       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW302.                                        
       DATE-WRITTEN.   03/26/99.                                        
       DATE-COMPILED.                                                   
       AUTHOR.         CBSI                                             
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **               COMPLETE BUSINESS SOLUTIONS INC.              **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS        REASON                           **         
      **======      ========        =================================**         
      **                                                             **         
      ** 03/26/99     CBSI       DEVELOPMENT OF NEW EXTRACT PROGRAM  **         
      **                                                             **         
T22243** 08/21/00     CBSI       CHANGES MADE TO IMPLEMENT MULTI-    **         
T22243**              CHENNAI    COMPANY IN METER INVENTORY.         **         
T30928** 04/19/06     JC91900    CHANGES FOR TRANSFORMER DEMAND LOAD **         
T30928**                         ING PROJECT.                        **         
T30928** 04/29/06     JC91900    SQL CLEAN UP AND TUNING.            **         
ACT002** 09/20/10     MC95456    SELECT KWH FROM TABLE AND APPEND    **         
ACT002**           A02778-ACT002 TO THE OUTPUT FILE.                 **         
A05136** 09/24/15     MC95456    REPLACE INPUT VSAM FILE WITH FLAT FILE         
A05460** 06/02/16     MR7E794    REPLACE THE DUPLICATE FIELD WS-B    **         
A05460**              ACT188     AND REMOVED THE UNUSED COPYBOOKS.   **         
      *****************************************************************         
      **                    PCSBW302   NARRATIVE                     **         
      **    EXTRACT DATA FOR DISTRIBUTION TRANSFORMER LOAD REPORT    **         
      **                                                             **         
      **  THE LEGACY REPORT OAS138 - PERCENT OF TRANSFORMER CAPACITY **         
      ** USED BY CUSTOMER IS REPLACED BY PCSBW302(EXTRACT DETAILS) & **         
      ** PCSBW303(ACCUMULATE % LOAD OF ALL THE ACCTS ON THE XFORMER)& *         
      ** PCSBW303 (REPORT DETAILS). PCSBW302 EXTRACTS TOTAL CUSTOMER **         
      ** ACTUAL DEMAND BY POINT ID AND DETERMINE THE PERCENT LOAD ON **         
      ** THE DISTRIBUTION TRANSFORMERS BASED ON THE TOTAL KVA FOR THE**         
      ** TRANSFORMERS ON THE OAS SYSTEM. PCSBW303 PROGRAM WILL TAKE  **         
      ** EXTRACTED DATA & ACCUMULATE THE %'S FOR THAT POINT ID AND   **         
      ** PCSBW304 WILL TAKE THE SORTED FILE, PRINT THE ACTUAL DEMAND **         
      ** FOR THE MONTH BY EACH CUSTOMER ASSOCIATED WITH THE          **         
      ** DISTRIBUTION TRANSFORMER.                                   **         
      ** SORT ORDER FOR BW304: DISTRICT-NO ASC, LOCAL-OFF ASC, TOTAL-**         
      ** PCT-LOAD DESC, POINT-ID ASC, ACCT-PCT-LOAD DESC, ACCT-NO ASC.*         
      *****************************************************************         
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBW302.                                                           
      *                                                                         
T30928     SELECT FCSB3021-FILE                                         
T30928         ASSIGN TO DA-FCSB3021                                    
T30928         FILE STATUS IS WS-FCSB3021-STATUS.                       
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBW302.                                                           
       COPY FIOBW302.                                                           
                                                                        
T30928 FD  FCSB3021-FILE                                                
T30928     BLOCK CONTAINS 0 RECORDS                                     
T30928     LABEL RECORDS ARE STANDARD.                                  
T30928 01  FCSB3021-RECORD.                                             
T30928     05 BW3021-KEY.                                               
T30928        10 BW3021-POINT-ID              PIC X(10).                
T30928        10 BW3021-KVA-CAPACITY          PIC X(09).                
T30928        10 BW3021-FILLER                PIC X(61).                
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW302'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SYS-DATE.                                                 
           05 WS-DT-YY                         PIC X(02).               
           05 WS-DT-MM                         PIC X(02).               
           05 WS-DT-DD                         PIC X(02).               
      *                                                                         
       01  WS-CUR-CCYY.                                                 
           05 WS-CUR-CC                        PIC 9(02).               
           05 WS-CUR-YY                        PIC 9(02).               
      *                                                                         
       01  WS-EXT-DATE.                                                 
           05 WS-EXT-CCYY                      PIC X(04).               
           05 FILLER                           PIC X(01)  VALUE '-'.    
           05 WS-EXT-MM                        PIC X(02).               
           05 FILLER                           PIC X(01)  VALUE '-'.    
           05 WS-EXT-DD                        PIC X(02).               
      *                                                                         
       01  WS-WORK-AREA.                                                
           05 WS-ACCOUNT-NO                    PIC S9(13) COMP-3        
                                                          VALUE ZEROES. 
           05 WS-FCSBW302-CNTR                 PIC S9(7) COMP-3 VALUE 0.
           05 WS-PARM-REVENUE-MONTH.                                    
               10 WS-PARM-REV-YEAR             PIC 9(04).               
               10 WS-PARM-REV-MONTH            PIC 9(02).               
           05  WS-PARM-REV-MONTH-PACKED REDEFINES                       
                 WS-PARM-REVENUE-MONTH         PIC 9(06).               
A05136     05  WS-RECS-PROCESSED               PIC 9(09) VALUE ZEROS.   
                                                                        
A05136 01  WS-POINT-ID-TABLE.                                           
A05136     05  WS-PID-MAX                      PIC S9(7) COMP-3 VALUE 0.
A05136     05  WS-POINT-ID-TB                                           
A05136         OCCURS 0 TO 300000 TIMES DEPENDING ON WS-PID-MAX         
A05136         ASCENDING KEY WS-TB-POINT-ID                             
A05136         INDEXED BY WS-I.                                         
A05136         10  WS-TB-POINT-ID              PIC X(10).               
A05136         10  WS-TB-KVA-CAPACITY          PIC X(09).               
A05136         10  WS-TB-FILLER                PIC X(61).               
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-DEMAND-FOUND-FLAG            PIC X(01)  VALUE 'N'.    
           05  WS-DEM-CNSLDTN-CD               PIC X(01)  VALUE ' '.    
               88  COINCIDENTAL-PEAKS                     VALUE 'B'.    
               88  SUMMED-PEAKS                           VALUE 'A'.    
           05  WS-USED-85-PF-FLAG              PIC X(01)  VALUE ' '.    
               88  USED-85-PF                             VALUE 'Y'.    
               88  NOT-USED-85-PF                         VALUE 'N'.    
           05  WS-FBW302-STATUS                PIC XX     VALUE '00'.   
               88  FBW302-SUCCESSFUL                      VALUE '00'.   
           05  WS-SELECT-DEMAND-FLAG           PIC X(01)  VALUE 'N'.    
               88  SELECT-DEMAND                          VALUE 'Y'.    
           05  WS-VALID-PREMISE                PIC X(01)  VALUE 'N'.    
               88  VALID-PREMISE                          VALUE 'Y'.    
A05136     05  WS-END-OF-FILE                  PIC X(01)  VALUE 'N'.    
A05136         88 END-OF-FILE                             VALUE 'Y'.    
T30928     05  WS-CHECK-FOR-BG                 PIC X(01)  VALUE 'N'.    
T30928         88 BG-RECORD-EXISTS                        VALUE 'Y'.    
T30928         88 BG-RECORD-NOT-EXISTS                    VALUE 'N'.    
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-A                             PIC X(01)  VALUE 'A'.    
           05 WS-E                             PIC X(01)  VALUE 'E'.    
           05 WS-J                             PIC X(01)  VALUE 'J'.    
           05 WS-M                             PIC X(01)  VALUE 'M'.    
           05 WS-N                             PIC X(01)  VALUE 'N'.    
           05 WS-S                             PIC X(01)  VALUE 'S'.    
           05 WS-Y                             PIC X(01)  VALUE 'Y'.    
T22243     05 WS-01                            PIC X(02)  VALUE '01'.   
      *                                                                         
       01  WS-VARIABLES.                                                
COB305     05 WS-KVA        PIC S9(09) COMP-3 VALUE 0.       
COB305     05 WS-ON-PEAK-KVA        PIC S9(09) COMP-3 VALUE 0.       
COB305     05 WS-OFF-PEAK-KVA        PIC S9(09) COMP-3 VALUE 0.       
COB305     05 WS-SHOULDER-KVA        PIC S9(09) COMP-3 VALUE 0.       
COB305     05 WS-KW        PIC S9(09) COMP-3 VALUE 0.       
COB305     05 WS-ON-PEAK-KW        PIC S9(09) COMP-3 VALUE 0.       
COB305     05 WS-OFF-PEAK-KW        PIC S9(09) COMP-3 VALUE 0.       
COB305     05 WS-SHOULDER-KW        PIC S9(09) COMP-3 VALUE 0.       
COB305     05 WS-TOTAL-KVA        PIC S9(10) COMP-3 VALUE 0.       
COB305     05 WS-TOTAL-KW        PIC S9(10) COMP-3 VALUE 0.       
COB305     05 WS-TOTAL-KWH        PIC S9(09) COMP-3 VALUE 0.       
A02778     05 WS-NULL-IND                      PIC S9(04) COMP.         
ACT002     05 WS-NO-OF-DAYS                    PIC S9(04) COMP.         
COB305     05 WS-PCT-LOAD-ON-XFMR        PIC S9(09)V99 COMP-3 VALUE 0.    
           05 WS-PREV-MTR-REF-NO               PIC S9(04) COMP.         
T30928     05 WS-PREV-POINT-ID                 PIC S9(9) USAGE COMP.    
           05 WS-CODE-USAGE-TYPE               PIC X(01).               
T30928     05 WS-RPT-POINT-ID                  PIC X(09).               
           05 WS-RPT-MTR-NO                    PIC X(09).               
           05 WS-PGRMNAME                      PIC X(08)  VALUE         
              'PCSBW302'.                                               
           05 WS-811                           PIC S9(04) COMP VALUE    
              -811.                                                     
T30928     05 WS-POINT-ID                      PIC X(10)                
T30928                                               JUSTIFIED RIGHT.   
T30928     05 WS-FCSB3021-STATUS               PIC X(02) VALUE '00'.    
A05136        88  FBW3021-SUCCESSFUL                     VALUE '00'.    
COB305     05 WS-TOTAL-KVA-CAPACITY        PIC S9(5)V USAGE COMP-3 
COB305       VALUE 0. 
T30928     05  WS-NO-MORE-BG-SW                PIC X(01)  VALUE 'N'.    
      *                                                                         
T22243 01  WS-SYSIN-COMP-NO                    PIC X(02) VALUE SPACES.  
       01  WS-INDICATOR-VARIABLES.                                      
           05 WS-TOTAL-KVA-NM-NULL             PIC S9(04) COMP.         
      *                                                                         
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
      *                                                                         
       COPY CWS00038.                                                   PCS01000
       COPY CWS00114.                                                   PCS01000
      *                                                                 PCS01010
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_EQUIPMENT                                                        
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBEQUIP                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_ACCOUNT                                                          
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT                                                     
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_MTRD_ENVRNMT                                                     
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBMTRENV                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_BILLING_DET                                                      
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBBLLDET                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CNSMPTN_HIST                                                     
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCNSMP                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_JOB_PARM                                                         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_REGISTER_READ                                                    
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBRGREAD                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_BILL_CONTRACT                                                    
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBBLCNTR                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_LOCAL_OFFICE                                                     
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      *                                                                         
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
                                                                        
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO SELECT UNIQUE PREMISE_NO FROM EQ      **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
           DECLARE GET_MAIN CURSOR WITH HOLD FOR                        
            SELECT DISTINCT(CRNT_LOC_NO)                                
              FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                          
             WHERE CODE_UTIL_TYPE = :WS-E                               
T22243         AND  COMPANY_NO    = :EQ-COMPANY-NO                      
               AND CODE_CRNT_LOC  = :WS-J                               
               AND DEVICE_NO IN                                         
                       ( SELECT EM.METER_NO                             
                           FROM CSS_ELEC_METER EM WITH(READUNCOMMITTED)         
                               ,CSS_MTR_CAP    MC WITH(READUNCOMMITTED)         
                          WHERE EM.CODE_UTIL_TYPE = :WS-E               
T22243                      AND EM.COMPANY_NO    = :EQ-COMPANY-NO       
T22243                      AND EM.COMPANY_NO    =  MC.COMPANY_NO       
                            AND MC.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE   
                            AND EM.METER_NO       = MC.METER_NO         
ACT188                      AND MC.CODE_CAP_TYPE IN ('B', :WS-E) )      
            ORDER BY CRNT_LOC_NO                                        
T30928      FOR READ ONLY                                       
A02778                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE GET_MAIN CURSOR WITH HOLD FOR                                
MFA-TR*     SELECT DISTINCT(CRNT_LOC_NO)                                        
MFA-TR*       FROM CSS_EQUIPMENT                                                
MFA-TR*      WHERE CODE_UTIL_TYPE = :WS-E                                       
MFA-TR*        AND  COMPANY_NO    = :EQ-COMPANY-NO                              
MFA-TR*        AND CODE_CRNT_LOC  = :WS-J                                       
MFA-TR*        AND DEVICE_NO IN                                                 
MFA-TR*                ( SELECT EM.METER_NO                                     
MFA-TR*                    FROM CSS_ELEC_METER EM                               
MFA-TR*                        ,CSS_MTR_CAP    MC                               
MFA-TR*                   WHERE EM.CODE_UTIL_TYPE = :WS-E                       
MFA-TR*                     AND EM.COMPANY_NO    = :EQ-COMPANY-NO               
MFA-TR*                     AND EM.COMPANY_NO    =  MC.COMPANY_NO               
MFA-TR*                     AND MC.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE           
MFA-TR*                     AND EM.METER_NO       = MC.METER_NO                 
MFA-TR*                     AND MC.CODE_CAP_TYPE IN ('B', :WS-E) )              
MFA-TR*     ORDER BY CRNT_LOC_NO                                                
MFA-TR*     FOR FETCH ONLY WITH UR                                              
MFA-TR*     QUERYNO 7000                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                 01092001
      ******************************************************************        
      * CURSOR FOR GETTING IC_NO FROM CSS_UTIL_ENVRNMT                 *        
      ******************************************************************        
      *                                                                 01092001
           EXEC SQL                                                     
           DECLARE IC_CURSOR CURSOR FOR                                 
            SELECT UT.IC_NO                                             
                  ,UT.RATE_PLAN_NO                                      
                  ,MN.MTR_REF_NO                                        
              FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                    
TEMP1             ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                    
             WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO               
    2          AND MN.ACCOUNT_NO         = UT.ACCOUNT_NO                
               AND UT.CODE_UTIL_TYPE     = :WS-E                        
    3          AND MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE            
    4          AND UT.IC_NO              = MN.IC_NO                     
    5          AND MN.MTR_READ_SOURCE_CD <> :WS-M                       
T30928      FOR READ ONLY                                       
A02778                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE IC_CURSOR CURSOR FOR                                         
MFA-TR*     SELECT UT.IC_NO                                                     
MFA-TR*           ,UT.RATE_PLAN_NO                                              
MFA-TR*           ,MN.MTR_REF_NO                                                
MFA-TR*       FROM CSS_UTIL_ENVRNMT UT                                          
MFA-TR*           ,CSS_MTRD_ENVRNMT MN                                          
MFA-TR*      WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO                       
MFA-TR*        AND MN.ACCOUNT_NO         = UT.ACCOUNT_NO                        
MFA-TR*        AND UT.CODE_UTIL_TYPE     = :WS-E                                
MFA-TR*        AND MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE                    
MFA-TR*        AND UT.IC_NO              = MN.IC_NO                             
MFA-TR*        AND MN.MTR_READ_SOURCE_CD <> :WS-M                               
MFA-TR*     FOR FETCH ONLY WITH UR                                              
MFA-TR*     QUERYNO 7050                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                 01092001
      ******************************************************************        
      * CURSOR FOR GETTING DETAILS FROM CSS_CNSMPTN_HIST & MN                   
      ******************************************************************        
      *                                                                 01092001
           EXEC SQL                                                     
A02778     DECLARE  CNSMPTN_CURSOR CURSOR FOR                           
            SELECT  MN.METER_NO                                         
                   ,CX.NO_DEMAND_UNITS                                  
                   ,CX.CODE_TIME_PERIOD                                 
                   ,CX.REG_ID_NO                                        
                   ,CX.CODE_USAGE_TYPE                                  
                   ,CX.CODE_TOU_SEASN                                   
ACT002             ,CX.NO_DAYS                                          
T30928             ,MN.GIS_POINT_ID                                     
                   ,MN.MTR_REF_NO                                       
              FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                    
                  ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                    
             WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO               
               AND CX.CODE_UTIL_TYPE     = :WS-E                        
               AND CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
               AND CX.BILL_NO            = :CX-BILL-NO                  
               AND CX.IC_NO              = :CX-IC-NO                    
               AND MN.ACCOUNT_NO         = CX.ACCOUNT_NO                
               AND MN.CODE_UTIL_TYPE     = CX.CODE_UTIL_TYPE            
               AND MN.IC_NO              = CX.IC_NO                     
               AND MN.MTR_REF_NO         = CX.MTR_REF_NO                
               AND MN.MTR_REF_NO         = :MN-MTR-REF-NO               
               AND CX.CODE_USAGE_TYPE    = :WS-CODE-USAGE-TYPE          
               AND CX.NO_DEMAND_UNITS    =                              
                  (SELECT MAX(C1.NO_DEMAND_UNITS)                       
                     FROM CSS_CNSMPTN_HIST C1 WITH(READUNCOMMITTED)             
                    WHERE C1.ACCOUNT_NO         = :CX-ACCOUNT-NO        
                      AND C1.CODE_UTIL_TYPE     = :WS-E                 
                      AND C1.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )
                      AND C1.BILL_NO            = :CX-BILL-NO           
                      AND C1.IC_NO              = :CX-IC-NO             
                      AND C1.CODE_USAGE_TYPE    = :WS-CODE-USAGE-TYPE   
                      AND C1.MTR_REF_NO         = CX.MTR_REF_NO         
                      AND C1.MTR_REF_NO         = :MN-MTR-REF-NO )      
T30928     ORDER BY MN.GIS_POINT_ID, MN.MTR_REF_NO, MN.METER_NO         
T30928     FOR READ ONLY                                        
A02778                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE  CNSMPTN_CURSOR CURSOR FOR                                   
MFA-TR*     SELECT  MN.METER_NO                                                 
MFA-TR*            ,CX.NO_DEMAND_UNITS                                          
MFA-TR*            ,CX.CODE_TIME_PERIOD                                         
MFA-TR*            ,CX.REG_ID_NO                                                
MFA-TR*            ,CX.CODE_USAGE_TYPE                                          
MFA-TR*            ,CX.CODE_TOU_SEASN                                           
MFA-TR*            ,CX.NO_DAYS                                                  
MFA-TR*            ,MN.GIS_POINT_ID                                             
MFA-TR*            ,MN.MTR_REF_NO                                               
MFA-TR*       FROM CSS_CNSMPTN_HIST CX                                          
MFA-TR*           ,CSS_MTRD_ENVRNMT MN                                          
MFA-TR*      WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*        AND CX.CODE_UTIL_TYPE     = :WS-E                                
MFA-TR*        AND CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*        AND CX.BILL_NO            = :CX-BILL-NO                          
MFA-TR*        AND CX.IC_NO              = :CX-IC-NO                            
MFA-TR*        AND MN.ACCOUNT_NO         = CX.ACCOUNT_NO                        
MFA-TR*        AND MN.CODE_UTIL_TYPE     = CX.CODE_UTIL_TYPE                    
MFA-TR*        AND MN.IC_NO              = CX.IC_NO                             
MFA-TR*        AND MN.MTR_REF_NO         = CX.MTR_REF_NO                        
MFA-TR*        AND MN.MTR_REF_NO         = :MN-MTR-REF-NO                       
MFA-TR*        AND CX.CODE_USAGE_TYPE    = :WS-CODE-USAGE-TYPE                  
MFA-TR*        AND CX.NO_DEMAND_UNITS    =                                      
MFA-TR*           (SELECT MAX(C1.NO_DEMAND_UNITS)                               
MFA-TR*              FROM CSS_CNSMPTN_HIST C1                                   
MFA-TR*             WHERE C1.ACCOUNT_NO         = :CX-ACCOUNT-NO                
MFA-TR*               AND C1.CODE_UTIL_TYPE     = :WS-E                         
MFA-TR*               AND C1.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP        
MFA-TR*               AND C1.BILL_NO            = :CX-BILL-NO                   
MFA-TR*               AND C1.IC_NO              = :CX-IC-NO                     
MFA-TR*               AND C1.CODE_USAGE_TYPE    = :WS-CODE-USAGE-TYPE           
MFA-TR*               AND C1.MTR_REF_NO         = CX.MTR_REF_NO                 
MFA-TR*               AND C1.MTR_REF_NO         = :MN-MTR-REF-NO )              
MFA-TR*    ORDER BY MN.GIS_POINT_ID, MN.MTR_REF_NO, MN.METER_NO                 
MFA-TR*    FOR FETCH ONLY WITH UR                                               
MFA-TR*    QUERYNO 7200                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                 01092001
      ******************************************************************        
      * CURSOR FOR CHECKING USAGE                                      *        
      ******************************************************************        
      *                                                                 01092001
           EXEC SQL                                                     
           DECLARE METER_CURSOR CURSOR FOR                              
T30928      SELECT MN.GIS_POINT_ID                                      
                  ,MN.METER_NO                                          
                  ,MN.MTR_REF_NO                                        
              FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                    
             WHERE MN.ACCOUNT_NO          = :MN-ACCOUNT-NO              
               AND MN.CODE_UTIL_TYPE      = :WS-E                       
               AND MN.IC_NO               = :MN-IC-NO                   
               AND MN.MTR_REF_NO          = :MN-MTR-REF-NO              
TEMP1          AND MN.MTR_READ_SOURCE_CD <> :WS-M                       
    2          AND ( MN.CODE_USAGE_SOURCE = :WS-S                       
                OR   MN.METER_NO IN                                     
                     ( SELECT RG.METER_NO                               
                         FROM CSS_REGISTER_READ RG WITH(READUNCOMMITTED)        
                        WHERE RG.ACCOUNT_NO      = :RG-ACCOUNT-NO       
                          AND RG.CODE_UTIL_TYPE  = :WS-E                
                          AND RG.IC_NO           = :RG-IC-NO            
                          AND RG.MTR_REF_NO      = MN.MTR_REF_NO        
                          AND RG.CODE_USAGE_TYPE IN (:WS-E, :WS-J) ))   
T30928       ORDER BY MN.GIS_POINT_ID, MN.MTR_REF_NO, MN.METER_NO       
T30928       FOR READ ONLY                                      
A02778                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE METER_CURSOR CURSOR FOR                                      
MFA-TR*     SELECT MN.GIS_POINT_ID                                              
MFA-TR*           ,MN.METER_NO                                                  
MFA-TR*           ,MN.MTR_REF_NO                                                
MFA-TR*       FROM CSS_MTRD_ENVRNMT MN                                          
MFA-TR*      WHERE MN.ACCOUNT_NO          = :MN-ACCOUNT-NO                      
MFA-TR*        AND MN.CODE_UTIL_TYPE      = :WS-E                               
MFA-TR*        AND MN.IC_NO               = :MN-IC-NO                           
MFA-TR*        AND MN.MTR_REF_NO          = :MN-MTR-REF-NO                      
MFA-TR*        AND MN.MTR_READ_SOURCE_CD <> :WS-M                               
MFA-TR*        AND ( MN.CODE_USAGE_SOURCE = :WS-S                               
MFA-TR*         OR   MN.METER_NO IN                                             
MFA-TR*              ( SELECT RG.METER_NO                                       
MFA-TR*                  FROM CSS_REGISTER_READ RG                              
MFA-TR*                 WHERE RG.ACCOUNT_NO      = :RG-ACCOUNT-NO               
MFA-TR*                   AND RG.CODE_UTIL_TYPE  = :WS-E                        
MFA-TR*                   AND RG.IC_NO           = :RG-IC-NO                    
MFA-TR*                   AND RG.MTR_REF_NO      = MN.MTR_REF_NO                
MFA-TR*                   AND RG.CODE_USAGE_TYPE IN (:WS-E, :WS-J) ))           
MFA-TR*      ORDER BY MN.GIS_POINT_ID, MN.MTR_REF_NO, MN.METER_NO               
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                 01092001
T30928*****************************************************************         
T30928* GET BILL NUMBER INCLUDING CANCEL REBILLS.                     *         
T30928*****************************************************************         
T30928     EXEC SQL                                                     
T30928        DECLARE BG_BILL CURSOR FOR                                
T30928          SELECT BG.BILL_NO                                       
T30928                ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                            
T30928            FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
T30928           WHERE BG.ACCOUNT_NO          = :BG-ACCOUNT-NO          
T30928             AND BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE      
T30928             AND BG.IC_NO               = :BG-IC-NO               
T30928             AND BG.CODE_BILL_ITM_TYPE  = 'C'                     
T30928             AND BG.CODE_BILL_ITM_IND   = 'A'                     
T30928             AND BG.REVENUE_MONTH       > 0                       
T30928             AND ((BG.REV_MTH_ORIG_BILL = 0                       
T30928                 AND BG.REVENUE_MONTH = :BG-REVENUE-MONTH)        
T30928                  OR BG.REV_MTH_ORIG_BILL = :BG-REV-MTH-ORIG-BILL)
T30928          ORDER BY BG.BILL_NO DESC                                
T30928          FOR READ ONLY                                   
A02778                                                      
T30928     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BG_BILL CURSOR FOR                                        
MFA-TR*         SELECT BG.BILL_NO                                               
MFA-TR*               ,BG.BILL_ITEM_TIMESTMP                                    
MFA-TR*           FROM CSS_BILLING_DET BG                                       
MFA-TR*          WHERE BG.ACCOUNT_NO          = :BG-ACCOUNT-NO                  
MFA-TR*            AND BG.CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE              
MFA-TR*            AND BG.IC_NO               = :BG-IC-NO                       
MFA-TR*            AND BG.CODE_BILL_ITM_TYPE  = 'C'                             
MFA-TR*            AND BG.CODE_BILL_ITM_IND   = 'A'                             
MFA-TR*            AND BG.REVENUE_MONTH       > 0                               
MFA-TR*            AND ((BG.REV_MTH_ORIG_BILL = 0                               
MFA-TR*                AND BG.REVENUE_MONTH = :BG-REVENUE-MONTH)                
MFA-TR*                 OR BG.REV_MTH_ORIG_BILL = :BG-REV-MTH-ORIG-BILL)        
MFA-TR*         ORDER BY BG.BILL_NO DESC                                        
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                 01092001
       PROCEDURE DIVISION.                                              

SCA006        SET WS-I TO 1.
      *                                                                         
      ******************************************************************        
      * MAIN PROCESS                                                   *01092001
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALISATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 1000-PROCESS-INPUT THRU 1000-EXIT.                   
      *                                                                         
           PERFORM 5110-WRITE-END-CONTROLS THRU 5110-EXIT.              
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  OPENS OUTPUT FCSBW302 FILE. AND GETS THE EXTRACT REVENUE MONTH*        
      *  FROM CSS_JOB_PARM: IF AN ACTIVE RECORD EXISTS ON JOB_PARM FOR *        
      *  THE PROGRAM, IT'S USED OTHERWISE, 'REPORTDATE' RECORD IS USED.*        
      ******************************************************************        
       0100-INITIALISATION.                                             
      *                                                                         
           ACCEPT   WS-SYS-DATE FROM DATE.                              
      *                                                                         
           IF  WS-DT-YY > 50                                            
               MOVE '19'                       TO WS-CUR-CC             
           ELSE                                                         
               MOVE '20'                       TO WS-CUR-CC             
           END-IF.                                                      
      *                                                                         
           MOVE WS-DT-MM                       TO WS-EXT-MM.            
           MOVE WS-DT-YY                       TO WS-CUR-YY.            
           MOVE WS-CUR-CCYY                    TO WS-EXT-CCYY.          
           MOVE WS-DT-DD                       TO WS-EXT-DD.            
      *                                                                         
T22243     ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
T22243     IF  WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES              
T22243         MOVE WS-01              TO WS-SYSIN-COMP-NO              
T22243     END-IF.                                                      
T22243*                                                                         
T22243     MOVE WS-SYSIN-COMP-NO       TO EQ-COMPANY-NO                 
T22243     DISPLAY '*********************************'                  
T22243     DISPLAY '* JOB IS RUNNING FOR COMPANY = ', EQ-COMPANY-NO     
T22243     DISPLAY '*********************************'                  
T22243*                                                                         
           OPEN OUTPUT FCSBW302-FILE.                                   
      *                                                                         
           IF  FBW302-SUCCESSFUL                                        
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FILE OPEN ERROR'                                
               DISPLAY 'FCSBW302 FILE STATUS ==>' WS-FBW302-STATUS      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
T30928     OPEN INPUT FCSB3021-FILE.                                    
T30928     IF WS-FCSB3021-STATUS NOT = '00' AND '97'                    
T30928         DISPLAY 'FCSB3021 OPEN ERROR--STATUS IS: '               
T30928             WS-FCSB3021-STATUS UPON SYSOUT                       
T30928         MOVE 12                       TO RETURN-CODE             
T30928         PERFORM 9900-ABEND              THRU 9900-EXIT           
A05136     ELSE                                                         
A05136         PERFORM 0150-LOAD-TABLE         THRU 0150-EXIT           
A05136     END-IF.                                                      
                                                                        
           MOVE ZEROS                          TO WS-FCSBW302-CNTR,     
                                                  WS-TOTAL-KVA,         
                                                  WS-TOTAL-KW,          
                                                  WS-KVA,               
                                                  WS-ON-PEAK-KVA,       
                                                  WS-OFF-PEAK-KVA,      
                                                  WS-SHOULDER-KVA,      
                                                  WS-KW,                
                                                  WS-ON-PEAK-KW,        
                                                  WS-OFF-PEAK-KW,       
                                                  WS-SHOULDER-KW,       
A02778                                            WS-TOTAL-KWH.         
      *                                                                         
           PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
      *                                                                         
           IF  END-OF-SYSIPT                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7611-CLOSE          THRU 7611-EXIT               
           END-IF.                                                      
      *                                                                         
           MOVE WS-PARM-YR                     TO WS-PARM-REV-YEAR.     
           MOVE WS-PARM-MONTH                  TO WS-PARM-REV-MONTH.    
      *                                                                         
T30928     IF COMMON-DATE-NEEDED                                        
T30928       SUBTRACT 1 FROM WS-PARM-REV-MONTH                          
T30928       IF WS-PARM-REV-MONTH EQUAL ZEROES                          
T30928          MOVE 12                      TO WS-PARM-REV-MONTH       
T30928          SUBTRACT 1 FROM WS-PARM-REV-YEAR                        
T30928       END-IF                                                     
T30928     END-IF                                                       
      *                                                                         
T30928     DISPLAY ' REVENUE MONTH USED  : ' WS-PARM-REV-MONTH-PACKED   
      *                                                                         
           MOVE WS-PARM-REV-MONTH-PACKED       TO BG-REVENUE-MONTH      
T30928                                        BG-REV-MTH-ORIG-BILL      
                                            E-FBW302-RUN-REV-MONTH.     
      *                                                                         
           PERFORM 5100-WRITE-BEGIN-CONTROLS THRU 5100-EXIT.            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A05136******************************************************************        
A05136*0150-LOAD-TABLE.                                                         
A05136******************************************************************        
A05136 0150-LOAD-TABLE.                                                 
                                                                        
A05136      MOVE +1  TO WS-PID-MAX                                      
A05136      PERFORM 7100-READ-POINT-ID-FILE   THRU 7100-EXIT            
A05136      PERFORM UNTIL END-OF-FILE                                   
A05136         MOVE  BW3021-POINT-ID       TO WS-TB-POINT-ID(WS-PID-MAX)
A05136         MOVE  BW3021-KVA-CAPACITY   TO                           
A05136                                    WS-TB-KVA-CAPACITY(WS-PID-MAX)
A05136         ADD   +1   TO WS-PID-MAX                                 
A05136         PERFORM 7100-READ-POINT-ID-FILE THRU 7100-EXIT           
A05136      END-PERFORM.                                                
                                                                        
A05136 0150-EXIT.                                                       
A05136      EXIT.                                                       
      ******************************************************************        
      * PASSES CONTROL TO OPEN,FETCH AND CLOSE THE  GET_MAIN CURSOR   **        
      * AND PROCESSES DATA UNTIL SQLCODE IS 100                       **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7000-OPEN-GET-MAIN-CURSOR   THRU 7000-EXIT.          
           PERFORM 7010-FETCH-GET-MAIN-CURSOR  THRU 7010-EXIT.          
      *                                                                         
           PERFORM 1100-PROCESS-IC-CURSOR THRU 1100-EXIT                
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
      *                                                                         
           PERFORM 7020-CLOSE-GET-MAIN-CURSOR  THRU 7020-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PASSES CONTROL TO OPEN,FETCH AND CLOSE THE IC_CURSOR CURSOR   **        
      * AND PROCESSES DATA UNTIL SQLCODE IS 100                       **        
      ******************************************************************        
       1100-PROCESS-IC-CURSOR.                                          
      *                                                                         
           MOVE EQ-CRNT-LOC-NO             TO WS-CPD99-PREMISE-NO       
                                              AT-PREMISE-NO.            
           MOVE WS-N                       TO WS-VALID-PREMISE.         
           PERFORM 7025-VALIDATE-PREMISE THRU 7025-EXIT.                
           IF  VALID-PREMISE                                            
               CONTINUE                                                 
           ELSE                                                         
               PERFORM 7010-FETCH-GET-MAIN-CURSOR THRU 7010-EXIT        
               GO TO 1100-EXIT                                          
           END-IF.                                                      
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
           MOVE WS-CPD99-ACCOUNT-NO        TO AT-ACCOUNT-NO             
                                              BK-ACCOUNT-NO             
                                              UT-ACCOUNT-NO             
                                              RG-ACCOUNT-NO             
                                              MN-ACCOUNT-NO             
                                              CX-ACCOUNT-NO             
                                              BG-ACCOUNT-NO.            
      *                                                                         
           PERFORM 7050-OPEN-IC-CURSOR THRU 7050-EXIT.                  
           PERFORM 7060-FETCH-IC-CURSOR THRU 7060-EXIT.                 
      *                                                                         
           PERFORM 1200-PROCESS-BK-BG THRU 1200-EXIT                    
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
      *                                                                         
           PERFORM 7070-CLOSE-IC-CURSOR THRU 7070-EXIT.                 
      *                                                                         
A05136     ADD +1                       TO WS-RECS-PROCESSED            
A05136     IF WS-RECS-PROCESSED  = 2000                                 
A05136          EXEC SQL                                                
A05136             COMMIT                                               
A05136          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05136          INITIALIZE WS-RECS-PROCESSED                            
A05136     END-IF.                                                      
      *                                                                         
           PERFORM 7010-FETCH-GET-MAIN-CURSOR THRU 7010-EXIT.           
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECKS FOR ORIGINAL/LATEST REBILL OF THE BG FOR THE EXTRACT   **        
      * REVENUE MONTH. CPD00166 COPYBOOK IS USED.                     **        
      ******************************************************************        
       1200-PROCESS-BK-BG.                                              
      *                                                                         
           MOVE WS-E                       TO BG-CODE-UTIL-TYPE.        
           MOVE UT-IC-NO                   TO BK-IC-NO                  
                                              RG-IC-NO                  
                                              MN-IC-NO                  
                                              CX-IC-NO                  
                                              BG-IC-NO.                 
      *                                                                         
           MOVE WS-PARM-REV-MONTH-PACKED   TO BG-REVENUE-MONTH.         
           MOVE WS-N                       TO WS-NO-MORE-BG-SW          
                                              WS-DEMAND-FOUND-FLAG.     
           MOVE ZEROS                      TO WS-PREV-MTR-REF-NO.       
T30928     MOVE ZEROS                      TO WS-PREV-POINT-ID.         
      *                                                                         
TEMP       SET SUMMED-PEAKS                TO TRUE                      
      *                                                                         
           SET BG-RECORD-NOT-EXISTS            TO TRUE.                 
T30928     PERFORM 7110-OPEN-BG-BILL-CURSOR  THRU 7110-EXIT.            
T30928     PERFORM 7120-FETCH-BG-BILL-CURSOR THRU 7120-EXIT.            
      *                                                                         
           PERFORM UNTIL WS-NO-MORE-BG-SW = 'Y' OR                      
                               WS-DEMAND-FOUND-FLAG = 'Y'               
               SET BG-RECORD-EXISTS             TO TRUE                 
               PERFORM 1210-PROCESS-DEMAND THRU 1210-EXIT               
               IF  WS-DEMAND-FOUND-FLAG = 'Y'                           
ACT002             ADD CX-NO-DAYS                 TO WS-NO-OF-DAYS      
                   PERFORM 2100-ACCUMULATE-DEMAND THRU 2100-EXIT        
A02778             PERFORM 7500-SELECT-KWH        THRU 7500-EXIT        
                   PERFORM 2300-WRITE-FIOBW302 THRU 2300-EXIT           
               ELSE                                                     
T30928             PERFORM 7120-FETCH-BG-BILL-CURSOR THRU 7120-EXIT     
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
T30928     PERFORM 7130-CLOSE-BG-BILL-CURSOR THRU 7130-EXIT.            
      *                                                                         
           IF  WS-DEMAND-FOUND-FLAG EQUAL WS-N                          
               PERFORM 2200-WRITE-ZERO-DEMAND THRU 2200-EXIT            
           END-IF.                                                      
           PERFORM 7060-FETCH-IC-CURSOR THRU 7060-EXIT.                 
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * IF BG EXISTS, THEN TRIES GET THE DEMAND DETAILS FROM CX FOR   **        
      * THAT PARTICULAR BILL.                                         **        
      ******************************************************************        
       1210-PROCESS-DEMAND.                                             
      *                                                                         
           IF  BG-RECORD-NOT-EXISTS                                     
               GO TO 1210-EXIT                                          
           END-IF.                                                      
      *                                                                         
           MOVE BG-BILL-ITEM-TIMESTMP      TO CX-BILL-ITEM-TIMESTMP.    
           MOVE BG-BILL-NO                 TO CX-BILL-NO.               
           MOVE WS-E                       TO WS-CODE-USAGE-TYPE.       
      *                                                                         
           PERFORM 7200-OPEN-CNSMPTN-CURSOR     THRU 7200-EXIT.         
           PERFORM 7210-FETCH-CNSMPTN-CURSOR    THRU 7210-EXIT.         
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               PERFORM 7220-CLOSE-CNSMPTN-CURSOR   THRU 7220-EXIT       
               MOVE WS-J                   TO WS-CODE-USAGE-TYPE        
               PERFORM 7200-OPEN-CNSMPTN-CURSOR     THRU 7200-EXIT      
               PERFORM 7210-FETCH-CNSMPTN-CURSOR    THRU 7210-EXIT      
               PERFORM 2000-PROCESS-DETAILS  THRU 2000-EXIT             
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
           ELSE                                                         
               PERFORM 2000-PROCESS-DETAILS  THRU 2000-EXIT             
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
           END-IF.                                                      
      *                                                                         
           PERFORM 7220-CLOSE-CNSMPTN-CURSOR   THRU 7220-EXIT.          
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * IF DEMAND DETAILS FOUND, ACCUMULATES OR WRITES EACH RECORD TO **        
      * EXTRACT FILE.                                                 **        
      ******************************************************************        
       2000-PROCESS-DETAILS.                                            
      *                                                                         
           MOVE WS-Y                       TO WS-DEMAND-FOUND-FLAG.     
           IF  MN-MTR-REF-NO NOT EQUAL WS-PREV-MTR-REF-NO               
                 AND WS-PREV-MTR-REF-NO NOT EQUAL ZEROS                 
ACT002             ADD CX-NO-DAYS                 TO WS-NO-OF-DAYS      
                   PERFORM 2100-ACCUMULATE-DEMAND THRU 2100-EXIT        
A02778             PERFORM 7500-SELECT-KWH        THRU 7500-EXIT        
                   PERFORM 2300-WRITE-FIOBW302 THRU 2300-EXIT           
           END-IF.                                                      
      *                                                                         
           IF  MN-MTR-REF-NO NOT EQUAL WS-PREV-MTR-REF-NO               
               MOVE MN-MTR-REF-NO          TO WS-PREV-MTR-REF-NO        
               MOVE MN-METER-NO            TO WS-RPT-MTR-NO             
               SET SELECT-DEMAND           TO TRUE                      
           END-IF.                                                      
T30928     IF  MN-GIS-POINT-ID NOT EQUAL WS-PREV-POINT-ID               
T30928         MOVE MN-GIS-POINT-ID         TO WS-PREV-POINT-ID         
                                               WS-RPT-POINT-ID          
               IF  SELECT-DEMAND                                        
                   CONTINUE                                             
               ELSE                                                     
                   SET SELECT-DEMAND           TO TRUE                  
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF  SELECT-DEMAND                                            
               PERFORM 2110-SELECT-DEMAND THRU 2110-EXIT                
               MOVE WS-N                   TO WS-SELECT-DEMAND-FLAG     
           END-IF.                                                      
           PERFORM 7210-FETCH-CNSMPTN-CURSOR    THRU 7210-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DEMAND IS ACCUMULATED FOR EACH ACCOUNT/METER COMBINATION.     **        
      ******************************************************************        
       2100-ACCUMULATE-DEMAND.                                          
      *                                                                         
           COMPUTE WS-TOTAL-KVA  = WS-TOTAL-KVA + WS-KVA +              
                   WS-ON-PEAK-KVA + WS-OFF-PEAK-KVA + WS-SHOULDER-KVA.  
           COMPUTE WS-TOTAL-KW   = WS-TOTAL-KW + WS-KW +                
                   WS-ON-PEAK-KW + WS-OFF-PEAK-KW + WS-SHOULDER-KW.     
      *                                                                         
           MOVE 0 TO  WS-KVA,                                           
                      WS-ON-PEAK-KVA,                                   
                      WS-OFF-PEAK-KVA,                                  
                      WS-SHOULDER-KVA,                                  
                      WS-KW,                                            
                      WS-ON-PEAK-KW,                                    
                      WS-OFF-PEAK-KW,                                   
                      WS-SHOULDER-KW.                                   
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * MODULE TO CHECK CONSUMPTION TYPE                              **        
      ******************************************************************        
       2110-SELECT-DEMAND.                                              
      *                                                                         
           IF  CX-CODE-USAGE-TYPE EQUAL WS-E                            
               EVALUATE CX-CODE-TIME-PERIOD                             
                  WHEN 0                                                
                     MOVE CX-NO-DEMAND-UNITS   TO WS-KVA                
                  WHEN 1                                                
                     MOVE CX-NO-DEMAND-UNITS   TO WS-ON-PEAK-KVA        
                  WHEN 2                                                
                     MOVE CX-NO-DEMAND-UNITS   TO WS-OFF-PEAK-KVA       
                  WHEN 3                                                
                     MOVE CX-NO-DEMAND-UNITS   TO WS-SHOULDER-KVA       
               END-EVALUATE                                             
           ELSE                                                         
               EVALUATE CX-CODE-TIME-PERIOD                             
                  WHEN 0                                                
                     MOVE CX-NO-DEMAND-UNITS   TO WS-KW                 
                  WHEN 1                                                
                     MOVE CX-NO-DEMAND-UNITS   TO WS-ON-PEAK-KW         
                  WHEN 2                                                
                     MOVE CX-NO-DEMAND-UNITS   TO WS-OFF-PEAK-KW        
                  WHEN 3                                                
                     MOVE CX-NO-DEMAND-UNITS   TO WS-SHOULDER-KW        
               END-EVALUATE                                             
               GO TO 2110-EXIT                                          
           END-IF.                                                      
      *                                                                         
           MOVE MN-MTR-REF-NO                  TO CX-MTR-REF-NO.        
           MOVE MN-METER-NO                    TO CX-METER-NO.          
           PERFORM 7225-SELECT-ASSOC-KW        THRU 7225-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                EVALUATE CX-CODE-TIME-PERIOD                            
                   WHEN 0                                               
                      MOVE CX-NO-DEMAND-UNITS  TO WS-KW                 
                   WHEN 1                                               
                      MOVE CX-NO-DEMAND-UNITS  TO WS-ON-PEAK-KW         
                   WHEN 2                                               
                      MOVE CX-NO-DEMAND-UNITS  TO WS-OFF-PEAK-KW        
                   WHEN 3                                               
                      MOVE CX-NO-DEMAND-UNITS  TO WS-SHOULDER-KW        
                END-EVALUATE                                            
           END-IF.                                                      
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * IF BG/CX DOES NOT EXIST, WRITES ACCOUNT/TRANSFORMER DETAILS TO**        
      * EXTRACT FILE.                                                 **        
      ******************************************************************        
       2200-WRITE-ZERO-DEMAND.                                          
      *                                                                         
           PERFORM 7250-OPEN-METER-CURSOR      THRU 7250-EXIT.          
           PERFORM 7260-FETCH-METER-CURSOR     THRU 7260-EXIT.          
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               MOVE MN-METER-NO            TO WS-RPT-MTR-NO             
               MOVE MN-GIS-POINT-ID        TO WS-RPT-POINT-ID           
               PERFORM 2300-WRITE-FIOBW302 THRU 2300-EXIT               
               PERFORM 7260-FETCH-METER-CURSOR THRU 7260-EXIT           
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7270-CLOSE-METER-CURSOR     THRU 7270-EXIT.          
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GETS THE DETAILS FROM OAS-POINT AND WRITES INTO FCSBW302 FILE.**        
      ******************************************************************        
       2300-WRITE-FIOBW302.                                             
      *                                                                         
           MOVE UT-ACCOUNT-NO              TO E-FBW302-ACCOUNT-NO.      
           MOVE UT-RATE-PLAN-NO            TO E-FBW302-RATE-PLAN-NO.    
T30928     MOVE SPACES                     TO WS-POINT-ID.              
T30928     MOVE WS-RPT-POINT-ID            TO WS-POINT-ID.              
T30928     INSPECT WS-POINT-ID REPLACING LEADING SPACES BY '0'.         
T30928     MOVE WS-POINT-ID                TO BW3021-POINT-ID.          
T30928                                                                  
A05136     PERFORM 7300-SEARCH-KVA-NM    THRU 7300-EXIT                 
                                                                        
           PERFORM 7350-SELECT-ACCOUNT THRU 7350-EXIT                   
           MOVE AT-LOCAL-OFFICE        TO E-FBW302-LOCAL-OFFICE         
      *                                                                         
           MOVE E-FBW302-LOCAL-OFFICE      TO B1-LOCAL-OFFICE.          
           PERFORM 7360-GET-DISTRICT-NO THRU 7360-EXIT.                 
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE B1-DISTRICT-NO         TO E-FBW302-DISTRICT-NO      
           ELSE                                                         
               MOVE SPACES                 TO E-FBW302-DISTRICT-NO      
           END-IF.                                                      
      *                                                                         
           IF  WS-TOTAL-KW > 0 AND WS-TOTAL-KVA = 0                     
               SET USED-85-PF              TO TRUE                      
               COMPUTE WS-TOTAL-KVA ROUNDED = WS-TOTAL-KW / 0.85        
           ELSE                                                         
               SET NOT-USED-85-PF          TO TRUE                      
           END-IF.                                                      
      *                                                                         
           MOVE WS-USED-85-PF-FLAG         TO E-FBW302-USED-85-PF-FLAG. 
                                                                        
T30928     IF  WS-TOTAL-KVA-CAPACITY > 0                                
T30928         COMPUTE WS-PCT-LOAD-ON-XFMR =                            
T30928                (WS-TOTAL-KVA * 100.00) / WS-TOTAL-KVA-CAPACITY   
T30928     ELSE                                                         
T30928         COMPUTE WS-PCT-LOAD-ON-XFMR = +9999                      
T30928     END-IF.                                                      
                                                                        
           IF  WS-PCT-LOAD-ON-XFMR > +9999                              
               MOVE +9999                  TO                           
                                          E-FBW302-PCT-LOAD-ON-XFORMER  
           ELSE                                                         
               COMPUTE E-FBW302-PCT-LOAD-ON-XFORMER ROUNDED             
                           = WS-PCT-LOAD-ON-XFMR                        
           END-IF.                                                      
      *                                                                         
           MOVE WS-RPT-MTR-NO              TO E-FBW302-METER-NO         
           MOVE WS-TOTAL-KVA               TO E-FBW302-TOTAL-KVA.       
           MOVE WS-TOTAL-KW                TO E-FBW302-TOTAL-KW.        
A02778     MOVE WS-TOTAL-KWH               TO E-FBW302-TOTAL-KWH.       
           MOVE ZEROS                      TO                           
                                            E-FBW302-TOT-PCT-LD-ON-XFMR.
ACT002     MOVE WS-NO-OF-DAYS              TO E-FBW302-NO-OF-DAYS.      
      *                                                                         
           ADD +1                          TO WS-FCSBW302-CNTR.         
           PERFORM 8930-WRITE-FCSBW302 THRU 8930-EXIT.                  
           MOVE ZEROS                      TO WS-TOTAL-KVA              
                                              WS-TOTAL-KW               
A02778                                        WS-TOTAL-KWH              
ACT002                                        WS-NO-OF-DAYS.            
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * WRITE HEADER RECORD                                           **        
      ******************************************************************        
       5100-WRITE-BEGIN-CONTROLS.                                       
           MOVE LOW-VALUES        TO E-FBW302-KEY-BREC.                 
           MOVE WS-EXT-DATE       TO E-FBW302-CREATE-DATE-BREC          
           PERFORM 8930-WRITE-FCSBW302 THRU 8930-EXIT.                  
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * WRITE TRAILER RECORD                                          **        
      ******************************************************************        
       5110-WRITE-END-CONTROLS.                                         
           MOVE HIGH-VALUES      TO E-FBW302-KEY-EREC.                  
           MOVE WS-FCSBW302-CNTR TO E-FBW302-REC-COUNT-EREC.            
           PERFORM 8930-WRITE-FCSBW302 THRU 8930-EXIT.                  
       5110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **********************************************************                
      **6200-GET-PARAMETER-DATE                             **                  
      **********************************************************                
           EXEC SQL                                                             
                 INCLUDE CPD00114                                               
           END-EXEC.                                                            
      ********************************************************                  
      * JOB_PARM INCLUDES FOR DATE ACCESS                                       
      ********************************************************                  
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************43111000
      * 6990-FETCH-CUR-ACCOUNT                                         *42840000
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *31300000
      ******************************************************************43111000
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************43111000
      * 6995-CPD99-ERROR-ROUTINE                                       *42840000
      * MODULE TO DISPLAY ANY SQL ERRORS FROM COPYBOOK CPD00099        *31300000
      ******************************************************************43111000
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           DISPLAY '********** PCSBW302 ABORT ************'.            
           DISPLAY '* ERROR IN PARA ' ACTIVE-PARAGRAPH.                 
           DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO.              
           DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE.              
           DISPLAY '* PROGRAM ABENDING...                *'.            
           DISPLAY '********** PCSBW302 ABORT ************'.            
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  DB2 CALLS                                                   **        
      ******************************************************************        
       7000-OPEN-GET-MAIN-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN GET_MAIN                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7000-OPEN-GET-MAIN-CURSOR          *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
T22243         DISPLAY '* COMPANY NO : ', EQ-COMPANY-NO                 
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCHES CRNT-LOC-NO FROM CSS_EQUIPMENT                         *        
      ******************************************************************        
       7010-FETCH-GET-MAIN-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH  GET_MAIN                                           
               INTO :EQ-CRNT-LOC-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7010-FETCH-GET-MAIN-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
T22243         DISPLAY '* COMPANY NO :',EQ-COMPANY-NO                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES GET_MAIN CURSOR                                                  
      ******************************************************************        
       7020-CLOSE-GET-MAIN-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_MAIN                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7020-CLOSE-GET-MAIN-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
T22243         DISPLAY '* COMPANY NO :',EQ-COMPANY-NO                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECK WHETHER PREMISE-NO IS A VALID ONE                        *        
      ******************************************************************        
       7025-VALIDATE-PREMISE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-VALID-PREMISE                                  
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :AT-PREMISE-NO                        
A02778                                                           
A02778                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-VALID-PREMISE                                          
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE PREMISE_NO = :AT-PREMISE-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7025                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                                                  OR WS-811             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7025-VALIDATE-PREMISE              *'         
               DISPLAY '* ACCOUNT_NO = ', AT-PREMISE-NO                 
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THESE PARAGRAPHS ARE TO FETCH DETAILS FROM IC_CURSOR        **        
      ******************************************************************        
       7050-OPEN-IC-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN IC_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* OPEN ERROR -  7050-OPEN-IC-CURSOR  *'         
               DISPLAY '* ACCOUNT_NO = ', UT-ACCOUNT-NO                 
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7060-FETCH-IC-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               FETCH IC_CURSOR                                          
                INTO :UT-IC-NO                                          
                    ,:UT-RATE-PLAN-NO                                   
                    ,:MN-MTR-REF-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* FETCH ERROR - 7060-FETCH-IC-CURSOR *'         
               DISPLAY '* ACCOUNT_NO = ', UT-ACCOUNT-NO                 
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7070-CLOSE-IC-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE IC_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE  SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* CLOSE ERROR - 7070-CLOSE-IC-CURSOR *'         
               DISPLAY '* ACCOUNT_NO = ', UT-ACCOUNT-NO                 
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A05136******************************************************************        
A05136* 7100-READ-POINT-ID-FILE.                                       *        
A05136******************************************************************        
A05136 7100-READ-POINT-ID-FILE.                                         
A05136*                                                                         
A05136         READ FCSB3021-FILE                                       
A05136              AT END                                              
A05136              MOVE WS-Y       TO WS-END-OF-FILE                   
A05136         END-READ                                                 
A05136         IF NOT FBW3021-SUCCESSFUL                                
A05136            IF END-OF-FILE                                        
A05136               CONTINUE                                           
A05136            ELSE                                                  
A05136               DISPLAY '**    PCSBW302 PROCESSING ERROR     **'   
A05136               DISPLAY '**   FCSB3021-FILE READ PROBLEM     **'   
A05136               DISPLAY '**   PARA - 7100-READ-POINT-ID-FILE **'   
A05136               DISPLAY '**      PROCESSING TERMINATED       **'   
A05136               PERFORM 9900-ABEND          THRU 9900-EXIT         
A05136         END-IF
               END-IF.                                                  
                                                                        
A05136 7100-EXIT.                                                       
A05136      EXIT.                                                       
T30928*****************************************************************         
T30928*                                                               *         
T30928* 7110-OPEN-BG-BILL-CURSOR.                                     *         
T30928*****************************************************************         
T30928 7110-OPEN-BG-BILL-CURSOR.                                        
T30928     EXEC SQL                                                     
T30928        OPEN BG_BILL                                              
T30928     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T30928                                                                  
T30928     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T30928                                                                  
T30928     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T30928         CONTINUE                                                 
T30928     ELSE                                                         
T30928         DISPLAY '*********** PCSBW302 ABORT *************'       
T30928         DISPLAY '*       7110-OPEN-BG-BILL-CURSOR       *'       
T30928         DISPLAY '* ACCOUNT_NO : ' BG-ACCOUNT-NO                  
T30928         DISPLAY '* CODE UTIL  : ' BG-CODE-UTIL-TYPE              
T30928         DISPLAY '* IC_NO      : ' BG-IC-NO                       
T30928         DISPLAY '* REV MONTH  : ' BG-REVENUE-MONTH               
T30928         DISPLAY '* SQLCODE IS : ' WS-ACTIVE-RETURN-CODE          
T30928         DISPLAY '* PROGRAM ABORTING...                  *'       
T30928         DISPLAY '*********** PCSBW302 ABORT *************'       
T30928         PERFORM 9900-ABEND              THRU 9900-EXIT           
T30928     END-IF.                                                      
T30928                                                                  
T30928 7110-EXIT.                                                       
T30928     EXIT.                                                        
T30928                                                                  
T30928*****************************************************************         
T30928*                                                               *         
T30928* 7120-FETCH-BG-BILL-CURSOR.                                    *         
T30928*****************************************************************         
T30928 7120-FETCH-BG-BILL-CURSOR.                                       
T30928     EXEC SQL                                                     
T30928        FETCH BG_BILL                                             
T30928         INTO :BG-BILL-NO                                         
T30928             ,:BG-BILL-ITEM-TIMESTMP                              
T30928     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T30928                                                                  
T30928     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T30928                                                                  
T30928     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T30928        IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
T30928          MOVE 'Y'                    TO WS-NO-MORE-BG-SW         
T30928        END-IF                                                    
T30928     ELSE                                                         
T30928         DISPLAY '*********** PCSBW302 ABORT *************'       
T30928         DISPLAY '*      7120-FETCH-BG-BILL-CURSOR       *'       
T30928         DISPLAY '* ACCOUNT_NO : ' BG-ACCOUNT-NO                  
T30928         DISPLAY '* CODE UTIL  : ' BG-CODE-UTIL-TYPE              
T30928         DISPLAY '* IC_NO      : ' BG-IC-NO                       
T30928         DISPLAY '* REV MONTH  : ' BG-REVENUE-MONTH               
T30928         DISPLAY '* SQLCODE IS : ' WS-ACTIVE-RETURN-CODE          
T30928         DISPLAY '* PROGRAM ABORTING...                  *'       
T30928         DISPLAY '*********** PCSBW302 ABORT *************'       
T30928         PERFORM 9900-ABEND              THRU 9900-EXIT           
T30928     END-IF.                                                      
T30928                                                                  
T30928 7120-EXIT.                                                       
T30928     EXIT.                                                        
T30928                                                                  
T30928*****************************************************************         
T30928*                                                               *         
T30928* 7130-CLOSE-BG-BILL-CURSOR.                                    *         
T30928*****************************************************************         
T30928 7130-CLOSE-BG-BILL-CURSOR.                                       
T30928     EXEC SQL                                                     
T30928        CLOSE BG_BILL                                             
T30928     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T30928                                                                  
T30928     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T30928                                                                  
T30928     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T30928         CONTINUE                                                 
T30928     ELSE                                                         
T30928         DISPLAY '*********** PCSBW302 ABORT *************'       
T30928         DISPLAY '*      7130-CLOSE-BG-BILL-CURSOR       *'       
T30928         DISPLAY '* ACCOUNT_NO : ' BG-ACCOUNT-NO                  
T30928         DISPLAY '* CODE UTIL  : ' BG-CODE-UTIL-TYPE              
T30928         DISPLAY '* IC_NO      : ' BG-IC-NO                       
T30928         DISPLAY '* REV MONTH  : ' BG-REVENUE-MONTH               
T30928         DISPLAY '* SQLCODE IS : ' WS-ACTIVE-RETURN-CODE          
T30928         DISPLAY '* PROGRAM ABORTING...                  *'       
T30928         DISPLAY '*********** PCSBW302 ABORT *************'       
T30928         PERFORM 9900-ABEND              THRU 9900-EXIT           
T30928     END-IF.                                                      
T30928                                                                  
T30928 7130-EXIT.                                                       
T30928     EXIT.                                                        
                                                                        
      ******************************************************************        
A02778* OPENS CNSMPTN_CURSOR CURSOR                                             
      ******************************************************************        
A02778 7200-OPEN-CNSMPTN-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN CNSMPTN_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7200-OPEN-CNSMPTN-CURSOR           *'         
               DISPLAY '* ACCOUNT_NO = ', CX-ACCOUNT-NO                 
               DISPLAY '* BILL_NO    = ', CX-BILL-NO                    
               DISPLAY '* IC_NO      = ', CX-IC-NO                      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCH CNSMPTN_CURSOR CURSOR                                             
      ******************************************************************        
       7210-FETCH-CNSMPTN-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH   CNSMPTN_CURSOR                                    
               INTO   :MN-METER-NO                                      
                     ,:CX-NO-DEMAND-UNITS                               
                     ,:CX-CODE-TIME-PERIOD                              
                     ,:CX-REG-ID-NO                                     
                     ,:CX-CODE-USAGE-TYPE                               
                     ,:CX-CODE-TOU-SEASN                                
ACT002               ,:CX-NO-DAYS                                       
T30928               ,:MN-GIS-POINT-ID                                  
                     ,:MN-MTR-REF-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7210-FETCH-CNSMPTN-CURSOR          *'         
               DISPLAY '* ACCOUNT_NO = ', CX-ACCOUNT-NO                 
               DISPLAY '* BILL_NO    = ', CX-BILL-NO                    
               DISPLAY '* IC_NO      = ', CX-IC-NO                      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES CNSMPTN_CURSOR   CURSOR                                          
      ******************************************************************        
       7220-CLOSE-CNSMPTN-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE CNSMPTN_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7220-CLOSE-CNSMPTN-CURSOR          *'         
               DISPLAY '* ACCOUNT_NO = ', CX-ACCOUNT-NO                 
               DISPLAY '* BILL_NO    = ', CX-BILL-NO                    
               DISPLAY '* IC_NO      = ', CX-IC-NO                      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECT THE ASSOCIATED KW (TO MAX KVA)                          *        
      ******************************************************************        
       7225-SELECT-ASSOC-KW.                                            
      *                                                                         
           EXEC SQL                                                     
            SELECT  CX.NO_DEMAND_UNITS                                  
              INTO :CX-NO-DEMAND-UNITS                                  
              FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                    
             WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO               
               AND CX.CODE_UTIL_TYPE     = :WS-E                        
               AND CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
               AND CX.BILL_NO            = :CX-BILL-NO                  
               AND CX.IC_NO              = :CX-IC-NO                    
               AND CX.CODE_USAGE_TYPE    = :WS-J                        
               AND CX.CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD         
               AND CX.MTR_REF_NO         = :CX-MTR-REF-NO               
               AND CX.REG_ID_NO          = :CX-REG-ID-NO                
               AND CX.METER_NO           = :CX-METER-NO                 
               AND CX.CODE_TOU_SEASN     = :CX-CODE-TOU-SEASN           
T30928                                                           
A02778                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  CX.NO_DEMAND_UNITS                                          
MFA-TR*       INTO :CX-NO-DEMAND-UNITS                                          
MFA-TR*       FROM CSS_CNSMPTN_HIST CX                                          
MFA-TR*      WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*        AND CX.CODE_UTIL_TYPE     = :WS-E                                
MFA-TR*        AND CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*        AND CX.BILL_NO            = :CX-BILL-NO                          
MFA-TR*        AND CX.IC_NO              = :CX-IC-NO                            
MFA-TR*        AND CX.CODE_USAGE_TYPE    = :WS-J                                
MFA-TR*        AND CX.CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD                 
MFA-TR*        AND CX.MTR_REF_NO         = :CX-MTR-REF-NO                       
MFA-TR*        AND CX.REG_ID_NO          = :CX-REG-ID-NO                        
MFA-TR*        AND CX.METER_NO           = :CX-METER-NO                         
MFA-TR*        AND CX.CODE_TOU_SEASN     = :CX-CODE-TOU-SEASN                   
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7225                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7225-SELECT-ASSOC-KW               *'         
               DISPLAY '* ACCOUNT_NO = ', CX-ACCOUNT-NO                 
               DISPLAY '* BILL_NO    = ', CX-BILL-NO                    
               DISPLAY '* IC_NO      = ', CX-IC-NO                      
               DISPLAY '* MTR_REF_NO = ', CX-MTR-REF-NO                 
               DISPLAY '* REG_ID_NO  = ', CX-REG-ID-NO                  
               DISPLAY '* METER_NO   = ', CX-METER-NO                   
               DISPLAY '* CODE_TIME_PERIOD = ', CX-CODE-TIME-PERIOD     
               DISPLAY '* CODE_TOU_SEASN   = ', CX-CODE-TOU-SEASN       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPENS METER_CURSOR                                                      
      ******************************************************************        
       7250-OPEN-METER-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
              OPEN METER_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7250-OPEN-METER-CURSOR           *'           
               DISPLAY '* ACCOUNT_NO = ', MN-ACCOUNT-NO                 
               DISPLAY '* IC_NO      = ', MN-IC-NO                      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCH METER_CURSOR                                                      
      ******************************************************************        
       7260-FETCH-METER-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
              FETCH   METER_CURSOR                                      
T30928         INTO   :MN-GIS-POINT-ID                                  
                     ,:MN-METER-NO                                      
                     ,:MN-MTR-REF-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7260-FETCH-METER-CURSOR            *'         
               DISPLAY '* ACCOUNT_NO = ', MN-ACCOUNT-NO                 
               DISPLAY '* IC_NO      = ', MN-IC-NO                      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES METER_CURSOR                                                     
      ******************************************************************        
       7270-CLOSE-METER-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
              CLOSE METER_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7270-CLOSE-METER-CURSOR            *'         
               DISPLAY '* ACCOUNT_NO = ', MN-ACCOUNT-NO                 
               DISPLAY '* IC_NO      = ', MN-IC-NO                      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T30928                                                                  
T30928*****************************************************************         
T30928*                                                               *         
A05136* 7300-SEARCH-KVA-NM.                                           *         
A05136*****************************************************************         
A05136 7300-SEARCH-KVA-NM.                                              
A05136                                                                  
A05136      SEARCH ALL WS-POINT-ID-TB                                   
A05136          AT END                                                  
A05136            MOVE BW3021-POINT-ID      TO E-FBW302-POINT-ID        
A05136            MOVE ZEROES               TO WS-TOTAL-KVA-CAPACITY    
A05136                                         E-FBW302-KVA-CAPACITY    
A05136          WHEN WS-TB-POINT-ID(WS-I) = BW3021-POINT-ID             
A05136            MOVE WS-TB-POINT-ID(WS-I) TO E-FBW302-POINT-ID        
A05136            MOVE WS-TB-KVA-CAPACITY(WS-I)                         
A05136                                      TO WS-TOTAL-KVA-CAPACITY    
A05136                                         E-FBW302-KVA-CAPACITY    
A05136      END-SEARCH.                                                 
T30928                                                                  
T30928 7300-EXIT.                                                       
T30928     EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET LOCAL_OFFICE FROM CSS_ACCOUNT, IF A RECORD NOT FOUND ON    *        
      * OAS-POINT TABLE OR IF IT IS SPACES ON OAS-POINT.               *        
      ******************************************************************        
       7350-SELECT-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE                                       
                INTO :AT-LOCAL-OFFICE                                   
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
T30928                                                           
A02778                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE                                               
MFA-TR*         INTO :AT-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7350-SELECT-ACCOUNT                *'         
               DISPLAY '* ACCOUNT_NO = ', AT-ACCOUNT-NO                 
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET DISTRICT-NO FROM CSS_LOCAL_OFFICE                          *        
      ******************************************************************        
       7360-GET-DISTRICT-NO.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT DISTRICT_NO                                        
                INTO :B1-DISTRICT-NO                                    
                FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
               WHERE COMPANY_NO   = '01'                                
                 AND LOCAL_OFFICE = :B1-LOCAL-OFFICE                    
T30928                                                           
A02778                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTRICT_NO                                                
MFA-TR*         INTO :B1-DISTRICT-NO                                            
MFA-TR*         FROM CSS_LOCAL_OFFICE                                           
MFA-TR*        WHERE COMPANY_NO   = '01'                                        
MFA-TR*          AND LOCAL_OFFICE = :B1-LOCAL-OFFICE                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW302 ABORT ************'         
               DISPLAY '* 7360-GET-DISTRICT-NO               *'         
               DISPLAY '* LOCAL_OFFICE = ', B1-LOCAL-OFFICE             
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW302 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A02778******************************************************************        
A02778*7500-SELECT-KWH.                                                         
A02778******************************************************************        
      *                                                                         
A02778 7500-SELECT-KWH.                                                 
      *                                                                         
A02778     EXEC SQL                                                     
A02778      SELECT SUM(CX.NO_UNITS)                                     
A02778        INTO :WS-TOTAL-KWH :WS-NULL-IND                            
A02778        FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                    
A02778       WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO               
A02778         AND CX.CODE_UTIL_TYPE     = :WS-E                        
A02778         AND CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
A02778         AND CX.BILL_NO            = :CX-BILL-NO                  
A02778         AND CX.IC_NO              = :CX-IC-NO                    
ACT188         AND CX.CODE_USAGE_TYPE    = 'B'                          
A02778         AND CX.MTR_REF_NO         = :CX-MTR-REF-NO               
A02778         AND CX.METER_NO           = :CX-METER-NO                 
A02778                                                           
A02778                                                      
A02778     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT SUM(CX.NO_UNITS)                                             
MFA-TR*       INTO :WS-TOTAL-KWH:WS-NULL-IND                                    
MFA-TR*       FROM CSS_CNSMPTN_HIST CX                                          
MFA-TR*      WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*        AND CX.CODE_UTIL_TYPE     = :WS-E                                
MFA-TR*        AND CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*        AND CX.BILL_NO            = :CX-BILL-NO                          
MFA-TR*        AND CX.IC_NO              = :CX-IC-NO                            
MFA-TR*        AND CX.CODE_USAGE_TYPE    = 'B'                                  
MFA-TR*        AND CX.MTR_REF_NO         = :CX-MTR-REF-NO                       
MFA-TR*        AND CX.METER_NO           = :CX-METER-NO                         
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A02778     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
A02778     IF WS-NULL-IND EQUAL -1                                      
A02778        MOVE ZEROS  TO  WS-TOTAL-KWH                              
A02778     END-IF.                                                      
      *                                                                         
A02778     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
A02778         CONTINUE                                                 
A02778     ELSE                                                         
A02778         DISPLAY '********** PCSBW302 ABORT ************'         
A02778         DISPLAY '* 7500-SELECT-KWH                    *'         
A02778         DISPLAY '* ACCOUNT_NO = ', CX-ACCOUNT-NO                 
A02778         DISPLAY '* BILL_NO    = ', CX-BILL-NO                    
A02778         DISPLAY '* IC_NO      = ', CX-IC-NO                      
A02778         DISPLAY '* MTR_REF_NO = ', CX-MTR-REF-NO                 
A02778         DISPLAY '* REG_ID_NO  = ', CX-REG-ID-NO                  
A02778         DISPLAY '* METER_NO   = ', CX-METER-NO                   
A02778         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A02778         DISPLAY '* PROGRAM ABORTING...                *'         
A02778         DISPLAY '********** PCSBW302 ABORT ************'         
A02778         PERFORM 9900-ABEND              THRU 9900-EXIT           
A02778     END-IF.                                                      
      *                                                                         
A02778 7500-EXIT.                                                       
A02778      EXIT.                                                       
      ******************************************************************        
      ******************************************************************        
      * WRITES FIOBW302 RECORD TO THE FILE AND INITIALIZES THE RECORD  *        
      ******************************************************************        
       8930-WRITE-FCSBW302.                                             
      *                                                                         
           WRITE FIOBW302.                                              
           IF FBW302-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8930-ERROR ON FCSBW302 WRITE '                  
               DISPLAY 'FCSBW302 FILE STATUE IS ==>' WS-FBW302-STATUS   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           MOVE SPACES TO FIOBW302.                                     
      *                                                                         
       8930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * CLOSE ALL FILES                                            *            
      **************************************************************            
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBW302-FILE.                                         
      *                                                                         
           IF  FBW302-SUCCESSFUL                                        
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FILE CLOSE ERROR'                               
               DISPLAY 'FCSBW302 FILE STATUS ==>' WS-FBW302-STATUS      
           END-IF.                                                      
                                                                        
T30928     CLOSE FCSB3021-FILE.                                         
T30928                                                                  
T30928     IF WS-FCSB3021-STATUS NOT = '00' AND '97'                    
T30928         DISPLAY 'FCSB3021 CLOSE ERROR--STATUS IS: '              
T30928             WS-FCSB3021-STATUS UPON SYSOUT                       
T30928         MOVE 12                       TO RETURN-CODE             
T30928     END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
