       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW301.                                        
       DATE-WRITTEN.   02/18/99.                                        
       DATE-COMPILED.                                                   
       AUTHOR.         CBSIMDS                                          
      ***************************************************************** 00060000
      **              SOUTH CAROLINA ELECTRICITY  & GAS              ** 00070000
      **           COMPLETE BUSINESS SOLUTIONS INC., MAD             ** 00080000
      **                                                             ** 00090000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00100000
      ********                   DB2                          ********* 00110000
      ***************************************************************** 00120000
      **                                                             ** 00130000
      **              PROGRAM  MODIFICATION  LOG                     ** 00140000
      **                                                             ** 00150000
      ** DATE       INITIALS        REASON                           ** 00160000
      **======      ========        =================================** 00170000
      **                                                             ** 00180000
      ** 02/18/99   CBSI, MDS    DEVELOPMENT OF  NEW REPORT PROGRAM  ** 00190000
      **                                                             ** 00200000
PCR700** 04/15/99   CBSI         PROGRAM CORRECTED TO REFLECT THE    ** 00210000
      **                         CHANGE IN COPYBOOK CPD00166 LOGIC.  ** 00220000
      **                                                             ** 00230000
T19591** 05/19/99   JDW          CHANGED PARAGRAPH 1105 TO EXCLUDE   ** 00240000
      **                         REPLACED METERS                     ** 00250000
      **                                                             ** 00260000
T22362** 07/27/00   SG18894      CHANGES MADE TO RUN THE PROGRAM FOR ** 00270000
      **                         PREVIOUS REVENUE MONTH.             ** 00280000
      **                                                             ** 00290000
T23978** 04/26/01   ESM          ADDED CODE FOR COMPANY BREAK.       ** 00291000
      **                                                             ** 00293000
C31044** 05/22/04   SG18894      CHANGES MADE TO IMPROVE THE RUN TIME** 00291000
C33884**                                                             ** 00293000
C33884** 09/11/06   NC94746      INCLUDED ITRON MOBILE AMR SOURCE    **         
C33884**                         BY ADDING CSS_MTR_RD_SOURCE TABLE   **         
C33884**                         WITH SEND_READ_REQ_FL = 'Y'         **         
      ***************************************************************** 00300000
      *                     PCSBW301   NARRATIVE                     ** 00310000
      *                     METER READ EXCEPTIONS                    ** 00320000
      *                                                              ** 00330000
      *   THIS PROGRAM LISTS ALL THE ACCOUNT NUMBERS WITH NUMBER OF  ** 00340000
      *  DAYS IS OUT OF BOUNDS (<28 0R >34)                          ** 00350000
      *                                                              ** 00360000
      ***************************************************************** 00370000
      *                                                                 00380000
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                 00470000
HPCCDM*EJECT                                                            00480000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00520000
       COPY CSSPT33.                                                    00530000
      *                                                                 00540000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00570000
       COPY CFDPT33.                                                    00580000
      *                                                                 00590000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW301'.
MSQ017     COPY MFASQLM.
      *                                                                 00610000
       01  WS-SYS-DATE.                                                 
           05 WS-DT-YY                         PIC X(02).               
           05 WS-DT-MM                         PIC X(02).               
           05 WS-DT-DD                         PIC X(02).               
      *                                                                 00660000
       01  WS-CUR-CCYY.                                                 
           05 WS-CUR-CC                        PIC 9(02).               
           05 WS-CUR-YY                        PIC 9(02).               
      *                                                                 00700000
       01  WS-RPT-DATE.                                                 
           05 WS-RPT-MM                        PIC X(02).               
           05 FILLER                           PIC X(01)  VALUE '/'.    
           05 WS-RPT-DD                        PIC X(02).               
           05 FILLER                           PIC X(01)  VALUE '/'.    
           05 WS-RPT-CCYY                      PIC X(04).               
      *                                                                 00770000
       01  WS-TIME.                                                     
           05 WS-TM-HH                         PIC X(02).               
           05 WS-TM-MM                         PIC X(02).               
           05 WS-TM-SS                         PIC X(02).               
      *                                                                 00820000
       01  WS-RPT-TIME.                                                 
           05 WS-RPT-HH                        PIC X(02).               
           05 FILLER                           PIC X(01)  VALUE ':'.    
           05 WS-RPT-MIN                       PIC X(02).               
           05 FILLER                           PIC X(01)  VALUE ':'.    
           05 WS-RPT-SS                        PIC X(02).               
      *                                                                 00890000
       01  WS-WORK-AREA.                                                
C31044     05 WS-TOTAL-DAYS                    PIC S9(04) COMP.         
           05 WS-ACCOUNT-NO                    PIC S9(13) COMP-3        
                                                          VALUE ZEROES. 
           05 WS-PARM-REVENUE-MONTH.                                    
               10 WS-PARM-REV-YEAR             PIC 9(04).               
               10 WS-PARM-REV-MONTH            PIC 9(02).               
           05  WS-PARM-REV-MONTH-PACKED REDEFINES                       
                 WS-PARM-REVENUE-MONTH         PIC 9(06).               
      *                                                                 00980000
       01  WS-RPT-TRAN-DATE.                                            
           05 WS-RT-CCYY                       PIC X(04).               
           05 WS-RT-MM                         PIC X(02).               
      *                                                                 01020000
       01  WS-LITERALS.                                                 
           05 WS-ONE                           PIC 9(01)  VALUE 1.      
           05 WS-TWO                           PIC 9(01)  VALUE 2.      
           05 WS-SIX                           PIC 9(01)  VALUE 6.      
           05 WS-FIFTY-SIX                     PIC 9(02)  VALUE 56.     
           05 WS-FIFTY-SEVEN                   PIC 9(02)  VALUE 57.     
      *                                                                 01090000
       01  WS-VARIABLES.                                                
           05 WS-LINE-CNTR                     PIC 9(02)  VALUE 57.     
           05 WS-PAGE                          PIC 9(04)  VALUE ZEROS.  
           05 WS-LINE-SPACE                    PIC 9(01)  VALUE ZERO.   
           05 WS-NO-REPORT                     PIC X(01)  VALUE 'Y'.    
           05 WS-PGRMNAME                      PIC X(08)  VALUE         
              'PCSBW301'.                                               
           05 WS-N                             PIC X(01)  VALUE 'N'.    
           05 WS-Y                             PIC X(01)  VALUE 'Y'.    
      *                                                                 01190000
       01  WS-INDICATOR-VARIABLES.                                      
           05 IV-CX-DATE-READ                  PIC S9(04) COMP.         
C31044     05 WS-TOTAL-DAYS-NULL               PIC S9(04) COMP.         
      *                                                                 01220000
       01  WS-HDR-ONE.                                                  
           05 FILLER                           PIC X(08)  VALUE         
              'PCSBW301'.                                               
           05 FILLER                           PIC X(38)  VALUE SPACES. 
T23978*    05 FILLER                           PIC X(39)  VALUE         01270000
T23978*       'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.                01280000
T23978     05 WS-HDR-ONE-TITLE                 PIC X(39)  VALUE SPACES. 
           05 FILLER                           PIC X(31)  VALUE SPACES. 
           05 FILLER                           PIC X(06)  VALUE         
              'PAGE: '.                                                 
           05 FILLER                           PIC X(05)  VALUE SPACES. 
           05 WS-DET-PAGE                      PIC ZZZZZ  VALUE SPACES. 
      *                                                                 01340000
       01  WS-HDR-TWO.                                                  
           05 FILLER                           PIC X(50)  VALUE SPACES. 
           05 FILLER                           PIC X(26)  VALUE         
              'METER READ EXCEPTIONS FOR '.                             
           05 WS-TRAN-DATE                     PIC X(06).               
           05 FILLER                           PIC X(30)  VALUE SPACES. 
           05 FILLER                           PIC X(10)  VALUE         
              'RUN DATE: '.                                             
           05 WS-RUN-DATE                      PIC X(10)  VALUE SPACES. 
      *                                                                 01440000
       01  WS-HDR-TIME.                                                 
           05 FILLER                           PIC X(112) VALUE SPACES. 
           05 FILLER                           PIC X(10)  VALUE         
              'RUN TIME: '.                                             
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 WS-RUN-TIME                      PIC X(08)  VALUE SPACES. 
      *                                                                 01510000
       01  WS-HDR-THREE.                                                
           05 FILLER                           PIC X(15)  VALUE         
              'LOCAL OFFICE : '.                                        
           05 WS-DET-LOC-OFF                   PIC X(03)  VALUE SPACES. 
           05 FILLER                           PIC X(03)  VALUE SPACES. 
           05 WS-DET-LOC-OFF-DESC              PIC X(22)  VALUE SPACES. 
           05 FILLER                           PIC X(89)  VALUE SPACES. 
      *                                                                 01590000
       01  WS-HDR-FOUR.                                                 
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 FILLER                           PIC X(04)  VALUE         
              'READ'.                                                   
           05 FILLER                           PIC X(90)  VALUE SPACES. 
           05 FILLER                           PIC X(04)  VALUE         
              'UTIL'.                                                   
           05 FILLER                           PIC X(12)  VALUE SPACES. 
           05 FILLER                           PIC X(15)  VALUE         
              'NUMBER OF'.                                              
           05 FILLER                           PIC X(01)  VALUE SPACES. 
      *                                                                 01710000
       01  WS-HDR-FIVE.                                                 
           05 FILLER                           PIC X(01)  VALUE SPACES. 
           05 FILLER                           PIC X(05)  VALUE         
              'CYCLE'.                                                  
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 FILLER                           PIC X(05)  VALUE         
              'ROUTE'.                                                  
           05 FILLER                           PIC X(03)  VALUE SPACES. 
           05 FILLER                           PIC X(14)  VALUE         
              'ACCOUNT NUMBER'.                                         
           05 FILLER                           PIC X(04)  VALUE SPACES. 
           05 FILLER                           PIC X(11)  VALUE         
              'READ SOURCE'.                                            
           05 FILLER                           PIC X(07)  VALUE SPACES. 
           05 FILLER                           PIC X(09)  VALUE         
              'READ CODE'.                                              
           05 FILLER                           PIC X(13)  VALUE SPACES. 
           05 FILLER                           PIC X(08)  VALUE         
              'RECYCLED'.                                               
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 FILLER                           PIC X(09)  VALUE         
              'READ DATE'.                                              
           05 FILLER                           PIC X(03)  VALUE SPACES. 
           05 FILLER                           PIC X(04)  VALUE         
              'TYPE'.                                                   
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 FILLER                           PIC X(08)  VALUE         
              'METER NO'.                                               
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 FILLER                           PIC X(15)  VALUE         
              'READ DAYS'.                                              
           05 FILLER                           PIC X(01)  VALUE SPACES. 
      *                                                                 02040000
       01  WS-DETAIL-LINE.                                              
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 WS-DET-READ-CYCLE                PIC X(02).               
           05 FILLER                           PIC X(04)  VALUE SPACES. 
           05 WS-DET-ROUTE                     PIC 9(04).               
           05 WS-DET-ROUTE-R REDEFINES WS-DET-ROUTE PIC X(04).          
           05 FILLER                           PIC X(03)  VALUE SPACES. 
           05 WS-DET-ACCOUNT-NO                PIC 9,9999,9999,9999.    
           05 WS-DET-ACCT-R  REDEFINES WS-DET-ACCOUNT-NO PIC X(16).     
           05 FILLER                           PIC X(03)  VALUE SPACES. 
           05 WS-DET-READ-SOURCE               PIC X(16).               
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 WS-DET-READ-CODE                 PIC X(22).               
           05 FILLER                           PIC X(04)  VALUE SPACES. 
           05 WS-DET-RECYCLED                  PIC X(01).               
           05 FILLER                           PIC X(05)  VALUE SPACES. 
           05 WS-DET-READ-DATE                 PIC X(10).               
           05 FILLER                           PIC X(03)  VALUE SPACES. 
           05 WS-DET-UTIL-TYPE                 PIC X(01).               
           05 FILLER                           PIC X(03)  VALUE SPACES. 
           05 WS-DET-MTR-NO                    PIC X(09).               
           05 FILLER                           PIC X(02)  VALUE SPACES. 
           05 WS-DET-READ-DAYS                 PIC Z(3)9.               
           05 FILLER                           PIC X(02)  VALUE SPACES. 
      *                                                                 02290000
       01  WS-LINE                             PIC X(132) VALUE ALL '-'.
      *                                                                 02310000
       01  WS-FOOT-LINE.                                                
           05 FILLER                           PIC X(55)  VALUE SPACES. 
           05 FILLER                           PIC X(22)  VALUE         
              '*** END OF  REPORT ***'.                                 
           05 FILLER                           PIC X(55)  VALUE SPACES. 
      *                                                                 02370000
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                           PIC X(54)  VALUE SPACES. 
           05 FILLER                           PIC X(24)  VALUE         
              '*** NO RECORDS FOUND ***'.                               
           05 FILLER                           PIC X(54)  VALUE SPACES. 
      *                                                                 02430000
T23978 01  WS-MISC.                                                     
T23978     05 WS-COMP-NO-HOLD                  PIC X(02)  VALUE SPACES. 
T23978     05 WS-COMPANY-NAME                  PIC X(26)  VALUE SPACES. 
T23978     05 WS-HEADER-TITLE.                                          
T23978        10 FILLER                        PIC X(08)  VALUE SPACES. 
T23978        10 WS-TITLE-COMP-NAME            PIC X(26)  VALUE SPACES. 
T23978        10 FILLER                        PIC X(05)  VALUE SPACES. 
T23978     05 WS-DEFAULT-HDR1-TITLE            PIC X(39)  VALUE         
T23978        'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.                
T23978*                                                                 02436000
       COPY FIOCA00.                                                    02440000
       COPY FIOJC01.                                                    02450000
      *                                                                 02460000
       COPY CWS00038.                                                   02470000
       COPY CWS00114.                                                   02480000
      *                                                                 02490000
      ***************************************************************** 02500000
      **      APPLICATION  TABLE DCLGENS                             ** 02510000
      ***************************************************************** 02520000
           EXEC SQL                                                     02530000
               INCLUDE SQLCA                                            02540000
           END-EXEC.                                                    02550000
      **                                                                02560000
      ***************************************************************** 02570000
      *    CSS_ACCOUNT                                                  02580000
      ***************************************************************** 02590000
           EXEC SQL                                                     02600000
             INCLUDE TBACCT                                             02610000
           END-EXEC.                                                    02620000
      *                                                                 02630000
      ***************************************************************** 02640000
      *    CSS_UTIL_ENVRNMT                                             02650000
      ***************************************************************** 02660000
           EXEC SQL                                                     02670000
             INCLUDE TBUTLENV                                           02680000
           END-EXEC.                                                    02690000
      *                                                                 02700000
      ***************************************************************** 02710000
      *    CSS_MTRD_ENVRNMT                                             02720000
      ***************************************************************** 02730000
           EXEC SQL                                                     02740000
             INCLUDE TBMTRENV                                           02750000
           END-EXEC.                                                    02760000
      *                                                                 02770000
      ***************************************************************** 02780000
      *    CSS_BILLING_DET                                              02790000
      ***************************************************************** 02800000
           EXEC SQL                                                     02810000
             INCLUDE TBBLLDET                                           02820000
           END-EXEC.                                                    02830000
      *                                                                 02840000
      ***************************************************************** 02850000
      *    CSS_CNSMPTN_HIST                                             02860000
      ***************************************************************** 02870000
           EXEC SQL                                                     02880000
             INCLUDE TBCNSMP                                            02890000
           END-EXEC.                                                    02900000
      *                                                                 02910000
      ***************************************************************** 02920000
      *    CSS_JOB_PARM                                                 02930000
      ***************************************************************** 02940000
           EXEC SQL                                                     02950000
             INCLUDE TBJBPARM                                           02960000
           END-EXEC.                                                    02970000
      *                                                                 02980000
      ***************************************************************** 02990000
      *    CSS_LOCAL_OFFICE                                             03000000
      ***************************************************************** 03010000
           EXEC SQL                                                     03020000
             INCLUDE TBLOCOFC                                           03030000
           END-EXEC.                                                    03040000
      *                                                                 03050000
      ***************************************************************** 03060000
           EXEC SQL                                                     03070000
               INCLUDE CWS00166                                         03080000
           END-EXEC.                                                    03090000
      ***************************************************************** 03100000
      *                                                                 03110000
       COPY CWS00303.                                                   03120000
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                03130000
                                                                        
      *  ABEND SWITCH COPYBOOK                                          03150000
       COPY CWS09900.                                                   03160000
      *                                                                 03170000
      * -- USED BY CPD0303B                                             03180000
      * WS ABEND WORK AREA                                              03190000
       COPY CWS00010.                                                   03200000
                                                                        
      *                                                                 03220000
      ***************************************************************** 03230000
      ** CURSOR DECLARATION TO SELECT ACCOUNT NO, CODE UTIL TYPE, IC NO 03240000
      ** READ ROUTE, READ CYCLE AND LOCAL OFFICE FROM THE JOIN OF THE   03250000
      ** TABLES CSS_ACCOUNT, CSS_UTIL_ENVRNMT, CSS_BILLING_DET AND      03260000
      ** CSS_CNSMPTN_HIST                                               03270000
      ***************************************************************** 03280000
      *                                                                 03290000
           EXEC SQL                                                     
           DECLARE  GET_MAIN CURSOR FOR                                 
            SELECT    BG.ACCOUNT_NO                                     
                     ,BG.CODE_UTIL_TYPE                                 
                     ,BG.IC_NO                                          
                     ,UT.READ_ROUTE                                     
                     ,UT.READ_CYCLE                                     
                     ,AT.LOCAL_OFFICE                                   
T23978               ,AT.COMPANY_NO                                     
                     ,MN.MTR_REF_NO                                     
                     ,BG.PRORATE_CD                                     
                     ,MN.METER_NO                                       
                     ,BG.BILL_NO                                        
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
              FROM    CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                 
                     ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                     ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
                     ,CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                 
C33884               ,CSS_MTR_RD_SOURCE  X7 WITH(READUNCOMMITTED)               
             WHERE    AT.ACCOUNT_NO         = UT.ACCOUNT_NO             
               AND    UT.ACCOUNT_NO         = MN.ACCOUNT_NO             
               AND    UT.PREMISE_NO         = AT.PREMISE_NO             
               AND    UT.IC_NO              = MN.IC_NO                  
               AND    UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE         
               AND    BG.ACCOUNT_NO         = UT.ACCOUNT_NO             
C33884         AND    MN.MTR_READ_SOURCE_CD = X7.MTR_READ_SOURCE_CD     
C33884         AND    X7.SEND_READ_REQ_FL   = 'Y'                       
               AND    AT.CODE_ACCT_STAT     = 'A'                       
C31044         AND    UT.CODE_UTIL_TYPE     IN ('E', 'G')               
C31044         AND    MN.CODE_METER_STATUS  IN ('A', 'B', 'I', 'J')     
               AND    BG.PRORATE_CD         NOT IN ('I', 'F')           
               AND    CIS.SUBSTR3(AT.CODES_DATA_PRESENT,2,1) = 'A'           
               AND    REV_MTH_LST_NRML      >= :AT-REV-MTH-LST-NRML     
               AND    BG.CODE_BILL_ITM_TYPE = 'C'                       
               AND    BG.CODE_BILL_ITM_IND  = 'A'                       
               AND  ((BG.REV_MTH_ORIG_BILL  = 0                         
               AND    BG.REVENUE_MONTH      = :BG-REVENUE-MONTH)        
                OR    BG.REV_MTH_ORIG_BILL  = :BG-REVENUE-MONTH)        
               AND    EXISTS ( SELECT '1'                               
              FROM    CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                 
             WHERE    AT.ACCOUNT_NO         = UT.ACCOUNT_NO             
               AND    CX.ACCOUNT_NO         = BG.ACCOUNT_NO             
               AND    MN.CODE_UTIL_TYPE     = BG.CODE_UTIL_TYPE         
               AND    CX.CODE_UTIL_TYPE     = BG.CODE_UTIL_TYPE         
               AND    CX.BILL_ITEM_TIMESTMP = BG.BILL_ITEM_TIMESTMP     
               AND    CX.BILL_NO            = BG.BILL_NO                
               AND    UT.IC_NO              = BG.IC_NO                  
               AND    CX.IC_NO              = BG.IC_NO                  
               AND    CX.MTR_REF_NO         = MN.MTR_REF_NO             
               AND    CX.REG_ID_NO          = 1                         
               AND    CX.CODE_TIME_PERIOD   = 0                         
               AND    CX.CODE_METER_READ    <> 'B'                      
               AND   (CX.NO_DAYS < 28                                   
                OR    CX.NO_DAYS > 34))                                 
T23978      ORDER BY AT.COMPANY_NO,                                     
T23978               AT.LOCAL_OFFICE,                                   
T23978               UT.READ_CYCLE,                                     
T23978               UT.READ_ROUTE                                      
                    ,BG.ACCOUNT_NO                                      
                    ,BG.CODE_UTIL_TYPE                                  
                    ,BG.IC_NO                                           
                    ,MN.MTR_REF_NO                                      
C33884           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03300000
MFA-TR*    DECLARE  GET_MAIN CURSOR FOR                                 03310000
MFA-TR*     SELECT    BG.ACCOUNT_NO                                     03320000
MFA-TR*              ,BG.CODE_UTIL_TYPE                                 03330000
MFA-TR*              ,BG.IC_NO                                          03340000
MFA-TR*              ,UT.READ_ROUTE                                     03350000
MFA-TR*              ,UT.READ_CYCLE                                     03360000
MFA-TR*              ,AT.LOCAL_OFFICE                                   03371000
MFA-TR*              ,AT.COMPANY_NO                                     03372002
MFA-TR*              ,MN.MTR_REF_NO                                     03380000
MFA-TR*              ,BG.PRORATE_CD                                     03531000
MFA-TR*              ,MN.METER_NO                                         035310
MFA-TR*              ,BG.BILL_NO                                          035350
MFA-TR*              ,BG.BILL_ITEM_TIMESTMP                               035350
MFA-TR*       FROM    CSS_ACCOUNT      AT                               03390000
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                               03400000
MFA-TR*              ,CSS_MTRD_ENVRNMT MN                               03410000
MFA-TR*              ,CSS_BILLING_DET  BG                               03540000
MFA-TR*              ,CSS_MTR_RD_SOURCE  X7                                     
MFA-TR*      WHERE    AT.ACCOUNT_NO         = UT.ACCOUNT_NO             03420000
MFA-TR*        AND    UT.ACCOUNT_NO         = MN.ACCOUNT_NO             03430000
MFA-TR*        AND    UT.PREMISE_NO         = AT.PREMISE_NO             03440000
MFA-TR*        AND    UT.IC_NO              = MN.IC_NO                  03450000
MFA-TR*        AND    UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE         03460000
MFA-TR*        AND    BG.ACCOUNT_NO         = UT.ACCOUNT_NO             03550000
MFA-TR*        AND    MN.MTR_READ_SOURCE_CD = X7.MTR_READ_SOURCE_CD             
MFA-TR*        AND    X7.SEND_READ_REQ_FL   = 'Y'                               
MFA-TR*        AND    AT.CODE_ACCT_STAT     = 'A'                       03470000
MFA-TR*        AND    UT.CODE_UTIL_TYPE     IN ('E', 'G')               03480000
MFA-TR*        AND    MN.CODE_METER_STATUS  IN ('A', 'B', 'I', 'J')     03490000
MFA-TR*        AND    BG.PRORATE_CD         NOT IN ('I', 'F')           04920000
MFA-TR*        AND    SUBSTR(AT.CODES_DATA_PRESENT,2,1) = 'A'           03500000
MFA-TR*        AND    REV_MTH_LST_NRML      >= :AT-REV-MTH-LST-NRML     03510000
MFA-TR*        AND    BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*        AND    BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*        AND  ((BG.REV_MTH_ORIG_BILL  = 0                                 
MFA-TR*        AND    BG.REVENUE_MONTH      = :BG-REVENUE-MONTH)                
MFA-TR*         OR    BG.REV_MTH_ORIG_BILL  = :BG-REVENUE-MONTH)                
MFA-TR*        AND    EXISTS ( SELECT '1'                               03610000
MFA-TR*       FROM    CSS_CNSMPTN_HIST CX                               03540000
MFA-TR*      WHERE    AT.ACCOUNT_NO         = UT.ACCOUNT_NO             03420000
MFA-TR*        AND    CX.ACCOUNT_NO         = BG.ACCOUNT_NO             03550000
MFA-TR*        AND    MN.CODE_UTIL_TYPE     = BG.CODE_UTIL_TYPE         03560000
MFA-TR*        AND    CX.CODE_UTIL_TYPE     = BG.CODE_UTIL_TYPE         03560000
MFA-TR*        AND    CX.BILL_ITEM_TIMESTMP = BG.BILL_ITEM_TIMESTMP     03570000
MFA-TR*        AND    CX.BILL_NO            = BG.BILL_NO                03580000
MFA-TR*        AND    UT.IC_NO              = BG.IC_NO                  03580000
MFA-TR*        AND    CX.IC_NO              = BG.IC_NO                  03580000
MFA-TR*        AND    CX.MTR_REF_NO         = MN.MTR_REF_NO             03600000
MFA-TR*        AND    CX.REG_ID_NO          = 1                         03610000
MFA-TR*        AND    CX.CODE_TIME_PERIOD   = 0                         03610000
MFA-TR*        AND    CX.CODE_METER_READ    <> 'B'                      05040000
MFA-TR*        AND   (CX.NO_DAYS < 28                                   05110000
MFA-TR*         OR    CX.NO_DAYS > 34))                                 05110000
MFA-TR*     ORDER BY AT.COMPANY_NO,                                     03521000
MFA-TR*              AT.LOCAL_OFFICE,                                   03522000
MFA-TR*              UT.READ_CYCLE,                                     03523000
MFA-TR*              UT.READ_ROUTE                                      03524000
MFA-TR*             ,BG.ACCOUNT_NO                                      03320000
MFA-TR*             ,BG.CODE_UTIL_TYPE                                  03330000
MFA-TR*             ,BG.IC_NO                                           03340000
MFA-TR*             ,MN.MTR_REF_NO                                      03380000
MFA-TR*          FOR FETCH ONLY WITH UR                                 03530000
MFA-TR*    END-EXEC.                                                    03530100
      *                                                                 03630200
      ******************************************************************03530300
      * CURSOR FOR GETTING DETAILS FROM CSS_CNSMPTN_HIST                03530400
      ******************************************************************03530500
      *                                                                 03530600
           EXEC SQL                                                     
           DECLARE  GET_CNSMPTN_DET CURSOR FOR                          
            SELECT  CX.ACCOUNT_NO                                       
                   ,CX.NO_DAYS                                          
                   ,CX.METER_NO                                         
                   ,CX.CODE_UTIL_TYPE                                   
                   ,CX.IC_NO                                            
                   ,CX.BILL_NO                                          
                   ,CX.CODE_METER_READ                                  
                   ,CX.CODE_SOURCE_ID                                   
                   ,CX.ITEM_SEQ_NO                                      
                   ,CX.DATE_READ                                        
              FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                    
             WHERE CX.ACCOUNT_NO         = :BG-ACCOUNT-NO               
               AND CX.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE           
               AND CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
               AND CX.BILL_NO            = :BG-BILL-NO                  
               AND CX.IC_NO              = :BG-IC-NO                    
               AND CX.MTR_REF_NO         = :MN-MTR-REF-NO               
               AND CX.REG_ID_NO          = 1                            
               AND CX.CODE_TIME_PERIOD   = 0                            
           ORDER BY ITEM_SEQ_NO                                         
C33884          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03530700
MFA-TR*    DECLARE  GET_CNSMPTN_DET CURSOR FOR                          03530800
MFA-TR*     SELECT  CX.ACCOUNT_NO                                       03530900
MFA-TR*            ,CX.NO_DAYS                                          03531000
MFA-TR*            ,CX.METER_NO                                         03532000
MFA-TR*            ,CX.CODE_UTIL_TYPE                                   03533000
MFA-TR*            ,CX.IC_NO                                            03534000
MFA-TR*            ,CX.BILL_NO                                          03535000
MFA-TR*            ,CX.CODE_METER_READ                                  03536000
MFA-TR*            ,CX.CODE_SOURCE_ID                                   03537000
MFA-TR*            ,CX.ITEM_SEQ_NO                                      03538000
MFA-TR*            ,CX.DATE_READ                                        03539000
MFA-TR*       FROM CSS_CNSMPTN_HIST CX                                  03540000
MFA-TR*      WHERE CX.ACCOUNT_NO         = :BG-ACCOUNT-NO               03550000
MFA-TR*        AND CX.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE           03560000
MFA-TR*        AND CX.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP       03570000
MFA-TR*        AND CX.BILL_NO            = :BG-BILL-NO                  03580000
MFA-TR*        AND CX.IC_NO              = :BG-IC-NO                    03590000
MFA-TR*        AND CX.MTR_REF_NO         = :MN-MTR-REF-NO               03600000
MFA-TR*        AND CX.REG_ID_NO          = 1                            03610000
MFA-TR*        AND CX.CODE_TIME_PERIOD   = 0                            03610000
MFA-TR*    ORDER BY ITEM_SEQ_NO                                         03620000
MFA-TR*         FOR FETCH ONLY WITH UR                                  03630000
MFA-TR*    END-EXEC.                                                    03630100
      *                                                                 03630200
      ******************************************************************03630300
      *                                                                 03630400
       PROCEDURE DIVISION.                                              
      *                                                                 03630600
       0000-MAINLINE.                                                   
      *                                                                 03630800
           PERFORM 0100-INITIALISATION         THRU 0100-EXIT.          
      *                                                                 03631000
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
      *                                                                 03633000
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                 03635000
           STOP RUN.                                                    
      *                                                                 03637000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03640000
      ******************************************************************03650000
      *  OPENS OUTPUT PRINTER FILE. TAKES THE SYSTEM DATE AND TIME AND *03660000
      *  SETS THEM FOR THE REPORT. GETS THE JOB_PARM DATE FROM JOB PARM*03670000
      *  TABLE MOVES IT ON TO THE RPT TRAN DATE AND BG-REVENUE-MONTH   *03680000
      ******************************************************************03690000
       0100-INITIALISATION.                                             
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                 03730000
           ACCEPT   WS-TIME     FROM TIME.                              
           ACCEPT   WS-SYS-DATE FROM DATE.                              
      *                                                                 03760000
           IF  WS-DT-YY > 50                                            
               MOVE '19'                       TO WS-CUR-CC             
           ELSE                                                         
               MOVE '20'                       TO WS-CUR-CC             
           END-IF.                                                      
      *                                                                 03820000
           MOVE WS-DT-MM                       TO WS-RPT-MM.            
           MOVE WS-DT-YY                       TO WS-CUR-YY.            
           MOVE WS-CUR-CCYY                    TO WS-RPT-CCYY.          
           MOVE WS-DT-DD                       TO WS-RPT-DD.            
      *                                                                 03870000
           MOVE WS-RPT-DATE                    TO WS-RUN-DATE.          
      *                                                                 03890000
           MOVE WS-TM-HH                       TO WS-RPT-HH.            
           MOVE WS-TM-MM                       TO WS-RPT-MIN.           
           MOVE WS-TM-SS                       TO WS-RPT-SS.            
      *                                                                 03930000
           MOVE WS-RPT-TIME                    TO WS-RUN-TIME.          
      *                                                                 03950000
           PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
      *                                                                 03970000
           IF END-OF-SYSIPT                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7611-CLOSE          THRU 7611-EXIT               
           END-IF.                                                      
      *                                                                 04030000
           MOVE WS-PARM-YR                     TO WS-PARM-REV-YEAR.     
           MOVE WS-PARM-MONTH                  TO WS-PARM-REV-MONTH.    
      *                                                                 04060000
T22362*CODE ADDED TO BE ABLE TO RUN THIS JOB ON THE WEEKEND AFTER       04070000
T22362*THE CLOSE OF CYCLE 20.                                           04080000
T22362     SUBTRACT 1                        FROM WS-PARM-REV-MONTH.    
T22362     IF  WS-PARM-REV-MONTH EQUAL ZEROS                            
T22362         MOVE 12                         TO WS-PARM-REV-MONTH     
T22362         SUBTRACT 1                    FROM WS-PARM-REV-YEAR      
T22362     END-IF.                                                      
T22362*                                                                 04140000
T22362     DISPLAY 'EXTRACT REVENUE MONTH = ' WS-PARM-REVENUE-MONTH.    
T22362*                                                                 04160000
           MOVE WS-PARM-REVENUE-MONTH          TO WS-TRAN-DATE.         
           MOVE WS-PARM-REV-MONTH-PACKED       TO BG-REVENUE-MONTH      
                                                  AT-REV-MTH-LST-NRML.  
      *                                                                 04200000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04230000
      ******************************************************************04240000
      * PASSES CONTROL TO OPEN,FETCH AND CLOSE THE  GET_MAIN CURSOR   **04250000
      * AND PROCESSES DATA UNTIL SQLCODE IS 100                       **04260000
      ******************************************************************04270000
      *                                                                 04280000
       1000-PROCESS-INPUT.                                              
      *                                                                 04300000
           PERFORM 7000-OPEN-GET-MAIN-CURSOR   THRU 7000-EXIT.          
           PERFORM 7010-FETCH-GET-MAIN-CURSOR  THRU 7010-EXIT.          
      *                                                                 04330000
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
      *                                                                 04350000
T23978         IF  WS-COMP-NO-HOLD = AT-COMPANY-NO                      
T23978             IF  WS-DET-LOC-OFF = AT-LOCAL-OFFICE                 
C31044                 PERFORM 1100-PROCESS-CNSMPTN THRU 1100-EXIT      
T23978             ELSE                                                 
T23978                 PERFORM 1200-LOFF-BREAK THRU 1200-EXIT           
T23978             END-IF                                               
T23978         ELSE                                                     
T23978            MOVE AT-COMPANY-NO TO WS-COMP-NO-HOLD                 
T23978            PERFORM 7800-GET-COMPANY-DESC                         
T23978            PERFORM 1200-LOFF-BREAK THRU 1200-EXIT                
T23978         END-IF                                                   
      *                                                                 04410000
               PERFORM 7010-FETCH-GET-MAIN-CURSOR THRU 7010-EXIT        
           END-PERFORM.                                                 
      *                                                                 04440000
           PERFORM 7020-CLOSE-GET-MAIN-CURSOR  THRU 7020-EXIT.          
      *                                                                 04460000
           IF  WS-NO-REPORT = 'Y'                                       
               PERFORM 8100-PRT-HEADINGS       THRU 8100-EXIT           
               MOVE WS-NO-DATA-LINE            TO PRT33-DATA            
               PERFORM 8200-WRITE-PRINT-REC    THRU 8200-EXIT           
           ELSE                                                         
               MOVE WS-FOOT-LINE               TO PRT33-DATA            
               MOVE WS-TWO                     TO WS-LINE-SPACE         
               PERFORM 8200-WRITE-PRINT-REC    THRU 8200-EXIT           
           END-IF.                                                      
      *                                                                 04560000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04590000
       1100-PROCESS-CNSMPTN.                                            
      *                                                                 04910000
           MOVE ZEROS                          TO WS-TOTAL-DAYS.        
           PERFORM 7100-GET-USAGE-DAYS THRU 7100-EXIT.                  
           IF  WS-TOTAL-DAYS < 28 OR WS-TOTAL-DAYS > 34                 
               CONTINUE                                                 
           ELSE                                                         
               GO TO 1100-EXIT                                          
           END-IF.                                                      
      *                                                                 04910000
           PERFORM 7200-OPEN-CNSMPTN-DET       THRU 7200-EXIT.          
           PERFORM 7210-FETCH-CNSMPTN-DET      THRU 7210-EXIT.          
      *                                                                 04980000
C31044     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
C31044         PERFORM 1110-PREPARE-DETAIL-REC   THRU 1110-EXIT         
C31044         PERFORM 7210-FETCH-CNSMPTN-DET      THRU 7210-EXIT       
C31044     END-PERFORM.                                                 
      *                                                                 05030000
           PERFORM 7220-CLOSE-CNSMPTN-DET      THRU 7220-EXIT.          
      *                                                                 05140000
END    1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05170000
      ******************************************************************04240000
      * PREPARES THE DETAIL RECORD DATA FOR THE REPORT                **04250000
      ******************************************************************04270000
       1110-PREPARE-DETAIL-REC.                                         
      *                                                                 05190000
           MOVE BG-ACCOUNT-NO              TO CX-ACCOUNT-NO.            
      *                                                                 04910000
           IF  WS-LINE-CNTR > WS-FIFTY-SIX                              
               PERFORM 8100-PRT-HEADINGS       THRU 8100-EXIT           
               ADD  WS-TWO                     TO WS-LINE-CNTR          
           END-IF.                                                      
      *                                                                 05240000
           PERFORM 1300-GET-CODE-DESC          THRU 1300-EXIT.          
      *                                                                 05260000
           IF  CX-ACCOUNT-NO EQUAL WS-ACCOUNT-NO                        
               MOVE SPACES                     TO WS-DET-READ-CYCLE     
                                                  WS-DET-ACCT-R         
                                                  WS-DET-ROUTE-R        
           ELSE                                                         
               MOVE UT-READ-CYCLE              TO WS-DET-READ-CYCLE     
               MOVE CX-ACCOUNT-NO              TO WS-DET-ACCOUNT-NO     
                                                  WS-ACCOUNT-NO         
               INSPECT  WS-DET-ACCOUNT-NO                               
                   REPLACING ALL ',' BY '-'                             
               MOVE UT-READ-ROUTE              TO WS-DET-ROUTE          
           END-IF.                                                      
      *                                                                 05390000
           MOVE CX-CODE-UTIL-TYPE              TO WS-DET-UTIL-TYPE.     
           MOVE CX-DATE-READ                   TO WS-DET-READ-DATE.     
           MOVE CX-METER-NO                    TO WS-DET-MTR-NO.        
      *                                                                 05430000
           IF  BG-PRORATE-CD = 'R'                                      
               MOVE 'Y'                        TO WS-DET-RECYCLED       
           ELSE                                                         
               MOVE SPACES                     TO WS-DET-RECYCLED       
           END-IF.                                                      
      *                                                                 05490000
           MOVE 'N'                            TO WS-NO-REPORT.         
           MOVE CX-NO-DAYS                     TO WS-DET-READ-DAYS.     
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           ADD  WS-ONE                         TO WS-LINE-CNTR.         
           MOVE WS-DETAIL-LINE                 TO PRT33-DATA.           
           PERFORM 8200-WRITE-PRINT-REC    THRU 8200-EXIT               
           INITIALIZE WS-DETAIL-LINE.                                   
      *                                                                 05570000
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05600000
      ******************************************************************05610000
      * WHEN EVER THERE IS A CHANGE IN LOCAL OFFICE PERFORMS A PAGE     05620000
      * BREAK                                                           05630000
      ******************************************************************05640000
      *                                                                 05650000
       1200-LOFF-BREAK.                                                 
      *                                                                 05670000
           MOVE AT-LOCAL-OFFICE                TO WS-DET-LOC-OFF        
                                                  B1-LOCAL-OFFICE.      
           PERFORM 7300-GET-LOC-OFF-DESC       THRU 7300-EXIT.          
           MOVE WS-FIFTY-SEVEN                 TO WS-LINE-CNTR.         
C31044     PERFORM 1100-PROCESS-CNSMPTN THRU 1100-EXIT.                 
      *                                                                 05730000
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05760000
      ******************************************************************05770000
      * EVALUATES CODE METER READ AND POPULATES WS-DET-READ-CODE        05780000
      * ACCORDINGLY. ALSO EVALUATES MTR READ SOURCE CD AND POPULATES    05790000
      * WS-DET-READ-SOURCE ACCORDINGLY                                  05800000
      ******************************************************************05810000
      *                                                                 05820000
       1300-GET-CODE-DESC.                                              
      *                                                                 05840000
           EVALUATE  CX-CODE-METER-READ                                 
               WHEN  'A'                                                
                 MOVE 'METER INSTALL READ'     TO WS-DET-READ-CODE      
               WHEN  'B'                                                
                 MOVE 'MTR EXCHANGE READ'      TO WS-DET-READ-CODE      
               WHEN  'C'                                                
                 MOVE 'MANUALLY SET READ'      TO WS-DET-READ-CODE      
               WHEN  'D'                                                
                 MOVE 'AWAITING READ'          TO WS-DET-READ-CODE      
               WHEN  'E'                                                
                 MOVE 'SYSTEM ESTIMATED'       TO WS-DET-READ-CODE      
               WHEN  'F'                                                
                 MOVE 'CANNOT ESTIMATE'        TO WS-DET-READ-CODE      
               WHEN  'G'                                                
                 MOVE 'SERVICE ORDER OFF READ' TO WS-DET-READ-CODE      
               WHEN  'J'                                                
                 MOVE 'NORMAL'                 TO WS-DET-READ-CODE      
               WHEN  'K'                                                
                 MOVE 'VERIFIED READ'          TO WS-DET-READ-CODE      
               WHEN  'L'                                                
                 MOVE 'ESTIMATED'              TO WS-DET-READ-CODE      
               WHEN  'N'                                                
                 MOVE 'NO READ'                TO WS-DET-READ-CODE      
               WHEN  'S'                                                
                 MOVE 'CUSTOMER CARD'          TO WS-DET-READ-CODE      
               WHEN  'T'                                                
                 MOVE 'CUSTOMER CALLED READ'   TO WS-DET-READ-CODE      
               WHEN  'X'                                                
                 MOVE 'CORRECTED'              TO WS-DET-READ-CODE      
               WHEN  OTHER                                              
                 MOVE CX-CODE-METER-READ       TO WS-DET-READ-CODE      
           END-EVALUATE.                                                
      *                                                                 06170000
           EVALUATE  CX-CODE-SOURCE-ID                                  
               WHEN  'A'                                                
                 MOVE 'SERVICE ORDER'          TO WS-DET-READ-SOURCE    
               WHEN  'B'                                                
                 MOVE 'ITRON'                  TO WS-DET-READ-SOURCE    
               WHEN  'C'                                                
                 MOVE 'ONLINE ENTRY'           TO WS-DET-READ-SOURCE    
               WHEN  'D'                                                
                 MOVE 'SYSTEM ESTIMATED'       TO WS-DET-READ-SOURCE    
               WHEN  'M'                                                
                 MOVE 'MV90'                   TO WS-DET-READ-SOURCE    
               WHEN  'R'                                                
                 MOVE 'CANCEL/REBILL'          TO WS-DET-READ-SOURCE    
               WHEN  OTHER                                              
                 MOVE CX-CODE-SOURCE-ID        TO WS-DET-READ-SOURCE    
           END-EVALUATE.                                                
      *                                                                 06340000
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06370000
      **********************************************************        06380000
      **6200-GET-PARAMETER-DATE                             **          06390000
      **********************************************************        06400000
           EXEC SQL                                                     06410000
                 INCLUDE CPD00114                                       06420000
           END-EXEC.                                                    06430000
      ********************************************************          06440000
      * JOB_PARM INCLUDES FOR DATE ACCESS                               06450000
      ********************************************************          06460000
                                                                        
           EXEC SQL                                                     06480000
               INCLUDE CPD00038                                         06490000
           END-EXEC.                                                    06500000
      *                                                                 06510000
      ******************************************************************06520000
      **  DB2 CALLS                                                   **06530000
      ******************************************************************06540000
      *                                                                 06550000
       7000-OPEN-GET-MAIN-CURSOR.                                       
      *                                                                 06570000
           EXEC SQL                                                     
              OPEN GET_MAIN                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW301 ABORT ************'         
               DISPLAY '* 7000-OPEN-GET-MAIN-CURSOR          *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW301 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 06730000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06760000
      ******************************************************************06770000
      * FETCHES ACCOUNT NO, IC NO, READ ROUTE READ CYCLE AND LOCAL      06780000
      * OFFICE                                                          06790000
      ******************************************************************06800000
      *                                                                 06810000
       7010-FETCH-GET-MAIN-CURSOR.                                      
      *                                                                 06830000
           EXEC SQL                                                     
              FETCH   GET_MAIN                                          
               INTO   :BG-ACCOUNT-NO                                    
                     ,:BG-CODE-UTIL-TYPE                                
                     ,:BG-IC-NO                                         
                     ,:UT-READ-ROUTE                                    
                     ,:UT-READ-CYCLE                                    
                     ,:AT-LOCAL-OFFICE                                  
T23978               ,:AT-COMPANY-NO                                    
                     ,:MN-MTR-REF-NO                                    
                     ,:BG-PRORATE-CD                                    
                     ,:MN-METER-NO                                      
                     ,:BG-BILL-NO                                       
                     ,:BG-BILL-ITEM-TIMESTMP                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06940000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW301 ABORT ************'         
               DISPLAY '* 7010-FETCH-GET-MAIN-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW301 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 07060000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07090000
      ******************************************************************07100000
      * CLOSES GET_MAIN CURSOR                                          07110000
      ******************************************************************07120000
      *                                                                 07130000
       7020-CLOSE-GET-MAIN-CURSOR.                                      
      *                                                                 07150000
           EXEC SQL                                                     
              CLOSE GET_MAIN                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07190000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW301 ABORT ************'         
               DISPLAY '* 7020-CLOSE-GET-MAIN-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW301 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 07310000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07340000
C31044******************************************************************08350000
ST    * GET SUM OF DAYS FOR A BILL-NO                                  *08360000
      ******************************************************************08370000
       7100-GET-USAGE-DAYS.                                             
      *                                                                 08400000
           EXEC SQL                                                     
              SELECT SUM(NO_DAYS)                                       
                INTO :WS-TOTAL-DAYS :WS-TOTAL-DAYS-NULL                  
                FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                
                 AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE            
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )        
                 AND BILL_NO            = :BG-BILL-NO                   
                 AND IC_NO              = :BG-IC-NO                     
                 AND MTR_REF_NO         = :MN-MTR-REF-NO                
                 AND CODE_TIME_PERIOD   = 0                             
                 AND REG_ID_NO          = 1                             
C33884                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08410000
MFA-TR*       SELECT SUM(NO_DAYS)                                       08420000
MFA-TR*         INTO :WS-TOTAL-DAYS:WS-TOTAL-DAYS-NULL                  08430000
MFA-TR*         FROM CSS_CNSMPTN_HIST                                   08440000
MFA-TR*        WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                  035500
MFA-TR*          AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE              035600
MFA-TR*          AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP          035700
MFA-TR*          AND BILL_NO            = :BG-BILL-NO                     035800
MFA-TR*          AND IC_NO              = :BG-IC-NO                       035900
MFA-TR*          AND MTR_REF_NO         = :MN-MTR-REF-NO                  036000
MFA-TR*          AND CODE_TIME_PERIOD   = 0                               036100
MFA-TR*          AND REG_ID_NO          = 1                               036100
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    08460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08470000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 08490000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   CONTINUE                                             
               ELSE                                                     
                   DISPLAY '*********** PCSBW301 ABORT ************'    
                   DISPLAY '* SELECT ERROR IN 7100-GET-USAGE-DAYS *'    
                   DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE       
                   DISPLAY '* PROGRAM ABORTING...                 *'    
                   DISPLAY '*********** PCSBW301 ABORT ************'    
                   PERFORM 9900-ABEND              THRU 9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                 08640000
       7100-EXIT.                                                       
END        EXIT.                                                        
C31044*                                                                 08670000
      ******************************************************************07430000
      * OPENS GET_CNSMTPN_DET CURSOR                                    07440000
      ******************************************************************07450000
      *                                                                 07460000
       7200-OPEN-CNSMPTN-DET.                                           
      *                                                                 07480000
           EXEC SQL                                                     
              OPEN GET_CNSMPTN_DET                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07520000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW301 ABORT ************'         
               DISPLAY '* 7200-OPEN-CNSMPTN-DET              *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW301 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 07640000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07670000
      ******************************************************************07680000
      * IF SQLCODE IS 0 AND CX-DATE-READ NULL MOVES SPACES TO           07690000
      * WS-DET-READ-DATE.                                               07700000
      ******************************************************************07710000
      *                                                                 07720000
       7210-FETCH-CNSMPTN-DET.                                          
      *                                                                 07740000
           EXEC SQL                                                     
              FETCH    GET_CNSMPTN_DET                                  
               INTO   :CX-ACCOUNT-NO                                    
                     ,:CX-NO-DAYS                                       
                     ,:CX-METER-NO                                      
                     ,:CX-CODE-UTIL-TYPE                                
                     ,:CX-IC-NO                                         
                     ,:CX-BILL-NO                                       
                     ,:CX-CODE-METER-READ                               
                     ,:CX-CODE-SOURCE-ID                                
                     ,:CX-ITEM-SEQ-NO                                   
                     ,:CX-DATE-READ :IV-CX-DATE-READ                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07880000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF  IV-CX-DATE-READ = -1                                 
                   MOVE SPACES                 TO CX-DATE-READ          
               END-IF                                                   
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   CONTINUE                                             
               ELSE                                                     
                   DISPLAY '********** PCSBW301 ABORT ************'     
                   DISPLAY '* 7210-FETCH-CNSMPTN-DET             *'     
                   DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE       
                   DISPLAY '* PROGRAM ABORTING...                *'     
                   DISPLAY '********** PCSBW301 ABORT ************'     
                   PERFORM 9900-ABEND              THRU 9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                 08060000
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08090000
      ******************************************************************08100000
      * CLOSES GET_CNSMTPN_DET CURSOR                                   08110000
      ******************************************************************08120000
      *                                                                 08130000
       7220-CLOSE-CNSMPTN-DET.                                          
      *                                                                 08150000
           EXEC SQL                                                     
              CLOSE GET_CNSMPTN_DET                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08190000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW301 ABORT ************'         
               DISPLAY '* 7220-CLOSE-CNSMPTN-DET             *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW301 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 08310000
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08340000
      ******************************************************************08350000
      * GETS LOCAL OFFICE DESCRIPTION FROM CSS_LOCAL_OFFICE            *08360000
      ******************************************************************08370000
      *                                                                 08380000
       7300-GET-LOC-OFF-DESC.                                           
      *                                                                 08400000
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE_DESC                                  
                INTO :B1-LOCAL-OFFICE-DESC                              
                FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
               WHERE LOCAL_OFFICE = :B1-LOCAL-OFFICE                    
C33884                                                           
T22362     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08410000
MFA-TR*       SELECT LOCAL_OFFICE_DESC                                  08420000
MFA-TR*         INTO :B1-LOCAL-OFFICE-DESC                              08430000
MFA-TR*         FROM CSS_LOCAL_OFFICE                                   08440000
MFA-TR*        WHERE LOCAL_OFFICE = :B1-LOCAL-OFFICE                    08450000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    08460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22362*                                                                 08470000
T22362     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T22362*                                                                 08490000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE B1-LOCAL-OFFICE-DESC       TO WS-DET-LOC-OFF-DESC   
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   MOVE SPACES                 TO WS-DET-LOC-OFF-DESC   
               ELSE                                                     
                   DISPLAY '*********** PCSBW301 ABORT ************'    
                   DISPLAY '* SELECT ERROR IN 7300-GET-LOC-OFF-DESC'    
                   DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE       
                   DISPLAY '* PROGRAM ABORTING...                 *'    
                   DISPLAY '*********** PCSBW301 ABORT ************'    
                   PERFORM 9900-ABEND              THRU 9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                 08640000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08670000
T23978******************************************************************08670100
T23978* GETS COMPANY NUMBER DESCRIPTION FROM CSS_COMPANY               *08670200
T23978******************************************************************08670300
T23978*                                                                 08670400
T23978 7800-GET-COMPANY-DESC.                                           
T23978*                                                                 08672000
T23978     EXEC SQL                                                     
T23978         SELECT   COMPANY_NAME                                    
T23978         INTO :WS-COMPANY-NAME                                    
T23978         FROM CSS_COMPANY WITH(READUNCOMMITTED)                           
T23978         WHERE    COMPANY_NO = :WS-COMP-NO-HOLD                   
C33884                                                           
T23978     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08673000
MFA-TR*        SELECT   COMPANY_NAME                                    08674000
MFA-TR*        INTO :WS-COMPANY-NAME                                    08675000
MFA-TR*        FROM CSS_COMPANY                                         08676000
MFA-TR*        WHERE    COMPANY_NO = :WS-COMP-NO-HOLD                   08677000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    08678000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23978*                                                                 08679000
T23978     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T23978     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T23978        MOVE WS-COMPANY-NAME          TO WS-TITLE-COMP-NAME       
T23978        MOVE WS-HEADER-TITLE          TO WS-HDR-ONE-TITLE         
T23978     ELSE                                                         
T23978        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T23978           MOVE WS-DEFAULT-HDR1-TITLE TO WS-HDR-ONE-TITLE         
T23978        ELSE                                                      
T23978           DISPLAY '*** 7800-GET-COMPANY-DESC ***'                
T23978           DISPLAY '**** PROGRAM TERMINATING ****'                
T23978           DISPLAY '  SQL ERROR CODE =' SQLCODE                   
T23978           PERFORM 9900-ABEND THRU 9900-EXIT                      
T23978        END-IF                                                    
T23978     END-IF.                                                      
T23978*                                                                 08680500
T23978 7800-EXIT.                                                       
T23978     EXIT.                                                        
T23978*                                                                 08680800
      ***************************************************************** 08681000
      * PRINTS PAGE HEADINGS AT THE TOP OF EACH PAGE LEAVING ONE LINE   08690000
      * SPACE AFTER THE FIRST TWO HDGNS AND ALSO AFTER THE THIRD SUB    08700000
      * HEADING                                                         08710000
      ***************************************************************** 08720000
      *                                                                 08730000
       8100-PRT-HEADINGS.                                               
           MOVE 0                              TO WS-LINE-CNTR.         
           ADD WS-ONE                          TO WS-PAGE.              
           MOVE WS-PAGE                        TO WS-DET-PAGE.          
           MOVE WS-HDR-ONE                     TO PRT33-DATA.           
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           MOVE WS-HDR-TWO                     TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8200-WRITE-PRINT-REC        THRU 8200-EXIT.          
           MOVE WS-HDR-TIME                    TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8200-WRITE-PRINT-REC        THRU 8200-EXIT.          
           MOVE WS-HDR-THREE                   TO PRT33-DATA.           
           MOVE WS-TWO                         TO WS-LINE-SPACE.        
           PERFORM 8200-WRITE-PRINT-REC        THRU 8200-EXIT.          
           MOVE WS-HDR-FOUR                    TO PRT33-DATA.           
           MOVE WS-TWO                         TO WS-LINE-SPACE.        
           PERFORM 8200-WRITE-PRINT-REC        THRU 8200-EXIT.          
           MOVE WS-HDR-FIVE                    TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8200-WRITE-PRINT-REC        THRU 8200-EXIT.          
           MOVE WS-LINE                        TO PRT33-DATA.           
           MOVE WS-ONE                         TO WS-LINE-SPACE.        
           PERFORM 8200-WRITE-PRINT-REC        THRU 8200-EXIT.          
           ADD  +9                             TO WS-LINE-CNTR.         
      *                                                                 08990000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09020000
      ******************************************************************09030000
      * WRITES THE RECORD ON TO THE REPORT                              09040000
      ******************************************************************09050000
      *                                                                 09060000
       8200-WRITE-PRINT-REC.                                            
           WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                 09090000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09120000
      **************************************************************    09130000
      * CLOSES THE FILE  FCSPT33-FILE AND DISPLAYS THE STATISTICS IN    09140000
      * THE SYSOUT                                                      09150000
      **************************************************************    09160000
      *                                                                 09170000
       9000-TERMINATE.                                                  
      *                                                                 09190000
           CLOSE   FCSPT33-FILE.                                        
      *                                                                 09210000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09240000
      ****************************************************************  09250000
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****   09260000
      ****************************************************************  09270000
           EXEC SQL                                                     09280000
               INCLUDE CPD09900                                         09290000
           END-EXEC.                                                    09300000
