       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW300.                                        
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL              **          
      **                     PRICE WATERHOUSE                       **          
      **                1410 NORTH WESTSHORE BLVD                   **          
      **                   TAMPA, FLORIDA  33607                    **          
      **                      (813) 287-9200                        **          
      **                                                            **          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      *                                                              *          
      *              PROGRAM  MODIFICATION  LOG                      *          
      *    DATE    INITIALS     REASON                               *          
      *  ________  ________     ____________________________________ *          
      *  03/13/95     TRC       ARCHIVE INTERVAL DATA RECORDER DATA  *          
      *                         ON MONTHLY BASIS FOR ALL DATA THAT   *          
      *                         HAS BEEN BILLED ONE MONTH AGO OR     *          
      *                         LONGER AND COPY TO A TAPE.  DELETE   *          
      *                         ALL CSS_INTERVAL_READ ROWS WHICH     *          
      *                         BELONG TO A CALCULATED BILL WHICH IS *          
      *                         MORE THAN A MONTH OLD.               *          
TP2842*  --------  ---------    ------------------------------------ *          
TP2842*  03/14/96     DW        DELETE BUT DO NOT ARCHIVE IDR DATA   *          
TP2842*                         WHERE IDR_INFO_RETENT_DT IS NOT NULL *          
TP2842*                         AND <= ARCHIVE/PURGE DATE (WS-WORK-  *          
TP2842*                         DATE).  CHANGE MTR_CURSOR TO ORDER   *          
TP2842*                         BY ACCOUNT_NO, MTR_REF_NO, AND       *          
TP2842*                         BILL_ITEM_TIMESTMP.                  *          
TP2842*  --------  ---------    ------------------------------------ *          
TP6049*  03/30/97     MJL       REMOVE CONDITION DST='X' FROM DELETE *          
TP6049*                         OF CSS_INTERVAL_READ.                *          
TP2842*  --------  ---------    ------------------------------------ *          
T15335*  03/11/98     TDK       CHANGED THE VALUE OF WS-DEFAULT-     *          
T15335*                         ARCHIVE-DATA TO 02.                  *          
T16273*  05/06/98     TDK       ADDED A NULL INDICATOR FOR           *          
T16273*                         DATE_BILLED                          *          
T18395*  11/11/98     AAT       DELETED LINES SO THAT ARCHIVING IDR  *          
      *                         RECORDS OCCURED EVERYTIME BEFORE     *          
      *                         RECORDS WERE DELETED FROM THE        *          
      *                         CSS_INTERVAL_READ UNLESS THERE WAS A *          
      *                         RETENT_DT B/C THEN HAD BEEN ARCHIVED *          
      *                         PREVIOUSLY.  CHANGED INTERVAL CURSOR *          
      *                         TO GET ONLY ITEMS WHERE THE TIMESTMP *          
      *                         WAS THE SAME AS THE MTR_IDENT_HIST   *          
      *                         TIMESTMP. ALSO CHANGED DEFAULT       *          
      *                         ARCHIVE DATE TO '03'.                *          
PRDFIX**  10/30/02    GAUSE      EMERGENCY FIX TO ADD UTIL TYPE TO   **         
PRDFIX**                         INTERVAL TABLE SELECTS.             **         
      **                                                             **         
30401 **  9 MAR 2004  RDF       ADD COMMIT LOGIC. BUT NO RESTART     **         
30401 **                        DELETE WRITING TO OUTPUT FILE        **         
      **                                                             **         
30719 **  5 APR 2004  RDF       FIX DUPLICATE ROW PROBLEM IN         **         
30719 **                        PARAGRAPH 7400- AND END-OF-DATA      **         
30719 **                        ERROR IN 7100-                       **         
      **                                                             **         
T33412** 21 OCT 2004  VIJAY     FIX DUPLICATE ROW PROBLEM IN         **         
T33412**                        PARAGRAPH 7400- 2ND SQL.             **         
A05460** 01 AUG 2016  MR7E794   REMOVE THE TABLE CSS_INTERVAL_READ   **         
A05460**              ACT240    USAGE PARA 7011- AND UNUSED CODE.    **         
      ****************************************************************          
                                                                        
       REMARKS.                                                         
             THIS PROGRAM LISTS ALL ACCOUNTS WITH A BILL CYCLE CHANGE.  
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                          ---- PARAGRAPH STRUCTURE ----                 
           SEQ #  NAME                          FUNCTION                
           ---- ------------------------- ----------------------------- 
           ADD THE PARAGRAPHS AND THEIR FUNCTIONS AS PART OF            
           PROGRAM DOCUMENTATION. EXAMPLE                               
           0000 MAIN-BODY                  CONTROLS PROGRAM FLOW        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW300'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
             'WORKING STORAGE FOR PCSBW300 STARTS HERE'.                
      *                                                                         
30401  01  WS-BILL-ITEM-TIMESTMP        PIC X(26) VALUE SPACES.         
30401  01  WS-CODE-UTIL-TYPE            PIC X     VALUE SPACES.         
30401  01  WS-METER-NO                  PIC 9(9)  VALUE ZERO.           
30401  01  WS-COMMIT-ACCT-NO            PIC S9(13) COMP-3 VALUE 0.      
30401  01  WS-NBR-COMMIT                PIC S9(5)  COMP-3 VALUE 0.      
      *                                                                         
PRDFIX 01  WS-COUNT-METER               PIC 9(6)  VALUE ZERO.           
       01  WS-MISC-FIELDS.                                              
           05  WS-END-OF-DATA           PIC X     VALUE 'N'.            
               88  END-OF-DATA                    VALUE 'Y'.            
      *                                                                         
       COPY CWS00010.                                                           
       COPY CWS00301.                                                           
       COPY CWS00303.                                                           
       COPY CWS00021.                                                           
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-WORK-DATE            PIC X(10)    VALUE SPACES.       
           05  WS-ROW-COUNT            PIC S9(9)   COMP VALUE ZERO.     
           05  WS-DAY                  PIC S9(4)   COMP VALUE ZERO.     
           05  WS-ARCHIVE-DATA         PIC S9(4)   COMP VALUE ZERO.     
           05  WS-REC-COUNTER          PIC 9(5)    VALUE ZEROS.         
           05  WS-NULL-IND             PIC S9(4)    COMP VALUE +0.      
           05  WS-NULL-IND2            PIC S9(4)    COMP VALUE +0.      
T16273     05  WS-DT-BILL-NULL-IND     PIC S9(4)    COMP VALUE +0.      
T18702     05  WS-REBILL-BILL-NO       PIC S9(4)    COMP VALUE +0.      
T18702     05  WS-REBILL-REV-MONTH     PIC S9(6)    COMP VALUE +0.      
T18702     05  WS-REBILL-ITEM-TIMESTMP PIC X(26)    VALUE SPACES.       
T33412     05  WS-811                     PIC S9(9) VALUE -811 COMP.    
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(8)   VALUE 'PCSBW300'.     
           05  WS-Y                    PIC X      VALUE 'Y'.            
           05  WS-N                    PIC X      VALUE 'N'.            
T18395     05  WS-DEFAULT-ARCHIVE-DATA PIC XX     VALUE '03'.           
           05  WS-RECORD-TYPE-0        PIC X      VALUE '0'.            
           05  WS-RECORD-TYPE-1        PIC X      VALUE '1'.            
           05  WS-CALCULATED-BILL      PIC X      VALUE 'I'.            
           05  WS-NULLS                PIC S9(4)  COMP VALUE -1.        
T18702     05  WS-NON-CALC-BILL        PIC X      VALUE 'S'.            
T18702     05  WS-CANCEL               PIC X      VALUE 'K'.            
T18702     05  WS-NORMAL-BILL          PIC X      VALUE 'A'.            
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-BAD-WORKING-DAY      PIC X.                           
               88  BAD-WORKING-DAY                VALUE 'N'.            
               88  GOOD-WORKING-DAY               VALUE 'Y'.            
T18702     05  WS-CANCEL-IND           PIC X.                           
T18702         88  CANCEL-EXISTS                  VALUE 'Y'.            
T18702         88  CANCEL-DNE                     VALUE 'N'.            
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRIDT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE MTR_CURSOR CURSOR WITH HOLD FOR                  
               SELECT ACCOUNT_NO,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                               
                      BILL_NO,                                          
                      CHANNEL_A_UOM,                                    
                      CHANNEL_B_UOM,                                    
                      CHANNEL_C_UOM,                                    
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      IDR_IDENT_NO,                                     
                      INTERVALS_PER_HR,                                 
                      METER_NO,                                         
                      MTR_REF_NO,                                       
                      IDR_INFO_RETENT_DT                                
               FROM CSS_MTR_IDENT_HIST                                  
               WHERE  BILL_ITEM_TIMESTMP <= DATEADD( DAY, -(28     
                                           * (:WS-ARCHIVE-DATA)), 
           CIS.CURRENT$TIMESTAMP() )   
TP2842         ORDER BY ACCOUNT_NO ASC,                                 
TP2842                  MTR_REF_NO ASC,                                 
TP2842                  BILL_ITEM_TIMESTMP ASC                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MTR_CURSOR CURSOR WITH HOLD FOR                          
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               BILL_ITEM_TIMESTMP,                                       
MFA-TR*               BILL_NO,                                                  
MFA-TR*               CHANNEL_A_UOM,                                            
MFA-TR*               CHANNEL_B_UOM,                                            
MFA-TR*               CHANNEL_C_UOM,                                            
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               IC_NO,                                                    
MFA-TR*               IDR_IDENT_NO,                                             
MFA-TR*               INTERVALS_PER_HR,                                         
MFA-TR*               METER_NO,                                                 
MFA-TR*               MTR_REF_NO,                                               
MFA-TR*               IDR_INFO_RETENT_DT                                        
MFA-TR*        FROM CSS_MTR_IDENT_HIST                                          
MFA-TR*        WHERE  BILL_ITEM_TIMESTMP <= CURRENT TIMESTAMP - (28             
MFA-TR*                                    * (:WS-ARCHIVE-DATA)) DAYS           
MFA-TR*        ORDER BY ACCOUNT_NO ASC,                                         
MFA-TR*                 MTR_REF_NO ASC,                                         
MFA-TR*                 BILL_ITEM_TIMESTMP ASC                                  
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(40)    VALUE               
             'WORKING STORAGE FOR PCSBW300 ENDS HERE  '.                
      *                                                                         
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **        CONTROLS MAIN PROCESSING                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 1000-CURSOR-PROCESS           THRU 1000-EXIT.        
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           GOBACK.                                                      
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      COMMON INITIALIZATION ROUTINE                         **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                                 THRU 6240-EXIT         
               MOVE WS-FCA00-COMMON-DATE                                
                                       TO WS-INPUT-DATE                 
           END-IF.                                                      
      *                                                                         
           MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
           PERFORM 7600-START-FCSJC01            THRU 7600-EXIT.        
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT         
               UNTIL (ARCHIVE-DATA AND INPUT-ACTIVE)                    
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF END-OF-SYSIPT                                             
               DISPLAY '** ' WS-PGRMNAME ' INFORMATIONAL MSG   **'      
               DISPLAY '**  ARCHIVE DATA PARM NOT ACTIVE  **'           
               DISPLAY '**  DEFAULT OF ' WS-DEFAULT-ARCHIVE-DATA        
                       ' WILL BE USED  **'                              
               DISPLAY '**      PROCESSING CONTINUING     **'           
               MOVE WS-DEFAULT-ARCHIVE-DATA                             
                                       TO WS-ARCHIVE-DATA               
           ELSE                                                         
               IF (ARCHIVE-DATA AND INPUT-ACTIVE)                       
                   PERFORM 7611-CLOSE            THRU 7611-EXIT         
                   MOVE WS-ARCHIVE-DATA-PARM                            
                                       TO WS-ARCHIVE-DATA               
               ELSE                                                     
                   MOVE WS-DEFAULT-ARCHIVE-DATA                         
                                       TO WS-ARCHIVE-DATA               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       COPY CPD00040.                                                           
       COPY CPD00037.                                                           
      *                                                                         
      ****************************************************************          
      **  CURSOR-PROCESS                                            **          
      ****************************************************************          
      *                                                                         
       1000-CURSOR-PROCESS.                                             
      *                                                                         
           PERFORM 2100-GET-ARCHIVE-MONTH THRU 2100-EXIT.               
      *                                                                         
T18702     DISPLAY ' '.                                                 
T18702     DISPLAY '***************************************************'
T18702     DISPLAY 'IDR DATA WILL BE ARCHIVED AND PURGED FOR ALL BILLS '
T18702     DISPLAY 'PRIOR TO ' WS-WORK-DATE.                            
T18702     DISPLAY '***************************************************'
T18702     DISPLAY ' '.                                                 
      *                                                                         
           PERFORM 7005-OPEN-MTR-CURSOR          THRU 7005-EXIT.        
           PERFORM 7010-FETCH-MTR-CURSOR         THRU 7010-EXIT.        
      *                                                                         
           PERFORM 2000-PROCESS-RECORDS          THRU 2000-EXIT         
               UNTIL END-OF-DATA.                                       
      *                                                                         
           PERFORM 7050-CLOSE-MTR-CURSOR         THRU 7050-EXIT.        
      *                                                                         
PRDFIX     DISPLAY 'END OF JOB CSRB300'.                                
PRDFIX     DISPLAY ' # OF UNIQUE BILLS/METERS DELETED '                 
PRDFIX             WS-COUNT-METER.                                      
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **     PROCESS RECORDS                                        **          
      ****************************************************************          
      *                                                                         
       2000-PROCESS-RECORDS.                                            
      *                                                                         
           PERFORM 7100-SELECT-BILL-HEADER THRU 7100-EXIT.              
      *                                                                         
           IF BI-DATE-BILLED LESS THAN OR EQUAL WS-WORK-DATE AND        
T16273       WS-DT-BILL-NULL-IND EQUAL ZERO                             
              IF BI-CODE-BILL-STATUS EQUAL WS-CALCULATED-BILL           
      *                                                                         
      *****************************************************************         
      *  TPR 18395 DELETED SOME LINES RELATING TO TPR 2842 (BELOW)    *         
      *  THE CHANGES MADE BY TPR 18395 ALLOW FOR IDR RECORDS TO BE    *         
      *  ARCHIVED (WRITTEN TO FCSBW300) BEFORE BEING DELETED FROM THE *         
      *  CSS_INTERVAL_READ TABLE.                                               
      *****************************************************************         
      *   IF THERE IS NO GA-IDR-INFO-RETENT-DT THEN DELETE THE ROWS             
      *****************************************************************         
      *                                                                         
TP2842           IF WS-NULL-IND NOT EQUAL ZERO                          
T18702              SET CANCEL-DNE TO TRUE                              
T18395              PERFORM 8100-DELETE-IDR-RECORDS THRU 8100-EXIT      
T18702              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
T18702                 DISPLAY 'IDR DATA DELETED FOR:'                  
T18702                 DISPLAY 'ACCOUNT : ' GA-ACCOUNT-NO               
T18702                         ' BILL NO : ' GA-BILL-NO                 
T18702                         ' METER NO: ' GA-METER-NO                
PRDFIX                 ADD 1 TO WS-COUNT-METER                          
T18702              END-IF                                              
T18395              MOVE WS-NULLS TO WS-NULL-IND                        
T18395              MOVE LOW-VALUES TO GA-IDR-INFO-RETENT-DT            
T18395              PERFORM 8200-UPDATE-IDR-RECORDS THRU 8200-EXIT      
T18702              PERFORM 7300-CHECK-FOR-CANCEL THRU 7300-EXIT        
T18702* THERE IS NO RECORD IN CSS_MTR_IDENT_HIST FOR A CANCEL/REBILL.           
T18705* THIS MUST BE CHECKED FOR SEPARATELY.                                    
T18702              IF CANCEL-EXISTS                                    
T18702                 MOVE 0 TO WS-REBILL-BILL-NO                      
                                 WS-REBILL-REV-MONTH                    
T18702                 MOVE SPACES TO WS-REBILL-ITEM-TIMESTMP           
T18702                 PERFORM 7400-CHECK-FOR-REBILL THRU 7400-EXIT     
T18702                 IF WS-REBILL-BILL-NO > 0                         
T18702                  AND (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL    
T33412                       OR WS-ACTIVE-RETURN-CODE = WS-811)         
T18702                    MOVE WS-REBILL-BILL-NO TO GA-BILL-NO          
T18702                    MOVE WS-REBILL-ITEM-TIMESTMP                  
T18702                      TO GA-BILL-ITEM-TIMESTMP                    
T18702                    PERFORM 8100-DELETE-IDR-RECORDS THRU 8100-EXIT
T18702                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL
T18702                       DISPLAY 'IDR DATA DELETED FOR REBILL: '    
T18702                       DISPLAY 'ACCOUNT : ' GA-ACCOUNT-NO         
T18702                               ' BILL NO : ' GA-BILL-NO           
T18702                               ' METER NO: ' GA-METER-NO          
PRDFIX                       ADD 1 TO WS-COUNT-METER                    
T18702                    END-IF                                        
                       END-IF                                           
T18702              END-IF                                              
T18395           ELSE                                                   
                    IF GA-IDR-INFO-RETENT-DT <= WS-INPUT-DATE           
                       PERFORM 8100-DELETE-IDR-RECORDS THRU 8100-EXIT   
T18702                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL   
T18702                   DISPLAY 'HONK A BUDDY : '                      
T18702                   DISPLAY 'ACCOUNT : ' GA-ACCOUNT-NO             
T18702                         ' BILL NO : ' GA-BILL-NO                 
T18702                         ' METER NO: ' GA-METER-NO                
T18702                 END-IF                                           
                       MOVE WS-NULLS TO WS-NULL-IND                     
                       MOVE LOW-VALUES TO GA-IDR-INFO-RETENT-DT         
                       PERFORM 8200-UPDATE-IDR-RECORDS THRU 8200-EXIT   
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7010-FETCH-MTR-CURSOR         THRU 7010-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      THE ARCHIVE MONTH IS DETERMINED BY THE ARCHIVE-DATE   **          
      **      JOB PARM.  FOR EXAMPLE: IF JOB PARM IS SET TO 01, ALL **          
      **      IDR DATA WITH A BILLED DATE OF ONE MONTH AGO OR MORE  **          
      **      WILL BE DELETED FROM CSS_INTERVAL_READ.               **          
      **      IF JOB PARM EQUALS 02, DATA TWO MONTHS OLD            **          
      **      OR GREATER WILL BE PROCESSED, ETC.                    **          
      ****************************************************************          
      *                                                                         
       2100-GET-ARCHIVE-MONTH.                                          
      *                                                                         
           MOVE WS-INPUT-DATE          TO WS-WORK-DATE.                 
           PERFORM 7150-GET-ARCHIVE-MONTH        THRU 7150-EXIT.        
      *                                                                         
           SET BAD-WORKING-DAY         TO TRUE.                         
      *                                                                         
           PERFORM UNTIL GOOD-WORKING-DAY                               
               IF WS-DAY < 1 OR                                         
                  WS-DAY > 5                                            
                   PERFORM 7180-GET-NEXT-DAY     THRU 7180-EXIT         
               ELSE                                                     
                   PERFORM 7200-SELECT-HOLIDAY   THRU 7200-EXIT         
                   IF WS-ROW-COUNT EQUAL ZERO                           
                       SET GOOD-WORKING-DAY                             
                                       TO TRUE                          
                   ELSE                                                 
                       PERFORM 7180-GET-NEXT-DAY THRU 7180-EXIT         
                   END-IF                                               
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      OPENS CURSOR FOR CSS_MTR_IDENT_HIST.                  **          
      ****************************************************************          
      *                                                                         
       7005-OPEN-MTR-CURSOR.                                            
      *                                                                         
           MOVE '7005'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               OPEN MTR_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  ERROR ON 7005-OPEN-MTR-CURSOR  **'          
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      PROCESSING TERMINATED      **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  FETCH-MTR-CURSOR                                          **          
      ****************************************************************          
      *                                                                         
       7010-FETCH-MTR-CURSOR.                                           
      *                                                                         
           MOVE '7010'                 TO WS-ACTIVE-PARAGRAPH.          
           MOVE ZEROES                 TO WS-NULL-IND.                  
      *                                                                         
           EXEC SQL                                                     
               FETCH MTR_CURSOR                                         
               INTO :GA-ACCOUNT-NO,                                     
                    :GA-BILL-ITEM-TIMESTMP,                             
                    :GA-BILL-NO,                                        
                    :GA-CHANNEL-A-UOM,                                  
                    :GA-CHANNEL-B-UOM,                                  
                    :GA-CHANNEL-C-UOM,                                  
                    :GA-CODE-UTIL-TYPE,                                 
                    :GA-IC-NO,                                          
                    :GA-IDR-IDENT-NO,                                   
                    :GA-INTERVALS-PER-HR,                               
                    :GA-METER-NO,                                       
                    :GA-MTR-REF-NO,                                     
                    :GA-IDR-INFO-RETENT-DT :WS-NULL-IND                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE 'Y' TO WS-END-OF-DATA                           
               ELSE                                                     
                   DISPLAY '** ERROR ON 7010-FETCH-MTR-CURSOR **'       
                   DISPLAY '**    RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '**    PROCESSING TERMINATED       **'       
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  CLOSE-MTR-CURSOR                                          **          
      ****************************************************************          
      *                                                                         
       7050-CLOSE-MTR-CURSOR.                                           
      *                                                                         
           MOVE '7050'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               CLOSE MTR_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** ERROR ON 7050-CLOSE-MTR-CURSOR **'           
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      PROCESSING TERMINATED     **'           
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **  SELECT-BILL-HEADER                                       **           
      ***************************************************************           
       7100-SELECT-BILL-HEADER.                                         
      *                                                                         
           MOVE '7100'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT ACCOUNT_NO,                                       
                      BILL_NO,                                          
                      CODE_BILL_STATUS,                                 
                      DATE_BILLED                                       
               INTO  :BI-ACCOUNT-NO,                                    
                     :BI-BILL-NO,                                       
                     :BI-CODE-BILL-STATUS,                              
                     :BI-DATE-BILLED :WS-DT-BILL-NULL-IND               
               FROM CSS_BILLING_HDR                                     
               WHERE ACCOUNT_NO = :GA-ACCOUNT-NO                        
                 AND BILL_NO    = :GA-BILL-NO                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
30719 *            MOVE 'Y'            TO WS-END-OF-DATA                        
30719              CONTINUE                                             
               ELSE                                                     
                  DISPLAY '** ERROR ON 7100-SELECT-BILL-HEADER **'      
                  DISPLAY '**     RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
                  DISPLAY '**     PROCESSING TERMINATED        **'      
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      THIS PARAGRAPH IS USED TO SELECT THE ARCHIVE MONTH    **          
      **      FROM TABLE CSS_MODEL_SQL.                             **          
      ****************************************************************          
      *                                                                         
       7150-GET-ARCHIVE-MONTH.                                          
      *                                                                         
           MOVE '7150'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT DATEADD( MONTH, -(:WS-ARCHIVE-DATA), 
              IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ),  
                 CIS.DAYS (DATEADD( MONTH, -(:WS-ARCHIVE-DATA), 
              IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) )) - (CIS.DAYS(
              DATEADD( MONTH, -(:WS-ARCHIVE-DATA), 
              IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))/7 * 7)                   
               INTO  :WS-WORK-DATE,                                     
                     :WS-DAY                                            
               FROM CSS_MODEL_SQL                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE(:WS-WORK-DATE) - (:WS-ARCHIVE-DATA) MONTHS,          
MFA-TR*          DAYS (DATE(:WS-WORK-DATE) - (:WS-ARCHIVE-DATA)                 
MFA-TR*          MONTHS) - (INTEGER(DAYS(DATE(:WS-WORK-DATE)                    
MFA-TR*          - (:WS-ARCHIVE-DATA) MONTHS)/7) * 7)                           
MFA-TR*        INTO  :WS-WORK-DATE,                                             
MFA-TR*              :WS-DAY                                                    
MFA-TR*        FROM CSS_MODEL_SQL                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** ERROR ON 7150-GET-ARCHIVE-MONTH **'          
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      PROCESSING TERMINATED      **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      THIS PARAGRAPH IS USED TO SELECT THE NEXT CURRENT DAY **          
      **      FROM TABLE CSS_MODEL_SQL.                             **          
      ****************************************************************          
      *                                                                         
       7180-GET-NEXT-DAY.                                               
      *                                                                         
           MOVE '7180'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
                SELECT DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ),                    
                  CIS.DAYS (DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))                   
                  - (CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))/7 * 7) 
                INTO  :WS-WORK-DATE,                                    
                      :WS-DAY                                           
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DATE(:WS-WORK-DATE) + 1 DAYS,                            
MFA-TR*           DAYS (DATE(:WS-WORK-DATE) + 1 DAYS)                           
MFA-TR*           - (INTEGER(DAYS(DATE(:WS-WORK-DATE) + 1 DAYS)/7) * 7)         
MFA-TR*         INTO  :WS-WORK-DATE,                                            
MFA-TR*               :WS-DAY                                                   
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                CONTINUE                                                
            ELSE                                                        
               DISPLAY '**   ERROR ON 7180-GET-NEXT-DAY    **'          
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      PROCESSING TERMINATED      **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      THIS PARAGRAPH IS USED TO DETERMINE IF THE DATE       **          
      **      SPECIFIED IS A HOLIDAY.                               **          
      ****************************************************************          
      *                                                                         
       7200-SELECT-HOLIDAY.                                             
      *                                                                         
           MOVE '7200'                 TO WS-ACTIVE-PARAGRAPH.          
           MOVE ZEROS                  TO WS-ROW-COUNT                  
      *                                                                         
           EXEC SQL                                                     
               SELECT COUNT (*)                                         
               INTO  :WS-ROW-COUNT                                      
               FROM CSS_HOLIDAY                                         
               WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) )                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT (*)                                                 
MFA-TR*        INTO  :WS-ROW-COUNT                                              
MFA-TR*        FROM CSS_HOLIDAY                                                 
MFA-TR*        WHERE HOLIDAY_DT = :WS-WORK-DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**   ERROR ON 7200-SELECT-HOLIDAY  **'          
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      PROCESSING TERMINATED      **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7300-CHECK-FOR-CANCEL.                                           
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CANCEL-IND                                     
                FROM CSS_BILLING_DET                                    
               WHERE CODE_BILL_ITM_IND  = :WS-CANCEL                    
                 AND BILL_NO            = :GA-BILL-NO                   
                 AND CODE_UTIL_TYPE     = :GA-CODE-UTIL-TYPE            
                 AND IC_NO              = :GA-IC-NO                     
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :GA-BILL-ITEM-TIMESTMP
              )        
                 AND ACCOUNT_NO         = :GA-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CANCEL-IND                                             
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*        WHERE CODE_BILL_ITM_IND  = :WS-CANCEL                            
MFA-TR*          AND BILL_NO            = :GA-BILL-NO                           
MFA-TR*          AND CODE_UTIL_TYPE     = :GA-CODE-UTIL-TYPE                    
MFA-TR*          AND IC_NO              = :GA-IC-NO                             
MFA-TR*          AND BILL_ITEM_TIMESTMP = :GA-BILL-ITEM-TIMESTMP                
MFA-TR*          AND ACCOUNT_NO         = :GA-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '**   ERROR ON 7300-CHECK-FOR-CANCEL  **'         
              DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '**      PROCESSING TERMINATED      **'           
              DISPLAY '** ACCOUNT NO. = ' GA-ACCOUNT-NO                 
              DISPLAY '** BILL NO.    = ' GA-BILL-NO                    
              DISPLAY '** UTIL TYPE   = ' GA-CODE-UTIL-TYPE             
              DISPLAY '** IC NO       = ' GA-IC-NO                      
              DISPLAY '** TIME STAMP  = ' GA-BILL-ITEM-TIMESTMP         
              DISPLAY '** BILL IND    = ' WS-CANCEL                     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7400-CHECK-FOR-REBILL.                                           
           EXEC SQL                                                     
              SELECT BILL_NO,                                           
                     IIF(TRY_CAST(REVENUE_MONTH AS INT) IS NULL, 
              CIS.INTEGER(REVENUE_MONTH), CAST(REVENUE_MONTH AS INT)) 
           REVENUE_MONTH                                      
                INTO :WS-REBILL-BILL-NO :WS-NULL-IND2,                  
                     :WS-REBILL-REV-MONTH                               
                FROM CSS_BILLING_DET BG2                                
               WHERE BG2.ACCOUNT_NO     = :GA-ACCOUNT-NO                
                 AND BG2.CODE_BILL_CALC = :WS-NON-CALC-BILL             
                 AND BG2.CODE_UTIL_TYPE = :GA-CODE-UTIL-TYPE            
                 AND BG2.IC_NO          = :GA-IC-NO                     
30719            AND BG2.CODE_BILL_ITM_TYPE = 'B'                       
                 AND BG2.BILL_ITEM_TIMESTMP                             
                   = CIS.CHAR2TIMESTAMP(:GA-BILL-ITEM-TIMESTMP)                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_NO,                                                   
MFA-TR*              REVENUE_MONTH                                              
MFA-TR*         INTO :WS-REBILL-BILL-NO :WS-NULL-IND2,                          
MFA-TR*              :WS-REBILL-REV-MONTH                                       
MFA-TR*         FROM CSS_BILLING_DET BG2                                        
MFA-TR*        WHERE BG2.ACCOUNT_NO     = :GA-ACCOUNT-NO                        
MFA-TR*          AND BG2.CODE_BILL_CALC = :WS-NON-CALC-BILL                     
MFA-TR*          AND BG2.CODE_UTIL_TYPE = :GA-CODE-UTIL-TYPE                    
MFA-TR*          AND BG2.IC_NO          = :GA-IC-NO                             
MFA-TR*          AND BG2.CODE_BILL_ITM_TYPE = 'B'                               
MFA-TR*          AND BG2.BILL_ITEM_TIMESTMP                                     
MFA-TR*            = :GA-BILL-ITEM-TIMESTMP                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '**   ERROR ON 7400-CHECK-FOR-REBILL  **'         
              DISPLAY '**   PART 1                          **'         
              DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '**      PROCESSING TERMINATED      **'           
              DISPLAY '** ACCOUNT NO. = ' GA-ACCOUNT-NO                 
              DISPLAY '** BILL NO.    = ' GA-BILL-NO                    
              DISPLAY '** UTIL TYPE   = ' GA-CODE-UTIL-TYPE             
              DISPLAY '** IC NO       = ' GA-IC-NO                      
              DISPLAY '** TIME STAMP  = ' GA-BILL-ITEM-TIMESTMP         
              DISPLAY '** BILL CALC   = ' WS-NON-CALC-BILL              
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
           IF WS-NULL-IND2 >= 0                                         
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                 
                INTO :WS-REBILL-ITEM-TIMESTMP :WS-NULL-IND2             
                FROM CSS_BILLING_DET BG                                 
               WHERE BG.CODE_BILL_CALC    = :WS-NORMAL-BILL             
                 AND BG.CODE_UTIL_TYPE    = :GA-CODE-UTIL-TYPE          
                 AND BG.IC_NO             = :GA-IC-NO                   
                 AND BG.ACCOUNT_NO        = :GA-ACCOUNT-NO              
                 AND BG.BILL_NO           = :WS-REBILL-BILL-NO          
                 AND BG.REV_MTH_ORIG_BILL = :WS-REBILL-REV-MONTH        
30071            AND                                                    
30071             (BG.CODE_UTIL_TYPE  = 'E'                             
30071            OR                                                     
30071             (BG.CODE_UTIL_TYPE  = 'G' AND                         
30071              BG.REV_RPT_CD <> 'T'))                               
           END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_ITEM_TIMESTMP                                         
MFA-TR*         INTO :WS-REBILL-ITEM-TIMESTMP :WS-NULL-IND2                     
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*        WHERE BG.CODE_BILL_CALC    = :WS-NORMAL-BILL                     
MFA-TR*          AND BG.CODE_UTIL_TYPE    = :GA-CODE-UTIL-TYPE                  
MFA-TR*          AND BG.IC_NO             = :GA-IC-NO                           
MFA-TR*          AND BG.ACCOUNT_NO        = :GA-ACCOUNT-NO                      
MFA-TR*          AND BG.BILL_NO           = :WS-REBILL-BILL-NO                  
MFA-TR*          AND BG.REV_MTH_ORIG_BILL = :WS-REBILL-REV-MONTH                
MFA-TR*          AND                                                            
MFA-TR*           (BG.CODE_UTIL_TYPE  = 'E'                                     
MFA-TR*          OR                                                             
MFA-TR*           (BG.CODE_UTIL_TYPE  = 'G' AND                                 
MFA-TR*            BG.REV_RPT_CD <> 'T'))                                       
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL


           END-IF.                                                    
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T33412                                                OR WS-811         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '**   ERROR ON 7400-CHECK-FOR-REBILL  **'         
              DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
                      '     **'                                         
              DISPLAY '**      PROCESSING TERMINATED        **'         
              DISPLAY '** ACCOUNT NO. = ' GA-ACCOUNT-NO                 
              DISPLAY '** BILL NO.    = ' WS-REBILL-BILL-NO             
              DISPLAY '** UTIL TYPE   = ' GA-CODE-UTIL-TYPE             
              DISPLAY '** IC NO       = ' GA-IC-NO                      
              DISPLAY '** BILL CALC   = ' WS-NORMAL-BILL                
              DISPLAY '** REV MONTH   = ' WS-REBILL-REV-MONTH           
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      DELETES RECORDS FROM CSS_INTERVAL_READ WHICH HAVE A   **          
      **      CALCULATED BILL AND HAVE A BILLED DATE ONE MONTH AGO  **          
      **      OR OLDER.                                             **          
      ****************************************************************          
      *                                                                         
       8100-DELETE-IDR-RECORDS.                                         
      *                                                                         
           MOVE '8100'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM CSS_INTERVAL_READ                            
               WHERE BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :GA-BILL-ITEM-TIMESTMP
              )        
PRDFIX           AND CODE_UTIL_TYPE = :GA-CODE-UTIL-TYPE                
                 AND METER_NO       = :GA-METER-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_INTERVAL_READ                                    
MFA-TR*        WHERE BILL_ITEM_TIMESTMP = :GA-BILL-ITEM-TIMESTMP                
MFA-TR*          AND CODE_UTIL_TYPE = :GA-CODE-UTIL-TYPE                        
MFA-TR*          AND METER_NO       = :GA-METER-NO                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
30401      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
30401         IF GA-METER-NO = WS-METER-NO AND                          
30401                 GA-BILL-ITEM-TIMESTMP = WS-BILL-ITEM-TIMESTMP     
30401            CONTINUE                                               
30401         ELSE                                                      
30401            MOVE GA-ACCOUNT-NO         TO WS-COMMIT-ACCT-NO        
30401            MOVE GA-BILL-ITEM-TIMESTMP TO WS-BILL-ITEM-TIMESTMP    
30401            MOVE GA-CODE-UTIL-TYPE     TO WS-CODE-UTIL-TYPE        
30401            MOVE GA-METER-NO           TO WS-METER-NO              
30401            PERFORM 8900-COMMIT THRU 8900-EXIT                     
30401         END-IF                                                    
30401      END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** ERROR ON 8100-DELETE-IDR-RECORDS **'         
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      PROCESSING TERMINATED       **'         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      UPDATES IDR_INFO_RETENT_DATE TO NULLS.                **          
      ****************************************************************          
      *                                                                         
       8200-UPDATE-IDR-RECORDS.                                         
      *                                                                         
           MOVE '8200'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_MTR_IDENT_HIST                                
               SET IDR_INFO_RETENT_DT   = IIF(TRY_CONVERT(DATE, 
                                                :GA-IDR-INFO-RETENT-DT 
                                                           :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :GA-IDR-INFO-RETENT-DT 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:GA-IDR-INFO-RETENT-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:GA-IDR-INFO-RETENT-DT 
                                                           :WS-NULL-IND
              ), CONVERT(DATE, :GA-IDR-INFO-RETENT-DT :WS-NULL-IND) )          
TP2842         WHERE ACCOUNT_NO         = :GA-ACCOUNT-NO                
TP2842           AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :GA-BILL-ITEM-TIMESTMP
              )        
TP2842           AND BILL_NO            = :GA-BILL-NO                   
TP2842           AND CODE_UTIL_TYPE     = :GA-CODE-UTIL-TYPE            
TP2842           AND IC_NO              = :GA-IC-NO                     
TP2842           AND MTR_REF_NO         = :GA-MTR-REF-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MTR_IDENT_HIST                                        
MFA-TR*        SET IDR_INFO_RETENT_DT   = :GA-IDR-INFO-RETENT-DT                
MFA-TR*                                   :WS-NULL-IND                          
MFA-TR*        WHERE ACCOUNT_NO         = :GA-ACCOUNT-NO                        
MFA-TR*          AND BILL_ITEM_TIMESTMP = :GA-BILL-ITEM-TIMESTMP                
MFA-TR*          AND BILL_NO            = :GA-BILL-NO                           
MFA-TR*          AND CODE_UTIL_TYPE     = :GA-CODE-UTIL-TYPE                    
MFA-TR*          AND IC_NO              = :GA-IC-NO                             
MFA-TR*          AND MTR_REF_NO         = :GA-MTR-REF-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** ERROR ON 8200-UPDATE-IDR-RECORDS **'         
               DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**      PROCESSING TERMINATED       **'         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
30401 ****************************************************************          
30401 *  ISSUES A COMMIT POINT                                      **          
30401 ****************************************************************          
      *                                                                         
30401  8900-COMMIT.                                                     
      *                                                                         
30401      EXEC SQL                                                     
30401         COMMIT                                                    
30401      END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
30401      COMPUTE WS-NBR-COMMIT = WS-NBR-COMMIT + 1.                   
      *                                                                         
30401      DISPLAY 'COMMIT POINT# ' WS-NBR-COMMIT ' TAKEN.'             
30401              ' ACCOUNT-NO = ' WS-COMMIT-ACCT-NO                   
30401              ' METER-NO = '   WS-METER-NO                         
30401              ' UTIL TYPE = '  WS-CODE-UTIL-TYPE                   
30401              ' TIMESTAMP = '  WS-BILL-ITEM-TIMESTMP.              
      *                                                                         
30401  8900-EXIT.                                                       
30401      EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  TERMINATE                                                 **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
30401      DISPLAY 'NUMBER OF COMMITS FOR PCSBW300 = ' WS-NBR-COMMIT.   
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-    THIS INCLUDES THE DB2 SQL ABEND MODULE           **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
