       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW185.                                        
       INSTALLATION.                                                    
       DATE-WRITTEN.   OCT  2011.                                       
           DATE-COMPILED.                                               
      *****************************************************************         
      **                                                             **         
      **             SOUTH CAROLINA ELECTRICITY  & GAS               **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                     DB2                        *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** --------   --------      -----------------------------------**         
      ** 04/25/16   NC94746       NEW CODE FOR ABE-IEE-IF70          **         
PRJ914** 05/20/16   NC94746       Remove Skip registers              **         
P00914** 06/07/16   NC94746       Remove duplicate demand registers  **         
P00914** 08/30/16   NC94746       Format co-gen skip reads correctly **         
A#5347** 10/20/16   SS95855       Fix Array for CSS_MTR_RD_FMT       **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSBW185 NARRATIVE                        
      *                                                                         
           THIS PROGRAM REFORMATS FIOBW85 (MDMS BILLING OUTPUT FILE)    
           TO VENDOR INDEPENDENT FORMAT FIOBW06. ALSO UPDATES           
           ROUTE_HEADER WITH METER COUNTS ON EACH CYCLE.                
      /                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      * SELECT STMT FOR BW85 FILE  *                                            
       COPY CSSBW85.                                                            
      * SELECT STMT FOR BW06 FILE  *                                            
       COPY CSSBW06.                                                            
       COPY CSSBW06R.                                                           
      /                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *** FD STMT FOR BW85 FILE                                                 
       COPY CFDBW85.                                                            
       01  FIOBW85-REC                  PIC X(200).                     
      *** FD STMT FOR BW06 FILE                                                 
       COPY CFDBW06.                                                            
       01  FIOBW06-REC                  PIC X(280).                     
      *** FD STMT FOR BW06R FILE                                                
       COPY CFDBW06R.                                                           
       01  FIOBW06R-REC                 PIC X(280).                     
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-RD-FMT  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW185'.
MSQ017     COPY MFASQLM.
      *                                                                         
       COPY FIOBW06.                                                            
      *                                                                         
      ***************************************************************           
      * FCA00-KEY          *                                                    
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      * IO AREA FOR PARM INPUT FILE 'A' *                                       
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *    DB2 TABLE DCLGENS USING IN THIS PROGRAM                              
      ******************************************************************        
      *----------------------------------------------------------------*        
      * CSS_ACCOUNT (AT)                                                        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_UTIL_ENVRNMT (UT)                                                   
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_CUST_PREM_HIST (CH)                                                 
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_READ_WINDOW (RW)                                                    
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_MTRD_ENVRNMT (MN)                                                   
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_MTR_RD_FMT (OA)                                                     
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE TBRDFMT                                                   
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_ROUTE_HEADER (RH)                                                   
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE TBRTEHDR                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_JOB_PARM (G6)                                                       
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_HOLIDAY (J8)                                                        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_RESTART (RF)                                                        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE TBRESTRT                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_ELEC_METER (EM)                                                     
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_RATE_USE_SEASN (RS)                                                 
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBRTUSES                                                 
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_RATE_CREATOR (RT)                                                   
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBRTCRTR                                                 
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_RATE_VRSN_DEF (J4)                                                  
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBRTVRSN                                                 
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CSS_MDM_SS_INTF (1D)                                                    
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBMDMINT                                                 
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      * CSS_MDM_SS_INTF_CH (1E)                                                 
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBMDMCHG                                                 
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      * SQL COMM AREA                                                           
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
       01 WS-UNSTRING-BW85-REC.                                         
          05 WS-BW85-METER-ID              PIC X(12).                   
          05 WS-BW85-REGISTER-CODE         PIC X(05).                   
          05 WS-BW85-READING-TMST          PIC X(17).                   
          05 WS-BW85-READING-VALUE         PIC X(20).                   
          05 WS-BW85-SKIP-CODE             PIC X(05).                   
          05 WS-BW85-READ-QUALIFIER        PIC X(01).                   
          05 WS-BW85-REQUEST-TYPE          PIC X(15).                   
          05 WS-BW85-PASS-THRU1            PIC X(20).                   
          05 WS-BW85-PASS-THRU2            PIC X(21).                   
          05 WS-BW85-PASS-THRU3            PIC X(20).                   
          05 WS-BW85-ESTIMATE-FLAG         PIC X(01).                   
          05 WS-BW85-HIGH-LOW-FLAG         PIC X(01).                   
      *                                                                         
       01 WS-TEMP-VAR-AREA.                                             
          05 WS-BD-METER-ID.                                            
             10 WS-BD-COMPANY-NO           PIC X(02).                   
             10 WS-BD-UTIL-TYPE            PIC X(01).                   
             10 WS-BD-METER-NO             PIC X(09).                   
          05 WS-BD-REGISTER-CODE.                                       
             10 WS-BD-REG-TYPE             PIC X(01).                   
             10 WS-BD-CODE-USAGE-TYPE      PIC X(01).                   
             10 WS-BD-CODE-TIME-PERIOD     PIC 9(01).                   
             10 WS-BD-CODE-TOU-SEASN       PIC X(01).                   
             10 WS-BD-CODE-USAGE-ID        PIC X(01).                   
          05 WS-BD-READ-DATE-TIME.                                      
             10 WS-BD-READ-DATE-MM         PIC X(02) VALUE SPACES.      
             10 WS-BD-READ-DATE-DD         PIC X(02) VALUE SPACES.      
             10 WS-BD-READ-DATE-CC         PIC X(02) VALUE SPACES.      
             10 WS-BD-READ-DATE-YY         PIC X(02) VALUE SPACES.      
             10 FILLER                     PIC X(01) VALUE SPACES.      
             10 WS-BD-READ-TIME            PIC X(08) VALUE SPACES.      
          05 WS-BD-READ-VAL-DIGITS         PIC 9(15) VALUE ZEROS.       
          05 WS-BD-READ-VAL-DECIMALS       PIC X(09) VALUE SPACES.      
          05 WS-BD-READ-VAL-DEC1           PIC 9(09) VALUE ZEROS.       
          05 WS-BD-READ-VAL-DEC2 REDEFINES WS-BD-READ-VAL-DEC1          
                                           PIC V9(09).                  
          05 WS-DB2-DATE                   PIC X(10) VALUE SPACES.      
          05 WS-SEASN-MMDD-NUM             PIC 9(04).                   
          05 WS-SEASN-MMDD-AN REDEFINES WS-SEASN-MMDD-NUM.              
             10 WS-SEASN-TEMP-MM           PIC 9(2).                    
             10 WS-SEASN-TEMP-DD           PIC 9(2).                    
          05 WS-SEASN1-END-DATE.                                        
             10 WS-SEASN1-END-CCYY         PIC 9(4).                    
             10 FILLER                     PIC X(1) VALUE '-'.          
             10 WS-SEASN1-END-MM           PIC 9(2).                    
             10 FILLER                     PIC X(1) VALUE '-'.          
             10 WS-SEASN1-END-DD           PIC 9(2).                    
          05 WS-SEASN2-END-DATE.                                        
             10 WS-SEASN2-END-CCYY         PIC 9(4).                    
             10 FILLER                     PIC X(1) VALUE '-'.          
             10 WS-SEASN2-END-MM           PIC 9(2).                    
             10 FILLER                     PIC X(1) VALUE '-'.          
             10 WS-SEASN2-END-DD           PIC 9(2).                    
          05 WS-WORK-DATE.                                              
             10 WS-WORK-CCYY               PIC 9(04).                   
             10 FILLER                     PIC X(01).                   
             10 WS-WORK-MM                 PIC 9(02).                   
             10 FILLER                     PIC X(01).                   
             10 WS-WORK-DD                 PIC 9(02).                   
      *                                                                         
          05 WS-OPTIMUM-READ-DATE.                                      
             10 WS-OPTM-RD-CC              PIC X(02).                   
             10 WS-OPTM-RD-YY              PIC X(02).                   
             10                            PIC X(01).                   
             10 WS-OPTM-RD-MM              PIC X(02).                   
             10                            PIC X(01).                   
             10 WS-OPTM-RD-DD              PIC X(02).                   
          05 WS-PREV-SERVICE-POINT-ID      PIC X(21).                   
          05 WS-NULL-IND                   PIC S9(4) COMP.              
          05 WS-PREV-READ-CYCLE            PIC X(02) VALUE SPACES.      
          05 WS-PREV-REGISTER-CODES        PIC X(05).                   
          05 WS-IDF-READ-AND-STATUS        PIC X(20).                   
          05 WS-IDF-METER-READ             PIC X(19).                   
          05 WS-IDF-READ-STATUS            PIC X(01).                   
          05 WS-ACCOUNT-NO-NUM             PIC 9(13) VALUE ZEROS.       
          05 WS-METER-READ-NUM             PIC 9(10).                   
          05 WS-METER-READ-DEC             PIC X(09).                   
          05 WS-METER-READ-DEC1            PIC 9(09).                   
          05 WS-METER-READ-DEC2 REDEFINES WS-METER-READ-DEC1            
                                           PIC V9(09).                  
          05 WS-RAW-METER-READ             PIC 9(12)V9(3).              
      *                                                                         
       01 WS-ABEND-AREA.                                                
          05 WS-ABEND-SPACE                PIC X VALUE SPACE.           
          05 WS-ABEND-NUMERIC REDEFINES WS-ABEND-SPACE                  
                                           PIC 9.                       
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-90                         PIC X(02)  VALUE '90'.       
          05 WS-H                          PIC X(01)  VALUE 'H'.        
          05 WS-G                          PIC X(01)  VALUE 'G'.        
          05 WS-E                          PIC X(01)  VALUE 'E'.        
          05 WS-YES                        PIC X(01)  VALUE 'Y'.        
          05 WS-Y                          PIC X(01)  VALUE 'Y'.        
          05 WS-N                          PIC X(01)  VALUE 'N'.        
          05 WS-I                          PIC X(01)  VALUE 'I'.        
          05 WS-NO                         PIC X(01)  VALUE 'N'.        
          05 WS-ONE                        PIC X(01)  VALUE '1'.        
          05 WS-PGRMNAME                   PIC X(08)  VALUE 'PCSBW185'. 
          05 PROGRAM-NAME                  PIC X(08)  VALUE 'PCSBW185'. 
          05 RS-RETURN-CODE                PIC S9(09) VALUE +000 COMP.  
          05 RS-RETURN-CODE-DISP           PIC S9(09) VALUE +000 COMP.  
          05 WS-PSNC                       PIC X(02)  VALUE '26'.       
          05 WS-ROWS-EXISTS                PIC X(01)  VALUE ' '.        
          05 WS-RRI-0                      PIC X(01)  VALUE '0'.        
          05 WS-811                        PIC S9(09) VALUE -811 COMP.  
          05 SCSCB077                      PIC X(08)  VALUE 'SCSCB077'. 
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 WS-ACCOUNT-FOUND-SW           PIC 9(01)  VALUE 0.          
             88 ACCOUNT-NOT-FOUND                     VALUE 0.          
             88 LATEST-ACCOUNT-FOUND                  VALUE 1.          
             88 ACCOUNT-METER-SKIP                    VALUE 2.          
          05 WS-USE-MDM-HILO-SW            PIC 9(01)  VALUE 0.          
             88 USE-MDM-HILO-FLAGS                    VALUE 0.          
             88 NOT-USE-MDM-HILO-FLAGS                VALUE 1.          
          05 WS-SEASON-RATE-SW             PIC 9(01)  VALUE 0.          
             88 NON-SEASON-RATE                       VALUE 0.          
             88 SEASON-RATE-BY-USAGE                  VALUE 1.          
          05 WS-REG-MATCH-FOUND-FL         PIC 9(01)  VALUE 0.          
             88 NO-REG-MATCH-FOUND                    VALUE 0.          
             88 REG-MATCH-FOUND                       VALUE 1.          
          05 WS-FBW85-STATUS               PIC X(02).                   
             88 FBW85-SUCCESSFUL                      VALUE '00'.       
             88 FBW85-READ-EOF                        VALUE '10'.       
          05 WS-FBW06-STATUS               PIC X(02).                   
             88 FBW06-SUCCESSFUL                      VALUE '00'.       
          05 WS-FBW06R-STATUS              PIC X(02).                   
             88 FBW06R-SUCCESSFUL                     VALUE '00'.       
             88 FBW06R-END-OF-FILE                    VALUE '10'.       
          05 WS-BW85-EOF                   PIC X(01)  VALUE 'N'.        
               88  BW85-EOF-REACHED                   VALUE 'Y'.        
      *                                                                         
       01 WS-CURRENT-DATE.                                              
          03 WS-CURRENT-DATE-CC            PIC 9(02).                   
          03 WS-CURRENT-DATE-YY            PIC 9(02).                   
          03 FILLER                        PIC X(01)  VALUE '-'.        
          03 WS-CURRENT-DATE-MM            PIC 9(02).                   
          03 FILLER                        PIC X(01)  VALUE '-'.        
          03 WS-CURRENT-DATE-DD            PIC 9(02).                   
      *                                                                         
       01 WS-WORK-AREA.                                                 
          05 WS-REVENUE-MONTH              PIC  X(06) VALUE SPACES.     
          05 WS-COMPANY-NO                 PIC  X(02) VALUE '01'.       
          05 WS-SAVE-COMPANY-NO            PIC  X(02) VALUE SPACES.     
          05 WS-NO-MO-RECORDS              PIC S9(07) COMP.             
          05 WS-MTR-COUNT                  PIC S9(07) COMP.             
          05 WS-EXISTS                     PIC  X(01) VALUE SPACE.      
          05 WS-ACCOUNT-NO-PART            PIC S9(13)V COMP-3 VALUE 0.  
          05 WS-PART-COUNT                 PIC S9(04) COMP VALUE 0.     
          05 WS-NO-MORE-ROWS               PIC  X(01) VALUE 'N'.        
          05 WS-NUM-OF-DIALS               PIC  9(01) VALUE 5.          
          05 WS-EXCESS-INDX-DGT            PIC  9(08) VALUE ZERO.       
          05 WS-METER-NO                   PIC  X(09).                  
          05 WS-NEW-METER-NO               PIC  X(09).                  
          05 WS-DATE-TRANS                 PIC  X(10) VALUE SPACES.     
          05 WS-COUNT-UNSUCCESSFUL-ROWS    PIC S9(04) COMP-3 VALUE 0.   
          05 WS-METER-FOUND-FL             PIC  9(01) VALUE 0.          
             88 METER-NOT-FOUND                       VALUE 0.          
             88 NEW-METER-FOUND                       VALUE 1.          
             88 OLD-METER-FOUND                       VALUE 2.          
             88 METER-FOUND                           VALUE 1 2.        
          05 WS-CURR-READ-VALUE            PIC  9(08) VALUE ZEROS.      
          05 WS-CURNT-CHGD-RD-VAL          PIC  9(08) VALUE ZEROS.      
      *                                                                         
       01 WS-WORK-QUEUE-DIRECTION.                                      
          05 WS-CATEGORY-ID-141            PIC S9(04) COMP VALUE 141.   
          05 WS-CATEGORY-ID-528            PIC S9(04) COMP VALUE 528.   
          05 WS-CATEGORY-ID-157            PIC S9(04) COMP VALUE 157.   
          05 WS-CATEGORY-ID-173            PIC S9(04) COMP VALUE 173.   
          05 WS-CATEGORY-ID-282            PIC S9(04) COMP VALUE 282.   
          05 WS-CATEGORY-ID-283            PIC S9(04) COMP VALUE 283.   
          05 WS-CATEGORY-ID-284            PIC S9(04) COMP VALUE 284.   
          05 WS-CATEGORY-ID-289            PIC S9(04) COMP VALUE 289.   
          05 WS-CATEGORY-ID-232            PIC S9(04) COMP VALUE 232.   
          05 WS-CATEGORY-ID-15             PIC S9(04) COMP VALUE  15.   
          05 WS-ROUTING-CATEGORY           PIC  X(01) VALUE '4'.        
          05 WS-NORMAL-PRIORITY            PIC  X(01) VALUE 'N'.        
          05 WS-HOLD-WQ-CATEGORY           PIC  9(03).                  
          05 WS-COMMENTS-TEMP              PIC  X(223).                 
      *                                                                         
       01 WS-WORK-QUEUE-MSGS.                                           
          05 WS-MISSING-MRF-MSG.                                        
             10 FILLER                     PIC X(30) VALUE              
                       'SMARTSYNCH WARNING FOR METER: '.                
             10 WS-WQ-METER-NO             PIC X(09).                   
             10 FILLER                     PIC X(13) VALUE              
                          ' METER TYPE: '.                              
             10 WS-WQ-DMT                  PIC X(02).                   
             10 WS-WQ-PGM-ID               PIC X(02).                   
             10 WS-WQ-MRS-CD               PIC X(01).                   
             10 WS-WQ-UTIL-TYPE            PIC X(01).                   
             10 FILLER                     PIC X(36) VALUE              
                ' RECORDS NOT FOUND IN CSS_MTR_RD_FMT'.                 
             10 FILLER                     PIC X(25) VALUE              
                ' FOR THE GIVEN METER TYPE'.                            
       01 WS-RESTART-DATA.                                              
          05 WS-RESTART-PROCESS-TYPE       PIC 9(01).                   
          05 WS-RESTART-JOB-COMPLETE       REDEFINES                    
             WS-RESTART-PROCESS-TYPE       PIC X(01).                   
          05 WS-RESTART-JOB-STATUS         PIC X(01).                   
             88 WS-RUN-COMPLETED-NO-PROBLEMS         VALUE 'A'.         
             88 WS-RERUN-COMPLETED                   VALUE 'B'.         
             88 WS-RERUN-PENDING                     VALUE 'C'.         
          05 WS-RESTART-INPUT-DATE         PIC X(10) VALUE SPACES.      
          05 WS-RESTART-METER-ID           PIC X(12) VALUE SPACES.      
          05 WS-RESTART-REGISTER-CODE      PIC X(05) VALUE SPACES.      
          05 WS-RESTART-CHKP-SEQ-NO        PIC 9(07) VALUE ZERO.        
          05 WS-RESTART-RECORD-NO          PIC 9(09) VALUE ZERO.        
          05 WS-RESTART-FBW06-REC-CNTR     PIC 9(09) VALUE ZERO.        
      *                                                                         
       01 WS-RESTART-MISC.                                              
          05 WS-COMMIT-REQ-SW              PIC 9(1) VALUE 0.            
             88 COMMITS-REQUIRE                     VALUE 0.            
             88 COMMITS-NOT-REQUIRE                 VALUE 1.            
          05 WS-RESTART-DATA-LENGTH        PIC S9(04) COMP VALUE +54.   
          05 WS-IS-THIS-A-RESTART          PIC X(01) VALUE 'N'.         
             88 WS-THIS-IS-A-RESTART                 VALUE 'Y'.         
          05 WS-RESTART-REQ                PIC X(01).                   
          05 WS-DEFAULT-RESTART-REQ        PIC X(01) VALUE 'N'.         
          05 WS-FCSBW85-REC-CNTR           PIC S9(09) COMP VALUE ZERO.  
          05 WS-FCSBW06-REC-CNTR           PIC S9(09) COMP VALUE ZERO.  
          05 WS-CHKP-SEQ-NO                PIC 9(05) VALUE ZERO.        
          05 WS-COMMIT-ROUTES              PIC 9(07) VALUE ZERO.        
          05 WS-FLAG-TO-TURN-OFF-COMMITS   PIC 9(04) VALUE 9999.        
          05 WS-DEFAULT-CHKP-LUW-LIMIT     PIC 9(04) VALUE 4.           
          05 WS-DEFAULT-CHKP-UPD-LIMIT     PIC 9(04) VALUE 20.          
          05 WS-CHKP-LUW-LIMIT             PIC 9(04).                   
          05 WS-CHKP-UPD-LIMIT             PIC 9(04).                   
          05 WS-DISP-FBW06-CNT             PIC ZZZ,ZZ9.                 
          05 WS-DISP-FBW85-CNT             PIC ZZZ,ZZ9.                 
      *                                                                         
       01 WS-TEMP-VAR.                                                  
          05 WS-PREV-METER-ID              PIC X(12).                   
          05 WS-DISPLAY-SQLCODE            PIC ---9.                    
          05 WS-CODE-UTIL-TYPE             PIC X(01) VALUE SPACES.      
          05 WS-MTR-READ-SOURCE-CD         PIC X(01) VALUE SPACES.      
          05 WS-REMOTE-READ-IND            PIC X(01) VALUE SPACES.      
          05 WS-PROGRAM-ID                 PIC X(02) VALUE SPACES.      
          05 WS-DIGTL-MTR-TYPE             PIC X(03) VALUE SPACES.      
          05 WS-CODE-USAGE-TYPE            PIC X(01) VALUE SPACES.      
          05 WS-CODE-TIME-PERIOD           PIC 9(04) VALUE ZEROES.      
          05 WS-CODE-TOU-SEASN             PIC X(01) VALUE SPACES.      
          05 WS-CODE-USAGE-ID              PIC X(01) VALUE SPACES.      
          05 WS-CODE-USAGE-SOURCE          PIC X(01) VALUE SPACES.      
          05 WS-CNSMPTN-READ-FL            PIC X(01) VALUE SPACES.      
          05 WS-INDEX-VALUE-CD             PIC X(01) VALUE SPACES.      
          05 WS-MTR-RD-DISP-CD             PIC X(03) VALUE SPACES.      
          05 WS-TEXT-PROMPT-RIR            PIC 9(04) VALUE ZEROES.      
          05 WS-MTR-SKIP-COUNT             PIC S9(07) COMP VALUE 0.     
          05 WS-PREV-ACCOUNT-NO            PIC 9(13).                   
          05 WS-SAVE-ACCOUNT-NO            PIC 9(13).                   
          05 WS-PREV-METER-NO              PIC X(09).                   
          05 WS-SAVE-METER-NO              PIC X(09).                   
          05 WS-READ-DIGITS                PIC S9(4) COMP VALUE 0.      
          05 WS-READ-DECIMALS              PIC S9(4) COMP VALUE 0.      
          05 WS-READ                       PIC 9(10) VALUE 0.           
          05 WS-READ-CODE                  PIC 9(02) VALUE 0.           
          05 WS-READ-CODITION              PIC 9(02) VALUE 0.           
          05 WS-ERT-READ-STATUS            PIC 9(01) VALUE 0.           
          05 WS-TEMP-FIOBW06-REC           PIC X(280) VALUE SPACES.     
          05 WS-TEMP-CODE-METER-READ       PIC X(01) VALUE SPACES.      
          05 WS-TEMP-CODE-METER-READ-F     PIC X(01) VALUE SPACES.      
COB305    05 WS-READ-TIME-ZONE        PIC S9(6)V COMP-3 VALUE 0.           
          05 WS-DST-BEGIN-LAST-YEAR        PIC X(26) VALUE SPACES.      
          05 WS-DST-BEGIN-CURR-YEAR        PIC X(26) VALUE SPACES.      
          05 WS-TOTAL-KWH-GMT-TMST         PIC X(26) VALUE SPACES.      
          05 WS-TOTAL-KWH-EST-TMST         PIC X(26) VALUE SPACES.      
          05 WS-CURR-TOT-KWHF-DTTM.                                     
             10 WS-CURR-TOT-KWHF-DATE      PIC X(10) VALUE SPACES.      
             10 WS-CURR-TOT-KWHF-TIME      PIC X(08) VALUE SPACES.      
          05 WS-CURR-TOT-KWH-DTTM.                                      
             10 WS-CURR-TOT-KWH-DATE       PIC X(10) VALUE SPACES.      
             10 WS-CURR-TOT-KWH-TIME       PIC X(08) VALUE SPACES.      
          05 WS-PREV-TOT-KWH-DTTM.                                      
             10 WS-PREV-TOT-KWH-DATE       PIC X(10) VALUE SPACES.      
             10 WS-PREV-TOT-KWH-TIME       PIC X(08) VALUE SPACES.      
          05 WS-REG-READ-DTTM.                                          
             10 WS-REG-READ-DATE           PIC X(10) VALUE SPACES.      
             10 WS-REG-READ-TIME           PIC X(08) VALUE SPACES.      
          05 WS-IDF-READ-DATE.                                          
             10 WS-IDF-READ-DATE-MM        PIC X(02) VALUE SPACES.      
             10 FILLER                     PIC X(01) VALUE SPACES.      
             10 WS-IDF-READ-DATE-DD        PIC X(02) VALUE SPACES.      
             10 FILLER                     PIC X(01) VALUE SPACES.      
             10 WS-IDF-READ-DATE-YY        PIC X(02) VALUE SPACES.      
          05 WS-SAVE-READ-DATE.                                         
             10 WS-SAVE-READ-DATE-CC       PIC X(02) VALUE SPACES.      
             10 WS-SAVE-READ-DATE-YY       PIC X(02) VALUE SPACES.      
             10 FILLER                     PIC X(01) VALUE '-'.         
             10 WS-SAVE-READ-DATE-MM       PIC X(02) VALUE SPACES.      
             10 FILLER                     PIC X(01) VALUE '-'.         
             10 WS-SAVE-READ-DATE-DD       PIC X(02) VALUE SPACES.      
          05 WS-DUMMY-VAR1                 PIC S9(4) COMP VALUE 0.      
       01 WS-FIOBW06-TABLE.                                             
          05 BW06-SUB                      PIC S9(04) COMP.             
          05 BW06-SUB1                     PIC S9(04) COMP.             
          05 WS-FIOBW06-WRITE-FL OCCURS 50 TIMES PIC X(01).             
          05 WS-FIOBW06-REC OCCURS 50 TIMES.                            
             10 WS-FBW06-ACCOUNT-NO        PIC 9(13).                   
             10 WS-FBW06-METER-NO          PIC X(09).                   
             10 WS-FBW06-CODE-UTIL-TYPE    PIC X(01).                   
             10 WS-FBW06-CODE-USAGE-TYPE   PIC X(01).                   
             10 WS-FBW06-CODE-TIME-PERIOD  PIC 9(04).                   
             10 WS-FBW06-CODE-TOU-SEASN    PIC X(01).                   
             10 WS-FBW06-CODE-USAGE-ID     PIC X(01).                   
             10 WS-FBW06-CODE-USAGE-SOURCE PIC X(01).                   
             10 FILLER                     PIC X(09).                   
             10 WS-FBW06-REG-MEASURE-CD    PIC X(03).                   
             10 WS-FBW06-METER-READING     PIC 9(12)V9(3).              
             10 WS-FBW06-DATE-READ         PIC X(10).                   
             10 WS-FBW06-TIME-READ         PIC X(08).                   
             10 WS-FBW06-CODE-METER-READ   PIC X(01).                   
             10 WS-FBW06-CODE-METER-NO-READ PIC X(01).                  
             10 WS-FBW06-MTR-COMMENT-TX    PIC X(40).                   
             10 WS-FBW06-MTR-COND-CD1      PIC X(02).                   
             10 WS-FBW06-MTR-COND-CD2      PIC X(02).                   
             10 WS-FBW06-EMPLOYEE-NO       PIC X(09).                   
             10 WS-FBW06-MTR-READ-SOURCE-CD PIC X(01).                  
             10 WS-FBW06-CNSMPTN-READ-FL   PIC X(01).                   
             10 WS-FBW06-INDEX-VALUE-CD    PIC X(01).                   
             10 WS-FBW06-READ-PROCESS-CD   PIC X(01).                   
             10 WS-FBW06-BTU-FACTOR        PIC 9(02)V9(5).              
             10 WS-FBW06-READ-ITEM-STATUS  PIC X(01).                   
             10 WS-FBW06-WORKSET-ID        PIC X(08).                   
             10 WS-FBW06-OFF-CYCLE-READ-CD PIC X(01).                   
             10 FILLER                     PIC X(127).                  
             10 WS-FBW06-DB-PART-DREC      PIC 9(01).                   
      *                                                                         
       01 WS-MTR-RD-FMT-TABLE.                                          
          05 WS-RD-FMT-COUNT               PIC 9(05) VALUE ZERO.        
          05 WS-MRF-SUB                    PIC 9(05) VALUE ZERO.        
          05 WS-MRF-TABLE.                                              
             10 TAB-CODE-UTIL-TYPE     OCCURS 1200 TIMES  PIC X(01).    
             10 TAB-DIGTL-MTR-TYPE     OCCURS 1200 TIMES  PIC X(03).    
             10 TAB-PROGRAM-ID         OCCURS 1200 TIMES  PIC X(02).    
             10 TAB-MTR-READ-SOURCE-CD OCCURS 1200 TIMES  PIC X(01).    
             10 TAB-REMOTE-READ-IND    OCCURS 1200 TIMES  PIC X(01).    
             10 TAB-CODE-USAGE-TYPE    OCCURS 1200 TIMES  PIC X(01).    
             10 TAB-CODE-TIME-PERIOD   OCCURS 1200 TIMES                
                                           PIC S9(4) USAGE COMP.        
             10 TAB-CODE-TOU-SEASN     OCCURS 1200 TIMES  PIC X(01).    
             10 TAB-CODE-USAGE-ID      OCCURS 1200 TIMES  PIC X(01).    
             10 TAB-CODE-USAGE-SOURCE  OCCURS 1200 TIMES  PIC X(01).    
             10 TAB-MTR-RD-DISP-CD     OCCURS 1200 TIMES  PIC X(03).    
             10 TAB-INDEX-VALUE-CD     OCCURS 1200 TIMES  PIC X(01).    
             10 TAB-NO-READ-DIGITS     OCCURS 1200 TIMES                
                                           PIC S9(4) USAGE COMP.        
             10 TAB-NO-READ-DECIMALS   OCCURS 1200 TIMES                
                                           PIC S9(4) USAGE COMP.        
             10 TAB-READ-SEQUENCE-NO   OCCURS 1200 TIMES                
                                           PIC S9(4) USAGE COMP.        
             10 TAB-CNSMPTN-READ-FL    OCCURS 1200 TIMES  PIC X(01).    
      *                                                                         
       01 WS-MATCH-REG-ARRAY.                                           
          05 WS-MATCH-REG-COUNT            PIC 9(05) VALUE ZERO.        
          05 WS-MRF-SUB2                   PIC 9(05) VALUE ZERO.        
          05 WS-MATCH-REG-ROW OCCURS       50  TIMES.                   
             10 ARR-CODE-USAGE-TYPE        PIC X(01).                   
             10 ARR-CODE-TIME-PERIOD       PIC S9(4) USAGE COMP.        
             10 ARR-CODE-TOU-SEASN         PIC X(01).                   
             10 ARR-CODE-USAGE-ID          PIC X(01).                   
             10 ARR-CODE-USAGE-SOURCE      PIC X(01).                   
             10 ARR-MTR-RD-DISP-CD         PIC X(03).                   
             10 ARR-INDEX-VALUE-CD         PIC X(01).                   
             10 ARR-NO-READ-DIGITS         PIC S9(4) USAGE COMP.        
             10 ARR-NO-READ-DECIMALS       PIC S9(4) USAGE COMP.        
             10 ARR-READ-SEQUENCE-NO       PIC S9(4) USAGE COMP.        
             10 ARR-CNSMPTN-READ-FL        PIC X(01).                   
             10 ARR-TEMP-CODE-USAGE-ID     PIC X(01).                   
             10 ARR-MATCH-FOUND            PIC X(01).                   
      *                                                                         
      * ABEND SWITCH         *                                                  
       COPY CWS09900.                                                           
                                                                        
      * WARNING DATA         *                                                  
       COPY CWS00303.                                                           
                                                                        
      * WS ABEND WORK AREA   *                                                  
       COPY CWS00010.                                                           
                                                                        
      * MISC INPUT           *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
       01 WS-MDM-HILO-DATA-PARM REDEFINES WS-INPUT-DATA-BREAKDOWN.      
          10 WS-MDM-HILO-TEXT-PARM         PIC X(19).                   
             88 MDM-HILO-FLAG             VALUE 'USE-MDM-HILO-FLAGS='.  
          10 WS-MDM-HILO-PARM              PIC  X(01).                  
          10 FILLER                        PIC  X(60).                  
      *                                                                         
      * FCA00 MISC INPUT     *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
                                                                        
      * WS NEXT BUSINESS DAY *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00315                                                  
           END-EXEC.                                                            
      *                                                                         
      *** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077                 
           EXEC SQL                                                             
                INCLUDE CWS00077                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    WORKING STORAGE COPY BOOK FOR CPDCA099                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DECLARE CURSOR TO GET ACCOUNT ASSOCIATED WITH METER            *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE MTR_CSR CURSOR  FOR                               
              SELECT AT.ACCOUNT_NO                                      
                    ,AT.PREMISE_NO                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.BILL_CYCLE                                      
                    ,AT.COMPANY_NO                                      
                    ,UT.RATE_PLAN_NO                                    
                    ,UT.READ_CYCLE                                      
                    ,UT.READ_ROUTE                                      
                    ,MN.CODE_METER_STATUS                               
                    ,MN.REMOTE_READ_IND                                 
                    ,MN.MTR_READ_SOURCE_CD                              
                    ,MN.DIGTL_MTR_TYPE                                  
                    ,MN.PROGRAM_ID                                      
               FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                   
                   ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
                   ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                   
               WHERE AT.ACCOUNT_NO     = UT.ACCOUNT_NO                  
                 AND MN.ACCOUNT_NO     = UT.ACCOUNT_NO                  
                 AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE              
                 AND MN.IC_NO          = UT.IC_NO                       
                 AND AT.COMPANY_NO     = :AT-COMPANY-NO                 
                 AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE             
                 AND MN.METER_NO       = :MN-METER-NO                   
                 AND MN.CODE_METER_STATUS <> 'K'                        
               ORDER BY AT.PREMISE_NO                                   
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MTR_CSR CURSOR  FOR                                       
MFA-TR*       SELECT AT.ACCOUNT_NO                                              
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*             ,UT.READ_CYCLE                                              
MFA-TR*             ,UT.READ_ROUTE                                              
MFA-TR*             ,MN.CODE_METER_STATUS                                       
MFA-TR*             ,MN.REMOTE_READ_IND                                         
MFA-TR*             ,MN.MTR_READ_SOURCE_CD                                      
MFA-TR*             ,MN.DIGTL_MTR_TYPE                                          
MFA-TR*             ,MN.PROGRAM_ID                                              
MFA-TR*        FROM CSS_ACCOUNT      AT                                         
MFA-TR*            ,CSS_UTIL_ENVRNMT UT                                         
MFA-TR*            ,CSS_MTRD_ENVRNMT MN                                         
MFA-TR*        WHERE AT.ACCOUNT_NO     = UT.ACCOUNT_NO                          
MFA-TR*          AND MN.ACCOUNT_NO     = UT.ACCOUNT_NO                          
MFA-TR*          AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                      
MFA-TR*          AND MN.IC_NO          = UT.IC_NO                               
MFA-TR*          AND AT.COMPANY_NO     = :AT-COMPANY-NO                         
MFA-TR*          AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                     
MFA-TR*          AND MN.METER_NO       = :MN-METER-NO                           
MFA-TR*          AND MN.CODE_METER_STATUS <> 'K'                                
MFA-TR*        ORDER BY AT.PREMISE_NO                                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DECLARE CURSOR FOR METER READ FORMAT                           *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE RD_FMT CURSOR WITH ROWSET POSITIONING FOR         
              SELECT CODE_UTIL_TYPE                                     
                    ,DIGTL_MTR_TYPE                                     
                    ,PROGRAM_ID                                         
                    ,MTR_READ_SOURCE_CD                                 
                    ,REMOTE_READ_IND                                    
                    ,CODE_USAGE_TYPE                                    
                    ,CODE_TIME_PERIOD                                   
                    ,CODE_TOU_SEASN                                     
                    ,CODE_USAGE_ID                                      
                    ,CODE_USAGE_SOURCE                                  
                    ,MTR_RD_DISP_CD                                     
                    ,INDEX_VALUE_CD                                     
                    ,NO_READ_DIGITS                                     
                    ,NO_READ_DECIMALS                                   
                    ,READ_SEQUENCE_NO                                   
                    ,CNSMPTN_READ_FL                                    
              FROM CSS_MTR_RD_FMT WITH(READUNCOMMITTED)                         
A#5347        WHERE CODE_UTIL_TYPE = 'E'                                
              ORDER BY CODE_UTIL_TYPE                                   
                     ,DIGTL_MTR_TYPE DESC                               
                     ,PROGRAM_ID                                        
                     ,MTR_READ_SOURCE_CD                                
                     ,REMOTE_READ_IND                                   
                     ,READ_SEQUENCE_NO                                  
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RD_FMT CURSOR WITH ROWSET POSITIONING FOR                 
MFA-TR*       SELECT CODE_UTIL_TYPE                                             
MFA-TR*             ,DIGTL_MTR_TYPE                                             
MFA-TR*             ,PROGRAM_ID                                                 
MFA-TR*             ,MTR_READ_SOURCE_CD                                         
MFA-TR*             ,REMOTE_READ_IND                                            
MFA-TR*             ,CODE_USAGE_TYPE                                            
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,CODE_TOU_SEASN                                             
MFA-TR*             ,CODE_USAGE_ID                                              
MFA-TR*             ,CODE_USAGE_SOURCE                                          
MFA-TR*             ,MTR_RD_DISP_CD                                             
MFA-TR*             ,INDEX_VALUE_CD                                             
MFA-TR*             ,NO_READ_DIGITS                                             
MFA-TR*             ,NO_READ_DECIMALS                                           
MFA-TR*             ,READ_SEQUENCE_NO                                           
MFA-TR*             ,CNSMPTN_READ_FL                                            
MFA-TR*       FROM CSS_MTR_RD_FMT                                               
MFA-TR*       WHERE CODE_UTIL_TYPE = 'E'                                        
MFA-TR*       ORDER BY CODE_UTIL_TYPE                                           
MFA-TR*              ,DIGTL_MTR_TYPE DESC                                       
MFA-TR*              ,PROGRAM_ID                                                
MFA-TR*              ,MTR_READ_SOURCE_CD                                        
MFA-TR*              ,REMOTE_READ_IND                                           
MFA-TR*              ,READ_SEQUENCE_NO                                          
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7210                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *********************** END OF DECLARATIVES **********************        
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
      *                                                                         
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
                                                                        
           PERFORM 0400-LOAD-RD-FMT-TAB    THRU 0400-EXIT.              
                                                                        
           PERFORM 1000-PROCESS-BW85       THRU 1000-EXIT               
                                   UNTIL BW85-EOF-REACHED.              
                                                                        
           PERFORM 3000-WRITE-CNTRL-REC    THRU 3000-EXIT.              
                                                                        
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           PERFORM 0110-OPEN-IO-FILES     THRU 0110-EXIT.               
                                                                        
           MOVE WS-COMPANY-NO                 TO  G6-COMPANY-NO.        
           PERFORM 0150-GET-PARM-DATA      THRU 0150-EXIT.              
                                                                        
      *** CHECK JOB_PARM TABLE TO GET WS-RESTART-REQ FLAG                       
           PERFORM 6235-GET-FJC01-RESTART-REQ  THRU 6235-EXIT.          
      *** CHECK CSS_RESTART TABLE TO GET PRIOR RUN LAST COMMITED DATA           
           PERFORM 0600-CHECK-FOR-RESTART    THRU 0600-EXIT.            
      *** VALIDATE JOB_PARM & CSS_RESTART STATUSES                              
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 0601-REPOSITION-INPUT-FILE  THRU 0601-EXIT        
              PERFORM 0602-REPOSITION-OUTPUT-FILE THRU 0602-EXIT        
           ELSE                                                         
              PERFORM 0610-INITIALIZE-RESTART    THRU 0610-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 5000-GET-FIOBW85-DATA THRU 5000-EXIT                 
                                                                        
           IF NOT WS-THIS-IS-A-RESTART                                  
              AND BW85-EOF-REACHED                                      
              DISPLAY '*************************************'           
              DISPLAY '*** WARNING: BW85 FILE WAS EMPTY  ***'           
              DISPLAY '*** PROGRAM WILL CREATE CNTRL RECS***'           
              DISPLAY '*************************************'           
              DISPLAY ' '                                               
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0110-OPEN-IO-FILES.                                              
      *================================================================*        
      *                                                                         
           OPEN INPUT FCSBW85-FILE.                                     
                                                                        
           IF  FBW85-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*****************************************'      
               DISPLAY '**   ERROR ON FCSBW85 OPEN INPUT       **'      
               DISPLAY '** FILE STATUS = ' WS-FBW85-STATUS              
               DISPLAY '** PROCESS TERMINATED IN 0110          **'      
               DISPLAY '*****************************************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSBW06-FILE                                     
                                                                        
           IF FBW06-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*****************************************'      
               DISPLAY '**   ERROR ON FCSBW06 OPEN OUTPUT      **'      
               DISPLAY '** FILE STATUS = ' WS-FBW06-STATUS              
               DISPLAY '** PROCESS TERMINATED IN 0110          **'      
               DISPLAY '*****************************************'      
                 PERFORM 9900-ABEND                 THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0150-GET-PARM-DATA.                                              
      *================================================================*        
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE                        
                                               THRU 6240-EXIT           
              DISPLAY 'COMMON DATE ==> ' WS-FCA00-COMMON-DATE           
              MOVE WS-FCA00-COMMON-DATE        TO WS-INPUT-DATE         
                                                  WS-NEW-BUSINESS-DAY   
              PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU                   
                     6500-NEXT-BUSINESS-DAY-EXIT                        
                     UNTIL NEXT-BUSINESS-DAY-FOUND                      
              MOVE WS-NEW-BUSINESS-DAY    TO WS-INPUT-DATE              
           END-IF                                                       
           MOVE WS-INPUT-DATE                  TO WS-CURRENT-DATE       
                                                  WS-WORK-DATE          
           MOVE WS-PGRMNAME                    TO WS-PROGRAM            
           MOVE SPACES                         TO WS-SYSIPT             
           MOVE ZEROS                          TO WS-SEQUENCE           
           MOVE WS-PARM                        TO WS-COMMAND            
           MOVE WS-KEY-AREA                    TO E-FJC01-KEY           
           PERFORM 7600-START-FCSJC01          THRU 7600-EXIT           
           PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT           
             UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                     
                OR END-OF-SYSIPT.                                       
           IF END-OF-SYSIPT                                             
              MOVE SPACES                      TO                       
                                               WS-INPUT-DATA-BREAKDOWN  
              MOVE 'COMMON'                    TO WS-PROGRAM            
              MOVE SPACES                      TO WS-SYSIPT             
              MOVE WS-DATE                     TO WS-COMMAND            
              MOVE ZERO                        TO WS-SEQUENCE           
              MOVE WS-KEY-AREA                 TO E-FJC01-KEY           
              PERFORM 7600-START-FCSJC01       THRU 7600-EXIT           
              PERFORM 7610-READ-FCSJC01        THRU 7610-EXIT           
                UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                  
                   OR END-OF-SYSIPT                                     
              IF END-OF-SYSIPT                                          
                 DISPLAY '      '                                       
                 DISPLAY '***  PROCESSING ERROR IN PCSBW185   ***'      
                 DISPLAY '***NO ACTIVE REVENUE MONTH IN COMMON***'      
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
              ELSE                                                      
                 MOVE WS-REVENUE-MONTH-PARM    TO WS-REVENUE-MONTH      
                 MOVE G6-COMPANY-NO            TO WS-COMPANY-NO         
                 PERFORM 7611-CLOSE            THRU 7611-EXIT           
              END-IF                                                    
           ELSE                                                         
              MOVE WS-REVENUE-MONTH-PARM       TO WS-REVENUE-MONTH      
              MOVE G6-COMPANY-NO               TO WS-COMPANY-NO         
              PERFORM 7611-CLOSE               THRU 7611-EXIT           
           END-IF.                                                      
      *                                                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
             AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
              SET COMMITS-NOT-REQUIRE  TO TRUE                          
              DISPLAY ' '                                               
              DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'    
              DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'           
              DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS     
                      ', INTERPRETED TO**'                              
              DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'           
              DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'           
              DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'           
              DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'           
              DISPLAY '**      PROCESSING CONTINUING      **'           
           END-IF.                                                      
      *                                                                         
      *** GET MDM HIGH/LOW ALLOW FLAG FROM JOB PARM                             
      *** THIS FLAG DECIDE WHETHER MDM HI/LO FLAGS REQUIRED IN CIS              
           MOVE SPACES                     TO WS-SYSIPT.                
           MOVE ZEROS                      TO WS-SEQUENCE.              
           MOVE WS-PARM                    TO WS-COMMAND.               
           MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
                                                                        
           PERFORM 7600-START-FCSJC01      THRU 7600-EXIT.              
                                                                        
           PERFORM 7610-READ-FCSJC01       THRU 7610-EXIT               
             UNTIL (MDM-HILO-FLAG AND INPUT-ACTIVE)                     
                OR  END-OF-SYSIPT.                                      
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY '***************************************'         
              DISPLAY '**     PCSBW185 PROCESSING WARNING   **'         
              DISPLAY '** PARM THAT DECIDE USE OF MDM HI/LO **'         
              DISPLAY '** FLAG NOT EXISTS JOB PARM TABLE    **'         
              DISPLAY '**  KEY = ' E-FJC01-KEY                          
              DISPLAY '** DEFAULT IS USE MDM HI/LO FLAGS    **'         
              DISPLAY '**  PROCESSING CONTINUE              **'         
              DISPLAY '***************************************'         
              SET USE-MDM-HILO-FLAGS       TO TRUE                      
           ELSE                                                         
              PERFORM 7611-CLOSE           THRU 7611-EXIT               
              IF  WS-MDM-HILO-PARM = 'N'                                
                  DISPLAY ' '                                           
                  DISPLAY '*************************************'       
                  DISPLAY '*                                   *'       
                  DISPLAY '* DO NOT USE MDM HI/LO FLAGS IN CIS *'       
                  DISPLAY '*                                   *'       
                  DISPLAY '*************************************'       
                  SET NOT-USE-MDM-HILO-FLAGS TO TRUE                    
              ELSE                                                      
                  DISPLAY ' '                                           
                  DISPLAY '*************************************'       
                  DISPLAY '*                                   *'       
                  DISPLAY '* USE MDM HI/LO FLAGS IN CIS WQ     *'       
                  DISPLAY '*                                   *'       
                  DISPLAY '*************************************'       
                  SET USE-MDM-HILO-FLAGS TO TRUE                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0400-LOAD-RD-FMT-TAB.                                            
      *================================================================*        
      *                                                                         
           INITIALIZE WS-MTR-RD-FMT-TABLE.                              
      *                                                                         
           PERFORM 7210-OPEN-RD-FMT-CURSOR THRU 7210-EXIT.              
      *                                                                         
           PERFORM 7220-FETCH-RD-FMT-CURSOR THRU 7220-EXIT              
      *                                                                         
           IF WS-RD-FMT-COUNT = 0                                       
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW185 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 0400          **'        
              DISPLAY '*** ZERO ROWS SELECTED FROM CSS_MTR_RD_FMT'      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
      *                                                                         
           IF WS-RD-FMT-COUNT >= 1200                                   
              DISPLAY '*********************************************'   
              DISPLAY '**   PCSBW185 PROCESSING ERROR             **'   
              DISPLAY '**   ABEND IN PARAGRAPH 0400               **'   
              DISPLAY '***         ARRAY OVERFLOW:                **'   
              DISPLAY '** EXPECTED MTR_RD_FMT ROWS ARE BELOW 1200 **'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
      *                                                                         
           PERFORM 7230-CLOSE-RD-FMT-CURSOR THRU 7230-EXIT.             
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0600-CHECK-FOR-RESTART.                                          
      *================================================================*        
      *                                                                         
           MOVE PROGRAM-NAME               TO RF-NAME-PROGRAM.          
           MOVE WS-ONE                     TO RF-PARTITION-NO           
                                              RF-DUP-CNTRL-NO.          
           PERFORM 7400-SELECT-RESTART-DATA  THRU 7400-EXIT.            
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE RF-RESTART-DATA-TEXT   TO WS-RESTART-DATA           
               IF  WS-RESTART-PROCESS-TYPE NUMERIC                      
                   MOVE WS-Y               TO WS-IS-THIS-A-RESTART      
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0601-REPOSITION-INPUT-FILE.                                      
      *================================================================*        
      **** REPOSITION BW85 FILE TO LAST SUCCESSFUL COMMIT                       
      *                                                                         
           MOVE ZERO                       TO WS-FCSBW85-REC-CNTR.      
      *                                                                         
           PERFORM 5000-GET-FIOBW85-DATA   THRU 5000-EXIT               
             UNTIL WS-FCSBW85-REC-CNTR  EQUAL WS-RESTART-RECORD-NO      
              OR BW85-EOF-REACHED.                                      
      *                                                                         
      *****************************************************************         
      *    THE FOLLOWING CODE COMPARES KEY VALUES STORED IN                     
      *    RESTART DATA WITH REPOSITIONED RECORD KEY.                           
      *****************************************************************         
           IF WS-RESTART-METER-ID   = WS-BW85-METER-ID                  
            AND WS-RESTART-REGISTER-CODE  = WS-BW85-REGISTER-CODE       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '** FAIL TO REPOSITION BW85 FILE      **'         
              DISPLAY '** CHECK FOR CORRECT BW85 FILE       **'         
              DISPLAY '** LAST DATA PROCESSED IN PRIOR RUN: '           
                 WS-RESTART-METER-ID '|' WS-RESTART-REGISTER-CODE       
              DISPLAY '** BUT FILE POSITIONED AT          : '           
                 WS-BW85-METER-ID '|' WS-BW85-REGISTER-CODE             
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
           DISPLAY ' '                                                  
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF PCSBW185  *****'.       
           DISPLAY '*******************************************'.       
           MOVE WS-RESTART-RECORD-NO         TO WS-FCSBW85-REC-CNTR.    
           MOVE WS-RESTART-CHKP-SEQ-NO       TO WS-CHKP-SEQ-NO.         
      *                                                                         
       0601-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0602-REPOSITION-OUTPUT-FILE.                                     
      *================================================================*        
      *                                                                         
           MOVE ZERO                       TO WS-FCSBW06-REC-CNTR.      
                                                                        
           OPEN INPUT FCSBW06R-FILE.                                    
           IF NOT FBW06R-SUCCESSFUL                                     
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW185 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 0602          **'        
              DISPLAY '**   ERROR ON OPEN FCSBW06R FILE      **'        
              DISPLAY '**   STATUS IS ' WS-FBW06R-STATUS                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           PERFORM WS-RESTART-FBW06-REC-CNTR TIMES                      
              READ FCSBW06R-FILE                                        
              IF FBW06R-SUCCESSFUL                                      
                 WRITE FIOBW06-REC FROM FIOBW06R-REC                    
                 IF FBW06-SUCCESSFUL                                    
                    CONTINUE                                            
                 ELSE                                                   
                    DISPLAY '****************************************'  
                    DISPLAY '**   PCSBW185 PROCESSING ERROR        **'  
                    DISPLAY '**   ABEND IN PARAGRAPH 0602          **'  
                    DISPLAY '**   ERROR ON FCSBW06 REWRITE         **'  
                    DISPLAY '**   STATUS IS ' WS-FBW06-STATUS           
                    DISPLAY '****************************************'  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '**   PCSBW185 PROCESSING ERROR        **'     
                 DISPLAY '**   ABEND IN PARAGRAPH 0602          **'     
                 DISPLAY '**   PREMATURE EOF ON BW06 RESTART    **'     
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           CLOSE FCSBW06R-FILE.                                         
                                                                        
           MOVE WS-RESTART-FBW06-REC-CNTR  TO WS-FCSBW06-REC-CNTR.      
                                                                        
        0602-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *================================================================*        
      *  0605-VALIDATE-RESTART-REQ                                              
       COPY CPD00030.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
       0610-INITIALIZE-RESTART.                                         
      *================================================================*        
      *                                                                         
           MOVE ZEROS                      TO WS-RESTART-CHKP-SEQ-NO    
                                              WS-RESTART-FBW06-REC-CNTR 
           MOVE SPACES                     TO WS-RESTART-METER-ID       
                                              WS-RESTART-REGISTER-CODE. 
           MOVE 1                          TO WS-RESTART-PROCESS-TYPE   
           SET WS-RERUN-PENDING            TO TRUE.                     
           MOVE WS-INPUT-DATE              TO WS-RESTART-INPUT-DATE.    
      *                                                                         
       0610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-PROCESS-BW85.                                               
      *================================================================*        
      *                                                                         
           PERFORM 1100-PROCESS-ACCOUNT  THRU 1100-EXIT.                
                                                                        
           PERFORM 1200-PROCESS-ALL-METERS  THRU 1200-EXIT              
                   UNTIL BW85-EOF-REACHED                               
            OR WS-BW85-METER-ID NOT = WS-PREV-METER-ID.                 
           IF WS-CURR-TOT-KWH-DATE = SPACES                             
              AND WS-CURR-TOT-KWHF-DATE > SPACES                        
              MOVE WS-CURR-TOT-KWHF-DATE   TO WS-CURR-TOT-KWH-DATE      
              MOVE WS-CURR-TOT-KWHF-TIME   TO WS-CURR-TOT-KWH-TIME      
              MOVE WS-TEMP-CODE-METER-READ-F TO WS-TEMP-CODE-METER-READ 
           END-IF                                                       
                                                                        
           IF WS-CURR-TOT-KWH-DATE > SPACES                             
              PERFORM 1250-FORMAT-OUTPUT-DATA   THRU 1250-EXIT          
           END-IF                                                       
           COMPUTE WS-COMMIT-ROUTES = WS-COMMIT-ROUTES + 1              
                                                                        
           IF COMMITS-REQUIRE                                           
              AND WS-COMMIT-ROUTES >= WS-CHKP-LUW-LIMIT                 
              PERFORM 3100-PROCESS-ROUTE-HEADER THRU 3100-EXIT          
              PERFORM 6025-ISSUE-CHKP           THRU 6025-EXIT          
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1100-PROCESS-ACCOUNT.                                            
      *================================================================*        
      *                                                                         
           DISPLAY 'PROCESSING: ' WS-BW85-METER-ID                      
                                                                        
           MOVE WS-BW85-METER-ID           TO WS-PREV-METER-ID          
           MOVE WS-BD-COMPANY-NO           TO AT-COMPANY-NO             
           MOVE WS-BD-UTIL-TYPE            TO MN-CODE-UTIL-TYPE         
                                              WS-CODE-UTIL-TYPE         
           MOVE WS-BD-METER-NO             TO MN-METER-NO               
                                              WS-SAVE-METER-NO          
           SET ACCOUNT-NOT-FOUND           TO TRUE                      
           EVALUATE TRUE                                                
              WHEN WS-BW85-REQUEST-TYPE = 'PartialBill'                 
                 PERFORM 1140-PROCESS-MTR-MDM     THRU 1140-EXIT        
              WHEN WS-BW85-REQUEST-TYPE = 'FinalBill'                   
                 PERFORM 1160-PROCESS-ACC-MDM     THRU 1160-EXIT        
              WHEN OTHER                                                
                 PERFORM 1120-PROCESS-MTR-MN      THRU 1120-EXIT        
           END-EVALUATE.                                                
                                                                        
           MOVE UT-READ-CYCLE              TO RW-READ-CYCLE             
           IF LATEST-ACCOUNT-FOUND                                      
              IF WS-PREV-READ-CYCLE = UT-READ-CYCLE                     
                 CONTINUE                                               
              ELSE                                                      
                 IF WS-PREV-READ-CYCLE > SPACES                         
                    PERFORM 3100-PROCESS-ROUTE-HEADER THRU 3100-EXIT    
                 END-IF                                                 
                 PERFORM 7150-SELECT-REVENUE-MONTH THRU 7150-EXIT       
                 MOVE UT-READ-CYCLE        TO WS-PREV-READ-CYCLE        
                 MOVE RW-OPTIMUM-READ-DATE TO WS-OPTIMUM-READ-DATE      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE AT-ACCOUNT-NO              TO WS-PREV-ACCOUNT-NO        
                                              MN-ACCOUNT-NO             
                                              WS-ACCOUNT-NO-PART        
                                              WS-SAVE-ACCOUNT-NO.       
                                                                        
           MOVE MN-MTR-READ-SOURCE-CD      TO WS-MTR-READ-SOURCE-CD     
           MOVE MN-REMOTE-READ-IND         TO WS-REMOTE-READ-IND        
           MOVE MN-PROGRAM-ID              TO WS-PROGRAM-ID             
           MOVE MN-DIGTL-MTR-TYPE          TO WS-DIGTL-MTR-TYPE.        
                                                                        
           INITIALIZE WS-MATCH-REG-ARRAY                                
                                                                        
           PERFORM 1260-LOOKUP-MTR-RD-FMT  THRU 1260-EXIT               
                                                                        
           MOVE SPACES                     TO WS-CURR-TOT-KWH-DATE      
                                              WS-CURR-TOT-KWH-TIME      
                                              WS-CURR-TOT-KWHF-DATE     
                                              WS-CURR-TOT-KWHF-TIME     
                                              WS-PREV-TOT-KWH-DATE      
                                              WS-PREV-TOT-KWH-TIME      
           INITIALIZE WS-FIOBW06-TABLE.                                 
           INITIALIZE WS-PREV-REGISTER-CODES.                           
           MOVE SPACES                  TO WS-TEMP-CODE-METER-READ      
                                           WS-TEMP-CODE-METER-READ-F.   
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1110-SET-DEFAULT-VALUES.                                         
      *================================================================*        
      *                                                                         
           MOVE 1                          TO AT-ACCOUNT-NO             
           MOVE ZERO                       TO AT-PREMISE-NO             
                                              AT-CUSTOMER-NO            
                                              UT-READ-ROUTE             
           MOVE SPACES                     TO AT-LOCAL-OFFICE           
                                              AT-CODE-ACCT-STAT         
                                              UT-RATE-PLAN-NO           
                                              MN-CODE-METER-STATUS      
                                              MN-REMOTE-READ-IND        
                                              MN-MTR-READ-SOURCE-CD     
                                              MN-DIGTL-MTR-TYPE         
                                              MN-PROGRAM-ID             
           MOVE WS-PREV-READ-CYCLE         TO UT-READ-CYCLE             
           MOVE WS-REVENUE-MONTH           TO RW-REVENUE-MONTH          
                                                                        
      **** GET DMT & PGM ID FROM EM WHEN NOT FOUND IN MN                        
           MOVE WS-BD-COMPANY-NO           TO EM-COMPANY-NO             
           MOVE MN-CODE-UTIL-TYPE          TO EM-CODE-UTIL-TYPE         
           MOVE MN-METER-NO                TO EM-METER-NO               
           PERFORM 7060-GET-DEFAULT-FROM-EM THRU 7060-EXIT              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE EM-DIGTL-MTR-TYPE       TO MN-DIGTL-MTR-TYPE         
              MOVE EM-PROGRAM-ID           TO MN-PROGRAM-ID             
              MOVE 'B'                     TO MN-REMOTE-READ-IND        
              MOVE 'R'                     TO MN-MTR-READ-SOURCE-CD     
           END-IF                                                       
                                                                        
           DISPLAY '********************************************'       
           DISPLAY '**  PCSBW185 PROCESSING WARNING           **'       
           DISPLAY '**  METER NOT ASSOCIATED WITH ANY ACCOUNT **'       
           DISPLAY '**  METER-ID: ' WS-BW85-METER-ID                    
           DISPLAY '**  PROCESSING CONTINUE ...               **'       
           DISPLAY '********************************************'.      
                                                                        
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1120-PROCESS-MTR-MN.                                             
      *================================================================*        
      *                                                                         
           PERFORM 7300-OPEN-METER-CURSOR   THRU 7300-EXIT.             
           PERFORM UNTIL LATEST-ACCOUNT-FOUND OR ACCOUNT-METER-SKIP     
             PERFORM 7310-FETCH-METER-CURSOR  THRU 7310-EXIT            
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                MOVE AT-PREMISE-NO   TO WS-CPD99-PREMISE-NO             
                PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT           
                IF WS-CPD99-ACCOUNT-NO  = AT-ACCOUNT-NO                 
                   SET LATEST-ACCOUNT-FOUND  TO TRUE                    
                END-IF                                                  
             ELSE                                                       
                SET ACCOUNT-METER-SKIP     TO TRUE                      
                PERFORM 1110-SET-DEFAULT-VALUES THRU 1110-EXIT          
             END-IF                                                     
           END-PERFORM.                                                 
           PERFORM 7320-CLOSE-METER-CURSOR  THRU 7320-EXIT.             
      *                                                                         
       1120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1140-PROCESS-MTR-MDM.                                            
      *================================================================*        
      *                                                                         
           MOVE WS-BW85-PASS-THRU2       TO 1E-SERVICE-POINT-ID         
           MOVE 'METER_NO'               TO 1E-COLUMN-NA                
           MOVE MN-METER-NO              TO 1E-PREV-COLUMN-VALUE        
                                                                        
           PERFORM 7420-GET-METER-CHNG-TMST THRU 7420-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             PERFORM 7450-GET-OLD-METER-DETAILS THRU 7450-EXIT          
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                SET LATEST-ACCOUNT-FOUND  TO TRUE                       
             ELSE                                                       
                SET ACCOUNT-METER-SKIP     TO TRUE                      
                PERFORM 1110-SET-DEFAULT-VALUES THRU 1110-EXIT          
             END-IF                                                     
           ELSE                                                         
              SET ACCOUNT-METER-SKIP     TO TRUE                        
              PERFORM 1110-SET-DEFAULT-VALUES THRU 1110-EXIT            
           END-IF.                                                      
      *                                                                         
       1140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1160-PROCESS-ACC-MDM.                                            
      *================================================================*        
      *                                                                         
           MOVE WS-BW85-PASS-THRU2       TO 1E-SERVICE-POINT-ID         
           MOVE 'ACCOUNT_NO'             TO 1E-COLUMN-NA                
      **   MOVE MN-METER-NO              TO 1E-PREV-COLUMN-VALUE                
                                                                        
           PERFORM 7430-GET-ACCOUNT-CHNG-TMST THRU 7430-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE 1E-PREV-COLUMN-VALUE (1:13)  TO WS-ACCOUNT-NO-NUM     
             MOVE WS-ACCOUNT-NO-NUM            TO AT-ACCOUNT-NO         
             PERFORM 7455-GET-OLD-ACC-DETAILS   THRU 7455-EXIT          
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                SET LATEST-ACCOUNT-FOUND  TO TRUE                       
             ELSE                                                       
                SET ACCOUNT-METER-SKIP     TO TRUE                      
                PERFORM 1110-SET-DEFAULT-VALUES THRU 1110-EXIT          
             END-IF                                                     
           ELSE                                                         
              SET ACCOUNT-METER-SKIP     TO TRUE                        
              PERFORM 1110-SET-DEFAULT-VALUES THRU 1110-EXIT            
           END-IF.                                                      
      *                                                                         
       1160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1200-PROCESS-ALL-METERS.                                         
      *================================================================*        
      *                                                                         
           MOVE WS-BW85-REGISTER-CODE      TO WS-BD-REGISTER-CODE       
PRJ914     IF WS-BD-REG-TYPE = 'R'                                      
PRJ914        PERFORM 1270-MATCH-MTR-RD-FMT   THRU 1270-EXIT            
PRJ914        IF REG-MATCH-FOUND                                        
PRJ914           PERFORM 1400-PROCESS-REGISTERS THRU 1400-EXIT          
PRJ914        END-IF                                                    
PRJ914     END-IF.                                                      
           PERFORM 5000-GET-FIOBW85-DATA   THRU 5000-EXIT.              
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1250-FORMAT-OUTPUT-DATA.                                         
      *================================================================*        
      *                                                                         
           COMPUTE WS-MTR-COUNT = WS-MTR-COUNT + 1                      
           IF WS-TEMP-CODE-METER-READ = 'Y'                             
              PERFORM 1255-SET-ADDITIONAL-REGS THRU 1255-EXIT           
           ELSE                                                         
              PERFORM 1420-TOU-NO-READ     THRU 1420-EXIT               
           END-IF.                                                      
                                                                        
P00914     PERFORM VARYING BW06-SUB FROM 1 BY 1 UNTIL                   
P00914                        BW06-SUB > 50                             
P00914                        OR WS-FBW06-ACCOUNT-NO (BW06-SUB) = 0     
P00914        IF WS-FIOBW06-WRITE-FL(BW06-SUB) = 'Y'                    
P00914           AND WS-FBW06-INDEX-VALUE-CD (BW06-SUB) = 'V'           
P00914           PERFORM 1252-RESET-DUP-DEMANDS THRU 1252-EXIT          
P00914                   VARYING BW06-SUB1 FROM 1 BY 1 UNTIL            
P00914                        BW06-SUB1 > 50                            
P00914                        OR WS-FBW06-ACCOUNT-NO (BW06-SUB1) = 0    
P00914        END-IF                                                    
P00914     END-PERFORM.                                                 
P00914                                                                  
           PERFORM VARYING BW06-SUB FROM 1 BY 1 UNTIL                   
                              BW06-SUB > 50                             
                              OR WS-FBW06-ACCOUNT-NO (BW06-SUB) = 0     
              IF WS-FIOBW06-WRITE-FL(BW06-SUB) = 'Y'                    
                 MOVE WS-CURR-TOT-KWH-DATE                              
                                       TO WS-FBW06-DATE-READ (BW06-SUB) 
                 MOVE WS-CURR-TOT-KWH-TIME                              
                                       TO WS-FBW06-TIME-READ (BW06-SUB) 
                 MOVE WS-FIOBW06-REC (BW06-SUB) TO FIOBW06              
                 PERFORM 8000-WRITE-FIOBW06 THRU 8000-EXIT              
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       1250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00914*==============================================================*          
P00914 1252-RESET-DUP-DEMANDS.                                          
P00914*==============================================================*          
P00914*** CHECK IF ANY DUPLICATE DEMAND REGISTERS AND KEEP ONLY                 
P00914*** HIGHER DEMAND REGISTERS -- AS PER JERRY                               
P00914     IF WS-FIOBW06-WRITE-FL(BW06-SUB1) = 'Y'                      
P00914        AND BW06-SUB1 NOT = BW06-SUB                              
P00914        AND WS-FBW06-CODE-USAGE-TYPE  (BW06-SUB1)                 
P00914                       = WS-FBW06-CODE-USAGE-TYPE  (BW06-SUB)     
P00914            AND WS-FBW06-CODE-TIME-PERIOD (BW06-SUB1)             
P00914                       = WS-FBW06-CODE-TIME-PERIOD (BW06-SUB)     
P00914            AND WS-FBW06-CODE-TOU-SEASN   (BW06-SUB1)             
P00914                       = WS-FBW06-CODE-TOU-SEASN   (BW06-SUB)     
P00914            AND WS-FBW06-CODE-USAGE-ID    (BW06-SUB1)             
P00914                       = WS-FBW06-CODE-USAGE-ID    (BW06-SUB)     
P00914        IF WS-FBW06-METER-READING (BW06-SUB1) <=                  
P00914            WS-FBW06-METER-READING (BW06-SUB)                     
P00914           MOVE 'N'   TO WS-FIOBW06-WRITE-FL(BW06-SUB1)           
P00914        ELSE                                                      
P00914           MOVE 'N'   TO WS-FIOBW06-WRITE-FL(BW06-SUB)            
P00914        END-IF                                                    
P00914     END-IF.                                                      
P00914*                                                                         
P00914 1252-EXIT.                                                       
P00914     EXIT.                                                        
P00914*                                                                         
      *==============================================================*          
       1255-SET-ADDITIONAL-REGS.                                        
      *==============================================================*          
      *** CHECK IF ANY PREVIOUS SEASON & SET PREVIOUS REGISTERS                 
      *** CHECK MISSING REGISTERS & SET SKIP READS                              
      *                                                                         
           IF WS-PREV-TOT-KWH-DATE < WS-CURR-TOT-KWH-DATE               
             AND UT-RATE-PLAN-NO > SPACES                               
              PERFORM 2400-CHECK-SEASON-CHG   THRU 2400-EXIT            
              IF SEASON-RATE-BY-USAGE                                   
                 PERFORM 2500-VALIDATE-PREV-SEASON  THRU 2500-EXIT      
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE BW06-SUB                   TO BW06-SUB1                 
           PERFORM VARYING BW06-SUB FROM 1 BY 1 UNTIL                   
                           BW06-SUB > 50                                
                           OR WS-FBW06-ACCOUNT-NO (BW06-SUB) = 0        
              SET NO-REG-MATCH-FOUND    TO TRUE                         
              PERFORM VARYING WS-MRF-SUB2 FROM 1 BY 1                   
                              UNTIL WS-MRF-SUB2 > WS-MATCH-REG-COUNT    
                                  OR WS-MRF-SUB2 > 50                   
                                  OR REG-MATCH-FOUND                    
                IF ARR-CODE-USAGE-TYPE      (WS-MRF-SUB2)               
                             = WS-FBW06-CODE-USAGE-TYPE  (BW06-SUB)     
                  AND ARR-CODE-TIME-PERIOD (WS-MRF-SUB2)                
                             = WS-FBW06-CODE-TIME-PERIOD (BW06-SUB)     
                  AND ARR-CODE-TOU-SEASN   (WS-MRF-SUB2)                
                             = WS-FBW06-CODE-TOU-SEASN   (BW06-SUB)     
                  AND ARR-CODE-USAGE-ID    (WS-MRF-SUB2)                
                             = WS-FBW06-CODE-USAGE-ID    (BW06-SUB)     
                   SET REG-MATCH-FOUND TO TRUE                          
                   MOVE 'Y'            TO ARR-MATCH-FOUND (WS-MRF-SUB2) 
                END-IF                                                  
              END-PERFORM                                               
              IF REG-MATCH-FOUND                                        
                 MOVE 'Y'              TO WS-FIOBW06-WRITE-FL(BW06-SUB) 
              ELSE                                                      
                 MOVE SPACES           TO WS-FIOBW06-WRITE-FL(BW06-SUB) 
              END-IF                                                    
           END-PERFORM                                                  
                                                                        
           MOVE BW06-SUB1                  TO BW06-SUB                  
           PERFORM VARYING WS-MRF-SUB2 FROM 1 BY 1                      
                 UNTIL WS-MRF-SUB2 > WS-MATCH-REG-COUNT                 
                               OR WS-MRF-SUB2 > 50                      
             IF ARR-MATCH-FOUND (WS-MRF-SUB2) NOT = 'Y'                 
                PERFORM 1450-PROCESS-NO-READS THRU 1450-EXIT            
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       1255-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1260-LOOKUP-MTR-RD-FMT.                                          
      *==============================================================*          
      *                                                                         
           PERFORM VARYING WS-MRF-SUB FROM 1 BY 1                       
                                 UNTIL WS-MRF-SUB > WS-RD-FMT-COUNT     
                                  OR WS-MRF-SUB > 1200                  
             IF TAB-CODE-UTIL-TYPE  (WS-MRF-SUB)   = WS-CODE-UTIL-TYPE  
              AND TAB-DIGTL-MTR-TYPE  (WS-MRF-SUB) = WS-DIGTL-MTR-TYPE  
              AND TAB-PROGRAM-ID      (WS-MRF-SUB) = WS-PROGRAM-ID      
              AND TAB-REMOTE-READ-IND(WS-MRF-SUB) = WS-REMOTE-READ-IND  
              AND TAB-MTR-READ-SOURCE-CD (WS-MRF-SUB)                   
                                       = WS-MTR-READ-SOURCE-CD          
                COMPUTE WS-MRF-SUB2 = WS-MRF-SUB2 + 1                   
                MOVE TAB-CODE-USAGE-TYPE (WS-MRF-SUB)                   
                                   TO ARR-CODE-USAGE-TYPE (WS-MRF-SUB2) 
                MOVE TAB-CODE-USAGE-ID   (WS-MRF-SUB)                   
                                   TO ARR-CODE-USAGE-ID   (WS-MRF-SUB2) 
                                                                        
                EVALUATE TAB-CODE-USAGE-ID (WS-MRF-SUB)                 
      *****        INCLUDE STAND-BY'S                                           
                   WHEN 'C'                                             
                   WHEN 'X'                                             
                         MOVE WS-A                                      
                                TO ARR-TEMP-CODE-USAGE-ID (WS-MRF-SUB2) 
                   WHEN OTHER                                           
                         MOVE TAB-CODE-USAGE-ID (WS-MRF-SUB)            
                                TO ARR-TEMP-CODE-USAGE-ID (WS-MRF-SUB2) 
                END-EVALUATE                                            
                                                                        
                MOVE TAB-CODE-USAGE-SOURCE (WS-MRF-SUB)                 
                                   TO ARR-CODE-USAGE-SOURCE(WS-MRF-SUB2)
                MOVE TAB-CODE-TIME-PERIOD (WS-MRF-SUB)                  
                                   TO ARR-CODE-TIME-PERIOD (WS-MRF-SUB2)
                MOVE TAB-MTR-RD-DISP-CD (WS-MRF-SUB)                    
                                   TO ARR-MTR-RD-DISP-CD (WS-MRF-SUB2)  
                MOVE TAB-NO-READ-DIGITS (WS-MRF-SUB)                    
                                   TO ARR-NO-READ-DIGITS (WS-MRF-SUB2)  
                MOVE TAB-NO-READ-DECIMALS (WS-MRF-SUB)                  
                                   TO ARR-NO-READ-DECIMALS (WS-MRF-SUB2)
                MOVE TAB-READ-SEQUENCE-NO (WS-MRF-SUB)                  
                                   TO ARR-READ-SEQUENCE-NO (WS-MRF-SUB2)
                MOVE TAB-CODE-TOU-SEASN   (WS-MRF-SUB)                  
                                   TO ARR-CODE-TOU-SEASN   (WS-MRF-SUB2)
                MOVE TAB-INDEX-VALUE-CD   (WS-MRF-SUB)                  
                                   TO ARR-INDEX-VALUE-CD   (WS-MRF-SUB2)
                MOVE TAB-CNSMPTN-READ-FL  (WS-MRF-SUB)                  
                                   TO ARR-CNSMPTN-READ-FL  (WS-MRF-SUB2)
                MOVE 'N'           TO ARR-MATCH-FOUND  (WS-MRF-SUB2)    
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
           IF WS-MRF-SUB2 > 0                                           
              MOVE WS-MRF-SUB2             TO WS-MATCH-REG-COUNT        
           ELSE                                                         
              PERFORM 2900-GENERATE-RD-FMT-WQ THRU 2900-EXIT            
           END-IF.                                                      
      *                                                                         
       1260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1270-MATCH-MTR-RD-FMT.                                           
      *==============================================================*          
      *                                                                         
           SET NO-REG-MATCH-FOUND    TO TRUE                            
           PERFORM VARYING WS-MRF-SUB2 FROM 1 BY 1                      
                              UNTIL WS-MRF-SUB2 > WS-MATCH-REG-COUNT    
                                  OR WS-MRF-SUB2 > 50                   
                                  OR REG-MATCH-FOUND                    
              IF ARR-CODE-USAGE-TYPE (WS-MRF-SUB2)                      
                                      = WS-BD-CODE-USAGE-TYPE           
                 AND ARR-CODE-TIME-PERIOD (WS-MRF-SUB2)                 
                                      = WS-BD-CODE-TIME-PERIOD          
                 AND ARR-CODE-TOU-SEASN (WS-MRF-SUB2)                   
                                      = WS-BD-CODE-TOU-SEASN            
                 AND ARR-TEMP-CODE-USAGE-ID (WS-MRF-SUB2)               
                                      = WS-BD-CODE-USAGE-ID             
                 IF (ARR-INDEX-VALUE-CD (WS-MRF-SUB2) = 'V'             
                     AND WS-BW85-READ-QUALIFIER = 'I')                  
                    OR                                                  
                    (ARR-INDEX-VALUE-CD (WS-MRF-SUB2) = 'I'             
                     AND WS-BW85-READ-QUALIFIER = 'R')                  
                    PERFORM 1280-ATTACH-MTR-FMT-DATA                    
                       THRU 1280-EXIT                                   
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       1270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1280-ATTACH-MTR-FMT-DATA.                                        
      *==============================================================*          
      *                                                                         
           SET REG-MATCH-FOUND    TO TRUE                               
           MOVE ARR-CODE-USAGE-TYPE (WS-MRF-SUB2)                       
                                  TO WS-CODE-USAGE-TYPE                 
           MOVE ARR-CODE-TIME-PERIOD (WS-MRF-SUB2)                      
                                  TO WS-CODE-TIME-PERIOD                
           MOVE ARR-CODE-TOU-SEASN   (WS-MRF-SUB2)                      
                                  TO WS-CODE-TOU-SEASN                  
           MOVE ARR-MTR-RD-DISP-CD (WS-MRF-SUB2)                        
                                  TO WS-MTR-RD-DISP-CD                  
           MOVE ARR-CNSMPTN-READ-FL  (WS-MRF-SUB2)                      
                                  TO WS-CNSMPTN-READ-FL                 
           MOVE ARR-INDEX-VALUE-CD   (WS-MRF-SUB2)                      
                                  TO WS-INDEX-VALUE-CD                  
           MOVE ARR-NO-READ-DIGITS (WS-MRF-SUB2)                        
                                  TO WS-READ-DIGITS                     
           MOVE ARR-NO-READ-DECIMALS (WS-MRF-SUB2)                      
                                  TO WS-READ-DECIMALS                   
           MOVE ARR-CODE-USAGE-ID   (WS-MRF-SUB2)                       
                                  TO WS-CODE-USAGE-ID                   
           MOVE ARR-CODE-USAGE-SOURCE (WS-MRF-SUB2)                     
                                  TO WS-CODE-USAGE-SOURCE.              
      *                                                                         
       1280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1400-PROCESS-REGISTERS.                                          
      *================================================================*        
      *                                                                         
           COMPUTE BW06-SUB  = BW06-SUB + 1                             
           IF BW06-SUB > 50                                             
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW185 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 1400          **'        
              DISPLAY '**   ARRAY OVERFLOW OCCUR ON WS-BWO6  **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND        THRU 9900-EXIT                  
           END-IF.                                                      
           MOVE 1                    TO WS-FBW06-DB-PART-DREC (BW06-SUB)
           MOVE WS-SAVE-ACCOUNT-NO     TO WS-FBW06-ACCOUNT-NO (BW06-SUB)
           MOVE WS-SAVE-METER-NO       TO WS-FBW06-METER-NO   (BW06-SUB)
           MOVE WS-CODE-UTIL-TYPE TO WS-FBW06-CODE-UTIL-TYPE (BW06-SUB) 
      ***  EMP ID ALWAYS BLANK                                                  
           MOVE SPACES                 TO WS-FBW06-EMPLOYEE-NO(BW06-SUB)
           MOVE WS-MTR-READ-SOURCE-CD  TO                               
                                   WS-FBW06-MTR-READ-SOURCE-CD(BW06-SUB)
      *                                                                         
      **** TROUBLE CODES ALWAYS BLANK.                                          
           MOVE SPACES           TO WS-FBW06-MTR-COND-CD1 (BW06-SUB)    
                                    WS-FBW06-MTR-COND-CD2 (BW06-SUB)    
                                    WS-FBW06-MTR-COMMENT-TX (BW06-SUB)  
      *                                                                         
           MOVE WS-CODE-USAGE-TYPE                                      
                                TO WS-FBW06-CODE-USAGE-TYPE (BW06-SUB)  
           MOVE WS-CODE-USAGE-ID                                        
                                TO WS-FBW06-CODE-USAGE-ID (BW06-SUB)    
           MOVE WS-CODE-USAGE-SOURCE                                    
                                TO WS-FBW06-CODE-USAGE-SOURCE(BW06-SUB) 
           MOVE WS-CODE-TIME-PERIOD                                     
                                TO WS-FBW06-CODE-TIME-PERIOD(BW06-SUB)  
           MOVE WS-CODE-TOU-SEASN                                       
                                TO WS-FBW06-CODE-TOU-SEASN (BW06-SUB)   
           MOVE WS-MTR-RD-DISP-CD                                       
                                TO WS-FBW06-REG-MEASURE-CD (BW06-SUB)   
           MOVE WS-CNSMPTN-READ-FL                                      
                                TO WS-FBW06-CNSMPTN-READ-FL (BW06-SUB)  
           MOVE WS-INDEX-VALUE-CD                                       
                               TO WS-FBW06-INDEX-VALUE-CD (BW06-SUB)    
      *                                                                         
           INSPECT WS-BW85-READING-VALUE                                
              REPLACING LEADING SPACES BY ZEROS.                        
      *                                                                         
           MOVE ZEROS                     TO WS-BD-READ-VAL-DIGITS      
                                             WS-BD-READ-VAL-DECIMALS    
      *                                                                         
           UNSTRING WS-BW85-READING-VALUE DELIMITED BY '.' OR ' '       
               INTO WS-BD-READ-VAL-DIGITS                               
                    WS-BD-READ-VAL-DECIMALS                             
           END-UNSTRING.                                                
      *                                                                         
           INSPECT WS-BD-READ-VAL-DECIMALS  REPLACING ALL ' ' BY '0'.   
      *                                                                         
           IF WS-BD-READ-VAL-DECIMALS  IS NUMERIC                       
              MOVE WS-BD-READ-VAL-DECIMALS TO WS-BD-READ-VAL-DEC1       
           ELSE                                                         
              MOVE ZEROS        TO WS-BD-READ-VAL-DEC1                  
           END-IF.                                                      
      *                                                                         
           MOVE ZEROS                 TO WS-RAW-METER-READ              
           IF WS-READ-DECIMALS = 0                                      
      **** FORMAT KWH (DECIMALS = 0)                                            
              COMPUTE WS-RAW-METER-READ = WS-BD-READ-VAL-DIGITS         
              IF WS-FBW06-CODE-USAGE-TYPE (BW06-SUB) = 'B'              
                 PERFORM 1460-PROCESS-TOU-KWH-READ  THRU 1460-EXIT      
              END-IF                                                    
           ELSE                                                         
             COMPUTE WS-RAW-METER-READ = WS-BD-READ-VAL-DIGITS          
                                     + WS-BD-READ-VAL-DEC2              
           END-IF.                                                      
      *                                                                         
           MOVE WS-RAW-METER-READ                                       
                           TO WS-FBW06-METER-READING (BW06-SUB).        
      *                                                                         
      ***------------------------------------------------------------***        
      ***-----------------READ-ITEM-STATUS (BW06 FIELD)--------------***        
      ** INFO READ --> I             ** BILLING READ   --> B          **        
      ** MID-MONTH --> M             ** MID-MONTH INFO --> N          **        
      ** AROP READ --> O             **                               **        
      ***------------------------------------------------------------***        
      *                                                                         
           IF WS-FBW06-CNSMPTN-READ-FL (BW06-SUB) = 'N'                 
              MOVE 'I'        TO WS-FBW06-READ-ITEM-STATUS (BW06-SUB)   
           ELSE                                                         
              MOVE 'B'        TO WS-FBW06-READ-ITEM-STATUS (BW06-SUB)   
           END-IF.                                                      
      *                                                                         
           IF WS-BW85-SKIP-CODE = 'Y'                                   
              MOVE '0'          TO WS-FBW06-CODE-METER-READ (BW06-SUB)  
              MOVE '2'          TO WS-FBW06-READ-PROCESS-CD (BW06-SUB)  
              MOVE 'J'        TO WS-FBW06-CODE-METER-NO-READ (BW06-SUB) 
              IF WS-BW85-READING-TMST > SPACES                          
                 CONTINUE                                               
              ELSE                                                      
                 MOVE SPACES               TO WS-BD-READ-DATE-TIME      
                 MOVE WS-OPTM-RD-CC        TO WS-BD-READ-DATE-CC        
                 MOVE WS-OPTM-RD-YY        TO WS-BD-READ-DATE-YY        
                 MOVE WS-OPTM-RD-MM        TO WS-BD-READ-DATE-MM        
                 MOVE WS-OPTM-RD-DD        TO WS-BD-READ-DATE-DD        
                 MOVE '00:00:00'           TO WS-BD-READ-TIME           
                 MOVE WS-BD-READ-DATE-TIME TO WS-BW85-READING-TMST      
              END-IF                                                    
           ELSE                                                         
              MOVE 'Y'          TO WS-FBW06-CODE-METER-READ (BW06-SUB)  
              MOVE '3'          TO WS-FBW06-READ-PROCESS-CD (BW06-SUB)  
              EVALUATE TRUE                                             
                 WHEN WS-BW85-ESTIMATE-FLAG = 'Y'                       
                   MOVE '!'                TO                           
                               WS-FBW06-CODE-METER-NO-READ (BW06-SUB)   
                 WHEN WS-BW85-HIGH-LOW-FLAG = 'H'                       
                      AND USE-MDM-HILO-FLAGS                            
                   MOVE '>'                TO                           
                               WS-FBW06-CODE-METER-NO-READ (BW06-SUB)   
                 WHEN WS-BW85-HIGH-LOW-FLAG = 'L'                       
                      AND USE-MDM-HILO-FLAGS                            
                   MOVE '<'                TO                           
                               WS-FBW06-CODE-METER-NO-READ (BW06-SUB)   
                 WHEN OTHER                                             
                   MOVE ' '                TO                           
                               WS-FBW06-CODE-METER-NO-READ (BW06-SUB)   
              END-EVALUATE                                              
           END-IF                                                       
      *                                                                         
           MOVE WS-BW85-READING-TMST   TO WS-BD-READ-DATE-TIME          
           MOVE WS-BD-READ-DATE-DD     TO WS-SAVE-READ-DATE-DD          
           MOVE WS-BD-READ-DATE-MM     TO WS-SAVE-READ-DATE-MM          
           MOVE WS-BD-READ-DATE-YY     TO WS-SAVE-READ-DATE-YY          
           MOVE WS-BD-READ-DATE-CC     TO WS-SAVE-READ-DATE-CC          
           MOVE WS-SAVE-READ-DATE      TO WS-FBW06-DATE-READ (BW06-SUB) 
           MOVE WS-BD-READ-TIME        TO WS-FBW06-TIME-READ (BW06-SUB) 
           MOVE SPACES                 TO WS-FBW06-WORKSET-ID(BW06-SUB) 
           MOVE 'Y'                    TO WS-FIOBW06-WRITE-FL(BW06-SUB) 
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-BW85-REQUEST-TYPE = 'PartialBill'                 
                 MOVE 'P'     TO WS-FBW06-OFF-CYCLE-READ-CD (BW06-SUB)  
              WHEN WS-BW85-REQUEST-TYPE = 'FinalBill'                   
                 MOVE 'F'     TO WS-FBW06-OFF-CYCLE-READ-CD (BW06-SUB)  
              WHEN OTHER                                                
                 MOVE ' '     TO WS-FBW06-OFF-CYCLE-READ-CD (BW06-SUB)  
           END-EVALUATE.                                                
                                                                        
           IF WS-FBW06-CODE-USAGE-TYPE (BW06-SUB) = 'B'                 
              AND WS-FBW06-CODE-TIME-PERIOD(BW06-SUB) = ZEROS           
              IF WS-FBW06-CODE-USAGE-ID (BW06-SUB)  = 'F'               
                 MOVE WS-FBW06-DATE-READ (BW06-SUB)                     
                                           TO WS-CURR-TOT-KWHF-DATE     
                 MOVE WS-FBW06-TIME-READ (BW06-SUB)                     
                                           TO WS-CURR-TOT-KWHF-TIME     
                 MOVE WS-FBW06-CODE-METER-READ (BW06-SUB)               
                                           TO WS-TEMP-CODE-METER-READ-F 
A01285           IF WS-CURR-TOT-KWH-DATE = SPACES                       
A01285              MOVE WS-FIOBW06-REC (BW06-SUB)                      
A01285                                     TO WS-TEMP-FIOBW06-REC       
A01285           END-IF                                                 
              ELSE                                                      
              IF WS-FBW06-DATE-READ (BW06-SUB) > WS-CURR-TOT-KWH-DATE   
                 MOVE WS-FIOBW06-REC (BW06-SUB) TO WS-TEMP-FIOBW06-REC  
                 MOVE WS-FBW06-CODE-METER-READ (BW06-SUB)               
                                           TO WS-TEMP-CODE-METER-READ   
                 MOVE WS-FBW06-DATE-READ (BW06-SUB)                     
                                           TO WS-CURR-TOT-KWH-DATE      
                 MOVE WS-FBW06-TIME-READ (BW06-SUB)                     
                                           TO WS-CURR-TOT-KWH-TIME      
              END-IF                                                    
              IF (WS-FBW06-DATE-READ (BW06-SUB) < WS-PREV-TOT-KWH-DATE  
                AND WS-FBW06-DATE-READ (BW06-SUB) > SPACES )            
                OR WS-PREV-TOT-KWH-DATE = SPACES                        
                 MOVE WS-FBW06-DATE-READ (BW06-SUB)                     
                                           TO WS-PREV-TOT-KWH-DATE      
                 MOVE WS-FBW06-TIME-READ (BW06-SUB)                     
                                           TO WS-PREV-TOT-KWH-TIME      
              END-IF                                                    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1420-TOU-NO-READ.                                                
      *================================================================*        
      **** WRITE DUMMY TOU RECORD INSTEAD OF WRITING NO READ FOR EACH           
      **** REGISTER.                                                            
      *                                                                         
           INITIALIZE WS-FIOBW06-TABLE.                                 
           MOVE 1                      TO BW06-SUB                      
           MOVE WS-TEMP-FIOBW06-REC    TO WS-FIOBW06-REC    (BW06-SUB)  
           MOVE '0'           TO WS-FBW06-CODE-METER-READ   (BW06-SUB)  
           MOVE 'J'           TO WS-FBW06-CODE-METER-NO-READ(BW06-SUB)  
           MOVE '2'           TO WS-FBW06-READ-PROCESS-CD   (BW06-SUB)  
           MOVE ZEROES        TO WS-FBW06-METER-READING     (BW06-SUB)  
           MOVE 'TOU'         TO WS-FBW06-REG-MEASURE-CD    (BW06-SUB)  
           MOVE 'C'           TO WS-FBW06-CODE-TOU-SEASN    (BW06-SUB)  
           MOVE '0'           TO WS-FBW06-CODE-TIME-PERIOD  (BW06-SUB)  
           MOVE 'B'           TO WS-FBW06-CODE-USAGE-TYPE   (BW06-SUB)  
           MOVE 'Y'           TO WS-FBW06-CNSMPTN-READ-FL   (BW06-SUB)  
           MOVE 'I'           TO WS-FBW06-INDEX-VALUE-CD    (BW06-SUB)  
           MOVE 'B'           TO WS-FBW06-READ-ITEM-STATUS  (BW06-SUB)  
           MOVE 'R'           TO WS-FBW06-MTR-READ-SOURCE-CD(BW06-SUB)  
           MOVE 'Y'           TO WS-FIOBW06-WRITE-FL        (BW06-SUB). 
      *                                                                         
       1420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1450-PROCESS-NO-READS.                                           
      *================================================================*        
      *                                                                         
           COMPUTE BW06-SUB  = BW06-SUB + 1                             
           IF BW06-SUB > 50                                             
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW185 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 1450          **'        
              DISPLAY '**   ARRAY OVERFLOW OCCUR ON WS-BWO6  **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND        THRU 9900-EXIT                  
           END-IF.                                                      
           MOVE WS-TEMP-FIOBW06-REC  TO WS-FIOBW06-REC (BW06-SUB)       
           MOVE ARR-CODE-USAGE-TYPE (WS-MRF-SUB2)                       
                             TO WS-FBW06-CODE-USAGE-TYPE (BW06-SUB)     
           MOVE ARR-CODE-TIME-PERIOD (WS-MRF-SUB2)                      
                             TO WS-FBW06-CODE-TIME-PERIOD(BW06-SUB)     
           MOVE ARR-CODE-TOU-SEASN   (WS-MRF-SUB2)                      
                             TO WS-FBW06-CODE-TOU-SEASN (BW06-SUB)      
           MOVE ARR-CODE-USAGE-ID    (WS-MRF-SUB2)                      
                             TO WS-FBW06-CODE-USAGE-ID (BW06-SUB)       
           MOVE ARR-MTR-RD-DISP-CD (WS-MRF-SUB2)                        
                             TO WS-FBW06-REG-MEASURE-CD (BW06-SUB)      
           MOVE ARR-CNSMPTN-READ-FL (WS-MRF-SUB2)                       
                             TO WS-FBW06-CNSMPTN-READ-FL (BW06-SUB)     
           MOVE ARR-INDEX-VALUE-CD  (WS-MRF-SUB2)                       
                             TO WS-FBW06-INDEX-VALUE-CD (BW06-SUB)      
           MOVE ARR-CODE-USAGE-SOURCE (WS-MRF-SUB2)                     
                             TO WS-FBW06-CODE-USAGE-SOURCE(BW06-SUB)    
      *                                                                         
      **** TROUBLE CODES ALWAYS BLANK.                                          
           MOVE SPACES           TO WS-FBW06-MTR-COND-CD1 (BW06-SUB)    
                                    WS-FBW06-MTR-COND-CD2 (BW06-SUB)    
                                    WS-FBW06-MTR-COMMENT-TX (BW06-SUB)  
      *                                                                         
           MOVE ZEROS            TO WS-FBW06-METER-READING (BW06-SUB).  
      *                                                                         
           IF WS-FBW06-CNSMPTN-READ-FL (BW06-SUB) = 'N'                 
              MOVE 'I'       TO WS-FBW06-READ-ITEM-STATUS (BW06-SUB)    
           ELSE                                                         
              MOVE 'B'       TO WS-FBW06-READ-ITEM-STATUS (BW06-SUB)    
           END-IF.                                                      
           MOVE '0'          TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
           MOVE 'J'          TO WS-FBW06-CODE-METER-NO-READ (BW06-SUB)  
           MOVE '2'          TO WS-FBW06-READ-PROCESS-CD (BW06-SUB).    
           MOVE 'Y'          TO WS-FIOBW06-WRITE-FL(BW06-SUB).          
      *                                                                         
       1450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1460-PROCESS-TOU-KWH-READ.                                       
      *================================================================*        
      *                                                                         
           MOVE ZEROS                      TO WS-CURR-READ-VALUE        
                                              WS-CURNT-CHGD-RD-VAL      
                                              WS-EXCESS-INDX-DGT.       
                                                                        
           IF WS-READ-DIGITS = 0                                        
              MOVE 5                       TO WS-READ-DIGITS            
           END-IF.                                                      
                                                                        
           MOVE WS-RAW-METER-READ          TO WS-CURR-READ-VALUE.       
                                                                        
           COMPUTE WS-EXCESS-INDX-DGT = (WS-CURR-READ-VALUE /           
                 (10 ** WS-READ-DIGITS))                                
             ON SIZE ERROR                                              
                MOVE ZERO                  TO WS-EXCESS-INDX-DGT        
           END-COMPUTE.                                                 
                                                                        
           COMPUTE WS-CURNT-CHGD-RD-VAL = (WS-CURR-READ-VALUE -         
                   (WS-EXCESS-INDX-DGT * (10 ** WS-READ-DIGITS)))       
             ON SIZE ERROR                                              
                MOVE ZERO TO WS-CURNT-CHGD-RD-VAL                       
           END-COMPUTE.                                                 
                                                                        
           MOVE WS-CURNT-CHGD-RD-VAL       TO WS-RAW-METER-READ.        
      *                                                                         
       1460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       2400-CHECK-SEASON-CHG.                                           
      *===============================================================*         
      *                                                                         
      *** CHECK FOR SEASON CHANGE.                                              
           MOVE SPACES                     TO J4-SEAS-PRORATE-CD        
           INITIALIZE     WS-SEASN1-END-DATE                            
                          WS-SEASN2-END-DATE                            
                          WS-SEASN-MMDD-NUM.                            
           SET NON-SEASON-RATE             TO TRUE                      
           MOVE WS-CODE-UTIL-TYPE          TO RT-CODE-UTIL-TYPE         
                                              RS-CODE-UTIL-TYPE         
                                              J4-CODE-UTIL-TYPE.        
           MOVE UT-RATE-PLAN-NO            TO RT-RATE-PLAN-NO           
                                              RS-RATE-PLAN-NO           
                                              J4-RATE-PLAN-NO.          
           PERFORM 7330-SELECT-RATE-VERSION THRU 7330-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RT-VERSION-NO-CNTRL     TO RS-VERSION-NO-CNTRL       
                                              J4-VERSION-NO-CNTRL       
              PERFORM 7350-GET-SEASN-PRT-TYPE THRU 7350-EXIT            
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              AND J4-SEAS-PRORATE-CD = 'U'                              
      ***CONSIDER ONLY WHEN SEASONAL PRORATE IS BY USAGE DAYS.                  
              PERFORM 7340-SELECT-SEASONS      THRU 7340-EXIT           
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 SET SEASON-RATE-BY-USAGE  TO TRUE                      
                 MOVE RS-DATE-FROM         TO WS-SEASN-MMDD-NUM         
                 MOVE WS-WORK-CCYY         TO WS-SEASN1-END-CCYY        
                                              WS-SEASN2-END-CCYY        
                 MOVE WS-SEASN-TEMP-MM     TO WS-SEASN1-END-MM          
                 MOVE WS-SEASN-TEMP-DD     TO WS-SEASN1-END-DD          
      *                                                                         
                 MOVE RS-DATE-TO           TO WS-SEASN-MMDD-NUM         
                 MOVE WS-SEASN-TEMP-MM     TO WS-SEASN2-END-MM          
                 MOVE WS-SEASN-TEMP-DD     TO WS-SEASN2-END-DD          
                 MOVE WS-SEASN2-END-DATE   TO WS-DB2-DATE               
                 PERFORM 7360-ADD-ONE-DAY THRU 7360-EXIT                
                 MOVE WS-DB2-DATE          TO WS-SEASN2-END-DATE        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2500-VALIDATE-PREV-SEASON.                                       
      *================================================================*        
      *                                                                         
           IF (WS-PREV-TOT-KWH-DATE = WS-SEASN1-END-DATE                
              AND WS-CURR-TOT-KWH-DATE > WS-SEASN1-END-DATE )           
              OR                                                        
             (WS-PREV-TOT-KWH-DATE = WS-SEASN2-END-DATE                 
              AND WS-CURR-TOT-KWH-DATE > WS-SEASN2-END-DATE)            
              PERFORM VARYING BW06-SUB FROM 1 BY 1 UNTIL                
                              BW06-SUB > 50                             
                              OR WS-FBW06-ACCOUNT-NO (BW06-SUB) = 0     
                MOVE WS-FBW06-DATE-READ(BW06-SUB) TO WS-REG-READ-DATE   
                MOVE WS-FBW06-TIME-READ(BW06-SUB) TO WS-REG-READ-TIME   
                IF WS-REG-READ-DTTM <= WS-PREV-TOT-KWH-DTTM             
                   MOVE 'P'       TO WS-FBW06-CODE-TOU-SEASN (BW06-SUB) 
                END-IF                                                  
              END-PERFORM                                               
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2900-GENERATE-RD-FMT-WQ.                                         
      *==============================================================*          
      *                                                                         
           MOVE SPACES                     TO WS-COMMENTS-TEMP          
           MOVE MN-METER-NO                TO WS-WQ-METER-NO            
           MOVE MN-DIGTL-MTR-TYPE          TO WS-WQ-DMT                 
           MOVE MN-PROGRAM-ID              TO WS-WQ-PGM-ID              
           MOVE MN-MTR-READ-SOURCE-CD      TO WS-WQ-MRS-CD              
           MOVE MN-CODE-UTIL-TYPE          TO WS-WQ-UTIL-TYPE           
           MOVE WS-MISSING-MRF-MSG         TO WS-COMMENTS-TEMP          
           MOVE WS-CATEGORY-ID-528         TO WS-HOLD-WQ-CATEGORY       
           PERFORM 5900-POPULATE-WQ        THRU 5900-EXIT.              
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3000-WRITE-CNTRL-REC.                                            
      *================================================================*        
      *                                                                         
           MOVE SPACES     TO FIOBW06.                                  
           INITIALIZE FIOBW06.                                          
      *                                                                         
           MOVE 1                   TO E-FBW06-DB-PART-DREC             
           MOVE ALL '9'             TO E-FBW06-RECORD-KEY               
           PERFORM 8000-WRITE-FIOBW06     THRU 8000-EXIT                
      *                                                                         
           IF WS-MTR-COUNT > 0                                          
              PERFORM 3100-PROCESS-ROUTE-HEADER THRU 3100-EXIT          
           END-IF                                                       
      ******************************************************************        
      * THE FOLLOWING STATEMENTS UPGRADE THE JOB-COMPLETE FIELD TO              
      * INDICATE A SUCCESSFUL COMPLETION:                                       
      ******************************************************************        
           MOVE SPACES   TO WS-RESTART-JOB-COMPLETE.                    
           IF WS-THIS-IS-A-RESTART                                      
              SET WS-RERUN-COMPLETED TO TRUE                            
           ELSE                                                         
              SET WS-RUN-COMPLETED-NO-PROBLEMS TO TRUE                  
           END-IF.                                                      
                                                                        
           IF COMMITS-REQUIRE                                           
              PERFORM 6025-ISSUE-CHKP      THRU 6025-EXIT               
           END-IF.                                                      
                                                                        
           IF WS-RESTART-REQ EQUAL WS-Y                                 
              PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT        
           END-IF.                                                      
      *                                                                         
           MOVE WS-FCSBW06-REC-CNTR        TO WS-DISP-FBW06-CNT         
           MOVE WS-FCSBW85-REC-CNTR        TO WS-DISP-FBW85-CNT         
           DISPLAY ' '                                                  
           DISPLAY '**************************************'             
           DISPLAY '** SUCCESSFUL END OF JOB            **'             
           DISPLAY '** BW85 FILE RECORD COUNT:' WS-DISP-FBW85-CNT ' **' 
           DISPLAY '** BW06 FILE RECORD COUNT:' WS-DISP-FBW06-CNT ' **' 
           DISPLAY '***************************************'            
           .                                                            
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3100-PROCESS-ROUTE-HEADER.                                       
      *================================================================*        
      *                                                                         
           MOVE '000'                      TO RH-LOCAL-OFFICE           
           MOVE 0                          TO RH-READ-ROUTE             
           MOVE AT-COMPANY-NO              TO RH-COMPANY-NO             
           MOVE WS-PREV-READ-CYCLE         TO RH-READ-CYCLE             
           MOVE RW-REVENUE-MONTH           TO WS-REVENUE-MONTH          
                                              RH-REVENUE-MONTH.         
                                                                        
           PERFORM 7100-SELECT-ROUTE-HEADER    THRU  7100-EXIT.         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              IF WS-NULL-IND < 0                                        
                 MOVE WS-CURRENT-DATE      TO  RH-UPLOAD-DATE           
              END-IF                                                    
                                                                        
              COMPUTE RH-UPLOAD-METERS = RH-UPLOAD-METERS               
                                         + WS-MTR-COUNT                 
                                                                        
              PERFORM 8450-UPDATE-ROUTE-HEADER                          
                 THRU 8450-EXIT                                         
           ELSE                                                         
              MOVE WS-CURRENT-DATE         TO RH-UPLOAD-DATE            
                                              RH-DOWNLOAD-DATE          
              MOVE SPACES                  TO RH-PC-ROUTE-IND           
              MOVE ZEROS                   TO RH-DOWN-RMVD-MTR-QT       
                                              RH-UP-RMVD-MTR-QT         
                                                                        
              MOVE WS-MTR-COUNT            TO  RH-UPLOAD-METERS         
              MOVE ZEROS                   TO  RH-DOWNLOAD-METERS       
                                                                        
              PERFORM 8400-INSERT-ROUTE-HEADER THRU 8400-EXIT           
           END-IF                                                       
                                                                        
           DISPLAY '****************************************'           
           DISPLAY '** UPDATED ROUTE HEADER UPLOAD COUNTS **'           
           DISPLAY '** UPLOAD METER COUNT = ' WS-MTR-COUNT              
           DISPLAY '** UPLOAD CYCLE       = ' WS-PREV-READ-CYCLE        
           DISPLAY '****************************************'           
                                                                        
           MOVE ZERO                       TO WS-MTR-COUNT.             
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       5000-GET-FIOBW85-DATA.                                           
      *===============================================================*         
      *                                                                         
           PERFORM 7000-READ-FIOBW85     THRU 7000-EXIT                 
      *                                                                         
      *** DELETE BELOW 2 LINES LATER                                            
           MOVE SPACES                   TO WS-BW85-ESTIMATE-FLAG       
                                            WS-BW85-HIGH-LOW-FLAG       
           IF FBW85-SUCCESSFUL                                          
              INITIALIZE  WS-UNSTRING-BW85-REC                          
              UNSTRING FIOBW85-REC DELIMITED BY ','                     
                  INTO WS-BW85-METER-ID                                 
                       WS-BW85-REGISTER-CODE                            
                       WS-BW85-READING-TMST                             
                       WS-BW85-READING-VALUE                            
                       WS-BW85-SKIP-CODE                                
                       WS-BW85-READ-QUALIFIER                           
                       WS-BW85-REQUEST-TYPE                             
                       WS-BW85-PASS-THRU1                               
                       WS-BW85-PASS-THRU2                               
                       WS-BW85-PASS-THRU3                               
              END-UNSTRING                                              
      *                                                                         
              MOVE WS-BW85-METER-ID        TO WS-BD-METER-ID            
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       5900-POPULATE-WQ.                                                
      *================================================================*        
      *                                                                         
           INITIALIZE CWS00077-FIELDS.                                  
      *                                                                         
           INITIALIZE WS-77-COMMENTS.                                   
           MOVE WS-INPUT-DATE                TO WS-77-DATE-REQUIRED.    
           MOVE ZERO                         TO WS-77-SERV-ORDER-NO.    
           MOVE WS-HOLD-WQ-CATEGORY          TO WS-77-CATEGORY-ID.      
           MOVE AT-ACCOUNT-NO                TO WS-77-ACCOUNT-NO.       
           MOVE AT-CUSTOMER-NO               TO WS-77-CUSTOMER-NO.      
           MOVE AT-LOCAL-OFFICE              TO WS-77-LOCAL-OFFICE.     
           MOVE AT-PREMISE-NO                TO WS-77-PREMISE-NO.       
                                                                        
           MOVE 'SYSTEM'                     TO WS-77-USER-ID-ORIG.     
           MOVE WS-ROUTING-CATEGORY          TO WS-77-ROUTE-CATEGORY    
           MOVE WS-NORMAL-PRIORITY           TO WS-77-PRIORITY.         
           MOVE SPACES                       TO WS-77-RESP-AREA-ID.     
                                                                        
           MOVE WS-COMMENTS-TEMP         TO WS-77-COMMENTS-TEXT.        
           MOVE LENGTH OF WS-77-COMMENTS-TEXT TO WS-77-COMMENTS-LEN.    
           MOVE SPACES                       TO WS-77-FREE-FORM-TXT.    
           MOVE ZERO                         TO WS-77-FREE-FORM-LEN.    
           MOVE PROGRAM-NAME                 TO WS-77-CREATED-BY.       
           PERFORM 8895-INSERT-WORK-QUEUE    THRU 8895-EXIT.            
           MOVE ZEROES                       TO WS-77-COMMENTS-LEN.     
           MOVE SPACES                       TO WS-77-COMMENTS-TEXT     
                                                 WS-COMMENTS-TEMP.      
           MOVE ZEROES                        TO WS-HOLD-WQ-CATEGORY.   
      *                                                                         
       5900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6025-ISSUE-CHKP.                                                 
      *================================================================*        
      *                                                                         
           ADD 1                       TO WS-CHKP-SEQ-NO.               
           MOVE WS-CHKP-SEQ-NO         TO WS-RESTART-CHKP-SEQ-NO.       
           MOVE WS-FCSBW06-REC-CNTR    TO WS-RESTART-FBW06-REC-CNTR     
           MOVE WS-FCSBW85-REC-CNTR    TO WS-RESTART-RECORD-NO          
           COMPUTE WS-RESTART-RECORD-NO = WS-RESTART-RECORD-NO - 1      
           MOVE WS-PREV-METER-ID       TO WS-RESTART-METER-ID           
           MOVE WS-BD-REGISTER-CODE    TO WS-RESTART-REGISTER-CODE      
      *                                                                         
           PERFORM 6030-WRITE-RSDDR                  THRU 6030-EXIT.    
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                                        
           MOVE ZEROS                  TO WS-COMMIT-ROUTES              
           DISPLAY 'COMMIT POINT# ' WS-CHKP-SEQ-NO ' TAKEN.'            
                   'LAST SP PROCESSED :' WS-PREV-SERVICE-POINT-ID.      
      *                                                                         
       6025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6030-WRITE-RSDDR.                                                
      *================================================================*        
      *                                                                         
           MOVE WS-ONE                 TO RF-PARTITION-NO.              
           MOVE PROGRAM-NAME           TO RF-NAME-PROGRAM.              
           MOVE WS-ONE                 TO RF-DUP-CNTRL-NO.              
           MOVE WS-RESTART-DATA        TO RF-RESTART-DATA-TEXT.         
           MOVE WS-RESTART-DATA-LENGTH TO RF-RESTART-DATA-LEN.          
           PERFORM 8896-UPDATE-RESTART THRU 8896-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8897-INSERT-RESTART THRU 8897-EXIT                
           END-IF.                                                      
      *                                                                         
       6030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * 6253-GET-FJC01-CHKP-LIMIT.                                              
       COPY CPD00034.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
      *** CHECK JOB PARM TABLE TO GET WS-RESTART-REQ FLAG                       
      * 6235-GET-FJC01-RESTART-REQ.                                             
       COPY CPD00035.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
       COPY CPD00040.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
       COPY CPD00037.                                                           
      *================================================================*        
                                                                        
      ******************************************************************        
      * COPYBOOK TO GET THE NEXT BUSINESS DAY                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00315                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * COPYBOOK TO GET THE MOST CURRENT ACCOUNT AT A PREMISE         *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * ERROR ROUTINE TO HANDLE ERRORS FROM CPDCA099                   *        
      ******************************************************************        
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = WS-811                            
              MOVE AT-ACCOUNT-NO          TO WS-CPD99-ACCOUNT-NO        
           ELSE                                                         
              MOVE WS-CPD99-RETURN-CODE TO WS-DISPLAY-SQLCODE           
              DISPLAY '****************************************'        
              DISPLAY '**  PCSBW185 PROCESSING ERROR         **'        
              DISPLAY '**  ERROR IN PARAGRAPH ' ACTIVE-PARAGRAPH        
              DISPLAY '**  PREMISE-NO      = ' WS-CPD99-PREMISE-NO      
              DISPLAY '**  SQLCODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7000-READ-FIOBW85.                                               
      *===============================================================*         
      *                                                                         
           READ FCSBW85-FILE                                            
                 AT END MOVE 'Y'          TO WS-BW85-EOF.               
      *                                                                         
           EVALUATE TRUE                                                
               WHEN FBW85-SUCCESSFUL                                    
                   ADD 1                  TO WS-FCSBW85-REC-CNTR        
               WHEN FBW85-READ-EOF                                      
                   CONTINUE                                             
               WHEN OTHER                                               
                  DISPLAY '****************************************'    
                  DISPLAY '** PCSBW185 PROCESSING ERROR          **'    
                  DISPLAY '** ABEND IN PARAGRAPH 7000            **'    
                  DISPLAY '** ERROR ON READING BW85 FILE         **'    
                  DISPLAY '** BW85 STATUS = ' WS-FBW85-STATUS           
                  DISPLAY '****************************************'    
                  PERFORM 9900-ABEND          THRU 9900-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7060-GET-DEFAULT-FROM-EM.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT EM.DIGTL_MTR_TYPE                                  
                    ,EM.PROGRAM_ID                                      
               INTO :EM-DIGTL-MTR-TYPE                                  
                   ,:EM-PROGRAM-ID                                      
                FROM CSS_ELEC_METER EM WITH(READUNCOMMITTED)                    
               WHERE EM.COMPANY_NO     = :EM-COMPANY-NO                 
                 AND EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE             
                 AND EM.METER_NO       = :EM-METER-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EM.DIGTL_MTR_TYPE                                          
MFA-TR*             ,EM.PROGRAM_ID                                              
MFA-TR*        INTO :EM-DIGTL-MTR-TYPE                                          
MFA-TR*            ,:EM-PROGRAM-ID                                              
MFA-TR*         FROM CSS_ELEC_METER EM                                          
MFA-TR*        WHERE EM.COMPANY_NO     = :EM-COMPANY-NO                         
MFA-TR*          AND EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                     
MFA-TR*          AND EM.METER_NO       = :EM-METER-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7060            **'        
              DISPLAY '** COMPANY_NO     = ' EM-COMPANY-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' EM-CODE-UTIL-TYPE          
              DISPLAY '** METER_NO       = ' EM-METER-NO                
              DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7100-SELECT-ROUTE-HEADER.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT UPLOAD_DATE                                        
                    ,PC_ROUTE_IND                                       
                    ,DOWNLOAD_METERS                                    
                    ,UPLOAD_METERS                                      
               INTO :RH-UPLOAD-DATE :WS-NULL-IND                         
                   ,:RH-PC-ROUTE-IND                                    
                   ,:RH-DOWNLOAD-METERS                                 
                   ,:RH-UPLOAD-METERS                                   
               FROM CSS_ROUTE_HEADER WITH(READUNCOMMITTED)                      
               WHERE LOCAL_OFFICE  = :RH-LOCAL-OFFICE                   
                 AND READ_CYCLE    = :RH-READ-CYCLE                     
                 AND READ_ROUTE    = :RH-READ-ROUTE                     
                 AND REVENUE_MONTH = :RH-REVENUE-MONTH                  
                 AND COMPANY_NO    = :RH-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UPLOAD_DATE                                                
MFA-TR*             ,PC_ROUTE_IND                                               
MFA-TR*             ,DOWNLOAD_METERS                                            
MFA-TR*             ,UPLOAD_METERS                                              
MFA-TR*        INTO :RH-UPLOAD-DATE:WS-NULL-IND                                 
MFA-TR*            ,:RH-PC-ROUTE-IND                                            
MFA-TR*            ,:RH-DOWNLOAD-METERS                                         
MFA-TR*            ,:RH-UPLOAD-METERS                                           
MFA-TR*        FROM CSS_ROUTE_HEADER                                            
MFA-TR*        WHERE LOCAL_OFFICE  = :RH-LOCAL-OFFICE                           
MFA-TR*          AND READ_CYCLE    = :RH-READ-CYCLE                             
MFA-TR*          AND READ_ROUTE    = :RH-READ-ROUTE                             
MFA-TR*          AND REVENUE_MONTH = :RH-REVENUE-MONTH                          
MFA-TR*          AND COMPANY_NO    = :RH-COMPANY-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7100            **'        
              DISPLAY '** LOCAL OFFICE   = ' RH-LOCAL-OFFICE            
              DISPLAY '** READ CYCLE     = ' RH-READ-CYCLE              
              DISPLAY '** READ ROUTE     = ' RH-READ-ROUTE              
              DISPLAY '** REVENUE MONTH  = ' RH-REVENUE-MONTH           
              DISPLAY '** COMPANY NO     = ' RH-COMPANY-NO              
              DISPLAY '** SQL CODE       = ' WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *===============================================================*         
       7150-SELECT-REVENUE-MONTH.                                       
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) REVENUE_MONTH,
              OPTIMUM_READ_DATE                                  
               INTO :RW-REVENUE-MONTH                                   
                   ,:RW-OPTIMUM-READ-DATE                               
               FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                       
               WHERE DATE_MTR_RD_XTRCT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                
                 AND READ_CYCLE         = :RW-READ-CYCLE                
               ORDER BY OPTIMUM_READ_DATE DESC                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REVENUE_MONTH                                              
MFA-TR*             ,OPTIMUM_READ_DATE                                          
MFA-TR*        INTO :RW-REVENUE-MONTH                                           
MFA-TR*            ,:RW-OPTIMUM-READ-DATE                                       
MFA-TR*        FROM CSS_READ_WINDOW                                             
MFA-TR*        WHERE DATE_MTR_RD_XTRCT <= :WS-INPUT-DATE                        
MFA-TR*          AND READ_CYCLE         = :RW-READ-CYCLE                        
MFA-TR*        ORDER BY OPTIMUM_READ_DATE DESC                                  
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
             ELSE                                                       
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7150            **'        
              DISPLAY '** READ CYCLE         = ' RW-READ-CYCLE          
              DISPLAY '** DATE_MTR_RD_XTRCT <= ' WS-INPUT-DATE          
              DISPLAY '** SQL CODE           = ' WS-DISPLAY-SQLCODE     
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7210-OPEN-RD-FMT-CURSOR.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN RD_FMT                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7210            **'        
              DISPLAY '** SELECT ALL ROWS FROM MTR_RD_FMT    **'        
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7220-FETCH-RD-FMT-CURSOR.                                        

MSQ008     MOVE 1200 TO MSQ008-RD-FMT
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FOR :MSQ008-RD-FMT
              FETCH 
              FROM RD_FMT               
                INTO :TAB-CODE-UTIL-TYPE                                
                    ,:TAB-DIGTL-MTR-TYPE                                
                    ,:TAB-PROGRAM-ID                                    
                    ,:TAB-MTR-READ-SOURCE-CD                            
                    ,:TAB-REMOTE-READ-IND                               
                    ,:TAB-CODE-USAGE-TYPE                               
                    ,:TAB-CODE-TIME-PERIOD                              
                    ,:TAB-CODE-TOU-SEASN                                
                    ,:TAB-CODE-USAGE-ID                                 
                    ,:TAB-CODE-USAGE-SOURCE                             
                    ,:TAB-MTR-RD-DISP-CD                                
                    ,:TAB-INDEX-VALUE-CD                                
                    ,:TAB-NO-READ-DIGITS                                
                    ,:TAB-NO-READ-DECIMALS                              
                    ,:TAB-READ-SEQUENCE-NO                              
                    ,:TAB-CNSMPTN-READ-FL                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM RD_FMT FOR 1200 ROWS                      
MFA-TR*         INTO :TAB-CODE-UTIL-TYPE                                        
MFA-TR*             ,:TAB-DIGTL-MTR-TYPE                                        
MFA-TR*             ,:TAB-PROGRAM-ID                                            
MFA-TR*             ,:TAB-MTR-READ-SOURCE-CD                                    
MFA-TR*             ,:TAB-REMOTE-READ-IND                                       
MFA-TR*             ,:TAB-CODE-USAGE-TYPE                                       
MFA-TR*             ,:TAB-CODE-TIME-PERIOD                                      
MFA-TR*             ,:TAB-CODE-TOU-SEASN                                        
MFA-TR*             ,:TAB-CODE-USAGE-ID                                         
MFA-TR*             ,:TAB-CODE-USAGE-SOURCE                                     
MFA-TR*             ,:TAB-MTR-RD-DISP-CD                                        
MFA-TR*             ,:TAB-INDEX-VALUE-CD                                        
MFA-TR*             ,:TAB-NO-READ-DIGITS                                        
MFA-TR*             ,:TAB-NO-READ-DECIMALS                                      
MFA-TR*             ,:TAB-READ-SEQUENCE-NO                                      
MFA-TR*             ,:TAB-CNSMPTN-READ-FL                                       
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-RD-FMT
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)              TO WS-RD-FMT-COUNT           
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7220            **'        
              DISPLAY '** SELECT ALL ROWS FROM MTR_RD_FMT    **'        
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7230-CLOSE-RD-FMT-CURSOR.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE RD_FMT                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7230            **'        
              DISPLAY '** CLOSE ERROR FOR RD_FMT CURSOR      **'        
              DISPLAY '** SQL CODE      = ' WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7300-OPEN-METER-CURSOR.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN MTR_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7300            **'        
              DISPLAY '** COMPANY_NO     = ' AT-COMPANY-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' MN-CODE-UTIL-TYPE          
              DISPLAY '** METER_NO       = ' MN-METER-NO                
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7310-FETCH-METER-CURSOR.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH MTR_CSR                                            
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-PREMISE-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-COMPANY-NO                                      
                   ,:UT-RATE-PLAN-NO                                    
                   ,:UT-READ-CYCLE                                      
                   ,:UT-READ-ROUTE                                      
                   ,:MN-CODE-METER-STATUS                               
                   ,:MN-REMOTE-READ-IND                                 
                   ,:MN-MTR-READ-SOURCE-CD                              
                   ,:MN-DIGTL-MTR-TYPE                                  
                   ,:MN-PROGRAM-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7310            **'        
              DISPLAY '** COMPANY_NO     = ' AT-COMPANY-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' MN-CODE-UTIL-TYPE          
              DISPLAY '** METER_NO       = ' MN-METER-NO                
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7320-CLOSE-METER-CURSOR.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE MTR_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7320            **'        
              DISPLAY '** COMPANY_NO     = ' AT-COMPANY-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' MN-CODE-UTIL-TYPE          
              DISPLAY '** METER_NO       = ' MN-METER-NO                
              DISPLAY '** SQL CODE      = ' WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7330-SELECT-RATE-VERSION.                                        
      *================================================================*        
      * SELECT RATE VERSION                                            *        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) VERSION_NO_CNTRL                                  
                 INTO :RT-VERSION-NO-CNTRL                              
                 FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)                    
                WHERE CODE_UTIL_TYPE     = :RT-CODE-UTIL-TYPE           
                  AND RATE_PLAN_NO       = :RT-RATE-PLAN-NO             
                  AND CODE_STATUS        = 'A'                          
                  AND FROM_EFFECTIVE_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )               
                ORDER BY FROM_EFFECTIVE_DT DESC                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VERSION_NO_CNTRL                                          
MFA-TR*          INTO :RT-VERSION-NO-CNTRL                                      
MFA-TR*          FROM CSS_RATE_CREATOR                                          
MFA-TR*         WHERE CODE_UTIL_TYPE     = :RT-CODE-UTIL-TYPE                   
MFA-TR*           AND RATE_PLAN_NO       = :RT-RATE-PLAN-NO                     
MFA-TR*           AND CODE_STATUS        = 'A'                                  
MFA-TR*           AND FROM_EFFECTIVE_DT <= :WS-INPUT-DATE                       
MFA-TR*         ORDER BY FROM_EFFECTIVE_DT DESC                                 
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7330                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7330            **'        
              DISPLAY '** ACCOUNT_NO     = ' AT-ACCOUNT-NO              
              DISPLAY '** RATE_PLAN_NO   = ' RT-RATE-PLAN-NO            
              DISPLAY '** CODE_UTIL_TYPE = ' RT-CODE-UTIL-TYPE          
              DISPLAY '** CODE_STATUS    =  A'                          
              DISPLAY '** FROM_EFFECTIVE_DT <= ' WS-INPUT-DATE          
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7340-SELECT-SEASONS.                                             
      *================================================================*        
      * SELECT SEASON DETAILS                                          *        
      *                                                                         
           EXEC SQL                                                     
               SELECT DATE_FROM                                         
                     ,DATE_TO                                           
                     ,CODE_SEASON                                       
                 INTO :RS-DATE-FROM                                     
                     ,:RS-DATE-TO                                       
                     ,:RS-CODE-SEASON                                   
                 FROM CSS_RATE_USE_SEASN WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE   = :RS-CODE-UTIL-TYPE             
                  AND RATE_PLAN_NO     = :RS-RATE-PLAN-NO               
                  AND VERSION_NO_CNTRL = :RS-VERSION-NO-CNTRL           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_FROM                                                 
MFA-TR*              ,DATE_TO                                                   
MFA-TR*              ,CODE_SEASON                                               
MFA-TR*          INTO :RS-DATE-FROM                                             
MFA-TR*              ,:RS-DATE-TO                                               
MFA-TR*              ,:RS-CODE-SEASON                                           
MFA-TR*          FROM CSS_RATE_USE_SEASN                                        
MFA-TR*         WHERE CODE_UTIL_TYPE   = :RS-CODE-UTIL-TYPE                     
MFA-TR*           AND RATE_PLAN_NO     = :RS-RATE-PLAN-NO                       
MFA-TR*           AND VERSION_NO_CNTRL = :RS-VERSION-NO-CNTRL                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7340                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7340            **'        
              DISPLAY '** ACCOUNT_NO       = ' AT-ACCOUNT-NO            
              DISPLAY '** RATE_PLAN_NO     = ' RS-RATE-PLAN-NO          
              DISPLAY '** CODE_UTIL_TYPE   = ' RS-CODE-UTIL-TYPE        
              DISPLAY '** VERSION_NO_CNTRL = ' RS-VERSION-NO-CNTRL      
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7350-GET-SEASN-PRT-TYPE.                                         
      *================================================================*        
      * SELECT SEASONAL PRORATE TYPE                                   *        
      *                                                                         
           EXEC SQL                                                     
               SELECT SEAS_PRORATE_CD                                   
                 INTO :J4-SEAS-PRORATE-CD                               
                 FROM CSS_RATE_VRSN_DEF WITH(READUNCOMMITTED)                   
                WHERE CODE_UTIL_TYPE   = :J4-CODE-UTIL-TYPE             
                  AND RATE_PLAN_NO     = :J4-RATE-PLAN-NO               
                  AND VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SEAS_PRORATE_CD                                           
MFA-TR*          INTO :J4-SEAS-PRORATE-CD                                       
MFA-TR*          FROM CSS_RATE_VRSN_DEF                                         
MFA-TR*         WHERE CODE_UTIL_TYPE   = :J4-CODE-UTIL-TYPE                     
MFA-TR*           AND RATE_PLAN_NO     = :J4-RATE-PLAN-NO                       
MFA-TR*           AND VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7350                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7350            **'        
              DISPLAY '** ACCOUNT_NO       = ' AT-ACCOUNT-NO            
              DISPLAY '** RATE_PLAN_NO     = ' J4-RATE-PLAN-NO          
              DISPLAY '** CODE_UTIL_TYPE   = ' J4-CODE-UTIL-TYPE        
              DISPLAY '** VERSION_NO_CNTRL = ' J4-VERSION-NO-CNTRL      
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7360-ADD-ONE-DAY.                                                
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DB2-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DB2-DATE
              ) <> 0) OR (LEN(:WS-DB2-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-DB2-DATE
              ), CONVERT(DATE, :WS-DB2-DATE) ) )
            INTO
              :WS-DB2-DATE             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DB2-DATE = DATE(:WS-DB2-DATE) + 1 DAY                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7360            **'        
              DISPLAY '** ADD ONE DAY TO ===> ' WS-DB2-DATE             
              DISPLAY '** ACCOUNT_NO        = ' AT-ACCOUNT-NO           
              DISPLAY '** METER_NO          = ' MN-METER-NO             
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7400-SELECT-RESTART-DATA.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT RESTART_DATA                                       
                INTO :RF-RESTART-DATA                                   
                FROM CSS_RESTART WITH(READUNCOMMITTED)                          
               WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                  
                 AND PARTITION_NO   = :RF-PARTITION-NO                  
                 AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESTART_DATA                                               
MFA-TR*         INTO :RF-RESTART-DATA                                           
MFA-TR*         FROM CSS_RESTART                                                
MFA-TR*        WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                          
MFA-TR*          AND PARTITION_NO   = :RF-PARTITION-NO                          
MFA-TR*          AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7400            **'        
              DISPLAY '** NAME_PROGRAM    = ' RF-NAME-PROGRAM           
              DISPLAY '** PARTITION_NO    = ' RF-PARTITION-NO           
              DISPLAY '** DUP_CNTRL_NO    = ' RF-DUP-CNTRL-NO           
              DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7420-GET-METER-CHNG-TMST.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS           
                 INTO :1E-LAST-UPDATE-TS                                
                 FROM CSS_MDM_SS_INTF_CH WITH(READUNCOMMITTED)                  
                WHERE SERVICE_POINT_ID  = :1E-SERVICE-POINT-ID          
                  AND COLUMN_NA         = :1E-COLUMN-NA                 
                  AND PREV_COLUMN_VALUE = :1E-PREV-COLUMN-VALUE         
                ORDER BY LAST_UPDATE_TS DESC                            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LAST_UPDATE_TS                                            
MFA-TR*          INTO :1E-LAST-UPDATE-TS                                        
MFA-TR*          FROM CSS_MDM_SS_INTF_CH                                        
MFA-TR*         WHERE SERVICE_POINT_ID  = :1E-SERVICE-POINT-ID                  
MFA-TR*           AND COLUMN_NA         = :1E-COLUMN-NA                         
MFA-TR*           AND PREV_COLUMN_VALUE = :1E-PREV-COLUMN-VALUE                 
MFA-TR*         ORDER BY LAST_UPDATE_TS DESC                                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7420                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7420            **'        
              DISPLAY '** SERVICE_POINT_ID = ' 1E-SERVICE-POINT-ID      
              DISPLAY '** COLUMN_NA = ' 1E-COLUMN-NA                    
              DISPLAY '** PREV_COLUMN_VALUE = ' 1E-PREV-COLUMN-VALUE    
              DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7430-GET-ACCOUNT-CHNG-TMST.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              PREV_COLUMN_VALUE                                 
                 INTO :1E-LAST-UPDATE-TS                                
                     ,:1E-PREV-COLUMN-VALUE                             
                 FROM CSS_MDM_SS_INTF_CH WITH(READUNCOMMITTED)                  
                WHERE SERVICE_POINT_ID  = :1E-SERVICE-POINT-ID          
                  AND COLUMN_NA         = :1E-COLUMN-NA                 
                ORDER BY LAST_UPDATE_TS DESC                            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LAST_UPDATE_TS                                            
MFA-TR*              ,PREV_COLUMN_VALUE                                         
MFA-TR*          INTO :1E-LAST-UPDATE-TS                                        
MFA-TR*              ,:1E-PREV-COLUMN-VALUE                                     
MFA-TR*          FROM CSS_MDM_SS_INTF_CH                                        
MFA-TR*         WHERE SERVICE_POINT_ID  = :1E-SERVICE-POINT-ID                  
MFA-TR*           AND COLUMN_NA         = :1E-COLUMN-NA                         
MFA-TR*         ORDER BY LAST_UPDATE_TS DESC                                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7430                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7430            **'        
              DISPLAY '** SERVICE_POINT_ID = ' 1E-SERVICE-POINT-ID      
              DISPLAY '** COLUMN_NA = ' 1E-COLUMN-NA                    
              DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7450-GET-OLD-METER-DETAILS.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT CIS.DECIMAL2DECIMAL(COALESCE(MD3.PREV_COLUMN_VALUE        
                                    , MI.ACCOUNT_NO ))                  
                     ,0                                                 
                     ,0                                                 
                     ,MI.CODE_ACCT_STAT                                 
                     ,MI.LOCAL_OFFICE                                   
                     ,MI.BILL_CYCLE                                     
                     ,'01'                                              
                     ,MI.RATE_PLAN_NO                                   
                     ,MI.READ_CYCLE                                     
                     ,MI.READ_ROUTE                                     
                     ,MI.CODE_METER_STATUS                              
                     ,MI.REMOTE_READ_IND                                
                     ,'P'                                               
                     ,COALESCE(MD1.PREV_COLUMN_VALUE                    
                                  , MI.DIGTL_MTR_TYPE)                  
                     ,COALESCE(MD2.PREV_COLUMN_VALUE                    
                                    , MI.PROGRAM_ID )                   
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-PREMISE-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-COMPANY-NO                                      
                   ,:UT-RATE-PLAN-NO                                    
                   ,:UT-READ-CYCLE                                      
                   ,:UT-READ-ROUTE                                      
                   ,:MN-CODE-METER-STATUS                               
                   ,:MN-REMOTE-READ-IND                                 
                   ,:MN-MTR-READ-SOURCE-CD                              
                   ,:MN-DIGTL-MTR-TYPE                                  
                   ,:MN-PROGRAM-ID                                      
                FROM CSS_MDM_SS_INTF MI WITH(READUNCOMMITTED)                   
                    LEFT JOIN CSS_MDM_SS_INTF_CH MD1
                           WITH(READUNCOMMITTED)                    
                  ON (MI.SERVICE_POINT_ID = MD1.SERVICE_POINT_ID        
                      AND MD1.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )       
                      AND MD1.COLUMN_NA = 'DIGTL_MTR_TYPE')             
                    LEFT JOIN CSS_MDM_SS_INTF_CH MD2
                           WITH(READUNCOMMITTED)                    
                  ON (MI.SERVICE_POINT_ID = MD2.SERVICE_POINT_ID        
                      AND MD2.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )       
                      AND MD2.COLUMN_NA = 'PROGRAM_ID'    )             
                    LEFT JOIN CSS_MDM_SS_INTF_CH MD3
                           WITH(READUNCOMMITTED)                    
                  ON (MI.SERVICE_POINT_ID = MD3.SERVICE_POINT_ID        
                      AND MD3.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )       
                      AND MD3.COLUMN_NA = 'ACCOUNT_NO'    )             
                WHERE MI.SERVICE_POINT_ID = :1E-SERVICE-POINT-ID        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DECIMAL(COALESCE(MD3.PREV_COLUMN_VALUE                    
MFA-TR*                             , MI.ACCOUNT_NO ))                          
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,MI.CODE_ACCT_STAT                                         
MFA-TR*              ,MI.LOCAL_OFFICE                                           
MFA-TR*              ,MI.BILL_CYCLE                                             
MFA-TR*              ,'01'                                                      
MFA-TR*              ,MI.RATE_PLAN_NO                                           
MFA-TR*              ,MI.READ_CYCLE                                             
MFA-TR*              ,MI.READ_ROUTE                                             
MFA-TR*              ,MI.CODE_METER_STATUS                                      
MFA-TR*              ,MI.REMOTE_READ_IND                                        
MFA-TR*              ,'P'                                                       
MFA-TR*              ,COALESCE(MD1.PREV_COLUMN_VALUE                            
MFA-TR*                           , MI.DIGTL_MTR_TYPE)                          
MFA-TR*              ,COALESCE(MD2.PREV_COLUMN_VALUE                            
MFA-TR*                             , MI.PROGRAM_ID )                           
MFA-TR*        INTO :AT-ACCOUNT-NO                                              
MFA-TR*            ,:AT-PREMISE-NO                                              
MFA-TR*            ,:AT-CUSTOMER-NO                                             
MFA-TR*            ,:AT-CODE-ACCT-STAT                                          
MFA-TR*            ,:AT-LOCAL-OFFICE                                            
MFA-TR*            ,:AT-BILL-CYCLE                                              
MFA-TR*            ,:AT-COMPANY-NO                                              
MFA-TR*            ,:UT-RATE-PLAN-NO                                            
MFA-TR*            ,:UT-READ-CYCLE                                              
MFA-TR*            ,:UT-READ-ROUTE                                              
MFA-TR*            ,:MN-CODE-METER-STATUS                                       
MFA-TR*            ,:MN-REMOTE-READ-IND                                         
MFA-TR*            ,:MN-MTR-READ-SOURCE-CD                                      
MFA-TR*            ,:MN-DIGTL-MTR-TYPE                                          
MFA-TR*            ,:MN-PROGRAM-ID                                              
MFA-TR*         FROM CSS_MDM_SS_INTF MI                                         
MFA-TR*             LEFT JOIN CSS_MDM_SS_INTF_CH MD1                            
MFA-TR*           ON (MI.SERVICE_POINT_ID = MD1.SERVICE_POINT_ID                
MFA-TR*               AND MD1.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS               
MFA-TR*               AND MD1.COLUMN_NA = 'DIGTL_MTR_TYPE')                     
MFA-TR*             LEFT JOIN CSS_MDM_SS_INTF_CH MD2                            
MFA-TR*           ON (MI.SERVICE_POINT_ID = MD2.SERVICE_POINT_ID                
MFA-TR*               AND MD2.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS               
MFA-TR*               AND MD2.COLUMN_NA = 'PROGRAM_ID'    )                     
MFA-TR*             LEFT JOIN CSS_MDM_SS_INTF_CH MD3                            
MFA-TR*           ON (MI.SERVICE_POINT_ID = MD3.SERVICE_POINT_ID                
MFA-TR*               AND MD3.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS               
MFA-TR*               AND MD3.COLUMN_NA = 'ACCOUNT_NO'    )                     
MFA-TR*         WHERE MI.SERVICE_POINT_ID = :1E-SERVICE-POINT-ID                
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7450                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7450            **'        
              DISPLAY '** SERVICE_POINT_ID = ' 1E-SERVICE-POINT-ID      
              DISPLAY '** COLUMN_NA = ' 1E-COLUMN-NA                    
              DISPLAY '** LAST_UPDATE_TS = ' 1E-LAST-UPDATE-TS          
              DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7455-GET-OLD-ACC-DETAILS.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT 0                                                 
                     ,0                                                 
                     ,MI.CODE_ACCT_STAT                                 
                     ,MI.LOCAL_OFFICE                                   
                     ,MI.BILL_CYCLE                                     
                     ,'01'                                              
                     ,MI.RATE_PLAN_NO                                   
                     ,MI.READ_CYCLE                                     
                     ,MI.READ_ROUTE                                     
                     ,MI.CODE_METER_STATUS                              
                     ,MI.REMOTE_READ_IND                                
                     ,'P'                                               
                     ,COALESCE(MD1.PREV_COLUMN_VALUE                    
                                  , MI.DIGTL_MTR_TYPE)                  
                     ,COALESCE(MD2.PREV_COLUMN_VALUE                    
                                    , MI.PROGRAM_ID )                   
               INTO :AT-PREMISE-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-COMPANY-NO                                      
                   ,:UT-RATE-PLAN-NO                                    
                   ,:UT-READ-CYCLE                                      
                   ,:UT-READ-ROUTE                                      
                   ,:MN-CODE-METER-STATUS                               
                   ,:MN-REMOTE-READ-IND                                 
                   ,:MN-MTR-READ-SOURCE-CD                              
                   ,:MN-DIGTL-MTR-TYPE                                  
                   ,:MN-PROGRAM-ID                                      
                FROM CSS_MDM_SS_INTF MI WITH(READUNCOMMITTED)                   
                    LEFT JOIN CSS_MDM_SS_INTF_CH MD1
                           WITH(READUNCOMMITTED)                    
                  ON (MI.SERVICE_POINT_ID = MD1.SERVICE_POINT_ID        
                      AND MD1.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )       
                      AND MD1.COLUMN_NA = 'DIGTL_MTR_TYPE')             
                    LEFT JOIN CSS_MDM_SS_INTF_CH MD2
                           WITH(READUNCOMMITTED)                    
                  ON (MI.SERVICE_POINT_ID = MD2.SERVICE_POINT_ID        
                      AND MD2.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )       
                      AND MD2.COLUMN_NA = 'PROGRAM_ID'    )             
                    LEFT JOIN CSS_MDM_SS_INTF_CH MD3
                           WITH(READUNCOMMITTED)                    
                  ON (MI.SERVICE_POINT_ID = MD3.SERVICE_POINT_ID        
                      AND MD3.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )       
                      AND MD3.COLUMN_NA = 'ACCOUNT_NO'    )             
                WHERE MI.SERVICE_POINT_ID = :1E-SERVICE-POINT-ID        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,MI.CODE_ACCT_STAT                                         
MFA-TR*              ,MI.LOCAL_OFFICE                                           
MFA-TR*              ,MI.BILL_CYCLE                                             
MFA-TR*              ,'01'                                                      
MFA-TR*              ,MI.RATE_PLAN_NO                                           
MFA-TR*              ,MI.READ_CYCLE                                             
MFA-TR*              ,MI.READ_ROUTE                                             
MFA-TR*              ,MI.CODE_METER_STATUS                                      
MFA-TR*              ,MI.REMOTE_READ_IND                                        
MFA-TR*              ,'P'                                                       
MFA-TR*              ,COALESCE(MD1.PREV_COLUMN_VALUE                            
MFA-TR*                           , MI.DIGTL_MTR_TYPE)                          
MFA-TR*              ,COALESCE(MD2.PREV_COLUMN_VALUE                            
MFA-TR*                             , MI.PROGRAM_ID )                           
MFA-TR*        INTO :AT-PREMISE-NO                                              
MFA-TR*            ,:AT-CUSTOMER-NO                                             
MFA-TR*            ,:AT-CODE-ACCT-STAT                                          
MFA-TR*            ,:AT-LOCAL-OFFICE                                            
MFA-TR*            ,:AT-BILL-CYCLE                                              
MFA-TR*            ,:AT-COMPANY-NO                                              
MFA-TR*            ,:UT-RATE-PLAN-NO                                            
MFA-TR*            ,:UT-READ-CYCLE                                              
MFA-TR*            ,:UT-READ-ROUTE                                              
MFA-TR*            ,:MN-CODE-METER-STATUS                                       
MFA-TR*            ,:MN-REMOTE-READ-IND                                         
MFA-TR*            ,:MN-MTR-READ-SOURCE-CD                                      
MFA-TR*            ,:MN-DIGTL-MTR-TYPE                                          
MFA-TR*            ,:MN-PROGRAM-ID                                              
MFA-TR*         FROM CSS_MDM_SS_INTF MI                                         
MFA-TR*             LEFT JOIN CSS_MDM_SS_INTF_CH MD1                            
MFA-TR*           ON (MI.SERVICE_POINT_ID = MD1.SERVICE_POINT_ID                
MFA-TR*               AND MD1.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS               
MFA-TR*               AND MD1.COLUMN_NA = 'DIGTL_MTR_TYPE')                     
MFA-TR*             LEFT JOIN CSS_MDM_SS_INTF_CH MD2                            
MFA-TR*           ON (MI.SERVICE_POINT_ID = MD2.SERVICE_POINT_ID                
MFA-TR*               AND MD2.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS               
MFA-TR*               AND MD2.COLUMN_NA = 'PROGRAM_ID'    )                     
MFA-TR*             LEFT JOIN CSS_MDM_SS_INTF_CH MD3                            
MFA-TR*           ON (MI.SERVICE_POINT_ID = MD3.SERVICE_POINT_ID                
MFA-TR*               AND MD3.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS               
MFA-TR*               AND MD3.COLUMN_NA = 'ACCOUNT_NO'    )                     
MFA-TR*         WHERE MI.SERVICE_POINT_ID = :1E-SERVICE-POINT-ID                
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7455                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW185 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7455            **'        
              DISPLAY '** SERVICE_POINT_ID = ' 1E-SERVICE-POINT-ID      
              DISPLAY '** COLUMN_NA = ' 1E-COLUMN-NA                    
              DISPLAY '** LAST_UPDATE_TS = ' 1E-LAST-UPDATE-TS          
              DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7455-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * 7600-START-FCSJC01                    *                                 
      *================================================================*        
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
      * 7620-START-FCSCA00 VSAM CTRL FILE     *                                 
      *================================================================*        
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       8000-WRITE-FIOBW06.                                              
      *================================================================*        
      *                                                                         
           WRITE FIOBW06-REC FROM FIOBW06.                              
      *                                                                         
           IF FBW06-SUCCESSFUL                                          
              ADD 1                TO WS-FCSBW06-REC-CNTR               
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**  PCSBW185 PROCESSING ERROR            **'     
              DISPLAY '**  ABEND IN PARAGRAPH 8000              **'     
              DISPLAY '**  ERROR ON FCSBW06 WRITE               **'     
              DISPLAY '**  FILE STATUS IS ' WS-FBW06-STATUS             
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8400-INSERT-ROUTE-HEADER.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_ROUTE_HEADER                            
                      (LOCAL_OFFICE,                                    
                       READ_CYCLE,                                      
                       READ_ROUTE,                                      
                       DOWNLOAD_DATE,                                   
                       UPLOAD_DATE,                                     
                       PC_ROUTE_IND,                                    
                       DOWNLOAD_METERS,                                 
                       UPLOAD_METERS,                                   
                       COMPANY_NO,                                      
                       REVENUE_MONTH,                                   
                       DOWN_RMVD_MTR_QT,                                
                       UP_RMVD_MTR_QT)                                  
                VALUES                                                  
                      (:RH-LOCAL-OFFICE,                                
                       :RH-READ-CYCLE,                                  
                       :RH-READ-ROUTE,                                  
                       IIF(TRY_CONVERT(DATE, :RH-DOWNLOAD-DATE
              ) IS NULL OR (PATINDEX('%.%', :RH-DOWNLOAD-DATE
              ) <> 0) OR (LEN(:RH-DOWNLOAD-DATE) <> 10), CIS.CHAR2DATE(
                                                      :RH-DOWNLOAD-DATE
              ), CONVERT(DATE, :RH-DOWNLOAD-DATE) ),                           
                       IIF(TRY_CONVERT(DATE, :RH-UPLOAD-DATE
              ) IS NULL OR (PATINDEX('%.%', :RH-UPLOAD-DATE
              ) <> 0) OR (LEN(:RH-UPLOAD-DATE) <> 10), CIS.CHAR2DATE(
                                                        :RH-UPLOAD-DATE
              ), CONVERT(DATE, :RH-UPLOAD-DATE) ),                             
                       :RH-PC-ROUTE-IND,                                
                       :RH-DOWNLOAD-METERS,                             
                       :RH-UPLOAD-METERS,                               
                       :RH-COMPANY-NO,                                  
                       :RH-REVENUE-MONTH,                               
                       :RH-DOWN-RMVD-MTR-QT,                            
                       :RH-UP-RMVD-MTR-QT)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ROUTE_HEADER                                    
MFA-TR*               (LOCAL_OFFICE,                                            
MFA-TR*                READ_CYCLE,                                              
MFA-TR*                READ_ROUTE,                                              
MFA-TR*                DOWNLOAD_DATE,                                           
MFA-TR*                UPLOAD_DATE,                                             
MFA-TR*                PC_ROUTE_IND,                                            
MFA-TR*                DOWNLOAD_METERS,                                         
MFA-TR*                UPLOAD_METERS,                                           
MFA-TR*                COMPANY_NO,                                              
MFA-TR*                REVENUE_MONTH,                                           
MFA-TR*                DOWN_RMVD_MTR_QT,                                        
MFA-TR*                UP_RMVD_MTR_QT)                                          
MFA-TR*         VALUES                                                          
MFA-TR*               (:RH-LOCAL-OFFICE,                                        
MFA-TR*                :RH-READ-CYCLE,                                          
MFA-TR*                :RH-READ-ROUTE,                                          
MFA-TR*                :RH-DOWNLOAD-DATE,                                       
MFA-TR*                :RH-UPLOAD-DATE,                                         
MFA-TR*                :RH-PC-ROUTE-IND,                                        
MFA-TR*                :RH-DOWNLOAD-METERS,                                     
MFA-TR*                :RH-UPLOAD-METERS,                                       
MFA-TR*                :RH-COMPANY-NO,                                          
MFA-TR*                :RH-REVENUE-MONTH,                                       
MFA-TR*                :RH-DOWN-RMVD-MTR-QT,                                    
MFA-TR*                :RH-UP-RMVD-MTR-QT)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL     TO SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '*******************************************'     
              DISPLAY '**  PCSBW185 PROCESSING ERROR            **'     
              DISPLAY '**  ABEND IN PARAGRAPH 8400              **'     
              DISPLAY '** LOCAL OFFICE     = ' RH-LOCAL-OFFICE          
              DISPLAY '** READ CYCLE       = ' RH-READ-CYCLE            
              DISPLAY '** READ ROUTE       = ' RH-READ-ROUTE            
              DISPLAY '** REVENUE MONTH    = ' RH-REVENUE-MONTH         
              DISPLAY '** COMPANY NO       = ' RH-COMPANY-NO            
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8450-UPDATE-ROUTE-HEADER.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_ROUTE_HEADER                                  
                  SET UPLOAD_DATE    = IIF(TRY_CONVERT(DATE, 
                                                        :RH-UPLOAD-DATE
              ) IS NULL OR (PATINDEX('%.%', :RH-UPLOAD-DATE
              ) <> 0) OR (LEN(:RH-UPLOAD-DATE) <> 10), CIS.CHAR2DATE(
                                                        :RH-UPLOAD-DATE
              ), CONVERT(DATE, :RH-UPLOAD-DATE) )                  
                     ,UPLOAD_METERS  = :RH-UPLOAD-METERS                
                WHERE LOCAL_OFFICE   = :RH-LOCAL-OFFICE                 
                  AND READ_CYCLE     = :RH-READ-CYCLE                   
                  AND READ_ROUTE     = :RH-READ-ROUTE                   
                  AND REVENUE_MONTH  = :RH-REVENUE-MONTH                
                  AND COMPANY_NO     = :RH-COMPANY-NO                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ROUTE_HEADER                                          
MFA-TR*           SET UPLOAD_DATE    = :RH-UPLOAD-DATE                          
MFA-TR*              ,UPLOAD_METERS  = :RH-UPLOAD-METERS                        
MFA-TR*         WHERE LOCAL_OFFICE   = :RH-LOCAL-OFFICE                         
MFA-TR*           AND READ_CYCLE     = :RH-READ-CYCLE                           
MFA-TR*           AND READ_ROUTE     = :RH-READ-ROUTE                           
MFA-TR*           AND REVENUE_MONTH  = :RH-REVENUE-MONTH                        
MFA-TR*           AND COMPANY_NO     = :RH-COMPANY-NO                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '*******************************************'     
              DISPLAY '**  PCSBW185 PROCESSING ERROR            **'     
              DISPLAY '**  ABEND IN PARAGRAPH 8450              **'     
              DISPLAY '** LOCAL OFFICE     = ' RH-LOCAL-OFFICE          
              DISPLAY '** READ CYCLE       = ' RH-READ-CYCLE            
              DISPLAY '** READ ROUTE       = ' RH-READ-ROUTE            
              DISPLAY '** REVENUE MONTH    = ' RH-REVENUE-MONTH         
              DISPLAY '** COMPANY NO       = ' RH-COMPANY-NO            
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8895-INSERT-WORK-QUEUE                                                  
      ******************************************************************        
      *                                                                         
       8895-INSERT-WORK-QUEUE.                                          
           MOVE SPACES TO ABEND-FUNCTION.                               
                                                                        
           CALL SCSCB077 USING CWS00077-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE                           
           MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
                                                                        
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              DISPLAY '8895-INSERT-WORK-QUEUE'                          
              DISPLAY 'CALL SCSCB077         '                          
              DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
              DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
              DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
              DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              PERFORM 9900-ABEND    THRU 9900-EXIT                      
           END-IF.                                                      
       8895-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       8896-UPDATE-RESTART.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '*******************************************'     
              DISPLAY '**  PCSBW185 PROCESSING ERROR            **'     
              DISPLAY '**  ABEND IN PARAGRAPH 8896              **'     
              DISPLAY '** NAME_PROGRAM     = ' RF-NAME-PROGRAM          
              DISPLAY '** PARTITION_NO     = ' RF-PARTITION-NO          
              DISPLAY '** DUP_CNTRL_NO     = ' RF-DUP-CNTRL-NO          
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8896-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8897-INSERT-RESTART.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM, PARTITION_NO, DUP_CNTRL_NO,           
                    RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM, :RF-PARTITION-NO,                 
                    :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '*******************************************'     
              DISPLAY '**  PCSBW185 PROCESSING ERROR            **'     
              DISPLAY '**  ABEND IN PARAGRAPH 8897              **'     
              DISPLAY '** NAME_PROGRAM     = ' RF-NAME-PROGRAM          
              DISPLAY '** PARTITION_NO     = ' RF-PARTITION-NO          
              DISPLAY '** DUP_CNTRL_NO     = ' RF-DUP-CNTRL-NO          
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8897-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **** RESET RESTART-REQ PARAMETER TO INACTIVE                              
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       9000-TERMINATE.                                                  
      *================================================================*        
      *                                                                         
           CLOSE FCSBW85-FILE.                                          
      *                                                                         
           IF FBW85-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**  PCSBW185 PROCESSING ERROR            **'     
              DISPLAY '**  ERROR IN PARAGRAPH 9000              **'     
              DISPLAY '**  ERROR ON FCSBW85 CLOSE               **'     
              DISPLAY '**  FILE STATUS IS ' WS-FBW85-STATUS             
              DISPLAY '**  PROCESSING CONTINUE ...              **'     
              DISPLAY '*******************************************'     
           END-IF.                                                      
      *                                                                         
           CLOSE FCSBW06-FILE.                                          
                                                                        
           IF FBW06-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**  PCSBW185 PROCESSING ERROR            **'     
              DISPLAY '**  ERROR IN PARAGRAPH 9000              **'     
              DISPLAY '**  ERROR ON FCSBW06 CLOSE               **'     
              DISPLAY '**  FILE STATUS IS ' WS-FBW06-STATUS             
              DISPLAY '**  PROCESSING CONTINUE ...              **'     
              DISPLAY '*******************************************'     
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
      *  COPY BOOK CONTAINING 9900-ABEND INCLUDES SQL ROLLBACK         *        
      *================================================================*        
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                *        
      ******************************************************************        
      ****************** END OF PCSBW185 *******************************        
      ******************************************************************        
      ***                                                            ***        
