       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW182.                                        
       INSTALLATION.                                                    
       DATE-WRITTEN.   JUL  2009.                                       
           DATE-COMPILED.                                               
      *****************************************************************         
      **                                                             **         
      **             SOUTH CAROLINA ELECTRICITY  & GAS               **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                     DB2                        *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** --------   --------      -----------------------------------**         
      ** 07/13/09   BILLING       NEW CODE FOR FCS                   **         
      **                                                             **         
A01738** 11/25/09   NC94746       GENERATE WQ ONLY WHEN NEW ERT NOT  **         
A01738**                          ATTACHED TO NEW METER. WRITE TOU   **         
A01738**                          DUMMY REC ONLY WHEN 'NO READ' ON   **         
A01738**                          1ST REGISTER AND SKIP ALL OTHER    **         
A01738**                          REGISTERS. REMOVE NUMERIC CHECK ON **         
A01738**                          EMPLOYEE NUMBER.                   **         
      **                                                             **         
A01738** 12/17/09   NC94746       FORMAT NEW METER NO BY PREFIX WITH **         
A01738**                          REQUIRED ZEROS. GET LATEST ACCOUNT **         
A01738**                          WHEN GIVEN METER NOT EXISTS IN MN. **         
P00251** 01/25/10   SS95855       Net Metering                       **         
P00251**                          -CODE_USAGE_ID & CODE_USAGE_SOURCE **         
P00251**                          added to FIOBW06 layout.           **         
P00251**                          -Populate these fields from MN     **         
P00251**                          when blank during transition.      **         
P00251**                          -Remove Mtr_Rd_Record_Cd references**         
P00251**                          in CSS_MTR_RD_FMT table.           **         
P00251**                          -Changed E-FBW81-USAGE-TYPE to     **         
P00251**                          E-FBW81-CODE-USAGE-TYPEto match    **         
P00251**                          DB2 name.                          **         
P00251** 05/04/10   SS95855       Net Metering                       **         
P00251**                          Fetch one row from CSS_MTR_CAP     **         
P00251**                          for both Normal & Co-gen Meters,   **         
P00251**                          as they have same number of read   **         
P00251**                          digits.                            **         
P00403** 07/04/10   SS95855       FCS Upgrade (2.x from 1.x) issue:  **         
P00403**                          Corrected CODE-METER-READ in case  **         
P00403**                          of manual read of ERT since CIS    **         
P00403**                          not receiving changed read method  **         
P00403**                          from FCS 2.x                       **         
P00403** 09/02/10   SS95855       Net metering                       **         
P00251**                          -Remove Mtr_Rd_Record_Cd references**         
P00251**                          in RD_FMT CURSOR.                  **         
ACT144** 07/05/10   BG17805       INCREASE OCCURS 1200               **         
ACT144**            APPL 3082     USING READ DIALS FROM MTR_RD_FMT   **         
ACT144**                          BEFORE GETTING FROM MTR_CAP.       **         
A03352*  07/12/11   MC95456       CHANGE WQ CATEGORY FROM 143 TO     **         
A03352*                           528 - SCEG (ROUTING CATEGORY OF 4) **         
A03352*                           529 - PSNC (ROUTING CATEGORY OF 1) **         
ACT016** 02/29/12   NC94746       A03967: ENHANCEMENT TO PROCESS AMR **         
ACT016**                          DRIVE-BY MANUAL READS FROM FCS.    **         
A04860* 2014-03-19  MR7E794       LOAD DIRECTLY CSS_WQ_ITEMS INSTEAD **         
A04860*             ACT055        OF CSS_WQ_ITEMS_MF BY CALLING SUB  **         
A04860*                           PROGRAM SCSCB077                   **         
ACT260* 2015-12-28  MC95456       INTIALIZE CWS00077 FIELDS BEFORE   **         
ACT260*             APPL5136      CALLING SCSCB077.                  **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSBW182 NARRATIVE                        
      *                                                                         
           THIS PROGRAM REFORMATS FIOBW81 TO VENDOR INDEPENDENT FORMAT  
           FIOBW06 AND UPDATE MN WITH TAMPER & METER LOC CODES, PR      
           WITH SPECIAL INSTRUCTIONS. ALSO UPDATES ROUTE_HEADER WITH    
           METER COUNTS OF EACH ROUTE.                                  
      /                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      * SELECT STMT FOR BW81 FILE  *                                            
       COPY CSSBW81.                                                            
      * SELECT STMT FOR BW06 FILE  *                                            
       COPY CSSBW06.                                                            
       COPY CSSBW06R.                                                           
      /                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      * FD STMT FOR BW81 FILE      *                                            
       COPY CFDBW81.                                                            
       COPY FIOBW81.                                                            
      * FD STMT FOR BW06 FILE      *                                            
       COPY CFDBW06.                                                            
       01  FIOBW06-REC                  PIC X(280).                     
      * FD STMT FOR BW06R FILE     *                                            
       COPY CFDBW06R.                                                           
       01  FIOBW06R-REC                 PIC X(280).                     
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-RD-FMT  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW182'.
MSQ017     COPY MFASQLM.
      *                                                                         
       COPY FIOBW06.                                                            
      *                                                                         
      ***************** COPY FIOBW01.                                           
      ***************************************************************           
      * FCA00-KEY          *                                                    
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      * IO AREA FOR PARM INPUT FILE 'A' *                                       
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *    DB2 TABLE DCLGENS USING IN THIS PROGRAM                              
      *****************************************************************         
      * CSS_ACCOUNT (AT)                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      * CSS_PREMISE (PR)                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      * CSS_CUST_PREM_HIST                                                      
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      * CSS_READ_WINDOW (RW)                                                    
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
      * CSS_MTRD_ENVRNMT (MN)                                                   
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      * CSS_REGISTER_READ (RG)                                                  
           EXEC SQL                                                             
              INCLUDE TBRGREAD                                                  
           END-EXEC.                                                            
      * CSS_METER_LOC                                                           
           EXEC SQL                                                             
              INCLUDE TBMTRLOC                                                  
           END-EXEC.                                                            
      * CSS_MTR_RD_INST                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRINS                                                  
           END-EXEC.                                                            
      * CSS_MTR_RD_FMT (OA)                                                     
           EXEC SQL                                                             
              INCLUDE TBRDFMT                                                   
           END-EXEC.                                                            
      * CSS_MODEL_SQL                                                           
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      * CSS_ROUTE_HEADER (RH)                                                   
           EXEC SQL                                                             
              INCLUDE TBRTEHDR                                                  
           END-EXEC.                                                            
      * CSS_MTR_CAP (MC)                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
      * CSS_BTCH_PARTITION (O5)                                                 
           EXEC SQL                                                             
              INCLUDE TBBTHPRT                                                  
           END-EXEC.                                                            
      * CSS_JOB_PARM (G6)                                                       
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      * CSS_HOLIDAY                                                             
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
      * CSS_RESTART (RF)                                                        
           EXEC SQL                                                             
              INCLUDE TBRESTRT                                                  
           END-EXEC.                                                            
      * CSS_LOC_OFF_CYC_RT                                                      
           EXEC SQL                                                             
              INCLUDE TBLCOFRT                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_METER_ATTCHMTS                                                      
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_MTR_ATT_TYPE                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRATP                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_READ_RT_SOURCE                                                      
           EXEC SQL                                                             
              INCLUDE TBRTSRCE                                                  
           END-EXEC.                                                            
      *                                                                         
      ***CSS_ELEC_METER                                                         
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ***CSS_GAS_METER                                                          
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      *                                                                         
       01 WS-TEMP-VAR-AREA.                                             
          05 WS-PREV-WORK-SET-ID            PIC X(08).                  
          05 WS-WORKSET-ID.                                             
             10 WS-WORKSET-COMPANY        PIC X(01).                    
             10 WS-WORKSET-CYCLE          PIC X(02).                    
             10 WS-WORKSET-ROUTE          PIC 9(04).                    
             10 WS-WORKSET-LOC REDEFINES WS-WORKSET-ROUTE.              
                15 WS-WORKSET-LOC-ZERO    PIC 9(01).                    
                15 WS-WORKSET-LOC-NUM     PIC X(03).                    
             10 WS-WORKSET-SUFIX          PIC X(01).                    
      *                                                                         
          05  WS-ROUTE-TYPE-SW        PIC X(01) VALUE ' '.              
              88  WS-MANUAL-ROUTE               VALUE 'X'.              
              88  WS-MRMS-ROUTE                 VALUE 'M'.              
              88  WS-AROP-ROUTE                 VALUE 'A'.              
      *                                                                         
       01  WS-ABEND-AREA.                                               
           05  WS-ABEND-SPACE            PIC X              VALUE SPACE.
           05  WS-ABEND-NUMERIC REDEFINES WS-ABEND-SPACE                
                                         PIC 9.                         
A04860*                                                                         
A04860     05  SCSCB077                  PIC X(08)  VALUE 'SCSCB077'.   
      /                                                                         
       01  WS-LITERALS.                                                 
           05  WS-90                     PIC X(02)  VALUE '90'.         
           05  WS-H                      PIC X(01)  VALUE 'H'.          
           05  WS-G                      PIC X(01)  VALUE 'G'.          
           05  WS-E                      PIC X(01)  VALUE 'E'.          
           05  WS-YES                    PIC X(01)  VALUE 'Y'.          
           05  WS-Y                      PIC X(01)  VALUE 'Y'.          
           05  WS-N                      PIC X(01)  VALUE 'N'.          
           05  WS-NO                     PIC X(01)  VALUE 'N'.          
           05  WS-ONE                    PIC X(01)  VALUE '1'.          
           05  WS-PGRMNAME               PIC X(08)  VALUE 'PCSBW182'.   
           05  PROGRAM-NAME              PIC X(08)  VALUE 'PCSBW182'.   
           05  RS-RETURN-CODE            PIC S9(09) VALUE +000 COMP.    
           05  RS-RETURN-CODE-DISP       PIC S9(09) VALUE +000 COMP.    
           05  WS-PSNC                   PIC X(02)  VALUE '26'.         
           05  WS-ROWS-EXISTS            PIC X(01)  VALUE ' '.          
           05  WS-RRI-0                  PIC X(01)  VALUE '0'.          
           05  WS-811                   PIC S9(9) VALUE -811 COMP.      
      /                                                                         
A04860 01  WS-INPUT-TS.                                                 
A04860     05  WS-INPUT-DATE-TS          PIC X(10).                     
A04860     05  WS-INPUT-TS-REF           PIC X(16)                      
A04860                                   VALUE '-00.00.00.000000'.      
       01  WS-SWITCHES.                                                 
           05  WS-REG-MATCH-FOUND-FL           PIC  9(01) VALUE 0.      
               88 NO-REG-MATCH-FOUND                    VALUE 0.        
               88 REG-MATCH-FOUND                       VALUE 1.        
           05  WS-FBW81-STATUS           PIC X(02).                     
               88  FBW81-SUCCESSFUL                 VALUE '00'.         
               88  FBW81-READ-EOF                   VALUE '10'.         
           05  WS-FBW06-STATUS           PIC X(02).                     
               88  FBW06-SUCCESSFUL                 VALUE '00'.         
           05  WS-FBW06R-STATUS          PIC X(02).                     
               88  FBW06R-SUCCESSFUL                VALUE '00'.         
               88  FBW06R-END-OF-FILE               VALUE '10'.         
           05  WS-BW81-EOF               PIC X(01)  VALUE 'N'.          
               88  BW81-EOF-REACHED                 VALUE 'Y'.          
           05  WS-VALID-BW81-REC-FL      PIC 9(01)  VALUE 0.            
               88  VALID-BW81-REC                   VALUE 0.            
               88  NOT-VALID-BW81-REC               VALUE 1.            
           05  WS-MID-OF-MONTH           PIC X(01)  VALUE 'N'.          
               88  MID-MONTH-READ                   VALUE 'Y'.          
           05  WS-BW81-REG-SEQ-CHG-FLG   PIC X(01)  VALUE 'N'.          
               88 WS-BW81-REG-SEQ-NOT-CHG           VALUE 'N'.          
               88 WS-BW81-REG-SEQ-CHG               VALUE 'Y'.          
      *                                                                         
          05 WS-MN-UPDATE-REQUIRE-FL             PIC 9(01) VALUE 0.     
             88 MN-UPDATE-NOT-REQUIRE              VALUE 0.             
             88 MN-UPDATE-REQUIRE                  VALUE 1.             
          05 WS-REMOTE-READ-IND-FL               PIC X(01).             
              88 MANUAL-MTR                          VALUE '0'.         
              88 AMR-MTR                             VALUE 'A'.         
              88 NON-TOU-MTR                         VALUE '0' 'A'.     
              88 TOU-MANUAL                          VALUE 'M'.         
              88 TOU-ONLY                            VALUE 'T'.         
              88 TOU-IDR                             VALUE 'B'.         
              88 IDR-ONLY                            VALUE 'I'.         
              88 OPTICAL-PROB-MTR                    VALUE 'T' 'B' 'I'. 
ACT016*                                                                         
ACT016    05 WS-FCS-READ-CODE-SW              PIC S9(04) COMP VALUE 0.  
ACT016       88 NO-READ-CODE                      VALUE 0, 2, 11, 99.   
ACT016       88 REGULAR-READ-CODE                 VALUE 1, 4, 15.       
ACT016       88 OPTICAL-READ-CODE                 VALUE 9.              
ACT016       88 AMR-READ-CODE                     VALUE 3, 12, 14.      
ACT016       88 CUSTOMER-READ-CODE                VALUE 5.              
ACT016       88 FIELD-EST-READ-CODE               VALUE 6.              
ACT016       88 SCAN-REMOTE-READ-CODE             VALUE 7.              
ACT016       88 MANU-REMOTE-READ-CODE             VALUE 8.              
ACT016       88 MANU-TOU-READ-CODE                VALUE 10.             
ACT016       88 OFFICE-READ-CODE                  VALUE 13.             
          05 WS-MTR-CHNG-FIELDS.                                        
             10 FILLER                        PIC X(01).                
             10 MTR-SEQ-NUM-CHNG-FL           PIC X(01).                
                88 MTR-SEQ-NUM-CHNGD               VALUE '1'.           
                88 MTR-SEQ-NUM-NOT-CHNGD           VALUE '0' ' '.       
             10 MTR-NUMBER-CHNG-FL            PIC X(01).                
                88 MTR-NUMBER-CHNGD                VALUE '1'.           
                88 MTR-NUMBER-NOT-CHNGD            VALUE '0' ' '.       
             10 MTR-TYP-CHNG-FL               PIC X(01).                
                88 MTR-TYP-CHNGD                   VALUE '1'.           
                88 MTR-TYP-NOT-CHNGD               VALUE '0' ' '.       
             10 INST-LOC-CD1-CHNG-FL          PIC X(01).                
                88 INST-LOC-CD1-CHNGD              VALUE '1'.           
                88 INST-LOC-CD1-NOT-CHNGD          VALUE '0' ' '.       
             10 FILLER                        PIC X(01).                
             10 INST-LOC-CD2-CHNG-FL          PIC X(01).                
                88 INST-LOC-CD2-CHNGD              VALUE '1'.           
                88 INST-LOC-CD2-NOT-CHNGD          VALUE '0' ' '.       
             10 FILLER                        PIC X(01).                
             10 INST-LOC-CD3-CHNG-FL          PIC X(01).                
                88 INST-LOC-CD3-CHNGD              VALUE '1'.           
                88 INST-LOC-CD3-NOT-CHNGD          VALUE '0' ' '.       
             10 SPL-MSG-CHNG-FL               PIC X(01).                
                88 SPL-MSG-CHNGD                   VALUE '1'.           
                88 SPL-MSG-NOT-CHNGD               VALUE '0' ' '.       
             10 FILLER                        PIC X(01).                
             10 FILLER                        PIC X(01).                
             10 FILLER                        PIC X(08).                
      *                                                                         
          05 WS-MSI-CHNG-FIELDS.                                        
             10 FILLER                           PIC X(01).             
             10 WS-READ-TYP-CD-CHNG-FL           PIC X(01).             
             10 WS-READ-METHOD-CHNG-FL           PIC X(01).             
                88 READ-METHOD-CHNGD               VALUE '1'.           
                88 READ-METHOD-NOT-CHNGD           VALUE '0' ' '.       
             10 WS-READ-DIALS-CHNG-FL            PIC X(01).             
                88 READ-DIALS-CHNGD                VALUE '1'.           
                88 READ-DIALS-NOT-CHNGD            VALUE '0' ' '.       
             10 WS-READ-DECIMALS-CHNG-FL         PIC X(01).             
                88 READ-DECIMALS-CHNGD             VALUE '1'.           
                88 READ-DECIMALS-NOT-CHNGD         VALUE '0' ' '.       
             10 WS-CONSTANT-CHNG-FL              PIC X(01).             
                88 CONSTANT-CHNGD                  VALUE '1'.           
                88 CONSTANT-NOT-CHNGD              VALUE '0' ' '.       
             10 WS-TEXT-PROMPT-CHNG-FL           PIC X(01).             
                88 TEXT-PROMPT-CHNGD               VALUE '1'.           
                88 TEXT-PROMPT-NOT-CHNGD           VALUE '0' ' '.       
             10 FILLER                           PIC X(13).             
      *                                                                         
      *                                                                         
          05 WS-READ-METHOD                     PIC 9(01).              
             88 READ-METHOD-MANUAL                 VALUE 0.             
             88 READ-METHOD-OPTICAL                VALUE 1.             
             88 READ-METHOD-REMOTE                 VALUE 2.             
             88 READ-METHOD-WALK-BY                VALUE 3.             
             88 READ-METHOD-DRIVE-BY               VALUE 4.             
             88 READ-METHOD-NO-READ                VALUE 5.             
             88 READ-METHOD-EKA                    VALUE 6.             
      *                                                                         
           05  WS-MTR-SEQ-REQ-SW        PIC  X(1) VALUE ' '.            
               88  WS-MTR-SEQ-REQ-NONE            VALUE ' '.            
               88  WS-MTR-SEQ-REQ                 VALUE 'Y'.            
               88  WS-MTR-SEQ-NOT-REQ             VALUE 'N'.            
      *                                                                         
       01 WS-BTCH-PARTITION.                                            
          05 WS-BTCH-PART-ROWS    OCCURS 10 TIMES                       
                  INDEXED BY WS-PART-INDX.                              
             10  WS-PARTITION-ID           PIC X(8).                    
COB305       10 WS-BEGIN-PART-RANGE        PIC S9(13)V COMP-3 VALUE 0.         
COB305       10 WS-END-PART-RANGE        PIC S9(13)V COMP-3 VALUE 0.         
      *                                                                         
       01  WS-WORK-DATE                  PIC X(10).                     
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND               PIC S9(4) COMP.                
       01  WS-CURRENT-DATE.                                             
           03  WS-CURRENT-DATE-CC        PIC 9(2).                      
           03  WS-CURRENT-DATE-YY        PIC 9(2).                      
           03  FILLER                    PIC X(1)   VALUE '-'.          
           03  WS-CURRENT-DATE-MM        PIC 9(2).                      
           03  FILLER                    PIC X(1)   VALUE '-'.          
           03  WS-CURRENT-DATE-DD        PIC 9(2).                      
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-REVENUE-MONTH          PIC X(06).                     
           05  WS-COMPANY-NO             PIC X(02)  VALUE '01'.         
           05  WS-SAVE-COMPANY-NO        PIC X(02)  VALUE SPACES.       
           05  WS-PREV-READ-CYCLE        PIC X(02)  VALUE '00'.         
           05  WS-NO-MO-RECORDS          PIC S9(07) COMP.               
           05  WS-MTR-COUNT              PIC S9(07) COMP.               
           05  WS-UPLOAD-MTR             PIC S9(07) COMP.               
           05  WS-TEMP-CHG-NOTES         PIC X(114).                    
           05  WS-I                      PIC X(01)  VALUE 'I'.          
           05  WS-EXISTS                 PIC X(01)  VALUE SPACE.        
           05  WS-ACCOUNT-NO-PART        PIC S9(13)V COMP-3 VALUE ZERO. 
           05  WS-PART-COUNT             PIC S9(04) COMP VALUE ZERO.    
           05  WS-EMPLOYEE-NO            PIC X(09).                     
           05  WS-NO-MORE-ROWS           PIC X(1)          VALUE 'N'.   
           05  WS-NUM-OF-DIALS           PIC 9(01)         VALUE 5.     
           05  WS-EXCESS-INDX-DGT        PIC 9(08)         VALUE ZERO.  
           05  WS-METER-NO               PIC X(09).                     
           05  WS-NEW-METER-NO           PIC X(09).                     
           05  WS-METER-NO-JUSTIFIED     PIC X(09) JUSTIFIED RIGHT.     
           05  WS-DATE-TRANS             PIC X(10)         VALUE SPACES.
           05  WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(04) COMP-3 VALUE ZERO.
           05  WS-OMR-CODE-METER-READ    PIC X(01)         VALUE SPACES.
           05 WS-METER-FOUND-FL          PIC 9(01) VALUE 0.             
              88 METER-NOT-FOUND                   VALUE 0.             
              88 NEW-METER-FOUND                   VALUE 1.             
              88 OLD-METER-FOUND                   VALUE 2.             
              88 METER-FOUND                       VALUE 1 2.           
           05 WS-MRF-LOOKUP-REQ-FL       PIC 9(01) VALUE 0.             
              88 MRF-LOOKUP-NOT-REQ                VALUE 0.             
              88 MRF-LOOKUP-REQ                    VALUE 1.             
           05  WS-CURR-READ-VALUE        PIC 9(08)         VALUE ZEROS. 
           05  WS-CURNT-CHGD-RD-VAL      PIC 9(08)         VALUE ZEROS. 
      *                                                                         
       01  WS-COMMENTS.                                                 
           05  FILLER                      PIC X(37)  VALUE             
               'WARNING: INVALID MTR READ INSTRUCTION'.                 
           05  WS-RD-INST                  PIC X(01).                   
           05  FILLER                      PIC X(02)  VALUE ', '.       
           05  WS-RD-INST-VAL              PIC X(02).                   
           05  FILLER                      PIC X(11)  VALUE             
               ' ON METER: '.                                           
           05  WS-WQ-METER-NO              PIC X(09).                   
      *                                                                         
       01  WS-WORK-QUEUE-DIRECTION.                                     
           05  WS-CATEGORY-ID              PIC S9(04)  COMP VALUE 141.  
           05  WS-CATEGORY-ID-157          PIC S9(04)  COMP VALUE 157.  
           05  WS-CATEGORY-ID-173          PIC S9(04)  COMP VALUE 173.  
           05  WS-CATEGORY-ID-282          PIC S9(04)  COMP VALUE 282.  
           05  WS-CATEGORY-ID-283          PIC S9(04)  COMP VALUE 283.  
           05  WS-CATEGORY-ID-284          PIC S9(04)  COMP VALUE 284.  
           05  WS-CATEGORY-ID-289          PIC S9(04)  COMP VALUE 289.  
           05  WS-CATEGORY-ID-232          PIC S9(04)  COMP VALUE 232.  
A03352     05  WS-CATEGORY-ID-528          PIC S9(04)  COMP VALUE 528.  
A03352     05  WS-CATEGORY-ID-529          PIC S9(04)  COMP VALUE 529.  
           05  WS-CATEGORY-ID-15           PIC S9(04)  COMP VALUE  15.  
A03352     05  WS-ROUTING-CATEGORY         PIC X(01)   VALUE ' '.       
           05  WS-NORMAL-PRIORITY          PIC X(01)   VALUE 'N'.       
           05  WS-WQ-COMMENTS              PIC X(100)  VALUE SPACES.    
           05  WS-HOLD-WQ-CATEGORY         PIC 9(03).                   
           05  WS-COMMENTS-TEMP            PIC X(223).                  
           05  WS-WQ-BIN-NO                PIC X(02).                   
           05  WS-WQ-SLOT-NO               PIC X(02).                   
      *                                                                         
       01  WS-ERROR-MESSAGES.                                           
           05  MSG-INVALID-SLOT-NO             PIC X(46)  VALUE         
                     'WARNING:INVALID SLOT-NO FROM MTR_RD_FMT TABLE;'.  
           05  MSG-INVALID-BIN-NO              PIC X(46)  VALUE         
                     'WARNING:INVALID BIN-NO FROM MTR_RD_FMT TABLE;'.   
           05  MSG-NOT-VALID-READ.                                      
               10  FILLER                      PIC X(33)  VALUE         
                   'WARNING:IT IS NOT A VALID READ = '.                 
               10  MSG-READ-VALUE              PIC X(15).               
               10  FILLER                      PIC X(50)  VALUE         
                   ';VERIFY MTR_RD_FMT TABLE FOR BIN/SLOT POSITIONS;'.  
           05  MSG-CHG-DIALS                   PIC X(33)  VALUE         
               'WARNING:NO OF DIALS HAS CHANGED. '.                     
           05  MSG-CHG-DECIMALS                PIC X(36)  VALUE         
               'WARNING:NO OF DECIMALS HAS CHANGED. '.                  
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
           05  WS-RESTART-JOB-COMPLETE     REDEFINES                    
               WS-RESTART-PROCESS-TYPE     PIC X(01).                   
           05  WS-RESTART-JOB-STATUS       PIC X(01).                   
               88  WS-RUN-COMPLETED-NO-PROBLEMS VALUE 'A'.              
               88  WS-RERUN-COMPLETED           VALUE 'B'.              
               88  WS-RERUN-PENDING             VALUE 'C'.              
           05  WS-RESTART-INPUT-DATE       PIC X(10).                   
           05  WS-RESTART-WORKSET-ID       PIC X(08) VALUE SPACES.      
           05  WS-RESTART-ACCOUNT-NO       PIC 9(13) VALUE ZERO.        
           05  WS-RESTART-METER-NO         PIC X(09) VALUE SPACES.      
           05  WS-RESTART-CHKP-SEQ-NO      PIC 9(09) VALUE ZERO.        
           05  WS-RESTART-RECORD-NO        PIC 9(09) VALUE ZERO.        
           05  WS-RESTART-FBW06-REC-CNTR   PIC 9(09) VALUE ZERO.        
           05  WS-RESTART-RH-UPDT-CNTR-TOT PIC 9(09) VALUE ZERO.        
           05  WS-RESTART-RH-ISRT-CNTR-TOT PIC 9(09) VALUE ZERO.        
           05  WS-RESTART-MN-UPDT-CNTR-TOT PIC 9(09) VALUE ZERO.        
           05  WS-RESTART-RG-UPDT-CNTR-TOT PIC 9(09) VALUE ZERO.        
           05  WS-RESTART-PR-UPDT-CNTR-TOT PIC 9(09) VALUE ZERO.        
           05  WS-RESTART-WQ-COUNT         PIC 9(09) VALUE ZERO.        
           05  WS-RESTART-ROUTE-CNTR-TOT   PIC 9(09) VALUE ZERO.        
      *                                                                         
       01  WS-RESTART-MISC.                                             
           05  WS-COMMIT-REQ-SW            PIC 9(1) VALUE 0.            
               88 COMMITS-REQUIRE                   VALUE 0.            
               88 COMMITS-NOT-REQUIRE               VALUE 1.            
           05  WS-RESTART-DATA-LENGTH    PIC S9(04) COMP VALUE +132.    
           05  WS-IS-THIS-A-RESTART      PIC X(01) VALUE 'N'.           
               88  WS-THIS-IS-A-RESTART            VALUE 'Y'.           
           05  WS-RESTART-REQ            PIC X(01).                     
           05  WS-DEFAULT-RESTART-REQ    PIC X(01) VALUE 'N'.           
           05  WS-REPOSITION-NEEDED      PIC X(01) VALUE 'Y'.           
           05  WS-FCSBW81-REC-CNTR         PIC S9(09) COMP VALUE ZERO.  
           05  WS-FCSBW06-REC-CNTR         PIC S9(09) COMP VALUE ZERO.  
           05  WS-CHKP-SEQ-NO              PIC 9(05) VALUE ZERO.        
           05  WS-COMMIT-ROUTES            PIC 9(07) VALUE ZERO.        
           05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-LUW-LIMIT           PIC 9(04).                   
           05  WS-CHKP-UPD-LIMIT           PIC 9(04).                   
      *****************************************************************         
      *  THE FOLLOWING FIELDS ARE TO STORE OFF THE DATABASE UPDATE              
      *  COUNTERS "PER LUW" AN LUW = 1 ENTRY IN THE JOB PARM TABLE              
      *****************************************************************         
           05  WS-DISP-MN-UCNTR                   PIC ZZZ,ZZ9.          
           05  WS-DISP-RG-UCNTR                   PIC ZZZ,ZZ9.          
           05  WS-DISP-PR-UCNTR                   PIC ZZZ,ZZ9.          
           05  WS-DISP-RH-UCNTR                   PIC ZZZ,ZZ9.          
           05  WS-DISP-RH-ICNTR                   PIC ZZZ,ZZ9.          
           05  WS-DISP-WQ-COUNT                   PIC ZZZ,ZZ9.          
           05  WS-DISP-ROUTE-COUNT                PIC ZZZ,ZZ9.          
      *                                                                         
       01 WS-TEMP-VAR.                                                  
          05 WS-DISPLAY-SQLCODE              PIC ---9.                  
          05 WS-CODE-UTIL-TYPE               PIC X(01) VALUE SPACES.    
          05 WS-MTR-READ-SOURCE-CD           PIC X(01) VALUE SPACES.    
          05 WS-REMOTE-READ-IND              PIC X(01) VALUE SPACES.    
          05 WS-PROGRAM-ID                   PIC X(02) VALUE SPACES.    
          05 WS-DIGTL-MTR-TYPE               PIC X(03) VALUE SPACES.    
          05 WS-CODE-USAGE-TYPE              PIC X(01) VALUE SPACES.    
          05 WS-CODE-TIME-PERIOD             PIC 9(04) VALUE ZEROES.    
          05 WS-CODE-TOU-SEASN               PIC X(01) VALUE SPACES.    
P00251    05 WS-CODE-USAGE-ID                PIC X(01) VALUE SPACES.    
P00251    05 WS-CODE-USAGE-SOURCE            PIC X(01) VALUE SPACES.    
          05 WS-CNSMPTN-READ-FL              PIC X(01) VALUE SPACES.    
          05 WS-INDEX-VALUE-CD               PIC X(01) VALUE SPACES.    
          05 WS-MTR-RD-DISP-CD               PIC X(03) VALUE SPACES.    
          05 WS-TEXT-PROMPT-RIR              PIC 9(04) VALUE ZEROES.    
          05 WS-MTR-SKIP-COUNT               PIC S9(07) COMP VALUE 0.   
          05 WS-REG-SKIP-COUNT               PIC S9(05) COMP VALUE 0.   
          05 WS-PREV-ACCOUNT-NO              PIC 9(13).                 
          05 WS-SAVE-ACCOUNT-NO              PIC 9(13).                 
          05 WS-PREV-METER-CATEGORY          PIC 9(01).                 
          05 WS-PREV-METER-NO                PIC X(09).                 
          05 WS-SAVE-METER-NO                PIC X(09).                 
          05 WS-READ-DIGITS                  PIC S9(4) COMP VALUE 0.    
          05 WS-READ-DECIMALS                PIC S9(4) COMP VALUE 0.    
          05 WS-READ                         PIC 9(10) VALUE 0.         
          05 WS-READ-CODE                    PIC 9(02) VALUE 0.         
          05 WS-READ-CODITION                PIC 9(02) VALUE 0.         
          05 WS-ERT-READ-STATUS              PIC 9(01) VALUE 0.         
          05 WS-SAVE-DB-PART-DREC            PIC 9(01) VALUE ZERO.      
          05 WS-SAVE-READ-DATETIME.                                     
             10 WS-SAVE-READ-DATE            PIC X(10) VALUE SPACES.    
             10 FILLER                       PIC X(01) VALUE SPACES.    
             10 WS-SAVE-READ-TIME            PIC X(08) VALUE SPACES.    
          05 WS-DUMMY-VAR1                   PIC S9(4) COMP VALUE 0.    
          05 WS-MTR-REG-COUNT                PIC S9(4) COMP VALUE 0.    
       01 WS-FIOBW06-TABLE.                                             
          05 BW06-SUB                      PIC S9(04) COMP.             
          05 WS-FIOBW06-REC OCCURS 50 TIMES.                            
             10 WS-FBW06-ACCOUNT-NO              PIC 9(13).             
             10 WS-FBW06-METER-NO                PIC X(09).             
             10 WS-FBW06-CODE-UTIL-TYPE          PIC X(01).             
             10 WS-FBW06-CODE-USAGE-TYPE         PIC X(01).             
             10 WS-FBW06-CODE-TIME-PERIOD        PIC 9(04).             
             10 WS-FBW06-CODE-TOU-SEASN          PIC X(01).             
P00251       10 WS-FBW06-CODE-USAGE-ID           PIC X(01).             
P00251       10 WS-FBW06-CODE-USAGE-SOURCE       PIC X(01).             
P00251       10 FILLER                           PIC X(09).             
             10 WS-FBW06-REG-MEASURE-CD          PIC X(03).             
             10 WS-FBW06-METER-READING           PIC 9(12)V9(3).        
             10 WS-FBW06-DATE-READ               PIC X(10).             
             10 WS-FBW06-TIME-READ               PIC X(08).             
             10 WS-FBW06-CODE-METER-READ         PIC X(01).             
             10 WS-FBW06-CODE-METER-NO-READ      PIC X(01).             
             10 WS-FBW06-MTR-COMMENT-TX          PIC X(40).             
             10 WS-FBW06-MTR-COND-CD1            PIC X(02).             
             10 WS-FBW06-MTR-COND-CD2            PIC X(02).             
A01738       10 WS-FBW06-EMPLOYEE-NO             PIC X(09).             
             10 WS-FBW06-MTR-READ-SOURCE-CD      PIC X(01).             
             10 WS-FBW06-CNSMPTN-READ-FL         PIC X(01).             
             10 WS-FBW06-INDEX-VALUE-CD          PIC X(01).             
             10 WS-FBW06-READ-PROCESS-CD         PIC X(01).             
             10 WS-FBW06-BTU-FACTOR              PIC 9(02)V9(5).        
             10 WS-FBW06-READ-ITEM-STATUS        PIC X(01).             
             10 WS-FBW06-WORKSET-ID              PIC X(08).             
             10 FILLER                           PIC X(128).            
             10 WS-FBW06-DB-PART-DREC            PIC 9(01).             
      *                                                                         
       01  WS-MTR-RD-FMT-TABLE.                                         
           05 WS-RD-FMT-COUNT          PIC 9(05) VALUE ZERO.            
           05 WS-MRF-SUB               PIC 9(05) VALUE ZERO.            
           05 WS-MRF-TABLE.                                             
ACT144        10 TAB-CODE-UTIL-TYPE     OCCURS 1200 TIMES  PIC X(01).   
ACT144        10 TAB-DIGTL-MTR-TYPE     OCCURS 1200 TIMES  PIC X(03).   
ACT144        10 TAB-PROGRAM-ID         OCCURS 1200 TIMES  PIC X(02).   
ACT144        10 TAB-MTR-READ-SOURCE-CD OCCURS 1200 TIMES  PIC X(01).   
ACT144        10 TAB-REMOTE-READ-IND    OCCURS 1200 TIMES  PIC X(01).   
ACT144        10 TAB-CODE-USAGE-TYPE    OCCURS 1200 TIMES  PIC X(01).   
ACT144        10 TAB-CODE-TIME-PERIOD   OCCURS 1200 TIMES               
                                                PIC S9(4) USAGE COMP.   
ACT144        10 TAB-CODE-TOU-SEASN     OCCURS 1200 TIMES  PIC X(01).   
ACT144        10 TAB-CODE-USAGE-ID      OCCURS 1200 TIMES  PIC X(01).   
ACT144        10 TAB-CODE-USAGE-SOURCE  OCCURS 1200 TIMES  PIC X(01).   
ACT144        10 TAB-MTR-RD-DISP-CD     OCCURS 1200 TIMES  PIC X(03).   
ACT144        10 TAB-INDEX-VALUE-CD     OCCURS 1200 TIMES  PIC X(01).   
ACT144        10 TAB-NO-READ-DIGITS     OCCURS 1200 TIMES               
                                                PIC S9(4) USAGE COMP.   
ACT144        10 TAB-NO-READ-DECIMALS   OCCURS 1200 TIMES               
                                                PIC S9(4) USAGE COMP.   
ACT144        10 TAB-READ-SEQUENCE-NO   OCCURS 1200 TIMES               
                                                PIC S9(4) USAGE COMP.   
ACT144        10 TAB-CNSMPTN-READ-FL    OCCURS 1200 TIMES  PIC X(01).   
      *                                                                         
       01  WS-MATCH-REG-ARRAY.                                          
           05 WS-MATCH-REG-COUNT       PIC 9(05) VALUE ZERO.            
           05 WS-MRF-SUB2              PIC 9(05) VALUE ZERO.            
           05 WS-MATCH-REG-ROW OCCURS   50  TIMES.                      
              10 ARR-CODE-USAGE-TYPE    PIC X(01).                      
              10 ARR-CODE-TIME-PERIOD   PIC S9(4) USAGE COMP.           
              10 ARR-CODE-TOU-SEASN     PIC X(01).                      
P00251        10 ARR-CODE-USAGE-ID      PIC X(01).                      
P00251        10 ARR-CODE-USAGE-SOURCE  PIC X(01).                      
              10 ARR-MTR-RD-DISP-CD     PIC X(03).                      
              10 ARR-INDEX-VALUE-CD     PIC X(01).                      
              10 ARR-NO-READ-DIGITS     PIC S9(4) USAGE COMP.           
              10 ARR-NO-READ-DECIMALS   PIC S9(4) USAGE COMP.           
              10 ARR-READ-SEQUENCE-NO   PIC S9(4) USAGE COMP.           
              10 ARR-CNSMPTN-READ-FL    PIC X(01).                      
              10 ARR-MATCH-FOUND        PIC X(01).                      
      *                                                                         
      * ABEND SWITCH         *                                                  
       COPY CWS09900.                                                           
                                                                        
      * WARNING DATA         *                                                  
       COPY CWS00303.                                                           
                                                                        
      * WS ABEND WORK AREA   *                                                  
       COPY CWS00010.                                                           
                                                                        
      * MISC INPUT           *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
                                                                        
      * FCA00 MISC INPUT     *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
                                                                        
      * WS NEXT BUSINESS DAY *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00315                                                  
           END-EXEC.                                                            
      *                                                                         
A01738*****************************************************************         
A01738*    WORKING STORAGE COPY BOOK FOR CPDCA099                     *         
A01738*****************************************************************         
A01738     EXEC SQL                                                             
A01738         INCLUDE CWS00099                                                 
A01738     END-EXEC.                                                            
A01738*                                                                         
A04860******************************************************************        
A04860* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
A04860******************************************************************        
A04860*                                                                         
A04860     EXEC SQL                                                             
A04860        INCLUDE CWS00077                                                  
A04860     END-EXEC.                                                            
A04860*                                                                         
      ******************************************************************        
      * CURSOR FOR FETCH PARTITION DATA                                *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE BTCH_PARTITION CURSOR FOR                       
                 SELECT PARTITION_ID,                                   
                        BEGIN_PART_RANGE,                               
                        END_PART_RANGE                                  
                   FROM CSS_BTCH_PARTITION WITH(READUNCOMMITTED)                
                  WHERE PARTITION_ID BETWEEN                            
                        'ATPART00' AND 'ATPART09'                       
                   ORDER BY PARTITION_ID                                
                  FOR READ ONLY                                 
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE BTCH_PARTITION CURSOR FOR                               
MFA-TR*          SELECT PARTITION_ID,                                           
MFA-TR*                 BEGIN_PART_RANGE,                                       
MFA-TR*                 END_PART_RANGE                                          
MFA-TR*            FROM CSS_BTCH_PARTITION                                      
MFA-TR*           WHERE PARTITION_ID BETWEEN                                    
MFA-TR*                 'ATPART00' AND 'ATPART09'                               
MFA-TR*            ORDER BY PARTITION_ID                                        
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7500                                                  
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * DECLARE CURSOR FOR METER READ FORMAT                           *        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE RD_FMT CURSOR WITH ROWSET POSITIONING FOR          
P00251       SELECT CODE_UTIL_TYPE                                      
                   ,DIGTL_MTR_TYPE                                      
                   ,PROGRAM_ID                                          
                   ,MTR_READ_SOURCE_CD                                  
                   ,REMOTE_READ_IND                                     
                   ,CODE_USAGE_TYPE                                     
                   ,CODE_TIME_PERIOD                                    
                   ,CODE_TOU_SEASN                                      
P00251             ,CODE_USAGE_ID                                       
P00251             ,CODE_USAGE_SOURCE                                   
                   ,MTR_RD_DISP_CD                                      
                   ,INDEX_VALUE_CD                                      
                   ,NO_READ_DIGITS                                      
                   ,NO_READ_DECIMALS                                    
                   ,READ_SEQUENCE_NO                                    
                   ,CNSMPTN_READ_FL                                     
             FROM CSS_MTR_RD_FMT WITH(READUNCOMMITTED)                          
             ORDER BY CODE_UTIL_TYPE                                    
                     ,DIGTL_MTR_TYPE DESC                               
                     ,PROGRAM_ID                                        
                     ,MTR_READ_SOURCE_CD                                
                     ,REMOTE_READ_IND                                   
                     ,READ_SEQUENCE_NO                                  
             FOR READ ONLY                                      
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE RD_FMT CURSOR WITH ROWSET POSITIONING FOR                  
MFA-TR*      SELECT CODE_UTIL_TYPE                                              
MFA-TR*            ,DIGTL_MTR_TYPE                                              
MFA-TR*            ,PROGRAM_ID                                                  
MFA-TR*            ,MTR_READ_SOURCE_CD                                          
MFA-TR*            ,REMOTE_READ_IND                                             
MFA-TR*            ,CODE_USAGE_TYPE                                             
MFA-TR*            ,CODE_TIME_PERIOD                                            
MFA-TR*            ,CODE_TOU_SEASN                                              
MFA-TR*            ,CODE_USAGE_ID                                               
MFA-TR*            ,CODE_USAGE_SOURCE                                           
MFA-TR*            ,MTR_RD_DISP_CD                                              
MFA-TR*            ,INDEX_VALUE_CD                                              
MFA-TR*            ,NO_READ_DIGITS                                              
MFA-TR*            ,NO_READ_DECIMALS                                            
MFA-TR*            ,READ_SEQUENCE_NO                                            
MFA-TR*            ,CNSMPTN_READ_FL                                             
MFA-TR*      FROM CSS_MTR_RD_FMT                                                
MFA-TR*      ORDER BY CODE_UTIL_TYPE                                            
MFA-TR*              ,DIGTL_MTR_TYPE DESC                                       
MFA-TR*              ,PROGRAM_ID                                                
MFA-TR*              ,MTR_READ_SOURCE_CD                                        
MFA-TR*              ,REMOTE_READ_IND                                           
MFA-TR*              ,READ_SEQUENCE_NO                                          
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *********************** END DECLARATIVES ******************               
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *   0000-MAINLINE                                                *        
      *        CONTROLS THE MAIN PATH OF PROGRAM                       *        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
      *                                                                         
           PERFORM 0400-LOAD-RD-FMT-TAB    THRU 0400-EXIT.              
      *                                                                         
           PERFORM 1000-PROCESS-BW81       THRU 1000-EXIT               
                                   UNTIL BW81-EOF-REACHED.              
      *                                                                         
           PERFORM 3000-WRITE-CNTRL-REC    THRU 3000-EXIT.              
      *                                                                         
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           OPEN INPUT FCSBW81-FILE.                                     
                                                                        
           IF  FBW81-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*****************************************'      
               DISPLAY '**   ERROR ON FCSBW81 OPEN INPUT       **'      
               DISPLAY '** FILE STATUS = ' WS-FBW81-STATUS              
               DISPLAY '** PROCESS TERMINATED IN 0100          **'      
               DISPLAY '*****************************************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSBW06-FILE                                     
      *                                                                         
           IF FBW06-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*****************************************'      
               DISPLAY '**   ERROR ON FCSBW06 OPEN OUTPUT      **'      
               DISPLAY '** FILE STATUS = ' WS-FBW06-STATUS              
               DISPLAY '** PROCESS TERMINATED IN 0100          **'      
               DISPLAY '*****************************************'      
                 PERFORM 9900-ABEND                 THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
           INITIALIZE  WS-BTCH-PARTITION.                               
           PERFORM 0101-GET-PARTITION-DATA     THRU 0101-EXIT.          
                                                                        
           MOVE WS-COMPANY-NO                 TO  G6-COMPANY-NO.        
           PERFORM 0150-GET-PARM-DATA         THRU 0150-EXIT.           
      *                                                                         
      *** CHECK JOB_PARM TABLE TO GET WS-RESTART-REQ FLAG                       
           PERFORM 6235-GET-FJC01-RESTART-REQ  THRU 6235-EXIT.          
      *** CHECK CSS_RESTART TABLE TO GET PRIOR RUN LAST COMMITED DATA           
           PERFORM 0600-CHECK-FOR-RESTART    THRU 0600-EXIT.            
      *** VALIDATE JOB_PARM & CSS_RESTART STATUSES                              
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-Y   TO WS-REPOSITION-NEEDED                       
              PERFORM 0601-REPOSITION-INPUT-FILE  THRU 0601-EXIT        
              PERFORM 0700-REPOSITION-OUTPUT-FILE THRU 0700-EXIT        
           ELSE                                                         
              PERFORM 0610-INITIALIZE-RESTART    THRU 0610-EXIT         
           END-IF.                                                      
      *                                                                         
           SET NOT-VALID-BW81-REC TO TRUE                               
           PERFORM 7000-READ-FIOBW81     THRU 7000-EXIT                 
              UNTIL BW81-EOF-REACHED OR VALID-BW81-REC                  
      *                                                                         
           IF NOT WS-THIS-IS-A-RESTART                                  
              AND BW81-EOF-REACHED                                      
              DISPLAY '*************************************'           
              DISPLAY '*** WARNING: BW81 FILE WAS EMPTY  ***'           
              DISPLAY '*** PROGRAM WILL CREATE CNTRL RECS***'           
              DISPLAY '*************************************'           
              DISPLAY ' '                                               
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0101-GET-PARTITION-DATA.                                         
      *================================================================*        
      *                                                                         
           PERFORM 7500-OPEN-BTCH-PARTITION    THRU 7500-EXIT.          
           PERFORM 7510-FETCH-BTCH-PARTITION   THRU 7510-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********************************************'    
              DISPLAY '*** NO ROWS FOUND IN BTCH_PARTITION TABLE **'    
              DISPLAY '*** PROGRAM BEING TERMINATED              **'    
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
           PERFORM VARYING WS-PART-INDX FROM 1 BY 1                     
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
      *                                                                         
              IF WS-PART-INDX > 10                                      
                 DISPLAY '********************************************' 
                 DISPLAY '*** BTCH_PARTITION HAS MORE THAN 10 ROWS  **' 
                 DISPLAY '*** PROGRAM BEING TERMINATED              **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND             THRU 9900-EXIT          
              END-IF                                                    
      *                                                                         
              MOVE O5-PARTITION-ID             TO                       
                                 WS-PARTITION-ID(WS-PART-INDX)          
              MOVE O5-BEGIN-PART-RANGE         TO                       
                                 WS-BEGIN-PART-RANGE(WS-PART-INDX)      
              MOVE O5-END-PART-RANGE           TO                       
                                 WS-END-PART-RANGE(WS-PART-INDX)        
              ADD 1                            TO WS-PART-COUNT         
      *                                                                         
              PERFORM 7510-FETCH-BTCH-PARTITION   THRU 7510-EXIT        
      *                                                                         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7520-CLOSE-BTCH-PARTITION   THRU 7520-EXIT.          
      *                                                                         
       0101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0150-GET-PARM-DATA.                                              
      *================================================================*        
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE                        
                                               THRU 6240-EXIT           
              DISPLAY 'COMMON DATE ==> ' WS-FCA00-COMMON-DATE           
              MOVE WS-FCA00-COMMON-DATE        TO WS-INPUT-DATE         
                                                  WS-NEW-BUSINESS-DAY   
              PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU                   
                     6500-NEXT-BUSINESS-DAY-EXIT                        
                     UNTIL NEXT-BUSINESS-DAY-FOUND                      
              MOVE WS-NEW-BUSINESS-DAY    TO WS-INPUT-DATE              
           END-IF                                                       
           MOVE WS-INPUT-DATE                  TO WS-CURRENT-DATE       
           MOVE WS-PGRMNAME                    TO WS-PROGRAM            
           MOVE SPACES                         TO WS-SYSIPT             
           MOVE ZEROS                          TO WS-SEQUENCE           
           MOVE WS-PARM                        TO WS-COMMAND            
           MOVE WS-KEY-AREA                    TO E-FJC01-KEY           
           PERFORM 7600-START-FCSJC01          THRU 7600-EXIT           
           PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT           
             UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                     
                OR END-OF-SYSIPT.                                       
           IF END-OF-SYSIPT                                             
              MOVE SPACES                      TO                       
                                               WS-INPUT-DATA-BREAKDOWN  
              MOVE 'COMMON'                    TO WS-PROGRAM            
              MOVE SPACES                      TO WS-SYSIPT             
              MOVE WS-DATE                     TO WS-COMMAND            
              MOVE ZERO                        TO WS-SEQUENCE           
              MOVE WS-KEY-AREA                 TO E-FJC01-KEY           
              PERFORM 7600-START-FCSJC01       THRU 7600-EXIT           
              PERFORM 7610-READ-FCSJC01        THRU 7610-EXIT           
                UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                  
                   OR END-OF-SYSIPT                                     
              IF END-OF-SYSIPT                                          
                 DISPLAY '      '                                       
                 DISPLAY '***  PROCESSING ERROR IN PCSBW182   ***'      
                 DISPLAY '***NO ACTIVE REVENUE MONTH IN COMMON***'      
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
              ELSE                                                      
                 MOVE WS-REVENUE-MONTH-PARM    TO WS-REVENUE-MONTH      
                 MOVE G6-COMPANY-NO            TO WS-COMPANY-NO         
                 PERFORM 7611-CLOSE            THRU 7611-EXIT           
              END-IF                                                    
           ELSE                                                         
              MOVE WS-REVENUE-MONTH-PARM       TO WS-REVENUE-MONTH      
              MOVE G6-COMPANY-NO               TO WS-COMPANY-NO         
              PERFORM 7611-CLOSE               THRU 7611-EXIT           
           END-IF.                                                      
      *                                                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
             AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
              SET COMMITS-NOT-REQUIRE  TO TRUE                          
              DISPLAY ' '                                               
              DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'    
              DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'           
              DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS     
                      ', INTERPRETED TO**'                              
              DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'           
              DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'           
              DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'           
              DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'           
              DISPLAY '**      PROCESSING CONTINUING      **'           
           END-IF.                                                      
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0400-LOAD-RD-FMT-TAB.                                            
      *================================================================*        
      *                                                                         
           INITIALIZE WS-MTR-RD-FMT-TABLE.                              
      *                                                                         
           PERFORM 7210-OPEN-RD-FMT-CURSOR THRU 7210-EXIT.              
      *                                                                         
           PERFORM 7220-FETCH-RD-FMT-CURSOR THRU 7220-EXIT              
      *                                                                         
           IF WS-RD-FMT-COUNT = 0                                       
              DISPLAY '*********************************************'   
              DISPLAY '*** ZERO ROWS SELECTED FROM CSS_MTR_RD_FMT***'   
              DISPLAY '**  PROGRAM ABORTING...                    **'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
      *                                                                         
ACT144     IF WS-RD-FMT-COUNT >= 1200                                   
              DISPLAY '*********************************************'   
              DISPLAY '***         ARRAY OVERFLOW:               ***'   
ACT144        DISPLAY '** EXPECTED MTR_RD_FMT ROWS ARE BELOW 1200 **'   
              DISPLAY '**  PROGRAM ABORTING...                    **'   
              DISPLAY '**  PROGRAMMING CHANGE MAY REQUIRE        ***'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
      *                                                                         
           PERFORM 7230-CLOSE-RD-FMT-CURSOR THRU 7230-EXIT.             
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0600-CHECK-FOR-RESTART.                                          
      *================================================================*        
      *                                                                         
           MOVE PROGRAM-NAME            TO RF-NAME-PROGRAM.             
           MOVE WS-ONE                  TO RF-PARTITION-NO              
                                           RF-DUP-CNTRL-NO.             
           PERFORM 7400-SELECT-RESTART-DATA  THRU 7400-EXIT.            
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE RF-RESTART-DATA-TEXT     TO WS-RESTART-DATA         
               IF  WS-RESTART-PROCESS-TYPE NUMERIC                      
                   MOVE WS-Y                 TO WS-IS-THIS-A-RESTART    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0601-REPOSITION-INPUT-FILE.                                      
      *================================================================*        
      **** REPOSITION BW81 FILE TO LAST SUCCESSFUL COMMIT                       
      *                                                                         
           MOVE ZERO TO WS-FCSBW81-REC-CNTR                             
                        WS-FCSBW06-REC-CNTR.                            
      *                                                                         
           PERFORM 7000-READ-FIOBW81        THRU 7000-EXIT              
             UNTIL WS-FCSBW81-REC-CNTR  EQUAL WS-RESTART-RECORD-NO      
              OR BW81-EOF-REACHED.                                      
      *                                                                         
      *****************************************************************         
      *    THE FOLLOWING CODE COMPARES KEY VALUES STORED IN                     
      *    RESTART DATA WITH REPOSITIONED RECORD KEY.                           
      *****************************************************************         
           IF WS-RESTART-WORKSET-ID = E-FBW81-WORK-SET-ID               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '** FAIL TO REPOSITION BW81 FILE      **'         
                      '** CHECK FOR CORRECT BW81 FILE       **'         
              DISPLAY ' '                                               
              DISPLAY '** LAST WORKSET PROCESSED IN PRIOR RUN: '        
                 WS-RESTART-WORKSET-ID                                  
              DISPLAY '** BUT FILE POSITIONED AT             : '        
                 E-FBW81-WORK-SET-ID                                    
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
      *****************************************************************         
      *    THE FOLLOWING CODE COMPARES RUN DATE STORED IN                       
      *    RESTART DATA TO RUN DATE FROM JOB CONTROL FILE:                      
      *****************************************************************         
           IF WS-RESTART-INPUT-DATE  EQUAL WS-INPUT-DATE                
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '** RUN DATE WAS CHANGED PRIOR TO '              
                       'RESTART **'                                     
               DISPLAY '***************************************'        
               DISPLAY '** OLD RUN DATE = ' WS-RESTART-INPUT-DATE       
               DISPLAY '** NEW RUN DATE = ' WS-INPUT-DATE               
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF PCSBW182  *****'.       
           DISPLAY '*******************************************'.       
           MOVE WS-RESTART-RECORD-NO         TO WS-FCSBW81-REC-CNTR.    
           MOVE WS-RESTART-FBW06-REC-CNTR    TO WS-FCSBW06-REC-CNTR.    
           MOVE WS-RESTART-CHKP-SEQ-NO       TO WS-CHKP-SEQ-NO.         
      *                                                                         
       0601-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      *  0605-VALIDATE-RESTART-REQ                                              
       COPY CPD00030.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
       0610-INITIALIZE-RESTART.                                         
      *================================================================*        
      *                                                                         
           MOVE ZEROS              TO WS-RESTART-PROCESS-TYPE           
                                      WS-RESTART-CHKP-SEQ-NO            
                                      WS-RESTART-RH-UPDT-CNTR-TOT       
                                      WS-RESTART-RH-ISRT-CNTR-TOT       
                                      WS-RESTART-MN-UPDT-CNTR-TOT       
                                      WS-RESTART-RG-UPDT-CNTR-TOT       
                                      WS-RESTART-PR-UPDT-CNTR-TOT       
                                      WS-RESTART-FBW06-REC-CNTR         
                                      WS-RESTART-WQ-COUNT               
                                      WS-RESTART-ROUTE-CNTR-TOT         
                                      WS-RESTART-ACCOUNT-NO.            
           MOVE SPACES             TO WS-RESTART-METER-NO               
                                      WS-RESTART-WORKSET-ID.            
           SET WS-RERUN-PENDING    TO TRUE.                             
           MOVE WS-INPUT-DATE      TO WS-RESTART-INPUT-DATE.            
           MOVE WS-N               TO WS-REPOSITION-NEEDED.             
      *                                                                         
       0610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0700-REPOSITION-OUTPUT-FILE.                                     
      *================================================================*        
      *                                                                         
           OPEN INPUT FCSBW06R-FILE.                                    
           IF NOT FBW06R-SUCCESSFUL                                     
              DISPLAY '0700-ERROR ON FCSBW06R OPEN.  STATUS IS '        
                           WS-FBW06R-STATUS                             
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           PERFORM WS-RESTART-FBW06-REC-CNTR TIMES                      
              READ FCSBW06R-FILE                                        
              IF FBW06R-SUCCESSFUL                                      
                 WRITE FIOBW06-REC FROM FIOBW06R-REC                    
                 IF FBW06-SUCCESSFUL                                    
                    CONTINUE                                            
                 ELSE                                                   
                    DISPLAY 'ERROR ON FCSBW06 REWRITE.  STATUS IS '     
                             WS-FBW06-STATUS                            
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'PREMATURE EOF ON BW06 RESTART'                
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           CLOSE FCSBW06R-FILE.                                         
      *                                                                         
        0700-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *================================================================*        
       1000-PROCESS-BW81.                                               
      *================================================================*        
      *                                                                         
           MOVE E-FBW81-WORK-SET-ID      TO WS-PREV-WORK-SET-ID         
                                            WS-WORKSET-ID               
           PERFORM 1050-SET-ROUTE-DTL    THRU 1050-EXIT.                
      *                                                                         
           PERFORM 1100-PROCESS-ALL-ACCOUNTS THRU 1100-EXIT             
                   UNTIL BW81-EOF-REACHED                               
              OR E-FBW81-WORK-SET-ID NOT = WS-PREV-WORK-SET-ID          
      *                                                                         
           PERFORM 1210-PROCESS-ROUTE-HEADER THRU 1210-EXIT             
           COMPUTE WS-RESTART-ROUTE-CNTR-TOT                            
                                    = WS-RESTART-ROUTE-CNTR-TOT + 1     
           COMPUTE WS-COMMIT-ROUTES = WS-COMMIT-ROUTES + 1              
      *                                                                         
           IF COMMITS-REQUIRE                                           
              AND WS-COMMIT-ROUTES >= WS-CHKP-LUW-LIMIT                 
              PERFORM 8898-ISSUE-CHKP           THRU 8898-EXIT          
           END-IF.                                                      
                                                                        
           MOVE ZEROS                            TO WS-MTR-COUNT.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1050-SET-ROUTE-DTL.                                              
      *================================================================*        
      *                                                                         
           MOVE WS-WORKSET-SUFIX         TO WS-ROUTE-TYPE-SW            
           MOVE WS-WORKSET-CYCLE         TO RH-READ-CYCLE               
                                            RW-READ-CYCLE               
           MOVE 'N'                      TO WS-MID-OF-MONTH             
           IF WS-WORKSET-CYCLE EQUAL WS-90                              
              SET MID-MONTH-READ      TO TRUE                           
           END-IF.                                                      
      *                                                                         
           IF E-FBW81-COMPANY-NO > SPACES                               
              MOVE E-FBW81-COMPANY-NO TO WS-SAVE-COMPANY-NO             
           ELSE                                                         
              IF WS-WORKSET-COMPANY = 'S'                               
                 MOVE '01'                  TO  WS-SAVE-COMPANY-NO      
              ELSE                                                      
                 MOVE '26'                  TO  WS-SAVE-COMPANY-NO      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-SAVE-COMPANY-NO       TO  RH-COMPANY-NO              
                                             R4-COMPANY-NO              
                                             O2-COMPANY-NO              
                                             GM-COMPANY-NO              
                                             MA-COMPANY-NO              
                                             EM-COMPANY-NO.             
      *                                                                         
      **** AROP OUT OF CYCLE PROCESS USE 22 & 23 AS MRMS CYCLES BUT             
      ****  E-FBW81-READ-CYCLE FIELD WILL HAVE VALID READ CYCLE TO GET          
      ****  REV MONTH BUT TO UPD RH WE CAN EVEN USE CYC 22 & 23.                
           IF WS-AROP-ROUTE                                             
              MOVE E-FBW81-READ-CYCLE       TO RW-READ-CYCLE            
              MOVE 9999                     TO RH-READ-ROUTE            
                                               R4-READ-ROUTE            
              IF E-FBW81-LOCAL-OFFICE > SPACES                          
                 MOVE E-FBW81-LOCAL-OFFICE  TO RH-LOCAL-OFFICE          
              ELSE                                                      
                 MOVE WS-WORKSET-LOC-NUM       TO RH-LOCAL-OFFICE       
              END-IF                                                    
           ELSE                                                         
              IF E-FBW81-READ-ROUTE > ZEROS                             
                 MOVE E-FBW81-READ-ROUTE       TO RH-READ-ROUTE         
                                                  R4-READ-ROUTE         
                                                  O2-READ-ROUTE         
              ELSE                                                      
                 MOVE WS-WORKSET-ROUTE         TO RH-READ-ROUTE         
                                                  R4-READ-ROUTE         
                                                  O2-READ-ROUTE         
              END-IF                                                    
              IF E-FBW81-LOCAL-OFFICE > SPACES                          
                 MOVE E-FBW81-LOCAL-OFFICE  TO RH-LOCAL-OFFICE          
              ELSE                                                      
                 PERFORM 7052-GET-LOFFICE-FROM-O2 THRU 7052-EXIT        
                 MOVE O2-LOCAL-OFFICE       TO RH-LOCAL-OFFICE          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7150-SELECT-REVENUE-MONTH THRU 7150-EXIT             
      *                                                                         
           MOVE RW-REVENUE-MONTH       TO WS-REVENUE-MONTH              
                                          RH-REVENUE-MONTH.             
           MOVE RW-DATE-MTR-RD-XTRCT   TO RH-DOWNLOAD-DATE.             
      *                                                                         
      *** USE MTR SEQ REQUEST FLAG PASSED FROM IMPORT PCSBW172 PGM              
      *** TO DETERMINE ROUTE SEQ. IF NONE RECEIVED THEN USE LOGIC               
      **** NEED TO UPDATE MTR SEQ ONLY WHEN WS-MTR-SEQ-REQ SET AT IMPORT        
      **** IF NOT, IT WILL BE DETERMINE HERE.                                   
           MOVE E-FBW81-SEQ-REQUIRED   TO WS-MTR-SEQ-REQ-SW             
           IF WS-MTR-SEQ-REQ-NONE                                       
              IF WS-MANUAL-ROUTE                                        
                 SET WS-MTR-SEQ-REQ   TO TRUE                           
                 PERFORM 7054-GET-MRMS-ROUTE THRU 7054-EXIT             
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    SET WS-MTR-SEQ-NOT-REQ   TO TRUE                    
                 END-IF                                                 
              ELSE                                                      
                 SET WS-MTR-SEQ-NOT-REQ   TO TRUE                       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1100-PROCESS-ALL-ACCOUNTS.                                       
      *================================================================*        
      *                                                                         
           MOVE E-FBW81-ACCOUNT-NO     TO WS-PREV-ACCOUNT-NO            
                                          AT-ACCOUNT-NO                 
                                          MN-ACCOUNT-NO                 
                                          WS-ACCOUNT-NO-PART            
                                          WS-SAVE-ACCOUNT-NO.           
      *                                                                         
           PERFORM 7200-SELECT-ACCOUNT     THRU 7200-EXIT.              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE ZERO                  TO AT-PREMISE-NO               
                                            AT-CUSTOMER-NO              
              MOVE SPACES                TO AT-LOCAL-OFFICE             
                                            AT-COMPANY-NO               
              DISPLAY '********** PCSBW182 ******************'          
              DISPLAY '* NO RECORDS EXISTS ON CSS_ACCOUNT, '            
                        'ACCOUNT: ' AT-ACCOUNT-NO                       
              DISPLAY '********** PCSBW182 ******************'          
           END-IF.                                                      
      *                                                                         
A01738     IF AT-CODE-ACCT-STAT NOT = 'A'                               
A01738        MOVE AT-PREMISE-NO      TO WS-CPD99-PREMISE-NO            
A01738        PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT             
A01738        IF WS-CPD99-ACCOUNT-NO NOT = AT-ACCOUNT-NO                
A01738           PERFORM 1260-VAL-MTR-LATEST-ACC THRU 1260-EXIT         
A01738        END-IF                                                    
A01738     END-IF.                                                      
      **** ASSIGN PART NO TO ACCOUNT                                            
           PERFORM VARYING WS-PART-INDX FROM 1 BY 1 UNTIL               
                     WS-PART-INDX > WS-PART-COUNT                       
            IF (WS-ACCOUNT-NO-PART >= WS-BEGIN-PART-RANGE(WS-PART-INDX))
             AND (WS-ACCOUNT-NO-PART <= WS-END-PART-RANGE(WS-PART-INDX))
               SET WS-SAVE-DB-PART-DREC TO WS-PART-INDX                 
               SET WS-PART-INDX         TO WS-PART-COUNT                
            END-IF                                                      
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 1200-PROCESS-ALL-METERS  THRU 1200-EXIT              
                   UNTIL BW81-EOF-REACHED                               
              OR E-FBW81-WORK-SET-ID NOT = WS-PREV-WORK-SET-ID          
              OR E-FBW81-ACCOUNT-NO NOT = WS-PREV-ACCOUNT-NO.           
      *                                                                         
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1200-PROCESS-ALL-METERS.                                         
      *================================================================*        
      *                                                                         
           MOVE E-FBW81-METER-CATEGORY   TO WS-PREV-METER-CATEGORY      
           MOVE E-FBW81-METER-NO         TO WS-PREV-METER-NO            
           MOVE E-FBW81-MTR-CHNG-FIELDS  TO WS-MTR-CHNG-FIELDS          
           MOVE E-FBW81-MSI-CHNG-FIELDS  TO WS-MSI-CHNG-FIELDS          
           SET MN-UPDATE-NOT-REQUIRE     TO TRUE                        
      *** FORMAT EMP ID BY REMOVING INITIALS                                    
A01738     MOVE E-FBW81-DC-USER-ID (3:5) TO WS-EMPLOYEE-NO              
      *                                                                         
           IF E-FBW81-GAS                                               
              MOVE WS-G                  TO MN-CODE-UTIL-TYPE           
           ELSE                                                         
              MOVE WS-E                  TO MN-CODE-UTIL-TYPE           
           END-IF.                                                      
           MOVE MN-CODE-UTIL-TYPE        TO WS-CODE-UTIL-TYPE           
                                            EM-CODE-UTIL-TYPE           
                                            GM-CODE-UTIL-TYPE           
                                            MA-CODE-UTIL-TYPE.          
      *                                                                         
           ADD  +1                       TO WS-MTR-COUNT                
           INITIALIZE WS-MATCH-REG-ARRAY                                
           SET MRF-LOOKUP-NOT-REQ      TO TRUE.                         
      *                                                                         
           PERFORM 1250-VALIDATE-METER-DATA   THRU 1250-EXIT.           
      *                                                                         
           MOVE WS-REMOTE-READ-IND TO WS-REMOTE-READ-IND-FL             
      *                                                                         
           IF OPTICAL-PROB-MTR                                          
              SET MRF-LOOKUP-REQ      TO TRUE                           
           ELSE                                                         
P00251        IF E-FBW81-CODE-USAGE-TYPE > SPACES                       
                 CONTINUE                                               
              ELSE                                                      
                 SET MRF-LOOKUP-REQ      TO TRUE                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF MRF-LOOKUP-REQ                                            
              PERFORM 2516-LOOKUP-MTR-RD-FMT THRU 2516-EXIT             
           END-IF.                                                      
      *                                                                         
      **** MTR LOC CHNG OR MTR READ INST CHNG(HZD CODE)                         
           IF INST-LOC-CD1-CHNGD                                        
              OR INST-LOC-CD2-CHNGD                                     
              PERFORM 2200-VAL-CODE-MTR-RD-INST THRU 2200-EXIT          
           END-IF.                                                      
      *                                                                         
           SET WS-BW81-REG-SEQ-NOT-CHG TO TRUE                          
           IF WS-MTR-SEQ-REQ                                            
              PERFORM 1410-PROCESS-READ-SEQ THRU 1410-EXIT              
           END-IF                                                       
      **** UPDATE SPECIAL INSTRUCTIONS AFTER ACCOUNT PROCESS ENDS               
           IF AT-PREMISE-NO > 0                                         
              AND E-FBW81-SPL-MSG-CHNGD-IND = 'Y'                       
              INITIALIZE PR-SPCL-READ-INSTR                             
              MOVE AT-PREMISE-NO     TO PR-PREMISE-NO                   
              MOVE E-FBW81-SPL-MSG   TO PR-SPCL-READ-INSTR-TEXT         
              MOVE LENGTH OF PR-SPCL-READ-INSTR-TEXT                    
                                    TO  PR-SPCL-READ-INSTR-LEN          
              PERFORM 8200-UPDATE-SPCL-READ-INSTR THRU 8200-EXIT        
           END-IF.                                                      
      *                                                                         
           MOVE ZEROS                  TO WS-REG-SKIP-COUNT             
           INITIALIZE WS-FIOBW06-TABLE.                                 
           MOVE ZEROS             TO WS-MTR-REG-COUNT                   
           PERFORM 1400-PROCESS-ALL-REGS  THRU 1400-EXIT                
                   UNTIL BW81-EOF-REACHED                               
              OR E-FBW81-WORK-SET-ID NOT = WS-PREV-WORK-SET-ID          
              OR E-FBW81-ACCOUNT-NO NOT = WS-PREV-ACCOUNT-NO            
              OR E-FBW81-METER-CATEGORY NOT =  WS-PREV-METER-CATEGORY   
              OR E-FBW81-METER-NO       NOT =  WS-PREV-METER-NO         
                                                                        
      **** UPDATE MN AFTER METER PROCESS COMPLETE                               
           IF METER-FOUND                                               
              AND (MN-UPDATE-REQUIRE OR WS-BW81-REG-SEQ-CHG)            
              PERFORM 2900-UPD-MTR-ENVRNMT THRU 2900-EXIT               
           END-IF.                                                      
      *                                                                         
      **** TOTAL SKIPPED METERS (INCLUDING RMVD METERS)                         
           COMPUTE WS-MTR-SKIP-COUNT = WS-MTR-SKIP-COUNT                
                                       + WS-REG-SKIP-COUNT              
      *                                                                         
           PERFORM VARYING BW06-SUB FROM 1 BY 1 UNTIL                   
                           BW06-SUB > 50                                
                           OR WS-FBW06-ACCOUNT-NO (BW06-SUB) = 0        
              MOVE WS-FIOBW06-REC (BW06-SUB) TO FIOBW06                 
              PERFORM 8001-WRITE-FIOBW06 THRU 8001-EXIT                 
           END-PERFORM.                                                 
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1210-PROCESS-ROUTE-HEADER.                                       
      *================================================================*        
      *                                                                         
           COMPUTE WS-UPLOAD-MTR =  WS-MTR-COUNT                        
                                    - WS-MTR-SKIP-COUNT                 
      *                                                                         
           PERFORM 7100-SELECT-ROUTE-HEADER    THRU  7100-EXIT.         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              IF  WS-NULL-IND < 0                                       
                  MOVE WS-CURRENT-DATE   TO  RH-UPLOAD-DATE             
              END-IF                                                    
      *                                                                         
              ADD WS-UPLOAD-MTR     TO  RH-UPLOAD-METERS                
      *                                                                         
              PERFORM 8450-UPDATE-ROUTE-HEADER                          
                 THRU 8450-EXIT                                         
           ELSE                                                         
              MOVE WS-CURRENT-DATE   TO RH-UPLOAD-DATE                  
              MOVE SPACES            TO RH-PC-ROUTE-IND                 
              MOVE ZEROS             TO RH-DOWNLOAD-METERS              
                                        RH-UPLOAD-METERS                
                                        RH-DOWN-RMVD-MTR-QT             
                                        RH-UP-RMVD-MTR-QT               
      *                                                                         
              MOVE WS-UPLOAD-MTR     TO  RH-UPLOAD-METERS               
      *                                                                         
              PERFORM 8400-INSERT-ROUTE-HEADER THRU 8400-EXIT           
           END-IF                                                       
      *                                                                         
           MOVE ZERO         TO WS-MTR-COUNT                            
                                WS-MTR-SKIP-COUNT                       
                                WS-UPLOAD-MTR                           
           .                                                            
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1250-VALIDATE-METER-DATA.                                        
      *================================================================*        
      *                                                                         
      *** THE MTR IN E-FBW81-METER-NO WILL BE ALWAYS 9 CHAR SINCE WE            
      *** FORMAT AS 9 CHAR DURING IMPORT TO FCS. BUT THE NEW METER              
      *** REQUIRE FORMATING TO 9 CHARACTERS.                                    
      *                                                                         
           SET METER-NOT-FOUND TO TRUE                                  
           MOVE SPACES                  TO WS-NEW-METER-NO              
                                           WS-METER-NO                  
P00251     MOVE E-FBW81-METER-NO        TO WS-METER-NO                  
P00251                                     MN-METER-NO                  
P00251                                     WS-SAVE-METER-NO             
           IF MTR-NUMBER-CHNGD AND E-FBW81-METER-NO-NEW > SPACES        
              DISPLAY 'NEW METER RECEIVED: ' E-FBW81-METER-NO-NEW       
A01738        MOVE E-FBW81-METER-NO-NEW  TO WS-NEW-METER-NO             
A01738        PERFORM 7040-FORMAT-METER-NUMBER THRU 7040-EXIT           
              MOVE WS-NEW-METER-NO       TO MN-METER-NO                 
                                            WS-SAVE-METER-NO            
                                            WS-METER-NO                 
           END-IF.                                                      
           PERFORM 7050-SELECT-MTR-ENVRNMT  THRU 7050-EXIT              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              SET METER-FOUND   TO TRUE                                 
           END-IF.                                                      
      *                                                                         
           IF METER-NOT-FOUND                                           
              DISPLAY '************* PCSBW182 ********************'     
P00251        IF MTR-NUMBER-CHNGD                                       
P00251          DISPLAY '* NEW METER NOT FND FOR ACCT# ' MN-ACCOUNT-NO  
P00251        ELSE                                                      
P00251          DISPLAY '* METER NOT FND FOR ACCT# ' MN-ACCOUNT-NO      
P00251        END-IF                                                    
              DISPLAY '* NO RECORDS EXISTS ON CSS_MTRD_ENVRNMT   *'     
              DISPLAY '* MTR RECEIVED    : '  MN-CODE-UTIL-TYPE ' | '   
                                              MN-METER-NO               
              DISPLAY '*******************************************'     
              MOVE SPACES              TO MN-CODE-METER-LOC             
                                          MN-CODE-METER-STATUS          
                                          MN-REMOTE-READ-IND            
                                          MN-MTR-READ-SOURCE-CD         
                                          MN-DIGTL-MTR-TYPE             
                                          MN-PROGRAM-ID                 
                                          MN-CODE-DATA-PRESENT          
                                          MN-CODE-MTR-RD-INST1          
                                          MN-CODE-MTR-RD-INST2          
                                          MN-CODE-MTR-RD-INST3          
              MOVE ZEROS               TO MN-REGISTER-RD-SEQ            
                                          MN-IC-NO                      
           END-IF.                                                      
      *                                                                         
      **** CONSIDER MTR DETAILS TRANSFERED FROM IMPORT TO EXPORT IF             
      **** AVAILABLE OTHERWISE USE MN VALUES                                    
           IF E-FBW81-MTR-READ-SOURCE-CD > SPACES                       
              MOVE E-FBW81-MTR-READ-SOURCE-CD TO WS-MTR-READ-SOURCE-CD  
           ELSE                                                         
              MOVE MN-MTR-READ-SOURCE-CD      TO WS-MTR-READ-SOURCE-CD  
           END-IF                                                       
           IF E-FBW81-RRI > SPACES                                      
              MOVE E-FBW81-RRI        TO WS-REMOTE-READ-IND             
           ELSE                                                         
              MOVE MN-REMOTE-READ-IND TO WS-REMOTE-READ-IND             
           END-IF                                                       
           IF E-FBW81-PGM-ID > SPACES                                   
              MOVE E-FBW81-PGM-ID     TO WS-PROGRAM-ID                  
           ELSE                                                         
              MOVE MN-PROGRAM-ID      TO WS-PROGRAM-ID                  
           END-IF                                                       
      *                                                                         
      **** REVALIDATE RD FARMAT WHEN DMT IS NOT SAME AT ANY CASE                
           IF E-FBW81-DMT > SPACES                                      
              AND (E-FBW81-DMT = MN-DIGTL-MTR-TYPE                      
                   OR MN-DIGTL-MTR-TYPE = SPACES )                      
              MOVE E-FBW81-DMT        TO WS-DIGTL-MTR-TYPE              
           ELSE                                                         
              MOVE MN-DIGTL-MTR-TYPE  TO WS-DIGTL-MTR-TYPE              
              SET MRF-LOOKUP-REQ      TO TRUE                           
           END-IF.                                                      
      *                                                                         
P00251     IF MTR-NUMBER-CHNGD AND METER-FOUND                          
P00251        SET MRF-LOOKUP-REQ      TO TRUE                           
P00251        MOVE MN-MTR-READ-SOURCE-CD  TO WS-MTR-READ-SOURCE-CD      
P00251        MOVE MN-REMOTE-READ-IND TO WS-REMOTE-READ-IND             
P00251        MOVE MN-PROGRAM-ID      TO WS-PROGRAM-ID                  
P00251        MOVE MN-DIGTL-MTR-TYPE  TO WS-DIGTL-MTR-TYPE              
P00251     END-IF.                                                      
P00251*                                                                         
           IF READ-METHOD-CHNGD                                         
              MOVE E-FBW81-READ-METHOD-NEW TO WS-READ-METHOD            
           ELSE                                                         
              MOVE E-FBW81-READ-METHOD     TO WS-READ-METHOD            
           END-IF.                                                      
      *                                                                         
      **** GET DMT & PGM ID FROM GM OR EM WHEN NOT EXISTS                       
           IF METER-NOT-FOUND                                           
              AND (WS-DIGTL-MTR-TYPE = SPACES                           
                    OR WS-PROGRAM-ID = SPACES)                          
              SET MRF-LOOKUP-REQ      TO TRUE                           
              MOVE MN-METER-NO      TO GM-METER-NO                      
                                       EM-METER-NO                      
              DISPLAY 'WARNING: USING GM/EM TABLES TO GET DMT/PGM.'     
              IF WS-CODE-UTIL-TYPE = 'G'                                
                 PERFORM 7310-GET-DMT-FROM-GM  THRU 7310-EXIT           
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE GM-DIGTL-MTR-TYPE  TO WS-DIGTL-MTR-TYPE        
                    MOVE GM-PROGRAM-ID      TO WS-PROGRAM-ID            
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 7320-GET-DMT-FROM-EM  THRU 7320-EXIT           
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE EM-DIGTL-MTR-TYPE  TO WS-DIGTL-MTR-TYPE        
                    MOVE EM-PROGRAM-ID      TO WS-PROGRAM-ID            
                 END-IF                                                 
              END-IF                                                    
              IF WS-REMOTE-READ-IND = SPACES                            
                 IF READ-METHOD-WALK-BY OR READ-METHOD-DRIVE-BY         
                    MOVE 'A'                 TO WS-REMOTE-READ-IND      
                    MOVE 'B'                 TO WS-MTR-READ-SOURCE-CD   
                 ELSE                                                   
                    MOVE '0'                 TO WS-REMOTE-READ-IND      
                    MOVE 'I'                 TO WS-MTR-READ-SOURCE-CD   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01738*================================================================*        
A01738 1260-VAL-MTR-LATEST-ACC.                                         
A01738*================================================================*        
A01738*                                                                         
A01738     DISPLAY '********** PCSBW182 ******************'             
A01738     DISPLAY '** REPLACED WITH LATEST ACCOUNT NO:  '              
A01738             '** OLD ACCOUNT: ' AT-ACCOUNT-NO                     
A01738             '** NEW ACCOUNT: ' WS-CPD99-ACCOUNT-NO               
A01738     DISPLAY '********** PCSBW182 ******************'             
A01738     MOVE WS-CPD99-ACCOUNT-NO TO AT-ACCOUNT-NO                    
A01738*                                                                         
A01738     PERFORM 7200-SELECT-ACCOUNT  THRU 7200-EXIT                  
A01738     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A01738        DISPLAY '********** PCSBW182 ******************'          
A01738        DISPLAY '* NO RECORDS EXISTS ON CSS_ACCOUNT, '            
A01738                  'ACCOUNT: ' AT-ACCOUNT-NO                       
A01738        DISPLAY '** SQLCODE         = ' WS-DISPLAY-SQLCODE        
A01738        DISPLAY '** PROCESSING TERMINATED            **'          
A01738        PERFORM 9900-ABEND            THRU 9900-EXIT              
A01738        DISPLAY '********** PCSBW182 ******************'          
A01738     END-IF.                                                      
A01738*                                                                         
A01738     MOVE AT-ACCOUNT-NO       TO MN-ACCOUNT-NO                    
A01738                                 WS-ACCOUNT-NO-PART               
A01738                                 WS-SAVE-ACCOUNT-NO.              
A01738*                                                                         
A01738 1260-EXIT.                                                       
A01738     EXIT.                                                        
A01738*                                                                         
      *================================================================*        
       1400-PROCESS-ALL-REGS.                                           
      *================================================================*        
      *                                                                         
           COMPUTE WS-MTR-REG-COUNT = WS-MTR-REG-COUNT + 1              
           COMPUTE BW06-SUB  = BW06-SUB + 1                             
           IF BW06-SUB > 50                                             
              DISPLAY '********************************************'    
              DISPLAY '** ARRAY OVERFLOW OCCUR ON WS-BWO6 ARRAY  **'    
              DISPLAY '**  NEED TO INCREASE ARRAY LENGTH         **'    
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND        THRU 9900-EXIT                  
           END-IF.                                                      
           MOVE E-FBW81-MSI-CHNG-FIELDS TO WS-MSI-CHNG-FIELDS           
           MOVE WS-SAVE-DB-PART-DREC TO WS-FBW06-DB-PART-DREC (BW06-SUB)
           MOVE WS-SAVE-ACCOUNT-NO     TO WS-FBW06-ACCOUNT-NO (BW06-SUB)
           MOVE WS-SAVE-METER-NO       TO WS-FBW06-METER-NO   (BW06-SUB)
           MOVE WS-CODE-UTIL-TYPE TO WS-FBW06-CODE-UTIL-TYPE (BW06-SUB) 
A01738     MOVE WS-EMPLOYEE-NO         TO WS-FBW06-EMPLOYEE-NO(BW06-SUB)
           MOVE WS-MTR-READ-SOURCE-CD  TO                               
                                   WS-FBW06-MTR-READ-SOURCE-CD(BW06-SUB)
      *                                                                         
      **** VALIDATE TROUBLE CODES.                                              
           MOVE SPACES           TO WS-FBW06-MTR-COND-CD1 (BW06-SUB)    
           MOVE SPACES           TO WS-FBW06-MTR-COND-CD2 (BW06-SUB)    
           IF E-FBW81-TROUBLE-CODE1(2:1) > SPACES                       
              AND E-FBW81-TROUBLE-CODE1 NOT = '00'                      
              MOVE E-FBW81-TROUBLE-CODE1(2:1)                           
                                    TO WS-FBW06-MTR-COND-CD1 (BW06-SUB) 
           END-IF.                                                      
      *                                                                         
           IF E-FBW81-TROUBLE-CODE2(2:1) > SPACES                       
              AND E-FBW81-TROUBLE-CODE2 NOT = '00'                      
              MOVE E-FBW81-TROUBLE-CODE2(2:1)                           
                                    TO WS-FBW06-MTR-COND-CD2 (BW06-SUB) 
           END-IF.                                                      
      *                                                                         
           IF E-FBW81-TROUBLE-MESG > SPACES                             
              MOVE E-FBW81-TROUBLE-MESG                                 
                                  TO WS-FBW06-MTR-COMMENT-TX (BW06-SUB) 
           END-IF.                                                      
      *                                                                         
           IF MRF-LOOKUP-REQ                                            
              PERFORM 2517-MATCH-MTR-RD-FMT   THRU 2517-EXIT            
           ELSE                                                         
P00251         IF E-FBW81-CODE-USAGE-TYPE > SPACES                      
P00251***  For transition period, Usage ID and Usage Source will                
P00251***  not be having any values. So, they will get default values           
P00251***  usage id: 'A' - Basic Service.                                       
P00251***  usage source: 'B' - Primary Register.                                
P00251***  usage source: 'C' - Additional register.                             
P00251            IF E-FBW81-CODE-USAGE-ID >  SPACES                    
P00251               MOVE E-FBW81-CODE-USAGE-ID TO WS-CODE-USAGE-ID     
P00251            ELSE                                                  
P00251               MOVE 'A'   TO  WS-CODE-USAGE-ID                    
P00251            END-IF                                                
P00251            IF E-FBW81-CODE-USAGE-SOURCE > SPACES                 
P00251               MOVE E-FBW81-CODE-USAGE-SOURCE                     
P00251                                      TO WS-CODE-USAGE-SOURCE     
P00251            ELSE                                                  
P00251               IF E-FBW81-TIME-PERIOD = 0                         
P00251                  AND E-FBW81-CODE-USAGE-TYPE = ('B' OR 'C')      
P00251                  MOVE 'B'   TO  WS-CODE-USAGE-SOURCE             
P00251               ELSE                                               
P00251                  MOVE 'C'   TO  WS-CODE-USAGE-SOURCE             
P00251               END-IF                                             
P00251            END-IF                                                
P00251            MOVE E-FBW81-CODE-USAGE-TYPE TO WS-CODE-USAGE-TYPE    
                  MOVE E-FBW81-TIME-PERIOD     TO WS-CODE-TIME-PERIOD   
                  MOVE E-FBW81-CODE-TOU-SEASN  TO WS-CODE-TOU-SEASN     
                  MOVE E-FBW81-TEXT-PROMPT     TO WS-MTR-RD-DISP-CD     
                  MOVE E-FBW81-INDEX-VALUE-CD  TO WS-INDEX-VALUE-CD     
                  MOVE E-FBW81-CNSMPTN-READ-FL TO WS-CNSMPTN-READ-FL    
                  MOVE E-FBW81-READ-DIALS      TO WS-READ-DIGITS        
                  MOVE E-FBW81-READ-DECIMALS   TO WS-READ-DECIMALS      
               ELSE                                                     
                  PERFORM 2516-LOOKUP-MTR-RD-FMT THRU 2516-EXIT         
                  PERFORM 2517-MATCH-MTR-RD-FMT   THRU 2517-EXIT        
                  SET MRF-LOOKUP-REQ   TO TRUE                          
               END-IF                                                   
           END-IF                                                       
      *                                                                         
           MOVE WS-CODE-USAGE-TYPE                                      
                                TO WS-FBW06-CODE-USAGE-TYPE (BW06-SUB)  
P00251     MOVE WS-CODE-USAGE-ID                                        
P00251                          TO WS-FBW06-CODE-USAGE-ID (BW06-SUB)    
P00251     MOVE WS-CODE-USAGE-SOURCE                                    
P00251                          TO WS-FBW06-CODE-USAGE-SOURCE(BW06-SUB) 
           MOVE WS-CODE-TIME-PERIOD                                     
                                TO WS-FBW06-CODE-TIME-PERIOD(BW06-SUB)  
           MOVE WS-CODE-TOU-SEASN                                       
                                TO WS-FBW06-CODE-TOU-SEASN (BW06-SUB)   
           MOVE WS-MTR-RD-DISP-CD                                       
                                TO WS-FBW06-REG-MEASURE-CD (BW06-SUB)   
           MOVE WS-CNSMPTN-READ-FL                                      
                                TO WS-FBW06-CNSMPTN-READ-FL (BW06-SUB)  
           MOVE WS-INDEX-VALUE-CD                                       
                               TO WS-FBW06-INDEX-VALUE-CD (BW06-SUB)    
      *                                                                         
           PERFORM 2518-VAL-DIAL-DECIMAL-CHNG THRU 2518-EXIT.           
      *                                                                         
           IF E-FBW81-READ IS NUMERIC                                   
              MOVE E-FBW81-READ        TO WS-READ                       
           ELSE                                                         
              MOVE ZEROS               TO WS-READ                       
           END-IF.                                                      
      *                                                                         
           IF WS-READ-DECIMALS = 0                                      
      **** NO FORMAT REQUIRE FOR KWH & CCF (DECIMALS = 0)                       
              MOVE WS-READ        TO WS-FBW06-METER-READING (BW06-SUB)  
              IF OPTICAL-PROB-MTR OR                                    
                 TOU-MANUAL                                             
                 IF WS-FBW06-CODE-USAGE-TYPE (BW06-SUB) = 'B'           
                    PERFORM 1430-PROCESS-TOU-KWH-READ  THRU 1430-EXIT   
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              COMPUTE WS-FBW06-METER-READING (BW06-SUB) =               
                      WS-READ /                                         
                      (10 ** WS-READ-DECIMALS)                          
                ON SIZE ERROR                                           
                   MOVE ZERO TO WS-FBW06-METER-READING (BW06-SUB)       
              END-COMPUTE                                               
           END-IF.                                                      
      *                                                                         
      ***------------------------------------------------------------***        
      ***-----------------READ-ITEM-STATUS (BW06 FIELD)--------------***        
      ** INFO READ --> I             ** BILLING READ   --> B          **        
      ** MID-MONTH --> M             ** MID-MONTH INFO --> N          **        
      ** AROP READ --> O             **                               **        
      ***------------------------------------------------------------***        
      *                                                                         
           IF WS-FBW06-CNSMPTN-READ-FL (BW06-SUB) = 'N'                 
              MOVE 'I'        TO WS-FBW06-READ-ITEM-STATUS (BW06-SUB)   
              IF MID-MONTH-READ                                         
                 MOVE 'N'     TO WS-FBW06-READ-ITEM-STATUS (BW06-SUB)   
              END-IF                                                    
           ELSE                                                         
              MOVE 'B'        TO WS-FBW06-READ-ITEM-STATUS (BW06-SUB)   
              IF MID-MONTH-READ                                         
                 MOVE 'M'     TO WS-FBW06-READ-ITEM-STATUS (BW06-SUB)   
              END-IF                                                    
           END-IF.                                                      
           IF WS-AROP-ROUTE                                             
              MOVE 'O'        TO WS-FBW06-READ-ITEM-STATUS (BW06-SUB)   
           END-IF.                                                      
      *                                                                         
      ***------------------------------------------------------------***        
      ***-------------------READ CODE:9(02)--------------------------***        
      ** 0 --> MISSED(DEFAULT)        ** 1 --> REGULAR READ           **        
      ** 2 --> SKIP READ              ** 3 --> WALK-BY READ           **        
      ** 4 --> MANUAL READ OF ERT     ** 5 --> CUSTOMER READ          **        
      ** 6 --> FIELD ESTIMATE         ** 7 --> SCANNED REMOTE READ    **        
      ** 8 --> MANUAL REMOTE READ     ** 9 --> OPTICAL READ (TOU/IDR) **        
      ** 10--> MANUAL READ OF TOU/IDR ** 11--> PASSBY                 **        
      ** 12--> DRIVE-BY READ          ** 13--> OFFICE READ            **        
      ** 14--> ADVANCED DRIVE-BY      ** 99--> FORCED COMPLETE        **        
      ***------------------------------------------------------------***        
      *                                                                         
           IF E-FBW81-READ-CODE IS NUMERIC                              
              MOVE E-FBW81-READ-CODE TO WS-READ-CODE                    
           ELSE                                                         
              MOVE ZEROS             TO WS-READ-CODE                    
              DISPLAY 'NO READ CODE:' E-FBW81-READ-CODE                 
           END-IF.                                                      
      *                                                                         
ACT016     MOVE WS-READ-CODE                  TO WS-FCS-READ-CODE-SW    
ACT016*                                                                         
ACT016     EVALUATE TRUE                                                
ACT016     WHEN NO-READ-CODE                                            
ACT016          MOVE '0'     TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
ACT016     WHEN REGULAR-READ-CODE                                       
ACT016          MOVE 'R'     TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
ACT016     WHEN OPTICAL-READ-CODE                                       
ACT016          MOVE 'P'     TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
ACT016     WHEN AMR-READ-CODE                                           
ACT016          MOVE 'A'     TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
ACT016     WHEN CUSTOMER-READ-CODE                                      
ACT016          MOVE 'C'     TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
ACT016     WHEN FIELD-EST-READ-CODE                                     
ACT016          MOVE 'F'     TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
ACT016     WHEN SCAN-REMOTE-READ-CODE                                   
ACT016          MOVE 'H'     TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
ACT016     WHEN MANU-REMOTE-READ-CODE                                   
ACT016          MOVE 'M'     TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
ACT016     WHEN MANU-TOU-READ-CODE                                      
ACT016          MOVE 'K'     TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
ACT016     WHEN OFFICE-READ-CODE                                        
ACT016          MOVE 'I'     TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
ACT016     WHEN OTHER                                                   
ACT016          MOVE '0'     TO WS-FBW06-CODE-METER-READ (BW06-SUB)     
ACT016          DISPLAY 'UN-HANDLED READ CODE:' E-FBW81-READ-CODE       
ACT016     END-EVALUATE                                                 
      *                                                                         
           MOVE SPACES       TO WS-FBW06-CODE-METER-NO-READ (BW06-SUB)  
           MOVE '3'          TO WS-FBW06-READ-PROCESS-CD (BW06-SUB)     
      *                                                                         
           IF WS-FBW06-CODE-METER-READ (BW06-SUB) = '0' OR '2'          
              MOVE '2'       TO WS-FBW06-READ-PROCESS-CD (BW06-SUB)     
              MOVE 'Z'       TO WS-FBW06-CODE-METER-NO-READ (BW06-SUB)  
              MOVE 1              TO WS-REG-SKIP-COUNT                  
           END-IF.                                                      
      *                                                                         
      ***------------------------------------------------------------***        
      ***-------------------READ CONDITION:9(01)---------------------***        
      ** 0 --> NO CONDITION DETECTED  ** 1 --> FAILED LOW2            **        
      ** 2 --> FAILED LOW1            ** 3 --> FAILED HIGH1           **        
      ** 4 --> FAILED HIGH2           ** 5 --> ZERO USE ON ACTIVE MTR **        
      ** 6 --> USAGE ON INACTIVE MTR  ** 7 --> FAILED TOU VALIDATION  **        
      ** 99--> NO VALIDATION PERFORMED                                **        
      ***------------------------------------------------------------***        
      *                                                                         
            EVALUATE E-FBW81-READ-CODITION                              
               WHEN 1 WHEN 2 WHEN 3 WHEN 4 WHEN 7                       
                  MOVE '#'   TO WS-FBW06-CODE-METER-NO-READ (BW06-SUB)  
                  IF E-FBW81-READ-FAIL-COUNT > 1                        
                    MOVE '@' TO WS-FBW06-CODE-METER-NO-READ (BW06-SUB)  
                  END-IF                                                
               WHEN 5                                                   
                  MOVE '7'   TO WS-FBW06-CODE-METER-NO-READ (BW06-SUB)  
               WHEN 6                                                   
                  MOVE '8'   TO WS-FBW06-CODE-METER-NO-READ (BW06-SUB)  
               WHEN OTHER                                               
                  CONTINUE                                              
            END-EVALUATE                                                
      *                                                                         
            IF E-FBW81-SKIP-CODE > SPACES                               
               AND E-FBW81-SKIP-CODE NOT = '00'                         
               MOVE 1              TO WS-REG-SKIP-COUNT                 
               IF E-FBW81-SKIP-CODE(1:1) = 'S'                          
                  MOVE E-FBW81-SKIP-CODE(2:1)                           
                             TO WS-FBW06-CODE-METER-NO-READ (BW06-SUB)  
               END-IF                                                   
            END-IF                                                      
                                                                        
      ***------------------------------------------------------------***        
      ***----------------ERT READ STATUS:9(01)-----------------------***        
      ** 0 --> READ NOT ATTEMPTED     ** 1 --> DC NOT EQUIP WITH RADIO**        
      ** 2 --> RF SOFTWARE ERROR      ** 3 --> RADIO FAILURE          **        
      ** 4 --> CACHE BUFFER ERROR     ** 5 --> NO READ FROM ERT       **        
      ** 6 --> ERROR FROM ERT(TYPE15) ** 7 --> READ SUCCESSFUL        **        
      ***------------------------------------------------------------***        
      *                                                                         
           MOVE 0        TO WS-ERT-READ-STATUS                          
           IF AMR-MTR                                                   
              IF E-FBW81-ERT-READ-STATUS IS NUMERIC                     
                 MOVE E-FBW81-ERT-READ-STATUS TO WS-ERT-READ-STATUS     
              END-IF                                                    
              IF READ-METHOD-WALK-BY OR READ-METHOD-DRIVE-BY            
                EVALUATE WS-ERT-READ-STATUS                             
                   WHEN 0                                               
                      MOVE '0' TO WS-FBW06-CODE-METER-READ (BW06-SUB)   
                   WHEN 1                                               
                      MOVE 'D' TO WS-FBW06-CODE-METER-READ (BW06-SUB)   
                   WHEN 2                                               
                      MOVE 'E' TO WS-FBW06-CODE-METER-READ (BW06-SUB)   
                   WHEN 3                                               
                      MOVE 'G' TO WS-FBW06-CODE-METER-READ (BW06-SUB)   
                   WHEN 4                                               
                      MOVE 'W' TO WS-FBW06-CODE-METER-READ (BW06-SUB)   
                   WHEN 5                                               
P00403                IF WS-READ-CODE NOT EQUAL 4                       
                         MOVE 'J' TO WS-FBW06-CODE-METER-READ (BW06-SUB)
P00403                END-IF                                            
                   WHEN 6                                               
                      MOVE 'L' TO WS-FBW06-CODE-METER-READ (BW06-SUB)   
                      PERFORM 3020-CREATE-TYPE15-WQ  THRU 3020-EXIT     
                   WHEN OTHER                                           
                      CONTINUE                                          
                END-EVALUATE                                            
                IF WS-ERT-READ-STATUS NOT = 7                           
                 MOVE 1              TO WS-REG-SKIP-COUNT               
                END-IF                                                  
              END-IF                                                    
      *                                                                         
              PERFORM 3040-PROCESS-TAMPERS      THRU 3040-EXIT          
      *                                                                         
              IF E-FBW81-ERT-ID-NEW NOT = E-FBW81-ERT-ID                
                 AND E-FBW81-ERT-ID-NEW IS NUMERIC                      
                 AND E-FBW81-ERT-ID-NEW > 0                             
                 MOVE E-FBW81-ERT-ID-NEW TO MA-DEVICE-NO                
                 MOVE MN-METER-NO        TO MA-METER-NO                 
A01738           IF WS-NEW-METER-NO > SPACES                            
                    MOVE WS-NEW-METER-NO    TO MA-METER-NO              
A01738           END-IF                                                 
                 PERFORM 7075-SELECT-AMR-DEVICE    THRU 7075-EXIT       
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    PERFORM 3030-GENRATE-ERT-CHNG-WQ THRU 3030-EXIT     
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW81-READ-DATETIME  TO WS-SAVE-READ-DATETIME         
           MOVE WS-SAVE-READ-DATE      TO WS-FBW06-DATE-READ (BW06-SUB) 
           MOVE WS-SAVE-READ-TIME      TO WS-FBW06-TIME-READ (BW06-SUB) 
           MOVE WS-WORKSET-ID          TO WS-FBW06-WORKSET-ID(BW06-SUB) 
      *                                                                         
           SET NOT-VALID-BW81-REC TO TRUE                               
A01738     IF OPTICAL-PROB-MTR AND WS-MTR-REG-COUNT = 1                 
              IF WS-READ-CODE =  9 OR 10                                
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 1420-TOU-NO-READ  THRU 1420-EXIT               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FIOBW81          THRU 7000-EXIT            
                              UNTIL VALID-BW81-REC                      
                              OR BW81-EOF-REACHED.                      
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1410-PROCESS-READ-SEQ.                                           
      *================================================================*        
      *                                                                         
           IF E-FBW81-MTR-READ-SEQ-NEW NOT = MN-REGISTER-RD-SEQ         
              AND MTR-SEQ-NUM-CHNGD                                     
                                                                        
              IF E-FBW81-MTR-READ-SEQ-NEW IS NUMERIC                    
                 MOVE E-FBW81-MTR-READ-SEQ-NEW TO MN-REGISTER-RD-SEQ    
                 SET WS-BW81-REG-SEQ-CHG       TO TRUE                  
              ELSE                                                      
                 DISPLAY '************** PCSBW182 ************'         
                 DISPLAY '* BW81-REGISTER-RD-SEQ NOT NUMERIC *'         
                 DISPLAY '* METER NO = '  E-FBW81-METER-NO              
                 DISPLAY '* REGISTER-RD-SEQ = ' E-FBW81-MTR-READ-SEQ-NEW
                 DISPLAY '************** PCSBW182 ************'         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1420-TOU-NO-READ.                                                
      *================================================================*        
      *                                                                         
      **** WRITE DUMMY TOU RECORD INSTEAD OF WRITING NO READ FOR                
      **** REGISTER OF PROB METER                                               
           MOVE ZEROES        TO WS-FBW06-METER-READING     (BW06-SUB)  
           MOVE 'TOU'         TO WS-FBW06-REG-MEASURE-CD    (BW06-SUB)  
           MOVE 'C'           TO WS-FBW06-CODE-TOU-SEASN    (BW06-SUB)  
           MOVE '0'           TO WS-FBW06-CODE-TIME-PERIOD  (BW06-SUB)  
           MOVE 'B'           TO WS-FBW06-CODE-USAGE-TYPE   (BW06-SUB)  
           MOVE 'Y'           TO WS-FBW06-CNSMPTN-READ-FL   (BW06-SUB)  
           MOVE 'I'           TO WS-FBW06-INDEX-VALUE-CD    (BW06-SUB)  
           MOVE 'B'           TO WS-FBW06-READ-ITEM-STATUS  (BW06-SUB)  
           MOVE 'I'           TO WS-FBW06-MTR-READ-SOURCE-CD(BW06-SUB)  
      *                                                                         
           PERFORM 7000-READ-FIOBW81        THRU 7000-EXIT              
              UNTIL BW81-EOF-REACHED                                    
              OR E-FBW81-ACCOUNT-NO NOT = WS-PREV-ACCOUNT-NO            
              OR E-FBW81-METER-CATEGORY NOT =  WS-PREV-METER-CATEGORY   
              OR E-FBW81-METER-NO       NOT =  WS-PREV-METER-NO.        
      *                                                                         
       1420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1430-PROCESS-TOU-KWH-READ.                                       
      *================================================================*        
      *                                                                         
           MOVE ZEROS                     TO WS-CURR-READ-VALUE         
                                             WS-CURNT-CHGD-RD-VAL       
                                             WS-EXCESS-INDX-DGT.        
                                                                        
           MOVE ZEROS                     TO MC-NO-READ-DIALS.          
           MOVE AT-COMPANY-NO             TO MC-COMPANY-NO.             
           MOVE MN-METER-NO               TO MC-METER-NO.               
           MOVE MN-CODE-UTIL-TYPE         TO MC-CODE-UTIL-TYPE.         
                                                                        
ACT144     IF WS-READ-DIGITS > 0                                        
ACT144        MOVE WS-READ-DIGITS         TO MC-NO-READ-DIALS           
ACT144     ELSE                                                         
ACT144        PERFORM 1520-SET-CODE-CAP-TYPE THRU 1520-EXIT             
ACT144        PERFORM 7300-SELECT-MTR-CAP    THRU 7300-EXIT             
ACT144     END-IF.                                                      
                                                                        
ACT144     IF MC-NO-READ-DIALS > 0                                      
ACT144        CONTINUE                                                  
ACT144     ELSE                                                         
ACT144        MOVE 5                      TO MC-NO-READ-DIALS           
ACT144     END-IF.                                                      
                                                                        
           MOVE WS-READ                   TO WS-CURR-READ-VALUE.        
                                                                        
           COMPUTE WS-EXCESS-INDX-DGT = (WS-CURR-READ-VALUE /           
                 (10 ** MC-NO-READ-DIALS))                              
             ON SIZE ERROR                                              
                MOVE ZERO TO WS-EXCESS-INDX-DGT                         
           END-COMPUTE.                                                 
                                                                        
           COMPUTE WS-CURNT-CHGD-RD-VAL = (WS-CURR-READ-VALUE -         
                   (WS-EXCESS-INDX-DGT * (10 ** MC-NO-READ-DIALS)))     
             ON SIZE ERROR                                              
                MOVE ZERO TO WS-CURNT-CHGD-RD-VAL                       
           END-COMPUTE.                                                 
                                                                        
           MOVE WS-CURNT-CHGD-RD-VAL      TO                            
                                     WS-FBW06-METER-READING(BW06-SUB).  
      *                                                                         
       1430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1520-SET-CODE-CAP-TYPE.                                          
      *================================================================*        
      *                                                                         
      **** EXPAND FOR ALL OTHER TYPES                                           
           MOVE WS-FBW06-CODE-USAGE-TYPE (BW06-SUB)                     
                                        TO WS-CODE-USAGE-TYPE.          
           EVALUATE WS-CODE-USAGE-TYPE                                  
              WHEN 'B'                                                  
              WHEN 'C'                                                  
                 MOVE 'A'                TO MC-CODE-CAP-TYPE            
              WHEN 'S'                                                  
                 MOVE 'C'                TO MC-CODE-CAP-TYPE            
              WHEN 'J'                                                  
                 MOVE 'B'                TO MC-CODE-CAP-TYPE            
              WHEN OTHER                                                
                 MOVE WS-CODE-USAGE-TYPE TO MC-CODE-CAP-TYPE            
           END-EVALUATE.                                                
      *                                                                         
       1520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2200-VAL-CODE-MTR-RD-INST.                                       
      *================================================================*        
      * VALIDATES CODE-METER-LOC OBTAINED AGAINST CSS_METER_LOC TABLE  *        
      * AND CODE-MTR-RD-INST1 AGAINST CSS_MTR_RD_INST TABLE            *        
      *----------------------------------------------------------------*        
      *                                                                         
      **** MTR LOCATION CODE CHNG                                               
           IF INST-LOC-CD1-CHNGD                                        
              AND E-FBW81-INSTR-LOC-CD1-NEW NOT EQUAL '00'              
              AND E-FBW81-INSTR-LOC-CD1-NEW NOT = MN-CODE-METER-LOC     
              MOVE E-FBW81-INSTR-LOC-CD1-NEW TO Q4-CODE-METER-LOC       
              PERFORM 7900-CHECK-MTR-LOC     THRU 7900-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE Q4-CODE-METER-LOC  TO MN-CODE-METER-LOC           
                 SET MN-UPDATE-REQUIRE   TO TRUE                        
              ELSE                                                      
                 MOVE SPACES                TO WS-WQ-COMMENTS           
                 STRING 'INVALID METER LOCATION CD '                    
                           Q4-CODE-METER-LOC                            
                           ' ON METER : '                               
                           MN-METER-NO    DELIMITED BY SIZE             
                    INTO WS-WQ-COMMENTS                                 
                 END-STRING                                             
                 MOVE WS-CATEGORY-ID-157    TO WS-HOLD-WQ-CATEGORY      
A03352           MOVE '1'                   TO WS-ROUTING-CATEGORY      
                 PERFORM 2300-POPULATE-WQ   THRU 2300-EXIT              
                 ADD  1                     TO WS-RESTART-WQ-COUNT      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      **** HZD OR READ INST CODE CHNG                                           
           IF INST-LOC-CD2-CHNGD                                        
              AND E-FBW81-INSTR-LOC-CD2-NEW NOT EQUAL '00'              
      **** CHECK FOR DELETE CODE & DELETE EXISTING INST                         
              IF E-FBW81-INSTR-LOC-CD2-NEW = 'ZZ'                       
                 MOVE SPACES           TO MN-CODE-MTR-RD-INST1          
                 SET MN-UPDATE-REQUIRE   TO TRUE                        
                 GO TO 2200-EXIT                                        
              END-IF                                                    
      **** JUST USE 2ND CHARECTOR (1ST CHAR ALWAYS U)                           
              MOVE E-FBW81-INSTR-LOC-CD2-NEW(2:1)                       
                                           TO Q5-CODE-MTR-RD-INST       
              PERFORM 7950-CHECK-MTR-RD-INST THRU 7950-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE Q5-CODE-MTR-RD-INST TO MN-CODE-MTR-RD-INST1       
                 SET MN-UPDATE-REQUIRE   TO TRUE                        
              ELSE                                                      
                 MOVE SPACES              TO WS-COMMENTS-TEMP           
                 MOVE MN-METER-NO         TO WS-WQ-METER-NO             
                 MOVE '1'                 TO WS-RD-INST                 
                 MOVE Q5-CODE-MTR-RD-INST TO WS-RD-INST-VAL             
                 MOVE WS-COMMENTS         TO WS-WQ-COMMENTS             
                 MOVE WS-CATEGORY-ID-289  TO WS-HOLD-WQ-CATEGORY        
A03352           MOVE '1'                 TO WS-ROUTING-CATEGORY        
                 PERFORM 2300-POPULATE-WQ THRU 2300-EXIT                
                 ADD  1                   TO WS-RESTART-WQ-COUNT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2300-POPULATE-WQ.                                                
      *================================================================*        
      *                                                                         
ACT260     INITIALIZE CWS00077-FIELDS.                                  
A04860     MOVE WS-INPUT-DATE                TO WS-INPUT-DATE-TS.       
A04860     MOVE WS-INPUT-DATE                TO WS-77-DATE-REQUIRED.    
A04860     MOVE WS-INPUT-TS                  TO WS-77-DATE-CREATED.     
A04860     MOVE ZERO                         TO WS-77-SERV-ORDER-NO.    
A04860     MOVE WS-HOLD-WQ-CATEGORY          TO WS-77-CATEGORY-ID.      
A04860     MOVE AT-ACCOUNT-NO                TO WS-77-ACCOUNT-NO.       
A04860     MOVE AT-CUSTOMER-NO               TO WS-77-CUSTOMER-NO.      
A04860     MOVE AT-LOCAL-OFFICE              TO WS-77-LOCAL-OFFICE.     
A04860     MOVE AT-PREMISE-NO                TO WS-77-PREMISE-NO.       
                                                                        
A04860     MOVE 'SYSTEM'                     TO WS-77-USER-ID-ORIG.     
A04860     MOVE WS-ROUTING-CATEGORY          TO WS-77-ROUTE-CATEGORY.   
A04860     MOVE WS-NORMAL-PRIORITY           TO WS-77-PRIORITY.         
A04860     MOVE SPACES                       TO WS-77-RESP-AREA-ID.     
                                                                        
           IF WS-COMMENTS-TEMP EQUAL SPACES                             
              MOVE WS-WQ-COMMENTS        TO WS-COMMENTS-TEMP            
           END-IF                                                       
A04860     MOVE WS-COMMENTS-TEMP         TO WS-77-COMMENTS-TEXT.        
A04860     MOVE LENGTH OF WS-77-COMMENTS-TEXT   TO WS-77-COMMENTS-LEN.  
A04860     MOVE SPACES                       TO WS-77-FREE-FORM-TXT.    
A04860     MOVE ZERO                         TO WS-77-FREE-FORM-LEN.    
A04860     MOVE WS-PGRMNAME                  TO WS-77-CREATED-BY.       
           PERFORM 8895-INSERT-WORK-QUEUE    THRU 8895-EXIT.            
ACT260     MOVE SPACES                       TO WS-WQ-COMMENTS          
                                                WS-COMMENTS-TEMP.       
           MOVE ZEROES                       TO WS-HOLD-WQ-CATEGORY.    
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2516-LOOKUP-MTR-RD-FMT.                                          
      *==============================================================*          
      *                                                                         
           PERFORM VARYING WS-MRF-SUB FROM 1 BY 1                       
                                 UNTIL WS-MRF-SUB > WS-RD-FMT-COUNT     
ACT144                            OR WS-MRF-SUB > 1200                  
P00251       IF TAB-CODE-UTIL-TYPE  (WS-MRF-SUB)   = WS-CODE-UTIL-TYPE  
              AND TAB-DIGTL-MTR-TYPE  (WS-MRF-SUB) = WS-DIGTL-MTR-TYPE  
              AND TAB-PROGRAM-ID      (WS-MRF-SUB) = WS-PROGRAM-ID      
              AND TAB-REMOTE-READ-IND(WS-MRF-SUB) = WS-REMOTE-READ-IND  
              AND TAB-MTR-READ-SOURCE-CD (WS-MRF-SUB)                   
                                       = WS-MTR-READ-SOURCE-CD          
                COMPUTE WS-MRF-SUB2 = WS-MRF-SUB2 + 1                   
                MOVE TAB-CODE-USAGE-TYPE (WS-MRF-SUB)                   
                                   TO ARR-CODE-USAGE-TYPE (WS-MRF-SUB2) 
P00251          MOVE TAB-CODE-USAGE-ID   (WS-MRF-SUB)                   
P00251                             TO ARR-CODE-USAGE-ID   (WS-MRF-SUB2) 
P00251          MOVE TAB-CODE-USAGE-SOURCE (WS-MRF-SUB)                 
P00251                             TO ARR-CODE-USAGE-SOURCE(WS-MRF-SUB2)
                MOVE TAB-CODE-TIME-PERIOD (WS-MRF-SUB)                  
                                   TO ARR-CODE-TIME-PERIOD (WS-MRF-SUB2)
                MOVE TAB-MTR-RD-DISP-CD (WS-MRF-SUB)                    
                                   TO ARR-MTR-RD-DISP-CD (WS-MRF-SUB2)  
                MOVE TAB-NO-READ-DIGITS (WS-MRF-SUB)                    
                                   TO ARR-NO-READ-DIGITS (WS-MRF-SUB2)  
                MOVE TAB-NO-READ-DECIMALS (WS-MRF-SUB)                  
                                   TO ARR-NO-READ-DECIMALS (WS-MRF-SUB2)
                MOVE TAB-READ-SEQUENCE-NO (WS-MRF-SUB)                  
                                   TO ARR-READ-SEQUENCE-NO (WS-MRF-SUB2)
                MOVE TAB-CODE-TOU-SEASN   (WS-MRF-SUB)                  
                                   TO ARR-CODE-TOU-SEASN   (WS-MRF-SUB2)
                MOVE TAB-INDEX-VALUE-CD   (WS-MRF-SUB)                  
                                   TO ARR-INDEX-VALUE-CD   (WS-MRF-SUB2)
                MOVE TAB-CNSMPTN-READ-FL  (WS-MRF-SUB)                  
                                   TO ARR-CNSMPTN-READ-FL  (WS-MRF-SUB2)
                MOVE 'N'           TO ARR-MATCH-FOUND  (WS-MRF-SUB2)    
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
           IF WS-MRF-SUB2 > 0                                           
              MOVE WS-MRF-SUB2 TO WS-MATCH-REG-COUNT                    
           ELSE                                                         
              PERFORM 3010-GENERATE-RD-FMT-WQ THRU 3010-EXIT            
           END-IF.                                                      
      *                                                                         
       2516-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2517-MATCH-MTR-RD-FMT.                                           
      *==============================================================*          
      *                                                                         
           SET NO-REG-MATCH-FOUND    TO TRUE                            
           PERFORM VARYING WS-MRF-SUB2 FROM 1 BY 1                      
                              UNTIL WS-MRF-SUB2 > WS-MATCH-REG-COUNT    
                                  OR WS-MRF-SUB2 > 50                   
                                  OR REG-MATCH-FOUND                    
             IF OPTICAL-PROB-MTR                                        
      *****  IF E-FBW81-TEXT-PROMPT = 'PROB'                                    
                IF E-FBW81-TEXT-PROMPT-RIR IS NUMERIC                   
                   MOVE E-FBW81-TEXT-PROMPT-RIR                         
                            TO WS-TEXT-PROMPT-RIR                       
                ELSE                                                    
                   MOVE ZEROS TO WS-TEXT-PROMPT-RIR                     
                   IF WS-MTR-REG-COUNT = WS-MRF-SUB2                    
                      SET REG-MATCH-FOUND    TO TRUE                    
                   END-IF                                               
                END-IF                                                  
                IF ARR-READ-SEQUENCE-NO (WS-MRF-SUB2)                   
                                    = WS-TEXT-PROMPT-RIR                
                   SET REG-MATCH-FOUND    TO TRUE                       
                END-IF                                                  
             ELSE                                                       
                IF E-FBW81-TEXT-PROMPT > SPACES                         
                   IF ARR-MTR-RD-DISP-CD (WS-MRF-SUB2)                  
                                    = E-FBW81-TEXT-PROMPT               
                      AND ARR-CODE-TOU-SEASN (WS-MRF-SUB2) = 'C'        
                      SET REG-MATCH-FOUND    TO TRUE                    
                   END-IF                                               
                ELSE                                                    
                   IF WS-MTR-REG-COUNT = WS-MRF-SUB2                    
                      SET REG-MATCH-FOUND    TO TRUE                    
                   END-IF                                               
                END-IF                                                  
             END-IF                                                     
             IF REG-MATCH-FOUND                                         
                MOVE ARR-CODE-USAGE-TYPE (WS-MRF-SUB2)                  
                                       TO WS-CODE-USAGE-TYPE            
                MOVE ARR-CODE-TIME-PERIOD (WS-MRF-SUB2)                 
                                       TO WS-CODE-TIME-PERIOD           
                MOVE ARR-CODE-TOU-SEASN   (WS-MRF-SUB2)                 
                                       TO WS-CODE-TOU-SEASN             
                MOVE ARR-MTR-RD-DISP-CD (WS-MRF-SUB2)                   
                                       TO WS-MTR-RD-DISP-CD             
                MOVE ARR-CNSMPTN-READ-FL  (WS-MRF-SUB2)                 
                                       TO WS-CNSMPTN-READ-FL            
                MOVE ARR-INDEX-VALUE-CD   (WS-MRF-SUB2)                 
                                       TO WS-INDEX-VALUE-CD             
                MOVE ARR-NO-READ-DIGITS (WS-MRF-SUB2)                   
                                       TO WS-READ-DIGITS                
                MOVE ARR-NO-READ-DECIMALS (WS-MRF-SUB2)                 
                                       TO WS-READ-DECIMALS              
P00251          MOVE ARR-CODE-USAGE-ID   (WS-MRF-SUB2)                  
P00251                                 TO WS-CODE-USAGE-ID              
P00251          MOVE ARR-CODE-USAGE-SOURCE (WS-MRF-SUB2)                
P00251                                 TO WS-CODE-USAGE-SOURCE          
                MOVE 'Y'               TO ARR-MATCH-FOUND (WS-MRF-SUB2) 
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
           IF NO-REG-MATCH-FOUND                                        
      *** IS THESE DEFAULTS OK?                                                 
              MOVE 'N'          TO WS-CNSMPTN-READ-FL                   
              MOVE E-FBW81-TEXT-PROMPT TO WS-MTR-RD-DISP-CD             
              MOVE 'C'          TO WS-CODE-TOU-SEASN                    
              MOVE ZEROS        TO WS-CODE-TIME-PERIOD                  
              MOVE SPACES       TO WS-CODE-USAGE-TYPE                   
P00251                             WS-CODE-USAGE-ID                     
P00251                             WS-CODE-USAGE-SOURCE                 
              MOVE SPACES       TO WS-INDEX-VALUE-CD                    
              MOVE ZEROS        TO WS-READ-DIGITS                       
                                   WS-READ-DECIMALS                     
           END-IF.                                                      
      *                                                                         
       2517-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2518-VAL-DIAL-DECIMAL-CHNG.                                      
      *==============================================================*          
      *                                                                         
      ***  TRACK DIALS CHANGE FLAG                                              
           IF READ-DIALS-CHNGD AND METER-FOUND                          
              IF WS-READ-DIGITS = 0 OR MRF-LOOKUP-NOT-REQ               
                 PERFORM 1520-SET-CODE-CAP-TYPE THRU 1520-EXIT          
                 MOVE ZEROS              TO MC-NO-READ-DIALS            
                 MOVE AT-COMPANY-NO      TO MC-COMPANY-NO               
                 MOVE MN-METER-NO        TO MC-METER-NO                 
                 MOVE MN-CODE-UTIL-TYPE  TO MC-CODE-UTIL-TYPE           
                 PERFORM 7300-SELECT-MTR-CAP    THRU 7300-EXIT          
                 MOVE MC-NO-READ-DIALS   TO WS-READ-DIGITS              
              END-IF                                                    
              IF E-FBW81-READ-DIALS-NEW NOT = WS-READ-DIGITS            
                 STRING MSG-CHG-DIALS                                   
                        'METER NO. '                                    
                        MN-METER-NO                                     
                        ' NO OF DIALS = '                               
                        E-FBW81-READ-DIALS-NEW                          
                        ' LOCAL OFFICE = '                              
                        AT-LOCAL-OFFICE                                 
                 DELIMITED BY SIZE INTO WS-WQ-COMMENTS                  
                 IF MN-CODE-UTIL-TYPE EQUAL WS-G                        
                    MOVE WS-CATEGORY-ID-232 TO WS-HOLD-WQ-CATEGORY      
A03352              MOVE '1'                TO WS-ROUTING-CATEGORY      
                 ELSE                                                   
A03352              MOVE WS-CATEGORY-ID-528 TO WS-HOLD-WQ-CATEGORY      
A03352              MOVE '4'                TO WS-ROUTING-CATEGORY      
                 END-IF                                                 
                 PERFORM 2300-POPULATE-WQ   THRU 2300-EXIT              
                 ADD  1                     TO WS-RESTART-WQ-COUNT      
              END-IF                                                    
           END-IF                                                       
      ***  TRACK DECIMALS CHANGE FLAG                                           
           IF READ-DECIMALS-CHNGD AND METER-FOUND                       
             AND E-FBW81-READ-DECIMALS-NEW NOT = WS-READ-DECIMALS       
              MOVE E-FBW81-READ-DECIMALS-NEW  TO WS-READ-DECIMALS       
              STRING MSG-CHG-DECIMALS                                   
                     'METER NO. '                                       
                     MN-METER-NO                                        
                     ' NO OF DIALS = '                                  
                     E-FBW81-READ-DECIMALS-NEW                          
                     ' LOCAL OFFICE = '                                 
                     AT-LOCAL-OFFICE                                    
              DELIMITED BY SIZE INTO WS-WQ-COMMENTS                     
              IF MN-CODE-UTIL-TYPE EQUAL WS-G                           
                 MOVE WS-CATEGORY-ID-232 TO WS-HOLD-WQ-CATEGORY         
A03352           MOVE '1'                TO WS-ROUTING-CATEGORY         
              ELSE                                                      
A03352           MOVE WS-CATEGORY-ID-528 TO WS-HOLD-WQ-CATEGORY         
A03352           MOVE '4'                TO WS-ROUTING-CATEGORY         
              END-IF                                                    
              PERFORM 2300-POPULATE-WQ   THRU 2300-EXIT                 
              ADD  1                     TO WS-RESTART-WQ-COUNT         
           END-IF.                                                      
      *                                                                         
       2518-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2900-UPD-MTR-ENVRNMT.                                            
      *================================================================*        
      *** UPDATES MTRD ENVRNMT AND/OR REG READ TABLES.                          
      *                                                                         
           PERFORM 8300-UPDATE-MTRD-ENVRNMT THRU 8300-EXIT              
           IF MN-CODE-DATA-PRESENT = 'A' AND WS-BW81-REG-SEQ-CHG        
              MOVE MN-REGISTER-RD-SEQ TO RG-REGISTER-RD-SEQ             
              MOVE MN-ACCOUNT-NO      TO RG-ACCOUNT-NO                  
              MOVE MN-METER-NO        TO RG-METER-NO                    
              MOVE MN-CODE-UTIL-TYPE  TO RG-CODE-UTIL-TYPE              
              PERFORM 8250-UPDATE-REG-READ THRU 8250-EXIT               
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3000-WRITE-CNTRL-REC.                                            
      *================================================================*        
      *                                                                         
           MOVE SPACES     TO FIOBW06.                                  
           INITIALIZE FIOBW06.                                          
      *                                                                         
           PERFORM VARYING WS-PART-INDX FROM 1 BY 1                     
              UNTIL WS-PART-INDX > WS-PART-COUNT                        
              MOVE WS-PARTITION-ID(WS-PART-INDX)(8:1)                   
                                       TO E-FBW06-DB-PART-DREC          
              MOVE ALL '9'             TO E-FBW06-RECORD-KEY            
              PERFORM 8001-WRITE-FIOBW06     THRU 8001-EXIT             
           END-PERFORM.                                                 
      *                                                                         
      ******************************************************************        
      * THE FOLLOWING STATEMENTS UPGRADE THE JOB-COMPLETE FIELD TO              
      * INDICATE A SUCCESSFUL COMPLETION:                                       
      ******************************************************************        
           MOVE SPACES   TO WS-RESTART-JOB-COMPLETE.                    
           IF WS-THIS-IS-A-RESTART                                      
              SET WS-RERUN-COMPLETED TO TRUE                            
           ELSE                                                         
              SET WS-RUN-COMPLETED-NO-PROBLEMS TO TRUE                  
           END-IF.                                                      
                                                                        
           IF COMMITS-REQUIRE                                           
              PERFORM 8899-WRITE-RSDDR     THRU 8899-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 8500-PRINT-COUNTERS     THRU 8500-EXIT               
                                                                        
           IF WS-RESTART-REQ EQUAL WS-Y                                 
              PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT        
           END-IF.                                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       3010-GENERATE-RD-FMT-WQ.                                         
      *==============================================================*          
      *                                                                         
           MOVE SPACES                TO WS-COMMENTS-TEMP               
           STRING 'WARNING: RECORD NOT FOUND IN CSS_MTR_RD_FMT '        
                  ' FOR THE TOU DMT/PGM ID COMBINATION.'                
                  ' METER NO: '                                         
                    MN-CODE-UTIL-TYPE                                   
                  ' '                                                   
                    MN-METER-NO                                         
                  '; DMT/PGM ID: '                                      
                   MN-DIGTL-MTR-TYPE                                    
                   '/'                                                  
                   MN-PROGRAM-ID                                        
                  '; MTR READ SOURCE CD: '                              
                    MN-MTR-READ-SOURCE-CD                               
                  '; REMOTE READ IND: '                                 
                     MN-REMOTE-READ-IND                                 
                 DELIMITED BY SIZE INTO WS-COMMENTS-TEMP                
           END-STRING                                                   
                                                                        
A03352     IF WS-SAVE-COMPANY-NO = '01'                                 
A03352        MOVE WS-CATEGORY-ID-528 TO WS-HOLD-WQ-CATEGORY            
A03352        MOVE '4'                TO WS-ROUTING-CATEGORY            
A03352     ELSE                                                         
A03352        MOVE WS-CATEGORY-ID-529 TO WS-HOLD-WQ-CATEGORY            
A03352        MOVE '1'                TO WS-ROUTING-CATEGORY            
A03352     END-IF                                                       
                                                                        
           PERFORM 2300-POPULATE-WQ   THRU 2300-EXIT                    
           ADD  1                     TO WS-RESTART-WQ-COUNT.           
      *                                                                         
       3010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       3020-CREATE-TYPE15-WQ.                                           
      *==============================================================*          
      *                                                                         
           MOVE SPACES                TO WS-COMMENTS-TEMP               
           STRING 'WARNING: ERT TYPE 15 RECEIVED, METER READ '          
                  'GROUP TO ISSUE ORDER TO RE-PROGRAM THE ERT.'         
                  ' METER NO: '                                         
                   MN-CODE-UTIL-TYPE                                    
                  ' '                                                   
                   MN-METER-NO                                          
                  '; CURR ERT ID: '                                     
                  E-FBW81-ERT-ID-NEW                                    
                  '; CURR ERT TYPE: '                                   
                  E-FBW81-ERT-TYPE-RCVD                                 
              DELIMITED BY SIZE INTO WS-COMMENTS-TEMP                   
           END-STRING                                                   
              MOVE WS-CATEGORY-ID-15  TO WS-HOLD-WQ-CATEGORY            
A03352        MOVE '1'                TO WS-ROUTING-CATEGORY            
              PERFORM 2300-POPULATE-WQ   THRU 2300-EXIT                 
              ADD  1                     TO WS-RESTART-WQ-COUNT.        
      *                                                                         
       3020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       3030-GENRATE-ERT-CHNG-WQ.                                        
      *==============================================================*          
      *                                                                         
           MOVE SPACES                TO WS-COMMENTS-TEMP               
A01738     STRING 'WARNING: METER/ERT COMBINATION IS NOT VALID.'        
                  ' METER NO: '                                         
A01738            MA-CODE-UTIL-TYPE                                     
                  ' '                                                   
A01738            MA-METER-NO                                           
                  '; NEW ERT ID: '                                      
                  E-FBW81-ERT-ID-NEW                                    
                  '; NEW ERT TYPE: '                                    
                  E-FBW81-ERT-TYPE-RCVD                                 
              DELIMITED BY SIZE INTO WS-COMMENTS-TEMP                   
           END-STRING                                                   
A01738     MOVE WS-CATEGORY-ID-15  TO WS-HOLD-WQ-CATEGORY               
A03352     MOVE '1'                TO WS-ROUTING-CATEGORY               
           PERFORM 2300-POPULATE-WQ   THRU 2300-EXIT                    
           ADD  1                     TO WS-RESTART-WQ-COUNT.           
      *                                                                         
       3030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       3040-PROCESS-TAMPERS.                                            
      *==============================================================*          
      *                                                                         
           IF E-FBW81-TAMPER-CD1-CHNG = 'Y'                             
              MOVE E-FBW81-TAMPER-CD1-NEW TO MN-CODE-MTR-RD-INST2       
           END-IF.                                                      
                                                                        
           IF E-FBW81-TAMPER-CD2-CHNG = 'Y'                             
              MOVE E-FBW81-TAMPER-CD2-NEW TO MN-CODE-MTR-RD-INST3       
           END-IF.                                                      
                                                                        
           IF E-FBW81-TAMPER-CD1-CHNG = 'Y'                             
              OR E-FBW81-TAMPER-CD2-CHNG = 'Y'                          
              SET MN-UPDATE-REQUIRE    TO TRUE                          
              IF E-FBW81-TAMPER-CD1 NOT = 16                            
                 OR E-FBW81-TAMPER-CD2 NOT = 16                         
                 DISPLAY 'TAMPER CHANGE DETECTED: '                     
                  ' METER NO: ' MN-CODE-UTIL-TYPE '|' MN-METER-NO       
                  ' |TAMPER CD1: ' E-FBW81-TAMPER-CD1 '-->'             
                    E-FBW81-TAMPER-CD1-NEW                              
                  ' |TAMPER CD2: ' E-FBW81-TAMPER-CD2 '-->'             
                    E-FBW81-TAMPER-CD2-NEW                              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       3040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * 6253-GET-FJC01-CHKP-LIMIT.                                              
       COPY CPD00034.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
      *** CHECK JOB PARM TABLE TO GET WS-RESTART-REQ FLAG                       
      * 6235-GET-FJC01-RESTART-REQ.                                             
       COPY CPD00035.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
       COPY CPD00040.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
       COPY CPD00037.                                                           
      *================================================================*        
                                                                        
      ******************************************************************        
      * COPYBOOK TO GET THE NEXT BUSINESS DAY                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00315                                                 
           END-EXEC.                                                            
      *                                                                         
A01738*****************************************************************         
A01738* COPYBOOK TO GET THE MOST CURRENT ACCOUNT AT A PREMISE         *         
A01738*****************************************************************         
A01738     EXEC SQL                                                             
A01738         INCLUDE CPDCA099                                                 
A01738     END-EXEC.                                                            
A01738*                                                                         
A01738******************************************************************        
A01738* ERROR ROUTINE TO HANDLE ERRORS FROM CPD00099                   *        
A01738******************************************************************        
A01738 6995-CPD99-ERROR-ROUTINE.                                        
A01738*                                                                         
A01738     IF  WS-ACTIVE-RETURN-CODE = WS-811                           
A01738         MOVE AT-ACCOUNT-NO          TO WS-CPD99-ACCOUNT-NO       
A01738     ELSE                                                         
A01738         DISPLAY '****************************************'       
A01738         DISPLAY '**     PCSBW182 PROCESSING ERROR      **'       
A01738         DISPLAY '**  ERROR IN PARA ', ACTIVE-PARAGRAPH           
A01738         DISPLAY '**  PREMISE-NO = ', WS-CPD99-PREMISE-NO         
A01738         DISPLAY '**  SQL CODE IS ', WS-CPD99-RETURN-CODE         
A01738         DISPLAY '****************************************'       
A01738         PERFORM 9900-ABEND THRU 9900-EXIT                        
A01738     END-IF.                                                      
A01738*                                                                         
A01738 6995-EXIT.                                                       
A01738     EXIT.                                                        
A01738*                                                                         
      *===============================================================*         
       7000-READ-FIOBW81.                                               
      *===============================================================*         
      *                                                                         
           READ FCSBW81-FILE                                            
                 AT END MOVE 'Y'          TO WS-BW81-EOF.               
      *                                                                         
           EVALUATE TRUE                                                
               WHEN FBW81-SUCCESSFUL                                    
                   ADD 1                       TO WS-FCSBW81-REC-CNTR   
                   IF E-FBW81-ACCOUNT-NO > 2                            
                      SET VALID-BW81-REC    TO  TRUE                    
                   ELSE                                                 
                      DISPLAY 'NEW ACCOUNT SKIPPED(ACC|MTR): '          
                      E-FBW81-ACCOUNT-NO '|' E-FBW81-METER-NO           
                   END-IF                                               
               WHEN FBW81-READ-EOF                                      
                   CONTINUE                                             
               WHEN OTHER                                               
                   DISPLAY 'ERROR 7000, BW81 STATUS = '                 
                   WS-FBW81-STATUS                                      
                   DISPLAY '**  PROCESSING TERMINATED  **'              
                   PERFORM 9900-ABEND          THRU 9900-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01738*================================================================*        
A01738 7040-FORMAT-METER-NUMBER.                                        
A01738*================================================================*        
A01738*                                                                         
A01738     EXEC SQL                                                     
A01738          SELECT
              CIS.SUBSTR3('000000000',1 ,                              
A01738            (9 - DATALENGTH(RTRIM(LTRIM(:WS-NEW-METER-NO))))) + 
           RTRIM(LTRIM(:WS-NEW-METER-NO))
            INTO
              :WS-NEW-METER-NO               
A01738     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-NEW-METER-NO =                                          
MFA-TR*             SUBSTR('000000000',1 ,                                      
MFA-TR*           (9 - LENGTH(RTRIM(LTRIM(:WS-NEW-METER-NO)))))                 
MFA-TR*                 || RTRIM(LTRIM(:WS-NEW-METER-NO))                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01738                                                                  
A01738                                                                  
A01738     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A01738*                                                                         
A01738     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A01738         CONTINUE                                                 
A01738     ELSE                                                         
A01738         MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
A01738         DISPLAY '************ PCSBW182 ERROR ******************' 
A01738         DISPLAY '** ERROR IN 7040-FORMAT-METER-NUMBER        **' 
A01738         DISPLAY '** ACCOUNT_NO     = ' MN-ACCOUNT-NO             
A01738         DISPLAY '** CODE_UTIL_TYPE = ' MN-CODE-UTIL-TYPE         
A01738         DISPLAY '** NEW METER_NO   = ' WS-NEW-METER-NO           
A01738         DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
A01738         DISPLAY '**********************************************' 
A01738         PERFORM 9900-ABEND              THRU 9900-EXIT           
A01738     END-IF.                                                      
A01738*                                                                         
A01738 7040-EXIT.                                                       
A01738     EXIT.                                                        
A01738*                                                                         
      *================================================================*        
       7050-SELECT-MTR-ENVRNMT.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) IC_NO,
              REGISTER_RD_SEQ,
              CODE_METER_LOC,
              CODE_METER_STATUS,
              REMOTE_READ_IND,
              MTR_READ_SOURCE_CD,
              DIGTL_MTR_TYPE,
              PROGRAM_ID,
              CODE_DATA_PRESENT,
              CODE_MTR_RD_INST1,
              CODE_MTR_RD_INST2,
              CODE_MTR_RD_INST3                               
                  INTO  :MN-IC-NO                                       
                       ,:MN-REGISTER-RD-SEQ                             
                       ,:MN-CODE-METER-LOC                              
                       ,:MN-CODE-METER-STATUS                           
                       ,:MN-REMOTE-READ-IND                             
                       ,:MN-MTR-READ-SOURCE-CD                          
                       ,:MN-DIGTL-MTR-TYPE                              
                       ,:MN-PROGRAM-ID                                  
                       ,:MN-CODE-DATA-PRESENT                           
                       ,:MN-CODE-MTR-RD-INST1                           
                       ,:MN-CODE-MTR-RD-INST2                           
                       ,:MN-CODE-MTR-RD-INST3                           
                  FROM  CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                  
                 WHERE  ACCOUNT_NO     = :MN-ACCOUNT-NO                 
                   AND  CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE             
                   AND  METER_NO       = :MN-METER-NO                   
                 ORDER BY CODE_METER_STATUS                             
                                             
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  IC_NO                                                   
MFA-TR*                ,REGISTER_RD_SEQ                                         
MFA-TR*                ,CODE_METER_LOC                                          
MFA-TR*                ,CODE_METER_STATUS                                       
MFA-TR*                ,REMOTE_READ_IND                                         
MFA-TR*                ,MTR_READ_SOURCE_CD                                      
MFA-TR*                ,DIGTL_MTR_TYPE                                          
MFA-TR*                ,PROGRAM_ID                                              
MFA-TR*                ,CODE_DATA_PRESENT                                       
MFA-TR*                ,CODE_MTR_RD_INST1                                       
MFA-TR*                ,CODE_MTR_RD_INST2                                       
MFA-TR*                ,CODE_MTR_RD_INST3                                       
MFA-TR*           INTO  :MN-IC-NO                                               
MFA-TR*                ,:MN-REGISTER-RD-SEQ                                     
MFA-TR*                ,:MN-CODE-METER-LOC                                      
MFA-TR*                ,:MN-CODE-METER-STATUS                                   
MFA-TR*                ,:MN-REMOTE-READ-IND                                     
MFA-TR*                ,:MN-MTR-READ-SOURCE-CD                                  
MFA-TR*                ,:MN-DIGTL-MTR-TYPE                                      
MFA-TR*                ,:MN-PROGRAM-ID                                          
MFA-TR*                ,:MN-CODE-DATA-PRESENT                                   
MFA-TR*                ,:MN-CODE-MTR-RD-INST1                                   
MFA-TR*                ,:MN-CODE-MTR-RD-INST2                                   
MFA-TR*                ,:MN-CODE-MTR-RD-INST3                                   
MFA-TR*           FROM  CSS_MTRD_ENVRNMT                                        
MFA-TR*          WHERE  ACCOUNT_NO     = :MN-ACCOUNT-NO                         
MFA-TR*            AND  CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                     
MFA-TR*            AND  METER_NO       = :MN-METER-NO                           
MFA-TR*          ORDER BY CODE_METER_STATUS                                     
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*          QUERYNO 7050                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR IN 7050-SELECT-MTR-ENVRNMT         **' 
               DISPLAY '** ACCOUNT_NO     = ' MN-ACCOUNT-NO             
               DISPLAY '** CODE_UTIL_TYPE = ' MN-CODE-UTIL-TYPE         
               DISPLAY '** METER_NO       = ' MN-METER-NO               
               DISPLAY '** SQLCODE        = ' WS-DISPLAY-SQLCODE        
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7052-GET-LOFFICE-FROM-O2.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT READ_CYCLE,                                        
                     LOCAL_OFFICE                                       
                INTO :O2-READ-CYCLE,                                    
                     :O2-LOCAL-OFFICE                                   
                FROM CSS_LOC_OFF_CYC_RT WITH(READUNCOMMITTED)                   
               WHERE READ_ROUTE = :O2-READ-ROUTE                        
                 AND COMPANY_NO = :O2-COMPANY-NO                        
                                                                 
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT READ_CYCLE,                                                
MFA-TR*              LOCAL_OFFICE                                               
MFA-TR*         INTO :O2-READ-CYCLE,                                            
MFA-TR*              :O2-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_LOC_OFF_CYC_RT                                         
MFA-TR*        WHERE READ_ROUTE = :O2-READ-ROUTE                                
MFA-TR*          AND COMPANY_NO = :O2-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7052                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR IN 7052-GET-LOFFICE-FROM-O2**'         
               DISPLAY '** O2-READ-ROUTE = ' O2-READ-ROUTE              
               DISPLAY '** O2-COMPANY-NO = ' O2-COMPANY-NO              
               DISPLAY '** RETURN CODE   = ' WS-DISPLAY-SQLCODE         
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7052-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7054-GET-MRMS-ROUTE.                                             
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) 1                                                   
             INTO  :WS-DUMMY-VAR1                                       
             FROM CSS_READ_RT_SOURCE WITH(READUNCOMMITTED)                      
             WHERE READ_ROUTE         = :R4-READ-ROUTE                  
               AND COMPANY_NO         = :R4-COMPANY-NO                  
               AND CODE_UTIL_TYPE  IN ( 'E','G','B')                    
                                             
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 1                                                           
MFA-TR*      INTO  :WS-DUMMY-VAR1                                               
MFA-TR*      FROM CSS_READ_RT_SOURCE                                            
MFA-TR*      WHERE READ_ROUTE         = :R4-READ-ROUTE                          
MFA-TR*        AND COMPANY_NO         = :R4-COMPANY-NO                          
MFA-TR*        AND CODE_UTIL_TYPE  IN ( 'E','G','B')                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7054                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR ON 7054-GET-MRMS-ROUTE             **' 
               DISPLAY '** READ_ROUTE      = ' R4-READ-ROUTE            
               DISPLAY '** COMPANY_NO      = ' R4-COMPANY-NO            
               DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE       
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF                                                       
           .                                                            
       7054-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *==============================================================*          
       7075-SELECT-AMR-DEVICE.                                          
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 1                                                 
                INTO :WS-DUMMY-VAR1                                     
                FROM  CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)               
                     ,CSS_MTR_ATT_TYPE   N5 WITH(READUNCOMMITTED)               
               WHERE  MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE             
                 AND  MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE              
                 AND  MA.COMPANY_NO     = :MA-COMPANY-NO                
                 AND  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE            
                 AND  MA.METER_NO       = :MA-METER-NO                  
                 AND  MA.DEVICE_NO      = :MA-DEVICE-NO                 
                 AND  N5.DEVICE_TYPE_CD = 'A'                           
                                             
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  1                                                         
MFA-TR*         INTO :WS-DUMMY-VAR1                                             
MFA-TR*         FROM  CSS_METER_ATTCHMTS MA                                     
MFA-TR*              ,CSS_MTR_ATT_TYPE   N5                                     
MFA-TR*        WHERE  MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE                     
MFA-TR*          AND  MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE                      
MFA-TR*          AND  MA.COMPANY_NO     = :MA-COMPANY-NO                        
MFA-TR*          AND  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                    
MFA-TR*          AND  MA.METER_NO       = :MA-METER-NO                          
MFA-TR*          AND  MA.DEVICE_NO      = :MA-DEVICE-NO                         
MFA-TR*          AND  N5.DEVICE_TYPE_CD = 'A'                                   
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7075                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR ON 7075-SELECT-AMR-DEVICE          **' 
               DISPLAY '** COMPANY_NO     = ' MA-COMPANY-NO             
               DISPLAY '** CODE_UTIL_TYPE = ' MA-CODE-UTIL-TYPE         
               DISPLAY '** METER_NO       = ' MA-METER-NO               
               DISPLAY '** DEVICE_NO      = ' MA-DEVICE-NO              
               DISPLAY '** SQL CODE       = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7075-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7100-SELECT-ROUTE-HEADER.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT UPLOAD_DATE                                       
                     ,PC_ROUTE_IND                                      
                     ,DOWNLOAD_METERS                                   
                     ,UPLOAD_METERS                                     
                 INTO :RH-UPLOAD-DATE :WS-NULL-IND                       
                     ,:RH-PC-ROUTE-IND                                  
                     ,:RH-DOWNLOAD-METERS                               
                     ,:RH-UPLOAD-METERS                                 
                 FROM CSS_ROUTE_HEADER WITH(READUNCOMMITTED)                    
                WHERE LOCAL_OFFICE  = :RH-LOCAL-OFFICE                  
                  AND READ_CYCLE    = :RH-READ-CYCLE                    
                  AND READ_ROUTE    = :RH-READ-ROUTE                    
                  AND REVENUE_MONTH = :RH-REVENUE-MONTH                 
                  AND COMPANY_NO    = :RH-COMPANY-NO                    
                                                                 
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT UPLOAD_DATE                                               
MFA-TR*              ,PC_ROUTE_IND                                              
MFA-TR*              ,DOWNLOAD_METERS                                           
MFA-TR*              ,UPLOAD_METERS                                             
MFA-TR*          INTO :RH-UPLOAD-DATE:WS-NULL-IND                               
MFA-TR*              ,:RH-PC-ROUTE-IND                                          
MFA-TR*              ,:RH-DOWNLOAD-METERS                                       
MFA-TR*              ,:RH-UPLOAD-METERS                                         
MFA-TR*          FROM CSS_ROUTE_HEADER                                          
MFA-TR*         WHERE LOCAL_OFFICE  = :RH-LOCAL-OFFICE                          
MFA-TR*           AND READ_CYCLE    = :RH-READ-CYCLE                            
MFA-TR*           AND READ_ROUTE    = :RH-READ-ROUTE                            
MFA-TR*           AND REVENUE_MONTH = :RH-REVENUE-MONTH                         
MFA-TR*           AND COMPANY_NO    = :RH-COMPANY-NO                            
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7100                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR IN 7100-SELECT-ROUTE-HEADER        **' 
               DISPLAY '** LOCAL OFFICE   = ' RH-LOCAL-OFFICE           
               DISPLAY '** READ CYCLE     = ' RH-READ-CYCLE             
               DISPLAY '** READ ROUTE     = ' RH-READ-ROUTE             
               DISPLAY '** REVENUE MONTH  = ' RH-REVENUE-MONTH          
               DISPLAY '** COMPANY NO     = ' RH-COMPANY-NO             
               DISPLAY '** SQL CODE       = ' WS-DISPLAY-SQLCODE        
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *===============================================================*         
       7150-SELECT-REVENUE-MONTH.                                       
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) REVENUE_MONTH,
              DATE_MTR_RD_XTRCT                                 
                 INTO :RW-REVENUE-MONTH                                 
                     ,:RW-DATE-MTR-RD-XTRCT                             
                 FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                     
                WHERE DATE_MTR_RD_XTRCT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )               
                  AND READ_CYCLE         = :RW-READ-CYCLE               
                  ORDER BY DATE_MTR_RD_XTRCT DESC                       
                                             
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REVENUE_MONTH                                             
MFA-TR*              ,DATE_MTR_RD_XTRCT                                         
MFA-TR*          INTO :RW-REVENUE-MONTH                                         
MFA-TR*              ,:RW-DATE-MTR-RD-XTRCT                                     
MFA-TR*          FROM CSS_READ_WINDOW                                           
MFA-TR*         WHERE DATE_MTR_RD_XTRCT <= :WS-INPUT-DATE                       
MFA-TR*           AND READ_CYCLE         = :RW-READ-CYCLE                       
MFA-TR*           ORDER BY DATE_MTR_RD_XTRCT DESC                               
MFA-TR*           FETCH FIRST ROW ONLY WITH UR                                  
MFA-TR*           QUERYNO 7150                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
             ELSE                                                       
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR IN 7150-SELECT-REVENUE-MONTH       **' 
               DISPLAY '** READ CYCLE         = ' RW-READ-CYCLE         
               DISPLAY '** DATE_MTR_RD_XTRCT <= ' WS-INPUT-DATE         
               DISPLAY '** SQL CODE           = ' WS-DISPLAY-SQLCODE    
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7200-SELECT-ACCOUNT.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT PREMISE_NO                                        
                     ,CUSTOMER_NO                                       
                     ,CODE_ACCT_STAT                                    
                     ,LOCAL_OFFICE                                      
                     ,COMPANY_NO                                        
                 INTO :AT-PREMISE-NO                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-CODE-ACCT-STAT                                
                     ,:AT-LOCAL-OFFICE                                  
                     ,:AT-COMPANY-NO                                    
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,CODE_ACCT_STAT                                            
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*          INTO :AT-PREMISE-NO                                            
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR IN 7200-SELECT-ACCOUNT             **' 
               DISPLAY '** ACCOUNT_NO      = ' AT-ACCOUNT-NO            
               DISPLAY '** SQLCODE         = ' WS-DISPLAY-SQLCODE       
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7210-OPEN-RD-FMT-CURSOR.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN RD_FMT                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW182 ERROR ******************'  
              DISPLAY '** ERROR IN 7210-OPEN-RD-FMT-CURSOR         **'  
              DISPLAY '** SELECT ALL ROWS FROM MTR_RD_FMT          **'  
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7220-FETCH-RD-FMT-CURSOR.                                        

MSQ008     MOVE 1200 TO MSQ008-RD-FMT
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
ACT144         FOR :MSQ008-RD-FMT
              FETCH 
              FROM RD_FMT               
P00251          INTO :TAB-CODE-UTIL-TYPE                                
                    ,:TAB-DIGTL-MTR-TYPE                                
                    ,:TAB-PROGRAM-ID                                    
                    ,:TAB-MTR-READ-SOURCE-CD                            
                    ,:TAB-REMOTE-READ-IND                               
                    ,:TAB-CODE-USAGE-TYPE                               
                    ,:TAB-CODE-TIME-PERIOD                              
                    ,:TAB-CODE-TOU-SEASN                                
P00251              ,:TAB-CODE-USAGE-ID                                 
P00251              ,:TAB-CODE-USAGE-SOURCE                             
                    ,:TAB-MTR-RD-DISP-CD                                
                    ,:TAB-INDEX-VALUE-CD                                
                    ,:TAB-NO-READ-DIGITS                                
                    ,:TAB-NO-READ-DECIMALS                              
                    ,:TAB-READ-SEQUENCE-NO                              
                    ,:TAB-CNSMPTN-READ-FL                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM RD_FMT FOR 1200 ROWS                      
MFA-TR*         INTO :TAB-CODE-UTIL-TYPE                                        
MFA-TR*             ,:TAB-DIGTL-MTR-TYPE                                        
MFA-TR*             ,:TAB-PROGRAM-ID                                            
MFA-TR*             ,:TAB-MTR-READ-SOURCE-CD                                    
MFA-TR*             ,:TAB-REMOTE-READ-IND                                       
MFA-TR*             ,:TAB-CODE-USAGE-TYPE                                       
MFA-TR*             ,:TAB-CODE-TIME-PERIOD                                      
MFA-TR*             ,:TAB-CODE-TOU-SEASN                                        
MFA-TR*             ,:TAB-CODE-USAGE-ID                                         
MFA-TR*             ,:TAB-CODE-USAGE-SOURCE                                     
MFA-TR*             ,:TAB-MTR-RD-DISP-CD                                        
MFA-TR*             ,:TAB-INDEX-VALUE-CD                                        
MFA-TR*             ,:TAB-NO-READ-DIGITS                                        
MFA-TR*             ,:TAB-NO-READ-DECIMALS                                      
MFA-TR*             ,:TAB-READ-SEQUENCE-NO                                      
MFA-TR*             ,:TAB-CNSMPTN-READ-FL                                       
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-RD-FMT
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)              TO WS-RD-FMT-COUNT           
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW182 ERROR ******************'  
              DISPLAY '** ERROR IN 7220-FETCH-RD-FMT-CURSOR        **'  
              DISPLAY '** SELECT ALL ROWS FROM MTR_RD_FMT          **'  
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7230-CLOSE-RD-FMT-CURSOR.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE RD_FMT                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW182 ERROR ******************'  
              DISPLAY '** ERROR IN 7230-CLOSE-RD-FMT-CURSOR        **'  
              DISPLAY '** CLOSE ERROR FOR RD_FMT CURSOR            **'  
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7300-SELECT-MTR-CAP.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) NO_READ_DIALS                                     
                 INTO :MC-NO-READ-DIALS                                 
                 FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                         
                WHERE CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE               
                  AND METER_NO       = :MC-METER-NO                     
                  AND CODE_CAP_TYPE  = :MC-CODE-CAP-TYPE                
                  AND COMPANY_NO     = :MC-COMPANY-NO                   
P00251            ORDER BY REG_ID_NO                                    
P00251                                       
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT NO_READ_DIALS                                             
MFA-TR*          INTO :MC-NO-READ-DIALS                                         
MFA-TR*          FROM CSS_MTR_CAP                                               
MFA-TR*         WHERE CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                       
MFA-TR*           AND METER_NO       = :MC-METER-NO                             
MFA-TR*           AND CODE_CAP_TYPE  = :MC-CODE-CAP-TYPE                        
MFA-TR*           AND COMPANY_NO     = :MC-COMPANY-NO                           
MFA-TR*           ORDER BY REG_ID_NO                                            
MFA-TR*           FETCH FIRST ROW ONLY WITH UR                                  
MFA-TR*           QUERYNO 7300                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR IN 7300-SELECT-MTR-CAP             **' 
               DISPLAY '** CODE_UTIL_TYPE  =' MC-CODE-UTIL-TYPE         
               DISPLAY '** METER_NO        =' MC-METER-NO               
               DISPLAY '** CODE_CAP_TYPE   =' MC-CODE-CAP-TYPE          
               DISPLAY '** COMPANY_NO      =' MC-COMPANY-NO             
               DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE       
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7310-GET-DMT-FROM-GM.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT DIGTL_MTR_TYPE                                    
                     ,PROGRAM_ID                                        
                INTO :GM-DIGTL-MTR-TYPE                                 
                    ,:GM-PROGRAM-ID                                     
                 FROM CSS_GAS_METER WITH(READUNCOMMITTED)                       
                WHERE CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE               
                  AND METER_NO       = :GM-METER-NO                     
                  AND COMPANY_NO     = :GM-COMPANY-NO                   
                                                                 
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DIGTL_MTR_TYPE                                            
MFA-TR*              ,PROGRAM_ID                                                
MFA-TR*         INTO :GM-DIGTL-MTR-TYPE                                         
MFA-TR*             ,:GM-PROGRAM-ID                                             
MFA-TR*          FROM CSS_GAS_METER                                             
MFA-TR*         WHERE CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE                       
MFA-TR*           AND METER_NO       = :GM-METER-NO                             
MFA-TR*           AND COMPANY_NO     = :GM-COMPANY-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7310                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR IN 7310-GET-DMT-FROM-GM            **' 
               DISPLAY '** CODE_UTIL_TYPE  = ' GM-CODE-UTIL-TYPE        
               DISPLAY '** METER_NO        = ' GM-METER-NO              
               DISPLAY '** COMPANY_NO      = ' GM-COMPANY-NO            
               DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE       
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7320-GET-DMT-FROM-EM.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT DIGTL_MTR_TYPE                                    
                     ,PROGRAM_ID                                        
                INTO :EM-DIGTL-MTR-TYPE                                 
                    ,:EM-PROGRAM-ID                                     
                 FROM CSS_ELEC_METER WITH(READUNCOMMITTED)                      
                WHERE CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE               
                  AND METER_NO       = :EM-METER-NO                     
                  AND COMPANY_NO     = :EM-COMPANY-NO                   
                                                                 
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DIGTL_MTR_TYPE                                            
MFA-TR*              ,PROGRAM_ID                                                
MFA-TR*         INTO :EM-DIGTL-MTR-TYPE                                         
MFA-TR*             ,:EM-PROGRAM-ID                                             
MFA-TR*          FROM CSS_ELEC_METER                                            
MFA-TR*         WHERE CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                       
MFA-TR*           AND METER_NO       = :EM-METER-NO                             
MFA-TR*           AND COMPANY_NO     = :EM-COMPANY-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7320                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR IN 7320-GET-DMT-FROM-EM            **' 
               DISPLAY '** CODE_UTIL_TYPE  = ' EM-CODE-UTIL-TYPE        
               DISPLAY '** METER_NO        = ' EM-METER-NO              
               DISPLAY '** COMPANY_NO      = ' EM-COMPANY-NO            
               DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE       
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7400-SELECT-RESTART-DATA.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART                                       
                WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                 
                  AND PARTITION_NO   = :RF-PARTITION-NO                 
                  AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                 
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART                                               
MFA-TR*         WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                         
MFA-TR*           AND PARTITION_NO   = :RF-PARTITION-NO                         
MFA-TR*           AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                         
MFA-TR*           QUERYNO 7400                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR IN 7400-SELECT-RESTART-DATA        **' 
               DISPLAY '** NAME_PROGRAM    = ' RF-NAME-PROGRAM          
               DISPLAY '** PARTITION_NO    = ' RF-PARTITION-NO          
               DISPLAY '** DUP_CNTRL_NO    = ' RF-DUP-CNTRL-NO          
               DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE       
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7500-OPEN-BTCH-PARTITION.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN BTCH_PARTITION                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW182 ERROR ******************'  
              DISPLAY '** ERROR IN 7500-OPEN-BTCH-PARTITION        **'  
              DISPLAY '** PARTITION_ID B/W ATPART01 AND ATPART09   **'  
              DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7510-FETCH-BTCH-PARTITION.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH BTCH_PARTITION                                     
                INTO :O5-PARTITION-ID                                   
                    ,:O5-BEGIN-PART-RANGE                               
                    ,:O5-END-PART-RANGE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW182 ERROR ******************'  
              DISPLAY '** ERROR IN 7510-FETCH-BTCH-PARTITION       **'  
              DISPLAY '** PARTITION_ID B/W ATPART01 AND ATPART09   **'  
              DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7520-CLOSE-BTCH-PARTITION.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE BTCH_PARTITION                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW182 ERROR ******************'  
              DISPLAY '** ERROR IN 7520-CLOSE-BTCH-PARTITION       **'  
              DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * 7600-START-FCSJC01                    *                                 
      *================================================================*        
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
      * 7620-START-FCSCA00 VSAM CTRL FILE     *                                 
      *================================================================*        
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       7900-CHECK-MTR-LOC.                                              
      *================================================================*        
      **  CHECKS IF A RECORD WITH CODE-METER-LOC PASSED FROM THE INPUT *        
      **  FILE  EXISTS ON CSS_METER_LOC TABLE                          *        
      *                                                                         
              EXEC SQL                                                  
                 SELECT  'Y'                                            
                   INTO  :WS-EXISTS                                     
                   FROM  CSS_METER_LOC WITH(READUNCOMMITTED)                    
                  WHERE  CODE_METER_LOC = :Q4-CODE-METER-LOC            
                                                                 
A03352                                                      
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT  'Y'                                                    
MFA-TR*            INTO  :WS-EXISTS                                             
MFA-TR*            FROM  CSS_METER_LOC                                          
MFA-TR*           WHERE  CODE_METER_LOC = :Q4-CODE-METER-LOC                    
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7900                                                   
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW182 ERROR ******************'  
              DISPLAY '** ERROR IN 7900-CHECK-MTR-LOC              **'  
              DISPLAY '** CODE_METER_LOC  = ' Q4-CODE-METER-LOC         
              DISPLAY '** SQL CODE        = ' WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7950-CHECK-MTR-RD-INST.                                          
      *================================================================*        
      **  CHECKS IF A RECORD WITH CODE-MTR-RD-INST PASSED FROM INPUT   *        
      **  FILE  EXISTS ON CSS_MTR_RD_INST TABLE                        *        
      *                                                                         
              EXEC SQL                                                  
                 SELECT  'Y'                                            
                   INTO  :WS-EXISTS                                     
                   FROM  CSS_MTR_RD_INST WITH(READUNCOMMITTED)                  
                  WHERE  CODE_MTR_RD_INST = :Q5-CODE-MTR-RD-INST        
                                                                 
A03352                                                      
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT  'Y'                                                    
MFA-TR*            INTO  :WS-EXISTS                                             
MFA-TR*            FROM  CSS_MTR_RD_INST                                        
MFA-TR*           WHERE  CODE_MTR_RD_INST = :Q5-CODE-MTR-RD-INST                
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7950                                                  
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW182 ERROR ******************'  
              DISPLAY '** ERROR IN 7950-CHECK-MTR-RD-INST          **'  
              DISPLAY '** CODE_MTR_RD_INST = ' Q5-CODE-MTR-RD-INST      
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8001-WRITE-FIOBW06.                                              
      *================================================================*        
      *                                                                         
           WRITE FIOBW06-REC FROM FIOBW06.                              
      *                                                                         
           IF FBW06-SUCCESSFUL                                          
              ADD 1                TO WS-RESTART-FBW06-REC-CNTR         
           ELSE                                                         
               DISPLAY '8001-ERROR ON FCSBW06 WRITE.  STATUS IS '       
                        WS-FBW06-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8200-UPDATE-SPCL-READ-INSTR.                                     
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
               SET SPCL_READ_INSTR = :PR-SPCL-READ-INSTR                
               WHERE PREMISE_NO    = :PR-PREMISE-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 ADD 1               TO WS-RESTART-PR-UPDT-CNTR-TOT     
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW182 ERROR ******************'  
              DISPLAY '** ERROR IN 8200-UPDATE-SPCL-READ-INSTR     **'  
              DISPLAY '** ACCOUNT-NO       = ' AT-ACCOUNT-NO            
              DISPLAY '** PREMISE_NO       = ' PR-PREMISE-NO            
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8250-UPDATE-REG-READ.                                            
      *================================================================*        
      **  UPDATES REGISTER_READ TABLE WITH REGISTER_RD-SEQ, WHENEVER   *        
      **  CODE_DATA_PRESENT = 'A' IN MTRD_ENVRNMT.                     *        
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_REGISTER_READ                                  
                 SET REGISTER_RD_SEQ   = :RG-REGISTER-RD-SEQ            
               WHERE CODE_UTIL_TYPE    = :RG-CODE-UTIL-TYPE             
                 AND METER_NO          = :RG-METER-NO                   
                 AND ACCOUNT_NO        = :RG-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
               ADD 1                     TO WS-RESTART-RG-UPDT-CNTR-TOT 
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE      
                 DISPLAY '*********** PCSBW182 ERROR *****************' 
                 DISPLAY '** ERROR IN 8250-UPDATE-REG-READ          **' 
                 DISPLAY '** CODE_UTIL_TYPE   = ' RG-CODE-UTIL-TYPE     
                 DISPLAY '** METER_NO         = ' RG-METER-NO           
                 DISPLAY '** ACCOUNT_NO       = ' RG-ACCOUNT-NO         
                 DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE    
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND        THRU 9900-EXIT               
           END-EVALUATE.                                                
      *                                                                         
       8250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8300-UPDATE-MTRD-ENVRNMT.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              UPDATE  CSS_MTRD_ENVRNMT                                  
                 SET  CODE_METER_LOC    = :MN-CODE-METER-LOC            
                     ,REGISTER_RD_SEQ   = :MN-REGISTER-RD-SEQ           
                     ,CODE_MTR_RD_INST1 = :MN-CODE-MTR-RD-INST1         
                     ,CODE_MTR_RD_INST2 = :MN-CODE-MTR-RD-INST2         
                     ,CODE_MTR_RD_INST3 = :MN-CODE-MTR-RD-INST3         
               WHERE  CODE_UTIL_TYPE    = :MN-CODE-UTIL-TYPE            
                 AND  METER_NO          = :MN-METER-NO                  
                 AND  ACCOUNT_NO        = :MN-ACCOUNT-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
               ADD 1                     TO WS-RESTART-MN-UPDT-CNTR-TOT 
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE      
                 DISPLAY '*********** PCSBW182 ERROR *****************' 
                 DISPLAY '** ERROR IN 8300-UPDATE-MTRD-ENVRNMT      **' 
                 DISPLAY '** CODE_UTIL_TYPE   = ' MN-CODE-UTIL-TYPE     
                 DISPLAY '** METER_NO         = ' MN-METER-NO           
                 DISPLAY '** ACCOUNT_NO       = ' MN-ACCOUNT-NO         
                 DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE    
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND        THRU 9900-EXIT               
           END-EVALUATE.                                                
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8400-INSERT-ROUTE-HEADER.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_ROUTE_HEADER                            
                      (LOCAL_OFFICE,                                    
                       READ_CYCLE,                                      
                       READ_ROUTE,                                      
                       DOWNLOAD_DATE,                                   
                       UPLOAD_DATE,                                     
                       PC_ROUTE_IND,                                    
                       DOWNLOAD_METERS,                                 
                       UPLOAD_METERS,                                   
                       COMPANY_NO,                                      
                       REVENUE_MONTH,                                   
                       DOWN_RMVD_MTR_QT,                                
                       UP_RMVD_MTR_QT)                                  
                VALUES                                                  
                      (:RH-LOCAL-OFFICE,                                
                       :RH-READ-CYCLE,                                  
                       :RH-READ-ROUTE,                                  
                       IIF(TRY_CONVERT(DATE, :RH-DOWNLOAD-DATE
              ) IS NULL OR (PATINDEX('%.%', :RH-DOWNLOAD-DATE
              ) <> 0) OR (LEN(:RH-DOWNLOAD-DATE) <> 10), CIS.CHAR2DATE(
                                                      :RH-DOWNLOAD-DATE
              ), CONVERT(DATE, :RH-DOWNLOAD-DATE) ),                           
                       IIF(TRY_CONVERT(DATE, :RH-UPLOAD-DATE
              ) IS NULL OR (PATINDEX('%.%', :RH-UPLOAD-DATE
              ) <> 0) OR (LEN(:RH-UPLOAD-DATE) <> 10), CIS.CHAR2DATE(
                                                        :RH-UPLOAD-DATE
              ), CONVERT(DATE, :RH-UPLOAD-DATE) ),                             
                       :RH-PC-ROUTE-IND,                                
                       :RH-DOWNLOAD-METERS,                             
                       :RH-UPLOAD-METERS,                               
                       :RH-COMPANY-NO,                                  
                       :RH-REVENUE-MONTH,                               
                       :RH-DOWN-RMVD-MTR-QT,                            
                       :RH-UP-RMVD-MTR-QT)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ROUTE_HEADER                                    
MFA-TR*               (LOCAL_OFFICE,                                            
MFA-TR*                READ_CYCLE,                                              
MFA-TR*                READ_ROUTE,                                              
MFA-TR*                DOWNLOAD_DATE,                                           
MFA-TR*                UPLOAD_DATE,                                             
MFA-TR*                PC_ROUTE_IND,                                            
MFA-TR*                DOWNLOAD_METERS,                                         
MFA-TR*                UPLOAD_METERS,                                           
MFA-TR*                COMPANY_NO,                                              
MFA-TR*                REVENUE_MONTH,                                           
MFA-TR*                DOWN_RMVD_MTR_QT,                                        
MFA-TR*                UP_RMVD_MTR_QT)                                          
MFA-TR*         VALUES                                                          
MFA-TR*               (:RH-LOCAL-OFFICE,                                        
MFA-TR*                :RH-READ-CYCLE,                                          
MFA-TR*                :RH-READ-ROUTE,                                          
MFA-TR*                :RH-DOWNLOAD-DATE,                                       
MFA-TR*                :RH-UPLOAD-DATE,                                         
MFA-TR*                :RH-PC-ROUTE-IND,                                        
MFA-TR*                :RH-DOWNLOAD-METERS,                                     
MFA-TR*                :RH-UPLOAD-METERS,                                       
MFA-TR*                :RH-COMPANY-NO,                                          
MFA-TR*                :RH-REVENUE-MONTH,                                       
MFA-TR*                :RH-DOWN-RMVD-MTR-QT,                                    
MFA-TR*                :RH-UP-RMVD-MTR-QT)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE EQUAL     TO SUCCESSFUL-CALL        
              ADD 1                           TO                        
                                             WS-RESTART-RH-ISRT-CNTR-TOT
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR IN 8400-INSERT-ROUTE-HEADER        **' 
               DISPLAY '** LOCAL OFFICE     = ' RH-LOCAL-OFFICE         
               DISPLAY '** READ CYCLE       = ' RH-READ-CYCLE           
               DISPLAY '** READ ROUTE       = ' RH-READ-ROUTE           
               DISPLAY '** REVENUE MONTH    = ' RH-REVENUE-MONTH        
               DISPLAY '** COMPANY NO       = ' RH-COMPANY-NO           
               DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE      
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8450-UPDATE-ROUTE-HEADER.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_ROUTE_HEADER                                  
                  SET UPLOAD_DATE    = IIF(TRY_CONVERT(DATE, 
                                                        :RH-UPLOAD-DATE
              ) IS NULL OR (PATINDEX('%.%', :RH-UPLOAD-DATE
              ) <> 0) OR (LEN(:RH-UPLOAD-DATE) <> 10), CIS.CHAR2DATE(
                                                        :RH-UPLOAD-DATE
              ), CONVERT(DATE, :RH-UPLOAD-DATE) )                  
                     ,UPLOAD_METERS  = :RH-UPLOAD-METERS                
                WHERE LOCAL_OFFICE   = :RH-LOCAL-OFFICE                 
                  AND READ_CYCLE     = :RH-READ-CYCLE                   
                  AND READ_ROUTE     = :RH-READ-ROUTE                   
                  AND REVENUE_MONTH  = :RH-REVENUE-MONTH                
                  AND COMPANY_NO     = :RH-COMPANY-NO                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ROUTE_HEADER                                          
MFA-TR*           SET UPLOAD_DATE    = :RH-UPLOAD-DATE                          
MFA-TR*              ,UPLOAD_METERS  = :RH-UPLOAD-METERS                        
MFA-TR*         WHERE LOCAL_OFFICE   = :RH-LOCAL-OFFICE                         
MFA-TR*           AND READ_CYCLE     = :RH-READ-CYCLE                           
MFA-TR*           AND READ_ROUTE     = :RH-READ-ROUTE                           
MFA-TR*           AND REVENUE_MONTH  = :RH-REVENUE-MONTH                        
MFA-TR*           AND COMPANY_NO     = :RH-COMPANY-NO                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF  WS-ACTIVE-RETURN-CODE EQUAL     TO SUCCESSFUL-CALL       
               ADD 1                           TO                       
                                             WS-RESTART-RH-UPDT-CNTR-TOT
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE        
               DISPLAY '************ PCSBW182 ERROR ******************' 
               DISPLAY '** ERROR IN 8450-UPDATE-ROUTE-HEADER        **' 
               DISPLAY '** LOCAL OFFICE     = ' RH-LOCAL-OFFICE         
               DISPLAY '** READ CYCLE       = ' RH-READ-CYCLE           
               DISPLAY '** READ ROUTE       = ' RH-READ-ROUTE           
               DISPLAY '** REVENUE MONTH    = ' RH-REVENUE-MONTH        
               DISPLAY '** COMPANY NO.      = ' RH-COMPANY-NO           
               DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE      
               DISPLAY '** PROCESSING TERMINATED                    **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8500-PRINT-COUNTERS.                                             
      *================================================================*        
      *                                                                         
           MOVE WS-RESTART-MN-UPDT-CNTR-TOT TO WS-DISP-MN-UCNTR.        
           MOVE WS-RESTART-RG-UPDT-CNTR-TOT TO WS-DISP-RG-UCNTR.        
           MOVE WS-RESTART-PR-UPDT-CNTR-TOT TO WS-DISP-PR-UCNTR.        
           MOVE WS-RESTART-RH-UPDT-CNTR-TOT TO WS-DISP-RH-UCNTR.        
           MOVE WS-RESTART-RH-ISRT-CNTR-TOT TO WS-DISP-RH-ICNTR.        
           MOVE WS-RESTART-WQ-COUNT         TO WS-DISP-WQ-COUNT.        
           MOVE WS-RESTART-ROUTE-CNTR-TOT   TO WS-DISP-ROUTE-COUNT.     
                                                                        
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY '*****   I/O COUNTERS FOR PCSBW182   *****'.         
           DISPLAY ' '.                                                 
           DISPLAY '** TOTAL MN UPDATES        = ' WS-DISP-MN-UCNTR.    
           DISPLAY '** TOTAL RG UPDATES        = ' WS-DISP-RG-UCNTR.    
           DISPLAY '** TOTAL RH INSERTS        = ' WS-DISP-RH-ICNTR.    
           DISPLAY '** TOTAL RH UPDATES        = ' WS-DISP-RH-UCNTR.    
           DISPLAY '** TOTAL PR UPDATES        = ' WS-DISP-PR-UCNTR.    
           DISPLAY '** TOTAL ROUTES PROCESSED  = ' WS-DISP-ROUTE-COUNT. 
           DISPLAY "** TOTAL WQ'S GENEATE      = " WS-DISP-WQ-COUNT.    
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04860***************************************************************** 28580000
A04860**                                                             ** 28590000
A04860**    8895-INSERT-WORK-QUEUE                                   ** 28600000
A04860**  CALL SUB PROGRAM SCSCB077 FOR INSERTING WORK QUEUES INTO   ** 28610000
A04860**  CSS_WQ_ITEMS                                               ** 28620000
A04860**                                                             ** 28630000
A04860***************************************************************** 28640000
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860                                                                  
A04860     CALL SCSCB077  USING   CWS00077-FIELDS,                      
A04860                            ABEND-FILE,                           
A04860                            RS-RETURN-CODE.                       
A04860*                                                                         
A04860     MOVE RS-RETURN-CODE          TO WS-ACTIVE-RETURN-CODE.       
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'COMMENTS        ' WS-77-COMMENTS                 
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860                                                                  
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
A04860                                                                  
      *================================================================*        
       8896-UPDATE-RESTART.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW182 ERROR ******************'  
              DISPLAY '** ERROR IN 8896-UPDATE-RESTART             **'  
              DISPLAY '** NAME_PROGRAM     = ' RF-NAME-PROGRAM          
              DISPLAY '** PARTITION_NO     = ' RF-PARTITION-NO          
              DISPLAY '** DUP_CNTRL_NO     = ' RF-DUP-CNTRL-NO          
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8896-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8897-INSERT-RESTART.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM, PARTITION_NO, DUP_CNTRL_NO,           
                    RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM, :RF-PARTITION-NO,                 
                    :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW182 ERROR ******************'  
              DISPLAY '** ERROR IN 8897-INSERT-RESTART             **'  
              DISPLAY '** NAME_PROGRAM     = ' RF-NAME-PROGRAM          
              DISPLAY '** PARTITION_NO     = ' RF-PARTITION-NO          
              DISPLAY '** DUP_CNTRL_NO     = ' RF-DUP-CNTRL-NO          
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8897-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **** RESET RESTART-REQ PARAMETER TO INACTIVE                              
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       8898-ISSUE-CHKP.                                                 
      *================================================================*        
      *                                                                         
           MOVE 1                      TO WS-RESTART-PROCESS-TYPE.      
           ADD 1                       TO WS-CHKP-SEQ-NO.               
           MOVE WS-CHKP-SEQ-NO         TO WS-RESTART-CHKP-SEQ-NO.       
           MOVE WS-FCSBW81-REC-CNTR    TO WS-RESTART-RECORD-NO          
           COMPUTE WS-RESTART-RECORD-NO = WS-RESTART-RECORD-NO - 1      
           MOVE WS-PREV-ACCOUNT-NO     TO WS-RESTART-ACCOUNT-NO         
           MOVE WS-PREV-METER-NO       TO WS-RESTART-METER-NO           
           MOVE WS-PREV-WORK-SET-ID    TO WS-RESTART-WORKSET-ID         
      *                                                                         
           PERFORM 8899-WRITE-RSDDR                  THRU 8899-EXIT.    
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                                        
           MOVE ZEROS                  TO WS-COMMIT-ROUTES              
           DISPLAY 'COMMIT POINT# ' WS-CHKP-SEQ-NO ' TAKEN.'            
                   'LAST WORKSET:' WS-PREV-WORK-SET-ID                  
                   ';READ CYCLE:' RH-READ-CYCLE                         
                   ';LOC OFFICE:' RH-LOCAL-OFFICE                       
                   ';UPLD METERS:' RH-UPLOAD-METERS                     
                   ';ENTRY PROCESSED:' WS-RESTART-RECORD-NO.            
      *                                                                         
       8898-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8899-WRITE-RSDDR.                                                
      *================================================================*        
      *                                                                         
           MOVE WS-ONE                 TO RF-PARTITION-NO.              
           MOVE PROGRAM-NAME           TO RF-NAME-PROGRAM.              
           MOVE WS-ONE                 TO RF-DUP-CNTRL-NO.              
           MOVE WS-RESTART-DATA        TO RF-RESTART-DATA-TEXT.         
           MOVE WS-RESTART-DATA-LENGTH TO RF-RESTART-DATA-LEN.          
           PERFORM 8896-UPDATE-RESTART THRU 8896-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8897-INSERT-RESTART THRU 8897-EXIT                
           END-IF.                                                      
      *                                                                         
       8899-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       9000-TERMINATE.                                                  
      *================================================================*        
      *                                                                         
           CLOSE FCSBW81-FILE.                                          
      *                                                                         
           IF  FBW81-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSBW182 PROCESSING ERROR           **'     
               DISPLAY '**  CLOSE ERROR  - OUTPUT FILES         **'     
               DISPLAY '**  FILE STATUS = ' WS-FBW81-STATUS             
               DISPLAY '**  UNSUCCESSFUL CLOSE OF FCSBW81-FILE  **'     
           END-IF.                                                      
      *                                                                         
           CLOSE FCSBW06-FILE.                                          
                                                                        
           IF  FBW06-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSBW182 PROCESSING ERROR           **'     
               DISPLAY '**  CLOSE ERROR  - OUTPUT FILES         **'     
               DISPLAY '**  FILE STATUS = ' WS-FBW06-STATUS             
               DISPLAY '**  UNSUCCESSFUL CLOSE OF FCSBW06-FILE  **'     
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND INCLUDES SQL ROLLBACK   ****           
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ****************** END OF PCSBW182 *****************************          
      ****************************************************************          
      *                                                                         
