       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW181.                                        
       DATE-WRITTEN.   07/13/09.                                        
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **              South Carolina Electricity  & Gas              ** 00060000
      **               COMPLETE BUSINESS SOLUTIONS INC.              ** 00070000
      **                                                             ** 00080000
      *********            CUSTOMER SERVICE SYSTEM            ********* 00090000
      *********              PURE COBOL (NO DB2)              ********* 00100000
      ***************************************************************** 00110000
      **                                                             ** 00120000
      **              PROGRAM  MODIFICATION  LOG                     ** 00130000
      **                                                             ** 00140000
      ** DATE       INITIALS        REASON                           ** 00150000
      ** ========   ========     ====================================** 00160000
      ** 07/13/09   NC94746      New code developed for FCS          ** 00170000
P00251** 01/25/10   SS95855      Net Metering                        ** 00180000
P00251**                         -Code_Usage_Id & Code_Usage_Source  ** 00190000
P00251**                         added to FIOBW81 layout.            ** 00200000
P00251**                         -MSICD-USAGE-TYPE changed to        ** 00201000
P00251**                         MSICD-CODE-USAGE-TYPE.              ** 00202000
A00775** 05/20/10   NC94746      PERFORMANCE RELATED CHANGES.        ** 00203013
      ***************************************************************** 00210000
      **                    PCSBW181   NARRATIVE                     ** 00220000
      **    XML PARSER FOR FCS EXPORT.                               ** 00230000
      **    CREATES BW81 FILE TO PCSBW182                            ** 00240000
      **                                                             ** 00250000
      ***************************************************************** 00260000
      *                                                                 00270000
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                 00360000
HPCCDM*EJECT                                                            00370000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00400000
      *                                                                 00410000
       FILE-CONTROL.                                                    
       COPY CSSBW73.                                                    00430000
       COPY CSSBW81.                                                    00440000
      *                                                                 00450000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00480000
       COPY CFDBW73.                                                    00490000
       01 FIOBW73                       PIC X(200).                     
      *                                                                 00510000
       COPY CFDBW81.                                                    00520000
       COPY FIOBW81.                                                    00530000
      *                                                                 00540000
       WORKING-STORAGE SECTION.                                         
      *                                                                 00560000
      *                                                                 00570000
       01  WS-WORK-AREA.                                                
           05 WS-PGRMNAME                  PIC X(08) VALUE              
              'PCSBW181'.                                               
           05 WS-CURR-DATE                 PIC X(10).                   
           05 WS-ST-WORKSET-COUNT          PIC 9(02).                   
A00775     05 WS-ST-CUST-COUNT             PIC 9(02).                   
A00775     05 WS-END-CUST-COUNT            PIC 9(02).                   
           05 WS-OPTICAL-RD-ORDER          PIC 9(04) VALUE 0.           
           05 WS-SPL-MSG-POS               PIC 9(04) VALUE 0.           
           05 WS-SPL-MSG-NEW-POS           PIC 9(04) VALUE 0.           
      *                                                                 00690000
       01  WS-COUNTERS.                                                 
           05 WS-COUNT-FCSBW81             PIC 9(09) VALUE 0.           
       01  WS-SWITCHES.                                                 
A00775     05 WS-PARSE-CUST-ARRAY-FL       PIC 9(01) VALUE 0.           
A00775        88 NOT-PARSE-CUST-ARRAY                VALUE 0.           
A00775        88 PARSE-CUST-ARRAY                    VALUE 1.           
           05 WS-PARSE-WORKSET-ARRAY-FL    PIC 9(01) VALUE 0.           
              88 NOT-PARSE-WORKSET-ARRAY             VALUE 0.           
              88 PARSE-WORKSET-ARRAY                 VALUE 1.           
A00775     05 WS-LOAD-CUST-ARRAY-FL        PIC 9(01) VALUE 0.           
A00775        88 NOT-LOAD-CUST-ARRAY                 VALUE 0.           
A00775        88 LOAD-CUST-ARRAY                     VALUE 1.           
           05 WS-LOAD-WORKSET-ARRAY-FL     PIC 9(01) VALUE 0.           
              88 NOT-LOAD-WORKSET-ARRAY              VALUE 0.           
              88 LOAD-WORKSET-ARRAY                  VALUE 1.           
           05 WS-MTR-SESSION-TYPE-FL       PIC 9(01) VALUE 0.           
              88 MTR-SESSION-NONE                    VALUE 0.           
              88 MTR-SESSION-MANUAL                  VALUE 1.           
              88 MTR-SESSION-RF                      VALUE 2.           
              88 MTR-SESSION-OPT                     VALUE 3.           
      *                                                                 00900000
           05 WS-USAGE-FLAG                PIC X(01)  VALUE 'Y'.        
              88 USAGE-NOT-FOUND                      VALUE 'N'.        
           05 WS-END-OF-ACCT               PIC X(01)  VALUE 'N'.        
           05 WS-FBW73-STATUS           PIC XX    VALUE '00'.           
              88 FBW73-SUCCESSFUL                 VALUE '00'.           
           05 WS-FBW81-STATUS           PIC XX    VALUE '00'.           
              88 FBW81-SUCCESSFUL                 VALUE '00'.           
           05 WS-DATABASE                  PIC 9(01)  VALUE  0.         
              88 CSR-DATABASE                         VALUE  1.         
              88 SEB-DATABASE                         VALUE  2.         
           05 WS-END-OF-FBW73-FILE        PIC X(01)   VALUE 'N'.        
               88  END-OF-FBW73                        VALUE 'Y'.       
           05 WS-WORKSET-EVE               PIC 9(01)   VALUE 0.         
               88  WORKSET-ENDED                       VALUE 0.         
               88  WORKSET-STARTED                     VALUE 1.         
           05 WS-CUSTOMER-EVE              PIC 9(01)   VALUE 0.         
               88  CUSTOMER-ENDED                      VALUE 0.         
               88  CUSTOMER-STARTED                    VALUE 1.         
           05 WS-METER-EVE                 PIC 9(01)   VALUE 0.         
               88  METER-ENDED                         VALUE 0.         
               88  METER-STARTED                       VALUE 1.         
           05 WS-METER-CHNG-EVE            PIC 9(01)   VALUE 0.         
               88  METER-CHNG-ENDED                    VALUE 0.         
               88  METER-CHNG-STARTED                  VALUE 1.         
           05 WS-MSIN-EVE                   PIC 9(01)   VALUE 0.        
               88  MSIN-ENDED                           VALUE 0.        
               88  MSIN-STARTED                         VALUE 1.        
           05 WS-MSIN-CHNG-EVE              PIC 9(01)   VALUE 0.        
               88  MSIN-CHNG-ENDED                      VALUE 0.        
               88  MSIN-CHNG-STARTED                    VALUE 1.        
           05 WS-MSIN-RF-EVE                   PIC 9(01)   VALUE 0.     
               88  MSIN-RF-ENDED                           VALUE 0.     
               88  MSIN-RF-STARTED                         VALUE 1.     
           05 WS-MSIN-OPT-EVE                  PIC 9(01)   VALUE 0.     
               88  MSIN-OPT-ENDED                          VALUE 0.     
               88  MSIN-OPT-STARTED                        VALUE 1.     
           05 WS-MSOUT-EVE                     PIC 9(01)   VALUE 0.     
               88  MSOUT-ENDED                             VALUE 0.     
               88  MSOUT-STARTED                           VALUE 1.     
           05 WS-MSOUT-RF-EVE                  PIC 9(01)   VALUE 0.     
               88  MSOUT-RF-ENDED                          VALUE 0.     
               88  MSOUT-RF-STARTED                        VALUE 1.     
           05 WS-MSOUT-OPT-EVE                 PIC 9(01)   VALUE 0.     
               88  MSOUT-OPT-ENDED                         VALUE 0.     
               88  MSOUT-OPT-STARTED                       VALUE 1.     
           05 WS-MSOUT-OPT-RIR-EVE             PIC 9(01)   VALUE 0.     
               88  MSOUT-OPT-RIR-ENDED                     VALUE 0.     
               88  MSOUT-OPT-RIR-STARTED                   VALUE 1.     
           05 WS-PREV-EVENT                PIC X(50)   VALUE SPACES.    
      *                                                                 01400000
       01  WS-HOLD-FIOBW81             PIC X(500)    VALUE SPACES.      
       01  WorkSet.                                                     
           05 WorkSetID                 PIC X(08).                      
           05 Cycle                     PIC X(02).                      
       01  Customer.                                                    
           05 AccountNumber             PIC 9(13).                      
           05 CompanyID                 PIC X(02).                      
       01 Meter.                                                        
          05 ServicePointID              PIC X(18).                     
          05 InstructionLocationCode1    PIC X(02).                     
          05 InstructionLocationCode2    PIC X(02).                     
          05 NewServiceFlag              PIC X(05) VALUE SPACES.        
             88 NewService-False         VALUE 'False' '     '.         
             88 NewService-True          VALUE 'True'.                  
          05 ChangeIndicator             PIC 9(01) VALUE 0.             
             88 MTRChangeIndicator-No    VALUE 0.                       
             88 MTRChangeIndicator-Edit  VALUE 1.                       
             88 MTRChangeIndicator-Yes   VALUE 2.                       
          05 UtilityMeterSequenceNumber  PIC 9(10).                     
          05 MeterNumber                 PIC X(14).                     
          05 MeterCategory               PIC 9(01) VALUE 0.             
             88 MeterCategory-Electric   VALUE 0.                       
             88 MeterCategory-Gas        VALUE 1.                       
             88 MeterCategory-NewSrv     VALUE 5.                       
          05 ActiveIndicator             PIC 9(01) VALUE 0.             
             88 ActiveIndicator-Active     VALUE 0.                     
             88 ActiveIndicator-Active     VALUE 1.                     
             88 ActiveIndicator-Seasonal   VALUE 2.                     
          05 SpecialMessage              PIC X(114).                    
          05 MeterCustomData.                                           
             10 WS-LOCAL-OFFICE          PIC X(03).                     
             10 WS-READ-ROUTE            PIC X(04).                     
             10 WS-READ-SEQ-REQ          PIC X(01).                     
             10 WS-MTR-READ-SOURCE-CD    PIC X(01).                     
             10 WS-RRI                   PIC X(01).                     
             10 WS-PGM-ID                PIC X(02).                     
             10 WS-DMT                   PIC X(03).                     
             10 FILLER                   PIC X(14).                     
          05 MeterChangedFields.                                        
             10 ChangedUtilityMeterSeqNum   PIC 9(09).                  
             10 ChangedMeterNumber          PIC X(09).                  
             10 ChangedInstructionLocCode1  PIC X(02).                  
             10 ChangedInstructionLocCode2  PIC X(02).                  
             10 SpecialMessageChangedFlag   PIC X(05) VALUE SPACES.     
                88 Spl-Msg-Changed-False    VALUE 'False' '     '.      
                88 Spl-Msg-Changed-True     VALUE 'True'.               
             10 ChangedSpecialMessage       PIC X(114).                 
             10 MTRChangeIndicators            PIC X(20).               
       01 MeterSessionInput.                                            
          05 NumberDials              PIC 9(02).                        
          05 NumberDecimals           PIC 9(02).                        
          05 ConstantMultiplier       PIC 9(06).                        
          05 ReadMethod               PIC 9(01) value 0.                
             88 ReadMethod-Keyed    VALUE 0.                            
             88 ReadMethod-Optical  VALUE 1.                            
             88 ReadMethod-Remote   VALUE 2.                            
             88 ReadMethod-Walk-by  VALUE 3.                            
             88 ReadMethod-Drive-by VALUE 4.                            
             88 ReadMethod-No-Read  VALUE 5.                            
             88 ReadMethod-EKA      VALUE 6.                            
          05 TextPrompt               PIC X(04).                        
          05 BestReadCode             PIC S9(04).                       
          05 MSICustomData.                                             
P00251       10 MSICD-CODE-USAGE-TYPE   PIC X(01).                      
             10 MSICD-TIME-PERIOD       PIC X(04).                      
             10 MSICD-CODE-TOU-SEASN    PIC X(01).                      
             10 MSICD-INDEX-VALUE-CD    PIC X(01).                      
             10 MSICD-CNSMPTN-READ-FL   PIC X(01).                      
P00251       10 MSICD-CODE-USAGE-ID     PIC X(01).                      
P00251       10 MSICD-CODE-USAGE-SOURCE PIC X(01).                      
P00251       10 FILLER                  PIC X(11).                      
          05 MSInputChangedFields.                                      
             10 ChangedReadMethod        PIC 9(01).                     
             10 ChangedNumberDials       PIC 9(02).                     
             10 ChangedNumberDecimals    PIC 9(02).                     
             10 MSIChangeIndicators      PIC X(20).                     
          05 MeterSessionInputRF.                                       
             10 EndpointID            PIC 9(12).                        
             10 ChangedEndpointID     PIC 9(12).                        
             10 EndpointType          PIC 9(02).                        
             10 TamperCount1          PIC 9(02).                        
             10 TamperCount2          PIC 9(02).                        
             10 SolidStateDemandIndicator PIC 9(01).                    
          05 MeterSessionInputOptical.                                  
             10 DeviceID              PIC X(09).                        
             10 TOUReadItemListID     PIC X(10).                        
       01 MeterSessionOutput.                                           
          05 READ-VALUE               PIC 9(10).                        
          05 ReadDateTime             PIC X(19).                        
          05 ReadCode                 PIC 9(02).                        
          05 ReadCondition            PIC 9(02).                        
          05 ForceCompleteReasonCode  PIC X(04).                        
          05 SkipCode                 PIC X(02).                        
          05 ReadFailureCount         PIC 9(02).                        
          05 ClearCount               PIC 9(04).                        
          05 TroubleCode1             PIC X(02).                        
          05 TroubleCode2             PIC X(02).                        
          05 TroubleMessage           PIC X(40).                        
          05 DataCollectorUserID      PIC X(09).                        
          05 MeterSessionOutputRF.                                      
             10 EndpointTypeReceived     PIC 9(02).                     
             10 ReadStatus               PIC 9(01).                     
             10 EndpointReadDateTime     PIC X(19).                     
             10 TamperCount1-NEW         PIC 9(02).                     
             10 TamperCount2-NEW         PIC 9(02).                     
             10 TamperCount1ChangedFlag  PIC X(05) VALUE '     '.       
                88 TAMPER-COUNT1-NOT-CHNGD   VALUE 'False' '     '.     
                88 TAMPER-COUNT1-CHNGD       VALUE 'True'.              
             10 TamperCount2ChangedFlag     PIC X(05) VALUE '     '.    
                88 TAMPER-COUNT2-NOT-CHNGD   VALUE 'False' '     '.     
                88 TAMPER-COUNT2-CHNGD       VALUE 'True'.              
             10 VisualReadFlag              PIC X(05) VALUE '     '.    
                88 NOT-VISUALLY-READ        VALUE 'False' '     '.      
                88 VISUALLY-READ            VALUE 'True'.               
             10 HitMissIndicator            PIC 9(04).                  
          05 MeterSessionOutputOptical.                                 
             10 LocalSetupReturnCode          PIC X(02).                
             10 OpenReturnCode                PIC X(02).                
             10 StatusCheckReturnCode         PIC X(02).                
             10 TOURegisterReadReturnCode     PIC X(02).                
             10 ResetDemandReturnCode         PIC X(02).                
       01 WS-RIR-TABLE.                                                 
          05 RIR-REC-COUNT                  PIC 9(03).                  
          05 RIR-SUB                        PIC 9(03).                  
          05 ReadItemResult OCCURS  50 TIMES.                           
             10 ReadType-RIR                  PIC X(02).                
             10 Read-RIR                      PIC 9(10).                
             10 ReadDateTime-RIR              PIC X(19).                
             10 ReadCode-RIR                  PIC 9(02).                
             10 ReadCondition-RIR             PIC 9(02).                
             10 SkipCode-RIR                  PIC X(02).                
             10 ActualReadOrder-RIR           PIC 9(09).                
             10 ReadFailureCount-RIR          PIC 9(04).                
             10 ClearCount-RIR                PIC 9(04).                
             10 TextPrompt-RIR                PIC X(04).                
      *                                                                 02760000
       01 WS-MTR-SESSION-TABLE.                                         
          05 WS-MSS-REC-COUNT               PIC 9(03).                  
          05 MSS-SUB                        PIC 9(03).                  
          05 WS-MSS-REC OCCURS  50 TIMES.                               
      ********* MeterSessionInput.                                      02810000
             10 WS-NUMBER-DIALS             PIC 9(02).                  
             10 WS-NUMBER-DECIMALS          PIC 9(02).                  
             10 WS-CONSTANT                 PIC 9(06).                  
             10 WS-READ-METHOD              PIC 9(01).                  
             10 WS-TEXT-PROMPT              PIC X(04).                  
             10 WS-BEST-READ-CODE           PIC S9(04).                 
P00251       10 WS-CODE-USAGE-TYPE          PIC X(01).                  
             10 WS-TIME-PERIOD              PIC 9(04).                  
             10 WS-CODE-TOU-SEASN           PIC X(01).                  
             10 WS-INDEX-VALUE-CD           PIC X(01).                  
             10 WS-CNSMPTN-READ-FL          PIC X(01).                  
P00251       10 WS-CODE-USAGE-ID            PIC X(01).                  
P00251       10 WS-CODE-USAGE-SOURCE        PIC X(01).                  
      ********* MSInputChangedFields.                                   02950000
             10 WS-CHNG-READ-METHOD         PIC 9(01).                  
             10 WS-CHNG-NUMBER-DIALS        PIC 9(02).                  
             10 WS-CHNG-NUMBER-DECIMALS     PIC 9(02).                  
             10 WS-CHNG-MSI-INDICATORS      PIC X(20).                  
      ********* MeterSessionInputRF.                                    03000000
             10 WS-ERT-ID                   PIC 9(12).                  
             10 WS-CHANGED-ERT-ID           PIC 9(12).                  
             10 WS-ERT-TYPE                 PIC 9(02).                  
             10 WS-TAMPER-COUNT1            PIC 9(02).                  
             10 WS-TAMPER-COUNT2            PIC 9(02).                  
             10 WS-ERT-SS-DEMAND-IND        PIC 9(01).                  
      ********* MeterSessionInputOptical.                               03070000
             10 TOU-RIL-ID                  PIC X(10).                  
      ********* MeterSessionOutput.                                     03090000
             10 WS-READ                        PIC 9(10).               
             10 WS-READ-DATETIME               PIC X(19).               
             10 WS-READ-CODE                   PIC 9(02).               
             10 WS-READ-CONDITION              PIC 9(02).               
             10 WS-FC-REASON-CODE              PIC X(04).               
             10 WS-SKIP-CODE                   PIC X(02).               
             10 WS-READ-FIAL-COUNT             PIC 9(02).               
             10 WS-CLEAR-COUNT                 PIC 9(04).               
             10 WS-TROUBLE-CODE1               PIC X(02).               
             10 WS-TROUBLE-CODE2               PIC X(02).               
             10 WS-TROUBLE-MESG                PIC X(40).               
             10 WS-DC-USER-ID                  PIC X(09).               
      ********* MeterSessionOutputRF.                                   03220000
             10 WS-ERT-TYPE-RECEIVED           PIC 9(02).               
             10 WS-READ-STATUS                 PIC 9(01).               
             10 WS-ERT-READ-DATETIME           PIC X(19).               
             10 WS-TAMPER-COUNT1-NEW           PIC 9(02).               
             10 WS-TAMPER-COUNT2-NEW           PIC 9(02).               
             10 WS-TAMPER-CD1-CHNG-FL       PIC X(01) VALUE ' '.        
             10 WS-TAMPER-CD2-CHNG-FL       PIC X(01) VALUE ' '.        
             10 WS-VISUAL-READ-FL              PIC X(01) VALUE ' '.     
             10 WS-HIT-MISS-IND                PIC 9(04).               
      ********* MeterSessionOutputOptical.                              03320000
             10 WS-LOCAL-SETUP-RC                PIC X(02).             
             10 WS-OPEN-RC                       PIC X(02).             
             10 WS-STATUS-CHECK-RC               PIC X(02).             
             10 WS-TOU-REG-READ-RC               PIC X(02).             
             10 WS-RESET-DEMAND-RC               PIC X(02).             
      ********* ReadItemResult.                                         03380000
             10 WS-ACTUAL-RD-ORD-RIR             PIC 9(04).             
             10 WS-TEXT-PROMPT-RIR               PIC X(04).             
      *                                                                 03410000
A00775 01  WS-CUSTOMER-ARRAY.                                           
A00775     05 WS-CUST-STRING            OCCURS 5000 TIMES               
                                           PIC X(200).                  
      *                                                                 03450000
       01  WS-WORKSET-ARRAY.                                            
           05 WS-WORKSET-STRING         OCCURS 100 TIMES                
                                          PIC X(200).                   
      *                                                                 03490000
       01  SUB1                         PIC 9(4) VALUE 0.               
       01  SUB2                         PIC 9(4) VALUE 0.               
       01  WS-BW73-REC                  PIC X(200).                     
       01  WS-XML-RCODE                 PIC ------------9.              
      *                                                                 03540000
      **                                                                03550000
      ***************************************************************** 03560000
       PROCEDURE DIVISION.                                              
      ***************************************************************** 03580000
      *                                                                 03590000
      *================================================================*03600000
       0000-MAINLINE.                                                   
      *================================================================*03620000
      * MAIN PROCESS                                                   *03630000
      *                                                                 03640000
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                 03660000
           PERFORM 1000-PROCESS-XML    THRU 1000-EXIT                   
                                   UNTIL END-OF-FBW73.                  
      *                                                                 03690000
           PERFORM 9000-TERMINATE      THRU 9000-EXIT.                  
      *                                                                 03710000
           STOP RUN.                                                    
      *                                                                 03730000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03760000
      *================================================================*03770000
       0100-INITIALIZATION.                                             
      *================================================================*03790000
      *                                                                 03800000
           DISPLAY '***************************************'            
           DISPLAY '** DATE COMPILED:' FUNCTION WHEN-COMPILED.          
           DISPLAY '***************************************'            
      *                                                                 03840000
           OPEN INPUT FCSBW73-FILE.                                     
      *                                                                 03860000
           IF  Fbw73-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY 'FILE OPEN ERROR'                                
               DISPLAY 'FCSBW73 FILE STATUS ==>' WS-FBW73-STATUS        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
               DISPLAY '*******************************************'    
           END-IF                                                       
      *                                                                 03960000
           OPEN OUTPUT FCSBW81-FILE.                                    
      *                                                                 03980000
           IF  FBW81-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY 'FILE OPEN ERROR'                                
               DISPLAY 'FCSBW81 FILE STATUS ==>' WS-FBW81-STATUS        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
               DISPLAY '*******************************************'    
           END-IF.                                                      
      *                                                                 04080000
A00775     INITIALIZE  WS-CUSTOMER-ARRAY                                
                       WS-WORKSET-ARRAY.                                
           MOVE ZEROS                  TO SUB1                          
                                          SUB2.                         
           PERFORM 5000-GET-XML-REC   THRU 5000-EXIT.                   
      *                                                                 04140000
       0100-EXIT.                                                       
           EXIT.                                                        
      *================================================================*04170000
       1000-PROCESS-XML.                                                
      *================================================================*04190000
      *                                                                 04200000
           EVALUATE TRUE                                                
A00775        WHEN LOAD-CUST-ARRAY                                      
                   COMPUTE SUB1  = SUB1 + 1                             
A00775             MOVE WS-BW73-REC    TO WS-CUST-STRING (SUB1)         
                   IF PARSE-WORKSET-ARRAY                               
                      COMPUTE SUB2  = SUB2 + 1                          
A00775                MOVE '</Work>'      TO WS-WORKSET-STRING (SUB2)   
A00775                COMPUTE SUB2  = SUB2 + 1                          
                      MOVE '</WorkSet>'   TO WS-WORKSET-STRING (SUB2)   
                      XML PARSE WS-WORKSET-ARRAY PROCESSING             
                          PROCEDURE 1100-PROCESS-XML                    
                      SET NOT-LOAD-WORKSET-ARRAY       TO  TRUE         
                      MOVE ZEROS                  TO SUB2               
                      INITIALIZE  WS-WORKSET-ARRAY                      
                   END-IF                                               
A00775        WHEN PARSE-CUST-ARRAY                                     
                   COMPUTE SUB1  = SUB1 + 1                             
A00775             MOVE '</Customer>'    TO WS-CUST-STRING (SUB1)       
      *                                                                 04370000
A00775             XML PARSE WS-CUSTOMER-ARRAY PROCESSING               
                       PROCEDURE 1100-PROCESS-XML                       
A00775             SET NOT-LOAD-CUST-ARRAY          TO  TRUE            
                   MOVE ZEROS                  TO SUB1                  
A00775             INITIALIZE WS-CUSTOMER-ARRAY                         
              WHEN LOAD-WORKSET-ARRAY                                   
                   COMPUTE SUB2  = SUB2 + 1                             
                   MOVE WS-BW73-REC    TO WS-WORKSET-STRING (SUB2)      
              WHEN PARSE-WORKSET-ARRAY                                  
                   COMPUTE SUB2  = SUB2 + 1                             
A00775             MOVE '</Work>'      TO WS-WORKSET-STRING (SUB2)      
A00775             COMPUTE SUB2  = SUB2 + 1                             
A00775             MOVE '</WorkSet>'   TO WS-WORKSET-STRING (SUB2)      
                   XML PARSE WS-WORKSET-ARRAY PROCESSING                
                       PROCEDURE 1100-PROCESS-XML                       
                   SET NOT-LOAD-WORKSET-ARRAY       TO  TRUE            
                   MOVE ZEROS                       TO SUB2             
                   INITIALIZE  WS-WORKSET-ARRAY                         
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE                                                 
                                                                        
           PERFORM 5000-GET-XML-REC   THRU 5000-EXIT                    
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
      *================================================================*04620000
       1100-PROCESS-XML.                                                
      *================================================================*04640000
      *                                                                 04650000
           MOVE XML-CODE     TO WS-XML-RCODE                            
           IF XML-CODE NOT = 0                                          
              DISPLAY '********************************************'    
              DISPLAY 'XML-EVENT   :' XML-EVENT                         
              DISPLAY 'XML-TEXT    :' XML-TEXT                          
              DISPLAY 'XML-CODE    :' WS-XML-RCODE                      
              DISPLAY '********************************************'    
           END-IF.                                                      
      *                                                                 04740000
           EVALUATE XML-EVENT                                           
              WHEN 'START-OF-ELEMENT'                                   
                 MOVE XML-TEXT TO WS-PREV-EVENT                         
                 PERFORM 1120-SET-ELEMENT-START    THRU 1120-EXIT       
              WHEN 'END-OF-ELEMENT'                                     
                 PERFORM 1140-SET-ELEMENT-END      THRU 1140-EXIT       
              WHEN 'CONTENT-CHARACTERS'                                 
                   IF XML-TEXT > SPACES                                 
                      PERFORM 2000-PEOCESS-EACH-ENTITY THRU 2000-EXIT   
                   END-IF                                               
              WHEN 'CONTENT-CHARACTER'                                  
                   PERFORM 5100-HANDLE-SPL-CHARS  THRU 5100-EXIT        
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 04900000
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04930000
      *================================================================*04940000
       1120-SET-ELEMENT-START.                                          
      *================================================================*04960000
      *                                                                 04970000
           EVALUATE XML-TEXT                                            
             WHEN 'Customer'                                            
               INITIALIZE Customer                                      
               SET CUSTOMER-STARTED    TO TRUE                          
             WHEN 'Meter'                                               
               SET METER-STARTED       TO TRUE                          
               SET MTR-SESSION-NONE    TO TRUE                          
               MOVE +1                 TO WS-SPL-MSG-POS                
                                          WS-SPL-MSG-NEW-POS            
               INITIALIZE WS-MTR-SESSION-TABLE                          
                          Meter                                         
             WHEN 'MeterChangedFields'                                  
               SET METER-CHNG-STARTED  TO TRUE                          
             WHEN 'MeterSessionInput'                                   
               SET MSIN-STARTED        TO TRUE                          
A00775         SET MTR-SESSION-NONE    TO TRUE                          
               INITIALIZE MeterSessionInput                             
                          MeterSessionOutput                            
             WHEN 'MeterSessionInputChangedFields'                      
               SET MSIN-CHNG-STARTED      TO TRUE                       
             WHEN 'MeterSessionInputRF'                                 
               SET MSIN-RF-STARTED        TO TRUE                       
             WHEN 'MeterSessionInputOptical'                            
               SET MSIN-OPT-STARTED        TO TRUE                      
             WHEN 'MeterSessionOutput'                                  
               SET MSOUT-STARTED        TO TRUE                         
               SET MTR-SESSION-MANUAL   TO TRUE                         
             WHEN 'MeterSessionOutputRF'                                
               SET MSOUT-RF-STARTED        TO TRUE                      
               SET MTR-SESSION-RF          TO TRUE                      
             WHEN 'MeterSessionOutputOptical'                           
               SET MSOUT-OPT-STARTED        TO TRUE                     
               SET MTR-SESSION-OPT          TO TRUE                     
               INITIALIZE WS-RIR-TABLE                                  
             WHEN 'ReadItemResult'                                      
               SET MSOUT-OPT-RIR-STARTED    TO TRUE                     
               COMPUTE RIR-SUB = RIR-SUB + 1                            
             WHEN 'WorkSet'                                             
               MOVE SPACES             TO WorkSet                       
               SET WORKSET-STARTED     TO TRUE                          
             WHEN OTHER                                                 
               CONTINUE                                                 
           END-EVALUATE.                                                
      *                                                                 05410000
       1120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05440000
      *================================================================*05450000
       1140-SET-ELEMENT-END.                                            
      *================================================================*05470000
      *                                                                 05480000
           EVALUATE XML-TEXT                                            
             WHEN 'Customer'                                            
               SET CUSTOMER-ENDED      TO TRUE                          
A00775         PERFORM 3600-FORMAT-BW81     THRU 3600-EXIT              
             WHEN 'Meter'                                               
               SET METER-ENDED       TO TRUE                            
             WHEN 'MeterChangedFields'                                  
               SET METER-CHNG-ENDED  TO TRUE                            
             WHEN 'MeterSessionInput'                                   
               SET MSIN-ENDED        TO TRUE                            
               PERFORM 3500-LOAD-MSS-ARRAY  THRU 3500-EXIT              
             WHEN 'MeterSessionInputChangedFields'                      
               SET MSIN-CHNG-ENDED        TO TRUE                       
             WHEN 'MeterSessionInputRF'                                 
               SET MSIN-RF-ENDED        TO TRUE                         
             WHEN 'MeterSessionInputOptical'                            
               SET MSIN-OPT-ENDED        TO TRUE                        
             WHEN 'MeterSessionOutput'                                  
               SET MSOUT-ENDED        TO TRUE                           
             WHEN 'MeterSessionOutputRF'                                
               SET MSOUT-RF-ENDED        TO TRUE                        
             WHEN 'MeterSessionOutputOptical'                           
               SET MSOUT-OPT-ENDED        TO TRUE                       
             WHEN 'ReadItemResult'                                      
               SET MSOUT-OPT-RIR-ENDED    TO TRUE                       
             WHEN 'WorkSet'                                             
               SET WORKSET-ENDED     TO TRUE                            
             WHEN OTHER                                                 
               CONTINUE                                                 
           END-EVALUATE.                                                
      *                                                                 05790000
       1140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05820000
      *================================================================*05830000
       2000-PEOCESS-EACH-ENTITY.                                        
      *================================================================*05850000
      *                                                                 05860000
           EVALUATE TRUE                                                
              WHEN METER-CHNG-STARTED                                   
                   PERFORM 2100-MTR-CHNG-ENTITY   THRU 2100-EXIT        
              WHEN MSIN-STARTED                                         
                   PERFORM 2200-MTR-SESSION-INPUT THRU 2200-EXIT        
              WHEN METER-STARTED                                        
                   PERFORM 2300-METER-ENTITY      THRU 2300-EXIT        
              WHEN CUSTOMER-STARTED                                     
                   PERFORM 2400-CUSTOMER-ENTITY   THRU 2400-EXIT        
              WHEN WORKSET-STARTED                                      
                   PERFORM 2500-WORKSET-ENTITY    THRU 2500-EXIT        
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 06010000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06040000
      *================================================================*06050000
       2100-MTR-CHNG-ENTITY.                                            
      *================================================================*06070000
      *                                                                 06080000
           EVALUATE TRUE                                                
              WHEN WS-PREV-EVENT = 'ChangedUtilityMeterSeqNum'          
                   IF XML-TEXT IS NUMERIC                               
                      MOVE XML-TEXT  TO ChangedUtilityMeterSeqNum       
                   ELSE                                                 
                      MOVE ZEROS     TO ChangedUtilityMeterSeqNum       
                   END-IF                                               
              WHEN WS-PREV-EVENT = 'ChangedMeterNumber'                 
                   MOVE XML-TEXT   TO  ChangedMeterNumber               
              WHEN WS-PREV-EVENT = 'ChangedInstructionLocCode1'         
                   MOVE XML-TEXT   TO  ChangedInstructionLocCode1       
              WHEN WS-PREV-EVENT = 'ChangedInstructionLocCode2'         
                   MOVE XML-TEXT   TO  ChangedInstructionLocCode2       
              WHEN WS-PREV-EVENT = 'SpecialMessageChangedFlag'          
                   MOVE XML-TEXT   TO  SpecialMessageChangedFlag        
              WHEN WS-PREV-EVENT = 'ChangeIndicators'                   
                   MOVE XML-TEXT   TO  MTRChangeIndicators              
              WHEN WS-PREV-EVENT = 'ChangedSpecialMessage'              
                   STRING XML-TEXT DELIMITED BY SIZE                    
                       INTO ChangedSpecialMessage                       
                       WITH POINTER WS-SPL-MSG-NEW-POS                  
              WHEN OTHER                                                
                   CONTINUE                                             
              END-EVALUATE                                              
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06360000
      *================================================================*06370000
       2200-MTR-SESSION-INPUT.                                          
      *================================================================*06390000
      *                                                                 06400000
           EVALUATE TRUE                                                
              WHEN MSOUT-STARTED                                        
                   PERFORM 3000-MTR-SESSION-OUTPUT THRU 3000-EXIT       
              WHEN MSIN-RF-STARTED                                      
                   PERFORM 2210-MSIN-RF-ENTITY     THRU 2210-EXIT       
              WHEN MSIN-OPT-STARTED                                     
                   PERFORM 2220-MSIN-OPT-ENTITY    THRU 2220-EXIT       
              WHEN MSIN-CHNG-STARTED                                    
                   PERFORM 2230-MSIN-CHNG-ENTITY   THRU 2230-EXIT       
              WHEN WS-PREV-EVENT = 'ReadMethod'                         
                   MOVE XML-TEXT   TO  ReadMethod                       
              WHEN WS-PREV-EVENT = 'TextPrompt'                         
                   MOVE XML-TEXT   TO  TextPrompt                       
              WHEN WS-PREV-EVENT = 'NumberDials'                        
                   MOVE XML-TEXT   TO  NumberDials                      
              WHEN WS-PREV-EVENT = 'NumberDecimals'                     
                   MOVE XML-TEXT   TO  NumberDecimals                   
              WHEN WS-PREV-EVENT = 'ConstantMultiplier'                 
                   MOVE XML-TEXT   TO  ConstantMultiplier               
              WHEN WS-PREV-EVENT = 'BestReadCode'                       
                   MOVE XML-TEXT   TO  BestReadCode                     
              WHEN WS-PREV-EVENT = 'CustomData'                         
                   MOVE XML-TEXT   TO  MSICustomData                    
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 06670000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06700000
      *================================================================*06710000
       2210-MSIN-RF-ENTITY.                                             
      *================================================================*06730000
      *                                                                 06740000
           EVALUATE TRUE                                                
              WHEN WS-PREV-EVENT = 'EndpointID'                         
                   MOVE XML-TEXT   TO  EndpointID                       
              WHEN WS-PREV-EVENT = 'ChangedEndpointID'                  
                   MOVE XML-TEXT   TO  ChangedEndpointID                
              WHEN WS-PREV-EVENT = 'EndpointType'                       
                   MOVE XML-TEXT   TO  EndpointType                     
              WHEN WS-PREV-EVENT = 'TamperCount1'                       
                   MOVE XML-TEXT   TO  TamperCount1                     
              WHEN WS-PREV-EVENT = 'TamperCount2'                       
                   MOVE XML-TEXT   TO  TamperCount2                     
              WHEN WS-PREV-EVENT = 'SolidStateDemandIndicator'          
                   MOVE XML-TEXT   TO  SolidStateDemandIndicator        
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 06910000
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06940000
      *================================================================*06950000
       2220-MSIN-OPT-ENTITY.                                            
      *================================================================*06970000
      *                                                                 06980000
           EVALUATE TRUE                                                
              WHEN WS-PREV-EVENT = 'DeviceID'                           
                   MOVE XML-TEXT   TO  DeviceID                         
              WHEN WS-PREV-EVENT = 'TOUReadItemListID'                  
                   MOVE XML-TEXT   TO  TOUReadItemListID                
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 07070000
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07100000
      *================================================================*07110000
       2230-MSIN-CHNG-ENTITY.                                           
      *================================================================*07130000
      *                                                                 07140000
           EVALUATE TRUE                                                
              WHEN WS-PREV-EVENT = 'ChangedReadMethod'                  
                   MOVE XML-TEXT   TO  ChangedReadMethod                
              WHEN WS-PREV-EVENT = 'ChangedNumberDials'                 
                   MOVE XML-TEXT   TO  ChangedNumberDials               
              WHEN WS-PREV-EVENT = 'ChangedNumberDecimals'              
                   MOVE XML-TEXT   TO  ChangedNumberDecimals            
              WHEN WS-PREV-EVENT = 'ChangeIndicators'                   
                   MOVE XML-TEXT   TO  MSIChangeIndicators              
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 07270000
       2230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07300000
      *================================================================*07310000
       2300-METER-ENTITY.                                               
      *================================================================*07330000
      *                                                                 07340000
           EVALUATE TRUE                                                
              WHEN WS-PREV-EVENT = 'MeterNumber'                        
                   MOVE XML-TEXT   TO  MeterNumber                      
              WHEN WS-PREV-EVENT = 'ServicePointID'                     
                   MOVE XML-TEXT   TO  ServicePointID                   
              WHEN WS-PREV-EVENT = 'InstructionLocationCode1'           
                   MOVE XML-TEXT   TO  InstructionLocationCode1         
              WHEN WS-PREV-EVENT = 'InstructionLocationCode2'           
                   MOVE XML-TEXT   TO  InstructionLocationCode2         
              WHEN WS-PREV-EVENT = 'UtilityMeterSequenceNumber'         
                   MOVE XML-TEXT   TO  UtilityMeterSequenceNumber       
              WHEN WS-PREV-EVENT = 'ChangeIndicator'                    
                   MOVE XML-TEXT   TO  ChangeIndicator                  
              WHEN WS-PREV-EVENT = 'NewServiceFlag'                     
                   MOVE XML-TEXT   TO  NewServiceFlag                   
              WHEN WS-PREV-EVENT = 'MeterCategory'                      
                   MOVE XML-TEXT   TO  MeterCategory                    
              WHEN WS-PREV-EVENT = 'CustomData'                         
                   MOVE XML-TEXT   TO  MeterCustomData                  
              WHEN WS-PREV-EVENT = 'SpecialMessage'                     
                   STRING XML-TEXT DELIMITED BY SIZE                    
                        INTO SpecialMessage                             
                        WITH POINTER WS-SPL-MSG-POS                     
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 07610000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07640000
      *================================================================*07650000
       2400-CUSTOMER-ENTITY.                                            
      *================================================================*07670000
      *                                                                 07680000
           EVALUATE TRUE                                                
              WHEN WS-PREV-EVENT = 'AccountNumber'                      
                   IF XML-TEXT IS NUMERIC                               
                      MOVE XML-TEXT   TO AccountNumber                  
                   ELSE                                                 
                      MOVE 1          TO AccountNumber                  
                   END-IF                                               
              WHEN WS-PREV-EVENT = 'CompanyID'                          
                   MOVE XML-TEXT   TO  CompanyID                        
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 07810000
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07840000
      *================================================================*07850000
       2500-WORKSET-ENTITY.                                             
      *================================================================*07870000
      *                                                                 07880000
           EVALUATE TRUE                                                
              WHEN WS-PREV-EVENT = 'WorkSetID'                          
                   MOVE XML-TEXT   TO WorkSetID                         
              WHEN WS-PREV-EVENT = 'Cycle'                              
                   MOVE XML-TEXT   TO Cycle                             
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 07970000
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08000000
      *================================================================*08010000
       3000-MTR-SESSION-OUTPUT.                                         
      *================================================================*08030000
      *                                                                 08040000
           EVALUATE TRUE                                                
              WHEN MSOUT-RF-STARTED                                     
                   PERFORM 3100-MSOUT-RF-ENTITY  THRU 3100-EXIT         
              WHEN MSOUT-OPT-STARTED                                    
                   PERFORM 3200-MSOUT-OPT-ENTITY THRU 3200-EXIT         
              WHEN WS-PREV-EVENT = 'Read'                               
                   IF XML-TEXT IS NUMERIC                               
                      MOVE XML-TEXT   TO  READ-VALUE                    
                   ELSE                                                 
                      MOVE ZEROS      TO  READ-VALUE                    
                   END-IF                                               
              WHEN WS-PREV-EVENT = 'ReadDateTime'                       
                   MOVE XML-TEXT   TO  ReadDateTime                     
              WHEN WS-PREV-EVENT = 'ReadCode'                           
                   MOVE XML-TEXT   TO  ReadCode                         
              WHEN WS-PREV-EVENT = 'ReadCondition'                      
                   MOVE XML-TEXT   TO  ReadCondition                    
              WHEN WS-PREV-EVENT = 'ForceCompleteReasonCode'            
                   MOVE XML-TEXT   TO  ForceCompleteReasonCode          
              WHEN WS-PREV-EVENT = 'SkipCode'                           
                   MOVE XML-TEXT   TO  SkipCode                         
              WHEN WS-PREV-EVENT = 'ReadFailureCount'                   
                   MOVE XML-TEXT   TO  ReadFailureCount                 
              WHEN WS-PREV-EVENT = 'ClearCount'                         
                   MOVE XML-TEXT   TO  ClearCount                       
              WHEN WS-PREV-EVENT = 'TroubleCode1'                       
                   MOVE XML-TEXT   TO  TroubleCode1                     
              WHEN WS-PREV-EVENT = 'TroubleCode2'                       
                   MOVE XML-TEXT   TO  TroubleCode2                     
              WHEN WS-PREV-EVENT = 'TroubleMessage'                     
                   MOVE XML-TEXT   TO  TroubleMessage                   
              WHEN WS-PREV-EVENT = 'DataCollectorUserID'                
                   MOVE XML-TEXT   TO  DataCollectorUserID              
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 08410000
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08440000
      *================================================================*08450000
       3100-MSOUT-RF-ENTITY.                                            
      *================================================================*08470000
      *                                                                 08480000
           EVALUATE TRUE                                                
              WHEN WS-PREV-EVENT = 'EndpointTypeReceived'               
                   MOVE XML-TEXT   TO  EndpointTypeReceived             
              WHEN WS-PREV-EVENT = 'ReadStatus'                         
                   MOVE XML-TEXT   TO  ReadStatus                       
              WHEN WS-PREV-EVENT = 'EndpointReadDateTime'               
                   MOVE XML-TEXT   TO  EndpointReadDateTime             
              WHEN WS-PREV-EVENT = 'TamperCount1'                       
                   MOVE XML-TEXT   TO  TamperCount1-NEW                 
              WHEN WS-PREV-EVENT = 'TamperCount2'                       
                   MOVE XML-TEXT   TO  TamperCount2-NEW                 
              WHEN WS-PREV-EVENT = 'TamperCount1ChangedFlag'            
                   MOVE XML-TEXT   TO  TamperCount1ChangedFlag          
              WHEN WS-PREV-EVENT = 'TamperCount2ChangedFlag'            
                   MOVE XML-TEXT   TO  TamperCount2ChangedFlag          
              WHEN WS-PREV-EVENT = 'VisualReadFlag'                     
                   MOVE XML-TEXT   TO  VisualReadFlag                   
              WHEN WS-PREV-EVENT = 'HitMissIndicator'                   
                   MOVE XML-TEXT   TO  HitMissIndicator                 
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 08710000
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08740000
      *================================================================*08750000
       3200-MSOUT-OPT-ENTITY.                                           
      *================================================================*08770000
      *                                                                 08780000
           EVALUATE TRUE                                                
              WHEN MSOUT-OPT-RIR-STARTED                                
                   PERFORM 3210-MSOUT-OPT-RIR    THRU 3210-EXIT         
              WHEN WS-PREV-EVENT = 'LocalSetupReturnCode'               
                   MOVE XML-TEXT   TO  LocalSetupReturnCode             
              WHEN WS-PREV-EVENT = 'OpenReturnCode'                     
                   MOVE XML-TEXT   TO  OpenReturnCode                   
              WHEN WS-PREV-EVENT = 'StatusCheckReturnCode'              
                   MOVE XML-TEXT   TO  StatusCheckReturnCode            
              WHEN WS-PREV-EVENT = 'TOURegisterReadReturnCode'          
                   MOVE XML-TEXT   TO  TOURegisterReadReturnCode        
              WHEN WS-PREV-EVENT = 'ResetDemandReturnCode'              
                   MOVE XML-TEXT   TO  ResetDemandReturnCode            
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 08950000
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08980000
      *================================================================*08990000
       3210-MSOUT-OPT-RIR.                                              
      *================================================================*09010000
      *                                                                 09020000
           EVALUATE TRUE                                                
              WHEN WS-PREV-EVENT = 'ReadType'                           
                   MOVE XML-TEXT   TO  ReadType-RIR (RIR-SUB)           
              WHEN WS-PREV-EVENT = 'Read'                               
                   IF XML-TEXT IS NUMERIC                               
                      MOVE XML-TEXT   TO  Read-RIR (RIR-SUB)            
                   ELSE                                                 
                      MOVE ZEROS      TO  Read-RIR (RIR-SUB)            
                   END-IF                                               
              WHEN WS-PREV-EVENT = 'ReadDateTime'                       
                   MOVE XML-TEXT   TO  ReadDateTime-RIR (RIR-SUB)       
              WHEN WS-PREV-EVENT = 'ReadCode'                           
                   MOVE XML-TEXT   TO  ReadCode-RIR (RIR-SUB)           
              WHEN WS-PREV-EVENT = 'ReadCondition'                      
                   MOVE XML-TEXT   TO  ReadCondition-RIR (RIR-SUB)      
              WHEN WS-PREV-EVENT = 'SkipCode'                           
                   MOVE XML-TEXT   TO  SkipCode-RIR (RIR-SUB)           
              WHEN WS-PREV-EVENT = 'ActualReadOrder'                    
                   MOVE XML-TEXT   TO  ActualReadOrder-RIR (RIR-SUB)    
              WHEN WS-PREV-EVENT = 'ReadFailureCount'                   
                   MOVE XML-TEXT   TO  ReadFailureCount-RIR (RIR-SUB)   
              WHEN WS-PREV-EVENT = 'ClearCount'                         
                   MOVE XML-TEXT   TO  ClearCount-RIR (RIR-SUB)         
              WHEN WS-PREV-EVENT = 'TextPrompt'                         
                   IF XML-TEXT IS NUMERIC                               
                      MOVE XML-TEXT   TO WS-OPTICAL-RD-ORDER            
                      MOVE WS-OPTICAL-RD-ORDER                          
                                      TO TextPrompt-RIR (RIR-SUB)       
                   ELSE                                                 
                      MOVE XML-TEXT   TO TextPrompt-RIR (RIR-SUB)       
                   END-IF                                               
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 09370000
       3210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09400000
      *================================================================*09410000
       3500-LOAD-MSS-ARRAY.                                             
      *================================================================*09430000
      *                                                                 09440000
           EVALUATE TRUE                                                
             WHEN MTR-SESSION-MANUAL                                    
                  PERFORM 3510-LOAD-MSS-MANUAL  THRU 3510-EXIT          
             WHEN MTR-SESSION-RF                                        
                  PERFORM 3520-LOAD-MSS-RF      THRU 3520-EXIT          
             WHEN MTR-SESSION-OPT                                       
                  PERFORM 3530-LOAD-MSS-OPT     THRU 3530-EXIT          
             WHEN MTR-SESSION-NONE                                      
A00775            DISPLAY 'NO MTR SESSION OUTPUT:' AccountNumber        
A00775                                         '|' MeterNumber          
A00775****        PERFORM 3540-LOAD-MSS-DEFAULT THRU 3540-EXIT          09531013
             WHEN OTHER                                                 
                  CONTINUE                                              
           END-EVALUATE.                                                
      *                                                                 09570000
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09600000
      *================================================================*09610000
       3510-LOAD-MSS-MANUAL.                                            
      *================================================================*09630000
      *                                                                 09640000
           COMPUTE MSS-SUB = MSS-SUB + 1                                
           MOVE NumberDials          TO WS-NUMBER-DIALS    (MSS-SUB)    
           MOVE NumberDecimals       TO WS-NUMBER-DECIMALS (MSS-SUB)    
           MOVE ConstantMultiplier   TO WS-CONSTANT        (MSS-SUB)    
           MOVE ReadMethod           TO WS-READ-METHOD    (MSS-SUB)     
           MOVE TextPrompt           TO WS-TEXT-PROMPT    (MSS-SUB)     
           MOVE BestReadCode         TO WS-BEST-READ-CODE (MSS-SUB)     
P00251     MOVE MSICD-CODE-USAGE-TYPE TO WS-CODE-USAGE-TYPE (MSS-SUB)   
P00251     MOVE MSICD-CODE-USAGE-ID   TO WS-CODE-USAGE-ID   (MSS-SUB)   
P00251     MOVE MSICD-CODE-USAGE-SOURCE TO WS-CODE-USAGE-SOURCE(MSS-SUB)
           IF MSICD-TIME-PERIOD IS NUMERIC                              
              MOVE MSICD-TIME-PERIOD TO WS-TIME-PERIOD    (MSS-SUB)     
           ELSE                                                         
              MOVE ZEROS             TO WS-TIME-PERIOD    (MSS-SUB)     
           END-IF                                                       
           MOVE MSICD-CODE-TOU-SEASN TO WS-CODE-TOU-SEASN (MSS-SUB)     
           MOVE MSICD-INDEX-VALUE-CD TO WS-INDEX-VALUE-CD (MSS-SUB)     
           MOVE MSICD-CNSMPTN-READ-FL TO WS-CNSMPTN-READ-FL (MSS-SUB)   
      ****** MeterSessionInputChangedFields.                            09830000
           MOVE ChangedReadMethod     TO WS-CHNG-READ-METHOD (MSS-SUB)  
           MOVE ChangedNumberDials    TO WS-CHNG-NUMBER-DIALS(MSS-SUB)  
           MOVE ChangedNumberDecimals TO WS-CHNG-NUMBER-DECIMALS        
                                                            (MSS-SUB)   
           MOVE MSIChangeIndicators   TO WS-CHNG-MSI-INDICATORS(MSS-SUB)
      *                                                                 09890000
      ****** MeterSessionInputRF.                                       09900000
           MOVE ZEROS                TO WS-ERT-ID         (MSS-SUB)     
                                        WS-CHANGED-ERT-ID (MSS-SUB)     
                                        WS-ERT-TYPE       (MSS-SUB)     
                                        WS-TAMPER-COUNT1  (MSS-SUB)     
                                        WS-TAMPER-COUNT2  (MSS-SUB)     
                                        WS-ERT-SS-DEMAND-IND(MSS-SUB)   
      ****** MeterSessionInputOptical.                                  09970000
           MOVE SPACES               TO TOU-RIL-ID (MSS-SUB)            
      ****MeterSessionOutput.                                           09990000
           MOVE READ-VALUE           TO WS-READ    (MSS-SUB)            
           MOVE ReadDateTime         TO WS-READ-DATETIME (MSS-SUB)      
           MOVE ReadCode             TO WS-READ-CODE     (MSS-SUB)      
           MOVE ReadCondition        TO WS-READ-CONDITION(MSS-SUB)      
           MOVE ForceCompleteReasonCode TO WS-FC-REASON-CODE(MSS-SUB)   
           MOVE SkipCode             TO WS-SKIP-CODE  (MSS-SUB)         
           MOVE ReadFailureCount     TO WS-READ-FIAL-COUNT (MSS-SUB)    
           MOVE TroubleCode1         TO WS-TROUBLE-CODE1 (MSS-SUB)      
           MOVE TroubleCode2         TO WS-TROUBLE-CODE2 (MSS-SUB)      
           MOVE TroubleMessage       TO WS-TROUBLE-MESG  (MSS-SUB)      
           MOVE DataCollectorUserID  TO WS-DC-USER-ID  (MSS-SUB)        
      ****** MeterSessionOutputRF.                                      10110000
           MOVE ZEROS              TO WS-ERT-TYPE-RECEIVED(MSS-SUB)     
                                      WS-READ-STATUS      (MSS-SUB)     
                                      WS-TAMPER-COUNT1-NEW(MSS-SUB)     
                                      WS-TAMPER-COUNT2-NEW(MSS-SUB)     
                                      WS-HIT-MISS-IND   (MSS-SUB).      
           MOVE SPACES             TO WS-ERT-READ-DATETIME(MSS-SUB)     
                                      WS-TAMPER-CD1-CHNG-FL (MSS-SUB)   
                                      WS-TAMPER-CD2-CHNG-FL (MSS-SUB)   
                                      WS-VISUAL-READ-FL (MSS-SUB).      
      ****** MeterSessionOutputOptical.                                 10210000
           MOVE SPACES             TO WS-LOCAL-SETUP-RC   (MSS-SUB)     
                                      WS-OPEN-RC          (MSS-SUB)     
                                      WS-STATUS-CHECK-RC (MSS-SUB)      
                                      WS-TOU-REG-READ-RC   (MSS-SUB)    
                                      WS-RESET-DEMAND-RC   (MSS-SUB).   
      ********* ReadItemResult.                                         10270000
           MOVE ZEROS               TO WS-ACTUAL-RD-ORD-RIR (MSS-SUB).  
           MOVE SPACES              TO WS-TEXT-PROMPT-RIR   (MSS-SUB).  
      *                                                                 10300000
       3510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10330000
      *================================================================*10340000
       3520-LOAD-MSS-RF.                                                
      *================================================================*10360000
      *                                                                 10370000
           COMPUTE MSS-SUB = MSS-SUB + 1                                
           MOVE NumberDials          TO WS-NUMBER-DIALS    (MSS-SUB)    
           MOVE NumberDecimals       TO WS-NUMBER-DECIMALS (MSS-SUB)    
           MOVE ConstantMultiplier   TO WS-CONSTANT        (MSS-SUB)    
           MOVE ReadMethod           TO WS-READ-METHOD    (MSS-SUB)     
           MOVE TextPrompt           TO WS-TEXT-PROMPT    (MSS-SUB)     
           MOVE BestReadCode         TO WS-BEST-READ-CODE (MSS-SUB)     
P00251     MOVE MSICD-CODE-USAGE-TYPE TO WS-CODE-USAGE-TYPE (MSS-SUB)   
P00251     MOVE MSICD-CODE-USAGE-ID   TO WS-CODE-USAGE-ID   (MSS-SUB)   
P00251     MOVE MSICD-CODE-USAGE-SOURCE TO WS-CODE-USAGE-SOURCE(MSS-SUB)
           IF MSICD-TIME-PERIOD IS NUMERIC                              
              MOVE MSICD-TIME-PERIOD TO WS-TIME-PERIOD    (MSS-SUB)     
           ELSE                                                         
              MOVE ZEROS             TO WS-TIME-PERIOD    (MSS-SUB)     
           END-IF                                                       
           MOVE MSICD-CODE-TOU-SEASN TO WS-CODE-TOU-SEASN (MSS-SUB)     
           MOVE MSICD-INDEX-VALUE-CD TO WS-INDEX-VALUE-CD (MSS-SUB)     
           MOVE MSICD-CNSMPTN-READ-FL TO WS-CNSMPTN-READ-FL (MSS-SUB)   
      ****** MeterSessionInputChangedFields.                            10560000
           MOVE ChangedReadMethod     TO WS-CHNG-READ-METHOD (MSS-SUB)  
           MOVE ChangedNumberDials    TO WS-CHNG-NUMBER-DIALS(MSS-SUB)  
           MOVE ChangedNumberDecimals TO WS-CHNG-NUMBER-DECIMALS        
                                                            (MSS-SUB)   
           MOVE MSIChangeIndicators   TO WS-CHNG-MSI-INDICATORS(MSS-SUB)
      *                                                                 10620000
      ****** MeterSessionInputRF.                                       10630000
           MOVE EndpointID           TO WS-ERT-ID         (MSS-SUB)     
           MOVE ChangedEndpointID    TO WS-CHANGED-ERT-ID (MSS-SUB)     
           MOVE EndpointType         TO WS-ERT-TYPE       (MSS-SUB)     
           MOVE TamperCount1         TO WS-TAMPER-COUNT1  (MSS-SUB)     
           MOVE TamperCount2         TO WS-TAMPER-COUNT2  (MSS-SUB)     
           MOVE SolidStateDemandIndicator                               
                                 TO WS-ERT-SS-DEMAND-IND  (MSS-SUB)     
      ****** MeterSessionInputOptical.                                  10710000
           MOVE SPACES               TO TOU-RIL-ID (MSS-SUB)            
      ****MeterSessionOutput.                                           10730000
           MOVE READ-VALUE           TO WS-READ    (MSS-SUB)            
           MOVE ReadDateTime         TO WS-READ-DATETIME (MSS-SUB)      
           MOVE ReadCode             TO WS-READ-CODE     (MSS-SUB)      
           MOVE ReadCondition        TO WS-READ-CONDITION(MSS-SUB)      
           MOVE ForceCompleteReasonCode TO WS-FC-REASON-CODE(MSS-SUB)   
           MOVE SkipCode             TO WS-SKIP-CODE  (MSS-SUB)         
           MOVE ReadFailureCount     TO WS-READ-FIAL-COUNT (MSS-SUB)    
           MOVE ClearCount           TO WS-CLEAR-COUNT (MSS-SUB)        
           MOVE TroubleCode1         TO WS-TROUBLE-CODE1 (MSS-SUB)      
           MOVE TroubleCode2         TO WS-TROUBLE-CODE2 (MSS-SUB)      
           MOVE TroubleMessage       TO WS-TROUBLE-MESG  (MSS-SUB)      
           MOVE DataCollectorUserID  TO WS-DC-USER-ID  (MSS-SUB)        
      ****** MeterSessionOutputRF.                                      10860000
           MOVE EndpointTypeReceived TO WS-ERT-TYPE-RECEIVED(MSS-SUB)   
           MOVE ReadStatus           TO WS-READ-STATUS      (MSS-SUB)   
           MOVE EndpointReadDateTime TO WS-ERT-READ-DATETIME(MSS-SUB)   
           MOVE TamperCount1-NEW     TO WS-TAMPER-COUNT1-NEW(MSS-SUB)   
           MOVE TamperCount2-NEW     TO WS-TAMPER-COUNT2-NEW(MSS-SUB)   
           IF TAMPER-COUNT1-CHNGD                                       
              MOVE 'Y'           TO WS-TAMPER-CD1-CHNG-FL (MSS-SUB)     
           END-IF                                                       
           IF TAMPER-COUNT2-CHNGD                                       
              MOVE 'Y'           TO WS-TAMPER-CD2-CHNG-FL (MSS-SUB)     
           END-IF                                                       
           IF VISUALLY-READ                                             
              MOVE 'Y'              TO WS-VISUAL-READ-FL (MSS-SUB)      
           END-IF                                                       
           MOVE HitMissIndicator     TO WS-HIT-MISS-IND   (MSS-SUB)     
      ****** MeterSessionOutputOptical.                                 11020000
           MOVE SPACES             TO WS-LOCAL-SETUP-RC   (MSS-SUB)     
                                      WS-OPEN-RC          (MSS-SUB)     
                                      WS-STATUS-CHECK-RC (MSS-SUB)      
                                      WS-TOU-REG-READ-RC   (MSS-SUB)    
                                      WS-RESET-DEMAND-RC   (MSS-SUB).   
      ********* ReadItemResult.                                         11080000
           MOVE ZEROS               TO WS-ACTUAL-RD-ORD-RIR (MSS-SUB).  
           MOVE SPACES              TO WS-TEXT-PROMPT-RIR   (MSS-SUB).  
      *                                                                 11110000
       3520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11140000
      *================================================================*11150000
       3530-LOAD-MSS-OPT.                                               
      *================================================================*11170000
      *                                                                 11180000
           IF RIR-SUB > 0                                               
              MOVE RIR-SUB             TO RIR-REC-COUNT                 
              PERFORM VARYING RIR-SUB FROM 1 BY 1 UNTIL                 
                                  RIR-SUB > RIR-REC-COUNT               
                COMPUTE MSS-SUB = MSS-SUB + 1                           
                MOVE NumberDials       TO WS-NUMBER-DIALS    (MSS-SUB)  
                MOVE NumberDecimals    TO WS-NUMBER-DECIMALS (MSS-SUB)  
                MOVE ConstantMultiplier TO WS-CONSTANT      (MSS-SUB)   
                MOVE ReadMethod        TO WS-READ-METHOD    (MSS-SUB)   
                MOVE TextPrompt        TO WS-TEXT-PROMPT    (MSS-SUB)   
                MOVE BestReadCode      TO WS-BEST-READ-CODE (MSS-SUB)   
P00251          MOVE MSICD-CODE-USAGE-TYPE                              
P00251                                 TO WS-CODE-USAGE-TYPE (MSS-SUB)  
P00251          MOVE MSICD-CODE-USAGE-ID  TO WS-CODE-USAGE-ID(MSS-SUB)  
P00251          MOVE MSICD-CODE-USAGE-SOURCE                            
P00251                                 TO WS-CODE-USAGE-SOURCE(MSS-SUB) 
                IF MSICD-TIME-PERIOD IS NUMERIC                         
                   MOVE MSICD-TIME-PERIOD TO WS-TIME-PERIOD (MSS-SUB)   
                ELSE                                                    
                   MOVE ZEROS             TO WS-TIME-PERIOD (MSS-SUB)   
                END-IF                                                  
                MOVE MSICD-CODE-TOU-SEASN TO WS-CODE-TOU-SEASN(MSS-SUB) 
                MOVE MSICD-INDEX-VALUE-CD TO WS-INDEX-VALUE-CD(MSS-SUB) 
                MOVE MSICD-CNSMPTN-READ-FL                              
                                          TO WS-CNSMPTN-READ-FL(MSS-SUB)
      ****** MeterSessionInputChangedFields.                            11440000
                MOVE ChangedReadMethod TO WS-CHNG-READ-METHOD (MSS-SUB) 
                MOVE ChangedNumberDials                                 
                                   TO WS-CHNG-NUMBER-DIALS(MSS-SUB)     
                MOVE ChangedNumberDecimals                              
                                   TO WS-CHNG-NUMBER-DECIMALS (MSS-SUB) 
                MOVE MSIChangeIndicators                                
                                   TO WS-CHNG-MSI-INDICATORS(MSS-SUB)   
      *                                                                 11520000
      ********* MeterSessionInputRF.                                    11530000
                MOVE ZEROS           TO WS-ERT-ID         (MSS-SUB)     
                                        WS-CHANGED-ERT-ID (MSS-SUB)     
                                        WS-ERT-TYPE       (MSS-SUB)     
                                        WS-TAMPER-COUNT1  (MSS-SUB)     
                                        WS-TAMPER-COUNT2  (MSS-SUB)     
                                        WS-ERT-SS-DEMAND-IND(MSS-SUB)   
      ********* MeterSessionInputOptical.                               11600000
                MOVE TOUReadItemListID  TO TOU-RIL-ID (MSS-SUB)         
      **********MeterSessionOutput REPLACE WITH RIR                     11620000
                MOVE Read-RIR(RIR-SUB) TO WS-READ    (MSS-SUB)          
                MOVE ReadDateTime-RIR (RIR-SUB)                         
                                       TO WS-READ-DATETIME (MSS-SUB)    
                MOVE ReadCode-RIR (RIR-SUB) TO WS-READ-CODE (MSS-SUB)   
                MOVE ReadCondition-RIR (RIR-SUB)                        
                                       TO WS-READ-CONDITION (MSS-SUB)   
                MOVE ForceCompleteReasonCode                            
                                       TO WS-FC-REASON-CODE (MSS-SUB)   
                MOVE SkipCode-RIR (RIR-SUB) TO WS-SKIP-CODE (MSS-SUB)   
                MOVE ReadFailureCount-RIR (RIR-SUB)                     
                                       TO WS-READ-FIAL-COUNT (MSS-SUB)  
                MOVE ClearCount-RIR (RIR-SUB)                           
                                       TO WS-CLEAR-COUNT (MSS-SUB)      
                MOVE TroubleCode1      TO WS-TROUBLE-CODE1 (MSS-SUB)    
                MOVE TroubleCode2      TO WS-TROUBLE-CODE2 (MSS-SUB)    
                MOVE TroubleMessage    TO WS-TROUBLE-MESG  (MSS-SUB)    
                MOVE DataCollectorUserID TO WS-DC-USER-ID (MSS-SUB)     
      **********MeterSessionOutputRF.                                   11800000
                MOVE ZEROS         TO WS-ERT-TYPE-RECEIVED(MSS-SUB)     
                                      WS-READ-STATUS      (MSS-SUB)     
                                      WS-TAMPER-COUNT1-NEW(MSS-SUB)     
                                      WS-TAMPER-COUNT2-NEW(MSS-SUB)     
                                      WS-HIT-MISS-IND   (MSS-SUB)       
                MOVE SPACES        TO WS-ERT-READ-DATETIME(MSS-SUB)     
                                      WS-TAMPER-CD1-CHNG-FL (MSS-SUB)   
                                      WS-TAMPER-CD2-CHNG-FL (MSS-SUB)   
                                      WS-VISUAL-READ-FL (MSS-SUB)       
      ****** MeterSessionOutputOptical.                                 11900000
                MOVE LocalSetupReturnCode TO WS-LOCAL-SETUP-RC (MSS-SUB)
                MOVE OpenReturnCode       TO WS-OPEN-RC       (MSS-SUB) 
                MOVE StatusCheckReturnCode                              
                                       TO WS-STATUS-CHECK-RC (MSS-SUB)  
                MOVE TOURegisterReadReturnCode                          
                                   TO WS-TOU-REG-READ-RC   (MSS-SUB)    
                MOVE ResetDemandReturnCode                              
                                   TO WS-RESET-DEMAND-RC   (MSS-SUB)    
      ********* ReadItemResult.                                         11990000
                MOVE ActualReadOrder-RIR (RIR-SUB)                      
                                   TO WS-ACTUAL-RD-ORD-RIR (MSS-SUB)    
                MOVE TextPrompt-RIR (RIR-SUB)                           
                                   TO WS-TEXT-PROMPT-RIR   (MSS-SUB)    
              END-PERFORM                                               
           ELSE                                                         
              COMPUTE MSS-SUB = MSS-SUB + 1                             
              MOVE NumberDials       TO WS-NUMBER-DIALS    (MSS-SUB)    
              MOVE NumberDecimals    TO WS-NUMBER-DECIMALS (MSS-SUB)    
              MOVE ConstantMultiplier TO WS-CONSTANT       (MSS-SUB)    
              MOVE ReadMethod           TO WS-READ-METHOD    (MSS-SUB)  
              MOVE TextPrompt           TO WS-TEXT-PROMPT    (MSS-SUB)  
              MOVE BestReadCode         TO WS-BEST-READ-CODE (MSS-SUB)  
P00251        MOVE MSICD-CODE-USAGE-TYPE                                
P00251                               TO WS-CODE-USAGE-TYPE (MSS-SUB)    
P00251        MOVE MSICD-CODE-USAGE-ID  TO WS-CODE-USAGE-ID(MSS-SUB)    
P00251        MOVE MSICD-CODE-USAGE-SOURCE                              
P00251                               TO WS-CODE-USAGE-SOURCE(MSS-SUB)   
              IF MSICD-TIME-PERIOD IS NUMERIC                           
                 MOVE MSICD-TIME-PERIOD TO WS-TIME-PERIOD (MSS-SUB)     
              ELSE                                                      
                 MOVE ZEROS             TO WS-TIME-PERIOD (MSS-SUB)     
              END-IF                                                    
              MOVE MSICD-CODE-TOU-SEASN TO WS-CODE-TOU-SEASN(MSS-SUB)   
              MOVE MSICD-INDEX-VALUE-CD TO WS-INDEX-VALUE-CD(MSS-SUB)   
              MOVE MSICD-CNSMPTN-READ-FL TO WS-CNSMPTN-READ-FL(MSS-SUB) 
      ****** MeterSessionInputChangedFields.                            12260000
              MOVE ChangedReadMethod TO WS-CHNG-READ-METHOD (MSS-SUB)   
              MOVE ChangedNumberDials                                   
                                   TO WS-CHNG-NUMBER-DIALS(MSS-SUB)     
              MOVE ChangedNumberDecimals                                
                                   TO WS-CHNG-NUMBER-DECIMALS (MSS-SUB) 
              MOVE MSIChangeIndicators                                  
                                   TO WS-CHNG-MSI-INDICATORS(MSS-SUB)   
      *                                                                 12340000
      ******* MeterSessionInputRF.                                      12350000
              MOVE ZEROS             TO WS-ERT-ID         (MSS-SUB)     
                                        WS-CHANGED-ERT-ID (MSS-SUB)     
                                        WS-ERT-TYPE       (MSS-SUB)     
                                        WS-TAMPER-COUNT1  (MSS-SUB)     
                                        WS-TAMPER-COUNT2  (MSS-SUB)     
                                        WS-ERT-SS-DEMAND-IND (MSS-SUB)  
      ******* MeterSessionInputOptical.                                 12420000
              MOVE TOUReadItemListID    TO TOU-RIL-ID (MSS-SUB)         
      ****MeterSessionOutput.                                           12440000
              MOVE READ-VALUE          TO WS-READ    (MSS-SUB)          
              MOVE ReadDateTime        TO WS-READ-DATETIME (MSS-SUB)    
              MOVE ReadCode            TO WS-READ-CODE     (MSS-SUB)    
              MOVE ReadCondition       TO WS-READ-CONDITION(MSS-SUB)    
              MOVE ForceCompleteReasonCode TO WS-FC-REASON-CODE(MSS-SUB)
              MOVE SkipCode            TO WS-SKIP-CODE  (MSS-SUB)       
              MOVE ReadFailureCount    TO WS-READ-FIAL-COUNT (MSS-SUB)  
              MOVE ClearCount          TO WS-CLEAR-COUNT (MSS-SUB)      
              MOVE TroubleCode1        TO WS-TROUBLE-CODE1 (MSS-SUB)    
              MOVE TroubleCode2        TO WS-TROUBLE-CODE2 (MSS-SUB)    
              MOVE TroubleMessage      TO WS-TROUBLE-MESG  (MSS-SUB)    
              MOVE DataCollectorUserID TO WS-DC-USER-ID  (MSS-SUB)      
      ****** MeterSessionOutputRF.                                      12570000
              MOVE ZEROS           TO WS-ERT-TYPE-RECEIVED(MSS-SUB)     
                                      WS-READ-STATUS      (MSS-SUB)     
                                      WS-TAMPER-COUNT1-NEW(MSS-SUB)     
                                      WS-TAMPER-COUNT2-NEW(MSS-SUB)     
                                      WS-HIT-MISS-IND   (MSS-SUB)       
              MOVE SPACES          TO WS-ERT-READ-DATETIME(MSS-SUB)     
                                      WS-TAMPER-CD1-CHNG-FL (MSS-SUB)   
                                      WS-TAMPER-CD2-CHNG-FL (MSS-SUB)   
                                      WS-VISUAL-READ-FL (MSS-SUB)       
      ********MeterSessionOutputOptical.                                12670000
              MOVE LocalSetupReturnCode TO WS-LOCAL-SETUP-RC  (MSS-SUB) 
              MOVE OpenReturnCode       TO WS-OPEN-RC         (MSS-SUB) 
              MOVE StatusCheckReturnCode TO WS-STATUS-CHECK-RC(MSS-SUB) 
              MOVE TOURegisterReadReturnCode                            
                                   TO WS-TOU-REG-READ-RC  (MSS-SUB)     
              MOVE ResetDemandReturnCode                                
                                   TO WS-RESET-DEMAND-RC  (MSS-SUB)     
      ********ReadItemResult.                                           12750000
              MOVE ZEROS           TO WS-ACTUAL-RD-ORD-RIR (MSS-SUB)    
              MOVE SPACES          TO WS-TEXT-PROMPT-RIR   (MSS-SUB)    
           END-IF.                                                      
      *                                                                 12790000
       3530-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12820000
      *================================================================*12830000
       3540-LOAD-MSS-DEFAULT.                                           
      *================================================================*12850000
      *                                                                 12860000
           COMPUTE MSS-SUB = MSS-SUB + 1                                
           MOVE NumberDials          TO WS-NUMBER-DIALS    (MSS-SUB)    
           MOVE NumberDecimals       TO WS-NUMBER-DECIMALS (MSS-SUB)    
           MOVE ConstantMultiplier   TO WS-CONSTANT       (MSS-SUB)     
           MOVE ReadMethod           TO WS-READ-METHOD    (MSS-SUB)     
           MOVE TextPrompt           TO WS-TEXT-PROMPT    (MSS-SUB)     
           MOVE BestReadCode         TO WS-BEST-READ-CODE (MSS-SUB)     
P00251     MOVE MSICD-CODE-USAGE-TYPE TO WS-CODE-USAGE-TYPE (MSS-SUB)   
P00251     MOVE MSICD-CODE-USAGE-ID   TO WS-CODE-USAGE-ID   (MSS-SUB)   
P00251     MOVE MSICD-CODE-USAGE-SOURCE TO WS-CODE-USAGE-SOURCE(MSS-SUB)
           IF MSICD-TIME-PERIOD IS NUMERIC                              
              MOVE MSICD-TIME-PERIOD TO WS-TIME-PERIOD    (MSS-SUB)     
           ELSE                                                         
              MOVE ZEROS             TO WS-TIME-PERIOD    (MSS-SUB)     
           END-IF                                                       
           MOVE MSICD-CODE-TOU-SEASN  TO WS-CODE-TOU-SEASN (MSS-SUB)    
           MOVE MSICD-INDEX-VALUE-CD  TO WS-INDEX-VALUE-CD(MSS-SUB)     
           MOVE MSICD-CNSMPTN-READ-FL TO WS-CNSMPTN-READ-FL(MSS-SUB)    
      ****** MeterSessionInputChangedFields.                            13050000
           MOVE ChangedReadMethod     TO WS-CHNG-READ-METHOD (MSS-SUB)  
           MOVE ChangedNumberDials    TO WS-CHNG-NUMBER-DIALS(MSS-SUB)  
           MOVE ChangedNumberDecimals TO WS-CHNG-NUMBER-DECIMALS        
                                                            (MSS-SUB)   
           MOVE MSIChangeIndicators   TO WS-CHNG-MSI-INDICATORS(MSS-SUB)
      *                                                                 13110000
      ****** MeterSessionInputRF.                                       13120000
           MOVE ZEROS                TO WS-ERT-ID         (MSS-SUB)     
                                        WS-CHANGED-ERT-ID (MSS-SUB)     
                                        WS-ERT-TYPE       (MSS-SUB)     
                                        WS-TAMPER-COUNT1  (MSS-SUB)     
                                        WS-TAMPER-COUNT2  (MSS-SUB)     
                                        WS-ERT-SS-DEMAND-IND(MSS-SUB)   
      ****** MeterSessionInputOptical.                                  13190000
           MOVE SPACES               TO TOU-RIL-ID (MSS-SUB)            
      ****MeterSessionOutput.                                           13210000
           MOVE ZEROS                TO WS-READ    (MSS-SUB)            
           MOVE SPACES               TO WS-READ-DATETIME (MSS-SUB)      
                                        WS-DC-USER-ID  (MSS-SUB)        
                                        WS-FC-REASON-CODE(MSS-SUB)      
                                        WS-SKIP-CODE  (MSS-SUB)         
                                        WS-TROUBLE-CODE1 (MSS-SUB)      
                                        WS-TROUBLE-CODE2 (MSS-SUB)      
                                        WS-TROUBLE-MESG  (MSS-SUB)      
           MOVE ZEROS                TO WS-READ-CODE     (MSS-SUB)      
                                        WS-READ-CONDITION(MSS-SUB)      
                                        WS-READ-FIAL-COUNT (MSS-SUB)    
                                        WS-CLEAR-COUNT (MSS-SUB)        
      ****** MeterSessionOutputRF.                                      13340000
           MOVE ZEROS              TO WS-ERT-TYPE-RECEIVED(MSS-SUB)     
                                      WS-READ-STATUS      (MSS-SUB)     
                                      WS-TAMPER-COUNT1-NEW(MSS-SUB)     
                                      WS-TAMPER-COUNT2-NEW(MSS-SUB)     
                                      WS-HIT-MISS-IND   (MSS-SUB).      
           MOVE SPACES             TO WS-ERT-READ-DATETIME(MSS-SUB)     
                                      WS-TAMPER-CD1-CHNG-FL (MSS-SUB)   
                                      WS-TAMPER-CD2-CHNG-FL (MSS-SUB)   
                                      WS-VISUAL-READ-FL (MSS-SUB).      
      ****** MeterSessionOutputOptical.                                 13440000
           MOVE SPACES             TO WS-LOCAL-SETUP-RC   (MSS-SUB)     
                                      WS-OPEN-RC          (MSS-SUB)     
                                      WS-STATUS-CHECK-RC (MSS-SUB)      
                                      WS-TOU-REG-READ-RC   (MSS-SUB)    
                                      WS-RESET-DEMAND-RC   (MSS-SUB).   
      ********* ReadItemResult.                                         13500000
           MOVE ZEROS               TO WS-ACTUAL-RD-ORD-RIR (MSS-SUB).  
           MOVE SPACES              TO WS-TEXT-PROMPT-RIR   (MSS-SUB).  
      *                                                                 13530000
       3540-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13560000
      *================================================================*13570000
       3600-FORMAT-BW81.                                                
      *================================================================*13590000
      *                                                                 13600000
           MOVE MSS-SUB                TO WS-MSS-REC-COUNT              
           PERFORM VARYING MSS-SUB FROM 1 BY 1 UNTIL                    
                                  MSS-SUB > WS-MSS-REC-COUNT            
              MOVE CompanyID             TO E-FBW81-COMPANY-NO          
              MOVE WorkSetID             TO E-FBW81-WORK-SET-ID         
              MOVE Cycle                 TO E-FBW81-READ-CYCLE          
              MOVE WS-LOCAL-OFFICE       TO E-FBW81-LOCAL-OFFICE        
              IF WS-READ-ROUTE IS NUMERIC                               
                 MOVE WS-READ-ROUTE      TO E-FBW81-READ-ROUTE          
              ELSE                                                      
                 MOVE ZEROS              TO E-FBW81-READ-ROUTE          
              END-IF                                                    
              MOVE WS-READ-SEQ-REQ       TO E-FBW81-SEQ-REQUIRED        
              MOVE AccountNumber         TO E-FBW81-ACCOUNT-NO          
              MOVE MeterNumber           TO E-FBW81-METER-NO            
              MOVE MeterCategory         TO E-FBW81-METER-CATEGORY      
              MOVE WS-MTR-READ-SOURCE-CD TO E-FBW81-MTR-READ-SOURCE-CD  
              MOVE WS-RRI                TO E-FBW81-RRI                 
              MOVE WS-PGM-ID             TO E-FBW81-PGM-ID              
              MOVE WS-DMT                TO E-FBW81-DMT                 
              MOVE UtilityMeterSequenceNumber TO E-FBW81-MTR-READ-SEQ   
              MOVE ActiveIndicator       TO E-FBW81-MTR-ACTIVE-IND      
              MOVE ServicePointID        TO E-FBW81-SERVICE-POINT-ID    
              MOVE InstructionLocationCode1 TO E-FBW81-INSTR-LOC-CD1    
              MOVE InstructionLocationCode2 TO E-FBW81-INSTR-LOC-CD2    
              IF NewService-True                                        
                 MOVE 'Y'                TO E-FBW81-NEW-SERVICE-FLAG    
              ELSE                                                      
                 MOVE SPACES             TO E-FBW81-NEW-SERVICE-FLAG    
              END-IF                                                    
              MOVE ChangeIndicator       TO E-FBW81-MTR-CHNG-IND        
              MOVE MTRChangeIndicators   TO E-FBW81-MTR-CHNG-FIELDS     
              MOVE ChangedUtilityMeterSeqNum TO E-FBW81-MTR-READ-SEQ-NEW
              MOVE ChangedMeterNumber    to E-FBW81-METER-NO-NEW        
              IF Spl-Msg-Changed-True                                   
                 MOVE 'Y'                TO E-FBW81-SPL-MSG-CHNGD-IND   
              ELSE                                                      
                 MOVE SPACES             TO E-FBW81-SPL-MSG-CHNGD-IND   
              END-IF                                                    
              MOVE ChangedInstructionLocCode1                           
                                         TO E-FBW81-INSTR-LOC-CD1-NEW   
              MOVE ChangedInstructionLocCode2                           
                                         TO E-FBW81-INSTR-LOC-CD2-NEW   
              IF E-FBW81-SPL-MSG-CHNGD                                  
                 MOVE ChangedSpecialMessage TO E-FBW81-SPL-MSG          
              ELSE                                                      
                 MOVE SpecialMessage        TO E-FBW81-SPL-MSG          
              END-IF                                                    
              MOVE WS-NUMBER-DIALS    (MSS-SUB) TO E-FBW81-READ-DIALS   
              MOVE WS-NUMBER-DECIMALS (MSS-SUB) TO E-FBW81-READ-DECIMALS
              MOVE WS-CONSTANT       (MSS-SUB) TO E-FBW81-CONSTANT      
              MOVE WS-READ-METHOD    (MSS-SUB) TO E-FBW81-READ-METHOD   
              MOVE WS-TEXT-PROMPT    (MSS-SUB) TO E-FBW81-TEXT-PROMPT   
      ***     MOVE WS-BEST-READ-CODE (MSS-SUB)                          14140000
P00251        MOVE WS-CODE-USAGE-TYPE(MSS-SUB)                          
P00251                                   TO E-FBW81-CODE-USAGE-TYPE     
P00251        MOVE WS-CODE-USAGE-ID  (MSS-SUB)                          
P00251                                   TO E-FBW81-CODE-USAGE-ID       
P00251        MOVE WS-CODE-USAGE-SOURCE(MSS-SUB)                        
P00251                                   TO E-FBW81-CODE-USAGE-SOURCE   
              MOVE WS-TIME-PERIOD   (MSS-SUB) TO E-FBW81-TIME-PERIOD    
              MOVE WS-CODE-TOU-SEASN(MSS-SUB) TO E-FBW81-CODE-TOU-SEASN 
              MOVE WS-INDEX-VALUE-CD(MSS-SUB) TO E-FBW81-INDEX-VALUE-CD 
              MOVE WS-CNSMPTN-READ-FL(MSS-SUB)                          
                                              TO E-FBW81-CNSMPTN-READ-FL
      ****** MeterSessionInputChangedFields.                            14260000
              MOVE WS-CHNG-READ-METHOD (MSS-SUB)                        
                                       TO E-FBW81-READ-METHOD-NEW       
              MOVE WS-CHNG-NUMBER-DIALS(MSS-SUB)                        
                                       TO E-FBW81-READ-DIALS-NEW        
              MOVE WS-CHNG-NUMBER-DECIMALS (MSS-SUB)                    
                                       TO E-FBW81-READ-DECIMALS-NEW     
              MOVE  WS-CHNG-MSI-INDICATORS(MSS-SUB)                     
                                       TO E-FBW81-MSI-CHNG-FIELDS       
      *                                                                 14350000
      ****** MeterSessionInputRF.                                       14360000
              MOVE WS-ERT-ID         (MSS-SUB) TO E-FBW81-ERT-ID        
              MOVE WS-CHANGED-ERT-ID (MSS-SUB) TO E-FBW81-ERT-ID-NEW    
              MOVE WS-ERT-TYPE       (MSS-SUB) TO E-FBW81-ERT-TYPE      
              MOVE WS-TAMPER-COUNT1  (MSS-SUB) TO E-FBW81-TAMPER-CD1    
              MOVE WS-TAMPER-COUNT2  (MSS-SUB) TO E-FBW81-TAMPER-CD2    
              MOVE WS-ERT-SS-DEMAND-IND (MSS-SUB)                       
                                          TO E-FBW81-ERT-SS-DMD-IND     
      ****** MeterSessionInputOptical.                                  14440000
              MOVE TOU-RIL-ID (MSS-SUB)   TO E-FBW81-TOU-RILIST         
      ****MeterSessionOutput.                                           14460000
              MOVE WS-READ    (MSS-SUB)       TO E-FBW81-READ           
              MOVE WS-READ-DATETIME (MSS-SUB) TO E-FBW81-READ-DATETIME  
              MOVE WS-READ-CODE     (MSS-SUB) TO E-FBW81-READ-CODE      
              MOVE WS-READ-CONDITION(MSS-SUB) TO E-FBW81-READ-CODITION  
      ***     MOVE WS-FC-REASON-CODE(MSS-SUB)                           14510000
              MOVE WS-SKIP-CODE  (MSS-SUB)    TO E-FBW81-SKIP-CODE      
              MOVE WS-READ-FIAL-COUNT (MSS-SUB)                         
                                           TO E-FBW81-READ-FAIL-COUNT   
      ***     MOVE WS-CLEAR-COUNT (MSS-SUB)                             14550000
              MOVE WS-TROUBLE-CODE1 (MSS-SUB) TO E-FBW81-TROUBLE-CODE1  
              MOVE WS-TROUBLE-CODE2 (MSS-SUB) TO E-FBW81-TROUBLE-CODE2  
              MOVE WS-TROUBLE-MESG  (MSS-SUB) TO E-FBW81-TROUBLE-MESG   
              MOVE WS-DC-USER-ID  (MSS-SUB)   TO E-FBW81-DC-USER-ID     
      ****** MeterSessionOutputRF.                                      14600000
              MOVE WS-ERT-TYPE-RECEIVED(MSS-SUB)                        
                                            TO E-FBW81-ERT-TYPE-RCVD    
              MOVE WS-READ-STATUS (MSS-SUB) TO E-FBW81-ERT-READ-STATUS  
              MOVE WS-TAMPER-COUNT1-NEW (MSS-SUB)                       
                                            TO E-FBW81-TAMPER-CD1-NEW   
              MOVE WS-TAMPER-COUNT2-NEW (MSS-SUB)                       
                                            TO E-FBW81-TAMPER-CD2-NEW   
              MOVE WS-HIT-MISS-IND (MSS-SUB) TO E-FBW81-HIT-MISS-COUNT  
      ****    MOVE WS-ERT-READ-DATETIME(MSS-SUB)                        14690000
              MOVE WS-TAMPER-CD1-CHNG-FL (MSS-SUB)                      
                                            TO E-FBW81-TAMPER-CD1-CHNG  
              MOVE WS-TAMPER-CD2-CHNG-FL (MSS-SUB)                      
                                            TO E-FBW81-TAMPER-CD2-CHNG  
              MOVE WS-VISUAL-READ-FL (MSS-SUB)                          
                                            TO E-FBW81-VISUAL-READ-FLAG 
      ****** MeterSessionOutputOptical.                                 14760000
              MOVE WS-LOCAL-SETUP-RC  (MSS-SUB)                         
                                            TO E-FBW81-LOCAL-SETUP-RC   
              MOVE WS-OPEN-RC         (MSS-SUB) TO E-FBW81-OPEN-RC      
              MOVE WS-STATUS-CHECK-RC (MSS-SUB)                         
                                            TO E-FBW81-STATUS-CHECK-RC  
              MOVE WS-TOU-REG-READ-RC (MSS-SUB)                         
                                            TO E-FBW81-TOU-REG-READ-RC  
              MOVE WS-RESET-DEMAND-RC (MSS-SUB)                         
                                            TO E-FBW81-RESET-DEMAND-RC  
      ********* ReadItemResult.                                         14860000
              MOVE WS-ACTUAL-RD-ORD-RIR (MSS-SUB)                       
                                        TO E-FBW81-ACTUAL-RD-ORD-RIR    
              MOVE WS-TEXT-PROMPT-RIR   (MSS-SUB)                       
                                        TO E-FBW81-TEXT-PROMPT-RIR      
              PERFORM 8400-WRITE-FCSBW81 THRU 8400-EXIT                 
           END-PERFORM.                                                 
      *                                                                 14930000
       3600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14960000
      *================================================================*14970000
       5000-GET-XML-REC.                                                
      *================================================================*14990000
      *                                                                 15000000
           MOVE ZEROS                  TO WS-ST-WORKSET-COUNT           
A00775                                    WS-ST-CUST-COUNT              
A00775                                    WS-END-CUST-COUNT             
           SET NOT-PARSE-CUST-ARRAY    TO TRUE                          
           SET NOT-PARSE-WORKSET-ARRAY TO TRUE                          
           PERFORM 7000-READ-XML    THRU 7000-EXIT                      
      *                                                                 15080000
           IF NOT Fbw73-SUCCESSFUL                                      
              GO TO 5000-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE FIOBW73               TO WS-BW73-REC                    
      *                                                                 15140000
A00775     INSPECT WS-BW73-REC TALLYING WS-ST-CUST-COUNT                
A00775               FOR ALL '<Customer>'                               
A00775     INSPECT WS-BW73-REC TALLYING WS-END-CUST-COUNT               
A00775               FOR ALL '</Customer>'                              
           INSPECT WS-BW73-REC TALLYING WS-ST-WORKSET-COUNT             
                     FOR ALL '<WorkSet>'                                
      *                                                                 15230000
           EVALUATE TRUE                                                
A00775        WHEN WS-ST-CUST-COUNT  > 0                                
A00775             SET LOAD-CUST-ARRAY       TO  TRUE                   
                   IF LOAD-WORKSET-ARRAY                                
                      SET PARSE-WORKSET-ARRAY   TO  TRUE                
                   END-IF                                               
                   SET NOT-LOAD-WORKSET-ARRAY   TO  TRUE                
A00775        WHEN WS-END-CUST-COUNT     > 0                            
A00775             SET PARSE-CUST-ARRAY   TO  TRUE                      
A00775             SET NOT-LOAD-CUST-ARRAY       TO  TRUE               
              WHEN WS-ST-WORKSET-COUNT   > 0                            
                   SET LOAD-WORKSET-ARRAY   TO  TRUE                    
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE                                                 
           .                                                            
      *                                                                 15420000
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15450000
      *================================================================*15460000
       5100-HANDLE-SPL-CHARS.                                           
      *================================================================*15480000
      *                                                                 15490000
           EVALUATE TRUE                                                
              WHEN WS-PREV-EVENT = 'SpecialMessage'                     
                 STRING XML-TEXT DELIMITED BY SIZE                      
                     INTO SpecialMessage                                
                     WITH POINTER WS-SPL-MSG-POS                        
              WHEN WS-PREV-EVENT = 'ChangedSpecialMessage'              
                 STRING XML-TEXT DELIMITED BY SIZE                      
                     INTO ChangedSpecialMessage                         
                     WITH POINTER WS-SPL-MSG-NEW-POS                    
              WHEN OTHER                                                
                 CONTINUE                                               
           END-EVALUATE.                                                
      *                                                                 15630000
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15660000
      *================================================================*15670000
       7000-READ-XML.                                                   
      *================================================================*15690000
      *                                                                 15700000
           READ FCSBW73-FILE                                            
               AT END MOVE 'Y'          TO WS-END-OF-FBW73-FILE         
      *                                                                 15730000
           IF Fbw73-SUCCESSFUL OR END-OF-FBW73                          
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '8200-ERROR ON FCSBW73 READ'                     
               DISPLAY 'FCSBW73 FILE STATUE IS ==>' WS-FBW73-STATUS     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15840000
      *================================================================*15850000
       8400-WRITE-FCSBW81.                                              
      *================================================================*15870000
      *                                                                 15880000
      ***  PRESERVE OFF THE CONTENTS OF FIOBW81 BECAUSE THE WRITE       15890000
      ***  STATEMENT WILL LOW-VALUE IT:                                 15900000
      *                                                                 15910000
           MOVE FIOBW81                TO WS-HOLD-FIOBW81.              
           WRITE FIOBW81.                                               
      *                                                                 15940000
           IF FBW81-SUCCESSFUL                                          
               MOVE WS-HOLD-FIOBW81    TO FIOBW81                       
               ADD 1                   TO WS-COUNT-FCSBW81              
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '8400-ERROR ON FCSBW81 WRITE.  STATUS IS '       
                        WS-FBW81-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
               DISPLAY '****************************************'       
           END-IF.                                                      
      *                                                                 16050000
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16080000
      *================================================================*16090000
       9000-TERMINATE.                                                  
      *================================================================*16110000
      *                                                                 16120000
           CLOSE FCSBW73-FILE.                                          
      *                                                                 16140000
           IF Fbw73-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY 'FILE CLOSE ERROR'                               
               DISPLAY 'FCSBW73 FILE STATUS ==>' WS-FBW73-STATUS        
           END-IF.                                                      
      *                                                                 16210000
           CLOSE FCSBW81-FILE.                                          
      *                                                                 16230000
           IF FBW81-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY 'FILE CLOSE ERROR'                               
               DISPLAY 'FCSBW81 FILE STATUS ==>' WS-FBW81-STATUS        
           END-IF.                                                      
      *                                                                 16300000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16330000
      *================================================================*16340000
       9900-ABEND.                                                      
      *================================================================*16360000
      *                                                                 16370000
           DISPLAY '*****************************************'          
           DISPLAY '**      PERFORMING 9900-ABEND          **'          
           DISPLAY '** ERROR OCCURED AND CAN NOT PROCEED.  **'          
           DISPLAY '** TERMINATING PROGRAM ...........     **'          
           DISPLAY '*****************************************'          
           PERFORM 9000-TERMINATE    THRU 9000-EXIT.                    
           MOVE 12  TO  RETURN-CODE.                                    
           STOP RUN.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16500000
      ****************** END OF PCSBW181 PROGRAM ***********************16510000
      ******************************************************************16520000
      *                                                                 16530000
