       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW173.                                        
       DATE-WRITTEN.   04/09/09.                                        
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **              South Carolina Electricity  & Gas              ** 00060000
      **               COMPLETE BUSINESS SOLUTIONS INC.              ** 00070000
      **                                                             ** 00080000
      *********            CUSTOMER SERVICE SYSTEM            ********* 00090000
      *********                      DB2                      ********* 00100000
      ***************************************************************** 00110000
      **                                                             ** 00120000
      **              PROGRAM  MODIFICATION  LOG                     ** 00130000
      **                                                             ** 00140000
      ** DATE       INITIALS        REASON                           ** 00150000
      ** ========   ========     ====================================** 00160000
      ** 04/09/09   SS95855      NEW XML FILE FORMAT FOR FCS         ** 00170000
      ** 08/28/09   SS95855      TO AVOID DUPLICATE READS,EACH METER ** 00180000
      **                         WILL HAVE CUSTOMER INFORMATION.     ** 00190000
A05081** 10/19/09   NC94746      Clarity id: APPLITR05081            ** 00200000
A05081**                         Removed Non-EBCDIC Char's in Name,  ** 00210000
A05081**                         Address & Spl Instruction fields to ** 00220000
A05081**                         addess ASCII code conversion issues ** 00230000
A05081**                         while FTP to FCS.                   ** 00240000
P00251** 01/25/10   SS95855      Net Metering                        ** 00250000
P00251**                         Code_Usage_Id and Code_Usage_Source ** 00260000
P00251**                         added to FIOBW71 layout.            ** 00270000
P00251** 01/25/10   SS95855      Exclude special char'|' in conversn ** 00270100
      ***************************************************************** 00280000
      **                    PCSBW173   NARRATIVE                     ** 00290000
      **    XML GENARATOR/PARSER                                     ** 00300000
      **    FOR METER READING                                        ** 00310000
      **                                                             ** 00320000
      **    CHECK COPYBOOK FIOBW71 FOR IMPACT, WHEN YOU CHANGE THE   ** 00330000
      **    XML FIELDS AND VICE VERSA.                               ** 00340000
      ***************************************************************** 00350000
      *                                                                 00360000
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                 00450000
HPCCDM*EJECT                                                            00460000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00490000
       FILE-CONTROL.                                                    
       COPY CSSBW71.                                                    00510000
       COPY CSSBW73.                                                    00520000
      *                                                                 00530000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00560000
       COPY CFDBW71.                                                    00570000
       COPY FIOBW71.                                                    00580000
       COPY CFDBW73.                                                    00590000
       01 FIOBW73                       PIC X(200).                     
      *                                                                 00610000
       WORKING-STORAGE SECTION.                                         
      *                                                                 00630000
       01  WS-WORK-AREA.                                                
           05 WS-PGRMNAME               PIC X(08) VALUE                 
                                                  'PCSBW173'.           
           05  WS-REMOTE-READ-IND           PIC X(01).                  
               88 MANUAL-MTR                    VALUE '0'.              
               88 TOU-MANUAL-MTR                VALUE 'M'.              
               88 TOU-ONLY-MTR                  VALUE 'T'.              
               88 TOU-IDR-MTR                   VALUE 'B'.              
               88 IDR-ONLY-MTR                  VALUE 'I'.              
               88 OPTICAL-PROB-MTR              VALUE 'T' 'B' 'I'.      
               88 AMR-MTR                       VALUE 'A'.              
       01  WS-SWITCHES.                                                 
           05 WS-Fbw71-STATUS           PIC XX    VALUE '00'.           
              88 Fbw71-SUCCESSFUL                 VALUE '00'.           
           05 WS-Fbw73-STATUS           PIC XX    VALUE '00'.           
              88 Fbw73-SUCCESSFUL                 VALUE '00'.           
           05  WS-NO-MORE-DATA          PIC X(01) VALUE 'N'.            
               88  NO-MORE-DATA                   VALUE 'Y'.            
      *                                                                 00820000
       01  WS-XML-INPUT                 PIC X(200) VALUE SPACES.        
       01  WS-VERSION-TAG               PIC X(200) VALUE                
           '<?xml version="1.0" encoding="utf-8"?>'.                    
       01  WS-IMPORT-TAG.                                               
           05 WS-IMPORT1                PIC X(44) VALUE                 
           '<Import xmlns="http://www.itron.com/nVanta" '.              
           05 WS-IMPORT2                PIC X(54) VALUE                 
           'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" '.    
           05 WS-IMPORT3                PIC X(19) VALUE                 
           'xsi:schemaLocation='.                                       
           05 WS-IMPORT4                PIC X(51) VALUE                 
           '"http://www.itron.com/nVanta nVantaImportFile.xsd">'.       
      *                                                                 00950000
       01  WS-WORKSETS-TAG              PIC X(29) VALUE                 
           '<WorkSets Ownership="SCANA?">'.                             
      *                                                                 00980000
       01  WS-WORKSETS-END-TAG          PIC X(11) VALUE                 
           '</WorkSets>'.                                               
       01  WS-IMPORT-END-TAG            PIC X(09) VALUE                 
           '</Import>'.                                                 
       01  WS-GPS-TAG.                                                  
           05 FILLER                    PIC X(08) VALUE SPACES.         
           05 WS-GPS-DATA               PIC X(192).                     
       01 WS-CUSTOM-DATA-AREA.                                          
          05 WS-CUSTOM-DATA-IN           PIC X(21).                     
          05 WS-METER-CUSTOM-DATA REDEFINES WS-CUSTOM-DATA-IN.          
             10 WS-LOCAL-OFFICE          PIC X(03).                     
             10 WS-READ-ROUTE            PIC X(04).                     
             10 WS-READ-SEQ-REQ          PIC X(01).                     
             10 WS-MTR-READ-SOURCE-CD    PIC X(01).                     
             10 WS-RRI                   PIC X(01).                     
             10 WS-PGM-ID                PIC X(02).                     
             10 WS-DMT                   PIC X(03).                     
             10 FILLER                   PIC X(06).                     
          05 WS-METER-SSON-CUSTOM-DATA REDEFINES WS-CUSTOM-DATA-IN.     
P00251       10 WS-CODE-USAGE-TYPE       PIC X(01).                     
             10 WS-TIME-PERIOD           PIC X(04).                     
             10 WS-CODE-TOU-SEASN        PIC X(01).                     
             10 WS-INDEX-VALUE-CD        PIC X(01).                     
             10 WS-CNSMPTN-READ-FL       PIC X(01).                     
P00251       10 WS-CODE-USAGE-ID         PIC X(01).                     
P00251       10 WS-CODE-USAGE-SOURCE     PIC X(01).                     
P00251       10 FILLER                   PIC X(11).                     
      *                                                                 01260000
       01  WorkSet.                                                     
           05 WorkSetID                 PIC X(08).                      
           05 WorkSetType               PIC 9(01).                      
           05 ScheduledReadDate         PIC X(10).                      
           05 Cycle                     PIC X(02).                      
           05 CriticalReadDate          PIC X(10).                      
           05 FilteringInformation      PIC X(100).                     
       01  Work.                                                        
           05 SequenceNumber            PIC 9(09).                      
           05 WorkType                  PIC 9(01).                      
           05 Customer.                                                 
              10 SequenceWithinWork     PIC 9(01).                      
              10 FullName               PIC X(42).                      
              10 FullStreetAddress      PIC X(60).                      
              10 AccountNumber          PIC X(20).                      
              10 CompanyID              PIC X(02).                      
       01 Meter.                                                        
          05 ServicePointID             PIC X(128).                     
          05 InstructionLocationCode1   PIC X(02).                      
          05 InstructionLocationCode2   PIC X(02).                      
          05 UtilityMeterSequenceNumber PIC 9(10).                      
          05 MeterNumber                PIC X(09).                      
          05 MeterCategory              PIC 9(01).                      
          05 MeterType                  PIC X(02).                      
          05 ActiveIndicator            PIC 9(01).                      
          05 GroupFlag                  PIC X(05).                      
          05 BillCode                   PIC X(01).                      
          05 Xegment                    PIC 9(04).                      
          05 SpecialMessage             PIC X(114).                     
          05 SpecialMessageBeepFlag     PIC X(05).                      
          05 SpecialMessageIndicator    PIC 9(01).                      
       01 MeterSessionInput.                                            
          05 NumberDials                PIC 9(02).                      
          05 NumberDecimals             PIC 9(02).                      
          05 PreviousRead               PIC 9(10).                      
          05 ConstantMultiplier         PIC 9(06).                      
          05 ReadTypeCode               PIC X(02).                      
          05 ReadMethod                 PIC 9(01).                      
          05 PromptCode                 PIC 9(01).                      
          05 TextPrompt                 PIC X(04).                      
          05 ConsecutiveEstimates       PIC 9(01).                      
          05 TypeOfValidationIndicator  PIC 9(03).                      
          05 Hi1                        PIC 9(10).                      
          05 Hi2                        PIC 9(10).                      
          05 Low1                       PIC 9(10).                      
          05 Low2                       PIC 9(10).                      
       01 CustomDataField.                                              
           05 CustomData                PIC X(21).                      
           05 Xequence                  PIC 9(01).                      
       01  GPSInformation.                                              
           05 Latitude                  PIC S9(3)V9(6).                 
           05 Longitude                 PIC S9(3)V9(6).                 
       01  MeterSessionInputRF.                                         
           05 RFFrequency               PIC 9(03)V9(05).                
           05 EndpointID                PIC 9(12).                      
           05 EndpointType              PIC 9(02).                      
           05 WakeupTone                PIC 9(02).                      
           05 TamperCount1              PIC 9(02).                      
           05 TamperCount2              PIC 9(02).                      
           05 SolidStateDemandIndicator PIC 9(01).                      
       01 MeterSessionInputOptical.                                     
           05 RecorderID                   PIC X(09).                   
           05 DeviceID                     PIC X(18).                   
           05 TIMName                      PIC X(04).                   
           05 PasswordID                   PIC X(10).                   
           05 TOUReadItemListID            PIC X(10).                   
           05 DaisyChainFlag               PIC X(05).                   
           05 DaylightSavingTimeFlag       PIC X(05).                   
           05 ReadLoadProfileIndicator     PIC 9(01).                   
           05 VisualReadFlag               PIC X(05).                   
           05 TOURegisterReadFlag          PIC X(05).                   
           05 ResetDemandFlag              PIC X(05).                   
           05 DaylightSavingTimeUpdateFlag PIC X(05).                   
           05 StatusCheckFlag              PIC X(05).                   
           05 LastLoadProfileReadDateTime  PIC X(19).                   
       01  WS-XML-OUT                   PIC X(1000).                    
       01 WS-PREV-NEXT-DATA.                                            
          05 WS-PREV-WORK-SET-ID        PIC X(08) VALUE SPACES.         
          05 WS-PREV-ACCOUNT-NO         PIC 9(13) VALUE 0.              
          05 WS-PREV-METER-NO           PIC X(09) VALUE SPACES.         
          05 WS-PREV-UTL-TYPE           PIC X(01) VALUE SPACES.         
          05 WS-WORK-SET-END            PIC X(200).                     
          05 WS-WORK-END                PIC X(200).                     
          05 WS-CUSTOMER-END            PIC X(200).                     
          05 WS-METER-END               PIC X(200).                     
          05 WS-METER-SESSION-END       PIC X(200).                     
          05 WS-DEPTH-WSET              PIC 9(02)  VALUE 0.             
          05 WS-DEPTH-WORK              PIC 9(02)  VALUE 1.             
          05 WS-DEPTH-CUSTOMER          PIC 9(02)  VALUE 2.             
          05 WS-DEPTH-METER             PIC 9(02)  VALUE 3.             
          05 WS-DEPTH-MSI               PIC 9(02)  VALUE 4.             
          05 WS-DEPTH-MSIRF             PIC 9(02)  VALUE 5.             
          05 WS-DEPTH-MSIOPT            PIC 9(02)  VALUE 5.             
          05 WS-DEPTH6                  PIC 9(02)  VALUE 6.             
          05 WS-DEPTH8                  PIC 9(02)  VALUE 8.             
          05 WS-DEPTH10                 PIC 9(02)  VALUE 10.            
          05 WS-SERVICEPOINTID.                                         
A05081       10 WS-SP-COMPANY-NO        PIC X(02).                      
             10 WS-SP-PREMISE-NO        PIC 9(10).                      
A05081       10 WS-SP-UTIL-TYPE         PIC X(01).                      
             10 WS-SP-IC-NO             PIC 9(04).                      
             10 WS-SP-MTR-REF-NO        PIC 9(04).                      
       01 WS-XML-ARR-TAB.                                               
           05 WS-XML-ARRAY.                                             
              10 WS-XML-STRING     OCCURS 1000 TIMES  PIC X(200).       
           05 SUB1                      PIC 9(04) VALUE 0.              
           05 SUB2                      PIC 9(04) VALUE 0.              
       01 WS-PARSE-WORK.                                                
           05 WS-ELE-POS                PIC 9(03).                      
           05 WS-DAT-POS                PIC 9(03).                      
           05 WS-DEPTH                  PIC 9(02).                      
           05 WS-SPL-CHAR               PIC X(30).                      
           05 WS-PREV-ROOT-FL           PIC 9(01) VALUE 0.              
              88 PREV-IS-NOT-ROOT                 VALUE 0.              
              88 PREV-IS-ROOT                     VALUE 1.              
           05 WS-TEMP-VAR               PIC X(200).                     
           05 WS-OUT-REC                PIC X(200).                     
      *                                                                 02440000
A05081 01  WS-SPL-CHAR-WORK-AREA.                                       
A05081     05 WS-EXCEPTION-FIELD        PIC X(17) VALUE SPACES.         
A05081     05 WS-PREV-FULL-NAME         PIC X(42) VALUE SPACES.         
A05081     05 WS-FULL-NAME              PIC X(42) VALUE SPACES.         
A05081     05 WS-PREV-STREET-ADDRESS    PIC X(60) VALUE SPACES.         
A05081     05 WS-STREET-ADDRESS         PIC X(60) VALUE SPACES.         
A05081     05 WS-PREV-SPCL-READ-INSTR   PIC X(114) VALUE SPACES.        
A05081     05 WS-SPCL-READ-INSTR        PIC X(114) VALUE SPACES.        
A05081     05 WS-SRC-STR1               PIC X(114) VALUE SPACES.        
A05081     05 WS-SRC-STR2               PIC X(114) VALUE SPACES.        
P01137     05 WS-CONVERT-TO1            PIC X(91) VALUE SPACES.         
A05081     05 WS-CONVERT-TO2            PIC X(114) VALUE SPACES.        
A05081     05 WS-CONVERT-FROM.                                          
A05081        10 WS-DATA-UPPER          PIC X(26) VALUE                 
A05081         'ABCDEFGHIJKLMNOPQRSTUVWXYZ'.                            
A05081        10 WS-DATA-LOWER          PIC X(26) VALUE                 
A05081         'abcdefghijklmnopqrstuvwxyz'.                            
A05081        10 WS-DATA-NUMBER         PIC X(10) VALUE                 
A05081         '1234567890'.                                            
A05081        10 WS-DATA-SPECIAL1       PIC X(27) VALUE                 
P01137         '.<(+&!$*);-/,%_>?`:#@=~{}\'.                           
A05081        10 WS-DATA-SPECIAL2       PIC X(01) VALUE                 
A05081         '"'.                                                     
A05081        10 WS-DATA-SPECIAL3       PIC X(01) VALUE                 
A05081         "'".                                                     
P01137     05 WS-CONVERT-FROM1 REDEFINES WS-CONVERT-FROM PIC X(91).     
A05081***      '.<(+|&!$*);-/,%_>?`:#@'="~^[]{}\                      02710000
      **                                                                02720000
      ******************************************************************02730000
       PROCEDURE DIVISION.                                              
      ******************************************************************02750000
      **                                                                02760000
      *================================================================*02770000
       0000-MAIN-PROCESS.                                               
      *================================================================*02790000
      *                                                                 02800000
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
      *                                                                 02820000
           PERFORM 7000-READ-FCSBW71       THRU 7000-EXIT.              
      *                                                                 02840000
           IF NO-MORE-DATA                                              
              DISPLAY 'EMPTY INPUT FILE'                                
           END-IF.                                                      
      *                                                                 02880000
           PERFORM 0700-INITIAL-TAGS       THRU 0700-EXIT.              
      *                                                                 02900000
           PERFORM 1000-PROCESS-BW71       THRU 1000-EXIT               
                                       UNTIL NO-MORE-DATA.              
      *                                                                 02930000
           PERFORM 1900-END-TAGS           THRU 1900-EXIT.              
      *                                                                 02950000
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
      *                                                                 02970000
           STOP RUN.                                                    
      *                                                                 02990000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03020000
      *================================================================*03030000
       0100-INITIALIZATION.                                             
      *================================================================*03050000
      *                                                                 03060000
           DISPLAY '*******************************************'        
           DISPLAY 'DATE COMPILED: ' FUNCTION WHEN-COMPILED.            
           DISPLAY '*******************************************'        
           DISPLAY ' '                                                  
      *                                                                 03110000
           OPEN INPUT FCSBW71-FILE.                                     
           IF  FBW71-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FILE OPEN ERROR'                                
               DISPLAY 'FCSBW71 FILE STATUS ==>' WS-FBW71-STATUS        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSBW73-FILE.                                    
           IF  FBW73-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FILE OPEN ERROR'                                
               DISPLAY 'FCSBW73 FILE STATUS ==>' WS-FBW73-STATUS        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           MOVE SPACES TO FIOBW73.                                      
      *                                                                 03310000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03340000
      *================================================================*03350000
       0700-INITIAL-TAGS.                                               
      *================================================================*03370000
      *                                                                 03380000
           MOVE WS-VERSION-TAG             TO WS-OUT-REC.               
           PERFORM 8100-WRITE-XML          THRU 8100-EXIT.              
      *                                                                 03410000
           MOVE WS-IMPORT-TAG              TO WS-OUT-REC.               
           PERFORM 8100-WRITE-XML          THRU 8100-EXIT.              
      *                                                                 03440000
           MOVE WS-WORKSETS-TAG            TO WS-OUT-REC.               
           PERFORM 8100-WRITE-XML          THRU 8100-EXIT.              
      *                                                                 03470000
       0700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03500000
      *================================================================*03510000
       1000-PROCESS-BW71.                                               
      *================================================================*03530000
      *                                                                 03540000
      *****WORK SET                                                     03550000
           PERFORM 1100-BUILD-WORK-SET     THRU 1100-EXIT               
           MOVE WS-XML-STRING (SUB1)       TO WS-WORK-SET-END           
           COMPUTE SUB1     =  SUB1 - 1                                 
           MOVE E-FBW71-WORK-SET-ID        TO WS-PREV-WORK-SET-ID       
           PERFORM 1200-PROCESS-WORK       THRU 1200-EXIT               
               UNTIL E-FBW71-WORK-SET-ID NOT = WS-PREV-WORK-SET-ID      
               OR NO-MORE-DATA .                                        
           MOVE WS-WORK-SET-END            TO WS-OUT-REC.               
           PERFORM 8100-WRITE-XML          THRU 8100-EXIT.              
      *                                                                 03650000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03680000
      *================================================================*03690000
       1100-BUILD-WORK-SET.                                             
      *================================================================*03710000
      *                                                                 03720000
           MOVE E-FBW71-WORK-SET-ID        TO WorkSetID                 
           MOVE E-FBW71-WORK-SET-TYPE      TO WorkSetType               
           MOVE E-FBW71-OPTIMUM-RD-DATE    TO ScheduledReadDate         
           MOVE E-FBW71-READ-CYCLE         TO Cycle                     
           MOVE E-FBW71-CRITICAL-RD-DATE   TO CriticalReadDate          
           MOVE E-FBW71-FILTERING-INFO     TO FilteringInformation.     
      *                                                                 03790000
           MOVE SPACE                  TO WS-XML-OUT                    
           XML GENERATE WS-XML-OUT FROM WorkSet                         
           END-XML.                                                     
      *                                                                 03830000
           MOVE SPACE                  TO WS-PARSE-WORK                 
           MOVE WS-DEPTH-WSET          TO WS-DEPTH                      
           MOVE 0                      TO WS-DAT-POS                    
           MOVE 1                      TO WS-ELE-POS                    
      *                                                                 03880000
           XML PARSE WS-XML-OUT PROCESSING                              
                PROCEDURE 2000-PROCESS-XML                              
             ON EXCEPTION                                               
                DISPLAY '  1100-BUILD-WORK-SET '                        
                DISPLAY '  ACCOUNT    ' E-FBW71-ACCOUNT-NO              
                DISPLAY '  METER      ' E-FBW71-METER-NO                
                DISPLAY '  WORKSET-ID ' E-FBW71-WORK-SET-ID             
                DISPLAY '  XML-CODE   ' XML-CODE                        
                DISPLAY '  XML-EVENT  ' XML-EVENT                       
                DISPLAY '  XML-TEXT   ' XML-TEXT                        
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-XML.                                                     
      *                                                                 04010000
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04040000
      *================================================================*04050000
       1200-PROCESS-WORK.                                               
      *================================================================*04070000
A05081*** Some code moved here from 1220- and removed 1224- para totally04080000
A05081*                                                                 04090000
           PERFORM 1210-BUILD-WORK-CUSTOMER    THRU 1210-EXIT           
           MOVE WS-XML-STRING (SUB1)       TO WS-WORK-END               
           COMPUTE SUB1     =  SUB1 - 1                                 
           MOVE WS-XML-STRING (SUB1)       TO WS-CUSTOMER-END           
           COMPUTE SUB1     =  SUB1 - 1                                 
      *                                                                 04150000
           PERFORM 1222-BUILD-METER        THRU 1222-EXIT.              
           MOVE WS-XML-STRING (SUB1)       TO WS-METER-END              
           COMPUTE SUB1     =  SUB1 - 1                                 
      *                                                                 04190000
           MOVE SPACES                 TO WS-CUSTOM-DATA-IN             
           MOVE E-FBW71-LOCAL-OFFICE   TO WS-LOCAL-OFFICE               
           MOVE E-FBW71-READ-ROUTE     TO WS-READ-ROUTE                 
           MOVE E-FBW71-SEQ-REQUIRED   TO WS-READ-SEQ-REQ               
           MOVE E-FBW71-MTR-READ-SOURCE-CD TO WS-MTR-READ-SOURCE-CD     
           MOVE E-FBW71-RRI                TO WS-RRI                    
           MOVE E-FBW71-PGM-ID             TO WS-PGM-ID                 
           MOVE E-FBW71-DMT                TO WS-DMT                    
           MOVE WS-DEPTH8                  TO WS-DEPTH                  
      *                                                                 04290000
           IF WS-CUSTOM-DATA-IN > SPACES                                
              PERFORM 1232-BUILD-CUSTOMDATA-FIELD THRU 1232-EXIT        
           END-IF.                                                      
      *                                                                 04330000
           IF E-FBW71-LATITUDE NOT = 0                                  
              AND E-FBW71-LONGITUDE NOT = 0                             
              PERFORM 1223-BUILD-LAT-LONG  THRU 1223-EXIT               
           END-IF.                                                      
      *                                                                 04380000
           MOVE E-FBW71-ACCOUNT-NO             TO WS-PREV-ACCOUNT-NO    
           MOVE E-FBW71-METER-NO               TO WS-PREV-METER-NO      
           MOVE E-FBW71-UTL-TYPE               TO WS-PREV-UTL-TYPE      
      *                                                                 04420000
           PERFORM 1220-PROCESS-METERS         THRU 1220-EXIT           
               UNTIL E-FBW71-ACCOUNT-NO  NOT = WS-PREV-ACCOUNT-NO       
                  OR E-FBW71-METER-NO    NOT = WS-PREV-METER-NO         
                  OR E-FBW71-UTL-TYPE    NOT = WS-PREV-UTL-TYPE         
                  OR E-FBW71-WORK-SET-ID NOT = WS-PREV-WORK-SET-ID      
                  OR NO-MORE-DATA .                                     
      *                                                                 04490000
           COMPUTE SUB1     =  SUB1 + 1                                 
           MOVE WS-METER-END           TO WS-XML-STRING (SUB1).         
      *                                                                 04520000
           COMPUTE SUB1     =  SUB1 + 1                                 
           MOVE WS-CUSTOMER-END        TO       WS-XML-STRING (SUB1)    
           COMPUTE SUB1     =  SUB1 + 1                                 
           MOVE WS-WORK-END            TO       WS-XML-STRING (SUB1)    
      *                                                                 04570000
           PERFORM 8000-LOAD-FILE   THRU 8000-EXIT.                     
           MOVE ZERO                   TO SUB1.                         
           INITIALIZE       WS-XML-ARRAY.                               
      *                                                                 04610000
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04640000
      *================================================================*04650000
       1210-BUILD-WORK-CUSTOMER.                                        
      *================================================================*04670000
      *                                                                 04680000
      *****WORK                                                         04690000
           MOVE E-FBW71-SEQUENCE-NUMBER    TO SequenceNumber            
           MOVE E-FBW71-WORK-TYPE          TO WorkType                  
      *****CUSTOMER                                                     04720000
           MOVE 1                          TO SequenceWithinWork        
A05081     IF E-FBW71-FULLL-NAME = WS-PREV-FULL-NAME                    
A05081        CONTINUE                                                  
A05081     ELSE                                                         
A05081        MOVE E-FBW71-FULLL-NAME      TO WS-SRC-STR1               
A05081                                        WS-SRC-STR2               
A05081                                        WS-PREV-FULL-NAME         
A05081        MOVE 'FULLL-NAME'            TO WS-EXCEPTION-FIELD        
A05081        PERFORM 3100-REMOVE-NON-EBCDIC  THRU 3100-EXIT            
A05081        MOVE WS-SRC-STR2             TO WS-FULL-NAME              
A05081     END-IF.                                                      
A05081     IF E-FBW71-STREET-ADDRESS = WS-PREV-STREET-ADDRESS           
A05081        CONTINUE                                                  
A05081     ELSE                                                         
A05081        MOVE E-FBW71-STREET-ADDRESS  TO WS-SRC-STR1               
A05081                                        WS-SRC-STR2               
A05081                                        WS-PREV-STREET-ADDRESS    
A05081        MOVE 'STREET-ADDRESS'        TO WS-EXCEPTION-FIELD        
A05081        PERFORM 3100-REMOVE-NON-EBCDIC  THRU 3100-EXIT            
A05081        MOVE WS-SRC-STR2             TO WS-STREET-ADDRESS         
A05081     END-IF.                                                      
A05081     MOVE WS-FULL-NAME              TO FullName                   
A05081     MOVE WS-STREET-ADDRESS          TO FullStreetAddress         
           MOVE E-FBW71-ACCOUNT-NO         TO AccountNumber             
           MOVE E-FBW71-COMPANY-NO         TO CompanyID                 
      *                                                                 04980000
           MOVE SPACE                  TO WS-XML-OUT                    
           XML GENERATE WS-XML-OUT FROM Work                            
           END-XML.                                                     
      *                                                                 05020000
           MOVE SPACE                  TO WS-PARSE-WORK                 
           MOVE WS-DEPTH-WORK          TO WS-DEPTH                      
           MOVE 0                      TO WS-DAT-POS                    
           MOVE 1                      TO WS-ELE-POS                    
      *                                                                 05070000
           XML PARSE WS-XML-OUT PROCESSING                              
                PROCEDURE 2000-PROCESS-XML                              
             ON EXCEPTION                                               
                DISPLAY '  1210-BUILD-WORK-CUSTOMER '                   
                DISPLAY '  ACCOUNT    ' E-FBW71-ACCOUNT-NO              
                DISPLAY '  METER      ' E-FBW71-METER-NO                
                DISPLAY '  WORKSET-ID ' E-FBW71-WORK-SET-ID             
                DISPLAY '  XML-CODE   ' XML-CODE                        
                DISPLAY '  XML-EVENT  ' XML-EVENT                       
                DISPLAY '  XML-TEXT   ' XML-TEXT                        
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-XML.                                                     
      *                                                                 05200000
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05230000
      *================================================================*05240000
       1220-PROCESS-METERS.                                             
      *================================================================*05260000
      *                                                                 05270000
           PERFORM 1226-BUILD-MTR-SESSION  THRU 1226-EXIT.              
      *                                                                 05290000
           MOVE WS-XML-STRING (SUB1)       TO WS-METER-SESSION-END      
           COMPUTE SUB1     =  SUB1 - 1                                 
      *                                                                 05320000
           MOVE SPACES                  TO WS-CUSTOM-DATA-IN            
P00251     MOVE E-FBW71-CODE-USAGE-TYPE TO WS-CODE-USAGE-TYPE           
P00251     MOVE E-FBW71-CODE-USAGE-ID   TO WS-CODE-USAGE-ID             
P00251     MOVE E-FBW71-CODE-USAGE-SOURCE TO WS-CODE-USAGE-SOURCE       
           MOVE E-FBW71-TIME-PERIOD     TO WS-TIME-PERIOD               
           MOVE E-FBW71-CODE-TOU-SEASN  TO WS-CODE-TOU-SEASN            
           MOVE E-FBW71-INDEX-VALUE-CD  TO WS-INDEX-VALUE-CD            
           MOVE E-FBW71-CNSMPTN-READ-FL TO WS-CNSMPTN-READ-FL           
           MOVE WS-DEPTH10              TO WS-DEPTH                     
      *                                                                 05420000
           IF WS-CUSTOM-DATA-IN > SPACES                                
              PERFORM 1232-BUILD-CUSTOMDATA-FIELD THRU 1232-EXIT        
           END-IF.                                                      
      *                                                                 05460000
           MOVE E-FBW71-RRI            TO WS-REMOTE-READ-IND            
           IF E-FBW71-ENDPOINT-ID IS NUMERIC                            
              AND E-FBW71-ENDPOINT-ID > ZEROS                           
              AND AMR-MTR                                               
              PERFORM 1228-BUILD-MTR-SESSION-RF THRU 1228-EXIT          
           END-IF.                                                      
      *                                                                 05530000
           IF OPTICAL-PROB-MTR                                          
              PERFORM 1230-BUILD-MTR-SESSION-OPT THRU 1230-EXIT         
           END-IF.                                                      
                                                                        
           COMPUTE SUB1     =  SUB1 + 1                                 
           MOVE WS-METER-SESSION-END   TO WS-XML-STRING (SUB1)          
      *                                                                 05600000
           PERFORM 7000-READ-FCSBW71   THRU 7000-EXIT.                  
      *                                                                 05620000
       1220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05650000
      *================================================================*05660000
       1222-BUILD-METER.                                                
      *================================================================*05680000
      *                                                                 05690000
      *****METER                                                        05700000
           MOVE E-FBW71-CODE-MTR-LOCATION  TO InstructionLocationCode1. 
           MOVE E-FBW71-CODE-MTR-RD-INST1  TO InstructionLocationCode2. 
           MOVE E-FBW71-READ-SEQ           TO UtilityMeterSequenceNumber
           MOVE E-FBW71-METER-NO           TO MeterNumber.              
           MOVE E-FBW71-METER-CATEGORY     TO MeterCategory.            
           MOVE E-FBW71-METER-TYPE         TO MeterType.                
           MOVE E-FBW71-ACTIVE-INDICATOR   TO ActiveIndicator.          
           MOVE E-FBW71-GROUP-FLAG         TO GroupFlag.                
           MOVE E-FBW71-ACCOUNT-TYPE-CODE  TO BillCode.                 
           MOVE E-FBW71-SEGMENT            TO Xegment.                  
A05081     IF E-FBW71-SPCL-READ-INSTR = WS-PREV-SPCL-READ-INSTR         
A05081        CONTINUE                                                  
A05081     ELSE                                                         
A05081        MOVE E-FBW71-SPCL-READ-INSTR TO WS-SRC-STR1               
A05081                                        WS-SRC-STR2               
A05081                                        WS-PREV-SPCL-READ-INSTR   
A05081        IF E-FBW71-SPCL-READ-INSTR = SPACES                       
A05081           MOVE SPACES               TO WS-SPCL-READ-INSTR        
A05081        ELSE                                                      
A05081           MOVE 'SPCL-READ-INSTR'    TO WS-EXCEPTION-FIELD        
A05081           PERFORM 3100-REMOVE-NON-EBCDIC  THRU 3100-EXIT         
A05081           MOVE WS-SRC-STR2             TO WS-SPCL-READ-INSTR     
A05081        END-IF                                                    
A05081     END-IF.                                                      
A05081     MOVE WS-SPCL-READ-INSTR         TO SpecialMessage.           
           MOVE E-FBW71-SPL-MSG-BEEP-FLAG  TO SpecialMessageBeepFlag.   
           MOVE E-FBW71-SPL-MSG-INDICATOR  TO SpecialMessageIndicator.  
      *                                                                 05980000
A05081     MOVE E-FBW71-COMPANY-NO         TO WS-SP-COMPANY-NO          
           MOVE E-FBW71-PREMISE-NO         TO WS-SP-PREMISE-NO          
A05081     MOVE E-FBW71-UTL-TYPE           TO WS-SP-UTIL-TYPE           
           MOVE E-FBW71-IC-NO              TO WS-SP-IC-NO               
           MOVE E-FBW71-MTR-REF-NO         TO WS-SP-MTR-REF-NO          
           MOVE WS-SERVICEPOINTID          TO ServicePointID.           
      *                                                                 06050000
           MOVE SPACE                  TO WS-XML-OUT                    
           XML GENERATE WS-XML-OUT FROM Meter                           
           END-XML.                                                     
      *                                                                 06090000
           INSPECT WS-XML-OUT REPLACING ALL 'Xegment'                   
                                       BY 'Segment'                     
      *                                                                 06120000
           MOVE SPACE                  TO WS-PARSE-WORK                 
           MOVE WS-DEPTH-METER         TO WS-DEPTH                      
           MOVE 0                      TO WS-DAT-POS                    
           MOVE 1                      TO WS-ELE-POS                    
      *                                                                 06170000
           XML PARSE WS-XML-OUT PROCESSING                              
                PROCEDURE 2000-PROCESS-XML                              
             ON EXCEPTION                                               
                DISPLAY '  1222-BUILD-METER '                           
                DISPLAY '  ACCOUNT    ' E-FBW71-ACCOUNT-NO              
                DISPLAY '  METER      ' E-FBW71-METER-NO                
                DISPLAY '  WORKSET-ID ' E-FBW71-WORK-SET-ID             
                DISPLAY '  XML-CODE   ' XML-CODE                        
                DISPLAY '  XML-EVENT  ' XML-EVENT                       
                DISPLAY '  XML-TEXT   ' XML-TEXT                        
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-XML.                                                     
      *                                                                 06300000
       1222-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06330000
      *================================================================*06340000
       1223-BUILD-LAT-LONG.                                             
      *================================================================*06360000
      *                                                                 06370000
           MOVE E-FBW71-LATITUDE       TO Latitude                      
           MOVE E-FBW71-LONGITUDE      TO Longitude                     
      *                                                                 06400000
           MOVE SPACE                  TO WS-XML-OUT                    
           XML GENERATE WS-XML-OUT FROM GPSInformation                  
           END-XML.                                                     
      *                                                                 06440000
           MOVE WS-XML-OUT             TO WS-GPS-DATA                   
      *                                                                 06460000
           COMPUTE SUB1     =  SUB1 + 1                                 
           MOVE WS-GPS-TAG             TO WS-XML-STRING (SUB1).         
      *                                                                 06490000
       1223-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06520000
      *================================================================*06530000
       1226-BUILD-MTR-SESSION.                                          
      *================================================================*06550000
      *                                                                 06560000
      *****MeterSessionInput                                            06570000
           MOVE E-FBW71-NO-READ-DIALS      TO NumberDials.              
           MOVE E-FBW71-NO-READ-DECIMALS   TO NumberDecimals.           
           MOVE E-FBW71-PREV-READ-VALUE    TO PreviousRead.             
           MOVE E-FBW71-CONSTANT           TO ConstantMultiplier.       
           MOVE E-FBW71-READ-TYPE-CODE     TO ReadTypeCode.             
           MOVE E-FBW71-READ-METHOD        TO ReadMethod.               
           MOVE E-FBW71-PROMPT-CODE        TO PromptCode.               
           MOVE E-FBW71-TEXT-PROMPT        TO TextPrompt.               
           MOVE E-FBW71-CONSECUTIVE-ESTIMATES                           
                                           TO ConsecutiveEstimates.     
           MOVE E-FBW71-TYPE-OF-VALIDATION-IND                          
                                           TO TypeOfValidationIndicator.
           MOVE E-FBW71-HI1                TO Hi1.                      
           MOVE E-FBW71-HI2                TO Hi2.                      
           MOVE E-FBW71-LOW1               TO Low1.                     
           MOVE E-FBW71-LOW2               TO Low2.                     
      *                                                                 06740000
           MOVE SPACE                  TO WS-XML-OUT                    
           XML GENERATE WS-XML-OUT FROM MeterSessionInput               
           END-XML.                                                     
      *                                                                 06780000
           MOVE SPACE                  TO WS-PARSE-WORK                 
           MOVE WS-DEPTH-MSI           TO WS-DEPTH                      
           MOVE 0                      TO WS-DAT-POS                    
           MOVE 1                      TO WS-ELE-POS                    
      *                                                                 06830000
           XML PARSE WS-XML-OUT PROCESSING                              
                PROCEDURE 2000-PROCESS-XML                              
             ON EXCEPTION                                               
                DISPLAY '  1226-BUILD-MTR-SESSION '                     
                DISPLAY '  ACCOUNT    ' E-FBW71-ACCOUNT-NO              
                DISPLAY '  METER      ' E-FBW71-METER-NO                
                DISPLAY '  WORKSET-ID ' E-FBW71-WORK-SET-ID             
                DISPLAY '  XML-CODE   ' XML-CODE                        
                DISPLAY '  XML-EVENT  ' XML-EVENT                       
                DISPLAY '  XML-TEXT   ' XML-TEXT                        
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-XML.                                                     
      *                                                                 06960000
       1226-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06990000
      *================================================================*07000000
       1228-BUILD-MTR-SESSION-RF.                                       
      *================================================================*07020000
      *                                                                 07030000
      *****MeterSessionInputRF                                          07040000
           MOVE E-FBW71-RF-FREQUENCY       TO RFFrequency.              
           MOVE E-FBW71-ENDPOINT-ID        TO EndpointID.               
           MOVE E-FBW71-ENDPOINT-TYPE      TO EndpointType.             
           MOVE E-FBW71-WAKEUP-TONE        TO WakeupTone.               
           MOVE E-FBW71-TAMPER-COUNT1      TO TamperCount1.             
           MOVE E-FBW71-TAMPER-COUNT2      TO TamperCount2.             
           MOVE E-FBW71-SS-DEMAND-IND      TO SolidStateDemandIndicator 
      *                                                                 07120000
           MOVE SPACE                  TO WS-XML-OUT                    
           XML GENERATE WS-XML-OUT FROM MeterSessionInputRF             
           END-XML.                                                     
      *                                                                 07160000
           MOVE SPACE                  TO WS-PARSE-WORK                 
           MOVE WS-DEPTH-MSIRF         TO WS-DEPTH                      
           MOVE 0                      TO WS-DAT-POS                    
           MOVE 1                      TO WS-ELE-POS                    
      *                                                                 07210000
           XML PARSE WS-XML-OUT PROCESSING                              
                PROCEDURE 2000-PROCESS-XML                              
             ON EXCEPTION                                               
                DISPLAY '  1228-BUILD-MTR-SESSION-RF '                  
                DISPLAY '  ACCOUNT    ' E-FBW71-ACCOUNT-NO              
                DISPLAY '  METER      ' E-FBW71-METER-NO                
                DISPLAY '  WORKSET-ID ' E-FBW71-WORK-SET-ID             
                DISPLAY '  XML-CODE   ' XML-CODE                        
                DISPLAY '  XML-EVENT  ' XML-EVENT                       
                DISPLAY '  XML-TEXT   ' XML-TEXT                        
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-XML.                                                     
      *                                                                 07340000
       1228-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07370000
      *================================================================*07380000
       1230-BUILD-MTR-SESSION-OPT.                                      
      *================================================================*07400000
      *                                                                 07410000
      *****MeterSessionInputOptical                                     07420000
           MOVE E-FBW71-METER-NO          TO RecorderID                 
           MOVE E-FBW71-TOU-IDR-DEVICE-ID TO DeviceID                   
           MOVE E-FBW71-TIM-NAME          TO TIMName                    
           MOVE E-FBW71-PASSWORD-ID       TO PasswordID                 
           MOVE E-FBW71-DAISY-CHAIN-FLAG  TO DaisyChainFlag             
           MOVE E-FBW71-DAYLIGHT-SAVING-FLAG TO  DaylightSavingTimeFlag 
           MOVE E-FBW71-READ-LOAD-PROFILE-IND                           
                                       TO ReadLoadProfileIndicator      
           MOVE E-FBW71-VISUAL-READ-FLAG   TO VisualReadFlag            
           MOVE E-FBW71-TOU-REG-READ-FLAG  TO TOURegisterReadFlag       
           MOVE E-FBW71-RESET-DEMAND-FLAG  TO ResetDemandFlag           
           MOVE E-FBW71-DST-UPDATE-FLAG                                 
                                       TO DaylightSavingTimeUpdateFlag  
           MOVE E-FBW71-STATUS-CHECK-FLAG  TO StatusCheckFlag           
           MOVE E-FBW71-LAST-LP-RD-DATETIME                             
                                        TO LastLoadProfileReadDateTime  
                                                                        
           MOVE SPACES                    TO TOUReadItemListID          
           STRING E-FBW71-DMT DELIMITED BY ' '                          
                  '-'         DELIMITED BY SIZE                         
                  E-FBW71-PGM-ID DELIMITED BY ' '                       
              INTO TOUReadItemListID                                    
      *                                                                 07650000
           MOVE SPACE                  TO WS-XML-OUT                    
           XML GENERATE WS-XML-OUT FROM MeterSessionInputOptical        
           END-XML.                                                     
      *                                                                 07690000
           MOVE SPACE                  TO WS-PARSE-WORK                 
           MOVE WS-DEPTH-MSIOPT        TO WS-DEPTH                      
           MOVE 0                      TO WS-DAT-POS                    
           MOVE 1                      TO WS-ELE-POS                    
      *                                                                 07740000
           XML PARSE WS-XML-OUT PROCESSING                              
                PROCEDURE 2000-PROCESS-XML                              
             ON EXCEPTION                                               
                DISPLAY '  1230-BUILD-MTR-SESSION-OPT '                 
                DISPLAY '  ACCOUNT    ' E-FBW71-ACCOUNT-NO              
                DISPLAY '  METER      ' E-FBW71-METER-NO                
                DISPLAY '  WORKSET-ID ' E-FBW71-WORK-SET-ID             
                DISPLAY '  XML-CODE   ' XML-CODE                        
                DISPLAY '  XML-EVENT  ' XML-EVENT                       
                DISPLAY '  XML-TEXT   ' XML-TEXT                        
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-XML.                                                     
      *                                                                 07870000
       1230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07900000
      *================================================================*07910000
       1232-BUILD-CUSTOMDATA-FIELD.                                     
      *================================================================*07930000
      *                                                                 07940000
           MOVE WS-CUSTOM-DATA-IN  TO CustomData                        
           MOVE ZERO               TO Xequence                          
      *                                                                 07970000
           MOVE SPACE                  TO WS-XML-OUT                    
           XML GENERATE WS-XML-OUT FROM CustomDataField                 
           END-XML.                                                     
      *                                                                 08010000
           INSPECT WS-XML-OUT REPLACING ALL 'Xequence'                  
                                       BY 'Sequence'                    
      *                                                                 08040000
           COMPUTE SUB1     =  SUB1 + 1                                 
           MOVE SPACES                 TO WS-XML-STRING (SUB1)          
           MOVE WS-XML-OUT TO WS-XML-STRING (SUB1)(WS-DEPTH + 1:).      
      *                                                                 08080000
       1232-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08110000
      *================================================================*08120000
       1900-END-TAGS.                                                   
      *================================================================*08140000
      *                                                                 08150000
           MOVE WS-WORKSETS-END-TAG       TO WS-OUT-REC.                
           PERFORM 8100-WRITE-XML         THRU 8100-EXIT.               
      *                                                                 08180000
           MOVE WS-IMPORT-END-TAG         TO WS-OUT-REC.                
           PERFORM 8100-WRITE-XML          THRU 8100-EXIT.              
      *                                                                 08210000
           DISPLAY '  '.                                                
           DISPLAY '*******************************************'.       
           DISPLAY '*** PCSBW173 HAS SUCCESSFULLY COMPLETED ***'.       
           DISPLAY '*******************************************'.       
           DISPLAY '  '.                                                
      *                                                                 08270000
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08300000
      *================================================================*08310000
       2000-PROCESS-XML.                                                
      *================================================================*08330000
      *                                                                 08340000
           EVALUATE XML-EVENT                                           
              WHEN 'START-OF-ELEMENT'                                   
                 IF PREV-IS-ROOT                                        
                    MOVE SPACES TO WS-OUT-REC                           
                    IF WS-DEPTH > 1                                     
                       MOVE WS-TEMP-VAR(1:WS-ELE-POS - 1)               
                             TO WS-OUT-REC(2 * WS-DEPTH - 1:)           
                    ELSE                                                
                       MOVE WS-TEMP-VAR(1:WS-ELE-POS - 1)               
                             TO WS-OUT-REC                              
                    END-IF                                              
                    PERFORM 5000-LOAD-XML THRU 5000-EXIT                
                 END-IF                                                 
                 SET PREV-IS-ROOT TO TRUE                               
                 COMPUTE WS-DEPTH = WS-DEPTH + 1                        
                 MOVE 1 TO WS-ELE-POS                                   
                 STRING '<' XML-TEXT '>' DELIMITED BY SIZE              
                      INTO WS-TEMP-VAR                                  
                      WITH POINTER WS-ELE-POS                           
                 MOVE WS-ELE-POS TO WS-DAT-POS                          
              WHEN 'CONTENT-CHARACTERS'                                 
                 STRING XML-TEXT DELIMITED BY SIZE                      
                      INTO WS-TEMP-VAR                                  
                      WITH POINTER WS-DAT-POS                           
              WHEN 'CONTENT-CHARACTER'                                  
                 PERFORM 3000-HANDLE-SPL-CHAR THRU 3000-EXIT            
                 STRING WS-SPL-CHAR DELIMITED BY SPACE                  
                       INTO WS-TEMP-VAR                                 
                       WITH POINTER WS-DAT-POS                          
              WHEN 'END-OF-ELEMENT'                                     
                 SET PREV-IS-NOT-ROOT TO TRUE                           
                 STRING '</' XML-TEXT '>' DELIMITED BY SIZE             
                      INTO WS-TEMP-VAR                                  
                      WITH POINTER WS-DAT-POS                           
                 MOVE SPACES TO WS-OUT-REC                              
                 IF WS-DEPTH > 1                                        
                    MOVE WS-TEMP-VAR(1:WS-DAT-POS - 1)                  
                         TO WS-OUT-REC(2 * WS-DEPTH - 1:)               
                 ELSE                                                   
                    MOVE WS-TEMP-VAR(1:WS-DAT-POS - 1)                  
                         TO WS-OUT-REC                                  
                 END-IF                                                 
                 PERFORM 5000-LOAD-XML  THRU 5000-EXIT                  
                 COMPUTE WS-DEPTH = WS-DEPTH - 1                        
                 MOVE 1 TO WS-DAT-POS                                   
              WHEN OTHER                                                
                   CONTINUE                                             
              END-EVALUATE.                                             
      *                                                                 08830000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08860000
      *================================================================*08870000
       3000-HANDLE-SPL-CHAR.                                            
      *================================================================*08890000
      *                                                                 08900000
           MOVE SPACES           TO WS-SPL-CHAR                         
      *                                                                 08920000
           EVALUATE XML-TEXT                                            
              WHEN '&'                                                  
                 MOVE '&amp;'          TO WS-SPL-CHAR                   
              WHEN '>'                                                  
                 MOVE '&gt;'           TO WS-SPL-CHAR                   
              WHEN '<'                                                  
                 MOVE '&lt;'           TO WS-SPL-CHAR                   
              WHEN '"'                                                  
                 MOVE '&quot;'         TO WS-SPL-CHAR                   
              WHEN "'"                                                  
                 MOVE '&apos;'         TO WS-SPL-CHAR                   
              WHEN OTHER                                                
                 MOVE XML-TEXT         TO WS-SPL-CHAR                   
                 DISPLAY 'UN-HANDLED SPECIAL CHAR: ' WS-SPL-CHAR        
           END-EVALUATE                                                 
           .                                                            
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09110000
A05081*================================================================*09120000
A05081 3100-REMOVE-NON-EBCDIC.                                          
A05081*================================================================*09140000
A05081**** 1ST INSPECT CONVERT ALL KNOWN EBCDIC CHAR'S TO SPACES        09150000
A05081**** 2ND INSPECT CONVERT NON-EBCDIC CHAR'S TO SPACES,IF FOUND.    09160000
A05081*                                                                 09170000
A05081     INSPECT WS-SRC-STR1 CONVERTING                               
A05081         WS-CONVERT-FROM1 TO WS-CONVERT-TO1                       
A05081*                                                                 09200000
A05081     IF WS-SRC-STR1 = SPACES                                      
A05081        CONTINUE                                                  
A05081     ELSE                                                         
A05081*                                                                 09240000
A05081        DISPLAY '****************************************'        
A05081        DISPLAY '** NON-EBCDIC CHARECTERS REMOVING ..  **'        
A05081        DISPLAY '** ACCOUNT NO: ' E-FBW71-ACCOUNT-NO              
A05081        DISPLAY '** WORKSET-ID: ' E-FBW71-WORK-SET-ID             
A05081        DISPLAY '** EXCEPTION FIELD: ' WS-EXCEPTION-FIELD         
A05081        DISPLAY '** FIELD VALUE: ' WS-SRC-STR2                    
A05081        DISPLAY '****************************************'        
A05081*                                                                 09320000
A05081        INSPECT WS-SRC-STR2 CONVERTING                            
A05081           WS-SRC-STR1 TO WS-CONVERT-TO2                          
A05081     END-IF.                                                      
A05081                                                                  
A05081 3100-EXIT.                                                       
A05081     EXIT.                                                        
      *                                                                 09390000
      *================================================================*09400000
       5000-LOAD-XML.                                                   
      *================================================================*09420000
      *                                                                 09430000
           COMPUTE SUB1   = SUB1 + 1                                    
           IF SUB1 > 999                                                
              DISPLAY '  5000-LOAD-XML '                                
              DISPLAY '  ARRAY OVERFLOW ' SUB1                          
              DISPLAY '  ACCOUNT    ' E-FBW71-ACCOUNT-NO                
              DISPLAY '  METER      ' E-FBW71-METER-NO                  
              DISPLAY '  WORKSET-ID ' E-FBW71-WORK-SET-ID               
              DISPLAY '  XML-CODE   ' XML-CODE                          
              DISPLAY '  XML-EVENT  ' XML-EVENT                         
              DISPLAY '  XML-TEXT   ' XML-TEXT                          
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
           MOVE WS-OUT-REC             TO WS-XML-STRING (SUB1).         
                                                                        
      *                                                                 09580000
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09610000
      *================================================================*09620000
       7000-READ-FCSBW71.                                               
      *================================================================*09640000
      *                                                                 09650000
           READ FCSBW71-FILE                                            
               AT END                                                   
                   MOVE 'Y'            TO WS-NO-MORE-DATA               
                   GO                  TO 7000-EXIT.                    
      *                                                                 09700000
           IF E-FBW71-COMPANY-NO = '99'                                 
              SET NO-MORE-DATA TO TRUE                                  
           END-IF                                                       
           IF FBW71-SUCCESSFUL OR NO-MORE-DATA                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7000-ERROR ON FCSBW71 READ. STATUS IS '          
                                                   WS-FBW71-STATUS      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09830000
      *================================================================*09840000
       8000-LOAD-FILE.                                                  
      *================================================================*09860000
      *                                                                 09870000
           PERFORM VARYING SUB2 FROM 1 BY 1 UNTIL SUB2 > SUB1           
                            OR WS-XML-STRING(SUB2) = SPACES             
              MOVE WS-XML-STRING (SUB2)   TO WS-OUT-REC                 
              PERFORM 8100-WRITE-XML    THRU 8100-EXIT                  
           END-PERFORM.                                                 
      *                                                                 09930000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09960000
      *================================================================*09970000
       8100-WRITE-XML.                                                  
      *================================================================*09990000
      *                                                                 10000000
           MOVE WS-OUT-REC             TO FIOBW73.                      
           WRITE FIOBW73.                                               
                                                                        
           IF FBW73-SUCCESSFUL                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '8000-ERROR ON FCSBW73 WRITE'                     
              DISPLAY 'FCSBW73 FILE STATUE IS ==>' WS-FBW73-STATUS      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10140000
      *================================================================*10150000
       9000-TERMINATE.                                                  
      *================================================================*10170000
      *                                                                 10180000
           CLOSE FCSBW71-FILE.                                          
                                                                        
           IF  FBW71-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FILE CLOSE ERROR'                               
               DISPLAY 'FCSBW71 FILE STATUS ==>' WS-FBW71-STATUS        
           END-IF.                                                      
                                                                        
           CLOSE FCSBW73-FILE.                                          
      *                                                                 10290000
           IF  FBW73-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FILE CLOSE ERROR'                               
               DISPLAY 'FCSBW73 FILE STATUS ==>' WS-FBW73-STATUS        
           END-IF.                                                      
      *                                                                 10360000
       9000-EXIT.                                                       
           EXIT.                                                        
      *================================================================*10390000
       9900-ABEND.                                                      
      *================================================================*10410000
      *                                                                 10420000
           DISPLAY '*****************************************'          
           DISPLAY '**      PERFORMING 9900-ABEND          **'          
           DISPLAY '** ERROR OCCURED AND CAN NOT PROCEED.  **'          
           DISPLAY '** TERMINATING PROGRAM ...........     **'          
           DISPLAY '*****************************************'          
           PERFORM 9000-TERMINATE    THRU 9000-EXIT.                    
           MOVE 12  TO  RETURN-CODE.                                    
           STOP RUN.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10550000
      ****************** END OF PCSBW173 PROGRAM ***********************10560000
      ******************************************************************10570000
                                                                        
