       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW172.                                        
       DATE-WRITTEN.   MAY 2009.                                        
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **    DATE    INITIALS    REASON                              **          
      **  ________  ________    ___________________________________ **          
      **  05-04-09  SS95855     P#00135 New program written for FCS **          
      **  08-31-09  SS95855     Running Sequence number increases   **          
      **                        when there is change in Account or  **          
      **                        Meter or Util type.This change was  **          
      **                        due to Cust/Meter change - PCSBW173 **          
A01738**  02-22-10  NC94746     GAP UP MTR READ SEQUENCE NUMBER     **          
A01738**                        PROPERLY.                           **          
P00251** 01/25/10   SS95855      Net Metering (Re-gen due to copy   **          
      **                         book changes).                     **          
A04527** 05/20/13   SS95855     RE-GAP READ SEQUENCE FOR AMR METERS **          
      **                                                            **          
A04880** 27 JUN 14  RF10596     ADD CIRCUIT NUMBER FOR STORM        **          
      **                                                            **          
      ****************************************************************          
      *                       PCSBW172 NARRATIVE                     *  00230000
      *                  ___________________________                 *  00240000
      *                                                              *  00310000
      * The program re-sequences the Manual meters for easier read.  *  00310000
      * Re-gapping of Sequence number is done for Manual Meters that *          
      * does not have a Split route. AROP/Out of cycle reads will    *          
      * have a route 9999. If the meter is re-sequenced the new seq  *          
      * no. is updated in CSS_MTRD_ENVRNMT and CSS_REGISTER_READ.    *  00310000
      * For each route, CSS_ROUTE_HEADER table is updated with       *  00310000
      * no. of meters downloaded.                                    *  00310000
      ****************************************************************  00320000
           REMARKS.                                                     
             -- METER READ EXTRACTION FOR FIELD COLLECTION SYSTEM   --  
             ------- THIS IS A NEW PROGRAM WRITTEN FOR FCS     -------  
                                                                        
                    ---- BASIC BATCH SEQUENCE STRUCTURE ----            
                   0000 - 0000     MAIN CONTROL PATH                    
                    -------------------------------------------------   
                    ---------- INITIAL PROCESSING  1 TIME ONLY ------   
                   0100 - 0100     INITIALIZATION                       
                   0200 - 0200     READ AND CHECK JCL PARAMETERS        
                    -------------------------------------------------   
                    -----------  MAIN PROCESSING ROUTINES  ----------   
                   1000 - 1000     MAJOR PROCESSING LOOP                
                   3000 - 4990     COMMON PROCESSING                    
                   5000 - 5360     LOADING OF THE FCA21 FILE FOR        
                                       CREATING THE MRB'S.              
                    -------------------------------------------------   
                   7000 - 7999     INQUIRY CALLS TO DATABASES           
                   8000 - 8870     UPDATE CALLS TO DATABASES.           
                    -------------------------------------------------   
                   9000 - 9000     CLOSE FILES                          
                   9900 - 9900     ABEND/ABORT MODULES                  
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBW71A.                                                   00410000
       COPY CSSBW71B.                                                   00380000
      *                                                                 CSS00070
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBW71A.                                                           
       COPY FIOBW71A.                                                           
      *                                                                         
       COPY CFDBW71B.                                                           
       COPY FIOBW71B.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW172'.
MSQ017     COPY MFASQLM.
      *                                                                         
           EXEC SQL                                                     00540000
              INCLUDE SQLCA                                             00550000
           END-EXEC.                                                    00560000
      *                                                                         
           EXEC SQL                                                     00540000
              INCLUDE FIOCA00                                           00550000
           END-EXEC.                                                    00560000
      *                                                                         
           EXEC SQL                                                     00600000
              INCLUDE FIOJC01                                           00610000
           END-EXEC.                                                    00620000
      *                                                                         
      ***************************                                               
      *    CSS_JOB_PARM, G6                                                     
      ***************************                                               
           EXEC SQL                                                     00600000
              INCLUDE TBJBPARM                                          00610000
           END-EXEC.                                                    00620000
      *                                                                         
      ***************************                                               
      *    CSS_READ_RT_SOURCE, R4                                               
      ***************************                                               
           EXEC SQL                                                             
             INCLUDE TBRTSRCE                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************                                               
      *    CSS_ROUTE_HEADER, RH                                                 
      ***************************                                               
           EXEC SQL                                                             
             INCLUDE TBRTEHDR                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************                                               
      *    CSS_READ_WINDOW, RW                                                  
      ***************************                                               
           EXEC SQL                                                             
             INCLUDE TBRDWNDW                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************                                               
      *    CSS_MTRD_ENVRNMT, MN                                                 
      ***************************                                               
           EXEC SQL                                                             
             INCLUDE TBMTRENV                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************                                               
      *    CSS_REGISTER_READ, RG                                                
      ***************************                                               
           EXEC SQL                                                             
             INCLUDE TBRGREAD                                                   
           END-EXEC.                                                            
      *                                                                         
       01 WS-WORK-VARIABLES.                                            
          05 WS-START                       PIC X(40) VALUE             
               'WORKING STORAGE FOR PCSBW172 STARTS HERE'.              
      *                                                                         
       01 WS-SWITCH.                                                    
          05 WS-FBW71A-STATUS               PIC X(02) VALUE '00'.       
             88 FBW71A-SUCCESSFUL                     VALUE '00'.       
          05 WS-FBW71B-STATUS               PIC X(02) VALUE '00'.       
             88 FBW71B-SUCCESSFUL                      VALUE '00'.      
          05 WS-CHECK-END-OF-BW71A          PIC X(01) VALUE 'N'.        
             88 WS-END-OF-BW71A                       VALUE 'Y'.        
          05 WS-END-RECORD-REACHED          PIC X(01) VALUE 'N'.        
             88 END-RECORD-REACHED                    VALUE 'Y'.        
          05 WS-MTR-SEQ-REQ-SW              PIC X(01) VALUE 'Y'.        
             88 WS-MTR-SEQ-REQ                        VALUE 'Y'.        
             88 WS-MTR-SEQ-NOT-REQ                    VALUE 'N'.        
      *                                                                         
       01 WS-MISC.                                                      
A04527    05 WS-55                          PIC XX    VALUE '55'.       
          05 WS-PGRMNAME                    PIC X(08) VALUE 'PCSBW172'. 
          05 WS-N                           PIC X(01) VALUE 'N'.        
          05 WS-Y                           PIC X(01) VALUE 'Y'.        
          05 WS-YES                         PIC X(01) VALUE 'Y'.        
          05 WS-RESEQ-GAP                   PIC 9(07) VALUE ZERO.       
COB305    05 WS-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.    
          05 WS-COMPANY-NO                  PIC X(02) VALUE SPACES.     
          05 WS-LOCAL-OFFICE                PIC X(03) VALUE SPACES.     
          05 WS-PREV-WORK-SET-ID            PIC X(08) VALUE SPACES.     
          05 WS-PREV-READ-ROUTE             PIC 9(04) VALUE ZERO.       
          05 WS-PREV-LOCAL-OFFICE           PIC X(03) VALUE SPACES.     
          05 WS-PREV-UTL-TYPE               PIC X(01) VALUE SPACES.     
          05 WS-PREV-METER-NO               PIC X(09) VALUE SPACES.     
          05 WS-PREV-ACCOUNT-NO             PIC 9(13) VALUE ZERO.       
          05 WS-READ-SEQ                    PIC 9(09) VALUE ZERO.       
A01738    05 WS-TEMP-READ-SEQ               PIC 9(09) VALUE ZERO.       
          05 WS-RECORDS-RESEQUENCED         PIC 9(08) VALUE ZERO.       
          05 WS-DOWNLD-MTR-COUNT            PIC S9(8) USAGE COMP.       
          05 WS-DOWNLD-MTR-COUNT-DISP       PIC ZZZZZZZ9.               
          05 WS-RECORDS-READ                PIC S9(07) COMP-3 VALUE 0.  
          05 WS-RECORDS-WRITTEN             PIC S9(07) COMP-3 VALUE 0.  
          05 WS-TRAILER-RECORD              PIC X(08) VALUE '99999999'. 
          05 WS-SEQUENCE-NUMBER             PIC S9(07) COMP-3 VALUE 0.  
          05 WS-COMMIT-COUNT                PIC S9(07) COMP-3 VALUE 0.  
          05 WS-WORK-SET-ID.                                            
             10 WS-WORK-SET-COMPANY         PIC X(01).                  
                88 SCEG                     VALUE 'S'.                  
                88 PSNC                     VALUE 'P'.                  
             10 WS-WORK-SET-CYCLE           PIC X(02).                  
A04880       10 WS-STORM-STUFF.                                         
                15 WS-WORK-SET-ROUTE           PIC 9(04).               
                15 WS-WORK-SET-LOC REDEFINES WS-WORK-SET-ROUTE.         
                   20 WS-WORKSET-LOC-ZERO      PIC 9(01).               
                   20 WS-WORKSET-LOC-NUM       PIC X(03).               
                15 WS-WORK-SET-SUFFIX          PIC X(01).               
                   88 MANUAL-ROUTE             VALUE 'X'.               
                   88 MOBILE-ROUTE             VALUE 'M'.               
                   88 OFF-CYCLE-AROP-ROUTE     VALUE 'A'.               
A04880       10 WS-CIRCUIT REDEFINES WS-STORM-STUFF.                    
A04880          15 WS-CIRCUIT-NBR         PIC 9(5).                     
      *                                                                         
       COPY CWS00010.                                                           
       COPY CWS00039.                                                           
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00038.                                                           
      *                                                                         
       01 WS-INPUT-DATA-GAP REDEFINES                                   
            WS-INPUT-DATA-BREAKDOWN.                                    
          10 WS-SYSIPT-GAP                  PIC X(12).                  
             88 SEQ-GAP-PARM                VALUE 'GAP-SEQUENCE'.       
          10 FILLER                         PIC X(01).                  
          10 WS-SEQ-GAP-VALUE               PIC 9(03).                  
          10 FILLER                         PIC X(64).                  
      *                                                                 00819000
      **** Structure of FIOBW71 used for both input and output          00819000
       COPY FIOBW71.                                                            
      *                                                                 00819000
       01 WS-END                            PIC X(40) VALUE             
            'WORKING STORAGE FOR PCSBW172 ENDS HERE  '.                 
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    0000-MAINLINE                                           **          
      **        CONTROLS MAIN PROCESSING                            **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
      *                                                                         
           PERFORM 1000-PROCESS-FIOBW71     THRU 1000-EXIT              
             UNTIL END-RECORD-REACHED                                   
             OR    WS-END-OF-BW71A.                                     
      *                                                                         
           PERFORM 8000-WRITE-FIOBW71      THRU 8000-EXIT.              
      *                                                                         
           IF WS-END-OF-BW71A                                           
              DISPLAY '*******************************************'     
              DISPLAY '** NO CONTROL RECORD FOUND AS END RECORD **'     
              DISPLAY '** PROCESSING TERMINATED........         **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND   THRU 9900-EXIT                       
           ELSE                                                         
              PERFORM 7000-READ-FIOBW71     THRU 7000-EXIT              
              IF NOT WS-END-OF-BW71A                                    
                 DISPLAY '*******************************************'  
                 DISPLAY '** SOME DATA FOUND AFTER CONTROL RECORD ***'  
                 DISPLAY '** PROCESSING TERMINATED........         **'  
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND   THRU 9900-EXIT                    
           END-IF
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
      *                                                                         
           IF WS-RECORDS-READ NOT = WS-RECORDS-WRITTEN                  
              DISPLAY '***************************************'         
              DISPLAY '         RECORD MISMATCH ERROR         '         
              DISPLAY '***************************************'         
              DISPLAY 'TOTAL RECORDS READ     = ' WS-RECORDS-READ       
              DISPLAY 'TOTAL RECORDS WRITTEN  = ' WS-RECORDS-WRITTEN    
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
           DISPLAY ' '                                                  
           DISPLAY 'RECORDS RESEQUENCED = ' WS-RECORDS-RESEQUENCED      
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0100-INITIALIZATION.                                             
      *==============================================================*          
      *                                                                         
           OPEN INPUT FCSBW71A-FILE.                                    
      *                                                                 02070000
           IF  FBW71A-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0100- ERROR ON FCSBW71A OPEN.  STATUS IS '      
                                                WS-FBW71A-STATUS        
               DISPLAY '**  PROCESSING TERMINATED          **'          
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 02160000
           OPEN OUTPUT FCSBW71B-FILE.                                   
      *                                                                 02180000
           IF  FBW71B-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0100- ERROR ON FCSBW71 OPEN.  STATUS IS '       
                                            WS-FBW71B-STATUS            
               DISPLAY '** PROCESSING TERMINATED           **'          
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 02270000
           PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT.             
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                            THRU 6240-EXIT              
               MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE            
           END-IF.                                                      
           DISPLAY '********************************'                   
           DISPLAY '           PCSBW172             '                   
           DISPLAY '      RUN DATE : ' WS-INPUT-DATE                    
           DISPLAY '********************************'                   
           DISPLAY ' '                                                  
      *                                                                         
           MOVE WS-INPUT-DATE               TO RW-DATE-MTR-RD-XTRCT     
           PERFORM 7100-SELECT-REVENUE-MONTH                            
                                            THRU 7100-EXIT.             
           MOVE RW-REVENUE-MONTH            TO WS-REVENUE-MONTH.        
      *                                                                         
           PERFORM 7200-GET-RESEQUENCE-GAP  THRU 7200-EXIT.             
           PERFORM 7000-READ-FIOBW71        THRU 7000-EXIT.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1000-PROCESS-FIOBW71.                                            
      *==============================================================*          
      *                                                                         
           PERFORM 1100-BUILD-ROUTE-DATA   THRU 1100-EXIT.              
      *                                                                         
           PERFORM 2000-PROCESS-EACH-ROUTE  THRU 2000-EXIT              
             UNTIL E-FBW71-WORK-SET-ID  NOT = WS-PREV-WORK-SET-ID       
             OR E-FBW71-LOCAL-OFFICE NOT = WS-PREV-LOCAL-OFFICE         
             OR END-RECORD-REACHED                                      
             OR WS-END-OF-BW71A.                                        
      *                                                                         
           PERFORM 2300-PROCESS-ROUTE-HDR   THRU 2300-EXIT.             
      *                                                                 02920000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02920000
      *==============================================================*          
       1100-BUILD-ROUTE-DATA.                                           
      *==============================================================*          
      *                                                                 02920000
           MOVE E-FBW71-WORK-SET-ID         TO WS-WORK-SET-ID           
                                               WS-PREV-WORK-SET-ID.     
           MOVE E-FBW71-COMPANY-NO          TO RH-COMPANY-NO            
                                               WS-COMPANY-NO.           
           MOVE E-FBW71-LOCAL-OFFICE        TO RH-LOCAL-OFFICE          
                                               WS-LOCAL-OFFICE.         
      *                                                                 02920000
           IF E-FBW71-LOCAL-OFFICE NOT = WS-PREV-LOCAL-OFFICE           
              DISPLAY '  *** PROCESSING LOCAL OFFICE *** '              
              DISPLAY '               ' E-FBW71-LOCAL-OFFICE            
           END-IF.                                                      
      *                                                                 02920000
           MOVE WS-REVENUE-MONTH            TO RH-REVENUE-MONTH.        
           MOVE WS-INPUT-DATE               TO RH-DOWNLOAD-DATE.        
      *                                                                 02920000
           MOVE E-FBW71-READ-ROUTE          TO WS-PREV-READ-ROUTE.      
           MOVE E-FBW71-LOCAL-OFFICE        TO WS-PREV-LOCAL-OFFICE.    
      *                                                                 02920000
A04527     IF OFF-CYCLE-AROP-ROUTE                                      
              MOVE 9999 TO RH-READ-ROUTE                                
           ELSE                                                         
A04527        IF WS-WORK-SET-CYCLE = WS-55                              
A04527           MOVE 9999 TO RH-READ-ROUTE                             
A04527        ELSE                                                      
                 MOVE WS-WORK-SET-ROUTE TO RH-READ-ROUTE                
A04527        END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-WORK-SET-CYCLE           TO RH-READ-CYCLE.           
      *                                                                         
           SET  WS-MTR-SEQ-REQ              TO TRUE.                    
      *                                                                         
A04527*** METERS RE-SEQUENCED FOR MANUAL AND MOBILE ROUTE. NOT FOR AROP.        
      *                                                                         
           IF MANUAL-ROUTE                                              
              MOVE E-FBW71-COMPANY-NO       TO R4-COMPANY-NO            
              MOVE E-FBW71-READ-ROUTE       TO R4-READ-ROUTE            
              PERFORM 7300-CHECK-MRMS-ROUTE THRU 7300-EXIT              
           ELSE                                                         
A04880        IF WS-WORK-SET-CYCLE = WS-55                              
A04527           CONTINUE                                               
A04527        ELSE                                                      
A04880           IF MOBILE-ROUTE                                        
A04880              CONTINUE                                            
A04880           ELSE                                                   
A04527              SET WS-MTR-SEQ-NOT-REQ     TO TRUE                  
A04527           END-IF                                                 
A04527        END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-MTR-SEQ-REQ-SW           TO E-FBW71-SEQ-REQUIRED.    
           MOVE ZERO                        TO WS-SEQUENCE-NUMBER       
                                               WS-READ-SEQ              
                                               WS-DOWNLD-MTR-COUNT      
                                               WS-PREV-ACCOUNT-NO.      
           MOVE SPACES                      TO WS-PREV-METER-NO.        
      *                                                                 02920000
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02920000
      *==============================================================*          
       2000-PROCESS-EACH-ROUTE.                                         
      *==============================================================*          
      *                                                                 02920000
      **** E-FBW71-SEQ-REQUIRED FLAG WILL BE PASSED TO TOHOST THRU      02920000
      **** CUSTOM AREA. THIS WILL BE USED IN PCSBW182 TO DETERMINE      02920000
      **** AND UPDATE METER READ SEQUENCE.                              02920000
                                                                        
           MOVE WS-MTR-SEQ-REQ-SW           TO E-FBW71-SEQ-REQUIRED.    
      *                                                                 02920000
      **** E-FBW71-SEQUENCE-NUMBER WILL BE USED TO MAINTAIN CUSTOMER    02920000
      **** SEQUENCE WITH IN WORKSET. THIS IS FOR FCS USE ONLY.          02920000
      *                                                                 02920000
      **** METER READ SEQUENCE WILL BE UPDATED WHEN ROUTE IS NOT SPLIT  02920000
      **** AND EXISTING SEQUENCE IS NOT ZERO.                           02920000
      **** METER NO IS NOT UNIQUE, HENCE COMBINED WITH ACCT & UTL TYPE  02920000
           IF E-FBW71-METER-NO      NOT = WS-PREV-METER-NO              
              OR E-FBW71-ACCOUNT-NO NOT = WS-PREV-ACCOUNT-NO            
              OR E-FBW71-UTL-TYPE   NOT = WS-PREV-UTL-TYPE              
              MOVE E-FBW71-METER-NO         TO WS-PREV-METER-NO         
              MOVE E-FBW71-ACCOUNT-NO       TO WS-PREV-ACCOUNT-NO       
              MOVE E-FBW71-UTL-TYPE         TO WS-PREV-UTL-TYPE         
              PERFORM 2100-RESEQ-READ-SEQ      THRU 2100-EXIT           
              ADD +1                        TO WS-DOWNLD-MTR-COUNT      
              ADD +1                        TO WS-SEQUENCE-NUMBER       
A01738     ELSE                                                         
A01738        MOVE WS-TEMP-READ-SEQ         TO E-FBW71-READ-SEQ         
           END-IF.                                                      
           MOVE WS-SEQUENCE-NUMBER          TO E-FBW71-SEQUENCE-NUMBER  
      *                                                                 02920000
           PERFORM 8000-WRITE-FIOBW71      THRU 8000-EXIT.              
      *                                                                 02920000
           PERFORM 7000-READ-FIOBW71       THRU 7000-EXIT.              
      *                                                                 02920000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03390000
      *==============================================================*          
       2100-RESEQ-READ-SEQ.                                             
      *==============================================================*          
      *                                                                         
A01738     MOVE E-FBW71-READ-SEQ            TO WS-TEMP-READ-SEQ         
           IF WS-MTR-SEQ-REQ                                            
              AND E-FBW71-READ-SEQ NOT = ZERO                           
A01738        COMPUTE WS-READ-SEQ = WS-READ-SEQ + WS-RESEQ-GAP          
A01738        IF WS-READ-SEQ  NOT = E-FBW71-READ-SEQ                    
A01738           PERFORM 2200-CHK-REG-RD-SEQ   THRU 2200-EXIT           
A01738        END-IF                                                    
           END-IF.                                                      
      *                                                                 03360000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03390000
      *==============================================================*          
       2200-CHK-REG-RD-SEQ.                                             
      * For Multi-registers, MN-CODE-DATA-PRESENT is > spaces           02920000
      *==============================================================*          
      *                                                                 03390000
      **** E-FBW71-READ-SEQ gets updated with the new read sequence no. 02920000
           MOVE WS-READ-SEQ           TO E-FBW71-READ-SEQ               
A01738                                   MN-REGISTER-RD-SEQ             
A01738                                   WS-TEMP-READ-SEQ.              
           MOVE E-FBW71-ACCOUNT-NO    TO MN-ACCOUNT-NO                  
           MOVE E-FBW71-UTL-TYPE      TO MN-CODE-UTIL-TYPE              
           MOVE E-FBW71-IC-NO         TO MN-IC-NO                       
           MOVE E-FBW71-MTR-REF-NO    TO MN-MTR-REF-NO                  
      *                                                                 04200000
           PERFORM 8100-UPD-MTRD-ENV  THRU 8100-EXIT.                   
      *                                                                 04200000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'PRIMARY REGISTER NOT FOUND... '                  
              DISPLAY 'ACCOUNT-NO       : ' MN-ACCOUNT-NO               
              DISPLAY 'CODE-UTIL-TYPE   : ' MN-CODE-UTIL-TYPE           
              DISPLAY 'IC-NO            : ' MN-IC-NO                    
              DISPLAY 'MTR-REF-NO       : ' MN-MTR-REF-NO               
              DISPLAY 'METER-NO         : ' E-FBW71-METER-NO            
              DISPLAY 'REGISTER-RD-SEQ  : ' MN-REGISTER-RD-SEQ          
           END-IF.                                                      
      *                                                                 04200000
           IF MN-CODE-DATA-PRESENT > SPACES                             
              MOVE WS-READ-SEQ        TO RG-REGISTER-RD-SEQ             
              MOVE E-FBW71-ACCOUNT-NO TO RG-ACCOUNT-NO                  
              MOVE E-FBW71-UTL-TYPE   TO RG-CODE-UTIL-TYPE              
              MOVE E-FBW71-IC-NO      TO RG-IC-NO                       
              MOVE E-FBW71-MTR-REF-NO TO RG-MTR-REF-NO                  
              PERFORM 8200-UPD-REG-READ THRU 8200-EXIT                  
           END-IF.                                                      
      *                                                                         
           ADD +1                     TO WS-RECORDS-RESEQUENCED.        
      *                                                                 04200000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03390000
      *==============================================================*          
       2300-PROCESS-ROUTE-HDR.                                          
      *==============================================================*          
      *                                                                 02920000
           PERFORM 8300-INSERT-ROUTE-HDR    THRU 8300-EXIT.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = ALREADY-EXISTS                    
              PERFORM 8400-UPDATE-ROUTE-HDR THRU 8400-EXIT              
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                COMMIT                                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           INITIALIZE WS-DOWNLD-MTR-COUNT-DISP.                         
           MOVE WS-DOWNLD-MTR-COUNT        TO WS-DOWNLD-MTR-COUNT-DISP. 
           DISPLAY ' COMMIT AT ' WS-PREV-WORK-SET-ID ' MTR QTY '        
                   WS-DOWNLD-MTR-COUNT-DISP.                            
      *                                                                 02920000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02920000
      *==============================================================*          
      *6240-GET-FCA00-COMMON-DATE                                    *          
      *==============================================================*          
           COPY CPD00040.                                                       
      *                                                                         
      *==============================================================*          
      *6251-GET-FJC01-DATE                                           *          
      *==============================================================*          
           COPY CPD00037.                                                       
      *                                                                         
      *==============================================================*          
       7000-READ-FIOBW71.                                               
      *==============================================================*          
      *                                                                 04350000
           READ FCSBW71A-FILE                                           
             AT END                                                     
                MOVE WS-YES                 TO WS-CHECK-END-OF-BW71A.   
      *                                                                 04370000
           IF  FIOBW71A-IN(1:8) = WS-TRAILER-RECORD                     
               SET END-RECORD-REACHED   TO TRUE                         
           END-IF.                                                      
      *                                                                 04500000
           IF NOT WS-END-OF-BW71A                                       
              MOVE FIOBW71A-IN              TO FIOBW71                  
              ADD +1                        TO WS-RECORDS-READ          
           END-IF.                                                      
      *                                                                 04500000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04500000
      *==============================================================*          
       7100-SELECT-REVENUE-MONTH.                                       
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) REVENUE_MONTH                                      
                INTO :RW-REVENUE-MONTH                                  
                FROM CSS_READ_WINDOW RW WITH(READUNCOMMITTED)                   
               WHERE DATE_MTR_RD_XTRCT <= IIF(TRY_CONVERT(DATE, 
                                                  :RW-DATE-MTR-RD-XTRCT
              ) IS NULL OR (PATINDEX('%.%', :RW-DATE-MTR-RD-XTRCT
              ) <> 0) OR (LEN(:RW-DATE-MTR-RD-XTRCT
              ) <> 10), CIS.CHAR2DATE(:RW-DATE-MTR-RD-XTRCT
              ), CONVERT(DATE, :RW-DATE-MTR-RD-XTRCT) )         
               ORDER BY DATE_MTR_RD_XTRCT DESC                          
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REVENUE_MONTH                                              
MFA-TR*         INTO :RW-REVENUE-MONTH                                          
MFA-TR*         FROM CSS_READ_WINDOW RW                                         
MFA-TR*        WHERE DATE_MTR_RD_XTRCT <= :RW-DATE-MTR-RD-XTRCT                 
MFA-TR*        ORDER BY DATE_MTR_RD_XTRCT DESC                                  
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSBW172     ABORT ************'     
               DISPLAY '* 7100-SELECT-REVENUE-MONTH              *'     
               DISPLAY '* SQLCODE           = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '* TABLE             = CSS_READ_WINDOW     '     
               DISPLAY '* DATE-MTR-RD-XTRCT = ' RW-DATE-MTR-RD-XTRCT    
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7200-GET-RESEQUENCE-GAP.                                         
      *==============================================================*          
      *                                                                         
           MOVE  WS-PGRMNAME                TO WS-PROGRAM.              
           MOVE  WS-PARM                    TO WS-COMMAND.              
           MOVE  ZEROS                      TO WS-SEQUENCE.             
           MOVE  SPACES                     TO WS-SYSIPT.               
           MOVE  WS-KEY-AREA                TO E-FJC01-KEY.             
           PERFORM 7600-START-FCSJC01       THRU  7600-EXIT.            
           PERFORM 7610-READ-FCSJC01        THRU  7610-EXIT             
               UNTIL (SEQ-GAP-PARM AND INPUT-ACTIVE)                    
               OR  END-OF-SYSIPT.                                       
      *                                                                 04311600
           IF  END-OF-SYSIPT                                            
               DISPLAY ' '                                              
               DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'        
               DISPLAY '**  SEQUENCE GAP PARM NOT FOUND'                
               DISPLAY '**    KEY =  ' E-FJC01-KEY                      
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND           THRU  9900-EXIT             
           ELSE                                                         
               PERFORM 7611-CLOSE           THRU 7611-EXIT              
               MOVE WS-SEQ-GAP-VALUE        TO WS-RESEQ-GAP             
           END-IF.                                                      
      *                                                                 04314300
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================* 04600000
       7300-CHECK-MRMS-ROUTE.                                           
      * An entry in this table means Split Routes.                      02920000
      *===============================================================* 04600000
      *                                                                 21891000
           EXEC SQL                                                     
             SELECT TOP(1) 'N'                                                 
             INTO  :WS-MTR-SEQ-REQ-SW                                   
             FROM CSS_READ_RT_SOURCE R4 WITH(READUNCOMMITTED)                   
             WHERE READ_ROUTE         = :R4-READ-ROUTE                  
             AND COMPANY_NO           = :R4-COMPANY-NO                  
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21790000
MFA-TR*      SELECT 'N'                                                         
MFA-TR*      INTO  :WS-MTR-SEQ-REQ-SW                                           
MFA-TR*      FROM CSS_READ_RT_SOURCE R4                                         
MFA-TR*      WHERE READ_ROUTE         = :R4-READ-ROUTE                          
MFA-TR*      AND COMPANY_NO           = :R4-COMPANY-NO                          
MFA-TR*      FETCH FIRST ROW ONLY                                               
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    21890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21891000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 21901000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              OR ALREADY-EXISTS                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSBW172     ABORT ************'      
              DISPLAY '* 7300-CHECK-MRMS-ROUTE                  *'      
              DISPLAY '* SQLCODE           = ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* TABLE             = CSS_READ_RT_SOURCE  '      
              DISPLAY '* READ_ROUTE        = ' R4-READ-ROUTE            
              DISPLAY '* COMPANY_NO        = ' R4-COMPANY-NO            
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 21971000
       7300-EXIT.                                                       
            EXIT.                                                       
      *                                                                 21901000
      *==============================================================*          
      *7600-START-FCSJC01                                            *          
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
      *7620-START-FCSCA00                                            *          
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
       8000-WRITE-FIOBW71.                                              
      *==============================================================*          
      *                                                                 04710000
           MOVE  FIOBW71                    TO FIOBW71B-OUT.            
           WRITE FIOBW71B-OUT.                                          
           ADD +1                           TO WS-RECORDS-WRITTEN.      
      *                                                                 04820000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8100-UPD-MTRD-ENV.                                               
      *==============================================================*          
      *                                                                 05630000
           EXEC SQL                                                     
                UPDATE CSS_MTRD_ENVRNMT                                 
                SET   REGISTER_RD_SEQ = :MN-REGISTER-RD-SEQ             
                WHERE ACCOUNT_NO      = :MN-ACCOUNT-NO                  
                AND   CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE              
                AND   IC_NO           = :MN-IC-NO                       
                AND   MTR_REF_NO      = :MN-MTR-REF-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05760000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 05780000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSBW172     ABORT *********'         
              DISPLAY '* 8100-UPD-MTRD-ENV                   *'         
              DISPLAY '* TABLE             = CSS_MTRD_ENVRNMT '         
              DISPLAY '* SQLCODE           = ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* ACCOUNT #         = ' MN-ACCOUNT-NO            
              DISPLAY '* IC NO             = ' MN-IC-NO                 
              DISPLAY '* MTR REF NO        = ' MN-MTR-REF-NO            
              DISPLAY '* METER NO          = ' E-FBW71-METER-NO         
              DISPLAY '* CODE UTIL TYPE    = ' MN-CODE-UTIL-TYPE        
              DISPLAY '* REG RD SEQ        = ' MN-REGISTER-RD-SEQ       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 05910000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05940000
      *==============================================================*          
       8200-UPD-REG-READ.                                               
      *==============================================================*          
      *                                                                 05990000
           EXEC SQL                                                     
                UPDATE CSS_REGISTER_READ                                
                SET   REGISTER_RD_SEQ = :RG-REGISTER-RD-SEQ             
                WHERE ACCOUNT_NO      = :RG-ACCOUNT-NO                  
                AND   CODE_UTIL_TYPE  = :RG-CODE-UTIL-TYPE              
                AND   IC_NO           = :RG-IC-NO                       
                AND   MTR_REF_NO      = :RG-MTR-REF-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06120000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 06140000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSBW172     ABORT ************'      
              DISPLAY '* 8200-UPD-REG-READ                      *'      
              DISPLAY '* TABLE             =   CSS_REGISTER_READ '      
              DISPLAY '* SQLCODE           = ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* ACCOUNT #         = ' RG-ACCOUNT-NO            
              DISPLAY '* IC NO             = ' RG-IC-NO                 
              DISPLAY '* MTR REF NO        = ' RG-MTR-REF-NO            
              DISPLAY '* METER NO          = ' E-FBW71-METER-NO         
              DISPLAY '* CODE UTIL TYPE    = ' RG-CODE-UTIL-TYPE        
              DISPLAY '* REG RD SEQ        = ' RG-REGISTER-RD-SEQ       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 06270000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04660000
      *==============================================================*          
       8300-INSERT-ROUTE-HDR.                                           
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_ROUTE_HEADER                            
                  (REVENUE_MONTH                                        
                  ,READ_ROUTE                                           
                  ,COMPANY_NO                                           
                  ,LOCAL_OFFICE                                         
                  ,READ_CYCLE                                           
                  ,DOWNLOAD_DATE                                        
                  ,PC_ROUTE_IND                                         
                  ,DOWNLOAD_METERS                                      
                  ,DOWN_RMVD_MTR_QT                                     
                  ,UPLOAD_METERS                                        
                  ,UP_RMVD_MTR_QT)                                      
               VALUES                                                   
                  (:RH-REVENUE-MONTH                                    
                  ,:RH-READ-ROUTE                                       
                  ,:RH-COMPANY-NO                                       
                  ,:RH-LOCAL-OFFICE                                     
                  ,:RH-READ-CYCLE                                       
                  ,IIF(TRY_CONVERT(DATE, :RH-DOWNLOAD-DATE
              ) IS NULL OR (PATINDEX('%.%', :RH-DOWNLOAD-DATE
              ) <> 0) OR (LEN(:RH-DOWNLOAD-DATE) <> 10), CIS.CHAR2DATE(
                                                      :RH-DOWNLOAD-DATE
              ), CONVERT(DATE, :RH-DOWNLOAD-DATE) )                            
                  , ' '                                                 
                  ,:WS-DOWNLD-MTR-COUNT                                 
                  ,0                                                    
                  ,0                                                    
                  ,0)                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ROUTE_HEADER                                    
MFA-TR*           (REVENUE_MONTH                                                
MFA-TR*           ,READ_ROUTE                                                   
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,LOCAL_OFFICE                                                 
MFA-TR*           ,READ_CYCLE                                                   
MFA-TR*           ,DOWNLOAD_DATE                                                
MFA-TR*           ,PC_ROUTE_IND                                                 
MFA-TR*           ,DOWNLOAD_METERS                                              
MFA-TR*           ,DOWN_RMVD_MTR_QT                                             
MFA-TR*           ,UPLOAD_METERS                                                
MFA-TR*           ,UP_RMVD_MTR_QT)                                              
MFA-TR*        VALUES                                                           
MFA-TR*           (:RH-REVENUE-MONTH                                            
MFA-TR*           ,:RH-READ-ROUTE                                               
MFA-TR*           ,:RH-COMPANY-NO                                               
MFA-TR*           ,:RH-LOCAL-OFFICE                                             
MFA-TR*           ,:RH-READ-CYCLE                                               
MFA-TR*           ,:RH-DOWNLOAD-DATE                                            
MFA-TR*           , ' '                                                         
MFA-TR*           ,:WS-DOWNLD-MTR-COUNT                                         
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,0)                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06270000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 06140000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR ALREADY-EXISTS                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSBW172     ABORT ************'      
              DISPLAY '* 8300-INSERT-ROUTE-HDR              *'          
              DISPLAY '* TABLE              = CSS_ROUTE_HEADER'         
              DISPLAY '* SQLCODE            = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* REVENUE_MONTH      = ' RH-REVENUE-MONTH        
              DISPLAY '* READ_ROUTE         = ' RH-READ-ROUTE           
              DISPLAY '* COMPANY_NO         = ' RH-COMPANY-NO           
              DISPLAY '* LOCAL_OFFICE       = ' RH-LOCAL-OFFICE         
              DISPLAY '* READ_CYCLE         = ' RH-READ-CYCLE           
              DISPLAY '* DOWNLOAD_METERS    = ' WS-DOWNLD-MTR-COUNT     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8400-UPDATE-ROUTE-HDR.                                           
      *==============================================================*          
      *                                                                 05990000
           EXEC SQL                                                     
                UPDATE CSS_ROUTE_HEADER                                 
                SET DOWNLOAD_METERS =                                   
                    DOWNLOAD_METERS + :WS-DOWNLD-MTR-COUNT              
                WHERE REVENUE_MONTH   = :RH-REVENUE-MONTH               
                AND READ_ROUTE        = :RH-READ-ROUTE                  
                AND COMPANY_NO        = :RH-COMPANY-NO                  
                AND LOCAL_OFFICE      = :RH-LOCAL-OFFICE                
                AND READ_CYCLE        = :RH-READ-CYCLE                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 06140000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSBW172     ABORT ************'      
              DISPLAY '* 8400-UPDATE-ROUTE-HDR                  *'      
              DISPLAY '* TABLE             = CSS_ROUTE_HEADER '         
              DISPLAY '* SQLCODE           = ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* DOWN-RMVD-MTR-QT  = ' RH-DOWN-RMVD-MTR-QT      
              DISPLAY '* REVENUE-MONTH     = ' RH-REVENUE-MONTH         
              DISPLAY '* READ-ROUTE        = ' RH-READ-ROUTE            
              DISPLAY '* COMPANY-NO        = ' RH-COMPANY-NO            
              DISPLAY '* LOCAL-OFFICE      = ' RH-LOCAL-OFFICE          
              DISPLAY '* READ-CYCLE        = ' RH-READ-CYCLE            
              DISPLAY '* DOWNLOAD-METERS   = ' RH-DOWNLOAD-METERS       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05580000
      *==============================================================*          
       9000-TERMINATE.                                                  
      *==============================================================*          
           CLOSE FCSBW71A-FILE                                          
                 FCSBW71B-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *==============================================================*          
      *9900-ABEND.                                                   *          
      *==============================================================*          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
