       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW171.                                        
       DATE-WRITTEN.   APRIL 2009.                                      
           DATE-COMPILED.                                               
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **    DATE    INITIALS    REASON                              **          
      **  ________  ________    ___________________________________ **          
      **  04-25-09  NC94746     NEW CODE WRITTEN FOR FCS            **          
      **  09-25-09  SS95855     P00135 PASS READ TYPE CODE AS 'G6'  **          
      **                        FOR 6 DIAL GAS METERS               **          
A00795** 02/02/10    NC94746  CHANGES TO USE NEW HIGH-LOW ROUTINE   **          
P00251** 01/25/10   SS95855     Net Metering                        **          
P00251**                      - Code_Usage_Id and Code_Usage_Source **          
P00251**                        added tO FIOBW71 Layout.            **          
P00251**                      - Changed E-FBW71-USAGE-TYPE to       **          
P00251**                        match DB2 name.                     **          
P00251**                      - Identify manually read registers by **          
P00251**                        using Remote_Read_Ind <> 'T'(Probed **          
P00251**                        TOU) and <> 'B'(Probed both TOU and **          
P00251**                        IDR).Remove mtr_rd_record_cd = B in **          
P00251**                        CSS_MTR_RD_FMT.                     **          
P00251** 09/02/10   SS95855     Net metering                        **          
P00251**                        Remove 'MTR-RD-RECORD-CD' references**          
ACT199** 11/01/11   BD09555     Reset special instructions when     **          
ACT199**                        date is less than current date.     **          
      **                                                            **          
A04527** 25 JUL 13  RF10596     ALLOW FOR STORM RECORDS TO PROCESS  **          
      **                                                            **          
A04880** 27 JUN 14  RF10596     ADD CIRCUIT NUMBER FOR STORM USE    **          
      **                                                            **          
A04860** 17 FEB 15  MR7E794     REPLACE CSS_WQ_ITEMS_MF WITH        **          
A04860**             ACT069     CSS_WQ_ITEMS.                       **          
A05347** 06/21/16    NC94746  FORMATTING CHANGES TO DEVICE ID       **          
A#5470** 11/10/16   SS95855     GET LAT/LONG FROM PREMISE(ACT054)   **          
      **                                                            **          
A05744** 01/13/17   NC94746   SPLIT LOCAL OFFICE FOR AROP ROUTES    **          
      ****************************************************************          
           REMARKS.                                                     
      *     METER READ EXTRACTION FOR FIELD COLLECTION SYSTEM                   
      *      + EXTRACT METER AND ITS REGISTER DATA USING DB09 ACC LIST          
      *      + EXTRACTS DATA FOR REGULAR MONTH, MID-MONTH & AROP RUNS           
      *      + CREATES BW71 FILE WHICH IS INPUT TO PCSBW172                     
      *      + TAKES COMMITS & IT HAS AUTO FILE REPOSITION RESTART LOGIC        
      *      + RUN ON DIFFERENT PARTIONS                                        
      *                                                                         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBW71.                                                            
       COPY CSSBW71R.                                                           
       COPY CSSDB09.                                                            
       COPY CSSCA55.                                                            
       COPY CSSCA55R.                                                           
       COPY CSSRP87.                                                            
       COPY CSSRP87R.                                                           
       COPY CSSRP123.                                                           
       COPY CSSRP12R.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBW71.                                                            
       COPY FIOBW71.                                                            
       COPY CFDBW71R.                                                           
       COPY FIOBW71R.                                                           
       COPY CFDDB09.                                                            
       COPY FIODB09.                                                            
       COPY CFDCA55.                                                            
       COPY FIOCA55.                                                            
       COPY CFDCA55R.                                                           
       COPY FIOCA55R.                                                           
       COPY CFDRP87.                                                            
       COPY FIORP87.                                                            
       COPY CFDRP87R.                                                           
       COPY FIORP87R.                                                           
       COPY CFDRP123.                                                           
       COPY FIORP123.                                                           
       COPY CFDRP12R.                                                           
       COPY FIORP12R.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-RD-FMT  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-FILTER-INFO  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-CWS72-HI-LO-CSR  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW171'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-WORK-VARIABLES.                                           
           05 WS-BW71-NO-READ-DIALS       PIC S9(4) COMP VALUE 0.       
ACT199     05 WS-DATE-MSG-NULL                 PIC S9(04) COMP.         
           05 WS-LAST-REG-RD-DT            PIC X(10).                   
           05 WS-HILO-WORK-DATE            PIC X(10).                   
           05 WS-HILO-WORK-DAYS            PIC 9(2).                    
           05 WS-HILO-SUBTRACT-DAYS        PIC S9(4) COMP VALUE 0.      
           05 WS-HILO-DAYS                 PIC S9(9) COMP VALUE 32.     
           05 WS-CODE-LONG-DESC            PIC X(80) VALUE SPACES.      
           05 WS-WORKSET-ID.                                            
A04880        10 WS-WORKSET-COMPANY        PIC X(01).                   
A04880        10 WS-WORKSET-CYCLE          PIC X(02).                   
A04880        10 WS-STORM-STUFF.                                        
A04880           15 WS-WORKSET-ROUTE       PIC 9(04).                   
A04880           15 WS-WORKSET-LOC REDEFINES WS-WORKSET-ROUTE.          
A04880              20 WS-WORKSET-LOC-ZERO PIC 9(01).                   
A04880              20 WS-WORKSET-LOC-NUM  PIC X(03).                   
A04880           15 WS-WORKSET-SUFIX       PIC X(01).                   
A04880        10 WS-CIRCUIT REDEFINES WS-STORM-STUFF.                   
A04880           15 WS-CIRCUIT-NBR         PIC 9(5).                    
           05  WS-FCS-OPTIMUM-RD-DT        PIC X(10).                   
           05  WS-FCS-CRITICAL-RD-DT       PIC X(10).                   
           05  WS-FCS-CYCLE                PIC X(02).                   
           05  WS-MFG-PLUS-DMT             PIC X(10).                   
           05  WS-LAST-RD-TIME             PIC X(08).                   
           05  WS-LAST-LP-RD-DATETIME.                                  
               10 WS-LAST-LP-RD-DATE       PIC X(10).                   
               10 WS-LAST-LP-DT-DELIM      PIC X(01).                   
               10 WS-LAST-LP-RD-TIME.                                   
                  15 FILLER                PIC X(02).                   
                  15 WS-TIME-SEP1          PIC X(01).                   
                  15 FILLER                PIC X(02).                   
                  15 WS-TIME-SEP2          PIC X(01).                   
                  15 FILLER                PIC X(02).                   
           05  WS-CODE-USAGE-TYPE      PIC X         VALUE SPACES.      
A00795     05  WS-CODE-USAGE-ID        PIC X         VALUE SPACES.      
A00795     05  WS-CODE-TIME-PERIOD     PIC S9(4)  COMP VALUE 0.         
A00795     05  WS-HL-CODE-TIME-PERIOD  PIC S9(4)  COMP VALUE -1.        
A00795     05  WS-HL-CODE-USAGE-ID     PIC X(01) VALUE ' '.             
           05  WS-FDB09-STATUS         PIC X(02).                       
               88  FDB09-SUCCESSFUL                  VALUE '00'.        
           05  WS-FBW71-STATUS         PIC X(02).                       
               88  FBW71-SUCCESSFUL                  VALUE '00'.        
           05  WS-FCA55-STATUS         PIC X(02).                       
               88  FCA55-SUCCESSFUL                  VALUE '00'.        
           05  WS-FRP87-STATUS         PIC X(02).                       
               88  FRP87-SUCCESSFUL                  VALUE '00'.        
           05  WS-FRP123-STATUS        PIC X(02).                       
               88  FRP123-SUCCESSFUL                 VALUE '00'.        
           05  WS-FBW71R-STATUS          PIC X(02).                     
               88  FBW71R-SUCCESSFUL       VALUE '00'.                  
               88  FBW71R-END-OF-FILE      VALUE '10'.                  
           05  WS-FCA55R-STATUS          PIC X(02).                     
               88  FCA55R-SUCCESSFUL       VALUE '00'.                  
               88  FCA55R-END-OF-FILE      VALUE '10'.                  
           05  WS-FRP87R-STATUS          PIC X(02).                     
               88  FRP87R-SUCCESSFUL       VALUE '00'.                  
               88  FRP87R-END-OF-FILE      VALUE '10'.                  
           05  WS-FRP12R-STATUS          PIC X(02).                     
               88  FRP12R-SUCCESSFUL       VALUE '00'.                  
               88  FRP12R-END-OF-FILE      VALUE '10'.                  
           05  WS-PREMISE-NO           PIC 9(10)     VALUE ZERO.        
           05  WS-NO-MORE-DATA         PIC X(01)     VALUE 'N'.         
               88  NO-MORE-DATA                      VALUE 'Y'.         
           05  WS-RST-REQUIRED-FL           PIC 9(01) VALUE 0.          
               88  RESTART-REQUIRED                   VALUE 0.          
               88  RESTART-NOT-REQUIRED               VALUE 1.          
           05  WS-PART-NO              PIC 9(02).                       
           05  WS-SAVE-READ-CYCLE-1    PIC X(02).                       
           05  WS-SAVE-READ-CYCLE-2    PIC X(02).                       
           05  WS-SAVE-READ-CYCLE-3    PIC X(02).                       
           05  WS-SAVE-READ-CYCLE-4    PIC X(02).                       
           05  WS-SAVE-READ-CYCLE-5    PIC X(02).                       
           05  WS-PROCESS-READING      PIC X(01)     VALUE 'Y'.         
               88  PROCESS-READING                   VALUE 'Y'.         
           05  WS-PROCESS-MONTH        PIC 9(02).                       
           05 WS-NON-STD-FRQ-OFFICE              PIC X(03).             
               88  NON-STD-FRQ-OFFICE              VALUES               
                                                 '252' '270'            
                                                 '271' '272'.           
           05  WS-MRMS-CYCLE-NO        PIC X(02)     VALUE SPACES.      
           05  WS-NUMBER-OF-METERS     PIC S9(07)    COMP-3 VALUE ZERO. 
           05  WS-CONTACT-LEN          PIC S9(04)    COMP VALUE +75.    
           05  WS-CONTACT-MSG.                                          
               10  FILLER              PIC X(51)     VALUE              
               ' METER READ SCHEDULED IN TWO DAYS, CUSTOMER MUST BE'.   
               10  FILLER              PIC X(24)     VALUE              
               ' NOTIFIED 24 HOURS PRIOR'.                              
           05  WS-CONTACT-LEN1         PIC S9(04)    COMP VALUE +142.   
           05  WS-CONTACT-MSG1.                                         
               10  FILLER              PIC X(14)     VALUE              
               ' LOCAL OFFICE '.                                        
               10  WS-WQ-LOC-OFF       PIC X(03).                       
               10  FILLER              PIC X(12)     VALUE              
               ' ON ACCOUNT '.                                          
               10  WS-WQ-ACCOUNT       PIC X(13).                       
               10  FILLER              PIC X(16)     VALUE              
               ' AND READ CYCLE '.                                      
               10  WS-WQ-READ-CYCLE    PIC X(02).                       
               10  FILLER              PIC X(27)     VALUE              
               ' DO NOT MATCH LOCAL OFFICE '.                           
               10  WS-WQ-LOC-OFF1      PIC X(03).                       
               10  FILLER              PIC X(16)     VALUE              
               ' AND READ CYCLE '.                                      
               10  WS-WQ-READ-CYCLE1   PIC X(02).                       
               10  FILLER              PIC X(26)     VALUE              
               ' ASSIGNED TO READ ROUTE '.                              
               10  WS-WQ-READ-ROUTE    PIC X(06).                       
           05  WS-FCS21-WRITE-IND      PIC X(01)     VALUE 'Y'.         
      *                                                                         
           05  WS-NO-DIGTL-MTR-LEN     PIC S9(04)    COMP VALUE +61.    
           05  WS-NO-DIGTL-MTR-MSG.                                     
               10  FILLER              PIC X(26)     VALUE              
               ' TIME OF USE METER NUMBER '.                            
               10  WS-MN-MTR-NO-HOLD   PIC X(9)      VALUE SPACES.      
               10  FILLER              PIC X(26)     VALUE              
               ' HAS NO DIGITAL METER TYPE'.                            
      *                                                                         
           05  WS-REV-MTH-NUM          PIC 9(6) VALUE ZERO.             
           05  WS-REVENUE-MONTH-RED REDEFINES WS-REV-MTH-NUM.           
               10  WS-REV-MTH-YYYY     PIC 9(4).                        
               10  WS-REV-MTH-MM       PIC 9(2).                        
           05  WS-HLD-NO-RD-REASON     PIC X(01)     VALUE SPACES.      
      *                                                                         
       01 WS-WQ-FORMAT-TEXT.                                            
      *                                                                         
           05  WS-ROUTING-CATEGORY4    PIC X     VALUE '4'.             
           05  WS-ROUTING-CATEGORY1    PIC X     VALUE '1'.             
           05  WS-CATEGORY-ID-225      PIC S9(4) COMP VALUE 225.        
           05  WS-CATEGORY-ID-232      PIC S9(4) COMP VALUE 232.        
           05  WS-CATEGORY-ID-143      PIC S9(4) COMP VALUE 143.        
      *                                                                         
           05 WS-WQ-ERROR-TEXT4.                                        
              10 FILLER               PIC X(48) VALUE                   
                'PCSBW141 - NO DMT/PGM ID COMBO IN CSS_MTR_RD_FMT'.     
              10 FILLER               PIC X(8) VALUE                    
                ' TABLE  '.                                             
              10 FILLER                    PIC X(18)                    
                 VALUE ' CODE-UTIL-TYPE = '.                            
              10 WQ4-OA-CODE-UTIL-TYPE     PIC X.                       
              10 FILLER                    PIC X(18)                    
                 VALUE ' DIGTL-MTR-TYPE = '.                            
              10 WQ4-OA-DIGTL-MTR-TYPE     PIC X(3).                    
              10 FILLER                    PIC X(10)                    
                 VALUE ' PGM-ID = '.                                    
              10 WQ4-OA-PROGRAM-ID         PIC XX.                      
              10 FILLER                    PIC X(22)                    
                 VALUE ' MTR-READ-SOURCE-CD = '.                        
              10 WQ4-OA-MTR-READ-SOURCE-CD PIC X.                       
              10 FILLER                    PIC X(19)                    
                 VALUE ' REMOTE-READ-IND = '.                           
              10 WQ4-OA-REMOTE-READ-IND    PIC X.                       
              10 FILLER                    PIC X(12)                    
                 VALUE ' METER-NO = '.                                  
              10 WQ4-METER-NO              PIC X(9).                    
      *                                                                         
           05 WS-WQ-ERROR-TEXT5.                                        
              10 FILLER               PIC X(46) VALUE                   
                 'PCSBW141 - REGISTER FROM MTR_RD_FMT TABLE NOT '.      
              10 FILLER               PIC X(24) VALUE                   
                 'AVAILABLE FOR THIS METER'.                            
              10 FILLER                    PIC X(11)                    
                  VALUE ' DISP-CD = '.                                  
              10 WQ5-DISP-CD               PIC X(3).                    
              10 FILLER                    PIC X(19)                    
                  VALUE ' CODE-USAGE-TYPE = '.                          
              10 WQ5-CODE-USAGE-TYPE       PIC X.                       
              10 FILLER                    PIC X(20)                    
                  VALUE ' CODE-TIME-PERIOD = '.                         
              10 WQ5-CODE-TIME-PERIOD      PIC 9.                       
              10 FILLER                    PIC X(12)                    
                  VALUE ' METER-NO = '.                                 
              10 WQ5-METER-NO              PIC X(9).                    
      *                                                                         
       01 WS-REMOTE-READ-IND-FL              PIC X(01).                 
          88 MANUAL-MTR                            VALUE '0'.           
          88 AMR-MTR                               VALUE 'A'.           
          88 NON-TOU-MTR                           VALUE '0' 'A'.       
          88 TOU-MANUAL                            VALUE 'M'.           
          88 TOU-ONLY                              VALUE 'T'.           
          88 TOU-IDR                               VALUE 'B'.           
          88 IDR-ONLY                              VALUE 'I'.           
          88 OPTICAL-PROB-MTR                      VALUE 'T' 'B' 'I'.   
      *                                                                         
       01  WS-READ-SOURCE-TABLE.                                        
           05 WS-RD-SOURCE-REC OCCURS 25 TIMES                          
                               INDEXED BY WS-RD-SRC-IDX.                
      *ALWAYS KEEP IN SYNC WITH 'WS-MAX-RD-SRC-ROWS'.                           
              10 WS-RD-SOURCE-ROW.                                      
                 15 WS-TAB-RD-SOURCE-CD        PIC X(01).               
                 15 WS-TAB-AMR-COMM-TYPE-CD    PIC X(01).               
                 15 WS-TAB-SEND-READ-REQ-FL    PIC X(01).               
      *                                                                         
       01  WS-HILO-DATE-TABLE.                                          
           05 WS-HILO-DATE-ENTRIES OCCURS 7 TIMES                       
                  INDEXED BY HL-INDX.                                   
              10  WS-HL-READ-DATE     PIC X(10).                        
              10  WS-HL-READ-DAYS     PIC 99.                           
      *                                                                         
       01  WS-TEMP-VAR.                                                 
           05  WS-PREV-READ-VALUE-HOLD       PIC 9999999V999.           
           05  WS-PREV-READ-VALUE-FORMAT                                
                  REDEFINES WS-PREV-READ-VALUE-HOLD.                    
               10 WS-PREV-READ               PIC 9(07).                 
               10 WS-PREV-READ-DECIMAL       PIC V9(03).                
COB305     05 WS-MC-CONSTANT        PIC S9(6)V9(3) COMP-3 VALUE 0.     
           05  WS-METER-PRESSURE             PIC S9(9) USAGE COMP.      
           05  WS-PCOMP-FCT                  PIC S9(2)V9(5) COMP-3      
                                                  VALUE 0.              
           05  WS-MIN-NO-UNITS               PIC S9(9)V COMP-3 VALUE 0. 
           05  WS-MAX-NO-UNITS               PIC S9(9)V COMP-3 VALUE 0. 
           05  WS-PREV-LOCAL-OFFICE          PIC X(03) VALUE SPACES.    
           05  WS-FBW71-FILTERING-INFO       PIC X(80) VALUE SPACES.    
           05  WS-AMR-COMM-FREQ-CD           PIC  9(08).                
           05  WS-E-G-UTIL-TYPE              PIC  X(01).                
           05  WS-B-E-G-UTIL-TYPE            PIC  X(01).                
           05  WS-MAX-RD-SRC-ROWS            PIC S9(04) COMP VALUE +25. 
           05  WS-RD-SRC-COUNT               PIC S9(04) COMP.           
           05  WS-RD-SRC-SUB                 PIC S9(04) COMP.           
           05 WS-SEND-READ-FL                PIC  X(01) VALUE ' '.      
               88 NOT-SEND-MTR-FOR-READ             VALUE 'N' ' '.      
               88 SEND-MTR-FOR-READ                 VALUE 'Y'.          
           05  WS-RD-SRC-MATCH-SW            PIC  9(01) VALUE 1.        
               88 WS-RD-SRC-NOT-MATCHED                 VALUE 1.        
               88 WS-RD-SRC-MATCHED                     VALUE 2.        
           05  WS-FORMATTED-DATA-FL            PIC  9(01) VALUE 0.      
               88 FORMATTED-DATA-NONE                   VALUE 0.        
               88 FORMATTED-DATA-MN                     VALUE 1.        
               88 FORMATTED-DATA-RG                     VALUE 2.        
           05  WS-REG-MATCH-FOUND-FL           PIC  9(01) VALUE 0.      
               88 NO-REG-MATCH-FOUND                    VALUE 0.        
               88 REG-MATCH-FOUND                       VALUE 1.        
           05  WS-HILO-LIMITS-CALC-FL          PIC  9(01) VALUE 0.      
               88 NO-HILO-LIMITS-CALC                   VALUE 0.        
               88 HILO-LIMITS-CALC                      VALUE 1.        
           05  WS-RD-FMT-ENTRIES-WQ-FL         PIC  9(01) VALUE 0.      
               88 NO-RD-FMT-ENTRIES-WQ                  VALUE 0.        
               88 RD-FMT-ENTRIES-WQ                     VALUE 1.        
           05  WS-COMPUTE-HI-LO-KW.                                     
               10 WS-HI-READ-KW                PIC 9(09) VALUE 0.       
               10 WS-LO-READ-KW                PIC 9(09) VALUE 0.       
               10 WS-HI-KW-HOLD                PIC S9(08)V9(3)          
                                                  COMP-3 VALUE 0.       
               10 WS-LO-KW-HOLD                PIC S9(08)V9(3)          
                                                  COMP-3 VALUE 0.       
           05  WS-COMPUTE-HI-LO-KVA.                                    
               10 WS-HI-READ-KVA               PIC 9(09) VALUE 0.       
               10 WS-LO-READ-KVA               PIC 9(09) VALUE 0.       
               10 WS-HI-KVA-HOLD               PIC S9(08)V9(3)          
                                                  COMP-3 VALUE 0.       
               10 WS-LO-KVA-HOLD               PIC S9(08)V9(3)          
                                                  COMP-3 VALUE 0.       
           05 WS-RECORDS-CHECK                 PIC X(01) VALUE ' '.     
              88 NO-MORE-RECORDS                       VALUE 'Y'.       
           05 WS-LG-MTR-SUFFIX                 PIC X(09)                
                                                 VALUE '000000000'.     
           05 WS-LG-DEVICE-ID.                                          
              10 WS-9-DGT-MTR-NO               PIC X(09).               
              10 WS-9-DGT-SUFFIX               PIC X(09).               
      *                                                                         
       01  WS-DATE-NULL                PIC S9(04)    COMP   VALUE +0.   
       01  WS-DATE-NULL-2              PIC S9(04)    COMP   VALUE +0.   
       01  WS-DATE-NULL-3              PIC S9(04)    COMP   VALUE +0.   
       01  WS-TIME-NULL-2              PIC S9(04)    COMP   VALUE +0.   
       01  WS-TIME-NULL-3              PIC S9(04)    COMP   VALUE +0.   
       01  WS-AT-TIME-NULL             PIC S9(04)    COMP   VALUE +0.   
       01  WS-DATE-CCYYMMDD            PIC X(10)     VALUE SPACES.      
       01  WS-DATE-CCYYMMDD-RED  REDEFINES  WS-DATE-CCYYMMDD.           
           05  WS-CYMD-CC-YY-MM        PIC 9(07).                       
           05  FILLER REDEFINES WS-CYMD-CC-YY-MM.                       
               10  WS-CYMD-CC-YY       PIC 9(04).                       
               10  WS-CYMD-CC-YY-BREAKDOWN                              
                   REDEFINES WS-CYMD-CC-YY.                             
                   15  WS-CYMD-CC      PIC 9(02).                       
                   15  WS-CYMD-YY      PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-CYMD-MM          PIC 9(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-CYMD-DD              PIC 9(02).                       
      *                                                                         
       01  WS-CUR-DATE-BREAKDOWN       PIC X(10).                       
       01  WS-CUR-DATE-BREAKDOWN-RED                                    
           REDEFINES WS-CUR-DATE-BREAKDOWN.                             
           05  WS-CUR-CC               PIC 9(02).                       
           05  WS-CUR-YY               PIC 9(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-CUR-MM               PIC 9(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-CUR-DD               PIC 9(02).                       
      *                                                                         
       01  WS-STOP-PARM-BREAKDOWN.                                      
           05  WS-STOP-PARM-ACCOUNT-NO                                  
                                       PIC 9(13).                       
           05  FILLER                  PIC X(38).                       
      *                                                                         
       01  WS-RST-MISC.                                                 
           05  WS-RST-DATA-LENGTH      PIC S9(04)    COMP VALUE +128.   
           05  WS-IS-THIS-A-RESTART    PIC X(01)     VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
           05  WS-PRINT-COUNTERS       PIC X(01)     VALUE 'A'.         
           05  WS-RESTART-REQ          PIC X(01).                       
           05  WS-DEFAULT-RESTART-REQ  PIC X(01)     VALUE 'N'.         
           05  WS-COUNT-UNSUCCESSFUL-ROWS                               
                                       PIC S9(04)    VALUE ZEROES COMP. 
           05  WS-REPOSITION-NEEDED    PIC X(01)     VALUE 'Y'.         
               88  REPOSITION-NOT-NEEDED             VALUE 'N'.         
           05  WS-FLAG-TO-TURN-OFF-COMMITS                              
                                       PIC 9(04)     VALUE 9999.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT                                
                                       PIC 9(04)     VALUE 4.           
           05  WS-CHKP-LUW-LIMIT       PIC 9(04)     VALUE ZERO.        
           05  WS-CHKP-LUW-COUNTER     PIC 9(04)     VALUE ZERO COMP-3. 
           05  WS-DEFAULT-CHKP-UPD-LIMIT                                
                                       PIC 9(04)     VALUE 20.          
           05  WS-CHKP-UPD-LIMIT       PIC 9(04)     VALUE ZERO.        
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID      PIC X(02)     VALUE '09'.        
               10  WS-CHKP-PART-NO     PIC 9(01)     VALUE 1.           
               10  WS-CHKP-SEQ-NO      PIC 9(05)     VALUE ZERO.        
           05  WS-STOP-ACCOUNT-NO      PIC 9(13).                       
           05  WS-RPT-SEQ-NO           PIC S9(05)    VALUE ZERO COMP-3. 
           05  WS-RECORD-COUNT-PIC-9   PIC S9(07)    VALUE ZERO.        
           05  WS-FCSDB09-REC-CNTR     PIC S9(07)    VALUE ZERO COMP-3. 
      *                                                                         
       01  WS-RST-DATA.                                                 
           05 WS-RST-PROCESS-TYPE      PIC 9(01).                       
           05 WS-RST-JOB-COMPLETE      REDEFINES                        
              WS-RST-PROCESS-TYPE      PIC X(01).                       
           05 WS-RST-JOB-STATUS        PIC X(01).                       
              88  WS-RUN-COMPLETED-NO-PROBLEMS       VALUE 'A'.         
              88  WS-RERUN-COMPLETED                 VALUE 'B'.         
              88  WS-RERUN-PENDING                   VALUE 'C'.         
           05 WS-RST-COMMON-DATE       PIC X(10) VALUE SPACES.          
           05 WS-RST-CHKP-SEQ-NO       PIC 9(05) VALUE ZERO.            
           05 WS-RST-ACCOUNT-NO        PIC 9(13) VALUE ZERO.            
           05 WS-RST-RECORD-COUNT      PIC 9(07) VALUE ZERO.            
           05 WS-RST-BW71-REC-CNTR     PIC 9(07) VALUE ZERO.            
           05 WS-RST-CA55-REC-CNTR     PIC 9(07) VALUE ZERO.            
           05 WS-RST-RP87-REC-CNTR     PIC 9(07) VALUE ZERO.            
           05 WS-RST-RP123-REC-CNTR    PIC 9(07) VALUE ZERO.            
           05 WS-RST-MN-UPDT-CNTR      PIC 9(07) VALUE ZERO.            
           05 WS-RST-AT-UPDT-CNTR      PIC 9(07) VALUE ZERO.            
           05 WS-RST-RG-UPDT-CNTR      PIC 9(07) VALUE ZERO.            
           05 WS-RST-CA55-COM-CNTR     PIC 9(07) VALUE ZERO.            
           05 WS-RST-RP87-COM-CNTR     PIC 9(07) VALUE ZERO.            
           05 WS-RST-RP123-COM-CNTR    PIC 9(07) VALUE ZERO.            
           05 WS-RST-CA55-TOT-CNTR     PIC 9(07) VALUE ZERO.            
           05 WS-RST-RP87-TOT-CNTR     PIC 9(07) VALUE ZERO.            
           05 WS-RST-RP123-TOT-CNTR    PIC 9(07) VALUE ZERO.            
      *                                                                         
       01  WS-HOLD-FIOBW71             PIC X(700)    VALUE SPACES.      
      *                                                                         
       01  WS-COUNTERS.                                                 
           05 WS-COUNT-FCSBW71         PIC 9(07)     VALUE ZERO.        
           05 WS-DISP-FCSBW71          PIC ZZZ,ZZ9.                     
           05 WS-DISP-FCSRP87          PIC ZZZ,ZZ9.                     
           05 WS-DISP-FCSCA55          PIC ZZZ,ZZ9.                     
           05 WS-DISP-FCSRP123         PIC ZZZ,ZZ9.                     
           05 WS-DISP-AT-UPD           PIC ZZZ,ZZ9.                     
           05 WS-DISP-MN-UPD           PIC ZZZ,ZZ9.                     
           05 WS-DISP-RG-UPD           PIC ZZZ,ZZ9.                     
      *                                                                         
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
      *                                                                         
       01  WS-MISCELLANEOUS-DATA.                                       
           05  WS-SUB                  PIC 9(04)     VALUE ZERO COMP.   
           05  WS-FCA55-COMPANY-NO     PIC X(02)     VALUE SPACES.      
           05  WS-FCA87-COMPANY-NO     PIC X(02)     VALUE SPACES.      
           05  WS-FCA123-COMPANY-NO    PIC X(02)     VALUE SPACES.      
P00135     05  WS-SIX-DIALS            PIC S9(4) COMP VALUE 6.          
P00135     05  WS-READ-TYPE-G6         PIC X(02)     VALUE 'G6'.        
ACT069     05  SCSCB077                PIC X(08)     VALUE 'SCSCB077'.  
ACT069     05  WS-CURRENT-DATE         PIC X(10).                       
ACT069     05  WS-INPUT-TS.                                             
ACT069         10 WS-INPUT-DATE-PT    PIC X(10).                        
ACT069         10 WS-INPUT-TIME-PT    PIC X(16)      VALUE              
ACT069                                               '-00.00.00.000000'.
      *                                                                         
       01  WS-WORK-DATE.                                                
           10  WS-WORK-CC               PIC 99.                         
           10  WS-WORK-YY               PIC 99.                         
           10  FILLER                   PIC X.                          
           10  WS-WORK-MM               PIC 99.                         
           10  FILLER                   PIC X.                          
           10  WS-WORK-DD               PIC 99.                         
      *                                                                         
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00039.                                                           
       COPY CWS00038.                                                           
      *                                                                         
       01  WS-INPUT-DATA-R25 REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           10  WS-SYSIPT-R25           PIC X(22).                       
               88  EXTRACT-RMV-MTRS  VALUE 'EXTRACT REMOVED METERS'.    
           10  FILLER                  PIC X(01).                       
           10  WS-INPUT-FLAG           PIC X(01).                       
           10  FILLER                  PIC X(08).                       
           10  WS-INPUT-COMP-NO        PIC 9(02).                       
           10  FILLER                  PIC X(06).                       
           10  WS-INPUT-UTIL-TYPE      PIC X(01).                       
           10  FILLER                  PIC X(12).                       
      *                                                                         
       COPY CWS00074.                                                           
       COPY CWS00004.                                                           
       COPY CWS00007.                                                           
       COPY CWS00011.                                                           
       COPY CWS00016.                                                           
           EXEC SQL                                                             
                INCLUDE CWS00018                                                
           END-EXEC.                                                            
       COPY CWS00028.                                                           
       COPY CWS00036.                                                           
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
ACT069******* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
ACT069     EXEC SQL                                                             
ACT069          INCLUDE CWS00077                                                
ACT069     END-EXEC.                                                            
ACT069*                                                                         
      ***************** COPY CWS00314.                                          
      *                                                                         
       01 WS-SWITCHES.                                                  
           05 WS-CONTROL-RECORD-FL        PIC 9(01) VALUE 0.            
              88 DATA-RECORD-FOUND                  VALUE 0.            
              88 CNTL-BEGIN-REC-FOUND               VALUE 1.            
              88 CNTL-END-REC-FOUND                 VALUE 2.            
           05 WS-IS-THIS-AN-MRB-CYCLE PIC X(01)     VALUE 'N'.          
               88  THIS-IS-AN-MRB-CYCLE              VALUE 'Y'.         
           05  WS-IS-THIS-A-NEW-CUSTOMER                                
                                       PIC X(01)     VALUE 'N'.         
               88  THIS-IS-A-NEW-CUSTOMER            VALUE 'Y'.         
           05  WS-END-OF-CYCLE         PIC X(01)     VALUE 'N'.         
               88  END-OF-CYCLE-IS-REACHED           VALUE 'Y'.         
           05  WS-METER-FOUND-SW       PIC X(01)     VALUE 'N'.         
               88  METER-FOUND                       VALUE 'Y'.         
               88  NOT-METER-FOUND                   VALUE 'N'.         
           05  WS-SECURED-RATE-FL      PIC X(01)     VALUE SPACES.      
               88  SECURED-RATE                      VALUE 'Y'.         
               88  NOT-SECURED-RATE                  VALUE 'N'.         
           05  WS-CA55-FIRST-TIME      PIC X(01)     VALUE 'Y'.         
               88  CA55-NOT-FIRST-TIME               VALUE 'N'.         
           05  WS-CA87-FIRST-TIME      PIC X(01)     VALUE 'Y'.         
               88  CA87-NOT-FIRST-TIME               VALUE 'N'.         
           05  WS-CA123-FIRST-TIME     PIC X(01)     VALUE 'Y'.         
               88  CA123-NOT-FIRST-TIME              VALUE 'N'.         
           05  WS-READ-TYPE-SW         PIC X(01)     VALUE ' '.         
               88  NORMAL-READ-REQ                   VALUE ' '.         
               88  SPECIAL-READ-REQ                  VALUE 'N'.         
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-CARRIER-CNST1        PIC V9(5)     VALUE 0.00625.     
           05  WS-CARRIER-CNST2        PIC 9(3)      VALUE 951.         
           05  WS-YES                  PIC X(01)     VALUE 'Y'.         
           05  WS-NO                   PIC X(01)     VALUE 'N'.         
           05  WS-ASTERISK             PIC X(01)     VALUE '*'.         
           05  WS-1                    PIC X(01)     VALUE '1'.         
           05  WS-2                    PIC X(01)     VALUE '2'.         
           05  WS-D                    PIC X(01)     VALUE 'D'.         
           05  WS-E                    PIC X(01)     VALUE 'E'.         
           05  WS-F                    PIC X(01)     VALUE 'F'.         
           05  WS-G                    PIC X(01)     VALUE 'G'.         
           05  WS-H                    PIC X(01)     VALUE 'H'.         
           05  WS-I                    PIC X(01)     VALUE 'I'.         
           05  WS-J                    PIC X(01)     VALUE 'J'.         
           05  WS-K                    PIC X(01)     VALUE 'K'.         
           05  WS-L                    PIC X(01)     VALUE 'L'.         
           05  WS-M                    PIC X(01)     VALUE 'M'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-O                    PIC X(01)     VALUE 'O'.         
           05  WS-Q                    PIC X(01)     VALUE 'Q'.         
           05  WS-R                    PIC X(01)     VALUE 'R'.         
           05  WS-S                    PIC X(01)     VALUE 'S'.         
           05  WS-T                    PIC X(01)     VALUE 'T'.         
           05  WS-U                    PIC X(01)     VALUE 'U'.         
           05  WS-V                    PIC X(01)     VALUE 'V'.         
           05  WS-W                    PIC X(01)     VALUE 'W'.         
           05  WS-X                    PIC X(01)     VALUE 'X'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-Z                    PIC X(01)     VALUE 'Z'.         
           05  WS-NC                   PIC X(02)     VALUE 'NC'.        
           05  WS-MA                   PIC X(02)     VALUE 'MA'.        
           05  WS-IPE                  PIC X(03)     VALUE 'IPE'.       
           05  WS-BTR                  PIC X(03)     VALUE 'BTR'.       
           05  WS-AROP                 PIC X(01)     VALUE 'A'.         
A04527     05  WS-STORM                PIC X(01)     VALUE 'S'.         
A04527     05  WS-55                   PIC XX        VALUE '55'.        
A04527     05  WS-STORM-CRITICAL-DATE  PIC X(10) VALUE '2020-04-03'.    
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSBW171'.  
           05  PROGRAM-NAME            PIC X(08)     VALUE 'PCSCA171'.  
           05  WS-PCSSF041             PIC X(08)     VALUE 'PCSSF041'.  
           05  WS-13-NINES             PIC 9(13)     VALUE              
                                                     9999999999999.     
           05  WS-KWH                  PIC X(03)     VALUE 'KWH'.       
           05  WS-CCF                  PIC X(03)     VALUE 'CCF'.       
           05  WS-REMOVED              PIC X(01)     VALUE 'K'.         
           05  WS-ITRON                PIC X(01)     VALUE 'I'.         
           05  WS-CARD-READ            PIC X(01)     VALUE 'C'.         
           05  WS-MV90                 PIC X(01)     VALUE 'M'.         
           05  WS-BUSINESS             PIC X(01)     VALUE 'B'.         
           05  WS-INACTIVE-METER       PIC X(01)     VALUE 'J'.         
           05  WS-811                  PIC S9(9) VALUE -811 COMP.       
           05  WS-SPCL-BILL-SCHEDULE   PIC X(25)     VALUE              
                                      'SPECIAL BILLING SCHEDULE '.      
           05  WS-INVALID-IC-NUMBER    PIC X(25)     VALUE              
                                      'INVALID IC NUMBER        '.      
           05  WS-INVALID-NUM-UNMTR-SERVICES                            
                                       PIC X(25)     VALUE              
                                      'INVALID NUM OF SERVICES  '.      
           05  WS-INVALID-HORSEPOWER-RATING                             
                                       PIC X(25)     VALUE              
                                      'INVALID HORSEPOWER RATING'.      
           05  WS-INVALID-POWER-FCTR-RATING                             
                                       PIC X(25)     VALUE              
                                      'INVALID POWER-FCTR RATING'.      
           05  WS-INA-TENANT-ZERO-USAGE                                 
                                       PIC X(25)     VALUE              
                                      'INACTIVE TENANT...0 USAGE'.      
           05  WS-CANCEL-RATE-NO-ESTIMATE                               
                                       PIC X(25)     VALUE              
                                      'RATE CANNOT BE ESTIMATED '.      
           05  WS-INVALID-STATUS-CODE  PIC X(25)     VALUE              
                                      'INVALID STATUS CODE      '.      
           05  WS-INVALID-FUNC-ID      PIC X(25)     VALUE              
                                      'INVALID FUNC-ID          '.      
           05  WS-SYSTEM-EST-USAGE     PIC X(25)     VALUE              
                                      'SYSTEM ESTIMATED USAGE   '.      
           05  WS-EXCESS-CARD-READ     PIC X(25)     VALUE              
                                      'EXCESS CARD READS        '.      
           05  WS-ESTIMATE-AT-3        PIC X(25)     VALUE              
                                      'NUM OF ESTIMATES AT 3    '.      
           05  WS-BTR-REC-CREATED      PIC X(25)     VALUE              
                                      'BILL TRANS-REC CREATED   '.      
           05  WS-TBL-OVFLOW-PR-SEQ    PIC X(25)     VALUE              
                                      'EDP-TBL-OVF..MTR P/RE-SEQ'.      
           05  WS-HIST-MASTER-CREATED  PIC X(25)     VALUE              
                                      'BILL HIST. MASTER CREATED'.      
           05  WS-BILL-HEADER-CREATED  PIC X(25)     VALUE              
                                      'BILL HEADER CREATED      '.      
           05  WS-SEP-DEM-NOT-READ     PIC X(25)     VALUE              
                                      'SEP-DEMAND METER NOT READ'.      
           05  WS-CMB-DEM-NOT-READ     PIC X(25)     VALUE              
                                      'CMB-DEMAND METER NOT READ'.      
           05  WS-IRRIG-TURNED-ON      PIC X(25)     VALUE              
                                      'IRRIGATION TURNED ON ....'.      
           05  WS-INACT-IRRIGATION-NO-BILL                              
                                       PIC X(25)     VALUE              
                                      'INACT IRRIGATION, NO BILL'.      
           05  WS-ACT-IRRIG-REG-NOT-READ                                
                                       PIC X(25)     VALUE              
                                      'ACT IRRIG REGSTR NOT READ'.      
           05  WS-KVR-QHR-NOT-READ     PIC X(25)     VALUE              
                                      'KVR/QHR METER NOT READ   '.      
           05  WS-SUB-COGEN-NOT-READ   PIC X(25)     VALUE              
                                      'SUB/COGEN METER NOT READ '.      
           05  WS-ACCT-NO-EST          PIC X(25)     VALUE              
                                      'DO NOT ESTIMATE THIS ACCT'.      
           05  WS-READER-NO-EST        PIC X(25)     VALUE              
                                      'RDR REQUESTED NO ESTIMATE'.      
           05  WS-NO-SYS-EST-USE       PIC X(25)     VALUE              
                                      'NO EST. AVAIL..THIS METER'.      
           05  WS-EXCESSIVE-ESTIMATE   PIC X(25)     VALUE              
                                      'NO EST. MORE THAN 40 DAYS'.      
           05  WS-NO-EST-LESS-5-DAYS   PIC X(25)     VALUE              
                                      'NO EST. LESS THAN 5 DAYS '.      
           05  WS-RATE-NO-BILLED       PIC X(25)     VALUE              
                                      'THIS RATE.... NO BILLED  '.      
           05  WS-LESS-5-DAYS-USE      PIC X(30)     VALUE              
                                      'LESS THAN 5 DAYS USAGE        '. 
           05  WS-FINAL-BILL-NO-USAGE  PIC X(30)     VALUE              
                                      '** FINAL BILL ... NO USAGE ***'. 
           05  WS-NO-BILL-INFORMATION  PIC X(30)     VALUE              
                                      '** NO BILLING INFORMATION ****'. 
           05  WS-NO-CDM-FOUND         PIC X(25)     VALUE              
                                      'NO CONTRACT DEMAND       '.      
           05  WS-ILLEGAL-USE-COMBINATION                               
                                       PIC X(25)     VALUE              
                                      'ILLEGAL USE COMBINATION  '.      
           05  WS-ILLEGAL-MTR-COMBINATION                               
                                       PIC X(25)     VALUE              
                                      'ILLEGAL MTR COMBINATION  '.      
           05  WS-BACKOUT-TRAN-REJECTED                                 
                                       PIC X(25)     VALUE              
                                      'BACKOUT TRAN REJECTED    '.      
           05  WS-OVER-4-MONTHS        PIC X(25)     VALUE              
                                      'OVER 4 MONTHS BILL       '.      
           05  WS-OVER-1-MONTH         PIC X(25)     VALUE              
                                      'OVER 1 MONTH BILL        '.      
           05  WS-MUST-HAVE-DEM        PIC X(25)     VALUE              
                                      'RATE MUST HAVE DEMAND MTR'.      
           05  WS-NEGATIVE-USE         PIC X(25)     VALUE              
                                      'NEGATIVE USAGE           '.      
           05  WS-RATE-100-210-POSS-HIGH-USE                            
                                       PIC X(25)     VALUE              
                                      'RT 100/210 POSS HIGH USE '.      
           05  WS-COM-810-910-POSS-HIGH-USE                             
                                       PIC X(25)     VALUE              
                                      'COM-810/910 POSS HIGH USE'.      
           05  WS-RES-810-910-POSS-HIGH-USE                             
                                       PIC X(25)     VALUE              
                                      'RES-810/910 POSS HIGH USE'.      
           05  WS-DAYS-SINCE-LAST-READ-MSG.                             
               10  WS-DAYS-SINCE-LAST-READ                              
                                       PIC ZZ9.                         
               10  FILLER              PIC X(22)     VALUE              
                                      ' DAYS SINCE LAST READ '.         
           05  WS-OVER-1-MONTH-UNMTRD-USE                               
                                       PIC X(25)     VALUE              
                                      'OVER 1 MONTH UNMTRD USE  '.      
           05  WS-OVER-4-MONTH-UNMTRD-USE                               
                                       PIC X(25)     VALUE              
                                      'OVER 4 MONTH UNMTRD USE  '.      
           05  WS-GAS-CHECK-LOW-USAGE  PIC X(25)     VALUE              
                                      '**GAS - CHECK LOW USAGE**'.      
           05  WS-GAS-CHECK-HIGH-USAGE PIC X(25)     VALUE              
                                      '**GAS - CHECK HIGH USAGE*'.      
      *                                                                         
       01  WS-LAST-YEAR-GAS-DATA  COMP-3.                               
           05  WS-PRI-SEQ-NO-LAST-YEAR-GAS                              
                                       PIC S9(03)    VALUE ZERO.        
           05  WS-PRI-SEQ-DAYS-LAST-YEAR-GAS                            
                                       PIC S9(03)    VALUE ZERO.        
           05  WS-LAST-YEAR-GAS.                                        
               10  WS-IC-NO-LAST-YEAR-GAS                               
                                       PIC S9(03)    VALUE ZERO.        
               10  WS-DAYS-LAST-YEAR-GAS                                
                                       PIC S9(03)    VALUE ZERO.        
               10  WS-USAGE-LAST-YEAR-GAS                               
                                       PIC S9(07)    VALUE ZERO.        
           05  WS-LAST-YEAR-GAS-1.                                      
               10  WS-IC-NO-LAST-YEAR-GAS-1                             
                                       PIC S9(03)    VALUE ZERO.        
               10  WS-DAYS-LAST-YEAR-GAS-1                              
                                       PIC S9(03)    VALUE ZERO.        
               10  WS-USAGE-LAST-YEAR-GAS-1                             
                                       PIC S9(07)    VALUE ZERO.        
           05  WS-LAST-YEAR-GAS-2.                                      
               10  WS-IC-NO-LAST-YEAR-GAS-2                             
                                       PIC S9(03)    VALUE ZERO.        
               10  WS-DAYS-LAST-YEAR-GAS-2                              
                                       PIC S9(03)    VALUE ZERO.        
               10  WS-USAGE-LAST-YEAR-GAS-2                             
                                       PIC S9(07)    VALUE ZERO.        
      *                                                                         
       01  WS-ERROR-PRINT-LINE.                                         
           05  P-ERROR-TYPE-BILL-MRB   PIC X(07).                       
           05  P-RW-CODE               PIC X(03).                       
           05  P-ERROR-MESSAGE         PIC X(25).                       
           05  FILLER                  PIC X(02)     VALUE SPACES.      
           05  P-PREMISE-NO            PIC 9(10).                       
           05  FILLER                  PIC X(06)     VALUE SPACES.      
           05  P-ACCOUNT-NUMBER        PIC 9(13).                       
           05  FILLER                  PIC X(66)     VALUE SPACES.      
      *                                                                         
       01  P-ACCT-NAME-LINE.                                            
           05  FILLER                  PIC X(03)     VALUE SPACES.      
           05  P-ACCT-NAME             PIC X(38).                       
           05  FILLER                  PIC X(101)    VALUE SPACES.      
      *                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
           05  WS-DISPLAY-SQLCODE      PIC ---9.                        
      *                                                                         
       01  WS-MTR-RD-FMT-TABLE.                                         
           05 WS-RD-FMT-COUNT          PIC 9(05) VALUE ZERO.            
           05 WS-MRF-SUB               PIC 9(05) VALUE ZERO.            
           05 WS-MRF-TABLE.                                             
              10 TAB-CODE-UTIL-TYPE     OCCURS 1000 TIMES  PIC X(01).   
              10 TAB-DIGTL-MTR-TYPE     OCCURS 1000 TIMES  PIC X(03).   
              10 TAB-PROGRAM-ID         OCCURS 1000 TIMES  PIC X(02).   
              10 TAB-MTR-READ-SOURCE-CD OCCURS 1000 TIMES  PIC X(01).   
              10 TAB-REMOTE-READ-IND    OCCURS 1000 TIMES  PIC X(01).   
              10 TAB-CODE-USAGE-TYPE    OCCURS 1000 TIMES  PIC X(01).   
P00251        10 TAB-CODE-USAGE-ID      OCCURS 1000 TIMES  PIC X(01).   
P00251        10 TAB-CODE-USAGE-SOURCE  OCCURS 1000 TIMES  PIC X(01).   
P00251        10 TAB-REG-ID-NO          OCCURS 1000 TIMES               
P00251                                          PIC S9(4) USAGE COMP.   
              10 TAB-CODE-TIME-PERIOD   OCCURS 1000 TIMES               
                                                PIC S9(4) USAGE COMP.   
              10 TAB-CODE-TOU-SEASN     OCCURS 1000 TIMES  PIC X(01).   
              10 TAB-MTR-RD-DISP-CD     OCCURS 1000 TIMES  PIC X(03).   
              10 TAB-INDEX-VALUE-CD     OCCURS 1000 TIMES  PIC X(01).   
              10 TAB-NO-READ-DIGITS     OCCURS 1000 TIMES               
                                                PIC S9(4) USAGE COMP.   
              10 TAB-NO-READ-DECIMALS   OCCURS 1000 TIMES               
                                                PIC S9(4) USAGE COMP.   
              10 TAB-READ-SEQUENCE-NO   OCCURS 1000 TIMES               
                                                PIC S9(4) USAGE COMP.   
              10 TAB-CNSMPTN-READ-FL    OCCURS 1000 TIMES  PIC X(01).   
              10 TAB-MIN-READ           OCCURS 1000 TIMES               
                                                PIC S9(9) USAGE COMP.   
              10 TAB-MAX-READ           OCCURS 1000 TIMES               
                                                PIC S9(9) USAGE COMP.   
      *                                                                         
       01  WS-MATCH-REG-ARRAY.                                          
           05 WS-MATCH-REG-COUNT       PIC 9(05) VALUE ZERO.            
           05 WS-MRF-SUB2              PIC 9(05) VALUE ZERO.            
           05 WS-MATCH-REG-ROW OCCURS   25  TIMES.                      
              10 ARR-CODE-USAGE-TYPE    PIC X(01).                      
P00251        10 ARR-CODE-USAGE-ID      PIC X(01).                      
P00251        10 ARR-CODE-USAGE-SOURCE  PIC X(01).                      
P00251        10 ARR-REG-ID-NO          PIC S9(4) USAGE COMP.           
              10 ARR-CODE-TIME-PERIOD   PIC S9(4) USAGE COMP.           
              10 ARR-CODE-TOU-SEASN     PIC X(01).                      
              10 ARR-MTR-RD-DISP-CD     PIC X(03).                      
              10 ARR-INDEX-VALUE-CD     PIC X(01).                      
              10 ARR-NO-READ-DIGITS     PIC S9(4) USAGE COMP.           
              10 ARR-NO-READ-DECIMALS   PIC S9(4) USAGE COMP.           
              10 ARR-READ-SEQUENCE-NO   PIC S9(4) USAGE COMP.           
              10 ARR-CNSMPTN-READ-FL    PIC X(01).                      
              10 ARR-MIN-READ           PIC S9(9) USAGE COMP.           
              10 ARR-MAX-READ           PIC S9(9) USAGE COMP.           
              10 ARR-MATCH-FOUND        PIC X(01).                      
      *                                                                         
       01 WS-FILTER-INFO-TABLE.                                         
          05 WS-FILTER-INFO-COUNT     PIC 9(05) VALUE ZERO.             
          05 FCSFI-SUB                PIC 9(05) VALUE ZERO.             
          05 WS-FILTER-INFO-REC.                                        
             10 TB-CODE-VALUE       OCCURS 100 TIMES  PIC X(10).        
             10 TB-FILTER-INFO-DATA OCCURS 100 TIMES  PIC X(80).        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      * CSS_MTR_RD_FMT                                                          
           EXEC SQL                                                             
               INCLUDE TBRDFMT                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRGREAD                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDGMTYP                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLCOFRT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATBLNM                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRDSRCE                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTSRCE                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_RATE_HIGH_LOW                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTHGLW                                                 
           END-EXEC.                                                            
      *                                                                         
A00795     EXEC SQL                                                             
A00795        INCLUDE TBRTERPT                                                  
A00795     END-EXEC.                                                            
A00795*                                                                         
A00795******************************************************************00750000
A00795* HIGH LOW ROUTINE WORKING STORAGE                                00850000
A00795******************************************************************00770000
A00795     EXEC SQL                                                             
A00795         INCLUDE CWSCA072                                                 
A00795     END-EXEC.                                                            
A00795*                                                                         
      * CSS_METER_ATTCHMTS                                                      
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_MTR_ATT_TYPE                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRATP                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_CODE_VALUE                                                          
           EXEC SQL                                                             
             INCLUDE TBCDVALU                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE RD_FMT CURSOR WITH ROWSET POSITIONING FOR          
             SELECT CODE_UTIL_TYPE,                                     
                    DIGTL_MTR_TYPE,                                     
                    PROGRAM_ID,                                         
                    MTR_READ_SOURCE_CD,                                 
                    REMOTE_READ_IND,                                    
                    CODE_USAGE_TYPE,                                    
P00251              CODE_USAGE_ID,                                      
P00251              CODE_USAGE_SOURCE,                                  
P00251              REG_ID_NO,                                          
                    CODE_TIME_PERIOD,                                   
                    CODE_TOU_SEASN,                                     
                    MTR_RD_DISP_CD,                                     
                    INDEX_VALUE_CD,                                     
                    NO_READ_DIGITS,                                     
                    NO_READ_DECIMALS,                                   
                    READ_SEQUENCE_NO,                                   
                    CNSMPTN_READ_FL,                                    
                    MIN_READ,                                           
                    MAX_READ                                            
             FROM CSS_MTR_RD_FMT WITH(READUNCOMMITTED)                          
P00251        WHERE REMOTE_READ_IND IN ('0','A')                        
              AND CODE_TOU_SEASN = 'C'                                  
             ORDER BY CODE_UTIL_TYPE,                                   
                      DIGTL_MTR_TYPE DESC,                              
                      PROGRAM_ID,                                       
                      MTR_READ_SOURCE_CD,                               
                      REMOTE_READ_IND,                                  
                      READ_SEQUENCE_NO                                  
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE RD_FMT CURSOR WITH ROWSET POSITIONING FOR                  
MFA-TR*      SELECT CODE_UTIL_TYPE,                                             
MFA-TR*             DIGTL_MTR_TYPE,                                             
MFA-TR*             PROGRAM_ID,                                                 
MFA-TR*             MTR_READ_SOURCE_CD,                                         
MFA-TR*             REMOTE_READ_IND,                                            
MFA-TR*             CODE_USAGE_TYPE,                                            
MFA-TR*             CODE_USAGE_ID,                                              
MFA-TR*             CODE_USAGE_SOURCE,                                          
MFA-TR*             REG_ID_NO,                                                  
MFA-TR*             CODE_TIME_PERIOD,                                           
MFA-TR*             CODE_TOU_SEASN,                                             
MFA-TR*             MTR_RD_DISP_CD,                                             
MFA-TR*             INDEX_VALUE_CD,                                             
MFA-TR*             NO_READ_DIGITS,                                             
MFA-TR*             NO_READ_DECIMALS,                                           
MFA-TR*             READ_SEQUENCE_NO,                                           
MFA-TR*             CNSMPTN_READ_FL,                                            
MFA-TR*             MIN_READ,                                                   
MFA-TR*             MAX_READ                                                    
MFA-TR*      FROM CSS_MTR_RD_FMT                                                
MFA-TR*       WHERE REMOTE_READ_IND IN ('0','A')                                
MFA-TR*       AND CODE_TOU_SEASN = 'C'                                          
MFA-TR*      ORDER BY CODE_UTIL_TYPE,                                           
MFA-TR*               DIGTL_MTR_TYPE DESC,                                      
MFA-TR*               PROGRAM_ID,                                               
MFA-TR*               MTR_READ_SOURCE_CD,                                       
MFA-TR*               REMOTE_READ_IND,                                          
MFA-TR*               READ_SEQUENCE_NO                                          
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE UTIL_CSR CURSOR FOR                               
               SELECT CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,READ_ROUTE                                        
                     ,RATE_PLAN_NO                                      
                     ,READ_CYCLE                                        
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO  = :UT-ACCOUNT-NO                      
                  AND CODE_UTIL_TYPE IN ( 'E', 'G' )                    
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE UTIL_CSR CURSOR FOR                                       
MFA-TR*        SELECT CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,READ_ROUTE                                                
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,READ_CYCLE                                                
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO  = :UT-ACCOUNT-NO                              
MFA-TR*           AND CODE_UTIL_TYPE IN ( 'E', 'G' )                            
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ***  CSS_MTRD_ENVRNMT                                                     
      *                                                                         
           EXEC SQL                                                     
              DECLARE MTR_CSR CURSOR FOR                                
               SELECT MTR_REF_NO                                        
                     ,CODE_TIME_PERIOD                                  
                     ,METER_NO                                          
                     ,CODE_METER_LOC                                    
                     ,CODE_METER_STATUS                                 
                     ,CODE_DATA_PRESENT                                 
                     ,CODE_USAGE_TYPE                                   
                     ,CODE_USAGE_ID                                     
                     ,CODE_USAGE_SOURCE                                 
                     ,REG_ID_NO                                         
                     ,REGISTER_RD_SEQ                                   
                     ,CODE_CRNT_REG_READ                                
                     ,CODE_NO_RD_REASON                                 
                     ,CODE_LAST_REG_READ                                
                     ,REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TIME
           , 108), ':', '.') LAST_REG_READ_TIME                                
                     ,LAST_REG_READ_DATE                                
                     ,LAST_READ_VALUE                                   
                     ,NO_CONSEC_ESTIMATE                                
                     ,CODE_MTR_RD_INST1                                 
                     ,CODE_MTR_RD_INST2                                 
                     ,CODE_MTR_RD_INST3                                 
                     ,DIGTL_MTR_TYPE                                    
                     ,REMOTE_READ_IND                                   
                     ,MTR_READ_SOURCE_CD                                
                     ,PROGRAM_ID                                        
                     ,MIN_NO_UNITS                                      
                     ,MAX_NO_UNITS                                      
                     ,METER_PRESSURE                                    
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO              
                  AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE          
                  AND IC_NO               = :MN-IC-NO                   
                  AND CODE_METER_STATUS   <> 'K'                        
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MTR_CSR CURSOR FOR                                        
MFA-TR*        SELECT MTR_REF_NO                                                
MFA-TR*              ,CODE_TIME_PERIOD                                          
MFA-TR*              ,METER_NO                                                  
MFA-TR*              ,CODE_METER_LOC                                            
MFA-TR*              ,CODE_METER_STATUS                                         
MFA-TR*              ,CODE_DATA_PRESENT                                         
MFA-TR*              ,CODE_USAGE_TYPE                                           
MFA-TR*              ,CODE_USAGE_ID                                             
MFA-TR*              ,CODE_USAGE_SOURCE                                         
MFA-TR*              ,REG_ID_NO                                                 
MFA-TR*              ,REGISTER_RD_SEQ                                           
MFA-TR*              ,CODE_CRNT_REG_READ                                        
MFA-TR*              ,CODE_NO_RD_REASON                                         
MFA-TR*              ,CODE_LAST_REG_READ                                        
MFA-TR*              ,LAST_REG_READ_TIME                                        
MFA-TR*              ,LAST_REG_READ_DATE                                        
MFA-TR*              ,LAST_READ_VALUE                                           
MFA-TR*              ,NO_CONSEC_ESTIMATE                                        
MFA-TR*              ,CODE_MTR_RD_INST1                                         
MFA-TR*              ,CODE_MTR_RD_INST2                                         
MFA-TR*              ,CODE_MTR_RD_INST3                                         
MFA-TR*              ,DIGTL_MTR_TYPE                                            
MFA-TR*              ,REMOTE_READ_IND                                           
MFA-TR*              ,MTR_READ_SOURCE_CD                                        
MFA-TR*              ,PROGRAM_ID                                                
MFA-TR*              ,MIN_NO_UNITS                                              
MFA-TR*              ,MAX_NO_UNITS                                              
MFA-TR*              ,METER_PRESSURE                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO                      
MFA-TR*           AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE                  
MFA-TR*           AND IC_NO               = :MN-IC-NO                           
MFA-TR*           AND CODE_METER_STATUS   <> 'K'                                
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ***  CSS_REGISTER_READ                                                    
      *                                                                         
           EXEC SQL                                                     
              DECLARE REG_RD_CSR CURSOR FOR                             
               SELECT REG_ID_NO                                         
                     ,CODE_USAGE_TYPE                                   
                     ,CODE_USAGE_ID                                     
                     ,CODE_USAGE_SOURCE                                 
                     ,CODE_TIME_PERIOD                                  
                     ,REGISTER_RD_SEQ                                   
                     ,CODE_LAST_REG_READ                                
                     ,REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TM, 108), 
           ':', '.') LAST_REG_READ_TM                                  
                     ,LAST_REG_READ_DT                                  
                     ,LAST_READ_VALUE                                   
                     ,NEXT_READ_MONTH                                   
                     ,CODE_CRNT_REG_READ                                
                     ,CODE_NO_RD_REASON                                 
                     ,MIN_NO_UNITS                                      
                     ,MAX_NO_UNITS                                      
                 FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO     = :RG-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :RG-CODE-UTIL-TYPE               
                  AND IC_NO          = :RG-IC-NO                        
                  AND MTR_REF_NO     = :RG-MTR-REF-NO                   
A00795          ORDER BY CODE_TIME_PERIOD                               
A00795                  ,CODE_USAGE_ID                                  
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG_RD_CSR CURSOR FOR                                     
MFA-TR*        SELECT REG_ID_NO                                                 
MFA-TR*              ,CODE_USAGE_TYPE                                           
MFA-TR*              ,CODE_USAGE_ID                                             
MFA-TR*              ,CODE_USAGE_SOURCE                                         
MFA-TR*              ,CODE_TIME_PERIOD                                          
MFA-TR*              ,REGISTER_RD_SEQ                                           
MFA-TR*              ,CODE_LAST_REG_READ                                        
MFA-TR*              ,LAST_REG_READ_TM                                          
MFA-TR*              ,LAST_REG_READ_DT                                          
MFA-TR*              ,LAST_READ_VALUE                                           
MFA-TR*              ,NEXT_READ_MONTH                                           
MFA-TR*              ,CODE_CRNT_REG_READ                                        
MFA-TR*              ,CODE_NO_RD_REASON                                         
MFA-TR*              ,MIN_NO_UNITS                                              
MFA-TR*              ,MAX_NO_UNITS                                              
MFA-TR*          FROM CSS_REGISTER_READ                                         
MFA-TR*         WHERE ACCOUNT_NO     = :RG-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :RG-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :RG-IC-NO                                
MFA-TR*           AND MTR_REF_NO     = :RG-MTR-REF-NO                           
MFA-TR*         ORDER BY CODE_TIME_PERIOD                                       
MFA-TR*                 ,CODE_USAGE_ID                                          
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE FILTER_INFO CURSOR WITH ROWSET POSITIONING FOR     
               SELECT CODE_VALUE                                        
                     ,CODE_LONG_DESC                                    
                FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                       
               WHERE COMPANY_NO IN ('01', '26')                         
                 AND TABLE_NA   =  'FCS_MTR_RD_DISTRCT'                 
                 AND COLUMN_NA  =  'FCS_FILTERING_INFO'                 
                 AND PROGRAM_ID =  'PCSBW171'                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FILTER_INFO CURSOR WITH ROWSET POSITIONING FOR             
MFA-TR*        SELECT CODE_VALUE                                                
MFA-TR*              ,CODE_LONG_DESC                                            
MFA-TR*         FROM CSS_CODE_VALUE                                             
MFA-TR*        WHERE COMPANY_NO IN ('01', '26')                                 
MFA-TR*          AND TABLE_NA   =  'FCS_MTR_RD_DISTRCT'                         
MFA-TR*          AND COLUMN_NA  =  'FCS_FILTERING_INFO'                         
MFA-TR*          AND PROGRAM_ID =  'PCSBW171'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE MTR_RD_SRC CURSOR FOR                            
               SELECT MTR_READ_SOURCE_CD                                
                     ,AMR_COMM_TYPE_CD                                  
                     ,SEND_READ_REQ_FL                                  
               FROM CSS_MTR_RD_SOURCE WITH(READUNCOMMITTED)                     
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MTR_RD_SRC CURSOR FOR                                    
MFA-TR*        SELECT MTR_READ_SOURCE_CD                                        
MFA-TR*              ,AMR_COMM_TYPE_CD                                          
MFA-TR*              ,SEND_READ_REQ_FL                                          
MFA-TR*        FROM CSS_MTR_RD_SOURCE                                           
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ****************************************************************          
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **                                                            **          
      *==============================================================*          
       0000-MAINLINE.                                                   
      *==============================================================*          
      *                                                                         
           PERFORM 0100-INITIALIZATION        THRU 0100-EXIT.           
      *                                                                         
           PERFORM 1000-PROCESS-DB09          THRU 1000-EXIT            
                   UNTIL CNTL-END-REC-FOUND  OR NO-MORE-DATA.           
      *                                                                         
           PERFORM 3000-PROCESS-END-JOB       THRU 3000-EXIT.           
      *                                                                         
           PERFORM 9000-TERMINATE             THRU 9000-EXIT.           
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0100-INITIALIZATION.                                             
      *==============================================================*          
      *                                                                         
           PERFORM 0110-OPEN-ALL-FILES           THRU 0110-EXIT.        
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE          TO WS-CUR-DATE-BREAKDOWN.        
           MOVE WS-CUR-DATE-BREAKDOWN  TO WS-DATE-CCYYMMDD.             
           MOVE WS-CUR-MM              TO WS-PROCESS-MONTH.             
      *                                                                         
           MOVE WS-INPUT-DATE          TO WS-DATE-CCYYMMDD,             
                                          WS-DATE-BREAKDOWN             
                                          WS-WORK-DATE                  
      *                                                                         
ACT069     PERFORM 7940-GET-CURRENT-DT           THRU 7940-EXIT.        
ACT069*                                                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
      *                                                                         
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS AND   
              WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
               SET RESTART-NOT-REQUIRED TO TRUE                         
               DISPLAY '** PCSBW171 INFORMATIONAL MESSAGE  **'          
               DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'          
               DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS    
                       ', INTERPRETED TO**'                             
               DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'          
               DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'          
               DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'          
               DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'          
               DISPLAY '**      PROCESSING CONTINUING      **'          
           END-IF.                                                      
      *                                                                         
           PERFORM 6254-GET-FJC01-STOP-KEY       THRU 6254-EXIT.        
           MOVE WS-STOP-KEY            TO WS-STOP-PARM-BREAKDOWN.       
      *                                                                         
           IF WS-STOP-PARM-ACCOUNT-NO NUMERIC                           
              MOVE WS-STOP-PARM-ACCOUNT-NO TO WS-STOP-ACCOUNT-NO        
           ELSE                                                         
               MOVE WS-13-NINES            TO WS-STOP-ACCOUNT-NO        
           END-IF.                                                      
      *                                                                         
           PERFORM 0150-LOAD-RD-FMT-TAB          THRU 0150-EXIT.        
           PERFORM 0160-LOAD-FCS-FILTER-INFO     THRU 0160-EXIT.        
           PERFORM 0170-POPULATE-RD-SRC-ARRAY    THRU 0170-EXIT.        
      *                                                                         
           PERFORM 0200-PROCESS-BEGIN-REC        THRU 0200-EXIT.        
      *                                                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ    THRU 6235-EXIT.        
           PERFORM 0600-PREPARE-FOR-RESTART      THRU 0600-EXIT.        
           PERFORM 0605-VALIDATE-RESTART-REQ     THRU 0605-EXIT.        
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
               PERFORM 0610-REPOSITION-FILES     THRU 0610-EXIT         
           ELSE                                                         
               PERFORM 0612-INITIALIZE-RESTART   THRU 0612-EXIT         
               PERFORM 0800-WRITE-BEGIN-CONTROLS THRU 0800-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FCSDB09          THRU 7000-EXIT.           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0110-OPEN-ALL-FILES.                                             
      *==============================================================*          
      *                                                                         
           OPEN INPUT FCSDB09-FILE.                                     
           IF FDB09-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '0110-ERROR ON FCSBW71 OPEN.  STATUS IS '        
                        WS-FDB09-STATUS                                 
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
      *                                                                         
           OPEN OUTPUT FCSBW71-FILE                                     
           IF NOT FBW71-SUCCESSFUL                                      
               DISPLAY '0110-ERROR ON FCSBW71 OPEN.  STATUS IS '        
                        WS-FBW71-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSCA55-FILE                                     
           IF NOT FCA55-SUCCESSFUL                                      
              DISPLAY '0110-ERROR ON FCSCA55 OPEN.  STATUS IS '         
                       WS-FCA55-STATUS                                  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSRP87-FILE                                     
           IF NOT FRP87-SUCCESSFUL                                      
              DISPLAY '0110-ERROR ON FCSRP87 OPEN.  STATUS IS '         
                       WS-FRP87-STATUS                                  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSRP123-FILE                                    
           IF NOT FRP123-SUCCESSFUL                                     
              DISPLAY '0110-ERROR ON FCSRP123 OPEN. STATUS IS '         
                       WS-FRP123-STATUS                                 
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0150-LOAD-RD-FMT-TAB.                                            
      *================================================================*        
      *                                                                         
           INITIALIZE WS-MTR-RD-FMT-TABLE.                              
      *                                                                         
           PERFORM 7910-OPEN-RD-FMT-CURSOR THRU 7910-EXIT.              
      *                                                                         
           PERFORM 7920-FETCH-RD-FMT-CURSOR THRU 7920-EXIT              
      *                                                                         
           IF WS-RD-FMT-COUNT = 0                                       
              DISPLAY '*********************************************'   
              DISPLAY '*** ZERO ROWS SELECTED FROM CSS_MTR_RD_FMT***'   
              DISPLAY '**  PROGRAM ABORTING...                    **'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
      *                                                                         
           IF WS-RD-FMT-COUNT >= 1000                                   
              DISPLAY '*********************************************'   
              DISPLAY '***         ARRAY OVERFLOW:               ***'   
              DISPLAY '** EXPECTED MTR_RD_FMT ROWS ARE BELOW 1000 **'   
              DISPLAY '**  PROGRAM ABORTING...                    **'   
              DISPLAY '**  PROGRAMMING CHANGE MAY REQUIRE        ***'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
      *                                                                         
           PERFORM 7930-CLOSE-RD-FMT-CURSOR THRU 7930-EXIT.             
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0160-LOAD-FCS-FILTER-INFO.                                       
      *================================================================*        
      *                                                                         
           INITIALIZE WS-FILTER-INFO-TABLE.                             
      *                                                                         
           PERFORM 7810-OPEN-FILT-INFO-CSR THRU 7810-EXIT.              
      *                                                                         
           PERFORM 7820-FETCH-FILT-INFO-CSR    THRU 7820-EXIT           
      *                                                                         
           IF WS-FILTER-INFO-COUNT = 0                                  
              DISPLAY '*********************************************'   
              DISPLAY '*** ZERO ROWS SELECTED FOR FCS FILTER INFO***'   
              DISPLAY '**  PROGRAM ABORTING...                    **'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
      *                                                                         
           IF WS-FILTER-INFO-COUNT >= 100                               
              DISPLAY '*********************************************'   
              DISPLAY '***   100 OR MORE ROWS FROM CODE VALUE    ***'   
              DISPLAY '** EXPECTED FCS FILTER INFO ROWS < 100     **'   
              DISPLAY '**  PROGRAM ABORTING...                    **'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
      *                                                                         
           PERFORM 7830-CLOSE-FILT-INFO-CSR  THRU 7830-EXIT.            
      *                                                                         
       0160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0170-POPULATE-RD-SRC-ARRAY.                                      
      *==============================================================*          
      *   FETCH ALL ROWS FROM CSS_MTR_RD_SOURCE TABLE AND LOAD ARRAY *          
      *--------------------------------------------------------------*          
      *                                                                         
           PERFORM 7040-OPEN-RD-SOURCE THRU 7040-EXIT.                  
      *                                                                         
           PERFORM 7045-FETCH-RD-SOURCE THRU 7045-EXIT.                 
      *                                                                         
           PERFORM 0175-LOAD-RD-SOURCE THRU 0175-EXIT                   
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
      *                                                                         
           PERFORM 7050-CLOSE-RD-SOURCE THRU 7050-EXIT.                 
      *                                                                         
       0170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0175-LOAD-RD-SOURCE.                                             
      *==============================================================*          
      *   CHECK TABLE OVER-FLOW EACH TIME BEFORE LOADING INTO ARRAY  *          
      *   ABEND THE PROGRAM IN CASE OF ARRAY OVER-FLOW               *          
      *--------------------------------------------------------------*          
      *                                                                         
           ADD +1  TO WS-RD-SRC-COUNT.                                  
           IF WS-RD-SRC-COUNT > WS-MAX-RD-SRC-ROWS                      
              DISPLAY '*** ERROR: ARRAY OVERFLOW ***'                   
              DISPLAY '*** ABENDING IN PARA 0175 ***'                   
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF.                                                      
      *                                                                         
           MOVE X7-MTR-READ-SOURCE-CD                                   
                  TO WS-TAB-RD-SOURCE-CD (WS-RD-SRC-COUNT)              
           MOVE X7-AMR-COMM-TYPE-CD                                     
                  TO WS-TAB-AMR-COMM-TYPE-CD (WS-RD-SRC-COUNT)          
           MOVE X7-SEND-READ-REQ-FL                                     
                  TO WS-TAB-SEND-READ-REQ-FL (WS-RD-SRC-COUNT)          
      *                                                                         
           PERFORM 7045-FETCH-RD-SOURCE THRU 7045-EXIT.                 
      *                                                                         
       0175-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0200-PROCESS-BEGIN-REC.                                          
      *==============================================================*          
      *** PROCESS DB09 HEADER DATA                                   *          
      *** TURN OFF COMMITS FOR AROP                                  *          
      *** GET OPTIMUM & CRETICAL READ DATES                          *          
      *--------------------------------------------------------------*          
      *                                                                         
           PERFORM 7000-READ-FCSDB09             THRU 7000-EXIT.        
      *                                                                         
           IF NO-MORE-DATA                                              
               DISPLAY '**   PCSBW171 PROCESSING ERROR    **'           
               DISPLAY '**     FCSDB09 FILE IS EMPTY      **'           
               DISPLAY '**     PROCESSING TERMINATED      **'           
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF CNTL-BEGIN-REC-FOUND                                      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**   PCSBW171 PROCESSING ERROR    **'           
               DISPLAY '** DB09 1ST RECORD IS NOT CNTL REC**'           
               DISPLAY '**     PROCESSING TERMINATED      **'           
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           DISPLAY 'CREATE DATE = ' E-FDB09-CREATE-DATE-BREC.           
           DISPLAY 'WS-INPUT-DATE = ' WS-INPUT-DATE.                    
      *                                                                         
           IF E-FDB09-CREATE-DATE-BREC EQUAL WS-INPUT-DATE              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSBW171 PROCESSING ERROR        **'   
               DISPLAY '** FCSDB09 CREATE DATE NOT EQUAL RUN DATE **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF E-FDB09-DB-PART-BREC GREATER THAN ZERO                    
               MOVE E-FDB09-DB-PART-BREC                                
                                       TO WS-PART-NO                    
               MOVE E-FDB09-CYCLE-NO-BREC (1)                           
                                       TO WS-SAVE-READ-CYCLE-1          
               MOVE E-FDB09-CYCLE-NO-BREC (2)                           
                                       TO WS-SAVE-READ-CYCLE-2          
               MOVE E-FDB09-CYCLE-NO-BREC (3)                           
                                       TO WS-SAVE-READ-CYCLE-3          
               MOVE E-FDB09-CYCLE-NO-BREC (4)                           
                                       TO WS-SAVE-READ-CYCLE-4          
               MOVE E-FDB09-CYCLE-NO-BREC (5)                           
                                       TO WS-SAVE-READ-CYCLE-5          
           ELSE                                                         
               DISPLAY '**        PCSBW171 PROCESSING ERROR         **' 
               DISPLAY '** FCSDB09 PARTITION NO. NOT GREATER THAN 0 **' 
               DISPLAY '**          PROCESSING TERMINATED           **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE 'N'                    TO WS-END-OF-CYCLE.              
      *                                                                         
           MOVE E-FDB09-CREATE-DATE-BREC TO RW-DATE-MTR-RD-XTRCT        
      *                                                                         
           IF E-FDB09-CYCLE-NO-BREC (1) IS NUMERIC AND                  
              E-FDB09-CYCLE-NO-BREC (1) > 0                             
              CONTINUE                                                  
           ELSE                                                         
              GO TO 0200-EXIT                                           
           END-IF                                                       
      *                                                                         
      ***  OUT OF CYCLE AROP PROCESS (PART 9) USES DUMMY CYCLES 22 & 23         
      ***  THESE ARE NOT EXISTS IN READ WINDOW SO GO BY RUN DATE AND            
      ***  FIND OUT NEAREST READ CYCLE TO USE IN CASE OF AROP.                  
      ***  ALSO TURN-OFF COMMIT LOGIC. SINCE NO SQL UPDATES WILL BE             
      ***  EXECUTED FOR AROP PROCESS.                                           
      *                                                                         
           IF WS-PART-NO = 9                                            
              DISPLAY '*************************************'           
              MOVE 9999                TO WS-CHKP-LUW-LIMIT             
                                          WS-CHKP-UPD-LIMIT             
              SET RESTART-NOT-REQUIRED TO TRUE                          
              DISPLAY '** INTERIM COMMIT LOGIC TURNED-OFF **'           
              DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'           
              DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'           
              DISPLAY '*************************************'           
      **                                                                        
              PERFORM 7445-GET-NEARBY-READ-CYCLE    THRU 7445-EXIT      
           ELSE                                                         
              PERFORM 7440-GET-READ-CYCLE           THRU 7440-EXIT      
           END-IF.                                                      
                                                                        
           MOVE RW-READ-CYCLE        TO WS-FCS-CYCLE                    
           MOVE RW-OPTIMUM-READ-DATE TO WS-FCS-OPTIMUM-RD-DT            
                                                                        
      ***  GET CRITICAL READ DATE (BILL WINDOW OPEN DATE)                       
           PERFORM 7030-SELECT-CYCLE-OPEN-DATE THRU 7030-EXIT           
           MOVE BN-DATE-EXTRACT      TO WS-FCS-CRITICAL-RD-DT           
                                                                        
           MOVE RW-REVENUE-MONTH TO WS-REV-MTH-NUM.                     
      *                                                                         
           PERFORM 0250-BUILD-HILO-DATE-TABLE THRU 0250-EXIT.           
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0250-BUILD-HILO-DATE-TABLE.                                      
      *================================================================*        
      *** BUILD DATE TABLE WITH 27TH DAY THRU 33RD DAY BY SUBTRACTING           
      *** DAYS FROM OPTIMUM READ DATE.                                          
      *                                                                         
           MOVE 27                       TO WS-HILO-WORK-DAYS           
                                            WS-HILO-SUBTRACT-DAYS       
           MOVE WS-FCS-OPTIMUM-RD-DT TO WS-HILO-WORK-DATE               
           PERFORM 7025-SUBTRACT-XX-DAYS  THRU 7025-EXIT.               
           MOVE 1                        TO WS-HILO-SUBTRACT-DAYS       
      *                                                                         
           PERFORM VARYING HL-INDX FROM 1 BY 1                          
                       UNTIL HL-INDX > 7                                
              MOVE WS-HILO-WORK-DATE  TO WS-HL-READ-DATE (HL-INDX)      
              MOVE WS-HILO-WORK-DAYS TO WS-HL-READ-DAYS (HL-INDX)       
              PERFORM 7025-SUBTRACT-XX-DAYS  THRU 7025-EXIT             
              COMPUTE WS-HILO-WORK-DAYS = WS-HILO-WORK-DAYS + 1         
           END-PERFORM.                                                 
      *                                                                         
       0250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0600-PREPARE-FOR-RESTART.                                        
      *==============================================================*          
      *                                                                         
           MOVE WS-PGRMNAME            TO RF-NAME-PROGRAM.              
           MOVE WS-PART-NO             TO RF-PARTITION-NO,              
                                          WS-CHKP-PART-NO.              
           MOVE 1                      TO RF-DUP-CNTRL-NO.              
      *                                                                         
           PERFORM 7450-SELECT-RESTART           THRU 7450-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RF-RESTART-DATA-TEXT TO WS-RST-DATA                  
              IF WS-RST-PROCESS-TYPE NUMERIC                            
                 MOVE WS-Y           TO WS-IS-THIS-A-RESTART            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
      *0605-VALIDATE-RESTART-REQ                                                
      *==============================================================*          
      *                                                                         
       COPY CPD00030.                                                           
      *                                                                         
      *==============================================================*          
       0610-REPOSITION-FILES.                                           
      *==============================================================*          
      *** THIS PROCESS REMOVES ANY DATA WRITTEN BETWEEN THE LAST                
      *** CHECKPOINT AND THE ABEND.                                             
      *** OPEN ALL INPUT FILES (FROM LAST RUN) FOR RECYCLING.                   
      *                                                                         
           MOVE WS-Y                   TO WS-REPOSITION-NEEDED          
           MOVE WS-RST-CHKP-SEQ-NO     TO WS-CHKP-SEQ-NO.               
      *                                                                         
           IF WS-RST-COMMON-DATE EQUAL WS-INPUT-DATE                    
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**********************************************' 
               DISPLAY '** COMMON DATE WAS CHANGED PRIOR TO RESTART **' 
               DISPLAY '**********************************************' 
               DISPLAY '** OLD COMMON DATE = ' WS-RST-COMMON-DATE       
               DISPLAY '** NEW COMMON DATE = ' WS-INPUT-DATE            
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE WS-RST-BW71-REC-CNTR TO WS-COUNT-FCSBW71                
      *                                                                         
      **** REPOSITION DB09 FILE                                                 
           PERFORM 7000-READ-FCSDB09           THRU 7000-EXIT           
              UNTIL WS-RST-RECORD-COUNT = WS-FCSDB09-REC-CNTR           
                 OR NO-MORE-DATA.                                       
      *                                                                         
           IF WS-RST-ACCOUNT-NO NOT = E-FDB09-ACCOUNT-NO                
              DISPLAY '**********************************************'  
              DISPLAY '**     FAILED TO REPOSITION DB09 FILE       **'  
              DISPLAY '**********************************************'  
              DISPLAY '** LAST COMMIT ACC = ' WS-RST-ACCOUNT-NO         
              DISPLAY '** DB09 POINTS ON  = ' E-FDB09-ACCOUNT-NO        
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
      **** COPY LAST RUN BW71 RECORDS TO NEW BW71 FILE                          
           IF WS-RST-BW71-REC-CNTR > 0                                  
              OPEN INPUT FCSBW71R-FILE                                  
              IF NOT FBW71R-SUCCESSFUL                                  
                 DISPLAY '0700-ERROR ON FCSBW71R OPEN.  STATUS IS '     
                       WS-FBW71R-STATUS                                 
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
      *                                                                         
              PERFORM WS-RST-BW71-REC-CNTR TIMES                        
                 READ FCSBW71R-FILE                                     
                 IF FBW71R-SUCCESSFUL                                   
                    WRITE FIOBW71 FROM FIOBW71R                         
                    IF NOT FBW71-SUCCESSFUL                             
                       DISPLAY 'ERROR ON FCSBW71 REWRITE.  STATUS IS '  
                             WS-FBW71-STATUS                            
                       PERFORM 9900-ABEND THRU 9900-EXIT                
                    END-IF                                              
                 ELSE                                                   
                    DISPLAY 'PREMATURE EOF ON BW71 RESTART'             
                    DISPLAY 'PROCESSING TERMINATED'                     
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              END-PERFORM                                               
              CLOSE FCSBW71R-FILE                                       
           END-IF.                                                      
      *                                                                         
      **** COPY LAST RUN CA55 RECORDS TO NEW CA55 FILE                          
           IF WS-RST-CA55-REC-CNTR > 0                                  
              OPEN INPUT FCSCA55R-FILE                                  
              IF NOT FCA55R-SUCCESSFUL                                  
                 DISPLAY '0700-ERROR ON FCSCA55R OPEN.  STATUS IS '     
                       WS-FCA55R-STATUS                                 
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
      *                                                                         
              PERFORM WS-RST-CA55-REC-CNTR TIMES                        
                 READ FCSCA55R-FILE                                     
                 IF FCA55R-SUCCESSFUL                                   
                    WRITE E-FCA55 FROM FIOCA55R                         
                    IF NOT FCA55-SUCCESSFUL                             
                       DISPLAY 'ERROR ON FCSCA55 REWRITE.  STATUS IS '  
                             WS-FCA55-STATUS                            
                       PERFORM 9900-ABEND THRU 9900-EXIT                
                    END-IF                                              
                 ELSE                                                   
                    DISPLAY 'PREMATURE EOF ON CA55 RESTART'             
                    DISPLAY 'PROCESSING TERMINATED'                     
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              END-PERFORM                                               
              CLOSE FCSCA55R-FILE                                       
           END-IF                                                       
      *                                                                         
      **** COPY LAST RUN RP87 RECORDS TO NEW RP87 FILE                          
           IF WS-RST-RP87-REC-CNTR > 0                                  
              OPEN INPUT FCSRP87R-FILE                                  
              IF NOT FRP87R-SUCCESSFUL                                  
                 DISPLAY '0700-ERROR ON FCSRP87R OPEN.  STATUS IS '     
                       WS-FRP87R-STATUS                                 
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
      *                                                                         
              PERFORM WS-RST-RP87-REC-CNTR TIMES                        
                 READ FCSRP87R-FILE                                     
                 IF FRP87R-SUCCESSFUL                                   
                    WRITE E-FRP87 FROM FIORP87R                         
                    IF NOT FRP87-SUCCESSFUL                             
                       DISPLAY 'ERROR ON FCSRP87 REWRITE. STATUS IS '   
                             WS-FRP87-STATUS                            
                       PERFORM 9900-ABEND THRU 9900-EXIT                
                    END-IF                                              
                 ELSE                                                   
                    DISPLAY 'PREMATURE EOF ON RP87 RESTART'             
                    DISPLAY 'PROCESSING TERMINATED'                     
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              END-PERFORM                                               
              CLOSE FCSRP87R-FILE                                       
           END-IF.                                                      
      *                                                                         
      **** COPY LAST RUN RP123 RECORDS TO NEW RP123 FILE                        
           IF WS-RST-RP123-REC-CNTR > 0                                 
              OPEN INPUT FCSRP12R-FILE                                  
              IF NOT FRP12R-SUCCESSFUL                                  
                 DISPLAY '0700-ERROR ON FCSRP12R OPEN.  STATUS IS '     
                       WS-FRP12R-STATUS                                 
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
      *                                                                         
              PERFORM WS-RST-RP123-REC-CNTR TIMES                       
                 READ FCSRP12R-FILE                                     
                 IF FRP12R-SUCCESSFUL                                   
                    WRITE E-FIORP123 FROM FIORP12R                      
                    IF NOT FRP123-SUCCESSFUL                            
                       DISPLAY 'ERROR ON FCSRP123 REWRITE.  STATUS IS ' 
                             WS-FRP123-STATUS                           
                       PERFORM 9900-ABEND THRU 9900-EXIT                
                    END-IF                                              
                 ELSE                                                   
                    DISPLAY 'PREMATURE EOF ON RP12 RESTART'             
                    DISPLAY 'PROCESSING TERMINATED'                     
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              END-PERFORM                                               
              CLOSE FCSRP12R-FILE                                       
           END-IF.                                                      
      *                                                                         
           DISPLAY '*********************************************'.     
           DISPLAY '*****   THIS IS A RESTART OF PCSBW171   *****'.     
           DISPLAY '*********************************************'.     
      *                                                                         
       0610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0612-INITIALIZE-RESTART.                                         
      *==============================================================*          
      *                                                                         
           MOVE WS-N                   TO WS-REPOSITION-NEEDED          
           MOVE SPACES                 TO WS-RST-COMMON-DATE            
           MOVE WS-C                   TO WS-RST-JOB-STATUS             
           MOVE ZERO                   TO WS-RST-CHKP-SEQ-NO            
                                          WS-RST-RP87-REC-CNTR          
                                          WS-RST-RP123-REC-CNTR         
                                          WS-RST-BW71-REC-CNTR          
                                          WS-RST-CA55-REC-CNTR          
                                          WS-RST-CA55-COM-CNTR          
                                          WS-RST-RP87-COM-CNTR          
                                          WS-RST-RP123-COM-CNTR         
                                          WS-RST-CA55-TOT-CNTR          
                                          WS-RST-RP87-TOT-CNTR          
                                          WS-RST-RP123-TOT-CNTR         
                                          WS-RST-MN-UPDT-CNTR           
                                          WS-RST-AT-UPDT-CNTR           
                                          WS-RST-RG-UPDT-CNTR           
                                          WS-RST-ACCOUNT-NO             
                                          WS-RST-RECORD-COUNT.          
      *                                                                         
       0612-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0800-WRITE-BEGIN-CONTROLS.                                       
      *================================================================*        
      *                                                                         
           MOVE LOW-VALUES             TO E-FCA55-KEY-BREC.             
           MOVE WS-PART-NO             TO E-FCA55-DB-PART-BREC.         
           MOVE WS-INPUT-DATE          TO E-FCA55-CREATE-DATE-BREC.     
           PERFORM 8420-WRITE-FCSCA55            THRU 8420-EXIT.        
           MOVE SPACES                 TO E-FCA55.                      
      *                                                                         
           MOVE LOW-VALUES             TO E-FRP87-KEY-BREC.             
           MOVE WS-PART-NO             TO E-FRP87-DB-PART-BREC.         
           MOVE WS-INPUT-DATE          TO E-FRP87-CREATE-DATE-BREC.     
           PERFORM 8430-WRITE-FCSRP87            THRU 8430-EXIT.        
           MOVE SPACES                 TO E-FRP87.                      
      *                                                                         
           MOVE SPACES                 TO E-FIORP123.                   
           MOVE LOW-VALUES             TO E-FRP123-KEY-BREC.            
           MOVE WS-PART-NO             TO E-FRP123-DB-PART-BREC.        
           MOVE WS-INPUT-DATE          TO E-FRP123-CREATE-DATE-BREC.    
           PERFORM 8440-WRITE-FCSRP123           THRU 8440-EXIT.        
           MOVE SPACES                 TO E-FIORP123.                   
      *                                                                         
       0800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1000-PROCESS-DB09.                                               
      *==============================================================*          
      *                                                                         
           SET NORMAL-READ-REQ         TO TRUE                          
A04527      IF (E-FDB09-OFF-CYCLE-BILL-CODE  = WS-AROP OR WS-STORM)     
A04527        OR (E-FDB09-MID-MONTH-RD-FLAG = WS-Y)                     
              SET SPECIAL-READ-REQ     TO TRUE                          
           END-IF                                                       
      *                                                                         
A04527     IF E-FDB09-OFF-CYCLE-BILL-CODE = WS-M OR WS-AROP OR WS-STORM 
              PERFORM 1100-PROCESS-ACCOUNT      THRU 1100-EXIT          
           END-IF                                                       
      *                                                                         
      ***  THE FOLLOWING STATEMENTS ISSUE A CHECKPOINT IF THE CHKP-LUW          
      ***  LIMIT HAS BEEN REACHED OR EXCEEDED. CHKP-UPD LIMIT IGNORED.          
      *                                                                         
           COMPUTE WS-CHKP-LUW-COUNTER = WS-CHKP-LUW-COUNTER + 1        
      *                                                                         
           IF WS-CHKP-LUW-COUNTER >= WS-CHKP-LUW-LIMIT                  
              AND RESTART-REQUIRED                                      
               PERFORM 8898-ISSUE-CHKP           THRU 8898-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FCSDB09             THRU 7000-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1100-PROCESS-ACCOUNT.                                            
      *==============================================================*          
      *                                                                         
           MOVE E-FDB09-ACCOUNT-NO       TO AT-ACCOUNT-NO               
           MOVE ZEROES                   TO WS-AT-TIME-NULL             
           PERFORM 7010-SELECT-ACCOUNT   THRU 7010-EXIT                 
      *                                                                         
           MOVE AT-ACCOUNT-NO          TO UT-ACCOUNT-NO                 
                                          MN-ACCOUNT-NO                 
                                          RG-ACCOUNT-NO.                
ACT069     MOVE AT-COMPANY-NO          TO O2-COMPANY-NO.                
      *                                                                         
           MOVE AT-PREMISE-NO          TO PR-PREMISE-NO                 
                                          WS-PREMISE-NO.                
ACT199     INITIALIZE     PR-SPCL-READ-INSTR PR-DATE-SPCL-MSG-ENDS.     
           PERFORM 7020-SELECT-PREMISE        THRU 7020-EXIT.           
ACT199     IF  PR-DATE-SPCL-MSG-ENDS > SPACES      AND                  
ACT199         PR-DATE-SPCL-MSG-ENDS < WS-INPUT-DATE                    
ACT199             MOVE SPACES TO PR-SPCL-READ-INSTR-TEXT               
ACT199             MOVE 0      TO PR-SPCL-READ-INSTR-LEN                
ACT199             PERFORM 7550-UPDATE-PREMISE THRU 7550-EXIT           
ACT199     END-IF.                                                      
      *                                                                         
           INITIALIZE DCLCSS-NAME-ACCT-XREF.                            
           PERFORM 4000-MAIL-NAME-ADDRESS     THRU 4000-EXIT.           
      *                                                                         
           MOVE 'N'                    TO WS-RECORDS-CHECK.             
           PERFORM 7200-OPEN-UTILITY             THRU 7200-EXIT.        
           PERFORM 7201-FETCH-UTILITY            THRU 7201-EXIT.        
           PERFORM 1200-PROCESS-UTILITY          THRU 1200-EXIT         
             UNTIL NO-MORE-RECORDS.                                     
           PERFORM 7202-CLOSE-UTILITY            THRU 7202-EXIT.        
      *                                                                         
           IF PR-PERSONAL-CNTCT-CD EQUAL WS-Y                           
ACT069         INITIALIZE CWS00077-FIELDS                               
ACT069         MOVE WS-CONTACT-MSG     TO WS-77-COMMENTS-TEXT           
ACT069         MOVE WS-CONTACT-LEN     TO WS-77-COMMENTS-LEN            
               PERFORM 5010-CREATE-WORKQ         THRU 5010-EXIT         
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1200-PROCESS-UTILITY.                                            
      *==============================================================*          
      *                                                                         
           IF E-FDB09-OFF-CYCLE-BILL-CODE = WS-AROP                     
A04527        OR E-FDB09-OFF-CYCLE-BILL-CODE = WS-STORM                 
              OR UT-READ-CYCLE = WS-SAVE-READ-CYCLE-1                   
              OR UT-READ-CYCLE = WS-SAVE-READ-CYCLE-2                   
              OR UT-READ-CYCLE = WS-SAVE-READ-CYCLE-3                   
              OR UT-READ-CYCLE = WS-SAVE-READ-CYCLE-4                   
              OR UT-READ-CYCLE = WS-SAVE-READ-CYCLE-5                   
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 7201-FETCH-UTILITY THRU 7201-EXIT                 
              GO TO 1200-EXIT                                           
           END-IF                                                       
                                                                        
           MOVE UT-IC-NO               TO MN-IC-NO                      
                                          RG-IC-NO                      
           MOVE UT-CODE-UTIL-TYPE      TO MN-CODE-UTIL-TYPE             
                                          RG-CODE-UTIL-TYPE             
                                          T1-CODE-UTIL-TYPE             
           MOVE WS-Y                     TO WS-FCS21-WRITE-IND.         
           MOVE UT-READ-ROUTE            TO O2-READ-ROUTE.              
           PERFORM 7900-READ-O2-TABLE    THRU 7900-EXIT.                
                                                                        
           IF UT-READ-CYCLE   NOT = O2-READ-CYCLE OR                    
              AT-LOCAL-OFFICE NOT = O2-LOCAL-OFFICE                     
              MOVE AT-LOCAL-OFFICE     TO WS-WQ-LOC-OFF                 
              MOVE AT-ACCOUNT-NO       TO WS-WQ-ACCOUNT                 
              MOVE UT-READ-CYCLE       TO WS-WQ-READ-CYCLE              
              MOVE O2-LOCAL-OFFICE     TO WS-WQ-LOC-OFF1                
              MOVE O2-READ-CYCLE       TO WS-WQ-READ-CYCLE1             
              MOVE O2-READ-ROUTE       TO WS-WQ-READ-ROUTE              
              MOVE WS-N                TO WS-FCS21-WRITE-IND            
           END-IF.                                                      
      *                                                                         
           MOVE UT-READ-CYCLE          TO WS-MRMS-CYCLE-NO              
           IF E-FDB09-OFF-CYCLE-BILL-CODE = WS-M                        
      **** SELECT MID-MONTH CYCLE FOR MID-MONTH READ ACCOUNTS                   
              PERFORM 7005-SELECT-READ-CYCLE THRU 7005-EXIT             
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE RW-READ-CYCLE     TO WS-MRMS-CYCLE-NO             
              END-IF                                                    
           ELSE                                                         
              MOVE WS-SAVE-READ-CYCLE-1 TO WS-MRMS-CYCLE-NO             
           END-IF.                                                      
      *                                                                         
           PERFORM 7210-OPEN-MTRD-ENVRNMT        THRU 7210-EXIT.        
           PERFORM 7211-FETCH-MTRD-ENVRNMT       THRU 7211-EXIT.        
      *                                                                         
           PERFORM 1300-PROCESS-MTR-ENVRNMT      THRU 1300-EXIT         
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
      *                                                                         
           PERFORM 7212-CLOSE-MTRD-ENVRNMT       THRU 7212-EXIT.        
      *                                                                         
           PERFORM 7201-FETCH-UTILITY            THRU 7201-EXIT.        
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1300-PROCESS-MTR-ENVRNMT.                                        
      *==============================================================*          
      *                                                                         
           SET FORMATTED-DATA-NONE     TO TRUE                          
           SET NO-HILO-LIMITS-CALC     TO TRUE                          
A00795     MOVE -1                     TO WS-HL-CODE-TIME-PERIOD        
A00795     MOVE SPACES                 TO WS-HL-CODE-USAGE-ID           
      *                                                                         
           MOVE MN-CODE-NO-RD-REASON   TO WS-HLD-NO-RD-REASON           
           MOVE MN-REMOTE-READ-IND     TO WS-REMOTE-READ-IND-FL         
           INITIALIZE WS-METER-PRESSURE                                 
           MOVE MN-METER-PRESSURE      TO WS-METER-PRESSURE             
      *                                                                         
           PERFORM 5030-LOCATE-MTR-RD-SOURCE THRU 5030-EXIT             
      *                                                                         
           IF MN-NO-CONSEC-ESTIMATE > 0                                 
             AND E-FDB09-HELD-CODE    NOT = WS-B                        
             AND MN-CODE-METER-STATUS NOT = WS-INACTIVE-METER           
                 PERFORM 5100-FORMAT-FRP123    THRU 5100-EXIT           
           END-IF.                                                      
      *                                                                         
           IF SEND-MTR-FOR-READ AND E-FDB09-HELD-CODE NOT = WS-B        
              IF MN-REGISTER-RD-SEQ EQUAL ZEROES                        
                 PERFORM 5200-FORMAT-FCA55     THRU 5200-EXIT           
              END-IF                                                    
      *                                                                         
              IF WS-FCS21-WRITE-IND = WS-Y                              
                 PERFORM 2000-FORMAT-BW71-MN       THRU 2000-EXIT       
              ELSE                                                      
ACT069           INITIALIZE CWS00077-FIELDS                             
ACT069           MOVE WS-CONTACT-MSG1  TO WS-77-COMMENTS-TEXT           
ACT069           MOVE WS-CONTACT-LEN1  TO WS-77-COMMENTS-LEN            
                 PERFORM 5010-CREATE-WORKQ THRU 5010-EXIT               
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           IF NORMAL-READ-REQ                                           
              AND MN-MTR-READ-SOURCE-CD NOT EQUAL WS-X                  
              PERFORM 1500-UPDATE-AT-MN      THRU 1500-EXIT             
           END-IF                                                       
      *                                                                         
           IF SEND-MTR-FOR-READ                                         
               PERFORM 5300-FORMAT-FRP87 THRU 5300-EXIT                 
           END-IF.                                                      
      *                                                                         
           IF MN-CODE-DATA-PRESENT > SPACES                             
              AND NON-TOU-MTR                                           
              AND E-FDB09-HELD-CODE     NOT = WS-B                      
              AND MN-MTR-READ-SOURCE-CD NOT = WS-X                      
              MOVE MN-MTR-REF-NO          TO RG-MTR-REF-NO              
              PERFORM 7220-OPEN-REGISTER-READ                           
                                              THRU 7220-EXIT            
              PERFORM 7221-FETCH-REGISTER-READ                          
                                             THRU 7221-EXIT             
              PERFORM 1400-PROCESS-REG-READ  THRU 1400-EXIT             
                    UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND         
              PERFORM 7222-CLOSE-REGISTER-READ                          
                                              THRU 7222-EXIT            
              IF (FORMATTED-DATA-MN OR FORMATTED-DATA-RG)               
                 AND WS-MATCH-REG-COUNT > 0                             
                 PERFORM 2200-FORMAT-BW71-OTHER THRU 2200-EXIT          
                    VARYING WS-MRF-SUB2 FROM 1 BY 1                     
                              UNTIL WS-MRF-SUB2 > WS-MATCH-REG-COUNT    
                                  OR WS-MRF-SUB2 > 25                   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF FORMATTED-DATA-MN                                         
              PERFORM 8400-WRITE-FCSBW71          THRU 8400-EXIT        
           END-IF                                                       
      *                                                                         
           PERFORM 7211-FETCH-MTRD-ENVRNMT       THRU 7211-EXIT.        
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1400-PROCESS-REG-READ.                                           
      *==============================================================*          
      *                                                                         
           IF FORMATTED-DATA-MN OR FORMATTED-DATA-RG                    
              PERFORM 2100-FORMAT-BW71-RG   THRU 2100-EXIT              
           END-IF.                                                      
      *                                                                         
           IF NORMAL-READ-REQ                                           
              MOVE WS-D                TO RG-CODE-CRNT-REG-READ         
              MOVE RG-CODE-NO-RD-REASON   TO WS-HLD-NO-RD-REASON        
              MOVE SPACES                 TO RG-CODE-NO-RD-REASON       
      ***     MOVE WS-MRB-BILL-DATE-MM-PARAM                                    
      ***                                 TO RG-NEXT-READ-MONTH                 
              MOVE WS-REV-MTH-MM          TO RG-NEXT-READ-MONTH         
              PERFORM 8530-UPDATE-REGISTER-READ   THRU 8530-EXIT        
           END-IF.                                                      
      *                                                                         
           PERFORM 7221-FETCH-REGISTER-READ THRU 7221-EXIT.             
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1500-UPDATE-AT-MN.                                               
      *==============================================================*          
      *                                                                         
           IF E-FDB09-HELD-CODE EQUAL WS-B                              
              MOVE WS-E               TO MN-CODE-CRNT-REG-READ          
                                         AT-CODE-ACCT-BILLED            
              MOVE SPACES             TO MN-CODE-NO-RD-REASON           
              PERFORM 8520-UPDATE-MTRD-ENVRNMT  THRU 8520-EXIT          
              PERFORM 8540-UPDATE-ACCOUNT       THRU 8540-EXIT          
           ELSE                                                         
              MOVE WS-D               TO MN-CODE-CRNT-REG-READ          
              MOVE SPACES             TO MN-CODE-NO-RD-REASON           
              PERFORM 8520-UPDATE-MTRD-ENVRNMT  THRU 8520-EXIT          
           END-IF.                                                      
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2000-FORMAT-BW71-MN.                                             
      *==============================================================*          
      *                                                                         
      *** Populate route data                                                   
           MOVE AT-COMPANY-NO          TO E-FBW71-COMPANY-NO            
           MOVE AT-LOCAL-OFFICE        TO E-FBW71-LOCAL-OFFICE          
           MOVE UT-READ-ROUTE          TO E-FBW71-READ-ROUTE            
           MOVE WS-MRMS-CYCLE-NO       TO E-FBW71-READ-CYCLE            
A04527     IF E-FDB09-OFF-CYCLE-BILL-CODE = WS-AROP OR WS-STORM         
      **** USE CURRENT OR NEAR-BY CYCLE FOR AROP                                
              MOVE WS-FCS-CYCLE        TO E-FBW71-READ-CYCLE            
           END-IF                                                       
           MOVE WS-FCS-OPTIMUM-RD-DT   TO E-FBW71-OPTIMUM-RD-DATE       
           MOVE WS-FCS-CRITICAL-RD-DT  TO E-FBW71-CRITICAL-RD-DATE      
A04527     IF E-FDB09-OFF-CYCLE-BILL-CODE = WS-STORM                    
A04527        MOVE WS-STORM-CRITICAL-DATE TO E-FBW71-CRITICAL-RD-DATE   
A04527     END-IF.                                                      
      *                                                                         
           MOVE MN-REGISTER-RD-SEQ     TO E-FBW71-READ-SEQ              
           MOVE AT-ACCOUNT-NO          TO E-FBW71-ACCOUNT-NO            
           MOVE UT-CODE-UTIL-TYPE      TO E-FBW71-UTL-TYPE              
           MOVE UT-IC-NO               TO E-FBW71-IC-NO                 
           MOVE MN-MTR-REF-NO          TO E-FBW71-MTR-REF-NO            
      *** change for each register                                              
           MOVE MN-REG-ID-NO           TO E-FBW71-REG-ID-NO             
           MOVE MN-CODE-TIME-PERIOD    TO E-FBW71-TIME-PERIOD           
A00795                                    WS-CODE-TIME-PERIOD           
P00251     MOVE MN-CODE-USAGE-TYPE     TO E-FBW71-CODE-USAGE-TYPE       
A00795                                    WS-CODE-USAGE-TYPE            
A00795     MOVE MN-CODE-USAGE-ID       TO WS-CODE-USAGE-ID              
P00251                                    E-FBW71-CODE-USAGE-ID         
P00251     MOVE MN-CODE-USAGE-SOURCE   TO E-FBW71-CODE-USAGE-SOURCE     
           MOVE 'C'                    TO E-FBW71-CODE-TOU-SEASN        
           MOVE ZEROS                  TO E-FBW71-REG-READ-ORDER        
      *                                                                         
           MOVE WS-PR-STREET           TO E-FBW71-STREET-ADDRESS        
           MOVE WS-CUSTOMER-NAME       TO E-FBW71-FULLL-NAME            
           MOVE PR-PREMISE-NO          TO E-FBW71-PREMISE-NO            
           MOVE MN-METER-NO            TO E-FBW71-METER-NO              
      *                                                                         
           IF PR-SPCL-READ-INSTR-TEXT > SPACES                          
              MOVE PR-SPCL-READ-INSTR-TEXT                              
                                       TO E-FBW71-SPCL-READ-INSTR       
              SET E-FBW71-SPL-MSG-BEEP-TRUE TO TRUE                     
              SET E-FBW71-SPL-MSG-ON-REQUEST TO TRUE                    
           ELSE                                                         
              MOVE SPACES TO E-FBW71-SPCL-READ-INSTR                    
              SET E-FBW71-SPL-MSG-BEEP-FALSE TO TRUE                    
              SET E-FBW71-SPL-MSG-NONE TO TRUE                          
           END-IF.                                                      
      *                                                                         
      **** FCS FILTERING INFORMATION                                            
           PERFORM 2010-GET-FILTER-INFO  THRU 2010-EXIT                 
           MOVE WS-FBW71-FILTERING-INFO TO E-FBW71-FILTERING-INFO       
      *                                                                         
      **** MTR LOCATION CODE                                                    
           IF MN-CODE-METER-LOC >= '00'                                 
              AND MN-CODE-METER-LOC <= '99'                             
              MOVE MN-CODE-METER-LOC TO E-FBW71-CODE-MTR-LOCATION       
           ELSE                                                         
              MOVE '00'              TO E-FBW71-CODE-MTR-LOCATION       
           END-IF                                                       
      *                                                                         
      **** MTR READ INSTRUCTION CODE (HZD CODE)                                 
      **** SEND TO FCS BY PREFIX WITH 'U' ONLY WHEN VALID                       
           EVALUATE TRUE                                                
              WHEN MN-CODE-MTR-RD-INST1 = 'ZZ'                          
              WHEN MN-CODE-MTR-RD-INST1 = 'L '                          
              WHEN MN-CODE-MTR-RD-INST1 = 'V '                          
              WHEN MN-CODE-MTR-RD-INST1 = 'W '                          
              WHEN MN-CODE-MTR-RD-INST1 = 'X '                          
              WHEN MN-CODE-MTR-RD-INST1 = 'Y '                          
                MOVE '00'  TO E-FBW71-CODE-MTR-RD-INST1                 
              WHEN MN-CODE-MTR-RD-INST1 >= 'A '                         
                   AND MN-CODE-MTR-RD-INST1 <= 'Z '                     
              WHEN MN-CODE-MTR-RD-INST1 >= '1 '                         
                   AND MN-CODE-MTR-RD-INST1 <= '9 '                     
                MOVE 'U '  TO E-FBW71-CODE-MTR-RD-INST1                 
                MOVE MN-CODE-MTR-RD-INST1(1:1)                          
                           TO E-FBW71-CODE-MTR-RD-INST1(2:1)            
              WHEN OTHER                                                
                MOVE '00'  TO E-FBW71-CODE-MTR-RD-INST1                 
           END-EVALUATE.                                                
      *                                                                         
           IF UT-CODE-UTIL-TYPE = 'G'                                   
              SET E-FBW71-GAS          TO TRUE                          
           ELSE                                                         
              SET E-FBW71-ELECTRIC     TO TRUE                          
           END-IF                                                       
      *                                                                         
           MOVE MN-LAST-READ-VALUE     TO E-FBW71-PREV-READ-VALUE       
      *                                                                         
      **** SEND 00 TO MTR TYPE ALWAYS?                                          
           MOVE '00'                   TO E-FBW71-METER-TYPE            
      *                                                                         
      **** R - RESIDENTIAL, C - COMERCIAL & I - INDUSTRIAL                      
           IF AT-ACCOUNT-TYPE-CODE = 'R' OR 'C' OR 'I'                  
              MOVE AT-ACCOUNT-TYPE-CODE TO E-FBW71-ACCOUNT-TYPE-CODE    
           ELSE                                                         
              MOVE 'R'                  TO E-FBW71-ACCOUNT-TYPE-CODE    
           END-IF                                                       
      *                                                                         
           MOVE MN-MTR-READ-SOURCE-CD TO E-FBW71-MTR-READ-SOURCE-CD     
           MOVE MN-DIGTL-MTR-TYPE   TO E-FBW71-DMT                      
           MOVE MN-PROGRAM-ID       TO E-FBW71-PGM-ID                   
           MOVE MN-REMOTE-READ-IND  TO E-FBW71-RRI                      
                                       WS-REMOTE-READ-IND-FL            
      *                                                                         
      ***  POPULATE E-FBW71-ACTIVE-INDICATOR based on CODE-METER-STATUS         
      ***  K --> Removed, Inactive or not yet installed                         
      ***  J --> Inactive, turned off (meter in place, no power to it)          
      ***  0 --> KVAR install........monitor only                               
      ***  1 --> KVAR read 1 month...monitor only                               
      ***  I --> Active, monitor only                                           
      ***  A --> Active, normal billing                                         
      ***  B --> Active, limited service                                        
      ***                                                                       
           IF MN-CODE-METER-STATUS = 'J'                                
              SET E-FBW71-MTR-ACTIVE-NO TO TRUE                         
           ELSE                                                         
              SET E-FBW71-MTR-ACTIVE-YES TO TRUE                        
           END-IF.                                                      
      *                                                                         
      ***  POPULATE LAT LONG DATA (ANY NON-ZERO VALUE IS VALID)                 
A#5470     IF PR-PREM-REF-LATITUDE NOT = 0                              
A#5470        AND PR-PREM-REF-LONGITUDE NOT = 0                         
A#5470        MOVE PR-PREM-REF-LATITUDE   TO E-FBW71-LATITUDE           
A#5470        MOVE PR-PREM-REF-LONGITUDE  TO E-FBW71-LONGITUDE          
           ELSE                                                         
              MOVE 0                    TO E-FBW71-LATITUDE             
              MOVE 0                    TO E-FBW71-LONGITUDE            
           END-IF.                                                      
      *                                                                         
      **** WorkSetType always 5 (Host Generated Route)                          
           MOVE 5                        TO E-FBW71-WORK-SET-TYPE       
      *                                                                         
      **** SEQ WILL BE UPDATED IN PCSBW172 IF ROUTE QUALIFIES                   
           MOVE 0                        TO E-FBW71-SEQUENCE-NUMBER     
      *                                                                         
      **** WorkType always 0 (meter read) -- special read (7) AROP?             
           MOVE 0                        TO E-FBW71-WORK-TYPE           
      *                                                                         
      **** GET CONSTANT & DIALS FROM MTR CAP, BUT USE DIALS IF REQUIRE          
           MOVE AT-COMPANY-NO          TO MC-COMPANY-NO                 
           MOVE UT-CODE-UTIL-TYPE      TO MC-CODE-UTIL-TYPE             
           MOVE MN-METER-NO            TO MC-METER-NO                   
           MOVE MN-REG-ID-NO           TO MC-REG-ID-NO                  
A00795     MOVE ZERO                   TO WS-MC-CONSTANT                
           PERFORM 7223-SELECT-MTR-CAP    THRU 7223-EXIT.               
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE MC-NO-READ-DIALS   TO WS-BW71-NO-READ-DIALS         
               MOVE MC-CONSTANT        TO E-FBW71-CONSTANT              
A00795                                    WS-MC-CONSTANT                
           ELSE                                                         
               MOVE ZEROS              TO WS-BW71-NO-READ-DIALS         
               MOVE 1                  TO E-FBW71-CONSTANT              
A00795                                    WS-MC-CONSTANT                
           END-IF.                                                      
      *                                                                         
      **** DECIMALS WILL BE POPULATED WITH RD FMT LATER                         
           MOVE 0                       TO E-FBW71-NO-READ-DECIMALS     
      *                                                                         
      **** ONLY 0 THRU 9 ARE VALID VALUES FOR FCS?                              
           IF MN-NO-CONSEC-ESTIMATE < 9                                 
             MOVE MN-NO-CONSEC-ESTIMATE TO E-FBW71-CONSECUTIVE-ESTIMATES
           ELSE                                                         
             MOVE 9                 TO E-FBW71-CONSECUTIVE-ESTIMATES    
           END-IF                                                       
      *                                                                         
      **** SEND WARNING PROMPT CD TO DC USER IF ESTIMATED LAST 2MONTHSH         
           IF E-FBW71-CONSECUTIVE-ESTIMATES > 1                         
              MOVE 2                    TO E-FBW71-PROMPT-CODE          
           ELSE                                                         
              MOVE 0                    TO E-FBW71-PROMPT-CODE          
           END-IF                                                       
      *                                                                         
      *** USE 0 FOR NORMAL CONSUMPTION REG & 1 FOR DEMAND REG                   
      *** SET TO 1 LATER FOR DEMAND REGISTERS                                   
           MOVE 0                TO E-FBW71-TYPE-OF-VALIDATION-IND      
      *                                                                         
           INITIALIZE E-FBW71-METER-SESSION-INPUT-RF.                   
           INITIALIZE  E-FBW71-MSI-OPTICAL.                             
           INITIALIZE WS-MATCH-REG-ARRAY.                               
      ***  POPULATE E-FBW71-GROUP-FLAG AS SINGLE (NO GROUPING) UPDATE           
      ***  LATER TO GROUP FOR TOU and Demand METERS                             
           SET E-FBW71-GROUP-SINGLE-REG TO TRUE                         
           SET E-FBW71-READ-METHOD-MANUAL TO TRUE                       
           SET NO-RD-FMT-ENTRIES-WQ       TO TRUE                       
A00795*                                                                         
A00795     IF AMR-MTR                                                   
A00795        PERFORM 2500-GET-AMR-DEVICE      THRU 2500-EXIT           
A00795     END-IF.                                                      
A00795*                                                                         
A00795     IF AMR-MTR OR MANUAL-MTR OR TOU-MANUAL                       
A00795        PERFORM 2600-LOOKUP-MTR-RD-FMT   THRU 2600-EXIT           
A00795        PERFORM 2700-MATCH-MTR-RD-FMT    THRU 2700-EXIT           
A00795        IF WS-CODE-TIME-PERIOD  NOT = WS-HL-CODE-TIME-PERIOD      
A00795           OR  WS-CODE-USAGE-ID NOT = WS-HL-CODE-USAGE-ID         
A00795           PERFORM 2800-GET-HIGH-LOW-LIMITS THRU 2800-EXIT        
A00795        END-IF                                                    
A00795     END-IF.                                                      
A00795*                                                                         
A00795     IF OPTICAL-PROB-MTR                                          
A00795        PERFORM 2900-LOAD-OPT-PROB-DATA  THRU 2900-EXIT           
A00795     END-IF.                                                      
      *                                                                         
           PERFORM 2050-CREATE-WORKSET-ID    THRU 2050-EXIT             
      *                                                                         
      **** SINCE WE ARE CREATING SUFFIX X ROUTE WITH DIFFERENT READ             
      **** METHODS (OPTICAL, WALK-BY & KEYED), SO Segment FIELD CAN BE          
      **** USED TO SPLIT & ASSIGN TO DIFFERENT HAND-HELDS IF POPULATED          
      **** WITH READ METHOD.                                                    
           MOVE E-FBW71-READ-METHOD    TO E-FBW71-SEGMENT               
      **** ADD +10 TO DEAL WITH READMETHOD ZERO                                 
           COMPUTE E-FBW71-SEGMENT = E-FBW71-SEGMENT + 10               
      *                                                                         
           MOVE ZEROS                  TO E-FBW71-LOW1                  
                                          E-FBW71-LOW2                  
           MOVE 999999999              TO E-FBW71-HI1                   
                                          E-FBW71-HI2                   
           IF HILO-LIMITS-CALC                                          
              MOVE MN-LAST-REG-READ-DATE TO WS-LAST-REG-RD-DT           
              MOVE MN-MIN-NO-UNITS     TO WS-MIN-NO-UNITS               
              MOVE MN-MAX-NO-UNITS     TO WS-MAX-NO-UNITS               
              PERFORM 2850-LOAD-HIGH-LOW-LIMITS THRU 2850-EXIT          
              MOVE WS-MIN-NO-UNITS     TO MN-MIN-NO-UNITS               
              MOVE WS-MAX-NO-UNITS     TO MN-MAX-NO-UNITS               
           END-IF.                                                      
      *                                                                         
      **** SEQ REQ FLAG WILL BE UPDATED BY PCSBW172 PROGRAM                     
           MOVE 'Y'             TO E-FBW71-SEQ-REQUIRED                 
      *                                                                         
P00135**** SEND 00 TO READ TYPE BY DEFAULT AND OVERRIDE WITH G6                 
P00135**** ONLY IN CASE OF GAS 6 DIAL METERS TO FORMAT READ CORRECTLY           
P00135     MOVE '00'                   TO E-FBW71-READ-TYPE-CODE        
P00135     IF E-FBW71-GAS AND AMR-MTR                                   
P00135        AND E-FBW71-NO-READ-DIALS = WS-SIX-DIALS                  
P00135        MOVE WS-READ-TYPE-G6         TO E-FBW71-READ-TYPE-CODE    
P00135     END-IF.                                                      
      *                                                                         
           SET FORMATTED-DATA-MN       TO TRUE.                         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2010-GET-FILTER-INFO.                                            
      *==============================================================*          
      *                                                                         
           IF AT-LOCAL-OFFICE = WS-PREV-LOCAL-OFFICE                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE AT-LOCAL-OFFICE TO WS-PREV-LOCAL-OFFICE              
              MOVE SPACES          TO WS-FBW71-FILTERING-INFO           
              PERFORM VARYING FCSFI-SUB FROM 1 BY 1                     
                 UNTIL FCSFI-SUB >  WS-FILTER-INFO-COUNT                
                 IF AT-LOCAL-OFFICE = TB-CODE-VALUE(FCSFI-SUB)(1:3)     
                    MOVE TB-FILTER-INFO-DATA (FCSFI-SUB)                
                                       TO WS-FBW71-FILTERING-INFO       
                    MOVE WS-FILTER-INFO-COUNT TO FCSFI-SUB              
                 END-IF                                                 
              END-PERFORM                                               
           END-IF.                                                      
      *                                                                         
           IF WS-FBW71-FILTERING-INFO = SPACES                          
              MOVE '/Root Node'        TO WS-FBW71-FILTERING-INFO       
           END-IF.                                                      
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2050-CREATE-WORKSET-ID.                                          
      *================================================================*        
      *** Populate WORKSET ID (8 CHAR) as below                      ***        
      *** POS 1        --> Company ( S for SCEG, P for PSNC)         ***        
      *** POS 2, 3     --> Cycle number                              ***        
      *** POS 4 thru 7 --> For reguler reads - Use Read Route        ***        
      ***              --> For AROP - Use zero + local office        ***        
      *** POS 8        --> M for mobile, X for Manual or A for AROP  ***        
      ***------------------------------------------------------------***        
      *                                                                         
           IF AT-COMPANY-NO = '01'                                      
              MOVE 'S'                   TO WS-WORKSET-COMPANY          
           ELSE                                                         
              MOVE 'P'                   TO WS-WORKSET-COMPANY          
           END-IF.                                                      
      *                                                                         
A04527     IF E-FDB09-OFF-CYCLE-BILL-CODE = WS-STORM                    
A04527        MOVE WS-55 TO WS-WORKSET-CYCLE                            
A04527     ELSE                                                         
              MOVE WS-MRMS-CYCLE-NO TO WS-WORKSET-CYCLE                 
A04527     END-IF.                                                      
      *                                                                         
A04527     IF E-FDB09-OFF-CYCLE-BILL-CODE = WS-AROP OR WS-STORM         
              MOVE ZERO                     TO WS-WORKSET-LOC-ZERO      
A05744                                                                  
A05744        PERFORM 7870-GET-OVERRIDE-LOFF  THRU 7870-EXIT            
A05744        IF O2-ERROR-MSG-NO <= SPACES                              
A05744           MOVE E-FBW71-LOCAL-OFFICE     TO WS-WORKSET-LOC-NUM    
A05744        ELSE                                                      
A05744           MOVE O2-ERROR-MSG-NO(1:3)     TO WS-WORKSET-LOC-NUM    
A05744        END-IF                                                    
                                                                        
              MOVE 'A'                      TO WS-WORKSET-SUFIX         
           ELSE                                                         
              MOVE E-FBW71-READ-ROUTE       TO WS-WORKSET-ROUTE         
              IF E-FBW71-READ-METHOD-DRIVE-BY                           
                 MOVE 'M'                   TO WS-WORKSET-SUFIX         
              ELSE                                                      
                 MOVE 'X'                   TO WS-WORKSET-SUFIX         
              END-IF                                                    
           END-IF                                                       
      *                                                                         
A04880     IF E-FDB09-OFF-CYCLE-BILL-CODE = WS-STORM                    
A04880        MOVE E-FDB09-CIRCUIT-NBR TO WS-CIRCUIT-NBR                
A04880     END-IF.                                                      
      *                                                                         
           MOVE WS-WORKSET-ID           TO E-FBW71-WORK-SET-ID.         
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2100-FORMAT-BW71-RG.                                             
      *==============================================================*          
      *                                                                         
           IF UT-CODE-UTIL-TYPE = 'E'                                   
              SET E-FBW71-GROUP-MULTIPLE-REG TO TRUE                    
           END-IF.                                                      
      *                                                                         
           IF AMR-MTR                                                   
              SET E-FBW71-ENDPOINT-MULTI-REG TO TRUE                    
           END-IF.                                                      
      *                                                                         
           IF FORMATTED-DATA-MN                                         
              PERFORM 8400-WRITE-FCSBW71          THRU 8400-EXIT        
           END-IF.                                                      
      *                                                                         
           SET FORMATTED-DATA-RG       TO TRUE                          
           IF AMR-MTR                                                   
              COMPUTE E-FBW71-SS-DEMAND-IND                             
                      = E-FBW71-SS-DEMAND-IND + 1                       
           END-IF.                                                      
      *                                                                         
           MOVE RG-CODE-TIME-PERIOD    TO E-FBW71-TIME-PERIOD           
A00795                                    WS-CODE-TIME-PERIOD           
P00251     MOVE RG-CODE-USAGE-TYPE     TO E-FBW71-CODE-USAGE-TYPE       
A00795                                    WS-CODE-USAGE-TYPE            
A00795     MOVE RG-CODE-USAGE-ID       TO WS-CODE-USAGE-ID              
P00251                                    E-FBW71-CODE-USAGE-ID         
P00251     MOVE RG-CODE-USAGE-SOURCE   TO E-FBW71-CODE-USAGE-SOURCE     
           MOVE 'C'                    TO E-FBW71-CODE-TOU-SEASN        
           MOVE ZEROS                  TO E-FBW71-REG-READ-ORDER        
           MOVE RG-LAST-READ-VALUE     TO E-FBW71-PREV-READ-VALUE       
           MOVE MN-REGISTER-RD-SEQ     TO E-FBW71-READ-SEQ              
           MOVE RG-REG-ID-NO           TO E-FBW71-REG-ID-NO             
                                          MC-REG-ID-NO                  
           MOVE AT-COMPANY-NO          TO MC-COMPANY-NO                 
           MOVE UT-CODE-UTIL-TYPE      TO MC-CODE-UTIL-TYPE             
           MOVE MN-METER-NO            TO MC-METER-NO                   
           MOVE ZERO                   TO WS-MC-CONSTANT                
      *                                                                         
           PERFORM 7223-SELECT-MTR-CAP      THRU 7223-EXIT              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE MC-NO-READ-DIALS   TO WS-BW71-NO-READ-DIALS          
              MOVE MC-CONSTANT        TO E-FBW71-CONSTANT               
                                         WS-MC-CONSTANT                 
           ELSE                                                         
              MOVE ZEROS               TO WS-BW71-NO-READ-DIALS         
              MOVE 1                   TO E-FBW71-CONSTANT              
           END-IF                                                       
      *                                                                         
A00795     IF WS-CODE-TIME-PERIOD    = WS-HL-CODE-TIME-PERIOD           
A00795        AND WS-CODE-USAGE-ID   = WS-HL-CODE-USAGE-ID              
A00795        CONTINUE                                                  
A00795     ELSE                                                         
A00795        PERFORM 2800-GET-HIGH-LOW-LIMITS THRU 2800-EXIT           
A00795     END-IF.                                                      
A00795*                                                                         
           MOVE ZEROS                  TO E-FBW71-LOW1                  
                                          E-FBW71-LOW2                  
           MOVE 999999999              TO E-FBW71-HI1                   
                                          E-FBW71-HI2                   
           IF HILO-LIMITS-CALC                                          
              MOVE RG-LAST-REG-READ-DT   TO WS-LAST-REG-RD-DT           
              MOVE RG-MIN-NO-UNITS       TO WS-MIN-NO-UNITS             
              MOVE RG-MAX-NO-UNITS       TO WS-MAX-NO-UNITS             
              PERFORM 2850-LOAD-HIGH-LOW-LIMITS  THRU 2850-EXIT         
              MOVE WS-MIN-NO-UNITS       TO RG-MIN-NO-UNITS             
              MOVE WS-MAX-NO-UNITS       TO RG-MAX-NO-UNITS             
           END-IF                                                       
      *                                                                         
           PERFORM 2700-MATCH-MTR-RD-FMT    THRU 2700-EXIT.             
P00135**** SEND 00 TO READ TYPE BY DEFAULT AND OVERRIDE WITH G6                 
P00135**** ONLY IN CASE OF GAS 6 DIAL METERS TO FORMAT READ CORRECTLY           
P00135     MOVE '00'                   TO E-FBW71-READ-TYPE-CODE        
P00135     IF E-FBW71-GAS AND AMR-MTR                                   
P00135        AND E-FBW71-NO-READ-DIALS = WS-SIX-DIALS                  
P00135        MOVE WS-READ-TYPE-G6         TO E-FBW71-READ-TYPE-CODE    
P00135     END-IF.                                                      
      *                                                                         
           PERFORM 8400-WRITE-FCSBW71       THRU 8400-EXIT.             
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2200-FORMAT-BW71-OTHER.                                          
      *==============================================================*          
      *** CHECK UN-MATCHED ROWS IN MTR RD FORMAT & SEND THEM FOR READING        
      *** NORMALLY NON-CNS RG'S LIKE VLT, TMP, PRE & UCG HANDLED HERE,          
      *** OTHERWISE CREATE WQ FOR CONSUMPTION REGISTERS.                        
      *                                                                         
           IF ARR-MATCH-FOUND (WS-MRF-SUB2) = 'N'                       
              IF UT-CODE-UTIL-TYPE = 'E'                                
                 SET E-FBW71-GROUP-MULTIPLE-REG TO TRUE                 
              END-IF                                                    
              IF AMR-MTR                                                
                 SET E-FBW71-ENDPOINT-MULTI-REG TO TRUE                 
              END-IF                                                    
              IF FORMATTED-DATA-MN                                      
                 PERFORM 8400-WRITE-FCSBW71          THRU 8400-EXIT     
              END-IF                                                    
      *                                                                         
              SET FORMATTED-DATA-RG       TO TRUE                       
              IF AMR-MTR                                                
                 COMPUTE E-FBW71-SS-DEMAND-IND                          
                      = E-FBW71-SS-DEMAND-IND + 1                       
              END-IF                                                    
              MOVE ARR-CODE-USAGE-TYPE (WS-MRF-SUB2)                    
P00251                              TO E-FBW71-CODE-USAGE-TYPE          
P00251        MOVE ARR-CODE-USAGE-ID (WS-MRF-SUB2)                      
P00251                              TO E-FBW71-CODE-USAGE-ID            
P00251        MOVE ARR-CODE-USAGE-SOURCE (WS-MRF-SUB2)                  
P00251                              TO E-FBW71-CODE-USAGE-SOURCE        
              MOVE ARR-CODE-TIME-PERIOD (WS-MRF-SUB2)                   
                                    TO E-FBW71-TIME-PERIOD              
              MOVE ARR-READ-SEQUENCE-NO (WS-MRF-SUB2)                   
                                    TO E-FBW71-REG-READ-ORDER           
              MOVE ARR-MTR-RD-DISP-CD (WS-MRF-SUB2)                     
                                    TO  E-FBW71-TEXT-PROMPT             
              MOVE ARR-NO-READ-DIGITS (WS-MRF-SUB2)                     
                                    TO E-FBW71-NO-READ-DIALS            
              MOVE ARR-NO-READ-DECIMALS (WS-MRF-SUB2)                   
                                    TO E-FBW71-NO-READ-DECIMALS         
              MOVE ARR-MIN-READ  (WS-MRF-SUB2)                          
                                    TO E-FBW71-LOW1                     
                                       E-FBW71-LOW2                     
              IF ARR-MAX-READ  (WS-MRF-SUB2) > 0                        
                 MOVE ARR-MAX-READ  (WS-MRF-SUB2)                       
                                    TO E-FBW71-HI1                      
                                       E-FBW71-HI2                      
              ELSE                                                      
                 MOVE 999999999     TO E-FBW71-HI1                      
                                       E-FBW71-HI2                      
              END-IF                                                    
              MOVE ARR-CODE-TOU-SEASN (WS-MRF-SUB2)                     
                                       TO E-FBW71-CODE-TOU-SEASN        
              MOVE ARR-INDEX-VALUE-CD (WS-MRF-SUB2)                     
                                       TO E-FBW71-INDEX-VALUE-CD        
              MOVE ARR-CNSMPTN-READ-FL (WS-MRF-SUB2)                    
                                       TO E-FBW71-CNSMPTN-READ-FL       
              IF ARR-INDEX-VALUE-CD(WS-MRF-SUB2) = 'V'                  
                 MOVE 1         TO E-FBW71-TYPE-OF-VALIDATION-IND       
              ELSE                                                      
                 MOVE 0         TO E-FBW71-TYPE-OF-VALIDATION-IND       
              END-IF                                                    
              MOVE 'Y'              TO ARR-MATCH-FOUND (WS-MRF-SUB2)    
              MOVE ZEROS            TO E-FBW71-PREV-READ-VALUE          
P00251        MOVE ARR-REG-ID-NO(WS-MRF-SUB2)                           
P00251                              TO E-FBW71-REG-ID-NO                
              MOVE 1                TO E-FBW71-CONSTANT                 
P00135**** SEND 00 TO READ TYPE BY DEFAULT AND OVERRIDE WITH G6                 
P00135**** ONLY IN CASE OF GAS 6 DIAL METERS TO FORMAT READ CORRECTLY           
P00135        MOVE '00'                TO E-FBW71-READ-TYPE-CODE        
P00135        IF E-FBW71-GAS AND AMR-MTR                                
P00135           AND E-FBW71-NO-READ-DIALS = WS-SIX-DIALS               
P00135           MOVE WS-READ-TYPE-G6      TO E-FBW71-READ-TYPE-CODE    
P00135        END-IF                                                    
      *                                                                         
              PERFORM 8400-WRITE-FCSBW71       THRU 8400-EXIT           
      *                                                                         
              IF ARR-CNSMPTN-READ-FL (WS-MRF-SUB2) = 'Y'                
ACT069           INITIALIZE CWS00077-FIELDS                             
                 MOVE ARR-CODE-USAGE-TYPE (WS-MRF-SUB2)                 
                                  TO WQ5-CODE-USAGE-TYPE                
                 MOVE ARR-MTR-RD-DISP-CD (WS-MRF-SUB2)                  
                                  TO WQ5-DISP-CD                        
                 MOVE ARR-CODE-TIME-PERIOD (WS-MRF-SUB2)                
                                  TO WQ5-CODE-TIME-PERIOD               
      *                                                                         
                 MOVE E-FBW71-METER-NO    TO WQ5-METER-NO               
                 STRING WS-WQ-ERROR-TEXT5                               
                         DELIMITED BY SIZE                              
ACT069                   INTO WS-77-COMMENTS-TEXT                       
ACT069           MOVE LENGTH OF WS-77-COMMENTS-TEXT                     
ACT069                               TO WS-77-COMMENTS-LEN              
                 PERFORM 5020-CREATE-WORKQ  THRU 5020-EXIT              
      *                                                                         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2500-GET-AMR-DEVICE.                                             
      *================================================================*        
      *                                                                         
           MOVE UT-CODE-UTIL-TYPE      TO MA-CODE-UTIL-TYPE.            
           MOVE MN-METER-NO            TO MA-METER-NO.                  
           MOVE AT-COMPANY-NO          TO MA-COMPANY-NO.                
           PERFORM 7860-SELECT-AMR-DEVICE     THRU 7860-EXIT.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2510-CHECK-FOR-MRMS-ROUTE THRU 2510-EXIT          
              MOVE MA-DEVICE-NO        TO E-FBW71-ENDPOINT-ID           
      *                                                                         
      **** SS-DEMAND IND 0 - 1ST REG, 1 - 2ND REG AND SO ON.                    
              SET E-FBW71-ENDPOINT-SINGLE-REG TO TRUE                   
              MOVE ZEROS               TO E-FBW71-SS-DEMAND-IND         
      *                                                                         
              IF MN-CODE-MTR-RD-INST2 > SPACES                          
                 MOVE MN-CODE-MTR-RD-INST2 TO E-FBW71-TAMPER-COUNT1     
              ELSE                                                      
                 MOVE 16                   TO E-FBW71-TAMPER-COUNT1     
              END-IF                                                    
      *                                                                         
              IF MN-CODE-MTR-RD-INST3 > SPACES                          
                 MOVE MN-CODE-MTR-RD-INST3 TO E-FBW71-TAMPER-COUNT2     
              ELSE                                                      
                 MOVE 16                   TO E-FBW71-TAMPER-COUNT2     
              END-IF                                                    
      *                                                                         
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2510-CHECK-FOR-MRMS-ROUTE.                                       
      *==============================================================*          
      *                                                                         
           MOVE AT-COMPANY-NO              TO R4-COMPANY-NO             
           MOVE UT-READ-ROUTE              TO R4-READ-ROUTE             
           MOVE MN-MTR-READ-SOURCE-CD      TO R4-MTR-READ-SOURCE-CD     
           MOVE UT-CODE-UTIL-TYPE          TO WS-E-G-UTIL-TYPE          
           MOVE 'B'                        TO WS-B-E-G-UTIL-TYPE        
           MOVE ' '                        TO R4-MANUAL-READ-FL         
           MOVE ZEROS                      TO WS-AMR-COMM-FREQ-CD       
                                                                        
           PERFORM 7035-GET-MRMS-ROUTE THRU 7035-EXIT.                  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL WS-811                        
              IF R4-CODE-UTIL-TYPE = WS-E-G-UTIL-TYPE                   
                 MOVE ZERO TO WS-ACTIVE-RETURN-CODE                     
              ELSE                                                      
                 MOVE WS-E-G-UTIL-TYPE TO WS-B-E-G-UTIL-TYPE            
                 PERFORM 7035-GET-MRMS-ROUTE THRU 7035-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              SET E-FBW71-READ-METHOD-DRIVE-BY TO TRUE                  
              IF R4-AMR-COMM-FREQ-CD IS NUMERIC                         
                 MOVE R4-AMR-COMM-FREQ-CD TO WS-AMR-COMM-FREQ-CD        
              END-IF                                                    
           ELSE                                                         
              SET E-FBW71-READ-METHOD-WALK-BY  TO TRUE                  
A04527        IF E-FDB09-OFF-CYCLE-BILL-CODE = WS-AROP OR WS-STORM      
                 SET E-FBW71-READ-METHOD-DRIVE-BY TO TRUE               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-AMR-COMM-FREQ-CD > ZEROS                               
              CONTINUE                                                  
           ELSE                                                         
              IF NON-STD-FRQ-OFFICE                                     
                 MOVE 265   TO WS-AMR-COMM-FREQ-CD                      
              ELSE                                                      
                 MOVE 865   TO WS-AMR-COMM-FREQ-CD                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           COMPUTE E-FBW71-RF-FREQUENCY                                 
                   = (WS-CARRIER-CNST1 * WS-AMR-COMM-FREQ-CD)           
                     + WS-CARRIER-CNST2                                 
           MOVE 4                   TO E-FBW71-WAKEUP-TONE.             
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2600-LOOKUP-MTR-RD-FMT.                                          
      *==============================================================*          
      *                                                                         
           PERFORM VARYING WS-MRF-SUB FROM 1 BY 1                       
                                 UNTIL WS-MRF-SUB > WS-RD-FMT-COUNT     
                                  OR WS-MRF-SUB > 1000                  
             IF TAB-CODE-UTIL-TYPE    (WS-MRF-SUB) = E-FBW71-UTL-TYPE   
               AND TAB-DIGTL-MTR-TYPE (WS-MRF-SUB) = E-FBW71-DMT        
               AND TAB-PROGRAM-ID     (WS-MRF-SUB) = E-FBW71-PGM-ID     
               AND TAB-REMOTE-READ-IND(WS-MRF-SUB) = E-FBW71-RRI        
               AND TAB-MTR-READ-SOURCE-CD (WS-MRF-SUB)                  
                                       = E-FBW71-MTR-READ-SOURCE-CD     
                COMPUTE WS-MRF-SUB2 = WS-MRF-SUB2 + 1                   
                MOVE TAB-CODE-USAGE-TYPE (WS-MRF-SUB)                   
                                   TO ARR-CODE-USAGE-TYPE (WS-MRF-SUB2) 
P00251          MOVE TAB-CODE-USAGE-ID  (WS-MRF-SUB)                    
P00251                             TO ARR-CODE-USAGE-ID(WS-MRF-SUB2)    
P00251          MOVE TAB-CODE-USAGE-SOURCE (WS-MRF-SUB)                 
P00251                             TO ARR-CODE-USAGE-SOURCE(WS-MRF-SUB2)
P00251          MOVE TAB-REG-ID-NO (WS-MRF-SUB)                         
P00251                             TO ARR-REG-ID-NO (WS-MRF-SUB2)       
                MOVE TAB-CODE-TIME-PERIOD (WS-MRF-SUB)                  
                                   TO ARR-CODE-TIME-PERIOD (WS-MRF-SUB2)
                MOVE TAB-MTR-RD-DISP-CD (WS-MRF-SUB)                    
                                   TO ARR-MTR-RD-DISP-CD (WS-MRF-SUB2)  
                MOVE TAB-NO-READ-DIGITS (WS-MRF-SUB)                    
                                   TO ARR-NO-READ-DIGITS (WS-MRF-SUB2)  
                MOVE TAB-NO-READ-DECIMALS (WS-MRF-SUB)                  
                                   TO ARR-NO-READ-DECIMALS (WS-MRF-SUB2)
                MOVE TAB-READ-SEQUENCE-NO (WS-MRF-SUB)                  
                                   TO ARR-READ-SEQUENCE-NO (WS-MRF-SUB2)
                MOVE TAB-CODE-TOU-SEASN   (WS-MRF-SUB)                  
                                   TO ARR-CODE-TOU-SEASN   (WS-MRF-SUB2)
                MOVE TAB-INDEX-VALUE-CD   (WS-MRF-SUB)                  
                                   TO ARR-INDEX-VALUE-CD   (WS-MRF-SUB2)
                MOVE TAB-CNSMPTN-READ-FL  (WS-MRF-SUB)                  
                                   TO ARR-CNSMPTN-READ-FL  (WS-MRF-SUB2)
                MOVE TAB-MIN-READ (WS-MRF-SUB)                          
                                   TO ARR-MIN-READ (WS-MRF-SUB2)        
                MOVE TAB-MAX-READ (WS-MRF-SUB)                          
                                   TO ARR-MAX-READ (WS-MRF-SUB2)        
                MOVE 'N'           TO ARR-MATCH-FOUND  (WS-MRF-SUB2)    
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
           MOVE WS-MRF-SUB2            TO WS-MATCH-REG-COUNT            
           IF WS-MRF-SUB2 = 0                                           
      ***  CREATE A WQ SAYING THE DMT/PGM ID COMBINATION DOES NOT               
      ***  HAVE THE METER READ FORMAT TABLE ENTRIES.                            
ACT069        INITIALIZE CWS00077-FIELDS                                
              SET RD-FMT-ENTRIES-WQ       TO TRUE                       
              MOVE E-FBW71-UTL-TYPE                                     
                        TO WQ4-OA-CODE-UTIL-TYPE                        
              MOVE E-FBW71-DMT                                          
                        TO WQ4-OA-DIGTL-MTR-TYPE                        
              MOVE E-FBW71-PGM-ID                                       
                         TO WQ4-OA-PROGRAM-ID                           
              MOVE E-FBW71-MTR-READ-SOURCE-CD                           
                           TO WQ4-OA-MTR-READ-SOURCE-CD                 
              MOVE E-FBW71-RRI                                          
                           TO WQ4-OA-REMOTE-READ-IND                    
              MOVE E-FBW71-METER-NO TO WQ4-METER-NO                     
      *                                                                         
              STRING WS-WQ-ERROR-TEXT4                                  
                 DELIMITED BY SIZE                                      
ACT069              INTO WS-77-COMMENTS-TEXT                            
ACT069        MOVE LENGTH OF WS-77-COMMENTS-TEXT TO WS-77-COMMENTS-LEN  
              PERFORM 5020-CREATE-WORKQ  THRU 5020-EXIT                 
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *==============================================================*          
       2700-MATCH-MTR-RD-FMT.                                           
      *==============================================================*          
      *                                                                         
           MOVE 0         TO E-FBW71-TYPE-OF-VALIDATION-IND             
           SET NO-REG-MATCH-FOUND    TO TRUE                            
           PERFORM VARYING WS-MRF-SUB2 FROM 1 BY 1                      
                              UNTIL WS-MRF-SUB2 > WS-MATCH-REG-COUNT    
                                  OR WS-MRF-SUB2 > 25                   
             IF ARR-CODE-USAGE-TYPE (WS-MRF-SUB2)                       
P00251                              = E-FBW71-CODE-USAGE-TYPE           
P00251         AND ARR-CODE-USAGE-ID (WS-MRF-SUB2)                      
P00251                              = E-FBW71-CODE-USAGE-ID             
               AND ARR-CODE-TIME-PERIOD (WS-MRF-SUB2)                   
                                    = E-FBW71-TIME-PERIOD               
                SET REG-MATCH-FOUND    TO TRUE                          
                MOVE ARR-MTR-RD-DISP-CD (WS-MRF-SUB2)                   
                                       TO  E-FBW71-TEXT-PROMPT          
                MOVE ARR-NO-READ-DIGITS (WS-MRF-SUB2)                   
                                       TO E-FBW71-NO-READ-DIALS         
                MOVE ARR-NO-READ-DECIMALS (WS-MRF-SUB2)                 
                                       TO E-FBW71-NO-READ-DECIMALS      
                MOVE ARR-READ-SEQUENCE-NO (WS-MRF-SUB2)                 
                                       TO E-FBW71-REG-READ-ORDER        
                MOVE ARR-CODE-TOU-SEASN (WS-MRF-SUB2)                   
                                       TO E-FBW71-CODE-TOU-SEASN        
                MOVE ARR-INDEX-VALUE-CD (WS-MRF-SUB2)                   
                                       TO E-FBW71-INDEX-VALUE-CD        
                MOVE ARR-CNSMPTN-READ-FL (WS-MRF-SUB2)                  
                                       TO E-FBW71-CNSMPTN-READ-FL       
                MOVE 'Y'               TO ARR-MATCH-FOUND (WS-MRF-SUB2) 
                IF ARR-INDEX-VALUE-CD(WS-MRF-SUB2) = 'V'                
                   MOVE 1         TO E-FBW71-TYPE-OF-VALIDATION-IND     
                END-IF                                                  
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
           IF E-FBW71-NO-READ-DIALS <= 0                                
      *** POPULATE WITH DIALS FROM METER CAP                                    
              MOVE  WS-BW71-NO-READ-DIALS TO E-FBW71-NO-READ-DIALS      
           END-IF                                                       
      *                                                                         
           IF  E-FBW71-NO-READ-DIALS <= 0                               
      *** IF BOTH RD FMT & METER CAP SAYS ZERO THEN SET 8 DIALS                 
               MOVE 8              TO  E-FBW71-NO-READ-DIALS            
           END-IF                                                       
      *                                                                         
           IF NO-REG-MATCH-FOUND                                        
      ***  SET DEFAULT                                                          
              MOVE ZEROS           TO E-FBW71-NO-READ-DECIMALS          
P00251        EVALUATE E-FBW71-CODE-USAGE-TYPE                          
                 WHEN 'B'                                               
                    MOVE 'KWH'     TO E-FBW71-TEXT-PROMPT               
                 WHEN 'C'                                               
                    MOVE 'GAS'     TO E-FBW71-TEXT-PROMPT               
                 WHEN 'J'                                               
                    MOVE 'KW'      TO E-FBW71-TEXT-PROMPT               
                    MOVE 3         TO E-FBW71-NO-READ-DECIMALS          
                    MOVE 1         TO E-FBW71-TYPE-OF-VALIDATION-IND    
                 WHEN 'E'                                               
                    MOVE 'KVA'     TO E-FBW71-TEXT-PROMPT               
                    MOVE 3         TO E-FBW71-NO-READ-DECIMALS          
                    MOVE 1         TO E-FBW71-TYPE-OF-VALIDATION-IND    
                 WHEN 'U'                                               
                    MOVE 'UNC'     TO E-FBW71-TEXT-PROMPT               
                 WHEN 'I'                                               
                    MOVE 'INT'     TO E-FBW71-TEXT-PROMPT               
                 WHEN OTHER                                             
                    MOVE 'NONE'    TO E-FBW71-TEXT-PROMPT               
              END-EVALUATE                                              
              IF NO-RD-FMT-ENTRIES-WQ                                   
ACT069           INITIALIZE CWS00077-FIELDS                             
                 SET RD-FMT-ENTRIES-WQ       TO TRUE                    
                 MOVE E-FBW71-UTL-TYPE                                  
                        TO WQ4-OA-CODE-UTIL-TYPE                        
                 MOVE E-FBW71-DMT                                       
                        TO WQ4-OA-DIGTL-MTR-TYPE                        
                 MOVE E-FBW71-PGM-ID                                    
                         TO WQ4-OA-PROGRAM-ID                           
                 MOVE E-FBW71-MTR-READ-SOURCE-CD                        
                           TO WQ4-OA-MTR-READ-SOURCE-CD                 
                 MOVE E-FBW71-RRI                                       
                           TO WQ4-OA-REMOTE-READ-IND                    
                 MOVE E-FBW71-METER-NO TO WQ4-METER-NO                  
      *                                                                         
                 STRING WS-WQ-ERROR-TEXT4                               
                    DELIMITED BY SIZE                                   
ACT069              INTO WS-77-COMMENTS-TEXT                            
ACT069           MOVE LENGTH OF WS-77-COMMENTS-TEXT                     
ACT069                       TO WS-77-COMMENTS-LEN                      
                 PERFORM 5020-CREATE-WORKQ  THRU 5020-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2800-GET-HIGH-LOW-LIMITS.                                        
      *================================================================*        
      *** CALL HIGH LOW ROUTINUE AND GET PER DAY HIGH & LOW LIMITS.             
      *                                                                         
A00795     SET CWS72-BATCH-CALL        TO TRUE                          
A00795     MOVE AT-ACCOUNT-NO          TO CWS72-ACCOUNT-NO              
A00795     MOVE UT-IC-NO               TO CWS72-IC-NO                   
A00795     MOVE MN-CODE-UTIL-TYPE      TO CWS72-UTIL-TYPE               
A00795     MOVE UT-RATE-PLAN-NO        TO CWS72-RATE-PLAN               
A00795     MOVE MN-MTR-REF-NO          TO CWS72-MTR-REF-NO              
A00795     MOVE AT-REV-MTH-LST-NRML    TO CWS72-REV-MTH-LST-NRML        
A00795     MOVE WS-CODE-TIME-PERIOD    TO CWS72-TIME-PERIOD             
A00795                                    WS-HL-CODE-TIME-PERIOD        
A00795     MOVE WS-CODE-USAGE-ID       TO CWS72-CODE-USAGE-ID           
A00795                                    WS-HL-CODE-USAGE-ID           
A00795*                                                                         
A00795     PERFORM 6351-CPD72-HI-LO-MAIN  THRU 6351-CPD72-EXIT          
A00795     PERFORM 6399-CHECK-HI-LO-ERROR THRU 6399-EXIT.               
A00795*                                                                         
A00795     IF NOT (CWS72-ERROR OR CWS72-WARNING)                        
A00795        SET HILO-LIMITS-CALC TO TRUE                              
A00795     END-IF.                                                      
A00795*                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2850-LOAD-HIGH-LOW-LIMITS.                                       
      *================================================================*        
      *** MOVE HIGH LOW VALUES TO BW71 FILEDS AS PER USAGE-TYPE                 
      *                                                                         
           MOVE ZEROS                  TO WS-HILO-DAYS                  
           IF WS-CODE-USAGE-TYPE = ('B' OR 'C' OR 'U' OR 'I')           
              SET HL-INDX TO 1                                          
              SEARCH WS-HILO-DATE-ENTRIES                               
                AT END                                                  
                   PERFORM 7750-REG-READ-DAYS   THRU 7750-EXIT          
                WHEN WS-LAST-REG-RD-DT = WS-HL-READ-DATE (HL-INDX)      
                   MOVE WS-HL-READ-DAYS (HL-INDX) TO WS-HILO-DAYS       
              END-SEARCH                                                
           END-IF.                                                      
      *                                                                         
           EVALUATE TRUE                                                
             WHEN WS-CODE-USAGE-TYPE = ('B' OR 'C')                     
A00795          IF CWS72-HI-KWH NOT = CWS72-HILO-MAX-LIMIT              
A00795             IF WS-MC-CONSTANT <= 1                               
A00795                MOVE CWS72-HI-KWH TO CWS72-HI-KWH-RND             
A00795                MOVE CWS72-LO-KWH TO CWS72-LO-KWH-RND             
A00795             ELSE                                                 
A00795                COMPUTE CWS72-HI-KWH-RND ROUNDED                  
A00795                           = CWS72-HI-KWH / WS-MC-CONSTANT        
A00795                COMPUTE CWS72-LO-KWH-RND ROUNDED                  
A00795                           = CWS72-LO-KWH / WS-MC-CONSTANT        
A00795             END-IF                                               
A00795             MOVE CWS72-HI-KWH-RND TO WS-MAX-NO-UNITS             
A00795             MOVE CWS72-LO-KWH-RND TO WS-MIN-NO-UNITS             
A00795                                                                  
A00795             COMPUTE CWS72-HI-KWH-RND                             
A00795                           = CWS72-HI-KWH-RND * WS-HILO-DAYS      
A00795             COMPUTE CWS72-LO-KWH-RND                             
A00795                           = CWS72-LO-KWH-RND * WS-HILO-DAYS      
A00795             MOVE CWS72-HI-KWH-RND TO E-FBW71-HI1                 
A00795                                      E-FBW71-HI2                 
A00795             MOVE CWS72-LO-KWH-RND TO E-FBW71-LOW1                
A00795                                      E-FBW71-LOW2                
A00795          END-IF                                                  
      *                                                                         
             WHEN WS-CODE-USAGE-TYPE = 'U'                              
A00795          IF CWS72-HI-UNC NOT = CWS72-HILO-MAX-LIMIT              
A00795             IF WS-MC-CONSTANT <= 1                               
A00795                MOVE CWS72-HI-UNC     TO CWS72-HI-UNC-RND         
A00795                MOVE CWS72-LO-UNC     TO CWS72-LO-UNC-RND         
A00795             ELSE                                                 
A00795                COMPUTE CWS72-HI-UNC-RND ROUNDED                  
A00795                           = CWS72-HI-UNC / WS-MC-CONSTANT        
A00795                COMPUTE CWS72-LO-UNC-RND ROUNDED                  
A00795                           = CWS72-LO-UNC / WS-MC-CONSTANT        
A00795             END-IF                                               
A00795             MOVE CWS72-HI-UNC-RND TO WS-MAX-NO-UNITS             
A00795             MOVE CWS72-LO-UNC-RND TO WS-MIN-NO-UNITS             
A00795             COMPUTE CWS72-HI-UNC-RND                             
A00795                           = CWS72-HI-UNC-RND * WS-HILO-DAYS      
A00795             COMPUTE CWS72-LO-UNC-RND                             
A00795                           = CWS72-LO-UNC-RND * WS-HILO-DAYS      
A00795             MOVE CWS72-HI-UNC-RND TO E-FBW71-HI1                 
A00795                                      E-FBW71-HI2                 
A00795             MOVE CWS72-LO-UNC-RND TO E-FBW71-LOW1                
A00795                                      E-FBW71-LOW2                
A00795          END-IF                                                  
      *                                                                         
             WHEN WS-CODE-USAGE-TYPE = 'I'                              
A00795          IF CWS72-HI-INT NOT = CWS72-HILO-MAX-LIMIT              
A00795             IF WS-MC-CONSTANT <= 1                               
A00795                MOVE CWS72-HI-INT     TO CWS72-HI-INT-RND         
A00795                MOVE CWS72-LO-INT     TO CWS72-LO-INT-RND         
A00795             ELSE                                                 
A00795                COMPUTE CWS72-HI-INT-RND ROUNDED                  
A00795                           = CWS72-HI-INT / WS-MC-CONSTANT        
A00795                COMPUTE CWS72-LO-INT-RND ROUNDED                  
A00795                           = CWS72-LO-INT / WS-MC-CONSTANT        
A00795             END-IF                                               
A00795             MOVE CWS72-HI-INT-RND TO WS-MAX-NO-UNITS             
A00795             MOVE CWS72-LO-INT-RND TO WS-MIN-NO-UNITS             
A00795             COMPUTE CWS72-HI-INT-RND                             
A00795                           = CWS72-HI-INT-RND * WS-HILO-DAYS      
A00795             COMPUTE CWS72-LO-INT-RND                             
A00795                           = CWS72-LO-INT-RND * WS-HILO-DAYS      
A00795             MOVE CWS72-HI-INT-RND TO E-FBW71-HI1                 
A00795                                      E-FBW71-HI2                 
A00795             MOVE CWS72-LO-INT-RND TO E-FBW71-LOW1                
A00795                                      E-FBW71-LOW2                
A00795          END-IF                                                  
      *                                                                         
             WHEN WS-CODE-USAGE-TYPE = 'J'                              
A00795          IF CWS72-HI-KW  NOT = CWS72-HILO-MAX-LIMIT              
A00795             MOVE CWS72-HI-KW         TO WS-MAX-NO-UNITS          
A00795                                         E-FBW71-HI1              
A00795                                         E-FBW71-HI2              
A00795             MOVE CWS72-LO-KW         TO WS-MIN-NO-UNITS          
A00795                                         E-FBW71-LOW1             
A00795                                         E-FBW71-LOW2             
                                                                        
A00795             IF WS-MC-CONSTANT > 0                                
A00795                INITIALIZE WS-COMPUTE-HI-LO-KW                    
A00795                COMPUTE WS-HI-KW-HOLD ROUNDED                     
A00795                        = CWS72-HI-KW / WS-MC-CONSTANT            
A00795                COMPUTE WS-HI-READ-KW = WS-HI-KW-HOLD * 1000      
A00795                MOVE WS-HI-READ-KW    TO E-FBW71-HI1              
A00795                                         E-FBW71-HI2              
A00795                COMPUTE WS-LO-KW-HOLD ROUNDED                     
A00795                        = CWS72-LO-KW / WS-MC-CONSTANT            
A00795                COMPUTE WS-LO-READ-KW = WS-LO-KW-HOLD * 1000      
A00795                MOVE WS-LO-READ-KW    TO E-FBW71-LOW1             
A00795                                         E-FBW71-LOW2             
A00795             END-IF                                               
A00795          END-IF                                                  
      *                                                                         
             WHEN WS-CODE-USAGE-TYPE = 'E'                              
A00795          IF CWS72-HI-KVA NOT = CWS72-HILO-MAX-LIMIT              
A00795             MOVE CWS72-HI-KVA        TO WS-MAX-NO-UNITS          
A00795                                         E-FBW71-HI1              
A00795                                         E-FBW71-HI2              
A00795             MOVE CWS72-LO-KVA        TO WS-MIN-NO-UNITS          
A00795                                         E-FBW71-LOW1             
A00795                                         E-FBW71-LOW2             
                                                                        
A00795             IF WS-MC-CONSTANT > 0                                
A00795                INITIALIZE WS-COMPUTE-HI-LO-KVA                   
A00795                COMPUTE WS-HI-KVA-HOLD ROUNDED                    
A00795                        = CWS72-HI-KVA / WS-MC-CONSTANT           
A00795                COMPUTE WS-HI-READ-KVA = WS-HI-KVA-HOLD * 1000    
A00795                MOVE WS-HI-READ-KVA   TO E-FBW71-HI1              
A00795                                         E-FBW71-HI2              
A00795                COMPUTE WS-LO-KVA-HOLD ROUNDED                    
A00795                        = CWS72-LO-KVA / WS-MC-CONSTANT           
A00795                COMPUTE WS-LO-READ-KVA = WS-LO-KVA-HOLD * 1000    
A00795                MOVE WS-LO-READ-KVA   TO E-FBW71-LOW1             
A00795                                         E-FBW71-LOW2             
A00795             END-IF                                               
A00795          END-IF                                                  
                                                                        
           END-EVALUATE.                                                
      *                                                                         
      *** The demand read is re-defined to display in correct FCS format        
           IF WS-CODE-USAGE-TYPE = 'J' OR 'E'                           
              INITIALIZE  WS-PREV-READ-VALUE-HOLD                       
                          WS-PREV-READ-VALUE-FORMAT                     
                          E-FBW71-PREV-READ-VALUE                       
              MOVE RG-LAST-READ-VALUE    TO WS-PREV-READ-VALUE-HOLD     
              MOVE WS-PREV-READ-VALUE-FORMAT                            
                                         TO E-FBW71-PREV-READ-VALUE     
           END-IF                                                       
      *                                                                         
           IF WS-CODE-USAGE-TYPE = 'C'                                  
              AND WS-METER-PRESSURE > 0                                 
              MOVE 0                 TO WS-PCOMP-FCT                    
              COMPUTE WS-PCOMP-FCT ROUNDED =                            
                     (WS-METER-PRESSURE + 14.7) / 14.73                 
                                                                        
              COMPUTE E-FBW71-HI1  ROUNDED =                            
                      E-FBW71-HI1 / WS-PCOMP-FCT                        
              MOVE E-FBW71-HI1       TO E-FBW71-HI2                     
                                                                        
              COMPUTE E-FBW71-LOW1 ROUNDED =                            
                      E-FBW71-LOW1 / WS-PCOMP-FCT                       
              MOVE E-FBW71-LOW1      TO E-FBW71-LOW2                    
           END-IF                                                       
      *                                                                         
           IF E-FBW71-HI1 <= 0                                          
              MOVE 999999999      TO E-FBW71-HI1                        
                                     E-FBW71-HI2                        
           END-IF.                                                      
      *                                                                         
           IF E-FBW71-LOW1 <= 0                                         
              MOVE 0              TO E-FBW71-LOW1                       
                                     E-FBW71-LOW2                       
           END-IF.                                                      
      *                                                                         
       2850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2900-LOAD-OPT-PROB-DATA.                                         
      *==============================================================*          
      *                                                                         
           MOVE 'PROB'              TO E-FBW71-TEXT-PROMPT              
           SET E-FBW71-GROUP-MULTIPLE-REG  TO TRUE                      
           SET E-FBW71-READ-METHOD-OPTICAL TO TRUE                      
      *                                                                         
           MOVE 0                   TO E-FBW71-NO-READ-DECIMALS         
                                       E-FBW71-NO-READ-DIALS            
                                       E-FBW71-PREV-READ-VALUE          
           MOVE 1                   TO E-FBW71-CONSTANT                 
           MOVE SPACES              TO E-FBW71-INDEX-VALUE-CD           
                                       E-FBW71-CNSMPTN-READ-FL          
      *                                                                         
           MOVE MN-CODE-UTIL-TYPE      TO T1-CODE-UTIL-TYPE             
           MOVE MN-DIGTL-MTR-TYPE      TO T1-DIGTL-MTR-TYPE             
           PERFORM 7623-SELECT-DIGTL-MTR-TYPE  THRU 7623-EXIT           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 5318-CREATE-DTL-MTR-TYP-WQ                        
                                                 THRU 5318-EXIT         
           END-IF                                                       
      *                                                                         
           MOVE SPACES                  TO WS-LG-DEVICE-ID              
                                           E-FBW71-TOU-IDR-DEVICE-ID.   
           EVALUATE T1-DIGTL-MTR-NBR-FMT                                
              WHEN '9'                                                  
                 MOVE MN-METER-NO(2:)   TO E-FBW71-TOU-IDR-DEVICE-ID    
              WHEN 'L'                                                  
                 MOVE MN-METER-NO       TO WS-9-DGT-MTR-NO              
                 MOVE WS-LG-MTR-SUFFIX  TO WS-9-DGT-SUFFIX              
                 MOVE WS-LG-DEVICE-ID   TO E-FBW71-TOU-IDR-DEVICE-ID    
              WHEN 'N'                                                  
                 MOVE MN-METER-NO       TO E-FBW71-TOU-IDR-DEVICE-ID    
A05347        WHEN '7'                                                  
A05347           MOVE MN-METER-NO(3:)   TO E-FBW71-TOU-IDR-DEVICE-ID    
              WHEN OTHER                                                
                 MOVE MN-METER-NO(4:)   TO E-FBW71-TOU-IDR-DEVICE-ID    
           END-EVALUATE.                                                
      *                                                                         
           MOVE SPACES                 TO WS-MFG-PLUS-DMT               
           IF T1-OPTICAL-PASSWD-ID > SPACES                             
              MOVE T1-OPTICAL-PASSWD-ID   TO WS-MFG-PLUS-DMT            
           ELSE                                                         
              STRING T1-MANUFACTURER-CD                                 
                     T1-DIGTL-MTR-TYPE  DELIMITED BY ' '                
                INTO WS-MFG-PLUS-DMT                                    
           END-IF.                                                      
           MOVE WS-MFG-PLUS-DMT        TO E-FBW71-PASSWORD-ID           
      *                                                                         
           IF T1-TIM-NAME > SPACES                                      
              MOVE T1-TIM-NAME         TO E-FBW71-TIM-NAME              
           ELSE                                                         
      **** CHECK LATER ABOUT POSSIBLE ALTERNATIVE                               
              MOVE T1-MANUFACTURER-CD     TO E-FBW71-TIM-NAME           
           END-IF                                                       
      *                                                                         
           SET E-FBW71-DAISY-CHAIN-FALSE     TO TRUE                    
           SET E-FBW71-DST-CONFIG-MTR        TO TRUE                    
           SET E-FBW71-DONT-UPD-DST-CALENDAR TO TRUE                    
      *                                                                         
           IF TOU-IDR OR IDR-ONLY                                       
              SET E-FBW71-READ-PARTIAL-LP TO TRUE                       
A00795        MOVE MN-METER-NO            TO PW-METER-NO                
A00795        MOVE MN-MTR-REF-NO          TO PW-MTR-REF-NO              
A00795        MOVE PR-PREMISE-NO          TO UT-PREMISE-NO              
A00795        MOVE UT-CODE-UTIL-TYPE      TO PW-CODE-UTIL-TYPE          
A00795        MOVE UT-IC-NO               TO PW-IC-NO                   
A00795        PERFORM 7700-GET-LAST-LP-READ-DATE THRU 7700-EXIT         
A00795        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
A00795           MOVE PW-LAST-REG-READ-DT    TO WS-LAST-LP-RD-DATE      
A00795           MOVE PW-LAST-REG-READ-TM    TO WS-LAST-RD-TIME         
A00795        ELSE                                                      
A00795           MOVE MN-LAST-REG-READ-DATE  TO WS-LAST-LP-RD-DATE      
A00795           MOVE MN-LAST-REG-READ-TIME  TO WS-LAST-RD-TIME         
A00795        END-IF                                                    
A00795        PERFORM 7720-SUBTRACT15-MINUTES-LP-TM THRU 7720-EXIT      
A00795        MOVE WS-LAST-RD-TIME        TO WS-LAST-LP-RD-TIME         
              MOVE 'T'                    TO WS-LAST-LP-DT-DELIM        
              MOVE ':'                    TO WS-TIME-SEP1               
                                             WS-TIME-SEP2               
           ELSE                                                         
              SET E-FBW71-DONT-READ-LP    TO TRUE                       
              MOVE SPACES                 TO WS-LAST-LP-RD-DATETIME     
           END-IF.                                                      
           MOVE WS-LAST-LP-RD-DATETIME TO E-FBW71-LAST-LP-RD-DATETIME   
      *                                                                         
           SET E-FBW71-VISUAL-RD-CAP    TO TRUE                         
      *                                                                         
           IF TOU-IDR OR TOU-ONLY                                       
              SET E-FBW71-READ-TOU-REG TO TRUE                          
           ELSE                                                         
              SET  E-FBW71-DONT-READ-TOU-REG TO TRUE                    
           END-IF.                                                      
      *                                                                         
           SET E-FBW71-DONT-RESET-DEMAND  TO TRUE.                      
           SET E-FBW71-STATUS-CHK-TRUE    TO TRUE.                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3000-PROCESS-END-JOB.                                            
      *================================================================*        
      *                                                                         
           PERFORM 3100-PROCESS-END-REC THRU 3100-EXIT.                 
      *                                                                         
           PERFORM 3200-WRITE-END-CONTROLS       THRU 3200-EXIT.        
      *                                                                         
      ***  UPGRADE JOB-COMPLETE FIELD TO INDICATE SUCCESSFUL COMPLETION         
      *                                                                         
           MOVE SPACES                 TO WS-RST-JOB-COMPLETE.          
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
               MOVE WS-B               TO WS-RST-JOB-STATUS             
           ELSE                                                         
               MOVE WS-A               TO WS-RST-JOB-STATUS             
           END-IF.                                                      
      *                                                                         
           IF RESTART-REQUIRED                                          
              DISPLAY 'UPGRADE JOB COMPLETION'                          
              MOVE ZEROS               TO WS-RST-ACCOUNT-NO             
              PERFORM 8899-WRITE-RSDDR          THRU 8899-EXIT          
           END-IF.                                                      
      *                                                                         
           IF WS-RESTART-REQ = WS-Y                                     
              PERFORM 8893-RESET-RESTART-REQ-PARM   THRU 8893-EXIT      
           END-IF.                                                      
           PERFORM 9001-DISPLAY               THRU 9001-EXIT.           
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       3100-PROCESS-END-REC.                                            
      *===============================================================*         
      *                                                                         
      *** ISSUE LAST CHECK POINT BEFORE END RECORD COUNT VALIDATION             
           IF RESTART-REQUIRED                                          
               PERFORM 8898-ISSUE-CHKP           THRU 8898-EXIT         
           END-IF.                                                      
      *                                                                         
      *** VALIDATE PROPER END OF DB09                                           
           IF NO-MORE-DATA                                              
              DISPLAY '******************************************'      
              DISPLAY '***      PCSBW171 PROCESSING ERROR     ***'      
              DISPLAY '*** DB09 LAST RECORD IS NOT CNTL RECORD***'      
              DISPLAY '***       PROCESSING TERMINATED        ***'      
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
           IF CNTL-END-REC-FOUND                                        
              IF WS-FCSDB09-REC-CNTR = E-FDB09-RECORD-COUNT-EREC        
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '******************************************'   
                 DISPLAY '**        PCSBW171 PROCESSING ERROR     **'   
                 DISPLAY '**ACTUAL REC COUNT NOT MATCHING CNTL REC**'   
                 DISPLAY '**CONTROL REC COUNT = '                       
                                        E-FDB09-RECORD-COUNT-EREC       
                 DISPLAY '**ACTUAL REC COUNT  = ' WS-FCSDB09-REC-CNTR   
                 DISPLAY '**          PROCESSING TERMINATED       **'   
                 DISPLAY '******************************************'   
                 PERFORM 9900-ABEND                THRU 9900-EXIT       
              END-IF                                                    
              PERFORM 7000-READ-FCSDB09     THRU 7000-EXIT              
           END-IF.                                                      
      *                                                                         
           IF NO-MORE-DATA                                              
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '***      PCSBW171 PROCESSING ERROR     ***'      
              DISPLAY '***  SOME DATA FOUND AFTER CNTL RECORD ***'      
              DISPLAY '***       PROCESSING TERMINATED        ***'      
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3200-WRITE-END-CONTROLS.                                         
      *================================================================*        
      *                                                                         
           INITIALIZE       FIOBW71                                     
           MOVE ALL '9'                TO E-FBW71-SORT-RECORD.          
           PERFORM 8400-WRITE-FCSBW71            THRU 8400-EXIT.        
      *                                                                         
           MOVE SPACES                 TO E-FCA55.                      
           MOVE HIGH-VALUES            TO E-FCA55-CO-KEY-EREC.          
           MOVE WS-PART-NO             TO E-FCA55-CO-DB-PART-EREC.      
           MOVE WS-RST-CA55-COM-CNTR   TO E-FCA55-CO-REC-COUNT-EREC.    
           MOVE WS-FCA55-COMPANY-NO    TO E-FCA55-CO-NO-KEY-EREC.       
           PERFORM 8420-WRITE-FCSCA55            THRU 8420-EXIT.        
      *                                                                         
           MOVE SPACES                 TO E-FCA55.                      
           MOVE HIGH-VALUES            TO E-FCA55-KEY-EREC.             
           MOVE WS-PART-NO             TO E-FCA55-DB-PART-EREC.         
           MOVE WS-RST-CA55-TOT-CNTR   TO E-FCA55-RECORD-COUNT-EREC.    
           PERFORM 8420-WRITE-FCSCA55            THRU 8420-EXIT.        
      *                                                                         
           MOVE SPACES                 TO E-FRP87.                      
           MOVE HIGH-VALUES            TO E-FRP87-CO-KEY-EREC.          
           MOVE WS-PART-NO             TO E-FRP87-CO-DB-PART-EREC.      
           MOVE WS-RST-RP87-COM-CNTR  TO E-FRP87-CO-REC-COUNT-EREC.     
           MOVE WS-FCA87-COMPANY-NO    TO E-FRP87-CO-NO-KEY-EREC.       
           PERFORM 8430-WRITE-FCSRP87            THRU 8430-EXIT.        
      *                                                                         
           MOVE SPACES                 TO E-FRP87.                      
           MOVE HIGH-VALUES            TO E-FRP87-KEY-EREC.             
           MOVE WS-PART-NO             TO E-FRP87-DB-PART-EREC.         
           MOVE WS-RST-RP87-TOT-CNTR   TO E-FRP87-RECORD-COUNT-EREC.    
           PERFORM 8430-WRITE-FCSRP87            THRU 8430-EXIT.        
      *                                                                         
           IF WS-RST-RP123-COM-CNTR > ZEROS                             
              MOVE SPACES              TO E-FIORP123                    
              MOVE HIGH-VALUES         TO E-FRP123-CO-KEY-EREC          
              MOVE WS-PART-NO          TO E-FRP123-CO-DB-PART-EREC      
              MOVE WS-RST-RP123-COM-CNTR                                
                                       TO E-FRP123-CO-REC-COUNT-EREC    
              MOVE WS-FCA123-COMPANY-NO                                 
                                       TO E-FRP123-CO-NO-KEY-EREC       
              PERFORM 8440-WRITE-FCSRP123           THRU 8440-EXIT      
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                 TO E-FIORP123.                   
           MOVE HIGH-VALUES            TO E-FRP123-KEY-EREC.            
           MOVE WS-PART-NO             TO E-FRP123-DB-PART-EREC.        
           MOVE WS-RST-RP123-TOT-CNTR  TO E-FRP123-RECORD-COUNT-EREC.   
      *                                                                         
           PERFORM 8440-WRITE-FCSRP123           THRU 8440-EXIT.        
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      ** 4000-MAIL-NAME-ADDRESS                                                 
      *================================================================*        
      **** INCLUDE COPY BOOK TO RETRIEVE NAMES AND ADDRESSES     **             
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       5010-CREATE-WORKQ.                                               
      *================================================================*        
      *                                                                         
ACT069     MOVE ZEROS                  TO WS-77-SERV-ORDER-NO.          
ACT069     MOVE 15                     TO WS-77-CATEGORY-ID.            
ACT069     MOVE AT-ACCOUNT-NO          TO WS-77-ACCOUNT-NO.             
ACT069     MOVE PR-PREMISE-NO          TO WS-77-PREMISE-NO.             
ACT069     MOVE AT-CUSTOMER-NO         TO WS-77-CUSTOMER-NO.            
ACT069     MOVE SPACES                 TO WS-77-RESP-AREA-ID.           
ACT069     MOVE AT-LOCAL-OFFICE        TO WS-77-LOCAL-OFFICE.           
ACT069     MOVE '1'                    TO WS-77-ROUTE-CATEGORY.         
ACT069     MOVE 'N'                    TO WS-77-PRIORITY.               
ACT069     MOVE WS-CUR-DATE-BREAKDOWN  TO WS-77-DATE-REQUIRED.          
ACT069     MOVE WS-CURRENT-DATE        TO WS-INPUT-DATE-PT.             
ACT069     MOVE WS-INPUT-TS            TO WS-77-DATE-CREATED.           
ACT069     MOVE ZEROS                  TO WS-77-FREE-FORM-LEN.          
ACT069     MOVE LOW-VALUES             TO WS-77-FREE-FORM-TXT.          
ACT069     MOVE WS-PGRMNAME            TO WS-77-CREATED-BY.             
      *                                                                         
           PERFORM 8895-INSERT-WORK-QUEUE        THRU 8895-EXIT.        
      *                                                                         
       5010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       5020-CREATE-WORKQ.                                               
      *================================================================*        
      *                                                                         
ACT069     MOVE AT-ACCOUNT-NO          TO WS-77-ACCOUNT-NO              
ACT069     MOVE PR-PREMISE-NO          TO WS-77-PREMISE-NO              
ACT069     MOVE AT-LOCAL-OFFICE        TO WS-77-LOCAL-OFFICE            
ACT069     MOVE AT-CUSTOMER-NO         TO WS-77-CUSTOMER-NO             
      *                                                                         
           IF  UT-CODE-UTIL-TYPE  = 'G'                                 
ACT069        MOVE WS-CATEGORY-ID-232  TO WS-77-CATEGORY-ID             
           ELSE                                                         
ACT069        MOVE WS-CATEGORY-ID-143  TO WS-77-CATEGORY-ID             
           END-IF.                                                      
ACT069     MOVE WS-ROUTING-CATEGORY1   TO WS-77-ROUTE-CATEGORY          
      *                                                                         
ACT069     MOVE 'N'                    TO WS-77-PRIORITY.               
ACT069     MOVE WS-CUR-DATE-BREAKDOWN  TO WS-77-DATE-REQUIRED.          
ACT069     MOVE WS-CURRENT-DATE        TO WS-INPUT-DATE-PT.             
ACT069     MOVE WS-INPUT-TS            TO WS-77-DATE-CREATED.           
ACT069     MOVE LOW-VALUES             TO WS-77-FREE-FORM-TXT.          
ACT069     MOVE ZEROES                 TO WS-77-FREE-FORM-LEN.          
ACT069     MOVE WS-PGRMNAME            TO WS-77-CREATED-BY.             
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
      *                                                                         
       5020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       5030-LOCATE-MTR-RD-SOURCE.                                       
      *==============================================================*          
      *                                                                         
           SET WS-RD-SRC-NOT-MATCHED TO TRUE.                           
           SET NOT-SEND-MTR-FOR-READ TO TRUE.                           
      *                                                                         
           PERFORM VARYING WS-RD-SRC-SUB FROM 1 BY 1                    
             UNTIL WS-RD-SRC-SUB > WS-RD-SRC-COUNT                      
                OR WS-RD-SRC-MATCHED                                    
      *                                                                         
                IF MN-MTR-READ-SOURCE-CD                                
                          = WS-TAB-RD-SOURCE-CD (WS-RD-SRC-SUB)         
                   SET WS-RD-SRC-MATCHED TO TRUE                        
                   MOVE WS-TAB-SEND-READ-REQ-FL (WS-RD-SRC-SUB)         
                        TO WS-SEND-READ-FL                              
                END-IF                                                  
      *                                                                         
           END-PERFORM.                                                 
      *                                                                         
       5030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       5100-FORMAT-FRP123.                                              
      *================================================================*        
      *                                                                         
           IF AT-COMPANY-NO  NOT = WS-FCA123-COMPANY-NO                 
              AND CA123-NOT-FIRST-TIME                                  
              AND WS-RST-RP123-COM-CNTR > 0                             
              MOVE SPACES                 TO E-FIORP123                 
              MOVE HIGH-VALUES            TO E-FRP123-KEY-EREC          
              MOVE WS-PART-NO             TO E-FRP123-DB-PART-EREC      
              MOVE WS-RST-RP123-COM-CNTR  TO E-FRP123-CO-REC-COUNT-EREC 
              MOVE WS-FCA123-COMPANY-NO   TO E-FRP123-CO-NO-KEY-EREC    
              PERFORM 8440-WRITE-FCSRP123           THRU 8440-EXIT      
              MOVE ZEROS               TO  WS-RST-RP123-COM-CNTR        
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                 TO E-FRP123-DATA-REC.            
           MOVE AT-COMPANY-NO          TO E-FRP123-COMPANY-NO,          
                                          WS-FCA123-COMPANY-NO.         
           MOVE AT-LOCAL-OFFICE        TO E-FRP123-LOCAL-OFFICE.        
           MOVE UT-READ-ROUTE        TO E-FRP123-ROUTE-NO.              
           MOVE AT-ACCOUNT-NO        TO E-FRP123-ACCOUNT-NO.            
      *                                                                         
           EVALUATE MN-CODE-USAGE-TYPE                                  
              WHEN 'B'                                                  
                 MOVE 'KWH'     TO E-FRP123-REG-MEASURE-CD              
              WHEN 'C'                                                  
                 MOVE 'GAS'     TO E-FRP123-REG-MEASURE-CD              
              WHEN 'J'                                                  
                 MOVE 'KW'      TO E-FRP123-REG-MEASURE-CD              
              WHEN 'E'                                                  
                 MOVE 'KVA'     TO E-FRP123-REG-MEASURE-CD              
              WHEN OTHER                                                
                 MOVE '---'     TO E-FRP123-REG-MEASURE-CD              
           END-EVALUATE.                                                
      *                                                                         
           MOVE WS-PR-STREET           TO E-FRP123-SERVICE-ADDR.        
           MOVE UT-CODE-UTIL-TYPE      TO E-FRP123-METER-TYPE.          
           MOVE MN-METER-NO            TO E-FRP123-METER-NO.            
           MOVE WS-HLD-NO-RD-REASON    TO E-FRP123-NO-READ-RSN.         
           MOVE UT-READ-CYCLE          TO E-FRP123-READ-CYCLE.          
           MOVE MN-NO-CONSEC-ESTIMATE  TO E-FRP123-NO-CONSEC-ESTIMATES. 
           MOVE UT-IC-NO               TO E-FRP123-IC-NO.               
           MOVE SPACES                 TO E-FRP123-LAST-READ-DATE.      
      *                                                                         
           PERFORM 8440-WRITE-FCSRP123           THRU 8440-EXIT.        
      *                                                                         
           COMPUTE WS-RST-RP123-TOT-CNTR = WS-RST-RP123-TOT-CNTR + 1    
           COMPUTE WS-RST-RP123-COM-CNTR = WS-RST-RP123-COM-CNTR + 1    
           MOVE WS-N                   TO WS-CA123-FIRST-TIME.          
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       5200-FORMAT-FCA55.                                               
      *================================================================*        
      *                                                                         
           IF AT-COMPANY-NO  NOT EQUAL WS-FCA55-COMPANY-NO              
              AND CA55-NOT-FIRST-TIME                                   
              AND WS-RST-CA55-COM-CNTR > 0                              
              MOVE SPACES                 TO E-FCA55                    
              MOVE HIGH-VALUES            TO E-FCA55-CO-KEY-EREC        
              MOVE WS-PART-NO             TO E-FCA55-CO-DB-PART-EREC    
              MOVE WS-RST-CA55-COM-CNTR   TO E-FCA55-CO-REC-COUNT-EREC  
              MOVE WS-FCA55-COMPANY-NO    TO E-FCA55-CO-NO-KEY-EREC     
              PERFORM 8420-WRITE-FCSCA55            THRU 8420-EXIT      
              MOVE ZEROS               TO  WS-RST-CA55-COM-CNTR         
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                 TO E-FCA55-DATA-REC.             
           MOVE AT-COMPANY-NO          TO E-FCA55-COMPANY-NO,           
                                          WS-FCA55-COMPANY-NO.          
           MOVE AT-LOCAL-OFFICE        TO E-FCA55-LOCAL-OFFICE.         
           MOVE UT-READ-CYCLE          TO E-FCA55-READ-CYCLE.           
           MOVE UT-READ-ROUTE          TO E-FCA55-ROUTE-NUMBER.         
           MOVE AT-ACCOUNT-NO          TO E-FCA55-ACCOUNT-NUMBER.       
           MOVE MN-METER-NO            TO E-FCA55-METER-NUMBER.         
           MOVE WS-PR-ADDR-OVERFLOW    TO E-FCA55-ADDRESS-OVERFLOW.     
           MOVE WS-PR-STREET           TO E-FCA55-SERVICE-ADDRESS.      
      *                                                                         
           PERFORM 8420-WRITE-FCSCA55            THRU 8420-EXIT.        
           COMPUTE WS-RST-CA55-TOT-CNTR = WS-RST-CA55-TOT-CNTR + 1      
           COMPUTE WS-RST-CA55-COM-CNTR = WS-RST-CA55-COM-CNTR + 1      
           MOVE WS-N                   TO WS-CA55-FIRST-TIME.           
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       5300-FORMAT-FRP87.                                               
      *================================================================*        
      *                                                                         
           IF AT-COMPANY-NO  NOT = WS-FCA87-COMPANY-NO                  
              AND CA87-NOT-FIRST-TIME                                   
              AND WS-RST-RP87-COM-CNTR > 0                              
              MOVE SPACES                 TO E-FRP87                    
              MOVE HIGH-VALUES            TO E-FRP87-CO-KEY-EREC        
              MOVE WS-PART-NO             TO E-FRP87-CO-DB-PART-EREC    
              MOVE WS-RST-RP87-COM-CNTR   TO E-FRP87-CO-REC-COUNT-EREC  
              MOVE WS-FCA87-COMPANY-NO    TO E-FRP87-CO-NO-KEY-EREC     
      *                                                                         
              PERFORM 8430-WRITE-FCSRP87            THRU 8430-EXIT      
              MOVE ZEROS               TO WS-RST-RP87-COM-CNTR          
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                 TO E-FRP87-DATA-REC.             
           MOVE AT-COMPANY-NO          TO E-FRP87-COMPANY-NO,           
                                          WS-FCA87-COMPANY-NO.          
           MOVE AT-LOCAL-OFFICE        TO E-FRP87-LOCAL-OFFICE.         
           MOVE UT-READ-CYCLE          TO E-FRP87-READ-CYCLE            
           MOVE UT-READ-ROUTE          TO E-FRP87-ROUTE.                
           MOVE MN-LAST-REG-READ-DATE  TO E-FRP87-LAST-READ-DATE.       
           MOVE RW-DATE-MTR-RD-XTRCT   TO E-FRP87-METER-EXTRACT-DATE.   
           MOVE BN-DATE-EXTRACT        TO E-FRP87-CYCLE-CLOSE-DATE.     
           MOVE WS-NUMBER-OF-METERS    TO E-FRP87-NUMBER-OF-METERS.     
      *                                                                         
           PERFORM 8430-WRITE-FCSRP87            THRU 8430-EXIT.        
      *                                                                         
           COMPUTE WS-RST-RP87-TOT-CNTR = WS-RST-RP87-TOT-CNTR + 1      
           COMPUTE WS-RST-RP87-COM-CNTR = WS-RST-RP87-COM-CNTR + 1      
           MOVE ZERO                   TO WS-NUMBER-OF-METERS.          
      *                                                                         
           MOVE WS-N                   TO WS-CA87-FIRST-TIME.           
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       5318-CREATE-DTL-MTR-TYP-WQ.                                      
      *================================================================*        
      *                                                                         
ACT069     INITIALIZE CWS00077-FIELDS.                                  
           MOVE MN-METER-NO            TO WS-MN-MTR-NO-HOLD.            
ACT069     MOVE ZEROS                  TO WS-77-SERV-ORDER-NO.          
ACT069     MOVE 142                    TO WS-77-CATEGORY-ID             
ACT069     MOVE AT-ACCOUNT-NO          TO WS-77-ACCOUNT-NO.             
ACT069     MOVE PR-PREMISE-NO          TO WS-77-PREMISE-NO.             
ACT069     MOVE AT-CUSTOMER-NO         TO WS-77-CUSTOMER-NO.            
ACT069     MOVE SPACES                 TO WS-77-RESP-AREA-ID.           
ACT069     MOVE AT-LOCAL-OFFICE        TO WS-77-LOCAL-OFFICE.           
ACT069     MOVE '4'                    TO WS-77-ROUTE-CATEGORY.         
ACT069     MOVE 'N'                    TO WS-77-PRIORITY.               
ACT069     MOVE WS-CUR-DATE-BREAKDOWN  TO WS-77-DATE-REQUIRED.          
ACT069     MOVE WS-CURRENT-DATE        TO WS-INPUT-DATE-PT.             
ACT069     MOVE WS-INPUT-TS            TO WS-77-DATE-CREATED.           
ACT069     MOVE WS-NO-DIGTL-MTR-MSG    TO WS-77-COMMENTS-TEXT.          
ACT069     MOVE WS-NO-DIGTL-MTR-LEN    TO WS-77-COMMENTS-LEN.           
ACT069     MOVE ZEROS                  TO WS-77-FREE-FORM-LEN.          
ACT069     MOVE LOW-VALUES             TO WS-77-FREE-FORM-TXT.          
ACT069     MOVE WS-PGRMNAME            TO WS-77-CREATED-BY.             
      *                                                                         
           PERFORM 8895-INSERT-WORK-QUEUE        THRU 8895-EXIT.        
      *                                                                         
       5318-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      *==============================================================*          
      *** 6240-GET-FCA00-COMMON-DATE                                 *          
      *==============================================================*          
      *** COPYBOOK TO GET COMMON DATE FROM JOB PARM                             
       COPY CPD00040.                                                           
      *                                                                         
      *==============================================================*          
      *** 6235-GET-FJC01-RESTART-REQ                                 *          
      *==============================================================*          
      *** COPYBOOK TO GET RESTART REQUEST FROM JOB PARM                         
       COPY CPD00035.                                                           
      *                                                                         
      *==============================================================*          
      *** 6251-GET-FJC01-DATE                                        *          
      *==============================================================*          
      *** COPYBOOK TO GET OVERRIDE DATE FROM JOB PARM                           
       COPY CPD00037.                                                           
      *                                                                         
      *==============================================================*          
      *** 6253-GET-FJC01-CHKP-LIMIT                                  *          
      *==============================================================*          
      *** COPYBOOK TO GET CHECKPOINT LIMITS FROM JOB PARM                       
       COPY CPD00034.                                                           
      *                                                                         
      *==============================================================*          
      *** 6254-GET-FJC01-STOP-KEY                                    *          
      *==============================================================*          
      *** COPYBOOK TO GET STOP ACCOUNT FROM JOB PARM                            
       COPY CPD00036.                                                           
      *                                                                         
A00795*==============================================================*          
A00795**   6351-CPD72-HI-LO-MAIN                                     *          
A00795*==============================================================*          
A00795*** COPYBOOK TO GET HIGH LOW LIMITS FOR REG USAGE                         
A00795     EXEC SQL                                                     02000000
A00795         INCLUDE CPDCA072                                                 
A00795     END-EXEC.                                                            
A00795*                                                                         
A00795*================================================================*05050000
A00795 6399-CHECK-HI-LO-ERROR.                                          
A00795*================================================================*05050000
A00795*                                                                 05070000
A00795     IF CWS72-ERROR                                               
A00795         DISPLAY ' '                                              
A00795         DISPLAY '***************************************'        
A00795         DISPLAY '**     PCSBW171 PROCESSING ERROR     **'        
A00795         DISPLAY ' in ' CWS72-ERROR-PARAGRAPH-NAME                
A00795         DISPLAY 'CWS72-ERROR-MESSAGE:'  CWS72-ERROR-MESSAGE      
A00795         DISPLAY 'CWS72-ERROR-SQLCODE:'  CWS72-ERROR-SQLCODE      
A00795         DISPLAY 'CWS72-ERROR-FUNCTION:' CWS72-ERROR-FUNCTION     
A00795         DISPLAY 'CWS72-ERROR-TABLE1:'   CWS72-ERROR-TABLE1       
A00795         DISPLAY 'CWS72-ERROR-TABLE2:'   CWS72-ERROR-TABLE2       
A00795         DISPLAY  CWS72-ERROR-TAB-COLUMN-1 '='                    
A00795                          CWS72-ERROR-HOSTVAR-1                   
A00795         DISPLAY  CWS72-ERROR-TAB-COLUMN-2 '='                    
A00795                          CWS72-ERROR-HOSTVAR-2                   
A00795         DISPLAY  CWS72-ERROR-TAB-COLUMN-3 '='                    
A00795                          CWS72-ERROR-HOSTVAR-3                   
A00795         DISPLAY  CWS72-ERROR-TAB-COLUMN-4 '='                    
A00795                          CWS72-ERROR-HOSTVAR-4                   
A00795         PERFORM 9900-ABEND THRU 9900-EXIT                        
A00795         DISPLAY '***************************************'        
A00795     END-IF.                                                      
A00795     IF CWS72-WARNING                                             
A00795        DISPLAY ' '                                               
A00795        DISPLAY '***************************************'         
A00795        DISPLAY '**     PCSBW171 PROCESSING WARNING   **'         
A00795        DISPLAY ' IN ' CWS72-ERROR-PARAGRAPH-NAME                 
A00795        DISPLAY 'CWS72-ERROR-MESSAGE:'  CWS72-ERROR-MESSAGE       
A00795        DISPLAY 'PROCESSING CONTINUE ******'                      
A00795        DISPLAY '***************************************'         
A00795     END-IF.                                                      
A00795*                                                                 05070000
A00795 6399-EXIT.                                                       
A00795     EXIT.                                                        
A00795*                                                                 05330000
      *==============================================================*          
       7000-READ-FCSDB09.                                               
      *==============================================================*          
      *** READS THE DAILY METER READ EXTRACTION FILE                            
      *                                                                         
           READ FCSDB09-FILE                                            
               AT END SET NO-MORE-DATA    TO TRUE.                      
      *                                                                         
           EVALUATE TRUE                                                
              WHEN E-FDB09-KEY-BREC = LOW-VALUES                        
                 SET CNTL-BEGIN-REC-FOUND  TO TRUE                      
              WHEN E-FDB09-KEY-EREC = HIGH-VALUES                       
                 SET CNTL-END-REC-FOUND TO TRUE                         
              WHEN FDB09-SUCCESSFUL                                     
                 SET DATA-RECORD-FOUND TO TRUE                          
                 COMPUTE WS-FCSDB09-REC-CNTR = WS-FCSDB09-REC-CNTR + 1  
              WHEN NO-MORE-DATA                                         
                 CONTINUE                                               
              WHEN OTHER                                                
                 DISPLAY '****************************************'     
                 DISPLAY '** ERROR WHILE READING FCSDB09 FILE   **'     
                 DISPLAY '**   ERROR ON 7000-READ-FCSDB09       **'     
                 DISPLAY '** STATUS IS ' WS-FDB09-STATUS       '**'     
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND                THRU 9900-EXIT       
           END-EVALUATE.                                                
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7005-SELECT-READ-CYCLE.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT READ_CYCLE                                        
               INTO :RW-READ-CYCLE                                      
               FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                       
               WHERE UT_READ_CYCLE = :UT-READ-CYCLE                     
                 AND DATE_MTR_RD_XTRCT = IIF(TRY_CONVERT(DATE, 
                                                  :RW-DATE-MTR-RD-XTRCT
              ) IS NULL OR (PATINDEX('%.%', :RW-DATE-MTR-RD-XTRCT
              ) <> 0) OR (LEN(:RW-DATE-MTR-RD-XTRCT
              ) <> 10), CIS.CHAR2DATE(:RW-DATE-MTR-RD-XTRCT
              ), CONVERT(DATE, :RW-DATE-MTR-RD-XTRCT) )          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT READ_CYCLE                                                
MFA-TR*        INTO :RW-READ-CYCLE                                              
MFA-TR*        FROM CSS_READ_WINDOW                                             
MFA-TR*        WHERE UT_READ_CYCLE = :UT-READ-CYCLE                             
MFA-TR*          AND DATE_MTR_RD_XTRCT = :RW-DATE-MTR-RD-XTRCT                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '** ERROR ON 7005-SELECT-READ-CYCLE       **'    
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '**       PROCESSING TERMINATED           **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7010-SELECT-ACCOUNT.                                             
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
             SELECT ACCOUNT_NO                                          
                   ,CUSTOMER_NO                                         
                   ,CODE_ACCT_STAT                                      
                   ,ACCOUNT_TYPE_CODE                                   
                   ,LOCAL_OFFICE                                        
                   ,PREMISE_NO                                          
                   ,COMPANY_NO                                          
                   ,ADDRESS_ID                                          
                   ,ADDRESS_FORMAT                                      
A00795             ,REV_MTH_LST_NRML                                    
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-ACCOUNT-TYPE-CODE                               
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-PREMISE-NO                                      
                   ,:AT-COMPANY-NO                                      
                   ,:AT-ADDRESS-ID                                      
                   ,:AT-ADDRESS-FORMAT                                  
A00795             ,:AT-REV-MTH-LST-NRML                                
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT ACCOUNT_NO                                                  
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*            ,CODE_ACCT_STAT                                              
MFA-TR*            ,ACCOUNT_TYPE_CODE                                           
MFA-TR*            ,LOCAL_OFFICE                                                
MFA-TR*            ,PREMISE_NO                                                  
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,ADDRESS_ID                                                  
MFA-TR*            ,ADDRESS_FORMAT                                              
MFA-TR*            ,REV_MTH_LST_NRML                                            
MFA-TR*        INTO :AT-ACCOUNT-NO                                              
MFA-TR*            ,:AT-CUSTOMER-NO                                             
MFA-TR*            ,:AT-CODE-ACCT-STAT                                          
MFA-TR*            ,:AT-ACCOUNT-TYPE-CODE                                       
MFA-TR*            ,:AT-LOCAL-OFFICE                                            
MFA-TR*            ,:AT-PREMISE-NO                                              
MFA-TR*            ,:AT-COMPANY-NO                                              
MFA-TR*            ,:AT-ADDRESS-ID                                              
MFA-TR*            ,:AT-ADDRESS-FORMAT                                          
MFA-TR*            ,:AT-REV-MTH-LST-NRML                                        
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '*****************************************'      
               DISPLAY '**  ERROR ON 7010-SELECT-ACCOUNT       **'      
               DISPLAY '**  ACCOUNT_NO    = ' AT-ACCOUNT-NO             
               DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE        
               DISPLAY '**      PROCESSING TERMINATED          **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
               DISPLAY '*****************************************'      
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7020-SELECT-PREMISE.                                             
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
             SELECT SPCL_READ_INSTR                                     
ACT199             ,DATE_SPCL_MSG_ENDS                                  
                   ,PERSONAL_CNTCT_CD                                   
                   ,ADDRESS_ID                                          
                   ,ADDRESS_FORMAT                                      
A#5470             ,PREM_REF_LATITUDE                                   
A#5470             ,PREM_REF_LONGITUDE                                  
               INTO :PR-SPCL-READ-INSTR                                 
ACT199             ,:PR-DATE-SPCL-MSG-ENDS :WS-DATE-MSG-NULL            
                   ,:PR-PERSONAL-CNTCT-CD                               
                   ,:PR-ADDRESS-ID                                      
                   ,:PR-ADDRESS-FORMAT                                  
A#5470             ,:PR-PREM-REF-LATITUDE                               
A#5470             ,:PR-PREM-REF-LONGITUDE                              
               FROM CSS_PREMISE WITH(READUNCOMMITTED)                           
                    WHERE PREMISE_NO = :PR-PREMISE-NO                   
                                                                 
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SPCL_READ_INSTR                                             
MFA-TR*            ,DATE_SPCL_MSG_ENDS                                          
MFA-TR*            ,PERSONAL_CNTCT_CD                                           
MFA-TR*            ,ADDRESS_ID                                                  
MFA-TR*            ,ADDRESS_FORMAT                                              
MFA-TR*            ,PREM_REF_LATITUDE                                           
MFA-TR*            ,PREM_REF_LONGITUDE                                          
MFA-TR*        INTO :PR-SPCL-READ-INSTR                                         
MFA-TR*            ,:PR-DATE-SPCL-MSG-ENDS :WS-DATE-MSG-NULL                    
MFA-TR*            ,:PR-PERSONAL-CNTCT-CD                                       
MFA-TR*            ,:PR-ADDRESS-ID                                              
MFA-TR*            ,:PR-ADDRESS-FORMAT                                          
MFA-TR*            ,:PR-PREM-REF-LATITUDE                                       
MFA-TR*            ,:PR-PREM-REF-LONGITUDE                                      
MFA-TR*        FROM CSS_PREMISE                                                 
MFA-TR*             WHERE PREMISE_NO = :PR-PREMISE-NO                           
MFA-TR*             WITH UR                                                     
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '*****************************************'      
               DISPLAY '** ERROR ON 7020-SELECT-PREMISE        **'      
               DISPLAY '** PREMISE NO  = ' PR-PREMISE-NO                
               DISPLAY '** ACCOUNT NO  = ' AT-ACCOUNT-NO                
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '**    PROCESSING TERMINATED            **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
               DISPLAY '*****************************************'      
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7025-SUBTRACT-XX-DAYS.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -:WS-HILO-SUBTRACT-DAYS, 
              IIF(TRY_CONVERT(DATE, :WS-HILO-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HILO-WORK-DATE
              ) <> 0) OR (LEN(:WS-HILO-WORK-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-HILO-WORK-DATE
              ), CONVERT(DATE, :WS-HILO-WORK-DATE) ) )
            INTO
              :WS-HILO-WORK-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-HILO-WORK-DATE =                                          
MFA-TR*           DATE(:WS-HILO-WORK-DATE)                                      
MFA-TR*             - :WS-HILO-SUBTRACT-DAYS DAYS                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '** ERROR ON 7025-SUBTRACT-XX-DAYS        **'    
               DISPLAY '** WS-HILO-WORK-DATE = ' WS-HILO-WORK-DATE      
               DISPLAY '** WS-HILO-SUBTRACT-DAYS = '                    
                                             WS-HILO-SUBTRACT-DAYS      
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '**       PROCESSING TERMINATED           **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7030-SELECT-CYCLE-OPEN-DATE.                                     
      *================================================================*        
      **** GET BILL CYCLE OPEN DATE FOR FCS CRITICAL DATE                       
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) A.DATE_EXTRACT                                    
               INTO :BN-DATE-EXTRACT                                    
               FROM CSS_BILL_WINDOW A
                           WITH(READUNCOMMITTED), CSS_READ_WINDOW B
                           WITH(READUNCOMMITTED)                
               WHERE A.BILL_CYCLE = B.READ_CYCLE                        
                 AND A.BILL_CYCLE = :RW-READ-CYCLE                      
                 AND A.REVENUE_MONTH = B.REVENUE_MONTH                  
                 AND A.REVENUE_MONTH = :RW-REVENUE-MONTH                
                 AND B.DATE_MTR_RD_XTRCT = IIF(TRY_CONVERT(DATE, 
                                                  :RW-DATE-MTR-RD-XTRCT
              ) IS NULL OR (PATINDEX('%.%', :RW-DATE-MTR-RD-XTRCT
              ) <> 0) OR (LEN(:RW-DATE-MTR-RD-XTRCT
              ) <> 10), CIS.CHAR2DATE(:RW-DATE-MTR-RD-XTRCT
              ), CONVERT(DATE, :RW-DATE-MTR-RD-XTRCT) )        
               ORDER BY A.DATE_EXTRACT                                  
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT A.DATE_EXTRACT                                            
MFA-TR*        INTO :BN-DATE-EXTRACT                                            
MFA-TR*        FROM CSS_BILL_WINDOW A, CSS_READ_WINDOW B                        
MFA-TR*        WHERE A.BILL_CYCLE = B.READ_CYCLE                                
MFA-TR*          AND A.BILL_CYCLE = :RW-READ-CYCLE                              
MFA-TR*          AND A.REVENUE_MONTH = B.REVENUE_MONTH                          
MFA-TR*          AND A.REVENUE_MONTH = :RW-REVENUE-MONTH                        
MFA-TR*          AND B.DATE_MTR_RD_XTRCT = :RW-DATE-MTR-RD-XTRCT                
MFA-TR*        ORDER BY A.DATE_EXTRACT                                          
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '** ERROR ON 7030-SELECT-CYCLE-OPEN-DATE **'     
               DISPLAY '** BILL_CYCLE =' RW-READ-CYCLE                  
               DISPLAY '** REVENUE_MONTH =' RW-REVENUE-MONTH            
               DISPLAY '** DATE_MTR_RD_XTRCT =' RW-DATE-MTR-RD-XTRCT    
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '**       PROCESSING TERMINATED           **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7035-GET-MRMS-ROUTE.                                             
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
             SELECT READ_SOURCE_DEF_FL                                  
                   ,MANUAL_READ_FL                                      
                   ,AMR_STATUS_CD                                       
                   ,AMR_COMM_FREQ_CD                                    
                   ,MRMS_READ_ROUTE                                     
                   ,OFF_CYC_READ_ROUTE                                  
                   ,READ_ROUTE_SUFFIX                                   
                   ,CODE_UTIL_TYPE                                      
             INTO  :R4-READ-SOURCE-DEF-FL                               
                  ,:R4-MANUAL-READ-FL                                   
                  ,:R4-AMR-STATUS-CD                                    
                  ,:R4-AMR-COMM-FREQ-CD                                 
                  ,:R4-MRMS-READ-ROUTE                                  
                  ,:R4-OFF-CYC-READ-ROUTE                               
                  ,:R4-READ-ROUTE-SUFFIX                                
                  ,:R4-CODE-UTIL-TYPE                                   
             FROM CSS_READ_RT_SOURCE WITH(READUNCOMMITTED)                      
             WHERE READ_ROUTE         = :R4-READ-ROUTE                  
               AND MTR_READ_SOURCE_CD = :R4-MTR-READ-SOURCE-CD          
               AND COMPANY_NO         = :R4-COMPANY-NO                  
               AND CODE_UTIL_TYPE  IN ( :WS-E-G-UTIL-TYPE,              
                                        :WS-B-E-G-UTIL-TYPE )           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT READ_SOURCE_DEF_FL                                          
MFA-TR*            ,MANUAL_READ_FL                                              
MFA-TR*            ,AMR_STATUS_CD                                               
MFA-TR*            ,AMR_COMM_FREQ_CD                                            
MFA-TR*            ,MRMS_READ_ROUTE                                             
MFA-TR*            ,OFF_CYC_READ_ROUTE                                          
MFA-TR*            ,READ_ROUTE_SUFFIX                                           
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*      INTO  :R4-READ-SOURCE-DEF-FL                                       
MFA-TR*           ,:R4-MANUAL-READ-FL                                           
MFA-TR*           ,:R4-AMR-STATUS-CD                                            
MFA-TR*           ,:R4-AMR-COMM-FREQ-CD                                         
MFA-TR*           ,:R4-MRMS-READ-ROUTE                                          
MFA-TR*           ,:R4-OFF-CYC-READ-ROUTE                                       
MFA-TR*           ,:R4-READ-ROUTE-SUFFIX                                        
MFA-TR*           ,:R4-CODE-UTIL-TYPE                                           
MFA-TR*      FROM CSS_READ_RT_SOURCE                                            
MFA-TR*      WHERE READ_ROUTE         = :R4-READ-ROUTE                          
MFA-TR*        AND MTR_READ_SOURCE_CD = :R4-MTR-READ-SOURCE-CD                  
MFA-TR*        AND COMPANY_NO         = :R4-COMPANY-NO                          
MFA-TR*        AND CODE_UTIL_TYPE  IN ( :WS-E-G-UTIL-TYPE,                      
MFA-TR*                                 :WS-B-E-G-UTIL-TYPE )                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                       OR WS-811                        
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '** ERROR ON 7035-GET-MRMS-ROUTE   **'           
               DISPLAY 'READ_ROUTE         ' R4-READ-ROUTE              
               DISPLAY 'MTR_READ_SOURCE_CD ' R4-MTR-READ-SOURCE-CD      
               DISPLAY 'COMPANY_NO         ' R4-COMPANY-NO              
               DISPLAY 'CODE_UTIL_TYPE     ' R4-CODE-UTIL-TYPE          
               DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '**       PROCESSING TERMINATED           **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF                                                       
           .                                                            
       7035-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7040-OPEN-RD-SOURCE.                                             
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
               OPEN MTR_RD_SRC                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '**  ERROR ON 7040-OPEN-RD-SOURCE  **'           
               DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE          
               DISPLAY '**     PROCESSING TERMINATED    **'             
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF                                                       
           .                                                            
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7045-FETCH-RD-SOURCE.                                            
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
              FETCH MTR_RD_SRC                                          
               INTO :X7-MTR-READ-SOURCE-CD                              
                   ,:X7-AMR-COMM-TYPE-CD                                
                   ,:X7-SEND-READ-REQ-FL                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7045-FETCH-RD-SOURCE **'            
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**     PROCESSING TERMINATED     **'             
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF                                                       
           .                                                            
       7045-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7050-CLOSE-RD-SOURCE.                                            
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
               CLOSE MTR_RD_SRC                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7050-CLOSE-RD-SOURCE  **'           
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**     PROCESSING TERMINATED     **'             
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF                                                       
           .                                                            
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7200-OPEN-UTILITY.                                               
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN UTIL_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7200-OPEN-UTILITY  **'              
              DISPLAY '**  ACCOUNT_NO  =' UT-ACCOUNT-NO                 
              DISPLAY '**  CODE_UTIL_TYPE = (  E OR G  )'               
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**     PROCESSING TERMINATED    **'              
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7201-FETCH-UTILITY.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH UTIL_CSR                                           
               INTO :UT-CODE-UTIL-TYPE                                  
                   ,:UT-IC-NO                                           
                   ,:UT-READ-ROUTE                                      
                   ,:UT-RATE-PLAN-NO                                    
                   ,:UT-READ-CYCLE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 SET NO-MORE-RECORDS     TO TRUE                        
              END-IF                                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7201-FETCH-UTILITY  **'             
              DISPLAY '**  ACCOUNT_NO  =' UT-ACCOUNT-NO                 
              DISPLAY '**  CODE_UTIL_TYPE = (  E OR G  )'               
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**     PROCESSING TERMINATED     **'             
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7201-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7202-CLOSE-UTILITY.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE UTIL_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7202-CLOSE-UTILITY  **'             
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**     PROCESSING TERMINATED     **'             
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7202-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7210-OPEN-MTRD-ENVRNMT.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN MTR_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7210-OPEN-MTRD-ENVRNMT  **'         
              DISPLAY '**  ACCOUNT_NO          =' MN-ACCOUNT-NO         
              DISPLAY '**  CODE_UTIL_TYPE      =' MN-CODE-UTIL-TYPE     
              DISPLAY '**  IC_NO               =' MN-IC-NO              
              DISPLAY '**  CODE_METER_STATUS   <>  K'                   
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**      PROCESSING TERMINATED        **'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7211-FETCH-MTRD-ENVRNMT.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH MTR_CSR                                            
               INTO :MN-MTR-REF-NO                                      
                   ,:MN-CODE-TIME-PERIOD                                
                   ,:MN-METER-NO                                        
                   ,:MN-CODE-METER-LOC                                  
                   ,:MN-CODE-METER-STATUS                               
                   ,:MN-CODE-DATA-PRESENT                               
                   ,:MN-CODE-USAGE-TYPE                                 
                   ,:MN-CODE-USAGE-ID                                   
                   ,:MN-CODE-USAGE-SOURCE                               
                   ,:MN-REG-ID-NO                                       
                   ,:MN-REGISTER-RD-SEQ                                 
                   ,:MN-CODE-CRNT-REG-READ                              
                   ,:MN-CODE-NO-RD-REASON                               
                   ,:MN-CODE-LAST-REG-READ                              
                   ,:MN-LAST-REG-READ-TIME :WS-TIME-NULL-2              
                   ,:MN-LAST-REG-READ-DATE :WS-DATE-NULL-3              
                   ,:MN-LAST-READ-VALUE                                 
                   ,:MN-NO-CONSEC-ESTIMATE                              
                   ,:MN-CODE-MTR-RD-INST1                               
                   ,:MN-CODE-MTR-RD-INST2                               
                   ,:MN-CODE-MTR-RD-INST3                               
                   ,:MN-DIGTL-MTR-TYPE                                  
                   ,:MN-REMOTE-READ-IND                                 
                   ,:MN-MTR-READ-SOURCE-CD                              
                   ,:MN-PROGRAM-ID                                      
                   ,:MN-MIN-NO-UNITS                                    
                   ,:MN-MAX-NO-UNITS                                    
                   ,:MN-METER-PRESSURE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                   TO WS-NUMBER-OF-METERS            
              IF WS-TIME-NULL-2 LESS THAN ZERO                          
                 MOVE SPACES         TO MN-LAST-REG-READ-TIME           
              END-IF                                                    
              IF WS-DATE-NULL-3 LESS THAN ZERO                          
                 MOVE SPACES         TO MN-LAST-REG-READ-DATE           
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7211-FETCH-MTRD-ENVRNMT  **'        
              DISPLAY '**  ACCOUNT_NO          =' MN-ACCOUNT-NO         
              DISPLAY '**  CODE_UTIL_TYPE      =' MN-CODE-UTIL-TYPE     
              DISPLAY '**  IC_NO               =' MN-IC-NO              
              DISPLAY '**  CODE_METER_STATUS   <>  K'                   
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**       PROCESSING TERMINATED        **'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7211-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7212-CLOSE-MTRD-ENVRNMT.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE MTR_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7212-CLOSE-MTRD-ENVRNMT  **'        
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**       PROCESSING TERMINATED        **'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7212-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7220-OPEN-REGISTER-READ.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN REG_RD_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7220-OPEN-REGISTER-READ  **'        
              DISPLAY '**  ACCOUNT_NO     =' RG-ACCOUNT-NO              
              DISPLAY '**  CODE_UTIL_TYPE =' RG-CODE-UTIL-TYPE          
              DISPLAY '**  IC_NO          =' RG-IC-NO                   
              DISPLAY '**  MTR_REF_NO     =' RG-MTR-REF-NO              
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**      PROCESSING TERMINATED         **'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7221-FETCH-REGISTER-READ.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH REG_RD_CSR                                         
               INTO :RG-REG-ID-NO                                       
                   ,:RG-CODE-USAGE-TYPE                                 
                   ,:RG-CODE-USAGE-ID                                   
                   ,:RG-CODE-USAGE-SOURCE                               
                   ,:RG-CODE-TIME-PERIOD                                
                   ,:RG-REGISTER-RD-SEQ                                 
                   ,:RG-CODE-LAST-REG-READ                              
                   ,:RG-LAST-REG-READ-TM :WS-TIME-NULL-2                
                   ,:RG-LAST-REG-READ-DT :WS-DATE-NULL-3                
                   ,:RG-LAST-READ-VALUE                                 
                   ,:RG-NEXT-READ-MONTH                                 
                   ,:RG-CODE-CRNT-REG-READ                              
                   ,:RG-CODE-NO-RD-REASON                               
                   ,:RG-MIN-NO-UNITS                                    
                   ,:RG-MAX-NO-UNITS                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-DATE-NULL-3 LESS THAN ZERO                          
                 MOVE SPACES         TO RG-LAST-REG-READ-DT             
              END-IF                                                    
              IF WS-TIME-NULL-2 LESS THAN ZERO                          
                 MOVE SPACES         TO RG-LAST-REG-READ-TM             
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7221-FETCH-REGISTER-READ  **'       
              DISPLAY '**  ACCOUNT_NO     =' RG-ACCOUNT-NO              
              DISPLAY '**  CODE_UTIL_TYPE =' RG-CODE-UTIL-TYPE          
              DISPLAY '**  IC_NO          =' RG-IC-NO                   
              DISPLAY '**  MTR_REF_NO     =' RG-MTR-REF-NO              
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**       PROCESSING TERMINATED         **'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7221-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7222-CLOSE-REGISTER-READ.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE REG_RD_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7222-CLOSE-REGISTER-READ  **'       
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**       PROCESSING TERMINATED         **'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7222-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7223-SELECT-MTR-CAP.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT NO_READ_DIALS                                      
                    ,CONSTANT                                           
                INTO :MC-NO-READ-DIALS                                  
                    ,:MC-CONSTANT                                       
                FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                          
               WHERE CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                
                 AND METER_NO       = :MC-METER-NO                      
                 AND REG_ID_NO      = :MC-REG-ID-NO                     
                 AND COMPANY_NO     = :MC-COMPANY-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NO_READ_DIALS                                              
MFA-TR*             ,CONSTANT                                                   
MFA-TR*         INTO :MC-NO-READ-DIALS                                          
MFA-TR*             ,:MC-CONSTANT                                               
MFA-TR*         FROM CSS_MTR_CAP                                                
MFA-TR*        WHERE CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                        
MFA-TR*          AND METER_NO       = :MC-METER-NO                              
MFA-TR*          AND REG_ID_NO      = :MC-REG-ID-NO                             
MFA-TR*          AND COMPANY_NO     = :MC-COMPANY-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7223-SELECT-MTR-CAP    **'          
              DISPLAY '** CODE_UTIL_TYPE ='  MC-CODE-UTIL-TYPE          
              DISPLAY '** METER_NO       ='  MC-METER-NO                
              DISPLAY '** REG_ID_NO      ='  MC-REG-ID-NO               
              DISPLAY '** COMPANY_NO     ='  MC-COMPANY-NO              
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**       PROCESSING TERMINATED      **'          
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7223-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7440-GET-READ-CYCLE.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) READ_CYCLE,
              OPTIMUM_READ_DATE,
              DATE_MTR_RD_XTRCT,
              REVENUE_MONTH,
              UT_READ_CYCLE                                      
               INTO :RW-READ-CYCLE,                                     
                    :RW-OPTIMUM-READ-DATE,                              
                    :RW-DATE-MTR-RD-XTRCT,                              
                    :RW-REVENUE-MONTH,                                  
                    :RW-UT-READ-CYCLE                                   
               FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                       
               WHERE  (READ_CYCLE        =:WS-SAVE-READ-CYCLE-1  OR     
                       READ_CYCLE        =:WS-SAVE-READ-CYCLE-2  OR     
                       READ_CYCLE        =:WS-SAVE-READ-CYCLE-3  OR     
                       READ_CYCLE        =:WS-SAVE-READ-CYCLE-4  OR     
                       READ_CYCLE        =:WS-SAVE-READ-CYCLE-5  OR     
                       UT_READ_CYCLE     =:WS-SAVE-READ-CYCLE-1  OR     
                       UT_READ_CYCLE     =:WS-SAVE-READ-CYCLE-2  OR     
                       UT_READ_CYCLE     =:WS-SAVE-READ-CYCLE-3  OR     
                       UT_READ_CYCLE     =:WS-SAVE-READ-CYCLE-4  OR     
                       UT_READ_CYCLE     =:WS-SAVE-READ-CYCLE-5) AND    
                       DATE_MTR_RD_XTRCT =IIF(TRY_CONVERT(DATE, 
                                                  :RW-DATE-MTR-RD-XTRCT
              ) IS NULL OR (PATINDEX('%.%', :RW-DATE-MTR-RD-XTRCT
              ) <> 0) OR (LEN(:RW-DATE-MTR-RD-XTRCT
              ) <> 10), CIS.CHAR2DATE(:RW-DATE-MTR-RD-XTRCT
              ), CONVERT(DATE, :RW-DATE-MTR-RD-XTRCT) )         
                ORDER BY READ_CYCLE                                     
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT READ_CYCLE                                                 
MFA-TR*             ,OPTIMUM_READ_DATE                                          
MFA-TR*             ,DATE_MTR_RD_XTRCT                                          
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*             ,UT_READ_CYCLE                                              
MFA-TR*        INTO :RW-READ-CYCLE,                                             
MFA-TR*             :RW-OPTIMUM-READ-DATE,                                      
MFA-TR*             :RW-DATE-MTR-RD-XTRCT,                                      
MFA-TR*             :RW-REVENUE-MONTH,                                          
MFA-TR*             :RW-UT-READ-CYCLE                                           
MFA-TR*        FROM CSS_READ_WINDOW                                             
MFA-TR*        WHERE  (READ_CYCLE        =:WS-SAVE-READ-CYCLE-1  OR             
MFA-TR*                READ_CYCLE        =:WS-SAVE-READ-CYCLE-2  OR             
MFA-TR*                READ_CYCLE        =:WS-SAVE-READ-CYCLE-3  OR             
MFA-TR*                READ_CYCLE        =:WS-SAVE-READ-CYCLE-4  OR             
MFA-TR*                READ_CYCLE        =:WS-SAVE-READ-CYCLE-5  OR             
MFA-TR*                UT_READ_CYCLE     =:WS-SAVE-READ-CYCLE-1  OR             
MFA-TR*                UT_READ_CYCLE     =:WS-SAVE-READ-CYCLE-2  OR             
MFA-TR*                UT_READ_CYCLE     =:WS-SAVE-READ-CYCLE-3  OR             
MFA-TR*                UT_READ_CYCLE     =:WS-SAVE-READ-CYCLE-4  OR             
MFA-TR*                UT_READ_CYCLE     =:WS-SAVE-READ-CYCLE-5) AND            
MFA-TR*                DATE_MTR_RD_XTRCT =:RW-DATE-MTR-RD-XTRCT                 
MFA-TR*         ORDER BY READ_CYCLE                                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7440-GET-READ-CYCLE       **'       
              DISPLAY '**  READ_CYCLE      = ' WS-SAVE-READ-CYCLE-1     
              DISPLAY '**  DATE_MTR_RD_XTRCT = ' RW-DATE-MTR-RD-XTRCT   
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**     PROCESSING TERMINATED     **'             
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7445-GET-NEARBY-READ-CYCLE.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) READ_CYCLE,
              OPTIMUM_READ_DATE,
              DATE_MTR_RD_XTRCT,
              REVENUE_MONTH,
              UT_READ_CYCLE                                      
               INTO :RW-READ-CYCLE,                                     
                    :RW-OPTIMUM-READ-DATE,                              
                    :RW-DATE-MTR-RD-XTRCT,                              
                    :RW-REVENUE-MONTH,                                  
                    :RW-UT-READ-CYCLE                                   
                 FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                     
                WHERE  DATE_MTR_RD_XTRCT <= IIF(TRY_CONVERT(DATE, 
                                                  :RW-DATE-MTR-RD-XTRCT
              ) IS NULL OR (PATINDEX('%.%', :RW-DATE-MTR-RD-XTRCT
              ) <> 0) OR (LEN(:RW-DATE-MTR-RD-XTRCT
              ) <> 10), CIS.CHAR2DATE(:RW-DATE-MTR-RD-XTRCT
              ), CONVERT(DATE, :RW-DATE-MTR-RD-XTRCT) )       
                ORDER BY DATE_MTR_RD_XTRCT DESC, READ_CYCLE ASC         
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT READ_CYCLE                                                 
MFA-TR*             ,OPTIMUM_READ_DATE                                          
MFA-TR*             ,DATE_MTR_RD_XTRCT                                          
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*             ,UT_READ_CYCLE                                              
MFA-TR*        INTO :RW-READ-CYCLE,                                             
MFA-TR*             :RW-OPTIMUM-READ-DATE,                                      
MFA-TR*             :RW-DATE-MTR-RD-XTRCT,                                      
MFA-TR*             :RW-REVENUE-MONTH,                                          
MFA-TR*             :RW-UT-READ-CYCLE                                           
MFA-TR*          FROM CSS_READ_WINDOW                                           
MFA-TR*         WHERE  DATE_MTR_RD_XTRCT <= :RW-DATE-MTR-RD-XTRCT               
MFA-TR*         ORDER BY DATE_MTR_RD_XTRCT DESC, READ_CYCLE ASC                 
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7445-GET-NEARBY-READ-CYCLE **'      
              DISPLAY '**  DATE_MTR_RD_XTRCT <=' RW-DATE-MTR-RD-XTRCT   
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**     PROCESSING TERMINATED     **'             
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7445-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7450-SELECT-RESTART.                                             
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART                                       
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**   ERROR ON 7450-SELECT-RESTART   **'          
              DISPLAY '**   RETURN CODE = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED      **'          
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
      *** 7600-START-FCSJC01                                         *          
      *** 7610-READ-FCSJC01                                          *          
      *** 7611-CLOSE                                                 *          
      *==============================================================*          
      *** COPYBOOK TO GET GENERIC DATA FROM JOB PARM                            
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
      *** 7620-START-FCSCA00                                         *          
      *** 7621-READ-FCSCA00                                          *          
      *** 7622-CLOSE-CA00-CSR                                        *          
      *==============================================================*          
      *** COPYBOOK TO GET SPECIAL DATA FROM JOB PARM (CA00)                     
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
ACT199 7550-UPDATE-PREMISE.                                             
ACT199                                                                  
ACT199     EXEC SQL                                                     
ACT199          UPDATE CSS_PREMISE                                      
ACT199          SET DATE_SPCL_MSG_ENDS = NULL,                          
ACT199                 SPCL_READ_INSTR = :PR-SPCL-READ-INSTR            
ACT199          WHERE PREMISE_NO = :PR-PREMISE-NO                       
ACT199                                                      
ACT199     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_PREMISE                                              
MFA-TR*         SET DATE_SPCL_MSG_ENDS = NULL,                                  
MFA-TR*                SPCL_READ_INSTR = :PR-SPCL-READ-INSTR                    
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*         QUERYNO 7550                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT199                                                                  
ACT199     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT199                                                                  
ACT199     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT199         CONTINUE                                                 
ACT199     ELSE                                                         
ACT199         DISPLAY '**************** PCSBW171 *****************'    
ACT199         DISPLAY '* 7550 : RETURN CODE ERROR - UPDATE'            
ACT199         DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
ACT199         DISPLAY '* PREMISE NO = ' PR-PREMISE-NO                  
ACT199         DISPLAY '**************** PCSBW171 *****************'    
ACT199         PERFORM 9900-ABEND                THRU 9900-EXIT         
ACT199     END-IF.                                                      
ACT199                                                                  
ACT199 7550-EXIT.                                                       
      *                                                                         
      *==============================================================*          
       7623-SELECT-DIGTL-MTR-TYPE.                                      
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
               SELECT DIGTL_MTR_NBR_FMT                                 
                     ,MANUFACTURER_CD                                   
                     ,OPTICAL_PASSWD_ID                                 
                     ,TIM_NAME                                          
                 INTO :T1-DIGTL-MTR-NBR-FMT                             
                     ,:T1-MANUFACTURER-CD                               
                     ,:T1-OPTICAL-PASSWD-ID                             
                     ,:T1-TIM-NAME                                      
                 FROM CSS_DIGTL_MTR_TYPE WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE = :T1-CODE-UTIL-TYPE               
                  AND DIGTL_MTR_TYPE = :T1-DIGTL-MTR-TYPE               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DIGTL_MTR_NBR_FMT                                         
MFA-TR*              ,MANUFACTURER_CD                                           
MFA-TR*              ,OPTICAL_PASSWD_ID                                         
MFA-TR*              ,TIM_NAME                                                  
MFA-TR*          INTO :T1-DIGTL-MTR-NBR-FMT                                     
MFA-TR*              ,:T1-MANUFACTURER-CD                                       
MFA-TR*              ,:T1-OPTICAL-PASSWD-ID                                     
MFA-TR*              ,:T1-TIM-NAME                                              
MFA-TR*          FROM CSS_DIGTL_MTR_TYPE                                        
MFA-TR*         WHERE CODE_UTIL_TYPE = :T1-CODE-UTIL-TYPE                       
MFA-TR*           AND DIGTL_MTR_TYPE = :T1-DIGTL-MTR-TYPE                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '** ERROR ON 7623-SELECT-DIGTL-MTR-TYPE  **'      
              DISPLAY '** T1-DIGTL-MTR-TYPE = ' T1-DIGTL-MTR-TYPE       
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '**       PROCESSING TERMINATED          **'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7623-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A00795*================================================================*        
A00795 7700-GET-LAST-LP-READ-DATE.                                      
A00795*================================================================*        
A00795*** GET LATEST PROBED TOU/IDR READ DATE FOR READINDG PARTIAL              
A00795*** LOAD PROFILE DATA OF IDR METER.                                       
A00795*                                                                         
A00795     EXEC SQL                                                     
A00795         SELECT TOP(1) LAST_REG_READ_DT,
              REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TM, 108), ':', 
           '.') LAST_REG_READ_TM                                  
A00795          INTO :PW-LAST-REG-READ-DT                               
A00795              ,:PW-LAST-REG-READ-TM                               
A00795         FROM CSS_ROUTE_REPORT PW WITH(READUNCOMMITTED),                  
A00795              CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
A00795         WHERE PW.ACCOUNT_NO     = UT.ACCOUNT_NO                  
A00795           AND PW.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE              
A00795           AND PW.IC_NO          = UT.IC_NO                       
A00795           AND UT.PREMISE_NO     = :UT-PREMISE-NO                 
A00795           AND PW.CODE_UTIL_TYPE = :PW-CODE-UTIL-TYPE             
A00795           AND PW.IC_NO          = :PW-IC-NO                      
A00795           AND PW.MTR_REF_NO     = :PW-MTR-REF-NO                 
A00795           AND PW.METER_NO       = :PW-METER-NO                   
A00795           AND PW.READING_CODE   = 'P'                            
A00795         ORDER BY LAST_REG_READ_DT DESC,                          
A00795                  LAST_REG_READ_TM DESC                           
A00795                                       
A00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LAST_REG_READ_DT                                          
MFA-TR*              ,LAST_REG_READ_TM                                          
MFA-TR*         INTO :PW-LAST-REG-READ-DT                                       
MFA-TR*             ,:PW-LAST-REG-READ-TM                                       
MFA-TR*        FROM CSS_ROUTE_REPORT PW,                                        
MFA-TR*             CSS_UTIL_ENVRNMT UT                                         
MFA-TR*        WHERE PW.ACCOUNT_NO     = UT.ACCOUNT_NO                          
MFA-TR*          AND PW.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                      
MFA-TR*          AND PW.IC_NO          = UT.IC_NO                               
MFA-TR*          AND UT.PREMISE_NO     = :UT-PREMISE-NO                         
MFA-TR*          AND PW.CODE_UTIL_TYPE = :PW-CODE-UTIL-TYPE                     
MFA-TR*          AND PW.IC_NO          = :PW-IC-NO                              
MFA-TR*          AND PW.MTR_REF_NO     = :PW-MTR-REF-NO                         
MFA-TR*          AND PW.METER_NO       = :PW-METER-NO                           
MFA-TR*          AND PW.READING_CODE   = 'P'                                    
MFA-TR*        ORDER BY LAST_REG_READ_DT DESC,                                  
MFA-TR*                 LAST_REG_READ_TM DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00795*                                                                         
A00795     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A00795*                                                                         
A00795     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A00795        CONTINUE                                                  
A00795     ELSE                                                         
A00795        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A00795        DISPLAY '**  ERROR ON 7700-GET-LAST-LP-READ-DATE **'      
A00795        DISPLAY '**  ACCOUNT_NO  = ' AT-ACCOUNT-NO                
A00795        DISPLAY '**  CODE_UTIL_TYPE = ' PW-CODE-UTIL-TYPE         
A00795        DISPLAY '**  IC_NO          = ' PW-IC-NO                  
A00795        DISPLAY '**  PREMISE_NO     = ' UT-PREMISE-NO             
A00795        DISPLAY '**  METER_NO       = ' PW-METER-NO               
A00795        DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
A00795        DISPLAY '**     PROCESSING TERMINATED     **'             
A00795        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00795     END-IF.                                                      
A00795*                                                                         
A00795 7700-EXIT.                                                       
A00795     EXIT.                                                        
A00795*                                                                         
A00795*================================================================*        
A00795 7720-SUBTRACT15-MINUTES-LP-TM.                                   
A00795*================================================================*        
A00795*                                                                         
A00795     EXEC SQL                                                     
A00795        SELECT
              REPLACE(CONVERT(CHAR(8), DATEADD( MINUTE, -15, 
           CIS.CHAR2TIME(:WS-LAST-RD-TIME) ), 108), ':', '.')
            INTO
              :WS-LAST-RD-TIME                   
A00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-LAST-RD-TIME =                                            
MFA-TR*           TIME(:WS-LAST-RD-TIME) - 15 MINUTES                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00795*                                                                         
A00795     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A00795     IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
A00795        CONTINUE                                                  
A00795     ELSE                                                         
A00795        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A00795        DISPLAY '** PCSBW171 PROCESSING ERROR     **'             
A00795        DISPLAY '** 7720-SUBTRACT15-MINUTES-LP-TM**'              
A00795        DISPLAY '** LAST-REG-RD-TM = ' WS-LAST-LP-RD-TIME         
A00795        DISPLAY '**  ACCOUNT_NO     = ' MN-ACCOUNT-NO             
A00795        DISPLAY '**  CODE_UTIL_TYPE = ' UT-CODE-UTIL-TYPE         
A00795        DISPLAY '**  IC_NO          = ' UT-IC-NO                  
A00795        DISPLAY '**  METER_NO       = ' MN-METER-NO               
A00795        DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
A00795        DISPLAY '** PROCESSING TERMINATED         **'             
A00795        PERFORM 9900-ABEND  THRU 9900-EXIT                        
A00795     END-IF.                                                      
A00795*                                                                         
A00795 7720-EXIT.                                                       
A00795     EXIT.                                                        
A00795*                                                                         
      *================================================================*        
       7750-REG-READ-DAYS.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-FCS-OPTIMUM-RD-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-FCS-OPTIMUM-RD-DT
              ) <> 0) OR (LEN(:WS-FCS-OPTIMUM-RD-DT
              ) <> 10), CIS.CHAR2DATE(:WS-FCS-OPTIMUM-RD-DT
              ), CONVERT(DATE, :WS-FCS-OPTIMUM-RD-DT) ))                     
                     - CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-LAST-REG-RD-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-REG-RD-DT
              ) <> 0) OR (LEN(:WS-LAST-REG-RD-DT
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-REG-RD-DT
              ), CONVERT(DATE, :WS-LAST-REG-RD-DT) ))
            INTO
              :WS-HILO-DAYS                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-HILO-DAYS =                                               
MFA-TR*           DAYS(DATE(:WS-FCS-OPTIMUM-RD-DT))                             
MFA-TR*              - DAYS(DATE(:WS-LAST-REG-RD-DT))                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              IF WS-HILO-DAYS > 70                                      
                 MOVE 32               TO WS-HILO-DAYS                  
              END-IF                                                    
              IF WS-HILO-DAYS < 1                                       
                 MOVE 1                TO WS-HILO-DAYS                  
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '** PCSBW171 PROCESSING ERROR     **'             
              DISPLAY '** 7750-REG-READ-DAYS            **'             
              DISPLAY '** LAST-REG-RD-DT = ' WS-LAST-REG-RD-DT          
              DISPLAY '** OPTIMUM-READ-DT = ' WS-FCS-OPTIMUM-RD-DT      
              DISPLAY '** RETURN CODE = ' WS-DISPLAY-SQLCODE            
              DISPLAY '** PROCESSING TERMINATED         **'             
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7810-OPEN-FILT-INFO-CSR.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN FILTER_INFO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  PCSBW171 PROCESSING ERROR     **'            
              DISPLAY '**  7810-OPEN-FILT-INFO-CSR       **'            
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  PROCESSING TERMINATED         **'            
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7820-FETCH-FILT-INFO-CSR.                                        

MSQ008     MOVE 100 TO MSQ008-FILTER-INFO
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FOR :MSQ008-FILTER-INFO
              FETCH 
              FROM FILTER_INFO           
                INTO :TB-CODE-VALUE                                     
                    ,:TB-FILTER-INFO-DATA                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM FILTER_INFO FOR 100 ROWS                  
MFA-TR*         INTO :TB-CODE-VALUE                                             
MFA-TR*             ,:TB-FILTER-INFO-DATA                                       
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-FILTER-INFO
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)              TO WS-FILTER-INFO-COUNT      
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  PCSBW171 PROCESSING ERROR     **'            
              DISPLAY '**  7820-FETCH-FILT-INFO-CSR      **'            
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  PROCESSING TERMINATED         **'            
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7830-CLOSE-FILT-INFO-CSR.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE FILTER_INFO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  PCSBW171 PROCESSING ERROR     **'            
              DISPLAY '**  7830-CLOSE-FILT-INFO-CSR      **'            
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  PROCESSING TERMINATED         **'            
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7830-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *===============================================================*         
       7860-SELECT-AMR-DEVICE.                                          
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) MA.DEVICE_NO,
              MA.CODE_ATT_TYPE                                 
                 INTO :MA-DEVICE-NO                                     
                     ,:MA-CODE-ATT-TYPE                                 
                 FROM  CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)              
                      ,CSS_MTR_ATT_TYPE   N5 WITH(READUNCOMMITTED)              
                WHERE  MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE            
                  AND  MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE             
                  AND  MA.COMPANY_NO     = :MA-COMPANY-NO               
                  AND  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE           
                  AND  MA.METER_NO       = :MA-METER-NO                 
                  AND  N5.DEVICE_TYPE_CD = 'A'                          
                ORDER BY MA.DEVICE_NO                                   
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MA.DEVICE_NO                                             
MFA-TR*               ,MA.CODE_ATT_TYPE                                         
MFA-TR*          INTO :MA-DEVICE-NO                                             
MFA-TR*              ,:MA-CODE-ATT-TYPE                                         
MFA-TR*          FROM  CSS_METER_ATTCHMTS MA                                    
MFA-TR*               ,CSS_MTR_ATT_TYPE   N5                                    
MFA-TR*         WHERE  MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE                    
MFA-TR*           AND  MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE                     
MFA-TR*           AND  MA.COMPANY_NO     = :MA-COMPANY-NO                       
MFA-TR*           AND  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                   
MFA-TR*           AND  MA.METER_NO       = :MA-METER-NO                         
MFA-TR*           AND  N5.DEVICE_TYPE_CD = 'A'                                  
MFA-TR*         ORDER BY MA.DEVICE_NO                                           
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '*****************PCSBW171******************'    
               DISPLAY '* CODE-UTIL-TYPE = ' MA-CODE-UTIL-TYPE          
               DISPLAY '* METER-NO       = ' MA-METER-NO                
               DISPLAY '* COMPANY_NO     = ' MA-COMPANY-NO              
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSBW171******************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A05744*================================================================*        
A05744 7870-GET-OVERRIDE-LOFF.                                          
A05744*================================================================*        
A05744*                                                                         
A05744     EXEC SQL                                                     
A05744        SELECT ERROR_MSG_NO                                       
A05744          INTO :O2-ERROR-MSG-NO                                   
A05744          FROM CSS_LOC_OFF_CYC_RT WITH(READUNCOMMITTED)                   
A05744         WHERE READ_ROUTE = :O2-READ-ROUTE                        
A05744           AND COMPANY_NO = :O2-COMPANY-NO                        
A05744           AND LOCAL_OFFICE = :O2-LOCAL-OFFICE                    
A05744                                                           
A05744     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ERROR_MSG_NO                                               
MFA-TR*         INTO :O2-ERROR-MSG-NO                                           
MFA-TR*         FROM CSS_LOC_OFF_CYC_RT                                         
MFA-TR*        WHERE READ_ROUTE = :O2-READ-ROUTE                                
MFA-TR*          AND COMPANY_NO = :O2-COMPANY-NO                                
MFA-TR*          AND LOCAL_OFFICE = :O2-LOCAL-OFFICE                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05744*                                                                         
A05744     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A05744*                                                                         
A05744     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A05744         CONTINUE                                                 
A05744     ELSE                                                         
A05744        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A05744        DISPLAY '**  ERROR ON 7870-GET-OVERRIDE-LOFF **'          
A05744        DISPLAY '**  O2-READ-ROUTE = ' O2-READ-ROUTE              
A05744        DISPLAY '**  O2-COMPANY-NO = ' O2-COMPANY-NO              
A05744        DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE         
A05744        DISPLAY '**       PROCESSING TERMINATED      **'          
A05744        PERFORM 9900-ABEND                THRU 9900-EXIT          
A05744     END-IF.                                                      
A05744*                                                                         
A05744 7870-EXIT.                                                       
A05744     EXIT.                                                        
A05744*                                                                         
      *================================================================*        
       7900-READ-O2-TABLE.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT READ_CYCLE,                                        
                     LOCAL_OFFICE                                       
                INTO :O2-READ-CYCLE,                                    
                     :O2-LOCAL-OFFICE                                   
                FROM CSS_LOC_OFF_CYC_RT WITH(READUNCOMMITTED)                   
               WHERE READ_ROUTE = :O2-READ-ROUTE                        
                 AND COMPANY_NO = :O2-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT READ_CYCLE,                                                
MFA-TR*              LOCAL_OFFICE                                               
MFA-TR*         INTO :O2-READ-CYCLE,                                            
MFA-TR*              :O2-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_LOC_OFF_CYC_RT                                         
MFA-TR*        WHERE READ_ROUTE = :O2-READ-ROUTE                                
MFA-TR*          AND COMPANY_NO = :O2-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 7900-READ-O2-TABLE     **'          
              DISPLAY '**  O2-READ-ROUTE = ' O2-READ-ROUTE              
              DISPLAY '**  O2-COMPANY-NO = ' O2-COMPANY-NO              
              DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED      **'          
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7910-OPEN-RD-FMT-CURSOR.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN RD_FMT                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  PCSBW171 PROCESSING ERROR     **'            
              DISPLAY '**  7910-OPEN-RD-FMT-CURSOR       **'            
              DISPLAY '**  OPEN ERROR FOR RD_FMT CURSOR  **'            
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  PROCESSING TERMINATED         **'            
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7920-FETCH-RD-FMT-CURSOR.                                        

MSQ008     MOVE 1000 TO MSQ008-RD-FMT
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FOR :MSQ008-RD-FMT
              FETCH 
              FROM RD_FMT               
                INTO :TAB-CODE-UTIL-TYPE                                
                    ,:TAB-DIGTL-MTR-TYPE                                
                    ,:TAB-PROGRAM-ID                                    
                    ,:TAB-MTR-READ-SOURCE-CD                            
                    ,:TAB-REMOTE-READ-IND                               
                    ,:TAB-CODE-USAGE-TYPE                               
P00251              ,:TAB-CODE-USAGE-ID                                 
P00251              ,:TAB-CODE-USAGE-SOURCE                             
P00251              ,:TAB-REG-ID-NO                                     
                    ,:TAB-CODE-TIME-PERIOD                              
                    ,:TAB-CODE-TOU-SEASN                                
                    ,:TAB-MTR-RD-DISP-CD                                
                    ,:TAB-INDEX-VALUE-CD                                
                    ,:TAB-NO-READ-DIGITS                                
                    ,:TAB-NO-READ-DECIMALS                              
                    ,:TAB-READ-SEQUENCE-NO                              
                    ,:TAB-CNSMPTN-READ-FL                               
                    ,:TAB-MIN-READ                                      
                    ,:TAB-MAX-READ                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM RD_FMT FOR 1000 ROWS                      
MFA-TR*         INTO :TAB-CODE-UTIL-TYPE                                        
MFA-TR*             ,:TAB-DIGTL-MTR-TYPE                                        
MFA-TR*             ,:TAB-PROGRAM-ID                                            
MFA-TR*             ,:TAB-MTR-READ-SOURCE-CD                                    
MFA-TR*             ,:TAB-REMOTE-READ-IND                                       
MFA-TR*             ,:TAB-CODE-USAGE-TYPE                                       
MFA-TR*             ,:TAB-CODE-USAGE-ID                                         
MFA-TR*             ,:TAB-CODE-USAGE-SOURCE                                     
MFA-TR*             ,:TAB-REG-ID-NO                                             
MFA-TR*             ,:TAB-CODE-TIME-PERIOD                                      
MFA-TR*             ,:TAB-CODE-TOU-SEASN                                        
MFA-TR*             ,:TAB-MTR-RD-DISP-CD                                        
MFA-TR*             ,:TAB-INDEX-VALUE-CD                                        
MFA-TR*             ,:TAB-NO-READ-DIGITS                                        
MFA-TR*             ,:TAB-NO-READ-DECIMALS                                      
MFA-TR*             ,:TAB-READ-SEQUENCE-NO                                      
MFA-TR*             ,:TAB-CNSMPTN-READ-FL                                       
MFA-TR*             ,:TAB-MIN-READ                                              
MFA-TR*             ,:TAB-MAX-READ                                              
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-RD-FMT
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              MOVE SQLERRD(3)              TO WS-RD-FMT-COUNT           
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  PCSBW171 PROCESSING ERROR     **'            
              DISPLAY '**  7920-FETCH-RD-FMT-CURSOR      **'            
              DISPLAY '**  FETCH ERROR FOR RD_FMT CURSOR **'            
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  PROCESSING TERMINATED         **'            
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7930-CLOSE-RD-FMT-CURSOR.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE RD_FMT                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  PCSBW171 PROCESSING ERROR     **'            
              DISPLAY '**  7930-CLOSE-RD-FMT-CURSOR      **'            
              DISPLAY '**  CLOSE ERROR FOR RD_FMT CURSOR **'            
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**  PROCESSING TERMINATED         **'            
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT069*================================================================*        
ACT069 7940-GET-CURRENT-DT.                                             
ACT069*================================================================*        
ACT069*                                                                         
ACT069     EXEC SQL                                                     
ACT069        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                  
ACT069     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT069                                                                  
ACT069     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT069*                                                                         
ACT069     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT069        CONTINUE                                                  
ACT069     ELSE                                                         
ACT069        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
ACT069        DISPLAY '**  PCSBW171 PROCESSING ERROR     **'            
ACT069        DISPLAY '**  7940-GET-CURRENT-DT           **'            
ACT069        DISPLAY '**  GET THE CURRENT DATE          **'            
ACT069        DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
ACT069        DISPLAY '**  PROCESSING TERMINATED         **'            
ACT069        PERFORM 9900-ABEND  THRU 9900-EXIT                        
ACT069     END-IF.                                                      
ACT069*                                                                         
ACT069 7940-EXIT.                                                       
ACT069     EXIT.                                                        
ACT069*                                                                         
      *================================================================*        
       8400-WRITE-FCSBW71.                                              
      *================================================================*        
      *                                                                         
      ***  PRESERVE OFF THE CONTENTS OF FIOBW71 BECAUSE THE WRITE               
      ***  STATEMENT WILL LOW-VALUE IT:                                         
      *                                                                         
           MOVE FIOBW71                TO WS-HOLD-FIOBW71.              
      *                                                                         
           WRITE FIOBW71.                                               
      *                                                                         
           IF FBW71-SUCCESSFUL                                          
               MOVE WS-HOLD-FIOBW71    TO FIOBW71                       
               ADD 1                   TO WS-COUNT-FCSBW71              
               ADD 1                   TO WS-RST-BW71-REC-CNTR          
           ELSE                                                         
               DISPLAY '8400-ERROR ON FCSBW71 WRITE.  STATUS IS '       
                        WS-FBW71-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8420-WRITE-FCSCA55.                                              
      *================================================================*        
      *                                                                         
           WRITE E-FCA55.                                               
      *                                                                         
           IF FCA55-SUCCESSFUL                                          
              COMPUTE WS-RST-CA55-REC-CNTR = WS-RST-CA55-REC-CNTR + 1   
           ELSE                                                         
               DISPLAY '8420-ERROR ON FCSCA55 WRITE.  STATUS IS '       
                        WS-FCA55-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8430-WRITE-FCSRP87.                                              
      *================================================================*        
      *                                                                         
           WRITE E-FRP87.                                               
      *                                                                         
           IF FRP87-SUCCESSFUL                                          
              COMPUTE WS-RST-RP87-REC-CNTR = WS-RST-RP87-REC-CNTR + 1   
           ELSE                                                         
              DISPLAY '8430-ERROR ON FCSRP87 WRITE.  STATUS IS '        
                       WS-FRP87-STATUS                                  
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8440-WRITE-FCSRP123.                                             
      *================================================================*        
      *                                                                         
           WRITE E-FIORP123.                                            
      *                                                                         
           IF FRP123-SUCCESSFUL                                         
              COMPUTE  WS-RST-RP123-REC-CNTR                            
                                 = WS-RST-RP123-REC-CNTR + 1            
           ELSE                                                         
              DISPLAY '8440-ERROR ON FCSRP123 WRITE.  STATUS IS '       
                       WS-FRP123-STATUS                                 
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8450-UPDATE-RESTART.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
               SET RESTART_DATA = :RF-RESTART-DATA                      
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
                 AND PARTITION_NO = :RF-PARTITION-NO                    
                 AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 8450-UPDATE-RESTART  **'            
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**      PROCESSING TERMINATED     **'            
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8460-INSERT-RESTART.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM, PARTITION_NO, DUP_CNTRL_NO,           
                       RESTART_DATA)                                    
               VALUES (:RF-NAME-PROGRAM, :RF-PARTITION-NO,              
                       :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**   ERROR ON 8460-INSERT-RESTART   **'          
              DISPLAY '**   RETURN CODE = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED      **'          
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8520-UPDATE-MTRD-ENVRNMT.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_MTRD_ENVRNMT                                  
               SET CODE_NO_RD_REASON = :MN-CODE-NO-RD-REASON            
                  ,CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ          
                  ,MIN_NO_UNITS       = :MN-MIN-NO-UNITS                
                  ,MAX_NO_UNITS       = :MN-MAX-NO-UNITS                
               WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                
                 AND IC_NO          = :UT-IC-NO                         
                 AND MTR_REF_NO     = :MN-MTR-REF-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD 1                   TO WS-RST-MN-UPDT-CNTR           
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**   ERROR ON 8520-UPDATE-MTRD-ENVRNMT   **'     
              DISPLAY 'ACCOUNT_NO     = ' AT-ACCOUNT-NO                 
              DISPLAY 'CODE_UTIL_TYPE = ' UT-CODE-UTIL-TYPE             
              DISPLAY 'IC_NO          = ' UT-IC-NO                      
              DISPLAY 'MTR_REF_NO     = ' MN-MTR-REF-NO                 
              DISPLAY '**   RETURN CODE = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8530-UPDATE-REGISTER-READ.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_REGISTER_READ                                 
               SET CODE_CRNT_REG_READ = :RG-CODE-CRNT-REG-READ          
                  ,CODE_NO_RD_REASON  = :RG-CODE-NO-RD-REASON           
                  ,NEXT_READ_MONTH    = :RG-NEXT-READ-MONTH             
                  ,MIN_NO_UNITS       = :RG-MIN-NO-UNITS                
                  ,MAX_NO_UNITS       = :RG-MAX-NO-UNITS                
               WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                  
                 AND CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE              
                 AND IC_NO            = :UT-IC-NO                       
                 AND MTR_REF_NO       = :MN-MTR-REF-NO                  
                 AND REG_ID_NO        = :RG-REG-ID-NO                   
                 AND CODE_TIME_PERIOD = :RG-CODE-TIME-PERIOD            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                   TO WS-RST-RG-UPDT-CNTR            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**  ERROR ON 8530-UPDATE-REGISTER-READ  **'      
              DISPLAY 'ACCOUNT_NO      = ' AT-ACCOUNT-NO                
              DISPLAY 'CODE_UTIL_TYPE  = ' UT-CODE-UTIL-TYPE            
              DISPLAY 'IC_NO           = ' UT-IC-NO                     
              DISPLAY 'MTR_REF_NO      = ' MN-MTR-REF-NO                
              DISPLAY 'REG_ID_NO       = ' RG-REG-ID-NO                 
              DISPLAY 'CODE_TIME_PERIOD= ' RG-CODE-TIME-PERIOD          
              DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
              DISPLAY '**      PROCESSING TERMINATED           **'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8540-UPDATE-ACCOUNT.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
               SET CODE_ACCT_BILLED = :AT-CODE-ACCT-BILLED              
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD 1                   TO WS-RST-AT-UPDT-CNTR           
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '**   ERROR ON 8540-UPDATE-ACCOUNT   **'          
              DISPLAY '** ACCOUNT_NO = ' AT-ACCOUNT-NO                  
              DISPLAY '**   RETURN CODE = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**      PROCESSING TERMINATED       **'          
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
      *  8895-INSERT-WORK-QUEUE  **                                             
      *================================================================*        
ACT069*                                                                         
ACT069 8895-INSERT-WORK-QUEUE.                                          
ACT069     MOVE SPACES TO ABEND-FUNCTION.                               
ACT069                                                                  
ACT069     CALL SCSCB077 USING CWS00077-FIELDS,                         
ACT069                         ABEND-FILE,                              
ACT069                         RS-RETURN-CODE                           
ACT069     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
ACT069                                                                  
ACT069     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
ACT069        MOVE WS-PGRMNAME         TO ABEND-PROGRAM                 
ACT069        DISPLAY '8895-INSERT-WORK-QUEUE'                          
ACT069        DISPLAY 'CALL SCSCB077         '                          
ACT069        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
ACT069        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
ACT069        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
ACT069        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
ACT069        PERFORM 9900-ABEND    THRU 9900-EXIT                      
ACT069     END-IF.                                                      
ACT069 8895-EXIT.                                                       
ACT069     EXIT.                                                        
      *================================================================*        
       8898-ISSUE-CHKP.                                                 
      *================================================================*        
      *                                                                         
           MOVE 1                      TO WS-RST-PROCESS-TYPE.          
           ADD 1                       TO WS-CHKP-SEQ-NO.               
           MOVE WS-CHKP-SEQ-NO         TO WS-RST-CHKP-SEQ-NO.           
      *                                                                         
           MOVE E-FDB09-ACCOUNT-NO     TO WS-RST-ACCOUNT-NO             
           MOVE WS-FCSDB09-REC-CNTR    TO WS-RST-RECORD-COUNT           
           MOVE WS-INPUT-DATE          TO WS-RST-COMMON-DATE            
      *                                                                         
           PERFORM 8899-WRITE-RSDDR        THRU 8899-EXIT.              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'           
                   'LAST ACCOUNT NO PROCESSED = ' AT-ACCOUNT-NO.        
      *                                                                         
           MOVE ZERO                   TO WS-CHKP-LUW-COUNTER.          
      *                                                                         
       8898-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8899-WRITE-RSDDR.                                                
      *================================================================*        
      *                                                                         
           MOVE WS-PGRMNAME            TO RF-NAME-PROGRAM.              
           MOVE WS-PART-NO             TO RF-PARTITION-NO.              
           MOVE 1                      TO RF-DUP-CNTRL-NO.              
           MOVE WS-RST-DATA            TO RF-RESTART-DATA-TEXT.         
           MOVE WS-RST-DATA-LENGTH TO RF-RESTART-DATA-LEN.              
      *                                                                         
           PERFORM 8450-UPDATE-RESTART        THRU 8450-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               PERFORM 8460-INSERT-RESTART    THRU 8460-EXIT            
           END-IF.                                                      
      *                                                                         
       8899-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       9000-TERMINATE.                                                  
      *================================================================*        
      *                                                                         
           CLOSE FCSBW71-FILE.                                          
           CLOSE FCSDB09-FILE.                                          
           CLOSE FCSRP87-FILE.                                          
           CLOSE FCSCA55-FILE.                                          
           CLOSE FCSRP123-FILE.                                         
      *                                                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       9001-DISPLAY.                                                    
      *================================================================*        
      *                                                                         
           IF WS-COUNT-FCSBW71 > 0                                      
              COMPUTE WS-COUNT-FCSBW71 = WS-COUNT-FCSBW71 - 1           
           END-IF.                                                      
      *                                                                         
           MOVE WS-COUNT-FCSBW71       TO WS-DISP-FCSBW71.              
           MOVE WS-RST-RP87-TOT-CNTR   TO WS-DISP-FCSRP87.              
           MOVE WS-RST-CA55-TOT-CNTR   TO WS-DISP-FCSCA55.              
           MOVE WS-RST-RP123-TOT-CNTR  TO WS-DISP-FCSRP123.             
           MOVE WS-RST-AT-UPDT-CNTR    TO WS-DISP-AT-UPD.               
           MOVE WS-RST-MN-UPDT-CNTR    TO WS-DISP-MN-UPD.               
           MOVE WS-RST-RG-UPDT-CNTR    TO WS-DISP-RG-UPD.               
      *                                                                         
           DISPLAY ' # OF RECS WRITTEN TO FCSBW71: ' WS-DISP-FCSBW71.   
           DISPLAY ' # OF RECS WRITTEN TO FCSRP87: ' WS-DISP-FCSRP87.   
           DISPLAY ' # OF RECS WRITTEN TO FCSCA55: ' WS-DISP-FCSCA55.   
           DISPLAY ' # OF RECS WRITTEN TO FCSRP123:' WS-DISP-FCSRP123.  
           DISPLAY ' '                                                  
           DISPLAY ' # OF ROWS UPDATED TO AT TABLE:' WS-DISP-AT-UPD.    
           DISPLAY ' # OF ROWS UPDATED TO MN TABLE:' WS-DISP-MN-UPD     
           DISPLAY ' # OF ROWS UPDATED TO RG TABLE:' WS-DISP-RG-UPD     
           DISPLAY ' '                                                  
      *                                                                         
           DISPLAY '****************************************'.          
           DISPLAY '** PCSBW171 HAS SUCESSFULLY COMPLETED **'.          
           DISPLAY '****************************************'.          
           DISPLAY ' '.                                                 
      *                                                                         
       9001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************                                     
      **   9700-   BATCH ABEND COPYBOOK  **                                     
      *************************************                                     
      *                                                                         
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      **   9900-   THIS INCLUDES THE DB2 SQL ABEND MODULE           **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
