       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW164.                                        
       DATE-WRITTEN.   JUNE 1998.                                       
      ***************************************************************** 00040000
      **               SOUTH CAROLINA ELECTRIC & GAS                 ** 00050000
      **              COMPLETE BUSINESS SOLUTIONS INC.               ** 00060000
      **                                                             ** 00070000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00080000
      ********                      DB2                       ********* 00090000
      ***************************************************************** 00100000
      **                                                             ** 00110000
      **              PROGRAM  MODIFICATION  LOG                     ** 00120000
      **                                                             ** 00130000
      **    DATE    INITIALS     REASON                              ** 00140000
      **                                                             ** 00130000
C23301**  01/23/01  VIJAY        CHANGES FOR PSNC (MCR - 092)        ** 00150000
C24674**  08/15/01  SS82048      CHANGES TO FIX BTU ERROR NOT GETTING** 00150000
      **                         REPORTED AND TO POPULATE COMMON DATE** 00150000
      **                         IN THE REPORT.                      **         
C23301**  09/05/01  VIJAY        CHANGES FOR PSNC (MCR - 092) TO CHECK* 00150000
      **                         WEATHER TREND FACTORS.                 00150000
BGBG01**  10/25/01  GAUSE        FIX PARA TO ALWAYS PERFORM ABEND    **         
      **                         PARA IF ANY ERR MSG WERE WRITTEN OUT**         
      **                                                             **         
T27237**  12/11/02  JAYANTHI     CIG CHANGES FOR CYCLE 21            **         
      **                                                             **         
T27237**  05/08/03  SK88120      ADDED NEW PARM TO GET CIG OR NON-CIG**         
      **                         RUN                                 **         
      **                                                             **         
T35148**  12/09/06  SP94986      CALCULATE BTU FACTOR AND CHECK      **         
      **                         AGAINST THE LIMITS.                 **         
T35216**  01/04/07  VIJAY        IF FACTOR NOT FOUND (IN 7620-CHK-BTU-* 00150000
T35216**                         IND-FCTR), MOVE ZEROS TO             * 00150000
T35216**                         FE-SPECIFIC-GRAVITY TO AVOID S0C7    * 00150000
T35216**                         ABEND IN 2500-CHECK-BTU-FACTOR.      * 00150000
T35434**  05/10/07 SP94986       REPLACE CSS_MODEL_SQL TO SET COMMANDS* 00150000
T36421**  10/17/07 PG36856       PUT IN CONDITION CODE 05 WHEN ANY    *         
T36421**                         DATA IS MISSING AND ADDED CODE FOR   *         
T36421**                         BTU IND GAS MISSING DATA TO RECIEVE  *         
T36421**                         CONDITION CODE OF 05.                *         
T36421**  11/06/07 PG36856       MOVED INDUSTRIAL BTU TO START ONLY   *         
T36421**                         ON OR AFTER THE 4TH WORKDAY. MOVED   *         
T36421**                         2300- AND 2400- FOR CHANGE.          *         
      **                                                              *         
A36553**  6/20/09  RF10596       CHANGE BILL_WINDOW EXTRACT DATE FROM *         
      **                         THE 4TH OCCURRENCE TO THE 5TH.       *         
      **                         ADD CHECK FOR SPCLFIRM COMPONENT     *         
      **                                                              *         
A36553**  7/08/09  RF10596       SPCLFIRM IS FOR RATES 45 AND 46 ONLY *         
P00411**  7/13/10  VY95550       VALIDATE ELEC_WNA_GROUP_NO TABLE     *         
P00411**                         ENTRIES                              *         
A04319** 10/08/12  HA7A338       ADD SPCL_FCTR CURSOR TO VALIDATE DUPL*         
A04319**                         -ICATE ACTIVE FACTOR IN SPCL_FCT_APPL*         
A04319**                         TABLE.                               *         
ACT239** 12/19/13  VIJAY         SELECT ACTIVE RATES ONLY.            *         
ACT239**  A04527                                                      *         
ACT003** 01/10/14  DB41297       REMOVE WNA CODE.                     *         
ACT003**  A04880                                                      *         
ACT149** 08/10/15  DB41297       SET RETURN CODE FOR ERRORS.          *         
ACT149**  A05361                                                      *         
      **                                                              *         
      ***************************************************************** 00160000
           REMARKS.                                                     
      ***************************************************************** 00190000
      * VERIFY DAILY BTU FACTORS, TEMPERATURES AND WEATHER TREND DATA.* 00200009
      * WILL GIVE AN EXCEPTION REPORT WITH DEATILS WHEREVER ENTRIES   * 00200009
      * NOT FOUND.                                                    * 00200009
      ***************************************************************** 00241009
                                                                        
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
HPCCDM*EJECT                                                            00400000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                    00490007
HPCCDM*EJECT                                                            00520000
      *                                                                 00530000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                    00550107
      *                                                                 00550307
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW164'.
MSQ017     COPY MFASQLM.
       01  WS-START                            PIC X(40) VALUE          
           'WORKING STORAGE FOR PCSBW164 STARTS HERE'.                  
       COPY CWS09900.                                                   00651109
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY FIOJC01.                                                            
      *                                                                 00651000
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                           PIC 9(02).               
           05  WS-MM                           PIC 9(02).               
           05  WS-SS                           PIC 9(02).               
           05  WS-TT                           PIC 9(02).               
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CUR-YY                       PIC 9(02).               
           05  WS-CUR-MM                       PIC 9(02).               
           05  WS-CUR-DD                       PIC 9(02).               
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RUN-DT-MM                    PIC 9(02).               
           05  FILLER                          PIC X(01) VALUE '/'.     
           05  WS-RUN-DT-DD                    PIC 9(02).               
           05  FILLER                          PIC X(01) VALUE '/'.     
           05  WS-RUN-DT-CC                    PIC 9(02).               
           05  WS-RUN-DT-YY                    PIC 9(02).               
      *                                                                         
C24674 01  WS-RPT-COMMON-DATE.                                          
C24674     05  WS-COM-DT-MM                    PIC 9(02).               
C24674     05  FILLER                          PIC X(01) VALUE '/'.     
C24674     05  WS-COM-DT-DD                    PIC 9(02).               
C24674     05  FILLER                          PIC X(01) VALUE '/'.     
C24674     05  WS-COM-DT-CCYY                  PIC 9(04).               
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-E                            PIC X(01)  VALUE 'E'.    
           05  WS-G                            PIC X(01)  VALUE 'G'.    
           05  WS-N                            PIC X(01)  VALUE 'N'.    
           05  WS-Y                            PIC X(01)  VALUE 'Y'.    
T36421     05  WS-COMMON                       PIC X(06)  VALUE         
T36421         'COMMON'.                                                
           05  WS-PGRMNAME                     PIC X(08)  VALUE         
               'PCSBW164'.                                              
      *                                                                 00840000
       01  WS-SWITCHES.                                                 
           05  WS-BTU-FACT-EXISTS              PIC X(01)  VALUE 'N'.    
               88  BTU-FACT-EXISTS                        VALUE 'Y'.    
T27237     05  WS-BTU-IND-FCT-EXISTS           PIC X(01)  VALUE 'N'.    
T27237         88  BTU-IND-FCT-EXISTS                     VALUE 'Y'.    
T27237     05  WS-SPCL-FCTR-EXISTS             PIC X(01)  VALUE 'N'.    
T27237         88  SPCL-FCTR-EXISTS                       VALUE 'Y'.    
           05  WS-TEMP-EXISTS                  PIC X(01)  VALUE 'N'.    
               88  TEMP-EXISTS                            VALUE 'Y'.    
           05  WS-WEATHER-DET-EXISTS           PIC X(01)  VALUE 'N'.    
               88  WEATHER-DET-EXISTS                     VALUE 'Y'.    
T27237     05  WS-CYCLE21-OPEN                 PIC X(01)  VALUE 'N'.    
T27237         88  CYCLE21-OPEN                           VALUE 'Y'.    
T27237     05  WS-BILLING-FACTOR               PIC X(01)  VALUE ' '.    
T27237         88  COGBR-FACTOR                           VALUE 'C'.    
T27237         88  TRNPR-FACTOR                           VALUE 'T'.    
C36553         88  SPCLFIRM-FACTOR                        VALUE 'S'.    
      *                                                                 00847000
       01  WS-ERROR-REC.                                                
           05  FILLER                          PIC X(05) VALUE SPACES.  
           05  WS-ERROR-MSG                    PIC X(45).               
           05  WS-ERROR-FLD.                                            
               10  WS-FLD1                     PIC X(01) VALUE SPACES.  
               10  WS-SEPERATOR                PIC X(01) VALUE ','.     
               10  WS-FLD2                     PIC X(08) VALUE SPACES.  
           05  FILLER                          PIC X(05) VALUE SPACES.  
T27237     05  WS-ERROR-FLD2.                                           
T27237         10  WS-FLD3                     PIC X(10) VALUE SPACES.  
T27237         10  WS-SEPERATOR1               PIC X(01) VALUE SPACES.  
T27237         10  WS-FLD4                     PIC X(10) VALUE SPACES.  
T27237         10  WS-FILLER                   PIC X(05) VALUE SPACES.  
T27237         10  WS-FLD5                     PIC X(10) VALUE SPACES.  
T27237         10  WS-SEPERATOR1               PIC X(01) VALUE SPACES.  
T27237         10  WS-FLD6                     PIC X(10) VALUE SPACES.  
      *                                                                 00847000
       01  WS-MESSAGES.                                                 
           05  WS-BTU-MSG                      PIC X(40) VALUE          
               'BTU-FACTOR ENTRY NOT FOUND FOR THE DAY '.               
           05  WS-TEMP-MSG                     PIC X(42) VALUE          
               'TEMPERATURE DETAILS NOT FOUND FOR THE DAY '.            
           05  WS-WEATHER-MSG                  PIC X(45) VALUE          
               'WEATHER ENTRY NOT FOUND FOR THE COMBINATION '.          
T27237     05  WS-SPEC-MSG                     PIC X(42) VALUE          
T27237         'SPEC GRAVITY DETAILS NOT FOUND FOR THE DAY'.            
T27237     05  WS-FACTOR-MSG                   PIC X(42) VALUE          
T27237         'FACTOR NOT FOUND FOR RATE PLAN            '.            
A04319     05  WS-DUP-FACTOR-MSG               PIC X(45) VALUE          
A04319         'MULTIPLE ACTIVE FACTORS AVLB FOR RATE PLAN #'.          
      *                                                                 00847000
BGBG01 01  WS-WROTE-ERR-MSG                    PIC X(01) VALUE SPACES.  
BGBG01*                                                                 00847000
       01  WS-VARIABLES.                                                
           05  WS-COMMON-DATE                  PIC X(10).               
           05  WS-PREV-DATE                    PIC X(10).               
           05  WS-LINE-COUNT                   PIC 9(02) VALUE 58.      
           05  WS-PAGE-COUNT                   PIC 9(05) VALUE ZEROS.   
           05  WS-DISPLAY-RC                   PIC -ZZZZZZZZ9.9.        
T35148*                                                                         
COB305     05 WS-MMBTU-TOTAL        PIC S9(7)V USAGE COMP-3 VALUE 0. 
COB305     05 WS-MCF-TOTAL        PIC S9(7)V USAGE COMP-3 VALUE 0. 
COB305     05 WS-BTU-FACTOR        PIC S9V9(5) COMP-3 VALUE 0.      
T35148     05  WS-BTU-FACTOR-DISP              PIC 9.9(5).              
COB305     05 WS-BTU-LOWER-LMT-BTUR        PIC S9V9(5) COMP-3 VALUE 0.      
COB305     05 WS-BTU-UPPER-LMT-BTUR        PIC S9V9(5) COMP-3 VALUE 0.      
T35148     05  WS-BTU-UPPER-LMT-DISP           PIC 9.9(5).              
T35148     05  WS-BTU-LOWER-LMT-DISP           PIC 9.9(5).              
T35148     05  WS-PARM-DATA                    PIC X(80).               
T35148*                                                                         
C23301     05  WS-PREV-COMP-NO                 PIC X(02) VALUE SPACES.  
C23301     05  WS-ERROR-FOUND                  PIC X(01) VALUE 'N'.     
C23301     05  WS-REPORT-HEADING               PIC X(01) VALUE 'N'.     
T27237     05  WS-FOURTH-DAY                   PIC X(10).               
T27237     05  WS-MAX-READ-DT                  PIC X(10).               
T27237     05  WS-MIN-READ-DT                  PIC X(10).               
T27237     05  WS-DB2-DATE                     PIC X(10).               
T27237     05  WS-PARM-REVENUE-MONTH.                                   
T27237         10 WS-PARM-REV-YEAR             PIC 9(04).               
T27237         10 WS-PARM-REV-MONTH            PIC 9(02).               
T27237     05  WS-PARM-REV-MONTH-N             REDEFINES                
T27237           WS-PARM-REVENUE-MONTH         PIC 9(06).               
T27237     05  WS-REPORT-TITLE                 PIC X(52)  VALUE SPACES. 
T27237                                                                  
      *                                                                 00849008
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                          PIC X(55)  VALUE SPACES. 
           05  FILLER                          PIC X(22)  VALUE         
               '** NO ERRORS FOUND **'.                                 
           05  FILLER                          PIC X(55)  VALUE SPACES. 
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                          PIC X(55)  VALUE SPACES. 
           05  FILLER                          PIC X(22)  VALUE         
               '*** END OF REPORT ***'.                                 
           05  FILLER                          PIC X(55)  VALUE SPACES. 
      *                                                                         
       01  WS-REPORT-AREA.                                              
           05  HEADER-01.                                               
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  FILLER                      PIC X(08)  VALUE         
                   'PCSBW164'.                                          
               10  FILLER                      PIC X(40)  VALUE SPACES. 
C23301         10  HDR-01-TITLE                PIC X(31).               
               10  FILLER                      PIC X(32)  VALUE SPACES. 
               10  FILLER                      PIC X(10)  VALUE         
                   'RUN DATE: '.                                        
               10  HDR-01-DATE                 PIC X(10).               
      *                                                                         
           05  HEADER-02.                                               
C24674         10  FILLER                      PIC X(01)  VALUE SPACES. 
C24674         10  FILLER                      PIC X(13)  VALUE         
C24674             'COMMON DATE: '.                                     
C24674         10  HDR-02-DATE                 PIC X(10).               
C24674         10  FILLER                      PIC X(16)  VALUE SPACES. 
               10  HDR-02-TITLE                PIC X(52)  VALUE         
               'VERIFY DAILY BTU FACTOR,TEMPS & WEATHER TREND ENTRY'.   
               10  FILLER                      PIC X(20)  VALUE SPACES. 
               10  FILLER                      PIC X(10)  VALUE         
                   'RUN TIME: '.                                        
               10  FILLER                      PIC X(02)  VALUE SPACES. 
               10  HDR-02-TIME.                                         
                   15 HDR-02-HH                PIC X(02)  VALUE SPACES. 
                   15 FILLER                   PIC X(01)  VALUE ':'.    
                   15 HDR-02-MM                PIC X(02)  VALUE SPACES. 
                   15 FILLER                   PIC X(01)  VALUE ':'.    
                   15 HDR-02-SS                PIC X(02)  VALUE SPACES. 
      *                                                                         
           05  HEADER-03.                                               
               10  FILLER                      PIC X(116) VALUE SPACES. 
               10  FILLER                      PIC X(05)  VALUE 'PAGE:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-03-PAGE                 PIC ZZ,ZZ9.              
      *                                                                 00849008
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                 00849008
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                 00849008
           EXEC SQL                                                             
               INCLUDE TBBTUFCT                                                 
           END-EXEC.                                                            
      *                                                                 00849008
           EXEC SQL                                                             
               INCLUDE TBWTHTRD                                                 
           END-EXEC.                                                            
      *                                                                 00849008
           EXEC SQL                                                             
               INCLUDE TBTEMPIN                                                 
           END-EXEC.                                                            
      *                                                                 00849008
C23301     EXEC SQL                                                     01601000
C23301       INCLUDE TBCOMPNY                                           01601100
C23301     END-EXEC.                                                    01601200
      *                                                                 01600900
T27237     EXEC SQL                                                     01601000
T27237       INCLUDE TBBILWDW                                           01601100
T27237     END-EXEC.                                                    01601200
      *                                                                 01600900
T27237     EXEC SQL                                                     01601000
T27237       INCLUDE TBRDWNDW                                           01601100
T27237     END-EXEC.                                                    01601200
      *                                                                 01600900
T27237     EXEC SQL                                                     01601000
T27237       INCLUDE TBBTUIND                                           01601100
T27237     END-EXEC.                                                    01601200
      *                                                                 01600900
T27237     EXEC SQL                                                     01601000
T27237       INCLUDE TBINDFCT                                           01601100
T27237     END-EXEC.                                                    01601200
      *                                                                 01600900
T27237     EXEC SQL                                                     01601000
T27237       INCLUDE TBSPLAPL                                           01601100
T27237     END-EXEC.                                                    01601200
      *                                                                 01600900
T27237     EXEC SQL                                                     01601000
T27237       INCLUDE TBRTCDEF                                           01601100
T27237     END-EXEC.                                                    01601200
      *                                                                 01600900
           EXEC SQL                                                             
               INCLUDE CWS00037                                                 
           END-EXEC.                                                            
      *                                                                 00849008
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
                                                                        
       01  WS-INPUT-DATA-R99    REDEFINES WS-INPUT-DATA-BREAKDOWN.      
           05 IN-FACTOR               PIC X(06).                        
           05 FILLER                  PIC X(01).                        
           05 IN-BILLING-FACTOR       PIC X(09).                        
           05 FILLER                  PIC X(12).                        
           05 IN-CMPNT-ID-CD          PIC X(03).                        
           05 FILLER                  PIC X(56).                        
                                                                        
      *                                                                 00849008
C23301     EXEC SQL DECLARE COMPANY-CURSOR CURSOR FOR                   
C23301        SELECT COMPANY_NO,                                        
C23301               COMPANY_NAME,                                      
C23301               TEMPERATURE_REQ_FL,                                
C23301               BTU_FACTOR_REQ_FL,                                 
C23301               WEATHER_TND_REQ_FL,                                
C23301               CALC_WNA_METHOD_CD                                 
C23301          FROM CSS_COMPANY WITH(READUNCOMMITTED)                          
C23301         WHERE TEMPERATURE_REQ_FL = 'Y'                           
C23301            OR BTU_FACTOR_REQ_FL  = 'Y'                           
C23301            OR WEATHER_TND_REQ_FL = 'Y'                           
C23301      ORDER BY COMPANY_NO                                         
T35434      FOR READ ONLY                                       
C23301     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE COMPANY-CURSOR CURSOR FOR                   00849008
MFA-TR*       SELECT COMPANY_NO,                                        00849008
MFA-TR*              COMPANY_NAME,                                      00849008
MFA-TR*              TEMPERATURE_REQ_FL,                                00849008
MFA-TR*              BTU_FACTOR_REQ_FL,                                 00849008
MFA-TR*              WEATHER_TND_REQ_FL,                                00849008
MFA-TR*              CALC_WNA_METHOD_CD                                 00849008
MFA-TR*         FROM CSS_COMPANY                                        00849008
MFA-TR*        WHERE TEMPERATURE_REQ_FL = 'Y'                           00849008
MFA-TR*           OR BTU_FACTOR_REQ_FL  = 'Y'                           00849008
MFA-TR*           OR WEATHER_TND_REQ_FL = 'Y'                           00849008
MFA-TR*     ORDER BY COMPANY_NO                                         00849008
MFA-TR*     FOR FETCH ONLY WITH UR                                      00849008
MFA-TR*    END-EXEC.                                                    00849008
      *                                                                 00849008
T27237     EXEC SQL DECLARE BTUID-CRSR CURSOR FOR                       
T27237        SELECT INDUST_BTU_ID,                                     
T27237               SPEC_GRAVITY_FL                                    
T27237          FROM CSS_BTU_INDUST WITH(READUNCOMMITTED)                       
T27237         WHERE COMPANY_NO = '01'                                  
T27237           AND STATUS_CD  = 'A'                                   
T27237      ORDER BY INDUST_BTU_ID                                      
T35434      FOR READ ONLY                                       
T27237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE BTUID-CRSR CURSOR FOR                       00849008
MFA-TR*       SELECT INDUST_BTU_ID,                                     00849008
MFA-TR*              SPEC_GRAVITY_FL                                    00849008
MFA-TR*         FROM CSS_BTU_INDUST                                     00849008
MFA-TR*        WHERE COMPANY_NO = '01'                                  00849008
MFA-TR*          AND STATUS_CD  = 'A'                                   00849008
MFA-TR*     ORDER BY INDUST_BTU_ID                                      00849008
MFA-TR*     FOR FETCH ONLY WITH UR                                      00849008
MFA-TR*    END-EXEC.                                                    00849008
      *                                                                 00849008
T27237     EXEC SQL DECLARE RATES-CURSOR CURSOR FOR                     
ACT239         SELECT DISTINCT J1.RATE_PLAN_NO                          
T27237           FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                
ACT239              , CSS_RATE_CREATOR  RT WITH(READUNCOMMITTED)                
T27237          WHERE CMPNT_ID_CD         = :J1-CMPNT-ID-CD             
ACT239            AND J1.RATE_PLAN_NO     = RT.RATE_PLAN_NO             
ACT239            AND J1.VERSION_NO_CNTRL = RT.VERSION_NO_CNTRL         
ACT239            AND RT.CODE_STATUS      = 'A'                         
T27237      ORDER BY RATE_PLAN_NO                                       
T35434      FOR READ ONLY                                       
T27237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE RATES-CURSOR CURSOR FOR                             
MFA-TR*        SELECT DISTINCT J1.RATE_PLAN_NO                                  
MFA-TR*          FROM CSS_RATE_COMP_DEF J1                                      
MFA-TR*             , CSS_RATE_CREATOR  RT                                      
MFA-TR*         WHERE CMPNT_ID_CD         = :J1-CMPNT-ID-CD                     
MFA-TR*           AND J1.RATE_PLAN_NO     = RT.RATE_PLAN_NO                     
MFA-TR*           AND J1.VERSION_NO_CNTRL = RT.VERSION_NO_CNTRL                 
MFA-TR*           AND RT.CODE_STATUS      = 'A'                                 
MFA-TR*     ORDER BY RATE_PLAN_NO                                       00849008
MFA-TR*     FOR FETCH ONLY WITH UR                                      00849008
MFA-TR*    END-EXEC.                                                            
      *                                                                 00849008
T27237     EXEC SQL DECLARE BILLDAY-CRSR CURSOR FOR                     
T27237         SELECT DATE_EXTRACT                                      
T27237           FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
T27237          WHERE BILL_CYCLE    = '21'                              
T27237            AND REVENUE_MONTH = :BN-REVENUE-MONTH                 
T27237      ORDER BY DATE_EXTRACT                                       
T35434      FOR READ ONLY                                       
T27237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE BILLDAY-CRSR CURSOR FOR                             
MFA-TR*        SELECT DATE_EXTRACT                                              
MFA-TR*          FROM CSS_BILL_WINDOW                                           
MFA-TR*         WHERE BILL_CYCLE    = '21'                                      
MFA-TR*           AND REVENUE_MONTH = :BN-REVENUE-MONTH                         
MFA-TR*     ORDER BY DATE_EXTRACT                                       00849008
MFA-TR*     FOR FETCH ONLY WITH UR                                      00849008
MFA-TR*    END-EXEC.                                                            
      *                                                                 00849008
A04319     EXEC SQL DECLARE SPCL-FCTR-CSR CURSOR FOR                    
A04319        SELECT SA.CODE_UTIL_TYPE                                  
A04319              ,SA.RATE_PLAN_NO                                    
A04319              ,SA.FACTOR_ID                                       
A04319              ,SA.CMPNT_ID_CD                                     
A04319              ,SA.BLOCK_NO                                        
A04319              ,SA.CODE_SEASON                                     
A04319              ,SA.CODE_TIME_PERIOD                                
A04319              ,SA.INSTR_USE_TYPE_CD                               
A04319          FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                
A04319         WHERE SA.CODE_UTIL_TYPE   > ' '                          
A04319           AND SA.DATE_FROM       <= IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )              
A04319           AND SA.DATE_TO         >= IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )              
A04319           AND SA.CODE_STATUS     IN ('A','E')                    
A04319        GROUP BY SA.CODE_UTIL_TYPE                                
A04319                ,SA.RATE_PLAN_NO                                  
A04319                ,SA.FACTOR_ID                                     
A04319                ,SA.CMPNT_ID_CD                                   
A04319                ,SA.BLOCK_NO                                      
A04319                ,SA.CODE_SEASON                                   
A04319                ,SA.CODE_TIME_PERIOD                              
A04319                ,SA.INSTR_USE_TYPE_CD                             
A04319        HAVING COUNT(*) > 1                                       
A04319        FOR READ ONLY                                     
A04319                                                      
A04319     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE SPCL-FCTR-CSR CURSOR FOR                            
MFA-TR*       SELECT SA.CODE_UTIL_TYPE                                          
MFA-TR*             ,SA.RATE_PLAN_NO                                            
MFA-TR*             ,SA.FACTOR_ID                                               
MFA-TR*             ,SA.CMPNT_ID_CD                                             
MFA-TR*             ,SA.BLOCK_NO                                                
MFA-TR*             ,SA.CODE_SEASON                                             
MFA-TR*             ,SA.CODE_TIME_PERIOD                                        
MFA-TR*             ,SA.INSTR_USE_TYPE_CD                                       
MFA-TR*         FROM CSS_SPCL_FCTR_APPL SA                                      
MFA-TR*        WHERE SA.CODE_UTIL_TYPE   > ' '                                  
MFA-TR*          AND SA.DATE_FROM       <= :WS-COMMON-DATE                      
MFA-TR*          AND SA.DATE_TO         >= :WS-COMMON-DATE                      
MFA-TR*          AND SA.CODE_STATUS     IN ('A','E')                            
MFA-TR*       GROUP BY SA.CODE_UTIL_TYPE                                        
MFA-TR*               ,SA.RATE_PLAN_NO                                          
MFA-TR*               ,SA.FACTOR_ID                                             
MFA-TR*               ,SA.CMPNT_ID_CD                                           
MFA-TR*               ,SA.BLOCK_NO                                              
MFA-TR*               ,SA.CODE_SEASON                                           
MFA-TR*               ,SA.CODE_TIME_PERIOD                                      
MFA-TR*               ,SA.INSTR_USE_TYPE_CD                                     
MFA-TR*       HAVING COUNT(*) > 1                                               
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7890                                                      
MFA-TR*    END-EXEC.                                                            
A04319*                                                                 00849008
       01  WS-END                              PIC X(40) VALUE          
           'WORKING STORAGE FOR PCSBW164 ENDS HERE  '.                  
HPCCDM*EJECT                                                            02830000
      *                                                                 02840000
T27237 LINKAGE SECTION.                                                 
T27237 01  PARM-CODE.                                                   
T27237     02  LINK-PARM               PIC S9999 COMP.                  
T27237     02  PARM-VAL                PIC XXX.                         
      *                                                                 02840000
T27237 PROCEDURE DIVISION USING PARM-CODE.                              
T27237*PROCEDURE DIVISION.                                              02871005
      ******************************************************************02880000
      *   CONTROLS MAIN PATH OF PROGRAM                                *02890000
      ******************************************************************02900000
       0000-MAINLINE.                                                   
      *                                                                 02920000
           PERFORM 1000-INITIALIZE THRU 1000-EXIT.                      
      *                                                                 02940000
           PERFORM 2000-MAIN-PROCESS THRU 2000-EXIT.                    
      *                                                                 02960000
           STOP RUN.                                                    
      *                                                                 03000000
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            03030000
      ******************************************************************03040000
      *   INITIALIZATION ROUTINE                                       *03050000
      ******************************************************************03060000
       1000-INITIALIZE.                                                 
      *                                                                 03080000
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                          TO  HDR-02-HH.           
           MOVE WS-MM                          TO  HDR-02-MM.           
           MOVE WS-SS                          TO  HDR-02-SS.           
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CUR-YY                      TO WS-RUN-DT-YY.         
           MOVE WS-CUR-MM                      TO WS-RUN-DT-MM.         
           MOVE WS-CUR-DD                      TO WS-RUN-DT-DD.         
           IF  WS-CUR-YY > 50                                           
               MOVE 19                         TO WS-RUN-DT-CC          
           ELSE                                                         
               MOVE 20                         TO WS-RUN-DT-CC          
           END-IF.                                                      
      *                                                                         
           MOVE WS-RUN-DATE                    TO HDR-01-DATE.          
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
T36421     PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
T36421     IF COMMON-DATE-NEEDED                                        
T36421        MOVE WS-COMMON              TO WS-PGRMNAME                
T36421        PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT           
T36421        MOVE 'PCSBW164'             TO WS-PGRMNAME                
T36421     END-IF.                                                      
T36421*                                                                         
           MOVE WS-INPUT-DATE                  TO WS-COMMON-DATE.       
C24674     MOVE WS-COMMON-DATE(1:4)            TO WS-COM-DT-CCYY.       
C24674     MOVE WS-COMMON-DATE(6:2)            TO WS-COM-DT-MM.         
C24674     MOVE WS-COMMON-DATE(9:2)            TO WS-COM-DT-DD.         
C24674     MOVE WS-RPT-COMMON-DATE             TO HDR-02-DATE.          
      *                                                                         
T35148     PERFORM 1100-SELECT-MAX-MIN-LMT     THRU 1100-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03320000
T35148****************************************************************          
T35148* 1100-SELECT-MAX-MIN-LMT PARA.                                *          
T35148* SELECT THE UPPER AND LOWER LIMIT FROM THE CSS_BTU_WNA_RANGE  *          
T35148* TABLE.                                                       *          
T35148****************************************************************          
T35148 1100-SELECT-MAX-MIN-LMT.                                         
T35148                                                                  
T27237      EXEC SQL                                                    
T35148         SELECT MIN(BTU_LOWER_LIMIT)                              
T35148               ,MAX(BTU_UPPER_LIMIT)                              
T35148          INTO :WS-BTU-LOWER-LMT-BTUR                             
T35148              ,:WS-BTU-UPPER-LMT-BTUR                             
T35148         FROM   CSS_BTU_WNA_RANGE                                 
T35148         WHERE CODE_UTIL_TYPE = 'G'                               
T27237      END-EXEC                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35148                                                                  
T35148       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
T35148                                                                  
T35148       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
T35148          MOVE WS-BTU-LOWER-LMT-BTUR   TO WS-BTU-LOWER-LMT-DISP   
T35148          MOVE WS-BTU-UPPER-LMT-BTUR   TO WS-BTU-UPPER-LMT-DISP   
T35148       ELSE                                                       
T35148          MOVE '1100'                TO ACTIVE-PARAGRAPH          
T35148          MOVE 'SELECT'              TO ABEND-FUNCTION            
T35148          MOVE 'CSS_BTU_WNA_RANGE'   TO TABLE-1                   
T35148          MOVE 'LIMITS     '         TO TABLE-ELEMENT-1           
T35148          MOVE SQLCODE               TO HOSTVAR-ELEMENT-1         
T35148          PERFORM 9900-ABEND THRU 9900-EXIT                       
T35148       END-IF.                                                    
T35148                                                                  
T35148 1100-EXIT.                                                       
T35148      EXIT.                                                       
                                                                        
      ******************************************************************03330000
      *   MAIN PROCESS                                                 *03340000
      ******************************************************************03350000
       2000-MAIN-PROCESS.                                               
      *                                                                 03370000
C23301     MOVE WS-N                           TO WS-ERROR-FOUND.       
C23301     PERFORM 7300-OPEN-COMPANY-CURSOR THRU 7300-EXIT.             
C23301     PERFORM 7350-FETCH-COMPANY-CURSOR THRU 7350-EXIT.            
C23301     PERFORM 2050-CHECK-PROCESS THRU 2050-EXIT                    
C23301             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
C23301     PERFORM 7400-CLOSE-COMPANY-CURSOR THRU 7400-EXIT.            
C23301*                                                                 03450000
C23301     IF  WS-ERROR-FOUND = WS-N                                    
C23301        WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER 2           
T36421     END-IF.                                                      
A04319                                                                  
A04319     PERFORM 2800-VLDT-SPCL-FCTR-DATA  THRU 2800-EXIT.            
C23301*                                                                 03450000
C23301     IF  WS-ERROR-FOUND = WS-Y                                    
T36421         MOVE 02  TO  RETURN-CODE                                 
T36421     END-IF.                                                      
A04319                                                                  
BGBG01     IF WS-WROTE-ERR-MSG NOT = SPACES                             
BGBG01         WRITE PRT33-RECORD FROM WS-END-DATA-LINE AFTER 2         
BGBG01         DISPLAY 'BTU/TEMPERATURE/WEATHER DATA NOT FOUND'         
BGBG01         DISPLAY 'CHECK REPORT FOR MISSING DATA'                  
T36421         MOVE 05  TO  RETURN-CODE                                 
T36421     END-IF.                                                      
      *                                                                         
BGBG01     PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                 03429008
       2000-EXIT.                                                       
           EXIT.                                                        
C23301                                                                  
C23301******************************************************************03330000
C23301*   CHECK PROCESS                                                *03340000
C23301******************************************************************03350000
C23301 2050-CHECK-PROCESS.                                              
C23301*                                                                 03370000
C23301     IF  C7-COMPANY-NO NOT EQUAL WS-PREV-COMP-NO                  
C23301         IF  WS-ERROR-FOUND = WS-N AND                            
C23301             WS-PREV-COMP-NO NOT = SPACES                         
C23301             WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER 2      
C23301         END-IF                                                   
C23301         MOVE WS-N                       TO WS-ERROR-FOUND        
C23301         MOVE WS-Y                       TO WS-REPORT-HEADING     
C23301         MOVE C7-COMPANY-NO              TO WS-PREV-COMP-NO       
C23301         MOVE C7-COMPANY-NAME            TO HDR-01-TITLE          
C23301         MOVE 58                         TO WS-LINE-COUNT         
C23301         PERFORM 8000-WRITE-FCSPT33 THRU 8000-EXIT                
C23301         MOVE WS-N                       TO WS-REPORT-HEADING     
C23301     END-IF.                                                      
C23301*                                                                 03429008
C23301     MOVE C7-COMPANY-NO                  TO WT-COMPANY-NO         
C23301                                            TF-COMPANY-NO         
C23301                                            E8-COMPANY-NO         
C23301                                            FE-COMPANY-NO.        
C23301*                                                                 03429008
C23301     MOVE WS-COMMON-DATE                 TO WT-DATE-BILL          
C23301                                            WS-PREV-DATE          
T27237                                            BN-DATE-EXTRACT.      
C23301*                                                                 03429008
C23301     PERFORM 2100-CHECK-BTU-TEMP-DET THRU 2100-EXIT               
C23301*                                                                 29008   
C23301     IF C7-WEATHER-TND-REQ-FL = 'Y'                               
C23301       IF C7-CALC-WNA-METHOD-CD = 'S'                             
C23301          PERFORM 2200-CHECK-WEATHER-ELEC THRU 2200-EXIT          
C23301          PERFORM 2205-CHECK-WEATHER-GAS THRU 2205-EXIT           
C23301       ELSE                                                       
C23301          IF C7-CALC-WNA-METHOD-CD = 'P'                          
C23301             PERFORM 2206-CHECK-WEATHER-PSNC THRU 2206-EXIT       
C23301          END-IF                                                  
C23301       END-IF                                                     
C23301     END-IF                                                       
C23301*                                                                 03450000
T27237     IF C7-COMPANY-NO = '01'                                      
T27237        PERFORM 7500-CHK-CYC21-OPEN     THRU 7500-EXIT            
T27237        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T27237           MOVE 'Y'                     TO WS-CYCLE21-OPEN        
T27237        END-IF                                                    
T27237        IF CYCLE21-OPEN                                           
T27237           IF  WS-ERROR-FOUND = WS-N                              
T27237              MOVE 58                      TO WS-LINE-COUNT       
T27237              WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER 2     
T27237           END-IF                                                 
T27237           MOVE HDR-02-TITLE            TO WS-REPORT-TITLE        
T27237           MOVE 'VERIFICATION OF CIG BILLING REQUIREMENTS'        
T27237                                        TO HDR-02-TITLE           
T27237           MOVE 58                      TO WS-LINE-COUNT          
T27237           PERFORM 2600-GET-FOURTH-DAY  THRU 2600-EXIT            
T27237           IF WS-COMMON-DATE >= WS-FOURTH-DAY                     
T36421              PERFORM 2300-GET-MIN-MAX-DATE   THRU 2300-EXIT      
T36421              PERFORM 2400-CHK-BTU-FCTR-CYC21 THRU 2400-EXIT      
T27237              PERFORM 2700-CHK-BILLING-FACTOR THRU 2700-EXIT      
T27237           END-IF                                                 
T27237           MOVE 'N'                     TO WS-CYCLE21-OPEN        
T27237           MOVE WS-REPORT-TITLE         TO HDR-02-TITLE           
T27237        END-IF                                                    
T27237     END-IF                                                       
C23301*                                                                 29008   
C23301     PERFORM 7350-FETCH-COMPANY-CURSOR THRU 7350-EXIT.            
C23301*                                                                 03429008
C23301 2050-EXIT.                                                       
C23301     EXIT.                                                        
      *                                                                 03450000
      ******************************************************************03330000
      *   CHECKS BTU-FACTOR & TEMPERATURE ENTRIES                      *03340000
      ******************************************************************03350000
       2100-CHECK-BTU-TEMP-DET.                                         
      *                                                                 03450000
           PERFORM 5 TIMES                                              
               PERFORM 7100-GET-PREV-DATE THRU 7100-EXIT                
               MOVE WS-PREV-DATE               TO TF-BTU-DT             
                                                  E8-TEMP-DT            
C24674         MOVE WS-N                       TO WS-BTU-FACT-EXISTS    
C23301         IF C7-BTU-FACTOR-REQ-FL = 'Y'                            
                  PERFORM 7150-SELECT-BTU-FACT THRU 7150-EXIT           
                  IF  BTU-FACT-EXISTS                                   
T35148                PERFORM 2750-CHK-BTU-FACTOR-LIMTS THRU 2750-EXIT  
                  ELSE                                                  
BGBG01                MOVE 'X' TO WS-WROTE-ERR-MSG                      
                      MOVE WS-BTU-MSG             TO WS-ERROR-MSG       
                      MOVE WS-PREV-DATE           TO WS-ERROR-FLD       
T27237                MOVE SPACES                 TO WS-ERROR-FLD2      
                      PERFORM 8000-WRITE-FCSPT33 THRU 8000-EXIT         
                  END-IF                                                
C23301         END-IF                                                   
                                                                        
C24674         MOVE WS-N                          TO WS-TEMP-EXISTS     
C23301         IF C7-TEMPERATURE-REQ-FL = 'Y'                           
                  PERFORM 7200-SELECT-TEMPERATURE THRU 7200-EXIT        
                  IF  TEMP-EXISTS                                       
                      CONTINUE                                          
                  ELSE                                                  
BGBG01                MOVE 'X' TO WS-WROTE-ERR-MSG                      
                      MOVE WS-TEMP-MSG            TO WS-ERROR-MSG       
                      MOVE WS-PREV-DATE           TO WS-ERROR-FLD       
T27237                MOVE SPACES                 TO WS-ERROR-FLD2      
                      PERFORM 8000-WRITE-FCSPT33 THRU 8000-EXIT         
                  END-IF                                                
C23301         END-IF                                                   
           END-PERFORM.                                                 
      *                                                                 03450000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03450000
      ******************************************************************03330000
      *   CHECKS WEATHER-TREND DATA FOR ALL COMBINATIONS OF DATA       *03340000
      ******************************************************************03350000
       2200-CHECK-WEATHER-ELEC.                                         
      *                                                                 03450000
           MOVE ','                            TO WS-SEPERATOR.         
           MOVE WS-E                           TO WT-CODE-UTIL-TYPE.    
           MOVE '000'                          TO WT-CODE-REVENUE-CLASS.
           PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
      *                                                                 03450000
           MOVE '010'                          TO WT-CODE-REVENUE-CLASS.
           PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
      *                                                                 03450000
           MOVE '020'                          TO WT-CODE-REVENUE-CLASS.
           PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
      *                                                                 03450000
           MOVE '030'                          TO WT-CODE-REVENUE-CLASS.
           PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
      *                                                                 03450000
           MOVE '060'                          TO WT-CODE-REVENUE-CLASS.
           PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
      *                                                                 03450000
           MOVE '070'                          TO WT-CODE-REVENUE-CLASS.
           PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
      *                                                                 03450000
           MOVE '910'                          TO WT-CODE-REVENUE-CLASS.
           PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
      *                                                                 03450000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03450000
      ******************************************************************03330000
      * CHECKS WEATHER-TREND DATA FOR ALL COMBINATIONS OF DATA FOR SCEG 03340000
      ******************************************************************03350000
       2205-CHECK-WEATHER-GAS .                                         
      *                                                                 03450000
           MOVE ','                            TO WS-SEPERATOR.         
           MOVE WS-G                           TO WT-CODE-UTIL-TYPE.    
           MOVE '000'                          TO WT-CODE-REVENUE-CLASS.
           PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
      *                                                                 03450000
           MOVE '010'                          TO WT-CODE-REVENUE-CLASS.
           PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
      *                                                                 03450000
           MOVE '020'                          TO WT-CODE-REVENUE-CLASS.
           PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
      *                                                                 03450000
           MOVE '030'                          TO WT-CODE-REVENUE-CLASS.
           PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
      *                                                                 03450000
       2205-EXIT.                                                       
           EXIT.                                                        
C23301                                                                  
C23301******************************************************************03330000
C23301* CHECKS WEATHER-TREND DATA FOR ALL COMBINATIONS OF DATA FOR PSNC 03340000
C23301******************************************************************03350000
C23301 2206-CHECK-WEATHER-PSNC.                                         
C23301*                                                                 03450000
C23301     MOVE ','                            TO WS-SEPERATOR.         
C23301     MOVE WS-G                           TO WT-CODE-UTIL-TYPE.    
C23301     MOVE '000'                          TO WT-CODE-REVENUE-CLASS.
C23301     PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
C23301*                                                                 03450000
C23301     MOVE '010'                          TO WT-CODE-REVENUE-CLASS.
C23301     PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
C23301*                                                                 03450000
C23301     MOVE '020'                          TO WT-CODE-REVENUE-CLASS.
C23301     PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
C23301*                                                                 03450000
C23301     MOVE '030'                          TO WT-CODE-REVENUE-CLASS.
C23301     PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
C23301*                                                                 03450000
C23301     MOVE '040'                          TO WT-CODE-REVENUE-CLASS.
C23301     PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
C23301*                                                                 03450000
C23301     MOVE '050'                          TO WT-CODE-REVENUE-CLASS.
C23301     PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
C23301*                                                                 03450000
C23301     MOVE '060'                          TO WT-CODE-REVENUE-CLASS.
C23301     PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
C23301*                                                                 03450000
C23301     MOVE '070'                          TO WT-CODE-REVENUE-CLASS.
C23301     PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
C23301*                                                                 03450000
C23301     MOVE '080'                          TO WT-CODE-REVENUE-CLASS.
C23301     PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
C23301*                                                                 03450000
C23301     MOVE '090'                          TO WT-CODE-REVENUE-CLASS.
C23301     PERFORM 2210-VERIFY-WEATHER-ENTRY THRU 2210-EXIT.            
C23301*                                                                 03450000
C23301 2206-EXIT.                                                       
C23301     EXIT.                                                        
      *                                                                 03450000
       2210-VERIFY-WEATHER-ENTRY.                                       
      *                                                                 03450000
           MOVE WS-N                           TO WS-WEATHER-DET-EXISTS.
           PERFORM 7250-SELECT-WEATHER-TREND THRU 7250-EXIT.            
           IF  WEATHER-DET-EXISTS                                       
               CONTINUE                                                 
           ELSE                                                         
BGBG01         MOVE 'X' TO WS-WROTE-ERR-MSG                             
               MOVE WS-WEATHER-MSG             TO WS-ERROR-MSG          
               MOVE WT-CODE-UTIL-TYPE          TO WS-FLD1               
               MOVE WT-CODE-REVENUE-CLASS      TO WS-FLD2               
T27237         MOVE SPACES                     TO WS-ERROR-FLD2         
               PERFORM 8000-WRITE-FCSPT33 THRU 8000-EXIT                
           END-IF.                                                      
      *                                                                 03450000
       2210-EXIT.                                                       
           EXIT.                                                        
T27237*                                                                 03450000
T27237******************************************************************04414100
T27237*   CHECKS MINIMUM AND MAXIMUM READ DATE                         *03340000
T27237******************************************************************04414300
T27237*                                                                 03450000
T27237 2300-GET-MIN-MAX-DATE.                                           
T27237*                                                                 03450000
T27237     MOVE '21'                          TO RW-READ-CYCLE          
T27237     MOVE BN-REVENUE-MONTH              TO RW-REVENUE-MONTH       
T27237     PERFORM 7800-SELECT-OPT-READ-DT    THRU 7800-EXIT            
T27237     MOVE RW-OPTIMUM-READ-DATE          TO WS-MAX-READ-DT         
T27237*                                                                         
T27237     MOVE BN-REVENUE-MONTH              TO WS-PARM-REV-MONTH-N.   
T27237     COMPUTE WS-PARM-REV-MONTH = WS-PARM-REV-MONTH - 1            
T27237     IF  WS-PARM-REV-MONTH = 0                                    
T27237         COMPUTE WS-PARM-REV-MONTH = 12                           
T27237         COMPUTE WS-PARM-REV-YEAR     = WS-PARM-REV-YEAR - 1      
T27237     END-IF.                                                      
T27237*                                                                         
T27237     MOVE WS-PARM-REV-MONTH-N           TO RW-REVENUE-MONTH.      
T27237     PERFORM 7800-SELECT-OPT-READ-DT    THRU 7800-EXIT.           
T27237     MOVE RW-OPTIMUM-READ-DATE          TO WS-DB2-DATE.           
T27237     PERFORM 7810-GET-NEXT-DAY          THRU 7810-EXIT            
T27237     MOVE WS-DB2-DATE                   TO WS-MIN-READ-DT.        
T27237*                                                                         
T27237 2300-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                 03450000
      ******************************************************************04414100
      *   CHECKS BTU-FACTOR & TEMPERATURE ENTRIES                      *03340000
      ******************************************************************04414300
      *                                                                 03450000
T27237 2400-CHK-BTU-FCTR-CYC21.                                         
T27237*                                                                 03450000
T27237     PERFORM 7710-OPEN-BTUID-CURSOR    THRU 7710-EXIT             
T27237     PERFORM 7720-FETCH-BTUID-CURSOR   THRU 7720-EXIT             
T27237     MOVE WS-MIN-READ-DT               TO WS-DB2-DATE             
T27237     PERFORM 2500-CHECK-BTU-FACTOR     THRU 2500-EXIT             
T27237             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
T27237     PERFORM 7730-CLOSE-BTUID-CURSOR   THRU 7730-EXIT.            
T27237*                                                                 03450000
T27237 2400-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                 03450000
T27237 2500-CHECK-BTU-FACTOR.                                           
T27237*                                                                 03450000
T27237     PERFORM UNTIL WS-DB2-DATE > WS-MAX-READ-DT                   
T27237        MOVE FD-INDUST-BTU-ID             TO FE-INDUST-BTU-ID     
T27237        PERFORM 7620-CHK-BTU-IND-FCTR     THRU 7620-EXIT          
T27237        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T27237           MOVE 'Y'                   TO WS-BTU-IND-FCT-EXISTS    
T36421        ELSE                                                      
T36421           MOVE 'X'                       TO WS-WROTE-ERR-MSG     
T27237           MOVE WS-BTU-MSG                TO WS-ERROR-MSG         
T27237           MOVE FE-BTU-DT                 TO WS-ERROR-FLD         
T27237           MOVE 'TABLE-ID  '              TO WS-FLD3              
T27237           MOVE FE-INDUST-BTU-ID          TO WS-FLD4              
T27237           PERFORM 8000-WRITE-FCSPT33     THRU 8000-EXIT          
T27237        END-IF                                                    
T27237        IF FD-SPEC-GRAVITY-FL = 'Y'                               
T27237           IF FE-SPECIFIC-GRAVITY > ZEROES                        
T27237              CONTINUE                                            
T27237           ELSE                                                   
T36421              MOVE 'X'                       TO WS-WROTE-ERR-MSG  
T27237              MOVE WS-SPEC-MSG               TO WS-ERROR-MSG      
T27237              MOVE FE-BTU-DT                 TO WS-ERROR-FLD      
T27237              MOVE 'TABLE-ID  '              TO WS-FLD3           
T27237              MOVE FE-INDUST-BTU-ID          TO WS-FLD4           
T27237              PERFORM 8000-WRITE-FCSPT33     THRU 8000-EXIT       
T27237           END-IF                                                 
T27237        END-IF                                                    
T27237        PERFORM 7810-GET-NEXT-DAY            THRU 7810-EXIT       
T27237     END-PERFORM                                                  
T27237     PERFORM 7720-FETCH-BTUID-CURSOR         THRU 7720-EXIT       
T27237     MOVE WS-MIN-READ-DT                     TO WS-DB2-DATE       
T27237                                                FE-BTU-DT.        
T27237*                                                                 03450000
T27237 2500-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                 03450000
T27237 2600-GET-FOURTH-DAY.                                             
T27237*                                                                 03450000
T27237     PERFORM 7950-OPEN-BILLDAY-CURSOR    THRU 7950-EXIT           
T27237     PERFORM 7960-FETCH-BILLDAY-CURSOR   THRU 7960-EXIT           
A36553             5 TIMES                                              
T27237     PERFORM 7970-CLOSE-BILLDAY-CURSOR   THRU 7970-EXIT           
T27237     .                                                            
T27237 2600-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                 03450000
T27237 2700-CHK-BILLING-FACTOR.                                         
T27237*                                                                 03450000
T27237     MOVE  WS-PGRMNAME           TO WS-PROGRAM                    
T27237     MOVE  WS-PARM               TO WS-COMMAND                    
T27237     MOVE  ZEROS                 TO WS-SEQUENCE                   
T27237     MOVE  SPACES                TO WS-SYSIPT                     
T27237     MOVE  WS-KEY-AREA           TO E-FJC01-KEY                   
T27237     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT                  
T27237     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
T27237         UNTIL (IN-FACTOR EQUAL 'FACTOR' AND INPUT-ACTIVE)        
T27237            OR  END-OF-SYSIPT.                                    
      *                                                                 03450000
C36553     IF END-OF-SYSIPT                                             
C36553         DISPLAY ' '                                              
C36553         DISPLAY '** ' WS-PGRMNAME ' INFORMATIONAL MSG **'        
C36553         DISPLAY '**   BILLING FACTOR NOT FOUND'                  
C36553         DISPLAY '**    KEY = ' E-FJC01-KEY                       
C36553         DISPLAY '**  PROCESSING CONTINUES   **'                  
C36553     ELSE                                                         
C36553         IF IN-CMPNT-ID-CD = SPACES                               
C36553            DISPLAY ' '                                           
C36553            DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR **'      
C36553            DISPLAY '**   CMPNT-ID-CD NOT VALID'                  
C36553            DISPLAY '**    KEY = ' E-FJC01-KEY                    
C36553            DISPLAY '**  PROCESSING TERMINATED  **'               
C36553            PERFORM 9900-ABEND THRU 9900-EXIT                     
C36553         ELSE                                                     
C36553            IF IN-BILLING-FACTOR = 'COG BR   ' OR                 
C36553               'TRNSPURCH' OR 'SPCLFIRM '                         
C36553               PERFORM 2710-PROCESS-BILL-FACTOR THRU 2710-EXIT    
C36553                       UNTIL END-OF-SYSIPT                        
C36553               IF WS-WROTE-ERR-MSG = SPACES                       
C36553                  MOVE 58   TO WS-LINE-COUNT                      
C36553                  MOVE WS-Y TO WS-REPORT-HEADING                  
C36553                  PERFORM 8000-WRITE-FCSPT33 THRU 8000-EXIT       
C36553                  MOVE WS-N TO WS-REPORT-HEADING                  
C36553               ELSE                                               
C36553                  IF PARM-VAL = 'CIG'                             
C36553                     CONTINUE                                     
C36553                  ELSE                                            
C36553                     MOVE SPACES TO WS-WROTE-ERR-MSG              
C36553                  END-IF                                          
C36553               END-IF                                             
C36553            ELSE                                                  
C36553               DISPLAY ' '                                        
C36553               DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR **'   
C36553               DISPLAY '**   BILLING FACTOR NOT VALID'            
C36553               DISPLAY '**    KEY = ' E-FJC01-KEY                 
C36553               DISPLAY '**  PROCESSING TERMINATED  **'            
C36553               PERFORM 9900-ABEND THRU 9900-EXIT                  
C36553            END-IF                                                
C36553         END-IF                                                   
C36553     END-IF.                                                      
      *                                                                 03450000
T27237 2700-EXIT.                                                       
T27237     EXIT.                                                        
      *                                                                 03450000
T27237 2710-PROCESS-BILL-FACTOR.                                        
      *                                                                 03450000
T27237     IF IN-BILLING-FACTOR = 'COG BR   '                           
T27237        SET COGBR-FACTOR              TO TRUE                     
C36553        PERFORM 2720-PROCESS-FACTOR THRU 2720-EXIT                
T27237     ELSE                                                         
T27237        IF IN-BILLING-FACTOR = 'TRNSPURCH'                        
T27237           SET TRNPR-FACTOR           TO TRUE                     
C36553           PERFORM 2720-PROCESS-FACTOR THRU 2720-EXIT             
C36553        ELSE                                                      
C36553           IF IN-BILLING-FACTOR = 'SPCLFIRM '                     
C36553              SET SPCLFIRM-FACTOR TO TRUE                         
C36553              PERFORM 2720-PROCESS-FACTOR THRU 2720-EXIT          
C36553           END-IF                                                 
T27237        END-IF                                                    
T27237     END-IF.                                                      
      *                                                                 03450000
T27237     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT.                 
      *                                                                 03450000
T27237 2710-EXIT.                                                       
T27237     EXIT.                                                        
      *                                                                 03450000
T27237 2720-PROCESS-FACTOR.                                             
      *                                                                 03450000
T27237     MOVE IN-CMPNT-ID-CD               TO J1-CMPNT-ID-CD.         
T27237     MOVE IN-BILLING-FACTOR            TO SA-FACTOR-ID.           
T27237     PERFORM 7910-OPEN-RATES-CURSOR    THRU 7910-EXIT.            
T27237     PERFORM 7920-FETCH-RATES-CURSOR   THRU 7920-EXIT.            
      *                                                                 03450000
C36553     IF SA-FACTOR-ID = 'SPCLFIRM '                                
C36553        IF J1-RATE-PLAN-NO = '045' OR '046'                       
T27237           PERFORM 2725-CHECK-SPCL-FACTOR THRU 2725-EXIT          
T27237                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
C36553        END-IF                                                    
C36553     ELSE                                                         
T27237        PERFORM 2725-CHECK-SPCL-FACTOR THRU 2725-EXIT             
T27237             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
C36553     END-IF.                                                      
      *                                                                 03450000
T27237     MOVE SPACES TO WS-BILLING-FACTOR.                            
T27237     PERFORM 7930-CLOSE-RATES-CURSOR THRU 7930-EXIT.              
      *                                                                 03450000
T27237 2720-EXIT.                                                       
T27237     EXIT.                                                        
      *                                                                 03450000
T27237 2725-CHECK-SPCL-FACTOR.                                          
      *                                                                 03450000
T27237     MOVE 'N'                          TO WS-SPCL-FCTR-EXISTS.    
T27237     MOVE J1-CMPNT-ID-CD               TO SA-CMPNT-ID-CD.         
T27237     MOVE J1-RATE-PLAN-NO              TO SA-RATE-PLAN-NO.        
T27237     PERFORM 7940-SPCL-FACTOR-APPL     THRU 7940-EXIT.            
T27237     IF SPCL-FCTR-EXISTS                                          
T27237        CONTINUE                                                  
T27237     ELSE                                                         
T27237        MOVE 'X'                            TO WS-WROTE-ERR-MSG   
T27237        MOVE WS-FACTOR-MSG                  TO WS-ERROR-MSG       
T27237        MOVE SA-RATE-PLAN-NO                TO WS-ERROR-FLD       
T27237        MOVE 'CMPNT-ID  '                   TO WS-FLD3            
T27237        MOVE SA-CMPNT-ID-CD                 TO WS-FLD4            
T27237        MOVE 'FACTOR    '                   TO WS-FLD5            
T27237        MOVE IN-BILLING-FACTOR              TO WS-FLD6            
T27237        PERFORM 8000-WRITE-FCSPT33 THRU 8000-EXIT                 
T27237     END-IF.                                                      
T27237     MOVE 'N'                          TO WS-SPCL-FCTR-EXISTS.    
T27237     IF COGBR-FACTOR                                              
T27237        MOVE '10'                      TO SA-CMPNT-ID-CD          
T27237     ELSE                                                         
T27237        IF TRNPR-FACTOR                                           
T27237           MOVE '71'                   TO SA-CMPNT-ID-CD          
A36553        ELSE                                                      
A36553           IF SPCLFIRM-FACTOR                                     
A36553              MOVE '10'                TO SA-CMPNT-ID-CD          
A36553           END-IF                                                 
A36553        END-IF                                                    
T27237     END-IF.                                                      
T27237     PERFORM 7940-SPCL-FACTOR-APPL     THRU 7940-EXIT.            
T27237     IF SPCL-FCTR-EXISTS                                          
T27237        CONTINUE                                                  
T27237     ELSE                                                         
T27237        MOVE 'X'                            TO WS-WROTE-ERR-MSG   
T27237        MOVE WS-FACTOR-MSG                  TO WS-ERROR-MSG       
T27237        MOVE SA-RATE-PLAN-NO                TO WS-ERROR-FLD       
T27237        MOVE 'CMPNT-ID  '                   TO WS-FLD3            
T27237        MOVE SA-CMPNT-ID-CD                 TO WS-FLD4            
T27237        MOVE 'FACTOR    '                   TO WS-FLD5            
T27237        MOVE IN-BILLING-FACTOR              TO WS-FLD6            
T27237        PERFORM 8000-WRITE-FCSPT33 THRU 8000-EXIT                 
T27237     END-IF.                                                      
T27237     PERFORM 7920-FETCH-RATES-CURSOR   THRU 7920-EXIT.            
      *                                                                 03450000
T27237 2725-EXIT.                                                       
T27237     EXIT.                                                        
      *                                                                 03450000
T35148****************************************************************          
T35148*2750-CHK-BTU-FACTOR-LIMTS-PARA.                               *          
T35148* BTU FACTOR IS CHECKED AGAINST THE HIGH VALUE AND LOW VALUE   *          
T35148* BY COMPUTE MMBTU-TOTAL AND MCF TOTAL.                        *          
T35148****************************************************************          
T35148 2750-CHK-BTU-FACTOR-LIMTS.                                       
T35148*                                                                 03450000
T35148     MOVE TF-MMBTU-TOTAL               TO WS-MMBTU-TOTAL          
T35148     MOVE TF-MCF-TOTAL                 TO WS-MCF-TOTAL            
T35148     COMPUTE WS-BTU-FACTOR = WS-MMBTU-TOTAL / WS-MCF-TOTAL        
T35148         ON SIZE ERROR                                            
T35148            MOVE ZERO           TO WS-BTU-FACTOR                  
T35148     END-COMPUTE                                                  
T35148*                                                                         
T35148     MOVE WS-BTU-FACTOR         TO WS-BTU-FACTOR-DISP             
T35148*                                                                         
T35148     IF WS-BTU-FACTOR <= WS-BTU-UPPER-LMT-BTUR AND                
T35148        WS-BTU-FACTOR >= WS-BTU-LOWER-LMT-BTUR                    
T35148        CONTINUE                                                  
T35148     ELSE                                                         
T35148        DISPLAY ' '                                               
T35148        DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR **'          
T35148        DISPLAY '**   CURRENT BTU FACTOR FOR DATE: '              
T35148                                              WS-PREV-DATE        
T35148        DISPLAY '**   MMBTU TOTAL               = ' WS-MMBTU-TOTAL
T35148        DISPLAY '**   MCF TOTAL                 = ' WS-MCF-TOTAL  
T35148        DISPLAY '**   BTU FACTOR                = '               
T35148                                    WS-BTU-FACTOR-DISP            
T35148        DISPLAY '**   BTU FACTOR LOWER LIMIT    = '               
T35148                                    WS-BTU-LOWER-LMT-DISP         
T35148        DISPLAY '**   BTU FACTOR UPPER LIMIT    = '               
T35148                                    WS-BTU-UPPER-LMT-DISP         
T35148        DISPLAY '**   PROCESSING TERMINATED  **'                  
T35148        MOVE '02'            TO RETURN-CODE                       
T35148        PERFORM 9000-TERMINATE THRU 9000-EXIT                     
T35148        STOP RUN                                                  
T35148     END-IF.                                                      
T35148*                                                                 03450000
T35148 2750-EXIT.                                                       
T35148     EXIT.                                                        
T35148*                                                                 03450000
A04319 2800-VLDT-SPCL-FCTR-DATA.                                        
A04319*                                                                 03450000
A04319     MOVE WS-N                         TO WS-ERROR-FOUND.         
A04319     PERFORM 7980-OPEN-SPCL-FCTR-CURSOR  THRU 7980-EXIT.          
A04319     PERFORM 7985-FETCH-SPCL-FCTR-CURSOR THRU 7985-EXIT.          
A04319*                                                                 03450000
A04319     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04319        MOVE WS-Y                      TO WS-REPORT-HEADING       
A04319        MOVE SPACES                    TO HDR-01-TITLE            
A04319        MOVE HDR-02-TITLE              TO WS-REPORT-TITLE         
A04319        MOVE 'VERIFICATION OF MULTIPLE ACTIVE FACTORS '           
A04319                                       TO HDR-02-TITLE            
A04319        MOVE 58                        TO WS-LINE-COUNT           
A04319        PERFORM 8000-WRITE-FCSPT33      THRU 8000-EXIT            
A04319        MOVE WS-N                      TO WS-REPORT-HEADING       
A04319        MOVE WS-REPORT-TITLE           TO WS-REPORT-TITLE         
A04319     END-IF.                                                      
A04319                                                                  
A04319     PERFORM 2825-PROCESS-DUP-SPCL-FCTR  THRU 2825-EXIT           
A04319             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
A04319*                                                                 03450000
A04319     PERFORM 7990-CLOSE-SPCL-FCTR-CURSOR THRU 7990-EXIT.          
A04319*                                                                 03450000
A04319     IF WS-ERROR-FOUND        = WS-N                              
A04319           WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER 2        
A04319     END-IF.                                                      
A04319*                                                                 03450000
A04319 2800-EXIT.                                                       
A04319     EXIT.                                                        
A04319*                                                                 03450000
A04319 2825-PROCESS-DUP-SPCL-FCTR.                                      
A04319*                                                                 03450000
A04319     MOVE 'X'                            TO WS-WROTE-ERR-MSG.     
A04319     MOVE WS-DUP-FACTOR-MSG              TO WS-ERROR-MSG.         
A04319     MOVE SA-RATE-PLAN-NO                TO WS-ERROR-FLD.         
A04319     MOVE 'CMPNT-ID  '                   TO WS-FLD3.              
A04319     MOVE SA-CMPNT-ID-CD                 TO WS-FLD4.              
A04319     MOVE 'FACTOR    '                   TO WS-FLD5.              
A04319     MOVE SA-FACTOR-ID                   TO WS-FLD6.              
A04319     PERFORM 8000-WRITE-FCSPT33          THRU 8000-EXIT.          
A04319                                                                  
A04319     PERFORM 7985-FETCH-SPCL-FCTR-CURSOR THRU 7985-EXIT.          
A04319*                                                                 03450000
A04319 2825-EXIT.                                                       
A04319     EXIT.                                                        
      *                                                                 03450000
       COPY CPD00037.                                                   01287800
      *                                                                 03450000
            EXEC SQL                                                            
                INCLUDE CPD00038                                                
            END-EXEC.                                                           
      *                                                                 03450000
      ******************************************************************04414100
      *   SQL FOR GETTING PREVIOUS DAY                                 *03340000
      ******************************************************************04414300
       7100-GET-PREV-DATE.                                              
           EXEC SQL                                                     
T35434       SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-PREV-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-DATE
              ) <> 0) OR (LEN(:WS-PREV-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-PREV-DATE
              ), CONVERT(DATE, :WS-PREV-DATE) ) )
            INTO
              :WS-PREV-DATE           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-PREV-DATE = DATE(:WS-PREV-DATE) - 1 DAYS                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '********** PCSBW164 ABORT ************'         
               DISPLAY '* 7100-GET-PREV-DATE                 *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW164 ABORT ************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04416502
      ******************************************************************04414100
      *   SELECT ON CSS_BTU_FACTOR                                     *03340000
      ******************************************************************04414300
       7150-SELECT-BTU-FACT.                                            
      *                                                                         
           EXEC SQL                                                     
T35148          SELECT  TF.MMBTU_TOTAL                                  
T35148                 ,TF.MCF_TOTAL                                    
T35148            INTO  :TF-MMBTU-TOTAL                                 
T35148                 ,:TF-MCF-TOTAL                                   
                  FROM  CSS_BTU_FACTOR TF WITH(READUNCOMMITTED)                 
                 WHERE  TF.BTU_DT = IIF(TRY_CONVERT(DATE, :TF-BTU-DT
              ) IS NULL OR (PATINDEX('%.%', :TF-BTU-DT) <> 0) OR (LEN(
                                                             :TF-BTU-DT
              ) <> 10), CIS.CHAR2DATE(:TF-BTU-DT), CONVERT(DATE, 
                                                             :TF-BTU-DT
              ) )                          
C23301             AND  TF.COMPANY_NO = :TF-COMPANY-NO                  
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  TF.MMBTU_TOTAL                                          
MFA-TR*                ,TF.MCF_TOTAL                                            
MFA-TR*           INTO  :TF-MMBTU-TOTAL                                         
MFA-TR*                ,:TF-MCF-TOTAL                                           
MFA-TR*           FROM  CSS_BTU_FACTOR TF                                       
MFA-TR*          WHERE  TF.BTU_DT = :TF-BTU-DT                                  
MFA-TR*            AND  TF.COMPANY_NO = :TF-COMPANY-NO                          
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T35148         IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
T35148             MOVE 'Y'              TO WS-BTU-FACT-EXISTS          
T35148         END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '********** PCSBW164 ABORT ************'         
               DISPLAY '* 7150-SELECT-BTU-FACT               *'         
               DISPLAY '* SQLCODE IS ',      WS-DISPLAY-RC              
               DISPLAY '* BTU-DT  IS ',      TF-BTU-DT                  
T35148         DISPLAY '* MMBTU TOTAL  IS ', TF-MMBTU-TOTAL             
T35148         DISPLAY '* MCF TOTAL  IS ',   TF-MCF-TOTAL               
C23301         DISPLAY '* COMPANY-NO IS ',   TF-COMPANY-NO              
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW164 ABORT ************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04416502
      ******************************************************************04414100
      *   SELECT ON CSS_TEMPERATURE                                    *03340000
      ******************************************************************04414300
       7200-SELECT-TEMPERATURE.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT  'Y'                                             
                  INTO :WS-TEMP-EXISTS                                  
                  FROM  CSS_TEMPERATURE WITH(READUNCOMMITTED)                   
                 WHERE  TEMP_DT = IIF(TRY_CONVERT(DATE, :E8-TEMP-DT
              ) IS NULL OR (PATINDEX('%.%', :E8-TEMP-DT) <> 0) OR (LEN(
                                                            :E8-TEMP-DT
              ) <> 10), CIS.CHAR2DATE(:E8-TEMP-DT), CONVERT(DATE, 
                                                            :E8-TEMP-DT
              ) )                           
C23301             AND  COMPANY_NO = :E8-COMPANY-NO                     
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  'Y'                                                     
MFA-TR*           INTO :WS-TEMP-EXISTS                                          
MFA-TR*           FROM  CSS_TEMPERATURE                                         
MFA-TR*          WHERE  TEMP_DT = :E8-TEMP-DT                                   
MFA-TR*            AND  COMPANY_NO = :E8-COMPANY-NO                             
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '********** PCSBW164 ABORT ************'         
               DISPLAY '* 7200-SELECT-TEMPERATURE            *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* TEMP-DT IS ', E8-TEMP-DT                      
C23301         DISPLAY '* COMPANY-NO IS ', E8-COMPANY-NO                
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW164 ABORT ************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************04414100
      *   SELECT ON CSS_WEATHER_TREND                                  *03340000
      ******************************************************************04414300
       7250-SELECT-WEATHER-TREND.                                       
      *                                                                         
           EXEC SQL                                                     
                SELECT  'Y'                                             
                  INTO :WS-WEATHER-DET-EXISTS                           
                  FROM  CSS_WEATHER_TREND WITH(READUNCOMMITTED)                 
                 WHERE  DATE_BILL          = IIF(TRY_CONVERT(DATE, 
                                                          :WT-DATE-BILL
              ) IS NULL OR (PATINDEX('%.%', :WT-DATE-BILL
              ) <> 0) OR (LEN(:WT-DATE-BILL) <> 10), CIS.CHAR2DATE(
                                                          :WT-DATE-BILL
              ), CONVERT(DATE, :WT-DATE-BILL) )              
                   AND  CODE_UTIL_TYPE     = :WT-CODE-UTIL-TYPE         
                   AND  CODE_REVENUE_CLASS = :WT-CODE-REVENUE-CLASS     
C23301             AND  COMPANY_NO         = :WT-COMPANY-NO             
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  'Y'                                                     
MFA-TR*           INTO :WS-WEATHER-DET-EXISTS                                   
MFA-TR*           FROM  CSS_WEATHER_TREND                                       
MFA-TR*          WHERE  DATE_BILL          = :WT-DATE-BILL                      
MFA-TR*            AND  CODE_UTIL_TYPE     = :WT-CODE-UTIL-TYPE                 
MFA-TR*            AND  CODE_REVENUE_CLASS = :WT-CODE-REVENUE-CLASS             
MFA-TR*            AND  COMPANY_NO         = :WT-COMPANY-NO                     
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '********** PCSBW164 ABORT ************'         
               DISPLAY '* 7250-SELECT-WEATHER-TREND          *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* DATE BILL = ', WT-DATE-BILL                   
C23301         DISPLAY '* COMPANY-NO IS ', WT-COMPANY-NO                
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSBW164 ABORT ************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04416502
C23301******************************************************************        
C23301* 7300-OPEN-COMPANY-CURSOR                                                
C23301******************************************************************        
C23301 7300-OPEN-COMPANY-CURSOR.                                        
C23301     EXEC SQL                                                     
C23301        OPEN COMPANY-CURSOR                                       
C23301     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23301                                                                  
C23301     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C23301                                                                  
C23301     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C23301        NEXT SENTENCE                                             
C23301     ELSE                                                         
C23301        DISPLAY '********** PCSBW164 ABORT ************'          
C23301        MOVE '7300'          TO ACTIVE-PARAGRAPH                  
C23301        MOVE 'OPEN'          TO ABEND-FUNCTION                    
C23301        MOVE 'CSS_COMPANY'        TO TABLE-1                      
C23301        PERFORM 9900-ABEND THRU 9900-EXIT                         
C23301     END-IF.                                                      
      *                                                                         
C23301 7300-EXIT.                                                       
C23301     EXIT.                                                        
                                                                        
C23301******************************************************************        
C23301* 7350-FETCH-COMPANY-CURSOR                                               
C23301******************************************************************        
C23301 7350-FETCH-COMPANY-CURSOR.                                       
C23301                                                                  
C23301     EXEC SQL                                                     
C23301        FETCH COMPANY-CURSOR                                      
C23301        INTO  :C7-COMPANY-NO,                                     
C23301              :C7-COMPANY-NAME,                                   
C23301              :C7-TEMPERATURE-REQ-FL,                             
C23301              :C7-BTU-FACTOR-REQ-FL,                              
C23301              :C7-WEATHER-TND-REQ-FL,                             
C23301              :C7-CALC-WNA-METHOD-CD                              
C23301     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23301                                                                  
C23301                                                                  
C23301     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C23301                                                                  
C23301     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C23301        NEXT SENTENCE                                             
C23301     ELSE                                                         
C23301        MOVE '7350'                TO ACTIVE-PARAGRAPH            
C23301        MOVE 'FETCH'               TO ABEND-FUNCTION              
C23301        MOVE 'CSS_COMPANY'         TO TABLE-1                     
C23301        MOVE 'TEMPERATURE_REQ_FL'  TO TABLE-ELEMENT-1             
C23301        MOVE C7-TEMPERATURE-REQ-FL TO HOSTVAR-ELEMENT-1           
C23301        MOVE 'BTU_FACTOR_REQ_FL'   TO TABLE-ELEMENT-2             
C23301        MOVE C7-BTU-FACTOR-REQ-FL  TO HOSTVAR-ELEMENT-2           
C23301        MOVE 'WEATHER_TND_REQ_FL'  TO TABLE-ELEMENT-3             
C23301        MOVE C7-WEATHER-TND-REQ-FL TO HOSTVAR-ELEMENT-3           
C23301        PERFORM 9900-ABEND THRU 9900-EXIT                         
C23301     END-IF.                                                      
C23301                                                                  
C23301 7350-EXIT.                                                       
C23301     EXIT.                                                        
                                                                        
C23301******************************************************************        
C23301* 7400-CLOSE-COMPANY-CURSOR                                               
C23301******************************************************************        
C23301 7400-CLOSE-COMPANY-CURSOR.                                       
C23301                                                                  
C23301     EXEC SQL                                                     
C23301        CLOSE COMPANY-CURSOR                                      
C23301     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23301                                                                  
C23301     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C23301                                                                  
C23301     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C23301        NEXT SENTENCE                                             
C23301     ELSE                                                         
C23301        MOVE '7400'          TO ACTIVE-PARAGRAPH                  
C23301        MOVE 'CLOSE'         TO ABEND-FUNCTION                    
C23301        MOVE 'CSS_COMPANY'        TO TABLE-1                      
C23301        PERFORM 9900-ABEND THRU 9900-EXIT                         
C23301     END-IF.                                                      
C23301                                                                  
C23301 7400-EXIT.                                                       
C23301     EXIT.                                                        
T27237*                                                                         
T27237******************************************************************04414100
T27237*   CHECK IF CYCLE 21 IS OPEN ON THE COMMON DATE                 *03340000
T27237******************************************************************04414300
T27237 7500-CHK-CYC21-OPEN.                                             
T27237*                                                                         
T27237     EXEC SQL                                                     
T27237          SELECT REVENUE_MONTH                                    
T27237            INTO :BN-REVENUE-MONTH                                
T27237            FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                   
T27237           WHERE  DATE_EXTRACT  = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                
T27237             AND  BILL_CYCLE    = '21'                            
T35434                                                           
T27237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT REVENUE_MONTH                                            
MFA-TR*           INTO :BN-REVENUE-MONTH                                        
MFA-TR*           FROM  CSS_BILL_WINDOW                                         
MFA-TR*          WHERE  DATE_EXTRACT  = :BN-DATE-EXTRACT                        
MFA-TR*            AND  BILL_CYCLE    = '21'                                    
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237*                                                                         
T27237     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T27237*                                                                         
T27237     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T27237         CONTINUE                                                 
T27237     ELSE                                                         
T27237         MOVE SQLCODE                    TO WS-DISPLAY-RC         
T27237         DISPLAY '********** PCSBW164 ABORT ************'         
T27237         DISPLAY '* 7500-CHK-CYC21-OPEN                *'         
T27237         DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
T27237         DISPLAY '* DATE EXTRACT = ', BN-DATE-EXTRACT             
T27237         DISPLAY '* PROGRAM ABORTING...                *'         
T27237         DISPLAY '********** PCSBW164 ABORT ************'         
T27237         PERFORM 9900-ABEND THRU 9900-EXIT                        
T27237     END-IF.                                                      
T27237*                                                                         
T27237 7500-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                 04416502
T27237******************************************************************04414100
T27237*   SELECT ON CSS_BTU_INDUST_FCT                                 *03340000
T27237******************************************************************04414300
T27237 7620-CHK-BTU-IND-FCTR.                                           
T27237*                                                                         
T27237     EXEC SQL                                                     
T27237          SELECT SPECIFIC_GRAVITY                                 
T27237            INTO :FE-SPECIFIC-GRAVITY                             
T27237            FROM CSS_BTU_INDUST_FCT WITH(READUNCOMMITTED)                 
T27237           WHERE COMPANY_NO = :FE-COMPANY-NO                      
T27237             AND BTU_DT = IIF(TRY_CONVERT(DATE, :FE-BTU-DT
              ) IS NULL OR (PATINDEX('%.%', :FE-BTU-DT) <> 0) OR (LEN(
                                                             :FE-BTU-DT
              ) <> 10), CIS.CHAR2DATE(:FE-BTU-DT), CONVERT(DATE, 
                                                             :FE-BTU-DT
              ) )                              
T27237             AND INDUST_BTU_ID= :FE-INDUST-BTU-ID                 
T35434                                                           
T27237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SPECIFIC_GRAVITY                                         
MFA-TR*           INTO :FE-SPECIFIC-GRAVITY                                     
MFA-TR*           FROM CSS_BTU_INDUST_FCT                                       
MFA-TR*          WHERE COMPANY_NO = :FE-COMPANY-NO                              
MFA-TR*            AND BTU_DT = :FE-BTU-DT                                      
MFA-TR*            AND INDUST_BTU_ID= :FE-INDUST-BTU-ID                         
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237*                                                                         
T27237     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T27237*                                                                         
T27237     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T35216        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
T35216           MOVE ZEROS TO FE-SPECIFIC-GRAVITY                      
T35216        END-IF                                                    
T27237     ELSE                                                         
T27237         MOVE SQLCODE                    TO WS-DISPLAY-RC         
T27237         DISPLAY '********** PCSBW164 ABORT ************'         
T27237         DISPLAY '* 7150-SELECT-BTU-FACT               *'         
T27237         DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
T27237         DISPLAY '* BTU-DT  IS ', TF-BTU-DT                       
T27237         DISPLAY '* COMPANY-NO IS ', TF-COMPANY-NO                
T27237         DISPLAY '* PROGRAM ABORTING...                *'         
T27237         DISPLAY '********** PCSBW164 ABORT ************'         
T27237         PERFORM 9900-ABEND THRU 9900-EXIT                        
T27237     END-IF.                                                      
T27237*                                                                         
T27237 7620-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                 04416502
T27237******************************************************************        
T27237* 7710-OPEN-BTUID-CURSOR                                                  
T27237******************************************************************        
T27237 7710-OPEN-BTUID-CURSOR.                                          
T27237*                                                                         
T27237     EXEC SQL                                                     
T27237        OPEN BTUID-CRSR                                           
T27237     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T27237        NEXT SENTENCE                                             
T27237     ELSE                                                         
T27237        DISPLAY '********** PCSBW164 ABORT ************'          
T27237        MOVE '7710'          TO ACTIVE-PARAGRAPH                  
T27237        MOVE 'OPEN'          TO ABEND-FUNCTION                    
T27237        MOVE 'CSS_BTU_INDUST_FCT' TO TABLE-1                      
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237*                                                                         
T27237 7710-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                         
T27237******************************************************************        
T27237* 7720-FETCH-BTUID-CURSOR                                                 
T27237******************************************************************        
T27237 7720-FETCH-BTUID-CURSOR.                                         
T27237                                                                  
T27237     EXEC SQL                                                     
T27237        FETCH BTUID-CRSR                                          
T27237        INTO  :FD-INDUST-BTU-ID                                   
T27237             ,:FD-SPEC-GRAVITY-FL                                 
T27237     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T27237        NEXT SENTENCE                                             
T27237     ELSE                                                         
T27237        MOVE '7720'                TO ACTIVE-PARAGRAPH            
T27237        MOVE 'FETCH'               TO ABEND-FUNCTION              
T27237        MOVE 'CSS_BTU_INDUST_FCT'  TO TABLE-1                     
T27237        MOVE 'BTU DATE'            TO TABLE-ELEMENT-1             
T27237        MOVE WS-COMMON-DATE        TO HOSTVAR-ELEMENT-1           
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237                                                                  
T27237 7720-EXIT.                                                       
T27237     EXIT.                                                        
T27237                                                                  
T27237******************************************************************        
T27237* 7730-CLOSE-BTUID-CURSOR                                                 
T27237******************************************************************        
T27237 7730-CLOSE-BTUID-CURSOR.                                         
T27237                                                                  
T27237     EXEC SQL                                                     
T27237        CLOSE BTUID-CRSR                                          
T27237     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T27237        NEXT SENTENCE                                             
T27237     ELSE                                                         
T27237        MOVE '7730'          TO ACTIVE-PARAGRAPH                  
T27237        MOVE 'CLOSE'         TO ABEND-FUNCTION                    
T27237        MOVE 'CSS_BTU_INDUST_FCT' TO TABLE-1                      
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237                                                                  
T27237 7730-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                         
T27237******************************************************************        
T27237* 7800-SELECT-OPT-READ-DT                                                 
T27237******************************************************************        
T27237 7800-SELECT-OPT-READ-DT.                                         
T27237                                                                  
T27237     EXEC SQL                                                     
T27237         SELECT OPTIMUM_READ_DATE                                 
T27237           INTO :RW-OPTIMUM-READ-DATE                             
T27237           FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                     
T27237          WHERE READ_CYCLE    = '21'                              
T27237            AND REVENUE_MONTH = :RW-REVENUE-MONTH                 
T35434                                                           
T27237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT OPTIMUM_READ_DATE                                         
MFA-TR*          INTO :RW-OPTIMUM-READ-DATE                                     
MFA-TR*          FROM CSS_READ_WINDOW                                           
MFA-TR*         WHERE READ_CYCLE    = '21'                                      
MFA-TR*           AND REVENUE_MONTH = :RW-REVENUE-MONTH                         
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE      EQUAL SUCCESSFUL-CALL          
T27237        CONTINUE                                                  
T27237     ELSE                                                         
T27237        MOVE SQLCODE                     TO WS-DISPLAY-RC         
T27237        DISPLAY '********** PCSBW164 ABORT ************'          
T27237        DISPLAY '* 7800-SELECT-OPT-READ-DT            *'          
T27237        DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                    
T27237        DISPLAY '* REVENUE MONTH = ', RW-REVENUE-MONTH            
T27237        DISPLAY '* PROGRAM ABORTING...                *'          
T27237        DISPLAY '********** PCSBW164 ABORT ************'          
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237                                                                  
T27237 7800-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                         
T27237******************************************************************        
T27237* 7810-GET-NEXT-DAY                                                       
T27237******************************************************************        
T27237 7810-GET-NEXT-DAY.                                               
T27237                                                                  
T27237     EXEC SQL                                                     
T35434          SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DB2-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DB2-DATE
              ) <> 0) OR (LEN(:WS-DB2-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-DB2-DATE
              ), CONVERT(DATE, :WS-DB2-DATE) ) )
            INTO
              :WS-DB2-DATE           
T27237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DB2-DATE = DATE(:WS-DB2-DATE) + 1 DAY                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE      EQUAL SUCCESSFUL-CALL          
T27237        MOVE WS-DB2-DATE                 TO FE-BTU-DT             
T27237     ELSE                                                         
T27237        MOVE SQLCODE                     TO WS-DISPLAY-RC         
T27237        DISPLAY '********** PCSBW164 ABORT ************'          
T27237        DISPLAY '* 7810-GET-NEXT-DAY                  *'          
T27237        DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                    
T27237        DISPLAY '* DATE     = ', WS-DB2-DATE                      
T27237        DISPLAY '* PROGRAM ABORTING...                *'          
T27237        DISPLAY '********** PCSBW164 ABORT ************'          
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237                                                                  
T27237 7810-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                         
T27237******************************************************************        
T27237* 7910-OPEN-RATES-CURSOR                                                  
T27237******************************************************************        
T27237 7910-OPEN-RATES-CURSOR.                                          
T27237*                                                                         
T27237     EXEC SQL                                                     
T27237        OPEN RATES-CURSOR                                         
T27237     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T27237        NEXT SENTENCE                                             
T27237     ELSE                                                         
T27237        DISPLAY '********** PCSBW164 ABORT ************'          
T27237        MOVE '7910'          TO ACTIVE-PARAGRAPH                  
T27237        MOVE 'OPEN'          TO ABEND-FUNCTION                    
T27237        MOVE 'CSS_RATE_COMP_DEF' TO TABLE-1                       
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237*                                                                         
T27237 7910-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                         
T27237******************************************************************        
T27237* 7920-FETCH-RATES-CURSOR                                                 
T27237******************************************************************        
T27237 7920-FETCH-RATES-CURSOR.                                         
T27237                                                                  
T27237     EXEC SQL                                                     
T27237        FETCH RATES-CURSOR                                        
T27237         INTO :J1-RATE-PLAN-NO                                    
T27237     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T27237        NEXT SENTENCE                                             
T27237     ELSE                                                         
T27237        MOVE '7920'                TO ACTIVE-PARAGRAPH            
T27237        MOVE 'FETCH'               TO ABEND-FUNCTION              
T27237        MOVE 'CSS_RATE_COMP_DEF'   TO TABLE-1                     
T27237        MOVE 'CMPNT ID CD'         TO TABLE-ELEMENT-1             
T27237        MOVE J1-CMPNT-ID-CD        TO HOSTVAR-ELEMENT-1           
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237                                                                  
T27237 7920-EXIT.                                                       
T27237     EXIT.                                                        
T27237                                                                  
T27237******************************************************************        
T27237* 7930-CLOSE-RATES-CURSOR                                                 
T27237******************************************************************        
T27237 7930-CLOSE-RATES-CURSOR.                                         
T27237                                                                  
T27237     EXEC SQL                                                     
T27237        CLOSE RATES-CURSOR                                        
T27237     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T27237        NEXT SENTENCE                                             
T27237     ELSE                                                         
T27237        MOVE '7930'          TO ACTIVE-PARAGRAPH                  
T27237        MOVE 'CLOSE'         TO ABEND-FUNCTION                    
T27237        MOVE 'CSS_RATE_COMP_DEF'  TO TABLE-1                      
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237                                                                  
T27237 7930-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                         
T27237******************************************************************        
T27237* 7940-SPCL-FACTOR-APPL                                                   
T27237******************************************************************        
T27237 7940-SPCL-FACTOR-APPL.                                           
T27237                                                                  
T27237     EXEC SQL                                                     
T27237         SELECT 'Y'                                               
T27237           INTO :WS-SPCL-FCTR-EXISTS                              
T27237           FROM CSS_SPCL_FCTR_APPL WITH(READUNCOMMITTED)                  
T27237          WHERE RATE_PLAN_NO  = :SA-RATE-PLAN-NO                  
T27237            AND FACTOR_ID     = :SA-FACTOR-ID                     
T27237            AND CMPNT_ID_CD   = :SA-CMPNT-ID-CD                   
T27237            AND CODE_STATUS   = 'A'                               
T27237            AND DATE_FROM     = IIF(TRY_CONVERT(DATE, 
                                                        :WS-MIN-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN-READ-DT
              ) <> 0) OR (LEN(:WS-MIN-READ-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-MIN-READ-DT
              ), CONVERT(DATE, :WS-MIN-READ-DT) )                   
T27237            AND DATE_TO      >= IIF(TRY_CONVERT(DATE, 
                                                        :WS-MAX-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-READ-DT
              ) <> 0) OR (LEN(:WS-MAX-READ-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-MAX-READ-DT
              ), CONVERT(DATE, :WS-MAX-READ-DT) )                   
T35434                                                           
T27237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-SPCL-FCTR-EXISTS                                      
MFA-TR*          FROM CSS_SPCL_FCTR_APPL                                        
MFA-TR*         WHERE RATE_PLAN_NO  = :SA-RATE-PLAN-NO                          
MFA-TR*           AND FACTOR_ID     = :SA-FACTOR-ID                             
MFA-TR*           AND CMPNT_ID_CD   = :SA-CMPNT-ID-CD                           
MFA-TR*           AND CODE_STATUS   = 'A'                                       
MFA-TR*           AND DATE_FROM     = :WS-MIN-READ-DT                           
MFA-TR*           AND DATE_TO      >= :WS-MAX-READ-DT                           
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T27237        CONTINUE                                                  
T27237     ELSE                                                         
T27237        MOVE SQLCODE                     TO WS-DISPLAY-RC         
T27237        DISPLAY '********** PCSBW164 ABORT ************'          
T27237        DISPLAY '* 7940-SPCL-FACTOR-APPL              *'          
T27237        DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                    
T27237        DISPLAY '* RATE_PLAN_NO  = ', SA-RATE-PLAN-NO             
T27237        DISPLAY '* FACTOR_ID     = ', SA-FACTOR-ID                
T27237        DISPLAY '* CMPNT_ID_CD   = ', SA-CMPNT-ID-CD              
T27237        DISPLAY '* DATE_FROM     = ', WS-MIN-READ-DT              
T27237        DISPLAY '* DATE_TO       = ', WS-MAX-READ-DT              
T27237        DISPLAY '* PROGRAM ABORTING...                *'          
T27237        DISPLAY '********** PCSBW164 ABORT ************'          
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237                                                                  
T27237 7940-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                         
T27237******************************************************************        
T27237* 7950-OPEN-BILLDAY-CURSOR                                                
T27237******************************************************************        
T27237 7950-OPEN-BILLDAY-CURSOR.                                        
T27237*                                                                         
T27237     EXEC SQL                                                     
T27237        OPEN BILLDAY-CRSR                                         
T27237     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T27237        NEXT SENTENCE                                             
T27237     ELSE                                                         
T27237        DISPLAY '********** PCSBW164 ABORT ************'          
T27237        MOVE '7950'          TO ACTIVE-PARAGRAPH                  
T27237        MOVE 'OPEN'          TO ABEND-FUNCTION                    
T27237        MOVE 'CSS_BILL_WINDOW'   TO TABLE-1                       
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237*                                                                         
T27237 7950-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                         
T27237******************************************************************        
T27237* 7960-FETCH-BILLDAY-CURSOR                                               
T27237******************************************************************        
T27237 7960-FETCH-BILLDAY-CURSOR.                                       
T27237*                                                                         
T27237     EXEC SQL                                                     
T27237        FETCH BILLDAY-CRSR                                        
T27237         INTO :WS-FOURTH-DAY                                      
T27237     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T27237        NEXT SENTENCE                                             
T27237     ELSE                                                         
T27237        MOVE '7960'                TO ACTIVE-PARAGRAPH            
T27237        MOVE 'FETCH'               TO ABEND-FUNCTION              
T27237        MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237                                                                  
T27237 7960-EXIT.                                                       
T27237     EXIT.                                                        
T27237                                                                  
T27237******************************************************************        
T27237* 7970-CLOSE-BILLDAY-CURSOR                                               
T27237******************************************************************        
T27237 7970-CLOSE-BILLDAY-CURSOR.                                       
T27237                                                                  
T27237     EXEC SQL                                                     
T27237        CLOSE BILLDAY-CRSR                                        
T27237     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237                                                                  
T27237     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T27237        NEXT SENTENCE                                             
T27237     ELSE                                                         
T27237        MOVE '7970'          TO ACTIVE-PARAGRAPH                  
T27237        MOVE 'CLOSE'         TO ABEND-FUNCTION                    
T27237        MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                      
T27237        PERFORM 9900-ABEND THRU 9900-EXIT                         
T27237     END-IF.                                                      
T27237                                                                  
T27237 7970-EXIT.                                                       
T27237     EXIT.                                                        
T27237*                                                                         
A04319******************************************************************        
A04319* 7980-OPEN-SPCL-FCTR-CURSOR.                                             
A04319******************************************************************        
A04319 7980-OPEN-SPCL-FCTR-CURSOR.                                      
A04319*                                                                         
A04319     EXEC SQL                                                     
A04319        OPEN SPCL-FCTR-CSR                                        
A04319     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04319                                                                  
A04319     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04319                                                                  
A04319     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04319        CONTINUE                                                  
A04319     ELSE                                                         
A04319        DISPLAY '********** PCSBW164 ABORT ************'          
A04319        MOVE '7980'                    TO ACTIVE-PARAGRAPH        
A04319        MOVE 'OPEN'                    TO ABEND-FUNCTION          
A04319        MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
A04319        PERFORM 9900-ABEND              THRU 9900-EXIT            
A04319     END-IF.                                                      
A04319*                                                                         
A04319 7980-EXIT.                                                       
A04319     EXIT.                                                        
A04319*                                                                         
A04319******************************************************************        
A04319* 7985-FETCH-SPCL-FCTR-CURSOR.                                            
A04319******************************************************************        
A04319 7985-FETCH-SPCL-FCTR-CURSOR.                                     
A04319*                                                                         
A04319     EXEC SQL                                                     
A04319        FETCH SPCL-FCTR-CSR                                       
A04319         INTO :SA-CODE-UTIL-TYPE                                  
A04319             ,:SA-RATE-PLAN-NO                                    
A04319             ,:SA-FACTOR-ID                                       
A04319             ,:SA-CMPNT-ID-CD                                     
A04319             ,:SA-BLOCK-NO                                        
A04319             ,:SA-CODE-SEASON                                     
A04319             ,:SA-CODE-TIME-PERIOD                                
A04319             ,:SA-INSTR-USE-TYPE-CD                               
A04319     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04319                                                                  
A04319     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04319                                                                  
A04319     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04319        CONTINUE                                                  
A04319     ELSE                                                         
A04319        MOVE '7985'                    TO ACTIVE-PARAGRAPH        
A04319        MOVE 'FETCH'                   TO ABEND-FUNCTION          
A04319        MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
A04319        PERFORM 9900-ABEND              THRU 9900-EXIT            
A04319     END-IF.                                                      
A04319                                                                  
A04319 7985-EXIT.                                                       
A04319     EXIT.                                                        
A04319                                                                  
A04319******************************************************************        
A04319* 7990-CLOSE-SPCL-FCTR-CURSOR                                             
A04319******************************************************************        
A04319 7990-CLOSE-SPCL-FCTR-CURSOR.                                     
A04319                                                                  
A04319     EXEC SQL                                                     
A04319        CLOSE SPCL-FCTR-CSR                                       
A04319     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04319                                                                  
A04319     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04319                                                                  
A04319     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04319        CONTINUE                                                  
A04319     ELSE                                                         
A04319        MOVE '7990'                    TO ACTIVE-PARAGRAPH        
A04319        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
A04319        MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
A04319        PERFORM 9900-ABEND              THRU 9900-EXIT            
A04319     END-IF.                                                      
A04319                                                                  
A04319 7990-EXIT.                                                       
A04319     EXIT.                                                        
A04319*                                                                         
                                                                        
      ******************************************************************04416608
      *   WRITING INTO THE FILE FCSPT33                                *04416708
      ******************************************************************04416808
       8000-WRITE-FCSPT33.                                              
      *                                                                 04417007
           IF  WS-LINE-COUNT > 57                                       
               ADD  1                          TO WS-PAGE-COUNT         
               MOVE WS-PAGE-COUNT              TO HDR-03-PAGE           
               WRITE PRT33-RECORD FROM HEADER-01 AFTER NEW-PAGE         
               WRITE PRT33-RECORD FROM HEADER-02 AFTER 1                
               WRITE PRT33-RECORD FROM HEADER-03 AFTER 1                
               MOVE 03                         TO WS-LINE-COUNT         
           END-IF.                                                      
C23301     IF WS-REPORT-HEADING NOT = WS-Y                              
C23301     MOVE WS-Y                       TO WS-ERROR-FOUND            
           WRITE PRT33-RECORD FROM WS-ERROR-REC AFTER 2                 
           ADD  02                         TO WS-LINE-COUNT             
C23301     END-IF.                                                      
      *                                                                 04418007
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04480007
HPCCDM* EJECT                                                           06040000
      ******************************************************************06050000
      *   TERMINATION ROUTINE                                          *06060000
      ******************************************************************06070000
      *                                                                 06080000
       9000-TERMINATE.                                                  
      *                                                                 06100000
           CLOSE FCSPT33-FILE.                                          
      *                                                                 06209107
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06230000
      ******************************************************************06240009
      *     9900-ABEND                                                 *06241009
      ******************************************************************06244009
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
       9900-EXIT.                                                       
      *                                                                 06310000
