       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW161.                                        
       DATE-WRITTEN.   JAN  2016.                                       
       DATE-COMPILED.                                                   
      *****************************************************************         
      **                                                             **         
      **                 PROGRAM MODIFICATION  LOG                   **         
      **                                                             **         
      **  DATE       INITIALS    REASON                              **         
      **  --------   --------    ------                              **         
      **  01/10/16   SS95855     NEW CODE FOR MDMS                   **         
A#5347**  06/01/16   SS95855     Align date for Season Change Request**         
A#5347**                         Increase length of Request type     **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      *                                                               *         
      *                       PCSBW161 NARRATIVE                      *         
      *                                                               *         
      *         THIS PROGRAM SENDS READ REQUEST FILE TO MDMS TO GET   *         
      *         METER READS. REQUEST WILL BE CREATED ON OPTIMUM READ  *         
      *         DATE PLUS 3 DAYS OF EACH CYCLE.                       *         
      *****************************************************************         
      /                                                                         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
      *****************************************************************         
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSBW61.                                                        
      /                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
       COPY CFDBW61.                                                            
       01 FIOBW61-RECORD                 PIC X(170).                    
      /                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW161'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSBW161 STARTS HERE'.            
      * FCA00-KEY          *                                                    
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      * IO AREA FOR PARM INPUT FILE 'A' *                                       
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      *                                                                         
           COPY FIOBW61.                                                        
      *                                                                         
       01  WS-ABEND-AREA.                                               
           05  WS-ABEND-SPACE           PIC X VALUE SPACE.              
           05  WS-ABEND-NUMERIC REDEFINES                               
               WS-ABEND-SPACE           PIC 9.                          
      * ABEND SWITCH     *                                                      
           COPY CWS09900.                                                       
      * WARNING DATA     *                                                      
           COPY CWS00303.                                                       
      * MISC INPUT       *                                                      
           COPY CWS00010.                                                       
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
       01 WS-INPUT-DATA-R8 REDEFINES                                    
           WS-INPUT-DATA-BREAKDOWN.                                     
          10 WS-SYSIPT-R8               PIC X(13).                      
             88 CONTROL-DAYS            VALUE 'CONTROL-DAYS='.          
          10 WS-CTRL-DAYS               PIC X(02).                      
          10 FILLER                     PIC X(65).                      
      *                                                                         
       01 WS-INPUT-DATA-R9 REDEFINES                                    
           WS-INPUT-DATA-BREAKDOWN.                                     
          10 WS-SYSIPT-R9               PIC X(09).                      
             88 LAG-LEAD                VALUE 'LAG-LEAD='.              
          10 WS-LAG-LEAD                PIC X(19).                      
          10 FILLER                     PIC X(52).                      
      *                                                                         
       01 WS-INPUT-DATA-R8 REDEFINES                                    
             WS-INPUT-DATA-BREAKDOWN.                                   
          10 WS-SYSIPT-R8               PIC X(14).                      
             88 TIME-STAMP              VALUE 'LAST-UPD-TMST='.         
          10 WS-TIME-STAMP-PARM         PIC X(26).                      
          10 FILLER                     PIC X(40).                      
      *                                                                         
      /                                                                         
      * FCA00 MISC INPUT *                                                      
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00315                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-WORK-AREA.                                                
           05 WS-FBW61-STATUS           PIC X(02) VALUE '00'.           
              88 FBW61-SUCCESSFUL                 VALUE '00'.           
           05 WS-SEASON-RATE-SW         PIC 9(01) VALUE 0.              
              88 NON-SEASON-RATE                  VALUE 0.              
              88 SEASON-RATE-BY-USAGE             VALUE 1.              
           05 WS-READ-REQU-SW           PIC 9(01) VALUE 0.              
              88 INIT-READ-REQU                   VALUE 0.              
              88 READ-REQU-SENT                   VALUE 1.              
           05 WS-ACCT-CHNG-SW           PIC 9(01) VALUE 1.              
              88 ACCT-CHNG-REQU                   VALUE 0.              
              88 ACCT-CHNG-SENT                   VALUE 1.              
           05 WS-METR-CHNG-SW           PIC 9(01) VALUE 1.              
              88 METR-CHNG-REQU                   VALUE 0.              
              88 METR-CHNG-SENT                   VALUE 1.              
           05 WS-PROCESS-SP-SW          PIC X(01) VALUE 'Y'.            
              88 PROCESS-ALL-SPS                  VALUE 'Y'.            
              88 NO-MORE-SERVICE-POINTS           VALUE 'N'.            
           05 WS-FIOBW61-COUNT          PIC 9(07) VALUE 0.              
           05 WS-CURR-READ-DATE         PIC X(10) VALUE SPACES.         
           05 WS-PREV-READ-DATE         PIC X(10) VALUE SPACES.         
A#5347     05 WS-REQUEST-TYPE           PIC X(16) VALUE SPACES.         
           05 WS-NO-READ-DAYS           PIC S9(8) COMP VALUE 0.         
           05 WS-DOWNLD-MTR-COUNT       PIC S9(8) USAGE COMP.           
           05 WS-ACCOUNT-NO-PART        PIC S9(13)V COMP-3 VALUE 0.     
           05 WS-NULL-IND               PIC S9(04) COMP.                
           05 WS-NULL-IND1              PIC S9(04) COMP.                
           05 WS-NULL-IND-01            PIC S9(04) COMP.                
           05 WS-NULL-IND-02            PIC S9(04) COMP.                
           05 WS-BILL-CYCLE             PIC X(2) VALUE '00'.            
           05 WS-REVENUE-MONTH          PIC 9(6).                       
           05 WS-RUN-DATE               PIC X(10).                      
           05 WS-CURR-DATE              PIC X(10) VALUE SPACES.         
A#5347     05 WS-CURR-DATE-PLUS-2       PIC X(10) VALUE SPACES.         
           05 WS-PREV-RUN-DATE          PIC X(10) VALUE SPACES.         
           05 WS-DISPLAY-SQLCODE        PIC ---9.                       
           05 WS-CURR-TMSTMP            PIC X(26) VALUE SPACES.         
           05 WS-LAG-LEAD-VALUE         PIC X(19) VALUE SPACES.         
           05 WS-ACCOUNT-NO-NUM         PIC 9(13) VALUE ZEROS.          
           05 WS-SERVICE-POINT-ID.                                      
              10 WS-COMPANY-NO-SP       PIC X(02) VALUE SPACES.         
              10 WS-PREMISE-NO          PIC 9(10) VALUE 0.              
              10 WS-CODE-UTIL-TYPE-SP   PIC X(01) VALUE SPACES.         
              10 WS-IC-NO               PIC 9(04) VALUE 0.              
              10 WS-MTR-REF-NO          PIC 9(04) VALUE 0.              
           05 WS-METER-ID.                                              
              10 WS-COMPANY-NO          PIC X(02).                      
              10 WS-CODE-UTIL-TYPE      PIC X(01).                      
              10 WS-METER-NO            PIC X(09).                      
           05 WS-LAST-READ-DATE         PIC X(10) VALUE SPACES.         
           05 WS-SCHEDULED-READ-DATE    PIC X(10) VALUE SPACES.         
           05 WS-WINDOW-END-DATE        PIC X(10) VALUE SPACES.         
           05 WS-BN-DATE-EXTRACT        PIC X(10) VALUE SPACES.         
           05 WS-LAST-READ-DATE1        PIC X(10) VALUE SPACES.         
           05 WS-SCHEDULED-READ-DATE1   PIC X(10) VALUE SPACES.         
A#5347     05 WS-WAIT-UNTIL-DATE        PIC X(10) VALUE SPACES.         
           05 WS-WINDOW-END-DATE1       PIC X(10) VALUE SPACES.         
           05 WS-DB2-DATE               PIC X(10) VALUE SPACES.         
           05 WS-LAST-RD-TIME.                                          
              10  WS-LAST-RD-TIME-HH      PIC X(02).                    
              10  FILLER                  PIC X(01).                    
              10  WS-LAST-RD-TIME-MM      PIC X(02).                    
              10  FILLER                  PIC X(01).                    
              10  WS-LAST-RD-TIME-SS      PIC X(02).                    
           05 WS-SEASN-MMDD-NUM         PIC 9(04).                      
           05 WS-SEASN-MMDD-AN REDEFINES WS-SEASN-MMDD-NUM.             
              10 WS-SEASN-TEMP-MM       PIC 9(2).                       
              10 WS-SEASN-TEMP-DD       PIC 9(2).                       
           05 WS-SEASN1-END-DATE.                                       
              10 WS-SEASN1-END-CCYY     PIC 9(4).                       
              10 FILLER                 PIC X(1) VALUE '-'.             
              10 WS-SEASN1-END-MM       PIC 9(2).                       
              10 FILLER                 PIC X(1) VALUE '-'.             
              10 WS-SEASN1-END-DD       PIC 9(2).                       
           05 WS-SEASN2-END-DATE.                                       
              10 WS-SEASN2-END-CCYY     PIC 9(4).                       
              10 FILLER                 PIC X(1) VALUE '-'.             
              10 WS-SEASN2-END-MM       PIC 9(2).                       
              10 FILLER                 PIC X(1) VALUE '-'.             
              10 WS-SEASN2-END-DD       PIC 9(2).                       
           05 WS-DATE-BREAKDOWN-ISO.                                    
              10 WS-DATE-CCYYMMDD       PIC X(10).                      
              10 FILLER                 PIC X(1) VALUE 'T'.             
              10 WS-TIME-HH             PIC 9(2).                       
              10 FILLER                 PIC X(1) VALUE ':'.             
              10 WS-TIME-MM             PIC 9(2).                       
           05 WS-DATE-BREAKDOWN-USA.                                    
              10 WS-DATE-MM2            PIC 9(2).                       
              10 FILLER                 PIC X(1) VALUE '/'.             
              10 WS-DATE-DD2            PIC 9(2).                       
              10 FILLER                 PIC X(1) VALUE '/'.             
              10 WS-DATE-CCYY2          PIC 9(4).                       
           05 WS-CTRL-DAYS-REDEF.                                       
              10 WS-CTRL-DAYS-SIGN      PIC X(1).                       
              10 WS-CTRL-DAYS-VALUE     PIC 9(1).                       
           05 WS-LAST-UPD-TMST-PARM.                                    
              10 WS-LAST-UPD-TMST-TX    PIC X(14) VALUE                 
                                                 'LAST-UPD-TMST='.      
              10 WS-LAST-UPD-TMST-VALUE PIC X(26).                      
      *                                                                         
       01 WS-WORK-QUEUE-TEMP.                                           
          05 WS-CATEGORY-ID-141         PIC S9(04)  COMP VALUE 141.     
          05 WS-CATEGORY-ID-142         PIC S9(04)  COMP VALUE 142.     
          05 WS-CATEGORY-ID-157         PIC S9(04)  COMP VALUE 157.     
          05 WS-CATEGORY-ID-173         PIC S9(04)  COMP VALUE 173.     
          05 WS-CATEGORY-ID-282         PIC S9(04)  COMP VALUE 282.     
          05 WS-CATEGORY-ID-283         PIC S9(04)  COMP VALUE 283.     
          05 WS-CATEGORY-ID-284         PIC S9(04)  COMP VALUE 284.     
          05 WS-CATEGORY-ID-289         PIC S9(04)  COMP VALUE 289.     
          05 WS-CATEGORY-ID-232         PIC S9(04)  COMP VALUE 232.     
          05 WS-CATEGORY-ID-528         PIC S9(04)  COMP VALUE 528.     
          05 WS-CATEGORY-ID-529         PIC S9(04)  COMP VALUE 529.     
          05 WS-CATEGORY-ID-15          PIC S9(04)  COMP VALUE  15.     
          05 WS-ROUTING-CATEGORY        PIC X(01)   VALUE ' '.          
          05 WS-NORMAL-PRIORITY         PIC X(01)   VALUE 'N'.          
          05 WS-WQ-MESSAGE              PIC X(223) VALUE SPACES.        
          05 WS-HOLD-WQ-CATEGORY        PIC 9(03).                      
          05 WS-COMMENTS-TEMP           PIC X(223).                     
          05 WS-BUMP-DAYS               PIC S9(4) USAGE COMP.           
          05 WS-DISPLAY-BUMP-DAYS       PIC --9.                        
          05 WS-TALLY                   PIC 9(02) VALUE 0.              
          05 WS-DEMAND-FL               PIC X(01) VALUE SPACE.          
      *                                                                         
       01 WS-WORK-QUEUE-MSGS.                                           
          05 WS-WQ-MSG-SIXTY-DAYS.                                      
             10 FILLER                  PIC X(15) VALUE                 
             'OPENWAY METER: '.                                         
             10 WS-WQ-METER-NO          PIC X(09).                      
             10 FILLER                  PIC X(13) VALUE                 
                          ' LAST RD DT: '.                              
             10 WS-WQ-LAST-RD-DT        PIC X(10).                      
             10 FILLER                  PIC X(13) VALUE                 
                          ' CURR RD DT: '.                              
             10 WS-WQ-CURR-RD-DT        PIC X(10).                      
             10 FILLER                  PIC X(34) VALUE                 
             ' UNABLE TO LOAD READINGS FROM MDM,'.                      
             10 FILLER                  PIC X(27) VALUE                 
             ' > 60 DAYS SINCE LAST READ.'.                             
             10 FILLER                  PIC X(43) VALUE                 
             ' PLEASE MANUALLY COLLECT READINGS FROM MDM.'.             
      *                                                                         
       01 FIOBW61-HEADER-RECORD.                                        
          05 FILLER                     PIC X(12) VALUE                 
                                            'DeadlineDate'.             
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(13) VALUE                 
                                            'WaitUntilDate'.            
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(07) VALUE                 
                                            'CycleID'.                  
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(08) VALUE                 
                                            'EntityID'.                 
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(13) VALUE                 
                                            'BillStartDate'.            
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(12) VALUE                 
                                            'BillStopDate'.             
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(08) VALUE                 
                                            'RateType'.                 
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(12) VALUE                 
                                            'RegisterType'.             
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(10) VALUE                 
                                            'ExportMode'.               
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(11) VALUE                 
                                            'RequestType'.              
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(17) VALUE                 
                                            'PassThroughData01'.        
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(17) VALUE                 
                                            'PassThroughData02'.        
          05 FILLER                     PIC X(01) VALUE ','.            
          05 FILLER                     PIC X(17) VALUE                 
                                            'PassThroughData03'.        
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-YES                     PIC X(01) VALUE 'Y'.            
          05 WS-I                       PIC X(01) VALUE 'I'.            
          05 WS-Y                       PIC X(01) VALUE 'Y'.            
          05 WS-N                       PIC X(01) VALUE 'N'.            
          05 WS-NO                      PIC X(01) VALUE 'N'.            
          05 WS-EXIT                    PIC X(01) VALUE 'N'.            
          05 WS-181                     PIC S9(9) VALUE -181.           
          05 WS-COMMON                  PIC X(06) VALUE 'COMMON'.       
          05 WS-PRGM-NAME               PIC X(08) VALUE 'PCSBW161'.     
          05 WS-PGRMNAME                PIC X(08) VALUE 'PCSBW161'.     
          05 PROGRAM-NAME               PIC X(08) VALUE 'PCSBW161'.     
          05 RS-RETURN-CODE             PIC S9(09) VALUE +000 COMP.     
          05 RS-RETURN-CODE-DISP        PIC S9(09) VALUE +000 COMP.     
          05 WS-EXPORT-MODE             PIC X(08) VALUE 'FreeFlow'.     
          05 WS-RATE-TYPE               PIC X(07) VALUE 'Billing'.      
          05 WS-REGISTER-TYPE           PIC X(03) VALUE 'All'.          
          05 WS-INACTIVE-TURN-OFF       PIC X(01) VALUE 'J'.            
          05 WS-WORK-DATE.                                              
             10 WS-WORK-CCYY            PIC 9(04).                      
             10 FILLER                  PIC X(01).                      
             10 WS-WORK-MM              PIC 9(02).                      
             10 FILLER                  PIC X(01).                      
             10 WS-WORK-DD              PIC 9(02).                      
       01  WS-MIS.                                                      
           05  SCSCB077                 PIC X(08) VALUE 'SCSCB077'.     
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTEHDR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBUSDAY                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DCLGEN FOR CSS_MDM_SS_INTF 1D                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMDMINT                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DCLGEN FOR CSS_MDM_SS_INTF_CH 1E                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMDMCHG                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DCLGEN FOR CSS_RATE_PLAN_DESC                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DCLGEN FOR CSS_CNSMPTN_HIST                                *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DCLGEN FOR CSS_ROUTE_REPORT                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTERPT                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DCLGEN FOR CSS_RATE_USE_SEASN                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTUSES                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DCLGEN FOR CSS_RATE_CREATOR                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTCRTR                                                 
           END-EXEC.                                                            
      *                                                                         
      ******* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
           EXEC SQL                                                             
                INCLUDE CWS00077                                                
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *****************************************************************         
      *    DCLGEN FOR CSS_RATE_VRSN_DEF                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTVRSN                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE CYL_OPEN_CSR CURSOR FOR                         
                SELECT RW1.READ_CYCLE                                   
                      ,RW1.REVENUE_MONTH                                
                      ,RW1.OPTIMUM_READ_DATE                            
                      ,BN1.DATE_EXTRACT                                 
                FROM CSS_BILL_WINDOW BN1 WITH(READUNCOMMITTED)                  
                    ,CSS_READ_WINDOW RW1 WITH(READUNCOMMITTED)                  
                WHERE BN1.DATE_EXTRACT      = IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
                  AND BN1.BILL_CYCLE  <= '20'                           
                  AND RW1.REVENUE_MONTH     = BN1.REVENUE_MONTH         
                  AND RW1.READ_CYCLE        = BN1.BILL_CYCLE            
                  AND BN1.DATE_EXTRACT      =                           
                      (SELECT MIN(BN2.DATE_EXTRACT)                     
                       FROM CSS_BILL_WINDOW BN2 WITH(READUNCOMMITTED)           
                       WHERE BN2.BILL_CYCLE    = BN1.BILL_CYCLE         
                         AND BN2.REVENUE_MONTH = BN1.REVENUE_MONTH)     
                UNION ALL                                               
                SELECT RW1.READ_CYCLE                                   
                      ,RW1.REVENUE_MONTH                                
                      ,DATEADD( DAY, 1, RW1.OPTIMUM_READ_DATE )                 
                      ,BN1.DATE_EXTRACT                                 
                FROM CSS_BILL_WINDOW BN1 WITH(READUNCOMMITTED)                  
                    ,CSS_READ_WINDOW RW1 WITH(READUNCOMMITTED)                  
                WHERE BN1.DATE_EXTRACT      = IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
                  AND BN1.BILL_CYCLE  = '21'                            
                  AND RW1.REVENUE_MONTH     = BN1.REVENUE_MONTH         
                  AND RW1.READ_CYCLE        = BN1.BILL_CYCLE            
                  AND BN1.DATE_EXTRACT      =                           
                      (SELECT MIN(BN2.DATE_EXTRACT)                     
                       FROM CSS_BILL_WINDOW BN2 WITH(READUNCOMMITTED)           
                       WHERE BN2.BILL_CYCLE    = BN1.BILL_CYCLE         
                         AND BN2.REVENUE_MONTH = BN1.REVENUE_MONTH)     
                ORDER BY 1                                              
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CYL_OPEN_CSR CURSOR FOR                                 
MFA-TR*         SELECT RW1.READ_CYCLE                                           
MFA-TR*               ,RW1.REVENUE_MONTH                                        
MFA-TR*               ,RW1.OPTIMUM_READ_DATE                                    
MFA-TR*               ,BN1.DATE_EXTRACT                                         
MFA-TR*         FROM CSS_BILL_WINDOW BN1                                        
MFA-TR*             ,CSS_READ_WINDOW RW1                                        
MFA-TR*         WHERE BN1.DATE_EXTRACT      = :WS-RUN-DATE                      
MFA-TR*           AND BN1.BILL_CYCLE  <= '20'                                   
MFA-TR*           AND RW1.REVENUE_MONTH     = BN1.REVENUE_MONTH                 
MFA-TR*           AND RW1.READ_CYCLE        = BN1.BILL_CYCLE                    
MFA-TR*           AND BN1.DATE_EXTRACT      =                                   
MFA-TR*               (SELECT MIN(BN2.DATE_EXTRACT)                             
MFA-TR*                FROM CSS_BILL_WINDOW BN2                                 
MFA-TR*                WHERE BN2.BILL_CYCLE    = BN1.BILL_CYCLE                 
MFA-TR*                  AND BN2.REVENUE_MONTH = BN1.REVENUE_MONTH)             
MFA-TR*         UNION ALL                                                       
MFA-TR*         SELECT RW1.READ_CYCLE                                           
MFA-TR*               ,RW1.REVENUE_MONTH                                        
MFA-TR*               ,RW1.OPTIMUM_READ_DATE + 1 DAY                            
MFA-TR*               ,BN1.DATE_EXTRACT                                         
MFA-TR*         FROM CSS_BILL_WINDOW BN1                                        
MFA-TR*             ,CSS_READ_WINDOW RW1                                        
MFA-TR*         WHERE BN1.DATE_EXTRACT      = :WS-RUN-DATE                      
MFA-TR*           AND BN1.BILL_CYCLE  = '21'                                    
MFA-TR*           AND RW1.REVENUE_MONTH     = BN1.REVENUE_MONTH                 
MFA-TR*           AND RW1.READ_CYCLE        = BN1.BILL_CYCLE                    
MFA-TR*           AND BN1.DATE_EXTRACT      =                                   
MFA-TR*               (SELECT MIN(BN2.DATE_EXTRACT)                             
MFA-TR*                FROM CSS_BILL_WINDOW BN2                                 
MFA-TR*                WHERE BN2.BILL_CYCLE    = BN1.BILL_CYCLE                 
MFA-TR*                  AND BN2.REVENUE_MONTH = BN1.REVENUE_MONTH)             
MFA-TR*         ORDER BY 1                                                      
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******                                                                    
           EXEC SQL                                                     
                DECLARE GET_MTR_CSR CURSOR FOR                          
                SELECT AT.ACCOUNT_NO                                    
                      ,AT.BILL_CYCLE                                    
                      ,AT.LOCAL_OFFICE                                  
                      ,AT.PREMISE_NO                                    
                      ,AT.CUSTOMER_NO                                   
                      ,AT.COMPANY_NO                                    
                      ,UT.READ_ROUTE                                    
                      ,UT.RATE_PLAN_NO                                  
                      ,MN.CODE_UTIL_TYPE                                
                      ,MN.IC_NO                                         
                      ,MN.MTR_REF_NO                                    
                      ,MN.METER_NO                                      
                      ,MN.DATE_MTR_INSTALL                              
                      ,MN.LAST_REG_READ_DATE                            
                      ,REPLACE(CONVERT(CHAR(8), MN.LAST_REG_READ_TIME
           , 108), ':', '.') LAST_REG_READ_TIME                            
                      ,MN.CODE_CRNT_REG_READ                            
                      ,MN.CODE_NO_RD_REASON                             
                      ,MN.CODE_METER_STATUS                             
                FROM  CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                 
                     ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                     ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
                WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO             
                  AND MN.ACCOUNT_NO         = UT.ACCOUNT_NO             
                  AND MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE         
                  AND MN.IC_NO              = UT.IC_NO                  
                  AND UT.READ_CYCLE         = :UT-READ-CYCLE            
                  AND MN.CODE_UTIL_TYPE     = 'E'                       
                  AND MN.MTR_READ_SOURCE_CD = 'P'                       
                  AND MN.CODE_METER_STATUS <> 'K'                       
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE GET_MTR_CSR CURSOR FOR                                  
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*               ,AT.BILL_CYCLE                                            
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*               ,AT.CUSTOMER_NO                                           
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*               ,UT.READ_ROUTE                                            
MFA-TR*               ,UT.RATE_PLAN_NO                                          
MFA-TR*               ,MN.CODE_UTIL_TYPE                                        
MFA-TR*               ,MN.IC_NO                                                 
MFA-TR*               ,MN.MTR_REF_NO                                            
MFA-TR*               ,MN.METER_NO                                              
MFA-TR*               ,MN.DATE_MTR_INSTALL                                      
MFA-TR*               ,MN.LAST_REG_READ_DATE                                    
MFA-TR*               ,MN.LAST_REG_READ_TIME                                    
MFA-TR*               ,MN.CODE_CRNT_REG_READ                                    
MFA-TR*               ,MN.CODE_NO_RD_REASON                                     
MFA-TR*               ,MN.CODE_METER_STATUS                                     
MFA-TR*         FROM  CSS_ACCOUNT      AT                                       
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_MTRD_ENVRNMT MN                                       
MFA-TR*         WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO                     
MFA-TR*           AND MN.ACCOUNT_NO         = UT.ACCOUNT_NO                     
MFA-TR*           AND MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE                 
MFA-TR*           AND MN.IC_NO              = UT.IC_NO                          
MFA-TR*           AND UT.READ_CYCLE         = :UT-READ-CYCLE                    
MFA-TR*           AND MN.CODE_UTIL_TYPE     = 'E'                               
MFA-TR*           AND MN.MTR_READ_SOURCE_CD = 'P'                               
MFA-TR*           AND MN.CODE_METER_STATUS <> 'K'                               
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******                                                                    
      *                                                                         
           EXEC SQL                                                     
              DECLARE GET_ACCTCHG_CSR CURSOR FOR                        
                 SELECT SERVICE_POINT_ID                                
                       ,COLUMN_NA                                       
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                       ,PREV_COLUMN_VALUE                               
                       ,CURR_COLUMN_VALUE                               
                       ,LAST_UPDATE_PGM_ID                              
                 FROM  CSS_MDM_SS_INTF_CH WITH(READUNCOMMITTED)                 
                 WHERE LAST_UPDATE_TS  > CIS.CHAR2TIMESTAMP(
                                                    :WS-TIME-STAMP-PARM
              )            
                   AND LAST_UPDATE_TS <= CIS.CHAR2TIMESTAMP(
                                                        :WS-CURR-TMSTMP
              )                
                   AND COLUMN_NA       = 'ACCOUNT_NO'                   
                 ORDER BY SERVICE_POINT_ID                              
                         ,LAST_UPDATE_TS                                
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_ACCTCHG_CSR CURSOR FOR                                
MFA-TR*          SELECT SERVICE_POINT_ID                                        
MFA-TR*                ,COLUMN_NA                                               
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,PREV_COLUMN_VALUE                                       
MFA-TR*                ,CURR_COLUMN_VALUE                                       
MFA-TR*                ,LAST_UPDATE_PGM_ID                                      
MFA-TR*          FROM  CSS_MDM_SS_INTF_CH                                       
MFA-TR*          WHERE LAST_UPDATE_TS  > :WS-TIME-STAMP-PARM                    
MFA-TR*            AND LAST_UPDATE_TS <= :WS-CURR-TMSTMP                        
MFA-TR*            AND COLUMN_NA       = 'ACCOUNT_NO'                           
MFA-TR*          ORDER BY SERVICE_POINT_ID                                      
MFA-TR*                  ,LAST_UPDATE_TS                                        
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7710                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******                                                                    
           EXEC SQL                                                     
              DECLARE GET_METRCHG_CSR CURSOR FOR                        
                 SELECT SERVICE_POINT_ID                                
                       ,COLUMN_NA                                       
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                       ,PREV_COLUMN_VALUE                               
                       ,CURR_COLUMN_VALUE                               
                       ,LAST_UPDATE_PGM_ID                              
                 FROM  CSS_MDM_SS_INTF_CH WITH(READUNCOMMITTED)                 
                 WHERE LAST_UPDATE_TS  > CIS.CHAR2TIMESTAMP(
                                                    :WS-TIME-STAMP-PARM
              )            
                   AND LAST_UPDATE_TS <= CIS.CHAR2TIMESTAMP(
                                                        :WS-CURR-TMSTMP
              )                
                   AND COLUMN_NA       = 'METER_NO'                     
                 ORDER BY SERVICE_POINT_ID                              
                         ,LAST_UPDATE_TS                                
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_METRCHG_CSR CURSOR FOR                                
MFA-TR*          SELECT SERVICE_POINT_ID                                        
MFA-TR*                ,COLUMN_NA                                               
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,PREV_COLUMN_VALUE                                       
MFA-TR*                ,CURR_COLUMN_VALUE                                       
MFA-TR*                ,LAST_UPDATE_PGM_ID                                      
MFA-TR*          FROM  CSS_MDM_SS_INTF_CH                                       
MFA-TR*          WHERE LAST_UPDATE_TS  > :WS-TIME-STAMP-PARM                    
MFA-TR*            AND LAST_UPDATE_TS <= :WS-CURR-TMSTMP                        
MFA-TR*            AND COLUMN_NA       = 'METER_NO'                             
MFA-TR*          ORDER BY SERVICE_POINT_ID                                      
MFA-TR*                  ,LAST_UPDATE_TS                                        
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7740                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
                                                                        
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
      *                                                                         
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
      *                                                                         
      *Regular Cyle                                                             
           PERFORM 1000-PROCESS-EACH-CYCLE THRU 1000-EXIT               
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
      *                                                                         
      *Service order Account Change                                             
           PERFORM 2000-GET-SO-ACCT-CHNG   THRU 2000-EXIT               
      *                                                                         
      *Service order Meter Change                                               
           PERFORM 2400-GET-SO-METR-CHNG   THRU 2400-EXIT               
      *                                                                         
           MOVE WS-CURR-TMSTMP          TO WS-LAST-UPD-TMST-VALUE       
           MOVE WS-LAST-UPD-TMST-PARM   TO G6-PARM-DATA                 
      *                                                                         
           PERFORM 8900-UPDATE-TIMESTMP    THRU 8900-EXIT               
      *                                                                         
           PERFORM 9000-TERMINATE          THRU 9000-EXIT               
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           OPEN OUTPUT FCSBW61-FILE.                                    
           IF  FBW61-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************* PCSBW161 ************'             
              DISPLAY '** BW61 FILE OPEN STATUS = ' WS-FBW61-STATUS     
              DISPLAY '** PROCESSING TERMINATED         **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
      *                                                                         
      ***  TO WRITE HEADER RECORDS                                              
           MOVE FIOBW61-HEADER-RECORD   TO FIOBW61-RECORD               
           PERFORM 8000-WRITE-FIOBW61      THRU 8000-EXIT.              
      *                                                                         
           MOVE ZEROS TO WS-FIOBW61-COUNT.                              
                                                                        
           PERFORM 7250-GET-CURR-DATE      THRU 7250-EXIT.              
                                                                        
           PERFORM 0200-GET-PARM-DATA      THRU 0200-EXIT.              
                                                                        
           PERFORM 7050-OPEN-CYL-OPEN-CSR  THRU 7050-EXIT.              
                                                                        
           PERFORM 7060-FETCH-CYL-OPEN-CSR THRU 7060-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              DISPLAY ' '                                               
              DISPLAY '**************************************'          
              DISPLAY '***      NO CYCLE OPENS TODAY      ***'          
              DISPLAY '**************************************'          
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0200-GET-PARM-DATA.                                              
      *================================================================*        
      *                                                                         
           MOVE '01'                    TO G6-COMPANY-NO.               
      ***  GET INPUT DATE                                                       
           PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT.              
                                                                        
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               DISPLAY 'COMMONDATE ==> ' WS-FCA00-COMMON-DATE           
               MOVE WS-FCA00-COMMON-DATE   TO WS-INPUT-DATE             
                                              WS-NEW-BUSINESS-DAY       
               PERFORM 6500-GET-NEXT-BUSINESS-DAY                       
                  THRU 6500-NEXT-BUSINESS-DAY-EXIT                      
                       UNTIL NEXT-BUSINESS-DAY-FOUND                    
               MOVE WS-NEW-BUSINESS-DAY    TO WS-INPUT-DATE             
               DISPLAY 'NEW BUSINESS DAY ==> ' WS-NEW-BUSINESS-DAY      
                                                                        
               PERFORM 0210-GET-BUMP-DAYS  THRU 0210-EXIT               
                                                                        
      *** CONFIGURE EXTRACT DATE USING THE BUMP DAYS & INPUT DATE               
               PERFORM 7000-GET-EXTRACT-DATE   THRU 7000-EXIT           
               MOVE 1G-BUSINESS-DAY-DT     TO WS-INPUT-DATE             
               DISPLAY '1G-BUSINESS-DAY-DT ==> : ' 1G-BUSINESS-DAY-DT   
           ELSE                                                         
               DISPLAY 'OVERRIDE RUN DATE  ==> : ' WS-INPUT-DATE        
           END-IF.                                                      
      *                                                                         
           DISPLAY ' '                                                  
           DISPLAY '************************************'               
           DISPLAY  'PROGRAM RUN DATE  ======> ' WS-INPUT-DATE          
           DISPLAY  'CURRENT DATE      ======> ' WS-CURR-DATE           
           DISPLAY '************************************'               
                                                                        
           MOVE WS-INPUT-DATE              TO WS-RUN-DATE               
                                              WS-WORK-DATE.             
      *                                                                         
      ***  GET LAG/LEAD                                                         
           PERFORM 0220-GET-LAG-LEAD          THRU 0220-EXIT            
           MOVE WS-LAG-LEAD                TO WS-LAG-LEAD-VALUE         
           DISPLAY 'LAG-LEAD           ==> ' WS-LAG-LEAD-VALUE          
           DISPLAY ' '                                                  
      *                                                                         
      ***  GET LAST-UPDATE=TS                                                   
           PERFORM 0230-GET-LAST-UPDT-TS      THRU 0230-EXIT.           
           DISPLAY 'JOBPARM TIMESTAMP  ==> '  WS-TIME-STAMP-PARM        
           DISPLAY 'CURRENT TIMESTAMP  ==> '  WS-CURR-TMSTMP            
           DISPLAY '  '.                                                
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0210-GET-BUMP-DAYS.                                              
      *================================================================*        
      *                                                                         
      *** GET BUMP DAYS THAT CONTROL THE READ REQUEST BETWEEN CIS & IEE         
      *** FROM JOB PARM                                                         
           MOVE SPACES                    TO WS-SYSIPT                  
           MOVE ZEROS                     TO WS-SEQUENCE                
           MOVE WS-PARM                   TO WS-COMMAND                 
           MOVE WS-KEY-AREA               TO E-FJC01-KEY                
           PERFORM 7600-START-FCSJC01        THRU 7600-EXIT             
           PERFORM 7610-READ-FCSJC01         THRU 7610-EXIT             
             UNTIL (CONTROL-DAYS AND INPUT-ACTIVE)                      
                OR  END-OF-SYSIPT                                       
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY '**     PCSBW161 PROCESSING ERROR     **'         
              DISPLAY '** CIS-IEE CONTROL DAYS NOT PRESENT  **'         
              DISPLAY '**  KEY = ' E-FJC01-KEY                          
              DISPLAY '**        PROCESSING TERMINATED      **'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           ELSE                                                         
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
           END-IF                                                       
                                                                        
           MOVE WS-CTRL-DAYS          TO WS-CTRL-DAYS-REDEF             
                                                                        
           IF WS-CTRL-DAYS-SIGN EQUAL '-'                               
              COMPUTE WS-BUMP-DAYS = WS-CTRL-DAYS-VALUE * -1            
           ELSE                                                         
              COMPUTE WS-BUMP-DAYS = WS-CTRL-DAYS-VALUE                 
           END-IF                                                       
                                                                        
           MOVE WS-BUMP-DAYS          TO WS-DISPLAY-BUMP-DAYS           
           DISPLAY 'CONTROL-DAYS       ==> ' WS-DISPLAY-BUMP-DAYS.      
           DISPLAY ' '.                                                 
      *                                                                         
       0210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0220-GET-LAG-LEAD.                                               
      *================================================================*        
      *                                                                         
           MOVE SPACES                    TO WS-SYSIPT                  
           MOVE ZEROS                     TO WS-SEQUENCE                
           MOVE WS-PARM                   TO WS-COMMAND                 
           MOVE WS-KEY-AREA               TO E-FJC01-KEY                
           PERFORM 7600-START-FCSJC01        THRU 7600-EXIT             
           PERFORM 7610-READ-FCSJC01         THRU 7610-EXIT             
             UNTIL (LAG-LEAD AND INPUT-ACTIVE)                          
                OR  END-OF-SYSIPT                                       
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY '**     PCSBW161 PROCESSING ERROR     **'         
              DISPLAY '**        LAG-LEAD NOT PRESENT       **'         
              DISPLAY '**  KEY = ' E-FJC01-KEY                          
              DISPLAY '**        PROCESSING TERMINATED      **'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           ELSE                                                         
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
           END-IF.                                                      
      *                                                                         
       0220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0230-GET-LAST-UPDT-TS.                                           
      *================================================================*        
      *                                                                         
           MOVE SPACES                    TO WS-SYSIPT                  
           MOVE ZEROS                     TO WS-SEQUENCE                
           MOVE WS-PARM                   TO WS-COMMAND                 
           MOVE WS-KEY-AREA               TO E-FJC01-KEY                
           PERFORM 7600-START-FCSJC01        THRU 7600-EXIT             
           PERFORM 7610-READ-FCSJC01         THRU 7610-EXIT             
             UNTIL (TIME-STAMP AND INPUT-ACTIVE)                        
                OR  END-OF-SYSIPT                                       
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY '**     PCSBW161 PROCESSING ERROR     **'         
              DISPLAY '**      LAST UPDATE TIMESTMP         **'         
              DISPLAY '**  KEY = ' E-FJC01-KEY                          
              DISPLAY '**        PROCESSING TERMINATED      **'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           ELSE                                                         
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
           END-IF.                                                      
      *                                                                         
       0230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-PROCESS-EACH-CYCLE.                                         
      *================================================================*        
      *                                                                         
           DISPLAY ' '                                                  
           DISPLAY '************************************'               
           DISPLAY '*** PROCESSING CYCLE  ======> ' RW-READ-CYCLE ' ***'
           DISPLAY '************************************'               
                                                                        
           MOVE RW-READ-CYCLE              TO UT-READ-CYCLE             
A#5347     MOVE SPACES                     TO WS-SERVICE-POINT-ID       
           PERFORM 7100-OPEN-MTR-CSR          THRU 7100-EXIT.           
           PERFORM 7110-FETCH-MTR-CSR         THRU 7110-EXIT.           
           PERFORM 1100-PROCESS-EACH-METER    THRU 1100-EXIT            
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 7120-CLOSE-MTR-CSR         THRU 7120-EXIT.           
                                                                        
           PERFORM 1200-PROCESS-ROUTES        THRU 1200-EXIT            
                                                                        
           PERFORM 7060-FETCH-CYL-OPEN-CSR    THRU 7060-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1100-PROCESS-EACH-METER.                                         
      *================================================================*        
      *                                                                         
           MOVE AT-PREMISE-NO              TO WS-CPD99-PREMISE-NO       
           MOVE ZERO                       TO WS-NULL-IND               
                                                                        
           PERFORM 6990-FETCH-CUR-ACCOUNT     THRU  6990-EXIT           
           IF WS-CPD99-ACCOUNT-NO = AT-ACCOUNT-NO                       
              MOVE AT-ACCOUNT-NO           TO MN-ACCOUNT-NO             
                                              UT-ACCOUNT-NO             
              PERFORM 1400-CHECK-SEASON-CHG   THRU 1400-EXIT            
              PERFORM 1600-PROCESS-READ-REQU  THRU 1600-EXIT            
           END-IF                                                       
                                                                        
           PERFORM 7110-FETCH-MTR-CSR         THRU 7110-EXIT.           
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1200-PROCESS-ROUTES.                                             
      *================================================================*        
      *** UPDATE ROUTE HEADER DOWNLOAD MTR QUANTITY ON EACH CYCLE.              
      *                                                                         
           MOVE '000'                      TO RH-LOCAL-OFFICE           
           MOVE 0                          TO RH-READ-ROUTE             
           MOVE AT-COMPANY-NO              TO RH-COMPANY-NO             
           MOVE RW-READ-CYCLE              TO RH-READ-CYCLE             
           MOVE RW-REVENUE-MONTH           TO RH-REVENUE-MONTH          
           MOVE WS-INPUT-DATE              TO RH-DOWNLOAD-DATE          
           MOVE WS-DOWNLD-MTR-COUNT        TO RH-DOWNLOAD-METERS        
           MOVE ZEROS                      TO WS-DOWNLD-MTR-COUNT       
                                                                        
           PERFORM 8300-INSERT-ROUTE-HDR      THRU 8300-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = ALREADY-EXISTS                    
              PERFORM 8400-UPDATE-ROUTE-HDR   THRU 8400-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       1400-CHECK-SEASON-CHG.                                           
      *===============================================================*         
      *** CHECK FOR SEASON CHANGE.                                              
      *                                                                         
           MOVE SPACES                     TO J4-SEAS-PRORATE-CD        
           INITIALIZE     WS-SEASN1-END-DATE                            
                          WS-SEASN2-END-DATE                            
                          WS-SEASN-MMDD-NUM.                            
                                                                        
           SET NON-SEASON-RATE             TO TRUE                      
           MOVE MN-CODE-UTIL-TYPE          TO RT-CODE-UTIL-TYPE         
                                              RS-CODE-UTIL-TYPE         
                                              J4-CODE-UTIL-TYPE.        
                                                                        
           MOVE UT-RATE-PLAN-NO            TO RT-RATE-PLAN-NO           
                                              RS-RATE-PLAN-NO           
                                              J4-RATE-PLAN-NO.          
                                                                        
           PERFORM 7210-SELECT-RATE-VERSION   THRU 7210-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RT-VERSION-NO-CNTRL     TO RS-VERSION-NO-CNTRL       
                                              J4-VERSION-NO-CNTRL       
              PERFORM 7230-GET-SEASN-PRT-TYPE THRU 7230-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              AND J4-SEAS-PRORATE-CD = 'U'                              
      ***CONSIDER ONLY WHEN SEASONAL PRORATE IS BY USAGE DAYS.                  
              PERFORM 7220-SELECT-SEASONS     THRU 7220-EXIT            
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 SET SEASON-RATE-BY-USAGE  TO TRUE                      
                 MOVE RS-DATE-FROM         TO WS-SEASN-MMDD-NUM         
                 MOVE WS-WORK-CCYY         TO WS-SEASN1-END-CCYY        
                                              WS-SEASN2-END-CCYY        
                 MOVE WS-SEASN-TEMP-MM     TO WS-SEASN1-END-MM          
                 MOVE WS-SEASN-TEMP-DD     TO WS-SEASN1-END-DD          
                                                                        
                 MOVE RS-DATE-TO           TO WS-SEASN-MMDD-NUM         
                 MOVE WS-SEASN-TEMP-MM     TO WS-SEASN2-END-MM          
                 MOVE WS-SEASN-TEMP-DD     TO WS-SEASN2-END-DD          
                 MOVE WS-SEASN2-END-DATE   TO WS-DB2-DATE               
                                                                        
                 PERFORM 7240-ADD-ONE-DAY     THRU 7240-EXIT            
                                                                        
                 MOVE WS-DB2-DATE          TO WS-SEASN2-END-DATE        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1600-PROCESS-READ-REQU.                                          
      *================================================================*        
      *                                                                         
           MOVE AT-COMPANY-NO              TO WS-COMPANY-NO             
           MOVE MN-CODE-UTIL-TYPE          TO WS-CODE-UTIL-TYPE         
           MOVE MN-METER-NO                TO WS-METER-NO               
                                                                        
           MOVE SPACES                     TO WS-LAST-READ-DATE1        
                                              WS-SCHEDULED-READ-DATE1   
                                              WS-WINDOW-END-DATE1       
                                              WS-WINDOW-END-DATE        
                                              WS-BN-DATE-EXTRACT        
                                                                        
           MOVE MN-LAST-REG-READ-DATE      TO WS-LAST-READ-DATE         
           MOVE RW-OPTIMUM-READ-DATE       TO WS-SCHEDULED-READ-DATE    
                                                                        
      *** To give IEE more time, Window-End-Date is bumped by 1 day             
           PERFORM 7500-SET-WINDOW-END-DATE   THRU 7500-EXIT            
           MOVE WS-BN-DATE-EXTRACT         TO WS-WINDOW-END-DATE        
                                                                        
      ***  ADJUST LAST READ DATE INCASE OF INACTIVE/TURNED OFF METERS           
      ***  IF NUM OF DAYS > 55                                                  
           IF MN-CODE-METER-STATUS = WS-INACTIVE-TURN-OFF               
              PERFORM 7300-GET-NO-DAYS     THRU 7300-EXIT               
              IF WS-NO-READ-DAYS > 55                                   
                 PERFORM 7400-SET-LAST-READ-DATE   THRU 7400-EXIT       
                 MOVE WS-LAST-READ-DATE    TO MN-LAST-REG-READ-DATE     
                 MOVE '00:00:00'           TO MN-LAST-REG-READ-TIME     
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF SEASON-RATE-BY-USAGE                                      
              PERFORM 1610-GET-SEASN-BILL-PERIOD THRU 1610-EXIT         
           END-IF.                                                      
                                                                        
           SET INIT-READ-REQU              TO TRUE                      
           PERFORM 1650-SEND-READ-REQU     THRU 1650-EXIT.              
                                                                        
           IF READ-REQU-SENT                                            
              COMPUTE WS-DOWNLD-MTR-COUNT = WS-DOWNLD-MTR-COUNT + 1     
              IF MN-CODE-CRNT-REG-READ = 'D'                            
                 AND MN-CODE-NO-RD-REASON = SPACES                      
                 CONTINUE                                               
              ELSE                                                      
      ****       UPDATE MN WITH 'AWAITING READING'                              
                 MOVE 'D'                  TO MN-CODE-CRNT-REG-READ     
                 MOVE SPACES               TO MN-CODE-NO-RD-REASON      
                 PERFORM 8520-UPDATE-MTRD-ENVRNMT  THRU 8520-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1610-GET-SEASN-BILL-PERIOD.                                      
      *================================================================*        
      *                                                                         
           EVALUATE TRUE                                                
             WHEN MN-LAST-REG-READ-DATE < WS-SEASN1-END-DATE            
                AND RW-OPTIMUM-READ-DATE > WS-SEASN1-END-DATE           
                MOVE MN-LAST-REG-READ-DATE TO WS-LAST-READ-DATE1        
                MOVE WS-SEASN1-END-DATE    TO WS-SCHEDULED-READ-DATE1   
                                              WS-WINDOW-END-DATE1       
                                              WS-LAST-READ-DATE         
             WHEN MN-LAST-REG-READ-DATE < WS-SEASN2-END-DATE            
                AND RW-OPTIMUM-READ-DATE > WS-SEASN2-END-DATE           
                MOVE MN-LAST-REG-READ-DATE TO WS-LAST-READ-DATE1        
                MOVE WS-SEASN2-END-DATE    TO WS-SCHEDULED-READ-DATE1   
                                              WS-WINDOW-END-DATE1       
                                              WS-LAST-READ-DATE         
             WHEN OTHER                                                 
                CONTINUE                                                
           END-EVALUATE.                                                
      *                                                                         
       1610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1650-SEND-READ-REQU.                                             
      *================================================================*        
      *                                                                         
      *** Regular Read Request                                                  
           IF WS-LAST-READ-DATE < WS-SCHEDULED-READ-DATE                
              PERFORM 7300-GET-NO-DAYS     THRU 7300-EXIT               
      ***  INCASE OF INACTIVE/TURNED OFF METERS, PROGRAM ALREADY                
      ***  ADJUSTED LAST READ DATE SO THAT WE ALWAYS HAVE < 55 DAYS             
A#5347        MOVE 'OnCycle'               TO WS-REQUEST-TYPE           
A#5347        MOVE WS-SCHEDULED-READ-DATE  TO WS-WAIT-UNTIL-DATE        
              IF WS-NO-READ-DAYS < 60                                   
                 PERFORM 2800-FORMAT-FIOBW61  THRU 2800-EXIT            
              ELSE                                                      
                 MOVE MN-METER-NO            TO WS-WQ-METER-NO          
                 MOVE WS-LAST-READ-DATE      TO WS-WQ-LAST-RD-DT        
                 MOVE WS-SCHEDULED-READ-DATE TO WS-WQ-CURR-RD-DT        
                 MOVE WS-CATEGORY-ID-141     TO WS-HOLD-WQ-CATEGORY     
                 MOVE '4'                    TO WS-ROUTING-CATEGORY     
                 MOVE WS-WQ-MSG-SIXTY-DAYS   TO WS-WQ-MESSAGE           
                 PERFORM 2300-POPULATE-WQ    THRU 2300-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *** Seasonal Read Request                                                 
           IF WS-LAST-READ-DATE1 > SPACES                               
             AND WS-LAST-READ-DATE1 < WS-SCHEDULED-READ-DATE1           
              MOVE WS-LAST-READ-DATE1      TO WS-LAST-READ-DATE         
A#5347        MOVE 'Other'                 TO WS-REQUEST-TYPE           
A#5347        MOVE WS-SCHEDULED-READ-DATE  TO WS-WAIT-UNTIL-DATE        
A#5347        MOVE WS-SCHEDULED-READ-DATE1 TO WS-SCHEDULED-READ-DATE    
A#5347*       MOVE WS-WINDOW-END-DATE1     TO WS-WINDOW-END-DATE                
              PERFORM 7300-GET-NO-DAYS     THRU 7300-EXIT               
      ***  INCASE OF INACTIVE/TURNED OFF METERS, PROGRAM ALREADY                
      ***  ADJUSTED LAST READ DATE SO THAT WE ALWAYS HAVE < 55 DAYS             
              IF WS-NO-READ-DAYS < 60                                   
                 PERFORM 2800-FORMAT-FIOBW61  THRU 2800-EXIT            
              ELSE                                                      
                 MOVE MN-METER-NO            TO WS-WQ-METER-NO          
                 MOVE WS-LAST-READ-DATE      TO WS-WQ-LAST-RD-DT        
                 MOVE WS-SCHEDULED-READ-DATE TO WS-WQ-CURR-RD-DT        
                 MOVE WS-CATEGORY-ID-141     TO WS-HOLD-WQ-CATEGORY     
                 MOVE '4'                    TO WS-ROUTING-CATEGORY     
                 MOVE WS-WQ-MSG-SIXTY-DAYS   TO WS-WQ-MESSAGE           
                 PERFORM 2300-POPULATE-WQ    THRU 2300-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2000-GET-SO-ACCT-CHNG.                                           
      *================================================================*        
      *                                                                         
           DISPLAY ' '                                                  
           DISPLAY '    PROCESSING ACCOUNT CHANGES - MOVE IN/MOVE OUT ' 
           DISPLAY ' '                                                  
                                                                        
           SET ACCT-CHNG-REQU TO TRUE                                   
           PERFORM 7710-OPEN-ACCT-CHG-CSR  THRU 7710-EXIT               
           PERFORM 7720-FETCH-ACCT-CHG-CSR THRU 7720-EXIT               
                                                                        
           PERFORM 2100-PROCESS-ACCT-CHGS  THRU 2100-EXIT               
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                                                                        
           SET ACCT-CHNG-SENT TO TRUE                                   
           PERFORM 7730-CLOSE-ACCT-CHG-CSR THRU 7730-EXIT.              
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2100-PROCESS-ACCT-CHGS.                                          
      *================================================================*        
           MOVE 1E-SERVICE-POINT-ID     TO 1D-SERVICE-POINT-ID          
                                           WS-SERVICE-POINT-ID          
           MOVE SPACES                  TO 1D-MTR-READ-SOURCE-CD        
                                                                        
           PERFORM 7765-GET-INTF-DETAILS   THRU 7765-EXIT               
                                                                        
           MOVE 1E-PREV-COLUMN-VALUE (1:13)  TO WS-ACCOUNT-NO-NUM       
           MOVE WS-ACCOUNT-NO-NUM       TO 1D-ACCOUNT-NO                
           MOVE 1D-ACCOUNT-NO           TO MN-ACCOUNT-NO                
                                           AT-ACCOUNT-NO                
           MOVE 1D-BILL-CYCLE           TO AT-BILL-CYCLE                
           MOVE WS-COMPANY-NO-SP        TO WS-COMPANY-NO                
           MOVE WS-CODE-UTIL-TYPE-SP    TO MN-CODE-UTIL-TYPE            
                                           WS-CODE-UTIL-TYPE            
           MOVE WS-IC-NO                TO MN-IC-NO                     
           MOVE WS-MTR-REF-NO           TO MN-MTR-REF-NO                
                                                                        
           MOVE ZERO                    TO WS-NULL-IND                  
           MOVE 1D-METER-NO             TO MN-METER-NO                  
                                           WS-METER-NO                  
                                                                        
           MOVE 'N'                     TO WS-DEMAND-FL                 
           IF 1D-MTR-READ-SOURCE-CD = 'P'                               
              PERFORM 7275-CHECK-OLD-DEMANDS  THRU 7275-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-DEMAND-FL = 'Y'                                        
A#5347        MOVE 'FinalBill'             TO WS-REQUEST-TYPE           
              PERFORM 2600-PROCESS-LAST-READS THRU 2600-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 7720-FETCH-ACCT-CHG-CSR THRU 7720-EXIT.              
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2300-POPULATE-WQ.                                                
      *================================================================*        
      *                                                                         
           INITIALIZE CWS00077-FIELDS.                                  
      *                                                                         
           INITIALIZE WS-77-COMMENTS.                                   
      *                                                                         
           MOVE UT-RATE-PLAN-NO              TO RD-RATE-PLAN-NO         
           PERFORM 7260-GET-SECU-RATE-FL     THRU 7260-EXIT             
           IF WS-HOLD-WQ-CATEGORY = 141                                 
              AND RD-SECURED-RATE-FL = 'Y'                              
              MOVE WS-CATEGORY-ID-142        TO WS-HOLD-WQ-CATEGORY     
           END-IF                                                       
           MOVE WS-INPUT-DATE                TO WS-77-DATE-REQUIRED.    
           MOVE ZERO                         TO WS-77-SERV-ORDER-NO.    
           MOVE WS-HOLD-WQ-CATEGORY          TO WS-77-CATEGORY-ID.      
           MOVE AT-ACCOUNT-NO                TO WS-77-ACCOUNT-NO.       
           MOVE AT-CUSTOMER-NO               TO WS-77-CUSTOMER-NO.      
           MOVE AT-LOCAL-OFFICE              TO WS-77-LOCAL-OFFICE.     
           MOVE AT-PREMISE-NO                TO WS-77-PREMISE-NO.       
                                                                        
           MOVE 'SYSTEM'                     TO WS-77-USER-ID-ORIG.     
           MOVE WS-ROUTING-CATEGORY          TO WS-77-ROUTE-CATEGORY.   
           MOVE WS-NORMAL-PRIORITY           TO WS-77-PRIORITY.         
           MOVE SPACES                       TO WS-77-RESP-AREA-ID.     
                                                                        
           MOVE WS-WQ-MESSAGE                TO WS-77-COMMENTS-TEXT.    
           MOVE LENGTH OF WS-77-COMMENTS-TEXT TO WS-77-COMMENTS-LEN.    
           MOVE SPACES                       TO WS-77-FREE-FORM-TXT.    
           MOVE ZERO                         TO WS-77-FREE-FORM-LEN.    
           MOVE PROGRAM-NAME                 TO WS-77-CREATED-BY.       
           PERFORM 8895-INSERT-WORK-QUEUE    THRU 8895-EXIT.            
           MOVE ZEROES                        TO WS-77-COMMENTS-LEN.    
           MOVE SPACES                        TO WS-77-COMMENTS-TEXT    
                                                 WS-WQ-MESSAGE          
           MOVE ZEROES                        TO WS-HOLD-WQ-CATEGORY.   
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2400-GET-SO-METR-CHNG.                                           
      *================================================================*        
      *                                                                         
           DISPLAY ' '                                                  
           DISPLAY '    PROCESSING METER CHANGES > ' WS-TIME-STAMP-PARM 
           DISPLAY ' '                                                  
                                                                        
           SET METR-CHNG-REQU TO TRUE                                   
           PERFORM 7740-OPEN-METR-CHG-CSR  THRU 7740-EXIT               
           PERFORM 7750-FETCH-METR-CHG-CSR THRU 7750-EXIT               
                                                                        
           PERFORM 2500-PROCESS-METR-CHGS  THRU 2500-EXIT               
             UNTIL NO-MORE-SERVICE-POINTS                               
                                                                        
           SET METR-CHNG-SENT TO TRUE                                   
           PERFORM 7760-CLOSE-METR-CHG-CSR THRU 7760-EXIT.              
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2500-PROCESS-METR-CHGS.                                          
      *================================================================*        
      *                                                                         
           MOVE 1E-SERVICE-POINT-ID     TO 1D-SERVICE-POINT-ID          
                                           WS-SERVICE-POINT-ID          
           MOVE SPACES                  TO 1D-MTR-READ-SOURCE-CD        
                                                                        
           PERFORM 7770-GET-INTF-DETAILS   THRU 7770-EXIT               
                                                                        
           MOVE 1D-ACCOUNT-NO           TO MN-ACCOUNT-NO                
                                           AT-ACCOUNT-NO                
           MOVE 1D-BILL-CYCLE           TO AT-BILL-CYCLE                
           MOVE WS-COMPANY-NO-SP        TO WS-COMPANY-NO                
           MOVE WS-CODE-UTIL-TYPE-SP    TO MN-CODE-UTIL-TYPE            
                                           WS-CODE-UTIL-TYPE            
           MOVE WS-IC-NO                TO MN-IC-NO                     
           MOVE WS-MTR-REF-NO           TO MN-MTR-REF-NO                
                                                                        
           MOVE ZERO                    TO WS-NULL-IND                  
           MOVE 1E-PREV-COLUMN-VALUE    TO MN-METER-NO                  
                                           WS-METER-NO                  
                                                                        
           MOVE 'N'                     TO WS-DEMAND-FL                 
           IF 1D-MTR-READ-SOURCE-CD = 'P'                               
              PERFORM 7275-CHECK-OLD-DEMANDS  THRU 7275-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-DEMAND-FL = 'Y'                                        
A#5347        MOVE 'PartialBill'           TO WS-REQUEST-TYPE           
              PERFORM 2600-PROCESS-LAST-READS THRU 2600-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 7750-FETCH-METR-CHG-CSR THRU 7750-EXIT.              
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2600-PROCESS-LAST-READS.                                         
      *================================================================*        
      *                                                                         
           MOVE SPACES               TO WS-LAST-READ-DATE               
                                        CX-DATE-READ                    
           MOVE ZERO                 TO WS-NULL-IND-01                  
           PERFORM 7285-GET-LAST-RD-DATES THRU 7285-EXIT                
           IF CX-DATE-READ      > SPACES                                
              MOVE SPACES                TO PW-LAST-REG-READ-TM         
              PERFORM 7290-GET-LAST-RD-TIME THRU 7290-EXIT              
              IF PW-LAST-REG-READ-TM > SPACES                           
                 MOVE WS-LAST-READ-DATE    TO MN-LAST-REG-READ-DATE     
                 MOVE PW-LAST-REG-READ-TM  TO MN-LAST-REG-READ-TIME     
              ELSE                                                      
                 MOVE SPACES               TO MN-LAST-REG-READ-DATE     
                                              MN-LAST-REG-READ-TIME     
              END-IF                                                    
              MOVE CX-DATE-READ          TO WS-SCHEDULED-READ-DATE      
A#5347                                      WS-WAIT-UNTIL-DATE          
A#5347        MOVE SPACES                TO WS-WINDOW-END-DATE          
              PERFORM 2800-FORMAT-FIOBW61  THRU 2800-EXIT               
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2800-FORMAT-FIOBW61.                                             
      *================================================================*        
      *                                                                         
           INITIALIZE FIOBW61                                           
      *                                                                         
           MOVE AT-BILL-CYCLE           TO E-FBW61-CYCLE-ID             
           MOVE WS-METER-ID             TO E-FBW61-ENTITY-ID            
           MOVE WS-EXPORT-MODE          TO E-FBW61-EXPORT-MODE          
           MOVE WS-RATE-TYPE            TO E-FBW61-RATE-TYPE            
           MOVE WS-REGISTER-TYPE        TO E-FBW61-REGISTER-TYPE        
           MOVE WS-LAG-LEAD-VALUE       TO E-FBW61-PASS-THRU-DATA-3     
      *                                                                         
      *** Request Type                                                          
A#5347     MOVE WS-REQUEST-TYPE         TO E-FBW61-REQUEST-TYPE         
A#5347     MOVE WS-SERVICE-POINT-ID     TO E-FBW61-PASS-THRU-DATA-2     
                                                                        
      *** Bill Start Date                                                       
           IF WS-LAST-READ-DATE = MN-LAST-REG-READ-DATE                 
              MOVE MN-LAST-REG-READ-TIME   TO WS-LAST-RD-TIME           
              MOVE WS-LAST-RD-TIME-HH      TO WS-TIME-HH                
              MOVE WS-LAST-RD-TIME-MM      TO WS-TIME-MM                
           ELSE                                                         
              MOVE 0                       TO WS-TIME-HH                
                                              WS-TIME-MM                
           END-IF                                                       
           MOVE WS-LAST-READ-DATE       TO WS-DATE-CCYYMMDD             
           MOVE WS-DATE-BREAKDOWN-ISO   TO E-FBW61-BILL-START-DATE      
      *                                                                         
      *** Bill Stop Date                                                        
           MOVE 0                          TO WS-TIME-HH                
                                              WS-TIME-MM                
      *                                                                         
           MOVE WS-SCHEDULED-READ-DATE  TO WS-DATE-CCYYMMDD             
           MOVE WS-DATE-BREAKDOWN-ISO   TO E-FBW61-BILL-STOP-DATE       
      *                                                                         
      *** Deadline Date                                                         
           IF WS-CURR-DATE > WS-WINDOW-END-DATE                         
A#5347        MOVE WS-CURR-DATE-PLUS-2  TO WS-DATE-CCYYMMDD             
           ELSE                                                         
              MOVE WS-WINDOW-END-DATE   TO WS-DATE-CCYYMMDD             
           END-IF                                                       
           MOVE WS-DATE-BREAKDOWN-ISO   TO E-FBW61-DEADLINE-DATE        
      *                                                                         
      *** Wait Until Date                                                       
A#5347     IF WS-CURR-DATE > WS-WAIT-UNTIL-DATE                         
              MOVE WS-CURR-DATE         TO WS-DATE-CCYYMMDD             
           ELSE                                                         
A#5347        MOVE WS-WAIT-UNTIL-DATE     TO WS-DATE-CCYYMMDD           
           END-IF                                                       
           MOVE 10                      TO WS-TIME-HH                   
           MOVE 30                      TO WS-TIME-MM                   
           MOVE WS-DATE-BREAKDOWN-ISO   TO E-FBW61-WAITUNTIL-DATE       
      *                                                                         
           DISPLAY 'EXTRACTED METER-NO: ',  E-FBW61-ENTITY-ID           
                                                                        
           MOVE FIOBW61                 TO FIOBW61-RECORD               
           PERFORM 8000-WRITE-FIOBW61      THRU 8000-EXIT               
                                                                        
           SET READ-REQU-SENT TO TRUE                                   
           ADD 1                        TO WS-FIOBW61-COUNT.            
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
      *** 6990-FETCH-CUR-ACCOUNT                                     *          
      *==============================================================*          
      *** TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.          *          
           EXEC SQL                                                             
                INCLUDE CPDCA099                                                
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       6995-CPD99-ERROR-ROUTINE.                                        
      *================================================================*        
      *                                                                         
           MOVE ZEROES  TO  WS-CPD99-ACCOUNT-NO.                        
                                                                        
           MOVE WS-CPD99-RETURN-CODE  TO WS-DISPLAY-SQLCODE             
           DISPLAY '****************************************'           
           DISPLAY '** PCSBW161 PROCESSING ERROR          **'           
           DISPLAY '** ABEND IN PARAGRAPH ' ACTIVE-PARAGRAPH            
           DISPLAY '** PREMISE-NO = ' WS-CPD99-PREMISE-NO               
           DISPLAY '** SQLCODE    = ' WS-DISPLAY-SQLCODE                
           DISPLAY '****************************************'           
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7000-GET-EXTRACT-DATE.                                           
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT BUSINESS_DAY_DT                                   
                 INTO :1G-BUSINESS-DAY-DT                               
                 FROM CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)                   
                WHERE BUS_DAY_DT_SEQ  =                                 
                     (SELECT (BUS_DAY_DT_SEQ + :WS-BUMP-DAYS)           
                        FROM CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)            
                       WHERE BUSINESS_DAY_DT = IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ))          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BUSINESS_DAY_DT                                           
MFA-TR*          INTO :1G-BUSINESS-DAY-DT                                       
MFA-TR*          FROM CSS_BUSINESS_DAYS                                         
MFA-TR*         WHERE BUS_DAY_DT_SEQ  =                                         
MFA-TR*              (SELECT (BUS_DAY_DT_SEQ + :WS-BUMP-DAYS)                   
MFA-TR*                 FROM CSS_BUSINESS_DAYS                                  
MFA-TR*                WHERE BUSINESS_DAY_DT = :WS-INPUT-DATE)                  
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7000            **'        
              DISPLAY '** WS-INPUT-DATE = ' WS-INPUT-DATE               
              DISPLAY '** WS-BUMP-DAYS  = ' WS-BUMP-DAYS                
              DISPLAY '** SQLCODE       = ' WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7050-OPEN-CYL-OPEN-CSR.                                          
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
                OPEN CYL_OPEN_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7050            **'        
              DISPLAY '** DATE_EXTRACT  = ' WS-RUN-DATE                 
              DISPLAY '** SQLCODE       = ' WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7060-FETCH-CYL-OPEN-CSR.                                         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              FETCH CYL_OPEN_CSR                                        
               INTO :RW-READ-CYCLE                                      
                   ,:RW-REVENUE-MONTH                                   
                   ,:RW-OPTIMUM-READ-DATE                               
                   ,:BN-DATE-EXTRACT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7060            **'        
              DISPLAY '** DATE_EXTRACT  = ' WS-RUN-DATE                 
              DISPLAY '** SQLCODE       = ' WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7100-OPEN-MTR-CSR.                                               
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
                OPEN GET_MTR_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7100            **'        
              DISPLAY '** READ CYCLE         = ' UT-READ-CYCLE          
              DISPLAY '** CODE_UTIL_TYPE     = E'                       
              DISPLAY '** MTR_READ_SOURCE_CD = R'                       
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7110-FETCH-MTR-CSR.                                              
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_MTR_CSR                                         
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-PREMISE-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-COMPANY-NO                                      
                   ,:UT-READ-ROUTE                                      
                   ,:UT-RATE-PLAN-NO                                    
                   ,:MN-CODE-UTIL-TYPE                                  
                   ,:MN-IC-NO                                           
                   ,:MN-MTR-REF-NO                                      
                   ,:MN-METER-NO                                        
                   ,:MN-DATE-MTR-INSTALL                                
                   ,:MN-LAST-REG-READ-DATE :WS-NULL-IND                 
                   ,:MN-LAST-REG-READ-TIME :WS-NULL-IND1                
                   ,:MN-CODE-CRNT-REG-READ                              
                   ,:MN-CODE-NO-RD-REASON                               
                   ,:MN-CODE-METER-STATUS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND < 0                                        
                 MOVE MN-DATE-MTR-INSTALL TO MN-LAST-REG-READ-DATE      
                 MOVE '00:00:00'          TO MN-LAST-REG-READ-TIME      
              END-IF                                                    
              IF WS-NULL-IND1 < 0                                       
                 MOVE '00:00:00'          TO MN-LAST-REG-READ-TIME      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7110            **'        
              DISPLAY '** READ CYCLE         = ' UT-READ-CYCLE          
              DISPLAY '** CODE_UTIL_TYPE     = E'                       
              DISPLAY '** MTR_READ_SOURCE_CD = R'                       
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7120-CLOSE-MTR-CSR.                                              
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
                CLOSE GET_MTR_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7120            **'        
              DISPLAY '** READ CYCLE         = ' UT-READ-CYCLE          
              DISPLAY '** CODE_UTIL_TYPE     = E'                       
              DISPLAY '** MTR_READ_SOURCE_CD = P'                       
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7210-SELECT-RATE-VERSION.                                        
      *================================================================*        
      * SELECT RATE VERSION                                            *        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) VERSION_NO_CNTRL                                  
                 INTO :RT-VERSION-NO-CNTRL                              
                 FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)                    
                WHERE CODE_UTIL_TYPE     = :RT-CODE-UTIL-TYPE           
                  AND RATE_PLAN_NO       = :RT-RATE-PLAN-NO             
                  AND CODE_STATUS        = 'A'                          
                  AND FROM_EFFECTIVE_DT <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )                 
                ORDER BY FROM_EFFECTIVE_DT DESC                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VERSION_NO_CNTRL                                          
MFA-TR*          INTO :RT-VERSION-NO-CNTRL                                      
MFA-TR*          FROM CSS_RATE_CREATOR                                          
MFA-TR*         WHERE CODE_UTIL_TYPE     = :RT-CODE-UTIL-TYPE                   
MFA-TR*           AND RATE_PLAN_NO       = :RT-RATE-PLAN-NO                     
MFA-TR*           AND CODE_STATUS        = 'A'                                  
MFA-TR*           AND FROM_EFFECTIVE_DT <= :WS-RUN-DATE                         
MFA-TR*         ORDER BY FROM_EFFECTIVE_DT DESC                                 
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7210                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7210            **'        
              DISPLAY '** ACCOUNT_NO     = ' AT-ACCOUNT-NO              
              DISPLAY '** RATE_PLAN_NO   = ' RT-RATE-PLAN-NO            
              DISPLAY '** CODE_UTIL_TYPE = ' RT-CODE-UTIL-TYPE          
              DISPLAY '** CODE_STATUS    =  A'                          
              DISPLAY '** FROM_EFFECTIVE_DT <= ' WS-RUN-DATE            
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7220-SELECT-SEASONS.                                             
      *================================================================*        
      * SELECT SEASON DETAILS                                          *        
      *                                                                         
           EXEC SQL                                                     
               SELECT DATE_FROM                                         
                     ,DATE_TO                                           
                     ,CODE_SEASON                                       
                 INTO :RS-DATE-FROM                                     
                     ,:RS-DATE-TO                                       
                     ,:RS-CODE-SEASON                                   
                 FROM CSS_RATE_USE_SEASN WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE   = :RS-CODE-UTIL-TYPE             
                  AND RATE_PLAN_NO     = :RS-RATE-PLAN-NO               
                  AND VERSION_NO_CNTRL = :RS-VERSION-NO-CNTRL           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_FROM                                                 
MFA-TR*              ,DATE_TO                                                   
MFA-TR*              ,CODE_SEASON                                               
MFA-TR*          INTO :RS-DATE-FROM                                             
MFA-TR*              ,:RS-DATE-TO                                               
MFA-TR*              ,:RS-CODE-SEASON                                           
MFA-TR*          FROM CSS_RATE_USE_SEASN                                        
MFA-TR*         WHERE CODE_UTIL_TYPE   = :RS-CODE-UTIL-TYPE                     
MFA-TR*           AND RATE_PLAN_NO     = :RS-RATE-PLAN-NO                       
MFA-TR*           AND VERSION_NO_CNTRL = :RS-VERSION-NO-CNTRL                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7220                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7220            **'        
              DISPLAY '** ACCOUNT_NO       = ' AT-ACCOUNT-NO            
              DISPLAY '** RATE_PLAN_NO     = ' RS-RATE-PLAN-NO          
              DISPLAY '** CODE_UTIL_TYPE   = ' RS-CODE-UTIL-TYPE        
              DISPLAY '** VERSION_NO_CNTRL = ' RS-VERSION-NO-CNTRL      
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7230-GET-SEASN-PRT-TYPE.                                         
      *================================================================*        
      * SELECT SEASONAL PRORATE TYPE                                   *        
      *                                                                         
           EXEC SQL                                                     
               SELECT SEAS_PRORATE_CD                                   
                 INTO :J4-SEAS-PRORATE-CD                               
                 FROM CSS_RATE_VRSN_DEF WITH(READUNCOMMITTED)                   
                WHERE CODE_UTIL_TYPE   = :J4-CODE-UTIL-TYPE             
                  AND RATE_PLAN_NO     = :J4-RATE-PLAN-NO               
                  AND VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SEAS_PRORATE_CD                                           
MFA-TR*          INTO :J4-SEAS-PRORATE-CD                                       
MFA-TR*          FROM CSS_RATE_VRSN_DEF                                         
MFA-TR*         WHERE CODE_UTIL_TYPE   = :J4-CODE-UTIL-TYPE                     
MFA-TR*           AND RATE_PLAN_NO     = :J4-RATE-PLAN-NO                       
MFA-TR*           AND VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7230                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7230            **'        
              DISPLAY '** ACCOUNT_NO       = ' AT-ACCOUNT-NO            
              DISPLAY '** RATE_PLAN_NO     = ' J4-RATE-PLAN-NO          
              DISPLAY '** CODE_UTIL_TYPE   = ' J4-CODE-UTIL-TYPE        
              DISPLAY '** VERSION_NO_CNTRL = ' J4-VERSION-NO-CNTRL      
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7240-ADD-ONE-DAY.                                                
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DB2-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DB2-DATE
              ) <> 0) OR (LEN(:WS-DB2-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-DB2-DATE
              ), CONVERT(DATE, :WS-DB2-DATE) ) )
            INTO
              :WS-DB2-DATE             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DB2-DATE = DATE(:WS-DB2-DATE) + 1 DAY                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7240            **'        
              DISPLAY '** ACCOUNT_NO     = ' AT-ACCOUNT-NO              
              DISPLAY '** ADD 1 DAY TO ==> ' WS-DB2-DATE                
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7250-GET-CURR-DATE.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              DATEADD( DAY, 2, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CURR-DATE,
              :WS-CURR-TMSTMP,
              :WS-CURR-DATE-PLUS-2         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURR-DATE        = CURRENT DATE                          
MFA-TR*           ,:WS-CURR-TMSTMP      = CURRENT TIMESTAMP                     
MFA-TR*           ,:WS-CURR-DATE-PLUS-2 = CURRENT DATE + 2 DAYS                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7250            **'        
              DISPLAY '** GET CURRENT DATE                   **'        
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7260-GET-SECU-RATE-FL.                                           
      *================================================================*        
      * CHECK IF RATE IS SECURE RATE                                            
      *----------------------------------------------------------------*        
      *                                                                         
           EXEC SQL                                                     
              SELECT RD.SECURED_RATE_FL                                 
                INTO :RD-SECURED-RATE-FL                                
                FROM CSS_RATE_PLAN_DESC RD                              
               WHERE RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO               
                 AND RD.CODE_UTIL_TYPE = 'E'                            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RD.SECURED_RATE_FL                                         
MFA-TR*         INTO :RD-SECURED-RATE-FL                                        
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO                       
MFA-TR*          AND RD.CODE_UTIL_TYPE = 'E'                                    
MFA-TR*        QUERYNO 7260                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7260            **'        
              DISPLAY '** ACCOUNT_NO     = ' AT-ACCOUNT-NO              
              DISPLAY '** RATE_PLAN_NO   = ' RD-RATE-PLAN-NO            
              DISPLAY '** CODE_UTIL_TYPE =  E                **'        
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7270-CHECK-DEMAND-FL.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-DEMAND-FL                                      
                FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
                    ,CSS_MTR_RD_FMT   MR WITH(READUNCOMMITTED)                  
               WHERE MN.ACCOUNT_NO         = :MN-ACCOUNT-NO             
                 AND MN.METER_NO           = :MN-METER-NO               
                 AND MN.DIGTL_MTR_TYPE     = MR.DIGTL_MTR_TYPE          
                 AND MN.PROGRAM_ID         = MR.PROGRAM_ID              
                 AND MN.MTR_READ_SOURCE_CD = MR.MTR_READ_SOURCE_CD      
                 AND MN.CODE_UTIL_TYPE     = MR.CODE_UTIL_TYPE          
                 AND MN.CODE_UTIL_TYPE     = 'E'                        
                 AND MN.MTR_READ_SOURCE_CD = 'P'                        
                 AND MR.INDEX_VALUE_CD     = 'V'                        
                 AND MR.CNSMPTN_READ_FL    = 'Y'                        
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-DEMAND-FL                                              
MFA-TR*         FROM CSS_MTRD_ENVRNMT MN                                        
MFA-TR*             ,CSS_MTR_RD_FMT   MR                                        
MFA-TR*        WHERE MN.ACCOUNT_NO         = :MN-ACCOUNT-NO                     
MFA-TR*          AND MN.METER_NO           = :MN-METER-NO                       
MFA-TR*          AND MN.DIGTL_MTR_TYPE     = MR.DIGTL_MTR_TYPE                  
MFA-TR*          AND MN.PROGRAM_ID         = MR.PROGRAM_ID                      
MFA-TR*          AND MN.MTR_READ_SOURCE_CD = MR.MTR_READ_SOURCE_CD              
MFA-TR*          AND MN.CODE_UTIL_TYPE     = MR.CODE_UTIL_TYPE                  
MFA-TR*          AND MN.CODE_UTIL_TYPE     = 'E'                                
MFA-TR*          AND MN.MTR_READ_SOURCE_CD = 'P'                                
MFA-TR*          AND MR.INDEX_VALUE_CD     = 'V'                                
MFA-TR*          AND MR.CNSMPTN_READ_FL    = 'Y'                                
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7270                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7270            **'        
              DISPLAY '** ACCOUNT_NO     = ' MN-ACCOUNT-NO              
              DISPLAY '** METER_NO       = ' MN-METER-NO                
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7275-CHECK-OLD-DEMANDS.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-DEMAND-FL                                      
                FROM CSS_MTR_RD_FMT WITH(READUNCOMMITTED)                       
               WHERE DIGTL_MTR_TYPE     = :1D-DIGTL-MTR-TYPE            
                 AND PROGRAM_ID         = :1D-PROGRAM-ID                
                 AND MTR_READ_SOURCE_CD = 'P'                           
                 AND CODE_UTIL_TYPE     = 'E'                           
                 AND INDEX_VALUE_CD     = 'V'                           
                 AND CNSMPTN_READ_FL    = 'Y'                           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-DEMAND-FL                                              
MFA-TR*         FROM CSS_MTR_RD_FMT                                             
MFA-TR*        WHERE DIGTL_MTR_TYPE     = :1D-DIGTL-MTR-TYPE                    
MFA-TR*          AND PROGRAM_ID         = :1D-PROGRAM-ID                        
MFA-TR*          AND MTR_READ_SOURCE_CD = 'P'                                   
MFA-TR*          AND CODE_UTIL_TYPE     = 'E'                                   
MFA-TR*          AND INDEX_VALUE_CD     = 'V'                                   
MFA-TR*          AND CNSMPTN_READ_FL    = 'Y'                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7275                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7275            **'        
              DISPLAY '** ACCOUNT_NO     = ' MN-ACCOUNT-NO              
              DISPLAY '** METER_NO       = ' MN-METER-NO                
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7285-GET-LAST-RD-DATES.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) CX.DATE_READ,
              DATEADD( DAY, -NO_DAYS, CX.DATE_READ )                  
                INTO :CX-DATE-READ :WS-NULL-IND-01                       
                    ,:WS-LAST-READ-DATE :WS-NULL-IND-02                  
                FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                  
               WHERE CX.ACCOUNT_NO     = :MN-ACCOUNT-NO                 
                 AND CX.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE             
                 AND CX.IC_NO          = :MN-IC-NO                      
                 AND CX.METER_NO       = :MN-METER-NO                   
                 AND CX.CODE_USAGE_TYPE = 'B'                           
                 AND CX.CODE_TIME_PERIOD = 0                            
              ORDER BY CX.DATE_READ DESC                                
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CX.DATE_READ                                               
MFA-TR*             ,DATE(CX.DATE_READ) - NO_DAYS DAYS                          
MFA-TR*         INTO :CX-DATE-READ:WS-NULL-IND-01                               
MFA-TR*             ,:WS-LAST-READ-DATE:WS-NULL-IND-02                          
MFA-TR*         FROM CSS_CNSMPTN_HIST CX                                        
MFA-TR*        WHERE CX.ACCOUNT_NO     = :MN-ACCOUNT-NO                         
MFA-TR*          AND CX.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                     
MFA-TR*          AND CX.IC_NO          = :MN-IC-NO                              
MFA-TR*          AND CX.METER_NO       = :MN-METER-NO                           
MFA-TR*          AND CX.CODE_USAGE_TYPE = 'B'                                   
MFA-TR*          AND CX.CODE_TIME_PERIOD = 0                                    
MFA-TR*       ORDER BY CX.DATE_READ DESC                                        
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*        QUERYNO 7280                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-01 < 0                                     
                 MOVE SPACES              TO WS-LAST-READ-DATE          
                                             CX-DATE-READ               
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7285            **'        
              DISPLAY '** ACCOUNT_NO     = ' MN-ACCOUNT-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' MN-CODE-UTIL-TYPE          
              DISPLAY '** IC_NO          = ' MN-IC-NO                   
              DISPLAY '** METER_NO       = ' MN-METER-NO                
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7285-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7290-GET-LAST-RD-TIME.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TM
           , 108), ':', '.') LAST_REG_READ_TM                                  
                INTO :PW-LAST-REG-READ-TM :WS-NULL-IND-01                
                FROM CSS_ROUTE_REPORT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
                 AND IC_NO          = :MN-IC-NO                         
                 AND METER_NO       = :MN-METER-NO                      
                 AND LAST_REG_READ_DT = IIF(TRY_CONVERT(DATE, 
                                                     :WS-LAST-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-READ-DATE
              ) <> 0) OR (LEN(:WS-LAST-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-READ-DATE
              ), CONVERT(DATE, :WS-LAST-READ-DATE) )              
                 AND CODE_USAGE_TYPE = 'B'                              
                 AND CODE_TIME_PERIOD = 0                               
              ORDER BY LAST_REG_READ_TM                                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LAST_REG_READ_TM                                           
MFA-TR*         INTO :PW-LAST-REG-READ-TM:WS-NULL-IND-01                        
MFA-TR*         FROM CSS_ROUTE_REPORT                                           
MFA-TR*        WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO          = :MN-IC-NO                                 
MFA-TR*          AND METER_NO       = :MN-METER-NO                              
MFA-TR*          AND LAST_REG_READ_DT = :WS-LAST-READ-DATE                      
MFA-TR*          AND CODE_USAGE_TYPE = 'B'                                      
MFA-TR*          AND CODE_TIME_PERIOD = 0                                       
MFA-TR*       ORDER BY LAST_REG_READ_TM                                         
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*        QUERYNO 7290                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7290            **'        
              DISPLAY '** ACCOUNT_NO     = ' MN-ACCOUNT-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' MN-CODE-UTIL-TYPE          
              DISPLAY '** IC_NO          = ' MN-IC-NO                   
              DISPLAY '** METER_NO       = ' MN-METER-NO                
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7300-GET-NO-DAYS.                                                
      *================================================================*        
      *** TO GET #OF DAYS BETWEEN TWO DATES.                                    
           EXEC SQL                                                     
              SELECT
              CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-SCHEDULED-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-SCHEDULED-READ-DATE
              ) <> 0) OR (LEN(:WS-SCHEDULED-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-SCHEDULED-READ-DATE
              ), CONVERT(DATE, :WS-SCHEDULED-READ-DATE) ) )                    
                          - CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                     :WS-LAST-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-READ-DATE
              ) <> 0) OR (LEN(:WS-LAST-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-READ-DATE
              ), CONVERT(DATE, :WS-LAST-READ-DATE) ) )
            INTO
              :WS-NO-READ-DAYS                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-NO-READ-DAYS =                                            
MFA-TR*            DAYS(:WS-SCHEDULED-READ-DATE)                                
MFA-TR*                   - DAYS(:WS-LAST-READ-DATE)                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7300            **'        
              DISPLAY '** GET DAYS B/W TWO DATES             **'        
              DISPLAY '** ACCOUNT_NO        = ' AT-ACCOUNT-NO           
              DISPLAY '** CURRENT READ DATE = ' WS-SCHEDULED-READ-DATE  
              DISPLAY '** LAST READ DATE    = ' WS-LAST-READ-DATE       
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7400-SET-LAST-READ-DATE.                                         
      *================================================================*        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -55, IIF(TRY_CONVERT(DATE, 
                                                :WS-SCHEDULED-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-SCHEDULED-READ-DATE
              ) <> 0) OR (LEN(:WS-SCHEDULED-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-SCHEDULED-READ-DATE
              ), CONVERT(DATE, :WS-SCHEDULED-READ-DATE) ) )
            INTO
              :WS-LAST-READ-DATE             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-LAST-READ-DATE =                                          
MFA-TR*           (DATE(:WS-SCHEDULED-READ-DATE) - 55 DAYS)                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7400            **'        
              DISPLAY '** SET LAST READ DATE                 **'        
              DISPLAY '** ACCOUNT_NO        = ' AT-ACCOUNT-NO           
              DISPLAY '** CURRENT READ DATE = ' WS-SCHEDULED-READ-DATE  
              DISPLAY '** LAST READ DATE    = ' WS-LAST-READ-DATE       
              DISPLAY '** METER NO          = ' WS-METER-NO             
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7500-SET-WINDOW-END-DATE.                                        
      *================================================================*        
           EXEC SQL                                                     
              SELECT MIN(BN.DATE_EXTRACT)                               
                INTO :WS-BN-DATE-EXTRACT                                
                FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
               WHERE BN.DATE_EXTRACT  > IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                
                 AND BN.REVENUE_MONTH = :RW-REVENUE-MONTH               
                 AND BN.BILL_CYCLE    = :RW-READ-CYCLE                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(BN.DATE_EXTRACT)                                       
MFA-TR*         INTO :WS-BN-DATE-EXTRACT                                        
MFA-TR*         FROM CSS_BILL_WINDOW BN                                         
MFA-TR*        WHERE BN.DATE_EXTRACT  > :BN-DATE-EXTRACT                        
MFA-TR*          AND BN.REVENUE_MONTH = :RW-REVENUE-MONTH                       
MFA-TR*          AND BN.BILL_CYCLE    = :RW-READ-CYCLE                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7500            **'        
              DISPLAY '** BUMP UP BN-DATE-EXTRACT            **'        
              DISPLAY '** DATE_EXTRACT  = ' BN-DATE-EXTRACT             
              DISPLAY '** REVENUE_MONTH = ' RW-REVENUE-MONTH            
              DISPLAY '** BILL_CYCLE    = ' RW-READ-CYCLE               
              DISPLAY '** SQLCODE       = ' WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * READ PARM FILE FOR OVERRIDE DATE      *                                 
           COPY CPD00037.                                                       
      /                                                                         
      * GET FCA00 COMMON DATE                 *                                 
           COPY CPD00040.                                                       
      *                                                                         
      ******************************************************************        
      * COPYBOOK TO GET THE NEXT BUSINESS DAY                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00315                                                 
           END-EXEC.                                                            
      *                                                                         
      * 7600-START-FCSJC01                    *                                 
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      * 7620-START-FCSCA00 VSAM CTRL FILE     *                                 
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *===============================================================*         
       7710-OPEN-ACCT-CHG-CSR.                                          
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
                OPEN GET_ACCTCHG_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7710            **'        
              DISPLAY '** LAST_UPDATE_TS   = ' WS-TIME-STAMP-PARM       
              DISPLAY '** MTR_READ_SOURCE_CD = P'                       
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7720-FETCH-ACCT-CHG-CSR.                                         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_ACCTCHG_CSR                                     
               INTO :1E-SERVICE-POINT-ID                                
                   ,:1E-COLUMN-NA                                       
                   ,:1E-LAST-UPDATE-TS                                  
                   ,:1E-PREV-COLUMN-VALUE                               
                   ,:1E-CURR-COLUMN-VALUE                               
                   ,:1E-LAST-UPDATE-PGM-ID                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7720            **'        
              DISPLAY '** LAST_UPDATE_TS   = ' WS-TIME-STAMP-PARM       
              DISPLAY '** MTR_READ_SOURCE_CD = P'                       
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7730-CLOSE-ACCT-CHG-CSR.                                         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
                CLOSE GET_ACCTCHG_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7730            **'        
              DISPLAY '** CODE_CRNT_REG_READ = G'                       
              DISPLAY '** CODE_UTIL_TYPE     = E'                       
              DISPLAY '** MTR_READ_SOURCE_CD = P'                       
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7740-OPEN-METR-CHG-CSR.                                          
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
                OPEN GET_METRCHG_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7740            **'        
              DISPLAY '** LAST_UPDATE_TS   = ' WS-TIME-STAMP-PARM       
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7740-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7750-FETCH-METR-CHG-CSR.                                         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_METRCHG_CSR                                     
               INTO :1E-SERVICE-POINT-ID                                
                   ,:1E-COLUMN-NA                                       
                   ,:1E-LAST-UPDATE-TS                                  
                   ,:1E-PREV-COLUMN-VALUE                               
                   ,:1E-CURR-COLUMN-VALUE                               
                   ,:1E-LAST-UPDATE-PGM-ID                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 SET NO-MORE-SERVICE-POINTS   TO TRUE                   
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE       
                 DISPLAY '****************************************'     
                 DISPLAY '** PCSBW161 PROCESSING ERROR          **'     
                 DISPLAY '** ABEND IN PARAGRAPH 7750            **'     
                 DISPLAY '** LAST_UPDATE_TS   = ' WS-TIME-STAMP-PARM    
                 DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE             
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7760-CLOSE-METR-CHG-CSR.                                         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
                CLOSE GET_METRCHG_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 7760            **'        
              DISPLAY '** LAST_UPDATE_TS   = ' WS-TIME-STAMP-PARM       
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7765-GET-INTF-DETAILS.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             SELECT CIS.SUBSTR3(COALESCE(MD2.PREV_COLUMN_VALUE               
                                  ,[1D].METER_NO ),1, 9)                  
                   ,[1D].BILL_CYCLE                                       
                   ,COALESCE(MD1.PREV_COLUMN_VALUE                      
                                ,[1D].MTR_READ_SOURCE_CD)                 
                   ,COALESCE(MD3.PREV_COLUMN_VALUE                      
                                ,[1D].DIGTL_MTR_TYPE)                     
                   ,COALESCE(MD4.PREV_COLUMN_VALUE                      
                                ,[1D].PROGRAM_ID )                        
              INTO :1D-METER-NO                                         
                  ,:1D-BILL-CYCLE                                       
                  ,:1D-MTR-READ-SOURCE-CD                               
                  ,:1D-DIGTL-MTR-TYPE                                   
                  ,:1D-PROGRAM-ID                                       
              FROM CSS_MDM_SS_INTF [1D] WITH(READUNCOMMITTED)                   
                   LEFT JOIN CSS_MDM_SS_INTF_CH MD1
                           WITH(READUNCOMMITTED)                     
                   ON ([1D].SERVICE_POINT_ID = MD1.SERVICE_POINT_ID       
                       AND MD1.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )      
                       AND MD1.COLUMN_NA = 'MTR_READ_SOURCE_CD')        
                     LEFT JOIN CSS_MDM_SS_INTF_CH MD2
                           WITH(READUNCOMMITTED)                   
                   ON ([1D].SERVICE_POINT_ID = MD2.SERVICE_POINT_ID       
                       AND MD2.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )      
                       AND MD2.COLUMN_NA = 'METER_NO'    )              
                     LEFT JOIN CSS_MDM_SS_INTF_CH MD3
                           WITH(READUNCOMMITTED)                   
                   ON ([1D].SERVICE_POINT_ID = MD3.SERVICE_POINT_ID       
                       AND MD3.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )      
                       AND MD3.COLUMN_NA = 'DIGTL_MTR_TYPE')            
                     LEFT JOIN CSS_MDM_SS_INTF_CH MD4
                           WITH(READUNCOMMITTED)                   
                   ON ([1D].SERVICE_POINT_ID = MD4.SERVICE_POINT_ID       
                       AND MD4.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )      
                       AND MD4.COLUMN_NA = 'PROGRAM_ID')                
             WHERE [1D].SERVICE_POINT_ID = :1D-SERVICE-POINT-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SUBSTR(COALESCE(MD2.PREV_COLUMN_VALUE                       
MFA-TR*                           ,1D.METER_NO ),1, 9)                          
MFA-TR*            ,1D.BILL_CYCLE                                               
MFA-TR*            ,COALESCE(MD1.PREV_COLUMN_VALUE                              
MFA-TR*                         ,1D.MTR_READ_SOURCE_CD)                         
MFA-TR*            ,COALESCE(MD3.PREV_COLUMN_VALUE                              
MFA-TR*                         ,1D.DIGTL_MTR_TYPE)                             
MFA-TR*            ,COALESCE(MD4.PREV_COLUMN_VALUE                              
MFA-TR*                         ,1D.PROGRAM_ID )                                
MFA-TR*       INTO :1D-METER-NO                                                 
MFA-TR*           ,:1D-BILL-CYCLE                                               
MFA-TR*           ,:1D-MTR-READ-SOURCE-CD                                       
MFA-TR*           ,:1D-DIGTL-MTR-TYPE                                           
MFA-TR*           ,:1D-PROGRAM-ID                                               
MFA-TR*       FROM CSS_MDM_SS_INTF 1D                                           
MFA-TR*            LEFT JOIN CSS_MDM_SS_INTF_CH MD1                             
MFA-TR*            ON (1D.SERVICE_POINT_ID = MD1.SERVICE_POINT_ID               
MFA-TR*                AND MD1.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS              
MFA-TR*                AND MD1.COLUMN_NA = 'MTR_READ_SOURCE_CD')                
MFA-TR*              LEFT JOIN CSS_MDM_SS_INTF_CH MD2                           
MFA-TR*            ON (1D.SERVICE_POINT_ID = MD2.SERVICE_POINT_ID               
MFA-TR*                AND MD2.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS              
MFA-TR*                AND MD2.COLUMN_NA = 'METER_NO'    )                      
MFA-TR*              LEFT JOIN CSS_MDM_SS_INTF_CH MD3                           
MFA-TR*            ON (1D.SERVICE_POINT_ID = MD3.SERVICE_POINT_ID               
MFA-TR*                AND MD3.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS              
MFA-TR*                AND MD3.COLUMN_NA = 'DIGTL_MTR_TYPE')                    
MFA-TR*              LEFT JOIN CSS_MDM_SS_INTF_CH MD4                           
MFA-TR*            ON (1D.SERVICE_POINT_ID = MD4.SERVICE_POINT_ID               
MFA-TR*                AND MD4.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS              
MFA-TR*                AND MD4.COLUMN_NA = 'PROGRAM_ID')                        
MFA-TR*      WHERE 1D.SERVICE_POINT_ID = :1D-SERVICE-POINT-ID                   
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7765                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN  7765-GET-INTF-DETAILS          **'  
              DISPLAY '** SELECT ROW FROM CSS_MDM_SS_INTF          **'  
              DISPLAY '** SERVICE-POINT-ID = ' 1D-SERVICE-POINT-ID      
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7765-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7770-GET-INTF-DETAILS.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             SELECT CIS.DECIMAL2DECIMAL(COALESCE(MD2.PREV_COLUMN_VALUE          
                                  ,[1D].ACCOUNT_NO ))                     
                   ,[1D].BILL_CYCLE                                       
                   ,COALESCE(MD1.PREV_COLUMN_VALUE                      
                                ,[1D].MTR_READ_SOURCE_CD)                 
                   ,COALESCE(MD3.PREV_COLUMN_VALUE                      
                                ,[1D].DIGTL_MTR_TYPE)                     
                   ,COALESCE(MD4.PREV_COLUMN_VALUE                      
                                ,[1D].PROGRAM_ID )                        
              INTO :1D-ACCOUNT-NO                                       
                  ,:1D-BILL-CYCLE                                       
                  ,:1D-MTR-READ-SOURCE-CD                               
                  ,:1D-DIGTL-MTR-TYPE                                   
                  ,:1D-PROGRAM-ID                                       
              FROM CSS_MDM_SS_INTF [1D] WITH(READUNCOMMITTED)                   
                   LEFT JOIN CSS_MDM_SS_INTF_CH MD1
                           WITH(READUNCOMMITTED)                     
                   ON ([1D].SERVICE_POINT_ID = MD1.SERVICE_POINT_ID       
                       AND MD1.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )      
                       AND MD1.COLUMN_NA = 'MTR_READ_SOURCE_CD')        
                     LEFT JOIN CSS_MDM_SS_INTF_CH MD2
                           WITH(READUNCOMMITTED)                   
                   ON ([1D].SERVICE_POINT_ID = MD2.SERVICE_POINT_ID       
                       AND MD2.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )      
                       AND MD2.COLUMN_NA = 'ACCOUNT_NO'    )            
                     LEFT JOIN CSS_MDM_SS_INTF_CH MD3
                           WITH(READUNCOMMITTED)                   
                   ON ([1D].SERVICE_POINT_ID = MD3.SERVICE_POINT_ID       
                       AND MD3.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )      
                       AND MD3.COLUMN_NA = 'DIGTL_MTR_TYPE')            
                     LEFT JOIN CSS_MDM_SS_INTF_CH MD4
                           WITH(READUNCOMMITTED)                   
                   ON ([1D].SERVICE_POINT_ID = MD4.SERVICE_POINT_ID       
                       AND MD4.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :1E-LAST-UPDATE-TS
              )      
                       AND MD4.COLUMN_NA = 'PROGRAM_ID')                
             WHERE [1D].SERVICE_POINT_ID = :1D-SERVICE-POINT-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DECIMAL(COALESCE(MD2.PREV_COLUMN_VALUE                      
MFA-TR*                           ,1D.ACCOUNT_NO ))                             
MFA-TR*            ,1D.BILL_CYCLE                                               
MFA-TR*            ,COALESCE(MD1.PREV_COLUMN_VALUE                              
MFA-TR*                         ,1D.MTR_READ_SOURCE_CD)                         
MFA-TR*            ,COALESCE(MD3.PREV_COLUMN_VALUE                              
MFA-TR*                         ,1D.DIGTL_MTR_TYPE)                             
MFA-TR*            ,COALESCE(MD4.PREV_COLUMN_VALUE                              
MFA-TR*                         ,1D.PROGRAM_ID )                                
MFA-TR*       INTO :1D-ACCOUNT-NO                                               
MFA-TR*           ,:1D-BILL-CYCLE                                               
MFA-TR*           ,:1D-MTR-READ-SOURCE-CD                                       
MFA-TR*           ,:1D-DIGTL-MTR-TYPE                                           
MFA-TR*           ,:1D-PROGRAM-ID                                               
MFA-TR*       FROM CSS_MDM_SS_INTF 1D                                           
MFA-TR*            LEFT JOIN CSS_MDM_SS_INTF_CH MD1                             
MFA-TR*            ON (1D.SERVICE_POINT_ID = MD1.SERVICE_POINT_ID               
MFA-TR*                AND MD1.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS              
MFA-TR*                AND MD1.COLUMN_NA = 'MTR_READ_SOURCE_CD')                
MFA-TR*              LEFT JOIN CSS_MDM_SS_INTF_CH MD2                           
MFA-TR*            ON (1D.SERVICE_POINT_ID = MD2.SERVICE_POINT_ID               
MFA-TR*                AND MD2.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS              
MFA-TR*                AND MD2.COLUMN_NA = 'ACCOUNT_NO'    )                    
MFA-TR*              LEFT JOIN CSS_MDM_SS_INTF_CH MD3                           
MFA-TR*            ON (1D.SERVICE_POINT_ID = MD3.SERVICE_POINT_ID               
MFA-TR*                AND MD3.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS              
MFA-TR*                AND MD3.COLUMN_NA = 'DIGTL_MTR_TYPE')                    
MFA-TR*              LEFT JOIN CSS_MDM_SS_INTF_CH MD4                           
MFA-TR*            ON (1D.SERVICE_POINT_ID = MD4.SERVICE_POINT_ID               
MFA-TR*                AND MD4.LAST_UPDATE_TS = :1E-LAST-UPDATE-TS              
MFA-TR*                AND MD4.COLUMN_NA = 'PROGRAM_ID')                        
MFA-TR*      WHERE 1D.SERVICE_POINT_ID = :1D-SERVICE-POINT-ID                   
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7770                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN  7770-GET-INTF-DETAILS          **'  
              DISPLAY '** SELECT ROW FROM CSS_MDM_SS_INTF          **'  
              DISPLAY '** SERVICE-POINT-ID = ' 1D-SERVICE-POINT-ID      
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7770-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       8000-WRITE-FIOBW61.                                              
      *===============================================================*         
      *                                                                         
           WRITE FIOBW61-RECORD.                                        
      *                                                                         
           IF FBW61-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 8000            **'        
              DISPLAY '** ERROR ON FCSBW61 WRITE             **'        
              DISPLAY '** FILE STATUS = '  WS-FBW61-STATUS              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8300-INSERT-ROUTE-HDR.                                           
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_ROUTE_HEADER                            
                  (REVENUE_MONTH                                        
                  ,READ_ROUTE                                           
                  ,COMPANY_NO                                           
                  ,LOCAL_OFFICE                                         
                  ,READ_CYCLE                                           
                  ,DOWNLOAD_DATE                                        
                  ,PC_ROUTE_IND                                         
                  ,DOWNLOAD_METERS                                      
                  ,DOWN_RMVD_MTR_QT                                     
                  ,UPLOAD_METERS                                        
                  ,UP_RMVD_MTR_QT)                                      
               VALUES                                                   
                  (:RH-REVENUE-MONTH                                    
                  ,:RH-READ-ROUTE                                       
                  ,:RH-COMPANY-NO                                       
                  ,:RH-LOCAL-OFFICE                                     
                  ,:RH-READ-CYCLE                                       
                  ,IIF(TRY_CONVERT(DATE, :RH-DOWNLOAD-DATE
              ) IS NULL OR (PATINDEX('%.%', :RH-DOWNLOAD-DATE
              ) <> 0) OR (LEN(:RH-DOWNLOAD-DATE) <> 10), CIS.CHAR2DATE(
                                                      :RH-DOWNLOAD-DATE
              ), CONVERT(DATE, :RH-DOWNLOAD-DATE) )                            
                  , ' '                                                 
                  ,:RH-DOWNLOAD-METERS                                  
                  ,0                                                    
                  ,0                                                    
                  ,0)                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ROUTE_HEADER                                    
MFA-TR*           (REVENUE_MONTH                                                
MFA-TR*           ,READ_ROUTE                                                   
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,LOCAL_OFFICE                                                 
MFA-TR*           ,READ_CYCLE                                                   
MFA-TR*           ,DOWNLOAD_DATE                                                
MFA-TR*           ,PC_ROUTE_IND                                                 
MFA-TR*           ,DOWNLOAD_METERS                                              
MFA-TR*           ,DOWN_RMVD_MTR_QT                                             
MFA-TR*           ,UPLOAD_METERS                                                
MFA-TR*           ,UP_RMVD_MTR_QT)                                              
MFA-TR*        VALUES                                                           
MFA-TR*           (:RH-REVENUE-MONTH                                            
MFA-TR*           ,:RH-READ-ROUTE                                               
MFA-TR*           ,:RH-COMPANY-NO                                               
MFA-TR*           ,:RH-LOCAL-OFFICE                                             
MFA-TR*           ,:RH-READ-CYCLE                                               
MFA-TR*           ,:RH-DOWNLOAD-DATE                                            
MFA-TR*           , ' '                                                         
MFA-TR*           ,:RH-DOWNLOAD-METERS                                          
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,0)                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR ALREADY-EXISTS                                         
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 8300            **'        
              DISPLAY '** REVENUE_MONTH      = ' RH-REVENUE-MONTH       
              DISPLAY '** READ_ROUTE         = ' RH-READ-ROUTE          
              DISPLAY '** COMPANY_NO         = ' RH-COMPANY-NO          
              DISPLAY '** LOCAL_OFFICE       = ' RH-LOCAL-OFFICE        
              DISPLAY '** READ_CYCLE         = ' RH-READ-CYCLE          
              DISPLAY '** DOWNLOAD_METERS    = ' RH-DOWNLOAD-METERS     
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8400-UPDATE-ROUTE-HDR.                                           
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_ROUTE_HEADER                                 
                SET DOWNLOAD_METERS =                                   
                    DOWNLOAD_METERS + :RH-DOWNLOAD-METERS               
                WHERE REVENUE_MONTH   = :RH-REVENUE-MONTH               
                AND READ_ROUTE        = :RH-READ-ROUTE                  
                AND COMPANY_NO        = :RH-COMPANY-NO                  
                AND LOCAL_OFFICE      = :RH-LOCAL-OFFICE                
                AND READ_CYCLE        = :RH-READ-CYCLE                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 8400            **'        
              DISPLAY '** REVENUE_MONTH      = ' RH-REVENUE-MONTH       
              DISPLAY '** READ_ROUTE         = ' RH-READ-ROUTE          
              DISPLAY '** COMPANY_NO         = ' RH-COMPANY-NO          
              DISPLAY '** LOCAL_OFFICE       = ' RH-LOCAL-OFFICE        
              DISPLAY '** READ_CYCLE         = ' RH-READ-CYCLE          
              DISPLAY '** DOWNLOAD_METERS    = ' RH-DOWNLOAD-METERS     
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8520-UPDATE-MTRD-ENVRNMT.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_MTRD_ENVRNMT                                  
               SET CODE_NO_RD_REASON  = :MN-CODE-NO-RD-REASON           
                  ,CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ          
               WHERE ACCOUNT_NO       = :MN-ACCOUNT-NO                  
                 AND CODE_UTIL_TYPE   = :MN-CODE-UTIL-TYPE              
                 AND IC_NO            = :MN-IC-NO                       
                 AND MTR_REF_NO       = :MN-MTR-REF-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** ABEND IN PARAGRAPH 8400            **'        
              DISPLAY '** ACCOUNT_NO     = ' MN-ACCOUNT-NO              
              DISPLAY '** CODE_UTIL_TYPE = ' MN-CODE-UTIL-TYPE          
              DISPLAY '** IC_NO          = ' MN-IC-NO                   
              DISPLAY '** MTR_REF_NO     = ' MN-MTR-REF-NO              
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8530-UPDATE-ACCT-STAT.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
               SET CODE_ACCT_STAT   = 'G'                               
                  ,LAST_UPDATE_TS   = CIS.CURRENT$TIMESTAMP()                 
               WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*        SET CODE_ACCT_STAT   = 'G'                                       
MFA-TR*           ,LAST_UPDATE_TS   = CURRENT TIMESTAMP                         
MFA-TR*        WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '** PCSBW161 PROCESSING ERROR          **'        
              DISPLAY '** 8530-UPDATE-ACCT-STAT              **'        
              DISPLAY '** ACCOUNT_NO     = ' AT-ACCOUNT-NO              
              DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * COPY BOOK CONTAINING 8895-INSERT-WORK-QUEUE                             
      ******************************************************************        
      *                                                                         
       8895-INSERT-WORK-QUEUE.                                          
           MOVE SPACES TO ABEND-FUNCTION.                               
                                                                        
           CALL SCSCB077 USING CWS00077-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE                           
           MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
                                                                        
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              DISPLAY '8895-INSERT-WORK-QUEUE'                          
              DISPLAY 'CALL SCSCB077         '                          
              DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
              DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
              DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
              DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              PERFORM 9900-ABEND    THRU 9900-EXIT                      
           END-IF.                                                      
       8895-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8900-UPDATE-TIMESTMP.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                UPDATE  CSS_JOB_PARM                                    
                   SET  PARM_DATA    = :G6-PARM-DATA                    
                 WHERE PROGRAM_NAME  = :PROGRAM-NAME                    
                   AND COMPANY_NO    = '01'                             
                   AND CMND_CODE     = :WS-PARM                         
                   AND PARM_DATA LIKE 'LAST-UPD-TMST=%'                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              DISPLAY ' '                                               
              DISPLAY ' JOB PARM UPDATED TO ' WS-CURR-TMSTMP            
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW161 ERROR ******************'  
              DISPLAY '**     8900-UPDATE-TIMESTMP                 **'  
              DISPLAY '** JOB PARM UPDATE ERROR                    **'  
              DISPLAY '** PARM_DATA        = ' G6-PARM-DATA             
              DISPLAY '** PROGRAM_NAME     = ' PROGRAM-NAME             
              DISPLAY '** CMND_CODE        = ' WS-PARM                  
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       9000-TERMINATE.                                                  
      *===============================================================*         
      *                                                                         
           CLOSE FCSBW61-FILE.                                          
      *                                                                         
           DISPLAY ' '                                                  
           DISPLAY 'TOTAL RECORDS PROCESSED: ' WS-FIOBW61-COUNT         
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * 9900-ABEND INCLUDES SQL ROLLBACK *                                      
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
