       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW160.                                        
       INSTALLATION.                                                    
       DATE-WRITTEN.   OCT 2015.                                        
           DATE-COMPILED.                                               
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                 COBOL/DB2                      *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** =====      ========      ======                             **         
      ** 10/15/15   SS95855       PROJ#914 OPENWAY                   **         
A#5347** 05/17/16   SS95855       POPULATE CUSTOMER ESTABLISHED DATE **         
A#5347** 05/20/16   SS95855       INCLUDE MV90 METERS TO IEE         **         
A#5347**                          ADD NEW TRAN TYPE METER CONNECT    **         
A5347A** 07/20/16   SS95855       WHEN METERS CHANGE FROM OPENWAY TO **         
A5347A**                          NON-OPENWAY, REMOVE THEM FROM IEE. **         
A#5347** 08/23/16   SS95855       SEND 'RM' FOR INACTIVE OPENWAY MTRS**         
A#5347**                          7-DIGIT DEVICE-ID FOR OPENWAY MTRS **         
A#5347** 08/23/16   SS95855       FILTER MV90 METERS FOR IEE(ACT005) **         
A#5470** 11/10/16   SS95855       GET LAT/LONG FROM PREMISE(ACT054)  **         
A#5470** 01/10/17   SS95855       RE-ARRANGE FIELDS FOR 'AC' REC TYP **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSBW160 NARRATIVE                        
      *                                                                         
           THIS PROGRAM SYNC UP CIS MASTER DATA WITH MDMS SYSTEM BY     
           SELECTING EVERY DAY CIS CHANGES RECORDED IN THE INTERFACE    
           TABLES. THIS PROGRAM RUNS DAILY AND FETCHES CHANGES IN       
           CSS_MDM_SS_INTF_CH TABLE BASED ON LAST RUN TIMSSTAMP STORED  
           IN JOB_PARM TABLE. EACH CHANGE WILL BE EXAMINED AND CREATE   
           COMMA DELIMITED INTERFACE FILE,ONLY IF CHANGE REQUIRE TO BE  
           REFLECTED IN MDMS.                                           
                                                                        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSBW60.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDBW60.                                                            
A#5347 01  FIOBW60-REC                        PIC X(750).               
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW160'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR PCSBW160 STARTS HERE'.                  
      *                                                                         
      * BW60 LAYOUT           *                                                 
A#5347 01 FIOBW60                             PIC X(750).               
                                                                        
      * ABEND SWITCH          *                                                 
       COPY CWS09900.                                                           
                                                                        
      * WARNING DATA          *                                                 
       COPY CWS00303.                                                           
                                                                        
      * WS ABEND WORK AREA    *                                                 
       COPY CWS00010.                                                           
                                                                        
       COPY CWS00011.                                                           
      *                                                                         
      * ADDRESS COPYBOOK      *                                                 
       COPY CWS00074.                                                           
                                                                        
      * FCA00-KEY             *                                                 
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
                                                                        
      * IO AREA FOR PARM INPUT FILE 'A' *                                       
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                           DCLGEN'S                             *        
      ******************************************************************        
                                                                        
      * COMMUNICATION AREA                                                      
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      * CSS_ACCOUNT        (AT)                                                 
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      * CSS_MTRD_ENVRNMT   (MN)                                                 
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_CUST_PREM_HIST (CH)                                                 
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_EQUIPMENT      (EQ)                                                 
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_JOB_PARM       (G6)                                                 
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_METER_ATTCHMTS (MA)                                                 
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_MDM_SS_INTF     (1D)                                                 
           EXEC SQL                                                             
               INCLUDE TBMDMINT                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_MDM_SS_INTF_CH  (1E)                                                 
           EXEC SQL                                                             
               INCLUDE TBMDMCHG                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_ADDR_FORMATTED  (DY)                                                 
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_ADDR_FREEFORM   (DZ)                                                 
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_NAME            (DQ)                                                 
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      *CSS_NAME_ACCT_XREF  (HT)                                                 
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_CUST_ADDR_XREF  (DM)                                                 
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_ZIP_CODE        (A4)                                                 
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      *CSS_ACCT_MISC_INFO  (TA)                                                 
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_PREMISE         (PR)                                                 
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      *CSS_CODE_VALUE      (UV)                                                 
           EXEC SQL                                                             
               INCLUDE TBCDVALU                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_MNT_TRANS_HIST  (MH)                                                 
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_MT_TRN_HST_DET  (MI)                                                 
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_RATE_PLAN_DESC (RD)                                                 
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_LOCAL_OFFICE   (B1)                                                 
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
A#5347* CSS_CUSTOMER       (CU)                                                 
A#5347     EXEC SQL                                                             
A#5347        INCLUDE TBCUST                                                    
A#5347     END-EXEC.                                                            
       01 WS-LITERALS.                                                  
          05 WS-YES                          PIC X(01) VALUE 'Y'.       
          05 WS-Y                            PIC X(01) VALUE 'Y'.       
          05 WS-N                            PIC X(01) VALUE 'N'.       
          05 WS-U                            PIC X(01) VALUE 'U'.       
          05 WS-NO                           PIC X(01) VALUE 'N'.       
A#5347    05 WS-MV90                         PIC X(01) VALUE 'M'.       
          05 WS-LAST-UPD-TMST-PARM.                                     
             10 WS-LAST-UPD-TMST-TX          PIC X(14) VALUE            
                                                'LAST-UPD-TMST='.       
             10 WS-LAST-UPD-TMST-VALUE       PIC X(26).                 
          05 WS-PGRMNAME                     PIC X(08) VALUE            
                                                      'PCSBW160'.       
          05 PROGRAM-NAME                    PIC X(08) VALUE            
                                                      'PCSBW160'.       
A#5347    05 WS-MDMS-LOW-DATE                PIC X(10) VALUE            
A#5347                                                '1950-01-01'.     
          05 WS-FBW60-STATUS                 PIC X(02).                 
             88 FBW60-SUCCESSFUL                       VALUE '00'.      
      *                                                                         
          05 WS-TRANSACTION-TYPE             PIC X(02) VALUE '  '.      
             88 NEW-SERVICE                            VALUE 'NS'.      
             88 ACCOUNT-CHANGE                         VALUE 'AC'.      
             88 CUSTOMER-CHANGE                        VALUE 'CC'.      
             88 RATE-CHANGE                            VALUE 'RT'.      
             88 READ-CYCLE-CHANGE                      VALUE 'RC'.      
             88 LOCAL-OFFICE-CHANGE                    VALUE 'LO'.      
             88 METER-EXCHANGE-LIKE                    VALUE 'ML'.      
             88 METER-EXCHANGE-NON-LIKE                VALUE 'MN'.      
             88 METER-REPROGRAM                        VALUE 'MR'.      
             88 METER-SUPPLY-CHANGE                    VALUE 'MS'.      
             88 POINT-ID-CHANGE                        VALUE 'PO'.      
             88 REMOVE-METER                           VALUE 'RM'.      
             88 ADDRESS-CHANGE                         VALUE 'AD'.      
             88 NAME-CHANGE                            VALUE 'CN'.      
             88 ACCOUNT-STATUS                         VALUE 'AS'.      
             88 METER-STATUS                           VALUE 'MC'.      
A#5347       88 METER-CONNECT                          VALUE 'MI'.      
      *                                                                         
       01 WS-OLD-ACCT-AREA.                                             
          05 WS-OLD-ACCT-STATUS              PIC X(10) VALUE SPACES.    
          05 WS-OLD-ACC-STATUS-DT            PIC X(19) VALUE SPACES.    
          05 WS-OLD-CUSTOMER-NO              PIC 9(10) VALUE 0.         
          05 WS-OLD-CUST-NAME                PIC X(100) VALUE SPACES.   
      *                                                                         
       01 WS-TEMP-FLAG.                                                 
          05 WS-MASTER-DATA-CHANGE-SW        PIC X(01) VALUE 'N'.       
             88 MASTER-DATA-CHANGED                    VALUE 'Y'.       
             88 MASTER-DATA-NOT-CHANGED                VALUE 'N'.       
          05 WS-METER-TYPE-CHANGE-SW         PIC X(01) VALUE 'N'.       
             88 METER-TYPE-CHANGED                     VALUE 'Y'.       
             88 METER-TYPE-NOT-CHANGED                 VALUE 'N'.       
          05 WS-METER-CONST-CHANGE-SW        PIC X(01) VALUE 'N'.       
             88 METER-CONST-CHANGED                    VALUE 'Y'.       
             88 METER-CONST-NOT-CHANGED                VALUE 'N'.       
          05 WS-NEW-SERVICE-POINT-SW         PIC X(01) VALUE 'N'.       
             88 SERVICE-POINT-EXISTS                   VALUE 'N'.       
             88 NEW-SERVICE-POINT                      VALUE 'Y'.       
          05 WS-PROCESS-SP-SW                PIC X(01) VALUE 'Y'.       
             88 PROCESS-ALL-SPS                        VALUE 'Y'.       
             88 NO-MORE-SERVICE-POINTS                 VALUE 'N'.       
          05 WS-OLD-MRS-CD-SW                PIC X(01) VALUE SPACES.    
A#5347       88 OLD-MTR-VALID-MDMS                     VALUE 'P', 'M'.  
             88 OLD-MTR-NOT-VALID-MDMS                 VALUE            
                                                   'R', 'B', 'C', 'E',  
A#5347                                        'X', 'F', 'I', 'S', 'T'.  
             88 OLD-MTR-OPENWAY                        VALUE 'P'.       
             88 OLD-MTR-SMARTSYNCH                     VALUE 'R'.       
             88 OLD-MTR-ITRON-MOBILE-AMR               VALUE 'B'.       
             88 OLD-MTR-ITRON-CUSTOMER                 VALUE 'C'.       
             88 OLD-MTR-METRETEK                       VALUE 'E'.       
             88 OLD-MTR-MV90                           VALUE 'M'.       
             88 OLD-MTR-DO-NOT-READ                    VALUE 'X'.       
             88 OLD-MTR-MANUAL                         VALUE 'F'.       
             88 OLD-MTR-ITRON-MANUAL                   VALUE 'I'.       
             88 OLD-MTR-EFM                            VALUE 'S'.       
             88 OLD-MTR-TWACS                          VALUE 'T'.       
      *                                                                         
          05 WS-NEW-MRS-CD-SW                PIC X(01) VALUE SPACES.    
A#5347       88 NEW-MTR-VALID-MDMS                     VALUE 'P', 'M'.  
             88 NEW-MTR-NOT-VALID-MDMS                 VALUE            
                                                   'R', 'B', 'C', 'E',  
A#5347                                        'X', 'F', 'I', 'S', 'T'.  
             88 NEW-MTR-OPENWAY                        VALUE 'P'.       
             88 NEW-MTR-SMARTSYNCH                     VALUE 'R'.       
             88 NEW-MTR-ITRON-MOBILE-AMR               VALUE 'B'.       
             88 NEW-MTR-ITRON-CUSTOMER                 VALUE 'C'.       
             88 NEW-MTR-METRETEK                       VALUE 'E'.       
             88 NEW-MTR-MV90                           VALUE 'M'.       
             88 NEW-MTR-DO-NOT-READ                    VALUE 'X'.       
             88 NEW-MTR-MANUAL                         VALUE 'F'.       
             88 NEW-MTR-ITRON-MANUAL                   VALUE 'I'.       
             88 NEW-MTR-EFM                            VALUE 'S'.       
             88 NEW-MTR-TWACS                          VALUE 'T'.       
      *                                                                         
       01 WS-TEMP-WORK-AREA.                                            
          05 WS-OLD-ENDPOINT-ID              PIC X(34) VALUE SPACES.    
          05 WS-OLD-METER-TYPE-ID            PIC X(06) VALUE SPACES.    
          05 WS-OLD-CONSTANT-KWH             PIC X(10) VALUE SPACES.    
          05 WS-OLD-MTR-STATUS               PIC X(10) VALUE SPACES.    
          05 WS-OLD-AMI-VENDOR               PIC X(15) VALUE SPACES.    
          05 WS-OLD-REVENUE-CLASS            PIC X(50) VALUE SPACES.    
          05 WS-OLD-MTR-INS-DTTM             PIC X(19) VALUE SPACES.    
          05 WS-OLD-METER-ID                 PIC X(12) VALUE SPACES.    
          05 WS-OLD-RECORDER-ID              PIC X(20) VALUE SPACES.    
      *                                                                         
          05 WS-ADDR-CHG-SW                  PIC X(01) VALUE 'N'.       
             88 ADDRESS-CHANGED                        VALUE 'Y'.       
          05 WS-NAME-CHG-SW                  PIC X(01) VALUE 'N'.       
             88 NAME-CHANGED                           VALUE 'Y'.       
      *                                                                         
       01 WS-ENDPOINT-ID                     PIC X(24) VALUE SPACES.    
       01 WS-LZERO-CNT                       PIC 9(01) VALUE ZERO.      
       01 WS-EPM-COUNT                       PIC 9(01) VALUE ZERO.      
       01 WS-ENDPT-MTR-SRC                   PIC X(09) VALUE SPACES.    
       01 WS-ENDPT-MTR-TRGT                  PIC X(09) VALUE SPACES.    
      *                                                                         
       01 WS-RECORD-STRING.                                             
          05 S-RECORD-TYPE.                                             
             10 RS-RECORD-TYPE               PIC X(02).                 
             10 RS-DELIMITER1                PIC X(03).                 
          05 S-ACCOUNT-NO.                                              
             10 RS-ACCOUNT-NO                PIC 9(13).                 
             10 RS-DELIMITER2                PIC X(03).                 
          05 S-SERVICE-POINT-ID.                                        
             10 RS-SERVICE-POINT-ID          PIC X(21).                 
             10 RS-DELIMITER3                PIC X(03).                 
          05 S-PREMISE-NO.                                              
             10 RS-PREMISE-NO                PIC 9(10).                 
             10 RS-DELIMITER4                PIC X(03).                 
          05 S-CUSTOMER-NO.                                             
             10 RS-CUSTOMER-NO               PIC 9(10).                 
             10 RS-DELIMITER5                PIC X(03).                 
          05 S-ACCT-STATUS.                                             
             10 RS-ACCT-STATUS               PIC X(06).                 
             10 RS-DELIMITER6                PIC X(03).                 
          05 S-READ-CYCLE.                                              
             10 RS-READ-CYCLE                PIC X(02).                 
             10 RS-DELIMITER7                PIC X(03).                 
          05 S-LOC-OFFICE.                                              
             10 RS-LOC-OFFICE                PIC X(26).                 
             10 RS-DELIMITER8                PIC X(03).                 
          05 S-RATE-PLAN-NO.                                            
             10 RS-RATE-PLAN-NO              PIC X(55).                 
             10 RS-DELIMITER9                PIC X(03).                 
          05 S-CUST-NAME.                                               
             10 RS-CUST-NAME                 PIC X(100).                
             10 RS-DELIMITER10               PIC X(03).                 
A#5347    05 S-CUST-EST-DTTM.                                           
A#5347       10 RS-CUST-EST-DTTM             PIC X(19).                 
A#5347       10 RS-DELIMITER10A              PIC X(03).                 
          05 S-SVC-ADDR-1.                                              
             10 RS-SVC-ADDR-1                PIC X(55).                 
             10 RS-DELIMITER11               PIC X(03).                 
          05 S-SVC-ADDR-OVERFLOW.                                       
             10 RS-SVC-ADDR-OVERFLOW         PIC X(26).                 
             10 RS-DELIMITER12               PIC X(03).                 
          05 S-SVC-CITY.                                                
             10 RS-SVC-CITY                  PIC X(30).                 
             10 RS-DELIMITER13               PIC X(03).                 
          05 S-SVC-STATE.                                               
             10 RS-SVC-STATE                 PIC X(20).                 
             10 RS-DELIMITER14               PIC X(03).                 
          05 S-SVC-ZIP.                                                 
             10 RS-SVC-ZIP                   PIC X(10).                 
             10 RS-DELIMITER15               PIC X(03).                 
          05 S-ACCT-CHNG-DTTM.                                          
             10 RS-ACCT-CHNG-DTTM            PIC X(19).                 
             10 RS-DELIMITER16               PIC X(03).                 
          05 S-METER-ID.                                                
             10 RS-METER-ID                  PIC X(12).                 
             10 RS-DELIMITER17               PIC X(03).                 
          05 S-METER-NO.                                                
             10 RS-METER-NO                  PIC X(09).                 
             10 RS-DELIMITER18               PIC X(03).                 
          05 S-METER-TYPE-ID.                                           
             10 RS-METER-TYPE-ID             PIC X(06).                 
             10 RS-DELIMITER19               PIC X(03).                 
          05 S-AMI-VENDOR.                                              
             10 RS-AMI-VENDOR                PIC X(15).                 
             10 RS-DELIMITER20               PIC X(03).                 
          05 S-CONSTANT-KWH.                                            
             10 RS-CONSTANT-KWH              PIC X(10).                 
             10 RS-DELIMITER21               PIC X(03).                 
          05 S-METER-STATUS.                                            
             10 RS-METER-STATUS              PIC X(11).                 
             10 RS-DELIMITER22               PIC X(03).                 
          05 S-METER-SUPPLYING.                                         
             10 RS-METER-SUPPLYING           PIC X(15).                 
             10 RS-DELIMITER23               PIC X(03).                 
          05 S-POINT-ID.                                                
             10 RS-POINT-ID                  PIC X(10).                 
             10 RS-DELIMITER24               PIC X(03).                 
          05 S-REVENUE-CLASS.                                           
             10 RS-REVENUE-CLASS             PIC X(05).                 
             10 RS-DELIMITER25               PIC X(03).                 
          05 S-RECORDER-ID.                                             
             10 RS-RECORDER-ID               PIC X(20).                 
             10 RS-DELIMITER26               PIC X(03).                 
          05 S-ENDPOINT-ID.                                             
             10 RS-ENDPOINT-ID               PIC X(34).                 
             10 RS-DELIMITER27               PIC X(03).                 
          05 S-MTR-INSTALL-DTTM.                                        
             10 RS-MTR-INSTALL-DTTM          PIC X(19).                 
             10 RS-DELIMITER28               PIC X(03).                 
          05 S-MTR-LATITUDE.                                            
             10 RS-MTR-LATITUDE              PIC -999.999999.           
             10 RS-DELIMITER29               PIC X(03).                 
          05 S-MTR-LONGITUDE.                                           
             10 RS-MTR-LONGITUDE             PIC -999.999999.           
             10 RS-DELIMITER30               PIC X(03).                 
          05 S-DBA-NAME.                                                
             10 RS-DBA-NAME                  PIC X(100).                
             10 RS-DELIMITER31               PIC X(03).                 
      *                                                                         
       01 WS-OLD-WORK-AREA.                                             
          05 WS-OLD-METER-NO                 PIC X(09) VALUE SPACES.    
          05 WS-OLD-ACCOUNT-NO-AN            PIC X(13).                 
          05 WS-OLD-ACCOUNT-NO REDEFINES                                
             WS-OLD-ACCOUNT-NO-AN            PIC 9(13).                 
          05 WS-OLD-READ-ROUTE-AN            PIC X(04).                 
          05 WS-OLD-READ-ROUTE REDEFINES                                
             WS-OLD-READ-ROUTE-AN            PIC 9(04).                 
          05 WS-OLD-CONSTANT-AN              PIC X(10).                 
          05 WS-OLD-CONSTANT   REDEFINES                                
             WS-OLD-CONSTANT-AN              PIC 9(6).999.              
          05 WS-OLD-DEVICE-NO                PIC X(12) VALUE SPACES.    
          05 WS-OLD-MTR-SERIAL-NO            PIC X(11) VALUE SPACES.    
          05 WS-OLD-LOCAL-OFFICE             PIC X(03) VALUE SPACES.    
          05 WS-OLD-READ-CYCLE               PIC X(02) VALUE SPACES.    
          05 WS-OLD-DIGTL-MTR-TYPE           PIC X(03) VALUE SPACES.    
          05 WS-OLD-CODE-REVENUE-CLASS       PIC X(03) VALUE SPACES.    
          05 WS-OLD-RATE-PLAN-NO             PIC X(03) VALUE SPACES.    
          05 WS-OLD-PROGRAM-ID               PIC X(02) VALUE SPACES.    
          05 WS-OLD-METER-STATUS             PIC X(01) VALUE SPACES.    
          05 WS-OLD-CODE-ACCT-STAT           PIC X(01) VALUE SPACES.    
          05 WS-OLD-REMOTE-READ-IND          PIC X(01) VALUE SPACES.    
          05 WS-OLD-POINT-ID                 PIC X(10) VALUE SPACES.    
          05 WS-OLD-IDR-IDENT-NO             PIC X(20) VALUE SPACES.    
          05 WS-OLD-ELEC-MTR-CLASS-CD        PIC X(02) VALUE SPACES.    
          05 WS-OLD-ELEC-MTR-SPEC-CD         PIC X(03) VALUE SPACES.    
          05 WS-OLD-METER-SUPPLYING          PIC X(15) VALUE SPACES.    
          05 WS-OLD-SECURED-RATE-FL          PIC X(01) VALUE SPACES.    
      *                                                                         
       01 WS-WORK-AREA.                                                 
          05 RS-RETURN-CODE                  PIC S9(9) VALUE +0 COMP.   
          05 RS-RETURN-CODE-DISP             PIC S9(9) VALUE +0 COMP.   
          05 WS-CURR-TMSTMP                  PIC X(26) VALUE SPACES.    
          05 WS-CURR-DATE                    PIC X(10) VALUE SPACES.    
          05 WS-TMP-READ-ROUTE               PIC 9(04) VALUE 0.         
          05 WS-FROM-UPDATE-TS               PIC X(26) VALUE SPACES.    
          05 WS-TO-UPDATE-TS                 PIC X(26) VALUE SPACES.    
          05 WS-DISPLAY-SQLCODE              PIC ---9.                  
          05 WS-FCSBW60-REC-CNTR             PIC S9(9) COMP VALUE 0.    
          05 WS-PREV-SERVICE-POINT-ID        PIC X(21) VALUE SPACES.    
          05 WS-CUST-NAME                    PIC X(100) VALUE SPACES.   
          05 WS-DBA-NAME                     PIC X(100) VALUE SPACES.   
          05 WS-ACC-ATTB-CHNG-DT             PIC X(10) VALUE SPACES.    
          05 WS-MTR-ATTB-CHNG-DT             PIC X(10) VALUE SPACES.    
          05 WS-ACC-STATUS-DT                PIC X(10) VALUE SPACES.    
          05 WS-MTR-STATUS-DT                PIC X(10) VALUE SPACES.    
          05 WS-HOLD-STATUS-DT               PIC X(10) VALUE SPACES.    
          05 WS-HOLD-MTR-STATUS-DT           PIC X(10)  VALUE SPACES.   
          05 WS-NULL-IND-FIN                 PIC S9(4) COMP VALUE 0.    
          05 WS-NULL-IND-STC                 PIC S9(4) COMP VALUE 0.    
          05 WS-NULL-IND-IAC                 PIC S9(4) COMP VALUE 0.    
          05 WS-NULL-IND-REM                 PIC S9(4) COMP VALUE 0.    
          05 WS-NULL-IND-TIME                PIC S9(4) COMP VALUE 0.    
A#5347    05 WS-NULL-IND-DATE                PIC S9(4) COMP VALUE 0.    
          05 WS-FMT-CHNG-DTTM                PIC X(19) VALUE SPACES.    
          05 WS-ACCT-CHNG-DTTM               PIC X(19) VALUE SPACES.    
      *                                                                         
          05 WS-SERVICE-POINT-ID.                                       
             10 WS-COMPANY-NO                PIC X(02) VALUE SPACES.    
             10 WS-PREMISE-NO                PIC 9(10) VALUE 0.         
             10 WS-CODE-UTIL-TYPE            PIC X(01) VALUE SPACES.    
             10 WS-IC-NO                     PIC 9(04) VALUE 0.         
             10 WS-MTR-REF-NO                PIC 9(04) VALUE 0.         
          05 WS-METER-ID.                                               
             10 WS-COMPANY-NO1               PIC X(02) VALUE SPACES.    
             10 WS-CODE-UTIL-TYPE1           PIC X(01) VALUE SPACES.    
             10 WS-METER-NO1                 PIC X(09) VALUE SPACES.    
          05 WS-METER-TYPE-ID.                                          
             10 WS-DMT                       PIC X(02) VALUE SPACES.    
             10 WS-PGM-ID                    PIC X(02) VALUE SPACES.    
             10 WS-CODE-UTIL-TYPE2           PIC X(01) VALUE SPACES.    
             10 WS-MTR-RD-SRC                PIC X(01) VALUE SPACES.    
          05 WS-MTR-CONSTANT.                                           
             10 WS-CONSTANT-NUM              PIC 9(06) VALUE 0.         
             10 WS-CONSTANT-DPOINT           PIC X(01) VALUE '.'.       
             10 WS-CONSTANT-DEC              PIC V9(3) VALUE 0.         
      *                                                                         
          05 WS-STATUS-DATE1.                                           
             10 WS-STATUS-YYYY1              PIC X(04).                 
             10                              PIC X(01).                 
             10 WS-STATUS-MM1                PIC X(02).                 
             10                              PIC X(01).                 
             10 WS-STATUS-DD1                PIC X(02).                 
      *                                                                         
          05 WS-STATUS-DTTM2.                                           
             10 WS-STATUS-MM2                PIC X(02).                 
             10                              PIC X(01) VALUE '/'.       
             10 WS-STATUS-DD2                PIC X(02).                 
             10                              PIC X(01) VALUE '/'.       
             10 WS-STATUS-YYYY2              PIC X(04).                 
             10                              PIC X(01) VALUE ' '.       
             10 WS-STATUS-HH2                PIC X(02).                 
             10                              PIC X(01) VALUE ':'.       
             10 WS-STATUS-MI2                PIC X(02).                 
             10                              PIC X(01) VALUE ':'.       
             10 WS-STATUS-SS2                PIC X(02).                 
      *                                                                         
      * FCA00 MISC INPUT     *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
                                                                        
      * WOKING STORAGE FOR CPDCA099                                             
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      * MISC INPUT           *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
       01 WS-INPUT-DATA-R8     REDEFINES                                
             WS-INPUT-DATA-BREAKDOWN.                                   
          10 WS-SYSIPT-R8                    PIC X(14).                 
             88 TIME-STAMP                             VALUE            
                                                 'LAST-UPD-TMST='.      
          10 WS-TIME-STAMP-PARM              PIC  X(26).                
          10 FILLER                          PIC  X(40).                
      *                                                                         
       01 WS-END                             PIC X(40) VALUE            
           'WORKING STORAGE FOR PCSBW160 ENDS HERE  '.                  
      *                                                                         
      ******************* BEGIN CURSOR DECLARATION ********************         
      *                                                                         
      *****************************************************************         
      **  CURSOR TO GET ROWS FROM CSS_MDM_SS_INTF_CH                 **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE INTF_CH_CSR CURSOR FOR                            
ACT005           SELECT A.SERVICE_POINT_ID                              
ACT005                 ,A.COLUMN_NA                                     
ACT005                 ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           A.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS         
ACT005                 ,A.PREV_COLUMN_VALUE                             
ACT005                 ,A.CURR_COLUMN_VALUE                             
ACT005                 ,A.LAST_UPDATE_PGM_ID                            
ACT005           FROM  CSS_MDM_SS_INTF_CH A WITH(READUNCOMMITTED)               
ACT005           WHERE A.LAST_UPDATE_TS  > CIS.CHAR2TIMESTAMP(
                                                     :WS-FROM-UPDATE-TS
              )           
ACT005             AND A.LAST_UPDATE_TS <= CIS.CHAR2TIMESTAMP(
                                                       :WS-TO-UPDATE-TS
              )             
ACT005             AND NOT EXISTS                                       
ACT005                (SELECT 'Y'                                       
ACT005                   FROM CSS_MDM_SS_INTF B WITH(READUNCOMMITTED)           
ACT005                  WHERE B.MTR_READ_SOURCE_CD = 'M'                
ACT005                    AND B.RATE_PLAN_NO = '000'                    
ACT005                    AND B.SERVICE_POINT_ID = A.SERVICE_POINT_ID)  
ACT005           ORDER BY A.SERVICE_POINT_ID                            
ACT005                   ,LAST_UPDATE_TS                              
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE INTF_CH_CSR CURSOR FOR                                    
MFA-TR*          SELECT A.SERVICE_POINT_ID                                      
MFA-TR*                ,A.COLUMN_NA                                             
MFA-TR*                ,A.LAST_UPDATE_TS                                        
MFA-TR*                ,A.PREV_COLUMN_VALUE                                     
MFA-TR*                ,A.CURR_COLUMN_VALUE                                     
MFA-TR*                ,A.LAST_UPDATE_PGM_ID                                    
MFA-TR*          FROM  CSS_MDM_SS_INTF_CH A                                     
MFA-TR*          WHERE A.LAST_UPDATE_TS  > :WS-FROM-UPDATE-TS                   
MFA-TR*            AND A.LAST_UPDATE_TS <= :WS-TO-UPDATE-TS                     
MFA-TR*            AND NOT EXISTS                                               
MFA-TR*               (SELECT 'Y'                                               
MFA-TR*                  FROM CSS_MDM_SS_INTF B                                 
MFA-TR*                 WHERE B.MTR_READ_SOURCE_CD = 'M'                        
MFA-TR*                   AND B.RATE_PLAN_NO = '000'                            
MFA-TR*                   AND B.SERVICE_POINT_ID = A.SERVICE_POINT_ID)          
MFA-TR*          ORDER BY A.SERVICE_POINT_ID                                    
MFA-TR*                  ,A.LAST_UPDATE_TS                                      
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7210                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  CURSOR TO GET OPENWAY METERS PREMISE TO TRACK ADDRESS CHNG **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE GET_SP_PREM_CSR CURSOR FOR                        
                 SELECT SERVICE_POINT_ID                                
                       ,ACCOUNT_NO                                      
                 FROM  CSS_MDM_SS_INTF WITH(READUNCOMMITTED)                    
                 WHERE MTR_READ_SOURCE_CD = 'P'                         
                   AND CODE_ACCT_STAT     = 'A'                         
                   AND CODE_METER_STATUS  IN ('A','I')                  
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_SP_PREM_CSR CURSOR FOR                                
MFA-TR*          SELECT SERVICE_POINT_ID                                        
MFA-TR*                ,ACCOUNT_NO                                              
MFA-TR*          FROM  CSS_MDM_SS_INTF                                          
MFA-TR*          WHERE MTR_READ_SOURCE_CD = 'P'                                 
MFA-TR*            AND CODE_ACCT_STAT     = 'A'                                 
MFA-TR*            AND CODE_METER_STATUS  IN ('A','I')                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7710                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  CURSOR TO TRACK NAME & ADDRESS CHANGE                      **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE GET_ADDR_CSR CURSOR FOR                           
             SELECT  MI.COLUMN_DESC                                     
               FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)                
                    ,CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)                
              WHERE  MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO        
                AND (MH.PREMISE_NO  = :MH-PREMISE-NO    OR              
                     MH.ACCOUNT_NO  = :MH-ACCOUNT-NO    OR              
                     MH.CUSTOMER_NO = :MH-CUSTOMER-NO)                  
                AND (MI.COLUMN_DESC = 'HOUSE NO'        OR              
                     MI.COLUMN_DESC = 'HOUSE NUMBER'    OR              
                     MI.COLUMN_DESC = 'STREET NAME'     OR              
                     MI.COLUMN_DESC = 'STREET SUFFIX'   OR              
                     MI.COLUMN_DESC = 'ZIP +4'          OR              
                     MI.COLUMN_DESC = 'ZIP CODE'        OR              
                     MI.COLUMN_DESC = 'ZIP CODE + FOUR' OR              
                     MI.COLUMN_DESC = 'ZIP CODE +4'     OR              
                     MI.COLUMN_DESC = 'ZIP+4 CODE'      OR              
                     MI.COLUMN_DESC = 'ADDR OVERFLOW'   OR              
                     MI.COLUMN_DESC = 'BUSINESS NAME'   OR              
                     MI.COLUMN_DESC = 'DBA NAME'        OR              
                     MI.COLUMN_DESC = 'NEW PREMISE')                    
                AND  MH.TRANS_HIST_SEQ_NO IN                            
                    (SELECT  MI.TRANS_HIST_SEQ_NO                       
                       FROM  CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)        
                      WHERE  MI.COLUMN_DESC <> 'NEW PREMISE'            
                        AND  MI.TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                     :WS-FROM-UPDATE-TS
              ))
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_ADDR_CSR CURSOR FOR                                   
MFA-TR*      SELECT  MI.COLUMN_DESC                                             
MFA-TR*        FROM  CSS_MNT_TRANS_HIST MH                                      
MFA-TR*             ,CSS_MT_TRN_HST_DET MI                                      
MFA-TR*       WHERE  MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO                
MFA-TR*         AND (MH.PREMISE_NO  = :MH-PREMISE-NO    OR                      
MFA-TR*              MH.ACCOUNT_NO  = :MH-ACCOUNT-NO    OR                      
MFA-TR*              MH.CUSTOMER_NO = :MH-CUSTOMER-NO)                          
MFA-TR*         AND (MI.COLUMN_DESC = 'HOUSE NO'        OR                      
MFA-TR*              MI.COLUMN_DESC = 'HOUSE NUMBER'    OR                      
MFA-TR*              MI.COLUMN_DESC = 'STREET NAME'     OR                      
MFA-TR*              MI.COLUMN_DESC = 'STREET SUFFIX'   OR                      
MFA-TR*              MI.COLUMN_DESC = 'ZIP +4'          OR                      
MFA-TR*              MI.COLUMN_DESC = 'ZIP CODE'        OR                      
MFA-TR*              MI.COLUMN_DESC = 'ZIP CODE + FOUR' OR                      
MFA-TR*              MI.COLUMN_DESC = 'ZIP CODE +4'     OR                      
MFA-TR*              MI.COLUMN_DESC = 'ZIP+4 CODE'      OR                      
MFA-TR*              MI.COLUMN_DESC = 'ADDR OVERFLOW'   OR                      
MFA-TR*              MI.COLUMN_DESC = 'BUSINESS NAME'   OR                      
MFA-TR*              MI.COLUMN_DESC = 'DBA NAME'        OR                      
MFA-TR*              MI.COLUMN_DESC = 'NEW PREMISE')                            
MFA-TR*         AND  MH.TRANS_HIST_SEQ_NO IN                                    
MFA-TR*             (SELECT  MI.TRANS_HIST_SEQ_NO                               
MFA-TR*                FROM  CSS_MT_TRN_HST_DET MI                              
MFA-TR*               WHERE  MI.COLUMN_DESC <> 'NEW PREMISE'                    
MFA-TR*                 AND  MI.TRANS_HIST_SEQ_NO >= :WS-FROM-UPDATE-TS)        
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7310                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
      *                                                                         
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
      *                                                                         
           PERFORM 1000-PROCESS-INTF-CHNG   THRU 1000-EXIT              
             UNTIL NO-MORE-SERVICE-POINTS.                              
      *                                                                         
           PERFORM 7230-CLOSE-INTF-CH-CSR   THRU 7230-EXIT.             
      *                                                                         
           PERFORM 1900-PROCESS-ADDR-CHNG   THRU 1900-EXIT.             
      *                                                                         
           MOVE WS-TO-UPDATE-TS           TO WS-LAST-UPD-TMST-VALUE     
           MOVE WS-LAST-UPD-TMST-PARM     TO G6-PARM-DATA.              
      *                                                                         
           PERFORM 8900-UPDATE-TIMESTMP     THRU 8900-EXIT.             
      *                                                                         
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           OPEN OUTPUT FCSBW60-FILE.                                    
                                                                        
           IF  FBW60-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN  0100-INITIALIZATION            **'  
              DISPLAY '**   FILE FCSBW60 OPEN INPUT                **'  
              DISPLAY '** FILE STATUS = ' WS-FBW60-STATUS               
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT.             
                                                                        
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                            THRU 6240-EXIT              
               DISPLAY 'COMMON DATE ==> ' WS-FCA00-COMMON-DATE          
               MOVE WS-FCA00-COMMON-DATE  TO WS-INPUT-DATE              
           END-IF.                                                      
      *                                                                         
      *** GET LAST UPDATE TIMESTAMP FROM JOB PARM                               
           MOVE SPACES                    TO WS-SYSIPT.                 
           MOVE ZEROS                     TO WS-SEQUENCE.               
           MOVE WS-PARM                   TO WS-COMMAND.                
           MOVE WS-KEY-AREA               TO E-FJC01-KEY.               
                                                                        
           PERFORM 7600-START-FCSJC01       THRU 7600-EXIT.             
                                                                        
           PERFORM 7610-READ-FCSJC01        THRU 7610-EXIT              
             UNTIL (TIME-STAMP AND INPUT-ACTIVE)                        
                OR  END-OF-SYSIPT.                                      
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY '**     PCSBW160 PROCESSING ERROR     **'         
              DISPLAY '** LAST UPDATE TIMESTAMP NOT PRESENT **'         
              DISPLAY '**  KEY = ' E-FJC01-KEY                          
              DISPLAY '**        PROCESSING TERMINATED      **'         
              DISPLAY ' '                                               
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           ELSE                                                         
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
              DISPLAY 'LAST RUN TIMESTAMP ==> ' WS-TIME-STAMP-PARM      
              MOVE WS-TIME-STAMP-PARM     TO WS-FROM-UPDATE-TS          
           END-IF.                                                      
      *                                                                         
           PERFORM 7240-GET-CURR-TMSTMP     THRU 7240-EXIT.             
           MOVE WS-CURR-TMSTMP            TO WS-TO-UPDATE-TS.           
           DISPLAY 'CURRENT TIMESTAMP  ==> ' WS-TO-UPDATE-TS.           
           DISPLAY '  '.                                                
      *                                                                         
      *** GET ITRON ENDPOINT-ID                                                 
           PERFORM 7270-GET-ENDPOINT-ID      THRU 7270-EXIT.            
           MOVE UV-CODE-LONG-DESC-TEXT    TO WS-ENDPOINT-ID.            
      *                                                                         
           PERFORM 7210-OPEN-INTF-CH-CSR    THRU 7210-EXIT.             
      *                                                                         
           PERFORM 7220-FETCH-INTF-CH-CSR   THRU 7220-EXIT.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              DISPLAY '  '                                              
              DISPLAY '****************************************'        
              DISPLAY '**                                    **'        
              DISPLAY '**   NO SERVICE POINT CHANGES FOUND   **'        
              DISPLAY '**   PROGRAM COMPLTED SUCCESSFULLY.   **'        
              DISPLAY '**                                    **'        
              DISPLAY '****************************************'        
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-PROCESS-INTF-CHNG.                                          
      *================================================================*        
      *                                                                         
           MOVE 1E-SERVICE-POINT-ID       TO 1D-SERVICE-POINT-ID        
                                             WS-PREV-SERVICE-POINT-ID.  
           DISPLAY 'PROCESSING SP: ' 1D-SERVICE-POINT-ID.               
      *                                                                         
           PERFORM 7100-GET-INTF-DETAILS    THRU 7100-EXIT.             
      *                                                                         
           PERFORM 1200-RESET-OLD-DETAILS   THRU 1200-EXIT.             
      *                                                                         
           PERFORM 1400-EVALUATE-TRANSACTIONS THRU 1400-EXIT            
             UNTIL NO-MORE-SERVICE-POINTS                               
             OR 1E-SERVICE-POINT-ID NOT = WS-PREV-SERVICE-POINT-ID.     
      *                                                                         
           IF MASTER-DATA-CHANGED                                       
              IF NEW-MTR-VALID-MDMS OR OLD-MTR-VALID-MDMS               
                 PERFORM 1600-PROCESS-TRANSACTIONS THRU 1600-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1200-RESET-OLD-DETAILS.                                          
      *================================================================*        
      *** INITIALIZE ALL OLD VARIABLES WITH NEW                                 
      *                                                                         
           MOVE 1D-SERVICE-POINT-ID       TO WS-SERVICE-POINT-ID.       
                                                                        
           MOVE 1D-ACCOUNT-NO             TO AT-ACCOUNT-NO              
                                             MN-ACCOUNT-NO              
                                             WS-OLD-ACCOUNT-NO          
           MOVE WS-CODE-UTIL-TYPE         TO MN-CODE-UTIL-TYPE          
           MOVE WS-IC-NO                  TO MN-IC-NO                   
           MOVE WS-MTR-REF-NO             TO MN-MTR-REF-NO              
      *                                                                         
           MOVE 1D-METER-NO               TO WS-OLD-METER-NO            
           MOVE 1D-CODE-ACCT-STAT         TO WS-OLD-CODE-ACCT-STAT      
           MOVE 1D-CODE-METER-STATUS      TO WS-OLD-METER-STATUS        
           MOVE 1D-MTR-READ-SOURCE-CD     TO WS-NEW-MRS-CD-SW           
                                             WS-OLD-MRS-CD-SW           
      *                                                                         
           MOVE 1D-DIGTL-MTR-TYPE     TO WS-OLD-DIGTL-MTR-TYPE          
           MOVE 1D-MTR-SERIAL-NO      TO WS-OLD-MTR-SERIAL-NO           
           MOVE 1D-DEVICE-NO          TO WS-OLD-DEVICE-NO               
           MOVE 1D-LOCAL-OFFICE       TO WS-OLD-LOCAL-OFFICE            
           MOVE 1D-READ-ROUTE         TO WS-OLD-READ-ROUTE              
           MOVE 1D-READ-CYCLE         TO WS-OLD-READ-CYCLE              
           MOVE 1D-CODE-REVENUE-CLASS TO WS-OLD-CODE-REVENUE-CLASS      
           MOVE 1D-RATE-PLAN-NO       TO WS-OLD-RATE-PLAN-NO            
           MOVE 1D-PROGRAM-ID         TO WS-OLD-PROGRAM-ID              
           MOVE 1D-REMOTE-READ-IND    TO WS-OLD-REMOTE-READ-IND         
           MOVE 1D-CONSTANT           TO WS-OLD-CONSTANT                
           MOVE 1D-POINT-ID           TO WS-OLD-POINT-ID                
           MOVE 1D-IDR-IDENT-NO       TO WS-OLD-IDR-IDENT-NO            
           MOVE 1D-ELEC-MTR-CLASS-CD  TO WS-OLD-ELEC-MTR-CLASS-CD       
           MOVE 1D-ELEC-MTR-SPEC-CD   TO WS-OLD-ELEC-MTR-SPEC-CD        
           MOVE 1D-METER-SUPPLYING    TO WS-OLD-METER-SUPPLYING         
           MOVE 1D-SECURED-RATE-FL    TO WS-OLD-SECURED-RATE-FL         
      *                                                                         
           SET MASTER-DATA-NOT-CHANGED    TO TRUE                       
           SET METER-TYPE-NOT-CHANGED     TO TRUE                       
           SET METER-CONST-NOT-CHANGED    TO TRUE                       
           SET SERVICE-POINT-EXISTS       TO TRUE.                      
           MOVE SPACES                    TO WS-ACC-ATTB-CHNG-DT        
                                             WS-MTR-ATTB-CHNG-DT.       
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1400-EVALUATE-TRANSACTIONS.                                      
      *================================================================*        
      *** EXAMINE CHANGES AND SET FLAGS FOR LATER PROCESSING                    
      *                                                                         
           EVALUATE 1E-COLUMN-NA                                        
             WHEN 'SERVICE_POINT_ID'                                    
               SET NEW-SERVICE-POINT     TO TRUE                        
               SET MASTER-DATA-CHANGED   TO TRUE                        
             WHEN 'MTR_READ_SOURCE_CD'                                  
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-MRS-CD-SW            
               SET MASTER-DATA-CHANGED   TO TRUE                        
               MOVE WS-CURR-DATE         TO WS-MTR-ATTB-CHNG-DT         
             WHEN 'CODE_METER_STATUS'                                   
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-METER-STATUS         
               SET MASTER-DATA-CHANGED   TO TRUE                        
             WHEN 'CODE_ACCT_STAT'                                      
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-CODE-ACCT-STAT       
               SET MASTER-DATA-CHANGED   TO TRUE                        
             WHEN 'METER_NO'                                            
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-METER-NO             
               SET MASTER-DATA-CHANGED   TO TRUE                        
             WHEN 'ACCOUNT_NO'                                          
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-ACCOUNT-NO-AN        
               SET MASTER-DATA-CHANGED   TO TRUE                        
             WHEN 'DIGTL_MTR_TYPE'                                      
               SET MASTER-DATA-CHANGED   TO TRUE                        
               SET METER-TYPE-CHANGED    TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-DIGTL-MTR-TYPE       
             WHEN 'DEVICE_NO'                                           
               SET MASTER-DATA-CHANGED   TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-DEVICE-NO            
               MOVE WS-CURR-DATE         TO WS-MTR-ATTB-CHNG-DT         
             WHEN 'LOCAL_OFFICE'                                        
               SET MASTER-DATA-CHANGED   TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-LOCAL-OFFICE         
               MOVE WS-CURR-DATE         TO WS-ACC-ATTB-CHNG-DT         
             WHEN 'READ_ROUTE'                                          
               SET MASTER-DATA-CHANGED   TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-READ-ROUTE-AN        
               MOVE WS-CURR-DATE         TO WS-MTR-ATTB-CHNG-DT         
             WHEN 'READ_CYCLE'                                          
               SET MASTER-DATA-CHANGED   TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-READ-CYCLE           
               MOVE WS-CURR-DATE         TO WS-ACC-ATTB-CHNG-DT         
             WHEN 'CODE_REVENUE_CLASS'                                  
               SET MASTER-DATA-CHANGED   TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-CODE-REVENUE-CLASS   
               MOVE WS-CURR-DATE         TO WS-MTR-ATTB-CHNG-DT         
             WHEN 'RATE_PLAN_NO'                                        
               SET MASTER-DATA-CHANGED   TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-RATE-PLAN-NO         
               MOVE WS-CURR-DATE         TO WS-MTR-ATTB-CHNG-DT         
             WHEN 'PROGRAM_ID'                                          
               SET MASTER-DATA-CHANGED   TO TRUE                        
               SET METER-TYPE-CHANGED    TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-PROGRAM-ID           
               MOVE WS-CURR-DATE         TO WS-MTR-ATTB-CHNG-DT         
             WHEN 'REMOTE_READ_IND'                                     
               SET MASTER-DATA-CHANGED   TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-REMOTE-READ-IND      
               MOVE WS-CURR-DATE         TO WS-MTR-ATTB-CHNG-DT         
             WHEN 'CONSTANT'                                            
               SET MASTER-DATA-CHANGED   TO TRUE                        
               SET METER-CONST-CHANGED   TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-CONSTANT-AN          
               MOVE WS-CURR-DATE         TO WS-MTR-ATTB-CHNG-DT         
             WHEN 'POINT_ID'                                            
               SET MASTER-DATA-CHANGED   TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-POINT-ID             
               MOVE WS-CURR-DATE         TO WS-MTR-ATTB-CHNG-DT         
             WHEN 'IDR_IDENT_NO'                                        
               SET MASTER-DATA-CHANGED   TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-IDR-IDENT-NO         
               MOVE WS-CURR-DATE         TO WS-MTR-ATTB-CHNG-DT         
             WHEN 'METER_SUPPLYING'                                     
               SET MASTER-DATA-CHANGED   TO TRUE                        
               MOVE 1E-PREV-COLUMN-VALUE TO WS-OLD-METER-SUPPLYING      
               MOVE WS-CURR-DATE         TO WS-MTR-ATTB-CHNG-DT         
             WHEN OTHER                                                 
               CONTINUE                                                 
           END-EVALUATE                                                 
                                                                        
           PERFORM 7220-FETCH-INTF-CH-CSR   THRU 7220-EXIT.             
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1600-PROCESS-TRANSACTIONS.                                       
      *================================================================*        
      *** PROCESS ONLY NEEDED CHANGES FOR MDM. CHANGES COULD BE                 
      *** NEW ENTITIES, ACCT ATTRIBUTE CHGS, MTR ATTRIBUTE CHGS, ETC            
      *                                                                         
           MOVE SPACES                 TO WS-RECORD-STRING              
                                          WS-ACC-STATUS-DT              
                                          WS-MTR-STATUS-DT              
                                          WS-HOLD-MTR-STATUS-DT         
                                          WS-HOLD-STATUS-DT.            
      *                                                                         
           EVALUATE TRUE                                                
                                                                        
             WHEN (NEW-SERVICE-POINT AND NEW-MTR-VALID-MDMS)            
A#5347       WHEN (NEW-MTR-VALID-MDMS AND OLD-MTR-NOT-VALID-MDMS)       
                  PERFORM 2300-NEW-ACCOUNT-ENTITY  THRU 2300-EXIT       
                  PERFORM 2400-NEW-METER-ENTITY    THRU 2400-EXIT       
                  PERFORM 3900-FORMAT-NEW-SERVICE  THRU 3900-EXIT       
                                                                        
             WHEN 1D-ACCOUNT-NO NOT = WS-OLD-ACCOUNT-NO                 
              AND 1D-METER-NO = WS-OLD-METER-NO                         
               PERFORM 2700-OLD-ACCT-ENTITY-CHNG   THRU 2700-EXIT       
               PERFORM 2300-NEW-ACCOUNT-ENTITY     THRU 2300-EXIT       
               PERFORM 2600-CURR-MTR-ENTITY-CHNG   THRU 2600-EXIT       
               PERFORM 3910-FORMAT-ACCOUNT-CHG     THRU 3910-EXIT       
               MOVE RS-ACCT-CHNG-DTTM           TO WS-ACCT-CHNG-DTTM    
               PERFORM 3920-FORMAT-RATE-CHG        THRU 3920-EXIT       
               PERFORM 3925-FORMAT-RDCYC-LO-CHG    THRU 3925-EXIT       
               IF (METER-TYPE-CHANGED OR METER-CONST-CHANGED)           
                  PERFORM 3995-FORMAT-MTR-REPROGRAM   THRU 3995-EXIT    
               END-IF                                                   
                                                                        
             WHEN 1D-ACCOUNT-NO = WS-OLD-ACCOUNT-NO                     
              AND ((1D-METER-NO NOT = WS-OLD-METER-NO)                  
                 OR METER-TYPE-CHANGED                                  
                 OR METER-CONST-CHANGED)                                
               IF OLD-MTR-VALID-MDMS                                    
                  PERFORM 2800-OLD-MTR-ENTITY-CHNG THRU 2800-EXIT       
               END-IF                                                   
               IF NEW-MTR-VALID-MDMS                                    
                  PERFORM 2300-NEW-ACCOUNT-ENTITY  THRU 2300-EXIT       
                  PERFORM 2400-NEW-METER-ENTITY    THRU 2400-EXIT       
               END-IF                                                   
A5347A         IF NEW-MTR-NOT-VALID-MDMS                                
A5347A            AND OLD-MTR-VALID-MDMS                                
ACT007            OR (NEW-MTR-VALID-MDMS                                
ACT007            AND 1D-CODE-METER-STATUS = 'K')                       
A5347A            PERFORM 3940-FORMAT-REMOVE-MTR   THRU 3940-EXIT       
A5347A         ELSE                                                     
A5347A            PERFORM 3930-FORMAT-METER-CHG    THRU 3930-EXIT       
A5347A            MOVE RS-ACCT-CHNG-DTTM        TO WS-ACCT-CHNG-DTTM    
A5347A            PERFORM 3920-FORMAT-RATE-CHG     THRU 3920-EXIT       
A5347A         END-IF                                                   
                                                                        
      *      WHEN 1D-ACCOUNT-NO NOT = WS-OLD-ACCOUNT-NO                         
      *       AND 1D-METER-NO NOT = WS-OLD-METER-NO                             
      *        IF NEW-MTR-VALID-MDMS                                            
      *           PERFORM 2300-NEW-ACCOUNT-ENTITY  THRU 2300-EXIT               
      *           PERFORM 2400-NEW-METER-ENTITY    THRU 2400-EXIT               
      *           PERFORM 3900-FORMAT-NEW-SERVICE  THRU 3900-EXIT               
      *        END-IF                                                           
      *        IF OLD-MTR-VALID-MDMS                                            
      *           PERFORM 2800-OLD-MTR-ENTITY-CHNG THRU 2800-EXIT               
      *           PERFORM 3940-FORMAT-REMOVE-MTR   THRU 3940-EXIT               
      *        END-IF                                                           
                                                                        
             WHEN 1D-ACCOUNT-NO NOT = WS-OLD-ACCOUNT-NO                 
              AND 1D-METER-NO NOT = WS-OLD-METER-NO                     
               PERFORM 2800-OLD-MTR-ENTITY-CHNG THRU 2800-EXIT          
A#5347         IF NEW-MTR-VALID-MDMS                                    
                  PERFORM 2700-OLD-ACCT-ENTITY-CHNG THRU 2700-EXIT      
                  PERFORM 2300-NEW-ACCOUNT-ENTITY   THRU 2300-EXIT      
                  PERFORM 2400-NEW-METER-ENTITY     THRU 2400-EXIT      
                  MOVE RS-ACCT-CHNG-DTTM            TO WS-ACCT-CHNG-DTTM
                  PERFORM 3910-FORMAT-ACCOUNT-CHG   THRU 3910-EXIT      
                  PERFORM 3930-FORMAT-METER-CHG     THRU 3930-EXIT      
                  PERFORM 3920-FORMAT-RATE-CHG      THRU 3920-EXIT      
                  PERFORM 3925-FORMAT-RDCYC-LO-CHG  THRU 3925-EXIT      
               ELSE                                                     
                  PERFORM 3940-FORMAT-REMOVE-MTR    THRU 3940-EXIT      
               END-IF                                                   
                                                                        
             WHEN OTHER                                                 
               IF OLD-MTR-VALID-MDMS                                    
                  PERFORM 2700-OLD-ACCT-ENTITY-CHNG THRU 2700-EXIT      
                  PERFORM 2800-OLD-MTR-ENTITY-CHNG  THRU 2800-EXIT      
                  IF 1D-CODE-METER-STATUS NOT = WS-OLD-METER-STATUS     
                     IF 1D-CODE-METER-STATUS = 'K'                      
                        PERFORM 3940-FORMAT-REMOVE-MTR THRU 3940-EXIT   
                     END-IF                                             
                     IF 1D-CODE-METER-STATUS = 'J'                      
                        MOVE 'Inactive'         TO WS-OLD-MTR-STATUS    
                        PERFORM 3980-FORMAT-MTR-STAT-CHG THRU 3980-EXIT 
                     END-IF                                             
                  END-IF                                                
                  IF 1D-CODE-ACCT-STAT NOT = WS-OLD-CODE-ACCT-STAT      
                     IF 1D-CODE-ACCT-STAT NOT = 'A'                     
                        MOVE 'Inactive'         TO WS-OLD-ACCT-STATUS   
                        PERFORM 3990-FORMAT-ACCT-STAT-CHG THRU 3990-EXIT
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
                                                                        
               IF NEW-MTR-VALID-MDMS                                    
                  PERFORM 2500-CURR-ACCT-ENTITY-CHNG THRU 2500-EXIT     
                  PERFORM 2600-CURR-MTR-ENTITY-CHNG  THRU 2600-EXIT     
                  PERFORM 3920-FORMAT-RATE-CHG       THRU 3920-EXIT     
                  PERFORM 3925-FORMAT-RDCYC-LO-CHG   THRU 3925-EXIT     
                  MOVE WS-CURR-DATE             TO WS-HOLD-STATUS-DT    
                  PERFORM 2900-FORMAT-STATUS-DATES   THRU 2900-EXIT     
                  MOVE WS-FMT-CHNG-DTTM         TO RS-MTR-INSTALL-DTTM  
                  IF RS-METER-SUPPLYING > SPACES                        
                     CONTINUE                                           
                  ELSE                                                  
                     MOVE 'None'                TO RS-METER-SUPPLYING   
                  END-IF                                                
                  PERFORM 3950-FORMAT-PTID-MTRSUP    THRU 3950-EXIT     
                  IF 1D-CODE-METER-STATUS NOT = WS-OLD-METER-STATUS     
                     IF 1D-CODE-METER-STATUS = 'A'                      
                        MOVE WS-METER-ID        TO WS-OLD-METER-ID      
                        MOVE 'Active'           TO WS-OLD-MTR-STATUS    
                        MOVE RS-MTR-INSTALL-DTTM TO WS-OLD-MTR-INS-DTTM 
                        PERFORM 3980-FORMAT-MTR-STAT-CHG THRU 3980-EXIT 
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       1600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1900-PROCESS-ADDR-CHNG.                                          
      *================================================================*        
      *                                                                         
           DISPLAY ' '.                                                 
           DISPLAY '*** PROCESSING NAME & ADDRESS CHANGE ***'           
      *                                                                         
           SET PROCESS-ALL-SPS TO TRUE.                                 
                                                                        
           PERFORM 7710-OPEN-SP-PREM-CSR     THRU 7710-EXIT.            
      *                                                                         
           PERFORM 7720-FETCH-SP-PREM-CSR    THRU 7720-EXIT.            
      *                                                                         
           PERFORM 5100-PROCESS-PREM-CSR     THRU 5100-EXIT             
             UNTIL NO-MORE-SERVICE-POINTS.                              
      *                                                                         
           PERFORM 7730-CLOSE-SP-PREM-CSR    THRU 7730-EXIT.            
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2300-NEW-ACCOUNT-ENTITY.                                         
      *================================================================*        
      *** TO CREATE NEW ACCOUNT ENTITY IN MDM                                   
      *                                                                         
           MOVE 1D-ACCOUNT-NO            TO RS-ACCOUNT-NO               
                                            AT-ACCOUNT-NO               
                                            CH-ACCOUNT-NO               
                                                                        
           MOVE WS-PREMISE-NO            TO RS-PREMISE-NO               
           PERFORM 7250-GET-SERVICE-DATES   THRU 7250-EXIT              
           MOVE CH-CUSTOMER-NO           TO RS-CUSTOMER-NO              
      *                                                                         
           IF 1D-CODE-ACCT-STAT = 'A'                                   
              MOVE 'Active'              TO RS-ACCT-STATUS              
              MOVE CH-DATE-UTIL-SVC-STRT TO WS-ACC-STATUS-DT            
           ELSE                                                         
              MOVE 'Final'               TO RS-ACCT-STATUS              
              MOVE CH-DATE-UTIL-SVC-END  TO WS-ACC-STATUS-DT            
           END-IF                                                       
                                                                        
           IF WS-ACC-STATUS-DT = SPACES                                 
              MOVE WS-CURR-DATE          TO WS-ACC-STATUS-DT            
           END-IF                                                       
                                                                        
           MOVE WS-ACC-STATUS-DT         TO WS-HOLD-STATUS-DT           
           PERFORM 2900-FORMAT-STATUS-DATES THRU 2900-EXIT              
           MOVE WS-FMT-CHNG-DTTM         TO RS-ACCT-CHNG-DTTM           
      *                                                                         
           MOVE 1D-READ-CYCLE            TO RS-READ-CYCLE.              
      *                                                                         
           MOVE SPACES                   TO B1-LOCAL-OFFICE-DESC.       
           PERFORM 7400-GET-LOCAL-OFFICE    THRU 7400-EXIT.             
           STRING 1D-LOCAL-OFFICE      DELIMITED BY SIZE                
                  ' - '                DELIMITED BY SIZE                
                  B1-LOCAL-OFFICE-DESC DELIMITED BY '  '                
              INTO RS-LOC-OFFICE                                        
           END-STRING.                                                  
      *                                                                         
           PERFORM 6000-FORMAT-NAME-ADDRESS THRU 6000-EXIT.             
A#5347*GET CUSTOMER ESTABLISHED DATE                                            
A#5347     MOVE SPACES                   TO RS-CUST-EST-DTTM.           
A#5347     PERFORM 7700-GET-CUST-EST-DT     THRU 7700-EXIT.             
A#5347                                                                  
A#5347     MOVE CU-CUSTOMER-EST-DATE     TO WS-HOLD-STATUS-DT           
A#5347     PERFORM 2900-FORMAT-STATUS-DATES   THRU 2900-EXIT            
A#5347     MOVE WS-FMT-CHNG-DTTM         TO RS-CUST-EST-DTTM.           
A#5347                                                                  
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2400-NEW-METER-ENTITY.                                           
      *================================================================*        
      *** TO CREATE NEW METER ENTITY IN MDM                                     
      *                                                                         
           MOVE 1D-SERVICE-POINT-ID      TO RS-SERVICE-POINT-ID         
           MOVE WS-COMPANY-NO            TO WS-COMPANY-NO1              
           MOVE WS-CODE-UTIL-TYPE        TO WS-CODE-UTIL-TYPE1          
           MOVE 1D-METER-NO              TO WS-METER-NO1                
           MOVE WS-METER-ID              TO RS-METER-ID                 
      *                                                                         
           MOVE SPACES                   TO WS-ENDPT-MTR-SRC            
           MOVE 1D-METER-NO              TO RS-METER-NO                 
                                            WS-ENDPT-MTR-SRC.           
           PERFORM 3000-FRMT-ENDPOINT       THRU 3000-EXIT.             
      *                                                                         
A#5347     IF 1D-MTR-READ-SOURCE-CD = WS-MV90                           
A#5347        MOVE 1D-IDR-IDENT-NO       TO RS-ENDPOINT-ID              
A#5347     ELSE                                                         
A#5347        STRING WS-ENDPOINT-ID     DELIMITED BY SIZE               
A#5347               WS-ENDPT-MTR-TRGT  DELIMITED BY SIZE               
A#5347          INTO RS-ENDPOINT-ID                                     
A#5347        END-STRING                                                
A#5347     END-IF.                                                      
      *                                                                         
           MOVE 1D-DIGTL-MTR-TYPE        TO WS-DMT                      
           MOVE 1D-PROGRAM-ID            TO WS-PGM-ID                   
           MOVE WS-CODE-UTIL-TYPE        TO WS-CODE-UTIL-TYPE2          
           MOVE 1D-MTR-READ-SOURCE-CD    TO WS-MTR-RD-SRC               
           MOVE WS-METER-TYPE-ID         TO RS-METER-TYPE-ID            
      *                                                                         
           EVALUATE 1D-MTR-READ-SOURCE-CD                               
              WHEN 'P'                                                  
                 MOVE 'Openway'          TO RS-AMI-VENDOR               
              WHEN 'M'                                                  
A#5347           MOVE 'MV90'             TO RS-AMI-VENDOR               
              WHEN OTHER                                                
                 MOVE 'Unknown'          TO RS-AMI-VENDOR               
           END-EVALUATE                                                 
      *                                                                         
           MOVE 1D-CONSTANT              TO WS-CONSTANT-NUM             
                                            WS-CONSTANT-DEC             
           MOVE '.'                      TO WS-CONSTANT-DPOINT          
           MOVE WS-MTR-CONSTANT          TO RS-CONSTANT-KWH             
      *                                                                         
           MOVE 1D-ACCOUNT-NO            TO MN-ACCOUNT-NO               
           PERFORM 7260-GET-MTR-STATUS-DATES THRU 7260-EXIT             
           MOVE SPACES                   TO WS-MTR-STATUS-DT            
                                            WS-HOLD-STATUS-DT           
           EVALUATE 1D-CODE-METER-STATUS                                
              WHEN 'J'                                                  
                 MOVE 'Inactive'         TO RS-METER-STATUS             
                 MOVE MN-METER-INACTIVE-DT TO WS-MTR-STATUS-DT          
                 IF WS-MTR-STATUS-DT = SPACES                           
                    MOVE WS-CURR-DATE    TO WS-MTR-STATUS-DT            
                 END-IF                                                 
              WHEN 'K'                                                  
                 MOVE 'Inactive'         TO RS-METER-STATUS             
                 MOVE MN-METER-REMOVED-DT TO WS-MTR-STATUS-DT           
                 IF WS-MTR-STATUS-DT = SPACES                           
                    MOVE WS-CURR-DATE    TO WS-MTR-STATUS-DT            
                 END-IF                                                 
              WHEN OTHER                                                
                 MOVE 'Active'           TO RS-METER-STATUS             
                 MOVE MN-DATE-MTR-INSTALL TO WS-MTR-STATUS-DT           
           END-EVALUATE                                                 
                                                                        
           IF WS-MTR-STATUS-DT = SPACES                                 
              OR WS-MTR-STATUS-DT < MN-DATE-MTR-INSTALL                 
              MOVE MN-DATE-MTR-INSTALL   TO WS-MTR-STATUS-DT            
           END-IF                                                       
      *                                                                         
           MOVE WS-MTR-STATUS-DT         TO WS-HOLD-STATUS-DT           
                                            WS-HOLD-MTR-STATUS-DT       
           PERFORM 2910-FORMAT-METER-DATE   THRU 2910-EXIT              
           MOVE WS-FMT-CHNG-DTTM         TO RS-MTR-INSTALL-DTTM         
      *                                                                         
ACT054     MOVE ZEROES                   TO PR-PREMISE-NO               
ACT054                                      PR-PREM-REF-LATITUDE        
ACT054                                      PR-PREM-REF-LONGITUDE       
ACT054     MOVE WS-PREMISE-NO            TO PR-PREMISE-NO               
ACT054     PERFORM 7265-GET-PREM-LAT-LONG   THRU 7265-EXIT              
ACT054     MOVE PR-PREM-REF-LATITUDE     TO RS-MTR-LATITUDE             
ACT054     MOVE PR-PREM-REF-LONGITUDE    TO RS-MTR-LONGITUDE            
      *                                                                         
           IF 1D-METER-SUPPLYING > SPACES                               
              MOVE 1D-METER-SUPPLYING    TO RS-METER-SUPPLYING          
           ELSE                                                         
              MOVE 'None'                TO RS-METER-SUPPLYING          
           END-IF                                                       
                                                                        
           IF 1D-POINT-ID > SPACES                                      
              MOVE 1D-POINT-ID           TO RS-POINT-ID                 
           ELSE                                                         
              MOVE 'None'                TO RS-POINT-ID                 
           END-IF                                                       
      *                                                                         
           MOVE SPACES                   TO RD-RATE-PLAN-NO             
           MOVE 1D-RATE-PLAN-NO          TO RD-RATE-PLAN-NO             
           PERFORM 7500-GET-RATE-DESC       THRU 7500-EXIT              
           STRING 1D-RATE-PLAN-NO      DELIMITED BY SIZE                
                  ' - '                DELIMITED BY SIZE                
                  RD-RATE-DESC         DELIMITED BY SIZE                
              INTO RS-RATE-PLAN-NO                                      
           END-STRING.                                                  
      *                                                                         
           MOVE 1D-CODE-REVENUE-CLASS    TO RS-REVENUE-CLASS            
      *                                                                         
A#5347     IF 1D-MTR-READ-SOURCE-CD = WS-MV90                           
              MOVE 1D-IDR-IDENT-NO       TO RS-RECORDER-ID              
           ELSE                                                         
ACT007        MOVE 1D-METER-NO(3:7)      TO RS-RECORDER-ID              
           END-IF                                                       
      *                                                                         
           MOVE 1D-READ-CYCLE            TO RS-READ-CYCLE.              
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2500-CURR-ACCT-ENTITY-CHNG.                                      
      *================================================================*        
      *** CHANGES TO EXISTING ACCOUNT ENTITY IN MDM                             
      *                                                                         
           MOVE 1D-ACCOUNT-NO           TO RS-ACCOUNT-NO                
                                           AT-ACCOUNT-NO                
                                           CH-ACCOUNT-NO                
                                                                        
           MOVE WS-PREMISE-NO           TO RS-PREMISE-NO                
           PERFORM 7250-GET-SERVICE-DATES THRU 7250-EXIT                
           MOVE CH-CUSTOMER-NO          TO RS-CUSTOMER-NO               
      *                                                                         
           IF 1D-CODE-ACCT-STAT = 'A'                                   
              MOVE 'Active'             TO RS-ACCT-STATUS               
           ELSE                                                         
              MOVE 'Final'              TO RS-ACCT-STATUS               
           END-IF                                                       
                                                                        
           MOVE WS-CURR-DATE            TO WS-HOLD-STATUS-DT.           
           PERFORM 2900-FORMAT-STATUS-DATES THRU 2900-EXIT              
           MOVE WS-FMT-CHNG-DTTM        TO WS-ACCT-CHNG-DTTM            
      *                                                                         
           MOVE 1D-READ-CYCLE           TO RS-READ-CYCLE.               
      *                                                                         
           MOVE SPACES                  TO B1-LOCAL-OFFICE-DESC.        
           PERFORM 7400-GET-LOCAL-OFFICE    THRU 7400-EXIT.             
           STRING 1D-LOCAL-OFFICE      DELIMITED BY SIZE                
                  ' - '                DELIMITED BY SIZE                
                  B1-LOCAL-OFFICE-DESC DELIMITED BY '  '                
              INTO RS-LOC-OFFICE                                        
           END-STRING.                                                  
      *                                                                         
           PERFORM 6000-FORMAT-NAME-ADDRESS THRU 6000-EXIT.             
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2600-CURR-MTR-ENTITY-CHNG.                                       
      *================================================================*        
      *** CHANGES TO EXISTING METER ENTITY IN MDM                               
      *                                                                         
           MOVE 1D-SERVICE-POINT-ID     TO RS-SERVICE-POINT-ID          
           MOVE WS-COMPANY-NO           TO WS-COMPANY-NO1               
           MOVE WS-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE1           
           MOVE 1D-METER-NO             TO WS-METER-NO1                 
           MOVE WS-METER-ID             TO RS-METER-ID                  
      *                                                                         
           MOVE SPACES                  TO WS-ENDPT-MTR-SRC             
           MOVE 1D-METER-NO             TO RS-METER-NO                  
                                           WS-ENDPT-MTR-SRC             
      *                                                                         
           PERFORM 3000-FRMT-ENDPOINT      THRU 3000-EXIT               
      *                                                                         
A#5347     IF 1D-MTR-READ-SOURCE-CD = WS-MV90                           
A#5347        MOVE 1D-IDR-IDENT-NO       TO RS-ENDPOINT-ID              
A#5347     ELSE                                                         
A#5347        STRING WS-ENDPOINT-ID     DELIMITED BY SIZE               
A#5347               WS-ENDPT-MTR-TRGT  DELIMITED BY SIZE               
A#5347          INTO RS-ENDPOINT-ID                                     
A#5347        END-STRING                                                
A#5347     END-IF.                                                      
      *                                                                         
           MOVE 1D-DIGTL-MTR-TYPE       TO WS-DMT                       
           MOVE 1D-PROGRAM-ID           TO WS-PGM-ID                    
           MOVE WS-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE2           
           MOVE 1D-MTR-READ-SOURCE-CD   TO WS-MTR-RD-SRC                
           MOVE WS-METER-TYPE-ID        TO RS-METER-TYPE-ID             
      *                                                                         
           EVALUATE 1D-MTR-READ-SOURCE-CD                               
              WHEN 'P'                                                  
                 MOVE 'Openway'         TO RS-AMI-VENDOR                
              WHEN 'M'                                                  
A#5347           MOVE 'MV90'            TO RS-AMI-VENDOR                
              WHEN OTHER                                                
                 MOVE 'Unknown'         TO RS-AMI-VENDOR                
           END-EVALUATE                                                 
      *                                                                         
           MOVE 1D-CONSTANT             TO WS-CONSTANT-NUM              
                                           WS-CONSTANT-DEC              
           MOVE '.'                     TO WS-CONSTANT-DPOINT           
           MOVE WS-MTR-CONSTANT         TO RS-CONSTANT-KWH              
      *                                                                         
           IF 1D-METER-SUPPLYING = WS-OLD-METER-SUPPLYING               
              MOVE 1D-METER-SUPPLYING   TO RS-METER-SUPPLYING           
           ELSE                                                         
              IF 1D-METER-SUPPLYING > SPACES                            
                 MOVE 1D-METER-SUPPLYING TO RS-METER-SUPPLYING          
              ELSE                                                      
                 MOVE SPACES             TO RS-METER-SUPPLYING          
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           IF 1D-POINT-ID > SPACES                                      
              MOVE 1D-POINT-ID          TO RS-POINT-ID                  
           ELSE                                                         
              MOVE SPACES               TO RS-POINT-ID                  
           END-IF                                                       
      *                                                                         
           MOVE SPACES                   TO RD-RATE-PLAN-NO             
           MOVE 1D-RATE-PLAN-NO          TO RD-RATE-PLAN-NO             
           PERFORM 7500-GET-RATE-DESC       THRU 7500-EXIT              
           STRING 1D-RATE-PLAN-NO      DELIMITED BY SIZE                
                  ' - '                DELIMITED BY SIZE                
                  RD-RATE-DESC         DELIMITED BY '  '                
              INTO RS-RATE-PLAN-NO                                      
           END-STRING.                                                  
      *                                                                         
           MOVE 1D-CODE-REVENUE-CLASS   TO RS-REVENUE-CLASS             
      *                                                                         
A#5347     IF 1D-MTR-READ-SOURCE-CD = WS-MV90                           
              MOVE 1D-IDR-IDENT-NO      TO RS-RECORDER-ID               
           ELSE                                                         
ACT007        MOVE 1D-METER-NO(3:7)     TO RS-RECORDER-ID               
           END-IF                                                       
      *                                                                         
           MOVE 1D-ACCOUNT-NO           TO MN-ACCOUNT-NO                
           PERFORM 7260-GET-MTR-STATUS-DATES THRU 7260-EXIT             
           EVALUATE 1D-CODE-METER-STATUS                                
              WHEN 'J'                                                  
                 MOVE 'Inactive'        TO RS-METER-STATUS              
                 MOVE MN-METER-INACTIVE-DT  TO WS-MTR-STATUS-DT         
                 IF WS-MTR-STATUS-DT = SPACES                           
                    MOVE WS-CURR-DATE   TO WS-MTR-STATUS-DT             
                 END-IF                                                 
              WHEN 'K'                                                  
                 MOVE 'Inactive'        TO RS-METER-STATUS              
                 MOVE MN-METER-REMOVED-DT   TO WS-MTR-STATUS-DT         
                 IF WS-MTR-STATUS-DT = SPACES                           
                    MOVE WS-CURR-DATE   TO WS-MTR-STATUS-DT             
                 END-IF                                                 
              WHEN OTHER                                                
                 MOVE 'Active'          TO RS-METER-STATUS              
                 MOVE MN-MTR-STATUS-CHNG-DT TO WS-MTR-STATUS-DT         
           END-EVALUATE                                                 
                                                                        
           IF WS-MTR-STATUS-DT = SPACES                                 
              OR WS-MTR-STATUS-DT < MN-DATE-MTR-INSTALL                 
              MOVE MN-DATE-MTR-INSTALL  TO WS-MTR-STATUS-DT             
           END-IF                                                       
                                                                        
           IF 1D-CODE-METER-STATUS = WS-OLD-METER-STATUS                
              AND WS-MTR-ATTB-CHNG-DT > SPACES                          
              AND NOT METER-TYPE-CHANGED                                
              MOVE WS-MTR-ATTB-CHNG-DT  TO WS-MTR-STATUS-DT             
           END-IF                                                       
                                                                        
           MOVE WS-MTR-STATUS-DT        TO WS-HOLD-STATUS-DT            
           PERFORM 2910-FORMAT-METER-DATE   THRU 2910-EXIT              
           MOVE WS-FMT-CHNG-DTTM        TO RS-MTR-INSTALL-DTTM.         
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2700-OLD-ACCT-ENTITY-CHNG.                                       
      *================================================================*        
      *** CHANGES TO OLD ACCOUNT ENTITY IN MDM (FOR FINAL ACCOUNTS)             
      *                                                                         
           INITIALIZE WS-OLD-ACCT-AREA                                  
                      WS-HOLD-STATUS-DT.                                
      *                                                                         
           MOVE WS-OLD-ACCOUNT-NO       TO RS-ACCOUNT-NO                
                                           AT-ACCOUNT-NO                
                                           CH-ACCOUNT-NO                
           MOVE WS-PREMISE-NO           TO RS-PREMISE-NO                
           MOVE ZEROS                   TO CH-CUSTOMER-NO               
           PERFORM 7250-GET-SERVICE-DATES THRU 7250-EXIT                
           MOVE CH-CUSTOMER-NO          TO WS-OLD-CUSTOMER-NO           
           MOVE 'Final'                 TO WS-OLD-ACCT-STATUS           
           MOVE CH-DATE-UTIL-SVC-END    TO WS-ACC-STATUS-DT             
           IF WS-ACC-STATUS-DT = SPACES                                 
              MOVE WS-CURR-DATE         TO WS-ACC-STATUS-DT             
           END-IF                                                       
                                                                        
           MOVE WS-ACC-STATUS-DT         TO WS-HOLD-STATUS-DT           
           PERFORM 2900-FORMAT-STATUS-DATES THRU 2900-EXIT              
           MOVE WS-FMT-CHNG-DTTM         TO WS-OLD-ACC-STATUS-DT        
      *                                                                         
           PERFORM 3800-GET-NAME-ADDRESS   THRU 3800-EXIT               
           MOVE WS-CUST-NAME            TO WS-OLD-CUST-NAME.            
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2800-OLD-MTR-ENTITY-CHNG.                                        
      *================================================================*        
      *** CHANGES TO OLD METER ENTITY IN MDM (FOR REMOVED METERS)               
      *                                                                         
           INITIALIZE WS-TEMP-WORK-AREA                                 
                      WS-HOLD-STATUS-DT                                 
                      WS-HOLD-MTR-STATUS-DT                             
                      WS-ENDPT-MTR-SRC.                                 
                                                                        
           MOVE 1D-SERVICE-POINT-ID     TO RS-SERVICE-POINT-ID          
           MOVE WS-COMPANY-NO           TO WS-COMPANY-NO1               
           MOVE WS-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE1           
           MOVE WS-OLD-METER-NO         TO WS-METER-NO1                 
                                           WS-ENDPT-MTR-SRC             
           MOVE WS-METER-ID             TO WS-OLD-METER-ID              
                                                                        
           PERFORM 3000-FRMT-ENDPOINT      THRU 3000-EXIT               
      *                                                                         
A#5347     IF WS-OLD-MRS-CD-SW = WS-MV90                                
A#5347        MOVE WS-OLD-IDR-IDENT-NO   TO WS-OLD-ENDPOINT-ID          
A#5347     ELSE                                                         
A#5347        STRING WS-ENDPOINT-ID      DELIMITED BY SIZE              
A#5347               WS-ENDPT-MTR-TRGT   DELIMITED BY SIZE              
A#5347          INTO WS-OLD-ENDPOINT-ID                                 
A#5347        END-STRING                                                
A#5347     END-IF.                                                      
      *                                                                         
           MOVE WS-OLD-DIGTL-MTR-TYPE   TO WS-DMT                       
           MOVE WS-OLD-PROGRAM-ID       TO WS-PGM-ID                    
           MOVE WS-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE2           
           MOVE WS-OLD-MRS-CD-SW        TO WS-MTR-RD-SRC                
           MOVE WS-METER-TYPE-ID        TO WS-OLD-METER-TYPE-ID         
      *                                                                         
           EVALUATE WS-OLD-MRS-CD-SW                                    
              WHEN 'P'                                                  
                 MOVE 'Openway'         TO WS-OLD-AMI-VENDOR            
              WHEN 'M'                                                  
A#5347           MOVE 'MV90'            TO WS-OLD-AMI-VENDOR            
              WHEN OTHER                                                
                 MOVE 'Unknown'         TO WS-OLD-AMI-VENDOR            
           END-EVALUATE                                                 
      *                                                                         
           MOVE WS-OLD-CONSTANT         TO WS-CONSTANT-NUM              
                                           WS-CONSTANT-DEC              
           MOVE '.'                     TO WS-CONSTANT-DPOINT           
           MOVE WS-MTR-CONSTANT         TO WS-OLD-CONSTANT-KWH          
      *                                                                         
           MOVE WS-OLD-CODE-REVENUE-CLASS TO WS-OLD-REVENUE-CLASS       
      *                                                                         
           MOVE WS-OLD-ACCOUNT-NO       TO MN-ACCOUNT-NO                
           PERFORM 7260-GET-MTR-STATUS-DATES THRU 7260-EXIT             
                                                                        
           EVALUATE WS-OLD-METER-STATUS                                 
              WHEN 'J'                                                  
                 MOVE 'Inactive'        TO WS-OLD-MTR-STATUS            
                 MOVE MN-METER-INACTIVE-DT  TO WS-HOLD-MTR-STATUS-DT    
              WHEN 'K'                                                  
                 MOVE 'Inactive'        TO WS-OLD-MTR-STATUS            
                 MOVE MN-METER-REMOVED-DT   TO WS-HOLD-MTR-STATUS-DT    
              WHEN OTHER                                                
                 MOVE 'Active'          TO WS-OLD-MTR-STATUS            
                 MOVE MN-MTR-STATUS-CHNG-DT TO WS-HOLD-MTR-STATUS-DT    
           END-EVALUATE                                                 
                                                                        
           IF WS-HOLD-MTR-STATUS-DT > SPACES                            
              MOVE WS-HOLD-MTR-STATUS-DT TO WS-MTR-STATUS-DT            
           ELSE                                                         
              MOVE WS-CURR-DATE         TO WS-MTR-STATUS-DT             
           END-IF                                                       
                                                                        
           MOVE WS-MTR-STATUS-DT        TO WS-HOLD-STATUS-DT            
           PERFORM 2910-FORMAT-METER-DATE  THRU 2910-EXIT               
           MOVE WS-FMT-CHNG-DTTM        TO WS-OLD-MTR-INS-DTTM          
      *                                                                         
A#5347     IF WS-OLD-MRS-CD-SW = WS-MV90                                
              MOVE WS-OLD-IDR-IDENT-NO  TO WS-OLD-RECORDER-ID           
           ELSE                                                         
ACT007        MOVE WS-OLD-METER-NO(3:7) TO WS-OLD-RECORDER-ID           
           END-IF.                                                      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2900-FORMAT-STATUS-DATES.                                        
      *================================================================*        
      *** FORMAT DATES AS PER MDM DATE & TIME FORMATS                           
      *                                                                         
           INITIALIZE WS-STATUS-DTTM2                                   
                      WS-FMT-CHNG-DTTM                                  
A#5347     IF WS-HOLD-STATUS-DT < WS-MDMS-LOW-DATE                      
A#5347        MOVE WS-MDMS-LOW-DATE     TO WS-HOLD-STATUS-DT            
A#5347     END-IF                                                       
           MOVE WS-HOLD-STATUS-DT     TO WS-STATUS-DATE1                
           MOVE WS-STATUS-YYYY1       TO WS-STATUS-YYYY2                
           MOVE WS-STATUS-MM1         TO WS-STATUS-MM2                  
           MOVE WS-STATUS-DD1         TO WS-STATUS-DD2                  
           MOVE '00'                  TO WS-STATUS-HH2                  
           MOVE '00'                  TO WS-STATUS-MI2                  
           MOVE '00'                  TO WS-STATUS-SS2                  
           MOVE WS-STATUS-DTTM2       TO WS-FMT-CHNG-DTTM.              
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2910-FORMAT-METER-DATE.                                          
      *================================================================*        
      *** FORMAT DATES AS PER MDM DATE & TIME FORMATS                           
      *                                                                         
           INITIALIZE WS-STATUS-DTTM2                                   
                      WS-FMT-CHNG-DTTM                                  
A#5347     IF WS-HOLD-STATUS-DT < WS-MDMS-LOW-DATE                      
A#5347        MOVE WS-MDMS-LOW-DATE     TO WS-HOLD-STATUS-DT            
A#5347     END-IF                                                       
           MOVE WS-HOLD-STATUS-DT     TO WS-STATUS-DATE1                
           MOVE WS-STATUS-YYYY1       TO WS-STATUS-YYYY2                
           MOVE WS-STATUS-MM1         TO WS-STATUS-MM2                  
           MOVE WS-STATUS-DD1         TO WS-STATUS-DD2                  
           MOVE MN-LAST-VALID-READ-TM(1:2) TO WS-STATUS-HH2             
           MOVE MN-LAST-VALID-READ-TM(4:2) TO WS-STATUS-MI2             
           MOVE MN-LAST-VALID-READ-TM(7:2) TO WS-STATUS-SS2             
           MOVE WS-STATUS-DTTM2       TO WS-FMT-CHNG-DTTM.              
      *                                                                         
       2910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3000-FRMT-ENDPOINT.                                              
      *================================================================*        
      *** TO GET NAME & ADDRESS                                                 
      *                                                                         
           MOVE SPACES                    TO WS-ENDPT-MTR-TRGT          
           MOVE ZERO                      TO WS-LZERO-CNT               
                                             WS-EPM-COUNT               
                                                                        
           INSPECT WS-ENDPT-MTR-SRC TALLYING WS-LZERO-CNT               
               FOR LEADING ZEROES                                       
           COMPUTE WS-EPM-COUNT = 9 - WS-LZERO-CNT                      
                                                                        
           MOVE WS-ENDPT-MTR-SRC(WS-LZERO-CNT + 1 : WS-EPM-COUNT)       
             TO WS-ENDPT-MTR-TRGT.                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3800-GET-NAME-ADDRESS.                                           
      *================================================================*        
      *** TO GET NAME & ADDRESS                                                 
      *                                                                         
           MOVE SPACES                    TO WS-CUST-NAME.              
           SET WS-NAME-ONLY               TO TRUE.                      
           PERFORM 4000-MAIL-NAME-ADDRESS     THRU 4000-EXIT.           
           MOVE 'N'                       TO WS-NAME-ONLY-SW.           
           INSPECT WS-CUSTOMER-NAME  REPLACING ALL ',' BY ' '.          
           MOVE WS-CUSTOMER-NAME          TO WS-CUST-NAME.              
           MOVE SPACES                    TO WS-DBA-NAME                
      *                                                                         
           PERFORM VARYING WS-NAME-INDX FROM 1 BY 1                     
                                   UNTIL WS-NAME-INDX > 5               
                OR WS-NAME-ENTRY (WS-NAME-INDX) = SPACES                
              IF WS-NAME-TYPE (WS-NAME-INDX) = 'DB'                     
                 MOVE WS-NAME (WS-NAME-INDX) TO WS-DBA-NAME             
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           MOVE ZERO                      TO AT-ADDRESS-ID.             
           MOVE SPACES                    TO WS-PR-STREET               
                                             WS-PR-ADDR-OVERFLOW        
                                             WS-PR-ADDR-CITY-STATE      
                                             WS-CITY                    
                                             WS-STATE                   
                                             WS-ZIP                     
      *                                                                         
           PERFORM 4025-DETERMINE-ADDRESS     THRU 4025-EXIT.           
      *                                                                         
           INSPECT WS-CUST-NAME REPLACING ALL ',' BY ' '.               
           IF WS-DBA-NAME > SPACES                                      
              INSPECT WS-DBA-NAME REPLACING ALL ',' BY ' '              
           END-IF.                                                      
           INSPECT WS-PR-STREET REPLACING ALL ',' BY ' '.               
           IF WS-PR-ADDR-OVERFLOW > SPACES                              
              INSPECT WS-PR-ADDR-OVERFLOW REPLACING ALL ',' BY ' '      
           END-IF.                                                      
           INSPECT WS-CITY REPLACING ALL ',' BY ' '.                    
           INSPECT WS-STATE REPLACING ALL ',' BY ' '.                   
      *                                                                         
       3800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3900-FORMAT-NEW-SERVICE.                                         
      *================================================================*        
      *** FORMAT CIS DATA RECORD                                                
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           SET NEW-SERVICE TO TRUE                                      
           MOVE WS-TRANSACTION-TYPE       TO RS-RECORD-TYPE             
      *                                                                         
           STRING S-RECORD-TYPE           DELIMITED BY '   '            
                  ','                                                   
                  S-ACCOUNT-NO            DELIMITED BY '   '            
                  ','                                                   
                  S-SERVICE-POINT-ID      DELIMITED BY '   '            
                  ','                                                   
                  S-PREMISE-NO            DELIMITED BY '   '            
                  ','                                                   
                  S-CUSTOMER-NO           DELIMITED BY '   '            
                  ','                                                   
                  S-ACCT-STATUS           DELIMITED BY '   '            
                  ','                                                   
                  S-READ-CYCLE            DELIMITED BY '   '            
                  ','                                                   
                  S-LOC-OFFICE            DELIMITED BY '   '            
                  ','                                                   
                  S-RATE-PLAN-NO          DELIMITED BY '   '            
                  ','                                                   
                  S-CUST-NAME             DELIMITED BY '   '            
                  ','                                                   
A#5347            S-CUST-EST-DTTM         DELIMITED BY '   '            
A#5347            ','                                                   
                  S-SVC-ADDR-1            DELIMITED BY '   '            
                  ','                                                   
                  S-SVC-ADDR-OVERFLOW     DELIMITED BY '   '            
                  ','                                                   
                  S-SVC-CITY              DELIMITED BY '   '            
                  ','                                                   
                  S-SVC-STATE             DELIMITED BY '   '            
                  ','                                                   
                  S-SVC-ZIP               DELIMITED BY '   '            
                  ','                                                   
                  S-ACCT-CHNG-DTTM        DELIMITED BY '   '            
                  ','                                                   
                  S-METER-ID              DELIMITED BY '   '            
                  ','                                                   
                  S-METER-NO              DELIMITED BY '   '            
                  ','                                                   
                  S-METER-TYPE-ID         DELIMITED BY '   '            
                  ','                                                   
                  S-AMI-VENDOR            DELIMITED BY '   '            
                  ','                                                   
                  S-CONSTANT-KWH          DELIMITED BY '   '            
                  ','                                                   
                  S-METER-STATUS          DELIMITED BY '   '            
                  ','                                                   
                  S-METER-SUPPLYING       DELIMITED BY '   '            
                  ','                                                   
                  S-POINT-ID              DELIMITED BY '   '            
                  ','                                                   
                  S-REVENUE-CLASS         DELIMITED BY '   '            
                  ','                                                   
                  S-RECORDER-ID           DELIMITED BY '   '            
                  ','                                                   
                  S-ENDPOINT-ID           DELIMITED BY '   '            
                  ','                                                   
                  S-MTR-INSTALL-DTTM      DELIMITED BY '   '            
                  ','                                                   
                  S-DBA-NAME              DELIMITED BY '   '            
                  ','                                                   
                  S-MTR-LATITUDE          DELIMITED BY '   '            
                  ','                                                   
                  S-MTR-LONGITUDE         DELIMITED BY '   '            
              INTO FIOBW60                                              
           END-STRING                                                   
      *                                                                         
           PERFORM 8000-WRITE-FIOBW60        THRU 8000-EXIT.            
      *                                                                         
       3900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3910-FORMAT-ACCOUNT-CHG.                                         
      *================================================================*        
      *** FORMAT CIS DATA RECORD (ACCOUNT CHANGE/CUSTOMER CHANGE)               
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           IF RS-CUSTOMER-NO NOT = WS-OLD-CUSTOMER-NO                   
              SET CUSTOMER-CHANGE TO TRUE                               
              MOVE WS-TRANSACTION-TYPE    TO RS-RECORD-TYPE             
              STRING S-RECORD-TYPE        DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-ACCOUNT-NO    DELIMITED BY '   '            
                      ','                                               
                     S-SERVICE-POINT-ID   DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-CUSTOMER-NO   DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-ACCT-STATUS   DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-CUST-NAME     DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-ACC-STATUS-DT DELIMITED BY '   '            
                      ','                                               
                     S-ACCOUNT-NO         DELIMITED BY '   '            
                      ','                                               
                     S-CUSTOMER-NO        DELIMITED BY '   '            
                      ','                                               
                     S-ACCT-STATUS        DELIMITED BY '   '            
                      ','                                               
                     S-CUST-NAME          DELIMITED BY '   '            
                     ','                                                
A#5347               S-CUST-EST-DTTM      DELIMITED BY '   '            
A#5347               ','                                                
                     S-ACCT-CHNG-DTTM     DELIMITED BY '   '            
                     ','                                                
                     S-DBA-NAME           DELIMITED BY '   '            
                     INTO FIOBW60                                       
              END-STRING                                                
           ELSE                                                         
              SET ACCOUNT-CHANGE TO TRUE                                
              MOVE WS-TRANSACTION-TYPE    TO RS-RECORD-TYPE             
              STRING S-RECORD-TYPE        DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-ACCOUNT-NO    DELIMITED BY '   '            
                      ','                                               
                     S-SERVICE-POINT-ID   DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-ACCT-STATUS   DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-ACC-STATUS-DT DELIMITED BY '   '            
                      ','                                               
                     S-ACCOUNT-NO         DELIMITED BY '   '            
SS9585                ','                                               
SS9585               S-SERVICE-POINT-ID   DELIMITED BY '   '            
                      ','                                               
                     S-ACCT-STATUS        DELIMITED BY '   '            
                      ','                                               
                     S-ACCT-CHNG-DTTM     DELIMITED BY '   '            
                     INTO FIOBW60                                       
              END-STRING                                                
           END-IF                                                       
      *                                                                         
           PERFORM 8000-WRITE-FIOBW60       THRU 8000-EXIT.             
      *                                                                         
       3910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3920-FORMAT-RATE-CHG.                                            
      *================================================================*        
      *** FORMAT CIS DATA RECORD (RATE CHANGE)                                  
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           IF (1D-RATE-PLAN-NO NOT = WS-OLD-RATE-PLAN-NO) OR            
              (1D-CODE-REVENUE-CLASS NOT = WS-OLD-CODE-REVENUE-CLASS)   
              SET RATE-CHANGE TO TRUE                                   
              MOVE WS-TRANSACTION-TYPE    TO RS-RECORD-TYPE             
              STRING S-RECORD-TYPE        DELIMITED BY '   '            
                      ','                                               
                     S-SERVICE-POINT-ID   DELIMITED BY '   '            
                      ','                                               
                     S-METER-ID           DELIMITED BY '   '            
                      ','                                               
                     S-RATE-PLAN-NO       DELIMITED BY '   '            
                      ','                                               
                     S-REVENUE-CLASS      DELIMITED BY '   '            
                      ','                                               
                     S-ENDPOINT-ID        DELIMITED BY '   '            
                      ','                                               
                     WS-ACCT-CHNG-DTTM    DELIMITED BY '   '            
                     INTO FIOBW60                                       
              END-STRING                                                
              PERFORM 8000-WRITE-FIOBW60     THRU 8000-EXIT             
           END-IF.                                                      
      *                                                                         
       3920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3925-FORMAT-RDCYC-LO-CHG.                                        
      *================================================================*        
      *** FORMAT CIS DATA RECORD (READ CYCLE/LOCAL OFFICE)                      
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           IF 1D-READ-CYCLE NOT = WS-OLD-READ-CYCLE                     
              SET READ-CYCLE-CHANGE TO TRUE                             
              MOVE WS-TRANSACTION-TYPE    TO RS-RECORD-TYPE             
              STRING S-RECORD-TYPE        DELIMITED BY '   '            
                      ','                                               
                     S-SERVICE-POINT-ID   DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-READ-CYCLE    DELIMITED BY '   '            
                      ','                                               
                     S-ENDPOINT-ID        DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-ACC-STATUS-DT DELIMITED BY '   '            
                      ','                                               
                     S-READ-CYCLE         DELIMITED BY '   '            
                      ','                                               
                     WS-ACCT-CHNG-DTTM    DELIMITED BY '   '            
                     INTO FIOBW60                                       
              END-STRING                                                
              PERFORM 8000-WRITE-FIOBW60     THRU 8000-EXIT             
           END-IF                                                       
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           IF 1D-LOCAL-OFFICE NOT = WS-OLD-LOCAL-OFFICE                 
              SET LOCAL-OFFICE-CHANGE TO TRUE                           
              MOVE WS-TRANSACTION-TYPE    TO RS-RECORD-TYPE             
              STRING S-RECORD-TYPE        DELIMITED BY '   '            
                      ','                                               
                     S-SERVICE-POINT-ID   DELIMITED BY '   '            
                      ','                                               
                     S-LOC-OFFICE         DELIMITED BY '   '            
                      ','                                               
                     WS-ACCT-CHNG-DTTM    DELIMITED BY '   '            
                     INTO FIOBW60                                       
              END-STRING                                                
              PERFORM 8000-WRITE-FIOBW60     THRU 8000-EXIT             
           END-IF.                                                      
      *                                                                         
       3925-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3930-FORMAT-METER-CHG.                                           
      *================================================================*        
      *** FORMAT CIS DATA RECORD (METER CHANGE-LIKE/NON-LIKE/RE-PROGRAM)        
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           IF 1D-METER-NO NOT = WS-OLD-METER-NO                         
              IF METER-TYPE-CHANGED                                     
                 SET METER-EXCHANGE-NON-LIKE TO TRUE                    
              ELSE                                                      
                 SET METER-EXCHANGE-LIKE TO TRUE                        
              END-IF                                                    
              MOVE WS-TRANSACTION-TYPE    TO RS-RECORD-TYPE             
              STRING S-RECORD-TYPE        DELIMITED BY '   '            
                      ','                                               
                     S-SERVICE-POINT-ID   DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-METER-ID      DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-METER-NO      DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-METER-TYPE-ID DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-CONSTANT-KWH  DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-MTR-STATUS    DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-POINT-ID      DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-RECORDER-ID   DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-AMI-VENDOR    DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-REVENUE-CLASS DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-ENDPOINT-ID   DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-READ-CYCLE    DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-MTR-INS-DTTM  DELIMITED BY '   '            
                      ','                                               
                     S-METER-ID           DELIMITED BY '   '            
                      ','                                               
                     S-METER-NO           DELIMITED BY '   '            
                      ','                                               
                     S-METER-TYPE-ID      DELIMITED BY '   '            
                      ','                                               
                     S-CONSTANT-KWH       DELIMITED BY '   '            
                      ','                                               
                     S-METER-STATUS       DELIMITED BY '   '            
                      ','                                               
                     S-POINT-ID           DELIMITED BY '   '            
                      ','                                               
                     S-RECORDER-ID        DELIMITED BY '   '            
                      ','                                               
                     S-AMI-VENDOR         DELIMITED BY '   '            
                      ','                                               
                     S-REVENUE-CLASS      DELIMITED BY '   '            
                      ','                                               
                     S-ENDPOINT-ID        DELIMITED BY '   '            
                      ','                                               
                     S-READ-CYCLE         DELIMITED BY '   '            
                      ','                                               
                     S-MTR-INSTALL-DTTM   DELIMITED BY '   '            
                      ','                                               
                     WS-OLD-ACCOUNT-NO-AN DELIMITED BY '   '            
                      ','                                               
                     S-ACCT-CHNG-DTTM     DELIMITED BY '   '            
                     INTO FIOBW60                                       
              END-STRING                                                
              PERFORM 8000-WRITE-FIOBW60        THRU 8000-EXIT          
           ELSE                                                         
              PERFORM 3995-FORMAT-MTR-REPROGRAM THRU 3995-EXIT          
           END-IF.                                                      
      *                                                                         
       3930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3940-FORMAT-REMOVE-MTR.                                          
      *================================================================*        
      *** FORMAT CIS DATA RECORD (METER REMOVE)                                 
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           SET REMOVE-METER TO TRUE                                     
           MOVE WS-TRANSACTION-TYPE       TO RS-RECORD-TYPE             
                                                                        
           STRING S-RECORD-TYPE           DELIMITED BY '   '            
                   ','                                                  
                  WS-OLD-METER-ID         DELIMITED BY '   '            
                   ','                                                  
                  WS-OLD-ENDPOINT-ID      DELIMITED BY '  '             
                   ','                                                  
                  WS-OLD-MTR-INS-DTTM     DELIMITED BY '   '            
                      ','                                               
                  WS-OLD-METER-TYPE-ID    DELIMITED BY '   '            
A#5347                ','                                               
A#5347            S-SERVICE-POINT-ID      DELIMITED BY '   '            
             INTO FIOBW60                                               
           END-STRING.                                                  
      *                                                                         
           PERFORM 8000-WRITE-FIOBW60        THRU 8000-EXIT.            
      *                                                                         
       3940-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3950-FORMAT-PTID-MTRSUP.                                         
      *================================================================*        
      *** FORMAT CIS DATA RECORD (POINT ID/ METER SUPPLY)                       
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           IF 1D-POINT-ID NOT = WS-OLD-POINT-ID                         
              SET POINT-ID-CHANGE TO TRUE                               
              MOVE WS-TRANSACTION-TYPE    TO RS-RECORD-TYPE             
              STRING S-RECORD-TYPE        DELIMITED BY '   '            
                      ','                                               
                     S-METER-ID           DELIMITED BY '   '            
                      ','                                               
                     S-POINT-ID           DELIMITED BY '   '            
                      ','                                               
                     S-ENDPOINT-ID        DELIMITED BY '   '            
                      ','                                               
                     S-MTR-INSTALL-DTTM   DELIMITED BY '   '            
                     INTO FIOBW60                                       
              END-STRING                                                
              PERFORM 8000-WRITE-FIOBW60     THRU 8000-EXIT             
           END-IF                                                       
      *                                                                         
           IF 1D-METER-SUPPLYING NOT = WS-OLD-METER-SUPPLYING           
              MOVE SPACES                 TO FIOBW60                    
              SET METER-SUPPLY-CHANGE TO TRUE                           
              MOVE WS-TRANSACTION-TYPE    TO RS-RECORD-TYPE             
              STRING S-RECORD-TYPE        DELIMITED BY '   '            
                      ','                                               
                     S-METER-ID           DELIMITED BY '   '            
                      ','                                               
                     S-METER-SUPPLYING    DELIMITED BY '   '            
                      ','                                               
                     S-ENDPOINT-ID        DELIMITED BY '   '            
                      ','                                               
                     S-MTR-INSTALL-DTTM   DELIMITED BY '   '            
                     INTO FIOBW60                                       
              END-STRING                                                
              PERFORM 8000-WRITE-FIOBW60     THRU 8000-EXIT             
           END-IF.                                                      
      *                                                                         
       3950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3960-FORMAT-ADDRESS-CHG.                                         
      *================================================================*        
      *** FORMAT CIS DATA RECORD (ADDRESS CHANGE)                               
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           SET ADDRESS-CHANGE TO TRUE                                   
           MOVE WS-TRANSACTION-TYPE       TO RS-RECORD-TYPE             
      *                                                                         
           STRING S-RECORD-TYPE           DELIMITED BY '   '            
                   ','                                                  
                  S-SERVICE-POINT-ID      DELIMITED BY '   '            
                   ','                                                  
                  S-SVC-ADDR-1            DELIMITED BY '   '            
                   ','                                                  
                  S-SVC-ADDR-OVERFLOW     DELIMITED BY '   '            
                   ','                                                  
                  S-SVC-CITY              DELIMITED BY '   '            
                   ','                                                  
                  S-SVC-STATE             DELIMITED BY '   '            
                    ','                                                 
                  S-SVC-ZIP               DELIMITED BY '   '            
             INTO FIOBW60                                               
           END-STRING                                                   
                                                                        
           PERFORM 8000-WRITE-FIOBW60        THRU 8000-EXIT.            
      *                                                                         
       3960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3970-FORMAT-NAME-CHG.                                            
      *================================================================*        
      *** FORMAT CIS DATA RECORD (NAME CHANGE)                                  
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           SET NAME-CHANGE TO TRUE                                      
           MOVE WS-TRANSACTION-TYPE       TO RS-RECORD-TYPE             
      *                                                                         
           STRING S-RECORD-TYPE           DELIMITED BY '   '            
                   ','                                                  
                  S-CUSTOMER-NO           DELIMITED BY '   '            
                    ','                                                 
                  S-CUST-NAME             DELIMITED BY '   '            
                     ','                                                
                  S-DBA-NAME              DELIMITED BY '   '            
                     ','                                                
                  S-ACCOUNT-NO            DELIMITED BY '   '            
A#5347                ','                                               
A#5347            S-SERVICE-POINT-ID      DELIMITED BY '   '            
             INTO FIOBW60                                               
           END-STRING                                                   
                                                                        
           PERFORM 8000-WRITE-FIOBW60        THRU 8000-EXIT.            
      *                                                                         
       3970-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3980-FORMAT-MTR-STAT-CHG.                                        
      *================================================================*        
      *** FORMAT CIS DATA RECORD (METER STATUS CHANGE)                          
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           SET METER-STATUS TO TRUE                                     
           MOVE WS-TRANSACTION-TYPE       TO RS-RECORD-TYPE             
      *                                                                         
           STRING S-RECORD-TYPE           DELIMITED BY '   '            
                   ','                                                  
                  WS-OLD-METER-ID         DELIMITED BY '   '            
                   ','                                                  
                  WS-OLD-MTR-STATUS       DELIMITED BY '   '            
                   ','                                                  
                  WS-OLD-MTR-INS-DTTM     DELIMITED BY '   '            
             INTO FIOBW60                                               
           END-STRING                                                   
                                                                        
           PERFORM 8000-WRITE-FIOBW60        THRU 8000-EXIT.            
      *                                                                         
       3980-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3990-FORMAT-ACCT-STAT-CHG.                                       
      *================================================================*        
      *** FORMAT CIS DATA RECORD (ACCOUNT STATUS CHANGE)                        
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           SET ACCOUNT-STATUS TO TRUE                                   
           MOVE WS-TRANSACTION-TYPE       TO RS-RECORD-TYPE             
      *                                                                         
           STRING S-RECORD-TYPE           DELIMITED BY '   '            
                   ','                                                  
                  WS-OLD-ACCOUNT-NO       DELIMITED BY '   '            
                   ','                                                  
                  WS-OLD-ACCT-STATUS      DELIMITED BY '   '            
                   ','                                                  
                  WS-OLD-ACC-STATUS-DT    DELIMITED BY '   '            
             INTO FIOBW60                                               
           END-STRING                                                   
                                                                        
           PERFORM 8000-WRITE-FIOBW60        THRU 8000-EXIT.            
      *                                                                         
       3990-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3995-FORMAT-MTR-REPROGRAM.                                       
      *================================================================*        
      *** FORMAT CIS DATA RECORD (METER REPROGRAM)                              
      *                                                                         
           MOVE SPACES                    TO FIOBW60                    
      *                                                                         
           SET METER-REPROGRAM TO TRUE                                  
           MOVE WS-TRANSACTION-TYPE    TO RS-RECORD-TYPE                
           STRING S-RECORD-TYPE        DELIMITED BY '   '               
                   ','                                                  
                  S-SERVICE-POINT-ID   DELIMITED BY '   '               
                   ','                                                  
                  S-METER-ID           DELIMITED BY '   '               
                   ','                                                  
                  S-METER-NO           DELIMITED BY '   '               
                   ','                                                  
                  S-METER-TYPE-ID      DELIMITED BY '   '               
                   ','                                                  
                  S-CONSTANT-KWH       DELIMITED BY '   '               
                   ','                                                  
                  S-RECORDER-ID        DELIMITED BY '   '               
                   ','                                                  
                  S-ENDPOINT-ID        DELIMITED BY '   '               
                   ','                                                  
                  S-READ-CYCLE         DELIMITED BY '   '               
                   ','                                                  
                  S-MTR-INSTALL-DTTM   DELIMITED BY '   '               
                   ','                                                  
                  WS-OLD-ACCOUNT-NO-AN DELIMITED BY '   '               
                   ','                                                  
                  S-ACCT-CHNG-DTTM     DELIMITED BY '   '               
                  INTO FIOBW60                                          
           END-STRING                                                   
      *                                                                         
           PERFORM 8000-WRITE-FIOBW60        THRU 8000-EXIT.            
      *                                                                         
       3995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      ** 4000-MAIL-NAME-ADDRESS.                                                
      *================================================================*        
      **** INCLUDE COPY BOOK TO RETRIEVE NAMES AND ADDRESSES     **             
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       5100-PROCESS-PREM-CSR.                                           
      *================================================================*        
      *                                                                         
           MOVE 'N'                         TO WS-ADDR-CHG-SW           
                                               WS-NAME-CHG-SW           
      *                                                                         
           MOVE 1D-SERVICE-POINT-ID         TO WS-SERVICE-POINT-ID      
                                               RS-SERVICE-POINT-ID      
           MOVE WS-PREMISE-NO               TO MH-PREMISE-NO            
      *                                                                         
           MOVE 1D-ACCOUNT-NO               TO CH-ACCOUNT-NO            
                                               MH-ACCOUNT-NO            
                                               RS-ACCOUNT-NO            
           PERFORM 7250-GET-SERVICE-DATES      THRU 7250-EXIT           
           MOVE CH-CUSTOMER-NO              TO RS-CUSTOMER-NO           
                                               MH-CUSTOMER-NO           
      *                                                                         
           PERFORM 7310-OPEN-GET-ADDR-CSR      THRU 7310-EXIT           
           PERFORM 7320-FETCH-GET-ADDR-CSR     THRU 7320-EXIT           
           PERFORM 5200-TRACK-ADDR-CHNG        THRU 5200-EXIT           
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
           PERFORM 7330-CLOSE-GET-ADDR-CSR     THRU 7330-EXIT           
                                                                        
           IF ADDRESS-CHANGED                                           
              PERFORM 6000-FORMAT-NAME-ADDRESS THRU 6000-EXIT           
              PERFORM 3960-FORMAT-ADDRESS-CHG  THRU 3960-EXIT           
           END-IF                                                       
      *                                                                         
           IF NAME-CHANGED                                              
              PERFORM 6000-FORMAT-NAME-ADDRESS THRU 6000-EXIT           
              PERFORM 3970-FORMAT-NAME-CHG     THRU 3970-EXIT           
           END-IF.                                                      
      *                                                                         
           PERFORM 7720-FETCH-SP-PREM-CSR      THRU 7720-EXIT.          
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       5200-TRACK-ADDR-CHNG.                                            
      *================================================================*        
      *                                                                         
           IF MI-COLUMN-DESC = 'NEW PREMISE'                            
              MOVE 'N'       TO WS-ADDR-CHG-SW                          
                                WS-NAME-CHG-SW                          
              MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE                   
              GO TO 5200-EXIT                                           
           END-IF                                                       
      *                                                                         
           IF MI-COLUMN-DESC = 'BUSINESS NAME' OR 'DBA NAME'            
              SET NAME-CHANGED    TO TRUE                               
           ELSE                                                         
              SET ADDRESS-CHANGED TO TRUE                               
           END-IF                                                       
      *                                                                         
           PERFORM 7320-FETCH-GET-ADDR-CSR     THRU 7320-EXIT.          
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6000-FORMAT-NAME-ADDRESS.                                        
      *================================================================*        
      *                                                                         
           MOVE 1D-ACCOUNT-NO              TO AT-ACCOUNT-NO.            
      *                                                                         
           PERFORM 3800-GET-NAME-ADDRESS      THRU 3800-EXIT.           
      *                                                                         
           MOVE SPACES                     TO RS-CUST-NAME              
           MOVE WS-CUST-NAME               TO RS-CUST-NAME              
      *                                                                         
           MOVE SPACES                     TO RS-DBA-NAME               
           IF WS-DBA-NAME > SPACES                                      
              MOVE WS-DBA-NAME(5:)         TO RS-DBA-NAME               
           END-IF.                                                      
                                                                        
           IF WS-PR-STREET > SPACES                                     
              MOVE WS-PR-STREET            TO RS-SVC-ADDR-1             
           ELSE                                                         
              MOVE ' '                     TO RS-SVC-ADDR-1             
           END-IF                                                       
           IF WS-PR-ADDR-OVERFLOW > SPACES                              
              MOVE WS-PR-ADDR-OVERFLOW     TO RS-SVC-ADDR-OVERFLOW      
           ELSE                                                         
              MOVE ' '                     TO RS-SVC-ADDR-OVERFLOW      
           END-IF                                                       
                                                                        
           IF WS-CITY > SPACES                                          
              MOVE WS-CITY       TO RS-SVC-CITY                         
           ELSE                                                         
              MOVE ' '                     TO RS-SVC-CITY               
           END-IF                                                       
           IF WS-STATE > SPACES                                         
              MOVE WS-STATE      TO RS-SVC-STATE                        
           ELSE                                                         
              MOVE ' '                     TO RS-SVC-STATE              
           END-IF                                                       
           IF WS-ZIP > SPACES                                           
              MOVE WS-ZIP                  TO RS-SVC-ZIP                
           ELSE                                                         
              MOVE ' '                     TO RS-SVC-ZIP                
           END-IF.                                                      
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
      ** 6010-REDUCE-EMBEDDED-SPACES.                                           
      *================================================================*        
       COPY CPD00004.                                                           
      *                                                                         
      *================================================================*        
       7100-GET-INTF-DETAILS.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             SELECT [1D].ACCOUNT_NO                                       
                   ,[1D].METER_NO                                         
                   ,[1D].CODE_ACCT_STAT                                   
                   ,[1D].CODE_METER_STATUS                                
                   ,[1D].MTR_SERIAL_NO                                    
                   ,[1D].DEVICE_NO                                        
                   ,[1D].LOCAL_OFFICE                                     
                   ,[1D].READ_ROUTE                                       
                   ,[1D].READ_CYCLE                                       
                   ,[1D].CODE_REVENUE_CLASS                               
                   ,[1D].RATE_PLAN_NO                                     
                   ,[1D].DIGTL_MTR_TYPE                                   
                   ,[1D].PROGRAM_ID                                       
                   ,[1D].REMOTE_READ_IND                                  
                   ,[1D].MTR_READ_SOURCE_CD                               
                   ,[1D].CONSTANT                                         
                   ,[1D].POINT_ID                                         
                   ,[1D].IDR_IDENT_NO                                     
                   ,[1D].ELEC_MTR_CLASS_CD                                
                   ,[1D].ELEC_MTR_SPEC_CD                                 
                   ,[1D].METER_SUPPLYING                                  
                   ,[1D].SECURED_RATE_FL                                  
                   ,[1D].LAST_SYNC_DATE                                   
                   ,[1D].LAST_UPDATE_PGM_ID                               
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1D].LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS                                   
                   ,[1D].TEMP_DATA                                        
              INTO :1D-ACCOUNT-NO                                       
                  ,:1D-METER-NO                                         
                  ,:1D-CODE-ACCT-STAT                                   
                  ,:1D-CODE-METER-STATUS                                
                  ,:1D-MTR-SERIAL-NO                                    
                  ,:1D-DEVICE-NO                                        
                  ,:1D-LOCAL-OFFICE                                     
                  ,:1D-READ-ROUTE                                       
                  ,:1D-READ-CYCLE                                       
                  ,:1D-CODE-REVENUE-CLASS                               
                  ,:1D-RATE-PLAN-NO                                     
                  ,:1D-DIGTL-MTR-TYPE                                   
                  ,:1D-PROGRAM-ID                                       
                  ,:1D-REMOTE-READ-IND                                  
                  ,:1D-MTR-READ-SOURCE-CD                               
                  ,:1D-CONSTANT                                         
                  ,:1D-POINT-ID                                         
                  ,:1D-IDR-IDENT-NO                                     
                  ,:1D-ELEC-MTR-CLASS-CD                                
                  ,:1D-ELEC-MTR-SPEC-CD                                 
                  ,:1D-METER-SUPPLYING                                  
                  ,:1D-SECURED-RATE-FL                                  
                  ,:1D-LAST-SYNC-DATE                                   
                  ,:1D-LAST-UPDATE-PGM-ID                               
                  ,:1D-LAST-UPDATE-TS                                   
                  ,:1D-TEMP-DATA                                        
              FROM CSS_MDM_SS_INTF [1D] WITH(READUNCOMMITTED)                   
             WHERE [1D].SERVICE_POINT_ID = :1D-SERVICE-POINT-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 1D.ACCOUNT_NO                                               
MFA-TR*            ,1D.METER_NO                                                 
MFA-TR*            ,1D.CODE_ACCT_STAT                                           
MFA-TR*            ,1D.CODE_METER_STATUS                                        
MFA-TR*            ,1D.MTR_SERIAL_NO                                            
MFA-TR*            ,1D.DEVICE_NO                                                
MFA-TR*            ,1D.LOCAL_OFFICE                                             
MFA-TR*            ,1D.READ_ROUTE                                               
MFA-TR*            ,1D.READ_CYCLE                                               
MFA-TR*            ,1D.CODE_REVENUE_CLASS                                       
MFA-TR*            ,1D.RATE_PLAN_NO                                             
MFA-TR*            ,1D.DIGTL_MTR_TYPE                                           
MFA-TR*            ,1D.PROGRAM_ID                                               
MFA-TR*            ,1D.REMOTE_READ_IND                                          
MFA-TR*            ,1D.MTR_READ_SOURCE_CD                                       
MFA-TR*            ,1D.CONSTANT                                                 
MFA-TR*            ,1D.POINT_ID                                                 
MFA-TR*            ,1D.IDR_IDENT_NO                                             
MFA-TR*            ,1D.ELEC_MTR_CLASS_CD                                        
MFA-TR*            ,1D.ELEC_MTR_SPEC_CD                                         
MFA-TR*            ,1D.METER_SUPPLYING                                          
MFA-TR*            ,1D.SECURED_RATE_FL                                          
MFA-TR*            ,1D.LAST_SYNC_DATE                                           
MFA-TR*            ,1D.LAST_UPDATE_PGM_ID                                       
MFA-TR*            ,1D.LAST_UPDATE_TS                                           
MFA-TR*            ,1D.TEMP_DATA                                                
MFA-TR*       INTO :1D-ACCOUNT-NO                                               
MFA-TR*           ,:1D-METER-NO                                                 
MFA-TR*           ,:1D-CODE-ACCT-STAT                                           
MFA-TR*           ,:1D-CODE-METER-STATUS                                        
MFA-TR*           ,:1D-MTR-SERIAL-NO                                            
MFA-TR*           ,:1D-DEVICE-NO                                                
MFA-TR*           ,:1D-LOCAL-OFFICE                                             
MFA-TR*           ,:1D-READ-ROUTE                                               
MFA-TR*           ,:1D-READ-CYCLE                                               
MFA-TR*           ,:1D-CODE-REVENUE-CLASS                                       
MFA-TR*           ,:1D-RATE-PLAN-NO                                             
MFA-TR*           ,:1D-DIGTL-MTR-TYPE                                           
MFA-TR*           ,:1D-PROGRAM-ID                                               
MFA-TR*           ,:1D-REMOTE-READ-IND                                          
MFA-TR*           ,:1D-MTR-READ-SOURCE-CD                                       
MFA-TR*           ,:1D-CONSTANT                                                 
MFA-TR*           ,:1D-POINT-ID                                                 
MFA-TR*           ,:1D-IDR-IDENT-NO                                             
MFA-TR*           ,:1D-ELEC-MTR-CLASS-CD                                        
MFA-TR*           ,:1D-ELEC-MTR-SPEC-CD                                         
MFA-TR*           ,:1D-METER-SUPPLYING                                          
MFA-TR*           ,:1D-SECURED-RATE-FL                                          
MFA-TR*           ,:1D-LAST-SYNC-DATE                                           
MFA-TR*           ,:1D-LAST-UPDATE-PGM-ID                                       
MFA-TR*           ,:1D-LAST-UPDATE-TS                                           
MFA-TR*           ,:1D-TEMP-DATA                                                
MFA-TR*       FROM CSS_MDM_SS_INTF 1D                                           
MFA-TR*      WHERE 1D.SERVICE_POINT_ID = :1D-SERVICE-POINT-ID                   
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN  7100-GET-INTF-DETAILS          **'  
              DISPLAY '** SELECT ROW FROM CSS_MDM_SS_INTF          **'  
              DISPLAY '** SERVICE-POINT-ID = ' 1D-SERVICE-POINT-ID      
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7210-OPEN-INTF-CH-CSR.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN INTF_CH_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN  7210-OPEN-INTF-CH-CSR          **'  
              DISPLAY '** FETCH ERROR IN INTF_CH_CSR               **'  
              DISPLAY '** LAST_UPDATE_TS   = ' 1E-LAST-UPDATE-TS        
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7220-FETCH-INTF-CH-CSR.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH FROM INTF_CH_CSR                                   
                INTO :1E-SERVICE-POINT-ID                               
                    ,:1E-COLUMN-NA                                      
                    ,:1E-LAST-UPDATE-TS                                 
                    ,:1E-PREV-COLUMN-VALUE                              
                    ,:1E-CURR-COLUMN-VALUE                              
                    ,:1E-LAST-UPDATE-PGM-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 SET NO-MORE-SERVICE-POINTS   TO TRUE                   
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE      
                 DISPLAY '************ PCSBW160 ERROR ****************' 
                 DISPLAY '** ERROR IN 7220-FETCH-INTF-CH-CSR        **' 
                 DISPLAY '** FETCH ERROR IN INTF_CH_CSR             **' 
                 DISPLAY '** LAST_UPDATE_TS   = ' 1E-LAST-UPDATE-TS     
                 DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE    
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7230-CLOSE-INTF-CH-CSR.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE INTF_CH_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN 7230-CLOSE-INTF-CH-CSR          **'  
              DISPLAY '** CLOSE ERROR FOR IN INTF_CH_CSR           **'  
              DISPLAY '** LAST_UPDATE_TS   = ' 1E-LAST-UPDATE-TS        
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7240-GET-CURR-TMSTMP.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURR-TMSTMP,
              :WS-CURR-DATE                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURR-TMSTMP = CURRENT TIMESTAMP                           
MFA-TR*          ,:WS-CURR-DATE   = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW160 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN 7240-GET-CURR-TMSTMP    **'        
              DISPLAY '**   GET CURRENT TIMESTAMP            **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7250-GET-SERVICE-DATES.                                          
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
             SELECT DATE_UTIL_SVC_STRT                                  
                   ,DATE_UTIL_SVC_END                                   
                   ,CUSTOMER_NO                                         
               INTO :CH-DATE-UTIL-SVC-STRT                              
                   ,:CH-DATE-UTIL-SVC-END :WS-NULL-IND-FIN               
                   ,:CH-CUSTOMER-NO                                     
               FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO = :CH-ACCOUNT-NO                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE_UTIL_SVC_STRT                                          
MFA-TR*            ,DATE_UTIL_SVC_END                                           
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*        INTO :CH-DATE-UTIL-SVC-STRT                                      
MFA-TR*            ,:CH-DATE-UTIL-SVC-END:WS-NULL-IND-FIN                       
MFA-TR*            ,:CH-CUSTOMER-NO                                             
MFA-TR*        FROM CSS_CUST_PREM_HIST                                          
MFA-TR*       WHERE ACCOUNT_NO = :CH-ACCOUNT-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-FIN < 0                                    
                 MOVE SPACES         TO CH-DATE-UTIL-SVC-END            
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '*****************************************'       
              DISPLAY '**  SELECT FROM CSS_EQUIPMENT          **'       
              DISPLAY '** ACCOUNT_NO = ' AT-ACCOUNT-NO                  
              DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**      PROCESSING TERMINATED          **'       
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7260-GET-MTR-STATUS-DATES.                                       
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
             SELECT DATE_MTR_INSTALL                                    
                   ,MTR_STATUS_CHNG_DT                                  
                   ,METER_INACTIVE_DT                                   
                   ,METER_REMOVED_DT                                    
                   ,REPLACE(CONVERT(CHAR(8), LAST_VALID_READ_TM, 108), 
           ':', '.') LAST_VALID_READ_TM                                  
                   ,MTR_REF_LATITUDE                                    
                   ,MTR_REF_LONGITUDE                                   
              INTO :MN-DATE-MTR-INSTALL                                 
                  ,:MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-STC               
                  ,:MN-METER-INACTIVE-DT :WS-NULL-IND-IAC                
                  ,:MN-METER-REMOVED-DT :WS-NULL-IND-REM                 
                  ,:MN-LAST-VALID-READ-TM :WS-NULL-IND-TIME              
                  ,:MN-MTR-REF-LATITUDE                                 
                  ,:MN-MTR-REF-LONGITUDE                                
               FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO      = :MN-ACCOUNT-NO                    
                AND CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE                
                AND IC_NO           = :MN-IC-NO                         
                AND MTR_REF_NO      = :MN-MTR-REF-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE_MTR_INSTALL                                            
MFA-TR*            ,MTR_STATUS_CHNG_DT                                          
MFA-TR*            ,METER_INACTIVE_DT                                           
MFA-TR*            ,METER_REMOVED_DT                                            
MFA-TR*            ,LAST_VALID_READ_TM                                          
MFA-TR*            ,MTR_REF_LATITUDE                                            
MFA-TR*            ,MTR_REF_LONGITUDE                                           
MFA-TR*       INTO :MN-DATE-MTR-INSTALL                                         
MFA-TR*           ,:MN-MTR-STATUS-CHNG-DT:WS-NULL-IND-STC                       
MFA-TR*           ,:MN-METER-INACTIVE-DT:WS-NULL-IND-IAC                        
MFA-TR*           ,:MN-METER-REMOVED-DT:WS-NULL-IND-REM                         
MFA-TR*           ,:MN-LAST-VALID-READ-TM:WS-NULL-IND-TIME                      
MFA-TR*           ,:MN-MTR-REF-LATITUDE                                         
MFA-TR*           ,:MN-MTR-REF-LONGITUDE                                        
MFA-TR*        FROM CSS_MTRD_ENVRNMT                                            
MFA-TR*       WHERE ACCOUNT_NO      = :MN-ACCOUNT-NO                            
MFA-TR*         AND CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE                        
MFA-TR*         AND IC_NO           = :MN-IC-NO                                 
MFA-TR*         AND MTR_REF_NO      = :MN-MTR-REF-NO                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7260                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-STC < 0                                    
                 MOVE SPACES                 TO MN-MTR-STATUS-CHNG-DT   
              END-IF                                                    
              IF WS-NULL-IND-IAC < 0                                    
                 MOVE SPACES                 TO MN-METER-INACTIVE-DT    
              END-IF                                                    
              IF WS-NULL-IND-REM < 0                                    
                 MOVE SPACES                 TO MN-METER-REMOVED-DT     
              END-IF                                                    
              IF WS-NULL-IND-TIME < 0                                   
                 MOVE ZEROES                 TO MN-LAST-VALID-READ-TM   
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '*****************************************'       
              DISPLAY '**  SELECT FROM CSS_METER_ATTCHMTS     **'       
              DISPLAY '** ACCOUNT_NO      = ' MN-ACCOUNT-NO             
              DISPLAY '** CODE_UTIL_TYPE  = ' MN-CODE-UTIL-TYPE         
              DISPLAY '** IC_NO           = ' MN-IC-NO                  
              DISPLAY '** MTR_REF_NO      = ' MN-MTR-REF-NO             
              DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**      PROCESSING TERMINATED          **'       
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT054*==============================================================*          
ACT054 7265-GET-PREM-LAT-LONG.                                          
ACT054*==============================================================*          
ACT054*                                                                         
ACT054     EXEC SQL                                                     
ACT054       SELECT PREM_REF_LATITUDE                                   
ACT054             ,PREM_REF_LONGITUDE                                  
ACT054        INTO :PR-PREM-REF-LATITUDE                                
ACT054            ,:PR-PREM-REF-LONGITUDE                               
ACT054         FROM CSS_PREMISE WITH(READUNCOMMITTED)                           
ACT054        WHERE PREMISE_NO = :PR-PREMISE-NO                         
ACT054                                                           
ACT054                                                      
ACT054     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PREM_REF_LATITUDE                                           
MFA-TR*            ,PREM_REF_LONGITUDE                                          
MFA-TR*       INTO :PR-PREM-REF-LATITUDE                                        
MFA-TR*           ,:PR-PREM-REF-LONGITUDE                                       
MFA-TR*        FROM CSS_PREMISE                                                 
MFA-TR*       WHERE PREMISE_NO = :PR-PREMISE-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7265                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT054*                                                                         
ACT054     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT054*                                                                         
ACT054     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT054        CONTINUE                                                  
ACT054     ELSE                                                         
ACT054        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
ACT054        DISPLAY '*****************************************'       
ACT054        DISPLAY '**  7265-GET-PREM-LAT-LONG             **'       
ACT054        DISPLAY '**  SELECT FROM CSS_PREMISE            **'       
ACT054        DISPLAY '** PREMISE_NO    = ' PR-PREMISE-NO               
ACT054        DISPLAY '** RETURN CODE   = ' WS-DISPLAY-SQLCODE          
ACT054        DISPLAY '**      PROCESSING TERMINATED          **'       
ACT054        DISPLAY '*****************************************'       
ACT054        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT054     END-IF.                                                      
ACT054*                                                                         
ACT054 7265-EXIT.                                                       
ACT054     EXIT.                                                        
ACT054*                                                                         
      *==============================================================*          
       7270-GET-ENDPOINT-ID.                                            
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
             SELECT  CODE_LONG_DESC                                     
               INTO :UV-CODE-LONG-DESC                                  
               FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
              WHERE CODE_VALUE = 'A'                                    
                AND COLUMN_NA  = 'ENDPOINT_ID'                          
                AND COMPANY_NO = '01'                                   
                AND PROGRAM_ID = 'ALL'                                  
                AND TABLE_NA   = 'OPENWAY'                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  CODE_LONG_DESC                                             
MFA-TR*        INTO :UV-CODE-LONG-DESC                                          
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE CODE_VALUE = 'A'                                            
MFA-TR*         AND COLUMN_NA  = 'ENDPOINT_ID'                                  
MFA-TR*         AND COMPANY_NO = '01'                                           
MFA-TR*         AND PROGRAM_ID = 'ALL'                                          
MFA-TR*         AND TABLE_NA   = 'OPENWAY'                                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7270                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '*****************************************'       
              DISPLAY '**  ERROR IN 7270-GET-ENDPOINT-ID      **'       
              DISPLAY '**  SELECT FROM CSS_CODE_VALUE         **'       
              DISPLAY '**  CODE_VALUE    =  A'                          
              DISPLAY '**  COLUMN_NA     =  ENDPOINT_ID'                
              DISPLAY '**  COMPANY_NO    =  01'                         
              DISPLAY '**  PROGRAM_ID    =  ALL'                        
              DISPLAY '**  TABLE_NA      =  OPENWAY'                    
              DISPLAY '**  RETURN CODE   = '  WS-DISPLAY-SQLCODE        
              DISPLAY '**      PROCESSING TERMINATED          **'       
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7310-OPEN-GET-ADDR-CSR.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN GET_ADDR_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN  7310-OPEN-GET-ADDR-CSR         **'  
              DISPLAY '** TRANS_HIST_SEQ_NO = ' WS-FROM-UPDATE-TS       
              DISPLAY '** SQL CODE          = ' WS-DISPLAY-SQLCODE      
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7320-FETCH-GET-ADDR-CSR.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH FROM GET_ADDR_CSR                                  
                INTO :MI-COLUMN-DESC                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE      
                 DISPLAY '************ PCSBW160 ERROR ****************' 
                 DISPLAY '** ERROR IN 7320-FETCH-GET-ADDR-CSR       **' 
                 DISPLAY '** TRANS_HIST_SEQ_NO = ' WS-FROM-UPDATE-TS    
                 DISPLAY '** SQL CODE          = ' WS-DISPLAY-SQLCODE   
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7330-CLOSE-GET-ADDR-CSR.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE GET_ADDR_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN 7330-CLOSE-GET-ADDR-CSR         **'  
              DISPLAY '** TRANS_HIST_SEQ_NO = ' WS-FROM-UPDATE-TS       
              DISPLAY '** SQL CODE          = ' WS-DISPLAY-SQLCODE      
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7400-GET-LOCAL-OFFICE.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             SELECT LOCAL_OFFICE_DESC                                   
               INTO :B1-LOCAL-OFFICE-DESC                               
               FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                      
              WHERE COMPANY_NO   = '01'                                 
                AND LOCAL_OFFICE = :1D-LOCAL-OFFICE                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT LOCAL_OFFICE_DESC                                           
MFA-TR*        INTO :B1-LOCAL-OFFICE-DESC                                       
MFA-TR*        FROM CSS_LOCAL_OFFICE                                            
MFA-TR*       WHERE COMPANY_NO   = '01'                                         
MFA-TR*         AND LOCAL_OFFICE = :1D-LOCAL-OFFICE                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN 7400-GET-LOCAL-OFFICE           **'  
              DISPLAY '** LOCAL_OFFICE     = ' 1D-LOCAL-OFFICE          
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7500-GET-RATE-DESC.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             SELECT RATE_DESC                                           
               INTO :RD-RATE-DESC                                       
               FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                    
              WHERE CODE_UTIL_TYPE = 'E'                                
                AND RATE_PLAN_NO   = :RD-RATE-PLAN-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT RATE_DESC                                                   
MFA-TR*        INTO :RD-RATE-DESC                                               
MFA-TR*        FROM CSS_RATE_PLAN_DESC                                          
MFA-TR*       WHERE CODE_UTIL_TYPE = 'E'                                        
MFA-TR*         AND RATE_PLAN_NO   = :RD-RATE-PLAN-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN 7500-GET-RATE-DESC              **'  
              DISPLAY '** CODE_UTIL_TYPE   = E'                         
              DISPLAY '** RATE_PLAN_NO     = ' RD-RATE-PLAN-NO          
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A#5347*================================================================*        
A#5347 7700-GET-CUST-EST-DT.                                            
A#5347*================================================================*        
A#5347*                                                                         
A#5347     EXEC SQL                                                     
A#5347       SELECT CUSTOMER_EST_DATE                                   
A#5347         INTO :CU-CUSTOMER-EST-DATE :WS-NULL-IND-DATE              
A#5347         FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                          
A#5347        WHERE CUSTOMER_NO = :CH-CUSTOMER-NO                       
A#5347                                                           
A#5347                                                      
A#5347     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CUSTOMER_EST_DATE                                           
MFA-TR*        INTO :CU-CUSTOMER-EST-DATE:WS-NULL-IND-DATE                      
MFA-TR*        FROM CSS_CUSTOMER                                                
MFA-TR*       WHERE CUSTOMER_NO = :CH-CUSTOMER-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A#5347*                                                                         
A#5347     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A#5347*                                                                         
A#5347     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A#5347        IF WS-NULL-IND-DATE < 0                                   
A#5347           MOVE WS-MDMS-LOW-DATE    TO CU-CUSTOMER-EST-DATE       
A#5347        END-IF                                                    
A#5347     ELSE                                                         
A#5347        MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
A#5347        DISPLAY '************ PCSBW160 ERROR ******************'  
A#5347        DISPLAY '** ERROR IN 7700-GET-CUST-EST-DT            **'  
A#5347        DISPLAY '** ACCOUNT-NO    = ' AT-ACCOUNT-NO               
A#5347        DISPLAY '** CUSTOMER-NO   = ' CH-CUSTOMER-NO              
A#5347        DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
A#5347        DISPLAY '** PROCESSING TERMINATED                    **'  
A#5347        DISPLAY '**********************************************'  
A#5347        PERFORM 9900-ABEND THRU 9900-EXIT                         
A#5347     END-IF.                                                      
A#5347*                                                                         
A#5347 7700-EXIT.                                                       
A#5347     EXIT.                                                        
A#5347*                                                                         
      *================================================================*        
       7710-OPEN-SP-PREM-CSR.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN GET_SP_PREM_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN  7710-OPEN-SP-PREM-CSR          **'  
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7720-FETCH-SP-PREM-CSR.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH FROM GET_SP_PREM_CSR                               
                INTO :1D-SERVICE-POINT-ID                               
                    ,:1D-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 SET NO-MORE-SERVICE-POINTS  TO TRUE                    
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE      
                 DISPLAY '************ PCSBW160 ERROR ****************' 
                 DISPLAY '** ERROR IN 7720-FETCH-SP-PREM-CSR        **' 
                 DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE    
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7730-CLOSE-SP-PREM-CSR.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE GET_SP_PREM_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW160 ERROR ******************'  
              DISPLAY '** ERROR IN 7730-CLOSE-SP-PREM-CSR          **'  
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      *                                                                         
      *================================================================*        
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
       COPY CPD00040.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
       COPY CPD00037.                                                           
      *================================================================*        
      *                                                                         
      *==============================================================*          
      * 7600-START-FCSJC01                    *                                 
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
      * 7620-START-FCSCA00 VSAM CTRL FILE     *                                 
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       8000-WRITE-FIOBW60.                                              
      *================================================================*        
      *                                                                         
           MOVE SPACES            TO FIOBW60-REC.                       
           WRITE FIOBW60-REC FROM FIOBW60.                              
      *                                                                         
           IF FBW60-SUCCESSFUL                                          
              ADD 1                TO WS-FCSBW60-REC-CNTR               
           ELSE                                                         
               DISPLAY '8000-ERROR ON FCSBW60 WRITE.  STATUS IS '       
                        WS-FBW60-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8900-UPDATE-TIMESTMP.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                UPDATE  CSS_JOB_PARM                                    
                   SET  PARM_DATA    = :G6-PARM-DATA                    
                 WHERE PROGRAM_NAME  = :PROGRAM-NAME                    
                   AND COMPANY_NO    = '01'                             
                   AND CMND_CODE     = :WS-PARM                         
                   AND PARM_DATA LIKE 'LAST-UPD-TMST=%'                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              DISPLAY ' '                                               
              DISPLAY ' JOB PARM UPDATED TO ' WS-TO-UPDATE-TS           
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW155 ERROR ******************'  
              DISPLAY '**     8900-UPDATE-TIMESTMP                 **'  
              DISPLAY '** JOB PARM UPDATE ERROR                    **'  
              DISPLAY '** PARM_DATA        = ' G6-PARM-DATA             
              DISPLAY '** PROGRAM_NAME     = ' PROGRAM-NAME             
              DISPLAY '** CMND_CODE        = ' WS-PARM                  
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       9000-TERMINATE.                                                  
      *===============================================================*         
      *                                                                         
           CLOSE FCSBW60-FILE.                                          
      *                                                                         
           IF FBW60-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSBW160 PROCESSING ERROR           **'     
               DISPLAY '**  CLOSE ERROR  - OUTPUT FILES         **'     
               DISPLAY '**  FILE STATUS = ' WS-FBW60-STATUS             
               DISPLAY '**  UNSUCCESSFUL CLOSE OF FCSBW50-FILE  **'     
           END-IF.                                                      
      *                                                                         
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
           DISPLAY '** TOTAL RECS PROCESSED FROM BW60 = '               
                                 WS-FCSBW60-REC-CNTR.                   
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      ****************************************************************          
      * 9700-PROCESS-ABEND  (REQUIED BY CPD00040)                    *          
      ****************************************************************          
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND INCLUDES SQL ROLLBACK   ****           
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
