       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW159.                                        
       INSTALLATION.                                                    
       DATE-WRITTEN.   OCT 2011.                                        
           DATE-COMPILED.                                               
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                 COBOL/DB2                      *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** =====      ========      ======                             **         
      ** 07/31/11   NC94746       NEW CODE                           **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSBW159 NARRATIVE                        
      *                                                                         
           THIS PROGRAM USED TO LOAD CIS MASTER DATA INTO MDMS SYSTEM   
           THIS IS USED ONLY FOR INITIAL DATA SETUP IN MDM SYSTEM.      
                                                                        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSBW58.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDBW58.                                                            
       01  FIOBW58-REC                        PIC X(700).               
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW159'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40)                 
           VALUE 'WORKING STORAGE FOR PCSBW159 STARTS HERE'.            
      *                                                                         
      * BW58 LAYOUT           *                                                 
       01 FIOBW58                             PIC X(700).               
       01 FIOBW58-LEN                         PIC 9(04).                
                                                                        
      * ABEND SWITCH          *                                                 
       COPY CWS09900.                                                           
                                                                        
      * WARNING DATA          *                                                 
       COPY CWS00303.                                                           
                                                                        
      * WS ABEND WORK AREA    *                                                 
       COPY CWS00010.                                                           
                                                                        
       COPY CWS00011.                                                           
      *                                                                         
      * ADDRESS COPYBOOK      *                                                 
       COPY CWS00074.                                                           
                                                                        
      * FCA00-KEY             *                                                 
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
                                                                        
      * IO AREA FOR PARM INPUT FILE 'A' *                                       
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                           DCLGEN'S                             *        
      ******************************************************************        
                                                                        
      * COMMUNICATION AREA                                                      
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      * CSS_ACCOUNT        (AT)                                                 
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      * CSS_MTRD_ENVRNMT   (MN)                                                 
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DCLGEN FOR CSS_CUST_PREM_HIST                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_EQUIPMENT      (EQ)                                                 
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_JOB_PARM       (G6)                                                 
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_METER_ATTCHMTS (MA)                                                 
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_MDM_SS_INTF     (1D)                                                 
           EXEC SQL                                                             
               INCLUDE TBMDMINT                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_MDM_SS_INTF_CH  (1E)                                                 
           EXEC SQL                                                             
               INCLUDE TBMDMCHG                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_ADDR_FORMATTED  (DY)                                                 
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_ADDR_FREEFORM   (DZ)                                                 
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_NAME            (DQ)                                                 
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      *CSS_NAME_ACCT_XREF  (HT)                                                 
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_CUST_ADDR_XREF  (DM)                                                 
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_ZIP_CODE        (A4)                                                 
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      *CSS_ACCT_MISC_INFO  (TA)                                                 
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_PREMISE         (PR)                                                 
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-YES                      PIC X(01) VALUE 'Y'.           
          05 WS-Y                        PIC X(01) VALUE 'Y'.           
          05 WS-N                        PIC X(01) VALUE 'N'.           
          05 WS-U                        PIC X(01) VALUE 'U'.           
          05 WS-NO                       PIC X(01) VALUE 'N'.           
          05 WS-MDMS-LOW-DATE            PIC X(10) VALUE '1970-01-01'.  
          05 WS-PGRMNAME                 PIC X(08)                      
                                           VALUE 'PCSBW159'.            
          05 PROGRAM-NAME                PIC X(08)                      
                                           VALUE 'PCSBW159'.            
          05 WS-FBW58-STATUS             PIC X(02).                     
             88 FBW58-SUCCESSFUL            VALUE '00'.                 
      *                                                                         
      *                                                                         
       01 WS-TEMP-FLAG.                                                 
          05 WS-MASTER-DATA-CHANGE-SW       PIC X(01) VALUE 'N'.        
             88 MASTER-DATA-CHANGED          VALUE 'Y'.                 
             88 MASTER-DATA-NOT-CHANGED      VALUE 'N'.                 
          05 WS-NEW-SERVICE-POINT-SW        PIC X(01) VALUE 'N'.        
             88 SERVICE-POINT-EXISTS         VALUE 'N'.                 
             88 NEW-SERVICE-POINT            VALUE 'Y'.                 
          05 WS-PROCESS-SP-SW               PIC X(01) VALUE 'Y'.        
             88 PROCESS-ALL-SPS              VALUE 'Y'.                 
             88 NO-MORE-SERVICE-POINTS       VALUE 'N'.                 
          05 WS-OLD-MRS-CD-SW               PIC X(01)  VALUE SPACES.    
             88 OLD-MTR-SMARTSYNCH           VALUE 'R'.                 
             88 OLD-MTR-MV90                 VALUE 'M'.                 
             88 OLD-MTR-VALID-MDMS           VALUE 'R','M'.             
             88 OLD-MTR-NOT-VALID-MDMS       VALUE 'B','C','E','F',     
                                                   'I','S','T','X'.     
             88 OLD-MTR-ITRON-MOBILE-AMR     VALUE 'B'.                 
             88 OLD-MTR-ITRON-CUSTOMER       VALUE 'C'.                 
             88 OLD-MTR-METRETEK             VALUE 'E'.                 
             88 OLD-MTR-MANUAL               VALUE 'F'.                 
             88 OLD-MTR-ITRON-MANUAL         VALUE 'I'.                 
             88 OLD-MTR-EFM                  VALUE 'S'.                 
             88 OLD-MTR-TWACS                VALUE 'T'.                 
             88 OLD-MTR-DO-NOT-READ          VALUE 'X'.                 
      *                                                                         
          05 WS-NEW-MRS-CD-SW               PIC X(01)  VALUE SPACES.    
             88 NEW-MTR-SMARTSYNCH           VALUE 'R'.                 
             88 NEW-MTR-MV90                 VALUE 'M'.                 
             88 NEW-MTR-VALID-MDMS           VALUE 'R','M'.             
             88 NEW-MTR-NOT-VALID-MDMS       VALUE 'B','C','E','F',     
                                                   'I','S','T','X'.     
             88 NEW-MTR-ITRON-MOBILE-AMR     VALUE 'B'.                 
             88 NEW-MTR-ITRON-CUSTOMER       VALUE 'C'.                 
             88 NEW-MTR-METRETEK             VALUE 'E'.                 
             88 NEW-MTR-MANUAL               VALUE 'F'.                 
             88 NEW-MTR-ITRON-MANUAL         VALUE 'I'.                 
             88 NEW-MTR-EFM                  VALUE 'S'.                 
             88 NEW-MTR-TWACS                VALUE 'T'.                 
             88 NEW-MTR-DO-NOT-READ          VALUE 'X'.                 
      *                                                                         
       01 WS-RECORD-STRING.                                             
          05 S-ACCOUNT-NO.                                              
             10 RS-ACCOUNT-NO                PIC 9(13).                 
             10 RS-DELIMITER1                PIC X(03).                 
          05 S-SERVICE-POINT-ID.                                        
             10 RS-SERVICE-POINT-ID          PIC X(21).                 
             10 RS-DELIMITER2                PIC X(03).                 
          05 S-PREMISE-NO.                                              
             10 RS-PREMISE-NO                PIC 9(10).                 
             10 RS-DELIMITER3                PIC X(03).                 
          05 S-CUSTOMER-NO.                                             
             10 RS-CUSTOMER-NO               PIC 9(10).                 
             10 RS-DELIMITER4                PIC X(03).                 
          05 S-ACCT-CUSTOM-DATA.                                        
             10 RS-ACCT-CUSTOM-DATA          PIC X(03).                 
             10 RS-DELIMITER5                PIC X(03).                 
          05 S-ACCT-STATUS.                                             
             10 RS-ACCT-STATUS               PIC X(10).                 
             10 RS-DELIMITER6                PIC X(03).                 
          05 S-SVC-STATE.                                               
             10 RS-SVC-STATE                 PIC X(20).                 
             10 RS-DELIMITER7                PIC X(03).                 
          05 S-BILL-CYCLE.                                              
             10 RS-BILL-CYCLE                PIC X(02).                 
             10 RS-DELIMITER8                PIC X(03).                 
          05 S-CUST-NAME.                                               
             10 RS-CUST-NAME                 PIC X(50).                 
             10 RS-DELIMITER9                PIC X(03).                 
          05 S-FIRST-NAME.                                              
             10 RS-FIRST-NAME                PIC X(50).                 
             10 RS-DELIMITER10               PIC X(03).                 
          05 S-ACCT-CHNG-DTTM.                                          
             10 RS-ACCT-CHNG-DTTM            PIC X(18).                 
             10 RS-DELIMITER11               PIC X(03).                 
          05 S-SVC-ADDR-1.                                              
             10 RS-SVC-ADDR-1                PIC X(50).                 
             10 RS-DELIMITER12               PIC X(03).                 
          05 S-SVC-ADDR-OVERFLOW.                                       
             10 RS-SVC-ADDR-OVERFLOW         PIC X(26).                 
             10 RS-DELIMITER13               PIC X(03).                 
          05 S-LOC-OFFICE.                                              
             10 RS-LOC-OFFICE                PIC X(03).                 
             10 RS-DELIMITER14               PIC X(03).                 
          05 S-SVC-CITY.                                                
             10 RS-SVC-CITY                  PIC X(30).                 
             10 RS-DELIMITER15               PIC X(03).                 
          05 S-SVC-ZIP.                                                 
             10 RS-SVC-ZIP                   PIC X(10).                 
             10 RS-DELIMITER16               PIC X(03).                 
          05 S-METER-ID.                                                
             10 RS-METER-ID                  PIC X(12).                 
             10 RS-DELIMITER17               PIC X(03).                 
          05 S-METER-NO.                                                
             10 RS-METER-NO                  PIC X(09).                 
             10 RS-DELIMITER18               PIC X(03).                 
          05 S-METER-TYPE-ID.                                           
             10 RS-METER-TYPE-ID             PIC X(06).                 
             10 RS-DELIMITER19               PIC X(03).                 
          05 S-FIELD-NOT-USE2.                                          
             10 RS-FIELD-NOT-USE2            PIC X(01).                 
             10 RS-DELIMITER20               PIC X(03).                 
          05 S-AMI-VENDOR.                                              
             10 RS-AMI-VENDOR                PIC X(15).                 
             10 RS-DELIMITER21               PIC X(03).                 
          05 S-CONSTANT-KWH.                                            
             10 RS-CONSTANT-KWH              PIC X(10).                 
             10 RS-DELIMITER22               PIC X(03).                 
          05 S-CONSTANT-KW.                                             
             10 RS-CONSTANT-KW               PIC X(10).                 
             10 RS-DELIMITER23               PIC X(03).                 
          05 S-CONSTANT-KVA.                                            
             10 RS-CONSTANT-KVA              PIC X(10).                 
             10 RS-DELIMITER24               PIC X(03).                 
          05 S-METER-STATUS.                                            
             10 RS-METER-STATUS              PIC X(21).                 
             10 RS-DELIMITER25               PIC X(03).                 
          05 S-ELEC-MTR-CLASS-CD.                                       
             10 RS-ELEC-MTR-CLASS-CD         PIC X(02).                 
             10 RS-DELIMITER26               PIC X(03).                 
          05 S-ELEC-MTR-SPEC-CD.                                        
             10 RS-ELEC-MTR-SPEC-CD          PIC X(03).                 
             10 RS-DELIMITER27               PIC X(03).                 
          05 S-MTR-SERIAL-NO.                                           
             10 RS-MTR-SERIAL-NO             PIC X(11).                 
             10 RS-DELIMITER28               PIC X(03).                 
          05 S-METER-SUPPLYING.                                         
             10 RS-METER-SUPPLYING           PIC X(15).                 
             10 RS-DELIMITER29               PIC X(03).                 
          05 S-POINT-ID.                                                
             10 RS-POINT-ID                  PIC X(10).                 
             10 RS-DELIMITER30               PIC X(03).                 
          05 S-CODE-REVENUE-CLASS.                                      
             10 RS-CODE-REVENUE-CLASS        PIC X(03).                 
             10 RS-DELIMITER31               PIC X(03).                 
          05 S-RATE-PLAN-NO.                                            
             10 RS-RATE-PLAN-NO              PIC X(03).                 
             10 RS-DELIMITER32               PIC X(03).                 
          05 S-READ-ROUTE.                                              
             10 RS-READ-ROUTE                PIC X(04).                 
             10 RS-DELIMITER33               PIC X(03).                 
          05 S-MTR-INSTALL-DTTM.                                        
             10 RS-MTR-INSTALL-DTTM          PIC X(18).                 
             10 RS-DELIMITER34               PIC X(03).                 
          05 S-MTR-CUSTOM-DATA.                                         
             10 RS-MTR-CUSTOM-DATA           PIC X(30).                 
             10 RS-DELIMITER35               PIC X(03).                 
          05 S-SECU-RATE-FLAG.                                          
             10 RS-SECU-RATE-FLAG            PIC X(01).                 
             10 RS-DELIMITER36               PIC X(03).                 
          05 S-RECORDER-ID.                                             
             10 RS-RECORDER-ID               PIC X(20).                 
             10 RS-DELIMITER37               PIC X(03).                 
          05 S-RECORD-TYPE.                                             
             10 RS-RECORD-TYPE               PIC X(01).                 
             10 RS-DELIMITER38               PIC X(03).                 
       01 WS-OLD-WORK-AREA.                                             
          05 WS-OLD-METER-NO                PIC X(09)  VALUE SPACES.    
          05 WS-OLD-ACCOUNT-NO-AN           PIC X(13).                  
          05 WS-OLD-ACCOUNT-NO REDEFINES WS-OLD-ACCOUNT-NO-AN           
                                            PIC 9(13).                  
          05 WS-OLD-READ-ROUTE-AN           PIC X(04).                  
          05 WS-OLD-READ-ROUTE REDEFINES WS-OLD-READ-ROUTE-AN           
                                            PIC 9(04).                  
          05 WS-OLD-CONSTANT-AN             PIC X(10).                  
          05 WS-OLD-CONSTANT REDEFINES WS-OLD-CONSTANT-AN               
                                            PIC 9(6).999.               
          05 WS-OLD-DEVICE-NO               PIC X(12)  VALUE SPACES.    
          05 WS-OLD-MTR-SERIAL-NO           PIC X(11)  VALUE SPACES.    
          05 WS-OLD-LOCAL-OFFICE            PIC X(03)  VALUE SPACES.    
          05 WS-OLD-BILL-CYCLE              PIC X(02)  VALUE SPACES.    
          05 WS-OLD-DIGTL-MTR-TYPE          PIC X(03)  VALUE SPACES.    
          05 WS-OLD-CODE-REVENUE-CLASS      PIC X(03)  VALUE SPACES.    
          05 WS-OLD-RATE-PLAN-NO            PIC X(03)  VALUE SPACES.    
          05 WS-OLD-PROGRAM-ID              PIC X(02)  VALUE SPACES.    
          05 WS-OLD-METER-STATUS            PIC X(01)  VALUE SPACES.    
          05 WS-OLD-CODE-ACCT-STAT          PIC X(01)  VALUE SPACES.    
          05 WS-OLD-REMOTE-READ-IND         PIC X(01)  VALUE SPACES.    
          05 WS-OLD-POINT-ID                PIC X(10)  VALUE SPACES.    
          05 WS-OLD-IDR-IDENT-NO            PIC X(20)  VALUE SPACES.    
          05 WS-OLD-ELEC-MTR-CLASS-CD       PIC X(02)  VALUE SPACES.    
          05 WS-OLD-ELEC-MTR-SPEC-CD        PIC X(03)  VALUE SPACES.    
          05 WS-OLD-METER-SUPPLYING         PIC X(15)  VALUE SPACES.    
          05 WS-OLD-SECURED-RATE-FL         PIC X(01)  VALUE SPACES.    
      *                                                                         
       01 WS-WORK-AREA.                                                 
          05 RS-RETURN-CODE                  PIC S9(09) VALUE +0 COMP.  
          05 RS-RETURN-CODE-DISP             PIC S9(09) VALUE +0 COMP.  
          05 WS-CURR-TMSTMP                  PIC X(26) VALUE SPACES.    
          05 WS-CURR-DATE                    PIC X(10) VALUE SPACES.    
          05 WS-TMP-READ-ROUTE               PIC 9(04) VALUE 0.         
          05 WS-FROM-UPDATE-TS               PIC X(26) VALUE SPACES.    
          05 WS-TO-UPDATE-TS                 PIC X(26) VALUE SPACES.    
          05 WS-DISPLAY-SQLCODE              PIC ---9.                  
          05 WS-FCSBW58-REC-CNTR             PIC S9(09) COMP VALUE 0.   
          05 WS-PREV-SERVICE-POINT-ID        PIC X(21)  VALUE SPACES.   
          05 WS-CUST-NAME                    PIC X(96)  VALUE SPACES.   
          05 WS-DBA-NAME                     PIC X(96)  VALUE SPACES.   
          05 WS-MTR-STATUS-DT                PIC X(10)  VALUE SPACES.   
          05 WS-HOLD-MTR-STATUS-DT           PIC X(10)  VALUE SPACES.   
          05 WS-NULL-IND-FIN                 PIC S9(04) COMP VALUE 0.   
          05 WS-NULL-IND-STC                 PIC S9(04) COMP VALUE 0.   
          05 WS-NULL-IND-IAC                 PIC S9(04) COMP VALUE 0.   
          05 WS-NULL-IND-REM                 PIC S9(04) COMP VALUE 0.   
      *                                                                         
          05 WS-SERVICE-POINT-ID.                                       
             10 WS-COMPANY-NO                 PIC X(02) VALUE SPACES.   
             10 WS-PREMISE-NO                 PIC 9(10) VALUE 0.        
             10 WS-CODE-UTIL-TYPE             PIC X(01) VALUE SPACES.   
             10 WS-IC-NO                      PIC 9(04) VALUE 0.        
             10 WS-MTR-REF-NO                 PIC 9(04) VALUE 0.        
          05 WS-METER-ID.                                               
             10 WS-COMPANY-NO1                PIC X(02) VALUE SPACES.   
             10 WS-CODE-UTIL-TYPE1            PIC X(01) VALUE SPACES.   
             10 WS-METER-NO1                  PIC X(09) VALUE SPACES.   
          05 WS-METER-TYPE-ID.                                          
             10 WS-DMT                        PIC X(02) VALUE SPACES.   
             10 WS-PGM-ID                     PIC X(02) VALUE SPACES.   
             10 WS-CODE-UTIL-TYPE2            PIC X(01) VALUE SPACES.   
             10 WS-MTR-RD-SRC                 PIC X(01) VALUE SPACES.   
          05 WS-MTR-CONSTANT.                                           
             10 WS-CONSTANT-NUM               PIC 9(06) VALUE 0.        
             10 WS-CONSTANT-DPOINT            PIC X(01) VALUE '.'.      
             10 WS-CONSTANT-DEC               PIC V9(03) VALUE 0.       
      *                                                                         
          05 WS-STATUS-DATE1.                                           
             10 WS-STATUS-YYYY1               PIC X(04).                
             10                               PIC X(01).                
             10 WS-STATUS-MM1                 PIC X(02).                
             10                               PIC X(01).                
             10 WS-STATUS-DD1                 PIC X(02).                
      *                                                                         
          05 WS-STATUS-DTTM2.                                           
             10 WS-STATUS-MM2                 PIC X(02).                
             10                               PIC X(01) VALUE '/'.      
             10 WS-STATUS-DD2                 PIC X(02).                
             10                               PIC X(01) VALUE '/'.      
             10 WS-STATUS-YYYY2               PIC X(04).                
             10 WS-STATUS-HH2                 PIC X(02).                
             10                               PIC X(01) VALUE ':'.      
             10 WS-STATUS-MI2                 PIC X(02).                
             10                               PIC X(01) VALUE ':'.      
             10 WS-STATUS-SS2                 PIC X(02).                
      *                                                                         
      * FCA00 MISC INPUT     *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
                                                                        
      * WOKING STORAGE FOR CPDCA099                                             
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      * MISC INPUT           *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
       01 WS-INPUT-DATA-R8 REDEFINES WS-INPUT-DATA-BREAKDOWN.           
          10 WS-SYSIPT-R8                   PIC X(14).                  
             88 TIME-STAMP                 VALUE 'LAST-UPD-TMST='.      
          10 WS-TIME-STAMP-PARM             PIC  X(26).                 
          10 FILLER                         PIC  X(40).                 
      *                                                                         
       01 WS-END                             PIC X(40)                  
           VALUE 'WORKING STORAGE FOR PCSBW159 ENDS HERE  '.            
      *                                                                         
      ******************* BEGIN CURSOR DECLARATION ********************         
      *                                                                         
      *****************************************************************         
      **  CURSOR TO GET ROWS FROM CSS_MDM_SS_INTF                    **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE INTF_CSR CURSOR FOR                               
                SELECT [1D].SERVICE_POINT_ID                              
                      ,[1D].ACCOUNT_NO                                    
                      ,[1D].METER_NO                                      
                      ,[1D].CODE_ACCT_STAT                                
                      ,[1D].CODE_METER_STATUS                             
                      ,[1D].MTR_SERIAL_NO                                 
                      ,[1D].DEVICE_NO                                     
                      ,[1D].LOCAL_OFFICE                                  
                      ,[1D].READ_ROUTE                                    
                      ,[1D].BILL_CYCLE                                    
                      ,[1D].CODE_REVENUE_CLASS                            
                      ,[1D].RATE_PLAN_NO                                  
                      ,[1D].DIGTL_MTR_TYPE                                
                      ,[1D].PROGRAM_ID                                    
                      ,[1D].REMOTE_READ_IND                               
                      ,[1D].MTR_READ_SOURCE_CD                            
                      ,[1D].CONSTANT                                      
                      ,[1D].POINT_ID                                      
                      ,[1D].IDR_IDENT_NO                                  
                      ,[1D].ELEC_MTR_CLASS_CD                             
                      ,[1D].ELEC_MTR_SPEC_CD                              
                      ,[1D].METER_SUPPLYING                               
                      ,[1D].SECURED_RATE_FL                               
                      ,[1D].LAST_SYNC_DATE                                
                      ,[1D].LAST_UPDATE_PGM_ID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1D].LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS                                
                      ,[1D].TEMP_DATA                                     
                   FROM CSS_MDM_SS_INTF [1D] WITH(READUNCOMMITTED)              
                   WHERE [1D].MTR_READ_SOURCE_CD IN ('R', 'M')            
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE INTF_CSR CURSOR FOR                                       
MFA-TR*         SELECT 1D.SERVICE_POINT_ID                                      
MFA-TR*               ,1D.ACCOUNT_NO                                            
MFA-TR*               ,1D.METER_NO                                              
MFA-TR*               ,1D.CODE_ACCT_STAT                                        
MFA-TR*               ,1D.CODE_METER_STATUS                                     
MFA-TR*               ,1D.MTR_SERIAL_NO                                         
MFA-TR*               ,1D.DEVICE_NO                                             
MFA-TR*               ,1D.LOCAL_OFFICE                                          
MFA-TR*               ,1D.READ_ROUTE                                            
MFA-TR*               ,1D.BILL_CYCLE                                            
MFA-TR*               ,1D.CODE_REVENUE_CLASS                                    
MFA-TR*               ,1D.RATE_PLAN_NO                                          
MFA-TR*               ,1D.DIGTL_MTR_TYPE                                        
MFA-TR*               ,1D.PROGRAM_ID                                            
MFA-TR*               ,1D.REMOTE_READ_IND                                       
MFA-TR*               ,1D.MTR_READ_SOURCE_CD                                    
MFA-TR*               ,1D.CONSTANT                                              
MFA-TR*               ,1D.POINT_ID                                              
MFA-TR*               ,1D.IDR_IDENT_NO                                          
MFA-TR*               ,1D.ELEC_MTR_CLASS_CD                                     
MFA-TR*               ,1D.ELEC_MTR_SPEC_CD                                      
MFA-TR*               ,1D.METER_SUPPLYING                                       
MFA-TR*               ,1D.SECURED_RATE_FL                                       
MFA-TR*               ,1D.LAST_SYNC_DATE                                        
MFA-TR*               ,1D.LAST_UPDATE_PGM_ID                                    
MFA-TR*               ,1D.LAST_UPDATE_TS                                        
MFA-TR*               ,1D.TEMP_DATA                                             
MFA-TR*            FROM CSS_MDM_SS_INTF 1D                                      
MFA-TR*            WHERE 1D.MTR_READ_SOURCE_CD IN ('R', 'M')                    
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7210                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
      *                                                                         
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
      *                                                                         
           PERFORM 1000-PROCESS-INTF-CHNG   THRU 1000-EXIT              
             UNTIL NO-MORE-SERVICE-POINTS.                              
      *                                                                         
           PERFORM 7230-CLOSE-INTF-CSR      THRU 7230-EXIT.             
      *                                                                         
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           OPEN OUTPUT FCSBW58-FILE.                                    
                                                                        
           IF  FBW58-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************ PCSBW159 ERROR ******************'  
              DISPLAY '** ERROR IN  0100-INITIALIZATION            **'  
              DISPLAY '**   FILE FCSBW58 OPEN INPUT                **'  
              DISPLAY '** FILE STATUS = ' WS-FBW58-STATUS               
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT.             
                                                                        
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                            THRU 6240-EXIT              
               DISPLAY 'COMMON DATE ==> ' WS-FCA00-COMMON-DATE          
               MOVE WS-FCA00-COMMON-DATE  TO WS-INPUT-DATE              
           END-IF.                                                      
      *                                                                         
           PERFORM 7240-GET-CURR-TMSTMP     THRU 7240-EXIT.             
           MOVE WS-CURR-TMSTMP            TO WS-TO-UPDATE-TS.           
           DISPLAY    'CURRENT TIMESTAMP  ==> ' WS-TO-UPDATE-TS.        
      *                                                                         
           PERFORM 7210-OPEN-INTF-CSR    THRU 7210-EXIT.                
      *                                                                         
           PERFORM 7220-FETCH-INTF-CSR   THRU 7220-EXIT.                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              DISPLAY '  '                                              
              DISPLAY '****************************************'        
              DISPLAY '**                                    **'        
              DISPLAY '**   NO SERVICE POINT CHANGES FOUND   **'        
              DISPLAY '**   PROGRAM COMPLTED SUCCESSFULLY.   **'        
              DISPLAY '**                                    **'        
              DISPLAY '****************************************'        
           END-IF.                                                      
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-PROCESS-INTF-CHNG.                                          
      *================================================================*        
      *                                                                         
           DISPLAY 'PROCESSING SP: ' 1D-SERVICE-POINT-ID.               
           MOVE 1D-SERVICE-POINT-ID       TO 1E-SERVICE-POINT-ID        
                                             WS-SERVICE-POINT-ID.       
      *                                                                         
           MOVE 1D-ACCOUNT-NO             TO AT-ACCOUNT-NO              
                                             MN-ACCOUNT-NO              
                                             WS-OLD-ACCOUNT-NO          
           MOVE WS-CODE-UTIL-TYPE         TO MN-CODE-UTIL-TYPE          
           MOVE WS-IC-NO                  TO MN-IC-NO                   
           MOVE WS-MTR-REF-NO             TO MN-MTR-REF-NO              
      *                                                                         
           MOVE 1D-MTR-READ-SOURCE-CD     TO WS-NEW-MRS-CD-SW           
                                             WS-OLD-MRS-CD-SW           
      *                                                                         
           SET MASTER-DATA-NOT-CHANGED    TO TRUE                       
           SET SERVICE-POINT-EXISTS       TO TRUE.                      
           MOVE SPACES                 TO WS-RECORD-STRING              
                                          WS-HOLD-MTR-STATUS-DT         
      *                                                                         
           PERFORM 2300-NEW-ACCOUNT-ENTITY THRU 2300-EXIT               
           PERFORM 2400-NEW-METER-ENTITY   THRU 2400-EXIT               
           PERFORM 3900-FORMAT-BW58-RECORD THRU 3900-EXIT.              
      *                                                                         
           PERFORM 7220-FETCH-INTF-CSR      THRU 7220-EXIT.             
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2300-NEW-ACCOUNT-ENTITY.                                         
      *================================================================*        
      *                                                                         
           MOVE 1D-ACCOUNT-NO           TO RS-ACCOUNT-NO                
                                           AT-ACCOUNT-NO                
                                           CH-ACCOUNT-NO                
           MOVE WS-PREMISE-NO           TO RS-PREMISE-NO                
           PERFORM 7250-GET-SERVICE-DATES THRU 7250-EXIT                
           MOVE CH-CUSTOMER-NO          TO RS-CUSTOMER-NO               
           MOVE SPACES                  TO RS-ACCT-CUSTOM-DATA          
      *                                                                         
           MOVE SPACES                TO WS-STATUS-DATE1                
           IF 1D-CODE-ACCT-STAT = 'A'                                   
              MOVE 'Active'             TO RS-ACCT-STATUS               
              MOVE CH-DATE-UTIL-SVC-STRT  TO WS-STATUS-DATE1            
           ELSE                                                         
              MOVE 'Final'              TO RS-ACCT-STATUS               
              MOVE CH-DATE-UTIL-SVC-END TO WS-STATUS-DATE1              
           END-IF                                                       
           IF WS-STATUS-DATE1 = SPACES                                  
              MOVE WS-CURR-DATE       TO WS-STATUS-DATE1                
           END-IF                                                       
           IF WS-STATUS-DATE1 < WS-MDMS-LOW-DATE                        
              MOVE WS-MDMS-LOW-DATE     TO WS-STATUS-DATE1              
           END-IF                                                       
      *                                                                         
           MOVE 1D-BILL-CYCLE           TO RS-BILL-CYCLE                
           PERFORM 3800-GET-NAME-ADDRESS THRU 3800-EXIT                 
           MOVE WS-CUST-NAME            TO RS-CUST-NAME                 
           IF WS-DBA-NAME > SPACES                                      
              MOVE WS-DBA-NAME             TO RS-FIRST-NAME             
           ELSE                                                         
              MOVE '-'                     TO RS-FIRST-NAME             
           END-IF                                                       
      *                                                                         
           INITIALIZE      WS-STATUS-DTTM2                              
           MOVE WS-STATUS-YYYY1       TO WS-STATUS-YYYY2                
           MOVE WS-STATUS-MM1         TO WS-STATUS-MM2                  
           MOVE WS-STATUS-DD1         TO WS-STATUS-DD2                  
           MOVE '00'                  TO WS-STATUS-HH2                  
           MOVE '00'                  TO WS-STATUS-MI2                  
           MOVE '00'                  TO WS-STATUS-SS2                  
           MOVE WS-STATUS-DTTM2       TO RS-ACCT-CHNG-DTTM              
      *                                                                         
           IF WS-PR-STREET > SPACES                                     
              MOVE WS-PR-STREET            TO RS-SVC-ADDR-1             
           ELSE                                                         
              MOVE '-'                     TO RS-SVC-ADDR-1             
           END-IF                                                       
           IF WS-PR-ADDR-OVERFLOW > SPACES                              
              MOVE WS-PR-ADDR-OVERFLOW     TO RS-SVC-ADDR-OVERFLOW      
           ELSE                                                         
              MOVE '-'                     TO RS-SVC-ADDR-OVERFLOW      
           END-IF                                                       
           MOVE 1D-LOCAL-OFFICE         TO RS-LOC-OFFICE                
           IF WS-CITY   > SPACES                                        
              MOVE WS-CITY              TO RS-SVC-CITY                  
           ELSE                                                         
              MOVE '-'                     TO RS-SVC-CITY               
           END-IF                                                       
           IF WS-STATE  > SPACES                                        
              MOVE WS-STATE             TO RS-SVC-STATE                 
           ELSE                                                         
              MOVE '-'                     TO RS-SVC-STATE              
           END-IF                                                       
           IF WS-ZIP > SPACES                                           
              MOVE WS-ZIP                  TO RS-SVC-ZIP                
           ELSE                                                         
              MOVE '-'                     TO RS-SVC-ZIP                
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2400-NEW-METER-ENTITY.                                           
      *================================================================*        
      *                                                                         
           MOVE 1D-SERVICE-POINT-ID     TO RS-SERVICE-POINT-ID          
           MOVE WS-COMPANY-NO           TO WS-COMPANY-NO1               
           MOVE WS-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE1           
           MOVE 1D-METER-NO             TO WS-METER-NO1                 
           MOVE WS-METER-ID             TO RS-METER-ID                  
      *                                                                         
           MOVE 1D-METER-NO             TO RS-METER-NO                  
      *                                                                         
           MOVE 1D-DIGTL-MTR-TYPE       TO WS-DMT                       
           MOVE 1D-PROGRAM-ID           TO WS-PGM-ID                    
           MOVE WS-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE2           
           MOVE 1D-MTR-READ-SOURCE-CD   TO WS-MTR-RD-SRC                
           MOVE WS-METER-TYPE-ID        TO RS-METER-TYPE-ID             
      *                                                                         
           MOVE SPACES                  TO RS-FIELD-NOT-USE2            
      *                                                                         
           EVALUATE 1D-MTR-READ-SOURCE-CD                               
              WHEN 'R'                                                  
                 MOVE 'SmartSynch'      TO RS-AMI-VENDOR                
              WHEN 'M'                                                  
                 MOVE 'MV 90'           TO RS-AMI-VENDOR                
              WHEN OTHER                                                
                 MOVE 'Unknown'         TO RS-AMI-VENDOR                
           END-EVALUATE                                                 
      *                                                                         
           MOVE 1D-CONSTANT             TO WS-CONSTANT-NUM              
                                           WS-CONSTANT-DEC              
           MOVE '.'                     TO WS-CONSTANT-DPOINT           
           MOVE WS-MTR-CONSTANT         TO RS-CONSTANT-KWH              
           MOVE '1.000'                 TO RS-CONSTANT-KW               
                                           RS-CONSTANT-KVA              
      *                                                                         
           MOVE 1D-ACCOUNT-NO           TO MN-ACCOUNT-NO                
           PERFORM 7260-GET-MTR-STATUS-DATES THRU 7260-EXIT             
           MOVE SPACES                  TO WS-MTR-STATUS-DT             
           EVALUATE 1D-CODE-METER-STATUS                                
              WHEN 'A'                                                  
              WHEN 'B'                                                  
                 MOVE 'Active'          TO RS-METER-STATUS              
                 MOVE MN-DATE-MTR-INSTALL   TO WS-MTR-STATUS-DT         
              WHEN 'I'                                                  
              WHEN '0'                                                  
              WHEN '1'                                                  
                 MOVE 'Monitor'         TO RS-METER-STATUS              
                 MOVE MN-DATE-MTR-INSTALL   TO WS-MTR-STATUS-DT         
              WHEN 'J'                                                  
                 MOVE 'Power Off'       TO RS-METER-STATUS              
                 MOVE MN-DATE-MTR-INSTALL   TO WS-MTR-STATUS-DT         
      ***        MOVE MN-METER-INACTIVE-DT  TO WS-MTR-STATUS-DT                 
      ****       IF WS-MTR-STATUS-DT = SPACES                                   
      ****          MOVE WS-CURR-DATE       TO WS-MTR-STATUS-DT                 
      ****       END-IF                                                         
              WHEN 'K'                                                  
                 MOVE 'Removed'         TO RS-METER-STATUS              
      *** SOME METERS MAY REMOVED RECENTLY, CODE CHANGE MAY NEEDED HERE         
                 MOVE MN-METER-REMOVED-DT   TO WS-MTR-STATUS-DT         
                 IF WS-MTR-STATUS-DT = SPACES                           
                    MOVE WS-CURR-DATE       TO WS-MTR-STATUS-DT         
                 END-IF                                                 
              WHEN OTHER                                                
                 MOVE 'Active'          TO RS-METER-STATUS              
                 MOVE MN-DATE-MTR-INSTALL   TO WS-MTR-STATUS-DT         
           END-EVALUATE.                                                
           IF WS-MTR-STATUS-DT = SPACES                                 
              OR WS-MTR-STATUS-DT < MN-DATE-MTR-INSTALL                 
              MOVE MN-DATE-MTR-INSTALL  TO WS-MTR-STATUS-DT             
           END-IF                                                       
      *                                                                         
           MOVE 1D-ELEC-MTR-CLASS-CD    TO RS-ELEC-MTR-CLASS-CD         
           MOVE 1D-ELEC-MTR-SPEC-CD     TO RS-ELEC-MTR-SPEC-CD          
           MOVE 1D-MTR-SERIAL-NO        TO RS-MTR-SERIAL-NO             
           IF 1D-METER-SUPPLYING > SPACES                               
              MOVE 1D-METER-SUPPLYING   TO RS-METER-SUPPLYING           
           ELSE                                                         
              MOVE '-'                  TO RS-METER-SUPPLYING           
           END-IF.                                                      
           IF 1D-POINT-ID > SPACES                                      
              MOVE 1D-POINT-ID             TO RS-POINT-ID               
           ELSE                                                         
              MOVE '-'                  TO RS-POINT-ID                  
           END-IF.                                                      
           MOVE 1D-CODE-REVENUE-CLASS   TO RS-CODE-REVENUE-CLASS        
           MOVE 1D-RATE-PLAN-NO         TO RS-RATE-PLAN-NO              
           MOVE 1D-READ-ROUTE           TO WS-TMP-READ-ROUTE            
           MOVE WS-TMP-READ-ROUTE       TO RS-READ-ROUTE                
      *                                                                         
           MOVE WS-MTR-STATUS-DT   TO WS-STATUS-DATE1                   
                                      WS-HOLD-MTR-STATUS-DT             
           IF WS-STATUS-DATE1 < WS-MDMS-LOW-DATE                        
              MOVE WS-MDMS-LOW-DATE     TO WS-STATUS-DATE1              
                                           WS-HOLD-MTR-STATUS-DT        
           END-IF                                                       
           INITIALIZE      WS-STATUS-DTTM2                              
           MOVE WS-STATUS-YYYY1       TO WS-STATUS-YYYY2                
           MOVE WS-STATUS-MM1         TO WS-STATUS-MM2                  
           MOVE WS-STATUS-DD1         TO WS-STATUS-DD2                  
           MOVE '00'                  TO WS-STATUS-HH2                  
           MOVE '00'                  TO WS-STATUS-MI2                  
           MOVE '00'                  TO WS-STATUS-SS2                  
           MOVE WS-STATUS-DTTM2       TO RS-MTR-INSTALL-DTTM            
      *                                                                         
           EVALUATE 1D-CODE-REVENUE-CLASS(2:1)                          
              WHEN '0'                                                  
                 MOVE 'Special Handling'    TO RS-MTR-CUSTOM-DATA       
              WHEN '1'                                                  
                 MOVE 'Residential'         TO RS-MTR-CUSTOM-DATA       
              WHEN '2'                                                  
                 MOVE 'Commercial '         TO RS-MTR-CUSTOM-DATA       
              WHEN '3'                                                  
                 MOVE 'Industrial'          TO RS-MTR-CUSTOM-DATA       
              WHEN '6'                                                  
                 MOVE 'Public Street Light' TO RS-MTR-CUSTOM-DATA       
              WHEN '7'                                                  
                 MOVE 'Other Public Authority' TO RS-MTR-CUSTOM-DATA    
              WHEN '8'                                                  
                 MOVE 'Commercial'          TO RS-MTR-CUSTOM-DATA       
              WHEN '9'                                                  
                 MOVE 'Industrial/Sales for Resale'                     
                                            TO RS-MTR-CUSTOM-DATA       
              WHEN OTHER                                                
                 MOVE 'Unknown'             TO RS-MTR-CUSTOM-DATA       
           END-EVALUATE                                                 
      *                                                                         
      ***  MOVE 1D-SECURED-RATE-FL      TO RS-SECU-RATE-FLAG                    
           MOVE 'Y'                     TO RS-SECU-RATE-FLAG            
           IF 1D-IDR-IDENT-NO > SPACES                                  
              MOVE 1D-IDR-IDENT-NO         TO RS-RECORDER-ID            
           ELSE                                                         
              MOVE '-'                     TO RS-RECORDER-ID            
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3800-GET-NAME-ADDRESS.                                           
      *================================================================*        
      *                                                                         
           MOVE SPACES                    TO WS-CUST-NAME.              
           SET WS-NAME-ONLY               TO TRUE.                      
           PERFORM 4000-MAIL-NAME-ADDRESS     THRU 4000-EXIT.           
           MOVE 'N'                       TO WS-NAME-ONLY-SW.           
           INSPECT WS-CUSTOMER-NAME  REPLACING ALL ',' BY ' '.          
           MOVE WS-CUSTOMER-NAME          TO WS-CUST-NAME.              
           MOVE SPACES                    TO WS-DBA-NAME                
      *                                                                         
           PERFORM VARYING WS-NAME-INDX FROM 1 BY 1                     
                                   UNTIL WS-NAME-INDX > 5               
                OR WS-NAME-ENTRY (WS-NAME-INDX) = SPACES                
              IF WS-NAME-TYPE (WS-NAME-INDX) = 'DB'                     
                 MOVE WS-NAME (WS-NAME-INDX) TO WS-DBA-NAME             
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           MOVE ZERO                      TO AT-ADDRESS-ID.             
           MOVE SPACES                    TO WS-PR-STREET               
                                             WS-PR-ADDR-OVERFLOW        
                                             WS-PR-ADDR-CITY-STATE      
                                             WS-CITY                    
                                             WS-STATE                   
                                             WS-ZIP                     
      *                                                                         
           PERFORM 4025-DETERMINE-ADDRESS     THRU 4025-EXIT.           
      *                                                                         
           INSPECT WS-CUST-NAME REPLACING ALL ',' BY ' '.               
           IF WS-DBA-NAME > SPACES                                      
              INSPECT WS-DBA-NAME REPLACING ALL ',' BY ' '              
           END-IF.                                                      
           INSPECT WS-PR-STREET REPLACING ALL ',' BY ' '.               
           IF WS-PR-ADDR-OVERFLOW > SPACES                              
              INSPECT WS-PR-ADDR-OVERFLOW REPLACING ALL ',' BY ' '      
           END-IF.                                                      
           INSPECT WS-CITY REPLACING ALL ',' BY ' '.                    
           INSPECT WS-STATE REPLACING ALL ',' BY ' '.                   
                                                                        
       3800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3900-FORMAT-BW58-RECORD.                                         
      *================================================================*        
      *                                                                         
           MOVE SPACES                 TO FIOBW58.                      
           MOVE +1                     TO FIOBW58-LEN.                  
      *                                                                         
           IF RS-ACCT-STATUS = 'Final' OR RS-METER-STATUS = 'Removed'   
              MOVE '1'                 TO RS-RECORD-TYPE                
           ELSE                                                         
              MOVE '2'                 TO RS-RECORD-TYPE                
           END-IF.                                                      
      *                                                                         
           STRING S-RECORD-TYPE           DELIMITED BY '   '            
                  ','                                                   
                  S-ACCOUNT-NO            DELIMITED BY '   '            
                  ','                                                   
                  S-SERVICE-POINT-ID      DELIMITED BY '   '            
                  ','                                                   
                  S-PREMISE-NO            DELIMITED BY '   '            
                  ','                                                   
                  S-CUSTOMER-NO           DELIMITED BY '   '            
                  ','                                                   
                  S-ACCT-CUSTOM-DATA      DELIMITED BY '   '            
                  ','                                                   
                  S-ACCT-STATUS           DELIMITED BY '   '            
                  ','                                                   
                  S-SVC-STATE             DELIMITED BY '   '            
                  ','                                                   
                  S-BILL-CYCLE            DELIMITED BY '   '            
                  ','                                                   
                  S-CUST-NAME             DELIMITED BY '   '            
                  ','                                                   
                  S-FIRST-NAME            DELIMITED BY '   '            
                  ','                                                   
                  S-ACCT-CHNG-DTTM        DELIMITED BY '   '            
                  ','                                                   
                  S-SVC-ADDR-1            DELIMITED BY '   '            
                  ','                                                   
                  S-SVC-ADDR-OVERFLOW     DELIMITED BY '   '            
                  ','                                                   
                  S-LOC-OFFICE            DELIMITED BY '   '            
                  ','                                                   
                  S-SVC-CITY              DELIMITED BY '   '            
                  ','                                                   
                  S-SVC-ZIP               DELIMITED BY '   '            
                  ','                                                   
                  S-METER-ID              DELIMITED BY '   '            
                  ','                                                   
                  S-METER-NO              DELIMITED BY '   '            
                  ','                                                   
                  S-METER-TYPE-ID         DELIMITED BY '   '            
                  ','                                                   
                  S-FIELD-NOT-USE2        DELIMITED BY '   '            
                  ','                                                   
                  S-AMI-VENDOR            DELIMITED BY '   '            
                  ','                                                   
                  S-CONSTANT-KWH          DELIMITED BY '   '            
                  ','                                                   
                  S-CONSTANT-KW           DELIMITED BY '   '            
                  ','                                                   
                  S-CONSTANT-KVA          DELIMITED BY '   '            
                  ','                                                   
                  S-METER-STATUS          DELIMITED BY '   '            
                  ','                                                   
                  S-ELEC-MTR-CLASS-CD     DELIMITED BY '   '            
                  ','                                                   
                  S-ELEC-MTR-SPEC-CD      DELIMITED BY '   '            
                  ','                                                   
                  S-MTR-SERIAL-NO         DELIMITED BY '   '            
                  ','                                                   
                  S-METER-SUPPLYING       DELIMITED BY '   '            
                  ','                                                   
                  S-POINT-ID              DELIMITED BY '   '            
                  ','                                                   
                  S-CODE-REVENUE-CLASS    DELIMITED BY '   '            
                  ','                                                   
                  S-RATE-PLAN-NO          DELIMITED BY '   '            
                  ','                                                   
                  S-READ-ROUTE            DELIMITED BY '   '            
                  ','                                                   
                  S-MTR-INSTALL-DTTM      DELIMITED BY '   '            
                  ','                                                   
                  S-MTR-CUSTOM-DATA       DELIMITED BY '   '            
                  ','                                                   
                  S-SECU-RATE-FLAG        DELIMITED BY '   '            
                  ','                                                   
                  S-RECORDER-ID           DELIMITED BY '   '            
              INTO FIOBW58 WITH POINTER FIOBW58-LEN                     
           END-STRING.                                                  
      *                                                                         
           COMPUTE FIOBW58-LEN = FIOBW58-LEN - 1                        
      *                                                                         
           PERFORM 8000-WRITE-FIOBW58   THRU 8000-EXIT.                 
      *                                                                         
       3900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      ** 4000-MAIL-NAME-ADDRESS.                                                
      *================================================================*        
      **** INCLUDE COPY BOOK TO RETRIEVE NAMES AND ADDRESSES     **             
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
      ** 6010-REDUCE-EMBEDDED-SPACES.                                           
      *================================================================*        
       COPY CPD00004.                                                           
      *                                                                         
      *================================================================*        
       7210-OPEN-INTF-CSR.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN INTF_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW159 ERROR ******************'  
              DISPLAY '** ERROR IN  7210-OPEN-INTF-CSR             **'  
              DISPLAY '** MTR_READ_SOURCE_CD IN (R, M)'                 
              DISPLAY '** CODE_METER_STATUS <> K'                       
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7220-FETCH-INTF-CSR.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH FROM INTF_CSR                                      
               INTO :1D-SERVICE-POINT-ID                                
                   ,:1D-ACCOUNT-NO                                      
                   ,:1D-METER-NO                                        
                   ,:1D-CODE-ACCT-STAT                                  
                   ,:1D-CODE-METER-STATUS                               
                   ,:1D-MTR-SERIAL-NO                                   
                   ,:1D-DEVICE-NO                                       
                   ,:1D-LOCAL-OFFICE                                    
                   ,:1D-READ-ROUTE                                      
                   ,:1D-BILL-CYCLE                                      
                   ,:1D-CODE-REVENUE-CLASS                              
                   ,:1D-RATE-PLAN-NO                                    
                   ,:1D-DIGTL-MTR-TYPE                                  
                   ,:1D-PROGRAM-ID                                      
                   ,:1D-REMOTE-READ-IND                                 
                   ,:1D-MTR-READ-SOURCE-CD                              
                   ,:1D-CONSTANT                                        
                   ,:1D-POINT-ID                                        
                   ,:1D-IDR-IDENT-NO                                    
                   ,:1D-ELEC-MTR-CLASS-CD                               
                   ,:1D-ELEC-MTR-SPEC-CD                                
                   ,:1D-METER-SUPPLYING                                 
                   ,:1D-SECURED-RATE-FL                                 
                   ,:1D-LAST-SYNC-DATE                                  
                   ,:1D-LAST-UPDATE-PGM-ID                              
                   ,:1D-LAST-UPDATE-TS                                  
                   ,:1D-TEMP-DATA                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 SET NO-MORE-SERVICE-POINTS   TO TRUE                   
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE      
                 DISPLAY '************ PCSBW159 ERROR ****************' 
                 DISPLAY '** ERROR IN 7220-FETCH-INTF-CSR           **' 
                 DISPLAY '** MTR_READ_SOURCE_CD IN (R, M)'              
                 DISPLAY '** CODE_METER_STATUS <> K'                    
                 DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE    
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND  THRU 9900-EXIT                     
           END-EVALUATE.                                                
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7230-CLOSE-INTF-CSR.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE INTF_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSBW159 ERROR ******************'  
              DISPLAY '** ERROR IN 7230-CLOSE-INTF-CSR             **'  
              DISPLAY '** SQL CODE         = ' WS-DISPLAY-SQLCODE       
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7240-GET-CURR-TMSTMP.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURR-TMSTMP,
              :WS-CURR-DATE                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURR-TMSTMP = CURRENT TIMESTAMP                           
MFA-TR*          ,:WS-CURR-DATE   = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW159 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN 7240-GET-CURR-TMSTMP    **'        
              DISPLAY '**   GET CURRENT TIMESTAMP            **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7250-GET-SERVICE-DATES.                                          
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
             SELECT DATE_UTIL_SVC_STRT                                  
                   ,DATE_UTIL_SVC_END                                   
                   ,CUSTOMER_NO                                         
               INTO :CH-DATE-UTIL-SVC-STRT                              
                   ,:CH-DATE-UTIL-SVC-END :WS-NULL-IND-FIN               
                   ,:CH-CUSTOMER-NO                                     
               FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO = :CH-ACCOUNT-NO                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE_UTIL_SVC_STRT                                          
MFA-TR*            ,DATE_UTIL_SVC_END                                           
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*        INTO :CH-DATE-UTIL-SVC-STRT                                      
MFA-TR*            ,:CH-DATE-UTIL-SVC-END:WS-NULL-IND-FIN                       
MFA-TR*            ,:CH-CUSTOMER-NO                                             
MFA-TR*        FROM CSS_CUST_PREM_HIST                                          
MFA-TR*       WHERE ACCOUNT_NO = :CH-ACCOUNT-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-FIN < 0                                    
                 MOVE SPACES         TO CH-DATE-UTIL-SVC-END            
              END-IF                                                    
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '*****************************************'      
               DISPLAY '**  SELECT FROM CSS_EQUIPMENT          **'      
               DISPLAY '** ACCOUNT_NO = ' AT-ACCOUNT-NO                 
               DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE        
               DISPLAY '**      PROCESSING TERMINATED          **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
               DISPLAY '*****************************************'      
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7260-GET-MTR-STATUS-DATES.                                       
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
             SELECT DATE_MTR_INSTALL                                    
                   ,MTR_STATUS_CHNG_DT                                  
                   ,METER_INACTIVE_DT                                   
                   ,METER_REMOVED_DT                                    
              INTO :MN-DATE-MTR-INSTALL                                 
                  ,:MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-STC               
                  ,:MN-METER-INACTIVE-DT :WS-NULL-IND-IAC                
                  ,:MN-METER-REMOVED-DT :WS-NULL-IND-REM                 
               FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO      = :MN-ACCOUNT-NO                    
                AND CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE                
                AND IC_NO           = :MN-IC-NO                         
                AND MTR_REF_NO      = :MN-MTR-REF-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE_MTR_INSTALL                                            
MFA-TR*            ,MTR_STATUS_CHNG_DT                                          
MFA-TR*            ,METER_INACTIVE_DT                                           
MFA-TR*            ,METER_REMOVED_DT                                            
MFA-TR*       INTO :MN-DATE-MTR-INSTALL                                         
MFA-TR*           ,:MN-MTR-STATUS-CHNG-DT:WS-NULL-IND-STC                       
MFA-TR*           ,:MN-METER-INACTIVE-DT:WS-NULL-IND-IAC                        
MFA-TR*           ,:MN-METER-REMOVED-DT:WS-NULL-IND-REM                         
MFA-TR*        FROM CSS_MTRD_ENVRNMT                                            
MFA-TR*       WHERE ACCOUNT_NO      = :MN-ACCOUNT-NO                            
MFA-TR*         AND CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE                        
MFA-TR*         AND IC_NO           = :MN-IC-NO                                 
MFA-TR*         AND MTR_REF_NO      = :MN-MTR-REF-NO                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7260                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-STC < 0                                    
                 MOVE SPACES                 TO MN-MTR-STATUS-CHNG-DT   
              END-IF                                                    
              IF WS-NULL-IND-IAC < 0                                    
                 MOVE SPACES                 TO MN-METER-INACTIVE-DT    
              END-IF                                                    
              IF WS-NULL-IND-REM < 0                                    
                 MOVE SPACES                 TO MN-METER-REMOVED-DT     
              END-IF                                                    
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '*****************************************'      
               DISPLAY '**  SELECT FROM CSS_METER_ATTCHMTS     **'      
               DISPLAY '** ACCOUNT_NO      = ' MN-ACCOUNT-NO            
               DISPLAY '** CODE_UTIL_TYPE  = ' MN-CODE-UTIL-TYPE        
               DISPLAY '** IC_NO           = ' MN-IC-NO                 
               DISPLAY '** MTR_REF_NO      = ' MN-MTR-REF-NO            
               DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE        
               DISPLAY '**      PROCESSING TERMINATED          **'      
               PERFORM 9900-ABEND                THRU 9900-EXIT         
               DISPLAY '*****************************************'      
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      *                                                                         
      *================================================================*        
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
       COPY CPD00040.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
       COPY CPD00037.                                                           
      *================================================================*        
      *                                                                         
      *==============================================================*  20231000
      * 7600-START-FCSJC01                    *                                 
      *==============================================================*  20231000
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*  20231000
      * 7620-START-FCSCA00 VSAM CTRL FILE     *                                 
      *==============================================================*  20231000
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       8000-WRITE-FIOBW58.                                              
      *================================================================*        
      *                                                                         
           MOVE SPACES            TO FIOBW58-REC.                       
           WRITE FIOBW58-REC FROM FIOBW58.                              
      *                                                                         
           IF FBW58-SUCCESSFUL                                          
              ADD 1                TO WS-FCSBW58-REC-CNTR               
           ELSE                                                         
               DISPLAY '8000-ERROR ON FCSBW58 WRITE.  STATUS IS '       
                        WS-FBW58-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       9000-TERMINATE.                                                  
      *===============================================================*         
      *                                                                         
           CLOSE FCSBW58-FILE.                                          
      *                                                                         
           IF FBW58-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSBW159 PROCESSING ERROR           **'     
               DISPLAY '**  CLOSE ERROR  - OUTPUT FILES         **'     
               DISPLAY '**  FILE STATUS = ' WS-FBW58-STATUS             
               DISPLAY '**  UNSUCCESSFUL CLOSE OF FCSBW50-FILE  **'     
           END-IF.                                                      
      *                                                                         
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
           DISPLAY '** TOTAL RECS PROCESSED FROM BW58 = '               
                                 WS-FCSBW58-REC-CNTR.                   
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      ****************************************************************          
      * 9700-PROCESS-ABEND  (REQUIED BY CPD00040)                    *          
      ****************************************************************          
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND INCLUDES SQL ROLLBACK   ****           
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
