       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW152.                                        
       INSTALLATION.                                                    
       DATE-WRITTEN.   JUN 2011.                                        
           DATE-COMPILED.                                               
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                     DB2                        *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** =====      ========      ======                             **         
      ** 06/15/11   NC94746       DEVELOPMENT OF NEW PROGRAM         **         
PRJ914** 05/20/16   NC94746       CHECK SO REMOVE ORDER TO SEND      **         
      **                          REMOVE METER TRANSACTIONS TO IEE.  **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSBW152 NARRATIVE                        
      *                                                                         
           THIS PROGRAM FETCHES SERVICE POINTS FROM MDM & SS INTERFACE  
           TABLES AND EXAMINE VARIOUS CIS TABLES WHEN DAILY SYNCH UP    
           PROCESS NOT ABLE TO SYNCH DUE TO METER CHANGES ACROSS READ   
           SOURCES.                                                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW152'.
MSQ017     COPY MFASQLM.
       01  WS-START                     PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSBW152 STARTS HERE'.            
      *                                                                         
      ***************************************************************           
      * FCA00-KEY          *                                                    
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      * IO AREA FOR PARM INPUT FILE 'A' *                                       
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *    DB2 TABLE DCLGENS USING IN THIS PROGRAM                              
      *****************************************************************         
      *---------------------------------------------------------------*         
      * CSS_ACCOUNT (AT)                                                        
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_MTRD_ENVRNMT (MN)                                                   
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_UTIL_ENVRNMT (UT)                                                   
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_EQUIPMENT (EQ)                                                      
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_JOB_PARM (G6)                                                       
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_METER_ATTCHMTS (MA)                                                 
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_IDR_ACCT_MTR (L7)                                                   
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBIDRATM                                                 
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_RATE_PLAN_DESC (RD)                                                 
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_PIM_POINT (PP)                                                      
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBPIMPNT                                                 
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_ELEC_METER (EM)                                                     
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_MTR_CAP (MC)                                                        
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_MDM_SS_INTF (1D)                                                    
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBMDMINT                                                 
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_MDM_SS_INTF_CH (1E)                                                 
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBMDMCHG                                                 
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_PREMISE (PR)                                                        
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
PRJ914*---------------------------------------------------------------*         
PRJ914* CSS_SO_DATA     (VO)                                                    
PRJ914*---------------------------------------------------------------*         
PRJ914     EXEC SQL                                                             
PRJ914        INCLUDE TBSODAT                                                   
PRJ914     END-EXEC.                                                            
PRJ914*                                                                         
PRJ914*---------------------------------------------------------------*         
PRJ914* CSS_SO_ORDER_INST (VI)                                                  
PRJ914*---------------------------------------------------------------*         
PRJ914     EXEC SQL                                                             
PRJ914        INCLUDE TBSOODR                                                   
PRJ914     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       01 WS-INTF-CHNG-TAB.                                             
          05 WS-INTF-CHNG-ROW  OCCURS 50 TIMES.                         
             10 WS-COLUMN-NA            PIC X(30).                      
             10 WS-PREV-COLUMN-VALUE    PIC X(50).                      
             10 WS-CURR-COLUMN-VALUE    PIC X(50).                      
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-YES                    PIC X(01)  VALUE 'Y'.            
          05 WS-Y                      PIC X(01)  VALUE 'Y'.            
          05 WS-N                      PIC X(01)  VALUE 'N'.            
          05 WS-U                      PIC X(01)  VALUE 'U'.            
          05 WS-I                      PIC X(01)  VALUE 'I'.            
          05 WS-NO                     PIC X(01)  VALUE 'N'.            
          05 WS-PGRMNAME               PIC X(08)  VALUE 'PCSBW152'.     
          05 PROGRAM-NAME              PIC X(08)  VALUE 'PCSBW152'.     
          05 RS-RETURN-CODE            PIC S9(09) VALUE +000 COMP.      
          05 RS-RETURN-CODE-DISP       PIC S9(09) VALUE +000 COMP.      
          05 WS-DB2-LOW-DATE           PIC X(10) VALUE '0001-01-01'.    
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 WS-ENTITY-CHNGS-SW        PIC 9(01).                       
             88 ENTITY-CHNGS-CHK-REQ              VALUE 0.              
             88 NO-MORE-ENTITY-CHNGS              VALUE 1.              
          05 WS-INTF-DATA-UPD-SW       PIC 9(01).                       
             88 INTF-DATA-UPD-REQ                 VALUE 0.              
             88 INTF-DATA-UPD-NOT-REQ             VALUE 1.              
          05 WS-ACC-CHNG-SW            PIC X(01)  VALUE 'N'.            
             88 NOT-SAME-ACCOUNT                  VALUE 'N'.            
             88 SAME-ACCOUNT                      VALUE 'Y'.            
          05 WS-CPD99-MATCH-SW         PIC X(01)  VALUE 'A'.            
             88 CPD99-NOT-EXECUTED                VALUE 'A'.            
             88 CPD99-EXECUTED                    VALUE 'B', 'C'.       
             88 LATEST-ACCOUNT                    VALUE 'B'.            
             88 NOT-LATEST-ACCOUNT                VALUE 'C'.            
PRJ914    05 WS-MTR-CHNG-SW            PIC X(01)  VALUE 'N'.            
PRJ914       88 NO-METER-CHANGED                  VALUE 'N'.            
PRJ914       88 METER-CHANGED                     VALUE 'Y'.            
PRJ914    05 WS-MTR-REMOVED-SW         PIC X(01)  VALUE 'N'.            
PRJ914       88 NO-METER-REMOVED                  VALUE 'N'.            
PRJ914       88 METER-REMOVED                     VALUE 'Y'.            
      *                                                                         
       01 WS-WORK-AREA.                                                 
          05 WS-SYNC-DATE                PIC X(10).                     
          05 WS-SYNC-DATE-MINUS1         PIC X(10).                     
          05 WS-CURR-DATE                PIC X(10).                     
          05 WS-CURR-TMST                PIC X(26).                     
          05 WS-HLD-COLUMN-NA            PIC X(30).                     
          05 WS-HLD-PREV-COLUMN-VALUE    PIC X(50).                     
          05 WS-HLD-CURR-COLUMN-VALUE    PIC X(50).                     
          05 SUB                        PIC 9(02)  VALUE ZEROS.         
          05 INTF-SUB                   PIC 9(02)  VALUE ZEROS.         
          05 WS-GIS-POINT-ID            PIC 9(10)  VALUE ZEROS.         
          05 WS-POINT-ID.                                               
             10 WS-AREA-ID              PIC X(03)  VALUE SPACES.        
             10 WS-TAG-NM               PIC X(07)  VALUE SPACES.        
          05 WS-IDR-IDENT-NO            PIC X(20)  VALUE ZEROS.         
          05 WS-CODE-ACCT-STAT          PIC X(01)  VALUE ZEROS.         
          05 WS-CODE-METER-STATUS       PIC X(01)  VALUE ZEROS.         
          05 WS-SERVICE-POINT-ID.                                       
             10 WS-COMPANY-NO           PIC X(02)  VALUE SPACES.        
             10 WS-PREMISE-NO           PIC 9(10)  VALUE ZEROES.        
             10 WS-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.        
             10 WS-IC-NO                PIC 9(04)  VALUE ZEROES.        
             10 WS-MTR-REF-NO           PIC 9(04)  VALUE ZEROES.        
          05 WS-ACCOUNT-NO              PIC 9(13)  VALUE ZERO.          
          05 WS-PRIOR-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE ZERO.  
          05 WS-INTF-REC-CNTR           PIC S9(09) COMP VALUE ZERO.     
          05 WS-DISPLAY-SQLCODE         PIC ---9.                       
          05 WS-DISPLAY-CONSTANT        PIC 999999.999.                 
      *                                                                         
      * ABEND SWITCH         *                                                  
       COPY CWS09900.                                                           
      * WARNING DATA         *                                                  
       COPY CWS00303.                                                           
      * WS ABEND WORK AREA   *                                                  
       COPY CWS00010.                                                           
       COPY CWS00074.                                                           
       COPY CWS00011.                                                           
      * MISC INPUT           *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *** REDEFINES CONTINUE FROM CWS00038                                      
       01 WS-SYNC-DATE-PARM REDEFINES WS-INPUT-DATA-BREAKDOWN.          
          05 WS-SYNC-DATE-TXT               PIC  X(15).                 
             88 LAST-SYNC-TEXT           VALUE 'LAST-SYNC-DATE='.       
          05 WS-PARM-SYNC-DATE              PIC  X(10).                 
          05 FILLER                         PIC  X(55).                 
      *                                                                         
      * FCA00 MISC INPUT     *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      * WOKING STORAGE FOR CPDCA099                                             
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSBW152 ENDS HERE  '.            
      *                                                                         
      ******************* BEGIN CURSOR DECLARATION ********************         
      *                                                                         
      **************************************                                    
      **  CURSOR DECLARATION -- INTF_CSR **                                     
      **************************************                                    
           EXEC SQL                                                     
            DECLARE INTF_CSR CURSOR FOR                                 
             SELECT [1D].SERVICE_POINT_ID                                 
                   ,[1D].ACCOUNT_NO                                       
                   ,[1D].METER_NO                                         
                   ,[1D].CODE_ACCT_STAT                                   
                   ,[1D].CODE_METER_STATUS                                
                   ,[1D].MTR_SERIAL_NO                                    
                   ,[1D].DEVICE_NO                                        
                   ,[1D].LOCAL_OFFICE                                     
                   ,[1D].READ_ROUTE                                       
                   ,[1D].BILL_CYCLE                                       
                   ,[1D].CODE_REVENUE_CLASS                               
                   ,[1D].RATE_PLAN_NO                                     
                   ,[1D].DIGTL_MTR_TYPE                                   
                   ,[1D].PROGRAM_ID                                       
                   ,[1D].REMOTE_READ_IND                                  
                   ,[1D].MTR_READ_SOURCE_CD                               
                   ,[1D].CONSTANT                                         
                   ,[1D].POINT_ID                                         
                   ,[1D].IDR_IDENT_NO                                     
                   ,[1D].ELEC_MTR_CLASS_CD                                
                   ,[1D].ELEC_MTR_SPEC_CD                                 
                   ,[1D].METER_SUPPLYING                                  
                   ,[1D].SECURED_RATE_FL                                  
                   ,[1D].LAST_SYNC_DATE                                   
                   ,[1D].LAST_UPDATE_PGM_ID                               
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1D].LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS                                   
                   ,[1D].TEMP_DATA                                        
               FROM CSS_MDM_SS_INTF  [1D] WITH(READUNCOMMITTED)                 
              WHERE [1D].LAST_SYNC_DATE <= IIF(TRY_CONVERT(DATE, 
                                                   :WS-SYNC-DATE-MINUS1
              ) IS NULL OR (PATINDEX('%.%', :WS-SYNC-DATE-MINUS1
              ) <> 0) OR (LEN(:WS-SYNC-DATE-MINUS1
              ) <> 10), CIS.CHAR2DATE(:WS-SYNC-DATE-MINUS1
              ), CONVERT(DATE, :WS-SYNC-DATE-MINUS1) )           
                AND [1D].LAST_SYNC_DATE  > IIF(TRY_CONVERT(DATE, 
                                                       :WS-DB2-LOW-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DB2-LOW-DATE
              ) <> 0) OR (LEN(:WS-DB2-LOW-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-DB2-LOW-DATE
              ), CONVERT(DATE, :WS-DB2-LOW-DATE) )               
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE INTF_CSR CURSOR FOR                                         
MFA-TR*      SELECT 1D.SERVICE_POINT_ID                                         
MFA-TR*            ,1D.ACCOUNT_NO                                               
MFA-TR*            ,1D.METER_NO                                                 
MFA-TR*            ,1D.CODE_ACCT_STAT                                           
MFA-TR*            ,1D.CODE_METER_STATUS                                        
MFA-TR*            ,1D.MTR_SERIAL_NO                                            
MFA-TR*            ,1D.DEVICE_NO                                                
MFA-TR*            ,1D.LOCAL_OFFICE                                             
MFA-TR*            ,1D.READ_ROUTE                                               
MFA-TR*            ,1D.BILL_CYCLE                                               
MFA-TR*            ,1D.CODE_REVENUE_CLASS                                       
MFA-TR*            ,1D.RATE_PLAN_NO                                             
MFA-TR*            ,1D.DIGTL_MTR_TYPE                                           
MFA-TR*            ,1D.PROGRAM_ID                                               
MFA-TR*            ,1D.REMOTE_READ_IND                                          
MFA-TR*            ,1D.MTR_READ_SOURCE_CD                                       
MFA-TR*            ,1D.CONSTANT                                                 
MFA-TR*            ,1D.POINT_ID                                                 
MFA-TR*            ,1D.IDR_IDENT_NO                                             
MFA-TR*            ,1D.ELEC_MTR_CLASS_CD                                        
MFA-TR*            ,1D.ELEC_MTR_SPEC_CD                                         
MFA-TR*            ,1D.METER_SUPPLYING                                          
MFA-TR*            ,1D.SECURED_RATE_FL                                          
MFA-TR*            ,1D.LAST_SYNC_DATE                                           
MFA-TR*            ,1D.LAST_UPDATE_PGM_ID                                       
MFA-TR*            ,1D.LAST_UPDATE_TS                                           
MFA-TR*            ,1D.TEMP_DATA                                                
MFA-TR*        FROM CSS_MDM_SS_INTF  1D                                         
MFA-TR*       WHERE 1D.LAST_SYNC_DATE <= :WS-SYNC-DATE-MINUS1                   
MFA-TR*         AND 1D.LAST_SYNC_DATE  > :WS-DB2-LOW-DATE                       
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
      *                                                                         
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
      *                                                                         
           PERFORM 1000-PROCESS-EACH-SP    THRU 1000-EXIT               
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
      *                                                                         
           PERFORM 7040-CLOSE-INTF-CURSOR  THRU 7040-EXIT.              
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               DISPLAY 'COMMON DATE ==> ' WS-FCA00-COMMON-DATE          
               MOVE WS-FCA00-COMMON-DATE   TO WS-INPUT-DATE             
           END-IF.                                                      
      *                                                                         
           PERFORM 0120-GET-LAST-SYNC    THRU 0120-EXIT.                
           PERFORM 7200-LAST-SYNC-MINUS1 THRU 7200-EXIT.                
           PERFORM 7210-GET-CURR-TMST    THRU 7210-EXIT.                
      *                                                                         
           MOVE WS-SYNC-DATE          TO 1D-LAST-SYNC-DATE              
           MOVE PROGRAM-NAME          TO 1D-LAST-UPDATE-PGM-ID          
           MOVE WS-CURR-TMST          TO 1D-LAST-UPDATE-TS              
      *                                                                         
           DISPLAY 'WS-SYNC-DATE-MINUS1: ' WS-SYNC-DATE-MINUS1          
           DISPLAY 'WS-DB2-LOW-DATE:     ' WS-DB2-LOW-DATE              
                                                                        
      *                                                                         
           PERFORM 7000-OPEN-INTF-CURSOR  THRU 7000-EXIT.               
           PERFORM 7020-FETCH-INTF-CURSOR THRU 7020-EXIT.               
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              DISPLAY '  '                                              
              DISPLAY '****************************************'        
              DISPLAY '**                                    **'        
              DISPLAY '**   NO SERVICE POINTS TO SYNCH       **'        
              DISPLAY '**   PROGRAM ENDING SUCCESSFULLY      **'        
              DISPLAY '**                                    **'        
              DISPLAY '****************************************'        
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0120-GET-LAST-SYNC.                                              
      *================================================================*        
      *** GET SYNC DATE USED BY PCSBW151 PROGRAM FROM JOB PARM                  
      *                                                                         
           MOVE SPACES                    TO WS-SYSIPT.                 
           MOVE ZEROS                     TO WS-SEQUENCE.               
           MOVE WS-PARM                   TO WS-COMMAND.                
           MOVE 'PCSBW151'                TO WS-PROGRAM.                
           MOVE WS-KEY-AREA               TO E-FJC01-KEY.               
                                                                        
           PERFORM 7600-START-FCSJC01       THRU 7600-EXIT.             
                                                                        
           PERFORM 7610-READ-FCSJC01        THRU 7610-EXIT              
             UNTIL (LAST-SYNC-TEXT AND INPUT-ACTIVE)                    
                OR  END-OF-SYSIPT.                                      
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 0120          **'        
              DISPLAY '**   LAST SYNC DATE NOT PRESENT IN    **'        
              DISPLAY '**   CSS_JOB_PARM TABLE               **'        
              DISPLAY '**   KEY = ' E-FJC01-KEY                         
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           ELSE                                                         
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
              DISPLAY 'LAST SYNC DATE ==> ' WS-PARM-SYNC-DATE           
              MOVE WS-PARM-SYNC-DATE      TO WS-SYNC-DATE               
              MOVE PROGRAM-NAME           TO WS-PROGRAM                 
           END-IF.                                                      
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-PROCESS-EACH-SP.                                            
      *================================================================*        
      *                                                                         
           MOVE ZEROS                      TO INTF-SUB                  
           INITIALIZE          WS-INTF-CHNG-TAB                         
           DISPLAY 'PROCESSING: ' 1D-SERVICE-POINT-ID                   
                              '|' 1D-ACCOUNT-NO                         
                              '|' 1D-METER-NO                           
           COMPUTE WS-INTF-REC-CNTR = WS-INTF-REC-CNTR + 1              
      *                                                                         
           MOVE 1D-SERVICE-POINT-ID    TO WS-SERVICE-POINT-ID           
           MOVE WS-PREMISE-NO          TO WS-CPD99-PREMISE-NO           
                                          AT-PREMISE-NO                 
           MOVE WS-CODE-UTIL-TYPE      TO MN-CODE-UTIL-TYPE             
           MOVE WS-IC-NO               TO MN-IC-NO                      
           MOVE WS-MTR-REF-NO          TO MN-MTR-REF-NO                 
PRJ914     SET NO-METER-CHANGED        TO TRUE                          
      *                                                                         
           PERFORM 6990-FETCH-CUR-ACCOUNT  THRU  6990-EXIT              
           IF WS-CPD99-ACCOUNT-NO EQUAL 1D-ACCOUNT-NO                   
              MOVE 1D-ACCOUNT-NO       TO MN-ACCOUNT-NO                 
           ELSE                                                         
              MOVE WS-CPD99-ACCOUNT-NO TO MN-ACCOUNT-NO                 
           END-IF                                                       
           PERFORM 7050-GET-MTR-DETAILS THRU 7050-EXIT                  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AT-ACCOUNT-NO           TO WS-ACCOUNT-NO             
              SET ENTITY-CHNGS-CHK-REQ     TO TRUE                      
              SET INTF-DATA-UPD-NOT-REQ    TO TRUE                      
              PERFORM 1100-GET-OTHER-DETAILS    THRU 1100-EXIT          
              PERFORM 1150-FORMAT-DATA          THRU 1150-EXIT          
              PERFORM 1200-PROCESS-INTF-UPDATES THRU 1200-EXIT          
                      UNTIL NO-MORE-ENTITY-CHNGS                        
              IF INTF-DATA-UPD-REQ                                      
                 PERFORM 2100-LOAD-INTF-CHNGS    THRU 2100-EXIT         
                 PERFORM 8100-UPDATE-ALL-MS      THRU 8100-EXIT         
              ELSE                                                      
                 PERFORM 8200-UPDATE-SYNC-MS     THRU 8200-EXIT         
              END-IF                                                    
           ELSE                                                         
              PERFORM 1400-PROCESS-INTF-REMOVE  THRU 1400-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 7020-FETCH-INTF-CURSOR THRU 7020-EXIT.               
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       1100-GET-OTHER-DETAILS.                                          
      *================================================================*        
      *                                                                         
           MOVE AT-ACCOUNT-NO              TO WS-ACCOUNT-NO             
                                              MN-ACCOUNT-NO             
                                              L7-ACCOUNT-NO             
           MOVE AT-COMPANY-NO              TO EM-COMPANY-NO             
                                              MC-COMPANY-NO             
                                              MA-COMPANY-NO             
                                              EQ-COMPANY-NO             
           MOVE UT-CODE-UTIL-TYPE          TO EM-CODE-UTIL-TYPE         
                                              MC-CODE-UTIL-TYPE         
                                              MA-CODE-UTIL-TYPE         
                                              EQ-CODE-UTIL-TYPE         
                                              RD-CODE-UTIL-TYPE         
                                              L7-CODE-UTIL-TYPE         
           MOVE MN-METER-NO                TO EM-METER-NO               
                                              MC-METER-NO               
                                              MA-METER-NO               
                                              L7-METER-NO               
                                              EQ-DEVICE-NO              
           MOVE UT-RATE-PLAN-NO            TO RD-RATE-PLAN-NO           
           MOVE MN-REG-ID-NO               TO MC-REG-ID-NO              
           MOVE AT-PREMISE-NO              TO PR-PREMISE-NO             
      *                                                                         
           MOVE SPACES                     TO PR-LOCAL-OFFICE           
           PERFORM 7060-GET-LOCAL-OFFICE   THRU 7060-EXIT               
      *                                                                         
           MOVE SPACES                     TO EQ-SERIAL-NO              
           PERFORM 7100-GET-EQ-DETAILS     THRU 7100-EXIT               
      *                                                                         
           MOVE ZEROS                      TO MC-CONSTANT               
           PERFORM 7120-GET-MTR-CONSTANT   THRU 7120-EXIT               
      *                                                                         
           MOVE SPACES                     TO L7-IDR-IDENT-NO           
           MOVE SPACES                     TO MA-DEVICE-NO              
           IF MN-MTR-READ-SOURCE-CD = 'M'                               
              PERFORM 7130-GET-IDR-IDENT-NO   THRU 7130-EXIT            
           ELSE                                                         
              PERFORM 7110-GET-SS-DEVICE      THRU 7110-EXIT            
           END-IF                                                       
      *                                                                         
           MOVE SPACES                     TO EM-ELEC-MTR-CLASS-CD      
                                              EM-ELEC-MTR-SPEC-CD       
           PERFORM 7140-GET-ELEC-CLASS-SPEC THRU 7140-EXIT.             
      *                                                                         
           MOVE 'N'                        TO RD-SECURED-RATE-FL        
           PERFORM 7150-CHECK-RATE-PLAN-DESC THRU 7150-EXIT.            
      *                                                                         
           MOVE SPACES                     TO PP-AREA-ID                
                                              PP-TAG-NM.                
           IF MN-GIS-POINT-ID > 0                                       
              PERFORM 7190-GET-GIS-LOC-AND-TAG  THRU 7190-EXIT          
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1150-FORMAT-DATA.                                                
      *================================================================*        
      *                                                                         
           IF AT-CODE-ACCT-STAT = 'A'                                   
              MOVE AT-CODE-ACCT-STAT      TO WS-CODE-ACCT-STAT          
           ELSE                                                         
              MOVE 'B'                    TO WS-CODE-ACCT-STAT          
           END-IF.                                                      
      *                                                                         
           EVALUATE MN-CODE-METER-STATUS                                
              WHEN 'J'                                                  
              WHEN 'A'                                                  
              WHEN 'I'                                                  
              WHEN 'K'                                                  
                MOVE MN-CODE-METER-STATUS TO WS-CODE-METER-STATUS       
              WHEN 'B'                                                  
                MOVE 'A'                  TO WS-CODE-METER-STATUS       
              WHEN '0'                                                  
              WHEN '1'                                                  
                MOVE 'I'                  TO WS-CODE-METER-STATUS       
              WHEN OTHER                                                
                MOVE 'A'                  TO WS-CODE-METER-STATUS       
           END-EVALUATE.                                                
      *                                                                         
           MOVE SPACES                    TO WS-POINT-ID                
           MOVE PP-AREA-ID                TO WS-AREA-ID                 
           MOVE PP-TAG-NM                 TO WS-TAG-NM                  
      *                                                                         
           MOVE SPACES                    TO WS-IDR-IDENT-NO            
           IF L7-IDR-IDENT-NO (1:1) = 'T'                               
              MOVE L7-IDR-IDENT-NO (2:)   TO WS-IDR-IDENT-NO            
           ELSE                                                         
              MOVE L7-IDR-IDENT-NO        TO WS-IDR-IDENT-NO            
           END-IF.                                                      
      *                                                                         
           MOVE WS-CURR-TMST          TO 1D-LAST-UPDATE-TS.             
           MOVE PROGRAM-NAME          TO 1D-LAST-UPDATE-PGM-ID          
           MOVE WS-SYNC-DATE          TO 1D-LAST-SYNC-DATE              
      *                                                                         
           IF WS-CODE-METER-STATUS = 'K' OR                             
             NOT (MN-MTR-READ-SOURCE-CD = 'R'                           
              OR MN-MTR-READ-SOURCE-CD = 'M'                            
              OR MN-MTR-READ-SOURCE-CD = 'P')                           
              MOVE WS-DB2-LOW-DATE        TO 1D-LAST-SYNC-DATE          
           END-IF.                                                      
      *                                                                         
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1200-PROCESS-INTF-UPDATES.                                       
      *================================================================*        
      *                                                                         
           EVALUATE TRUE                                                
              WHEN AT-ACCOUNT-NO NOT = 1D-ACCOUNT-NO                    
                 PERFORM 1210-PROCESS-ACCOUNT-CHNG  THRU 1210-EXIT      
              WHEN MN-METER-NO   NOT = 1D-METER-NO                      
                 PERFORM 1220-PROCESS-METER-CHNG  THRU 1220-EXIT        
              WHEN WS-CODE-ACCT-STAT NOT = 1D-CODE-ACCT-STAT            
                 PERFORM 1230-PROCESS-ACCT-STATUS THRU 1230-EXIT        
              WHEN WS-CODE-METER-STATUS NOT = 1D-CODE-METER-STATUS      
                 PERFORM 1240-PROCESS-MTR-STATUS THRU 1240-EXIT         
              WHEN MN-PROGRAM-ID      NOT = 1D-PROGRAM-ID               
                 PERFORM 1250-PROCESS-PGM-ID     THRU 1250-EXIT         
              WHEN MN-DIGTL-MTR-TYPE  NOT = 1D-DIGTL-MTR-TYPE           
                 PERFORM 1260-PROCESS-DMT-CHNG   THRU 1260-EXIT         
              WHEN UT-RATE-PLAN-NO    NOT = 1D-RATE-PLAN-NO             
                 PERFORM 1270-PROCESS-RATE-CHNG   THRU 1270-EXIT        
              WHEN OTHER                                                
                 PERFORM 1290-PROCESS-OTHER-CHNGS THRU 1290-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1210-PROCESS-ACCOUNT-CHNG.                                       
      *================================================================*        
      *                                                                         
           MOVE 'ACCOUNT_NO'        TO WS-HLD-COLUMN-NA                 
           MOVE 1D-ACCOUNT-NO       TO WS-ACCOUNT-NO                    
           MOVE WS-ACCOUNT-NO       TO WS-HLD-PREV-COLUMN-VALUE         
           MOVE AT-ACCOUNT-NO       TO WS-ACCOUNT-NO                    
           MOVE WS-ACCOUNT-NO       TO WS-HLD-CURR-COLUMN-VALUE         
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT               
           MOVE AT-ACCOUNT-NO         TO 1D-ACCOUNT-NO.                 
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1220-PROCESS-METER-CHNG.                                         
      *================================================================*        
      *                                                                         
PRJ914     SET METER-CHANGED        TO TRUE                             
           MOVE 'METER_NO'          TO WS-HLD-COLUMN-NA                 
           MOVE 1D-METER-NO         TO WS-HLD-PREV-COLUMN-VALUE         
           MOVE MN-METER-NO         TO WS-HLD-CURR-COLUMN-VALUE         
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT               
           MOVE MN-METER-NO              TO 1D-METER-NO.                
      *                                                                         
       1220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1230-PROCESS-ACCT-STATUS.                                        
      *================================================================*        
      *                                                                         
           MOVE 'CODE_ACCT_STAT'       TO WS-HLD-COLUMN-NA              
           MOVE 1D-CODE-ACCT-STAT      TO WS-HLD-PREV-COLUMN-VALUE      
           MOVE WS-CODE-ACCT-STAT      TO WS-HLD-CURR-COLUMN-VALUE      
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT.              
      *                                                                         
           MOVE WS-CODE-ACCT-STAT      TO 1D-CODE-ACCT-STAT.            
      *                                                                         
       1230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1240-PROCESS-MTR-STATUS.                                         
      *================================================================*        
      *                                                                         
PRJ914     SET NO-METER-REMOVED        TO TRUE                          
PRJ914     IF WS-CODE-METER-STATUS = 'K' AND NO-METER-CHANGED           
PRJ914        MOVE AT-PREMISE-NO           TO VO-PREMISE-NO             
PRJ914        MOVE MN-METER-NO               TO VI-METER-NO             
PRJ914        PERFORM 7160-CHECK-SO-MTR-REMOVE  THRU 7160-EXIT          
PRJ914     END-IF.                                                      
                                                                        
PRJ914     IF METER-REMOVED                                             
              MOVE 'CODE_METER_STATUS'     TO WS-HLD-COLUMN-NA          
              MOVE 1D-CODE-METER-STATUS    TO WS-HLD-PREV-COLUMN-VALUE  
              MOVE WS-CODE-METER-STATUS    TO WS-HLD-CURR-COLUMN-VALUE  
      *                                                                         
              PERFORM 2000-STORE-INTF-CHNG THRU 2000-EXIT               
              MOVE WS-CODE-METER-STATUS    TO 1D-CODE-METER-STATUS      
PRJ914     ELSE                                                         
PRJ914        MOVE 1D-CODE-METER-STATUS    TO WS-CODE-METER-STATUS      
PRJ914**      SET INTF-DATA-UPD-REQ        TO TRUE                              
PRJ914        MOVE WS-SYNC-DATE            TO 1D-LAST-SYNC-DATE         
PRJ914     END-IF.                                                      
      *                                                                         
      *                                                                         
       1240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1250-PROCESS-PGM-ID.                                             
      *================================================================*        
      *                                                                         
           MOVE 'PROGRAM_ID'              TO WS-HLD-COLUMN-NA           
           MOVE 1D-PROGRAM-ID             TO WS-HLD-PREV-COLUMN-VALUE   
           MOVE MN-PROGRAM-ID             TO WS-HLD-CURR-COLUMN-VALUE   
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT.              
      *                                                                         
           MOVE MN-PROGRAM-ID             TO 1D-PROGRAM-ID.             
      *                                                                         
       1250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1260-PROCESS-DMT-CHNG.                                           
      *================================================================*        
      *                                                                         
           MOVE 'DIGTL_MTR_TYPE'          TO WS-HLD-COLUMN-NA           
           MOVE 1D-DIGTL-MTR-TYPE         TO WS-HLD-PREV-COLUMN-VALUE   
           MOVE MN-DIGTL-MTR-TYPE    TO WS-HLD-CURR-COLUMN-VALUE        
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT.              
      *                                                                         
           MOVE MN-DIGTL-MTR-TYPE         TO 1D-DIGTL-MTR-TYPE.         
      *                                                                         
       1260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1270-PROCESS-RATE-CHNG.                                          
      *================================================================*        
      *                                                                         
           MOVE 'RATE_PLAN_NO'            TO WS-HLD-COLUMN-NA           
           MOVE 1D-RATE-PLAN-NO           TO WS-HLD-PREV-COLUMN-VALUE   
           MOVE UT-RATE-PLAN-NO           TO WS-HLD-CURR-COLUMN-VALUE   
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT.              
      *                                                                         
           MOVE UT-RATE-PLAN-NO           TO 1D-RATE-PLAN-NO.           
           MOVE RD-SECURED-RATE-FL        TO 1D-SECURED-RATE-FL.        
      *                                                                         
       1270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1290-PROCESS-OTHER-CHNGS.                                        
      *================================================================*        
      *                                                                         
           EVALUATE TRUE                                                
              WHEN MN-MTR-READ-SOURCE-CD NOT = 1D-MTR-READ-SOURCE-CD    
                 MOVE 'MTR_READ_SOURCE_CD' TO WS-HLD-COLUMN-NA          
                 MOVE 1D-MTR-READ-SOURCE-CD                             
                                          TO WS-HLD-PREV-COLUMN-VALUE   
                 MOVE MN-MTR-READ-SOURCE-CD                             
                                          TO WS-HLD-CURR-COLUMN-VALUE   
                                             1D-MTR-READ-SOURCE-CD      
              WHEN MN-REMOTE-READ-IND NOT = 1D-REMOTE-READ-IND          
                 MOVE 'REMOTE_READ_IND'   TO WS-HLD-COLUMN-NA           
                 MOVE 1D-REMOTE-READ-IND  TO WS-HLD-PREV-COLUMN-VALUE   
                 MOVE MN-REMOTE-READ-IND  TO WS-HLD-CURR-COLUMN-VALUE   
                                             1D-REMOTE-READ-IND         
              WHEN MC-CONSTANT         NOT = 1D-CONSTANT                
                 MOVE 'CONSTANT'          TO WS-HLD-COLUMN-NA           
                 MOVE 1D-CONSTANT         TO WS-DISPLAY-CONSTANT        
                 MOVE WS-DISPLAY-CONSTANT TO WS-HLD-PREV-COLUMN-VALUE   
                 MOVE MC-CONSTANT         TO WS-DISPLAY-CONSTANT        
                 MOVE WS-DISPLAY-CONSTANT TO WS-HLD-CURR-COLUMN-VALUE   
                 MOVE MC-CONSTANT         TO 1D-CONSTANT                
              WHEN PR-LOCAL-OFFICE    NOT = 1D-LOCAL-OFFICE             
                 MOVE 'LOCAL_OFFICE'       TO WS-HLD-COLUMN-NA          
                 MOVE 1D-LOCAL-OFFICE      TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE PR-LOCAL-OFFICE      TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-LOCAL-OFFICE           
              WHEN UT-READ-ROUTE      NOT = 1D-READ-ROUTE               
                 MOVE 'READ_ROUTE'         TO WS-HLD-COLUMN-NA          
                 MOVE 1D-READ-ROUTE        TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE UT-READ-ROUTE        TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-READ-ROUTE             
              WHEN AT-BILL-CYCLE      NOT = 1D-BILL-CYCLE               
                 MOVE 'BILL_CYCLE'         TO WS-HLD-COLUMN-NA          
                 MOVE 1D-BILL-CYCLE        TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE AT-BILL-CYCLE        TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-BILL-CYCLE             
              WHEN UT-CODE-REVENUE-CLASS NOT = 1D-CODE-REVENUE-CLASS    
                 MOVE 'CODE_REVENUE_CLASS' TO WS-HLD-COLUMN-NA          
                 MOVE 1D-CODE-REVENUE-CLASS                             
                                          TO WS-HLD-PREV-COLUMN-VALUE   
                 MOVE UT-CODE-REVENUE-CLASS                             
                                          TO WS-HLD-CURR-COLUMN-VALUE   
                                             1D-CODE-REVENUE-CLASS      
              WHEN RD-SECURED-RATE-FL NOT = 1D-SECURED-RATE-FL          
                 MOVE 'SECURED_RATE_FL'    TO WS-HLD-COLUMN-NA          
                 MOVE 1D-SECURED-RATE-FL   TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE RD-SECURED-RATE-FL   TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-SECURED-RATE-FL        
              WHEN WS-POINT-ID           NOT = 1D-POINT-ID              
                 MOVE 'POINT_ID'           TO WS-HLD-COLUMN-NA          
                 MOVE 1D-POINT-ID          TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE WS-POINT-ID          TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-POINT-ID               
              WHEN WS-IDR-IDENT-NO       NOT = 1D-IDR-IDENT-NO          
                 MOVE 'IDR_IDENT_NO'       TO WS-HLD-COLUMN-NA          
                 MOVE 1D-IDR-IDENT-NO      TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE WS-IDR-IDENT-NO      TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-IDR-IDENT-NO           
              WHEN EM-ELEC-MTR-CLASS-CD  NOT = 1D-ELEC-MTR-CLASS-CD     
                 MOVE 'ELEC_MTR_CLASS_CD'  TO WS-HLD-COLUMN-NA          
                 MOVE 1D-ELEC-MTR-CLASS-CD TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE EM-ELEC-MTR-CLASS-CD TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-ELEC-MTR-CLASS-CD      
              WHEN EM-ELEC-MTR-SPEC-CD   NOT = 1D-ELEC-MTR-SPEC-CD      
                 MOVE 'ELEC_MTR_SPEC_CD'   TO WS-HLD-COLUMN-NA          
                 MOVE 1D-ELEC-MTR-SPEC-CD  TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE EM-ELEC-MTR-SPEC-CD  TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-ELEC-MTR-SPEC-CD       
              WHEN MN-METER-SUPPLYING    NOT = 1D-METER-SUPPLYING       
                 MOVE 'METER_SUPPLYING'    TO WS-HLD-COLUMN-NA          
                 MOVE 1D-METER-SUPPLYING   TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE MN-METER-SUPPLYING   TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-METER-SUPPLYING        
              WHEN MA-DEVICE-NO          NOT = 1D-DEVICE-NO             
                 MOVE 'DEVICE_NO'          TO WS-HLD-COLUMN-NA          
                 MOVE 1D-DEVICE-NO         TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE MA-DEVICE-NO         TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-DEVICE-NO              
              WHEN EQ-SERIAL-NO          NOT = 1D-MTR-SERIAL-NO         
                 MOVE 'MTR_SERIAL_NO'      TO WS-HLD-COLUMN-NA          
                 MOVE 1D-MTR-SERIAL-NO     TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE EQ-SERIAL-NO         TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-MTR-SERIAL-NO          
              WHEN OTHER                                                
                 SET NO-MORE-ENTITY-CHNGS  TO TRUE                      
                 MOVE SPACES               TO WS-HLD-COLUMN-NA          
                                              WS-HLD-PREV-COLUMN-VALUE  
                                              WS-HLD-CURR-COLUMN-VALUE  
           END-EVALUATE.                                                
      *                                                                         
           IF WS-HLD-COLUMN-NA > SPACES                                 
              PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT            
           END-IF.                                                      
      *                                                                         
       1290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1400-PROCESS-INTF-REMOVE.                                        
      *================================================================*        
      *                                                                         
           MOVE WS-COMPANY-NO          TO EQ-COMPANY-NO                 
           MOVE WS-CODE-UTIL-TYPE      TO EQ-CODE-UTIL-TYPE             
           MOVE 1D-METER-NO            TO EQ-DEVICE-NO                  
      *                                                                         
           PERFORM 7100-GET-EQ-DETAILS     THRU 7100-EXIT               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF EQ-CODE-CRNT-LOC = 'J'                                 
                 DISPLAY 'METER INVENTORY NOT MATCHES CIS:'             
                         1D-SERVICE-POINT-ID                            
              ELSE                                                      
                 SET INTF-DATA-UPD-REQ       TO TRUE                    
                 PERFORM 1450-WRITE-REMOVE-RECORD  THRU 1450-EXIT       
              END-IF                                                    
           ELSE                                                         
              DISPLAY 'SERVICE POINT DETAILS MISSING IN CIS: '          
                         1D-SERVICE-POINT-ID                            
           END-IF.                                                      
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1450-WRITE-REMOVE-RECORD.                                        
      *================================================================*        
      *                                                                         
           MOVE 'CODE_METER_STATUS'       TO 1E-COLUMN-NA               
           MOVE 1D-CODE-METER-STATUS      TO 1E-PREV-COLUMN-VALUE       
           MOVE 'K'                       TO 1E-CURR-COLUMN-VALUE       
                                             1D-CODE-METER-STATUS       
      *                                                                         
           MOVE 1D-SERVICE-POINT-ID       TO 1E-SERVICE-POINT-ID        
           MOVE WS-CURR-TMST              TO 1E-LAST-UPDATE-TS          
           MOVE PROGRAM-NAME              TO 1E-LAST-UPDATE-PGM-ID.     
      *                                                                         
           PERFORM 8500-INSERT-INTF-CH    THRU 8500-EXIT.               
      *                                                                         
           MOVE WS-DB2-LOW-DATE        TO 1D-LAST-SYNC-DATE             
           PERFORM 8300-UPDATE-MTR-STATUS  THRU 8300-EXIT.              
      *                                                                         
       1450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2000-STORE-INTF-CHNG.                                            
      *================================================================*        
      *                                                                         
           SET INTF-DATA-UPD-REQ       TO TRUE                          
           COMPUTE INTF-SUB = INTF-SUB + 1                              
           IF INTF-SUB > 50                                             
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 2000          **'        
              DISPLAY '**   ARRY OVER-FLOW OCCUR             **'        
              DISPLAY '**   MORE THAN 50 CHANGES FOUND FOR   **'        
              DISPLAY '**   SERVICE-POINT = ' 1D-SERVICE-POINT-ID       
              DISPLAY '**   ACCOUNT-NO    = ' WS-ACCOUNT-NO             
              DISPLAY '**   METER-NO      = ' MN-METER-NO               
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
           MOVE WS-HLD-COLUMN-NA                                        
                                 TO  WS-COLUMN-NA (INTF-SUB)            
           MOVE WS-HLD-PREV-COLUMN-VALUE                                
                                 TO WS-PREV-COLUMN-VALUE(INTF-SUB)      
           MOVE WS-HLD-CURR-COLUMN-VALUE                                
                                 TO WS-CURR-COLUMN-VALUE(INTF-SUB).     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2100-LOAD-INTF-CHNGS.                                            
      *================================================================*        
      *                                                                         
           MOVE 1D-SERVICE-POINT-ID TO 1E-SERVICE-POINT-ID              
           MOVE WS-CURR-TMST        TO 1E-LAST-UPDATE-TS                
           MOVE PROGRAM-NAME        TO 1E-LAST-UPDATE-PGM-ID            
      *                                                                         
           PERFORM VARYING INTF-SUB FROM 1 BY 1 UNTIL INTF-SUB > 50     
                      OR WS-COLUMN-NA (INTF-SUB) = SPACES               
              MOVE WS-COLUMN-NA (INTF-SUB) TO 1E-COLUMN-NA              
              MOVE WS-PREV-COLUMN-VALUE(INTF-SUB)                       
                                           TO 1E-PREV-COLUMN-VALUE      
              MOVE WS-CURR-COLUMN-VALUE(INTF-SUB)                       
                                           TO 1E-CURR-COLUMN-VALUE      
              PERFORM 8500-INSERT-INTF-CH  THRU 8500-EXIT               
           END-PERFORM.                                                 
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
       COPY CPD00040.                                                           
      *                                                                         
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
       COPY CPD00037.                                                           
      *                                                                         
      *==============================================================*  20231000
      * 6990-FETCH-CUR-ACCOUNT                                       *          
      *==============================================================*  20231000
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.           *          
      *--------------------------------------------------------------*  20231000
           EXEC SQL                                                             
                INCLUDE CPDCA099                                                
           END-EXEC.                                                            
      *                                                                 20231000
      *==============================================================*  20231000
       6995-CPD99-ERROR-ROUTINE.                                        
      *==============================================================*  20231000
      *                                                                 20231000
           MOVE ZEROES                     TO  WS-CPD99-ACCOUNT-NO.     
      *                                                                 20231000
           DISPLAY '****************** PCSBW150 ***************'.       
           DISPLAY '* ERROR IN PARA ', ACTIVE-PARAGRAPH                 
           DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO               
           DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE               
           DISPLAY '*******************************************'.       
           PERFORM 9900-ABEND     THRU  9900-EXIT.                      
      *                                                                 20231000
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7000-OPEN-INTF-CURSOR.                                           
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               OPEN INTF_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7000          **'        
              DISPLAY '**   LAST_SYNC_DATE <=' WS-SYNC-DATE-MINUS1      
              DISPLAY '**   LAST_SYNC_DATE  > 0001-01-01'               
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7020-FETCH-INTF-CURSOR.                                          
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             FETCH  INTF_CSR                                            
               INTO :1D-SERVICE-POINT-ID                                
                   ,:1D-ACCOUNT-NO                                      
                   ,:1D-METER-NO                                        
                   ,:1D-CODE-ACCT-STAT                                  
                   ,:1D-CODE-METER-STATUS                               
                   ,:1D-MTR-SERIAL-NO                                   
                   ,:1D-DEVICE-NO                                       
                   ,:1D-LOCAL-OFFICE                                    
                   ,:1D-READ-ROUTE                                      
                   ,:1D-BILL-CYCLE                                      
                   ,:1D-CODE-REVENUE-CLASS                              
                   ,:1D-RATE-PLAN-NO                                    
                   ,:1D-DIGTL-MTR-TYPE                                  
                   ,:1D-PROGRAM-ID                                      
                   ,:1D-REMOTE-READ-IND                                 
                   ,:1D-MTR-READ-SOURCE-CD                              
                   ,:1D-CONSTANT                                        
                   ,:1D-POINT-ID                                        
                   ,:1D-IDR-IDENT-NO                                    
                   ,:1D-ELEC-MTR-CLASS-CD                               
                   ,:1D-ELEC-MTR-SPEC-CD                                
                   ,:1D-METER-SUPPLYING                                 
                   ,:1D-SECURED-RATE-FL                                 
                   ,:1D-LAST-SYNC-DATE                                  
                   ,:1D-LAST-UPDATE-PGM-ID                              
                   ,:1D-LAST-UPDATE-TS                                  
                   ,:1D-TEMP-DATA                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7020          **'        
              DISPLAY '**   LAST_SYNC_DATE <=' WS-SYNC-DATE-MINUS1      
              DISPLAY '**   LAST_SYNC_DATE  > 0001-01-01'               
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7040-CLOSE-INTF-CURSOR.                                          
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               CLOSE INTF_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7040          **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7050-GET-MTR-DETAILS.                                            
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             SELECT AT.ACCOUNT_NO                                       
                   ,AT.CUSTOMER_NO                                      
                   ,AT.BILL_CYCLE                                       
                   ,AT.CODE_ACCT_STAT                                   
                   ,AT.LOCAL_OFFICE                                     
                   ,AT.PREMISE_NO                                       
                   ,AT.COMPANY_NO                                       
                   ,UT.CODE_UTIL_TYPE                                   
                   ,UT.IC_NO                                            
                   ,UT.CODE_REVENUE_CLASS                               
                   ,UT.RATE_PLAN_NO                                     
                   ,UT.READ_ROUTE                                       
                   ,MN.MTR_REF_NO                                       
                   ,MN.CODE_TIME_PERIOD                                 
                   ,MN.METER_NO                                         
                   ,MN.CODE_METER_STATUS                                
                   ,MN.CODE_USAGE_TYPE                                  
                   ,MN.CODE_USAGE_ID                                    
                   ,MN.REG_ID_NO                                        
                   ,MN.CODE_CRNT_REG_READ                               
                   ,MN.CODE_LAST_REG_READ                               
                   ,REPLACE(CONVERT(CHAR(8), MN.LAST_REG_READ_TIME
           , 108), ':', '.') LAST_REG_READ_TIME                               
                   ,MN.LAST_REG_READ_DATE                               
                   ,MN.LAST_READ_VALUE                                  
                   ,MN.GIS_POINT_ID                                     
                   ,MN.METER_SUPPLYING                                  
                   ,MN.DIGTL_MTR_TYPE                                   
                   ,MN.REMOTE_READ_IND                                  
                   ,MN.MTR_READ_SOURCE_CD                               
                   ,MN.PROGRAM_ID                                       
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-PREMISE-NO                                      
                   ,:AT-COMPANY-NO                                      
                   ,:UT-CODE-UTIL-TYPE                                  
                   ,:UT-IC-NO                                           
                   ,:UT-CODE-REVENUE-CLASS                              
                   ,:UT-RATE-PLAN-NO                                    
                   ,:UT-READ-ROUTE                                      
                   ,:MN-MTR-REF-NO                                      
                   ,:MN-CODE-TIME-PERIOD                                
                   ,:MN-METER-NO                                        
                   ,:MN-CODE-METER-STATUS                               
                   ,:MN-CODE-USAGE-TYPE                                 
                   ,:MN-CODE-USAGE-ID                                   
                   ,:MN-REG-ID-NO                                       
                   ,:MN-CODE-CRNT-REG-READ                              
                   ,:MN-CODE-LAST-REG-READ                              
                   ,:MN-LAST-REG-READ-TIME                              
                   ,:MN-LAST-REG-READ-DATE                              
                   ,:MN-LAST-READ-VALUE                                 
                   ,:MN-GIS-POINT-ID                                    
                   ,:MN-METER-SUPPLYING                                 
                   ,:MN-DIGTL-MTR-TYPE                                  
                   ,:MN-REMOTE-READ-IND                                 
                   ,:MN-MTR-READ-SOURCE-CD                              
                   ,:MN-PROGRAM-ID                                      
               FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                   
                   ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                   
                   ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
              WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO               
                AND MN.ACCOUNT_NO         = UT.ACCOUNT_NO               
                AND MN.IC_NO              = UT.IC_NO                    
                AND MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE           
                AND MN.ACCOUNT_NO         = :MN-ACCOUNT-NO              
                AND MN.CODE_UTIL_TYPE     = :MN-CODE-UTIL-TYPE          
                AND MN.IC_NO              = :MN-IC-NO                   
                AND MN.MTR_REF_NO         = :MN-MTR-REF-NO              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.CUSTOMER_NO                                              
MFA-TR*            ,AT.BILL_CYCLE                                               
MFA-TR*            ,AT.CODE_ACCT_STAT                                           
MFA-TR*            ,AT.LOCAL_OFFICE                                             
MFA-TR*            ,AT.PREMISE_NO                                               
MFA-TR*            ,AT.COMPANY_NO                                               
MFA-TR*            ,UT.CODE_UTIL_TYPE                                           
MFA-TR*            ,UT.IC_NO                                                    
MFA-TR*            ,UT.CODE_REVENUE_CLASS                                       
MFA-TR*            ,UT.RATE_PLAN_NO                                             
MFA-TR*            ,UT.READ_ROUTE                                               
MFA-TR*            ,MN.MTR_REF_NO                                               
MFA-TR*            ,MN.CODE_TIME_PERIOD                                         
MFA-TR*            ,MN.METER_NO                                                 
MFA-TR*            ,MN.CODE_METER_STATUS                                        
MFA-TR*            ,MN.CODE_USAGE_TYPE                                          
MFA-TR*            ,MN.CODE_USAGE_ID                                            
MFA-TR*            ,MN.REG_ID_NO                                                
MFA-TR*            ,MN.CODE_CRNT_REG_READ                                       
MFA-TR*            ,MN.CODE_LAST_REG_READ                                       
MFA-TR*            ,MN.LAST_REG_READ_TIME                                       
MFA-TR*            ,MN.LAST_REG_READ_DATE                                       
MFA-TR*            ,MN.LAST_READ_VALUE                                          
MFA-TR*            ,MN.GIS_POINT_ID                                             
MFA-TR*            ,MN.METER_SUPPLYING                                          
MFA-TR*            ,MN.DIGTL_MTR_TYPE                                           
MFA-TR*            ,MN.REMOTE_READ_IND                                          
MFA-TR*            ,MN.MTR_READ_SOURCE_CD                                       
MFA-TR*            ,MN.PROGRAM_ID                                               
MFA-TR*        INTO :AT-ACCOUNT-NO                                              
MFA-TR*            ,:AT-CUSTOMER-NO                                             
MFA-TR*            ,:AT-BILL-CYCLE                                              
MFA-TR*            ,:AT-CODE-ACCT-STAT                                          
MFA-TR*            ,:AT-LOCAL-OFFICE                                            
MFA-TR*            ,:AT-PREMISE-NO                                              
MFA-TR*            ,:AT-COMPANY-NO                                              
MFA-TR*            ,:UT-CODE-UTIL-TYPE                                          
MFA-TR*            ,:UT-IC-NO                                                   
MFA-TR*            ,:UT-CODE-REVENUE-CLASS                                      
MFA-TR*            ,:UT-RATE-PLAN-NO                                            
MFA-TR*            ,:UT-READ-ROUTE                                              
MFA-TR*            ,:MN-MTR-REF-NO                                              
MFA-TR*            ,:MN-CODE-TIME-PERIOD                                        
MFA-TR*            ,:MN-METER-NO                                                
MFA-TR*            ,:MN-CODE-METER-STATUS                                       
MFA-TR*            ,:MN-CODE-USAGE-TYPE                                         
MFA-TR*            ,:MN-CODE-USAGE-ID                                           
MFA-TR*            ,:MN-REG-ID-NO                                               
MFA-TR*            ,:MN-CODE-CRNT-REG-READ                                      
MFA-TR*            ,:MN-CODE-LAST-REG-READ                                      
MFA-TR*            ,:MN-LAST-REG-READ-TIME                                      
MFA-TR*            ,:MN-LAST-REG-READ-DATE                                      
MFA-TR*            ,:MN-LAST-READ-VALUE                                         
MFA-TR*            ,:MN-GIS-POINT-ID                                            
MFA-TR*            ,:MN-METER-SUPPLYING                                         
MFA-TR*            ,:MN-DIGTL-MTR-TYPE                                          
MFA-TR*            ,:MN-REMOTE-READ-IND                                         
MFA-TR*            ,:MN-MTR-READ-SOURCE-CD                                      
MFA-TR*            ,:MN-PROGRAM-ID                                              
MFA-TR*        FROM CSS_ACCOUNT      AT                                         
MFA-TR*            ,CSS_MTRD_ENVRNMT MN                                         
MFA-TR*            ,CSS_UTIL_ENVRNMT UT                                         
MFA-TR*       WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO                       
MFA-TR*         AND MN.ACCOUNT_NO         = UT.ACCOUNT_NO                       
MFA-TR*         AND MN.IC_NO              = UT.IC_NO                            
MFA-TR*         AND MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE                   
MFA-TR*         AND MN.ACCOUNT_NO         = :MN-ACCOUNT-NO                      
MFA-TR*         AND MN.CODE_UTIL_TYPE     = :MN-CODE-UTIL-TYPE                  
MFA-TR*         AND MN.IC_NO              = :MN-IC-NO                           
MFA-TR*         AND MN.MTR_REF_NO         = :MN-MTR-REF-NO                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7050          **'        
              DISPLAY '**   ACCOUNT-NO     = ' MN-ACCOUNT-NO            
              DISPLAY '**   CODE-UTIL-TYPE = ' MN-CODE-UTIL-TYPE        
              DISPLAY '**   IC-NO          = ' MN-IC-NO                 
              DISPLAY '**   MTR-REF-NO     = ' MN-MTR-REF-NO            
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7060-GET-LOCAL-OFFICE.                                           
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT  PR.LOCAL_OFFICE                                  
                 INTO :PR-LOCAL-OFFICE                                  
                 FROM  CSS_PREMISE PR WITH(READUNCOMMITTED)                     
                WHERE  PR.PREMISE_NO = :PR-PREMISE-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  PR.LOCAL_OFFICE                                          
MFA-TR*          INTO :PR-LOCAL-OFFICE                                          
MFA-TR*          FROM  CSS_PREMISE PR                                           
MFA-TR*         WHERE  PR.PREMISE_NO = :PR-PREMISE-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7060          **'        
              DISPLAY '**   PREMISE_NO     = ' PR-PREMISE-NO            
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7100-GET-EQ-DETAILS.                                             
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT  EQ.SERIAL_NO                                     
                      ,EQ.CODE_CRNT_LOC                                 
                      ,EQ.CRNT_LOC_NO                                   
                 INTO :EQ-SERIAL-NO                                     
                     ,:EQ-CODE-CRNT-LOC                                 
                     ,:EQ-CRNT-LOC-NO                                   
                 FROM  CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                   
                WHERE  EQ.COMPANY_NO     = :EQ-COMPANY-NO               
                  AND  EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE           
                  AND  EQ.DEVICE_NO      = :EQ-DEVICE-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  EQ.SERIAL_NO                                             
MFA-TR*               ,EQ.CODE_CRNT_LOC                                         
MFA-TR*               ,EQ.CRNT_LOC_NO                                           
MFA-TR*          INTO :EQ-SERIAL-NO                                             
MFA-TR*              ,:EQ-CODE-CRNT-LOC                                         
MFA-TR*              ,:EQ-CRNT-LOC-NO                                           
MFA-TR*          FROM  CSS_EQUIPMENT EQ                                         
MFA-TR*         WHERE  EQ.COMPANY_NO     = :EQ-COMPANY-NO                       
MFA-TR*           AND  EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                   
MFA-TR*           AND  EQ.DEVICE_NO      = :EQ-DEVICE-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7100          **'        
              DISPLAY '**   COMPANY_NO     = ' EQ-COMPANY-NO            
              DISPLAY '**   CODE-UTIL-TYPE = ' EQ-CODE-UTIL-TYPE        
              DISPLAY '**   METER-NO       = ' EQ-DEVICE-NO             
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7110-GET-SS-DEVICE.                                              
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) MA.DEVICE_NO                                     
                 INTO :MA-DEVICE-NO                                     
                 FROM  CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)              
                WHERE  MA.COMPANY_NO     = :MA-COMPANY-NO               
                  AND  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE           
                  AND  MA.METER_NO       = :MA-METER-NO                 
                  AND  MA.CODE_ATT_TYPE  = 'SS'                         
               ORDER BY MA.DEVICE_NO                                    
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MA.DEVICE_NO                                             
MFA-TR*          INTO :MA-DEVICE-NO                                             
MFA-TR*          FROM  CSS_METER_ATTCHMTS MA                                    
MFA-TR*         WHERE  MA.COMPANY_NO     = :MA-COMPANY-NO                       
MFA-TR*           AND  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                   
MFA-TR*           AND  MA.METER_NO       = :MA-METER-NO                         
MFA-TR*           AND  MA.CODE_ATT_TYPE  = 'SS'                                 
MFA-TR*        ORDER BY MA.DEVICE_NO                                            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7110          **'        
              DISPLAY '**   CODE_ATT_TYPE  =  SS             **'        
              DISPLAY '**   COMPANY_NO     = ' MA-COMPANY-NO            
              DISPLAY '**   CODE-UTIL-TYPE = ' MA-CODE-UTIL-TYPE        
              DISPLAY '**   METER-NO       = ' MA-METER-NO              
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7120-GET-MTR-CONSTANT.                                           
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT MC.CONSTANT                                        
                INTO :MC-CONSTANT                                        
                FROM CSS_MTR_CAP      MC WITH(READUNCOMMITTED)                  
               WHERE MC.COMPANY_NO     = :MC-COMPANY-NO                 
                 AND MC.CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE             
                 AND MC.METER_NO       = :MC-METER-NO                   
                 AND MC.REG_ID_NO      = :MC-REG-ID-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ025
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MC.CONSTANT                                                
MFA-TR*         INTO:MC-CONSTANT                                                
MFA-TR*         FROM CSS_MTR_CAP      MC                                        
MFA-TR*        WHERE MC.COMPANY_NO     = :MC-COMPANY-NO                         
MFA-TR*          AND MC.CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                     
MFA-TR*          AND MC.METER_NO       = :MC-METER-NO                           
MFA-TR*          AND MC.REG_ID_NO      = :MC-REG-ID-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7120          **'        
              DISPLAY '**   COMPANY NO     = ' MC-COMPANY-NO            
              DISPLAY '**   CODE_UTIL_TYPE = ' MC-CODE-UTIL-TYPE        
              DISPLAY '**   METER NO       = ' MC-METER-NO              
              DISPLAY '**   REG_ID_NO      = ' MC-REG-ID-NO             
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7130-GET-IDR-IDENT-NO.                                           
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT L7.IDR_IDENT_NO                                    
               INTO :L7-IDR-IDENT-NO                                    
                FROM CSS_IDR_ACCT_MTR L7 WITH(READUNCOMMITTED)                  
               WHERE L7.ACCOUNT_NO     = :L7-ACCOUNT-NO                 
                 AND L7.METER_NO       = :L7-METER-NO                   
                 AND L7.CODE_UTIL_TYPE = :L7-CODE-UTIL-TYPE             
               ORDER BY L7.LAST_UPDATE_TS DESC                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT L7.IDR_IDENT_NO                                            
MFA-TR*        INTO :L7-IDR-IDENT-NO                                            
MFA-TR*         FROM CSS_IDR_ACCT_MTR L7                                        
MFA-TR*        WHERE L7.ACCOUNT_NO     = :L7-ACCOUNT-NO                         
MFA-TR*          AND L7.METER_NO       = :L7-METER-NO                           
MFA-TR*          AND L7.CODE_UTIL_TYPE = :L7-CODE-UTIL-TYPE                     
MFA-TR*        ORDER BY L7.LAST_UPDATE_TS DESC                                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                                          OR -811       
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7130          **'        
              DISPLAY '**   ACCOUNT NO     = ' L7-ACCOUNT-NO            
              DISPLAY '**   METER NO       = ' L7-METER-NO              
              DISPLAY '**   CODE_UTIL_TYPE = ' L7-CODE-UTIL-TYPE        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7140-GET-ELEC-CLASS-SPEC.                                        
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT EM.ELEC_MTR_CLASS_CD                               
                    ,EM.ELEC_MTR_SPEC_CD                                
               INTO :EM-ELEC-MTR-CLASS-CD                               
                   ,:EM-ELEC-MTR-SPEC-CD                                
                FROM CSS_ELEC_METER EM WITH(READUNCOMMITTED)                    
               WHERE EM.COMPANY_NO     = :EM-COMPANY-NO                 
                 AND EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE             
                 AND EM.METER_NO       = :EM-METER-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EM.ELEC_MTR_CLASS_CD                                       
MFA-TR*             ,EM.ELEC_MTR_SPEC_CD                                        
MFA-TR*        INTO :EM-ELEC-MTR-CLASS-CD                                       
MFA-TR*            ,:EM-ELEC-MTR-SPEC-CD                                        
MFA-TR*         FROM CSS_ELEC_METER EM                                          
MFA-TR*        WHERE EM.COMPANY_NO     = :EM-COMPANY-NO                         
MFA-TR*          AND EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                     
MFA-TR*          AND EM.METER_NO       = :EM-METER-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7140                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7140          **'        
              DISPLAY '**   COMPANY NO     = ' EM-COMPANY-NO            
              DISPLAY '**   CODE_UTIL_TYPE = ' EM-CODE-UTIL-TYPE        
              DISPLAY '**   METER NO       = ' EM-METER-NO              
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7150-CHECK-RATE-PLAN-DESC.                                       
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
               INTO :RD-SECURED-RATE-FL                                 
                FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE RD.CODE_UTIL_TYPE  = :RD-CODE-UTIL-TYPE            
                 AND RD.RATE_PLAN_NO    = :RD-RATE-PLAN-NO              
                 AND RD.SECURED_RATE_FL = 'Y'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*        INTO :RD-SECURED-RATE-FL                                         
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE RD.CODE_UTIL_TYPE  = :RD-CODE-UTIL-TYPE                    
MFA-TR*          AND RD.RATE_PLAN_NO    = :RD-RATE-PLAN-NO                      
MFA-TR*          AND RD.SECURED_RATE_FL = 'Y'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7150          **'        
              DISPLAY '**   CODE_UTIL_TYPE = ' RD-CODE-UTIL-TYPE        
              DISPLAY '**   RATE_PLAN_NO   = ' RD-RATE-PLAN-NO          
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7160-CHECK-SO-MTR-REMOVE.                                        
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-MTR-REMOVED-SW                                
                 FROM CSS_SO_DATA         VO WITH(READUNCOMMITTED)              
                     ,CSS_SO_ORDER_INST   VI WITH(READUNCOMMITTED)              
                 WHERE VO.PREMISE_NO         = :VO-PREMISE-NO           
                   AND VI.SERV_ORDER_NO      = VO.SERV_ORDER_NO         
                   AND VI.WORK_TYPE_CD   IN ('RMC', 'RMM',              
                                             'RS2', 'RTM')              
                   AND VI.METER_NO           = :VI-METER-NO             
                   AND VI.CODE_UTIL_TYPE     = 'E'                      
                   AND VO.ORDER_STATE_CD     = 'Z'                      
                   AND CAST(VO.COMPLETED_DATETIME AS DATE) BETWEEN              
                        DATEADD( DAY, -5, CAST(SYSDATETIMEOFFSET() 
           AS DATE) ) AND CAST(SYSDATETIMEOFFSET() AS DATE)          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-MTR-REMOVED-SW                                        
MFA-TR*          FROM CSS_SO_DATA         VO                                    
MFA-TR*              ,CSS_SO_ORDER_INST   VI                                    
MFA-TR*          WHERE VO.PREMISE_NO         = :VO-PREMISE-NO                   
MFA-TR*            AND VI.SERV_ORDER_NO      = VO.SERV_ORDER_NO                 
MFA-TR*            AND VI.WORK_TYPE_CD   IN ('RMC', 'RMM',                      
MFA-TR*                                      'RS2', 'RTM')                      
MFA-TR*            AND VI.METER_NO           = :VI-METER-NO                     
MFA-TR*            AND VI.CODE_UTIL_TYPE     = 'E'                              
MFA-TR*            AND VO.ORDER_STATE_CD     = 'Z'                              
MFA-TR*            AND DATE(VO.COMPLETED_DATETIME) BETWEEN                      
MFA-TR*                 CURRENT DATE - 5 DAYS AND CURRENT DATE                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*        QUERYNO 7160                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7160          **'        
              DISPLAY '**   CODE_UTIL_TYPE =    E            **'        
              DISPLAY '**   METER_NO    = ' VI-METER-NO                 
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7190-GET-GIS-LOC-AND-TAG.                                        
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT AREA_ID                                            
                    ,TAG_NM                                             
               INTO :PP-AREA-ID                                         
                   ,:PP-TAG-NM                                          
               FROM CSS_PIM_POINT WITH(READUNCOMMITTED)                         
              WHERE POINT_ID = :MN-GIS-POINT-ID                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AREA_ID                                            18620000
MFA-TR*             ,TAG_NM                                             18630000
MFA-TR*        INTO :PP-AREA-ID                                                 
MFA-TR*            ,:PP-TAG-NM                                                  
MFA-TR*        FROM CSS_PIM_POINT                                       19480000
MFA-TR*       WHERE POINT_ID = :MN-GIS-POINT-ID                         19490000
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7190                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7190          **'        
              DISPLAY '**   ACCOUNT NO     = ' MN-ACCOUNT-NO            
              DISPLAY '**   CODE_UTIL_TYPE = ' MN-CODE-UTIL-TYPE        
              DISPLAY '**   METER-NO       = ' MN-METER-NO              
              DISPLAY '**   POINT_ID       = ' MN-GIS-POINT-ID          
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7190-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7200-LAST-SYNC-MINUS1.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-SYNC-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-SYNC-DATE
              ) <> 0) OR (LEN(:WS-SYNC-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-SYNC-DATE
              ), CONVERT(DATE, :WS-SYNC-DATE) ) )
            INTO
              :WS-SYNC-DATE-MINUS1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-SYNC-DATE-MINUS1                                          
MFA-TR*          = DATE(:WS-SYNC-DATE) - 1 DAY                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7200          **'        
              DISPLAY '**   GET SYNC DATE MINUS 1 DAY        **'        
              DISPLAY '**   INVALID JOB PARM SYNC DATE       **'        
              DISPLAY '**   WS-SYNC-DATE = ' WS-SYNC-DATE               
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7210-GET-CURR-TMST.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURR-TMST                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURR-TMST = CURRENT TIMESTAMP                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7210          **'        
              DISPLAY '**   GET CURRENT TIMESTAMP            **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  20231000
      * 7600-START-FCSJC01                    *                                 
      *==============================================================*  20231000
           EXEC SQL                                                             
              INCLUDE CPDCA038                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*  20231000
      * 7620-START-FCSCA00 VSAM CTRL FILE     *                                 
      *==============================================================*  20231000
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *===============================================================*         
       8100-UPDATE-ALL-MS.                                              
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_MDM_SS_INTF                                     
                SET ACCOUNT_NO         = :1D-ACCOUNT-NO                 
                   ,METER_NO           = :1D-METER-NO                   
                   ,CODE_ACCT_STAT     = :1D-CODE-ACCT-STAT             
                   ,CODE_METER_STATUS  = :1D-CODE-METER-STATUS          
                   ,MTR_SERIAL_NO      = :1D-MTR-SERIAL-NO              
                   ,DEVICE_NO          = :1D-DEVICE-NO                  
                   ,LOCAL_OFFICE       = :1D-LOCAL-OFFICE               
                   ,READ_ROUTE         = :1D-READ-ROUTE                 
                   ,BILL_CYCLE         = :1D-BILL-CYCLE                 
                   ,CODE_REVENUE_CLASS = :1D-CODE-REVENUE-CLASS         
                   ,RATE_PLAN_NO       = :1D-RATE-PLAN-NO               
                   ,DIGTL_MTR_TYPE     = :1D-DIGTL-MTR-TYPE             
                   ,PROGRAM_ID         = :1D-PROGRAM-ID                 
                   ,REMOTE_READ_IND    = :1D-REMOTE-READ-IND            
                   ,MTR_READ_SOURCE_CD = :1D-MTR-READ-SOURCE-CD         
                   ,CONSTANT           = :1D-CONSTANT                   
                   ,POINT_ID           = :1D-POINT-ID                   
                   ,IDR_IDENT_NO       = :1D-IDR-IDENT-NO               
                   ,ELEC_MTR_CLASS_CD  = :1D-ELEC-MTR-CLASS-CD          
                   ,ELEC_MTR_SPEC_CD   = :1D-ELEC-MTR-SPEC-CD           
                   ,METER_SUPPLYING    = :1D-METER-SUPPLYING            
                   ,SECURED_RATE_FL    = :1D-SECURED-RATE-FL            
                   ,LAST_SYNC_DATE     = IIF(TRY_CONVERT(DATE, 
                                                     :1D-LAST-SYNC-DATE
              ) IS NULL OR (PATINDEX('%.%', :1D-LAST-SYNC-DATE
              ) <> 0) OR (LEN(:1D-LAST-SYNC-DATE
              ) <> 10), CIS.CHAR2DATE(:1D-LAST-SYNC-DATE
              ), CONVERT(DATE, :1D-LAST-SYNC-DATE) )             
                   ,LAST_UPDATE_PGM_ID = :1D-LAST-UPDATE-PGM-ID         
                   ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :1D-LAST-UPDATE-TS
              )             
                   ,TEMP_DATA          = :1D-TEMP-DATA                  
             WHERE SERVICE_POINT_ID = :1D-SERVICE-POINT-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_MDM_SS_INTF                                             
MFA-TR*         SET ACCOUNT_NO         = :1D-ACCOUNT-NO                         
MFA-TR*            ,METER_NO           = :1D-METER-NO                           
MFA-TR*            ,CODE_ACCT_STAT     = :1D-CODE-ACCT-STAT                     
MFA-TR*            ,CODE_METER_STATUS  = :1D-CODE-METER-STATUS                  
MFA-TR*            ,MTR_SERIAL_NO      = :1D-MTR-SERIAL-NO                      
MFA-TR*            ,DEVICE_NO          = :1D-DEVICE-NO                          
MFA-TR*            ,LOCAL_OFFICE       = :1D-LOCAL-OFFICE                       
MFA-TR*            ,READ_ROUTE         = :1D-READ-ROUTE                         
MFA-TR*            ,BILL_CYCLE         = :1D-BILL-CYCLE                         
MFA-TR*            ,CODE_REVENUE_CLASS = :1D-CODE-REVENUE-CLASS                 
MFA-TR*            ,RATE_PLAN_NO       = :1D-RATE-PLAN-NO                       
MFA-TR*            ,DIGTL_MTR_TYPE     = :1D-DIGTL-MTR-TYPE                     
MFA-TR*            ,PROGRAM_ID         = :1D-PROGRAM-ID                         
MFA-TR*            ,REMOTE_READ_IND    = :1D-REMOTE-READ-IND                    
MFA-TR*            ,MTR_READ_SOURCE_CD = :1D-MTR-READ-SOURCE-CD                 
MFA-TR*            ,CONSTANT           = :1D-CONSTANT                           
MFA-TR*            ,POINT_ID           = :1D-POINT-ID                           
MFA-TR*            ,IDR_IDENT_NO       = :1D-IDR-IDENT-NO                       
MFA-TR*            ,ELEC_MTR_CLASS_CD  = :1D-ELEC-MTR-CLASS-CD                  
MFA-TR*            ,ELEC_MTR_SPEC_CD   = :1D-ELEC-MTR-SPEC-CD                   
MFA-TR*            ,METER_SUPPLYING    = :1D-METER-SUPPLYING                    
MFA-TR*            ,SECURED_RATE_FL    = :1D-SECURED-RATE-FL                    
MFA-TR*            ,LAST_SYNC_DATE     = :1D-LAST-SYNC-DATE                     
MFA-TR*            ,LAST_UPDATE_PGM_ID = :1D-LAST-UPDATE-PGM-ID                 
MFA-TR*            ,LAST_UPDATE_TS     = :1D-LAST-UPDATE-TS                     
MFA-TR*            ,TEMP_DATA          = :1D-TEMP-DATA                          
MFA-TR*      WHERE SERVICE_POINT_ID = :1D-SERVICE-POINT-ID                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8100          **'        
              DISPLAY '**   SERVICE_POINT_ID = ' 1D-SERVICE-POINT-ID    
              DISPLAY '**   ACCOUNT_NO       = ' 1D-ACCOUNT-NO          
              DISPLAY '**   METER_NO         = ' 1D-METER-NO            
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       8200-UPDATE-SYNC-MS.                                             
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_MDM_SS_INTF                                     
                SET LAST_SYNC_DATE  = IIF(TRY_CONVERT(DATE, 
                                                     :1D-LAST-SYNC-DATE
              ) IS NULL OR (PATINDEX('%.%', :1D-LAST-SYNC-DATE
              ) <> 0) OR (LEN(:1D-LAST-SYNC-DATE
              ) <> 10), CIS.CHAR2DATE(:1D-LAST-SYNC-DATE
              ), CONVERT(DATE, :1D-LAST-SYNC-DATE) )                
             WHERE SERVICE_POINT_ID = :1D-SERVICE-POINT-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_MDM_SS_INTF                                             
MFA-TR*         SET LAST_SYNC_DATE  = :1D-LAST-SYNC-DATE                        
MFA-TR*      WHERE SERVICE_POINT_ID = :1D-SERVICE-POINT-ID                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8200          **'        
              DISPLAY '**   SERVICE_POINT_ID = ' 1D-SERVICE-POINT-ID    
              DISPLAY '**   ACCOUNT_NO       = ' 1D-ACCOUNT-NO          
              DISPLAY '**   METER_NO         = ' 1D-METER-NO            
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       8300-UPDATE-MTR-STATUS.                                          
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_MDM_SS_INTF                                     
                SET CODE_METER_STATUS  = :1D-CODE-METER-STATUS          
                   ,LAST_SYNC_DATE     = IIF(TRY_CONVERT(DATE, 
                                                     :1D-LAST-SYNC-DATE
              ) IS NULL OR (PATINDEX('%.%', :1D-LAST-SYNC-DATE
              ) <> 0) OR (LEN(:1D-LAST-SYNC-DATE
              ) <> 10), CIS.CHAR2DATE(:1D-LAST-SYNC-DATE
              ), CONVERT(DATE, :1D-LAST-SYNC-DATE) )             
             WHERE SERVICE_POINT_ID = :1D-SERVICE-POINT-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_MDM_SS_INTF                                             
MFA-TR*         SET CODE_METER_STATUS  = :1D-CODE-METER-STATUS                  
MFA-TR*            ,LAST_SYNC_DATE     = :1D-LAST-SYNC-DATE                     
MFA-TR*      WHERE SERVICE_POINT_ID = :1D-SERVICE-POINT-ID                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8300          **'        
              DISPLAY '**   SERVICE_POINT_ID = ' 1D-SERVICE-POINT-ID    
              DISPLAY '**   ACCOUNT_NO       = ' 1D-ACCOUNT-NO          
              DISPLAY '**   METER_NO         = ' 1D-METER-NO            
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       8500-INSERT-INTF-CH.                                             
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_MDM_SS_INTF_CH                             
                   (SERVICE_POINT_ID                                    
                   ,COLUMN_NA                                           
                   ,LAST_UPDATE_TS                                      
                   ,PREV_COLUMN_VALUE                                   
                   ,CURR_COLUMN_VALUE                                   
                   ,LAST_UPDATE_PGM_ID )                                
               VALUES                                                   
                   (:1E-SERVICE-POINT-ID                                
                   ,:1E-COLUMN-NA                                       
                   ,CIS.CHAR2TIMESTAMP(:1E-LAST-UPDATE-TS)                      
                   ,:1E-PREV-COLUMN-VALUE                               
                   ,:1E-CURR-COLUMN-VALUE                               
                   ,:1E-LAST-UPDATE-PGM-ID )                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_MDM_SS_INTF_CH                                     
MFA-TR*            (SERVICE_POINT_ID                                            
MFA-TR*            ,COLUMN_NA                                                   
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,PREV_COLUMN_VALUE                                           
MFA-TR*            ,CURR_COLUMN_VALUE                                           
MFA-TR*            ,LAST_UPDATE_PGM_ID )                                        
MFA-TR*        VALUES                                                           
MFA-TR*            (:1E-SERVICE-POINT-ID                                        
MFA-TR*            ,:1E-COLUMN-NA                                               
MFA-TR*            ,:1E-LAST-UPDATE-TS                                          
MFA-TR*            ,:1E-PREV-COLUMN-VALUE                                       
MFA-TR*            ,:1E-CURR-COLUMN-VALUE                                       
MFA-TR*            ,:1E-LAST-UPDATE-PGM-ID )                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8500          **'        
              DISPLAY '**   SERVICE_POINT_ID = ' 1E-SERVICE-POINT-ID    
              DISPLAY '**   ACCOUNT_NO       = ' 1D-ACCOUNT-NO          
              DISPLAY '**   METER_NO         = ' 1D-METER-NO            
              DISPLAY '**   COLUMN_NA        = ' 1E-COLUMN-NA           
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       9000-TERMINATE.                                                  
      *===============================================================*         
      *                                                                         
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
           DISPLAY '** TOTAL RECS PROCESSED FROM INTF CURSOR = '        
                                 WS-INTF-REC-CNTR.                      
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      ****************************************************************          
      * 9700-PROCESS-ABEND  (REQUIED BY CPD00040)                    *          
      ****************************************************************          
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND INCLUDES SQL ROLLBACK   ****           
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
