       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW151.                                        
       INSTALLATION.                                                    
       DATE-WRITTEN.   JUN 2011.                                        
           DATE-COMPILED.                                               
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                     DB2                        *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** =====      ========      ======                             **         
      ** 06/15/11   NC94746       NEW PROGRAM FOR MDMS & SMARTSYNCH  **         
A04202** 11/13/12   VENKAT.P      ADDED READ-CYCLE FOR G_DASA        **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSBW151 NARRATIVE                        
      *                                                                         
           THIS PROGRAM USE DAILY SMART SYNCH & MV 90 METER DATA EXTRACT
           AND COMPARE WITH MDM & SS INTERFACE TABLE. CHANGES WILL BE   
           RECORDED IN INTERFACE CHANGES TABLE.                         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      * SELECT STMT FOR BW50 FILE  *                                            
       COPY CSSBW50.                                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBW50.                                                            
       COPY FIOBW50.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW151'.
MSQ017     COPY MFASQLM.
       01 WS-START                     PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSBW151 STARTS HERE'.            
      *                                                                         
      ***************************************************************           
      * FCA00-KEY          *                                                    
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      * IO AREA FOR PARM INPUT FILE 'A' *                                       
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    DB2 TABLE DCLGENS USING IN THIS PROGRAM                              
      ******************************************************************        
      *----------------------------------------------------------------*        
      * CSS_JOB_PARM (G6)                                                       
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      * CSS_MDM_SS_INTF (1D)                                                    
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBMDMINT                                                 
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      * CSS_MDM_SS_INTF_CH (1E)                                                 
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBMDMCHG                                                 
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      * CSS_RESTART (RF)                                               *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       01 WS-INTF-CHNG-TAB.                                             
          05 WS-INTF-CHNG-ROW  OCCURS 50 TIMES.                         
             10 WS-COLUMN-NA            PIC X(30).                      
             10 WS-PREV-COLUMN-VALUE    PIC X(50).                      
             10 WS-CURR-COLUMN-VALUE    PIC X(50).                      
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-YES                    PIC X(01)  VALUE 'Y'.            
          05 WS-Y                      PIC X(01)  VALUE 'Y'.            
          05 WS-N                      PIC X(01)  VALUE 'N'.            
          05 WS-U                      PIC X(01)  VALUE 'U'.            
          05 WS-I                      PIC X(01)  VALUE 'I'.            
          05 WS-NO                     PIC X(01)  VALUE 'N'.            
          05 WS-PGRMNAME               PIC X(08)  VALUE 'PCSBW151'.     
          05 PROGRAM-NAME              PIC X(08)  VALUE 'PCSBW151'.     
          05 RS-RETURN-CODE            PIC S9(09) VALUE +000 COMP.      
          05 RS-RETURN-CODE-DISP       PIC S9(09) VALUE +000 COMP.      
          05 WS-HEADER-FIOBW50.                                         
             10 WS-HEADER-DATE-TXT     PIC X(09) VALUE 'RUN DATE='.     
             10 WS-HEADER-DATE-YYYY-MM-DD  PIC X(10)  VALUE SPACES.     
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 WS-ENTITY-CHNGS-SW        PIC 9(01).                       
             88 ENTITY-CHNGS-CHK-REQ             VALUE 0.               
             88 NO-MORE-ENTITY-CHNGS             VALUE 1.               
          05 WS-INTF-DATA-UPD-SW       PIC 9(01).                       
             88 INTF-DATA-UPD-REQ                VALUE 0.               
             88 INTF-DATA-UPD-NOT-REQ            VALUE 1.               
          05 WS-FBW50-STATUS           PIC X(02).                       
             88 FBW50-SUCCESSFUL                 VALUE '00'.            
          05 WS-BW50-EOF               PIC X(01) VALUE 'N'.             
             88 BW50-EOF-REACHED                 VALUE 'Y'.             
          05 WS-ACC-CHNG-SW            PIC X(01) VALUE 'N'.             
             88 NOT-SAME-ACCOUNT                 VALUE 'N'.             
             88 SAME-ACCOUNT                     VALUE 'Y'.             
          05 WS-CPD99-MATCH-SW         PIC X(01) VALUE 'A'.             
             88 CPD99-NOT-EXECUTED               VALUE 'A'.             
             88 CPD99-EXECUTED                   VALUE 'B', 'C'.        
             88 LATEST-ACCOUNT                   VALUE 'B'.             
             88 NOT-LATEST-ACCOUNT               VALUE 'C'.             
      *                                                                         
       01 WS-WORK-AREA.                                                 
          05 WS-CURR-DATE                PIC X(10).                     
          05 WS-CURR-TMST                PIC X(26).                     
          05 WS-HLD-COLUMN-NA            PIC X(30).                     
          05 WS-HLD-PREV-COLUMN-VALUE    PIC X(50).                     
          05 WS-HLD-CURR-COLUMN-VALUE    PIC X(50).                     
          05 SUB                         PIC 9(02)  VALUE ZEROS.        
          05 INTF-SUB                    PIC 9(02)  VALUE ZEROS.        
          05 WS-GIS-POINT-ID             PIC 9(10)  VALUE ZEROS.        
          05 WS-SERVICE-POINT-ID.                                       
             10 WS-COMPANY-NO            PIC X(02)  VALUE SPACES.       
             10 WS-PREMISE-NO            PIC 9(10)  VALUE ZEROES.       
             10 WS-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.       
             10 WS-IC-NO                 PIC 9(04)  VALUE ZEROES.       
             10 WS-MTR-REF-NO            PIC 9(04)  VALUE ZEROES.       
          05 WS-ACCOUNT-NO               PIC 9(13)  VALUE ZERO.         
          05 WS-PRIOR-ACCOUNT-NO         PIC S9(13)V COMP-3 VALUE ZERO. 
          05 WS-FCSBW50-REC-CNTR         PIC 9(09) VALUE ZERO.          
          05 WS-FCSBW50-REC-NO           PIC 9(09) VALUE ZERO.          
          05 WS-DISPLAY-SQLCODE          PIC ---9.                      
          05 WS-DISPLAY-CONSTANT         PIC 999999.999.                
      *                                                                         
       01 WS-RESTART-DATA.                                              
          05 WS-RESTART-PROCESS-TYPE     PIC 9(01).                     
          05 WS-RESTART-JOB-COMPLETE     REDEFINES                      
             WS-RESTART-PROCESS-TYPE     PIC X(01).                     
          05 WS-RESTART-JOB-STATUS       PIC X(01).                     
             88 WS-RUN-COMPLETED-NORMAL      VALUE 'A'.                 
             88 WS-RERUN-COMPLETED           VALUE 'B'.                 
             88 WS-RERUN-PENDING             VALUE 'C'.                 
          05 WS-RESTART-INPUT-DATE       PIC X(10) VALUE SPACE.         
          05 WS-RESTART-CHKP-SEQ-NO      PIC 9(07) VALUE 0.             
          05 WS-RESTART-RECORD-NO        PIC 9(09) VALUE 0.             
          05 WS-RESTART-SP-ID            PIC X(21) VALUE SPACE.         
          05 WS-RESTART-ACCOUNT-NO       PIC 9(13) VALUE 0.             
          05 WS-RESTART-METER-NO         PIC X(09) VALUE SPACE.         
          05 WS-RESTART-REC-COUNT        PIC 9(09) VALUE 0.             
      *                                                                         
       01 WS-RESTART-MISC.                                              
          05 WS-RESTART-DATA-LENGTH      PIC S9(04) COMP VALUE +80.     
          05 WS-IS-THIS-A-RESTART        PIC X(01) VALUE 'N'.           
             88 WS-THIS-IS-A-RESTART               VALUE 'Y'.           
          05 WS-CHKP-COMMITS-ON-OFF-SW   PIC X(01) VALUE 'Y'.           
             88 TURN-ON-CHKP-COMMITS               VALUE 'Y'.           
             88 TURN-OFF-CHKP-COMMITS              VALUE 'N'.           
          05 WS-RESTART-REQ              PIC X(01).                     
          05 WS-PRINT-COUNTERS           PIC X(01) VALUE 'A'.           
          05 WS-DEFAULT-RESTART-REQ      PIC X(01) VALUE 'N'.           
          05 WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.          
          05 WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.             
          05 WS-CHKP-LUW-LIMIT           PIC 9(04).                     
          05 WS-CHKP-LUW-COUNTER         PIC S9(05) COMP-3 VALUE 0.     
          05 WS-CHKP-UPD-COUNTER         PIC S9(05) COMP-3 VALUE 0.     
          05 WS-CHKP-SEQ-NO              PIC S9(07) COMP-3 VALUE 0.     
          05 WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.            
          05 WS-CHKP-UPD-LIMIT           PIC 9(04).                     
          05 WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(04) COMP-3 VALUE ZERO.  
      *                                                                         
      * ABEND SWITCH         *                                                  
       COPY CWS09900.                                                           
      * WARNING DATA         *                                                  
       COPY CWS00303.                                                           
      * WS ABEND WORK AREA   *                                                  
       COPY CWS00010.                                                           
       COPY CWS00074.                                                           
       COPY CWS00011.                                                           
      * MISC INPUT           *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *** REDEFINES CONTINUE FROM CWS00038                                      
       01 WS-SYNC-DATE-PARM REDEFINES WS-INPUT-DATA-BREAKDOWN.          
          05 WS-SYNC-DATE-TXT               PIC  X(15).                 
             88 LAST-SYNC-DATE           VALUE 'LAST-SYNC-DATE='.       
          05 WS-PARM-SYNC-DATE              PIC  X(10).                 
          05 FILLER                         PIC  X(55).                 
      *                                                                         
      * FCA00 MISC INPUT     *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSBW151 ENDS HERE  '.            
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *================================================================*        
       0000-MAIN-PROCESS.                                               
      *================================================================*        
      *                                                                         
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
      *                                                                         
           PERFORM 1000-PROCESS-EACH-SP    THRU 1000-EXIT               
                   UNTIL BW50-EOF-REACHED.                              
      *                                                                         
           PERFORM 2900-END-OF-PROCESS     THRU 2900-EXIT.              
      *                                                                         
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           OPEN INPUT FCSBW50-FILE                                      
      *                                                                         
           IF  FBW50-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** 0100-ERROR ON FCSBW50 OPEN. STATUS IS '      
                                  WS-FBW50-STATUS                       
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               DISPLAY 'COMMON DATE ==> ' WS-FCA00-COMMON-DATE          
               MOVE WS-FCA00-COMMON-DATE   TO WS-INPUT-DATE             
           END-IF.                                                      
      *                                                                         
           PERFORM 7200-GET-CURR-DATE    THRU 7200-EXIT.                
           PERFORM 7210-GET-CURR-TMST    THRU 7210-EXIT.                
      *                                                                         
           MOVE WS-CURR-DATE          TO 1D-LAST-SYNC-DATE              
           MOVE PROGRAM-NAME          TO 1D-LAST-UPDATE-PGM-ID          
           MOVE WS-CURR-TMST          TO 1D-LAST-UPDATE-TS              
      *                                                                         
           SET TURN-ON-CHKP-COMMITS      TO TRUE                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT   THRU 6253-EXIT.          
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
              AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              SET TURN-OFF-CHKP-COMMITS      TO TRUE                    
              DISPLAY ' '                                               
              DISPLAY '********************************************'    
              DISPLAY '**   PCSBW151 PROCESSING WARNING          **'    
              DISPLAY '**   BOTH CHKP-LUW AND CHKP-UPD PARMS SET **'    
              DISPLAY '**   TO ' WS-FLAG-TO-TURN-OFF-COMMITS            
              DISPLAY '**   INDICATE THAT INTERIM COMMIT POINTS  **'    
              DISPLAY '**   SHOULD NOT BE TAKEN.                 **'    
              DISPLAY '**   COMPLETE RERUN REQUIRED UPON         **'    
              DISPLAY '**   UNSUCCESSFUL COMPLETION OF JOB.      **'    
              DISPLAY '********************************************'    
           END-IF.                                                      
      *                                                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ  THRU 6235-EXIT.          
      *                                                                         
           PERFORM 0600-PREPARE-FOR-RESTART    THRU 0600-EXIT.          
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
           IF  WS-THIS-IS-A-RESTART                                     
               PERFORM 0610-REPOSITION-BW50     THRU 0610-EXIT          
           ELSE                                                         
               SET WS-RERUN-PENDING        TO TRUE                      
               MOVE 0                      TO WS-RESTART-PROCESS-TYPE   
               MOVE WS-INPUT-DATE          TO WS-RESTART-INPUT-DATE     
               PERFORM 0620-PROCESS-HEADER-BW50 THRU 0620-EXIT          
               MOVE ZEROS                  TO WS-FCSBW50-REC-CNTR       
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FIOBW50     THRU 7000-EXIT.                
           IF BW50-EOF-REACHED                                          
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSBW151 PROCESSING WARNING         **'     
              DISPLAY '**   NO DATA FOR THIS RUN                **'     
              DISPLAY '**   FILE DT: ' WS-HEADER-DATE-YYYY-MM-DD        
              DISPLAY '**   RUN  DT: ' WS-INPUT-DATE                    
              DISPLAY '*******************************************'     
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0600-PREPARE-FOR-RESTART.                                        
      *================================================================*        
      *                                                                         
           MOVE PROGRAM-NAME               TO RF-NAME-PROGRAM.          
           MOVE 1                          TO RF-PARTITION-NO           
           MOVE 1                          TO RF-DUP-CNTRL-NO.          
           PERFORM 7550-SELECT-RESTART-DATA    THRU 7550-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE RF-RESTART-DATA-TEXT   TO WS-RESTART-DATA           
               IF  WS-RESTART-PROCESS-TYPE NUMERIC                      
                   MOVE WS-YES             TO WS-IS-THIS-A-RESTART      
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
      * 0605-VALIDATE-RESTART                                                   
      *===============================================================*         
       COPY CPD00030.                                                           
      *                                                                         
      *****************************************************************         
      *    REPOSITION INPUT FILE                                      *         
      *===============================================================*         
       0610-REPOSITION-BW50.                                            
      *===============================================================*         
      *                                                                         
           MOVE ZERO                       TO WS-FCSBW50-REC-NO         
           PERFORM 7000-READ-FIOBW50     THRU 7000-EXIT                 
               UNTIL WS-FCSBW50-REC-NO = WS-RESTART-RECORD-NO           
                     OR BW50-EOF-REACHED.                               
      *                                                                         
           IF WS-RESTART-SP-ID          = E-FBW50-SERVICE-POINT-ID      
              AND WS-RESTART-ACCOUNT-NO = E-FBW50-ACCOUNT-NO            
              AND WS-RESTART-METER-NO   = E-FBW50-METER-NO              
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '** RESTART ERROR: FILE REPOSITIONING FAILED'     
              DISPLAY '** INPUT RECORD NOT MATCHES  RESTART RECORD'     
              DISPLAY '** FILE REC: ' E-FBW50-SERVICE-POINT-ID          
                                  '|' E-FBW50-ACCOUNT-NO                
                                  '|' E-FBW50-METER-NO                  
              DISPLAY '** RSTT REC: ' WS-RESTART-SP-ID                  
                                  '|' WS-RESTART-ACCOUNT-NO             
                                  '|' WS-RESTART-METER-NO               
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
      *****************************************************************         
      *    THE FOLLOWING CODE COMPARES RUN DATE STORED IN             *         
      *    RESTART DATA TO RUN DATE FROM JOB CONTROL FILE:            *         
      *****************************************************************         
           IF WS-RESTART-INPUT-DATE  EQUAL WS-INPUT-DATE                
              OR WS-RESTART-INPUT-DATE EQUAL SPACES                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '** RUN DATE HAS CHANGED PRIOR TO RESTART **'    
               DISPLAY '** OLD RUN DATE = ' WS-RESTART-INPUT-DATE       
               DISPLAY '** NEW RUN DATE = ' WS-INPUT-DATE               
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF PCSBW151  *****'.       
           DISPLAY '*******************************************'.       
           MOVE WS-RESTART-CHKP-SEQ-NO     TO WS-CHKP-SEQ-NO            
           MOVE WS-RESTART-REC-COUNT       TO WS-FCSBW50-REC-CNTR.      
      *                                                                         
       0610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0620-PROCESS-HEADER-BW50.                                        
      *================================================================*        
      *                                                                         
           PERFORM 7000-READ-FIOBW50     THRU 7000-EXIT.                
      *                                                                         
           IF BW50-EOF-REACHED                                          
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSBW151 PROCESSING ERROR           **'     
              DISPLAY '**   ABEND IN PARAGRAPH 0620             **'     
              DISPLAY '**   EMPTY BW50 FILE, HEADER REC MISSING **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           ELSE                                                         
              MOVE FIOBW50                  TO WS-HEADER-FIOBW50        
              IF WS-HEADER-DATE-YYYY-MM-DD = WS-INPUT-DATE              
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '**   PCSBW151 PROCESSING ERROR           **'  
                 DISPLAY '**   ABEND IN PARAGRAPH 0620             **'  
                 DISPLAY '**   BW50 FILE DATE NOT SAME AS RUN DATE **'  
                 DISPLAY '**   FILE DT: ' WS-HEADER-DATE-YYYY-MM-DD     
                 DISPLAY '**   RUN  DT: ' WS-INPUT-DATE                 
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-PROCESS-EACH-SP.                                            
      *================================================================*        
      *                                                                         
           MOVE ZEROS                  TO INTF-SUB                      
           INITIALIZE                     WS-INTF-CHNG-TAB              
           MOVE E-FBW50-SERVICE-POINT-ID  TO 1D-SERVICE-POINT-ID        
      *                                                                         
           DISPLAY 'PROCESSING: ' E-FBW50-SERVICE-POINT-ID              
                              '|' E-FBW50-ACCOUNT-NO                    
                              '|' E-FBW50-METER-NO                      
      *                                                                         
           PERFORM 7100-SELECT-SERVICE-POINT THRU 7100-EXIT             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 1D-ACCOUNT-NO           TO WS-ACCOUNT-NO             
              SET ENTITY-CHNGS-CHK-REQ     TO TRUE                      
              SET INTF-DATA-UPD-NOT-REQ    TO TRUE                      
              PERFORM 1100-PROCESS-INTF-UPDATES THRU 1100-EXIT          
                      UNTIL NO-MORE-ENTITY-CHNGS                        
              IF INTF-DATA-UPD-REQ                                      
                 PERFORM 2100-LOAD-INTF-CHNGS    THRU 2100-EXIT         
                 PERFORM 8100-UPDATE-ALL-INTF    THRU 8100-EXIT         
              ELSE                                                      
                 PERFORM 8200-UPDATE-SYNC-INTF   THRU 8200-EXIT         
              END-IF                                                    
           ELSE                                                         
              PERFORM 1400-PROCESS-INTF-NEW     THRU 1400-EXIT          
           END-IF.                                                      
      *                                                                         
           IF TURN-ON-CHKP-COMMITS                                      
              ADD 1                    TO WS-CHKP-LUW-COUNTER           
                                          WS-CHKP-UPD-COUNTER           
              IF (WS-CHKP-LUW-COUNTER >= WS-CHKP-LUW-LIMIT)             
                  OR (WS-CHKP-UPD-COUNTER  >= WS-CHKP-UPD-LIMIT)        
                 PERFORM 6025-ISSUE-CHKP       THRU 6025-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FIOBW50     THRU 7000-EXIT.                
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1100-PROCESS-INTF-UPDATES.                                       
      *================================================================*        
      *                                                                         
           EVALUATE TRUE                                                
              WHEN E-FBW50-ACCOUNT-NO NOT = 1D-ACCOUNT-NO               
                 PERFORM 1110-PROCESS-ACCOUNT-CHNG  THRU 1110-EXIT      
              WHEN E-FBW50-METER-NO   NOT = 1D-METER-NO                 
                 PERFORM 1120-PROCESS-METER-CHNG  THRU 1120-EXIT        
              WHEN E-FBW50-CODE-ACCT-STAT NOT = 1D-CODE-ACCT-STAT       
                 PERFORM 1130-PROCESS-ACCT-STATUS THRU 1130-EXIT        
              WHEN E-FBW50-CODE-METER-STATUS NOT = 1D-CODE-METER-STATUS 
                 PERFORM 1140-PROCESS-MTR-STATUS THRU 1140-EXIT         
              WHEN E-FBW50-PROGRAM-ID      NOT = 1D-PROGRAM-ID          
                 PERFORM 1150-PROCESS-PGM-ID     THRU 1150-EXIT         
              WHEN E-FBW50-DIGTL-MTR-TYPE  NOT = 1D-DIGTL-MTR-TYPE      
                 PERFORM 1160-PROCESS-DMT-CHNG   THRU 1160-EXIT         
              WHEN E-FBW50-RATE-PLAN-NO    NOT = 1D-RATE-PLAN-NO        
                 PERFORM 1170-PROCESS-RATE-CHNG   THRU 1170-EXIT        
              WHEN OTHER                                                
                 PERFORM 1190-PROCESS-OTHER-CHNGS THRU 1190-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1110-PROCESS-ACCOUNT-CHNG.                                       
      *================================================================*        
      *                                                                         
           MOVE 'ACCOUNT_NO'        TO WS-HLD-COLUMN-NA                 
           MOVE WS-ACCOUNT-NO       TO WS-HLD-PREV-COLUMN-VALUE         
           MOVE E-FBW50-ACCOUNT-NO  TO WS-HLD-CURR-COLUMN-VALUE         
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT               
           MOVE E-FBW50-ACCOUNT-NO         TO 1D-ACCOUNT-NO.            
      *                                                                         
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1120-PROCESS-METER-CHNG.                                         
      *================================================================*        
      *                                                                         
           MOVE 'METER_NO'          TO WS-HLD-COLUMN-NA                 
           MOVE 1D-METER-NO         TO WS-HLD-PREV-COLUMN-VALUE         
           MOVE E-FBW50-METER-NO    TO WS-HLD-CURR-COLUMN-VALUE         
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT               
           MOVE E-FBW50-METER-NO    TO 1D-METER-NO.                     
      *                                                                         
       1120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1130-PROCESS-ACCT-STATUS.                                        
      *================================================================*        
      *                                                                         
           MOVE 'CODE_ACCT_STAT'       TO WS-HLD-COLUMN-NA              
           MOVE 1D-CODE-ACCT-STAT      TO WS-HLD-PREV-COLUMN-VALUE      
           MOVE E-FBW50-CODE-ACCT-STAT TO WS-HLD-CURR-COLUMN-VALUE      
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT.              
      *                                                                         
           MOVE E-FBW50-CODE-ACCT-STAT TO 1D-CODE-ACCT-STAT.            
      *                                                                         
       1130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1140-PROCESS-MTR-STATUS.                                         
      *================================================================*        
      *                                                                         
           MOVE 'CODE_METER_STATUS'       TO WS-HLD-COLUMN-NA           
           MOVE 1D-CODE-METER-STATUS      TO WS-HLD-PREV-COLUMN-VALUE   
           MOVE E-FBW50-CODE-METER-STATUS TO WS-HLD-CURR-COLUMN-VALUE   
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT.              
      *                                                                         
           MOVE E-FBW50-CODE-METER-STATUS TO 1D-CODE-METER-STATUS.      
      *                                                                         
       1140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1150-PROCESS-PGM-ID.                                             
      *================================================================*        
      *                                                                         
           MOVE 'PROGRAM_ID'              TO WS-HLD-COLUMN-NA           
           MOVE 1D-PROGRAM-ID             TO WS-HLD-PREV-COLUMN-VALUE   
           MOVE E-FBW50-PROGRAM-ID        TO WS-HLD-CURR-COLUMN-VALUE   
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT.              
      *                                                                         
           MOVE E-FBW50-PROGRAM-ID        TO 1D-PROGRAM-ID.             
      *                                                                         
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1160-PROCESS-DMT-CHNG.                                           
      *================================================================*        
      *                                                                         
           MOVE 'DIGTL_MTR_TYPE'          TO WS-HLD-COLUMN-NA           
           MOVE 1D-DIGTL-MTR-TYPE         TO WS-HLD-PREV-COLUMN-VALUE   
           MOVE E-FBW50-DIGTL-MTR-TYPE    TO WS-HLD-CURR-COLUMN-VALUE   
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT.              
      *                                                                         
           MOVE E-FBW50-DIGTL-MTR-TYPE    TO 1D-DIGTL-MTR-TYPE.         
      *                                                                         
       1160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1170-PROCESS-RATE-CHNG.                                          
      *================================================================*        
      *                                                                         
           MOVE 'RATE_PLAN_NO'            TO WS-HLD-COLUMN-NA           
           MOVE 1D-RATE-PLAN-NO           TO WS-HLD-PREV-COLUMN-VALUE   
           MOVE E-FBW50-RATE-PLAN-NO      TO WS-HLD-CURR-COLUMN-VALUE   
      *                                                                         
           PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT.              
      *                                                                         
           MOVE E-FBW50-RATE-PLAN-NO      TO  1D-RATE-PLAN-NO.          
           MOVE E-FBW50-SECURED-RATE-FL   TO 1D-SECURED-RATE-FL.        
      *                                                                         
       1170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1190-PROCESS-OTHER-CHNGS.                                        
      *================================================================*        
      *                                                                         
           EVALUATE TRUE                                                
              WHEN E-FBW50-MTR-READ-SOURCE-CD                           
                                           NOT = 1D-MTR-READ-SOURCE-CD  
                 MOVE 'MTR_READ_SOURCE_CD' TO WS-HLD-COLUMN-NA          
                 MOVE 1D-MTR-READ-SOURCE-CD                             
                                          TO WS-HLD-PREV-COLUMN-VALUE   
                 MOVE E-FBW50-MTR-READ-SOURCE-CD                        
                                          TO WS-HLD-CURR-COLUMN-VALUE   
                                             1D-MTR-READ-SOURCE-CD      
              WHEN E-FBW50-REMOTE-READ-IND NOT = 1D-REMOTE-READ-IND     
                 MOVE 'REMOTE_READ_IND'   TO WS-HLD-COLUMN-NA           
                 MOVE 1D-REMOTE-READ-IND  TO WS-HLD-PREV-COLUMN-VALUE   
                 MOVE E-FBW50-REMOTE-READ-IND                           
                                          TO WS-HLD-CURR-COLUMN-VALUE   
                                             1D-REMOTE-READ-IND         
              WHEN E-FBW50-CONSTANT        NOT = 1D-CONSTANT            
                 MOVE 'CONSTANT'          TO WS-HLD-COLUMN-NA           
                 MOVE 1D-CONSTANT         TO WS-DISPLAY-CONSTANT        
                 MOVE WS-DISPLAY-CONSTANT TO WS-HLD-PREV-COLUMN-VALUE   
                 MOVE E-FBW50-CONSTANT    TO WS-DISPLAY-CONSTANT        
                 MOVE WS-DISPLAY-CONSTANT TO WS-HLD-CURR-COLUMN-VALUE   
                 MOVE E-FBW50-CONSTANT    TO 1D-CONSTANT                
              WHEN E-FBW50-LOCAL-OFFICE    NOT = 1D-LOCAL-OFFICE        
                 MOVE 'LOCAL_OFFICE'       TO WS-HLD-COLUMN-NA          
                 MOVE 1D-LOCAL-OFFICE      TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE E-FBW50-LOCAL-OFFICE TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-LOCAL-OFFICE           
              WHEN E-FBW50-READ-ROUTE      NOT = 1D-READ-ROUTE          
                 MOVE 'READ_ROUTE'         TO WS-HLD-COLUMN-NA          
                 MOVE 1D-READ-ROUTE        TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE E-FBW50-READ-ROUTE   TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-READ-ROUTE             
              WHEN E-FBW50-BILL-CYCLE      NOT = 1D-BILL-CYCLE          
                 MOVE 'BILL_CYCLE'         TO WS-HLD-COLUMN-NA          
                 MOVE 1D-BILL-CYCLE        TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE E-FBW50-BILL-CYCLE   TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-BILL-CYCLE             
              WHEN E-FBW50-CODE-REVENUE-CLASS                           
                                           NOT = 1D-CODE-REVENUE-CLASS  
                 MOVE 'CODE_REVENUE_CLASS' TO WS-HLD-COLUMN-NA          
                 MOVE 1D-CODE-REVENUE-CLASS                             
                                          TO WS-HLD-PREV-COLUMN-VALUE   
                 MOVE E-FBW50-CODE-REVENUE-CLASS                        
                                          TO WS-HLD-CURR-COLUMN-VALUE   
                                             1D-CODE-REVENUE-CLASS      
              WHEN E-FBW50-SECURED-RATE-FL NOT = 1D-SECURED-RATE-FL     
                 MOVE 'SECURED_RATE_FL'    TO WS-HLD-COLUMN-NA          
                 MOVE 1D-SECURED-RATE-FL   TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE E-FBW50-SECURED-RATE-FL                           
                                           TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-SECURED-RATE-FL        
              WHEN E-FBW50-POINT-ID        NOT = 1D-POINT-ID            
                 MOVE 'POINT_ID'           TO WS-HLD-COLUMN-NA          
                 MOVE 1D-POINT-ID          TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE E-FBW50-POINT-ID     TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-POINT-ID               
              WHEN E-FBW50-IDR-IDENT-NO    NOT = 1D-IDR-IDENT-NO        
                 MOVE 'IDR_IDENT_NO'       TO WS-HLD-COLUMN-NA          
                 MOVE 1D-IDR-IDENT-NO      TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE E-FBW50-IDR-IDENT-NO TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-IDR-IDENT-NO           
              WHEN E-FBW50-ELEC-MTR-CLASS-CD                            
                                           NOT = 1D-ELEC-MTR-CLASS-CD   
                 MOVE 'ELEC_MTR_CLASS_CD'  TO WS-HLD-COLUMN-NA          
                 MOVE 1D-ELEC-MTR-CLASS-CD TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE E-FBW50-ELEC-MTR-CLASS-CD                         
                                           TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-ELEC-MTR-CLASS-CD      
              WHEN E-FBW50-ELEC-MTR-SPEC-CD                             
                                           NOT = 1D-ELEC-MTR-SPEC-CD    
                 MOVE 'ELEC_MTR_SPEC_CD'   TO WS-HLD-COLUMN-NA          
                 MOVE 1D-ELEC-MTR-SPEC-CD  TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE E-FBW50-ELEC-MTR-SPEC-CD                          
                                           TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-ELEC-MTR-SPEC-CD       
              WHEN E-FBW50-METER-SUPPLYING                              
                                           NOT = 1D-METER-SUPPLYING     
                 MOVE 'METER_SUPPLYING'    TO WS-HLD-COLUMN-NA          
                 MOVE 1D-METER-SUPPLYING   TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE E-FBW50-METER-SUPPLYING                           
                                           TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-METER-SUPPLYING        
              WHEN E-FBW50-DEVICE-NO NOT = 1D-DEVICE-NO                 
                 MOVE 'DEVICE_NO'          TO WS-HLD-COLUMN-NA          
                 MOVE 1D-DEVICE-NO         TO WS-HLD-PREV-COLUMN-VALUE  
                 MOVE E-FBW50-DEVICE-NO    TO WS-HLD-CURR-COLUMN-VALUE  
                                              1D-DEVICE-NO              
              WHEN E-FBW50-MTR-SERIAL-NO NOT = 1D-MTR-SERIAL-NO         
                 MOVE 'MTR_SERIAL_NO'       TO WS-HLD-COLUMN-NA         
                 MOVE 1D-MTR-SERIAL-NO      TO WS-HLD-PREV-COLUMN-VALUE 
                 MOVE E-FBW50-MTR-SERIAL-NO TO WS-HLD-CURR-COLUMN-VALUE 
                                               1D-MTR-SERIAL-NO         
A04202        WHEN E-FBW50-READ-CYCLE      NOT = 1D-READ-CYCLE          
A04202           MOVE 'READ_CYCLE'         TO WS-HLD-COLUMN-NA          
A04202           MOVE 1D-READ-CYCLE        TO WS-HLD-PREV-COLUMN-VALUE  
A04202           MOVE E-FBW50-READ-CYCLE   TO WS-HLD-CURR-COLUMN-VALUE  
A04202                                        1D-READ-CYCLE             
              WHEN OTHER                                                
                 SET NO-MORE-ENTITY-CHNGS  TO TRUE                      
                 MOVE SPACES               TO WS-HLD-COLUMN-NA          
                                              WS-HLD-PREV-COLUMN-VALUE  
                                              WS-HLD-CURR-COLUMN-VALUE  
           END-EVALUATE.                                                
      *                                                                         
           IF WS-HLD-COLUMN-NA > SPACES                                 
              PERFORM 2000-STORE-INTF-CHNG    THRU 2000-EXIT            
           END-IF.                                                      
      *                                                                         
       1190-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1400-PROCESS-INTF-NEW.                                           
      *================================================================*        
      *                                                                         
           SET INTF-DATA-UPD-REQ       TO TRUE                          
      *                                                                         
           MOVE E-FBW50-SERVICE-POINT-ID  TO 1D-SERVICE-POINT-ID        
           MOVE E-FBW50-ACCOUNT-NO        TO 1D-ACCOUNT-NO              
           MOVE E-FBW50-METER-NO          TO 1D-METER-NO                
           MOVE E-FBW50-CODE-ACCT-STAT    TO 1D-CODE-ACCT-STAT          
           MOVE E-FBW50-CODE-METER-STATUS TO 1D-CODE-METER-STATUS       
           MOVE E-FBW50-MTR-SERIAL-NO     TO 1D-MTR-SERIAL-NO           
           MOVE E-FBW50-DEVICE-NO         TO 1D-DEVICE-NO               
      *                                                                         
           MOVE E-FBW50-LOCAL-OFFICE      TO 1D-LOCAL-OFFICE            
           MOVE E-FBW50-READ-ROUTE        TO 1D-READ-ROUTE              
           MOVE E-FBW50-BILL-CYCLE        TO 1D-BILL-CYCLE              
           MOVE E-FBW50-CODE-REVENUE-CLASS TO 1D-CODE-REVENUE-CLASS     
           MOVE E-FBW50-RATE-PLAN-NO      TO 1D-RATE-PLAN-NO            
           MOVE E-FBW50-DIGTL-MTR-TYPE    TO 1D-DIGTL-MTR-TYPE          
           MOVE E-FBW50-PROGRAM-ID        TO 1D-PROGRAM-ID              
           MOVE E-FBW50-MTR-READ-SOURCE-CD TO 1D-MTR-READ-SOURCE-CD     
           MOVE E-FBW50-REMOTE-READ-IND   TO 1D-REMOTE-READ-IND         
           MOVE E-FBW50-CONSTANT          TO 1D-CONSTANT                
           MOVE E-FBW50-POINT-ID          TO 1D-POINT-ID                
           MOVE E-FBW50-IDR-IDENT-NO      TO 1D-IDR-IDENT-NO            
           MOVE E-FBW50-ELEC-MTR-CLASS-CD TO 1D-ELEC-MTR-CLASS-CD       
           MOVE E-FBW50-ELEC-MTR-SPEC-CD  TO 1D-ELEC-MTR-SPEC-CD        
           MOVE E-FBW50-METER-SUPPLYING   TO 1D-METER-SUPPLYING         
           MOVE E-FBW50-SECURED-RATE-FL   TO 1D-SECURED-RATE-FL         
A04202     MOVE E-FBW50-READ-CYCLE        TO 1D-READ-CYCLE              
      *                                                                         
           MOVE SPACES                    TO 1D-TEMP-DATA               
      *                                                                         
           PERFORM 8000-INSERT-INTF    THRU 8000-EXIT.                  
      *                                                                         
           MOVE 'SERVICE_POINT_ID'        TO 1E-COLUMN-NA               
           MOVE 'NEW ENTITY'              TO 1E-PREV-COLUMN-VALUE       
           MOVE E-FBW50-SERVICE-POINT-ID  TO 1E-SERVICE-POINT-ID        
                                             1E-CURR-COLUMN-VALUE       
           MOVE WS-CURR-TMST              TO 1E-LAST-UPDATE-TS          
           MOVE PROGRAM-NAME              TO 1E-LAST-UPDATE-PGM-ID.     
      *                                                                         
           PERFORM 8500-INSERT-INTF-CH    THRU 8500-EXIT.               
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2000-STORE-INTF-CHNG.                                            
      *================================================================*        
      *                                                                         
           SET INTF-DATA-UPD-REQ       TO TRUE                          
           COMPUTE INTF-SUB = INTF-SUB + 1                              
           IF INTF-SUB > 50                                             
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 2000          **'        
              DISPLAY '**   ARRY OVER-FLOW OCCUR             **'        
              DISPLAY '**   MORE THAN 50 CHANGES FOUND FOR   **'        
              DISPLAY '**   SERVICE-POINT = ' E-FBW50-SERVICE-POINT-ID  
              DISPLAY '**   ACCOUNT-NO    = ' E-FBW50-ACCOUNT-NO        
              DISPLAY '**   METER-NO      = ' E-FBW50-METER-NO          
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
           MOVE WS-HLD-COLUMN-NA                                        
                                 TO  WS-COLUMN-NA (INTF-SUB)            
           MOVE WS-HLD-PREV-COLUMN-VALUE                                
                                 TO WS-PREV-COLUMN-VALUE(INTF-SUB)      
           MOVE WS-HLD-CURR-COLUMN-VALUE                                
                                 TO WS-CURR-COLUMN-VALUE(INTF-SUB).     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2100-LOAD-INTF-CHNGS.                                            
      *================================================================*        
      *                                                                         
           MOVE 1D-SERVICE-POINT-ID TO 1E-SERVICE-POINT-ID              
           MOVE WS-CURR-TMST        TO 1E-LAST-UPDATE-TS                
           MOVE PROGRAM-NAME        TO 1E-LAST-UPDATE-PGM-ID            
      *                                                                         
           PERFORM VARYING INTF-SUB FROM 1 BY 1 UNTIL INTF-SUB > 50     
                      OR WS-COLUMN-NA (INTF-SUB) = SPACES               
              MOVE WS-COLUMN-NA (INTF-SUB) TO 1E-COLUMN-NA              
              MOVE WS-PREV-COLUMN-VALUE(INTF-SUB)                       
                                           TO 1E-PREV-COLUMN-VALUE      
              MOVE WS-CURR-COLUMN-VALUE(INTF-SUB)                       
                                           TO 1E-CURR-COLUMN-VALUE      
              PERFORM 8500-INSERT-INTF-CH  THRU 8500-EXIT               
           END-PERFORM.                                                 
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2900-END-OF-PROCESS.                                             
      *================================================================*        
      *                                                                         
           MOVE SPACES               TO WS-SYNC-DATE-PARM               
           SET LAST-SYNC-DATE        TO TRUE                            
           MOVE WS-CURR-DATE         TO WS-PARM-SYNC-DATE               
           MOVE WS-SYNC-DATE-PARM    TO G6-PARM-DATA                    
           PERFORM 8900-UPDATE-SYNC-DATE   THRU 8900-EXIT.              
      *                                                                         
           MOVE SPACES                     TO WS-RESTART-JOB-COMPLETE.  
      *                                                                         
           IF  WS-THIS-IS-A-RESTART                                     
               SET WS-RERUN-COMPLETED      TO TRUE                      
           ELSE                                                         
               SET WS-RUN-COMPLETED-NORMAL TO TRUE                      
           END-IF.                                                      
      *                                                                         
           IF TURN-ON-CHKP-COMMITS                                      
              PERFORM 6025-ISSUE-CHKP           THRU 6025-EXIT          
           END-IF.                                                      
      *                                                                         
           IF  WS-RESTART-REQ EQUAL WS-YES                              
               PERFORM 8893-RESET-RESTART-REQ-PARM  THRU 8893-EXIT      
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6025-ISSUE-CHKP.                                                 
      *================================================================*        
      * THIS PROCESS UPDATES/INSERTS THE RESTART DATA INTO CSS_RESTART *        
      * AND SAVES THE CHANGES TO DATABASE TILL THIS POINT              *        
      *----------------------------------------------------------------*        
      *                                                                         
           ADD 1                           TO WS-CHKP-SEQ-NO.           
           MOVE WS-CHKP-SEQ-NO             TO WS-RESTART-CHKP-SEQ-NO.   
      *                                                                         
           MOVE WS-FCSBW50-REC-NO          TO WS-RESTART-RECORD-NO.     
           MOVE WS-FCSBW50-REC-CNTR        TO WS-RESTART-REC-COUNT      
           MOVE WS-INPUT-DATE              TO WS-RESTART-INPUT-DATE     
           MOVE E-FBW50-SERVICE-POINT-ID   TO WS-RESTART-SP-ID          
           MOVE E-FBW50-ACCOUNT-NO         TO WS-RESTART-ACCOUNT-NO     
           MOVE E-FBW50-METER-NO           TO WS-RESTART-METER-NO       
      *                                                                         
           PERFORM 6030-WRITE-RSDDR THRU 6030-EXIT.                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY 'COMMIT # ' WS-RESTART-CHKP-SEQ-NO ' TAKEN. '        
                'LAST SERVICE POINT PROCESSED = ' WS-RESTART-SP-ID.     
      *                                                                         
           MOVE ZERO                       TO WS-CHKP-UPD-COUNTER       
                                              WS-CHKP-LUW-COUNTER.      
      *                                                                         
       6025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6030-WRITE-RSDDR.                                                
      *================================================================*        
      * POPULATES RESTART-DATA BEFORE IT IS STORED IN CSS_RESTART      *        
      * AND UPDATES/INSERTS DATA IN CSS_RESTART                        *        
      *----------------------------------------------------------------*        
      *                                                                         
           MOVE 1                          TO RF-PARTITION-NO.          
           MOVE PROGRAM-NAME               TO RF-NAME-PROGRAM.          
           MOVE 1                          TO RF-DUP-CNTRL-NO.          
           MOVE WS-RESTART-DATA            TO RF-RESTART-DATA-TEXT.     
           MOVE WS-RESTART-DATA-LENGTH     TO RF-RESTART-DATA-LEN.      
      *                                                                         
           PERFORM 8880-UPDATE-RESTART THRU 8880-EXIT.                  
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               PERFORM 8890-INSERT-RESTART THRU 8890-EXIT               
           END-IF.                                                      
      *                                                                         
       6030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *    6235-GET-FJC01-RESTART-REQ.                                          
       COPY CPD00035.                                                           
      *                                                                         
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
       COPY CPD00040.                                                           
      *                                                                         
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
       COPY CPD00037.                                                           
      *                                                                         
      *    6253-GET-FJC01-CHKP-LIMIT.                                           
       COPY CPD00034.                                                           
      *                                                                         
      *===============================================================*         
       7000-READ-FIOBW50.                                               
      *===============================================================*         
      *                                                                         
           READ FCSBW50-FILE                                            
                 AT END MOVE 'Y'          TO WS-BW50-EOF.               
      *                                                                         
           EVALUATE TRUE                                                
               WHEN FBW50-SUCCESSFUL                                    
                   ADD 1                       TO WS-FCSBW50-REC-CNTR   
                                                  WS-FCSBW50-REC-NO     
               WHEN BW50-EOF-REACHED                                    
                   CONTINUE                                             
               WHEN OTHER                                               
                   DISPLAY 'ERROR 7000, BW50 STATUS = '                 
                   WS-FBW50-STATUS                                      
                   DISPLAY '**  PROCESSING TERMINATED  **'              
                   PERFORM 9900-ABEND          THRU 9900-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7100-SELECT-SERVICE-POINT.                                       
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             SELECT [1D].SERVICE_POINT_ID                                 
                   ,[1D].ACCOUNT_NO                                       
                   ,[1D].METER_NO                                         
                   ,[1D].CODE_ACCT_STAT                                   
                   ,[1D].CODE_METER_STATUS                                
                   ,[1D].MTR_SERIAL_NO                                    
                   ,[1D].DEVICE_NO                                        
                   ,[1D].LOCAL_OFFICE                                     
                   ,[1D].READ_ROUTE                                       
                   ,[1D].BILL_CYCLE                                       
                   ,[1D].CODE_REVENUE_CLASS                               
                   ,[1D].RATE_PLAN_NO                                     
                   ,[1D].DIGTL_MTR_TYPE                                   
                   ,[1D].PROGRAM_ID                                       
                   ,[1D].REMOTE_READ_IND                                  
                   ,[1D].MTR_READ_SOURCE_CD                               
                   ,[1D].CONSTANT                                         
                   ,[1D].POINT_ID                                         
                   ,[1D].IDR_IDENT_NO                                     
                   ,[1D].ELEC_MTR_CLASS_CD                                
                   ,[1D].ELEC_MTR_SPEC_CD                                 
                   ,[1D].METER_SUPPLYING                                  
                   ,[1D].SECURED_RATE_FL                                  
                   ,[1D].TEMP_DATA                                        
                   ,[1D].READ_CYCLE                                       
               INTO :1D-SERVICE-POINT-ID                                
                   ,:1D-ACCOUNT-NO                                      
                   ,:1D-METER-NO                                        
                   ,:1D-CODE-ACCT-STAT                                  
                   ,:1D-CODE-METER-STATUS                               
                   ,:1D-MTR-SERIAL-NO                                   
                   ,:1D-DEVICE-NO                                       
                   ,:1D-LOCAL-OFFICE                                    
                   ,:1D-READ-ROUTE                                      
                   ,:1D-BILL-CYCLE                                      
                   ,:1D-CODE-REVENUE-CLASS                              
                   ,:1D-RATE-PLAN-NO                                    
                   ,:1D-DIGTL-MTR-TYPE                                  
                   ,:1D-PROGRAM-ID                                      
                   ,:1D-REMOTE-READ-IND                                 
                   ,:1D-MTR-READ-SOURCE-CD                              
                   ,:1D-CONSTANT                                        
                   ,:1D-POINT-ID                                        
                   ,:1D-IDR-IDENT-NO                                    
                   ,:1D-ELEC-MTR-CLASS-CD                               
                   ,:1D-ELEC-MTR-SPEC-CD                                
                   ,:1D-METER-SUPPLYING                                 
                   ,:1D-SECURED-RATE-FL                                 
                   ,:1D-TEMP-DATA                                       
A04202             ,:1D-READ-CYCLE                                      
               FROM CSS_MDM_SS_INTF  [1D] WITH(READUNCOMMITTED)                 
              WHERE [1D].SERVICE_POINT_ID = :1D-SERVICE-POINT-ID          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 1D.SERVICE_POINT_ID                                         
MFA-TR*            ,1D.ACCOUNT_NO                                               
MFA-TR*            ,1D.METER_NO                                                 
MFA-TR*            ,1D.CODE_ACCT_STAT                                           
MFA-TR*            ,1D.CODE_METER_STATUS                                        
MFA-TR*            ,1D.MTR_SERIAL_NO                                            
MFA-TR*            ,1D.DEVICE_NO                                                
MFA-TR*            ,1D.LOCAL_OFFICE                                             
MFA-TR*            ,1D.READ_ROUTE                                               
MFA-TR*            ,1D.BILL_CYCLE                                               
MFA-TR*            ,1D.CODE_REVENUE_CLASS                                       
MFA-TR*            ,1D.RATE_PLAN_NO                                             
MFA-TR*            ,1D.DIGTL_MTR_TYPE                                           
MFA-TR*            ,1D.PROGRAM_ID                                               
MFA-TR*            ,1D.REMOTE_READ_IND                                          
MFA-TR*            ,1D.MTR_READ_SOURCE_CD                                       
MFA-TR*            ,1D.CONSTANT                                                 
MFA-TR*            ,1D.POINT_ID                                                 
MFA-TR*            ,1D.IDR_IDENT_NO                                             
MFA-TR*            ,1D.ELEC_MTR_CLASS_CD                                        
MFA-TR*            ,1D.ELEC_MTR_SPEC_CD                                         
MFA-TR*            ,1D.METER_SUPPLYING                                          
MFA-TR*            ,1D.SECURED_RATE_FL                                          
MFA-TR*            ,1D.TEMP_DATA                                                
MFA-TR*            ,1D.READ_CYCLE                                               
MFA-TR*        INTO :1D-SERVICE-POINT-ID                                        
MFA-TR*            ,:1D-ACCOUNT-NO                                              
MFA-TR*            ,:1D-METER-NO                                                
MFA-TR*            ,:1D-CODE-ACCT-STAT                                          
MFA-TR*            ,:1D-CODE-METER-STATUS                                       
MFA-TR*            ,:1D-MTR-SERIAL-NO                                           
MFA-TR*            ,:1D-DEVICE-NO                                               
MFA-TR*            ,:1D-LOCAL-OFFICE                                            
MFA-TR*            ,:1D-READ-ROUTE                                              
MFA-TR*            ,:1D-BILL-CYCLE                                              
MFA-TR*            ,:1D-CODE-REVENUE-CLASS                                      
MFA-TR*            ,:1D-RATE-PLAN-NO                                            
MFA-TR*            ,:1D-DIGTL-MTR-TYPE                                          
MFA-TR*            ,:1D-PROGRAM-ID                                              
MFA-TR*            ,:1D-REMOTE-READ-IND                                         
MFA-TR*            ,:1D-MTR-READ-SOURCE-CD                                      
MFA-TR*            ,:1D-CONSTANT                                                
MFA-TR*            ,:1D-POINT-ID                                                
MFA-TR*            ,:1D-IDR-IDENT-NO                                            
MFA-TR*            ,:1D-ELEC-MTR-CLASS-CD                                       
MFA-TR*            ,:1D-ELEC-MTR-SPEC-CD                                        
MFA-TR*            ,:1D-METER-SUPPLYING                                         
MFA-TR*            ,:1D-SECURED-RATE-FL                                         
MFA-TR*            ,:1D-TEMP-DATA                                               
MFA-TR*            ,:1D-READ-CYCLE                                              
MFA-TR*        FROM CSS_MDM_SS_INTF  1D                                         
MFA-TR*       WHERE 1D.SERVICE_POINT_ID = :1D-SERVICE-POINT-ID                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7100          **'        
              DISPLAY '**   SERVICE_POINT_ID = ' 1D-SERVICE-POINT-ID    
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7200-GET-CURR-DATE.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURR-DATE                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURR-DATE = CURRENT DATE                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7200          **'        
              DISPLAY '**   GET CURRENT DATE                 **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7210-GET-CURR-TMST.                                              
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURR-TMST                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURR-TMST = CURRENT TIMESTAMP                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7210          **'        
              DISPLAY '**   GET CURRENT TIMESTAMP            **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  20231000
       7550-SELECT-RESTART-DATA.                                        
      *==============================================================*  20231000
      *                                                                         
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART                                       
                WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                 
                  AND PARTITION_NO   = :RF-PARTITION-NO                 
                  AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART                                               
MFA-TR*         WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                         
MFA-TR*           AND PARTITION_NO   = :RF-PARTITION-NO                         
MFA-TR*           AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                         
MFA-TR*        QUERYNO 7550                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7550          **'        
              DISPLAY '**   NAME_PROGRAM  = ' RF-NAME-PROGRAM           
              DISPLAY '**   PARTITION_NO  = ' RF-PARTITION-NO           
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  20231000
      * 7600-START-FCSJC01                                           *          
      *==============================================================*  20231000
           EXEC SQL                                                             
              INCLUDE CPDCA038                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*  20231000
      * 7620-START-FCSCA00 VSAM CTRL FILE     *                                 
      *==============================================================*  20231000
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *===============================================================*         
       8000-INSERT-INTF.                                                
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_MDM_SS_INTF                                
                   (SERVICE_POINT_ID                                    
                   ,ACCOUNT_NO                                          
                   ,METER_NO                                            
                   ,CODE_ACCT_STAT                                      
                   ,CODE_METER_STATUS                                   
                   ,MTR_SERIAL_NO                                       
                   ,DEVICE_NO                                           
                   ,LOCAL_OFFICE                                        
                   ,READ_ROUTE                                          
                   ,BILL_CYCLE                                          
                   ,CODE_REVENUE_CLASS                                  
                   ,RATE_PLAN_NO                                        
                   ,DIGTL_MTR_TYPE                                      
                   ,PROGRAM_ID                                          
                   ,REMOTE_READ_IND                                     
                   ,MTR_READ_SOURCE_CD                                  
                   ,CONSTANT                                            
                   ,POINT_ID                                            
                   ,IDR_IDENT_NO                                        
                   ,ELEC_MTR_CLASS_CD                                   
                   ,ELEC_MTR_SPEC_CD                                    
                   ,METER_SUPPLYING                                     
                   ,SECURED_RATE_FL                                     
                   ,LAST_SYNC_DATE                                      
                   ,LAST_UPDATE_PGM_ID                                  
                   ,LAST_UPDATE_TS                                      
A04202             ,TEMP_DATA                                           
A04202             ,READ_CYCLE                                          
A04202             )                                                    
               VALUES                                                   
                   (:1D-SERVICE-POINT-ID                                
                   ,:1D-ACCOUNT-NO                                      
                   ,:1D-METER-NO                                        
                   ,:1D-CODE-ACCT-STAT                                  
                   ,:1D-CODE-METER-STATUS                               
                   ,:1D-MTR-SERIAL-NO                                   
                   ,:1D-DEVICE-NO                                       
                   ,:1D-LOCAL-OFFICE                                    
                   ,:1D-READ-ROUTE                                      
                   ,:1D-BILL-CYCLE                                      
                   ,:1D-CODE-REVENUE-CLASS                              
                   ,:1D-RATE-PLAN-NO                                    
                   ,:1D-DIGTL-MTR-TYPE                                  
                   ,:1D-PROGRAM-ID                                      
                   ,:1D-REMOTE-READ-IND                                 
                   ,:1D-MTR-READ-SOURCE-CD                              
                   ,:1D-CONSTANT                                        
                   ,:1D-POINT-ID                                        
                   ,:1D-IDR-IDENT-NO                                    
                   ,:1D-ELEC-MTR-CLASS-CD                               
                   ,:1D-ELEC-MTR-SPEC-CD                                
                   ,:1D-METER-SUPPLYING                                 
                   ,:1D-SECURED-RATE-FL                                 
                   ,IIF(TRY_CONVERT(DATE, :1D-LAST-SYNC-DATE
              ) IS NULL OR (PATINDEX('%.%', :1D-LAST-SYNC-DATE
              ) <> 0) OR (LEN(:1D-LAST-SYNC-DATE
              ) <> 10), CIS.CHAR2DATE(:1D-LAST-SYNC-DATE
              ), CONVERT(DATE, :1D-LAST-SYNC-DATE) )                           
                   ,:1D-LAST-UPDATE-PGM-ID                              
                   ,CIS.CHAR2TIMESTAMP(:1D-LAST-UPDATE-TS)                      
A04202             ,:1D-TEMP-DATA                                       
A04202             ,:1D-READ-CYCLE                                      
A04202             )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_MDM_SS_INTF                                        
MFA-TR*            (SERVICE_POINT_ID                                            
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,METER_NO                                                    
MFA-TR*            ,CODE_ACCT_STAT                                              
MFA-TR*            ,CODE_METER_STATUS                                           
MFA-TR*            ,MTR_SERIAL_NO                                               
MFA-TR*            ,DEVICE_NO                                                   
MFA-TR*            ,LOCAL_OFFICE                                                
MFA-TR*            ,READ_ROUTE                                                  
MFA-TR*            ,BILL_CYCLE                                                  
MFA-TR*            ,CODE_REVENUE_CLASS                                          
MFA-TR*            ,RATE_PLAN_NO                                                
MFA-TR*            ,DIGTL_MTR_TYPE                                              
MFA-TR*            ,PROGRAM_ID                                                  
MFA-TR*            ,REMOTE_READ_IND                                             
MFA-TR*            ,MTR_READ_SOURCE_CD                                          
MFA-TR*            ,CONSTANT                                                    
MFA-TR*            ,POINT_ID                                                    
MFA-TR*            ,IDR_IDENT_NO                                                
MFA-TR*            ,ELEC_MTR_CLASS_CD                                           
MFA-TR*            ,ELEC_MTR_SPEC_CD                                            
MFA-TR*            ,METER_SUPPLYING                                             
MFA-TR*            ,SECURED_RATE_FL                                             
MFA-TR*            ,LAST_SYNC_DATE                                              
MFA-TR*            ,LAST_UPDATE_PGM_ID                                          
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,TEMP_DATA                                                   
MFA-TR*            ,READ_CYCLE                                                  
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (:1D-SERVICE-POINT-ID                                        
MFA-TR*            ,:1D-ACCOUNT-NO                                              
MFA-TR*            ,:1D-METER-NO                                                
MFA-TR*            ,:1D-CODE-ACCT-STAT                                          
MFA-TR*            ,:1D-CODE-METER-STATUS                                       
MFA-TR*            ,:1D-MTR-SERIAL-NO                                           
MFA-TR*            ,:1D-DEVICE-NO                                               
MFA-TR*            ,:1D-LOCAL-OFFICE                                            
MFA-TR*            ,:1D-READ-ROUTE                                              
MFA-TR*            ,:1D-BILL-CYCLE                                              
MFA-TR*            ,:1D-CODE-REVENUE-CLASS                                      
MFA-TR*            ,:1D-RATE-PLAN-NO                                            
MFA-TR*            ,:1D-DIGTL-MTR-TYPE                                          
MFA-TR*            ,:1D-PROGRAM-ID                                              
MFA-TR*            ,:1D-REMOTE-READ-IND                                         
MFA-TR*            ,:1D-MTR-READ-SOURCE-CD                                      
MFA-TR*            ,:1D-CONSTANT                                                
MFA-TR*            ,:1D-POINT-ID                                                
MFA-TR*            ,:1D-IDR-IDENT-NO                                            
MFA-TR*            ,:1D-ELEC-MTR-CLASS-CD                                       
MFA-TR*            ,:1D-ELEC-MTR-SPEC-CD                                        
MFA-TR*            ,:1D-METER-SUPPLYING                                         
MFA-TR*            ,:1D-SECURED-RATE-FL                                         
MFA-TR*            ,:1D-LAST-SYNC-DATE                                          
MFA-TR*            ,:1D-LAST-UPDATE-PGM-ID                                      
MFA-TR*            ,:1D-LAST-UPDATE-TS                                          
MFA-TR*            ,:1D-TEMP-DATA                                               
MFA-TR*            ,:1D-READ-CYCLE                                              
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8000          **'        
              DISPLAY '**   SERVICE_POINT_ID = ' 1D-SERVICE-POINT-ID    
              DISPLAY '**   ACCOUNT_NO       = ' 1D-ACCOUNT-NO          
              DISPLAY '**   METER_NO         = ' 1D-METER-NO            
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       8100-UPDATE-ALL-INTF.                                            
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_MDM_SS_INTF                                     
                SET ACCOUNT_NO         = :1D-ACCOUNT-NO                 
                   ,METER_NO           = :1D-METER-NO                   
                   ,CODE_ACCT_STAT     = :1D-CODE-ACCT-STAT             
                   ,CODE_METER_STATUS  = :1D-CODE-METER-STATUS          
                   ,MTR_SERIAL_NO      = :1D-MTR-SERIAL-NO              
                   ,DEVICE_NO          = :1D-DEVICE-NO                  
                   ,LOCAL_OFFICE       = :1D-LOCAL-OFFICE               
                   ,READ_ROUTE         = :1D-READ-ROUTE                 
                   ,BILL_CYCLE         = :1D-BILL-CYCLE                 
                   ,CODE_REVENUE_CLASS = :1D-CODE-REVENUE-CLASS         
                   ,RATE_PLAN_NO       = :1D-RATE-PLAN-NO               
                   ,DIGTL_MTR_TYPE     = :1D-DIGTL-MTR-TYPE             
                   ,PROGRAM_ID         = :1D-PROGRAM-ID                 
                   ,REMOTE_READ_IND    = :1D-REMOTE-READ-IND            
                   ,MTR_READ_SOURCE_CD = :1D-MTR-READ-SOURCE-CD         
                   ,CONSTANT           = :1D-CONSTANT                   
                   ,POINT_ID           = :1D-POINT-ID                   
                   ,IDR_IDENT_NO       = :1D-IDR-IDENT-NO               
                   ,ELEC_MTR_CLASS_CD  = :1D-ELEC-MTR-CLASS-CD          
                   ,ELEC_MTR_SPEC_CD   = :1D-ELEC-MTR-SPEC-CD           
                   ,METER_SUPPLYING    = :1D-METER-SUPPLYING            
                   ,SECURED_RATE_FL    = :1D-SECURED-RATE-FL            
                   ,LAST_SYNC_DATE     = IIF(TRY_CONVERT(DATE, 
                                                     :1D-LAST-SYNC-DATE
              ) IS NULL OR (PATINDEX('%.%', :1D-LAST-SYNC-DATE
              ) <> 0) OR (LEN(:1D-LAST-SYNC-DATE
              ) <> 10), CIS.CHAR2DATE(:1D-LAST-SYNC-DATE
              ), CONVERT(DATE, :1D-LAST-SYNC-DATE) )             
                   ,LAST_UPDATE_PGM_ID = :1D-LAST-UPDATE-PGM-ID         
                   ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :1D-LAST-UPDATE-TS
              )             
                   ,TEMP_DATA          = :1D-TEMP-DATA                  
A04202             ,READ_CYCLE         = :1D-READ-CYCLE                 
             WHERE SERVICE_POINT_ID = :1D-SERVICE-POINT-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_MDM_SS_INTF                                             
MFA-TR*         SET ACCOUNT_NO         = :1D-ACCOUNT-NO                         
MFA-TR*            ,METER_NO           = :1D-METER-NO                           
MFA-TR*            ,CODE_ACCT_STAT     = :1D-CODE-ACCT-STAT                     
MFA-TR*            ,CODE_METER_STATUS  = :1D-CODE-METER-STATUS                  
MFA-TR*            ,MTR_SERIAL_NO      = :1D-MTR-SERIAL-NO                      
MFA-TR*            ,DEVICE_NO          = :1D-DEVICE-NO                          
MFA-TR*            ,LOCAL_OFFICE       = :1D-LOCAL-OFFICE                       
MFA-TR*            ,READ_ROUTE         = :1D-READ-ROUTE                         
MFA-TR*            ,BILL_CYCLE         = :1D-BILL-CYCLE                         
MFA-TR*            ,CODE_REVENUE_CLASS = :1D-CODE-REVENUE-CLASS                 
MFA-TR*            ,RATE_PLAN_NO       = :1D-RATE-PLAN-NO                       
MFA-TR*            ,DIGTL_MTR_TYPE     = :1D-DIGTL-MTR-TYPE                     
MFA-TR*            ,PROGRAM_ID         = :1D-PROGRAM-ID                         
MFA-TR*            ,REMOTE_READ_IND    = :1D-REMOTE-READ-IND                    
MFA-TR*            ,MTR_READ_SOURCE_CD = :1D-MTR-READ-SOURCE-CD                 
MFA-TR*            ,CONSTANT           = :1D-CONSTANT                           
MFA-TR*            ,POINT_ID           = :1D-POINT-ID                           
MFA-TR*            ,IDR_IDENT_NO       = :1D-IDR-IDENT-NO                       
MFA-TR*            ,ELEC_MTR_CLASS_CD  = :1D-ELEC-MTR-CLASS-CD                  
MFA-TR*            ,ELEC_MTR_SPEC_CD   = :1D-ELEC-MTR-SPEC-CD                   
MFA-TR*            ,METER_SUPPLYING    = :1D-METER-SUPPLYING                    
MFA-TR*            ,SECURED_RATE_FL    = :1D-SECURED-RATE-FL                    
MFA-TR*            ,LAST_SYNC_DATE     = :1D-LAST-SYNC-DATE                     
MFA-TR*            ,LAST_UPDATE_PGM_ID = :1D-LAST-UPDATE-PGM-ID                 
MFA-TR*            ,LAST_UPDATE_TS     = :1D-LAST-UPDATE-TS                     
MFA-TR*            ,TEMP_DATA          = :1D-TEMP-DATA                          
MFA-TR*            ,READ_CYCLE         = :1D-READ-CYCLE                         
MFA-TR*      WHERE SERVICE_POINT_ID = :1D-SERVICE-POINT-ID                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8100          **'        
              DISPLAY '**   SERVICE_POINT_ID = ' 1D-SERVICE-POINT-ID    
              DISPLAY '**   ACCOUNT_NO       = ' 1D-ACCOUNT-NO          
              DISPLAY '**   METER_NO         = ' 1D-METER-NO            
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       8200-UPDATE-SYNC-INTF.                                           
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_MDM_SS_INTF                                     
                SET LAST_SYNC_DATE  = IIF(TRY_CONVERT(DATE, 
                                                     :1D-LAST-SYNC-DATE
              ) IS NULL OR (PATINDEX('%.%', :1D-LAST-SYNC-DATE
              ) <> 0) OR (LEN(:1D-LAST-SYNC-DATE
              ) <> 10), CIS.CHAR2DATE(:1D-LAST-SYNC-DATE
              ), CONVERT(DATE, :1D-LAST-SYNC-DATE) )                
             WHERE SERVICE_POINT_ID = :1D-SERVICE-POINT-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_MDM_SS_INTF                                             
MFA-TR*         SET LAST_SYNC_DATE  = :1D-LAST-SYNC-DATE                        
MFA-TR*      WHERE SERVICE_POINT_ID = :1D-SERVICE-POINT-ID                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8200          **'        
              DISPLAY '**   SERVICE_POINT_ID = ' 1D-SERVICE-POINT-ID    
              DISPLAY '**   ACCOUNT_NO       = ' 1D-ACCOUNT-NO          
              DISPLAY '**   METER_NO         = ' 1D-METER-NO            
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       8500-INSERT-INTF-CH.                                             
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_MDM_SS_INTF_CH                             
                   (SERVICE_POINT_ID                                    
                   ,COLUMN_NA                                           
                   ,LAST_UPDATE_TS                                      
                   ,PREV_COLUMN_VALUE                                   
                   ,CURR_COLUMN_VALUE                                   
                   ,LAST_UPDATE_PGM_ID )                                
               VALUES                                                   
                   (:1E-SERVICE-POINT-ID                                
                   ,:1E-COLUMN-NA                                       
                   ,CIS.CHAR2TIMESTAMP(:1E-LAST-UPDATE-TS)                      
                   ,:1E-PREV-COLUMN-VALUE                               
                   ,:1E-CURR-COLUMN-VALUE                               
                   ,:1E-LAST-UPDATE-PGM-ID )                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_MDM_SS_INTF_CH                                     
MFA-TR*            (SERVICE_POINT_ID                                            
MFA-TR*            ,COLUMN_NA                                                   
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,PREV_COLUMN_VALUE                                           
MFA-TR*            ,CURR_COLUMN_VALUE                                           
MFA-TR*            ,LAST_UPDATE_PGM_ID )                                        
MFA-TR*        VALUES                                                           
MFA-TR*            (:1E-SERVICE-POINT-ID                                        
MFA-TR*            ,:1E-COLUMN-NA                                               
MFA-TR*            ,:1E-LAST-UPDATE-TS                                          
MFA-TR*            ,:1E-PREV-COLUMN-VALUE                                       
MFA-TR*            ,:1E-CURR-COLUMN-VALUE                                       
MFA-TR*            ,:1E-LAST-UPDATE-PGM-ID )                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8500          **'        
              DISPLAY '**   SERVICE_POINT_ID = ' 1E-SERVICE-POINT-ID    
              DISPLAY '**   ACCOUNT_NO       = ' 1D-ACCOUNT-NO          
              DISPLAY '**   METER_NO         = ' 1D-METER-NO            
              DISPLAY '**   COLUMN_NA        = ' 1E-COLUMN-NA           
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8880-UPDATE-RESTART.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8880          **'        
              DISPLAY '**   NAME_PROGRAM  = ' RF-NAME-PROGRAM           
              DISPLAY '**   PARTITION_NO  = ' RF-PARTITION-NO           
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8880-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8890-INSERT-RESTART.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM                                        
                   ,PARTITION_NO                                        
                   ,DUP_CNTRL_NO                                        
                   ,RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM                                    
                   ,:RF-PARTITION-NO                                    
                   ,:RF-DUP-CNTRL-NO                                    
                   ,:RF-RESTART-DATA)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8890          **'        
              DISPLAY '**   NAME_PROGRAM  = ' RF-NAME-PROGRAM           
              DISPLAY '**   PARTITION_NO  = ' RF-PARTITION-NO           
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8893-RESET-RESTART-REQ-PARM                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *================================================================*        
       8900-UPDATE-SYNC-DATE.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                UPDATE  CSS_JOB_PARM                                    
                   SET  PARM_DATA    = :G6-PARM-DATA                    
                 WHERE PROGRAM_NAME  = :PROGRAM-NAME                    
                   AND COMPANY_NO    = '01'                             
                   AND CMND_CODE     = :WS-PARM                         
                   AND CHARINDEX('LAST-SYNC-DATE=', PARM_DATA
            COLLATE Latin1_General_CS_AS) = 1         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE  CSS_JOB_PARM                                            
MFA-TR*            SET  PARM_DATA    = :G6-PARM-DATA                            
MFA-TR*          WHERE PROGRAM_NAME  = :PROGRAM-NAME                            
MFA-TR*            AND COMPANY_NO    = '01'                                     
MFA-TR*            AND CMND_CODE     = :WS-PARM                                 
MFA-TR*            AND POSSTR(PARM_DATA, 'LAST-SYNC-DATE=') = 1                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW151 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8900          **'        
              DISPLAY '**   JOB PARM UPDATE ERROR            **'        
              DISPLAY '**   G6-PARM-DATA     = ' G6-PARM-DATA           
              DISPLAY '**   PROGRAM-NAME     = ' PROGRAM-NAME           
              DISPLAY '**   CMND_CODE        = ' WS-PARM                
              DISPLAY '**   PARM_DATA LIKE  LAST-SYNC-DATE=  **'        
              DISPLAY '**   SQL CODE         = ' WS-DISPLAY-SQLCODE     
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       9000-TERMINATE.                                                  
      *===============================================================*         
      *                                                                         
           CLOSE FCSBW50-FILE.                                          
      *                                                                         
           IF FBW50-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**  PCSBW151 PROCESSING ERROR         **'        
              DISPLAY '**  CLOSE ERROR  - OUTPUT FILES       **'        
              DISPLAY '**  FILE STATUS = ' WS-FBW50-STATUS              
              DISPLAY '**  UNSUCCESSFUL CLOSE OF FIOBW50     **'        
              DISPLAY '****************************************'        
           END-IF.                                                      
      *                                                                         
           DISPLAY ' '.                                                 
           DISPLAY '************************************************'.  
           DISPLAY ' '.                                                 
           DISPLAY '** TOTAL RECS PROCESSED FROM BW50 = '               
                                 WS-FCSBW50-REC-CNTR ' **'.             
           DISPLAY ' '.                                                 
           DISPLAY '************************************************'.  
           DISPLAY ' '.                                                 
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
      * 9700-PROCESS-ABEND  (REQUIED BY CPD00040)                      *        
      *================================================================*        
       COPY CPD0023B.                                                           
      *                                                                         
      *================================================================*        
      * 9900-ABEND INCLUDES SQL ROLLBACK                               *        
      *================================================================*        
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
