       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW150.                                        
       INSTALLATION.                                                    
       DATE-WRITTEN.   JUN 2011.                                        
           DATE-COMPILED.                                               
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                     DB2                        *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** =====      ========      ======                             **         
      ** 06/15/11   NC94746       DEVELOPMENT OF NEW PROGRAM         **         
A03706** 07/11/12   VP43661       ADDED METER READ SOURCE 'X'        **         
A04202** 07/11/12   VENKAT.P      ADDED READ-CYCLE FOR G_DASA        **         
PRJ914** 10/07/15   SS95855       OPENWAY AMI METERING               **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSBW150 NARRATIVE                        
      *                                                                         
           THIS PROGRAM IS TO EXTRACT SMART SYNCH & MV 90 METER DATA    
           AND CREATE DAILY GDG FILE TO BE USED TO SYNCH UP TMS AND     
           MDMS SYSTEMS WITH CIS CHANGES.                               
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      * SELECT STMT FOR BW50 FILE  *                                            
       COPY CSSBW50.                                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBW50.                                                            
       COPY FIOBW50.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW150'.
MSQ017     COPY MFASQLM.
       01  WS-START                     PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSBW150 STARTS HERE'.            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-YES                    PIC X(01)  VALUE 'Y'.          
           05  WS-Y                      PIC X(01)  VALUE 'Y'.          
           05  WS-N                      PIC X(01)  VALUE 'N'.          
           05  WS-U                      PIC X(01)  VALUE 'U'.          
           05  WS-I                      PIC X(01)  VALUE 'I'.          
           05  WS-NO                     PIC X(01)  VALUE 'N'.          
           05  WS-PGRMNAME               PIC X(08)  VALUE 'PCSBW150'.   
           05  PROGRAM-NAME              PIC X(08)  VALUE 'PCSBW150'.   
           05  RS-RETURN-CODE            PIC S9(09) VALUE +000 COMP.    
           05  RS-RETURN-CODE-DISP       PIC S9(09) VALUE +000 COMP.    
           05  WS-HEADER-FIOBW50.                                       
               10 WS-HEADER-DATE-TXT     PIC X(09) VALUE 'RUN DATE='.   
               10 WS-HEADER-DATE-YYYY-MM-DD  PIC X(10)  VALUE SPACES.   
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FBW50-STATUS           PIC X(02).                     
               88  FBW50-SUCCESSFUL                 VALUE '00'.         
           05  WS-ACC-CHNG-SW            PIC X(01)  VALUE 'N'.          
               88 NOT-SAME-ACCOUNT                  VALUE 'N'.          
               88 SAME-ACCOUNT                      VALUE 'Y'.          
           05  WS-CPD99-MATCH-SW         PIC X(01)  VALUE 'A'.          
               88 CPD99-NOT-EXECUTED                VALUE 'A'.          
               88 CPD99-EXECUTED                    VALUE 'B', 'C'.     
               88 LATEST-ACCOUNT                    VALUE 'B'.          
               88 NOT-LATEST-ACCOUNT                VALUE 'C'.          
      *                                                                         
       01  WS-WORK-AREA.                                                
           05 SUB                        PIC 9(02)  VALUE ZEROS.        
           05 WS-POINT-ID.                                              
              10 WS-AREA-ID              PIC X(03)  VALUE SPACES.       
              10 WS-TAG-NM               PIC X(07)  VALUE SPACES.       
           05 WS-SERVICE-POINT-ID.                                      
              10 WS-COMPANY-NO           PIC X(02)  VALUE SPACES.       
              10 WS-PREMISE-NO           PIC 9(10)  VALUE ZEROES.       
              10 WS-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.       
              10 WS-IC-NO                PIC 9(04)  VALUE ZEROES.       
              10 WS-MTR-REF-NO           PIC 9(04)  VALUE ZEROES.       
           05 WS-ACCOUNT-NO              PIC S9(13)V COMP-3 VALUE ZERO. 
           05 WS-PRIOR-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE ZERO. 
           05 WS-FCSBW50-REC-CNTR        PIC 9(09) VALUE ZERO.          
           05 WS-DISPLAY-SQLCODE         PIC ---9.                      
      *                                                                         
      *=============================================================*           
      * FCA00-KEY                                                   *           
      *=============================================================*           
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      *                                                                         
      *===============================================================*         
      * IO AREA FOR PARM INPUT FILE 'A'                             *           
      *===============================================================*         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DB2 TABLE DCLGENS USING IN THIS PROGRAM                              
      *****************************************************************         
      *---------------------------------------------------------------*         
      * CSS_ACCOUNT (AT)                                                        
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_MTRD_ENVRNMT (MN)                                                   
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_UTIL_ENVRNMT (UT)                                                   
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_EQUIPMENT (EQ)                                                      
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_JOB_PARM (G6)                                                       
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_METER_ATTCHMTS (MA)                                                 
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_IDR_ACCT_MTR (L7)                                                   
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBIDRATM                                                 
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_RATE_PLAN_DESC (RD)                                                 
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_PIM_POINT (PP)                                                      
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBPIMPNT                                                 
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_ELEC_METER (EM)                                                     
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_MTR_CAP (MC)                                                        
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
      *---------------------------------------------------------------*         
      * CSS_PREMISE (PR)                                                        
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      * ABEND SWITCH         *                                                  
       COPY CWS09900.                                                           
      * WARNING DATA         *                                                  
       COPY CWS00303.                                                           
      * WS ABEND WORK AREA   *                                                  
       COPY CWS00010.                                                           
      * MISC INPUT           *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      * FCA00 MISC INPUT     *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      * WOKING STORAGE FOR CPDCA099                                             
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSBW150 ENDS HERE  '.            
      *                                                                         
      ******************* BEGIN CURSOR DECLARATION ********************         
      *                                                                         
      **************************************                                    
      **  CURSOR DECLARATION -- METER_CSR **                                    
      **************************************                                    
           EXEC SQL                                                     
            DECLARE METER_CSR CURSOR FOR                                
             SELECT AT.ACCOUNT_NO                                       
                   ,AT.CUSTOMER_NO                                      
                   ,AT.BILL_CYCLE                                       
                   ,AT.CODE_ACCT_STAT                                   
                   ,AT.LOCAL_OFFICE                                     
                   ,AT.PREMISE_NO                                       
                   ,AT.COMPANY_NO                                       
                   ,UT.CODE_UTIL_TYPE                                   
                   ,UT.IC_NO                                            
                   ,UT.CODE_REVENUE_CLASS                               
                   ,UT.RATE_PLAN_NO                                     
                   ,UT.READ_ROUTE                                       
A04202             ,UT.READ_CYCLE                                       
                   ,MN.MTR_REF_NO                                       
                   ,MN.CODE_TIME_PERIOD                                 
                   ,MN.METER_NO                                         
                   ,MN.CODE_METER_STATUS                                
                   ,MN.CODE_USAGE_TYPE                                  
                   ,MN.CODE_USAGE_ID                                    
                   ,MN.REG_ID_NO                                        
                   ,MN.CODE_CRNT_REG_READ                               
                   ,MN.CODE_LAST_REG_READ                               
                   ,REPLACE(CONVERT(CHAR(8), MN.LAST_REG_READ_TIME
           , 108), ':', '.') LAST_REG_READ_TIME                               
                   ,MN.LAST_REG_READ_DATE                               
                   ,MN.LAST_READ_VALUE                                  
                   ,MN.GIS_POINT_ID                                     
                   ,MN.METER_SUPPLYING                                  
                   ,MN.DIGTL_MTR_TYPE                                   
                   ,MN.REMOTE_READ_IND                                  
                   ,MN.MTR_READ_SOURCE_CD                               
                   ,MN.PROGRAM_ID                                       
               FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                   
                   ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                   
                   ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
              WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO               
                AND MN.ACCOUNT_NO         = UT.ACCOUNT_NO               
                AND MN.IC_NO              = UT.IC_NO                    
                AND MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE           
                AND MN.CODE_UTIL_TYPE     = 'E'                         
                AND (                                                   
PRJ914               MN.MTR_READ_SOURCE_CD IN ('R','M','P') OR          
A03706               (MN.MTR_READ_SOURCE_CD =  'X'   AND                
A03706                UT.CODE_REVENUE_CLASS <> '000' AND                
A03706                UT.RATE_PLAN_NO       <> '000' )                  
                    )                                                   
                AND MN.CODE_METER_STATUS  <> 'K'                        
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE METER_CSR CURSOR FOR                                        
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.CUSTOMER_NO                                              
MFA-TR*            ,AT.BILL_CYCLE                                               
MFA-TR*            ,AT.CODE_ACCT_STAT                                           
MFA-TR*            ,AT.LOCAL_OFFICE                                             
MFA-TR*            ,AT.PREMISE_NO                                               
MFA-TR*            ,AT.COMPANY_NO                                               
MFA-TR*            ,UT.CODE_UTIL_TYPE                                           
MFA-TR*            ,UT.IC_NO                                                    
MFA-TR*            ,UT.CODE_REVENUE_CLASS                                       
MFA-TR*            ,UT.RATE_PLAN_NO                                             
MFA-TR*            ,UT.READ_ROUTE                                               
MFA-TR*            ,UT.READ_CYCLE                                               
MFA-TR*            ,MN.MTR_REF_NO                                               
MFA-TR*            ,MN.CODE_TIME_PERIOD                                         
MFA-TR*            ,MN.METER_NO                                                 
MFA-TR*            ,MN.CODE_METER_STATUS                                        
MFA-TR*            ,MN.CODE_USAGE_TYPE                                          
MFA-TR*            ,MN.CODE_USAGE_ID                                            
MFA-TR*            ,MN.REG_ID_NO                                                
MFA-TR*            ,MN.CODE_CRNT_REG_READ                                       
MFA-TR*            ,MN.CODE_LAST_REG_READ                                       
MFA-TR*            ,MN.LAST_REG_READ_TIME                                       
MFA-TR*            ,MN.LAST_REG_READ_DATE                                       
MFA-TR*            ,MN.LAST_READ_VALUE                                          
MFA-TR*            ,MN.GIS_POINT_ID                                             
MFA-TR*            ,MN.METER_SUPPLYING                                          
MFA-TR*            ,MN.DIGTL_MTR_TYPE                                           
MFA-TR*            ,MN.REMOTE_READ_IND                                          
MFA-TR*            ,MN.MTR_READ_SOURCE_CD                                       
MFA-TR*            ,MN.PROGRAM_ID                                               
MFA-TR*        FROM CSS_ACCOUNT      AT                                         
MFA-TR*            ,CSS_MTRD_ENVRNMT MN                                         
MFA-TR*            ,CSS_UTIL_ENVRNMT UT                                         
MFA-TR*       WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO                       
MFA-TR*         AND MN.ACCOUNT_NO         = UT.ACCOUNT_NO                       
MFA-TR*         AND MN.IC_NO              = UT.IC_NO                            
MFA-TR*         AND MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE                   
MFA-TR*         AND MN.CODE_UTIL_TYPE     = 'E'                                 
MFA-TR*         AND (                                                           
MFA-TR*              MN.MTR_READ_SOURCE_CD IN ('R','M','P') OR                  
MFA-TR*              (MN.MTR_READ_SOURCE_CD =  'X'   AND                        
MFA-TR*               UT.CODE_REVENUE_CLASS <> '000' AND                        
MFA-TR*               UT.RATE_PLAN_NO       <> '000' )                          
MFA-TR*             )                                                           
MFA-TR*         AND MN.CODE_METER_STATUS  <> 'K'                                
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
PRJ914*              (MN.MTR_READ_SOURCE_CD =  'I'   AND                        
PRJ914*               MN.REMOTE_READ_IND = 'T')                                 
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
      *                                                                         
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
      *                                                                         
           PERFORM 1000-PROCESS-CURSOR     THRU 1000-EXIT.              
      *                                                                         
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           OPEN OUTPUT FCSBW50-FILE                                     
      *                                                                         
           IF  FBW50-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** 0100-ERROR ON FCSBW50 OPEN. STATUS IS '      
                                  WS-FBW50-STATUS                       
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               DISPLAY 'COMMON DATE ==> ' WS-FCA00-COMMON-DATE          
               MOVE WS-FCA00-COMMON-DATE   TO WS-INPUT-DATE             
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE          TO WS-HEADER-DATE-YYYY-MM-DD.    
           MOVE WS-HEADER-FIOBW50      TO FIOBW50.                      
           PERFORM 8000-WRITE-FIOBW50 THRU 8000-EXIT.                   
           MOVE ZEROS                  TO WS-FCSBW50-REC-CNTR.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-PROCESS-CURSOR.                                             
      *================================================================*        
      *                                                                         
           PERFORM 7100-OPEN-METER-CURSOR  THRU 7100-EXIT.              
      *                                                                         
           PERFORM 7110-FETCH-METER-CURSOR THRU 7110-EXIT.              
      *                                                                         
           PERFORM 1100-PROCESS-METER-CSR  THRU 1100-EXIT               
                 UNTIL WS-ACTIVE-RETURN-CODE =  NOT-FOUND.              
      *                                                                         
           PERFORM 7120-CLOSE-METER-CURSOR THRU 7120-EXIT.              
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1100-PROCESS-METER-CSR.                                          
      *================================================================*        
      *                                                                         
           IF WS-PRIOR-ACCOUNT-NO = AT-ACCOUNT-NO                       
              SET SAME-ACCOUNT             TO TRUE                      
           ELSE                                                         
              SET NOT-SAME-ACCOUNT         TO TRUE                      
              SET CPD99-NOT-EXECUTED       TO TRUE                      
              MOVE AT-ACCOUNT-NO           TO WS-PRIOR-ACCOUNT-NO       
           END-IF.                                                      
      *                                                                         
           MOVE AT-PREMISE-NO              TO WS-CPD99-PREMISE-NO       
                                              PR-PREMISE-NO             
           IF CPD99-NOT-EXECUTED                                        
              PERFORM 6990-FETCH-CUR-ACCOUNT  THRU  6990-EXIT           
              IF WS-CPD99-ACCOUNT-NO EQUAL AT-ACCOUNT-NO                
                 SET LATEST-ACCOUNT        TO TRUE                      
              ELSE                                                      
                 SET NOT-LATEST-ACCOUNT    TO TRUE                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF LATEST-ACCOUNT                                            
              PERFORM 1120-GET-OTHER-DATA       THRU 1120-EXIT          
              PERFORM 1150-PROCESS-OUTPUT       THRU 1150-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 7110-FETCH-METER-CURSOR THRU 7110-EXIT.              
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1120-GET-OTHER-DATA.                                             
      *================================================================*        
      *                                                                         
           MOVE AT-ACCOUNT-NO              TO WS-ACCOUNT-NO             
                                              MN-ACCOUNT-NO             
                                              L7-ACCOUNT-NO             
           MOVE AT-COMPANY-NO              TO EM-COMPANY-NO             
                                              MC-COMPANY-NO             
                                              MA-COMPANY-NO             
                                              EQ-COMPANY-NO             
           MOVE UT-CODE-UTIL-TYPE          TO EM-CODE-UTIL-TYPE         
                                              MC-CODE-UTIL-TYPE         
                                              MA-CODE-UTIL-TYPE         
                                              EQ-CODE-UTIL-TYPE         
                                              RD-CODE-UTIL-TYPE         
                                              L7-CODE-UTIL-TYPE         
           MOVE MN-METER-NO                TO EM-METER-NO               
                                              MC-METER-NO               
                                              MA-METER-NO               
                                              L7-METER-NO               
                                              EQ-DEVICE-NO              
           MOVE UT-RATE-PLAN-NO            TO RD-RATE-PLAN-NO           
           MOVE MN-REG-ID-NO               TO MC-REG-ID-NO              
PRJ914     MOVE SPACES                     TO PR-LOCAL-OFFICE           
PRJ914     PERFORM 7125-GET-LOCAL-OFFICE   THRU 7125-EXIT               
      *                                                                         
           MOVE SPACES                     TO EQ-SERIAL-NO              
           PERFORM 7130-GET-MTR-SERIAL     THRU 7130-EXIT               
      *                                                                         
           MOVE SPACES                     TO MA-DEVICE-NO              
           IF MN-MTR-READ-SOURCE-CD = 'R'                               
              PERFORM 7140-GET-SS-DEVICE      THRU 7140-EXIT            
           END-IF                                                       
      *                                                                         
           MOVE ZEROS                      TO MC-CONSTANT               
           PERFORM 7150-GET-MTR-CONSTANT   THRU 7150-EXIT               
      *                                                                         
           MOVE SPACES                     TO L7-IDR-IDENT-NO           
           IF MN-MTR-READ-SOURCE-CD = 'M'                               
              PERFORM 7160-GET-IDR-IDENT-NO   THRU 7160-EXIT            
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                     TO EM-ELEC-MTR-CLASS-CD      
                                              EM-ELEC-MTR-SPEC-CD       
           PERFORM 7170-GET-ELEC-CLASS-SPEC THRU 7170-EXIT.             
      *                                                                         
           MOVE 'N'                        TO RD-SECURED-RATE-FL        
           PERFORM 7180-CHECK-RATE-PLAN-DESC THRU 7180-EXIT.            
      *                                                                         
           MOVE SPACES                     TO PP-AREA-ID                
                                              PP-TAG-NM.                
           IF MN-GIS-POINT-ID > 0                                       
              PERFORM 7190-GET-GIS-LOC-AND-TAG  THRU 7190-EXIT          
           END-IF.                                                      
      *                                                                         
       1120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       1150-PROCESS-OUTPUT.                                             
      *================================================================*        
      *                                                                         
           INITIALIZE FIOBW50.                                          
      *                                                                         
           MOVE AT-COMPANY-NO             TO WS-COMPANY-NO              
           MOVE AT-PREMISE-NO             TO WS-PREMISE-NO              
           MOVE UT-CODE-UTIL-TYPE         TO WS-CODE-UTIL-TYPE          
           MOVE UT-IC-NO                  TO WS-IC-NO                   
           MOVE MN-MTR-REF-NO             TO WS-MTR-REF-NO              
           MOVE WS-SERVICE-POINT-ID       TO E-FBW50-SERVICE-POINT-ID   
           MOVE AT-ACCOUNT-NO             TO E-FBW50-ACCOUNT-NO         
           MOVE MN-METER-NO               TO E-FBW50-METER-NO           
      *                                                                         
           IF AT-CODE-ACCT-STAT = 'A'                                   
              MOVE AT-CODE-ACCT-STAT      TO E-FBW50-CODE-ACCT-STAT     
           ELSE                                                         
              MOVE 'B'                    TO E-FBW50-CODE-ACCT-STAT     
           END-IF.                                                      
      *                                                                         
           EVALUATE MN-CODE-METER-STATUS                                
              WHEN 'J'                                                  
              WHEN 'A'                                                  
              WHEN 'I'                                                  
              WHEN 'K'                                                  
                MOVE MN-CODE-METER-STATUS TO E-FBW50-CODE-METER-STATUS  
              WHEN 'B'                                                  
                MOVE 'A'                  TO E-FBW50-CODE-METER-STATUS  
              WHEN '0'                                                  
              WHEN '1'                                                  
                MOVE 'I'                  TO E-FBW50-CODE-METER-STATUS  
              WHEN OTHER                                                
                MOVE 'A'                  TO E-FBW50-CODE-METER-STATUS  
           END-EVALUATE.                                                
      *                                                                         
           MOVE EQ-SERIAL-NO              TO E-FBW50-MTR-SERIAL-NO      
           MOVE MA-DEVICE-NO              TO E-FBW50-DEVICE-NO          
PRJ914     MOVE PR-LOCAL-OFFICE           TO E-FBW50-LOCAL-OFFICE       
      *                                                                         
           MOVE UT-READ-ROUTE             TO E-FBW50-READ-ROUTE         
A04202     MOVE UT-READ-CYCLE             TO E-FBW50-READ-CYCLE         
           MOVE AT-BILL-CYCLE             TO E-FBW50-BILL-CYCLE         
           MOVE UT-CODE-REVENUE-CLASS     TO E-FBW50-CODE-REVENUE-CLASS 
           MOVE UT-RATE-PLAN-NO           TO E-FBW50-RATE-PLAN-NO       
           MOVE MN-DIGTL-MTR-TYPE         TO E-FBW50-DIGTL-MTR-TYPE     
           MOVE MN-PROGRAM-ID             TO E-FBW50-PROGRAM-ID         
           MOVE MN-MTR-READ-SOURCE-CD     TO E-FBW50-MTR-READ-SOURCE-CD 
           MOVE MN-REMOTE-READ-IND        TO E-FBW50-REMOTE-READ-IND    
           MOVE MC-CONSTANT               TO E-FBW50-CONSTANT           
      *                                                                         
           MOVE PP-AREA-ID                TO WS-AREA-ID                 
           MOVE PP-TAG-NM                 TO WS-TAG-NM                  
           MOVE WS-POINT-ID               TO E-FBW50-POINT-ID           
      *                                                                         
           IF L7-IDR-IDENT-NO (1:1) = 'T'                               
              MOVE L7-IDR-IDENT-NO (2:)   TO E-FBW50-IDR-IDENT-NO       
           ELSE                                                         
              MOVE L7-IDR-IDENT-NO        TO E-FBW50-IDR-IDENT-NO       
           END-IF.                                                      
      *                                                                         
           MOVE EM-ELEC-MTR-CLASS-CD     TO E-FBW50-ELEC-MTR-CLASS-CD   
           MOVE EM-ELEC-MTR-SPEC-CD      TO E-FBW50-ELEC-MTR-SPEC-CD    
           MOVE MN-METER-SUPPLYING       TO E-FBW50-METER-SUPPLYING     
           MOVE RD-SECURED-RATE-FL       TO E-FBW50-SECURED-RATE-FL     
      *                                                                         
           PERFORM 8000-WRITE-FIOBW50  THRU 8000-EXIT.                  
      *                                                                         
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
       COPY CPD00040.                                                           
      *                                                                         
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
       COPY CPD00037.                                                           
      *                                                                         
      *==============================================================*  20231000
      * 6990-FETCH-CUR-ACCOUNT                                       *          
      *==============================================================*  20231000
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.           *          
      *--------------------------------------------------------------*  20231000
           EXEC SQL                                                             
                INCLUDE CPDCA099                                                
           END-EXEC.                                                            
      *                                                                 20231000
      *==============================================================*  20231000
       6995-CPD99-ERROR-ROUTINE.                                        
      *==============================================================*  20231000
      *                                                                 20231000
           MOVE ZEROES                     TO  WS-CPD99-ACCOUNT-NO.     
      *                                                                 20231000
           DISPLAY '****************** PCSBW150 ***************'.       
           DISPLAY '* ERROR IN PARA ', ACTIVE-PARAGRAPH                 
           DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO               
           DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE               
           DISPLAY '*******************************************'.       
           PERFORM 9900-ABEND     THRU  9900-EXIT.                      
      *                                                                 20231000
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7100-OPEN-METER-CURSOR.                                          
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               OPEN METER_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW150 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7100          **'        
              DISPLAY '**   CODE_UTIL_TYPE     = E           **'        
              DISPLAY '**   MTR_READ_SOURCE_CD IN (R, M)     **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7110-FETCH-METER-CURSOR.                                         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             FETCH  METER_CSR                                           
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-PREMISE-NO                                      
                   ,:AT-COMPANY-NO                                      
                   ,:UT-CODE-UTIL-TYPE                                  
                   ,:UT-IC-NO                                           
                   ,:UT-CODE-REVENUE-CLASS                              
                   ,:UT-RATE-PLAN-NO                                    
                   ,:UT-READ-ROUTE                                      
A04202             ,:UT-READ-CYCLE                                      
                   ,:MN-MTR-REF-NO                                      
                   ,:MN-CODE-TIME-PERIOD                                
                   ,:MN-METER-NO                                        
                   ,:MN-CODE-METER-STATUS                               
                   ,:MN-CODE-USAGE-TYPE                                 
                   ,:MN-CODE-USAGE-ID                                   
                   ,:MN-REG-ID-NO                                       
                   ,:MN-CODE-CRNT-REG-READ                              
                   ,:MN-CODE-LAST-REG-READ                              
                   ,:MN-LAST-REG-READ-TIME                              
                   ,:MN-LAST-REG-READ-DATE                              
                   ,:MN-LAST-READ-VALUE                                 
                   ,:MN-GIS-POINT-ID                                    
                   ,:MN-METER-SUPPLYING                                 
                   ,:MN-DIGTL-MTR-TYPE                                  
                   ,:MN-REMOTE-READ-IND                                 
                   ,:MN-MTR-READ-SOURCE-CD                              
                   ,:MN-PROGRAM-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW150 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7110          **'        
              DISPLAY '**   CODE_UTIL_TYPE     = E           **'        
              DISPLAY '**   MTR_READ_SOURCE_CD IN (R, M)     **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7120-CLOSE-METER-CURSOR.                                         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               CLOSE METER_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW150 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7120          **'        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
PRJ914*===============================================================*         
PRJ914 7125-GET-LOCAL-OFFICE.                                           
PRJ914*===============================================================*         
PRJ914*                                                                         
PRJ914     EXEC SQL                                                     
PRJ914         SELECT  PR.LOCAL_OFFICE                                  
PRJ914           INTO :PR-LOCAL-OFFICE                                  
PRJ914           FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                      
PRJ914          WHERE  PR.PREMISE_NO = :PR-PREMISE-NO                   
PRJ914                                                           
PRJ914                                                      
PRJ914     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  PR.LOCAL_OFFICE                                          
MFA-TR*          INTO :PR-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_PREMISE PR                                            
MFA-TR*         WHERE  PR.PREMISE_NO = :PR-PREMISE-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7125                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ914*                                                                         
PRJ914     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
PRJ914*                                                                         
PRJ914     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
PRJ914        CONTINUE                                                  
PRJ914     ELSE                                                         
PRJ914        MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
PRJ914        DISPLAY '****************************************'        
PRJ914        DISPLAY '**   PCSBW152 PROCESSING ERROR        **'        
PRJ914        DISPLAY '**   ABEND IN PARAGRAPH 7125          **'        
PRJ914        DISPLAY '**   PREMISE_NO = ' PR-PREMISE-NO                
PRJ914        DISPLAY '**   SQLCODE    = ' WS-DISPLAY-SQLCODE           
PRJ914        DISPLAY '****************************************'        
PRJ914        PERFORM 9900-ABEND THRU 9900-EXIT                         
PRJ914     END-IF.                                                      
PRJ914*                                                                         
PRJ914 7125-EXIT.                                                       
PRJ914     EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7130-GET-MTR-SERIAL.                                             
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT  EQ.SERIAL_NO                                     
                 INTO :EQ-SERIAL-NO                                     
                 FROM  CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                   
                WHERE  EQ.COMPANY_NO     = :EQ-COMPANY-NO               
                  AND  EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE           
                  AND  EQ.DEVICE_NO      = :EQ-DEVICE-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  EQ.SERIAL_NO                                             
MFA-TR*          INTO :EQ-SERIAL-NO                                             
MFA-TR*          FROM  CSS_EQUIPMENT EQ                                         
MFA-TR*         WHERE  EQ.COMPANY_NO     = :EQ-COMPANY-NO                       
MFA-TR*           AND  EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                   
MFA-TR*           AND  EQ.DEVICE_NO      = :EQ-DEVICE-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW150 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7130          **'        
              DISPLAY '**   COMPANY_NO     = ' EQ-COMPANY-NO            
              DISPLAY '**   CODE-UTIL-TYPE = ' EQ-CODE-UTIL-TYPE        
              DISPLAY '**   METER-NO       = ' EQ-DEVICE-NO             
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7140-GET-SS-DEVICE.                                              
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) MA.DEVICE_NO                                     
                 INTO :MA-DEVICE-NO                                     
                 FROM  CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)              
                WHERE  MA.COMPANY_NO     = :MA-COMPANY-NO               
                  AND  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE           
                  AND  MA.METER_NO       = :MA-METER-NO                 
                  AND  MA.CODE_ATT_TYPE  = 'SS'                         
               ORDER BY MA.DEVICE_NO                                    
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MA.DEVICE_NO                                             
MFA-TR*          INTO :MA-DEVICE-NO                                             
MFA-TR*          FROM  CSS_METER_ATTCHMTS MA                                    
MFA-TR*         WHERE  MA.COMPANY_NO     = :MA-COMPANY-NO                       
MFA-TR*           AND  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                   
MFA-TR*           AND  MA.METER_NO       = :MA-METER-NO                         
MFA-TR*           AND  MA.CODE_ATT_TYPE  = 'SS'                                 
MFA-TR*        ORDER BY MA.DEVICE_NO                                            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7140                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW150 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7140          **'        
              DISPLAY '**   CODE_ATT_TYPE  =  SS             **'        
              DISPLAY '**   COMPANY_NO     = ' MA-COMPANY-NO            
              DISPLAY '**   CODE-UTIL-TYPE = ' MA-CODE-UTIL-TYPE        
              DISPLAY '**   METER-NO       = ' MA-METER-NO              
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7150-GET-MTR-CONSTANT.                                           
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT MC.CONSTANT                                        
                INTO :MC-CONSTANT                                        
                FROM CSS_MTR_CAP      MC WITH(READUNCOMMITTED)                  
               WHERE MC.COMPANY_NO     = :MC-COMPANY-NO                 
                 AND MC.CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE             
                 AND MC.METER_NO       = :MC-METER-NO                   
                 AND MC.REG_ID_NO      = :MC-REG-ID-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ025
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MC.CONSTANT                                                
MFA-TR*         INTO:MC-CONSTANT                                                
MFA-TR*         FROM CSS_MTR_CAP      MC                                        
MFA-TR*        WHERE MC.COMPANY_NO     = :MC-COMPANY-NO                         
MFA-TR*          AND MC.CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                     
MFA-TR*          AND MC.METER_NO       = :MC-METER-NO                           
MFA-TR*          AND MC.REG_ID_NO      = :MC-REG-ID-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW150 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7150          **'        
              DISPLAY '**   COMPANY NO     = ' MC-COMPANY-NO            
              DISPLAY '**   CODE_UTIL_TYPE = ' MC-CODE-UTIL-TYPE        
              DISPLAY '**   METER NO       = ' MC-METER-NO              
              DISPLAY '**   REG_ID_NO      = ' MC-REG-ID-NO             
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7160-GET-IDR-IDENT-NO.                                           
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT L7.IDR_IDENT_NO                                    
               INTO :L7-IDR-IDENT-NO                                    
                FROM CSS_IDR_ACCT_MTR L7 WITH(READUNCOMMITTED)                  
               WHERE L7.ACCOUNT_NO     = :L7-ACCOUNT-NO                 
                 AND L7.METER_NO       = :L7-METER-NO                   
                 AND L7.CODE_UTIL_TYPE = :L7-CODE-UTIL-TYPE             
               ORDER BY L7.LAST_UPDATE_TS DESC                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT L7.IDR_IDENT_NO                                            
MFA-TR*        INTO :L7-IDR-IDENT-NO                                            
MFA-TR*         FROM CSS_IDR_ACCT_MTR L7                                        
MFA-TR*        WHERE L7.ACCOUNT_NO     = :L7-ACCOUNT-NO                         
MFA-TR*          AND L7.METER_NO       = :L7-METER-NO                           
MFA-TR*          AND L7.CODE_UTIL_TYPE = :L7-CODE-UTIL-TYPE                     
MFA-TR*        ORDER BY L7.LAST_UPDATE_TS DESC                                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7160                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                                          OR -811       
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW150 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7160          **'        
              DISPLAY '**   ACCOUNT NO     = ' L7-ACCOUNT-NO            
              DISPLAY '**   METER NO       = ' L7-METER-NO              
              DISPLAY '**   CODE_UTIL_TYPE = ' L7-CODE-UTIL-TYPE        
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7170-GET-ELEC-CLASS-SPEC.                                        
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT EM.ELEC_MTR_CLASS_CD                               
                    ,EM.ELEC_MTR_SPEC_CD                                
               INTO :EM-ELEC-MTR-CLASS-CD                               
                   ,:EM-ELEC-MTR-SPEC-CD                                
                FROM CSS_ELEC_METER EM WITH(READUNCOMMITTED)                    
               WHERE EM.COMPANY_NO     = :EM-COMPANY-NO                 
                 AND EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE             
                 AND EM.METER_NO       = :EM-METER-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EM.ELEC_MTR_CLASS_CD                                       
MFA-TR*             ,EM.ELEC_MTR_SPEC_CD                                        
MFA-TR*        INTO :EM-ELEC-MTR-CLASS-CD                                       
MFA-TR*            ,:EM-ELEC-MTR-SPEC-CD                                        
MFA-TR*         FROM CSS_ELEC_METER EM                                          
MFA-TR*        WHERE EM.COMPANY_NO     = :EM-COMPANY-NO                         
MFA-TR*          AND EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                     
MFA-TR*          AND EM.METER_NO       = :EM-METER-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7170                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW150 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7170          **'        
              DISPLAY '**   COMPANY NO     = ' EM-COMPANY-NO            
              DISPLAY '**   CODE_UTIL_TYPE = ' EM-CODE-UTIL-TYPE        
              DISPLAY '**   METER NO       = ' EM-METER-NO              
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7180-CHECK-RATE-PLAN-DESC.                                       
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
               INTO :RD-SECURED-RATE-FL                                 
                FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE RD.CODE_UTIL_TYPE  = :RD-CODE-UTIL-TYPE            
                 AND RD.RATE_PLAN_NO    = :RD-RATE-PLAN-NO              
                 AND RD.SECURED_RATE_FL = 'Y'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*        INTO :RD-SECURED-RATE-FL                                         
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE RD.CODE_UTIL_TYPE  = :RD-CODE-UTIL-TYPE                    
MFA-TR*          AND RD.RATE_PLAN_NO    = :RD-RATE-PLAN-NO                      
MFA-TR*          AND RD.SECURED_RATE_FL = 'Y'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7180                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW150 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7180          **'        
              DISPLAY '**   CODE_UTIL_TYPE = ' RD-CODE-UTIL-TYPE        
              DISPLAY '**   RATE_PLAN_NO   = ' RD-RATE-PLAN-NO          
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7190-GET-GIS-LOC-AND-TAG.                                        
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT AREA_ID                                            
                    ,TAG_NM                                             
               INTO :PP-AREA-ID                                         
                   ,:PP-TAG-NM                                          
               FROM CSS_PIM_POINT WITH(READUNCOMMITTED)                         
              WHERE POINT_ID = :MN-GIS-POINT-ID                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AREA_ID                                            18620000
MFA-TR*             ,TAG_NM                                             18630000
MFA-TR*        INTO :PP-AREA-ID                                                 
MFA-TR*            ,:PP-TAG-NM                                                  
MFA-TR*        FROM CSS_PIM_POINT                                       19480000
MFA-TR*       WHERE POINT_ID = :MN-GIS-POINT-ID                         19490000
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7190                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW150 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7190          **'        
              DISPLAY '**   ACCOUNT NO     = ' MN-ACCOUNT-NO            
              DISPLAY '**   CODE_UTIL_TYPE = ' MN-CODE-UTIL-TYPE        
              DISPLAY '**   METER-NO       = ' MN-METER-NO              
              DISPLAY '**   POINT_ID       = ' MN-GIS-POINT-ID          
              DISPLAY '**   SQLCODE = ' WS-DISPLAY-SQLCODE              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7190-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  20231000
      * 7600-START-FCSJC01                                           *          
      *==============================================================*  20231000
           EXEC SQL                                                             
              INCLUDE CPDCA038                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*  20231000
      * 7620-START-FCSCA00 VSAM CTRL FILE                            *          
      *==============================================================*  20231000
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *===============================================================*         
       8000-WRITE-FIOBW50.                                              
      *===============================================================*         
      *                                                                         
           WRITE FIOBW50.                                               
      *                                                                         
           IF  FBW50-SUCCESSFUL                                         
               COMPUTE WS-FCSBW50-REC-CNTR = WS-FCSBW50-REC-CNTR + 1    
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**   PCSBW150 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 8000          **'        
              DISPLAY '**   WHILE WRITING FCSBW50 FILE       **'        
              DISPLAY '**   FILE STATUS = ' WS-FBW50-STATUS             
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       9000-TERMINATE.                                                  
      *===============================================================*         
      *                                                                         
           CLOSE FCSBW50-FILE.                                          
      *                                                                         
           IF  FBW50-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSBW150 PROCESSING ERROR           **'     
               DISPLAY '**  CLOSE ERROR  - OUTPUT FILES         **'     
               DISPLAY '**  FILE STATUS = ' WS-FBW50-STATUS             
               DISPLAY '**  UNSUCCESSFUL CLOSE OF FCSBW50-FILE  **'     
           END-IF.                                                      
      *                                                                         
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
           DISPLAY '** RECS WRITTEN TO BW50 = ' WS-FCSBW50-REC-CNTR.    
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      ****************************************************************          
      * 9700-PROCESS-ABEND  (REQUIED BY CPD00040)                    *          
      ****************************************************************          
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND INCLUDES SQL ROLLBACK   ****           
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
