       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW139.                                        
       INSTALLATION.                                                    
       DATE-WRITTEN.   JANUARY 2004.                                    
           DATE-COMPILED.                                               
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRICITY  & GAS               **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE       INITIALS      REASON                          **         
      **    ----       --------      ------                          **         
      **  01/22/2004    RF10596  DEVELOPMENT OF NEW PROGRAM.         **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSBW139 NARRATIVE                        
           READS FCSBW05 HOURLY VOLUME FILE FROM EFM FOR METER READ     
           POSTINGS TO CIS.                                             
           TOTAL THE VOLUME AND NUMBER OF RECORDS.  COMPARE THIS        
           TO THE TOTAL RECORDS (CAN BE MORE THAN 1) AT THE END         
           OF THE FILE.   IF EQUAL, ALL IS FINE.  IF NOT, ABEND         
           THIS STEP DISPLAYING THE TOTALS.                             
      *****************************************************************         
                -------- BASIC SEQUENCE STRUCTURE -----------           
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1000     MAIN FILE PROCESSING CONTROL            
                7000 - 7999     INPUT MODULES                           
                9900 - 9999     TERMINATE/ABEND MODULES                 
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSBW05.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDBW05.                                                            
       01 FIOBW05-REC             PIC X(80).                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         
      *                                                                         
       COPY FIOBW05.                                                            
      *                                                                         
       01  WS-FCSBW05-STATUS            PIC XX.                         
           88  FCSBW05-SUCCESSFUL           VALUE '00'.                 
      *                                                                         
       01  WS-YES                       PIC X VALUE 'Y'.                
      *                                                                         
       01  WS-END-OF-EFM-FILE           PIC X VALUE 'N'.                
           88  WS-EFM-EOF                   VALUE 'Y'.                  
      *                                                                         
       01  WS-FBW05-TOT-REC-COUNT       PIC S9(9) COMP-3 VALUE 0.       
      *                                                                         
       01  WS-FBW05-TOTAL-VOLUME        PIC 9(11)V99.                   
       01  WS-FBW05-TOTAL-VOLUME-X REDEFINES                            
             WS-FBW05-TOTAL-VOLUME      PIC X(13).                      
      *                                                                         
       01  WS-COMPUTE-METER-VOLUME      PIC 9(11)V99 VALUE ZEROS.       
      *                                                                         
       01  WS-COMP-METER-VOLUME.                                        
           05  WS-COMP-METER-VOL-NUM    PIC 9(06).                      
           05  FILLER                   PIC X(01).                      
           05  WS-COMP-METER-VOL-DEC    PIC 9(02).                      
       01  WS-COMP-METER-VOLUME-RED                                     
                     REDEFINES WS-COMP-METER-VOLUME  PIC X(9).          
      *                                                                         
       01  WS-TOTAL-METER-VOLUME.                                       
           05  WS-TOTAL-METER-VOL-NUM   PIC 9(10).                      
           05  FILLER                   PIC X.                          
           05  WS-TOTAL-METER-VOL-DEC   PIC 99.                         
       01  WS-TOTAL-METER-VOLUME-RED                                    
                    REDEFINES WS-TOTAL-METER-VOLUME PIC X(13).          
      *                                                                         
       01  WS-FCSBW05-REC-CNTR          PIC S9(9) COMP-3 VALUE 0.       
      *                                                                         
COB305 01 WS-FBW05-ACCUM-MTR-VOL        PIC S9(11)V99 COMP-3 VALUE 0.           
       01  WS-FBW05-ACCUM-MTR-VOL-X REDEFINES                           
             WS-FBW05-ACCUM-MTR-VOL     PIC X(13).                      
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                  *          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 7400-READ-EFM-FILE THRU 7400-EXIT.                   
      *                                                                         
           IF WS-EFM-EOF                                                
              DISPLAY '*********************************************'   
              DISPLAY '**      PCSBW139 PROCESSING ERROR          **'   
              DISPLAY '**        FCSBW05  FILE IS EMPTY           **'   
              DISPLAY '**        PROCESSING TERMINATED            **'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           PERFORM 1000-PROCESS-EFM THRU 1000-EXIT UNTIL WS-EFM-EOF.    
      *                                                                         
           IF WS-FCSBW05-REC-CNTR = WS-FBW05-TOT-REC-COUNT AND          
                WS-FBW05-ACCUM-MTR-VOL = WS-FBW05-TOTAL-VOLUME          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '  '                                              
              DISPLAY '****************************************'        
              DISPLAY '* PROCESSING ERROR IN PROGRAM PCSBW139 *'        
              DISPLAY '*  ACCUMULATION OF NUMBER OF RECORDS   *'        
              DISPLAY '*  AND METER VOLUME FROM INPUT RECORDS *'        
              DISPLAY '*  DOES NOT EQUAL THE ACCUMULATED      *'        
              DISPLAY '*  TOTAL OF THE SAME FIELDS CARRIED    *'        
              DISPLAY '*  ON THE TOTAL RECORDS.  THERE CAN    *'        
              DISPLAY '*  BE MULTIPLE TOTAL RECORDS.          *'        
              DISPLAY '*                                      *'        
              DISPLAY '* PGM ACCUM COUNT = ' WS-FCSBW05-REC-CNTR        
              DISPLAY '* PGM ACCUM VOLUME = ' WS-FBW05-ACCUM-MTR-VOL    
              DISPLAY '* TOTAL REC COUNT = ' WS-FBW05-TOT-REC-COUNT     
              DISPLAY '* TOTAL REC VOLUME = ' WS-FBW05-TOTAL-VOLUME     
              DISPLAY '****************************************'        
              DISPLAY '  '                                              
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *        INITIALIZATION ROUTINE                                *          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE ZEROS TO WS-FBW05-TOTAL-VOLUME.                         
           MOVE ZEROS TO WS-FBW05-ACCUM-MTR-VOL.                        
      *                                                                         
           OPEN INPUT FCSBW05-FILE.                                     
      *                                                                         
           IF FCSBW05-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSBW139   **'    
              DISPLAY '**        PARA - 0100-INITIALIZARION      **'    
              DISPLAY '**       ERROR DURING OPEN OF FILE        **'    
              DISPLAY '**               FCSBW05                  **'    
              DISPLAY '** WS-FCSBW05-STATUS = ' WS-FCSBW05-STATUS       
              DISPLAY '**          PROCESSING TERMINATED         **'    
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *       CONTROLS PROCESSING UNTIL END OF FILE                  *          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-EFM.                                                
      *                                                                         
           IF E-FBW05-METER-NO = 999999999 AND                          
                          E-FBW05-ACCOUNT-NO = 9999999999999            
              ADD E-FBW05-TOT-REC-COUNT TO WS-FBW05-TOT-REC-COUNT       
              MOVE E-FBW05-TOT-MCF-VOLUME                               
                                TO WS-TOTAL-METER-VOLUME-RED            
              IF WS-TOTAL-METER-VOL-NUM IS NUMERIC                      
                       AND WS-TOTAL-METER-VOL-DEC IS NUMERIC            
                COMPUTE WS-COMPUTE-METER-VOLUME =                       
                 (WS-TOTAL-METER-VOL-NUM +                              
                             WS-TOTAL-METER-VOL-DEC / 100)              
                ADD WS-COMPUTE-METER-VOLUME TO WS-FBW05-TOTAL-VOLUME    
              ELSE                                                      
                 DISPLAY '                                  '           
                 DISPLAY 'ERROR ON VOLUME TOTAL ACCUMULATION'           
                 DISPLAY '  PARAGRAPH 7400-READ-EFM-FILE   '            
                 DISPLAY 'ACCOUNT NUMBER = ' E-FBW05-ACCOUNT-NO         
                 DISPLAY 'WS-COMP-METER-VOL-NUM NOT NUMERIC'            
                 DISPLAY '            OR                   '            
                 DISPLAY 'WS-COMP-METER-VOL-DEC NOT NUMERIC'            
                 DISPLAY '                                  '           
              END-IF                                                    
           ELSE                                                         
              ADD 1 TO WS-FCSBW05-REC-CNTR                              
              MOVE E-FBW05-METER-VOLUME TO WS-COMP-METER-VOLUME-RED     
              IF WS-COMP-METER-VOL-NUM IS NUMERIC                       
                       AND WS-COMP-METER-VOL-DEC IS NUMERIC             
                COMPUTE WS-COMPUTE-METER-VOLUME =                       
                 (WS-COMP-METER-VOL-NUM +                               
                             WS-COMP-METER-VOL-DEC / 100)               
                 ADD WS-COMPUTE-METER-VOLUME                            
                                TO WS-FBW05-ACCUM-MTR-VOL               
              ELSE                                                      
                 DISPLAY '                                  '           
                 DISPLAY 'ERROR ON VOLUME TOTAL ACCUMULATION'           
                 DISPLAY '  PARAGRAPH 7400-READ-EFM-FILE   '            
                 DISPLAY 'ACCOUNT NUMBER = ' E-FBW05-ACCOUNT-NO         
                 DISPLAY 'WS-COMP-METER-VOL-NUM NOT NUMERIC'            
                 DISPLAY '            OR                   '            
                 DISPLAY 'WS-COMP-METER-VOL-DEC NOT NUMERIC'            
                 DISPLAY '                                  '           
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7400-READ-EFM-FILE THRU 7400-EXIT.                   
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *       READ THE INPUT FILE                                    *          
      ****************************************************************          
      *                                                                         
       7400-READ-EFM-FILE.                                              
      *                                                                         
           READ FCSBW05-FILE                                            
             INTO FIOBW05                                               
               AT END MOVE WS-YES TO WS-END-OF-EFM-FILE.                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   NORMAL JOB TERMINATION                                                
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBW05-FILE.                                          
      *                                                                         
           IF FCSBW05-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSBW139   **'    
              DISPLAY '**     PARAGRAPH  - 9000-TERMINATE        **'    
              DISPLAY '**       ERROR DURING CLOSE OF FILE       **'    
              DISPLAY '**               FCSBW05                  **'    
              DISPLAY '** WS-FCSBW05-STATUS = ' WS-FCSBW05-STATUS       
              DISPLAY '**          PROCESSING TERMINATED         **'    
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   ABNORMAL TERMINATION                                       *          
      ****************************************************************          
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
      *                                                                         
       9900-EXIT.                                                       
