       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW138.                                        
       AUTHOR.         COVANSYS                                         
       INSTALLATION.                                                    
       DATE-WRITTEN.   SEPTEMBER 2002.                                  
           DATE-COMPILED.                                               
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRICITY  & GAS               **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE       INITIALS      REASON                          **         
      **    ----       --------      ------                          **         
T27236**  09/05/2002    VD88125  DEVELOPMENT OF NEW PROGRAM.         **         
EFMENH**  11/01/2002    VD88125  ADDED LOGIC TO POPULATE THE DATA FOR**         
EFMENH**                         CSS_MTR_IDENT_HIST TABLE.           **         
      **  04/02/2003    VD88125  CHANGES MADE TO HANDLE DUPLICATE TIME*         
      **                         INERVAL READINS AND GENERATE WQ.    **         
C28742**  04/10/2003    GSR      CHANGES MADE TO UPDATE FEW FIELDS ON**         
      **                         MN & CX AND TO HANDLE VOLUME UPDATES**         
T29165**  06/11/2003    VD88125  CODE CHANGES TO CREATE WQ IF THE EFM**         
      **                         RE-SENDS THE VOLUMES FOR THE BILLED **         
      **                         BILL HOOK FOR THOSE MONTHS.         **         
T27149**  06/12/2003    JS83520  ROUTE WQS TO CATEGORY ID 276 FOR    **         
T27149**                         METER READ EXCEPTIONS               **         
C30010**  01/23/2004    GANESH   CHANGES TO SUPPORT THE GAS DAY START**         
C30010**                         TIME 10.00 AM.                      **         
      **                                                             **         
30909 **   5/19/2004    RDF      IT IS OK FOR INPUT FILE TO BE EMPTY **         
      **                         IF PCSBW139 COMPLETED WITH 0 CC AND **         
      **                         IF THE INPUT TO PCSBW139 WAS 1      **         
      **                         RECORD, ALL 9'S AND ZEROS, AND THE  **         
      **                         ZERO VESION (PRIOR TO THE RUNNING   **         
      **                         OF PCSBW138) OF FCSBW05A IN STEP    **         
      **                         CSRB138S IS EMPTY.   THIS SORT STEP **         
      **                         DELETES THE 9'S RECORDS.            **         
      **                                                             **         
31870 **  11/19/2004    RDF      FOR ALL NONE TRAILER RECORDS, IF    **         
      **                         THE FIRST THREE POSITIONS OF THE    **         
      **                         METER NUMBER  = '999' CHANGE THEM   **         
      **                         TO '000'.                           **         
C32481**  03/21/05   GANESH      CHANGES MADE TO USE THE INDUSTRIAL  **         
C32481**                         BTU ID OF ORIGINAL BILL FOR ALL     **         
C32481**                         CANCEL \REBILL CONDITIONS.          **         
C35804**  06/01/07   GD97441     WQ LOGIC OF "METER READINGS SKIPPED"**         
C35804**                         SCENARIO IS BEEN UPDATED. REPLACED  **         
C35804**                         MODEL SQL STATEMENTS WITH SET.ADDED **         
C35804**                         WITH UR FOR PERFORMANCE IMPROVEMENT.**         
      **                                                             **         
36423 **  10/25/07   RF10596     REMOVE CWS00166 AND CPD00166.       **         
      **                         REPLACE THEM WITH IN-PROGRAM CODE.  **         
C37131**   04/01/08   PA94870    NON CURRENT MONTH VOLUMES POSTED TO **         
C37131**                         FUTURE BILL HOOK.                   **         
      **                         FUTURE BILL HOOK.                   **         
      **                                                             **         
C37423**   1 JUL 08   RF10596    CORRECT AN ERROR FOR WHEN THERE ARE **         
      **                         DUPLICATE RECORDS ON THE FILE       **         
      **                                                             **         
C37554**  11 AUG 08   RF10596    CORRECT ERROR WITH CANCEL REBILL    **         
      **                                                             **         
A00633**  18 MAR 09   RF10596    CHANGE WQ DETERMINATION             **         
      **                                                             **         
A02906**  02 DEC 10   SV95326    REMOVE CODE_ACCT_USAGE REFERENCES   **         
ACT063**  26 JUN 12   BD09555    REMOVE CPD00314 AND EXECUTION OF    **         
ACT063**  A03967      BD09555    PARAGRAPHS INSIDE IT.               **         
A04700**  06/03/2013  VIJAY      CHANGES TO BALNCE EFM VOLUMES TO CIS**         
A04700**                         (ROUNDING IS DONE AFTER MULTIPLYING **         
A04700**                          BY 10 FOR CX-NO-UNITS AS DATA FROM **         
A04700**                          EFM USES ONLY 1 DECIMAL PLACE)     **         
A04860**  12/17/2014  MR7E794    LOAD DIRECTLY CSS_WQ_ITEMS INSTEAD  **         
A04860**              ACT056     OF CSS_WQ_ITEMS_MF BY CALLING SUB   **         
A04860**                         PROGRAM SCSCB077                    **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSBW138 NARRATIVE                        
           READS FCSBW05 HOURLY VOLUME FILE FROM EFM FOR METER READ     
           POSTINGS TO CIS.                                             
           PCSBW138 UPDATES/INSERTS  METER READ ENVIRONMENT, BILLING    
           DETAIL ,BILLING HEADER, HOURLY INTERVAL READ TABLE AND       
           CONSUMPTION HISTORY WITH THE METER VOLUMES TO BE POSTED.     
           IF THE BILLING HEADER AND BILLING DETAIL RECORDS ARE NOT     
           IN PLACE FOR THIS METER TO CONTINUE TO BE BILLED THEY ARE    
           UPDATED OR INSERTED BEFORE BILLING. ALL METER EXCEPTIONS     
           ARE REPORTED VIA WORK QUEUES TO A SPECIFIC CATAGORY ID       
           INCLUDING METER READ ERRORS AND INVALID READS.               
      *****************************************************************         
                -------- BASIC SEQUENCE STRUCTURE -----------           
                0000 - 0999     MAIN CONTROL PATH RESTART AND           
                                INITIALIZATION                          
                1000 - 1000     MAIN FILE PROCESSING CONTROL            
                1100 - 1100     EDIT AND VALIDATION OF INPUT EFM DATA   
                1200 - 1500     ACCOUNT/METER/DATE REC CHANGE PROCESS   
                2000 - 2100     INSERT PRIMARY CX/SUBTRACTIVE MTR CX    
                5000 - 5000     GET FUTURE BILL HOOK LOGIC              
                5030 - 5030     INSERT UNBILLED HOOK IF NECESSARY       
                5050 - 5050     VERIFY BILL DETAIL EXISTANCE            
                5300 - 5310     WORK QUEUE PROCESSING                   
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9900 - 9999     TERMINATE/ABEND MODULES                 
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSBW05.                                                            
       COPY CSSBW05A.                                                           
       COPY CSSBW05R.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDBW05.                                                            
       01 FIOBW05-REC             PIC X(80).                            
      *                                                                         
       COPY CFDBW05A.                                                           
       01 FIOBW05A-REC             PIC X(80).                           
      *                                                                         
       COPY CFDBW05R.                                                           
       01 FIOBW05R-REC             PIC X(80).                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW138'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSBW138 STARTS HERE'.            
       COPY FIOBW05.                                                            
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00004.                                                           
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       COPY CWS00314.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-FCSBW05-STATUS       PIC X(02).                       
               88  FCSBW05-SUCCESSFUL             VALUE '00'.           
           05  WS-FCSBW05A-STATUS      PIC X(02).                       
               88  FCSBW05A-SUCCESSFUL            VALUE '00'.           
           05  WS-FBW05R-STATUS        PIC X(02).                       
               88  FBW05R-SUCCESSFUL              VALUE '00'.           
               88  FBW05R-END-OF-FILE             VALUE '10'.           
           05  WS-END-OF-EFM-FILE     PIC X       VALUE 'N'.            
               88  WS-EFM-EOF                     VALUE 'Y'.            
           05  WS-PARM-VALID-IND       PIC X      VALUE 'N'.            
               88  PARM-IS-VALID                  VALUE 'Y'.            
               88  PARM-IS-INVALID                VALUE 'N'.            
           05  WS-WARNING-IND          PIC X      VALUE 'N'.            
               88  WS-METER-WARNING               VALUE 'Y'.            
           05  WS-ERROR-IND            PIC X      VALUE 'N'.            
               88  MULTI-ROWS-ERROR               VALUE 'Y'.            
           05  WS-EMPTY-FILE-IND       PIC X      VALUE 'N'.            
               88  EMPTY-FILE                     VALUE 'Y'.            
           05  WS-MTR-ALREADY-READ-IND PIC X      VALUE 'N'.            
               88  MTR-ALREADY-READ               VALUE 'Y'.            
           05  WS-READ-CODE-CHECK      PIC X      VALUE 'N'.            
           05  WS-FIRST-RECORD         PIC X      VALUE 'Y'.            
               88  FIRST-RECORD                   VALUE 'Y'.            
           05  WS-BILL-CNTRCT-FL       PIC X      VALUE 'N'.            
               88  VALID-CNTRCT                   VALUE 'Y'.            
           05  WS-CNTRCT-ERRMSG-FL     PIC X      VALUE 'N'.            
               88  CNTRCT-ERRMSG                  VALUE 'Y'.            
           05  WS-BK-CRSR-FL           PIC X      VALUE 'N'.            
               88  END-OF-BK-CRSR                 VALUE 'Y'.            
           05  WS-WQ-FLAG              PIC X      VALUE 'N'.            
C37131     05  WS-VALID-CONS-FLAG      PIC X      VALUE 'Y'.            
C37131         88  VALID-CONS                     VALUE 'Y'.            
C37131         88  INVALID-CONS                   VALUE 'N'.            
           05  WS-REV-MTH-FLAG         PIC X      VALUE 'N'.            
           05  WS-RUN-DATE             PIC X(10).                       
           05  WS-FCSBW05-REC-CNTR     PIC S9(09) COMP VALUE ZERO.      
           05  WS-FCSBW05A-REC-CNTR    PIC S9(09) COMP VALUE ZERO.      
           05  WS-CNTRL-REC-FLAG       PIC X(01)  VALUE 'N'.            
           05  WS-UPDT-REC-FLAG        PIC X(01)  VALUE 'N'.            
           05  WS-COMPANY-NO           PIC X(02)  VALUE '01'.           
           05  WS-COMP-NO              PIC X(02)  VALUE '01'.           
           05  WS-LOCAL-OFFICE         PIC X(02)  VALUE SPACES.         
           05  WS-REVENUE-MONTH        PIC 9(06)  VALUE ZERO.           
           05  WS-REVENUE-MONTH-A.                                      
               10 WS-REV-YEAR          PIC 9(04).                       
               10 WS-REV-MTH           PIC 9(02).                       
           05  WS-REVENUE-MONTH-N       REDEFINES                       
                 WS-REVENUE-MONTH-A    PIC 9(06).                       
           05  WS-TIMESTMP-FROM-DB2-CALL      PIC X(26) VALUE SPACES.   
           05  WS-ACCOUNT-NO           PIC 9(13)  VALUE ZEROES.         
           05  WS-CODE-ACCT-STAT       PIC X      VALUE SPACES.         
           05  WS-DONT-UPDATE-ACCT     PIC 9(3)   VALUE ZEROES.         
           05  WS-SECURED-RATE-FL      PIC X(1)   VALUE SPACES.         
           05  WS-LITERALS.                                             
               10  WS-G                PIC X(01) VALUE 'G'.             
               10  WS-CREDIT           PIC X(01) VALUE 'C'.             
               10  WS-DEBIT            PIC X(01) VALUE 'D'.             
               10  WS-SPACE            PIC X(01) VALUE SPACES.          
               10  WS-1                PIC 9(01) VALUE 1.               
               10  WS-811              PIC S9(9)  VALUE -811 COMP.      
           05  WS-COUNTERS.                                             
               10  WS-COUNT-ACCT       PIC 9(07) VALUE 0.               
               10  WS-COUNT-METER      PIC 9(07) VALUE 0.               
               10  WS-COUNT-GAS        PIC 9(07) VALUE 0.               
               10  WS-COUNT-NOT-READ   PIC 9(07) VALUE 0.               
               10  WS-GAS-WORKQ        PIC 9(07) VALUE 0.               
               10  WS-COUNT-FBW05A     PIC 9(07) VALUE 0.               
                                                                        
               10  WS-DISP-FBW05A      PIC ZZZ,ZZ9.                     
               10  WS-DISP-METER       PIC ZZZ,ZZ9.                     
               10  WS-DISP-GAS         PIC ZZZ,ZZ9.                     
               10  WS-DISP-NOT-READ    PIC ZZZ,ZZ9.                     
               10  WS-DISP-GAS-WQ      PIC ZZZ,ZZ9.                     
               10  WS-DISP-REJECT      PIC ZZZ,ZZ9.                     
               10  WS-DISP-MN-UCNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-BI-ICNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-BG-ICNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-BG-UCNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-CX-ICNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-CX-UCNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-IV-ICNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-IV-UCNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-GA-ICNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-GA-UCNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-AT-UCNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-RF-ICNTR    PIC ZZZ,ZZ9.                     
               10  WS-DISP-RF-UCNTR    PIC ZZZ,ZZ9.                     
                                                                        
           05  WS-REGISTER-BREAKDOWN.                                   
               10  WS-USAGE-TYPE       PIC X VALUE 'C'.                 
               10  WS-USAGE-ID         PIC X VALUE 'A'.                 
               10  WS-USAGE-SOURCE     PIC X VALUE 'B'.                 
           05  WS-UTL-IC-NO-BREAKDOWN.                                  
               10  WS-UTIL-TYPE        PIC X(01)  VALUE 'G'.            
               10  WS-IC-NO            PIC 9(03)  VALUE 0.              
               10  WS-MTR-REF-NO       PIC 9(04)  VALUE 0.              
           05  WS-TIME-CHAR6.                                           
               10  WS-TIME-CHAR6-HH    PIC X(02)  VALUE SPACES.         
               10  WS-TIME-CHAR6-MM    PIC X(02)  VALUE SPACES.         
               10  WS-TIME-CHAR6-SS    PIC X(02)  VALUE SPACES.         
           05  WS-INPUT-TIME.                                           
               10  WS-INPUT-TIME-HH    PIC X(02)  VALUE SPACES.         
               10  FILLER              PIC X(01)  VALUE '.'.            
               10  WS-INPUT-TIME-MM    PIC X(02)  VALUE SPACES.         
               10  FILLER              PIC X(01)  VALUE '.'.            
               10  WS-INPUT-TIME-SS    PIC X(02)  VALUE SPACES.         
           05  WS-DATE-READ            PIC X(10)  VALUE SPACES.         
           05  WS-CD-TIME.                                              
               10  WS-CD-HR            PIC 9(02)  VALUE ZEROES.         
               10  WS-CD-MIN           PIC 9(02)  VALUE ZEROES.         
               10  WS-CD-SEC           PIC 9(02)  VALUE ZEROES.         
               10  WS-CD-HUN           PIC 9(02)  VALUE ZEROES.         
           05  WS-DATE-NUM.                                             
               10  WS-DATE-NUM-CCYY    PIC 9(04)  VALUE ZERO.           
               10  FILLER              PIC X(01)  VALUE '-'.            
               10  WS-DATE-NUM-MM      PIC 9(02)  VALUE ZERO.           
               10  FILLER              PIC X(01)  VALUE '-'.            
               10  WS-DATE-NUM-DD      PIC 9(02)  VALUE ZERO.           
           05  WS-WORK-DATE.                                            
               10  WS-WORK-CC          PIC 9(02).                       
               10  WS-WORK-YY          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-WORK-MM          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-WORK-DD          PIC 9(02).                       
      *                                                                         
           05  WS-SUM-BTU-FACTOR       PIC S9(5)V9(5) COMP-3 VALUE ZERO.
           05  WS-SUM-SP-GRAVITY       PIC S9(3)V9(3) COMP-3 VALUE ZERO.
           05  WS-AVG-BTU-FACTOR       PIC S9(5)V9(5) COMP-3 VALUE ZERO.
           05  WS-AVG-SP-GRAVITY       PIC S9(3)V9(3) COMP-3 VALUE ZERO.
           05  WS-SUM-CNT              PIC S9(04) COMP VALUE ZERO.      
           05  WS-DATE-READ-MM         PIC X(02).                       
           05  WS-DATE-READ-MM-RED  REDEFINES WS-DATE-READ-MM           
                                       PIC 9(02).                       
           05  WS-BTU-DT-MM            PIC S9(04) COMP.                 
           05  WS-BTU-DT-YY            PIC S9(04) COMP.                 
           05  WS-DATE-READ-YY         PIC X(04).                       
           05  WS-DATE-READ-YY-RED  REDEFINES WS-DATE-READ-YY           
                                       PIC 9(04).                       
           05  WS-DAILY-VOLUME         PIC S9(6)V9(02) COMP-3 VALUE 0.  
           05  WS-DAILY-VOL            PIC S9(6)V9(01) COMP-3 VALUE 0.  
           05  WS-DAILY-TEMP           PIC S9(6)V9(02) COMP-3 VALUE 0.  
           05  WS-DAILY-PRES           PIC S9(6)V9(02) COMP-3 VALUE 0.  
COB305     05 WS-NEW-FPV-FACTOR        PIC S9V9(04) COMP-3 VALUE 0.             
COB305     05 WS-OLD-FPV-FACTOR        PIC S9V9(04) COMP-3 VALUE 0.             
COB305     05 WS-PRES-ROUND        PIC S9(04)V9 COMP-3 VALUE 0.             
COB305     05 WS-TEMP-ROUND        PIC S9(04)V9 COMP-3 VALUE 0.             
COB305     05 WS-AVG-PRES        PIC S9(04) COMP-3 VALUE 0.             
COB305     05 WS-AVG-TEMP        PIC S9(03) COMP-3 VALUE 0.             
           05  WS-CONSTANT             PIC S9V9(03) VALUE 0.575.        
COB305     05 WS-ADJS-FACTOR        PIC S9V9(05) COMP-3 VALUE 0.             
           05  WS-CODE-METER-READ      PIC X(01).                       
           05  WS-ROW-EXISTS           PIC X(01).                       
           05  WS-NO-OF-REJECT         PIC 9(07) VALUE ZERO.            
C30010     05  WS-EFF-TIME.                                             
C30010         10  WS-EFF-TIME-HH      PIC 9(02) VALUE 08.              
C30010         10  FILLER              PIC X(01) VALUE ':'.             
C30010         10  WS-EFF-TIME-MM      PIC 9(02) VALUE 00.              
C30010         10  FILLER              PIC X(01) VALUE ':'.             
C30010         10  WS-EFF-TIME-SS      PIC 9(02) VALUE 00.              
C30010         10  FILLER              PIC X(02) VALUE 'AM'.            
C30010     05  WS-PARM-EFF-TIME REDEFINES WS-EFF-TIME PIC X(10).        
           05  WS-END-TIME.                                             
               10  WS-END-TIME-HH      PIC 9(02) VALUE 08.              
               10  FILLER              PIC X(01) VALUE ':'.             
               10  WS-END-TIME-MM      PIC 9(02) VALUE 00.              
               10  FILLER              PIC X(01) VALUE ':'.             
               10  WS-END-TIME-SS      PIC 9(02) VALUE 00.              
               10  FILLER              PIC X(02) VALUE 'AM'.            
           05  WS-PARM-END-TIME REDEFINES WS-END-TIME PIC X(10).        
           05  WS-START-TIME.                                           
               10  WS-START-TIME-HH    PIC 9(02) VALUE 09.              
               10  FILLER              PIC X(01) VALUE ':'.             
               10  WS-START-TIME-MM    PIC 9(02) VALUE 00.              
               10  FILLER              PIC X(01) VALUE ':'.             
               10  WS-START-TIME-SS    PIC 9(02) VALUE 00.              
               10  FILLER              PIC X(02) VALUE 'AM'.            
           05  WS-PARM-START-TIME REDEFINES WS-START-TIME PIC X(10).    
           05  WS-TIME-READ.                                            
               10  WS-TIME-READ-HH     PIC 9(02)  VALUE 00.             
               10  FILLER              PIC X(01)  VALUE ':'.            
               10  WS-TIME-READ-MM     PIC 9(02)  VALUE 00.             
               10  FILLER              PIC X(01)  VALUE ':'.            
               10  WS-TIME-READ-SS     PIC 9(02)  VALUE 00.             
           05  WS-TIME-READ-RED REDEFINES WS-TIME-READ PIC X(08).       
      *                                                                         
C30010     05  WS-CUR-TIME-HH         PIC 9(02) VALUE 08.               
                                                                        
      *                                                                         
           05  WS-INPUT-GAS-DATA.                                       
               10  WA-GAS-DATA         PIC X(12).                       
               10  FILLER              PIC X(01).                       
               10  WS-GAS-START-PARM   PIC X(10).                       
               10  FILLER              PIC X(03).                       
               10  WS-GAS-END-PARM     PIC X(10).                       
               10  FILLER              PIC X(44).                       
                                                                        
C30010     05  WS-INPUT-GAS-DAY.                                        
C30010         10  WA-GAS-DAY          PIC X(12).                       
C30010         10  FILLER              PIC X(01).                       
C30010         10  WS-GAS-EFF-DATE     PIC X(10).                       
C30010         10  FILLER              PIC X(03).                       
C30010         10  WS-GAS-EFF-TIME     PIC X(10).                       
C30010         10  FILLER              PIC X(44).                       
C30010     05  WS-DAY-BEFORE-EFF       PIC X(10).                       
      *                                                                         
           05  WS-INPUT-VALUES.                                         
               10  WS-MTR-DATE-READ    PIC X(10)  VALUE SPACES.         
               10  FILLER              PIC X(01)  VALUE SPACES.         
               10  WS-MTR-TIME-READ    PIC X(08)  VALUE SPACES.         
               10  WS-MTR-NO           PIC X(09).                       
               10  WS-MTR-VOL          PIC 9(06)V99.                    
               10  WS-MTR-PRE          PIC 9(03)V99.                    
               10  WS-MTR-TMP          PIC 9(03)V99.                    
               10  WS-MTR-VOL-TYPE     PIC X(01).                       
               10  WS-ACCT-NO          PIC X(13).                       
               10  WS-ACCT-NO-RED REDEFINES WS-ACCT-NO                  
                                       PIC 9(13).                       
           05  WS-METER-VOLUME.                                         
               10  WS-METER-VOL-NUM    PIC 9(06).                       
               10  FILLER              PIC X(01).                       
               10  WS-METER-VOL-DEC    PIC 9(02).                       
           05  WS-METER-VOLUME-RED  REDEFINES WS-METER-VOLUME           
                                       PIC X(09).                       
           05  WS-METER-PRESSURE.                                       
               10  WS-METER-PRE-NUM    PIC 9(03).                       
               10  FILLER              PIC X(01).                       
               10  WS-METER-PRE-DEC    PIC 9(02).                       
           05  WS-METER-PRESSURE-RED REDEFINES WS-METER-PRESSURE        
                                       PIC X(06).                       
           05  WS-METER-TEMP.                                           
               10  WS-METER-TMP-NUM    PIC 9(03).                       
               10  FILLER              PIC X(01).                       
               10  WS-METER-TMP-DEC    PIC 9(02).                       
           05  WS-METER-TEMP-RED REDEFINES WS-METER-TEMP                
                                       PIC X(06).                       
           05  WS-METER-VOL-TYPE       PIC X(01).                       
           05  WS-CURR-DATE-READ       PIC X(10).                       
C28742     05  WS-MN-READ-DATE         PIC X(10).                       
C28742     05  WS-MN-READ-TIME         PIC X(08).                       
C28742     05  WS-MN-READ-CODE         PIC X(01).                       
           05  WS-CURR-TIME-READ       PIC X(08).                       
           05  WS-PREV-ACCT-NO         PIC 9(13).                       
           05  WS-PREV-METER-NO        PIC X(09).                       
           05  WS-PREV-DATE-TIME.                                       
               10  WS-PREV-DATE-READ   PIC X(10).                       
               10  WS-FILLER           PIC X(01).                       
               10  WS-PREV-TIME-READ   PIC X(08).                       
           05  WS-EXCHG-DATE-READ      PIC X(10).                       
      *                                                                         
A02906     05  WS-DEP-REL-START-DT.                                     
A02906         10 WS-DEP-REL-START-CCYY PIC X(04) VALUE SPACES.         
A02906         10 FILLER                PIC X(01) VALUE '-'.            
A02906         10 WS-DEP-REL-START-MM   PIC X(02) VALUE SPACES.         
A02906         10 FILLER                PIC X(01) VALUE '-'.            
A02906         10 WS-DEP-REL-START-DD   PIC X(02) VALUE '01'.           
A02906     05  WS-DEP-REL-END-DT.                                       
A02906         10 WS-DEP-REL-END-CCYY   PIC X(04) VALUE SPACES.         
A02906         10 FILLER                PIC X(01) VALUE '-'.            
A02906         10 WS-DEP-REL-END-MM     PIC X(02) VALUE SPACES.         
A02906         10 FILLER                PIC X(01) VALUE '-'.            
A02906         10 WS-DEP-REL-END-DD     PIC X(02) VALUE '28'.           
A02906     05  WS-REV-MTH-ORIG-BILL     PIC S9(6)V USAGE COMP-3 VALUE 0.
A02906     05  WS-REV-MTH-ORIG-BILL-N   PIC 9(06)  VALUE ZERO.          
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-1                   PIC S9(4) COMP.              
           05  WS-CX-ITEM-SEQ-NO-NULL      PIC S9(04) COMP VALUE ZEROES.
C28742     05  WS-MN-DATE-NULL             PIC S9(04) COMP VALUE ZEROES.
C28742     05  WS-MN-TIME-NULL             PIC S9(04) COMP VALUE ZEROES.
           05  WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(04) COMP-3 VALUE ZERO.
           05  WS-SUM-BTU-FACT-NULL        PIC S9(04) COMP VALUE ZEROES.
           05  WS-SUM-SP-GRAV-NULL         PIC S9(04) COMP VALUE ZEROES.
           05  WS-SUM-CNT-NULL             PIC S9(04) COMP VALUE ZEROES.
           05  IND-DATE-BILLED             PIC S9(04) COMP-4 VALUE 1.   
           05  IND-DATE-ORIG-BILL          PIC S9(04) COMP-4 VALUE 1.   
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08)  VALUE 'PCSBW138'. 
           05  PROGRAM-NAME                PIC X(08)  VALUE 'PCSBW138'. 
           05  WS-PCSBW138                 PIC X(08)  VALUE 'PCSBW138'. 
           05  WS-NEG-ONE                  PIC S9(04)  COMP-3 VALUE -1. 
           05  WS-ONE                      PIC X(02)   VALUE '01'.      
           05  WS-NO                       PIC X(01)   VALUE 'N'.       
           05  WS-N                        PIC X(01)   VALUE 'N'.       
           05  WS-J                        PIC X(01)   VALUE 'J'.       
           05  WS-YES                      PIC X(01)   VALUE 'Y'.       
           05  WS-Y                        PIC X(01)   VALUE 'Y'.       
           05  WS-I                        PIC X(01)   VALUE 'I'.       
           05  WS-CURRENT                  PIC X(01)   VALUE 'C'.       
           05  WS-COMMON                   PIC X(06)   VALUE 'COMMON'.  
           05  WS-READ-CODES.                                           
               10  WS-EXCH-READ            PIC X(01)   VALUE 'B'.       
               10  WS-AWAITING-READ        PIC X(01)   VALUE 'D'.       
               10  WS-SYS-CANNOT-EST       PIC X(01)   VALUE 'F'.       
               10  WS-NORMAL-READ          PIC X(01)   VALUE 'J'.       
               10  WS-READER-EST           PIC X(01)   VALUE 'L'.       
               10  WS-CUST-CALLED-RD       PIC X(01)   VALUE 'T'.       
               10  WS-INSTALL-READ         PIC X(01)   VALUE 'A'.       
               10  WS-MANUAL-READ          PIC X(01)   VALUE 'C'.       
               10  WS-SYSTEM-EST           PIC X(01)   VALUE 'E'.       
               10  WS-SRVC-ORDER-OFF       PIC X(01)   VALUE 'G'.       
               10  WS-VERIFIED-READ        PIC X(01)   VALUE 'K'.       
               10  WS-CUSTOMER-READ        PIC X(01)   VALUE 'S'.       
               10  WS-CORRECTED-READ       PIC X(01)   VALUE 'X'.       
           05  WS-METER-STATUS-CODES.                                   
               10  WS-ACTIVE               PIC X(01)   VALUE 'A'.       
               10  WS-INACTIVE             PIC X(01)   VALUE 'J'.       
               10  WS-MONITOR-ONLY         PIC X(01)   VALUE 'I'.       
               10  WS-REMOVED              PIC X(01)   VALUE 'K'.       
           05  WS-GAS                      PIC X(01)   VALUE 'G'.       
           05  WS-CX-NO-UNITS              PIC S9(9)V USAGE COMP-3      
                                           VALUE 0.                     
           05  WS-NO-UNITS                 PIC S9(12)  VALUE ZERO.      
           05  WS-WQ-NO-UNITS              PIC X(07).                   
           05  WS-WQ-NO-UNITS-R  REDEFINES WS-WQ-NO-UNITS               
                                           PIC ---,--9.                 
           05  WS-WQ-MN-UNITS              PIC X(07).                   
           05  WS-WQ-MN-UNITS-R  REDEFINES WS-WQ-MN-UNITS               
                                           PIC ---,--9.                 
           05  WS-WQ-USAGE-PCT             PIC X(6).                    
           05  WS-WQ-USAGE-PCT-R REDEFINES WS-WQ-USAGE-PCT              
                                           PIC --9.99.                  
           05  WS-COMMENTS-TEMP            PIC X(223).                  
           05  WS-MTRCHG-CMT               PIC X(27)  VALUE             
                 'METER CHANGE HAS OCCURRED.'.                          
           05  WS-WQ-ERROR-TEXT.                                        
               10 FILLER                   PIC X(40) VALUE              
                 'ERROR:METER WAS NOT PROCESSED. METER NO:'.            
               10 WS-WQ-ERROR-METER-NO     PIC 9(9)  VALUE 0.           
               10 WS-WQ-ERROR-METER-NO-R   REDEFINES                    
                  WS-WQ-ERROR-METER-NO     PIC X(9).                    
               10 FILLER                   PIC X(01) VALUE SPACES.      
      *                                                                         
       01  WS-WORK-QUEUE-DIRECTION.                                     
           05  WS-CATEGORY-ID              PIC S9(04)  COMP VALUE 33.   
           05  WS-CATEGORY-ID-141          PIC S9(04)  COMP VALUE 141.  
           05  WS-CATEGORY-ID-142          PIC S9(04)  COMP VALUE 142.  
           05  WS-CATEGORY-ID-173          PIC S9(04)  COMP VALUE 173.  
T27149     05  WS-CATEGORY-ID-276          PIC S9(04)  COMP VALUE 276.  
           05  WS-ROUTING-CATEGORY         PIC X       VALUE '1'.       
           05  WS-NORMAL-PRIORITY          PIC X       VALUE 'N'.       
      *                                                                         
       01  WS-MISC-VARIABLES.                                           
36423      05  WS-NO-MORE-BG-SW        PIC X    VALUE 'N'.              
           05  WS-BILL-CYCLE           PIC XX   VALUE SPACES.           
           05  WS-USAGE-TYPE-DESC      PIC X(3) VALUE SPACES.           
           05  WS-BTU-FACTOR           PIC S99V9(5) COMP-3 VALUE ZERO.  
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
           05  WS-RESTART-JOB-COMPLETE     REDEFINES                    
               WS-RESTART-PROCESS-TYPE     PIC X(01).                   
           05  WS-RESTART-JOB-STATUS       PIC X(01).                   
               88  WS-RUN-COMPLETED-NO-PROBLEMS VALUE 'A'.              
               88  WS-RERUN-COMPLETED           VALUE 'B'.              
               88  WS-RERUN-PENDING             VALUE 'C'.              
           05  WS-RESTART-INPUT-DATE       PIC X(10).                   
           05  WS-RESTART-CHKP-SEQ-NO      PIC 9(05) VALUE ZERO.        
           05  WS-RESTART-RECORD-NO        PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-FBW05A-REC-CNTR  PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-MN-UPDT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-BI-ISRT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-BG-ISRT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-BG-UPDT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-CX-ISRT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-CX-UPDT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-IV-ISRT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-IV-UPDT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-GA-ISRT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-GA-UPDT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-AT-UPDT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-RF-ISRT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-RF-UPDT-CNTR-TOT PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-SAVE-DATE-TIME   PIC X(19) VALUE ZERO.        
           05  WS-RESTART-SAVE-MTR-VOL     PIC X(09) VALUE ZERO.        
           05  WS-RESTART-SAVE-MTR-PRE     PIC X(06) VALUE ZERO.        
           05  WS-RESTART-SAVE-MTR-TMP     PIC X(06) VALUE ZERO.        
           05  WS-RESTART-SAVE-VOL-TYPE    PIC X(01) VALUE ZERO.        
           05  WS-RESTART-POST-METER-NO    PIC X(09) VALUE ZERO.        
           05  WS-RESTART-POST-ACCT-NO     PIC 9(13) VALUE ZERO.        
           05  WS-RESTART-FIRST-RECORD     PIC X(01) VALUE 'Y'.         
           05  WS-RESTART-NO-OF-REJECT     PIC 9(06) VALUE ZERO.        
           05  WS-RESTART-COUNT-METER      PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-COUNT-GAS        PIC 9(07) VALUE ZERO.        
           05  WS-RESTART-GAS-WORKQ        PIC 9(07) VALUE ZERO.        
                                                                        
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH    PIC S9(04) COMP VALUE +214.    
           05  WS-IS-THIS-A-RESTART      PIC X(01) VALUE 'N'.           
               88  WS-THIS-IS-A-RESTART            VALUE 'Y'.           
           05  WS-NEXT-RECORD-READ-FLAG  PIC X(01) VALUE 'N'.           
               88  WS-NEXT-RECORD-READ             VALUE 'Y'.           
               88  WS-NEXT-RECORD-NOT-READ         VALUE 'N'.           
           05  WS-RESTART-REQ            PIC X(01).                     
           05  WS-PRINT-COUNTERS         PIC X(01) VALUE 'A'.           
           05  WS-DEFAULT-RESTART-REQ    PIC X(01) VALUE 'N'.           
           05  WS-PROCESS-TYPE           PIC 9(01).                     
           05  WS-REPOSITION-NEEDED      PIC X(01) VALUE 'Y'.           
           05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04) VALUE 4.             
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04) VALUE 20.            
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID   PIC X(02) VALUE 'B4'.               
               10  WS-CHKP-PART-NO  PIC 9(01) VALUE 1.                  
               10  WS-CHKP-SEQ-NO   PIC 9(05) VALUE ZERO.               
      *                                                                         
       01  WS-METER-NO                     PIC X(09).                   
       01  WS-METER-NO-NUM   REDEFINES WS-METER-NO                      
                                           PIC 9(09).                   
       01  WS-CUR-ACCT-IND                 PIC X(01) VALUE 'N'.         
           88  CUR-ACCT-FOUND              VALUE 'Y'.                   
           88  CUR-ACCT-NOTFOUND           VALUE 'N'.                   
       01  WS-ACCT-MATCH-IND               PIC X(01) VALUE 'N'.         
           88  ACCT-MATCH-FOUND            VALUE 'Y'.                   
           88  ACCT-MATCH-NOTFOUND         VALUE 'N'.                   
       01  WS-MTR-INACTIVE-IND             PIC X(01) VALUE 'N'.         
           88  MTR-INACTIVE                VALUE 'Y'.                   
           88  MTR-ACTIVE                  VALUE 'N'.                   
       01  WS-ACCT-INACTIVE-IND            PIC X(01) VALUE 'N'.         
           88  ACCT-INACTIVE               VALUE 'Y'.                   
           88  ACCT-ACTIVE                 VALUE 'N'.                   
       01  WS-SKIP-REC                     PIC X(01) VALUE 'N'.         
           88  SKIP-RECORD                 VALUE 'Y'.                   
       01  WS-ACCT-SKIP-REC                PIC X(01) VALUE 'N'.         
           88  ACCT-SKIP-RECORD            VALUE 'Y'.                   
       01  WS-MTR-SKIP-REC                 PIC X(01) VALUE 'N'.         
           88  MTR-SKIP-RECORD             VALUE 'Y'.                   
       01  WS-COPY-DATA-FL                 PIC X(01) VALUE 'N'.         
           88  COPY-TO-OUTPUT              VALUE 'Y'.                   
       01  WS-ORIF-METER                   PIC X(01) VALUE 'N'.         
           88  ORIFICE-METER               VALUE 'Y'.                   
       01  WS-CANCEL-REBILL-IND            PIC X(01) VALUE 'N'.         
           88  CANCEL-REBILL               VALUE 'Y'.                   
       01  WS-METER-CHANGE-IND             PIC X(01) VALUE 'N'.         
           88  METER-CHANGE                VALUE 'Y'.                   
           88  METER-UNCHANGE              VALUE 'N'.                   
      *                                                                         
       01  WS-WORK-QUEUE-DATA.                                          
           05  WS-WQ-METER-NO              PIC 9(09).                   
           05  WS-WQ-READING               PIC 9(06)V999.               
           05  WS-WQ-DATE-READ             PIC X(10).                   
           05  WS-WQ-TIME-READ             PIC X(08).                   
           05  WS-WQ-UTIL-TYPE             PIC X.                       
           05  WS-WQ-READ-CODE             PIC X.                       
           05  WS-WQ-RD-TYPE-COND-CD       PIC X.                       
           05  WS-WQ-REGISTER-BREAKDOWN    PIC X(03).                   
           05  WS-WQ-CODE-TIME-PERIOD      PIC 9(01).                   
           05  WS-WQ-READ-ROUTE            PIC 9(04).                   
           05  WS-WQ-MTR-SEQ-NO            PIC 9(08).                   
           05  WS-WQ-COMMENTS-CODES.                                    
               10  WS-WQ-CANT-RD-OTHER-CD  PIC XX.                      
               10  WS-WQ-COMMENT-CODE-1    PIC X.                       
               10  WS-WQ-COMMENT-CODE-2    PIC X.                       
               10  WS-WQ-READER-ID         PIC X(05).                   
           05  WS-WQ-READINGS.                                          
               10  WS-WQ-TOTAL-COR         PIC 9(06)V999.               
               10  WS-WQ-TOTAL-UNC         PIC 9(06)V999.               
               10  FILLER                  PIC X(162).                  
           05  WS-WQ-BTU-FACTOR            PIC 9(02)V9(5).              
           05  WS-WQ-CYCLE-IND             PIC X.                       
                                                                        
       01  WS-WQ-COMMENTS.                                              
           05  WS-WQ-MESSAGE               PIC X(85).                   
      *                                                                         
       01  WS-RESTART-MISC.                                             
           05  WS-CHKP-LUW-LIMIT         PIC 9(04).                     
           05  WS-CHKP-LUW-COUNTER       PIC 9(04) COMP-3 VALUE ZERO.   
           05  WS-CHKP-UPD-LIMIT         PIC 9(04).                     
           05  WS-CHKP-UPD-COUNTER       PIC S9(04) COMP-3 VALUE ZERO.  
      *****************************************************************         
      *    THE FOLLOWING FIELD WILL ALLOW PROGRAMMER TO FORCE ABEND BY          
      *    SPECIFYING AN ACCOUNT NO                                             
      *****************************************************************         
           05  WS-STOP-ACCOUNT-NO            PIC 9(13).                 
      *****************************************************************         
      *  THE FOLLOWING FIELDS ARE TO STORE OFF THE DATABASE UPDATE              
      *  COUNTERS "PER LUW" AN LUW = 1 ENTRY IN THE JOB PARM TABLE              
      *****************************************************************         
           05  WS-MN-UPDT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-CX-UPDT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-BI-ISRT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-GA-UPDT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-GA-ISRT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-BG-ISRT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-BG-UPDT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-CX-ISRT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-AT-UPDT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RF-ISRT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RF-UPDT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-IV-ISRT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-IV-UPDT-CNTR-LUW                PIC S9(07) COMP-3     
                                                             VALUE ZERO.
      *                                                                         
       01  WS-STOP-PARM-BREAKDOWN.                                      
           05  WS-STOP-PARM-ACCOUNT-NO   PIC 9(10).                     
           05  FILLER                    PIC X(38).                     
      *                                                                         
       01  WS-ERROR-MESSAGES.                                           
           05  MSG-DAILY-VOL-LESS-25.                                   
               10  FILLER                PIC X(19)     VALUE            
                              'WARNING:DAILY VOL <'.                    
               10  MSG-LOW-PCT           PIC X(05).                     
               10  MSG-LOW-PCT-R REDEFINES MSG-LOW-PCT                  
                                         PIC -9.99.                     
               10  FILLER                PIC X(16)     VALUE            
                                 ' TIMES HIST VOL;'.                    
           05  MSG-DAILY-VOL-MORE-25.                                   
               10  FILLER                PIC X(19)     VALUE            
                              'WARNING:DAILY VOL >'.                    
               10  MSG-HIGH-PCT          PIC X(05).                     
               10  MSG-HIGH-PCT-R REDEFINES MSG-HIGH-PCT                
                                         PIC -9.99.                     
               10  FILLER                PIC X(16)     VALUE            
                                 ' TIMES HIST VOL;'.                    
           05  MSG-MULTI-INTERVAL-ROWS.                                 
               10 FILLER                   PIC X(54)   VALUE            
               'ERROR:MORE THAN ONE READING RECEIVED FOR THE INTERVAL.'.
               10 FILLER                   PIC X(54)   VALUE            
               ' PLEASE RESEND THE VOL FROM EFM.'.                      
           05  MSG-NO-PREMISE              PIC X(18)   VALUE            
               'PREMISE NOT FOUND '.                                    
           05  MSG-NO-MTRD-ENV             PIC X(28)   VALUE            
               'NO METER ENVIRONMENT FOUND. '.                          
           05  MSG-CHG-METER-NO            PIC X(27)   VALUE            
               'METER NUMBER HAS CHANGED. '.                            
           05  MSG-NOT-VALID-CNTRCT.                                    
               10 FILLER                   PIC X(42)   VALUE            
                  'ERROR:READINGS FOR THE DAY/MTR CAN NOT BE '.         
               10 FILLER                   PIC X(43)   VALUE            
                  'POSTED, AS IT DOES NOT HAVE A VALID CNTRCT.'.        
           05  MSG-CNTRCT-DT               PIC X(10).                   
           05  MSG-FUTURE-BILL-HOOK.                                    
               10 FILLER                   PIC X(41)   VALUE            
C37131            'ERROR:  VOLUMES RECEIVED FOR INVALID DAY '.          
C37131         10 FILLER                   PIC X(10)   VALUE            
C37131            'FOR METER '.                                         
C37131         10 MSG-MTR-NUM              PIC X(09).                   
           05  MSG-INDUST-BTU.                                          
               10 FILLER                   PIC X(43)   VALUE            
                   'WARNING:INDUST BTU ID HAS SPACES. METER NO.'.       
               10 MSG-MN-MTR-NO            PIC X(09).                   
           05  MSG-ACCOUNT-NO-NOT-FOUND.                                
              10 FILLER                    PIC X(17)   VALUE            
                                           'ERROR:ACCOUNT NO.'.         
              10 MSG-ACCOUNT-NO            PIC X(13).                   
              10 FILLER                    PIC X(21)   VALUE            
                                           ' NOT FOUND. METER NO.'.     
              10 MSG-MTR-NO                PIC X(09).                   
              10 FILLER                    PIC X(22)   VALUE            
                                           ' READINGS ARE SKIPPED.'.    
                                                                        
           05  MSG-ACCT-MTR-COMB-NOT-FOUND.                             
              10 FILLER                    PIC X(43) VALUE              
                   'ERROR:ACCT/METER COMBINATION IS NOT VALID. '.       
              10 FILLER                    PIC X(09)   VALUE            
                                                         'METER NO:'.   
              10 MSG-METER-NO              PIC X(09).                   
              10 FILLER                    PIC X(09)   VALUE            
                                                         ';ACCT NO:'.   
              10 MSG-ACCT-NO               PIC X(13).                   
           05  MSG-METER-WAS-SKIPED.                                    
              10 FILLER                    PIC X(15)   VALUE            
                                           'ERROR:METER NO.'.           
              10 MSG-METER-NO-SKIP         PIC X(09).                   
              10 FILLER                    PIC X(21)   VALUE            
                                           ' READINGS ARE SKIPED.'.     
              10 FILLER                    PIC X(27)   VALUE            
                                     ' INVALID EFM INPUT-ACCT NO:'.     
              10 MSG-ACCT-NO-SKIP          PIC X(13).                   
           05  MSG-INACT-METER-HAS-USE     PIC X(40)   VALUE            
               'ERROR:INACTIVE ACCOUNT/METER HAS USAGE. '.              
           05  MSG-REMV-METER-HAS-READ     PIC X(25)   VALUE            
               'REMOVED METER HAS READING'.                             
      *                                                                         
A04860     05  SCSCB077                     PIC X(08) VALUE 'SCSCB077'. 
A04860*                                                                         
       01  WS-SCSCA120-LINK-RECORD.                                     
           05  WS-CA120-ERROR-NUMBER       PIC 9(6).                    
COB305     05 WS-CA120-TEMPERATURE        PIC S999 COMP-3 VALUE 0.          
COB305     05 WS-CA120-SPECIFIC-GRAVITY        PIC S9V999 COMP-3 
COB305       VALUE 0.          
COB305     05 WS-CA120-GAUGE-PRESSURE        PIC S9(4)V9 COMP-3 VALUE 0.        
COB305     05 WS-CA120-FPV-FACTOR        PIC S9V9(4) COMP-3 VALUE 0.          
      *                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE         PIC S9(04) COMP VALUE 0.          
           05  RS-RETURN-CODE-DISP    PIC +Z(04).                       
      *                                                                         
A04860 01  WS-CURR-TS.                                                  
A04860     05  WS-CURR-DATE-TS              PIC X(10).                  
A04860     05  WS-CURR-TS-REF               PIC X(16)                   
A04860                                    VALUE '-00.00.00.000000'.     
A04860******************************************************************        
A04860* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
A04860******************************************************************        
A04860*                                                                         
A04860     EXEC SQL                                                             
A04860        INCLUDE CWS00077                                                  
A04860     END-EXEC.                                                            
A04860*                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00042                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DB2 TABLE DCLGENS USING IN THIS PROGRAM                              
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTHGLW                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBINDFCT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBINTVRD                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLREL                                                 
           END-EXEC.                                                            
     *                                                                  
           EXEC SQL                                                             
               INCLUDE TBMTRIDT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLCNTR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBXREF                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      *                                                                         
           COPY FIOCA00.                                                        
      *                                                                         
      ***********************************************************               
      *          CURSOR DECLARATION FOR CSS_BILL_CONTRACT       *               
      ***********************************************************               
      *                                                                         
           EXEC SQL                                                     
               DECLARE BILL_CNTRCT CURSOR FOR                           
                SELECT 'Y'                                              
                  FROM CSS_BILL_CONTRACT WITH(READUNCOMMITTED)                  
                 WHERE ACCOUNT_NO      = :BK-ACCOUNT-NO                 
                   AND CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE             
                   AND IC_NO           = :BK-IC-NO                      
                   AND CNTRCT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                     :WS-CURR-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE-READ
              ) <> 0) OR (LEN(:WS-CURR-DATE-READ
              ) <> 10), CIS.CHAR2DATE(:WS-CURR-DATE-READ
              ), CONVERT(DATE, :WS-CURR-DATE-READ) )            
                   AND CNTRCT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-CURR-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE-READ
              ) <> 0) OR (LEN(:WS-CURR-DATE-READ
              ) <> 10), CIS.CHAR2DATE(:WS-CURR-DATE-READ
              ), CONVERT(DATE, :WS-CURR-DATE-READ) )            
                ORDER BY CNTRCT_START_DT DESC                           
C35804          FOR READ ONLY                                   
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILL_CNTRCT CURSOR FOR                                   
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           FROM CSS_BILL_CONTRACT                                        
MFA-TR*          WHERE ACCOUNT_NO      = :BK-ACCOUNT-NO                         
MFA-TR*            AND CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE                     
MFA-TR*            AND IC_NO           = :BK-IC-NO                              
MFA-TR*            AND CNTRCT_START_DT <= :WS-CURR-DATE-READ                    
MFA-TR*            AND CNTRCT_END_DT   >= :WS-CURR-DATE-READ                    
MFA-TR*         ORDER BY CNTRCT_START_DT DESC                                   
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7950                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      *          CURSOR DECLARATION FOR CSS_BILLING_HDR         *               
      ***********************************************************               
           EXEC SQL                                                     
               DECLARE BILLING_HDR CURSOR FOR                           
                SELECT ACCOUNT_NO,                                      
                       PREMISE_NO,                                      
                       BILL_NO,                                         
                       DATE_BILLED                                      
                  FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_NO       = :BI-ACCOUNT-NO                
              ORDER BY BILL_NO DESC                                     
C35804          FOR READ ONLY                                   
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILLING_HDR CURSOR FOR                                   
MFA-TR*         SELECT ACCOUNT_NO,                                              
MFA-TR*                PREMISE_NO,                                              
MFA-TR*                BILL_NO,                                                 
MFA-TR*                DATE_BILLED                                              
MFA-TR*           FROM CSS_BILLING_HDR                                          
MFA-TR*          WHERE ACCOUNT_NO       = :BI-ACCOUNT-NO                        
MFA-TR*       ORDER BY BILL_NO DESC                                             
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7230                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      *          CURSOR DECLARATION FOR CSS_BILLING_DET - 1     *               
      ***********************************************************               
           EXEC SQL                                                     
               DECLARE BILLING_DET CURSOR FOR                           
                SELECT ACCOUNT_NO                                       
                      ,PREMISE_NO                                       
                      ,BILL_NO                                          
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                               
                      ,DATE_ORIG_BILL                                   
                      ,AMT_BILL_ITEM                                    
                      ,CODE_BILL_CALC                                   
                      ,CODE_BILL_ITM_TYPE                               
                      ,CODE_BILL_ITM_IND                                
                      ,CODE_DR_CR_CNSMPTN                               
                      ,AMT_STATE_TAX                                    
                      ,AMT_CITY_TAX                                     
                      ,AMT_OTHER_TAX                                    
                      ,CODE_REVENUE_CLASS                               
                      ,CODE_SIC_NO                                      
                      ,RATE_PLAN_NO                                     
                      ,CODE_CURTAIL_PRTY                                
                      ,CODE_STAT_TAX_XMT                                
                      ,CODE_CITY_TAX_XMT                                
                      ,CODE_OTHR_TAX_XMT                                
                  FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO              
                   AND BILL_NO            = :BG-BILL-NO                 
                   AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE          
                   AND IC_NO              = :BG-IC-NO                   
                   AND DATE_ORIG_BILL IS NULL                           
                   AND CODE_BILL_CALC     = :WS-ACTIVE                  
                   AND CODE_BILL_ITM_TYPE = :WS-CURRENT                 
                   AND CODE_BILL_ITM_IND = :WS-ACTIVE                   
                   AND CODE_REVENUE_CLASS = :BG-CODE-REVENUE-CLASS      
                   AND (REBILL_IND = ' '                                
                       OR REBILL_IND = 'N')                             
              ORDER BY BILL_ITEM_TIMESTMP DESC                          
C35804          FOR READ ONLY                                   
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILLING_DET CURSOR FOR                                   
MFA-TR*         SELECT ACCOUNT_NO                                               
MFA-TR*               ,PREMISE_NO                                               
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,BILL_ITEM_TIMESTMP                                       
MFA-TR*               ,DATE_ORIG_BILL                                           
MFA-TR*               ,AMT_BILL_ITEM                                            
MFA-TR*               ,CODE_BILL_CALC                                           
MFA-TR*               ,CODE_BILL_ITM_TYPE                                       
MFA-TR*               ,CODE_BILL_ITM_IND                                        
MFA-TR*               ,CODE_DR_CR_CNSMPTN                                       
MFA-TR*               ,AMT_STATE_TAX                                            
MFA-TR*               ,AMT_CITY_TAX                                             
MFA-TR*               ,AMT_OTHER_TAX                                            
MFA-TR*               ,CODE_REVENUE_CLASS                                       
MFA-TR*               ,CODE_SIC_NO                                              
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,CODE_CURTAIL_PRTY                                        
MFA-TR*               ,CODE_STAT_TAX_XMT                                        
MFA-TR*               ,CODE_CITY_TAX_XMT                                        
MFA-TR*               ,CODE_OTHR_TAX_XMT                                        
MFA-TR*           FROM CSS_BILLING_DET                                          
MFA-TR*          WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                      
MFA-TR*            AND BILL_NO            = :BG-BILL-NO                         
MFA-TR*            AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                  
MFA-TR*            AND IC_NO              = :BG-IC-NO                           
MFA-TR*            AND DATE_ORIG_BILL IS NULL                                   
MFA-TR*            AND CODE_BILL_CALC     = :WS-ACTIVE                          
MFA-TR*            AND CODE_BILL_ITM_TYPE = :WS-CURRENT                         
MFA-TR*            AND CODE_BILL_ITM_IND = :WS-ACTIVE                           
MFA-TR*            AND CODE_REVENUE_CLASS = :BG-CODE-REVENUE-CLASS              
MFA-TR*            AND (REBILL_IND = ' '                                        
MFA-TR*                OR REBILL_IND = 'N')                                     
MFA-TR*       ORDER BY BILL_ITEM_TIMESTMP DESC                                  
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7240                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
A02906***********************************************************               
A02906*          CURSOR DECLARATION FOR CSS_UTL_BILL_REL        *               
A02906***********************************************************               
A02906     EXEC SQL                                                     
A02906        DECLARE UTL_BILL_REL CURSOR FOR                           
A02906        SELECT UR.ACCOUNT_NO_MST                                  
A02906              ,UR.CODE_UTIL_TYPE_MST                              
A02906              ,UR.IC_NO_MST                                       
A02906              ,UR.MTR_REF_NO_MST                                  
A02906          FROM CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED)                  
A02906        WHERE UR.ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP          
A02906          AND UR.CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP      
A02906          AND UR.IC_NO_DEP          = :UR-IC-NO-DEP               
A02906          AND UR.MTR_REF_NO_DEP     = :UR-MTR-REF-NO-DEP          
A02906          AND UR.CODE_RELATION_TYPE = 'S'                         
A02906          AND UR.DEP_REL_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                   :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) )        
A02906          AND UR.DEP_REL_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                     :UR-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-END-DT
              ), CONVERT(DATE, :UR-DEP-REL-END-DT) )          
A02906          FOR READ ONLY                                   
A02906                                                      
A02906*                                                                         
A02906     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE UTL_BILL_REL CURSOR FOR                                   
MFA-TR*       SELECT UR.ACCOUNT_NO_MST                                          
MFA-TR*             ,UR.CODE_UTIL_TYPE_MST                                      
MFA-TR*             ,UR.IC_NO_MST                                               
MFA-TR*             ,UR.MTR_REF_NO_MST                                          
MFA-TR*         FROM CSS_UTL_BILL_REL UR                                        
MFA-TR*       WHERE UR.ACCOUNT_NO_DEP     = :UR-ACCOUNT-NO-DEP                  
MFA-TR*         AND UR.CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP              
MFA-TR*         AND UR.IC_NO_DEP          = :UR-IC-NO-DEP                       
MFA-TR*         AND UR.MTR_REF_NO_DEP     = :UR-MTR-REF-NO-DEP                  
MFA-TR*         AND UR.CODE_RELATION_TYPE = 'S'                                 
MFA-TR*         AND UR.DEP_REL_START_DT  <= :UR-DEP-REL-START-DT                
MFA-TR*         AND UR.DEP_REL_END_DT    >= :UR-DEP-REL-END-DT                  
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       QUERYNO 7900                                                      
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
      *********************** END DECLARATIVES ******************               
      *                                                                         
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSBW138 ENDS HERE  '.            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   0000-MAINLINE.                                               *        
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 0600-PREPARE-FOR-RESTART      THRU 0600-EXIT.        
           PERFORM 0605-VALIDATE-RESTART-REQ     THRU 0605-EXIT.        
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-YES TO WS-REPOSITION-NEEDED                       
              PERFORM 0700-OPEN-RESTART THRU 0700-EXIT                  
           ELSE                                                         
              PERFORM 0610-INITIALIZE-RESTART    THRU 0610-EXIT         
              MOVE 0                  TO WS-PROCESS-TYPE                
              MOVE WS-RUN-DATE        TO WS-RESTART-INPUT-DATE          
              MOVE WS-YES             TO WS-REPOSITION-NEEDED           
           END-IF.                                                      
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              OPEN EXTEND FCSBW05A-FILE                                 
           ELSE                                                         
              OPEN OUTPUT FCSBW05A-FILE                                 
           END-IF                                                       
      *                                                                         
           IF FCSBW05A-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** 0000-ERROR ON FCSBW05A OPEN. STATUS IS '      
                                  WS-FCSBW05A-STATUS                    
              PERFORM 9900-ABEND                 THRU 9900-EXIT
           END-IF.        
                                                                        
           PERFORM 7400-READ-EFM-FILE        THRU 7400-EXIT.            
           IF WS-EFM-EOF                                                
              DISPLAY '************************************************'
              DISPLAY '**         PCSBW138 PROCESSING ERROR          **'
              DISPLAY '**           FCSBW05  FILE IS EMPTY           **'
              DISPLAY '**           PROCESSING TERMINATED            **'
30909         DISPLAY '**    IF PCSBW139 COMPLETED WITH A 0 CONDITION**'
30909         DISPLAY '**    CODE AND THE FILES USED IN THE JOB      **'
30909         DISPLAY '**    ARE AS STATED BELOW                     **'
30909         DISPLAY '**    CSR.PROD.UPLD.FCSBW05                   **'
30909         DISPLAY '**    CSR.PROD.FCSBW05(+1)                    **'
30909         DISPLAY '**    BOTH OF THE ABOVE HAVE ALL 9S IN POS 1  **'
30909         DISPLAY '**    THRU 30 AND 53 TO 80 AND ZEROS          **'
30909         DISPLAY '**    IN THE MIDDLE.                          **'
30909         DISPLAY '**    AND CSR.PROD.FCSBW05A(0),BEFORE THIS JOB**'
30909         DISPLAY '**    RUNS IS EMPTY.                          **'
30909         DISPLAY '**                                            **'
30909         DISPLAY '**    THEN RUNNING WITH AN EMPTY FILE IS OK   **'
30909         DISPLAY '**                                            **'
30909         DISPLAY '************************************************'
30909         GO TO 0000-EMPTY-FILE-ENDING                              
           END-IF.                                                      
      *                                                                         
           PERFORM 1000-PROCESS-EFM              THRU 1000-EXIT         
                                UNTIL WS-EFM-EOF.                       
           IF NOT COPY-TO-OUTPUT AND NOT SKIP-RECORD                    
              AND NOT ACCT-SKIP-RECORD AND NOT MTR-SKIP-RECORD          
C37131         AND VALID-CONS                                           
              PERFORM 2000-CREATE-CX THRU 2000-EXIT                     
      *                                                                         
              IF WS-WQ-FLAG EQUAL WS-Y                                  
                 MOVE WS-N  TO WS-WQ-FLAG                               
              ELSE                                                      
                 DISPLAY 'PROCESSED METER NO:' WS-PREV-METER-NO         
                        ' SUCCESSFULLY. READ DATE:' WS-PREV-DATE-READ   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-THIS-IS-A-RESTART AND WS-PROCESS-TYPE GREATER THAN 1   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 2 TO WS-PROCESS-TYPE                                 
              MOVE WS-NO TO WS-REPOSITION-NEEDED                        
              PERFORM 8898-ISSUE-CHKP            THRU 8898-EXIT         
              MOVE WS-YES TO WS-REPOSITION-NEEDED                       
           END-IF.                                                      
      ******************************************************************        
      * THE FOLLOWING STATEMENTS UPGRADE THE JOB-COMPLETE FIELD TO              
      * INDICATE A SUCCESSFUL COMPLETION:                                       
      ******************************************************************        
           MOVE SPACES   TO WS-RESTART-JOB-COMPLETE.                    
           IF WS-THIS-IS-A-RESTART                                      
              SET WS-RERUN-COMPLETED TO TRUE                            
           ELSE                                                         
              SET WS-RUN-COMPLETED-NO-PROBLEMS TO TRUE                  
           END-IF.                                                      
      *                                                                         
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
             AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 8899-WRITE-RSDDR           THRU 8899-EXIT         
           END-IF.                                                      
      *                                                                         
           IF WS-PRINT-COUNTERS = 'B' OR 'C'                            
              PERFORM 8180-PRINT-COUNTERS        THRU 8180-EXIT         
           END-IF.                                                      
      *                                                                         
           IF WS-RESTART-REQ EQUAL WS-YES                               
              PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT        
           END-IF.                                                      
      *                                                                         
           PERFORM 8940-DISPLAY-COUNTERS         THRU 8940-EXIT.        
      *                                                                         
       0000-EMPTY-FILE-ENDING.                                          
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
      *                                                                         
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                         
      *   0100-INITIALIZATION                                                   
      *        COMMON INITIALIZATION ROUTINE.                                   
      *        RETRIEVE JOB PARMS.                                              
      *                                                                         
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT FCSBW05-FILE.                                     
           IF FCSBW05-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW138   **'     
              DISPLAY '**        PARA - 0100-INITIALIZARION      **'    
              DISPLAY '**       ERROR DURING OPEN OF FILE        **'    
              DISPLAY '**               FCSBW05                  **'    
              DISPLAY '**  RC = ' WS-FCSBW05-STATUS                     
              DISPLAY '**          PROCESSING TERMINATED         **'    
              PERFORM 9900-ABEND                 THRU 9900-EXIT
           END-IF.        
      *                                                                         
           ACCEPT WS-CD-TIME FROM TIME.                                 
           MOVE WS-CD-HR  TO WS-INPUT-TIME-HH.                          
           MOVE WS-CD-MIN TO WS-INPUT-TIME-MM.                          
           MOVE WS-CD-SEC TO WS-INPUT-TIME-SS.                          
      *                                                                         
           MOVE WS-COMP-NO             TO G6-COMPANY-NO.                
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF  COMMON-DATE-NEEDED                                       
C28742         MOVE 'COMMON'               TO WS-PGRMNAME               
C28742         PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT               
C30010         MOVE WS-PCSBW138            TO WS-PGRMNAME               
C28742     END-IF.                                                      
           MOVE WS-INPUT-DATE              TO WS-RUN-DATE               
                                              WS-WORK-DATE.             
C28742     DISPLAY 'COMMON DATE ==> ' WS-RUN-DATE.                      
      *                                                                 05620000
      *---------------------------------------------------------------*         
      * SELECT REV MONTH FROM BILL WINDOW FOR CURR DATE OF MIN(REVMTH)          
      *---------------------------------------------------------------*         
           MOVE WS-WORK-DATE            TO BN-DATE-EXTRACT.             
           PERFORM 7025-SELECT-CURR-REVMTH THRU 7025-EXIT.              
           DISPLAY 'CURR REVENUE MONTH: ' WS-REVENUE-MONTH.             
      *                                                                         
           MOVE WS-PCSBW138                    TO WS-PROGRAM.           
           MOVE SPACES                         TO WS-SYSIPT.            
           MOVE ZEROS                          TO WS-SEQUENCE.          
           MOVE WS-PARM                        TO WS-COMMAND.           
           MOVE WS-KEY-AREA                    TO E-FJC01-KEY.          
           PERFORM 7600-START-FCSJC01          THRU 7600-EXIT.          
           PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT           
             UNTIL (WS-INPUT-DATA-BREAKDOWN(1:13) =                     
                        'GAS-READINGS=' AND INPUT-ACTIVE)               
                OR END-OF-SYSIPT.                                       
           IF END-OF-SYSIPT                                             
              DISPLAY '      '                                          
              DISPLAY '** ' WS-PROGRAM ' INFORMATIONAL MSG **'          
              DISPLAY '** GAS-READINGS PARM NOT ACTIVE,'                
                      ' DEFAULT GAS READINGS ARE USED'                  
              DISPLAY '** START TIME: ' WS-START-TIME                   
                      ' END TIME: ' WS-END-TIME                         
           ELSE                                                         
              MOVE G6-PARM-DATA        TO WS-INPUT-GAS-DATA             
              MOVE WS-GAS-END-PARM     TO WS-PARM-END-TIME              
C30010        MOVE WS-END-TIME-HH      TO WS-CUR-TIME-HH                
              MOVE WS-GAS-START-PARM   TO WS-PARM-START-TIME            
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
           END-IF.                                                      
C30010*******************************************************                   
ST         MOVE WS-PCSBW138                    TO WS-PROGRAM.           
           MOVE SPACES                         TO WS-SYSIPT.            
           MOVE ZEROES                         TO WS-SEQUENCE.          
           MOVE WS-PARM                        TO WS-COMMAND.           
           MOVE WS-KEY-AREA                    TO E-FJC01-KEY.          
           PERFORM 7600-START-FCSJC01          THRU 7600-EXIT.          
           PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT           
             UNTIL (WS-INPUT-DATA-BREAKDOWN(1:13) =                     
                        'EFF-GAS-DAY =' AND INPUT-ACTIVE)               
                OR END-OF-SYSIPT.                                       
           IF END-OF-SYSIPT                                             
              DISPLAY '      '                                          
              DISPLAY '** ' WS-PROGRAM ' INFORMATIONAL MSG **'          
              DISPLAY '** EFF-GAS-DAY  PARM NOT ACTIVE '                
           ELSE                                                         
              MOVE G6-PARM-DATA        TO WS-INPUT-GAS-DAY              
              MOVE WS-GAS-EFF-TIME     TO WS-PARM-EFF-TIME              
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
END        END-IF.                                                      
C30010*******************************************************                   
           MOVE WS-COMP-NO             TO G6-COMPANY-NO.                
      *                                                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
             AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
               DISPLAY ' '                                              
               DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'   
               DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'          
               DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS    
                       ', INTERPRETED TO**'                             
               DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'          
               DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'          
               DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'          
               DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'          
               DISPLAY '**      PROCESSING CONTINUING      **'          
           END-IF.                                                      
      *                                                                         
           PERFORM 6255-GET-FJC01-PRT-CNTR THRU 6255-EXIT.              
      *                                                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ    THRU 6235-EXIT.        
      *                                                                         
           MOVE ZEROS TO WS-WORK-QUEUE-DATA.                            
      *                                                                         
           SET FIRST-RECORD TO TRUE.                                    
           MOVE ZEROS       TO WS-PREV-ACCT-NO                          
                               WS-DAILY-VOLUME                          
                               WS-DAILY-PRES                            
T29165                         WS-NO-OF-REJECT                          
                               WS-DAILY-TEMP.                           
           MOVE SPACES      TO WS-PREV-METER-NO                         
                               WS-PREV-DATE-TIME.                       
           MOVE 9999        TO WS-RR-WQ-MTR-POST.                       
A04860     MOVE SPACES      TO WS-77-COMMENTS-TEXT.                     
A04860     MOVE ZEROES TO WS-77-COMMENTS-LEN                            
A04860                    WS-77-FREE-FORM-LEN.                          
A04860     MOVE SPACES TO WS-77-COMMENTS-TEXT                           
                          WS-WQ-MESSAGE                                 
                          WS-COMMENTS-TEMP.                             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                                         
      *    0600-PREPARE-FOR-RESTART                                             
      *                                                                         
      *****************************************************************         
       0600-PREPARE-FOR-RESTART.                                        
      *                                                                         
           MOVE '0600'                  TO ACTIVE-PARAGRAPH.            
           MOVE PROGRAM-NAME            TO RF-NAME-PROGRAM.             
           MOVE WS-ONE                  TO RF-PARTITION-NO.             
           MOVE WS-ONE                  TO RF-DUP-CNTRL-NO.             
           PERFORM 7475-SELECT-RESTART-DATA  THRU 7475-EXIT.            
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE RF-RESTART-DATA-TEXT     TO WS-RESTART-DATA         
               IF  WS-RESTART-PROCESS-TYPE NUMERIC                      
                   MOVE WS-YES               TO WS-IS-THIS-A-RESTART    
              ELSE                                                      
                 GO TO 0600-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              GO TO 0600-EXIT                                           
           END-IF.                                                      
      *****************************************************************         
      *    REPOSITION INPUT FILE                                                
      *****************************************************************         
           MOVE ZERO TO WS-FCSBW05-REC-CNTR                             
                        WS-FCSBW05A-REC-CNTR.                           
           PERFORM 7400-READ-EFM-FILE       THRU 7400-EXIT              
             UNTIL WS-FCSBW05-REC-CNTR  EQUAL WS-RESTART-RECORD-NO.     
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF PCSBW138  *****'.       
           DISPLAY '*******************************************'.       
           MOVE WS-RESTART-RECORD-NO         TO WS-FCSBW05-REC-CNTR.    
           MOVE WS-RESTART-FBW05A-REC-CNTR   TO WS-FCSBW05A-REC-CNTR.   
           MOVE WS-RESTART-CHKP-SEQ-NO       TO WS-CHKP-SEQ-NO.         
           MOVE WS-RESTART-PROCESS-TYPE      TO WS-PROCESS-TYPE.        
           MOVE WS-RESTART-SAVE-DATE-TIME    TO WS-PREV-DATE-TIME.      
           MOVE WS-RESTART-SAVE-MTR-VOL      TO WS-METER-VOLUME-RED     
           MOVE WS-RESTART-SAVE-MTR-PRE      TO WS-METER-PRESSURE-RED.  
           MOVE WS-RESTART-SAVE-MTR-TMP      TO WS-METER-TEMP-RED.      
           MOVE WS-RESTART-SAVE-VOL-TYPE     TO WS-METER-VOL-TYPE.      
           MOVE WS-RESTART-POST-METER-NO     TO WS-PREV-METER-NO        
           MOVE WS-RESTART-POST-ACCT-NO      TO WS-PREV-ACCT-NO.        
           MOVE WS-RESTART-NO-OF-REJECT      TO WS-NO-OF-REJECT.        
           MOVE WS-RESTART-MN-UPDT-CNTR-TOT  TO WS-MN-UPDT-CNTR-LUW.    
           MOVE WS-RESTART-BI-ISRT-CNTR-TOT  TO WS-BI-ISRT-CNTR-LUW.    
           MOVE WS-RESTART-BG-ISRT-CNTR-TOT  TO WS-BG-ISRT-CNTR-LUW.    
           MOVE WS-RESTART-BG-UPDT-CNTR-TOT  TO WS-BG-UPDT-CNTR-LUW.    
           MOVE WS-RESTART-CX-ISRT-CNTR-TOT  TO WS-CX-ISRT-CNTR-LUW.    
           MOVE WS-RESTART-CX-UPDT-CNTR-TOT  TO WS-CX-UPDT-CNTR-LUW.    
           MOVE WS-RESTART-GA-ISRT-CNTR-TOT  TO WS-GA-ISRT-CNTR-LUW.    
           MOVE WS-RESTART-GA-UPDT-CNTR-TOT  TO WS-GA-UPDT-CNTR-LUW.    
           MOVE WS-RESTART-AT-UPDT-CNTR-TOT  TO WS-AT-UPDT-CNTR-LUW.    
           MOVE WS-RESTART-RF-ISRT-CNTR-TOT  TO WS-RF-ISRT-CNTR-LUW.    
           MOVE WS-RESTART-RF-UPDT-CNTR-TOT  TO WS-RF-UPDT-CNTR-LUW.    
           MOVE WS-RESTART-IV-ISRT-CNTR-TOT  TO WS-IV-ISRT-CNTR-LUW.    
           MOVE WS-RESTART-IV-UPDT-CNTR-TOT  TO WS-IV-UPDT-CNTR-LUW.    
           MOVE WS-RESTART-COUNT-METER       TO WS-COUNT-METER.         
           MOVE WS-RESTART-COUNT-GAS         TO WS-COUNT-GAS.           
           MOVE WS-RESTART-GAS-WORKQ         TO WS-GAS-WORKQ.           
      *****************************************************************         
      *    THE FOLLOWING CODE COMPARES RUN DATE STORED IN                       
      *    RESTART DATA TO RUN DATE FROM JOB CONTROL FILE:                      
      *****************************************************************         
           IF WS-RESTART-INPUT-DATE  EQUAL WS-INPUT-DATE                
             OR WS-RESTART-INPUT-DATE EQUAL SPACES                      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '** RUN DATE WAS CHANGED PRIOR TO '              
                       'RESTART **'                                     
               DISPLAY '***************************************'        
               DISPLAY '** OLD RUN DATE = ' WS-RESTART-INPUT-DATE       
               DISPLAY '** NEW RUN DATE = ' WS-INPUT-DATE               
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
           PERFORM 8181-PRINT-COUNTERS THRU 8181-EXIT.                  
      *                                                                         
       0600-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                                         
      *    0605-VALIDATE-RESTART                                                
      *                                                                         
      *****************************************************************         
      *                                                               *         
       COPY CPD00030.                                                           
      *                                                               *         
      *****************************************************************         
      *    0610-INITIALIZE-RESTART                                    *         
      *****************************************************************         
      *                                                               *         
       0610-INITIALIZE-RESTART.                                         
      *                                                               *         
           MOVE ZEROS              TO WS-RESTART-PROCESS-TYPE           
                                      WS-RESTART-CHKP-SEQ-NO            
                                      WS-RESTART-MN-UPDT-CNTR-TOT       
                                      WS-RESTART-BI-ISRT-CNTR-TOT       
                                      WS-RESTART-BG-ISRT-CNTR-TOT       
                                      WS-RESTART-BG-UPDT-CNTR-TOT       
                                      WS-RESTART-CX-ISRT-CNTR-TOT       
                                      WS-RESTART-CX-UPDT-CNTR-TOT       
                                      WS-RESTART-GA-ISRT-CNTR-TOT       
                                      WS-RESTART-GA-UPDT-CNTR-TOT       
                                      WS-RESTART-AT-UPDT-CNTR-TOT       
                                      WS-RESTART-RF-ISRT-CNTR-TOT       
                                      WS-RESTART-RF-UPDT-CNTR-TOT       
                                      WS-RESTART-IV-ISRT-CNTR-TOT       
                                      WS-RESTART-IV-UPDT-CNTR-TOT       
                                      WS-RESTART-POST-ACCT-NO           
                                      WS-RESTART-NO-OF-REJECT           
                                      WS-RESTART-COUNT-METER            
                                      WS-RESTART-COUNT-GAS              
                                      WS-RESTART-GAS-WORKQ              
                                      WS-RESTART-FBW05A-REC-CNTR        
           MOVE SPACES             TO WS-RESTART-SAVE-DATE-TIME         
                                      WS-RESTART-INPUT-DATE             
                                      WS-RESTART-SAVE-MTR-VOL           
                                      WS-RESTART-SAVE-MTR-PRE           
                                      WS-RESTART-SAVE-MTR-TMP           
                                      WS-RESTART-SAVE-VOL-TYPE          
                                      WS-RESTART-POST-METER-NO          
           MOVE WS-YES             TO WS-RESTART-FIRST-RECORD           
           SET WS-RERUN-PENDING TO TRUE.                                
      *                                                                         
       0610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0700-OPEN-RESTART.                                               
      *                                                                         
           OPEN INPUT FCSBW05R-FILE.                                    
           IF NOT FBW05R-SUCCESSFUL                                     
              DISPLAY '0700-ERROR ON FCSBW05R OPEN.  STATUS IS '        
                           WS-FBW05R-STATUS                             
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN OUTPUT FCSBW05A-FILE.                                   
           IF NOT FCSBW05A-SUCCESSFUL                                   
              DISPLAY '0700-ERROR ON FCSBW05A OPEN.  STATUS IS '        
                           WS-FCSBW05A-STATUS                           
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           MOVE WS-RESTART-FBW05A-REC-CNTR TO WS-COUNT-FBW05A           
           PERFORM WS-RESTART-FBW05A-REC-CNTR TIMES                     
              READ FCSBW05R-FILE                                        
              IF FBW05R-SUCCESSFUL                                      
                 WRITE FIOBW05A-REC FROM FIOBW05R-REC                   
                 IF FCSBW05A-SUCCESSFUL                                 
                    CONTINUE                                            
                 ELSE                                                   
                    DISPLAY 'ERROR ON FCSBW05A REWRITE.  STATUS IS '    
                             WS-FCSBW05A-STATUS                         
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'PREMATURE EOF ON BW05A RESTART'               
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-PERFORM                                                  
                                                                        
           CLOSE FCSBW05A-FILE                                          
                 FCSBW05R-FILE.                                         
     *                                                                  
       0700-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   1000-PROCESS-EFM                                                      
      *       CONTROLS PROCESSING OF ALL METER OUTPUT RECORDS                   
      *       LOAD DATA FROM INPUT FILE, CONVERT DATES AND PROCESS METER        
      ******************************************************************        
       1000-PROCESS-EFM.                                                
      *                                                                         
           MOVE '1000'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           MOVE E-FBW05-DATE-READ          TO WS-MTR-DATE-READ.         
           MOVE E-FBW05-TIME-READ          TO WS-MTR-TIME-READ.         
           MOVE E-FBW05-METER-VOL-TYPE     TO WS-MTR-VOL-TYPE           
                                              WS-METER-VOL-TYPE.        
      *                                                                         
           PERFORM 1100-EDIT-PARMS     THRU 1100-EXIT.                  
           IF PARM-IS-INVALID                                           
              ADD 1       TO WS-NO-OF-REJECT                            
              IF WS-NO-OF-REJECT > WS-RR-WQ-MTR-POST                    
                 DISPLAY 'METERS REJECTS EXCEEDS THRESHOLD'             
                 DISPLAY 'METERS REJECTED: ' WS-NO-OF-REJECT            
                 DISPLAY 'REJECT THRESHOLD: ' WS-RR-WQ-MTR-POST         
                 PERFORM 9900-ABEND         THRU 9900-EXIT              
              END-IF                                                    
              MOVE WS-METER-NO-NUM        TO MSG-METER-NO-SKIP          
              MOVE E-FBW05-ACCOUNT-NO     TO MSG-ACCT-NO-SKIP           
              MOVE MSG-METER-WAS-SKIPED   TO WS-WQ-MESSAGE              
C35804        IF (E-FBW05-ACCOUNT-NO NOT EQUAL WS-PREV-ACCT-NO)         
C35804           MOVE WS-METER-NO-NUM     TO WS-PREV-METER-NO           
C35804           MOVE E-FBW05-ACCOUNT-NO  TO AT-ACCOUNT-NO              
C35804           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT             
C35804           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
C35804              MOVE ZERO             TO AT-ACCOUNT-NO              
C35804              MOVE ZERO             TO AT-PREMISE-NO              
C35804              MOVE ZERO             TO AT-CUSTOMER-NO             
C35804              MOVE ZERO             TO AT-LOCAL-OFFICE            
C35804              MOVE '01'             TO AT-COMPANY-NO              
C35804           END-IF                                                 
C35804        END-IF                                                    
              PERFORM 5310-CREATE-WORKQ THRU 5310-EXIT                  
              MOVE 'Y'                    TO WS-WQ-FLAG                 
      *                                                                         
T29165        MOVE E-FBW05-ACCOUNT-NO     TO WS-PREV-ACCT-NO            
T29165        MOVE E-FBW05-METER-NO       TO WS-PREV-METER-NO           
              PERFORM 7400-READ-EFM-FILE THRU 7400-EXIT                 
                  UNTIL (E-FBW05-ACCOUNT-NO NOT EQUAL WS-PREV-ACCT-NO   
                     OR E-FBW05-METER-NO NOT EQUAL WS-PREV-METER-NO     
                     OR WS-END-OF-EFM-FILE EQUAL WS-YES)                
              SET SKIP-RECORD TO TRUE                                   
              GO TO 1000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW05-DATE-READ TO WS-CURR-DATE-READ                  
                                     WS-DATE-READ.                      
           MOVE E-FBW05-TIME-READ TO WS-TIME-READ-RED                   
                                     WS-CURR-TIME-READ.                 
                                                                        
C30010     IF WS-CURR-DATE-READ <  WS-GAS-EFF-DATE                      
C30010        MOVE WS-EFF-TIME-HH TO WS-END-TIME-HH                     
C30010     ELSE                                                         
C30010        MOVE WS-CUR-TIME-HH TO WS-END-TIME-HH                     
C30010     END-IF                                                       
           IF WS-TIME-READ-HH <= WS-END-TIME-HH                         
              PERFORM 7060-GET-PREV-DAY THRU 7060-EXIT                  
           END-IF.                                                      
      *                                                                         
           IF FIRST-RECORD                                              
              MOVE WS-NO TO WS-FIRST-RECORD                             
           ELSE                                                         
              IF (E-FBW05-ACCOUNT-NO  NOT EQUAL WS-PREV-ACCT-NO         
                 OR E-FBW05-METER-NO NOT EQUAL WS-PREV-METER-NO         
                 OR WS-CURR-DATE-READ NOT EQUAL WS-PREV-DATE-READ)      
                 AND NOT SKIP-RECORD AND NOT COPY-TO-OUTPUT             
                 AND NOT ACCT-SKIP-RECORD AND NOT MTR-SKIP-RECORD       
C37131           AND VALID-CONS                                         
                 PERFORM 2000-CREATE-CX THRU 2000-EXIT                  
                 IF WS-WQ-FLAG EQUAL WS-Y                               
                    MOVE WS-N  TO WS-WQ-FLAG                            
                 ELSE                                                   
                    DISPLAY 'PROCESSED METER NO:' WS-PREV-METER-NO      
                      ' SUCCESSFULLY. READ DATE:' WS-PREV-DATE-READ     
                 END-IF                                                 
                 MOVE ZEROES  TO WS-DAILY-VOLUME                        
                                 WS-DAILY-TEMP                          
                                 WS-DAILY-PRES                          
                 ADD 1        TO WS-CHKP-LUW-COUNTER                    
                 IF (WS-CHKP-LUW-COUNTER EQUAL WS-CHKP-LUW-LIMIT)       
                    OR (WS-CHKP-UPD-COUNTER  EQUAL WS-CHKP-UPD-LIMIT    
                    OR GREATER WS-CHKP-UPD-LIMIT)                       
                    PERFORM 8898-ISSUE-CHKP           THRU 8898-EXIT    
                 END-IF                                                 
                 IF WS-PRINT-COUNTERS = 'C'                             
                    PERFORM 8181-PRINT-COUNTERS       THRU 8181-EXIT    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF (E-FBW05-ACCOUNT-NO NOT EQUAL WS-PREV-ACCT-NO)            
              OR WS-THIS-IS-A-RESTART                                   
              MOVE WS-N                TO WS-SKIP-REC                   
                                          WS-ACCT-SKIP-REC              
                                          WS-MTR-SKIP-REC               
                                          WS-WQ-FLAG                    
                                          WS-COPY-DATA-FL               
              MOVE ZERO                TO WS-DAILY-VOLUME               
                                          WS-DAILY-PRES                 
                                          WS-DAILY-TEMP                 
              MOVE E-FBW05-ACCOUNT-NO  TO WS-PREV-ACCT-NO               
              MOVE E-FBW05-METER-NO    TO WS-PREV-METER-NO              
              MOVE WS-CURR-DATE-READ   TO WS-PREV-DATE-READ             
C30010        MOVE WS-CURR-TIME-READ   TO WS-PREV-TIME-READ             
              PERFORM 1200-PROCESS-ACCT-CHG  THRU 1200-EXIT             
              MOVE 'N'                 TO WS-IS-THIS-A-RESTART          
           ELSE                                                         
              IF E-FBW05-METER-NO NOT EQUAL WS-PREV-METER-NO            
                 MOVE WS-N             TO WS-SKIP-REC                   
                                          WS-MTR-SKIP-REC               
                                          WS-WQ-FLAG                    
                                          WS-COPY-DATA-FL               
                 MOVE ZERO             TO WS-DAILY-VOLUME               
                                          WS-DAILY-PRES                 
                                          WS-DAILY-TEMP                 
                 MOVE E-FBW05-METER-NO TO WS-PREV-METER-NO              
                                          MN-METER-NO                   
                 MOVE WS-CURR-DATE-READ TO WS-PREV-DATE-READ            
C30010           MOVE WS-CURR-TIME-READ TO WS-PREV-TIME-READ            
                 PERFORM 1300-PROCESS-METER-CHG THRU 1300-EXIT          
              ELSE                                                      
                 IF WS-CURR-DATE-READ NOT EQUAL WS-PREV-DATE-READ       
                    MOVE WS-N              TO WS-SKIP-REC               
                                              WS-WQ-FLAG                
                                              WS-COPY-DATA-FL           
C37423              MOVE ZERO              TO WS-DAILY-VOLUME           
C37423                                        WS-DAILY-PRES             
C37423                                        WS-DAILY-TEMP             
                    MOVE WS-CURR-DATE-READ TO WS-PREV-DATE-READ         
C30010              MOVE WS-CURR-TIME-READ TO WS-PREV-TIME-READ         
                    PERFORM 1400-PROCESS-DATE-READ-CHG THRU 1400-EXIT   
                 ELSE                                                   
                    IF WS-CURR-TIME-READ NOT EQUAL WS-PREV-TIME-READ    
                       MOVE WS-N           TO WS-SKIP-REC               
                                              WS-WQ-FLAG                
                                              WS-COPY-DATA-FL           
                       MOVE WS-CURR-TIME-READ TO WS-PREV-TIME-READ      
                       PERFORM 1500-PROCESS-READ-RECORD THRU 1500-EXIT  
                    ELSE                                                
                       MOVE MSG-MULTI-INTERVAL-ROWS  TO WS-WQ-MESSAGE   
                       SET MULTI-ROWS-ERROR          TO TRUE            
                       PERFORM 5310-CREATE-WORKQ THRU 5310-EXIT         
                       ADD 1                         TO WS-GAS-WORKQ    
                       SET SKIP-RECORD               TO TRUE            
                       MOVE SPACES                  TO WS-PREV-TIME-READ
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF SKIP-RECORD                                               
              PERFORM 7400-READ-EFM-FILE THRU 7400-EXIT                 
                     UNTIL E-FBW05-ACCOUNT-NO NOT EQUAL WS-PREV-ACCT-NO 
                     OR E-FBW05-METER-NO NOT EQUAL WS-PREV-METER-NO     
                     OR WS-CURR-DATE-READ NOT EQUAL WS-PREV-DATE-READ   
                     OR WS-END-OF-EFM-FILE EQUAL WS-YES                 
           ELSE                                                         
              IF  COPY-TO-OUTPUT                                        
                  PERFORM 1800-COPY-TO-OUTPUT THRU 1800-EXIT            
                     UNTIL E-FBW05-ACCOUNT-NO NOT EQUAL WS-PREV-ACCT-NO 
                     OR E-FBW05-METER-NO NOT EQUAL WS-PREV-METER-NO     
                     OR WS-CURR-DATE-READ NOT EQUAL WS-PREV-DATE-READ   
                     OR WS-END-OF-EFM-FILE EQUAL WS-YES                 
              ELSE                                                      
                 IF ACCT-SKIP-RECORD                                    
                    PERFORM 7400-READ-EFM-FILE THRU 7400-EXIT           
                      UNTIL E-FBW05-ACCOUNT-NO NOT EQUAL WS-PREV-ACCT-NO
                            OR WS-END-OF-EFM-FILE EQUAL WS-YES          
                 ELSE                                                   
                    IF MTR-SKIP-RECORD                                  
                      PERFORM 7400-READ-EFM-FILE THRU 7400-EXIT         
                      UNTIL E-FBW05-ACCOUNT-NO NOT EQUAL WS-PREV-ACCT-NO
                          OR E-FBW05-METER-NO NOT EQUAL WS-PREV-METER-NO
                          OR WS-END-OF-EFM-FILE EQUAL WS-YES            
                    ELSE                                                
                       PERFORM 7400-READ-EFM-FILE THRU 7400-EXIT        
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1100-EDIT-PARMS                                                *        
      *                                                                *        
      *     VALIDATE THE INPUT PARAMETERS.                             *        
      ******************************************************************        
       1100-EDIT-PARMS.                                                 
      *                                                                         
           MOVE '1100'               TO ACTIVE-PARAGRAPH.               
           SET PARM-IS-VALID         TO TRUE.                           
           ADD 1                     TO WS-COUNT-METER.                 
      *                                                                         
           INSPECT E-FBW05-METER-NO REPLACING LEADING ' ' BY '0'.       
           MOVE E-FBW05-METER-NO TO WS-MTR-NO                           
                                    WS-METER-NO.                        
      *                                                                         
           MOVE E-FBW05-METER-VOLUME      TO WS-METER-VOLUME-RED.       
           IF WS-METER-VOL-NUM IS NUMERIC                               
              AND WS-METER-VOL-DEC IS NUMERIC                           
              COMPUTE WS-MTR-VOL =                                      
                   (WS-METER-VOL-NUM + WS-METER-VOL-DEC / 100)          
           ELSE                                                         
              SET PARM-IS-INVALID       TO TRUE                         
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW05-METER-PRESSURE    TO WS-METER-PRESSURE-RED.     
           IF WS-METER-PRE-NUM IS NUMERIC                               
              AND WS-METER-PRE-DEC IS NUMERIC                           
              COMPUTE WS-MTR-PRE =                                      
                   (WS-METER-PRE-NUM + WS-METER-PRE-DEC / 100)          
           ELSE                                                         
              SET PARM-IS-INVALID         TO TRUE                       
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW05-METER-TEMP        TO WS-METER-TEMP-RED.         
           IF WS-METER-TMP-NUM IS NUMERIC                               
              AND WS-METER-TMP-DEC IS NUMERIC                           
              COMPUTE WS-MTR-TMP =                                      
                   (WS-METER-TMP-NUM + WS-METER-TMP-DEC / 100)          
           ELSE                                                         
              SET PARM-IS-INVALID         TO TRUE                       
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
           INSPECT E-FBW05-ACCOUNT-NO REPLACING ALL ' ' BY '0'.         
           MOVE E-FBW05-ACCOUNT-NO      TO WS-ACCT-NO.                  
           IF WS-ACCT-NO-RED IS NUMERIC                                 
              IF WS-ACCT-NO-RED > 0                                     
                 MOVE WS-ACCT-NO-RED    TO WS-ACCOUNT-NO                
              ELSE                                                      
                 SET PARM-IS-INVALID    TO TRUE                         
                 GO TO 1100-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              MOVE ZEROS    TO WS-ACCOUNT-NO                            
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *----------------------*                                                  
       1200-PROCESS-ACCT-CHG.                                           
      *----------------------*                                                  
           MOVE WS-PREV-ACCT-NO TO AT-ACCOUNT-NO.                       
           SET ACCT-ACTIVE TO TRUE.                                     
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE AT-ACCOUNT-NO         TO XR-OLD-ACCOUNT-NO           
              PERFORM 7050-XREF-ACCT-CYCLE THRU 7050-EXIT               
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE XR-OLD-ACCOUNT-NO  TO MSG-ACCOUNT-NO              
                 MOVE WS-PREV-METER-NO   TO MSG-MTR-NO                  
                 MOVE MSG-ACCOUNT-NO-NOT-FOUND                          
                                         TO WS-WQ-MESSAGE               
                 MOVE ZERO               TO AT-ACCOUNT-NO               
                 MOVE ZERO               TO AT-PREMISE-NO               
                 MOVE ZERO               TO AT-CUSTOMER-NO              
                 MOVE ZERO               TO AT-LOCAL-OFFICE             
                 MOVE '01'               TO AT-COMPANY-NO               
                 PERFORM 5310-CREATE-WORKQ THRU 5310-EXIT               
                 ADD 1                   TO WS-GAS-WORKQ                
                 SET ACCT-SKIP-RECORD TO TRUE                           
                 MOVE 'Y'                TO WS-WQ-FLAG                  
                 GO TO 1200-EXIT                                        
              END-IF                                                    
           END-IF                                                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-COMPANY-NO    TO WS-COMPANY-NO                    
              IF AT-CODE-ACCT-STAT NOT EQUAL WS-A                       
                  SET ACCT-INACTIVE TO TRUE                             
              END-IF                                                    
              MOVE WS-PREV-METER-NO TO MN-METER-NO                      
              PERFORM 1300-PROCESS-METER-CHG THRU 1300-EXIT             
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *-----------------------*                                                 
       1300-PROCESS-METER-CHG.                                          
      *-----------------------*                                                 
      *                                                                         
           SET MTR-ACTIVE     TO TRUE.                                  
           SET METER-UNCHANGE TO TRUE.                                  
C28742     MOVE SPACES                     TO MN-LAST-REG-READ-DATE     
C28742                                        MN-LAST-REG-READ-TIME     
C28742                                        MN-CODE-LAST-REG-READ.    
           PERFORM 7100-GET-METER-INFO THRU 7100-EXIT                   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF MN-CODE-METER-STATUS EQUAL 'J'                         
                 SET MTR-INACTIVE TO TRUE                               
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 PERFORM 7250-GET-MTR-CHG THRU 7250-EXIT                
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    MOVE AT-ACCOUNT-NO  TO MN-ACCOUNT-NO                
                    MOVE WS-UTIL-TYPE   TO MN-CODE-UTIL-TYPE            
                    MOVE CX-IC-NO       TO MN-IC-NO                     
                    MOVE CX-MTR-REF-NO  TO MN-MTR-REF-NO                
                    MOVE CX-DATE-READ   TO WS-EXCHG-DATE-READ           
                    IF WS-CURR-DATE-READ < WS-EXCHG-DATE-READ           
                       CONTINUE                                         
                    ELSE                                                
                       SET METER-CHANGE TO TRUE                         
                    END-IF                                              
                 END-IF                                                 
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    OR METER-CHANGE                                     
                    MOVE WS-MTR-NO              TO MSG-METER-NO         
                    MOVE WS-ACCT-NO             TO MSG-ACCT-NO          
                    MOVE MSG-ACCT-MTR-COMB-NOT-FOUND TO WS-WQ-MESSAGE   
                    PERFORM 5310-CREATE-WORKQ THRU 5310-EXIT            
                    ADD 1                       TO WS-GAS-WORKQ         
                    MOVE 'Y'                    TO WS-WQ-FLAG           
                    SET MTR-SKIP-RECORD             TO TRUE             
                    GO TO 1300-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE AT-PREMISE-NO TO PR-PREMISE-NO.                         
           PERFORM 7075-GET-PREMISE THRU 7075-EXIT.                     
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE MSG-NO-PREMISE     TO WS-WQ-MESSAGE                  
              PERFORM 5310-CREATE-WORKQ THRU 5310-EXIT                  
              ADD 1                   TO WS-GAS-WORKQ                   
              SET SKIP-RECORD         TO TRUE                           
           END-IF.                                                      
           PERFORM 7200-GET-CODE-MTR-TYPE THRU 7200-EXIT.               
           PERFORM 1400-PROCESS-DATE-READ-CHG THRU 1400-EXIT.           
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *-----------------------*                                                 
31870  1350-FIX-METER-NUMBER.                                           
      *-----------------------*                                                 
      *                                                                         
31870      IF E-FBW05-METER-NO = 999999999                              
31870         CONTINUE                                                  
31870      ELSE                                                         
31870         IF E-FBW05-METER-NO(1:3) = 999                            
31870            MOVE 000 TO E-FBW05-METER-NO(1:3)                      
31870         END-IF                                                    
31870      END-IF.                                                      
      *                                                                         
31870  1350-EXIT.                                                       
31870      EXIT.                                                        
      *                                                                         
      *---------------------------*                                             
       1400-PROCESS-DATE-READ-CHG.                                      
      *---------------------------*                                             
      *                                                                         
           MOVE MN-CODE-UTIL-TYPE     TO BK-CODE-UTIL-TYPE.             
           MOVE MN-ACCOUNT-NO         TO BK-ACCOUNT-NO.                 
           MOVE MN-IC-NO              TO BK-IC-NO.                      
           MOVE 'N'                   TO WS-BILL-CNTRCT-FL              
                                         WS-BK-CRSR-FL.                 
           PERFORM 7950-OPEN-BILL-CNTRCT-CRSR   THRU 7950-EXIT.         
           PERFORM 7960-FETCH-BILL-CNTRCT-CRSR  THRU 7960-EXIT          
                         UNTIL VALID-CNTRCT OR END-OF-BK-CRSR.          
           PERFORM 7970-CLOSE-BILL-CNTRCT-CRSR  THRU 7970-EXIT.         
                                                                        
           IF VALID-CNTRCT                                              
              CONTINUE                                                  
           ELSE                                                         
              SET CNTRCT-ERRMSG             TO TRUE                     
              MOVE WS-DATE-READ             TO MSG-CNTRCT-DT            
              MOVE MSG-NOT-VALID-CNTRCT     TO WS-WQ-MESSAGE            
              PERFORM 5310-CREATE-WORKQ THRU 5310-EXIT                  
              ADD 1                   TO WS-GAS-WORKQ                   
              SET SKIP-RECORD         TO TRUE                           
           END-IF.                                                      
      *                                                                         
36423      PERFORM 7300-GET-REV-MTH THRU 7300-EXIT.                     
36423      MOVE AT-ACCOUNT-NO    TO BG-ACCOUNT-NO.                      
36423      MOVE WS-UTIL-TYPE     TO BG-CODE-UTIL-TYPE.                  
36423      MOVE MN-IC-NO         TO BG-IC-NO                            
36423                               WS-IC-NO.                           
      *                                                                         
C37131     SET VALID-CONS TO TRUE.                                      
           PERFORM 1600-GET-REV-MONTH THRU 1600-EXIT.                   
      *                                                                         
           IF SKIP-RECORD OR COPY-TO-OUTPUT                             
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 1700-GET-BTU-GRAVITY     THRU 1700-EXIT           
              PERFORM 1500-PROCESS-READ-RECORD THRU 1500-EXIT           
           END-IF.                                                      
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *-------------------------*                                               
       1500-PROCESS-READ-RECORD.                                        
      *-------------------------*                                               
           COMPUTE IV-CHANNEL-A-PULSES = WS-MTR-VOL * 100               
           COMPUTE IV-CHANNEL-B-PULSES = WS-MTR-PRE * 100               
           COMPUTE IV-CHANNEL-C-PULSES = WS-MTR-TMP * 100               
      *                                                                         
           MOVE WS-UTIL-TYPE          TO IV-CODE-UTIL-TYPE              
           MOVE WS-MTR-NO             TO IV-METER-NO                    
           MOVE WS-MTR-DATE-READ      TO IV-DATE-READ                   
           MOVE WS-MTR-TIME-READ      TO IV-TIME-READ                   
           MOVE 'N'                   TO IV-DST-CHNG-IND                
           MOVE WS-MTR-VOL-TYPE       TO IV-CHANNEL-A-STATUS            
           MOVE SPACES                TO IV-CHANNEL-B-STATUS            
                                         IV-CHANNEL-C-STATUS.           
           MOVE BG-BILL-ITEM-TIMESTMP TO IV-BILL-ITEM-TIMESTMP.         
           IF ACCT-INACTIVE OR MTR-INACTIVE                             
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 8000-ISRT-INTERVAL-READ THRU 8000-EXIT            
              IF WS-ACTIVE-RETURN-CODE EQUAL ALREADY-EXISTS             
                 PERFORM 8050-UPDT-INTERVAL-READ THRU 8050-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           COMPUTE WS-DAILY-VOLUME = WS-DAILY-VOLUME + WS-MTR-VOL.      
           COMPUTE WS-DAILY-PRES   = WS-DAILY-PRES   + WS-MTR-PRE.      
           COMPUTE WS-DAILY-TEMP   = WS-DAILY-TEMP   + WS-MTR-TMP.      
      *---------------------------------------------------------------*         
      * VOLUME TYPES: L - EFM ESTIMATE; R - TEST GAS; V - BYPASS GAS  *         
      * M - TEMP ADJ; N - DIFF. ADJ; P - PRE ADJ; U - MANUAL ADJ      *         
      *---------------------------------------------------------------*         
           IF WS-MTR-VOL-TYPE EQUAL 'L' OR 'R' OR 'V' OR 'U' OR 'N'     
                                     OR 'P' OR 'M'                      
              MOVE 'L'  TO WS-CODE-METER-READ                           
      */ L - READER ESTIMATE IN CIS*/                                           
           ELSE                                                         
              MOVE WS-MTR-VOL-TYPE  TO WS-CODE-METER-READ               
           END-IF.                                                      
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *-------------------*                                                     
       1600-GET-REV-MONTH.                                              
      *-------------------*                                                     
      *                                                                         
HONK       MOVE 'N' TO WS-NO-MORE-BG-SW.                                
      *                                                                         
37554      MOVE RW-REVENUE-MONTH TO BG-REV-MTH-ORIG-BILL.               
      *                                                                         
36423      IF RW-REVENUE-MONTH > WS-REVENUE-MONTH                       
36423         SET COPY-TO-OUTPUT TO TRUE                                
36423      ELSE                                                         
36423         PERFORM 7120-SELECT-BILL THRU 7120-EXIT                   
36423         IF WS-NO-MORE-BG-SW = 'Y'                                 
36423            PERFORM 5000-GET-FUTURE-BILL-HOOK THRU 5000-EXIT       
A00633        END-IF                                                    
36423         IF RW-REVENUE-MONTH <= AT-REV-MTH-LST-NRML                
A00633          AND RW-REVENUE-MONTH NOT = BG-REV-MTH-ORIG-BILL         
C37131           MOVE WS-PREV-METER-NO  TO MSG-MTR-NUM                  
36423            MOVE MSG-FUTURE-BILL-HOOK TO WS-WQ-MESSAGE             
36423            PERFORM 5310-CREATE-WORKQ THRU 5310-EXIT               
36423            ADD 1    TO WS-GAS-WORKQ                               
36423            MOVE 'Y' TO WS-WQ-FLAG                                 
C37131           SET INVALID-CONS TO TRUE                               
36423         END-IF                                                    
36423      END-IF.                                                      
      *                                                                         
       1600-EXIT.                                                       
           EXIT.                                                        
      *---------------------*                                                   
       1700-GET-BTU-GRAVITY.                                            
      *---------------------*                                                   
           MOVE ZERO                     TO WS-AVG-BTU-FACTOR           
                                            WS-AVG-SP-GRAVITY.          
           MOVE WS-PREV-DATE-READ        TO FE-BTU-DT.                  
           MOVE MN-INDUST-BTU-ID         TO FE-INDUST-BTU-ID.           
           IF FE-INDUST-BTU-ID > SPACES                                 
              PERFORM 7350-SELECT-BTU-GRAVITY THRU 7350-EXIT            
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-MTR-DATE-READ(6:2) TO WS-DATE-READ-MM          
                 MOVE WS-MTR-DATE-READ(1:4) TO WS-DATE-READ-YY          
                 MOVE WS-DATE-READ-MM-RED   TO WS-BTU-DT-MM             
                 MOVE WS-DATE-READ-YY-RED   TO WS-BTU-DT-YY             
                 PERFORM 7375-ESTIMATE-BTU-GRAVITY THRU 7375-EXIT       
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                   COMPUTE WS-DATE-READ-MM-RED = WS-DATE-READ-MM-RED - 1
                    IF WS-DATE-READ-MM-RED EQUAL 0                      
                       MOVE 12 TO WS-DATE-READ-MM-RED                   
                       COMPUTE WS-DATE-READ-YY-RED =                    
                                           WS-DATE-READ-YY-RED - 1      
                    END-IF                                              
                    MOVE WS-DATE-READ-MM-RED   TO WS-BTU-DT-MM          
                    MOVE WS-DATE-READ-YY-RED   TO WS-BTU-DT-YY          
                    PERFORM 7375-ESTIMATE-BTU-GRAVITY THRU 7375-EXIT    
                 END-IF                                                 
                 IF WS-SUM-CNT > 0                                      
                    COMPUTE WS-AVG-BTU-FACTOR =                         
                               WS-SUM-BTU-FACTOR / WS-SUM-CNT           
                    COMPUTE WS-AVG-SP-GRAVITY =                         
                                 WS-SUM-SP-GRAVITY / WS-SUM-CNT         
                 ELSE                                                   
                    MOVE 0   TO WS-AVG-BTU-FACTOR                       
                                WS-AVG-SP-GRAVITY                       
                 END-IF                                                 
              ELSE                                                      
                 MOVE FE-BTU-FACTOR       TO WS-AVG-BTU-FACTOR          
                 MOVE FE-SPECIFIC-GRAVITY TO WS-AVG-SP-GRAVITY          
              END-IF                                                    
           ELSE                                                         
              MOVE WS-PREV-METER-NO       TO MSG-MN-MTR-NO              
              MOVE MSG-INDUST-BTU         TO WS-WQ-MESSAGE              
              PERFORM 5310-CREATE-WORKQ THRU 5310-EXIT                  
              ADD 1                       TO WS-GAS-WORKQ               
              MOVE 0                      TO WS-AVG-BTU-FACTOR          
                                             WS-AVG-SP-GRAVITY          
           END-IF.                                                      
           MOVE WS-AVG-BTU-FACTOR TO FE-BTU-FACTOR.                     
           MOVE WS-AVG-SP-GRAVITY TO FE-SPECIFIC-GRAVITY.               
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *--------------------*                                                    
       1800-COPY-TO-OUTPUT.                                             
      *--------------------*                                                    
           MOVE FIOBW05-REC                TO FIOBW05A-REC.             
           WRITE FIOBW05A-REC.                                          
                                                                        
           IF FCSBW05A-SUCCESSFUL                                       
              ADD 1                      TO WS-COUNT-FBW05A             
              ADD 1                      TO WS-RESTART-FBW05A-REC-CNTR  
           ELSE                                                         
               DISPLAY '1800-ERROR ON FCSBW05A WRITE.  STATUS IS '      
                        WS-FCSBW05A-STATUS                              
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 7400-READ-EFM-FILE THRU 7400-EXIT.                   
      *                                                                         
           MOVE E-FBW05-DATE-READ TO WS-CURR-DATE-READ.                 
           MOVE E-FBW05-TIME-READ TO WS-TIME-READ-RED.                  
C30010     IF WS-CURR-DATE-READ <  WS-GAS-EFF-DATE                      
C30010        MOVE WS-EFF-TIME-HH TO WS-END-TIME-HH                     
C30010     ELSE                                                         
C30010        MOVE WS-CUR-TIME-HH TO WS-END-TIME-HH                     
C30010     END-IF                                                       
           IF WS-TIME-READ-HH <= WS-END-TIME-HH                         
              PERFORM 7060-GET-PREV-DAY THRU 7060-EXIT                  
           END-IF.                                                      
      *                                                                         
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *---------------*                                                         
       2000-CREATE-CX.                                                  
      *---------------*                                                         
           MOVE ZERO               TO WS-CX-NO-UNITS                    
                                      WS-DAILY-VOL.                     
           COMPUTE WS-DAILY-VOL ROUNDED   = WS-DAILY-VOLUME * 1.        
A04700     COMPUTE WS-CX-NO-UNITS ROUNDED = WS-DAILY-VOL * 10.          
           IF ORIFICE-METER AND FE-SPECIFIC-GRAVITY > 0                 
              PERFORM 3000-CALC-FPV-FACTOR THRU 3000-EXIT               
              MOVE FE-SPECIFIC-GRAVITY TO CX-CONSTANT                   
           ELSE                                                         
A04700        MOVE WS-CX-NO-UNITS TO CX-NO-UNITS                        
              MOVE 1 TO CX-CONSTANT                                     
           END-IF.                                                      
                                                                        
           MOVE CX-NO-UNITS        TO WS-NO-UNITS                       
                                      WS-WQ-NO-UNITS-R.                 
           IF CX-NO-UNITS > 0 AND (ACCT-INACTIVE OR MTR-INACTIVE)       
              STRING MSG-INACT-METER-HAS-USE                            
                    'CURR VOL.'                                         
                    WS-WQ-NO-UNITS                                      
                    '; METER NO.'                                       
                    WS-PREV-METER-NO                                    
              DELIMITED BY SIZE                                         
                    INTO WS-WQ-MESSAGE                                  
              PERFORM 5310-CREATE-WORKQ THRU 5310-EXIT                  
              ADD 1                       TO WS-GAS-WORKQ               
              MOVE 'Y'                    TO WS-WQ-FLAG                 
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE BG-ACCOUNT-NO     TO CX-ACCOUNT-NO.                     
           MOVE BG-BILL-NO        TO CX-BILL-NO.                        
           MOVE BG-CODE-UTIL-TYPE TO CX-CODE-UTIL-TYPE.                 
           MOVE BG-IC-NO          TO CX-IC-NO                           
C28742                               MN-IC-NO.                          
           MOVE BG-BILL-ITEM-TIMESTMP TO CX-BILL-ITEM-TIMESTMP.         
           MOVE ZEROS             TO CX-CODE-TIME-PERIOD.               
           MOVE MN-MTR-REF-NO     TO CX-MTR-REF-NO.                     
           MOVE MN-REG-ID-NO      TO CX-REG-ID-NO.                      
                                                                        
           PERFORM 7500-CXROW-EXISTS THRU 7500-EXIT.                    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE 'Y'  TO WS-ROW-EXISTS                                
              IF CANCEL-REBILL                                          
                 CONTINUE                                               
              ELSE                                                      
                 IF CX-CODE-METER-READ EQUAL WS-Y                       
                    GO TO 2000-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
      * HI/LO CONDITION CHECK FOR MIN/MAX DAILY VOLUMES                         
           MOVE UT-CODE-UTIL-TYPE TO O9-CODE-UTIL-TYPE.                 
           MOVE UT-RATE-PLAN-NO   TO O9-RATE-PLAN-NO.                   
           PERFORM 7850-SELECT-RATE-HILO THRU 7850-EXIT.                
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 1.25  TO O9-USAGE-HIGH-PCT                           
              MOVE 0.75  TO O9-USAGE-LOW-PCT                            
           END-IF.                                                      
           MOVE MN-MIN-NO-UNITS  TO WS-WQ-MN-UNITS-R.                   
           MOVE O9-USAGE-LOW-PCT TO WS-WQ-USAGE-PCT-R                   
                                    MSG-LOW-PCT-R.                      
           IF CX-NO-UNITS < (MN-MIN-NO-UNITS * O9-USAGE-LOW-PCT)        
              STRING MSG-DAILY-VOL-LESS-25                              
                    'CURR VOL:'                                         
                    WS-WQ-NO-UNITS                                      
                    ' CCF;HIST MIN VOL:'                                
                    WS-WQ-MN-UNITS                                      
                    ' CCF'                                              
              DELIMITED BY SIZE                                         
                    INTO WS-WQ-MESSAGE                                  
              SET WS-METER-WARNING        TO TRUE                       
              PERFORM 5310-CREATE-WORKQ THRU 5310-EXIT                  
              ADD 1                       TO WS-GAS-WORKQ               
           END-IF.                                                      
           MOVE MN-MAX-NO-UNITS   TO WS-WQ-MN-UNITS-R.                  
           MOVE O9-USAGE-HIGH-PCT TO WS-WQ-USAGE-PCT-R                  
                                     MSG-HIGH-PCT-R.                    
           IF CX-NO-UNITS > (MN-MAX-NO-UNITS * O9-USAGE-HIGH-PCT)       
              STRING MSG-DAILY-VOL-MORE-25                              
                    'CURR VOL:'                                         
                    WS-WQ-NO-UNITS                                      
                    ' CCF;HIST MAX VOL:'                                
                    WS-WQ-MN-UNITS                                      
                    ' CCF'                                              
              DELIMITED BY SIZE                                         
                    INTO WS-WQ-MESSAGE                                  
              SET WS-METER-WARNING        TO TRUE                       
              PERFORM 5310-CREATE-WORKQ THRU 5310-EXIT                  
              ADD 1                       TO WS-GAS-WORKQ               
           END-IF.                                                      
           IF CX-NO-UNITS > MN-MAX-NO-UNITS                             
              MOVE CX-NO-UNITS TO MN-MAX-NO-UNITS                       
           END-IF.                                                      
           IF CX-NO-UNITS < MN-MIN-NO-UNITS                             
              MOVE CX-NO-UNITS TO MN-MIN-NO-UNITS                       
           END-IF.                                                      
      *                                                                         
           MOVE WS-PREV-METER-NO  TO MN-METER-NO.                       
C28742     MOVE WS-CODE-METER-READ         TO WS-MN-READ-CODE.          
C28742     MOVE WS-PREV-DATE-READ          TO WS-MN-READ-DATE.          
C28742     MOVE WS-PREV-TIME-READ          TO WS-TIME-READ-RED          
C28742                                        WS-MN-READ-TIME.          
C30010     IF WS-MN-READ-DATE  <  WS-GAS-EFF-DATE                       
C30010        MOVE WS-EFF-TIME-HH TO WS-END-TIME-HH                     
C30010     ELSE                                                         
C30010        MOVE WS-CUR-TIME-HH TO WS-END-TIME-HH                     
C30010     END-IF                                                       
C28742     IF WS-TIME-READ-HH <= WS-END-TIME-HH                         
C28742        PERFORM 7065-GET-NEXT-DAY THRU 7065-EXIT                  
C28742     END-IF.                                                      
C28742     IF WS-MN-READ-DATE >= MN-LAST-REG-READ-DATE                  
C28742        CONTINUE                                                  
C28742     ELSE                                                         
C28742        MOVE MN-LAST-REG-READ-DATE   TO WS-MN-READ-DATE           
C28742        MOVE MN-LAST-REG-READ-TIME   TO WS-MN-READ-TIME           
C28742        MOVE MN-CODE-LAST-REG-READ   TO WS-MN-READ-CODE           
C28742     END-IF.                                                      
C28742*                                                                         
           PERFORM 8100-UPDATE-MTRD-ENV THRU 8100-EXIT.                 
                                                                        
      * INSERT/UPDATE INDUST_BTU_ID DETAILS IN MTR_IDENT_HIST TABLE             
           PERFORM 2500-PROCESS-MTR-IDENT-HIST THRU 2500-EXIT.          
                                                                        
           MOVE WS-CODE-METER-READ     TO CX-CODE-METER-READ.           
           MOVE MN-METER-NO            TO CX-METER-NO.                  
           MOVE WS-PREV-DATE-READ      TO CX-DATE-READ.                 
           MOVE FE-BTU-FACTOR          TO CX-BTU-FACTOR.                
           IF WS-ROW-EXISTS EQUAL WS-Y                                  
              PERFORM 8350-UPDT-CX-NO-UNITS THRU 8350-EXIT              
A02906        PERFORM 2100-PROCESS-SUB-METER THRU 2100-EXIT             
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
      * POPULATE CX FIELDS FOR NEW ROW.                                         
           MOVE MN-CODE-USAGE-TYPE     TO CX-CODE-USAGE-TYPE.           
           MOVE MN-CODE-USAGE-ID       TO CX-CODE-USAGE-ID.             
           MOVE MN-CODE-USAGE-SOURCE   TO CX-CODE-USAGE-SOURCE.         
           MOVE SPACES                 TO CX-CODE-METER-NO-READ.        
           MOVE AT-COMPANY-NO          TO CX-COMPANY-NO                 
           MOVE 0                      TO CX-EMPLOYEE-NO.               
           MOVE ZEROES                 TO CX-METER-READING              
                                          CX-DEMAND-READING             
                                          CX-NO-DEMAND-UNITS.           
           MOVE MN-DIGTL-MTR-TYPE      TO CX-DIGTL-MTR-TYPE.            
           MOVE 1                      TO CX-NO-DAYS.                   
           MOVE 'S'                    TO CX-CODE-SOURCE-ID.            
           IF MN-CODE-USAGE-SOURCE EQUAL 'J' OR 'U'                     
              MOVE WS-CREDIT           TO CX-CODE-DEBIT-CREDIT          
           ELSE                                                         
              MOVE WS-DEBIT            TO CX-CODE-DEBIT-CREDIT          
           END-IF.                                                      
           MOVE MN-CODE-METER-STATUS   TO CX-CODE-ITEM-STATUS.          
           MOVE MN-CODE-DISCOUNT       TO CX-CODE-DISCOUNT.             
           MOVE 6                      TO CX-NO-DIALS.                  
           MOVE 'S'                    TO CX-MTR-READ-SOURCE-CD.        
           MOVE WS-CURRENT             TO CX-CODE-TOU-SEASN.            
           MOVE 'N'                    TO CX-EXCL-DMD-RCHT-IND.         
                                                                        
           PERFORM 7700-GET-MAX-SEQNO THRU 7700-EXIT.                   
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE +0001               TO CX-ITEM-SEQ-NO                
           ELSE                                                         
              ADD  +0001               TO CX-ITEM-SEQ-NO                
           END-IF.                                                      
                                                                        
           PERFORM 8200-ISRT-CNSMPTN-HIST THRU 8200-EXIT.               
           IF WS-ACTIVE-RETURN-CODE EQUAL ALREADY-EXISTS                
C28742        PERFORM 8350-UPDT-CX-NO-UNITS THRU 8350-EXIT              
           END-IF.                                                      
      *                                                                         
A02906     PERFORM 2100-PROCESS-SUB-METER THRU 2100-EXIT                
           INITIALIZE WS-CODE-METER-READ.                               
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *---------------------------*                                             
C28742* CHECK FOR SUBTRACTIVE STATUS.                                           
      *---------------------------*                                             
      *                                                                         
C28742 2100-PROCESS-SUB-METER.                                          
      *                                                                         
C28742     MOVE MN-ACCOUNT-NO              TO UR-ACCOUNT-NO-DEP.        
C28742     MOVE MN-IC-NO                   TO UR-IC-NO-DEP.             
C28742     MOVE MN-CODE-UTIL-TYPE          TO UR-CODE-UTIL-TYPE-DEP     
C28742                                        BG-CODE-UTIL-TYPE.        
C28742     MOVE MN-MTR-REF-NO              TO UR-MTR-REF-NO-DEP.        
A02906     PERFORM 7026-GET-REBILL-REV-MONTH   THRU 7026-EXIT.          
A02906* FOR MASTER/DEPENDENT METER RELATIONSHIP START AND END DATES             
A02906     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02906        MOVE WS-REV-MTH-ORIG-BILL      TO WS-REV-MTH-ORIG-BILL-N  
A02906        MOVE WS-REV-MTH-ORIG-BILL-N(1:4) TO WS-DEP-REL-START-CCYY 
A02906                                            WS-DEP-REL-END-CCYY   
A02906        MOVE WS-REV-MTH-ORIG-BILL-N(5:2) TO WS-DEP-REL-START-MM   
A02906                                            WS-DEP-REL-END-MM     
A02906     ELSE                                                         
A02906        MOVE WS-REVENUE-MONTH(1:4)       TO WS-DEP-REL-START-CCYY 
A02906                                            WS-DEP-REL-END-CCYY   
A02906        MOVE WS-REVENUE-MONTH(5:2)       TO WS-DEP-REL-START-MM   
A02906                                            WS-DEP-REL-END-MM     
A02906     END-IF.                                                      
A02906     MOVE WS-DEP-REL-START-DT      TO UR-DEP-REL-START-DT.        
A02906     MOVE WS-DEP-REL-END-DT        TO UR-DEP-REL-END-DT.          
A02906     PERFORM 7900-OPEN-UTL-BILL-REL-CRSR  THRU 7900-EXIT.         
A02906     PERFORM 7910-FETCH-UTL-BILL-REL-CRSR THRU 7910-EXIT.         
A02906     PERFORM 2200-PROCESS-UTL-BILL-REL-CRSR THRU 2200-EXIT        
A02906                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.   
A02906     PERFORM 7920-CLOSE-UTL-BILL-REL-CRSR THRU 7920-EXIT.         
                                                                        
      *                                                                         
C28742 2100-EXIT.                                                       
C28742     EXIT.                                                        
      *                                                                         
A02906******************************************************************        
A02906* 2200-PROCESS-UTL-BILL-REL-CRSR.                                *        
A02906* PROCESS UTL_BILL_REL CURSOR.                                   *        
A02906******************************************************************        
A02906 2200-PROCESS-UTL-BILL-REL-CRSR.                                  
A02906*                                                                         
A02906     MOVE UR-ACCOUNT-NO-MST       TO CX-ACCOUNT-NO                
A02906                                     AT-ACCOUNT-NO                
A02906                                     BG-ACCOUNT-NO.               
A02906     MOVE WS-CREDIT               TO CX-CODE-DEBIT-CREDIT.        
A02906     MOVE UR-CODE-UTIL-TYPE-MST   TO CX-CODE-UTIL-TYPE.           
A02906     MOVE UR-IC-NO-MST            TO CX-IC-NO                     
A02906                                     WS-IC-NO                     
A02906                                     BG-IC-NO.                    
A02906     MOVE UR-MTR-REF-NO-MST       TO CX-MTR-REF-NO.               
A02906     MOVE WS-J                    TO CX-CODE-USAGE-SOURCE.        
A02906     PERFORM 7000-SELECT-ACCOUNT  THRU 7000-EXIT.                 
A02906     MOVE RW-REVENUE-MONTH        TO BG-REVENUE-MONTH.            
A02906*                                                                         
A02906     PERFORM 1600-GET-REV-MONTH THRU 1600-EXIT.                   
A02906*                                                                         
A02906     IF INVALID-CONS                                              
A02906        GO TO 2100-EXIT                                           
A02906     END-IF.                                                      
A02906*                                                                         
A02906     MOVE BG-BILL-ITEM-TIMESTMP   TO CX-BILL-ITEM-TIMESTMP.       
A02906     PERFORM 7750-SUBTRACT-CXROW THRU 7750-EXIT.                  
A02906     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02906        PERFORM 8300-UPDT-CNSMPTN-HIST THRU 8300-EXIT             
A02906     ELSE                                                         
A02906        PERFORM 7700-GET-MAX-SEQNO THRU 7700-EXIT                 
A02906        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
A02906           MOVE +0001             TO CX-ITEM-SEQ-NO               
A02906        ELSE                                                      
A02906           ADD  +0001             TO CX-ITEM-SEQ-NO               
A02906        END-IF                                                    
A02906        PERFORM 8200-ISRT-CNSMPTN-HIST THRU 8200-EXIT             
A02906     END-IF.                                                      
A02906     PERFORM 7910-FETCH-UTL-BILL-REL-CRSR THRU 7910-EXIT.         
A02906*                                                                         
A02906 2200-EXIT.                                                       
A02906     EXIT.                                                        
      *                                                                         
      *---------------------------*                                             
       2500-PROCESS-MTR-IDENT-HIST.                                     
      *---------------------------*                                             
           MOVE BG-ACCOUNT-NO         TO GA-ACCOUNT-NO.                 
           MOVE BG-BILL-NO            TO GA-BILL-NO.                    
           MOVE BG-CODE-UTIL-TYPE     TO GA-CODE-UTIL-TYPE.             
           MOVE BG-IC-NO              TO GA-IC-NO.                      
           MOVE BG-BILL-ITEM-TIMESTMP TO GA-BILL-ITEM-TIMESTMP.         
           MOVE MN-MTR-REF-NO         TO GA-MTR-REF-NO.                 
           MOVE MN-METER-NO           TO GA-METER-NO.                   
           MOVE MN-INDUST-BTU-ID      TO GA-INDUST-BTU-ID.              
           MOVE 1                     TO GA-INTERVALS-PER-HR.           
           MOVE WS-PREV-DATE-READ     TO GA-IDR-INFO-RETENT-DT.         
           MOVE SPACES                TO GA-IDR-IDENT-NO                
                                         GA-CHANNEL-A-UOM               
                                         GA-CHANNEL-B-UOM               
                                         GA-CHANNEL-C-UOM.              
           MOVE ZERO                  TO GA-CT-UPPER-RATIO              
                                         GA-PT-UPPER-RATIO              
                                         GA-CT-LOWER-RATIO              
                                         GA-PT-LOWER-RATIO.             
      *                                                                         
           PERFORM 8600-ISRT-MTR-IDENT-HIST THRU 8600-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL ALREADY-EXISTS                
C32481        IF CANCEL-REBILL                                          
C32481           CONTINUE                                               
C32481        ELSE                                                      
C32481          PERFORM 8650-UPDT-MTR-IDENT-HIST THRU 8650-EXIT         
C32481        END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *--------------------*                                                    
       3000-CALC-FPV-FACTOR.                                            
      *--------------------*                                                    
      *                                                                         
           INITIALIZE WS-SCSCA120-LINK-RECORD.                          
           MOVE ZEROS                     TO WS-AVG-PRES                
                                             WS-AVG-TEMP                
                                             WS-PRES-ROUND              
                                             WS-TEMP-ROUND.             
                                                                        
C30010     PERFORM 7061-GET-DAY-BEFORE-EFF THRU 7061-EXIT.              
C30010     IF WS-PREV-DATE-READ = WS-DAY-BEFORE-EFF                     
C30010        COMPUTE WS-PRES-ROUND ROUNDED = WS-DAILY-PRES / 26        
C30010        COMPUTE WS-TEMP-ROUND ROUNDED = WS-DAILY-TEMP / 26        
C30010     ELSE                                                         
C30010        COMPUTE WS-PRES-ROUND ROUNDED = WS-DAILY-PRES / 24        
C30010        COMPUTE WS-TEMP-ROUND ROUNDED = WS-DAILY-TEMP / 24        
C30010     END-IF                                                       
           COMPUTE WS-AVG-PRES ROUNDED = WS-PRES-ROUND * 1.             
           COMPUTE WS-AVG-TEMP ROUNDED = WS-TEMP-ROUND * 1.             
                                                                        
           MOVE WS-AVG-TEMP                TO WS-CA120-TEMPERATURE      
           MOVE WS-AVG-PRES                TO WS-CA120-GAUGE-PRESSURE   
           MOVE WS-CONSTANT                TO WS-CA120-SPECIFIC-GRAVITY 
                                                                        
           CALL 'SCSCA120' USING WS-SCSCA120-LINK-RECORD.               
           MOVE WS-CA120-FPV-FACTOR        TO WS-OLD-FPV-FACTOR.        
                                                                        
           MOVE FE-SPECIFIC-GRAVITY        TO WS-CA120-SPECIFIC-GRAVITY 
           CALL 'SCSCA120' USING WS-SCSCA120-LINK-RECORD.               
           MOVE WS-CA120-FPV-FACTOR        TO WS-NEW-FPV-FACTOR.        
                                                                        
           COMPUTE WS-ADJS-FACTOR ROUNDED =                             
                      ((WS-CONSTANT / FE-SPECIFIC-GRAVITY) ** 0.5).     
                                                                        
           COMPUTE CX-NO-UNITS ROUNDED = WS-CX-NO-UNITS *               
                   (WS-NEW-FPV-FACTOR / WS-OLD-FPV-FACTOR) *            
                   WS-ADJS-FACTOR.                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *--------------------------*                                              
       5000-GET-FUTURE-BILL-HOOK.                                       
      *--------------------------*                                              
           MOVE AT-ACCOUNT-NO  TO BI-ACCOUNT-NO.                        
           PERFORM 7230-OPEN-BILLING-HDR THRU 7230-EXIT.                
           PERFORM 7231-FETCH-BILLING-HDR THRU 7231-EXIT.               
           IF (WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND)                   
             OR (IND-DATE-BILLED NOT EQUAL WS-NEG-ONE)                  
             PERFORM 5030-LOAD-DATA-TO-UNBILLED THRU 5030-EXIT          
           END-IF.                                                      
           PERFORM 7232-CLOSE-BILLING-HDR THRU 7232-EXIT.               
           PERFORM 5050-VERIFY-BILLING-DET THRU 5050-EXIT.              
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *---------------------------*                                             
       5030-LOAD-DATA-TO-UNBILLED.                                      
      *---------------------------*                                             
           MOVE AT-ACCOUNT-NO                  TO BI-ACCOUNT-NO.        
           MOVE AT-PREMISE-NO                  TO BI-PREMISE-NO.        
           MOVE AT-CUSTOMER-NO                 TO BI-CUSTOMER-NO.       
           MOVE AT-COMPANY-NO                  TO BI-COMPANY-NO.        
           ADD WS-1                            TO AT-NXT-BILL-NO.       
           MOVE AT-NXT-BILL-NO                 TO BI-BILL-NO.           
           MOVE WS-NEG-ONE                     TO IND-DATE-BILLED.      
           MOVE WS-ACTIVE                      TO BI-CODE-BILL-STATUS   
                                                  BI-CODE-BILL-TYPE     
                                                  BI-CODE-BILL-REASON.  
           MOVE SPACES                         TO BI-CODE-SPCL-BILL.    
           PERFORM 8400-ISRT-BILLING-HDR    THRU 8400-EXIT.             
           PERFORM 8550-UPDATE-ACCOUNT      THRU 8550-EXIT.             
      *                                                                         
       5030-EXIT.                                                       
           EXIT.                                                        
      *------------------------*                                                
       5050-VERIFY-BILLING-DET.                                         
      *------------------------*                                                
           MOVE AT-ACCOUNT-NO      TO UT-ACCOUNT-NO.                    
           MOVE MN-CODE-UTIL-TYPE  TO UT-CODE-UTIL-TYPE.                
           MOVE WS-IC-NO           TO UT-IC-NO.                         
           PERFORM 7550-SELECT-UTIL-ENVRNMT THRU 7550-EXIT.             
      *                                                                         
           MOVE BI-ACCOUNT-NO                  TO BG-ACCOUNT-NO.        
           MOVE BI-PREMISE-NO                  TO BG-PREMISE-NO.        
           MOVE BI-BILL-NO                     TO BG-BILL-NO.           
           MOVE UT-CODE-UTIL-TYPE              TO BG-CODE-UTIL-TYPE.    
           MOVE UT-IC-NO                       TO BG-IC-NO.             
           MOVE WS-CURRENT                     TO BG-CODE-BILL-ITM-TYPE.
           MOVE UT-RATE-PLAN-NO                TO BG-RATE-PLAN-NO.      
           MOVE UT-CODE-REVENUE-CLASS          TO BG-CODE-REVENUE-CLASS.
      *                                                                         
           PERFORM 7240-OPEN-BILLING-DET       THRU 7240-EXIT.          
           PERFORM 7241-FETCH-BILLING-DET      THRU 7241-EXIT.          
           MOVE WS-ACTIVE                      TO BG-CODE-BILL-ITM-IND  
                                                  BG-CODE-BILL-CALC.    
           MOVE WS-DEBIT                       TO BG-CODE-DR-CR-CNSMPTN.
           MOVE ZEROS                          TO BG-REV-MTH-ORIG-BILL. 
           MOVE UT-RATE-PLAN-NO                TO BG-RATE-PLAN-NO.      
           MOVE UT-CODE-REVENUE-CLASS          TO BG-CODE-REVENUE-CLASS.
           MOVE UT-CODE-SIC-NO                 TO BG-CODE-SIC-NO.       
           MOVE UT-CODE-CURTAIL-PRTY           TO BG-CODE-CURTAIL-PRTY. 
           MOVE WS-NEG-ONE                     TO IND-DATE-ORIG-BILL.   
           MOVE ZEROES                         TO BG-AMT-BILL-ITEM      
                                                  BG-AMT-STATE-TAX      
                                                  BG-AMT-CITY-TAX       
                                                  BG-AMT-OTHER-TAX.     
           MOVE UT-COMPANY-NO                  TO BG-COMPANY-NO.        
           MOVE UT-CODE-STAT-TAX-XMT           TO BG-CODE-STAT-TAX-XMT. 
           MOVE UT-CODE-CITY-TAX-XMT           TO BG-CODE-CITY-TAX-XMT. 
           MOVE UT-CODE-OTHR-TAX-XMT           TO BG-CODE-OTHR-TAX-XMT. 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 7242-CLOSE-BILLING-DET      THRU 7242-EXIT        
              GO TO 5050-EXIT                                           
           ELSE                                                         
              PERFORM 7450-SELECT-TIMESTAMP    THRU 7450-EXIT           
              MOVE WS-TIMESTMP-FROM-DB2-CALL   TO BG-BILL-ITEM-TIMESTMP 
              MOVE PR-REV-DISTRICT-CD          TO BG-REV-DISTRICT-CD    
              PERFORM 8500-INSERT-BILLING-DET THRU 8500-EXIT            
           END-IF.                                                      
           PERFORM 7242-CLOSE-BILLING-DET      THRU 7242-EXIT.          
      *                                                                         
       5050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    5310-CREATE-WORKQ                                          *         
      *****************************************************************         
       5310-CREATE-WORKQ.                                               
      *                                                                         
A04860     MOVE WS-CATEGORY-ID-276  TO WS-77-CATEGORY-ID                
A04860     MOVE '4'                 TO WS-77-ROUTE-CATEGORY.            
A04860     MOVE SPACES              TO WS-77-RESP-AREA-ID.              
A04860     MOVE WS-RUN-DATE         TO WS-CURR-DATE-TS.                 
A04860     MOVE WS-CURR-TS          TO WS-77-DATE-CREATED               
A04860                                 WS-77-DATE-REQUIRED.             
A04860     MOVE ZEROS               TO WS-77-SERV-ORDER-NO.             
A04860     MOVE AT-ACCOUNT-NO       TO WS-77-ACCOUNT-NO.                
A04860     MOVE AT-PREMISE-NO       TO WS-77-PREMISE-NO.                
A04860     MOVE AT-CUSTOMER-NO      TO WS-77-CUSTOMER-NO.               
A04860     MOVE AT-LOCAL-OFFICE     TO WS-77-LOCAL-OFFICE.              
A04860     MOVE WS-NORMAL-PRIORITY  TO WS-77-PRIORITY.                  
           MOVE WS-PREV-METER-NO    TO WS-WQ-ERROR-METER-NO.            
                                                                        
           IF PARM-IS-INVALID                                           
              STRING WS-WQ-MESSAGE                                      
                     ';READ DATE='                                      
                     WS-DATE-READ                                       
                     ';READ TIME='                                      
                     WS-TIME-READ                                       
                     ';VOL='                                            
                     WS-METER-VOLUME-RED                                
                     ';PRE='                                            
                     WS-METER-PRESSURE-RED                              
                     ';TMP='                                            
                     WS-METER-TEMP-RED                                  
              DELIMITED BY SIZE                                         
                INTO WS-COMMENTS-TEMP                                   
                                                                        
A04860        MOVE WS-COMMENTS-TEMP TO WS-77-COMMENTS-TEXT              
           ELSE                                                         
              IF WS-METER-WARNING                                       
                 STRING WS-WQ-MESSAGE                                   
                       ';METER NO: '                                    
                       WS-PREV-METER-NO                                 
                  DELIMITED BY SIZE                                     
                     INTO WS-COMMENTS-TEMP                              
                                                                        
A04860            MOVE WS-COMMENTS-TEMP TO WS-77-COMMENTS-TEXT          
              ELSE                                                      
                 IF CNTRCT-ERRMSG                                       
                    STRING WS-WQ-MESSAGE                                
                           ' METER NO: '                                
                           WS-PREV-METER-NO                             
                           '; READ DATE: '                              
                           MSG-CNTRCT-DT                                
                    DELIMITED BY SIZE                                   
                      INTO WS-COMMENTS-TEMP                             
                                                                        
A04860              MOVE WS-COMMENTS-TEMP  TO WS-77-COMMENTS-TEXT       
                 ELSE                                                   
                    IF MULTI-ROWS-ERROR                                 
                       STRING WS-WQ-MESSAGE                             
                              ';METER NO: '                             
                              WS-PREV-METER-NO                          
                              ';READ DATE='                             
                              WS-CURR-DATE-READ                         
                       DELIMITED BY SIZE                                
                           INTO WS-COMMENTS-TEMP                        
                                                                        
A04860                 MOVE WS-COMMENTS-TEMP  TO WS-77-COMMENTS-TEXT    
                    ELSE                                                
                       STRING WS-WQ-MESSAGE                             
                             'READ DATE: '                              
                             WS-DATE-READ                               
                       DELIMITED BY SIZE                                
                          INTO WS-COMMENTS-TEMP                         
                                                                        
A04860                 MOVE WS-COMMENTS-TEMP  TO WS-77-COMMENTS-TEXT    
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
A04860     MOVE LENGTH OF WS-77-COMMENTS-TEXT TO WS-77-COMMENTS-LEN.    
A04860     MOVE SPACES             TO WS-77-FREE-FORM-TXT.              
A04860     MOVE LENGTH OF WS-WORK-QUEUE-DATA TO WS-77-FREE-FORM-LEN.    
A04860     MOVE WS-PGRMNAME                  TO WS-77-CREATED-BY.       
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
A04860     MOVE ZEROES TO WS-77-COMMENTS-LEN                            
A04860                    WS-77-FREE-FORM-LEN.                          
A04860     MOVE SPACES TO WS-77-COMMENTS-TEXT                           
                          WS-WQ-MESSAGE                                 
                          WS-COMMENTS-TEMP.                             
           MOVE ZERO   TO WS-WQ-ERROR-METER-NO.                         
           MOVE WS-N   TO WS-WARNING-IND                                
                          WS-ERROR-IND                                  
                          WS-CNTRCT-ERRMSG-FL.                          
      *                                                                         
       5310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *    6235-GET-FJC01-RESTART-REQ.                                          
       COPY CPD00035.                                                           
      *                                                                         
      *    6251-GET-FJC01-DATE.                                                 
       COPY CPD00037.                                                           
      *                                                                         
      *    6253-GET-FJC01-CHKP-LIMIT.                                           
       COPY CPD00034.                                                           
      *                                                                         
      *    6255-GET-FJC01-PRT-CNTR.                                             
       COPY CPD00015.                                                           
      *                                                                         
      *    6500-LOAD-EXCP-LIMITS.                                               
      *--------------------*                                                    
       7000-SELECT-ACCOUNT.                                             
      *--------------------*                                                    
           MOVE '7000'  TO ACTIVE-PARAGRAPH.                            
           EXEC SQL                                                     
              SELECT BILL_CYCLE                                         
                    ,CODE_ACCT_STAT                                     
                    ,PREMISE_NO                                         
                    ,CUSTOMER_NO                                        
                    ,CODE_ACCT_BILLED                                   
                    ,LOCAL_OFFICE                                       
                    ,COMPANY_NO                                         
                    ,NXT_BILL_NO                                        
                    ,REV_MTH_LST_NRML                                   
                INTO :AT-BILL-CYCLE                                     
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-PREMISE-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-CODE-ACCT-BILLED                               
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-COMPANY-NO                                     
                    ,:AT-NXT-BILL-NO                                    
                    ,:AT-REV-MTH-LST-NRML                               
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_CYCLE                                                 
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,CODE_ACCT_BILLED                                           
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,NXT_BILL_NO                                                
MFA-TR*             ,REV_MTH_LST_NRML                                           
MFA-TR*         INTO :AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-CODE-ACCT-BILLED                                       
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-NXT-BILL-NO                                            
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7000-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'ACCOUNT NO = ' AT-ACCOUNT-NO                     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *-----------------------*                                                 
       7025-SELECT-CURR-REVMTH.                                         
      *-----------------------*                                                 
           MOVE '7025'  TO ACTIVE-PARAGRAPH.                            
           EXEC SQL                                                     
              SELECT MIN(REVENUE_MONTH)                                 
                INTO :BN-REVENUE-MONTH                                  
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                    
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(REVENUE_MONTH)                                         
MFA-TR*         INTO :BN-REVENUE-MONTH                                          
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT = :BN-DATE-EXTRACT                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7025                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE BN-REVENUE-MONTH TO WS-REVENUE-MONTH                 
           ELSE                                                         
              DISPLAY '7025-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'RUN DATE = ' BN-DATE-EXTRACT                     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7025-EXIT.                                                       
           EXIT.                                                        
A02906*-----------------------*                                                 
A02906 7026-GET-REBILL-REV-MONTH.                                       
A02906*-----------------------*                                                 
A02906     MOVE '7026'  TO ACTIVE-PARAGRAPH.                            
A02906     EXEC SQL                                                     
A02906        SELECT BG.REV_MTH_ORIG_BILL                               
A02906          INTO :WS-REV-MTH-ORIG-BILL                              
A02906          FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
A02906         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO             
A02906           AND BG.BILL_NO            = :BG-BILL-NO                
A02906           AND BG.IC_NO              = :BG-IC-NO                  
A02906           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE         
A02906           AND BG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )     
A02906           AND BG.REBILL_IND         = :WS-Y                      
A02906                                                           
A02906                                                      
A02906     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BG.REV_MTH_ORIG_BILL                                       
MFA-TR*         INTO :WS-REV-MTH-ORIG-BILL                                      
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*        WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                     
MFA-TR*          AND BG.BILL_NO            = :BG-BILL-NO                        
MFA-TR*          AND BG.IC_NO              = :BG-IC-NO                          
MFA-TR*          AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                 
MFA-TR*          AND BG.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP             
MFA-TR*          AND BG.REBILL_IND         = :WS-Y                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7026                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02906     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02906                                                                  
A02906     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A02906        NEXT SENTENCE                                             
A02906     ELSE                                                         
A02906        DISPLAY '7026-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
A02906        DISPLAY 'ACCOUNT NO         = ' BG-ACCOUNT-NO             
A02906        DISPLAY 'IC NO              = ' BG-IC-NO                  
A02906        DISPLAY 'BILL_NO            = ' BG-BILL-NO                
A02906        DISPLAY 'CODE_UTIL_TYPE     = ' BG-CODE-UTIL-TYPE         
A02906        DISPLAY 'BILL ITEM TIMESTMP = ' BG-BILL-ITEM-TIMESTMP     
A02906        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02906     END-IF.                                                      
A02906*                                                                         
A02906 7026-EXIT.                                                       
A02906     EXIT.                                                        
      *---------------------*                                                   
       7050-XREF-ACCT-CYCLE.                                            
      *---------------------*                                                   
           MOVE '7050'  TO ACTIVE-PARAGRAPH.                            
           EXEC SQL                                                     
              SELECT BILL_CYCLE                                         
                    ,CODE_ACCT_STAT                                     
                    ,PREMISE_NO                                         
                    ,CUSTOMER_NO                                        
                    ,CODE_ACCT_BILLED                                   
                    ,LOCAL_OFFICE                                       
                    ,COMPANY_NO                                         
                    ,NXT_BILL_NO                                        
                    ,REV_MTH_LST_NRML                                   
                    ,ACCOUNT_NO                                         
                INTO :AT-BILL-CYCLE                                     
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-PREMISE-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-CODE-ACCT-BILLED                               
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-COMPANY-NO                                     
                    ,:AT-NXT-BILL-NO                                    
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-ACCOUNT-NO                                     
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
                   ,CSS_XREF_ACCT XR WITH(READUNCOMMITTED)                      
              WHERE AT.ACCOUNT_NO = XR.NEW_ACCOUNT_NO                   
                AND XR.OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO              
C35804                                                           
A02906                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_CYCLE                                                 
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,CODE_ACCT_BILLED                                           
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,NXT_BILL_NO                                                
MFA-TR*             ,REV_MTH_LST_NRML                                           
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*         INTO :AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-CODE-ACCT-BILLED                                       
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-NXT-BILL-NO                                            
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-ACCOUNT-NO                                             
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*            ,CSS_XREF_ACCT XR                                            
MFA-TR*       WHERE AT.ACCOUNT_NO = XR.NEW_ACCOUNT_NO                           
MFA-TR*         AND XR.OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO                      
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7050-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'OLD ACCT NO = ' XR-OLD-ACCOUNT-NO                
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *------------------*                                                      
       7060-GET-PREV-DAY.                                               
      *------------------*                                                      
           MOVE '7060' TO ACTIVE-PARAGRAPH.                             
C35804     EXEC SQL                                                     
C35804        SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-CURR-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE-READ
              ) <> 0) OR (LEN(:WS-CURR-DATE-READ
              ) <> 10), CIS.CHAR2DATE(:WS-CURR-DATE-READ
              ), CONVERT(DATE, :WS-CURR-DATE-READ) ) )
            INTO
              :WS-CURR-DATE-READ                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-CURR-DATE-READ =                                         
MFA-TR*             DATE(:WS-CURR-DATE-READ) - 1 DAY                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '** WS CURR DATE = ' WS-CURR-DATE-READ           
               DISPLAY '** 7060-SELECT = ' WS-ACTIVE-RETURN-CODE        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *------------------*                                                      
       7061-GET-DAY-BEFORE-EFF.                                         
      *------------------*                                                      
           MOVE '7061' TO ACTIVE-PARAGRAPH.                             
C35804     EXEC SQL                                                     
C35804        SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-GAS-EFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-GAS-EFF-DATE
              ) <> 0) OR (LEN(:WS-GAS-EFF-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-GAS-EFF-DATE
              ), CONVERT(DATE, :WS-GAS-EFF-DATE) ) )
            INTO
              :WS-DAY-BEFORE-EFF                      
C35804     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-DAY-BEFORE-EFF =                                         
MFA-TR*             DATE(:WS-GAS-EFF-DATE) - 1 DAY                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '** WS CURR DATE = ' WS-CURR-DATE-READ           
               DISPLAY '** 7061-SELECT = ' WS-ACTIVE-RETURN-CODE        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7061-EXIT.                                                       
           EXIT.                                                        
C28742*------------------*                                                      
C28742 7065-GET-NEXT-DAY.                                               
C28742*------------------*                                                      
C28742     MOVE '7065' TO ACTIVE-PARAGRAPH.                             
C35804     EXEC SQL                                                     
C35804        SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-MN-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MN-READ-DATE
              ) <> 0) OR (LEN(:WS-MN-READ-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-MN-READ-DATE
              ), CONVERT(DATE, :WS-MN-READ-DATE) ) )
            INTO
              :WS-MN-READ-DATE                      
C35804     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-MN-READ-DATE =                                           
MFA-TR*             DATE(:WS-MN-READ-DATE) + 1 DAY                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28742     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C28742     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C28742        NEXT SENTENCE                                             
C28742     ELSE                                                         
C28742         DISPLAY '** READ DATE   = ' WS-MN-READ-DATE              
C28742         DISPLAY '** 7065-SELECT = ' WS-ACTIVE-RETURN-CODE        
C28742         PERFORM 9900-ABEND THRU 9900-EXIT                        
C28742     END-IF.                                                      
C28742*                                                                         
C28742 7065-EXIT.                                                       
C28742     EXIT.                                                        
      *-----------------*                                                       
       7075-GET-PREMISE.                                                
      *-----------------*                                                       
           MOVE '7075' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE                                       
                    ,REV_DISTRICT_CD                                    
                INTO :PR-LOCAL-OFFICE                                   
                    ,:PR-REV-DISTRICT-CD                                
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE                                               
MFA-TR*             ,REV_DISTRICT_CD                                            
MFA-TR*         INTO :PR-LOCAL-OFFICE                                           
MFA-TR*             ,:PR-REV-DISTRICT-CD                                        
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7075                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7075-SELECT RETURN CODE =' WS-ACTIVE-RETURN-CODE 
              DISPLAY 'PREMISE NO = ' PR-PREMISE-NO                     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7075-EXIT.                                                       
           EXIT.                                                        
      *--------------------*                                                    
       7100-GET-METER-INFO.                                             
      *--------------------*                                                    
           MOVE '7100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT IC_NO                                              
                    ,MTR_REF_NO                                         
                    ,INDUST_BTU_ID                                      
                    ,MAX_NO_UNITS                                       
                    ,MIN_NO_UNITS                                       
                    ,CODE_METER_STATUS                                  
                    ,CODE_UTIL_TYPE                                     
                    ,ACCOUNT_NO                                         
                    ,CODE_DISCOUNT                                      
                    ,DIGTL_MTR_TYPE                                     
                    ,CODE_USAGE_TYPE                                    
                    ,CODE_USAGE_ID                                      
                    ,CODE_USAGE_SOURCE                                  
                    ,REG_ID_NO                                          
C28742              ,CODE_LAST_REG_READ                                 
C28742              ,LAST_REG_READ_DATE                                 
C28742              ,REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TIME, 108), 
           ':', '.') LAST_REG_READ_TIME                                 
                INTO :MN-IC-NO                                          
                    ,:MN-MTR-REF-NO                                     
                    ,:MN-INDUST-BTU-ID                                  
                    ,:MN-MAX-NO-UNITS                                   
                    ,:MN-MIN-NO-UNITS                                   
                    ,:MN-CODE-METER-STATUS                              
                    ,:MN-CODE-UTIL-TYPE                                 
                    ,:MN-ACCOUNT-NO                                     
                    ,:MN-CODE-DISCOUNT                                  
                    ,:MN-DIGTL-MTR-TYPE                                 
                    ,:MN-CODE-USAGE-TYPE                                
                    ,:MN-CODE-USAGE-ID                                  
                    ,:MN-CODE-USAGE-SOURCE                              
                    ,:MN-REG-ID-NO                                      
C28742              ,:MN-CODE-LAST-REG-READ                             
C28742              ,:MN-LAST-REG-READ-DATE :WS-MN-DATE-NULL             
C28742              ,:MN-LAST-REG-READ-TIME :WS-MN-TIME-NULL             
               FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                      
              WHERE CODE_UTIL_TYPE = :WS-UTIL-TYPE                      
                AND ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND METER_NO = :MN-METER-NO                             
                AND CODE_METER_STATUS <> 'K'                            
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IC_NO                                                      
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,INDUST_BTU_ID                                              
MFA-TR*             ,MAX_NO_UNITS                                               
MFA-TR*             ,MIN_NO_UNITS                                               
MFA-TR*             ,CODE_METER_STATUS                                          
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CODE_DISCOUNT                                              
MFA-TR*             ,DIGTL_MTR_TYPE                                             
MFA-TR*             ,CODE_USAGE_TYPE                                            
MFA-TR*             ,CODE_USAGE_ID                                              
MFA-TR*             ,CODE_USAGE_SOURCE                                          
MFA-TR*             ,REG_ID_NO                                                  
MFA-TR*             ,CODE_LAST_REG_READ                                         
MFA-TR*             ,LAST_REG_READ_DATE                                         
MFA-TR*             ,LAST_REG_READ_TIME                                         
MFA-TR*         INTO :MN-IC-NO                                                  
MFA-TR*             ,:MN-MTR-REF-NO                                             
MFA-TR*             ,:MN-INDUST-BTU-ID                                          
MFA-TR*             ,:MN-MAX-NO-UNITS                                           
MFA-TR*             ,:MN-MIN-NO-UNITS                                           
MFA-TR*             ,:MN-CODE-METER-STATUS                                      
MFA-TR*             ,:MN-CODE-UTIL-TYPE                                         
MFA-TR*             ,:MN-ACCOUNT-NO                                             
MFA-TR*             ,:MN-CODE-DISCOUNT                                          
MFA-TR*             ,:MN-DIGTL-MTR-TYPE                                         
MFA-TR*             ,:MN-CODE-USAGE-TYPE                                        
MFA-TR*             ,:MN-CODE-USAGE-ID                                          
MFA-TR*             ,:MN-CODE-USAGE-SOURCE                                      
MFA-TR*             ,:MN-REG-ID-NO                                              
MFA-TR*             ,:MN-CODE-LAST-REG-READ                                     
MFA-TR*             ,:MN-LAST-REG-READ-DATE:WS-MN-DATE-NULL                     
MFA-TR*             ,:MN-LAST-REG-READ-TIME:WS-MN-TIME-NULL                     
MFA-TR*        FROM CSS_MTRD_ENVRNMT                                            
MFA-TR*       WHERE CODE_UTIL_TYPE = :WS-UTIL-TYPE                              
MFA-TR*         AND ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*         AND METER_NO = :MN-METER-NO                                     
MFA-TR*         AND CODE_METER_STATUS <> 'K'                                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 MOVE SPACES               TO WS-SECURED-RATE-FL        
                 EXEC SQL                                               
                    SELECT RP.SECURED_RATE_FL                           
                      INTO :WS-SECURED-RATE-FL                          
                      FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),           
                           CSS_RATE_PLAN_DESC RP WITH(READUNCOMMITTED)          
                     WHERE UT.ACCOUNT_NO     = :MN-ACCOUNT-NO           
                       AND UT.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE       
                       AND UT.IC_NO          = :MN-IC-NO                
                       AND RP.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE        
                       AND RP.RATE_PLAN_NO   = UT.RATE_PLAN_NO          
C35804                                                           
A02906                                                      
                 END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*          EXEC SQL                                                       
MFA-TR*             SELECT RP.SECURED_RATE_FL                                   
MFA-TR*               INTO :WS-SECURED-RATE-FL                                  
MFA-TR*               FROM CSS_UTIL_ENVRNMT UT,                                 
MFA-TR*                    CSS_RATE_PLAN_DESC RP                                
MFA-TR*              WHERE UT.ACCOUNT_NO     = :MN-ACCOUNT-NO                   
MFA-TR*                AND UT.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE               
MFA-TR*                AND UT.IC_NO          = :MN-IC-NO                        
MFA-TR*                AND RP.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                
MFA-TR*                AND RP.RATE_PLAN_NO   = UT.RATE_PLAN_NO                  
MFA-TR*             WITH UR                                                     
MFA-TR*             QUERYNO 7100                                                
MFA-TR*          END-EXEC                                                       
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                               
T27149*          IF WS-SECURED-RATE-FL = 'Y'                                    
T27149*             MOVE WS-CATEGORY-ID-142  TO WS-CATEGORY-ID                  
T27149*             MOVE '4'                 TO WS-ROUTING-CATEGORY             
T27149*          ELSE                                                           
T27149*             MOVE WS-CATEGORY-ID-173  TO WS-CATEGORY-ID                  
T27149*             MOVE '1'                 TO WS-ROUTING-CATEGORY             
T27149*          END-IF                                                         
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 DISPLAY '7100-SELECT RETURN CODE = '                   
                                    WS-ACTIVE-RETURN-CODE               
                 DISPLAY 'ACCOUNT NO = ' AT-ACCOUNT-NO                  
                 DISPLAY 'METER NO = ' MN-METER-NO                      
                 DISPLAY 'CODE UTIL TYPE = ' WS-UTIL-TYPE               
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
36423 * FETCH DETAILS FROM GET_BILL                                  *          
      ****************************************************************          
      *                                                                         
36423  7120-SELECT-BILL.                                                
      *                                                                         
36423      EXEC SQL                                                     
36423         SELECT TOP(1) BILL_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP,
              REV_MTH_ORIG_BILL                                  
36423          INTO :BG-BILL-NO                                         
36423              ,:BG-BILL-ITEM-TIMESTMP                              
37554              ,:BG-REV-MTH-ORIG-BILL                               
36423         FROM   CSS_BILLING_DET WITH(READUNCOMMITTED)                      
36423         WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO                
36423           AND  CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE            
36423           AND  IC_NO              = :BG-IC-NO                     
37554           AND  REV_MTH_ORIG_BILL  IN (0, :BG-REV-MTH-ORIG-BILL)   
36423           AND  CODE_BILL_ITM_IND  = 'A'                           
36423           AND  CODE_BILL_ITM_TYPE = 'C'                           
36423           AND  REV_RPT_CD        <> 'T'                           
36423           AND  CODE_BILL_CALC     = 'A'                           
36423           AND  REVENUE_MONTH      = 0                             
37554         ORDER BY REV_MTH_ORIG_BILL  DESC                          
36423                                        
A02906                                                      
36423      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_NO                                                    
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,REV_MTH_ORIG_BILL                                          
MFA-TR*        INTO :BG-BILL-NO                                                 
MFA-TR*            ,:BG-BILL-ITEM-TIMESTMP                                      
MFA-TR*            ,:BG-REV-MTH-ORIG-BILL                                       
MFA-TR*       FROM   CSS_BILLING_DET                                            
MFA-TR*       WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO                        
MFA-TR*         AND  CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                    
MFA-TR*         AND  IC_NO              = :BG-IC-NO                             
MFA-TR*         AND  REV_MTH_ORIG_BILL  IN (0, :BG-REV-MTH-ORIG-BILL)           
MFA-TR*         AND  CODE_BILL_ITM_IND  = 'A'                                   
MFA-TR*         AND  CODE_BILL_ITM_TYPE = 'C'                                   
MFA-TR*         AND  REV_RPT_CD        <> 'T'                                   
MFA-TR*         AND  CODE_BILL_CALC     = 'A'                                   
MFA-TR*         AND  REVENUE_MONTH      = 0                                     
MFA-TR*       ORDER BY REV_MTH_ORIG_BILL  DESC                                  
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
36423      IF SQLCODE = SUCCESSFUL-CALL                                 
36423         CONTINUE                                                  
36423      ELSE                                                         
36423         IF SQLCODE = NOT-FOUND                                    
36423            MOVE 'Y' TO WS-NO-MORE-BG-SW                           
36423         ELSE                                                      
36423            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                  
36423            DISPLAY '*****************PCSBW138******************'  
36423            DISPLAY '*         ABENDING PROGRAM                *'  
36423            DISPLAY '* PARAGRAPH 7120-SELECT-BILL        *'        
36423            DISPLAY '* SQLCODE        = ' WS-ACTIVE-RETURN-CODE    
36423            DISPLAY '* ACCOUNT NO     = ' BG-ACCOUNT-NO            
36423            DISPLAY '* CODE-UTIL-TYPE = ' BG-CODE-UTIL-TYPE        
36423            DISPLAY '* BILL NO        = ' BG-BILL-NO               
36423            DISPLAY '*   IC NO        = ' BG-IC-NO                 
36423            DISPLAY '* REVENUE MONTH  = ' BG-REVENUE-MONTH         
36423            DISPLAY '*****************PCSBW138******************'  
36423            PERFORM 9900-ABEND THRU 9900-EXIT                      
36423         END-IF                                                    
36423      END-IF.                                                      
      *                                                                         
36423  7120-EXIT.                                                       
36423      EXIT.                                                        
      *                                                                         
      *-----------------------*                                                 
       7200-GET-CODE-MTR-TYPE.                                          
      *-----------------------*                                                 
      *                                                                         
           MOVE '7200' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT CODE_METER_TYPE                                    
                INTO :GM-CODE-METER-TYPE                                
                FROM CSS_GAS_METER WITH(READUNCOMMITTED)                        
               WHERE CODE_UTIL_TYPE = :WS-UTIL-TYPE                     
                 AND COMPANY_NO = :WS-COMPANY-NO                        
                 AND METER_NO = :MN-METER-NO                            
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_METER_TYPE                                            
MFA-TR*         INTO :GM-CODE-METER-TYPE                                        
MFA-TR*         FROM CSS_GAS_METER                                              
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-UTIL-TYPE                             
MFA-TR*          AND COMPANY_NO = :WS-COMPANY-NO                                
MFA-TR*          AND METER_NO = :MN-METER-NO                                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              IF GM-CODE-METER-TYPE EQUAL '4'                           
                 MOVE 'Y' TO  WS-ORIF-METER                             
              ELSE                                                      
                 MOVE 'N' TO  WS-ORIF-METER                             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '7200-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'COMPANY NO = ' WS-COMPANY-NO                     
              DISPLAY 'METER NO = ' MN-METER-NO                         
              DISPLAY 'CODE UTIL TYPE = ' WS-UTIL-TYPE                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *----------------------*                                                  
       7230-OPEN-BILLING-HDR.                                           
      *----------------------*                                                  
           MOVE '7230' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                OPEN BILLING_HDR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7230-OPEN RETURN CODE =' WS-ACTIVE-RETURN-CODE  
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *-----------------------*                                                 
       7231-FETCH-BILLING-HDR.                                          
      *-----------------------*                                                 
           MOVE '7231' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               FETCH BILLING_HDR                                        
                INTO :BI-ACCOUNT-NO,                                    
                     :BI-PREMISE-NO,                                    
                     :BI-BILL-NO,                                       
                     :BI-DATE-BILLED :IND-DATE-BILLED                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7231-FETCH RETURN CODE =' WS-ACTIVE-RETURN-CODE 
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7231-EXIT.                                                       
           EXIT.                                                        
      *-----------------------*                                                 
       7232-CLOSE-BILLING-HDR.                                          
      *-----------------------*                                                 
           MOVE '7232' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               CLOSE BILLING_HDR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7232-CLOSE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7232-EXIT.                                                       
           EXIT.                                                        
      *----------------------*                                                  
       7240-OPEN-BILLING-DET.                                           
      *----------------------*                                                  
           MOVE '7240' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               OPEN BILLING_DET                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7240-OPEN RETURN CODE =' WS-ACTIVE-RETURN-CODE  
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *-----------------------*                                                 
       7241-FETCH-BILLING-DET.                                          
      *-----------------------*                                                 
           MOVE '7241' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                FETCH BILLING_DET                                       
                INTO :BG-ACCOUNT-NO,                                    
                     :BG-PREMISE-NO,                                    
                     :BG-BILL-NO,                                       
                     :BG-CODE-UTIL-TYPE,                                
                     :BG-IC-NO,                                         
                     :BG-BILL-ITEM-TIMESTMP,                            
                     :BG-DATE-ORIG-BILL :IND-DATE-ORIG-BILL,             
                     :BG-AMT-BILL-ITEM,                                 
                     :BG-CODE-BILL-CALC,                                
                     :BG-CODE-BILL-ITM-TYPE,                            
                     :BG-CODE-BILL-ITM-IND,                             
                     :BG-CODE-DR-CR-CNSMPTN,                            
                     :BG-AMT-STATE-TAX,                                 
                     :BG-AMT-CITY-TAX,                                  
                     :BG-AMT-OTHER-TAX,                                 
                     :BG-CODE-REVENUE-CLASS,                            
                     :BG-CODE-SIC-NO,                                   
                     :BG-RATE-PLAN-NO,                                  
                     :BG-CODE-CURTAIL-PRTY,                             
                     :BG-CODE-STAT-TAX-XMT,                             
                     :BG-CODE-CITY-TAX-XMT,                             
                     :BG-CODE-OTHR-TAX-XMT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7241-FETCH RETURN CODE =' WS-ACTIVE-RETURN-CODE 
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7241-EXIT.                                                       
           EXIT.                                                        
      *-----------------------*                                                 
       7242-CLOSE-BILLING-DET.                                          
      *-----------------------*                                                 
           MOVE '7242' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               CLOSE BILLING_DET                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7242-CLOSE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7242-EXIT.                                                       
           EXIT.                                                        
      *-----------------*                                                       
       7250-GET-MTR-CHG.                                                
      *-----------------*                                                       
           MOVE '7250' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT DISTINCT IC_NO                                     
                    ,MTR_REF_NO                                         
                    ,MAX(DATE_READ)                                     
                INTO :CX-IC-NO                                          
                    ,:CX-MTR-REF-NO                                     
                    ,:CX-DATE-READ                                      
                FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                     
               WHERE CODE_UTIL_TYPE = :WS-UTIL-TYPE                     
                 AND ACCOUNT_NO     = :AT-ACCOUNT-NO                    
                 AND METER_NO       = :MN-METER-NO                      
                 AND CODE_METER_READ = 'B'                              
               GROUP BY IC_NO, MTR_REF_NO                               
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT IC_NO                                             
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,MAX(DATE_READ)                                             
MFA-TR*         INTO :CX-IC-NO                                                  
MFA-TR*             ,:CX-MTR-REF-NO                                             
MFA-TR*             ,:CX-DATE-READ                                              
MFA-TR*         FROM CSS_CNSMPTN_HIST                                           
MFA-TR*        WHERE CODE_UTIL_TYPE = :WS-UTIL-TYPE                             
MFA-TR*          AND ACCOUNT_NO     = :AT-ACCOUNT-NO                            
MFA-TR*          AND METER_NO       = :MN-METER-NO                              
MFA-TR*          AND CODE_METER_READ = 'B'                                      
MFA-TR*        GROUP BY IC_NO, MTR_REF_NO                                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7250-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'ACCOUNT NO = ' AT-ACCOUNT-NO                     
              DISPLAY 'METER NO = ' MN-METER-NO                         
              DISPLAY 'CODE UTIL TYPE = ' WS-UTIL-TYPE                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *-----------------*                                                       
       7300-GET-REV-MTH.                                                
      *-----------------*                                                       
           MOVE '7300' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT MIN(REVENUE_MONTH)                                 
                INTO :RW-REVENUE-MONTH                                  
                FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                      
               WHERE READ_CYCLE = :AT-BILL-CYCLE                        
                 AND OPTIMUM_READ_DATE >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-CURR-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE-READ
              ) <> 0) OR (LEN(:WS-CURR-DATE-READ
              ) <> 10), CIS.CHAR2DATE(:WS-CURR-DATE-READ
              ), CONVERT(DATE, :WS-CURR-DATE-READ) )            
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(REVENUE_MONTH)                                         
MFA-TR*         INTO :RW-REVENUE-MONTH                                          
MFA-TR*         FROM CSS_READ_WINDOW                                            
MFA-TR*        WHERE READ_CYCLE = :AT-BILL-CYCLE                                
MFA-TR*          AND OPTIMUM_READ_DATE >= :WS-CURR-DATE-READ                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7300-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'READ CYCLE = ' AT-BILL-CYCLE                     
              DISPLAY 'OPTIMUM READ DT = ' WS-CURR-DATE-READ            
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *------------------------*                                                
       7350-SELECT-BTU-GRAVITY.                                         
      *------------------------*                                                
           MOVE '7350' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT BTU_FACTOR                                         
                    ,SPECIFIC_GRAVITY                                   
                INTO :FE-BTU-FACTOR                                     
                    ,:FE-SPECIFIC-GRAVITY                               
                FROM CSS_BTU_INDUST_FCT WITH(READUNCOMMITTED)                   
               WHERE COMPANY_NO = :WS-COMPANY-NO                        
                 AND INDUST_BTU_ID = :FE-INDUST-BTU-ID                  
                 AND BTU_DT = IIF(TRY_CONVERT(DATE, :FE-BTU-DT
              ) IS NULL OR (PATINDEX('%.%', :FE-BTU-DT) <> 0) OR (LEN(
                                                             :FE-BTU-DT
              ) <> 10), CIS.CHAR2DATE(:FE-BTU-DT), CONVERT(DATE, 
                                                             :FE-BTU-DT
              ) )                                
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BTU_FACTOR                                                 
MFA-TR*             ,SPECIFIC_GRAVITY                                           
MFA-TR*         INTO :FE-BTU-FACTOR                                             
MFA-TR*             ,:FE-SPECIFIC-GRAVITY                                       
MFA-TR*         FROM CSS_BTU_INDUST_FCT                                         
MFA-TR*        WHERE COMPANY_NO = :WS-COMPANY-NO                                
MFA-TR*          AND INDUST_BTU_ID = :FE-INDUST-BTU-ID                          
MFA-TR*          AND BTU_DT = :FE-BTU-DT                                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7350-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'COMPANY NO = ' WS-COMPANY-NO                     
              DISPLAY 'INDUST BTU ID = ' FE-INDUST-BTU-ID               
              DISPLAY 'BTU DT = ' FE-BTU-DT                             
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *--------------------------*                                              
       7375-ESTIMATE-BTU-GRAVITY.                                       
      *--------------------------*                                              
           MOVE '7375' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT SUM(BTU_FACTOR)                                    
                    ,SUM(SPECIFIC_GRAVITY)                              
                    ,COUNT(*)                                           
                INTO :WS-SUM-BTU-FACTOR :WS-SUM-BTU-FACT-NULL           
                    ,:WS-SUM-SP-GRAVITY :WS-SUM-SP-GRAV-NULL            
                    ,:WS-SUM-CNT :WS-SUM-CNT-NULL                       
                FROM CSS_BTU_INDUST_FCT WITH(READUNCOMMITTED)                   
               WHERE COMPANY_NO    = :WS-COMPANY-NO                     
                 AND INDUST_BTU_ID = :FE-INDUST-BTU-ID                  
                 AND MONTH(BTU_DT) = :WS-BTU-DT-MM                      
                 AND YEAR(BTU_DT)  = :WS-BTU-DT-YY                      
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(BTU_FACTOR)                                            
MFA-TR*             ,SUM(SPECIFIC_GRAVITY)                                      
MFA-TR*             ,COUNT(*)                                                   
MFA-TR*         INTO :WS-SUM-BTU-FACTOR :WS-SUM-BTU-FACT-NULL                   
MFA-TR*             ,:WS-SUM-SP-GRAVITY :WS-SUM-SP-GRAV-NULL                    
MFA-TR*             ,:WS-SUM-CNT :WS-SUM-CNT-NULL                               
MFA-TR*         FROM CSS_BTU_INDUST_FCT                                         
MFA-TR*        WHERE COMPANY_NO    = :WS-COMPANY-NO                             
MFA-TR*          AND INDUST_BTU_ID = :FE-INDUST-BTU-ID                          
MFA-TR*          AND MONTH(BTU_DT) = :WS-BTU-DT-MM                              
MFA-TR*          AND YEAR(BTU_DT)  = :WS-BTU-DT-YY                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7375                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-SUM-BTU-FACT-NULL < ZERO OR                            
              WS-SUM-SP-GRAV-NULL  < ZERO OR                            
              WS-SUM-CNT-NULL < ZERO                                    
              MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE                   
           END-IF                                                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7375-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'COMPANY NO = ' WS-COMPANY-NO                     
              DISPLAY 'INDUST BTU ID = ' FE-INDUST-BTU-ID               
              DISPLAY 'MONTH(BTU DT) = ' WS-BTU-DT-MM                   
              DISPLAY 'YEAR(BTU DT) = ' WS-BTU-DT-YY                    
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7375-EXIT.                                                       
           EXIT.                                                        
      *-------------------*                                                     
       7400-READ-EFM-FILE.                                              
      *-------------------*                                                     
           MOVE '7400' TO ACTIVE-PARAGRAPH.                             
                                                                        
           READ FCSBW05-FILE                                            
             INTO FIOBW05                                               
               AT END MOVE WS-YES TO WS-END-OF-EFM-FILE.                
      *                                                                         
31870      PERFORM 1350-FIX-METER-NUMBER THRU 1350-EXIT.                
      *                                                                         
           IF WS-EFM-EOF                                                
              MOVE 1                  TO WS-PROCESS-TYPE                
           ELSE                                                         
              MOVE E-FBW05-DATE-READ TO WS-CURR-DATE-READ               
              MOVE E-FBW05-TIME-READ TO WS-TIME-READ-RED                
                                        WS-CURR-TIME-READ               
C30010        IF WS-CURR-DATE-READ <  WS-GAS-EFF-DATE                   
C30010           MOVE WS-EFF-TIME-HH TO WS-END-TIME-HH                  
C30010        ELSE                                                      
C30010           MOVE WS-CUR-TIME-HH TO WS-END-TIME-HH                  
C30010        END-IF                                                    
              IF WS-TIME-READ-HH <= WS-END-TIME-HH                      
                 PERFORM 7060-GET-PREV-DAY THRU 7060-EXIT               
              END-IF                                                    
           END-IF.                                                      
                                                                        
           ADD  1 TO WS-FCSBW05-REC-CNTR.                               
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *----------------------*                                                  
       7450-SELECT-TIMESTAMP.                                           
      *----------------------*                                                  
           MOVE '7450' TO ACTIVE-PARAGRAPH.                             
C35804     EXEC SQL                                                     
C35804        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTMP-FROM-DB2-CALL                                   
C35804     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-TIMESTMP-FROM-DB2-CALL =                                 
MFA-TR*             CURRENT TIMESTAMP                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7450-SELECT RETURN CODE =' WS-ACTIVE-RETURN-CODE 
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *-------------------------*                                               
       7475-SELECT-RESTART-DATA.                                        
      *-------------------------*                                               
           MOVE '7475' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART WITH(READUNCOMMITTED)                         
                WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                 
                  AND PARTITION_NO   = :RF-PARTITION-NO                 
                  AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                 
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART                                               
MFA-TR*         WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                         
MFA-TR*           AND PARTITION_NO   = :RF-PARTITION-NO                         
MFA-TR*           AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7475                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7475-SELECT RETURN CODE =' WS-ACTIVE-RETURN-CODE
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7475-EXIT.                                                       
           EXIT.                                                        
      *------------------*                                                      
       7500-CXROW-EXISTS.                                               
      *------------------*                                                      
           MOVE '7500'  TO ACTIVE-PARAGRAPH.                            
           MOVE SPACES  TO WS-ROW-EXISTS.                               
           EXEC SQL                                                     
              SELECT CODE_METER_READ                                    
                    ,ITEM_SEQ_NO                                        
                    ,METER_NO                                           
                INTO :CX-CODE-METER-READ                                
                    ,:CX-ITEM-SEQ-NO                                    
                    ,:CX-METER-NO                                       
                FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                
                 AND BILL_NO            = :CX-BILL-NO                   
                 AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE            
                 AND IC_NO              = :CX-IC-NO                     
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )        
                 AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD          
                 AND MTR_REF_NO         = :CX-MTR-REF-NO                
                 AND REG_ID_NO          = :CX-REG-ID-NO                 
                 AND DATE_READ          = IIF(TRY_CONVERT(DATE, 
                                                     :WS-PREV-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-DATE-READ
              ) <> 0) OR (LEN(:WS-PREV-DATE-READ
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-DATE-READ
              ), CONVERT(DATE, :WS-PREV-DATE-READ) )            
                 AND METER_NO           = :WS-PREV-METER-NO             
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_METER_READ                                            
MFA-TR*             ,ITEM_SEQ_NO                                                
MFA-TR*             ,METER_NO                                                   
MFA-TR*         INTO :CX-CODE-METER-READ                                        
MFA-TR*             ,:CX-ITEM-SEQ-NO                                            
MFA-TR*             ,:CX-METER-NO                                               
MFA-TR*         FROM CSS_CNSMPTN_HIST                                           
MFA-TR*        WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                        
MFA-TR*          AND BILL_NO            = :CX-BILL-NO                           
MFA-TR*          AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                    
MFA-TR*          AND IC_NO              = :CX-IC-NO                             
MFA-TR*          AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP                
MFA-TR*          AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD                  
MFA-TR*          AND MTR_REF_NO         = :CX-MTR-REF-NO                        
MFA-TR*          AND REG_ID_NO          = :CX-REG-ID-NO                         
MFA-TR*          AND DATE_READ          = :WS-PREV-DATE-READ                    
MFA-TR*          AND METER_NO           = :WS-PREV-METER-NO                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7500-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'ACCOUNT NO = ' CX-ACCOUNT-NO                     
              DISPLAY 'BILL NO = ' CX-BILL-NO                           
              DISPLAY 'CODE UTIL TYPE = ' CX-CODE-UTIL-TYPE             
              DISPLAY 'IC NO = ' CX-IC-NO                               
              DISPLAY 'BILL ITEM TIMESTMP = ' CX-BILL-ITEM-TIMESTMP     
              DISPLAY 'CODE TIME PERIOD = ' CX-CODE-TIME-PERIOD         
              DISPLAY 'MTR_REF_NO = ' CX-MTR-REF-NO                     
              DISPLAY 'REG_ID_NO = ' CX-REG-ID-NO                       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *-------------------------*                                               
       7550-SELECT-UTIL-ENVRNMT.                                        
      *-------------------------*                                               
           MOVE '7550' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT CODE_ESTIMATE_OK                                   
                    ,CODE_CURTAIL_PRTY                                  
                    ,CODE_REVENUE_CLASS                                 
                    ,RATE_PLAN_NO                                       
                    ,CODE_SIC_NO                                        
                    ,CODE_MTR_READ_FREQ                                 
                    ,SEASONAL_USE_CODE                                  
                    ,READ_CYCLE                                         
                    ,COMPANY_NO                                         
                    ,CODE_STAT_TAX_XMT                                  
                    ,CODE_CITY_TAX_XMT                                  
                    ,CODE_OTHR_TAX_XMT                                  
                INTO :UT-CODE-ESTIMATE-OK                               
                    ,:UT-CODE-CURTAIL-PRTY                              
                    ,:UT-CODE-REVENUE-CLASS                             
                    ,:UT-RATE-PLAN-NO                                   
                    ,:UT-CODE-SIC-NO                                    
                    ,:UT-CODE-MTR-READ-FREQ                             
                    ,:UT-SEASONAL-USE-CODE                              
                    ,:UT-READ-CYCLE                                     
                    ,:UT-COMPANY-NO                                     
                    ,:UT-CODE-STAT-TAX-XMT                              
                    ,:UT-CODE-CITY-TAX-XMT                              
                    ,:UT-CODE-OTHR-TAX-XMT                              
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                
                 AND IC_NO          = :UT-IC-NO                         
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_ESTIMATE_OK                                           
MFA-TR*             ,CODE_CURTAIL_PRTY                                          
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,CODE_SIC_NO                                                
MFA-TR*             ,CODE_MTR_READ_FREQ                                         
MFA-TR*             ,SEASONAL_USE_CODE                                          
MFA-TR*             ,READ_CYCLE                                                 
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,CODE_STAT_TAX_XMT                                          
MFA-TR*             ,CODE_CITY_TAX_XMT                                          
MFA-TR*             ,CODE_OTHR_TAX_XMT                                          
MFA-TR*         INTO :UT-CODE-ESTIMATE-OK                                       
MFA-TR*             ,:UT-CODE-CURTAIL-PRTY                                      
MFA-TR*             ,:UT-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:UT-RATE-PLAN-NO                                           
MFA-TR*             ,:UT-CODE-SIC-NO                                            
MFA-TR*             ,:UT-CODE-MTR-READ-FREQ                                     
MFA-TR*             ,:UT-SEASONAL-USE-CODE                                      
MFA-TR*             ,:UT-READ-CYCLE                                             
MFA-TR*             ,:UT-COMPANY-NO                                             
MFA-TR*             ,:UT-CODE-STAT-TAX-XMT                                      
MFA-TR*             ,:UT-CODE-CITY-TAX-XMT                                      
MFA-TR*             ,:UT-CODE-OTHR-TAX-XMT                                      
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO          = :UT-IC-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7550                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7550-SELECT RETURN CODE =' WS-ACTIVE-RETURN-CODE 
              DISPLAY 'ACCOUNT = ' UT-ACCOUNT-NO                        
              DISPLAY 'IC = ' UT-CODE-UTIL-TYPE UT-IC-NO                
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *-------------------*                                                     
       7700-GET-MAX-SEQNO.                                              
      *-------------------*                                                     
           MOVE '7700' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT MAX(ITEM_SEQ_NO)                                   
                INTO :CX-ITEM-SEQ-NO :WS-CX-ITEM-SEQ-NO-NULL            
                FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                
                 AND BILL_NO            = :CX-BILL-NO                   
                 AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE            
                 AND IC_NO              = :CX-IC-NO                     
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )        
                 AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD          
                 AND MTR_REF_NO         = :CX-MTR-REF-NO                
                 AND REG_ID_NO          = :CX-REG-ID-NO                 
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(ITEM_SEQ_NO)                                           
MFA-TR*         INTO :CX-ITEM-SEQ-NO :WS-CX-ITEM-SEQ-NO-NULL                    
MFA-TR*         FROM CSS_CNSMPTN_HIST                                           
MFA-TR*        WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                        
MFA-TR*          AND BILL_NO            = :CX-BILL-NO                           
MFA-TR*          AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                    
MFA-TR*          AND IC_NO              = :CX-IC-NO                             
MFA-TR*          AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP                
MFA-TR*          AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD                  
MFA-TR*          AND MTR_REF_NO         = :CX-MTR-REF-NO                        
MFA-TR*          AND REG_ID_NO          = :CX-REG-ID-NO                         
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-CX-ITEM-SEQ-NO-NULL LESS THAN ZERO                     
              MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE
           END-IF.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7700-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *--------------------*                                                    
       7750-SUBTRACT-CXROW.                                             
      *--------------------*                                                    
A02906     MOVE '7750'  TO ACTIVE-PARAGRAPH.                            
           EXEC SQL                                                     
C28742        SELECT ITEM_SEQ_NO                                        
C28742          INTO :CX-ITEM-SEQ-NO                                    
                FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                
                 AND BILL_NO            = :CX-BILL-NO                   
                 AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE            
                 AND IC_NO              = :CX-IC-NO                     
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )        
                 AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD          
                 AND MTR_REF_NO         = :CX-MTR-REF-NO                
                 AND REG_ID_NO          = :CX-REG-ID-NO                 
                 AND DATE_READ          = IIF(TRY_CONVERT(DATE, 
                                                          :CX-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ
              ) <> 0) OR (LEN(:CX-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :CX-DATE-READ
              ), CONVERT(DATE, :CX-DATE-READ) )                 
                 AND METER_NO           = :CX-METER-NO                  
                 AND CODE_USAGE_SOURCE  = :WS-J                         
                 AND CODE_DEBIT_CREDIT  = :WS-CREDIT                    
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ITEM_SEQ_NO                                                
MFA-TR*         INTO :CX-ITEM-SEQ-NO                                            
MFA-TR*         FROM CSS_CNSMPTN_HIST                                           
MFA-TR*        WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                        
MFA-TR*          AND BILL_NO            = :CX-BILL-NO                           
MFA-TR*          AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                    
MFA-TR*          AND IC_NO              = :CX-IC-NO                             
MFA-TR*          AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP                
MFA-TR*          AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD                  
MFA-TR*          AND MTR_REF_NO         = :CX-MTR-REF-NO                        
MFA-TR*          AND REG_ID_NO          = :CX-REG-ID-NO                         
MFA-TR*          AND DATE_READ          = :CX-DATE-READ                         
MFA-TR*          AND METER_NO           = :CX-METER-NO                          
MFA-TR*          AND CODE_USAGE_SOURCE  = :WS-J                                 
MFA-TR*          AND CODE_DEBIT_CREDIT  = :WS-CREDIT                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7750                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7750-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'ACCOUNT NO = ' CX-ACCOUNT-NO                     
              DISPLAY 'BILL NO = ' CX-BILL-NO                           
              DISPLAY 'CODE UTIL TYPE = ' CX-CODE-UTIL-TYPE             
              DISPLAY 'IC NO = ' CX-IC-NO                               
              DISPLAY 'BILL ITEM TIMESTMP = ' CX-BILL-ITEM-TIMESTMP     
              DISPLAY 'CODE TIME PERIOD = ' CX-CODE-TIME-PERIOD         
              DISPLAY 'MTR_REF_NO = ' CX-MTR-REF-NO                     
              DISPLAY 'REG_ID_NO = ' CX-REG-ID-NO                       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *----------------------*                                                  
       7850-SELECT-RATE-HILO.                                           
      *----------------------*                                                  
           MOVE '7850' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT USAGE_HIGH_PCT                                     
                    ,USAGE_LOW_PCT                                      
                INTO :O9-USAGE-HIGH-PCT                                 
                    ,:O9-USAGE-LOW-PCT                                  
                FROM CSS_RATE_HIGH_LOW WITH(READUNCOMMITTED)                    
               WHERE CODE_UTIL_TYPE = :O9-CODE-UTIL-TYPE                
                 AND RATE_PLAN_NO   = :O9-RATE-PLAN-NO                  
C35804                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT USAGE_HIGH_PCT                                             
MFA-TR*             ,USAGE_LOW_PCT                                              
MFA-TR*         INTO :O9-USAGE-HIGH-PCT                                         
MFA-TR*             ,:O9-USAGE-LOW-PCT                                          
MFA-TR*         FROM CSS_RATE_HIGH_LOW                                          
MFA-TR*        WHERE CODE_UTIL_TYPE = :O9-CODE-UTIL-TYPE                        
MFA-TR*          AND RATE_PLAN_NO   = :O9-RATE-PLAN-NO                          
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7850                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7850-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'O9-RATE-PLAN-NO    =' O9-RATE-PLAN-NO            
              DISPLAY 'O9-CODE-UTIL-TYPE  =' O9-CODE-UTIL-TYPE          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A02906******************************************************************        
A02906* 7900-OPEN-UTL-BILL-REL-CRSR.                                   *        
A02906* OPENS UTL_BILL_REL CURSOR.                                     *        
A02906******************************************************************        
A02906*                                                                         
A02906 7900-OPEN-UTL-BILL-REL-CRSR.                                     
A02906*                                                                         
A02906     MOVE '7900' TO ACTIVE-PARAGRAPH.                             
A02906*                                                                         
A02906     EXEC SQL                                                     
A02906          OPEN UTL_BILL_REL                                       
A02906     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02906*                                                                         
A02906     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02906*                                                                         
A02906     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02906        NEXT SENTENCE                                             
A02906     ELSE                                                         
A02906        DISPLAY '* 7900-OPEN-UTL-BILL-REL-CRSR          *'        
A02906        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A02906        DISPLAY '* ACCOUNT_NO_DEP     = ' UR-ACCOUNT-NO-DEP       
A02906        DISPLAY '* CODE_UTIL_TYPE_DEP = ' UR-CODE-UTIL-TYPE-DEP   
A02906        DISPLAY '* IC_NO_DEP          = ' UR-IC-NO-DEP            
A02906        DISPLAY '* MTR_REF_NO_DEP     = ' UR-MTR-REF-NO-DEP       
A02906        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02906     END-IF.                                                      
A02906*                                                                         
A02906 7900-EXIT.                                                       
A02906     EXIT.                                                        
A02906*                                                                         
A02906******************************************************************        
A02906* 7910-FETCH-UTL-BILL-REL-CRSR.                                  *        
A02906* FETCH UTL_BILL_REL CURSOR.                                     *        
A02906******************************************************************        
A02906*                                                                         
A02906 7910-FETCH-UTL-BILL-REL-CRSR.                                    
A02906*                                                                         
A02906     MOVE '7910' TO ACTIVE-PARAGRAPH.                             
A02906*                                                                         
A02906     EXEC SQL                                                     
A02906         FETCH UTL_BILL_REL                                       
A02906          INTO  :UR-ACCOUNT-NO-MST                                
A02906               ,:UR-CODE-UTIL-TYPE-MST                            
A02906               ,:UR-IC-NO-MST                                     
A02906               ,:UR-MTR-REF-NO-MST                                
A02906     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02906*                                                                         
A02906     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02906*                                                                         
A02906     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A02906        NEXT SENTENCE                                             
A02906     ELSE                                                         
A02906        DISPLAY '* 7910-FETCH-UTL-BILL-REL-CRSR         *'        
A02906        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A02906        DISPLAY '* ACCOUNT_NO_DEP     = ' UR-ACCOUNT-NO-DEP       
A02906        DISPLAY '* CODE_UTIL_TYPE_DEP = ' UR-CODE-UTIL-TYPE-DEP   
A02906        DISPLAY '* IC_NO_DEP          = ' UR-IC-NO-DEP            
A02906        DISPLAY '* MTR_REF_NO_DEP     = ' UR-MTR-REF-NO-DEP       
A02906        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02906     END-IF.                                                      
A02906*                                                                         
A02906 7910-EXIT.                                                       
A02906     EXIT.                                                        
A02906*                                                                         
A02906******************************************************************        
A02906* 7920-CLOSE-UTL-BILL-REL-CRSR.                                  *        
A02906* CLOSE UTL_BILL_REL CURSOR.                                     *        
A02906******************************************************************        
A02906*                                                                         
A02906 7920-CLOSE-UTL-BILL-REL-CRSR.                                    
A02906*                                                                         
A02906     MOVE '7920' TO ACTIVE-PARAGRAPH.                             
A02906*                                                                         
A02906     EXEC SQL                                                     
A02906         CLOSE UTL_BILL_REL                                       
A02906     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02906*                                                                         
A02906     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02906*                                                                         
A02906     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02906         NEXT SENTENCE                                            
A02906     ELSE                                                         
A02906        DISPLAY '* 7920-CLOSE-UTL-BILL-REL-CRSR         *'        
A02906        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A02906        DISPLAY '* ACCOUNT_NO_DEP     = ' UR-ACCOUNT-NO-DEP       
A02906        DISPLAY '* CODE_UTIL_TYPE_DEP = ' UR-CODE-UTIL-TYPE-DEP   
A02906        DISPLAY '* IC_NO_DEP          = ' UR-IC-NO-DEP            
A02906        DISPLAY '* MTR_REF_NO_DEP     = ' UR-MTR-REF-NO-DEP       
A02906        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02906     END-IF.                                                      
A02906*                                                                         
A02906 7920-EXIT.                                                       
A02906     EXIT.                                                        
A02906*                                                                         
      *--------------------------*                                              
       7950-OPEN-BILL-CNTRCT-CRSR.                                      
      *--------------------------*                                              
           MOVE '7950' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
               OPEN BILL_CNTRCT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSBW138 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7950-OPEN  **'        
              DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *---------------------------*                                             
       7960-FETCH-BILL-CNTRCT-CRSR.                                     
      *---------------------------*                                             
           MOVE '7960' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              FETCH BILL_CNTRCT                                         
               INTO :WS-BILL-CNTRCT-FL                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 SET END-OF-BK-CRSR  TO  TRUE                           
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSBW138 PROCESSING ERROR      **'     
                 DISPLAY '**      ABEND IN PARAGRAPH 7960-FETCH **'     
                 DISPLAY '**     ACCOUNT_NO = ' BK-ACCOUNT-NO           
                 DISPLAY '**          IC_NO = ' BK-IC-NO                
                 DISPLAY '**     START_DATE = ' WS-CURR-DATE-READ       
                 DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE   
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *---------------------------*                                             
       7970-CLOSE-BILL-CNTRCT-CRSR.                                     
      *---------------------------*                                             
           MOVE '7970' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE BILL_CNTRCT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSBW138 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7970-CLOSE **'        
              DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7970-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *------------------------*                                                
       8000-ISRT-INTERVAL-READ.                                         
      *------------------------*                                                
           MOVE '8000'  TO ACTIVE-PARAGRAPH.                            
           EXEC SQL                                                     
              INSERT INTO CSS_INTERVAL_READ                             
                (METER_NO                                               
                ,BILL_ITEM_TIMESTMP                                     
                ,DATE_READ                                              
                ,TIME_READ                                              
                ,DST_CHNG_IND                                           
                ,CHANNEL_A_PULSES                                       
                ,CHANNEL_A_STATUS                                       
                ,CHANNEL_B_PULSES                                       
                ,CHANNEL_B_STATUS                                       
                ,CHANNEL_C_PULSES                                       
                ,CHANNEL_C_STATUS                                       
                ,CODE_UTIL_TYPE)                                        
              VALUES (                                                  
                 :IV-METER-NO                                           
                ,CIS.CHAR2TIMESTAMP(:IV-BILL-ITEM-TIMESTMP)                     
                ,IIF(TRY_CONVERT(DATE, :IV-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :IV-DATE-READ
              ) <> 0) OR (LEN(:IV-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :IV-DATE-READ
              ), CONVERT(DATE, :IV-DATE-READ) )                                
                ,CIS.CHAR2TIME(:IV-TIME-READ)                                   
                ,:IV-DST-CHNG-IND                                       
                ,:IV-CHANNEL-A-PULSES                                   
                ,:IV-CHANNEL-A-STATUS                                   
                ,:IV-CHANNEL-B-PULSES                                   
                ,:IV-CHANNEL-B-STATUS                                   
                ,:IV-CHANNEL-C-PULSES                                   
                ,:IV-CHANNEL-C-STATUS                                   
                ,:IV-CODE-UTIL-TYPE)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_INTERVAL_READ                                     
MFA-TR*         (METER_NO                                                       
MFA-TR*         ,BILL_ITEM_TIMESTMP                                             
MFA-TR*         ,DATE_READ                                                      
MFA-TR*         ,TIME_READ                                                      
MFA-TR*         ,DST_CHNG_IND                                                   
MFA-TR*         ,CHANNEL_A_PULSES                                               
MFA-TR*         ,CHANNEL_A_STATUS                                               
MFA-TR*         ,CHANNEL_B_PULSES                                               
MFA-TR*         ,CHANNEL_B_STATUS                                               
MFA-TR*         ,CHANNEL_C_PULSES                                               
MFA-TR*         ,CHANNEL_C_STATUS                                               
MFA-TR*         ,CODE_UTIL_TYPE)                                                
MFA-TR*       VALUES (                                                          
MFA-TR*          :IV-METER-NO                                                   
MFA-TR*         ,:IV-BILL-ITEM-TIMESTMP                                         
MFA-TR*         ,:IV-DATE-READ                                                  
MFA-TR*         ,:IV-TIME-READ                                                  
MFA-TR*         ,:IV-DST-CHNG-IND                                               
MFA-TR*         ,:IV-CHANNEL-A-PULSES                                           
MFA-TR*         ,:IV-CHANNEL-A-STATUS                                           
MFA-TR*         ,:IV-CHANNEL-B-PULSES                                           
MFA-TR*         ,:IV-CHANNEL-B-STATUS                                           
MFA-TR*         ,:IV-CHANNEL-C-PULSES                                           
MFA-TR*         ,:IV-CHANNEL-C-STATUS                                           
MFA-TR*         ,:IV-CODE-UTIL-TYPE)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 ADD 1 TO WS-RESTART-IV-ISRT-CNTR-TOT                   
                 ADD 1 TO WS-IV-ISRT-CNTR-LUW                           
              WHEN ALREADY-EXISTS                                       
                 CONTINUE                                               
              WHEN OTHER                                                
                 DISPLAY '8000-INSERT RETURN CODE ='                    
                                 WS-ACTIVE-RETURN-CODE                  
                 DISPLAY 'METER NO. = ' IV-METER-NO                     
                 DISPLAY 'DATE READ. = ' IV-DATE-READ                   
                 DISPLAY 'TIME READ. = ' IV-TIME-READ                   
                 DISPLAY 'BILL ITEM TIMESTMP. = ' IV-BILL-ITEM-TIMESTMP 
                 DISPLAY 'CODE UTIL TYPE. = ' IV-CODE-UTIL-TYPE         
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *------------------------*                                                
       8050-UPDT-INTERVAL-READ.                                         
      *------------------------*                                                
           MOVE '8050' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              UPDATE CSS_INTERVAL_READ                                  
                 SET CHANNEL_A_PULSES = :IV-CHANNEL-A-PULSES            
                    ,CHANNEL_A_STATUS = :IV-CHANNEL-A-STATUS            
                    ,CHANNEL_B_PULSES = :IV-CHANNEL-B-PULSES            
                    ,CHANNEL_B_STATUS = :IV-CHANNEL-B-STATUS            
                    ,CHANNEL_C_PULSES = :IV-CHANNEL-C-PULSES            
                    ,CHANNEL_C_STATUS = :IV-CHANNEL-C-STATUS            
               WHERE METER_NO = :IV-METER-NO                            
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :IV-BILL-ITEM-TIMESTMP
              )        
                 AND DATE_READ = IIF(TRY_CONVERT(DATE, :IV-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :IV-DATE-READ
              ) <> 0) OR (LEN(:IV-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :IV-DATE-READ
              ), CONVERT(DATE, :IV-DATE-READ) )                          
                 AND TIME_READ = CIS.CHAR2TIME(:IV-TIME-READ)                   
                 AND DST_CHNG_IND = :IV-DST-CHNG-IND                    
                 AND CODE_UTIL_TYPE = :IV-CODE-UTIL-TYPE                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_INTERVAL_READ                                          
MFA-TR*          SET CHANNEL_A_PULSES = :IV-CHANNEL-A-PULSES                    
MFA-TR*             ,CHANNEL_A_STATUS = :IV-CHANNEL-A-STATUS                    
MFA-TR*             ,CHANNEL_B_PULSES = :IV-CHANNEL-B-PULSES                    
MFA-TR*             ,CHANNEL_B_STATUS = :IV-CHANNEL-B-STATUS                    
MFA-TR*             ,CHANNEL_C_PULSES = :IV-CHANNEL-C-PULSES                    
MFA-TR*             ,CHANNEL_C_STATUS = :IV-CHANNEL-C-STATUS                    
MFA-TR*        WHERE METER_NO = :IV-METER-NO                                    
MFA-TR*          AND BILL_ITEM_TIMESTMP = :IV-BILL-ITEM-TIMESTMP                
MFA-TR*          AND DATE_READ = :IV-DATE-READ                                  
MFA-TR*          AND TIME_READ = :IV-TIME-READ                                  
MFA-TR*          AND DST_CHNG_IND = :IV-DST-CHNG-IND                            
MFA-TR*          AND CODE_UTIL_TYPE = :IV-CODE-UTIL-TYPE                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1 TO WS-RESTART-IV-UPDT-CNTR-TOT                      
              ADD 1 TO WS-IV-UPDT-CNTR-LUW                              
           ELSE                                                         
              DISPLAY '8050-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
              DISPLAY 'METER NO. = ' IV-METER-NO                        
              DISPLAY 'DATE READ. = ' IV-DATE-READ                      
              DISPLAY 'TIME READ. = ' IV-TIME-READ                      
              DISPLAY 'BILL ITEM TIMESTMP. = ' IV-BILL-ITEM-TIMESTMP    
              DISPLAY 'CODE UTIL TYPE. = ' IV-CODE-UTIL-TYPE            
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8050-EXIT.                                                       
           EXIT.                                                        
      *---------------------*                                                   
       8100-UPDATE-MTRD-ENV.                                            
      *---------------------*                                                   
           MOVE '8100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              UPDATE CSS_MTRD_ENVRNMT                                   
                 SET MIN_NO_UNITS = :MN-MIN-NO-UNITS                    
                    ,MAX_NO_UNITS = :MN-MAX-NO-UNITS                    
C28742              ,LAST_REG_READ_DATE = IIF(TRY_CONVERT(DATE, 
                                                       :WS-MN-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MN-READ-DATE
              ) <> 0) OR (LEN(:WS-MN-READ-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-MN-READ-DATE
              ), CONVERT(DATE, :WS-MN-READ-DATE) )              
C28742              ,LAST_VALID_READ_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-MN-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MN-READ-DATE
              ) <> 0) OR (LEN(:WS-MN-READ-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-MN-READ-DATE
              ), CONVERT(DATE, :WS-MN-READ-DATE) )              
C28742              ,LAST_REG_READ_TIME = CIS.CHAR2TIME(:WS-MN-READ-TIME
              )              
C28742              ,LAST_VALID_READ_TM = CIS.CHAR2TIME(:WS-MN-READ-TIME
              )              
C28742              ,CODE_LAST_REG_READ = :WS-MN-READ-CODE              
C28742              ,CODE_CRNT_REG_READ = :WS-MN-READ-CODE              
C28742              ,CODE_LAST_VALID_RD = :WS-MN-READ-CODE              
C28742              ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO         = :MN-ACCOUNT-NO                
                 AND CODE_UTIL_TYPE     = :WS-UTIL-TYPE                 
C28742           AND IC_NO              = :MN-IC-NO                     
                 AND MTR_REF_NO         = :MN-MTR-REF-NO                
                 AND CODE_METER_STATUS <> 'K'                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_MTRD_ENVRNMT                                           
MFA-TR*          SET MIN_NO_UNITS = :MN-MIN-NO-UNITS                            
MFA-TR*             ,MAX_NO_UNITS = :MN-MAX-NO-UNITS                            
MFA-TR*             ,LAST_REG_READ_DATE = :WS-MN-READ-DATE                      
MFA-TR*             ,LAST_VALID_READ_DT = :WS-MN-READ-DATE                      
MFA-TR*             ,LAST_REG_READ_TIME = :WS-MN-READ-TIME                      
MFA-TR*             ,LAST_VALID_READ_TM = :WS-MN-READ-TIME                      
MFA-TR*             ,CODE_LAST_REG_READ = :WS-MN-READ-CODE                      
MFA-TR*             ,CODE_CRNT_REG_READ = :WS-MN-READ-CODE                      
MFA-TR*             ,CODE_LAST_VALID_RD = :WS-MN-READ-CODE                      
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :MN-ACCOUNT-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :WS-UTIL-TYPE                         
MFA-TR*          AND IC_NO              = :MN-IC-NO                             
MFA-TR*          AND MTR_REF_NO         = :MN-MTR-REF-NO                        
MFA-TR*          AND CODE_METER_STATUS <> 'K'                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              ADD 1 TO WS-RESTART-MN-UPDT-CNTR-TOT                      
              ADD 1 TO WS-MN-UPDT-CNTR-LUW                              
           ELSE                                                         
              DISPLAY '8100-UPDATE RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'METER NO. = ' MN-METER-NO                        
              DISPLAY 'ACCOUNT NO. = ' MN-ACCOUNT-NO                    
              DISPLAY 'CODE UTIL TYPE. = ' MN-CODE-UTIL-TYPE            
              DISPLAY 'CODE MTR STATUS. = ' MN-CODE-METER-STATUS        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *        THIS INCLUDE INSERTS READINGS                       *            
      *                    IN CONSUMPTION HISTORY                  *            
      **************************************************************            
       8200-ISRT-CNSMPTN-HIST.                                          
      *                                                                         
           MOVE '8200' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              INSERT INTO CSS_CNSMPTN_HIST                              
                    (ACCOUNT_NO                                         
                    ,BILL_NO                                            
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,BILL_ITEM_TIMESTMP                                 
                    ,CODE_TIME_PERIOD                                   
                    ,MTR_REF_NO                                         
                    ,CODE_USAGE_TYPE                                    
                    ,CODE_USAGE_ID                                      
                    ,CODE_USAGE_SOURCE                                  
                    ,ITEM_SEQ_NO                                        
                    ,METER_NO                                           
                    ,REG_ID_NO                                          
                    ,DATE_READ                                          
                    ,CODE_METER_READ                                    
                    ,CODE_METER_NO_READ                                 
                    ,METER_READING                                      
                    ,DEMAND_READING                                     
                    ,EMPLOYEE_NO                                        
                    ,NO_UNITS                                           
                    ,NO_DEMAND_UNITS                                    
                    ,NO_DAYS                                            
                    ,CODE_SOURCE_ID                                     
                    ,CODE_DEBIT_CREDIT                                  
                    ,CODE_ITEM_STATUS                                   
                    ,CODE_DISCOUNT                                      
                    ,CONSTANT                                           
                    ,NO_DIALS                                           
                    ,CODE_TOU_SEASN                                     
                    ,COMPANY_NO                                         
                    ,MTR_READ_SOURCE_CD                                 
                    ,DIGTL_MTR_TYPE                                     
                    ,BTU_FACTOR                                         
                    ,EXCL_DMD_RCHT_IND)                                 
             VALUES (:CX-ACCOUNT-NO, :CX-BILL-NO, :CX-CODE-UTIL-TYPE,   
                     :CX-IC-NO, CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              ),                 
                     :CX-CODE-TIME-PERIOD, :CX-MTR-REF-NO,              
                     :CX-CODE-USAGE-TYPE, :CX-CODE-USAGE-ID,            
                     :CX-CODE-USAGE-SOURCE, :CX-ITEM-SEQ-NO,            
                     :CX-METER-NO, :CX-REG-ID-NO,                       
                     IIF(TRY_CONVERT(DATE, :CX-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ
              ) <> 0) OR (LEN(:CX-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :CX-DATE-READ
              ), CONVERT(DATE, :CX-DATE-READ) ), :CX-CODE-METER-READ,          
                     :CX-CODE-METER-NO-READ, :CX-METER-READING,         
                     :CX-DEMAND-READING, :CX-EMPLOYEE-NO, :CX-NO-UNITS, 
                     :CX-NO-DEMAND-UNITS, :CX-NO-DAYS,                  
                     :CX-CODE-SOURCE-ID,                                
                     :CX-CODE-DEBIT-CREDIT, :CX-CODE-ITEM-STATUS,       
                     :CX-CODE-DISCOUNT, :CX-CONSTANT, :CX-NO-DIALS,     
                     :CX-CODE-TOU-SEASN, :CX-COMPANY-NO,                
                     :CX-MTR-READ-SOURCE-CD, :CX-DIGTL-MTR-TYPE,        
                     :CX-BTU-FACTOR,                                    
                     :CX-EXCL-DMD-RCHT-IND)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CNSMPTN_HIST                                      
MFA-TR*             (ACCOUNT_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,CODE_USAGE_TYPE                                            
MFA-TR*             ,CODE_USAGE_ID                                              
MFA-TR*             ,CODE_USAGE_SOURCE                                          
MFA-TR*             ,ITEM_SEQ_NO                                                
MFA-TR*             ,METER_NO                                                   
MFA-TR*             ,REG_ID_NO                                                  
MFA-TR*             ,DATE_READ                                                  
MFA-TR*             ,CODE_METER_READ                                            
MFA-TR*             ,CODE_METER_NO_READ                                         
MFA-TR*             ,METER_READING                                              
MFA-TR*             ,DEMAND_READING                                             
MFA-TR*             ,EMPLOYEE_NO                                                
MFA-TR*             ,NO_UNITS                                                   
MFA-TR*             ,NO_DEMAND_UNITS                                            
MFA-TR*             ,NO_DAYS                                                    
MFA-TR*             ,CODE_SOURCE_ID                                             
MFA-TR*             ,CODE_DEBIT_CREDIT                                          
MFA-TR*             ,CODE_ITEM_STATUS                                           
MFA-TR*             ,CODE_DISCOUNT                                              
MFA-TR*             ,CONSTANT                                                   
MFA-TR*             ,NO_DIALS                                                   
MFA-TR*             ,CODE_TOU_SEASN                                             
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,MTR_READ_SOURCE_CD                                         
MFA-TR*             ,DIGTL_MTR_TYPE                                             
MFA-TR*             ,BTU_FACTOR                                                 
MFA-TR*             ,EXCL_DMD_RCHT_IND)                                         
MFA-TR*      VALUES (:CX-ACCOUNT-NO, :CX-BILL-NO, :CX-CODE-UTIL-TYPE,           
MFA-TR*              :CX-IC-NO, :CX-BILL-ITEM-TIMESTMP,                         
MFA-TR*              :CX-CODE-TIME-PERIOD, :CX-MTR-REF-NO,                      
MFA-TR*              :CX-CODE-USAGE-TYPE, :CX-CODE-USAGE-ID,                    
MFA-TR*              :CX-CODE-USAGE-SOURCE, :CX-ITEM-SEQ-NO,                    
MFA-TR*              :CX-METER-NO, :CX-REG-ID-NO,                               
MFA-TR*              :CX-DATE-READ, :CX-CODE-METER-READ,                        
MFA-TR*              :CX-CODE-METER-NO-READ, :CX-METER-READING,                 
MFA-TR*              :CX-DEMAND-READING, :CX-EMPLOYEE-NO, :CX-NO-UNITS,         
MFA-TR*              :CX-NO-DEMAND-UNITS, :CX-NO-DAYS,                          
MFA-TR*              :CX-CODE-SOURCE-ID,                                        
MFA-TR*              :CX-CODE-DEBIT-CREDIT, :CX-CODE-ITEM-STATUS,               
MFA-TR*              :CX-CODE-DISCOUNT, :CX-CONSTANT, :CX-NO-DIALS,             
MFA-TR*              :CX-CODE-TOU-SEASN, :CX-COMPANY-NO,                        
MFA-TR*              :CX-MTR-READ-SOURCE-CD, :CX-DIGTL-MTR-TYPE,                
MFA-TR*              :CX-BTU-FACTOR,                                            
MFA-TR*              :CX-EXCL-DMD-RCHT-IND)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 ADD 1 TO WS-CHKP-UPD-COUNTER                           
                 ADD 1 TO WS-RESTART-CX-ISRT-CNTR-TOT                   
                 ADD 1 TO WS-CX-ISRT-CNTR-LUW                           
                 ADD 1 TO WS-COUNT-GAS                                  
              WHEN ALREADY-EXISTS                                       
                 CONTINUE                                               
              WHEN OTHER                                                
                 DISPLAY '8200-INSERT RETURN CODE ='                    
                                      WS-ACTIVE-RETURN-CODE             
                 DISPLAY 'ACCOUNT NO. = ' CX-ACCOUNT-NO                 
                 DISPLAY 'BILL NO. = ' CX-BILL-NO                       
                 DISPLAY 'IC NO. = ' CX-IC-NO                           
                 DISPLAY 'METER REFERENCE NO. = ' CX-MTR-REF-NO         
                 DISPLAY 'REGISTER ID NO. = ' CX-REG-ID-NO              
                 DISPLAY 'SEQUENCE NO. = ' CX-ITEM-SEQ-NO               
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *-----------------------*                                                 
       8300-UPDT-CNSMPTN-HIST.                                          
      *-----------------------*                                                 
           MOVE '8300'  TO ACTIVE-PARAGRAPH.                            
           EXEC SQL                                                     
              UPDATE CSS_CNSMPTN_HIST                                   
                 SET DATE_READ = IIF(TRY_CONVERT(DATE, :CX-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ
              ) <> 0) OR (LEN(:CX-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :CX-DATE-READ
              ), CONVERT(DATE, :CX-DATE-READ) )                          
                    ,CODE_METER_READ = :CX-CODE-METER-READ              
                    ,NO_UNITS = :CX-NO-UNITS                            
                    ,CONSTANT = :CX-CONSTANT                            
                    ,BTU_FACTOR = :CX-BTU-FACTOR                        
               WHERE ACCOUNT_NO = :CX-ACCOUNT-NO                        
                 AND BILL_NO    = :CX-BILL-NO                           
                 AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                
                 AND IC_NO = :CX-IC-NO                                  
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )        
                 AND CODE_TIME_PERIOD = :CX-CODE-TIME-PERIOD            
                 AND MTR_REF_NO = :CX-MTR-REF-NO                        
                 AND METER_NO = :CX-METER-NO                            
                 AND ITEM_SEQ_NO = :CX-ITEM-SEQ-NO                      
                 AND REG_ID_NO = :CX-REG-ID-NO                          
                 AND CODE_USAGE_SOURCE = :WS-J                          
                 AND CODE_DEBIT_CREDIT = :WS-CREDIT                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CNSMPTN_HIST                                           
MFA-TR*          SET DATE_READ = :CX-DATE-READ                                  
MFA-TR*             ,CODE_METER_READ = :CX-CODE-METER-READ                      
MFA-TR*             ,NO_UNITS = :CX-NO-UNITS                                    
MFA-TR*             ,CONSTANT = :CX-CONSTANT                                    
MFA-TR*             ,BTU_FACTOR = :CX-BTU-FACTOR                                
MFA-TR*        WHERE ACCOUNT_NO = :CX-ACCOUNT-NO                                
MFA-TR*          AND BILL_NO    = :CX-BILL-NO                                   
MFA-TR*          AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO = :CX-IC-NO                                          
MFA-TR*          AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP                
MFA-TR*          AND CODE_TIME_PERIOD = :CX-CODE-TIME-PERIOD                    
MFA-TR*          AND MTR_REF_NO = :CX-MTR-REF-NO                                
MFA-TR*          AND METER_NO = :CX-METER-NO                                    
MFA-TR*          AND ITEM_SEQ_NO = :CX-ITEM-SEQ-NO                              
MFA-TR*          AND REG_ID_NO = :CX-REG-ID-NO                                  
MFA-TR*          AND CODE_USAGE_SOURCE = :WS-J                                  
MFA-TR*          AND CODE_DEBIT_CREDIT = :WS-CREDIT                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1 TO WS-CHKP-UPD-COUNTER                              
              ADD 1 TO WS-RESTART-CX-UPDT-CNTR-TOT                      
              ADD 1 TO WS-CX-UPDT-CNTR-LUW                              
              ADD 1 TO WS-COUNT-GAS                                     
           ELSE                                                         
              DISPLAY '8300-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
              DISPLAY 'ACCOUNT NO. = ' CX-ACCOUNT-NO                    
              DISPLAY 'BILL NO. = ' CX-BILL-NO                          
              DISPLAY 'IC NO. = ' CX-IC-NO                              
              DISPLAY 'METER REFERENCE NO. = ' CX-MTR-REF-NO            
              DISPLAY 'REGISTER ID NO. = ' CX-REG-ID-NO                 
              DISPLAY 'SEQUENCE NO. = ' CX-ITEM-SEQ-NO                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *----------------------*                                                  
       8350-UPDT-CX-NO-UNITS.                                           
      *----------------------*                                                  
           MOVE '8350'  TO ACTIVE-PARAGRAPH.                            
           EXEC SQL                                                     
              UPDATE CSS_CNSMPTN_HIST                                   
                 SET NO_UNITS = :CX-NO-UNITS                            
                    ,BTU_FACTOR = :CX-BTU-FACTOR                        
C28742              ,CONSTANT        = :CX-CONSTANT                     
C28742              ,CODE_METER_READ = :CX-CODE-METER-READ              
               WHERE ACCOUNT_NO = :CX-ACCOUNT-NO                        
                 AND BILL_NO    = :CX-BILL-NO                           
                 AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                
                 AND IC_NO = :CX-IC-NO                                  
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )        
                 AND CODE_TIME_PERIOD = :CX-CODE-TIME-PERIOD            
                 AND MTR_REF_NO = :CX-MTR-REF-NO                        
                 AND METER_NO = :CX-METER-NO                            
                 AND ITEM_SEQ_NO = :CX-ITEM-SEQ-NO                      
                 AND REG_ID_NO = :CX-REG-ID-NO                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CNSMPTN_HIST                                           
MFA-TR*          SET NO_UNITS = :CX-NO-UNITS                                    
MFA-TR*             ,BTU_FACTOR = :CX-BTU-FACTOR                                
MFA-TR*             ,CONSTANT        = :CX-CONSTANT                             
MFA-TR*             ,CODE_METER_READ = :CX-CODE-METER-READ                      
MFA-TR*        WHERE ACCOUNT_NO = :CX-ACCOUNT-NO                                
MFA-TR*          AND BILL_NO    = :CX-BILL-NO                                   
MFA-TR*          AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO = :CX-IC-NO                                          
MFA-TR*          AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP                
MFA-TR*          AND CODE_TIME_PERIOD = :CX-CODE-TIME-PERIOD                    
MFA-TR*          AND MTR_REF_NO = :CX-MTR-REF-NO                                
MFA-TR*          AND METER_NO = :CX-METER-NO                                    
MFA-TR*          AND ITEM_SEQ_NO = :CX-ITEM-SEQ-NO                              
MFA-TR*          AND REG_ID_NO = :CX-REG-ID-NO                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1 TO WS-CHKP-UPD-COUNTER                              
              ADD 1 TO WS-RESTART-CX-UPDT-CNTR-TOT                      
              ADD 1 TO WS-CX-UPDT-CNTR-LUW                              
              ADD 1 TO WS-COUNT-GAS                                     
           ELSE                                                         
              DISPLAY '8350-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
              DISPLAY 'ACCOUNT NO. = ' CX-ACCOUNT-NO                    
              DISPLAY 'BILL NO. = ' CX-BILL-NO                          
              DISPLAY 'IC NO. = ' CX-IC-NO                              
              DISPLAY 'METER REFERENCE NO. = ' CX-MTR-REF-NO            
              DISPLAY 'REGISTER ID NO. = ' CX-REG-ID-NO                 
              DISPLAY 'SEQUENCE NO. = ' CX-ITEM-SEQ-NO                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8350-EXIT.                                                       
           EXIT.                                                        
      *----------------------*                                                  
       8400-ISRT-BILLING-HDR.                                           
      *----------------------*                                                  
           MOVE '8400' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               INSERT INTO CSS_BILLING_HDR                              
                 (ACCOUNT_NO,                                           
                  PREMISE_NO,                                           
                  BILL_NO,                                              
                  DATE_BILLED,                                          
                  CODE_BILL_REASON,                                     
                  CODE_BILL_STATUS,                                     
                  CODE_BILL_TYPE,                                       
                  COMPANY_NO,                                           
                  CUSTOMER_NO,                                          
                  CODE_SPCL_BILL,                                       
                  PREM_ACCT_SEQ_NO,                                     
                  SMRY_BILL_NO,                                         
                  SMRY_REBILL_NO)                                       
               VALUES                                                   
                 (:BI-ACCOUNT-NO,                                       
                  :BI-PREMISE-NO,                                       
                  :BI-BILL-NO,                                          
                  IIF(TRY_CONVERT(DATE, :BI-DATE-BILLED :IND-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED 
                                                       :IND-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED :IND-DATE-BILLED
              ) <> 10), CIS.CHAR2DATE(:BI-DATE-BILLED :IND-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED :IND-DATE-BILLED) ),            
                  :BI-CODE-BILL-REASON,                                 
                  :BI-CODE-BILL-STATUS,                                 
                  :BI-CODE-BILL-TYPE,                                   
                  :BI-COMPANY-NO,                                       
                  :BI-CUSTOMER-NO,                                      
                  :BI-CODE-SPCL-BILL,                                   
                  :BI-PREM-ACCT-SEQ-NO,                                 
                  :BI-SMRY-BILL-NO,                                     
                  :BI-SMRY-REBILL-NO)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILLING_HDR                                      
MFA-TR*          (ACCOUNT_NO,                                                   
MFA-TR*           PREMISE_NO,                                                   
MFA-TR*           BILL_NO,                                                      
MFA-TR*           DATE_BILLED,                                                  
MFA-TR*           CODE_BILL_REASON,                                             
MFA-TR*           CODE_BILL_STATUS,                                             
MFA-TR*           CODE_BILL_TYPE,                                               
MFA-TR*           COMPANY_NO,                                                   
MFA-TR*           CUSTOMER_NO,                                                  
MFA-TR*           CODE_SPCL_BILL,                                               
MFA-TR*           PREM_ACCT_SEQ_NO,                                             
MFA-TR*           SMRY_BILL_NO,                                                 
MFA-TR*           SMRY_REBILL_NO)                                               
MFA-TR*        VALUES                                                           
MFA-TR*          (:BI-ACCOUNT-NO,                                               
MFA-TR*           :BI-PREMISE-NO,                                               
MFA-TR*           :BI-BILL-NO,                                                  
MFA-TR*           :BI-DATE-BILLED:IND-DATE-BILLED,                              
MFA-TR*           :BI-CODE-BILL-REASON,                                         
MFA-TR*           :BI-CODE-BILL-STATUS,                                         
MFA-TR*           :BI-CODE-BILL-TYPE,                                           
MFA-TR*           :BI-COMPANY-NO,                                               
MFA-TR*           :BI-CUSTOMER-NO,                                              
MFA-TR*           :BI-CODE-SPCL-BILL,                                           
MFA-TR*           :BI-PREM-ACCT-SEQ-NO,                                         
MFA-TR*           :BI-SMRY-BILL-NO,                                             
MFA-TR*           :BI-SMRY-REBILL-NO)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD 1 TO WS-RESTART-BI-ISRT-CNTR-TOT                     
               ADD 1 TO WS-BI-ISRT-CNTR-LUW                             
           ELSE                                                         
               DISPLAY '8400-INSERT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *------------------------*                                                
       8500-INSERT-BILLING-DET.                                         
      *------------------------*                                                
           MOVE '8500' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              INSERT INTO CSS_BILLING_DET                               
                     (ACCOUNT_NO,                                       
                      PREMISE_NO,                                       
                      BILL_NO,                                          
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      BILL_ITEM_TIMESTMP,                               
                      DATE_ORIG_BILL,                                   
                      AMT_BILL_ITEM,                                    
                      COMPANY_NO,                                       
                      CODE_BILL_CALC,                                   
                      CODE_BILL_ITM_TYPE,                               
                      CODE_BILL_ITM_IND,                                
                      CODE_DR_CR_CNSMPTN,                               
                      AMT_STATE_TAX,                                    
                      AMT_CITY_TAX,                                     
                      AMT_OTHER_TAX,                                    
                      CODE_REVENUE_CLASS,                               
                      CODE_SIC_NO,                                      
                      RATE_PLAN_NO,                                     
                      CODE_CURTAIL_PRTY,                                
                      CODE_STAT_TAX_XMT,                                
                      CODE_CITY_TAX_XMT,                                
                      CODE_OTHR_TAX_XMT,                                
                      REV_MTH_ORIG_BILL,                                
                      REV_DISTRICT_CD)                                  
           VALUES    (:BG-ACCOUNT-NO,                                   
                      :BG-PREMISE-NO,                                   
                      :BG-BILL-NO,                                      
                      :BG-CODE-UTIL-TYPE,                               
                      :BG-IC-NO,                                        
                      CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP),               
                      IIF(TRY_CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                            :IND-DATE-ORIG-BILL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL 
                                                    :IND-DATE-ORIG-BILL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL :IND-DATE-ORIG-BILL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL 
                                                    :IND-DATE-ORIG-BILL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL :IND-DATE-ORIG-BILL
              ) ),            
                      :BG-AMT-BILL-ITEM,                                
                      :BG-COMPANY-NO,                                   
                      :BG-CODE-BILL-CALC,                               
                      :BG-CODE-BILL-ITM-TYPE,                           
                      :BG-CODE-BILL-ITM-IND,                            
                      :BG-CODE-DR-CR-CNSMPTN,                           
                      :BG-AMT-STATE-TAX,                                
                      :BG-AMT-CITY-TAX,                                 
                      :BG-AMT-OTHER-TAX,                                
                      :BG-CODE-REVENUE-CLASS,                           
                      :BG-CODE-SIC-NO,                                  
                      :BG-RATE-PLAN-NO,                                 
                      :BG-CODE-CURTAIL-PRTY,                            
                      :BG-CODE-STAT-TAX-XMT,                            
                      :BG-CODE-CITY-TAX-XMT,                            
                      :BG-CODE-OTHR-TAX-XMT,                            
                      :BG-REV-MTH-ORIG-BILL,                            
                      :BG-REV-DISTRICT-CD)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_BILLING_DET                                       
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               BILL_NO,                                                  
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               IC_NO,                                                    
MFA-TR*               BILL_ITEM_TIMESTMP,                                       
MFA-TR*               DATE_ORIG_BILL,                                           
MFA-TR*               AMT_BILL_ITEM,                                            
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               CODE_BILL_CALC,                                           
MFA-TR*               CODE_BILL_ITM_TYPE,                                       
MFA-TR*               CODE_BILL_ITM_IND,                                        
MFA-TR*               CODE_DR_CR_CNSMPTN,                                       
MFA-TR*               AMT_STATE_TAX,                                            
MFA-TR*               AMT_CITY_TAX,                                             
MFA-TR*               AMT_OTHER_TAX,                                            
MFA-TR*               CODE_REVENUE_CLASS,                                       
MFA-TR*               CODE_SIC_NO,                                              
MFA-TR*               RATE_PLAN_NO,                                             
MFA-TR*               CODE_CURTAIL_PRTY,                                        
MFA-TR*               CODE_STAT_TAX_XMT,                                        
MFA-TR*               CODE_CITY_TAX_XMT,                                        
MFA-TR*               CODE_OTHR_TAX_XMT,                                        
MFA-TR*               REV_MTH_ORIG_BILL,                                        
MFA-TR*               REV_DISTRICT_CD)                                          
MFA-TR*    VALUES    (:BG-ACCOUNT-NO,                                           
MFA-TR*               :BG-PREMISE-NO,                                           
MFA-TR*               :BG-BILL-NO,                                              
MFA-TR*               :BG-CODE-UTIL-TYPE,                                       
MFA-TR*               :BG-IC-NO,                                                
MFA-TR*               :BG-BILL-ITEM-TIMESTMP,                                   
MFA-TR*               :BG-DATE-ORIG-BILL:IND-DATE-ORIG-BILL,                    
MFA-TR*               :BG-AMT-BILL-ITEM,                                        
MFA-TR*               :BG-COMPANY-NO,                                           
MFA-TR*               :BG-CODE-BILL-CALC,                                       
MFA-TR*               :BG-CODE-BILL-ITM-TYPE,                                   
MFA-TR*               :BG-CODE-BILL-ITM-IND,                                    
MFA-TR*               :BG-CODE-DR-CR-CNSMPTN,                                   
MFA-TR*               :BG-AMT-STATE-TAX,                                        
MFA-TR*               :BG-AMT-CITY-TAX,                                         
MFA-TR*               :BG-AMT-OTHER-TAX,                                        
MFA-TR*               :BG-CODE-REVENUE-CLASS,                                   
MFA-TR*               :BG-CODE-SIC-NO,                                          
MFA-TR*               :BG-RATE-PLAN-NO,                                         
MFA-TR*               :BG-CODE-CURTAIL-PRTY,                                    
MFA-TR*               :BG-CODE-STAT-TAX-XMT,                                    
MFA-TR*               :BG-CODE-CITY-TAX-XMT,                                    
MFA-TR*               :BG-CODE-OTHR-TAX-XMT,                                    
MFA-TR*               :BG-REV-MTH-ORIG-BILL,                                    
MFA-TR*               :BG-REV-DISTRICT-CD)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1 TO WS-RESTART-BG-ISRT-CNTR-TOT                      
              ADD 1 TO WS-BG-ISRT-CNTR-LUW                              
           ELSE                                                         
              DISPLAY '8500-INSERT RETURN CODE=' WS-ACTIVE-RETURN-CODE  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *--------------------*                                                    
       8550-UPDATE-ACCOUNT.                                             
      *--------------------*                                                    
           MOVE '8550' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET NXT_BILL_NO = :AT-NXT-BILL-NO                     
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD 1 TO WS-RESTART-AT-UPDT-CNTR-TOT                     
               ADD 1 TO WS-AT-UPDT-CNTR-LUW                             
           ELSE                                                         
               DISPLAY '8550 RETURN CODE =' WS-ACTIVE-RETURN-CODE       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       8550-EXIT.                                                       
            EXIT.                                                       
      *-------------------------*                                               
       8600-ISRT-MTR-IDENT-HIST.                                        
      *-------------------------*                                               
           MOVE '8600' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              INSERT INTO CSS_MTR_IDENT_HIST                            
                    (ACCOUNT_NO                                         
                    ,BILL_NO                                            
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,BILL_ITEM_TIMESTMP                                 
                    ,MTR_REF_NO                                         
                    ,METER_NO                                           
                    ,IDR_IDENT_NO                                       
                    ,INTERVALS_PER_HR                                   
                    ,CHANNEL_A_UOM                                      
                    ,CHANNEL_B_UOM                                      
                    ,CHANNEL_C_UOM                                      
                    ,IDR_INFO_RETENT_DT                                 
                    ,CT_UPPER_RATIO                                     
                    ,PT_UPPER_RATIO                                     
                    ,CT_LOWER_RATIO                                     
                    ,PT_LOWER_RATIO                                     
                    ,INDUST_BTU_ID)                                     
             VALUES (:GA-ACCOUNT-NO, :GA-BILL-NO, :GA-CODE-UTIL-TYPE,   
                     :GA-IC-NO, CIS.CHAR2TIMESTAMP(
                                                 :GA-BILL-ITEM-TIMESTMP
              ),                 
                     :GA-MTR-REF-NO, :GA-METER-NO,                      
                     :GA-IDR-IDENT-NO, :GA-INTERVALS-PER-HR,            
                     :GA-CHANNEL-A-UOM, :GA-CHANNEL-B-UOM,              
                     :GA-CHANNEL-C-UOM, IIF(TRY_CONVERT(DATE, 
                                                 :GA-IDR-INFO-RETENT-DT
              ) IS NULL OR (PATINDEX('%.%', :GA-IDR-INFO-RETENT-DT
              ) <> 0) OR (LEN(:GA-IDR-INFO-RETENT-DT
              ) <> 10), CIS.CHAR2DATE(:GA-IDR-INFO-RETENT-DT
              ), CONVERT(DATE, :GA-IDR-INFO-RETENT-DT) ),         
                     :GA-CT-UPPER-RATIO, :GA-PT-UPPER-RATIO,            
                     :GA-CT-LOWER-RATIO, :GA-PT-LOWER-RATIO,            
                     :GA-INDUST-BTU-ID)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MTR_IDENT_HIST                                    
MFA-TR*             (ACCOUNT_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,METER_NO                                                   
MFA-TR*             ,IDR_IDENT_NO                                               
MFA-TR*             ,INTERVALS_PER_HR                                           
MFA-TR*             ,CHANNEL_A_UOM                                              
MFA-TR*             ,CHANNEL_B_UOM                                              
MFA-TR*             ,CHANNEL_C_UOM                                              
MFA-TR*             ,IDR_INFO_RETENT_DT                                         
MFA-TR*             ,CT_UPPER_RATIO                                             
MFA-TR*             ,PT_UPPER_RATIO                                             
MFA-TR*             ,CT_LOWER_RATIO                                             
MFA-TR*             ,PT_LOWER_RATIO                                             
MFA-TR*             ,INDUST_BTU_ID)                                             
MFA-TR*      VALUES (:GA-ACCOUNT-NO, :GA-BILL-NO, :GA-CODE-UTIL-TYPE,           
MFA-TR*              :GA-IC-NO, :GA-BILL-ITEM-TIMESTMP,                         
MFA-TR*              :GA-MTR-REF-NO, :GA-METER-NO,                              
MFA-TR*              :GA-IDR-IDENT-NO, :GA-INTERVALS-PER-HR,                    
MFA-TR*              :GA-CHANNEL-A-UOM, :GA-CHANNEL-B-UOM,                      
MFA-TR*              :GA-CHANNEL-C-UOM, :GA-IDR-INFO-RETENT-DT,                 
MFA-TR*              :GA-CT-UPPER-RATIO, :GA-PT-UPPER-RATIO,                    
MFA-TR*              :GA-CT-LOWER-RATIO, :GA-PT-LOWER-RATIO,                    
MFA-TR*              :GA-INDUST-BTU-ID)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
      *          ADD 1 TO WS-CHKP-UPD-COUNTER                                   
                 ADD 1 TO WS-RESTART-GA-ISRT-CNTR-TOT                   
                 ADD 1 TO WS-GA-ISRT-CNTR-LUW                           
              WHEN ALREADY-EXISTS                                       
                 CONTINUE                                               
              WHEN OTHER                                                
                 DISPLAY '8600-INSERT RETURN CODE ='                    
                                      WS-ACTIVE-RETURN-CODE             
                 DISPLAY 'ACCOUNT NO. = ' GA-ACCOUNT-NO                 
                 DISPLAY 'BILL NO. = ' GA-BILL-NO                       
                 DISPLAY 'IC NO. = ' GA-IC-NO                           
                 DISPLAY 'METER REFERENCE NO. = ' GA-MTR-REF-NO         
                 DISPLAY 'METER NO. = ' GA-METER-NO                     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *------------------------*                                                
       8650-UPDT-MTR-IDENT-HIST.                                        
      *------------------------*                                                
           MOVE '8650'  TO ACTIVE-PARAGRAPH.                            
           EXEC SQL                                                     
              UPDATE CSS_MTR_IDENT_HIST                                 
                 SET INDUST_BTU_ID = :GA-INDUST-BTU-ID                  
               WHERE ACCOUNT_NO = :GA-ACCOUNT-NO                        
                 AND BILL_NO    = :GA-BILL-NO                           
                 AND CODE_UTIL_TYPE = :GA-CODE-UTIL-TYPE                
                 AND IC_NO = :GA-IC-NO                                  
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :GA-BILL-ITEM-TIMESTMP
              )        
                 AND MTR_REF_NO = :GA-MTR-REF-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_MTR_IDENT_HIST                                         
MFA-TR*          SET INDUST_BTU_ID = :GA-INDUST-BTU-ID                          
MFA-TR*        WHERE ACCOUNT_NO = :GA-ACCOUNT-NO                                
MFA-TR*          AND BILL_NO    = :GA-BILL-NO                                   
MFA-TR*          AND CODE_UTIL_TYPE = :GA-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO = :GA-IC-NO                                          
MFA-TR*          AND BILL_ITEM_TIMESTMP = :GA-BILL-ITEM-TIMESTMP                
MFA-TR*          AND MTR_REF_NO = :GA-MTR-REF-NO                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *          AND METER_NO = :GA-METER-NO                                    
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
      *       ADD 1 TO WS-CHKP-UPD-COUNTER                                      
              ADD 1 TO WS-RESTART-GA-UPDT-CNTR-TOT                      
              ADD 1 TO WS-GA-UPDT-CNTR-LUW                              
           ELSE                                                         
              DISPLAY '8650-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
              DISPLAY 'ACCOUNT NO. = ' GA-ACCOUNT-NO                    
              DISPLAY 'BILL NO. = ' GA-BILL-NO                          
              DISPLAY 'IC NO. = ' GA-IC-NO                              
              DISPLAY 'METER REF NO. = ' GA-MTR-REF-NO                  
              DISPLAY 'METER NO. = ' GA-METER-NO                        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8650-EXIT.                                                       
           EXIT.                                                        
      *--------------------*                                                    
       8180-PRINT-COUNTERS.                                             
      *--------------------*                                                    
           MOVE '8180' TO ACTIVE-PARAGRAPH.                             
           MOVE WS-RESTART-MN-UPDT-CNTR-TOT TO WS-DISP-MN-UCNTR.        
           MOVE WS-RESTART-BI-ISRT-CNTR-TOT TO WS-DISP-BI-ICNTR.        
           MOVE WS-RESTART-BG-ISRT-CNTR-TOT TO WS-DISP-BG-ICNTR.        
           MOVE WS-RESTART-BG-UPDT-CNTR-TOT TO WS-DISP-BG-UCNTR.        
           MOVE WS-RESTART-CX-ISRT-CNTR-TOT TO WS-DISP-CX-ICNTR.        
           MOVE WS-RESTART-CX-UPDT-CNTR-TOT TO WS-DISP-CX-UCNTR.        
           MOVE WS-RESTART-IV-ISRT-CNTR-TOT TO WS-DISP-IV-ICNTR.        
           MOVE WS-RESTART-IV-UPDT-CNTR-TOT TO WS-DISP-IV-UCNTR.        
           MOVE WS-RESTART-GA-ISRT-CNTR-TOT TO WS-DISP-GA-ICNTR.        
           MOVE WS-RESTART-GA-UPDT-CNTR-TOT TO WS-DISP-GA-UCNTR.        
           MOVE WS-RESTART-AT-UPDT-CNTR-TOT TO WS-DISP-AT-UCNTR.        
           MOVE WS-RESTART-RF-ISRT-CNTR-TOT TO WS-DISP-RF-ICNTR.        
           MOVE WS-RESTART-RF-UPDT-CNTR-TOT TO WS-DISP-RF-UCNTR.        
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY '*****   I/O COUNTERS FOR PCSBW138   *****'.         
           DISPLAY ' '.                                                 
           DISPLAY '** TOTAL MN UPDATES            = ' WS-DISP-MN-UCNTR.
           DISPLAY '** TOTAL BI INSERTS            = ' WS-DISP-BI-ICNTR.
           DISPLAY '** TOTAL BG INSERTS            = ' WS-DISP-BG-ICNTR.
           DISPLAY '** TOTAL BG UPDATES            = ' WS-DISP-BG-UCNTR.
           DISPLAY '** TOTAL CX INSERTS            = ' WS-DISP-CX-ICNTR.
           DISPLAY '** TOTAL CX UPDATES            = ' WS-DISP-CX-UCNTR.
           DISPLAY '** TOTAL IV INSERTS            = ' WS-DISP-IV-ICNTR.
           DISPLAY '** TOTAL IV UPDATES            = ' WS-DISP-IV-UCNTR.
           DISPLAY '** TOTAL GA INSERTS            = ' WS-DISP-GA-ICNTR.
           DISPLAY '** TOTAL GA UPDATES            = ' WS-DISP-GA-UCNTR.
           DISPLAY '** TOTAL AT UPDATES            = ' WS-DISP-AT-UCNTR.
           DISPLAY '** TOTAL RF INSERTS            = ' WS-DISP-RF-ICNTR.
           DISPLAY '** TOTAL RF UPDATES            = ' WS-DISP-RF-UCNTR.
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
      *                                                                         
       8180-EXIT.                                                       
           EXIT.                                                        
      *--------------------*                                                    
       8181-PRINT-COUNTERS.                                             
      *--------------------*                                                    
           MOVE '8181' TO ACTIVE-PARAGRAPH.                             
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY '** I/O COUNTERS FOR 1 LUW IN PCSBW138  **'.         
           DISPLAY ' '.                                                 
           DISPLAY '** RECORDS PROCESSED= ' WS-FCSBW05-REC-CNTR.        
           DISPLAY '** MN UPDATES = ' WS-MN-UPDT-CNTR-LUW.              
           DISPLAY '** BI INSERTS = ' WS-BI-ISRT-CNTR-LUW.              
           DISPLAY '** BG INSERTS = ' WS-BG-ISRT-CNTR-LUW.              
           DISPLAY '** BG UPDATES = ' WS-BG-UPDT-CNTR-LUW.              
           DISPLAY '** CX INSERTS = ' WS-CX-ISRT-CNTR-LUW.              
           DISPLAY '** CX UPDATES = ' WS-CX-UPDT-CNTR-LUW.              
           DISPLAY '** IV INSERTS = ' WS-IV-ISRT-CNTR-LUW.              
           DISPLAY '** IV UPDATES = ' WS-IV-UPDT-CNTR-LUW.              
           DISPLAY '** GA INSERTS = ' WS-GA-ISRT-CNTR-LUW.              
           DISPLAY '** GA UPDATES = ' WS-GA-UPDT-CNTR-LUW.              
           DISPLAY '** AT UPDATES = ' WS-AT-UPDT-CNTR-LUW.              
           DISPLAY '** RF INSERTS = ' WS-RF-ISRT-CNTR-LUW.              
           DISPLAY '** RF UPDATES = ' WS-RF-UPDT-CNTR-LUW.              
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
      *                                                                         
       8181-EXIT.                                                       
           EXIT.                                                        
A04860*--------------------*                                                    
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*--------------------*                                                    
A04860*                                                                         
A04860     CALL SCSCB077  USING   CWS00077-FIELDS,                      
A04860                            ABEND-FILE,                           
A04860                            RS-RETURN-CODE.                       
A04860*                                                                         
A04860     MOVE RS-RETURN-CODE          TO WS-ACTIVE-RETURN-CODE.       
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'COMMENTS        ' WS-77-COMMENTS                 
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860                                                                  
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
A04860                                                                  
      *--------------------*                                                    
       8896-UPDATE-RESTART.                                             
      *--------------------*                                                    
           MOVE '8896' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND               
                      PARTITION_NO = :RF-PARTITION-NO AND               
                      DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD 1 TO WS-RESTART-RF-UPDT-CNTR-TOT                     
               ADD 1 TO WS-RF-UPDT-CNTR-LUW                             
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8896-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF
           END-IF.                       
      *                                                                         
       8896-EXIT.                                                       
           EXIT.                                                        
      *--------------------*                                                    
       8897-INSERT-RESTART.                                             
      *--------------------*                                                    
           MOVE '8897' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM, PARTITION_NO, DUP_CNTRL_NO,           
                    RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM, :RF-PARTITION-NO,                 
                    :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD 1 TO WS-RESTART-RF-ISRT-CNTR-TOT                     
               ADD 1 TO WS-RF-ISRT-CNTR-LUW                             
           ELSE                                                         
               DISPLAY '8897-INSERT RETURN CODE =' WS-ACTIVE-RETURN-CODE
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       8897-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *RESET RESTART-REQ PARAMETER TO INACTIVE                                  
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
      *----------------*                                                        
       8898-ISSUE-CHKP.                                                 
      *----------------*                                                        
           MOVE '8898' TO ACTIVE-PARAGRAPH.                             
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
             AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
               GO TO 8898-EXIT
           END-IF.                                         
           MOVE WS-PROCESS-TYPE        TO WS-RESTART-PROCESS-TYPE.      
           ADD 1                       TO WS-CHKP-SEQ-NO.               
           MOVE WS-CHKP-SEQ-NO         TO WS-RESTART-CHKP-SEQ-NO.       
           IF WS-REPOSITION-NEEDED = WS-NO                              
               IF WS-PROCESS-TYPE > 0                                   
                   MOVE 9999999        TO WS-RESTART-RECORD-NO          
                 ELSE                                                   
                   MOVE ZEROES         TO WS-RESTART-RECORD-NO          
               END-IF                                                   
           ELSE                                                         
               MOVE WS-FCSBW05-REC-CNTR TO WS-RESTART-RECORD-NO         
           END-IF.                                                      
           MOVE WS-PREV-METER-NO        TO WS-RESTART-POST-METER-NO.    
           MOVE WS-PREV-ACCT-NO         TO WS-RESTART-POST-ACCT-NO.     
           MOVE WS-PREV-DATE-TIME       TO WS-RESTART-SAVE-DATE-TIME    
           MOVE WS-METER-VOLUME-RED     TO WS-RESTART-SAVE-MTR-VOL      
           MOVE WS-METER-PRESSURE-RED   TO WS-RESTART-SAVE-MTR-PRE      
           MOVE WS-METER-TEMP-RED       TO WS-RESTART-SAVE-MTR-TMP      
           MOVE WS-METER-VOL-TYPE       TO WS-RESTART-SAVE-VOL-TYPE     
           MOVE WS-NO-OF-REJECT         TO WS-RESTART-NO-OF-REJECT.     
           MOVE WS-MN-UPDT-CNTR-LUW     TO WS-RESTART-MN-UPDT-CNTR-TOT. 
           MOVE WS-BI-ISRT-CNTR-LUW     TO WS-RESTART-BI-ISRT-CNTR-TOT. 
           MOVE WS-BG-ISRT-CNTR-LUW     TO WS-RESTART-BG-ISRT-CNTR-TOT. 
           MOVE WS-BG-UPDT-CNTR-LUW     TO WS-RESTART-BG-UPDT-CNTR-TOT. 
           MOVE WS-CX-ISRT-CNTR-LUW     TO WS-RESTART-CX-ISRT-CNTR-TOT. 
           MOVE WS-CX-UPDT-CNTR-LUW     TO WS-RESTART-CX-UPDT-CNTR-TOT. 
           MOVE WS-AT-UPDT-CNTR-LUW     TO WS-RESTART-AT-UPDT-CNTR-TOT. 
           MOVE WS-IV-ISRT-CNTR-LUW     TO WS-RESTART-IV-ISRT-CNTR-TOT. 
           MOVE WS-IV-UPDT-CNTR-LUW     TO WS-RESTART-IV-UPDT-CNTR-TOT. 
           MOVE WS-GA-ISRT-CNTR-LUW     TO WS-RESTART-GA-ISRT-CNTR-TOT. 
           MOVE WS-GA-UPDT-CNTR-LUW     TO WS-RESTART-GA-UPDT-CNTR-TOT. 
           MOVE WS-RF-ISRT-CNTR-LUW     TO WS-RESTART-RF-ISRT-CNTR-TOT. 
           MOVE WS-RF-UPDT-CNTR-LUW     TO WS-RESTART-RF-UPDT-CNTR-TOT. 
           MOVE WS-COUNT-METER          TO WS-RESTART-COUNT-METER       
           MOVE WS-COUNT-GAS            TO WS-RESTART-COUNT-GAS         
           MOVE WS-GAS-WORKQ            TO WS-RESTART-GAS-WORKQ.        
      *                                                                         
           PERFORM 8899-WRITE-RSDDR                  THRU 8899-EXIT.    
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
           DISPLAY 'COMMIT POINT# ' WS-CHKP-SEQ-NO ' TAKEN.'            
                   'LAST METER NO:' WS-PREV-METER-NO                    
                   ';READ DATE:' WS-PREV-DATE-READ                      
                   ';ENTRY PROCESSED:' WS-RESTART-RECORD-NO        '/'. 
           MOVE ZERO TO WS-CHKP-LUW-COUNTER                             
                        WS-CHKP-UPD-COUNTER.                            
      *                                                                         
       8898-EXIT.                                                       
           EXIT.                                                        
      *-----------------*                                                       
       8899-WRITE-RSDDR.                                                
      *-----------------*                                                       
           MOVE WS-ONE                 TO RF-PARTITION-NO.              
           MOVE PROGRAM-NAME           TO RF-NAME-PROGRAM.              
           MOVE WS-ONE                 TO RF-DUP-CNTRL-NO.              
           MOVE WS-RESTART-DATA        TO RF-RESTART-DATA-TEXT.         
           MOVE WS-RESTART-DATA-LENGTH TO RF-RESTART-DATA-LEN.          
           PERFORM 8896-UPDATE-RESTART THRU 8896-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8897-INSERT-RESTART THRU 8897-EXIT                
           END-IF.                                                      
      *                                                                         
       8899-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      *   8940-DISPLAY-COUNTERS                                                 
      *                                                                         
      ******************************************************************        
       8940-DISPLAY-COUNTERS.                                           
      *                                                                         
           MOVE WS-COUNT-FBW05A        TO WS-DISP-FBW05A.               
           MOVE WS-COUNT-METER         TO WS-DISP-METER.                
           MOVE WS-COUNT-GAS           TO WS-DISP-GAS.                  
           MOVE WS-NO-OF-REJECT        TO WS-DISP-REJECT.               
           MOVE WS-GAS-WORKQ           TO WS-DISP-GAS-WQ.               
                                                                        
           DISPLAY ' '                                                  
           DISPLAY '****************************************'           
           DISPLAY 'TOTAL RECORDS PROCESS  = '                          
                   WS-DISP-METER                                        
           DISPLAY 'TOTAL METERS POSTED    = '                          
                   WS-DISP-GAS                                          
           DISPLAY 'TOTAL METERS REJECTED  = '                          
                   WS-DISP-REJECT                                       
           DISPLAY 'TOTAL MTR WORK QUEUES  = '                          
                   WS-DISP-GAS-WQ                                       
           DISPLAY ' '                                                  
           DISPLAY '# OF RECS WRITTEN TO FCSBW05A = '                   
                   WS-DISP-FBW05A.                                      
           DISPLAY '****************************************'.          
      *                                                                         
       8940-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                         
      *   9000-TERMINATE                                                        
      *                                                                         
      ******************************************************************        
       9000-TERMINATE.                                                  
           CLOSE FCSBW05-FILE.                                          
           IF FCSBW05-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW138    **'    
              DISPLAY '**        PARA - 9000-TERMINATE           **'    
              DISPLAY '**       ERROR DURING CLOSE OF FILE       **'    
              DISPLAY '**               FCSBW05                  **'    
              DISPLAY '**  RC = ' WS-FCSBW05-STATUS                     
              DISPLAY '**          PROCESSING TERMINATED         **'
           END-IF.   
      *                                                                         
           CLOSE FCSBW05A-FILE.                                         
           IF FCSBW05A-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW138    **'    
              DISPLAY '**        PARA - 9000-TERMINATE           **'    
              DISPLAY '**       ERROR DURING CLOSE OF FILE       **'    
              DISPLAY '**               FCSBW05A                 **'    
              DISPLAY '**  RC = ' WS-FCSBW05A-STATUS                    
              DISPLAY '**          PROCESSING TERMINATED         **'
           END-IF.   
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                         
      *   9900-ABEND                                                            
      *                                                                         
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
