       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW136.                                        
       DATE-WRITTEN.   DEC 2001.                                        
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **               PROGRAM  MODIFICATION  LOG                    **         
      **                                                             **         
      **    DATE     INITIALS                 REASON                 **         
      **  ________   ________   ___________________________________  **         
      **                                                             **         
      **  12/10/01   VD88125    INITIAL NEW PROGRAM                  **         
T25860**  01/15/02   VD88125    CODE CHANGES TO PICKUP CORRECT REPORT**         
T25860**                        DATE FROM JOB-PARM.                  **         
T25919**  01/23/02   VD88125    INCLUDE ALL PSNC ACCOUNTS WITH ANNUAL**         
T25919**                        USE >2500 DTS IN PNC008-02. ADDED NEW**         
T25919**                        FIELD BW03-ACCT-TOT-USG-DT IN FIOBW03**         
T26050**  02/20/02   VD88125    CODE CHANGES MADE TO POPULATE CORRECT**         
T26050**                        BILL HISTORY DATA INTO 12 MONTHS HIST**         
T26050**                        REVENUE BUCKETS.                     **         
T26183**  03/18/02   VD88125    CODE CHANGES MADE TO DECLARE A CURSOR**         
T26183**                        FOR ALTERNATE FUEL CODE INSTEAD OF   **         
T26183**                        SELECT STMT.                         **         
T26283**  04/22/02   JT37186    ADD FIOBW04 AND OUTPUT A FILE FOR    **         
T26283**                        RATE REVIEW REPORTS FOR PSNC         **         
T27262**  08/07/02   JT37186    FOR THE 'ALL ACCTS' RUN, WRITE A     **         
T27262**                        RECORD IF CODE_MAJOR_ACCT = 'Y' OR   **         
T27262**                        USAGE IS GT 2500 DT                  **         
T28590**  03/21/03   JT37186    PROCESS ALL ACCOUNTS RATES 125 THRU  **         
T28590**                        225 - DT MUST BE GT 1999 FOR RATE 125**         
T28590**  06/24/03   JT37186    PROCESS RATES 125 FOR THE RATE REVIEW**         
T28590**                        REPORT                               **         
T30342**  02/10/04   JT37186    PROCESS RATES 126 FOR THE RATE REVIEW**         
T30342**                        REPORT                               **         
T33924**  08/26/06   SP94986    CHANGED TO USE THE JOB PARM DATA     **         
      **                        INSTEAD OF HARD CODED RATE VALUES.   **         
T33924**  09/18/06   SP94986    PROGRAM CHANGED TO PROCESS FOR RATES **         
T33924**                        REQUIRED THROUGH JOB PARM TABLE.     **         
      **                                                             **         
      **  07/26/07   RF10596    CHANGED WS-PARM-MAX FROM 8 TO 15     **         
CSR531**  09/21/07   VY95550    INCLUDE TAX EXMPT NUMBER ON BW03 FILE**         
      **                                                             **         
C36461**  11/15/07   MC95456    ADD FIOBW010 AND OUTPUT A FILE FOR   **         
C36461**                        REPORT OF THE ACCOUNTS WHOSE CURRENT **         
C36461**                        MONTH CONSUMPTION IS COMPARED TO     **         
C36461**                        SAME MONTH LAST YEAR.                **         
C36851**  02/14/08   MC95456    ADD FIOBW011 AND OUTPUT A FILE FOR   **         
C36851**                        REPORT OF THE ACCOUNTS WHOSE CURRENT **         
C36851**                        YEAR  CONSUMPTION IS COMPARED TO     **         
C36851**                        THE LAST YEAR CONSUMPTION.           **         
ACT047**  05/06/09   VIJAY   1. CHANGE LIMIT FROM 1999 TO 999 FOR    **         
ACT047**                        RATES 125 AND 225.                   **         
ACT047**                     2. ADD NEW RATES 126 AND 127 SIMILAR TO **         
ACT047**                        RATE 125.                            **         
ACT047**  APPL:CSR SUPPORT MISC TASKS                                           
      *****************************************************************         
      *****************************************************************         
           REMARKS.                                                     
                              PCSBW136 NARRATIVE                        
              **********************************************************
               THIS PROGRAM RUNS MONTHLY. IT IS DESIGNED EXTRACT DATA   
               FOR 12 MONTHS BILLING HISTORY FOR CYCLE 90 INDUSTRIAL    
               AND LARGE COMMERCIAL ACCOUNTS.                           
      *                                                                         
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-3090.                                    
       OBJECT-COMPUTER.    IBM-3090.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSBW03-FILE                                          
               ASSIGN TO UT-S-FCSBW03                                   
               FILE STATUS IS WS-FCSBW03-STATUS.                        
           SELECT FCSBW04-FILE                                          
               ASSIGN TO UT-S-FCSBW04                                   
               FILE STATUS IS WS-FCSBW04-STATUS.                        
C36461     SELECT FCSBW010-FILE                                         
C36461         ASSIGN TO UT-S-FCSBW010                                  
C36461         FILE STATUS IS WS-FCSBW010-STATUS.                       
C36851     SELECT FCSBW011-FILE                                         
C36851         ASSIGN TO UT-S-FCSBW011                                  
C36851         FILE STATUS IS WS-FCSBW011-STATUS.                       
HPCCDM*EJECT                                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSBW03-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
CSR531 01 FIOBW03-RECORD         PIC X(350).                            
T25919*01 FIOBW03-RECORD         PIC X(340).                                    
T25919*01 FIOBW03-RECORD         PIC X(330).                                    
T26283 FD  FCSBW04-FILE                                                 
T26283     BLOCK CONTAINS 0 RECORDS                                     
T26283     RECORDING MODE IS F                                          
T26283     LABEL RECORDS ARE STANDARD.                                  
T26283 01 FIOBW04-RECORD         PIC X(069).                            
C36461 FD  FCSBW010-FILE                                                
C36461     BLOCK CONTAINS 0 RECORDS                                     
C36461     RECORDING MODE IS F                                          
C36461     LABEL RECORDS ARE STANDARD.                                  
C36461 01 FIOBW010-RECORD         PIC X(105).                           
C36851 FD  FCSBW011-FILE                                                
C36851     BLOCK CONTAINS 0 RECORDS                                     
C36851     RECORDING MODE IS F                                          
C36851     LABEL RECORDS ARE STANDARD.                                  
C36851 01 FIOBW011-RECORD         PIC X(105).                           
HPCCDM*EJECT                                                                    
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW136'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSBW136 STARTS HERE'.                  
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
       COPY FIOBW03.                                                            
T26283*                                                                         
T26283 COPY FIOBW04.                                                            
      *                                                                         
C36461 COPY FIOBW010.                                                           
C36851 COPY FIOBW011.                                                           
       01  WS-MISC.                                                     
           05  R-INDEX-MAX                     PIC S9(04) COMP.         
COB305     05 WS-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.       
T36851     05  WS-PROCESS-ACCT-NO              PIC S9(13) COMP-3        
T36851                                                    VALUE 0.      
           05  WS-MTH-REV.                                              
               10 WS-CCYY                      PIC X(04).               
               10 WS-MM                        PIC X(02).               
           05  WS-RPT-REV-MTH.                                          
               10 WS-REV-CCYY                  PIC 9(04).               
               10 WS-REV-MM                    PIC 9(02).               
T26050     05  HD-REVENUE-MONTH                PIC 9(06) VALUE 0.       
           05  WS-REVENUE-MONTH                PIC 9(06) VALUE 0.       
T26283     05  WS-REVIEW-RUN                   PIC X(01) VALUE 'N'.     
T26283         88  WS-RATE-REVIEW-RUN                    VALUE 'Y'.     
T26283     05  WS-OFFSET                       PIC 9(02) VALUE 0.       
T26283     05  WS-FIRST-CURR-IDX               PIC 9(02) VALUE 0.       
T26283     05  WS-LAST-PREV-IDX                PIC 9(02) VALUE 0.       
T26283     05  WS-FIRST-PREV-IDX               PIC 9(02) VALUE 0.       
T26283     05  WS-FIRST-CURRMTH                PIC 9(06) VALUE 0.       
T26283     05  WS-FIRST-CURR-MTH               PIC 9(06) VALUE 0.       
T26283     05  WS-LAST-CURR-MTH                PIC 9(06) VALUE 0.       
T26283     05  WS-FIRST-PREV-MTH               PIC 9(06) VALUE 0.       
T26283     05  WS-LAST-PREV-MTH                PIC 9(06) VALUE 0.       
           05  WS-MTH-CNT                      PIC 9(02) VALUE 0.       
           05  WS-RATE-PLAN-NO                 PIC X(03).               
           05  WS-CODE-REVENUE-CLASS           PIC X(03).               
           05  WS-NO-OF-CONS-DAYS              PIC S9(04) COMP.         
           05  WS-BILL-NO                      PIC S9(09) COMP.         
           05  WS-CODE-UTIL-TYPE               PIC X(01).               
           05  WS-IC-NO                        PIC S9(04) COMP.         
           05  SAVE-NO-CONS-DAYS               PIC 9(04) VALUE 0.       
           05  WS-DAILY-AVG-DKTH               PIC 9(09) VALUE 0.       
           05  WS-MTHLY-DKTH                   PIC 9(09) VALUE 0.       
T26283     05  WS-MTHLY-THRMS                  PIC 9(09) VALUE 0.       
           05  WS-ALTN-FUEL-CD                 PIC X(01) VALUE SPACES.  
T26283     05  WS-TOT-USG-DKTRMS            PIC S9(11) COMP-3 VALUE 0.  
           05  WS-TOT-REV-AMT               PIC S9(13) COMP-3 VALUE 0.  
           05  WS-REV-AMT                   PIC S9(13) COMP-3 VALUE 0.  
T25919     05  WS-ACCT-TOT-USG-DT           PIC S9(13) COMP-3 VALUE 0.  
T26283     05  WS-ACCT-TOT-USG-TH           PIC S9(13) COMP-3 VALUE 0.  
T26283     05  WS-ACCT-TOT-USG-TH-PREV      PIC S9(13) COMP-3 VALUE 0.  
T26283     05  WS-ACCT-TOT-REV-AMT          PIC S9(13) COMP-3 VALUE 0.  
           05  WS-SERVICE-ADDRESS              PIC X(25) VALUE SPACES.  
           05  WS-CUST-NAME                    PIC X(25) VALUE SPACES.  
           05  WS-ZIPCODE                      PIC X(05) VALUE SPACES.  
      *                                                                         
           05  WS-CURRENT-DATE                 PIC X(10).               
           05  WS-CURSOR-COUNTER               PIC S9(7) COMP-3 VALUE 0.
           05  WS-DISPLAY-CSR-COUNTER          PIC 9(07).               
           05  WS-REV-CNT                      PIC S9(04) COMP.         
           05  WS-DISPLAY-RC                   PIC S9(09) COMP.         
           05  WS-FCSBW03-STATUS               PIC X(02).               
               88  FCSBW03-SUCCESSFUL                     VALUE '00'.   
T26283     05  WS-FCSBW04-STATUS               PIC X(02).               
T26283         88  FCSBW04-SUCCESSFUL                     VALUE '00'.   
C36461     05  WS-FCSBW010-STATUS              PIC X(02).               
C36461         88  FCSBW010-SUCCESSFUL                    VALUE '00'.   
C36851     05  WS-FCSBW011-STATUS              PIC X(02).               
C36851         88  FCSBW011-SUCCESSFUL                    VALUE '00'.   
           05  WS-FIRST-TIME                   PIC X(01)  VALUE 'Y'.    
               88  FIRST-TIME                             VALUE 'Y'.    
           05  WS-NULL-1                       PIC S9(04) COMP.         
T26283     05  WS-PARM-CT                      PIC S9(02) VALUE +0.     
           05  WS-PARM-MAX                     PIC S9(02) VALUE +15.    
T26283     05  WS-SUB                          PIC S9(04) COMP VALUE 0. 
C36851     05  WS-SUB1                         PIC S9(04) COMP VALUE 0. 
C36851     05  WS-SUB2                         PIC S9(04) COMP VALUE 0. 
C36851     05  WS-SUBS                         PIC S9(04) COMP VALUE 0. 
T26283     05  WS-LT-SIGN                      PIC X(01) VALUE '<'.     
T26283     05  WS-GT-SIGN                      PIC X(01) VALUE '>'.     
           05  WS-BW04-IND                     PIC X(01) VALUE SPACES.  
C36851     05  WS-CURR-YYMM-DKTHRMS            PIC S9(09) COMP-3        
C36851                                                    VALUE 0.      
C36851     05  WS-PRE-YYMM-DKTHRMS             PIC S9(09) COMP-3        
C36851                                                    VALUE 0.      
C36851     05  WS-CNSMPTN-CMPR-PERCENT         PIC S9(04) COMP-3        
C36851                                                    VALUE 0.      
C36461     05  WS-CMPR-PERCENT1                PIC S9(02)V99 COMP-3     
C36851                                                    VALUE 0.      
C36461     05  WS-CMPR-PERCENT2                PIC S9(02)V99 COMP-3     
C36851                                                    VALUE 0.      
C36851     05  WS-CURR-YEAR-DKTHRMS            PIC S9(09) COMP-3        
C36851                                                    VALUE 0.      
C36851     05  WS-PREV-YEAR-DKTHRMS            PIC S9(09) COMP-3        
C36851                                                    VALUE 0.      
C36851     05  WS-MONTHLY-VARIANCE             PIC S9(09) COMP-3        
C36851                                                    VALUE 0.      
C36851     05  WS-YEARLY-VARIANCE              PIC S9(09) COMP-3        
C36851                                                    VALUE 0.      
      *                                                                         
       01  WS-BILL-HIST-TABLE.                                          
           05 WS-RATE-PLAN-HIST OCCURS 3 TIMES INDEXED BY R-INDEX.      
              10 WS-RATE-PLAN       PIC X(03).                          
              10 WS-REV-CLASS       PIC X(04).                          
              10 WS-REV-PREV-IND    PIC X(01).                          
T26283        10 WS-REV-MTH-HIST OCCURS 24 TIMES INDEXED BY RM-INDEX.   
COB305           15 WS-MTH-USG-DKTH        PIC S9(09) COMP-3 VALUE 0.           
COB305           15 WS-MTH-USG-THRMS        PIC S9(09) COMP-3 VALUE 0.          
COB305           15 WS-MTH-REV-AMT        PIC S9(11) COMP-3 VALUE 0.            
COB305           15 WS-DLY-AVG-DKTH        PIC S9(09) COMP-3 VALUE 0.           
COB305           15 WS-REV-MTH        PIC S9(06) COMP-3 VALUE 0.              
      *                                                                         
T26050 01  WS-MONTH-TABLE.                                              
T26283     05 WS-MTH-TABLE OCCURS 24 TIMES INDEXED BY MTH-INDEX.        
T26050        10 WS-MONTH           PIC 9(06).                          
T26050 01  WS-FOUND-MTH                 PIC X(01) VALUE 'N'.            
C36851 01  WS-BILLED                    PIC X(01) VALUE 'N'.            
T26050*                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME          PIC X(08) VALUE 'PCSBW136'.        
           05  WS-COMPANY-NO         PIC X(02) VALUE '26'.              
           05  WS-Y                  PIC X(01) VALUE 'Y'.               
           05  WS-N                  PIC X(01) VALUE 'N'.               
           05  WS-D                  PIC X(01) VALUE 'D'.               
           05  WS-PGRMNAME           PIC X(08) VALUE 'PCSBW136'.        
           05  WS-811                PIC S9(09) VALUE -811 COMP.        
           05  WS-INPUT-PARM-BREAK.                                     
               10  WS-INPUT-RPT-PARM PIC X(12).                         
               10  WS-INPUT-RPT-DT   PIC X(06).                         
               10  WS-INPUT-FILLER   PIC X(62).                         
T25919*                                                                         
T25919 01  WS-RPTMTH-DATA.                                              
T25919     05  FILLER                      PIC X(20).                   
T25919     05  WS-MONTH1                   PIC X(02).                   
T25919     05  WS-MTH1-R REDEFINES WS-MONTH1                            
T25919                                     PIC 9(02).                   
T25919     05  FILLER                      PIC X(05).                   
T25919     05  WS-MONTH2                   PIC X(02).                   
T25919     05  WS-MTH2-R REDEFINES WS-MONTH2                            
T25919                                     PIC 9(02).                   
T25919     05  FILLER                      PIC X(51).                   
T26283 01  WS-PARM-RATE-REVIEW REDEFINES WS-RPTMTH-DATA.                
T26283     05  FILLER                      PIC X(17).                   
T26283     05  WS-PARM-RATE                PIC X(03).                   
T26283     05  FILLER                      PIC X(01).                   
T26283     05  WS-PARM-SIGN                PIC X(01).                   
T26283     05  FILLER                      PIC X(01).                   
T26283     05  WS-PARM-THERMS              PIC 9(06).                   
T26283     05  FILLER                      PIC X(51).                   
T25919                                                                  
C36851 01  WS-MNTHLY-VARIANCE              PIC X(01).                   
C36851     88 MNTHLY-VARIANCE              VALUE 'Y'.                   
C36851                                                                  
T25919 01  WS-PROCESS-ACCTS                PIC X(01) VALUE 'Y'.         
T25919     88  ALL-OF-ACCTS                VALUE ' '.                   
T25919     88  MAJ-OF-ACCTS                VALUE 'Y'.                   
T25919 01  WS-ACCTS-DESC                   PIC X(05) VALUE SPACES.      
T26283*                                                                         
T26283 01  WS-RATE-REVIEW-PARMS.                                        
T33924     05  WS-RATE-REVIEW OCCURS 25 TIMES.                          
T26283         10  WS-RR-RATE-PLAN-NO             PIC X(03).            
T26283         10  WS-RR-SIGN                     PIC X(01).            
T26283             88  WS-RR-SIGN-MAX            VALUE '<'.             
T26283             88  WS-RR-SIGN-MIN            VALUE '>'.             
COB305         10 WS-RR-MAX-MIN-THERMS        PIC S9(13)V COMP-3 
COB305           VALUE 0.   
T25919*                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                         
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY CWS00038.                                                           
       COPY CWS00114.                                                           
       COPY CWS00037.                                                           
       COPY CWS09900.                                                           
       COPY CWS00074.                                                           
       COPY CWS00011.                                                           
       COPY FIOJC01.                                                            
      *                                                                         
HPCCDM*EJECT                                                                    
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBALTSPY                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLCLDT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00166                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
T33924*********************** CURSOR DECLARATIVES ***************               
T33924*                                                                         
T33924* CURSOR TO SELECT THE DISTINCT ROWS FROM JOB_PARM.                       
T33924*                                                                         
T33924     EXEC SQL                                                     
T33924         DECLARE PARM_CURSOR CURSOR FOR                           
T33924           SELECT DISTINCT(CIS.SUBSTR3(G6.PARM_DATA,18,3))             
T33924             FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                   
T33924             WHERE G6.PROGRAM_NAME    =:G6-PROGRAM-NAME           
T33924             AND G6.CMND_CODE         =:G6-CMND-CODE              
T33924             AND G6.COMPANY_NO        =:G6-COMPANY-NO             
T33924             AND CIS.SUBSTR3 (
           G6.PARM_DATA,1,16) =  'RATE REVIEW RATE' 
T33924           FOR READ ONLY                                  
T33924     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PARM_CURSOR CURSOR FOR                                   
MFA-TR*          SELECT DISTINCT(SUBSTR(G6.PARM_DATA,18,3))                     
MFA-TR*            FROM CSS_JOB_PARM G6                                         
MFA-TR*            WHERE G6.PROGRAM_NAME    =:G6-PROGRAM-NAME                   
MFA-TR*            AND G6.CMND_CODE         =:G6-CMND-CODE                      
MFA-TR*            AND G6.COMPANY_NO        =:G6-COMPANY-NO                     
MFA-TR*            AND SUBSTR (G6.PARM_DATA,1,16) =  'RATE REVIEW RATE'         
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC                                                             
T33924*                                                                         
      *                                                                         
      * CURSOR TO SELECT MAJOR ACCOUNTS.                                        
           EXEC SQL                                                     
               DECLARE MAJOR_ACCT CURSOR FOR                            
                 SELECT  AT.ACCOUNT_NO                                  
                        ,AT.CODE_ACCT_STAT                              
                        ,AT.LOCAL_OFFICE                                
                        ,UT.IC_NO                                       
                        ,UT.CODE_SIC_NO                                 
                        ,AT.COMPANY_NO                                  
                        ,AT.ADDRESS_ID                                  
                        ,UT.RATE_PLAN_NO                                
                        ,UT.CODE_REVENUE_CLASS                          
CSR531                  ,UT.STATE_TAX_EXMPT_NO                          
T27262                  ,AT.CODE_MAJOR_ACCT                             
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                  WHERE AT.COMPANY_NO = :WS-COMPANY-NO                  
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND UT.CODE_UTIL_TYPE = 'G'                         
T33924              AND UT.RATE_PLAN_NO  = :UT-RATE-PLAN-NO             
T33924           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MAJOR_ACCT CURSOR FOR                                    
MFA-TR*          SELECT  AT.ACCOUNT_NO                                          
MFA-TR*                 ,AT.CODE_ACCT_STAT                                      
MFA-TR*                 ,AT.LOCAL_OFFICE                                        
MFA-TR*                 ,UT.IC_NO                                               
MFA-TR*                 ,UT.CODE_SIC_NO                                         
MFA-TR*                 ,AT.COMPANY_NO                                          
MFA-TR*                 ,AT.ADDRESS_ID                                          
MFA-TR*                 ,UT.RATE_PLAN_NO                                        
MFA-TR*                 ,UT.CODE_REVENUE_CLASS                                  
MFA-TR*                 ,UT.STATE_TAX_EXMPT_NO                                  
MFA-TR*                 ,AT.CODE_MAJOR_ACCT                                     
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*           WHERE AT.COMPANY_NO = :WS-COMPANY-NO                          
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND UT.CODE_UTIL_TYPE = 'G'                                 
MFA-TR*             AND UT.RATE_PLAN_NO  = :UT-RATE-PLAN-NO                     
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      * CURSOR TO SELECT BILLING HISTORY                                        
           EXEC SQL                                                     
               DECLARE BILL_HIST CURSOR FOR                             
                 SELECT  DISTINCT BG.ACCOUNT_NO                         
                        ,BG.REVENUE_MONTH                               
                        ,BG.CODE_UTIL_TYPE                              
                        ,BG.IC_NO                                       
                   FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                
                  WHERE BG.COMPANY_NO = :AT-COMPANY-NO                  
                    AND BG.ACCOUNT_NO = :AT-ACCOUNT-NO                  
                    AND BG.IC_NO      = :UT-IC-NO                       
T33924              AND BG.CODE_UTIL_TYPE = 'G'                         
                 ORDER BY REVENUE_MONTH DESC                            
T33924           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILL_HIST CURSOR FOR                                     
MFA-TR*          SELECT  DISTINCT BG.ACCOUNT_NO                                 
MFA-TR*                 ,BG.REVENUE_MONTH                                       
MFA-TR*                 ,BG.CODE_UTIL_TYPE                                      
MFA-TR*                 ,BG.IC_NO                                               
MFA-TR*            FROM CSS_BILLING_DET BG                                      
MFA-TR*           WHERE BG.COMPANY_NO = :AT-COMPANY-NO                          
MFA-TR*             AND BG.ACCOUNT_NO = :AT-ACCOUNT-NO                          
MFA-TR*             AND BG.IC_NO      = :UT-IC-NO                               
MFA-TR*             AND BG.CODE_UTIL_TYPE = 'G'                                 
MFA-TR*          ORDER BY REVENUE_MONTH DESC                                    
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
T25919*                 ,BG.CODE_REVENUE_CLASS                                  
      *                                                                         
T26183* CURSOR TO SELECT ALTERNATE FUEL CODE                                    
T26183     EXEC SQL                                                     
T26183         DECLARE ALTN_FUEL CURSOR FOR                             
T26183          SELECT AK.ALTERNATE_FUEL_CD                             
T26183            FROM CSS_ALTN_FUEL_SPLY AK WITH(READUNCOMMITTED)              
T26183           WHERE AK.ACCOUNT_NO = :AT-ACCOUNT-NO                   
T26183             AND AK.CODE_UTIL_TYPE = 'G'                          
T26183             AND AK.IC_NO = :UT-IC-NO                             
T26183             AND AK.CNTRCT_START_DT = (                           
T26183                 SELECT MAX(A.CNTRCT_START_DT)                    
T26183                   FROM CSS_ALTN_FUEL_SPLY A WITH(READUNCOMMITTED)        
T26183                  WHERE A.ACCOUNT_NO = :AT-ACCOUNT-NO             
T33924                    AND A.IC_NO         = AK.IC_NO                
T33924                    AND A.CODE_UTIL_TYPE = 'G')                   
T26183           ORDER BY AK.ALTN_FUEL_SPLY_CD                          
T33924           FOR READ ONLY                                  
T26183     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ALTN_FUEL CURSOR FOR                                     
MFA-TR*         SELECT AK.ALTERNATE_FUEL_CD                                     
MFA-TR*           FROM CSS_ALTN_FUEL_SPLY AK                                    
MFA-TR*          WHERE AK.ACCOUNT_NO = :AT-ACCOUNT-NO                           
MFA-TR*            AND AK.CODE_UTIL_TYPE = 'G'                                  
MFA-TR*            AND AK.IC_NO = :UT-IC-NO                                     
MFA-TR*            AND AK.CNTRCT_START_DT = (                                   
MFA-TR*                SELECT MAX(A.CNTRCT_START_DT)                            
MFA-TR*                  FROM CSS_ALTN_FUEL_SPLY A                              
MFA-TR*                 WHERE A.ACCOUNT_NO = :AT-ACCOUNT-NO                     
MFA-TR*                   AND A.IC_NO         = AK.IC_NO                        
MFA-TR*                   AND A.CODE_UTIL_TYPE = 'G')                           
MFA-TR*          ORDER BY AK.ALTN_FUEL_SPLY_CD                                  
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                        PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSBW136 ENDS HERE  '.                  
HPCCDM*EJECT                                                                    
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *   CONTROLS MAIN PATH OF PROGRAM                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 0150-INIT-BILL-HIST-TABLE THRU 0150-EXIT.            
           PERFORM 0175-BUILD-12MONTH-TABLE THRU 0175-EXIT.             
      *                                                                         
T33924     PERFORM 7000-OPEN-JOB-PARM-CURSOR  THRU 7000-EXIT.           
T33924     PERFORM 7100-FETCH-JOB-PARM-CURSOR THRU 7100-EXIT.           
      *                                                                         
           PERFORM 1000-MAIN-PROCESSING THRU 1000-EXIT UNTIL            
             SQLCODE = NOT-FOUND                                        
      *                                                                         
T33924     PERFORM 7200-CLOSE-JOB-PARM-CURSOR THRU 7200-EXIT.           
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *   INITIALIZATION ROUTINE. GETS THE RUN DATE THE PROGRAM IS TO  *        
      *   USE.                                                         *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      ****************************************************************          
      *                                                                         
           OPEN OUTPUT FCSBW03-FILE.                                    
           IF FCSBW03-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSBW136 **'      
              DISPLAY '**     PARA - 0100-INITIALIZATION       **'      
              DISPLAY '** ERROR DURING OPEN OF FILE FCSBW03    **'      
              DISPLAY '** RC = ' WS-FCSBW03-STATUS                      
              DISPLAY '** PROCESSING TERMINATED                **'      
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
           OPEN OUTPUT FCSBW04-FILE.                                    
           IF FCSBW04-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSBW136 **'      
              DISPLAY '**     PARA - 0100-INITIALIZATION       **'      
              DISPLAY '** ERROR DURING OPEN OF FILE FCSBW04    **'      
              DISPLAY '** RC = ' WS-FCSBW04-STATUS                      
              DISPLAY '** PROCESSING TERMINATED                **'      
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
C36461     OPEN OUTPUT FCSBW010-FILE.                                   
C36461     IF FCSBW010-SUCCESSFUL                                       
C36461        NEXT SENTENCE                                             
C36461     ELSE                                                         
C36461        DISPLAY '** PROCESSING ERROR IN PROGRAM PCSBW136 **'      
C36461        DISPLAY '**     PARA - 0100-INITIALIZATION       **'      
C36461        DISPLAY '** ERROR DURING OPEN OF FILE FCSBW010   **'      
C36461        DISPLAY '** RC = ' WS-FCSBW010-STATUS                     
C36461        DISPLAY '** PROCESSING TERMINATED                **'      
C36461        PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
C36851*                                                                         
C36851     OPEN OUTPUT FCSBW011-FILE.                                   
C36851     IF FCSBW011-SUCCESSFUL                                       
C36851        NEXT SENTENCE                                             
C36851     ELSE                                                         
C36851        DISPLAY '** PROCESSING ERROR IN PROGRAM PCSBW136 **'      
C36851        DISPLAY '**     PARA - 0100-INITIALIZATION       **'      
C36851        DISPLAY '** ERROR DURING OPEN OF FILE FCSBW011   **'      
C36851        DISPLAY '** RC = ' WS-FCSBW011-STATUS                     
C36851        DISPLAY '** PROCESSING TERMINATED                **'      
C36851        PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
                                                                        
      * GET PROGRAM RUN DATE...                                                 
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                   
                                                                        
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              DISPLAY ' '                                               
              DISPLAY '************PCSBW136**************'              
              DISPLAY '* COMMON DATE BEING USED         *'              
              DISPLAY '* DATE IS ', WS-FCA00-COMMON-DATE                
              DISPLAY '* PROCESSING CONTINUES...        *'              
              DISPLAY '************PCSBW136**************'              
              DISPLAY ' '                                               
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE          TO WS-CURRENT-DATE.              
      *                                   WS-REPORT-DATE.                       
           PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
                                                                        
           IF END-OF-SYSIPT                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7611-CLOSE          THRU 7611-EXIT               
           END-IF.                                                      
                                                                        
           MOVE WS-PARM-YR                     TO WS-REV-CCYY.          
           MOVE WS-PARM-MONTH                  TO WS-REV-MM.            
T25919* UNCOMMENT OUT THE CODE..                                                
T25860     SUBTRACT 1                        FROM WS-REV-MM.            
T25860     IF  WS-REV-MM EQUAL ZEROS                                    
T25860         MOVE 12                         TO WS-REV-MM             
T25860         SUBTRACT 1                    FROM WS-REV-CCYY           
T25860     END-IF.                                                      
           DISPLAY 'EXTRACT REVENUE MONTH = ' WS-RPT-REV-MTH            
T25919* ACCOUNT-PARM(ALL, MAJOR)                                                
T25919     MOVE  WS-PGRMNAME                   TO WS-PROGRAM.           
T25919     MOVE  WS-PARM                       TO WS-COMMAND.           
T25919     MOVE  ZEROS                         TO WS-SEQUENCE.          
T25919     MOVE  SPACES                        TO WS-SYSIPT.            
T25919     MOVE  WS-KEY-AREA                   TO E-FJC01-KEY.          
T25919     MOVE  WS-COMPANY-NO                 TO G6-COMPANY-NO.        
T25919     PERFORM 7600-START-FCSJC01          THRU  7600-EXIT.         
T26283     PERFORM 0125-READ-FCSJC01           THRU  0125-EXIT          
T26283                                         UNTIL END-OF-SYSIPT.     
T26283     IF ALL-OF-ACCTS OR MAJ-OF-ACCTS                              
T26283         NEXT SENTENCE                                            
T26283     ELSE                                                         
T25919         DISPLAY ' '                                              
T25919         DISPLAY '** ' WS-PGRMNAME ' INFORMATIONAL MSG   **'      
T25919         DISPLAY '**  ALL ACCT RPT PARM NOT ACTIVE  **'           
T25919         DISPLAY '**  PROCESSING CONTINUING         **'           
T25919         SET MAJ-OF-ACCTS TO TRUE                                 
T25919         MOVE 'MAJOR' TO WS-ACCTS-DESC                            
T26283     END-IF.                                                      
T25919     DISPLAY 'PROCESSING ACCOUNTS FOR => ' WS-ACCTS-DESC          
T25919*                                                                         
T25919     MOVE WS-PROCESS-ACCTS               TO BW03-ACCTS-IND-BREC   
           MOVE WS-RPT-REV-MTH                 TO BW03-REV-DT-BREC      
           MOVE WS-COMPANY-NO                  TO BW03-COMPANY-NO-BREC  
           MOVE LOW-VALUES                     TO BW03-KEY-BREC         
           MOVE FIOBW03-BEGIN-REC              TO FIOBW03-REC.          
           PERFORM 8000-WRITE-FCSBW03 THRU 8000-EXIT.                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T26283 0125-READ-FCSJC01.                                               
T26283     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT.                 
T26283     IF END-OF-SYSIPT                                             
T26283         GO TO 0125-EXIT                                          
T26283     END-IF.                                                      
T25919     MOVE G6-PARM-DATA                   TO WS-RPTMTH-DATA.       
T25919     DISPLAY G6-PARM-DATA.                                        
T26283     IF WS-INPUT-DATA-BREAKDOWN(1:20) = 'ALL ACCT RPT MONTHS='    
T26283         IF INPUT-ACTIVE                                          
T26283            AND (WS-REV-MM = WS-MTH1-R                            
T26283             OR WS-REV-MM = WS-MTH2-R)                            
T26283             SET ALL-OF-ACCTS TO TRUE                             
T26283             MOVE 'ALL' TO WS-ACCTS-DESC                          
T26283         ELSE                                                     
T26283             SET MAJ-OF-ACCTS TO TRUE                             
T26283             MOVE 'MAJOR' TO WS-ACCTS-DESC                        
T26283         END-IF                                                   
T26283     ELSE                                                         
T26283         IF WS-INPUT-DATA-BREAKDOWN(1:17) = 'RATE REVIEW RATE='   
T26283            AND INPUT-ACTIVE                                      
T26283             ADD +1 TO WS-SUB                                     
T26283             IF WS-SUB IS GREATER THAN WS-PARM-MAX                
T26283                 DISPLAY ' '                                      
T26283                 DISPLAY '** ' WS-PGRMNAME ' WARNING MSG   **'    
T26283                 DISPLAY '**  TOO MANY RATE REVIEW PARMS   **'    
T26283                 DISPLAY '**  PROCESSING CONTINUING        **'    
T26283             ELSE                                                 
T26283                 MOVE WS-PARM-RATE TO WS-RR-RATE-PLAN-NO (WS-SUB) 
T26283                 MOVE WS-PARM-SIGN TO WS-RR-SIGN (WS-SUB)         
T26283                 MOVE WS-PARM-THERMS TO                           
T26283                                    WS-RR-MAX-MIN-THERMS (WS-SUB) 
T26283                 MOVE WS-SUB TO WS-PARM-CT                        
T26283             END-IF                                               
C36461     ELSE                                                         
C36461         IF WS-INPUT-DATA-BREAKDOWN(1:19) = 'RATE OF COMPARISON=' 
C36461            MOVE WS-INPUT-DATA-BREAKDOWN(20:2)                    
C36461                                  TO WS-CNSMPTN-CMPR-PERCENT      
C36461            COMPUTE WS-CMPR-PERCENT1                              
C36461                            = 1 + WS-CNSMPTN-CMPR-PERCENT / 100   
C36461            COMPUTE WS-CMPR-PERCENT2                              
C36461                           =  1 - WS-CNSMPTN-CMPR-PERCENT / 100   
C36461         END-IF                                                   
T26283      END-IF                                                      
T26283     END-IF.                                                      
      *                                                                         
       0125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0150-INIT-BILL-HIST-TABLE.                                       
      *                                                                         
           INITIALIZE WS-BILL-HIST-TABLE.                               
           PERFORM VARYING R-INDEX FROM 1 BY 1                          
                            UNTIL R-INDEX > 3                           
              MOVE SPACES TO WS-RATE-PLAN (R-INDEX)                     
                             WS-REV-CLASS (R-INDEX)                     
T26283                       WS-REV-PREV-IND (R-INDEX)                  
              PERFORM VARYING RM-INDEX FROM 1 BY 1                      
T26283                UNTIL RM-INDEX > 24                               
                 MOVE 0 TO WS-MTH-USG-DKTH (R-INDEX RM-INDEX)           
T26283                     WS-MTH-USG-THRMS (R-INDEX RM-INDEX)          
                           WS-MTH-REV-AMT (R-INDEX RM-INDEX)            
                           WS-DLY-AVG-DKTH (R-INDEX RM-INDEX)           
                           WS-REV-MTH (R-INDEX RM-INDEX)                
              END-PERFORM                                               
           END-PERFORM.                                                 
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T26050***BUILD THE MONTH TABLE                                                  
T26050 0175-BUILD-12MONTH-TABLE.                                        
T26050*                                                                         
T26050     MOVE WS-RPT-REV-MTH TO HD-REVENUE-MONTH.                     
T26050     INITIALIZE WS-MONTH-TABLE.                                   
T26050     PERFORM VARYING MTH-INDEX FROM 24 BY -1                      
T26050             UNTIL MTH-INDEX < 1                                  
T26050        MOVE WS-RPT-REV-MTH TO WS-MONTH (MTH-INDEX)               
T26283        ADD 1 TO WS-MTH-CNT                                       
T26283        IF WS-MTH-CNT IS EQUAL TO 1                               
T26283            MOVE WS-RPT-REV-MTH TO WS-LAST-CURR-MTH               
T26283        END-IF                                                    
T26283        IF WS-MTH-CNT IS EQUAL TO 12                              
T26283            MOVE WS-RPT-REV-MTH TO WS-FIRST-CURRMTH               
T26283        END-IF                                                    
T26283        IF WS-MTH-CNT IS EQUAL TO (12 - WS-OFFSET)                
T26283            MOVE WS-RPT-REV-MTH TO WS-FIRST-CURR-MTH              
T26283        END-IF                                                    
T26283        IF WS-MTH-CNT IS EQUAL TO (13 - WS-OFFSET)                
T26283            MOVE WS-RPT-REV-MTH TO WS-LAST-PREV-MTH               
T26283        END-IF                                                    
T26283        IF WS-MTH-CNT IS EQUAL TO (24 - WS-OFFSET)                
T26283            MOVE WS-RPT-REV-MTH TO WS-FIRST-PREV-MTH              
T26283        END-IF                                                    
T26050        SUBTRACT 1 FROM WS-REV-MM                                 
T26050        IF WS-REV-MM EQUAL ZERO                                   
T26050           MOVE 12 TO WS-REV-MM                                   
T26050           SUBTRACT 1 FROM WS-REV-CCYY                            
T26050        END-IF                                                    
T26050     END-PERFORM.                                                 
T26050     MOVE HD-REVENUE-MONTH TO WS-RPT-REV-MTH.                     
T26283     IF WS-PARM-CT IS GREATER THAN +0                             
T26283         MOVE WS-RPT-REV-MTH    TO BW04-REV-DT-BREC               
T26283         MOVE WS-COMPANY-NO     TO BW04-COMPANY-NO-BREC           
T26283         MOVE LOW-VALUES        TO BW04-KEY-BREC                  
T26283         MOVE WS-FIRST-CURR-MTH TO BW04-CURR-BEGINS               
T26283         MOVE WS-LAST-CURR-MTH  TO BW04-CURR-ENDS                 
T26283         MOVE WS-FIRST-PREV-MTH TO BW04-PREV-BEGINS               
T26283         MOVE WS-LAST-PREV-MTH  TO BW04-PREV-ENDS                 
T26283         MOVE FIOBW04-BEGIN-REC TO FIOBW04-REC                    
T26283         PERFORM 8500-WRITE-FCSBW04 THRU 8500-EXIT                
T26283     END-IF.                                                      
C36461     MOVE WS-RPT-REV-MTH          TO BW10-REPT-DT-BREC.           
C36461     MOVE WS-COMPANY-NO           TO BW10-COMPANY-NO-BREC.        
C36461     MOVE WS-MONTH(24)            TO BW10-REPT-CURR-MNTH.         
C36461     MOVE WS-MONTH(12)            TO BW10-REPT-PREV-MNTH.         
C36461     MOVE WS-CNSMPTN-CMPR-PERCENT TO BW10-PERCENTAGE-CNSMPTN.     
C36461     MOVE FIOBW010-BEGIN-REC      TO FIOBW010-REC.                
C36461     PERFORM 8600-WRITE-FCSBW010  THRU 8600-EXIT.                 
T26050*                                                                         
C36851     MOVE WS-RPT-REV-MTH          TO BW11-REPT-DT-BREC.           
C36851     MOVE WS-COMPANY-NO           TO BW11-COMPANY-NO-BREC.        
C36851     MOVE WS-MONTH(13)            TO BW11-FROM-CURR-MNTH.         
C36851     MOVE WS-MONTH(24)            TO BW11-TO-CURR-MNTH.           
C36851     MOVE WS-MONTH(01)            TO BW11-FROM-PREV-MNTH.         
C36851     MOVE WS-MONTH(12)            TO BW11-TO-PREV-MNTH.           
C36851     MOVE WS-CNSMPTN-CMPR-PERCENT TO BW11-PERCENTAGE-CNSMPTN.     
C36851     MOVE FIOBW011-BEGIN-REC      TO FIOBW011-REC.                
C36851     PERFORM 8700-WRITE-FCSBW011  THRU 8700-EXIT.                 
T26050 0175-EXIT.                                                       
T26050     EXIT.                                                        
HPCCDM*EJECT                                                                    
T26050*                                                                         
T33924*****************************************************************         
T33924* 1000-MAIN-PROCESSING PARA.                                    *         
T33924* POPULATING THE UT RATE PLAN NUMBER FROM JOB_PARM TABLE.       *         
T33924*****************************************************************         
T33924 1000-MAIN-PROCESSING.                                            
T33924*                                                                         
T33924     MOVE WS-RATE-PLAN-NO              TO UT-RATE-PLAN-NO.        
T33924*                                                                         
T33924     PERFORM 7300-OPEN-CURSOR          THRU 7300-OPEN-EXIT.       
T33924     PERFORM 7400-FETCH-CURSOR         THRU 7400-FETCH-EXIT.      
T33924     PERFORM 1100-EXTRACT-PROCESSING   THRU 1100-EXIT             
T33924        UNTIL SQLCODE = NOT-FOUND.                                
T33924*                                                                         
T33924     PERFORM 7500-CLOSE-CURSOR          THRU 7500-CLOSE-EXIT.     
T33924     PERFORM 7100-FETCH-JOB-PARM-CURSOR THRU 7100-EXIT.           
T33924*                                                                         
T33924 1000-EXIT.                                                       
T33924       EXIT.                                                      
T33924                                                                  
      *                                                                         
      *****************************************************************         
      * EXTRACT PROCESSING.                                           *         
      *****************************************************************         
T33924 1100-EXTRACT-PROCESSING.                                         
      *                                                                         
T26283     MOVE 24 TO WS-REV-CNT.                                       
           MOVE 'Y' TO WS-FIRST-TIME.                                   
T26183     PERFORM 7020-OPEN-ALTN-FUEL   THRU 7020-EXIT.                
T26183     PERFORM 7030-FETCH-ALTN-FUEL  THRU 7030-EXIT.                
T26183     IF SQLCODE EQUAL TO SUCCESSFUL-CALL                          
T26183        MOVE AK-ALTERNATE-FUEL-CD TO WS-ALTN-FUEL-CD              
T26183     ELSE                                                         
T26183        MOVE SPACES  TO WS-ALTN-FUEL-CD                           
T26183     END-IF                                                       
T26183     PERFORM 7040-CLOSE-ALTN-FUEL  THRU 7040-EXIT.                
           PERFORM 7050-OPEN-BILL-HIST   THRU 7050-EXIT.                
           PERFORM 7060-FETCH-BILL-HIST  THRU 7060-EXIT.                
C36851     MOVE    WS-N                  TO   WS-BILLED.                
           PERFORM UNTIL SQLCODE = NOT-FOUND OR WS-REV-CNT = 1          
              PERFORM 2000-PROCESS-REV-MONTH THRU 2000-EXIT             
              PERFORM 7060-FETCH-BILL-HIST  THRU 7060-EXIT              
           END-PERFORM.                                                 
C36851     IF WS-REV-CNT EQUAL 24 AND WS-BILLED  EQUAL TO WS-N          
T25919        PERFORM 0150-INIT-BILL-HIST-TABLE THRU 0150-EXIT          
T25919*       NEXT SENTENCE                                                     
           ELSE                                                         
              PERFORM 4000-MAIL-NAME-ADDRESS  THRU 4000-EXIT            
              MOVE WS-PR-STREET        TO WS-SERVICE-ADDRESS            
              MOVE WS-CUSTOMER-NAME    TO WS-CUST-NAME                  
              MOVE WS-PR-ADDR-ZIP-CODE TO WS-ZIPCODE                    
                 PERFORM 6000-PROCESS-FCSBW03 THRU 6000-EXIT            
                 PERFORM 0150-INIT-BILL-HIST-TABLE THRU 0150-EXIT       
           END-IF.                                                      
           PERFORM 7070-CLOSE-BILL-HIST  THRU 7070-EXIT.                
           PERFORM 7400-FETCH-CURSOR THRU 7400-FETCH-EXIT.              
      *                                                                         
T33924 1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
       2000-PROCESS-REV-MONTH.                                          
      *                                                                         
T26050     SET MTH-INDEX TO WS-REV-CNT.                                 
           MOVE WS-N TO WS-FOUND-MTH.                                   
           PERFORM UNTIL  MTH-INDEX < 1                                 
              IF WS-MONTH (MTH-INDEX) = BG-REVENUE-MONTH                
                 SET WS-REV-CNT TO MTH-INDEX                            
                 SET MTH-INDEX TO 1                                     
                 MOVE WS-Y TO WS-FOUND-MTH                              
C36851           MOVE WS-Y TO WS-BILLED                                 
              END-IF                                                    
              SET MTH-INDEX DOWN BY 1                                   
           END-PERFORM.                                                 
           IF WS-FOUND-MTH EQUAL TO WS-N                                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
T26050*                                                                         
           SET BG-RECORD-NOT-EXISTS        TO  TRUE.                    
           MOVE 'N'                        TO  WS-NO-MORE-BG-SW.        
           SET R-INDEX TO 1.                                            
           SET RM-INDEX TO WS-REV-CNT.                                  
                                                                        
           PERFORM 7110-OPEN-ORIG-BILL-CURSOR  THRU 7110-EXIT.          
           PERFORM 7120-FETCH-ORIG-BILL-CURSOR THRU 7120-EXIT.          
                                                                        
           PERFORM UNTIL WS-NO-MORE-BG-SW = 'Y'                         
               SET BG-RECORD-EXISTS       TO TRUE                       
               PERFORM 7150-OBTAIN-ALL-BG  THRU  7150-EXIT              
T25919         IF BG-RECORD-EXISTS                                      
                  PERFORM 7350-SELECT-BILL-DET THRU 7350-EXIT           
                  PERFORM 3000-ACCUM-AMT-THERM THRU 3000-EXIT           
T25919         END-IF                                                   
               PERFORM 7120-FETCH-ORIG-BILL-CURSOR THRU 7120-EXIT       
           END-PERFORM.                                                 
                                                                        
           PERFORM 7130-CLOSE-ORIG-BILL-CURSOR THRU 7130-EXIT.          
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       3000-ACCUM-AMT-THERM.                                            
      *                                                                         
      *    IF BG-RATE-PLAN-NO = '125'                                           
      *       MOVE '225' TO BG-RATE-PLAN-NO                                     
      *    END-IF                                                               
           IF BG-REVENUE-MONTH NOT EQUAL WS-REVENUE-MONTH               
              MOVE BG-NO-OF-CONS-DAYS TO SAVE-NO-CONS-DAYS              
              IF SAVE-NO-CONS-DAYS NOT EQUAL 0                          
                 COMPUTE WS-DAILY-AVG-DKTH ROUNDED =                    
                         WS-MTHLY-DKTH / SAVE-NO-CONS-DAYS              
              ELSE                                                      
                 MOVE 0 TO WS-DAILY-AVG-DKTH                            
              END-IF                                                    
              MOVE BG-REVENUE-MONTH TO WS-REVENUE-MONTH                 
T26050*       IF NOT FIRST-TIME                                                 
T26050*          SET RM-INDEX DOWN BY 1                                         
T26050*          SET WS-REV-CNT TO RM-INDEX                                     
T26050*       END-IF                                                            
           ELSE                                                         
              MOVE BG-NO-OF-CONS-DAYS TO SAVE-NO-CONS-DAYS              
              IF SAVE-NO-CONS-DAYS NOT EQUAL 0                          
                 COMPUTE WS-DAILY-AVG-DKTH ROUNDED =                    
                         WS-MTHLY-DKTH / SAVE-NO-CONS-DAYS              
              ELSE                                                      
                 MOVE 0 TO WS-DAILY-AVG-DKTH                            
              END-IF                                                    
              MOVE BG-REVENUE-MONTH TO WS-REVENUE-MONTH                 
           END-IF                                                       
           SET R-INDEX TO 1.                                            
           SEARCH WS-RATE-PLAN-HIST  VARYING R-INDEX                    
             AT END                                                     
                SET R-INDEX TO 1                                        
                IF WS-RATE-PLAN (R-INDEX) = SPACES                      
                   MOVE BG-RATE-PLAN-NO  TO WS-RATE-PLAN (R-INDEX)      
                   MOVE BG-CODE-REVENUE-CLASS TO WS-REV-CLASS (R-INDEX) 
                   IF BG-REVENUE-MONTH IS LESS THAN WS-FIRST-CURRMTH    
                      MOVE 'Y' TO WS-REV-PREV-IND (R-INDEX)             
                   END-IF                                               
                   PERFORM 5000-ACCUMULATE-AMTS THRU 5000-EXIT          
                ELSE                                                    
                   SET R-INDEX UP BY 1                                  
                   IF WS-RATE-PLAN (R-INDEX) = SPACES                   
                      MOVE BG-RATE-PLAN-NO  TO WS-RATE-PLAN (R-INDEX)   
                    MOVE BG-CODE-REVENUE-CLASS TO WS-REV-CLASS (R-INDEX)
                      IF BG-REVENUE-MONTH IS LESS THAN WS-FIRST-CURRMTH 
                         MOVE 'Y' TO WS-REV-PREV-IND (R-INDEX)          
                      END-IF                                            
                      PERFORM 5000-ACCUMULATE-AMTS THRU 5000-EXIT       
                   ELSE                                                 
                      SET R-INDEX UP BY 1                               
                      IF BG-REVENUE-MONTH IS LESS THAN WS-FIRST-CURRMTH 
                         AND WS-RATE-PLAN (R-INDEX) = SPACES            
                         MOVE 'Y' TO WS-REV-PREV-IND (R-INDEX)          
                      END-IF                                            
                      MOVE BG-RATE-PLAN-NO  TO WS-RATE-PLAN (R-INDEX)   
                    MOVE BG-CODE-REVENUE-CLASS TO WS-REV-CLASS (R-INDEX)
                      PERFORM 5000-ACCUMULATE-AMTS THRU 5000-EXIT       
                   END-IF                                               
                END-IF                                                  
             WHEN WS-RATE-PLAN (R-INDEX) = BG-RATE-PLAN-NO              
                  PERFORM 5000-ACCUMULATE-AMTS THRU 5000-EXIT           
           END-SEARCH.                                                  
                                                                        
           MOVE ZERO TO WS-REV-AMT                                      
                        WS-DAILY-AVG-DKTH                               
                        WS-MTHLY-DKTH                                   
T26283                  WS-MTHLY-THRMS.                                 
           MOVE 'N' TO WS-FIRST-TIME.                                   
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5000-ACCUMULATE-AMTS.                                            
      *                                                                         
           IF BG-CODE-DR-CR-CNSMPTN = WS-D                              
              COMPUTE WS-REV-AMT ROUNDED = (BG-AMT-BILL-ITEM -          
                BG-AMT-STATE-TAX - BG-AMT-CITY-TAX  - BG-AMT-OTHER-TAX) 
           ELSE                                                         
              COMPUTE WS-REV-AMT ROUNDED = (- BG-AMT-BILL-ITEM +        
                BG-AMT-STATE-TAX + BG-AMT-CITY-TAX  + BG-AMT-OTHER-TAX) 
           END-IF                                                       
           COMPUTE WS-MTH-REV-AMT (R-INDEX RM-INDEX) ROUNDED =          
                    WS-MTH-REV-AMT (R-INDEX RM-INDEX) + WS-REV-AMT.     
           COMPUTE WS-MTH-USG-DKTH (R-INDEX RM-INDEX) ROUNDED =         
                  WS-MTH-USG-DKTH (R-INDEX RM-INDEX) + WS-MTHLY-DKTH.   
T26283     COMPUTE WS-MTH-USG-THRMS (R-INDEX RM-INDEX) ROUNDED =        
T26283            WS-MTH-USG-THRMS (R-INDEX RM-INDEX) + WS-MTHLY-THRMS. 
           COMPUTE WS-DLY-AVG-DKTH (R-INDEX RM-INDEX) ROUNDED =         
               WS-DLY-AVG-DKTH (R-INDEX RM-INDEX) + WS-DAILY-AVG-DKTH.  
           MOVE BG-REVENUE-MONTH TO WS-REV-MTH (R-INDEX RM-INDEX).      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       COPY CPD00037.                                                           
           EXEC SQL                                                             
              INCLUDE CPD00074                                                  
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
           EXEC SQL                                                             
            INCLUDE CPD00039                                                    
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
           EXEC SQL                                                             
            INCLUDE CPD00004                                                    
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
       COPY CPD00040.                                                           
HPCCDM*EJECT                                                                    
      ******************************************************************        
      **  6000-PROCESS FCSBW03.                                       **        
      ******************************************************************        
       6000-PROCESS-FCSBW03.                                            
      *                                                                         
T26283*    IF UT-RATE-PLAN-NO IS EQUAL TO '125'                                 
T26283*        MOVE '225' TO UT-RATE-PLAN-NO                                    
T26283*    END-IF.                                                              
T26283     MOVE 'N' TO WS-BW04-IND.                                     
           MOVE SPACES                 TO FIOBW03-REC.                  
T25919     MOVE 0                      TO WS-ACCT-TOT-USG-DT.           
T26283     MOVE 0                      TO WS-ACCT-TOT-USG-TH.           
T26283     MOVE 0                      TO WS-ACCT-TOT-REV-AMT.          
                                                                        
           MOVE BG-ACCOUNT-NO          TO BW03-ACCOUNT-NO               
           MOVE AT-LOCAL-OFFICE        TO BW03-LOCAL-OFFICE             
           MOVE UT-CODE-SIC-NO         TO BW03-CODE-SIC-NO              
           MOVE AT-CODE-ACCT-STAT      TO BW03-CODE-ACCT-STAT           
           MOVE WS-ALTN-FUEL-CD        TO BW03-ALTN-FUEL-CD             
           MOVE WS-CUST-NAME           TO BW03-CUSTOMER-NAME            
           MOVE WS-SERVICE-ADDRESS     TO BW03-SERVICE-ADDRESS          
           MOVE WS-ZIPCODE             TO BW03-ZIP-CODE.                
CSR531     MOVE UT-STATE-TAX-EXMPT-NO  TO BW03-STATE-TAX-EXMPT-NO       
T25919*                                                                         
T25919     PERFORM VARYING R-INDEX FROM 1 BY 1                          
T25919             UNTIL R-INDEX > 3 OR WS-RATE-PLAN (R-INDEX) = SPACES 
T25919        PERFORM VARYING RM-INDEX FROM 13 BY 1                     
T25919                UNTIL RM-INDEX > 24                               
T25919          COMPUTE WS-ACCT-TOT-USG-DT ROUNDED =                    
T25919          WS-ACCT-TOT-USG-DT + WS-MTH-USG-DKTH (R-INDEX, RM-INDEX)
T25919        END-PERFORM                                               
T25919     END-PERFORM.                                                 
T25919     MOVE WS-ACCT-TOT-USG-DT  TO BW03-ACCT-TOT-USAGE-DT.          
                                                                        
T26283     COMPUTE WS-FIRST-CURR-IDX = 13 + WS-OFFSET.                  
T26283     PERFORM VARYING R-INDEX FROM 1 BY 1                          
T26283             UNTIL R-INDEX > 3 OR WS-RATE-PLAN (R-INDEX) = SPACES 
T26283        PERFORM VARYING RM-INDEX FROM WS-FIRST-CURR-IDX BY 1      
T26283                UNTIL RM-INDEX > 24                               
T26283          COMPUTE WS-ACCT-TOT-USG-TH ROUNDED =                    
T26283                  WS-ACCT-TOT-USG-TH +                            
T26283                  WS-MTH-USG-THRMS (R-INDEX, RM-INDEX)            
T26283          COMPUTE WS-ACCT-TOT-REV-AMT ROUNDED =                   
T26283                  WS-ACCT-TOT-REV-AMT +                           
T26283                  WS-MTH-REV-AMT (R-INDEX, RM-INDEX)              
T26283        END-PERFORM                                               
T26283     END-PERFORM.                                                 
T26283     MOVE ZERO TO WS-ACCT-TOT-USG-TH-PREV.                        
T26283     COMPUTE WS-FIRST-PREV-IDX  = 1 + WS-OFFSET.                  
T26283     COMPUTE WS-LAST-PREV-IDX = 12 + WS-OFFSET.                   
T26283     PERFORM VARYING R-INDEX FROM 1 BY 1                          
T26283             UNTIL R-INDEX > 3 OR WS-RATE-PLAN (R-INDEX) = SPACES 
T26283        PERFORM VARYING RM-INDEX FROM WS-FIRST-PREV-IDX BY 1      
T26283                UNTIL RM-INDEX > WS-LAST-PREV-IDX                 
T26283          COMPUTE WS-ACCT-TOT-USG-TH-PREV ROUNDED =               
T26283                  WS-ACCT-TOT-USG-TH-PREV +                       
T26283                  WS-MTH-USG-THRMS (R-INDEX, RM-INDEX)            
T26283        END-PERFORM                                               
T26283     END-PERFORM.                                                 
T25919*                                                                         
           PERFORM VARYING R-INDEX FROM 1 BY 1                          
                   UNTIL R-INDEX > 3 OR WS-RATE-PLAN (R-INDEX) = SPACES 
              SET RATE-INDEX TO 1                                       
              MOVE WS-RATE-PLAN (R-INDEX)      TO                       
                                BW03-RATE-PLAN-NO (RATE-INDEX)          
C36851                          BW10-RATE-PLAN-NO                       
C36851                          BW11-RATE-PLAN-NO                       
              MOVE WS-REV-CLASS (R-INDEX) TO                            
                                BW03-CODE-REV-CLASS (RATE-INDEX)        
C36851                          BW10-CODE-REV-CLASS                     
C36851                          BW11-CODE-REV-CLASS                     
T26283        PERFORM VARYING RM-INDEX FROM 13 BY 1                     
T26283                UNTIL RM-INDEX > 24                               
                 COMPUTE WS-TOT-REV-AMT ROUNDED = WS-TOT-REV-AMT +      
                                WS-MTH-REV-AMT (R-INDEX, RM-INDEX)      
                 COMPUTE WS-TOT-USG-DKTRMS ROUNDED = WS-TOT-USG-DKTRMS +
                                WS-MTH-USG-DKTH (R-INDEX, RM-INDEX)     
              END-PERFORM                                               
              MOVE WS-TOT-USG-DKTRMS      TO BW03-TOTAL-USAGE-THERMS    
              MOVE WS-TOT-REV-AMT         TO BW03-TOTAL-REV-AMT         
T26283        PERFORM VARYING RM-INDEX FROM 13 BY 1                     
T26283                UNTIL RM-INDEX > 24                               
T26283           SET REV-MTH-INDEX TO RM-INDEX                          
T26283           SET REV-MTH-INDEX DOWN BY 12                           
                 MOVE WS-MTH-USG-DKTH (R-INDEX RM-INDEX)  TO            
                       BW03-MTH-USAGE-THERMS (RATE-INDEX REV-MTH-INDEX) 
                 MOVE WS-MTH-REV-AMT (R-INDEX RM-INDEX)   TO            
                       BW03-MTH-REV-AMOUNT (RATE-INDEX REV-MTH-INDEX)   
                 MOVE WS-DLY-AVG-DKTH (R-INDEX RM-INDEX)  TO            
                       BW03-DAILY-AVG-THERMS (RATE-INDEX REV-MTH-INDEX) 
                 MOVE WS-REV-MTH (R-INDEX RM-INDEX) TO                  
                       BW03-REVENUE-MONTH (RATE-INDEX REV-MTH-INDEX)    
              END-PERFORM                                               
T26283        IF WS-REV-PREV-IND (R-INDEX) IS EQUAL TO SPACES           
T28590            IF (UT-RATE-PLAN-NO = '125'                           
T28590               OR UT-RATE-PLAN-NO  = '225'                        
ACT047               OR UT-RATE-PLAN-NO  = '126'                        
ACT047               OR UT-RATE-PLAN-NO  = '127')                       
ACT047                IF WS-ACCT-TOT-USG-DT > 999                       
T27262                   PERFORM 8000-WRITE-FCSBW03   THRU 8000-EXIT    
C36461                   IF BG-ACCOUNT-NO NOT EQUAL WS-PROCESS-ACCT-NO  
C36461                   PERFORM 6500-COMPARE-PROCESS THRU 6500-EXIT    
C36461                   END-IF                                         
T27262                END-IF                                            
T27262            ELSE                                                  
T27262                PERFORM 8000-WRITE-FCSBW03   THRU 8000-EXIT       
C36851                IF BG-ACCOUNT-NO NOT EQUAL WS-PROCESS-ACCT-NO     
C36851                PERFORM 6500-COMPARE-PROCESS THRU 6500-EXIT       
C36851                END-IF                                            
T27262            END-IF                                                
              END-IF                                                    
              IF WS-PARM-CT IS GREATER THAN +0                          
                 AND WS-BW04-IND IS EQUAL TO 'N'                        
T28590           PERFORM 8200-RATE-REVIEW THRU 8200-EXIT                
              END-IF                                                    
              MOVE 0 TO WS-TOT-USG-DKTRMS                               
                        WS-TOT-REV-AMT                                  
           END-PERFORM.                                                 
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
           EXEC SQL                                                             
            INCLUDE CPD00114                                                    
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *                                                                         
C36851*****************************************************************         
C36851* 6500-COMPARE-PROCESS.                                                   
C36851* COMPARES CURRENT MONTH CONSUMPTION WITH LAST YEAR SAME MONTH  *         
C36851* COMPARES CURRENT YEAR CONSUPTION WITH LAST YEAR CONSUMPTION *           
C36851*****************************************************************         
C36851 6500-COMPARE-PROCESS.                                            
C36851     INITIALIZE                        WS-CURR-YYMM-DKTHRMS       
C36851                                       WS-PRE-YYMM-DKTHRMS        
C36851                                       WS-CURR-YEAR-DKTHRMS       
C36851                                       WS-PREV-YEAR-DKTHRMS.      
C36851     MOVE    'Y'                  TO   WS-MNTHLY-VARIANCE.        
C36851     PERFORM 6510-YEARLY-VARIANCE THRU 6510-EXIT.                 
C36851     PERFORM 6520-MNTHLY-VARIANCE THRU 6520-EXIT.                 
C36851     MOVE BG-ACCOUNT-NO           TO   WS-PROCESS-ACCT-NO.        
C36851 6500-EXIT.                                                       
C36851     EXIT.                                                        
C36851*                                                                         
C36851*****************************************************************         
C36851* 6510-YEARLY-VARIANCE.                                                   
C36851* COMPARES CURRENT YEAR  CONSUMPTION WITH LAST YEAR CONSUMPTION *         
C36851*****************************************************************         
C36851 6510-YEARLY-VARIANCE.                                            
C36851     PERFORM   VARYING WS-SUB1 FROM  1 BY 1 UNTIL WS-SUB1  > 3    
C36851       PERFORM VARYING WS-SUB2 FROM 13 BY 1 UNTIL WS-SUB2  > 24   
C36851        COMPUTE  WS-CURR-YEAR-DKTHRMS =                           
C36851         WS-CURR-YEAR-DKTHRMS + WS-MTH-USG-DKTH(WS-SUB1,WS-SUB2)  
C36851       END-PERFORM                                                
C36851       PERFORM VARYING WS-SUB2 FROM  1 BY 1 UNTIL WS-SUB2  > 12   
C36851        COMPUTE  WS-PREV-YEAR-DKTHRMS =                           
C36851         WS-PREV-YEAR-DKTHRMS + WS-MTH-USG-DKTH(WS-SUB1,WS-SUB2)  
C36851       END-PERFORM                                                
C36851     END-PERFORM.                                                 
C36851*                                                                         
C36851     IF  WS-CURR-YEAR-DKTHRMS = 0 AND WS-PREV-YEAR-DKTHRMS = 0    
C36851         NEXT SENTENCE                                            
C36851         ELSE IF (WS-CURR-YEAR-DKTHRMS >=                         
C36851                 (WS-CMPR-PERCENT1 * WS-PREV-YEAR-DKTHRMS))       
C36851                       OR                                         
C36851                 (WS-CURR-YEAR-DKTHRMS <=                         
C36851                 (WS-CMPR-PERCENT2 * WS-PREV-YEAR-DKTHRMS))       
C36851                 COMPUTE WS-YEARLY-VARIANCE   =                   
C36851                 (WS-CURR-YEAR-DKTHRMS -  WS-PREV-YEAR-DKTHRMS)   
C36851                 PERFORM  7511-PROCESS-FW011    THRU   7511-EXIT  
C36851         END-IF                                                   
C36851     END-IF.                                                      
C36851     IF  WS-CURR-YEAR-DKTHRMS  >  2500 OR                         
C36851         WS-PREV-YEAR-DKTHRMS  >  2500                            
C36851         PERFORM   6520-MNTHLY-VARIANCE     THRU 6520-EXIT        
C36851         MOVE      'N'                      TO WS-MNTHLY-VARIANCE 
C36851     END-IF.                                                      
C36851 6510-EXIT.                                                       
C36851      EXIT.                                                       
C36851                                                                  
C36851*****************************************************************         
C36851* 6520-MNTHLY-VARIANCE.                                                   
C36851* COMPARES CURRENT YYMM  CONSUMPTION WITH PREV YYMM CONSUMPTION *         
C36851*****************************************************************         
C36851 6520-MNTHLY-VARIANCE.                                            
C36851      IF MNTHLY-VARIANCE                                          
C36851         PERFORM VARYING WS-SUBS  FROM 1 BY 1 UNTIL WS-SUBS > 3   
C36851           COMPUTE WS-CURR-YYMM-DKTHRMS   =                       
C36851             WS-CURR-YYMM-DKTHRMS + WS-MTH-USG-DKTH(WS-SUBS,24)   
C36851           COMPUTE WS-PRE-YYMM-DKTHRMS    =                       
C36851             WS-PRE-YYMM-DKTHRMS  + WS-MTH-USG-DKTH(WS-SUBS,12)   
C36851         END-PERFORM                                              
C36851         COMPUTE WS-MONTHLY-VARIANCE =                            
C36851                (WS-CURR-YYMM-DKTHRMS - WS-PRE-YYMM-DKTHRMS )     
C36851         IF WS-CURR-YYMM-DKTHRMS = 0 AND WS-PRE-YYMM-DKTHRMS = 0  
C36851             NEXT SENTENCE                                        
C36851          ELSE                                                    
C36851              IF (WS-CURR-YYMM-DKTHRMS >= ( WS-CMPR-PERCENT1 *    
C36851                                        WS-PRE-YYMM-DKTHRMS ))    
C36851                              OR                                  
C36851                  (WS-CURR-YYMM-DKTHRMS <= ( WS-CMPR-PERCENT2 *   
C36851                                         WS-PRE-YYMM-DKTHRMS ))   
C36851                 PERFORM 7510-PROCESS-FW010  THRU  7510-EXIT      
C36851              END-IF                                              
C36851           END-IF                                                 
C36851        END-IF.                                                   
C36851 6520-EXIT.                                                       
C36851      EXIT.                                                       
C36851*                                                                         
C36461*****************************************************************         
C36461* 7510-PROCESS-FW010.                                           *         
C36461* POPULATES FIOBW010 RECORD                                     *         
C36461*****************************************************************         
C36461*                                                                         
C36461 7510-PROCESS-FW010.                                              
C36461     MOVE BG-ACCOUNT-NO         TO BW10-ACCOUNT-NO.               
C36461     MOVE AT-LOCAL-OFFICE       TO BW10-LOCAL-OFFICE.             
C36461     MOVE UT-CODE-SIC-NO        TO BW10-CODE-SIC-NO.              
C36461     MOVE AT-CODE-ACCT-STAT     TO BW10-CODE-ACCT-STAT.           
C36461     MOVE WS-ALTN-FUEL-CD       TO BW10-ALTN-FUEL-CD.             
C36461     MOVE WS-CUST-NAME          TO BW10-CUSTOMER-NAME.            
C36461     MOVE WS-SERVICE-ADDRESS    TO BW10-SERVICE-ADDRESS.          
C36461     MOVE WS-ZIPCODE            TO BW10-ZIP-CODE.                 
C36461     MOVE UT-STATE-TAX-EXMPT-NO TO BW10-STATE-TAX-EXMPT-NO.       
C36461     MOVE WS-CURR-YYMM-DKTHRMS  TO BW10-CURR-MTH-USAGE-DKTHRMS.   
C36461     MOVE WS-PRE-YYMM-DKTHRMS   TO BW10-PREV-MTH-USAGE-DKTHRMS.   
C36851     MOVE WS-MONTHLY-VARIANCE   TO BW10-MONTHLY-VARIANCE.         
C36461     PERFORM 8600-WRITE-FCSBW010  THRU 8600-EXIT.                 
C36461*                                                                         
C36461 7510-EXIT.                                                       
C36461      EXIT.                                                       
C36851*****************************************************************         
C36851* 7511-PROCESS-FW011.                                           *         
C36851* POPULATES FIOBW011 RECORD                                     *         
C36851*****************************************************************         
C36851*                                                                         
C36851 7511-PROCESS-FW011.                                              
C36851     MOVE BG-ACCOUNT-NO         TO BW11-ACCOUNT-NO.               
C36851     MOVE AT-LOCAL-OFFICE       TO BW11-LOCAL-OFFICE.             
C36851     MOVE UT-CODE-SIC-NO        TO BW11-CODE-SIC-NO.              
C36851     MOVE AT-CODE-ACCT-STAT     TO BW11-CODE-ACCT-STAT.           
C36851     MOVE WS-ALTN-FUEL-CD       TO BW11-ALTN-FUEL-CD.             
C36851     MOVE WS-CUST-NAME          TO BW11-CUSTOMER-NAME.            
C36851     MOVE WS-SERVICE-ADDRESS    TO BW11-SERVICE-ADDRESS.          
C36851     MOVE WS-ZIPCODE            TO BW11-ZIP-CODE.                 
C36851     MOVE UT-STATE-TAX-EXMPT-NO TO BW11-STATE-TAX-EXMPT-NO.       
C36851     MOVE WS-CURR-YEAR-DKTHRMS  TO BW11-CURR-YEAR-USAGE-DKTHRMS.  
C36851     MOVE WS-PREV-YEAR-DKTHRMS  TO BW11-PREV-YEAR-USAGE-DKTHRMS.  
C36851     MOVE WS-YEARLY-VARIANCE    TO BW11-YEARLY-VARIANCE.          
C36851     PERFORM 8700-WRITE-FCSBW011  THRU 8700-EXIT.                 
C36851*                                                                         
C36851 7511-EXIT.                                                       
C36851      EXIT.                                                       
T33924******************************************************************        
T33924**  7000-OPEN A CURSOR FOR JOB PARM.                            **        
T33924******************************************************************        
T33924 7000-OPEN-JOB-PARM-CURSOR.                                       
T33924                                                                  
T33924     EXEC SQL                                                     
T33924         OPEN PARM_CURSOR                                         
T33924     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T33924*                                                                         
T33924     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
T33924         NEXT SENTENCE                                            
T33924     ELSE                                                         
T33924         MOVE SQLCODE TO WS-DISPLAY-RC                            
T33924         DISPLAY '*****************PCSBW136******************'    
T33924         DISPLAY '* 7000 : RETURN CODE ERROR - OPEN         *'    
T33924         DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T33924         DISPLAY '* PROGRAM ABENDING...                     *'    
T33924         DISPLAY '*****************PCSBW136******************'    
T33924         PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
T33924*                                                                         
T33924 7000-EXIT.                                                       
T33924     EXIT.                                                        
T33924*                                                                         
T33924******************************************************************        
T33924**  7100 PARA SELECT A DISTINCT RATE PLAN FROM JOB PARM TABLE.  **        
T33924******************************************************************        
T33924*                                                                         
T33924 7100-FETCH-JOB-PARM-CURSOR.                                      
T33924     EXEC SQL                                                     
T33924         FETCH PARM_CURSOR                                        
T33924             INTO :WS-RATE-PLAN-NO                                
T33924     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T33924*                                                                         
T33924     IF SQLCODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND              
T33924         CONTINUE                                                 
T33924     ELSE                                                         
T33924         MOVE SQLCODE TO WS-DISPLAY-RC                            
T33924         DISPLAY '*****************PCSBW136******************'    
T33924         DISPLAY '* 7100 : RETURN CODE ERROR - FETCH        *'    
T33924         DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T33924         DISPLAY '* NO RATE VALUES IN JOB PARM TABLE...     *'    
T33924         DISPLAY '* PROGRAM ABENDING...                     *'    
T33924         DISPLAY '*****************PCSBW136******************'    
T33924         PERFORM 9900-ABEND  THRU  9900-EXIT                      
T33924     END-IF.                                                      
T33924*                                                                         
T33924 7100-EXIT.                                                       
T33924     EXIT.                                                        
T33924*                                                                         
T33924******************************************************************        
T33924**  7200 CLOSE THE JOB PARM CURSOR.                             **        
T33924******************************************************************        
T33924*                                                                         
T33924 7200-CLOSE-JOB-PARM-CURSOR.                                      
T33924*                                                                         
T33924     EXEC SQL                                                     
T33924         CLOSE PARM_CURSOR                                        
T33924     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T33924                                                                  
T33924     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
T33924         NEXT SENTENCE                                            
T33924     ELSE                                                         
T33924         MOVE SQLCODE TO WS-DISPLAY-RC                            
T33924         DISPLAY '*****************PCSBW136******************'    
T33924         DISPLAY '* 7200 : RETURN CODE ERROR - CLOSE        *'    
T33924         DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T33924         DISPLAY '* PROGRAM ABENDING...                     *'    
T33924         DISPLAY '*****************PCSBW136******************'    
T33924         PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
T33924*                                                                         
T33924 7200-EXIT.                                                       
T33924     EXIT.                                                        
T33924*                                                                         
T33924******************************************************************        
T33924**  7300-MAJOR ACCOUNT CURSOR.                                  **        
T33924******************************************************************        
T33924 7300-OPEN-CURSOR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN MAJOR_ACCT                                          
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSBW136******************'    
               DISPLAY '* 7000 : RETURN CODE ERROR - OPEN         *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSBW136******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                         
       7300-OPEN-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
T33924 7400-FETCH-CURSOR.                                               
           EXEC SQL                                                     
               FETCH MAJOR_ACCT                                         
                   INTO :AT-ACCOUNT-NO,                                 
                        :AT-CODE-ACCT-STAT,                             
                        :AT-LOCAL-OFFICE,                               
                        :UT-IC-NO,                                      
                        :UT-CODE-SIC-NO,                                
                        :AT-COMPANY-NO,                                 
                        :AT-ADDRESS-ID,                                 
                        :UT-RATE-PLAN-NO,                               
                        :UT-CODE-REVENUE-CLASS,                         
CSR531                  :UT-STATE-TAX-EXMPT-NO,                         
T27262                  :AT-CODE-MAJOR-ACCT                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSBW136******************'    
               DISPLAY '* 7000 : RETURN CODE ERROR - FETCH        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSBW136******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7400-FETCH-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
T33924 7500-CLOSE-CURSOR.                                               
      *                                                                         
           EXEC SQL                                                     
               CLOSE MAJOR_ACCT                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSBW136******************'    
               DISPLAY '* 7000 : RETURN CODE ERROR - CLOSE        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSBW136******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                         
       7500-CLOSE-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
T26183****************************************************************          
T26183**  7020-OPEN-ALTN-FUEL. CURSOR.                              **          
T26183****************************************************************          
T26183 7020-OPEN-ALTN-FUEL.                                             
T26183*                                                                         
T26183     EXEC SQL                                                     
T26183         OPEN ALTN_FUEL                                           
T26183     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26183                                                                  
T26183     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
T26183         NEXT SENTENCE                                            
T26183     ELSE                                                         
T26183         MOVE SQLCODE TO WS-DISPLAY-RC                            
T26183         DISPLAY '*****************PCSBW136******************'    
T26183         DISPLAY '* 7020 : RETURN CODE ERROR - OPEN         *'    
T26183         DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T26183         DISPLAY '* ACCOUNT NO = ' AT-ACCOUNT-NO                  
T26183         DISPLAY '* PROGRAM ABENDING...                     *'    
T26183         DISPLAY '*****************PCSBW136******************'    
T26183         PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
T26183*                                                                         
T26183 7020-EXIT.                                                       
T26183     EXIT.                                                        
T26183*                                                                         
T26183 7030-FETCH-ALTN-FUEL.                                            
T26183*                                                                         
T26183     EXEC SQL                                                     
T26183         FETCH ALTN_FUEL                                          
T26183             INTO :AK-ALTERNATE-FUEL-CD                           
T26183     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26183                                                                  
T26183     IF SQLCODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND              
T26183        NEXT SENTENCE                                             
T26183     ELSE                                                         
T26183         MOVE SQLCODE TO WS-DISPLAY-RC                            
T26183         DISPLAY '*****************PCSBW136******************'    
T26183         DISPLAY '* 7030 : RETURN CODE ERROR - FETCH        *'    
T26183         DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T26183         DISPLAY '* ACCOUNT NO = ' AT-ACCOUNT-NO                  
T26183         DISPLAY '* PROGRAM ABENDING...                     *'    
T26183         DISPLAY '*****************PCSBW136******************'    
T26183         PERFORM 9900-ABEND  THRU  9900-EXIT                      
T26183     END-IF.                                                      
T26183*                                                                         
T26183 7030-EXIT.                                                       
T26183     EXIT.                                                        
T26183*                                                                         
T26183 7040-CLOSE-ALTN-FUEL.                                            
T26183*                                                                         
T26183     EXEC SQL                                                     
T26183         CLOSE ALTN_FUEL                                          
T26183     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26183                                                                  
T26183     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
T26183         NEXT SENTENCE                                            
T26183     ELSE                                                         
T26183         MOVE SQLCODE TO WS-DISPLAY-RC                            
T26183         DISPLAY '*****************PCSBW136******************'    
T26183         DISPLAY '* 7040 : RETURN CODE ERROR - CLOSE        *'    
T26183         DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T26183         DISPLAY '* PROGRAM ABENDING...                     *'    
T26183         DISPLAY '*****************PCSBW136******************'    
T26183         PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
T26183*                                                                         
T26183 7040-EXIT.                                                       
T26183     EXIT.                                                        
T26183*                                                                         
      ******************************************************************        
      **  7050-BILL HISTORY  CURSOR.                                  **        
      ******************************************************************        
       7050-OPEN-BILL-HIST.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN BILL_HIST                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSBW136******************'    
               DISPLAY '* 7050 : RETURN CODE ERROR - OPEN         *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* ACCOUNT NO = ' AT-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSBW136******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7060-FETCH-BILL-HIST.                                            
      *                                                                         
           EXEC SQL                                                     
               FETCH BILL_HIST                                          
                   INTO :BG-ACCOUNT-NO                                  
                       ,:BG-REVENUE-MONTH                               
                       ,:BG-CODE-UTIL-TYPE                              
                       ,:BG-IC-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25919*                ,:BG-CODE-REVENUE-CLASS                                  
                                                                        
           IF SQLCODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSBW136******************'    
               DISPLAY '* 7060 : RETURN CODE ERROR - FETCH        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* ACCOUNT NO = ' AT-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSBW136******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7070-CLOSE-BILL-HIST.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE BILL_HIST                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSBW136******************'    
               DISPLAY '* 7070 : RETURN CODE ERROR - CLOSE        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSBW136******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      * CURSOR TO GET THE LATEST VERSION OF EACH BILL                           
           EXEC SQL                                                             
              INCLUDE CPD00166                                                  
           END-EXEC.                                                            
      ****************************************************************          
      * 7350-SELECT-BILL-DET                                         *          
      * GETS THE REVENUE AMOUNT AND TAXES                            *          
      ****************************************************************          
       7350-SELECT-BILL-DET.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT AMT_BILL_ITEM,                                   
                       AMT_STATE_TAX,                                   
                       AMT_CITY_TAX,                                    
                       AMT_OTHER_TAX,                                   
                       RATE_PLAN_NO,                                    
                       CODE_DR_CR_CNSMPTN,                              
                       REV_MTH_ORIG_BILL,                               
                       NO_OF_CONS_DAYS,                                 
                       CODE_REVENUE_CLASS                               
                INTO                                                    
                      :BG-AMT-BILL-ITEM,                                
                      :BG-AMT-STATE-TAX,                                
                      :BG-AMT-CITY-TAX,                                 
                      :BG-AMT-OTHER-TAX,                                
                      :BG-RATE-PLAN-NO,                                 
                      :BG-CODE-DR-CR-CNSMPTN,                           
                      :BG-REV-MTH-ORIG-BILL,                            
                      :BG-NO-OF-CONS-DAYS,                              
                      :BG-CODE-REVENUE-CLASS                            
                FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :BG-ACCOUNT-NO                       
                  AND BILL_NO    = :BG-BILL-NO                          
C33924            AND IC_NO      = :BG-IC-NO                            
C33924            AND CODE_UTIL_TYPE = 'G'                              
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
T33924                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AMT_BILL_ITEM,                                           
MFA-TR*                AMT_STATE_TAX,                                           
MFA-TR*                AMT_CITY_TAX,                                            
MFA-TR*                AMT_OTHER_TAX,                                           
MFA-TR*                RATE_PLAN_NO,                                            
MFA-TR*                CODE_DR_CR_CNSMPTN,                                      
MFA-TR*                REV_MTH_ORIG_BILL,                                       
MFA-TR*                NO_OF_CONS_DAYS,                                         
MFA-TR*                CODE_REVENUE_CLASS                                       
MFA-TR*         INTO                                                            
MFA-TR*               :BG-AMT-BILL-ITEM,                                        
MFA-TR*               :BG-AMT-STATE-TAX,                                        
MFA-TR*               :BG-AMT-CITY-TAX,                                         
MFA-TR*               :BG-AMT-OTHER-TAX,                                        
MFA-TR*               :BG-RATE-PLAN-NO,                                         
MFA-TR*               :BG-CODE-DR-CR-CNSMPTN,                                   
MFA-TR*               :BG-REV-MTH-ORIG-BILL,                                    
MFA-TR*               :BG-NO-OF-CONS-DAYS,                                      
MFA-TR*               :BG-CODE-REVENUE-CLASS                                    
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*         WHERE ACCOUNT_NO = :BG-ACCOUNT-NO                               
MFA-TR*           AND BILL_NO    = :BG-BILL-NO                                  
MFA-TR*           AND IC_NO      = :BG-IC-NO                                    
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE BG-BILL-ITEM-TIMESTMP TO BZ-BILL-ITEM-TIMESTMP       
              MOVE BG-ACCOUNT-NO         TO  BZ-ACCOUNT-NO              
              MOVE BG-BILL-NO            TO  BZ-BILL-NO                 
C33924        MOVE BG-IC-NO              TO  BZ-IC-NO                   
              PERFORM 7400-SELECT-BILL-CALC-DET THRU 7400-EXIT          
           ELSE                                                         
              IF SQLCODE = NOT-FOUND                                    
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE SQLCODE TO WS-DISPLAY-RC                          
                 DISPLAY '*************PCSBW136******************'      
                 DISPLAY '** 7350 :  RETURN CODE ERROR           '      
                 DISPLAY '**      :  RC = ' WS-DISPLAY-RC               
                 DISPLAY '** ACCOUNT NO = ' BG-ACCOUNT-NO               
                 DISPLAY '** BILL NO = ' BG-BILL-NO                     
                 DISPLAY '*************PCSBW136******************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      *****************************************************************         
      * 7400-SELECT-BILL-CALC-DET.                                    *         
      * GETS REVENUE AMOUNT AND BILL UNITS FOR THE REVENUE MONTH OF   *         
      * LATEST BILL NO FOR THAT ACCOUNT.                              *         
      *****************************************************************         
       7400-SELECT-BILL-CALC-DET.                                       
      *                                                                         
           EXEC SQL                                                     
                SELECT SUM(BILL_UNITS)                                  
                  INTO :BZ-BILL-UNITS :WS-NULL-1                        
                  FROM CSS_BILL_CALC_DET WITH(READUNCOMMITTED)                  
                 WHERE ACCOUNT_NO = :BZ-ACCOUNT-NO                      
                   AND BILL_NO    = :BZ-BILL-NO                         
C33924             AND IC_NO      = :BZ-IC-NO                           
C33924             AND CODE_UTIL_TYPE = 'G'                             
                   AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )      
T33924                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUM(BILL_UNITS)                                          
MFA-TR*           INTO :BZ-BILL-UNITS :WS-NULL-1                                
MFA-TR*           FROM CSS_BILL_CALC_DET                                        
MFA-TR*          WHERE ACCOUNT_NO = :BZ-ACCOUNT-NO                              
MFA-TR*            AND BILL_NO    = :BZ-BILL-NO                                 
MFA-TR*            AND IC_NO      = :BZ-IC-NO                                   
MFA-TR*            AND CODE_UTIL_TYPE = 'G'                                     
MFA-TR*            AND BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP              
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              IF WS-NULL-1 < 0                                          
                 MOVE 0 TO BZ-BILL-UNITS                                
              ELSE                                                      
                 COMPUTE WS-MTHLY-DKTH ROUNDED = (BZ-BILL-UNITS / 10)   
T26283           COMPUTE WS-MTHLY-THRMS ROUNDED = (BZ-BILL-UNITS * 1)   
              END-IF                                                    
           ELSE                                                         
              IF SQLCODE = NOT-FOUND                                    
                 MOVE 0  TO WS-MTHLY-DKTH                               
T26283           MOVE 0  TO WS-MTHLY-THRMS                              
              ELSE                                                      
                 MOVE SQLCODE TO WS-DISPLAY-RC                          
                 DISPLAY '*****************PCSBW136******************'  
                 DISPLAY '* 7400 : RETURN CODE ERROR - SELECT       *'  
                 DISPLAY '*         RC = ' WS-DISPLAY-RC                
                 DISPLAY '* ACCOUNT NO = ' BZ-ACCOUNT-NO                
                 DISPLAY '* BILL NO    = ' BZ-BILL-NO                   
                 DISPLAY '*****************PCSBW136******************'  
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 8000-WRITE-FCSBW03                                          *           
      ***************************************************************           
       8000-WRITE-FCSBW03.                                              
      *                                                                         
           MOVE FIOBW03-REC TO FIOBW03-RECORD.                          
           WRITE FIOBW03-RECORD.                                        
           IF FCSBW03-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW136    **'    
              DISPLAY '**        PARA - 8000-WRITE-FCSBW03       **'    
              DISPLAY '** ERROR DURING WRITE OF FILE FCSBW03     **'    
              DISPLAY '**  RC = ' WS-FCSBW03-STATUS                     
              DISPLAY '**          PROCESSING TERMINATED         **'    
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
T26283*                                                                         
T26283***************************************************************           
T26283* 8200-RATE-REVIEW                                            *           
T26283***************************************************************           
T26283*                                                                         
T26283 8200-RATE-REVIEW.                                                
T26283     MOVE ZERO TO WS-SUB.                                         
T26283     PERFORM 8300-COMPARE-RATE THRU 8300-EXIT                     
T26283         UNTIL WS-SUB = WS-PARM-CT                                
T26283            OR WS-SUB > WS-PARM-CT.                               
T26283*                                                                         
T26283 8200-EXIT.                                                       
T26283     EXIT.                                                        
T26283*                                                                         
T26283***************************************************************           
T26283* 8300-COMPARE-RATE                                              *        
T33924* CHECKS CUSTOMER USES THE THERMS/YR FOR 12 MONTHS PERIOD FOR  *          
T33924* CURRENT AND PREVIOUS MTH.                                    *          
T26283***************************************************************           
T26283*                                                                         
T26283 8300-COMPARE-RATE.                                               
T26283     ADD +1 TO WS-SUB.                                            
T26283     IF UT-RATE-PLAN-NO IS EQUAL TO                               
T26283                      WS-RR-RATE-PLAN-NO (WS-SUB)                 
T26283         IF WS-RR-SIGN (WS-SUB) IS EQUAL TO WS-LT-SIGN            
T26283            AND (WS-ACCT-TOT-USG-TH IS LESS THAN                  
T26283                WS-RR-MAX-MIN-THERMS (WS-SUB)                     
T33924             OR WS-ACCT-TOT-USG-TH-PREV IS LESS THAN              
T33924                WS-RR-MAX-MIN-THERMS (WS-SUB))                    
T26283            PERFORM 8400-PROCESS-FCSBW04 THRU 8400-EXIT           
T26283         ELSE                                                     
T26283             IF WS-RR-SIGN (WS-SUB) IS EQUAL TO WS-GT-SIGN        
T26283                AND (WS-ACCT-TOT-USG-TH IS GREATER THAN           
T26283                    WS-RR-MAX-MIN-THERMS (WS-SUB)                 
T33924                 OR WS-ACCT-TOT-USG-TH-PREV IS GREATER THAN       
T33924                    WS-RR-MAX-MIN-THERMS (WS-SUB))                
T26283                 PERFORM 8400-PROCESS-FCSBW04 THRU 8400-EXIT      
T26283             END-IF                                               
T26283         END-IF                                                   
T26283     END-IF.                                                      
T26283*                                                                         
T26283 8300-EXIT.                                                       
T26283     EXIT.                                                        
T26283*                                                                         
T26283***************************************************************           
T26283* 8400-PROCESS-FCSBW04                                        *           
T26283***************************************************************           
T26283 8400-PROCESS-FCSBW04.                                            
T26283     MOVE SPACES                 TO FIOBW04-REC.                  
T26283     MOVE UT-RATE-PLAN-NO        TO BW04-RATE-PLAN-NO.            
T26283     MOVE WS-RR-SIGN (WS-SUB)    TO  BW04-REVIEW-SIGN.            
T26283     MOVE WS-RR-MAX-MIN-THERMS (WS-SUB)                           
T26283                                 TO BW04-REVIEW-MAX-MIN-THERMS.   
T26283     MOVE AT-LOCAL-OFFICE        TO BW04-LOCAL-OFFICE.            
T26283     MOVE BG-ACCOUNT-NO          TO BW04-ACCOUNT-NO.              
T26283     MOVE AT-CODE-ACCT-STAT      TO BW04-CODE-ACCT-STAT.          
T26283     MOVE UT-CODE-REVENUE-CLASS  TO BW04-CODE-REV-CLASS.          
T26283     MOVE WS-ACCT-TOT-USG-TH     TO BW04-TOTAL-CURR-YR-THERMS.    
T26283     MOVE WS-ACCT-TOT-USG-TH-PREV  TO BW04-TOTAL-PREV-YR-THERMS.  
T26283     MOVE WS-ACCT-TOT-REV-AMT      TO BW04-TOTAL-REV-AMT.         
T26283     MOVE WS-CUST-NAME           TO BW04-CUSTOMER-NAME.           
T26283     PERFORM 8500-WRITE-FCSBW04 THRU 8500-EXIT.                   
T26283     MOVE 'Y' TO WS-BW04-IND.                                     
T26283*                                                                         
T26283 8400-EXIT.                                                       
T26283     EXIT.                                                        
T26283*                                                                         
T26283***************************************************************           
T26283* 8500-WRITE-FCSBW04                                          *           
T26283***************************************************************           
T26283 8500-WRITE-FCSBW04.                                              
T26283*                                                                         
T26283     MOVE FIOBW04-REC TO FIOBW04-RECORD.                          
T26283     WRITE FIOBW04-RECORD.                                        
T26283     IF FCSBW04-SUCCESSFUL                                        
T26283        NEXT SENTENCE                                             
T26283     ELSE                                                         
T26283        DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW136    **'    
T26283        DISPLAY '**        PARA - 8500-WRITE-FCSBW04       **'    
T26283        DISPLAY '** ERROR DURING WRITE OF FILE FCSBW04     **'    
T26283        DISPLAY '**  RC = ' WS-FCSBW04-STATUS                     
T26283        DISPLAY '**          PROCESSING TERMINATED         **'    
T26283        PERFORM 9900-ABEND THRU 9900-EXIT                         
T26283     END-IF.                                                      
T26283*                                                                         
T26283 8500-EXIT.                                                       
T26283     EXIT.                                                        
T26283*                                                                         
C36461***************************************************************           
C36461* 8600-WRITE-FCSBW010                                         *           
C36461***************************************************************           
C36461 8600-WRITE-FCSBW010.                                             
C36461*                                                                         
C36461     MOVE FIOBW010-REC TO FIOBW010-RECORD.                        
C36461     WRITE FIOBW010-RECORD.                                       
C36461     IF FCSBW010-SUCCESSFUL                                       
C36461        MOVE SPACES                  TO FIOBW010-REC              
C36461     ELSE                                                         
C36461        DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW136    **'    
C36461        DISPLAY '**        PARA - 8600-WRITE-FCSBW010      **'    
C36461        DISPLAY '** ERROR DURING WRITE OF FILE FCSBW010    **'    
C36461        DISPLAY '**  RC = ' WS-FCSBW010-STATUS                    
C36461        DISPLAY '**          PROCESSING TERMINATED         **'    
C36461        PERFORM 9900-ABEND THRU 9900-EXIT                         
C36461     END-IF.                                                      
C36461*                                                                         
C36461 8600-EXIT.                                                       
C36461     EXIT.                                                        
C36851***************************************************************           
C36851* 8700-WRITE-FCSBW011                                         *           
C36851***************************************************************           
C36851 8700-WRITE-FCSBW011.                                             
C36851*                                                                         
C36851     MOVE FIOBW011-REC TO FIOBW011-RECORD.                        
C36851     WRITE FIOBW011-RECORD.                                       
C36851     IF FCSBW011-SUCCESSFUL                                       
C36851        MOVE SPACES                  TO FIOBW011-REC              
C36851     ELSE                                                         
C36851        DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW136    **'    
C36851        DISPLAY '**        PARA - 8700-WRITE-FCSBW011      **'    
C36851        DISPLAY '** ERROR DURING WRITE OF FILE FCSBW011    **'    
C36851        DISPLAY '**  RC = ' WS-FCSBW011-STATUS                    
C36851        DISPLAY '**          PROCESSING TERMINATED         **'    
C36851        PERFORM 9900-ABEND THRU 9900-EXIT                         
C36851     END-IF.                                                      
C36851*                                                                         
C36851 8700-EXIT.                                                       
C36851     EXIT.                                                        
C36851*                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBW03-FILE.                                          
           IF FCSBW03-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW136    **'    
              DISPLAY '**        PARA - 9000-TERMINATE           **'    
              DISPLAY '** ERROR DURING CLOSE OF FILE FCSBW03     **'    
              DISPLAY '**  RC = ' WS-FCSBW03-STATUS                     
              DISPLAY '**          PROCESSING TERMINATED         **'    
           END-IF.                                                      
T26283     CLOSE FCSBW04-FILE.                                          
T26283     IF FCSBW04-SUCCESSFUL                                        
T26283        NEXT SENTENCE                                             
T26283     ELSE                                                         
              DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW136    **'    
T26283        DISPLAY '**        PARA - 9000-TERMINATE           **'    
T26283        DISPLAY '** ERROR DURING CLOSE OF FILE FCSBW04     **'    
T26283        DISPLAY '**  RC = ' WS-FCSBW04-STATUS                     
T26283        DISPLAY '**          PROCESSING TERMINATED         **'    
T26283     END-IF.                                                      
C36461     CLOSE FCSBW010-FILE.                                         
C36461     IF FCSBW010-SUCCESSFUL                                       
C36461        NEXT SENTENCE                                             
C36461     ELSE                                                         
C36461        DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW136    **'    
C36461        DISPLAY '**        PARA - 9000-TERMINATE           **'    
C36461        DISPLAY '** ERROR DURING CLOSE OF FILE FCSBW010    **'    
C36461        DISPLAY '**  RC = ' WS-FCSBW010-STATUS                    
C36461        DISPLAY '**          PROCESSING TERMINATED         **'    
C36461     END-IF.                                                      
C36851*                                                                         
C36851     CLOSE FCSBW011-FILE.                                         
C36851     IF FCSBW011-SUCCESSFUL                                       
C36851        NEXT SENTENCE                                             
C36851     ELSE                                                         
C36851        DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW136    **'    
C36851        DISPLAY '**        PARA - 9000-TERMINATE           **'    
C36851        DISPLAY '** ERROR DURING CLOSE OF FILE FCSBW011    **'    
C36851        DISPLAY '**  RC = ' WS-FCSBW011-STATUS                    
C36851        DISPLAY '**          PROCESSING TERMINATED         **'    
C36851     END-IF.                                                      
C36851*                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9700-PROCESS-ABEND.                                              
      *                                                                         
           PERFORM 9900-ABEND                THRU 9900-EXIT.            
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *            
      **************************************************************            
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
