       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW135.                                        
       AUTHOR.         COVANSYS                                         
       INSTALLATION.                                                    
       DATE-WRITTEN.   JULY    2001.                                    
           DATE-COMPILED.                                               
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRICITY  & GAS               **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE       INITIALS      REASON                          **         
      **    ----       --------      ------                          **         
T23631**  07/05/2001    VD88125  DEVELOPMENT OF NEW PROGRAM.         **         
C29853**  01/28/2004    SG18894  CHANGES MADE TO REFOMRAT FIOBW02 TO **         
      **                         FIOBW06 & USE PCSBW143 TO POST THE  **         
      **                         READINGS.                           **         
P00251** 01/25/10   SS95855     NET METERING                         **         
P00251**                        Add Code_Usgae_ID & Code_Usage_Source**         
ACT118** 01/18/13   DB41297     BYPASS 2ND ROW IF CODE-USAGE-TYPE = 'U'         
A05460** 01/18/16   DB41297     Changes to meter reading processing.            
ACT007 *                                                                
      *****************************************************************         
           REMARKS.                                                     
                              PCSBW135 NARRATIVE                        
           READS FCSBW02 METRETEK RECORDS WHICH HAVE BEEN SENT BY       
           METRETEK FOR METER READ POSTING. MID MONTH READS ARE         
           POSTED TO ROUTE REPORT ONLY AND END OF MONTH READS ARE       
           POSTED TO CONSUMPTION HISTORY AND ROUTE REPORT.              
           PCSBW135 REFORMATS FIOBW02 FORMAT INPUT FILE TO VENDOR       
           INDEPENDENT FORMAT FIOBW06 OUTPUT FILE. THIS OUTPUT FILE     
           IS INPUT TO PCSBW143 WHICH POSTS ALL METER READINGS TO CIS.  
      *                                                                         
                -------- BASIC SEQUENCE STRUCTURE -----------           
                0000 - 0999     MAIN CONTROL PATH AND                   
                                INITIALIZATION                          
                1000 - 2000     MAIN FILE PROCESSING CONTROL            
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9900 - 9999     TERMINATE/ABEND MODULES                 
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSBW02.                                                            
       COPY CSSBW06.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDBW02.                                                            
       01 FIOBW02-REC             PIC X(80).                            
       COPY CFDBW06.                                                            
       01 FIOBW06-REC             PIC X(280).                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW135'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSBW135 STARTS HERE'.            
       COPY FIOBW02.                                                            
       COPY FIOBW06.                                                            
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00004.                                                           
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-FCSBW02-STATUS       PIC X(02).                       
               88  FCSBW02-SUCCESSFUL             VALUE '00'.           
           05  WS-FBW06-STATUS         PIC X(02).                       
               88  FBW06-SUCCESSFUL               VALUE '00'.           
           05  WS-END-OF-MTEK-FILE     PIC X      VALUE 'N'.            
               88  WS-MTEK-EOF                    VALUE 'Y'.            
           05  WS-RUN-DATE             PIC X(10).                       
           05  WS-FCSBW02-REC-CNTR     PIC S9(09) COMP VALUE ZERO.      
           05  WS-COMPANY-NO           PIC X(02).                       
           05  WS-TIME-READ            PIC X(08)  VALUE SPACES.         
           05  WS-INPUT-TIME.                                           
               10  WS-INPUT-TIME-HH    PIC X(02)  VALUE SPACES.         
               10  FILLER              PIC X(01)  VALUE '.'.            
               10  WS-INPUT-TIME-MM    PIC X(02)  VALUE SPACES.         
               10  FILLER              PIC X(01)  VALUE '.'.            
               10  WS-INPUT-TIME-SS    PIC X(02)  VALUE SPACES.         
           05  WS-CD-TIME.                                              
               10  WS-CD-HR            PIC 9(02)  VALUE ZEROES.         
               10  WS-CD-MIN           PIC 9(02)  VALUE ZEROES.         
               10  WS-CD-SEC           PIC 9(02)  VALUE ZEROES.         
               10  WS-CD-HUN           PIC 9(02)  VALUE ZEROES.         
           05  WS-DATE-NUM.                                             
               10  WS-DATE-NUM-CCYY    PIC 9(04)  VALUE ZERO.           
               10  FILLER              PIC X(01)  VALUE '-'.            
               10  WS-DATE-NUM-MM      PIC 9(02)  VALUE ZERO.           
               10  FILLER              PIC X(01)  VALUE '-'.            
               10  WS-DATE-NUM-DD      PIC 9(02)  VALUE ZERO.           
           05  WS-WORK-DATE.                                            
               10  WS-WORK-CC          PIC 9(02).                       
               10  WS-WORK-YY          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-WORK-MM          PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-WORK-DD          PIC 9(02).                       
           05  WS-FIOBW06-COUNT        PIC 9(07) VALUE ZERO.            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08)  VALUE 'PCSBW135'. 
           05  PROGRAM-NAME                PIC X(08)  VALUE 'PCSBW135'. 
           05  WS-PCSBW135                 PIC X(08)  VALUE 'PCSBW135'. 
           05  WS-NEG-ONE                  PIC S9(04)  COMP-3 VALUE -1. 
           05  WS-ONE                      PIC X(02)   VALUE '01'.      
           05  WS-NO                       PIC X(01)   VALUE 'N'.       
           05  WS-N                        PIC X(01)   VALUE 'N'.       
           05  WS-YES                      PIC X(01)   VALUE 'Y'.       
           05  WS-Y                        PIC X(01)   VALUE 'Y'.       
           05  WS-I                        PIC X(01)   VALUE 'I'.       
           05  WS-COMP-26                  PIC X(02)   VALUE '26'.      
           05  WS-METRETEK                 PIC X(01)   VALUE 'E'.       
           05  WS-CURRENT                  PIC X(01)   VALUE 'C'.       
           05  WS-COMMON                   PIC X(06)   VALUE 'COMMON'.  
           05  WS-REGULAR-READ             PIC X(01)   VALUE 'R'.       
           05  WS-USAGE-TYPE-CODES.                                     
               10  WS-COR                  PIC X(01)   VALUE 'C'.       
               10  WS-UNC                  PIC X(01)   VALUE 'U'.       
           05  WS-GAS                      PIC X(01)   VALUE 'G'.       
                                                                        
       01  WS-MINMAX-DATA.                                              
           05  FILLER                      PIC X(20).                   
           05  WS-MIN-ON-PARM              PIC X(02).                   
           05  FILLER                      PIC X(09).                   
           05  WS-MAX-ON-PARM              PIC X(02).                   
           05  FILLER                      PIC X(47).                   
       01  WS-MINMAX-ON-PARM               PIC X(01).                   
      *                                                                         
       01  WS-PROCESS-MONTH                PIC X(01) VALUE 'E'.         
           88  MID-OF-MONTH                VALUE 'M'.                   
           88  END-OF-MONTH                VALUE 'E'.                   
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-METER-NUM              PIC 9(09) VALUE ZEROS.       
           05  PARM-READ-DATE-IN.                                       
               10 PARM-READ-DATE-MM        PIC X(02) VALUE SPACES.      
               10 PARM-READ-DATE-MM-NUM REDEFINES PARM-READ-DATE-MM     
                                           PIC 9(02).                   
               10 FILLER                   PIC X(01) VALUE SPACE.       
               10 PARM-READ-DATE-DD        PIC X(02) VALUE SPACES.      
               10 PARM-READ-DATE-DD-NUM REDEFINES PARM-READ-DATE-DD     
                                           PIC 9(02).                   
               10 FILLER                   PIC X(01) VALUE SPACE.       
               10 PARM-READ-DATE-CCYY      PIC X(04) VALUE SPACES.      
               10 PARM-READ-DATE-CCYY-NUM REDEFINES PARM-READ-DATE-CCYY 
                                           PIC 9(04).                   
           05  PARM-MTR-READ-CORR          PIC X(09) VALUE ZEROS.       
           05  PARM-MTR-READ-CORR-NUM REDEFINES PARM-MTR-READ-CORR      
                                           PIC 9(09).                   
           05  PARM-MTR-READ-UNCORR        PIC X(09) VALUE ZEROS.       
           05  PARM-MTR-READ-UNCORR-NUM REDEFINES PARM-MTR-READ-UNCORR  
                                           PIC 9(09).                   
           05  PARM-READ-DATE              PIC X(10) VALUE SPACES.      
           05  PARM-ACCOUNT-NO             PIC X(13) VALUE SPACES.      
           05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO            
                                           PIC 9(13).                   
      *                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE         PIC S9(04) COMP VALUE 0.          
           05  RS-RETURN-CODE-DISP    PIC +Z(04).                       
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       COPY FIOJC01.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      *    DB2 TABLE DCLGENS USING IN THIS PROGRAM                              
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
ACT118*****************************************************************         
ACT118*    DCLGEN FOR CSS_MTRD_ENVRNMT                                *         
ACT118*****************************************************************         
ACT118     EXEC SQL                                                             
ACT118         INCLUDE TBMTRENV                                                 
ACT118     END-EXEC.                                                            
ACT118*                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
           COPY FIOCA00.                                                        
      *****************************************************************         
      *    DECLARATION FOR SQL COMMON AREA                            *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
      *********************** END DECLARATIVES ******************               
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSBW135 ENDS HERE  '.            
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *                                                                *        
      *   0000-MAINLINE.                                               *        
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                         
           PERFORM 7000-READ-MTEK-FILE        THRU 7000-EXIT.           
           IF WS-MTEK-EOF                                               
              DISPLAY '************************************************'
              DISPLAY '**         PCSBW135 PROCESSING ERROR          **'
              DISPLAY '**           FCSBW02  FILE IS EMPTY           **'
              DISPLAY '**           PROCESSING TERMINATED            **'
              DISPLAY '************************************************'
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 1000-PROCESS-METRETEK         THRU 1000-EXIT         
                                UNTIL WS-MTEK-EOF.                      
      *                                                                         
           PERFORM 1100-WRITE-END-REC THRU 1100-EXIT.                   
           DISPLAY 'TOTAL NO. OF RECORDS WRITTEN: ' WS-FIOBW06-COUNT.   
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
      *                                                                         
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                         
      *   0100-INITIALIZATION                                                   
      *        COMMON INITIALIZATION ROUTINE.                                   
      *        RETRIEVE JOB PARMS.                                              
      *                                                                         
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT FCSBW02-FILE.                                     
           IF FCSBW02-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW135   **'     
              DISPLAY '**        PARA - 0100-INITIALIZATION      **'    
              DISPLAY '**       ERROR DURING OPEN OF FILE        **'    
              DISPLAY '**               FCSBW02                  **'    
              DISPLAY '**  RC = ' WS-FCSBW02-STATUS                     
              DISPLAY '**          PROCESSING TERMINATED         **'    
              PERFORM 9900-ABEND                 THRU 9900-EXIT
           END-IF.        
      *                                                                         
           OPEN OUTPUT FCSBW06-FILE.                                    
           IF FBW06-SUCCESSFUL                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSBW135   **'    
              DISPLAY '**        PARA - 0100-INITIALIZATION      **'    
              DISPLAY '**       ERROR DURING OPEN OF FILE        **'    
              DISPLAY '**               FCSBW06                  **'    
              DISPLAY '**  RC = ' WS-FBW06-STATUS                       
              DISPLAY '**          PROCESSING TERMINATED         **'    
              PERFORM 9900-ABEND                 THRU 9900-EXIT
           END-IF.        
      *                                                                         
           ACCEPT WS-CD-TIME FROM TIME.                                 
           MOVE WS-CD-HR  TO WS-INPUT-TIME-HH.                          
           MOVE WS-CD-MIN TO WS-INPUT-TIME-MM.                          
           MOVE WS-CD-SEC TO WS-INPUT-TIME-SS.                          
           MOVE WS-INPUT-TIME TO WS-TIME-READ.                          
      *                                                                         
           MOVE WS-COMP-26             TO G6-COMPANY-NO.                
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
              MOVE SPACES               TO G6-COMPANY-NO                
              MOVE SPACES               TO WS-INPUT-DATE                
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              DISPLAY 'COMMON DATE ==> ' WS-FCA00-COMMON-DATE           
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE           TO WS-RUN-DATE                  
                                           WS-WORK-DATE.                
      *                                                                         
           MOVE WS-COMP-26             TO G6-COMPANY-NO.                
      * MIN-MAX PARM                                                            
           MOVE  WS-PGRMNAME TO WS-PROGRAM.                             
           MOVE  WS-PARM     TO WS-COMMAND.                             
           MOVE  ZEROS       TO WS-SEQUENCE.                            
           MOVE  SPACES      TO WS-SYSIPT.                              
           MOVE  WS-KEY-AREA TO E-FJC01-KEY.                            
           MOVE  WS-COMP-26  TO G6-COMPANY-NO.                          
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:20) =                   
                         'MID MONTH RANGE MIN=' AND INPUT-ACTIVE)       
                  OR  END-OF-SYSIPT.                                    
           MOVE G6-PARM-DATA    TO WS-MINMAX-DATA.                      
      *                                                                         
           IF END-OF-SYSIPT                                             
               DISPLAY ' '                                              
               DISPLAY '** ' WS-PGRMNAME ' INFORMATIONAL MSG   **'      
               DISPLAY '**  MINMAX-CHECK PARM NOT ACTIVE  **'           
               DISPLAY '**  PROCESSING CONTINUING         **'           
               MOVE WS-N        TO WS-MINMAX-ON-PARM                    
               SET END-OF-MONTH TO TRUE                                 
           ELSE                                                         
              IF WS-WORK-DD >= WS-MIN-ON-PARM AND                       
                 WS-WORK-DD <= WS-MAX-ON-PARM                           
                 SET MID-OF-MONTH TO TRUE                               
              ELSE                                                      
                 SET END-OF-MONTH TO TRUE                               
              END-IF                                                    
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
           MOVE ZEROS                      TO WS-FIOBW06-COUNT.         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                         
      *   1000-PROCESS-METRETEK                                                 
      *       CONTROLS PROCESSING OF ALL METER OUTPUT RECORDS                   
      *       LOAD DATA FROM INPUT FILE, CONVERT DATES AND PROCESS METER        
      *                                                                         
      ******************************************************************        
       1000-PROCESS-METRETEK.                                           
      *                                                                         
           MOVE '1000'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           MOVE SPACES                     TO FIOBW06.                  
           MOVE E-FBW02-ACCOUNT-NO         TO PARM-ACCOUNT-NO           
           IF  PARM-ACCOUNT-NO-NUM EQUAL ZEROS                          
               MOVE 1                      TO E-FBW06-ACCOUNT-NO        
           ELSE                                                         
               MOVE PARM-ACCOUNT-NO-NUM    TO E-FBW06-ACCOUNT-NO        
           END-IF.                                                      
           MOVE E-FBW02-METER-NO           TO E-FBW06-METER-NO          
           MOVE WS-GAS                     TO E-FBW06-CODE-UTIL-TYPE    
           MOVE ZEROS                      TO E-FBW06-CODE-TIME-PERIOD  
           MOVE WS-CURRENT                 TO E-FBW06-CODE-TOU-SEASN    
      *                                                                         
           MOVE E-FBW02-READ-DATE          TO PARM-READ-DATE-IN.        
           MOVE PARM-READ-DATE-MM-NUM      TO WS-DATE-NUM-MM.           
           MOVE PARM-READ-DATE-DD-NUM      TO WS-DATE-NUM-DD.           
           MOVE PARM-READ-DATE-CCYY-NUM    TO WS-DATE-NUM-CCYY.         
           MOVE WS-DATE-NUM                TO E-FBW06-DATE-READ         
           MOVE WS-TIME-READ               TO E-FBW06-TIME-READ         
      *                                                                         
           MOVE WS-REGULAR-READ            TO E-FBW06-CODE-METER-READ   
           MOVE SPACES                     TO E-FBW06-MTR-COMMENT-TX    
                                              E-FBW06-MTR-COND-CD1      
                                              E-FBW06-MTR-COND-CD2      
                                              E-FBW06-CODE-METER-NO-READ
           MOVE ZEROS                      TO E-FBW06-EMPLOYEE-NO       
           MOVE WS-METRETEK                TO E-FBW06-MTR-READ-SOURCE-CD
           MOVE 'Y'                        TO E-FBW06-CNSMPTN-READ-FL   
           MOVE 'I'                        TO E-FBW06-INDEX-VALUE-CD    
           MOVE '3'                        TO E-FBW06-READ-PROCESS-CD   
           MOVE ZEROS                      TO E-FBW06-BTU-FACTOR        
           IF  MID-OF-MONTH                                             
               MOVE 'M'                    TO E-FBW06-READ-ITEM-STATUS  
           ELSE                                                         
               MOVE 'B'                    TO E-FBW06-READ-ITEM-STATUS  
           END-IF.                                                      
           MOVE 1                          TO E-FBW06-DB-PART-DREC.     
      *                                                                         
      *OUTPUT FILE WILL HAVE ONE READ FOR EACH RECORD                           
           MOVE WS-COR                     TO E-FBW06-CODE-USAGE-TYPE   
P00251     MOVE 'A'                        TO E-FBW06-CODE-USAGE-ID.    
P00251     MOVE 'B'                        TO E-FBW06-CODE-USAGE-SOURCE 
           MOVE 'COR'                      TO E-FBW06-REG-MEASURE-CD    
           MOVE E-FBW02-METER-READ-CORR    TO PARM-MTR-READ-CORR        
           MOVE PARM-MTR-READ-CORR-NUM     TO E-FBW06-METER-READING     
           PERFORM 8000-WRITE-FIOBW06 THRU 8000-EXIT.                   
           ADD 1                           TO WS-FIOBW06-COUNT.         
ACT118*                                                                         
ACT118     MOVE E-FBW02-METER-READ-UNCORR TO PARM-MTR-READ-UNCORR.      
           MOVE PARM-MTR-READ-UNCORR-NUM TO E-FBW06-METER-READING.      
                                                                        
           PERFORM 7300-SELECT-MN THRU 7300-EXIT.                       
                                                                        
ACT007     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL AND          
ACT007     MN-CODE-DATA-PRESENT = SPACES                                
ACT007       CONTINUE                                                   
ACT007     ELSE                                                         
ACT007        MOVE WS-UNC                  TO E-FBW06-CODE-USAGE-TYPE   
ACT007        MOVE 'A'                     TO E-FBW06-CODE-USAGE-ID     
ACT007        MOVE 'C'                     TO E-FBW06-CODE-USAGE-SOURCE 
ACT007        MOVE 'UNC'                   TO E-FBW06-REG-MEASURE-CD    
ACT007        PERFORM 8000-WRITE-FIOBW06 THRU 8000-EXIT                 
ACT007        ADD 1                           TO WS-FIOBW06-COUNT       
ACT007     END-IF.                                                      
                                                                        
           PERFORM 7000-READ-MTEK-FILE THRU 7000-EXIT.                  
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * MODULE TO WRITE OUT THE CONTROL RECORD                         *        
      ******************************************************************        
       1100-WRITE-END-REC.                                              
      *                                                                         
           INITIALIZE FIOBW06.                                          
           MOVE ALL '9'                    TO E-FBW06-RECORD-KEY.       
           MOVE 1                          TO E-FBW06-DB-PART-DREC.     
           PERFORM 8000-WRITE-FIOBW06 THRU 8000-EXIT.                   
           ADD 1                           TO WS-FIOBW06-COUNT.         
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
       COPY CPD00040.                                                           
      *                                                                         
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
       COPY CPD00037.                                                           
      *                                                                         
      ******************************************************************        
      * READ INPUT FILE                                                *        
      ******************************************************************        
       7000-READ-MTEK-FILE.                                             
      *                                                                         
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           READ FCSBW02-FILE                                            
             INTO FIOBW02                                               
               AT END MOVE WS-YES TO WS-END-OF-MTEK-FILE.               
                                                                        
           ADD  1 TO WS-FCSBW02-REC-CNTR.                               
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
ACT118******************************************************************        
ACT118* SELECT METER  DETAILS                                          *        
ACT118******************************************************************        
ACT118 7300-SELECT-MN.                                                  
ACT118*                                                                         
ACT118     MOVE E-FBW06-CODE-UTIL-TYPE TO MN-CODE-UTIL-TYPE.            
ACT118     MOVE E-FBW06-METER-NO     TO MN-METER-NO.                    
ACT118     MOVE E-FBW06-ACCOUNT-NO   TO MN-ACCOUNT-NO.                  
ACT118*                                                                         
ACT118     EXEC SQL                                                     
ACT007        SELECT TOP(1) MN.CODE_DATA_PRESENT                               
ACT007          INTO :MN-CODE-DATA-PRESENT                              
ACT007          FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
ACT007         WHERE MN.METER_NO       = :MN-METER-NO                   
ACT007           AND MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                 
ACT007           AND MN.CODE_UTIL_TYPE = 'G'                            
ACT007           AND CODE_METER_STATUS NOT IN('K')                      
ACT007                                              
ACT007                                                           
ACT007                                                      
ACT118     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MN.CODE_DATA_PRESENT                                       
MFA-TR*         INTO :MN-CODE-DATA-PRESENT                                      
MFA-TR*         FROM CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE MN.METER_NO       = :MN-METER-NO                           
MFA-TR*          AND MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                         
MFA-TR*          AND MN.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*          AND CODE_METER_STATUS NOT IN('K')                              
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT118*                                                                         
ACT118     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
ACT118*                                                                         
ACT118     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
ACT118         NEXT SENTENCE                                            
ACT118     ELSE                                                         
ACT118         DISPLAY '****************************************'       
ACT118         DISPLAY '**     PCSBW135 PROCESSING ERROR      **'       
ACT118         DISPLAY '**      ABEND IN PARAGRAPH 7300       **'       
ACT118         DISPLAY '**      METER-NO      = ' MN-METER-NO           
ACT118         DISPLAY '**      UTIL TYPE     = ' MN-CODE-UTIL-TYPE     
ACT118         DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
ACT118         DISPLAY '****************************************'       
ACT118         PERFORM 9900-ABEND THRU 9900-EXIT                        
ACT118     END-IF.                                                      
ACT118*                                                                         
ACT118 7300-EXIT.                                                       
ACT118     EXIT.                                                        
      *                                                                         
      ************************************************************              
      *    CPD00038 INCLUDES:                                                   
      *        7600-START-FCSJC01                                               
      *        7610-READ-FCSJC01                                                
      *        7611-CLOSE                                                       
      ************************************************************              
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *7620-START-FCSCA00 VSAM CTRL FILE     *                                  
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *   8000-WRITE-FIOBW06                                          *         
      *****************************************************************         
       8000-WRITE-FIOBW06.                                              
      *                                                                         
           WRITE FIOBW06-REC FROM FIOBW06.                              
      *                                                                         
           IF FBW06-SUCCESSFUL                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSBW135   **'    
              DISPLAY '**        PARA - 8000-WRITE-FIOBW06       **'    
              DISPLAY '**       ERROR DURING WRITE OF FILE       **'    
              DISPLAY '**               FCSBW06                  **'    
              DISPLAY '**  RC = ' WS-FBW06-STATUS                       
              DISPLAY '**          PROCESSING TERMINATED         **'    
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      *   9000-TERMINATE                                                        
      *                                                                         
      ******************************************************************        
       9000-TERMINATE.                                                  
           CLOSE FCSBW02-FILE.                                          
           IF FCSBW02-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR INPROGRAM PCSBW135    **'    
              DISPLAY '**        PARA - 9000-TERMINATE           **'    
              DISPLAY '**       ERROR DURING CLOSE OF FILE       **'    
              DISPLAY '**               FCSBW02                  **'    
              DISPLAY '**  RC = ' WS-FCSBW02-STATUS                     
              DISPLAY '**          PROCESSING TERMINATED         **'
           END-IF.   
      *                                                                         
           CLOSE FCSBW06-FILE.                                          
           IF FBW06-SUCCESSFUL                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSBW135   **'    
              DISPLAY '**        PARA - 9000-TERMINATE           **'    
              DISPLAY '**       ERROR DURING CLOSE OF FILE       **'    
              DISPLAY '**               FCSBW06                  **'    
              DISPLAY '**  RC = ' WS-FBW06-STATUS                       
              DISPLAY '**          PROCESSING TERMINATED         **'
           END-IF.   
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                         
      *   9700-PROCESS-ABEND                                                    
      *                                                                         
      ******************************************************************        
       COPY CPD0023B.                                                           
      ******************************************************************        
      *                                                                         
      *   9900-ABEND                                                            
      *                                                                         
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
