       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW126.                                        
       DATE-WRITTEN.   NOV  2003.                                       
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **                                                             ** 00060000
      **                 PROGRAM MODIFICATION  LOG                   ** 00070000
      **                                                             ** 00080000
      **    DATE     INITIALS    REASON                              ** 00090000
      **    ----     --------    ------                              ** 00100000
      **  11/03/03   VD88125     REWRITE FOR ITRON/AMR PRJ           ** 00110000
C30191**  01/13/04   VD88125     ADDED UTIL_ENVRNMT TO MAIN CURSOR,TO** 00120000
      **                         ELIMINATE MULTIPLE ROWS FROM ROUTE- ** 00130000
      **                         REPORT AND MTR-RD-FMT TABLES.       ** 00140000
C35066**  08/08/07   NC94746     CHANGES DUE TO REPLACING OF READING ** 00150000
C35066**                         FILE WITH BILLING FILE FROM ITRON   ** 00160000
C35066**                         (1) HI-LO FIELD EXCEPTION READS     ** 00170000
C35066**                             HELD UNTIL BILL CYCLE OPEN.     ** 00180000
C35066**                         (2) SUPERVISOR ESTIMATED READS      ** 00190000
C35066**                             HELD UNTIL BILL CYCLE OPEN.     ** 00200000
C36317** 09/30/07    NC94746     POPULATE 90 AS READ CYCLE BY SETING ** 00210000
C36317**                         'N' TO READ-ITEM-STATUS FOR ALL MID ** 00220000
C36317**                         MONTH INFORMATIONAL READS.          ** 00230000
C35066**  10/16/07   NC94746     WS-PGRMNAME VARIABLE INITIALIZED    ** 00240000
C35066**                         WITH PROGRAM NAME (PCSBW126)        ** 00250000
C36661**                                                             ** 00260000
C36661**  01/03/08   SP94986     PROGRAM RUN DATE RETRIEVED FROM     ** 00270000
C36661**                         COMMONDATE PARM AND ADDED A BUSINESS** 00280000
C36661**                         DAY INSTEAD OF COMMON PARM DATE     ** 00290000
C37129**                                                              * 00300000
C37129**  08/14/08   NC94746     PULL PENDING-OFF ORDERS IRRESPECTIVE** 00310000
C37129**                         OF ORDER DATE IN PREMISE TABLE.     ** 00320000
C37129**                                                              * 00330000
P00251** 01/25/10   SS95855       Net Metering                       ** 00340000
P00251**                          Route Report table changed to      ** 00350000
P00251**                          include new columns and removed    ** 00360000
P00251**                          logic that referenced Code Value   ** 00370000
P00251**                          and Meter Read Format table.       ** 00380000
ACT114**  07/24/13   VIJAY       ALLOW TO PULL THE READINGS EVEN AFTER* 00381000
ACT114**  A04527                 COMPLETION OF ORDER TO POST ON ACCO-** 00382000
ACT114**                         UNT(REMOVE PR.PEND_OFF_ORD_DT CHECK)** 00383000
      ***************************************************************** 00390000
      *                                                               * 00400000
      *                       PCSBW126 NARRATIVE                      * 00410000
      *                                                               * 00420000
      *         THIS PROGRAM REFORMATS ROUTE REPORT DATA FOR ACCTS    * 00430000
      *         WITH PENDING OFF SERVICE ORDERS FOR THE CLOSING       * 00440000
      *         CYCLE. IF ACCT BELONGS TO CLOSING CYCLE AND HAS       * 00450000
      *         PENDING OFF ORDER AND HAD A READING FROM ITRON,       * 00460000
      *         THEN INF. IS EXTRACTED FROM ROUTE REPORT TABLE AND    * 00470000
      *         PUT INTO FIOBW06 LIKE FORMAT TO BE PROCESSED BY BW143.* 00480000
      *                                                               * 00490000
C35066*         THIS PROGRAM ALSO REFORMATS FIELD HI-LO EXCEPTION     * 00500000
C35066*         READS & SUPERVISOR ESTIMATED READS THAT WERE HELD     * 00510000
C35066*         UNTIL CYCLE OPEN DATE AND CREATE BW06 FILE TO BE      * 00520000
C35066*         PROCESSED BY BW143.                                   * 00530000
      ***************************************************************** 00540000
      /                                                                 00550000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00570000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSBW06.                                                00600000
      /                                                                 00610000
       DATA DIVISION.                                                   
      *                                                                 00630000
       FILE SECTION.                                                    
       COPY CFDBW06.                                                    00650000
       01  FIOBW06-REC                  PIC X(280).                     
      /                                                                 00670000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW126'.
MSQ017     COPY MFASQLM.
      * FCA00-KEY          *                                            00690000
           EXEC SQL                                                     00700000
              INCLUDE FIOCA00                                           00710000
           END-EXEC.                                                    00720000
      * IO AREA FOR PARM INPUT FILE 'A' *                               00730000
           EXEC SQL                                                     00740000
              INCLUDE FIOJC01                                           00750000
           END-EXEC.                                                    00760000
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSBW126 STARTS HERE'.            
       01  WS-ABEND-AREA.                                               
           05  WS-ABEND-SPACE            PIC X              VALUE SPACE.
           05  WS-ABEND-NUMERIC REDEFINES WS-ABEND-SPACE                
                                         PIC 9.                         
      *                                                                 00830000
       COPY FIOBW06.                                                    00840000
      *                                                                 00850000
      * ABEND SWITCH     *                                              00860000
           COPY CWS09900.                                               00870000
      * WARNING DATA     *                                              00880000
           COPY CWS00303.                                               00890000
      * MISC INPUT       *                                              00900000
           EXEC SQL                                                     00910000
              INCLUDE CWS00038                                          00920000
           END-EXEC.                                                    00930000
      /                                                                 00940000
C36661* FCA00 MISC INPUT *                                              00950000
C36661     EXEC SQL                                                     00960000
C36661        INCLUDE CWS00039                                          00970000
C36661     END-EXEC.                                                    00980000
C36661*                                                                 00990000
C36661     EXEC SQL                                                     01000000
C36661         INCLUDE CWS00315                                         01010000
C36661     END-EXEC.                                                    01020000
C36661*                                                                 01030000
       01  WS-WORK-AREA.                                                
           05  WS-FBW06-STATUS         PIC XX     VALUE '00'.           
               88  FBW06-SUCCESSFUL               VALUE '00'.           
           05  WS-FIOBW06-COUNT          PIC 9(07) VALUE ZERO.          
           05  ACTIVE-PARAGRAPH          PIC X(4).                      
           05  WS-ACCOUNT-NO-PART        PIC S9(13)V COMP-3 VALUE ZERO. 
           05  WS-NULL-IND               PIC S9(04) COMP.               
           05  WS-BILL-CYCLE             PIC X(2)   VALUE '00'.         
           05  WS-REVENUE-MONTH          PIC 9(6).                      
           05  WS-COMPANY-NO             PIC X(2)   VALUE '01'.         
C35066     05  WS-RUN-DATE               PIC X(10).                     
C35066     05  WS-MIDMONTH-CYCLE         PIC X(02)  VALUE SPACES.       
C35066     05  WS-PENDING-ORDER-SW       PIC X      VALUE 'N'.          
C35066         88  WS-PEND-ORDER-READ               VALUE 'N'.          
C35066         88  WS-HILO-EXCEP-READ               VALUE 'Y'.          
       01  WS-DATE-BREAKDOWN.                                           
           03  WS-DATE-CC                PIC 9(2).                      
           03  WS-DATE-YY                PIC 9(2).                      
           03  FILLER                    PIC X(1) VALUE '-'.            
           03  WS-DATE-MM                PIC 9(2).                      
           03  FILLER                    PIC X(1) VALUE '-'.            
           03  WS-DATE-DD                PIC 9(2).                      
       01  WS-LITERALS.                                                 
           05  WS-YES                    PIC X(01)     VALUE 'Y'.       
           05  WS-PRGM-NAME              PIC X(08)     VALUE 'PCSBW126'.
           05  WS-I                      PIC X(01)     VALUE 'I'.       
           05  WS-Y                      PIC X(01)     VALUE 'Y'.       
           05  WS-N                      PIC X(01)     VALUE 'N'.       
           05  WS-NO                     PIC X(01)     VALUE 'N'.       
           05  WS-EXIT                   PIC X(01)     VALUE 'N'.       
           05  WS-NO-MORE-ROWS           PIC X(1)      VALUE 'N'.       
           05  WS-181                    PIC S9(9)     VALUE -181.      
           05  WS-COMMON                 PIC X(06)     VALUE 'COMMON'.  
           05  WS-PGRMNAME               PIC X(08)     VALUE 'PCSBW126'.
           05  WS-CLOSE-DATE             PIC X(10).                     
           05  WS-WORK-DATE              PIC X(10).                     
      *                                                                 01410000
           EXEC SQL                                                     01420000
              INCLUDE SQLCA                                             01430000
           END-EXEC.                                                    01440000
      *                                                                 01450000
           EXEC SQL                                                     01460000
              INCLUDE TBRTERPT                                          01470000
           END-EXEC.                                                    01480000
      *                                                                 01490000
           EXEC SQL                                                     01500000
              INCLUDE TBHLDAY                                           01510000
           END-EXEC.                                                    01520000
      *                                                                 01530000
           EXEC SQL                                                     01540000
               INCLUDE TBJBPARM                                         01550000
           END-EXEC.                                                    01560000
      *                                                                 01570000
           EXEC SQL                                                     01580000
              INCLUDE TBXREF                                            01590000
           END-EXEC.                                                    01600000
      *                                                                 01610000
           EXEC SQL                                                     01620000
              INCLUDE TBACCT                                            01630000
           END-EXEC.                                                    01640000
      *                                                                 01650000
           EXEC SQL                                                     01700000
              INCLUDE TBMTRENV                                          01710000
           END-EXEC.                                                    01720000
      *                                                                 01730000
           EXEC SQL                                                     01740000
              INCLUDE TBRDWNDW                                          01750000
           END-EXEC.                                                    01760000
      *                                                                 01770000
           EXEC SQL                                                     01780000
              INCLUDE TBBILWDW                                          01790000
           END-EXEC.                                                    01800000
      *                                                                 01810000
      ******                                                            01820000
      * DECLARE CURSOR TO SELECT ACCOUNTS WITH PENDING OFF ORDERS       01830000
      * AND THAT BELONG TO THE CYCLE CLOSING TODAY.                     01840000
C37129* REMOVED PENDING ORDER DATE WINDOW CHECK AGAINST PR IN ORDER     01850000
C37129* TO PULL ALL ORDERS EXISTS FOR THE CYCLE BEING CLOSED.           01860000
      ******                                                            01870000
           EXEC SQL                                                     
                 DECLARE EXTRACT_CURSOR CURSOR FOR                      
                 SELECT PW.ACCOUNT_NO,                                  
                        PW.CODE_UTIL_TYPE,                              
                        PW.METER_NO,                                    
                        PW.REG_MEASURE_CD,                              
                        PW.LAST_REG_READ_DT,                            
                        REPLACE(CONVERT(CHAR(8), PW.LAST_REG_READ_TM
           , 108), ':', '.') LAST_REG_READ_TM,                            
                        PW.READING_COND_CD,                             
                        PW.READING_CODE,                                
                        PW.METER_READER_ID,                             
                        PW.REGISTER_RD_SEQ,                             
                        PW.METER_READING,                               
                        PW.CODE_TIME_PERIOD,                            
                        PW.CODE_TOU_SEASN,                              
P00251                  PW.MTR_READ_SOURCE_CD,                          
P00251                  PW.CODE_USAGE_TYPE,                             
P00251                  PW.CODE_USAGE_ID,                               
P00251                  PW.CODE_USAGE_SOURCE,                           
P00251                  PW.CNSMPTN_READ_FL,                             
P00251                  PW.INDEX_VALUE_CD,                              
P00251                  PW.READ_PROCESS_CD,                             
P00251                  PW.READ_STATUS_CD                               
                 FROM   CSS_ACCOUNT      AT WITH(READUNCOMMITTED),              
                        CSS_ROUTE_REPORT PW WITH(READUNCOMMITTED),              
                        CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),              
C30191                  CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                 WHERE  AT.BILL_CYCLE       = :BN-BILL-CYCLE            
                   AND  PW.REVENUE_MONTH    = :PW-REVENUE-MONTH         
                   AND  PW.ACCOUNT_NO       = AT.ACCOUNT_NO             
C30191             AND  PW.TYPE_OF_RD_IND   = 'P'                       
                   AND  PW.BILL_CYCLE       = AT.BILL_CYCLE             
                   AND  MN.ACCOUNT_NO       = PW.ACCOUNT_NO             
                   AND  MN.CODE_UTIL_TYPE   = PW.CODE_UTIL_TYPE         
                   AND  MN.IC_NO            = PW.IC_NO                  
                   AND  MN.MTR_REF_NO       = PW.MTR_REF_NO             
P00251             AND  PW.CNSMPTN_READ_FL  = 'Y'                       
C30191             AND  UT.READ_CYCLE       = PW.READ_CYCLE             
C30191             AND  UT.ACCOUNT_NO       = MN.ACCOUNT_NO             
C30191             AND  UT.CODE_UTIL_TYPE   = MN.CODE_UTIL_TYPE         
C30191             AND  UT.IC_NO            = MN.IC_NO                  
C35066           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01880000
MFA-TR*          DECLARE EXTRACT_CURSOR CURSOR FOR                      01890000
MFA-TR*          SELECT PW.ACCOUNT_NO,                                  01900000
MFA-TR*                 PW.CODE_UTIL_TYPE,                              01910000
MFA-TR*                 PW.METER_NO,                                    01920000
MFA-TR*                 PW.REG_MEASURE_CD,                              01930000
MFA-TR*                 PW.LAST_REG_READ_DT,                            01940000
MFA-TR*                 PW.LAST_REG_READ_TM,                            01950000
MFA-TR*                 PW.READING_COND_CD,                             01960000
MFA-TR*                 PW.READING_CODE,                                01970000
MFA-TR*                 PW.METER_READER_ID,                             01980000
MFA-TR*                 PW.REGISTER_RD_SEQ,                             01990000
MFA-TR*                 PW.METER_READING,                               02000000
MFA-TR*                 PW.CODE_TIME_PERIOD,                            02010000
MFA-TR*                 PW.CODE_TOU_SEASN,                              02020000
MFA-TR*                 PW.MTR_READ_SOURCE_CD,                          02031000
MFA-TR*                 PW.CODE_USAGE_TYPE,                             02040000
MFA-TR*                 PW.CODE_USAGE_ID,                               02050000
MFA-TR*                 PW.CODE_USAGE_SOURCE,                           02060000
MFA-TR*                 PW.CNSMPTN_READ_FL,                             02070000
MFA-TR*                 PW.INDEX_VALUE_CD,                              02080000
MFA-TR*                 PW.READ_PROCESS_CD,                             02090000
MFA-TR*                 PW.READ_STATUS_CD                               02100000
MFA-TR*          FROM   CSS_ACCOUNT      AT,                            02120000
MFA-TR*                 CSS_ROUTE_REPORT PW,                            02140000
MFA-TR*                 CSS_MTRD_ENVRNMT MN,                            02150000
MFA-TR*                 CSS_UTIL_ENVRNMT UT                             02160000
MFA-TR*          WHERE  AT.BILL_CYCLE       = :BN-BILL-CYCLE            02170000
MFA-TR*            AND  PW.REVENUE_MONTH    = :PW-REVENUE-MONTH         02200000
MFA-TR*            AND  PW.ACCOUNT_NO       = AT.ACCOUNT_NO             02210000
MFA-TR*            AND  PW.TYPE_OF_RD_IND   = 'P'                       02220000
MFA-TR*            AND  PW.BILL_CYCLE       = AT.BILL_CYCLE             02240000
MFA-TR*            AND  MN.ACCOUNT_NO       = PW.ACCOUNT_NO             02250000
MFA-TR*            AND  MN.CODE_UTIL_TYPE   = PW.CODE_UTIL_TYPE         02260000
MFA-TR*            AND  MN.IC_NO            = PW.IC_NO                  02270000
MFA-TR*            AND  MN.MTR_REF_NO       = PW.MTR_REF_NO             02280000
MFA-TR*            AND  PW.CNSMPTN_READ_FL  = 'Y'                       02281000
MFA-TR*            AND  UT.READ_CYCLE       = PW.READ_CYCLE             02320000
MFA-TR*            AND  UT.ACCOUNT_NO       = MN.ACCOUNT_NO             02330000
MFA-TR*            AND  UT.CODE_UTIL_TYPE   = MN.CODE_UTIL_TYPE         02340000
MFA-TR*            AND  UT.IC_NO            = MN.IC_NO                  02350000
MFA-TR*          FOR FETCH ONLY WITH UR                                 02360000
MFA-TR*    END-EXEC.                                                    02370000
      *                                                                 02380000
      ******                                                            02390000
      * DECLARE CURSOR TO SELECT BILL CYCLE                             02400000
      ******                                                            02410000
           EXEC SQL                                                     
                 DECLARE BILL_WINDOW_CURSOR CURSOR FOR                  
                 SELECT BILL_CYCLE                                      
                       ,REVENUE_MONTH                                   
                 FROM   CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                
                 WHERE  BN.DATE_EXTRACT   = IIF(TRY_CONVERT(DATE, 
                                                         :WS-CLOSE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CLOSE-DATE
              ) <> 0) OR (LEN(:WS-CLOSE-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CLOSE-DATE
              ), CONVERT(DATE, :WS-CLOSE-DATE) )              
                   AND  BN.CODE_BILL_COND = 'C'                         
C35066           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02420000
MFA-TR*          DECLARE BILL_WINDOW_CURSOR CURSOR FOR                  02430000
MFA-TR*          SELECT BILL_CYCLE                                      02440000
MFA-TR*                ,REVENUE_MONTH                                   02450000
MFA-TR*          FROM   CSS_BILL_WINDOW BN                              02460000
MFA-TR*          WHERE  BN.DATE_EXTRACT   = :WS-CLOSE-DATE              02470000
MFA-TR*            AND  BN.CODE_BILL_COND = 'C'                         02480000
MFA-TR*          FOR FETCH ONLY WITH UR                                 02490000
MFA-TR*    END-EXEC.                                                    02500000
      *                                                                 02510000
C35066***************************************************************** 02520000
C35066* CURSOR TO SELECT BILL CYCLES THAT ARE OPEN ON RUN DATE PLUS   * 02530000
C35066*           SELECT MID-MONTH CYCLE ONLY WHEN ITS READ DATE      * 02540000
C35066*           IS SAME AS THE READ DATE OF BILL CYCLE THAT IS OPEN * 02550000
C35066*           ON RUN DATE.                                        * 02560000
C35066***************************************************************** 02570000
C35066     EXEC SQL                                                     
C35066          DECLARE CYL_OPEN_CSR CURSOR FOR                         
C35066          SELECT BN1.BILL_CYCLE                                   
C35066                ,RW2.READ_CYCLE                                   
C35066                ,RW2.UT_READ_CYCLE                                
C35066                ,BN1.REVENUE_MONTH                                
C35066          FROM CSS_BILL_WINDOW BN1 WITH(READUNCOMMITTED)                  
C35066              ,CSS_READ_WINDOW RW1 WITH(READUNCOMMITTED)                  
C35066              ,CSS_READ_WINDOW RW2 WITH(READUNCOMMITTED)                  
C35066          WHERE BN1.DATE_EXTRACT      = IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
C35066            AND RW1.DATE_MTR_RD_XTRCT = RW2.DATE_MTR_RD_XTRCT     
C35066            AND RW1.REVENUE_MONTH     = RW2.REVENUE_MONTH         
C35066            AND RW1.REVENUE_MONTH     = BN1.REVENUE_MONTH         
C35066            AND RW1.READ_CYCLE        = BN1.BILL_CYCLE            
C35066            AND (RW2.READ_CYCLE       = BN1.BILL_CYCLE            
C35066                 OR RW2.UT_READ_CYCLE > ' ')                      
C35066            AND BN1.DATE_EXTRACT      =                           
C35066                 (SELECT MIN(BN2.DATE_EXTRACT)                    
C35066                  FROM CSS_BILL_WINDOW BN2 WITH(READUNCOMMITTED)          
C35066                  WHERE BN2.BILL_CYCLE    = BN1.BILL_CYCLE        
C35066                    AND BN2.REVENUE_MONTH = BN1.REVENUE_MONTH)    
C35066            FOR READ ONLY                                 
C35066     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02580000
MFA-TR*         DECLARE CYL_OPEN_CSR CURSOR FOR                         02590000
MFA-TR*         SELECT BN1.BILL_CYCLE                                   02600000
MFA-TR*               ,RW2.READ_CYCLE                                   02610000
MFA-TR*               ,RW2.UT_READ_CYCLE                                02620000
MFA-TR*               ,BN1.REVENUE_MONTH                                02630000
MFA-TR*         FROM CSS_BILL_WINDOW BN1                                02640000
MFA-TR*             ,CSS_READ_WINDOW RW1                                02650000
MFA-TR*             ,CSS_READ_WINDOW RW2                                02660000
MFA-TR*         WHERE BN1.DATE_EXTRACT      = :WS-RUN-DATE              02670000
MFA-TR*           AND RW1.DATE_MTR_RD_XTRCT = RW2.DATE_MTR_RD_XTRCT     02680000
MFA-TR*           AND RW1.REVENUE_MONTH     = RW2.REVENUE_MONTH         02690000
MFA-TR*           AND RW1.REVENUE_MONTH     = BN1.REVENUE_MONTH         02700000
MFA-TR*           AND RW1.READ_CYCLE        = BN1.BILL_CYCLE            02710000
MFA-TR*           AND (RW2.READ_CYCLE       = BN1.BILL_CYCLE            02720000
MFA-TR*                OR RW2.UT_READ_CYCLE > ' ')                      02730000
MFA-TR*           AND BN1.DATE_EXTRACT      =                           02740000
MFA-TR*                (SELECT MIN(BN2.DATE_EXTRACT)                    02750000
MFA-TR*                 FROM CSS_BILL_WINDOW BN2                        02760000
MFA-TR*                 WHERE BN2.BILL_CYCLE    = BN1.BILL_CYCLE        02770000
MFA-TR*                   AND BN2.REVENUE_MONTH = BN1.REVENUE_MONTH)    02780000
MFA-TR*           FOR FETCH ONLY WITH UR                                02790000
MFA-TR*    END-EXEC.                                                    02800000
C35066*                                                                 02810000
C35066***************************************************************** 02820000
C35066* CURSOR TO SELECT ACCOUNTS TO PROCESS ON ITS CYCLE OPEN DATE   * 02830000
C35066*         -->ACCOUNTS FLAGED WITH 'H' - HILO FAILD AT FIELD     * 02840000
C35066*         -->ACCOUNTS FLAGED WITH 'S' - SUPERVISOR ESTIMATES    * 02850000
C35066*         -->NORMAL & MID-MONTH CYCLE ACCOUNTS WITH ABOVE FLAGS * 02860000
C35066***************************************************************** 02870000
C35066******                                                            02880000
C35066     EXEC SQL                                                     
C35066           DECLARE HILO_EXTRACT_CSR CURSOR FOR                    
C35066           SELECT PW.ACCOUNT_NO                                   
C35066                 ,PW.CODE_UTIL_TYPE                               
C35066                 ,PW.METER_NO                                     
C35066                 ,PW.REG_MEASURE_CD                               
C35066                 ,PW.LAST_REG_READ_DT                             
C35066                 ,REPLACE(CONVERT(CHAR(8), PW.LAST_REG_READ_TM
           , 108), ':', '.') LAST_REG_READ_TM                             
C35066                 ,PW.READING_COND_CD                              
C35066                 ,PW.READING_CODE                                 
C35066                 ,PW.METER_READER_ID                              
C35066                 ,PW.REGISTER_RD_SEQ                              
C35066                 ,PW.METER_READING                                
C35066                 ,PW.CODE_TIME_PERIOD                             
C35066                 ,PW.CODE_TOU_SEASN                               
P00251                 ,PW.MTR_READ_SOURCE_CD                           
P00251                 ,PW.CODE_USAGE_TYPE                              
P00251                 ,PW.CODE_USAGE_ID                                
P00251                 ,PW.CODE_USAGE_SOURCE                            
P00251                 ,PW.CNSMPTN_READ_FL                              
P00251                 ,PW.INDEX_VALUE_CD                               
P00251                 ,PW.READ_PROCESS_CD                              
P00251                 ,PW.READ_STATUS_CD                               
C35066           FROM   CSS_ACCOUNT      AT WITH(READUNCOMMITTED)               
C35066                 ,CSS_ROUTE_REPORT PW WITH(READUNCOMMITTED)               
C35066                 ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)               
C35066                 ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
C35066           WHERE AT.BILL_CYCLE       = :BN-BILL-CYCLE             
C35066             AND PW.REVENUE_MONTH    = :PW-REVENUE-MONTH          
C35066             AND PW.ACCOUNT_NO       = AT.ACCOUNT_NO              
C35066             AND PW.TYPE_OF_RD_IND   IN ( 'H', 'S' )              
C35066             AND PW.BILL_CYCLE       = AT.BILL_CYCLE              
C35066             AND (PW.READ_CYCLE      = :WS-MIDMONTH-CYCLE         
C35066                  OR PW.READ_CYCLE   = UT.READ_CYCLE )            
C35066             AND MN.ACCOUNT_NO       = PW.ACCOUNT_NO              
C35066             AND MN.CODE_UTIL_TYPE   = PW.CODE_UTIL_TYPE          
C35066             AND MN.IC_NO            = PW.IC_NO                   
C35066             AND MN.MTR_REF_NO       = PW.MTR_REF_NO              
C35066             AND UT.ACCOUNT_NO       = MN.ACCOUNT_NO              
C35066             AND UT.CODE_UTIL_TYPE   = MN.CODE_UTIL_TYPE          
C35066             AND UT.IC_NO            = MN.IC_NO                   
C35066           FOR READ ONLY                                  
C35066     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02890000
MFA-TR*          DECLARE HILO_EXTRACT_CSR CURSOR FOR                    02900000
MFA-TR*          SELECT PW.ACCOUNT_NO                                   02910000
MFA-TR*                ,PW.CODE_UTIL_TYPE                               02920000
MFA-TR*                ,PW.METER_NO                                     02930000
MFA-TR*                ,PW.REG_MEASURE_CD                               02940000
MFA-TR*                ,PW.LAST_REG_READ_DT                             02950000
MFA-TR*                ,PW.LAST_REG_READ_TM                             02960000
MFA-TR*                ,PW.READING_COND_CD                              02970000
MFA-TR*                ,PW.READING_CODE                                 02980000
MFA-TR*                ,PW.METER_READER_ID                              02990000
MFA-TR*                ,PW.REGISTER_RD_SEQ                              03000000
MFA-TR*                ,PW.METER_READING                                03010000
MFA-TR*                ,PW.CODE_TIME_PERIOD                             03020000
MFA-TR*                ,PW.CODE_TOU_SEASN                               03030000
MFA-TR*                ,PW.MTR_READ_SOURCE_CD                           03071000
MFA-TR*                ,PW.CODE_USAGE_TYPE                              03080000
MFA-TR*                ,PW.CODE_USAGE_ID                                03090000
MFA-TR*                ,PW.CODE_USAGE_SOURCE                            03100000
MFA-TR*                ,PW.CNSMPTN_READ_FL                              03110000
MFA-TR*                ,PW.INDEX_VALUE_CD                               03120000
MFA-TR*                ,PW.READ_PROCESS_CD                              03130000
MFA-TR*                ,PW.READ_STATUS_CD                               03140000
MFA-TR*          FROM   CSS_ACCOUNT      AT                             03160000
MFA-TR*                ,CSS_ROUTE_REPORT PW                             03170000
MFA-TR*                ,CSS_MTRD_ENVRNMT MN                             03180000
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                             03190000
MFA-TR*          WHERE AT.BILL_CYCLE       = :BN-BILL-CYCLE             03200000
MFA-TR*            AND PW.REVENUE_MONTH    = :PW-REVENUE-MONTH          03210000
MFA-TR*            AND PW.ACCOUNT_NO       = AT.ACCOUNT_NO              03220000
MFA-TR*            AND PW.TYPE_OF_RD_IND   IN ( 'H', 'S' )              03230000
MFA-TR*            AND PW.BILL_CYCLE       = AT.BILL_CYCLE              03240000
MFA-TR*            AND (PW.READ_CYCLE      = :WS-MIDMONTH-CYCLE         03250000
MFA-TR*                 OR PW.READ_CYCLE   = UT.READ_CYCLE )            03260000
MFA-TR*            AND MN.ACCOUNT_NO       = PW.ACCOUNT_NO              03270000
MFA-TR*            AND MN.CODE_UTIL_TYPE   = PW.CODE_UTIL_TYPE          03280000
MFA-TR*            AND MN.IC_NO            = PW.IC_NO                   03290000
MFA-TR*            AND MN.MTR_REF_NO       = PW.MTR_REF_NO              03300000
MFA-TR*            AND UT.ACCOUNT_NO       = MN.ACCOUNT_NO              03340000
MFA-TR*            AND UT.CODE_UTIL_TYPE   = MN.CODE_UTIL_TYPE          03350000
MFA-TR*            AND UT.IC_NO            = MN.IC_NO                   03360000
MFA-TR*          FOR FETCH ONLY WITH UR                                 03370000
MFA-TR*    END-EXEC.                                                    03380000
C35066*                                                                 03390000
      /                                                                 03400000
       PROCEDURE DIVISION.                                              
      ******************************************************************03420000
      *   0000-MAINLINE                                                *03430000
      *        CONTROLS THE MAIN PATH OF PROGRAM                       *03440000
      ******************************************************************03450000
       0000-MAINLINE.                                                   
      *                                                                 03470000
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
           MOVE SPACES                     TO FIOBW06.                  
      *                                                                 03500000
           MOVE WS-COMPANY-NO              TO  G6-COMPANY-NO.           
           PERFORM 0200-GET-PARM-DATA      THRU 0200-EXIT.              
C35066*                                                                 03530000
C35066     PERFORM 1000-PROCESS-PENDING-ORDERS                          
C35066        THRU 1000-EXIT.                                           
C35066*                                                                 03560000
C35066     PERFORM 0300-PROCESS-HILO-EXCEPTIONS                         
C35066        THRU 0300-EXIT.                                           
      *                                                                 03590000
                                                                        
           PERFORM 0120-WRITE-END-REC      THRU 0120-EXIT.              
      *                                                                 03620000
           PERFORM 9000-TERMINATE          THRU 9000-EXIT               
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************03680000
      *   0100-INITIALIZATION                                          *03690000
      *        COMMON INITIALIZATION ROUTINE                           *03700000
      ******************************************************************03710000
       0100-INITIALIZATION.                                             
      *                                                                 03730000
           OPEN OUTPUT FCSBW06-FILE.                                    
           IF  FBW06-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************* PCSBW126 ************'             
              DISPLAY '** BW06 FILE OPEN STATUS = ' WS-FBW06-STATUS     
              DISPLAY '** PROCESSING TERMINATED         **'             
              PERFORM 9900-ABEND                       THRU 9900-EXIT   
           END-IF                                                       
           MOVE ZEROS TO WS-FIOBW06-COUNT.                              
      *                                                                 03840000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03870000
       0120-WRITE-END-REC.                                              
      *                                                                 03890000
           INITIALIZE FIOBW06.                                          
           MOVE ALL '9'     TO E-FBW06-RECORD-KEY                       
           MOVE 1           TO E-FBW06-DB-PART-DREC                     
           PERFORM 8000-WRITE-FIOBW06 THRU 8000-EXIT                    
           .                                                            
      *                                                                 03950000
       0120-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************03980000
      *   0200-GET-PARM-DATA                                           *03990000
      *        ACCESS OF COMMON-DATE RECORD                            *04000000
      ******************************************************************04010000
       0200-GET-PARM-DATA.                                              
      *                                                                 04030000
C36661*    GET COMMON DATE                                              04040000
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF  COMMON-DATE-NEEDED                                       
C36661         PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
C36661         DISPLAY 'COMMONDATE ==> ' WS-FCA00-COMMON-DATE           
C36661         MOVE WS-FCA00-COMMON-DATE   TO WS-INPUT-DATE             
C36661                                        WS-NEW-BUSINESS-DAY       
C36661         PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU                  
C36661                 6500-NEXT-BUSINESS-DAY-EXIT                      
C36661                 UNTIL NEXT-BUSINESS-DAY-FOUND                    
C36661         MOVE WS-NEW-BUSINESS-DAY    TO WS-INPUT-DATE             
           END-IF.                                                      
C36661*                                                                 04160000
C36661     DISPLAY ' '                                                  
C36661     DISPLAY '**************************************'             
C36661     DISPLAY  'PROGRAM RUN DATE ======> ' WS-INPUT-DATE           
C36661     DISPLAY '**************************************'             
C36661*                                                                 04210000
C36661     MOVE WS-INPUT-DATE              TO WS-RUN-DATE               
C36661                                        WS-CLOSE-DATE.            
C36661*                                                                 04240000
       0200-EXIT.                                                       
           EXIT.                                                        
C35066*                                                                 04270000
C35066*================================================================*04280000
C35066 0300-PROCESS-HILO-EXCEPTIONS.                                    
C35066*================================================================*04300000
C35066*----------------------------------------------------------------*04310000
C35066***  PROCESS EXCEPTION READS WHICH ARE HELD FOR CYCLE OPEN DATE  *04320000
C35066***         -HILO FAILED READS AT FIELD                          *04330000
C35066***         -SUPERVISOR ESTIMATED READS                          *04340000
C35066*----------------------------------------------------------------*04350000
C35066     PERFORM 7230-OPEN-CYL-OPEN-CSR   THRU 7230-EXIT.             
C35066     PERFORM 7240-FETCH-CYL-OPEN-CSR  THRU 7240-EXIT.             
C35066     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35066        DISPLAY ' '                                               
C35066        DISPLAY 'PROCESS HILO FAILED & SUPERVISOR ESTIMATED READS'
C35066*                                                                 04410000
C35066        PERFORM 0310-PROCESS-HILO-BY-CYCLE THRU 0310-EXIT         
C35066             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
C35066     ELSE                                                         
C35066        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
C35066           DISPLAY '************* PCSBW126 ******************'    
C35066           DISPLAY '*** NO HILO EXCEP READS  EXISTS      ***'     
C35066           DISPLAY '*** NO CYCLE OPENS FOR BELOW DATE    ***'     
C35066           DISPLAY '*** OPEN DATE     = ' WS-RUN-DATE             
C35066           DISPLAY '*****************************************'    
C35066        END-IF                                                    
C35066     END-IF.                                                      
C35066*                                                                 04530000
C35066     PERFORM 7250-CLOSE-CYL-OPEN-CSR  THRU 7250-EXIT.             
C35066                                                                  
C35066 0300-EXIT.                                                       
C35066     EXIT.                                                        
C35066*                                                                 04580000
C35066*================================================================*04590000
C35066 0310-PROCESS-HILO-BY-CYCLE.                                      
C35066*================================================================*04610000
C35066*                                                                 04620000
C35066     IF RW-UT-READ-CYCLE = SPACES                                 
C35066***     NORMAL CYCLES OPEN ON RUN DATE ARE ALREADY                04640000
C35066***     ASSIGNED TO BN-BILL-CYCLE FIELD                           04650000
C35066        MOVE SPACES TO WS-MIDMONTH-CYCLE                          
C35066     ELSE                                                         
C35066***     MID-MONTH CYCLE AND ITS CORRESPONDING BILL CYCLE          04680000
C35066        MOVE RW-READ-CYCLE    TO WS-MIDMONTH-CYCLE                
C35066        MOVE RW-UT-READ-CYCLE TO BN-BILL-CYCLE                    
C35066     END-IF.                                                      
C35066*                                                                 04720000
C35066     DISPLAY '  '                                                 
C35066     IF WS-MIDMONTH-CYCLE = SPACES                                
C35066        DISPLAY 'PROCESSING CYCLE: ' BN-BILL-CYCLE                
C35066                ' AND REV MONTH: ' BN-REVENUE-MONTH               
C35066     ELSE                                                         
C35066        DISPLAY 'PROCESSING CYCLE: MID-MONTH'                     
C35066                ' AND REV MONTH: ' BN-REVENUE-MONTH               
C35066     END-IF.                                                      
C35066     DISPLAY '  '                                                 
C35066     MOVE BN-REVENUE-MONTH     TO PW-REVENUE-MONTH.               
C35066                                                                  
C35066     PERFORM 7330-OPEN-HILO-EXCEP-READS  THRU 7330-EXIT.          
C35066     PERFORM 7340-FETCH-HILO-EXCEP-READS THRU 7340-EXIT.          
C35066     SET WS-HILO-EXCEP-READ TO TRUE                               
C35066     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35066        PERFORM 1200-PROCESS-ROUTES     THRU 1200-EXIT            
C35066           UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
C35066     ELSE                                                         
C35066        DISPLAY '    *** NO ACCOUNTS/METERS SELECTED ***'         
C35066     END-IF.                                                      
C35066     PERFORM 7350-CLOSE-HILO-EXCEP-READS THRU 7350-EXIT.          
C35066                                                                  
C35066     PERFORM 7240-FETCH-CYL-OPEN-CSR THRU 7240-EXIT.              
C35066*                                                                 04960000
C35066 0310-EXIT.                                                       
C35066     EXIT.                                                        
      *                                                                 04990000
      *================================================================*05000000
       1000-PROCESS-PENDING-ORDERS.                                     
      *================================================================*05020000
      *                                                                 05030000
           PERFORM 7200-OPEN-BILL-WINDOW   THRU 7200-EXIT.              
           PERFORM 7210-FETCH-BILL-WINDOW  THRU 7210-EXIT.              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              DISPLAY '************* PCSBW126 ************'             
      *                                                                 05080000
              PERFORM 1100-PROCESS-EACH-CYCLE  THRU 1100-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 DISPLAY '************* PCSBW126 ******************'    
                 DISPLAY '*** NO PENDING-OFF ORDERS EXISTS      ***'    
                 DISPLAY '*** NO CYCLE CLOSES FOR BELOW DATE    ***'    
                 DISPLAY '*** CLOSE DATE     = ' WS-CLOSE-DATE          
                 DISPLAY '*** REVENUE MONTH  = ' BN-REVENUE-MONTH       
                 DISPLAY '*** CODE BILL COND = C'                       
                 DISPLAY '*****************************************'    
              END-IF                                                    
           END-IF.                                                      
      *                                                                 05220000
           PERFORM 7220-CLOSE-BILL-WINDOW  THRU 7220-EXIT.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05270000
      /*****************************************************************05280000
      *       1100-PROCESS-EACH-CYCLE                                  *05290000
      ******************************************************************05300000
       1100-PROCESS-EACH-CYCLE.                                         
      *                                                                 05320000
C35066     DISPLAY 'PROCESSING CYCLE: ' BN-BILL-CYCLE                   
                ' PENDORD ACCOUNTS FOR REV MONTH: ' BN-REVENUE-MONTH    
           DISPLAY '  '                                                 
                                                                        
           MOVE BN-REVENUE-MONTH           TO PW-REVENUE-MONTH.         
                                                                        
           PERFORM 7300-OPEN-ROUTE-REPORT  THRU 7300-EXIT.              
           PERFORM 7310-FETCH-ROUTE-REPORT THRU 7310-EXIT.              
C35066     SET WS-PEND-ORDER-READ TO TRUE                               
C35066     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 1200-PROCESS-ROUTES     THRU 1200-EXIT            
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
C35066     ELSE                                                         
C35066        DISPLAY '    *** NO ACCOUNTS/METERS SELECTED ***'         
C35066     END-IF.                                                      
           PERFORM 7320-CLOSE-ROUTE-REPORT THRU 7320-EXIT.              
                                                                        
           PERFORM 7210-FETCH-BILL-WINDOW  THRU 7210-EXIT.              
      *                                                                 05510000
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05540000
      /*****************************************************************05550000
      *       1200-PROCESS-ROUTES                                      *05560000
C35066******************************************************************05570000
C35066 1200-PROCESS-ROUTES.                                             
C35066*                                                                 05590000
P00251     PERFORM 1210-FORMAT-BW06-OUTPUT    THRU 1210-EXIT.           
C35066     IF WS-PEND-ORDER-READ                                        
C35066        PERFORM 7310-FETCH-ROUTE-REPORT THRU 7310-EXIT            
C35066     ELSE                                                         
C35066        PERFORM 7340-FETCH-HILO-EXCEP-READS THRU 7340-EXIT        
C35066     END-IF.                                                      
C35066*                                                                 05670000
C35066 1200-EXIT.                                                       
C35066     EXIT.                                                        
C35066*                                                                 05700000
C35066*================================================================*05710000
C35066 1210-FORMAT-BW06-OUTPUT.                                         
C35066*================================================================*05730000
C35066*                                                                 05740000
C35066     MOVE SPACES                     TO FIOBW06.                  
C35066     MOVE PW-ACCOUNT-NO              TO E-FBW06-ACCOUNT-NO        
C35066     MOVE PW-METER-NO                TO E-FBW06-METER-NO          
C35066     MOVE PW-CODE-UTIL-TYPE          TO E-FBW06-CODE-UTIL-TYPE    
C35066     MOVE PW-CODE-TIME-PERIOD        TO E-FBW06-CODE-TIME-PERIOD  
C35066     MOVE PW-CODE-TOU-SEASN          TO E-FBW06-CODE-TOU-SEASN    
C35066     MOVE PW-REG-MEASURE-CD          TO E-FBW06-REG-MEASURE-CD    
C35066     MOVE PW-METER-READING           TO E-FBW06-METER-READING     
C35066     MOVE PW-LAST-REG-READ-DT        TO E-FBW06-DATE-READ         
C35066     MOVE PW-LAST-REG-READ-TM        TO E-FBW06-TIME-READ         
C35066     MOVE PW-READING-CODE            TO E-FBW06-CODE-METER-READ   
C35066     MOVE PW-READING-COND-CD         TO E-FBW06-CODE-METER-NO-READ
C35066     MOVE SPACES                     TO E-FBW06-MTR-COMMENT-TX    
C35066                                        E-FBW06-MTR-COND-CD1      
C35066                                        E-FBW06-MTR-COND-CD2      
C35066     MOVE PW-METER-READER-ID         TO E-FBW06-EMPLOYEE-NO       
P00251     MOVE PW-MTR-READ-SOURCE-CD      TO E-FBW06-MTR-READ-SOURCE-CD
P00251     MOVE PW-CODE-USAGE-TYPE         TO E-FBW06-CODE-USAGE-TYPE   
P00251     MOVE PW-CODE-USAGE-ID           TO E-FBW06-CODE-USAGE-ID     
P00251     MOVE PW-CODE-USAGE-SOURCE       TO E-FBW06-CODE-USAGE-SOURCE 
P00251     MOVE PW-CNSMPTN-READ-FL         TO E-FBW06-CNSMPTN-READ-FL   
P00251     MOVE PW-INDEX-VALUE-CD          TO E-FBW06-INDEX-VALUE-CD    
P00251     MOVE PW-READ-PROCESS-CD         TO E-FBW06-READ-PROCESS-CD   
P00251     MOVE PW-READ-STATUS-CD          TO E-FBW06-READ-ITEM-STATUS  
C35066     MOVE ZEROS                      TO E-FBW06-BTU-FACTOR        
C35066     MOVE 1                          TO E-FBW06-DB-PART-DREC.     
C35066                                                                  
C35066     DISPLAY 'EXTRACTED METER-NO: ',  E-FBW06-CODE-UTIL-TYPE,     
C35066                                 '|', E-FBW06-METER-NO,           
C35066                                 '|', E-FBW06-REG-MEASURE-CD,     
C35066                        ' ACCT-NO: ', E-FBW06-ACCOUNT-NO.         
C35066                                                                  
C35066     PERFORM 8000-WRITE-FIOBW06 THRU 8000-EXIT.                   
C35066     ADD 1                           TO WS-FIOBW06-COUNT.         
C35066*                                                                 06090000
C35066 1210-EXIT.                                                       
C35066     EXIT.                                                        
C35066*                                                                 06120000
       7200-OPEN-BILL-WINDOW.                                           
      *                                                                 06140000
           EXEC SQL                                                     
                OPEN BILL_WINDOW_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7200-OPEN-BILL-WINDOW'                          
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND         THRU 9900-EXIT
           END-IF.               
      *                                                                 06260000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06290000
       7210-FETCH-BILL-WINDOW.                                          
      *                                                                 06310000
           EXEC SQL                                                     
              FETCH BILL_WINDOW_CURSOR                                  
               INTO :BN-BILL-CYCLE                                      
                   ,:BN-REVENUE-MONTH                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7210-FETCH-BILL-WINDOW'                          
              DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
              PERFORM 7220-CLOSE-BILL-WINDOW                            
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                 06480000
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06510000
       7220-CLOSE-BILL-WINDOW.                                          
      *                                                                 06530000
           EXEC SQL                                                     
                CLOSE BILL_WINDOW_CURSOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7220-CLOSE-BILL-WINDOW'                         
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND         THRU 9900-EXIT
           END-IF.               
      *                                                                 06650000
       7220-EXIT.                                                       
           EXIT.                                                        
C35066*===============================================================* 06680000
C35066 7230-OPEN-CYL-OPEN-CSR.                                          
C35066*===============================================================* 06700000
C35066*                                                                 06710000
C35066     EXEC SQL                                                     
C35066          OPEN CYL_OPEN_CSR                                       
C35066     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35066                                                                  
C35066     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35066     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35066         CONTINUE                                                 
C35066     ELSE                                                         
C35066         DISPLAY '******************************************'     
C35066         DISPLAY '7230-OPEN-CYL_OPEN_CSR'                         
C35066         DISPLAY 'DATE_EXTRACT  = ' WS-RUN-DATE                   
C35066         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
C35066         PERFORM 9900-ABEND         THRU 9900-EXIT                
C35066         DISPLAY '******************************************'     
C35066     END-IF.                                                      
C35066*                                                                 06870000
C35066 7230-EXIT.                                                       
C35066     EXIT.                                                        
C35066*                                                                 06900000
C35066*===============================================================* 06910000
C35066 7240-FETCH-CYL-OPEN-CSR.                                         
C35066*===============================================================* 06930000
C35066*                                                                 06940000
C35066     EXEC SQL                                                     
C35066        FETCH CYL_OPEN_CSR                                        
C35066         INTO :BN-BILL-CYCLE                                      
C35066             ,:RW-READ-CYCLE                                      
C35066             ,:RW-UT-READ-CYCLE                                   
C35066             ,:BN-REVENUE-MONTH                                   
C35066     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35066                                                                  
C35066     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35066                                                                  
C35066     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35066                              OR NOT-FOUND                        
C35066        CONTINUE                                                  
C35066     ELSE                                                         
C35066        DISPLAY '******************************************'      
C35066        DISPLAY '7240-FETCH-CYL_OPEN_CSR'                         
C35066        DISPLAY 'DATE_EXTRACT  = ' WS-RUN-DATE                    
C35066        DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
C35066        PERFORM 9900-ABEND THRU 9900-EXIT                         
C35066        DISPLAY '******************************************'      
C35066     END-IF.                                                      
C35066*                                                                 07160000
C35066 7240-EXIT.                                                       
C35066     EXIT.                                                        
C35066*                                                                 07190000
C35066*===============================================================* 07200000
C35066 7250-CLOSE-CYL-OPEN-CSR.                                         
C35066*===============================================================* 07220000
C35066*                                                                 07230000
C35066     EXEC SQL                                                     
C35066          CLOSE CYL_OPEN_CSR                                      
C35066     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35066                                                                  
C35066     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35066     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35066         CONTINUE                                                 
C35066     ELSE                                                         
C35066         DISPLAY '******************************************'     
C35066         DISPLAY '7250-CLOSE-CYL_OPEN_CSR'                        
C35066         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
C35066         PERFORM 9900-ABEND         THRU 9900-EXIT                
C35066         DISPLAY '******************************************'     
C35066     END-IF.                                                      
C35066*                                                                 07380000
C35066 7250-EXIT.                                                       
C35066     EXIT.                                                        
      *                                                                 07410000
       7300-OPEN-ROUTE-REPORT.                                          
      *                                                                 07430000
           EXEC SQL                                                     
                OPEN EXTRACT_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7300-OPEN-ROUTE-REPORT'                         
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND         THRU 9900-EXIT
           END-IF.               
      *                                                                 07550000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07580000
       7310-FETCH-ROUTE-REPORT.                                         
      *                                                                 07600000
           EXEC SQL                                                     
              FETCH EXTRACT_CURSOR                                      
               INTO :PW-ACCOUNT-NO                                      
                   ,:PW-CODE-UTIL-TYPE                                  
                   ,:PW-METER-NO                                        
                   ,:PW-REG-MEASURE-CD                                  
                   ,:PW-LAST-REG-READ-DT                                
                   ,:PW-LAST-REG-READ-TM                                
                   ,:PW-READING-COND-CD                                 
                   ,:PW-READING-CODE                                    
                   ,:PW-METER-READER-ID                                 
                   ,:PW-REGISTER-RD-SEQ                                 
                   ,:PW-METER-READING                                   
                   ,:PW-CODE-TIME-PERIOD                                
                   ,:PW-CODE-TOU-SEASN                                  
P00251             ,:PW-MTR-READ-SOURCE-CD                              
P00251             ,:PW-CODE-USAGE-TYPE                                 
P00251             ,:PW-CODE-USAGE-ID                                   
P00251             ,:PW-CODE-USAGE-SOURCE                               
P00251             ,:PW-CNSMPTN-READ-FL                                 
P00251             ,:PW-INDEX-VALUE-CD                                  
P00251             ,:PW-READ-PROCESS-CD                                 
P00251             ,:PW-READ-STATUS-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7310-FETCH-ROUTE-REPORT'                         
              DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
              PERFORM 7320-CLOSE-ROUTE-REPORT THRU 7320-EXIT            
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                 07970000
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08000000
       7320-CLOSE-ROUTE-REPORT.                                         
      *                                                                 08020000
           EXEC SQL                                                     
                CLOSE EXTRACT_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7320-CLOSE-ROUTE-REPORT'                        
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND         THRU 9900-EXIT
           END-IF.               
      *                                                                 08140000
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08170000
C35066*===============================================================* 08180000
C35066 7330-OPEN-HILO-EXCEP-READS.                                      
C35066*===============================================================* 08200000
C35066*                                                                 08210000
C35066     EXEC SQL                                                     
C35066          OPEN HILO_EXTRACT_CSR                                   
C35066     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35066                                                                  
C35066     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35066     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35066         CONTINUE                                                 
C35066     ELSE                                                         
C35066         DISPLAY '******************************************'     
C35066         DISPLAY '7330-OPEN-HILO-EXCEP-READS'                     
C35066         DISPLAY 'BILL_CYCLE       = ' BN-BILL-CYCLE              
C35066         DISPLAY 'REVENUE_MONTH    = ' PW-REVENUE-MONTH           
C35066         DISPLAY 'TYPE_OF_RD_IND   = H OR S'                      
C35066         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
C35066         PERFORM 9900-ABEND         THRU 9900-EXIT                
C35066         DISPLAY '******************************************'     
C35066     END-IF.                                                      
C35066*                                                                 08390000
C35066 7330-EXIT.                                                       
C35066     EXIT.                                                        
C35066*                                                                 08420000
C35066*===============================================================* 08430000
C35066 7340-FETCH-HILO-EXCEP-READS.                                     
C35066*===============================================================* 08450000
C35066*                                                                 08460000
C35066     EXEC SQL                                                     
C35066        FETCH HILO_EXTRACT_CSR                                    
C35066         INTO :PW-ACCOUNT-NO                                      
C35066             ,:PW-CODE-UTIL-TYPE                                  
C35066             ,:PW-METER-NO                                        
C35066             ,:PW-REG-MEASURE-CD                                  
C35066             ,:PW-LAST-REG-READ-DT                                
C35066             ,:PW-LAST-REG-READ-TM                                
C35066             ,:PW-READING-COND-CD                                 
C35066             ,:PW-READING-CODE                                    
C35066             ,:PW-METER-READER-ID                                 
C35066             ,:PW-REGISTER-RD-SEQ                                 
C35066             ,:PW-METER-READING                                   
C35066             ,:PW-CODE-TIME-PERIOD                                
C35066             ,:PW-CODE-TOU-SEASN                                  
P00251             ,:PW-MTR-READ-SOURCE-CD                              
P00251             ,:PW-CODE-USAGE-TYPE                                 
P00251             ,:PW-CODE-USAGE-ID                                   
P00251             ,:PW-CODE-USAGE-SOURCE                               
P00251             ,:PW-CNSMPTN-READ-FL                                 
P00251             ,:PW-INDEX-VALUE-CD                                  
P00251             ,:PW-READ-PROCESS-CD                                 
P00251             ,:PW-READ-STATUS-CD                                  
C35066     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35066                                                                  
C35066     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35066                                                                  
C35066     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35066                              OR NOT-FOUND                        
C35066        CONTINUE                                                  
C35066     ELSE                                                         
C35066        DISPLAY '******************************************'      
C35066        DISPLAY '7340-FETCH-HILO-EXCEP-READS'                     
C35066        DISPLAY 'BILL_CYCLE       = ' BN-BILL-CYCLE               
C35066        DISPLAY 'REVENUE_MONTH    = ' PW-REVENUE-MONTH            
C35066        DISPLAY 'TYPE_OF_RD_IND   = H OR S'                       
C35066        DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
C35066        PERFORM 9900-ABEND THRU 9900-EXIT                         
C35066        DISPLAY '******************************************'      
C35066     END-IF.                                                      
C35066*                                                                 08910000
C35066 7340-EXIT.                                                       
C35066     EXIT.                                                        
C35066*                                                                 08940000
C35066*===============================================================* 08950000
C35066 7350-CLOSE-HILO-EXCEP-READS.                                     
C35066*===============================================================* 08970000
C35066*                                                                 08980000
C35066     EXEC SQL                                                     
C35066          CLOSE HILO_EXTRACT_CSR                                  
C35066     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35066                                                                  
C35066     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35066     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35066         CONTINUE                                                 
C35066     ELSE                                                         
C35066         DISPLAY '******************************************'     
C35066         DISPLAY '7350-CLOSE-HILO-EXCEP-READS'                    
C35066         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
C35066         PERFORM 9900-ABEND         THRU 9900-EXIT                
C35066         DISPLAY '******************************************'     
C35066     END-IF.                                                      
C35066*                                                                 09130000
C35066 7350-EXIT.                                                       
C35066     EXIT.                                                        
C35066*                                                                 09160000
      /                                                                 09170000
      * READ PARM FILE FOR OVERRIDE DATE      *                         09180000
           COPY CPD00037.                                               09190000
      /                                                                 09200000
C36661* GET FCA00 COMMON DATE                 *                         09210000
C36661     COPY CPD00040.                                               09220000
C36661*                                                                 09230000
C36661******************************************************************09240000
C36661* COPYBOOK TO GET THE NEXT BUSINESS DAY                          *09250000
C36661******************************************************************09260000
C36661     EXEC SQL                                                     09270000
C36661         INCLUDE CPD00315                                         09280000
C36661     END-EXEC.                                                    09290000
C36661*                                                                 09300000
      * 7600-START-FCSJC01                    *                         09310000
           EXEC SQL                                                     09320000
              INCLUDE CPD00038                                          09330000
           END-EXEC.                                                    09340000
      *                                                                 09350000
C36661* 7620-START-FCSCA00 VSAM CTRL FILE     *                         09360000
C36661     EXEC SQL                                                     09370000
C36661        INCLUDE CPD00039                                          09380000
C36661     END-EXEC.                                                    09390000
      *                                                                 09400000
      /**************************************************************** 09410000
      *   8000-WRITE-FIOBW06                                          * 09420000
      ***************************************************************** 09430000
       8000-WRITE-FIOBW06.                                              
      *                                                                 09450000
           WRITE FIOBW06-REC FROM FIOBW06.                              
      *                                                                 09470000
       8000-EXIT.                                                       
           EXIT.                                                        
      /**************************************************************** 09500000
      *   9000-TERMINATE                                              * 09510000
      ***************************************************************** 09520000
       9000-TERMINATE.                                                  
      *                                                                 09540000
           CLOSE FCSBW06-FILE                                           
           DISPLAY 'TOTAL NO. OF RECORDS PROCESSED: ' WS-FIOBW06-COUNT  
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                 09600000
      * 9900-ABEND INCLUDES SQL ROLLBACK *                              09610000
           EXEC SQL                                                     09620000
             INCLUDE CPD09900                                           09630000
           END-EXEC.                                                    09640000
