       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW112.                                        
       AUTHOR.         MICHAEL J. LAWRENCE                              
       INSTALLATION.                                                    
       DATE-WRITTEN.   OCTOBER 1994.                                    
       DATE-COMPILED.                                                   
      ***************************************************************** 00007086
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** 00008086
      **                     PRICE WATERHOUSE                        ** 00009086
      **                1410 NORTH WESTSHORE BLVD                    ** 00009186
      **                   TAMPA, FLORIDA  33607                     ** 00009286
      **                      (813) 287-9200                         ** 00009386
      **                                                             ** 00009486
      ********            CUSTOMER SERVICE SYSTEM             ********* 00009586
      ********                      DB2                       ********* 00009686
      ***************************************************************** 00011288
      **                                                             ** 00011388
      **              PROGRAM  MODIFICATION  LOG                     ** 00011488
      **                                                             ** 00011588
      **     DATE     INIT               DESCRIPTION                 ** 00011688
      **   --------   ----   --------------------------------------  ** 00011789
      **   12/01/94   MJL    INITIAL PROGRAM VERSION                 **         
      **   01/31/96   ELJ    DELETE ALL ACCESS AND UPDATE REFERENCES ** 00012888
      **                     TO CSS_REGISTER_READ TABLE. TPR 2847.   ** 00012988
      **   05/22/96   MJL    SEARCH FOR OLD ACCOUNT NO. IF ACCOUNT   **         
      **                     ON FILE IS NOT FOUND.  TPR 4281.        **         
      **   05/30/96   MJL    RE-ADD   LOGIC TO CREATE CNSMPTN_HIST   **         
      **                     FOR INDIVIDUAL CHANNELS WHICH WAS TAKEN **         
      **                     OUT WHEN LOGIC FOR REG_READ WAS REMOVED **         
      **                     TPR 4385.                               **         
      **   06/25/96   MJL    ADD LOGIC TO CHECK IF ALL METERS HAVE   **         
      **                     BEEN PROCESSED.  UPDATE CODE-ACCT-BILLED**         
      **                     ADDED PARA 2400.  TPR 4714.             **         
TP5228**   08/29/96   MAD    ADDED LOGIC FOR ABEND STANDARDIZATION   **         
TP5228**                     AMONG BATCH AND ONLINE (CICS) MODULES.  **         
TP5228**                     TPR 5228.                               **         
T5320 **   09/03/96   CSG    CHANGE PROCESSING IN 3200-.  TPR 5320.  **         
T5442 **   10/22/96   CSG    ADD LOGIC TO HANDLE RESTARTING WITH THE **         
      **                     FIRST METER ID ON THE FILE.  TPR5442.   **         
TP5444**   12/11/96   RAH    USE MN AND AT FIELDS INSTEAD OF WORKING **         
      **                     STORAGE WHEN SETTING REG ID AND CODE-   **         
      **                     USAGE-SOURCE.                           **         
TP8184**   12/16/96   RAH    INSERT PARENTHESES AROUND THE UTILITY   **         
      **                     TYPE SPECIFICATIONS IN THE UTIL_ENVRNMT **         
      **                     CURSOR.                                 **         
TP9251**   02/12/97  CHANDRA 9900-ABEND PARA REPLACED BY 9700-PROCESS**         
      **                     ABEND PARA. THIS IS DONE ONLY IN THIS   **         
      **                     COBOL PROGRAM AND NONE OF THE COPY      **         
      **                     BOOKS ( CPD*** ) ARE MODIFIED.          **         
      **                     STOP RUN REMOVED FROM 9000-TERMINATE    **         
TP9087**   02/17/97  CHANDRA WS-NO-OF-UNITS COMPUTED BASED ON        **         
      **                     PULSES.                                 **         
TP9332**   02/17/97  CHANDRA 9900- PARA CALL IN 9000- REMOVED TO     **         
      **                     ELIMINATE LOOPING                       **         
TP9491**   02/26/97  CHANDRA WS-START-READ AND WS-END-READ ARE       **         
TP9491**                     DIVIDED BY 10 AND ROUNDED TO ELIMINATE  **         
TP9491**                     THE DECIMAL PORTION.                    **         
TEMPFX**   02/26/97  CHANDRA FOUR LINES WERE COMMENTED OUT IN 2021-  **         
TEMPFX**                     PARA ( MICHAEL LAWRENCE ). THIS FIX IS  **         
TEMPFX**                     TO BYPASS ALL THE CONVERSION ERRORS.    **         
TEMPFX**                     BEFORE MOVING TO PRODUCTION, THIS SHOULD**         
TEMPFX**                     BE UNCOMMENTED.                         **         
T10159**  04/07/97   MJL     CHANGED PROGRAM NOT TO ERROR WHEN ACCT  **         
      **                     ON FILE IS NOT FOUND ON XREF_ACCT TABLE **         
      **                     USE ACCOUNT ON IDR_ACCT_MTR TABLE INSTEAD*         
T10811**  05/05/97   MJL     CHANGED PROGRAM TO GET PREVIOUS METER   **         
      **                     INFO FROM CNSMPTN_HIST IF METER CHANGED **         
T11993**  07/08/97   MJL     DO NOT CHECK FOR CNSMPTN_HIST FOR REBILL**         
PCR376**   9/3/97    PD      SELECT CSS_XREF_ACCT BY JOINING WITH    **         
PCR376**                     CSS_CUST_PREM_HIST TO TAKE CARE OF      **         
PCR376**                     MULTIPLE OLD-ACCOUNT-NO.                **         
T13287**  10/09/97   MJL     FIX RESTART LOGIC IF ABEND BEFORE       **         
      **                     PROCESSING FIRST ACCOUNT.               **         
T14361**  01/16/98   CSG     IF METER IS NOT FOUND (7010-) RESET     **         
      **                     FIELDS FOR WQ (PRINTING PREV. ACCT INFO)**         
T14956**  02/26/98   RGB     READ ERROR ON INPUT FILE FCSBW112 -WHEN **         
      **             CBSI    IT IS RESTARTED IS CHECKED AND CORRECTED**         
T15068**  02/26/98   RGB     REMOVED FIRST COMMIT THAT IS DONE       **         
      **             CBSI    BEFORE ANY DB UPDATES HAVE BEEN DONE    **         
PR0594**  03/10/98   RGB     CREATED OUTPUT FILE FCSBW113 TO WRITE OUT*         
PR0594**             CBSI    PULSE DATA'S THAT IS SUCCESSFULLY POSTED**         
T15361**  03/13/98   RGB     PROGRAM CAN'T FIND MV90 METER NO FROM   **         
T15361**             CBSI    JOB PARM ON FILE EVEN THOUGH IT IS THERE**         
T15460**  03/17/98   RGB     CHECK FOR INSTALL DATE SHOULD ALLOW     **         
T15460**             CBSI    PULSE RECORD TO POST WHEN IT IS EQUAL   **         
T15460**                     TO END DATE                             **         
T15558**  03/21/98   MJL     CHANGE TO HANDLE READINGS NOT AT MIDNIGHT*         
T15689**  03/31/98   MJL     PERFORM COMMIT AFTER UPDATING ACCOUNT   **         
T15925**  04/21/98   CBSI    INCORRECT WQ ROUTING CATEGORY &         **         
T15925**                     WQ CATEGORY ID IS  RECTIFIED            **         
T16376**  05/13/98   MJL     POST READING WHEN DAYLIGHT SAVING TIME  **         
      **                     BEGINS AT 2:00 INSTEAD OF 3:00.         **         
T16776**  06/11/98   MJL     SUBTRACT 1 FROM INTERVALS WHEN AT END   **         
T16423**  06/16/98   MJL     SET CONSTANT TO 1 IF 0.                 **         
T16904**  06/23/98   TDK     WRITE WQ IF METER ALREADY PROCESSED.    **         
T17026**  07/08/98   VK      POST IDR DATA FOR A METER THAT HAS BEEN **         
      **                     EXCHANGED. ( TPR 17026 )                **         
T17143**  07/17/98   RGB     CHANGED CODE TO CHECK MONTH'S START INDEX*         
      **                     ON MV90 WITHIN 1 OF LAST MONTH'S OFFINDEX*         
T17233**  07/29/98   VK      CHECK FOR EXCHANGED METER IN CONSUMPTION**         
      **                     HISTORY WHEN POSTING IDR.               **         
T17339**  08/05/98   VK      CONSUMPTION ON A METER CHANGE WITH A    **         
      **                     REBILL SHOULD POST SUCCESSFULLY.        **         
PCR671**  08/31/98   TDK     DO NOT SET CODE_ACCT_BILLED TO READY TO **         
PCR671**                     BILL IF ACCOUNT IS HELD.                **         
T17425**  09/03/98   RAQ     INSERT REV_DIST INTO BILLING DETAILS    **         
T18349**  11/03/98   AAT     CHECK TO SEE IF MTR INSTALL DATE IS     **         
      **                     BETWEEN IDR DATES. IF IT IS INITIATE A  **         
      **                     WORK QUEUE.                             **         
T18464**  11/16/98   MJL     DISPLAY LAST READ DATE AND TIME IN WQ   **         
T18069**  11/16/98   MJL     CORRECT INVALID SEQUENCE ERROR MESSAGE  **         
T19383**  04/012/99  VWG     ADD 3 TAX FIELDS TO SELECT IN PARA 7313 **         
      **                     AND MOVE IN IN PARA 8862-ISRT           **         
T20288**  12/15/99   CBSI    CHANGES MADE TO POPULATE CT/PT RATIOS TO**         
      **                     CSS_MTR_IDENT_HIST TABLE.               **         
T21338**  01/17/00   GAUSE   MOVE 0 TO MN-NO-CONSEC-ESTIMATE         ** 00010000
T19862**  01/17/00   SREENI  CHANGES MADE TO CREATE PEAK HISTORY ROWS**         
      **                     FOR PEAK KVA, ASSOCIATED KVAR & PEAK KW.**         
T22214**  05/15/00   SREENI  CHANGES MADE TO CREATE PEAK HISTORY ROWS**         
      **                     FOR PEAK KVA, ASSOCIATED KVAR & PEAK KW **         
      **                     IN CSS_PEAK_HISTORY.                    **         
T22675**  08/16/00   SREENI  CHANGES MADE TO SAVE KVAR FROM KW PEAK. **         
T22243**  08/22/00   CBSI    CHANGES MADE TO IMPLEMENT MULTI-        **         
T22243**                     COMPANY IN METER INVENTORY.             **         
T23817**  02/27/01   TVWG    CHANGED 7311 TO NOT ABEND               **         
T23817**                     ADD CODE_METER_STATUS = 'A' TO SQL      **         
T23951**  06/27/01   SR16861 CHANGED 8862 TO DISPLAY COMPANY NO AND TO*         
T23591**                     GET THE COMPANY NO FROM THE PREMISE ROW.**         
T24001**  06/27/01   EM19682 CHANGED 7311 TO NOT ABEND. CHGED SQL TO **         
T24001**                     CODE_METER_STATUS IN ('A', 'B', 'I')    **         
T27541**  09/10/02   VIJAY   MOVE ZEROS TO BG-REV-MTH-ORIG-BILL      **         
      **                     IN FUTURE HOOK OF BG.                   **         
C26776**  06/16/03   GANESH  CHANGES MADE TO SUPPORT THE RTP ACCOUNTS**         
C26776**                     WITH COMBINED USAGE TO BILL DEPENDING ON**         
C26776**                     THE CORESSPONDING DEMAND AND ENERGY RATIO*         
T26776**  09/30/03   ROD     UPDATE CHANGES FOR C26776 TO HANDLE A   **         
T26776**                     3-WAY SPLIT FOR UNROYAL AND MICHELIN.   **         
C35227**  01/07/07   DB41297 PERFORMANCE IMPROVEMENTS.               **         
T33694**  03/25/08   MC95456 REMOVED OUTPUT FILE BW113  AND          **         
T33694**                     HANDLED THE PROGRAM NOT TO ABEND WHEN   **         
T33694**                     INPUT FILE IS EMPTY                     **         
ACT104**  05/02/11   BG17805 CHANGED WS-NO-OF-UNITS FROM S9(07)      **         
ACT104**  APPL3082           TO S9(09)                               **         
ACT200**  10/14/11   VIJAY   POST MV90 READINGS PROPERLY TO FUTURE   **         
ACT200**  APPL3082           HOOK WHEN REBILL ROW IS PRESENT(WHEN    **         
ACT200**                     REBILL ROW IS PRESENT ALONG WITH FUTURE **         
ACT200**                     IT IS POSTING TO REBILL ROW).           **         
P00496**  01/12/12   SS97726 CORRECT DST ISSUE FOR 'FALL BACK' EXTRA **         
P00496**  PHASE-II           HOUR.                                   **         
A03247** 01/23/2012  MS93554 PROCESS TO INSERT IDR-INFO-RETENT-DT    **         
A03247**                     INTO CSS_MTR_IDENT_HIST TABLE.          **         
WINLOS** 09/12/2012  RH15956 CHANGES FOR WINNSBORO TRANSFORMER AND   **         
WINLOS**                     DISTRIBUTION LINE LOSSES.               **         
A03956** 11/07/2012  VIJAY   MICHELIN CHANGES.                       **         
A04860** 02/02/2015  MR7E794 REPLACE CSS_WQ_ITEMS_MF WITH            **         
A04860**             ACT059  CSS_WQ_ITEMS.                           **         
ACT062** 02/02/2016  VIJAY 1.USE 00.00.00 IN END-TIME INSTEAD OF     **         
ACT062** A05460              24.00.00.                               **         
ACT062**                   2.FOR COGEN METERS POST UNITS AS -VE VALUES*         
ACT138** 04/27/2016  VIJAY   FIX 'MN' DATES UPDATE.                  **         
ACT138** A05460                                                      **         
ACT186** 05/28/2016  VIJAY   FIX 'MN' DATES UPDATE.                  **         
ACT186** A05460                                                      **         
ACT122** 06/17/2016  VIJAY   CONVERT 24.00.00 TO 00.00.00 WHILE WRIT-**         
ACT122** A05460              ING INTO PEAK_HISTORY                   **         
      ***************************************************************** 00013088
           REMARKS.                                                     
                              PCSBW112 NARRATIVE                        
                READS MV-90 DTV FILE AND POSTS INTERVAL                 
                METER READS TO CSS_INTERVAL_READ, UPDATES               
                CNSMPTN_HIST, MTRD_ENVRNMT                              
                NO REPORT IS PRODUCED.                                  
      *                                                                 00153086
HPCCDM*EJECT                                                            00157586
                    ------- PARAGRAPH STRUCTURE ------                  
           SEQ #  NAME                          FUNCTION                
           ---- ------------------------- ------------------------------
           0000 MAINLINE                  CONTROLS PROGRAM FLOW         
           1000 INITIATE PROCESSING       INITIALIZES FIELDS            
           2000 PROCESS IDR DATA          CONTROLS IDR RECORD PROCESSING
           2010 PROCESS HEADERS           PROCESSES HEADERS             
           2020 PROCESS KWH CHANNEL       PROCESSES KWH UOM CHANNEL     
           2030 PROCESS CHANNELS          PROCESSES REMAINING CHANNELS  
           3000 PROCESS IDR PULSES        PROCESSES PULSE RECORDS       
           3010 GET NEXT PULSE                                          
           3200 CHECK PULSE RECORDS       EDIT AND VALIDATE PULSE REC.  
           5000 UPDATE                    UPDATE CNSMPTN_HIST AND BILL  
           9700 TERMINATE PROCESSING      RETURNS CONTROL TO CICS       
           9900 ABEND                     ISSUES A CICS ABEND COMMAND   
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBW112.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
      *                                                                         
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
      *****************************************************************         
      *                                                               *         
      *    FILE DESCRIPTION FOR PCSBW112 IDR EXTRACT FILE             *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       COPY CFDBW112.                                                           
      *                                                                         
       01  E-FBW112-REC                PIC X(144).                      
                                                                        
                                                                        
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-HRLY-RATE  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW112'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  PROGRAM-NAME                PIC X(08) VALUE 'PCSBW112'.      
      *                                                                         
       01  E-FBW112-REC-BUFFER         PIC X(144) VALUE SPACES.         
      *                                                                         
       01  WS-ACCUMULATORS.                                             
           05  WS-NO-OF-CHANNELS       PIC 9(02)  COMP VALUE ZERO.      
           05  WS-NO-OF-DAYS           PIC S9(04) COMP VALUE ZERO.      
           05  WS-NO-OF-JOB-PARMS      PIC S9(04) COMP VALUE ZERO.      
           05  WS-UT-COUNT             PIC S9(04) COMP VALUE ZERO.      
           05  WS-READS-POSTED         PIC S9(04) COMP VALUE ZERO.      
           05  WS-MN-AWAITING-RD-COUNT PIC S9(04) COMP VALUE ZERO.      
           05  WS-RG-AWAITING-RD-COUNT PIC S9(04) COMP VALUE ZERO.      
       01  WS-DATE-READ.                                                
           05  WS-READ-CENTURY         PIC X(02) VALUE SPACES.          
           05  WS-READ-YEAR            PIC X(02) VALUE SPACES.          
           05  FILLER                  PIC X(01) VALUE '-'.             
           05  WS-READ-MONTH           PIC X(02) VALUE SPACES.          
           05  FILLER                  PIC X(01) VALUE '-'.             
           05  WS-READ-DAY             PIC X(02) VALUE SPACES.          
       01  WS-DATE-READ-RED REDEFINES WS-DATE-READ PIC X(10).           
T18464 01  WS-DATE-READ-SAVE           PIC X(10) VALUE SPACES.          
T26776 01  WS-COINCIDENTAL-FLAG        PIC X(1).                        
T26776 01  WS-COINCIDENTAL-ACCT-FLAG   PIC X(1).                        
T26776 01  WS-MORE-COINCIDENTALS-SW    PIC X(1).                        
C26776 01  WS-CON-CX-PROCESS           PIC X(1).                        
C26776 01  WS-ORIG-BILL-ITEM-TIMESTMP  PIC X(26).                       
C26776 01  WS-CON-BILL-ITEM-TIMESTMP   PIC X(26).                       
C26776 01  WS-CON-BILL-ITEM-TIMESTMP2  PIC X(26).                       
C26776 01  WS-ORIG-IV-BILL-ITEM-TIMESTMP PIC X(26).                     
C26776 01  WS-ORIG-BILL-NO             PIC S9(9) USAGE COMP.            
C26776 01  WS-ORIG-IC-NO               PIC S9(4) USAGE COMP.            
C26676 01  WS-811                      PIC S9(9) VALUE -811 COMP.       
COB305 01 WS-ORIG-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
       01  WS-FLAGS.                                                    
           05  WS-END-OF-FILE          PIC X(01) VALUE 'N'.             
               88 EMPTY-FILE                     VALUE 'Y'.             
           05  WS-METER-NOT-READ       PIC X(01) VALUE 'Y'.             
               88  METER-NOT-READ-FOUND          VALUE 'N'.             
           05  WS-METER-CHANGE-IND     PIC X(01) VALUE 'N'.             
               88  WS-METER-CHANGE               VALUE 'Y'.             
           05  WS-FIRST-TIME           PIC X(01) VALUE 'N'.             
           05  WS-GOTO-NEXT-METER      PIC X(01) VALUE 'N'.             
           05  WS-INSERT-WORK-QUEUE    PIC X(01) VALUE 'N'.             
           05  WS-JOB-PARM             PIC X(01) VALUE 'N'.             
           05  WS-NO-MORE-INTERVALS    PIC X(01) VALUE 'N'.             
           05  WS-NO-MORE-JOB-PARMS    PIC X(01) VALUE 'N'.             
           05  WS-FLG-SKIP-INTERVAL    PIC X(01) VALUE 'N'.             
       01  WS-HEADER-SORT-CODES.                                        
           05  HEADER-0000             PIC 9(04) VALUE 0000.            
           05  HEADER-0001             PIC 9(04) VALUE 0001.            
           05  HEADER-0002             PIC 9(04) VALUE 0002.            
       01  WS-IDR-DATE.                                                 
           05  WS-IDR-MONTH            PIC X(02) VALUE SPACES.          
           05  WS-IDR-DAY              PIC X(02) VALUE SPACES.          
           05  WS-IDR-YEAR             PIC X(02) VALUE SPACES.          
           05  WS-IDR-HOUR             PIC X(02) VALUE SPACES.          
           05  WS-IDR-MIN              PIC X(02) VALUE SPACES.          
       01  WS-JOB-PARMS.                                                
           05  WS-PARM-ACCOUNT         PIC 9(13) COMP-3 VALUE ZERO.     
           05  WS-PARM-IDENT-NO        PIC X(20) VALUE SPACES.          
           05  WS-PARM-OVERRIDE-DATE   PIC X(10) VALUE SPACES.          
           05  WS-OVERRIDE-YES         PIC X(10) VALUE 'OVERRIDE=Y'.    
           05  WS-OVERRIDE-NO          PIC X(10) VALUE 'OVERRIDE=N'.    
       01  WS-IDENT-NO-STRING.                                          
           05 FILLER               PIC X(03) VALUE 'ID='.               
           05 WS-IDENT-NO-STR      PIC X(20) VALUE SPACES.              
       01  WS-IDENT-STRING REDEFINES WS-IDENT-NO-STRING PIC X(23).      
                                                                        
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LEN         PIC S9(04) VALUE +80 COMP.   
           05  WS-IS-THIS-A-RESTART        PIC X(01)  VALUE 'N'.        
               88  WS-THIS-IS-A-RESTART               VALUE 'Y'.        
           05  WS-RESTART-REQ              PIC X(01).                   
           05  WS-DEFAULT-RESTART-REQ      PIC X(01)  VALUE 'N'.        
           05  WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(04) VALUE ZEROES COMP.
           05  WS-PROCESS-TYPE             PIC 9(01)  VALUE ZERO.       
           05  WS-REPOSITION-NEEDED        PIC X(01)  VALUE 'Y'.        
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID          PIC X(02)  VALUE '00'.       
               10  WS-CHKP-PART-NO         PIC 9(01)  VALUE 1.          
               10  WS-CHKP-SEQ-NO          PIC 9(05)  VALUE ZERO.       
           05  WS-RPT-SEQ-NO               PIC S9(05) VALUE ZERO COMP-3.
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
           05  WS-RESTART-JOB-COMPLETE    REDEFINES                     
               WS-RESTART-PROCESS-TYPE     PIC X(01).                   
           05  WS-RESTART-JOB-STATUS       PIC X(01).                   
               88  WS-RUN-COMPLETED-NO-PROBLEMS     VALUE 'A'.          
               88  WS-RERUN-COMPLETED               VALUE 'B'.          
               88  WS-RERUN-PENDING                 VALUE 'C'.          
           05  WS-RESTART-COMMON-DATE      PIC X(10).                   
           05  WS-RESTART-CHKP-SEQ-NO      PIC 9(05).                   
           05  WS-RESTART-METER-ID-NO      PIC X(20) VALUE SPACES.      
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-0                    PIC 9(01) VALUE 0.               
           05  WS-1                    PIC 9(01) VALUE 1.               
           05  WS-2                    PIC 9(01) VALUE 2.               
           05  WS-3                    PIC 9(01) VALUE 3.               
           05  WS-4                    PIC 9(01) VALUE 4.               
           05  WS-5                    PIC 9(01) VALUE 5.               
           05  WS-10                   PIC 9(02) VALUE 10.              
           05  WS-16                   PIC 9(02) VALUE 16.              
           05  WS-19                   PIC 9(02) VALUE 19.              
           05  WS-20                   PIC 9(02) VALUE 20.              
           05  WS-50                   PIC 9(02) VALUE 50.              
           05  WS-0000                 PIC 9(04) VALUE 0000.            
           05  WS-7777                 PIC 9(04) VALUE 7777.            
           05  WS-9999                 PIC 9(04) VALUE 9999.            
           05  WS-D                    PIC X(01) VALUE 'D'.             
           05  WS-E                    PIC X(01) VALUE 'E'.             
           05  WS-F                    PIC X(01) VALUE 'F'.             
           05  WS-G                    PIC X(01) VALUE 'G'.             
           05  WS-H                    PIC X(01) VALUE 'H'.             
           05  WS-I                    PIC X(01) VALUE 'I'.             
           05  WS-J                    PIC X(01) VALUE 'J'.             
           05  WS-K                    PIC X(01) VALUE 'K'.             
           05  WS-M                    PIC X(01) VALUE 'M'.             
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-Q                    PIC X(01) VALUE 'Q'.             
           05  WS-R                    PIC X(01) VALUE 'R'.             
           05  WS-S                    PIC X(01) VALUE 'S'.             
           05  WS-T                    PIC X(01) VALUE 'T'.             
           05  WS-U                    PIC X(01) VALUE 'U'.             
T20288     05  WS-X                    PIC X(01) VALUE 'X'.             
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-KWH-CODE             PIC X(02) VALUE '01'.            
           05  WS-KQH-CODE             PIC X(02) VALUE '02'.            
           05  WS-KVH-CODE             PIC X(02) VALUE '03'.            
           05  WS-NEG-ONE              PIC S9(04) COMP-3 VALUE -1.      
           05  WS-ONE-HOUR             PIC 9(02) COMP VALUE 60.         
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSBW112'.      
           05  WS-COMMON               PIC X(06) VALUE  'COMMON'.       
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-ACTIVE               PIC X(01) VALUE 'A'.             
T20288     05  WS-CT                   PIC X(02) VALUE 'CT'.            
T20288     05  WS-PT                   PIC X(02) VALUE 'PT'.            
ACT062     05  WS-COGEN-METER          PIC X(01) VALUE 'N'.             
           05  WS-20-NINES             PIC X(20)                        
                             VALUE '99999999999999999999'.              
       01  WS-NULL-INDICATORS.                                          
           05  WS-IND-DATE-ORIG-BILL   PIC S9(04) COMP-4.               
           05  WS-IND-DATE-BILLED      PIC S9(04) COMP-4.               
           05  WS-IND-CX-ITEM-SEQ-NO   PIC S9(04) COMP-4.               
A03247     05  WS-NULL-IND-RETENT-DT   PIC S9(04) COMP VALUE 0.         
       01  WS-PULSE-DATA.                                               
ACT062     05  WS-PULSE                PIC S9(05) VALUE ZERO.           
           05  WS-PULSE-MULT.                                           
               10  WS-PULSE-MULT-DEC   PIC 9(01) VALUE ZERO.            
               10  WS-PULSE-MULT-VAL   PIC 9(09) VALUE ZERO.            
           05  WS-PULSE-SORT-CODE      PIC 9(04) COMP VALUE 0100.       
           05  WS-PULSE-STATUS         PIC X(01) VALUE SPACE.           
       01  WS-SUBSCRIPTS.                                               
           05  WS-IDR-SUB              PIC 9 COMP VALUE ZERO.           
           05  WS-PULSE-SUB            PIC S9(03) COMP VALUE ZERO.      
           05  WS-MAX-PULSE-TABLE      PIC S9(03) COMP VALUE 24.        
       01  WS-TIME-READ.                                                
           05  WS-READ-HOUR            PIC X(02) VALUE '00'.            
           05  FILLER                  PIC X(01) VALUE '.'.             
           05  WS-READ-MIN             PIC X(02) VALUE '00'.            
           05  FILLER                  PIC X(01) VALUE '.'.             
           05  WS-READ-SEC             PIC X(02) VALUE '00'.            
       01  WS-TIME-READ-RED REDEFINES WS-TIME-READ PIC X(08).           
       01  WS-PULSE-TOTAL-CHECK.                                        
ACT062     05  WS-PULSE-CHECK OCCURS 3 TIMES PIC S9(08) COMP VALUE ZERO.
ACT062     05  WS-PULSE-TOTAL OCCURS 3 TIMES PIC S9(08) COMP VALUE ZERO.
       01  WS-CODE-USAGE-BREAKDOWN.                                     
           05  WS-CODE-USAGE-TYPE      PIC X VALUE SPACES.              
           05  WS-CODE-USAGE-ID        PIC X VALUE SPACES.              
       01  WS-WORK-AREA.                                                
COB305     05 WS-ACCOUNT-NO        PIC 9(13) COMP-3 VALUE 0.                
           05  WS-ACCOUNT-NO-STR       PIC X(13) VALUE SPACES.          
           05  WS-CONSTANT             PIC 9(06)V99999 VALUE ZERO.      
TP9087     05  WS-CONSTANT-TEMP        PIC 9(06)V99999 VALUE ZERO.      
           05  WS-COUNT                PIC S9(04) COMP VALUE ZERO.      
           05  WS-DST-TYPE             PIC X(01) VALUE SPACES.          
           05  WS-DST-DATE             PIC X(10) VALUE SPACES.          
           05  WS-DST-TIME             PIC X(08) VALUE SPACES.          
           05  WS-END-DATE             PIC X(10) VALUE SPACES.          
           05  WS-END-TIME             PIC X(08) VALUE SPACES.          
           05  WS-END-READ             PIC S9(08).                      
T17143     05  WS-END-PLUS-1           PIC S9(08).                      
           05  WS-END-READ-COMP        PIC S9(08).                      
           05  WS-IC-NO                PIC 9(04) COMP.                  
           05  WS-IDR-IDENT-NO         PIC X(20) VALUE SPACES.          
           05  WS-INTERVAL             PIC S9(04) COMP VALUE ZERO.      
           05  WS-INTERVAL-PER-HOUR    PIC S9(04) COMP VALUE ZERO.      
           05  WS-KWH-CHANNEL          PIC S9(03) COMP VALUE ZERO.      
           05  WS-METER-MULT           PIC S9(08) COMP VALUE ZERO.      
           05  WS-METER-NO             PIC X(09)  VALUE SPACES.         
           05  WS-MTR-REF-NO           PIC S9(04) COMP.                 
ACT104     05  WS-NO-OF-UNITS          PIC S9(09) COMP-3 VALUE ZERO.    
           05  WS-CRNT-USE             PIC S9(07) COMP-3 VALUE ZERO.    
           05  WS-OVERRIDE.                                             
               10  FILLER              PIC X(09) VALUE SPACES.          
               10  WS-OVERRIDE-IND     PIC X(01) VALUE SPACES.          
           05  WS-PULSE-OFFSET         PIC S9(08).                      
           05  WS-REVENUE-MONTH        PIC S999999V USAGE COMP-3        
                                       VALUE ZERO.                      
           05  WS-START-DATE           PIC X(10) VALUE SPACES.          
           05  WS-START-TIME           PIC X(08) VALUE SPACES.          
           05  WS-START-READ           PIC S9(08).                      
T17143     05  WS-START-PLUS-1         PIC S9(08).                      
           05  WS-TIME-BEGIN           PIC X(08) VALUE '00.00.00'.      
ACT062     05  WS-TIME-24              PIC X(08) VALUE '00.00.00'.      
           05  WS-TIME-ZERO            PIC X(08) VALUE '00.00.00'.      
           05  WS-TOTAL-INTERVALS      PIC 9(05) COMP VALUE ZERO.       
           05  WS-TOTAL-INT-ON-HEADER  PIC 9(05) COMP VALUE ZERO.       
           05  WS-UOM.                                                  
               10 WS-UOM-HIGH          PIC X(01) VALUE SPACES.          
               10 WS-UOM-LOW           PIC X(01) VALUE SPACES.          
           05  WS-WINDOW-DATE          PIC X(10) VALUE SPACES.          
T18349     05  WS-NEW-METER-NO         PIC X(09).                       
T18349     05  WS-DATE-NEW-MTR-INSTALL PIC X(10).                       
T20288     05  WS-TEMP-RETURN-CD       PIC S9(09) COMP.                 
COB305     05 WS-KWH-PULSE-MULT        PIC S9(6)V9(5) COMP-3 VALUE 0.           
COB305     05 WS-OTHR-PULSE-MULT        PIC S9(6)V9(5) COMP-3 VALUE 0.          
COB305     05 WS-KWH        PIC S9(9)V9(3) COMP-3 VALUE 0.           
COB305     05 WS-KQH        PIC S9(9)V9(3) COMP-3 VALUE 0.           
COB305     05 WS-KVAR        PIC S9(9)V9(3) COMP-3 VALUE 0.           
COB305     05 WS-KVARH        PIC S9(9)V9(3) COMP-3 VALUE 0.           
COB305     05 WS-KW        PIC S9(9)V9(3) COMP-3 VALUE 0.           
COB305     05 WS-KVA        PIC S9(9)V9(3) COMP-3 VALUE 0.           
T19862     05  WS-PEAK-DATE-1          PIC X(10).                       
T19862     05  WS-PEAK-DATE-2          PIC X(10).                       
T19862     05  WS-PEAK-TIME-1          PIC X(08).                       
T19862     05  WS-PEAK-TIME-2          PIC X(08).                       
COB305     05 WS-PEAK-KVA-1        PIC S9(9)V9(3) COMP-3 VALUE 0.           
COB305     05 WS-PEAK-KW-1        PIC S9(9)V9(3) COMP-3 VALUE 0.           
COB305     05 WS-PEAK-KVA-2        PIC S9(9)V9(3) COMP-3 VALUE 0.           
COB305     05 WS-PEAK-KW-2        PIC S9(9)V9(3) COMP-3 VALUE 0.           
COB305     05 WS-PEAK-KVAR-1        PIC S9(9)V9(3) COMP-3 VALUE 0.           
COB305     05 WS-PEAK-KVAR-2        PIC S9(9)V9(3) COMP-3 VALUE 0.           
T22214     05  WS-OLD-KW-MTR-NO        PIC X(09) VALUE SPACES.          
T22214     05  WS-OLD-KVA-MTR-NO       PIC X(09) VALUE SPACES.          
A03247     05  WS-INPUT-DT-PLUS-25MTHS PIC X(10) VALUE SPACES.          
A03247     05  WS-IDR-INFO-RETENT-DT   PIC X(10) VALUE SPACES.          
A03247     05  WS-RATE-PLAN-SUB        PIC S9(04) VALUE 0.              
A03247     05  WS-RATE-PLAN-FOUND      PIC X(01)  VALUE SPACES.         
A03247     05  WS-RATE-PLAN-COUNT      PIC 9(05)  VALUE 0.              
A03247     05  WS-RATE-PLAN-TABLE.                                      
A03247         10 ARR-RATE-PLAN-NO     OCCURS 20 TIMES PIC X(03).       
A03956     05  WS-INDEX                PIC 9(02)  VALUE 0.              
A03956     05  WS-CODE-ACCT-BILLED     PIC X(01)  VALUE SPACE.          
T19862*                                                                         
       01  WS-WORK-QUEUE.                                               
           05  WS-COMMENTS-TEXT        PIC X(250) VALUE SPACES.         
           05  WS-COMMENTS-LEN         PIC S9(04) COMP VALUE ZERO.      
           05  WS-IDR-CATEGORY         PIC S9(04) COMP VALUE 16.        
T15925     05  WS-IDR-CATEGORY-16      PIC S9(04) COMP VALUE 16.        
T15925     05  WS-IDR-CATEGORY-136     PIC S9(04) COMP VALUE 136.       
T15925     05  WS-ROUTE-CATEGORY       PIC 9(01)       VALUE 1.         
       01  WS-WORK-QUEUE-COMMENTS.                                      
           05  METER-NO-NOT-FOUND      PIC X(43) VALUE                  
               'METER NO. NOT FOUND ON IDR_ACCT_MTR TABLE. '.           
           05  END-OF-FILE-MISSING     PIC X(28) VALUE                  
               'END OF FILE RECORD MISSING. '.                          
           05  NO-KWH-CHANNEL          PIC X(28) VALUE                  
               'KWH CHANNEL DOES NOT EXIST. '.                          
           05  NO-READ-WINDOW          PIC X(23) VALUE                  
               'READ WINDOW NOT FOUND. '.                               
           05  NO-BILL-WINDOW          PIC X(23) VALUE                  
               'BILL WINDOW NOT FOUND. '.                               
           05  NO-MTRD-ENVRNMT         PIC X(29) VALUE                  
               'METER ENVIRONMENT NOT FOUND. '.                         
           05  NO-UTIL-ENVRNMT         PIC X(31) VALUE                  
               'UTILITY ENVIRONMENT NOT FOUND. '.                       
           05  NO-REG-ENVRNMT          PIC X(37) VALUE                  
               'REGISTER READ ENVIRONMENT NOT FOUND. '.                 
           05  NO-MTR-CAP              PIC X(28) VALUE                  
               'METER CAPABILITY NOT FOUND. '.                          
           05  NO-REBILL-DETAIL        PIC X(41) VALUE                  
               'BILL DETAIL FOR CANCEL REBILL NOT FOUND. '.             
           05  INCORRECT-ACCOUNT       PIC X(26) VALUE                  
               'ACCOUNT NUMBER NOT FOUND. '.                            
           05  INCORRECT-TOT-INT       PIC X(29) VALUE                  
               'TOTAL INTERVALS IS INCORRECT '.                         
           05  INCORRECT-PULSE-TOT     PIC X(25) VALUE                  
               'PULSE TOTAL IS INCORRECT '.                             
           05  INCORRECT-SORT          PIC X(26) VALUE                  
               'SORT CODE OUT OF SEQUENCE '.                            
           05  INCORRECT-UOM           PIC X(29) VALUE                  
               'INVALID UNIT OF MEASUREMENT '.                          
           05  INCORRECT-METER-READ    PIC X(54) VALUE                  
               'START METER READING DOES NOT EQUAL LAST METER READING '.
           05  INCORRECT-READ-DATE     PIC X(55) VALUE                  
               'LAST METER READ DATE IS NOT DIRECTLY BEFORE START DATE'.
           05  CNSMPTN-HIST-EXIST      PIC X(52) VALUE                  
               'CONSUMPTION HIST SHOULD NOT EXIST FOR CANCEL REBILL '.  
           05  METER-CHANGE            PIC X(29) VALUE                  
               'METER EXCHANGE HAS OCCURRED. '.                         
           05  INVALID-END-DATE        PIC X(43) VALUE                  
               'END DATE DOES NOT EQUAL OPTIMUM READ DATE. '.           
           05  INVALID-PULSE           PIC X(38) VALUE                  
               'INVALID OR SKIPPED PULSE ENCOUNTERED. '.                
T18349     05  NEW-MTRD-ENVRNMT        PIC X(90) VALUE                  
               'NEW METER INSTALLED BETWEEN START AND END IDR DATE OF OL        
      -        'D METER.'.                                                      
A03967     05  ALREADY-PROCESSED       PIC X(47) VALUE                  
A03967         'METER ON INPUT FILE HAS ALREADY BEEN PROCESSED.'.       
      *                                                                         
ACT059 01  WS-MIS.                                                      
ACT059     05  SCSCB077               PIC X(08)      VALUE 'SCSCB077'.  
ACT059     05  WS-INPUT-TS.                                             
ACT059         10 WS-INPUT-DATE-PT    PIC X(10).                        
ACT059         10 WS-INPUT-TIME-PT    PIC X(16)      VALUE              
ACT059                                               '-00.00.00.000000'.
TP5228 01  RS-RPC-RETURN-CODE.                                          
TP5228     05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
TP5228     05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                         
       01  WS-FILE-STATUS.                                              
           05  WS-FBW112-STATUS        PIC X(02).                       
               88  FBW112-SUCCESSFUL              VALUE '00'.           
      *                                                                 00227586
A03956 01  WS-NOMORE-ACCTS-FL          PIC X(01) VALUE 'N'.             
A03956     88  WS-NOMORE-ACCTS                   VALUE 'Y'.             
HPCCDM*EJECT                                                            00227486
      *                                                                 00227586
TP5228 COPY CWS00010.                                                           
      *                                                                         
A03247     EXEC SQL                                                             
A03247         INCLUDE CWS00038                                                 
A03247     END-EXEC.                                                            
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY FIOBW112.                                                           
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
       COPY FIOCA00.                                                            
ACT059******* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
ACT059     EXEC SQL                                                             
ACT059          INCLUDE CWS00077                                                
ACT059     END-EXEC.                                                            
ACT059*                                                                         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBIDRATM                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBINTVRD                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBMTRIDT                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBRGREAD                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBXREF                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
PCR376     EXEC SQL                                                             
PCR376        INCLUDE TBCSTPRM                                                  
PCR376     END-EXEC.                                                            
T20288*                                                                 03610045
T20288     EXEC SQL                                                     03580006
T20288         INCLUDE TBINXFOR                                         03590006
T20288     END-EXEC.                                                    03600006
T20288*                                                                 03610045
T20288     EXEC SQL                                                     03700006
T20288         INCLUDE TBMTRATT                                         03710006
T20288     END-EXEC.                                                    03720006
T20288*                                                                 03730045
           EXEC SQL                                                     00227686
T22214         INCLUDE TBPKHIST                                         03710006
T19862     END-EXEC.                                                    03720006
T19862*                                                                 03730045
C26776**********************************                                        
C26776**  CSS_UTL_BILL_REL            **                                        
C26776**********************************                                        
C26776     EXEC SQL                                                             
C26776       INCLUDE TBUTLREL                                                   
C26776     END-EXEC.                                                            
                                                                        
A03247**********************************                                        
A03247**  CSS_RATE_CREATOR            **                                        
A03247**********************************                                        
A03247     EXEC SQL                                                             
A03247       INCLUDE TBRTCRTR                                                   
A03247     END-EXEC.                                                            
A03247**********************************                                        
A03247**  CSS_RATE_COMP_DEF           **                                        
A03247**********************************                                        
A03247     EXEC SQL                                                             
A03247       INCLUDE TBRTCDEF                                                   
A03247     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     00227686
               INCLUDE SQLCA                                            00227786
           END-EXEC.                                                    00227886
      *                                                                         
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSBW112 ENDS HERE  '.            
HPCCDM*EJECT                                                            00252786
      *                                                                         
      *********************** CURSOR DECLARATIVES ********************* 00231886
      *                                                                         
           EXEC SQL                                                     
               DECLARE GET-BILL-HOOK CURSOR FOR                         
                SELECT PREMISE_NO,                                      
                       BILL_NO,                                         
                       DATE_BILLED                                      
                  FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_NO       = :BI-ACCOUNT-NO                
                   AND CODE_BILL_STATUS = 'A'                           
              ORDER BY BILL_NO DESC                                     
C35227        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GET-BILL-HOOK CURSOR FOR                                 
MFA-TR*         SELECT PREMISE_NO,                                              
MFA-TR*                BILL_NO,                                                 
MFA-TR*                DATE_BILLED                                              
MFA-TR*           FROM CSS_BILLING_HDR                                          
MFA-TR*          WHERE ACCOUNT_NO       = :BI-ACCOUNT-NO                        
MFA-TR*            AND CODE_BILL_STATUS = 'A'                                   
MFA-TR*       ORDER BY BILL_NO DESC                                             
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
               DECLARE GET-BILL-DETAIL CURSOR FOR                       
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                              
                       RATE_PLAN_NO,                                    
                       CODE_REVENUE_CLASS                               
                  FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                  
                   AND BILL_NO        = :BG-BILL-NO                     
                   AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE              
                   AND IC_NO          = :BG-IC-NO                       
ACT200             AND CODE_BILL_CALC     = 'A'                         
ACT200             AND CODE_BILL_ITM_TYPE = 'C'                         
ACT200             AND CODE_BILL_ITM_IND  = 'A'                         
ACT200             AND DATE_ORIG_BILL     IS NULL                       
ACT200             AND REVENUE_MONTH      = 0                           
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GET-BILL-DETAIL CURSOR FOR                               
MFA-TR*         SELECT BILL_ITEM_TIMESTMP,                                      
MFA-TR*                RATE_PLAN_NO,                                            
MFA-TR*                CODE_REVENUE_CLASS                                       
MFA-TR*           FROM CSS_BILLING_DET                                          
MFA-TR*          WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                          
MFA-TR*            AND BILL_NO        = :BG-BILL-NO                             
MFA-TR*            AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                      
MFA-TR*            AND IC_NO          = :BG-IC-NO                               
MFA-TR*            AND CODE_BILL_CALC     = 'A'                                 
MFA-TR*            AND CODE_BILL_ITM_TYPE = 'C'                                 
MFA-TR*            AND CODE_BILL_ITM_IND  = 'A'                                 
MFA-TR*            AND DATE_ORIG_BILL     IS NULL                               
MFA-TR*            AND REVENUE_MONTH      = 0                                   
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
               DECLARE GET-ITEM-STAMP CURSOR FOR                        
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                               
                  FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                  
                   AND BILL_NO        = :BG-BILL-NO                     
                   AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE              
                   AND IC_NO          = :BG-IC-NO                       
ACT200             AND CODE_BILL_CALC     = 'A'                         
ACT200             AND CODE_BILL_ITM_TYPE = 'C'                         
ACT200             AND CODE_BILL_ITM_IND  = 'A'                         
ACT200             AND DATE_ORIG_BILL     IS NULL                       
ACT200             AND REVENUE_MONTH      = 0                           
C35227        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GET-ITEM-STAMP CURSOR FOR                                
MFA-TR*         SELECT BILL_ITEM_TIMESTMP                                       
MFA-TR*           FROM CSS_BILLING_DET                                          
MFA-TR*          WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                          
MFA-TR*            AND BILL_NO        = :BG-BILL-NO                             
MFA-TR*            AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                      
MFA-TR*            AND IC_NO          = :BG-IC-NO                               
MFA-TR*            AND CODE_BILL_CALC     = 'A'                                 
MFA-TR*            AND CODE_BILL_ITM_TYPE = 'C'                                 
MFA-TR*            AND CODE_BILL_ITM_IND  = 'A'                                 
MFA-TR*            AND DATE_ORIG_BILL     IS NULL                               
MFA-TR*            AND REVENUE_MONTH      = 0                                   
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
               DECLARE GET-JOB-PARM CURSOR FOR                          
                SELECT PARM_DATA,                                       
                       SEQ_NO                                           
                  FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                       
                 WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                  
                   AND STATUS       = :G6-STATUS                        
                   AND CMND_CODE    = 'PARM'                            
                   AND NOT PARM_DATA = 'RESTART-REQ=Y'                  
C35227        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GET-JOB-PARM CURSOR FOR                                  
MFA-TR*         SELECT PARM_DATA,                                               
MFA-TR*                SEQ_NO                                                   
MFA-TR*           FROM CSS_JOB_PARM                                             
MFA-TR*          WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                          
MFA-TR*            AND STATUS       = :G6-STATUS                                
MFA-TR*            AND CMND_CODE    = 'PARM'                                    
MFA-TR*            AND NOT PARM_DATA = 'RESTART-REQ=Y'                          
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      * 7501-FETCH-UTIL-ENVRNMT:                                                
           EXEC SQL                                                     
               DECLARE UTIL_ENVRNMT CURSOR FOR                          
                SELECT ACCOUNT_NO,                                      
                       CODE_UTIL_TYPE,                                  
                       IC_NO,                                           
                       READ_CYCLE,                                      
                       READ_ROUTE                                       
                  FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                   
                 WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                 
C35227             AND CODE_UTIL_TYPE IN('E','G')                       
              ORDER BY ACCOUNT_NO, CODE_UTIL_TYPE, IC_NO                
C35227        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UTIL_ENVRNMT CURSOR FOR                                  
MFA-TR*         SELECT ACCOUNT_NO,                                              
MFA-TR*                CODE_UTIL_TYPE,                                          
MFA-TR*                IC_NO,                                                   
MFA-TR*                READ_CYCLE,                                              
MFA-TR*                READ_ROUTE                                               
MFA-TR*           FROM CSS_UTIL_ENVRNMT                                         
MFA-TR*          WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                         
MFA-TR*            AND CODE_UTIL_TYPE IN('E','G')                               
MFA-TR*       ORDER BY ACCOUNT_NO, CODE_UTIL_TYPE, IC_NO                        
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
T20288******************************************************************00252986
T20288*** CURSOR TO GET CT/PT RATIOS FROM CSS_INSTR_XFORMER          ***00252986
T20288******************************************************************00252986
T20288     EXEC SQL                                                     
T20288       DECLARE GET_RATIO CURSOR FOR                               
T20288        SELECT IX.RTO_UPPER_FRACTION                              
T20288              ,IX.RTO_LOWER_FRACTION                              
T20288              ,IX.XFORMER_TYPE_CD                                 
T20288          FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                
T20288              ,CSS_INSTR_XFORMER  IX WITH(READUNCOMMITTED)                
T20288         WHERE MA.METER_NO       = :MA-METER-NO                   
T20288           AND MA.CODE_ATT_TYPE  = :MA-CODE-ATT-TYPE              
C35227           AND MA.CODE_UTIL_TYPE = 'E'                            
T22243           AND MA.COMPANY_NO     = :IX-COMPANY-NO                 
T22243           AND IX.COMPANY_NO     = MA.COMPANY_NO                  
T20288           AND MA.DEVICE_NO      = IX.XFORMER_NO                  
T20288           AND MA.CODE_ATT_TYPE  = IX.XFORMER_TYPE_CD             
C35227           AND IX.CODE_UTIL_TYPE = 'X'                            
C35227        FOR READ ONLY                                     
T20288     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GET_RATIO CURSOR FOR                                       
MFA-TR*       SELECT IX.RTO_UPPER_FRACTION                                      
MFA-TR*             ,IX.RTO_LOWER_FRACTION                                      
MFA-TR*             ,IX.XFORMER_TYPE_CD                                         
MFA-TR*         FROM CSS_METER_ATTCHMTS MA                                      
MFA-TR*             ,CSS_INSTR_XFORMER  IX                                      
MFA-TR*        WHERE MA.METER_NO       = :MA-METER-NO                           
MFA-TR*          AND MA.CODE_ATT_TYPE  = :MA-CODE-ATT-TYPE                      
MFA-TR*          AND MA.CODE_UTIL_TYPE = 'E'                                    
MFA-TR*          AND MA.COMPANY_NO     = :IX-COMPANY-NO                         
MFA-TR*          AND IX.COMPANY_NO     = MA.COMPANY_NO                          
MFA-TR*          AND MA.DEVICE_NO      = IX.XFORMER_NO                          
MFA-TR*          AND MA.CODE_ATT_TYPE  = IX.XFORMER_TYPE_CD                     
MFA-TR*          AND IX.CODE_UTIL_TYPE = 'X'                                    
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
T20288*                                                                         
T22214******************************************************************00252986
T22214*** CURSOR TO RETRIEVE PH DETAILS                              ***00252986
T22214******************************************************************00252986
T22214     EXEC SQL                                                     
T22214       DECLARE GET_PH CURSOR FOR                                  
T22214        SELECT  PEAK_KW_UNITS                                     
T22214               ,PEAK_KVA_UNITS                                    
T22214               ,PEAK_KVAR_UNITS                                   
T22214               ,METER_NO                                          
T22214               ,REPLACE(CONVERT(CHAR(8), PEAK_TIME, 108), ':', 
           '.') PEAK_TIME                                         
T22214               ,PEAK_DATE                                         
T22214               ,PEAK_TYPE                                         
T22214          FROM CSS_PEAK_HISTORY WITH(READUNCOMMITTED)                     
T22214         WHERE ACCOUNT_NO     = :PH-ACCOUNT-NO                    
T22214           AND BILL_NO        = :PH-BILL-NO                       
T22214           AND CODE_UTIL_TYPE = :PH-CODE-UTIL-TYPE                
T22214           AND IC_NO          = :PH-IC-NO                         
T22214           AND MTR_REF_NO     = :PH-MTR-REF-NO                    
T22214           AND PEAK_TYPE     IN ('B', 'E', 'J')                   
C35227        FOR READ ONLY                                     
T22214     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GET_PH CURSOR FOR                                          
MFA-TR*       SELECT  PEAK_KW_UNITS                                             
MFA-TR*              ,PEAK_KVA_UNITS                                            
MFA-TR*              ,PEAK_KVAR_UNITS                                           
MFA-TR*              ,METER_NO                                                  
MFA-TR*              ,PEAK_TIME                                                 
MFA-TR*              ,PEAK_DATE                                                 
MFA-TR*              ,PEAK_TYPE                                                 
MFA-TR*         FROM CSS_PEAK_HISTORY                                           
MFA-TR*        WHERE ACCOUNT_NO     = :PH-ACCOUNT-NO                            
MFA-TR*          AND BILL_NO        = :PH-BILL-NO                               
MFA-TR*          AND CODE_UTIL_TYPE = :PH-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO          = :PH-IC-NO                                 
MFA-TR*          AND MTR_REF_NO     = :PH-MTR-REF-NO                            
MFA-TR*          AND PEAK_TYPE     IN ('B', 'E', 'J')                           
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
T22214*                                                                         
T26776******************************************************************00252986
T26776*** CURSOR TO RETRIEVE COINCIDENTAL ACCOUNTS                   ***00252986
T26776******************************************************************00252986
T26776     EXEC SQL                                                     
T26776       DECLARE GET_COINCIDENTALS CURSOR FOR                       
T26776          SELECT ACCOUNT_NO_MST,                                  
T26776                 CODE_UTIL_TYPE_MST,                              
T26776                 IC_NO_MST,                                       
WINLOS                 CODE_RELATION_TYPE                               
T26776            FROM CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                   
T26776            WHERE  ACCOUNT_NO_DEP      = :UR-ACCOUNT-NO-DEP       
T26776             AND   CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP   
T26776             AND   IC_NO_DEP           = :UR-IC-NO-DEP            
WINLOS             AND   CODE_RELATION_TYPE  IN ('C','W')               
C35227        FOR READ ONLY                                     
T26776     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GET_COINCIDENTALS CURSOR FOR                               
MFA-TR*         SELECT ACCOUNT_NO_MST,                                          
MFA-TR*                CODE_UTIL_TYPE_MST,                                      
MFA-TR*                IC_NO_MST,                                               
MFA-TR*                CODE_RELATION_TYPE                                       
MFA-TR*           FROM CSS_UTL_BILL_REL                                         
MFA-TR*           WHERE  ACCOUNT_NO_DEP      = :UR-ACCOUNT-NO-DEP               
MFA-TR*            AND   CODE_UTIL_TYPE_DEP  = :UR-CODE-UTIL-TYPE-DEP           
MFA-TR*            AND   IC_NO_DEP           = :UR-IC-NO-DEP                    
MFA-TR*            AND   CODE_RELATION_TYPE  IN ('C','W')                       
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
T26776                                                                  
A03247******************************************************************00252986
A03247*   CURSOR TO RETRIEVE RATE PLAN NO                              *00252986
A03247******************************************************************00252986
A03247     EXEC SQL                                                     
A03247       DECLARE HRLY_RATE CURSOR WITH ROWSET POSITIONING FOR       
A03247          SELECT RT.RATE_PLAN_NO                                  
A03247            FROM CSS_RATE_CREATOR   RT WITH(READUNCOMMITTED)              
A03247                ,CSS_RATE_COMP_DEF  J1 WITH(READUNCOMMITTED)              
A03247           WHERE RT.CODE_STATUS       =  'A'                      
A03247             AND RT.CODE_UTIL_TYPE    =  'E'                      
A03247             AND RT.CODE_UTIL_TYPE    =  J1.CODE_UTIL_TYPE        
A03247             AND RT.RATE_PLAN_NO      =  J1.RATE_PLAN_NO          
A03247             AND RT.VERSION_NO_CNTRL  =  J1.VERSION_NO_CNTRL      
A03247             AND (J1.REG_TYPE_CD      = 'H' OR                    
A03247                  J1.DEM_REG_TYPE_CD  = 'H' )                     
A03247             AND RT.VERSION_NO_CNTRL  =                           
A03247                 (SELECT MAX (RT2.VERSION_NO_CNTRL)               
A03247                    FROM CSS_RATE_CREATOR  RT2
                           WITH(READUNCOMMITTED)                    
A03247                   WHERE RT2.RATE_PLAN_NO   = RT.RATE_PLAN_NO     
A03247                     AND RT2.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE   
A03247                     AND RT2.CODE_STATUS    = RT.CODE_STATUS)     
A03247          GROUP BY RT.RATE_PLAN_NO                                
A03247          ORDER BY 1                                              
A03247          FOR READ ONLY                                   
A03247                                                      
A03247     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE HRLY_RATE CURSOR WITH ROWSET POSITIONING FOR               
MFA-TR*         SELECT RT.RATE_PLAN_NO                                          
MFA-TR*           FROM CSS_RATE_CREATOR   RT                                    
MFA-TR*               ,CSS_RATE_COMP_DEF  J1                                    
MFA-TR*          WHERE RT.CODE_STATUS       =  'A'                              
MFA-TR*            AND RT.CODE_UTIL_TYPE    =  'E'                              
MFA-TR*            AND RT.CODE_UTIL_TYPE    =  J1.CODE_UTIL_TYPE                
MFA-TR*            AND RT.RATE_PLAN_NO      =  J1.RATE_PLAN_NO                  
MFA-TR*            AND RT.VERSION_NO_CNTRL  =  J1.VERSION_NO_CNTRL              
MFA-TR*            AND (J1.REG_TYPE_CD      = 'H' OR                            
MFA-TR*                 J1.DEM_REG_TYPE_CD  = 'H' )                             
MFA-TR*            AND RT.VERSION_NO_CNTRL  =                                   
MFA-TR*                (SELECT MAX (RT2.VERSION_NO_CNTRL)                       
MFA-TR*                   FROM CSS_RATE_CREATOR  RT2                            
MFA-TR*                  WHERE RT2.RATE_PLAN_NO   = RT.RATE_PLAN_NO             
MFA-TR*                    AND RT2.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE           
MFA-TR*                    AND RT2.CODE_STATUS    = RT.CODE_STATUS)             
MFA-TR*         GROUP BY RT.RATE_PLAN_NO                                        
MFA-TR*         ORDER BY 1                                                      
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7560                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
A03956******************************************************************00252986
A03956*** CURSOR TO RETRIEVE SUB ACCTS OF MICHELIN MASTER ACCOUNT    ***00252986
A03956******************************************************************00252986
A03956     EXEC SQL                                                     
A03956       DECLARE SUBS_OF_MICH_MAST CURSOR FOR                       
A03956          SELECT CODE_ACCT_BILLED                                 
A03956            FROM CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED)                
A03956                ,CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                
A03956            WHERE  UR.ACCOUNT_NO_MST      = :UR-ACCOUNT-NO-MST    
A03956             AND   UR.CODE_RELATION_TYPE  = 'C'                   
A03956             AND   UR.ACCOUNT_NO_DEP      = AT.ACCOUNT_NO         
A03956          FOR READ ONLY                                   
A03956                                                      
A03956     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SUBS_OF_MICH_MAST CURSOR FOR                               
MFA-TR*         SELECT CODE_ACCT_BILLED                                         
MFA-TR*           FROM CSS_UTL_BILL_REL UR                                      
MFA-TR*               ,CSS_ACCOUNT      AT                                      
MFA-TR*           WHERE  UR.ACCOUNT_NO_MST      = :UR-ACCOUNT-NO-MST            
MFA-TR*            AND   UR.CODE_RELATION_TYPE  = 'C'                           
MFA-TR*            AND   UR.ACCOUNT_NO_DEP      = AT.ACCOUNT_NO                 
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7910                                                    
MFA-TR*    END-EXEC.                                                            
A03956                                                                  
       PROCEDURE DIVISION.                                              
      ******************************************************************00252986
      *                                                                *00253086
      *   0000-MAINLINE.                                               *00253186
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *00253286
      *                                                                *00253386
      ******************************************************************00253486
       0000-MAINLINE.                                                   
           PERFORM 1000-INITIATE-PROCESSING      THRU 1000-EXIT.        
           IF WS-PROCESS-TYPE = 1                                       
              PERFORM 2000-PROCESS-IDR-DATA         THRU 2000-EXIT      
                UNTIL EMPTY-FILE                                        
           END-IF.                                                      
           IF WS-THIS-IS-A-RESTART                                      
            AND WS-PROCESS-TYPE GREATER THAN 1                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 2 TO WS-PROCESS-TYPE                                 
              MOVE WS-Y  TO WS-REPOSITION-NEEDED                        
           END-IF                                                       
           MOVE SPACES TO WS-RESTART-JOB-COMPLETE.                      
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-B TO WS-RESTART-JOB-STATUS                        
           ELSE                                                         
              MOVE WS-A TO WS-RESTART-JOB-STATUS                        
           END-IF                                                       
           PERFORM 8899-MAINTAIN-RESTART THRU 8899-EXIT.                
           IF WS-RESTART-REQ = WS-YES                                   
              PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT        
           END-IF.                                                      
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0600-GET-RESTART-REQUEST.                                        
           MOVE WS-PGRMNAME    TO RF-NAME-PROGRAM.                      
           MOVE 1              TO RF-PARTITION-NO.                      
           MOVE 1              TO RF-DUP-CNTRL-NO.                      
T14956     MOVE  SPACES        TO RF-RESTART-DATA-TEXT.                 
           PERFORM 7900-SELECT-RESTART THRU 7900-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE RF-RESTART-DATA-TEXT TO WS-RESTART-DATA              
              IF WS-RESTART-PROCESS-TYPE NUMERIC                        
                 SET WS-THIS-IS-A-RESTART TO TRUE                       
              END-IF                                                    
           END-IF.                                                      
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0602-VALIDATE-REQUEST.                                           
           DISPLAY '*********************************************'.     
           DISPLAY '*****   THIS IS A RESTART OF JCSBW112   *****'.     
           DISPLAY '*********************************************'.     
           MOVE WS-RESTART-PROCESS-TYPE       TO WS-PROCESS-TYPE.       
           MOVE WS-RESTART-CHKP-SEQ-NO        TO WS-CHKP-SEQ-NO.        
           IF WS-RESTART-COMMON-DATE NOT = WS-INPUT-DATE                
            AND WS-RESTART-COMMON-DATE NOT EQUAL SPACES                 
              DISPLAY '**********************************************'  
              DISPLAY '** COMMON DATE WAS CHANGED PRIOR TO RESTART **'  
              DISPLAY '**********************************************'  
              DISPLAY '** OLD COMMON DATE = ' WS-RESTART-COMMON-DATE    
              DISPLAY '** NEW COMMON DATE = ' WS-INPUT-DATE             
TP9251        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       0602-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *    0605-VALIDATE-RESTART-REQ                                 **         
      *****************************************************************         
       COPY CPD00030.                                                           
                                                                        
A03247******************************************************************        
A03247* 0700-PROCESS-FOR-HRLY-RATE                                     *        
A03247******************************************************************        
A03247 0700-PROCESS-FOR-HRLY-RATE.                                      
A03247*                                                                         
A03247     PERFORM 7100-INPUT-DT-PLUS-25-MTHS  THRU 7100-EXIT.          
A03247     MOVE WS-INPUT-DT-PLUS-25MTHS        TO WS-IDR-INFO-RETENT-DT.
A03247     DISPLAY 'IDR INFO RETENT DT  : ' WS-IDR-INFO-RETENT-DT.      
A03247*                                                                         
A03247     INITIALIZE                             WS-RATE-PLAN-TABLE.   
A03247     PERFORM 7560-OPEN-HRLY-RATE-CURSOR  THRU 7560-EXIT.          
A03247     PERFORM 7570-FETCH-HRLY-RATE-CURSOR THRU 7570-EXIT.          
A03247*                                                                         
A03247     IF WS-RATE-PLAN-COUNT >= 20                                  
A03247        DISPLAY '********** PCSBW112 ABORT **************'        
A03247        DISPLAY '*  0700-PROCESS-FOR-HRLY-RATE          *'        
A03247        DISPLAY '* CSS_RATE_CREATOR  : ARRAY OVERFLOW   *'        
A03247        DISPLAY '* CSS_RATE_COMP_DEF : ARRAY OVERFLOW   *'        
A03247        DISPLAY '****************************************'        
A03247        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
A03247     END-IF.                                                      
A03247*                                                                         
A03247     PERFORM 7580-CLOSE-HRLY-RATE-CURSOR THRU 7580-EXIT.          
A03247*                                                                         
A03247     DISPLAY 'RATE PLAN ROW COUNT : ' WS-RATE-PLAN-COUNT.         
A03247                                                                  
A03247*                                                                         
A03247 0700-EXIT.                                                       
A03247     EXIT.                                                        
                                                                        
      ******************************************************************00265686
      *                                                                *00265786
      *   1000-INITIATE-PROCESSING                                     *00265886
      *        COMMON INITIALIZATION ROUTINE OPENS INPUT FILE AND      *00265986
      *        PERFORMS PRIMARY READ.                                  *        
      *                                                                *00266086
      ******************************************************************00266186
       1000-INITIATE-PROCESSING.                                        
           OPEN INPUT  FCSBW112.                                        
           IF FBW112-SUCCESSFUL                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '1000- ERROR ON FCSBW112 OPEN. STATUS IS '        
                       WS-FBW112-STATUS                                 
TP9251        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
              MOVE SPACES              TO WS-SYSIPT                     
              MOVE SPACES              TO WS-INPUT-DATA-BREAKDOWN       
              MOVE WS-COMMON           TO WS-PROGRAM                    
              MOVE WS-DATE             TO WS-COMMAND                    
              MOVE ZEROS               TO WS-SEQUENCE                   
              MOVE WS-KEY-AREA         TO E-FJC01-KEY                   
              PERFORM 7600-START-FCSJC01 THRU 7600-EXIT                 
              PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                  
                UNTIL (RUN-DATE AND INPUT-ACTIVE)                       
                   OR END-OF-SYSIPT                                     
              IF END-OF-SYSIPT                                          
                 DISPLAY '**  PCSBW112 PROCESSING ERROR   **'           
                 DISPLAY '**  COMMON DATE PARM NOT ACTIVE **'           
                 DISPLAY '**    KEY = ' E-FJC01-KEY                     
                 DISPLAY '**    PROCESSING TERMINATED     **'           
                 PERFORM 9900-ABEND                THRU 9900-EXIT       
              ELSE                                                      
                 IF WS-INPUT-RUN-DATE-MM NUMERIC AND                    
                    WS-INPUT-RUN-DATE-DD NUMERIC AND                    
                    WS-INPUT-RUN-DATE-CC NUMERIC AND                    
                    WS-INPUT-RUN-DATE-YY NUMERIC                        
                     MOVE WS-INPUT-RUN-DATE TO WS-INPUT-DATE            
                     PERFORM 7611-CLOSE            THRU 7611-EXIT       
                 ELSE                                                   
                     DISPLAY '**  PCSBW112 PROCESSING ERROR    **'      
                     DISPLAY '**  COMMON DATE PARM NOT NUMERIC **'      
                     DISPLAY '**    KEY = ' E-FJC01-KEY                 
                     DISPLAY '**     PROCESSING TERMINATED     **'      
                     PERFORM 9900-ABEND            THRU 9900-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           PERFORM 1500-INITIALIZE-JOB-PARMS     THRU 1500-EXIT.        
           PERFORM 5005-READ-IDR-RECORD          THRU 5005-EXIT.        
           IF EMPTY-FILE                                                
T33694         DISPLAY '1000- INITIATE-PROCESSING STOPPED'              
               DISPLAY 'INPUT FILE IS EMPTY'                            
T33694         STOP RUN                                                 
           END-IF.                                                      
T13287     MOVE E-FBW112-REC-BUFFER TO E-FBW112-HEADER-0000.            
           PERFORM 6235-GET-FJC01-RESTART-REQ    THRU 6235-EXIT.        
           PERFORM 0600-GET-RESTART-REQUEST THRU 0600-EXIT              
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 0602-VALIDATE-REQUEST THRU 0602-EXIT              
           END-IF                                                       
           PERFORM 0605-VALIDATE-RESTART-REQ THRU 0605-EXIT.            
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
               MOVE WS-Y         TO WS-REPOSITION-NEEDED                
               IF WS-PROCESS-TYPE EQUAL 1                               
T5442            IF WS-RESTART-METER-ID-NO NOT EQUAL ZEROS              
                   PERFORM 5006-READ-MV90-FOR-RESTART THRU 5006-EXIT    
                     UNTIL E-FBW112-0000-IDENT-NO =                     
                                         WS-RESTART-METER-ID-NO         
T5442            END-IF                                                 
               END-IF                                                   
           ELSE                                                         
               MOVE SPACES TO WS-RESTART-COMMON-DATE                    
               MOVE WS-C TO WS-RESTART-JOB-STATUS                       
               MOVE ZERO TO WS-RESTART-CHKP-SEQ-NO                      
               MOVE ZERO TO WS-RESTART-METER-ID-NO                      
               MOVE 1    TO WS-PROCESS-TYPE                             
      ****************************************************************          
      *          ISSUE INITIAL CHECKPOINT                                       
      ****************************************************************          
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
                                                                        
T15068*        PERFORM 8000-COMMIT     THRU 8000-EXIT                           
                                                                        
               MOVE WS-Y TO WS-REPOSITION-NEEDED                        
               MOVE WS-INPUT-DATE TO WS-RESTART-COMMON-DATE             
               MOVE E-FBW112-REC-BUFFER    TO E-FBW112-HEADER-0000      
           END-IF.                                                      
      *                                                                         
           PERFORM 0700-PROCESS-FOR-HRLY-RATE THRU 0700-EXIT.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00265686
      *                                                                *00265786
      *    1000-INITIALIZE-JOB-PARMS                                   *00265886
      *    CHECKS TO SEE IF THERE ARE ANY JOB PARMS.                   *        
      *    IF THERE ARE THEN COUNT THE NUMBER OF JOB PARMS.            *        
      *                                                                *00266086
      ******************************************************************00265686
       1500-INITIALIZE-JOB-PARMS.                                       
      *                                                                         
           PERFORM 2011-CHECK-JOB-PARM           THRU 2011-EXIT.        
           IF WS-JOB-PARM EQUAL WS-YES                                  
               PERFORM 7000-COUNT-JOB-PARM       THRU 7000-EXIT         
               DIVIDE WS-NO-OF-JOB-PARMS BY 2                           
                 GIVING WS-NO-OF-JOB-PARMS                              
           END-IF.                                                      
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    2000-PROCESS-IDR-DATA                                      *         
      *        PROCESS EACH METER ON THE MV90 INPUT FILE.             *         
      *        GET INFORMATION FROM HEADER RECORDS THEN CHECK ACCOUNT *         
      *        TABLE, AND METER IDENTIFICATION HISTORY TABLES.        *         
      *        PROCESS THE KWH UNIT OF MEASUREMENT CHANNEL FIRST THEN *         
      *        PROCESS THE REST OF THE CHANNELS.  AT THE END PROCESS  *         
      *        THE PULSE RECORD.                                      *         
      *                                                               *         
      *****************************************************************         
       2000-PROCESS-IDR-DATA.                                           
      *                                                                         
           MOVE 'N' TO WS-METER-CHANGE-IND                              
                       WS-OVERRIDE-IND                                  
T26776                 WS-COINCIDENTAL-FLAG                             
T26776                 WS-COINCIDENTAL-ACCT-FLAG                        
T26776                 WS-CON-CX-PROCESS.                               
T26776     MOVE SPACES TO WS-CON-BILL-ITEM-TIMESTMP                     
T26776                    WS-CON-BILL-ITEM-TIMESTMP2.                   
           IF WS-INSERT-WORK-QUEUE EQUAL WS-YES                         
              PERFORM 8100-ROLLBACK             THRU 8100-EXIT          
              PERFORM 5314-CREATE-WORKQ         THRU 5314-EXIT          
              PERFORM 8000-COMMIT               THRU 8000-EXIT          
              IF WS-JOB-PARM EQUAL WS-YES                               
                 PERFORM 2011-CHECK-JOB-PARM   THRU 2011-EXIT           
              END-IF                                                    
              MOVE WS-YES             TO WS-GOTO-NEXT-METER             
           END-IF.                                                      
           IF WS-GOTO-NEXT-METER EQUAL WS-YES                           
              PERFORM 5300-GOTO-NEXT-METER      THRU 5300-EXIT          
                UNTIL (E-FBW112-0000-SORT-CODE EQUAL WS-0000            
                  AND E-FBW112-0000-IDENT-NO NOT EQUAL WS-IDR-IDENT-NO) 
                   OR EMPTY-FILE                                        
              IF EMPTY-FILE                                             
                 IF (WS-JOB-PARM EQUAL WS-YES                           
                   AND WS-NO-MORE-JOB-PARMS EQUAL WS-NO)                
                   AND G6-PARM-DATA NOT EQUAL 'RESTART-REQ=Y'           
                    DISPLAY '2000-PROCESS-IDR-DATA ABEND'               
                    DISPLAY 'JOB-PARM NOT FOUND ON INPUT FILE. '        
                             G6-PARM-DATA                               
TP9251              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
                 ELSE                                                   
                    PERFORM 2400-CHECK-HELD-RD-ROUTE THRU 2400-EXIT     
                 END-IF                                                 
                 GO TO 2000-EXIT                                        
              ELSE                                                      
                 PERFORM 2001-INIT-VARIABLES   THRU 2001-EXIT           
              END-IF                                                    
           END-IF.                                                      
           IF WS-NO-MORE-JOB-PARMS EQUAL WS-YES                         
              SET EMPTY-FILE TO TRUE                                    
              GO TO 2000-EXIT                                           
           END-IF.                                                      
           PERFORM 2010-PROCESS-HEADERS          THRU 2010-EXIT.        
           IF WS-INSERT-WORK-QUEUE EQUAL WS-YES                         
              DISPLAY '2000-PROCESS-IDR-DATA '                          
              DISPLAY 'HEADER SORT CODES OUT OF SEQUENCE '              
              DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING'        
              MOVE ZERO               TO AT-ACCOUNT-NO                  
              MOVE ZERO               TO AT-PREMISE-NO                  
              MOVE ZERO               TO AT-CUSTOMER-NO                 
              MOVE ZERO               TO AT-LOCAL-OFFICE                
              MOVE WS-YES TO WS-INSERT-WORK-QUEUE                       
T15925        MOVE   4                    TO WS-ROUTE-CATEGORY          
T15925        MOVE WS-IDR-CATEGORY-136    TO WS-IDR-CATEGORY            
              MOVE E-FBW112-0000-IDENT-NO TO WS-IDENT-NO-STR            
                                             WS-IDR-IDENT-NO            
              STRING INCORRECT-SORT WS-IDENT-NO-STRING                  
                DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT               
              MOVE LENGTH OF WS-COMMENTS-TEXT                           
                                      TO WS-COMMENTS-LEN                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           DIVIDE WS-ONE-HOUR BY E-FBW112-0001-INT-PER-HOUR             
             GIVING WS-INTERVAL.                                        
           MOVE E-FBW112-0000-IDENT-NO     TO WS-IDR-IDENT-NO           
                                              L7-IDR-IDENT-NO.          
           MOVE E-FBW112-0002-ACCOUNT-NO   TO WS-ACCOUNT-NO             
                                              AT-ACCOUNT-NO.            
           MOVE E-FBW112-0001-INT-PER-HOUR TO WS-INTERVAL-PER-HOUR.     
      *                                                                         
           IF WS-JOB-PARM EQUAL WS-YES                                  
              PERFORM 2013-PROCESS-JOB-PARM     THRU 2013-EXIT          
              IF WS-GOTO-NEXT-METER EQUAL WS-YES                        
                 GO TO 2000-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7010-SELECT-METER-NO          THRU 7010-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              DISPLAY '2000-PROCESS-IDR-DATA ' WS-IDR-IDENT-NO          
              DISPLAY 'METER-NO NOT FOUND ON IDR_ACCT_MTR TABLE'        
              DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '       
T14361        MOVE ZERO               TO AT-ACCOUNT-NO                  
T14361        MOVE ZERO               TO AT-PREMISE-NO                  
T14361        MOVE ZERO               TO AT-CUSTOMER-NO                 
T14361        MOVE ZERO               TO AT-LOCAL-OFFICE                
T15925        MOVE   4                 TO WS-ROUTE-CATEGORY             
T15925        MOVE WS-IDR-CATEGORY-136 TO WS-IDR-CATEGORY               
              MOVE WS-YES TO WS-INSERT-WORK-QUEUE                       
              MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR                
              STRING METER-NO-NOT-FOUND WS-IDENT-NO-STRING              
                DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT               
              MOVE LENGTH OF WS-COMMENTS-TEXT                           
                                       TO WS-COMMENTS-LEN               
              GO TO 2000-EXIT                                           
           END-IF.                                                      
           MOVE L7-METER-NO TO WS-METER-NO.                             
           MOVE L7-ACCOUNT-NO TO AT-ACCOUNT-NO                          
                                 WS-ACCOUNT-NO.                         
           PERFORM 7050-SELECT-ACCOUNT-NO        THRU 7050-EXIT.        
T22243     MOVE AT-COMPANY-NO            TO IX-COMPANY-NO               
T22243                                      MA-COMPANY-NO               
T22243                                      MC-COMPANY-NO.              
T15925     MOVE   1                      TO WS-ROUTE-CATEGORY           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 5060-SELECT-OLD-ACCOUNT   THRU 5060-EXIT          
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 DISPLAY '2000-PROCESS-IDR-DATA '                       
                          WS-IDR-IDENT-NO                               
                 DISPLAY 'ACCOUNT NUMBER NOT FOUND'                     
                 DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '    
                 MOVE AT-ACCOUNT-NO      TO WS-ACCOUNT-NO-STR           
                 MOVE ZERO               TO AT-ACCOUNT-NO               
                 MOVE ZERO               TO AT-PREMISE-NO               
                 MOVE ZERO               TO AT-CUSTOMER-NO              
                 MOVE ZERO               TO AT-LOCAL-OFFICE             
                 MOVE WS-YES TO WS-INSERT-WORK-QUEUE                    
T15925           MOVE   4                TO WS-ROUTE-CATEGORY           
T15925           MOVE WS-IDR-CATEGORY-16 TO WS-IDR-CATEGORY             
                 MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR             
                 STRING INCORRECT-ACCOUNT                               
                        WS-IDENT-NO-STRING                              
                        ' ACCOUNT NO='                                  
                        WS-ACCOUNT-NO-STR                               
                     DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT          
                 MOVE LENGTH OF WS-COMMENTS-TEXT                        
                                         TO WS-COMMENTS-LEN             
                 GO TO 2000-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
           PERFORM 2020-PROCESS-KWH-CHANNEL      THRU 2020-EXIT         
             VARYING WS-IDR-SUB      FROM 1 BY 1                        
             UNTIL WS-IDR-SUB GREATER WS-NO-OF-CHANNELS                 
                OR WS-KWH-CHANNEL GREATER ZERO                          
                OR WS-INSERT-WORK-QUEUE EQUAL WS-YES.                   
           IF WS-INSERT-WORK-QUEUE EQUAL WS-YES                         
              GO TO 2000-EXIT
           END-IF.                                          
           IF WS-KWH-CHANNEL EQUAL ZERO                                 
              DISPLAY '2000-PROCESS-IDR-DATA ' WS-IDR-IDENT-NO          
              DISPLAY 'NO KWH CHANNEL EXISTS'                           
              DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '       
              MOVE WS-YES TO WS-INSERT-WORK-QUEUE                       
T15925        MOVE   4                 TO WS-ROUTE-CATEGORY             
T15925        MOVE WS-IDR-CATEGORY-136 TO WS-IDR-CATEGORY               
              MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR                
              STRING NO-KWH-CHANNEL WS-IDENT-NO-STRING                  
                  DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT             
              MOVE LENGTH OF WS-COMMENTS-TEXT                           
                                      TO WS-COMMENTS-LEN                
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
T19862     MOVE ZEROS                  TO WS-KWH-PULSE-MULT             
T19862                                    WS-OTHR-PULSE-MULT.           
           PERFORM 2030-PROCESS-CHANNELS         THRU 2030-EXIT         
             VARYING WS-IDR-SUB      FROM 1 BY 1                        
             UNTIL WS-IDR-SUB GREATER WS-NO-OF-CHANNELS                 
                OR WS-INSERT-WORK-QUEUE EQUAL WS-YES.                   
           IF WS-INSERT-WORK-QUEUE EQUAL WS-YES                         
              GO TO 2000-EXIT                                           
           END-IF.                                                      
           MOVE AT-ACCOUNT-NO          TO GA-ACCOUNT-NO                 
           MOVE WS-METER-NO            TO GA-METER-NO                   
T20288                                    MA-METER-NO                   
                                          IV-METER-NO.                  
T20288     MOVE WS-CT                      TO MA-CODE-ATT-TYPE.         
T20288     PERFORM 7520-GET-CT-PT-RATIO THRU 7520-EXIT.                 
T20288     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T20288         MOVE IX-RTO-UPPER-FRACTION  TO GA-CT-UPPER-RATIO         
T20288         MOVE IX-RTO-LOWER-FRACTION  TO GA-CT-LOWER-RATIO         
T20288     ELSE                                                         
T20288         MOVE ZEROS                  TO GA-CT-UPPER-RATIO         
T20288                                        GA-CT-LOWER-RATIO         
T20288     END-IF.                                                      
T20288*                                                                         
T20288     MOVE WS-PT                      TO MA-CODE-ATT-TYPE.         
T20288     PERFORM 7520-GET-CT-PT-RATIO THRU 7520-EXIT.                 
T20288     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T20288         MOVE IX-RTO-UPPER-FRACTION  TO GA-PT-UPPER-RATIO         
T20288         MOVE IX-RTO-LOWER-FRACTION  TO GA-PT-LOWER-RATIO         
T20288     ELSE                                                         
T20288         MOVE ZEROS                  TO GA-PT-UPPER-RATIO         
T20288                                        GA-PT-LOWER-RATIO         
T20288     END-IF.                                                      
           MOVE WS-MTR-REF-NO          TO GA-MTR-REF-NO.                
           MOVE WS-IC-NO               TO GA-IC-NO.                     
           MOVE WS-E                   TO GA-CODE-UTIL-TYPE.            
           MOVE BG-BILL-NO             TO GA-BILL-NO.                   
           MOVE WS-IDR-IDENT-NO        TO GA-IDR-IDENT-NO.              
           MOVE BG-BILL-ITEM-TIMESTMP  TO GA-BILL-ITEM-TIMESTMP         
                                          IV-BILL-ITEM-TIMESTMP.        
           MOVE WS-INTERVAL-PER-HOUR   TO GA-INTERVALS-PER-HR.          
A03247     MOVE SPACES                 TO GA-IDR-INFO-RETENT-DT.        
A03247     MOVE WS-NO                  TO WS-RATE-PLAN-FOUND.           
A03247     PERFORM VARYING WS-RATE-PLAN-SUB FROM 1 BY 1                 
A03247           UNTIL WS-RATE-PLAN-SUB   > WS-RATE-PLAN-COUNT          
A03247              OR WS-RATE-PLAN-FOUND = WS-YES                      
A03247       IF BG-RATE-PLAN-NO EQUAL ARR-RATE-PLAN-NO(WS-RATE-PLAN-SUB)
A03247          MOVE WS-YES            TO WS-RATE-PLAN-FOUND            
A03247       END-IF                                                     
A03247     END-PERFORM.                                                 
A03247     IF WS-RATE-PLAN-FOUND EQUAL WS-YES                           
A03247        MOVE 0                     TO WS-NULL-IND-RETENT-DT       
A03247        MOVE WS-IDR-INFO-RETENT-DT TO GA-IDR-INFO-RETENT-DT       
A03247     ELSE                                                         
A03247        MOVE WS-NEG-ONE            TO WS-NULL-IND-RETENT-DT       
A03247     END-IF.                                                      
           PERFORM 8800-INSERT-MTR-IDENT-HIST    THRU 8800-EXIT.        
           MOVE WS-N                   TO IV-DST-CHNG-IND.              
           MOVE WS-TIME-BEGIN          TO WS-TIME-READ.                 
           PERFORM 8600-ADD-ONE-INTERVAL         THRU 8600-EXIT.        
           MOVE WS-TIME-READ           TO WS-TIME-BEGIN.                
           MOVE WS-START-TIME          TO WS-TIME-READ.                 
           MOVE WS-START-DATE          TO IV-DATE-READ                  
                                          WS-DATE-READ.                 
           PERFORM 8500-SUBTRACT-ONE-MINUTE      THRU 8500-EXIT.        
           IF WS-TIME-READ EQUAL WS-TIME-ZERO                           
              MOVE WS-YES              TO WS-FIRST-TIME                 
           END-IF.                                                      
           MOVE WS-9999                TO WS-PULSE-SUB.                 
           PERFORM 3010-GET-NEXT-PULSE           THRU 3010-EXIT.        
           IF WS-INSERT-WORK-QUEUE EQUAL WS-YES                         
              GO TO 2000-EXIT                                           
           END-IF.                                                      
T19862     MOVE ZEROS                  TO WS-KWH                        
T19862                                    WS-KQH                        
T19862                                    WS-KVAR                       
T19862                                    WS-KVARH                      
T19862                                    WS-KW                         
T19862                                    WS-KVA                        
T19862                                    WS-PEAK-KVA-1                 
T19862                                    WS-PEAK-KW-1                  
T19862                                    WS-PEAK-KVA-2                 
T22675                                    WS-PEAK-KVAR-1                
T19862                                    WS-PEAK-KVAR-2                
T19862                                    WS-PEAK-KW-2.                 
T22214     MOVE SPACES                 TO WS-PEAK-DATE-1                
T22214                                    WS-PEAK-DATE-2.               
           PERFORM 3000-PROCESS-IDR-PULSES       THRU 3000-EXIT         
             UNTIL WS-NO-MORE-INTERVALS EQUAL WS-YES                    
                OR WS-INSERT-WORK-QUEUE EQUAL WS-YES.                   
           IF WS-INSERT-WORK-QUEUE EQUAL WS-YES                         
              GO TO 2000-EXIT                                           
           END-IF.                                                      
T22214     IF  WS-PEAK-DATE-1 > ZEROS AND SPACES                        
T22214          AND WS-PEAK-DATE-2 > ZEROS AND SPACES                   
T22214         PERFORM 3030-DETERMINE-PEAKS THRU 3030-EXIT              
T22214     END-IF.                                                      
      *                                                                         
           PERFORM 3200-CHECK-PULSE-RECORDS      THRU 3200-EXIT.        
           IF WS-INSERT-WORK-QUEUE EQUAL WS-YES                         
              GO TO 2000-EXIT
           END-IF.                                          
           IF EMPTY-FILE                                                
              DISPLAY '2000-PROCESS-IDR-DATA '                          
              DISPLAY 'END OF FILE RECORD MISSING '                     
              DISPLAY 'LAST METER IDENT PROCESSED = ' WS-IDR-IDENT-NO   
              DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '       
              MOVE WS-YES TO WS-INSERT-WORK-QUEUE                       
T15925        MOVE   4                 TO WS-ROUTE-CATEGORY             
T15925        MOVE WS-IDR-CATEGORY-136 TO WS-IDR-CATEGORY               
              MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR                
              STRING END-OF-FILE-MISSING WS-IDENT-NO-STRING             
                  DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT             
              MOVE LENGTH OF WS-COMMENTS-TEXT TO WS-COMMENTS-LEN        
              GO TO 2000-EXIT                                           
           END-IF.                                                      
           IF E-FBW112-PULSE-SORT-CODE EQUAL WS-9999                    
T15689        PERFORM 2400-CHECK-HELD-RD-ROUTE     THRU 2400-EXIT       
              PERFORM 8000-COMMIT                  THRU 8000-EXIT       
              SET EMPTY-FILE TO TRUE                                    
           ELSE                                                         
T15689        PERFORM 2400-CHECK-HELD-RD-ROUTE     THRU 2400-EXIT       
              PERFORM 8000-COMMIT                  THRU 8000-EXIT       
              IF WS-JOB-PARM EQUAL WS-YES                               
                 PERFORM 2011-CHECK-JOB-PARM       THRU 2011-EXIT       
              END-IF                                                    
              PERFORM 2001-INIT-VARIABLES          THRU 2001-EXIT       
           END-IF.                                                      
       2000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    2001-INIT-VARIABLES                                        *         
      *                                                               *         
      *****************************************************************         
       2001-INIT-VARIABLES.                                             
           MOVE ZERO                   TO WS-KWH-CHANNEL.               
           MOVE ZERO                   TO WS-PULSE-SUB.                 
           MOVE ZERO                   TO WS-TOTAL-INTERVALS.           
           MOVE ZERO                   TO WS-TOTAL-INT-ON-HEADER.       
           MOVE ZERO                   TO WS-REVENUE-MONTH.             
           MOVE WS-NO                  TO WS-NO-MORE-INTERVALS.         
           MOVE WS-NO                  TO WS-INSERT-WORK-QUEUE.         
           MOVE WS-NO                  TO WS-GOTO-NEXT-METER.           
           MOVE WS-NO                  TO WS-END-OF-FILE.               
           MOVE SPACES                 TO WS-COMMENTS-TEXT.             
T15925     MOVE 1                      TO WS-ROUTE-CATEGORY.            
T15925     MOVE 16                     TO WS-IDR-CATEGORY.              
           MOVE 0                      TO WS-COMMENTS-LEN.              
           MOVE 0100                   TO WS-PULSE-SORT-CODE.           
           MOVE '00:00:00'             TO WS-TIME-BEGIN.                
           PERFORM                                                      
               VARYING WS-IDR-SUB FROM 1 BY 1                           
               UNTIL WS-IDR-SUB GREATER WS-NO-OF-CHANNELS               
                  MOVE ZERO TO WS-PULSE-TOTAL(WS-IDR-SUB)               
           END-PERFORM.                                                 
       2001-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    2010-PROCESS-HEADERS                                       *         
      *         CONTROLS PROCESSING OF HEADERS 0000-0002 AND READS    *         
      *         THE FIRST PULSE DATA RECORD.  CONVERTS DATES IN       *         
      *         HEADERS TO DB2 FORMAT.                                *         
      *                                                               *         
      *****************************************************************         
       2010-PROCESS-HEADERS.                                            
      *                                                                         
           IF E-FBW112-0000-SORT-CODE EQUAL HEADER-0000                 
               NEXT SENTENCE                                            
             ELSE                                                       
               MOVE WS-YES TO WS-INSERT-WORK-QUEUE                      
               GO TO 2010-EXIT                                          
           END-IF.                                                      
      *                                                                         
           PERFORM 5005-READ-IDR-RECORD          THRU 5005-EXIT.        
           MOVE E-FBW112-REC-BUFFER    TO E-FBW112-HEADER-0001.         
           IF E-FBW112-0001-SORT-CODE EQUAL HEADER-0001                 
               NEXT SENTENCE                                            
             ELSE                                                       
               MOVE WS-YES TO WS-INSERT-WORK-QUEUE                      
               GO TO 2010-EXIT                                          
           END-IF.                                                      
      *                                                                         
           PERFORM 5005-READ-IDR-RECORD          THRU 5005-EXIT.        
           MOVE E-FBW112-REC-BUFFER    TO E-FBW112-HEADER-0002.         
           IF E-FBW112-0002-SORT-CODE EQUAL HEADER-0002                 
               NEXT SENTENCE                                            
             ELSE                                                       
               MOVE WS-YES TO WS-INSERT-WORK-QUEUE                      
               GO TO 2010-EXIT                                          
           END-IF.                                                      
      *                                                                         
           PERFORM 3100-DETERMINE-CHANNELS       THRU 3100-EXIT.        
      *                                                                         
           MOVE E-FBW112-0000-TOTAL-INT    TO WS-TOTAL-INT-ON-HEADER.   
           MOVE E-FBW112-0000-STOP-TIME    TO WS-IDR-DATE.              
           PERFORM 2015-CNVRT-IDR-DATE-TIME      THRU 2015-EXIT.        
           MOVE WS-DATE-READ               TO WS-END-DATE.              
ACT138     MOVE WS-TIME-READ               TO WS-END-TIME.              
           MOVE E-FBW112-0000-START-TIME   TO WS-IDR-DATE.              
           PERFORM 2015-CNVRT-IDR-DATE-TIME      THRU 2015-EXIT.        
           MOVE WS-DATE-READ               TO WS-START-DATE.            
           MOVE WS-TIME-READ               TO WS-START-TIME.            
           MOVE E-FBW112-0001-DST-TYPE     TO WS-DST-TYPE.              
           IF WS-DST-TYPE EQUAL WS-F OR WS-S                            
               MOVE E-FBW112-0001-DST-CHANGE TO WS-IDR-DATE             
               PERFORM 2015-CNVRT-IDR-DATE-TIME  THRU 2015-EXIT         
               MOVE WS-DATE-READ           TO WS-DST-DATE               
               MOVE WS-TIME-READ           TO WS-DST-TIME               
           END-IF.                                                      
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    2011-CHECK-JOB-PARM                                        *         
      *        CHECK TO SEE IF A JOB PARM EXISTS FOR THIS PROGRAM     *         
      *        AND OPEN THE CURSOR.                                   *         
      *                                                               *         
      *****************************************************************         
       2011-CHECK-JOB-PARM.                                             
      *                                                                         
           MOVE PROGRAM-NAME           TO G6-PROGRAM-NAME.              
           MOVE WS-A                   TO G6-STATUS.                    
           PERFORM 7200-OPEN-JOB-PARM            THRU 7200-EXIT.        
           PERFORM 7201-FETCH-JOB-PARM           THRU 7201-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE WS-YES             TO WS-JOB-PARM
           END-IF.                  
           PERFORM 7202-CLOSE-JOB-PARM           THRU 7202-EXIT.        
      *                                                                         
       2011-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00265686
      *                                                                *00265786
      *    2013-PROCESS-JOB-PARM                                       *00265886
      *        CHECKS JOB PARM CURSOR WITH CURRENT METER IDENT NO.     *        
      *        IF A JOB PARM IS FOUND THEN UPDATE THE PARM TO INACTIVE *        
      *        AND PROCESS METER'S INTERVAL READS.                     *        
      *        IF A JOB PARM IS NOT FOUND THEN SET FLAG TO GO TO NEXT  *        
      *        METER ON INPUT FILE.  DECREMENT THE NUMBER OF JOB PARMS *        
      *        UNTIL ZERO IF THE JOB PARM IS FOUND.                    *        
      *                                                                *        
      ******************************************************************00266186
       2013-PROCESS-JOB-PARM.                                           
      *                                                                         
           MOVE WS-IDR-IDENT-NO TO WS-IDENT-NO-STR.                     
           MOVE 'A'             TO G6-STATUS.                           
           PERFORM 7200-OPEN-JOB-PARM            THRU 7200-EXIT         
           PERFORM 7201-FETCH-JOB-PARM           THRU 7201-EXIT         
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
               OR  G6-PARM-DATA EQUAL WS-IDENT-NO-STRING.               
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE WS-I               TO G6-STATUS                     
               PERFORM 8700-UPDATE-JOB-PARM      THRU 8700-EXIT         
               PERFORM 7201-FETCH-JOB-PARM       THRU 7201-EXIT         
               IF G6-PARM-DATA EQUAL WS-OVERRIDE-YES OR WS-OVERRIDE-NO  
                   CONTINUE                                             
                 ELSE                                                   
                   DISPLAY '2013-PROCESS-JOB-PARM ABEND' WS-IDR-IDENT-NO
                   DISPLAY 'INVALID JOB PARM ENTRY'                     
TP9251             PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT         
               END-IF                                                   
               MOVE G6-PARM-DATA       TO WS-OVERRIDE                   
               IF WS-OVERRIDE-IND = 'Y'                                 
                   CONTINUE                                             
               ELSE                                                     
                   MOVE 'N' TO WS-OVERRIDE-IND                          
               END-IF                                                   
               MOVE WS-I               TO G6-STATUS                     
               PERFORM 8700-UPDATE-JOB-PARM  THRU 8700-EXIT             
               PERFORM 7202-CLOSE-JOB-PARM   THRU 7202-EXIT             
               SUBTRACT 1 FROM WS-NO-OF-JOB-PARMS                       
               IF WS-NO-OF-JOB-PARMS EQUAL ZERO                         
                   MOVE WS-YES         TO WS-NO-MORE-JOB-PARMS          
               END-IF                                                   
               MOVE WS-NO              TO WS-GOTO-NEXT-METER            
             ELSE                                                       
               PERFORM 7202-CLOSE-JOB-PARM   THRU 7202-EXIT             
               PERFORM 2011-CHECK-JOB-PARM   THRU 2011-EXIT             
               MOVE WS-YES             TO WS-GOTO-NEXT-METER            
           END-IF.                                                      
      *                                                                         
       2013-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00265686
      *                                                                *00265786
      *   2015-CNVRT-IDR-DATE-TIME                                     *00265886
      *       FORMATS THE DATE AND TIME FROM THE IDR INPUT FILE TO     *00266086
      *       DB2 DATE AND TIME VALUES.                                *        
      *                                                                *        
      ******************************************************************00266186
       2015-CNVRT-IDR-DATE-TIME.                                        
      *                                                                         
           IF WS-IDR-YEAR GREATER WS-50                                 
               MOVE WS-19              TO WS-READ-CENTURY               
             ELSE                                                       
               MOVE WS-20              TO WS-READ-CENTURY
           END-IF.              
           MOVE WS-IDR-YEAR            TO WS-READ-YEAR.                 
           MOVE WS-IDR-MONTH           TO WS-READ-MONTH.                
           MOVE WS-IDR-DAY             TO WS-READ-DAY.                  
           MOVE WS-IDR-HOUR            TO WS-READ-HOUR.                 
           MOVE WS-IDR-MIN             TO WS-READ-MIN.                  
      *                                                                         
       2015-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    2020-PROCESS-KWH-CHANNEL                                   *         
      *        LOCATE AND PROCESS THE CHANNEL WITH KWH UNIT OF        *         
      *        MEASUREMENT.  CALL 5000-UPDATE TO UPDATE BILLING       *         
      *        INFORMATION.  UPDATE MTR-ENVRNMT TABLE.                *         
      *                                                               *         
      *****************************************************************         
       2020-PROCESS-KWH-CHANNEL.                                        
      *                                                                         
           IF E-FBW112-0001-UOM(WS-IDR-SUB) EQUAL WS-KWH-CODE           
               NEXT SENTENCE                                            
           ELSE                                                         
               GO TO 2020-EXIT                                          
           END-IF.                                                      
                                                                        
                                                                        
TP5444     MOVE AT-ACCOUNT-NO          TO MN-ACCOUNT-NO                 
TP5444                                    UT-ACCOUNT-NO.                
           MOVE WS-E                   TO MN-CODE-UTIL-TYPE             
                                          UT-CODE-UTIL-TYPE.            
           MOVE WS-METER-NO            TO MN-METER-NO.                  
      *                                                                         
ACT062     MOVE 'N' TO WS-COGEN-METER.                                  
                                                                        
           PERFORM 7311-SELECT-MTRD-ENVRNMT THRU 7311-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
T10811        MOVE AT-LAST-NRML-BILL-NO TO CX-BILL-NO                   
T10811        MOVE MN-ACCOUNT-NO TO CX-ACCOUNT-NO                       
T10811        MOVE MN-CODE-UTIL-TYPE TO CX-CODE-UTIL-TYPE               
T10811        MOVE MN-METER-NO TO CX-METER-NO                           
T10811        MOVE 'B' TO CX-CODE-USAGE-TYPE                            
T17026        MOVE '1' TO CX-CODE-USAGE-ID                              
T10811        MOVE 'B' TO CX-CODE-USAGE-SOURCE                          
T10811        MOVE 0 TO CX-CODE-TIME-PERIOD                             
T10811        PERFORM 7312-SELECT-OLD-METER THRU 7312-EXIT              
T17233        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T17233           SUBTRACT 1 FROM CX-BILL-NO                             
T17233           PERFORM 7312-SELECT-OLD-METER THRU 7312-EXIT           
T17233        END-IF                                                    
T10811        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
T10811           SET WS-METER-CHANGE TO TRUE                            
T10811           MOVE CX-IC-NO TO MN-IC-NO                              
T10811           MOVE CX-MTR-REF-NO TO MN-MTR-REF-NO                    
T10811           MOVE CX-REG-ID-NO TO MN-REG-ID-NO                      
T10811           MOVE CX-DATE-READ TO MN-LAST-REG-READ-DATE             
ACT062           MOVE '00.00.00'   TO MN-LAST-REG-READ-TIME             
T10811           MOVE CX-METER-READING TO MN-LAST-READ-VALUE            
T10811           MOVE CX-CODE-DISCOUNT TO MN-CODE-DISCOUNT              
T10811           MOVE CX-CODE-USAGE-TYPE TO MN-CODE-USAGE-TYPE          
T10811           MOVE CX-CODE-USAGE-ID TO MN-CODE-USAGE-ID              
T10811           MOVE CX-CODE-USAGE-SOURCE TO MN-CODE-USAGE-SOURCE      
T10811           MOVE CX-CODE-ITEM-STATUS TO MN-CODE-METER-STATUS       
T18349           PERFORM 7315-SELECT-NEW-METER THRU 7315-EXIT           
T18349           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
T18349              IF WS-DATE-NEW-MTR-INSTALL > WS-START-DATE AND      
T18349                 WS-DATE-NEW-MTR-INSTALL < WS-END-DATE            
T18349                 DISPLAY '2020-PROCESS-KWH-CHANNEL '              
T18349                 DISPLAY WS-IDR-IDENT-NO                          
T18349                 DISPLAY WS-NEW-METER-NO ' IS A NEW METER'        
T18349                 DISPLAY 'METER WAS INSTALLED BETWEEN START IDR DA        
T18349-                'TE AND END IDR DATE OF OLD METER.'                      
T18349                 DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING        
T18349-                '.'                                                      
T18349                 MOVE WS-YES TO WS-INSERT-WORK-QUEUE              
T18349                 MOVE 4                  TO WS-ROUTE-CATEGORY     
T18349                 MOVE WS-IDR-CATEGORY-16 TO WS-IDR-CATEGORY       
T18349                 MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR       
T18349                 STRING NEW-MTRD-ENVRNMT WS-IDENT-NO-STRING       
T18349                   DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT      
T18349                 MOVE LENGTH OF WS-COMMENTS-TEXT                  
T18349                                         TO WS-COMMENTS-LEN       
T18349               GO TO 2020-EXIT                                    
T18349               END-IF                                             
T18349           END-IF                                                 
T10811        ELSE                                                      
                 DISPLAY '2020-PROCESS-KWH-CHANNEL ' WS-IDR-IDENT-NO    
                 DISPLAY 'METER NOT FOUND IN MTRD_ENVRNMT TABLE. '      
                          WS-METER-NO                                   
                 DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '    
                 MOVE WS-YES TO WS-INSERT-WORK-QUEUE                    
T15925           MOVE 4                  TO WS-ROUTE-CATEGORY           
T15925           MOVE WS-IDR-CATEGORY-16 TO WS-IDR-CATEGORY             
                 MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR             
                 STRING NO-MTRD-ENVRNMT WS-IDENT-NO-STRING              
                     DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT          
                 MOVE LENGTH OF WS-COMMENTS-TEXT                        
                                         TO WS-COMMENTS-LEN             
                 GO TO 2020-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
ACT062***** COGEN METER                                                         
ACT062     IF MN-PROGRAM-ID = '08'                                      
ACT062        AND MN-DIGTL-MTR-TYPE = 'X1'                              
ACT062          MOVE 'Y' TO WS-COGEN-METER                              
ACT062     END-IF.                                                      
                                                                        
           MOVE MN-IC-NO               TO UT-IC-NO                      
                                          WS-IC-NO.                     
           MOVE MN-MTR-REF-NO          TO WS-MTR-REF-NO.                
      *                                                                         
           PERFORM 7313-SELECT-UTIL-ENVRNMT      THRU 7313-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               DISPLAY '2020-PROCESS-KWH-CHANNEL ' WS-IDR-IDENT-NO      
               DISPLAY 'UTILITY NOT FOUND IN CSS-UTIL-ENVRNMT TABLE'    
               DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '      
               MOVE WS-YES TO WS-INSERT-WORK-QUEUE                      
T15925         MOVE 4                  TO WS-ROUTE-CATEGORY             
T15925         MOVE WS-IDR-CATEGORY-16 TO WS-IDR-CATEGORY               
               MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR               
               STRING NO-UTIL-ENVRNMT WS-IDENT-NO-STRING                
                   DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT            
               MOVE LENGTH OF WS-COMMENTS-TEXT                          
                                       TO WS-COMMENTS-LEN               
               GO TO 2020-EXIT                                          
           END-IF.                                                      
      *                                                                         
ACT062     PERFORM 2035-GET-CHANNEL-DATA         THRU 2035-EXIT.        
                                                                        
           COMPUTE WS-CONSTANT = (WS-PULSE-MULT-VAL /                   
                                  10 ** WS-PULSE-MULT-DEC).             
           EVALUATE WS-IDR-SUB                                          
           WHEN 1                                                       
               MOVE WS-UOM-LOW         TO GA-CHANNEL-A-UOM              
           WHEN 2                                                       
               MOVE WS-UOM-LOW         TO GA-CHANNEL-B-UOM              
           WHEN 3                                                       
               MOVE WS-UOM-LOW         TO GA-CHANNEL-C-UOM              
           END-EVALUATE.                                                
           MOVE WS-IDR-SUB             TO WS-KWH-CHANNEL.               
           MOVE WS-END-DATE TO WS-DATE-READ.                            
      ****************************************************************          
      *    A TIME OF 24:00:00 = 00:00:00 (12 AM) OF THE NEXT DAY.               
      ****************************************************************          
           IF WS-END-TIME = WS-TIME-24                                  
               PERFORM 8650-ADD-ONE-DAY          THRU 8650-EXIT         
           END-IF.                                                      
                                                                        
T17339     IF WS-OVERRIDE-IND = 'Y' OR WS-METER-CHANGE                  
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 2021-CHECK-MTRD-ENV       THRU 2021-EXIT         
               IF WS-INSERT-WORK-QUEUE EQUAL WS-YES                     
                   GO TO 2020-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 5000-UPDATE                   THRU 5000-EXIT.        
                                                                        
      *                                                                         
       2020-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    2021-CHECK-MTRD-ENV                                        *         
      *        COMPARE METER READ ENVIRONMENT WITH METER FROM INPUT   *         
      *        FILE.  CHECK LAST METER READ VALUE AND LAST METER      *         
      *        READ DATE.  ABEND IF METER WAS ALREADY READ FOR THE    *         
      *        CURRENT PERIOD.                                        *         
      *                                                               *         
      *****************************************************************         
       2021-CHECK-MTRD-ENV.                                             
      *                                                                         
           IF MN-LAST-REG-READ-DATE = WS-END-DATE                       
T17143        AND (MN-LAST-READ-VALUE = WS-END-READ OR WS-END-PLUS-1)   
               DISPLAY '2021-CHECK-MTRD-ENV ' WS-IDR-IDENT-NO           
               DISPLAY 'METER ON INPUT FILE ALREADY PROCESSED '         
               DISPLAY 'ACCOUNT NO=' WS-ACCOUNT-NO                      
               DISPLAY 'METER NO=' WS-METER-NO                          
T16904         DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '      
T16904         MOVE WS-YES TO WS-INSERT-WORK-QUEUE                      
T16904         MOVE 4                   TO WS-ROUTE-CATEGORY            
T16904         MOVE WS-IDR-CATEGORY-136 TO WS-IDR-CATEGORY              
T16904         MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR               
A03967         STRING ALREADY-PROCESSED WS-IDENT-NO-STRING              
T16904             DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT            
T16904         MOVE LENGTH OF WS-COMMENTS-TEXT                          
T16904                                 TO WS-COMMENTS-LEN               
T16904         GO TO 2021-EXIT                                          
           END-IF.                                                      
                                                                        
T17143     IF MN-LAST-READ-VALUE = WS-START-READ OR WS-START-PLUS-1     
               NEXT SENTENCE                                            
             ELSE                                                       
T15460         IF MN-DATE-MTR-INSTALL <= WS-END-DATE                    
                   DISPLAY '2021-CHECK-MTRD-ENV ' WS-IDR-IDENT-NO       
                   DISPLAY 'WARNING: '                                  
                           'LAST METER READ VALUE DOES NOT EQUAL START' 
                   DISPLAY 'METER READ VALUE FOR CURRENT PERIOD. '      
                   DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '  
                   DISPLAY ' '                                          
                 ELSE                                                   
                   DISPLAY '2021-CHECK-MTRD-ENV' WS-IDR-IDENT-NO        
                   DISPLAY 'METER EXCHANGE: NEW METER ' WS-METER-NO     
                   DISPLAY 'IDR NOT POSTED '                            
                   DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '  
                   MOVE WS-YES TO WS-INSERT-WORK-QUEUE                  
T15925             MOVE 4                   TO WS-ROUTE-CATEGORY        
T15925             MOVE WS-IDR-CATEGORY-136 TO WS-IDR-CATEGORY          
                   MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR           
                   STRING METER-CHANGE WS-IDENT-NO-STRING               
                       DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT        
                   MOVE LENGTH OF WS-COMMENTS-TEXT                      
                                           TO WS-COMMENTS-LEN           
                   GO TO 2021-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
T18464     MOVE MN-LAST-REG-READ-DATE TO WS-DATE-READ-SAVE.             
           IF MN-LAST-REG-READ-DATE EQUAL WS-START-DATE                 
               NEXT SENTENCE                                            
             ELSE                                                       
               DISPLAY '2021-CHECK-MTRD-ENVL ' WS-IDR-IDENT-NO          
               DISPLAY 'LAST METER READ DATE IS NOT DIRECTLY'           
               DISPLAY 'BEFORE CURRENT METER READ DATE '                
T18464         DISPLAY 'LAST READ DATE: ' WS-DATE-READ-SAVE             
T18464         DISPLAY 'LAST READ TIME: ' MN-LAST-REG-READ-TIME         
T18464         DISPLAY 'CURRENT READ DATE: ' WS-START-DATE              
               DISPLAY 'CURRENT READ TIME: ' WS-START-TIME              
               DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '      
               MOVE WS-YES TO WS-INSERT-WORK-QUEUE                      
T15925         MOVE 4                   TO WS-ROUTE-CATEGORY            
T15925         MOVE WS-IDR-CATEGORY-136 TO WS-IDR-CATEGORY              
               MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR               
               STRING INCORRECT-READ-DATE                               
                      WS-IDENT-NO-STRING                                
T18464                ' LAST READ DATE/TIME '                           
T18464                WS-DATE-READ-SAVE '/' MN-LAST-REG-READ-TIME       
T18464                ' CURRENT READ DATE/TIME '                        
T18464                WS-START-DATE '/' WS-START-TIME                   
                   DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT            
               MOVE LENGTH OF WS-COMMENTS-TEXT TO WS-COMMENTS-LEN       
               GO TO 2021-EXIT                                          
           END-IF.                                                      
      *                                                                         
       2021-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    2030-PROCESS-CHANNELS                                      *         
      *        PROCESS ALL CHANNELS OTHER THAN CHANNEL WITH KWH       *         
      *        UNIT OF MEASUREMENT.                                   *         
      *                                                               *         
      *****************************************************************         
       2030-PROCESS-CHANNELS.                                           
           PERFORM 2035-GET-CHANNEL-DATA         THRU 2035-EXIT.        
           COMPUTE WS-CONSTANT = (WS-PULSE-MULT-VAL /                   
                                  10 ** WS-PULSE-MULT-DEC).             
           EVALUATE WS-IDR-SUB                                          
           WHEN 1                                                       
               MOVE WS-UOM-LOW         TO GA-CHANNEL-A-UOM              
           WHEN 2                                                       
               MOVE WS-UOM-LOW         TO GA-CHANNEL-B-UOM              
           WHEN 3                                                       
               MOVE WS-UOM-LOW         TO GA-CHANNEL-C-UOM              
           END-EVALUATE.                                                
           EVALUATE WS-UOM                                              
           WHEN WS-KWH-CODE                                             
               MOVE 'B'                TO WS-CODE-USAGE-TYPE            
               MOVE 1                  TO MN-REG-ID-NO                  
           WHEN WS-KVH-CODE                                             
               MOVE 'S'                TO WS-CODE-USAGE-TYPE            
               MOVE 4                  TO MN-REG-ID-NO                  
           WHEN WS-KQH-CODE                                             
               MOVE 'Q'                TO WS-CODE-USAGE-TYPE            
               MOVE 5                  TO MN-REG-ID-NO                  
           WHEN OTHER                                                   
               DISPLAY '2030-PROCESS-CHANNELS ' WS-IDR-IDENT-NO         
               DISPLAY 'INVALID UNIT OF MEASUREMENT'                    
               DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '      
               MOVE WS-YES TO WS-INSERT-WORK-QUEUE                      
T15925         MOVE 4                   TO WS-ROUTE-CATEGORY            
T15925         MOVE WS-IDR-CATEGORY-136 TO WS-IDR-CATEGORY              
               MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR               
               STRING INCORRECT-UOM WS-IDENT-NO-STRING                  
                   DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT            
               MOVE LENGTH OF WS-COMMENTS-TEXT TO WS-COMMENTS-LEN       
               GO TO 2030-EXIT                                          
           END-EVALUATE.                                                
           MOVE WS-IDR-SUB         TO WS-CODE-USAGE-ID.                 
                                                                        
           PERFORM 5080-LOAD-RG-UNITS-TO-CX      THRU 5080-EXIT.        
T26776     MOVE AT-ACCOUNT-NO TO UR-ACCOUNT-NO-DEP.                     
T26776     MOVE BG-CODE-UTIL-TYPE TO UR-CODE-UTIL-TYPE-DEP.             
T26776     MOVE BG-IC-NO TO UR-IC-NO-DEP.                               
T26776     PERFORM 7801-OPEN-COINCIDENTALS THRU 7801-EXIT.              
T26776     MOVE 'Y' TO WS-MORE-COINCIDENTALS-SW.                        
C26776     PERFORM UNTIL WS-MORE-COINCIDENTALS-SW = 'N'                 
T26776        MOVE 'N'                     TO WS-COINCIDENTAL-FLAG      
T26776                                        WS-CON-CX-PROCESS         
T26776        PERFORM 7800-FETCH-COINCIDENTALS      THRU 7800-EXIT      
C26776        IF WS-COINCIDENTAL-FLAG = 'Y'                             
C26776           MOVE AT-ACCOUNT-NO        TO WS-ORIG-ACCOUNT-NO        
C26776           MOVE BG-BILL-NO           TO WS-ORIG-BILL-NO           
C26776           MOVE BG-IC-NO             TO WS-ORIG-IC-NO             
C26776           MOVE BG-BILL-ITEM-TIMESTMP                             
C26776                                     TO WS-ORIG-BILL-ITEM-TIMESTMP
C26776           MOVE UR-ACCOUNT-NO-MST    TO AT-ACCOUNT-NO             
C26776           MOVE UR-IC-NO-MST         TO BG-IC-NO                  
WINLOS           IF UR-CODE-RELATION-TYPE = 'W'                         
WINLOS             AND WS-OVERRIDE-IND = 'Y'                            
WINLOS               PERFORM 7855-SELECT-BG-TIMESTAMP THRU 7855-EXIT    
WINLOS           ELSE                                                   
C26776               PERFORM 7850-SELECT-BG-TIMESTAMP THRU 7850-EXIT    
WINLOS           END-IF                                                 
C26776           IF SQLCODE = SUCCESSFUL-CALL                           
T26776              IF WS-CON-BILL-ITEM-TIMESTMP > SPACES               
C26776                 MOVE BG-BILL-ITEM-TIMESTMP                       
C26776                                     TO WS-CON-BILL-ITEM-TIMESTMP2
T26776              ELSE                                                
T26776                 MOVE BG-BILL-ITEM-TIMESTMP                       
T26776                                     TO WS-CON-BILL-ITEM-TIMESTMP 
T26776              END-IF                                              
C26776              MOVE  'Y'              TO WS-CON-CX-PROCESS         
C26776             PERFORM 5080-LOAD-RG-UNITS-TO-CX THRU 5080-EXIT      
C26776           ELSE                                                   
C26776              CONTINUE                                            
C26776           END-IF                                                 
C26776           MOVE WS-ORIG-ACCOUNT-NO   TO AT-ACCOUNT-NO             
C26776           MOVE WS-ORIG-BILL-NO      TO BG-BILL-NO                
C26776           MOVE WS-ORIG-IC-NO        TO BG-IC-NO                  
C26776           MOVE WS-ORIG-BILL-ITEM-TIMESTMP                        
C26776                                     TO BG-BILL-ITEM-TIMESTMP     
T26776        END-IF                                                    
T26776     END-PERFORM.                                                 
T26776     PERFORM 7802-CLOSE-COINCIDENTALS         THRU 7802-EXIT.     
T26776     IF WS-COINCIDENTAL-ACCT-FLAG = 'Y'                           
T26776        MOVE 'N'                     TO WS-COINCIDENTAL-ACCT-FLAG 
T26776        MOVE 'Y'                     TO WS-COINCIDENTAL-FLAG      
T26776                                        WS-CON-CX-PROCESS         
T26776     END-IF.                                                      
       2030-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    2035-GET-CHANNEL-DATA                                      *         
      *         RETRIEVES THE DATA FOR AN INDIVIDUAL CHANNEL INDEXED  *         
      *         BY WS-IDR-SUB.                                        *         
      *                                                               *         
      *****************************************************************         
       2035-GET-CHANNEL-DATA.                                           
           MOVE E-FBW112-0000-START-READ(WS-IDR-SUB)                    
                                       TO WS-START-READ.                
           MOVE E-FBW112-0000-END-READ(WS-IDR-SUB)                      
                                       TO WS-END-READ.                  
           MOVE E-FBW112-0000-METER-MULT(WS-IDR-SUB)                    
                                       TO WS-METER-MULT.                
           MOVE E-FBW112-0001-PULSE-TOT(WS-IDR-SUB)                     
                                       TO WS-PULSE-CHECK(WS-IDR-SUB).   
ACT062     IF WS-COGEN-METER = 'Y'                                      
ACT062        COMPUTE WS-PULSE-CHECK(WS-IDR-SUB)                        
ACT062                =  WS-PULSE-CHECK(WS-IDR-SUB) * -1                
ACT062     END-IF.                                                      
           MOVE E-FBW112-0001-PULSE-MULT(WS-IDR-SUB)                    
                                       TO WS-PULSE-MULT.                
           MOVE E-FBW112-0001-UOM(WS-IDR-SUB)                           
                                       TO WS-UOM.                       
           MOVE E-FBW112-0002-PULSE-OFFSET(WS-IDR-SUB)                  
                                       TO WS-PULSE-OFFSET.              
TP9491     DIVIDE WS-START-READ BY 10  GIVING WS-START-READ ROUNDED.    
T17143     COMPUTE WS-START-PLUS-1 = WS-START-READ + 1.                 
TP9491     DIVIDE WS-END-READ   BY 10  GIVING WS-END-READ   ROUNDED.    
T17143     COMPUTE WS-END-PLUS-1   = WS-END-READ + 1.                   
       2035-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    2040-CHECK-ROLLOVER                                        *         
      *         CHECK FOR METER DIAL ROLLOVER USING NUMBER OF DIALS   *         
      *         ON MTR_CAP TABLE.                                     *         
      *                                                               *         
      *****************************************************************         
       2040-CHECK-ROLLOVER.                                             
           IF WS-CRNT-USE LESS ZERO                                     
               EVALUATE MC-NO-READ-DIALS                                
               WHEN 4                                                   
                  ADD        10000 TO WS-END-READ-COMP                  
               WHEN 5                                                   
                  ADD       100000 TO WS-END-READ-COMP                  
               WHEN 6                                                   
                  ADD      1000000 TO WS-END-READ-COMP                  
               WHEN 7                                                   
                  ADD     10000000 TO WS-END-READ-COMP                  
               WHEN 8                                                   
                  ADD    100000000 TO WS-END-READ-COMP                  
               WHEN 9                                                   
                  ADD   1000000000 TO WS-END-READ-COMP                  
               WHEN 10                                                  
                  ADD  10000000000 TO WS-END-READ-COMP                  
           END-IF.                                                      
       2040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-CHECK-HELD-RD-ROUTE.                                        
           MOVE ZERO TO WS-UT-COUNT                                     
                        WS-READS-POSTED.                                
TP5444     MOVE AT-ACCOUNT-NO TO UT-ACCOUNT-NO                          
           PERFORM 7500-OPEN-UTIL-ENVRNMT            THRU 7500-EXIT.    
           PERFORM 7501-FETCH-UTIL-ENVRNMT           THRU 7501-EXIT.    
           PERFORM 5400-CHECK-READ-CODES             THRU 5400-EXIT     
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
           PERFORM 7502-CLOSE-UTIL-ENVRNMT           THRU 7502-EXIT.    
           IF WS-UT-COUNT GREATER THAN ZERO                             
              IF WS-READS-POSTED EQUAL WS-UT-COUNT                      
                 IF AT-CODE-ACCT-BILLED EQUAL WS-H                      
PCR671              CONTINUE                                            
                 ELSE                                                   
                    MOVE 'R' TO AT-CODE-ACCT-BILLED                     
                    PERFORM 8890-UPDATE-ACCOUNT   THRU 8890-EXIT        
A03956              IF UR-CODE-RELATION-TYPE = 'C'                      
A03956                 PERFORM 2450-UPDATE-MICH-ACCT THRU 2450-EXIT     
A03956              END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF AT-CODE-ACCT-BILLED EQUAL 'H'                       
                    CONTINUE                                            
                 ELSE                                                   
                 IF AT-CODE-ACCT-BILLED EQUAL 'U'                       
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE SPACES TO AT-CODE-ACCT-BILLED                  
                    PERFORM 8890-UPDATE-ACCOUNT   THRU 8890-EXIT        
                 END-IF                                                 
              END-IF                                                    
           END-IF
           END-IF.                                                      
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *   IF ALL SUB ACCOUNTS OF MICHELIN MASTER ARE 'READY' TO BILL  *         
      *      THEN SET MASTER 'READY' TO BILL.                         *         
      *                                                               *         
      *****************************************************************         
A03956 2450-UPDATE-MICH-ACCT.                                           
A03956     MOVE 'R' TO WS-CODE-ACCT-BILLED.                             
A03956     PERFORM 7910-OPEN-SUBS-OF-MICH-MAST  THRU 7910-EXIT.         
A03956     PERFORM 7920-FETCH-SUBS-OF-MICH-MAST THRU 7920-EXIT.         
A03956     PERFORM UNTIL WS-NOMORE-ACCTS                                
A03956         IF AT-CODE-ACCT-BILLED = 'R'                             
A03956            CONTINUE                                              
A03956         ELSE                                                     
A03956            MOVE SPACE  TO WS-CODE-ACCT-BILLED                    
A03956         END-IF                                                   
A03956         PERFORM 7920-FETCH-SUBS-OF-MICH-MAST THRU 7920-EXIT      
A03956     END-PERFORM.                                                 
A03956     PERFORM 7930-CLOSE-SUBS-OF-MICH-MAST THRU 7930-EXIT.         
A03956                                                                  
A03956     IF WS-CODE-ACCT-BILLED = 'R'                                 
A03956        PERFORM 8891-UPDATE-MICH-ACCOUNT  THRU 8891-EXIT          
A03956     END-IF.                                                      
A03956                                                                  
A03956 2450-EXIT.                                                       
A03956      EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      *    3000-PROCESS-IDR-PULSES                                    *         
      *         CONTROLS PROCESSING OF EACH INDIVIDUAL PULSE FOR      *         
      *         CHANELS A-C.  INCREMENTS TIME AND DATE FOR EACH PULSE *         
      *                                                               *         
      *****************************************************************         
       3000-PROCESS-IDR-PULSES.                                         
           PERFORM 8600-ADD-ONE-INTERVAL         THRU 8600-EXIT.        
           IF WS-TIME-READ EQUAL WS-TIME-ZERO                           
ACT062        MOVE WS-TIME-24         TO WS-TIME-READ-RED               
ACT062        PERFORM 8650-ADD-ONE-DAY      THRU 8650-EXIT              
ACT062        MOVE WS-DATE-READ   TO IV-DATE-READ                       
ACT062     END-IF.                                                      
                                                                        
           IF WS-DST-TYPE EQUAL WS-F OR WS-S                            
              PERFORM 3002-PROCESS-DST          THRU 3002-EXIT
           END-IF.         
                                                                        
           MOVE WS-TIME-READ           TO IV-TIME-READ.                 
           PERFORM 3001-PROCESS-PULSE              THRU 3001-EXIT       
             VARYING WS-IDR-SUB      FROM 1 BY 1                        
             UNTIL WS-NO-MORE-INTERVALS EQUAL WS-YES                    
                OR WS-IDR-SUB GREATER WS-NO-OF-CHANNELS                 
                OR WS-INSERT-WORK-QUEUE EQUAL WS-YES.                   
           IF WS-INSERT-WORK-QUEUE EQUAL WS-YES                         
              GO TO 3000-EXIT                                           
           END-IF.                                                      
27775      MOVE WS-E TO IV-CODE-UTIL-TYPE.                              
           PERFORM 8810-INSERT-INTERVAL-READ       THRU 8810-EXIT.      
C26776     IF (WS-COINCIDENTAL-FLAG = 'Y') AND (WS-CON-CX-PROCESS = 'Y')
C26776        MOVE IV-BILL-ITEM-TIMESTMP                                
C26776                         TO WS-ORIG-IV-BILL-ITEM-TIMESTMP         
C26776        MOVE WS-CON-BILL-ITEM-TIMESTMP                            
C26776                         TO IV-BILL-ITEM-TIMESTMP                 
C26776        PERFORM 8810-INSERT-INTERVAL-READ       THRU 8810-EXIT    
A03956        IF WS-CON-BILL-ITEM-TIMESTMP2 NOT EQUAL                   
A03956                            WS-CON-BILL-ITEM-TIMESTMP             
T26776           MOVE WS-CON-BILL-ITEM-TIMESTMP2                        
T26776                         TO IV-BILL-ITEM-TIMESTMP                 
T26776           PERFORM 8810-INSERT-INTERVAL-READ    THRU 8810-EXIT    
A03956        END-IF                                                    
C26776        MOVE WS-ORIG-IV-BILL-ITEM-TIMESTMP                        
C26776                         TO IV-BILL-ITEM-TIMESTMP                 
C26776     END-IF                                                       
T19862     PERFORM 3020-CALCULATE-KW-KVA THRU 3020-EXIT.                
       3000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    3001-PROCESS-PULSE                                         *         
      *        STORES THE PULSE INFORMATION FOR THE INTERVAL READ     *         
      *        TABLE.                                                 *         
      *                                                               *         
      *****************************************************************         
       3001-PROCESS-PULSE.                                              
                                                                        
ACT062     IF WS-COGEN-METER  = 'Y'                                     
ACT062        COMPUTE  WS-PULSE = WS-PULSE * -1                         
ACT062     END-IF.                                                      
                                                                        
           ADD WS-PULSE                TO WS-PULSE-TOTAL(WS-IDR-SUB).   
           IF WS-PULSE = 9999                                           
              MOVE 0 TO WS-PULSE                                        
           END-IF.                                                      
           IF WS-IDR-SUB EQUAL WS-1                                     
              MOVE WS-PULSE           TO IV-CHANNEL-A-PULSES            
              MOVE WS-PULSE-STATUS    TO IV-CHANNEL-A-STATUS            
           ELSE                                                         
           IF WS-IDR-SUB EQUAL WS-2                                     
              MOVE WS-PULSE           TO IV-CHANNEL-B-PULSES            
              MOVE WS-PULSE-STATUS    TO IV-CHANNEL-B-STATUS            
           ELSE                                                         
           IF WS-IDR-SUB EQUAL WS-3                                     
              MOVE WS-PULSE           TO IV-CHANNEL-C-PULSES            
              MOVE WS-PULSE-STATUS    TO IV-CHANNEL-C-STATUS            
           END-IF
           END-IF
           END-IF.                                                      
           PERFORM 3010-GET-NEXT-PULSE           THRU 3010-EXIT.        
       3001-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    3002-PROCESS-DST                                           *         
      *         CONTROL SPRING AND FALL DAYLIGHT SAVINGS TIME CHANGES *         
      *         CHANGE DST CHANGE INDICATOR TO FALL WHEN ONE HOUR     *         
      *         IS REPEATED DURING INTERVAL READS.  ADD ONE HOUR TO   *         
      *         READ TIME IN SPRING.                                  *         
P00496*         INTERVALS TO BE MARKED 'F' FOR FALL DST TIME ADJUSTMNT*         
P00496*            '01.15.00' '01.30.00' '01.45.00' '02.00.00'        *         
      *                                                               *         
      *****************************************************************         
       3002-PROCESS-DST.                                                
           IF WS-DATE-READ EQUAL WS-DST-DATE                            
             AND (WS-TIME-READ EQUAL WS-DST-TIME                        
T16376            OR WS-TIME-READ EQUAL '02.15.00')                     
P00496        IF WS-DST-TYPE EQUAL 'F' AND WS-TIME-READ = '02.15.00'    
                 IF IV-DST-CHNG-IND EQUAL 'F'                           
                    MOVE 'N'            TO IV-DST-CHNG-IND              
                 ELSE                                                   
                    PERFORM 8550-SUBTRACT-ONE-HOUR THRU 8550-EXIT       
                    MOVE 'F'            TO IV-DST-CHNG-IND              
                 END-IF                                                 
              ELSE                                                      
T16376           IF WS-TIME-READ = '02.15.00' AND WS-DST-TYPE = 'S'     
                    PERFORM 8560-ADD-ONE-HOUR      THRU 8560-EXIT       
T16376           END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
       3002-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    3010-GET-NEXT-PULSE                                        *         
      *        RETREIVES THE NEXT PULSE FROM THE PULSE DATA RECORD.   *         
      *        IF AT END OF RECORD THEN ANOTHER PULSE DATA RECORD IS  *         
      *        READ FROM THE IDR FILE UNTIL ALL OF THE PULSES HAVE    *         
      *        BEEN READ.                                             *         
      *                                                               *         
      *****************************************************************         
       3010-GET-NEXT-PULSE.                                             
           IF WS-PULSE-SUB GREATER WS-MAX-PULSE-TABLE                   
               PERFORM 5005-READ-IDR-RECORD      THRU 5005-EXIT         
               IF EMPTY-FILE                                            
                   MOVE WS-YES             TO WS-NO-MORE-INTERVALS      
                   GO TO 3010-EXIT                                      
               END-IF                                                   
               MOVE E-FBW112-REC-BUFFER    TO E-FBW112-PULSE-RECORD     
               IF E-FBW112-PULSE-SORT-CODE NOT EQUAL WS-PULSE-SORT-CODE 
                   IF E-FBW112-PULSE-SORT-CODE EQUAL WS-9999 OR WS-0000 
                       IF E-FBW112-PULSE-SORT-CODE EQUAL WS-0000        
                           MOVE E-FBW112-REC-BUFFER                     
                                           TO E-FBW112-HEADER-0000      
                       END-IF                                           
                       MOVE WS-YES         TO WS-NO-MORE-INTERVALS      
                       GO TO 3010-EXIT                                  
                     ELSE                                               
                       DISPLAY '3010-GET-NEXT-PULSE ' WS-IDR-IDENT-NO   
                       DISPLAY 'PULSE RECORD SORT CODE OUT OF SEQUENCE' 
                       DISPLAY 'INSERTING WORK QUEUE CONTINUE '         
                               'PROCESSING'                             
                       MOVE WS-YES TO WS-INSERT-WORK-QUEUE              
                       MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR       
                       STRING INCORRECT-SORT WS-IDENT-NO-STRING         
                           DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT    
                       MOVE LENGTH OF WS-COMMENTS-TEXT                  
                                           TO WS-COMMENTS-LEN           
                       GO TO 3010-EXIT                                  
                   END-IF                                               
                 ELSE                                                   
                   MOVE 1                  TO WS-PULSE-SUB              
                   ADD 1                   TO WS-PULSE-SORT-CODE        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW112-PULSES(WS-PULSE-SUB)       TO WS-PULSE.        
           MOVE E-FBW112-PULSE-STATUS(WS-PULSE-SUB) TO WS-PULSE-STATUS. 
           ADD 1 TO WS-TOTAL-INTERVALS.                                 
           ADD 1 TO WS-PULSE-SUB.                                       
      *                                                                         
TP9934     IF WS-PULSE = 9999 AND WS-PULSE-STATUS = 9                   
T16776         SUBTRACT 1 FROM WS-TOTAL-INTERVALS                       
               MOVE WS-YES                 TO WS-NO-MORE-INTERVALS      
               PERFORM 5005-READ-IDR-RECORD      THRU 5005-EXIT         
               MOVE E-FBW112-REC-BUFFER    TO E-FBW112-HEADER-0000      
T18069         MOVE E-FBW112-REC-BUFFER    TO E-FBW112-PULSE-RECORD     
             ELSE                                                       
               IF WS-PULSE EQUAL WS-7777                                
                   DISPLAY '3010-GET-NEXT-PULSE ' WS-IDR-IDENT-NO       
                   DISPLAY INVALID-PULSE                                
                   DISPLAY 'INSERTING WORK QUEUE CONTINUE '             
                           'PROCESSING'                                 
                   MOVE WS-YES TO WS-INSERT-WORK-QUEUE                  
T15925             MOVE 4                   TO WS-ROUTE-CATEGORY        
T15925             MOVE WS-IDR-CATEGORY-136 TO WS-IDR-CATEGORY          
                   MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR           
                   STRING INVALID-PULSE WS-IDENT-NO-STRING              
                       DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT        
                   MOVE LENGTH OF WS-COMMENTS-TEXT                      
                                       TO WS-COMMENTS-LEN               
                   MOVE WS-YES             TO WS-FLG-SKIP-INTERVAL      
                   GO TO 3010-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       3010-EXIT.                                                       
           EXIT.                                                        
T19862*                                                                         
T19862******************************************************************        
T19862* CALCULATE PEAK KW/KVA                                         **        
T19862******************************************************************        
T19862 3020-CALCULATE-KW-KVA.                                           
T19862*                                                                         
T22675     MOVE ZEROS                  TO WS-KWH                        
T22675                                    WS-KQH                        
T22675                                    WS-KVAR                       
T22675                                    WS-KVARH                      
T22675                                    WS-KW                         
T22675                                    WS-KVA.                       
T22675*                                                                         
T19862     IF  GA-CHANNEL-A-UOM = '1'                                   
T19862         COMPUTE WS-KWH ROUNDED                                   
T19862               = WS-KWH-PULSE-MULT * IV-CHANNEL-A-PULSES          
T19862     END-IF.                                                      
T19862     COMPUTE WS-KW ROUNDED = WS-KWH / 0.25.                       
T19862*                                                                         
T19862     IF  GA-CHANNEL-B-UOM = '2'                                   
T19862         COMPUTE WS-KQH ROUNDED                                   
T19862              = WS-OTHR-PULSE-MULT * IV-CHANNEL-B-PULSES          
T19862     ELSE                                                         
T19862         IF  GA-CHANNEL-B-UOM = '3'                               
T19862             COMPUTE WS-KVARH ROUNDED                             
T19862                 = WS-OTHR-PULSE-MULT * IV-CHANNEL-B-PULSES       
T19862         END-IF                                                   
T19862     END-IF.                                                      
T19862*                                                                         
T19862     IF  GA-CHANNEL-C-UOM = '3'                                   
T19862         COMPUTE WS-KVARH ROUNDED                                 
T19862             = WS-OTHR-PULSE-MULT * IV-CHANNEL-C-PULSES           
T19862     END-IF.                                                      
T19862*                                                                         
T19862     IF  WS-KVARH > 0                                             
T19862         COMPUTE WS-KVAR ROUNDED = WS-KVARH / 0.25                
T19862     ELSE                                                         
T19862         IF  WS-KQH > 0                                           
T19862             COMPUTE WS-KVARH ROUNDED =                           
T19862               ( 2 * WS-KQH - WS-KWH ) / 1.732                    
T19862             COMPUTE WS-KVAR ROUNDED = WS-KVARH / 0.25            
T19862         END-IF                                                   
T19862     END-IF.                                                      
T19862*                                                                         
T19862     COMPUTE WS-KVA ROUNDED                                       
T19862             = ((WS-KVAR ** 2) + (WS-KW ** 2)) ** 0.5.            
T19862*                                                                         
T19862     IF  WS-KW > WS-PEAK-KW-1                                     
T19862         MOVE WS-KW                  TO WS-PEAK-KW-1              
T19862         MOVE WS-KVA                 TO WS-PEAK-KVA-1             
T22675         MOVE WS-KVAR                TO WS-PEAK-KVAR-1            
T19862         MOVE IV-DATE-READ           TO WS-PEAK-DATE-1            
T19862         MOVE IV-TIME-READ           TO WS-PEAK-TIME-1            
T19862     ELSE                                                         
T19862         IF  WS-KW = WS-PEAK-KW-1                                 
T19862                AND WS-KVA > WS-PEAK-KVA-1                        
T19862             MOVE WS-KVA             TO WS-PEAK-KVA-1             
T22675             MOVE WS-KVAR            TO WS-PEAK-KVAR-1            
T19862             MOVE IV-DATE-READ       TO WS-PEAK-DATE-1            
T19862             MOVE IV-TIME-READ       TO WS-PEAK-TIME-1            
T19862         END-IF                                                   
T19862     END-IF.                                                      
T19862*                                                                         
T19862     IF  WS-KVA > WS-PEAK-KVA-2                                   
T19862         MOVE WS-KVA                 TO WS-PEAK-KVA-2             
T19862         MOVE WS-KW                  TO WS-PEAK-KW-2              
T19862         MOVE WS-KVAR                TO WS-PEAK-KVAR-2            
T19862         MOVE IV-DATE-READ           TO WS-PEAK-DATE-2            
T19862         MOVE IV-TIME-READ           TO WS-PEAK-TIME-2            
T19862     ELSE                                                         
T19862         IF  WS-KVA = WS-PEAK-KVA-2                               
T19862                AND WS-KW > WS-PEAK-KW-2                          
T19862             MOVE WS-KW              TO WS-PEAK-KW-2              
T22214             MOVE WS-KVAR            TO WS-PEAK-KVAR-2            
T19862             MOVE IV-DATE-READ       TO WS-PEAK-DATE-2            
T19862             MOVE IV-TIME-READ       TO WS-PEAK-TIME-2            
T19862         END-IF                                                   
T19862     END-IF.                                                      
T19862*                                                                         
T19862 3020-EXIT.                                                       
T19862     EXIT.                                                        
T19862*                                                                         
T19862******************************************************************        
T19862* DETERMINE KW/KVA PEAKS                                        **        
T19862******************************************************************        
T19862 3030-DETERMINE-PEAKS.                                            
T19862*                                                                         
T22214     MOVE GA-ACCOUNT-NO              TO PH-ACCOUNT-NO.            
T22214     MOVE GA-BILL-NO                 TO PH-BILL-NO.               
T22214     MOVE WS-E                       TO PH-CODE-UTIL-TYPE         
T22214     MOVE GA-IC-NO                   TO PH-IC-NO.                 
T22214     MOVE GA-BILL-ITEM-TIMESTMP      TO PH-BILL-ITEM-TIMESTMP.    
T22214     MOVE GA-MTR-REF-NO              TO PH-MTR-REF-NO.            
T22214     MOVE GA-METER-NO                TO PH-METER-NO.              
T22214     MOVE SPACES                     TO WS-OLD-KW-MTR-NO          
T22214                                        WS-OLD-KVA-MTR-NO.        
T19862*                                                                         
T22214     PERFORM 3040-CHECK-FOR-PRIOR-PEAKS THRU 3040-EXIT.           
T22214*                                                                         
T22214     IF  WS-PEAK-DATE-1 EQUAL WS-PEAK-DATE-2                      
T22214          AND WS-PEAK-TIME-1 EQUAL WS-PEAK-TIME-2                 
T22214         MOVE WS-B                   TO PH-PEAK-TYPE              
T22214         IF  WS-OLD-KW-MTR-NO > SPACES AND LOW-VALUES             
T22214               AND WS-OLD-KVA-MTR-NO > SPACES AND LOW-VALUES      
T22214                AND WS-OLD-KVA-MTR-NO = WS-OLD-KW-MTR-NO          
T22214             MOVE WS-OLD-KW-MTR-NO   TO PH-METER-NO               
T19862         ELSE                                                     
T22214             MOVE GA-METER-NO        TO PH-METER-NO               
T19862         END-IF                                                   
T19862*                                                                         
T22214         MOVE WS-PEAK-DATE-1         TO PH-PEAK-DATE              
T22214         MOVE WS-PEAK-TIME-1         TO PH-PEAK-TIME              
ACT122         IF PH-PEAK-TIME = '24.00.00'                             
ACT122            MOVE '00.00.00' TO PH-PEAK-TIME                       
ACT122         END-IF                                                   
T22214         COMPUTE PH-PEAK-KW-UNITS ROUNDED = WS-PEAK-KW-1          
T22214         COMPUTE PH-PEAK-KVA-UNITS ROUNDED = WS-PEAK-KVA-2        
T22675         COMPUTE PH-PEAK-KVAR-UNITS ROUNDED = WS-PEAK-KVAR-1      
T22214         PERFORM 8865-INSERT-PH-RECORD THRU 8865-EXIT             
T19862*                                                                         
T19862     ELSE                                                         
T19862*                                                                         
T22214         MOVE WS-J                   TO PH-PEAK-TYPE              
T22214         IF  WS-OLD-KW-MTR-NO > SPACES AND LOW-VALUES             
T22214             MOVE WS-OLD-KW-MTR-NO   TO PH-METER-NO               
T19862         ELSE                                                     
T22214             MOVE GA-METER-NO        TO PH-METER-NO               
T19862         END-IF                                                   
T19862*                                                                         
T22214         MOVE WS-PEAK-DATE-1         TO PH-PEAK-DATE              
T22214         MOVE WS-PEAK-TIME-1         TO PH-PEAK-TIME              
ACT122         IF PH-PEAK-TIME = '24.00.00'                             
ACT122            MOVE '00.00.00' TO PH-PEAK-TIME                       
ACT122         END-IF                                                   
T22214         COMPUTE PH-PEAK-KW-UNITS ROUNDED = WS-PEAK-KW-1          
T22214         COMPUTE PH-PEAK-KVA-UNITS ROUNDED = WS-PEAK-KVA-1        
T22675         COMPUTE PH-PEAK-KVAR-UNITS ROUNDED = WS-PEAK-KVAR-1      
T22214         PERFORM 8865-INSERT-PH-RECORD THRU 8865-EXIT             
T22214*                                                                         
T22214         MOVE WS-E                   TO PH-PEAK-TYPE              
T22214         IF  WS-OLD-KVA-MTR-NO > SPACES AND LOW-VALUES            
T22214             MOVE WS-OLD-KVA-MTR-NO  TO PH-METER-NO               
T22214         ELSE                                                     
T22214             MOVE GA-METER-NO        TO PH-METER-NO               
T22214         END-IF                                                   
T19862*                                                                         
T22214         MOVE WS-PEAK-DATE-2         TO PH-PEAK-DATE              
T22214         MOVE WS-PEAK-TIME-2         TO PH-PEAK-TIME              
ACT122         IF PH-PEAK-TIME = '24.00.00'                             
ACT122            MOVE '00.00.00' TO PH-PEAK-TIME                       
ACT122         END-IF                                                   
T22214         COMPUTE PH-PEAK-KW-UNITS ROUNDED = WS-PEAK-KW-2          
T22214         COMPUTE PH-PEAK-KVA-UNITS ROUNDED = WS-PEAK-KVA-2        
T22214         COMPUTE PH-PEAK-KVAR-UNITS ROUNDED = WS-PEAK-KVAR-2      
T22214         PERFORM 8865-INSERT-PH-RECORD THRU 8865-EXIT             
T19862*                                                                         
T19862     END-IF.                                                      
T19862*                                                                         
T19862 3030-EXIT.                                                       
T19862     EXIT.                                                        
T19862*                                                                         
T19862******************************************************************        
T22214* CHECK FOR ANY PRIOR PEAKS EXISTING FOR THE SAME BILL-NO       **        
T19862******************************************************************        
T22214 3040-CHECK-FOR-PRIOR-PEAKS.                                      
T19862*                                                                         
T22214     PERFORM 7530-OPEN-GET-PH THRU 7530-EXIT.                     
T22214     PERFORM 7540-FETCH-GET-PH THRU 7540-EXIT.                    
T19862*                                                                         
T22214     PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
ACT122         IF PH-PEAK-TIME = '00.00.00'                             
ACT122            MOVE '24.00.00' TO PH-PEAK-TIME                       
ACT122         END-IF                                                   
T22214         IF  PH-PEAK-TYPE EQUAL WS-B                              
T22214             IF  PH-PEAK-KW-UNITS > WS-PEAK-KW-1                  
T22214                 MOVE PH-METER-NO            TO WS-OLD-KW-MTR-NO  
T22214                 MOVE PH-PEAK-DATE           TO WS-PEAK-DATE-1    
T22214                 MOVE PH-PEAK-TIME           TO WS-PEAK-TIME-1    
T22214                 MOVE PH-PEAK-KW-UNITS       TO WS-PEAK-KW-1      
T22214                 MOVE PH-PEAK-KVA-UNITS      TO WS-PEAK-KVA-1     
T22675                 MOVE PH-PEAK-KVAR-UNITS     TO WS-PEAK-KVAR-1    
T22214             END-IF                                               
T22214             IF  PH-PEAK-KVA-UNITS > WS-PEAK-KVA-2                
T22214                 MOVE PH-METER-NO            TO WS-OLD-KVA-MTR-NO 
T22214                 MOVE PH-PEAK-DATE           TO WS-PEAK-DATE-2    
T22214                 MOVE PH-PEAK-TIME           TO WS-PEAK-TIME-2    
T22214                 MOVE PH-PEAK-KW-UNITS       TO WS-PEAK-KW-2      
T22214                 MOVE PH-PEAK-KVA-UNITS      TO WS-PEAK-KVA-2     
T22214                 MOVE PH-PEAK-KVAR-UNITS     TO WS-PEAK-KVAR-2    
T22214             END-IF                                               
T22214             PERFORM 8870-DELETE-PH-RECORD THRU 8870-EXIT         
T22214         ELSE                                                     
T22214         IF  PH-PEAK-TYPE EQUAL WS-J                              
T22214             IF  PH-PEAK-KW-UNITS > WS-PEAK-KW-1                  
T22214                 MOVE PH-METER-NO            TO WS-OLD-KW-MTR-NO  
T22214                 MOVE PH-PEAK-DATE           TO WS-PEAK-DATE-1    
T22214                 MOVE PH-PEAK-TIME           TO WS-PEAK-TIME-1    
T22214                 MOVE PH-PEAK-KW-UNITS       TO WS-PEAK-KW-1      
T22214                 MOVE PH-PEAK-KVA-UNITS      TO WS-PEAK-KVA-1     
T22675                 MOVE PH-PEAK-KVAR-UNITS     TO WS-PEAK-KVAR-1    
T22214             END-IF                                               
T22214             PERFORM 8870-DELETE-PH-RECORD THRU 8870-EXIT         
T22214         ELSE                                                     
T22214             IF  PH-PEAK-KVA-UNITS > WS-PEAK-KVA-2                
T22214                 MOVE PH-METER-NO            TO WS-OLD-KVA-MTR-NO 
T22214                 MOVE PH-PEAK-DATE           TO WS-PEAK-DATE-2    
T22214                 MOVE PH-PEAK-TIME           TO WS-PEAK-TIME-2    
T22214                 MOVE PH-PEAK-KW-UNITS       TO WS-PEAK-KW-2      
T22214                 MOVE PH-PEAK-KVA-UNITS      TO WS-PEAK-KVA-2     
T22214                 MOVE PH-PEAK-KVAR-UNITS     TO WS-PEAK-KVAR-2    
T22214             END-IF                                               
T22214             PERFORM 8870-DELETE-PH-RECORD THRU 8870-EXIT         
T22214         END-IF                                                   
T22214         END-IF                                                   
T22214         PERFORM 7540-FETCH-GET-PH THRU 7540-EXIT                 
T22214     END-PERFORM.                                                 
T22214     PERFORM 7550-CLOSE-GET-PH THRU 7550-EXIT.                    
T22214*                                                                         
T19862 3040-EXIT.                                                       
T19862     EXIT.                                                        
T19862*                                                                         
      *****************************************************************         
      *                                                               *         
      *    3100-DETERMINE-CHANNELS                                    *         
      *        DETERMINE THE NUMBER OF CHANNELS OUTPUT TO THE         *         
      *        TRANSFER FILE (1-4) USING THE UNIT OF MEASUREMENT      *         
      *        FIELDS IN HEADER RECORD 0001.                          *         
      *                                                               *         
      *****************************************************************         
       3100-DETERMINE-CHANNELS.                                         
           PERFORM VARYING WS-IDR-SUB FROM 1 BY 1                       
             UNTIL E-FBW112-0001-UOM(WS-IDR-SUB) EQUAL ZERO             
           END-PERFORM.                                                 
           SUBTRACT 1 FROM WS-IDR-SUB GIVING WS-NO-OF-CHANNELS.         
       3100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    3200-CHECK-PULSE-RECORDS                                   *         
      *        CHECK THE TOTAL INTERVALS READ AND THE PULSE TOTALS    *         
      *        FOR EACH CHANNEL WITH THE TOTALS ON THE HEADER         *         
      *        RECORDS TO VERIFY DATA.                                *         
      *                                                               *         
      *****************************************************************         
       3200-CHECK-PULSE-RECORDS.                                        
      *                                                                         
           DIVIDE WS-TOTAL-INTERVALS BY WS-NO-OF-CHANNELS               
               GIVING WS-TOTAL-INTERVALS.                               
           IF WS-TOTAL-INTERVALS NOT EQUAL WS-TOTAL-INT-ON-HEADER       
               DISPLAY '3200-CHECK-PULSE-RECORDS ' WS-IDR-IDENT-NO      
               DISPLAY 'TOTAL INTERVALS READ FROM FILE'                 
               DISPLAY 'DOES NOT EQUAL TOTAL INTERVALS ON HEADER'       
               DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '      
               MOVE WS-YES TO WS-INSERT-WORK-QUEUE                      
T15925         MOVE 4                   TO WS-ROUTE-CATEGORY            
T15925         MOVE WS-IDR-CATEGORY-136 TO WS-IDR-CATEGORY              
               MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR               
               STRING INCORRECT-TOT-INT WS-IDENT-NO-STRING              
                   DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT            
               MOVE LENGTH OF WS-COMMENTS-TEXT                          
                                       TO WS-COMMENTS-LEN               
               GO TO 3200-EXIT
           END-IF.                                         
      *                                                                         
           PERFORM                                                      
               VARYING WS-IDR-SUB FROM 1 BY 1                           
               UNTIL WS-IDR-SUB GREATER WS-NO-OF-CHANNELS               
                 OR WS-PULSE-TOTAL(WS-IDR-SUB) NOT EQUAL                
                 WS-PULSE-CHECK(WS-IDR-SUB)                             
           END-PERFORM.                                                 
T5320      IF WS-IDR-SUB > WS-NO-OF-CHANNELS                            
T5320         CONTINUE                                                  
T5320      ELSE                                                         
           IF WS-PULSE-TOTAL(WS-IDR-SUB)                                
             NOT EQUAL WS-PULSE-CHECK(WS-IDR-SUB)                       
               DISPLAY '3200-CHECK-PULSE-RECORDS ' WS-IDR-IDENT-NO      
               DISPLAY 'WARNING: TOTAL PULSES FOR CHANNEL ' WS-IDR-SUB  
               DISPLAY 'DOES NOT EQUAL TOTAL PULSES ON HEADER'          
               DISPLAY ' '                                              
           END-IF
           END-IF.                                                      
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *****************************************************************         
      *                                                               *         
      *    5000-UPDATE.                                               *         
      *        UPDATE DB2 BILLING TABLES IF NEEDED                    *         
      *        UPDATE METER ENVIRONMENT                               *         
      *        PROCESS CANCEL REBILL IF NEEDED                        *         
      *                                                               *         
      *****************************************************************         
       5000-UPDATE.                                                     
           MOVE AT-ACCOUNT-NO          TO BI-ACCOUNT-NO.                
T17339     IF WS-OVERRIDE-IND = 'Y'                                     
              PERFORM 5002-PROCESS-REBILL       THRU 5002-EXIT          
           ELSE                                                         
              PERFORM 7211-OPEN-BILL-HOOK       THRU 7211-EXIT          
              PERFORM 7212-FETCH-BILL-HOOK      THRU 7212-EXIT          
              IF (WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND)                
                OR (WS-IND-DATE-BILLED NOT EQUAL WS-NEG-ONE)            
                PERFORM 5030-LOAD-DATA-TO-UNBILLED-BHH THRU 5030-EXIT   
              END-IF                                                    
              PERFORM 7214-CLOSE-BILL-HOOK      THRU 7214-EXIT          
              PERFORM 5050-VERIFY-BILL-DET      THRU 5050-EXIT          
           END-IF.                                                      
           IF WS-INSERT-WORK-QUEUE EQUAL WS-YES                         
              GO TO 5000-EXIT                                           
           END-IF.                                                      
           MOVE MN-REG-ID-NO           TO MC-REG-ID-NO.                 
           MOVE MN-CODE-UTIL-TYPE      TO MC-CODE-UTIL-TYPE.            
           MOVE MN-METER-NO            TO MC-METER-NO.                  
           PERFORM 7060-SELECT-METER-CAP-INFO    THRU 7060-EXIT.        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              DISPLAY '5000-UPDATE ' WS-IDR-IDENT-NO                    
              DISPLAY 'METER NOT FOUND IN METER_CAP TABLE'              
              DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '       
              MOVE WS-YES TO WS-INSERT-WORK-QUEUE                       
T15925        MOVE 4                  TO WS-ROUTE-CATEGORY              
T15925        MOVE WS-IDR-CATEGORY-16 TO WS-IDR-CATEGORY                
              MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR                
              STRING NO-MTR-CAP WS-IDENT-NO-STRING                      
                  DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT             
              MOVE LENGTH OF WS-COMMENTS-TEXT                           
                                      TO WS-COMMENTS-LEN                
              GO TO 5000-EXIT                                           
           END-IF.                                                      
           COMPUTE WS-CRNT-USE                                          
             = WS-END-READ - WS-START-READ.                             
           MOVE WS-END-READ TO WS-END-READ-COMP.                        
           PERFORM 2040-CHECK-ROLLOVER           THRU 2040-EXIT.        
           IF WS-CRNT-USE < ZERO                                        
              COMPUTE WS-CRNT-USE                                       
              = (WS-END-READ-COMP - WS-START-READ)                      
           END-IF.                                                      
           COMPUTE WS-NO-OF-UNITS                                       
             = WS-CRNT-USE * WS-METER-MULT.                             
T17339     IF WS-OVERRIDE-IND = 'Y' OR WS-METER-CHANGE                  
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 5010-PROCESS-MN           THRU 5010-EXIT          
           END-IF.                                                      
       5000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    5002-PROCESS-REBILL                                        *         
      *                                                               *         
      *****************************************************************         
       5002-PROCESS-REBILL.                                             
           MOVE AT-ACCOUNT-NO          TO BG-ACCOUNT-NO.                
           MOVE UT-CODE-UTIL-TYPE      TO BG-CODE-UTIL-TYPE.            
           MOVE UT-IC-NO               TO BG-IC-NO.                     
           MOVE WS-REVENUE-MONTH       TO BG-REVENUE-MONTH.             
           MOVE 'Y'                    TO BG-REBILL-IND.                
           PERFORM 7218-SELECT-REBILL-DETAIL     THRU 7218-EXIT.        
T11993     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               DISPLAY '5002-UPDATE ' WS-IDR-IDENT-NO                   
               DISPLAY 'BILL DETAIL FOR CANCEL REBILL NOT FOUND'        
               DISPLAY 'IN BILLING_DET TABLE'                           
               DISPLAY 'INSERTING WORK QUEUE CONTINUE PROCESSING '      
               MOVE WS-YES TO WS-INSERT-WORK-QUEUE                      
T15925         MOVE 4                  TO WS-ROUTE-CATEGORY             
T15925         MOVE WS-IDR-CATEGORY-16 TO WS-IDR-CATEGORY               
               MOVE WS-IDR-IDENT-NO    TO WS-IDENT-NO-STR               
               STRING NO-REBILL-DETAIL WS-IDENT-NO-STRING               
                   DELIMITED BY SIZE   INTO WS-COMMENTS-TEXT            
               MOVE LENGTH OF WS-COMMENTS-TEXT                          
                                       TO WS-COMMENTS-LEN               
               GO TO 5002-EXIT                                          
           END-IF.                                                      
       5002-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    5005-READ-IDR-RECORD                                       *         
      *        READS A RECORD FROM THE BINARY FILE INTO A BUFFER.     *         
      *                                                               *         
      *****************************************************************         
       5005-READ-IDR-RECORD.                                            
      *                                                                         
           MOVE '5005' TO ACTIVE-PARAGRAPH.                             
           READ FCSBW112                                                
               INTO E-FBW112-REC-BUFFER                                 
               AT END                                                   
                   SET EMPTY-FILE TO TRUE.                              
                                                                        
           IF FBW112-SUCCESSFUL OR EMPTY-FILE                           
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '5005-ERROR ON FCSBW112 READ.  STATUS IS '       
                        WS-FBW112-STATUS                                
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       5005-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    5006-READ-MV90-FOR-RESTART                                 *         
      *        READS A RECORD FROM THE IDR FILE INTO THE HEADER       *         
      *        LAYOUT.                                                *         
      *                                                               *         
      *****************************************************************         
       5006-READ-MV90-FOR-RESTART.                                      
      *                                                                         
           MOVE '5006' TO ACTIVE-PARAGRAPH.                             
           READ FCSBW112                                                
               INTO E-FBW112-HEADER-0000                                
               AT END                                                   
                   SET EMPTY-FILE TO TRUE.                              
                                                                        
           IF FBW112-SUCCESSFUL AND NOT EMPTY-FILE                      
T15909         CONTINUE                                                 
           ELSE                                                         
               DISPLAY '5006-ERROR ON FCSBW112 READ.  STATUS IS '       
                        WS-FBW112-STATUS                                
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       5006-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      *                                                             *           
      *    5010-PROCESS-MN                                          *           
      *                                                             *           
      ***************************************************************           
       5010-PROCESS-MN.                                                 
      *                                                                         
           MOVE '5010' TO ACTIVE-PARAGRAPH.                             
           MOVE WS-END-DATE            TO MN-LAST-REG-READ-DATE         
                                          MN-LAST-VALID-READ-DT.        
                                                                        
ACT186     IF WS-END-TIME = '24.00.00'                                  
ACT062        MOVE MN-LAST-REG-READ-DATE  TO WS-DATE-READ               
ACT062        PERFORM 8650-ADD-ONE-DAY  THRU 8650-EXIT                  
ACT062        MOVE WS-DATE-READ           TO MN-LAST-REG-READ-DATE      
ACT062                                       MN-LAST-VALID-READ-DT      
ACT186        MOVE '00.00.00'             TO MN-LAST-REG-READ-TIME      
ACT186                                       MN-LAST-VALID-READ-TM      
ACT186     ELSE                                                         
              MOVE WS-END-TIME            TO MN-LAST-REG-READ-TIME      
                                             MN-LAST-VALID-READ-TM      
ACT138     END-IF                                                       
                                                                        
           MOVE WS-END-READ            TO MN-LAST-READ-VALUE            
                                          MN-LAST-VAL-RD-VALUE.         
           MOVE 'J'                    TO MN-CODE-CRNT-REG-READ.        
           MOVE MN-CODE-CRNT-REG-READ  TO MN-CODE-LAST-REG-READ         
                                          MN-CODE-LAST-VALID-RD.        
           IF WS-UOM EQUAL WS-KVH-CODE                                  
               IF MN-CODE-METER-STATUS EQUAL WS-0                       
                   MOVE WS-1 TO MN-CODE-METER-STATUS                    
               ELSE                                                     
               IF MN-CODE-METER-STATUS EQUAL WS-1                       
                   MOVE WS-A TO MN-CODE-METER-STATUS
               END-IF
               END-IF
           END-IF.                   
           IF WS-UOM EQUAL WS-KQH-CODE                                  
               IF MN-CODE-METER-STATUS EQUAL WS-0                       
                   MOVE WS-1 TO MN-CODE-METER-STATUS                    
               ELSE                                                     
               IF MN-CODE-METER-STATUS EQUAL WS-1                       
                   MOVE WS-A TO MN-CODE-METER-STATUS
               END-IF
               END-IF
           END-IF.                   
T21338     MOVE ZERO TO MN-NO-CONSEC-ESTIMATE.                          
           PERFORM 8840-REPL-MTRD-ENVRNMT        THRU 8840-EXIT.        
      *                                                                         
       5010-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00265686
      *                                                                *00265786
      *   5030-LOAD-DATA-TO-UNBILLED-BHH                               *00265886
      *                                                                *00266086
      ******************************************************************00266186
       5030-LOAD-DATA-TO-UNBILLED-BHH.                                  
      *                                                                         
           MOVE '5030'                 TO ACTIVE-PARAGRAPH.             
           MOVE AT-ACCOUNT-NO          TO BI-ACCOUNT-NO.                
           MOVE AT-PREMISE-NO          TO BI-PREMISE-NO.                
           MOVE AT-CUSTOMER-NO         TO BI-CUSTOMER-NO.               
           MOVE AT-COMPANY-NO          TO BI-COMPANY-NO.                
           MOVE AT-NXT-BILL-NO         TO BI-BILL-NO.                   
           ADD +1                      TO AT-NXT-BILL-NO.               
           MOVE WS-NEG-ONE             TO WS-IND-DATE-BILLED.           
           MOVE WS-A                   TO BI-CODE-BILL-STATUS           
                                          BI-CODE-BILL-TYPE             
                                          BI-CODE-BILL-REASON.          
           PERFORM 8880-ISRT-BILL-HEADER         THRU 8880-EXIT.        
           PERFORM 8888-UPDATE-ACCOUNT           THRU 8888-EXIT.        
      *                                                                         
       5030-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    5050-VERIFY-BILL-DET                                       *         
      *        VERIFY THAT THE BILL DETAIL EXISTS IF NOT THEN         *         
      *        INSERT A NEW ONE.                                      *         
      *                                                               *         
      *****************************************************************         
       5050-VERIFY-BILL-DET.                                            
           MOVE '5050'                 TO ACTIVE-PARAGRAPH.             
           MOVE BI-ACCOUNT-NO          TO BG-ACCOUNT-NO.                
           MOVE BI-BILL-NO             TO BG-BILL-NO.                   
           MOVE UT-CODE-UTIL-TYPE      TO BG-CODE-UTIL-TYPE.            
           MOVE UT-IC-NO               TO BG-IC-NO.                     
           PERFORM 7209-OPEN-BILLING-DETAIL      THRU 7209-EXIT.        
           PERFORM 7210-FETCH-BILLING-DETAIL     THRU 7210-EXIT.        
           MOVE WS-NEG-ONE             TO WS-IND-DATE-ORIG-BILL.        
           MOVE AT-COMPANY-NO          TO BG-COMPANY-NO.                
           MOVE BI-PREMISE-NO          TO BG-PREMISE-NO.                
           MOVE WS-REVENUE-MONTH       TO BG-REVENUE-MONTH.             
           MOVE 'A'                    TO BG-CODE-BILL-CALC             
                                          BG-CODE-BILL-ITM-IND.         
           MOVE 'C'                    TO BG-CODE-BILL-ITM-TYPE.        
           MOVE 'D'                    TO BG-CODE-DR-CR-CNSMPTN.        
           MOVE UT-RATE-PLAN-NO        TO BG-RATE-PLAN-NO.              
           MOVE UT-CODE-REVENUE-CLASS  TO BG-CODE-REVENUE-CLASS.        
           MOVE UT-CODE-SIC-NO         TO BG-CODE-SIC-NO.               
           MOVE UT-CODE-CURTAIL-PRTY   TO BG-CODE-CURTAIL-PRTY.         
T27541     MOVE ZEROS                  TO BG-REV-MTH-ORIG-BILL.         
           MOVE ZEROES                 TO BG-AMT-BILL-ITEM              
                                          BG-AMT-STATE-TAX              
                                          BG-AMT-CITY-TAX               
                                          BG-AMT-OTHER-TAX.             
           PERFORM 7213-CLOSE-BILLING-DETAIL     THRU 7213-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 8864-REPL-BILLING-DETAIL  THRU 8864-EXIT         
           ELSE                                                         
               PERFORM 8862-ISRT-BILLING-DETAIL  THRU 8862-EXIT         
               PERFORM 7216-OPEN-ITEM-STAMP      THRU 7216-EXIT         
               PERFORM 7215-FETCH-ITEM-STAMP     THRU 7215-EXIT         
               PERFORM 7217-CLOSE-ITEM-STAMP     THRU 7217-EXIT         
           END-IF.                                                      
      *                                                                         
       5050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5060-SELECT-OLD-ACCOUNT.                                         
           MOVE AT-ACCOUNT-NO TO XR-OLD-ACCOUNT-NO.                     
           PERFORM 7052-SELECT-XREF-ACCOUNT      THRU 7052-EXIT         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE XR-NEW-ACCOUNT-NO TO AT-ACCOUNT-NO                   
              PERFORM 7050-SELECT-ACCOUNT-NO     THRU 7050-EXIT         
           END-IF.                                                      
      *                                                                         
       5060-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    5080-LOAD-RG-UNITS-TO-CX                                   *         
      *                                                               *         
      *****************************************************************         
       5080-LOAD-RG-UNITS-TO-CX.                                        
           MOVE '5080'                 TO ACTIVE-PARAGRAPH.             
           MOVE AT-ACCOUNT-NO          TO CX-ACCOUNT-NO.                
           MOVE BG-BILL-NO             TO CX-BILL-NO.                   
           MOVE BG-CODE-UTIL-TYPE      TO CX-CODE-UTIL-TYPE.            
           MOVE BG-IC-NO               TO CX-IC-NO.                     
           MOVE BG-BILL-ITEM-TIMESTMP  TO CX-BILL-ITEM-TIMESTMP.        
           MOVE 0                      TO CX-CODE-TIME-PERIOD.          
           MOVE MN-MTR-REF-NO          TO CX-MTR-REF-NO.                
           MOVE WS-CODE-USAGE-TYPE     TO CX-CODE-USAGE-TYPE.           
           MOVE WS-CODE-USAGE-ID       TO CX-CODE-USAGE-ID.             
WINLOS     IF UR-CODE-RELATION-TYPE = 'W'                               
WINLOS        AND WS-COINCIDENTAL-ACCT-FLAG = 'Y'                       
WINLOS           MOVE UR-CODE-RELATION-TYPE TO CX-CODE-USAGE-SOURCE     
WINLOS     ELSE                                                         
              MOVE MN-CODE-USAGE-SOURCE   TO CX-CODE-USAGE-SOURCE       
WINLOS     END-IF.                                                      
           MOVE 'J'                    TO CX-CODE-METER-READ.           
           MOVE 'M'                    TO CX-MTR-READ-SOURCE-CD.        
           MOVE MN-REG-ID-NO           TO CX-REG-ID-NO.                 
           MOVE MN-METER-NO            TO CX-METER-NO.                  
           MOVE AT-COMPANY-NO          TO CX-COMPANY-NO.                
           MOVE MN-CODE-METER-STATUS   TO CX-CODE-ITEM-STATUS.          
           MOVE MN-DIGTL-MTR-TYPE      TO CX-DIGTL-MTR-TYPE.            
           MOVE MN-CODE-DISCOUNT       TO CX-CODE-DISCOUNT.             
           MOVE MC-NO-READ-DIALS       TO CX-NO-DIALS                   
           MOVE 'M'                    TO CX-CODE-SOURCE-ID.            
T16423     IF WS-CONSTANT = 0                                           
T16423        MOVE 1 TO CX-CONSTANT                                     
T16423     ELSE                                                         
              MOVE WS-CONSTANT            TO CX-CONSTANT                
           END-IF.                                                      
           MOVE WS-END-DATE            TO CX-DATE-READ.                 
           MOVE WS-END-READ            TO CX-METER-READING.             
WINLOS     IF CX-CODE-USAGE-SOURCE = 'W'                                
               MOVE WS-C               TO CX-CODE-DEBIT-CREDIT          
           ELSE                                                         
               MOVE WS-D               TO CX-CODE-DEBIT-CREDIT          
           END-IF.                                                      
                                                                        
           IF WS-CODE-USAGE-TYPE = 'B'                                  
TP9087         MOVE E-FBW112-0001-PULSE-MULT(WS-IDR-SUB)                
TP9087                                          TO WS-PULSE-MULT        
TP9087         COMPUTE WS-CONSTANT-TEMP =                               
TP9087             ( WS-PULSE-MULT-VAL / 10 ** WS-PULSE-MULT-DEC)       
TP9087         COMPUTE WS-NO-OF-UNITS = WS-CONSTANT-TEMP *              
TP9087                        E-FBW112-0001-PULSE-TOT(WS-IDR-SUB)       
ACT062         IF WS-COGEN-METER  = 'Y'                                 
ACT062            COMPUTE WS-NO-OF-UNITS                                
ACT062                =  WS-NO-OF-UNITS * -1                            
ACT062         END-IF                                                   
TP9087         MOVE WS-NO-OF-UNITS     TO CX-NO-UNITS                   
TP9087         MOVE ZERO               TO WS-NO-OF-UNITS                
           ELSE                                                         
TP9087         MOVE 0                  TO WS-NO-OF-UNITS                
               MOVE 0                  TO CX-NO-UNITS                   
           END-IF.                                                      
                                                                        
           MOVE ZERO                   TO CX-DEMAND-READING.            
           MOVE ZERO                   TO CX-NO-DEMAND-UNITS.           
           PERFORM 5090-CALCULATE-NO-OF-DAYS     THRU 5090-EXIT.        
ACT138     IF WS-END-TIME = '24.00.00'                                  
              ADD 1 TO WS-NO-OF-DAYS GIVING CX-NO-DAYS                  
           ELSE                                                         
              MOVE WS-NO-OF-DAYS TO CX-NO-DAYS                          
T15558     END-IF.                                                      
           PERFORM 7221-SELECT-MAX-CNSMPTN-HIST  THRU 7221-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               MOVE +0001              TO CX-ITEM-SEQ-NO                
           ELSE                                                         
               ADD +0001               TO CX-ITEM-SEQ-NO
           END-IF.               
T19862*                                                                         
T19862     IF  CX-CODE-USAGE-ID = 1                                     
T19862         MOVE CX-CONSTANT        TO WS-KWH-PULSE-MULT             
T19862     ELSE                                                         
T19862         IF  CX-CODE-USAGE-ID = 2                                 
T19862             MOVE CX-CONSTANT    TO WS-OTHR-PULSE-MULT            
T19862         END-IF                                                   
T19862     END-IF.                                                      
T19862*                                                                         
           PERFORM 8863-ISRT-CONSUMPTION-HIST    THRU 8863-EXIT.        
      *                                                                         
       5080-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00265686
      *                                                                *00265786
      *   5090-CALCULATE-NO-OF-DAYS                                    *00265886
      *                                                                *00266086
      ******************************************************************00266186
       5090-CALCULATE-NO-OF-DAYS.                                       
           EXEC SQL                                                     
C35227        SELECT
              CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ) - CIS.DAYS( 
              IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ) )
            INTO
              :WS-NO-OF-DAYS            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-NO-OF-DAYS =                                              
MFA-TR*            DAYS(:WS-END-DATE) - DAYS(:WS-START-DATE)                    
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       5090-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00265686
      *                                                                *00265786
      *   5300-GOTO-NEXT-METER                                         *00265886
      *                                                                *00266086
      ******************************************************************00266186
       5300-GOTO-NEXT-METER.                                            
           PERFORM 5005-READ-IDR-RECORD      THRU 5005-EXIT.            
           MOVE E-FBW112-REC-BUFFER    TO E-FBW112-HEADER-0000.         
           IF E-FBW112-0000-SORT-CODE EQUAL WS-9999                     
               SET EMPTY-FILE TO TRUE
           END-IF.                                  
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    5314-CREATE-WORKQ                                          *         
      *        SET ROUTING CATEGORY FOR WORK QUEUE TO 1 IF THERE      *         
      *        IS AN ACCOUNT NUMBER ASSOCIATED WITH WQ.  OTHERWISE    *         
      *        SET ROUTING CATEGORY TO 4.                             *         
      *                                                               *         
      *****************************************************************         
       5314-CREATE-WORKQ.                                               
      *    IF AT-ACCOUNT-NO = 0                                                 
      *       MOVE 4                   TO WF-WQ-ROUTE-CATEGORY                  
      *    ELSE                                                                 
      *       MOVE 1                   TO WF-WQ-ROUTE-CATEGORY                  
      *    END-IF.                                                              
ACT059     INITIALIZE CWS00077-FIELDS.                                  
ACT059*                                                                         
ACT059     INITIALIZE WS-77-COMMENTS.                                   
ACT059*                                                                         
ACT059     MOVE WS-ROUTE-CATEGORY      TO WS-77-ROUTE-CATEGORY.         
ACT059     MOVE WS-IDR-CATEGORY        TO WS-77-CATEGORY-ID.            
ACT059     MOVE AT-ACCOUNT-NO          TO WS-77-ACCOUNT-NO.             
ACT059     MOVE AT-CUSTOMER-NO         TO WS-77-CUSTOMER-NO.            
ACT059     MOVE AT-PREMISE-NO          TO WS-77-PREMISE-NO.             
ACT059     MOVE AT-LOCAL-OFFICE        TO WS-77-LOCAL-OFFICE.           
ACT059     MOVE SPACES                 TO WS-77-RESP-AREA-ID.           
ACT059     MOVE ZEROS                  TO WS-77-SERV-ORDER-NO.          
ACT059     MOVE 'N'                    TO WS-77-PRIORITY.               
ACT059     MOVE WS-INPUT-DATE          TO WS-INPUT-DATE-PT              
ACT059                                    WS-77-DATE-REQUIRED.          
ACT059     MOVE WS-INPUT-TS            TO WS-77-DATE-CREATED.           
ACT059     MOVE WS-COMMENTS-TEXT       TO WS-77-COMMENTS-TEXT.          
ACT059     MOVE WS-COMMENTS-LEN        TO WS-77-COMMENTS-LEN.           
ACT059     MOVE ZEROS                  TO WS-77-FREE-FORM-LEN.          
ACT059     MOVE LOW-VALUES             TO WS-77-FREE-FORM-TXT.          
ACT059     MOVE PROGRAM-NAME           TO WS-77-CREATED-BY.             
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
           DISPLAY ' '.                                                 
      *                                                                         
       5314-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                                         
      *    5400-CHECK-READ-CODES                                                
      *                                                                         
      *****************************************************************         
       5400-CHECK-READ-CODES.                                           
           MOVE '5400' TO ACTIVE-PARAGRAPH.                             
           MOVE 'Y'               TO WS-METER-NOT-READ.                 
           MOVE ZERO              TO WS-MN-AWAITING-RD-COUNT.           
           MOVE UT-ACCOUNT-NO     TO MN-ACCOUNT-NO.                     
           MOVE UT-CODE-UTIL-TYPE TO MN-CODE-UTIL-TYPE.                 
           MOVE UT-IC-NO          TO MN-IC-NO.                          
           MOVE 'D'               TO MN-CODE-CRNT-REG-READ.             
           PERFORM 7505-SELECT-CNT-MTRD-ENVRNMT      THRU 7505-EXIT.    
           IF WS-MN-AWAITING-RD-COUNT > 0                               
               MOVE 'N' TO WS-METER-NOT-READ                            
           ELSE                                                         
               MOVE UT-ACCOUNT-NO     TO RG-ACCOUNT-NO                  
               MOVE UT-CODE-UTIL-TYPE TO RG-CODE-UTIL-TYPE              
               MOVE UT-IC-NO          TO RG-IC-NO                       
               MOVE 'D'               TO RG-CODE-CRNT-REG-READ          
               MOVE ZERO              TO WS-RG-AWAITING-RD-COUNT        
               PERFORM 7510-SELECT-CNT-REGISTER-READ THRU 7510-EXIT     
               IF WS-RG-AWAITING-RD-COUNT GREATER THAN ZERO             
                   MOVE WS-N TO WS-METER-NOT-READ                       
           END-IF
           END-IF.                                                      
           IF METER-NOT-READ-FOUND                                      
               NEXT SENTENCE                                            
           ELSE                                                         
               ADD 1 TO WS-READS-POSTED                                 
           END-IF.                                                      
           ADD 1 TO WS-UT-COUNT.                                        
           PERFORM 7501-FETCH-UTIL-ENVRNMT THRU 7501-EXIT.              
       5400-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                                         
      *   6235-GET-FJC01-RESTART-REQ.                                           
      *                                                                         
      *****************************************************************         
       COPY CPD00035.                                                           
      ******************************************************************        
      *                                                                         
      *   6251-GET-FJC01-DATE                                                   
      *                                                                         
      ******************************************************************        
       COPY CPD00037.                                                           
      ******************************************************************00265686
      *                                                                 00265786
      *   7000-COUNT-JOB-PARM                                           00265886
      *                                                                 00266086
      ******************************************************************00266186
       7000-COUNT-JOB-PARM.                                             
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-NO-OF-JOB-PARMS                                
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
                 AND STATUS       = :G6-STATUS                          
                 AND CMND_CODE    = 'PARM'                              
                 AND NOT PARM_DATA = 'RESTART-REQ=Y'                    
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-NO-OF-JOB-PARMS                                        
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                            
MFA-TR*          AND STATUS       = :G6-STATUS                                  
MFA-TR*          AND CMND_CODE    = 'PARM'                                      
MFA-TR*          AND NOT PARM_DATA = 'RESTART-REQ=Y'                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7000-SELECT RETURN CODE=' WS-ACTIVE-RETURN-CODE  
TP9251        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.         
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00265686
      *                                                                *00265786
      *   7010-SELECT-METER-NO                                         *00265886
      *                                                                *00266086
      ******************************************************************00266186
       7010-SELECT-METER-NO.                                            
           EXEC SQL                                                     
              SELECT METER_NO,                                          
                     ACCOUNT_NO                                         
                INTO :L7-METER-NO,                                      
                     :L7-ACCOUNT-NO                                     
                FROM CSS_IDR_ACCT_MTR WITH(READUNCOMMITTED)                     
               WHERE IDR_IDENT_NO = :L7-IDR-IDENT-NO                    
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_NO,                                                  
MFA-TR*              ACCOUNT_NO                                                 
MFA-TR*         INTO :L7-METER-NO,                                              
MFA-TR*              :L7-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_IDR_ACCT_MTR                                           
MFA-TR*        WHERE IDR_IDENT_NO = :L7-IDR-IDENT-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7010-SELECT RETURN CODE=' WS-ACTIVE-RETURN-CODE  
TP9251        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.         
       7010-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00265686
      *                                                                *00265786
      *   7050-SELECT-ACCOUNT-NO                                       *00265886
      *                                                                *00266086
      ******************************************************************00266186
       7050-SELECT-ACCOUNT-NO.                                          
           EXEC SQL                                                     
              SELECT CODE_ACCT_BILLED,                                  
                     COMPANY_NO,                                        
                     BILL_CYCLE,                                        
                     CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
                     LOCAL_OFFICE,                                      
                     NXT_BILL_NO,                                       
                     LAST_NRML_BILL_NO                                  
                INTO :AT-CODE-ACCT-BILLED,                              
                     :AT-COMPANY-NO,                                    
                     :AT-BILL-CYCLE,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-LOCAL-OFFICE,                                  
                     :AT-NXT-BILL-NO,                                   
                     :AT-LAST-NRML-BILL-NO                              
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_ACCT_BILLED,                                          
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              BILL_CYCLE,                                                
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              NXT_BILL_NO,                                               
MFA-TR*              LAST_NRML_BILL_NO                                          
MFA-TR*         INTO :AT-CODE-ACCT-BILLED,                                      
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-BILL-CYCLE,                                            
MFA-TR*              :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-LOCAL-OFFICE,                                          
MFA-TR*              :AT-NXT-BILL-NO,                                           
MFA-TR*              :AT-LAST-NRML-BILL-NO                                      
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7050-SELECT RETURN CODE =' WS-ACTIVE-RETURN-CODE 
TP9251        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
       7050-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00265686
      *                                                                *00265786
      *   7052-SELECT-XREF-ACCOUNT.                                    *00265886
      *                                                                *00266086
      ******************************************************************00266186
       7052-SELECT-XREF-ACCOUNT.                                        
PCR376     EXEC SQL                                                     
PCR376        SELECT XR.NEW_ACCOUNT_NO                                  
PCR376          INTO :XR-NEW-ACCOUNT-NO                                 
PCR376          FROM CSS_XREF_ACCT      XR WITH(READUNCOMMITTED),               
PCR376               CSS_ACCOUNT        AT WITH(READUNCOMMITTED),               
PCR376               CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                
PCR376          WHERE XR.OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO            
PCR376            AND XR.NEW_ACCOUNT_NO = AT.ACCOUNT_NO                 
PCR376            AND AT.ACCOUNT_NO     = CH.ACCOUNT_NO                 
PCR376            AND AT.PREMISE_NO     = CH.PREMISE_NO                 
PCR376            AND AT.CODE_ACCT_STAT <> 'S'                          
PCR376            AND CH.DATE_UTIL_SVC_STRT =                           
PCR376                (SELECT MAX(DATE_UTIL_SVC_STRT)                   
PCR376                   FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)          
PCR376                  WHERE PREMISE_NO = AT.PREMISE_NO)               
C35227                                                           
PCR376     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT XR.NEW_ACCOUNT_NO                                          
MFA-TR*         INTO :XR-NEW-ACCOUNT-NO                                         
MFA-TR*         FROM CSS_XREF_ACCT      XR,                                     
MFA-TR*              CSS_ACCOUNT        AT,                                     
MFA-TR*              CSS_CUST_PREM_HIST CH                                      
MFA-TR*         WHERE XR.OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO                    
MFA-TR*           AND XR.NEW_ACCOUNT_NO = AT.ACCOUNT_NO                         
MFA-TR*           AND AT.ACCOUNT_NO     = CH.ACCOUNT_NO                         
MFA-TR*           AND AT.PREMISE_NO     = CH.PREMISE_NO                         
MFA-TR*           AND AT.CODE_ACCT_STAT <> 'S'                                  
MFA-TR*           AND CH.DATE_UTIL_SVC_STRT =                                   
MFA-TR*               (SELECT MAX(DATE_UTIL_SVC_STRT)                           
MFA-TR*                  FROM CSS_CUST_PREM_HIST                                
MFA-TR*                 WHERE PREMISE_NO = AT.PREMISE_NO)                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7052-GET-XREF RETURN CODE ='                     
                      WS-ACTIVE-RETURN-CODE                             
TP9251        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       7052-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7060-SELECT-METER-CAP-INFO                                 *         
      *                                                               *         
      *****************************************************************         
       7060-SELECT-METER-CAP-INFO.                                      
           EXEC SQL                                                     
               SELECT K_Q_LEAD_LAG_IND,                                 
                      CONSTANT,                                         
                      NO_READ_DIALS                                     
                 INTO :MC-K-Q-LEAD-LAG-IND,                             
                      :MC-CONSTANT,                                     
                      :MC-NO-READ-DIALS                                 
                 FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                         
                WHERE CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE               
T22243            AND COMPANY_NO = :MC-COMPANY-NO                       
                  AND METER_NO = :MC-METER-NO                           
                  AND REG_ID_NO = :MC-REG-ID-NO                         
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT K_Q_LEAD_LAG_IND,                                         
MFA-TR*               CONSTANT,                                                 
MFA-TR*               NO_READ_DIALS                                             
MFA-TR*          INTO :MC-K-Q-LEAD-LAG-IND,                                     
MFA-TR*               :MC-CONSTANT,                                             
MFA-TR*               :MC-NO-READ-DIALS                                         
MFA-TR*          FROM CSS_MTR_CAP                                               
MFA-TR*         WHERE CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                       
MFA-TR*           AND COMPANY_NO = :MC-COMPANY-NO                               
MFA-TR*           AND METER_NO = :MC-METER-NO                                   
MFA-TR*           AND REG_ID_NO = :MC-REG-ID-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7060-SELECT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
T22243         DISPLAY  'COMPANY-NO            =' MC-COMPANY-NO         
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03247*****************************************************************         
A03247* ADD 25 MONTHS TO INPUT DATE                                   *         
A03247*****************************************************************         
A03247 7100-INPUT-DT-PLUS-25-MTHS.                                      
A03247                                                                  
A03247     EXEC SQL                                                     
A03247        SELECT
              DATEADD( MONTH, 25, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-INPUT-DT-PLUS-25MTHS             
A03247     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-INPUT-DT-PLUS-25MTHS  =                                   
MFA-TR*                    DATE(:WS-INPUT-DATE) + 25 MONTHS                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03247                                                                  
A03247     MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
A03247                                                                  
A03247     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03247        CONTINUE                                                  
A03247     ELSE                                                         
A03247        DISPLAY '********** PCSBW112 ABORT **************'        
A03247        DISPLAY '*  7100-INPUT-DT-PLUS-25-MTHS          *'        
A03247        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A03247        DISPLAY '*     PROCESSING TERMINATED            *'        
A03247        DISPLAY '********** PCSBW112 ABORT **************'        
A03247        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
A03247     END-IF.                                                      
A03247                                                                  
A03247 7100-EXIT.                                                       
A03247     EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *    7200-OPEN-JOB-PARM                                         *         
      *                                                               *         
      *****************************************************************         
       7200-OPEN-JOB-PARM.                                              
           EXEC SQL                                                     
               OPEN GET-JOB-PARM                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T15361     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
T15361     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7200-OPEN RETURN CODE =' SQLCODE                
TP9251         PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT
           END-IF.       
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7201-FETCH-JOB-PARM                                        *         
      *                                                               *         
      *****************************************************************         
       7201-FETCH-JOB-PARM.                                             
           EXEC SQL                                                     
               FETCH GET-JOB-PARM                                       
                INTO :G6-PARM-DATA,                                     
                     :G6-SEQ-NO                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7201-FETCH RETURN CODE =' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
      *                                                                         
       7201-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7202-CLOSE-JOB-PARM                                        *         
      *                                                               *         
      *****************************************************************         
       7202-CLOSE-JOB-PARM.                                             
           EXEC SQL                                                     
              CLOSE GET-JOB-PARM                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7202-CLOSE RETURN CODE =' SQLCODE               
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
      *                                                                         
       7202-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7290-OPEN-BILLING-DETAIL                                   *         
      *                                                               *         
      *****************************************************************         
       7209-OPEN-BILLING-DETAIL.                                        
           EXEC SQL                                                     
               OPEN GET-BILL-DETAIL                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7209-OPEN RETURN CODE =' SQLCODE                
TP9251         PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT
           END-IF.       
       7209-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7210-FETCH-BILLING-DETAIL                                  *         
      *                                                               *         
      *****************************************************************         
       7210-FETCH-BILLING-DETAIL.                                       
           EXEC SQL                                                     
               FETCH GET-BILL-DETAIL                                    
                INTO :BG-BILL-ITEM-TIMESTMP,                            
                     :BG-RATE-PLAN-NO, :BG-CODE-REVENUE-CLASS           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7210-FETCH RETURN CODE =' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7210-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *****************************************************************         
      *                                                               *         
      *    7211-OPEN-BILL-HOOK                                        *         
      *                                                               *         
      *****************************************************************         
       7211-OPEN-BILL-HOOK.                                             
           EXEC SQL                                                     
               OPEN GET-BILL-HOOK                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7211-OPEN RETURN CODE =' SQLCODE                
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7211-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7211-FETCH-BILL-HOOK                                       *         
      *                                                               *         
      *****************************************************************         
       7212-FETCH-BILL-HOOK.                                            
           EXEC SQL                                                     
               FETCH GET-BILL-HOOK                                      
                INTO :BI-PREMISE-NO, :BI-BILL-NO,                       
                     :BI-DATE-BILLED :WS-IND-DATE-BILLED                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7212-FETCH RETURN CODE =' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7212-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7213-CLOSE-BILLLING-DETAIL                                 *         
      *                                                               *         
      *****************************************************************         
       7213-CLOSE-BILLING-DETAIL.                                       
           EXEC SQL                                                     
              CLOSE GET-BILL-DETAIL                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7213-CLOSE RETURN CODE =' SQLCODE               
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7213-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7214-CLOSE-BILL-HOOK                                       *         
      *                                                               *         
      *****************************************************************         
       7214-CLOSE-BILL-HOOK.                                            
           EXEC SQL                                                     
              CLOSE GET-BILL-HOOK                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7214-CLOSE RETURN CODE =' SQLCODE               
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7214-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7215-FETCH-ITEM-STAMP                                      *         
      *                                                               *         
      *****************************************************************         
       7215-FETCH-ITEM-STAMP.                                           
           EXEC SQL                                                     
              FETCH  GET-ITEM-STAMP                                     
                INTO :BG-BILL-ITEM-TIMESTMP                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7215-FETCH RETURN CODE =' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7215-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7216-OPEN-ITEM-STAMP                                       *         
      *                                                               *         
      *****************************************************************         
       7216-OPEN-ITEM-STAMP.                                            
           EXEC SQL                                                     
               OPEN GET-ITEM-STAMP                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7216-OPEN RETURN CODE =' SQLCODE                
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7216-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7217-CLOSE-ITEM-STAMP                                      *         
      *                                                               *         
      *****************************************************************         
       7217-CLOSE-ITEM-STAMP.                                           
           EXEC SQL                                                     
               CLOSE GET-ITEM-STAMP                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7217-OPEN RETURN CODE =' SQLCODE                
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7217-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    7218-SELECT-REBILL-DETAIL                                  *         
      *                                                               *         
      *****************************************************************         
       7218-SELECT-REBILL-DETAIL.                                       
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           B.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                              
                     ,B.BILL_NO                                         
A03247               ,B.RATE_PLAN_NO                                    
                 INTO :BG-BILL-ITEM-TIMESTMP                            
                     ,:BG-BILL-NO                                       
A03247               ,:BG-RATE-PLAN-NO                                  
                 FROM CSS_BILLING_HDR A
                           WITH(READUNCOMMITTED), CSS_BILLING_DET B
                           WITH(READUNCOMMITTED)              
                WHERE A.ACCOUNT_NO     = :BG-ACCOUNT-NO                 
                  AND A.DATE_BILLED    IS NULL                          
                  AND A.BILL_NO        = B.BILL_NO                      
                  AND B.ACCOUNT_NO     = :BG-ACCOUNT-NO                 
                  AND B.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE             
                  AND B.IC_NO          = :BG-IC-NO                      
                  AND B.DATE_ORIG_BILL IS NOT NULL                      
                  AND B.REBILL_IND     = :BG-REBILL-IND                 
C35227            AND B.CODE_BILL_CALC = 'A'                            
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT B.BILL_ITEM_TIMESTMP                                      
MFA-TR*              ,B.BILL_NO                                                 
MFA-TR*              ,B.RATE_PLAN_NO                                            
MFA-TR*          INTO :BG-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:BG-BILL-NO                                               
MFA-TR*              ,:BG-RATE-PLAN-NO                                          
MFA-TR*          FROM CSS_BILLING_HDR A, CSS_BILLING_DET B                      
MFA-TR*         WHERE A.ACCOUNT_NO     = :BG-ACCOUNT-NO                         
MFA-TR*           AND A.DATE_BILLED    IS NULL                                  
MFA-TR*           AND A.BILL_NO        = B.BILL_NO                              
MFA-TR*           AND B.ACCOUNT_NO     = :BG-ACCOUNT-NO                         
MFA-TR*           AND B.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                     
MFA-TR*           AND B.IC_NO          = :BG-IC-NO                              
MFA-TR*           AND B.DATE_ORIG_BILL IS NOT NULL                              
MFA-TR*           AND B.REBILL_IND     = :BG-REBILL-IND                         
MFA-TR*           AND B.CODE_BILL_CALC = 'A'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7218 SELECT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7218-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7221-SELECT-MAX-CNSMPTN-HIST.                                    
           EXEC SQL                                                     
               SELECT MAX (ITEM_SEQ_NO)                                 
                 INTO :CX-ITEM-SEQ-NO :WS-IND-CX-ITEM-SEQ-NO             
                 FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :CX-ACCOUNT-NO                       
                  AND BILL_NO = :CX-BILL-NO                             
                  AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE               
                  AND IC_NO = :CX-IC-NO                                 
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
                  AND MTR_REF_NO = :CX-MTR-REF-NO                       
                  AND CODE_TIME_PERIOD = :CX-CODE-TIME-PERIOD           
                  AND REG_ID_NO = :CX-REG-ID-NO                         
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX (ITEM_SEQ_NO)                                         
MFA-TR*          INTO :CX-ITEM-SEQ-NO:WS-IND-CX-ITEM-SEQ-NO                     
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO = :CX-ACCOUNT-NO                               
MFA-TR*           AND BILL_NO = :CX-BILL-NO                                     
MFA-TR*           AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO = :CX-IC-NO                                         
MFA-TR*           AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*           AND MTR_REF_NO = :CX-MTR-REF-NO                               
MFA-TR*           AND CODE_TIME_PERIOD = :CX-CODE-TIME-PERIOD                   
MFA-TR*           AND REG_ID_NO = :CX-REG-ID-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-IND-CX-ITEM-SEQ-NO LESS THAN ZERO                      
               MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE
           END-IF.                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7221 SELECT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7221-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7311-SELECT-MTRD-ENVRNMT.                                        
           EXEC SQL                                                     
              SELECT CODE_USAGE_SOURCE, SPCL_MTR_CONDITION,             
                     METER_NO, IC_NO,                                   
                     MTR_REF_NO, CODE_USAGE_TYPE, CODE_USAGE_ID,        
                     CODE_USAGE_SOURCE,                                 
                     LAST_REG_READ_DATE, REPLACE(CONVERT(CHAR(8), 
           LAST_REG_READ_TIME, 108), ':', '.') LAST_REG_READ_TIME,            
                     CODE_METER_STATUS,                                 
                     LAST_VAL_RD_VALUE,                                 
                     CODE_LAST_VALID_RD,                                
                     LAST_READ_VALUE, CODE_UTIL_TYPE,                   
                     CODE_CRNT_REG_READ, CODE_NO_RD_REASON,             
                     CODE_LAST_REG_READ,                                
                     LAST_VALID_READ_DT,                                
                     REPLACE(CONVERT(CHAR(8), LAST_VALID_READ_TM, 108), 
           ':', '.') LAST_VALID_READ_TM,                                
                     CODE_LAST_VALID_RD,                                
                     REG_ID_NO,                                         
                     CODE_DISCOUNT,                                     
                     DATE_MTR_INSTALL,                                  
                     DIGTL_MTR_TYPE                                     
ACT062             , PROGRAM_ID                                         
                INTO :MN-CODE-USAGE-SOURCE, :MN-SPCL-MTR-CONDITION,     
                     :MN-METER-NO, :MN-IC-NO,                           
                     :MN-MTR-REF-NO, :MN-CODE-USAGE-TYPE,               
                     :MN-CODE-USAGE-ID,                                 
                     :MN-CODE-USAGE-SOURCE,                             
                     :MN-LAST-REG-READ-DATE, :MN-LAST-REG-READ-TIME,    
                     :MN-CODE-METER-STATUS,                             
                     :MN-LAST-VAL-RD-VALUE,                             
                     :MN-CODE-LAST-VALID-RD,                            
                     :MN-LAST-READ-VALUE, :MN-CODE-UTIL-TYPE,           
                     :MN-CODE-CRNT-REG-READ, :MN-CODE-NO-RD-REASON,     
                     :MN-CODE-LAST-REG-READ,                            
                     :MN-LAST-VALID-READ-DT,                            
                     :MN-LAST-VALID-READ-TM,                            
                     :MN-CODE-LAST-VALID-RD,                            
                     :MN-REG-ID-NO,                                     
                     :MN-CODE-DISCOUNT,                                 
                     :MN-DATE-MTR-INSTALL,                              
                     :MN-DIGTL-MTR-TYPE                                 
ACT062             , :MN-PROGRAM-ID                                     
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
                 AND METER_NO       = :MN-METER-NO                      
T24001           AND CODE_METER_STATUS IN ('A', 'B', 'I')               
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_USAGE_SOURCE, SPCL_MTR_CONDITION,                     
MFA-TR*              METER_NO, IC_NO,                                           
MFA-TR*              MTR_REF_NO, CODE_USAGE_TYPE, CODE_USAGE_ID,                
MFA-TR*              CODE_USAGE_SOURCE,                                         
MFA-TR*              LAST_REG_READ_DATE, LAST_REG_READ_TIME,                    
MFA-TR*              CODE_METER_STATUS,                                         
MFA-TR*              LAST_VAL_RD_VALUE,                                         
MFA-TR*              CODE_LAST_VALID_RD,                                        
MFA-TR*              LAST_READ_VALUE, CODE_UTIL_TYPE,                           
MFA-TR*              CODE_CRNT_REG_READ, CODE_NO_RD_REASON,                     
MFA-TR*              CODE_LAST_REG_READ,                                        
MFA-TR*              LAST_VALID_READ_DT,                                        
MFA-TR*              LAST_VALID_READ_TM,                                        
MFA-TR*              CODE_LAST_VALID_RD,                                        
MFA-TR*              REG_ID_NO,                                                 
MFA-TR*              CODE_DISCOUNT,                                             
MFA-TR*              DATE_MTR_INSTALL,                                          
MFA-TR*              DIGTL_MTR_TYPE                                             
MFA-TR*            , PROGRAM_ID                                                 
MFA-TR*         INTO :MN-CODE-USAGE-SOURCE, :MN-SPCL-MTR-CONDITION,             
MFA-TR*              :MN-METER-NO, :MN-IC-NO,                                   
MFA-TR*              :MN-MTR-REF-NO, :MN-CODE-USAGE-TYPE,                       
MFA-TR*              :MN-CODE-USAGE-ID,                                         
MFA-TR*              :MN-CODE-USAGE-SOURCE,                                     
MFA-TR*              :MN-LAST-REG-READ-DATE, :MN-LAST-REG-READ-TIME,            
MFA-TR*              :MN-CODE-METER-STATUS,                                     
MFA-TR*              :MN-LAST-VAL-RD-VALUE,                                     
MFA-TR*              :MN-CODE-LAST-VALID-RD,                                    
MFA-TR*              :MN-LAST-READ-VALUE, :MN-CODE-UTIL-TYPE,                   
MFA-TR*              :MN-CODE-CRNT-REG-READ, :MN-CODE-NO-RD-REASON,             
MFA-TR*              :MN-CODE-LAST-REG-READ,                                    
MFA-TR*              :MN-LAST-VALID-READ-DT,                                    
MFA-TR*              :MN-LAST-VALID-READ-TM,                                    
MFA-TR*              :MN-CODE-LAST-VALID-RD,                                    
MFA-TR*              :MN-REG-ID-NO,                                             
MFA-TR*              :MN-CODE-DISCOUNT,                                         
MFA-TR*              :MN-DATE-MTR-INSTALL,                                      
MFA-TR*              :MN-DIGTL-MTR-TYPE                                         
MFA-TR*            , :MN-PROGRAM-ID                                             
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*          AND METER_NO       = :MN-METER-NO                              
MFA-TR*          AND CODE_METER_STATUS IN ('A', 'B', 'I')                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7311 SELECT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
T23817         DISPLAY MN-ACCOUNT-NO   ' '                              
T23817                 MN-CODE-UTIL-TYPE ' '                            
T23817                 MN-METER-NO                                      
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7311-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T10811 7312-SELECT-OLD-METER.                                           
           EXEC SQL                                                     
              SELECT METER_READING,                                     
                     DATE_READ,                                         
                     IC_NO,                                             
                     MTR_REF_NO,                                        
                     REG_ID_NO,                                         
                     CODE_DISCOUNT,                                     
                     CODE_ITEM_STATUS                                   
                INTO :CX-METER-READING,                                 
                     :CX-DATE-READ,                                     
                     :CX-IC-NO,                                         
                     :CX-MTR-REF-NO,                                    
                     :CX-REG-ID-NO,                                     
                     :CX-CODE-DISCOUNT,                                 
                     :CX-CODE-ITEM-STATUS                               
                FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO        = :CX-ACCOUNT-NO                 
                 AND BILL_NO           = :CX-BILL-NO                    
                 AND CODE_UTIL_TYPE    = :CX-CODE-UTIL-TYPE             
                 AND METER_NO          = :CX-METER-NO                   
                 AND CODE_USAGE_TYPE   = :CX-CODE-USAGE-TYPE            
                 AND CODE_USAGE_ID     = :CX-CODE-USAGE-ID              
                 AND CODE_USAGE_SOURCE = :CX-CODE-USAGE-SOURCE          
                 AND CODE_TIME_PERIOD  = :CX-CODE-TIME-PERIOD           
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_READING,                                             
MFA-TR*              DATE_READ,                                                 
MFA-TR*              IC_NO,                                                     
MFA-TR*              MTR_REF_NO,                                                
MFA-TR*              REG_ID_NO,                                                 
MFA-TR*              CODE_DISCOUNT,                                             
MFA-TR*              CODE_ITEM_STATUS                                           
MFA-TR*         INTO :CX-METER-READING,                                         
MFA-TR*              :CX-DATE-READ,                                             
MFA-TR*              :CX-IC-NO,                                                 
MFA-TR*              :CX-MTR-REF-NO,                                            
MFA-TR*              :CX-REG-ID-NO,                                             
MFA-TR*              :CX-CODE-DISCOUNT,                                         
MFA-TR*              :CX-CODE-ITEM-STATUS                                       
MFA-TR*         FROM CSS_CNSMPTN_HIST                                           
MFA-TR*        WHERE ACCOUNT_NO        = :CX-ACCOUNT-NO                         
MFA-TR*          AND BILL_NO           = :CX-BILL-NO                            
MFA-TR*          AND CODE_UTIL_TYPE    = :CX-CODE-UTIL-TYPE                     
MFA-TR*          AND METER_NO          = :CX-METER-NO                           
MFA-TR*          AND CODE_USAGE_TYPE   = :CX-CODE-USAGE-TYPE                    
MFA-TR*          AND CODE_USAGE_ID     = :CX-CODE-USAGE-ID                      
MFA-TR*          AND CODE_USAGE_SOURCE = :CX-CODE-USAGE-SOURCE                  
MFA-TR*          AND CODE_TIME_PERIOD  = :CX-CODE-TIME-PERIOD                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7312-SELECT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
               DISPLAY 'ACCOUNT_NO ' CX-ACCOUNT-NO                      
               DISPLAY 'BILL_NO ' CX-BILL-NO                            
               DISPLAY 'CODE_UTIL_TYPE ' CX-CODE-UTIL-TYPE              
               DISPLAY 'METER_NO ' CX-METER-NO                          
               DISPLAY 'CODE_USAGE_TYPE ' CX-CODE-USAGE-TYPE            
               DISPLAY 'CODE_USAGE_SOURCE ' CX-CODE-USAGE-SOURCE        
               DISPLAY 'CODE_TIME_PERIOD ' CX-CODE-TIME-PERIOD          
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
T10811 7312-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7313-SELECT-UTIL-ENVRNMT.                                        
           EXEC SQL                                                     
               SELECT CODE_UTIL_TYPE, IC_NO,                            
                      CODE_REVENUE_CLASS, CODE_ESTIMATE_OK,             
                      RATE_PLAN_NO, CODE_SIC_NO,                        
                      CODE_MTR_READ_FREQ,                               
                      CODE_CURTAIL_PRTY,                                
T19383                CODE_STAT_TAX_XMT,                                
T19383                CODE_CITY_TAX_XMT,                                
T19383                CODE_OTHR_TAX_XMT,                                
                      READ_CYCLE                                        
                 INTO :UT-CODE-UTIL-TYPE, :UT-IC-NO,                    
                      :UT-CODE-REVENUE-CLASS, :UT-CODE-ESTIMATE-OK,     
                      :UT-RATE-PLAN-NO, :UT-CODE-SIC-NO,                
                      :UT-CODE-MTR-READ-FREQ,                           
                      :UT-CODE-CURTAIL-PRTY,                            
T19383                :UT-CODE-STAT-TAX-XMT,                            
T19383                :UT-CODE-CITY-TAX-XMT,                            
T19383                :UT-CODE-OTHR-TAX-XMT,                            
                      :UT-READ-CYCLE                                    
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                  AND IC_NO          = :UT-IC-NO                        
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_UTIL_TYPE, IC_NO,                                    
MFA-TR*               CODE_REVENUE_CLASS, CODE_ESTIMATE_OK,                     
MFA-TR*               RATE_PLAN_NO, CODE_SIC_NO,                                
MFA-TR*               CODE_MTR_READ_FREQ,                                       
MFA-TR*               CODE_CURTAIL_PRTY,                                        
MFA-TR*               CODE_STAT_TAX_XMT,                                        
MFA-TR*               CODE_CITY_TAX_XMT,                                        
MFA-TR*               CODE_OTHR_TAX_XMT,                                        
MFA-TR*               READ_CYCLE                                                
MFA-TR*          INTO :UT-CODE-UTIL-TYPE, :UT-IC-NO,                            
MFA-TR*               :UT-CODE-REVENUE-CLASS, :UT-CODE-ESTIMATE-OK,             
MFA-TR*               :UT-RATE-PLAN-NO, :UT-CODE-SIC-NO,                        
MFA-TR*               :UT-CODE-MTR-READ-FREQ,                                   
MFA-TR*               :UT-CODE-CURTAIL-PRTY,                                    
MFA-TR*               :UT-CODE-STAT-TAX-XMT,                                    
MFA-TR*               :UT-CODE-CITY-TAX-XMT,                                    
MFA-TR*               :UT-CODE-OTHR-TAX-XMT,                                    
MFA-TR*               :UT-READ-CYCLE                                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :UT-IC-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7313 SELECT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7313-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
T18349*     7315-SELECT-NEW-METER                                      *        
      *                                                                *        
      ******************************************************************        
T18349 7315-SELECT-NEW-METER.                                           
      *                                                                         
T18349     EXEC SQL                                                     
                SELECT  METER_NO,                                       
                        DATE_MTR_INSTALL                                
                INTO    :WS-NEW-METER-NO,                               
                        :WS-DATE-NEW-MTR-INSTALL                        
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO    = :MN-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
                 AND IC_NO          = :MN-IC-NO                         
                 AND MTR_REF_NO     = :MN-MTR-REF-NO                    
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  METER_NO,                                               
MFA-TR*                 DATE_MTR_INSTALL                                        
MFA-TR*         INTO    :WS-NEW-METER-NO,                                       
MFA-TR*                 :WS-DATE-NEW-MTR-INSTALL                                
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*         WHERE ACCOUNT_NO    = :MN-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO          = :MN-IC-NO                                 
MFA-TR*          AND MTR_REF_NO     = :MN-MTR-REF-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7315 SELECT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
       7315-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *     7500-OPEN-UTIL-ENVRNMT                                     *        
      *                                                                *        
      ******************************************************************        
       7500-OPEN-UTIL-ENVRNMT.                                          
           EXEC SQL                                                     
               OPEN UTIL_ENVRNMT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7500-OPEN RETURN CODE =' WS-ACTIVE-RETURN-CODE  
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       7500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *     7500-FETCH-UTIL-ENVRNMT                                    *        
      *                                                                *        
      ******************************************************************        
       7501-FETCH-UTIL-ENVRNMT.                                         
           MOVE '7501' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                FETCH UTIL_ENVRNMT                                      
                 INTO :UT-ACCOUNT-NO,                                   
                      :UT-CODE-UTIL-TYPE,                               
                      :UT-IC-NO,                                        
                      :UT-READ-CYCLE,                                   
                      :UT-READ-ROUTE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7501-FETCH RETURN CODE =' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       7501-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *     7500-CLOSE-UTIL-ENVRNMT                                    *        
      *                                                                *        
      ******************************************************************        
       7502-CLOSE-UTIL-ENVRNMT.                                         
           MOVE '7502' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               CLOSE UTIL_ENVRNMT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7502-CLOSE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       7502-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *     7505-SELECT-CNT-MTRD-ENVRNMT                               *        
      *                                                                *        
      ******************************************************************        
       7505-SELECT-CNT-MTRD-ENVRNMT.                                    
           MOVE '7505' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-MN-AWAITING-RD-COUNT                          
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO         = :MN-ACCOUNT-NO               
                  AND CODE_UTIL_TYPE     = :MN-CODE-UTIL-TYPE           
                  AND IC_NO              = :MN-IC-NO                    
                  AND CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ       
C35227            AND CODE_METER_STATUS  = 'A'                          
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-MN-AWAITING-RD-COUNT                                  
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO         = :MN-ACCOUNT-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :MN-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :MN-IC-NO                            
MFA-TR*           AND CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ               
MFA-TR*           AND CODE_METER_STATUS  = 'A'                                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7505-SELECT RETURN CODE =' WS-ACTIVE-RETURN-CODE
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       7505-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *     7510-SELECT-CNT-REGISTER-READ.                             *        
      *                                                                *        
      ******************************************************************        
       7510-SELECT-CNT-REGISTER-READ.                                   
           MOVE '7510' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-RG-AWAITING-RD-COUNT                          
                 FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO         = :RG-ACCOUNT-NO               
                  AND CODE_UTIL_TYPE     = :RG-CODE-UTIL-TYPE           
                  AND IC_NO              = :RG-IC-NO                    
                  AND CODE_CRNT_REG_READ = :RG-CODE-CRNT-REG-READ       
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-RG-AWAITING-RD-COUNT                                  
MFA-TR*          FROM CSS_REGISTER_READ                                         
MFA-TR*         WHERE ACCOUNT_NO         = :RG-ACCOUNT-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :RG-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :RG-IC-NO                            
MFA-TR*           AND CODE_CRNT_REG_READ = :RG-CODE-CRNT-REG-READ               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7510-SELECT RETURN CODE =' WS-ACTIVE-RETURN-CODE
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       7510-EXIT.                                                       
           EXIT.                                                        
T20288*                                                                 26380000
T20288******************************************************************        
T20288* MODULE TO GET THE CT/PT RATIOS FROM TABLES                     *26380000
T20288******************************************************************        
T20288 7520-GET-CT-PT-RATIO.                                            
T20288*                                                                 26380000
T20288     EXEC SQL                                                     
T20288         OPEN GET_RATIO                                           
T20288     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20288*                                                                 26420000
T20288     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T20288*                                                                 26440000
T20288     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T20288         NEXT SENTENCE                                            
T20288     ELSE                                                         
T20288         DISPLAY '7520-OPEN  RETURN CODE =' WS-ACTIVE-RETURN-CODE 
T22243         DISPLAY 'COMPANY-NO = ' IX-COMPANY-NO                    
T20288         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
T20288*                                                                 26590000
T20288     EXEC SQL                                                     
T20288       FETCH GET_RATIO                                            
T20288        INTO :IX-RTO-UPPER-FRACTION                               
T20288            ,:IX-RTO-LOWER-FRACTION                               
T20288            ,:IX-XFORMER-TYPE-CD                                  
T20288     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20288*                                                                 26710000
T20288     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE, WS-TEMP-RETURN-CD.    
T20288*                                                                 26730000
T20288     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T20288         NEXT SENTENCE                                            
T20288     ELSE                                                         
T20288         DISPLAY '7520-FETCH RETURN CODE =' WS-ACTIVE-RETURN-CODE 
T22243         DISPLAY 'COMPANY-NO =' IX-COMPANY-NO                     
T20288         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
T20288*                                                                 26930000
T20288     EXEC SQL                                                     
T20288         CLOSE GET_RATIO                                          
T20288     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20288*                                                                 26970000
T20288     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T20288*                                                                 26990000
T20288     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T20288         NEXT SENTENCE                                            
T20288     ELSE                                                         
T20288         DISPLAY '7520-CLOSE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
T20288         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
T20288*                                                                 27140000
T20288     MOVE WS-TEMP-RETURN-CD    TO WS-ACTIVE-RETURN-CODE.          
T20288*                                                                 27140000
T20288 7520-EXIT.                                                       
T20288     EXIT.                                                        
      *                                                                 27170000
      ******************************************************************        
T22214* OPEN GET_PH CURSOR                                             *26380000
T19862******************************************************************        
T22214 7530-OPEN-GET-PH.                                                
T19862*                                                                 26380000
T19862     EXEC SQL                                                     
T22214         OPEN GET_PH                                              
T19862     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19862*                                                                 26420000
T19862     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T19862*                                                                 26440000
T19862     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T19862         NEXT SENTENCE                                            
T19862     ELSE                                                         
T22214         DISPLAY '7530-OPEN  RETURN CODE =' WS-ACTIVE-RETURN-CODE 
T22214         DISPLAY 'ACCOUNT NO. = ' PH-ACCOUNT-NO                   
T22214         DISPLAY 'BILL NO. = ' PH-BILL-NO                         
T22214         DISPLAY 'CODE UTIL TYPE = ' PH-CODE-UTIL-TYPE            
T22214         DISPLAY 'IC NO. = ' PH-IC-NO                             
T22214         DISPLAY 'METER REF NO. = ' PH-MTR-REF-NO                 
T19862         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
T19862*                                                                 26590000
T19862 7530-EXIT.                                                       
T19862     EXIT.                                                        
      *                                                                 27170000
T22214******************************************************************        
T22214* FETCH GET_PH CURSOR                                           **        
T22214******************************************************************        
T22214 7540-FETCH-GET-PH.                                               
T22214*                                                                 26380000
T22214     EXEC SQL                                                     
T22214       FETCH GET_PH                                               
T22214        INTO :PH-PEAK-KW-UNITS                                    
T22214            ,:PH-PEAK-KVA-UNITS                                   
T22214            ,:PH-PEAK-KVAR-UNITS                                  
T22214            ,:PH-METER-NO                                         
T22214            ,:PH-PEAK-TIME                                        
T22214            ,:PH-PEAK-DATE                                        
T22214            ,:PH-PEAK-TYPE                                        
T22214     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22214*                                                                 26710000
T22214     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE, WS-TEMP-RETURN-CD.    
T22214*                                                                 26730000
T22214     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T22214         NEXT SENTENCE                                            
T22214     ELSE                                                         
T22214         DISPLAY '7540-FETCH RETURN CODE =' WS-ACTIVE-RETURN-CODE 
T22214         DISPLAY 'ACCOUNT NO. = ' PH-ACCOUNT-NO                   
T22214         DISPLAY 'BILL NO. = ' PH-BILL-NO                         
T22214         DISPLAY 'CODE UTIL TYPE = ' PH-CODE-UTIL-TYPE            
T22214         DISPLAY 'IC NO. = ' PH-IC-NO                             
T22214         DISPLAY 'METER REF NO. = ' PH-MTR-REF-NO                 
T22214         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
T22214*                                                                 26930000
T22214 7540-EXIT.                                                       
T22214     EXIT.                                                        
T22214*                                                                 26380000
T22214******************************************************************        
T22214* CLOSE GET_PH CURSOR                                           **        
T22214******************************************************************        
T22214 7550-CLOSE-GET-PH.                                               
T22214*                                                                 26380000
T22214     EXEC SQL                                                     
T22214         CLOSE GET_PH                                             
T19862     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19862*                                                                 26590000
T19862     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T19862*                                                                 26590000
T22214     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T22214         NEXT SENTENCE                                            
T19862     ELSE                                                         
T22214         DISPLAY '7550-CLOSE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
T22214         DISPLAY 'ACCOUNT NO. = ' PH-ACCOUNT-NO                   
T22214         DISPLAY 'BILL NO. = ' PH-BILL-NO                         
T22214         DISPLAY 'CODE UTIL TYPE = ' PH-CODE-UTIL-TYPE            
T22214         DISPLAY 'IC NO. = ' PH-IC-NO                             
T22214         DISPLAY 'METER REF NO. = ' PH-MTR-REF-NO                 
T22214         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
T19862*                                                                 26590000
T22214 7550-EXIT.                                                       
T19862     EXIT.                                                        
T19862*                                                                         
A03247*****************************************************************         
A03247** 7560-OPEN-HRLY-RATE-CURSOR.                                 **         
A03247*****************************************************************         
A03247 7560-OPEN-HRLY-RATE-CURSOR.                                      
A03247*                                                                 52132201
A03247     EXEC SQL                                                     
A03247         OPEN HRLY_RATE                                           
A03247     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03247                                                                  
A03247     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A03247                                                                  
A03247     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A03247        CONTINUE                                                  
A03247     ELSE                                                         
A03247        DISPLAY '********** PCSBW112 ABORT **************'        
A03247        DISPLAY '*  7560-OPEN-HRLY-RATE-CURSOR          *'        
A03247        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A03247        DISPLAY '*     PROCESSING TERMINATED            *'        
A03247        DISPLAY '********** PCSBW112 ABORT **************'        
A03247        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
A03247     END-IF.                                                      
A03247*                                                                 52136701
A03247 7560-EXIT.                                                       
A03247     EXIT.                                                        
A03247*                                                                         
A03247*****************************************************************         
A03247*  7570-FETCH-HRLY-RATE-CURSOR.                                 *         
A03247*****************************************************************         
A03247 7570-FETCH-HRLY-RATE-CURSOR.                                     

MSQ008     MOVE 20 TO MSQ008-HRLY-RATE
A03247*                                                                 52132201
A03247     EXEC SQL                                                     
A03247        FOR :MSQ008-HRLY-RATE
              FETCH 
              FROM HRLY_RATE               
A03247         INTO :ARR-RATE-PLAN-NO                                   
A03247     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*       FETCH NEXT ROWSET FROM HRLY_RATE FOR 20 ROWS                      
MFA-TR*        INTO :ARR-RATE-PLAN-NO                                           
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-HRLY-RATE
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03247                                                                  
A03247     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A03247                                                                  
A03247     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A03247        MOVE SQLERRD(3)             TO WS-RATE-PLAN-COUNT         
A03247     ELSE                                                         
A03247        DISPLAY '********** PCSBW112 ABORT **************'        
A03247        DISPLAY '*  7570-FETCH-HRLY-RATE-CURSOR         *'        
A03247        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A03247        DISPLAY '*     PROCESSING TERMINATED            *'        
A03247        DISPLAY '********** PCSBW112 ABORT **************'        
A03247        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
A03247     END-IF.                                                      
A03247*                                                                 52136701
A03247 7570-EXIT.                                                       
A03247     EXIT.                                                        
A03247*                                                                         
A03247*****************************************************************         
A03247** 7580-CLOSE-HRLY-RATE-CURSOR                                 **         
A03247*****************************************************************         
A03247 7580-CLOSE-HRLY-RATE-CURSOR.                                     
A03247*                                                                 52132201
A03247     EXEC SQL                                                     
A03247        CLOSE  HRLY_RATE                                          
A03247     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03247                                                                  
A03247     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A03247                                                                  
A03247     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A03247        CONTINUE                                                  
A03247     ELSE                                                         
A03247        DISPLAY '********** PCSBW112 ABORT **************'        
A03247        DISPLAY '*  7580-CLOSE-HRLY-RATE-CURSOR         *'        
A03247        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A03247        DISPLAY '*     PROCESSING TERMINATED            *'        
A03247        DISPLAY '********** PCSBW112 ABORT **************'        
A03247        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
A03247     END-IF.                                                      
A03247*                                                                 52136701
A03247 7580-EXIT.                                                       
A03247     EXIT.                                                        
A03247*                                                                         
      ******************************************************************        
      *                                                                *        
      *     7600-START-FCSJC01                                         *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
T26776                                                                  
T26776 7800-FETCH-COINCIDENTALS.                                        
T26776                                                                  
T26776     EXEC SQL                                                     
T26776         FETCH GET_COINCIDENTALS                                  
T26776          INTO :UR-ACCOUNT-NO-MST,                                
T26776               :UR-CODE-UTIL-TYPE-MST,                            
T26776               :UR-IC-NO-MST,                                     
WINLOS               :UR-CODE-RELATION-TYPE                             
T26776     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26776                                                                  
T26776     IF SQLCODE = SUCCESSFUL-CALL                                 
T26776        MOVE 'Y' TO WS-COINCIDENTAL-FLAG                          
T26776                    WS-COINCIDENTAL-ACCT-FLAG                     
T26776     ELSE                                                         
T26776       IF SQLCODE = NOT-FOUND                                     
T26776         MOVE 'N' TO WS-MORE-COINCIDENTALS-SW                     
T26776       ELSE                                                       
T26776         DISPLAY '7800-FETCH-COINCIDENTALS ' WS-ACTIVE-RETURN-CODE
T26776         DISPLAY 'ACCOUNT NO. = ' UR-ACCOUNT-NO-DEP               
T26776         DISPLAY 'CODE UTIL TYPE = ' UR-CODE-UTIL-TYPE-DEP        
T26776         DISPLAY 'IC NO. = ' UR-IC-NO-DEP                         
T26776         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
T26776        END-IF                                                    
T26776     END-IF.                                                      
T26776                                                                  
T26776 7800-EXIT.                                                       
T26776     EXIT.                                                        
T26776                                                                  
T26776******************************************************************        
T26776* OPEN GET_COINCIDENTALS CURSOR                                  *26380000
T26776******************************************************************        
T26776 7801-OPEN-COINCIDENTALS.                                         
T26776                                                                  
T26776     EXEC SQL                                                     
T26776         OPEN GET_COINCIDENTALS                                   
T26776     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26776                                                                  
T26776     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T26776                                                                  
T26776     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T26776         NEXT SENTENCE                                            
T26776     ELSE                                                         
T26776         DISPLAY '7801-OPEN  RETURN CODE =' WS-ACTIVE-RETURN-CODE 
T26776         DISPLAY 'ACCOUNT NO. = ' UR-ACCOUNT-NO-DEP               
T26776         DISPLAY 'CODE UTIL TYPE = ' UR-CODE-UTIL-TYPE-DEP        
T26776         DISPLAY 'IC NO. = ' UR-IC-NO-DEP                         
T26776         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
T26776                                                                  
T26776 7801-EXIT.                                                       
T26776     EXIT.                                                        
T26776                                                                  
T26776******************************************************************        
T26776* CLOSE GET_COINCIDENTALS CURSOR                                **        
T26776******************************************************************        
T26776                                                                  
T26776 7802-CLOSE-COINCIDENTALS.                                        
T26776                                                                  
T26776     EXEC SQL                                                     
T26776         CLOSE GET_COINCIDENTALS                                  
T26776     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26776                                                                  
T26776     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T26776                                                                  
T26776     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T26776         NEXT SENTENCE                                            
T26776     ELSE                                                         
T26776         DISPLAY '7802-CLOSE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
T26776         DISPLAY 'ACCOUNT NO. = ' UR-ACCOUNT-NO-DEP               
T26776         DISPLAY 'CODE UTIL TYPE = ' UR-CODE-UTIL-TYPE-DEP        
T26776         DISPLAY 'IC NO. = ' UR-IC-NO-DEP                         
T26776         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
T26776                                                                  
T26776 7802-EXIT.                                                       
T26776     EXIT.                                                        
T26776                                                                  
C26776 7850-SELECT-BG-TIMESTAMP.                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                             
                     BG.BILL_NO                                         
                INTO :BG-BILL-ITEM-TIMESTMP,                            
                     :BG-BILL-NO                                        
               FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED),                   
                    CSS_BILLING_HDR BZ WITH(READUNCOMMITTED)                    
               WHERE BG.ACCOUNT_NO         = :AT-ACCOUNT-NO             
                 AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE         
                 AND BG.IC_NO              = :BG-IC-NO                  
                 AND BG.DATE_ORIG_BILL IS NULL                          
                 AND BG.CODE_BILL_CALC     = 'A'                        
                 AND BG.CODE_BILL_ITM_TYPE = 'C'                        
                 AND BG.CODE_BILL_ITM_IND = 'A'                         
                 AND BG.REVENUE_MONTH  = 0                              
T26776           AND BG.REV_MTH_ORIG_BILL = 0                           
                 AND BZ.ACCOUNT_NO         = BG.ACCOUNT_NO              
                 AND BZ.BILL_NO            = BG.BILL_NO                 
                 AND BZ.DATE_BILLED   IS NULL                           
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     59260000
MFA-TR*       SELECT BG.BILL_ITEM_TIMESTMP,                             59270000
MFA-TR*              BG.BILL_NO                                                 
MFA-TR*         INTO :BG-BILL-ITEM-TIMESTMP,                            59280000
MFA-TR*              :BG-BILL-NO                                                
MFA-TR*        FROM CSS_BILLING_DET BG,                                         
MFA-TR*             CSS_BILLING_HDR BZ                                          
MFA-TR*        WHERE BG.ACCOUNT_NO         = :AT-ACCOUNT-NO                     
MFA-TR*          AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                 
MFA-TR*          AND BG.IC_NO              = :BG-IC-NO                          
MFA-TR*          AND BG.DATE_ORIG_BILL IS NULL                                  
MFA-TR*          AND BG.CODE_BILL_CALC     = 'A'                                
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*          AND BG.CODE_BILL_ITM_IND = 'A'                                 
MFA-TR*          AND BG.REVENUE_MONTH  = 0                                      
MFA-TR*          AND BG.REV_MTH_ORIG_BILL = 0                                   
MFA-TR*          AND BZ.ACCOUNT_NO         = BG.ACCOUNT_NO                      
MFA-TR*          AND BZ.BILL_NO            = BG.BILL_NO                         
MFA-TR*          AND BZ.DATE_BILLED   IS NULL                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    59300000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL  OR NOT-FOUND  OR  WS-811       
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '7850-SELECT-BG-TIMESTAMP' WS-ACTIVE-RETURN-CODE 
               DISPLAY 'ACCOUNT NO. = ' BG-ACCOUNT-NO                   
               DISPLAY 'CODE UTIL TYPE = ' BG-CODE-UTIL-TYPE            
               DISPLAY 'IC NO. = ' BG-IC-NO                             
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7850-EXIT.                                                       
C26776     EXIT.                                                        
WINLOS                                                                  
WINLOS 7855-SELECT-BG-TIMESTAMP.                                        
WINLOS     EXEC SQL                                                     
WINLOS        SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                             
WINLOS               BG.BILL_NO                                         
WINLOS          INTO :BG-BILL-ITEM-TIMESTMP,                            
WINLOS               :BG-BILL-NO                                        
WINLOS         FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED),                   
WINLOS              CSS_BILLING_HDR BZ WITH(READUNCOMMITTED)                    
WINLOS         WHERE BG.ACCOUNT_NO         = :AT-ACCOUNT-NO             
WINLOS           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE         
WINLOS           AND BG.IC_NO              = :BG-IC-NO                  
WINLOS           AND BG.DATE_ORIG_BILL IS NOT NULL                      
WINLOS           AND BG.CODE_BILL_CALC     = 'A'                        
WINLOS           AND BG.CODE_BILL_ITM_TYPE = 'C'                        
WINLOS           AND BG.CODE_BILL_ITM_IND = 'A'                         
WINLOS           AND BG.REVENUE_MONTH  = 0                              
WINLOS           AND BG.REV_MTH_ORIG_BILL IS NOT NULL                   
WINLOS           AND BZ.ACCOUNT_NO         = BG.ACCOUNT_NO              
WINLOS           AND BZ.BILL_NO            = BG.BILL_NO                 
WINLOS           AND BZ.DATE_BILLED   IS NULL                           
WINLOS                                                           
WINLOS     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     59260000
MFA-TR*       SELECT BG.BILL_ITEM_TIMESTMP,                             59270000
MFA-TR*              BG.BILL_NO                                                 
MFA-TR*         INTO :BG-BILL-ITEM-TIMESTMP,                            59280000
MFA-TR*              :BG-BILL-NO                                                
MFA-TR*        FROM CSS_BILLING_DET BG,                                         
MFA-TR*             CSS_BILLING_HDR BZ                                          
MFA-TR*        WHERE BG.ACCOUNT_NO         = :AT-ACCOUNT-NO                     
MFA-TR*          AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                 
MFA-TR*          AND BG.IC_NO              = :BG-IC-NO                          
MFA-TR*          AND BG.DATE_ORIG_BILL IS NOT NULL                              
MFA-TR*          AND BG.CODE_BILL_CALC     = 'A'                                
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*          AND BG.CODE_BILL_ITM_IND = 'A'                                 
MFA-TR*          AND BG.REVENUE_MONTH  = 0                                      
MFA-TR*          AND BG.REV_MTH_ORIG_BILL IS NOT NULL                           
MFA-TR*          AND BZ.ACCOUNT_NO         = BG.ACCOUNT_NO                      
MFA-TR*          AND BZ.BILL_NO            = BG.BILL_NO                         
MFA-TR*          AND BZ.DATE_BILLED   IS NULL                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    59300000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

WINLOS     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
WINLOS     IF SQLCODE = SUCCESSFUL-CALL                                 
WINLOS        CONTINUE                                                  
WINLOS     ELSE                                                         
WINLOS         DISPLAY '7855-SELECT-BG-TIMESTAMP' WS-ACTIVE-RETURN-CODE 
WINLOS         DISPLAY 'ACCOUNT NO. = ' BG-ACCOUNT-NO                   
WINLOS         DISPLAY 'CODE UTIL TYPE = ' BG-CODE-UTIL-TYPE            
WINLOS         DISPLAY 'IC NO. = ' BG-IC-NO                             
WINLOS         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
WINLOS     END-IF.                                                      
WINLOS                                                                  
WINLOS 7855-EXIT.                                                       
WINLOS     EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *     7900-SELECT-RESTART                                        *        
      *                                                                *        
      ******************************************************************        
       7900-SELECT-RESTART.                                             
           EXEC SQL                                                     
                SELECT  RESTART_DATA INTO :RF-RESTART-DATA              
                FROM  CSS_RESTART                                       
                WHERE   NAME_PROGRAM  = :RF-NAME-PROGRAM AND            
                        PARTITION_NO  = :RF-PARTITION-NO AND            
                        DUP_CNTRL_NO  = :RF-DUP-CNTRL-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               OR NOT-FOUND                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7900-SELECT-RESTART'                            
                       ' RETURN CODE=' WS-ACTIVE-RETURN-CODE            
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       7900-EXIT.                                                       
            EXIT.                                                       
HPCCDM*EJECT                                                                    
      *                                                                         
A03956******************************************************************        
A03956* OPEN SUBS_OF_MICH_MAST                                         *26380000
A03956******************************************************************        
A03956 7910-OPEN-SUBS-OF-MICH-MAST.                                     
A03956                                                                  
A03956     EXEC SQL                                                     
A03956         OPEN SUBS_OF_MICH_MAST                                   
A03956     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03956                                                                  
A03956     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03956                                                                  
A03956     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A03956         CONTINUE                                                 
A03956     ELSE                                                         
A03956         DISPLAY '7910-OPEN-SUBS-OF-MICH-MAST'                    
A03956         DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
A03956         DISPLAY 'ACCOUNT NO. = ' UR-ACCOUNT-NO-MST               
A03956         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
A03956     END-IF.                                                      
A03956                                                                  
A03956 7910-EXIT.                                                       
A03956      EXIT.                                                       
      *                                                                         
A03956******************************************************************        
A03956* FETCH SUBS_OF_MICH_MAST                                        *26380000
A03956******************************************************************        
A03956 7920-FETCH-SUBS-OF-MICH-MAST.                                    
A03956                                                                  
A03956     EXEC SQL                                                     
A03956         FETCH SUBS_OF_MICH_MAST                                  
A03956          INTO :AT-CODE-ACCT-BILLED                               
A03956     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03956                                                                  
A03956     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03956                                                                  
A03956     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A03956        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
A03956           SET  WS-NOMORE-ACCTS       TO TRUE                     
A03956        END-IF                                                    
A03956     ELSE                                                         
A03956         DISPLAY '7920-FETCH-SUBS-OF-MICH-MAST'                   
A03956         DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
A03956         DISPLAY 'ACCOUNT NO. = ' UR-ACCOUNT-NO-MST               
A03956         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
A03956     END-IF.                                                      
A03956                                                                  
A03956 7920-EXIT.                                                       
A03956      EXIT.                                                       
      *                                                                         
A03956******************************************************************        
A03956* CLOSE SUBS_OF_MICH_MAST                                        *26380000
A03956******************************************************************        
A03956 7930-CLOSE-SUBS-OF-MICH-MAST.                                    
A03956                                                                  
A03956     EXEC SQL                                                     
A03956        CLOSE SUBS_OF_MICH_MAST                                   
A03956     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03956                                                                  
A03956     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03956                                                                  
A03956     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A03956         CONTINUE                                                 
A03956     ELSE                                                         
A03956         DISPLAY '7930-OPEN-SUBS-OF-MICH-MAST'                    
A03956         DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
A03956         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
A03956     END-IF.                                                      
A03956                                                                  
A03956 7930-EXIT.                                                       
A03956      EXIT.                                                       
      *                                                                         
       8000-COMMIT.                                                     
           MOVE WS-PROCESS-TYPE        TO WS-RESTART-PROCESS-TYPE.      
           ADD 1                       TO WS-CHKP-SEQ-NO.               
           MOVE WS-CHKP-SEQ-NO         TO WS-RESTART-CHKP-SEQ-NO.       
                                                                        
           IF WS-REPOSITION-NEEDED = WS-N                               
               IF WS-PROCESS-TYPE > 1                                   
                   MOVE WS-20-NINES    TO WS-RESTART-METER-ID-NO        
                 ELSE                                                   
      ************ THIS CHECKPOINT IS THEREFORE THE INITIAL ONE                 
                   MOVE ZEROS          TO WS-RESTART-METER-ID-NO
               END-IF        
           ELSE                                                         
               MOVE E-FBW112-0000-IDENT-NO  TO WS-RESTART-METER-ID-NO   
           END-IF.                                                      
                                                                        
           PERFORM 8899-MAINTAIN-RESTART THRU 8899-EXIT.                
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8000-COMMIT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN. '          
                   'LAST METER ID PROCESSED=' WS-IDR-IDENT-NO.          
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
       8100-ROLLBACK.                                                   
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8100-RLLBCK RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       8100-EXIT.                                                       
           EXIT.                                                        
       8500-SUBTRACT-ONE-MINUTE.                                        
           EXEC SQL                                                     
C35227         SELECT
              REPLACE(CONVERT(CHAR(8), DATEADD( MINUTE, -1, 
           CIS.CHAR2TIME(:WS-TIME-READ-RED) ), 108), ':', '.')
            INTO
              :WS-TIME-READ-RED            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-TIME-READ-RED =                                          
MFA-TR*             TIME(TIME(:WS-TIME-READ-RED) - 1 MINUTE)                    
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       8500-EXIT.                                                       
           EXIT.                                                        
       8550-SUBTRACT-ONE-HOUR.                                          
           EXEC SQL                                                     
C35227         SELECT
              REPLACE(CONVERT(CHAR(8), DATEADD( HOUR, -1, CIS.CHAR2TIME(
                                                     :WS-TIME-READ-RED)
               ), 108), ':', '.')
            INTO
              :WS-TIME-READ-RED              
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-TIME-READ-RED =                                          
MFA-TR*             TIME(TIME(:WS-TIME-READ-RED) - 1 HOUR)                      
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       8550-EXIT.                                                       
           EXIT.                                                        
       8560-ADD-ONE-HOUR.                                               
           EXEC SQL                                                     
C35227         SELECT
              REPLACE(CONVERT(CHAR(8), DATEADD( HOUR, 1, CIS.CHAR2TIME(
                                                   :WS-TIME-READ-RED) )
           , 108), ':', '.')
            INTO
              :WS-TIME-READ-RED              
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-TIME-READ-RED =                                          
MFA-TR*             TIME(TIME(:WS-TIME-READ-RED) + 1 HOUR)                      
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       8560-EXIT.                                                       
           EXIT.                                                        
       8600-ADD-ONE-INTERVAL.                                           
           EXEC SQL                                                     
C35227         SELECT
              REPLACE(CONVERT(CHAR(8), DATEADD( MINUTE, :WS-INTERVAL, 
           CIS.CHAR2TIME(:WS-TIME-READ-RED) ), 108), ':', '.')
            INTO
              :WS-TIME-READ-RED                   
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-TIME-READ-RED =                                          
MFA-TR*             TIME(TIME(:WS-TIME-READ-RED) +                              
MFA-TR*                         :WS-INTERVAL MINUTES)                           
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       8600-EXIT.                                                       
           EXIT.                                                        
       8650-ADD-ONE-DAY.                                                
           EXEC SQL                                                     
C35227         SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DATE-READ-RED
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-READ-RED
              ) <> 0) OR (LEN(:WS-DATE-READ-RED) <> 10), CIS.CHAR2DATE(
                                                      :WS-DATE-READ-RED
              ), CONVERT(DATE, :WS-DATE-READ-RED) ) )
            INTO
              :WS-DATE-READ-RED               
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DATE-READ-RED =                                          
MFA-TR*             DATE(DATE(:WS-DATE-READ-RED) + 1 DAY)                       
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       8650-EXIT.                                                       
           EXIT.                                                        
       8700-UPDATE-JOB-PARM.                                            
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
                  SET STATUS = :G6-STATUS                               
                WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
                  AND SEQ_NO       = :G6-SEQ-NO                         
                  AND PARM_DATA    = :G6-PARM-DATA                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
             ELSE                                                       
               DISPLAY '8700-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       8700-EXIT.                                                       
           EXIT.                                                        
       8800-INSERT-MTR-IDENT-HIST.                                      
           EXEC SQL                                                     
               INSERT INTO CSS_MTR_IDENT_HIST                           
                      (ACCOUNT_NO, METER_NO, MTR_REF_NO,                
                       BILL_ITEM_TIMESTMP, IC_NO,                       
                       CODE_UTIL_TYPE, BILL_NO,                         
                       IDR_IDENT_NO, CHANNEL_A_UOM,                     
                       CHANNEL_B_UOM, CHANNEL_C_UOM                     
A03247                ,IDR_INFO_RETENT_DT                               
T20288                ,INTERVALS_PER_HR                                 
T20288                ,CT_UPPER_RATIO                                   
T20288                ,PT_UPPER_RATIO                                   
T20288                ,CT_LOWER_RATIO                                   
T20288                ,PT_LOWER_RATIO)                                  
               VALUES (:GA-ACCOUNT-NO, :GA-METER-NO, :GA-MTR-REF-NO,    
                       CIS.CHAR2TIMESTAMP(:GA-BILL-ITEM-TIMESTMP), 
                                                             :GA-IC-NO,        
                       :GA-CODE-UTIL-TYPE, :GA-BILL-NO,                 
                       :GA-IDR-IDENT-NO, :GA-CHANNEL-A-UOM,             
                       :GA-CHANNEL-B-UOM, :GA-CHANNEL-C-UOM             
A03247                ,IIF(TRY_CONVERT(DATE, :GA-IDR-INFO-RETENT-DT 
                                             :WS-NULL-IND-RETENT-DT
              ) IS NULL OR (PATINDEX('%.%', :GA-IDR-INFO-RETENT-DT 
                                                 :WS-NULL-IND-RETENT-DT
              ) <> 0) OR (LEN(:GA-IDR-INFO-RETENT-DT 
                                                 :WS-NULL-IND-RETENT-DT
              ) <> 10), CIS.CHAR2DATE(:GA-IDR-INFO-RETENT-DT 
                                                 :WS-NULL-IND-RETENT-DT
              ), CONVERT(DATE, :GA-IDR-INFO-RETENT-DT 
                                                 :WS-NULL-IND-RETENT-DT
              ) )     
T20288                ,:GA-INTERVALS-PER-HR                             
T20288                ,:GA-CT-UPPER-RATIO                               
T20288                ,:GA-PT-UPPER-RATIO                               
T20288                ,:GA-CT-LOWER-RATIO                               
T20288                ,:GA-PT-LOWER-RATIO)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MTR_IDENT_HIST                                   
MFA-TR*               (ACCOUNT_NO, METER_NO, MTR_REF_NO,                        
MFA-TR*                BILL_ITEM_TIMESTMP, IC_NO,                               
MFA-TR*                CODE_UTIL_TYPE, BILL_NO,                                 
MFA-TR*                IDR_IDENT_NO, CHANNEL_A_UOM,                             
MFA-TR*                CHANNEL_B_UOM, CHANNEL_C_UOM                             
MFA-TR*               ,IDR_INFO_RETENT_DT                                       
MFA-TR*               ,INTERVALS_PER_HR                                         
MFA-TR*               ,CT_UPPER_RATIO                                           
MFA-TR*               ,PT_UPPER_RATIO                                           
MFA-TR*               ,CT_LOWER_RATIO                                           
MFA-TR*               ,PT_LOWER_RATIO)                                          
MFA-TR*        VALUES (:GA-ACCOUNT-NO, :GA-METER-NO, :GA-MTR-REF-NO,            
MFA-TR*                :GA-BILL-ITEM-TIMESTMP, :GA-IC-NO,                       
MFA-TR*                :GA-CODE-UTIL-TYPE, :GA-BILL-NO,                         
MFA-TR*                :GA-IDR-IDENT-NO, :GA-CHANNEL-A-UOM,                     
MFA-TR*                :GA-CHANNEL-B-UOM, :GA-CHANNEL-C-UOM                     
MFA-TR*               ,:GA-IDR-INFO-RETENT-DT:WS-NULL-IND-RETENT-DT             
MFA-TR*               ,:GA-INTERVALS-PER-HR                                     
MFA-TR*               ,:GA-CT-UPPER-RATIO                                       
MFA-TR*               ,:GA-PT-UPPER-RATIO                                       
MFA-TR*               ,:GA-CT-LOWER-RATIO                                       
MFA-TR*               ,:GA-PT-LOWER-RATIO)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
               NEXT SENTENCE                                            
           ELSE IF WS-ACTIVE-RETURN-CODE = ALREADY-EXISTS               
               DISPLAY '8800-INSERT'                                    
               DISPLAY 'DUPLICATE MTR_IDENT_HIST ID=' WS-IDR-IDENT-NO   
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           ELSE                                                         
               DISPLAY '8800-INSERT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
                END-IF
           END-IF.               
       8800-EXIT.                                                       
           EXIT.                                                        
       8810-INSERT-INTERVAL-READ.                                       
           EXEC SQL                                                     
               INSERT INTO CSS_INTERVAL_READ                            
                      (METER_NO, BILL_ITEM_TIMESTMP,                    
                       TIME_READ,                                       
                       DATE_READ, DST_CHNG_IND,                         
                       CHANNEL_A_PULSES, CHANNEL_A_STATUS,              
                       CHANNEL_B_PULSES, CHANNEL_B_STATUS,              
27775                  CHANNEL_C_PULSES, CHANNEL_C_STATUS,              
27775                  CODE_UTIL_TYPE)                                  
               VALUES (:IV-METER-NO, CIS.CHAR2TIMESTAMP(
                                                 :IV-BILL-ITEM-TIMESTMP
              ),            
                       CIS.CHAR2TIME(:IV-TIME-READ),                            
                       IIF(TRY_CONVERT(DATE, :IV-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :IV-DATE-READ
              ) <> 0) OR (LEN(:IV-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :IV-DATE-READ
              ), CONVERT(DATE, :IV-DATE-READ) ), :IV-DST-CHNG-IND,             
                       :IV-CHANNEL-A-PULSES, :IV-CHANNEL-A-STATUS,      
                       :IV-CHANNEL-B-PULSES, :IV-CHANNEL-B-STATUS,      
27775                  :IV-CHANNEL-C-PULSES, :IV-CHANNEL-C-STATUS,      
27775                  :IV-CODE-UTIL-TYPE)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_INTERVAL_READ                                    
MFA-TR*               (METER_NO, BILL_ITEM_TIMESTMP,                            
MFA-TR*                TIME_READ,                                               
MFA-TR*                DATE_READ, DST_CHNG_IND,                                 
MFA-TR*                CHANNEL_A_PULSES, CHANNEL_A_STATUS,                      
MFA-TR*                CHANNEL_B_PULSES, CHANNEL_B_STATUS,                      
MFA-TR*                CHANNEL_C_PULSES, CHANNEL_C_STATUS,                      
MFA-TR*                CODE_UTIL_TYPE)                                          
MFA-TR*        VALUES (:IV-METER-NO, :IV-BILL-ITEM-TIMESTMP,                    
MFA-TR*                :IV-TIME-READ,                                           
MFA-TR*                :IV-DATE-READ, :IV-DST-CHNG-IND,                         
MFA-TR*                :IV-CHANNEL-A-PULSES, :IV-CHANNEL-A-STATUS,              
MFA-TR*                :IV-CHANNEL-B-PULSES, :IV-CHANNEL-B-STATUS,              
MFA-TR*                :IV-CHANNEL-C-PULSES, :IV-CHANNEL-C-STATUS,              
MFA-TR*                :IV-CODE-UTIL-TYPE)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8810-INSERT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       8810-EXIT.                                                       
           EXIT.                                                        
       8840-REPL-MTRD-ENVRNMT.                                          
           EXEC SQL                                                     
               UPDATE CSS_MTRD_ENVRNMT                                  
                  SET CODE_USAGE_SOURCE = :MN-CODE-USAGE-SOURCE,        
                      SPCL_MTR_CONDITION = :MN-SPCL-MTR-CONDITION,      
                      CODE_USAGE_ID = :MN-CODE-USAGE-ID,                
                      LAST_REG_READ_DATE = IIF(TRY_CONVERT(DATE, 
                                                 :MN-LAST-REG-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-REG-READ-DATE
              ) <> 0) OR (LEN(:MN-LAST-REG-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-REG-READ-DATE
              ), CONVERT(DATE, :MN-LAST-REG-READ-DATE) ),      
                      LAST_REG_READ_TIME = CIS.CHAR2TIME(
                                                 :MN-LAST-REG-READ-TIME
              ),      
                      CODE_METER_STATUS = :MN-CODE-METER-STATUS,        
                      LAST_READ_VALUE = :MN-LAST-READ-VALUE,            
                      CODE_LAST_VALID_RD = :MN-CODE-LAST-VALID-RD,      
                      LAST_VAL_RD_VALUE = :MN-LAST-VAL-RD-VALUE,        
                      CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ,      
                      CODE_NO_RD_REASON = :MN-CODE-NO-RD-REASON,        
                      CODE_LAST_REG_READ = :MN-CODE-LAST-REG-READ,      
                      LAST_VALID_READ_DT = IIF(TRY_CONVERT(DATE, 
                                                 :MN-LAST-VALID-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-VALID-READ-DT
              ) <> 0) OR (LEN(:MN-LAST-VALID-READ-DT
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-VALID-READ-DT
              ), CONVERT(DATE, :MN-LAST-VALID-READ-DT) ),      
                      LAST_VALID_READ_TM = CIS.CHAR2TIME(
                                                 :MN-LAST-VALID-READ-TM
              )       
T21338               ,NO_CONSEC_ESTIMATE = :MN-NO-CONSEC-ESTIMATE       
                WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE               
                  AND IC_NO = :MN-IC-NO                                 
                  AND MTR_REF_NO = :MN-MTR-REF-NO                       
                  AND METER_NO = :MN-METER-NO                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MTRD_ENVRNMT                                          
MFA-TR*           SET CODE_USAGE_SOURCE = :MN-CODE-USAGE-SOURCE,                
MFA-TR*               SPCL_MTR_CONDITION = :MN-SPCL-MTR-CONDITION,              
MFA-TR*               CODE_USAGE_ID = :MN-CODE-USAGE-ID,                        
MFA-TR*               LAST_REG_READ_DATE = :MN-LAST-REG-READ-DATE,              
MFA-TR*               LAST_REG_READ_TIME = :MN-LAST-REG-READ-TIME,              
MFA-TR*               CODE_METER_STATUS = :MN-CODE-METER-STATUS,                
MFA-TR*               LAST_READ_VALUE = :MN-LAST-READ-VALUE,                    
MFA-TR*               CODE_LAST_VALID_RD = :MN-CODE-LAST-VALID-RD,              
MFA-TR*               LAST_VAL_RD_VALUE = :MN-LAST-VAL-RD-VALUE,                
MFA-TR*               CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ,              
MFA-TR*               CODE_NO_RD_REASON = :MN-CODE-NO-RD-REASON,                
MFA-TR*               CODE_LAST_REG_READ = :MN-CODE-LAST-REG-READ,              
MFA-TR*               LAST_VALID_READ_DT = :MN-LAST-VALID-READ-DT,              
MFA-TR*               LAST_VALID_READ_TM = :MN-LAST-VALID-READ-TM               
MFA-TR*              ,NO_CONSEC_ESTIMATE = :MN-NO-CONSEC-ESTIMATE       00015000
MFA-TR*         WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO = :MN-IC-NO                                         
MFA-TR*           AND MTR_REF_NO = :MN-MTR-REF-NO                               
MFA-TR*           AND METER_NO = :MN-METER-NO                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8840-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       8840-EXIT.                                                       
           EXIT.                                                        
       8862-ISRT-BILLING-DETAIL.                                        
                                                                        
T19383     DISPLAY 'BEG PCSBW112 - PARA 8862 - INSERT BG'.              
T19383     DISPLAY ' ' BG-ACCOUNT-NO ' ' BG-BILL-NO                     
T23951             ' ' BG-COMPANY-NO                                    
T19383             ' ' BG-CODE-UTIL-TYPE ' ' BG-IC-NO                   
T19383             ' ' UT-CODE-STAT-TAX-XMT                             
T19383             ' ' UT-CODE-CITY-TAX-XMT                             
T19383             ' ' UT-CODE-OTHR-TAX-XMT.                            
                                                                        
           EXEC SQL                                                     
T23951         SELECT COMPANY_NO,                                       
T23951                REV_DISTRICT_CD                                   
T23951           INTO :BG-COMPANY-NO,                                   
T23951                :BG-REV-DISTRICT-CD                               
T17425           FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
T17425          WHERE PREMISE_NO = :BG-PREMISE-NO                       
C35227                                                           
T17425     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO,                                               
MFA-TR*               REV_DISTRICT_CD                                           
MFA-TR*          INTO :BG-COMPANY-NO,                                           
MFA-TR*               :BG-REV-DISTRICT-CD                                       
MFA-TR*          FROM CSS_PREMISE                                               
MFA-TR*         WHERE PREMISE_NO = :BG-PREMISE-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17425*                                                                         
T17425     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T17425     IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
T17425        DISPLAY '8862-SELECT RETURN CODE=' WS-ACTIVE-RETURN-CODE  
T17425        PERFORM 9900-ABEND THRU 9900-EXIT                         
T17425     END-IF.                                                      
T17425*                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_BILLING_DET                              
                (ACCOUNT_NO,                                            
                 COMPANY_NO,                                            
                 PREMISE_NO, BILL_NO,                                   
                 REVENUE_MONTH,                                         
                 CODE_UTIL_TYPE, IC_NO,                                 
                 DATE_ORIG_BILL,                                        
                 RATE_PLAN_NO, CODE_REVENUE_CLASS,                      
                 CODE_BILL_CALC,                                        
                 CODE_DR_CR_CNSMPTN,                                    
                 CODE_SIC_NO, CODE_CURTAIL_PRTY,                        
                 AMT_BILL_ITEM, AMT_STATE_TAX,                          
                 AMT_CITY_TAX, AMT_OTHER_TAX,                           
T17425           REV_DISTRICT_CD,                                       
T19383           CODE_STAT_TAX_XMT,                                     
T19383           CODE_CITY_TAX_XMT,                                     
T19383           CODE_OTHR_TAX_XMT,                                     
T27541           REV_MTH_ORIG_BILL,                                     
                 CODE_BILL_ITM_TYPE, CODE_BILL_ITM_IND)                 
               VALUES                                                   
                (:BG-ACCOUNT-NO,                                        
                 :BG-COMPANY-NO,                                        
                 :BG-PREMISE-NO, :BG-BILL-NO,                           
                 :BG-REVENUE-MONTH,                                     
                 :BG-CODE-UTIL-TYPE, :BG-IC-NO,                         
                 IIF(TRY_CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                       :WS-IND-DATE-ORIG-BILL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL 
                                                 :WS-IND-DATE-ORIG-BILL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL :WS-IND-DATE-ORIG-BILL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL 
                                                 :WS-IND-DATE-ORIG-BILL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                                 :WS-IND-DATE-ORIG-BILL
              ) ),              
                 :BG-RATE-PLAN-NO, :BG-CODE-REVENUE-CLASS,              
                 :BG-CODE-BILL-CALC,                                    
                 :BG-CODE-DR-CR-CNSMPTN,                                
                 :BG-CODE-SIC-NO, :BG-CODE-CURTAIL-PRTY,                
                 :BG-AMT-BILL-ITEM, :BG-AMT-STATE-TAX,                  
                 :BG-AMT-CITY-TAX, :BG-AMT-OTHER-TAX,                   
T17425           :BG-REV-DISTRICT-CD,                                   
T19383           :UT-CODE-STAT-TAX-XMT,                                 
T19383           :UT-CODE-CITY-TAX-XMT,                                 
T19383           :UT-CODE-OTHR-TAX-XMT,                                 
T27541           :BG-REV-MTH-ORIG-BILL,                                 
                 :BG-CODE-BILL-ITM-TYPE, :BG-CODE-BILL-ITM-IND)         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILLING_DET                                      
MFA-TR*         (ACCOUNT_NO,                                                    
MFA-TR*          COMPANY_NO,                                                    
MFA-TR*          PREMISE_NO, BILL_NO,                                           
MFA-TR*          REVENUE_MONTH,                                                 
MFA-TR*          CODE_UTIL_TYPE, IC_NO,                                         
MFA-TR*          DATE_ORIG_BILL,                                                
MFA-TR*          RATE_PLAN_NO, CODE_REVENUE_CLASS,                              
MFA-TR*          CODE_BILL_CALC,                                                
MFA-TR*          CODE_DR_CR_CNSMPTN,                                            
MFA-TR*          CODE_SIC_NO, CODE_CURTAIL_PRTY,                                
MFA-TR*          AMT_BILL_ITEM, AMT_STATE_TAX,                                  
MFA-TR*          AMT_CITY_TAX, AMT_OTHER_TAX,                                   
MFA-TR*          REV_DISTRICT_CD,                                               
MFA-TR*          CODE_STAT_TAX_XMT,                                             
MFA-TR*          CODE_CITY_TAX_XMT,                                             
MFA-TR*          CODE_OTHR_TAX_XMT,                                             
MFA-TR*          REV_MTH_ORIG_BILL,                                             
MFA-TR*          CODE_BILL_ITM_TYPE, CODE_BILL_ITM_IND)                         
MFA-TR*        VALUES                                                           
MFA-TR*         (:BG-ACCOUNT-NO,                                                
MFA-TR*          :BG-COMPANY-NO,                                                
MFA-TR*          :BG-PREMISE-NO, :BG-BILL-NO,                                   
MFA-TR*          :BG-REVENUE-MONTH,                                             
MFA-TR*          :BG-CODE-UTIL-TYPE, :BG-IC-NO,                                 
MFA-TR*          :BG-DATE-ORIG-BILL:WS-IND-DATE-ORIG-BILL,                      
MFA-TR*          :BG-RATE-PLAN-NO, :BG-CODE-REVENUE-CLASS,                      
MFA-TR*          :BG-CODE-BILL-CALC,                                            
MFA-TR*          :BG-CODE-DR-CR-CNSMPTN,                                        
MFA-TR*          :BG-CODE-SIC-NO, :BG-CODE-CURTAIL-PRTY,                        
MFA-TR*          :BG-AMT-BILL-ITEM, :BG-AMT-STATE-TAX,                          
MFA-TR*          :BG-AMT-CITY-TAX, :BG-AMT-OTHER-TAX,                           
MFA-TR*          :BG-REV-DISTRICT-CD,                                           
MFA-TR*          :UT-CODE-STAT-TAX-XMT,                                         
MFA-TR*          :UT-CODE-CITY-TAX-XMT,                                         
MFA-TR*          :UT-CODE-OTHR-TAX-XMT,                                         
MFA-TR*          :BG-REV-MTH-ORIG-BILL,                                         
MFA-TR*          :BG-CODE-BILL-ITM-TYPE, :BG-CODE-BILL-ITM-IND)                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8862-INSERT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
T19383     DISPLAY 'END PCSBW112 - PARA 8862 - INSERT BG'.              
T19383     DISPLAY ' ' BG-ACCOUNT-NO ' ' BG-BILL-NO                     
T23951             ' ' BG-COMPANY-NO                                    
T19383             ' ' BG-CODE-UTIL-TYPE ' ' BG-IC-NO                   
T19383             ' ' UT-CODE-STAT-TAX-XMT                             
T19383             ' ' UT-CODE-CITY-TAX-XMT                             
T19383             ' ' UT-CODE-OTHR-TAX-XMT.                            
                                                                        
                                                                        
       8862-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8863-ISRT-CONSUMPTION-HIST.                                      
           EXEC SQL                                                     
               INSERT INTO CSS_CNSMPTN_HIST                             
                (ACCOUNT_NO, BILL_NO,                                   
                 CODE_UTIL_TYPE, IC_NO,                                 
                 COMPANY_NO,                                            
                 BILL_ITEM_TIMESTMP,                                    
                 CODE_TIME_PERIOD, MTR_REF_NO,                          
                 CODE_USAGE_TYPE, CODE_USAGE_ID,                        
                 CODE_USAGE_SOURCE, ITEM_SEQ_NO, METER_NO,              
                 DATE_READ, CODE_METER_READ,                            
                 METER_READING, EMPLOYEE_NO,                            
                 NO_UNITS,                                              
                 NO_DAYS, CODE_SOURCE_ID,                               
                 CODE_DEBIT_CREDIT, CODE_DISCOUNT,                      
                 CONSTANT, NO_DIALS,                                    
                 REG_ID_NO, DEMAND_READING,                             
                 CODE_ITEM_STATUS,                                      
                 MTR_READ_SOURCE_CD,                                    
                 DIGTL_MTR_TYPE)                                        
               VALUES                                                   
                (:CX-ACCOUNT-NO, :CX-BILL-NO,                           
                 :CX-CODE-UTIL-TYPE, :CX-IC-NO,                         
                 :CX-COMPANY-NO,                                        
                 CIS.CHAR2TIMESTAMP(:CX-BILL-ITEM-TIMESTMP),                    
                 :CX-CODE-TIME-PERIOD, :CX-MTR-REF-NO,                  
                 :CX-CODE-USAGE-TYPE, :CX-CODE-USAGE-ID,                
                 :CX-CODE-USAGE-SOURCE, :CX-ITEM-SEQ-NO, :CX-METER-NO,  
                 IIF(TRY_CONVERT(DATE, :CX-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ
              ) <> 0) OR (LEN(:CX-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :CX-DATE-READ
              ), CONVERT(DATE, :CX-DATE-READ) ), :CX-CODE-METER-READ,          
                 :CX-METER-READING, :CX-EMPLOYEE-NO,                    
                 :CX-NO-UNITS,                                          
                 :CX-NO-DAYS, :CX-CODE-SOURCE-ID,                       
                 :CX-CODE-DEBIT-CREDIT, :CX-CODE-DISCOUNT,              
                 :CX-CONSTANT, :CX-NO-DIALS,                            
                 :CX-REG-ID-NO, :CX-DEMAND-READING,                     
                 :CX-CODE-ITEM-STATUS,                                  
                 :CX-MTR-READ-SOURCE-CD,                                
                 :CX-DIGTL-MTR-TYPE)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CNSMPTN_HIST                                     
MFA-TR*         (ACCOUNT_NO, BILL_NO,                                           
MFA-TR*          CODE_UTIL_TYPE, IC_NO,                                         
MFA-TR*          COMPANY_NO,                                                    
MFA-TR*          BILL_ITEM_TIMESTMP,                                            
MFA-TR*          CODE_TIME_PERIOD, MTR_REF_NO,                                  
MFA-TR*          CODE_USAGE_TYPE, CODE_USAGE_ID,                                
MFA-TR*          CODE_USAGE_SOURCE, ITEM_SEQ_NO, METER_NO,                      
MFA-TR*          DATE_READ, CODE_METER_READ,                                    
MFA-TR*          METER_READING, EMPLOYEE_NO,                                    
MFA-TR*          NO_UNITS,                                                      
MFA-TR*          NO_DAYS, CODE_SOURCE_ID,                                       
MFA-TR*          CODE_DEBIT_CREDIT, CODE_DISCOUNT,                              
MFA-TR*          CONSTANT, NO_DIALS,                                            
MFA-TR*          REG_ID_NO, DEMAND_READING,                                     
MFA-TR*          CODE_ITEM_STATUS,                                              
MFA-TR*          MTR_READ_SOURCE_CD,                                            
MFA-TR*          DIGTL_MTR_TYPE)                                                
MFA-TR*        VALUES                                                           
MFA-TR*         (:CX-ACCOUNT-NO, :CX-BILL-NO,                                   
MFA-TR*          :CX-CODE-UTIL-TYPE, :CX-IC-NO,                                 
MFA-TR*          :CX-COMPANY-NO,                                                
MFA-TR*          :CX-BILL-ITEM-TIMESTMP,                                        
MFA-TR*          :CX-CODE-TIME-PERIOD, :CX-MTR-REF-NO,                          
MFA-TR*          :CX-CODE-USAGE-TYPE, :CX-CODE-USAGE-ID,                        
MFA-TR*          :CX-CODE-USAGE-SOURCE, :CX-ITEM-SEQ-NO, :CX-METER-NO,          
MFA-TR*          :CX-DATE-READ, :CX-CODE-METER-READ,                            
MFA-TR*          :CX-METER-READING, :CX-EMPLOYEE-NO,                            
MFA-TR*          :CX-NO-UNITS,                                                  
MFA-TR*          :CX-NO-DAYS, :CX-CODE-SOURCE-ID,                               
MFA-TR*          :CX-CODE-DEBIT-CREDIT, :CX-CODE-DISCOUNT,                      
MFA-TR*          :CX-CONSTANT, :CX-NO-DIALS,                                    
MFA-TR*          :CX-REG-ID-NO, :CX-DEMAND-READING,                             
MFA-TR*          :CX-CODE-ITEM-STATUS,                                          
MFA-TR*          :CX-MTR-READ-SOURCE-CD,                                        
MFA-TR*          :CX-DIGTL-MTR-TYPE)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8863-INSERT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
               DISPLAY 'ACCOUNT NO. = ' CX-ACCOUNT-NO                   
               DISPLAY 'BILL NO. = ' CX-BILL-NO                         
               DISPLAY 'CODE UTIL TYPE = ' CX-CODE-UTIL-TYPE            
               DISPLAY 'IC NO. = ' CX-IC-NO                             
               DISPLAY 'METER REF NO. = ' CX-MTR-REF-NO                 
               DISPLAY 'REGISTER ID NO. = ' CX-REG-ID-NO                
               DISPLAY 'TIME PERIOD = ' CX-CODE-TIME-PERIOD             
               DISPLAY 'ITEM SEQ NO. = ' CX-ITEM-SEQ-NO                 
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       8863-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8864-REPL-BILLING-DETAIL.                                        
           EXEC SQL                                                     
               UPDATE CSS_BILLING_DET                                   
               SET DATE_ORIG_BILL =                                     
                              IIF(TRY_CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                                 :WS-IND-DATE-ORIG-BILL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL 
                                                 :WS-IND-DATE-ORIG-BILL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL :WS-IND-DATE-ORIG-BILL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL 
                                                 :WS-IND-DATE-ORIG-BILL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                                 :WS-IND-DATE-ORIG-BILL
              ) ), 
                   RATE_PLAN_NO       = :BG-RATE-PLAN-NO,               
                   CODE_REVENUE_CLASS = :BG-CODE-REVENUE-CLASS,         
                   CODE_BILL_CALC     = :BG-CODE-BILL-CALC,             
                   CODE_SIC_NO        = :BG-CODE-SIC-NO,                
                   CODE_CURTAIL_PRTY  = :BG-CODE-CURTAIL-PRTY,          
                   AMT_BILL_ITEM      = :BG-AMT-BILL-ITEM,              
                   AMT_STATE_TAX      = :BG-AMT-STATE-TAX,              
                   AMT_CITY_TAX       = :BG-AMT-CITY-TAX,               
                   CODE_BILL_ITM_TYPE = :BG-CODE-BILL-ITM-TYPE,         
                   CODE_BILL_ITM_IND  = :BG-CODE-BILL-ITM-IND,          
                   REVENUE_MONTH      = :BG-REVENUE-MONTH,              
                   COMPANY_NO         = :BG-COMPANY-NO,                 
                   CODE_DR_CR_CNSMPTN = :BG-CODE-DR-CR-CNSMPTN          
             WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                  
               AND BILL_NO            = :BG-BILL-NO                     
               AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE              
               AND IC_NO              = :BG-IC-NO                       
               AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILLING_DET                                           
MFA-TR*        SET DATE_ORIG_BILL =                                             
MFA-TR*                       :BG-DATE-ORIG-BILL:WS-IND-DATE-ORIG-BILL,         
MFA-TR*            RATE_PLAN_NO       = :BG-RATE-PLAN-NO,                       
MFA-TR*            CODE_REVENUE_CLASS = :BG-CODE-REVENUE-CLASS,                 
MFA-TR*            CODE_BILL_CALC     = :BG-CODE-BILL-CALC,                     
MFA-TR*            CODE_SIC_NO        = :BG-CODE-SIC-NO,                        
MFA-TR*            CODE_CURTAIL_PRTY  = :BG-CODE-CURTAIL-PRTY,                  
MFA-TR*            AMT_BILL_ITEM      = :BG-AMT-BILL-ITEM,                      
MFA-TR*            AMT_STATE_TAX      = :BG-AMT-STATE-TAX,                      
MFA-TR*            AMT_CITY_TAX       = :BG-AMT-CITY-TAX,                       
MFA-TR*            CODE_BILL_ITM_TYPE = :BG-CODE-BILL-ITM-TYPE,                 
MFA-TR*            CODE_BILL_ITM_IND  = :BG-CODE-BILL-ITM-IND,                  
MFA-TR*            REVENUE_MONTH      = :BG-REVENUE-MONTH,                      
MFA-TR*            COMPANY_NO         = :BG-COMPANY-NO,                         
MFA-TR*            CODE_DR_CR_CNSMPTN = :BG-CODE-DR-CR-CNSMPTN                  
MFA-TR*      WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                          
MFA-TR*        AND BILL_NO            = :BG-BILL-NO                             
MFA-TR*        AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                      
MFA-TR*        AND IC_NO              = :BG-IC-NO                               
MFA-TR*        AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8864-UPDATE RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       8864-EXIT.                                                       
           EXIT.                                                        
                                                                        
T19862******************************************************************        
T22214* INSERT INTO CSS_PEAK_HISTORY                                  **        
T19862******************************************************************        
T22214 8865-INSERT-PH-RECORD.                                           
T19862*                                                                         
T19862     EXEC SQL                                                     
T22214         INSERT INTO CSS_PEAK_HISTORY                             
T19862                ( ACCOUNT_NO                                      
T19862                 ,BILL_NO                                         
T19862                 ,CODE_UTIL_TYPE                                  
T19862                 ,IC_NO                                           
T19862                 ,BILL_ITEM_TIMESTMP                              
T19862                 ,MTR_REF_NO                                      
T22214                 ,PEAK_TIME                                       
T22214                 ,PEAK_DATE                                       
T22214                 ,PEAK_KW_UNITS                                   
T22214                 ,PEAK_KVA_UNITS                                  
T22214                 ,PEAK_KVAR_UNITS                                 
T19862                 ,METER_NO                                        
T22214                 ,PEAK_TYPE )                                     
T19862         VALUES                                                   
T22214               ( :PH-ACCOUNT-NO                                   
T22214                ,:PH-BILL-NO                                      
T22214                ,:PH-CODE-UTIL-TYPE                               
T22214                ,:PH-IC-NO                                        
T22214                ,CIS.CHAR2TIMESTAMP(:PH-BILL-ITEM-TIMESTMP)               
T22214                ,:PH-MTR-REF-NO                                   
T22214                ,CIS.CHAR2TIME(:PH-PEAK-TIME)                             
T22214                ,IIF(TRY_CONVERT(DATE, :PH-PEAK-DATE
              ) IS NULL OR (PATINDEX('%.%', :PH-PEAK-DATE
              ) <> 0) OR (LEN(:PH-PEAK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :PH-PEAK-DATE
              ), CONVERT(DATE, :PH-PEAK-DATE) )                                
T22214                ,:PH-PEAK-KW-UNITS                                
T22214                ,:PH-PEAK-KVA-UNITS                               
T22214                ,:PH-PEAK-KVAR-UNITS                              
T22214                ,:PH-METER-NO                                     
T22214                ,:PH-PEAK-TYPE )                                  
T19862     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_PEAK_HISTORY                                     
MFA-TR*               ( ACCOUNT_NO                                              
MFA-TR*                ,BILL_NO                                                 
MFA-TR*                ,CODE_UTIL_TYPE                                          
MFA-TR*                ,IC_NO                                                   
MFA-TR*                ,BILL_ITEM_TIMESTMP                                      
MFA-TR*                ,MTR_REF_NO                                              
MFA-TR*                ,PEAK_TIME                                               
MFA-TR*                ,PEAK_DATE                                               
MFA-TR*                ,PEAK_KW_UNITS                                           
MFA-TR*                ,PEAK_KVA_UNITS                                          
MFA-TR*                ,PEAK_KVAR_UNITS                                         
MFA-TR*                ,METER_NO                                                
MFA-TR*                ,PEAK_TYPE )                                             
MFA-TR*        VALUES                                                           
MFA-TR*              ( :PH-ACCOUNT-NO                                           
MFA-TR*               ,:PH-BILL-NO                                              
MFA-TR*               ,:PH-CODE-UTIL-TYPE                                       
MFA-TR*               ,:PH-IC-NO                                                
MFA-TR*               ,:PH-BILL-ITEM-TIMESTMP                                   
MFA-TR*               ,:PH-MTR-REF-NO                                           
MFA-TR*               ,:PH-PEAK-TIME                                            
MFA-TR*               ,:PH-PEAK-DATE                                            
MFA-TR*               ,:PH-PEAK-KW-UNITS                                        
MFA-TR*               ,:PH-PEAK-KVA-UNITS                                       
MFA-TR*               ,:PH-PEAK-KVAR-UNITS                                      
MFA-TR*               ,:PH-METER-NO                                             
MFA-TR*               ,:PH-PEAK-TYPE )                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19862*                                                                         
T19862     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
T19862*                                                                         
T19862     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T19862         NEXT SENTENCE                                            
T19862     ELSE                                                         
T19862         DISPLAY '8865-INSERT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
T22214         DISPLAY 'ACCOUNT NO. = ' PH-ACCOUNT-NO                   
T22214         DISPLAY 'BILL NO. = ' PH-BILL-NO                         
T22214         DISPLAY 'CODE UTIL TYPE = ' PH-CODE-UTIL-TYPE            
T22214         DISPLAY 'IC NO. = ' PH-IC-NO                             
T22214         DISPLAY 'METER REF NO. = ' PH-MTR-REF-NO                 
T22214         DISPLAY 'PEAK TYPE. = ' PH-PEAK-TYPE                     
T19862         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
T19862*                                                                         
T19862 8865-EXIT.                                                       
T19862     EXIT.                                                        
T19862*                                                                         
T22214******************************************************************        
T22214* DELETE INTO CSS_PEAK_HISTORY                                  **        
T22214******************************************************************        
T22214 8870-DELETE-PH-RECORD.                                           
T22214*                                                                         
T22214     EXEC SQL                                                     
T22214         DELETE FROM CSS_PEAK_HISTORY                             
T22214          WHERE ACCOUNT_NO     = :PH-ACCOUNT-NO                   
T22214            AND BILL_NO        = :PH-BILL-NO                      
T22214            AND CODE_UTIL_TYPE = :PH-CODE-UTIL-TYPE               
T22214            AND IC_NO          = :PH-IC-NO                        
T22214            AND MTR_REF_NO     = :PH-MTR-REF-NO                   
T22214            AND PEAK_TYPE      = :PH-PEAK-TYPE                    
T22214     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22214*                                                                         
T22214     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
T22214*                                                                         
T22214     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22214         NEXT SENTENCE                                            
T22214     ELSE                                                         
T22214         DISPLAY '8870-DELETE RETURN CODE=' WS-ACTIVE-RETURN-CODE 
T22214         DISPLAY 'ACCOUNT NO. = ' PH-ACCOUNT-NO                   
T22214         DISPLAY 'BILL NO. = ' PH-BILL-NO                         
T22214         DISPLAY 'CODE UTIL TYPE = ' PH-CODE-UTIL-TYPE            
T22214         DISPLAY 'IC NO. = ' PH-IC-NO                             
T22214         DISPLAY 'METER REF NO. = ' PH-MTR-REF-NO                 
T22214         DISPLAY 'PEAK TYPE. = ' PH-PEAK-TYPE                     
T22214         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
T22214*                                                                         
T22214 8870-EXIT.                                                       
T19862     EXIT.                                                        
T19862*                                                                         
       8880-ISRT-BILL-HEADER.                                           
           EXEC SQL                                                     
               INSERT INTO CSS_BILLING_HDR                              
                (PREMISE_NO, BILL_NO,                                   
                 DATE_BILLED, CODE_BILL_REASON,                         
                 CODE_BILL_STATUS, CODE_BILL_TYPE,                      
                 CUSTOMER_NO, ACCOUNT_NO,                               
                 COMPANY_NO)                                            
               VALUES                                                   
                (:BI-PREMISE-NO, :BI-BILL-NO,                           
                 IIF(TRY_CONVERT(DATE, :BI-DATE-BILLED 
                                       :WS-IND-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED 
                                                    :WS-IND-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED :WS-IND-DATE-BILLED
              ) <> 10), CIS.CHAR2DATE(:BI-DATE-BILLED 
                                                    :WS-IND-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED :WS-IND-DATE-BILLED) ),         
                 :BI-CODE-BILL-REASON,                                  
                 :BI-CODE-BILL-STATUS, :BI-CODE-BILL-TYPE,              
                 :BI-CUSTOMER-NO, :BI-ACCOUNT-NO,                       
                 :BI-COMPANY-NO)                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILLING_HDR                                      
MFA-TR*         (PREMISE_NO, BILL_NO,                                           
MFA-TR*          DATE_BILLED, CODE_BILL_REASON,                                 
MFA-TR*          CODE_BILL_STATUS, CODE_BILL_TYPE,                              
MFA-TR*          CUSTOMER_NO, ACCOUNT_NO,                                       
MFA-TR*          COMPANY_NO)                                                    
MFA-TR*        VALUES                                                           
MFA-TR*         (:BI-PREMISE-NO, :BI-BILL-NO,                                   
MFA-TR*          :BI-DATE-BILLED:WS-IND-DATE-BILLED,                            
MFA-TR*          :BI-CODE-BILL-REASON,                                          
MFA-TR*          :BI-CODE-BILL-STATUS, :BI-CODE-BILL-TYPE,                      
MFA-TR*          :BI-CUSTOMER-NO, :BI-ACCOUNT-NO,                               
MFA-TR*          :BI-COMPANY-NO)                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8880-INSERT RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       8880-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8888-UPDATE-ACCOUNT.                                             
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET NXT_BILL_NO       = :AT-NXT-BILL-NO               
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8888-UPDATE RETURN CODE=' WS-ACTIVE-RETURN-CODE 
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       8888-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8890-UPDATE-ACCOUNT.                                             
           MOVE '8890' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODE_ACCT_BILLED = :AT-CODE-ACCT-BILLED           
                WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8890-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       8890-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03956******************************************************************00711886
A03956*                                                                *        
A03956*    SET MICHELIN MASTER 'READY' TO BILL                         *        
A03956*                                                                *        
A03956******************************************************************00711886
A03956 8891-UPDATE-MICH-ACCOUNT.                                        
A03956     MOVE '8891' TO ACTIVE-PARAGRAPH.                             
A03956     EXEC SQL                                                     
A03956         UPDATE CSS_ACCOUNT                                       
A03956            SET CODE_ACCT_BILLED = :WS-CODE-ACCT-BILLED           
A03956          WHERE ACCOUNT_NO       = :UR-ACCOUNT-NO-MST             
A03956     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03956                                                                  
A03956     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03956     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A03956         CONTINUE                                                 
A03956     ELSE                                                         
A03956         DISPLAY '8891-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE
A03956         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
A03956     END-IF.                                                      
A03956                                                                  
A03956 8891-EXIT.                                                       
A03956     EXIT.                                                        
                                                                        
      ******************************************************************00711886
      *                                                                *        
      *    8895-INSERT-WORK-QUEUE COPYBOOK                             *        
      *                                                                *        
      ******************************************************************00711886
ACT059*                                                                         
ACT059 8895-INSERT-WORK-QUEUE.                                          
ACT059     MOVE SPACES TO ABEND-FUNCTION.                               
ACT059                                                                  
ACT059     CALL SCSCB077 USING CWS00077-FIELDS,                         
ACT059                         ABEND-FILE,                              
ACT059                         RS-RETURN-CODE                           
ACT059     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
ACT059                                                                  
ACT059     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
ACT059        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
ACT059        DISPLAY '8895-INSERT-WORK-QUEUE'                          
ACT059        DISPLAY 'CALL SCSCB077         '                          
ACT059        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
ACT059        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
ACT059        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
ACT059        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
ACT059        PERFORM 9900-ABEND    THRU 9900-EXIT                      
ACT059     END-IF.                                                      
ACT059 8895-EXIT.                                                       
ACT059     EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
       8899-MAINTAIN-RESTART.                                           
           MOVE WS-PGRMNAME    TO RF-NAME-PROGRAM.                      
           MOVE 1              TO RF-PARTITION-NO.                      
           MOVE 1              TO RF-DUP-CNTRL-NO.                      
           MOVE WS-RESTART-DATA     TO RF-RESTART-DATA-TEXT.            
           MOVE WS-RESTART-DATA-LEN TO RF-RESTART-DATA-LEN.             
           PERFORM 8910-UPDATE-RESTART THRU 8910-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               PERFORM 8911-INSERT-RESTART THRU 8911-EXIT
           END-IF.              
       8899-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8910-UPDATE-RESTART.                                             
           EXEC SQL                                                     
                UPDATE CSS_RESTART                                      
                SET RESTART_DATA   = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM  AND              
                      PARTITION_NO = :RF-PARTITION-NO  AND              
                      DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF   WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
             OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '8910-UPDATE-RESTART'                            
                       ' RETURN CODE=' WS-ACTIVE-RETURN-CODE            
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       8910-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8911-INSERT-RESTART.                                             
           EXEC SQL                                                     
                INSERT INTO CSS_RESTART                                 
                (NAME_PROGRAM, PARTITION_NO,                            
                 DUP_CNTRL_NO, RESTART_DATA)                            
                VALUES                                                  
                (:RF-NAME-PROGRAM, :RF-PARTITION-NO,                    
                 :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '8911-INSERT-RESTART'                            
                       ' RETURN CODE=' WS-ACTIVE-RETURN-CODE            
TP9251         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
       8911-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *                                                                         
      ******************************************************************00711886
      *                                                              **         
      *   8893-RESET-RESTART-REQ-PARM                                **         
      *                                                              **         
      ******************************************************************00711886
             EXEC SQL                                                           
                INCLUDE CPD00029                                                
             END-EXEC.                                                          
                                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************00711886
      *                                                                *        
      *   9000-TERMINATE                                               *00711986
      *                                                                *00712086
      ******************************************************************00712186
       9000-TERMINATE.                                                  
      *                                                                         
           MOVE '9700' TO ACTIVE-PARAGRAPH.                             
           CLOSE FCSBW112.                                              
           IF FBW112-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '1000- ERROR ON FCSBW112 CLOSE. STATUS IS '      
                        WS-FBW112-STATUS                                
TP9332*        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                        
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    COPYBOOK FOR ABEND PROCESSING - TPR 5228                   *         
      *                                                               *         
      *    9700-PROCESS-ABEND                                         *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
TP5228 COPY CPD0023B.                                                           
      *                                                                         
      *****************************************************************         
      *                                                               *         
      *    9900-ABEND                                                 *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
              EXEC SQL                                                          
                  INCLUDE CPD09900                                              
              END-EXEC.                                                         
