       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW108.                                        
       AUTHOR.         ROGER D FAULK                                    
       INSTALLATION.                                                    
       DATE-WRITTEN.   AUGUST 2014.                                     
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      ********                   DB2                         *********          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      ** DATE       INITIALS       REASON                           **          
      **                                                            **          
      ** 31 AUG 2014 RF10596       DEVELOPMENT OF NEW PROGRAM TO    **          
      **                           ADD METER NUMBER, ACCOUNT NUMBER **          
      **                           AND SERVICE ADDRESS TO INPUT FILE**          
      **                                                            **          
A05136**  8 MAR 2015 RF10596       DO NOT ABEND WHEN MOST CURRENT   **          
      **                           ACCOUNT IS NOT FOUND             **          
      **                                                            **          
      ****************************************************************          
           REMARKS.                                                     
                              PCSBW108 NARRATIVE                        
           PROGRAM READS THE INPUT FIOBW09 FILE.  THIS COMES FROM       
           A GROUPDIR MEMBER THAT IS SORTED TO A FLAT FILE.             
           ADD METER NUMBER, ACCOUNT NUMBER AND SERVICE ADDRESS TO      
           THE INPUT FILE AND WRITE IT OUT.  GOES BACK TO GROUP         
           DIRECTORY.                                                   
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBW09.                                                            
      *                                                                         
       COPY CSSBW108.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBW09.                                                            
       COPY FIOBW09.                                                            
      *                                                                         
       COPY CFDBW108.                                                           
       COPY FIOBW108.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW108'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  PROGRAM-NAME                PIC X(8)    VALUE 'PCSBW108'.    
      *                                                                         
       01  WS-WORK-AREA.                                                
HEX01      05  WS-DELIM                PIC X       VALUE X'09'.         
           05  WS-USE                  PIC X       VALUE 'Y'.           
           05  WS-NOT                  PIC X(9)    VALUE 'NOT FOUND'.   
           05  WS-COMPANY-PARM         PIC XX      VALUE '01'.          
           05  RS-RETURN-CODE          PIC S9(4)   VALUE ZEROS COMP.    
           05  RS-RETURN-CODE-DISP     PIC +Z(4).                       
           05  WS-PREM-ADDR            PIC X(55)   VALUE SPACES.        
           05  WS-PREM-TOWN            PIC X(30)   VALUE SPACES.        
           05  WS-PREM-ZIP             PIC X(5)    VALUE SPACES.        
           05  WS-METER-NO             PIC X(9)    VALUE SPACES.        
           05  WS-METER-NO-CURRENTLY   PIC X(9)    VALUE SPACES.        
           05  WS-ACCOUNT-NO           PIC 9(13)   VALUE ZEROS.         
           05  WS-811                  PIC S9(9)   VALUE -811 COMP.     
           05  WS-803                  PIC S9(9)   VALUE -803 COMP.     
           05  WS-SAVE-PREMISE         PIC 9(10)   VALUE 0.             
           05  WS-SAVE-ERTID           PIC X(12)   VALUE SPACES.        
           05  WS-PGRMNAME             PIC X(8)    VALUE 'PCSBW108'.    
           05  WS-PREMISE-NO           PIC S9(10)V VALUE 0 COMP-3.      
           05  WS-CODE-UTIL-TYPE       PIC X(01)   VALUE SPACES.        
           05  WS-ERT-NO               PIC X(12)   VALUE SPACES.        
           05  WS-CURR-ACCT-NO         PIC 9(13)   VALUE ZERO.          
           05  WS-DEVICE-NO            PIC X(12)   VALUE SPACES.        
      *                                                                         
           05  WS-SWITCHES.                                             
               10 WS-EOF-FLAG        PIC X    VALUE 'N'.                
                  88 END-OF-FILE              VALUE 'Y'.                
               10 WS-FBW09-STATUS    PIC XX.                            
                  88 FBW09-SUCCESSFUL         VALUE '00'.               
               10 WS-FBW108-STATUS   PIC XX.                            
                  88 FBW108-SUCCESSFUL        VALUE '00'.               
      *                                                                         
       01  WS-ERT-TYPE             PIC XX.                              
           88  WS-ELECTRIC-METER   VALUE '04', '05', '07', '08'.        
           88  WS-GAS-METER        VALUE '02', '12'.                    
      *                                                                         
       01  WS-ERT-12A.                                                  
           05  WS-ERT-4                PIC X(4).                        
           05  WS-ERT-8                PIC X(8).                        
       01  WS-ERT-12B REDEFINES WS-ERT-12A.                             
           05  WS-ERT-3                PIC X(3).                        
           05  WS-ERT-9                PIC X(9).                        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-YES                      PIC X   VALUE 'Y'.           
           05  WS-NO                       PIC X   VALUE 'N'.           
           05  WS-ELECTRIC                 PIC X   VALUE 'E'.           
           05  WS-GAS                      PIC X   VALUE 'G'.           
      *                                                                         
       01  HEADER-RECORD.                                               
           05 E-FBWHDR-HEADER.                                          
              10  E-FBWHDR-ERT-ID            PIC X(10)                  
                                             VALUE '  ERT-ID  '.        
HEX01         10  E-FBWHDR-DELIM1            PIC X VALUE X'09'.         
              10  E-FBWHDR-ERT-READING       PIC X(10)                  
                                             VALUE ' READING  '.        
HEX01         10  E-FBWHDR-DELIM2            PIC X VALUE X'09'.         
              10  E-FBWHDR-DATE-READ         PIC X(6) VALUE ' DATE '.   
HEX01         10  E-FBWHDR-DELIM3            PIC X VALUE X'09'.         
              10  E-FBWHDR-TIME-READ         PIC X(6) VALUE ' TIME '.   
HEX01         10  E-FBWHDR-DELIM4            PIC X VALUE X'09'.         
              10  E-FBWHDR-ERT-TYPE          PIC XX VALUE 'ET'.         
HEX01         10  E-FBWHDR-DELIM5            PIC X VALUE X'09'.         
              10  E-FBWHDR-TAMPER-CD-1       PIC XX VALUE 'T1'.         
HEX01         10  E-FBWHDR-DELIM6            PIC X VALUE X'09'.         
              10  E-FBWHDR-TAMPER-CD-2       PIC XX VALUE 'T2'.         
HEX01         10  E-FBWHDR-DELIM7            PIC X VALUE X'09'.         
              10  E-FBWHDR-FLASH-CARD-ID     PIC X(10)                  
                                             VALUE ' FLASH-ID '.        
HEX01         10  E-FBWHDR-DELIM8            PIC X VALUE X'09'.         
              10  E-FBWHDR-ACCOUNT-NO        PIC X(13)                  
                                             VALUE '  ACCOUNT    '.     
HEX01         10  E-FBWHDR-DELIM9            PIC X VALUE X'09'.         
              10  E-FBWHDR-METER-NO          PIC X(9)                   
                                             VALUE '  METER  '.         
HEX01         10  E-FBWHDR-DELIM10           PIC X VALUE X'09'.         
              10  E-FBWHDR-SERVICE-ADDRESS   PIC X(55)                  
                                             VALUE ' SERVICE ADDRESS '. 
HEX01         10  E-FBWHDR-DELIM11           PIC X VALUE X'09'.         
              10  E-FBWHDR-TOWN              PIC X(30)                  
                                             VALUE ' SERVICE TOWN    '. 
HEX01         10  E-FBWHDR-DELIM12           PIC X VALUE X'09'.         
              10  E-FBWHDR-ZIP               PIC X(5)                   
                                             VALUE 'ZIPCD'.             
HEX01         10  E-FBWHDR-DELIM13           PIC X VALUE X'09'.         
              10  E-FBWHDR-METER-NO-CUR      PIC X(9)                   
                                             VALUE 'CUR METER'.         
HEX01         10  E-FBWHDR-DELIM14           PIC X VALUE X'09'.         
      *                                                                         
      ****************************************************************          
      *  CWS00303  WORKING STORAGE FIELDS                            *          
      ****************************************************************          
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ****************************************************************          
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                      *          
      ****************************************************************          
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM      *          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR CPD09900                                 *          
      ****************************************************************          
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR CPD00074 - NAME AND ADDRESS              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00074                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR JOB PARM                                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR JOB PARM - REPORT DATE                   *          
      ****************************************************************          
      *                                                                         
       COPY CWS00114.                                                           
      *                                                                         
      ****************************************************************          
      * USED WITH THE EMBEDDED SPACES ROUTINE                        *          
      ****************************************************************          
      *                                                                         
       COPY CWS00011.                                                           
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_METER_ATTCHMTS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_MTR_CAP                                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_EQUIPMENT                                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_JOB_PARM                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_MTRD_ENVRNMT                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DECLARATION FOR SQL COMMAND AREA                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_ACCOUNT                                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   CSS_PREMISE                                                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_CUST_PREM_HIST                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_MOVEMENT_HIST                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMVHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_COMPANY                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_NAME                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ADDR_FORMATTED                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ADDR_FREEFORM                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ACCT_BILL_NMES                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATBLNM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ACCT_MISC_INFO                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_CUST_ADDR_XREF                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_NAME_ACCT_XREF                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ZIP_CODE                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   WORKING STORAGE FOR CPD00099 - GET MOST CURRENT            *          
      *        ACCOUNT NUMBER AT A PREMISE                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                 40070000
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT.                 
      *                                                                         
           IF E-FBW09-NO-DATA-LIT = 'No input files to process.'        
              DISPLAY '***********************************'             
              DISPLAY '         0000-MAINLINE           **'             
              DISPLAY '      FCSBW09 FILE IS EMPTY      **'             
              DISPLAY '            CREATING             **'             
              DISPLAY '      NO DATA REPORT RECORD      **'             
              DISPLAY '          FOR FIOBW108           **'             
              DISPLAY '              AND                **'             
              DISPLAY '          ALL 9S RECORD          **'             
              DISPLAY '          FOR FIOBW06            **'             
              DISPLAY '***********************************'             
           ELSE                                                         
              PERFORM 1000-PROCESS-INPUT THRU 1000-EXIT                 
                 UNTIL END-OF-FILE                                      
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   INITIAL ROUTINE - OPEN INPUT AND OUTPUT FILES              *          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT FCSBW09-FILE.                                     
      *                                                                         
           IF FBW09-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '    ABENDING PROGRAM    '                        
              DISPLAY ' FIOBW09 FILE OPEN ERROR '                       
              DISPLAY '  0100-INITIALIZATION '                          
              DISPLAY 'FIOBW09 FILE STATUS = ' WS-FBW09-STATUS          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSBW108-FILE.                                   
      *                                                                         
           MOVE SPACES TO WS-ERT-12A.                                   
      *                                                                         
           PERFORM 1350-CREATE-HEADER THRU 1350-EXIT.                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PROCESS INPUT DATA                                         *          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE SPACES               TO WS-ERT-TYPE                     
                                        WS-ERT-NO                       
                                        WS-DEVICE-NO                    
                                        WS-CODE-UTIL-TYPE.              
           MOVE E-FBW09-ERT-TYPE     TO WS-ERT-TYPE.                    
                                                                        
           IF WS-ELECTRIC-METER                                         
              MOVE WS-ELECTRIC       TO WS-CODE-UTIL-TYPE               
           ELSE                                                         
              IF WS-GAS-METER                                           
                 MOVE WS-GAS         TO WS-CODE-UTIL-TYPE               
              ELSE                                                      
                 PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT            
                 GO TO 1000-EXIT                                        
           END-IF
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW09-ERT-ID(3:8)  TO WS-ERT-8.                       
           MOVE ZEROS                TO WS-ERT-4.                       
      *                                                                         
           MOVE WS-ERT-12A TO MA-DEVICE-NO                              
                              WS-ERT-NO.                                
      *                                                                         
           PERFORM 1200-PROCESS-ERT-ID THRU 1200-EXIT.                  
      *                                                                         
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT.                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   CHECK ERT-ID ON METER_ATTCHMNTS.                           *          
      ****************************************************************          
      *                                                                         
       1200-PROCESS-ERT-ID.                                             
      *                                                                         
           INITIALIZE FIOBW108.                                         
           MOVE ZEROS  TO WS-ACCOUNT-NO.                                
           MOVE WS-YES TO WS-USE.                                       
           MOVE SPACES TO WS-PREM-ADDR                                  
                          WS-PREM-TOWN                                  
                          WS-PREM-ZIP                                   
                          WS-METER-NO                                   
                          WS-METER-NO-CURRENTLY.                        
      *                                                                         
           MOVE WS-COMPANY-PARM TO MA-COMPANY-NO.                       
           PERFORM 7200-CHECK-METER-ATTACHMENT THRU 7200-EXIT.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE MA-METER-NO TO EQ-DEVICE-NO                          
                                  WS-METER-NO                           
              MOVE WS-COMPANY-PARM TO EQ-COMPANY-NO                     
              PERFORM 7300-GET-PREMISE-FROM-EQ THRU 7300-EXIT           
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF EQ-CODE-CRNT-LOC = 'J' OR 'K'                       
                    MOVE EQ-CRNT-LOC-NO TO WS-CPD99-PREMISE-NO          
                    MOVE ZEROS TO WS-CPD99-ACCOUNT-NO                   
      *                                                                         
                    PERFORM 1400-GET-CURRENT-ACCOUNT THRU 1400-EXIT     
      *                                                                         
                    IF WS-PR-STREET = SPACES                            
                       CONTINUE                                         
                    ELSE                                                
                       MOVE WS-CPD99-ACCOUNT-NO   TO WS-ACCOUNT-NO      
                       MOVE WS-PR-STREET          TO WS-PREM-ADDR       
                       MOVE WS-PR-ADDR-CITY-STATE TO WS-PREM-TOWN       
                       MOVE WS-PR-ADDR-ZIP-CODE   TO WS-PREM-ZIP        
                    END-IF                                              
                 ELSE                                                   
                    MOVE ZEROS TO WS-CPD99-ACCOUNT-NO                   
                    MOVE MA-METER-NO TO MV-DEVICE-NO                    
                    MOVE WS-COMPANY-PARM TO MV-COMPANY-NO               
                    PERFORM 7325-GET-PREMISE-FROM-MV THRU 7325-EXIT     
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       MOVE MV-LOC-NO TO WS-CPD99-PREMISE-NO            
                       PERFORM 1400-GET-CURRENT-ACCOUNT THRU 1400-EXIT  
                       IF WS-PR-STREET = SPACES                         
                          CONTINUE                                      
                       ELSE                                             
                          MOVE WS-PR-STREET          TO WS-PREM-ADDR    
                          MOVE WS-PR-ADDR-CITY-STATE TO WS-PREM-TOWN    
                          MOVE WS-PR-ADDR-ZIP-CODE   TO WS-PREM-ZIP     
                       END-IF                                           
      *                                                                         
                       IF WS-CPD99-ACCOUNT-NO > ZEROS                   
                          MOVE WS-CPD99-ACCOUNT-NO TO MN-ACCOUNT-NO     
                                                      WS-ACCOUNT-NO     
                          PERFORM 7335-GET-MTRENV THRU 7335-EXIT        
                          IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL    
                             MOVE MN-METER-NO TO WS-METER-NO-CURRENTLY  
                          ELSE                                          
                             MOVE WS-NOT TO WS-METER-NO-CURRENTLY       
                          END-IF                                        
                       END-IF                                           
                    ELSE                                                
                       DISPLAY 'NOT FOUND ON CSS_MOVEMENT_HIST = '      
                       MV-DEVICE-NO ' UTIL TYPE = ' WS-CODE-UTIL-TYPE   
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'NOT FOUND ON CSS_EQUIPMENT = ' EQ-DEVICE-NO   
                          ' UTIL TYPE = ' WS-CODE-UTIL-TYPE             
              END-IF                                                    
           ELSE                                                         
              DISPLAY 'NOT FOUND ON CSS_METER_ATTCHMTS = ' MA-DEVICE-NO 
                          ' UTIL TYPE = ' WS-CODE-UTIL-TYPE             
              MOVE WS-NO TO WS-USE                                      
           END-IF.                                                      
      *                                                                         
           IF WS-USE = WS-YES                                           
              PERFORM 1300-CREATE-OUTFILE THRU 1300-EXIT                
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PREPARE FOR OUTPUT FILE FIOBW108.                          *          
      ****************************************************************          
      *                                                                         
       1300-CREATE-OUTFILE.                                             
      *                                                                         
           MOVE E-FBW09-ERT-ID        TO E-FBW108-ERT-ID.               
           MOVE E-FBW09-ERT-READING   TO E-FBW108-ERT-READING.          
           MOVE E-FBW09-DATE-READ     TO E-FBW108-DATE-READ.            
           MOVE E-FBW09-TIME-READ     TO E-FBW108-TIME-READ.            
           MOVE E-FBW09-ERT-TYPE      TO E-FBW108-ERT-TYPE.             
           MOVE E-FBW09-TAMPER-CD-1   TO E-FBW108-TAMPER-CD-1.          
           MOVE E-FBW09-TAMPER-CD-2   TO E-FBW108-TAMPER-CD-2.          
           MOVE E-FBW09-FLASH-CARD-ID TO E-FBW108-FLASH-CARD-ID.        
      *                                                                         
           IF WS-PREM-ADDR = SPACES                                     
              MOVE SPACES TO E-FBW108-SERVICE-ADDRESS                   
                             E-FBW108-TOWN                              
                             E-FBW108-ZIP                               
           ELSE                                                         
              MOVE WS-PREM-ADDR  TO E-FBW108-SERVICE-ADDRESS            
              MOVE WS-PREM-TOWN  TO E-FBW108-TOWN                       
              MOVE WS-PREM-ZIP   TO E-FBW108-ZIP                        
           END-IF.                                                      
      *                                                                         
           MOVE WS-ACCOUNT-NO  TO E-FBW108-ACCOUNT-NO.                  
      *                                                                         
           MOVE WS-METER-NO    TO E-FBW108-METER-NO.                    
           MOVE WS-METER-NO-CURRENTLY TO E-FBW108-METER-NO-CUR.         
      *                                                                         
           MOVE WS-DELIM  TO E-FBW108-DELIM1                            
                             E-FBW108-DELIM2                            
                             E-FBW108-DELIM3                            
                             E-FBW108-DELIM4                            
                             E-FBW108-DELIM5                            
                             E-FBW108-DELIM6                            
                             E-FBW108-DELIM7                            
                             E-FBW108-DELIM8                            
                             E-FBW108-DELIM9                            
                             E-FBW108-DELIM10                           
                             E-FBW108-DELIM11                           
                             E-FBW108-DELIM12                           
                             E-FBW108-DELIM13                           
                             E-FBW108-DELIM14.                          
      *                                                                         
           PERFORM 8200-WRITE-FIOBW108 THRU 8200-EXIT.                  
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   WRITE OUR 1 HEADER RECORD.                                 *          
      ****************************************************************          
      *                                                                         
       1350-CREATE-HEADER.                                              
      *                                                                         
           MOVE HEADER-RECORD TO FIOBW108.                              
      *                                                                         
           PERFORM 8200-WRITE-FIOBW108 THRU 8200-EXIT.                  
      *                                                                         
       1350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   GET THE MOST CURRENT ACCOUNT FOR THE PREMISE NUMBER        *          
      *   AND SERVICE ADDRESS.                                       *          
      ****************************************************************          
      *                                                                         
       1400-GET-CURRENT-ACCOUNT.                                        
      *                                                                         
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
      *                                                                         
           IF WS-CPD99-ACCOUNT-NO = ZEROS                               
              DISPLAY '******************************************'      
              DISPLAY ' 1400-GET-CURRENT-ACCOUNT                *'      
              DISPLAY ' DID NOT FIND THE MOST CURRENT ACCOUNT   *'      
              DISPLAY ' FOR PREMISE NUMBER = ' WS-CPD99-PREMISE-NO      
              DISPLAY '******************************************'      
           ELSE                                                         
              MOVE WS-CPD99-ACCOUNT-NO TO AT-ACCOUNT-NO                 
              MOVE ZEROS               TO AT-ADDRESS-ID                 
              PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT             
           END-IF.                                                      
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES 4000-MAIL-NAME-ADDRESS                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00074                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES 6010-REDUCE-EMBEDDED-SPACES                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6990-FETCH-CUR-ACCOUNT                                      *          
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6995-CPD99-ERROR-ROUTINE IS PERFORMED IN CPD00099 WHEN      *          
      *  THERE IS A PROBLEM.                                         *          
      ****************************************************************          
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
A05136     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A05136        DISPLAY '*************PCSBW108************'               
A05136        DISPLAY '* ERROR PERFORMING - 6990-FETCH-CUR-ACCOUNT '    
A05136        DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1              
A05136        DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE            
A05136        DISPLAY '* INFORMATIONAL ONLY  *'                         
A05136        DISPLAY '*************PCSBW108************'               
A05136     ELSE                                                         
              DISPLAY '*************PCSBW108************'               
              DISPLAY '* ERROR PERFORMING - 6990-FETCH-CUR-ACCOUNT '    
              DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1              
              DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE            
              DISPLAY '* PROGRAM ABENDING...           *'               
              DISPLAY '*************PCSBW108************'               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
A05136     END-IF.                                                      
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   READ INPUT FILE                                            *          
      ****************************************************************          
      *                                                                         
       7000-READ-INPUT-FILE.                                            
      *                                                                         
           READ FCSBW09-FILE                                            
                     AT END MOVE WS-YES TO WS-EOF-FLAG.                 
      *                                                                         
           IF FBW09-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              IF END-OF-FILE                                            
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '*************************************'        
                 DISPLAY '**   PCSBW108 PROCESSING ERROR     **'        
                 DISPLAY '**   ABEND IN PARAGRAPH 7000       **'        
                 DISPLAY '**  READ STATUS   = ' WS-FBW09-STATUS         
                 DISPLAY '*************************************'        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE METER NUMBER FROM CSS_METER_ATTCHMTS              *          
      ****************************************************************          
      *                                                                         
       7200-CHECK-METER-ATTACHMENT.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) METER_NO                                           
                INTO :MA-METER-NO                                       
               FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                 
                   ,CSS_MTR_ATT_TYPE   N5 WITH(READUNCOMMITTED)                 
              WHERE MA.COMPANY_NO            = :MA-COMPANY-NO           
               AND  MA.CODE_UTIL_TYPE        = :WS-CODE-UTIL-TYPE       
               AND  MA.DEVICE_NO             = :MA-DEVICE-NO            
               AND  MA.CODE_UTIL_TYPE        = N5.CODE_UTIL_TYPE        
               AND  MA.CODE_ATT_TYPE         = N5.CODE_ATT_TYPE         
               AND  N5.DEVICE_TYPE_CD        = 'A'                      
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_NO                                                   
MFA-TR*         INTO :MA-METER-NO                                               
MFA-TR*        FROM CSS_METER_ATTCHMTS MA                                       
MFA-TR*            ,CSS_MTR_ATT_TYPE   N5                                       
MFA-TR*       WHERE MA.COMPANY_NO            = :MA-COMPANY-NO                   
MFA-TR*        AND  MA.CODE_UTIL_TYPE        = :WS-CODE-UTIL-TYPE               
MFA-TR*        AND  MA.DEVICE_NO             = :MA-DEVICE-NO                    
MFA-TR*        AND  MA.CODE_UTIL_TYPE        = N5.CODE_UTIL_TYPE                
MFA-TR*        AND  MA.CODE_ATT_TYPE         = N5.CODE_ATT_TYPE                 
MFA-TR*        AND  N5.DEVICE_TYPE_CD        = 'A'                              
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '      CSS_METER_ATTCHMTS   '                    
               DISPLAY '   7200-CHECK-METER-ATTACHMENT '                
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' ERT-ID NUMBER  = ' MA-DEVICE-NO                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE PREMISE NUMBER FROM CSS_EQUIPMENT                 *          
      ****************************************************************          
      *                                                                         
       7300-GET-PREMISE-FROM-EQ.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) CODE_CRNT_LOC,
              CRNT_LOC_NO                                        
                INTO :EQ-CODE-CRNT-LOC                                  
                    ,:EQ-CRNT-LOC-NO                                    
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
                WHERE COMPANY_NO     = :EQ-COMPANY-NO                   
                AND   DEVICE_NO      = :EQ-DEVICE-NO                    
                AND   CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_CRNT_LOC                                              
MFA-TR*             ,CRNT_LOC_NO                                                
MFA-TR*         INTO :EQ-CODE-CRNT-LOC                                          
MFA-TR*             ,:EQ-CRNT-LOC-NO                                            
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*         WHERE COMPANY_NO     = :EQ-COMPANY-NO                           
MFA-TR*         AND   DEVICE_NO      = :EQ-DEVICE-NO                            
MFA-TR*         AND   CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '      CSS_EQUIPMENT FETCH  '                    
               DISPLAY '      7300-GET-PREMISE-FROM-EQ '                
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' METER NO       = ' EQ-DEVICE-NO                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE PREMISE NUMBER FROM CSS_MOVEMENT_HIST             *          
      ****************************************************************          
      *                                                                         
       7325-GET-PREMISE-FROM-MV.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) LOC_NO                                            
                INTO :MV-LOC-NO                                         
                FROM CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                    
                WHERE COMPANY_NO     = :MV-COMPANY-NO                   
                 AND  DEVICE_NO      = :MV-DEVICE-NO                    
                 AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                 AND  CODE_CRNT_LOC  IN ('J', 'K')                      
                 AND  LOC_NO         > 0                                
           ORDER BY MOVE_NO DESC                                        
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  LOC_NO                                                    
MFA-TR*         INTO :MV-LOC-NO                                                 
MFA-TR*         FROM CSS_MOVEMENT_HIST                                          
MFA-TR*         WHERE COMPANY_NO     = :MV-COMPANY-NO                           
MFA-TR*          AND  DEVICE_NO      = :MV-DEVICE-NO                            
MFA-TR*          AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*          AND  CODE_CRNT_LOC  IN ('J', 'K')                              
MFA-TR*          AND  LOC_NO         > 0                                        
MFA-TR*    ORDER BY MOVE_NO DESC                                                
MFA-TR*    FETCH FIRST ROW ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       CSS_MOVEMENT_HIST '                      
               DISPLAY '      7325-GET-PREMISE-FROM-MV '                
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' METER NO       = ' MV-DEVICE-NO                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE ACTUAL METER NUMBER ON CSS_MTRD_ENVRNMT           *          
      ****************************************************************          
      *                                                                         
       7335-GET-MTRENV.                                                 
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) METER_NO,
              MTR_READ_SOURCE_CD                                 
                INTO :MN-METER-NO                                       
                    ,:MN-MTR-READ-SOURCE-CD                             
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                   
                 AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                 AND  CODE_METER_STATUS <> 'K'                          
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_NO                                                   
MFA-TR*             ,MTR_READ_SOURCE_CD                                         
MFA-TR*         INTO :MN-METER-NO                                               
MFA-TR*             ,:MN-MTR-READ-SOURCE-CD                                     
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                           
MFA-TR*          AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*          AND  CODE_METER_STATUS = 'K'                                  
MFA-TR*    FETCH FIRST ROW ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '  ABENDING PROGRAM '                            
               DISPLAY '  CSS_MTRD_ENVRNMT '                            
               DISPLAY '  7335-GET-MTRENV '                             
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' ACCOUNT-NO     = ' MN-ACCOUNT-NO               
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7335-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7600-START-FCSJC01                                          *          
      *  7610-READ-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  WRITE FIOBW108 RECORD                                     **          
      ****************************************************************          
      *                                                                         
       8200-WRITE-FIOBW108.                                             
      *                                                                         
           WRITE FIOBW108.                                              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   NORMAL JOB TERMINATION                                     *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBW108-FILE                                          
                 FCSBW09-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  THIS INCLUDES 9700-PROCESS-ABEND                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD0023B                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  9900-ABEND                                                  *          
      *  THIS INCLUDES THE DB2 SQL ABEND MODULE AND ALSO PERFORMS    *          
      *  9000-TERMINATE.  THEN IT MOVES 12 TO RETURN CODE.           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
