       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSBW107.                                         
       DATE-WRITTEN.  AUGUST 99.                                        
       DATE-COMPILED.                                                   
       AUTHOR.        CBSIMDS                                           
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS       REASON                            **         
      **                                                             **         
      ** 08/99      CBSI, MDS      DEVELOPMENT OF NEW PROGRAM        **         
      **                                                             **         
BGBG01** 11/15/01   GAUSE          ADDED DISPLAY AFTER  FINALED_TODAY**         
BGBG01**                           CUSSOR OF KEY INFO SO THAT YOU    **         
BGBG01**                           WILL KNOW WHAT ACCOUNT CAUSES     **         
BGBG01**                           ABEND                             **         
      **                                                             **         
C35227** 03/08/07   DB41297        PERFORMANCE IMPROVEMENTS AND      **         
C35227**                           ABEND REDUCTION.                  **         
      **                                                             **         
A04860**                                                             ** 02431000
A04860**2014-04-02  MR7E794        LOAD DIRECTLY CSS_WQ_ITEMS INSTEAD**         
A04860**            ACT030         OF CSS_WQ_ITEMS_MF BY CALLING SUB **         
A04860**                           PROGRAM SCSCB077                  **         
      **                                                             **         
ACT260**2016-08-18  VIJAY          REMOVE DCLGEN TBMFWQ              **         
      *****************************************************************         
      *                   PCSBW107   NARRATIVE                        *         
      *                                                               *         
      * THIS PROGRAM SELECTS ALL THE ACCOUNT NUMBERS WHICH HAVE       *         
      * SPECIAL READ INSTRUCTIONS AND WHICH ARE FINALLED AND CREATES  *         
      * WORK QUEUE FOR EACH ACCOUNT.                                  *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                9000 - 9799     TERMINATION MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW107'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-PREV-BUS-DAY-FLAG             PIC X(01)  VALUE 'N'.    
              88 PREV-BUS-DAY-FOUND                       VALUE 'Y'.    
           05 WS-HOLIDAY-EXISTS                PIC X(01).               
              88 HOLIDAY-EXISTS-NO                        VALUE 'N'.    
              88 HOLIDAY-EXISTS-YES                       VALUE 'Y'.    
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-N                             PIC X(01)  VALUE 'N'.    
           05 WS-Y                             PIC X(01)  VALUE 'Y'.    
           05 WS-B                             PIC X(01)  VALUE 'B'.    
           05 WS-I                             PIC X(01)  VALUE 'I'.    
           05 WS-C                             PIC X(01)  VALUE 'C'.    
           05 WS-SPACES                        PIC X(01)  VALUE SPACES. 
           05 WS-ONE                           PIC 9(01)  VALUE 1.      
           05 WS-79                            PIC 9(02)  VALUE 79.     
           05 WS-88                            PIC 9(02)  VALUE 88.     
      *                                                                         
       01  WS-VARIABLES.                                                
           05 PROGRAM-NAME                     PIC X(08)  VALUE         
              'PCSBW107'.                                               
           05 WS-PGRMNAME REDEFINES PROGRAM-NAME                        
                                               PIC X(08).               
           05 RS-RETURN-CODE                   PIC S9(9)  VALUE         
              +000 COMP.                                                
           05 RS-RETURN-CODE-DISP              PIC S9(9)  VALUE         
              +000 COMP.                                                
           05 WS-SQL-RETURN                    PIC -ZZZZZZZZ9.          
           05 WS-PREV-BUSINESS-DAY             PIC X(10).               
           05 WS-DAY-OF-WEEK                   PIC S9(04) COMP.         
           05 WS-SUNDAY                        PIC S9(04) COMP          
                                                          VALUE +1.     
           05 WS-SATURDAY                      PIC S9(04) COMP          
                                                          VALUE +7.     
           05 WS-WQ-CATEGORY                   PIC 9(04)  VALUE 171.    
           05 WS-CURRENT-DATE                  PIC X(10)  VALUE SPACES. 
           05 WS-COMMENTS-LEN                  PIC S9(04) USAGE COMP.   
           05 WS-COMMENTS-TEXT1                PIC X(250) VALUE         
              'ACCOUNT FINALED,PLEASE VERIFY WHETHER THE SPECIAL READ IN        
      -       'STRUCTIONS STILL APPLY'.                                         
           05 WS-COMMENTS-TEXT2                PIC X(250) VALUE         
              'CUSTOMER CHANGE OCCURRED,PLEASE VERIFY WHETHER THE SPECIA        
      -       'L READ INSTRUCTIONS STILL APPLY'.                                
A04860     05  SCSCB077                     PIC X(08) VALUE 'SCSCB077'. 
A04860 01  WS-CURR-TS.                                                  
A04860     05  WS-CURR-DATE-TS              PIC X(10).                  
A04860     05  WS-CURR-TS-REF               PIC X(16)                   
A04860                                    VALUE '-00.00.00.000000'.     
A04860******************************************************************        
A04860* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
A04860******************************************************************        
A04860*                                                                         
A04860     EXEC SQL                                                             
A04860        INCLUDE CWS00077                                                  
A04860     END-EXEC.                                                            
A04860*                                                                         
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_PREMISE.                                                         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBPREM                                                     
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *  CSS_ACCOUNT                                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *  CSS_JOB_PARM                                                           
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      **                                                                        
      ******************************************************************        
      *  CSS_HOLIDAY                                                            
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
      **                                                                        
      ******************************************************************        
      *  CSS_MTRD_ENVRNMT                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      *                                                                         
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      *                                                                         
      * -- USED TO GET COMMON DATE FROM JOB-PARM TABLE                          
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
      *                                                                         
      *****************************************************************         
      * WORKING STORAGE FOR CPD00099                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO SELECT ACCOUNT_NO, LOCAL_OFFICE,      **         
      ** PREMISE_NO AND CUSTOMER_NO FROM CSS_ACCOUNT AND CSS_PREMISE **         
      ** FOR THE FINALLED ACCOUNTS AND FOR THE ACCOUNTS HAVING       **         
      ** SPECIAL READ INSTRUCTIONS                                   **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
           DECLARE FINALED_TODAY  CURSOR FOR                            
             SELECT  AT.ACCOUNT_NO                                      
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.PREMISE_NO                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.COMPANY_NO                                      
               FROM  CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                
                    ,CSS_PREMISE        PR WITH(READUNCOMMITTED)                
C35227        WHERE  AT.CODE_ACCT_STAT  = 'B'                           
C35227          AND  CAST(AT.ACCT_FINALED_DT AS DATE) > 
              IIF(TRY_CONVERT(DATE, :WS-PREV-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-BUSINESS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSINESS-DAY) )   
C35227          AND  PR.PREMISE_NO = AT.PREMISE_NO                      
C35227          AND  PR.SPCL_READ_INSTR >  ' '                          
C35227        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE FINALED_TODAY  CURSOR FOR                                    
MFA-TR*      SELECT  AT.ACCOUNT_NO                                              
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*        FROM  CSS_ACCOUNT        AT                                      
MFA-TR*             ,CSS_PREMISE        PR                                      
MFA-TR*       WHERE  AT.CODE_ACCT_STAT  = 'B'                                   
MFA-TR*         AND  DATE(AT.ACCT_FINALED_DT) > :WS-PREV-BUSINESS-DAY           
MFA-TR*         AND  PR.PREMISE_NO = AT.PREMISE_NO                              
MFA-TR*         AND  PR.SPCL_READ_INSTR >  ' '                                  
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALISATION         THRU 0100-EXIT.          
      *                                                                         
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
      *                                                                         
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   GETS THE CURRENT DATE AND DATE FROM JOB-PARM TABLE           *        
      ******************************************************************        
       0100-INITIALISATION.                                             
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '                  TO WS-PGRMNAME           
              MOVE SPACES                      TO WS-INPUT-AREA         
              MOVE SPACES                      TO                       
                                                 WS-INPUT-DATA-BREAKDOWN
              PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT           
              MOVE 'PCSBW107'                  TO WS-PGRMNAME           
           END-IF.                                                      
           MOVE WS-INPUT-RUN-DATE              TO WS-PREV-BUSINESS-DAY. 
           PERFORM 7300-GET-PREV-BUSINESS-DAY  THRU 7300-EXIT           
                   UNTIL PREV-BUS-DAY-FOUND.                            
           PERFORM 7200-GET-CURRENT-DATE       THRU 7200-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PASSES CONTROL TO OPEN , FETCH AND CLOSE THE CURSOR           **        
      * FINALED_TODAY CURSOR                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7000-OPEN-FINALED-TODAY-CUR  THRU 7000-EXIT.         
           PERFORM 7010-FETCH-FINALED-TODAY-CUR THRU 7010-EXIT.         
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               DISPLAY '********** PCSBW107 *********************'      
               DISPLAY '* NO ROWS FETCHED                       *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '********** PCSBW107 *********************'      
               PERFORM 7020-CLOSE-FINALED-TODAY-CUR                     
                                                THRU 7020-EXIT          
               GO TO 1000-EXIT                                          
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               PERFORM 2000-PROCESS-RECORD      THRU 2000-EXIT          
               PERFORM 7010-FETCH-FINALED-TODAY-CUR                     
                                                THRU 7010-EXIT          
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7020-CLOSE-FINALED-TODAY-CUR                         
                                                THRU 7020-EXIT.         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GETS THE LATEST ACCOUNT FOR THE PREMISE AND CREATES A ROW IN   *        
      * THE WORK QUEUE                                                 *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-RECORD.                                             
      *                                                                         
           MOVE AT-PREMISE-NO                   TO WS-CPD99-PREMISE-NO. 
           PERFORM 6990-FETCH-CUR-ACCOUNT       THRU 6990-EXIT.         
           IF WS-CPD99-ACCOUNT-NO = AT-ACCOUNT-NO                       
              PERFORM 2100-MOVE-WQ-DETAILS      THRU 2100-EXIT          
              MOVE AT-ACCOUNT-NO                TO MN-ACCOUNT-NO        
              PERFORM 7100-UPDATE-MTRD-ENVRNMT  THRU 7100-EXIT          
           ELSE                                                         
              PERFORM 7400-GET-ACCOUNT-DETAILS  THRU 7400-EXIT          
              PERFORM 2100-MOVE-WQ-DETAILS      THRU 2100-EXIT          
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * MOVES ALL THE DETAILS FOR INSERTING A ROW IN THE WORK QUEUE    *        
      ******************************************************************        
      *                                                                         
       2100-MOVE-WQ-DETAILS.                                            
      *                                                                         
A04860     INITIALIZE CWS00077-FIELDS.                                  
A04860     MOVE WS-CPD99-ACCOUNT-NO             TO WS-77-ACCOUNT-NO.    
A04860     MOVE AT-CUSTOMER-NO                  TO WS-77-CUSTOMER-NO.   
A04860     MOVE AT-PREMISE-NO                   TO WS-77-PREMISE-NO.    
A04860     MOVE AT-LOCAL-OFFICE                 TO WS-77-LOCAL-OFFICE.  
A04860     MOVE WS-WQ-CATEGORY                  TO WS-77-CATEGORY-ID.   
A04860     MOVE WS-ONE                          TO WS-77-ROUTE-CATEGORY.
A04860     MOVE WS-N                            TO WS-77-PRIORITY.      
A04860     MOVE WS-CURRENT-DATE                 TO WS-CURR-DATE-TS.     
A04860     MOVE WS-CURR-TS                      TO WS-77-DATE-CREATED   
A04860                                             WS-77-DATE-REQUIRED. 
           IF WS-CPD99-ACCOUNT-NO = AT-ACCOUNT-NO                       
              MOVE WS-79                        TO WS-COMMENTS-LEN      
A04860        MOVE WS-COMMENTS-TEXT1            TO WS-77-COMMENTS-TEXT  
A04860        MOVE WS-COMMENTS-LEN              TO WS-77-COMMENTS-LEN   
           ELSE                                                         
              MOVE WS-88                        TO WS-COMMENTS-LEN      
A04860        MOVE WS-COMMENTS-TEXT2            TO WS-77-COMMENTS-TEXT  
A04860        MOVE WS-COMMENTS-LEN              TO WS-77-COMMENTS-LEN   
           END-IF.                                                      
A04860     MOVE SPACES                          TO WS-77-RESP-AREA-ID.  
A04860     MOVE ZERO                            TO WS-77-FREE-FORM-LEN. 
A04860     MOVE LOW-VALUES                      TO WS-77-FREE-FORM-TXT. 
A04860     MOVE WS-PGRMNAME                     TO WS-77-CREATED-BY.    
           PERFORM 8895-INSERT-WORK-QUEUE       THRU 8895-EXIT.         
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * COPY BOOKS FOR JOB PARM TABLE                               **          
      ****************************************************************          
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6990-FETCH-CUR-ACCOUNT                                         *        
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *        
      ******************************************************************        
           EXEC SQL                                                             
      *        INCLUDE CPD00099                                                 
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           DISPLAY '***************PCSBW107**********************'      
           DISPLAY '* ERROR IN PARA ', ACTIVE-PARAGRAPH                 
           DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO               
           DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE               
           DISPLAY '***************PCSBW107**********************'      
           PERFORM 9900-ABEND                   THRU 9900-EXIT.         
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  DB2 CALLS                                                   **        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      * OPENS FINALLED_TODAY CURSOR                                             
      ******************************************************************        
      *                                                                         
       7000-OPEN-FINALED-TODAY-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
              OPEN FINALED_TODAY                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSBW107  ABORT **************'      
               DISPLAY '* 7000-OPEN-FINALED-TODAY-CURSOR        *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSBW107  ABORT **************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCHES ACCOUNT-NO, PREMISE-NO,LOCAL-OFFICE,COMPANY-NO AND     *        
      * CUSTOMER-NO                                                    *        
      ******************************************************************        
       7010-FETCH-FINALED-TODAY-CUR.                                    
      *                                                                         
           EXEC SQL                                                     
              FETCH FINALED_TODAY                                       
               INTO  :AT-ACCOUNT-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-PREMISE-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
BGBG01     DISPLAY ' DATA RETD IN P7010 FINALED_TODAY CURSOR '          
BGBG01            AT-ACCOUNT-NO     ' '                                 
BGBG01            AT-LOCAL-OFFICE   ' '                                 
BGBG01            AT-PREMISE-NO     ' '                                 
BGBG01            AT-CUSTOMER-NO    ' '                                 
BGBG01            AT-COMPANY-NO.                                        
                                                                        
                                                                        
                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSBW107 ABORT ***************'      
               DISPLAY '* 7010-FETCH-FINALED-TODAY-CURSOR       *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSBW107 ABORT ***************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES FINALLED_TODAY CURSOR                                   *        
      ******************************************************************        
       7020-CLOSE-FINALED-TODAY-CUR.                                    
      *                                                                         
           EXEC SQL                                                     
              CLOSE FINALED_TODAY                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSBW107 ABORT ***************'      
               DISPLAY '* 7020-CLOSE-FINALED-TODAY-CURSOR       *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSBW107 ABORT ***************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * UPDATES THE CSS_MTRD_ENVRNMT TABLE IF THE ACCOUNT IS THE       *        
      * LATEST IN THE PREMISE                                          *        
      ******************************************************************        
      *                                                                         
       7100-UPDATE-MTRD-ENVRNMT.                                        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_MTRD_ENVRNMT                                  
                   SET MTR_READ_SOURCE_CD = 'I'                         
               WHERE ACCOUNT_NO           = :MN-ACCOUNT-NO              
                   AND MTR_READ_SOURCE_CD = 'C'                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSBW107 ABORT ***************'      
               DISPLAY '*  7100-UPDATE-MTRD-ENVRNMT             *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSBW107 ABORT ***************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GETS THE CURRENT DATE                                                   
      ******************************************************************        
      *                                                                         
       7200-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
C35227         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE =                                           
MFA-TR*             CURRENT DATE                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSBW107 ABORT ***************'      
               DISPLAY '*  7200-GET-CURRENT-DATE                *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSBW107 ABORT ***************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GETS THE PREVIOUS BUSINESS DAY                                          
      ******************************************************************        
      *                                                                         
       7300-GET-PREV-BUSINESS-DAY.                                      
      *                                                                         
           EXEC SQL                                                     
C35227       SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                  :WS-PREV-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-BUSINESS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSINESS-DAY) ) ),
              (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                  :WS-PREV-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-BUSINESS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSINESS-DAY) ) )) -       
C35227               CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                  :WS-PREV-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-BUSINESS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSINESS-DAY) ) ))/7*7)+1
            INTO
              :WS-PREV-BUSINESS-DAY,
              :WS-DAY-OF-WEEK  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-PREV-BUSINESS-DAY =                                        
MFA-TR*           DATE(:WS-PREV-BUSINESS-DAY) - 1 DAYS                          
MFA-TR*         ,:WS-DAY-OF-WEEK       =                                        
MFA-TR*             (DAYS(DATE(:WS-PREV-BUSINESS-DAY) - 1 DAYS) -               
MFA-TR*              DAYS(DATE(:WS-PREV-BUSINESS-DAY) - 1 DAYS)/7*7)+1          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
              DISPLAY '******************************************'      
              DISPLAY '**   PCSBW107 PROCESSING ERROR          **'      
              DISPLAY '**-------------------------------       **'      
              DISPLAY '**   7300-GET-PREV-BUSINESS-DAY:'                
              DISPLAY '**   COULD NOT FIND PREV'                        
              DISPLAY '**   CALENDAR DAY'                               
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      ***  CHECK TO SEE IF IT IS A WEEKEND...                                   
           IF WS-DAY-OF-WEEK NOT EQUAL WS-SATURDAY AND                  
              WS-DAY-OF-WEEK NOT EQUAL WS-SUNDAY                        
                                                                        
              MOVE WS-PREV-BUSINESS-DAY        TO J8-HOLIDAY-DT         
              MOVE WS-N                        TO WS-HOLIDAY-EXISTS     
                                                                        
      ***  ...IF NOT A WEEKEND, THEN CHECK TO SEE IF IT IS A HOLID              
              EXEC SQL                                                  
                  SELECT 'Y'                                            
                  INTO   :WS-HOLIDAY-EXISTS                             
                  FROM   CSS_HOLIDAY WITH(READUNCOMMITTED)                      
                  WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, 
                                                         :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                    
C35227                                                           
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT 'Y'                                                    
MFA-TR*           INTO   :WS-HOLIDAY-EXISTS                                     
MFA-TR*           FROM   CSS_HOLIDAY                                            
MFA-TR*           WHERE  HOLIDAY_DT = :J8-HOLIDAY-DT                            
MFA-TR*           WITH UR                                                       
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              IF SQLCODE EQUAL SUCCESSFUL-CALL                          
                 CONTINUE                                               
              ELSE                                                      
                 IF SQLCODE NOT EQUAL NOT-FOUND                         
                    DISPLAY '************************************'      
                    DISPLAY '**  PCSBW107  PROCESSING ERROR    **'      
                    DISPLAY '**--------------------------------**'      
                    DISPLAY '**   7300-GET-PREV-BUSINESS-DAY:'          
                    DISPLAY '**   ERROR WHEN CHECKING TO SEE'           
                    DISPLAY '**   IF THE PREV DAY IS A HOLIDAY'         
                    DISPLAY '************************************'      
                    PERFORM 9900-ABEND         THRU 9900-EXIT           
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              IF HOLIDAY-EXISTS-NO                                      
                 MOVE WS-Y                     TO WS-PREV-BUS-DAY-FLAG  
              ELSE                                                      
                 MOVE WS-N                     TO WS-PREV-BUS-DAY-FLAG  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7400-GET-ACCOUNT-DETAILS.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT CUSTOMER_NO                                       
                     ,PREMISE_NO                                        
                     ,LOCAL_OFFICE                                      
                     ,COMPANY_NO                                        
               INTO  :AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-COMPANY-NO                                     
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
               WHERE ACCOUNT_NO = :WS-CPD99-ACCOUNT-NO                  
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*              ,PREMISE_NO                                                
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*        INTO  :AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*        WHERE ACCOUNT_NO = :WS-CPD99-ACCOUNT-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSBW107 ABORT ***************'      
               DISPLAY '*  7400-GET-ACCOUNT-DETAILS             *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
BGBG01         DISPLAY '* ACCT USED IN CALL ' WS-CPD99-ACCOUNT-NO       
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSBW107 ABORT ***************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 8895-INSERT-WORK-QUEUE                                     **          
A04860**  CALL SUB PROGRAM SCSCB077 FOR INSERTING WORK QUEUES INTO  **  28610000
A04860**  CSS_WQ_ITEMS                                              **  28620000
      ****************************************************************          
      *                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860                                                                  
A04860     CALL SCSCB077  USING   CWS00077-FIELDS,                      
A04860                            ABEND-FILE,                           
A04860                            RS-RETURN-CODE.                       
A04860*                                                                         
A04860     MOVE RS-RETURN-CODE          TO WS-ACTIVE-RETURN-CODE        
A04860                                     WS-SQL-RETURN.               
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'COMMENTS        ' WS-77-COMMENTS                 
A04860*       DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE                  
A04860        DISPLAY 'SQL RETURN CODE ' WS-SQL-RETURN                  
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860                                                                  
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
A04860                                                                  
      *                                                                         
      ****************************************************************          
      *  TERMINATE PARA FOR CPD09900                                **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
       COPY CPD0023B.                                                           
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      ******************************************************************        
      ******             END OF THE PROGRAM                    *********        
      ******************************************************************        
