       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW106.                                        
       DATE-WRITTEN.   JUNE 2013.                                       
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **    DATE    INITIALS    REASON                              **          
      **  ________  ________    ___________________________________ **          
      **  06-04-13  SS95855     A#04684 New Program                 **          
A04880**  01-22-14  DB41297     ADD COMMITS TO PREVENT LOCK LIMIT   **          
ACT016**                        OVERFLOW CAUSING A -904             **          
      **                                                            **          
A04684**  08-01-15  SS95855     ACT003 ADD FLASH CARD ID            **          
      ****************************************************************          
      *                       PCSBW106 NARRATIVE                     *  00230000
      *                  ___________________________                 *  00240000
      *                                                              *  00310000
      * The program inserts reads received from FCS untattended      *  00310000
      * Scheduler in to OFFCYCLE reads table. These reads can be     *          
      * utilized by AROP. The Input file is formatted by PCSBW105    *          
      * and Sorted to retain the latest read for the Meter/ERT. It's *          
      * then sorted again to remove any duplicates.                  *          
      ****************************************************************  00320000
           REMARKS.                                                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSB105O.                                                   00410000
      *                                                                 CSS00070
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDB105O.                                                           
       COPY FIOB105O.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW106'.
MSQ017     COPY MFASQLM.
      *                                                                         
           EXEC SQL                                                     00540000
              INCLUDE SQLCA                                             00550000
           END-EXEC.                                                    00560000
      *                                                                         
           EXEC SQL                                                     00540000
              INCLUDE FIOCA00                                           00550000
           END-EXEC.                                                    00560000
      *                                                                         
           EXEC SQL                                                     00600000
              INCLUDE FIOJC01                                           00610000
           END-EXEC.                                                    00620000
      *                                                                         
      ***************************                                               
      *    CSS_JOB_PARM, G6                                                     
      ***************************                                               
           EXEC SQL                                                     00600000
              INCLUDE TBJBPARM                                          00610000
           END-EXEC.                                                    00620000
      *                                                                         
      ***************************                                               
      *    CSS_OFFCYCLE_READS, 3B                                               
      ***************************                                               
           EXEC SQL                                                     00600000
              INCLUDE TBOFFCYR                                          00610000
           END-EXEC.                                                    00620000
      *                                                                         
       COPY CWS00010.                                                           
       COPY CWS00039.                                                           
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00038.                                                           
      *                                                                         
       01 WS-WORK-VARIABLES.                                            
          05 WS-START                       PIC X(40) VALUE             
               'WORKING STORAGE FOR PCSBW106 STARTS HERE'.              
      *                                                                         
       01 WS-SWITCH.                                                    
          05 WS-FCSB105O-STATUS             PIC X(02) VALUE '00'.       
             88 FCSB105O-SUCCESSFUL                   VALUE '00'.       
          05 WS-END-RECORD-REACHED          PIC X(01) VALUE 'N'.        
             88 END-RECORD-REACHED                    VALUE 'Y'.        
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-PGRMNAME                    PIC X(08) VALUE 'PCSBW106'. 
          05 WS-N                           PIC X(01) VALUE 'N'.        
          05 WS-Y                           PIC X(01) VALUE 'Y'.        
          05 WS-YES                         PIC X(01) VALUE 'Y'.        
          05 WS-FB105O-STATUS               PIC X(02) VALUE '00'.       
          05 WS-RECORD-COUNT                PIC S9(5) COMP-3 VALUE +0.  
      *                                                                 00819000
       01 WS-END                            PIC X(40) VALUE             
            'WORKING STORAGE FOR PCSBW106 ENDS HERE  '.                 
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    0000-MAINLINE                                           **          
      **        CONTROLS MAIN PROCESSING                            **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
      *                                                                         
           PERFORM 1000-PROCESS-FCSB105O    THRU 1000-EXIT              
             UNTIL END-RECORD-REACHED.                                  
      *                                                                         
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0100-INITIALIZATION.                                             
      *==============================================================*          
      *                                                                         
           OPEN INPUT FCSB105O-FILE.                                    
      *                                                                 02070000
           IF  FCSB105O-SUCCESSFUL                                      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0100- ERROR ON FCSB105O, STATUS IS '            
                                                WS-FCSB105O-STATUS      
               DISPLAY '**  PROCESSING TERMINATED          **'          
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 02160000
           PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT.             
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                            THRU 6240-EXIT              
               MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE            
           END-IF.                                                      
           DISPLAY '********************************'                   
           DISPLAY '           PCSBW106             '                   
           DISPLAY '      RUN DATE : ' WS-INPUT-DATE                    
           DISPLAY '********************************'                   
           DISPLAY ' '                                                  
      *                                                                         
           PERFORM 7000-READ-FCSB105O       THRU 7000-EXIT.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1000-PROCESS-FCSB105O.                                           
      *==============================================================*          
      *                                                                         
           MOVE FB-105O-DEVICE-NO         TO 3B-DEVICE-NO.              
           MOVE FB-105O-COMPANY-NO        TO 3B-COMPANY-NO.             
           MOVE FB-105O-REG-READ-DT       TO 3B-REG-READ-DT.            
           MOVE FB-105O-REG-READ-TM       TO 3B-REG-READ-TM.            
           MOVE FB-105O-CODE-UTIL-TYPE    TO 3B-CODE-UTIL-TYPE.         
           MOVE FB-105O-ACCOUNT-NO        TO 3B-ACCOUNT-NO.             
           MOVE FB-105O-IC-NO             TO 3B-IC-NO.                  
           MOVE FB-105O-METER-NO          TO 3B-METER-NO.               
           MOVE FB-105O-RAW-READING       TO 3B-RAW-READING.            
           MOVE FB-105O-ENDPOINT-TYPE     TO 3B-ENDPOINT-TYPE.          
           MOVE FB-105O-TAMPER-CD-1       TO 3B-TAMPER-CD-1.            
           MOVE FB-105O-TAMPER-CD-2       TO 3B-TAMPER-CD-2.            
ACT002     MOVE FB-105O-FLASH-CARD-ID     TO 3B-FLASH-ID.               
      *                                                                 02750000
           PERFORM 8000-INSERT-OFFCYC-READ  THRU 8000-EXIT.             
      *                                                                 02920000
           PERFORM 7000-READ-FCSB105O       THRU 7000-EXIT.             
      *                                                                 02920000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02920000
      *==============================================================*          
      *6240-GET-FCA00-COMMON-DATE                                    *          
      *==============================================================*          
           COPY CPD00040.                                                       
      *                                                                         
      *==============================================================*          
      *6251-GET-FJC01-DATE                                           *          
      *==============================================================*          
           COPY CPD00037.                                                       
      *                                                                         
      *==============================================================*          
       7000-READ-FCSB105O.                                              
      *==============================================================*          
      *                                                                 04350000
           READ FCSB105O-FILE                                           
             AT END                                                     
                MOVE WS-YES                 TO WS-END-RECORD-REACHED.   
      *                                                                 04370000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04500000
      *==============================================================*          
      *7600-START-FCSJC01                                            *          
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
      *7620-START-FCSCA00                                            *          
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
       8000-INSERT-OFFCYC-READ.                                         
      *==============================================================*          
      *                                                                 04710000
           EXEC SQL                                                     
                INSERT INTO CSS_OFFCYCLE_READS                          
                  (DEVICE_NO                                            
                  ,COMPANY_NO                                           
                  ,REG_READ_DT                                          
                  ,REG_READ_TM                                          
                  ,CODE_UTIL_TYPE                                       
                  ,ACCOUNT_NO                                           
                  ,IC_NO                                                
                  ,METER_NO                                             
                  ,RAW_READING                                          
                  ,ENDPOINT_TYPE                                        
                  ,TAMPER_CD_1                                          
                  ,TAMPER_CD_2                                          
ACT002            ,FLASH_ID)                                            
                VALUES                                                  
                   (:3B-DEVICE-NO                                       
                   ,:3B-COMPANY-NO                                      
                   ,IIF(TRY_CONVERT(DATE, :3B-REG-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :3B-REG-READ-DT
              ) <> 0) OR (LEN(:3B-REG-READ-DT) <> 10), CIS.CHAR2DATE(
                                                        :3B-REG-READ-DT
              ), CONVERT(DATE, :3B-REG-READ-DT) )                              
                   ,CIS.CHAR2TIME(:3B-REG-READ-TM)                              
                   ,:3B-CODE-UTIL-TYPE                                  
                   ,:3B-ACCOUNT-NO                                      
                   ,:3B-IC-NO                                           
                   ,:3B-METER-NO                                        
                   ,:3B-RAW-READING                                     
                   ,:3B-ENDPOINT-TYPE                                   
                   ,:3B-TAMPER-CD-1                                     
                   ,:3B-TAMPER-CD-2                                     
ACT002             ,:3B-FLASH-ID)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_OFFCYCLE_READS                                  
MFA-TR*           (DEVICE_NO                                                    
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,REG_READ_DT                                                  
MFA-TR*           ,REG_READ_TM                                                  
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,METER_NO                                                     
MFA-TR*           ,RAW_READING                                                  
MFA-TR*           ,ENDPOINT_TYPE                                                
MFA-TR*           ,TAMPER_CD_1                                                  
MFA-TR*           ,TAMPER_CD_2                                                  
MFA-TR*           ,FLASH_ID)                                                    
MFA-TR*         VALUES                                                          
MFA-TR*            (:3B-DEVICE-NO                                               
MFA-TR*            ,:3B-COMPANY-NO                                              
MFA-TR*            ,:3B-REG-READ-DT                                             
MFA-TR*            ,:3B-REG-READ-TM                                             
MFA-TR*            ,:3B-CODE-UTIL-TYPE                                          
MFA-TR*            ,:3B-ACCOUNT-NO                                              
MFA-TR*            ,:3B-IC-NO                                                   
MFA-TR*            ,:3B-METER-NO                                                
MFA-TR*            ,:3B-RAW-READING                                             
MFA-TR*            ,:3B-ENDPOINT-TYPE                                           
MFA-TR*            ,:3B-TAMPER-CD-1                                             
MFA-TR*            ,:3B-TAMPER-CD-2                                             
MFA-TR*            ,:3B-FLASH-ID)                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06270000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 06140000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
ACT016        ADD 1 TO WS-RECORD-COUNT                                  
ACT016        IF WS-RECORD-COUNT = 1000                                 
ACT016           PERFORM 8750-COMMIT                                    
ACT016              THRU 8750-EXIT                                      
ACT016           MOVE 0 TO WS-RECORD-COUNT                              
ACT016           DISPLAY '*** COMMIT POINT TAKEN ***'                   
ACT016           DISPLAY '* DEVICE_NO          = ' 3B-DEVICE-NO         
ACT016           DISPLAY '* COMPANY_NO         = ' 3B-COMPANY-NO        
ACT016           DISPLAY '* REG_READ_DT        = ' 3B-REG-READ-DT       
ACT016           DISPLAY '* REG_READ_TM        = ' 3B-REG-READ-TM       
ACT016           DISPLAY '* CODE_UTIL_TYPE     = ' 3B-CODE-UTIL-TYPE    
ACT016        END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSBW106     ABORT ************'      
              DISPLAY '* 8000-INSERT-OFFCYC-READ            *'          
              DISPLAY '* TABLE              = CSS_OFFCYCLE_READS '      
              DISPLAY '* SQLCODE            = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* DEVICE_NO          = ' 3B-DEVICE-NO            
              DISPLAY '* COMPANY_NO         = ' 3B-COMPANY-NO           
              DISPLAY '* REG_READ_DT        = ' 3B-REG-READ-DT          
              DISPLAY '* REG_READ_TM        = ' 3B-REG-READ-TM          
              DISPLAY '* CODE_UTIL_TYPE     = ' 3B-CODE-UTIL-TYPE       
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 04820000
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT016******************************************************************        
ACT016**  8750-COMMIT.                                                **        
ACT016**                                                              **        
ACT016******************************************************************        
ACT016 8750-COMMIT.                                                     
ACT016*---------------------------*                                             
ACT016     MOVE '8750'                   TO WS-ACTIVE-PARAGRAPH.        
ACT016                                                                  
ACT016     EXEC SQL                                                     
ACT016      COMMIT                                                      
ACT016     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT016                                                                  
ACT016     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
ACT016                                                                  
ACT016     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT016          NEXT SENTENCE                                           
ACT016     ELSE                                                         
ACT016        DISPLAY '* 8750-COMMIT                        *'          
ACT016        DISPLAY '* TABLE              = CSS_OFFCYCLE_READS '      
ACT016        DISPLAY '* SQLCODE            = ' WS-ACTIVE-RETURN-CODE   
ACT016        DISPLAY '*******************************************'     
ACT016        PERFORM 9900-ABEND            THRU 9900-EXIT              
ACT016     END-IF.                                                      
ACT016                                                                  
ACT016 8750-EXIT.                                                       
ACT016     EXIT.                                                        
      *                                                                         
      *==============================================================*          
       9000-TERMINATE.                                                  
      *==============================================================*          
           CLOSE FCSB105O-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *==============================================================*          
      *9900-ABEND.                                                   *          
      *==============================================================*          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
