       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW105.                                        
       AUTHOR.         ROGER D FAULK                                    
       INSTALLATION.                                                    
       DATE-WRITTEN.   JANUARY 2008.                                    
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      ********                   DB2                         *********          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      ** DATE       INITIALS       REASON                           **          
      **                                                            **          
      **  1/01/08   RF10596        DEVELOPMENT OF NEW PROGRAM TO    **          
      **                           CREATE A FILE TO SEND TO AN      **          
      **                           EZT PROGRAM FOR PRINTING A REPORT**          
      **                                                            **          
RDF205**  2/05/08   RF10596        CORRECT ERROR ON FLASH ID TEXT   **          
      **                                                            **          
A04684** 20/05/13   SS95855        STORE READS IN CSS_OFFCYCLE_READS**          
A04684**                           FOR SCE&G (ELECTRIC & GAS READS) **          
      **                                                            **          
A04880** 5 JUNE 2014 RF10596       DO NOT PUT GAS RECORDS ON THE    **          
A04880**                           105 OUTPUT FILE                  **          
      **                                                            **          
AA4880** 10/16/14    SS95855       ENDPOINT TYPE '04' HAS NO        **          
      **                           TRUNCATION.                      **          
      **                                                            **          
A05136** 16 JAN 2015 RF10596       PUT GAS RECORDS ON 105 FILE      **          
A05136**                           IF ELECTRIC AND METER-SIZE-ID    **          
A05136**                           = I-210-I, GO READ ANOTHER       **          
      **                                                            **          
A04684** 08/01/15    SS95855       ACT002 POPULATE FLASH-CARD-ID    **          
      ****************************************************************          
           REMARKS.                                                     
                              PCSBW105 NARRATIVE                        
           PROGRAM READS THE INPUT FIOBW09 FILE.  THIS COMES FROM       
           A GROUPDIR MEMBER THAT IS CREATED DAILY.  THERE IS A PARM    
           THAT DETERMINES IF THE FIOBW06 RECORD IS CREATED, OR NOT.    
           ALONG WITH THE FIOBW06 FILE, FIOBW105 IS CREATED.  THIS IS   
           INPUT TO A EZT PROGRAM WHICH CREATES A DISPATCH REPORT.      
           IF FIOBW09 IS EMPTY, A 'NO DATA' MESSAGE IS WRITTEN TO THE   
           FILE.  THE EZT PROGRAM CHECKS FOR THIS ON THE FIRST RECORD   
           TO DETERMINE IF THERE IS DATA.  THE FIELDS WITH 'CLOSEST'    
           IN THEM, ARE JUST WHAT THEY ARE LABELED.  WE TRY TO PUT      
           THE DATA FROM THE CLOSEST RECORD TO THE ONE WRITTEN OUT.     
           THIS IS AN ATTEMPT TO AID IN FINDING THE PROBLEM METERS      
           LOCATION.                                                    
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBW09.                                                            
      *                                                                         
       COPY CSSBW06.                                                            
      *                                                                         
       COPY CSSBW105.                                                           
      *                                                                         
       COPY CSSB105O.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBW09.                                                            
       COPY FIOBW09.                                                            
      *                                                                         
       COPY CFDBW06.                                                            
       COPY FIOBW06.                                                            
      *                                                                         
       COPY CFDBW105.                                                           
       COPY FIOBW105.                                                           
      *                                                                         
       COPY CFDB105O.                                                           
       COPY FIOB105O.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW105'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  PROGRAM-NAME                PIC X(8)    VALUE 'PCSBW105'.    
      *                                                                         
       01  WS-WORK-AREA.                                                
A05136     05  WS-METER-SIZE-ID        PIC X(8)    VALUE 'I-210-I'.     
A05136     05  WS-BYPASS-RECORD        PIC X       VALUE 'N'.           
           05  WS-SAVE-CODE-VALUE      PIC X(10)   VALUE SPACES.        
           05  WS-SAVE-FLASH-CARD-ID   PIC X(15)   VALUE SPACES.        
           05  RS-RETURN-CODE          PIC S9(4)   VALUE ZEROS COMP.    
           05  RS-RETURN-CODE-DISP     PIC +Z(4).                       
           05  WS-COMPANY-NAME         PIC X(26)   VALUE SPACES.        
           05  WS-CLOSEST-ERTID        PIC X(12)   VALUE SPACES.        
           05  WS-CLOSEST-ACCT         PIC 9(13)   VALUE ZEROS.         
           05  WS-CLOSEST-ADDR         PIC X(55)   VALUE SPACES.        
           05  WS-CLOSEST-TOWN         PIC X(30)   VALUE SPACES.        
           05  WS-CLOSEST-ZIP          PIC X(5)    VALUE SPACES.        
           05  WS-PREM-ADDR            PIC X(55)   VALUE SPACES.        
           05  WS-PREM-TOWN            PIC X(30)   VALUE SPACES.        
           05  WS-PREM-ZIP             PIC X(5)    VALUE SPACES.        
           05  WS-MTR-READ-SOURCE-CD   PIC X       VALUE SPACES.        
           05  WS-NORMAL-PRIORITY      PIC X       VALUE 'N'.           
           05  WS-SCEG-NO-DATA         PIC X       VALUE 'N'.           
           05  WS-PSNC-NO-DATA         PIC X       VALUE 'N'.           
           05  WS-METER-NO             PIC X(9)    VALUE SPACES.        
           05  WS-METER-NO-CURRENTLY   PIC X(9)    VALUE SPACES.        
           05  WS-811                  PIC S9(9)   VALUE -811 COMP.     
           05  WS-803                  PIC S9(9)   VALUE -803 COMP.     
           05  WS-SAVE-CLOSEST-PREMISE PIC 9(10)   VALUE 0.             
           05  WS-SAVE-PREMISE         PIC 9(10)   VALUE 0.             
           05  WS-SAVE-ERTID           PIC X(12)   VALUE SPACES.        
           05  WS-PGRMNAME             PIC X(8)    VALUE 'PCSBW105'.    
           05  WS-PREMISE-NO           PIC S9(10)V VALUE 0 COMP-3.      
A04684     05  WS-CODE-UTIL-TYPE       PIC X(01)   VALUE SPACES.        
A04684     05  WS-ERT-NO               PIC X(12)   VALUE SPACES.        
A04684     05  WS-CURR-ACCT-NO         PIC 9(13)   VALUE ZERO.          
A04684     05  WS-DEVICE-NO            PIC X(12)   VALUE SPACES.        
      *                                                                         
           05  WS-SWITCHES.                                             
               10 WS-EOF-FLAG        PIC X    VALUE 'N'.                
                  88 END-OF-FILE              VALUE 'Y'.                
               10 WS-FBW09-STATUS    PIC XX.                            
                  88 FBW09-SUCCESSFUL         VALUE '00'.               
               10 WS-FBW06-STATUS    PIC XX.                            
                  88 FBW06-SUCCESSFUL         VALUE '00'.               
               10 WS-FBW105-STATUS   PIC XX.                            
                  88 FBW105-SUCCESSFUL        VALUE '00'.               
               10 WS-FB105O-STATUS   PIC XX.                            
                  88 FB105O-SUCCESSFUL        VALUE '00'.               
      *                                                                         
A04684 01  WS-ERT-TYPE             PIC X(02).                           
A04684     88  WS-ELECTRIC-METER   VALUE '04','05','07','08'.           
A04684     88  WS-GAS-METER        VALUE '02','12'.                     
      *                                                                         
       01  WS-CURRENT-TIMESTAMP    PIC X(26)   VALUE SPACES.            
       01  WS-CURRENT-DATE         PIC X(10)   VALUE SPACES.            
       01  WS-CURRENT-DATE-X10.                                         
           05  WS-SAVE-CURR-CC     PIC XX      VALUE SPACES.            
           05  WS-SAVE-CURR-YY     PIC XX      VALUE SPACES.            
           05  FILLER              PIC X       VALUE SPACES.            
           05  WS-SAVE-CURR-MM     PIC XX      VALUE SPACES.            
           05  FILLER              PIC X       VALUE SPACES.            
           05  WS-SAVE-CURR-DD     PIC XX      VALUE SPACES.            
      *                                                                         
       01  WS-ERT-READING          PIC 9(10)   VALUE ZEROS.             
       01  WS-DIALS                PIC 99      VALUE 10.                
      *                                                                         
       01  WS-DATE-READ.                                                
           05 WS-FBW09-DATE-READ-YEAR.                                  
              10 WS-FBW09-DATE-READ-CC    PIC XX   VALUE SPACES.        
              10 WS-FBW09-DATE-READ-YY    PIC XX   VALUE SPACES.        
           05 FILLER                      PIC X    VALUE '-'.           
           05 WS-FBW09-DATE-READ-MM       PIC XX   VALUE SPACES.        
           05 FILLER                      PIC X    VALUE '-'.           
           05 WS-FBW09-DATE-READ-DD       PIC XX   VALUE SPACES.        
      *                                                                         
       01  WS-TIME-READ.                                                
           05 WS-FBW09-TIME-READ-HH       PIC XX   VALUE SPACES.        
           05 FILLER                      PIC X    VALUE ':'.           
           05 WS-FBW09-TIME-READ-MM       PIC XX   VALUE SPACES.        
           05 FILLER                      PIC X    VALUE ':'.           
           05 WS-FBW09-TIME-READ-SS       PIC XX   VALUE SPACES.        
      *                                                                         
       01  WS-ERT-12A.                                                  
           05  WS-ERT-4                PIC X(4).                        
           05  WS-ERT-8                PIC X(8).                        
       01  WS-ERT-12B REDEFINES WS-ERT-12A.                             
           05  WS-ERT-3                PIC X(3).                        
           05  WS-ERT-9                PIC X(9).                        
      *                                                                         
       01 WS-WORK-PARM.                                                 
          05 WS-PARM-PROGRAM           PIC X(8)    VALUE 'PCSBW105'.    
          05 WS-PARM-COMPANY           PIC XX      VALUE SPACES.        
          05 WS-PARM-CMND-CODE         PIC X(4)    VALUE 'PARM'.        
      *                                                                         
       01  WS-EXCEPTION-MESSAGES.                                       
           05 WS-PREM-NOT-FOUND       PIC X(36)                         
              VALUE 'METER HAS NEVER BEEN INSTALLED      '.             
           05 WS-NOT-FOUND-ONMV       PIC X(36)                         
              VALUE 'METER NOT ON MOVEMENT_HIST AS J OR K'.             
           05 WS-NO-DATA-MSG          PIC X(23)                         
              VALUE 'NO DATA FOR THIS RUN   '.                          
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-NEGATIVE                 PIC X   VALUE '-'.           
           05  WS-YES                      PIC X   VALUE 'Y'.           
           05  WS-Y                        PIC X   VALUE 'Y'.           
           05  WS-N                        PIC X   VALUE 'N'.           
           05  WS-I                        PIC X   VALUE 'I'.           
           05  WS-NO                       PIC X   VALUE 'N'.           
           05  WS-M                        PIC X   VALUE 'M'.           
           05  WS-DOT                      PIC X   VALUE '.'.           
           05  WS-19-CENTURY               PIC 99  VALUE  19.           
           05  WS-20-CENTURY               PIC 99  VALUE  20.           
           05  WS-SCEG                     PIC X(26)                    
               VALUE '   S C ELECTRIC AND GAS CO'.                      
           05  WS-PSNC                     PIC X(26)                    
               VALUE '       PSNC ENERGY        '.                      
A04684     05  WS-ELECTRIC                 PIC X   VALUE 'E'.           
A04684     05  WS-GAS                      PIC X   VALUE 'G'.           
      *                                                                         
      ****************************************************************          
      *  CWS00303  WORKING STORAGE FIELDS                            *          
      ****************************************************************          
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ****************************************************************          
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                      *          
      ****************************************************************          
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM      *          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR CPD09900                                 *          
      ****************************************************************          
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR CPD00074 - NAME AND ADDRESS              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00074                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR JOB PARM                                 *          
      *                                                              *          
      * DO NOT PUT ANYTHING BETWEEN CWS00038, 01 WS-PARM-FILE-06     *          
      * AND CWS00114.                                                *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR JOB PARM - CREATE FILE 06 PARM           *          
      ****************************************************************          
      *                                                                         
       01  WS-PARM-FILE-06 REDEFINES WS-INPUT-DATA-BREAKDOWN.           
           05  WS-COMPANY-LIT    PIC X(10).                             
           05  WS-COMPANY-PARM   PIC XX.                                
           05  FILLER            PIC X.                                 
           05  WS-FILE-06-LIT    PIC X(17).                             
           05  WS-FILE-06-PARM   PIC X.                                 
           05  FILLER            PIC X(49).                             
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR JOB PARM - REPORT DATE                   *          
      ****************************************************************          
      *                                                                         
       COPY CWS00114.                                                           
      *                                                                         
      ****************************************************************          
      * USED WITH THE EMBEDDED SPACES ROUTINE                        *          
      ****************************************************************          
      *                                                                         
       COPY CWS00011.                                                           
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_METER_ATTCHMTS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
A05136*    DCLGEN FOR CSS_ELEC_METER  -  EM                          *          
      ****************************************************************          
      *                                                                         
A05136     EXEC SQL                                                             
A05136         INCLUDE TBELMTR                                                  
A05136     END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_MTR_CAP                                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_EQUIPMENT                                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_JOB_PARM                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_MTRD_ENVRNMT                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DECLARATION FOR SQL COMMAND AREA                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_ACCOUNT                                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   CSS_PREMISE                                                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_CUST_PREM_HIST                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_MOVEMENT_HIST                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMVHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_COMPANY                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_NAME                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ADDR_FORMATTED                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ADDR_FREEFORM                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ACCT_BILL_NMES                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATBLNM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ACCT_MISC_INFO                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_CUST_ADDR_XREF                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_NAME_ACCT_XREF                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_ZIP_CODE                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   DCLGEN COPYBOOK FOR CSS_CODE_VALUE                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCDVALU                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   WORKING STORAGE FOR CPD00099 - GET MOST CURRENT            *          
      *        ACCOUNT NUMBER AT A PREMISE                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                 40070000
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT.                 
      *                                                                         
           IF E-FBW09-NO-DATA-LIT = 'No input files to process.'        
              DISPLAY '***********************************'             
              DISPLAY '         0000-MAINLINE           **'             
              DISPLAY '      FCSBW09 FILE IS EMPTY      **'             
              DISPLAY '            CREATING             **'             
              DISPLAY '      NO DATA REPORT RECORD      **'             
              DISPLAY '          FOR FIOBW105           **'             
              DISPLAY '              AND                **'             
              DISPLAY '          ALL 9S RECORD          **'             
              DISPLAY '          FOR FIOBW06            **'             
              DISPLAY '***********************************'             
           ELSE                                                         
              PERFORM 1000-PROCESS-INPUT THRU 1000-EXIT                 
                 UNTIL END-OF-FILE                                      
           END-IF.                                                      
      *                                                                         
           PERFORM 3000-PROCESS-NODATA-REPORT THRU 3000-EXIT.           
      *                                                                         
           PERFORM 0120-WRITE-END-REC THRU 0120-EXIT.                   
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   INITIAL ROUTINE - OPEN INPUT AND OUTPUT FILES              *          
      *   AND GET CURRENT DATE.                                      *          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT FCSBW09-FILE.                                     
      *                                                                         
           IF FBW09-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '    ABENDING PROGRAM    '                        
              DISPLAY ' FIOBW09 FILE OPEN ERROR '                       
              DISPLAY '  0100-INITIALIZATION '                          
              DISPLAY 'FIOBW09 FILE STATUS = ' WS-FBW09-STATUS          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSBW105-FILE                                    
A04684                 FCSB105O-FILE                                    
                       FCSBW06-FILE.                                    
      *                                                                         
           PERFORM 7500-GET-CURRENT-TIMESTAMP THRU 7500-EXIT.           
           MOVE WS-CURRENT-DATE TO WS-CURRENT-DATE-X10.                 
      *                                                                         
      *  GET PARM THAT DETERMINES WHETHER OR NOT YOU BUILD                      
      *  FCSBW06-FILE, IF WS-FILE-06-PARM = 'Y', OR THE PARM IS                 
      *  NOT FOUND -  YOU CREATE THE FILE,  IF = 'N', YOU DO NOT.               
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE 0           TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-FILE-06-LIT = 'CREATE FILE 06 = '              
                     AND WS-COMPANY-LIT = 'COMPANY = '                  
                     AND INPUT-ACTIVE)                                  
                  OR END-OF-SYSIPT.                                     
      *                                                                         
           IF END-OF-SYSIPT                                             
              MOVE '01' TO WS-COMPANY-PARM                              
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** CREATE 06 FILE PARM NOT FOUND      **'        
              DISPLAY '**                                    **'        
              DISPLAY '** VALID VALUES ARE Y OR N.           **'        
              DISPLAY '** PROCESSING WILL CONTINUE AND FILE  **'        
              DISPLAY '** WILL BE CREATED.                   **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
           ELSE                                                         
              IF WS-FILE-06-PARM = 'Y' OR 'N'                           
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '****************************************'     
                 DISPLAY '** JOB PARM VALUE FOR DETERMINING     **'     
                 DISPLAY '** WHETHER OR NOT TO CREATE THE 06    **'     
                 DISPLAY '** FILE WAS FOUND, BUT IS INVALID.    **'     
                 DISPLAY '** VALID VALUES ARE Y OR N.           **'     
                 DISPLAY '** WS-FILE-06-PARM = ' WS-FILE-06-PARM        
                 DISPLAY '** PROCESSING WILL CONTINUE AND FILE  **'     
                 DISPLAY '** WILL BE CREATED.                   **'     
                 DISPLAY '****************************************'     
                 DISPLAY ' '                                            
              END-IF                                                    
              IF WS-COMPANY-PARM = '01'                                 
                 CONTINUE                                               
              ELSE                                                      
                 MOVE '01' TO WS-COMPANY-PARM                           
                 DISPLAY ' '                                            
                 DISPLAY '****************************************'     
                 DISPLAY '** JOB PARM VALUE FOR COMPANY-NO NOT  **'     
                 DISPLAY '** VALID.  USING 01 AS DEFAULT.       **'     
                 DISPLAY '****************************************'     
                 DISPLAY ' '                                            
              END-IF                                                    
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
           MOVE SPACES TO WS-ERT-12A.                                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  WRITE THE TRAILER RECORD FOR FIOBW06                      **          
      ****************************************************************          
      *                                                                         
       0120-WRITE-END-REC.                                              
      *                                                                         
           INITIALIZE FIOBW06.                                          
           MOVE ALL '9' TO E-FBW06-RECORD-KEY.                          
           MOVE 1       TO E-FBW06-DB-PART-DREC.                        
           PERFORM 8000-WRITE-FIOBW06 THRU 8000-EXIT.                   
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PROCESS INPUT DATA                                         *          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE E-FBW09-DATE-READ-MM TO WS-FBW09-DATE-READ-MM.          
           MOVE E-FBW09-DATE-READ-DD TO WS-FBW09-DATE-READ-DD.          
           MOVE E-FBW09-DATE-READ-YY TO WS-FBW09-DATE-READ-YY.          
           MOVE WS-SAVE-CURR-CC      TO WS-FBW09-DATE-READ-CC.          
      *                                                                         
           MOVE E-FBW09-TIME-READ-HH TO WS-FBW09-TIME-READ-HH.          
           MOVE E-FBW09-TIME-READ-MM TO WS-FBW09-TIME-READ-MM.          
           MOVE E-FBW09-TIME-READ-SS TO WS-FBW09-TIME-READ-SS.          
      *                                                                         
A04684     MOVE SPACES               TO WS-ERT-TYPE                     
A04684                                  WS-ERT-NO                       
A04684                                  WS-DEVICE-NO                    
A04684                                  WS-CODE-UTIL-TYPE.              
A04684     MOVE E-FBW09-ERT-TYPE     TO WS-ERT-TYPE.                    
A04684                                                                  
A04684     IF WS-ELECTRIC-METER                                         
A04684        MOVE WS-ELECTRIC       TO WS-CODE-UTIL-TYPE               
A04684     ELSE                                                         
A04684        IF WS-GAS-METER                                           
A04684           MOVE WS-GAS         TO WS-CODE-UTIL-TYPE               
A04684        ELSE                                                      
A04684           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT            
A04684           GO TO 1000-EXIT                                        
A04684     END-IF
           END-IF.                                                      
      *                                                                         
           MOVE E-FBW09-ERT-ID(3:8)  TO WS-ERT-8.                       
           MOVE ZEROS                TO WS-ERT-4.                       
      *                                                                         
           MOVE WS-ERT-12A TO MA-DEVICE-NO                              
A04684                        WS-ERT-NO.                                
      *                                                                         
A04684                                                                  
A04684     PERFORM 7100-CHECK-FOR-FIRST-ERT THRU 7100-EXIT              
A04684                                                                  
A04684     IF WS-DEVICE-NO = WS-ERT-NO                                  
A04684        PERFORM 1200-PROCESS-ERT-ID   THRU 1200-EXIT              
A04684     END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT.                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   CHECK ERT-ID ON METER_ATTCHMNTS.                           *          
      ****************************************************************          
      *                                                                         
       1200-PROCESS-ERT-ID.                                             
      *                                                                         
           INITIALIZE FIOBW105.                                         
           MOVE ZEROS  TO WS-DIALS.                                     
           MOVE SPACES TO WS-PREM-ADDR                                  
                          WS-PREM-TOWN                                  
                          WS-PREM-ZIP.                                  
      *                                                                         
           MOVE WS-COMPANY-PARM TO MA-COMPANY-NO.                       
           PERFORM 7200-CHECK-METER-ATTACHMENT THRU 7200-EXIT.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE MA-METER-NO TO MC-METER-NO                           
      *                                                                         
A05136*    CHECK - IF ELECTRIC AND METER-SIZE-ID = I-210-I ON                   
A05136*            CSS_ELEC_METER, GO READ ANOTHER                              
      *                                                                         
A05136        MOVE WS-N TO WS-BYPASS-RECORD                             
A05136        IF WS-ELECTRIC-METER                                      
A05136           MOVE MA-METER-NO     TO EM-METER-NO                    
A05136           MOVE WS-COMPANY-PARM TO EM-COMPANY-NO                  
A05136           MOVE WS-ELECTRIC     TO EM-CODE-UTIL-TYPE              
A05136           PERFORM 7450-ELEC-METER THRU 7450-EXIT                 
A05136           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
A05136              MOVE WS-Y TO WS-BYPASS-RECORD                       
A05136           END-IF                                                 
A05136        END-IF                                                    
      *                                                                         
A05136        IF WS-BYPASS-RECORD = WS-N                                
                 MOVE WS-COMPANY-PARM TO MC-COMPANY-NO                  
                 PERFORM 7320-GET-MTR-CAP THRU 7320-EXIT                
      *                                                                         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE MC-NO-DIALS TO WS-DIALS                        
                    PERFORM 1500-CALC-READING THRU 1500-EXIT            
                 ELSE                                                   
                    MOVE ZEROS TO WS-DIALS                              
                 END-IF                                                 
      *                                                                         
                 MOVE MA-METER-NO TO EQ-DEVICE-NO                       
                 MOVE WS-COMPANY-PARM TO EQ-COMPANY-NO                  
                 PERFORM 7300-GET-PREMISE-FROM-EQ THRU 7300-EXIT        
      *                                                                         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    IF EQ-CODE-CRNT-LOC = 'J' OR 'K'                    
                       MOVE EQ-CRNT-LOC-NO TO WS-SAVE-CLOSEST-PREMISE   
                                              WS-CPD99-PREMISE-NO       
                       MOVE ZEROS TO WS-CPD99-ACCOUNT-NO                
      *                                                                         
                       PERFORM 1400-GET-CURRENT-ACCOUNT THRU 1400-EXIT  
      *                                                                         
                       IF WS-PR-STREET = SPACES                         
                          CONTINUE                                      
                       ELSE                                             
                          MOVE WS-ERT-12A           TO WS-CLOSEST-ERTID 
                          MOVE WS-CPD99-ACCOUNT-NO  TO WS-CLOSEST-ACCT  
                          MOVE WS-PR-STREET         TO WS-CLOSEST-ADDR  
                          MOVE WS-PR-ADDR-CITY-STATE TO WS-CLOSEST-TOWN 
                          MOVE WS-PR-ADDR-ZIP-CODE  TO WS-CLOSEST-ZIP   
                       END-IF                                           
      *                                                                         
                       IF WS-FILE-06-PARM = 'N'                         
                          CONTINUE                                      
                       ELSE                                             
                          IF WS-CPD99-ACCOUNT-NO > ZEROS                
                             MOVE WS-CPD99-ACCOUNT-NO TO MN-ACCOUNT-NO  
                             PERFORM 7335-GET-MTRENV THRU 7335-EXIT     
                                IF WS-ACTIVE-RETURN-CODE =              
                                   SUCCESSFUL-CALL                      
                                   MOVE MN-MTR-READ-SOURCE-CD           
                                         TO WS-MTR-READ-SOURCE-CD       
                                ELSE                                    
                                   MOVE 'I' TO WS-MTR-READ-SOURCE-CD    
                                END-IF                                  
                          END-IF                                        
                          PERFORM 1210-FORMAT-BW06-OUTPUT               
                              THRU 1210-EXIT                            
                       END-IF                                           
      *                                                                         
A04684                 IF WS-CPD99-ACCOUNT-NO > ZEROS                   
A04684                    PERFORM 1220-FORMAT-OFFCYCLE-RD               
A04684                        THRU 1220-EXIT                            
A04684                 END-IF                                           
      *                                                                         
                    ELSE                                                
                      MOVE ZEROS TO WS-CPD99-ACCOUNT-NO                 
                      MOVE SPACES TO WS-METER-NO-CURRENTLY              
                      MOVE MA-METER-NO TO MV-DEVICE-NO                  
                      MOVE WS-COMPANY-PARM TO MV-COMPANY-NO             
                      PERFORM 7325-GET-PREMISE-FROM-MV                  
                          THRU 7325-EXIT                                
                      MOVE ZEROS TO WS-SAVE-PREMISE                     
                      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL        
                         MOVE MV-LOC-NO TO WS-CPD99-PREMISE-NO          
                                           WS-SAVE-PREMISE              
                         PERFORM 1400-GET-CURRENT-ACCOUNT               
                             THRU 1400-EXIT                             
      *                                                                         
                         IF WS-PR-STREET = SPACES                       
                            CONTINUE                                    
                         ELSE                                           
                            MOVE WS-PR-STREET          TO WS-PREM-ADDR  
                            MOVE WS-PR-ADDR-CITY-STATE TO WS-PREM-TOWN  
                            MOVE WS-PR-ADDR-ZIP-CODE   TO WS-PREM-ZIP   
                         END-IF                                         
      *                                                                         
                         IF WS-CPD99-ACCOUNT-NO > ZEROS                 
                            MOVE WS-CPD99-ACCOUNT-NO TO MN-ACCOUNT-NO   
                            PERFORM 7335-GET-MTRENV THRU 7335-EXIT      
                            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  
                               MOVE MN-METER-NO                         
                                    TO WS-METER-NO-CURRENTLY            
                            ELSE                                        
                               MOVE SPACES TO WS-METER-NO-CURRENTLY     
                            END-IF                                      
                         END-IF                                         
                         PERFORM 1300-CREATE-OUTFILE-REPORT             
                             THRU 1300-EXIT                             
                      ELSE                                              
                         MOVE WS-NOT-FOUND-ONMV                         
                              TO E-FBW105-MESSAGE-AREA                  
                         PERFORM 1300-CREATE-OUTFILE-REPORT             
                             THRU 1300-EXIT                             
                      END-IF                                            
                    END-IF                                              
                 ELSE                                                   
                    DISPLAY 'PREMISE NOT ON EQ FOR ' EQ-DEVICE-NO       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   FORMAT THE FIOBW06 RECORD                                **          
      ****************************************************************          
      *                                                                         
       1210-FORMAT-BW06-OUTPUT.                                         
      *                                                                         
           INITIALIZE FIOBW06.                                          
      *                                                                         
           MOVE WS-CPD99-ACCOUNT-NO   TO E-FBW06-ACCOUNT-NO.            
           MOVE MA-METER-NO           TO E-FBW06-METER-NO.              
           MOVE 'C'                   TO E-FBW06-CODE-TOU-SEASN.        
           MOVE 'E'                   TO E-FBW06-CODE-UTIL-TYPE.        
           MOVE 'B'                   TO E-FBW06-CODE-USAGE-TYPE.       
           MOVE '0'                   TO E-FBW06-CODE-TIME-PERIOD.      
           MOVE 'I'                   TO E-FBW06-READ-ITEM-STATUS.      
           MOVE 'I'                   TO E-FBW06-INDEX-VALUE-CD.        
           MOVE 'Y'                   TO E-FBW06-CNSMPTN-READ-FL.       
           MOVE 'KWH'                 TO E-FBW06-REG-MEASURE-CD.        
           MOVE WS-ERT-READING        TO E-FBW06-METER-READING.         
      *                                                                         
           MOVE WS-DATE-READ          TO E-FBW06-DATE-READ.             
           MOVE WS-TIME-READ          TO E-FBW06-TIME-READ.             
           MOVE 1                     TO E-FBW06-DB-PART-DREC.          
           MOVE 'A'                   TO E-FBW06-CODE-METER-READ.       
           MOVE SPACES                TO E-FBW06-CODE-METER-NO-READ.    
           MOVE WS-MTR-READ-SOURCE-CD TO E-FBW06-MTR-READ-SOURCE-CD.    
           MOVE '3'                   TO E-FBW06-READ-PROCESS-CD.       
      *                                                                         
           PERFORM 8000-WRITE-FIOBW06 THRU 8000-EXIT.                   
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04684****************************************************************          
A04684**   FORMAT OFFCYCLE READS TO STORE IN CSS_OFFCYCLE_READS     **          
A04684****************************************************************          
A04684 1220-FORMAT-OFFCYCLE-RD.                                         
A04684*                                                                         
A04684     INITIALIZE FIOB105O.                                         
A04684*                                                                         
A04684     MOVE MA-DEVICE-NO          TO FB-105O-DEVICE-NO.             
A04684     MOVE MA-METER-NO           TO FB-105O-METER-NO.              
A04684     MOVE WS-COMPANY-PARM       TO FB-105O-COMPANY-NO.            
A04684     MOVE WS-DATE-READ          TO FB-105O-REG-READ-DT.           
A04684     MOVE WS-TIME-READ          TO FB-105O-REG-READ-TM.           
AA4880     IF WS-ERT-TYPE = '04'                                        
AA4880        MOVE E-FBW09-ERT-READING TO FB-105O-RAW-READING           
AA4880     ELSE                                                         
AA4880        MOVE WS-ERT-READING     TO FB-105O-RAW-READING            
AA4880     END-IF.                                                      
A04684     MOVE E-FBW09-ERT-TYPE      TO FB-105O-ENDPOINT-TYPE.         
A04684     MOVE E-FBW09-TAMPER-CD-1   TO FB-105O-TAMPER-CD-1.           
A04684     MOVE E-FBW09-TAMPER-CD-2   TO FB-105O-TAMPER-CD-2.           
ACT002     MOVE E-FBW09-FLASH-CARD-ID TO FB-105O-FLASH-CARD-ID.         
A04684     MOVE WS-CPD99-ACCOUNT-NO   TO FB-105O-ACCOUNT-NO.            
A04684     MOVE WS-CODE-UTIL-TYPE     TO FB-105O-CODE-UTIL-TYPE.        
A04684*                                                                         
A04684     MOVE WS-CPD99-ACCOUNT-NO   TO MN-ACCOUNT-NO.                 
A04684     MOVE WS-CODE-UTIL-TYPE     TO MN-CODE-UTIL-TYPE.             
A04684     MOVE MA-METER-NO           TO MN-METER-NO.                   
A04684                                                                  
A04684     PERFORM 7400-GET-IC-NO        THRU 7400-EXIT.                
A04684*                                                                         
A04684     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04684        MOVE MN-IC-NO           TO FB-105O-IC-NO                  
A04684        PERFORM 8400-WRITE-FB-105O THRU 8400-EXIT                 
A04684     END-IF.                                                      
A04684*                                                                         
A04684 1220-EXIT.                                                       
A04684     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   PREPARE FOR OUTPUT FILE FIOBW105.  THIS OUTPUT FILE        *          
      *   WILL BE PRINTED IN AN EZT PROGRAM.                         *          
      ****************************************************************          
      *                                                                         
       1300-CREATE-OUTFILE-REPORT.                                      
      *                                                                         
           IF WS-COMPANY-PARM = '01'                                    
              MOVE 'Y' TO WS-SCEG-NO-DATA                               
           END-IF.                                                      
      *                                                                         
           IF WS-PREM-ADDR = SPACES                                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PREM-ADDR  TO E-FBW105-SERV-ADDR                  
              MOVE WS-PREM-TOWN  TO E-FBW105-SERV-TOWN                  
              MOVE WS-PREM-ZIP   TO E-FBW105-SERV-ZIP                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-CURRENT-DATE      TO E-FBW105-RUN-DATE.              
           MOVE WS-CURRENT-TIMESTAMP TO E-FBW105-RUN-TIMESTAMP.         
           MOVE WS-ERT-12A           TO E-FBW105-ERT-ID.                
      *                                                                         
           MOVE WS-CPD99-ACCOUNT-NO  TO E-FBW105-ACCOUNT-NO.            
      *                                                                         
           MOVE WS-COMPANY-PARM      TO E-FBW105-COMPANY-NO.            
           MOVE MA-METER-NO          TO E-FBW105-METER-NO.              
           MOVE WS-SAVE-PREMISE      TO E-FBW105-PREMISE-NO.            
      *                                                                         
           MOVE WS-CLOSEST-ERTID        TO E-FBW105-CLOSEST-ERT-ID.     
           MOVE WS-CLOSEST-ACCT         TO E-FBW105-CLOSEST-ACCOUNT.    
           MOVE WS-CLOSEST-ADDR         TO E-FBW105-CLOSEST-SERV-ADDR.  
           MOVE WS-CLOSEST-TOWN         TO E-FBW105-CLOSEST-SERV-TOWN.  
           MOVE WS-CLOSEST-ZIP          TO E-FBW105-CLOSEST-SERV-ZIP.   
           MOVE WS-SAVE-CLOSEST-PREMISE TO E-FBW105-CLOSEST-PREMISE-NO. 
      *                                                                         
           MOVE WS-DATE-READ          TO E-FBW105-DATE-READ.            
           MOVE WS-TIME-READ          TO E-FBW105-TIME-READ.            
           MOVE E-FBW09-ERT-TYPE      TO E-FBW105-ERT-TYPE.             
           MOVE E-FBW09-TAMPER-CD-1   TO E-FBW105-TAMPER-CD-1.          
           MOVE E-FBW09-TAMPER-CD-2   TO E-FBW105-TAMPER-CD-2.          
           MOVE WS-METER-NO-CURRENTLY TO E-FBW105-METER-NO-CURRENTLY.   
           MOVE WS-ERT-READING        TO E-FBW105-ERT-READING.          
           MOVE WS-DIALS              TO E-FBW105-DIALS.                
      *                                                                         
           IF E-FBW09-FLASH-CARD-ID = WS-SAVE-FLASH-CARD-ID             
              MOVE WS-SAVE-CODE-VALUE TO E-FBW105-FLASH-CARD-ID         
           ELSE                                                         
RDF205        MOVE SPACES TO UV-CODE-SHORT-DESC                         
              MOVE E-FBW09-FLASH-CARD-ID TO UV-CODE-VALUE-TEXT          
RDF205        MOVE LENGTH OF UV-CODE-VALUE-TEXT TO UV-CODE-VALUE-LEN    
              PERFORM 7030-SELECT-CODE-VALUE THRU 7030-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
RDF205          MOVE SPACES                  TO WS-SAVE-CODE-VALUE      
RDF205                                          WS-SAVE-FLASH-CARD-ID   
                MOVE UV-CODE-SHORT-DESC-TEXT TO E-FBW105-FLASH-CARD-ID  
                                                WS-SAVE-CODE-VALUE      
                MOVE E-FBW09-FLASH-CARD-ID   TO WS-SAVE-FLASH-CARD-ID   
              ELSE                                                      
RDF205          MOVE SPACES                TO WS-SAVE-CODE-VALUE        
RDF205                                        WS-SAVE-FLASH-CARD-ID     
                MOVE E-FBW09-FLASH-CARD-ID TO WS-SAVE-FLASH-CARD-ID     
                MOVE 'INVALID CD'          TO E-FBW105-FLASH-CARD-ID    
                                              WS-SAVE-CODE-VALUE        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 8200-WRITE-FIOBW105 THRU 8200-EXIT.                  
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   GET THE MOST CURRENT ACCOUNT FOR THE PREMISE NUMBER        *          
      *   AND SERVICE ADDRESS.                                       *          
      ****************************************************************          
      *                                                                         
       1400-GET-CURRENT-ACCOUNT.                                        
      *                                                                         
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
      *                                                                         
           IF WS-CPD99-ACCOUNT-NO = ZEROS                               
              DISPLAY '******************************************'      
              DISPLAY ' 1400-GET-CURRENT-ACCOUNT                *'      
              DISPLAY ' DID NOT FIND THE MOST CURRENT ACCOUNT   *'      
              DISPLAY ' FOR PREMISE NUMBER = ' WS-CPD99-PREMISE-NO      
              DISPLAY '******************************************'      
           ELSE                                                         
              MOVE WS-CPD99-ACCOUNT-NO TO AT-ACCOUNT-NO                 
              MOVE ZEROS               TO AT-ADDRESS-ID                 
              PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT             
           END-IF.                                                      
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   TAKE THE INPUT ERT-READING AND REFORMAT USING NUMBER       *          
      *   OF DIALS FROM MTRCAP.                                      *          
      ****************************************************************          
      *                                                                         
       1500-CALC-READING.                                               
      *                                                                         
           MOVE ZEROS TO WS-ERT-READING.                                
      *                                                                         
           IF WS-DIALS = 4 OR 5                                         
              MOVE E-FBW09-ERT-READING (1:8) TO WS-ERT-READING          
           ELSE                                                         
              MOVE E-FBW09-ERT-READING (1:9) TO WS-ERT-READING          
           END-IF.                                                      
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  WS-SCEG-NO-DATA IS SET TO 'Y' IF THERE IS SOME DATA FOR     *          
      *      COMPANY 01 ON THE EXCEPTION REPORT.                     *          
      *      IF AT THIS POINT IT IS = 'N' THEN                       *          
      *      'NO DATA FOR THIS RUN' LINE IS PRINTED ON THE REPORT    *          
      ****************************************************************          
      *                                                                         
       3000-PROCESS-NODATA-REPORT.                                      
      *                                                                         
           IF WS-SCEG-NO-DATA = 'N'                                     
              INITIALIZE FIOBW105                                       
              MOVE WS-COMPANY-PARM TO E-FBW105-COMPANY-NO               
              MOVE WS-CURRENT-DATE TO E-FBW105-RUN-DATE                 
              MOVE WS-NO-DATA-MSG  TO E-FBW105-MESSAGE-AREA             
              PERFORM 8200-WRITE-FIOBW105 THRU 8200-EXIT                
           END-IF.                                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES 4000-MAIL-NAME-ADDRESS                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00074                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES 6010-REDUCE-EMBEDDED-SPACES                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6990-FETCH-CUR-ACCOUNT                                      *          
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6995-CPD99-ERROR-ROUTINE IS PERFORMED IN CPD00099 WHEN      *          
      *  THERE IS A PROBLEM.                                         *          
      ****************************************************************          
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
A05136     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A05136        DISPLAY '*************PCSBW105************'               
A05136        DISPLAY '* ERROR PERFORMING - 6990-FETCH-CUR-ACCOUNT '    
A05136        DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1              
A05136        DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE            
A05136        DISPLAY '* INFORMATIONAL ONLY  *'                         
A05136        DISPLAY '*************PCSBW105************'               
A05136     ELSE                                                         
              DISPLAY '*************PCSBW105************'               
              DISPLAY '* ERROR PERFORMING - 6990-FETCH-CUR-ACCOUNT '    
              DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1              
              DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE            
              DISPLAY '* PROGRAM ABENDING...           *'               
              DISPLAY '*************PCSBW105************'               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
A05136     END-IF.                                                      
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   READ INPUT FILE                                            *          
      ****************************************************************          
      *                                                                         
       7000-READ-INPUT-FILE.                                            
      *                                                                         
           READ FCSBW09-FILE                                            
                     AT END MOVE WS-YES TO WS-EOF-FLAG.                 
      *                                                                         
           IF FBW09-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              IF END-OF-FILE                                            
                 CONTINUE                                               
              ELSE                                                      
                   DISPLAY '*************************************'      
                   DISPLAY '**   PCSBW105 PROCESSING ERROR     **'      
                   DISPLAY '**   ABEND IN PARAGRAPH 7000       **'      
                   DISPLAY '**  READ STATUS   = ' WS-FBW09-STATUS       
                   DISPLAY '*************************************'      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   GET FLASH-ID LITERAL FROM CSS_CODE_VALUE                   *          
      *   IF THE VALUE IS NOT FOUND, "INVALID CD" WILL BE PUT        *          
      *   THE OUTPUT RECORD.                                         *          
      ****************************************************************          
      *                                                                         
       7030-SELECT-CODE-VALUE.                                          
      *                                                                         
           EXEC SQL                                                     
            SELECT CODE_SHORT_DESC                                      
              INTO :UV-CODE-SHORT-DESC                                  
             FROM  CSS_CODE_VALUE WITH(READUNCOMMITTED)                         
             WHERE COMPANY_NO = '01'                                    
             AND   COLUMN_NA  = 'FLASH_ID'                              
             AND   TABLE_NA   = 'CSS_DUMMY'                             
             AND   CODE_VALUE = :UV-CODE-VALUE                          
             AND   PROGRAM_ID = 'PCSBW105'                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT CODE_SHORT_DESC                                              
MFA-TR*       INTO :UV-CODE-SHORT-DESC                                          
MFA-TR*      FROM  CSS_CODE_VALUE                                               
MFA-TR*      WHERE COMPANY_NO = '01'                                            
MFA-TR*      AND   COLUMN_NA  = 'FLASH_ID'                                      
MFA-TR*      AND   TABLE_NA   = 'CSS_DUMMY'                                     
MFA-TR*      AND   CODE_VALUE = :UV-CODE-VALUE                                  
MFA-TR*      AND   PROGRAM_ID = 'PCSBW105'                                      
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '****************************************'       
               DISPLAY '**    7030-SELECT-CODE-VALUE          **'       
               DISPLAY '**      SOMETHING NOT RIGHT           **'       
               DISPLAY '** CODE VALUE = ' UV-CODE-VALUE                 
               DISPLAY '**     PROCESSING TERMINATED          **'       
               DISPLAY '****************************************'       
               DISPLAY ' '                                              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
A04684****************************************************************          
A04684*  In case of multiple ERT's, send only if the ERT received is *          
A04684*  the first ERT.                                              *          
A04684****************************************************************          
A04684*                                                                         
A04684 7100-CHECK-FOR-FIRST-ERT.                                        
A04684*                                                                         
A04684     EXEC SQL                                                     
A04684         SELECT COALESCE(MIN(DEVICE_NO),' ')                  
A04684           INTO :WS-DEVICE-NO                                     
A04684           FROM CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                  
A04684          WHERE COMPANY_NO     = :WS-COMPANY-PARM                 
A04684            AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
A04684            AND METER_NO =                                        
A04684                (SELECT MA.METER_NO                               
A04684                 FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)         
A04684                 WHERE MA.COMPANY_NO     = :WS-COMPANY-PARM       
A04684                   AND MA.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE     
A04684                   AND MA.DEVICE_NO      = :WS-ERT-NO)            
A04684                                                           
A04684     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(MIN(DEVICE_NO),CHAR(' '))                          
MFA-TR*          INTO :WS-DEVICE-NO                                             
MFA-TR*          FROM CSS_METER_ATTCHMTS                                        
MFA-TR*         WHERE COMPANY_NO     = :WS-COMPANY-PARM                         
MFA-TR*           AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*           AND METER_NO =                                                
MFA-TR*               (SELECT MA.METER_NO                                       
MFA-TR*                FROM CSS_METER_ATTCHMTS MA                               
MFA-TR*                WHERE MA.COMPANY_NO     = :WS-COMPANY-PARM               
MFA-TR*                  AND MA.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE             
MFA-TR*                  AND MA.DEVICE_NO      = :WS-ERT-NO)                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684*                                                                         
A04684     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04684*                                                                         
A04684     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04684        CONTINUE                                                  
A04684     ELSE                                                         
A04684         DISPLAY '*******************************************'    
A04684         DISPLAY '  ABENDING PROGRAM '                            
A04684         DISPLAY '  7100-CHECK-FOR-FIRST-ERT '                    
A04684         DISPLAY ' RETURN CODE =  ' WS-ACTIVE-RETURN-CODE         
A04684         DISPLAY ' COMPANY NO     ' WS-COMPANY-PARM               
A04684         DISPLAY ' CODE-UTIL-TYPE ' WS-CODE-UTIL-TYPE             
A04684         DISPLAY ' ERT NO         ' WS-ERT-NO                     
A04684         DISPLAY '*******************************************'    
A04684         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04684     END-IF.                                                      
A04684*                                                                         
A04684 7100-EXIT.                                                       
A04684     EXIT.                                                        
A04684*                                                                         
      ****************************************************************          
      *    GET THE METER NUMBER FROM CSS_METER_ATTCHMTS              *          
      ****************************************************************          
      *                                                                         
       7200-CHECK-METER-ATTACHMENT.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) METER_NO                                           
                INTO :MA-METER-NO                                       
               FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                 
                   ,CSS_MTR_ATT_TYPE   N5 WITH(READUNCOMMITTED)                 
              WHERE MA.COMPANY_NO            = :MA-COMPANY-NO           
A04684         AND  MA.CODE_UTIL_TYPE        = :WS-CODE-UTIL-TYPE       
               AND  MA.DEVICE_NO             = :MA-DEVICE-NO            
               AND  MA.CODE_UTIL_TYPE        = N5.CODE_UTIL_TYPE        
               AND  MA.CODE_ATT_TYPE         = N5.CODE_ATT_TYPE         
               AND  N5.DEVICE_TYPE_CD        = 'A'                      
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_NO                                                   
MFA-TR*         INTO :MA-METER-NO                                               
MFA-TR*        FROM CSS_METER_ATTCHMTS MA                                       
MFA-TR*            ,CSS_MTR_ATT_TYPE   N5                                       
MFA-TR*       WHERE MA.COMPANY_NO            = :MA-COMPANY-NO                   
MFA-TR*        AND  MA.CODE_UTIL_TYPE        = :WS-CODE-UTIL-TYPE               
MFA-TR*        AND  MA.DEVICE_NO             = :MA-DEVICE-NO                    
MFA-TR*        AND  MA.CODE_UTIL_TYPE        = N5.CODE_UTIL_TYPE                
MFA-TR*        AND  MA.CODE_ATT_TYPE         = N5.CODE_ATT_TYPE                 
MFA-TR*        AND  N5.DEVICE_TYPE_CD        = 'A'                              
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '      CSS_METER_ATTCHMTS   '                    
               DISPLAY '   7200-CHECK-METER-ATTACHMENT '                
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' ERT-ID NUMBER  = ' MA-DEVICE-NO                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE PREMISE NUMBER FROM CSS_EQUIPMENT                 *          
      ****************************************************************          
      *                                                                         
       7300-GET-PREMISE-FROM-EQ.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) CODE_CRNT_LOC,
              CRNT_LOC_NO                                        
                INTO :EQ-CODE-CRNT-LOC                                  
                    ,:EQ-CRNT-LOC-NO                                    
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
                WHERE COMPANY_NO     = :EQ-COMPANY-NO                   
                AND   DEVICE_NO      = :EQ-DEVICE-NO                    
A04684          AND   CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_CRNT_LOC                                              
MFA-TR*             ,CRNT_LOC_NO                                                
MFA-TR*         INTO :EQ-CODE-CRNT-LOC                                          
MFA-TR*             ,:EQ-CRNT-LOC-NO                                            
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*         WHERE COMPANY_NO     = :EQ-COMPANY-NO                           
MFA-TR*         AND   DEVICE_NO      = :EQ-DEVICE-NO                            
MFA-TR*         AND   CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '      CSS_EQUIPMENT FETCH  '                    
               DISPLAY '      7300-GET-PREMISE-FROM-EQ '                
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' METER NO       = ' EQ-DEVICE-NO                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE NUMBER OF DIALS FROM CSS_MTR_CAP                  *          
      ****************************************************************          
      *                                                                         
       7320-GET-MTR-CAP.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) NO_DIALS                                           
                INTO :MC-NO-DIALS                                       
                FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                          
                WHERE COMPANY_NO     = :MC-COMPANY-NO                   
                AND   METER_NO       = :MC-METER-NO                     
A04684          AND   CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NO_DIALS                                                   
MFA-TR*         INTO :MC-NO-DIALS                                               
MFA-TR*         FROM CSS_MTR_CAP                                                
MFA-TR*         WHERE COMPANY_NO     = :MC-COMPANY-NO                           
MFA-TR*         AND   METER_NO       = :MC-METER-NO                             
MFA-TR*         AND   CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '      CSS_EQUIPMENT FETCH  '                    
               DISPLAY '      7320-GET-MTR-CAP   '                      
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' METER NO       = ' MC-METER-NO                 
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE PREMISE NUMBER FROM CSS_MOVEMENT_HIST             *          
      ****************************************************************          
      *                                                                         
       7325-GET-PREMISE-FROM-MV.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) LOC_NO                                            
                INTO :MV-LOC-NO                                         
                FROM CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                    
                WHERE COMPANY_NO     = :MV-COMPANY-NO                   
                 AND  DEVICE_NO      = :MV-DEVICE-NO                    
A04684           AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                 AND  CODE_CRNT_LOC  IN ('J', 'K')                      
                 AND  LOC_NO         > 0                                
           ORDER BY MOVE_NO DESC                                        
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  LOC_NO                                                    
MFA-TR*         INTO :MV-LOC-NO                                                 
MFA-TR*         FROM CSS_MOVEMENT_HIST                                          
MFA-TR*         WHERE COMPANY_NO     = :MV-COMPANY-NO                           
MFA-TR*          AND  DEVICE_NO      = :MV-DEVICE-NO                            
MFA-TR*          AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*          AND  CODE_CRNT_LOC  IN ('J', 'K')                              
MFA-TR*          AND  LOC_NO         > 0                                        
MFA-TR*    ORDER BY MOVE_NO DESC                                                
MFA-TR*    FETCH FIRST ROW ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       CSS_MOVEMENT_HIST '                      
               DISPLAY '      7325-GET-PREMISE-FROM-MV '                
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' METER NO       = ' MV-DEVICE-NO                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE ACTUAL METER NUMBER ON CSS_MTRD_ENVRNMT           *          
      ****************************************************************          
      *                                                                         
       7335-GET-MTRENV.                                                 
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) METER_NO,
              MTR_READ_SOURCE_CD                                 
                INTO :MN-METER-NO                                       
                    ,:MN-MTR-READ-SOURCE-CD                             
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                   
A04684           AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE               
                 AND  CODE_METER_STATUS <> 'K'                          
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_NO                                                   
MFA-TR*             ,MTR_READ_SOURCE_CD                                         
MFA-TR*         INTO :MN-METER-NO                                               
MFA-TR*             ,:MN-MTR-READ-SOURCE-CD                                     
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                           
MFA-TR*          AND  CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       
MFA-TR*          AND  CODE_METER_STATUS = 'K'                                  
MFA-TR*    FETCH FIRST ROW ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '  ABENDING PROGRAM '                            
               DISPLAY '  CSS_MTRD_ENVRNMT '                            
               DISPLAY '  7335-GET-MTRENV '                             
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' ACCOUNT-NO     = ' MN-ACCOUNT-NO               
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7335-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04684****************************************************************          
A04684*  GET THE IC NO FOR THE METER & ACCOUNT FROM CSS_MTRD_ENVRNMT *          
A04684****************************************************************          
A04684*                                                                         
A04684 7400-GET-IC-NO.                                                  
A04684*                                                                         
A04684     EXEC SQL                                                     
A04684        SELECT TOP(1) IC_NO                                              
A04684          INTO :MN-IC-NO                                          
A04684          FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
A04684          WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                   
A04684           AND  CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE               
A04684           AND  METER_NO       = :MN-METER-NO                     
A04684           AND  CODE_METER_STATUS <> 'K'                          
A04684                                       
A04684     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IC_NO                                                      
MFA-TR*         INTO :MN-IC-NO                                                  
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                           
MFA-TR*          AND  CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                       
MFA-TR*          AND  METER_NO       = :MN-METER-NO                             
MFA-TR*          AND  CODE_METER_STATUS = 'K'                                  
MFA-TR*    FETCH FIRST ROW ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684*                                                                         
A04684     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04684*                                                                         
A04684     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04684        CONTINUE                                                  
A04684     ELSE                                                         
A04684         DISPLAY '*******************************************'    
A04684         DISPLAY '  ABENDING PROGRAM '                            
A04684         DISPLAY '  CSS_MTRD_ENVRNMT '                            
A04684         DISPLAY '  7400-GET-IC-NO  '                             
A04684         DISPLAY ' RETURN CODE =  ' WS-ACTIVE-RETURN-CODE         
A04684         DISPLAY ' ACCOUNT-NO     ' MN-ACCOUNT-NO                 
A04684         DISPLAY ' CODE-UTIL-TYPE ' MN-CODE-UTIL-TYPE             
A04684         DISPLAY ' METER-NO       ' MN-METER-NO                   
A04684         DISPLAY '*******************************************'    
A04684         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04684     END-IF.                                                      
A04684*                                                                         
A04684 7400-EXIT.                                                       
A04684     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A05136*  CHECK TO SEE IF YO WANT THIS METER.  IF FOUND, YOU DO NOT   *          
A05136*    WANT THIS METER.  IT HAS BEEN SOLD TO ANOTHER COMPANY     *          
      ****************************************************************          
      *                                                                         
A05136 7450-ELEC-METER.                                                 
      *                                                                         
A05136     EXEC SQL                                                     
A05136        SELECT TOP(1) METER_SIZE_ID                                      
A05136          INTO :EM-METER-SIZE-ID                                  
A05136          FROM CSS_ELEC_METER WITH(READUNCOMMITTED)                       
A05136          WHERE METER_NO       = :EM-METER-NO                     
A05136           AND  COMPANY_NO     = :EM-COMPANY-NO                   
A05136           AND  CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE               
A05136           AND  METER_SIZE_ID  = :WS-METER-SIZE-ID                
A05136                                       
A05136     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_SIZE_ID                                              
MFA-TR*         INTO :EM-METER-SIZE-ID                                          
MFA-TR*         FROM CSS_ELEC_METER                                             
MFA-TR*         WHERE METER_NO       = :EM-METER-NO                             
MFA-TR*          AND  COMPANY_NO     = :EM-COMPANY-NO                           
MFA-TR*          AND  CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                       
MFA-TR*          AND  METER_SIZE_ID  = :WS-METER-SIZE-ID                        
MFA-TR*    FETCH FIRST ROW ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A05136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A05136     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A05136        CONTINUE                                                  
A05136     ELSE                                                         
A05136        DISPLAY '*******************************************'     
A05136        DISPLAY '  ABENDING PROGRAM '                             
A05136        DISPLAY '  CSS_ELEC_METER   '                             
A05136        DISPLAY '  7450-ELEC-METER '                              
A05136        DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
A05136        DISPLAY ' METER-NO       = ' EM-METER-NO                  
A05136        DISPLAY ' COMPANY-NO     = ' EM-COMPANY-NO                
A05136        DISPLAY ' CODE-UTIL-TYPE = ' EM-CODE-UTIL-TYPE            
A05136        DISPLAY '*******************************************'     
A05136        PERFORM 9900-ABEND THRU 9900-EXIT                         
A05136     END-IF.                                                      
      *                                                                         
A05136 7450-EXIT.                                                       
A05136     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET CURRENT DATE AND TIMESTAMP                            *          
      ****************************************************************          
      *                                                                         
       7500-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*          ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING CURRENT DATE OR TIMESTAMP'        
              DISPLAY ' 7500-GET-CURRENT-TIMESTAMP '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7600-START-FCSJC01                                          *          
      *  7610-READ-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  WRITE FIOBW06 RECORD                                      **          
      ****************************************************************          
      *                                                                         
       8000-WRITE-FIOBW06.                                              
      *                                                                         
           WRITE FIOBW06.                                               
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  WRITE FIOBW105 RECORD                                     **          
      ****************************************************************          
      *                                                                         
       8200-WRITE-FIOBW105.                                             
      *                                                                         
           WRITE FIOBW105.                                              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04684*==============================================================*          
A04684 8400-WRITE-FB-105O.                                              
A04684*==============================================================*          
A04684*                                                                         
A04684     WRITE FIOB105O.                                              
A04684*                                                                         
A04684 8400-EXIT.                                                       
A04684     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   NORMAL JOB TERMINATION                                     *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBW105-FILE                                          
                 FCSBW09-FILE                                           
                 FCSBW06-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  THIS INCLUDES 9700-PROCESS-ABEND                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD0023B                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  9900-ABEND                                                  *          
      *  THIS INCLUDES THE DB2 SQL ABEND MODULE AND ALSO PERFORMS    *          
      *  9000-TERMINATE.  THEN IT MOVES 12 TO RETURN CODE.           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
