       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW103.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      ** THIS PROGRAM WILL READ THE BE00 FILE OUTPUT BY BILLING.     **         
      ** IF A BILL HAS AN ADJUSTMENT REASON AND THE                  **         
      ** CSS_BILL_ADJ_REASN USER TABLE INDICATES THAT IT SHOULD      **         
      ** BE CONSIDERED A METER READER ERROR, THEN SELECT THE BILLING **         
      ** DETAIL TO BE PRINTED ON THE REPORT.  IF THE BILL DOES NOT   **         
      ** HAVE AN ADJUSTMENT REASON,THEN SELECT ANY OF THE CONSUMPTION**         
      ** ROWS BELONGING TO THE BILL WHICH HAVE A CORRECTED READING   **         
      ** FOR THE REPORT.  CREATE AN REPORT FILE FIOCA03 FOR PCSRP102 **         
      ** "PRINT METER READ CORRECTIONS".                             **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________  _____________________________________ **         
PCR672**  01/08/99     TDK      INITIAL CREATION OF REPORT           **         
      **                                                             **         
T18862**  01/13/99     TDK      DONT INCLUDE DIFF. OF +/- 1 UNIT WHEN**         
T18862**                        WRITING TO EXTRACT                   **         
T18994**  03/05/99     RAQ      ADD SOME COLUMNS TO REPORT           **         
T19585**  03/31/99     RAQ      ADDITIONAL ADJUSTMENTS TO REPORT     **         
T19655**  04/10/99     RAQ      SELECT ROUTE REPORT ONLY BY MATCHING **         
T19655**                        READ DATE FROM THE CORRECTED READ    **         
T20590**  08/06/99     CBSI     PERFORMING 8800-PROCESS-END-REC-TBL  **         
T20590**               MADRAS   WHICH INCREMENTS CO-NO-COUNTER ONLY  **         
T20590**                        WHEN WS-READING-DIFF NOT EQUAL TO +1 **         
T20590**                        OR -1                                **         
T20596**  01/19/2000   CBSI     EXPANDED THE COPYBOOK FIOCA103 TO    **         
T20596**               MADRAS   INCLUDE IRRGLR-MTR-CD1, IRRGLR-MTR-CD2*         
T20596**                        AND MTR-READ-COMMENTS AND WRITTEN TO **         
T20596**                        THE OUTPUT FILE                      **         
T23461**  01/09/2001   CBSI     CHANGES MADE TO AVOID MUTIPLE ROW    **         
T23461**               MADRAS   SELECTION.                           **         
T27781**  20/11/2002   COVANSYS ADDED IC_NO AS PART OF SELECT TO     **         
T27781**               CHENNAI  PREVENT -811                         **         
A01738**  26/02/2010   SP94986  1. REPLACE THE EMPLOYEE NO OF BE00   **         
A01738**                        TO METER_READER_ID FROM CSS_ROUTE_REPORT        
A01738**                        TABLE.                               **         
A01738**                        2. ADDED "WITH UR" CHANGES TO CURSORS**         
A01738**                        3. QUERYNO ADDED TO SELECT STATS.    **         
      *****************************************************************         
      **          ----BASIC SEQUENCE STRUCTURE ----                  **         
      **                                                             **         
      **  0000         MODULE CONTROL                                **         
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     **         
      **  1000 - 1999  FUNCTIONAL CONTROL                            **         
      **  2000 - 4999  DETAIL LOGIC                                  **         
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            **         
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  **         
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)**         
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)*         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBE00.                                                            
       COPY CSSCA103.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ******************************************************************        
      * CFDCA103 - FD FOR METER READ ERROR                             *        
      *            OUTPUT OF PCSBW103  (RUN 1)                         *        
      *            INPUT TO PCSRP102   (RUN 2)                         *        
      ******************************************************************        
      *                                                                         
       COPY CFDCA103.                                                           
       COPY FIOCA103.                                                           
       COPY CFDBE00.                                                            
       COPY FIOBE00.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW103'.
MSQ017     COPY MFASQLM.
       01  WS-MISC.                                                     
           05 WS-START                     PIC  X(40)                   
           VALUE 'WORKING STORAGE FOR PCSBW103 STARTS HERE'.            
           05  WS-ACCT-NO                  PIC S9(13) COMP-3 VALUE 0.   
           05  WS-BACKOUT-BG-INDX          PIC S9(4) COMP.              
           05  WS-CUST-BG-INDX             PIC S9(4) COMP.              
           05  WS-BACKOUT-BILL-FOUND       PIC X(01) VALUE SPACES.      
           05  WS-HOLD-BACKOUT-BG-INDX     PIC S9(4) COMP.              
           05  WS-BCKOUT-CX-INDX           PIC S9(4) COMP.              
COB305     05 WS-ORIGINAL-METER-READING        PIC S9(08)V999 COMP-3 
COB305       VALUE 0.       
COB305     05 WS-CORRECTED-METER-READING        PIC S9(08)V999 COMP-3 
COB305       VALUE 0.       
COB305     05 WS-READING-DIFF        PIC S9(08)V999 COMP-3 VALUE 0.       
           05  WS-DATE-READ                PIC X(10) VALUE SPACES.      
T18862     05  WS-ORIG-READ-DATE           PIC X(10) VALUE SPACES.      
           05  WS-TIME-PRD-TOU.                                         
               10 WS-CODE-TIME-PERIOD-N1   PIC 9(01)  VALUE 0.          
               10 WS-CODE-TOU-SEASN-C1     PIC X(01)  VALUE SPACES.     
           05  WS-MEASURE-CODE-C1          PIC X(01)  VALUE SPACES.     
           05  WS-MEASURE-CODE-C3          PIC X(03)  VALUE SPACES.     
           05  ROUTE-REPORT-FOUND          PIC X(01)  VALUE SPACES.     
           05  WS-FIRST-TIME               PIC X(01)  VALUE 'Y'.        
           05  WS-COMP-NO                  PIC X(02)  VALUE SPACES.     
           05  WS-PREV-COMP-NO             PIC X(02)  VALUE SPACES.     
COB305     05 WS-ACCOUNT-NUM        PIC S9(13)V COMP-3 VALUE 0.          
           05  WS-NO                       PIC X(01)  VALUE 'N'.        
           05  WS-YES                      PIC X(01)  VALUE 'Y'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-ERR-ORIG-BILL-FOUND      PIC X(01)  VALUE 'N'.        
           05  WS-ERR-REBILL-FOUND         PIC X(01)  VALUE 'N'.        
           05  WS-TOTAL-NAME               PIC X(50)  VALUE SPACES.     
           05  WS-TOT-CA103-COUNT          PIC S9(07) COMP-3 VALUE 0.   
           05  WS-PREVIOUS-ACCT-NO         PIC S9(13) COMP-3 VALUE 0.   
           05  WS-PREVIOUS-COMP-NO         PIC X(02)  VALUE SPACES.     
           05  WS-PREVIOUS-DATE            PIC X(10).                   
           05  WS-HOLD-DATE                PIC X(10).                   
           05  WS-NUM-EMPLOYEE-NO          PIC 9(05).                   
           05  WS-CHAR-EMPLOYEE-NO  REDEFINES WS-NUM-EMPLOYEE-NO        
                                           PIC X(05).                   
           05  WS-HOLD-ADJUSTMENT-CLASS    PIC X(01) VALUE SPACE.       
           05  WS-HOLD-ADJ-REASON-DESC     PIC X(25) VALUE SPACES.      
           05  WS-CAN-REBILL-CX-FOUND-CNTR PIC 9(03) VALUE ZEROES.      
           05  WS-ORIG-BILL-CX-FOUND-CNTR  PIC 9(03) VALUE ZEROES.      
           05  WS-MATCHING-CX-FOUND-FL     PIC  X(01) VALUE 'N'.        
           05  WS-MATCHING-REBILL-CX-FOUND PIC  X(01) VALUE 'N'.        
           05  WS-MATCHING-BACKOUT-CX-FOUND                             
                                           PIC  X(01) VALUE 'N'.        
           05  WS-HOLD-CNSMPTN-INDX        PIC S9(4) COMP.              
           05  WS-HOLD-BG-INDX             PIC S9(4) COMP.              
           05  WS-CX-INDX-2ND-LOOP         PIC S9(4) COMP.              
           05  WS-FCSBE00-ACCT-FLAG        PIC  X(01) VALUE 'N'.        
               88  FCSBE00-ACCT-NO-CHANGED            VALUE 'Y'.        
           05  WS-ACT-DTL-RECS             PIC S9(4) COMP.              
T27781     05  WS-IRR-MTR-IC-NO            PIC S9(04) COMP.             
                                                                        
       01  WS-USER-ID-KEY                  PIC X(80).                   
      *                                                                         
      * FIELDS USED WITH CPD00103                                               
                                                                        
       01  WS-CALLING-PARAGRAPH            PIC  X(04).                  
       01  WS-CWS-TABLE-ID                 PIC  9(04).                  
           88  WS-TABLE-AT-BI-BG-CX        VALUES                       
               0300 1900 1910 2100.                                     
      * ----------------------------------------------------------            * 
       01 WS-BILL-ADJ-ROWS-TABLE.                                       
          05 WS-BILL-ADJ-ROWS OCCURS 222 TIMES                          
                             INDEXED BY WS-BILL-ADJ-RSN-INDX.           
             10  WS-ADJ-REASON-CD          PIC  X(04).                  
             10  WS-CORRECTED-BILL-FL      PIC  X(01).                  
             10  WS-ADJUSTMENT-CLASS       PIC  X(01).                  
             10  WS-ADJ-REASON-DESC        PIC  X(25).                  
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-END-REC-PROCESSED        PIC  X(01) VALUE 'N'.        
           05  WS-FBE00-STATUS             PIC  X(02).                  
               88  FBE00-SUCCESSFUL                   VALUE '00'.       
           05  WS-FCA103-STATUS            PIC  X(02).                  
               88  FCA103-SUCCESSFUL                  VALUE '00'.       
           05  WS-BEGIN-REC-SW             PIC  X(01).                  
               88  WS-BEGIN-RECS-PROCESSED            VALUE 'Y'.        
               88  WS-BEGIN-REC-NOT-PROCESSED         VALUE 'N'.        
               88  WS-START-INPUT-DATA                VALUE 'X'.        
           05  WS-FCSBE00-FLAG             PIC  X(01) VALUE 'N'.        
               88  END-OF-FCSBE00                     VALUE 'Y'.        
           05  WS-BEGIN-REC-PROCESSED      PIC  X(01) VALUE 'N'.        
           05  WS-END-REC-PROCESS-BE01     PIC  X(01) VALUE 'N'.        
           05  WS-MORE-BEGIN-REC           PIC  X(01) VALUE 'N'.        
           05  WS-MORE-DATA-FBE00          PIC  X(01) VALUE 'Y'.        
               88  NO-MORE-DATA-FBE00                 VALUE 'N'.        
           05  WS-CNTRL-REC-FLAG           PIC  X(01) VALUE 'N'.        
           05  WS-ADJ-REASON-FLAG          PIC  X(01) VALUE 'N'.        
               88  ADJ-REASON-FOUND                   VALUE 'Y'.        
      *                                                                         
T18994 01  WS-READING-COND-CODE-DESC.                                   
T18994     05 FILLER PIC X(31) VALUE '1FAILED LOW-2'.                   
T18994     05 FILLER PIC X(31) VALUE '2FAILED LOW-1'.                   
T18994     05 FILLER PIC X(31) VALUE '3FAILED HIGH-1'.                  
T18994     05 FILLER PIC X(31) VALUE '4FAILED HIGH-2'.                  
T18994     05 FILLER PIC X(31) VALUE '5FAILED LOW-2,X IN MTR NO'.       
T18994     05 FILLER PIC X(31) VALUE '6FAILED HIGH-2,X IN MTR NO'.      
T18994     05 FILLER PIC X(31) VALUE '7ZERO CONSUMPTION ON ACTIVE MTR'. 
T18994     05 FILLER PIC X(31) VALUE '8CONSUMPTION ON INACTIVE METER'.  
T18994     05 FILLER PIC X(31) VALUE '9FAILED FULL SCALE'.              
T18994     05 FILLER PIC X(31) VALUE '0NORMAL READ'.                    
      *                                                                         
T18994 01  WS-READING-COND-CODE-DESC-RED REDEFINES                      
T18994                                   WS-READING-COND-CODE-DESC.     
T18994     05  WS-READING-COND-CODE-DESC-TBL OCCURS 10 TIMES            
T18994                                 INDEXED BY WS-TBL-INDX-1.        
T18994         10 WS-READING-COND-CODE         PIC X(01).               
T18994         10 WS-READING-COND-CODE-DESC-1  PIC X(30).               
      *                                                                         
T18994 01  WS-CODE-SOURCE-ID-DESC.                                      
T18994     05 FILLER PIC X(11) VALUE 'ASERV. ORD.'.                     
T18994     05 FILLER PIC X(11) VALUE 'BITRON     '.                     
T18994     05 FILLER PIC X(11) VALUE 'CONLINE    '.                     
T18994     05 FILLER PIC X(11) VALUE 'DESTIMATED '.                     
T18994     05 FILLER PIC X(11) VALUE 'MMV90      '.                     
T18994     05 FILLER PIC X(11) VALUE 'RREBILL    '.                     
      *                                                                         
T18994 01  WS-CODE-SOURCE-ID-DESC-RED REDEFINES WS-CODE-SOURCE-ID-DESC. 
T18994     05  WS-CODE-SOURCE-ID-DESC-TBL OCCURS 06 TIMES               
T18994                                 INDEXED BY WS-TBL-INDX-2.        
T18994         10 WS-CODE-SOURCE-ID            PIC X(01).               
T18994         10 WS-CODE-SOURCE-ID-DESC-1     PIC X(10).               
T18994*                                                                         
T18994 01  WS-ORIG-SOURCE-ID           PIC X(01).                       
      *------------------------------------------------------------*            
      * SINCE CPD00050 IS WRITTEN ON THE BASIS OF BE02 FIELDS                   
      * WE WILL READ BE00 AND MOVE BE00 RECORD TO BE02 RECORD                   
      * - BOTH FILES HAVE SAME LAYOUT                                           
      *------------------------------------------------------------*            
       COPY FIOBE02.                                                            
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME         PIC  X(08) VALUE 'PCSBW103'.         
      *                                                                         
      ******* JOBS FILE/TABLE DEFINITIONS                                       
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
                                                                        
      ******* CWS00038 IS JC01 WORK DATA                                        
       COPY CWS00038.                                                           
                                                                        
      ******* CWS00039 IS CA00 WORK DATA                                        
       COPY CWS00039.                                                           
                                                                        
      ******* CWS00050 IS THE TABLE ID VARIABLES                                
       COPY CWS00050.                                                           
                                                                        
      ******* CWS10000 CONTAINS BE00 RECORD LAYOUTS                             
      ** CWS10000 WAS SPLIT INTO CWS1000A & CWS1000B.                           
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
                                                                        
      ******* CWS10009 CONTAINS BE00 RECORD LAYOUTS                             
       COPY CWS10009.                                                           
       COPY CWS10006.                                                           
                                                                        
      ******* CWS00303 CONTAINS WS-WARNING-DATA-ELEMENTS                        
       COPY CWS00303.                                                           
                                                                        
      ******* CWS10005 CONTAINS WS FOR CPD00051                                 
       COPY CWS10005.                                                           
       COPY CWS09900.                                                           
                                                                        
      ******* CWS00104 CONTAINS WS FOR CPD00104 AND CPD00105                    
       COPY CWS00104.                                                           
      *                                                                         
            EXEC SQL                                                            
                 INCLUDE SQLCA                                                  
            END-EXEC.                                                           
                                                                        
      ****** TBJBPARM HAS BEEN INCLUDED TO GET RUN DATE                         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      ****** TBJBPARM HAS BEEN INCLUDED FOR CSS_ROUTE_REPORT                    
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRTERPT                                                
           END-EXEC.                                                            
                                                                        
      ****** TBUSRPRF HAS BEEN INCLUDED FOR CSS_UTIL_ENVRNMT                    
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      ****** TBLADRSN HAS BEEN INCLUDED FOR CSR_BILL_ADJ_REASN                  
                                                                        
           EXEC SQL                                                             
                INCLUDE TBLADRSN                                                
           END-EXEC.                                                            
                                                                        
T18994     EXEC SQL                                                             
T18994         INCLUDE TBNORDRN                                                 
T18994     END-EXEC.                                                            
                                                                        
T20596     EXEC SQL                                                             
T20596         INCLUDE TBIRMTRD                                                 
T20596     END-EXEC.                                                            
      *                                                                         
      *============================================================*            
      *                      DECLARE CURSORS                       *            
      *============================================================*            
      *                                                                         
      * 7231-FETCH-BILL-ADJ-REASN:                                              
           EXEC SQL                                                     
               DECLARE BILL_ADJ_RSN_CSR  CURSOR FOR                     
                SELECT  ADJ_REASON_CD,                                  
                        CORRECTED_BILL_FL,                              
                        ADJUSTMENT_CLASS,                               
                        ADJ_REASON_DESC                                 
                  FROM CSS_BILL_ADJ_REASN WITH(READUNCOMMITTED)                 
T18994           WHERE ADJUSTMENT_CLASS = 'M'                           
                 ORDER BY ADJ_REASON_CD                                 
A01738           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILL_ADJ_RSN_CSR  CURSOR FOR                             
MFA-TR*         SELECT  ADJ_REASON_CD,                                          
MFA-TR*                 CORRECTED_BILL_FL,                                      
MFA-TR*                 ADJUSTMENT_CLASS,                                       
MFA-TR*                 ADJ_REASON_DESC                                         
MFA-TR*           FROM CSS_BILL_ADJ_REASN                                       
MFA-TR*          WHERE ADJUSTMENT_CLASS = 'M'                                   
MFA-TR*          ORDER BY ADJ_REASON_CD                                         
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      * 7251-FETCH-ROUTE-REPORT-CSR:                                            
            EXEC SQL                                                    
               DECLARE ROUTE_REPORT_CSR  CURSOR FOR                     
                SELECT LAST_REG_READ_DT,                                
                       REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TM, 108), 
           ':', '.') LAST_REG_READ_TM,                                
                       READING_CODE,                                    
                       METER_READING,                                   
                       TYPE_OF_RD_IND,                                  
T18994                 READING_COND_CD,                                 
                       REG_MEASURE_CD,                                  
A01738                 METER_READER_ID                                  
                  FROM CSS_ROUTE_REPORT WITH(READUNCOMMITTED)                   
                 WHERE ACCOUNT_NO     = :PW-ACCOUNT-NO                  
                   AND CODE_UTIL_TYPE = :PW-CODE-UTIL-TYPE              
                   AND IC_NO          = :PW-IC-NO                       
                   AND METER_NO       = :PW-METER-NO                    
                   AND REG_MEASURE_CD = :PW-REG-MEASURE-CD              
T19655             AND LAST_REG_READ_DT = IIF(TRY_CONVERT(DATE, 
                                                   :PW-LAST-REG-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :PW-LAST-REG-READ-DT
              ) <> 0) OR (LEN(:PW-LAST-REG-READ-DT
              ) <> 10), CIS.CHAR2DATE(:PW-LAST-REG-READ-DT
              ), CONVERT(DATE, :PW-LAST-REG-READ-DT) )          
                 ORDER BY LAST_REG_READ_DT DESC, LAST_REG_READ_TM DESC  
A01738           FOR READ ONLY                                  
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*        DECLARE ROUTE_REPORT_CSR  CURSOR FOR                             
MFA-TR*         SELECT LAST_REG_READ_DT,                                        
MFA-TR*                LAST_REG_READ_TM,                                        
MFA-TR*                READING_CODE,                                            
MFA-TR*                METER_READING,                                           
MFA-TR*                TYPE_OF_RD_IND,                                          
MFA-TR*                READING_COND_CD,                                         
MFA-TR*                REG_MEASURE_CD,                                          
MFA-TR*                METER_READER_ID                                          
MFA-TR*           FROM CSS_ROUTE_REPORT                                         
MFA-TR*          WHERE ACCOUNT_NO     = :PW-ACCOUNT-NO                          
MFA-TR*            AND CODE_UTIL_TYPE = :PW-CODE-UTIL-TYPE                      
MFA-TR*            AND IC_NO          = :PW-IC-NO                               
MFA-TR*            AND METER_NO       = :PW-METER-NO                            
MFA-TR*            AND REG_MEASURE_CD = :PW-REG-MEASURE-CD                      
MFA-TR*            AND LAST_REG_READ_DT = :PW-LAST-REG-READ-DT                  
MFA-TR*          ORDER BY LAST_REG_READ_DT DESC, LAST_REG_READ_TM DESC          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*     END-EXEC.                                                           
      *                                                                         
                                                                        
       PROCEDURE DIVISION.                                              
      *****************************************************************         
      *                                                              **         
      *    0000-MAINLINE                                             **         
      *                                                              **         
      *    PERFORM INITIALIZATION TO OPEN FILES/INIT CWS10000 ETC    **         
      *                                                              **         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION       THRU 0100-EXIT.            
           PERFORM 0150-STORE-BILL-ADJ-REASN THRU 0150-EXIT.            
                                                                        
      * READ PAST ALL OF THE BEGIN RECORDS OF THE BE00 FILE.                    
      *                                                                         
           SET WS-BEGIN-REC-NOT-PROCESSED TO TRUE.                      
                                                                        
           MOVE WS-YES                TO WS-MORE-BEGIN-REC.             
                                                                        
           PERFORM 0500-PROCESS-BEGIN-REC     THRU 0500-EXIT            
               UNTIL WS-MORE-BEGIN-REC EQUAL WS-NO.                     
      **                                                                        
           IF END-OF-FCSBE00                                            
             DISPLAY '**     PCSBW103 PROCESSING ERROR      **'         
             DISPLAY '**       FCSBE00 FILE IS EMPTY        **'         
             DISPLAY '**       PROCESSING TERMINATED        **'         
             PERFORM 9900-ABEND               THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
           MOVE E-FBE00-ACCOUNT-NO TO WS-PREVIOUS-ACCT-NO.              
           MOVE E-FBE00-COMPANY-NO TO WS-PREVIOUS-COMP-NO.              
                                                                        
      * WRITE THE BEGIN RECORD FOR THE OUTPUT FILE.                             
                                                                        
           PERFORM 5100-WRITE-BEGIN-CONTROLS THRU 5100-EXIT.            
                                                                        
           SUBTRACT +1 FROM  WS-TOT-CA103-COUNT.                        
      *                                                                         
      *********************************************************                 
      * FETCH EACH ACCOUNT FROM THE BE00 FILE AND LOAD THEM   *                 
      * INTO THE COPYBOOKS TO BE SENT THROUGH LINKAGE FOR THE *                 
      * SUBMODULES TO DO THEIR PROCESSING.                    *                 
      *********************************************************                 
      *                                                                         
           PERFORM 2000-PROCESS-ACCOUNTS   THRU 2000-EXIT               
             UNTIL END-OF-FCSBE00.                                      
                                                                        
           PERFORM 8820-WRITE-CO-END-REC   THRU 8820-EXIT.              
                                                                        
      * WRITE THE END RECORD FOR THE OUTPUT FILE.                               
      *                                                                         
           PERFORM 5110-WRITE-END-CONTROLS THRU 5110-EXIT.              
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
      *                                                                         
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *    0100-INITIALIZATION                                       **         
      *                                                              **         
      *    OPEN FILES                                                **         
      *    READ JOBS TABLE TO OBTAIN RUN DATE/COMMON DATE            **         
      *                                                              **         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
      * OPEN THE INPUT FILE FOR PROCESSING                                      
      *                                                                         
           OPEN INPUT  FCSBE00-FILE.                                    
           IF NOT FBE00-SUCCESSFUL                                      
              DISPLAY '** PCSBW103  PROCESSING ERROR  **'               
              DISPLAY '** OPEN ERROR ON FILE FBE00 **'                  
              DISPLAY '** PROCESSING TERMINATED    **'                  
              DISPLAY '** STATUS IS ' WS-FBE00-STATUS                   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
            END-IF.                                                     
                                                                        
      * OPEN THE OUTPUT FILE FOR PROCESSING                                     
      *                                                                         
           OPEN OUTPUT FCSCA103-FILE.                                   
           IF NOT FCA103-SUCCESSFUL                                     
              DISPLAY '** PCSBW103  PROCESSING ERROR  **'               
              DISPLAY '** OPEN ERROR ON FILE FCA103   **'               
              DISPLAY '** PROCESSING TERMINATED    **'                  
              DISPLAY '** STATUS IS ' WS-FCA103-STATUS                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
           INITIALIZE COMPANY-END-REC-DATA.                             
                                                                        
      * GET THE COMMON DATE FROM THE JOB PARM DB2 TABLE.                        
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT.           
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE TO WS-HOLD-DATE.                          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 0150-STORE-BILL-ADJ-REASN.                                  *          
      **                                                             *          
      ****************************************************************          
       0150-STORE-BILL-ADJ-REASN.                                       
                                                                        
            PERFORM 7230-OPEN-BILL-ADJ-REASN      THRU 7230-EXIT.       
            SET WS-BILL-ADJ-RSN-INDX TO +1.                             
            PERFORM 7231-FETCH-BILL-ADJ-REASN     THRU 7231-EXIT        
            PERFORM 0155-LOAD-BILL-ADJ-REASN-DATA THRU 0155-EXIT        
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
            PERFORM 7232-CLOSE-BILL-ADJ-REASN     THRU 7232-EXIT.       
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 0155-LOAD-BILL-ADJ-REASN-DATA.                              *          
      **                                                             *          
      ****************************************************************          
       0155-LOAD-BILL-ADJ-REASN-DATA.                                   
                                                                        
            MOVE K0-ADJ-REASON-CD                                       
              TO WS-ADJ-REASON-CD     (WS-BILL-ADJ-RSN-INDX)            
            MOVE K0-CORRECTED-BILL-FL                                   
              TO WS-CORRECTED-BILL-FL (WS-BILL-ADJ-RSN-INDX)            
            MOVE K0-ADJUSTMENT-CLASS                                    
              TO WS-ADJUSTMENT-CLASS  (WS-BILL-ADJ-RSN-INDX)            
            MOVE K0-ADJ-REASON-DESC                                     
              TO WS-ADJ-REASON-DESC   (WS-BILL-ADJ-RSN-INDX)            
            SET WS-BILL-ADJ-RSN-INDX UP BY +1.                          
            PERFORM 7231-FETCH-BILL-ADJ-REASN THRU 7231-EXIT.           
       0155-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 0200-READ-ALL-RECS                                         **          
      ** THIS IS CALLED WHEN THE PROGRAM NEEDS TO GET THE NEXT RECORD*          
      ** FROM THE BE00 QSAM FILE.                                    *          
      ****************************************************************          
       0200-READ-ALL-RECS.                                              
      *                                                                         
           IF WS-END-REC-PROCESSED EQUAL WS-YES                         
             IF E-FBE00-KEY-EREC EQUAL HIGH-VALUES                      
                NEXT SENTENCE                                           
             ELSE                                                       
                DISPLAY '*       PCSBW103 PROCESSING ERROR       *'     
                DISPLAY '*  LAST RECORD IS NOT A CONTROL RECORD  *'     
                DISPLAY '* PROCESSING TERMINATED                 *'     
                PERFORM 9900-ABEND         THRU 9900-EXIT               
             END-IF                                                     
           ELSE                                                         
             IF E-FBE00-KEY-EREC EQUAL HIGH-VALUES                      
                MOVE WS-YES           TO WS-END-REC-PROCESSED           
             ELSE                                                       
               IF E-FBE00-ACCOUNT-NO EQUAL WS-PREVIOUS-ACCT-NO          
                 PERFORM 0250-LOAD-BY-TABLE-ID  THRU 0250-EXIT          
               ELSE                                                     
                 MOVE WS-YES          TO WS-FCSBE00-ACCT-FLAG           
                 GO TO 0200-EXIT                                        
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           PERFORM 7990-READ-FCSBE00          THRU 7990-EXIT.           
      *                                                                         
           IF END-OF-FCSBE00                                            
               IF E-FBE00-KEY-EREC  EQUAL HIGH-VALUES                   
                  NEXT SENTENCE                                         
               ELSE                                                     
                  DISPLAY '*       PCSBW103 PROCESSING ERROR       *'   
                  DISPLAY '*  LAST RECORD IS NOT A CONTROL RECORD  *'   
                  DISPLAY '* PROCESSING TERMINATED                 *'   
                  PERFORM 9900-ABEND         THRU 9900-EXIT             
               END-IF                                                   
           END-IF.                                                      
      **                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      ** 0250-LOAD-BY-TABLE-ID.                                     **          
      ** THIS PROCESS WILL DECIDE WHICH COPYBOOK AND ROUTINE TO USE **          
      ** TO LOAD THE DATA FROM THE BE00 FILE.                       **          
      ****************************************************************          
       0250-LOAD-BY-TABLE-ID.                                           
      **                                                                        
           MOVE E-FBE00-TABLE-ID TO WS-CWS-TABLE-ID.                    
                                                                        
           IF WS-TABLE-AT-BI-BG-CX                                      
              PERFORM 0800-LOAD-FBE02-WS-AREA THRU 0800-EXIT            
           END-IF.                                                      
      **                                                                        
       0250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 0500-PROCESS-BEGIN-REC                                     **          
      ** THIS PROCESS IS CALLED TO DO AN INITIAL READ OF THE BE00   **          
      ** QSAM FILE TO SEE IF IT IS EMPTY OR IF THE FIRST RECORD IS  **          
      ** NOT A CONTROL RECORD.                                      **          
      ****************************************************************          
       0500-PROCESS-BEGIN-REC.                                          
      **                                                                        
           PERFORM 7990-READ-FCSBE00          THRU 7990-EXIT.           
                                                                        
           IF END-OF-FCSBE00                                            
             DISPLAY '** PCSBW103 PROCESSING ERROR  **'                 
             DISPLAY '**   FCSBE00 FILE IS EMPTY    **'                 
             DISPLAY '**   PROCESSING TERMINATED    **'                 
             PERFORM 9900-ABEND               THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
           IF E-FBE00-KEY-BREC EQUAL LOW-VALUES                         
              MOVE WS-YES              TO WS-BEGIN-REC-PROCESSED        
           ELSE                                                         
              IF WS-BEGIN-REC-PROCESSED EQUAL WS-YES                    
                MOVE WS-NO              TO WS-MORE-BEGIN-REC            
                GO TO 0500-EXIT                                         
              ELSE                                                      
                DISPLAY '**       PCSBW103 PROCESSING ERROR        **'  
                DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'  
                DISPLAY '**         PROCESSING TERMINATED          **'  
                PERFORM 9900-ABEND           THRU 9900-EXIT             
              END-IF                                                    
           END-IF.                                                      
      **                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                              **         
      *    2000-PROCESS-ACCOUNTS                                     **         
      * THIS WILL CONTROL THE PROCESS OF GOING THROUGH THE QSAM FILES**         
      * AND CHECKING TO SEE IF ANY COMPARE SHOULD BE DONE FOR AN     **         
      * ACCOUNT.                                                     **         
      *                                                              **         
      *****************************************************************         
       2000-PROCESS-ACCOUNTS.                                           
                                                                        
      *    INITIALIZE LS-COMM-AREA-VARIABLES.                                   
                                                                        
           PERFORM  0609-INITIALIZE-FBE00-WS-AREA THRU 0609-EXIT.       
                                                                        
      * READ FROM THE BE00 FILE FOR ALL RECORDS FOR THE SAME ACCOUNT.           
      *                                                                         
           PERFORM 0200-READ-ALL-RECS THRU 0200-EXIT                    
             UNTIL FCSBE00-ACCT-NO-CHANGED OR END-OF-FCSBE00.           
      *                                                                         
           PERFORM 2100-PROCESS-EACH-BILL-DTL THRU 2100-EXIT.           
      *                                                                         
           MOVE WS-NO                 TO WS-FCSBE00-ACCT-FLAG.          
                                                                        
           MOVE E-FBE00-COMPANY-NO    TO WS-PREVIOUS-COMP-NO.           
           MOVE E-FBE00-ACCOUNT-NO    TO WS-PREVIOUS-ACCT-NO.           
           MOVE ZERO                  TO WS-ACT-DTL-RECS.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                              **         
      *    2100-PROCESS-EACH-BILL-DTL                                **         
      * THIS PARAGRAPH WILL CHECK EACH BG TO SEE WHETHER ANY METER   **         
      * CORRECTION/ADJUSMENT HAS TAKEN PLACE                         **         
      *                                                              **         
      *****************************************************************         
       2100-PROCESS-EACH-BILL-DTL.                                      
      *                                                                         
           SET WS-BILLING-INDX TO +1                                    
           MOVE 1              TO WS-CUST-BG-INDX.                      
           PERFORM UNTIL WS-BILLING-INDX > 30                           
                   OR WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = 0            
      *                                                                         
              MOVE ZEROES     TO WS-ORIGINAL-METER-READING              
              MOVE ZEROES     TO WS-CORRECTED-METER-READING             
              MOVE SPACES     TO WS-DATE-READ                           
      *                                                                         
T18994        MOVE WS-NO            TO WS-ERR-REBILL-FOUND              
T18994        PERFORM 2250-CHECK-REASON-CODE  THRU 2250-EXIT            
T18994        IF WS-ERR-REBILL-FOUND = WS-NO                            
T18994           CONTINUE                                               
T18994        ELSE                                                      
                IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) NOT = SPACES  
                   AND WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX)           
                                            NOT = LOW-VALUES            
T19655             AND WS-REBILL-IND-BG (WS-BILLING-INDX) NOT = WS-NO   
      *                                                                         
                   PERFORM 2200-PROCESS-CAN-REBILL THRU 2200-EXIT       
                ELSE                                                    
T19585             IF WS-CODE-BILL-ITM-TYPE-BG (WS-BILLING-INDX)        
T19585                NOT = 'B'                                         
                      PERFORM 2500-PROCESS-ORIG-BILL  THRU 2500-EXIT    
T19585             END-IF                                               
                END-IF                                                  
T18994        END-IF                                                    
              SET WS-BILLING-INDX UP BY +1                              
           END-PERFORM.                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      *    2200-PROCESS-CAN-REBILL                                   **         
      *                                                              **         
      *****************************************************************         
       2200-PROCESS-CAN-REBILL.                                         
      *                                                                         
A01738     MOVE 1                   TO WS-HOLD-CNSMPTN-INDX             
A01738                                 WS-BCKOUT-CX-INDX.               
      *                                                                         
           PERFORM UNTIL WS-ACCOUNT-NO-CX (WS-HOLD-CNSMPTN-INDX) = 0    
      *--BEFORE PROCESS REBILL REC GET THE CORRESPONDING BACKOUT REC            
              PERFORM 2210-GET-BACKOUT-BILL-INFO    THRU 2210-EXIT      
              PERFORM 2320-PROCESS-BACKOUT-CX       THRU 2320-EXIT      
              PERFORM 2300-PROCESS-REBILL-CX        THRU 2300-EXIT      
           END-PERFORM.                                                 
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      *    2210-GET-BACKOUT-BILL-INFO                                **         
      *                                                              **         
      *      STORE THE BACKOUT BILL INDEX - USING THE SAME PROCEDURE **         
      *      OF REBILL (2100-)                                       **         
      *                                                              **         
      *****************************************************************         
       2210-GET-BACKOUT-BILL-INFO.                                      
                                                                        
           IF WS-ACT-DTL-RECS = 0                                       
              MOVE 1                           TO WS-BACKOUT-BG-INDX    
           ELSE                                                         
              MOVE WS-ACT-DTL-RECS             TO WS-BACKOUT-BG-INDX    
              ADD 1                            TO WS-BACKOUT-BG-INDX    
           END-IF                                                       
           MOVE 1                           TO WS-HOLD-BACKOUT-BG-INDX  
           MOVE 'N'                         TO WS-BACKOUT-BILL-FOUND    
      *                                                                         
           PERFORM UNTIL WS-BACKOUT-BG-INDX    > 30 OR                  
                         WS-BACKOUT-BILL-FOUND = 'Y'                    
              IF WS-DATE-ORIG-BILL-BG (WS-BACKOUT-BG-INDX) NOT = SPACES 
                AND WS-DATE-ORIG-BILL-BG (WS-BACKOUT-BG-INDX)           
                                                       NOT = LOW-VALUES 
                AND WS-CODE-BILL-ITM-TYPE-BG (WS-BACKOUT-BG-INDX) = 'B' 
T18994          AND WS-CODE-UTIL-TYPE-BG     (WS-BACKOUT-BG-INDX) =     
T18994              WS-CODE-UTIL-TYPE-BG     (WS-BILLING-INDX)          
T19585          AND WS-DATE-ORIG-BILL-BG (WS-BACKOUT-BG-INDX) =         
T19585              WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX)              
                    MOVE 'Y'                TO WS-BACKOUT-BILL-FOUND    
                    MOVE WS-BACKOUT-BG-INDX TO WS-HOLD-BACKOUT-BG-INDX  
              END-IF                                                    
              ADD 1                         TO WS-BACKOUT-BG-INDX       
           END-PERFORM.                                                 
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      *    2250-CHECK-REASON-CODE                                    **         
      *                                                              **         
      *                                                              **         
      *****************************************************************         
       2250-CHECK-REASON-CODE.                                          
      *                                                                         
           SET WS-BILL-ADJ-RSN-INDX TO +1.                              
           MOVE SPACES  TO WS-HOLD-ADJUSTMENT-CLASS,                    
                           WS-HOLD-ADJ-REASON-DESC.                     
T18994     MOVE WS-NO   TO WS-ADJ-REASON-FLAG                           
           PERFORM UNTIL WS-BILL-ADJ-RSN-INDX >=  222                   
                      OR WS-ERR-REBILL-FOUND = WS-YES                   
              IF WS-ADJ-REASON-CD(WS-BILL-ADJ-RSN-INDX) =               
                 WS-ADJ-REASON-CD-BG(WS-BILLING-INDX)                   
      *                                                                         
                 MOVE WS-ADJUSTMENT-CLASS (WS-BILL-ADJ-RSN-INDX)        
                   TO WS-HOLD-ADJUSTMENT-CLASS                          
                 MOVE WS-ADJ-REASON-DESC (WS-BILL-ADJ-RSN-INDX)         
                   TO WS-HOLD-ADJ-REASON-DESC                           
                 MOVE WS-YES                                            
                   TO WS-ERR-REBILL-FOUND                               
                 MOVE WS-YES                                            
                   TO WS-ADJ-REASON-FLAG                                
              ELSE                                                      
                 SET WS-BILL-ADJ-RSN-INDX UP BY +1                      
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      *    2300-PROCESS-REBILL-CX.                                **            
      *                                                              **         
      *    FOR REBILL RELATED CONSUMTION/CX                          **         
      *                                                              **         
      *****************************************************************         
       2300-PROCESS-REBILL-CX.                                          
      *                                                                         
           SET WS-CNSMPTN-INDX       TO +1.                             
           MOVE ZERO                 TO WS-CAN-REBILL-CX-FOUND-CNTR     
           MOVE WS-NO                TO WS-MATCHING-REBILL-CX-FOUND     
                                                                        
           PERFORM UNTIL WS-CNSMPTN-INDX              > 100             
                OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = 0               
                OR WS-MATCHING-REBILL-CX-FOUND        = WS-YES          
      *                                                                         
              IF WS-BILLING-KEY (WS-BILLING-INDX) =                     
                   WS-BILLING-KEY-CX(WS-HOLD-CNSMPTN-INDX)              
                AND WS-CODE-METER-READ-CX (WS-HOLD-CNSMPTN-INDX) = 'X'  
                    PERFORM 2350-EXTRACT-REBILL-CX-INFO THRU 2350-EXIT  
                    ADD 1 TO WS-CAN-REBILL-CX-FOUND-CNTR                
                    MOVE WS-YES          TO WS-MATCHING-REBILL-CX-FOUND 
              END-IF                                                    
              SET WS-CNSMPTN-INDX UP BY +1                              
              ADD  1                     TO WS-HOLD-CNSMPTN-INDX        
           END-PERFORM.                                                 
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      *    2320-PROCESS-BACKOUT-CX.                                  **         
      *                                                              **         
      *    FOR BACKOUT RELATED CONSUMTION/CX                         **         
      *    - USING WS-HOLD-BACKOUT-BG-INDX(2210-)                    **         
      *                                                              **         
      *****************************************************************         
       2320-PROCESS-BACKOUT-CX.                                         
                                                                        
           SET WS-CNSMPTN-INDX           TO +1.                         
           MOVE WS-NO                TO WS-MATCHING-BACKOUT-CX-FOUND    
T18994     MOVE SPACES               TO WS-ORIG-SOURCE-ID               
      *                                                                         
           PERFORM UNTIL WS-CNSMPTN-INDX              > 100             
                OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = 0               
                OR WS-MATCHING-BACKOUT-CX-FOUND       = WS-YES          
      *                                                                         
              IF WS-BILLING-KEY (WS-HOLD-BACKOUT-BG-INDX) =             
                   WS-BILLING-KEY-CX(WS-BCKOUT-CX-INDX)                 
                    PERFORM 2360-EXTRACT-BACKOUT-CX-INFO THRU 2360-EXIT 
                    MOVE WS-YES        TO WS-MATCHING-BACKOUT-CX-FOUND  
              END-IF                                                    
              SET WS-CNSMPTN-INDX UP BY +1                              
              ADD 1                    TO WS-BCKOUT-CX-INDX             
           END-PERFORM.                                                 
      *                                                                         
           ADD +1             TO WS-CUST-BG-INDX.                       
      *                                                                         
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      *    2350-EXTRACT-REBILL-CX-INFO.                              **         
      *                                                              **         
      *****************************************************************         
       2350-EXTRACT-REBILL-CX-INFO.                                     
                                                                        
           MOVE WS-DATE-READ-CX (WS-HOLD-CNSMPTN-INDX)                  
             TO WS-DATE-READ                                            
T19655          PW-LAST-REG-READ-DT                                     
           IF WS-CODE-USAGE-TYPE-CX (WS-HOLD-CNSMPTN-INDX)              
               NOT EQUAL 'B' AND 'C'                                    
              MOVE WS-DEMAND-READING-CX (WS-HOLD-CNSMPTN-INDX)          
                TO WS-CORRECTED-METER-READING                           
           ELSE                                                         
              MOVE WS-METER-READING-CX (WS-HOLD-CNSMPTN-INDX)           
                TO WS-CORRECTED-METER-READING                           
           END-IF.                                                      
T18994     MOVE SPACES TO PW-READING-CODE                               
T18994                    PW-READING-COND-CD                            
A01738                    PW-METER-READER-ID                            
T18994     IF WS-MATCHING-BACKOUT-CX-FOUND = WS-YES                     
T18994        AND WS-ORIG-SOURCE-ID = 'B'                               
              PERFORM 7255-OPEN-RT-REPORT-CSR           THRU 7255-EXIT  
              PERFORM 7251-FETCH-ROUTE-REPORT-CSR       THRU 7251-EXIT  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T18862           MOVE PW-LAST-REG-READ-DT TO WS-ORIG-READ-DATE          
T18994        END-IF                                                    
              PERFORM 7252-CLOSE-ROUTE-REPORT-CSR       THRU 7252-EXIT  
           END-IF.                                                      
           PERFORM 3000-FORMAT-CANREBILL-DETAIL  THRU 3000-EXIT.        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      *    2360-EXTRACT-BACKOUT-CX-INFO.                             **         
      *                                                              **         
      *****************************************************************         
       2360-EXTRACT-BACKOUT-CX-INFO.                                    
                                                                        
           IF WS-CODE-USAGE-TYPE-CX (WS-CNSMPTN-INDX)                   
               NOT EQUAL 'B' AND 'C'                                    
              MOVE WS-DEMAND-READING-CX (WS-CNSMPTN-INDX)               
                TO WS-ORIGINAL-METER-READING                            
           ELSE                                                         
              MOVE WS-METER-READING-CX (WS-CNSMPTN-INDX)                
                 TO WS-ORIGINAL-METER-READING                           
           END-IF.                                                      
T18994     MOVE WS-DATE-READ-CX (WS-CNSMPTN-INDX)                       
T18994       TO WS-ORIG-READ-DATE                                       
T18994     MOVE WS-CODE-SOURCE-ID-CX (WS-CNSMPTN-INDX)                  
T18994       TO WS-ORIG-SOURCE-ID.                                      
      *                                                                         
       2360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *==> NOT USED ***                                              **         
      *    2370-LOAD-ORIG-CORR-READ.                                 **         
      *                                                              **         
      *****************************************************************         
       2370-LOAD-ORIG-CORR-READ.                                        
                                                                        
           MOVE WS-NO TO WS-MATCHING-CX-FOUND-FL                        
           MOVE 1  TO WS-CX-INDX-2ND-LOOP.                              
                                                                        
           PERFORM UNTIL WS-CX-INDX-2ND-LOOP > 100                      
                OR WS-ACCOUNT-NO-CX (WS-CX-INDX-2ND-LOOP) = 0           
                OR WS-MATCHING-CX-FOUND-FL = WS-YES                     
              IF WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX)               =     
                     WS-ACCOUNT-NO-CX (WS-CX-INDX-2ND-LOOP)             
                 AND WS-BILL-NO-CX (WS-CNSMPTN-INDX)              =     
                     WS-BILL-NO-CX (WS-CX-INDX-2ND-LOOP)                
                 AND WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX)       =     
                     WS-CODE-UTIL-TYPE-CX (WS-CX-INDX-2ND-LOOP)         
                 AND WS-IC-NO-CX (WS-CNSMPTN-INDX)                =     
                     WS-IC-NO-CX (WS-CX-INDX-2ND-LOOP)                  
                 AND WS-MTR-REF-NO-CX (WS-CNSMPTN-INDX)           =     
                     WS-MTR-REF-NO-CX (WS-CX-INDX-2ND-LOOP)             
                 AND WS-REG-ID-NO-CX (WS-CNSMPTN-INDX)            =     
                     WS-REG-ID-NO-CX (WS-CX-INDX-2ND-LOOP)              
                 AND WS-CODE-TIME-PERIOD-CX(WS-CNSMPTN-INDX) =          
                     WS-CODE-TIME-PERIOD-CX (WS-CX-INDX-2ND-LOOP)       
                 AND WS-ITEM-SEQ-NO-CX(WS-CNSMPTN-INDX)           =     
                     WS-ITEM-SEQ-NO-CX(WS-CX-INDX-2ND-LOOP)             
                 AND (WS-BILL-ITEM-TIMESTMP-CX(WS-CNSMPTN-INDX)         
                   NOT = WS-BILL-ITEM-TIMESTMP-CX (WS-CX-INDX-2ND-LOOP))
      * CAPTURE CX INFO                                                         
                   MOVE WS-METER-READING-CX (WS-CNSMPTN-INDX)           
                     TO WS-ORIGINAL-METER-READING                       
                   MOVE WS-DATE-READ-CX (WS-CNSMPTN-INDX)               
                     TO WS-DATE-READ                                    
                   MOVE WS-METER-READING-CX (WS-CX-INDX-2ND-LOOP)       
                     TO WS-CORRECTED-METER-READING                      
                                                                        
                   PERFORM 3000-FORMAT-CANREBILL-DETAIL  THRU 3000-EXIT 
                                                                        
                   MOVE WS-YES TO WS-MATCHING-CX-FOUND-FL               
              END-IF                                                    
                   ADD 1 TO  WS-CX-INDX-2ND-LOOP                        
           END-PERFORM.                                                 
       2370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      *  2500-PROCESS-ORIG-BILL                                      **         
      * THIS PARAGRAPH PROCESS THE ADJUSTMENT                        **         
      *                                                              **         
      *****************************************************************         
       2500-PROCESS-ORIG-BILL.                                          
      *                                                                         
           SET WS-CNSMPTN-INDX TO +1.                                   
           MOVE 1              TO  WS-HOLD-CNSMPTN-INDX.                
           MOVE ZERO           TO  WS-ORIG-BILL-CX-FOUND-CNTR.          
                                                                        
           PERFORM UNTIL WS-CNSMPTN-INDX > 100                          
                OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = 0               
              IF WS-BILLING-KEY (WS-BILLING-INDX) =                     
                    WS-BILLING-KEY-CX(WS-CNSMPTN-INDX)                  
                AND WS-CODE-METER-READ-CX (WS-CNSMPTN-INDX) = 'X'       
      *ML                                                                       
                AND WS-EXCEPT-OVERRIDE-CD-CX (WS-CNSMPTN-INDX) NOT =    
                                                             SPACES     
              ADD 1 TO  WS-ORIG-BILL-CX-FOUND-CNTR                      
              MOVE WS-NO                       TO ROUTE-REPORT-FOUND    
T19655        MOVE WS-DATE-READ-CX (WS-CNSMPTN-INDX)                    
T19655                                         TO PW-LAST-REG-READ-DT   
              PERFORM 7250-OPEN-ROUTE-REPORT-CSR        THRU 7250-EXIT  
                                                                        
      *---------------------------------------------------------                
      *-- COMMENTOUT  "UNTIL" IF ONE/FIRST ROW IS REQUIRED !   *                
      *---------------------------------------------------------                
              PERFORM 2600-GET-ROUTE-REPORT-DATA        THRU 2600-EXIT  
              PERFORM 7252-CLOSE-ROUTE-REPORT-CSR       THRU 7252-EXIT  
              END-IF                                                    
              SET WS-CNSMPTN-INDX UP BY +1                              
              ADD +1                 TO WS-HOLD-CNSMPTN-INDX            
           END-PERFORM.                                                 
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
                                                                        
      *****************************************************************         
      *                                                              **         
      *  2600-GET-ROUTE-REPORT-DATA                                  **         
      *       GET THE FIRST ROW FROM THE CURSOR !                    **         
      *                                                              **         
      *****************************************************************         
       2600-GET-ROUTE-REPORT-DATA.                                      
      *                                                                         
T19655     MOVE SPACES TO PW-READING-CODE                               
T19655                    PW-READING-COND-CD                            
T19655     MOVE ZEROS  TO PW-METER-READING                              
           PERFORM 7251-FETCH-ROUTE-REPORT-CSR     THRU 7251-EXIT.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T19655                                 OR NOT-FOUND                     
              MOVE PW-METER-READING    TO WS-ORIGINAL-METER-READING     
T18862        MOVE PW-LAST-REG-READ-DT TO WS-ORIG-READ-DATE             
              PERFORM 3100-FORMAT-ORIG-BILL-DETAIL THRU 3100-EXIT       
              MOVE WS-YES              TO ROUTE-REPORT-FOUND            
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      *  2800-CONV-MEASURE-CD-1-TO-3CHR                                         
      *                                                              **         
      *****************************************************************         
       2800-CONV-MEASURE-CD-1-TO-3CHR.                                  
                                                                        
           MOVE WS-CODE-USAGE-TYPE-CX (WS-HOLD-CNSMPTN-INDX)            
             TO WS-MEASURE-CODE-C1                                      
                                                                        
           EVALUATE WS-MEASURE-CODE-C1                                  
              WHEN 'B'                                                  
                 MOVE 'KWH'     TO WS-MEASURE-CODE-C3                   
              WHEN 'C'                                                  
                 MOVE 'GAS'     TO WS-MEASURE-CODE-C3                   
              WHEN 'J'                                                  
                 MOVE 'KW'      TO WS-MEASURE-CODE-C3                   
              WHEN 'E'                                                  
                 MOVE 'KVA'     TO WS-MEASURE-CODE-C3                   
              WHEN OTHER                                                
                 MOVE '---'     TO WS-MEASURE-CODE-C3                   
           END-EVALUATE.                                                
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *****************************************************************         
      *                                                              **         
      *  3000-FORMAT-CANREBILL-DETAIL                                **         
      * THIS PARAGRAPH POPULATES ALL THE FIELDS IN OUTPUT RECORD     **         
      * AND ADDS THE DATA RECORD TO COMPANY END TOTAL RECORD         **         
      *****************************************************************         
       3000-FORMAT-CANREBILL-DETAIL.                                    
      *                                                                         
T18994     MOVE WS-CODE-SOURCE-ID-CX (WS-HOLD-CNSMPTN-INDX)             
T18994       TO E-FCA103-CODE-SOURCE-ID                                 
T18994     MOVE 'Y'                 TO E-FCA103-CODE-BILL-ITM-IND       
T18994     MOVE ' '                 TO E-FCA103-READING-COND-CD         
T18994     MOVE ' '                 TO E-FCA103-READING-COND-CD-DESC    
      *                                                                         
           MOVE SPACES                       TO WS-TIME-PRD-TOU.        
           MOVE WS-PREVIOUS-ACCT-NO          TO E-FCA103-ACCOUNT-NO.    
           MOVE WS-PREVIOUS-COMP-NO          TO E-FCA103-COMPANY-NO.    
           MOVE WS-HOLD-ADJ-REASON-DESC     TO E-FCA103-ADJ-REASON-DESC.
      *                                                                         
           PERFORM 2800-CONV-MEASURE-CD-1-TO-3CHR THRU 2800-EXIT.       
           MOVE WS-ORIGINAL-METER-READING                               
             TO E-FCA103-ORIGINAL-READ                                  
           MOVE WS-CORRECTED-METER-READING                              
             TO E-FCA103-CORRECTED-READ                                 
           MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                   
             TO E-FCA103-UTILITY-TYPE                                   
T27781     MOVE WS-IC-NO-BG(WS-BILLING-INDX)                            
T27781       TO WS-IRR-MTR-IC-NO                                        
           MOVE SPACES                                                  
             TO E-FCA103-EMPLOYEE-PFX                                   
T18994     MOVE WS-EMPLOYEE-NO-CX (WS-HOLD-CNSMPTN-INDX)                
             TO WS-NUM-EMPLOYEE-NO                                      
           MOVE WS-CHAR-EMPLOYEE-NO                                     
             TO E-FCA103-EMPLOYEE-NO                                    
A01738*                                                                         
A01738     IF PW-METER-READER-ID > SPACES                               
A01738        MOVE PW-METER-READER-ID TO E-FCA103-EMPLOYEE-NO           
A01738     END-IF.                                                      
A01738*                                                                         
           MOVE WS-METER-NO-CX (WS-HOLD-CNSMPTN-INDX)                   
             TO E-FCA103-METER-NO                                       
           MOVE WS-DATE-READ                                            
             TO E-FCA103-READ-DATE                                      
           MOVE WS-ORIG-READ-DATE                                       
             TO E-FCA103-ORIG-DATE                                      
           MOVE WS-MEASURE-CODE-C3                                      
             TO E-FCA103-READ-TYPE                                      
           MOVE WS-CODE-TIME-PERIOD-CX(WS-HOLD-CNSMPTN-INDX)            
             TO WS-CODE-TIME-PERIOD-N1                                  
           MOVE WS-CODE-TOU-SEASN-CX (WS-HOLD-CNSMPTN-INDX)             
             TO WS-CODE-TOU-SEASN-C1                                    
T18335     IF WS-MEASURE-CODE-C3 NOT = 'KWH' AND NOT = 'GAS'            
              MOVE WS-TIME-PRD-TOU   TO E-FCA103-TOU-CODE               
T18335     END-IF                                                       
      *                                                                         
      *--GET ROUTE NO FROM CSS_UTIL_ENVRNMT                                     
           MOVE E-FCA103-ACCOUNT-NO           TO UT-ACCOUNT-NO          
           MOVE E-FCA103-UTILITY-TYPE         TO UT-CODE-UTIL-TYPE      
           MOVE WS-IC-NO-CX (WS-HOLD-CNSMPTN-INDX) TO UT-IC-NO          
           PERFORM 7300-GET-ROUTE-FROM-UT     THRU 7300-EXIT            
           MOVE UT-READ-ROUTE                 TO  E-FCA103-ROUTE-NO     
      *                                                                         
T18994     PERFORM 3110-FIND-READING-COND THRU 3110-EXIT                
T18862     IF WS-MEASURE-CODE-C3 = 'KWH' OR 'GAS'                       
T18862        COMPUTE WS-READING-DIFF =                                 
T18862         (WS-ORIGINAL-METER-READING - WS-CORRECTED-METER-READING) 
T18862        IF WS-READING-DIFF EQUAL +1 OR -1                         
T18862           CONTINUE                                               
T18862        ELSE                                                      
T20596           PERFORM 3200-LOAD-MTR-IRRGLARITY   THRU 3200-EXIT      
                 PERFORM 8500-WRITE-FIOCA103-RECORD THRU 8500-EXIT      
                 ADD 1                            TO WS-ACT-DTL-RECS    
T20590           MOVE WS-PREVIOUS-COMP-NO         TO CMP-COMPANY-NO     
T20590           PERFORM 8800-PROCESS-END-REC-TBL THRU 8800-EXIT        
T18862        END-IF                                                    
T18862     ELSE                                                         
T20596        PERFORM 3200-LOAD-MTR-IRRGLARITY   THRU 3200-EXIT         
              PERFORM 8500-WRITE-FIOCA103-RECORD THRU 8500-EXIT         
              ADD 1                            TO WS-ACT-DTL-RECS       
T20590        MOVE WS-PREVIOUS-COMP-NO         TO CMP-COMPANY-NO        
T20590        PERFORM 8800-PROCESS-END-REC-TBL THRU 8800-EXIT           
T18862     END-IF.                                                      
      *                                                                         
T18862     MOVE 0                           TO WS-READING-DIFF.         
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      *  3100-FORMAT-ORIG-BILL-DETAIL                                **         
      * THIS PARAGRAPH POPULATES ALL THE FIELDS IN OUTPUT RECORD     **         
      * AND ADDS THE DATA RECORD TO COMPANY END TOTAL RECORD         **         
      *****************************************************************         
       3100-FORMAT-ORIG-BILL-DETAIL.                                    
                                                                        
T18994     MOVE WS-CODE-SOURCE-ID-CX (WS-CNSMPTN-INDX)                  
T18994       TO E-FCA103-CODE-SOURCE-ID                                 
T19655     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T19655        MOVE SPACES           TO WS-ORIG-SOURCE-ID                
T19655     ELSE                                                         
T18994        MOVE 'B'              TO WS-ORIG-SOURCE-ID                
T19655     END-IF                                                       
T18994     MOVE ' '                 TO E-FCA103-CODE-BILL-ITM-IND       
T19585     IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) NOT = SPACES AND   
T19585        WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) NOT = LOW-VALUES   
T19585        MOVE 'Y'              TO E-FCA103-CODE-BILL-ITM-IND       
T19585     END-IF                                                       
T18994     MOVE PW-READING-COND-CD  TO E-FCA103-READING-COND-CD         
           MOVE SPACES                       TO WS-TIME-PRD-TOU.        
           MOVE WS-PREVIOUS-ACCT-NO          TO E-FCA103-ACCOUNT-NO.    
           MOVE WS-PREVIOUS-COMP-NO          TO E-FCA103-COMPANY-NO.    
      *                                                                         
           MOVE WS-HOLD-ADJ-REASON-DESC   TO E-FCA103-ADJ-REASON-DESC   
           IF WS-CODE-USAGE-TYPE-CX (WS-CNSMPTN-INDX)                   
               NOT EQUAL 'B' AND 'C'                                    
              MOVE WS-DEMAND-READING-CX (WS-CNSMPTN-INDX)               
                TO WS-CORRECTED-METER-READING                           
           ELSE                                                         
              MOVE WS-METER-READING-CX (WS-CNSMPTN-INDX)                
                TO WS-CORRECTED-METER-READING                           
           END-IF                                                       
           MOVE WS-DATE-READ-CX (WS-CNSMPTN-INDX)                       
             TO WS-DATE-READ                                            
A01738*                                                                         
A01738     MOVE SPACES                    TO E-FCA103-EMPLOYEE-PFX      
T18994     MOVE WS-EMPLOYEE-NO-CX (WS-CNSMPTN-INDX)                     
             TO WS-NUM-EMPLOYEE-NO                                      
           MOVE WS-CHAR-EMPLOYEE-NO                                     
             TO E-FCA103-EMPLOYEE-NO                                    
A01738*                                                                         
A01738     IF PW-METER-READER-ID > SPACES                               
A01738        MOVE PW-METER-READER-ID     TO E-FCA103-EMPLOYEE-NO       
A01738     END-IF                                                       
A01738*                                                                         
           MOVE WS-METER-NO-CX (WS-CNSMPTN-INDX)                        
             TO E-FCA103-METER-NO                                       
           MOVE WS-DATE-READ                                            
             TO E-FCA103-READ-DATE                                      
           MOVE WS-ORIG-READ-DATE                                       
             TO E-FCA103-ORIG-DATE                                      
      *                                                                         
           PERFORM 2800-CONV-MEASURE-CD-1-TO-3CHR  THRU 2800-EXIT       
      *                                                                         
           IF WS-MEASURE-CODE-C3 = 'KW' OR                              
              WS-MEASURE-CODE-C3 = 'KVA'                                
                 COMPUTE WS-ORIGINAL-METER-READING =                    
                         WS-ORIGINAL-METER-READING / 1000               
           END-IF.                                                      
      *                                                                         
           MOVE WS-ORIGINAL-METER-READING                               
             TO E-FCA103-ORIGINAL-READ                                  
           MOVE WS-CORRECTED-METER-READING                              
             TO E-FCA103-CORRECTED-READ                                 
           MOVE WS-MEASURE-CODE-C3                                      
             TO E-FCA103-READ-TYPE                                      
           MOVE WS-CODE-TIME-PERIOD-CX(WS-CNSMPTN-INDX)                 
             TO WS-CODE-TIME-PERIOD-N1                                  
           MOVE WS-CODE-TOU-SEASN-CX (WS-CNSMPTN-INDX)                  
             TO WS-CODE-TOU-SEASN-C1                                    
T18335     IF WS-MEASURE-CODE-C3 NOT = 'KWH' AND NOT = 'GAS'            
              MOVE WS-TIME-PRD-TOU   TO E-FCA103-TOU-CODE               
T18335     END-IF                                                       
      *----                                                                     
           MOVE WS-CORRECTED-METER-READING   TO E-FCA103-CORRECTED-READ 
           MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                   
             TO E-FCA103-UTILITY-TYPE                                   
T27781     MOVE WS-IC-NO-BG(WS-BILLING-INDX)                            
T27781       TO WS-IRR-MTR-IC-NO                                        
      * GET ROUTE NO                                                            
           MOVE E-FCA103-ACCOUNT-NO           TO UT-ACCOUNT-NO          
           MOVE E-FCA103-UTILITY-TYPE         TO UT-CODE-UTIL-TYPE      
           MOVE WS-IC-NO-CX (WS-CNSMPTN-INDX) TO UT-IC-NO               
           PERFORM 7300-GET-ROUTE-FROM-UT     THRU 7300-EXIT            
           MOVE UT-READ-ROUTE                 TO  E-FCA103-ROUTE-NO     
T18994     PERFORM 3110-FIND-READING-COND THRU 3110-EXIT                
      *                                                                         
T18862     IF WS-MEASURE-CODE-C3 = 'KWH' OR 'GAS'                       
T18862        COMPUTE WS-READING-DIFF =                                 
T18862         (WS-ORIGINAL-METER-READING - WS-CORRECTED-METER-READING) 
T18862        IF WS-READING-DIFF EQUAL +1 OR -1                         
T18862           CONTINUE                                               
T18862        ELSE                                                      
T20596           PERFORM 3200-LOAD-MTR-IRRGLARITY   THRU 3200-EXIT      
                 PERFORM 8500-WRITE-FIOCA103-RECORD THRU 8500-EXIT      
                 ADD 1                            TO WS-ACT-DTL-RECS    
T20590           MOVE WS-PREVIOUS-COMP-NO         TO CMP-COMPANY-NO     
T20590           PERFORM 8800-PROCESS-END-REC-TBL THRU 8800-EXIT        
T18862        END-IF                                                    
T18862     ELSE                                                         
T20596        PERFORM 3200-LOAD-MTR-IRRGLARITY   THRU 3200-EXIT         
              PERFORM 8500-WRITE-FIOCA103-RECORD THRU 8500-EXIT         
              ADD 1                            TO WS-ACT-DTL-RECS       
T20590        MOVE WS-PREVIOUS-COMP-NO         TO CMP-COMPANY-NO        
T20590        PERFORM 8800-PROCESS-END-REC-TBL THRU 8800-EXIT           
T18862     END-IF.                                                      
      *                                                                         
T18862     MOVE 0                           TO WS-READING-DIFF.         
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
T18994*3110-FIND-READING-COND.                                        *         
      *****************************************************************         
T18994 3110-FIND-READING-COND.                                          
T18994     MOVE WS-LOCAL-OFFICE-AT           TO E-FCA103-LOCAL-OFFICE.  
T18994*                                                                         
T18994     MOVE SPACES TO E-FCA103-CODE-SOURCE-ID-DESC                  
T18994     SET WS-TBL-INDX-2                  TO +1                     
T18994     SEARCH WS-CODE-SOURCE-ID-DESC-TBL                            
T18994       VARYING WS-TBL-INDX-2                                      
T18994       AT END                                                     
T18994       CONTINUE                                                   
T18994       WHEN E-FCA103-CODE-SOURCE-ID =                             
T18994            WS-CODE-SOURCE-ID (WS-TBL-INDX-2)                     
T18994            MOVE WS-CODE-SOURCE-ID-DESC-1(WS-TBL-INDX-2)          
T18994              TO E-FCA103-CODE-SOURCE-ID-DESC                     
T18994     END-SEARCH                                                   
T18994*                                                                         
T18994     MOVE SPACES TO E-FCA103-ORIG-SOURCE-ID-DESC                  
T18994     SET WS-TBL-INDX-2                  TO +1                     
T18994     SEARCH WS-CODE-SOURCE-ID-DESC-TBL                            
T18994       VARYING WS-TBL-INDX-2                                      
T18994       AT END                                                     
T18994       CONTINUE                                                   
T18994       WHEN WS-ORIG-SOURCE-ID =                                   
T18994            WS-CODE-SOURCE-ID (WS-TBL-INDX-2)                     
T18994            MOVE WS-CODE-SOURCE-ID-DESC-1(WS-TBL-INDX-2)          
T18994              TO E-FCA103-ORIG-SOURCE-ID-DESC                     
T18994     END-SEARCH                                                   
T18994*                                                                         
T18994     IF PW-READING-CODE = WS-N                                    
T18994        MOVE SPACES TO S4-NO-RD-REASON-DESC                       
T18994        EXEC SQL                                                  
T18994           SELECT  NO_RD_REASON_DESC                              
T18994             INTO  :S4-NO-RD-REASON-DESC                          
T18994             FROM  CSS_NO_READ_REASON WITH(READUNCOMMITTED)               
T18994             WHERE CODE_NO_RD_REASON = :PW-READING-COND-CD        
A01738                                                           
A01738                                                      
T18994        END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT  NO_RD_REASON_DESC                                      
MFA-TR*            INTO  :S4-NO-RD-REASON-DESC                                  
MFA-TR*            FROM  CSS_NO_READ_REASON                                     
MFA-TR*            WHERE CODE_NO_RD_REASON = :PW-READING-COND-CD                
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 3110                                                    
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18994        MOVE S4-NO-RD-REASON-DESC TO E-FCA103-READING-COND-CD-DESC
T18994     ELSE                                                         
T18994        MOVE SPACES TO E-FCA103-READING-COND-CD-DESC              
T18994        SET WS-TBL-INDX-1                  TO +1                  
T18994        SEARCH WS-READING-COND-CODE-DESC-TBL                      
T18994          VARYING WS-TBL-INDX-1                                   
T18994          AT END                                                  
T18994          CONTINUE                                                
T18994          WHEN PW-READING-COND-CD =                               
T18994               WS-READING-COND-CODE(WS-TBL-INDX-1)                
T18994               MOVE WS-READING-COND-CODE-DESC-1(WS-TBL-INDX-1)    
T18994                 TO E-FCA103-READING-COND-CD-DESC                 
T18994        END-SEARCH                                                
T18994     END-IF.                                                      
T18994*                                                                         
T18994 3110-EXIT.                                                       
T18994     EXIT.                                                        
T20596******************************************************************        
T20596* POPULATES THE OUTPUT FILE WITH IRREGULAR CODES AND COMMENTS    *        
T20596******************************************************************        
T20596*                                                                         
T20596 3200-LOAD-MTR-IRRGLARITY.                                        
T20596*                                                                         
T20596     MOVE E-FCA103-ACCOUNT-NO          TO IM-ACCOUNT-NO.          
T20596     MOVE E-FCA103-UTILITY-TYPE        TO IM-CODE-UTIL-TYPE.      
T20596     MOVE E-FCA103-READ-DATE           TO IM-METER-READ-DT.       
T20596     PERFORM 7000-SELECT-MTR-IRRGLARITY                           
T20596                                       THRU 7000-EXIT.            
T20596     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T20596         MOVE IM-IRRGLR-MTR-CD-1       TO E-FCA103-IRRGLR-MTR-CD1 
T20596         MOVE IM-IRRGLR-MTR-CD-2       TO E-FCA103-IRRGLR-MTR-CD2 
T20596         MOVE IM-MTR-RD-COMMENTS       TO E-FCA103-MTR-RD-COMMENTS
T20596     ELSE                                                         
T20596         MOVE SPACES                   TO E-FCA103-IRRGLR-MTR-CD1 
T20596                                          E-FCA103-IRRGLR-MTR-CD2 
T20596                                          E-FCA103-MTR-RD-COMMENTS
T20596     END-IF.                                                      
T20596*                                                                         
T20596 3200-EXIT.                                                       
T20596     EXIT.                                                        
T20596*                                                                         
      *****************************************************************         
      *                                                              **         
      ** COPY CPDS                                                   **         
      *                                                              **         
      *****************************************************************         
      *                                                                         
      * INITIALIZE BE00 VARIABLES : 0609-                                       
       COPY CPD00052.                                                           
                                                                        
      * INITIALIZE BE00 BILL PRINT CWS10009 VARIABLES : 690-                    
       COPY CPD00101.                                                           
                                                                        
      * INITIALIZE BE00 VARIABLES BY TABLE ID                                   
       COPY CPD00050.                                                           
                                                                        
      * INITIALIZE BE00 BILL PRINT CWS10009 VARIABLE BY TABLE ID                
       COPY CPD00102.                                                           
      *                                                                         
      ********************************************************                  
      *   6240-GET-FCA00-COMMON-DATE.                        *                  
      ********************************************************                  
       COPY CPD00040.                                                           
      *                                                                         
      ********************************************************                  
      * 6251-GET-FJC01-DATE.                                 *                  
      ********************************************************                  
       COPY CPD00037.                                                           
      *                                                                         
      ********************************************************                  
      * COMPANY END RECORD LOGIC COPYBOOKS                   *                  
      ********************************************************                  
       COPY CPD00104.                                                           
       COPY CPD00105.                                                           
      ********************************************************                  
      * WRITES THE BEGIN CONTROL RECORDS IN FLAT OUTPUT FILE *                  
      ********************************************************                  
                                                                        
       5100-WRITE-BEGIN-CONTROLS.                                       
           INITIALIZE FIOCA103-BEGIN-REC.                               
           MOVE LOW-VALUES            TO E-FCA103-KEY-BREC.             
           MOVE ZEROES                TO E-FCA103-DB-PART-BREC.         
           MOVE WS-INPUT-DATE         TO E-FCA103-CREATE-DATE-BREC.     
           PERFORM 8500-WRITE-FIOCA103-RECORD THRU 8500-EXIT.           
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
      ********************************************************                  
      * WRITES THE END CONTROL RECORDS IN FLAT OUTPUT FILE   *                  
      ********************************************************                  
       5110-WRITE-END-CONTROLS.                                         
                                                                        
           MOVE HIGH-VALUES           TO FIOCA103-END-REC.              
           MOVE WS-TOT-CA103-COUNT    TO E-FCA103-RECORD-COUNT-EREC.    
           PERFORM 8500-WRITE-FIOCA103-RECORD THRU 8500-EXIT.           
      *                                                                         
       5110-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
T20596* SELECTS IRRGLR MTR CODE 1, IRRGLR MTR CODE 2 & MTR READ COMMENTS        
T20596******************************************************************        
T20596*                                                                         
T20596 7000-SELECT-MTR-IRRGLARITY.                                      
T20596*                                                                         
T20596     EXEC SQL                                                     
T20596          SELECT IRRGLR_MTR_CD_1,                                 
T20596                 IRRGLR_MTR_CD_2,                                 
T20596                 MTR_RD_COMMENTS                                  
T20596            INTO :IM-IRRGLR-MTR-CD-1,                             
T20596                 :IM-IRRGLR-MTR-CD-2,                             
T20596                 :IM-MTR-RD-COMMENTS                              
T20596            FROM CSS_IRRGLR_MTR_RD WITH(READUNCOMMITTED)                  
T20596           WHERE ACCOUNT_NO      = :IM-ACCOUNT-NO                 
T20596             AND CODE_UTIL_TYPE  = :IM-CODE-UTIL-TYPE             
T20596             AND METER_READ_DT   = IIF(TRY_CONVERT(DATE, 
                                                      :IM-METER-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :IM-METER-READ-DT
              ) <> 0) OR (LEN(:IM-METER-READ-DT) <> 10), CIS.CHAR2DATE(
                                                      :IM-METER-READ-DT
              ), CONVERT(DATE, :IM-METER-READ-DT) )              
T27781             AND IC_NO           = :WS-IRR-MTR-IC-NO              
T23461             AND METER_READ_TM   =                                
T23461                     (SELECT MAX(METER_READ_TM)                   
T23461                        FROM CSS_IRRGLR_MTR_RD
                           WITH(READUNCOMMITTED)                    
T23461                       WHERE ACCOUNT_NO     = :IM-ACCOUNT-NO      
T23461                         AND CODE_UTIL_TYPE = :IM-CODE-UTIL-TYPE  
T23461                         AND METER_READ_DT  = 
              IIF(TRY_CONVERT(DATE, :IM-METER-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :IM-METER-READ-DT
              ) <> 0) OR (LEN(:IM-METER-READ-DT) <> 10), CIS.CHAR2DATE(
                                                      :IM-METER-READ-DT
              ), CONVERT(DATE, :IM-METER-READ-DT) )   
T27781                         AND IC_NO          = :WS-IRR-MTR-IC-NO)  
A01738                                                           
A01738                                                      
T20596     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT IRRGLR_MTR_CD_1,                                         
MFA-TR*                IRRGLR_MTR_CD_2,                                         
MFA-TR*                MTR_RD_COMMENTS                                          
MFA-TR*           INTO :IM-IRRGLR-MTR-CD-1,                                     
MFA-TR*                :IM-IRRGLR-MTR-CD-2,                                     
MFA-TR*                :IM-MTR-RD-COMMENTS                                      
MFA-TR*           FROM CSS_IRRGLR_MTR_RD                                        
MFA-TR*          WHERE ACCOUNT_NO      = :IM-ACCOUNT-NO                         
MFA-TR*            AND CODE_UTIL_TYPE  = :IM-CODE-UTIL-TYPE                     
MFA-TR*            AND METER_READ_DT   = :IM-METER-READ-DT                      
MFA-TR*            AND IC_NO           = :WS-IRR-MTR-IC-NO                      
MFA-TR*            AND METER_READ_TM   =                                        
MFA-TR*                    (SELECT MAX(METER_READ_TM)                           
MFA-TR*                       FROM CSS_IRRGLR_MTR_RD                            
MFA-TR*                      WHERE ACCOUNT_NO     = :IM-ACCOUNT-NO              
MFA-TR*                        AND CODE_UTIL_TYPE = :IM-CODE-UTIL-TYPE          
MFA-TR*                        AND METER_READ_DT  = :IM-METER-READ-DT           
MFA-TR*                        AND IC_NO          = :WS-IRR-MTR-IC-NO)          
MFA-TR*                      WITH UR                                            
MFA-TR*                      QUERYNO 7000                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20596                                                                  
T20596     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
T20596     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T20596         NEXT SENTENCE                                            
T20596     ELSE                                                         
T20596         DISPLAY '************* PCSBW103 ABORT ***************'   
T20596         DISPLAY '* ERROR IN 7000-SELECT-MTR-IRRGLARITY     **'   
T20596         DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE       
T20596         DISPLAY '* ACCOUNT_NO    : ' IM-ACCOUNT-NO               
T27781         DISPLAY '* CODE_UTIL_TYPE: ' IM-CODE-UTIL-TYPE           
T27781         DISPLAY '* METER_READ_DT : ' IM-METER-READ-DT            
T20596         DISPLAY '************* PCSBW103 ABORT ***************'   
T20596         PERFORM 9900-ABEND     THRU 9900-EXIT                    
T20596     END-IF.                                                      
T20596*                                                                         
T20596 7000-EXIT.                                                       
T20596     EXIT.                                                        
T20596*                                                                         
      ******************************************************************        
      *                                                              **         
      *    7230-OPEN-BILL-ADJ-REASN.                                            
      *                                                              **         
      ******************************************************************        
                                                                        
       7230-OPEN-BILL-ADJ-REASN.                                        
      *     MOVE '7230' TO ACTIVE-PARAGRAPH.                                    
            EXEC SQL                                                    
                 OPEN BILL_ADJ_RSN_CSR                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                NEXT SENTENCE                                           
            ELSE                                                        
                DISPLAY '7230-OPEN RETURN CODE =' WS-ACTIVE-RETURN-CODE 
                PERFORM 9900-ABEND THRU 9900-EXIT
            END-IF.                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                              **         
      *    7230-FETCH-BILL-ADJ-REASN.                                           
      *                                                              **         
      ******************************************************************        
       7231-FETCH-BILL-ADJ-REASN.                                       
           EXEC SQL                                                     
               FETCH BILL_ADJ_RSN_CSR                                   
                INTO :K0-ADJ-REASON-CD,                                 
                     :K0-CORRECTED-BILL-FL,                             
                     :K0-ADJUSTMENT-CLASS,                              
                     :K0-ADJ-REASON-DESC                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7231-FETCH RETURN CODE =' WS-ACTIVE-RETURN-CODE 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7231-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                               **        
      *    7230-CLOSE-BILL-ADJ-REASN.                                 **        
      *                                                               **        
      ******************************************************************        
       7232-CLOSE-BILL-ADJ-REASN.                                       
      *    MOVE '7232' TO ACTIVE-PARAGRAPH.                                     
           EXEC SQL                                                     
               CLOSE BILL_ADJ_RSN_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7232-CLOSE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7232-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                               **        
      *    7250-OPEN-ROUTE-REPORT-CSR.                                **        
      *                                                               **        
      ******************************************************************        
       7250-OPEN-ROUTE-REPORT-CSR.                                      
      *                                                                         
      *    MOVE '7250' TO ACTIVE-PARAGRAPH                                      
                                                                        
           MOVE WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX)                      
             TO PW-ACCOUNT-NO                                           
           MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)                   
             TO PW-REVENUE-MONTH                                        
           MOVE WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX)                  
             TO PW-CODE-UTIL-TYPE                                       
           MOVE WS-IC-NO-CX (WS-CNSMPTN-INDX)                           
             TO PW-IC-NO                                                
           MOVE WS-METER-NO-CX (WS-CNSMPTN-INDX)                        
             TO PW-METER-NO                                             
           PERFORM 2800-CONV-MEASURE-CD-1-TO-3CHR  THRU 2800-EXIT       
           MOVE WS-MEASURE-CODE-C3                                      
             TO PW-REG-MEASURE-CD                                       
      *                                                                         
           EXEC SQL                                                     
                OPEN ROUTE_REPORT_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7250-OPEN RETURN CODE =' WS-ACTIVE-RETURN-CODE  
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    7251-FETCH-ROUTE-REPORT-CSR.                                         
      ******************************************************************        
       7251-FETCH-ROUTE-REPORT-CSR.                                     
           EXEC SQL                                                     
               FETCH ROUTE_REPORT_CSR                                   
                INTO :PW-LAST-REG-READ-DT,                              
                     :PW-LAST-REG-READ-TM,                              
                     :PW-READING-CODE,                                  
                     :PW-METER-READING,                                 
                     :PW-TYPE-OF-RD-IND,                                
T18994               :PW-READING-COND-CD,                               
                     :PW-REG-MEASURE-CD,                                
A01738               :PW-METER-READER-ID                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7251-FETCH RETURN CODE =' WS-ACTIVE-RETURN-CODE 
A01738         DISPLAY 'ACCOUNT NO : '            PW-ACCOUNT-NO         
A01738         DISPLAY 'METER NO   : '            PW-METER-NO           
A01738         DISPLAY 'REVENUE MON : '           PW-REVENUE-MONTH      
A01738         DISPLAY 'CODE UTIL TYPE : '        PW-CODE-UTIL-TYPE     
A01738         DISPLAY 'REG MEASURE CD : '        PW-REG-MEASURE-CD     
A01738         DISPLAY 'IC NO          : '        PW-IC-NO              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7251-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    7250-CLOSE-BILL-ADJ-REASN.                                           
      ******************************************************************        
       7252-CLOSE-ROUTE-REPORT-CSR.                                     
      *    MOVE '7252' TO ACTIVE-PARAGRAPH.                                     
           EXEC SQL                                                     
               CLOSE ROUTE_REPORT_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7252-CLOSE RETURN CODE =' WS-ACTIVE-RETURN-CODE 
A01738         DISPLAY 'ACCOUNT NO : '            PW-ACCOUNT-NO         
A01738         DISPLAY 'METER NO   : '            PW-METER-NO           
A01738         DISPLAY 'REVENUE MON : '           PW-REVENUE-MONTH      
A01738         DISPLAY 'CODE UTIL TYPE : '        PW-CODE-UTIL-TYPE     
A01738         DISPLAY 'REG MEASURE CD : '        PW-REG-MEASURE-CD     
A01738         DISPLAY 'IC NO          : '        PW-IC-NO              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
         7252-EXIT.                                                     
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      *                                                               **        
      *    7255-OPEN-RT-REPORT-CSR.                                   **        
      *                                                               **        
      ******************************************************************        
       7255-OPEN-RT-REPORT-CSR.                                         
      *                                                                         
           MOVE WS-ACCOUNT-NO-CX (WS-HOLD-CNSMPTN-INDX)                 
             TO PW-ACCOUNT-NO                                           
T18994     MOVE WS-REVENUE-MONTH-BG (WS-HOLD-BACKOUT-BG-INDX)           
             TO PW-REVENUE-MONTH                                        
           MOVE WS-CODE-UTIL-TYPE-CX (WS-HOLD-CNSMPTN-INDX)             
             TO PW-CODE-UTIL-TYPE                                       
           MOVE WS-IC-NO-CX (WS-HOLD-CNSMPTN-INDX)                      
             TO PW-IC-NO                                                
           MOVE WS-METER-NO-CX (WS-HOLD-CNSMPTN-INDX)                   
             TO PW-METER-NO                                             
           PERFORM 2800-CONV-MEASURE-CD-1-TO-3CHR  THRU 2800-EXIT       
           MOVE WS-MEASURE-CODE-C3                                      
             TO PW-REG-MEASURE-CD                                       
      *                                                                         
           EXEC SQL                                                     
                OPEN ROUTE_REPORT_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7255-OPEN RETURN CODE =' WS-ACTIVE-RETURN-CODE  
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7255-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    7300-GET-ROUTE-FROM-UT.                                              
      ******************************************************************        
       7300-GET-ROUTE-FROM-UT.                                          
      *    MOVE '7240' TO ACTIVE-PARAGRAPH.                                     
           MOVE ZEROES TO UT-READ-ROUTE                                 
           EXEC SQL                                                     
                SELECT READ_ROUTE                                       
                  INTO :UT-READ-ROUTE                                   
                  FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                   
                 WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                 
                   AND CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE             
                   AND IC_NO           = :UT-IC-NO                      
A01738                                                           
A01738                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT READ_ROUTE                                               
MFA-TR*           INTO :UT-READ-ROUTE                                           
MFA-TR*           FROM CSS_UTIL_ENVRNMT                                         
MFA-TR*          WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                         
MFA-TR*            AND CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE                     
MFA-TR*            AND IC_NO           = :UT-IC-NO                              
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7300                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7300-SELECT RETURN CODE =' WS-ACTIVE-RETURN-CODE
A01738         DISPLAY 'UT ACCOUNT NO '            UT-ACCOUNT-NO        
A01738         DISPLAY 'UT CODE UTIL TYPE'         UT-CODE-UTIL-TYPE    
A01738         DISPLAY 'UT IC NO         '         UT-IC-NO             
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *     7600-START-FCSJC01                                         *        
      ******************************************************************        
      *                                                                         
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
      ******************************************************************        
      *     7620-START-FCSCA00                                         *        
      ******************************************************************        
            EXEC SQL                                                            
              INCLUDE CPD00039                                                  
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      *     7990-READ-FCSBE00                                          *        
      * READS FROM THE INPUT FILE AND TESTS WHETHER READ IS SUCCESS OR *        
      * NOT                                                            *        
      ******************************************************************        
       7990-READ-FCSBE00.                                               
                                                                        
           READ FCSBE00-FILE                                            
           AT END                                                       
               MOVE WS-YES TO WS-FCSBE00-FLAG                           
           END-READ.                                                    
                                                                        
           IF FBE00-SUCCESSFUL OR END-OF-FCSBE00                        
              MOVE FIOBE00  TO FIOBE02                                  
           ELSE                                                         
              DISPLAY '7990-ERROR ON FIOBE00 READ'                      
              DISPLAY 'PROCESSING TERMINATED'                           
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7990-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *     8500-WRITE-FIOCA103-RECORD                                 *        
      * WRITES THE REPORT RECORD AND TESTS FOR SUCCESS OR FAILURE      *        
      ******************************************************************        
       8500-WRITE-FIOCA103-RECORD.                                      
                                                                        
           WRITE FIOCA103.                                              
                                                                        
           IF NOT FCA103-SUCCESSFUL                                     
              DISPLAY '** PCSBW103  PROCESSING ERROR   **'              
              DISPLAY '** WRITE ERROR ON FILE FIOCA103 **'              
              DISPLAY '** PROCESSING TERMINATED        **'              
              DISPLAY '** STATUS IS ' WS-FCA103-STATUS                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
           ADD +1 TO WS-TOT-CA103-COUNT.                                
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **    8840-WRITE-END-REC                                      **          
      **        WRITES THE COMPANY RECORD INTO FLAT FILE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8840-WRITE-END-REC.                                              
      *                                                                         
           MOVE COMPANY-END-REC        TO FIOCA103-COMPANY-END-REC.     
           PERFORM 8500-WRITE-FIOCA103-RECORD THRU 8500-EXIT.           
           SUBTRACT +1 FROM  WS-TOT-CA103-COUNT.                        
      *                                                                         
       8840-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *     9000-TERMINATE                                             *        
      *     CLOSE FILES                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSBE00-FILE                                           
                 FCSCA103-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **      THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
