       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW100.                                        
       DATE-WRITTEN.   APR  1999.                                       
       DATE-COMPILED.                                                   
      ***************************************************************** PCS00050
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **                 PROGRAM MODIFICATION  LOG                   **         
      **                                                             **         
      **    DATE     INITIALS    REASON                              **         
      **    ----     --------    ------                              **         
      **   4/29/99   RGB         INITIAL VERSION                     **         
T20028**   5/18/99   RGB         CHANGED TO CHECK THE UPLOAD_METERS  **         
      **                         IN HEADER TABLE FOR MISSING ROUTES  **         
C23466**   1/26/01   DVK         CHANGED TO CHECK THE SPECIAL CYCLES **         
C23466**                         THAT WERE EXTRACTED FOR METER READING*         
C23466**                         ON THE SAME DAY AS THE REGULAR CYCLE**         
C23466**                         BEING CHECKED.                      **         
T25466**  10/19/01   DVK         CHANGED TO CHECK THE DOWNLOAD_METERS**         
T25466**                         UP&DOWN_RMVD_MTR_QT IN HEADER TABLE **         
T25466**                         WHILE LOOKING FOR MISSING ROUTES.   **         
T27237**  04/01/03   GANESH      CHANGED TO SUPPORT THE CYCLE 21     **         
T27237**                         OPENING BEFORE CYCLE 20 OPENS.      **         
T35434**  13/03/07   COVANSYS    REPLACED MODEL_SQL WITH SET STATEMENT*         
      *****************************************************************         
      *                                                                         
                              PCSBW100 NARRATIVE                        
      *                                                                         
                THIS PROGRAM CHECKS FOR MISSING ROUTES ON ITRON.        
                                                                        
      /                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      /                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      /                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW100'.
MSQ017     COPY MFASQLM.
      * FCA00-KEY          *                                                    
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      * IO AREA FOR PARM INPUT FILE 'A' *                                       
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBXREF                                                    
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSBW110 STARTS HERE'.            
       01  WS-ABEND-AREA.                                               
           05  WS-ABEND-SPACE            PIC X              VALUE SPACE.
           05  WS-ABEND-NUMERIC REDEFINES WS-ABEND-SPACE                
                                         PIC 9.                         
      /                                                                         
      * ABEND SWITCH     *                                                      
           COPY CWS09900.                                                       
      * WARNING DATA     *                                                      
           COPY CWS00303.                                                       
      * MISC INPUT       *                                                      
           EXEC SQL                                                     10510000
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      * FCA00 MISC INPUT *                                                      
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                    10530000
      /                                                                         
       01  WS-WORK-AREA.                                                
           05  ACTIVE-PARAGRAPH          PIC X(4).                      
       01  WS-WORK-DATE                  PIC X(10).                     
       01  WS-01                         PIC X(02)      VALUE  '01'.    
       01  WS-DAY                        PIC S9(4) COMP VALUE ZERO.     
       01  WS-SET-RETURN-CODE            PIC X(1)       VALUE 'N'.      
       01  WS-ROW-COUNT                  PIC S9(9) COMP VALUE ZERO.     
       01  WS-SWITCHES.                                                 
           05 WS-BAD-WORKING-DAY         PIC X(1).                      
              88  BAD-WORKING-DAY                       VALUE 'N'.      
              88  GOOD-WORKING-DAY                      VALUE 'Y'.      
       01  WS-Y                          PIC X(1)       VALUE 'Y'.      
       01  WS-N                          PIC X(1)       VALUE 'N'.      
       01  WS-PGRMNAME                   PIC X(08)     VALUE 'PCSBW100'.
       01  WS-811                        PIC S9(4) COMP VALUE -811.     
       01  WS-UPLOAD-METERS              PIC S9(4) USAGE COMP.          
T25466 01  WS-DOWNLOAD-METERS            PIC S9(4) USAGE COMP.          
T25466 01  WS-UP-RMVD-MTR-QT             PIC S9(4) USAGE COMP.          
T25466 01  WS-DOWN-RMVD-MTR-QT           PIC S9(4) USAGE COMP.          
C27237 01  WS-VALID-CYCLE                PIC X(1)  VALUE 'N' .          
                                                                        
                                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTEHDR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
C23466     EXEC SQL                                                             
C23466         INCLUDE TBRDWNDW                                                 
C23466     END-EXEC.                                                            
      *                                                                         
      *****************************************************                     
      * DECLARE CURSOR FOR SELECTING BILL CYCLE  DETAILS                        
      ******************************************************                    
           EXEC SQL                                                     
               DECLARE BILL_CYCLE CURSOR FOR                            
                   SELECT BILL_CYCLE,                                   
                          REVENUE_MONTH                                 
                   FROM CSS_BILL_WINDOW                                 
                   WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00003406
MFA-TR*        DECLARE BILL_CYCLE CURSOR FOR                            00003507
MFA-TR*            SELECT BILL_CYCLE,                                   00003609
MFA-TR*                   REVENUE_MONTH                                 00003806
MFA-TR*            FROM CSS_BILL_WINDOW                                 00004009
MFA-TR*            WHERE DATE_EXTRACT = :WS-INPUT-DATE                  00004106
MFA-TR*    END-EXEC.                                                    00004406
      *****************************************************                     
      * DECLARE CURSOR FOR SELECTING ROUTE HEADER DETAILS                       
      ******************************************************                    
           EXEC SQL                                                     
                 DECLARE HEADER_CURS CURSOR FOR                         
                 SELECT READ_ROUTE,                                     
                        LOCAL_OFFICE,                                   
T20028                  UPLOAD_METERS,                                  
T25466                  DOWNLOAD_METERS,                                
T25466                  DOWN_RMVD_MTR_QT,                               
T25466                  UP_RMVD_MTR_QT                                  
                 FROM   CSS_ROUTE_HEADER                                
C23466*          WHERE  COMPANY_NO    = :WS-01                                  
C23466*            AND  READ_CYCLE    = :BN-BILL-CYCLE                          
C23466           WHERE  READ_CYCLE    = :RW-READ-CYCLE                  
                   AND  REVENUE_MONTH = :BN-REVENUE-MONTH               
                 ORDER BY LOCAL_OFFICE ,READ_ROUTE                      
           END-EXEC.                                                    
      /                                                                         
C23466*****************************************************                     
C23466* DECLARE CURSOR FOR SELECTING READ WINDOW DETAILS                        
C23466******************************************************                    
C23466     EXEC SQL                                                     
C23466           DECLARE READ_WINDOW CURSOR FOR                         
C23466           SELECT RW.DATE_MTR_RD_XTRCT                            
C23466                 ,RW.READ_CYCLE                                   
C23466                 ,RW.REVENUE_MONTH                                
C27237                 ,RW.UT_READ_CYCLE                                
C23466           FROM   CSS_READ_WINDOW RW                              
C23466           WHERE  RW.DATE_MTR_RD_XTRCT =                          
C23466                 (SELECT MAX(R1.DATE_MTR_RD_XTRCT)                
C23466                  FROM   CSS_READ_WINDOW R1                       
C23466                  WHERE  R1.REVENUE_MONTH = RW.REVENUE_MONTH      
C23466                    AND  R1.REVENUE_MONTH = :BN-REVENUE-MONTH     
C23466                    AND  R1.READ_CYCLE    = :BN-BILL-CYCLE        
C23466                    AND  R1.DATE_MTR_RD_XTRCT < 
              IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )    
C23466                 )                                                
C23466     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*          DECLARE READ_WINDOW CURSOR FOR                                 
MFA-TR*          SELECT RW.DATE_MTR_RD_XTRCT                                    
MFA-TR*                ,RW.READ_CYCLE                                           
MFA-TR*                ,RW.REVENUE_MONTH                                        
MFA-TR*                ,RW.UT_READ_CYCLE                                        
MFA-TR*          FROM   CSS_READ_WINDOW RW                                      
MFA-TR*          WHERE  RW.DATE_MTR_RD_XTRCT =                                  
MFA-TR*                (SELECT MAX(R1.DATE_MTR_RD_XTRCT)                        
MFA-TR*                 FROM   CSS_READ_WINDOW R1                               
MFA-TR*                 WHERE  R1.REVENUE_MONTH = RW.REVENUE_MONTH              
MFA-TR*                   AND  R1.REVENUE_MONTH = :BN-REVENUE-MONTH             
MFA-TR*                   AND  R1.READ_CYCLE    = :BN-BILL-CYCLE                
MFA-TR*                   AND  R1.DATE_MTR_RD_XTRCT < :WS-INPUT-DATE            
MFA-TR*                )                                                        
MFA-TR*    END-EXEC.                                                            
C23466/                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************00071500
      *   0000-MAINLINE                                                *00072500
      *        CONTROLS THE MAIN PATH OF PROGRAM                       *00073000
      ******************************************************************00074000
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE
           END-IF.               
      *                                                                         
           MOVE 'N'         TO WS-SET-RETURN-CODE                       
                                                                        
           PERFORM 2900-CALC-WANTED-BY-DATE THRU 2900-EXIT              
           MOVE WS-WORK-DATE TO WS-INPUT-DATE                           
      *                                                                         
           PERFORM 1000-PROCESS-ROUTES                  THRU 1000-EXIT  
           IF WS-SET-RETURN-CODE = 'Y'                                  
              MOVE 05                  TO RETURN-CODE                   
           ELSE                                                         
              DISPLAY '********REPORT FOR MISSING ROUTES*****'          
              DISPLAY 'PCSBW100*     RUN DATE : 'WS-INPUT-DATE          
              DISPLAY '                                            '    
              DISPLAY '   ********NO MISSING ROUTES**********      '    
           END-IF                                                       
      *                                                                         
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   0100-INITIALIZATION                                          *00084500
      *        COMMON INITIALIZATION ROUTINE                           *00085000
      ******************************************************************00086000
       1000-PROCESS-ROUTES.                                             
      *                                                                         
           PERFORM 7030-OPEN-BILL-WINDOW THRU 7030-EXIT.                
           PERFORM 7040-FETCH-BILL-WINDOW THRU 7040-EXIT                
           PERFORM 1100-CHECK-FOR-BILL-CYCLES THRU 1100-EXIT            
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
           PERFORM 7050-CLOSE-BILL-WINDOW THRU 7050-EXIT.               
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   1100-CHECK-FOR-BILL-CYCLES                                   *00084500
      *      IT CHECKS FOR RECENT BILL CYCLE OPENED                    *00085000
      ******************************************************************00086000
       1100-CHECK-FOR-BILL-CYCLES.                                      
      *                                                                         
            PERFORM 7100-SELECT-OPEN-CYCLE  THRU  7100-EXIT.            
            IF BN-DATE-EXTRACT = WS-INPUT-DATE                          
C23466         PERFORM 7700-OPEN-READ-WINDOW THRU 7700-EXIT             
C27237         MOVE 'N'               TO WS-VALID-CYCLE                 
C27237         PERFORM 1150-GET-VALID-BILL-CYCLE THRU 1150-EXIT         
C27237                                    UNTIL WS-VALID-CYCLE = 'Y'    
               PERFORM  1200-CHECK-FOR-ROUTES  THRU 1200-EXIT           
C23466                  UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND     
C23466         PERFORM 7900-CLOSE-READ-WINDOW THRU 7900-EXIT            
            ELSE                                                        
               CONTINUE                                                 
            END-IF                                                      
            PERFORM 7040-FETCH-BILL-WINDOW THRU 7040-EXIT.              
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
C27237 1150-GET-VALID-BILL-CYCLE.                                       
C27237                                                                  
C23466      PERFORM 7800-FETCH-READ-WINDOW THRU 7800-EXIT               
C27237      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C27237          IF (RW-UT-READ-CYCLE = SPACES ) AND                     
C27237             (RW-READ-CYCLE NOT = BN-BILL-CYCLE)                  
C27237             MOVE 'N'            TO WS-VALID-CYCLE                
C27237          ELSE                                                    
C27237             MOVE 'Y'            TO WS-VALID-CYCLE                
C27237          END-IF                                                  
C27237     ELSE                                                         
C27237         MOVE 'Y'                TO WS-VALID-CYCLE                
C27237     END-IF.                                                      
C27237                                                                  
C27237 1150-EXIT.                                                       
C27237     EXIT.                                                        
      ******************************************************************        
      *   1200-CHECK-FOR-ROUTES                                        *00084500
      *      IT CHECKS FOR MISSING ROUTES IN ROUTE_DETAIL TABLE WHICH  *00085000
      *      IS PRESENT IN ROUTE_HEADER TABLE                          *        
      ******************************************************************00086000
       1200-CHECK-FOR-ROUTES.                                           
      *                                                                         
           PERFORM 7200-OPEN-HEADER-CURS THRU 7200-EXIT.                
           PERFORM 7300-FETCH-HEADER-CURS THRU 7300-EXIT                
           PERFORM 1300-CHECK-IN-ROUTE-DETAILS THRU 1300-EXIT           
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
           PERFORM 7400-CLOSE-HEADER-CURS THRU 7400-EXIT.               
      *                                                                         
C27237     MOVE 'N'               TO WS-VALID-CYCLE                     
C27237     PERFORM 1150-GET-VALID-BILL-CYCLE THRU 1150-EXIT             
C27237                               UNTIL WS-VALID-CYCLE = 'Y' .       
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   1200-CHECK-IN-ROUTE-DETAILS                                  *00084500
      ******************************************************************00086000
                                                                        
       1300-CHECK-IN-ROUTE-DETAILS.                                     
      *                                                                         
T25466     MOVE 'N' TO  WS-ERROR-FLAG.                                  
           MOVE RH-UPLOAD-METERS    TO WS-UPLOAD-METERS.                
T25466     MOVE RH-DOWNLOAD-METERS  TO WS-DOWNLOAD-METERS.              
T25466     MOVE RH-UP-RMVD-MTR-QT   TO WS-UP-RMVD-MTR-QT.               
T25466     MOVE RH-DOWN-RMVD-MTR-QT TO WS-DOWN-RMVD-MTR-QT.             
           IF WS-UPLOAD-METERS  GREATER THAN ZERO                       
                CONTINUE                                                
T25466     ELSE                                                         
T25466        IF WS-UPLOAD-METERS = ZERO AND                            
T25466                     WS-DOWNLOAD-METERS NOT = ZERO                
T25466           MOVE 'Y' TO WS-ERROR-FLAG                              
T25466        END-IF                                                    
T25466        IF WS-UP-RMVD-MTR-QT = ZERO AND                           
T25466                          WS-DOWN-RMVD-MTR-QT NOT = ZERO          
T25466           MOVE 'Y' TO WS-ERROR-FLAG                              
T25466        END-IF                                                    
T25466     END-IF.                                                      
T25466*    ELSE                                                                 
T25466     IF WS-ERROR-FLAG = 'Y'                                       
               IF WS-SET-RETURN-CODE = 'N'                              
                  DISPLAY '********REPORT FOR MISSING ROUTES*****'      
                  DISPLAY 'PCSBW100*     RUN DATE : ' WS-INPUT-DATE     
                  DISPLAY  '                                      '     
                  DISPLAY 'MISSING READ ROUTE   LOCAL OFFICE           '
                  DISPLAY '------------------   ------------     '      
               END-IF                                                   
               MOVE 'Y'         TO WS-SET-RETURN-CODE                   
               MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE            
              DISPLAY RH-READ-ROUTE  '                 ' RH-LOCAL-OFFICE
           END-IF                                                       
           PERFORM 7300-FETCH-HEADER-CURS THRU 7300-EXIT.               
      *    PERFORM 7500-SELECT-ROUTE-DETAILS  THRU 7500-EXIT                    
      *     IF  WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL                    
      *                               OR WS-811                                 
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /                                                                         
      * GET FCA00 COMMON DATE                 *                                 
           COPY CPD00040.                                                       
      /                                                                         
      * READ PARM FILE FOR OVERRIDE DATE      *                                 
           COPY CPD00037.                                                       
      /                                                                         
      ****************************************************************          
      *                                                              *          
      *    DETERMINE THE WANTED BY DATE, EXCLUDING WEEK-ENDS AND     *          
      *    HOLIDAYS.                                                 *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       2900-CALC-WANTED-BY-DATE.                                        
           MOVE WS-INPUT-DATE TO WS-WORK-DATE.                          
           SET BAD-WORKING-DAY TO TRUE.                                 
           PERFORM UNTIL GOOD-WORKING-DAY                               
               PERFORM 7010-GET-NEXT-DAY THRU 7010-EXIT                 
               IF  WS-DAY > 0                                           
                 AND WS-DAY < 6                                         
                   PERFORM 7020-SELECT-HOLIDAY THRU 7020-EXIT           
                   IF  WS-ROW-COUNT = 0                                 
                       SET GOOD-WORKING-DAY TO TRUE                     
                   END-IF                                               
               END-IF                                                   
           END-PERFORM.                                                 
       2900-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      *    SELECT THE NEXT CURRENT DAY                               *          
      *                                                              *          
      ****************************************************************          
       7010-GET-NEXT-DAY.                                               
           EXEC SQL                                                     
T35434         SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ),
              CIS.DAYS (DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))        
T35434                           - (CIS.DAYS(DATEADD( DAY, 1, 
              IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))/7 * 7)
            INTO
              :WS-WORK-DATE,
              :WS-DAY                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-WORK-DATE = DATE(:WS-WORK-DATE) + 1 DAYS                 
MFA-TR*           ,:WS-DAY = DAYS (DATE(:WS-WORK-DATE) + 1 DAYS)                
MFA-TR*                          - (INTEGER(DAYS(DATE(:WS-WORK-DATE)            
MFA-TR*                          + 1 DAYS)/7) * 7)                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7010-ABEND ' WS-ACTIVE-RETURN-CODE              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7010-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        00035000
      ****************************************************************          
      *                                                              *          
      *    DETERMINE IF THE DATE SPECIFIED IS A HOLIDAY              *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       7020-SELECT-HOLIDAY.                                             
           MOVE ZEROS TO WS-ROW-COUNT.                                  
           EXEC SQL                                                     
                SELECT  COUNT (*)                                       
                  INTO :WS-ROW-COUNT                                    
                  FROM  CSS_HOLIDAY                                     
                 WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) )                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  COUNT (*)                                               
MFA-TR*           INTO :WS-ROW-COUNT                                            
MFA-TR*           FROM  CSS_HOLIDAY                                             
MFA-TR*          WHERE  HOLIDAY_DT = :WS-WORK-DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7020-ABEND ' WS-ACTIVE-RETURN-CODE              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7020-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        00035000
      ***************************************************************** 00002809
      *                                                              ** 00002907
      *    7030-OPEN-BILL-WINDOW                                     ** 00003007
      *                                                              ** 00003107
      ***************************************************************** 00003207
       7030-OPEN-BILL-WINDOW.                                           
      *                                                                 00004506
           EXEC SQL                                                     
               OPEN BILL_CYCLE                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00004906
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7030-OPEN-BILL-WINDOW'                          
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00005806
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00006106
      ***************************************************************** 00006209
      *                                                              ** 00006306
      *    7040-FETCH-BILL-WINDOW                                    ** 00006407
      *                                                              ** 00006506
      ***************************************************************** 00006606
       7040-FETCH-BILL-WINDOW.                                          
      *                                                                 00006806
           EXEC SQL                                                     
               FETCH BILL_CYCLE                                         
               INTO :BN-BILL-CYCLE                                      
                  , :BN-REVENUE-MONTH                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00007806
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                         OR NOT-FOUND                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7040-FETCH-BILL-WINDOW'                         
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00005806
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00011906
      ***************************************************************** 00012009
      *                                                              ** 00012106
      *    7050-CLOSE-BILL-WINDOW                                    ** 00012207
      *                                                              ** 00012306
      ***************************************************************** 00012406
       7050-CLOSE-BILL-WINDOW.                                          
      *                                                                 00012606
           EXEC SQL                                                     
               CLOSE BILL_CYCLE                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00013006
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7050-CLOSE-BILL-WINDOW'                         
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00013906
       7050-EXIT.                                                       
           EXIT.                                                        
     /****************************************************************          
      *   7100-SELECT-OPEN-CYCLE                                     *          
      *****************************************************************         
       7100-SELECT-OPEN-CYCLE.                                          
      *                                                                         
           MOVE '7100'                       TO ACTIVE-PARAGRAPH        
      *                                                                         
           EXEC SQL                                                     
               SELECT MIN(DATE_EXTRACT)                                 
                 INTO :BN-DATE-EXTRACT                                  
                 FROM CSS_BILL_WINDOW                                   
                WHERE BILL_CYCLE    = :BN-BILL-CYCLE                    
                  AND REVENUE_MONTH = :BN-REVENUE-MONTH                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
             ELSE                                                       
               DISPLAY '7100-SELECT-OPEN-CYCLE'                         
               DISPLAY 'RETURN CODE   = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY 'BILL_CYCLE     = ' BN-BILL-CYCLE                
               DISPLAY 'REVENUE_MONTH  = ' BN-REVENUE-MONTH             
               PERFORM 9900-ABEND                      THRU 9900-EXIT   
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 00002809
      *                                                              ** 00002907
      *    7200-OPEN-HEADER-CURS                                     ** 00003007
      *                                                              ** 00003107
      ***************************************************************** 00003207
       7200-OPEN-HEADER-CURS.                                           
      *                                                                 00004506
           EXEC SQL                                                     
               OPEN HEADER_CURS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00004906
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7200-OPEN-HEADER-CURS'                          
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00005806
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00006106
      ***************************************************************** 00006209
      *                                                              ** 00006306
      *    7300-FETCH-HEADER-CURS                                    ** 00006407
      *                                                              ** 00006506
      ***************************************************************** 00006606
       7300-FETCH-HEADER-CURS.                                          
      *                                                                 00006806
           EXEC SQL                                                     
               FETCH HEADER_CURS                                        
               INTO :RH-READ-ROUTE,                                     
                    :RH-LOCAL-OFFICE,                                   
T20028              :RH-UPLOAD-METERS,                                  
T25466              :RH-DOWNLOAD-METERS,                                
T25466              :RH-DOWN-RMVD-MTR-QT,                               
T25466              :RH-UP-RMVD-MTR-QT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00007806
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                     OR NOT-FOUND                       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7300-FETCH-HEADER-CURS'                         
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00005806
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00011906
      ***************************************************************** 00012009
      *                                                              ** 00012106
      *    7400-CLOSE-HEADER-CURS                                    ** 00012207
      *                                                              ** 00012306
      ***************************************************************** 00012406
       7400-CLOSE-HEADER-CURS.                                          
      *                                                                 00012606
           EXEC SQL                                                     
               CLOSE HEADER_CURS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00013006
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7400-CLOSE-HEADER-CURS'                         
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 00013906
       7400-EXIT.                                                       
           EXIT.                                                        
     /****************************************************************          
      *   7100-SELECT-ROUTE-DEATAILS                                 *          
      *****************************************************************         
      *7500-SELECT-ROUTE-DETAILS.                                               
      *                                                                         
      *    MOVE '7500'                       TO ACTIVE-PARAGRAPH.               
      *                                                                         
      *    EXEC SQL                                                             
      *        SELECT READ_ROUTE                                                
      *          INTO :RR-READ-ROUTE                                            
      *          FROM CSS_ROUTE_DETAIL                                          
      *         WHERE READ_CYCLE    = :BN-BILL-CYCLE                            
      *           AND REVENUE_MONTH = :BN-REVENUE-MONTH                         
      *           AND COMPANY_NO    = :WS-01                                    
      *           AND LOCAL_OFFICE  = :RH-LOCAL-OFFICE                          
      *           AND READ_ROUTE    = :RH-READ-ROUTE                            
      *    END-EXEC                                                             
      **                                                                        
      *    MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE            
      *                                                                         
      *    IF  WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL                     
      *                                    OR NOT-FOUND  OR WS-811              
      *        CONTINUE                                                         
      *      ELSE                                                               
      *        DISPLAY '7500-SELECT-ROUTE_DETAILS'                              
      *        DISPLAY 'RETURN CODE   = ' WS-ACTIVE-RETURN-CODE                 
      *        DISPLAY 'READ_CYCLE     = ' BN-BILL-CYCLE                        
      *        DISPLAY 'REVENUE_MONTH  = ' BN-REVENUE-MONTH                     
      *        PERFORM 9900-ABEND                      THRU 9900-EXIT           
      *    END-IF                                                               
      *    .                                                                    
      *7500-EXIT.                                                               
      *    EXIT.                                                                
      /                                                                         
      * 7600-START-FCSJC01                    *                                 
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      /                                                                         
      * 7620-START-FCSCA00 VSAM CTRL FILE     *                                 
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
C23466***************************************************************** 00002809
C23466*                                                              ** 00002907
C23466*    7700-OPEN-READ-WINDOW                                     ** 00003007
C23466*                                                              ** 00003107
C23466***************************************************************** 00003207
C23466 7700-OPEN-READ-WINDOW.                                           
C23466*                                                                 00004506
C23466     EXEC SQL                                                     
C23466         OPEN READ_WINDOW                                         
C23466     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23466*                                                                 00004906
C23466     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C23466     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C23466         CONTINUE                                                 
C23466     ELSE                                                         
C23466         DISPLAY '7700-OPEN-READ-WINDOW'                          
C23466                 ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
C23466         PERFORM 9900-ABEND          THRU 9900-EXIT               
C23466     END-IF.                                                      
C23466*                                                                 00005806
C23466 7700-EXIT.                                                       
C23466     EXIT.                                                        
C23466*                                                                 00006106
C23466***************************************************************** 00006209
C23466*                                                              ** 00006306
C23466*    7800-FETCH-READ-WINDOW                                    ** 00006407
C23466*                                                              ** 00006506
C23466***************************************************************** 00006606
C23466 7800-FETCH-READ-WINDOW.                                          
C23466*                                                                 00006806
C23466     EXEC SQL                                                     
C23466         FETCH READ_WINDOW                                        
C23466         INTO :RW-DATE-MTR-RD-XTRCT,                              
C23466              :RW-READ-CYCLE,                                     
C23466              :RW-REVENUE-MONTH,                                  
C27237              :RW-UT-READ-CYCLE                                   
C23466     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23466*                                                                 00007806
C23466     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C23466     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C23466                               OR NOT-FOUND                       
C23466         CONTINUE                                                 
C23466     ELSE                                                         
C23466         DISPLAY '7800-FETCH-READ-WINDOW'                         
C23466                 ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
C23466         PERFORM 9900-ABEND          THRU 9900-EXIT               
C23466     END-IF.                                                      
C23466*                                                                 00005806
C23466 7800-EXIT.                                                       
C23466     EXIT.                                                        
C23466*                                                                 00011906
C23466***************************************************************** 00012009
C23466*                                                              ** 00012106
C23466*    7900-CLOSE-READ-WINDOW                                    ** 00012207
C23466*                                                              ** 00012306
C23466***************************************************************** 00012406
C23466 7900-CLOSE-READ-WINDOW.                                          
C23466*                                                                 00012606
C23466     EXEC SQL                                                     
C23466         CLOSE READ_WINDOW                                        
C23466     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23466*                                                                 00013006
C23466     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C23466     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C23466         CONTINUE                                                 
C23466     ELSE                                                         
C23466         DISPLAY '7900-CLOSE-READ-WINDOW'                         
C23466                 ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
C23466         PERFORM 9900-ABEND          THRU 9900-EXIT               
C23466     END-IF.                                                      
C23466*                                                                 00013906
C23466 7900-EXIT.                                                       
C23466     EXIT.                                                        
C23466/                                                                         
      *                                                                         
       9000-TERMINATE.                                                  
       9000-EXIT.                                                       
           EXIT.                                                        
      * 9900-ABEND INCLUDES SQL ROLLBACK *                                      
           EXEC SQL                                                     08170000
             INCLUDE CPD09900                                           08180001
           END-EXEC.                                                    08190000
