       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBA137.                                        
       DATE-WRITTEN.   DEC, 1997.                                       
           DATE-COMPILED.                                               
      ***************************************************************** 00050000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** 00060000
      **                     PRICE WATERHOUSE                        ** 00070000
      **                1410 NORTH WESTSHORE BLVD                    ** 00080000
      **                   TAMPA, FLORIDA  33607                     ** 00090000
      **                      (813) 287-9200                         ** 00100000
      **                                                             ** 00110000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00120000
      ********                      DB2                       ********* 00130000
      ***************************************************************** 00140000
      **                                                             ** 00150000
      **              PROGRAM  MODIFICATION  LOG                     ** 00160000
      **    DATE    INITIALS     REASON                              ** 00170000
      **    ____    ________     ______                              ** 00180000
      ** 12/17/97    AJC         CREATED FROM PCSCA137               ** 00190000
T20012** 05/21/99    CJB         MODIFIED LOGIC FOR PARAGRAPH        ** 00230400
T20012**                         1135-ACCUM-PJS TO ENSURE CORRECT    ** 00230500
T20012**                         CALCULATION OF PSJ AR LOC TOTALS.   ** 00230500
C24646** 08/28/01    SS19371     EXPLICIT ASSIGNMENT TO "DO" FOR     ** 00230500
C24646**                         DB2 VERSION 6 UPDATE                ** 00230500
A04527** 06/06/13    MR7E794     REMOVED UNUSED COPYBOOK CWS00056.   **         
      ***************************************************************** 00231000
                                                                        
      *================================================================*00250000
      *================================================================*00260000
      *                                                                *00270000
      *   PCSBA137 SUMS A/R BALANCES BY LOCAL-OFFICE & PASSES THEM TO  *00280000
      *   PCSBA131 IN FILE FC1WK08.                                    *00290000
      *                                                                *00300000
      *================================================================*00310000
      *================================================================*00320000
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           COPY CSSWK08.                                                00410000
                                                                        
           COPY CSSCM16.                                                00430000
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
                                                                        
       COPY CFDWK08.                                                    00490000
       COPY FIOWK08.                                                    00500000
                                                                        
       COPY CFDCM16.                                                    00520000
       COPY FIOCM16.                                                    00530000
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBA137'.
MSQ017     COPY MFASQLM.
                                                                        
       COPY FIOCA00.                                                    00570000
                                                                        
       COPY FIOJC01.                                                    00590000
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05 WS-START                 PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSCA137 STARTS HERE'.            
           05  WS-ABEND-PARAGRAPH      PIC XXXX           VALUE SPACES. 
           05  WS-SQLCODE              PIC --------9.                   
           05  WS-ZERO-IND             PIC S9999  COMP.                 
           05  WS-LOCAL-OFFICE         PIC X(3) VALUE SPACE.            
                                                                        
       COPY CWS09900.                                                   00680000
                                                                        
       COPY CWS00039.                                                   00700000
                                                                        
       COPY CWS00038.                                                   00720000
                                                                        
                                                                        
      *                                                                 00760000
       01  WS-INPUT-DATE-BREAKDOWN     PIC 9(10)  VALUE ZEROS.          
       01  FILLER REDEFINES WS-INPUT-DATE-BREAKDOWN.                    
           05  WS-INPUT-MM-B           PIC 9(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-INPUT-DD-B           PIC 9(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-INPUT-CC-B           PIC 9(02).                       
           05  WS-INPUT-YY-B           PIC 9(02).                       
      *                                                                 00850000
       01  WS-CURRENT-DATE             PIC 9(09)  VALUE ZEROS.          
       01  FILLER REDEFINES WS-CURRENT-DATE.                            
           05  FILLER                  PIC 9(01).                       
           05  WS-CURRENT-CC           PIC 9(02).                       
           05  WS-CURRENT-YY           PIC 9(02).                       
           05  WS-CURRENT-MM           PIC 9(02).                       
           05  WS-CURRENT-DD           PIC 9(02).                       
      *                                                                 00930000
       01  WS-CURRENT-DATE-DISPLAY.                                     
           05  WS-CURRENT-MM-DISPLAY   PIC 9(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-CURRENT-DD-DISPLAY   PIC 9(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-CURRENT-YY-DISPLAY   PIC 9(02).                       
      *                                                                 01000000
       01  WS-LITERALS.                                                 
           05  WS-D                    PIC X(01)     VALUE 'D'.         
           05  WS-E                    PIC X(01)     VALUE 'E'.         
           05  WS-F                    PIC X(01)     VALUE 'F'.         
           05  WS-G                    PIC X(01)     VALUE 'G'.         
           05  WS-H                    PIC X(01)     VALUE 'H'.         
           05  WS-I                    PIC X(01)     VALUE 'I'.         
           05  WS-J                    PIC X(01)     VALUE 'J'.         
           05  WS-K                    PIC X(01)     VALUE 'K'.         
           05  WS-L                    PIC X(01)     VALUE 'L'.         
           05  WS-M                    PIC X(01)     VALUE 'M'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-P                    PIC X(01)     VALUE 'P'.         
           05  WS-S                    PIC X(01)     VALUE 'S'.         
           05  WS-T                    PIC X(01)     VALUE 'T'.         
           05  WS-U                    PIC X(01)     VALUE 'U'.         
           05  WS-W                    PIC X(01)     VALUE 'W'.         
           05  WS-X                    PIC X(01)     VALUE 'X'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-Z                    PIC X(01)     VALUE 'Z'.         
           05  WS-0                    PIC X(01)     VALUE '0'.         
           05  WS-1                    PIC X(01)     VALUE '1'.         
           05  WS-5                    PIC X(01)     VALUE '5'.         
           05  WS-YES                  PIC X(01)     VALUE 'Y'.         
           05  WS-NO                   PIC X(01)     VALUE 'N'.         
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSCA137'.  
                                                                        
       01  WS-TOTAL-ACCUMS.                                             
T11246   02 WS-TOTAL-WORK-AREA  OCCURS 75 TIMES                         
              INDEXED BY  WS-ACCUM-INDX.                                
         05 WS-LOCAL-OFFICE-LOC     PIC X(3) VALUE SPACES.              
         05 WS-TOTAL-ACCUMS-LOC.                                        
            10 WS-UNPD-ELC-LOC         PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-GAS-LOC         PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-EPP-LOC         PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-CCC-LOC         PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-DFA-LOC         PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-CIA-LOC         PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-DEP-LOC         PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-CNT-LOC         PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-PJS-LOC         PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-LPC-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-LPN-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-ELC-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-GAS-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-EPP-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-CCC-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-DFA-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-CIA-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-DEP-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-CNT-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-NSA-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-NSN-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-NSC-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-ADV-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-PJS-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-DEP-TOF-LOC       PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-LPC-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-LPN-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-ELC-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-GAS-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-CCC-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-DFA-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
P072  *     10 WS-CO-CIA-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  01610000
P072        10 FILLER                  PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-CNT-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-NSA-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-NSN-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-NSC-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-ADJ-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-PJS-LOC           PIC S9(9)V99 COMP-3 VALUE ZERO.  
      *                                                                 01680000
       01  WS-FILE-STATUS.                                              
           05  WS-FST08-STATUS         PIC X(02).                       
               88  FCSST08-SUCCESSFUL       VALUE '00'.                 
      *                                                                 01720000
       01  WS-RECORDS-WRITTEN-COUNTERS.                                 
           05  WS-FWK08-REC-CNTR          PIC S9(07) COMP-3 VALUE ZERO. 
                                                                        
      *                                                                 01760000
           COPY CWS00303.                                               01770000
                                                                        
           EXEC SQL                                                     01790000
               INCLUDE CWS00042                                         01800000
           END-EXEC.                                                    01810000
                                                                        
           EXEC SQL                                                     01830000
               INCLUDE SQLCA                                            01840000
           END-EXEC.                                                    01850000
                                                                        
           EXEC SQL                                                     01870000
               INCLUDE TBACCT                                           01880000
           END-EXEC.                                                    01890000
                                                                        
           EXEC SQL                                                     01910000
               INCLUDE TBARCNTL                                         01920000
           END-EXEC.                                                    01930000
                                                                        
           EXEC SQL                                                     01950000
               INCLUDE TBBTHPRT                                         01960000
           END-EXEC.                                                    01970000
                                                                        
           EXEC SQL                                                     01990000
               INCLUDE TBCHGOFF                                         02000000
           END-EXEC.                                                    02010000
                                                                        
           EXEC SQL                                                     02030000
               INCLUDE TBDEPHND                                         02040000
           END-EXEC.                                                    02050000
                                                                        
           EXEC SQL                                                     02070000
               INCLUDE TBJBPARM                                         02080000
           END-EXEC.                                                    02090000
                                                                        
           EXEC SQL                                                     02110000
               INCLUDE TBLOCOFC                                         02120000
           END-EXEC.                                                    02130000
                                                                        
           EXEC SQL                                                     
                DECLARE AR_CNTL_CSR CURSOR FOR                          
                SELECT LOCAL_OFFICE,                                    
                       PYMT_PRIORITY_LVL,                               
                       SUM(AMT_AR_DAY_00),                              
                       SUM(AMT_AR_DAY_30),                              
                       SUM(AMT_AR_DAY_60),                              
                       SUM(AMT_AR_DAY_90),                              
                       SUM(AMT_UNUSED_CR),                              
                       SUM(AMT_TRAN_BALANCE),                           
                       SUM(TOT_SUMM_UNBILLED)                           
                 FROM CSS_AR_CNTL AC,                                   
                      CSS_ACCOUNT AT                                    
                 WHERE AT.ACCOUNT_NO  = AC.ACCOUNT_NO                   
                     AND AT.ACCOUNT_NO BETWEEN :WS-BEGIN-ACCOUNT-NO     
                                         AND   :WS-END-ACCOUNT-NO       
                     AND (AC.PYMT_PRIORITY_LVL < 50                     
                        OR (AC.PYMT_PRIORITY_LVL > 45                   
                            AND AC.ITEM_ID > 0))                        
                  GROUP BY  LOCAL_OFFICE,AC.PYMT_PRIORITY_LVL           
           END-EXEC.                                                    
      *                                                                 02491400
           EXEC SQL                                                     
                DECLARE CHG_OFF_CSR CURSOR FOR                          
                SELECT LOCAL_OFFICE,                                    
                       PYMT_PRIORITY_LVL,                               
                       SUM(AMT_TRANS)                                   
                 FROM CSS_CHRG_OFF CO,                                  
                      CSS_ACCOUNT AT                                    
                 WHERE AT.ACCOUNT_NO  = CO.ACCOUNT_NO                   
                     AND AT.ACCOUNT_NO BETWEEN :WS-BEGIN-ACCOUNT-NO     
                                         AND   :WS-END-ACCOUNT-NO       
                     AND (CO.PYMT_PRIORITY_LVL < 50                     
                        OR (CO.PYMT_PRIORITY_LVL > 45                   
                            AND CO.ITEM_ID > 0))                        
                  GROUP BY  LOCAL_OFFICE,CO.PYMT_PRIORITY_LVL           
           END-EXEC.                                                    
      *                                                                 02493100
           EXEC SQL                                                     
                DECLARE DEPOSIT_CSR CURSOR FOR                          
                SELECT LOCAL_OFFICE,                                    
                       SUM (AMT_DEPOSIT)                                
C24646            FROM  CSS_DEP_ON_HAND AS DO,                          
                        CSS_ACCOUNT      AT                             
                  WHERE AT.ACCOUNT_NO = DO.ACCOUNT_NO                   
                   AND  AT.ACCOUNT_NO BETWEEN  :WS-BEGIN-ACCOUNT-NO     
                                    AND     :WS-END-ACCOUNT-NO          
PCR482             AND  (DO.DEPOSIT_STATUS_CD = 'A'                     
PCR482              OR   DO.DEPOSIT_STATUS_CD = 'P')                    
                   GROUP BY LOCAL_OFFICE                                
           END-EXEC.                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT              
                                                                        
           PERFORM 1000-ACCUM-LOC-OFFICE THRU 1000-EXIT.                
           PERFORM 2000-PROCESS-OUTPUT   THRU 2000-EXIT                 
              VARYING WS-ACCUM-INDX FROM 1 BY 1                         
T11246        UNTIL WS-ACCUM-INDX GREATER THAN 75                       
                    OR WS-LOCAL-OFFICE-LOC(WS-ACCUM-INDX) = SPACES      
                                                                        
           PERFORM 0200-CLEANUP             THRU 0200-EXIT.             
                                                                        
           GOBACK.                                                      
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
           DISPLAY '<<< PCSCA137 START >>>'.                            
                                                                        
           OPEN OUTPUT FCSWK08-FILE.                                    
      *                                                                 02830000
           IF  FCSST08-SUCCESSFUL                                       
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA137 PROCESSING ERROR  **'              
               DISPLAY '0100-ERROR ON FCSST08 OPEN.  STATUS IS '        
                    WS-FST08-STATUS                                     
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                 02930000
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
                                                                        
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               DISPLAY 'FCA00-COMMON-DATE = ' WS-FCA00-COMMON-DATE      
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
           END-IF.                                                      
                                                                        
              MOVE 0                 TO WS-BEGIN-ACCOUNT-NO.            
                                                                        
              MOVE WS-PART-ALL-NINES TO WS-END-ACCOUNT-NO.              
                                                                        
           MOVE SPACES        TO FIOWK08-BEGIN-REC.                     
           MOVE LOW-VALUES    TO E-FWK08-KEY-BREC.                      
           MOVE 1             TO E-FWK08-PART-NO-BREC.                  
           MOVE WS-INPUT-DATE TO E-FWK08-CREATE-DATE-BREC.              
           PERFORM 8000-WRITE-FCSWK08 THRU 8000-EXIT.                   
           SUBTRACT 1 FROM WS-FWK08-REC-CNTR.                           
           MOVE SPACES TO FIOWK08.                                      
           INITIALIZE    WS-TOTAL-ACCUMS.                               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     03230000
              INCLUDE CPD00048                                          03240000
           END-EXEC.                                                    03250000
                                                                        
       0200-CLEANUP.                                                    
           PERFORM 0250-WRITE-END-CONTROLS  THRU 0250-EXIT.             
           DISPLAY '<<< PCSCA137 COMPLETED >>>'.                        
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0250-WRITE-END-CONTROLS.                                         
           MOVE SPACES            TO FIOWK08.                           
           MOVE HIGH-VALUES       TO E-FWK08-KEY-EREC.                  
           MOVE 1                 TO E-FWK08-PART-NO-EREC.              
           MOVE WS-FWK08-REC-CNTR TO E-FWK08-RECORD-COUNT-EREC.         
           PERFORM 8000-WRITE-FCSWK08 THRU 8000-EXIT.                   
           SUBTRACT 1 FROM WS-FWK08-REC-CNTR.                           
                                                                        
       0250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-ACCUM-LOC-OFFICE.                                           
           PERFORM 1100-PROCESS-AR-CNTL THRU  1100-EXIT.                
           PERFORM 1200-PROCESS-CHARGE-OFF  THRU  1200-EXIT.            
           PERFORM 1300-PROCESS-DEPOSIT  THRU  1300-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-PROCESS-AR-CNTL.                                            
      *                                                                 03670000
           PERFORM 7100-OPEN-AR-CNTL-CSR    THRU 7100-EXIT.             
           PERFORM 7110-FETCH-AR-CNTL-CSR   THRU 7110-EXIT.             
           PERFORM WITH TEST BEFORE                                     
              UNTIL SQLCODE = 100                                       
              PERFORM 1110-PROCESS-AR-CNTLS  THRU 1110-EXIT             
              PERFORM 7110-FETCH-AR-CNTL-CSR THRU 7110-EXIT             
           END-PERFORM.                                                 
      *                                                                 03781000
           PERFORM 7120-CLOSE-AR-CNTL-CSR   THRU 7120-EXIT.             
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1110-PROCESS-AR-CNTLS.                                           
            SET WS-ACCUM-INDX TO 1.                                     
            SEARCH WS-TOTAL-WORK-AREA                                   
            AT END                                                      
                   DISPLAY 'INDEX EXCEEDED'                             
            WHEN WS-LOCAL-OFFICE  = WS-LOCAL-OFFICE-LOC(WS-ACCUM-INDX)  
              PERFORM  1120-ACCUM-AR  THRU  1120-EXIT                   
            WHEN WS-LOCAL-OFFICE-LOC(WS-ACCUM-INDX) EQUAL SPACES        
             MOVE WS-LOCAL-OFFICE TO WS-LOCAL-OFFICE-LOC(WS-ACCUM-INDX) 
             PERFORM 1120-ACCUM-AR   THRU  1120-EXIT                    
           .                                                            
       1110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1120-ACCUM-AR.                                                   
           EVALUATE AC-PYMT-PRIORITY-LVL                                
               WHEN 19                                                  
                    PERFORM 1121-ACCUM-NSC  THRU 1121-EXIT              
               WHEN 20                                                  
                    PERFORM 1122-ACCUM-NSA  THRU 1122-EXIT              
               WHEN 29                                                  
                    PERFORM 1123-ACCUM-NSN  THRU 1123-EXIT              
               WHEN 30                                                  
                    PERFORM 1124-ACCUM-LPC  THRU 1124-EXIT              
               WHEN 39                                                  
                    PERFORM 1125-ACCUM-LPN  THRU 1125-EXIT              
               WHEN 40                                                  
                    PERFORM 1126-ACCUM-ELC  THRU 1126-EXIT              
               WHEN 45                                                  
                    PERFORM 1127-ACCUM-GAS  THRU 1127-EXIT              
               WHEN 50                                                  
                    PERFORM 1128-ACCUM-EPP  THRU 1128-EXIT              
               WHEN 60                                                  
                    PERFORM 1129-ACCUM-CCC  THRU 1129-EXIT              
TP8086         WHEN 70                                                  
TP8086              PERFORM 1130-ACCUM-CIA  THRU 1130-EXIT              
               WHEN 80                                                  
                    PERFORM 1131-ACCUM-DEP  THRU 1131-EXIT              
               WHEN 90                                                  
                    PERFORM 1132-ACCUM-DFA  THRU 1132-EXIT              
               WHEN 100                                                 
                    PERFORM 1133-ACCUM-CNT  THRU 1133-EXIT              
               WHEN 129                                                 
                    PERFORM 1135-ACCUM-PJS  THRU 1135-EXIT              
           END-EVALUATE.                                                
                                                                        
       1120-EXIT.                                                       
           EXIT.                                                        
       1121-ACCUM-NSC.                                                  
           COMPUTE WS-AR-NSC-LOC (WS-ACCUM-INDX)  EQUAL                 
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
T10917                                      + AC-TOT-SUMM-UNBILLED      
               END-COMPUTE.                                             
                                                                        
       1121-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1122-ACCUM-NSA.                                                  
           COMPUTE WS-AR-NSA-LOC (WS-ACCUM-INDX)  EQUAL                 
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
T10917                                      + AC-TOT-SUMM-UNBILLED      
               END-COMPUTE.                                             
                                                                        
       1122-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1123-ACCUM-NSN.                                                  
               COMPUTE WS-AR-NSN-LOC (WS-ACCUM-INDX)   EQUAL            
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
T10917                                      + AC-TOT-SUMM-UNBILLED      
               END-COMPUTE.                                             
                                                                        
       1123-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1124-ACCUM-LPC.                                                  
               COMPUTE WS-AR-LPC-LOC (WS-ACCUM-INDX)   EQUAL            
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
T10917                                      + AC-TOT-SUMM-UNBILLED      
               END-COMPUTE.                                             
                                                                        
       1124-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1125-ACCUM-LPN.                                                  
               COMPUTE WS-AR-LPN-LOC (WS-ACCUM-INDX)   EQUAL            
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
                                            + AC-TOT-SUMM-UNBILLED      
               END-COMPUTE.                                             
                                                                        
       1125-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1126-ACCUM-ELC.                                                  
               COMPUTE WS-AR-ELC-LOC (WS-ACCUM-INDX)   EQUAL            
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
                                            + AC-TOT-SUMM-UNBILLED      
               END-COMPUTE                                              
               COMPUTE WS-UNPD-ELC-LOC (WS-ACCUM-INDX) EQUAL            
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
               END-COMPUTE.                                             
                                                                        
       1126-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1127-ACCUM-GAS.                                                  
               COMPUTE WS-AR-GAS-LOC (WS-ACCUM-INDX)   EQUAL            
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
                                            + AC-TOT-SUMM-UNBILLED      
               END-COMPUTE                                              
               COMPUTE WS-UNPD-GAS-LOC (WS-ACCUM-INDX)  EQUAL           
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
               END-COMPUTE.                                             
                                                                        
       1127-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1128-ACCUM-EPP.                                                  
               COMPUTE WS-UNPD-EPP-LOC (WS-ACCUM-INDX) EQUAL            
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
               END-COMPUTE                                              
               COMPUTE WS-AR-EPP-LOC (WS-ACCUM-INDX)   EQUAL            
                                              AC-AMT-TRAN-BALANCE       
               END-COMPUTE.                                             
                                                                        
       1128-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       1129-ACCUM-CCC.                                                  
               COMPUTE WS-UNPD-CCC-LOC (WS-ACCUM-INDX) EQUAL            
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
               END-COMPUTE                                              
      *                                                                 04401100
               COMPUTE WS-AR-CCC-LOC (WS-ACCUM-INDX)   EQUAL            
                                              AC-AMT-TRAN-BALANCE       
               END-COMPUTE.                                             
                                                                        
       1129-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
TP8086 1130-ACCUM-CIA.                                                  
TP8086         MOVE AC-AMT-UNUSED-CR TO WS-UNPD-CIA-LOC (WS-ACCUM-INDX).
TP8086*                                                                 04402700
TP8086         MOVE AC-AMT-TRAN-BALANCE                                 
TP8086                               TO WS-AR-CIA-LOC (WS-ACCUM-INDX).  
TP8086 1130-EXIT.                                                       
TP8086     EXIT.                                                        
                                                                        
                                                                        
       1131-ACCUM-DEP.                                                  
               COMPUTE WS-UNPD-DEP-LOC (WS-ACCUM-INDX) EQUAL            
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
               END-COMPUTE                                              
      *                                                                 04404200
               COMPUTE WS-AR-DEP-LOC (WS-ACCUM-INDX)   EQUAL            
                                              AC-AMT-TRAN-BALANCE       
               END-COMPUTE.                                             
                                                                        
       1131-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1132-ACCUM-DFA.                                                  
               COMPUTE WS-UNPD-DFA-LOC (WS-ACCUM-INDX) EQUAL            
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
               END-COMPUTE                                              
      *                                                                 04405800
               COMPUTE WS-AR-DFA-LOC (WS-ACCUM-INDX)  EQUAL             
                                              AC-AMT-TRAN-BALANCE       
               END-COMPUTE.                                             
                                                                        
       1132-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1133-ACCUM-CNT.                                                  
               COMPUTE WS-UNPD-CNT-LOC (WS-ACCUM-INDX)  EQUAL           
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
               END-COMPUTE                                              
      *                                                                 04407400
               COMPUTE WS-AR-CNT-LOC (WS-ACCUM-INDX)   EQUAL            
                                              AC-AMT-TRAN-BALANCE       
               END-COMPUTE.                                             
                                                                        
       1133-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1135-ACCUM-PJS.                                                  
T20012*        COMPUTE WS-AR-PJS-LOC (WS-ACCUM-INDX)   EQUAL            04408300
T20012*                                       AC-AMT-AR-DAY-00          04408400
T20012*                                     + AC-AMT-AR-DAY-30          04408500
T20012*                                     + AC-AMT-AR-DAY-60          04408600
T20012*                                     + AC-AMT-AR-DAY-90          04408700
T20012*                                     + AC-AMT-UNUSED-CR          04408800
T20012*                                     + AC-TOT-SUMM-UNBILLED      04408900
T20012*        END-COMPUTE                                              04409000
               COMPUTE WS-AR-PJS-LOC (WS-ACCUM-INDX)   EQUAL            
T20012                                        AC-AMT-TRAN-BALANCE       
               END-COMPUTE                                              
               COMPUTE WS-UNPD-PJS-LOC (WS-ACCUM-INDX) EQUAL            
                                              AC-AMT-AR-DAY-00          
                                            + AC-AMT-AR-DAY-30          
                                            + AC-AMT-AR-DAY-60          
                                            + AC-AMT-AR-DAY-90          
                                            + AC-AMT-UNUSED-CR          
               END-COMPUTE.                                             
                                                                        
       1135-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-PROCESS-CHARGE-OFF.                                         
           PERFORM 7200-OPEN-CHG-OFF-CSR    THRU 7200-EXIT              
           PERFORM 7210-FETCH-CHG-OFF-CSR   THRU 7210-EXIT              
           PERFORM WITH TEST BEFORE                                     
                 UNTIL SQLCODE = 100                                    
               PERFORM 1210-PROCESS-CHG-OFFS THRU 1210-EXIT             
               PERFORM 7210-FETCH-CHG-OFF-CSR  THRU 7210-EXIT           
           END-PERFORM                                                  
      *                                                                 04411000
           PERFORM 7220-CLOSE-CHG-OFF-CSR   THRU 7220-EXIT              
           .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
       1210-PROCESS-CHG-OFFS.                                           
            SET WS-ACCUM-INDX TO 1.                                     
            SEARCH WS-TOTAL-WORK-AREA                                   
            AT END                                                      
              DISPLAY 'LOCAL OFFICE NOT FOUND'                          
            WHEN WS-LOCAL-OFFICE = WS-LOCAL-OFFICE-LOC(WS-ACCUM-INDX)   
              PERFORM  1220-ACCUM-CO  THRU  1220-EXIT                   
T12043      WHEN WS-LOCAL-OFFICE-LOC(WS-ACCUM-INDX) EQUAL SPACES        
T12043       MOVE WS-LOCAL-OFFICE TO WS-LOCAL-OFFICE-LOC(WS-ACCUM-INDX) 
T12043        PERFORM  1220-ACCUM-CO  THRU  1220-EXIT                   
           .                                                            
       1210-EXIT.                                                       
           EXIT.                                                        
       1220-ACCUM-CO.                                                   
           EVALUATE CO-PYMT-PRIORITY-LVL                                
               WHEN 19                                                  
                    MOVE CO-AMT-TRANS TO WS-CO-NSC-LOC(WS-ACCUM-INDX)   
                                                                        
               WHEN 20                                                  
                    MOVE CO-AMT-TRANS TO WS-CO-NSA-LOC(WS-ACCUM-INDX)   
                                                                        
               WHEN 29                                                  
                    MOVE CO-AMT-TRANS TO WS-CO-NSN-LOC(WS-ACCUM-INDX)   
                                                                        
               WHEN 30                                                  
                    MOVE CO-AMT-TRANS TO WS-CO-LPC-LOC(WS-ACCUM-INDX)   
                                                                        
               WHEN 39                                                  
                    MOVE CO-AMT-TRANS TO WS-CO-LPN-LOC(WS-ACCUM-INDX)   
                                                                        
               WHEN 40                                                  
                    MOVE CO-AMT-TRANS TO   WS-CO-ELC-LOC(WS-ACCUM-INDX) 
                                                                        
               WHEN 45                                                  
                    MOVE CO-AMT-TRANS TO  WS-CO-GAS-LOC(WS-ACCUM-INDX)  
                                                                        
               WHEN 60                                                  
                    MOVE CO-AMT-TRANS TO WS-CO-CCC-LOC(WS-ACCUM-INDX)   
                                                                        
               WHEN 90                                                  
                    MOVE CO-AMT-TRANS TO WS-CO-DFA-LOC(WS-ACCUM-INDX)   
                                                                        
               WHEN 100                                                 
                    MOVE CO-AMT-TRANS TO WS-CO-CNT-LOC(WS-ACCUM-INDX)   
                                                                        
               WHEN 129                                                 
                    MOVE CO-AMT-TRANS TO WS-CO-PJS-LOC(WS-ACCUM-INDX)   
                                                                        
               WHEN 999                                                 
                    MOVE CO-AMT-TRANS TO WS-CO-ADJ-LOC(WS-ACCUM-INDX)   
           END-EVALUATE.                                                
                                                                        
       1220-EXIT.                                                       
           EXIT.                                                        
       1300-PROCESS-DEPOSIT.                                            
                                                                        
           PERFORM 7300-OPEN-DEPOSIT-CSR    THRU 7300-EXIT.             
           PERFORM 7310-FETCH-DEPOSIT-CSR   THRU 7310-EXIT.             
           PERFORM WITH TEST BEFORE                                     
              UNTIL SQLCODE = 100                                       
              PERFORM 1310-PROCESS-DEPOSITS  THRU 1310-EXIT             
              PERFORM 7310-FETCH-DEPOSIT-CSR THRU 7310-EXIT             
           END-PERFORM.                                                 
      *                                                                 04980900
           PERFORM 7320-CLOSE-DEPOSIT-CSR   THRU 7320-EXIT.             
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1310-PROCESS-DEPOSITS.                                           
            SET WS-ACCUM-INDX TO 1.                                     
            SEARCH WS-TOTAL-WORK-AREA                                   
            AT END                                                      
              DISPLAY 'LOCAL OFFICE NOT FOUND'                          
            WHEN WS-LOCAL-OFFICE = WS-LOCAL-OFFICE-LOC(WS-ACCUM-INDX)   
TP9994************ DEPOSIT LIABILITIES ARE A CREDIT BALANCE********     04983700
TP9994       MULTIPLY -1  BY DO-AMT-DEPOSIT                             
             MOVE DO-AMT-DEPOSIT TO WS-AR-DEP-TOF-LOC(WS-ACCUM-INDX)    
T12043      WHEN WS-LOCAL-OFFICE-LOC(WS-ACCUM-INDX) EQUAL SPACES        
T12043       MOVE WS-LOCAL-OFFICE TO WS-LOCAL-OFFICE-LOC(WS-ACCUM-INDX) 
T12043       MULTIPLY -1  BY DO-AMT-DEPOSIT                             
T12043       MOVE DO-AMT-DEPOSIT TO WS-AR-DEP-TOF-LOC(WS-ACCUM-INDX)    
           .                                                            
       1310-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
           IF WS-UNPD-ELC-LOC(WS-ACCUM-INDX)  = 0 AND                   
              WS-UNPD-GAS-LOC(WS-ACCUM-INDX)  = 0 AND                   
              WS-UNPD-EPP-LOC(WS-ACCUM-INDX)  = 0 AND                   
              WS-UNPD-CCC-LOC(WS-ACCUM-INDX)  = 0 AND                   
              WS-UNPD-DFA-LOC(WS-ACCUM-INDX)  = 0 AND                   
              WS-UNPD-CIA-LOC(WS-ACCUM-INDX)  = 0 AND                   
              WS-UNPD-DEP-LOC(WS-ACCUM-INDX)  = 0 AND                   
              WS-UNPD-CNT-LOC(WS-ACCUM-INDX)  = 0 AND                   
              WS-UNPD-PJS-LOC(WS-ACCUM-INDX)  = 0 AND                   
              WS-AR-LPC-LOC(WS-ACCUM-INDX)    = 0 AND                   
              WS-AR-ELC-LOC(WS-ACCUM-INDX)    = 0 AND                   
              WS-AR-GAS-LOC(WS-ACCUM-INDX)    = 0 AND                   
              WS-AR-EPP-LOC(WS-ACCUM-INDX)    = 0 AND                   
              WS-AR-CCC-LOC(WS-ACCUM-INDX)    = 0 AND                   
              WS-AR-DFA-LOC(WS-ACCUM-INDX)    = 0 AND                   
              WS-AR-CIA-LOC(WS-ACCUM-INDX)    = 0 AND                   
              WS-AR-DEP-LOC(WS-ACCUM-INDX)    = 0 AND                   
              WS-AR-CNT-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-AR-PJS-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-AR-NSA-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-AR-NSC-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-AR-ADV-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-AR-DEP-TOF-LOC(WS-ACCUM-INDX)  = 0 AND                 
              WS-CO-LPC-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-CO-ELC-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-CO-GAS-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-CO-CCC-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-CO-DFA-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-CO-CNT-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-CO-NSA-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-CO-NSC-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-CO-ADJ-LOC(WS-ACCUM-INDX)      = 0 AND                 
              WS-CO-PJS-LOC(WS-ACCUM-INDX)      = 0                     
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           INITIALIZE FIOWK08.                                          
           MOVE 1                   TO E-FWK08-PART-NO.                 
           MOVE 01                  TO E-FWK08-COMPANY-NO.              
           MOVE WS-LOCAL-OFFICE-LOC(WS-ACCUM-INDX)                      
                                    TO E-FWK08-LOCAL-OFF.               
           MOVE WS-TOTAL-ACCUMS-LOC(WS-ACCUM-INDX)                      
                              TO E-FWK08-TOTAL-ACCUMS.                  
           MOVE WS-B                TO E-FWK08-CODE.                    
           MOVE ZERO                TO E-FWK08-SORT-SUM-FLD.            
           PERFORM 8000-WRITE-FCSWK08 THRU 8000-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       COPY CPD00040.                                                   07930000
       COPY CPD00037.                                                   07940000
                                                                        
                                                                        
       7100-OPEN-AR-CNTL-CSR.                                           
           EXEC SQL                                                     
                OPEN AR_CNTL_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7500-CHECK-DB2-RETURN-CODE THRU 7500-EXIT.           
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-FETCH-AR-CNTL-CSR.                                          
           MOVE '7110'                          TO WS-ABEND-PARAGRAPH.  
                                                                        
           EXEC SQL                                                     
                FETCH AR_CNTL_CSR INTO                                  
                      :WS-LOCAL-OFFICE,                                 
                      :AC-PYMT-PRIORITY-LVL,                            
                      :AC-AMT-AR-DAY-00,                                
                      :AC-AMT-AR-DAY-30,                                
                      :AC-AMT-AR-DAY-60,                                
                      :AC-AMT-AR-DAY-90,                                
                      :AC-AMT-UNUSED-CR,                                
                      :AC-AMT-TRAN-BALANCE,                             
                      :AC-TOT-SUMM-UNBILLED                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7500-CHECK-DB2-RETURN-CODE THRU 7500-EXIT.           
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-CLOSE-AR-CNTL-CSR.                                          
           EXEC SQL                                                     
                CLOSE AR_CNTL_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           PERFORM 7500-CHECK-DB2-RETURN-CODE THRU 7500-EXIT.           
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-OPEN-CHG-OFF-CSR.                                           
           EXEC SQL                                                     
                OPEN CHG_OFF_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7500-CHECK-DB2-RETURN-CODE THRU 7500-EXIT.           
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-FETCH-CHG-OFF-CSR.                                          
           MOVE '7210'                          TO WS-ABEND-PARAGRAPH.  
                                                                        
           EXEC SQL                                                     
                FETCH CHG_OFF_CSR INTO                                  
                      :WS-LOCAL-OFFICE,                                 
                      :CO-PYMT-PRIORITY-LVL,                            
                      :CO-AMT-TRANS                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           PERFORM 7500-CHECK-DB2-RETURN-CODE THRU 7500-EXIT.           
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-CLOSE-CHG-OFF-CSR.                                          
           EXEC SQL                                                     
                CLOSE CHG_OFF_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7500-CHECK-DB2-RETURN-CODE THRU 7500-EXIT.           
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-OPEN-DEPOSIT-CSR.                                           
           EXEC SQL                                                     
                OPEN DEPOSIT_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7500-CHECK-DB2-RETURN-CODE THRU 7500-EXIT.           
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
       7310-FETCH-DEPOSIT-CSR.                                          
           MOVE '7310'                          TO WS-ABEND-PARAGRAPH.  
                                                                        
           EXEC SQL                                                     
                FETCH  DEPOSIT_CSR                                      
                  INTO :WS-LOCAL-OFFICE,                                
                       :DO-AMT-DEPOSIT :WS-ZERO-IND                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7500-CHECK-DB2-RETURN-CODE THRU 7500-EXIT.           
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09231200
       7320-CLOSE-DEPOSIT-CSR.                                          
           EXEC SQL                                                     
                CLOSE DEPOSIT_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7500-CHECK-DB2-RETURN-CODE THRU 7500-EXIT.           
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7500-CHECK-DB2-RETURN-CODE.                                      
           IF SQLCODE = 0 OR 100                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA137       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*========== BAD SQL RETURN CODE =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '*============================================*'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     09610000
               INCLUDE CPD00038                                         09620000
           END-EXEC.                                                    09630000
                                                                        
           EXEC SQL                                                     09650000
               INCLUDE CPD00039                                         09660000
           END-EXEC.                                                    09670000
                                                                        
       8000-WRITE-FCSWK08.                                              
           WRITE FIOWK08.                                               
           ADD 1 TO WS-FWK08-REC-CNTR.                                  
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSWK08-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     09830000
               INCLUDE CPD09900                                         09840000
           END-EXEC.                                                    09850000
