       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBA131.                                        
       DATE-WRITTEN.   SEPT 1989.                                       
           DATE-COMPILED.                                               
      ***************************************************************** 00050000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** 00060000
      **                     PRICE WATERHOUSE                        ** 00070000
      **                1410 NORTH WESTSHORE BLVD                    ** 00080000
      **                   TAMPA, FLORIDA  33607                     ** 00090000
      **                      (813) 287-9200                         ** 00100000
      **                                                             ** 00110000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00120000
      ********                      DB2                       ********* 00130000
      ***************************************************************** 00140000
      **                                                             ** 00150000
      **              PROGRAM  MODIFICATION  LOG                     ** 00160000
      **    DATE    INITIALS     REASON                              ** 00170000
      **    ----    --------     ------                              ** 00180000
      **    12/96     CDS        NEW PROGRAM TO AUTOMATICALLY        ** 00190000
      **                         BALANCE THE SYSTEM.                 ** 00200000
      **                                                             **         
      **    12/02/97  TQT        ADD DISPLAY STATEMENTS FOR ABEND    **         
      **                                                             **         
16733 **    05/09/98  KLP        UPDATES GL_BEGIN BAL IN ORDER TO    **         
      **                         KEEP IT IN SYN WITH CURRENT GL BAL  **         
      **                                                                        
T24436**    10/30/01  COVANSYS   COPYBOOK CPD00061 CHANGED TO SUB    **         
T24436**              CHENNAI    PROGRAM  SCSCB061.                  **         
A04527**    09/23/13  MR7E794    REMOVED UNUSED DCLGENS.             **         
      ***************************************************************** 00240000
           REMARKS.                                                     
      ******************************************************************00260000
      *   THE DAILY SYTEM BALANCE PROGRAM WILL BE EXECUTED ANY TIME THE*00270000
      *   SYTEM NEEDS TO BE BALANCED. THE PRIMARY FUNCTION OF THE      *00280000
      *   SYSTEM BALANCE IS TO BALANCE THE DATA BASE WITHIN IT-        *00290000
      *   SELF AND BALANCE TO THE GENERAL LEDGER ACCOUNT BALANCES.     *00300000
      *   THIS PROGRAM UPDATES THE GL ACCOUNT BALANCES WITH THEIR      *00310000
      *   COORESPONDING AR BALANCES IF THE NUMBERS ARE NOT EQUAL.      *00320000
      *   THIS COMPONENT USES THE SAME INPUT FILE AND LOGIC AS         *00330000
      *   PCSCA131.                                                    *00340000
      *                                                                *00360000
      *   I USE 4 SWITCHES IN THE PROGRAM. THEY ARE USED               *00370000
      *   IN SETTING UP 4-ACROSS ACCOUNTS ON THE PRINT OUT.            *00380000
      *                                                                *00390000
      *   EXPLANATION OF CODE IN COL. 1-3.                             *00400000
      *      STR  STP  LNG  A/N  NAME   DESCR                          *00410000
      *       1    3    3    A   CODE  'A  ' USE FOR LOCAL OFFICE TOTAL*00420000
      *                                'B  ' USE ONLY FOR INVALID CODES*00430000
      *                                'BAA' 2ND POS REFERS TO VALUEA  *00440000
      *                                      WHICH IS USUALLY A NUMBER *00450000
      *                                      OR MONEY WITH NO DECIMALS *00460000
      *                                'BBB' 3RD POS REFERS TO VALUEB  *00470000
      *                                      WHICH IS MONEY COMPARISONS*00480000
      *                                      TAR VS TRC, TRC VS TRD    *00490000
      *              2ND POS         3RD POS                           *00500000
      *              A=X(11)         A=9(09)   COMP-3                  *00510000
      *              B=9(09)V99      B=9(07)V99 COMP-3                 *00520000
      *                                                                *00530000
      *       66   76   11  A/N  VALUEA   VALUEA                       *00540000
      *       85   89   9   NP   VALUEB   VALUEB                       *00550000
      *                                                                *00560000
      ******************************************************************00570000
      *                                                                 00580000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00600000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00630000
           COPY CSSWK08.                                                00640000
HPCCDM*    EJECT                                                        00670000
       DATA DIVISION.                                                   
      *                                                                 00690000
       FILE SECTION.                                                    
      *                                                                 00710000
       COPY CFDWK08.                                                    00720000
       COPY FIOWK08.                                                    00730000
      *                                                                 00770000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBA131'.
MSQ017     COPY MFASQLM.
       01  WS-MISCELLANEOUS.                                            
           05 WS-START                 PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSBA131 STARTS HERE'.            
      ******************************************************************00820000
      *                                                                *00830000
      *    THE FOLLOWING FIELDS ARE USED IN ABEND SITUATIONS.          *00840000
      *    THEY STORE THE ACTIVE PARAGRAPH NUMBER, AND FORCE           *00850000
      *    A DATA EXCEPTION IN THE ABEND PARAGRAPHS.                   *00860000
      *                                                                *00870000
      ******************************************************************00880000
      *    05  WS-ABEND-SPACE               PIC X     VALUE SPACE.      00890000
      *    05  WS-ABEND-NUMERIC REDEFINES WS-ABEND-SPACE                00900000
      *                                     PIC 9.                      00910000
           05  WS-FST08-STATUS              PIC XX.                     
           05  WS-WK08-BEGIN-REC-PROCESSED  PIC X(01) VALUE 'N'.        
           05  WS-IS-THIS-FIRST-RECORD      PIC X(01) VALUE 'Y'.        
               88  WS-THIS-IS-FIRST-RECORD            VALUE 'Y'.        
           05  WS-MORE-WK08-BEGIN-RECS      PIC X(01) VALUE 'Y'.        
               88  NO-MORE-WK08-BEGIN-RECS            VALUE 'N'.        
           05  WS-SUB                  PIC S9(03) COMP-3 VALUE ZERO.    
           05  WS-SUB1                 PIC S9(03) COMP-3 VALUE ZERO.    
           05  WS-HOLD-FWK08-LOCAL-OFF     PIC X(03)  VALUE ZERO.       
           05  WS-PREV-FWK08-LOCAL-OFF     PIC X(03)  VALUE ZERO.       
           05  WS-HOLD-FWK08-COMPANY-NO    PIC X(02)  VALUE ZERO.       
           05  WS-PREV-FWK08-COMPANY-NO    PIC X(02)  VALUE ZERO.       
           05  WS-BALANCE-CODE             PIC 9(02)  VALUE ZERO.       
           05  WS-FCSWK08-REC-CNTR-TOT PIC S9(07) COMP-3 VALUE ZERO.    
       01  WS-GL-ACCT-NO              PIC S999V9999 COMP-3 VALUE ZERO.  
           COPY FIOCA00.                                                01200000
      *                                                                 01210000
           COPY FIOJC01.                                                01220000
      ******************************                                    02400000
      *     GENERAL LEDGER NO 142.01-142.26 ARE SEGMENT TRC, FUNCTIONS  02410000
      *        A-K,Z AMOUNTS                                            02420000
      *     GENERAL LEDGER NO 144.01-26,235.00 ARE SEGMENT TOF AMOUNTS  02430000
      ******************************                                    02440000
      *                                                                 02630000
       01  WS-INPUT-DATE-BREAKDOWN     PIC 9(10)  VALUE ZEROS.          
       01  FILLER REDEFINES WS-INPUT-DATE-BREAKDOWN.                    
           05  WS-INPUT-MM-B           PIC 9(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-INPUT-DD-B           PIC 9(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-INPUT-CC-B           PIC 9(02).                       
           05  WS-INPUT-YY-B           PIC 9(02).                       
      *                                                                 02940000
       01  WS-HOLD-GL-LOCAL-OFF        PIC 9(3)  VALUE ZERO.            
      *                                                                 02970000
       01  PREVIOUS-ACCT.                                               
           05  WS-PRINT-DATE-LAST-TRAN PIC X(10).                       
           05  WS-PRINT-DATE-LAST-TRAN-R REDEFINES                      
               WS-PRINT-DATE-LAST-TRAN.                                 
               10  WS-PRINT-DATE-CC    PIC 99.                          
               10  WS-PRINT-DATE-YY    PIC 99.                          
               10  FILLER              PIC X.                           
               10  WS-PRINT-DATE-MM    PIC 99.                          
               10  FILLER              PIC X.                           
               10  WS-PRINT-DATE-DD    PIC 99.                          
      *                                                                 03260000
       01  WS-CURRENT-DATE             PIC 9(07)  VALUE ZEROS.          
       01  FILLER REDEFINES WS-CURRENT-DATE.                            
           05  FILLER                  PIC 9(01).                       
           05  WS-CURRENT-YY           PIC 9(02).                       
           05  WS-CURRENT-MM           PIC 9(02).                       
           05  WS-CURRENT-DD           PIC 9(02).                       
       01  WS-CURRENT-DATE-DISPLAY.                                     
           05  WS-CURRENT-MM-DISPLAY   PIC 9(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-CURRENT-DD-DISPLAY   PIC 9(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-CURRENT-YY-DISPLAY   PIC 9(02).                       
      *                                                                 03400000
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSBA131'.   
           05  WS-FINAL-TABLE-UPDATE   PIC X(01)    VALUE 'N'.          
           05  WS-AR-LOCAL-OFFICE      PIC S9(9)V99 COMP-3 VALUE ZERO.  
T24436     05  SCSCB061                PIC X(08)    VALUE 'SCSCB061'.   
      *                                                                 03560000
      *                                                                 03900000
       01  WS-DIFFERENCE-BETWEEN-CA-GS.                                 
           03  WS-DIFFERENCE           PIC S9(09)V99 COMP-3 VALUE ZERO. 
      *                                                                 03950000
       01  WS-TOTAL-ACCUMS.                                             
           05 WS-TOTAL-ACCUMS-LOCAL-OFF.                                
      *    BILLED-AND-UNPAID-ACCUM-LOCAL-OFF.                                   
            10 WS-UNPD-UTE-LOCAL-OFF   PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-UTG-LOCAL-OFF   PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-EPP-LOCAL-OFF   PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-CCC-LOCAL-OFF   PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-DFA-LOCAL-OFF   PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-CIA-LOCAL-OFF   PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-DEP-LOCAL-OFF   PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-CNT-LOCAL-OFF   PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-UNPD-PJS-LOCAL-OFF   PIC S9(9)V99 COMP-3 VALUE ZERO.  
      *    AR-LOCAL-OFF-ACCUMS-TRC-TRD.                                         
            10 WS-AR-LPC-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-LPN-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-UTE-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-UTG-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-EPP-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-CCC-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-DFA-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-CIA-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-DEP-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-CNT-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-NSA-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-NSN-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-NSC-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-ADV-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-AR-PJS-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
      *    DEPOSIT-ON-HAND-LOCAL-OFF.                                           
            10 WS-AR-DEP-TOF-LOCAL-OFF PIC S9(9)V99 COMP-3 VALUE ZERO.  
      *    CO-LOCAL-OFF-ACCUMS-TOF.                                             
            10 WS-CO-LPC-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-LPN-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-UTE-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-UTG-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-CCC-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-DFA-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
P072  *     10 WS-CO-CIA-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.          
P072        10 FILLER                  PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-CNT-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-NSA-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-NSN-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-NSC-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-ADJ-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-CO-PJS-LOCAL-OFF     PIC S9(9)V99 COMP-3 VALUE ZERO.  
      *    ACCUMS-FOR-CHG-OFF-TAXES.                                            
            10 WS-CHG-OFF-TAXES-ACC    PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-TOTAL-CHG-OFF-ACC    PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-TOTAL-AR-UNPD-ACC    PIC S9(9)V99 COMP-3 VALUE ZERO.  
            10 WS-TOTAL-AR-OF-AR-ACC   PIC S9(9)V99 COMP-3 VALUE ZERO.  
      *                                                                         
           05  WS-TOTAL-ACCUMS-LOCAL-OFF-TBL                            
                  REDEFINES WS-TOTAL-ACCUMS-LOCAL-OFF.                  
               10  WS-ACCUM-TABLE      PIC S9(9)V99 COMP-3              
                                                    OCCURS 42 TIMES.    
      *                                                                 04500000
       01  WS-GEN-LED-LOCAL-OFFICE-ALL PIC 9(3)V9(04)     VALUE ZERO.   
       01  WS-GEN-LED-LOCAL-OFFICE                                      
           REDEFINES WS-GEN-LED-LOCAL-OFFICE-ALL.                       
           05  WS-GEN-LED-PRE          PIC 9(3)V9(04).                  
      *                                                                 04500000
       COPY CWS09900.                                                   05000000
      *                                                                 05010000
TP5228 COPY CWS00010.                                                   05020000
      *                                                                 05030000
       COPY CWS00004.                                                   05040000
      *                                                                 05050000
       COPY CWS00038.                                                   05060000
      *                                                                 05070000
       COPY CWS00039.                                                   05080000
      *                                                                 05090000
       COPY CWS00061.                                                   05100000
      *                                                                 05110000
       01  WS-FW-STATUS.                                                
           05  WS-FWK08-STATUS             PIC X(02)  VALUE '00'.       
               88  FWK08-SUCCESSFUL                   VALUE '00'.       
      *                                                                 05170000
       01  WS-MISC.                                                     
           05  WS-MORE-FWK08-DATA-SW       PIC X(01)  VALUE 'Y'.        
               88  WS-NO-MORE-FWK08-DATA              VALUE 'N'.        
           05  WS-END-FWK08-REC-PROCESSED  PIC X(01)  VALUE 'N'.        
           05  WS-FWK08-REC-CNTR           PIC S9(07) COMP-3 VALUE ZERO.
       COPY CWS00303.                                                   05270000
      *                                                                 05290000
TP5228 01  RS-RPC-RETURN-CODE.                                          
TP5228     05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
TP5228     05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
      *                                                                 05330000
           EXEC SQL                                                     05340000
              INCLUDE SQLCA                                             05350000
           END-EXEC.                                                    05360000
           EXEC SQL                                                     05400000
              INCLUDE TBGLACCT                                          05410000
           END-EXEC.                                                    05420000
           EXEC SQL                                                     05520000
              INCLUDE TBJBPARM                                          05530000
           END-EXEC.                                                    05540000
       01  WS-MISC-END.                                                 
           05 WS-END                   PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSBA131 ENDS HERE'.              
      *                                                                 05640000
       PROCEDURE DIVISION.                                              
      ******************************************************************05660000
      *                                                                *05670000
      *   0000-MAINLINE.                                               *05680000
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *05690000
      *                                                                *05700000
      ******************************************************************05710000
       0000-MAINLINE.                                                   
      *                                                                 05730000
           PERFORM 0100-INITIALIZATION                 THRU 0100-EXIT.  
      *                                                                 05730000
           PERFORM 0200-PROCESS-BEGIN-REC              THRU 0200-EXIT   
               UNTIL NO-MORE-WK08-BEGIN-RECS.                           
      *                                                                 05890000
           PERFORM 0300-SET-HOLD-PREV-FLDS             THRU 0300-EXIT.  
      *                                                                 05890000
           PERFORM 1000-CREATE-TRIAL-BALANCE           THRU 1000-EXIT   
               UNTIL WS-NO-MORE-FWK08-DATA.                             
      *                                                                 05890000
           PERFORM 3000-PROCESS-END-RECORD             THRU 3000-EXIT.  
      *                                                                 06070000
           PERFORM 9000-TERMINATE                      THRU 9000-EXIT.  
           DISPLAY 'PCSBA131 COMPLETED'.                                
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************06270000
      *                                                                *06280000
      *   0100-INITIALIZATION                                          *06290000
      *        COMMON INITIALIZATION ROUTINE                           *06300000
      *                                                                *06310000
      ******************************************************************06320000
       0100-INITIALIZATION.                                             
           OPEN INPUT FCSWK08-FILE.                                     
           IF FWK08-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSWK08 OPEN.  STATUS IS '        
                        WS-FWK08-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      ***************************************************************   06530000
      *        THE FOLLOWING CODE INSERTED TO ALLOW FOR AN          *   06540000
      *    OVERRIDE OF SYSTEM DATE THRU THE PARAMETER FILE (FCSJC01)*   06550000
      ***************************************************************   06560000
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
           END-IF.                                                      
           MOVE WS-INPUT-DATE TO WS-INPUT-DATE-BREAKDOWN.               
           MOVE WS-INPUT-MM-B TO WS-DISPLAY-MM.                         
           MOVE WS-INPUT-DD-B TO WS-DISPLAY-DD.                         
           MOVE WS-INPUT-YY-B TO WS-DISPLAY-YY.                         
           MOVE WS-DISPLAY-MM TO WS-CURRENT-MM                          
                                 WS-CURRENT-MM-DISPLAY.                 
           MOVE WS-DISPLAY-DD TO WS-CURRENT-DD                          
                                 WS-CURRENT-DD-DISPLAY.                 
           MOVE WS-DISPLAY-YY TO WS-CURRENT-YY                          
                                 WS-CURRENT-YY-DISPLAY.                 
      *****                                                             06730000
           PERFORM 6243-GET-FCA00-UTIL-TYPES  THRU 6243-EXIT.           
           PERFORM 6246-GET-FCA00-EXTRA-DATES THRU 6246-EXIT.           
T24436     MOVE WS-PGRMNAME                   TO                        
T24436                                        WS-CPD00061-CALLING-PGM.  
T24436     MOVE SPACES                        TO  ABEND-FUNCTION.       
T24436     CALL SCSCB061  USING   WS-GL-ACCT-NAME,                      
T24436                            WS-GL-ACCT-MAJOR-FIELDS,              
T24436                            WS-VALID-COMPANY-NOS,                 
T24436                            WS-GL-NAME-INFO,                      
T24436                            WS-GL-ACCT-NO-TABLE,                  
T24436                            WS-CPD00061-CALLING-PGM,              
T24436                            ABEND-FILE,                           
T24436                            RS-RETURN-CODE.                       
T24436                                                                  
T24436     IF ABEND-FUNCTION  > SPACES                                  
T24436        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T24436     END-IF.                                                      
T24436*    PERFORM 0700-LOAD-GL-NO-VALUES     THRU 0700-EXIT            06760000
T24436*        VARYING WS-VALID-CO-SUB FROM 1 BY 1 UNTIL                06770000
T24436*        WS-VALID-CO-SUB GREATER THAN WS-MAX-CO OR                06780000
T24436*        WS-VALID-CO-NO (WS-VALID-CO-SUB) EQUAL WS-GL-99.         06790000
      ******************************************************************06800000
      *    REMOVE BELOW STATEMENT FOR MULTI COMPANY MODIFICATIONS      *06810000
      ******************************************************************06820000
           SET WS-GL-SUB TO 1.                                          
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07060000
T24436*COPY CPD00061.                                                   07070000
      *                                                                 07060000
      ******************************************************************        
      *0200-PROCESS-BEGIN-REC                                          *        
      ******************************************************************        
       0200-PROCESS-BEGIN-REC.                                          
           IF NO-MORE-WK08-BEGIN-RECS                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7000-READ-FCSWK08 THRU 7000-EXIT                 
           END-IF.                                                      
      *                                                                 07150000
           IF NO-MORE-WK08-BEGIN-RECS                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               IF E-FWK08-KEY-BREC EQUAL LOW-VALUES                     
                   SUBTRACT 1 FROM WS-FWK08-REC-CNTR                    
                   MOVE WS-Y TO WS-WK08-BEGIN-REC-PROCESSED             
               ELSE                                                     
                   IF WS-WK08-BEGIN-REC-PROCESSED EQUAL WS-Y            
                       MOVE WS-N TO WS-MORE-WK08-BEGIN-RECS             
                   ELSE                                                 
                       DISPLAY '**    FCSWK08 PROCESSING ERROR    **'   
                       DISPLAY '** FIRST REC IS NOT A CONTROL REC **'   
                       DISPLAY '**     PROCESSING TERMINATED      **'   
                       PERFORM 9900-ABEND THRU 9900-EXIT                
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                 07330000
           IF NO-MORE-WK08-BEGIN-RECS                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               IF E-FWK08-CREATE-DATE-BREC EQUAL WS-INPUT-DATE          
                   NEXT SENTENCE                                        
               ELSE                                                     
                   DISPLAY '**     FCSWK08 PROCESSING ERROR         **' 
                   DISPLAY '**FCSWK08 CREATE DATE NOT EQUAL RUN DATE**' 
                   DISPLAY '**     PROCESSING TERMINATED            **' 
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
       0200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 0300-SET-HOLD-PREV-FLDS                                        *        
      ******************************************************************        
       0300-SET-HOLD-PREV-FLDS.                                         
           MOVE E-FWK08-COMPANY-NO TO WS-HOLD-FWK08-COMPANY-NO          
                                      WS-PREV-FWK08-COMPANY-NO.         
           MOVE E-FWK08-LOCAL-OFF  TO WS-HOLD-FWK08-LOCAL-OFF           
                                      WS-PREV-FWK08-LOCAL-OFF.          
       0300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *1000-CREATE-TRIAL-BALANCE                                       *        
      ******************************************************************        
       1000-CREATE-TRIAL-BALANCE.                                       
           PERFORM 1100-PROCESS-FWK08 THRU 1100-EXIT                    
               UNTIL WS-HOLD-FWK08-COMPANY-NO NOT EQUAL                 
PMB                  WS-PREV-FWK08-COMPANY-NO                           
                  OR WS-HOLD-FWK08-LOCAL-OFF  NOT EQUAL                 
PMB                  WS-PREV-FWK08-LOCAL-OFF                            
                  OR WS-NO-MORE-FWK08-DATA.                             
      *                                                                 07560000
           PERFORM 2000-WRITE-CONTROL-LISTING THRU 2000-EXIT.           
      *                                                                 07580000
           MOVE WS-HOLD-FWK08-COMPANY-NO TO WS-PREV-FWK08-COMPANY-NO.   
PMB        MOVE WS-HOLD-FWK08-LOCAL-OFF  TO WS-PREV-FWK08-LOCAL-OFF.    
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1100-PROCESS-FWK08                                             *        
      ******************************************************************        
       1100-PROCESS-FWK08.                                              
           IF WS-END-FWK08-REC-PROCESSED EQUAL WS-Y                     
               IF E-FWK08-KEY-EREC EQUAL HIGH-VALUES                    
                  PERFORM 1120-PROCESS-END-FWK08-REC THRU 1120-EXIT     
               ELSE                                                     
                  DISPLAY '**      FCSWK08 PROCESSING ERROR       **'   
                  DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'   
                  DISPLAY '**      PROCESSING TERMINATED          **'   
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
           ELSE                                                         
               IF E-FWK08-KEY-EREC EQUAL HIGH-VALUES                    
                   PERFORM 1120-PROCESS-END-FWK08-REC THRU 1120-EXIT    
               ELSE                                                     
                   PERFORM 1110-PROCESS-FWK08-DETAIL  THRU 1110-EXIT    
               END-IF                                                   
           END-IF.                                                      
       1100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1110-PROCESS-FWK08-DETAIL                                      *        
      ******************************************************************        
       1110-PROCESS-FWK08-DETAIL.                                       
           IF E-FWK08-CODE EQUAL WS-B                                   
               PERFORM 1115-ACCUM-LOCAL-OFF-TOTALS THRU 1115-EXIT       
                       VARYING WS-SUB FROM 1 BY 1                       
                       UNTIL WS-SUB GREATER THAN 38                     
           END-IF.                                                      
      *                                                                 07860000
           PERFORM 7000-READ-FCSWK08 THRU 7000-EXIT.                    
      *                                                                 07860000
           IF E-FWK08-KEY-EREC NOT EQUAL HIGH-VALUES                    
               MOVE E-FWK08-COMPANY-NO TO WS-HOLD-FWK08-COMPANY-NO      
               MOVE E-FWK08-LOCAL-OFF  TO WS-HOLD-FWK08-LOCAL-OFF       
           END-IF.                                                      
       1110-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1115-ACCUM-LOCAL-OFF-TOTALS                                    *        
      ******************************************************************        
       1115-ACCUM-LOCAL-OFF-TOTALS.                                     
           ADD E-FWK08-ACCUM (WS-SUB) TO WS-ACCUM-TABLE (WS-SUB).       
       1115-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************0799000 
      * 1120-PROCESS-END-FWK08-REC                                     *        
      ******************************************************************08010000
       1120-PROCESS-END-FWK08-REC.                                      
           SUBTRACT 1 FROM WS-FWK08-REC-CNTR.                           
           ADD E-FWK08-RECORD-COUNT-EREC TO WS-FCSWK08-REC-CNTR-TOT     
           MOVE WS-Y TO WS-END-FWK08-REC-PROCESSED.                     
           PERFORM 7000-READ-FCSWK08 THRU 7000-EXIT.                    
       1120-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************08740000
      * 2000-WRITE-CONTROL-LISTING.                                    *08760000
      *      BALANCES 15 LEDGER RECORDS FOR EACH LOCAL OFFICE BREAK    *08770000
      ******************************************************************08790000
       2000-WRITE-CONTROL-LISTING.                                      
           MOVE 1                           TO WS-HOLD-GL-LOCAL-OFF.    
      *** PROCESS LPC ***********************************************           
           MOVE WS-AR-LPC-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-LPC-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS LPN ***********************************************           
           MOVE WS-AR-LPN-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-LPN-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS UTE ***********************************************           
           MOVE WS-AR-UTE-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-UTE-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS UTG ***********************************************           
           MOVE WS-AR-UTG-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-UTG-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS EPP/BUD *******************************************           
           MOVE WS-AR-BUD-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-EPP-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS CCC ***********************************************   09970000
           MOVE WS-AR-CCC-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-CCC-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS DFA ***********************************************   09970000
           MOVE WS-AR-DFA-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-DFA-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS CIA ***********************************************   09970000
           MOVE WS-AR-CIA-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-CIA-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS DEP ***********************************************   09970000
           MOVE WS-AR-DEP-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-DEP-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS CNT ***********************************************   09970000
           MOVE WS-AR-CNT-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-CNT-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS NSA ***********************************************   09970000
           MOVE WS-AR-NSA-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-NSA-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS NSN ***********************************************   09970000
           MOVE WS-AR-NSN-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-NSN-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS NSC ***********************************************   09970000
           MOVE WS-AR-NSC-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-NSC-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS PJS ***********************************************   09970000
           MOVE WS-AR-PJS-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-PJS-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS ADV ***********************************************   09970000
           MOVE WS-AR-ADV-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-AR-ADV-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      **************************************************************    12710000
      ***  CHARGE OFF FUNDS                                             12730000
      **************************************************************    12750000
      *** PROCESS WO LPC ********************************************   09970000
           MOVE WS-WO-LPC-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-LPC-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS WO LPN ********************************************   09970000
           MOVE WS-WO-LPN-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-LPN-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS WO UTE ********************************************   09970000
           MOVE WS-WO-UTE-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-UTE-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS WO UTG ********************************************   09970000
           MOVE WS-WO-UTG-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-UTG-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS WO CCC ********************************************   09970000
           MOVE WS-WO-CCC-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-CCC-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS WO DFA ********************************************   09970000
           MOVE WS-WO-DFA-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-DFA-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS WO CNT ********************************************   09970000
           MOVE WS-WO-CNT-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-CNT-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS WO NSA ********************************************   09970000
           MOVE WS-WO-NSA-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-NSA-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS WO NSN ********************************************   09970000
           MOVE WS-WO-NSN-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-NSN-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS WO NSC ********************************************   09970000
           MOVE WS-WO-NSC-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-NSC-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS WO PJS ********************************************   09970000
           MOVE WS-WO-PJS-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-PJS-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS WO ADJ ********************************************   09970000
           MOVE WS-WO-ADJ-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE           
                                               WS-GL-ACCT-NO.           
           MOVE WS-CO-ADJ-LOCAL-OFF         TO WS-AR-LOCAL-OFFICE.      
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** PROCESS DEP TOF *******************************************   09970000
           MOVE WS-DEP-DEP-GL-NO (WS-GL-SUB) TO WS-GEN-LED-PRE          
                                                WS-GL-ACCT-NO.          
           MOVE WS-AR-DEP-TOF-LOCAL-OFF      TO WS-AR-LOCAL-OFFICE.     
           PERFORM 2100-PROCESS-GL-AR                THRU 2100-EXIT.    
      *** CLEAR LOCAL OFFICE FIELDS**********************************   09970000
           PERFORM 2200-CLEAR-LOCAL-OFF-ACCUMS THRU 2200-EXIT           
                   VARYING WS-SUB1 FROM 1 BY 1                          
                   UNTIL WS-SUB1 GREATER THAN 42.                       
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************08740000
      * 2100-PROCESS-GL-AR.                                            *08760000
      *        WRITES 15 LEDGER RECORDS FOR EACH LOCAL OFFICE BREAK    *08770000
      ******************************************************************08790000
       2100-PROCESS-GL-AR.                                              
           PERFORM 7100-GET-GENERAL-LEDGER           THRU 7100-EXIT.    
                                                                        
           SUBTRACT GL-ACCT-BALANCE FROM WS-AR-LOCAL-OFFICE             
                                    GIVING WS-DIFFERENCE.               
           IF WS-DIFFERENCE NOT EQUAL 0                                 
              MOVE WS-AR-LOCAL-OFFICE TO GL-ACCT-BALANCE                
              PERFORM 8000-UPDATE-GL-ACCOUNT         THRU 8000-EXIT     
           END-IF.                                                      
       2100-EXIT.                                                       
      ******************************************************************0799000 
      * 2200-CLEAR-LOCAL-OFF-ACCUMS                                    *        
      ******************************************************************08010000
       2200-CLEAR-LOCAL-OFF-ACCUMS.                                     
           MOVE ZERO TO WS-ACCUM-TABLE (WS-SUB1).                       
       2200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************0799000 
      * 3000-PROCESS-END-RECORD                                        *        
      ******************************************************************08010000
       3000-PROCESS-END-RECORD.                                         
           IF WS-FWK08-REC-CNTR EQUAL WS-FCSWK08-REC-CNTR-TOT           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**         FIOWK08 PROCESSING ERROR         **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**      CONTROL REC COUNT = '                   
                                  WS-FCSWK08-REC-CNTR-TOT               
               DISPLAY '**      ACTUAL  REC COUNT = ' WS-FWK08-REC-CNTR 
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 06040000
           MOVE WS-Y TO WS-FINAL-TABLE-UPDATE.                          
       3000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************0799000 
      *7000-READ-FCSWK08                                               *        
      ******************************************************************08010000
       7000-READ-FCSWK08.                                               
           READ FCSWK08-FILE                                            
               AT END                                                   
                    MOVE WS-N TO WS-MORE-FWK08-DATA-SW                  
                    GO TO 7000-EXIT.                                    
           IF FWK08-SUCCESSFUL                                          
               ADD 1 TO WS-FWK08-REC-CNTR                               
           ELSE                                                         
               DISPLAY '7000-ERROR ON FCSWK08 READ.  STATUS IS '        
                        WS-FWK08-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************08440000
      **  7100-GET-GENERAL-LEDGER                                      *08460000
      ******************************************************************08480000
       7100-GET-GENERAL-LEDGER.                                         
      *                                                                         
           MOVE WS-GL-ACCT-NO              TO GL-GL-ACCT-NO.            
           MOVE WS-PREV-FWK08-LOCAL-OFF    TO GL-LOCAL-OFFICE.          
           MOVE WS-PREV-FWK08-COMPANY-NO   TO GL-COMPANY-NO.            
      *                                                                         
           EXEC SQL                                                     
              SELECT ACCT_BALANCE                                       
              INTO   :GL-ACCT-BALANCE                                   
              FROM   CSS_GL_ACCOUNT                                     
              WHERE  GL_ACCT_NO   = :GL-GL-ACCT-NO                      
                AND  LOCAL_OFFICE = :GL-LOCAL-OFFICE                    
                AND  COMPANY_NO   = :GL-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
              CONTINUE                                                  
            WHEN NOT-FOUND                                              
              MOVE ZEROES TO GL-ACCT-BALANCE                            
            WHEN OTHER                                                  
              DISPLAY '** PARAGRAPH 7100-GET-GENERAL-LEDGER **'         
TQT           DISPLAY '** COMPANY = ' GL-COMPANY-NO                     
TQT                   'LOCAL OFFICE = ' GL-LOCAL-OFFICE                 
TQT                   'GL ACCT NO = ' GL-GL-ACCT-NO                     
              DISPLAY '** ABEND RETURN-CODE = ' WS-ACTIVE-RETURN-CODE   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-EVALUATE.                                                
       7100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************08440000
      **  8000-UPDATE-GL-ACCOUNTR                                      *08460000
      ******************************************************************08480000
       8000-UPDATE-GL-ACCOUNT.                                          
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_GL_ACCOUNT                                     
              SET    ACCT_BALANCE = :GL-ACCT-BALANCE,                   
16733                BEGIN_ACCT_BALANCE = :GL-ACCT-BALANCE              
              WHERE  GL_ACCT_NO   = :GL-GL-ACCT-NO                      
                AND  LOCAL_OFFICE = :GL-LOCAL-OFFICE                    
                AND  COMPANY_NO   = :GL-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '** PARAGRAPH 8000-UPDATE-GL-ACCOUNT **'          
TQT           DISPLAY '** COMPANY = ' GL-COMPANY-NO                     
TQT                   'LOCAL OFFICE = ' GL-LOCAL-OFFICE                 
TQT                   'GL ACCT NO = ' GL-GL-ACCT-NO                     
              DISPLAY '** ABEND RETURN-CODE = ' WS-ACTIVE-RETURN-CODE   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 08130000
       COPY CPD00037.                                                   08200000
      *                                                                 08360000
           EXEC SQL                                                     08370000
               INCLUDE CPD00038                                         08380000
           END-EXEC.                                                    08390000
      *                                                                 08400000
           EXEC SQL                                                     08410000
               INCLUDE CPD00039                                         08420000
           END-EXEC.                                                    08430000
      *                                                                 08400000
       COPY CPD00040.                                                   08140000
      *                                                                 08150000
       COPY CPD00043.                                                   08160000
      *                                                                 08170000
       COPY CPD00046.                                                   08180000
      *                                                                         
T24436*    EXEC SQL                                                     08700000
T24436*        INCLUDE CPD00062                                         08710000
T24436*    END-EXEC.                                                    08720000
      ******************************************************************24060000
      *9000-TERMINATE                                                  *        
      ******************************************************************24060000
       9000-TERMINATE.                                                  
       9000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************25080000
      *  9700-PROCESS-ABEND                                           **25100000
      ******************************************************************25120000
      *                                                                 25130000
       COPY CPD0023B.                                                   25140000
      *                                                                 25150000
           EXEC SQL                                                     25160000
               INCLUDE CPD09900                                         25170000
           END-EXEC.                                                    25180000
                                                                        
