000100 IDENTIFICATION DIVISION.                                         
000200 PROGRAM-ID.    PCSAC200.                                         
000300 AUTHOR.        S VALLURI.                                        
000400 DATE-WRITTEN.  NOV 2010.                                         
000500 DATE-COMPILED.                                                   
000600******************************************************************        
000700**               SOUTH CAROLINA ELECTRIC & GAS                  **        
000800**                                                              **        
000900**                CUSTOMER INFORMATION SYSTEM                   **        
001000******************************************************************        
001100*              P R O G R A M  S U M M A R Y                      *        
001200******************************************************************        
001300**                                                              **        
001400** THIS IS A BATCH PROGRAM THAT WILL READ A DB2 TABLE,          **        
001500** CSS_BATCH_EMAIL, FOR INPUT.THE PROGRAM WILL PROCESS ACCOUNTS **        
001600** THAT ARE SETUP TO RECEIVE 'EMAIL' BILL NOTIFICATIONS.        **        
001700**                                                              **        
001800** WE CHECK WHETHER ANY OF THESE ACCOUNTS HAD A EMAIL RETURNED  **        
001900** (BOUNCED) WITHIN  PAST BUSINESS DAY.FOR EACH OF THESE        **        
002000** ACCOUNTS WE CHECK IF A LETTER WAS SENT IN LAST 180 DAYS TO   **        
002100** CUSTOMER TO INFORM THEM OF THE EMAIL ADDRESS BEING INVALID.  **        
002200**                                                              **        
002300** IF A BAD EMAIL LETTER WAS NOT SENT IN LAST 180 DAYS THEN     **        
002400** FOR EACH OF THOSE ACCOUNTS WE WRITE DETAILS INTO OUTPUT     **         
002500** FILE FOR FURTHER PROCESSING BY PCSAC201.                     **        
002600**                                                              **        
002700******************************************************************        
002800**                                                             **         
002900**              PROGRAM  MODIFICATION  LOG                      **        
003000**                                                              **        
003100**    DATE    INITIALS     REASON                               **        
003200**  --------  --------     ----------------------------------   **        
003300**  08/2010   SRIDHAR      PROJ433- INITIAL VERSION OF PROGRAM  **        
003400**            VALLURI                                           **        
ACT058**  03/11/11  GD97441      APPL 3082-ACT058: PROD FIX SQL -304. **        
P00532**  09/07/11  BD09555      ADD SPECIFIC FORM AND BLANK OUT EMAIL**        
P00532**                         FOR ACCOUNTS SPECIFICALLY IDENTIFIED **        
P00532**                         IN DELINQUENCY TABLE.                **        
P00532**  09/08/11  BD09555      ADDITIONAL CLEANUP WORK FROM PREVIOUS**        
P00532**                         UPDATE                               **        
P00532**  09/09/11  BD09555      TRIM BLANKS ON EMAIL ADDRESSES; LIMIT**        
P00532**                         TO 75 WHEN WRITING TO TRANS HIST     **        
P00599**                                                              **        
P00599**  10/09/201 WR19680      INSERT NOTICES INTO DB2 TABLES       **        
P00599**                         INSTEAD OF WRITING IT TO RP000 FILE  **        
P00599**                                                              **        
003500******************************************************************        
003600*                                                                *        
003700*                ---- BASIC SEQUENCE STRUCTURE ----              *        
003800*                                                                *        
003900*  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
004000*  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
004100*  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
004200*  3000 - 4999  NOT USED                                         *        
004300*   5000 - 5999  COMMON PROGRAM MODULES                          *        
004400*  6000 - 6999  COMMON SYSTEM MODULES                            *        
004500*  7000 - 7999  INPUT MODULES                                    *        
004600*  8000 - 8999  OUTPUT MODULES                                   *        
004700*  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
004800*                                                                *        
004900******************************************************************        
005000                                                                  
005100 ENVIRONMENT DIVISION.                                            
005200 CONFIGURATION SECTION.                                           
005300 SOURCE-COMPUTER.    IBM-370.                                     
005400 OBJECT-COMPUTER.    IBM-370.                                     
005500 INPUT-OUTPUT SECTION.                                            
005600 FILE-CONTROL.                                                    
005700*                                                                         
006300 DATA DIVISION.                                                   
006400 FILE SECTION.                                                    
006500*                                                                         
007200 WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC200'.
MSQ017     COPY MFASQLM.
007300*                                                                         
007400 01 WS-START                         PIC X(40) VALUE              
007500       'WORKING STORAGE FOR PCSAC200 STARTS HERE'.                
007600*                                                                         
007700 01  WS-LITERALS.                                                 
007800     05  PROGRAM-NAME                PIC X(08) VALUE 'PCSAC200'.  
007900     05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSAC200'.  
008000     05  WS-Y                        PIC X(01) VALUE 'Y'.         
008100     05  WS-N                        PIC X(01) VALUE 'N'.         
008200     05  WS-NO                       PIC X(01) VALUE 'N'.         
008300     05  WS-YES                      PIC X(01) VALUE 'Y'.         
008400*                                                                         
008600*                                                                         
008700 01  WS-MISC.                                                     
008800     05  WS-FAC200-STATUS            PIC X(02).                   
008900         88 FAC200-SUCCESSFUL                      VALUE '00'.    
009000     05  WS-FAC200R-STATUS           PIC X(02).                   
009100         88 FAC200R-SUCCESSFUL                      VALUE '00'.   
P00532     05  WS-EMAIL-BLANK-OUT-SW       PIC X         VALUE 'Y'.     
P00532         88 BLANKING-EMAILS-TURNED-ON              VALUE 'Y'.     
009200     05  WS-END-OF-FILE              PIC X(01) VALUE 'N'.         
009300         88 END-OF-FILE                        VALUE 'Y'.         
P00532     05  WS-DOMAIN-FLAG              PIC X(01) VALUE ' '.         
P00532         88 DOMAIN-TABLE-FULL                  VALUE 'Y'.         
009400     05  WS-COMMIT-INTERVAL          PIC S9(4)V9(5) USAGE COMP-3  
009500                                               VALUE 100.         
009600     05  WS-RUN-DT                   PIC X(10) VALUE SPACES.      
009700     05  WS-RUN-DT-FMT         REDEFINES WS-RUN-DT.               
009800         10 WS-RUN-CEN              PIC X(2).                     
009900         10 WS-RUN-YEAR                PIC X(2).                  
010000         10 FILLER1                  PIC X(1).                    
010100         10 WS-RUN-MONTH               PIC X(2).                  
010200         10 FILLER2                  PIC X(1).                    
010300         10 WS-RUN-DAY                 PIC X(2).                  
010400     05  WS-PROCESSED-DT             PIC X(10) VALUE SPACES.      
010500     05  WS-PROCESSED-DT-FMT         REDEFINES WS-PROCESSED-DT.   
010600         10 WS-PROCESSED-CEN        PIC X(2).                     
010700         10 WS-PROCESSED-YEAR          PIC X(2).                  
010800         10 FILLER1                  PIC X(1).                    
010900         10 WS-PROCESSED-MONTH         PIC X(2).                  
011000         10 FILLER2                  PIC X(1).                    
011100         10 WS-PROCESSED-DAY           PIC X(2).                  
011200     05  WS-LEGACY-END-DT            PIC X(10) VALUE SPACES.      
011300     05  WS-NBR-BIZDAYS              PIC S9(5)      USAGE COMP-3  
011400                                               VALUE 1.           
011500     05  WS-NBR-LTRDAYS              PIC S9(4)V9(5) USAGE COMP-3  
011600                                               VALUE 180.         
011700     05  WS-COMM-TYPE                PIC 9(02) VALUE 46.          
011800     05  WS-COMM-SUBTYPE             PIC 9(02) VALUE 23.          
011900     05  WS-COMM-DIRECTION           PIC X(01) VALUE 'O'.         
012000     05  WS-COMM-METHOD              PIC X(01) VALUE 'L'.         
012100     05  WS-MESSAGE-NO               PIC S9(5) USAGE COMP         
012200                                               VALUE 4100.        
012300     05  WS-PREV-ACCOUNT-NO         PIC S9(13)V USAGE COMP-3      
012400                                               VALUE 0.           
012300     05  WS-PREV-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3      
012400                                               VALUE 0.           
012500     05  WS-MIN-NBR-OCCURENCES       PIC S9(4)V9(5) USAGE COMP-3  
012600                                               VALUE 1.           
012700     05  WS-MAX-NBR-LETTERS          PIC S9(4)V9(5) USAGE COMP-3  
012800                                               VALUE 500.         
012900     05  WS-LETTER-COUNTER           PIC S9(4)V9(5) USAGE COMP-3  
013000                                               VALUE 0.           
013100     05  WS-COMPANY-NO               PIC X(2)  VALUE '01'.        
013200     05  WS-FROM-DATE                PIC X(10) VALUE SPACES.      
P00599     05  WS-RUN-DATE                 PIC X(10) VALUE SPACES.      
P00599     05  WS-DFLT-USER-ID             PIC X(06) VALUE 'SYSTEM'.    
P00599     05  WS-DFLT-RESP-AREA-ID        PIC X(3)  VALUE SPACES.      
P00599     05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
013300     05  WS-LETTER-DATE              PIC X(10) VALUE SPACES.      
P00532     05  S-RETURN-CODE               PIC 9(4)  COMP.              
P00532     05  WS-EMAIL                    PIC X(40) VALUE SPACES.      
P00532     05  WS-DOMAIN                   PIC X(40) VALUE SPACES.      
P00532     05  WS-SAVE-EMAIL-ADDR-LEN      PIC S9(4) COMP  VALUE +0.    
P00532     05  WS-SAVE-EMAIL-ADDR          PIC X(75) VALUE SPACES.      
P00532     05  WS-SPECIFIC-DOMAIN-MSG      PIC X(5)  VALUE SPACES.      
P00532     05  WS-ALL-DOMAINS-SW           PIC X     VALUE 'N'.         
P00532         88 SELECTING-ALL-DOMAINS              VALUE 'Y'.         
P00532         88 SELECTING-SPECIFIC-DOMAINS         VALUE 'N'.         
P00532     05  WS-TIMESTAMP                PIC X(28).                   
013400     05  WS-NBR-DAYS                 PIC S9(4)V9(5) USAGE COMP-3  
013500                                               VALUE 5.           
013600     05  WS-PREV-COMPANY-NO          PIC X(02) VALUE SPACES.      
ACT058     05  WS-PREV-LTR-CNTR            PIC S9(4) USAGE COMP-3       
013800                                               VALUE 0.           
013900     05  WS-APPL-PGM-ID-ACC          PIC X(09) VALUE 'PCSAC200A'. 
014000     05  WS-APPL-PGM-ID-CUST         PIC X(09) VALUE 'PCSAC200B'. 
014100     05  WS-EMAIL-EVENT              PIC X(01) VALUE SPACES.      
P00599     05  WS-TH-APPL-PROGRAM-ID       PIC X(09) VALUE SPACES.      
P00599     05  WS-TH-TRANS-HIST-FL         PIC X(01) VALUE 'Y'.         
P00599     05  WS-TH-CODE-TRAN-TYPE        PIC X(01) VALUE SPACES.      
P00599     05  WS-CD-COMM-DATA-FL          PIC X(01) VALUE 'N'.         
P00599     05  WS-RP-RP000-FL              PIC X(01) VALUE 'N'.         
P00599     05  WS-NULL-IND-1               PIC S9(04) COMP.             
P00599     05  WS-NULL-IND-2               PIC S9(04) COMP.             
P00599     05  WS-CORRESP-STMT-DT-NULL     PIC S9(04)   COMP.           
P00599     05  WRITTEN-NOTICE-CNT          PIC S9(04)   COMP VALUE 0.   
P00599     05  WS-CURRENT-DATE             PIC X(10)    VALUE SPACES.   
P00599     05  WS-CURRENT-TIMESTAMP        PIC X(26)    VALUE SPACES.   
P00599     05  WS-CORRESP-VAR-TYPE         PIC X(1)     VALUE SPACES.   
P00599     05  WS-CORRESP-VAR-DATA         PIC X(20)    VALUE SPACES.   
P00599     05  WS-CORRESP-VAR-NM           PIC X(20)    VALUE SPACES.   
COB305     05 WS-CORRESP-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.   
P00599     05  WS-WRITE-NOTICE-IND         PIC X(01)    VALUE SPACES.   
P00599         88  WRITE-NOTICE                         VALUE 'Y'.      
P00532     05  WS-PAPERLESS-SW             PIC X(01) VALUE 'N'.         
P00532         88  BLANKING-PAPERLESS-ONLY           VALUE 'Y'.         
P00532         88  BLANKING-ALL-ACCOUNTS             VALUE 'A'.         
P00532         88  BLANKING-PRINTED-ONLY             VALUE 'P'.         
P00532     05  WS-NOTICE-SW                PIC X(01) VALUE 'N'.         
P00532         88  PROCESSING-PAPERLESS-ONLY         VALUE 'Y'.         
P00532         88  PROCESSING-ALL-ACCOUNTS           VALUE 'A'.         
P00532         88  PROCESSING-PRINTED-ONLY           VALUE 'P'.         
P00532     05  WS-SPECIAL-BOUNCE-NOTICE    PIC X(01) VALUE 'N'.         
P00532         88  SPECIAL-BOUNCE-NOTICE             VALUE 'Y'.         
P00532     05  WS-DOMAIN-ON-DELINQ         PIC X(01) VALUE SPACES.      
P00532         88  THE-DOMAIN-WAS-ON-THE-TABLE       VALUE 'Y'.         
P00532         88  THE-DOMAIN-WAS-NOT-ON-TABLE       VALUE 'N'.         
P00532     05  WS-DELETE-EMAIL-SW          PIC X(01) VALUE 'N'.         
P00532         88  THE-EMAIL-IS-TO-BE-ERASED         VALUE 'Y'.         
014200     05  WS-INCLUDED-EMAIL-EVENTS    OCCURS 50 TIMES              
014300            INDEXED BY WS-INCLUDED-INDEX.                         
014400         10 WS-INCLUDED-EVENT-CD     PIC X(05).                   
014500         10 WS-INCLUDED-COMPANY-NO   PIC X(02).                   
P00532     05  WS-DOMAIN-TAB-GRP.                                       
P00532         10  WS-DOMAIN-TAB                                        
P00532                OCCURS 50 TIMES                                   
P00532                INDEXED BY WS-DOM-IX.                             
P00532             15 WS-DOMAIN-TAB-FLAG       PIC 9.                   
P00532             15 WS-DOMAIN-TAB-DOM        PIC X(35).               
014600*                                                                         
014700 01  WS-COMMIT-MISC.                                              
014800     05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE 0.           
014900     05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE 0.           
015000     05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 100.         
015100     05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 100.         
015200     05  WS-COMMIT-COUNTER           PIC S9(7) VALUE ZERO COMP-3. 
015300     05  WS-RESTART-DATA-LENGTH      PIC S9(4) COMP VALUE +52.    
015400*                                                                         
015500 01  WS-RESTART-DATA.                                             
015600     05 WS-IS-THIS-A-RESTART        PIC X(02) VALUE 'N'.          
015700        88 WS-THIS-IS-A-RESTART               VALUE 'Y'.          
015800        88 WS-THIS-IS-NOT-A-RESTART           VALUE 'N'.          
015900     05 WS-RESTART-PROCESS-TYPE     PIC 9(01).                    
016000     05 WS-RESTART-JOB-COMPLETE   REDEFINES                       
016100            WS-RESTART-PROCESS-TYPE     PIC X(01).                
016200     05 WS-RESTART-JOB-STATUS       PIC X(01).                    
016300        88  WS-RUN-COMPLETED-NO-PROBLEMS       VALUE 'A'.         
016400        88  WS-RERUN-COMPLETED                 VALUE 'B'.         
016500        88  WS-RERUN-PENDING                   VALUE 'C'.         
016600     05 WS-RESTART-RUN-DATE         PIC X(10).                    
016610     05 WS-RESTART-PROCESS-DATE      PIC X(10).                   
016700     05 WS-RESTART-LEGACY-DATE      PIC X(10).                    
COB305     05 WS-RESTART-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.     
016900     05 WS-RESTART-LETTER-CNTR      PIC S9(05) VALUE 0.           
017000*                                                                         
017100     COPY FIORP000.                                                       
017200*                                                                         
017300     COPY FIOCA00.                                                        
P00599*                                                                         
017500     COPY FIOJC01.                                                        
017600*                                                                         
017700******************************************************************        
017800* WORKING STORAGE COPYBOOK FOR CPD00038 USED FOR RESTART LOGIC   *        
017900******************************************************************        
018000     EXEC SQL                                                             
018100        INCLUDE CWS00038                                                  
018200     END-EXEC.                                                            
018300                                                                  
018400******************************************************************        
018500* WORKING STORAGE COPYBOOK FOR CPD00039 USED FOR COMMON DATE     *        
018600******************************************************************        
018700     EXEC SQL                                                             
018800        INCLUDE CWS00039                                                  
018900     END-EXEC.                                                            
019000                                                                  
019100******************************************************************        
019200** CWS00010  CONTAINS DB2 ABEND VARIABLES                        *        
019300******************************************************************        
019400     COPY CWS00010.                                                       
019500                                                                  
019600******************************************************************        
019700*  COPYBOOK WITH COMMON SQL VARIABLES                            *        
019800******************************************************************        
019900     COPY CWS00303.                                                       
020000                                                                  
020100******************************************************************        
020200* WORKING STORAGE FOR CPD09900                                   *        
020300******************************************************************        
020400     COPY CWS09900.                                                       
020500                                                                  
020600******************************************************************        
020700* WORKING STORAGE FOR CPD00315 USED FOR PREV. BUSINESS DAY LOGIC *        
020800*****************************************************************         
020900     EXEC SQL                                                             
021000        INCLUDE CWS00315                                                  
021100     END-EXEC.                                                            
021200                                                                  
P00599*****************************************************************         
P00599*  CWS00341  - INSERT INTO CSS_CORRESP_HDR, CSS_CORRESP_NOTICE, *         
P00599*              AND CSS_CORRESP_VAR.                             *         
P00599*****************************************************************         
P00599*                                                                         
P00599      EXEC SQL                                                            
P00599           INCLUDE CWS00341                                               
P00599      END-EXEC.                                                           
P00599*                                                                         
P00599*                                                                 00771400
P00599******************************************************************        
P00599* WS CWS00350                                                    *        
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE CWS00350                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599******************************************************************        
P00599** CWSCA165: THIS COPYBOOK IS THE WORKING STORAGE FOR CPDCA165 ** 00020000
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE CWSCA165                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599*                                                                 00771400
P00599*****************************************************************         
P00599*  CWS00329  - GOOD PAYMENT                                     *         
P00599*****************************************************************         
P00599*                                                                         
P00599*COPY CWS00329.                                                           
P00599*                                                                         
021300*******************************************************************       
021400*    DECLARATION FOR SQL COMMAND AREA                            *        
021500******************************************************************        
021600     EXEC SQL                                                             
021700        INCLUDE SQLCA                                                     
021800     END-EXEC.                                                            
021900                                                                  
022000******************************************************************        
022100*    TABLE : CSS_USER_PROFILE, PF                                *        
022200******************************************************************        
022300     EXEC SQL                                                             
022400        INCLUDE TBUSRPRF                                                  
022500     END-EXEC.                                                            
022600                                                                  
022700******************************************************************        
022800*    TABLE : CSS_ACCOUNT, AT                                     *        
022900******************************************************************        
023000     EXEC SQL                                                             
023100        INCLUDE TBACCT                                                    
023200     END-EXEC.                                                            
023300                                                                  
023400******************************************************************        
023500*    TABLE : CSS_BATCH_EMAIL, AE                                 *        
023600******************************************************************        
023700     EXEC SQL                                                             
023800        INCLUDE TBBEMAIL                                                  
023900     END-EXEC.                                                            
024000                                                                  
P00532******************************************************************        
P00532*    TABLE : CSS_MNT_TRANS_HIST                                           
P00532******************************************************************        
P00532     EXEC SQL                                                             
P00532        INCLUDE TBMNHIST                                                  
P00532     END-EXEC.                                                            
P00532                                                                  
P00532******************************************************************        
P00532*    TABLE : CSS_MT_TRN_HST_DET                                           
P00532******************************************************************        
P00532     EXEC SQL                                                             
P00532        INCLUDE TBMNHDT                                                   
P00532     END-EXEC.                                                            
P00532                                                                  
P00532******************************************************************        
P00532*    TABLE : CSS_CUST_EMAIL, NE                                  *        
P00532******************************************************************        
P00532     EXEC SQL                                                             
P00532        INCLUDE TBCSTEML                                                  
P00532     END-EXEC.                                                            
024000                                                                  
024100******************************************************************        
024200*    TABLE : CSS_COMM_DATA, KO                                   *        
024300******************************************************************        
024400     EXEC SQL                                                             
024500        INCLUDE TBCOMDAT                                                  
024600     END-EXEC.                                                            
024700                                                                  
024800******************************************************************        
024900*    TABLE : CSS_RESTART, RF                                     *        
025000******************************************************************        
025100     EXEC SQL                                                             
025200        INCLUDE TBRESTRT                                                  
025300     END-EXEC.                                                            
025400                                                                  
025500******************************************************************        
025600*    TABLE : CSS_DELINQUENCY, C8                                 *        
025700******************************************************************        
025800     EXEC SQL                                                             
025900        INCLUDE TBDELQ                                                    
026000     END-EXEC.                                                            
026100                                                                  
026200******************************************************************        
026300*    TABLE : CSS_HOLIDAY, J8                                     *        
026400******************************************************************        
026500     EXEC SQL                                                             
026600         INCLUDE TBHLDAY                                                  
026700     END-EXEC.                                                            
026800                                                                  
026900******************************************************************        
027000*    TABLE : CSS_JOB_PARM, G6                                    *        
027100******************************************************************        
027200     EXEC SQL                                                             
027300        INCLUDE TBJBPARM                                                  
027400     END-EXEC.                                                            
027500                                                                  
P00599******************************************************************06330000
P00599* CSS_CORRESP_HDR - 1J                                           *06340000
P00599******************************************************************06350000
      *                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORHDR                                                 
P00599     END-EXEC.                                                            
      *                                                                         
P00599******************************************************************        
P00599* CSS_CORRESP_NOTICE - 1M                                       *         
P00599******************************************************************        
      *                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORNOT                                                 
P00599     END-EXEC.                                                            
      *                                                                         
P00599******************************************************************06330000
P00599* CSS_CORRESP_VAR - 1K                                           *06340000
P00599******************************************************************06350000
      *                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORVAR                                                 
P00599     END-EXEC.                                                            
      *                                                                         
P00599******************************************************************07520000
P00599*    TABLE : CSS_REG_PROFILE, LR                                 *07530000
P00599******************************************************************07540000
P00599     EXEC SQL                                                     07550000
P00599        INCLUDE TBREGPRF                                          07560000
P00599     END-EXEC.                                                    07570000
P00599                                                                  
P00599******************************************************************06330000
P00599* CSS_CORRESP_COMM - IL                                          *06340000
P00599******************************************************************06350000
      *                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORCOM                                                 
P00599     END-EXEC.                                                            
      *                                                                         
P00599******************************************************************07170000
P00599*    TABLE : CSS_CUSTOMER CU                                     *07180000
P00599******************************************************************07190000
P00599     EXEC SQL                                                     07200000
P00599        INCLUDE TBCUST                                            07210000
P00599     END-EXEC.                                                    07220000
P00599*                                                                 07230000
P00599                                                                  
027700******************************************************************        
027800*    SQL DECLARE STATEMENTS                                      *        
027900******************************************************************        
028000                                                                  
028100*----------------------------------------------------------------*        
028200* CURSOR TO GET EXCLUDE EMAIL EVENT CODES AND OVERRIDES FOR      *        
028300* BUSINESS DAYS, MIN NUMBER OF OCCURENCES AND NUMBER OF DAYS     *        
028400*----------------------------------------------------------------*        
028500                                                                  
028600     EXEC SQL                                                     
028700        DECLARE DELINQ_CURSOR CURSOR FOR                          
028800        SELECT COMPANY_NO                                         
028900               ,DELINQ_CD                                         
029000               ,DELINQ_VALUE                                      
029000               ,UPPER(DESCRIPTION)                                
029100          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
029200         WHERE (DELINQ_CD    LIKE 'SW-BNC%'                       
029300           AND DELINQ_VALUE    = 1)                               
029400            OR DELINQ_CD LIKE 'NO-BNCLTR%'                        
029500            OR DELINQ_CD LIKE 'CD-BNCLTR%'                        
P00532            OR DELINQ_CD LIKE 'EMAIL-DOMAIN%'                     
P00532            OR DELINQ_CD LIKE 'DOMAIN-BNC%'                       
029600           FOR READ ONLY                                  
029610                                                      
029700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DELINQ_CURSOR CURSOR FOR                                  
MFA-TR*       SELECT COMPANY_NO                                                 
MFA-TR*              ,DELINQ_CD                                                 
MFA-TR*              ,DELINQ_VALUE                                              
MFA-TR*              ,UPPER(DESCRIPTION)                                        
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE (DELINQ_CD    LIKE 'SW-BNC%'                               
MFA-TR*          AND DELINQ_VALUE    = 1)                                       
MFA-TR*           OR DELINQ_CD LIKE 'NO-BNCLTR%'                                
MFA-TR*           OR DELINQ_CD LIKE 'CD-BNCLTR%'                                
MFA-TR*           OR DELINQ_CD LIKE 'EMAIL-DOMAIN%'                             
MFA-TR*           OR DELINQ_CD LIKE 'DOMAIN-BNC%'                               
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 2001                                                   
MFA-TR*    END-EXEC.                                                            
029800                                                                  
029900*----------------------------------------------------------------*        
030000* CURSOR TO GET CANDIDATE ACCOUNTS THAT HAVE AN EMAIL RETURNED   *        
030100* THE PREV BUSINESS DAY AND WITH EMAIL EVENT 2 BUS. DAYS PRIOR   *        
030200*----------------------------------------------------------------*        
030300*                                                                         
030400     EXEC SQL                                                     
030500        DECLARE CANDIDATE_ACCT CURSOR WITH HOLD FOR               
030600        SELECT AE.ACCOUNT_NO                                      
030700               ,AT.CUSTOMER_NO                                    
030800               ,AT.COMPANY_NO                                     
030800               ,AT.NO_BILL_COPIES                                 
P00599               ,AT.PREMISE_NO                                     
P00599               ,AT.ADDRESS_ID                                     
P00599               ,AT.ADDRESS_FORMAT                                 
P00599               ,AT.LOCAL_OFFICE                                   
P00599               ,CU.NAME_ID                                        
030900               ,AE.EMAIL_EVENT_CD                                 
P00532               ,UPPER(RTRIM(NE.EMAIL_ADDRESS_TX))                 
031000          FROM CSS_ACCOUNT         AT WITH(READUNCOMMITTED)               
031100               ,CSS_BATCH_EMAIL    AE WITH(READUNCOMMITTED)               
P00532               ,CSS_CUST_EMAIL     NE WITH(READUNCOMMITTED)               
P00599               ,CSS_CUSTOMER       CU WITH(READUNCOMMITTED)               
031200         WHERE AE.ACCOUNT_NO     = AT.ACCOUNT_NO                  
P00532           AND AE.CUSTOMER_NO    = NE.CUSTOMER_NO                 
P00599           AND AE.CUSTOMER_NO    = CU.CUSTOMER_NO                 
P00532           AND AE.EMAIL_EVENT_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROCESSED-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESSED-DT
              ) <> 0) OR (LEN(:WS-PROCESSED-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESSED-DT
              ), CONVERT(DATE, :WS-PROCESSED-DT) )               
031400           AND AE.PROCESSED_CD   = 'B'                            
031600         ORDER BY AE.CUSTOMER_NO,                                 
031600                  AE.ACCOUNT_NO                                   
031700         FOR READ ONLY                                    
031710                                                      
031800     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CANDIDATE_ACCT CURSOR WITH HOLD FOR                       
MFA-TR*       SELECT AE.ACCOUNT_NO                                              
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.NO_BILL_COPIES                                         
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.ADDRESS_FORMAT                                         
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,CU.NAME_ID                                                
MFA-TR*              ,AE.EMAIL_EVENT_CD                                         
MFA-TR*              ,UPPER(RTRIM(NE.EMAIL_ADDRESS_TX))                         
MFA-TR*         FROM CSS_ACCOUNT         AT                                     
MFA-TR*              ,CSS_BATCH_EMAIL    AE                                     
MFA-TR*              ,CSS_CUST_EMAIL     NE                                     
MFA-TR*              ,CSS_CUSTOMER       CU                                     
MFA-TR*        WHERE AE.ACCOUNT_NO     = AT.ACCOUNT_NO                          
MFA-TR*          AND AE.CUSTOMER_NO    = NE.CUSTOMER_NO                         
MFA-TR*          AND AE.CUSTOMER_NO    = CU.CUSTOMER_NO                         
MFA-TR*          AND AE.EMAIL_EVENT_DT = :WS-PROCESSED-DT                       
MFA-TR*          AND AE.PROCESSED_CD   = 'B'                                    
MFA-TR*        ORDER BY AE.CUSTOMER_NO,                                         
MFA-TR*                 AE.ACCOUNT_NO                                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 2002                                                     
MFA-TR*    END-EXEC.                                                            
031900                                                                  
032000 01  WS-END                          PIC X(40)                    
032100     VALUE 'WORKING STORAGE FOR PCSAC200 ENDS HERE  '.            
032200*                                                                         
032300 PROCEDURE DIVISION.                                              
032400*                                                                         
032500******************************************************************        
032600* 0000-MAINLINE                                                  *        
032700******************************************************************        
032800 0000-MAINLINE.                                                   
032900                                                                  
033000     PERFORM 1000-INITIALIZATION                THRU 1000-EXIT.   
033100     PERFORM 2000-PROCESS-OUTPUT                THRU 2000-EXIT.   
033200     PERFORM 9000-TERMINATE                     THRU 9000-EXIT.   
033300     STOP RUN.                                                    
033400                                                                  
033500 0000-EXIT.                                                       
033600     EXIT.                                                        
033700*                                                                         
033800******************************************************************        
033900* 1000-INITIALIZATION                                            *        
034000* GET PROCESSED DATE, FROM DATE AND DELINQUENCY VALUES           *        
034100******************************************************************        
034200 1000-INITIALIZATION.                                             
034300*                                                                         
034410*                                                                         
P00532     MOVE 0 TO AT-CUSTOMER-NO.                                    
035000     PERFORM 1100-PROCESS-DATE           THRU 1100-EXIT.          
036500*                                                                         
036600     SET WS-INCLUDED-INDEX            TO 1.                       
P00532     SET WS-DOM-IX                    TO 1.                       
036700*                                                                         
036800     PERFORM 1150-GET-DELINQ-DATA             THRU 1150-EXIT.     
036900*                                                                         
036910     PERFORM 7100-GET-LETTER-DATE             THRU 7100-EXIT.     
036920*                                                                         
037000     DISPLAY   '** RUN DATE:'  WS-RUN-DT.                         
037100     DISPLAY   '** EMAIL EVENT DATE:'  WS-PROCESSED-DT.           
037300     DISPLAY   '** LETTER DATE: '  WS-LETTER-DATE.                
037300     DISPLAY   '** LEGACY DATE: '  WS-LEGACY-END-DT.              
039510*                                                                         
039600 1000-EXIT.                                                       
039700     EXIT.                                                        
039800                                                                  
039900*                                                                         
040000******************************************************************        
040100* 1100-PROCESS-DATE                                              *        
040200* GET ALL VALUES FROM CSS_JOB_PARM_TABLE.                        *        
040300* CHECK POINT OR COMMIT LIMITS, RUN DATE, LEGACY DATE.           *        
040400******************************************************************        
040500 1100-PROCESS-DATE.                                               
040600* READ JOB PARM FOR OVERRIDE DATE AND LEGACY DATE                         
040700     MOVE SPACES                   TO WS-INPUT-AREA.              
040800     MOVE WS-PGRMNAME              TO G6-PROGRAM-NAME.            
040900     MOVE WS-COMPANY-NO            TO G6-COMPANY-NO.              
041000     MOVE WS-DATE                  TO G6-CMND-CODE.               
041100     MOVE SPACES                   TO WS-INPUT-DATA-BREAKDOWN.    
041200*                                                                         
P00532     INITIALIZE WS-SYSIPT WS-DOMAIN-TAB-GRP.                      
041310*                                                                         
041320*    GET THE COMMIT OR CHECK POINT VALUES FROM JOB PARM                   
041330*    TABLE.                                                               
041340*                                                                         
041400     PERFORM 6253-GET-FJC01-CHKP-LIMIT THRU 6253-EXIT.            
041410*                                                                         
041420*    GET THE RUN DATE FROM JOB PARM TABLE. IF IT IS NOT AVAILABLE         
041430*    THEN USE COMMON DATE.                                                
041440*                                                                         
041500     PERFORM 6251-GET-FJC01-DATE       THRU 6251-EXIT.            
041600     IF COMMON-DATE-NEEDED                                        
041700         PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
041800         MOVE WS-FCA00-COMMON-DATE     TO WS-INPUT-DATE           
041900     END-IF.                                                      
042000     MOVE WS-INPUT-DATE               TO WS-PROCESSED-DT          
                                               WS-RUN-DT                
P00599                                         WS-RUN-DATE.             
042200*                                                                         
042300*    NOW GET THE LEGACY DATE                                              
042301*                                                                         
041300     INITIALIZE WS-SYSIPT.                                        
041300     INITIALIZE WS-INPUT-DATA-BREAKDOWN.                          
042310     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
042320     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
042321        UNTIL WS-INPUT-DATA-BREAKDOWN(1:12) = "LEGACY DATE="      
042322        OR END-OF-SYSIPT.                                         
042323     IF NOT END-OF-SYSIPT                                         
042330       PERFORM 7611-CLOSE THRU 7611-EXIT                          
042400       MOVE WS-INPUT-DATA-BREAKDOWN(13:22) TO WS-LEGACY-END-DT    
042410     END-IF.                                                      
042420*                                                                         
      *                                                                         
P00599* TO IDENTIFY THE DATA BASE                                               
P00599     MOVE ZERO                            TO WS-CWS350-DATABASE.  
P00599     MOVE '01'                            TO C8-COMPANY-NO.       
P00599     MOVE 'DATABASE'                      TO C8-DELINQ-CD.        
P00599     PERFORM 7250-SELECT-DELINQ-VALUE     THRU 7250-EXIT.         
P00599     MOVE C8-DELINQ-VALUE                 TO WS-CWS350-DATABASE.  
042510 1100-EXIT.                                                       
042600     EXIT.                                                        
042700*                                                                         
042800******************************************************************        
042900* 1150-GET-DELINQ-DATA                                           *        
043000* GET PROGRAM VALUES FROM CSS_DELINQUENCY TABLE                  *        
043100******************************************************************        
043200 1150-GET-DELINQ-DATA.                                            
043300* READ DELINQUENCY                                                        
P00532     MOVE SPACES TO C8-DESCRIPTION.                               
043400     PERFORM 7200-OPEN-DELINQ-CUR               THRU 7200-EXIT.   
043500     PERFORM 7210-FETCH-DELINQ-CUR              THRU 7210-EXIT.   
043600                                                                  
043700     PERFORM 1200-PROCESS-DELINQ               THRU 1200-EXIT     
043800       UNTIL WS-ACTIVE-RETURN-CODE =  NOT-FOUND.                  
043900                                                                  
044000     PERFORM 7220-CLOSE-DELINQ-CUR              THRU 7220-EXIT.   
042441*                                                                         
042430* NOW COMPUTE THE BUSINESS DAY ON WHICH EMAIL EVENT WAS                   
P00532* PROCESSED. IT IS TYPICALLY 4 BUSINESS DAYS PRIOR TO RUN DATE.           
042441*                                                                         
P00532*    FIND THE EVENT DATE BASED ON THE NUMBER OF BUSINESS DAYS             
P00532*    PREVIOUS TO TODAY                                                    
P00532     PERFORM WS-NBR-BIZDAYS TIMES                                 
P00532         MOVE 'N' TO WS-NEXT-BUSINESS-DAY                         
042450         MOVE WS-PROCESSED-DT  TO WS-NEW-BUSINESS-DAY             
042460         PERFORM 6525-PREV-BUSINESS-DAY THRU                      
042470                 6525-PREV-BUSINESS-DAY-EXIT UNTIL                
042480                 NEXT-BUSINESS-DAY-FOUND                          
042481         MOVE WS-NEW-BUSINESS-DAY TO WS-PROCESSED-DT              
P00532     END-PERFORM.                                                 
042482*                                                                         
042503*                                                                         
P00532     PERFORM VARYING WS-DOM-IX FROM 1 BY 1 UNTIL                  
P00532         WS-DOM-IX > 50 OR WS-DOMAIN-TAB-DOM (WS-DOM-IX) = SPACES 
P00532             IF SELECTING-SPECIFIC-DOMAINS                        
P00532                 IF WS-DOMAIN-TAB-FLAG (WS-DOM-IX) = 1            
P00532                     DISPLAY 'INCLUDING DOMAIN '                  
P00532                        WS-DOMAIN-TAB (WS-DOM-IX)                 
P00532                 END-IF                                           
P00532               ELSE                                               
P00532                 IF WS-DOMAIN-TAB-FLAG (WS-DOM-IX) = 0            
P00532                     DISPLAY 'EXCLUDING DOMAIN '                  
P00532                        WS-DOMAIN-TAB (WS-DOM-IX)                 
P00532                 END-IF                                           
P00532             END-IF                                               
P00532     END-PERFORM                                                  
P00532     IF WS-DOMAIN-TAB-DOM (50) > SPACES                           
P00532         DISPLAY 'PCSAC200 DOMAIN TABLE FULL - '                  
P00532         'CHECK FOR OVERFLOW'                                     
P00532         MOVE 'Y' TO WS-DOMAIN-FLAG                               
P00532       ELSE                                                       
P00532         IF WS-DOMAIN-TAB-DOM (45) > SPACES                       
P00532             DISPLAY 'PCSAC200 DOMAIN TABLE NEARING LIMIT - '     
P00532             'INCREASE'                                           
P00532             MOVE 'Y' TO WS-DOMAIN-FLAG                           
P00532         END-IF                                                   
P00532     END-IF.                                                      
044300 1150-EXIT.                                                       
044400      EXIT.                                                       
044500*                                                                         
044600******************************************************************        
044700* 1200-PROCESS-DELINQ                                            *        
044800* GET VALUES FROM CSS_DELINQUENCY TABLE AND INITIALIZE VARIABLES *        
044900******************************************************************        
045000 1200-PROCESS-DELINQ.                                             
045100                                                                  
045200     EVALUATE C8-DELINQ-CD                                        
045300        WHEN 'NO-BNCLTR-OCCURRENCE'                               
045400          MOVE C8-DELINQ-VALUE      TO WS-MIN-NBR-OCCURENCES      
045500          DISPLAY   'MIN-NBR-OCCURENCES: ' WS-MIN-NBR-OCCURENCES  
045600        WHEN 'NO-BNCLTR-MAXLETTERS'                               
045700          MOVE C8-DELINQ-VALUE     TO WS-MAX-NBR-LETTERS          
045800          DISPLAY   '   MAX-NBR-LETTERS: '  WS-MAX-NBR-LETTERS    
045900        WHEN 'NO-BNCLTR-BIZDAYS'                                  
046000          MOVE C8-DELINQ-VALUE      TO WS-NBR-BIZDAYS             
046100          DISPLAY   '      NBR-BIZ-DAYS: '  WS-NBR-BIZDAYS        
046200        WHEN 'NO-BNCLTR-LTRDAYS'                                  
046300          MOVE C8-DELINQ-VALUE      TO WS-NBR-LTRDAYS             
046400          DISPLAY   '       NBR-LTRDAYS: ' WS-NBR-LTRDAYS         
046500        WHEN 'CD-BNCLTR-COM-TYPE'                                 
046600          MOVE C8-DELINQ-VALUE    TO WS-COMM-TYPE                 
046700          DISPLAY   '         COMM-TYPE: ' WS-COMM-TYPE           
046800        WHEN 'CD-BNCLTR-COM-SUBTYP'                               
046900          MOVE C8-DELINQ-VALUE      TO WS-COMM-SUBTYPE            
047000          DISPLAY   '     COMM-SUB-TYPE: ' WS-COMM-SUBTYPE        
P00532        WHEN 'SW-BNCEML-NO-BLANK'                                 
P00532          MOVE 'N'                  TO WS-EMAIL-BLANK-OUT-SW      
P00532          DISPLAY   '     BLANKING OUT EMAILS TURNED OFF'         
P00532        WHEN 'SW-BNCEML-DOMAIN'                                   
P00532          DISPLAY 'ALL DOMAINS ELIGIBLE FOR EMAIL REMOVAL'        
P00532          MOVE 'Y' TO WS-ALL-DOMAINS-SW                           
P00532        WHEN 'SW-BNCEML-PAPERLESS'                                
P00532             EVALUATE TRUE                                        
P00532                 WHEN C8-DESCRIPTION-TEXT (1:1) = '0'             
P00532                     MOVE 'A' TO WS-PAPERLESS-SW                  
P00532                     DISPLAY 'BLANKING PAPERLESS AND PRINTED'     
P00532                 WHEN C8-DESCRIPTION-TEXT (1:1) = '1'             
P00532                     MOVE 'Y' TO WS-PAPERLESS-SW                  
P00532                     DISPLAY 'BLANKING PAPERLESS ONLY'            
P00532                 WHEN C8-DESCRIPTION-TEXT (1:1) = '2'             
P00532                     MOVE 'P' TO WS-PAPERLESS-SW                  
P00532                     DISPLAY 'BLANKING PRINTED ONLY         '     
P00532             END-EVALUATE                                         
P00532        WHEN 'SW-BNCEML-NOTICE'                                   
P00532             EVALUATE TRUE                                        
P00532                 WHEN C8-DESCRIPTION-TEXT (1:1) = '0'             
P00532                     MOVE 'A' TO WS-NOTICE-SW                     
P00532                     DISPLAY 'PROCESSING PAPERLESS AND PRINTED'   
P00532                 WHEN C8-DESCRIPTION-TEXT (1:1) = '1'             
P00532                     MOVE 'Y' TO WS-NOTICE-SW                     
P00532                     DISPLAY 'PROCESSING PAPERLESS ONLY'          
P00532                 WHEN C8-DESCRIPTION-TEXT (1:1) = '2'             
P00532                     MOVE 'P' TO WS-NOTICE-SW                     
P00532                     DISPLAY 'PROCESSING PRINTED ONLY         '   
P00532             END-EVALUATE                                         
047100        WHEN OTHER                                                
047200          IF C8-DELINQ-CD(1:14) EQUAL 'NO-BNCLTR-MSG-'            
047300             MOVE C8-DELINQ-CD(15:5) TO WS-MESSAGE-NO             
047400             DISPLAY 'MESSAGE-NO: ' WS-MESSAGE-NO                 
047500          END-IF                                                  
P00532          IF C8-DELINQ-CD(1:18) EQUAL 'NO-BNCLTR-SPEC-MSG'        
P00532             MOVE C8-DESCRIPTION-TEXT TO WS-SPECIFIC-DOMAIN-MSG   
P00532             DISPLAY 'DOMAIN SPECIFIC MESSAGE NO: '               
P00532                 WS-SPECIFIC-DOMAIN-MSG                           
P00532          END-IF                                                  
047510          IF C8-DELINQ-CD(1:14) EQUAL 'SW-BNCLTR-INC-'            
047600             MOVE C8-DELINQ-CD(15:5) TO                           
047700                      WS-INCLUDED-EVENT-CD(WS-INCLUDED-INDEX)     
047800             MOVE C8-COMPANY-NO TO                                
047900                      WS-INCLUDED-COMPANY-NO(WS-INCLUDED-INDEX)   
048000             DISPLAY 'INCLUDED EVENT CD:'                         
048100                 WS-INCLUDED-EVENT-CD(WS-INCLUDED-INDEX)          
048200             DISPLAY 'INCLUDED COMPANY NO:'                       
048300                 WS-INCLUDED-COMPANY-NO(WS-INCLUDED-INDEX)        
048400             SET WS-INCLUDED-INDEX UP BY 1                        
P00532          END-IF                                                  
P00532          IF C8-DELINQ-CD(1:12) EQUAL 'EMAIL-DOMAIN'              
P00532             MOVE C8-DESCRIPTION-TEXT   TO                        
P00532                 WS-DOMAIN-TAB-DOM  (WS-DOM-IX)                   
P00532             MOVE C8-DELINQ-VALUE       TO                        
P00532                 WS-DOMAIN-TAB-FLAG(WS-DOM-IX)                    
P00532             DISPLAY 'SELECTING DOMAIN ' WS-DOMAIN-TAB (WS-DOM-IX)
P00532             SET WS-DOM-IX UP BY 1                                
P00532          END-IF                                                  
048600     END-EVALUATE.                                                
P00532     MOVE SPACES TO C8-DESCRIPTION.                               
048700     PERFORM 7210-FETCH-DELINQ-CUR              THRU 7210-EXIT.   
048800                                                                  
048900 1200-EXIT.                                                       
049000      EXIT.                                                       
049100*                                                                         
050800******************************************************************        
050900* 1300-CHECK-RESTART.                                            *        
051000******************************************************************        
051100*                                                                         
051200 1300-CHECK-RESTART.                                              
051300*                                                                         
051400      MOVE WS-PGRMNAME                TO RF-NAME-PROGRAM.         
051500      MOVE 1                          TO RF-PARTITION-NO.         
051600      MOVE 1                          TO RF-DUP-CNTRL-NO.         
051700*                                                                         
051800      PERFORM 7000-SELECT-RESTART     THRU 7000-EXIT.             
051900*                                                                         
052000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
052100         MOVE RF-RESTART-DATA-TEXT    TO WS-RESTART-DATA          
052200         IF WS-RESTART-PROCESS-TYPE NUMERIC                       
052300            MOVE WS-YES            TO WS-IS-THIS-A-RESTART        
052400            DISPLAY   'THIS IS A RESTART'                         
052500         ELSE                                                     
052600            DISPLAY 'THIS IS NORMAL RUN'                          
052700         END-IF                                                   
052800      END-IF.                                                     
052900*                                                                         
053000 1300-EXIT.                                                       
053100      EXIT.                                                       
053200*                                                                         
053300******************************************************************        
053400* 2000-PROCESS-OUTPUT.                                           *        
053500* PROCESS ACCOUNTS TO EMAIL AND PAPER                            *        
053600******************************************************************        
053700 2000-PROCESS-OUTPUT.                                             
054400     PERFORM 7300-OPEN-CANDIDATE-CUR       THRU 7300-EXIT.        
055500     PERFORM 7310-FETCH-CANDIDATE-CUR      THRU 7310-EXIT.        
055600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00532         PERFORM 2200-PROCESS-CANDIDATE THRU 2200-EXIT            
P00532             UNTIL   WS-ACTIVE-RETURN-CODE = NOT-FOUND            
P00532     END-IF                                                       
056000     PERFORM 7320-CLOSE-CANDIDATE-CUR   THRU 7320-EXIT.           
056101     MOVE 'I'                      TO G6-STATUS.                  
056110     MOVE WS-PGRMNAME              TO G6-PROGRAM-NAME.            
056120     MOVE WS-COMPANY-NO            TO G6-COMPANY-NO.              
056130     MOVE WS-DATE                  TO G6-CMND-CODE.               
056140     PERFORM 8400-RESET-JOB-PARM  THRU 8400-EXIT.                 
056300     DISPLAY 'COMPLETED PROCESSING ACCOUNTS'.                     
056700     IF WS-LETTER-COUNTER > WS-MAX-NBR-LETTERS THEN               
056800         MOVE 4 TO RETURN-CODE                                    
056900     END-IF.                                                      
P00532     IF DOMAIN-TABLE-FULL                                         
P00532         MOVE 4 TO RETURN-CODE                                    
056900     END-IF.                                                      
057000 2000-EXIT.                                                       
057100      EXIT.                                                       
057200*                                                                         
059100******************************************************************        
059200* 2200-PROCESS-CANDIDATE                                         *        
059300* PROCESS CANDIDATE CURSOR*                                      *        
059400******************************************************************        
059500 2200-PROCESS-CANDIDATE.                                          
059600                                                                  
P00532     IF AT-CUSTOMER-NO NOT EQUAL WS-PREV-CUSTOMER-NO              
P00599       INITIALIZE WS-CORRESP-COMM-VAR                             
P00599                  WS-TH-APPL-PROGRAM-ID                           
P00599                  WS-TH-TRANS-HIST-FL                             
P00599                  WS-TH-CODE-TRAN-TYPE                            
P00599                  WS-CD-COMM-DATA-FL                              
P00599                  WS-RP-RP000-FL                                  
P00599*                                                                         
P00599       MOVE WS-MESSAGE-NO           TO 1L-CORRESP-MSG-ID          
P00599                                       1J-CORRESP-MSG-ID          
P00599                                       WS-MESSAGE-ID              
P00599       PERFORM 5000-CHECK-LOAD-CORRESP-TBL   THRU 5000-CPD350-EXIT
P00599       MOVE WS-CURR-CORRESP-TYP-CD TO 1J-CORRESP-TYPE-CD          
P00532       UNSTRING NE-EMAIL-ADDRESS-TX-TEXT DELIMITED BY '@'         
P00532          INTO WS-EMAIL WS-DOMAIN                                 
P00532       MOVE  NE-EMAIL-ADDRESS-TX-LEN  TO WS-SAVE-EMAIL-ADDR-LEN   
P00532       IF WS-SAVE-EMAIL-ADDR-LEN > 75                             
P00532           DISPLAY AE-ACCOUNT-NO ' ' AT-CUSTOMER-NO               
P00532           ' EMAIL ' NE-EMAIL-ADDRESS-TX-TEXT ' LENGTH '          
P00532                     NE-EMAIL-ADDRESS-TX-LEN                      
P00532           MOVE +75 TO WS-SAVE-EMAIL-ADDR-LEN                     
P00532                      NE-EMAIL-ADDRESS-TX-LEN                     
P00532       END-IF                                                     
P00532       MOVE  NE-EMAIL-ADDRESS-TX-TEXT TO WS-SAVE-EMAIL-ADDR       
060000       PERFORM  2300-CHECK-EMAIL-EVENT         THRU 2300-EXIT     
060200       IF WS-EMAIL-EVENT = 'Y'                                    
060300         MOVE 'N' TO WS-EMAIL-EVENT                               
060400         MOVE AE-ACCOUNT-NO            TO KO-ACCOUNT-NO           
060500                                          AT-ACCOUNT-NO           
060700         MOVE AT-COMPANY-NO          TO WS-PREV-COMPANY-NO        
P00599         MOVE WS-CURR-COMM-TYP-CD    TO KO-COMM-TYPE-CD           
P00599         MOVE WS-CURR-COMM-SUBTYP-CD TO KO-COMM-SUBTYPE-CODE      
061000         MOVE WS-COMM-METHOD         TO KO-COMM-METHOD            
061100         MOVE WS-COMM-DIRECTION      TO KO-COMM-DIRECTION         
061200         STRING WS-LETTER-DATE DELIMITED BY ' '                   
061300                '-'           DELIMITED BY SIZE                   
061400            '00.00.00.000000' DELIMITED BY ' '                    
061500           INTO KO-COMMUNICATION-ID                               
061600         IF (WS-PROCESSED-DT > WS-LEGACY-END-DT) THEN             
061700           PERFORM 7400-CHK-LTR-SENT-CUR     THRU 7400-EXIT       
061800         ELSE                                                     
061900           PERFORM 7500-CHK-LTR-SENT-OLDCUR  THRU 7500-EXIT       
062000         END-IF                                                   
P00532         IF WS-PREV-LTR-CNTR < 100 THEN                           
P00532           IF PROCESSING-ALL-ACCOUNTS                             
P00532            OR                                                    
P00532             PROCESSING-PAPERLESS-ONLY AND                        
P00532             AT-NO-BILL-COPIES = 0                                
P00532            OR                                                    
P00532             PROCESSING-PRINTED-ONLY   AND                        
P00532             AT-NO-BILL-COPIES > 0                                
P00599              MOVE WS-NO    TO WS-TH-TRANS-HIST-FL                
P00599              MOVE WS-YES   TO WS-CD-COMM-DATA-FL                 
P00599              MOVE WS-YES   TO WS-RP-RP000-FL                     
063500              ADD 1 TO WS-LETTER-COUNTER                          
064210              DISPLAY 'ACCT#SELECTED FOR LETTER:' AE-ACCOUNT-NO   
P00532              IF BLANKING-EMAILS-TURNED-ON                        
P00532                  IF  BLANKING-ALL-ACCOUNTS                       
P00532                    OR                                            
P00532                      BLANKING-PAPERLESS-ONLY AND                 
P00532                      AT-NO-BILL-COPIES = 0                       
P00532                    OR                                            
P00532                      BLANKING-PRINTED-ONLY     AND               
P00532                      AT-NO-BILL-COPIES > 0                       
P00532                         PERFORM 7550-CHECK-TO-ERASE-EMAIL THRU   
P00532                             7550-EXIT                            
P00532                  END-IF                                          
P00532              END-IF                                              
P00532          END-IF                                                  
064300         ELSE                                                     
064400          DISPLAY 'ACCT#:LETTER SENT IN PREV 180 DAYS:'           
064410                                   AE-ACCOUNT-NO                  
064500          MOVE 0 TO WS-PREV-LTR-CNTR                              
064600         END-IF                                                   
064700       ELSE                                                       
064800        DISPLAY 'ACCT# EMAIL EVENT CD EXCLUDED:' AE-ACCOUNT-NO    
064900       END-IF                                                     
065100     END-IF.                                                      
P00599     MOVE AT-LOCAL-OFFICE       TO WS-CWS350-LOCAL-OFFICE.        
P00599     IF AE-ACCOUNT-NO = WS-PREV-ACCOUNT-NO                        
P00599       ADD 1                     TO WS-CORRESP-SEQ-NO             
P00599     ELSE                                                         
P00599       MOVE 0                    TO WS-CORRESP-SEQ-NO             
P00599       MOVE AE-ACCOUNT-NO        TO WS-PREV-ACCOUNT-NO            
P00599     END-IF.                                                      
P00599     IF WS-TH-TRANS-HIST-FL = 'Y' THEN                            
P00599         PERFORM 2400-POPLT-TRAN-DATA  THRU 2400-EXIT             
P00599     END-IF.                                                      
P00599     IF WS-CURR-COMM-INSERT-FL = 'Y' AND                          
P00599        WS-CD-COMM-DATA-FL  = 'Y' THEN                            
P00599        PERFORM 2500-POPLT-COMM-DATA   THRU 2500-EXIT             
P00599     END-IF.                                                      
P00599     IF WS-RP-RP000-FL = 'Y' THEN                                 
P00599        PERFORM 2600-POPLT-FIORP000    THRU 2600-EXIT             
P00599     END-IF.                                                      
P00532     MOVE AT-CUSTOMER-NO TO WS-PREV-CUSTOMER-NO.                  
P00532     MOVE SPACES TO NE-EMAIL-ADDRESS-TX-TEXT WS-DOMAIN WS-EMAIL.  
065200     PERFORM 7310-FETCH-CANDIDATE-CUR      THRU 7310-EXIT.        
065300                                                                  
065400 2200-EXIT.                                                       
065500      EXIT.                                                       
065600*                                                                         
065700******************************************************************        
065800* 2300-CHECK-EMAIL-EVENT                                         *        
065900* SEARCHES EMAIL EVENT CODE IN ARRAY                             *        
066000******************************************************************        
066100 2300-CHECK-EMAIL-EVENT.                                          
066200                                                                  
066300     SET WS-INCLUDED-INDEX            TO 1.                       
066400     SEARCH WS-INCLUDED-EMAIL-EVENTS                              
066500     AT END                                                       
066600           MOVE 'N'                   TO WS-EMAIL-EVENT           
066700     WHEN WS-INCLUDED-EVENT-CD(WS-INCLUDED-INDEX) =               
066800                                         AE-EMAIL-EVENT-CD        
066900     AND WS-INCLUDED-COMPANY-NO (WS-INCLUDED-INDEX)=              
067000                                               AT-COMPANY-NO      
067100           MOVE 'Y'                   TO WS-EMAIL-EVENT           
067200     END-SEARCH.                                                  
067300                                                                  
067400 2300-EXIT.                                                       
067500      EXIT.                                                       
067600*                                                                         
067700******************************************************************        
067800* 2400-POPLT-TRAN-DATA                                           *        
067900* POPULATE TRANSACTION HISTORY FIELDS TO WRITE IN DETAIL REC.    *        
068000******************************************************************        
068100 2400-POPLT-TRAN-DATA.                                            
068400     MOVE WS-PGRMNAME        TO WS-TH-APPL-PROGRAM-ID.            
P00599*                                                                         
057300     IF WS-TH-CODE-TRAN-TYPE = ' '                                
057400                     OR WS-TH-APPL-PROGRAM-ID = ' '               
057500          DISPLAY 'TRANSACTION TYPE OR PROGRAM ID MISSING'        
057600          PERFORM 9900-ABEND               THRU 9900-EXIT         
057700     ELSE                                                         
P00599          MOVE AE-ACCOUNT-NO    TO MH-ACCOUNT-NO                  
P00599*                                                                         
P00599          MOVE WS-DFLT-USER-ID TO MH-USER-ID                      
P00599          MOVE WS-DFLT-RESP-AREA-ID TO MH-RESP-AREA-ID            
P00599*                                                                         
P00599          MOVE 0 TO MH-TRAN-COMMENT-LEN                           
P00599*                                                                         
P00599          MOVE 0 TO MH-ENTITY-KEY-DESC-LEN                        
P00599*                                                                         
P00599          PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT       
P00599     END-IF.                                                      
P00599*                                                                         
068700 2400-EXIT.                                                       
068800      EXIT.                                                       
068900*                                                                         
069000******************************************************************        
069100* 2500-POPLT-COMM-DATA                                           *        
069200* POPULATE COMMUNICATION FIELDS TO WRITE IN DETAIL REC.          *        
069300******************************************************************        
069400 2500-POPLT-COMM-DATA.                                            
P00599     IF KO-COMM-METHOD = ' '                                      
P00599         OR KO-COMM-DIRECTION = ' '                               
P00599         OR KO-COMM-TYPE-CD = '  '                                
P00599         OR KO-COMM-SUBTYPE-CODE = '  '                           
063200     THEN                                                         
063300          DISPLAY 'COMMUNICATION DETAILS ARE MISSING'             
063400          PERFORM 9900-ABEND               THRU 9900-EXIT         
063500     ELSE                                                         
      *                                                                         
063700       PERFORM 7010-SELECT-TIMESTAMP   THRU 7010-EXIT             
063800*                                                                       00
063900       MOVE                  0         TO WS-NULL-IND-1           
064000       MOVE                  0         TO WS-NULL-IND-2           
064100       MOVE WS-CURRENT-TIMESTAMP       TO KO-COMMUNICATION-ID     
064200       MOVE AE-ACCOUNT-NO              TO KO-ACCOUNT-NO           
064300       MOVE AT-CUSTOMER-NO             TO KO-CUSTOMER-NO          
064400       MOVE AT-PREMISE-NO              TO KO-PREMISE-NO           
064500       MOVE AT-COMPANY-NO              TO KO-COMPANY-NO           
P00599*                                                                       00
065000       MOVE 'N'                        TO KO-RED-FLAG-IND         
065200*                                                                       00
065400       INITIALIZE                         KO-RED-FLAG-EXPIRE-DT   
065600       MOVE                    -1      TO WS-NULL-IND-1           
065800*                                                                       00
A03866       MOVE WS-MESSAGE-NO              TO KO-PROMOTION-ID         
066300       MOVE 'SYSTEM'                   TO KO-USER-ID-ORIG         
066400       MOVE SPACES                     TO KO-CONTACT-NAME         
066600       MOVE 'BOUNCED EMAIL LETTER SENT'                           
066700                                  TO KO-INITIAL-COMMENT-TX-TEXT   
066800       MOVE 26                                                    
066900                                  TO KO-INITIAL-COMMENT-TX-LEN    
067000       MOVE 'N'                        TO KO-PSC-COMPLIANCE-IND   
067100       MOVE 0                          TO KO-CALL-ORIGIN-ID       
067200       MOVE SPACES                     TO KO-CALL-END-TIME        
067300       MOVE  -1                        TO WS-NULL-IND-2           
067400       MOVE 0                          TO KO-NUMBER-TRANSFERS     
067500       MOVE 0                          TO KO-HOLD-TIME            
067600       MOVE 0                          TO KO-QUEUE-TIME           
067700       MOVE 'N'                        TO KO-SCREEN-POP-IND       
067800       MOVE 0                          TO KO-TOTAL-CALL-TIME      
067900       MOVE SPACES                     TO KO-RESPONSE-REASON-CD   
068000       MOVE SPACES                     TO KO-RESPONSE-TYPE-CD     
068100       MOVE SPACES                     TO KO-SOLICITATION-CD      
068200       MOVE 'A'                        TO KO-COMM-ASSOC-CD        
068300       MOVE 'N'                        TO KO-COMPLAINT-FL         
068400       MOVE SPACES                     TO KO-DISCOVERY-MTHD-CD    
068500       MOVE SPACES                     TO KO-PREV-MARKETER-CD     
A03866                                                                  
068600*                                                                       00
068700       PERFORM   8200-INSRT-COMM-DATA      THRU 8200-EXIT         
068800*                                                                       00
068900     END-IF.                                                      
069000*                                                                       00
070900 2500-EXIT.                                                       
071000      EXIT.                                                       
071100*                                                                         
071200******************************************************************        
071300* 2600-POPLT-FIORP000                                            *        
071400* POPULATE FIORP000 FIELDS BEFORE WRITING DETAIL REC.            *        
071500******************************************************************        
071600 2600-POPLT-FIORP000.                                             
071700                                                                  
070900*                                                                       00
070301     MOVE AE-ACCOUNT-NO           TO LR-ACCOUNT-NO.               
070302     PERFORM 7680-GET-ACCT-REG-PROFILE THRU 7680-EXIT.            
P00599*                                                                         
P00599     MOVE AE-ACCOUNT-NO          TO 1J-ACCOUNT-NO.                
P00599     MOVE AT-COMPANY-NO          TO 1J-CORRESP-COMPANY-NO         
P00599                                    1L-COMPANY-NO.                
P00599     MOVE AT-CUSTOMER-NO         TO 1J-CUSTOMER-NO.               
P00599     MOVE LR-REG-GROUP-CD        TO 1J-REG-GROUP-CD.              
P00599     MOVE 'I'                    TO 1J-CORRESP-STATUS-CD.         
P00599     MOVE ZEROES                 TO 1J-GUARNTR-ACCT-NO            
P00599                                    1J-THD-PRTY-ID.               
P00599     MOVE SPACES                 TO 1J-BARCODE-UNIQUE-ID.         
P00599     IF THE-EMAIL-IS-TO-BE-ERASED                                 
P00599         MOVE WS-SPECIFIC-DOMAIN-MSG        TO 1J-CORRESP-MSG-ID  
                                                     1L-CORRESP-MSG-ID  
P00599       ELSE                                                       
P00599         MOVE WS-MESSAGE-NO                 TO 1J-CORRESP-MSG-ID  
                                                     1L-CORRESP-MSG-ID  
P00599     END-IF.                                                      
P00599     MOVE WS-PGRMNAME            TO 1J-CREATED-BY-PGM-ID          
P00599                                   1J-LAST-UPDATE-PGM-ID.         
P00599     MOVE WS-RUN-DATE            TO 1J-CORRESP-STMT-DT            
P00599                                    1L-EFF-TO-DT.                 
P00599     MOVE SPACES                 TO WS-CORRESP-ID-FND             
P00599     MOVE WS-CURR-CORRESP-TYP-CD TO 1J-CORRESP-TYPE-CD.           
P00599     MOVE WS-CORRESP-SEQ-NO      TO 1J-CORRESP-SEQ-NO.            
P00599                                                                  
P00599     PERFORM 5425-GET-CORRESP-ID-VAL       THRU 5425-CPD350-EXIT. 
073100                                                                  
073200 2600-EXIT.                                                       
073300      EXIT.                                                       
073400*                                                                         
P00599******************************************************************        
P00599* 5000-CHECK-LOAD-CORRESP-TBL.                                   *        
P00599******************************************************************        
P00599*                                                                         
P00599      EXEC SQL                                                            
P00599           INCLUDE CPD00350                                               
P00599      END-EXEC.                                                           
P00599*                                                                         
073500******************************************************************        
073600* 6240-GET-FCA00-COMMON-DATE                                     *        
073700* COPYBOOK CONTAINING DATE PARAMETER RETRIEVAL LOGIC             *        
073800******************************************************************        
073900                                                                  
074000     COPY CPD00040.                                                       
074100                                                                  
074200*                                                                         
074300******************************************************************        
074400* 6251-GET-FJC01-DATE                                            *        
074500* COPYBOOK CONTAINING DATE PARAMETER RETRIEVAL LOGIC             *        
074600******************************************************************        
074700                                                                  
074800     COPY CPD00037.                                                       
074900                                                                  
075000******************************************************************        
075100* 6253-GET-FJC01-CHKP-LIMIT                                      *        
075200* COPYBOOK CONTAINING PARM DATA READ LOGIC                       *        
075300******************************************************************        
075400                                                                  
075500     COPY CPD00034.                                                       
075600                                                                  
075700**************************************************************            
075800* 6525-PREV-BUSINESS-DAY                                     *            
075900* COPYBOOK CONTAINING PREVIOUS BUSINESS DAY LOGIC            *            
076000**************************************************************            
076100                                                                  
076200     EXEC SQL                                                             
076300         INCLUDE CPD00315                                                 
076400     END-EXEC.                                                            
076500                                                                  
076600*                                                                         
P00532**************************************************************            
P00532* 6530-LOAD-MNT-TRANS-HIST                                   *            
P00532* COPYBOOK CONTAINING TRANSACTION HISTORY LOGIC              *            
P00532**************************************************************            
P00532                                                                  
P00532     EXEC SQL                                                             
P00532         INCLUDE CPD00067                                                 
P00532     END-EXEC.                                                            
P00532                                                                  
076600*                                                                         
076700******************************************************************        
076800* 7000-SELECT-RESTART                                            *        
076900* GET RESTART DATA                                               *        
077000******************************************************************        
077100 7000-SELECT-RESTART.                                             
077200                                                                  
077300      EXEC SQL                                                    
077400       SELECT                                                     
077500         RF.RESTART_DATA                                          
077600       INTO :RF-RESTART-DATA                                      
077700       FROM CSS_RESTART RF WITH(READUNCOMMITTED)                          
077800       WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                   
077900         AND RF.PARTITION_NO = :RF-PARTITION-NO                   
078000         AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
078100                                                           
078200                                                      
078300      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*      SELECT                                                             
MFA-TR*        RF.RESTART_DATA                                                  
MFA-TR*      INTO :RF-RESTART-DATA                                              
MFA-TR*      FROM CSS_RESTART RF                                                
MFA-TR*      WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                           
MFA-TR*        AND RF.PARTITION_NO = :RF-PARTITION-NO                           
MFA-TR*        AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

078400                                                                  
078500      MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
078600                                                                  
078700      IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
078800         OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
078900         CONTINUE                                                 
079000      ELSE                                                        
079100         DISPLAY '********** PCSAC200  ABORT **************'      
079200         DISPLAY '* 7000-SELECT-RESTART                   '       
079300         DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE   
079400         DISPLAY '* PROCESSED DATE      ' WS-PROCESSED-DT         
079500         DISPLAY '* PROGRAM ABORTING...                   *'      
079600         DISPLAY '********** PCSAC200  ABORT **************'      
079700         PERFORM 9900-ABEND                     THRU 9900-EXIT    
079800      END-IF.                                                     
079900                                                                  
080000 7000-EXIT.                                                       
080100      EXIT.                                                       
080200*                                                                         
P00599******************************************************************      00
P00599* 7010-SELECT-TIMESTAMP                                          *      00
P00599* SELECT CURRENT TIMESTAMP                                       *      00
P00599******************************************************************      00
P00599 7010-SELECT-TIMESTAMP.                                           
P00599*                                                                       00
P00599     EXEC SQL                                                     
P00599        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                  
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                           00
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   00
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                        00
MFA-TR*    END-EXEC.                                                          00

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599                                                                  
P00599     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00599                                                                  
P00599     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00599         CONTINUE                                                 
P00599     ELSE                                                         
P00599         DISPLAY '********** PCSAC200  ABORT **************'      
P00599         DISPLAY '* 7010-SELECT-TIMESTAMP                 *'      
P00599         DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE   
P00599         DISPLAY '* PROGRAM ABORTING...                   *'      
P00599         DISPLAY '********** PCSAC201  ABORT **************'      
P00599         PERFORM 9900-ABEND                     THRU 9900-EXIT    
P00599     END-IF.                                                      
P00599*                                                                       00
P00599 7010-EXIT.                                                       
P00599      EXIT.                                                       
P00599*                                                                       00
080300******************************************************************        
080400* 7100-GET-LETTER-DATE                                           *        
080500* GET LETTER DATE                                                *        
080600******************************************************************        
080700 7100-GET-LETTER-DATE.                                            
080800                                                                  
080900      EXEC SQL                                                    
080910        SELECT
              DATEADD( DAY, -:WS-NBR-LTRDAYS, IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROCESSED-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESSED-DT
              ) <> 0) OR (LEN(:WS-PROCESSED-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESSED-DT
              ), CONVERT(DATE, :WS-PROCESSED-DT) ) )
            INTO
              :WS-LETTER-DATE       
081200      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SET :WS-LETTER-DATE = DATE(:WS-PROCESSED-DT)                      
MFA-TR*                                    - :WS-NBR-LTRDAYS DAYS               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

081300                                                                  
081400      MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
081500                                                                  
081600      IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
081700         CONTINUE                                                 
081800      ELSE                                                        
081900         DISPLAY '********** PCSAC200  ABORT **************'      
082000         DISPLAY '* 7100-GET-LETTER-DATE                  *'      
082100         DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE   
082200         DISPLAY '* PROCESSED DATE      ' WS-PROCESSED-DT         
082300         DISPLAY '* PROGRAM ABORTING...                   *'      
082400         DISPLAY '********** PCSAC200  ABORT **************'      
082500         PERFORM 9900-ABEND                     THRU 9900-EXIT    
082600      END-IF.                                                     
082700                                                                  
082800  7100-EXIT.                                                      
082900      EXIT.                                                       
083000*                                                                         
083100***************************************************************** *       
083200* 7200-OPEN-DELINQ-CUR.                                           *       
083300* OPEN CURSOR                                                     *       
083400***************************************************************** *       
083500 7200-OPEN-DELINQ-CUR.                                            
083600                                                                  
083700       EXEC SQL                                                   
083800        OPEN DELINQ_CURSOR                                        
083900       END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

084000                                                                  
084100       MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE. 
084200                                                                  
084300       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
084400          CONTINUE                                                
084500       ELSE                                                       
084600        DISPLAY '********** PCSAC200 ABORT **************'        
084700        DISPLAY '*    7200-OPEN-DELINQ-CUR              *'        
084800        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
084900        DISPLAY '* PROGRAM ABORTING...                  *'        
085000        DISPLAY '********** PCSAC200 ABORT **************'        
085100        PERFORM 9900-ABEND                      THRU 9900-EXIT    
085200       END-IF.                                                    
085300                                                                  
085400 7200-EXIT.                                                       
085500      EXIT.                                                       
085600*                                                                         
085700******************************************************************        
085800* 7210-FETCH-DELINQ-CUR.                                         *        
085900* FETCH CURSOR                                                   *        
086000******************************************************************        
086100 7210-FETCH-DELINQ-CUR.                                           
086200                                                                  
086300     EXEC SQL                                                     
086400        FETCH DELINQ_CURSOR                                       
086500         INTO :C8-COMPANY-NO                                      
086600             ,:C8-DELINQ-CD                                       
086700             ,:C8-DELINQ-VALUE                                    
086700             ,:C8-DESCRIPTION                                     
086800     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

086900                                                                  
087000     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
087100                                                                  
087200     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
087300        CONTINUE                                                  
087400     ELSE                                                         
087500        DISPLAY '********** PCSAC200 ABORT **************'        
087600        DISPLAY '*    7210-FETCH-DELINQ-CUR             *'        
087700        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
087800        DISPLAY '* PROGRAM ABORTING...                  *'        
087900        DISPLAY '********** PCSAC200 ABORT **************'        
088000        PERFORM 9900-ABEND                      THRU 9900-EXIT    
088100     END-IF.                                                      
088200                                                                  
088300 7210-EXIT.                                                       
088400      EXIT.                                                       
088500*                                                                         
088600******************************************************************        
088700* 7220-CLOSE-DELINQ-CUR.                                         *        
088800* CLOSE CURSOR                                                   *        
088900******************************************************************        
089000 7220-CLOSE-DELINQ-CUR.                                           
089100                                                                  
089200     EXEC SQL                                                     
089300        CLOSE DELINQ_CURSOR                                       
089400     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

089500                                                                  
089600     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
089700                                                                  
089800     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
089900        CONTINUE                                                  
090000     ELSE                                                         
090100        DISPLAY '********** PCSAC200 ABORT **************'        
090200        DISPLAY '*    7220-CLOSE-DELINQ-CUR             *'        
090300        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
090400        DISPLAY '* PROGRAM ABORTING...                  *'        
090500        DISPLAY '********** PCSAC200 ABORT **************'        
090600        PERFORM 9900-ABEND                      THRU 9900-EXIT    
090700     END-IF.                                                      
090800                                                                  
090900 7220-EXIT.                                                       
091000      EXIT.                                                       
091100*                                                                         
P00599******************************************************************        
P00599* 7250-SELECT-DELINQ-VALUE                                       *        
P00599* SELECTS THE DELINQUENCY VALUE FOR THE GIVEN DELINQ CODE        *        
P00599******************************************************************        
P00599 7250-SELECT-DELINQ-VALUE.                                        
P00599*                                                                         
P00599     EXEC SQL                                                     
P00599        SELECT DELINQ_VALUE                                       
P00599          INTO :C8-DELINQ-VALUE                                   
P00599          FROM CSS_DELINQUENCY                                    
P00599         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
P00599           AND COMPANY_NO = :C8-COMPANY-NO                        
P00599                                                      
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                         
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        DISPLAY '********** PCSCA200 ABORT **************'        
P00599        DISPLAY '* 7250-SELECT-DELINQ-VALUE             *'        
P00599        DISPLAY '* DELINQ CD ', C8-DELINQ-CD                      
P00599        DISPLAY '* COMPANY NO', C8-COMPANY-NO                     
P00599        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00599        DISPLAY '* PROGRAM ABORTING...                  *'        
P00599        DISPLAY '********** PCSAC200 ABORT **************'        
P00599        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00599     END-IF.                                                      
P00599*                                                                         
P00599 7250-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                         
091200******************************************************************        
091300* 7300-OPEN-CANDIDATE-CUR                                        *        
091400* OPEN CANDIDATE CURSOR                                          *        
091500******************************************************************        
091600 7300-OPEN-CANDIDATE-CUR.                                         
091700                                                                  
091800     EXEC SQL                                                     
091900        OPEN CANDIDATE_ACCT                                       
092000     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

092100                                                                  
092200     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
092300                                                                  
092400     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
092500        CONTINUE                                                  
092600     ELSE                                                         
092700        DISPLAY '********** PCSAC200 ABORT **************'        
092800        DISPLAY '*    7300-OPEN-CANDIDATE-CUR           *'        
092900        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
093000        DISPLAY '* PROCESSED_DT ' WS-PROCESSED-DT                 
093200        DISPLAY '* PROGRAM ABORTING...                  *'        
093300        DISPLAY '********** PCSAC200 ABORT **************'        
093400        PERFORM 9900-ABEND                      THRU 9900-EXIT    
093500     END-IF.                                                      
093600                                                                  
093700 7300-EXIT.                                                       
093800      EXIT.                                                       
093900*                                                                         
094000******************************************************************        
094100* 7310-FETCH-CANDIDATE-CUR                                       *        
094200* FETCH CANDIDATE CURSOR                                         *        
094300******************************************************************        
094400 7310-FETCH-CANDIDATE-CUR.                                        
094500                                                                  
094600     EXEC SQL                                                     
094700        FETCH CANDIDATE_ACCT                                      
094800         INTO :AE-ACCOUNT-NO                                      
094900             ,:AT-CUSTOMER-NO                                     
095000             ,:AT-COMPANY-NO                                      
P00532             ,:AT-NO-BILL-COPIES                                  
P00599             ,:AT-PREMISE-NO                                      
P00599             ,:AT-ADDRESS-ID                                      
P00599             ,:AT-ADDRESS-FORMAT                                  
P00599             ,:AT-LOCAL-OFFICE                                    
P00599             ,:CU-NAME-ID                                         
095100             ,:AE-EMAIL-EVENT-CD                                  
095100             ,:NE-EMAIL-ADDRESS-TX                                
095200     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

095300                                                                  
095400     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
095500                                                                  
095600     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
095700        CONTINUE                                                  
095800     ELSE                                                         
095900        DISPLAY '********** PCSAC200 ABORT **************'        
096000        DISPLAY '*    7310-FETCH-CANDIDATE-CUR          *'        
096100        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
096200        DISPLAY '* PROCESSED_DT BETWEEN ' WS-FROM-DATE            
096300        DISPLAY '*                  AND ' WS-PROCESSED-DT         
096400        DISPLAY '* PROGRAM ABORTING...                  *'        
096500        DISPLAY '********** PCSAC200 ABORT **************'        
096600        PERFORM 9900-ABEND                      THRU 9900-EXIT    
096700     END-IF.                                                      
096800                                                                  
096900 7310-EXIT.                                                       
097000      EXIT.                                                       
097100*                                                                         
097200******************************************************************        
097300* 7320-CLOSE-CANDIDATE-CUR                                       *        
097400* CLOSE CANDIDATE CURSOR                                         *        
097500******************************************************************        
097600 7320-CLOSE-CANDIDATE-CUR.                                        
097700                                                                  
097800     EXEC SQL                                                     
097900        CLOSE CANDIDATE_ACCT                                      
098000     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

098100                                                                  
098200     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
098300                                                                  
098400     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
098500        CONTINUE                                                  
098600     ELSE                                                         
098700        DISPLAY '********** PCSAC200 ABORT **************'        
098800        DISPLAY '*    7320-CLOSE-CANDIDATE-CUR          *'        
098900        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
099000        DISPLAY '* PROCESSED_DT BETWEEN ' WS-FROM-DATE            
099100        DISPLAY '*                  AND ' WS-PROCESSED-DT         
099200        DISPLAY '* PROGRAM ABORTING...                  *'        
099300        DISPLAY '********** PCSAC200 ABORT **************'        
099400        PERFORM 9900-ABEND                      THRU 9900-EXIT    
099500     END-IF.                                                      
099600                                                                  
099700 7320-EXIT.                                                       
099800      EXIT.                                                       
099900*                                                                         
100000*                                                                         
100100******************************************************************        
100200* 7400-CHK-LTR-SENT-CUR                                          *        
100300* SELECT NUMBER OF LETTERS SENT WITH REGARDS TO BOUNCED EMAIL ID *        
100400******************************************************************        
100500 7400-CHK-LTR-SENT-CUR.                                           
100600*                                                                         
100700     EXEC SQL                                                     
100800     SELECT COUNT(1)                                              
100900     INTO :WS-PREV-LTR-CNTR                                       
101000       FROM CSS_COMM_DATA KO                                      
101100      WHERE KO.ACCOUNT_NO = :KO-ACCOUNT-NO                        
101200        AND KO.COMMUNICATION_ID > CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )            
101300        AND KO.COMM_METHOD = :KO-COMM-METHOD                      
101400        AND KO.COMM_DIRECTION = :KO-COMM-DIRECTION                
101500        AND KO.COMM_TYPE_CD = :KO-COMM-TYPE-CD                    
101600        AND KO.COMM_SUBTYPE_CODE = :KO-COMM-SUBTYPE-CODE          
ACT058                                                      
101700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT COUNT(1)                                                      
MFA-TR*    INTO :WS-PREV-LTR-CNTR                                               
MFA-TR*      FROM CSS_COMM_DATA KO                                              
MFA-TR*     WHERE KO.ACCOUNT_NO = :KO-ACCOUNT-NO                                
MFA-TR*       AND KO.COMMUNICATION_ID > :KO-COMMUNICATION-ID                    
MFA-TR*       AND KO.COMM_METHOD = :KO-COMM-METHOD                              
MFA-TR*       AND KO.COMM_DIRECTION = :KO-COMM-DIRECTION                        
MFA-TR*       AND KO.COMM_TYPE_CD = :KO-COMM-TYPE-CD                            
MFA-TR*       AND KO.COMM_SUBTYPE_CODE = :KO-COMM-SUBTYPE-CODE                  
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

101800                                                                  
101900     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
102000                                                                  
102100     IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
102200         OR                                                       
102300         WS-ACTIVE-RETURN-CODE = NOT-FOUND)                       
102400         CONTINUE                                                 
102500     ELSE                                                         
102600         DISPLAY '********** PCSAC200  ABORT **************'      
102700         DISPLAY '* 7400-CHK-LTR-SENT-CUR                 *'      
102800         DISPLAY '* SQLCODE IS      : ' WS-ACTIVE-RETURN-CODE     
102810         DISPLAY 'ACCOUNT NO        : ' KO-ACCOUNT-NO             
102820         DISPLAY 'COMMUNICATION ID  : ' KO-COMMUNICATION-ID       
102830         DISPLAY 'COMM METHOD       : ' KO-COMM-METHOD            
102840         DISPLAY 'COMM DIRECTION    : ' KO-COMM-DIRECTION         
102850         DISPLAY 'COMM TYPE CD      : ' KO-COMM-TYPE-CD           
102860         DISPLAY 'COMM SUB TYPE CODE: ' KO-COMM-SUBTYPE-CODE      
102900         DISPLAY '* PROGRAM ABORTING...                   *'      
103000         DISPLAY '********** PCSAC200  ABORT **************'      
103100         PERFORM 9900-ABEND                     THRU 9900-EXIT    
103200     END-IF.                                                      
103300                                                                  
103400 7400-EXIT.                                                       
103500      EXIT.                                                       
103600*                                                                         
103700******************************************************************        
103800* 7500-CHK-LTR-SENT-OLDCUR                                       *        
103900* SELECT NUMBER OF LETTERS SENT WITH REGARDS TO BOUNCED EMAIL ID *        
104000******************************************************************        
104100 7500-CHK-LTR-SENT-OLDCUR.                                        
104200*                                                                         
104300     EXEC SQL                                                     
104400     SELECT COUNT(1)                                              
104500     INTO :WS-PREV-LTR-CNTR                                       
104600       FROM CSS_COMM_DATA KO                                      
104800      WHERE KO.ACCOUNT_NO = :KO-ACCOUNT-NO                        
104900        AND KO.COMMUNICATION_ID > CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )            
105000        AND KO.COMM_METHOD = :KO-COMM-METHOD                      
105100        AND KO.COMM_DIRECTION = :KO-COMM-DIRECTION                
ACT058        AND ( (KO.COMM_TYPE_CD      = :KO-COMM-TYPE-CD      AND   
ACT058               KO.COMM_SUBTYPE_CODE = :KO-COMM-SUBTYPE-CODE )     
ACT058                                   OR                             
ACT058              (KO.COMM_TYPE_CD      = '06'             AND        
ACT058               KO.COMM_SUBTYPE_CODE = '42'             AND        
ACT058               EXISTS                                             
ACT058                 (SELECT 1                                        
ACT058                    FROM CSS_USER_PROFILE PF                      
ACT058                   WHERE PF.USER_ID       = KO.USER_ID_ORIG       
ACT058                     AND PF.RESP_AREA_ID IN ('420','637') ) ) )   
ACT058                                                      
105800     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT COUNT(1)                                                      
MFA-TR*    INTO :WS-PREV-LTR-CNTR                                               
MFA-TR*      FROM CSS_COMM_DATA KO                                              
MFA-TR*     WHERE KO.ACCOUNT_NO = :KO-ACCOUNT-NO                                
MFA-TR*       AND KO.COMMUNICATION_ID > :KO-COMMUNICATION-ID                    
MFA-TR*       AND KO.COMM_METHOD = :KO-COMM-METHOD                              
MFA-TR*       AND KO.COMM_DIRECTION = :KO-COMM-DIRECTION                        
MFA-TR*       AND ( (KO.COMM_TYPE_CD      = :KO-COMM-TYPE-CD      AND           
MFA-TR*              KO.COMM_SUBTYPE_CODE = :KO-COMM-SUBTYPE-CODE )             
MFA-TR*                                  OR                                     
MFA-TR*             (KO.COMM_TYPE_CD      = '06'             AND                
MFA-TR*              KO.COMM_SUBTYPE_CODE = '42'             AND                
MFA-TR*              EXISTS                                                     
MFA-TR*                (SELECT 1                                                
MFA-TR*                   FROM CSS_USER_PROFILE PF                              
MFA-TR*                  WHERE PF.USER_ID       = KO.USER_ID_ORIG               
MFA-TR*                    AND PF.RESP_AREA_ID IN ('420','637') ) ) )           
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

105900                                                                  
106000     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
106100                                                                  
106200     IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
106300         OR                                                       
106400         WS-ACTIVE-RETURN-CODE = NOT-FOUND)                       
106500         CONTINUE                                                 
106600     ELSE                                                         
106700         DISPLAY '********** PCSAC200  ABORT **************'      
106800         DISPLAY '* 7500-CHK-LTR-SENT-OLDCUR              *'      
106900         DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE   
106910         DISPLAY 'ACCOUNT NO        : ' KO-ACCOUNT-NO             
106920         DISPLAY 'COMMUNICATION ID  : ' KO-COMMUNICATION-ID       
106930         DISPLAY 'COMM METHOD       : ' KO-COMM-METHOD            
106940         DISPLAY 'COMM DIRECTION    : ' KO-COMM-DIRECTION         
106950         DISPLAY 'COMM TYPE CD      : ' KO-COMM-TYPE-CD           
106960         DISPLAY 'COMM SUB TYPE CODE: ' KO-COMM-SUBTYPE-CODE      
106970         DISPLAY 'USER ID           : ' KO-USER-ID-ORIG           
107000         DISPLAY '* PROGRAM ABORTING...                   *'      
107100         DISPLAY '********** PCSAC200  ABORT **************'      
107200         PERFORM 9900-ABEND                     THRU 9900-EXIT    
107300     END-IF.                                                      
107400                                                                  
107500 7500-EXIT.                                                       
107600      EXIT.                                                       
P00532*                                                                         
P00532 7550-CHECK-TO-ERASE-EMAIL.                                       
P00532**************************************************************            
P00532* DELETE THE EMAIL IF:                                       *            
P00532* A) THE FLAG HAS BEEN SET TO PROCESS ALL EMAILS AND IT IS   *            
P00532*    EITHER NOT PRESENT IN THE TABLE, OR IS IN THE TABLE, BUT*            
P00532*    FLAGGED AS AN 'INCLUDE'                                 *            
P00532*     ==OR==                                                 *            
P00532* B) WE ARE DELETING SPECIFIC DOMAINS AND IT IS FLAGGED IN   *            
P00532*    THE TABLE AS AN 'INCLUDE'                               *            
P00532* DO NOT DELETE THE EMAIL IF:                                *            
P00532* A) THE FLAG HAS BEEN SET TO PROCESS ALL EMAILS   AND       *            
P00532*    IT IS FLAGGED IN THE TABLE AS AN 'EXCLUDE'              *            
P00532*     ==OR==                                                 *            
P00532* B) WE ARE DELETING SPECIFIC DOMAINS AND THE DOMAIN IS NOT  *            
P00532*    IN THE TABLE OR IS IN THE TABLE, BUT FLAGGED AS AN      *            
P00532*    EXCLUDE.                                                *            
P00532**************************************************************            
P00532     SET WS-DOM-IX TO 1.                                          
P00532     MOVE 'N' TO WS-DELETE-EMAIL-SW.                              
P00532     MOVE 'N' TO WS-DOMAIN-ON-DELINQ.                             
P00532     MOVE 'N' TO WS-SPECIAL-BOUNCE-NOTICE.                        
P00532     SEARCH WS-DOMAIN-TAB                                         
P00532        WHEN WS-DOMAIN-TAB-DOM (WS-DOM-IX) =     SPACES           
P00532            CONTINUE                                              
P00532        WHEN WS-DOMAIN-TAB-DOM (WS-DOM-IX) = WS-DOMAIN            
P00532            MOVE 'Y' TO WS-DOMAIN-ON-DELINQ.                      
P00532     IF SELECTING-SPECIFIC-DOMAINS    AND                         
P00532         THE-DOMAIN-WAS-ON-THE-TABLE  AND                         
P00532         WS-DOMAIN-TAB-FLAG (WS-DOM-IX) = 0                       
P00532             MOVE 'Y' TO WS-SPECIAL-BOUNCE-NOTICE                 
P00532             MOVE 'Y' TO WS-DELETE-EMAIL-SW                       
P00532       ELSE                                                       
P00532         IF SELECTING-ALL-DOMAINS AND                             
P00532             (THE-DOMAIN-WAS-NOT-ON-TABLE OR                      
P00532              THE-DOMAIN-WAS-ON-THE-TABLE AND                     
P00532              WS-DOMAIN-TAB-FLAG (WS-DOM-IX) = 0)                 
P00532                  MOVE 'Y' TO WS-DELETE-EMAIL-SW                  
P00532         END-IF                                                   
P00532     END-IF.                                                      
P00532     IF THE-EMAIL-IS-TO-BE-ERASED                                 
P00532         MOVE 1   TO NE-EMAIL-ADDRESS-TX-LEN                      
P00532         MOVE ' ' TO NE-EMAIL-ADDRESS-TX-TEXT                     
P00532         PERFORM 7555-BLANK-EMAIL                                 
P00532         PERFORM 7560-LOAD-TRANS-HIST THRU 7560-EXIT              
P00532     END-IF.                                                      
P00532 7550-EXIT.                                                       
P00532     EXIT.                                                        
108300                                                                  
P00532 7555-BLANK-EMAIL.                                                
P00532     EXEC SQL                                                     
P00532         UPDATE CSS_CUST_EMAIL                                    
P00532         SET EMAIL_ADDRESS_TX = ' '                               
P00532         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
P00532     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00532     IF SQLCODE NOT = 0                                           
P00532         DISPLAY '********** PCSAC200  ABORT **************'      
P00532         DISPLAY '* 7555-BLANK-EMAIL                      *'      
P00532         DISPLAY '* SQLCODE IS        : ' SQLCODE                 
P00532         DISPLAY 'ACCOUNT NO        : ' KO-ACCOUNT-NO             
P00532         DISPLAY 'CUSTOMER NO       : ' AT-CUSTOMER-NO            
P00532         PERFORM 9900-ABEND                     THRU 9900-EXIT    
P00532     END-IF.                                                      
P00532 7555-EXIT.                                                       
P00532     EXIT.                                                        
108300                                                                  
P00532 7560-LOAD-TRANS-HIST.                                            
P00532     MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
P00532     MOVE AT-CUSTOMER-NO            TO MH-CUSTOMER-NO.            
P00532     MOVE ZERO                      TO MH-PREMISE-NO              
P00532                                       MH-ACCOUNT-NO              
P00532                                       MH-ENTITY-KEY-DESC-LEN.    
P00532     MOVE 'SYSTEM'                  TO MH-USER-ID.                
P00532     MOVE 'PCSAC200'                TO MH-APPL-PROGRAM-ID.        
P00532     MOVE SPACES                    TO MH-RESP-AREA-ID.           
P00532     MOVE +25                       TO MH-TRAN-COMMENT-LEN.       
P00532     MOVE 'EMAIL ADDRESS BLANKED OUT'                             
P00532                                    TO MH-TRAN-COMMENT-TEXT.      
P00532     MOVE +1                        TO MI-TRAN-APPL-NO.           
P00532     MOVE SPACES                    TO MI-TABLE-ID.               
P00532     MOVE 'CUSTOMER EMAIL'          TO MI-COLUMN-DESC.            
P00532     MOVE 1                         TO MI-CHG-COLUMN-VALUE-LEN.   
P00532     MOVE WS-SAVE-EMAIL-ADDR-LEN    TO MI-PRV-COLUMN-VALUE-LEN.   
P00532     MOVE WS-SAVE-EMAIL-ADDR        TO MI-PRV-COLUMN-VALUE-TEXT.  
P00532     PERFORM 7570-GET-TIMESTAMP THRU 7570-EXIT.                   
P00532     MOVE WS-TIMESTAMP              TO MH-TRANS-HIST-SEQ-NO       
P00532                                       MI-TRANS-HIST-SEQ-NO       
P00532                                       MH-DATE-TRANS.             
P00532     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
P00532     EVALUATE SQLCODE                                             
P00532         WHEN 0                                                   
P00532             CONTINUE                                             
P00532         WHEN -803                                                
P00532             DISPLAY 'PCSAC200 DUPLICATE TIMESTAMP ON TRANS HIST,'
P00532                     ' ATTEMPTING SECOND TRY'                     
P00532             PERFORM 7570-GET-TIMESTAMP   THRU 7570-EXIT          
P00532             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
P00532             IF SQLCODE NOT = 0                                   
P00532                 PERFORM 9900-ABEND THRU 9900-EXIT                
P00532             END-IF                                               
P00532         WHEN OTHER                                               
P00532                 PERFORM 9900-ABEND THRU 9900-EXIT                
P00532     END-EVALUATE.                                                
P00532 7560-EXIT.                                                       
P00532     EXIT.                                                        
P00532                                                                  
P00532 7570-GET-TIMESTAMP.                                              
P00532                                                                  
P00532     EXEC SQL                                                     
P00532         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                    
P00532     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET: WS-TIMESTAMP = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00532                                                                  
P00532     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00532                                                                  
P00532     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00532          NEXT SENTENCE                                           
P00532     ELSE                                                         
P00532         DISPLAY '*******************************************'    
P00532         DISPLAY '** ERROR IN 7570-SELECT-TIMESTAMP        **'    
P00532         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
P00532         DISPLAY '*******************************************'    
P00532         PERFORM 9900-ABEND                THRU 9900-EXIT         
P00532     END-IF.                                                      
P00532                                                                  
P00532 7570-EXIT.                                                       
P00532     EXIT.                                                        
108300                                                                  
108400     EXEC SQL                                                             
108500         INCLUDE CPD00038                                                 
108600     END-EXEC.                                                            
108700                                                                  
108800*                                                                         
101800*                                                                       00
108900******************************************************************        
109000* 7620-START-FCSCA00                                             *        
109100* 7621-READ-FCSCA00                                              *        
109200* 7622-CLOSE-CA00-CSR                                            *        
109300* COPY BOOK CONTAINING COMMON DATE RETRIEVAL LOGIC               *        
109400*****************************************************************         
109500                                                                  
109600     EXEC SQL                                                             
109700         INCLUDE CPD00039                                                 
109800     END-EXEC.                                                            
109900                                                                  
098100******************************************************************      00
098200* 7680-GET-ACCT-REG-PROFILE                                      *      0 
098300* GET REGULATED PROFILE OF THE ACCT                              *      00
098400******************************************************************      00
098500*                                                                       00
098600 7680-GET-ACCT-REG-PROFILE.                                       
098700*                                                                       00
098800     EXEC SQL                                                     
098900        SELECT                                                    
099000          LR.REG_GROUP_CD                                         
099100          INTO                                                    
099200           :LR-REG-GROUP-CD                                       
099300        FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                     
099400        WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                      
099500                                                           
099600                                                      
099700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                           00
MFA-TR*       SELECT                                                            
MFA-TR*         LR.REG_GROUP_CD                                                 
MFA-TR*         INTO                                                            
MFA-TR*          :LR-REG-GROUP-CD                                               
MFA-TR*       FROM CSS_REG_PROFILE LR                                           
MFA-TR*       WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                          00

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

099800                                                                  
099900     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
099910                                                                  
100000     EVALUATE WS-ACTIVE-RETURN-CODE                               
100100     WHEN SUCCESSFUL-CALL                                         
100200        CONTINUE                                                  
100300     WHEN NOT-FOUND                                               
100400        MOVE SPACES TO LR-REG-GROUP-CD                            
100500     WHEN OTHER                                                   
100600        DISPLAY '********** PCSAC200 ABORT **************'        
100700        DISPLAY '*    7680-GET-ACCT-REG-PROFILE         *'        
100800        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
100900        DISPLAY '* ACCOUNT NO           ' LR-ACCOUNT-NO           
101000        DISPLAY '* COMPANY NO          ' AT-COMPANY-NO            
101100        DISPLAY '* PROGRAM ABORTING...                  *'        
101200        DISPLAY '********** PCSAC201 ABORT **************'        
101300        PERFORM 9900-ABEND                      THRU 9900-EXIT    
101400     END-EVALUATE.                                                
101500*                                                                       00
101600 7680-EXIT.                                                       
101700      EXIT.                                                       
081100******************************************************************      00
081200* 8200-INSRT-COMM-DATA.                                          *      00
081300* INSERT ROW INTO CSS_COMM_DATA                                  *      00
081400******************************************************************      00
081500*                                                                       00
081600 8200-INSRT-COMM-DATA.                                            
081700*                                                                       00
081800     EXEC SQL                                                     
081900        INSERT INTO CSS_COMM_DATA                                 
082000             ( COMMUNICATION_ID,                                  
082100               ACCOUNT_NO,                                        
082200               CUSTOMER_NO,                                       
082300               PREMISE_NO,                                        
082400               COMPANY_NO,                                        
082500               RED_FLAG_IND,                                      
082600               RED_FLAG_EXPIRE_DT,                                
082700               COMM_METHOD,                                       
082800               COMM_DIRECTION,                                    
082900               COMM_TYPE_CD,                                      
083000               COMM_SUBTYPE_CODE,                                 
083100               USER_ID_ORIG,                                      
083200               CONTACT_NAME,                                      
083300               PROMOTION_ID,                                      
083400               PSC_COMPLIANCE_IND,                                
083500               CALL_ORIGIN_ID,                                    
083600               CALL_END_TIME,                                     
083700               NUMBER_TRANSFERS,                                  
083800               HOLD_TIME,                                         
083900               QUEUE_TIME,                                        
084000               SCREEN_POP_IND,                                    
084100               TOTAL_CALL_TIME,                                   
084200               INITIAL_COMMENT_TX,                                
084300               COMM_ASSOC_CD,                                     
084400               COMPLAINT_FL,                                      
084500               DISCOVERY_MTHD_CD,                                 
084600              PREV_MARKETER_CD)                                   
084700        VALUES                                                    
084800              (CIS.CHAR2TIMESTAMP(:KO-COMMUNICATION-ID),                  
084900               :KO-ACCOUNT-NO,                                    
085000               :KO-CUSTOMER-NO,                                   
085100               :KO-PREMISE-NO,                                    
085200               :KO-COMPANY-NO,                                    
085300               :KO-RED-FLAG-IND,                                  
085400               CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                        :WS-NULL-IND-1),              
085500               :KO-COMM-METHOD,                                   
085600               :KO-COMM-DIRECTION,                                
085700               :KO-COMM-TYPE-CD,                                  
085800               :KO-COMM-SUBTYPE-CODE,                             
085900               :KO-USER-ID-ORIG,                                  
086000               :KO-CONTACT-NAME,                                  
086100               :KO-PROMOTION-ID,                                  
086200               :KO-PSC-COMPLIANCE-IND,                            
086300               :KO-CALL-ORIGIN-ID,                                
086400               CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME :WS-NULL-IND-2
              ),                   
086500               :KO-NUMBER-TRANSFERS,                              
086600               :KO-HOLD-TIME,                                     
086700               :KO-QUEUE-TIME,                                    
086800               :KO-SCREEN-POP-IND,                                
086900               :KO-TOTAL-CALL-TIME,                               
087000               :KO-INITIAL-COMMENT-TX,                            
087100               :KO-COMM-ASSOC-CD,                                 
087200               :KO-COMPLAINT-FL,                                  
087300               :KO-DISCOVERY-MTHD-CD,                             
087400               :KO-PREV-MARKETER-CD)                              
087500          END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                           00
MFA-TR*       INSERT INTO CSS_COMM_DATA                                         
MFA-TR*            ( COMMUNICATION_ID,                                          
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              RED_FLAG_IND,                                              
MFA-TR*              RED_FLAG_EXPIRE_DT,                                        
MFA-TR*              COMM_METHOD,                                               
MFA-TR*              COMM_DIRECTION,                                            
MFA-TR*              COMM_TYPE_CD,                                              
MFA-TR*              COMM_SUBTYPE_CODE,                                         
MFA-TR*              USER_ID_ORIG,                                              
MFA-TR*              CONTACT_NAME,                                              
MFA-TR*              PROMOTION_ID,                                              
MFA-TR*              PSC_COMPLIANCE_IND,                                        
MFA-TR*              CALL_ORIGIN_ID,                                            
MFA-TR*              CALL_END_TIME,                                             
MFA-TR*              NUMBER_TRANSFERS,                                          
MFA-TR*              HOLD_TIME,                                                 
MFA-TR*              QUEUE_TIME,                                                
MFA-TR*              SCREEN_POP_IND,                                            
MFA-TR*              TOTAL_CALL_TIME,                                           
MFA-TR*              INITIAL_COMMENT_TX,                                        
MFA-TR*              COMM_ASSOC_CD,                                             
MFA-TR*              COMPLAINT_FL,                                              
MFA-TR*              DISCOVERY_MTHD_CD,                                         
MFA-TR*             PREV_MARKETER_CD)                                           
MFA-TR*       VALUES                                                            
MFA-TR*             (:KO-COMMUNICATION-ID,                                      
MFA-TR*              :KO-ACCOUNT-NO,                                            
MFA-TR*              :KO-CUSTOMER-NO,                                           
MFA-TR*              :KO-PREMISE-NO,                                            
MFA-TR*              :KO-COMPANY-NO,                                            
MFA-TR*              :KO-RED-FLAG-IND,                                          
MFA-TR*              :KO-RED-FLAG-EXPIRE-DT:WS-NULL-IND-1,                      
MFA-TR*              :KO-COMM-METHOD,                                           
MFA-TR*              :KO-COMM-DIRECTION,                                        
MFA-TR*              :KO-COMM-TYPE-CD,                                          
MFA-TR*              :KO-COMM-SUBTYPE-CODE,                                     
MFA-TR*              :KO-USER-ID-ORIG,                                          
MFA-TR*              :KO-CONTACT-NAME,                                          
MFA-TR*              :KO-PROMOTION-ID,                                          
MFA-TR*              :KO-PSC-COMPLIANCE-IND,                                    
MFA-TR*              :KO-CALL-ORIGIN-ID,                                        
MFA-TR*              :KO-CALL-END-TIME:WS-NULL-IND-2,                           
MFA-TR*              :KO-NUMBER-TRANSFERS,                                      
MFA-TR*              :KO-HOLD-TIME,                                             
MFA-TR*              :KO-QUEUE-TIME,                                            
MFA-TR*              :KO-SCREEN-POP-IND,                                        
MFA-TR*              :KO-TOTAL-CALL-TIME,                                       
MFA-TR*              :KO-INITIAL-COMMENT-TX,                                    
MFA-TR*              :KO-COMM-ASSOC-CD,                                         
MFA-TR*              :KO-COMPLAINT-FL,                                          
MFA-TR*              :KO-DISCOVERY-MTHD-CD,                                     
MFA-TR*              :KO-PREV-MARKETER-CD)                                      
MFA-TR*         END-EXEC.                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

087600     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
087700     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
087800        CONTINUE                                                  
087900     ELSE                                                         
088000        DISPLAY '********** PCSAC200 ABORT **************'        
088100        DISPLAY '*    8200-INSRT-COMM-DATA              *'        
088200        DISPLAY '* SQL CODE           : ' WS-ACTIVE-RETURN-CODE   
088300        DISPLAY '* ACCOUNT NO         : ' KO-ACCOUNT-NO           
088400        DISPLAY '* CUSTOMER NO        : ' KO-CUSTOMER-NO          
088500        DISPLAY '* PREMISE NO         : ' KO-PREMISE-NO           
088600        DISPLAY '* COMPANY NO         : ' KO-COMPANY-NO           
088700        DISPLAY '* PROGRAM ABORTING...                  *'        
088800        DISPLAY '********** PCSAC201 ABORT **************'        
088900        PERFORM 9900-ABEND                      THRU 9900-EXIT    
089000     END-IF.                                                      
089100*                                                                       00
089200 8200-EXIT.                                                       
089300      EXIT.                                                       
089400*                                                                       00
114800******************************************************************        
114900* 8300-COMMIT.                                                   *        
115000******************************************************************        
115100 8300-COMMIT.                                                     
115200                                                                  
115300     EXEC SQL                                                             
115400        INCLUDE CPD00047                                                  
115500     END-EXEC.                                                            
115600                                                                  
115700     DISPLAY 'COMMITTED ' WS-LETTER-COUNTER ' ACCOUNTS'.          
115800                                                                  
115900 8300-EXIT.                                                       
116000      EXIT.                                                       
116100*                                                                         
116200******************************************************************        
116300* 8400-RESET-JOB-PARM                                            *        
116400* UPDATES STATUS TO INACTIVE FOR COMMAND CODE AS DATE            *        
116500******************************************************************        
116600 8400-RESET-JOB-PARM.                                             
116700                                                                  
116800     EXEC SQL                                                     
116900        UPDATE CSS_JOB_PARM                                       
117000           SET STATUS       = :G6-STATUS                          
117100         WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
117200           AND CMND_CODE    = :G6-CMND-CODE                       
117300           AND COMPANY_NO   = :G6-COMPANY-NO                      
117400     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

117500                                                                  
117600     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
117700     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
117800        CONTINUE                                                  
117900     ELSE                                                         
118000        DISPLAY '********** PCSAC200 ABORT **************'        
118100        DISPLAY '*    8400-RESET-JOB-PARM               *'        
118200        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
118300        DISPLAY '* PROGRAM_NAME         ' G6-PROGRAM-NAME         
118400        DISPLAY '* CMND_CODE            ' G6-CMND-CODE            
118500        DISPLAY '* COMPANY_NO           ' G6-COMPANY-NO           
118600        DISPLAY '* PROGRAM ABORTING...                  *'        
118700        DISPLAY '********** PCSAC200 ABORT **************'        
118800        PERFORM 9900-ABEND                      THRU 9900-EXIT    
118900     END-IF.                                                      
119000                                                                  
119100 8400-EXIT.                                                       
119200      EXIT.                                                       
119300*                                                                         
119400******************************************************************        
119500* 8500-COMMIT-RESTART.                                           *        
119600******************************************************************        
119700 8500-COMMIT-RESTART.                                             
119800     MOVE 1 TO WS-RESTART-PROCESS-TYPE                            
119900     MOVE 'C' TO WS-RESTART-JOB-STATUS                            
120000     MOVE WS-RUN-DT TO  WS-RESTART-RUN-DATE                       
120100     MOVE WS-PROCESSED-DT TO  WS-RESTART-PROCESS-DATE             
120110     MOVE WS-LEGACY-END-DT TO WS-RESTART-LEGACY-DATE              
120200     MOVE WS-PREV-ACCOUNT-NO TO WS-RESTART-ACCOUNT-NO             
120300     MOVE WS-LETTER-COUNTER  TO WS-RESTART-LETTER-CNTR            
120400*    ADD ONE TO LETTER COUNTER SO HEADER REC IS ALSO READ.                
120500     ADD 1                   TO WS-RESTART-LETTER-CNTR            
120600     PERFORM 8600-STORE-RESTART           THRU 8600-EXIT.         
120800                                                                  
120900 8500-EXIT.                                                       
121000      EXIT.                                                       
121100*                                                                         
121200******************************************************************        
121300* 8600-STORE-RESTART.                                            *        
121400******************************************************************        
121500 8600-STORE-RESTART.                                              
121600                                                                  
121700     MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
121800     MOVE 1                           TO RF-PARTITION-NO.         
121900     MOVE 1                           TO RF-DUP-CNTRL-NO.         
122000     MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
122100     MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.     
122200                                                                  
122300     PERFORM 8800-UPD-RESTART      THRU 8800-EXIT.                
122400                                                                  
122500     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
122600       PERFORM 8900-INSRT-RESTART   THRU 8900-EXIT                
122700     END-IF.                                                      
122800     EXEC SQL                                                             
122900        INCLUDE CPD00047                                                  
123000     END-EXEC.                                                            
                                                    
123100 8600-EXIT.                                                       
123200      EXIT.                                                       
123300*                                                                         
123400***************************************************************           
123500* 8700-DEL-RESTART.                                            *          
123600****************************************************************          
123700 8700-DEL-RESTART.                                                
123800*                                                                         
123900     EXEC SQL                                                     
124000         DELETE FROM RF                                
               FROM CSS_RESTART RF
124100          WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                
124200            AND RF.PARTITION_NO = :RF-PARTITION-NO                
124300            AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                
124400                                                      
124500     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_RESTART RF                                       
MFA-TR*         WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                        
MFA-TR*           AND RF.PARTITION_NO = :RF-PARTITION-NO                        
MFA-TR*           AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                        
MFA-TR*        QUERYNO 8700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

124600*                                                                         
124700     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
124800     IF SQLCODE  = SUCCESSFUL-CALL OR NOT-FOUND                   
124900        CONTINUE                                                  
125000     ELSE                                                         
125100        DISPLAY '***************************************'         
125200        DISPLAY '**   ERROR ON 8700-DEL-RESTART       **'         
125300        DISPLAY '**   NAME_PROGRAM = ' RF-NAME-PROGRAM            
125400        DISPLAY '**   SQLCODE      = ' SQLCODE                    
125500        DISPLAY '**       PROCESSING TERMINATED       **'         
125600        DISPLAY '***************************************'         
125700        PERFORM 9900-ABEND            THRU 9900-EXIT              
125800     END-IF.                                                      
125900 8700-EXIT.                                                       
126000      EXIT.                                                       
126100*                                                                         
126200****************************************************************          
126300*8800-UPD-RESTART.                                            *           
126400***************************************************************           
126500 8800-UPD-RESTART.                                                
126600*                                                                         
126700     EXEC SQL                                                     
126800         UPDATE RF                                     
126900            SET RF.RESTART_DATA = :RF-RESTART-DATA                
               FROM CSS_RESTART RF
127000          WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                
127100            AND RF.PARTITION_NO = :RF-PARTITION-NO                
127200            AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                
127300                                                      
127400     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_RESTART RF                                            
MFA-TR*           SET RF.RESTART_DATA = :RF-RESTART-DATA                        
MFA-TR*         WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                        
MFA-TR*           AND RF.PARTITION_NO = :RF-PARTITION-NO                        
MFA-TR*           AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                        
MFA-TR*        QUERYNO 8800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

127500*                                                                         
127600     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
127700     IF SQLCODE  = SUCCESSFUL-CALL OR NOT-FOUND                   
127800       CONTINUE                                                   
127900     ELSE                                                         
128000       DISPLAY '***************************************'          
128100       DISPLAY '**   ERROR ON 8800-UPD-RESTART       **'          
128200       DISPLAY '**   NAME_PROGRAM = ' RF-NAME-PROGRAM             
128300       DISPLAY '**   SQLCODE      = ' SQLCODE                     
128400       DISPLAY '**       PROCESSING TERMINATED       **'          
128500       DISPLAY '***************************************'          
128600       PERFORM 9900-ABEND            THRU 9900-EXIT               
128700     END-IF.                                                      
128800 8800-EXIT.                                                       
128900      EXIT.                                                       
129000*                                                                         
129100****************************************************************          
129200* 8900-INSRT-RESTART.                                          *          
129300*****************************************************************         
129400 8900-INSRT-RESTART.                                              
129500      EXEC SQL                                                    
129600        INSERT INTO CSS_RESTART                                   
129700               (NAME_PROGRAM                                      
129800               ,PARTITION_NO                                      
129900              ,DUP_CNTRL_NO                                       
130000              ,RESTART_DATA)                                      
130100        VALUES    (:RF-NAME-PROGRAM                               
130200             ,:RF-PARTITION-NO                                    
130300             ,:RF-DUP-CNTRL-NO                                    
130400             ,:RF-RESTART-DATA)                                   
130500       END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

130600                                                                  
130700      MOVE SQLCODE               TO  WS-ACTIVE-RETURN-CODE.       
130800                                                                  
130900      IF SQLCODE  = SUCCESSFUL-CALL                               
131000           CONTINUE                                               
131100      ELSE                                                        
131200       DISPLAY '***************************************'          
131300       DISPLAY '**   ERROR ON 8900-INSRT-RESTART     **'          
131400       DISPLAY '**   NAME_PROGRAM = ' RF-NAME-PROGRAM             
131500       DISPLAY '**   SQLCODE      = ' SQLCODE                     
131600       DISPLAY '**       PROCESSING TERMINATED       **'          
131700       DISPLAY '***************************************'          
131800       PERFORM 9900-ABEND            THRU 9900-EXIT               
131900     END-IF.                                                      
132000 8900-EXIT.                                                       
132100      EXIT.                                                       
132200*                                                                         
132300******************************************************************        
132400*9000-SEND-ERROR-RESULT.                                        *         
132500* REQUIRED BY THE COPYBOOK CPD00067                              *        
132600******************************************************************        
132700 9000-SEND-ERROR-RESULT.                                          
132800                                                                  
132900     GO TO 9000-EXIT.                                             
133000                                                                  
133100                                                                  
133200******************************************************************        
133300* 9000-TERMINATE.                                                *        
133400******************************************************************        
133500 9000-TERMINATE.                                                  
P00599     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
P00599         GO TO 9000-EXIT                                          
P00599     ELSE                                                         
P00599         MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
P00599         DISPLAY '                                      '         
P00599         DISPLAY '**************************************'         
P00599         DISPLAY '****  PCSKR400  PROCESSING ERROR  ****'         
P00599         DISPLAY '**************************************'         
P00599         DISPLAY '                                      '         
P00599         DISPLAY 'SQLCODE =  ' WS-DISPLAY-SQLCODE
           END-IF.                
133600*    CLOSE FCSAC200-FILE.                                                 
133800 9000-EXIT.                                                       
133900      EXIT.                                                       
134000*                                                                         
      *                                                                         
P00599****************************************************************          
P00599**  9700-PROCESS-ABEND.                                       **          
P00599****************************************************************          
P00599 COPY CPD0023B.                                                           
P00599*                                                                         
P00599****************************************************************          
134100******************************************************************        
134200* 9900-SQL-ERROR-ROUTINE                                         *        
134300* REQUIRED BY THE COPYBOOK CPD00067                              *        
134400******************************************************************        
134500 9900-SQL-ERROR-ROUTINE.                                          
134600                                                                  
134700     DISPLAY '********** PCSAC200  ABORT **************'.         
134800     DISPLAY '* ACTIVE PARA        : ' ACTIVE-PARAGRAPH.          
134900     DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE.     
135000     DISPLAY '* ABEND FUNCT        : ' ABEND-FUNCTION.            
135100     DISPLAY '* TABLE1             : ' TABLE-1.                   
135200     DISPLAY '* HOSTVAR1           : ' HOSTVAR-ELEMENT-1.         
135300     DISPLAY '* HOSTVAR2           : ' HOSTVAR-ELEMENT-2.         
135400     DISPLAY '* HOSTVAR3           : ' HOSTVAR-ELEMENT-3.         
135500     DISPLAY '* HOSTVAR4           : ' HOSTVAR-ELEMENT-4.         
135600     DISPLAY '* PROGRAM ABORTING...                   *'.         
135700     DISPLAY '********** PCSAC200  ABORT **************'.         
135800                                                                  
135900******************************************************************        
136000* 9900-ABEND.                                                    *        
136100******************************************************************        
136200     EXEC SQL                                                             
136300        INCLUDE CPD09900                                                  
136400     END-EXEC.                                                            
136500                                                                  
