       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSAC195.                                            
       AUTHOR. BASKAR VANNI.                                            
       DATE-WRITTEN. OCTOBER 2012.                                      
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *      DATE       INITIALS   REASON                             *         
      *    ==========   =========  ================================   *         
A04174*    10/15/2012   BASKAR V   NEW PROGRAM                        *         
ACT214*    11/17/2015   RICK BLACK 1)ADD DATE RANGE TO VERIFY PAYMENT.*         
ACT214*      APPL00005613,ACT214   2)ADD COMPANY NUMBER FOR JOB PARM  *         
ACT214*                              DATE OPTION.                     *         
ACT162*    05/13/2016   MR7E794    REPLACE TABLE CSS_CC_PMT_CANC_RS BY*         
ACT162*                 A05460     TABLE CSS_CODE_VALUE.              *         
ACT268*    08/31/2016   BD09555    REMOVE CBL ADV                     *         
ACT268*A05460-ACT268                                                  *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
      *---------------------------------------------------------------*         
      * THIS PROGRAM UPDATES AUTO CARD PAYMENT STATUS TO CANCELLED    *         
      * AND UPDATES THE CANCEL REASON. THE INPUT ACCOUNTS AND REASON  *         
      * ARE RECEIVED IN A FILE FROM BILLMATRIX ON DAILY BASIS.        *         
      *---------------------------------------------------------------*         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.                                                 
       OBJECT-COMPUTER.                                                 
       SPECIAL-NAMES.                                                   
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
           SELECT FCSAC195-FILE                                         
               ASSIGN TO UT-S-FCSAC195                                  
               FILE STATUS IS WS-FAC195-STATUS.                         
                                                                        
      ***************************************************************           
      *  CSSPT33 - SELECT STATEMENT FOR OUTPUT REPORT FILE - 133 CHR*           
      ***************************************************************           
       COPY CSSPT33.                                                            
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
                                                                        
       FD  FCSAC195-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       COPY FIOAC195.                                                           
                                                                        
      ***************************************************************           
      *  CFDPT33 - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE       *           
      ***************************************************************           
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC195'.
MSQ017     COPY MFASQLM.
       01  WS-COUNTERS.                                                 
           05 WS-DET-REC-CNT            PIC  9(08) VALUE  0.            
           05 WS-PAGE-NUM               PIC 9(04) VALUE ZEROES.         
           05 WS-LINE-SPACE             PIC 9(02) VALUE ZEROES.         
           05 WS-LINE-DIFF              PIC 9(03) VALUE ZEROES.         
           05 WS-LINE-CNTR              PIC 9(03) VALUE 56.             
           05 WS-EXCEP-CNT              PIC S9(04) COMP VALUE +0.       
                                                                        
       01  WS-CONSTANTS.                                                
           05 WS-PGRMNAME               PIC X(08) VALUE 'PCSAC195'.     
           05 WS-PGMNAME                PIC X(08) VALUE 'PCSAC195'.     
           05 WS-FIFTY-FIVE             PIC 9(02) VALUE 55.             
           05 WS-Y                      PIC X(01) VALUE 'Y'.            
           05 WS-N                      PIC X(01) VALUE 'N'.            
           05 WS-ZERO                   PIC 9(01) VALUE 0.              
           05 WS-ONE                    PIC 9(01) VALUE 1.              
           05 WS-TWO                    PIC 9(01) VALUE 2.              
           05 WS-SIX                    PIC 9(01) VALUE 6.              
                                                                        
       01  WS-VARIABLES.                                                
           05 WS-PAYMENT-AMT            PIC S9(07)V9(2) COMP.           
           05 WS-COMPANY                PIC X(02) VALUE SPACES.         
           05 WS-TOTAL-AMT              PIC S9(09)V9(2) COMP VALUE +0.  
           05 WS-EXCEP-AMT              PIC S9(09)V9(2) COMP VALUE +0.  
COB305     05 WS-DAYS        PIC S9(04)V9(05) COMP-3 VALUE 0.        
ACT214     05 WS-DATE-BEFORE            PIC X(10) VALUE SPACES.         
ACT214     05 WS-DATE-AFTER             PIC X(10) VALUE SPACES.         
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-EOF-FLAG                PIC X(01) VALUE 'N'.            
             88 END-OF-FILE                       VALUE 'Y'.            
          05 WS-FAC195-STATUS           PIC X(02).                      
             88 FAC195-SUCCESSFUL                 VALUE '00'.           
                                                                        
       01 WS-RPT-HDR1.                                                  
          05 FILLER                           PIC X(1)  VALUE SPACES.   
          05 WS-RPT-ID                        PIC X(8).                 
          05 FILLER                           PIC X(34) VALUE SPACES.   
          05 WS-COMPANY-NAME                  PIC X(39) VALUE SPACES.   
          05 FILLER                           PIC X(28) VALUE SPACES.   
          05 FILLER                           PIC X(10) VALUE           
                                                  'RUN-DATE :'.         
          05 WS-RPT-DATE                      PIC X(10).                
                                                                        
       01 WS-RPT-HDR2.                                                  
          05 FILLER                           PIC X(37) VALUE SPACES.   
          05 FILLER                           PIC X(38) VALUE           
                        ' AUTO CARD PAYMENT REJECTION  '.               
          05 FILLER                           PIC X(35) VALUE SPACES.   
          05 FILLER                           PIC X(12) VALUE           
                                                  'RUN-TIME :  '.       
          05 WS-RPT-TIME                      PIC X(08).                
                                                                        
       01 WS-PAGE-HDR.                                                  
          05 FILLER                           PIC X(110) VALUE SPACES.  
          05 FILLER                           PIC X(10) VALUE           
                                                  'PAGE-NO  :'.         
          05 FILLER                           PIC X(06) VALUE SPACES.   
          05 WS-PAGE-NO                       PIC ZZZ9  VALUE '00'.     
          05 FILLER                           PIC X(05) VALUE SPACES.   
                                                                        
       01 WS-RPT-LINE.                                                  
          05 FILLER                           PIC X(132) VALUE ALL      
                                                  '-'.                  
                                                                        
       01 WS-RPT-HDR3.                                                  
          05 FILLER                           PIC X(2)  VALUE SPACES.   
          05 FILLER                           PIC X(14) VALUE           
                                                  '  ACCOUNT NO  '.     
          05 FILLER                           PIC X(3)  VALUE SPACES.   
          05 FILLER                           PIC X(12) VALUE           
                                                  'PAYMENT DATE'.       
          05 FILLER                           PIC X(03) VALUE SPACES.   
          05 FILLER                           PIC X(14) VALUE           
                                                  'PAYMENT AMOUNT'.     
          05 FILLER                           PIC X(03) VALUE SPACES.   
          05 FILLER                           PIC X(14) VALUE           
                                                  'PAYMENT STATUS'.     
          05 FILLER                           PIC X(07) VALUE SPACES.   
          05 FILLER                           PIC X(16) VALUE           
                                                  ' CANCEL REASON  '.   
          05 FILLER                           PIC X(44) VALUE SPACES.   
                                                                        
       01 WS-RPT-DTL.                                                   
          05 FILLER                           PIC X(2)  VALUE SPACES.   
          05 WS-RPT-ACCT-NO                   PIC X(13) VALUE SPACES.   
          05 FILLER                           PIC X(5)  VALUE SPACES.   
          05 WS-RPT-PYMT-DT                   PIC X(10) VALUE SPACES.   
          05 FILLER                           PIC X(05) VALUE SPACES.   
          05 WS-RPT-PYMT-AMT                  PIC Z(7).99 VALUE SPACES. 
          05 FILLER                           PIC X(10) VALUE SPACES.   
          05 WS-RPT-PYMT-STAT                 PIC X(10) VALUE SPACES.   
          05 FILLER                           PIC X(07) VALUE SPACES.   
          05 WS-RPT-CAN-REAS                  PIC X(26) VALUE SPACES.   
          05 FILLER                           PIC X(34) VALUE SPACES.   
                                                                        
                                                                        
       01 WS-RPT-TOT-MSG.                                               
          05 FILLER                           PIC X(10) VALUE SPACES.   
          05 FILLER                           PIC X(15) VALUE           
                                              'TOTAL ACCOUNT: '.        
          05 WS-RPT-TOTAL-CNT                 PIC ---,--9.              
          05 FILLER                           PIC X(06) VALUE SPACES.   
          05 FILLER                           PIC X(15) VALUE           
                                              'TOTAL AMOUNT:'.          
          05 WS-RPT-TOTAL-AMOUNT              PIC --,---,---,--9.99.    
          05 FILLER                           PIC X(60) VALUE SPACES.   
                                                                        
       01 WS-RPT-EXCEP-MSG.                                             
          05 FILLER                           PIC X(06) VALUE SPACES.   
          05 FILLER                           PIC X(19) VALUE           
                                              'EXCEPTION ACCOUNT: '.    
          05 WS-RPT-EXCEP-CNT                 PIC ---,--9.              
          05 FILLER                           PIC X(04) VALUE SPACES.   
          05 FILLER                           PIC X(17) VALUE           
                                              'EXCEPTION AMOUNT:'.      
          05 WS-RPT-EXCEP-AMOUNT              PIC --,---,---,--9.99.    
          05 FILLER                           PIC X(58) VALUE SPACES.   
                                                                        
                                                                        
       01 WS-RPT-FTR.                                                   
          05 FILLER                            PIC X(32) VALUE SPACES.  
          05 FILLER                            PIC X(25) VALUE          
                                           '**** END OF REPORT ****'.   
          05 FILLER                            PIC X(75) VALUE SPACES.  
                                                                        
      *===============================================================*         
      * SQL COMMUNICATION AREA                                        *         
      *===============================================================*         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_ACCOUNT                                                *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBPNDCRD                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_COMPANY - C7                                           *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      * UV - CSS_CODE_VALUE                                                     
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCDVALU                                                   
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_JOB_PARM                                               *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBJBPARM                                                    
           END-EXEC.                                                            
ACT214*                                                                         
ACT214******************************************************************        
ACT214*    C8 - CSS_DELINQUENCY                                        *        
ACT214******************************************************************        
ACT214*                                                                         
ACT214     EXEC SQL                                                             
ACT214        INCLUDE TBDELQ                                                    
ACT214     END-EXEC.                                                            
ACT214*                                                                         
      * JOB PARM RUN DATE VARIABLES                                             
       COPY FIOJC01.                                                            
                                                                        
      * DB2 AND SQL ERROR CHECKING VARIABLES                                    
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK.                                                  
       COPY CWS09900.                                                           
                                                                        
      * MISC VARIABLE DECLARATION                                               
       COPY CWS00038.                                                           
                                                                        
       LINKAGE SECTION.                                                 
       PROCEDURE DIVISION.                                              
      *----------------------------------------------------------------*        
      *                          M A I N L I N E                       *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-INPUT                                   
              THRU 1000-EXIT UNTIL  END-OF-FILE                         
                                                                        
           PERFORM 2990-PRINT-REPORT-TRAILER                            
              THRU 2990-EXIT                                            
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   OPENS THE INPUT FILE AND FINDS THE RUN DATE                  *        
      *                                                                *        
      *----------------------------------------------------------------*        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
      * OPEN THE INPUT PAYMENT REJECTION FILE                                   
           OPEN INPUT FCSAC195-FILE                                     
                                                                        
           IF  FAC195-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** PCSAC195  PROCESSING ERROR  **'              
               DISPLAY '0100-ERROR ON FCSAC195 OPEN.  STATUS IS '       
                       WS-FAC195-STATUS                                 
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF                                                       
                                                                        
           OPEN OUTPUT FCSPT33-FILE                                     
                                                                        
           ACCEPT WS-COMPANY FROM SYSIN                                 
                                                                        
           IF WS-COMPANY > SPACES                                       
              MOVE WS-COMPANY      TO C7-COMPANY-NO                     
ACT214                                G6-COMPANY-NO                     
              PERFORM 7300-GET-COMPANY-NAME                             
                 THRU 7300-EXIT                                         
              MOVE C7-COMPANY-NAME TO WS-COMPANY-NAME                   
           ELSE                                                         
              MOVE SPACES          TO WS-COMPANY-NAME                   
           END-IF                                                       
                                                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                   
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES     TO WS-INPUT-AREA                          
              MOVE SPACES     TO WS-INPUT-DATA-BREAKDOWN                
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
              MOVE 'PCSAC195' TO WS-PGRMNAME                            
           END-IF                                                       
                                                                        
           PERFORM 7100-GET-CURRENT-DATE                                
              THRU 7100-EXIT                                            
                                                                        
           MOVE WS-PGRMNAME   TO WS-RPT-ID                              
                                                                        
           PERFORM 1100-READ-RECORDS                                    
              THRU 1100-EXIT.                                           
ACT214*                                                                         
ACT214     MOVE 'NBR-DAYS-PCSAC195'             TO   C8-DELINQ-CD.      
ACT214     PERFORM 7500-GET-DELIQUENCY-VALUES   THRU 7500-EXIT.         
ACT214*                                                                         
ACT214     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT214        MOVE C8-DELINQ-VALUE              TO WS-DAYS              
ACT214     ELSE                                                         
ACT214        MOVE 5                            TO WS-DAYS              
ACT214     END-IF.                                                      
ACT214*                                                                         
ACT214     EXEC SQL                                                     
ACT214        SELECT
              DATEADD( DAY, -IIF(TRY_CAST(:WS-DAYS AS INT) IS NULL, 
              CIS.INTEGER(:WS-DAYS), CAST(:WS-DAYS AS INT)), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-DATE-BEFORE 
ACT214     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-BEFORE = (CURRENT DATE - INT(:WS-DAYS) DAYS) S)      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT214*                                                                         
ACT214     EXEC SQL                                                     
ACT214        SELECT
              DATEADD( DAY, IIF(TRY_CAST(:WS-DAYS AS INT) IS NULL, 
              CIS.INTEGER(:WS-DAYS), CAST(:WS-DAYS AS INT)), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-DATE-AFTER  
ACT214     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-AFTER = (CURRENT DATE + INT(:WS-DAYS) DAYS)          
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
ACT214*                                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
                                                                        
           EVALUATE AC195-DET-RECORD-ID                                 
               WHEN 'H'                                                 
                  PERFORM 2300-VALIDATE-HDR-DATE                        
                     THRU 2300-EXIT                                     
               WHEN 'D'                                                 
                  PERFORM 2000-PROCESS-DETAIL-REC                       
                     THRU 2000-EXIT                                     
               WHEN 'T'                                                 
                  PERFORM 2100-PROCESS-TRAILER-REC                      
                     THRU 2100-EXIT                                     
               WHEN OTHER                                               
                  DISPLAY 'INVALID RECORD TYPE IN FCSAC195 FILE'        
                  DISPLAY 'PLEASE CORRECT THE ERROR ON THE FILE'        
                  DISPLAY 'PROCESSING TERMINATED'                       
                  PERFORM 9900-ABEND                                    
                     THRU 9900-EXIT                                     
           END-EVALUATE                                                 
                                                                        
           PERFORM 1100-READ-RECORDS                                    
              THRU 1100-EXIT                                            
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *                                                                *        
      *       READS THE INPUT PAYMENT REJECTION FILE                   *        
      *----------------------------------------------------------------*        
       1100-READ-RECORDS.                                               
                                                                        
           READ FCSAC195-FILE                                           
             AT END MOVE WS-Y     TO WS-EOF-FLAG                        
                                                                        
           IF FAC195-SUCCESSFUL OR END-OF-FILE                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'ERROR ON READING FCSAC195'                       
              DISPLAY 'PROCESSING TERMINATED'                           
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF                                                       
           .                                                            
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *----------------------------------------------------------------*        
      *CHECKS THE CURRENT STATUS OF THE PAYMENT AND CANCEL THAT PAYMENT*        
      *                                                                *        
      *----------------------------------------------------------------*        
       2000-PROCESS-DETAIL-REC.                                         
                                                                        
           ADD  1 TO WS-DET-REC-CNT                                     
           MOVE AC195-DET-ACCT-NO    TO PC-ACCOUNT-NO                   
           MOVE AC195-AMOUNT         TO PC-PAYMENT-AMT                  
ACT162     MOVE 2                    TO UV-CODE-VALUE-LEN               
ACT162     MOVE AC195-DET-CAN-REASON TO UV-CODE-VALUE-TEXT              
                                        PC-PMT-CANCEL-REAS-CD           
                                                                        
           PERFORM 7000-VERIFY-PYMT                                     
              THRU 7000-EXIT                                            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF PC-STATUS-CODE NOT EQUAL 'P'                           
                 AND PC-STATUS-CODE NOT EQUAL 'X'                       
                 PERFORM 8000-CANCEL-PYMT                               
                    THRU 8000-EXIT                                      
              END-IF                                                    
           ELSE                                                         
ACT214        MOVE AC195-DET-DATE TO PC-PAYMENT-DATE                    
              MOVE SPACES         TO PC-STATUS-CODE                     
           END-IF                                                       
                                                                        
           ADD  PC-PAYMENT-AMT    TO WS-TOTAL-AMT                       
           IF PC-STATUS-CODE NOT EQUAL 'X'                              
              ADD PC-PAYMENT-AMT  TO WS-EXCEP-AMT                       
              ADD +1              TO WS-EXCEP-CNT                       
           END-IF                                                       
                                                                        
           PERFORM 2200-PROCESS-REPORT                                  
              THRU 2200-EXIT                                            
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * VERIFIES WHETHER THE NO OF RECORDS ARE MATCHING WITH THE FILE  *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2100-PROCESS-TRAILER-REC.                                        
                                                                        
           IF AC195-TRA-RECORD-CNT = WS-DET-REC-CNT                     
              PERFORM 2200-PROCESS-REPORT                               
                 THRU 2200-EXIT                                         
           ELSE                                                         
              DISPLAY 'TOTAL RECORD COUNT  = ' AC195-TRA-RECORD-CNT     
              DISPLAY 'DETAIL RECORD COUNT = ' WS-DET-REC-CNT           
              DISPLAY 'DETAIL RECORD COUNT IS NOT MATCHING WITH'        
              DISPLAY 'TOTAL RECORD  COUNT'                             
              DISPLAY 'PLEASE CORRECT THE ERROR ON THE FILE'            
              DISPLAY 'PROCESSING TERMINATED'                           
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF                                                       
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *MOVES REQUIRED VALUES TO WRITE THE REPORT                       *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2200-PROCESS-REPORT.                                             
                                                                        
           MOVE WS-ZERO                TO WS-LINE-DIFF                  
                                                                        
           COMPUTE WS-LINE-DIFF = WS-FIFTY-FIVE - WS-LINE-CNTR          
           END-COMPUTE                                                  
                                                                        
           IF WS-LINE-CNTR > WS-FIFTY-FIVE  OR WS-LINE-DIFF <= 5        
              PERFORM 2965-PRINT-REPORT-HEADER                          
                 THRU 2965-EXIT                                         
                                                                        
              MOVE WS-TWO              TO WS-LINE-SPACE                 
           END-IF                                                       
                                                                        
           IF AC195-DET-RECORD-ID = 'D'                                 
              ADD WS-ONE               TO WS-LINE-CNTR                  
              MOVE PC-ACCOUNT-NO       TO WS-RPT-ACCT-NO                
              MOVE PC-PAYMENT-DATE     TO WS-RPT-PYMT-DT                
              MOVE PC-PAYMENT-AMT      TO WS-RPT-PYMT-AMT               
                                                                        
              IF PC-STATUS-CODE = 'X'                                   
ACT162           MOVE SPACES             TO UV-CODE-SHORT-DESC-TEXT     
                 PERFORM 7200-GET-CANCEL-REASON                         
                    THRU 7200-EXIT                                      
ACT162           MOVE UV-CODE-SHORT-DESC-TEXT TO WS-RPT-CAN-REAS        
              ELSE                                                      
                 MOVE SPACES           TO WS-RPT-CAN-REAS               
              END-IF                                                    
                                                                        
              IF PC-STATUS-CODE EQUAL SPACES                            
                 MOVE '*NO MATCH*' TO WS-RPT-PYMT-STAT                  
              ELSE                                                      
                MOVE 1                   TO UV-CODE-VALUE-LEN           
                MOVE PC-STATUS-CODE      TO UV-CODE-VALUE-TEXT          
                MOVE SPACES              TO UV-CODE-SHORT-DESC-TEXT     
                PERFORM 7400-GET-PAYMENT-STATUS                         
                   THRU 7400-EXIT                                       
                                                                        
                MOVE UV-CODE-SHORT-DESC-TEXT TO WS-RPT-PYMT-STAT        
              END-IF                                                    
                                                                        
              MOVE WS-TWO                   TO WS-LINE-SPACE            
              MOVE WS-RPT-DTL               TO PRT33-DATA               
                                                                        
              PERFORM 2985-WRITE-RECORD                                 
                 THRU 2985-EXIT                                         
                                                                        
              MOVE WS-ONE                  TO WS-LINE-SPACE             
              ADD WS-ONE                   TO WS-LINE-CNTR              
           ELSE                                                         
              MOVE WS-DET-REC-CNT         TO WS-RPT-TOTAL-CNT           
              MOVE WS-TOTAL-AMT           TO WS-RPT-TOTAL-AMOUNT        
              MOVE WS-RPT-TOT-MSG         TO PRT33-DATA                 
              PERFORM 2985-WRITE-RECORD                                 
                 THRU 2985-EXIT                                         
                                                                        
              MOVE WS-ONE                  TO WS-LINE-SPACE             
              ADD WS-ONE                   TO WS-LINE-CNTR              
              MOVE WS-EXCEP-CNT           TO WS-RPT-EXCEP-CNT           
              MOVE WS-EXCEP-AMT           TO WS-RPT-EXCEP-AMOUNT        
              MOVE WS-RPT-EXCEP-MSG       TO PRT33-DATA                 
              PERFORM 2985-WRITE-RECORD                                 
                 THRU 2985-EXIT                                         
                                                                        
              MOVE WS-ONE                  TO WS-LINE-SPACE             
              ADD WS-ONE                   TO WS-LINE-CNTR              
           END-IF                                                       
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * VERIFIES WHETHER FILE DATE IS MATCHING WITH THE RUN DATE       *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2300-VALIDATE-HDR-DATE.                                          
ACT214     IF AC195-HDR-DATE <= WS-DATE-BEFORE OR                       
ACT214       AC195-HDR-DATE >= WS-DATE-AFTER                            
              DISPLAY 'HEADER DATE IS INVALID IN FCSAC195 FILE'         
              DISPLAY 'FILE HEADER DATE = ' AC195-HDR-DATE              
              DISPLAY '   JOB PARM DATE = ' WS-INPUT-DATE               
              DISPLAY 'PLEASE CORRECT THE ERROR ON THE FILE'            
              DISPLAY 'PROCESSING TERMINATED'                           
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF                                                       
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITES REPORT HEADER DETAILS                                   *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2965-PRINT-REPORT-HEADER.                                        
                                                                        
           MOVE '2965'                       TO WS-ACTIVE-PARAGRAPH     
                                                                        
           MOVE WS-ZERO                      TO WS-LINE-CNTR            
           ADD  WS-ONE                       TO WS-PAGE-NUM             
           MOVE WS-PAGE-NUM                  TO WS-PAGE-NO              
                                                                        
      ***  INCREMENTS THE PAGENO AND PRINTS THE HEADER                          
      ***  AFTER ADVANCING ONE PAGE                                             
                                                                        
           MOVE WS-RPT-HDR1                  TO PRT33-DATA              
                                                                        
           PERFORM 2975-WRITE-FIRST-HEADER                              
              THRU 2975-EXIT                                            
                                                                        
      ***  PRINT THE TITLE AND TIME                                             
                                                                        
           MOVE WS-RPT-HDR2                   TO PRT33-DATA             
           MOVE WS-ONE                        TO WS-LINE-SPACE          
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
           MOVE WS-PAGE-HDR                   TO PRT33-DATA             
                                                                        
           MOVE WS-ONE                        TO WS-LINE-SPACE          
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
      ***  PRINTS  ======                                                       
                                                                        
           MOVE WS-RPT-LINE                   TO PRT33-DATA             
           MOVE WS-TWO                        TO WS-LINE-SPACE          
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
      ***  PRINTS THE  COMPANY DETAILS              ***                         
                                                                        
           MOVE WS-RPT-HDR3                  TO PRT33-DATA              
           MOVE WS-ONE                       TO WS-LINE-SPACE           
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
      ***  PRINTS ======                             ***                        
                                                                        
           MOVE WS-RPT-LINE                  TO PRT33-DATA              
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
           MOVE WS-SIX                       TO WS-LINE-CNTR            
           .                                                            
       2965-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITES REPORT IN A NEW PAGE                                    *        
      *----------------------------------------------------------------*        
       2975-WRITE-FIRST-HEADER.                                         
                                                                        
           MOVE '2975'                       TO WS-ACTIVE-PARAGRAPH     
                                                                        
           WRITE PRT33-RECORD AFTER ADVANCING PAGE                      
           .                                                            
       2975-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITES REPORT IN NEXT LINE                                     *        
      *----------------------------------------------------------------*        
       2985-WRITE-RECORD.                                               
                                                                        
           MOVE '2985'                       TO WS-ACTIVE-PARAGRAPH     
                                                                        
           WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE             
           .                                                            
       2985-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITES END OF REPORT LINE                                      *        
      *----------------------------------------------------------------*        
       2990-PRINT-REPORT-TRAILER.                                       
                                                                        
           MOVE '2990'                       TO WS-ACTIVE-PARAGRAPH     
                                                                        
           MOVE  WS-RPT-FTR                  TO PRT33-DATA              
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
           .                                                            
       2990-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS THE PAYMENT STATUS                                     *        
      *                                                                *        
      *----------------------------------------------------------------*        
       7000-VERIFY-PYMT.                                                
      *-----------------*                                                       
                                                                        
           EXEC SQL                                                     
             SELECT STATUS_CODE                                         
ACT214             ,PAYMENT_DATE                                        
               INTO :PC-STATUS-CODE                                     
ACT214             ,:PC-PAYMENT-DATE                                    
               FROM CSS_PNDNG_CARD_PMT WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO     = :PC-ACCOUNT-NO                     
ACT214          AND PAYMENT_DATE                                        
ACT214            BETWEEN IIF(TRY_CONVERT(DATE, :WS-DATE-BEFORE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BEFORE
              ) <> 0) OR (LEN(:WS-DATE-BEFORE) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-BEFORE
              ), CONVERT(DATE, :WS-DATE-BEFORE) ) AND 
              IIF(TRY_CONVERT(DATE, :WS-DATE-AFTER
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-AFTER
              ) <> 0) OR (LEN(:WS-DATE-AFTER) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-AFTER
              ), CONVERT(DATE, :WS-DATE-AFTER) )            
                AND PAYMENT_AMT    = :PC-PAYMENT-AMT                    
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT STATUS_CODE                                                 
MFA-TR*            ,PAYMENT_DATE                                                
MFA-TR*        INTO :PC-STATUS-CODE                                             
MFA-TR*            ,:PC-PAYMENT-DATE                                            
MFA-TR*        FROM CSS_PNDNG_CARD_PMT                                          
MFA-TR*       WHERE ACCOUNT_NO     = :PC-ACCOUNT-NO                             
MFA-TR*         AND PAYMENT_DATE                                                
MFA-TR*           BETWEEN :WS-DATE-BEFORE AND :WS-DATE-AFTER                    
MFA-TR*         AND PAYMENT_AMT    = :PC-PAYMENT-AMT                            
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7000                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7000 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7000-VERIFY-PYMT'                
              DISPLAY '**  SQL STATUS       = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  PC-ACCOUNT-NO    = ' AC195-DET-ACCT-NO       
              DISPLAY '**  WS-DATE-BEFORE   = ' WS-DATE-BEFORE          
              DISPLAY '**  WS-DATE-AFTER    = ' WS-DATE-AFTER           
              DISPLAY '**  PC-PAYMENT-AMT   = ' AC195-DET-AMOUNT        
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS CURRENT DATE AND TIME                                  *        
      *----------------------------------------------------------------*        
       7100-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-RPT-DATE,
              :WS-RPT-TIME                        
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-RPT-DATE  = CURRENT DATE                                
MFA-TR*            ,:WS-RPT-TIME  = CURRENT TIME                                
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7100 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7100-GET-CURRENT-DATE'           
              DISPLAY '**  FAILED IN SET STATEMENT'                     
              DISPLAY '**  SQL STATUS       = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
                                                                        
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS CANCEL REASON DESCRIPTION                              *        
      *                                                                *        
      *----------------------------------------------------------------*        
       7200-GET-CANCEL-REASON.                                          
      *-----------------*                                                       
                                                                        
           EXEC SQL                                                     
ACT162       SELECT CODE_SHORT_DESC                                     
ACT162         INTO :UV-CODE-SHORT-DESC                                 
ACT162         FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
ACT162        WHERE TABLE_NA   = 'CSS_PNDNG_CARD_PMT'                   
ACT162          AND PROGRAM_ID = 'ALL'                                  
ACT162          AND COLUMN_NA  = 'PMT_CANCEL_REAS_CD'                   
ACT162          AND COMPANY_NO = '01'                                   
ACT162          AND CODE_VALUE = :UV-CODE-VALUE                         
                                                                 
ACT162                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CODE_SHORT_DESC                                             
MFA-TR*        INTO :UV-CODE-SHORT-DESC                                         
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE TABLE_NA   = 'CSS_PNDNG_CARD_PMT'                           
MFA-TR*         AND PROGRAM_ID = 'ALL'                                          
MFA-TR*         AND COLUMN_NA  = 'PMT_CANCEL_REAS_CD'                           
MFA-TR*         AND COMPANY_NO = '01'                                           
MFA-TR*         AND CODE_VALUE = :UV-CODE-VALUE                                 
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7200 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7200-GET-CANCEL-REASON'          
              DISPLAY '**  SQL STATUS         = ' WS-ACTIVE-RETURN-CODE 
              DISPLAY '**  PC-ACCOUNT-NO      = ' AC195-DET-ACCT-NO     
              DISPLAY '**  PC-PAYMENT-DATE    = ' AC195-DET-DATE        
              DISPLAY '**  PC-PAYMENT-AMT     = ' AC195-DET-AMOUNT      
ACT162        DISPLAY '**  PMT-CANCEL-REAS-CD = ' UV-CODE-VALUE         
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS COMPANY DESCRIPTION                                    *        
      *                                                                *        
      *----------------------------------------------------------------*        
       7300-GET-COMPANY-NAME.                                           
      *-----------------*                                                       
                                                                        
           EXEC SQL                                                     
             SELECT COMPANY_NAME                                        
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY WITH(READUNCOMMITTED)                           
              WHERE COMPANY_NO = :C7-COMPANY-NO                         
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NAME                                                
MFA-TR*        INTO :C7-COMPANY-NAME                                            
MFA-TR*        FROM CSS_COMPANY                                                 
MFA-TR*       WHERE COMPANY_NO = :C7-COMPANY-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7300                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7300 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7300-GET-COMPANY-NAME'           
              DISPLAY '**  SQL STATUS         = ' WS-ACTIVE-RETURN-CODE 
              DISPLAY '**  COMPANY NO         = ' C7-COMPANY-NO         
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT DESCRIPTION FOR PAYMENT STATUS                          *        
      *                                                                *        
      *----------------------------------------------------------------*        
       7400-GET-PAYMENT-STATUS.                                         
      *------------------------*                                                
                                                                        
           EXEC SQL                                                     
             SELECT CODE_SHORT_DESC                                     
               INTO :UV-CODE-SHORT-DESC                                 
               FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
              WHERE TABLE_NA   = 'CSS_PNDNG_CARD_PMT'                   
                AND PROGRAM_ID = 'PANEL190'                             
                AND COLUMN_NA  = 'STATUS_CODE'                          
                AND COMPANY_NO = '01'                                   
                AND CODE_VALUE = :UV-CODE-VALUE                         
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CODE_SHORT_DESC                                             
MFA-TR*        INTO :UV-CODE-SHORT-DESC                                         
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE TABLE_NA   = 'CSS_PNDNG_CARD_PMT'                           
MFA-TR*         AND PROGRAM_ID = 'PANEL190'                                     
MFA-TR*         AND COLUMN_NA  = 'STATUS_CODE'                                  
MFA-TR*         AND COMPANY_NO = '01'                                           
MFA-TR*         AND CODE_VALUE = :UV-CODE-VALUE                                 
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7400                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7400 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7400-GET-PAYMENT-STATUS'         
              DISPLAY '**  SQL STATUS         = ' WS-ACTIVE-RETURN-CODE 
              DISPLAY '**  COMPANY NO         = ' C7-COMPANY-NO         
              DISPLAY '**  CODE VALUE         = ' UV-CODE-VALUE         
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
ACT214*                                                                         
ACT214******************************************************************        
ACT214* READS THE CSS_DELINQUENCY TABLE                                *03500000
ACT214******************************************************************        
ACT214 7500-GET-DELIQUENCY-VALUES.                                      
ACT214*                                                                         
ACT214     EXEC SQL                                                     
ACT214         SELECT TOP(1) DELINQ_VALUE                                     
ACT214           INTO                                                   
ACT214                 :C8-DELINQ-VALUE                                 
ACT214           FROM                                                   
ACT214                 CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                 
ACT214          WHERE                                                   
ACT214                 C8.DELINQ_CD    = :C8-DELINQ-CD                  
ACT214                                                           
ACT214                                                      
ACT214                                              
ACT214     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*                DELINQ_VALUE                                             
MFA-TR*          INTO                                                           
MFA-TR*                :C8-DELINQ-VALUE                                         
MFA-TR*          FROM                                                           
MFA-TR*                CSS_DELINQUENCY C8                                       
MFA-TR*         WHERE                                                           
MFA-TR*                C8.DELINQ_CD    = :C8-DELINQ-CD                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT214*                                                                         
ACT214     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT214*                                                                         
ACT214     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT214        CONTINUE                                                  
ACT214     ELSE                                                         
ACT214        DISPLAY '7500 ' WS-ACTIVE-RETURN-CODE                     
ACT214        DISPLAY '*************************************'           
ACT214        DISPLAY '**  PROCESSING ERROR'                            
ACT214        DISPLAY '**  PARAGRAPH = 7500-GET-DELIQUENCY-VALUES'      
ACT214        DISPLAY '**  SQL STATUS         = ' WS-ACTIVE-RETURN-CODE 
ACT214        DISPLAY '**  C8-DELINQ-CD       = ' C8-DELINQ-CD          
ACT214        DISPLAY '**  PROCESSING TERMINATED'                       
ACT214        DISPLAY '*************************************'           
ACT214        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT214     END-IF.                                                      
ACT214*                                                                         
ACT214 7500-EXIT.                                                       
ACT214     EXIT.                                                        
      *                                                                         
      *----------------------------------------------------------------*        
      * UPDATES THE PAYMENT STATUS TO CANCELLED                        *        
      *----------------------------------------------------------------*        
       8000-CANCEL-PYMT.                                                
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_PNDNG_CARD_PMT                                  
                SET STATUS_CODE        = 'X'                            
                   ,CANCELLED_TS       = CIS.CURRENT$TIMESTAMP()              
                   ,PMT_CANCEL_REAS_CD = :PC-PMT-CANCEL-REAS-CD         
              WHERE ACCOUNT_NO         = :PC-ACCOUNT-NO                 
                AND PAYMENT_DATE       = IIF(TRY_CONVERT(DATE, 
                                                       :PC-PAYMENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PC-PAYMENT-DATE
              ) <> 0) OR (LEN(:PC-PAYMENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :PC-PAYMENT-DATE
              ), CONVERT(DATE, :PC-PAYMENT-DATE) )               
                AND PAYMENT_AMT        = :PC-PAYMENT-AMT                
                AND STATUS_CODE        = :PC-STATUS-CODE                
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_PNDNG_CARD_PMT                                          
MFA-TR*         SET STATUS_CODE        = 'X'                                    
MFA-TR*            ,CANCELLED_TS       = CURRENT TIMESTAMP                      
MFA-TR*            ,PMT_CANCEL_REAS_CD = :PC-PMT-CANCEL-REAS-CD                 
MFA-TR*       WHERE ACCOUNT_NO         = :PC-ACCOUNT-NO                         
MFA-TR*         AND PAYMENT_DATE       = :PC-PAYMENT-DATE                       
MFA-TR*         AND PAYMENT_AMT        = :PC-PAYMENT-AMT                        
MFA-TR*         AND STATUS_CODE        = :PC-STATUS-CODE                        
MFA-TR*     QUERYNO 8000                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE 'X'   TO PC-STATUS-CODE                              
           ELSE                                                         
              DISPLAY '8000 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 8000-CANCEL-PYMT'                
              DISPLAY '**  SQL STATUS       = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  ACCOUNT-NO       = ' AC195-DET-ACCT-NO       
              DISPLAY '**  PAYMENT-DATE     = ' AC195-DET-DATE          
              DISPLAY '**  PAYMENT-AMOUNT   = ' AC195-DET-AMOUNT        
              DISPLAY '**  STATUS-CODE      = ' PC-STATUS-CODE          
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSES ALL OPEN FILES                                          *        
      *                                                                *        
      *----------------------------------------------------------------*        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           CLOSE FCSAC195-FILE                                          
                                                                        
           IF  FAC195-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**PCSAC195   PROCESSING ERROR  **'              
               DISPLAY '9000-ERROR ON FCSAC145 CLOSE.  STATUS IS '      
                       WS-FAC195-STATUS                                 
           END-IF                                                       
                                                                        
           CLOSE FCSPT33-FILE                                           
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * COPYBOOK TO READ PARM FILE FOR OVERRIDE RUN DATE                        
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
                                                                        
      * CURSOR DECLARATION FOR OVERRIDE RUN DATE                                
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
                                                                        
      * ABEND ROUTINE                                                           
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
