       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSAC194.                                            
       AUTHOR. BASKAR VANNI.                                            
       DATE-WRITTEN. MARCH 2012.                                        
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *      DATE       INITIALS   REASON                             *         
      *    ==========   =========  ================================   *         
P00547*    03/30/2012   BASKAR V   NEW PROGRAM                        *         
P00547*    11/13/2013   BASKAR V   UPDATE FIOCA192 FILE FOR EXCEPTION *         
      *                            RECORD ALSO                        *         
ACT268*    08/31/2016   BD09555    REMOVE CBL ADV                     *         
ACT268*A05460-ACT268                                                  *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
      *---------------------------------------------------------------*         
      * THIS PROGRAM SPLITS ALL THE IAT (INTERNATIONAL ACH)           *         
      * PAYMENTS FROM DRAFT FILE AND CREATE A NEW FILE FOR IAT        *         
      * PAYMENTS. THIS PROGRAM ALSO UPDATES THE DRAFT REPORT FILE FOR *         
      * IAT TRANSACTIONS.                                             *         
      *---------------------------------------------------------------*         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.                                                 
       OBJECT-COMPUTER.                                                 
       SPECIAL-NAMES.                                                   
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
           COPY CSSAC03.                                                        
           COPY CSSDRFT.                                                        
           SELECT FCSIAT-FILE                                           
               ASSIGN TO UT-S-FCSIAT                                    
               FILE STATUS IS WS-FACIAT-STATUS.                         
                                                                        
           SELECT FCSCA192-FILE                                         
               ASSIGN TO UT-FCSCA192                                    
               ORGANIZATION IS SEQUENTIAL                               
               ACCESS MODE IS SEQUENTIAL                                
               FILE STATUS IS WS-FCA192-STATUS.                         
                                                                        
      ***************************************************************           
      *  CSSPT33 - SELECT STATEMENT FOR OUTPUT REPORT FILE - 133 CHR*           
      ***************************************************************           
       COPY CSSPT33.                                                            
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
      *-------------------------------------------------------------*           
      *         FD FOR BANK DRAFT INPUT FILE                        *           
      *-------------------------------------------------------------*           
       COPY CFDAC03.                                                            
                                                                        
      *-------------------------------------------------------------*           
      *         THIS FILE CONTAINS BANKDRAFT RECORDS                *           
      *-------------------------------------------------------------*           
       COPY FIOAC03B.                                                           
                                                                        
      *-------------------------------------------------------------*           
      *         FD FOR BANK DRAFT OUTPUT FILE                       *           
      *-------------------------------------------------------------*           
       COPY CFDCADFT.                                                           
       01   FIOCADFT.                                                   
            03  CSHCNACH-OUTPUT-DRAFT          PIC X(105).              
                                                                        
       FD  FCSIAT-FILE                                                  
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
                                                                        
      *-------------------------------------------------------------*           
      *         THIS FILE CONTAINS INTERNATIONAL ACH RECORDS        *           
      *-------------------------------------------------------------*           
       COPY FIOIAT.                                                             
                                                                        
       FD  FCSCA192-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 177 CHARACTERS                               
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
      *-------------------------------------------------------------*           
      *         THIS FILE CONTAINS REPORT FILE LAYOUT               *           
      *-------------------------------------------------------------*           
       COPY FIOCA192.                                                           
                                                                        
      ***************************************************************           
      *  CFDPT33 - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE       *           
      ***************************************************************           
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC194'.
MSQ017     COPY MFASQLM.
       01  WS-COUNTERS.                                                 
           05 WS-TRACE-IAT-SEQ-NO       PIC S9(06) COMP-3 VALUE +0.     
           05 WS-TRACE-DRAFT-SEQ-NO     PIC S9(06) COMP-3 VALUE +0.     
           05 WS-TOTAL-IAT-TYPE6        PIC 9(06)  VALUE 0.             
           05 WS-TOTAL-IAT-CNT          PIC 9(06)  VALUE 0.             
           05 WS-TOTAL-DRAFT-TYPE6      PIC 9(06)  VALUE 0.             
           05 WS-IAT-REC-WRITTEN        PIC S9(06) COMP-3 VALUE +0.     
           05 WS-DRAFT-REC-WRITTEN      PIC S9(06) COMP-3 VALUE +0.     
           05 WS-EXCEP-CNT              PIC  9(04) VALUE 0.             
                                                                        
       01  WS-TOTALS.                                                   
           05 WS-TOTAL-IAT-HASH         PIC S9(13) COMP-3 VALUE +0.     
           05 WS-TOTAL-DRAFT-HASH       PIC S9(13) COMP-3 VALUE +0.     
           05 WS-TOTAL-IAT-DEBIT        PIC S9(13)V99 COMP-3 VALUE +0.  
           05 WS-TOTAL-DRAFT-DEBIT      PIC S9(13)V99 COMP-3 VALUE +0.  
           05 WS-EXCEP-AMOUNT           PIC S9(13)V99 COMP-3 VALUE +0.  
                                                                        
       01  WS-CONSTANTS.                                                
           05 WS-PGRMNAME               PIC X(08) VALUE 'PCSAC194'.     
           05 WS-PGMNAME                PIC X(08) VALUE 'PCSAC194'.     
           05 WS-COMPANY-ID             PIC X(10) VALUE '2570248695'.   
           05 WS-Y                      PIC X(01) VALUE 'Y'.            
           05 WS-N                      PIC X(01) VALUE 'N'.            
           05 WS-01                     PIC X(02) VALUE '01'.           
           05 WS-DATABASE               PIC X(08) VALUE 'DATABASE'.     
           05 DELIMITER-SPACE           PIC X(03) VALUE '   '.          
           05 WS-FIFTY-FIVE             PIC 9(02) VALUE 55.             
           05 WS-ZERO                   PIC 9(01) VALUE 0.              
           05 WS-ONE                    PIC 9(01) VALUE 1.              
           05 WS-TWO                    PIC 9(01) VALUE 2.              
           05 WS-SIX                    PIC 9(01) VALUE 6.              
                                                                        
       01  WS-VARIABLES.                                                
           05 WS-IMMED-DEST             PIC X(10).                      
           05 WS-DESTINATION            PIC X(23) VALUE SPACES.         
           05 WS-GO-ODFI-IDENT          PIC 9(08).                      
           05 WS-CENTURY                PIC X(02).                      
           05 WS-ACCOUNT-NO             PIC X(13).                      
           05 WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                 
                                        PIC 9(13).                      
           05 WS-WORK-CNT               PIC 9(06).                      
           05 WS-WORK-CNT-DIGIT REDEFINES WS-WORK-CNT.                  
              10 WS-WORK-CNT-DIGIT5     PIC 9(05).                      
              10 WS-WORK-CNT-DIGIT6     PIC 9(01).                      
           05 WS-PAGE-NUM               PIC 9(04) VALUE ZEROES.         
           05 WS-LINE-SPACE             PIC 9(02) VALUE ZEROES.         
           05 WS-LINE-DIFF              PIC 9(03) VALUE ZEROES.         
           05 WS-LINE-CNTR              PIC 9(03) VALUE 56.             
           05 WS-COUNTRY.                                               
              10 WS-CNTRY-CD            PIC X(02) VALUE SPACES.         
              10 FILLER                 PIC X(01) VALUE SPACES.         
                                                                        
       01  WS-BKD-DATE.                                                 
           05 WS-BKD-DATE-CC            PIC X(02).                      
           05 WS-BKD-DATE-YY            PIC X(02).                      
           05 FILLER                    PIC X(01) VALUE '-'.            
           05 WS-BKD-DATE-MM            PIC X(02).                      
           05 FILLER                    PIC X(01) VALUE '-'.            
           05 WS-BKD-DATE-DD            PIC X(02).                      
       01  WS-SWITCHES.                                                 
           05 WS-EOF-FLAG               PIC X(01) VALUE 'N'.            
              88 END-OF-FILE                      VALUE 'Y'.            
           05 WS-FAC03-STATUS           PIC X(02).                      
              88 FAC03-SUCCESSFUL                 VALUE '00'.           
           05 WS-FACIAT-STATUS          PIC X(02).                      
              88 FACIAT-SUCCESSFUL                VALUE '00'.           
           05 WS-FCADFT-STATUS          PIC X(02).                      
              88 FCADFT-SUCCESSFUL                VALUE '00'.           
           05 WS-FCA192-STATUS          PIC X(02).                      
              88 FCA192-SUCCESSFUL                VALUE '00'.           
              88 FCA192-NOT-FOUND                 VALUE '23'.           
              88 FCA192-END-OF-FILE               VALUE '10'.           
           05 WS-DATABASE-SW            PIC 9(01) VALUE 0.              
              88 CSR-DATABASE                     VALUE 1.              
              88 SEB-DATABASE                     VALUE 2.              
           05 WS-EXCEPTION-SW           PIC X(01) VALUE 'B'.            
              88 EXCEPTION-FOUND                  VALUE 'A'.            
              88 EXCEPTION-NOT-FOUND              VALUE 'B'.            
                                                                        
       01 WS-RPT-HDR1.                                                  
          05 FILLER                           PIC X(1)  VALUE SPACES.   
          05 WS-RPT-ID                        PIC X(8).                 
          05 FILLER                           PIC X(34) VALUE SPACES.   
          05 WS-COMPANY-NAME                  PIC X(39) VALUE SPACES.   
          05 FILLER                           PIC X(28) VALUE SPACES.   
          05 FILLER                           PIC X(10) VALUE           
                                                  'RUN-DATE :'.         
          05 WS-RPT-DATE                      PIC X(10).                
                                                                        
       01 WS-RPT-HDR2.                                                  
          05 FILLER                           PIC X(37) VALUE SPACES.   
          05 FILLER                           PIC X(38) VALUE           
                        ' IAT FOREIGN ADDRESS ERROR    '.               
          05 FILLER                           PIC X(35) VALUE SPACES.   
          05 FILLER                           PIC X(12) VALUE           
                                                  'RUN-TIME :  '.       
          05 WS-RPT-TIME                      PIC X(08).                
                                                                        
       01 WS-PAGE-HDR.                                                  
          05 FILLER                           PIC X(110) VALUE SPACES.  
          05 FILLER                           PIC X(10) VALUE           
                                                  'PAGE-NO  :'.         
          05 FILLER                           PIC X(06) VALUE SPACES.   
          05 WS-PAGE-NO                       PIC ZZZ9  VALUE '00'.     
          05 FILLER                           PIC X(05) VALUE SPACES.   
                                                                        
       01 WS-RPT-LINE.                                                  
          05 FILLER                           PIC X(132) VALUE ALL '-'. 
                                                                        
       01 WS-RPT-HDR3.                                                  
          05 FILLER                           PIC X(2)  VALUE SPACES.   
          05 FILLER                           PIC X(14) VALUE           
                                                  '  ACCOUNT NO  '.     
          05 FILLER                           PIC X(3)  VALUE SPACES.   
          05 FILLER                           PIC X(14) VALUE           
                                                  'PAYMENT AMOUNT'.     
          05 FILLER                           PIC X(03) VALUE SPACES.   
          05 FILLER                           PIC X(32) VALUE           
                                                  'FOREIGN CITY'.       
          05 FILLER                           PIC X(03) VALUE SPACES.   
          05 FILLER                           PIC X(16) VALUE           
                                                  'FOREIGN PROVINCE'.   
          05 FILLER                           PIC X(03) VALUE SPACES.   
          05 FILLER                           PIC X(17) VALUE           
                                                  'FOREIGN POST CODE'.  
          05 FILLER                           PIC X(24) VALUE SPACES.   
                                                                        
       01 WS-RPT-DTL.                                                   
          05 FILLER                           PIC X(2)  VALUE SPACES.   
          05 WS-RPT-ACCT-NO                   PIC X(13) VALUE SPACES.   
          05 FILLER                           PIC X(5)  VALUE SPACES.   
          05 WS-RPT-PYMT-AMT                  PIC Z(7).99 VALUE SPACES. 
          05 FILLER                           PIC X(05) VALUE SPACES.   
          05 WS-RPT-CITY                      PIC X(40) VALUE SPACES.   
          05 FILLER                           PIC X(03) VALUE SPACES.   
          05 WS-RPT-PROVINCE                  PIC X(10) VALUE SPACES.   
          05 FILLER                           PIC X(09) VALUE SPACES.   
          05 WS-RPT-POST-CODE                 PIC X(26) VALUE SPACES.   
          05 FILLER                           PIC X(08) VALUE SPACES.   
                                                                        
       01 WS-RPT-EXCEP-MSG.                                             
          05 FILLER                           PIC X(06) VALUE SPACES.   
          05 FILLER                           PIC X(19) VALUE           
                                              'EXCEPTION ACCOUNT: '.    
          05 WS-RPT-EXCEP-CNT                 PIC ---,--9.              
          05 FILLER                           PIC X(04) VALUE SPACES.   
          05 FILLER                           PIC X(17) VALUE           
                                              'EXCEPTION AMOUNT:'.      
          05 WS-RPT-EXCEP-AMOUNT              PIC --,---,---,--9.99.    
          05 FILLER                           PIC X(58) VALUE SPACES.   
                                                                        
                                                                        
       01 WS-RPT-FTR.                                                   
          05 FILLER                            PIC X(32) VALUE SPACES.  
          05 FILLER                            PIC X(25) VALUE          
                                           '**** END OF REPORT ****'.   
          05 FILLER                            PIC X(75) VALUE SPACES.  
                                                                        
       01 WS-NO-DATA-REC.                                               
          05 FILLER                            PIC X(32) VALUE SPACES.  
          05 FILLER                            PIC X(25) VALUE          
                                           '**** NO DATA FOUND ****'.   
          05 FILLER                            PIC X(75) VALUE SPACES.  
                                                                        
      *                                                                         
      *===============================================================*         
      * SQL COMMUNICATION AREA                                        *         
      *===============================================================*         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_COMPANY - C7                                           *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_ACCOUNT                                                *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBACCT                                                      
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_ADDR_FREEFORM                                          *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBADRFRE                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_JOB_PARM                                               *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBJBPARM                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_BUSINESS_DAYS                                          *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBBUSDAY                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_COUNTRY                                                *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCONTRY                                                    
           END-EXEC.                                                            
                                                                        
      * CSS_DELINQUENCY                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      * JOB PARM RUN DATE VARIABLES                                             
       COPY FIOJC01.                                                            
                                                                        
      * DB2 AND SQL ERROR CHECKING VARIABLES                                    
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK.                                                  
       COPY CWS09900.                                                           
                                                                        
      * MISC VARIABLE DECLARATION                                               
       COPY CWS00038.                                                           
                                                                        
       LINKAGE SECTION.                                                 
       PROCEDURE DIVISION.                                              
      *----------------------------------------------------------------*        
      *                          M A I N L I N E                       *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-INPUT                                   
              THRU 1000-EXIT UNTIL  END-OF-FILE                         
                                                                        
           IF WS-EXCEP-CNT = 0                                          
              PERFORM 2965-PRINT-REPORT-HEADER                          
                 THRU 2965-EXIT                                         
                                                                        
              MOVE  WS-NO-DATA-REC        TO PRT33-DATA                 
              PERFORM 2985-WRITE-RECORD                                 
                 THRU 2985-EXIT                                         
           END-IF                                                       
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           DISPLAY '                     '                              
           DISPLAY 'TOTAL DRAFT ACCOUNT: ' WS-TOTAL-DRAFT-TYPE6         
           DISPLAY ' TOTAL DRAFT AMOUNT: ' WS-TOTAL-DRAFT-DEBIT         
           DISPLAY '                     '                              
           DISPLAY '  TOTAL IAT ACCOUNT: ' WS-TOTAL-IAT-CNT             
           DISPLAY '   TOTAL IAT AMOUNT: ' WS-TOTAL-IAT-DEBIT           
           DISPLAY '                     '                              
           DISPLAY 'TOTAL IAT EXCEPTION ACCOUNT: ' WS-EXCEP-CNT         
           DISPLAY ' TOTAL IAT EXCEPTION AMOUNT: ' WS-EXCEP-AMOUNT      
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   OPENS ALL INPUT AND OUTPUT FILES AND FINDS THE RUN DATE      *        
      *                                                                *        
      *----------------------------------------------------------------*        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-01                        TO C8-COMPANY-NO           
           MOVE WS-DATABASE                  TO C8-DELINQ-CD            
           PERFORM 7400-GET-DELINQ-VALUE     THRU 7400-EXIT             
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE-SW          
                                                                        
      * OPEN THE INPUT DRAFT FILE                                               
           OPEN INPUT FCSAC03-FILE                                      
                                                                        
           IF  FAC03-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** PCSAC194  PROCESSING ERROR  **'              
               DISPLAY '0100-ERROR ON FCSAC03 OPEN.  STATUS IS '        
                       WS-FAC03-STATUS                                  
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF                                                       
                                                                        
      * OPEN THE OUTPUT DRAFT FILE                                              
           OPEN OUTPUT FCSCADFT-FILE                                    
                                                                        
           IF  FCADFT-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** PCSAC194  PROCESSING ERROR  **'              
               DISPLAY ' ERROR ON FCSCADRT OPEN.  STATUS IS '           
                       WS-FCADFT-STATUS                                 
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF                                                       
                                                                        
           OPEN OUTPUT FCSIAT-FILE                                      
                                                                        
           IF  FACIAT-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** PCSAC194  PROCESSING ERROR  **'              
               DISPLAY '0100-ERROR ON FCSIAT OPEN.  STATUS IS '         
                       WS-FACIAT-STATUS                                 
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF                                                       
                                                                        
           OPEN I-O FCSCA192-FILE                                       
                                                                        
           IF  FCA192-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** PCSAC194  PROCESSING ERROR  **'              
               DISPLAY '0100-ERROR ON FCSCA192 OPEN.  STATUS IS '       
                       WS-FCA192-STATUS                                 
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF                                                       
                                                                        
           PERFORM 7100-READ-FCSCA192                                   
              THRU 7100-EXIT                                            
                                                                        
           OPEN OUTPUT FCSPT33-FILE                                     
                                                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                   
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES     TO WS-INPUT-AREA                          
              MOVE SPACES     TO WS-INPUT-DATA-BREAKDOWN                
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
              MOVE 'PCSAC194' TO WS-PGRMNAME                            
           END-IF                                                       
                                                                        
           PERFORM 0200-CHECK-FCSCA192-DATE                             
              THRU 0200-EXIT                                            
                                                                        
           MOVE WS-PGRMNAME   TO WS-RPT-ID                              
                                                                        
           PERFORM 7650-GET-CURRENT-DATE                                
              THRU 7650-EXIT                                            
                                                                        
           MOVE '01'            TO C7-COMPANY-NO                        
           PERFORM 7700-GET-COMPANY-NAME                                
              THRU 7700-EXIT                                            
           MOVE C7-COMPANY-NAME TO WS-COMPANY-NAME                      
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * VERIFIES WHETHER WE ARE USING THE CORRECT REPORT FILE TO UPDATE*        
      * IAT DETAILS.                                                   *        
      *----------------------------------------------------------------*        
       0200-CHECK-FCSCA192-DATE.                                        
                                                                        
           PERFORM 7300-SELECT-PREV-BUSINESS-DATE                       
              THRU 7300-EXIT                                            
                                                                        
           IF E-FCA192-CREATE-DATE-BREC = 1G-BUSINESS-DAY-DT            
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '  '                                              
              DISPLAY '** PCSAC194 PROCESSING ERROR '                   
              DISPLAY '** DATE ON BANKDRAFT REPORT FILE ('              
                      E-FCA192-CREATE-DATE-BREC                         
                     ') DOES NOT MATCH PREVIOUS BUSINESS DATE ('        
                      1G-BUSINESS-DAY-DT                                
              DISPLAY '** PROCESSING TERMINATED '                       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *       VALIDATE INPUT DATE IN THE BANKDRAFT HEADER              *        
      *----------------------------------------------------------------*        
       0700-PROCESS-BKD-HEADER.                                         
                                                                        
           MOVE WS-INPUT-DATE(1:2)        TO WS-BKD-DATE-CC             
           MOVE CSHCNACH-1-FILE-CREATE-YY TO WS-BKD-DATE-YY             
           MOVE CSHCNACH-1-FILE-CREATE-MM TO WS-BKD-DATE-MM             
           MOVE CSHCNACH-1-FILE-CREATE-DD TO WS-BKD-DATE-DD             
                                                                        
           IF WS-INPUT-DATE NOT = WS-BKD-DATE                           
              DISPLAY '  '                                              
              DISPLAY '** PCSAC194 PROCESSING ERROR '                   
              DISPLAY '** DATE ON BANKDRAFT HEADER (' WS-BKD-DATE       
                     ') DOES NOT MATCH RUN DATE (' WS-INPUT-DATE        
              DISPLAY '** PROCESSING TERMINATED '                       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       0700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE SPACES TO CSHCNACH-OUTPUT-RECORD                        
                                                                        
           PERFORM 1100-READ-RECORDS                                    
              THRU 1100-EXIT                                            
                                                                        
           PERFORM 1200-VALIDATE-RECORDS                                
              THRU 1200-EXIT                                            
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *                                                                *        
      *       READS THE INPUT DRAFT FILE                               *        
      *----------------------------------------------------------------*        
       1100-READ-RECORDS.                                               
                                                                        
           READ FCSAC03-FILE                                            
             AT END MOVE WS-Y     TO WS-EOF-FLAG                        
                                                                        
           IF FAC03-SUCCESSFUL                                          
              MOVE CSHCNACH-OUTPUT-RECORD TO CSHCNACH-OUTPUT-DRAFT      
           ELSE                                                         
              IF END-OF-FILE                                            
                 MOVE SPACES      TO CSHCNACH-OUTPUT-RECORD             
              ELSE                                                      
                 DISPLAY 'ERROR ON READING FCSAC03'                     
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND           THRU 9900-EXIT            
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *                                                                *        
      * SPLITS THE IAT PAYMENTS FROM DRAFT PAYMENT FILE AND WRITES THE *        
      * IAT PAYMENTS IN TO A NEW FILE.                                 *        
      *----------------------------------------------------------------*        
       1200-VALIDATE-RECORDS.                                           
                                                                        
           EVALUATE  CSHCNACH-RECORD-TYPE                               
                                                                        
              WHEN '1'                                                  
                  PERFORM 0700-PROCESS-BKD-HEADER                       
                     THRU 0700-EXIT                                     
                                                                        
                  PERFORM 8000-WRITE-DRAFT                              
                     THRU 8000-EXIT                                     
                                                                        
                  PERFORM 2050-PREPARE-TYPE-1-IAT                       
                     THRU 2050-EXIT                                     
                                                                        
                  PERFORM 8100-WRITE-IAT                                
                     THRU 8100-EXIT                                     
                                                                        
              WHEN '5'                                                  
                  PERFORM 8000-WRITE-DRAFT                              
                     THRU 8000-EXIT                                     
                                                                        
                  PERFORM 2100-PREPARE-TYPE-5-IAT                       
                     THRU 2100-EXIT                                     
                                                                        
                  PERFORM 8100-WRITE-IAT                                
                     THRU 8100-EXIT                                     
                                                                        
              WHEN '6'                                                  
                                                                        
                  PERFORM 7200-READ-NEXT-FCSCA192                       
                     THRU 7200-EXIT                                     
                                                                        
                  MOVE CSHCNACH-6-ID-NBR(1:13) TO WS-ACCOUNT-NO         
                  MOVE WS-ACCOUNT-NO-NUM       TO AT-ACCOUNT-NO         
                                                                        
                  PERFORM 7000-CHECK-COUNTRY                            
                     THRU 7000-EXIT                                     
                                                                        
                  IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL        
                                                                        
                    IF DZ-INTRNTNL-CITY > SPACES AND                    
                       DZ-INTRNTNL-PROVINCE > SPACES AND                
                       DZ-INTRNTNL-POST-CODE > SPACES                   
                       PERFORM 2200-PREPARE-TYPE-6-IAT                  
                          THRU 2200-EXIT                                
                                                                        
                       PERFORM 8100-WRITE-IAT                           
                          THRU 8100-EXIT                                
                                                                        
                       PERFORM 2700-PROCESS-ADDENDA-RECS                
                          THRU 2700-EXIT                                
                                                                        
                       PERFORM 2500-CHANGE-REPORT-FILE                  
                          THRU 2500-EXIT                                
                    ELSE                                                
                       IF E-FCA192-COMPANY-NO = AT-COMPANY-NO AND       
                          E-FCA192-ACCOUNT-NO = CSHCNACH-6-ID-NBR       
                                                                        
                          MOVE ' ' TO E-FCA192-ACTION-CODE              
                          PERFORM 8200-UPDATE-FIOCA192                  
                             THRU 8200-EXIT                             
                                                                        
                       END-IF                                           
                       SET EXCEPTION-FOUND TO TRUE                      
                                                                        
                       PERFORM 2800-PROCESS-EXCEP-REPORT                
                          THRU 2800-EXIT                                
                    END-IF                                              
                  ELSE                                                  
                                                                        
                    PERFORM 2150-PREPARE-TYPE-6-DRAFT                   
                       THRU 2150-EXIT                                   
                                                                        
                    PERFORM 8000-WRITE-DRAFT                            
                       THRU 8000-EXIT                                   
                  END-IF                                                
              WHEN '8'                                                  
                                                                        
                  PERFORM 2250-PREPARE-TYPE-8-DRAFT                     
                     THRU 2250-EXIT                                     
                                                                        
                  PERFORM 8000-WRITE-DRAFT                              
                     THRU 8000-EXIT                                     
                                                                        
                  PERFORM 2300-PREPARE-TYPE-8-IAT                       
                     THRU 2300-EXIT                                     
                                                                        
                  PERFORM 8100-WRITE-IAT                                
                     THRU 8100-EXIT                                     
                                                                        
              WHEN '9'                                                  
                  PERFORM 2350-PREPARE-TYPE-9-DRAFT                     
                     THRU 2350-EXIT                                     
                                                                        
                  PERFORM 8000-WRITE-DRAFT                              
                     THRU 8000-EXIT                                     
                                                                        
                  PERFORM 2400-PREPARE-TYPE-9-IAT                       
                     THRU 2400-EXIT                                     
                                                                        
                  PERFORM 8100-WRITE-IAT                                
                     THRU 8100-EXIT                                     
                                                                        
                  IF EXCEPTION-FOUND                                    
                     PERFORM 2990-PRINT-REPORT-TRAILER                  
                        THRU 2990-EXIT                                  
                  END-IF                                                
                                                                        
           END-EVALUATE                                                 
           .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * MOVE VALUES TO IAT FILE HEADER RECORD                          *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2050-PREPARE-TYPE-1-IAT.                                         
           MOVE 1                            TO IAT-1-RECORD-TYPE       
           MOVE '01'                         TO IAT-1-PRIORITY          
           MOVE CSHCNACH-1-FILE-CREATE-DT    TO IAT-1-CREATE-DATE       
           MOVE CSHCNACH-1-FILE-CREATE-TIME  TO IAT-1-CREATE-TIME       
           MOVE 'A'                          TO IAT-1-FILE-ID           
           MOVE 094                          TO IAT-1-RECORD-SIZE       
           MOVE 10                           TO IAT-1-BLOCK-FACTOR      
           MOVE 1                            TO IAT-1-FORMAT            
           MOVE CSHCNACH-1-IMMED-ORIGIN-NAME TO IAT-1-ORIGIN            
           MOVE 'IAT     '                   TO IAT-1-REFERENCE         
           MOVE SPACES                       TO C8-DESCRIPTION-TEXT     
           MOVE WS-01                        TO C8-COMPANY-NO           
           MOVE 'IAT-IMMED-DEST'             TO C8-DELINQ-CD            
           PERFORM 7400-GET-DELINQ-VALUE     THRU 7400-EXIT             
           MOVE C8-DESCRIPTION-TEXT(1:10)    TO IAT-1-IMMED-DEST        
                                                WS-IMMED-DEST           
           IF SEB-DATABASE                                              
              MOVE C8-DESCRIPTION-TEXT(2:09) TO WS-IMMED-DEST           
           END-IF                                                       
                                                                        
           MOVE C8-DESCRIPTION-TEXT(12:19)   TO IAT-1-DESTINATION       
                                                WS-DESTINATION          
                                                                        
           MOVE SPACES                       TO C8-DESCRIPTION-TEXT     
           MOVE 'IAT-IMMED-ORIG'             TO C8-DELINQ-CD            
           PERFORM 7400-GET-DELINQ-VALUE     THRU 7400-EXIT             
           MOVE C8-DESCRIPTION-TEXT(1:10)    TO WS-COMPANY-ID           
                                                IAT-1-IMMED-ORIGIN      
           IF SEB-DATABASE                                              
              MOVE '0570784499'              TO IAT-1-IMMED-ORIGIN      
           END-IF                                                       
           .                                                            
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * MOVE VALUES TO IAT BATCH FILE HEADER RECORD                    *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2100-PREPARE-TYPE-5-IAT.                                         
           MOVE 5                          TO IAT-5-RECORD-TYPE         
           MOVE 225                        TO IAT-5-SERVICE-CLASS-CODE  
           MOVE SPACES                     TO IAT-5-IAT-INDICATOR       
           MOVE 'FF'                       TO IAT-5-FOREIGN-EXCHANGE-IND
           MOVE 3                                                       
             TO IAT-5-FOREIGN-EXCHANGE-REF-IND                          
           MOVE SPACES                     TO IAT-5-FOREIGN-EXCHANGE-REF
           MOVE WS-COMPANY-ID              TO IAT-5-ORIGINATOR-IDENT    
           MOVE 'US'                       TO IAT-5-ISO-DEST-COUNTRY    
           MOVE 'IAT'                      TO IAT-5-ENTRY-CLASS-CODE    
           MOVE 'SCANA PYMT'               TO IAT-5-COMPANY-ENTRY-DESC  
           MOVE 'USD'                      TO IAT-5-ISO-ORIG-CURR       
           MOVE 'USD'                      TO IAT-5-ISO-DEST-CURR       
           MOVE CSHCNACH-5-CO-EFF-DATE     TO IAT-5-EFFECT-ENTRY-DATE   
           MOVE SPACES                     TO IAT-5-SETTLEMENT-DATE     
           MOVE 1                          TO IAT-5-ORIGINATOR-STATUS   
           MOVE 1                          TO IAT-5-BATCH-NUMBER        
                                                                        
           MOVE WS-01                      TO C8-COMPANY-NO             
           MOVE 'IAT-GO-ODFI-IDENT'        TO C8-DELINQ-CD              
           PERFORM 7400-GET-DELINQ-VALUE   THRU 7400-EXIT               
           MOVE C8-DESCRIPTION-TEXT(1:8)   TO IAT-5-GO-ODFI-IDENT       
                                              WS-GO-ODFI-IDENT          
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * MOVE VALUES TO DRAFT PAYMENT DETAIL RECORD                     *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2150-PREPARE-TYPE-6-DRAFT.                                       
           ADD  1                           TO WS-TRACE-DRAFT-SEQ-NO    
                                               WS-TOTAL-DRAFT-TYPE6     
           ADD  CSHCNACH-6-TRANSITR-8       TO WS-TOTAL-DRAFT-HASH      
           ADD  CSHCNACH-6-DRAFT-AMT        TO WS-TOTAL-DRAFT-DEBIT     
           MOVE WS-TRACE-DRAFT-SEQ-NO       TO CSHCNACH-6-TRACE-SEQ     
           .                                                            
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *----------------------------------------------------------------*        
      * MOVE VALUES TO IAT PAYMENT DETAIL RECORD                       *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2200-PREPARE-TYPE-6-IAT.                                         
           MOVE 6                           TO IAT-6-RECORD-TYPE        
           MOVE CSHCNACH-6-TRANSACTION-CODE TO IAT-6-TRANSACTION-CODE   
           MOVE CSHCNACH-6-TRANSITR         TO IAT-6-ROUTING-NUM        
           MOVE 7                           TO IAT-6-NO-ADDENDA-RECORDS 
           MOVE CSHCNACH-6-DRAFT-AMT        TO IAT-6-AMOUNT             
           MOVE CSHCNACH-6-BANK-ACCT-NBR    TO IAT-6-FOREIGN-RCVRS-ACCT 
           MOVE SPACES                      TO IAT-6-OFAC-SCR-INDICATOR 
           MOVE SPACES                                                  
             TO IAT-6-SECONDARY-OFAC-SCR-IND                            
           MOVE '1'                         TO IAT-6-ADDENDA-RECORD-IND 
           MOVE WS-GO-ODFI-IDENT            TO IAT-6-TRACE-TRANSIT      
           ADD  1                           TO WS-TRACE-IAT-SEQ-NO      
                                               WS-TOTAL-IAT-TYPE6       
                                               WS-TOTAL-IAT-CNT         
           MOVE WS-TRACE-IAT-SEQ-NO         TO IAT-6-TRACE-SEQ          
           ADD  CSHCNACH-6-TRANSITR-8       TO WS-TOTAL-IAT-HASH        
           ADD  CSHCNACH-6-DRAFT-AMT        TO WS-TOTAL-IAT-DEBIT       
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * MOVE VALUES TO DRAFT BATCH TRAILER RECORD                      *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2250-PREPARE-TYPE-8-DRAFT.                                       
           MOVE WS-TOTAL-DRAFT-TYPE6 TO CSHCNACH-8-ENTRY-ADDENDA-COUNT  
           MOVE WS-TOTAL-DRAFT-HASH  TO CSHCNACH-8-ENTRY-HASH           
           MOVE WS-TOTAL-DRAFT-DEBIT TO CSHCNACH-8-TOTAL-DEBIT          
           MOVE ZERO                 TO CSHCNACH-8-TOTAL-CREDIT         
           MOVE 1                    TO CSHCNACH-8-BATCH-NBR            
           .                                                            
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * MOVE VALUES TO IAT BATCH TRAILER/TOTAL RECORD                  *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2300-PREPARE-TYPE-8-IAT.                                         
           MOVE 8                            TO IAT-8-RECORD-TYPE       
           MOVE 225                          TO IAT-8-SERVICE-CLASS     
           MOVE WS-TOTAL-IAT-TYPE6           TO IAT-8-ADDENDA-COUNT     
           MOVE WS-TOTAL-IAT-HASH            TO IAT-8-ENTRY-HASH        
           MOVE WS-TOTAL-IAT-DEBIT           TO IAT-8-TOTAL-DEBIT       
           MOVE ZERO                         TO IAT-8-TOTAL-CREDIT      
           MOVE WS-COMPANY-ID                TO IAT-8-COMPANY-IDENT     
           MOVE WS-GO-ODFI-IDENT             TO IAT-8-ORIGIN-DFI-IDENT  
           MOVE 1                            TO IAT-8-BATCH-NUMBER      
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * MOVE VALUES TO DRAFT FILE TRAILER RECORD                       *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2350-PREPARE-TYPE-9-DRAFT.                                       
                                                                        
           MOVE WS-DRAFT-REC-WRITTEN  TO WS-WORK-CNT                    
           ADD 1                      TO WS-WORK-CNT                    
                                                                        
           IF WS-WORK-CNT-DIGIT6 > 0                                    
              ADD 1                   TO WS-WORK-CNT-DIGIT5             
           END-IF                                                       
                                                                        
           MOVE 1                     TO CSHCNACH-9-BATCH-COUNT         
           MOVE WS-WORK-CNT-DIGIT5    TO CSHCNACH-9-BLOCK-COUNT         
           MOVE WS-TOTAL-DRAFT-TYPE6  TO CSHCNACH-9-ENTRY-ADDENDA-COUNT 
           MOVE WS-TOTAL-DRAFT-HASH   TO CSHCNACH-9-ENTRY-HASH          
           MOVE WS-TOTAL-DRAFT-DEBIT  TO CSHCNACH-9-TOTAL-DEBIT         
           MOVE 0                     TO CSHCNACH-9-TOTAL-CREDIT        
           .                                                            
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * MOVE VALUES TO IAT FILE TRAILER RECORD                         *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2400-PREPARE-TYPE-9-IAT.                                         
                                                                        
           MOVE WS-IAT-REC-WRITTEN   TO WS-WORK-CNT                     
                                                                        
           IF WS-WORK-CNT-DIGIT6 > 0                                    
              ADD 1                  TO WS-WORK-CNT-DIGIT5              
           END-IF                                                       
                                                                        
           MOVE 9                    TO IAT-9-RECORD-TYPE               
           MOVE 1                    TO IAT-9-BATCH-COUNT               
           MOVE WS-WORK-CNT-DIGIT5   TO IAT-9-BLOCK-COUNT               
           MOVE WS-TOTAL-IAT-TYPE6   TO IAT-9-ADDENDA-COUNT             
           MOVE WS-TOTAL-IAT-HASH    TO IAT-9-ENTRY-HASH                
           MOVE WS-TOTAL-IAT-DEBIT   TO IAT-9-TOTAL-DEBIT               
           MOVE ZERO                 TO IAT-9-TOTAL-CREDIT              
           .                                                            
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * ASSIGNS DIFFERENT ACTION CODE FOR IAT PAYMENTS TO DETERMINE THE*        
      * PAYMENT TYPE ON THE REPORT PROGRAM                             *        
      *----------------------------------------------------------------*        
       2500-CHANGE-REPORT-FILE.                                         
           IF E-FCA192-COMPANY-NO = AT-COMPANY-NO AND                   
              E-FCA192-ACCOUNT-NO = CSHCNACH-6-ID-NBR                   
                                                                        
              EVALUATE E-FCA192-ACTION-CODE                             
                 WHEN 'A'                                               
                    MOVE 'F' TO E-FCA192-ACTION-CODE                    
                 WHEN 'B'                                               
                    MOVE 'G' TO E-FCA192-ACTION-CODE                    
                 WHEN 'C'                                               
                    MOVE 'H' TO E-FCA192-ACTION-CODE                    
                 WHEN 'D'                                               
                    MOVE 'J' TO E-FCA192-ACTION-CODE                    
                 WHEN 'M'                                               
                    MOVE 'K' TO E-FCA192-ACTION-CODE                    
                 WHEN 'N'                                               
                    MOVE 'L' TO E-FCA192-ACTION-CODE                    
                 WHEN 'O'                                               
                    MOVE 'P' TO E-FCA192-ACTION-CODE                    
                 WHEN 'R'                                               
                    MOVE 'Q' TO E-FCA192-ACTION-CODE                    
                 WHEN 'W'                                               
                    MOVE 'S' TO E-FCA192-ACTION-CODE                    
                 WHEN 'X'                                               
                    MOVE 'T' TO E-FCA192-ACTION-CODE                    
                 WHEN 'Y'                                               
                    MOVE 'U' TO E-FCA192-ACTION-CODE                    
                 WHEN 'Z'                                               
                    MOVE 'V' TO E-FCA192-ACTION-CODE                    
                                                                        
              END-EVALUATE                                              
                                                                        
              PERFORM 8200-UPDATE-FIOCA192                              
                 THRU 8200-EXIT                                         
           END-IF                                                       
                                                                        
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * PREPARE ADDENDA RECORDS WHICH NEEDS TO BE ATTACHED ALONG WITH  *        
      * THE DETAIL ENTRY RECORD AND WRITE ON THE IAT FILE              *        
      *----------------------------------------------------------------*        
       2700-PROCESS-ADDENDA-RECS.                                       
      *--------------------------*                                              
           PERFORM 2710-PREPARE-710-REC                                 
              THRU 2710-EXIT                                            
                                                                        
           PERFORM 8100-WRITE-IAT                                       
              THRU 8100-EXIT                                            
                                                                        
           PERFORM 2711-PREPARE-711-REC                                 
              THRU 2711-EXIT                                            
                                                                        
           PERFORM 8100-WRITE-IAT                                       
              THRU 8100-EXIT                                            
                                                                        
           PERFORM 2712-PREPARE-712-REC                                 
              THRU 2712-EXIT                                            
                                                                        
           PERFORM 8100-WRITE-IAT                                       
              THRU 8100-EXIT                                            
                                                                        
           PERFORM 2713-PREPARE-713-REC                                 
              THRU 2713-EXIT                                            
                                                                        
           PERFORM 8100-WRITE-IAT                                       
              THRU 8100-EXIT                                            
                                                                        
           PERFORM 2714-PREPARE-714-REC                                 
              THRU 2714-EXIT                                            
                                                                        
           PERFORM 8100-WRITE-IAT                                       
              THRU 8100-EXIT                                            
                                                                        
           PERFORM 2715-PREPARE-715-REC                                 
              THRU 2715-EXIT                                            
                                                                        
           PERFORM 8100-WRITE-IAT                                       
              THRU 8100-EXIT                                            
                                                                        
           PERFORM 2716-PREPARE-716-REC                                 
              THRU 2716-EXIT                                            
                                                                        
           PERFORM 8100-WRITE-IAT                                       
              THRU 8100-EXIT                                            
                                                                        
           ADD 7   TO WS-TOTAL-IAT-TYPE6                                
           .                                                            
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * THE FIRST ADDENDA RECORD IDENTIFIES THE RECEIVER OF THE TRANSAC*        
      * TION AND THE DOLLAR AMOUNT OF THE PAYMENT                      *        
      *----------------------------------------------------------------*        
       2710-PREPARE-710-REC.                                            
      *---------------------*                                                   
           MOVE 7                      TO IAT-710-RECORD-TYPE           
           MOVE '10'                   TO IAT-710-ADDENDA-TYPE-CODE     
           MOVE 'DEP'                  TO IAT-710-TRANSACTION-TYPE-CODE 
           MOVE CSHCNACH-6-DRAFT-AMT   TO IAT-710-FOREIGN-PAYMENT-AMT   
           MOVE '0000000000'           TO IAT-710-FOREIGN-TRACE-NO      
           MOVE CSHCNACH-6-NAME        TO IAT-710-RECEIVER-NAME         
           MOVE WS-TRACE-IAT-SEQ-NO    TO IAT-710-ENTRY-DET-SEQ-NO      
           .                                                            
       2710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *  THE SECOND ADDENDA RECORD IDENTIFY KEY INFORMATION RELATED TO *        
      *  THE ORIGINATOR OF THE COUNTRY                                 *        
      *----------------------------------------------------------------*        
       2711-PREPARE-711-REC.                                            
      *---------------------*                                                   
           MOVE 7                      TO IAT-711-RECORD-TYPE           
           MOVE '11'                   TO IAT-711-ADDENDA-TYPE-CODE     
           MOVE 'SCANA CORPORATION'    TO IAT-711-ORIGINATOR-NAME       
           MOVE '220 OPERATIONS WAY'   TO IAT-711-ORIGIN-STREET-ADDRESS 
           MOVE WS-TRACE-IAT-SEQ-NO    TO IAT-711-ENTRY-DET-SEQ-NO      
           .                                                            
       2711-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *  THE THIRD ADDENDA RECORD IDENTIFY KEY INFORMATION RELATED TO  *        
      *  THE ORIGINATOR OF THE COUNTRY                                 *        
      *----------------------------------------------------------------*        
       2712-PREPARE-712-REC.                                            
      *---------------------*                                                   
           MOVE 7                     TO IAT-712-RECORD-TYPE            
           MOVE '12'                  TO IAT-712-ADDENDA-TYPE-CODE      
           MOVE 'CAYCE*SC\'           TO IAT-712-ORIGIN-CITY-STATE      
           MOVE 'US*29033\'           TO IAT-712-ORIGIN-COUNTRY-POST-CD 
           MOVE WS-TRACE-IAT-SEQ-NO   TO IAT-712-ENTRY-DET-SEQ-NO       
           .                                                            
       2712-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * THE FOURTH ADDENDA RECORD CONTAINS INFORMATION RELATED TO THE  *        
      * FINANCIAL INSTITUTION ORIGINATING THE COUNTRY                  *        
      *----------------------------------------------------------------*        
       2713-PREPARE-713-REC.                                            
      *---------------------*                                                   
           MOVE 7                      TO IAT-713-RECORD-TYPE           
           MOVE '13'                   TO IAT-713-ADDENDA-TYPE-CODE     
           MOVE WS-DESTINATION         TO IAT-713-ORIGIN-DFI-NAME       
           MOVE '01'                   TO IAT-713-ORIG-DFI-IDENT-QUAL   
           MOVE WS-IMMED-DEST          TO IAT-713-ORIG-DFI-IDENT        
           MOVE 'US '                  TO IAT-713-ORIG-DFI-COUNTRY-CD   
           MOVE WS-TRACE-IAT-SEQ-NO    TO IAT-713-ENTRY-DET-SEQ-NO      
           .                                                            
       2713-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * THE FIFTH ADDENDA RECORD IDENTIFIES THE RECEIVING FINANCIAL    *        
      * INSTITUTION HOLDING THE RECEIVER'S ACCOUNT                     *        
      *----------------------------------------------------------------*        
       2714-PREPARE-714-REC.                                            
      *---------------------*                                                   
           MOVE 7                   TO IAT-714-RECORD-TYPE              
           MOVE '14'                TO IAT-714-ADDENDA-TYPE-CODE        
           MOVE E-FCA192-BANK-NAME  TO IAT-714-RECEIVING-DFI-NAME       
           MOVE '01'                TO IAT-714-REC-DFI-IDENT-QUAL       
           MOVE CSHCNACH-6-TRANSITR TO IAT-714-REC-DFI-IDENT            
                                                                        
           MOVE DZ-ADDR-COUNTRY     TO 2H-COUNTRY-DESC                  
           PERFORM 7500-GET-COUNTRY-CODE                                
              THRU 7500-EXIT                                            
           MOVE WS-COUNTRY          TO IAT-714-REC-DFI-COUNTRY-CD       
           MOVE WS-TRACE-IAT-SEQ-NO TO IAT-714-ENTRY-DET-SEQ-NO         
           .                                                            
       2714-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *  THE SIXTH ADDENDA RECORD IDENTIFY INFORMATION RELATED TO THE  *        
      *  RECEIVER                                                      *        
      *----------------------------------------------------------------*        
       2715-PREPARE-715-REC.                                            
      *---------------------*                                                   
           MOVE 7                   TO IAT-715-RECORD-TYPE              
           MOVE '15'                TO IAT-715-ADDENDA-TYPE-CODE        
           MOVE CSHCNACH-6-ID-NBR   TO IAT-715-RECEIVER-IDENT-NO        
           MOVE DZ-ADDR-STREET      TO IAT-715-REC-STREET-ADDRESS       
           MOVE WS-TRACE-IAT-SEQ-NO TO IAT-715-ENTRY-DET-SEQ-NO         
           .                                                            
       2715-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * THE SEVENTH ADDENDA RECORD IDENTIFY INFORMATION RELATED TO THE *        
      * RECEIVER                                                       *        
      *----------------------------------------------------------------*        
       2716-PREPARE-716-REC.                                            
      *---------------------*                                                   
           MOVE 7                   TO IAT-716-RECORD-TYPE              
           MOVE '16'                TO IAT-716-ADDENDA-TYPE             
                                                                        
           STRING DZ-INTRNTNL-CITY DELIMITED DELIMITER-SPACE            
                  '*' DELIMITED BY SIZE                                 
                  DZ-INTRNTNL-PROVINCE DELIMITED DELIMITER-SPACE        
                  '\' DELIMITED BY SIZE                                 
                  INTO IAT-716-RECEIVER-CITY-STATE                      
                                                                        
           STRING WS-CNTRY-CD DELIMITED DELIMITER-SPACE                 
                  '*' DELIMITED BY SIZE                                 
                  DZ-INTRNTNL-POST-CODE DELIMITED DELIMITER-SPACE       
                  '\' DELIMITED BY SIZE                                 
                  INTO IAT-716-REC-CNTY-POSTAL-CD                       
                                                                        
           MOVE WS-TRACE-IAT-SEQ-NO   TO IAT-716-ENTRY-DET-SEQ-NO       
           .                                                            
       2716-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *MOVES REQUIRED VALUES TO WRITE THE REPORT                       *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2800-PROCESS-EXCEP-REPORT.                                       
                                                                        
           MOVE WS-ZERO                TO WS-LINE-DIFF                  
                                                                        
           COMPUTE WS-LINE-DIFF = WS-FIFTY-FIVE - WS-LINE-CNTR          
           END-COMPUTE                                                  
                                                                        
           IF WS-LINE-CNTR > WS-FIFTY-FIVE  OR WS-LINE-DIFF <= 5        
              PERFORM 2965-PRINT-REPORT-HEADER                          
                 THRU 2965-EXIT                                         
                                                                        
              MOVE WS-TWO                TO WS-LINE-SPACE               
           END-IF                                                       
                                                                        
                                                                        
           MOVE WS-ACCOUNT-NO            TO WS-RPT-ACCT-NO              
           MOVE CSHCNACH-6-DRAFT-AMT     TO WS-RPT-PYMT-AMT             
           MOVE DZ-INTRNTNL-CITY         TO WS-RPT-CITY                 
           MOVE DZ-INTRNTNL-PROVINCE     TO WS-RPT-PROVINCE             
           MOVE DZ-INTRNTNL-POST-CODE    TO WS-RPT-POST-CODE            
                                                                        
           ADD WS-ONE                    TO WS-LINE-CNTR                
           MOVE WS-TWO                   TO WS-LINE-SPACE               
           MOVE WS-RPT-DTL               TO PRT33-DATA                  
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
           MOVE WS-ONE                  TO WS-LINE-SPACE                
           ADD WS-ONE                   TO WS-LINE-CNTR                 
           ADD WS-ONE                   TO WS-EXCEP-CNT                 
           ADD CSHCNACH-6-DRAFT-AMT     TO WS-EXCEP-AMOUNT              
           .                                                            
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITES REPORT HEADER DETAILS                                   *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2965-PRINT-REPORT-HEADER.                                        
                                                                        
           MOVE '2965'                       TO WS-ACTIVE-PARAGRAPH     
                                                                        
           MOVE WS-ZERO                      TO WS-LINE-CNTR            
           ADD  WS-ONE                       TO WS-PAGE-NUM             
           MOVE WS-PAGE-NUM                  TO WS-PAGE-NO              
                                                                        
      ***  INCREMENTS THE PAGENO AND PRINTS THE HEADER                          
      ***  AFTER ADVANCING ONE PAGE                                             
                                                                        
           MOVE WS-RPT-HDR1                  TO PRT33-DATA              
                                                                        
           PERFORM 2975-WRITE-FIRST-HEADER                              
              THRU 2975-EXIT                                            
                                                                        
      ***  PRINT THE TITLE AND TIME                                             
                                                                        
           MOVE WS-RPT-HDR2                   TO PRT33-DATA             
           MOVE WS-ONE                        TO WS-LINE-SPACE          
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
           MOVE WS-PAGE-HDR                   TO PRT33-DATA             
                                                                        
           MOVE WS-ONE                        TO WS-LINE-SPACE          
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
      ***  PRINTS  ======                                                       
                                                                        
           MOVE WS-RPT-LINE                   TO PRT33-DATA             
           MOVE WS-TWO                        TO WS-LINE-SPACE          
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
      ***  PRINTS THE  COMPANY DETAILS              ***                         
                                                                        
           MOVE WS-RPT-HDR3                  TO PRT33-DATA              
           MOVE WS-ONE                       TO WS-LINE-SPACE           
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
      ***  PRINTS ======                             ***                        
                                                                        
           MOVE WS-RPT-LINE                  TO PRT33-DATA              
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
           MOVE WS-SIX                       TO WS-LINE-CNTR            
           .                                                            
       2965-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITES REPORT IN A NEW PAGE                                    *        
      *----------------------------------------------------------------*        
       2975-WRITE-FIRST-HEADER.                                         
                                                                        
           MOVE '2975'                       TO WS-ACTIVE-PARAGRAPH     
                                                                        
           WRITE PRT33-RECORD AFTER ADVANCING PAGE                      
           .                                                            
       2975-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITES REPORT IN NEXT LINE                                     *        
      *----------------------------------------------------------------*        
       2985-WRITE-RECORD.                                               
                                                                        
           MOVE '2985'                       TO WS-ACTIVE-PARAGRAPH     
                                                                        
           WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE             
           .                                                            
       2985-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITES END OF REPORT LINE                                      *        
      *----------------------------------------------------------------*        
       2990-PRINT-REPORT-TRAILER.                                       
                                                                        
           MOVE '2990'                TO WS-ACTIVE-PARAGRAPH            
                                                                        
           MOVE  WS-EXCEP-CNT         TO WS-RPT-EXCEP-CNT               
           MOVE  WS-EXCEP-AMOUNT      TO WS-RPT-EXCEP-AMOUNT            
           MOVE  WS-RPT-EXCEP-MSG     TO PRT33-DATA                     
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
           MOVE WS-ONE                TO WS-LINE-SPACE                  
           ADD WS-ONE                 TO WS-LINE-CNTR                   
                                                                        
           MOVE  WS-RPT-FTR           TO PRT33-DATA                     
                                                                        
           PERFORM 2985-WRITE-RECORD                                    
              THRU 2985-EXIT                                            
                                                                        
           .                                                            
       2990-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *----------------------------------------------------------------*        
      *  SELECTS THE COUNTRY INFORMATION FOR AN ACCOUNT                *        
      *                                                                *        
      *----------------------------------------------------------------*        
       7000-CHECK-COUNTRY.                                              
      *--------------------*                                                    
                                                                        
           MOVE SPACES   TO DZ-ADDR-COUNTRY                             
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) DZ.ADDR_COUNTRY,
              DZ.ADDR_STREET,
              DZ.INTRNTNL_CITY,
              DZ.INTRNTNL_PROVINCE,
              DZ.INTRNTNL_POST_CODE,
              AT.COMPANY_NO                                       
               INTO :DZ-ADDR-COUNTRY                                    
                   ,:DZ-ADDR-STREET                                     
                   ,:DZ-INTRNTNL-CITY                                   
                   ,:DZ-INTRNTNL-PROVINCE                               
                   ,:DZ-INTRNTNL-POST-CODE                              
                   ,:AT-COMPANY-NO                                      
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
                   ,CSS_ADDR_FREEFORM DZ WITH(READUNCOMMITTED)                  
              WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                  
                AND AT.ADDRESS_ID     = DZ.ADDRESS_ID                   
                AND AT.ADDRESS_FORMAT = 'B'                             
                AND DZ.ADDR_COUNTRY   > ' '                             
                AND DZ.ADDR_COUNTRY   NOT IN ('UNITED STATES')          
                                           
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DZ.ADDR_COUNTRY                                             
MFA-TR*            ,DZ.ADDR_STREET                                              
MFA-TR*            ,DZ.INTRNTNL_CITY                                            
MFA-TR*            ,DZ.INTRNTNL_PROVINCE                                        
MFA-TR*            ,DZ.INTRNTNL_POST_CODE                                       
MFA-TR*            ,AT.COMPANY_NO                                               
MFA-TR*        INTO :DZ-ADDR-COUNTRY                                            
MFA-TR*            ,:DZ-ADDR-STREET                                             
MFA-TR*            ,:DZ-INTRNTNL-CITY                                           
MFA-TR*            ,:DZ-INTRNTNL-PROVINCE                                       
MFA-TR*            ,:DZ-INTRNTNL-POST-CODE                                      
MFA-TR*            ,:AT-COMPANY-NO                                              
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*            ,CSS_ADDR_FREEFORM DZ                                        
MFA-TR*       WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                          
MFA-TR*         AND AT.ADDRESS_ID     = DZ.ADDRESS_ID                           
MFA-TR*         AND AT.ADDRESS_FORMAT = 'B'                                     
MFA-TR*         AND DZ.ADDR_COUNTRY   > ' '                                     
MFA-TR*         AND DZ.ADDR_COUNTRY   NOT IN ('UNITED STATES')                  
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*     QUERYNO 7000                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7000 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7000-CHECK-COUNTRY'              
              DISPLAY '**  SQL STATUS       = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  AT-ACCOUNT-NO    = ' WS-ACCOUNT-NO-NUM       
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * READS THE FIRST RECORD FROM THE REPORT FILE                    *        
      *----------------------------------------------------------------*        
       7100-READ-FCSCA192.                                              
                                                                        
           READ FCSCA192-FILE                                           
                                                                        
           IF FCA192-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              IF FCA192-END-OF-FILE                                     
                 DISPLAY ' FCSAC192 END OF FILE'                        
              ELSE                                                      
                 DISPLAY 'ERROR ON READING FCSCA192 FILE'               
                 DISPLAY '7100-ERROR ON FCSCA192 READ.  STATUS IS '     
                          WS-FCA192-STATUS                              
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND           THRU 9900-EXIT            
              END-IF                                                    
           END-IF                                                       
                                                                        
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * READS THE NEXT SEQUENTIAL RECORD FROM REPORT FILE              *        
      *----------------------------------------------------------------*        
       7200-READ-NEXT-FCSCA192.                                         
                                                                        
           READ FCSCA192-FILE NEXT RECORD                               
                                                                        
           IF FCA192-SUCCESSFUL OR FCA192-END-OF-FILE                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7200-ERROR ON FCSCA192 READ.  STATUS IS '        
                       WS-FCA192-STATUS                                 
              DISPLAY 'PROCESSING TERMINATED'                           
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
                                                                        
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS PREVIOUS BUSINESS DATE FROM BUSINESS DAYS TABLE        *        
      *----------------------------------------------------------------*        
       7300-SELECT-PREV-BUSINESS-DATE.                                  
                                                                        
           MOVE WS-INPUT-DATE                TO 1G-BUSINESS-DAY-DT      
                                                                        
           EXEC SQL                                                     
             SELECT BUSINESS_DAY_DT                                     
               INTO :1G-BUSINESS-DAY-DT                                 
               FROM CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)                     
              WHERE BUS_DAY_DT_SEQ =                                    
                       (SELECT BUS_DAY_DT_SEQ - 1                       
                          FROM CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)          
                         WHERE BUSINESS_DAY_DT = IIF(TRY_CONVERT(DATE, 
                                                    :1G-BUSINESS-DAY-DT
              ) IS NULL OR (PATINDEX('%.%', :1G-BUSINESS-DAY-DT
              ) <> 0) OR (LEN(:1G-BUSINESS-DAY-DT
              ) <> 10), CIS.CHAR2DATE(:1G-BUSINESS-DAY-DT
              ), CONVERT(DATE, :1G-BUSINESS-DAY-DT) )    
                           AND COMPANY_NO = '01')                       
                AND COMPANY_NO = '01'                                   
                                                            
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT BUSINESS_DAY_DT                                             
MFA-TR*        INTO :1G-BUSINESS-DAY-DT                                         
MFA-TR*        FROM CSS_BUSINESS_DAYS                                           
MFA-TR*       WHERE BUS_DAY_DT_SEQ =                                            
MFA-TR*                (SELECT BUS_DAY_DT_SEQ - 1                               
MFA-TR*                   FROM CSS_BUSINESS_DAYS                                
MFA-TR*                  WHERE BUSINESS_DAY_DT = :1G-BUSINESS-DAY-DT            
MFA-TR*                    AND COMPANY_NO = '01')                               
MFA-TR*         AND COMPANY_NO = '01'                                           
MFA-TR*     QUERYNO 7300                                                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7300 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7300-SELECT-PREV-BUSINESS-DATE'  
              DISPLAY '**  SQL STATUS       = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  BUSINESS-DAY-DT  = ' 1G-BUSINESS-DAY-DT      
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * SELECTS DELINQUENCY VALUE FOR GIVEN DELINQUENCY CODE          *         
      *---------------------------------------------------------------*         
                                                                        
       7400-GET-DELINQ-VALUE.                                           
                                                                        
           EXEC SQL                                                     
             SELECT DELINQ_VALUE                                        
                   ,DESCRIPTION                                         
               INTO :C8-DELINQ-VALUE                                    
                   ,:C8-DESCRIPTION                                     
               FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
              WHERE DELINQ_CD  = :C8-DELINQ-CD                          
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                            
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DELINQ_VALUE                                                
MFA-TR*            ,DESCRIPTION                                                 
MFA-TR*        INTO :C8-DELINQ-VALUE                                            
MFA-TR*            ,:C8-DESCRIPTION                                             
MFA-TR*        FROM CSS_DELINQUENCY                                             
MFA-TR*       WHERE DELINQ_CD  = :C8-DELINQ-CD                                  
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*     QUERYNO 7400                                                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7400 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7400-GET-DELINQ-VALUE'           
              DISPLAY '**  SQL STATUS       = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  C8-DELINQ-CD     = ' C8-DELINQ-CD            
              DISPLAY '**  C8-COMPANY-NO    = ' C8-COMPANY-NO           
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *---------------------------------------------------------------*         
      * SELECTS COUNTRY CODE FOR GIVEN COUNTRY                        *         
      *---------------------------------------------------------------*         
                                                                        
       7500-GET-COUNTRY-CODE.                                           
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) ISO_CD                                              
               INTO :2H-ISO-CD                                          
               FROM CSS_COUNTRY WITH(READUNCOMMITTED)                           
              WHERE COUNTRY_DESC = :2H-COUNTRY-DESC                     
                                                            
                                                  
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT ISO_CD                                                      
MFA-TR*        INTO :2H-ISO-CD                                                  
MFA-TR*        FROM CSS_COUNTRY                                                 
MFA-TR*       WHERE COUNTRY_DESC = :2H-COUNTRY-DESC                             
MFA-TR*     QUERYNO 7500                                                        
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE 2H-ISO-CD    TO WS-CNTRY-CD                       
              ELSE                                                      
                 MOVE SPACES       TO WS-CNTRY-CD                       
              END-IF                                                    
           ELSE                                                         
              DISPLAY '7500 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7500-GET-COUNTRY-CODE'           
              DISPLAY '**  SQL STATUS       = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  COUNTRY DESC     = ' 2H-COUNTRY-DESC         
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS CURRENT DATE AND TIME                                  *        
      *----------------------------------------------------------------*        
       7650-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-RPT-DATE,
              :WS-RPT-TIME                        
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-RPT-DATE  = CURRENT DATE                                
MFA-TR*            ,:WS-RPT-TIME  = CURRENT TIME                                
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7100 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7650-GET-CURRENT-DATE'           
              DISPLAY '**  FAILED IN SET STATEMENT'                     
              DISPLAY '**  SQL STATUS       = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS COMPANY DESCRIPTION                                    *        
      *                                                                *        
      *----------------------------------------------------------------*        
       7700-GET-COMPANY-NAME.                                           
      *-----------------*                                                       
                                                                        
           EXEC SQL                                                     
             SELECT COMPANY_NAME                                        
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY WITH(READUNCOMMITTED)                           
              WHERE COMPANY_NO = :C7-COMPANY-NO                         
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NAME                                                
MFA-TR*        INTO :C7-COMPANY-NAME                                            
MFA-TR*        FROM CSS_COMPANY                                                 
MFA-TR*       WHERE COMPANY_NO = :C7-COMPANY-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7700                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7700 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7700-GET-COMPANY-NAME'           
              DISPLAY '**  SQL STATUS         = ' WS-ACTIVE-RETURN-CODE 
              DISPLAY '**  COMPANY NO         = ' C7-COMPANY-NO         
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITE DRAFT PAYMENTS                                           *        
      *----------------------------------------------------------------*        
       8000-WRITE-DRAFT.                                                
                                                                        
           MOVE CSHCNACH-OUTPUT-RECORD  TO CSHCNACH-OUTPUT-DRAFT        
                                                                        
           WRITE FIOCADFT                                               
                                                                        
           INITIALIZE  FIOCADFT                                         
           ADD 1  TO  WS-DRAFT-REC-WRITTEN                              
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITE IAT PAYMENTS                                             *        
      *----------------------------------------------------------------*        
       8100-WRITE-IAT.                                                  
                                                                        
           WRITE NACHA-IAT                                              
                                                                        
           INITIALIZE  NACHA-IAT                                        
                                                                        
           ADD 1  TO  WS-IAT-REC-WRITTEN                                
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * UPDATES DRAFT REPORT FILE TO RECORD IT'S A IAT TRANSACTION     *        
      *                                                                *        
      *----------------------------------------------------------------*        
       8200-UPDATE-FIOCA192.                                            
                                                                        
           REWRITE FIOCA192                                             
                                                                        
           .                                                            
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   CLOSES NORMAL ACH, INTERNATIONAL ACH AND DRAFT REPORT FILES  *        
      *                                                                *        
      *----------------------------------------------------------------*        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           CLOSE FCSAC03-FILE                                           
                                                                        
           IF  FAC03-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**PCSAC194   PROCESSING ERROR  **'              
               DISPLAY '9000-ERROR ON FCSAC03 CLOSE.  STATUS IS '       
                       WS-FAC03-STATUS                                  
           END-IF                                                       
                                                                        
           CLOSE FCSIAT-FILE                                            
                                                                        
           IF  FACIAT-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**PCSAC194   PROCESSING ERROR  **'              
               DISPLAY '9000-ERROR ON FCSIAT CLOSE.  STATUS IS '        
                       WS-FACIAT-STATUS                                 
           END-IF                                                       
                                                                        
           CLOSE FCSCA192-FILE                                          
                                                                        
           IF  FCA192-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**PCSAC194   PROCESSING ERROR  **'              
               DISPLAY '9000-ERROR ON FCSIAT CLOSE.  STATUS IS '        
                       WS-FCA192-STATUS                                 
           END-IF                                                       
                                                                        
           CLOSE FCSPT33-FILE                                           
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * COPYBOOK TO READ PARM FILE FOR OVERRIDE RUN DATE                        
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
                                                                        
      * CURSOR DECLARATION FOR OVERRIDE RUN DATE                                
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
                                                                        
      * ABEND ROUTINE                                                           
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
