       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSAC193.                                         
       AUTHOR.        COVANSYS.                                         
       DATE-WRITTEN.  JUNE 2009.                                        
       DATE-COMPILED.                                                   
      ******************************************************************00040000
      **               SOUTH CAROLINA ELECTRIC & GAS                  **00050000
      **                                                              **00051000
      **                CUSTOMER INFORMATION SYSTEM                   **00052000
      ******************************************************************00060000
      *              P R O G R A M  S U M M A R Y                      *00070000
      ******************************************************************00080000
      **                                                              **00090000
      ** THIS IS A BATCH PROGRAM THAT WILL READ A DB2 TABLE,          **00100000
      ** CSS_BATCH_EMAIL, FOR INPUT.THE PROGRAM WILL PROCESS          **00110000
      ** ACCOUNTS THAT ARE SETUP TO RECEIVE BOTH 'EMAIL & PAPER'      **00120000
      ** BILL NOTIFICATIONS AND HAD AN EMAIL RETURNED (BOUNCED)       **00130000
      ** THE PREVIOUS BUSINESS DAY (VARIABLE).AS PART OF THE          **00140000
      ** PROCESSING,IT CHECKS TO SEE IF THE ACCOUNT HAS HAD 3 OR MORE **00150000
      ** (VARIABLE)RETURNED EMAILS OVER THE PAST 90 (VARIABLE) DAYS.  **00160000
      ** IF SO, THIS PROCESS WILL UPDATE THE ACCOUNT TO 'PAPER ONLY'  **00170000
      ** BILL NOTIFICATION AND SPACE OUT THEIR EMAIL ADDRESS.         **00180000
      **                                                              **00190000
      ** ADDITIONALLY, THE PROCESS WILL UNSET PAYMENT REMINDER        **00200000
      ** NOTIFICATIONS IF THE ACCOUNT IS SETUP TO RECEIVE THEM        **00210000
      **                                                              **00220000
      ******************************************************************00230000
      **                                                              **00240000
      **              PROGRAM  MODIFICATION  LOG                      **00250000
      **                                                              **00260000
      **    DATE    INITIALS     REASON                               **00270000
      **  --------  --------     ----------------------------------   **00280000
P00176**  06/2009   CVNS         INITIAL VERSION OF PROGRAM           **00290000
      **            CHENNAI                                           **00300000
A37741**  11/2009   MC95456      DECLARED  S-RETURN-CODE REPECTIVE TO **00300100
A37741**                         CPD00067 CHANGES                     **00300200
      ******************************************************************00310000
      *                                                                *00993000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00993100
      *                                                                *00993200
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00993300
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00993400
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00993500
      *  3000 - 4999  NOT USED                                         *00993600
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00993700
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00993800
      *  7000 - 7999  INPUT MODULES                                    *00993900
      *  8000 - 8999  OUTPUT MODULES                                   *00994000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00994100
      *                                                                *00994200
      ******************************************************************00994300
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
      *                                                                 00995300
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC193'.
MSQ017     COPY MFASQLM.
      *                                                                 00996000
       01 WS-START                         PIC X(40) VALUE              
             'WORKING STORAGE FOR PCSAC193 STARTS HERE'.                
      *                                                                 00999000
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSAC193'.  
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSAC193'.  
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-NO                       PIC X(01) VALUE 'N'.         
           05  WS-YES                      PIC X(01) VALUE 'Y'.         
      *                                                                 01150000
A37741 01  S-RETURN-CODE            PIC S9(9) VALUE 0.                  
      *                                                                 01150200
       01  WS-MISC.                                                     
           05  WS-FROM-DATE                PIC X(10) VALUE SPACES.      
           05  WS-PROCESSED-DT             PIC X(10) VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.      
           05  WS-CURRENT-DATE             PIC X(10) VALUE SPACES.      
           05  WS-NBR-DAYS                 PIC S9(4)V9(5) USAGE COMP-3  
                                                     VALUE 90.          
           05  WS-NBR-BIZDAYS              PIC S9(4)V9(5) USAGE COMP-3  
                                                     VALUE 1.           
           05  WS-MIN-NBR-OCCURRENCES      PIC S9(4)V9(5) USAGE COMP-3  
                                                     VALUE 5.           
           05  WS-PREV-ACCOUNT-NO          PIC S9(13)V USAGE COMP-3     
                                                     VALUE 0.           
           05  WS-PREV-CUSTOMER-NO         PIC S9(10)V USAGE COMP-3     
                                                     VALUE 0.           
           05  WS-PREV-COMPANY-NO          PIC X(02) VALUE SPACES.      
           05  WS-EMAIL-CNTR               PIC S9(4) USAGE COMP         
                                                     VALUE 0.           
           05  WS-PREV-BUS-CNTR            PIC S9(4)V9(5) USAGE COMP-3  
                                                     VALUE 0.           
           05  WS-TOT-REC-CNT              PIC S9(7) VALUE ZERO COMP-3. 
           05  WS-DISPLAY-COUNT            PIC -Z(8)9 VALUE ZERO.       
           05  WS-ACCT-COUNT               PIC S9(4) USAGE COMP         
                                                     VALUE 0.           
           05  WS-TRAN-APPL-NO             PIC S9(4) USAGE COMP.        
           05  WS-APPL-PGM-ID-ACC          PIC X(09) VALUE 'PCSAC193A'. 
           05  WS-APPL-PGM-ID-CUST         PIC X(09) VALUE 'PCSAC193B'. 
           05  WS-TRAN-COMMENT-TEXT        PIC X(28)                    
                                 VALUE 'EMAIL RETURNED UNDELIVERABLE'.  
           05  WS-EXCLUDED-EMAIL-EVENTS    OCCURS 50 TIMES              
                  INDEXED BY WS-EXCLUDED-INDEX.                         
               10 WS-EXCLUDED-EVENT-CD     PIC X(20).                   
               10 WS-EXCLUDED-COMPANY-NO   PIC X(02).                   
      *                                                                 01329200
       01  WS-COMMIT-MISC.                                              
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE 0.           
           05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE 0.           
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 100.         
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 100.         
           05  WS-COMMIT-CNTR              PIC S9(7) VALUE ZERO COMP-3. 
      *                                                                 01450000
       01  WS-FLAGS.                                                    
           05  WS-EMAIL-PMT-REMINDER       PIC X(01) VALUE 'N'.         
               88 EMAIL-PMT-REMINDER                 VALUE 'Y'.         
           05  WS-EMAIL-EVENT              PIC X(01) VALUE SPACES.      
               88 NO-EMAIL-EVENT                     VALUE 'N'.         
               88 YES-EMAIL-EVENT                    VALUE 'Y'.         
           05  WS-PAPER-ONLY               PIC X(01) VALUE 'N'.         
               88 PAPER-ONLY                         VALUE 'Y'.         
                                                                        
           COPY FIOJC01.                                                01622000
                                                                        
      ******************************************************************01624000
      * WORKING STORAGE COPYBOOK FOR CPD00038                          *01625000
      ******************************************************************01626000
           EXEC SQL                                                     01629200
              INCLUDE CWS00038                                          01629300
           END-EXEC.                                                    01629400
                                                                        
      ******************************************************************01630300
      * WORKING STORAGE COPYBOOK FOR CPD00315                          *01630400
      ******************************************************************01630500
           EXEC SQL                                                     01630600
              INCLUDE CWS00315                                          01630700
           END-EXEC.                                                    01630800
                                                                        
      ******************************************************************01631000
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                        *01640000
      ******************************************************************01650000
       COPY CWS00010.                                                   01660000
                                                                        
      ******************************************************************01680000
      *  COPYBOOK WITH COMMON SQL VARIABLES                            *01690000
      ******************************************************************01700000
       COPY CWS00303.                                                   01710000
                                                                        
      ******************************************************************01721000
      * WORKING STORAGE FOR CPD09900                                   *01722000
      ******************************************************************01723000
       COPY CWS09900.                                                   01724000
                                                                        
      ******************************************************************01730000
      *    DECLARATION FOR SQL COMMAND AREA                            *01740000
      ******************************************************************01750000
           EXEC SQL                                                     01760000
              INCLUDE SQLCA                                             01770000
           END-EXEC.                                                    01780000
                                                                        
      ******************************************************************07170000
      *    TABLE : CSS_ACCOUNT, AT                                     *07180000
      ******************************************************************07190000
           EXEC SQL                                                     07200000
              INCLUDE TBACCT                                            07210000
           END-EXEC.                                                    07220000
                                                                        
      ******************************************************************07240000
      *    TABLE : CSS_ACCT_ATTRIBUTE, YP                              *07250000
      ******************************************************************07260000
           EXEC SQL                                                     07270000
              INCLUDE TBACTATT                                          07280000
           END-EXEC.                                                    07290000
                                                                        
      ******************************************************************07310000
      *    TABLE : CSS_ATTRIBUTE, WZ                                   *07320000
      ******************************************************************07330000
           EXEC SQL                                                     07340000
              INCLUDE TBATTRIB                                          07350000
           END-EXEC.                                                    07360000
                                                                        
      ******************************************************************07380000
      *    TABLE : CSS_BATCH_EMAIL, AE                                 *07390000
      ******************************************************************07400000
           EXEC SQL                                                     07410000
              INCLUDE TBBEMAIL                                          07420000
           END-EXEC.                                                    07430000
                                                                        
      ******************************************************************07452000
      *    TABLE : CSS_CUST_EMAIL, NE                                  *07453000
      ******************************************************************07454000
           EXEC SQL                                                     07455000
              INCLUDE TBCSTEML                                          07456000
           END-EXEC.                                                    07457000
                                                                        
      ******************************************************************07458000
      *    TABLE : CSS_DELINQUENCY, C8                                 *07460000
      ******************************************************************07470000
           EXEC SQL                                                     07480000
              INCLUDE TBDELQ                                            07490000
           END-EXEC.                                                    07500000
                                                                        
      ******************************************************************07511000
      *    TABLE : CSS_HOLIDAY, J8                                     *07512000
      ******************************************************************07513000
           EXEC SQL                                                     07514000
               INCLUDE TBHLDAY                                          07515000
           END-EXEC.                                                    07516000
                                                                        
      ******************************************************************07520000
      *    TABLE : CSS_JOB_PARM, G6                                    *07530000
      ******************************************************************07540000
           EXEC SQL                                                     07550000
              INCLUDE TBJBPARM                                          07560000
           END-EXEC.                                                    07570000
                                                                        
      ******************************************************************07613000
      *    TABLE : CSS_MNT_TRANS_HIST, MH                              *07620000
      ******************************************************************07630000
           EXEC SQL                                                     07640000
              INCLUDE TBMNHIST                                          07650000
           END-EXEC.                                                    07660000
                                                                        
      ******************************************************************07680000
      *    TABLE : CSS_MT_TRN_HST_DET, MI                              *07690000
      ******************************************************************07700000
           EXEC SQL                                                     07710000
              INCLUDE TBMNHDT                                           07720000
           END-EXEC.                                                    07730000
                                                                        
                                                                        
      ******************************************************************07800200
      *    SQL DECLARE STATEMENTS                                      *07800300
      ******************************************************************07800400
                                                                        
      *----------------------------------------------------------------*07810200
      * CURSOR TO GET EXCLUDE EMAIL EVENT CODES AND OVERRIDES FOR      *07810300
      * BUSINESS DAYS, MIN NUMBER OF OCCURENCES AND NUMBER OF DAYS     *07810400
      *----------------------------------------------------------------*07810500
                                                                        
           EXEC SQL                                                     
              DECLARE DELINQ_CURSOR CURSOR FOR                          
              SELECT COMPANY_NO                                         
                     ,DELINQ_CD                                         
                     ,DELINQ_VALUE                                      
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD    LIKE 'SW-BNC%'                        
                 AND DELINQ_VALUE    = 1                                
                  OR DELINQ_CD       = 'NO-BNCEML-OCCURRENCE'           
                  OR DELINQ_CD       = 'NO-BNCEML-DAYS'                 
                  OR DELINQ_CD       = 'NO-BNCEML-BIZDAYS'              
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07810700
MFA-TR*       DECLARE DELINQ_CURSOR CURSOR FOR                          07810800
MFA-TR*       SELECT COMPANY_NO                                         07810900
MFA-TR*              ,DELINQ_CD                                         07811000
MFA-TR*              ,DELINQ_VALUE                                      07811100
MFA-TR*         FROM CSS_DELINQUENCY                                    07812000
MFA-TR*        WHERE DELINQ_CD    LIKE 'SW-BNC%'                        07813000
MFA-TR*          AND DELINQ_VALUE    = 1                                07814000
MFA-TR*           OR DELINQ_CD       = 'NO-BNCEML-OCCURRENCE'           07815000
MFA-TR*           OR DELINQ_CD       = 'NO-BNCEML-DAYS'                 07816000
MFA-TR*           OR DELINQ_CD       = 'NO-BNCEML-BIZDAYS'              07817000
MFA-TR*          FOR FETCH ONLY WITH UR                                 07818000
MFA-TR*    END-EXEC.                                                    07819000
                                                                        
      *----------------------------------------------------------------*07819200
      * CURSOR TO GET CANDIDATE ACCOUNTS THAT HAVE AN EMAIL RETURNED   *07819300
      * THE THE DAY                                                    *07819400
      *----------------------------------------------------------------*07819500
      *                                                                 07819600
           EXEC SQL                                                     
              DECLARE CANDIDATE_ACCT CURSOR WITH HOLD FOR               
              SELECT AE.ACCOUNT_NO                                      
                     ,AT.CUSTOMER_NO                                    
                     ,AT.COMPANY_NO                                     
                     ,AE.EMAIL_EVENT_CD                                 
                     ,COUNT(1)                                          
                FROM CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                
                     ,CSS_BATCH_EMAIL    AE WITH(READUNCOMMITTED)               
                     ,(SELECT ACCOUNT_NO                                
                         FROM CSS_BATCH_EMAIL WITH(READUNCOMMITTED)             
                        WHERE PROCESSED_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROCESSED-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESSED-DT
              ) <> 0) OR (LEN(:WS-PROCESSED-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESSED-DT
              ), CONVERT(DATE, :WS-PROCESSED-DT) )           
                          AND PROCESSED_CD = 'B') AE2                   
               WHERE AE.ACCOUNT_NO     = AT.ACCOUNT_NO                  
                 AND AE.ACCOUNT_NO     = AE2.ACCOUNT_NO                 
                 AND AE.PROCESSED_DT  >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-FROM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FROM-DATE
              ) <> 0) OR (LEN(:WS-FROM-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-FROM-DATE
              ), CONVERT(DATE, :WS-FROM-DATE) )                  
                 AND AE.PROCESSED_DT  <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROCESSED-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESSED-DT
              ) <> 0) OR (LEN(:WS-PROCESSED-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESSED-DT
              ), CONVERT(DATE, :WS-PROCESSED-DT) )               
                 AND AE.PROCESSED_CD   = 'B'                            
                 AND AT.NO_BILL_COPIES > 0                              
               GROUP BY AE.ACCOUNT_NO                                   
                        ,AT.CUSTOMER_NO                                 
                        ,AT.COMPANY_NO                                  
                        ,AE.EMAIL_EVENT_CD                              
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     07819700
MFA-TR*       DECLARE CANDIDATE_ACCT CURSOR WITH HOLD FOR               07819800
MFA-TR*       SELECT AE.ACCOUNT_NO                                      07819900
MFA-TR*              ,AT.CUSTOMER_NO                                    07820000
MFA-TR*              ,AT.COMPANY_NO                                     07821000
MFA-TR*              ,AE.EMAIL_EVENT_CD                                 07830000
MFA-TR*              ,COUNT(1)                                          07840000
MFA-TR*         FROM CSS_ACCOUNT        AT                              07850000
MFA-TR*              ,CSS_BATCH_EMAIL    AE                             07860000
MFA-TR*              ,(SELECT ACCOUNT_NO                                07870000
MFA-TR*                  FROM CSS_BATCH_EMAIL                           07880000
MFA-TR*                 WHERE PROCESSED_DT = :WS-PROCESSED-DT           07890000
MFA-TR*                   AND PROCESSED_CD = 'B') AE2                   07900000
MFA-TR*        WHERE AE.ACCOUNT_NO     = AT.ACCOUNT_NO                  07910000
MFA-TR*          AND AE.ACCOUNT_NO     = AE2.ACCOUNT_NO                 07920000
MFA-TR*          AND AE.PROCESSED_DT  >= :WS-FROM-DATE                  07930000
MFA-TR*          AND AE.PROCESSED_DT  <= :WS-PROCESSED-DT               07940000
MFA-TR*          AND AE.PROCESSED_CD   = 'B'                            07950000
MFA-TR*          AND AT.NO_BILL_COPIES > 0                              07960000
MFA-TR*        GROUP BY AE.ACCOUNT_NO                                   07970000
MFA-TR*                 ,AT.CUSTOMER_NO                                 07980000
MFA-TR*                 ,AT.COMPANY_NO                                  07990000
MFA-TR*                 ,AE.EMAIL_EVENT_CD                              08000000
MFA-TR*          FOR FETCH ONLY WITH UR                                 08010000
MFA-TR*    END-EXEC.                                                    08020000
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSAC193 ENDS HERE  '.            
      *                                                                 08050000
       PROCEDURE DIVISION.                                              
      *                                                                 08061000
      ******************************************************************08070000
      * 0000-MAINLINE                                                  *08090000
      ******************************************************************08110000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZATION                THRU 1000-EXIT.   
           PERFORM 2000-PROCESS-OUTPUT                THRU 2000-EXIT.   
           PERFORM 9000-TERMINATE                     THRU 9000-EXIT.   
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08250000
      ******************************************************************08260000
      * 1000-INITIALIZATION                                            *08280000
      * GET PROCESSED DATE, FROM DATE AND DELINQUENCY VALUES           *08290000
      ******************************************************************08300000
       1000-INITIALIZATION.                                             
                                                                        
           PERFORM 7200-OPEN-DELINQ-CUR               THRU 7200-EXIT.   
           PERFORM 7210-FETCH-DELINQ-CUR              THRU 7210-EXIT.   
                                                                        
           PERFORM 1100-PROCESS-DELINQ                THRU 1100-EXIT    
             UNTIL WS-ACTIVE-RETURN-CODE =  NOT-FOUND                   
                                                                        
           PERFORM 7220-CLOSE-DELINQ-CUR              THRU 7220-EXIT.   
                                                                        
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT          THRU 6253-EXIT.   
                                                                        
           PERFORM 6251-GET-FJC01-DATE                THRU 6251-EXIT.   
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON'                 TO WS-PGRMNAME              
              MOVE SPACES                   TO WS-INPUT-AREA            
              MOVE SPACES                   TO WS-INPUT-DATA-BREAKDOWN  
              PERFORM 6251-GET-FJC01-DATE             THRU 6251-EXIT    
              MOVE WS-INPUT-DATE            TO WS-NEW-BUSINESS-DAY      
              MOVE 'PCSAC193'               TO WS-PGRMNAME              
                                                                        
              PERFORM UNTIL  WS-PREV-BUS-CNTR = WS-NBR-BIZDAYS          
                 MOVE WS-NO                 TO WS-NEXT-BUSINESS-DAY     
                                                                        
                 PERFORM 6525-PREV-BUSINESS-DAY       THRU              
                         6525-PREV-BUSINESS-DAY-EXIT  UNTIL             
                         NEXT-BUSINESS-DAY-FOUND                        
                 ADD 1 TO WS-PREV-BUS-CNTR                              
                                                                        
              END-PERFORM                                               
              MOVE WS-NEW-BUSINESS-DAY      TO WS-PROCESSED-DT          
           ELSE                                                         
              MOVE WS-INPUT-DATE            TO WS-PROCESSED-DT          
              MOVE 'I'                      TO G6-STATUS                
              MOVE WS-PGRMNAME              TO G6-PROGRAM-NAME          
              MOVE '01'                     TO G6-COMPANY-NO            
              MOVE 'DATE'                   TO G6-CMND-CODE             
              PERFORM  8400-RESET-JOB-PARM            THRU 8400-EXIT    
           END-IF.                                                      
           PERFORM 7100-GET-FROM-DATE                 THRU 7100-EXIT.   
           DISPLAY   '** PROCESSED DATE ' WS-PROCESSED-DT.              
           DISPLAY   '** FROM DATE      ' WS-FROM-DATE.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 08737600
      ******************************************************************08737700
      * 1100-PROCESS-DELINQ                                            *08737800
      * GET OVERRIDE VALUES FROM CSS_DELINQUENCY TABLE                 *08737900
      ******************************************************************08738000
       1100-PROCESS-DELINQ.                                             
                                                                        
           EVALUATE C8-DELINQ-CD                                        
              WHEN 'NO-BNCEML-OCCURRENCE'                               
                  MOVE C8-DELINQ-VALUE      TO WS-MIN-NBR-OCCURRENCES   
              WHEN 'NO-BNCEML-DAYS'                                     
                  MOVE C8-DELINQ-VALUE      TO WS-NBR-DAYS              
              WHEN 'NO-BNCEML-BIZDAYS'                                  
                  MOVE C8-DELINQ-VALUE      TO WS-NBR-BIZDAYS           
              WHEN OTHER                                                
                  IF C8-DELINQ-CD(1:14) EQUAL 'SW-BNCEML-XCL-'          
                     MOVE C8-DELINQ-CD(15:5) TO                         
                                 WS-EXCLUDED-EVENT-CD(WS-EXCLUDED-INDEX)
                                                                        
                     MOVE C8-COMPANY-NO      TO                         
                              WS-EXCLUDED-COMPANY-NO(WS-EXCLUDED-INDEX) 
                     SET WS-EXCLUDED-INDEX UP BY 1                      
                  END-IF                                                
           END-EVALUATE.                                                
           PERFORM 7210-FETCH-DELINQ-CUR              THRU 7210-EXIT.   
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08763000
      ******************************************************************08770000
      * 2000-PROCESS-OUTPUT.                                           *08780000
      * PROCESS ACCOUNTS TO EMAIL AND PAPER                            *08781000
      ******************************************************************08790000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7300-OPEN-CANDIDATE-CUR            THRU 7300-EXIT.   
           PERFORM 7310-FETCH-CANDIDATE-CUR           THRU 7310-EXIT.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AE-ACCOUNT-NO            TO WS-PREV-ACCOUNT-NO       
              MOVE AT-CUSTOMER-NO           TO WS-PREV-CUSTOMER-NO      
              MOVE AT-COMPANY-NO            TO WS-PREV-COMPANY-NO       
           END-IF.                                                      
                                                                        
           PERFORM 2100-PROCESS-CANDIDATE             THRU 2100-EXIT    
             UNTIL WS-ACTIVE-RETURN-CODE    = NOT-FOUND.                
                                                                        
           PERFORM 7320-CLOSE-CANDIDATE-CUR           THRU 7320-EXIT.   
                                                                        
           IF WS-EMAIL-CNTR    >= WS-MIN-NBR-OCCURRENCES                
              PERFORM 2200-PROCESS-PAPER-ONLY         THRU 2200-EXIT    
           END-IF.                                                      
                                                                        
           MOVE WS-TOT-REC-CNT              TO WS-DISPLAY-COUNT.        
           DISPLAY 'TOTAL NUMBER OF ACCOUNTS PROCESSED: '               
                                               WS-DISPLAY-COUNT.        
           DISPLAY 'PCSAC193 COMPLETED SUCCESSFULLY'.                   
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************09430000
      * 2100-PROCESS-CANDIDATE                                         *09440000
      * PROCESS CANDIDATE CURSOR*                                      *09441000
      ******************************************************************09450000
       2100-PROCESS-CANDIDATE.                                          
                                                                        
           IF AE-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO                
              IF WS-EMAIL-CNTR    >= WS-MIN-NBR-OCCURRENCES             
                 PERFORM 2200-PROCESS-PAPER-ONLY      THRU 2200-EXIT    
              END-IF                                                    
                                                                        
              MOVE AE-ACCOUNT-NO            TO WS-PREV-ACCOUNT-NO       
              MOVE AT-CUSTOMER-NO           TO WS-PREV-CUSTOMER-NO      
              MOVE AT-COMPANY-NO            TO WS-PREV-COMPANY-NO       
                                                                        
              MOVE 0                        TO WS-EMAIL-CNTR            
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM  2300-CHECK-EMAIL-EVENT            THRU 2300-EXIT.   
           IF NO-EMAIL-EVENT                                            
              ADD  WS-ACCT-COUNT            TO WS-EMAIL-CNTR            
           END-IF.                                                      
                                                                        
                                                                        
           PERFORM 7310-FETCH-CANDIDATE-CUR           THRU 7310-EXIT.   
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32707800
      ******************************************************************32707900
      * 2200-PROCESS-PAPER-ONLY                                        *32708000
      * VALIDATE THE ACCOUNTS AND UPDATES  ACCOUNT TO EMAIL AND PAPER. *32708100
      * INSERTS RECORD IN TRANSACTION HISTORY AND COMMITS BASED ON     *32708200
      * LIMIT                                                          *32708300
      ******************************************************************32708400
       2200-PROCESS-PAPER-ONLY.                                         
      *                                                                 32708600
           MOVE WS-PREV-ACCOUNT-NO          TO YP-ACCOUNT-NO.           
           MOVE WS-PREV-COMPANY-NO          TO WZ-COMPANY-NO.           
           MOVE WS-PREV-CUSTOMER-NO         TO NE-CUSTOMER-NO.          
           MOVE 0                           TO WS-TRAN-APPL-NO          
                                               NE-EMAIL-ADDRESS-TX-LEN. 
           MOVE 'N'                         TO WS-EMAIL-PMT-REMINDER    
                                               WS-PAPER-ONLY            
           MOVE SPACES                      TO NE-EMAIL-ADDRESS-TX-TEXT.
           MOVE 'EMAIL_PAPERONLY'           TO YP-ATTRIBUTE-DESC.       
                                                                        
           PERFORM 7400-SELECT-ACCT-ATTRIBUTE         THRU 7400-EXIT.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
                                                                        
              MOVE 'YES'                    TO YP-ATTRIBUTE-VALUE-CD    
              MOVE +15                      TO YP-ATTRIBUTE-VALUE-TX-LEN
              MOVE 'EMAIL_PAPERONLY'        TO                          
                                              YP-ATTRIBUTE-VALUE-TX-TEXT
                                              YP-ATTRIBUTE-DESC         
              PERFORM 8100-INSERT-ATTRB-CD            THRU 8100-EXIT    
              MOVE 'Y'                      TO WS-PAPER-ONLY            
              PERFORM 6100-INS-TRANS-HIST-ACCT        THRU 6100-EXIT    
              MOVE 'N'                      TO WS-PAPER-ONLY            
                                                                        
              MOVE 'EMAIL PMT REMINDER'     TO YP-ATTRIBUTE-DESC        
              PERFORM 7400-SELECT-ACCT-ATTRIBUTE      THRU 7400-EXIT    
              MOVE 'N'                      TO WS-PAPER-ONLY            
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 8200-DELETE-ATTRB-CD         THRU 8200-EXIT    
                 MOVE 'Y'                   TO WS-EMAIL-PMT-REMINDER    
                 PERFORM 6100-INS-TRANS-HIST-ACCT     THRU 6100-EXIT    
                 MOVE 'N'                   TO WS-EMAIL-PMT-REMINDER    
              END-IF                                                    
                                                                        
              PERFORM  7550-GET-CUST-EMAIL            THRU 7550-EXIT    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM  8300-DELETE-CUST-EMAIL      THRU 8300-EXIT    
                 PERFORM  6000-INSERT-TRANS-HIST-CUST THRU 6000-EXIT    
              END-IF                                                    
                                                                        
              ADD +1 TO WS-TOT-REC-CNT                                  
              IF WS-TOT-REC-CNT  = 1                                    
                 DISPLAY '** PROCESSED ACCOUNTS **'                     
              END-IF                                                    
              DISPLAY '** ACCOUNT # ' WS-PREV-ACCOUNT-NO                
                                                                        
              ADD +1 TO WS-COMMIT-CNTR                                  
              IF WS-COMMIT-CNTR = WS-CHKP-UPD-LIMIT                     
                 PERFORM 8900-COMMIT                  THRU 8900-EXIT    
                 MOVE 0                     TO WS-COMMIT-CNTR           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32921000
      ******************************************************************32922000
      * 2300-CHECK-EMAIL-EVENT                                         *32923000
      * SEARCHES EMAIL EVENT CODE IN ARRAY                             *32923100
      ******************************************************************32924000
       2300-CHECK-EMAIL-EVENT.                                          
                                                                        
           SET WS-EXCLUDED-INDEX            TO 1.                       
           SEARCH WS-EXCLUDED-EMAIL-EVENTS                              
           AT END                                                       
                 MOVE 'N'                   TO WS-EMAIL-EVENT           
           WHEN WS-EXCLUDED-EVENT-CD(WS-EXCLUDED-INDEX) =               
                                                       AE-EMAIL-EVENT-CD
           AND WS-EXCLUDED-COMPANY-NO (WS-EXCLUDED-INDEX)=              
                                                     AT-COMPANY-NO      
                 MOVE 'Y'                   TO WS-EMAIL-EVENT           
           END-SEARCH.                                                  
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32931000
      ******************************************************************32932000
      * 6000-INSERT-TRANS-HIST-CUST                                    *32933000
      * INSERTS DATA IN TRANSACTION HISTORY AND DETAIL TABLES          *32934000
      * FOR CUSTOMER EMAIL ADDRESS - CUSTOMER LEVEL                    *32934100
      ******************************************************************32935000
       6000-INSERT-TRANS-HIST-CUST.                                     
                                                                        
                                                                        
              PERFORM 7000-SELECT-TIMESTAMP          THRU 7000-EXIT.    
              MOVE WS-TRAN-COMMENT-TEXT     TO MH-TRAN-COMMENT-TEXT.    
              MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                       
                                            TO MH-TRAN-COMMENT-LEN.     
      ** DATA FOR CSS_MNT_TRANS_HIST                                    32939400
              MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.    
              MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.           
              MOVE 'F'                      TO MH-CODE-TRAN-TYPE.       
              MOVE '998'                    TO MH-RESP-AREA-ID.         
              MOVE +0                       TO MH-ACCOUNT-NO.           
              MOVE WS-PREV-CUSTOMER-NO      TO MH-CUSTOMER-NO.          
              MOVE +0                       TO MH-PREMISE-NO.           
              MOVE 'SYSTEM'                 TO MH-USER-ID.              
              MOVE WS-APPL-PGM-ID-CUST      TO MH-APPL-PROGRAM-ID.      
              MOVE +0                       TO MH-ENTITY-KEY-DESC-LEN.  
              MOVE SPACES                   TO MH-ENTITY-KEY-DESC-TEXT. 
              MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
                                                                        
      ** DATA FOR CSS_MT_TRN_HST_DET                                    32940900
                                                                        
              MOVE 1                        TO MI-TRAN-APPL-NO.         
              MOVE +75                      TO MI-PRV-COLUMN-VALUE-LEN. 
              MOVE NE-EMAIL-ADDRESS-TX-TEXT TO MI-PRV-COLUMN-VALUE-TEXT.
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN. 
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT.
              MOVE 'EMAIL ADDRESS'          TO MI-COLUMN-DESC.          
              PERFORM 6530-LOAD-MNT-TRANS-HIST        THRU 6530-EXIT.   
                                                                        
              IF NE-EMAIL-DISP-PREF-CD > SPACES                         
                 MOVE 2                     TO MI-TRAN-APPL-NO          
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 EVALUATE NE-EMAIL-DISP-PREF-CD                         
                     WHEN 'H'                                           
                         MOVE 'HTML'        TO MI-PRV-COLUMN-VALUE-TEXT 
                     WHEN 'T'                                           
                         MOVE 'TEXT'        TO MI-PRV-COLUMN-VALUE-TEXT 
                     WHEN OTHER                                         
                         MOVE SPACES        TO MI-PRV-COLUMN-VALUE-TEXT 
                 END-EVALUATE                                           
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE 'EMAIL DISPLAY PREF'  TO MI-COLUMN-DESC           
                                                                        
                 PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT    
              END-IF.                                                   
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32947400
      ******************************************************************32948000
      * 6100-INS-TRANS-HIST-ACCT                                       *32950000
      * INSERTS DATA IN TRANSACTION HISTORY AND DETAIL TABLES          *32951000
      * FOR EMAIL AND PAPER AND EMAIL PMT REMINDER - ACCOUNT LEVEL     *32952000
      ******************************************************************32960000
       6100-INS-TRANS-HIST-ACCT.                                        
                                                                        
           IF WS-TRAN-APPL-NO = 0                                       
              PERFORM 7000-SELECT-TIMESTAMP          THRU 7000-EXIT     
              MOVE WS-TRAN-COMMENT-TEXT     TO MH-TRAN-COMMENT-TEXT     
              MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                       
                                            TO MH-TRAN-COMMENT-LEN      
      ** DATA FOR CSS_MNT_TRANS_HIST                                    32980800
              MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO     
              MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS            
              MOVE 'F'                      TO MH-CODE-TRAN-TYPE        
              MOVE '998'                    TO MH-RESP-AREA-ID          
              MOVE WS-PREV-ACCOUNT-NO       TO MH-ACCOUNT-NO            
              MOVE +0                       TO MH-CUSTOMER-NO           
              MOVE +0                       TO MH-PREMISE-NO            
              MOVE 'SYSTEM'                 TO MH-USER-ID               
              MOVE WS-APPL-PGM-ID-ACC       TO MH-APPL-PROGRAM-ID       
              MOVE +0                       TO MH-ENTITY-KEY-DESC-LEN   
              MOVE SPACES                   TO MH-ENTITY-KEY-DESC-TEXT  
              MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO     
           END-IF.                                                      
                                                                        
      ** DATA FOR CSS_MT_TRN_HST_DET                                    32982400
           IF PAPER-ONLY                                                
               ADD  1                       TO WS-TRAN-APPL-NO          
               MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO          
               MOVE +15                     TO MI-PRV-COLUMN-VALUE-LEN  
               MOVE 'EMAIL AND PAPER'       TO MI-PRV-COLUMN-VALUE-TEXT 
               MOVE SPACES                  TO MI-TABLE-ID              
               MOVE +10                     TO MI-CHG-COLUMN-VALUE-LEN  
               MOVE 'PAPER ONLY'            TO MI-CHG-COLUMN-VALUE-TEXT 
               MOVE 'BILL NOTIFY OPT'       TO MI-COLUMN-DESC           
               PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT    
           END-IF.                                                      
                                                                        
                                                                        
           IF EMAIL-PMT-REMINDER                                        
               ADD 1                        TO WS-TRAN-APPL-NO          
               MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO          
               MOVE SPACES                  TO MI-TABLE-ID              
               MOVE +18                     TO MI-PRV-COLUMN-VALUE-LEN  
               MOVE 'EMAIL PMT REMINDER'    TO MI-PRV-COLUMN-VALUE-TEXT 
               MOVE +11                     TO MI-CHG-COLUMN-VALUE-LEN  
               MOVE '* DELETED *'           TO MI-CHG-COLUMN-VALUE-TEXT 
               MOVE 'ATTRIBUTE DESC '       TO MI-COLUMN-DESC           
               PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT    
                                                                        
               ADD 1                        TO WS-TRAN-APPL-NO          
               MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO          
               MOVE SPACES                  TO MI-TABLE-ID              
               MOVE +6                      TO MI-PRV-COLUMN-VALUE-LEN  
               MOVE 'OPT IN'                TO MI-PRV-COLUMN-VALUE-TEXT 
               MOVE +7                      TO MI-CHG-COLUMN-VALUE-LEN  
               MOVE 'OPT OUT'               TO MI-CHG-COLUMN-VALUE-TEXT 
               MOVE ' PYMT REMINDER '       TO MI-COLUMN-DESC           
               PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT    
           END-IF.                                                      
                                                                        
       6100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33045100
      ******************************************************************33046200
      * 6251-GET-FJC01-DATE                                            *33046300
      * COPYBOOK CONTAINING DATE PARAMETER RETRIEVAL LOGIC             *33046400
      ******************************************************************33046500
                                                                        
           EXEC SQL                                                     33046700
              INCLUDE CPD00037                                          33046800
           END-EXEC.                                                    33046900
                                                                        
      ******************************************************************33047100
      * 6253-GET-FJC01-CHKP-LIMIT                                      *33047200
      * COPYBOOK CONTAINING PARM DATA READ LOGIC                       *33047300
      ******************************************************************33047400
                                                                        
            EXEC SQL                                                    33047600
               INCLUDE CPD00034                                         33047700
            END-EXEC.                                                   33047800
      ******************************************************************33047900
      * 6525-PREV-BUSINESS-DAY                                         *33048000
      * DETERMINE THE PREVIOUS BUSINESS DAY                            *33048100
      ******************************************************************33048200
                                                                        
           EXEC SQL                                                     33048400
               INCLUDE CPD00315                                         33048500
           END-EXEC.                                                    33048600
                                                                        
      ******************************************************************33048800
      * 6530-LOAD-MNT-TRANS-HIST.                                      *33048900
      * COPYBOOK CONTAINING TRANSACTION HISTORY                        *33049000
      ******************************************************************33049100
                                                                        
           EXEC SQL                                                     33050000
              INCLUDE CPD00067                                          33060000
           END-EXEC.                                                    33070000
      *                                                                 33591000
      ******************************************************************33600000
      * 7000-SELECT-TIMESTAMP                                          *33601000
      * SELECT CURRENT TIMESTAMP                                       *33610000
      ******************************************************************33620000
       7000-SELECT-TIMESTAMP.                                           
      *                                                                 33640000
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     33650000
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP             33660000
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                  33670000
MFA-TR*    END-EXEC.                                                    33680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSAC193  ABORT **************'      
               DISPLAY '* 7000-SELECT-TIMESTAMP                 *'      
               DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSAC193  ABORT **************'      
               PERFORM 9900-ABEND                     THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33862600
      ******************************************************************33862700
      * 7100-GET-FROM-DATE                                             *33862800
      * GET FROM DATE                                                  *33862900
      ******************************************************************33863000
       7100-GET-FROM-DATE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD(D, (CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROCESSED-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESSED-DT
              ) <> 0) OR (LEN(:WS-PROCESSED-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESSED-DT
              ), CONVERT(DATE, :WS-PROCESSED-DT) ))     
                                                      - :WS-NBR-DAYS
              )-1, CAST('00010101' AS DATE))
            INTO
              :WS-FROM-DATE   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     33866000
MFA-TR*       SET :WS-FROM-DATE = DATE(DAYS(DATE(:WS-PROCESSED-DT))     33867000
MFA-TR*                                               - :WS-NBR-DAYS)   33868000
MFA-TR*    END-EXEC.                                                    33869000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSAC193  ABORT **************'      
               DISPLAY '* 7100-GET-FROM-DATE                    *'      
               DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '* PROCESSED DATE      ' WS-PROCESSED-DT         
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSAC193  ABORT **************'      
               PERFORM 9900-ABEND                     THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 46630000
      ******************************************************************46640000
      * 7200-OPEN-DELINQ-CUR.                                          *46650000
      * OPEN CURSOR                                                    *46651000
      ******************************************************************46660000
       7200-OPEN-DELINQ-CUR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN DELINQ_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    7200-OPEN-DELINQ-CUR              *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 46890000
      ******************************************************************46900000
      * 7210-FETCH-DELINQ-CUR.                                         *46910000
      * FETCH CURSOR                                                   *46911000
      ******************************************************************46920000
       7210-FETCH-DELINQ-CUR.                                           
                                                                        
           EXEC SQL                                                     
              FETCH DELINQ_CURSOR                                       
               INTO :C8-COMPANY-NO                                      
                   ,:C8-DELINQ-CD                                       
                   ,:C8-DELINQ-VALUE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    7210-FETCH-DELINQ-CUR             *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 47180000
      ******************************************************************47190000
      * 7220-CLOSE-DELINQ-CUR.                                         *47200000
      * CLOSE CURSOR                                                   *47201000
      ******************************************************************47210000
       7220-CLOSE-DELINQ-CUR.                                           
                                                                        
           EXEC SQL                                                     
              CLOSE DELINQ_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    7220-CLOSE-DELINQ-CUR             *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 47440000
      ******************************************************************47450000
      * 7300-OPEN-CANDIDATE-CUR                                        *47460000
      * OPEN CANDIDATE CURSOR                                          *47461000
      ******************************************************************47470000
       7300-OPEN-CANDIDATE-CUR.                                         
                                                                        
           EXEC SQL                                                     
              OPEN CANDIDATE_ACCT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    7300-OPEN-CANDIDATE-CUR           *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROCESSED_DT BETWEEN ' WS-FROM-DATE            
              DISPLAY '*                  AND ' WS-PROCESSED-DT         
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 47720000
      ******************************************************************47730000
      * 7310-FETCH-CANDIDATE-CUR                                       *47740000
      * FETCH CANDIDATE CURSOR                                         *47740100
      ******************************************************************47750000
       7310-FETCH-CANDIDATE-CUR.                                        
                                                                        
           EXEC SQL                                                     
              FETCH CANDIDATE_ACCT                                      
               INTO :AE-ACCOUNT-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-COMPANY-NO                                      
                   ,:AE-EMAIL-EVENT-CD                                  
                   ,:WS-ACCT-COUNT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    7310-FETCH-CANDIDATE-CUR          *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROCESSED_DT BETWEEN ' WS-FROM-DATE            
              DISPLAY '*                  AND ' WS-PROCESSED-DT         
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 48070000
      ******************************************************************48080000
      * 7320-CLOSE-CANDIDATE-CUR                                       *48090000
      * CLOSE CANDIDATE CURSOR                                         *48091000
      ******************************************************************48100000
       7320-CLOSE-CANDIDATE-CUR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE CANDIDATE_ACCT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    7320-CLOSE-CANDIDATE-CUR          *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROCESSED_DT BETWEEN ' WS-FROM-DATE            
              DISPLAY '*                  AND ' WS-PROCESSED-DT         
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 48330000
      ******************************************************************48340000
      * 7400-SELECT-ACCT-ATTRIBUTE                                     *48350000
      * QUERY USED TO CHECK PAPER ONLY BILL NOTIFICATION AND EMAIL PMT *48351000
      * REMINDER EXISTS FOR ACCOUNT                                    *48352000
      ******************************************************************48360000
       7400-SELECT-ACCT-ATTRIBUTE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-PAPER-ONLY                                     
                FROM CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                     
                    ,CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
               WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC           
                 AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC          
                 AND WZ.COMPANY_NO        = :WZ-COMPANY-NO              
                 AND YP.ACCOUNT_NO        = :YP-ACCOUNT-NO              
                 AND WZ.ATTRIBUTE_STAT_CD = 'A'                         
                 AND WZ.ATTRIBUTE_TYPE_TX = 'EMAIL'                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     48390000
MFA-TR*       SELECT 'Y'                                                48400000
MFA-TR*         INTO :WS-PAPER-ONLY                                     48410000
MFA-TR*         FROM CSS_ATTRIBUTE WZ                                   48420000
MFA-TR*             ,CSS_ACCT_ATTRIBUTE YP                              48430000
MFA-TR*        WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC           48440000
MFA-TR*          AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC          48450000
MFA-TR*          AND WZ.COMPANY_NO        = :WZ-COMPANY-NO              48460000
MFA-TR*          AND YP.ACCOUNT_NO        = :YP-ACCOUNT-NO              48470000
MFA-TR*          AND WZ.ATTRIBUTE_STAT_CD = 'A'                         48480000
MFA-TR*          AND WZ.ATTRIBUTE_TYPE_TX = 'EMAIL'                     48490000
MFA-TR*         WITH UR                                                 48491000
MFA-TR*    END-EXEC.                                                    48500000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    7400-SELECT-ACCT-ATTRIBUTE        *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* ACCOUNT_NO           ' YP-ACCOUNT-NO           
              DISPLAY '* COMPANY_NO           ' WZ-COMPANY-NO           
              DISPLAY '* ATTRIBUTE_DESC       ' YP-ATTRIBUTE-DESC       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 49081000
      ******************************************************************49082000
      * 7550-GET-CUST-EMAIL                                            *49083000
      * SELECT EMAIL ADDRESS AND EMAIL DISPALY PREFERENCE CODE         *49084000
      ******************************************************************49085000
       7550-GET-CUST-EMAIL.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) EMAIL_ADDRESS_TX,
              EMAIL_DISP_PREF_CD                                
                INTO  :NE-EMAIL-ADDRESS-TX                              
                     ,:NE-EMAIL-DISP-PREF-CD                            
                FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO     =:NE-CUSTOMER-NO                   
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     49088000
MFA-TR*       SELECT  EMAIL_ADDRESS_TX                                  49089000
MFA-TR*              ,EMAIL_DISP_PREF_CD                                49089100
MFA-TR*         INTO  :NE-EMAIL-ADDRESS-TX                              49089200
MFA-TR*              ,:NE-EMAIL-DISP-PREF-CD                            49089300
MFA-TR*         FROM CSS_CUST_EMAIL                                     49089400
MFA-TR*        WHERE CUSTOMER_NO     =:NE-CUSTOMER-NO                   49089500
MFA-TR*        FETCH FIRST ROW ONLY                                     49089600
MFA-TR*         WITH UR                                                 49089700
MFA-TR*    END-EXEC.                                                    49089800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    7550-GET-CUST-EMAIL               *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* CUSTOMER_NO          ' NE-CUSTOMER-NO          
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 49091600
      **************************************************************    49091700
      * 7600-START-FCSJC01                                         *    49091800
      * 7610-READ-FCSJC01                                          *    49091900
      * 7611-CLOSE                                                 *    49092000
      * COPYBOOK CONTAINING DATE OVERRIDE RETRIEVAL LOGIC          *    49092100
      **************************************************************    49092200
                                                                        
           EXEC SQL                                                     49092400
               INCLUDE CPD00038                                         49092500
           END-EXEC.                                                    49092600
                                                                        
      *                                                                 49094200
      ******************************************************************49097000
      * 8100-INSERT-ATTRB-CD                                           *49100000
      * INSERTS RECORD IN CSS_ACCT_ATTRIBUTE TABLE                     *49110000
      ******************************************************************49120000
       8100-INSERT-ATTRB-CD.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_ATTRIBUTE                            
                     (                                                  
                      ACCOUNT_NO                                        
                     ,ATTRIBUTE_DESC                                    
                     ,ATTRIBUTE_VALUE_CD                                
                     ,ATTRIBUTE_VALUE_DT                                
                     ,ATTRIBUTE_VALUE_TX                                
                     )                                                  
              VALUES                                                    
                     (                                                  
                      :YP-ACCOUNT-NO                                    
                     ,:YP-ATTRIBUTE-DESC                                
                     ,:YP-ATTRIBUTE-VALUE-CD                            
                     ,CAST(SYSDATETIMEOFFSET() AS DATE)                         
                     ,:YP-ATTRIBUTE-VALUE-TX                            
                     )                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     49150000
MFA-TR*       INSERT INTO CSS_ACCT_ATTRIBUTE                            49160000
MFA-TR*              (                                                  49161000
MFA-TR*               ACCOUNT_NO                                        49170000
MFA-TR*              ,ATTRIBUTE_DESC                                    49180000
MFA-TR*              ,ATTRIBUTE_VALUE_CD                                49190000
MFA-TR*              ,ATTRIBUTE_VALUE_DT                                49200000
MFA-TR*              ,ATTRIBUTE_VALUE_TX                                49210000
MFA-TR*              )                                                  49211000
MFA-TR*       VALUES                                                    49220000
MFA-TR*              (                                                  49221000
MFA-TR*               :YP-ACCOUNT-NO                                    49230000
MFA-TR*              ,:YP-ATTRIBUTE-DESC                                49240000
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-CD                            49250000
MFA-TR*              ,CURRENT DATE                                      49260000
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-TX                            49270000
MFA-TR*              )                                                  49271000
MFA-TR*    END-EXEC.                                                    49280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    8100-INSERT-ATTRB-CD              *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* ACCOUNT_NO           ' YP-ACCOUNT-NO           
              DISPLAY '* ATTRIBUTE_DESC       ' YP-ATTRIBUTE-DESC       
              DISPLAY '* ATTRIBUTE_VALUE_CD   ' YP-ATTRIBUTE-VALUE-CD   
              DISPLAY '* CURRENT_DATE         ' WS-CURRENT-DATE         
              DISPLAY '* ATTRIBUTE_VALUE_TX   ' YP-ATTRIBUTE-VALUE-TX   
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 49461000
      ******************************************************************49470000
      * 8200-DELETE-ATTRB-CD                                          **49480000
      * DELETE ROW IN CSS_ACCT_ATTRIBUTE                              **49490000
      ******************************************************************49500000
       8200-DELETE-ATTRB-CD.                                            
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ACCT_ATTRIBUTE                            
               WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                    
                 AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    8200-DELETE-ATTRB-CD              *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* ACCOUNT_NO           ' YP-ACCOUNT-NO           
              DISPLAY '* ATTRIBUTE_DESC       ' YP-ATTRIBUTE-DESC       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 55363100
      ******************************************************************55363200
      * 8300-DELETE-CUST-EMAIL                                         *55363300
      * DELETES EMAIL ADDRESS RECORD                                   *55363400
      ******************************************************************55363500
       8300-DELETE-CUST-EMAIL.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_EMAIL                                
               WHERE CUSTOMER_NO  = :NE-CUSTOMER-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    8300-DELETE-CUST-EMAIL            *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* CUSTOMER_NO          ' NE-CUSTOMER-NO          
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 55366400
      ******************************************************************55366500
      * 8400-RESET-JOB-PARM                                            *55366600
      * UPDATES STATUS TO INACTIVE FOR COMMAND CODE AS DATE            *55366700
      ******************************************************************55366800
       8400-RESET-JOB-PARM.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
                 SET STATUS       = :G6-STATUS                          
               WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
                 AND CMND_CODE    = :G6-CMND-CODE                       
                 AND COMPANY_NO   = :G6-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSAC193 ABORT **************'        
              DISPLAY '*    8400-RESET-JOB-PARM               *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROGRAM_NAME         ' G6-PROGRAM-NAME         
              DISPLAY '* CMND_CODE            ' G6-CMND-CODE            
              DISPLAY '* COMPANY_NO           ' G6-COMPANY-NO           
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSAC193 ABORT **************'        
              PERFORM 9900-ABEND                      THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 55370200
      ******************************************************************55370300
      * 8900-COMMIT.                                                   *55370400
      ******************************************************************55370500
       8900-COMMIT.                                                     
                                                                        
           EXEC SQL                                                     55371000
              INCLUDE CPD00047                                          55380000
           END-EXEC.                                                    55390000
                                                                        
           DISPLAY 'COMMITTED ' WS-COMMIT-CNTR    ' ACCOUNTS'.          
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 55470000
      ******************************************************************55470100
      * 9000-SEND-ERROR-RESULT.                                        *55470200
      * REQUIRED BY THE COPYBOOK CPD00067                              *55470300
      ******************************************************************55470400
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
                                                                        
                                                                        
      ******************************************************************55530300
      * 9000-TERMINATE.                                                *55530500
      ******************************************************************55530600
       9000-TERMINATE.                                                  
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 56100200
      ******************************************************************56100300
      * 9900-SQL-ERROR-ROUTINE                                         *56100400
      * REQUIRED BY THE COPYBOOK CPD00067                              *56100500
      ******************************************************************56100600
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           DISPLAY '********** PCSAC193  ABORT **************'.         
           DISPLAY '* ACTIVE PARA        : ' ACTIVE-PARAGRAPH.          
           DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE.     
           DISPLAY '* ABEND FUNCT        : ' ABEND-FUNCTION.            
           DISPLAY '* TABLE1             : ' TABLE-1.                   
           DISPLAY '* HOSTVAR1           : ' HOSTVAR-ELEMENT-1.         
           DISPLAY '* HOSTVAR2           : ' HOSTVAR-ELEMENT-2.         
           DISPLAY '* HOSTVAR3           : ' HOSTVAR-ELEMENT-3.         
           DISPLAY '* HOSTVAR4           : ' HOSTVAR-ELEMENT-4.         
           DISPLAY '* PROGRAM ABORTING...                   *'.         
           DISPLAY '********** PCSAC193  ABORT **************'.         
                                                                        
      ******************************************************************56103900
      * 9900-ABEND.                                                    *56104000
      ******************************************************************56104100
           EXEC SQL                                                     56104200
              INCLUDE CPD09900                                          56104300
           END-EXEC.                                                    56105000
                                                                        
