       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSAC192.                                            
       DATE-WRITTEN.                                                    
       AUTHOR. VIDHU VALSARAJAN.                                        
      ******************************************************************00050000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00060000
      *                                                                *00080000
      ******************************************************************00240000
      *        THIS PROGRAM IS USED TO INSERT ROWS INTO CSS_BATCH_EMAIL*00250000
      *        TABLE FOR AN ECUSTOMER BASED ON THE DATA FROM OUTPUT    *00260000
      *        FILE OF PCSAC191.                                       *00260000
      ******************************************************************00320000
      *               PROGRAM  MODIFICATION  LOG                       *00110000
      *                                                                *00120000
      *     DATE    | USER_ID | REASON                                 *00130000
      *-------------|---------|----------------------------------------*        
C29533*  01/11/2005 | VV90387 | NEW PROGRAM TO INSERT ROWS INTO        *00140000
      *             |         | CSS_BATCH_EMAIL FOR ECUSTOMERS.        *00140000
      *-------------|---------|----------------------------------------*        
C32352*  02/25/2005 | BB18179 | CML32352 - ADD SERVICE ADDRESS TO      *        
      *             |         | OUTPUT FILE FOR USE BY PCSCA192.  USE  *        
      *             |         | LOGIC SIMILAR TO CML 31785 - DISPLAY   *        
      *             |         | FIRST 6 CHARS OF SERV ADDR, THEN PAD   *        
      *             |         | RMDR WITH '*', AND INCL CITY / STATE.  *        
      *             |         | IE: 1401 MAIN STREET, COLUMBIA SC      *        
      *             |         |     SHOULD DISPLAY AS:                 *        
      *             |         |     1401 M**********, COLUMBIA SC      *        
      *-------------|---------|----------------------------------------*        
A04527*  06/06/2013 | MR7E794 | REMOVED UNUSED COPYBOOK CWS00056.      *        
ACT070*  02/25/2016 | MC95456 | USE NEXT VALUE FOR BATCH_EMAIL_ID IN   *        
ACT070*   APPL5460  |         | CSS_BATCH_EMAIL TABLE.                 *        
      *-------------|---------|----------------------------------------*        
      ******************************************************************00221000
             REMARKS.                                                   
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
            SELECT FCSAC191-FILE ASSIGN  UT-S-FCSAC191                  
                   FILE STATUS IS WS-FAC191-STATUS.                     
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCSAC191-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
                                                                        
       01  FAC191.                                                      
           05  E-FAC191-ACCOUNT-NO         PIC 9(13).                   
           05  E-FAC191-CUSTOMER-NO        PIC 9(10).                   
           05  E-FAC191-EMAIL-EVENT-CD     PIC X(05).                   
           05  E-FAC191-EMAIL-EVENT-DT     PIC X(10).                   
           05  E-FAC191-COMPANY-NO         PIC X(02).                   
           05  E-FAC191-REV-MTH-LST-NRML   PIC X(06).                   
C32352     05  E-FAC191-PREM-ADDR          PIC X(80).                   
C32352     05  E-FAC191-PREM-ADDR-LEN      PIC 9(03).                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC192'.
MSQ017     COPY MFASQLM.
       01  WS-START                        PIC X(40) VALUE              
           'WORKING STORAGE FOR PCSAC192 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-PGRMNAME                 PIC X(10)  VALUE 'PCSAC192'. 
           05  PROGRAM-NAME                PIC X(08)  VALUE 'PCSAC192'. 
           05  WS-COMMON                   PIC X(10)  VALUE 'COMMON  '. 
           05  WS-FAC191-STATUS            PIC X(02)  VALUE '00'.       
               88  WS-FAC191-SUCCESSFUL               VALUE '00'.       
           05  WS-END-OF-FILE              PIC X(01)  VALUE 'N'.        
               88  WS-END-OF-FCSAC191                 VALUE 'Y'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-I                        PIC X(01)  VALUE 'I'.        
           05  RS-RETURN-CODE              PIC S9(4)  COMP.             
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
                                                                        
       01  WS-ATTRIBUTE-TX.                                             
           05  WS-ATTRIBUTE-MSG            PIC X(31)  VALUE             
               'LAST-REV-MONTH-PYMT-REMINDER = '.                       
           05  WS-ATTRIBUTE-REV-MNTH       PIC X(06).                   
                                                                        
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE       PIC 9(01).                 
           05  WS-RESTART-JOB-COMPLETE REDEFINES                        
               WS-RESTART-PROCESS-TYPE       PIC X(01).                 
           05  WS-RESTART-COMMON-DATE        PIC X(10).                 
           05  WS-RESTART-PROG-ID            PIC X(08) VALUE 'PCSAC192'.
           05  WS-RESTART-CHKP-SEQ-NO        PIC 9(05) VALUE 0.         
           05  WS-RESTART-ACCT-NO            PIC 9(13) VALUE 0.         
           05  WS-RESTART-CUST-NO            PIC 9(10) VALUE 0.         
           05  WS-RESTART-COMP-NO            PIC X(02) VALUE SPACES.    
                                                                        
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH        PIC S9(04) COMP VALUE +49. 
           05  WS-IS-THIS-A-RESTART          PIC X(01) VALUE 'N'.       
               88  WS-THIS-IS-A-RESTART                VALUE 'Y'.       
           05  WS-RESTART-COMMIT-COUNTER     PIC 9(04) VALUE 0.         
           05  WS-DEFAULT-RESTART-REQ        PIC X(01) VALUE 'N'.       
           05  WS-RESTART-RECORD             PIC X(01) VALUE 'N'.       
               88  WS-RESTART-REC-FOUND                VALUE 'Y'.       
               88  WS-RESTART-REC-NOT-FOUND            VALUE 'N'.       
           05  WS-RESTART-REQ                PIC X(01).                 
           05  WS-SEQ-NO                     PIC 9(04) VALUE 0.         
           05  WS-CHKP-LUW-LIMIT             PIC 9(04) VALUE 0.         
           05  WS-CHKP-UPD-LIMIT             PIC 9(04) VALUE 0.         
           05  WS-CHKP-SEQ-NO                PIC 9(05) VALUE 0.         
           05  WS-DEFAULT-CHKP-LUW-LIMIT     PIC 9(04) VALUE 1000.      
           05  WS-DEFAULT-CHKP-UPD-LIMIT     PIC 9(04) VALUE 1000.      
                                                                        
       COPY CWS00038.                                                   01270000
       COPY CWS09900.                                                   01280000
       COPY CWS00303.                                                   01290000
       COPY CWS00010.                                                           
       COPY FIOJC01.                                                    01300000
                                                                        
      ***************************************************************** 01320000
      * SQL COMMUNICATION AREA                                        * 01330000
      ***************************************************************** 01320000
           EXEC SQL                                                     01350000
                INCLUDE SQLCA                                           01360000
           END-EXEC.                                                    01370000
                                                                        
      ***************************************************************** 01320000
      * CSS_ACCT_ATTRIBUTE    (PREFIX = YP)                           * 01470000
      ***************************************************************** 01320000
           EXEC SQL                                                     01490000
                INCLUDE TBACTATT                                        01500000
           END-EXEC.                                                    01510000
                                                                        
      ***************************************************************** 01320000
      * CSS_BATCH_EMAIL       (PREFIX = AE)                           * 01470000
      ***************************************************************** 01320000
           EXEC SQL                                                     01490000
                INCLUDE TBBEMAIL                                        01500000
           END-EXEC.                                                    01510000
                                                                        
C32352***************************************************************** 01320000
C32352* CSS_BTCH_EMAIL_DET    (PREFIX = JK)                           * 01470000
C32352***************************************************************** 01320000
C32352     EXEC SQL                                                     01490000
C32352          INCLUDE TBBTEDET                                        01500000
C32352     END-EXEC.                                                    01510000
                                                                        
      ***************************************************************** 01320000
      * CSS_JOB_PARM          (PREFIX = C8)                           * 01470000
      ***************************************************************** 01320000
           EXEC SQL                                                     01490000
                INCLUDE TBJBPARM                                        01500000
           END-EXEC.                                                    01510000
                                                                        
      ****************************************************************          
      *    CSS_RESTART        (PREFIX = RF)                          *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
                                                                        
       01  WS-END                          PIC X(40) VALUE              
          'WORKING STORAGE FOR PCSAC192 ENDS HERE  '.                   
                                                                        
                                                                        
      ******************************************************************02630000
      *   0000-MAINLINE.                                               *02650000
      *        CONTROLS MAIN PATH OF PROGRAM                           *02660000
      ******************************************************************02630000
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZATION        THRU 1000-EXIT.           
                                                                        
           PERFORM 2000-MAIN-PROCESS          THRU 2000-EXIT.           
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-SEQ-NO                  TO G6-SEQ-NO              
              MOVE WS-I                       TO G6-STATUS              
              MOVE 'RESTART-REQ=N'            TO G6-PARM-DATA           
              PERFORM 8500-RESET-JOB-PARM     THRU 8500-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 8600-DELETE-RESTART-ROW    THRU 8600-EXIT.           
                                                                        
           PERFORM 9000-TERMINATE             THRU 9000-EXIT.           
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    1000-INITIALIZATION.                                        *03000000
      *         GETS JOB PARM DATE AND OPENS FSCAC191-FILE CHECKS FOR  *03010000
      *         RESTART PROCESSING.                                    *        
      ******************************************************************02630000
       1000-INITIALIZATION.                                             
                                                                        
           DISPLAY '**************************************************'.
           DISPLAY '** PROGRAM NAME: 'PROGRAM-NAME.                     
                                                                        
           MOVE '1000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           OPEN INPUT  FCSAC191-FILE.                                   
                                                                        
           IF WS-FAC191-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**       PCSAC192   PROCESSING ERROR       **'   
              DISPLAY '     OPEN ERROR OF FCSAC191 INPUT FILE '         
              DISPLAY '     FILE STATUS = ' WS-FAC191-STATUS            
              DISPLAY '**         PROCESSING TERMINATED           **'   
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF COMMON-DATE-NEEDED                                        
              MOVE WS-COMMON               TO WS-PGRMNAME               
              MOVE SPACES                  TO WS-INPUT-AREA             
              MOVE SPACES                  TO WS-INPUT-DATA-BREAKDOWN   
              PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT           
              MOVE 'PCSAC192'              TO WS-PGRMNAME               
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE              TO WS-RESTART-COMMON-DATE.   
                                                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT   THRU 6253-EXIT.          
           PERFORM 1100-CHECK-RESTART          THRU 1100-EXIT.          
           PERFORM 6235-GET-FJC01-RESTART-REQ  THRU 6235-EXIT.          
           MOVE G6-SEQ-NO                  TO WS-SEQ-NO.                
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-CHECK-RESTART.                                            *        
      * DETERMINES IF RESTART PROCESSING IS REQUIRED.                  *        
      ******************************************************************        
       1100-CHECK-RESTART.                                              
                                                                        
           MOVE PROGRAM-NAME                   TO RF-NAME-PROGRAM.      
           MOVE 1                              TO RF-PARTITION-NO       
                                                  RF-DUP-CNTRL-NO.      
           PERFORM 7700-SELECT-RESTART         THRU 7700-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RF-RESTART-DATA-TEXT        TO WS-RESTART-DATA       
              IF WS-RESTART-PROCESS-TYPE IS NUMERIC                     
                 MOVE WS-Y                     TO WS-IS-THIS-A-RESTART  
                 DISPLAY '*******************************************'  
                 DISPLAY '*****  THIS IS A RESTART OF PCSAC192  *****'  
                 DISPLAY '*******************************************'  
              END-IF                                                    
              IF WS-RESTART-COMMON-DATE EQUAL WS-INPUT-DATE OR          
                 WS-RESTART-COMMON-DATE EQUAL SPACES                    
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '*****************************************'    
                 DISPLAY '** COMMON DATE CHANGED PRIOR TO RESTART**'    
                 DISPLAY '*****************************************'    
                 DISPLAY '** OLD COMMON DATE = ' WS-RESTART-COMMON-DATE 
                 DISPLAY '** NEW COMMON DATE = ' WS-INPUT-DATE          
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2000-MAIN-PROCESS.                                          *03963003
      *        READS FILE AND INSERTS INTO BATCH EMAIL TABLE.          *03964003
      ******************************************************************02630000
       2000-MAIN-PROCESS.                                               
                                                                        
           PERFORM 7000-READ-FCSAC191      THRU 7000-EXIT.              
                                                                        
           PERFORM 2100-MOVE-DATA          THRU 2100-EXIT.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2100-MOVE-DATA                                              *03963003
      *       INSERTS RELEVANT DATA INTO CSS_BATCH_EMAIL TABLE.        *03964003
      ******************************************************************02630000
       2100-MOVE-DATA.                                                  
                                                                        
           SET WS-RESTART-REC-NOT-FOUND       TO TRUE.                  
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM UNTIL WS-RESTART-REC-FOUND OR WS-END-OF-FCSAC191  
                IF E-FAC191-ACCOUNT-NO  = WS-RESTART-ACCT-NO AND        
                   E-FAC191-CUSTOMER-NO = WS-RESTART-CUST-NO AND        
                   E-FAC191-COMPANY-NO  = WS-RESTART-COMP-NO            
                   SET  WS-RESTART-REC-FOUND     TO TRUE                
                   MOVE WS-RESTART-CHKP-SEQ-NO   TO WS-CHKP-SEQ-NO      
                END-IF                                                  
                                                                        
                PERFORM 7000-READ-FCSAC191    THRU 7000-EXIT            
                                                                        
              END-PERFORM                                               
                                                                        
              IF WS-RESTART-REC-NOT-FOUND                               
                 DISPLAY '***********************************'          
                 DISPLAY '**  PROCESSING ERROR             **'          
                 DISPLAY '**  PARAGRAPH   = 2100-MOVE-DATA'             
                 DISPLAY '**  RESTART ACCOUNT NOT FOUND'                
                 DISPLAY '**  ACCOUNT NO     = ' WS-RESTART-ACCT-NO     
                 DISPLAY '**  CUSTOMER NO    = ' WS-RESTART-CUST-NO     
                 DISPLAY '**  COMPANY NO     = ' WS-RESTART-COMP-NO     
                 DISPLAY '**  PROCESSING TERMINATED        **'          
                 DISPLAY '***********************************'          
                 PERFORM 9900-ABEND           THRU 9900-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-FAC191-SUCCESSFUL                                      
              PERFORM UNTIL WS-END-OF-FCSAC191                          
                MOVE E-FAC191-ACCOUNT-NO      TO AE-ACCOUNT-NO          
                MOVE E-FAC191-CUSTOMER-NO     TO AE-CUSTOMER-NO         
                MOVE E-FAC191-EMAIL-EVENT-CD  TO AE-EMAIL-EVENT-CD      
                MOVE E-FAC191-EMAIL-EVENT-DT  TO AE-EMAIL-EVENT-DT      
                MOVE E-FAC191-COMPANY-NO      TO AE-COMPANY-NO          
ACT070          PERFORM 7800-SET-NEXT-VALUE            THRU 7800-EXIT   
                PERFORM 8000-INSERT-BATCH-EMAIL        THRU 8000-EXIT   
                                                                        
C32352          PERFORM 7100-SELECT-BATCH-EMAIL-ID     THRU 7100-EXIT   
C32352          IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
C32352             AND E-FAC191-PREM-ADDR GREATER THAN SPACES           
C32352                 MOVE AE-BATCH-EMAIL-ID  TO JK-BATCH-EMAIL-ID     
C32352                 MOVE 'PREM-ADDR'        TO JK-FIELD-NAME-TX      
C32352                 MOVE E-FAC191-PREM-ADDR TO JK-FIELD-VALUE-TX-TEXT
C32352                 MOVE E-FAC191-PREM-ADDR-LEN                      
C32352                   TO JK-FIELD-VALUE-TX-LEN                       
C32352                 PERFORM 8700-INSERT-BTCH-EMAIL-DET THRU 8700-EXIT
C32352          END-IF                                                  
                                                                        
                MOVE E-FAC191-REV-MTH-LST-NRML                          
                                              TO WS-ATTRIBUTE-REV-MNTH  
                MOVE +37                      TO                        
                                              YP-ATTRIBUTE-VALUE-TX-LEN 
                MOVE WS-ATTRIBUTE-TX          TO                        
                                              YP-ATTRIBUTE-VALUE-TX-TEXT
                                                                        
                PERFORM 8050-UPDATE-ACCT-ATTRIBUTE     THRU 8050-EXIT   
                                                                        
                ADD 1                         TO                        
                                              WS-RESTART-COMMIT-COUNTER 
                IF WS-RESTART-COMMIT-COUNTER  = WS-CHKP-LUW-LIMIT       
                OR WS-RESTART-COMMIT-COUNTER  = WS-CHKP-UPD-LIMIT       
                   ADD  1                     TO WS-CHKP-SEQ-NO         
                   PERFORM 8100-PRE-COMMIT             THRU 8100-EXIT   
                   MOVE 0                     TO                        
                                              WS-RESTART-COMMIT-COUNTER 
                END-IF                                                  
                PERFORM 7000-READ-FCSAC191             THRU 7000-EXIT   
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7000-READ-FCSAC191                                           *08063003
      *        READS INPUT FILE FCSAC191                               *08064003
      ******************************************************************08061003
                                                                        
       7000-READ-FCSAC191.                                              
                                                                        
           MOVE '7000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           READ FCSAC191-FILE                                           
             AT END                                                     
                SET WS-END-OF-FCSAC191     TO TRUE.                     
                                                                        
           IF WS-FAC191-SUCCESSFUL OR WS-END-OF-FCSAC191                
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7000-READ-FCSAC191'          
              DISPLAY '**  FILE STATUS  = ' WS-FAC191-STATUS            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32352******************************************************************        
C32352*   7100-SELECT-BATCH-EMAIL-ID                                   *        
C32352*   RETRIEVES BATCH_EMAIL_ID FROM CSS_BATCH_EMAIL                *        
C32352******************************************************************        
C32352 7100-SELECT-BATCH-EMAIL-ID.                                      
                                                                        
C32352     MOVE '7100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
C32352     EXEC SQL                                                     
             SELECT TOP(1) BATCH_EMAIL_ID                                      
               INTO :AE-BATCH-EMAIL-ID                                  
               FROM CSS_BATCH_EMAIL                                     
              WHERE COMPANY_NO     = :AE-COMPANY-NO                     
                AND ACCOUNT_NO     = :AE-ACCOUNT-NO                     
                AND CUSTOMER_NO    = :AE-CUSTOMER-NO                    
                AND EMAIL_EVENT_CD = :AE-EMAIL-EVENT-CD                 
                AND EMAIL_EVENT_DT = IIF(TRY_CONVERT(DATE, 
                                                     :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )                 
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT BATCH_EMAIL_ID                                              
MFA-TR*        INTO :AE-BATCH-EMAIL-ID                                          
MFA-TR*        FROM CSS_BATCH_EMAIL                                             
MFA-TR*       WHERE COMPANY_NO     = :AE-COMPANY-NO                             
MFA-TR*         AND ACCOUNT_NO     = :AE-ACCOUNT-NO                             
MFA-TR*         AND CUSTOMER_NO    = :AE-CUSTOMER-NO                            
MFA-TR*         AND EMAIL_EVENT_CD = :AE-EMAIL-EVENT-CD                         
MFA-TR*         AND EMAIL_EVENT_DT = :AE-EMAIL-EVENT-DT                         
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C32352     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C32352     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
C32352        CONTINUE                                                  
C32352     ELSE                                                         
C32352        DISPLAY '***  ERROR IN PARA #: ' WS-ACTIVE-PARAGRAPH      
C32352        DISPLAY '***   PARAGRAPH DESC: SELECT-BATCH-EMAIL-ID'     
C32352        DISPLAY '***    AE-COMPANY-NO: ' AE-COMPANY-NO            
C32352        DISPLAY '***    AE-ACCOUNT-NO: ' AE-ACCOUNT-NO            
C32352        DISPLAY '***   AE-CUSTOMER-NO: ' AE-CUSTOMER-NO           
C32352        DISPLAY '***AE-EMAIL-EVENT-CD: ' AE-EMAIL-EVENT-CD        
C32352        DISPLAY '***AE-EMAIL-EVENT-DT: ' AE-EMAIL-EVENT-DT        
C32352        DISPLAY '***      RETURN CODE: ' WS-ACTIVE-RETURN-CODE    
C32352        DISPLAY '***      PROCESSING TERMINATED     ***'          
C32352        PERFORM 9900-ABEND                THRU 9900-EXIT          
C32352     END-IF.                                                      
                                                                        
C32352 7100-EXIT.                                                       
C32352     EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7700-SELECT-RESTART.                                         *08063003
      *   RETRIEVES RESTART DATA VALUES.                               *08064003
      ******************************************************************08061003
                                                                        
       7700-SELECT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
              SELECT RESTART_DATA                                       
                INTO :RF-RESTART-DATA                                   
                FROM CSS_RESTART                                        
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND                
                     PARTITION_NO = :RF-PARTITION-NO AND                
                     DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***  ERROR IN 7700-SELECT-RESTART  ***'          
              DISPLAY '***  RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***      PROCESSING TERMINATED     ***'          
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT070*****************************************************************         
ACT070* 7800-SET-NEXT-VALUE.                                          *         
ACT070*****************************************************************         
ACT070 7800-SET-NEXT-VALUE.                                             
      *                                                                         
ACT070     EXEC SQL                                                     
ACT070       SELECT
              NEXT VALUE FOR SEQ_AE_BATCH_EMAIL_ID
            INTO
              :AE-BATCH-EMAIL-ID 
ACT070     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*      SET :AE-BATCH-EMAIL-ID = NEXTVAL FOR SEQ_AE_BATCH_EMAIL_ID 07458000
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
ACT070     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
ACT070     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT070        CONTINUE                                                  
ACT070     ELSE                                                         
ACT070        DISPLAY '***  ERROR IN PARA #: ' WS-ACTIVE-PARAGRAPH      
ACT070        DISPLAY '***   PARAGRAPH DESC: SET-NEXT-VALUE'            
ACT070        DISPLAY '***AE-BATCH-EMAIL-ID: ' AE-BATCH-EMAIL-ID        
ACT070        DISPLAY '***      RETURN CODE: ' WS-ACTIVE-RETURN-CODE    
ACT070        DISPLAY '***      PROCESSING TERMINATED     ***'          
ACT070        PERFORM 9900-ABEND                THRU 9900-EXIT          
ACT070     END-IF.                                                      
                                                                        
      *                                                                         
ACT070 7800-EXIT.                                                       
ACT070     EXIT.                                                        
      *                                                                 12950000
      ******************************************************************08079400
      *   8000-INSERT-BATCH-EMAIL.                                     *08090000
      *        INSERTS A ROW IN CSS_BATCH_EMAIL TABLE                  *08100000
      ******************************************************************08120000
                                                                        
       8000-INSERT-BATCH-EMAIL.                                         
                                                                        
           MOVE '8000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_BATCH_EMAIL                             
                       (ACCOUNT_NO                                      
                       ,CUSTOMER_NO                                     
                       ,EMAIL_EVENT_CD                                  
                       ,EMAIL_EVENT_DT                                  
ACT070                 ,BATCH_EMAIL_ID                                  
                       ,COMPANY_NO)                                     
                VALUES                                                  
                       (:AE-ACCOUNT-NO                                  
                       ,:AE-CUSTOMER-NO                                 
                       ,:AE-EMAIL-EVENT-CD                              
                       ,IIF(TRY_CONVERT(DATE, :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )                           
ACT070                 ,:AE-BATCH-EMAIL-ID                              
                       ,:AE-COMPANY-NO)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         INSERT INTO CSS_BATCH_EMAIL                             08190000
MFA-TR*                (ACCOUNT_NO                                      08200000
MFA-TR*                ,CUSTOMER_NO                                     08210000
MFA-TR*                ,EMAIL_EVENT_CD                                  08220000
MFA-TR*                ,EMAIL_EVENT_DT                                  08230000
MFA-TR*                ,BATCH_EMAIL_ID                                          
MFA-TR*                ,COMPANY_NO)                                     08240000
MFA-TR*         VALUES                                                  08250000
MFA-TR*                (:AE-ACCOUNT-NO                                  08260000
MFA-TR*                ,:AE-CUSTOMER-NO                                 08270000
MFA-TR*                ,:AE-EMAIL-EVENT-CD                              08280000
MFA-TR*                ,:AE-EMAIL-EVENT-DT                              08290000
MFA-TR*                ,:AE-BATCH-EMAIL-ID                              08290000
MFA-TR*                ,:AE-COMPANY-NO)                                 08300000
MFA-TR*    END-EXEC.                                                    08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 8000-INSERT-BATCH-EMAIL'    
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  ACCOUNT NO     = ' AE-ACCOUNT-NO             
              DISPLAY '**  CUSTOMER NO    = ' AE-CUSTOMER-NO            
              DISPLAY '**  EMAIL EVENT CD = ' AE-EMAIL-EVENT-CD         
              DISPLAY '**  EMAIL EVENT DT = ' AE-EMAIL-EVENT-DT         
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08079400
      *   8050-UPDATE-ACCT-ATTRIBUTE.                                  *08090000
      *        UPDATES THE REVENUE MONTH LAST NORMAL IN ACCT_ATTRIBUTE *08100000
      ******************************************************************08120000
                                                                        
       8050-UPDATE-ACCT-ATTRIBUTE.                                      
                                                                        
           MOVE '8050'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_ACCT_ATTRIBUTE                               
                   SET ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX      
                 WHERE ACCOUNT_NO         = :AE-ACCOUNT-NO              
                   AND ATTRIBUTE_DESC     = 'EMAIL PMT REMINDER'        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 8050-UPDATE-ACCT-ATTRIBUTE' 
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  ACCOUNT NO     = ' AE-ACCOUNT-NO             
              DISPLAY '**  ATTRIBUTE_DESC = ' 'EMAIL PMT REMINDER'      
              DISPLAY '**  EMAIL EVENT CD = ' AE-EMAIL-EVENT-CD         
              DISPLAY '**  EMAIL EVENT DT = ' AE-EMAIL-EVENT-DT         
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-PRE-COMMIT                                                *        
      * POPULATED REQUIRED FILEDS BEFORE COMMIT.                       *        
      ******************************************************************        
       8100-PRE-COMMIT.                                                 
                                                                        
           MOVE PROGRAM-NAME           TO RF-NAME-PROGRAM.              
           MOVE 1                      TO RF-PARTITION-NO.              
           MOVE 1                      TO RF-DUP-CNTRL-NO.              
           MOVE 1                      TO WS-RESTART-PROCESS-TYPE.      
           MOVE WS-INPUT-DATE          TO WS-RESTART-COMMON-DATE.       
           MOVE WS-CHKP-SEQ-NO         TO WS-RESTART-CHKP-SEQ-NO.       
           MOVE AE-ACCOUNT-NO          TO WS-RESTART-ACCT-NO.           
           MOVE AE-CUSTOMER-NO         TO WS-RESTART-CUST-NO.           
           MOVE AE-COMPANY-NO          TO WS-RESTART-COMP-NO.           
           MOVE WS-RESTART-DATA        TO RF-RESTART-DATA-TEXT.         
           MOVE WS-RESTART-DATA-LENGTH TO RF-RESTART-DATA-LEN.          
           PERFORM 8200-WRITE-RESTART  THRU 8200-EXIT.                  
           PERFORM 8400-ISSUE-CHKP     THRU 8400-EXIT.                  
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' ' AE-ACCOUNT-NO.  
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-WRITE-RESTART.                                            *        
      * UPDATES RESTART DATA.                                          *        
      ******************************************************************        
        8200-WRITE-RESTART.                                             
                                                                        
            EXEC SQL                                                    
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  PERFORM 8300-INSERT-RESTART         THRU 8300-EXIT    
               ELSE                                                     
                  DISPLAY '*** ABEND IN 8200-WRITE-RESTART ***'         
                  DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
                  DISPLAY 'PROGRAM NAME  ' RF-NAME-PROGRAM              
                  DISPLAY 'PARTITION NO  ' RF-PARTITION-NO              
                  PERFORM 9900-ABEND                  THRU 9900-EXIT    
               END-IF                                                   
            END-IF.                                                     
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-INSERT-RESTART.                                           *        
      * INSERTS INTO RESTART TABLE.                                    *        
      ******************************************************************        
       8300-INSERT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RESTART                                   
                     (NAME_PROGRAM,                                     
                      PARTITION_NO,                                     
                      DUP_CNTRL_NO,                                     
                      RESTART_DATA)                                     
              VALUES                                                    
                     (:RF-NAME-PROGRAM,                                 
                      :RF-PARTITION-NO,                                 
                      :RF-DUP-CNTRL-NO,                                 
                      :RF-RESTART-DATA)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ABEND IN 8300-INSERT-RESTART ***'            
              DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY 'PROGRAM NAME  ' RF-NAME-PROGRAM                  
              DISPLAY 'PARTITION NO  ' RF-PARTITION-NO                  
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8400-ISSUE-CHKP.                                              *         
      * COMMITS THE UNIT OF WORK.                                     *         
      *****************************************************************         
       8400-ISSUE-CHKP.                                                 
                                                                        
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8500-RESET-JOB-PARM.                                          *         
      * RESETS STATUS TO INACTIVE ON SUCCESSFUL COMPLETION OF RESTART *         
      * JOB.                                                          *         
      *****************************************************************         
       8500-RESET-JOB-PARM.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
                  SET STATUS       = :G6-STATUS,                        
                      PARM_DATA    = :G6-PARM-DATA                      
                WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
                  AND CMND_CODE    = :G6-CMND-CODE                      
                  AND COMPANY_NO   = :G6-COMPANY-NO                     
                  AND SEQ_NO       = :G6-SEQ-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ERROR IN 8500-RESET-JOB-PARM ***'            
              DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '***   PROCESSING TERMINATED ***'                 
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8600-DELETE-RESTART-ROW.                                      *         
      * DELETES RESTART ROW ON SUCCESSFUL JOB COMPLETION.             *         
      *****************************************************************         
       8600-DELETE-RESTART-ROW.                                         
                                                                        
           MOVE PROGRAM-NAME           TO RF-NAME-PROGRAM.              
           MOVE 1                      TO RF-PARTITION-NO.              
           MOVE 1                      TO RF-DUP-CNTRL-NO.              
           EXEC SQL                                                     
               DELETE FROM CSS_RESTART                                  
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ERROR IN 8600-DELETE-RESTART-ROW ***'        
              DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '***       PROCESSING TERMINATED      ***'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32352*****************************************************************         
C32352* 8700-INSERT-BTCH-EMAIL-DET.                                   *         
C32352* INSERTS DETAIL ROW INTO CSS_BTCH_EMAIL_DET.                   *         
C32352*****************************************************************         
C32352 8700-INSERT-BTCH-EMAIL-DET.                                      
                                                                        
C32352     MOVE '8700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
C32352     EXEC SQL                                                     
C32352       INSERT INTO CSS_BTCH_EMAIL_DET                             
C32352              (BATCH_EMAIL_ID                                     
C32352              ,FIELD_NAME_TX                                      
C32352              ,FIELD_VALUE_TX)                                    
C32352       VALUES                                                     
C32352              (:JK-BATCH-EMAIL-ID                                 
C32352              ,:JK-FIELD-NAME-TX                                  
C32352              ,:JK-FIELD-VALUE-TX)                                
C32352     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C32352     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C32352     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
C32352        IF SQLCODE = -803                                         
C32352           MOVE SUCCESSFUL-CALL TO SQLCODE                        
C32352           MOVE SUCCESSFUL-CALL TO WS-ACTIVE-RETURN-CODE          
C32352        END-IF                                                    
C32352     ELSE                                                         
C32352        DISPLAY '***  ERROR IN PARA #: ' WS-ACTIVE-PARAGRAPH      
C32352        DISPLAY '***   PARAGRAPH DESC: INSERT-BTCH-EMAIL-DET'     
C32352        DISPLAY '***    AE-ACCOUNT-NO: ' AE-ACCOUNT-NO            
C32352        DISPLAY '***JK-BATCH-EMAIL-ID: ' JK-BATCH-EMAIL-ID        
C32352        DISPLAY '*** JK-FIELD-NAME-TX: ' JK-FIELD-NAME-TX         
C32352        DISPLAY '***JK-FIELD-VALUE-TX: ' JK-FIELD-VALUE-TX        
C32352        DISPLAY '***      RETURN CODE: ' WS-ACTIVE-RETURN-CODE    
C32352        DISPLAY '***      PROCESSING TERMINATED     ***'          
C32352        PERFORM 9900-ABEND                     THRU 9900-EXIT     
C32352     END-IF.                                                      
                                                                        
C32352 8700-EXIT.                                                       
C32352     EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   9000-TERMINATE.                                              *10060000
      ******************************************************************08061003
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSAC191-FILE.                                         
                                                                        
           IF WS-FAC191-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSAC191  PROCESSING ERROR **'               
              DISPLAY '**    CLOSE ERROR OF FCSAC191 INPUT FILE'        
              DISPLAY '**    FILE STATUS = ' WS-FAC191-STATUS           
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0605-VALIDATE-RESTART-REQ.                                     *        
      * VALIDATES IF RESTART IS REQUIRED AND IF SO JOB PARM FLAGS ARE  *        
      * APPROPRIATELY SET.                                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00030                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00034                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6235-GET-FJC01-RESTART-REQ.                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00035                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************08061003
      *  6251-GET-FJC01-DATE                                           *10290000
      ******************************************************************08061003
                                                                        
       COPY CPD00037.                                                   10330000
                                                                        
      ******************************************************************08061003
      *  7600-START-FCSJC01                                            *10370000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10410000
               INCLUDE CPD00038                                         10420000
           END-EXEC.                                                    10430000
                                                                        
      ******************************************************************08061003
      * COPYBOOK FOR ABEND ROUTINE                                     *10470000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10510000
               INCLUDE CPD0023B                                         10520000
           END-EXEC.                                                    10530000
                                                                        
      ******************************************************************08061003
      * COPYBOOK FOR ABEND ROUTINE                                     *10470000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10510000
               INCLUDE CPD09900                                         10520000
           END-EXEC.                                                    10530000
