       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSAC191.                                            
       DATE-WRITTEN.                                                    
       AUTHOR. VIDHU VALSARAJAN.                                        
      ******************************************************************00050000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00060000
      *                                                                *00080000
      ******************************************************************00090000
      *  - - - - - >            O V E R V I E W           < - - - - -  *        
      *        THIS PROGRAM WRITES OUT TO A FILE THE DETAILS OF        *00250000
      *        ACCOUNTS WHO NEED TO GET PAYMENT REMINDERS              *00260000
      ******************************************************************00100000
      *               PROGRAM  MODIFICATION  LOG                       *00110000
      *                                                                *00120000
      *     DATE    | USER_ID | REASON                                 *00130000
      *-------------|---------|----------------------------------------*        
C29533*  01/08/2005 | VV90387 | NEW PROGRAM TO GENERATE PAYMENT        *00140000
      *             |         | REMINDERS FOR ECUSTOMER ACCOUNTS       *00140000
      *-------------|---------|----------------------------------------*        
C32352*  02/25/2005 | BB18179 | CML32352 - ADD SERVICE ADDRESS TO      *        
      *             |         | OUTPUT FILE FOR USE BY PCSCA192.  USE  *        
      *             |         | LOGIC SIMILAR TO CML 31785 - DISPLAY   *        
      *             |         | FIRST 6 CHARS OF SERV ADDR, THEN PAD   *        
      *             |         | RMDR WITH '*', AND INCL CITY / STATE.  *        
      *             |         | IE: 1401 MAIN STREET, COLUMBIA SC      *        
      *             |         |     SHOULD DISPLAY AS:                 *        
      *             |         |     1401 M**********, COLUMBIA SC      *        
      *-------------|---------|----------------------------------------*        
C32659*  04/29/2005 | BB18179 | CML32659 - DETERMINE DIFFERENCE BETWEEN*        
      *             |         | PENDING SCHED PMTS AND TOTAL_AR_BAL.   *        
      *             |         | IF DIFF LESS THAN / EQ DELINQ VALUE,   *        
      *             |         | DO NOT SEND PAYMENT REMINDER.          *        
      *-------------|---------|----------------------------------------*        
C32791*  05/31/2005 | BB18179 | CML 32791                              *        
      *             |         | A) FIX PREM ADDRESS FUNCT SO THAT SMALL*        
      *             |         |    ADDRESSES DON'T CAUSE OTHER ADDRESS *        
      *             |         |    TO NOT BE POPULATED.                *        
      *             |         | B) FIX BIZ DATE CALC FUNCTIONALITY.    *        
      *-------------|---------|----------------------------------------*        
      ******************************************************************00221000
             REMARKS.                                                   
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
            SELECT FCSAC191-FILE ASSIGN  UT-S-FCSAC191                  
                   FILE STATUS IS WS-FAC191-STATUS.                     
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCSAC191-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
                                                                        
       01  FAC191.                                                      
           05  E-FAC191-ACCOUNT-NO          PIC 9(13).                  
           05  E-FAC191-CUSTOMER-NO         PIC 9(10).                  
           05  E-FAC191-EMAIL-EVENT-CD      PIC X(05).                  
           05  E-FAC191-EMAIL-EVENT-DT      PIC X(10).                  
           05  E-FAC191-COMPANY-NO          PIC X(02).                  
           05  E-FAC191-REV-MTH-LST-NRML    PIC X(06).                  
C32352     05  E-FAC191-PREM-ADDR           PIC X(80).                  
C32352     05  E-FAC191-PREM-ADDR-LEN       PIC 9(03).                  
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC191'.
MSQ017     COPY MFASQLM.
       01  WS-START                         PIC X(40)  VALUE            
           'WORKING STORAGE FOR PCSAC191 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-PGRMNAME                  PIC X(10)  VALUE 'PCSAC191'.
           05  PROGRAM-NAME                 PIC X(08)  VALUE 'PCSAC191'.
           05  WS-COMMON                    PIC X(10)  VALUE 'COMMON  '.
           05  WS-FAC191-STATUS             PIC X(02)  VALUE '00'.      
               88  WS-FAC191-SUCCESSFUL                VALUE '00'.      
                                                                        
       01  WS-EXT-INFO.                                                 
           05  WS-COUNT                     PIC 9(02)  VALUE 0.         
C32791     05  WS-BIZ-DAY-CTR               PIC 9(02)  VALUE 0.         
           05  WS-HOLD-COUNT                PIC 9(02)  VALUE 0.         
           05  WS-EXT-MAX-ENTRY             PIC 9(02)  VALUE 10.        
           05  WS-PMT-RMDR-DAYS             PIC S9(02) COMP.            
C32791     05  WS-PMT-RMDR-DAYS-ABS         PIC S9(02) COMP.            
           05  WS-RMDR-DATE                 PIC X(10)  VALUE '   '.     
           05  WS-PMT-RMDR-DATE             PIC X(10)  VALUE '   '.     
COB305     05 WS-ATT-REV-MNTH        PIC S9(06) USAGE COMP-3 VALUE 0.    
           05  WS-ECS22                     PIC X(05)  VALUE 'ECS22'.   
           05  SCSCB068                     PIC X(08)  VALUE 'SCSCB068'.
           05  WS-N                         PIC X(01)  VALUE 'N'.       
           05  WS-Y                         PIC X(01)  VALUE 'Y'.       
           05  WS-NO                        PIC X(01)  VALUE 'N'.       
           05  WS-YES                       PIC X(01)  VALUE 'Y'.       
           05  RS-RETURN-CODE               PIC S9(4)  COMP.            
           05  RS-RETURN-CODE-DISP          PIC +Z(04).                 
                                                                        
      * INTERNAL STORAGE TABLE DECLARATION.                                     
           05  WS-EXT-DATA OCCURS 10 TIMES.                             
               10  WS-EXT-COMPANY-NO        PIC X(02).                  
               10  WS-EXT-PMT-RMDR-DAYS     PIC S9(02).                 
               10  WS-EXT-PMT-RMDR-DATE     PIC X(10).                  
               10  WS-EXT-PMT-RMDR-EVENT-CD PIC X(05).                  
C32352         10  WS-EXT-SERV-ADDR-MASK    PIC S9(04).                 
COB305         10 WS-EXT-PMT-RMDR-AMT        PIC S9(4)V9(5) COMP-3 
COB305           VALUE 0.      
                                                                        
C32352 01  WS-SERV-ADDR-INFO.                                           
C32352     05  WS-ADDRESS-MASK-CD          PIC X(20)                    
C32352         VALUE 'NO-ECS-MASK-AFTER'.                               
C32659     05  WS-AMT-PAYMENT-RMDR         PIC X(20)                    
C32659         VALUE 'AMT-PAYMENT-REMINDER'.                            
C32352     05  WS-DEFAULT-MASK             PIC S9(04) COMP VALUE 7.     
C32659     05  WS-DEFAULT-RMDR-AMT        PIC S9(4)V9(5) COMP-3 VALUE 0.
C32352     05  WS-MASK                     PIC S9(04) COMP.             
C32352     05  WS-MASK-STREET              PIC X(50).                   
C32352     05  WS-ADDRESS-SIZE             PIC X(01).                   
C32791         88  WS-ADDRESS-NORMAL                  VALUE 'N'.        
C32352         88  WS-ADDRESS-SMALL                   VALUE 'Y'.        
C32352     05  WS-MASK-START               PIC S9(04) COMP.             
C32352     05  WS-MASK-DIFF                PIC S9(04) COMP.             
C32352     05  WS-EML-PREM-ADDR            PIC X(108).                  
C32352     05  WS-EML-PREM-ADDR-LEN        PIC S9(04) COMP.             
C32352     05  WS-EML-CITY-STATE-LEN       PIC S9(04) COMP.             
C32352     05  WS-EML-NULL-IND             PIC S9(04) VALUE +0 COMP.    
C32659     05  WS-DRAFT-NULL-IND           PIC S9(04) VALUE +0 COMP.    
C32352     05  WS-HOLD-PREM-ADDR           PIC X(80).                   
C32352     05  WS-HOLD-PREM-ADDR-LEN       PIC 9(03).                   
COB305     05 WS-AMT-BAL-LESS-PNDG        PIC S9(11)V9(2) COMP-3 
COB305       VALUE 0.      
                                                                        
       COPY CWS09900.                                                   01280000
       COPY CWS00303.                                                   01290000
       COPY CWS00010.                                                           
       COPY CWS00056.                                                           
       COPY FIOJC01.                                                    01300000
                                                                        
C32352***************************************************************** 01320000
C32352* CWS00011 - W/S COPYBOOK FOR REDUCING EMBEDDED SPACES          * 01400000
C32352***************************************************************** 01320000
C32352 COPY CWS00011.                                                           
                                                                        
      ***************************************************************** 01320000
      * SQL COMMUNICATION AREA                                        * 01330000
      ***************************************************************** 01320000
           EXEC SQL                                                     01350000
                INCLUDE SQLCA                                           01360000
           END-EXEC.                                                    01370000
                                                                        
      ***************************************************************** 01320000
      * CSS_ACCOUNT        (PREFIX = AT)                              * 01400000
      ***************************************************************** 01320000
           EXEC SQL                                                     01420000
                INCLUDE TBACCT                                          01430000
           END-EXEC.                                                    01440000
                                                                        
C32352***************************************************************** 01320000
C32352* CSS_ACCOUNT_MISC   (PREFIX = TA)                              *         
C32352***************************************************************** 01320000
C32352     EXEC SQL                                                             
C32352         INCLUDE TBATMISC                                                 
C32352     END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_ACCT_ATTRIBUTE (PREFIX = YP)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBACTATT                                                 
           END-EXEC.                                                            
                                                                        
C32352***************************************************************** 01320000
C32352* CSS_ACCT_BILL_NMES (PREFIX = AB)                              *         
C32352***************************************************************** 01320000
C32352     EXEC SQL                                                             
C32352         INCLUDE TBATBLNM                                                 
C32352     END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_CRED_COLL      (PREFIX = CL)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBCRCOLL                                                 
           END-EXEC.                                                            
                                                                        
C32352***************************************************************** 01320000
C32352* CSS_CUST_ADDR_XREF (PREFIX = DM)                              *         
C32352***************************************************************** 01320000
C32352     EXEC SQL                                                             
C32352         INCLUDE TBCSADRX                                                 
C32352     END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_DELINQUENCY    (PREFIX = G6)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
C32352***************************************************************** 01320000
C32352* CSS_FORMATTED_ADDR (PREFIX = DY)                              *         
C32352***************************************************************** 01320000
C32352     EXEC SQL                                                             
C32352         INCLUDE TBADRFMT                                                 
C32352     END-EXEC.                                                            
                                                                        
C32352***************************************************************** 01320000
C32352* CSS_FREEFORM_ADDR  (PREFIX = DZ)                              *         
C32352***************************************************************** 01320000
C32352     EXEC SQL                                                             
C32352         INCLUDE TBADRFRE                                                 
C32352     END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_HOLIDAY        (PREFIX = J8)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 01320000
      * CSS_JOB_PARM       (PREFIX = C8)                              * 01470000
      ***************************************************************** 01320000
           EXEC SQL                                                     01490000
                INCLUDE TBJBPARM                                        01500000
           END-EXEC.                                                    01510000
                                                                        
      ***************************************************************** 01320000
      * CSS_MODEL_SQL      (PREFIX = MS)                              *         
      ***************************************************************** 01320000
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
                                                                        
C32352***************************************************************** 01320000
C32352* CSS_NAME           (PREFIX = DQ)                              *         
C32352***************************************************************** 01320000
C32352     EXEC SQL                                                             
C32352         INCLUDE TBNAME                                                   
C32352     END-EXEC.                                                            
                                                                        
C32352***************************************************************** 01320000
C32352* CSS_NAME_ACCT_XREF (PREFIX = HT)                              *         
C32352***************************************************************** 01320000
C32352     EXEC SQL                                                             
C32352         INCLUDE TBNMACTX                                                 
C32352     END-EXEC.                                                            
                                                                        
C32659*****************************************************************         
C32659* CSS_PNDNG_BNK_DRFT (PREFIX = PB)                              *         
C32659*****************************************************************         
C32659     EXEC SQL                                                             
C32659         INCLUDE TBPDBKDF                                                 
C32659     END-EXEC.                                                            
                                                                        
C32352***************************************************************** 01320000
C32352* CSS_ZIP_CODE       (PREFIX = A4)                              *         
C32352***************************************************************** 01320000
C32352     EXEC SQL                                                             
C32352         INCLUDE TBZIPCD                                                  
C32352     END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * COPYBOOK DECLARATION                                          *         
      *****************************************************************         
C32659*****                                                                     
C32659*  CWS00038 - JOB PARM / COMMON DATE SUPPORT                              
C32659*****                                                                     
C32659     EXEC SQL                                                             
C32659          INCLUDE CWS00038                                                
C32659     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00068                                                 
           END-EXEC.                                                            
                                                                        
C32352*****                                                                     
C32352*  CWS00074 - COPYBOOK FOR NAME / ADDRESS ROUTINE                         
C32352*****                                                                     
C32352     EXEC SQL                                                             
C32352         INCLUDE CWS00074                                                 
C32352     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00315                                                 
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------* 02016203
      * CURSOR FOR FETCHING DELINQUENCY INFO FOR RETRIEVING           * 02016303
      * PMT-RMDR-DAYS.                                                * 02016303
      *---------------------------------------------------------------* 02016503
           EXEC SQL                                                     
                DECLARE EXT_DELINQ CURSOR FOR                           
                 SELECT C8.COMPANY_NO                                   
                       ,C8.DELINQ_VALUE                                 
C32352                 ,C8.DELINQ_CD                                    
                   FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                
                  WHERE C8.DELINQ_CD = 'DAY-PAYMENT-REMINDER'           
C32352               OR C8.DELINQ_CD = 'NO-ECS-MASK-AFTER'              
C32659               OR C8.DELINQ_CD = 'AMT-PAYMENT-REMINDER'           
                  ORDER BY C8.COMPANY_NO                                
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02016603
MFA-TR*         DECLARE EXT_DELINQ CURSOR FOR                           02016703
MFA-TR*          SELECT C8.COMPANY_NO                                   02016803
MFA-TR*                ,C8.DELINQ_VALUE                                         
MFA-TR*                ,C8.DELINQ_CD                                            
MFA-TR*            FROM CSS_DELINQUENCY C8                              02017103
MFA-TR*           WHERE C8.DELINQ_CD = 'DAY-PAYMENT-REMINDER'           02017203
MFA-TR*              OR C8.DELINQ_CD = 'NO-ECS-MASK-AFTER'              02017203
MFA-TR*              OR C8.DELINQ_CD = 'AMT-PAYMENT-REMINDER'                   
MFA-TR*           ORDER BY C8.COMPANY_NO                                02017403
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                    02017603
                                                                        
                                                                        
      *---------------------------------------------------------------* 02016203
      * CURSOR FOR FETCHING POTENTIAL ACCOUNTS TO RECEIVE PAYMENT     * 02016303
      * REMINDERS.                                                    * 02016303
      *---------------------------------------------------------------* 02016503
           EXEC SQL                                                     
                DECLARE EXT_ACCOUNT CURSOR FOR                          
                 SELECT DISTINCT AT.ACCOUNT_NO                          
                                ,AT.CUSTOMER_NO                         
                                ,AT.COMPANY_NO                          
                                ,AT.CREDIT_GROUP                        
                                ,AT.CODE_ACCT_STAT                      
                                ,AT.DATE_BILL_DAY_00                    
                                ,AT.REV_MTH_LST_NRML                    
C32659                          ,AT.TOTAL_AR_BALANCE                    
                                ,YP.ATTRIBUTE_VALUE_TX                  
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
                        CSS_CRED_COLL CL WITH(READUNCOMMITTED),                 
                        CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO         = CL.ACCOUNT_NO           
                    AND YP.ACCOUNT_NO         = CL.ACCOUNT_NO           
                    AND CL.CODE_NOTICE_TYPE   IN ('A','B')              
                    AND CL.DATE_NOTICE_DUE    = IIF(TRY_CONVERT(DATE, 
                                                    :CL-DATE-NOTICE-DUE
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-DUE
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-DUE
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-DUE
              ), CONVERT(DATE, :CL-DATE-NOTICE-DUE) )     
                    AND AT.TOTAL_AR_BALANCE   > 0                       
                    AND YP.ATTRIBUTE_DESC     = 'EMAIL PMT REMINDER'    
                    AND YP.ATTRIBUTE_VALUE_CD = 'YES'                   
                    AND AT.COMPANY_NO         = :AT-COMPANY-NO          
                    FOR READ ONLY                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02016603
MFA-TR*         DECLARE EXT_ACCOUNT CURSOR FOR                          02016703
MFA-TR*          SELECT DISTINCT AT.ACCOUNT_NO                          02016803
MFA-TR*                         ,AT.CUSTOMER_NO                                 
MFA-TR*                         ,AT.COMPANY_NO                                  
MFA-TR*                         ,AT.CREDIT_GROUP                                
MFA-TR*                         ,AT.CODE_ACCT_STAT                              
MFA-TR*                         ,AT.DATE_BILL_DAY_00                            
MFA-TR*                         ,AT.REV_MTH_LST_NRML                            
MFA-TR*                         ,AT.TOTAL_AR_BALANCE                            
MFA-TR*                         ,YP.ATTRIBUTE_VALUE_TX                          
MFA-TR*            FROM CSS_ACCOUNT AT,                                 02017103
MFA-TR*                 CSS_CRED_COLL CL,                                       
MFA-TR*                 CSS_ACCT_ATTRIBUTE YP                                   
MFA-TR*           WHERE AT.ACCOUNT_NO         = CL.ACCOUNT_NO           02017203
MFA-TR*             AND YP.ACCOUNT_NO         = CL.ACCOUNT_NO                   
MFA-TR*             AND CL.CODE_NOTICE_TYPE   IN ('A','B')                      
MFA-TR*             AND CL.DATE_NOTICE_DUE    = :CL-DATE-NOTICE-DUE             
MFA-TR*             AND AT.TOTAL_AR_BALANCE   > 0                               
MFA-TR*             AND YP.ATTRIBUTE_DESC     = 'EMAIL PMT REMINDER'            
MFA-TR*             AND YP.ATTRIBUTE_VALUE_CD = 'YES'                           
MFA-TR*             AND AT.COMPANY_NO         = :AT-COMPANY-NO                  
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                    02017603
                                                                        
       01  WS-END                           PIC X(40) VALUE             
          'WORKING STORAGE FOR PCSAC191 ENDS HERE  '.                   
                                                                        
                                                                        
      ******************************************************************02630000
      *   0000-MAINLINE.                                               *02650000
      *        CONTROLS MAIN PATH OF PROGRAM                           *02660000
      ******************************************************************02630000
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZATION     THRU 1000-EXIT.              
                                                                        
           PERFORM 2000-MAIN-PROCESS       THRU 2000-EXIT.              
                                                                        
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    1000-INITIALIZATION.                                        *03000000
      *         GETS JOB PARM DATE AND OPENS FSCAC191-FILE             *03010000
      ******************************************************************02630000
       1000-INITIALIZATION.                                             
                                                                        
           DISPLAY '**************************************************'.
           DISPLAY '** PROGRAM NAME: ' PROGRAM-NAME.                    
                                                                        
           MOVE '1000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           OPEN OUTPUT  FCSAC191-FILE.                                  
                                                                        
           IF WS-FAC191-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**       PCSAC191   PROCESSING ERROR       **'   
              DISPLAY '     OPEN ERROR OF FCSAC191 OUTPUT FILE '        
              DISPLAY '     FILE STATUS = ' WS-FAC191-STATUS            
              DISPLAY '**         PROCESSING TERMINATED           **'   
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT.              
           IF COMMON-DATE-NEEDED                                        
              MOVE WS-COMMON               TO WS-PGRMNAME               
              MOVE SPACES                  TO WS-INPUT-AREA             
              MOVE SPACES                  TO WS-INPUT-DATA-BREAKDOWN   
              PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT               
              MOVE 'PCSAC191'              TO WS-PGRMNAME               
           END-IF.                                                      
                                                                        
           MOVE 1                          TO WS-COUNT.                 
           INITIALIZE                         WS-EXT-DATA(WS-COUNT)     
                                              WS-PMT-RMDR-DAYS          
                                              WS-ATT-REV-MNTH           
                                              WS-HOLD-DATE.             
                                                                        
           MOVE WS-INPUT-DATE              TO WS-RMDR-DATE              
                                              WS-HOLD-DATE.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2000-MAIN-PROCESS                                           *03963003
      *         LOADS THE INTERNAL TABLE WS-EXT-DATA BASED ON          *03964003
      *         INFO FROM CSS_DELINQUENCY                              *03964103
      ******************************************************************02630000
       2000-MAIN-PROCESS.                                               
                                                                        
           PERFORM 2100-LOAD-DELINQ-INFO   THRU 2100-EXIT.              
                                                                        
           PERFORM 2200-GET-RMDR-DETAILS   THRU 2200-EXIT.              
                                                                        
           PERFORM 2300-GET-ACCOUNTS       THRU 2300-EXIT.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2100-LOAD-DELINQ-INFO                                       *03963003
      *         LOADS THE INTERNAL TABLE WITH EXT-COMPANY-NO AND       *03964003
      *         EXT-PMT-RMDR-DAYS INFO FROM CSS_DELINQUENCY            *03964103
      ******************************************************************02630000
       2100-LOAD-DELINQ-INFO.                                           
                                                                        
           PERFORM 7500-OPEN-DELINQ-CURSOR         THRU 7500-EXIT.      
                                                                        
           PERFORM 7525-FETCH-DELINQ-CURSOR        THRU 7525-EXIT.      
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              MOVE 1      TO WS-COUNT                                   
              INITIALIZE  WS-EXT-DATA(WS-COUNT)                         
              PERFORM UNTIL SQLCODE NOT EQUAL SUCCESSFUL-CALL           
                         OR WS-COUNT > WS-EXT-MAX-ENTRY                 
                  PERFORM 2125-LOAD-WS-EXT-DATA    THRU 2125-EXIT       
                  PERFORM 7525-FETCH-DELINQ-CURSOR THRU 7525-EXIT       
C32352            IF WS-EXT-COMPANY-NO(WS-COUNT) NOT EQUAL C8-COMPANY-NO
                     ADD 1 TO WS-COUNT                                  
C32352               INITIALIZE  WS-EXT-DATA(WS-COUNT)                  
C32352            END-IF                                                
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
           PERFORM 7550-CLOSE-DELINQ-CURSOR        THRU 7550-EXIT.      
                                                                        
C32352     MOVE WS-COUNT TO WS-HOLD-COUNT.                              
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2125-LOAD-WS-EXT-DATA                                       *03975505
      *    POPULATES THE INTERNAL TABLE WITH COMPANY NO & PMT-RMDR-DAYS*03975605
      ******************************************************************02630000
       2125-LOAD-WS-EXT-DATA.                                           
                                                                        
C32352     IF WS-EXT-COMPANY-NO(WS-COUNT) NOT EQUAL C8-COMPANY-NO       
              MOVE C8-COMPANY-NO   TO WS-EXT-COMPANY-NO(WS-COUNT)       
C32352        MOVE WS-DEFAULT-MASK TO WS-EXT-SERV-ADDR-MASK(WS-COUNT)   
C32659        MOVE WS-DEFAULT-RMDR-AMT                                  
C32659          TO WS-EXT-PMT-RMDR-AMT(WS-COUNT)                        
C32352     END-IF.                                                      
                                                                        
C32659     EVALUATE C8-DELINQ-CD                                        
C32352         WHEN WS-ADDRESS-MASK-CD                                  
C32352              MOVE C8-DELINQ-VALUE                                
C32352                TO WS-EXT-SERV-ADDR-MASK(WS-COUNT)                
C32659         WHEN WS-AMT-PAYMENT-RMDR                                 
C32659              MOVE C8-DELINQ-VALUE                                
C32659                TO WS-EXT-PMT-RMDR-AMT(WS-COUNT)                  
               WHEN OTHER                                               
                    MOVE C8-DELINQ-VALUE                                
                      TO WS-EXT-PMT-RMDR-DAYS(WS-COUNT)                 
C32659     END-EVALUATE.                                                
                                                                        
       2125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2200-GET-RMDR-DETAILS.                                      *03975505
      *    POPULATES THE INTERNAL TABLE WITH WS-EXT-PMT-RMDR-DATE AND  *03975605
      *    ALSO WS-EXT-PMT-RMDR-EVENT-CD DETAILS.                      *        
      ******************************************************************02630000
       2200-GET-RMDR-DETAILS.                                           
                                                                        
           MOVE 1                         TO WS-COUNT.                  
                                                                        
           PERFORM UNTIL WS-COUNT > WS-HOLD-COUNT                       
               MOVE WS-EXT-PMT-RMDR-DAYS(WS-COUNT)                      
                                          TO WS-PMT-RMDR-DAYS           
C32791         IF WS-PMT-RMDR-DAYS < 0                                  
C32791            COMPUTE WS-PMT-RMDR-DAYS-ABS = WS-PMT-RMDR-DAYS * -1  
C32791            MOVE 1            TO WS-BIZ-DAY-CTR                   
C32791            MOVE WS-RMDR-DATE TO WS-NEW-BUSINESS-DAY              
C32791            PERFORM UNTIL WS-BIZ-DAY-CTR > WS-PMT-RMDR-DAYS-ABS   
C32791               MOVE WS-NO     TO WS-NEXT-BUSINESS-DAY             
C32791               PERFORM 6500-GET-NEXT-BUSINESS-DAY  THRU           
C32791                       6500-NEXT-BUSINESS-DAY-EXIT UNTIL          
C32791                       NEXT-BUSINESS-DAY-FOUND                    
C32791               ADD 1 TO WS-BIZ-DAY-CTR                            
C32791            END-PERFORM                                           
C32781         ELSE                                                     
                  PERFORM 7620-PMT-RMDR-DATE          THRU 7620-EXIT    
                  MOVE WS-NO TO WS-NEXT-BUSINESS-DAY                    
                  PERFORM 7625-CHECK-BUSINESS-DAY     THRU 7625-EXIT    
                  PERFORM 6500-GET-NEXT-BUSINESS-DAY  THRU              
                          6500-NEXT-BUSINESS-DAY-EXIT UNTIL             
                          NEXT-BUSINESS-DAY-FOUND                       
C32791         END-IF                                                   
                                                                        
               MOVE WS-NEW-BUSINESS-DAY   TO                            
                       WS-EXT-PMT-RMDR-DATE(WS-COUNT)                   
                                                                        
               MOVE WS-EXT-COMPANY-NO(WS-COUNT)                         
                                          TO C8-COMPANY-NO              
               PERFORM 7630-PMT-EVENT-CD           THRU 7630-EXIT       
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                  MOVE C8-DELINQ-CD(13:5) TO                            
                       WS-EXT-PMT-RMDR-EVENT-CD(WS-COUNT)               
               ELSE                                                     
                  MOVE WS-ECS22           TO                            
                       WS-EXT-PMT-RMDR-EVENT-CD(WS-COUNT)               
               END-IF                                                   
                                                                        
               ADD 1                      TO WS-COUNT                   
           END-PERFORM.                                                 
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2300-GET-ACCOUNTS.                                          *03975505
      *    GETS POTENTIAL ACCOUNTS THAT NEED TO RECEIVE PAYMENT REMINDER03975605
      ******************************************************************02630000
       2300-GET-ACCOUNTS.                                               
                                                                        
           MOVE 1                         TO WS-COUNT.                  
                                                                        
           PERFORM UNTIL WS-COUNT > WS-HOLD-COUNT                       
               MOVE WS-EXT-COMPANY-NO(WS-COUNT)                         
                                          TO AT-COMPANY-NO              
               MOVE WS-EXT-PMT-RMDR-DATE(WS-COUNT)                      
                                          TO CL-DATE-NOTICE-DUE         
                                                                        
               PERFORM 7700-OPEN-ACCTS-CURSOR        THRU 7700-EXIT     
               PERFORM 7725-FETCH-ACCTS-CURSOR       THRU 7725-EXIT     
                                                                        
               PERFORM UNTIL SQLCODE NOT EQUAL SUCCESSFUL-CALL          
                   MOVE YP-ATTRIBUTE-VALUE-TX-TEXT(32:6)                
                                          TO WS-ATT-REV-MNTH            
                                                                        
                   IF AT-REV-MTH-LST-NRML NOT EQUAL WS-ATT-REV-MNTH     
                      MOVE 'Y'            TO LOAD-DUE-DATES-SW          
                      MOVE PROGRAM-NAME   TO WS-CPD00068-CALLING-PGM    
                      MOVE SPACES         TO ABEND-FUNCTION             
                      CALL SCSCB068    USING CWS00068-FIELDS,           
                                             WS-CODES-DATA-PRESENT,     
                                             DCLCSS-ACCOUNT,            
                                             ABEND-FILE,                
                                             RS-RETURN-CODE             
                      IF ABEND-FUNCTION > SPACES                        
                         PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT     
                      END-IF                                            
                                                                        
                      IF WS-EXT-PMT-RMDR-DATE(WS-COUNT)                 
                                          = WS-DATE-BILL-DUE            
C32659                   PERFORM 7850-SELECT-PNDNG-PMTS                 
C32659                      THRU 7850-EXIT                              
C32659                   COMPUTE WS-AMT-BAL-LESS-PNDG =                 
C32659                           AT-TOTAL-AR-BALANCE - PB-DRAFT-AMT     
C32659                   IF WS-AMT-BAL-LESS-PNDG GREATER THAN           
C32659                           WS-EXT-PMT-RMDR-AMT(WS-COUNT)          
C32352                      PERFORM 2500-LOOKUP-PREM-ADDR               
C32352                         THRU 2500-EXIT                           
C32352                      PERFORM 2525-FORMAT-PREM-ADDR               
C32352                         THRU 2525-EXIT                           
                            PERFORM 2400-WRITE-FCSAC191                 
                               THRU 2400-EXIT                           
C32659                   END-IF                                         
                      END-IF                                            
                   END-IF                                               
                                                                        
                   PERFORM 7725-FETCH-ACCTS-CURSOR   THRU 7725-EXIT     
               END-PERFORM                                              
                                                                        
               ADD 1                      TO WS-COUNT                   
               PERFORM 7750-CLOSE-ACCTS-CURSOR       THRU 7750-EXIT     
           END-PERFORM.                                                 
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *    2400-WRITE-FCSAC191                                         *03975505
      *    WRITES TO OUTPUT FILE DETAILS OF ACCOUNTS THAT NEED TO      *03975605
      *    RECEIVE PAYMENT REMINDERS.                                  *03975605
      ******************************************************************02630000
       2400-WRITE-FCSAC191.                                             
                                                                        
           MOVE AT-ACCOUNT-NO     TO E-FAC191-ACCOUNT-NO.               
           MOVE AT-CUSTOMER-NO    TO E-FAC191-CUSTOMER-NO.              
           MOVE WS-EXT-PMT-RMDR-EVENT-CD(WS-COUNT)                      
                                  TO E-FAC191-EMAIL-EVENT-CD.           
           MOVE WS-INPUT-DATE     TO E-FAC191-EMAIL-EVENT-DT.           
           MOVE AT-COMPANY-NO     TO E-FAC191-COMPANY-NO.               
           MOVE AT-REV-MTH-LST-NRML                                     
                                  TO E-FAC191-REV-MTH-LST-NRML.         
C32352     MOVE WS-HOLD-PREM-ADDR TO E-FAC191-PREM-ADDR.                
C32352     MOVE WS-HOLD-PREM-ADDR-LEN                                   
C32352                            TO E-FAC191-PREM-ADDR-LEN.            
                                                                        
           WRITE FAC191.                                                
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32352******************************************************************02630000
C32352* 2500-LOOKUP-PREM-ADDR                                          *06301114
C32352******************************************************************02630000
C32352 2500-LOOKUP-PREM-ADDR.                                           
                                                                        
C32352     MOVE ZERO   TO AT-ADDRESS-ID.                                
C32352     MOVE SPACES TO WS-NAME-ONLY-SW.                              
C32352     PERFORM 4000-MAIL-NAME-ADDRESS                               
C32352        THRU 4000-EXIT.                                           
                                                                        
C32352 2500-EXIT.                                                       
C32352     EXIT.                                                        
                                                                        
C32352******************************************************************02630000
C32352* 2525-FORMAT-PREM-ADDR                                          *06301114
C32352******************************************************************02630000
C32352 2525-FORMAT-PREM-ADDR.                                           
                                                                        
C32352     MOVE 0      TO WS-EML-NULL-IND.                              
C32352     MOVE 0      TO WS-EML-PREM-ADDR-LEN.                         
C32352     MOVE 0      TO WS-HOLD-PREM-ADDR-LEN.                        
C32352     MOVE SPACES TO WS-EML-PREM-ADDR.                             
C32352     MOVE SPACES TO WS-HOLD-PREM-ADDR.                            
C32352     MOVE WS-EXT-SERV-ADDR-MASK(WS-COUNT) TO WS-MASK.             
                                                                        
C32791     SET WS-ADDRESS-NORMAL TO TRUE.                               
C32352     PERFORM 7800-FORMAT-ADDRESS-SMALL                            
C32352        THRU 7800-EXIT.                                           
                                                                        
C32352     IF NOT WS-ADDRESS-SMALL                                      
C32352        PERFORM 7825-FORMAT-ADDRESS-NORMAL                        
C32352           THRU 7825-EXIT                                         
C32352     END-IF.                                                      
                                                                        
C32352 2525-EXIT.                                                       
C32352     EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7500-OPEN-DELINQ-CURSOR                                      *08063003
      *        OPENS THE EXT_DELINQ CURSOR TO FETCH ROWS               *08064003
      ******************************************************************08061003
       7500-OPEN-DELINQ-CURSOR.                                         
                                                                        
           MOVE '7500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN EXT_DELINQ                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7500-OPEN-DELINQ-CURSOR'     
              DISPLAY '**  OPEN EXT_DELINQ CURSOR'                      
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7525-FETCH-DELINQ-CURSOR                                     *08071703
      *        GETS DELINQUENCY INFO                                   *08071803
      ******************************************************************08061003
                                                                        
       7525-FETCH-DELINQ-CURSOR.                                        
                                                                        
           MOVE '7525'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH EXT_DELINQ                                          
               INTO :C8-COMPANY-NO                                      
                   ,:C8-DELINQ-VALUE                                    
C32352             ,:C8-DELINQ-CD                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7525-FETCH-DELINQ-CURSOR'     
              DISPLAY '**  FETCH EXT_DELINQ CURSOR'                     
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7550-CLOSE-DELINQ-CURSOR                                     *08076303
      *        CLOSING DELINQUENCY CURSOR                              *08076403
      ******************************************************************08061003
                                                                        
       7550-CLOSE-DELINQ-CURSOR.                                        
                                                                        
           MOVE '7550'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE EXT_DELINQ                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7550-CLOSE-DELINQ-CURSOR'     
              DISPLAY '**  CLOSE EXT_DELINQ CURSOR '                    
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7620-PMT-RMDR-DATE.                                          *08090000
      *        GETS THE EXT-PMT-REMINDER DATE.                         *08100000
      ******************************************************************08061003
                                                                        
       7620-PMT-RMDR-DATE.                                              
                                                                        
           EXEC SQL                                                     
               SELECT DATEADD( DAY, -:WS-PMT-RMDR-DAYS, 
              IIF(TRY_CONVERT(DATE, :WS-RMDR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RMDR-DATE
              ) <> 0) OR (LEN(:WS-RMDR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-RMDR-DATE
              ), CONVERT(DATE, :WS-RMDR-DATE) ) )     
                 INTO :WS-PMT-RMDR-DATE                                 
                 FROM CSS_MODEL_SQL                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE(:WS-RMDR-DATE)  - :WS-PMT-RMDR-DAYS DAYS             
MFA-TR*          INTO :WS-PMT-RMDR-DATE                                         
MFA-TR*          FROM CSS_MODEL_SQL                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 7620-PMT-RMDR-DATE'         
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7625-CHECK-BUSINESS-DAY                                      *08090000
      *   USES CPD00315 LOGIC TO DETERMINE IF WS-PMT-RMDR-DATE FALLS   *08100000
      *   ON A BUSINESS DAY ELSE FINDS THE NEXT BUSINESS DAY           *08110000
      ******************************************************************08061003
                                                                        
       7625-CHECK-BUSINESS-DAY.                                         
                                                                        
           EXEC SQL                                                     
               SELECT DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                      :WS-PMT-RMDR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PMT-RMDR-DATE
              ) <> 0) OR (LEN(:WS-PMT-RMDR-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-PMT-RMDR-DATE
              ), CONVERT(DATE, :WS-PMT-RMDR-DATE) ) )                 
                 INTO :WS-NEW-BUSINESS-DAY                              
                 FROM CSS_MODEL_SQL                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE(:WS-PMT-RMDR-DATE)  - 1 DAYS                         
MFA-TR*          INTO :WS-NEW-BUSINESS-DAY                                      
MFA-TR*          FROM CSS_MODEL_SQL                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 7625-CHECK-BUSINESS-DAY'    
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7625-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7630-PMT-EVENT-CD.                                           *08090000
      *        GETS EXT-PMT-RMDR-EVENT-CD                              *08100000
      ******************************************************************08061003
                                                                        
       7630-PMT-EVENT-CD.                                               
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) C8.DELINQ_CD                                     
                  INTO :C8-DELINQ-CD                                    
                  FROM CSS_DELINQUENCY C8                               
                 WHERE C8.COMPANY_NO   = :C8-COMPANY-NO                 
                   AND C8.DELINQ_CD LIKE 'CD-PMT-RMDR%'                 
                   AND C8.DELINQ_VALUE = 1                              
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT C8.DELINQ_CD                                             
MFA-TR*           INTO :C8-DELINQ-CD                                            
MFA-TR*           FROM CSS_DELINQUENCY C8                                       
MFA-TR*          WHERE C8.COMPANY_NO   = :C8-COMPANY-NO                         
MFA-TR*            AND C8.DELINQ_CD LIKE 'CD-PMT-RMDR%'                         
MFA-TR*            AND C8.DELINQ_VALUE = 1                                      
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 7630-PMT-EVENT-CD'          
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7700-OPEN-ACCTS-CURSOR                                       *08063003
      *        OPENS THE EXT_ACCOUNT CURSOR TO FETCH ROWS              *08064003
      ******************************************************************08061003
                                                                        
       7700-OPEN-ACCTS-CURSOR.                                          
                                                                        
           MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN EXT_ACCOUNT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7700-OPEN-ACCTS-CURSOR'      
              DISPLAY '**  OPEN EXT_ACCOUNT CURSOR'                     
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7725-FETCH-ACCTS-CURSOR                                      *08071703
      *        GETS ACCOUNT INFO                                       *08071803
      ******************************************************************08061003
                                                                        
       7725-FETCH-ACCTS-CURSOR.                                         
                                                                        
           MOVE '7725'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH EXT_ACCOUNT                                         
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-COMPANY-NO                                      
                   ,:AT-CREDIT-GROUP                                    
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:AT-REV-MTH-LST-NRML                                
C32659             ,:AT-TOTAL-AR-BALANCE                                
                   ,:YP-ATTRIBUTE-VALUE-TX                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7725-FETCH-ACCTS-CURSOR'      
              DISPLAY '**  FETCH EXT_ACCOUNT CURSOR'                    
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7725-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   7750-CLOSE-ACCTS-CURSOR                                      *08076303
      *        CLOSING EXT_ACCOUNT CURSOR                              *08076403
      ******************************************************************08061003
                                                                        
       7750-CLOSE-ACCTS-CURSOR.                                         
                                                                        
           MOVE '7750'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE EXT_ACCOUNT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7750-CLOSE-ACCTS-CURSOR'      
              DISPLAY '**  CLOSE EXT_ACCOUNT CURSOR '                   
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32352******************************************************************        
C32352* 7800-FORMAT-ADDRESS-SMALL                                      *        
C32352******************************************************************        
C32352 7800-FORMAT-ADDRESS-SMALL.                                       
                                                                        
C32352     MOVE '7800'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
C32352     COMPUTE WS-MASK-START = WS-MASK + 1.                         
C32352     COMPUTE WS-MASK-DIFF = LENGTH OF WS-PR-STREET - WS-MASK-START
                                                                        
C32352     MOVE WS-PR-STREET(WS-MASK-START:WS-MASK-DIFF)                
C32352       TO WS-MASK-STREET.                                         
                                                                        
C32352     IF WS-MASK-STREET GREATER THAN SPACES                        
C32352        GO TO 7800-EXIT                                           
C32352     END-IF.                                                      
                                                                        
C32352     EXEC SQL                                                     
C32352       SELECT DATALENGTH(LTRIM(RTRIM(:WS-PR-STREET)))                     
C32352             ,DATALENGTH(LTRIM(RTRIM(:WS-PR-ADDR-CITY-STATE)))            
C32352             ,LTRIM(RTRIM(:WS-PR-ADDR-CITY-STATE))                       
C32352         INTO :WS-EML-PREM-ADDR-LEN                               
C32352             ,:WS-EML-CITY-STATE-LEN                              
C32352             ,:WS-EML-PREM-ADDR :WS-EML-NULL-IND                  
C32352         FROM CSS_MODEL_SQL                                       
C32352     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT LENGTH(STRIP(:WS-PR-STREET))                                
MFA-TR*            ,LENGTH(STRIP(:WS-PR-ADDR-CITY-STATE))                       
MFA-TR*            ,STRIP(:WS-PR-ADDR-CITY-STATE)                               
MFA-TR*        INTO :WS-EML-PREM-ADDR-LEN                                       
MFA-TR*            ,:WS-EML-CITY-STATE-LEN                                      
MFA-TR*            ,:WS-EML-PREM-ADDR :WS-EML-NULL-IND                          
MFA-TR*        FROM CSS_MODEL_SQL                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C32352     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C32352     IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
C32352        DISPLAY '***********************************'             
C32352        DISPLAY '**  PROCESSING ERROR             **'             
C32352        DISPLAY '**  PARAGRAPH NBR = ' WS-ACTIVE-PARAGRAPH        
C32352        DISPLAY '**  PARAGRAPH DESC= FORMAT-ADDRESS-SMALL'        
C32352        DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
C32352        DISPLAY '**  ACCOUNT-NO    = ' AT-ACCOUNT-NO              
C32352        DISPLAY '**  PR-STREET          = ' WS-PR-STREET          
C32352        DISPLAY '**  PR-ADDR-CITY-STATE = ' WS-PR-ADDR-CITY-STATE 
C32352        DISPLAY '**  PROCESSING TERMINATED        **'             
C32352        DISPLAY '***********************************'             
C32352        PERFORM 9900-ABEND         THRU 9900-EXIT                 
C32352     END-IF.                                                      
                                                                        
C32352     IF WS-EML-PREM-ADDR-LEN < 4                                  
C32352        SET WS-ADDRESS-SMALL TO TRUE                              
C32352        IF WS-EML-NULL-IND EQUAL 0                                
C32352           MOVE WS-EML-PREM-ADDR      TO WS-HOLD-PREM-ADDR        
C32352        ELSE                                                      
C32352           MOVE WS-PR-ADDR-CITY-STATE TO WS-HOLD-PREM-ADDR        
C32352        END-IF                                                    
C32352        MOVE WS-EML-CITY-STATE-LEN TO WS-HOLD-PREM-ADDR-LEN       
C32352        GO TO 7800-EXIT                                           
C32352     END-IF.                                                      
                                                                        
C32352     COMPUTE WS-MASK ROUNDED = WS-EML-PREM-ADDR-LEN / 2.          
                                                                        
C32352 7800-EXIT.                                                       
C32352     EXIT.                                                        
                                                                        
C32352******************************************************************        
C32352* 7825-FORMAT-ADDRESS-NORMAL                                     *        
C32352******************************************************************        
C32352 7825-FORMAT-ADDRESS-NORMAL.                                      
                                                                        
C32352     MOVE '7825'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
C32352     EXEC SQL                                                     
C32352       SELECT LTRIM(RTRIM(CIS.SUBSTR3$(LTRIM(RTRIM(:WS-PR-STREET))
           , 1, :WS-MASK) + REPLICATE('*', DATALENGTH(LTRIM(RTRIM(
                                                          :WS-PR-STREET
           )))-:WS-MASK) + ', ' + :WS-PR-ADDR-CITY-STATE))                     
C32352          ,DATALENGTH(LTRIM(RTRIM(CIS.SUBSTR3$(LTRIM(RTRIM(
                                                          :WS-PR-STREET
           )), 1, :WS-MASK) + REPLICATE('*', DATALENGTH(LTRIM(RTRIM(
                                                          :WS-PR-STREET
           )))-:WS-MASK) + ', ' + :WS-PR-ADDR-CITY-STATE)))                    
C32352         INTO :WS-EML-PREM-ADDR :WS-EML-NULL-IND                  
C32352             ,:WS-EML-PREM-ADDR-LEN                               
C32352         FROM CSS_MODEL_SQL                                       
C32352     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT STRIP(SUBSTR(STRIP(:WS-PR-STREET),1,:WS-MASK) ||            
MFA-TR*             REPEAT('*',LENGTH(STRIP(:WS-PR-STREET))-:WS-MASK) ||        
MFA-TR*             ', ' || :WS-PR-ADDR-CITY-STATE)                             
MFA-TR*         ,LENGTH(STRIP(SUBSTR(STRIP(:WS-PR-STREET),1,:WS-MASK) ||        
MFA-TR*             REPEAT('*',LENGTH(STRIP(:WS-PR-STREET))-:WS-MASK) ||        
MFA-TR*             ', ' || :WS-PR-ADDR-CITY-STATE))                            
MFA-TR*        INTO :WS-EML-PREM-ADDR :WS-EML-NULL-IND                          
MFA-TR*            ,:WS-EML-PREM-ADDR-LEN                                       
MFA-TR*        FROM CSS_MODEL_SQL                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C32352     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C32352     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C32352        IF WS-EML-NULL-IND EQUAL 0                                
C32352           MOVE WS-EML-PREM-ADDR     TO WS-HOLD-PREM-ADDR         
C32352           MOVE WS-EML-PREM-ADDR-LEN TO WS-HOLD-PREM-ADDR-LEN     
C32352        END-IF                                                    
C32352     ELSE                                                         
C32352        DISPLAY '***********************************'             
C32352        DISPLAY '**  PROCESSING ERROR             **'             
C32352        DISPLAY '**  PARAGRAPH NBR = ' WS-ACTIVE-PARAGRAPH        
C32352        DISPLAY '**  PARAGRAPH DESC= FORMAT-ADDRESS-NORMAL'       
C32352        DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
C32352        DISPLAY '**  ACCOUNT-NO    = ' AT-ACCOUNT-NO              
C32352        DISPLAY '**  PR-STREET          = ' WS-PR-STREET          
C32352        DISPLAY '**  PR-ADDR-CITY-STATE = ' WS-PR-ADDR-CITY-STATE 
C32352        DISPLAY '**  PROCESSING TERMINATED        **'             
C32352        DISPLAY '***********************************'             
C32352        PERFORM 9900-ABEND         THRU 9900-EXIT                 
C32352     END-IF.                                                      
                                                                        
C32352 7825-EXIT.                                                       
C32352     EXIT.                                                        
                                                                        
C32659******************************************************************        
C32659* 7850-SELECT-SCHED-PMTS                                         *        
C32659******************************************************************        
C32659 7850-SELECT-PNDNG-PMTS.                                          
                                                                        
C32659     MOVE '7850'        TO WS-ACTIVE-PARAGRAPH.                   
C32659     MOVE AT-ACCOUNT-NO TO PB-ACCOUNT-NO.                         
C32659     MOVE ZERO          TO PB-DRAFT-AMT.                          
C32659     MOVE ZERO          TO WS-DRAFT-NULL-IND.                     
                                                                        
C32659     EXEC SQL                                                     
C32659          SELECT SUM(PB.DRAFT_AMT)                                
C32659            INTO :PB-DRAFT-AMT :WS-DRAFT-NULL-IND                 
C32659            FROM CSS_PNDNG_BNK_DRFT PB                            
C32659           WHERE PB.ACCOUNT_NO = :PB-ACCOUNT-NO                   
C32659             AND PB.DRAFT_DATE >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                  
C32659             AND PB.DRAFT_DATE <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-DATE-BILL-DUE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILL-DUE
              ) <> 0) OR (LEN(:WS-DATE-BILL-DUE) <> 10), CIS.CHAR2DATE(
                                                      :WS-DATE-BILL-DUE
              ), CONVERT(DATE, :WS-DATE-BILL-DUE) )               
C32659             AND PB.PYMT_POSTED_FL <> 'Y'                         
C32659     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUM(PB.DRAFT_AMT)                                        
MFA-TR*           INTO :PB-DRAFT-AMT :WS-DRAFT-NULL-IND                         
MFA-TR*           FROM CSS_PNDNG_BNK_DRFT PB                                    
MFA-TR*          WHERE PB.ACCOUNT_NO = :PB-ACCOUNT-NO                           
MFA-TR*            AND PB.DRAFT_DATE >= :WS-INPUT-DATE                          
MFA-TR*            AND PB.DRAFT_DATE <= :WS-DATE-BILL-DUE                       
MFA-TR*            AND PB.PYMT_POSTED_FL <> 'Y'                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C32659     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C32659     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C32659        IF WS-DRAFT-NULL-IND NOT EQUAL ZERO                       
C32659           MOVE ZERO TO PB-DRAFT-AMT                              
C32659        END-IF                                                    
C32659     ELSE                                                         
C32659        DISPLAY '****--->  P C S A C 1 9 1  <---****'             
C32659        DISPLAY '**  PROCESSING ERROR             **'             
C32659        DISPLAY '**  PARAGRAPH NBR  = ' WS-ACTIVE-PARAGRAPH       
C32659        DISPLAY '**  PARAGRAPH DESC = SELECT-PNDNG-PMTS'          
C32659        DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
C32659        DISPLAY '**  ACCOUNT-NO     = ' PB-ACCOUNT-NO             
C32659        DISPLAY '**  INPUT-DATE     = ' WS-INPUT-DATE             
C32659        DISPLAY '**  DATE-BILL-DUE  = ' WS-DATE-BILL-DUE          
C32659        DISPLAY '**  PROCESSING TERMINATED        **'             
C32659        DISPLAY '***********************************'             
C32659        PERFORM 9900-ABEND         THRU 9900-EXIT                 
C32659     END-IF.                                                      
                                                                        
C32659 7850-EXIT.                                                       
C32659     EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   9000-TERMINATE.                                              *10060000
      ******************************************************************08061003
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSAC191-FILE.                                         
                                                                        
           IF WS-FAC191-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSAC191  PROCESSING ERROR **'               
              DISPLAY '**    CLOSE ERROR OF FCSAC191 INPUT FILE'        
              DISPLAY '**    FILE STATUS = ' WS-FAC191-STATUS           
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32352******************************************************************08061003
C32352*  4000-MAIL-NAME-ADDRESS                                        *10370000
C32352******************************************************************08061003
C32352     EXEC SQL                                                     10410000
C32352         INCLUDE CPD00074                                         10420000
C32352     END-EXEC.                                                    10430000
                                                                        
C32352******************************************************************08061003
C32352*  6010-REDUCE-EMBEDDED-SPACES                                   *10370000
C32352******************************************************************08061003
C32352     EXEC SQL                                                     10410000
C32352         INCLUDE CPD00004                                         10420000
C32352     END-EXEC.                                                    10430000
                                                                        
      ******************************************************************08061003
      *  6251-GET-FJC01-DATE                                           *10290000
      ******************************************************************08061003
                                                                        
       COPY CPD00037.                                                   10330000
                                                                        
      ******************************************************************08061003
      *  7600-START-FCSJC01                                            *10370000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10410000
               INCLUDE CPD00038                                         10420000
           END-EXEC.                                                    10430000
                                                                        
                                                                        
      ******************************************************************08061003
      *  6500-GET-NEXT-BUSINESS-DAY                                    *10370000
      *  DETERMINE THE NEXT BUSINESS DAY.                              *        
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10410000
               INCLUDE CPD00315                                         10420000
           END-EXEC.                                                    10430000
                                                                        
      ******************************************************************08061003
      * COPYBOOK FOR ABEND ROUTINE                                     *10470000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10510000
               INCLUDE CPD0023B                                         10520000
           END-EXEC.                                                    10530000
                                                                        
      ******************************************************************08061003
      * COPYBOOK FOR ABEND ROUTINE                                     *10470000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10510000
               INCLUDE CPD09900                                         10520000
           END-EXEC.                                                    10530000
