       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSAC189.                                            
       AUTHOR. BASKAR VANNI.                                            
       DATE-WRITTEN. DECEMBER 2010.                                     
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *      DATE       INITIALS   REASON                             *         
      *    ==========   =========  ================================   *         
      *    12/10/2010   BASKAR V   NEW PROGRAM                        *         
A03009*    01/14/2011   BASKAR V   USE CURRENT DATE INSTEAD OF COMMON *         
A03009*                            DATE                               *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
      *---------------------------------------------------------------*         
      * THIS PROGRAM CHECKS TWO HEADER RECORDS AND VERIFIES THAT THESE*         
      * TWO RECORDS HAVE THE CORRECT DATE. THIS PROGRAM RUNS IN THE   *         
      * SPECIAL HOLIDAY SCHEDULE BEFORE POSTING PAYMENTS TO MAKE SURE *         
      * WE ARE GOING TO PROCESS CORRECT FILES. THIS WILL AVOID        *         
      * DUPLICATE POSTING OF PAYMENT FILES IN CASE THE HOLIDAY JOBS   *         
      * WERE NOT RUN PROPERLY.                                        *         
      *---------------------------------------------------------------*         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.                                                 
       OBJECT-COMPUTER.                                                 
       SPECIAL-NAMES.                                                   
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
            SELECT CSHBANK ASSIGN  TO UT-S-CSHBANK                      
              FILE STATUS IS WS-CSHBANK-STATUS.                         
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  CSHBANK                                                      
           RECORDING MODE IS F                                          
           LABEL RECORDS STANDARD                                       
           DATA RECORD ARE WEB-HDR-REC.                                 
       01  WEB-HDR-REC.                                                 
           05  WEB-HDR-SOURCE          PIC XX.                          
           05  WEB-HDR-COMPANY         PIC XX.                          
           05  WEB-RECORD-COUNT        PIC 9(10).                       
           05  WEB-TOTAL-AMOUNT        PIC 9(08)V99.                    
           05  WEB-HDR-DATE            PIC 9(08).                       
           05  FILLER                  PIC X(68).                       
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC189'.
MSQ017     COPY MFASQLM.
       01  WS-CONSTANTS.                                                
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSAC189'.  
           05  WS-PGMNAME                  PIC X(08) VALUE 'PCSAC189'.  
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-YES                      PIC X(01) VALUE 'Y'.         
           05  WS-NO                       PIC X(01) VALUE 'N'.         
                                                                        
       01  WS-VARIABLES.                                                
           05 WS-ERR-MSG                       PIC X(120) VALUE SPACES. 
           05 WS-ERR-MSG2                      PIC X(120) VALUE SPACES. 
           05 WS-HOLIDAY-1                     PIC X(10).               
           05 WS-HOLIDAY-2                     PIC X(10).               
A03009     05 WS-INPUT-DT                      PIC X(10).               
           05 WS-FILE-DATE-1.                                           
              10 WS-DATE-YY-1                  PIC X(04).               
              10 FILLER                        PIC X(01) VALUE '-'.     
              10 WS-DATE-MM-1                  PIC X(02).               
              10 FILLER                        PIC X(01) VALUE '-'.     
              10 WS-DATE-DD-1                  PIC X(02).               
           05 WS-FILE-DATE-2.                                           
              10 WS-DATE-YY-2                  PIC X(04).               
              10 FILLER                        PIC X(01) VALUE '-'.     
              10 WS-DATE-MM-2                  PIC X(02).               
              10 FILLER                        PIC X(01) VALUE '-'.     
              10 WS-DATE-DD-2                  PIC X(02).               
                                                                        
       01  WS-PREV-BUSINESS-DAY-MISC.                                   
           05 WS-OLD-BUSINESS-DAY      PIC X(10).                       
           05 WS-PREV-SUNDAY           PIC S9(04) COMP VALUE -1.        
           05 WS-PREV-SATURDAY         PIC S9(04) COMP VALUE +5.        
           05 WS-PREV-BUSINESS-DAY     PIC  X(01)      VALUE 'N'.       
              88 PREV-BUSINESS-DAY-FOUND               VALUE 'Y'.       
                                                                        
       01  WS-SWITCHES.                                                 
           05 CSHBANK-EOF-SW                 PIC X(01)  VALUE 'N'.      
              88 CSHBANK-AT-EOF                         VALUE 'Y'.      
              88 CSHBANK-NOT-AT-EOF                     VALUE 'N'.      
           05 WS-CSHBANK-STATUS              PIC X(02)  VALUE '00'.     
              88 CSHBANK-SUCCESSFUL                     VALUE '00'.     
                                                                        
      *                                                                         
      *---------------------------------------------------------------*         
      * SQL COMMUNICATION AREA                                        *         
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      *    CSS_HOLIDAY                                                *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBHLDAY                                                     
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      *    CSS_JOB_PARM                                               *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                             
            INCLUDE  TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      *    COPYBOOK CONTAINS WORKING STORAGE VARIABLE FOR CPD00315    *         
      *    6500-GET-NEXT-BUSINESS-DAY                                 *         
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
              INCLUDE CWS00315                                                  
           END-EXEC.                                                            
                                                                        
       COPY FIOJC01.                                                            
                                                                        
      * DB2 AND SQL ERROR CHECKING VARIABLES                                    
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                           
                                                                        
      * WS-INPUT MISC VARIABLES                                                 
       COPY CWS00038.                                                           
                                                                        
           EXEC SQL                                                     
            DECLARE HOLIDAY_CSR CURSOR FOR                              
             SELECT TOP(2) HOLIDAY_DT                                          
               FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                           
              WHERE HOLIDAY_DT < IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                         
              ORDER BY HOLIDAY_DT DESC                                  
                                                  
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE HOLIDAY_CSR CURSOR FOR                                      
MFA-TR*      SELECT HOLIDAY_DT                                                  
MFA-TR*        FROM CSS_HOLIDAY                                                 
MFA-TR*       WHERE HOLIDAY_DT < :J8-HOLIDAY-DT                                 
MFA-TR*       ORDER BY HOLIDAY_DT DESC                                          
MFA-TR*       FETCH FIRST 2 ROW ONLY                                            
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7000                                                        
MFA-TR*    END-EXEC                                                             
                                                                        
       LINKAGE SECTION.                                                 
       PROCEDURE DIVISION.                                              
      *----------------------------------------------------------------*        
      **                         M A I N L I N E                      **        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-VALIDATE-FILE-DATE                              
              THRU 1000-EXIT                                            
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   COMMON INITIALIZATION ROUTINE                                *        
      *    GETS RUN DATE, OPEN INPUT FILE FOR PROCESSING               *        
      *----------------------------------------------------------------*        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                   
                                                                        
           IF COMMON-DATE-NEEDED                                        
A03009        PERFORM 7000-SELECT-CURRENT-DATE                          
A03009           THRU 7000-EXIT                                         
A03009        MOVE WS-INPUT-DT TO WS-INPUT-DATE                         
           END-IF                                                       
                                                                        
                                                                        
           OPEN INPUT CSHBANK                                           
                                                                        
           IF CSHBANK-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              STRING '** OPEN ERROR OF CSHBANK ' DELIMITED BY SIZE      
                     'INPUT FILE   **  '         DELIMITED BY SIZE      
                INTO WS-ERR-MSG                                         
              STRING 'FILE STATUS = '  DELIMITED BY SIZE                
                      WS-CSHBANK-STATUS  DELIMITED BY SIZE              
                INTO WS-ERR-MSG2                                        
              PERFORM 8900-DISPLAY-ERROR                                
                 THRU 8900-EXIT                                         
           END-IF                                                       
                                                                        
           MOVE WS-INPUT-DATE                TO WS-OLD-BUSINESS-DAY     
           MOVE WS-NO                        TO WS-PREV-BUSINESS-DAY    
           MOVE SPACES                       TO WS-HOLIDAY-EXISTS       
                                                                        
           PERFORM 1300-GET-PREV-BUSINESS-DAY THRU 1300-EXIT            
             UNTIL PREV-BUSINESS-DAY-FOUND                              
           MOVE WS-NO                        TO WS-PREV-BUSINESS-DAY    
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   VERIFIES THE FILE DATES ARE CORRECT FOR PROCESSING THE       *        
      *    PAYMENTS                                                    *        
      *----------------------------------------------------------------*        
       1000-VALIDATE-FILE-DATE.                                         
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 1100-GET-HOLIDAY-DATES                               
              THRU 1100-EXIT                                            
                                                                        
           PERFORM 7400-READ-CSHBANK                                    
              THRU 7400-EXIT                                            
           IF CSHBANK-AT-EOF                                            
              STRING '** CSHBANK INPUT FILE IS ' DELIMITED BY SIZE      
                     'EMPTY     **  '            DELIMITED BY SIZE      
                INTO WS-ERR-MSG                                         
              PERFORM 8900-DISPLAY-ERROR                                
                 THRU 8900-EXIT                                         
           ELSE                                                         
              MOVE WEB-HDR-DATE(1:4) TO WS-DATE-YY-1                    
              MOVE WEB-HDR-DATE(5:2) TO WS-DATE-MM-1                    
              MOVE WEB-HDR-DATE(7:2) TO WS-DATE-DD-1                    
           END-IF                                                       
                                                                        
           PERFORM 7400-READ-CSHBANK                                    
              THRU 7400-EXIT                                            
           IF CSHBANK-AT-EOF                                            
              STRING '** CSHBANK INPUT FILE HAS' DELIMITED BY SIZE      
                     ' ONLY ONE RECORD  ** '     DELIMITED BY SIZE      
                INTO WS-ERR-MSG                                         
              PERFORM 8900-DISPLAY-ERROR                                
                 THRU 8900-EXIT                                         
           ELSE                                                         
              MOVE WEB-HDR-DATE(1:4) TO WS-DATE-YY-2                    
              MOVE WEB-HDR-DATE(5:2) TO WS-DATE-MM-2                    
              MOVE WEB-HDR-DATE(7:2) TO WS-DATE-DD-2                    
           END-IF                                                       
                                                                        
           DISPLAY ' FIRST FILE DATE     = ' WS-FILE-DATE-1             
           DISPLAY ' SECOND FILE DATE    = ' WS-FILE-DATE-2             
           DISPLAY ' FIRST HOLIDAY DATE  = ' WS-HOLIDAY-1               
           DISPLAY ' SECOND HOLIDAY DATE = ' WS-HOLIDAY-2               
           DISPLAY ' CURRENT DATE        = ' WS-INPUT-DATE              
           DISPLAY ' PREV BUSINESS DATE  = ' WS-OLD-BUSINESS-DAY        
                                                                        
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           IF WEB-HDR-SOURCE = 'CF'                                     
              IF (WS-FILE-DATE-2 = WS-HOLIDAY-1 OR                      
                  WS-FILE-DATE-2 = WS-HOLIDAY-2 ) AND                   
                 WS-FILE-DATE-1 = WS-INPUT-DATE                         
                 CONTINUE                                               
              ELSE                                                      
                 STRING 'PROBLEM ALERT ;- CHECK THE PAYMENT FILES, '    
                          DELIMITED BY SIZE                             
                'THEY MIGHT HAVE POSTED ALREADY. '                      
                          DELIMITED BY SIZE INTO WS-ERR-MSG             
                 PERFORM 8900-DISPLAY-ERROR                             
                    THRU 8900-EXIT                                      
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WEB-HDR-SOURCE = 'BA'                                     
              IF (WS-FILE-DATE-1 = WS-HOLIDAY-1 OR                      
                  WS-FILE-DATE-1 = WS-HOLIDAY-2 ) AND                   
                 WS-FILE-DATE-2 = WS-OLD-BUSINESS-DAY                   
                 CONTINUE                                               
              ELSE                                                      
                 STRING 'PROBLEM ALERT ;- CHECK THE PAYMENT FILES, '    
                          DELIMITED BY SIZE                             
                'THEY MIGHT HAVE POSTED ALREADY. '                      
                          DELIMITED BY SIZE INTO WS-ERR-MSG             
                 PERFORM 8900-DISPLAY-ERROR                             
                    THRU 8900-EXIT                                      
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   GETS THE LAST TWO HOLIDAYS                                   *        
      *----------------------------------------------------------------*        
       1100-GET-HOLIDAY-DATES.                                          
                                                                        
           MOVE '1100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-INPUT-DATE TO J8-HOLIDAY-DT                          
           PERFORM 7100-OPEN-HOLIDAY-CURSOR                             
              THRU 7100-EXIT                                            
                                                                        
           PERFORM 7200-FETCH-HOLIDAY-CURSOR                            
              THRU 7200-EXIT                                            
           MOVE J8-HOLIDAY-DT TO WS-HOLIDAY-1                           
                                                                        
           PERFORM 7200-FETCH-HOLIDAY-CURSOR                            
              THRU 7200-EXIT                                            
           MOVE J8-HOLIDAY-DT TO WS-HOLIDAY-2                           
                                                                        
           PERFORM 7300-CLOSE-HOLIDAY-CURSOR                            
              THRU 7300-EXIT                                            
           .                                                            
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  12880000
      * SELECTS THE PREVIOUS BUSINESS DATE                           *  12890000
      *--------------------------------------------------------------*  12900000
       1300-GET-PREV-BUSINESS-DAY.                                      
                                                                        
           MOVE '1300'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 7500-GET-PREV-BUSINESS-DAY THRU 7500-EXIT            
                                                                        
      ***  CHECK TO SEE IF IT IS A WEEKEND...                           12960000
           IF WS-DAY-OF-WEEK NOT EQUAL WS-PREV-SATURDAY AND             
              WS-DAY-OF-WEEK NOT EQUAL WS-PREV-SUNDAY                   
                                                                        
              MOVE WS-OLD-BUSINESS-DAY       TO J8-HOLIDAY-DT           
              MOVE WS-NO                     TO WS-HOLIDAY-EXISTS       
                                                                        
      ***  ...IF NOT A WEEKEND, THEN CHECK TO SEE IF IT IS A HOLIDAY    13030000
              PERFORM 7550-CHECK-HOLIDAY     THRU 7550-EXIT             
              IF HOLIDAY-EXISTS-NO                                      
                  MOVE WS-YES                TO WS-PREV-BUSINESS-DAY    
              ELSE                                                      
                  MOVE WS-NO                 TO WS-PREV-BUSINESS-DAY    
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03009*--------------------------------------------------------------*  12880000
A03009* SELECTS CURRENT DATE                                         *  12890000
      *--------------------------------------------------------------*  12900000
       7000-SELECT-CURRENT-DATE.                                        
                                                                        
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
            EXEC SQL                                                    
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-INPUT-DT                                       
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-INPUT-DT                                               
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR SELECTING CURRENT DATE **'                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
A03009 7000-EXIT.                                                       
A03009     EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  12880000
      * OPENS THE HOLIDAY CURSOR                                     *  12890000
      *--------------------------------------------------------------*  12900000
       7100-OPEN-HOLIDAY-CURSOR.                                        
                                                                        
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               OPEN HOLIDAY_CSR                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING HOLIDAY_CSR CURSOR **'             
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  12880000
      * GET SELECTED ROWS FROM THE HOLIDAY CURSOR                    *  12890000
      *--------------------------------------------------------------*  12900000
       7200-FETCH-HOLIDAY-CURSOR.                                       
                                                                        
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              FETCH HOLIDAY_CSR                                         
               INTO :J8-HOLIDAY-DT                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR FETCHING HOLIDAY_CSR CURSOR **'            
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  12880000
      * CLOSE THE HOLIDAY CURSOR                                     *  12890000
      *--------------------------------------------------------------*  12900000
       7300-CLOSE-HOLIDAY-CURSOR.                                       
                                                                        
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              CLOSE HOLIDAY_CSR                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR CLOSING HOLIDAY_CSR CURSOR **'             
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  12880000
      * READ THE CSHBANK INPUT FILE                                  *  12890000
      *--------------------------------------------------------------*  12900000
       7400-READ-CSHBANK.                                               
                                                                        
           MOVE '7400'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           READ CSHBANK                                                 
               AT END                                                   
                  MOVE WS-Y TO CSHBANK-EOF-SW                           
                                                                        
           IF CSHBANK-SUCCESSFUL OR CSHBANK-AT-EOF                      
              CONTINUE                                                  
           ELSE                                                         
             STRING '** READ ERROR OF CSHBANK FILE ' DELIMITED BY SIZE  
               INTO WS-ERR-MSG                                          
             STRING 'FILE STATUS = ' DELIMITED BY SIZE                  
                    WS-CSHBANK-STATUS  DELIMITED BY SIZE                
               INTO WS-ERR-MSG2                                         
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 25400000
      *    FINDS THE PREV BUSINESS DAY, SKIPPING OVER WEEKENDS        * 25410000
      *    AND HOLIDAYS (FOUND IN CSS_HOLIDAY), FROM THE CURRENT      * 25420000
      *    VALUE IN WS-OLD-BUSINESS-DAY                               * 25430000
      *---------------------------------------------------------------* 25440000
       7500-GET-PREV-BUSINESS-DAY.                                      
                                                                        
           MOVE '7500'                TO WS-ACTIVE-PARAGRAPH            
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-OLD-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-OLD-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-BUSINESS-DAY
              ), CONVERT(DATE, :WS-OLD-BUSINESS-DAY) ) ),
              (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-OLD-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-OLD-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-BUSINESS-DAY
              ), CONVERT(DATE, :WS-OLD-BUSINESS-DAY) ) )) -       
                      CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-OLD-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-OLD-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-BUSINESS-DAY
              ), CONVERT(DATE, :WS-OLD-BUSINESS-DAY) ) ))/7*7)-1
            INTO
              :WS-OLD-BUSINESS-DAY,
              :WS-DAY-OF-WEEK  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     25480000
MFA-TR*       SET :WS-OLD-BUSINESS-DAY =                                25490000
MFA-TR*                      DATE(:WS-OLD-BUSINESS-DAY) - 1 DAYS        25500000
MFA-TR*          ,:WS-DAY-OF-WEEK =                                     25501000
MFA-TR*              (DAYS(DATE(:WS-OLD-BUSINESS-DAY) - 1 DAYS) -       25502000
MFA-TR*               DAYS(DATE(:WS-OLD-BUSINESS-DAY) - 1 DAYS)/7*7)-1  25503000
MFA-TR*    END-EXEC                                                     25510000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              STRING '** SELECT PREVIOUS BUSINESS ' DELIMITED BY SIZE   
                     'DATE   **  '  DELIMITED BY SIZE                   
                      INTO WS-ERR-MSG                                   
              STRING 'WS-OLD-BUSINESS-DATE = '  DELIMITED BY SIZE       
                      WS-OLD-BUSINESS-DAY    DELIMITED BY SIZE          
                      INTO WS-ERR-MSG2                                  
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 26820000
      * CHECKS WHETHER THE GIVEN DATE IS EXISTS IN HOLIDAY TABLE      * 26830000
      *---------------------------------------------------------------* 26840000
       7550-CHECK-HOLIDAY.                                              
                                                                        
           MOVE '7550'                TO WS-ACTIVE-PARAGRAPH            
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-HOLIDAY-EXISTS                                  
               FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                           
              WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                         
                                                  
                                                            
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     26880000
MFA-TR*      SELECT 'Y'                                                 26891000
MFA-TR*        INTO :WS-HOLIDAY-EXISTS                                  26900000
MFA-TR*        FROM CSS_HOLIDAY                                         26910000
MFA-TR*       WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                         26920000
MFA-TR*       FETCH FIRST 1 ROW ONLY                                    26922000
MFA-TR*       QUERYNO 7550                                                      
MFA-TR*        WITH UR                                                  26923000
MFA-TR*    END-EXEC                                                     26930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              STRING '** CHECKS WHETHER THE SELECTED' DELIMITED BY SIZE 
                     ' DATE IS A HOLIDAY IN '  DELIMITED BY SIZE        
                     ' CSS_HOLIDAY      **  '  DELIMITED BY SIZE        
                      INTO WS-ERR-MSG                                   
              STRING 'HOLIDAY_DT = '  DELIMITED BY SIZE                 
                      J8-HOLIDAY-DT   DELIMITED BY SIZE                 
                      INTO WS-ERR-MSG2                                  
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 26820000
      *   DISPLAY TABLE ERROR                                         *         
      *---------------------------------------------------------------* 26820000
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'.    
           DISPLAY '**     PCSAC189 PROCESSING ERROR            **'.    
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'.    
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE.           
           DISPLAY '**       PROCESSING TERMINATED              **'.    
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------* 26820000
      *   DISPLAY ERROR                                               *         
      *---------------------------------------------------------------* 26820000
       8900-DISPLAY-ERROR.                                              
      *-------------------*                                                     
           DISPLAY '                                          '.        
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSAC189 PROCESSING ERROR        **'.        
           DISPLAY '******************************************'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**       PROCESSING TERMINATED          **'.        
           DISPLAY '******************************************'.        
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 26820000
      * CLOSE THE INPUT FILE                                          *         
      *---------------------------------------------------------------* 26820000
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           CLOSE CSHBANK                                                
                                                                        
           IF CSHBANK-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSAC189 PROCESSING ERROR  **'               
              DISPLAY '**    CLOSE ERROR OF CSHBANK INPUT FILE'         
              DISPLAY '**    FILE STATUS = ' WS-CSHBANK-STATUS          
           END-IF                                                       
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 26820000
      * COPYBOOK TO READ PARM FILE FOR OVERRIDE DATE                  *         
      *---------------------------------------------------------------* 26820000
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------* 26820000
      * SQLS FOR COPYBOOK CPD00037                                    *         
      *---------------------------------------------------------------* 26820000
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------* 26820000
      * ABEND ROUTINE                                                 *         
      *---------------------------------------------------------------* 26820000
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
