       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSAC187.                                        
       DATE-WRITTEN.   FEB 2007.                                        
      ******************************************************************        
      *                                                                *        
      *                 PROGRAM MODIFICATION LOG                       *        
      *                                                                *        
      *   DATE    INITIALS   REASON                                    *        
      * --------  --------   -------------------------------------     *        
      *  02/07     LG        NEW PROGRAM TO CALL THE DNP CANCEL PROCESS*        
      *                      THIS WILL REPLACE THE SQR CAC100.         *        
A01757* 12/21/09  BASKAR V   CORRECTED THE ERROR CHECK PROCESS AND     *        
      *                      HANDLED THE RETURN CODE PROPERLY          *        
A04687* 06/06/13  BASKAR V   REMOVED UNUSED PARMS                      *        
      ******************************************************************        
      *                                                                         
              REMARKS.                                                  
      *                                                                         
      ******************************************************************        
      *  THIS PROGRAM CALLS THE STORED PROCEDURE CSR02336 WHICH CANCEL *        
      *  DNPS.                                                         *        
      ******************************************************************        
      *                                                                         
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
      *                                                                         
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
                                                                        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC187'.
MSQ017     COPY MFASQLM.
       01  WS-ERR-MSG1                 PIC X(100)  VALUE SPACES.        
       01  WS-ERR-MSG2                 PIC X(100)  VALUE SPACES.        
                                                                        
       01  WS-HARDCODED-VARS.                                           
           05 PROGRAM-NAME             PIC X(08)   VALUE 'PCSAC187'.    
                                                                        
       01  WS-MSGTEXT                  PIC X(255)  VALUE SPACES.        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE            PIC S9(9) COMP VALUE +0.         
                                                                        
       01  S-RETURN-CODE-DISP          PIC +ZZZZZZZZ9.                  
                                                                        
      *01  LOC1        USAGE IS SQL TYPE IS                             
      *                RESULT-SET-LOCATOR VARYING.                      
                                                                        
           EXEC SQL                                                             
            INCLUDE SQLCA                                                       
           END-EXEC.                                                            
                                                                        
      *COPYBOOK FOR ERROR HANDLING                                              
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      *DECLARE DB2 ERROR PROCESSING VARIABLES                                   
       COPY CWS00303.                                                           
MSQ001        EXEC SQL
MSQ001          DECLARE C1 CURSOR
MSQ001          FOR CALL CSR02336                                       
                         ( :WS-UPDATE-PARM
                  )
MSQ001        END-EXEC.
       
                                                                        
       LINKAGE SECTION.                                                 
       01 WS-PARM.                                                      
          05 WS-LENGTH                   PIC S9(4) COMP.                
          05 WS-UPDATE-PARM              PIC X(01).                     
                                                                        
       PROCEDURE DIVISION USING WS-PARM.                                
                                                                        
      ******************************************************************        
      **                         M A I N L I N E                      **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 2000-CALL-DNPCANCEL-PROC THRU 2000-EXIT.             
           IF S-RETURN-CODE = SUCCESSFUL-CALL                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE S-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE    
              MOVE ACTIVE-PARAGRAPH         TO WS-ACTIVE-PARAGRAPH      
              PERFORM 8200-DISPLAY-ERROR    THRU 8200-EXIT              
           END-IF.                                                      
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** CALL DNP CANCEL PROCEDURE CSR02336                          **         
      *****************************************************************         
       2000-CALL-DNPCANCEL-PROC.                                        
           MOVE '2000'                       TO WS-ACTIVE-PARAGRAPH.    
           MOVE 0                            TO S-RETURN-CODE.          
           DISPLAY ' UPDATE PARM : ' WS-UPDATE-PARM.                    
                                                                        
      *    EXEC SQL CALL CSR02336                                       
      *                  (:WS-UPDATE-PARM                               
      *                  )                                              
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           IF SQLCODE = 466 THEN                                        
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
      *           CSR02336                                              
      *       END-EXEC                                                  
                                                                        
      *       EXEC SQL ALLOCATE C1 CURSOR FOR RESULT SET :LOC1          
      *       END-EXEC                                                  
                                                                        
              EXEC SQL                                                  
                  FETCH C1 INTO :S-RETURN-CODE,                         
                                :ACTIVE-PARAGRAPH,                      
                                :WS-MSGTEXT                             
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              IF SQLCODE NOT EQUAL 0                                    
                 MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE          
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 STRING 'ERROR IN CSR02336 FETCH STATEMENT'             
                                      DELIMITED BY SIZE                 
                                      INTO WS-ERR-MSG1                  
                 PERFORM 8200-DISPLAY-ERROR    THRU 8200-EXIT           
              END-IF                                                    
A01757        IF S-RETURN-CODE NOT EQUAL 0                              
A01757           MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
A01757           MOVE S-RETURN-CODE   TO WS-ACTIVE-RETURN-CODE          
A01757           STRING 'ERROR IN CSR02336 WHILE CANCELLING DNP'        
A01757                                DELIMITED BY SIZE                 
A01757                                INTO WS-ERR-MSG1                  
A01757           PERFORM 8200-DISPLAY-ERROR    THRU 8200-EXIT           
A01757        END-IF                                                    
              MOVE S-RETURN-CODE       TO S-RETURN-CODE-DISP            
              DISPLAY 'CSR02336 RETURN CODE   : ' S-RETURN-CODE-DISP    
              DISPLAY 'NO. OF ACCTS PROCESSED : ' WS-MSGTEXT            
           ELSE                                                         
              MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              STRING  'ERROR RETURNING FROM CSR02336   **'              
                                       DELIMITED BY SIZE                
                                       INTO WS-ERR-MSG1                 
              STRING 'UPDATE PARM = '  DELIMITED BY SIZE                
                     WS-UPDATE-PARM    DELIMITED BY SIZE                
                     'PROGRAM NAME = ' DELIMITED BY SIZE                
                     PROGRAM-NAME      DELIMITED BY SIZE                
                                       INTO WS-ERR-MSG2                 
              PERFORM 8200-DISPLAY-ERROR    THRU 8200-EXIT              
           END-IF.                                                      
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-DISPLAY-ERROR.                                              
           MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-DISP            
           DISPLAY '*--------------------------------------------*'     
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'     
           DISPLAY  WS-ERR-MSG1                                         
           DISPLAY '*--------------------------------------------*'     
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
           DISPLAY '** SQLCODE           = ' S-RETURN-CODE-DISP         
           DISPLAY '** ' WS-ERR-MSG2                                    
           DISPLAY '*--------------------------------------------*'     
                                                                        
           DISPLAY '** PERFORMING ABEND PROCESS **'                     
           MOVE 12         TO RETURN-CODE                               
           STOP RUN.                                                    
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
