       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSAC185.                                         
       DATE-WRITTEN.  10/11/06.                                         
       DATE-COMPILED.                                                   
      *****************************************************************         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *                    PROGRAM SUMMARY                             *        
      *  THIS PROGRAM IS REVISED VERSION OF FCS073 WRITTEN FOR MAIL    *        
      *  PAYMENTS TO ENSURE THAT EACH BATCH NUMBER IS UNIQUE AND ALL   *        
      *  BATCHES WERE TRANSMITTED ONLY ONCE.  PROGRAM WILL PERFORM     *        
      *  EDITS ON NUMERIC FIELDS, SUMMARIZE AMOUNTS FROM EACH DETAIL   *        
      *  RECORD TO CHECK AGAINST THE AMOUNT IN THE TOTAL RECORD FOR    *        
      *  EACH BATCH, ALSO THE NUMBER OF DETAIL RECORDS IN EACH BATCH.  *        
      *  A SUMMARY RECORD FOR EACH BATCH WILL BE WRITTEN TO A FILE,    *        
      *  AND A REPORT WILL BE WRITTEN WITH ANY ERRORS THAT OCCURRED.   *        
      *  PROGRAM WILL ABEND IF THERE IS A DUPLICATE BATCH NUMBER OR    *        
      *  IF WE HAVE BAD ACCOUNT NUMBERS GREATER THAN OR EQUAL TO       *        
      *  FIVE ALL DATA MUST BE CORRECT BEFORE RERUNNING THE JOB.       *        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *                   PROGRAM MAINTENANCE LOG                     *         
      *     DATE       PROGRAMMER  BRIEF DESCRIPTION OF MAINTENANCE   *         
      *  ----- -----   ---------   ---------------------------------- *         
C34844*  10/11/2006    AP40911    1.MOVE PROGRAM FROM FCS TO CIS      *         
      *                            STANDARDS                          *         
      *                           2.CODE WAS ADDED FOR THE PROCESS    *         
      *                             NOT TO ABEND FOR A BAD ACCOUNT NO *         
      *                             AS THE NEXT STEP IN THE PAYMENT   *         
      *                             PROCESS WILL HANDLE THIS WITHOUT  *         
      *                             ABEND BUT IT WILL ABEND IF THE BAD*         
      *                             ACCOUNTNO COUNT IS GREATER THAN   *         
      *                             OR EQUAL TO FIVE AND PRINTS ALL   *         
      *                             THE BAD ACCOUNT NO'S.                       
      *  ----- -----  ----------   ---------------------------------- *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                                                                        
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 4999     OUTPUT PROCESSING CONTROL PATH          
                5000 - 6099     COMMON PROGRAM MODULES                  
                6100 - 6499     COMMON SYSTEM MODULES                   
                6500 - 6999     INPUT MODULES                           
                7000 - 8999     OUTPUT MODULES                          
                9000 - 9999     TERMINATION MODULES                     
                                                                        
HPCCDM*EJECT                                                            00640000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-3172.                                    
       OBJECT-COMPUTER.    IBM-3172.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT BANKTRAN ASSIGN TO UT-S-BANKTRAN.                     
           SELECT BATCHIN  ASSIGN TO UT-S-BATCHIN.                      
           SELECT BATCHOUT ASSIGN TO UT-S-BATCHOUT.                     
           SELECT PRINTER1 ASSIGN TO UT-S-PRINTER1.                     
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  BANKTRAN                                                     
           LABEL RECORDS ARE STANDARD                                   
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           RECORD CONTAINS 80 CHARACTERS                                
           DATA RECORD IS  DETAIL-REC  NOTICE-REC  BATCH-TOTAL-REC.     
       01  DETAIL-REC.                                                  
           05  DETAIL-RECORD-TYPE      PIC 9.                           
           05  DETAIL-OUT-SEQ-NUM      PIC 9(6).                        
           05  DETAIL-DATE.                                             
               10  DETAIL-DATE-MO      PIC 9(2).                        
               10  DETAIL-DATE-DA      PIC 9(2).                        
               10  DETAIL-DATE-YR.                                      
                   15  DETAIL-DT-YEAR1 PIC 9.                           
                   15  DETAIL-DT-YEAR2 PIC 9.                           
           05  DETAIL-BAT-NUM-AREA.                                     
               10  DETAIL-BATCH-TYPE       PIC 9.                       
               10  DETAIL-BATCH-NUMBER     PIC 9(3).                    
           05  DETAIL-BAT-NUMBER REDEFINES DETAIL-BAT-NUM-AREA          
                                       PIC 9(04).                       
           05  DETAIL-SEQUENCE-NO      PIC 9(6).                        
           05  DETAIL-ACCOUNT-NO.                                       
               10  DETAIL-CYCLE        PIC 9(2).                        
               10  DETAIL-KEY.                                          
                   15  DETAIL-LOC-OFC  PIC 9(2).                        
                   15  DETAIL-ROUTE    PIC 9(4).                        
                   15  DETAIL-FOLIO    PIC 9(4).                        
                   15  DETAIL-CS       PIC 9.                           
           05  DETAIL-ACCOUNT-NO-9 REDEFINES DETAIL-ACCOUNT-NO          
                                       PIC 9(13).                       
           05  FILLER                  PIC X.                           
           05  DETAIL-PAY-CODE         PIC X.                           
           05  DETAIL-PAY-AMOUNT       PIC 9(8)V99.                     
           05  DETAIL-BILL-DATE.                                        
               10  DETAIL-DT-BILL-MO   PIC X(2).                        
               10  DETAIL-DT-BILL-YR   PIC X(2).                        
           05  FILLER                  PIC X(28).                       
       01  NOTICE-REC.                                                  
           05  NOTICE-RECORD-TYPE      PIC 9.                           
           05  NOTICE-OUT-SEQ-NUM      PIC 9(6).                        
           05  NOTICE-DATE.                                             
               10  NOTICE-DATE-MO      PIC 9(2).                        
               10  NOTICE-DATE-DA      PIC 9(2).                        
               10  NOTICE-DATE-YR      PIC 9(2).                        
           05  NOTICE-PAY-AMOUNT       PIC 9(8)V99.                     
           05  NOTICE-SIGN             PIC X.                           
           05  NOTICE-COMMENT          PIC X(30).                       
           05  NOTICE-AGENT-ID         PIC X(6).                        
           05  FILLER                  PIC X(20).                       
       01  BATCH-TOTAL-REC.                                             
           05  BATCH-TOT-RECORD-TYPE   PIC 9.                           
           05  BATCH-TOT-OUT-SEQ-NUM   PIC 9(6).                        
           05  BATCH-TOT-DATE.                                          
               10  BATCH-TOT-DATE-MO   PIC 9(2).                        
               10  BATCH-TOT-DATE-DA   PIC 9(2).                        
               10  BATCH-TOT-DATE-YR   PIC 9(2).                        
           05  BATCH-TOT-BAT-NUM-AREA.                                  
               10  BATCH-TOT-BATCH-TYPE    PIC 9.                       
               10  BATCH-TOT-BATCH-NUMBER  PIC 9(3).                    
           05  BATCH-TOT-NUMBER REDEFINES BATCH-TOT-BAT-NUM-AREA        
                                       PIC 9(04).                       
           05  BATCH-TOT-NO-DOCUMENTS  PIC 9(3).                        
           05  BATCH-TOT-AMOUNT-TOTAL  PIC 9(9)V99.                     
           05  BATCH-TOT-CHEK-AMT-TOT  PIC 9(9)V99.                     
           05  BATCH-TOT-BANK-NO       PIC 9(5).                        
           05  BATCH-TOT-AGENT-ID      PIC X(6).                        
           05  FILLER                  PIC X(27).                       
                                                                        
       FD  BATCHIN                                                      
           LABEL RECORDS ARE STANDARD                                   
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           RECORD CONTAINS 80 CHARACTERS                                
           DATA RECORD IS BATCH-SUM-IN-REC.                             
       01  BATCH-SUM-IN-REC.                                            
           05  BATCH-SUM-REC-TYPE-IN   PIC 9.                           
           05  BATCH-SUM-OSEQ-NO-IN    PIC 9(6).                        
           05  BATCH-SUM-DATE-IN.                                       
               10  BATCH-SUM-DT-MO-IN  PIC 9(2).                        
               10  BATCH-SUM-DT-DA-IN  PIC 9(2).                        
               10  BATCH-SUM-DT-YR-IN  PIC 9(2).                        
           05  BATCH-NUM-IN-AREA.                                       
               10  BATCH-SUM-TYPE-IN       PIC 9.                       
               10  BATCH-SUM-BATCH-NO-IN   PIC 9(3).                    
           05  BATCH-NUMBER-IN REDEFINES BATCH-NUM-IN-AREA              
                                       PIC 9(04).                       
           05  BATCH-SUM-NO-DOCS-IN    PIC 9(3).                        
           05  BATCH-SUM-AMT-TOT-IN    PIC 9(9)V99.                     
           05  BATCH-SUM-CHEK-AMT-IN   PIC 9(9)V99.                     
           05  BATCH-SUM-BANK-NO-IN    PIC 9(5).                        
           05  BATCH-SUM-AGENT-ID-IN   PIC X(6).                        
           05  FILLER                  PIC X(27).                       
                                                                        
       FD  BATCHOUT                                                     
           LABEL RECORDS ARE STANDARD                                   
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           RECORD CONTAINS 80 CHARACTERS                                
           DATA RECORD IS BATCH-SUM-OUT-REC.                            
       01  BATCH-SUM-OUT-REC.                                           
           05  BATCH-SUM-REC-TYP-OUT   PIC 9.                           
           05  BATCH-SUM-OSEQ-NO-OUT   PIC 9(6).                        
           05  BATCH-SUM-DATE-OUT.                                      
               10  BATCH-SUM-DT-MO-OUT PIC 9(2).                        
               10  BATCH-SUM-DT-DA-OUT PIC 9(2).                        
               10  BATCH-SUM-DT-YR-OUT PIC 9(2).                        
           05  BATCH-NUM-OT-AREA.                                       
               10  BATCH-SUM-TYPE-OUT      PIC 9.                       
               10  BATCH-SUM-BATCH-NO-OUT  PIC 9(3).                    
           05  BATCH-NUMBER-OT REDEFINES BATCH-NUM-OT-AREA              
                                       PIC 9(04).                       
           05  BATCH-SUM-NO-DOCS-OUT   PIC 9(3).                        
           05  BATCH-SUM-AMT-TOT-OUT   PIC 9(9)V99.                     
           05  BATCH-SUM-CHEK-AMT-OUT  PIC 9(9)V99.                     
           05  BATCH-SUM-BANK-NO-OUT   PIC 9(5).                        
           05  BATCH-SUM-AGENT-ID-OUT  PIC X(6).                        
           05  FILLER                  PIC X(27).                       
                                                                        
       FD  PRINTER1                                                     
           LABEL RECORDS ARE STANDARD                                   
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           RECORD CONTAINS 132 CHARACTERS                               
           DATA RECORD IS PRT-1-RECORD.                                 
       01  PRT-1-RECORD.                                                
           05  FILLER                  PIC X(132).                      
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC185'.
MSQ017     COPY MFASQLM.
                                                                        
C34844*    COPY SDTCDAT2.                                                       
                                                                        
       01  WS-MAX-SUB                  PIC 9(03) VALUE 998.             
                                                                        
       77  EOJ-CODE                    PIC S9(4)     COMP SYNC VALUE +0.
                                                                        
       01  FILLER                      PIC X(45)     VALUE              
           '*** PCSAC185WORKING-STORAGE BEGINS HERE ***'.               
                                                                        
       01  CURRENT-DATE.                                                
           05  WS-CY                   PIC 9(2).                        
           05  WS-CM                   PIC 9(2).                        
           05  WS-CD                   PIC 9(2).                        
                                                                        
       01  RUN-DATE1.                                                   
           05  RUN-MM                  PIC X(2).                        
           05  FILLER                  PIC X       VALUE '/'.           
           05  RUN-DD                  PIC X(2).                        
           05  FILLER                  PIC X       VALUE '/'.           
           05  RUN-YY                  PIC X(2).                        
                                                                        
       01  RUN-TIME.                                                    
           05  RUN-HOUR                PIC X(2).                        
           05  RUN-MINU                PIC X(2).                        
           05  RUN-SECO                PIC X(2).                        
           05  RUN-HSEC                PIC X(2).                        
                                                                        
       01  LITERALS.                                                    
           05  WS-Y                    PIC X         VALUE 'Y'.         
           05  WS-N                    PIC X         VALUE 'N'.         
           05  WS-51                   PIC 99        VALUE 51.          
C34844     05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSAC185'.  
                                                                        
       01  WS-PREV-BATCH-REC-NUM.                                       
           05  WS-PREV-BATCH-TYPE      PIC 9(01)     VALUE ZEROES.      
           05  WS-PREV-BATCH-NUM       PIC 9(03)     VALUE ZEROES.      
       01  WS-PREV-BATCH-REC-9 REDEFINES WS-PREV-BATCH-REC-NUM          
                                       PIC 9(04).                       
                                                                        
       01  WS-PREV-DET-REC-NUM.                                         
           05  WS-PREV-DET-TYPE        PIC 9(01)     VALUE ZEROES.      
           05  WS-PREV-DET-NUM         PIC 9(03)     VALUE ZEROES.      
       01  WS-PREV-DET-REC-9 REDEFINES WS-PREV-DET-REC-NUM              
                                       PIC 9(04).                       
                                                                        
       01  WS-CUR-DET-REC-NUM.                                          
           05  WS-CUR-DET-TYPE         PIC 9(01)     VALUE ZEROES.      
           05  WS-CUR-DET-NUM          PIC 9(03)     VALUE ZEROES.      
       01  WS-CUR-DET-REC-9 REDEFINES WS-CUR-DET-REC-NUM                
                                       PIC 9(04).                       
                                                                        
       01  FLAGS.                                                       
           05  EOF-BANKTRAN            PIC X         VALUE 'N'.         
               88  END-OF-BANKTRAN-FILE              VALUE 'Y'.         
           05  EOF-BATCHIN             PIC X.                           
               88  END-OF-BATCHIN-FILE               VALUE 'Y'.         
               88  NOT-END-OF-BATCHIN                VALUE 'N'.         
           05  MATCH-FOUND             PIC X.                           
               88  MATCH-IS-FOUND                    VALUE 'Y'.         
               88  MATCH-NOT-FOUND                   VALUE 'N'.         
           05  NUMERIC-ERROR           PIC X         VALUE 'N'.         
               88  NUMERIC-ERROR-FOUND               VALUE 'Y'.         
           05  BATCH-DUPLICATE         PIC X         VALUE 'N'.         
               88  BATCH-DUPLICATE-FOUND             VALUE 'Y'.         
                                                                        
       01  SUBSCRIPTS.                                                  
           05  BATCH-SUB               PIC S9(3)     COMP-3 VALUE +0.   
           05  TABLE-SUB               PIC S9(3)     COMP-3 VALUE +0.   
           05  ERROR-SUB               PIC S9(3)     COMP-3 VALUE +0.   
           05  WRITE-SUB               PIC S9(3)     COMP-3 VALUE +0.   
           05  SEARCH-SUB              PIC S9(3)     COMP-3 VALUE +0.   
           05  RECORD-SUB              PIC S9(3)     COMP-3 VALUE +0.   
                                                                        
       01  COUNTERS.                                                    
           05  DET-ERRORS-FOUND        PIC 9(3)      VALUE ZERO.        
           05  NOT-ERRORS-FOUND        PIC 9(3)      VALUE ZERO.        
           05  BAT-ERRORS-FOUND        PIC 9(3)      VALUE ZERO.        
           05  TOT-ERRORS-FOUND        PIC 9(3)      VALUE ZERO.        
           05  NUM-DETAIL-RECS         PIC 9(3)      VALUE ZERO.        
           05  NUM-TOTALS-RECS         PIC 9(3)      VALUE ZERO.        
           05  PREV-BATCH-REC-CNT      PIC 9(3)      VALUE ZERO.        
           05  NEW-BATCH-REC-CNT       PIC 9(3)      VALUE ZERO.        
           05  BATCH-TOT-AMOUNT        PIC 9(11)V99  VALUE ZERO.        
           05  MAX-PRINT-ERRORS        PIC 9(3)      VALUE ZERO.        
           05  DUPLICATE-COUNT         PIC 9(3)      VALUE ZERO.        
C34844     05  ACCOUNTNO-COUNT         PIC 9(3)      VALUE ZERO.        
C34844     05  WS-COUNT                PIC 9(3)      VALUE ZERO.        
C34844     05  WS-PRINTED              PIC X(1)      VALUE 'N'.         
           05  WS-ACCT-COUNT           PIC 9(3)      VALUE ZERO.        
                                                                        
       01  DISPLAY-COUNT.                                               
           05  BATCH-COUNTER  OCCURS 998 TIMES.                         
               10  NO-DETL-RECS-BC     PIC 9(3)      VALUE ZERO.        
               10  BATCH-NUMBER-BC     PIC 9(4)      VALUE ZERO.        
               10  BATCH-AMOUNT-BC     PIC 9(11)V99  VALUE ZERO.        
           05  NUMBER-BATCHES          PIC 9(3)      VALUE ZERO.        
                                                                        
       01  BAT-ERROR-CNTR.                                              
           05  ERR-BATCH-NO  OCCURS 998 TIMES                           
                                       PIC 9(4)      VALUE ZERO.        
                                                                        
C34844*    IF CODE_VALUE IS CHANGED IN THE CSS_DUMMYTABLE                       
C34844*     WS-DETAILED-DATA OCCURENCE SHOULD BE CHANGED.                       
C34844 01  WS-DETAIL-LINE.                                              
C34844     05  WS-DETAIL-DATA  OCCURS 1 TO 100 TIMES DEPENDING ON       
C34844             ACCOUNTNO-COUNT PIC X(131)      VALUE SPACES.        
                                                                        
       01  BAT-SUMMARY-TABLE.                                           
           05  BATCH-SUM-TBL  OCCURS 998 TIMES.                         
               10  BAT-TBL-RECORD-TYPE PIC 9.                           
               10  BAT-TBL-OUT-SEQ-NUM PIC 9(6).                        
               10  BAT-TBL-DATE.                                        
                   15  BAT-TBL-DATE-MO PIC 9(2).                        
                   15  BAT-TBL-DATE-DA PIC 9(2).                        
                   15  BAT-TBL-DATE-YR PIC 9(2).                        
               10  BAT-TBL-BAT-NUM-AREA.                                
                   15  BAT-TBL-BATCH-TYPE  PIC 9.                       
                   15  BAT-TBL-BATCH-NBR   PIC 9(3).                    
               10  BAT-TBL-BATCH-NUMBER REDEFINES BAT-TBL-BAT-NUM-AREA  
                                       PIC 9(04).                       
               10  BAT-TBL-NUM-DOCS    PIC 9(3).                        
               10  BAT-TBL-AMOUNT-TOT  PIC 9(9)V99.                     
               10  BAT-TBL-CHK-AMT-TOT PIC 9(9)V99.                     
               10  BAT-TBL-BANK-NO     PIC 9(5).                        
               10  BAT-TBL-AGENT-ID    PIC X(6).                        
               10  FILLER              PIC X(27).                       
                                                                        
       01  ERROR-MESSAGES.                                              
           05  ERROR-MESSAGE-1.                                         
               10  FILLER              PIC X(6)      VALUE 'BATCH '.    
               10  PRT-ERR-BATCH-NO    PIC 9(4).                        
               10  FILLER              PIC X(43)     VALUE              
                        ' IS DUPLICATE OF BATCH ALREADY TRANSMITTED!'.  
           05  ERROR-MESSAGE-1A        PIC X(52)     VALUE              
               'PLEASE NOTIFY CASH MGMT & EDI TEAM IMMEDIATELY!'.       
           05  ERROR-MESSAGE-2         PIC X(52)     VALUE              
               'BATCH RECORD TYPE IS NOT NUMERIC                    '.  
           05  ERROR-MESSAGE-3         PIC X(52)     VALUE              
               'BATCH TOTAL AMOUNT DOES NOT MATCH SUM OF DETAIL AMTS'.  
           05  ERROR-MESSAGE-4         PIC X(52)     VALUE              
               'BATCH NUMBER RECS DOES NOT EQUAL NUMBER RECORDS READ'.  
           05  DET-ERROR-MSG-1         PIC X(52)     VALUE              
               'DETAIL-REC OUT SEQUENCE NUMBER IS NOT NUMERIC       '.  
           05  DET-ERROR-MSG-2         PIC X(52)     VALUE              
               'DETAIL-REC DATE ERROR - MONTH IS NOT NUMERIC        '.  
           05  DET-ERROR-MSG-3         PIC X(52)     VALUE              
               'DETAIL-REC DATE ERROR - DAY IS NOT NUMERIC          '.  
           05  DET-ERROR-MSG-4         PIC X(52)     VALUE              
               'DETAIL-REC DATE ERROR - YEAR IS NOT NUMERIC         '.  
           05  DET-ERROR-MSG-5         PIC X(52)     VALUE              
               'DETAIL-REC BATCH TYPE IS NOT NUMERIC                '.  
           05  DET-ERROR-MSG-6         PIC X(52)     VALUE              
               'DETAIL-REC TERMINAL ID IS NOT NUMERIC               '.  
           05  DET-ERROR-MSG-7         PIC X(52)     VALUE              
               'DETAIL-REC BATCH NUMBER IS NOT NUMERIC              '.  
           05  DET-ERROR-MSG-8         PIC X(52)     VALUE              
               'DETAIL-REC SEQUENCE NUMBER IS NOT NUMERIC           '.  
           05  DET-ERROR-MSG-9         PIC X(52)     VALUE              
               'DETAIL-REC ACCOUNT NUMBER IS NOT NUMERIC            '.  
           05  DET-ERROR-MSG-10        PIC X(52)     VALUE              
               'DETAIL-REC BATCH AMOUNT IS NOT NUMERIC              '.  
           05  DET-ERROR-MSG-11        PIC X(52)     VALUE              
               'DETAIL-REC DATE ERROR - BILL MONTH IS NOT NUMERIC   '.  
           05  DET-ERROR-MSG-12        PIC X(52)     VALUE              
               'DETAIL-REC DATE ERROR - BILL YEAR IS NOT NUMERIC    '.  
           05  DET-ERROR-MSG-13        PIC X(52)     VALUE              
               'DETAIL-REC ACCT ERROR - ACCT NO. IS ALL ZEROES      '.  
           05  DET-ERROR-MSG-14        PIC X(52)     VALUE              
               'DETAIL-REC PAYMENT AMOUNT IS ALL ZEROES             '.  
           05  DET-ERROR-MSG-15        PIC X(52)     VALUE              
               'A BATCH RECORD WAS NOT FOUND FOR THE PREVIOUS BATCH '.  
           05  DET-ERROR-MSG-16        PIC X(52)     VALUE              
               'A BATCH RECORD WAS NOT FOUND FOR THIS BATCH         '.  
           05  DET-ERROR-MSG-17.                                        
               10  FILLER              PIC X(35)     VALUE              
               'DATE ON THIS REC <> BUSINESS DATE: '.                   
               10  WS-BUSINESS-DATE.                                    
                   15  WS-BUSINESS-MM          PIC 9(2).                
                   15  WS-BUSINESS-DD          PIC 9(2).                
                   15  WS-BUSINESS-YY          PIC 9(2).                
               10  FILLER              PIC X(11)     VALUE SPACES.      
                                                                        
           05  NOT-ERROR-MSG-1         PIC X(52)     VALUE              
               'NOTICE-REC OUT SEQUENCE NUMBER IS NOT NUMERIC       '.  
           05  NOT-ERROR-MSG-2         PIC X(52)     VALUE              
               'NOTICE-REC DATE ERROR - MONTH IS NOT NUMERIC        '.  
           05  NOT-ERROR-MSG-3         PIC X(52)     VALUE              
               'NOTICE-REC DATE ERROR - DAY IS NOT NUMERIC          '.  
           05  NOT-ERROR-MSG-4         PIC X(52)     VALUE              
               'NOTICE-REC DATE ERROR - YEAR IS NOT NUMERIC         '.  
           05  NOT-ERROR-MSG-5         PIC X(52)     VALUE              
               'NOTICE-REC BATCH AMOUNT IS NOT NUMERIC              '.  
           05  TOT-ERROR-MSG-1         PIC X(52)     VALUE              
               'TOTAL-REC OUT SEQUENCE NUMBER IS NOT NUMERIC        '.  
           05  TOT-ERROR-MSG-2         PIC X(52)     VALUE              
               'TOTAL-REC DATE ERROR - MONTH IS NOT NUMERIC         '.  
           05  TOT-ERROR-MSG-3         PIC X(52)     VALUE              
               'TOTAL-REC DATE ERROR - DAY IS NOT NUMERIC           '.  
           05  TOT-ERROR-MSG-4         PIC X(52)     VALUE              
               'TOTAL-REC DATE ERROR - YEAR IS NOT NUMERIC          '.  
           05  TOT-ERROR-MSG-5         PIC X(52)     VALUE              
               'TOTAL-REC BATCH TYPE IS NOT NUMERIC                 '.  
           05  TOT-ERROR-MSG-6         PIC X(52)     VALUE              
               'TOTAL-REC TERMINAL ID IS NOT NUMERIC                '.  
           05  TOT-ERROR-MSG-7         PIC X(52)     VALUE              
               'TOTAL-REC BATCH NUMBER IS NOT NUMERIC               '.  
           05  TOT-ERROR-MSG-8         PIC X(52)     VALUE              
               'TOTAL-REC TOTAL NUMBER DOCUMENTS IS NOT NUMERIC     '.  
           05  TOT-ERROR-MSG-9         PIC X(52)     VALUE              
               'TOTAL-REC DOCUMENT TOTAL IS NOT NUMERIC (AMT)       '.  
           05  TOT-ERROR-MSG-10        PIC X(52)     VALUE              
               'TOTAL-REC CHECK TOTAL IS NOT NUMERIC (AMT)          '.  
           05  TOT-ERROR-MSG-11        PIC X(52)     VALUE              
               'TOTAL-REC BANK NUMBER IS NOT NUMERIC                '.  
           05  TOT-ERROR-MSG-12        PIC X(52)     VALUE              
               'TOTAL-REC: TWO CONSECUTIVE DUPLICATE BATCH RECORDS  '.  
                                                                        
       01  HEAD-01.                                                     
           05  FILLER                  PIC X(01)      VALUE SPACES.     
           05  FILLER                  PIC X(08)      VALUE 'PCSAC185'. 
           05  FILLER                  PIC X(40)     VALUE SPACES.      
C34844*    05  FILLER                  PIC X(37)     VALUE                      
C34844*                        'SOUTH CAROLINA ELECTRIC & GAS COMPANY'.         
C34844     05  WS-COMP-NAME            PIC X(37)     VALUE SPACES.      
           05  FILLER                  PIC X(30)     VALUE SPACES.      
           05  FILLER                  PIC X(6)      VALUE 'DATE: '.    
           05  PRT-DATE                PIC X(8)      VALUE SPACES.      
           05  FILLER                  PIC X(2)      VALUE SPACES.      
       01  HEAD-02.                                                     
           05  FILLER                  PIC X(55)     VALUE SPACES.      
           05  DES-H02                 PIC X(23)     VALUE              
                                                   'BATCH ERRORS'.      
           05  FILLER                  PIC X(38)     VALUE SPACES.      
           05  FILLER                  PIC X(6)      VALUE 'TIME: '.    
           05  PRT-HR                  PIC X(2).                        
           05  FILLER                  PIC X         VALUE ':'.         
           05  PRT-MIN                 PIC X(2).                        
           05  FILLER                  PIC X         VALUE ':'.         
           05  PRT-SEC                 PIC X(2).                        
           05  FILLER                  PIC X(2)      VALUE SPACES.      
       01  HEAD-03.                                                     
           05  FILLER                  PIC X(116)    VALUE SPACES.      
           05  FILLER                  PIC X(6)      VALUE 'PAGE: '.    
           05  PRT-PAGE-NO             PIC ZZZZZZZ9.                    
           05  FILLER                  PIC X(2)      VALUE SPACES.      
       01  HEAD-04.                                                     
           05  FILLER                  PIC X(5)      VALUE SPACES.      
           05  FILLER                  PIC X(8)      VALUE 'BATCH-NO'.  
           05  FILLER                  PIC X(6)      VALUE SPACES.      
           05  FILLER                  PIC X(11)     VALUE              
                                                    'SEQ/NO RECS'.      
           05  FILLER                  PIC X(3)      VALUE SPACES.      
           05  FILLER                  PIC X(10)     VALUE 'PMT AMOUNT'.
           05  FILLER                  PIC X(10)     VALUE SPACES.      
           05  FILLER                  PIC X(17)     VALUE              
                                                    'ERROR DESCRIPTION'.
           05  FILLER                  PIC X(62)     VALUE SPACES.      
                                                                        
       01  DETAIL-LINE.                                                 
           05  FILLER                  PIC X(4)      VALUE SPACES.      
           05  PRT-BATCH-NO            PIC 9(4).                        
           05  FILLER                  PIC X(11)     VALUE SPACES.      
           05  PRT-SEQ-RECS            PIC ZZ9.                         
           05  FILLER                  PIC X(11)     VALUE SPACES.      
           05  FILLER                  PIC X         VALUE '$'.         
           05  PRT-PMT-AMOUNT          PIC ZZ,ZZZ,ZZZ,ZZ9.99.           
           05  FILLER                  PIC X(1)      VALUE SPACES.      
           05  PRT-DET-ERROR                         VALUE SPACES.      
               10  PRT-ACCT-LIT        PIC X(7).                        
               10  PRT-ACCT-NO         PIC X(13).                       
               10  FILLER              PIC X(3).                        
               10  PRT-DET-MSG         PIC X(52).                       
               10  FILLER              PIC X(4).                        
           05  PRT-NOT-BATCH  REDEFINES  PRT-DET-ERROR.                 
               10  PRT-NOT-BAT-MSG     PIC X(52).                       
               10  PRINT-EX-1.                                          
                   15  FILLER          PIC X.                           
                   15  PRT-X1-A        PIC Z,ZZZ,ZZ9.99.                
                   15  FILLER          PIC X.                           
                   15  PRT-X1-B        PIC Z,ZZZ,ZZ9.99.                
                   15  FILLER          PIC X.                           
               10  PRINT-EX-2  REDEFINES  PRINT-EX-1.                   
                   15  FILLER          PIC X(7).                        
                   15  PRT-X2-A        PIC ZZ9.                         
                   15  FILLER          PIC X(7).                        
                   15  PRT-X2-B        PIC ZZ9.                         
                   15  FILLER          PIC X(7).                        
               10  PRINT-EX-3  REDEFINES  PRINT-EX-1.                   
                   15  PRT-BATCH-NUM   PIC 9(04).                       
                   15  FILLER          PIC X(23).                       
                                                                        
       01  TOTAL-LINE-1.                                                
           05  FILLER                  PIC X(40)     VALUE SPACES.      
           05  FILLER                  PIC X(38)     VALUE              
                              'NUMBER OF DETAIL RECORD ERRORS FOUND: '. 
           05  PRT-DET-ERRORS          PIC ZZ9.                         
           05  FILLER                  PIC X(51)     VALUE SPACES.      
       01  TOTAL-LINE-2.                                                
           05  FILLER                  PIC X(40)     VALUE SPACES.      
           05  FILLER                  PIC X(38)     VALUE              
                              'NUMBER OF NOTICE RECORD ERRORS FOUND: '. 
           05  PRT-NOT-ERRORS          PIC ZZ9.                         
           05  FILLER                  PIC X(51)     VALUE SPACES.      
       01  TOTAL-LINE-3.                                                
           05  FILLER                  PIC X(40)     VALUE SPACES.      
           05  FILLER                  PIC X(38)     VALUE              
                              'NUMBER OF TOTALS RECORD ERRORS FOUND: '. 
           05  PRT-BAT-ERRORS          PIC ZZ9.                         
           05  FILLER                  PIC X(51)     VALUE SPACES.      
       01  TOTAL-LINE-4.                                                
           05  FILLER                  PIC X(40)     VALUE SPACES.      
           05  FILLER                  PIC X(38)     VALUE              
                              'TOTAL NUMBER ERRORS FROM ALL RECORDS: '. 
           05  PRT-TOT-ERRORS          PIC ZZ9.                         
           05  FILLER                  PIC X(51)     VALUE SPACES.      
                                                                        
       01  WRITE-ERROR-LINE.                                            
           05  FILLER                  PIC X(40)     VALUE SPACES.      
           05  PRT-ERROR-MSG           PIC X(53).                       
           05  FILLER                  PIC X(39)     VALUE SPACES.      
                                                                        
       01  DISPLAY-ERROR-LINE.                                          
           05  FILLER                  PIC X(8)      VALUE 'BATCH # '.  
           05  DISP-BATCH-NO           PIC 9(4).                        
           05  FILLER                  PIC X(23)     VALUE              
                                            ' - NUMBER OF RECORDS = '.  
           05  DISP-NUM-RECS           PIC ZZ9.                         
           05  FILLER                  PIC X(18)     VALUE              
                                                 ' - TOTAL AMOUNT = '.  
           05  DISP-AMOUNT             PIC ZZ,ZZZ,ZZZ,ZZ9.99.           
                                                                        
       01  REPORT-LINE-NO              PIC 9(2)    VALUE ZERO.          
       01  REPORT-PAGE-NO              PIC 9(2)    VALUE ZERO.          
       01  DASH-LINE                   PIC X(132)  VALUE ALL '-'.       
       01  BLANK-LINE                  PIC X(132)  VALUE SPACES.        
                                                                        
       01  NO-DATA-LINE.                                                
           05  FILLER                  PIC X(52)   VALUE SPACES.        
           05  FILLER                  PIC X(27)   VALUE                
                  '** NO BATCH ERRORS FOUND **'.                        
           05  FILLER                  PIC X(53)   VALUE SPACES.        
                                                                        
       01  END-DATA-LINE.                                               
           05  FILLER                  PIC X(55)   VALUE SPACES.        
           05  FILLER                  PIC X(22)   VALUE                
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)   VALUE SPACES.        
                                                                        
       01  FILLER                      PIC X(45)     VALUE              
           ' *** PCSAC185 WORKING STORAGE ENDS HERE *** '.              
                                                                        
      *INCLUDE SQL COMMUNICATION AREA                                           
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      * UV - CSS_CODE_VALUE                                                     
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCDVALU                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_JOB_PARM                                                    05370000
                                                                        
C34844     EXEC SQL                                                     05390000
C34844        INCLUDE TBJBPARM                                          05400000
C34844     END-EXEC.                                                    05410000
                                                                        
      * CSS_COMPANY                                                     05370000
                                                                        
C34844     EXEC SQL                                                     05390000
C34844        INCLUDE TBCOMPNY                                          05400000
C34844     END-EXEC.                                                    05410000
                                                                        
       COPY CWS00303.                                                           
C34844 COPY CWS00038.                                                           
C34844 COPY FIOJC01.                                                            
C34844 COPY CWS00010.                                                           
C34844 COPY CWS09900.                                                           
                                                                        
       PROCEDURE DIVISION.                                              
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  PROCEDURE P0000-MAIN                                         *         
      *                                                               *         
      *  THIS PROCEDURE CONTROLS THE MAIN PROCESSING OF PROGRAM.      *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P0000-MAIN.                                                      
           PERFORM P0100-INITIATE-PROCESS THRU P0100-EXIT.              
           PERFORM P1000-PROCESS-BATCHES THRU P1000-EXIT                
              UNTIL END-OF-BANKTRAN-FILE.                               
                                                                        
           IF WS-CUR-DET-REC-9 = WS-PREV-BATCH-REC-9                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE DET-ERROR-MSG-16      TO PRT-DET-MSG                 
              PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT                
              ADD 1 TO DET-ERRORS-FOUND                                 
           END-IF                                                       
                                                                        
      *** IF THE TABLE-SUB IS GREATER THAN ZERO AND NO ERRORS ARE FOUND         
      *** THEN THE RECORDS IN THE WORKING STORAGE TABLE CAN BE WRITTEN          
      *** TO A NEW GENERATION OF THE BATCH SUMMARY FILE; OTHERWISE NO           
      *** NEW FILE WILL BE WRITTEN, SO CORRECTIONS CAN BE MADE.                 
           IF DET-ERRORS-FOUND EQUAL ZERO AND                           
              NOT-ERRORS-FOUND EQUAL ZERO AND                           
              BAT-ERRORS-FOUND EQUAL ZERO AND                           
              MAX-PRINT-ERRORS EQUAL ZERO AND                           
              DUPLICATE-COUNT  EQUAL ZERO                               
               IF TABLE-SUB IS GREATER THAN ZERO                        
                   OPEN OUTPUT BATCHOUT                                 
                   MOVE 1 TO WRITE-SUB                                  
                   PERFORM P7000-WRITE-SUMMARY THRU P7000-EXIT          
                      UNTIL WRITE-SUB IS GREATER THAN TABLE-SUB         
                   CLOSE BATCHOUT                                       
               END-IF                                                   
               WRITE PRT-1-RECORD FROM NO-DATA-LINE                     
                  AFTER ADVANCING 3 LINES                               
               WRITE PRT-1-RECORD FROM END-DATA-LINE                    
                  AFTER ADVANCING 3 LINES                               
           ELSE                                                         
               IF DUPLICATE-COUNT IS GREATER THAN ZERO                  
                   MOVE WS-Y TO BATCH-DUPLICATE                         
               END-IF                                                   
               IF DET-ERRORS-FOUND GREATER THAN ZERO                    
                   MOVE DET-ERRORS-FOUND TO PRT-DET-ERRORS              
                   MOVE WS-Y TO NUMERIC-ERROR                           
                   WRITE PRT-1-RECORD FROM TOTAL-LINE-1                 
                      AFTER ADVANCING 3 LINES                           
               END-IF                                                   
               IF NOT-ERRORS-FOUND GREATER THAN ZERO                    
                   MOVE NOT-ERRORS-FOUND TO PRT-NOT-ERRORS              
                   MOVE WS-Y TO NUMERIC-ERROR                           
                   IF DET-ERRORS-FOUND EQUAL ZERO                       
                       WRITE PRT-1-RECORD FROM TOTAL-LINE-2             
                          AFTER ADVANCING 3 LINES                       
                   ELSE                                                 
                       WRITE PRT-1-RECORD FROM TOTAL-LINE-2             
                          AFTER ADVANCING 1 LINE                        
                   END-IF                                               
               END-IF                                                   
               IF BAT-ERRORS-FOUND GREATER THAN ZERO                    
                   MOVE BAT-ERRORS-FOUND TO PRT-BAT-ERRORS              
                   MOVE WS-Y TO NUMERIC-ERROR                           
                   IF DET-ERRORS-FOUND EQUAL ZERO AND                   
                      NOT-ERRORS-FOUND EQUAL ZERO                       
                       WRITE PRT-1-RECORD FROM TOTAL-LINE-3             
                          AFTER ADVANCING 3 LINES                       
                   ELSE                                                 
                       WRITE PRT-1-RECORD FROM TOTAL-LINE-3             
                          AFTER ADVANCING 1 LINE                        
                   END-IF                                               
               END-IF                                                   
               COMPUTE TOT-ERRORS-FOUND = DET-ERRORS-FOUND +            
                       NOT-ERRORS-FOUND + BAT-ERRORS-FOUND              
               IF TOT-ERRORS-FOUND IS GREATER THAN ZERO                 
                   MOVE TOT-ERRORS-FOUND TO PRT-TOT-ERRORS              
                   WRITE PRT-1-RECORD FROM TOTAL-LINE-4                 
                      AFTER ADVANCING 1 LINE                            
               END-IF                                                   
               IF MAX-PRINT-ERRORS IS GREATER THAN ZERO                 
                   MOVE 1 TO ERROR-SUB                                  
                   PERFORM MAX-PRINT-ERRORS TIMES                       
                       MOVE ERR-BATCH-NO (ERROR-SUB)                    
                                         TO PRT-ERR-BATCH-NO            
                       MOVE ERROR-MESSAGE-1 TO PRT-ERROR-MSG            
                       IF ERROR-SUB EQUAL 1                             
                           WRITE PRT-1-RECORD FROM WRITE-ERROR-LINE     
                              AFTER ADVANCING 3 LINES                   
                       ELSE                                             
                           WRITE PRT-1-RECORD FROM WRITE-ERROR-LINE     
                              AFTER ADVANCING 1 LINE                    
                       END-IF                                           
                       ADD 1 TO ERROR-SUB                               
                   END-PERFORM                                          
                   MOVE ERROR-MESSAGE-1A TO PRT-ERROR-MSG               
                   WRITE PRT-1-RECORD FROM WRITE-ERROR-LINE             
                      AFTER ADVANCING 1 LINE                            
               END-IF                                                   
               WRITE PRT-1-RECORD FROM END-DATA-LINE                    
                  AFTER ADVANCING 3 LINES                               
               MOVE +9 TO EOJ-CODE                                      
           END-IF.                                                      
                                                                        
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
       P0000-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  PROCEDURE P0100-INITIATE-PROCESS.                            *         
      *       CALLED BY: P0000-MAIN                                   *         
      *                                                               *         
      *  THIS PROCEDURE OPENS THE FILES, ACCEPTS SYSTEM DATE & TIME,  *         
      *  PRINTS HEADERS FOR THE REPORT, PERFORMS INITIALIZATION OF    *         
      *  WORKING STORAGE TABLE & PERFORMS THE LOAD OF THE TABLE FROM  *         
      *  THE BATCHIN FILE, THEN READS THE 1ST RECORD FROM BANKTRAN.   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P0100-INITIATE-PROCESS.                                          
                                                                        
           OPEN INPUT  BANKTRAN                                         
           OPEN INPUT  BATCHIN                                          
           OPEN OUTPUT PRINTER1.                                        
                                                                        
           ACCEPT CURRENT-DATE FROM DATE.                               
           MOVE WS-CM TO RUN-MM.                                        
           MOVE WS-CD TO RUN-DD.                                        
           MOVE WS-CY TO RUN-YY.                                        
                                                                        
           ACCEPT RUN-TIME FROM TIME.                                   
           MOVE RUN-HOUR TO PRT-HR.                                     
           MOVE RUN-MINU TO PRT-MIN.                                    
           MOVE RUN-SECO TO PRT-SEC.                                    
           MOVE RUN-DATE1 TO PRT-DATE.                                  
                                                                        
C34844     PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
                                                                        
C34844     IF COMMON-DATE-NEEDED                                        
C34844       MOVE 'COMMON  ' TO WS-PGRMNAME                             
C34844       MOVE SPACES     TO WS-INPUT-AREA                           
C34844       MOVE SPACES     TO WS-INPUT-DATA-BREAKDOWN                 
C34844       PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                 
C34844       MOVE 'PCSAC185' TO WS-PGRMNAME                             
C34844     END-IF                                                       
C34844     MOVE WS-INPUT-DATE(3:2) TO WS-BUSINESS-YY                    
C34844     MOVE WS-INPUT-DATE(6:2) TO WS-BUSINESS-MM                    
C34844     MOVE WS-INPUT-DATE(9:2) TO WS-BUSINESS-DD                    
                                                                        
C34844     PERFORM 7510-SELECT-COMPANY THRU 7510-EXIT                   
C34844       MOVE  C7-COMPANY-NAME        TO  WS-COMP-NAME              
           PERFORM P0500-INITIALIZE-TABLE THRU P0500-EXIT.              
           PERFORM P0750-LOAD-SUMMARY-TBL THRU P0750-EXIT.              
           PERFORM P8000-REPORT-HEADINGS  THRU P8000-EXIT.              
           PERFORM P5000-READ-BANKTRAN-FL THRU P5000-EXIT.              
                                                                        
       P0100-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  PROCEDURE P0500-INITIALIZE-TABLE                             *         
      *       CALLED BY: P0100-INITIATE-PROCESS                       *         
      *                                                               *         
      *  THIS PROCEDURE INITIALIZES W-S TABLE OF SUMMARY RECORDS.     *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P0500-INITIALIZE-TABLE.                                          
                                                                        
           MOVE 1 TO BATCH-SUB.                                         
           PERFORM UNTIL BATCH-SUB IS GREATER THAN WS-MAX-SUB           
               MOVE ZEROES TO BAT-TBL-RECORD-TYPE (BATCH-SUB),          
                              BAT-TBL-OUT-SEQ-NUM (BATCH-SUB),          
                              BAT-TBL-DATE        (BATCH-SUB),          
                              BAT-TBL-BATCH-TYPE  (BATCH-SUB),          
                              BAT-TBL-BATCH-NBR   (BATCH-SUB),          
                              BAT-TBL-NUM-DOCS    (BATCH-SUB),          
                              BAT-TBL-AMOUNT-TOT  (BATCH-SUB),          
                              BAT-TBL-CHK-AMT-TOT (BATCH-SUB),          
                              BAT-TBL-BANK-NO     (BATCH-SUB)           
               MOVE SPACES TO BAT-TBL-AGENT-ID    (BATCH-SUB)           
               ADD 1 TO BATCH-SUB                                       
           END-PERFORM.                                                 
C34844     PERFORM 7000-SELECT-ACCT-CNT THRU 7000-EXIT.                 
       P0500-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  PROCEDURE P0750-LOAD-SUMMARY-TBL                             *         
      *       CALLED BY: P0100-INITIATE-PROCESS                       *         
      *                                                               *         
      *  THIS PROCEDURE LOADS SUMMARY RECORDS FROM BATCHIN FILE INTO *          
      *  A WORKING STORAGE TABLE SO THAT EACH RECORD FROM THE BATCH   *         
      *  TRANSACTION FILE CAN BE CHECKED AGAINST IT FOR DUPLICATES.   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P0750-LOAD-SUMMARY-TBL.                                          
                                                                        
           MOVE 1 TO BATCH-SUB.                                         
           MOVE 0 TO TABLE-SUB.                                         
           MOVE WS-N TO EOF-BATCHIN.                                    
           PERFORM                                                      
              UNTIL BATCH-SUB IS GREATER THAN WS-MAX-SUB                
                 OR END-OF-BATCHIN-FILE                                 
               READ BATCHIN                                             
                   AT END                                               
                       MOVE WS-Y TO EOF-BATCHIN                         
               END-READ                                                 
               IF NOT-END-OF-BATCHIN                                    
                   MOVE BATCH-SUM-REC-TYPE-IN  TO                       
                        BAT-TBL-RECORD-TYPE (BATCH-SUB)                 
                   MOVE BATCH-SUM-OSEQ-NO-IN   TO                       
                        BAT-TBL-OUT-SEQ-NUM (BATCH-SUB)                 
                   MOVE BATCH-SUM-DATE-IN      TO                       
                        BAT-TBL-DATE        (BATCH-SUB)                 
                   MOVE BATCH-SUM-TYPE-IN      TO                       
                        BAT-TBL-BATCH-TYPE  (BATCH-SUB)                 
                   MOVE BATCH-SUM-BATCH-NO-IN  TO                       
                        BAT-TBL-BATCH-NBR   (BATCH-SUB)                 
                   MOVE BATCH-SUM-NO-DOCS-IN   TO                       
                        BAT-TBL-NUM-DOCS    (BATCH-SUB)                 
                   MOVE BATCH-SUM-AMT-TOT-IN   TO                       
                        BAT-TBL-AMOUNT-TOT  (BATCH-SUB)                 
                   MOVE BATCH-SUM-CHEK-AMT-IN  TO                       
                        BAT-TBL-CHK-AMT-TOT (BATCH-SUB)                 
                   MOVE BATCH-SUM-BANK-NO-IN   TO                       
                        BAT-TBL-BANK-NO     (BATCH-SUB)                 
                   MOVE BATCH-SUM-AGENT-ID-IN  TO                       
                        BAT-TBL-AGENT-ID    (BATCH-SUB)                 
                   MOVE BATCH-SUB TO TABLE-SUB                          
                   ADD 1 TO BATCH-SUB                                   
                   ADD 1 TO PREV-BATCH-REC-CNT                          
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
       P0750-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  PROCEDURE P1000-PROCESS-RECORDS                              *         
      *       CALLED BY: P0000-MAIN                                   *         
      *                                                               *         
      *  THIS PROCEDURE CHECKS RECORD TYPE, THEN PERFORMS EDIT ROU-   *         
      *  TINE ACCORDING TO TYPE AND READS NEXT TRANSACTION RECORD.    *         
      *  IT ALSO KEEPS COUNT OF NUMBER OF RECORDS FOR COMPARISON.     *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P1000-PROCESS-BATCHES.                                           
      ***  DETAIL-RECORD-TYPE '1' - DETAIL RECORDS                              
      ***  DETAIL-RECORD-TYPE '2' - NOTICE RECORDS                              
      ***  DETAIL-RECORD-TYPE '3' - BATCH RECORDS                               
                                                                        
           IF END-OF-BANKTRAN-FILE                                      
               GO TO P1000-EXIT                                         
           END-IF.                                                      
                                                                        
           EVALUATE DETAIL-RECORD-TYPE                                  
               WHEN 1                                                   
                   PERFORM P2000-PROCESS-DETAIL THRU P2000-EXIT         
                   ADD 1 TO NUM-DETAIL-RECS                             
               WHEN 2                                                   
                   PERFORM P3000-PROCESS-NOTICE THRU P3000-EXIT         
               WHEN 3                                                   
                   PERFORM P4000-PROCESS-TOTALS THRU P4000-EXIT         
                   ADD 1 TO NUM-TOTALS-RECS                             
               WHEN OTHER                                               
                   DISPLAY '** INVALID RECORD TYPE - CAN NOT PROCESS **'
                   DISPLAY '** RECORD TYPE = ' DETAIL-RECORD-TYPE       
                           ' - PROGRAM TERMINATING **'                  
                   MOVE +9 TO EOJ-CODE                                  
                   PERFORM 9000-TERMINATE THRU 9000-EXIT                
           END-EVALUATE.                                                
                                                                        
           PERFORM P5000-READ-BANKTRAN-FL THRU P5000-EXIT.              
                                                                        
       P1000-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  PROCEDURE P2000-PROCESS-DETAIL                               *         
      *       CALLED BY: P1000-PROCESS-RECORDS                        *         
      *                                                               *         
      *  THIS PROCEDURE EDITS NUMERIC DETAIL RECORD FIELDS AND WRITES *         
      *  ERROR MESSAGES TO ERROR PRINT REPORT; ALSO ADDS AMOUNTS FROM *         
      *  DETAIL RECORDS TO COMPARE WITH TOTAL AMOUNT FROM TOTAL REC-  *         
      *  ORD AND KEEPS A COUNT OF THE NUMBER OF ERRORS.               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P2000-PROCESS-DETAIL.                                            
      ***  DETAIL-RECORD-TYPE '1' - DETAIL RECORDS                              
                                                                        
           MOVE SPACES              TO PRT-DET-ERROR.                   
           MOVE DETAIL-BAT-NUMBER   TO PRT-BATCH-NO.                    
           MOVE DETAIL-OUT-SEQ-NUM  TO PRT-SEQ-RECS.                    
           MOVE DETAIL-PAY-AMOUNT   TO PRT-PMT-AMOUNT.                  
           MOVE 'ACCT # ' TO PRT-ACCT-LIT.                              
           MOVE DETAIL-ACCOUNT-NO-9 TO PRT-ACCT-NO.                     
                                                                        
           IF DETAIL-RECORD-TYPE IS NUMERIC                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE ERROR-MESSAGE-2 TO PRT-DET-MSG                      
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF DETAIL-OUT-SEQ-NUM IS NUMERIC                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-1 TO PRT-DET-MSG                      
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF DETAIL-DATE-MO IS NUMERIC                                 
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-2 TO PRT-DET-MSG                      
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF DETAIL-DATE-DA IS NUMERIC                                 
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-3 TO PRT-DET-MSG                      
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF DETAIL-DATE-YR IS NUMERIC                                 
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-4 TO PRT-DET-MSG                      
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF DETAIL-BATCH-TYPE IS NUMERIC                              
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-5 TO PRT-DET-MSG                      
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF DETAIL-BATCH-NUMBER IS NUMERIC                            
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-7 TO PRT-DET-MSG                      
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           MOVE DETAIL-BATCH-TYPE   TO WS-CUR-DET-TYPE                  
           MOVE DETAIL-BATCH-NUMBER TO WS-CUR-DET-NUM                   
           EVALUATE TRUE                                                
              WHEN WS-PREV-DET-REC-9 = ZEROES                           
                 MOVE WS-CUR-DET-REC-9   TO WS-PREV-DET-REC-9           
                                                                        
              WHEN WS-PREV-DET-REC-9 NOT = WS-CUR-DET-REC-9             
                 IF WS-PREV-DET-REC-9 = WS-PREV-BATCH-REC-9             
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE DET-ERROR-MSG-15 TO PRT-DET-MSG                
                    PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT          
                    ADD 1 TO DET-ERRORS-FOUND                           
                    MOVE ZERO TO NUM-DETAIL-RECS                        
                    MOVE ZERO TO BATCH-TOT-AMOUNT                       
                 END-IF                                                 
                 MOVE WS-CUR-DET-REC-9   TO WS-PREV-DET-REC-9           
           END-EVALUATE                                                 
                                                                        
           IF DETAIL-SEQUENCE-NO IS NUMERIC                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-8 TO PRT-DET-MSG                      
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF DETAIL-ACCOUNT-NO-9 IS NUMERIC                            
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-9 TO PRT-DET-MSG                      
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
C34844     IF DETAIL-ACCOUNT-NO-9 EQUAL ZEROES                          
C34844              AND DETAIL-RECORD-TYPE = 1                          
C34844        ADD 1 TO WS-ACCT-COUNT                                    
C34844        IF WS-ACCT-COUNT >= ACCOUNTNO-COUNT                       
C34844           IF WS-PRINTED = 'N'                                    
C34844              MOVE DET-ERROR-MSG-13      TO PRT-DET-MSG           
C34844              MOVE DETAIL-LINE           TO                       
C34844                                  WS-DETAIL-DATA(WS-ACCT-COUNT)   
C34844              PERFORM VARYING WS-COUNT FROM 1 BY 1 UNTIL          
C34844                              WS-COUNT > ACCOUNTNO-COUNT          
C34844                MOVE  WS-DETAIL-DATA (WS-COUNT)                   
C34844                                           TO DETAIL-LINE         
C34844                PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT        
C34844                ADD 1                      TO DET-ERRORS-FOUND    
C34844              END-PERFORM                                         
C34844              MOVE 'Y'                TO WS-PRINTED               
C34844           ELSE                                                   
C34844              MOVE DET-ERROR-MSG-13      TO PRT-DET-MSG           
C34844              PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT          
C34844              ADD 1                      TO DET-ERRORS-FOUND      
C34844           END-IF                                                 
C34844        ELSE                                                      
C34844           MOVE DET-ERROR-MSG-13      TO PRT-DET-MSG              
C34844           MOVE DETAIL-LINE           TO                          
C34844                                  WS-DETAIL-DATA(WS-ACCT-COUNT)   
C34844         END-IF                                                   
C34844      END-IF.                                                     
                                                                        
           IF DETAIL-PAY-AMOUNT IS NUMERIC                              
               ADD DETAIL-PAY-AMOUNT TO BATCH-TOT-AMOUNT                
           ELSE                                                         
               MOVE DET-ERROR-MSG-10 TO PRT-DET-MSG                     
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF DETAIL-PAY-AMOUNT NOT EQUAL ZEROES                        
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-14 TO PRT-DET-MSG                     
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF DETAIL-DT-BILL-MO IS NUMERIC                              
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-11 TO PRT-DET-MSG                     
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF DETAIL-DT-BILL-YR IS NUMERIC                              
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-12 TO PRT-DET-MSG                     
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF DETAIL-DATE = WS-BUSINESS-DATE                            
               CONTINUE                                                 
           ELSE                                                         
               MOVE DET-ERROR-MSG-17 TO PRT-DET-MSG                     
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO DET-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
       P2000-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  PROCEDURE P3000-PROCESS-NOTICE                               *         
      *       CALLED BY: P1000-PROCESS-RECORDS                        *         
      *                                                               *         
      *  THIS PROCEDURE EDITS NUMERIC NOTICE RECORD FIELDS, WRITES    *         
      *  ERROR MESSAGES TO ERROR REPORT, AND KEEPS COUNT OF ERRORS.   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P3000-PROCESS-NOTICE.                                            
      ***  DETAIL-RECORD-TYPE '2' - NOTICE RECORDS                              
                                                                        
           MOVE SPACES TO PRT-DET-ERROR.                                
           MOVE NOTICE-OUT-SEQ-NUM TO PRT-SEQ-RECS.                     
           MOVE NOTICE-PAY-AMOUNT TO PRT-PMT-AMOUNT.                    
                                                                        
           IF NOTICE-RECORD-TYPE IS NUMERIC                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE ERROR-MESSAGE-2 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO NOT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF NOTICE-OUT-SEQ-NUM IS NUMERIC                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE NOT-ERROR-MSG-1 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO NOT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF NOTICE-DATE-MO IS NUMERIC                                 
               CONTINUE                                                 
           ELSE                                                         
               MOVE NOT-ERROR-MSG-2 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO NOT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF NOTICE-DATE-DA IS NUMERIC                                 
               CONTINUE                                                 
           ELSE                                                         
               MOVE NOT-ERROR-MSG-3 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO NOT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF NOTICE-DATE-YR IS NUMERIC                                 
               CONTINUE                                                 
           ELSE                                                         
               MOVE NOT-ERROR-MSG-4 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO NOT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF NOTICE-PAY-AMOUNT IS NUMERIC                              
               CONTINUE                                                 
           ELSE                                                         
               MOVE NOT-ERROR-MSG-5 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO NOT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
       P3000-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  PROCEDURE P4000-PROCESS-TOTALS                               *         
      *       CALLED BY: P1000-PROCESS-RECORDS                        *         
      *                                                               *         
      *  THIS PROCEDURE EDITS NUMERIC TOTALS RECORD FIELDS AND WRITES *         
      *  ERROR MESSAGES TO ERROR PRINT REPORT, THEN PERFORMS CHECK TO *         
      *  SEE IF BATCH SUMMARY RECORD IS IN WORKING STORAGE TABLE.  IT *         
      *  ALSO CHECKS TO SEE IF THE TOTAL PAYMENT AMOUNT FROM DETAIL   *         
      *  RECORDS MATCHES THE TOTAL AMOUNT IN THE TOTALS RECORD & THAT *         
      *  THE NUMBER OF DETAIL RECORDS MATCHES COUNT IN TOTALS RECORD. *         
      *  SETS BOTH WS- COUNTERS TO ZERO FOR THE NEXT BATCH.           *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P4000-PROCESS-TOTALS.                                            
      ***  DETAIL-RECORD-TYPE '3' - BATCH RECORDS                               
                                                                        
           MOVE SPACES TO PRT-DET-ERROR.                                
           MOVE BATCH-TOT-NUMBER       TO PRT-BATCH-NO.                 
           MOVE BATCH-TOT-NO-DOCUMENTS TO PRT-SEQ-RECS.                 
           MOVE BATCH-TOT-CHEK-AMT-TOT TO PRT-PMT-AMOUNT.               
                                                                        
           IF BATCH-TOT-RECORD-TYPE IS NUMERIC                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE ERROR-MESSAGE-2 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF BATCH-TOT-OUT-SEQ-NUM IS NUMERIC                          
               CONTINUE                                                 
           ELSE                                                         
               MOVE TOT-ERROR-MSG-1 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF BATCH-TOT-DATE-MO IS NUMERIC                              
               CONTINUE                                                 
           ELSE                                                         
               MOVE TOT-ERROR-MSG-2 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF BATCH-TOT-DATE-DA IS NUMERIC                              
               CONTINUE                                                 
           ELSE                                                         
               MOVE TOT-ERROR-MSG-3 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF BATCH-TOT-DATE-YR IS NUMERIC                              
               CONTINUE                                                 
           ELSE                                                         
               MOVE TOT-ERROR-MSG-4 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF BATCH-TOT-BATCH-TYPE IS NUMERIC                           
               CONTINUE                                                 
           ELSE                                                         
               MOVE TOT-ERROR-MSG-5 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF BATCH-TOT-BATCH-NUMBER IS NUMERIC                         
               CONTINUE                                                 
           ELSE                                                         
               MOVE TOT-ERROR-MSG-7 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF BATCH-TOT-NO-DOCUMENTS IS NUMERIC                         
               CONTINUE                                                 
           ELSE                                                         
               MOVE TOT-ERROR-MSG-8 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF BATCH-TOT-AMOUNT-TOTAL IS NUMERIC                         
               CONTINUE                                                 
           ELSE                                                         
               MOVE TOT-ERROR-MSG-9 TO PRT-NOT-BAT-MSG                  
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF BATCH-TOT-CHEK-AMT-TOT IS NUMERIC                         
               CONTINUE                                                 
           ELSE                                                         
               MOVE TOT-ERROR-MSG-10 TO PRT-NOT-BAT-MSG                 
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF BATCH-TOT-BANK-NO IS NUMERIC                              
               CONTINUE                                                 
           ELSE                                                         
               MOVE TOT-ERROR-MSG-11 TO PRT-NOT-BAT-MSG                 
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF BATCH-TOT-AMOUNT-TOTAL IS NOT EQUAL BATCH-TOT-AMOUNT      
               MOVE SPACES TO PRT-DET-ERROR                             
               MOVE ERROR-MESSAGE-3 TO PRT-NOT-BAT-MSG                  
               MOVE BATCH-TOT-AMOUNT-TOTAL TO PRT-X1-A                  
               MOVE BATCH-TOT-AMOUNT TO PRT-X1-B                        
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
           ADD 1 TO RECORD-SUB.                                         
           MOVE BATCH-TOT-AMOUNT TO BATCH-AMOUNT-BC (RECORD-SUB).       
           MOVE ZERO TO BATCH-TOT-AMOUNT.                               
                                                                        
           IF BATCH-TOT-NO-DOCUMENTS IS NOT EQUAL NUM-DETAIL-RECS       
               MOVE SPACES TO PRT-DET-ERROR                             
               MOVE ERROR-MESSAGE-4 TO PRT-NOT-BAT-MSG                  
               MOVE BATCH-TOT-NO-DOCUMENTS TO PRT-X2-A                  
               MOVE NUM-DETAIL-RECS TO PRT-X2-B                         
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           IF ( BATCH-TOT-BATCH-TYPE = WS-PREV-BATCH-TYPE ) AND         
                    ( BATCH-TOT-BATCH-NUMBER = WS-PREV-BATCH-NUM )      
               MOVE SPACES                 TO PRT-DET-ERROR             
               MOVE TOT-ERROR-MSG-12       TO PRT-NOT-BAT-MSG           
               MOVE WS-PREV-BATCH-REC-NUM  TO PRT-BATCH-NUM             
               PERFORM P8500-WRITE-DETAIL THRU P8500-EXIT               
               ADD 1 TO BAT-ERRORS-FOUND                                
           END-IF.                                                      
                                                                        
           MOVE BATCH-TOT-BATCH-TYPE     TO WS-PREV-BATCH-TYPE          
           MOVE BATCH-TOT-BATCH-NUMBER   TO WS-PREV-BATCH-NUM           
           MOVE NUM-DETAIL-RECS TO NO-DETL-RECS-BC (RECORD-SUB).        
           MOVE WS-PREV-BATCH-REC-9   TO BATCH-NUMBER-BC (RECORD-SUB).  
           MOVE RECORD-SUB TO NUMBER-BATCHES.                           
           MOVE ZERO TO NUM-DETAIL-RECS.                                
                                                                        
           PERFORM P6000-CHECK-BATCH-SUMM THRU P6000-EXIT.              
                                                                        
       P4000-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  P5000-READ-BANKTRAN-FL                                       *         
      *       CALLED BY: P1000-PROCESS-RECORDS                        *         
      *                                                               *         
      *  THIS PROCEDURE READS AN INPUT RECORD OF BATCH TRANSACTIONS.  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P5000-READ-BANKTRAN-FL.                                          
                                                                        
           READ BANKTRAN                                                
               AT END                                                   
                   MOVE WS-Y TO EOF-BANKTRAN                            
                   GO TO P5000-EXIT                                     
           END-READ.                                                    
                                                                        
       P5000-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  P6000-CHECK-BATCH-SUMM                                       *         
      *       CALLED BY: P4000-PROCESS-TOTALS                         *         
      *                                                               *         
      *  THIS PROCEDURE SEARCHES THE TABLE OF BATCH RECORDS THAT WERE *         
      *  PREVIOUSLY TRANSMITTED TO SEE IF THE CURRENT BATCH NUMBER IS *         
      *  THERE.  NO TWO BATCHES CAN HAVE THE SAME NUMBER IN ONE DAY.  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P6000-CHECK-BATCH-SUMM.                                          
                                                                        
           MOVE WS-N TO MATCH-FOUND.                                    
           PERFORM VARYING SEARCH-SUB FROM 1 BY 1                       
              UNTIL SEARCH-SUB IS GREATER THAN TABLE-SUB                
                 OR MATCH-IS-FOUND                                      
               IF BATCH-TOT-NUMBER IS EQUAL                             
                  BAT-TBL-BATCH-NUMBER (SEARCH-SUB)                     
                   MOVE WS-Y TO MATCH-FOUND                             
                   ADD 1 TO DUPLICATE-COUNT                             
                   ADD 1 TO ERROR-SUB                                   
                   MOVE BATCH-TOT-NUMBER TO                             
                        ERR-BATCH-NO (ERROR-SUB)                        
                   MOVE ERROR-SUB TO MAX-PRINT-ERRORS                   
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
           IF MATCH-NOT-FOUND                                           
               PERFORM P6500-LOAD-VAL-BATCH THRU P6500-EXIT             
           END-IF.                                                      
                                                                        
       P6000-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * 6251-GET-FJC01-DATE                                           *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C34844        EXEC SQL                                                          
C34844          INCLUDE CPD00037                                                
C34844        END-EXEC.                                                         
C34844        EXEC SQL                                                          
C34844          INCLUDE CPD00038                                                
C34844        END-EXEC.                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  P6500-LOAD-VAL-BATCH                                         *         
      *       CALLED BY: P6000-CHECK-BATCH-SUM                        *         
      *                                                               *         
      *  THIS PROCEDURE LOADS VALID BATCH TOTAL RECORDS INTO TABLE.   *         
      *  IF NO ERRORS ARE FOUND, THESE, ALONG WITH THE RECORDS FROM   *         
      *  THE CURRENT GENERATION OF THE BATCH SUMMARY FILE (WHICH      *         
      *  WERE PREVIOUSLY LOADED INTO THE TABLE) WILL BE WRITTEN TO    *         
      *  THE NEXT GENERATION OF THE BATCH SUMMARY FILE.  IF ERRORS    *         
      *  ARE FOUND, WE CAN CORRECT THE RECORDS IN ERROR AND RERUN     *         
      *  THE PROGRAM WITHOUT CREATING THE NEW FILE GENERATION.        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P6500-LOAD-VAL-BATCH.                                            
                                                                        
           ADD 1 TO TABLE-SUB.                                          
           IF TABLE-SUB IS GREATER THAN WS-MAX-SUB                      
               DISPLAY '** TABLE EXCEEDED - MORE THAN '                 
               WS-MAX-SUB ' ENTRIES **'                                 
               DISPLAY '**       PROCESSING IS TERMINATED         **'   
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           ELSE                                                         
               MOVE BATCH-TOT-RECORD-TYPE  TO                           
                    BAT-TBL-RECORD-TYPE (TABLE-SUB)                     
               MOVE BATCH-TOT-OUT-SEQ-NUM  TO                           
                    BAT-TBL-OUT-SEQ-NUM (TABLE-SUB)                     
               MOVE BATCH-TOT-DATE         TO                           
                    BAT-TBL-DATE        (TABLE-SUB)                     
               MOVE BATCH-TOT-BATCH-TYPE   TO                           
                    BAT-TBL-BATCH-TYPE  (TABLE-SUB)                     
               MOVE BATCH-TOT-BATCH-NUMBER TO                           
                    BAT-TBL-BATCH-NBR   (TABLE-SUB)                     
               MOVE BATCH-TOT-NO-DOCUMENTS TO                           
                    BAT-TBL-NUM-DOCS    (TABLE-SUB)                     
               MOVE BATCH-TOT-AMOUNT-TOTAL TO                           
                    BAT-TBL-AMOUNT-TOT  (TABLE-SUB)                     
               MOVE BATCH-TOT-CHEK-AMT-TOT TO                           
                    BAT-TBL-CHK-AMT-TOT (TABLE-SUB)                     
               MOVE BATCH-TOT-BANK-NO      TO                           
                    BAT-TBL-BANK-NO     (TABLE-SUB)                     
               MOVE BATCH-TOT-AGENT-ID     TO                           
                    BAT-TBL-AGENT-ID    (TABLE-SUB)                     
           END-IF.                                                      
                                                                        
       P6500-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  P7000-WRITE-SUMMARY                                          *         
      *       CALLED BY: P0000-MAIN                                   *         
      *                                                               *         
      *  THIS PROCEDURE WRITES ALL BATCH SUMMARY TOTAL RECORDS TO THE *         
      *  NEXT GENERATION OF THE FILE WHEN NO ERRORS HAVE BEEN FOUND.  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P7000-WRITE-SUMMARY.                                             
                                                                        
           IF WRITE-SUB IS GREATER THAN WS-MAX-SUB                      
               DISPLAY '** TABLE EXCEEDED - MORE THAN '                 
               WS-MAX-SUB ' ENTRIES **'                                 
               DISPLAY '**       PROCESSING IS TERMINATED         **'   
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           ELSE                                                         
               MOVE BAT-TBL-RECORD-TYPE (WRITE-SUB) TO                  
                    BATCH-SUM-REC-TYP-OUT                               
               MOVE BAT-TBL-OUT-SEQ-NUM (WRITE-SUB) TO                  
                    BATCH-SUM-OSEQ-NO-OUT                               
               MOVE BAT-TBL-DATE        (WRITE-SUB) TO                  
                    BATCH-SUM-DATE-OUT                                  
               MOVE BAT-TBL-BATCH-TYPE  (WRITE-SUB) TO                  
                    BATCH-SUM-TYPE-OUT                                  
               MOVE BAT-TBL-BATCH-NBR   (WRITE-SUB) TO                  
                    BATCH-SUM-BATCH-NO-OUT                              
               MOVE BAT-TBL-NUM-DOCS    (WRITE-SUB) TO                  
                    BATCH-SUM-NO-DOCS-OUT                               
               MOVE BAT-TBL-AMOUNT-TOT  (WRITE-SUB) TO                  
                    BATCH-SUM-AMT-TOT-OUT                               
               MOVE BAT-TBL-CHK-AMT-TOT (WRITE-SUB) TO                  
                    BATCH-SUM-CHEK-AMT-OUT                              
               MOVE BAT-TBL-BANK-NO     (WRITE-SUB) TO                  
                    BATCH-SUM-BANK-NO-OUT                               
               MOVE BAT-TBL-AGENT-ID    (WRITE-SUB) TO                  
                    BATCH-SUM-AGENT-ID-OUT                              
           END-IF.                                                      
                                                                        
           WRITE BATCH-SUM-OUT-REC.                                     
           ADD 1 TO NEW-BATCH-REC-CNT.                                  
           ADD 1 TO WRITE-SUB.                                          
                                                                        
       P7000-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  P8000-REPORT-HEADINGS                                        *         
      *       CALLED BY: P0100-INITIATE-PROCESSING P8500-WRITE-DETAIL *         
      *                                                               *         
      *  THIS PROCEDURE WRITES THE HEADERS FOR THE ERROR REPORT.      *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P8000-REPORT-HEADINGS.                                           
                                                                        
           ADD 1 TO REPORT-PAGE-NO.                                     
           MOVE REPORT-PAGE-NO TO PRT-PAGE-NO.                          
                                                                        
           WRITE PRT-1-RECORD FROM HEAD-01                              
              AFTER ADVANCING TOP-OF-PAGE.                              
           WRITE PRT-1-RECORD FROM HEAD-02                              
              AFTER ADVANCING 1 LINE.                                   
           WRITE PRT-1-RECORD FROM HEAD-03                              
              AFTER ADVANCING 1 LINE.                                   
           WRITE PRT-1-RECORD FROM BLANK-LINE                           
              AFTER ADVANCING 1 LINE.                                   
           WRITE PRT-1-RECORD FROM HEAD-04                              
              AFTER ADVANCING 1 LINE.                                   
           WRITE PRT-1-RECORD FROM DASH-LINE                            
              AFTER ADVANCING 1 LINE.                                   
           WRITE PRT-1-RECORD FROM BLANK-LINE                           
              AFTER ADVANCING 1 LINE.                                   
                                                                        
           ADD 7 TO REPORT-LINE-NO.                                     
                                                                        
       P8000-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  P8500-WRITE-DETAIL                                           *         
      *       CALLED BY: P2000-PROCESS-DETAIL  P3000-PROCESS-NOTICE   *         
      *                  P4000-PROCESS-TOTALS                         *         
      *                                                               *         
      *  THIS PROCEDURE WRITES THE DETAIL LINE FOR THE ERROR REPORT.  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       P8500-WRITE-DETAIL.                                              
                                                                        
           IF REPORT-LINE-NO IS GREATER THAN WS-51                      
               MOVE ZERO TO REPORT-LINE-NO                              
               PERFORM P8000-REPORT-HEADINGS THRU P8000-EXIT            
           END-IF.                                                      
                                                                        
           WRITE PRT-1-RECORD FROM DETAIL-LINE                          
              AFTER ADVANCING 1 LINE.                                   
                                                                        
           ADD 1 TO REPORT-LINE-NO.                                     
                                                                        
       P8500-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   7000-SELECT-ACCT-CNT.                                       *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C34844    7000-SELECT-ACCT-CNT.                                         
C34844                                                                  
C34844     MOVE '7000' TO WS-ACTIVE-PARAGRAPH                           
C34844                                                                  
C34844     EXEC SQL                                                     
C34844       SELECT CODE_VALUE                                          
C34844         INTO :UV-CODE-VALUE                                      
C34844         FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
C34844        WHERE TABLE_NA   = 'CSS_DUMMY'                            
C34844          AND COMPANY_NO = '01'                                   
C34844          AND COLUMN_NA  = 'DUMMY'                                
C34844          AND PROGRAM_ID = 'ALL'                                  
C34844                                                           
C34844     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CODE_VALUE                                                  
MFA-TR*        INTO :UV-CODE-VALUE                                              
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE TABLE_NA   = 'CSS_DUMMY'                                    
MFA-TR*         AND COMPANY_NO = '01'                                           
MFA-TR*         AND COLUMN_NA  = 'DUMMY'                                        
MFA-TR*         AND PROGRAM_ID = 'ALL'                                          
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34844                                                                  
C34844     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C34844        MOVE UV-CODE-VALUE-TEXT(1:3) TO ACCOUNTNO-COUNT           
C34844     ELSE                                                         
C34844     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C34844        MOVE 005                     TO ACCOUNTNO-COUNT           
C34844     ELSE                                                         
C34844        DISPLAY '*--------------------------------------------*'  
C34844        DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'  
C34844        DISPLAY '** ERROR SELECTING VALUE IN CSS_CODE_VALUE   *'  
C34844        DISPLAY '*--------------------------------------------*'  
C34844        DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH     
C34844        DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE   
C34844        DISPLAY '** TABLE = CSS_DUMMY, COLUMN = DUMMY '           
C34844        DISPLAY '*--------------------------------------------*'  
C34844         PERFORM 9900-ABEND THRU 9900-EXIT                        
C34844     END-IF                                                       
C34844     END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * READ COMPANY USER TABLE TO GET COMPANY NAME                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C34844 7510-SELECT-COMPANY.                                             
C34844     EXEC SQL                                                     
C34844        SELECT                                                    
C34844          COMPANY_NAME                                            
C34844        INTO :C7-COMPANY-NAME                                     
C34844        FROM CSS_COMPANY                                          
C34844        WHERE COMPANY_NO ='01'                                    
C34844     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34844     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C34844     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
C34844          OR NOT-FOUND                                            
C34844        NEXT SENTENCE                                             
C34844      ELSE                                                        
C34844         DISPLAY '** 7510-SELECT-COMPANY'                         
C34844         DISPLAY '** COMPANY = ' C7-COMPANY-NO                    
C34844         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
C34844         PERFORM 9900-ABEND THRU 9900-EXIT                        
C34844     END-IF.                                                      
C34844 7510-EXIT.                                                       
C34844     EXIT.                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  PROCEDURE 9000-TERMINATE.                                    *         
      *       CALLED BY: P0000-MAIN                                   *         
      *                                                               *         
      *  THIS PROCEDURE CLOSES THE FILES, THEN DISPLAYS THE BATCH-NO, *         
      *  NUMBER OF DETAIL RECORDS AND TOTAL AMOUNT FOR THAT BATCH, &  *         
      *  THE NUMBER OF BATCHES PROCESSED, AND TERMINATES PROCESSING.  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE BANKTRAN,                                              
                 BATCHIN,                                               
                 PRINTER1.                                              
                                                                        
           MOVE 1 TO RECORD-SUB.                                        
           PERFORM NUMBER-BATCHES TIMES                                 
               MOVE BATCH-NUMBER-BC (RECORD-SUB) TO DISP-BATCH-NO       
               MOVE NO-DETL-RECS-BC (RECORD-SUB) TO DISP-NUM-RECS       
               MOVE BATCH-AMOUNT-BC (RECORD-SUB) TO DISP-AMOUNT         
               DISPLAY DISPLAY-ERROR-LINE                               
               ADD 1 TO RECORD-SUB                                      
           END-PERFORM.                                                 
               DISPLAY                                                  
               '*******************************************************'
           DISPLAY '**-------> NUMBER OF BATCHES PROCESSED = '          
                    NUMBER-BATCHES ' <-------**'.                       
                                                                        
           DISPLAY '**-------> NUMBER OF RECS IN PREV GDG  = '          
                PREV-BATCH-REC-CNT ' <-------**'.                       
           IF NUMERIC-ERROR-FOUND OR BATCH-DUPLICATE-FOUND              
               DISPLAY                                                  
               '** NO RECORDS WERE WRITTEN TO NEW GDG DUE TO ERROR(S)**'
               DISPLAY                                                  
            '** PCSAC185- PROGRAM ABEND - CORRECT ERROR(S) & RERUN **'  
               DISPLAY                                                  
               '**--------> DELETE CURRENT GDG BEFORE RERUN <--------**'
           ELSE                                                         
               DISPLAY '**-------> NUMBER OF RECS IN CURR GDG  = '      
                     NEW-BATCH-REC-CNT ' <-------**'                    
           END-IF.                                                      
C34844        IF WS-ACCT-COUNT >= ACCOUNTNO-COUNT                       
C34844           DISPLAY '**----->TOTAL ACCOUNTS WITH ZEROS = '         
C34844                 WS-ACCT-COUNT '<-----**'                         
C34844        END-IF.                                                   
           DISPLAY '**---------> END OF JOB RETURN-CODE = '             
                    EOJ-CODE  '<--------**'.                            
           MOVE EOJ-CODE TO RETURN-CODE.                                
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C34844* ABEND ROUTINE PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                  
                                                                        
C34844     EXEC SQL                                                     19450000
C34844          INCLUDE CPD09900                                        19460000
C34844    END-EXEC.                                                     19470000
