       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSAC184.                                         
       AUTHOR.    BASKAR VANNI.                                         
       DATE-WRITTEN.  JAN 2006.                                         
      *----------------------------------------------------------------*        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *----------------------------------------------------------------*        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS USED TO POST BATCH PAYMENT REVERSALS          *        
      *                                                                *        
      *  NOTES:- THE INPUT FILE SHOULD MEET THE FOLLOWING CRITERIA.    *        
      *  1.BATCH TOTAL RECORD SHOULD HAVE A VALUE '3' IN RECORD TYPE   *        
      *  2.DATE CASH REPORT FORMAT IS YYYYMMDD                         *        
      *  3.CASH LOCAL OFFICE VALUE SHOULD MATCH THE ORIGINAL PAYMENT   *        
      *    CASH LOCAL OFFICE                                           *        
      *  4.CASH DRAWER ID IS THE ORIGINAL CASH DRAWER ID USED          *        
      *  5.DETAIL RECORD SHOULD HAVE A VALUE '1' IN RECORD TYPE        *        
      *                                                                *        
      *----------------------------------------------------------------*        
      *----------------------------------------------------------------*        
      * CREATE INPUT FILE BY USING THE FOLLOWING STEPS:                *        
      *----------------------------------------------------------------*        
      *-RUN BELOW QUERY BY UPDATING THE WHERE CLAUSE-------------------*        
      *----------------------------------------------------------------*        
      *-------SELECT ACCOUNT_NO,TRANS_HIST_SEQ_NO,            ---------*        
      *-------       ,AMT_ORIG_ENTERED,CASH_DRAWER_ID         ---------*        
      *-------  FROM CSRP.CSS_AR_TRANS_HIST                   ---------*        
      *------- WHERE ACCOUNT_NO > 0                           ---------*        
      *-------   AND DATE_TRANS = PAYMENT DATE                ---------*        
      *-------   AND DATE_CASH_REPORT = ORIGINAL REPORT DATE  ---------*        
      *-------   AND CASH_LOCAL_OFFICE = ORIGINAL OFFICE      ---------*        
      *------- ORDER BY CASH_DRAWER_ID ASC, ACCOUNT_NO ASC    ---------*        
      *-------  WITH UR                                       ---------*        
      *----------------------------------------------------------------*        
      *----------------------------------------------------------------*        
      *- FROM SPUFI OUTPUT DO A SORT AND DELETE ROWS OTHER THAN OUTPUT-*        
      *- DO A SORT FOR CASH DRAWER ID POSITIONS ( EX. SORT 54 57 )    -*        
      *- PAD WITH ZEROES FOR ACCOUNT NO AND PAYMENT AMOUNT FIELDS TO  -*        
      *- ITS FULL LENGTH ( ACCT NO - 13, PAYMENT AMT - 11 ) BY TYPING -*        
      *- ZEROES IN A NEW LINE IN THESE FIELDS CORRESPONDING POSITIONS -*        
      *- AND DOING A COPY AND OVERRIDE TO ALL ROWS.                   -*        
      *- ADD 1 TO ALL ROWS IN POSITION 1 USING THE SAME METHOD ABOVE. -*        
      *- REMOVE UNNECESSARY SPACES BETWEEN FIELDS BY USING CHANGE     -*        
      *- COMMAND.                                                     -*        
      *- REMOVE THE '.' IN THE AMOUNT FIELD BY USING CHANGE COMMAND.  -*        
      *- ADD THE CURRENCY TYPE TO ALL ROWS USING CHANGE & OVERRIDE.   -*        
      *- INSERT A HEADER RECORD WHENEVER BATCH NO CHANGES             -*        
      *- AFTER INSERTING HEADER WE DON'T NEED CASH DRAWER ID, IF WE   -*        
      *- LEAVE THIS THEN THE FILE SHOULD BE 52 CHARACTERS LONG.       -*        
      *- COPY THIS TO INPUT FILE WHICH HAS THE RECORD LENGTH OF 52    -*        
      *----------------------------------------------------------------*        
      *----------------------------------------------------------------*        
      *----------------------------------------------------------------*        
      *                                                                *        
      *                 PROGRAM MODIFICATION LOG                       *        
      *                                                                *        
      *   DATE    INITIALS   REASON                                    *        
      * --------  --------   ----------------------------------------- *        
      * 01/20/06  BASKAR V   NEW PROGRAM TO DO BATCH PAYMENT REVERSALS *        
A00956* 03/26/09  CVNS       REPLACE CPD00006 WITH CPD0006A.           *        
A00956*           CHENNAI                                              *        
      *                                                                *        
P00641* 05/01/12   DB41297    REMOVE TBGLATNO UNUSED FIELDS.           *        
ACT306* 10/14/16   RB19957    REMOVE ALL LOGIC THAT CALLS DB2 TABLE    *        
ACT306*  APPL00005460,ACT306  CSS_BILL_AGNT_PYMT AND TBBAPYMT.         *        
      *----------------------------------------------------------------*        
                                                                        
              REMARKS.                                                  
                                                                        
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
                                                                        
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
           SELECT FCSAC184-FILE                                         
            ASSIGN UT-S-FCSAC184                                        
             FILE STATUS IS WS-FCSAC184-STATUS.                         
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSAC184-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD                                   
           DATA RECORD IS DETAIL-REC BATCH-TOTAL-REC.                   
       01  BATCH-TOTAL-REC.                                             
           05  I-REC-TYPE-TOT              PIC X(01).                   
      * TOTAL REC VALUE IS 3                                                    
           05  I-CASH-LOCAL-OFFICE         PIC X(03).                   
      * ORIGINAL PAYMENT OFFICE, REVERSAL WILL BE DONE ON SAME OFFICE           
           05  I-DATE-CASH-REPORT          PIC X(08).                   
      * ORIGINAL REPORT DATE, REVERSAL WILL BE DONE ON SAME DATE                
           05  I-CASH-DRAWER-ID            PIC 9(04).                   
      * ORIGINAL BATCH, REVERSAL WILL BE PROCESSED ON SAME                      
           05  I-TOTAL-NO-RECS             PIC 9(06).                   
      * TOTAL NO OF RECORDS ON FILE                                             
           05  I-TOTAL-PYMT-AMT            PIC 9(13).                   
      * TOTAL PAYMENT AMOUNT                                                    
           05  FILLER                      PIC X(17).                   
       01  DETAIL-REC.                                                  
           05  I-REC-TYPE-DET              PIC X(01).                   
      * DETAIL RECORD VALUE IS 1                                                
           05  I-ACCOUNT-NO                PIC X(13).                   
           05  I-PAYMENT-TS                PIC X(26).                   
           05  I-PAYMENT-AMOUNT            PIC X(11).                   
           05  I-CURRENCY-TYPE             PIC X(01).                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC184'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-FCSAC184-STATUS          PIC X(02)   VALUE '00'.      
               88 FCSAC184-SUCCESSFUL                  VALUE '00' '04'. 
           05  WS-FCSAC184-FLAG            PIC X(01)   VALUE SPACE.     
               88 END-OF-FCSAC184                      VALUE 'Y'.       
           05  WS-RECORD-SW                PIC X(01)   VALUE SPACE.     
               88 DETAIL-REC-FOUND                     VALUE 'D'.       
               88 TOTAL-REC-FOUND                      VALUE 'T'.       
           05  WS-THIRD-PARTY-SW           PIC X(01)   VALUE SPACE.     
               88 THIRD-PARTY-PYMT                     VALUE 'Y'.       
               88 NORMAL-PYMT                          VALUE 'N'.       
                                                                        
       01  WS-HARDCODED-VARIABLES.                                      
           05  WS-TRAN-ID                  PIC X(04)  VALUE 'C184'.     
           05  WS-ALL9-ACNO                PIC 9(13)  VALUE             
                                                      9999999999999.    
           05  WS-PROGRAM-NAME             PIC X(08)  VALUE 'PCSAC184'. 
           05  PROGRAM-NAME                PIC X(08)  VALUE 'PCSAC184'. 
           05  WS-JRNL-NAME                PIC X(04)  VALUE 'C184'.     
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-M                        PIC X(01)  VALUE 'M'.        
           05  WS-D                        PIC X(01)  VALUE 'D'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-P                        PIC X(01)  VALUE 'P'.        
           05  WS-LIT-A                    PIC X(01)  VALUE 'A'.        
           05  WS-LIT-C                    PIC X(01)  VALUE 'C'.        
           05  WS-LIT-D                    PIC X(01)  VALUE 'D'.        
           05  WS-THREE                    PIC 9(01)  VALUE 3.          
           05  WS-ZERO                     PIC 9(01)  VALUE 0.          
           05  WS-NO                       PIC X(01)  VALUE 'N'.        
           05  WS-01                       PIC X(02)  VALUE '01'.       
           05  WS-101                      PIC 9(03)  VALUE 101.        
           05  WS-REC-TYPE-ERROR           PIC X(50)   VALUE            
                   'UNRECOGNIZED RECORD TYPE FOUND'.                    
           05  WS-COMMENT-LEN              PIC S9(04)  COMP VALUE +30.  
           05  WS-COMMENT-TEXT             PIC X(35)   VALUE            
                   'BCH SHORTAGE POSTED BY SYSTEM '.                    
           05  WS-TRAN-COMMENT-LEN         PIC S9(04)  COMP VALUE +19.  
           05  WS-TRAN-COMMENT-TEXT        PIC X(19)   VALUE            
                   'THIRD PARTY JOURNAL'.                               
           05  WS-SYSTEM                   PIC X(06)   VALUE 'SYSTEM'.  
           05  WS-SYS                      PIC X(07)   VALUE 'SYSTEM '. 
           05  WS-ONE                      PIC 9(01)   VALUE 1.         
           05  WS-CASH-GL-ACCT             PIC 9(03)V9(4)               
                                                       VALUE 184.2000.  
                                                                        
       01  WS-WORK-VARIABLES.                                           
           05  WS-REPORT-DATE.                                          
               10 WS-REPORT-YY             PIC X(04).                   
               10 FILLER                   PIC X(01)   VALUE '-'.       
               10 WS-REPORT-MM             PIC X(02).                   
               10 FILLER                   PIC X(01)   VALUE '-'.       
               10 WS-REPORT-DD             PIC X(02).                   
           05  WS-ERR-MSG                  PIC X(100)  VALUE SPACES.    
                                                                        
           05  WS-ERR-MSG2                 PIC X(100)  VALUE SPACES.    
           05  WS-PYMT-ACCT-CNT            PIC S9(8)   VALUE +0.        
           05  WS-CASH-LOCAL-OFFICE        PIC  X(3).                   
           05  WS-TOTAL-RVR-AMT            PIC  9(11)V99.               
           05  WS-TOTAL-BATCH-RECS         PIC  9(06)  VALUE 0.         
           05  WS-CASH-DRAWER-ID           PIC S9(4)   VALUE +0.        
           05  WS-BATCH-NO                 PIC  9(4)   VALUE  0.        
           05  WS-TOTAL-RECS               PIC  9(6)   VALUE  0.        
           05  WS-XFR-TS                   PIC X(26)   VALUE SPACES.    
           05  WS-TRAN-TIME                PIC X(08).                   
           05  WS-CURRENT-DATE             PIC X(10)  VALUE SPACES.     
           05  WS-DISP-GL-ACCT             PIC 9(3).9(4).               
           05  WS-DEP-BANK-ID              PIC 9(4).                    
           05  WS-DUP-CNTRL-NO             PIC 9(4).                    
           05  WS-PARTITION-NO             PIC 9(4).                    
           05  WS-PYMT-AMT                 PIC X(11).                   
           05  WS-PYMT-AMT-NUM REDEFINES WS-PYMT-AMT PIC 9(9)V99.       
           05  WS-PYMT-AMOUNT              PIC S9(09)V99 COMP-3         
                                                      VALUE +0.         
           05  WS-TOTAL-AMT                PIC X(13).                   
           05  WS-TOTAL-AMT-NUM REDEFINES WS-TOTAL-AMT PIC 9(11)V99.    
           05  WS-BATCH-TOT-AMT            PIC S9(11)V99 COMP-3         
                                                      VALUE +0.         
           05  WS-NULL-IND-1               PIC S9(4)  USAGE COMP        
                                                      VALUE +0.         
           05  WS-DISP-CASH-DRAWER-ID      PIC 9(4)   VALUE 0.          
           05  WS-OVERSHORT-ID             PIC 9(4)   VALUE 0.          
           05  WS-ACCOUNT-NO               PIC 9(13)  VALUE 0.          
           05  WS-ACCOUNT-CHAR             PIC X(13).                   
           05  WS-TIMESTAMP                PIC X(26).                   
                                                                        
       01  WS-COMMIT-DATA.                                              
           05  WS-COMMIT-TEXT              PIC X(09).                   
           05  WS-COMMIT-NUM               PIC 9(05).                   
           05  FILLER                      PIC X(69).                   
                                                                        
       01  WS-RESTART-MISC.                                             
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 50.          
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-LUW-PROCESSED            PIC S9(07) VALUE ZERO COMP-3.
           05  WS-RECORDS-PROCESSED        PIC S9(07) VALUE ZERO COMP-3.
           05  WS-COMMIT-COUNT             PIC 9(05)  VALUE 0.          
           05  WS-RESTART-IND              PIC X(01)  VALUE 'N'.        
           05  WS-COMMIT-REC               PIC X(01)  VALUE 'Y'.        
               88 COMMIT-REC-NOT-FOUND                VALUE 'N'.        
               88 COMMIT-REC-FOUND                    VALUE 'Y'.        
           05  WS-RESTART-KEY.                                          
               10 WS-RESTART-REC-TYPE      PIC X(01).                   
               10 WS-RESTART-ACCOUNT       PIC X(13).                   
               10 WS-RESTART-PYMT-TS       PIC X(26).                   
               10 WS-RESTART-AMOUNT        PIC X(11).                   
               10 WS-RESTART-CURRENCY      PIC X(01).                   
                                                                        
       01 ATT-RETURN-FIELDS.                                            
           05 S-RETURN-CODE                PIC S9(9)  VALUE 0 COMP.     
           05 S-DNP-FLAG                   PIC X(01)  VALUE 'N'.        
           05 S-AR-LOCKOUT-IND             PIC X(01)  VALUE SPACE.      
           05 S-ACCT-XFER-TO               PIC X(13)  VALUE SPACE.      
                                                                        
      *DECLARE 101 JOURNAL VARIABLES                                            
       COPY CJF00101.                                                           
      *DECLARE DATE VARIABLES                                                   
      *COPY CWS00021.                                                           
      *DECLARE RESTART AND JOB PARM TABLE VARIABLES                             
       COPY CWS00038.                                                           
      *DECLARE 101 JOURNAL VARIBLES                                             
       COPY FIOJC01.                                                            
      *DECLARE DB2 ERROR PROCESSING VARIABLES                                   
       COPY CWS00303.                                                           
      *DECLARE ABEND SWITCH                                                     
       COPY CWS09900.                                                           
      *COPY CWS00104.                                                           
      *DECLARE CODES_DATA_PRESENT VALUES                                        
       COPY CWS00056.                                                           
      *COPY CWS00010.                                                           
      *DECLARE WS-PAR VARIABLES TO BE USED IN PAYMENTS MODULE                   
           EXEC SQL                                                             
             INCLUDE CWS00017                                                   
           END-EXEC.                                                            
                                                                        
      *COPYBOOK FOR ERROR HANDLING                                              
           EXEC SQL                                                             
             INCLUDE CWSX0010                                                   
           END-EXEC.                                                            
                                                                        
      *INCLUDE SQL COMMUNICATION AREA                                           
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      * CSS_BATCH_JRNL - BJ                                                     
           EXEC SQL                                                             
             INCLUDE TBBTJRNL                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_ACCOUNT - AT                                                        
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_BCH_JRNL_CNTL - BC                                                  
           EXEC SQL                                                             
             INCLUDE TBBJCNTL                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_JOB_PARM - G6                                                       
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_APPL_PGM_DESC - K9                                                  
           EXEC SQL                                                             
             INCLUDE TBPGMDSC                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_OVERSHORT_HDR - OH                                                  
           EXEC SQL                                                             
             INCLUDE TBOVSHHD                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_OVERSHORT_TYPE - OT                                                 
           EXEC SQL                                                             
             INCLUDE TBOVSHTY                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_DELINQUENCY - C8                                                    
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_XREF_ACCT - XR                                                      
           EXEC SQL                                                             
             INCLUDE TBXREF                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_AR_TRANS_HIST - AR                                                  
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_AR_TRN_HST_DET - AU                                                 
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_CSH_DRWR_CNTL - CS                                                  
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_CSH_DRWR_JRNL - CJ                                                  
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_BANK_TRANSFER - YB                                                  
           EXEC SQL                                                             
            INCLUDE TBBNKXFR                                                    
           END-EXEC.                                                            
                                                                        
      * CSS_CSH_REPORT_HDR - YR                                                 
           EXEC SQL                                                             
               INCLUDE TBCSRPHD                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_GL_ACCT_NO - GO                                                     
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_MISC_JRNL - MJ                                                      
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_BANK - D1                                                           
           EXEC SQL                                                             
            INCLUDE TBBANK                                                      
           END-EXEC.                                                            
                                                                        
      * CSS_CASHIER_OFFICE - Y2                                                 
           EXEC SQL                                                             
              INCLUDE TBCSHOFF                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_USER_PROFILE - PF                                                   
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_CASHIER - Y1                                                        
           EXEC SQL                                                             
            INCLUDE TBCSHIER                                                    
           END-EXEC.                                                            
                                                                        
      * CSS_RESTART - RF                                                        
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
                                                                        
      * DECLARE JOURNAL VARIABLES                                               
           EXEC SQL                                                             
              INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
      ****** DB2 COMMUNICATION REQUIREMENT ******                               
      *01  LOC1                        USAGE IS SQL TYPE IS             
      *                                RESULT-SET-LOCATOR VARYING.      
                                                                        
      * CURSOR TO RETRIEVE OVER_SHORT_TYPE                                      
           EXEC SQL                                                     
            DECLARE OVSHTYPE_CURSOR CURSOR FOR                          
             SELECT OVERSHORT_TYPE_CD                                   
               FROM CSS_OVERSHORT_TYPE                                  
              WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                         
           END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C3 CURSOR
MSQ001          FOR CALL CSR03486                                       
                       ( :WS-ACCOUNT-CHAR
                  , :WS-TIMESTAMP
                  , :WS-PROGRAM-NAME
                  , :WS-SYS
                  , :WS-PARM-COMMENT
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01 WS-PARM-FIELD.                                                
          05 WS-LENGTH                   PIC S9(4) COMP.                
          05 WS-PARM-COMMENT             PIC X(30).                     
       PROCEDURE DIVISION USING WS-PARM-FIELD.                          
                                                                        
      **--------------------------------------------------------------**        
      ** CONTROLS THE PATH OF THE PROGRAM                             **        
      **--------------------------------------------------------------**        
       0000-MAINLINE.                                                   
      *-------------*                                                           
                                                                        
           PERFORM 0100-OPEN-FILES         THRU 0100-EXIT               
           PERFORM 2000-PROCESS-ACCOUNTS   THRU 2000-EXIT               
             UNTIL END-OF-FCSAC184                                      
           PERFORM 2500-PERFORM-JRNL-XFER                               
              THRU 2500-EXIT                                            
           PERFORM 8930-DELETE-RESTART                                  
              THRU 8930-EXIT                                            
           PERFORM 9100-TERMINATE                                       
              THRU 9100-EXIT                                            
                                                                        
           DISPLAY ' **  PROCESSING COMPLETED SUCCESSFULLY **'          
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-MAINLINE.                                                   
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** OPENS THE INPUT FILE AND CHECK FOR RESTART RECORD            **        
      **--------------------------------------------------------------**        
       0100-OPEN-FILES.                                                 
      *----------------*                                                        
                                                                        
           MOVE '0100'                        TO WS-ACTIVE-PARAGRAPH    
                                                                        
           OPEN INPUT FCSAC184-FILE                                     
           IF FCSAC184-SUCCESSFUL                                       
              PERFORM 1000-READ-FILE          THRU 1000-EXIT            
              IF I-REC-TYPE-DET NOT EQUAL WS-THREE                      
                 STRING '** FIRST RECORD IS NOT TOTAL RECORD **'        
                                        DELIMITED BY SIZE               
                                        INTO WS-ERR-MSG                 
                 PERFORM 8850-DISPLAY-ERR-TERM                          
                    THRU 8850-EXIT                                      
              END-IF                                                    
           ELSE                                                         
              STRING '** FCSAC184 FILE OPEN ERROR  **'                  
                                        DELIMITED BY SIZE               
                     'FILE STATUS = '   DELIMITED BY SIZE               
                     WS-FCSAC184-STATUS  DELIMITED BY SIZE              
                                        INTO WS-ERR-MSG                 
              PERFORM 8850-DISPLAY-ERR-TERM                             
                 THRU 8850-EXIT                                         
           END-IF                                                       
                                                                        
           PERFORM 1010-COMMIT-JOB-PARM       THRU 1010-EXIT            
                                                                        
           MOVE WS-N                  TO WS-RESTART-IND                 
           MOVE WS-PROGRAM-NAME       TO RF-NAME-PROGRAM                
           MOVE 1                     TO RF-DUP-CNTRL-NO                
                                         WS-DUP-CNTRL-NO                
           MOVE 0                     TO RF-PARTITION-NO                
                                         WS-PARTITION-NO                
                                                                        
           SET  COMMIT-REC-FOUND  TO TRUE                               
           PERFORM  8910-CHECK-FOR-RESTART THRU 8910-EXIT               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RF-RESTART-DATA-TEXT       TO WS-RESTART-KEY         
              MOVE WS-Y                       TO WS-RESTART-IND         
              SET  COMMIT-REC-NOT-FOUND       TO TRUE                   
              DISPLAY ' '                                               
              DISPLAY '** PCSAC184 PROCESSING INFO **'                  
              DISPLAY '** THE KEY FOR THE LAST BATCH COMMITTED IS :'    
                          WS-RESTART-KEY                                
           END-IF                                                       
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** READS THE INPUT FILE                                         **        
      **--------------------------------------------------------------**        
       1000-READ-FILE.                                                  
      *---------------*                                                         
           MOVE '1000'                TO WS-ACTIVE-PARAGRAPH            
                                                                        
           READ FCSAC184-FILE                                           
           AT END                                                       
              SET END-OF-FCSAC184 TO TRUE                               
           END-READ                                                     
                                                                        
           IF FCSAC184-SUCCESSFUL OR END-OF-FCSAC184                    
              IF END-OF-FCSAC184 AND COMMIT-REC-NOT-FOUND               
                 STRING '** RESTART RECORD NOT FOUND IN FILE **'        
                                        DELIMITED BY SIZE               
                                        INTO WS-ERR-MSG                 
                 PERFORM 8850-DISPLAY-ERR-TERM                          
                    THRU 8850-EXIT                                      
              END-IF                                                    
           ELSE                                                         
              STRING '** FCSAC184 FILE READ ERROR  **'                  
                                        DELIMITED BY SIZE               
                     'FILE STATUS = '   DELIMITED BY SIZE               
                     WS-FCSAC184-STATUS DELIMITED BY SIZE               
                                        INTO WS-ERR-MSG                 
              PERFORM 8850-DISPLAY-ERR-TERM                             
                 THRU 8850-EXIT                                         
           END-IF                                                       
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** SELECTS THE COMMIT NO                                        **        
      **--------------------------------------------------------------**        
       1010-COMMIT-JOB-PARM.                                            
      *---------------------*                                                   
                                                                        
           PERFORM 7600-GET-COMMIT-PARM THRU  7600-EXIT                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA  TO WS-COMMIT-DATA                      
           END-IF                                                       
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSAC184 PROCESSING INFO   **'            
                 DISPLAY '**    COMMIT PARM NOT PRESENT'                
                 DISPLAY '**  DEFAULT CHKP LUW 50 IS USED'              
                 MOVE WS-DEFAULT-CHKP-LUW-LIMIT TO WS-CHKP-LUW-LIMIT    
              WHEN WS-COMMIT-NUM NOT NUMERIC                            
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSAC184 PROCESSING ERROR  **'            
                 DISPLAY '**    COMMIT PARM NOT NUMERIC'                
                 DISPLAY '**    KEY = ' WS-COMMIT-DATA                  
                 DISPLAY '**  PROCESSING TERMINATED  **'                
                 PERFORM 9800-ABEND  THRU  9800-EXIT                    
              WHEN WS-COMMIT-NUM  NUMERIC                               
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSAC184 PROCESSING INFO  **'             
                 MOVE WS-COMMIT-NUM  TO  WS-CHKP-LUW-LIMIT              
                 DISPLAY '**    CHKP LUW IS ' WS-CHKP-LUW-LIMIT         
           END-EVALUATE                                                 
           .                                                            
       1010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** CHECKS THE RECORD TYPE AND PROCESS THAT                      **        
      **--------------------------------------------------------------**        
       2000-PROCESS-ACCOUNTS.                                           
      *----------------------*                                                  
           MOVE '2000'                TO WS-ACTIVE-PARAGRAPH            
                                                                        
           IF COMMIT-REC-NOT-FOUND                                      
              IF I-REC-TYPE-DET = WS-ONE                                
                 ADD  1 TO WS-TOTAL-RECS                                
                 MOVE I-PAYMENT-AMOUNT        TO WS-PYMT-AMT            
                 MOVE WS-PYMT-AMT-NUM         TO WS-PYMT-AMOUNT         
                 ADD  WS-PYMT-AMT-NUM         TO WS-TOTAL-RVR-AMT       
              ELSE                                                      
                 MOVE I-CASH-DRAWER-ID        TO WS-BATCH-NO            
                 MOVE I-TOTAL-PYMT-AMT        TO WS-TOTAL-AMT           
                 MOVE WS-TOTAL-AMT-NUM        TO WS-BATCH-TOT-AMT       
                 MOVE I-TOTAL-NO-RECS         TO WS-TOTAL-BATCH-RECS    
                 MOVE 0                       TO WS-TOTAL-RECS          
                                                 WS-TOTAL-RVR-AMT       
                 MOVE I-DATE-CASH-REPORT(1:4) TO WS-REPORT-YY           
                 MOVE I-DATE-CASH-REPORT(5:2) TO WS-REPORT-MM           
                 MOVE I-DATE-CASH-REPORT(7:2) TO WS-REPORT-DD           
                 MOVE I-CASH-DRAWER-ID        TO WS-CASH-DRAWER-ID      
                                                 WS-BATCH-NO            
                 MOVE WS-01                   TO Y2-CASH-COMPANY-NO     
                 MOVE I-CASH-LOCAL-OFFICE     TO Y2-CASH-LOCAL-OFFICE   
                                                 WS-CASH-LOCAL-OFFICE   
                 PERFORM 7200-CHECK-CASHIER-OFFICE                      
                    THRU 7200-EXIT                                      
                                                                        
                 IF Y2-PAYMENT-AGENT-FL = WS-Y                          
                    SET THIRD-PARTY-PYMT TO TRUE                        
                 ELSE                                                   
                    SET NORMAL-PYMT TO TRUE                             
                 END-IF                                                 
                                                                        
                 PERFORM 2050-CREATE-REPORT-DRWR                        
                    THRU 2050-EXIT                                      
                                                                        
              END-IF                                                    
                                                                        
              IF DETAIL-REC = WS-RESTART-KEY                            
                 SET COMMIT-REC-FOUND TO TRUE                           
              END-IF                                                    
              GO TO 2000-CONTINUE                                       
           END-IF                                                       
                                                                        
           IF I-REC-TYPE-DET = WS-ONE                                   
              SET DETAIL-REC-FOUND TO TRUE                              
           ELSE                                                         
              IF I-REC-TYPE-DET = WS-THREE                              
                 IF DETAIL-REC-FOUND                                    
                    PERFORM 2500-PERFORM-JRNL-XFER                      
                       THRU 2500-EXIT                                   
                    MOVE 0  TO WS-TOTAL-RECS                            
                               WS-TOTAL-BATCH-RECS                      
                               WS-TOTAL-RVR-AMT                         
                               WS-BATCH-TOT-AMT                         
                               WS-BATCH-NO                              
                 END-IF                                                 
                 SET TOTAL-REC-FOUND TO TRUE                            
              ELSE                                                      
                 MOVE WS-REC-TYPE-ERROR TO WS-ERR-MSG                   
                 PERFORM 8850-DISPLAY-ERR-TERM                          
                    THRU 8850-EXIT                                      
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF TOTAL-REC-FOUND                                           
              MOVE I-TOTAL-PYMT-AMT        TO WS-TOTAL-AMT              
              MOVE WS-TOTAL-AMT-NUM        TO WS-BATCH-TOT-AMT          
              MOVE I-DATE-CASH-REPORT(1:4) TO WS-REPORT-YY              
              MOVE I-DATE-CASH-REPORT(5:2) TO WS-REPORT-MM              
              MOVE I-DATE-CASH-REPORT(7:2) TO WS-REPORT-DD              
              MOVE WS-01                   TO Y2-CASH-COMPANY-NO        
              MOVE I-CASH-LOCAL-OFFICE     TO Y2-CASH-LOCAL-OFFICE      
                                              WS-CASH-LOCAL-OFFICE      
              MOVE I-CASH-DRAWER-ID        TO WS-CASH-DRAWER-ID         
                                              WS-BATCH-NO               
              MOVE I-TOTAL-NO-RECS         TO WS-TOTAL-BATCH-RECS       
              PERFORM 7200-CHECK-CASHIER-OFFICE                         
                 THRU 7200-EXIT                                         
                                                                        
              IF Y2-PAYMENT-AGENT-FL = WS-Y                             
                 SET THIRD-PARTY-PYMT TO TRUE                           
              ELSE                                                      
                 SET NORMAL-PYMT TO TRUE                                
              END-IF                                                    
                                                                        
              PERFORM 2050-CREATE-REPORT-DRWR                           
                 THRU 2050-EXIT                                         
                                                                        
              GO TO 2000-CONTINUE                                       
           END-IF                                                       
                                                                        
           IF DETAIL-REC-FOUND                                          
              ADD 1 TO WS-TOTAL-RECS                                    
              MOVE I-CURRENCY-TYPE    TO WS-CURRENCY-TYPE               
              MOVE I-ACCOUNT-NO       TO AR-ACCOUNT-NO                  
              MOVE I-PAYMENT-TS       TO AR-TRANS-HIST-SEQ-NO           
              MOVE I-PAYMENT-AMOUNT   TO WS-PYMT-AMT                    
              MOVE WS-PYMT-AMT-NUM    TO WS-PYMT-AMOUNT                 
              ADD WS-PYMT-AMT-NUM     TO WS-TOTAL-RVR-AMT               
                                                                        
              PERFORM 7100-SELECT-ORIG-PAYMENT                          
                 THRU 7100-EXIT                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF AR-PYMT-REFUNDED-IND NOT EQUAL 'Y'                  
                    CONTINUE                                            
                 ELSE                                                   
                   DISPLAY  I-ACCOUNT-NO ' WAS ALREADY REVERSED'        
                   GO TO 2000-CONTINUE                                  
                 END-IF                                                 
                 IF AR-AMT-ORIG-ENTERED NOT EQUAL WS-PYMT-AMOUNT        
                   DISPLAY  I-ACCOUNT-NO ' PAYMENT AMOUNT IS NOT '      
                   DISPLAY  'MATCHING WITH ORIGINAL AMOUNT'             
                   GO TO 2000-CONTINUE                                  
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY I-ACCOUNT-NO ' NOT FOUND IN AR TABLE'          
                 GO TO 2000-CONTINUE                                    
              END-IF                                                    
                                                                        
              PERFORM 2300-PROCESS-REVERSAL                             
                 THRU 2300-EXIT                                         
                                                                        
              IF S-RETURN-CODE = SUCCESSFUL-CALL                        
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY 'PAYMENT REVERSAL FAILED '                     
                 DISPLAY 'FOR ACCOUNT NO ' I-ACCOUNT-NO                 
                 DISPLAY 'RETURN CODE ' S-RETURN-CODE                   
                 PERFORM 8850-DISPLAY-ERR-TERM                          
                    THRU 8850-EXIT                                      
              END-IF                                                    
                                                                        
              IF WS-CHKP-LUW-LIMIT = WS-LUW-PROCESSED                   
                 MOVE DETAIL-REC TO RF-RESTART-DATA-TEXT                
                                    WS-RESTART-KEY                      
                 MOVE +52        TO RF-RESTART-DATA-LEN                 
                 PERFORM 8920-WRITE-RESTART-RECORD THRU 8920-EXIT       
                 PERFORM 8999-ISSUE-COMMIT         THRU 8999-EXIT       
                 MOVE 0 TO WS-LUW-PROCESSED                             
                 ADD  1 TO WS-COMMIT-COUNT                              
                 DISPLAY '** COMMIT NO ' WS-COMMIT-COUNT '  TAKEN FOR ' 
                         'KEY ' WS-RESTART-KEY                          
              ELSE                                                      
                 ADD 1  TO WS-LUW-PROCESSED                             
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2000-CONTINUE.                                                   
                                                                        
           PERFORM 1000-READ-FILE     THRU 1000-EXIT                    
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** MOVE VALUES TO JOURNAL VARIABLES                             **        
      **--------------------------------------------------------------**        
       2150-SET-CASH-DRWR-JRNL-VALUES.                                  
      *-------------------------------*                                         
           MOVE '2150'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE CS-CASH-COMPANY-NO       TO CJ-CASH-COMPANY-NO          
                                            CJ-COMPANY-NO               
           MOVE CS-CASH-LOCAL-OFFICE     TO CJ-CASH-LOCAL-OFFICE        
                                            CJ-CASH-REPORT-NO           
           MOVE WS-ONE                   TO CJ-TRAN-APPL-NO             
           MOVE CS-NO-ITEMS-ENTERED      TO CJ-ENTRY-NO                 
           MOVE CS-CASH-DRAWER-ID        TO CJ-CASH-DRAWER-ID           
           MOVE Y2-LOCAL-OFFICE          TO CJ-LOCAL-OFFICE             
                                            CJ-ENTRY-LOC                
           MOVE WS-LIT-A                 TO CJ-JRNL-SORT-ID             
           MOVE WS-ALL9-ACNO             TO CJ-ACCOUNT-NO               
           MOVE WS-ZERO                  TO CJ-GL-ACCT-NO               
           MOVE WS-ZERO                  TO CJ-METER-NO                 
           MOVE 30                       TO CJ-TRAN-COMMENT-LEN         
           MOVE WS-PARM-COMMENT          TO CJ-TRAN-COMMENT-TEXT        
                                                                        
           MOVE WS-TRAN-TIME             TO CJ-TRAN-TIME                
           MOVE WS-TRAN-ID               TO CJ-TRAN-ID                  
           MOVE CS-DATE-CASH-REPORT      TO CJ-DATE-CASH-REPORT         
           MOVE WS-REPORT-DATE           TO CJ-DATE-TRAN                
           MOVE WS-REPORT-DATE           TO CJ-DATE-LAST-ACTION         
           MOVE WS-LIT-A                 TO CJ-CODE-ENTRY-SOURCE        
           MOVE CS-USER-ID               TO CJ-USER-ID                  
           MOVE SPACES                   TO CJ-BATCH-SEND-LOC           
           MOVE SPACES                   TO CJ-ENTRY-LOC                
           MOVE SPACES                   TO CJ-CODE-TRAN-ERRORS         
           MOVE SPACES                   TO CJ-CODE-JRNL-EXTRACT        
           MOVE SPACES                   TO CJ-CODE-STATUS              
           MOVE WS-CURRENCY-TYPE         TO CJ-CURRENCY-TYPE            
           MOVE CS-CODE-PYMT-FACILITY    TO CJ-CODE-PYMT-FACILITY       
           MOVE SPACES                   TO CJ-CSR-PC-ID                
           MOVE WS-ZERO                  TO CJ-CUSTOMER-NO              
           MOVE SPACES                   TO CJ-BALANCED-BY              
           MOVE WS-REPORT-DATE           TO CJ-DATE-BALANCED            
           MOVE WS-TRAN-TIME             TO CJ-TIME-BALANCED            
           MOVE Y2-USER-ID               TO CJ-BALANCED-BY              
           .                                                            
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** MOVE VALUES TO TTAN DATA                                     **        
      **--------------------------------------------------------------**        
       2160-POPULATE-TRAN-DATA.                                         
      *-----------------------*                                                 
           MOVE '2160'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE SPACES                   TO CJF00101                    
           MOVE WS-101                   TO WS-101-JRNL-FORMAT-NO       
           MOVE WS-ONE                   TO WS-101-CASH-DRAWER-USED     
           MOVE WS-BATCH-TOT-AMT         TO WS-101-AMOUNT-ENTERED       
                                            WS-101-AMT-POSTED           
           MOVE WS-CASH-GL-ACCT          TO WS-101-ACCT-GEN-LED-DR      
           MOVE WS-CASH-GL-ACCT          TO WS-101-ACCT-GEN-LED-CR      
           MOVE ZEROES                   TO WS-101-ITEM-ID-NO           
                                            WS-101-DETAIL-END-AR-BAL    
                                            WS-101-ACCT-END-AR-BAL      
                                            WS-101-REVENUE-MONTH        
           MOVE Y2-DEP-DEFT-BANK-ID      TO WS-101-FCS-DEP-BANK-CD      
           MOVE D1-FCS-DEP-BANK-ST-CD    TO WS-101-FCS-DEP-BANK-ST-CD   
           .                                                            
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** MOVE VALUES TO BANK TRANSFER VARIBLES                        **        
      **--------------------------------------------------------------**        
       2220-WRITE-BANK-XFR.                                             
      *---------------------*                                                   
           MOVE '2200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-01                    TO YB-CASH-COMPANY-NO          
           MOVE Y2-CASH-LOCAL-OFFICE     TO YB-CASH-LOCAL-OFFICE        
           MOVE CS-CASH-DRAWER-ID        TO YB-CASH-DRAWER-ID           
           MOVE CS-DATE-CASH-REPORT      TO YB-DATE-CASH-REPORT         
           MOVE Y2-USER-ID               TO YB-USER-ID                  
           MOVE Y2-DEP-DEFT-BANK-ID      TO YB-BANK-ID                  
           MOVE WS-BATCH-TOT-AMT         TO YB-TRANSFER-AMT             
           MOVE CS-DATE-CASH-REPORT      TO YB-BANK-POST-DT             
           MOVE WS-XFR-TS                TO YB-TRANSFER-TS              
           MOVE WS-CURRENCY-TYPE         TO YB-CURRENCY-TYPE            
           MOVE WS-LIT-D                 TO YB-CODE-DR-CR               
                                                                        
           PERFORM 8100-CREATE-BANK-TRANSFER                            
              THRU 8100-EXIT                                            
           .                                                            
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** CHECKS FOR VALID CASH DRAWER AND CASH REPORT FOR GIVEN CASH  **        
      ** LOCAL OFFICE AND CASH REPORT DATE. IF NOT AVAILABLE IT       **        
      ** CREATES NEW BATCH AND REPORT.                                **        
      **--------------------------------------------------------------**        
       2050-CREATE-REPORT-DRWR.                                         
      *------------------------*                                                
                                                                        
           MOVE WS-REPORT-DATE               TO CS-DATE-CASH-REPORT     
                                                YR-DATE-CASH-REPORT     
           MOVE WS-CASH-LOCAL-OFFICE         TO CS-CASH-LOCAL-OFFICE    
                                                CS-CASH-REPORT-NO       
                                                YR-CASH-LOCAL-OFFICE    
           MOVE WS-CASH-DRAWER-ID            TO CS-CASH-DRAWER-ID       
           MOVE WS-01                        TO CS-CASH-COMPANY-NO      
                                                YR-CASH-COMPANY-NO      
           MOVE WS-A                         TO CS-CODE-CSH-DRWR-STAT   
                                                                        
           PERFORM 7000-SELECT-ACTIVE-DRWR   THRU 7000-EXIT             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
                                                                        
              PERFORM 7010-CHECK-CASH-RPT    THRU 7010-EXIT             
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE Y2-USER-ID             TO YR-USER-ID              
                 MOVE WS-A                   TO YR-STATUS               
                 PERFORM 8000-CREATE-NEW-RPT THRU 8000-EXIT             
              END-IF                                                    
                                                                        
              INITIALIZE DCLCSS-CSH-DRWR-CNTL                           
              MOVE WS-01                     TO CS-CASH-COMPANY-NO      
              MOVE WS-REPORT-DATE            TO CS-DATE-CASH-REPORT     
              MOVE WS-CASH-LOCAL-OFFICE      TO CS-CASH-LOCAL-OFFICE    
                                                CS-CASH-REPORT-NO       
              MOVE WS-CASH-DRAWER-ID         TO CS-CASH-DRAWER-ID       
                                                                        
              MOVE WS-A                      TO CS-CODE-CSH-DRWR-STAT   
              MOVE Y2-USER-ID                TO CS-USER-ID              
              MOVE SPACES                    TO CS-CASHIER-CODE         
              MOVE WS-NO                     TO CS-CODE-FCS-EXTRACTED   
              MOVE SPACES                    TO CS-BALANCED-BY          
              MOVE WS-P                      TO CS-CODE-PYMT-FACILITY   
              MOVE -1                        TO WS-NULL-IND-1           
                                                                        
              PERFORM 8010-CREATE-NEW-BATCH  THRU 8010-EXIT             
                                                                        
           END-IF                                                       
           .                                                            
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** CREATES JOURNAL ENTRY                                        **        
      **--------------------------------------------------------------**        
       2100-PROCESS-JOURNAL.                                            
      *---------------------*                                                   
           MOVE '2100'                      TO WS-ACTIVE-PARAGRAPH      
                                                                        
           MOVE WS-JRNL-NAME                TO WS-PAR-EIBTRNID          
           MOVE WS-M                        TO WS-PAR-PYMT-FACILITY-CD  
           MOVE WS-01                       TO WS-100-COMPANY-NO        
           MOVE 9                           TO WS-TRAN-OPER-LEVEL       
           MOVE 1                           TO WS-TRAN-OCAP-FIELD       
           MOVE 1                           TO WS-TRAN-OCAP-VALUE       
           MOVE WS-C                        TO WS-TRAN-JRNL-TYPE        
           MOVE WS-N                        TO WS-TRAN-HOLD-EXEMPT-FLAG 
           MOVE WS-SYSTEM                   TO WS-JRNL-OL-TEMP-ID       
           MOVE WS-JRNL-CK-OPER-ID          TO WS-JRNL-OPERATION-RQST   
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
           MOVE WS-JRNL-OL-OPR-LOC          TO WS-TERM-LOC              
           MOVE WS-01                       TO WS-JRNL-OL-COMPANY       
           MOVE WS-CASH-LOCAL-OFFICE        TO WS-JRNL-OL-LOC-OFF       
                                               WS-JRNL-OL-REPORT-NO     
           MOVE WS-REPORT-DATE              TO WS-JRNL-OL-REPORT-DT     
           MOVE CS-CASH-DRAWER-ID           TO WS-JRNL-OL-CASH-DRWR     
           MOVE SPACES                      TO WS-JRNL-OL-CSR-PC-ID     
           MOVE WS-TERM-LOC                 TO WS-JRNL-OL-TERM-LOC      
                                               WS-JRNL-OL-CASH-LOC      
                                               WS-JRNL-OL-OPR-LOC       
           MOVE WS-TRAN-ID                  TO WS-PAR-APPL-PROG-ID      
           MOVE WS-NO                       TO WS-PAR-PYMT-RCPT-PRNTD-CD
           MOVE WS-PAR-P                    TO WS-PAR-CODE-TRAN-TYPE    
           MOVE WS-JRNL-VALIDATE-OPER       TO WS-JRNL-OPERATION-RQST   
           MOVE WS-C                        TO WS-JRNL-SOURCE-CODE      
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE      TO WS-JRNL-OL-AUTH-TYPE     
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE  TO WS-JRNL-OL-AUTH-TYPE     
           END-IF                                                       
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
                                                                        
           MOVE WS-A                   TO WS-100-JRNL-SORT-ID           
           MOVE ZEROES                 TO WS-100-ACCT-NO                
           MOVE ZEROES                 TO WS-100-CUSTOMER-NO            
           MOVE ZEROES                 TO WS-100-PREMISE-NO             
           ADD 1                       TO WS-100-JRNL-TRAN-APPL-NO      
           MOVE WS-CURRENT-DATE        TO WS-100-DATE-LAST-ACTION       
           MOVE WS-C                   TO WS-100-CODE-ENTRY-SOURCE      
           MOVE Y2-LOCAL-OFFICE        TO WS-100-LOCAL-OFFICE-CD        
           MOVE WS-JRNL-OL-COMPANY     TO WS-PAR-COMPANY-NO             
           MOVE WS-JRNL-OL-LOC-OFF     TO WS-PAR-LOCAL-OFFICE           
           MOVE WS-JRNL-OL-REPORT-NO   TO WS-PAR-REPORT-NO              
           MOVE WS-JRNL-OL-REPORT-DT   TO WS-PAR-REPORT-DATE            
           MOVE WS-JRNL-OL-CASH-DRWR   TO WS-PAR-CASH-DRAWER            
           MOVE WS-TERM-LOC            TO WS-PAR-ACCESS-LOC             
           MOVE WS-SYSTEM              TO WS-PAR-OPERATOR-ID            
           MOVE SPACES                 TO WS-PAR-RESP-AREA              
                                                                        
           INITIALIZE CJF00101                                          
                                                                        
           MOVE WS-CURRENCY-TYPE        TO WS-JRNL-CURRENCY-TYPE        
           MOVE WS-PYMT-AMOUNT          TO WS-101-AMT-POSTED            
                                           WS-PAYMENT-AMOUNT            
                                                                        
           PERFORM 2180-MOVE-TRAN-DATA-VALUES                           
              THRU 2180-EXIT                                            
                                                                        
           IF THIRD-PARTY-PYMT                                          
              MOVE Y2-DEP-CASH-GL-OFFSET TO WS-101-ACCT-GEN-LED-CR      
              MOVE WS-CASH-GL-ACCT       TO WS-101-ACCT-GEN-LED-DR      
              MOVE 30                    TO WS-JRNL-TRAN-COMMENT-LEN    
              MOVE WS-PARM-COMMENT       TO WS-JRNL-TRAN-COMMENT-TEXT   
           ELSE                                                         
              MOVE WS-CASH-GL-ACCT       TO WS-101-ACCT-GEN-LED-DR      
              MOVE WS-CASH-GL-ACCT       TO WS-101-ACCT-GEN-LED-CR      
              MOVE 30                    TO WS-JRNL-TRAN-COMMENT-LEN    
              MOVE WS-PARM-COMMENT       TO WS-JRNL-TRAN-COMMENT-TEXT   
           END-IF                                                       
                                                                        
           MOVE WS-JRNL-NAME             TO WS-100-CODE-TERMINAL-TRAN   
                                                                        
           MOVE CJF00101                 TO WS-100-USER-DEFINED-AREA    
           MOVE WS-JRNL-ONLY             TO WS-JRNL-OPERATION-RQST      
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE                             
              THRU 6400-EXIT                                            
           MOVE WS-JRNL-CNTRL-ONLY       TO WS-JRNL-OPERATION-RQST      
           PERFORM 6400-ONLINE-JRNL-ROUTINE                             
              THRU 6400-EXIT                                            
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **-------------------------------------------------------------**         
      ** MOVE VALUES TO 101 JOURNAL VARIABLES                        **         
      **-------------------------------------------------------------**         
       2180-MOVE-TRAN-DATA-VALUES.                                      
      *---------------------------*                                             
                                                                        
           MOVE 101                      TO WS-101-JRNL-FORMAT-NO       
           MOVE WS-PYMT-AMOUNT           TO WS-101-AMOUNT-ENTERED       
           MOVE SPACES                   TO WS-101-AR-AGE               
                                            WS-101-CASH-DRAWER-USED     
                                            WS-101-DATE-AR-BILLED       
                                            WS-101-FCS-DEP-BANK-CD      
                                            WS-101-FCS-DEP-BANK-ST-CD   
                                            WS-101-FUNCTION-CODE        
                                            WS-101-CODE-REVENUE-DISTRICT
                                            WS-101-CODE-EMPL-ACCT       
                                            WS-101-CODE-COMPANY-ACCT    
                                            WS-101-CODE-ACCOUNT-STATUS  
                                            WS-101-CODE-PREMISE-STATUS  
           MOVE ZERO                     TO WS-101-ITEM-DETAIL-DATA     
                                            WS-101-ITEM-ID-NO           
                                            WS-101-DETAIL-END-BAL       
                                            WS-101-DETAIL-END-AR-BAL    
                                            WS-101-ACCT-END-AR-BAL      
                                            WS-101-REVENUE-MONTH        
           .                                                            
       2180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** UPDATES THIRD PARTY PAYMENT AMOUNTS IN OVER/SHORT TABLES     **        
      **--------------------------------------------------------------**        
       2230-ADJ-THIRD-PARTY-AMT.                                        
      *-------------------------*                                               
                                                                        
           MOVE CS-CASH-COMPANY-NO            TO OH-CASH-COMPANY-NO     
           MOVE CS-CASH-LOCAL-OFFICE          TO OH-CASH-LOCAL-OFFICE   
           MOVE CS-DATE-CASH-REPORT           TO OH-DATE-CASH-REPORT    
           MOVE CS-CASH-DRAWER-ID             TO OH-CASH-DRAWER-ID      
           MOVE 1                             TO OH-OVERSHORT-ID        
           PERFORM 7240-SELECT-OVSH           THRU 7240-EXIT            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF OH-OVERSHORT-DR-CR = 'D'                               
                 COMPUTE OH-OVERSHORT-AMT = OH-OVERSHORT-AMT -          
                                            WS-PYMT-AMOUNT              
                 IF OH-OVERSHORT-AMT > 0                                
                    MOVE 'D'                  TO OH-OVERSHORT-DR-CR     
                 ELSE                                                   
                    MOVE 'C'                  TO OH-OVERSHORT-DR-CR     
                    COMPUTE OH-OVERSHORT-AMT = (OH-OVERSHORT-AMT * -1)  
                 END-IF                                                 
              ELSE                                                      
                 COMPUTE OH-OVERSHORT-AMT = OH-OVERSHORT-AMT +          
                                            WS-PYMT-AMOUNT              
                 MOVE 'C'                     TO OH-OVERSHORT-DR-CR     
              END-IF                                                    
              PERFORM 8080-UPDATE-OVERSHORT   THRU 8080-EXIT            
           ELSE                                                         
              PERFORM 2800-MOVE-DTL-TO-OVSH   THRU 2800-EXIT            
              PERFORM 8070-INSERT-OVERSHORT   THRU 8070-EXIT            
           END-IF                                                       
           .                                                            
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** CALLS REVERSAL STORED PROCEDURE                              **        
      **--------------------------------------------------------------**        
       2300-PROCESS-REVERSAL.                                           
      *----------------------*                                                  
                                                                        
           MOVE '2300'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           MOVE 0                       TO S-RETURN-CODE                
                                                                        
           DISPLAY 'ACCOUNT NO ' I-ACCOUNT-NO                           
                                                                        
           MOVE I-ACCOUNT-NO TO WS-ACCOUNT-CHAR                         
           MOVE I-PAYMENT-TS TO WS-TIMESTAMP                            
                                                                        
      *    EXEC SQL CALL CSR03486                                       
      *                ( :WS-ACCOUNT-CHAR                               
      *                 ,:WS-TIMESTAMP                                  
      *                 ,:WS-PROGRAM-NAME                               
      *                 ,:WS-SYS                                        
      *                 ,:WS-PARM-COMMENT                               
      *                )                                                
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C3
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C3
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C3 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           IF SQLCODE = 466 THEN                                        
                                                                        
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
      *         CSR03486                                                
      *       END-EXEC                                                  
                                                                        
      *       EXEC SQL ALLOCATE C3 CURSOR FOR RESULT SET :LOC1          
      *       END-EXEC                                                  
                                                                        
              EXEC SQL                                                  
              FETCH C3 INTO :S-RETURN-CODE                              
                           ,:S-DNP-FLAG                                 
                           ,:S-AR-LOCKOUT-IND                           
                           ,:S-ACCT-XFER-TO                             
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              DISPLAY '          RETURN CODE ' S-RETURN-CODE            
           ELSE                                                         
              MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              STRING  'ERROR RETURNING FROM CSR03486   **'              
                                            DELIMITED BY SIZE           
                                       INTO WS-ERR-MSG                  
              STRING 'ACCOUNT_NO    = '     DELIMITED BY SIZE           
                     WS-ACCOUNT-CHAR        DELIMITED BY SIZE           
                     ' TIMESTAMP    = '     DELIMITED BY SIZE           
                     WS-TIMESTAMP           DELIMITED BY SIZE           
                     ' PROGRAM_NAME   = '   DELIMITED BY SIZE           
                     WS-PROGRAM-NAME        DELIMITED BY SIZE           
                                       INTO WS-ERR-MSG2                 
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** CREATES A JOURNAL FOR THE THIRD PARTY AMOUNT                 **        
      **--------------------------------------------------------------**        
       2500-PERFORM-JRNL-XFER.                                          
      *-----------------------*                                                 
           MOVE '2500'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           PERFORM 8860-DISPLAY-BATCH-TOTALS                            
              THRU 8860-EXIT                                            
                                                                        
           PERFORM 7700-GET-CURRENT-TIMESTAMP                           
              THRU 7700-EXIT                                            
           IF THIRD-PARTY-PYMT                                          
              PERFORM 2100-PROCESS-JOURNAL                              
                 THRU 2100-EXIT                                         
              PERFORM 2230-ADJ-THIRD-PARTY-AMT                          
                 THRU 2230-EXIT                                         
           ELSE                                                         
              MOVE Y2-USER-ID                  TO Y1-USER-ID            
              MOVE WS-01                       TO Y1-CASH-COMPANY-NO    
                                                                        
              PERFORM 7550-SELECT-CASHIER-CODE                          
                 THRU 7550-EXIT                                         
                                                                        
              PERFORM 7560-SELECT-BANK-ST-CD                            
                 THRU 7560-EXIT                                         
                                                                        
              PERFORM 2100-PROCESS-JOURNAL                              
                 THRU 2100-EXIT                                         
                                                                        
              MOVE WS-CASH-DRAWER-ID           TO CS-CASH-DRAWER-ID     
              MOVE WS-LIT-C                    TO CS-CODE-CSH-DRWR-STAT 
                                                                        
              PERFORM 2220-WRITE-BANK-XFR                               
                 THRU 2220-EXIT                                         
           END-IF                                                       
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **-------------------------------------------------------------**         
      ** MOVE DETAILS TO OVERSHORT                                   **         
      **-------------------------------------------------------------**         
       2800-MOVE-DTL-TO-OVSH.                                           
      *----------------------*                                                  
                                                                        
           MOVE WS-SYSTEM                     TO OH-USER-ID             
           MOVE WS-COMMENT-LEN                TO OH-TRAN-COMMENT-LEN    
           MOVE WS-COMMENT-TEXT               TO OH-TRAN-COMMENT-TEXT   
           MOVE WS-P                          TO OH-OVERSHORT-SOLTN-FL  
           MOVE WS-PYMT-AMOUNT                TO OH-OVERSHORT-AMT       
           MOVE WS-C                          TO OH-OVERSHORT-DR-CR     
           MOVE Y2-DEP-CASH-GL-OFFSET         TO OH-GL-ACCT-NO          
                                                 OT-GL-ACCT-NO          
                                                 WS-DISP-GL-ACCT        
                                                                        
           PERFORM 7210-OPEN-OVSH-TYPE        THRU 7210-EXIT            
           PERFORM 7220-FETCH-OVSH-TYPE       THRU 7220-EXIT            
           PERFORM 7230-CLOSE-OVSH-TYPE       THRU 7230-EXIT            
                                                                        
           MOVE OT-OVERSHORT-TYPE-CD          TO OH-OVERSHORT-TYPE-CD   
           MOVE 1                             TO OH-OVERSHORT-ID        
           MOVE ZERO                          TO OH-OFST-OVERSHORT-AMT  
                                                 OH-ACCOUNT-NO          
           MOVE SPACES                        TO OH-OFST-DR-CR          
           .                                                            
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **----------------------------------------------------------**            
      ** BATCH JOURNAL ROUTINE. 6400-BATCH-JRNL-ROUTINE.          **            
      **----------------------------------------------------------**            
           EXEC SQL                                                             
A00956         INCLUDE CPD0006A                                                 
           END-EXEC.                                                            
                                                                        
      **--------------------------------------------------------------**        
      ** SELECTS ACTIVE CASH DRAWER ID FOR GIVEN CASH LOCAL OFFICE AND**        
      ** DATE CASH REPORT                                             **        
      **--------------------------------------------------------------**        
       7000-SELECT-ACTIVE-DRWR.                                         
      *------------------------*                                                
                                                                        
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT CASH_DRAWER_ID                                      
               INTO :CS-CASH-DRAWER-ID                                  
               FROM CSS_CSH_DRWR_CNTL                                   
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                AND CODE_CSH_DRWR_STAT = :CS-CODE-CSH-DRWR-STAT         
                AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CASH_DRAWER_ID                                              
MFA-TR*        INTO :CS-CASH-DRAWER-ID                                          
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                           
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                   
MFA-TR*         AND CODE_CSH_DRWR_STAT = :CS-CODE-CSH-DRWR-STAT                 
MFA-TR*         AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE CS-CASH-DRAWER-ID TO WS-DISP-CASH-DRAWER-ID          
              STRING  'ERROR SELECTING CASH DRAWER **'                  
                                            DELIMITED BY SIZE           
                                      INTO  WS-ERR-MSG                  
              STRING 'CASH_LOCAL_OFFICE = ' DELIMITED BY SIZE           
                     CS-CASH-LOCAL-OFFICE   DELIMITED BY SIZE           
                     'DATE_CASH_REPORT = '  DELIMITED BY SIZE           
                     CS-DATE-CASH-REPORT    DELIMITED BY SIZE           
                     'CASH_DRAWER_ID = '    DELIMITED BY SIZE           
                     WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE           
                                      INTO  WS-ERR-MSG2                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** SELECTS CASH REPORT FOR GIVEN CASH LOCAL OFFICE AND          **        
      ** DATE CASH REPORT                                             **        
      **--------------------------------------------------------------**        
       7010-CHECK-CASH-RPT.                                             
      *--------------------*                                                    
                                                                        
           MOVE '7010'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT STATUS                                              
               INTO :YR-STATUS                                          
               FROM CSS_CSH_REPORT_HDR                                  
              WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT STATUS                                                      
MFA-TR*        INTO :YR-STATUS                                                  
MFA-TR*        FROM CSS_CSH_REPORT_HDR                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :YR-DATE-CASH-REPORT                   
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               STRING  'ERROR SELECTING CASH REPORT **'                 
                                             DELIMITED BY SIZE          
                                        INTO WS-ERR-MSG                 
               STRING 'CASH_LOCAL_OFFICE = ' DELIMITED BY SIZE          
                      YR-CASH-LOCAL-OFFICE   DELIMITED BY SIZE          
                      'DATE_CASH_REPORT = '  DELIMITED BY SIZE          
                      YR-DATE-CASH-REPORT    DELIMITED BY SIZE          
                                        INTO WS-ERR-MSG2                
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** SELECT ORIGINAL PAYMENT ROW FROM TRANS HIST                  **        
      **--------------------------------------------------------------**        
       7100-SELECT-ORIG-PAYMENT.                                        
      *-------------------------*                                               
           MOVE '7100'                  TO WS-ACTIVE-PARAGRAPH          
                                                                        
           EXEC SQL                                                     
             SELECT CASH_COMPANY_NO                                     
                   ,CASH_LOCAL_OFFICE                                   
                   ,DATE_CASH_REPORT                                    
                   ,CASH_DRAWER_ID                                      
                   ,PYMT_REFUNDED_IND                                   
                   ,AMT_ORIG_ENTERED                                    
                   ,CODE_TRAN_TYPE                                      
               INTO :AR-CASH-COMPANY-NO                                 
                   ,:AR-CASH-LOCAL-OFFICE                               
                   ,:AR-DATE-CASH-REPORT                                
                   ,:AR-CASH-DRAWER-ID                                  
                   ,:AR-PYMT-REFUNDED-IND                               
                   ,:AR-AMT-ORIG-ENTERED                                
                   ,:AR-CODE-TRAN-TYPE                                  
               FROM CSS_AR_TRANS_HIST                                   
              WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                  
                AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CASH_COMPANY_NO                                             
MFA-TR*            ,CASH_LOCAL_OFFICE                                           
MFA-TR*            ,DATE_CASH_REPORT                                            
MFA-TR*            ,CASH_DRAWER_ID                                              
MFA-TR*            ,PYMT_REFUNDED_IND                                           
MFA-TR*            ,AMT_ORIG_ENTERED                                            
MFA-TR*            ,CODE_TRAN_TYPE                                              
MFA-TR*        INTO :AR-CASH-COMPANY-NO                                         
MFA-TR*            ,:AR-CASH-LOCAL-OFFICE                                       
MFA-TR*            ,:AR-DATE-CASH-REPORT                                        
MFA-TR*            ,:AR-CASH-DRAWER-ID                                          
MFA-TR*            ,:AR-PYMT-REFUNDED-IND                                       
MFA-TR*            ,:AR-AMT-ORIG-ENTERED                                        
MFA-TR*            ,:AR-CODE-TRAN-TYPE                                          
MFA-TR*        FROM CSS_AR_TRANS_HIST                                           
MFA-TR*       WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                          
MFA-TR*         AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO                   
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-PYMT-ACCT-CNT                              
              END-IF                                                    
           ELSE                                                         
              MOVE AR-ACCOUNT-NO TO WS-ACCOUNT-NO                       
              STRING ' ERROR SELECTING CSS_AR_TRANS_HIST  ** '          
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' ACCOUNT_NO   = ' WS-ACCOUNT-NO                   
                     ' ,TRANS_HIST_SEQ_NO = ' AR-TRANS-HIST-SEQ-NO      
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** SELECTS CASHIER OFFICE                                       **        
      **--------------------------------------------------------------**        
       7200-CHECK-CASHIER-OFFICE.                                       
      *--------------------------*                                              
           MOVE '7200'                  TO WS-ACTIVE-PARAGRAPH          
                                                                        
           EXEC SQL                                                     
            SELECT BATCH_DEP_CASH_OFF                                   
                  ,DEP_XFER_METHOD                                      
                  ,USER_ID                                              
                  ,DEP_DEFT_BANK_ID                                     
                  ,LOCAL_OFFICE                                         
                  ,DEP_CASH_GL_OFFSET                                   
                  ,PAYMENT_AGENT_FL                                     
                  ,PYMT_TO_POST_DAYS                                    
                  ,ERROR_GL_OFFSET                                      
             INTO :Y2-BATCH-DEP-CASH-OFF                                
                 ,:Y2-DEP-XFER-METHOD                                   
                 ,:Y2-USER-ID                                           
                 ,:Y2-DEP-DEFT-BANK-ID                                  
                 ,:Y2-LOCAL-OFFICE                                      
                 ,:Y2-DEP-CASH-GL-OFFSET                                
                 ,:Y2-PAYMENT-AGENT-FL                                  
                 ,:Y2-PYMT-TO-POST-DAYS                                 
                 ,:Y2-ERROR-GL-OFFSET                                   
             FROM CSS_CASHIER_OFFICE                                    
            WHERE CASH_COMPANY_NO      = :Y2-CASH-COMPANY-NO            
              AND CASH_LOCAL_OFFICE    = :Y2-CASH-LOCAL-OFFICE          
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF (Y2-DEP-CASH-GL-OFFSET EQUAL ZERO AND                 
                   Y2-PAYMENT-AGENT-FL = WS-Y) OR                       
                  Y2-ERROR-GL-OFFSET  EQUAL ZERO                        
                  STRING ' ERROR GL OFFSET OR DEP GL OFFSET IS ZERO **' 
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
                  STRING ' CASH COMPANY NO   '  DELIMITED BY SIZE       
                         Y2-CASH-COMPANY-NO     DELIMITED BY SIZE       
                         'CASH LOCAL OFFICE '   DELIMITED BY SIZE       
                         Y2-CASH-LOCAL-OFFICE   DELIMITED BY SIZE       
                                         INTO WS-ERR-MSG2               
                  PERFORM 8800-DIS-TABLE-ERROR                          
                     THRU 8800-EXIT                                     
               END-IF                                                   
           ELSE                                                         
               STRING ' ERROR GETTING CASH OFFICE, USER ID  **'         
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH COMPANY NO   '  DELIMITED BY SIZE          
                      Y2-CASH-COMPANY-NO     DELIMITED BY SIZE          
                      'CASH LOCAL OFFICE '   DELIMITED BY SIZE          
                      Y2-CASH-LOCAL-OFFICE   DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** OPEN OVER SHORT TYPE CURSOR                                  **        
      **--------------------------------------------------------------**        
       7210-OPEN-OVSH-TYPE.                                             
      *--------------------*                                                    
                                                                        
           MOVE '7210'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               OPEN OVSHTYPE_CURSOR                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               STRING  'ERROR OPENING OVSHTYPE_CURSOR **'               
                                      DELIMITED BY SIZE                 
                                      INTO WS-ERR-MSG                   
               STRING 'GL-ACCT_NO = ' DELIMITED BY SIZE                 
                 WS-DISP-GL-ACCT      DELIMITED BY SIZE                 
                                      INTO WS-ERR-MSG2                  
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      **     FETCH OVERSHORT TYPE CURSOR                              **        
      **--------------------------------------------------------------**        
       7220-FETCH-OVSH-TYPE.                                            
      *---------------------*                                                   
                                                                        
           MOVE '7220'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              FETCH OVSHTYPE_CURSOR                                     
               INTO :OT-OVERSHORT-TYPE-CD                               
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               STRING  'ERROR FETCHING OVSHTYPE_CURSOR **'              
                                      DELIMITED BY SIZE                 
                                      INTO WS-ERR-MSG                   
               STRING 'GL-ACCT_NO = ' DELIMITED BY SIZE                 
                 WS-DISP-GL-ACCT      DELIMITED BY SIZE                 
                                      INTO WS-ERR-MSG2                  
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      **     CLOSE OVERSHORT TYPE                                     **        
      **--------------------------------------------------------------**        
       7230-CLOSE-OVSH-TYPE.                                            
      *---------------------*                                                   
                                                                        
           MOVE '7230'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              CLOSE OVSHTYPE_CURSOR                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               STRING  'ERROR SELECTING OVSHTYPE_CURSOR **'             
                                      DELIMITED BY SIZE                 
                                      INTO WS-ERR-MSG                   
               STRING 'GL-ACCT_NO = ' DELIMITED BY SIZE                 
                 WS-DISP-GL-ACCT      DELIMITED BY SIZE                 
                                      INTO WS-ERR-MSG2                  
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** SELECT OVER/SHORT AMOUNT FOR GIVEN PYMT OFFICE, DATE, DRAWER **        
      **--------------------------------------------------------------**        
       7240-SELECT-OVSH.                                                
      *-----------------*                                                       
                                                                        
           MOVE '7240'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT OVERSHORT_AMT,                                      
                    OVERSHORT_DR_CR                                     
               INTO :OH-OVERSHORT-AMT,                                  
                    :OH-OVERSHORT-DR-CR                                 
               FROM CSS_OVERSHORT_HDR                                   
              WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO             
                AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE           
                AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )            
                AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID              
                AND OVERSHORT_ID      = :OH-OVERSHORT-ID                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT OVERSHORT_AMT,                                              
MFA-TR*             OVERSHORT_DR_CR                                             
MFA-TR*        INTO :OH-OVERSHORT-AMT,                                          
MFA-TR*             :OH-OVERSHORT-DR-CR                                         
MFA-TR*        FROM CSS_OVERSHORT_HDR                                           
MFA-TR*       WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                      
MFA-TR*         AND OVERSHORT_ID      = :OH-OVERSHORT-ID                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE OH-CASH-DRAWER-ID   TO WS-DISP-CASH-DRAWER-ID        
              STRING  'ERROR SELECTING OVER SHORT DETAIL **'            
                                            DELIMITED BY SIZE           
                                       INTO WS-ERR-MSG                  
              STRING 'CASH_LOCAL_OFFICE = ' DELIMITED BY SIZE           
                     OH-CASH-LOCAL-OFFICE   DELIMITED BY SIZE           
                     ' DATE_CASH_REPORT = ' DELIMITED BY SIZE           
                     OH-DATE-CASH-REPORT    DELIMITED BY SIZE           
                     ' CASH_DRAWER_ID = '   DELIMITED BY SIZE           
                     WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE           
                     ' OVERSHORT_ID = '     DELIMITED BY SIZE           
                     WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE           
                                       INTO WS-ERR-MSG2                 
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** SELECTS CASHIER CODE FOR A CASHIER                           **        
      **--------------------------------------------------------------**        
       7550-SELECT-CASHIER-CODE.                                        
      *-------------------------*                                               
           MOVE '7550'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT CASHIER_CODE                                        
               INTO :Y1-CASHIER-CODE                                    
               FROM CSS_CASHIER                                         
              WHERE USER_ID            = :Y1-USER-ID                    
                AND CASH_COMPANY_NO    = :Y1-CASH-COMPANY-NO            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING ' ERROR GETTING CASHIER CODE **'                  
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' FOR USER ID       '  DELIMITED BY SIZE          
                      Y1-USER-ID,            DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      Y1-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      **  SELECTS BANK STATE CODE                                     **        
      **--------------------------------------------------------------**        
       7560-SELECT-BANK-ST-CD.                                          
      *-----------------------*                                                 
           MOVE '7560'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE Y2-DEP-DEFT-BANK-ID      TO D1-BANK-ID                  
                                                                        
           EXEC SQL                                                     
             SELECT FCS_DEP_BANK_ST_CD                                  
               INTO :D1-FCS-DEP-BANK-ST-CD                              
               FROM CSS_BANK                                            
              WHERE BANK_ID = :D1-BANK-ID                               
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE Y2-DEP-DEFT-BANK-ID TO WS-DEP-BANK-ID               
               STRING  'ERROR GETTING BANK ST CD  **'                   
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
               STRING 'BANK ID '      DELIMITED BY SIZE                 
                 WS-DEP-BANK-ID  DELIMITED BY SIZE                      
                                      INTO    WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** SELECTS THE COMMIT DATA                                      **        
      **--------------------------------------------------------------**        
       7600-GET-COMMIT-PARM.                                            
           MOVE '7600'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT PARM_DATA                                           
               INTO :G6-PARM-DATA                                       
               FROM CSS_JOB_PARM                                        
              WHERE PROGRAM_NAME = 'PCSAC184'                           
                AND COMPANY_NO   = '01'                                 
                AND CMND_CODE    = 'PARM'                               
                AND SEQ_NO       = 10                                   
                AND STATUS       = 'A'                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               STRING '**ERROR GETTING COMMIT PARM FROM CSS_JOB_PARM **'
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
               STRING 'PROGRAM_NAME = PCSAC184'  DELIMITED BY SIZE      
                      'CMND_CODE = PARM'         DELIMITED BY SIZE      
                      'SEQ_NO = 10 '             DELIMITED BY SIZE      
                                      INTO    WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** SELECTS DATE, TIME AND TIMESTAMP                             **        
      **--------------------------------------------------------------**        
       7700-GET-CURRENT-TIMESTAMP.                                      
      *---------------------------*                                             
           MOVE '7700'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-XFR-TS                                          
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      VALUES CURRENT TIMESTAMP                                           
MFA-TR*        INTO :WS-XFR-TS                                                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
             SELECT
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-TRAN-TIME                                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      VALUES CURRENT TIME                                                
MFA-TR*        INTO :WS-TRAN-TIME                                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
             SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      VALUES CURRENT DATE                                                
MFA-TR*        INTO :WS-CURRENT-DATE                                            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE                      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'ERROR GETTING TIMESTAMP VALUE **'                
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
                                                                        
           END-IF                                                       
           .                                                            
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** SELECTS GL ACCT NO FOR GIVEN NAME                            **        
      **--------------------------------------------------------------**        
       7900-SELECT-CLRCASH.                                             
      *--------------------*                                                    
           MOVE '7900'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT GL_ACCT_NO                                          
               INTO :GO-GL-ACCT-NO                                      
               FROM CSS_GL_ACCT_NO                                      
              WHERE COMPANY_NO           = :GO-COMPANY-NO               
                AND GL_ACCT_NAME         = :GO-GL-ACCT-NAME             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                  CONTINUE                                              
           ELSE                                                         
              STRING 'ERROR SELECTING ACCOUNT NUMBER **'                
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              STRING 'GL ACCOUNT NAME  '     DELIMITED BY SIZE          
                      GO-GL-ACCT-NAME   ,    DELIMITED BY SIZE          
                      'COMPANY NO  '         DELIMITED BY SIZE          
                       GO-COMPANY-NO         DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** CREATES NEW CASH REPORT                                      **        
      **--------------------------------------------------------------**        
       8000-CREATE-NEW-RPT.                                             
      *--------------------*                                                    
                                                                        
           MOVE '8000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_REPORT_HDR                             
                  (                                                     
                   CASH_COMPANY_NO                                      
                  ,CASH_LOCAL_OFFICE                                    
                  ,DATE_CASH_REPORT                                     
                  ,USER_ID                                              
                  ,STATUS                                               
                  ,CLOSED_TS                                            
                  )                                                     
             VALUES                                                     
                  (                                                     
                   :YR-CASH-COMPANY-NO                                  
                  ,:YR-CASH-LOCAL-OFFICE                                
                  ,IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )                         
                  ,:YR-USER-ID                                          
                  ,:YR-STATUS                                           
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  )                                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_REPORT_HDR                                     
MFA-TR*           (                                                             
MFA-TR*            CASH_COMPANY_NO                                              
MFA-TR*           ,CASH_LOCAL_OFFICE                                            
MFA-TR*           ,DATE_CASH_REPORT                                             
MFA-TR*           ,USER_ID                                                      
MFA-TR*           ,STATUS                                                       
MFA-TR*           ,CLOSED_TS                                                    
MFA-TR*           )                                                             
MFA-TR*      VALUES                                                             
MFA-TR*           (                                                             
MFA-TR*            :YR-CASH-COMPANY-NO                                          
MFA-TR*           ,:YR-CASH-LOCAL-OFFICE                                        
MFA-TR*           ,:YR-DATE-CASH-REPORT                                         
MFA-TR*           ,:YR-USER-ID                                                  
MFA-TR*           ,:YR-STATUS                                                   
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           )                                                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
                                       S-RETURN-CODE                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING  'ERROR INSERTING CASH REPORT **'                  
                                            DELIMITED BY SIZE           
                                            INTO WS-ERR-MSG             
              STRING 'CASH_LOCAL_OFFICE = ' DELIMITED BY SIZE           
                     YR-CASH-LOCAL-OFFICE   DELIMITED BY SIZE           
                     'DATE_CASH_REPORT = '  DELIMITED BY SIZE           
                     YR-DATE-CASH-REPORT    DELIMITED BY SIZE           
                                            INTO WS-ERR-MSG2            
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** CREATES NEW BATCH                                            **        
      **--------------------------------------------------------------**        
       8010-CREATE-NEW-BATCH.                                           
      *----------------------*                                                  
                                                                        
           MOVE '8010'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_DRWR_CNTL                              
                  (                                                     
                   CASH_COMPANY_NO                                      
                  ,CASH_LOCAL_OFFICE                                    
                  ,CASH_REPORT_NO                                       
                  ,DATE_CASH_REPORT                                     
                  ,CASH_DRAWER_ID                                       
                  ,AMT_CASH_DEBIT                                       
                  ,AMT_CASH_CREDIT                                      
                  ,AMT_AR_DEBIT                                         
                  ,AMT_AR_CREDIT                                        
                  ,AMT_CK_ISS_DEBIT                                     
                  ,AMT_CK_ISS_CREDIT                                    
                  ,AMT_GL_DEBIT                                         
                  ,AMT_GL_CREDIT                                        
                  ,AMT_CASH_BEGIN_BAL                                   
                  ,AMT_BASIC_WORK                                       
                  ,USER_ID                                              
                  ,CASHIER_CODE                                         
                  ,CODE_PYMT_FACILITY                                   
                  ,CODE_FCS_EXTRACTED                                   
                  ,CODE_CSH_DRWR_STAT                                   
                  ,DATE_LAST_ACTIVITY                                   
                  ,BALANCED_BY                                          
                  ,BALANCED_TS                                          
                  ,NO_ITEMS_ENTERED                                     
                  )                                                     
           VALUES (                                                     
                   :CS-CASH-COMPANY-NO                                  
                  ,:CS-CASH-LOCAL-OFFICE                                
                  ,:CS-CASH-REPORT-NO                                   
                  ,IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )                         
                  ,:CS-CASH-DRAWER-ID                                   
                  ,:CS-AMT-CASH-DEBIT                                   
                  ,:CS-AMT-CASH-CREDIT                                  
                  ,:CS-AMT-AR-DEBIT                                     
                  ,:CS-AMT-AR-CREDIT                                    
                  ,:CS-AMT-CK-ISS-DEBIT                                 
                  ,:CS-AMT-CK-ISS-CREDIT                                
                  ,:CS-AMT-GL-DEBIT                                     
                  ,:CS-AMT-GL-CREDIT                                    
                  ,:CS-AMT-CASH-BEGIN-BAL                               
                  ,:CS-AMT-BASIC-WORK                                   
                  ,:CS-USER-ID                                          
                  ,:CS-CASHIER-CODE                                     
                  ,:CS-CODE-PYMT-FACILITY                               
                  ,:CS-CODE-FCS-EXTRACTED                               
                  ,:CS-CODE-CSH-DRWR-STAT                               
                  ,CAST(SYSDATETIMEOFFSET() AS DATE)                            
                  ,:CS-BALANCED-BY                                      
                  ,CIS.CHAR2TIMESTAMP(:CS-BALANCED-TS :WS-NULL-IND-1)           
                  ,:CS-NO-ITEMS-ENTERED                                 
                  )                                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_DRWR_CNTL                                      
MFA-TR*           (                                                             
MFA-TR*            CASH_COMPANY_NO                                              
MFA-TR*           ,CASH_LOCAL_OFFICE                                            
MFA-TR*           ,CASH_REPORT_NO                                               
MFA-TR*           ,DATE_CASH_REPORT                                             
MFA-TR*           ,CASH_DRAWER_ID                                               
MFA-TR*           ,AMT_CASH_DEBIT                                               
MFA-TR*           ,AMT_CASH_CREDIT                                              
MFA-TR*           ,AMT_AR_DEBIT                                                 
MFA-TR*           ,AMT_AR_CREDIT                                                
MFA-TR*           ,AMT_CK_ISS_DEBIT                                             
MFA-TR*           ,AMT_CK_ISS_CREDIT                                            
MFA-TR*           ,AMT_GL_DEBIT                                                 
MFA-TR*           ,AMT_GL_CREDIT                                                
MFA-TR*           ,AMT_CASH_BEGIN_BAL                                           
MFA-TR*           ,AMT_BASIC_WORK                                               
MFA-TR*           ,USER_ID                                                      
MFA-TR*           ,CASHIER_CODE                                                 
MFA-TR*           ,CODE_PYMT_FACILITY                                           
MFA-TR*           ,CODE_FCS_EXTRACTED                                           
MFA-TR*           ,CODE_CSH_DRWR_STAT                                           
MFA-TR*           ,DATE_LAST_ACTIVITY                                           
MFA-TR*           ,BALANCED_BY                                                  
MFA-TR*           ,BALANCED_TS                                                  
MFA-TR*           ,NO_ITEMS_ENTERED                                             
MFA-TR*           )                                                             
MFA-TR*    VALUES (                                                             
MFA-TR*            :CS-CASH-COMPANY-NO                                          
MFA-TR*           ,:CS-CASH-LOCAL-OFFICE                                        
MFA-TR*           ,:CS-CASH-REPORT-NO                                           
MFA-TR*           ,:CS-DATE-CASH-REPORT                                         
MFA-TR*           ,:CS-CASH-DRAWER-ID                                           
MFA-TR*           ,:CS-AMT-CASH-DEBIT                                           
MFA-TR*           ,:CS-AMT-CASH-CREDIT                                          
MFA-TR*           ,:CS-AMT-AR-DEBIT                                             
MFA-TR*           ,:CS-AMT-AR-CREDIT                                            
MFA-TR*           ,:CS-AMT-CK-ISS-DEBIT                                         
MFA-TR*           ,:CS-AMT-CK-ISS-CREDIT                                        
MFA-TR*           ,:CS-AMT-GL-DEBIT                                             
MFA-TR*           ,:CS-AMT-GL-CREDIT                                            
MFA-TR*           ,:CS-AMT-CASH-BEGIN-BAL                                       
MFA-TR*           ,:CS-AMT-BASIC-WORK                                           
MFA-TR*           ,:CS-USER-ID                                                  
MFA-TR*           ,:CS-CASHIER-CODE                                             
MFA-TR*           ,:CS-CODE-PYMT-FACILITY                                       
MFA-TR*           ,:CS-CODE-FCS-EXTRACTED                                       
MFA-TR*           ,:CS-CODE-CSH-DRWR-STAT                                       
MFA-TR*           ,CURRENT DATE                                                 
MFA-TR*           ,:CS-BALANCED-BY                                              
MFA-TR*           ,:CS-BALANCED-TS:WS-NULL-IND-1                                
MFA-TR*           ,:CS-NO-ITEMS-ENTERED                                         
MFA-TR*           )                                                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE CS-CASH-DRAWER-ID     TO WS-DISP-CASH-DRAWER-ID     
               STRING  'ERROR INSERTING CASH DRAWER **'                 
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
               STRING 'CASH_LOCAL_OFFICE = ' DELIMITED BY SIZE          
                      CS-CASH-LOCAL-OFFICE   DELIMITED BY SIZE          
                      'DATE_CASH_REPORT = '  DELIMITED BY SIZE          
                      CS-DATE-CASH-REPORT    DELIMITED BY SIZE          
                      'CASH_DRAWER_ID = '    DELIMITED BY SIZE          
                      WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG2           
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** CREATES BANK TRANSFER                                        **        
      **--------------------------------------------------------------**        
       8100-CREATE-BANK-TRANSFER.                                       
      *-------------------------*                                               
           MOVE '8100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
            INSERT INTO CSS_BANK_TRANSFER                               
                    ( CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      DATE_CASH_REPORT,                                 
                      CASH_DRAWER_ID,                                   
                      TRANSFER_TS,                                      
                      CURRENCY_TYPE,                                    
                      USER_ID,                                          
                      BANK_ID,                                          
                      TRANSFER_AMT,                                     
                      CODE_DR_CR,                                       
                      BANK_POST_DT)                                     
                      VALUES (                                          
                      :YB-CASH-COMPANY-NO,                              
                      :YB-CASH-LOCAL-OFFICE,                            
                      IIF(TRY_CONVERT(DATE, :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) ),                        
                      :YB-CASH-DRAWER-ID,                               
                      CIS.CHAR2TIMESTAMP(:YB-TRANSFER-TS),                      
                      :YB-CURRENCY-TYPE,                                
                      :YB-USER-ID,                                      
                      :YB-BANK-ID,                                      
                      :YB-TRANSFER-AMT,                                 
                      :YB-CODE-DR-CR,                                   
                      IIF(TRY_CONVERT(DATE, :YB-BANK-POST-DT
              ) IS NULL OR (PATINDEX('%.%', :YB-BANK-POST-DT
              ) <> 0) OR (LEN(:YB-BANK-POST-DT) <> 10), CIS.CHAR2DATE(
                                                       :YB-BANK-POST-DT
              ), CONVERT(DATE, :YB-BANK-POST-DT) ))                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     INSERT INTO CSS_BANK_TRANSFER                                       
MFA-TR*             ( CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               CASH_DRAWER_ID,                                           
MFA-TR*               TRANSFER_TS,                                              
MFA-TR*               CURRENCY_TYPE,                                            
MFA-TR*               USER_ID,                                                  
MFA-TR*               BANK_ID,                                                  
MFA-TR*               TRANSFER_AMT,                                             
MFA-TR*               CODE_DR_CR,                                               
MFA-TR*               BANK_POST_DT)                                             
MFA-TR*               VALUES (                                                  
MFA-TR*               :YB-CASH-COMPANY-NO,                                      
MFA-TR*               :YB-CASH-LOCAL-OFFICE,                                    
MFA-TR*               :YB-DATE-CASH-REPORT,                                     
MFA-TR*               :YB-CASH-DRAWER-ID,                                       
MFA-TR*               :YB-TRANSFER-TS,                                          
MFA-TR*               :YB-CURRENCY-TYPE,                                        
MFA-TR*               :YB-USER-ID,                                              
MFA-TR*               :YB-BANK-ID,                                              
MFA-TR*               :YB-TRANSFER-AMT,                                         
MFA-TR*               :YB-CODE-DR-CR,                                           
MFA-TR*               :YB-BANK-POST-DT)                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE YB-CASH-DRAWER-ID     TO WS-DISP-CASH-DRAWER-ID      
              STRING ' ERROR INSERTING INTO CSS_BANK_TRANSFER **'       
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              STRING 'LOCAL OFFICE     '     DELIMITED BY SIZE          
                   YB-CASH-LOCAL-OFFICE,     DELIMITED BY SIZE          
                  ',CASH COMPANY NO   '      DELIMITED BY SIZE          
                   YB-CASH-COMPANY-NO,       DELIMITED BY SIZE          
                   ',DATE CASH REPORT'       DELIMITED BY SIZE          
                   YB-DATE-CASH-REPORT,      DELIMITED BY SIZE          
                   ',CASH DRAWER ID'         DELIMITED BY SIZE          
                   WS-DISP-CASH-DRAWER-ID,   DELIMITED BY SIZE          
                   ',USER ID       '         DELIMITED BY SIZE          
                   YB-USER-ID                DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** INSERTS OVER/SHORT IN OVERSHORT HEADER TABLE                 **        
      **--------------------------------------------------------------**        
       8070-INSERT-OVERSHORT.                                           
      *----------------------*                                                  
                                                                        
           MOVE '8070'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_OVERSHORT_HDR                           
                       (                                                
                        CASH_COMPANY_NO                                 
                       ,CASH_LOCAL_OFFICE                               
                       ,DATE_CASH_REPORT                                
                       ,CASH_DRAWER_ID                                  
                       ,USER_ID                                         
                       ,OVERSHORT_ID                                    
                       ,TRAN_TS                                         
                       ,OVERSHORT_AMT                                   
                       ,OVERSHORT_DR_CR                                 
                       ,OFST_OVERSHORT_AMT                              
                       ,OFST_DR_CR                                      
                       ,GL_ACCT_NO                                      
                       ,LAST_UPDATE_TS                                  
                       ,OVERSHORT_TYPE_CD                               
                       ,OVERSHORT_SOLTN_FL                              
                       ,TRAN_COMMENT                                    
                       ,ACCOUNT_NO                                      
                       )                                                
                VALUES                                                  
                       (                                                
                        :OH-CASH-COMPANY-NO                             
                       ,:OH-CASH-LOCAL-OFFICE                           
                       ,IIF(TRY_CONVERT(DATE, :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )                         
                       ,:OH-CASH-DRAWER-ID                              
                       ,:OH-USER-ID                                     
                       ,:OH-OVERSHORT-ID                                
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:OH-OVERSHORT-AMT                               
                       ,:OH-OVERSHORT-DR-CR                             
                       ,:OH-OFST-OVERSHORT-AMT                          
                       ,:OH-OFST-DR-CR                                  
                       ,:OH-GL-ACCT-NO                                  
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:OH-OVERSHORT-TYPE-CD                           
                       ,:OH-OVERSHORT-SOLTN-FL                          
                       ,:OH-TRAN-COMMENT                                
                       ,:OH-ACCOUNT-NO                                  
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_OVERSHORT_HDR                                   
MFA-TR*                (                                                        
MFA-TR*                 CASH_COMPANY_NO                                         
MFA-TR*                ,CASH_LOCAL_OFFICE                                       
MFA-TR*                ,DATE_CASH_REPORT                                        
MFA-TR*                ,CASH_DRAWER_ID                                          
MFA-TR*                ,USER_ID                                                 
MFA-TR*                ,OVERSHORT_ID                                            
MFA-TR*                ,TRAN_TS                                                 
MFA-TR*                ,OVERSHORT_AMT                                           
MFA-TR*                ,OVERSHORT_DR_CR                                         
MFA-TR*                ,OFST_OVERSHORT_AMT                                      
MFA-TR*                ,OFST_DR_CR                                              
MFA-TR*                ,GL_ACCT_NO                                              
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,OVERSHORT_TYPE_CD                                       
MFA-TR*                ,OVERSHORT_SOLTN_FL                                      
MFA-TR*                ,TRAN_COMMENT                                            
MFA-TR*                ,ACCOUNT_NO                                              
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :OH-CASH-COMPANY-NO                                     
MFA-TR*                ,:OH-CASH-LOCAL-OFFICE                                   
MFA-TR*                ,:OH-DATE-CASH-REPORT                                    
MFA-TR*                ,:OH-CASH-DRAWER-ID                                      
MFA-TR*                ,:OH-USER-ID                                             
MFA-TR*                ,:OH-OVERSHORT-ID                                        
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:OH-OVERSHORT-AMT                                       
MFA-TR*                ,:OH-OVERSHORT-DR-CR                                     
MFA-TR*                ,:OH-OFST-OVERSHORT-AMT                                  
MFA-TR*                ,:OH-OFST-DR-CR                                          
MFA-TR*                ,:OH-GL-ACCT-NO                                          
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:OH-OVERSHORT-TYPE-CD                                   
MFA-TR*                ,:OH-OVERSHORT-SOLTN-FL                                  
MFA-TR*                ,:OH-TRAN-COMMENT                                        
MFA-TR*                ,:OH-ACCOUNT-NO                                          
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE OH-OVERSHORT-ID TO WS-OVERSHORT-ID                   
              STRING ' ERROR INSERTING INTO CSS_OVERSHORT_HDR **'       
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              STRING 'CASH LOCAL OFFICE  '   DELIMITED BY SIZE          
                     OH-CASH-LOCAL-OFFICE,   DELIMITED BY SIZE          
                     ',DATE CASH REPORT'     DELIMITED BY SIZE          
                     OH-DATE-CASH-REPORT,    DELIMITED BY SIZE          
                     ',CASH DRAWER ID'       DELIMITED BY SIZE          
                     WS-DISP-CASH-DRAWER-ID, DELIMITED BY SIZE          
                     ',OVERSHORT ID  '       DELIMITED BY SIZE          
                     WS-OVERSHORT-ID         DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG2           
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** UPDATES OVERSHORT AMOUNT IN OVERSHORT HEADER TABLE           **        
      **--------------------------------------------------------------**        
       8080-UPDATE-OVERSHORT.                                           
      *----------------------*                                                  
                                                                        
           MOVE '8080'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_OVERSHORT_HDR                                   
                SET OVERSHORT_AMT     = :OH-OVERSHORT-AMT               
                   ,OVERSHORT_DR_CR   = :OH-OVERSHORT-DR-CR             
                   ,LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()               
              WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO             
                AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE           
                AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )            
                AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID              
                AND OVERSHORT_ID      = :OH-OVERSHORT-ID                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_OVERSHORT_HDR                                           
MFA-TR*         SET OVERSHORT_AMT     = :OH-OVERSHORT-AMT                       
MFA-TR*            ,OVERSHORT_DR_CR   = :OH-OVERSHORT-DR-CR                     
MFA-TR*            ,LAST_UPDATE_TS    = CURRENT TIMESTAMP                       
MFA-TR*       WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                      
MFA-TR*         AND OVERSHORT_ID      = :OH-OVERSHORT-ID                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE OH-OVERSHORT-ID TO WS-OVERSHORT-ID                   
              STRING ' ERROR UPDATING CSS_OVERSHORT_HDR **'             
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              STRING 'CASH LOCAL OFFICE  '   DELIMITED BY SIZE          
                     OH-CASH-LOCAL-OFFICE,   DELIMITED BY SIZE          
                     ',DATE CASH REPORT'     DELIMITED BY SIZE          
                     OH-DATE-CASH-REPORT,    DELIMITED BY SIZE          
                     ',CASH DRAWER ID'       DELIMITED BY SIZE          
                     WS-DISP-CASH-DRAWER-ID, DELIMITED BY SIZE          
                     ',OVERSHORT ID  '       DELIMITED BY SIZE          
                     WS-OVERSHORT-ID         DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG2           
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       8080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** DISPLAY DB2 ERROR MESSAGE                                    **        
      **--------------------------------------------------------------**        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '*--------------------------------------------*'     
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'     
           DISPLAY  WS-ERR-MSG                                          
           DISPLAY '*--------------------------------------------*'     
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
           DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE      
           DISPLAY '**' WS-ERR-MSG2                                     
           DISPLAY '*--------------------------------------------*'     
           PERFORM 9800-ABEND                                           
              THRU 9800-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      **--------------------------------------------------------------**        
      ** DISPLAY ERROR MESSAGE                                        **        
      **--------------------------------------------------------------**        
       8850-DISPLAY-ERR-TERM.                                           
      *---------------------*                                                   
           DISPLAY '                                   '                
           DISPLAY '*----------------------------------------*'         
           DISPLAY '**     PCSAC184 PROCESSING ERROR        **'         
           DISPLAY '*----------------------------------------*'         
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
           DISPLAY '**' WS-ERR-MSG                                      
           DISPLAY '**       PROCESSING TERMINATED          **'         
           DISPLAY '*----------------------------------------*'         
           PERFORM 9800-ABEND                                           
              THRU 9800-EXIT                                            
           .                                                            
       8850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** DISPLAY BATCH TOTALS                                         **        
      **--------------------------------------------------------------**        
       8860-DISPLAY-BATCH-TOTALS.                                       
      *--------------------------*                                              
                                                                        
           MOVE '8860'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           DISPLAY '            BATCH NO =        ' WS-BATCH-NO         
           DISPLAY ' TOTAL BATCH RECORDS =        ' WS-TOTAL-BATCH-RECS 
           DISPLAY 'ACTUAL TOTAL RECORDS =        ' WS-TOTAL-RECS       
           IF WS-TOTAL-RECS NOT EQUAL WS-TOTAL-BATCH-RECS               
              MOVE 'SYSTEM TOTAL RECS ARE NOT MATCHING WITH FILE TOTAL' 
                   TO WS-ERR-MSG                                        
              PERFORM 8850-DISPLAY-ERR-TERM                             
                 THRU 8850-EXIT                                         
           END-IF                                                       
                                                                        
           DISPLAY ' TOTAL BATCH AMOUNT  = ' WS-BATCH-TOT-AMT           
           DISPLAY 'ACTUAL TOTAL AMOUNT  = ' WS-TOTAL-RVR-AMT           
           IF WS-BATCH-TOT-AMT NOT EQUAL WS-TOTAL-RVR-AMT               
              MOVE 'SYSTEM TOTAL AMT IS NOT MATCHING WITH FILE TOTAL'   
                   TO WS-ERR-MSG                                        
              PERFORM 8850-DISPLAY-ERR-TERM                             
                 THRU 8850-EXIT                                         
           END-IF                                                       
                                                                        
           MOVE WS-BATCH-TOT-AMT TO WS-PYMT-AMOUNT                      
                                                                        
           .                                                            
       8860-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
      *--------------*                                                          
           CONTINUE                                                     
           .                                                            
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** CHECKS FOR A RESTART RECORD                                  **        
      **--------------------------------------------------------------**        
       8910-CHECK-FOR-RESTART.                                          
                                                                        
           MOVE '8910'                TO WS-ACTIVE-PARAGRAPH            
                                                                        
           EXEC SQL                                                     
             SELECT RESTART_DATA                                        
               INTO :RF-RESTART-DATA                                    
               FROM CSS_RESTART                                         
              WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                     
                AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                     
                AND PARTITION_NO = :RF-PARTITION-NO                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR SELECTING CSS_RESTART **'                  
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              STRING 'NAME_PROGRAM '         DELIMITED BY SIZE          
                     RF-NAME-PROGRAM,        DELIMITED BY SIZE          
                     ',DUP_CNTRL_NO '        DELIMITED BY SIZE          
                     WS-DUP-CNTRL-NO         DELIMITED BY SIZE          
                     ',PARTITION_NO '        DELIMITED BY SIZE          
                     WS-PARTITION-NO         DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG2           
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       8910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** CREATES/UPDATES A RESTART RECORD                             **        
      **--------------------------------------------------------------**        
       8920-WRITE-RESTART-RECORD.                                       
                                                                        
           MOVE '8920'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           IF WS-RESTART-IND = WS-Y                                     
              EXEC SQL                                                  
                UPDATE CSS_RESTART                                      
                   SET RESTART_DATA = :RF-RESTART-DATA                  
                 WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                  
                   AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                  
                   AND PARTITION_NO = :RF-PARTITION-NO                  
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           ELSE                                                         
              EXEC SQL                                                  
                INSERT INTO CSS_RESTART                                 
                       (NAME_PROGRAM, PARTITION_NO,                     
                        DUP_CNTRL_NO, RESTART_DATA)                     
                VALUES                                                  
                       (:RF-NAME-PROGRAM, :RF-PARTITION-NO,             
                        :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)             
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF                                                       
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR INSERTING/UPDATING IN CSS_RESTART **'      
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              STRING 'NAME_PROGRAM '         DELIMITED BY SIZE          
                     RF-NAME-PROGRAM,        DELIMITED BY SIZE          
                     ',RESTART_DATA '        DELIMITED BY SIZE          
                     RF-RESTART-DATA         DELIMITED BY SIZE          
                     ',PARTITION_NO '        DELIMITED BY SIZE          
                     WS-PARTITION-NO         DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG2           
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
                                                                        
           MOVE WS-Y TO WS-RESTART-IND                                  
           .                                                            
       8920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **--------------------------------------------------------------**        
      ** DELETES A RESTART RECORD                                     **        
      **--------------------------------------------------------------**        
       8930-DELETE-RESTART.                                             
                                                                        
           MOVE '8930'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_RESTART                                    
              WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                     
                AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                     
                AND PARTITION_NO = :RF-PARTITION-NO                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR DEDLETING RECORD IN CSS_RESTART **'        
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              STRING 'NAME_PROGRAM '         DELIMITED BY SIZE          
                     RF-NAME-PROGRAM,        DELIMITED BY SIZE          
                     ',DUP_CNTRL_NO '        DELIMITED BY SIZE          
                     WS-DUP-CNTRL-NO         DELIMITED BY SIZE          
                     ',PARTITION_NO '        DELIMITED BY SIZE          
                     WS-PARTITION-NO         DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG2           
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       8930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **-------------------------------------------------------------**         
      ** COMMIT DB2                                                  **         
      **-------------------------------------------------------------**         
       8999-ISSUE-COMMIT.                                               
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC                                                             
           .                                                                    
                                                    
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **-------------------------------------------------------------**         
      ** SENDS ERROR RESULT                                          **         
      **-------------------------------------------------------------**         
       9000-SEND-ERROR-RESULT.                                          
      *-----------------------*                                                 
                                                                        
           DISPLAY 'PERFORMING ABEND PROCESS'                           
                                                                        
           PERFORM 9100-TERMINATE THRU 9100-EXIT                        
                                                                        
           EXEC SQL                                                     
             ROLLBACK                                                   
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 12  TO  RETURN-CODE                                     
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **-------------------------------------------------------------**         
      ** CLOSE INPUT FILE                                            **         
      **-------------------------------------------------------------**         
       9100-TERMINATE.                                                  
      *---------------*                                                         
           CLOSE  FCSAC184-FILE                                         
           IF FCSAC184-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              STRING '** FCSAC184 FILE CLOSE ERROR  **'                 
                                        DELIMITED BY SIZE               
                     'FILE STATUS = '   DELIMITED BY SIZE               
                     WS-FCSAC184-STATUS DELIMITED BY SIZE               
                                        INTO WS-ERR-MSG                 
              DISPLAY '*** ' WS-ERR-MSG                                 
           END-IF                                                       
           .                                                            
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **-------------------------------------------------------------**         
      ** ABEND ROUTINE                                               **         
      **-------------------------------------------------------------**         
       9800-ABEND.                                                      
      *-----------*                                                             
           PERFORM 9000-SEND-ERROR-RESULT                               
              THRU 9000-EXIT                                            
           STOP RUN                                                     
           .                                                            
       9800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **-------------------------------------------------------------**         
      ** CREATES ERROR LOG                                           **         
      **-------------------------------------------------------------**         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
