       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSAC183.                                            
       AUTHOR. BASKAR VANNI.                                            
       DATE-WRITTEN. AUGUST 2004.                                       
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      **-------------------------------------------------------------**         
      ********            CUSTOMER INFORMATION SYSTEMS        *********         
      **-------------------------------------------------------------**         
      *                                                               *         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *                                                               *         
      *      DATE       INITIALS   REASON                             *         
      *    ==========   =========  ================================   *         
      *    08/02/2004   BASKAR V   NEW PROGRAM TO PROCESS 2040 FILE   *         
      *                            FROM CHECKFREE                     *         
      *                                                               *         
      *    10/29/2004   BASKAR V   CHECK BILL COPIES BEFORE UPDATING  *         
      *                                                               *         
C31818*    11/11/2004   BASKAR V   REJECT ACCOUNTS IF BILLER ID IS    *         
      *                            NOT MATCHING                       *         
      *                                                               *         
T32079*    02/07/2005   SK88120 A) CODE CHANGES WERE MADE NOT TO CHECK*         
      *                            ACCOUNT STATUS FOR INA REQUESTS.   *         
      *                         B) GENERATE WQ FOR EDI BILLS NOT SENT *         
      *                            BEFORE DELETING THE ACCOUNT.       *         
      *                         C) CHANGES WERE MADE TO REMOVE FINAL- *         
      *                            BILLED ACCOUNTS FROM EDI TABLES.   *         
C29533*    02/23/2005   SK88120    E-CUSTOMER-CUSTOMER INFO THREAD    *         
C29533*                            DELETE ROWS IN CSS_ACCT_ATTRIBUTE  *         
C29533*                            (IF ANY) WHEN ACCT IS ACTIVATED/   *         
C29533*                            INACTIVATED WITH CHECKFREE.        *         
C34583*    11/28/2006   RICK S     REJECT CONSOLIDATED SUB-ACCOUNTS   *         
T35434*    03/01/2007   COVANSYS   REPLACED CSS_MODEL_SQL WITH SET    *         
T35434*                            STATEMENT.                         *         
C35914*    08/22/2007   AP40911    NOT TO ABEND FOR                   *         
      *                             1.REPEATED TRANSACTION ACROSS DAYS*         
      *                             2.DUPLICATE ROWS                  *         
      *                             BUT IT WILL ABEND IF THE DUPLICATE*         
      *                             ROWS ARE MORE.                    *         
A02034*    09/29/2010   MC95456    CHANGED WQ CATEGORY FROM           *         
A02034*                            "CUSTOMER MEMO/BILL ADJUSTMENT(174)*         
A02034*                            TO "DUPLICATE BILL REQUESTED(419)" *         
ACT003*    12/20/2013   SS7F226    REPLACE CSS_WQ_ITEMS_MF WITH       *         
ACT003*    A04860                  CSS_WQ_ITEMS BY CALLING SCSCB077   *         
ACT003*    A04860                  AND REMOVED UN USED CODE           *         
ACT026*    01/26/2015   DB41297    ADD EMAIL_TYPE_CD TO SELECT.       *         
A04983*    05/04/2016   BD09555    EZ ACTIVATION                      *         
A04983*    06/15/2016   BD09555    CORRECT SITUATION WHERE SOME       *         
A04983*                            CUSTOMERS INCORRECTLY CHANGED TO   *         
A04983*                            PAPERLESS                          *         
A4983F*    07/05/2016   AP40911    1.FINE TUNE EZ ACTIVATION PROCESS  *         
      *                            2.ADD NEW APPL-ID FOR 2040ADD      *         
      *                              RECORD WHEN E-F2040-PAPER-SUPP-FL*         
      *                              IS Q (BOTH PAPER AND E-BILL).    *         
      *                            3.FOR 2040CHG RECORD AND           *         
      *                              E-F2040-PAPER-SUPP-FL IS Y UPDATE*         
      *                            BILL COPIES TO ZERO AND NEW APPL-ID*         
ACT268*    08/31/2016   BD09555    REMOVE CBL ADV                     *         
ACT268*A05460-ACT268                                                  *         
A04983*    08/31/2016   AP40911    REMOVE UNNECESSARY UPDATES ON THE  *         
      *                            ACCOUNT FOR INACTIVE TRANSACTION   *         
ACT366*    12/01/2016   AP40911    FINE TUNE TASK CREATION FOR INA    *         
      *A05460-ACT366               RECORDS.                           *         
ACT405*    01/20/2017   AP40911    WHEN PROCESSING INA RECORDS        *         
      *A05460-ACT405               1.DO NOT DELETE ATTRIBUTES         *         
      *                            2.DO NOT CHECK FOR EPAY OR EDRAFT  *         
      *                              TO UPDATE BILL COPIES            *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
      *---------------------------------------------------------------*         
      * THIS PROGRAM VALIDATES ACCOUNTS FROM 2040 FILE WHICH IS SENT  *         
      * BY CHECKFREE FOR EBILL ACTIVATION/DEACTIVATION. IT CREATES    *         
      * A RESPONSE FILE (2050) WHICH CONTAINS INFORMATION WHETHER     *         
      * ACCOUNT IS ACCEPTED OR REJECTED AND REASON FOR THAT. IF A     *         
      * ACCOUNT IS ACCEPTED FOR EBILL THEN IT AUTOMATICALLY SET THE NO*         
      * OF BILL COPIES TO ZERO AND SETS IT TO ONE WHEN DEACTIVATION.  *         
      * THIS PROGRAM ALSO CREATES A REPORT FOR INACTIVE ACCOUNTS AND  *         
      * DELETES IT.                                                   *         
      *---------------------------------------------------------------*         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
                                                                        
           SELECT FCS2040-FILE                                          
              ASSIGN UT-S-FCS2040                                       
                 FILE STATUS IS WS-FAC2040-STATUS.                      
                                                                        
           SELECT FCS2050-FILE                                          
              ASSIGN UT-S-FCS2050                                       
                 FILE STATUS IS WS-FAC2050-STATUS.                      
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
                                                                        
       FD  FCS2040-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       COPY FIO2040.                                                            
                                                                        
       FD  FCS2050-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       COPY FIO2050.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC183'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-F2040-REC-COUNT          PIC 9(06) VALUE ZEROES.      
           05  WS-F2040-ADD-COUNT          PIC 9(06) VALUE ZEROES.      
           05  WS-F2040-REJ-COUNT          PIC 9(06) VALUE ZEROES.      
           05  WS-F2040-CHG-COUNT          PIC 9(06) VALUE ZEROES.      
           05  WS-F2040-INA-COUNT          PIC 9(06) VALUE ZEROES.      
C35914     05  WS-F2040-NPO-COUNT          PIC 9(06) VALUE ZEROES.      
           05  WS-F2050-INA-COUNT          PIC 9(06) VALUE ZEROES.      
           05  WS-F2050-REC-COUNT          PIC 9(06) VALUE ZEROES.      
C35914     05  WS-ACCOUNTNO-COUNT          PIC 9(03) VALUE ZEROES.      
                                                                        
       01  WS-CONSTANTS.                                                
A4983F     05  WS-PGRMNAME                 PIC X(09) VALUE 'PCSAC183'.  
A4983F     05  WS-PGMNAME                  PIC X(09) VALUE 'PCSAC183'.  
A4983F     05  WS-EZ-ADD-Q                 PIC X(09) VALUE 'ADD183EZQ'. 
A4983F     05  WS-EZ-CHG-Y                 PIC X(09) VALUE 'CHG183EZY'. 
ACT003     05  SCSCB077                    PIC X(08) VALUE 'SCSCB077'.  
           05  WS-SYSTEM                   PIC X(08) VALUE 'SYSTEM'.    
           05  WS-I                        PIC X(01) VALUE 'I'.         
           05  WS-R                        PIC X(01) VALUE 'R'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-SOURCE                   PIC X(01) VALUE 'C'.         
           05  WS-H                        PIC X(01) VALUE 'H'.         
           05  WS-D                        PIC X(01) VALUE 'D'.         
           05  WS-P1                       PIC X(02) VALUE 'P1'.        
           05  WS-1                        PIC 9(01) VALUE 1.           
           05  WS-2                        PIC 9(01) VALUE 2.           
           05  WS-3                        PIC 9(01) VALUE 3.           
           05  WS-5                        PIC 9(01) VALUE 5.           
           05  WS-247                      PIC X(09) VALUE '000000247'. 
           05  WS-248                      PIC X(09) VALUE '000000248'. 
           05  WS-01                       PIC X(02) VALUE '01'.        
           05  WS-54                       PIC 9(02) VALUE 54.          
           05  WS-ZZ                       PIC X(02) VALUE 'ZZ'.        
           05  WS-ADD                      PIC X(03) VALUE 'ADD'.       
           05  WS-CHG                      PIC X(03) VALUE 'CHG'.       
           05  WS-INA                      PIC X(03) VALUE 'INA'.       
           05  WS-2040                     PIC X(04) VALUE '2040'.      
C31818     05  WS-SCEG-BILLER-ID           PIC X(13) VALUE              
C31818                                               '0000000391001'.   
C31818     05  WS-PSNC-BILLER-ID           PIC X(13) VALUE              
C31818                                               '0000001620001'.   
C31818     05  WS-SEB-BILLER-ID            PIC X(13) VALUE              
C31818                                               '0000000725001'.   
           05  WS-NO-DATA                  PIC X(01) VALUE 'N'.         
C35914     05  WS-F2040-PROCESSED-FLAG     PIC X(01) VALUE 'N'.         
A4983F     05  WS-UPDATE-BILL-COPIES       PIC X(01) VALUE 'N'.         
           05  WS-COMPANY                  PIC X(02) VALUE '01'.        
           05  WS-DATABASE                 PIC X(08) VALUE 'DATABASE'.  
           05  WS-CHECKFREE                PIC X(09) VALUE 'CHECKFREE'. 
           05  WS-CF-SENDER-ID             PIC X(12) VALUE              
                                                     'CF-SENDER-ID'.    
           05  WS-CF-RECEIVER-ID           PIC X(14) VALUE              
                                                     'CF-RECEIVER-ID'.  
           05  WS-END-DATE                 PIC X(10) VALUE '2999-12-31'.
           05  WS-CKFR-ENROL-LEN           PIC S9(4) COMP VALUE +26.    
           05  WS-CKFR-ENROL               PIC X(26) VALUE              
                                        'CHECKFREE EBILL ENROLLMENT'.   
           05  WS-CKFR-ENROL-REJ-LEN       PIC S9(4) COMP VALUE +37.    
           05  WS-SCANA-COMP-NAME          PIC X(39)    VALUE           
                 '         SCANA ENERGY                  '.             
           05  WS-CKFR-ENROL-REJ           PIC X(37) VALUE              
                            'CHECKFREE EBILL ENROLLMENT - REJECTED'.    
           05  WS-CKFR-DEENROL-LEN         PIC S9(4) COMP VALUE +29.    
           05  WS-CKFR-DEENROL             PIC X(29) VALUE              
                                        'CHECKFREE EBILL DE-ENROLLMENT'.
           05  WS-COMMENTS.                                             
               10 FILLER                   PIC X(50) VALUE              
               'CHECKFREE EBILL CUSTOMER ACCOUNT DEACTIVATED FROM '.    
               10 FILLER                   PIC X(32) VALUE              
               'EBILLING. PRINT/MAIL PAPER BILL.'.                      
           05  WS-SCEG-INVALID-ACCT.                                    
               10 FILLER                   PIC X(50) VALUE              
               'YOUR SCE&G E-BILL ENROLLMENT REQUEST HAS NOT BEEN '.    
               10 FILLER                   PIC X(48) VALUE              
               'APPROVED. THE ACCOUNT NUMBER ENTERED IS INVALID.'.      
               10 FILLER                   PIC X(50) VALUE              
               ' PLEASE TRY AGAIN.'.                                    
           05  WS-PSNC-INVALID-ACCT.                                    
               10 FILLER                   PIC X(50) VALUE              
               'YOUR PSNC ENERGY EBILL ENROLLMENT REQUEST HAS NOT '.    
               10 FILLER                   PIC X(53) VALUE              
               'BEEN APPROVED. THE ACCOUNT NUMBER ENTERED IS INVALID.'. 
               10 FILLER                   PIC X(50) VALUE              
               ' PLEASE TRY AGAIN.'.                                    
           05  WS-SEB-INVALID-ACCT.                                     
               10 FILLER                   PIC X(51) VALUE              
               'YOUR SCANA ENERGY EBILL ENROLLMENT REQUEST HAS NOT '.   
               10 FILLER                   PIC X(53) VALUE              
               'BEEN APPROVED. THE ACCOUNT NUMBER ENTERED IS INVALID.'. 
               10 FILLER                   PIC X(50) VALUE              
               ' PLEASE TRY AGAIN.'.                                    
           05  WS-SCEG-CASHONLY-STAT.                                   
               10 FILLER                   PIC X(50) VALUE              
               'YOUR SCE&G E-BILL ENROLLMENT REQUEST HAS NOT BEEN '.    
               10 FILLER                   PIC X(50) VALUE              
               'APPROVED. THIS ACCOUNT IS IN CASH-ONLY STATUS AND '.    
               10 FILLER                   PIC X(53) VALUE              
               'IS NOT ELIGIBLE FOR E-BILL PAYMENTS.  PLEASE RESUBMIT'. 
               10 FILLER                   PIC X(44) VALUE              
               ' YOUR REQUEST WHEN THE ACCOUNT IS NO LONGER '.          
               10 FILLER                   PIC X(22) VALUE              
               'IN CASH-ONLY STATUS.'.                                  
           05  WS-PSNC-CASHONLY-STAT.                                   
               10 FILLER                   PIC X(51) VALUE              
               'YOUR PSNC ENERGY E-BILL ENROLLMENT REQUEST HAS NOT '.   
               10 FILLER                   PIC X(51) VALUE              
               'BEEN APPROVED. THIS ACCOUNT IS IN CASH-ONLY STATUS '.   
               10 FILLER                   PIC X(49) VALUE              
               'AND IS NOT ELIGIBLE FOR E-BILL PAYMENTS.  PLEASE '.     
               10 FILLER                   PIC X(52) VALUE              
               'RESUBMIT YOUR REQUEST WHEN THE ACCOUNT IS NO LONGER '.  
               10 FILLER                   PIC X(20) VALUE              
               'IN CASH-ONLY STATUS.'.                                  
           05  WS-SEB-CASHONLY-STAT.                                    
               10 FILLER                   PIC X(52) VALUE              
               'YOUR SCANA ENERGY E-BILL ENROLLMENT REQUEST HAS NOT '.  
               10 FILLER                   PIC X(51) VALUE              
               'BEEN APPROVED. THIS ACCOUNT IS IN CASH-ONLY STATUS '.   
               10 FILLER                   PIC X(49) VALUE              
               'AND IS NOT ELIGIBLE FOR E-BILL PAYMENTS.  PLEASE '.     
               10 FILLER                   PIC X(52) VALUE              
               'RESUBMIT YOUR REQUEST WHEN THE ACCOUNT IS NO LONGER '.  
               10 FILLER                   PIC X(20) VALUE              
               'IN CASH-ONLY STATUS.'.                                  
           05  WS-SCEG-DEENROL-MSG.                                     
               10 FILLER                   PIC X(50) VALUE              
               'YOUR SCE&G E-BILL ENROLLMENT HAS BEEN TERMINATED. '.    
               10 FILLER                   PIC X(52) VALUE              
               'THIS ACCOUNT IS IN CASH-ONLY STATUS AND IS NO LONGER'.  
               10 FILLER                   PIC X(53) VALUE              
               ' ELIGIBLE FOR E-BILL PAYMENTS. PAPER BILLS HAVE BEEN '. 
               10 FILLER                   PIC X(50) VALUE              
               'REINSTATED.  PLEASE SIGN UP FOR E-BILLS AGAIN WHEN'.    
               10 FILLER                   PIC X(42) VALUE              
               ' ACCOUNT IS NO LONGER IN CASH-ONLY STATUS.'.            
           05  WS-PSNC-DEENROL-MSG.                                     
               10 FILLER                   PIC X(44) VALUE              
               'YOUR PSNC ENERGY E-BILL ENROLLMENT HAS BEEN '.          
               10 FILLER                   PIC X(52) VALUE              
               'TERMINATED. THIS ACCOUNT IS IN CASH-ONLY STATUS AND '.  
               10 FILLER                   PIC X(54) VALUE              
               'IS NO LONGER ELIGIBLE FOR E-BILL PAYMENTS. PAPER BILLS'.
               10 FILLER                   PIC X(51) VALUE              
               ' HAVE BEEN REINSTATED.  PLEASE SIGN UP FOR E-BILLS '.   
               10 FILLER                   PIC X(52) VALUE              
               'AGAIN WHEN ACCOUNT IS NO LONGER IN CASH-ONLY STATUS.'.  
           05  WS-SEB-DEENROL-MSG.                                      
               10 FILLER                   PIC X(45) VALUE              
               'YOUR SCANA ENERGY E-BILL ENROLLMENT HAS BEEN '.         
               10 FILLER                   PIC X(52) VALUE              
               'TERMINATED. THIS ACCOUNT IS IN CASH-ONLY STATUS AND '.  
               10 FILLER                   PIC X(49) VALUE              
               'IS NO LONGER ELIGIBLE FOR E-BILL PAYMENTS. PAPER '.     
               10 FILLER                   PIC X(48) VALUE              
               'BILLS HAVE BEEN REINSTATED.  PLEASE SIGN UP FOR '.      
               10 FILLER                   PIC X(42) VALUE              
               'E-BILLS AGAIN WHEN ACCOUNT IS NO LONGER IN'.            
               10 FILLER                   PIC X(17) VALUE              
               'CASH-ONLY STATUS.'.                                     
           05  WS-SCEG-FINALBL-MSG.                                     
               10 FILLER                   PIC X(47) VALUE              
               'YOUR SCE&G EBILLS ACCOUNT HAS BEEN INACTIVATED,'.       
               10 FILLER                   PIC X(49) VALUE              
               'AS IT WAS RECENTLY FINAL BILLED. YOU WILL NEED TO'.     
               10 FILLER                   PIC X(53) VALUE              
               ' RE-ENROLL FOR EBILLS IF ANOTHER ACCOUNT IS OPENED.'.   
               10 FILLER                   PIC X(106) VALUE SPACES.     
           05  WS-PSNC-FINALBL-MSG.                                     
               10 FILLER                   PIC X(41) VALUE              
               'YOUR PSNC ENERGY EBILLS ACCOUNT HAS BEEN '.             
               10 FILLER                   PIC X(53) VALUE              
               'INACTIVATED,AS IT WAS RECENTLY FINAL BILLED. YOU WILL'. 
               10 FILLER                   PIC X(52) VALUE              
               ' NEED TO  RE-ENROLL FOR EBILLS IF ANOTHER ACCOUNT IS'.  
               10 FILLER                   PIC X(08) VALUE              
               ' OPENED.'.                                              
               10 FILLER                   PIC X(101) VALUE SPACES.     
           05  WS-SEB-FINALBL-MSG.                                      
               10 FILLER                   PIC X(42) VALUE              
               'YOUR SCANA ENERGY EBILLS ACCOUNT HAS BEEN '.            
               10 FILLER                   PIC X(53) VALUE              
               'INACTIVATED,AS IT WAS RECENTLY FINAL BILLED. YOU WILL'. 
               10 FILLER                   PIC X(52) VALUE              
               ' NEED TO  RE-ENROLL FOR EBILLS IF ANOTHER ACCOUNT IS'.  
               10 FILLER                   PIC X(08) VALUE              
               ' OPENED.'.                                              
               10 FILLER                   PIC X(100) VALUE SPACES.     
C34583*   THIS MESSAGE IS FOR CHECKFREE ACCOUNTS THAT ARE ON                    
C34583*   CONSOLIDATED BILLING AND TRY TO ADD THE SUB ACCOUNT.                  
C34583     05  WS-SCEG-SUBACCT-MSG.                                     
C34583         10 FILLER                   PIC X(54) VALUE              
C34583         'YOUR REQUEST FOR SCE&G EBILLS ENROLLMENT HAS NOT BEEN '.
C34583         10 FILLER                   PIC X(44) VALUE              
C34583         'APPROVED, AS THIS SUB ACCOUNT IS INVOLVED IN'.          
C34583         10 FILLER                   PIC X(53) VALUE              
C34583         ' CONSOLIDATED BILLING WITH ALL ACTIVITY PERFORMED VIA'. 
C34583         10 FILLER                   PIC X(53) VALUE              
C34583         ' THE MASTER ACCOUNT. MASTER ACCOUNTS NOT IN CASH-ONLY'. 
C34583         10 FILLER                   PIC X(41) VALUE              
C34583         ' STATUS MAY BE CONSIDERED FOR ENROLLMENT.'.             
C34583         10 FILLER                   PIC X(10) VALUE SPACES.      
C34583     05  WS-PSNC-SUBACCT-MSG.                                     
C34583         10 FILLER                   PIC X(54) VALUE              
C34583         'YOUR REQUEST FOR PSNC ENERGY EBILLS ENROLLMENT HAS NOT'.
C34583         10 FILLER                   PIC X(50) VALUE              
C34583         ' BEEN APPROVED, AS THIS SUB ACCOUNT IS INVOLVED IN'.    
C34583         10 FILLER                   PIC X(53) VALUE              
C34583         ' CONSOLIDATED BILLING WITH ALL ACTIVITY PERFORMED VIA'. 
C34583         10 FILLER                   PIC X(53) VALUE              
C34583         ' THE MASTER ACCOUNT. MASTER ACCOUNTS NOT IN CASH-ONLY'. 
C34583         10 FILLER                   PIC X(41) VALUE              
C34583         ' STATUS MAY BE CONSIDERED FOR ENROLLMENT.'.             
C34583         10 FILLER                   PIC X(04) VALUE SPACES.      
C34583     05  WS-SEB-SUBACCT-MSG.                                      
C34583         10 FILLER                   PIC X(52) VALUE              
C34583         'YOUR REQUEST FOR SCANA ENERGY EBILLS ENROLLMENT HAS '.  
C34583         10 FILLER                   PIC X(53) VALUE              
C34583         'NOT BEEN APPROVED, AS THIS SUB ACCOUNT IS INVOLVED IN'. 
C34583         10 FILLER                   PIC X(53) VALUE              
C34583         ' CONSOLIDATED BILLING WITH ALL ACTIVITY PERFORMED VIA'. 
C34583         10 FILLER                   PIC X(53) VALUE              
C34583         ' THE MASTER ACCOUNT. MASTER ACCOUNTS NOT IN CASH-ONLY'. 
C34583         10 FILLER                   PIC X(41) VALUE              
C34583         ' STATUS MAY BE CONSIDERED FOR ENROLLMENT.'.             
C34583         10 FILLER                   PIC X(03) VALUE SPACES.      
                                                                        
       01  WS-VARIABLES.                                                
           05 WS-ERR-MSG                  PIC X(100)  VALUE SPACES.     
           05 WS-ERR-MSG2                 PIC X(150)  VALUE SPACES.     
           05 WS-SENDER-ID                PIC X(32)   VALUE SPACES.     
           05 WS-RECEIVER-ID              PIC X(32)   VALUE SPACES.     
           05 WS-ACCOUNT-NO               PIC 9(13)   VALUE 0.          
           05 WS-CUSTOMER-NO              PIC 9(10)   VALUE 0.          
           05 WS-CURRENT-TS               PIC X(26)   VALUE SPACES.     
           05 WS-CREATE-DATE              PIC X(10)   VALUE SPACES.     
C31818     05 WS-BILLER-ID                PIC X(13)   VALUE SPACES.     
ACT003     05 WS-ITEM-ID                  PIC S9(10)V COMP-3 VALUE +0.  
ACT003     05 RS-RETURN-CODE              PIC S9(09)  COMP   VALUE +0.  
           05 WS-ROW-EXIST                PIC X(01)   VALUE 'N'.        
C29533     05 WS-PAPER-ONLY-EXIST         PIC X(01)   VALUE 'N'.        
C29533     05 WS-EBILL-REGISTER           PIC X(01)   VALUE 'N'.        
C29533     05 WS-CALL-PARA                PIC X(04)   VALUE SPACES.     
C29533     05 WS-BILL-NOTIFY-EXIST        PIC X(01)   VALUE 'N'.        
           05 WS-811                      PIC S9(09)  VALUE -811 COMP.  
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-END-REC-SW               PIC X(01)  VALUE 'N'.        
               88 END-OF-RECORD                       VALUE 'Y'.        
           05  WS-VALID-ACCOUNT            PIC X(01)  VALUE 'N'.        
               88 VALID-ACCOUNT                       VALUE 'Y'.        
               88 INVALID-ACCOUNT                     VALUE 'N'.        
               88 CASHONLY-ACCOUNT                    VALUE 'C'.        
C34583         88 SUB-ACCOUNT                         VALUE 'S'.        
C34583     05  WS-SUB-ACCOUNT              PIC X(01)  VALUE ' '.        
           05  WS-CIS-HAS-EMAIL            PIC X(01)  VALUE 'N'.        
               88 EMAIL-IN-CIS                        VALUE 'Y'.        
               88 EMAIL-NOT-IN-CIS                    VALUE 'N'.        
           05  WS-FCS2040-EOF-SW           PIC X(01)  VALUE 'N'.        
               88 WS-FCS2040-AT-EOF                   VALUE 'Y'.        
               88 WS-FCS2040-NOT-AT-EOF               VALUE 'N'.        
           05  WS-FAC2040-STATUS           PIC X(02)  VALUE '00'.       
               88 WS-FAC2040-SUCCESSFUL               VALUE '00' '04'.  
           05  WS-FAC2050-STATUS           PIC X(02)  VALUE '00'.       
               88 WS-FAC2050-SUCCESSFUL               VALUE '00' '04'.  
           05  WS-DELINQ-VALUE             PIC S9(9)V9(5)               
                                                      VALUE 1.00000.    
               88 WS-CSR                              VALUE 1.00000.    
               88 WS-SEB                              VALUE 2.00000.    
                                                                        
       01  WS-DATE-8.                                                   
           02  WS-D8-MM                    PIC X(02).                   
           02  FILLER                      PIC X(01)    VALUE '/'.      
           02  WS-D8-DD                    PIC X(02).                   
           02  FILLER                      PIC X(01)    VALUE '/'.      
           02  WS-D8-YY                    PIC X(02).                   
                                                                        
       01  WS-DATE-10.                                                  
           02  WS-D10-CC                   PIC X(02).                   
           02  WS-D10-YY                   PIC X(02).                   
           02  FILLER                      PIC X(01)    VALUE '/'.      
           02  WS-D10-MM                   PIC X(02).                   
           02  FILLER                      PIC X(01)    VALUE '/'.      
           02  WS-D10-DD                   PIC X(02).                   
                                                                        
       01  WS-CURRENT-DATE.                                             
           02  WS-CD-CC                    PIC X(02).                   
           02  WS-CD-YY                    PIC X(02).                   
           02  WS-CD-MM                    PIC X(02).                   
           02  WS-CD-DD                    PIC X(02).                   
                                                                        
       01  WS-CURRENT-DATE-6.                                           
           02  WS-CD6-YY                   PIC X(02).                   
           02  WS-CD6-MM                   PIC X(02).                   
           02  WS-CD6-DD                   PIC X(02).                   
                                                                        
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                       PIC 9(02).                   
           05  WS-MM                       PIC 9(02).                   
           05  WS-SS                       PIC 9(02).                   
           05  WS-TT                       PIC 9(02).                   
                                                                        
       01  WS-CREATE-TS.                                                
           05  WS-TS-HH                    PIC 9(02).                   
           05  WS-TS-MM                    PIC 9(02).                   
           05  WS-TS-SS                    PIC 9(02).                   
           05  WS-TS-MS                    PIC 9(06).                   
                                                                        
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                    PIC X(02).                   
           05  FILLER                      PIC X(01)    VALUE ':'.      
           05  WS-RT-MM                    PIC X(02).                   
           05  FILLER                      PIC X(01)    VALUE ':'.      
           05  WS-RT-SS                    PIC X(02).                   
                                                                        
       01  PRINTER-CONTROL.                                             
           05  WS-LINE                 PIC X(132)   VALUE ALL '-'.      
           05  WS-BLANK-LINE           PIC X(132)   VALUE SPACES.       
           05  WS-RPT1-LINE-NO         PIC S999     COMP-3 VALUE +60.   
           05  WS-RPT1-PAGE-NO         PIC 9(4)     VALUE 0.            
                                                                        
      *--------------------------------------------------------------*          
      *           COMMON WORKING STORAGE FOR REPORT TITLE            *          
      *--------------------------------------------------------------*          
                                                                        
       01  WS-HEADERS.                                                  
                                                                        
           05  WS-RPT1-TITLE.                                           
ACT366         10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
ACT366         10  FILLER              PIC X(37)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(39)    VALUE               
                 '         SCE&G AND PSNC ENERGY         '.             
               10  FILLER              PIC X(29)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(08).                       
                                                                        
      *--------------------------------------------------------------*          
      *           COMMON WORKING STORAGE FOR REPORT HEADER1          *          
      *--------------------------------------------------------------*          
                                                                        
           05  WS-RPT1-HEADER-1.                                        
ACT366         10  FILLER              PIC X(01)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
ACT366         10  FILLER              PIC X(31)    VALUE SPACES.       
               10  FILLER              PIC X(38)    VALUE               
                   ' DAILY REPORT FOR EBILL DE-ENROLLMENT '.            
               10  FILLER              PIC X(30)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
                                                                        
      *--------------------------------------------------------------*          
      *            COMMON WORKING STORAGE FOR REPORT HEADER2         *          
      *--------------------------------------------------------------*          
                                                                        
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(118)   VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
                                                                        
      *--------------------------------------------------------------*          
      *        COMMON WORKING STORAGE FOR REPORT HEADER3             *          
      *--------------------------------------------------------------*          
                                                                        
           05  WS-RPT1-HEADER-3.                                        
               10  FILLER              PIC X(12)    VALUE               
                                             '  ACCOUNT NO'.            
               10  FILLER              PIC X(14)    VALUE SPACES.       
               10  FILLER              PIC X(20)    VALUE               
                                       'INACTIVATION DATE   '.          
               10  FILLER              PIC X(16)    VALUE SPACES.       
               10  FILLER              PIC X(20)    VALUE               
                                       'ACTIVATION DATE'.               
               10  FILLER              PIC X(15)    VALUE SPACES.       
               10  FILLER              PIC X(20)    VALUE               
                                       'EBILL PROVIDER      '.          
               10  FILLER              PIC X(15)    VALUE SPACES.       
                                                                        
      *--------------------------------------------------------------*          
      *        COMMON WORKING STORAGE FOR REPORT COLUMN DETAILS      *          
      *--------------------------------------------------------------*          
                                                                        
           05  WS-RPT1-DETAIL-1.                                        
ACT366         10  FILLER              PIC X(01)    VALUE SPACES.       
ACT366         10  P-ACCOUNT-NO        PIC X(13)    VALUE SPACES.       
ACT366         10  FILLER              PIC X(16)    VALUE SPACES.       
               10  P-INACTIVE-DATE     PIC X(10)    VALUE SPACES.       
               10  FILLER              PIC X(25)    VALUE SPACES.       
               10  P-ACTIVE-DATE       PIC X(10)    VALUE SPACES.       
               10  FILLER              PIC X(25)    VALUE SPACES.       
               10  P-EBILL-PROVIDER    PIC X(20)    VALUE SPACES.       
               10  FILLER              PIC X(12)    VALUE SPACES.       
                                                                        
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(52)    VALUE SPACES.       
           05  FILLER                  PIC X(28)    VALUE               
                     '*** NO DATA FOR THIS RUN ***'.                    
           05  FILLER                  PIC X(52)    VALUE SPACES.       
                                                                        
ACT003*===============================================================*         
ACT003* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077         *         
ACT003*===============================================================*         
ACT003     EXEC SQL                                                             
ACT003          INCLUDE CWS00077                                                
ACT003     END-EXEC.                                                            
ACT003                                                                  
      *===============================================================*         
      * SQL COMMUNICATION AREA                                        *         
      *===============================================================*         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *   CSS_JOB_PARM                                                *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *   UV - CSS_CODE_VALUE                                                   
      *===============================================================*         
                                                                        
C35914     EXEC SQL                                                             
C35914       INCLUDE TBCDVALU                                                   
C35914     END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_ACCOUNT                                                *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBACCT                                                      
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_CUST_EMAIL                                             *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCSTEML                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_BANK_EFT                                               *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBBNKEFT                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_CUST_STATS                                             *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCSTSTS                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_CREDIT_PROFILE                                         *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCRPROF                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_MT_TRN_HST_DET                                         *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBMNHDT                                                     
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_MNT_TRANS_HIST                                         *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBMNHIST                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_EDI_ACCT_DEST                                          *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBACDEST                                                    
           END-EXEC.                                                            
                                                                        
                                                                        
      *===============================================================*         
      *    CSS_EDI_BILL_HDR                                           *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBBILHDR                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_DELINQUENCY                                            *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
C29533*===============================================================*         
C29533*    CSS_ACCT_ATTRIBUTE                                         *         
C29533*===============================================================*         
C29533     EXEC SQL                                                             
C29533         INCLUDE TBACTATT                                                 
C29533     END-EXEC.                                                            
C29533*                                                                         
C29533*===============================================================*         
C29533*    CSS_ATTRIBUTE                                              *         
C29533*===============================================================*         
C29533     EXEC SQL                                                             
C29533        INCLUDE TBATTRIB                                                  
C29533     END-EXEC.                                                            
C29533*                                                                         
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00038.                                                           
ACT003 COPY CWS00010.                                                           
                                                                        
      *===============================================================*         
      *    CURSOR TO SELECT INACTIVE ACCOUNTS                         *         
      *===============================================================*         
            EXEC SQL                                                    
             DECLARE EDI_ACCT CURSOR WITH HOLD FOR                      
              SELECT NF.ACCOUNT_NO                                      
                    ,NF.STATUS_CD                                       
                    ,NF.DEST_ID                                         
                    ,NF.STAT_BEGIN_DT                                   
                    ,NF.STAT_END_DT                                     
                    ,AT.COMPANY_NO                                      
                FROM CSS_EDI_ACCT_DEST NF WITH(READUNCOMMITTED)                 
                    ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE NF.STATUS_CD   IN ('I','D','B')                    
                 AND NF.EDI_ID_QUAL = 'ZZ'                              
                 AND NF.DEST_ID     = 'CHECKFREE'                       
                 AND NF.ACCOUNT_NO  = AT.ACCOUNT_NO                     
                 FOR READ ONLY                                  
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*      DECLARE EDI_ACCT CURSOR WITH HOLD FOR                              
MFA-TR*       SELECT NF.ACCOUNT_NO                                              
MFA-TR*             ,NF.STATUS_CD                                               
MFA-TR*             ,NF.DEST_ID                                                 
MFA-TR*             ,NF.STAT_BEGIN_DT                                           
MFA-TR*             ,NF.STAT_END_DT                                             
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*         FROM CSS_EDI_ACCT_DEST NF                                       
MFA-TR*             ,CSS_ACCOUNT AT                                             
MFA-TR*        WHERE NF.STATUS_CD   IN ('I','D','B')                            
MFA-TR*          AND NF.EDI_ID_QUAL = 'ZZ'                                      
MFA-TR*          AND NF.DEST_ID     = 'CHECKFREE'                               
MFA-TR*          AND NF.ACCOUNT_NO  = AT.ACCOUNT_NO                             
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*     END-EXEC.                                                           
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      **                         M A I N L I N E                      **        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 7000-READ-FCS2040                                    
              THRU 7000-EXIT                                            
                                                                        
      ** CHECK FOR EMPTY INPUT FILE; IF EMPTY, DISPLAY MESSAGE                  
           IF WS-FCS2040-AT-EOF                                         
              STRING  '** 2040 INPUT FILE IS EMPTY '   DELIMITED BY SIZE
                 'CONTACT CHECKFREE TECH SUPPORT **'   DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
                                                                        
           PERFORM 1000-PROCESS-FCS2040                                 
              THRU 1000-EXIT UNTIL WS-FCS2040-AT-EOF.                   
                                                                        
           DISPLAY '                           '                        
           DISPLAY 'TOTAL NO OF 2040 RECORDS     = ' WS-F2040-REC-COUNT 
           DISPLAY 'NO OF CHANGES REQUESTS       = ' WS-F2040-CHG-COUNT 
           DISPLAY 'NO OF EBILL ACTIVATED ACCTS  = ' WS-F2040-ADD-COUNT 
           DISPLAY 'NO OF EBILL REJECTED  ACCTS  = ' WS-F2040-REJ-COUNT 
           DISPLAY 'NO OF EBILL INACTIVATED ACTS = ' WS-F2040-INA-COUNT 
C35914     DISPLAY 'NO OF NOT PROCESSED ACCOUNTS = ' WS-F2040-NPO-COUNT 
           DISPLAY 'TOTAL NO OF 2050 RECORDS     = ' WS-F2050-REC-COUNT 
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   COMMON INITIALIZATION ROUTINE                                *        
      *                                                                *        
      *----------------------------------------------------------------*        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0200-OPEN-FILES                                      
              THRU 0200-EXIT                                            
                                                                        
           PERFORM 0300-SETUP-DATES                                     
              THRU 0300-EXIT                                            
                                                                        
C35914     PERFORM 0400-SELECT-ACCT-CNT                                 
C35914        THRU 0400-EXIT                                            
                                                                        
           MOVE WS-COMPANY               TO C8-COMPANY-NO               
           MOVE WS-DATABASE              TO C8-DELINQ-CD                
           PERFORM 7800-SELECT-DELINQ    THRU 7800-EXIT                 
           MOVE C8-DELINQ-VALUE          TO WS-DELINQ-VALUE             
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   OPEN INPUT 2040, OUTPUT 2050 AND REPORT FILES                *        
      *                                                                *        
      *----------------------------------------------------------------*        
       0200-OPEN-FILES.                                                 
      *---------------*                                                         
           MOVE '0200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           OPEN INPUT FCS2040-FILE                                      
           IF WS-FAC2040-SUCCESSFUL                                     
              CONTINUE                                                  
           ELSE                                                         
              STRING  '** FILE OPEN ERROR FCS2040  **' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FAC2040-STATUS                        DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
                                                                        
           OPEN OUTPUT FCS2050-FILE                                     
           IF WS-FAC2050-SUCCESSFUL                                     
              CONTINUE                                                  
           ELSE                                                         
              STRING  '** FILE OPEN ERROR FCS2050  **' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FAC2050-STATUS                        DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
                                                                        
           OPEN OUTPUT FCSPT33-FILE                                     
           MOVE SPACES                   TO PRT33-RECORD                
           .                                                            
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   GET THE CURRENT DATE, TIME AND RUN DATE FROM JOB PARM TABLE  *        
      *                                                                *        
      *----------------------------------------------------------------*        
       0300-SETUP-DATES.                                                
      *----------------*                                                        
           MOVE '0300'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           ACCEPT WS-CURRENT-TIME FROM TIME                             
           MOVE WS-HH                  TO WS-RT-HH                      
           MOVE WS-MM                  TO WS-RT-MM                      
           MOVE WS-SS                  TO WS-RT-SS                      
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME               
                                                                        
           ACCEPT WS-CURRENT-DATE-6 FROM DATE                           
           MOVE WS-CD6-YY              TO WS-D8-YY                      
           MOVE WS-CD6-MM              TO WS-D8-MM                      
           MOVE WS-CD6-DD              TO WS-D8-DD                      
           MOVE WS-DATE-8              TO P-RPT1-RUN-DATE               
                                                                        
           PERFORM 6251-GET-FJC01-DATE                                  
              THRU 6251-EXIT                                            
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '          TO WS-PGRMNAME                   
              MOVE SPACES              TO WS-INPUT-AREA                 
              MOVE SPACES              TO WS-INPUT-DATA-BREAKDOWN       
              PERFORM 6251-GET-FJC01-DATE                               
                 THRU 6251-EXIT                                         
              MOVE WS-PGMNAME          TO WS-PGRMNAME                   
           END-IF                                                       
                                                                        
           MOVE WS-INPUT-DATE          TO WS-DATE-10                    
           MOVE WS-D10-YY              TO WS-D8-YY                      
           MOVE WS-D10-MM              TO WS-D8-MM                      
           MOVE WS-D10-DD              TO WS-D8-DD                      
           MOVE WS-DATE-8              TO P-RPT1-DATE                   
                                                                        
           PERFORM 7300-GET-CURRENT-TS                                  
              THRU 7300-EXIT                                            
                                                                        
           .                                                            
       0300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      *   0400-SELECT-ACCT-CNT.                                       *         
      *---------------------------------------------------------------*         
C35914 0400-SELECT-ACCT-CNT.                                            
C35914*---------------------*                                                   
C35914     MOVE '0400' TO WS-ACTIVE-PARAGRAPH                           
C35914                                                                  
C35914     EXEC SQL                                                     
C35914       SELECT CODE_VALUE                                          
C35914        INTO :UV-CODE-VALUE                                       
C35914         FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
C35914        WHERE TABLE_NA   = 'CSS_EDI_COUNT'                        
C35914          AND COMPANY_NO = '01'                                   
C35914          AND COLUMN_NA  = 'COUNT'                                
C35914          AND PROGRAM_ID = 'ALL'                                  
C35914                                                           
C35914     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CODE_VALUE                                                  
MFA-TR*       INTO :UV-CODE-VALUE                                               
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE TABLE_NA   = 'CSS_EDI_COUNT'                                
MFA-TR*         AND COMPANY_NO = '01'                                           
MFA-TR*         AND COLUMN_NA  = 'COUNT'                                        
MFA-TR*         AND PROGRAM_ID = 'ALL'                                          
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35914                                                                  
C35914     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
                                                                        
C35914     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35914        MOVE UV-CODE-VALUE-TEXT(1:3) TO WS-ACCOUNTNO-COUNT        
C35914     ELSE                                                         
C35914     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C35914        MOVE 005                     TO WS-ACCOUNTNO-COUNT        
C35914     ELSE                                                         
C35914        STRING ' ERROR SELECTING CSS_CODE_VALUE'                  
C35914                                       DELIMITED BY SIZE          
C35914                                       INTO WS-ERR-MSG            
C35914        STRING 'TABLE = CSS_EDI_COUNT' DELIMITED BY SIZE          
C35914               'COLUMN = COUNT'        DELIMITED BY SIZE          
C35914                                       INTO WS-ERR-MSG2           
C35914                                                                  
C35914        PERFORM 8800-DIS-TABLE-ERROR                              
C35914           THRU 8800-EXIT                                         
C35914     END-IF                                                       
C35914     END-IF.                                                      
       0400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * PROCESS 2040 RECORDS                                           *        
      *----------------------------------------------------------------*        
       1000-PROCESS-FCS2040.                                            
      *---------------------*                                                   
                                                                        
           EVALUATE E-F2040-RECORD-TYPE-0001                            
             WHEN '0000'                                                
                PERFORM 1100-VALIDATE-BEGIN-REC                         
                   THRU 1100-EXIT                                       
                PERFORM 8300-WRITE-2050-REC                             
                   THRU 8300-EXIT                                       
             WHEN '2040'                                                
                PERFORM 1200-PROCESS-2040-REC                           
                   THRU 1200-EXIT                                       
                PERFORM 1250-MOVE-2050-VALUES                           
                   THRU 1250-EXIT                                       
                PERFORM 8300-WRITE-2050-REC                             
                   THRU 8300-EXIT                                       
             WHEN '9999'                                                
                PERFORM 1300-VALIDATE-END-REC                           
                   THRU 1300-EXIT                                       
                PERFORM 1700-PROCESS-EBILL-CURSOR                       
                   THRU 1700-EXIT                                       
                SET END-OF-RECORD TO TRUE                               
                PERFORM 8300-WRITE-2050-REC                             
                   THRU 8300-EXIT                                       
           END-EVALUATE                                                 
                                                                        
           PERFORM 7000-READ-FCS2040                                    
              THRU 7000-EXIT                                            
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * VALIDATE 2040 BEGIN RECORD.                                    *        
      *----------------------------------------------------------------*        
       1100-VALIDATE-BEGIN-REC.                                         
      *------------------------*                                                
                                                                        
           IF E-F2040-FILE-CREATE-DATE(1:4) = WS-INPUT-DATE(1:4) AND    
              E-F2040-FILE-CREATE-DATE(5:2) = WS-INPUT-DATE(6:2) AND    
              E-F2040-FILE-CREATE-DATE(7:2) = WS-INPUT-DATE(9:2)        
              CONTINUE                                                  
           ELSE                                                         
              STRING  ' EBILL 2040 FILE INPUT DATE '  DELIMITED BY SIZE 
                 'IS NOT MATCHING WITH CURRENT DATE,' DELIMITED BY SIZE 
                 'CONTACT CHECKFREE TECH SUPPORT **'  DELIMITED BY SIZE 
                                                      INTO WS-ERR-MSG   
              STRING  ' F2040 FILE DATE = '           DELIMITED BY SIZE 
                      E-F2040-FILE-CREATE-DATE        DELIMITED BY SIZE 
                      ', SYSTEM DATE = '              DELIMITED BY SIZE 
                      WS-INPUT-DATE                   DELIMITED BY SIZE 
                                                      INTO WS-ERR-MSG2  
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
                                                                        
           MOVE WS-CF-SENDER-ID          TO C8-DELINQ-CD                
           PERFORM 7800-SELECT-DELINQ    THRU 7800-EXIT                 
           MOVE C8-DESCRIPTION-TEXT      TO WS-SENDER-ID                
                                                                        
           MOVE WS-CF-RECEIVER-ID        TO C8-DELINQ-CD                
           PERFORM 7800-SELECT-DELINQ    THRU 7800-EXIT                 
           MOVE C8-DESCRIPTION-TEXT      TO WS-RECEIVER-ID              
                                                                        
           IF E-F2040-SENDER-ID    = WS-SENDER-ID  AND                  
              E-F2040-RECEIVER-ID  = WS-RECEIVER-ID                     
              CONTINUE                                                  
           ELSE                                                         
              STRING  ' SENDER OR RECEIVER ID IS '     DELIMITED BY SIZE
                 'NOT CORRECT IN EBILL 2040 FILE,'     DELIMITED BY SIZE
                 'CONTACT CHECKFREE TECH SUPPORT **'   DELIMITED BY SIZE
                                                       INTO WS-ERR-MSG  
              STRING  ' FILE SENDER ID = '             DELIMITED BY SIZE
                      E-F2040-SENDER-ID(1:9)           DELIMITED BY SIZE
                      ',SYSTEM SENDER ID = '           DELIMITED BY SIZE
                      WS-SENDER-ID(1:9)                DELIMITED BY SIZE
                      ',FILE RECEIVER ID = '           DELIMITED BY SIZE
                      E-F2040-RECEIVER-ID              DELIMITED BY SIZE
                      ',SYSTEM RECEIVER ID = '         DELIMITED BY SIZE
                      WS-RECEIVER-ID                   DELIMITED BY SIZE
                                                       INTO WS-ERR-MSG2 
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
           .                                                            
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * PROCESS 2040 DETAIL RECORD FOR ACTIVATION/INACTIVATION.        *        
      *----------------------------------------------------------------*        
       1200-PROCESS-2040-REC.                                           
      *----------------------*                                                  
A4983F     MOVE WS-N                 TO WS-UPDATE-BILL-COPIES           
           PERFORM 7300-GET-CURRENT-TS                                  
              THRU 7300-EXIT                                            
                                                                        
           SET INVALID-ACCOUNT           TO TRUE                        
                                                                        
           MOVE E-F2040-BILLER-ACCT-NO(1:13)   TO AT-ACCOUNT-NO         
                                                  WS-ACCOUNT-NO         
                                                  CZ-ACCOUNT-NO         
           PERFORM 7100-SELECT-CIS-ACCOUNT                              
              THRU 7100-EXIT                                            
           IF VALID-ACCOUNT                                             
C31818        IF WS-CSR                                                 
C31818           IF AT-COMPANY-NO = WS-01                               
C31818              MOVE WS-SCEG-BILLER-ID     TO WS-BILLER-ID          
C31818           ELSE                                                   
C31818              MOVE WS-PSNC-BILLER-ID     TO WS-BILLER-ID          
C31818           END-IF                                                 
C31818        ELSE                                                      
C31818           MOVE WS-SEB-BILLER-ID         TO WS-BILLER-ID          
C31818        END-IF                                                    
C31818        IF WS-BILLER-ID = E-F2040-BILLER-ID(1:13)                 
                 IF E-F2040-RECORD-ACTION = WS-INA                      
C35914*              ADD 1 TO WS-F2040-INA-COUNT                                
                    PERFORM 1500-REMOVE-EBILL                           
                       THRU 1500-EXIT                                   
                 END-IF                                                 
                 IF E-F2040-RECORD-ACTION = WS-ADD                      
                   IF AT-ACCT-XFER-TO = 0 AND (AT-CODE-ACCT-STAT = 'P'  
                   OR AT-CODE-ACCT-STAT = 'A' )                         
                      PERFORM 7200-CHK-CASH-ONLY-FL                     
                         THRU 7200-EXIT                                 
                      IF CZ-CASH-ONLY-FL = 'Y'                          
                         SET CASHONLY-ACCOUNT     TO TRUE               
A4983F                   MOVE WS-PGMNAME TO WS-PGRMNAME                 
                         PERFORM 1420-MOVE-MNTTRANS-VAL                 
                            THRU 1420-EXIT                              
                         PERFORM 8100-INSERT-MNT-HIST-TRANS             
                            THRU 8100-EXIT                              
                         ADD 1 TO WS-F2040-REJ-COUNT                    
                      ELSE                                              
A4983F                   EVALUATE E-F2040-PAPER-SUPP-FL                 
A4983F                     WHEN 'Q'                                     
A4983F                        MOVE WS-EZ-ADD-Q TO WS-PGRMNAME           
A4983F                        PERFORM 1400A-SETUP-EBILL THRU 1400A-EXIT 
A4983F                        ADD 1 TO WS-F2040-ADD-COUNT               
A4983F                     WHEN 'X'                                     
A4983F                        MOVE WS-PGMNAME TO WS-PGRMNAME            
A4983F                        PERFORM 1400-SETUP-EBILL THRU 1400-EXIT   
A4983F                        ADD 1 TO WS-F2040-ADD-COUNT               
A4983F                     WHEN OTHER                                   
A4983F                        DISPLAY 'SKIPPING INVALID CODE '          
A4983F                        E-F2040-PAPER-SUPP-FL ' FOR ACCOUNT '     
A4983F                          E-F2040-BILLER-ACCT-NO                  
A4983F                        ADD 1 TO WS-F2040-NPO-COUNT               
A4983F                   END-EVALUATE                                   
C35914*                    ADD 1 TO WS-F2040-ADD-COUNT                          
                         IF E-F2040-SUB-EMAIL-ID NOT EQUAL SPACES       
                            PERFORM 1800-CHECK-EMAIL                    
                               THRU 1800-EXIT                           
                         END-IF                                         
                      END-IF                                            
                   ELSE                                                 
C34583                IF WS-SUB-ACCOUNT = 'S'                           
C34583                   SET SUB-ACCOUNT     TO TRUE                    
C34583                ELSE                                              
                      SET INVALID-ACCOUNT   TO TRUE                     
C34583                END-IF                                            
                      ADD 1 TO WS-F2040-REJ-COUNT                       
A4983F                MOVE WS-PGMNAME TO WS-PGRMNAME                    
                      PERFORM 1420-MOVE-MNTTRANS-VAL                    
                         THRU 1420-EXIT                                 
                      PERFORM 8100-INSERT-MNT-HIST-TRANS                
                         THRU 8100-EXIT                                 
                   END-IF                                               
                 END-IF                                                 
              ELSE                                                      
                 SET INVALID-ACCOUNT   TO TRUE                          
                 ADD 1 TO WS-F2040-REJ-COUNT                            
              END-IF                                                    
           ELSE                                                         
              ADD 1 TO WS-F2040-REJ-COUNT                               
           END-IF                                                       
A4983F     IF E-F2040-RECORD-ACTION = WS-CHG                            
A4983F        EVALUATE E-F2040-PAPER-SUPP-FL                            
A4983F         WHEN 'Y'                                                 
A4983F           MOVE WS-EZ-CHG-Y TO WS-PGRMNAME                        
A4983F           PERFORM 1400B-SETUP-EBILL THRU 1400B-EXIT              
A4983F           ADD 1 TO WS-F2040-CHG-COUNT                            
A4983F         WHEN OTHER                                               
A4983F           ADD 1 TO WS-F2040-NPO-COUNT                            
A4983F         END-EVALUATE                                             
A4983F     END-IF                                                       
           ADD 1 TO WS-F2040-REC-COUNT                                  
           .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * POPULATE 2050 RECORD VALUES                                    *        
      *----------------------------------------------------------------*        
       1250-MOVE-2050-VALUES.                                           
      *----------------------*                                                  
                                                                        
           MOVE SPACES                     TO FIO2050-DATA-REC          
                                                                        
           IF E-F2040-RECORD-TYPE-0001 = '2040'                         
              MOVE '2050'                  TO E-F2050-RECORD-TYPE-0000  
              MOVE E-F2040-RECORD-ACTION   TO E-F2050-RECORD-ACTION     
              MOVE E-F2040-SPONSOR-ID      TO E-F2050-SPONSOR-ID        
              MOVE E-F2040-SUBSCRIBER-ID   TO E-F2050-SUBSCRIBER-ID     
              MOVE E-F2040-BILL-PUB-ID     TO E-F2050-BILL-PUB-ID       
              MOVE E-F2040-BILLER-ID       TO E-F2050-BILLER-ID         
              MOVE E-F2040-BILLER-ACCT-NO  TO E-F2050-BILLER-ACCT-NO    
                                              E-F2050-ALTER-ACCT-NO     
              MOVE E-F2040-SERV-HOLD-BUS-NAME                           
                                           TO E-F2050-SERV-HOLD-BUS-NAME
              MOVE E-F2040-SERV-HOLD-LST-NAME                           
                                           TO E-F2050-SERV-HOLD-LST-NAME
              MOVE E-F2040-SERV-HOLD-FST-NAME                           
                                           TO E-F2050-SERV-HOLD-FST-NAME
              MOVE E-F2040-SERV-HOLD-MID-NAME                           
                                           TO E-F2050-SERV-HOLD-MID-NAME
              MOVE E-F2040-SERV-ADDR-LINE1 TO E-F2050-SERV-ADDR-LINE1   
              MOVE E-F2040-SERV-ADDR-LINE2 TO E-F2050-SERV-ADDR-LINE2   
              MOVE E-F2040-SERV-ADDR-LINE3 TO E-F2050-SERV-ADDR-LINE3   
              MOVE E-F2040-SERVICE-CITY    TO E-F2050-SERVICE-CITY      
              MOVE E-F2040-SERVICE-STATE   TO E-F2050-SERVICE-STATE     
              MOVE E-F2040-SERVICE-ZIP5    TO E-F2050-SERVICE-ZIP5      
              MOVE E-F2040-SERVICE-ZIP4    TO E-F2050-SERVICE-ZIP4      
              MOVE E-F2040-SERVICE-ZIP2    TO E-F2050-SERVICE-ZIP2      
              MOVE E-F2040-SERVICE-CNTRY   TO E-F2050-SERVICE-CNTRY     
              MOVE E-F2040-SERVICE-POST-CODE                            
                                           TO E-F2050-SERVICE-POST-CODE 
              MOVE E-F2040-SERVICE-PROVINCE                             
                                           TO E-F2050-SERVICE-PROVINCE  
              MOVE E-F2040-SERV-DAY-PHONE  TO E-F2050-SERV-DAY-PHONE    
              MOVE E-F2040-SERV-EVEN-PHONE TO E-F2050-SERV-EVEN-PHONE   
              IF WS-CSR                                                 
                 MOVE WS-248               TO E-F2050-BILL-PROC-CNTR    
              ELSE                                                      
                 MOVE WS-247               TO E-F2050-BILL-PROC-CNTR    
              END-IF                                                    
              MOVE SPACES                  TO E-F2050-NEW-ALTER-ACCT-NO 
              MOVE E-F2040-SERV-TRN-TIMESTAMP                           
                                           TO E-F2050-SERV-TRN-TIMESTAMP
              MOVE SPACES                  TO E-F2050-REMIT-ACCT-NO     
              MOVE E-F2040-PAPER-SUPP-FL   TO E-F2050-PAPER-SUPP-FLAG   
              MOVE SPACES                  TO E-F2050-ERROR-CD          
              MOVE SPACES                  TO E-F2050-ERROR-MSG         
              MOVE SPACES                  TO E-F2050-REJECTION-TEXT    
              EVALUATE WS-VALID-ACCOUNT                                 
                 WHEN 'Y'                                               
                    MOVE WS-A              TO E-F2050-RESPONSE-CD       
                    MOVE SPACES            TO E-F2050-REJECTION-TEXT    
                 WHEN 'N'                                               
                    MOVE WS-R              TO E-F2050-RESPONSE-CD       
                    IF WS-CSR                                           
C31818                 IF E-F2040-BILLER-ID(1:13) = WS-SCEG-BILLER-ID   
                          MOVE WS-SCEG-INVALID-ACCT                     
                                              TO E-F2050-REJECTION-TEXT 
                       ELSE                                             
                          MOVE WS-PSNC-INVALID-ACCT                     
                                              TO E-F2050-REJECTION-TEXT 
                       END-IF                                           
                    ELSE                                                
                       MOVE WS-SEB-INVALID-ACCT                         
                                              TO E-F2050-REJECTION-TEXT 
                    END-IF                                              
                 WHEN 'C'                                               
                    MOVE WS-R              TO E-F2050-RESPONSE-CD       
                    IF WS-CSR                                           
                       IF AT-COMPANY-NO = WS-01                         
                          MOVE WS-SCEG-CASHONLY-STAT                    
                                              TO E-F2050-REJECTION-TEXT 
                       ELSE                                             
                          MOVE WS-PSNC-CASHONLY-STAT                    
                                              TO E-F2050-REJECTION-TEXT 
                       END-IF                                           
                    ELSE                                                
                       MOVE WS-SEB-CASHONLY-STAT                        
                                              TO E-F2050-REJECTION-TEXT 
                    END-IF                                              
C34583                                                                  
C34583           WHEN 'S'                                               
C34583              MOVE WS-R              TO E-F2050-RESPONSE-CD       
C34583              IF WS-CSR                                           
C34583                 IF AT-COMPANY-NO = WS-01                         
C34583                    MOVE WS-SCEG-SUBACCT-MSG                      
C34583                                        TO E-F2050-REJECTION-TEXT 
C34583                 ELSE                                             
C34583                    MOVE WS-PSNC-SUBACCT-MSG                      
C34583                                        TO E-F2050-REJECTION-TEXT 
C34583                 END-IF                                           
C34583              ELSE                                                
C34583                 MOVE WS-SEB-SUBACCT-MSG                          
C34583                                        TO E-F2050-REJECTION-TEXT 
C34583              END-IF                                              
              END-EVALUATE                                              
           ELSE                                                         
              MOVE '2050'                  TO E-F2050-RECORD-TYPE-0000  
              MOVE WS-INA                  TO E-F2050-RECORD-ACTION     
              MOVE WS-CHECKFREE            TO E-F2050-BILL-PUB-ID       
              IF WS-CSR                                                 
                 MOVE WS-248               TO E-F2050-BILL-PROC-CNTR    
                 IF AT-COMPANY-NO = WS-01                               
                    MOVE '0000000391001'   TO E-F2050-BILLER-ID         
                 ELSE                                                   
                    MOVE '0000001620001'   TO E-F2050-BILLER-ID         
                 END-IF                                                 
              ELSE                                                      
                 MOVE '0000000725001'      TO E-F2050-BILLER-ID         
                 MOVE WS-247               TO E-F2050-BILL-PROC-CNTR    
              END-IF                                                    
              MOVE NF-ACCOUNT-NO           TO E-F2050-BILLER-ACCT-NO    
                                              E-F2050-ALTER-ACCT-NO     
              MOVE WS-R                    TO E-F2050-RESPONSE-CD       
              IF WS-CSR                                                 
                 IF AT-COMPANY-NO = WS-01                               
                    IF NF-STATUS-CD = 'I'                               
                       MOVE WS-SCEG-DEENROL-MSG                         
                                     TO E-F2050-REJECTION-TEXT          
                    ELSE                                                
                      IF NF-STATUS-CD = 'B'                             
                         MOVE WS-SCEG-FINALBL-MSG                       
                                       TO E-F2050-REJECTION-TEXT        
                      END-IF                                            
                    END-IF                                              
                 ELSE                                                   
                    IF NF-STATUS-CD = 'I'                               
                       MOVE WS-PSNC-DEENROL-MSG                         
                                     TO E-F2050-REJECTION-TEXT          
                    ELSE                                                
                      IF NF-STATUS-CD = 'B'                             
                         MOVE WS-PSNC-FINALBL-MSG                       
                                       TO E-F2050-REJECTION-TEXT        
                      END-IF                                            
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF NF-STATUS-CD = 'I'                                  
                    MOVE WS-SEB-DEENROL-MSG  TO E-F2050-REJECTION-TEXT  
                 ELSE                                                   
                    IF NF-STATUS-CD = 'B'                               
                       MOVE WS-SEB-FINALBL-MSG                          
                                        TO E-F2050-REJECTION-TEXT       
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * VALIDATE 2040 END RECORD                                       *        
      *----------------------------------------------------------------*        
       1300-VALIDATE-END-REC.                                           
      *----------------------*                                                  
                                                                        
           MOVE '1300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           IF E-F2040-RECORD-TYPE1   = '0000' AND                       
              E-F2040-RECORD-TYPE3   = '9999' AND                       
              E-F2040-NO-OF-RECORDS1 = 1    AND                         
              E-F2040-NO-OF-RECORDS3 = 1                                
              CONTINUE                                                  
           ELSE                                                         
              STRING  ' EBILL 2040 FILE END RECORD '   DELIMITED BY SIZE
                      'IS HAVING INVALID VALUES,'      DELIMITED BY SIZE
                 'CONTACT CHECKFREE TECH SUPPORT **'   DELIMITED BY SIZE
                                               INTO    WS-ERR-MSG       
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
                                                                        
           IF E-F2040-RECORD-TYPE2   = '2040' AND                       
A4983F        E-F2040-NO-OF-RECORDS2 = WS-F2040-REC-COUNT               
              CONTINUE                                                  
           ELSE                                                         
              STRING  '  EBILL 2040 FILE END RECORD ' DELIMITED BY SIZE 
                      'IS HAVING INVALID VALUES,'     DELIMITED BY SIZE 
                 ' CONTACT CHECKFREE TECH SUPPORT **' DELIMITED BY SIZE 
                                                      INTO WS-ERR-MSG   
              STRING  '  E-F2040-RECORD-TYPE2 = 2040' DELIMITED BY SIZE 
                      ', E-F2040-NO-OF-RECORDS2 =   ' DELIMITED BY SIZE 
                         WS-F2040-REC-COUNT           DELIMITED BY SIZE 
                                                      INTO WS-ERR-MSG2  
                                                                        
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
           .                                                            
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * IF 2040 DETAIL RECORD IS FOR ACTIVATION THEN SET THE ACCOUNT   *        
      * FOR EBILL                                                      *        
      *----------------------------------------------------------------*        
       1400-SETUP-EBILL.                                                
      *-----------------*                                                       
                                                                        
           PERFORM 1410-MOVE-EDIACCT-VAL                                
              THRU 1410-EXIT                                            
                                                                        
           PERFORM 8000-INSERT-EDI-ACCT                                 
              THRU 8000-EXIT                                            
                                                                        
C35914     IF WS-F2040-PROCESSED-FLAG = 'Y'                             
              PERFORM 7900-CHECK-BILL-COPIES                            
                 THRU 7900-EXIT                                         
              IF AT-NO-BILL-COPIES = 0                                  
                  CONTINUE                                              
              ELSE                                                      
                  MOVE 0                        TO AT-NO-BILL-COPIES    
                  PERFORM 8050-UPDATE-ACCOUNT                           
                        THRU 8050-EXIT                                  
A4983F            MOVE WS-Y TO WS-UPDATE-BILL-COPIES                    
C29533            PERFORM 1440-CHECK-ATTRIBUTES                         
C29533                   THRU 1440-EXIT                                 
              END-IF                                                    
              PERFORM 1600-WRITE-MNT-HISTORY                            
                 THRU 1600-EXIT                                         
C35914     END-IF                                                       
           .                                                            
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
A4983F*----------------------------------------------------------------*        
A4983F* IF 2040 DETAIL RECORD IS FOR ACTIVATION AND                    *        
A4983F* E-F2040-PAPER-SUPP-FL = "Q" WHEN SUBSCRIBER IS AUTOMATICALLY   *        
A4983F* ENROLL FOR EBILL WITH DUEL DELIVERY(EBILL AND PAPER BILL)      *        
A4983F*----------------------------------------------------------------*        
A4983F 1400A-SETUP-EBILL.                                               
      *-----------------*                                                       
                                                                        
           PERFORM 1410-MOVE-EDIACCT-VAL                                
              THRU 1410-EXIT                                            
                                                                        
           PERFORM 8000-INSERT-EDI-ACCT                                 
              THRU 8000-EXIT                                            
                                                                        
           IF WS-F2040-PROCESSED-FLAG = 'Y'                             
              PERFORM 1600-WRITE-MNT-HISTORY                            
                 THRU 1600-EXIT                                         
           END-IF                                                       
           .                                                            
       1400A-EXIT.                                                      
           EXIT.                                                        
A4983F*----------------------------------------------------------------*        
A4983F* IF 2040 DETAIL RECORD IS FOR CHANGE AND                        *        
A4983F* E-F2040-PAPER-SUPP-FL = "Y" WHEN SUBSCRIBER CURRENTLY IN DUAL  *        
A4983F* DELIVERY AGREES TO STOP/SUPPRESS THEIR PAPER BILL AND CONTINUE *        
A4983F* WITH EBILL.                                                             
A4983F*----------------------------------------------------------------*        
A4983F 1400B-SETUP-EBILL.                                               
      *-----------------*                                                       
                                                                        
              PERFORM 7900-CHECK-BILL-COPIES                            
                 THRU 7900-EXIT                                         
              IF AT-NO-BILL-COPIES = 0                                  
                  CONTINUE                                              
              ELSE                                                      
                  MOVE 0                        TO AT-NO-BILL-COPIES    
                  PERFORM 8050-UPDATE-ACCOUNT                           
                        THRU 8050-EXIT                                  
                  MOVE WS-Y TO WS-UPDATE-BILL-COPIES                    
                  PERFORM 1440-CHECK-ATTRIBUTES                         
                         THRU 1440-EXIT                                 
              END-IF                                                    
              PERFORM 1600-WRITE-MNT-HISTORY                            
                 THRU 1600-EXIT                                         
           .                                                            
       1400B-EXIT.                                                      
           EXIT.                                                        
      *----------------------------------------------------------------*        
      * POPULATE VALUES TO SET UP AN ACCOUNT FOR EBILL                 *        
      *----------------------------------------------------------------*        
       1410-MOVE-EDIACCT-VAL.                                           
      *----------------------*                                                  
                                                                        
           MOVE AT-ACCOUNT-NO          TO NF-ACCOUNT-NO                 
           MOVE WS-CHECKFREE           TO NF-DEST-ID                    
           MOVE WS-N                   TO NF-AUTOMATIC-EMAIL-FL         
           MOVE WS-ZZ                  TO NF-EDI-ID-QUAL                
           MOVE SPACES                 TO NF-EDI-RECEIVER-ID            
           MOVE SPACES                 TO NF-EMAIL-GROUP                
           MOVE 'PCAC183'              TO NF-LAST-UPDATE-USERID         
           MOVE WS-END-DATE            TO NF-STAT-END-DT                
           MOVE WS-A                   TO NF-STATUS-CD                  
           MOVE 1                      TO NF-HOLD-DAYS-NO               
           .                                                            
       1410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * POPULATE VALUES TO WRITE MAINTENANCE TRANSACTION HISTORY       *        
      *----------------------------------------------------------------*        
       1420-MOVE-MNTTRANS-VAL.                                          
      *-----------------------*                                                 
                                                                        
           MOVE WS-CURRENT-TS          TO MH-TRANS-HIST-SEQ-NO          
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE             
           MOVE 571                    TO MH-RESP-AREA-ID               
           MOVE AT-ACCOUNT-NO          TO MH-ACCOUNT-NO                 
           MOVE 0                      TO MH-CUSTOMER-NO                
           MOVE 0                      TO MH-PREMISE-NO                 
           MOVE WS-SYSTEM              TO MH-USER-ID                    
           MOVE WS-PGRMNAME            TO MH-APPL-PROGRAM-ID            
                                                                        
           IF E-F2040-RECORD-ACTION = WS-ADD                            
C34583        IF CASHONLY-ACCOUNT OR INVALID-ACCOUNT OR SUB-ACCOUNT     
                 MOVE WS-CKFR-ENROL-REJ-LEN    TO MH-TRAN-COMMENT-LEN   
                 MOVE WS-CKFR-ENROL-REJ        TO MH-TRAN-COMMENT-TEXT  
              ELSE                                                      
                 MOVE WS-CKFR-ENROL-LEN        TO MH-TRAN-COMMENT-LEN   
                 MOVE WS-CKFR-ENROL            TO MH-TRAN-COMMENT-TEXT  
              END-IF                                                    
           ELSE                                                         
A4983F        IF E-F2040-RECORD-ACTION = WS-CHG                         
A4983F          MOVE WS-CKFR-ENROL-LEN        TO MH-TRAN-COMMENT-LEN    
A4983F          MOVE WS-CKFR-ENROL            TO MH-TRAN-COMMENT-TEXT   
              ELSE                                                      
                MOVE WS-CKFR-DEENROL-LEN         TO MH-TRAN-COMMENT-LEN 
                MOVE WS-CKFR-DEENROL             TO MH-TRAN-COMMENT-TEXT
A4983F        END-IF                                                    
           END-IF                                                       
           .                                                            
       1420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * POPULATE VALUES TO WRITE MAINTENANCE TRANSACTION HISTORY       *        
      * DETAILS                                                        *        
      *----------------------------------------------------------------*        
       1430-INSERT-MNT-DETAILS.                                         
      *------------------------*                                                
                                                                        
           MOVE 0                         TO MI-TRAN-APPL-NO            
A4983F     IF WS-UPDATE-BILL-COPIES = 'Y'                               
              MOVE WS-CURRENT-TS          TO MI-TRANS-HIST-SEQ-NO       
              MOVE 1                      TO MI-TRAN-APPL-NO            
              MOVE 'NO BILL COPIES'       TO MI-COLUMN-DESC             
              MOVE '  '                   TO MI-TABLE-ID                
              MOVE 1                      TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE 1                      TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE '1'                 TO MI-PRV-COLUMN-VALUE-TEXT      
              MOVE '0'                 TO MI-CHG-COLUMN-VALUE-TEXT      
              PERFORM 8150-INSERT-MNT-DET-TRANS                         
                 THRU 8150-EXIT                                         
           END-IF                                                       
A4983F     IF E-F2040-RECORD-ACTION NOT EQUAL TO WS-CHG                 
           MOVE WS-CURRENT-TS          TO MI-TRANS-HIST-SEQ-NO          
           ADD  1                      TO MI-TRAN-APPL-NO               
           MOVE 'STATUS CODE'          TO MI-COLUMN-DESC                
           MOVE '66'                   TO MI-TABLE-ID                   
           MOVE 1                      TO MI-CHG-COLUMN-VALUE-LEN       
           IF E-F2040-RECORD-ACTION = WS-ADD                            
              MOVE  5                  TO MI-PRV-COLUMN-VALUE-LEN       
              MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT      
              MOVE 'A'                 TO MI-CHG-COLUMN-VALUE-TEXT      
           ELSE                                                         
              MOVE  1                  TO MI-PRV-COLUMN-VALUE-LEN       
              MOVE 'A'                 TO MI-PRV-COLUMN-VALUE-TEXT      
              MOVE 'I'                 TO MI-CHG-COLUMN-VALUE-TEXT      
           END-IF                                                       
           PERFORM 8150-INSERT-MNT-DET-TRANS                            
                 THRU 8150-EXIT                                         
A4983F     END-IF                                                       
      *                                                                         
C29533     IF ((WS-PAPER-ONLY-EXIST  = 'Y') OR                          
C29533         (WS-BILL-NOTIFY-EXIST = 'Y') AND                         
C29533         (E-F2040-RECORD-ACTION = WS-ADD))                        
C29533         MOVE '1430'           TO WS-CALL-PARA                    
C29533         PERFORM 1430C-INSERT-ATT-DET-TRANS                       
C29533            THRU 1430C-EXIT                                       
C29533     END-IF                                                       
           .                                                            
       1430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * POPULATE VALUES TO WRITE MAINTENANCE TRANSACTION HISTORY       *        
      * DETAILS(CALLED ONLY WHEN THE DEACTIVATION IS FROM CHECKFREE)   *        
      *----------------------------------------------------------------*        
       1430A-INSERT-MNT-DETAILS.                                        
      *------------------------*                                                
                                                                        
           MOVE WS-CURRENT-TS          TO MI-TRANS-HIST-SEQ-NO          
           MOVE 1                      TO MI-TRAN-APPL-NO               
           MOVE 'STATUS CODE'          TO MI-COLUMN-DESC                
           MOVE '66'                   TO MI-TABLE-ID                   
           MOVE 1                      TO MI-CHG-COLUMN-VALUE-LEN       
           MOVE  1                     TO MI-PRV-COLUMN-VALUE-LEN       
           MOVE 'A'                    TO MI-PRV-COLUMN-VALUE-TEXT      
           MOVE 'I'                    TO MI-CHG-COLUMN-VALUE-TEXT      
           PERFORM 8150-INSERT-MNT-DET-TRANS                            
                 THRU 8150-EXIT                                         
           .                                                            
       1430A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * POPULATE VALUES TO WRITE MAINTENANCE TRANSACTION HISTORY       *        
      * DETAILS(CALLED ONLY WHEN INACTIVATION IS FROM SCANA )          *        
      *----------------------------------------------------------------*        
       1430B-INSERT-MNT-DETAILS.                                        
      *------------------------*                                                
                                                                        
           MOVE WS-CURRENT-TS          TO MI-TRANS-HIST-SEQ-NO          
           MOVE 1                      TO MI-TRAN-APPL-NO               
           MOVE 'NO BILL COPIES'       TO MI-COLUMN-DESC                
           MOVE '  '                   TO MI-TABLE-ID                   
           MOVE 1                      TO MI-PRV-COLUMN-VALUE-LEN       
           MOVE 1                      TO MI-CHG-COLUMN-VALUE-LEN       
           MOVE '0'                    TO MI-PRV-COLUMN-VALUE-TEXT      
           MOVE '1'                    TO MI-CHG-COLUMN-VALUE-TEXT      
           PERFORM 8150-INSERT-MNT-DET-TRANS                            
              THRU 8150-EXIT                                            
                                                                        
C29533     IF WS-PAPER-ONLY-EXIST  = 'Y' OR                             
C29533        WS-BILL-NOTIFY-EXIST = 'Y'                                
C29533        MOVE '143B'           TO WS-CALL-PARA                     
C29533        PERFORM 7100-SELECT-CIS-ACCOUNT                           
C29533           THRU 7100-EXIT                                         
C29533        PERFORM 1430C-INSERT-ATT-DET-TRANS                        
C29533           THRU 1430C-EXIT                                        
C29533     END-IF                                                       
           .                                                            
       1430B-EXIT.                                                      
           EXIT.                                                        
                                                                        
C29533*-------------------------*                                               
C29533 1430C-INSERT-ATT-DET-TRANS.                                      
C29533*-------------------------*                                               
C29533*                                                                         
C29533     MOVE 'N'  TO WS-EBILL-REGISTER.                              
C29533     PERFORM 8430-EBILL-REGISTER THRU 8430-EXIT.                  
C29533     IF WS-EBILL-REGISTER = 'Y'                                   
C29533        CONTINUE                                                  
C29533     ELSE                                                         
C29533        PERFORM 8430A-EBILL-REGISTER THRU 8430A-EXIT              
C29533     END-IF.                                                      
C29533                                                                  
C29533     MOVE WS-CURRENT-TS          TO MI-TRANS-HIST-SEQ-NO          
C29533     ADD  1                      TO MI-TRAN-APPL-NO               
C29533     MOVE 'BILL NOTIFY OPT'      TO MI-COLUMN-DESC                
C29533     MOVE SPACES                 TO MI-TABLE-ID                   
C29533     IF WS-CALL-PARA = '1430'                                     
C29533        MOVE +15                 TO MI-CHG-COLUMN-VALUE-LEN       
C29533        MOVE 'PAPERLESS/EMAIL'   TO MI-CHG-COLUMN-VALUE-TEXT      
C29533        IF WS-EBILL-REGISTER = 'Y'                                
C29533           MOVE  +15             TO MI-PRV-COLUMN-VALUE-LEN       
C29533           MOVE 'EMAIL AND PAPER' TO MI-PRV-COLUMN-VALUE-TEXT     
C29533        ELSE                                                      
C29533           MOVE  +5              TO MI-PRV-COLUMN-VALUE-LEN       
C29533           MOVE 'PAPER'          TO MI-PRV-COLUMN-VALUE-TEXT      
C29533        END-IF                                                    
C29533     ELSE                                                         
C29533        MOVE  +15                TO MI-PRV-COLUMN-VALUE-LEN       
C29533        MOVE 'PAPERLESS/EMAIL'   TO MI-PRV-COLUMN-VALUE-TEXT      
C29533        IF WS-EBILL-REGISTER = 'Y'                                
C29533           MOVE +15              TO MI-CHG-COLUMN-VALUE-LEN       
C29533           MOVE 'EMAIL AND PAPER' TO MI-CHG-COLUMN-VALUE-TEXT     
C29533        ELSE                                                      
C29533           MOVE  +5              TO MI-CHG-COLUMN-VALUE-LEN       
C29533           MOVE 'PAPER'          TO MI-CHG-COLUMN-VALUE-TEXT      
C29533        END-IF                                                    
C29533     END-IF                                                       
C29533                                                                  
C29533        PERFORM 8150-INSERT-MNT-DET-TRANS                         
C29533           THRU 8150-EXIT                                         
C29533     .                                                            
C29533 1430C-EXIT.                                                      
C29533     EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CHECKS FOR EMAIL_BILLNOTIFY/EMAIL_PAPERONLY ATTRIBUTES IN      *        
      * CSS_ACCT_ATTRIBUTE AND DELETE THEM.                            *        
      *----------------------------------------------------------------*        
       1440-CHECK-ATTRIBUTES.                                           
      *---------------------*                                                   
      *                                                                         
           MOVE WS-N                  TO WS-PAPER-ONLY-EXIST            
           MOVE WS-N                  TO WS-BILL-NOTIFY-EXIST           
           MOVE 'EMAIL_BILLNOTIFY'    TO YP-ATTRIBUTE-DESC              
           PERFORM 8420-CHECK-ACCT-ATTRB                                
              THRU 8420-EXIT                                            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-Y               TO WS-BILL-NOTIFY-EXIST           
           END-IF                                                       
      *                                                                         
           MOVE 'EMAIL_PAPERONLY'     TO YP-ATTRIBUTE-DESC              
           PERFORM 8420-CHECK-ACCT-ATTRB                                
              THRU 8420-EXIT                                            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-Y               TO WS-PAPER-ONLY-EXIST            
           END-IF                                                       
      *                                                                         
           IF WS-BILL-NOTIFY-EXIST = 'Y' OR                             
              WS-PAPER-ONLY-EXIST  = 'Y'                                
              PERFORM 8410-DELETE-ATTRIBUTES                            
                 THRU 8410-EXIT                                         
           END-IF.                                                      
      *                                                                         
       1440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * IF 2040 DETAIL RECORD IS FOR INACTIVATION THEN REMOVE FROM     *        
      * EBILL                                                          *        
      *----------------------------------------------------------------*        
       1500-REMOVE-EBILL.                                               
      *------------------*                                                      
                                                                        
           MOVE WS-CHECKFREE           TO NF-DEST-ID                    
           MOVE AT-ACCOUNT-NO          TO NF-ACCOUNT-NO                 
                                                                        
           PERFORM 8200-UPDATE-EDI-ACCT-DEST                            
              THRU 8200-EXIT                                            
                                                                        
C35914     IF WS-F2040-PROCESSED-FLAG = 'Y'                             
A4983F        MOVE WS-PGMNAME TO WS-PGRMNAME                            
              PERFORM 1420-MOVE-MNTTRANS-VAL                            
                 THRU 1420-EXIT                                         
                                                                        
              PERFORM 8100-INSERT-MNT-HIST-TRANS                        
                 THRU 8100-EXIT                                         
                                                                        
              PERFORM 1430A-INSERT-MNT-DETAILS                          
                 THRU 1430A-EXIT                                        
C35914     END-IF                                                       
           .                                                            
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITE MAINTENANCE TRANSACTION                                  *        
      *----------------------------------------------------------------*        
       1600-WRITE-MNT-HISTORY.                                          
      *-----------------------*                                                 
           MOVE '1600'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 1420-MOVE-MNTTRANS-VAL                               
              THRU 1420-EXIT                                            
                                                                        
           PERFORM 8100-INSERT-MNT-HIST-TRANS                           
              THRU 8100-EXIT                                            
                                                                        
           PERFORM 1430-INSERT-MNT-DETAILS                              
              THRU 1430-EXIT                                            
           .                                                            
       1600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT INACTIVE ACCOUNTS FROM EBILL, WRITE A REPORT AND        *        
      * DELETE THE RECORD.                                             *        
      *----------------------------------------------------------------*        
       1700-PROCESS-EBILL-CURSOR.                                       
      *--------------------------*                                              
           MOVE '1700'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-N                     TO WS-NO-DATA                  
A4983F     MOVE WS-N                     TO WS-UPDATE-BILL-COPIES       
           MOVE WS-PGMNAME    TO WS-PGRMNAME                            
           PERFORM 7510-OPEN-EBILL-CURSOR                               
              THRU 7510-EXIT                                            
                                                                        
           PERFORM 7520-FETCH-EBILL-CURSOR                              
              THRU 7520-EXIT                                            
           PERFORM 1750-PROCESS-RECORDS                                 
              THRU 1750-EXIT UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND    
                                                                        
           PERFORM 7530-CLOSE-EBILL-CURSOR                              
              THRU 7530-EXIT                                            
                                                                        
           IF WS-NO-DATA = WS-N                                         
              ADD 1 TO WS-RPT1-PAGE-NO                                  
              PERFORM 8500-PRINT-HEADER                                 
                 THRU 8500-EXIT                                         
              WRITE PRT33-RECORD FROM WS-NO-DATA-LINE                   
              AFTER ADVANCING WS-2 LINE                                 
           END-IF                                                       
                                                                        
           WRITE PRT33-RECORD FROM WS-END-DATA-LINE                     
              AFTER ADVANCING WS-2 LINE                                 
           .                                                            
       1700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * PROCESS SELECTED INACTIVE EBILL ACCOUNTS                       *        
      *----------------------------------------------------------------*        
       1750-PROCESS-RECORDS.                                            
      *---------------------*                                                   
           MOVE '1750'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-Y                 TO WS-NO-DATA                      
A04983     MOVE WS-N                 TO WS-UPDATE-BILL-COPIES           
           MOVE WS-N                 TO WS-ROW-EXIST                    
                                                                        
           IF WS-RPT1-LINE-NO GREATER THAN WS-54                        
              ADD 1 TO WS-RPT1-PAGE-NO                                  
              PERFORM 8500-PRINT-HEADER                                 
                 THRU 8500-EXIT                                         
           END-IF                                                       
                                                                        
           MOVE NF-ACCOUNT-NO            TO P-ACCOUNT-NO                
                                            WS-ACCOUNT-NO               
                                            AT-ACCOUNT-NO               
                                            BE-ACCOUNT-NO               
                                            HZ-ACCOUNT-NO               
           MOVE NF-STAT-END-DT           TO P-INACTIVE-DATE             
           MOVE NF-STAT-BEGIN-DT         TO P-ACTIVE-DATE               
           MOVE NF-DEST-ID               TO P-EBILL-PROVIDER            
                                                                        
           IF NF-STATUS-CD = 'I' OR                                     
              NF-STATUS-CD = 'B'                                        
              PERFORM 1250-MOVE-2050-VALUES                             
                 THRU 1250-EXIT                                         
              PERFORM 8300-WRITE-2050-REC                               
                 THRU 8300-EXIT                                         
              ADD 1 TO WS-F2050-INA-COUNT                               
           END-IF                                                       
                                                                        
           IF NF-STATUS-CD = 'B'                                        
                                                                        
              PERFORM 7300-GET-CURRENT-TS                               
                 THRU 7300-EXIT                                         
                                                                        
A4983F        MOVE WS-PGMNAME TO WS-PGRMNAME                            
              PERFORM 1420-MOVE-MNTTRANS-VAL                            
                 THRU 1420-EXIT                                         
                                                                        
              PERFORM 8100-INSERT-MNT-HIST-TRANS                        
                 THRU 8100-EXIT                                         
                                                                        
              PERFORM 1430A-INSERT-MNT-DETAILS                          
                 THRU 1430A-EXIT                                        
                                                                        
           END-IF                                                       
                                                                        
           PERFORM 7950-CHECK-EDI-BILL-HDR                              
              THRU 7950-EXIT                                            
                                                                        
           IF WS-ROW-EXIST = 'Y'                                        
ACT366*       PERFORM 1760-CREATE-WORK-QUEUE                                    
ACT366*          THRU 1760-EXIT                                                 
              PERFORM 7960-UPDATE-EDI-BILL-HDR                          
                 THRU 7960-EXIT                                         
           END-IF                                                       
                                                                        
           PERFORM 8520-PRINT-DETAIL-LINE                               
              THRU 8520-EXIT                                            
                                                                        
           PERFORM 8250-DELETE-EDI-ACCT                                 
              THRU 8250-EXIT                                            
                                                                        
                                                                        
           PERFORM 7900-CHECK-BILL-COPIES                               
                 THRU 7900-EXIT                                         
                                                                        
A04983     IF AT-NO-BILL-COPIES = 1                                     
A04983       CONTINUE                                                   
A04983     ELSE                                                         
A04983       MOVE WS-Y TO WS-UPDATE-BILL-COPIES                         
A04983     END-IF                                                       
                                                                        
ACT366     IF WS-ROW-EXIST = 'Y' AND  WS-UPDATE-BILL-COPIES = 'Y'       
ACT366        PERFORM 1760-CREATE-WORK-QUEUE THRU 1760-EXIT             
ACT366     END-IF                                                       
                                                                        
ACT405     IF WS-UPDATE-BILL-COPIES = 'Y'                               
                                                                        
              MOVE 1                        TO AT-NO-BILL-COPIES        
                                                                        
              PERFORM 8050-UPDATE-ACCOUNT                               
                 THRU 8050-EXIT                                         
                                                                        
              PERFORM 7300-GET-CURRENT-TS                               
                 THRU 7300-EXIT                                         
                                                                        
A4983F        MOVE  WS-PGMNAME  TO  WS-PGRMNAME                         
              PERFORM 1420-MOVE-MNTTRANS-VAL                            
                 THRU 1420-EXIT                                         
                                                                        
              PERFORM 8100-INSERT-MNT-HIST-TRANS                        
                 THRU 8100-EXIT                                         
                                                                        
              PERFORM 1430B-INSERT-MNT-DETAILS                          
                 THRU 1430B-EXIT                                        
                                                                        
           END-IF                                                       
              PERFORM 7520-FETCH-EBILL-CURSOR                           
                 THRU 7520-EXIT                                         
           .                                                            
       1750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **   1760-CREATE-WORK-QUEUE                                    **         
      *****************************************************************         
       1760-CREATE-WORK-QUEUE.                                          
      *                                                                         
           PERFORM 7100-SELECT-CIS-ACCOUNT                              
              THRU 7100-EXIT                                            
      *                                                                         
ACT003     INITIALIZE CWS00077-FIELDS                                   
ACT003     MOVE ZERO                  TO WS-ITEM-ID                     
ACT003     MOVE WS-ITEM-ID            TO WS-77-ITEM-ID                  
ACT003     MOVE +82                   TO WS-77-COMMENTS-LEN             
ACT003     MOVE WS-COMMENTS           TO WS-77-COMMENTS-TEXT            
ACT003     MOVE +419                  TO WS-77-CATEGORY-ID              
ACT003     MOVE 'H'                   TO WS-77-PRIORITY                 
ACT003     MOVE '4'                   TO WS-77-ROUTE-CATEGORY           
ACT003     MOVE ZERO                  TO WS-77-SERV-ORDER-NO            
ACT003     MOVE AT-ACCOUNT-NO         TO WS-77-ACCOUNT-NO               
ACT003     MOVE SPACES                TO WS-77-LOCAL-OFFICE             
ACT003     MOVE AT-CUSTOMER-NO        TO WS-77-CUSTOMER-NO              
ACT003     MOVE AT-PREMISE-NO         TO WS-77-PREMISE-NO               
ACT003     MOVE SPACES                TO WS-77-RESP-AREA-ID             
ACT003     MOVE 'SYSTEM'              TO WS-77-USER-ID-ORIG             
ACT003     MOVE ZERO                  TO WS-77-FREE-FORM-LEN            
ACT003     MOVE LOW-VALUES            TO WS-77-FREE-FORM-TXT            
ACT003     MOVE WS-PGMNAME            TO WS-77-CREATED-BY               
                                                                        
           PERFORM 8895-INSERT-WORK-QUEUE     THRU 8895-EXIT            
           .                                                            
       1760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *----------------------------------------------------------------*        
      * IF 2040 DETAIL RECORD IS FOR ACTIVATION THEN CHECK WHETHER CIS *        
      * IS HAVING CUSTOMER E-MAIL ADDRESS IN CSS_CUST_EMAIL TABLE      *        
      * IF NOT ADD THE E-MAIL ADDRESS GIVEN IN THIS 2040 FILE.         *        
      * IF CIS IS HAVING ANY OF THE CUSTOMER E-MAIL ADDRESS WE WILL NOT*        
      * MODIFY THE EXISTING ONE.                                       *        
      *----------------------------------------------------------------*        
       1800-CHECK-EMAIL.                                                
      *-----------------*                                                       
                                                                        
           PERFORM 7400-SELECT-CUST-EMAIL                               
              THRU 7400-EXIT                                            
                                                                        
           IF EMAIL-NOT-IN-CIS                                          
              MOVE AT-CUSTOMER-NO           TO NE-CUSTOMER-NO           
              MOVE WS-P1                    TO NE-EMAIL-TYPE-CD         
              MOVE WS-H                     TO NE-EMAIL-DISP-PREF-CD    
              MOVE WS-SOURCE                TO NE-EMAIL-SOURCE-CD       
              MOVE E-F2040-SUB-EMAIL-ID     TO NE-EMAIL-ADDRESS-TX-TEXT 
              MOVE LENGTH OF NE-EMAIL-ADDRESS-TX-TEXT                   
                                            TO NE-EMAIL-ADDRESS-TX-LEN  
              PERFORM 8400-INSERT-CUST-EMAIL                            
                 THRU 8400-EXIT                                         
           END-IF                                                       
                                                                        
           .                                                            
       1800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * READ INPUT 2040 FILE                                           *        
      *----------------------------------------------------------------*        
       7000-READ-FCS2040.                                               
      *-------------------*                                                     
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           READ FCS2040-FILE                                            
                 AT END                                                 
                 MOVE WS-Y               TO WS-FCS2040-EOF-SW.          
                                                                        
           IF WS-FAC2040-SUCCESSFUL OR WS-FCS2040-AT-EOF                
              IF WS-FAC2040-SUCCESSFUL                                  
                CONTINUE                                                
              ELSE                                                      
                GO TO 7000-EXIT                                         
              END-IF                                                    
           ELSE                                                         
              STRING  'READ ERROR OF FCS2040 INPUT FILE     **'         
                                                      DELIMITED BY SIZE 
              WS-FAC2040-STATUS                     DELIMITED BY SIZE   
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CHECK WHETHER IT IS A VALID ACCOUNT FOR EBILL                  *        
      *----------------------------------------------------------------*        
       7100-SELECT-CIS-ACCOUNT.                                         
      *------------------------*                                                
                                                                        
           MOVE '7100'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             SELECT ACCOUNT_NO                                          
                   ,CUSTOMER_NO                                         
                   ,PREMISE_NO                                          
                   ,ACCT_XFER_TO                                        
                   ,CODE_ACCT_STAT                                      
                   ,COMPANY_NO                                          
C34583             ,MST_SUB_ACCT_IND                                    
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-PREMISE-NO                                      
                   ,:AT-ACCT-XFER-TO                                    
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-COMPANY-NO                                      
C34583             ,:AT-MST-SUB-ACCT-IND                                
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                     
C35914                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT ACCOUNT_NO                                                  
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*            ,PREMISE_NO                                                  
MFA-TR*            ,ACCT_XFER_TO                                                
MFA-TR*            ,CODE_ACCT_STAT                                              
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,MST_SUB_ACCT_IND                                            
MFA-TR*        INTO :AT-ACCOUNT-NO                                              
MFA-TR*            ,:AT-CUSTOMER-NO                                             
MFA-TR*            ,:AT-PREMISE-NO                                              
MFA-TR*            ,:AT-ACCT-XFER-TO                                            
MFA-TR*            ,:AT-CODE-ACCT-STAT                                          
MFA-TR*            ,:AT-COMPANY-NO                                              
MFA-TR*            ,:AT-MST-SUB-ACCT-IND                                        
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*       WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                 SET VALID-ACCOUNT     TO TRUE                          
               WHEN NOT-FOUND                                           
                 SET INVALID-ACCOUNT   TO TRUE                          
               WHEN OTHER                                               
                 STRING 'CHECKING WHETHER AN A/C IS VALID FOR EBILL **' 
                         DELIMITED BY SIZE                              
                         INTO WS-ERR-MSG                                
                 STRING 'ACCOUNT NO    '                                
                         DELIMITED BY SIZE                              
                         WS-ACCOUNT-NO  DELIMITED BY SIZE               
                         INTO  WS-ERR-MSG2                              
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-EVALUATE                                                 
C34583                                                                  
C34583     MOVE AT-MST-SUB-ACCT-IND TO WS-SUB-ACCOUNT                   
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CHECK WHETHER CASH ONLY FLAG IS SET FOR AN ACCOUNT             *        
      *----------------------------------------------------------------*        
       7200-CHK-CASH-ONLY-FL.                                           
      *---------------------*                                                   
                                                                        
           MOVE '7200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT CASH_ONLY_FL                                        
               INTO :CZ-CASH-ONLY-FL                                    
               FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                         
C35914                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CASH_ONLY_FL                                                
MFA-TR*        INTO :CZ-CASH-ONLY-FL                                            
MFA-TR*        FROM CSS_CREDIT_PROFILE                                          
MFA-TR*       WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING '** SELECTING CASH ONLY FLAG ' DELIMITED BY SIZE   
                     'FROM CSS_CREDIT_PROFILE **  ' DELIMITED BY SIZE   
                      INTO WS-ERR-MSG                                   
              STRING 'ACCOUNT NO '                  DELIMITED BY SIZE   
                      WS-ACCOUNT-NO                 DELIMITED BY SIZE   
                      INTO WS-ERR-MSG2                                  
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * GET CURRENT TIMESTAMP                                          *        
      *----------------------------------------------------------------*        
       7300-GET-CURRENT-TS.                                             
      *--------------------*                                                    
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
T35434       SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TS,
              :WS-CREATE-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-TS  = CURRENT TIMESTAMP                            
MFA-TR*         ,:WS-CREATE-DATE = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
T35434        STRING '** SETTING CURRENT TIMESTAMP ' DELIMITED BY SIZE  
                      INTO WS-ERR-MSG                                   
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CHECK WHETHER CIS IS HAVING ANY OF CUSTOMER EMAIL ADDRESS      *        
      *----------------------------------------------------------------*        
       7400-SELECT-CUST-EMAIL.                                          
      *------------------------*                                                
                                                                        
           MOVE '7400'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           MOVE AT-CUSTOMER-NO         TO WS-CUSTOMER-NO.               
           MOVE WS-N                   TO WS-CIS-HAS-EMAIL.             
                                                                        
           EXEC SQL                                                     
             SELECT CUSTOMER_NO                                         
               INTO :NE-CUSTOMER-NO                                     
               FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                        
              WHERE CUSTOMER_NO    = :AT-CUSTOMER-NO                    
ACT026        AND   EMAIL_TYPE_CD  = 'P1'                               
C35914                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CUSTOMER_NO                                                 
MFA-TR*        INTO :NE-CUSTOMER-NO                                             
MFA-TR*        FROM CSS_CUST_EMAIL                                              
MFA-TR*       WHERE CUSTOMER_NO    = :AT-CUSTOMER-NO                            
MFA-TR*       AND   EMAIL_TYPE_CD  = 'P1'                                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                 SET EMAIL-IN-CIS      TO TRUE                          
               WHEN NOT-FOUND                                           
                 SET EMAIL-NOT-IN-CIS  TO TRUE                          
               WHEN OTHER                                               
                 STRING 'CHECKING WHETHER CIS IS HAVING CUST EMAIL  **' 
                         DELIMITED BY SIZE                              
                         INTO WS-ERR-MSG                                
                 STRING 'CUSTOMER NO   '                                
                         DELIMITED BY SIZE                              
                         WS-CUSTOMER-NO  DELIMITED BY SIZE              
                         INTO  WS-ERR-MSG2                              
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-EVALUATE                                                 
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * OPEN EBILL CURSOR FOR REPORTING                                *        
      *----------------------------------------------------------------*        
       7510-OPEN-EBILL-CURSOR.                                          
      *-----------------------*                                                 
           MOVE '7510'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN EDI_ACCT                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING '** ERROR OPENING EDI_ACCT CURSOR '                
                                                       DELIMITED BY SIZE
                     'FROM CSS_EDI_ACCT_DEST TABLE **' DELIMITED BY SIZE
                      INTO WS-ERR-MSG                                   
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * FETCH INACTIVATED ACCOUNTS                                     *        
      *----------------------------------------------------------------*        
       7520-FETCH-EBILL-CURSOR.                                         
      *------------------------*                                                
           MOVE '7520'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH EDI_ACCT                                            
               INTO :NF-ACCOUNT-NO                                      
                   ,:NF-STATUS-CD                                       
                   ,:NF-DEST-ID                                         
                   ,:NF-STAT-BEGIN-DT                                   
                   ,:NF-STAT-END-DT                                     
                   ,:AT-COMPANY-NO                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING '** ERROR FETCHING EDI_ACCT CURSOR '               
                                                       DELIMITED BY SIZE
                     'FROM CSS_EDI_ACCT_DEST TABLE **' DELIMITED BY SIZE
                      INTO WS-ERR-MSG                                   
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE EBILL CURSOR                                             *        
      *----------------------------------------------------------------*        
       7530-CLOSE-EBILL-CURSOR.                                         
      *------------------------*                                                
           MOVE '7530'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE EDI_ACCT                                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING '** ERROR CLOSING EDI_ACCT CURSOR '                
                                                       DELIMITED BY SIZE
                     'FROM CSS_EDI_ACCT_DEST TABLE **' DELIMITED BY SIZE
                      INTO WS-ERR-MSG                                   
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT DELINQUENCY VALUE FROM DELINQUENCY CODE                 *        
      *----------------------------------------------------------------*        
       7800-SELECT-DELINQ.                                              
      *-------------------*                                                     
           MOVE '7800'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT DELINQ_VALUE                                         
                  ,DESCRIPTION                                          
              INTO :C8-DELINQ-VALUE                                     
                  ,:C8-DESCRIPTION                                      
              FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                        
             WHERE COMPANY_NO           = :C8-COMPANY-NO                
               AND DELINQ_CD            = :C8-DELINQ-CD                 
C35914                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT DELINQ_VALUE                                                 
MFA-TR*           ,DESCRIPTION                                                  
MFA-TR*       INTO :C8-DELINQ-VALUE                                             
MFA-TR*           ,:C8-DESCRIPTION                                              
MFA-TR*       FROM CSS_DELINQUENCY                                              
MFA-TR*      WHERE COMPANY_NO           = :C8-COMPANY-NO                        
MFA-TR*        AND DELINQ_CD            = :C8-DELINQ-CD                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 STRING 'ERROR SELECTING DELINQUENCY CODE **'           
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
                 STRING 'DELINQUENCY CODE '  DELIMITED BY SIZE          
                         C8-DELINQ-CD,       DELIMITED BY SIZE          
                         'COMPANY NO  '      DELIMITED BY SIZE          
                          C8-COMPANY-NO      DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           END-IF                                                       
           .                                                            
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CHECK WHETHER NO.OF BILL COPIES ARE UPDATED TO 0 DURING BILLING*        
      *----------------------------------------------------------------*        
       7900-CHECK-BILL-COPIES.                                          
      *-------------------*                                                     
           MOVE '7900'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT NO_BILL_COPIES                                      
               INTO :AT-NO-BILL-COPIES                                  
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
              WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                     
C35914                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT NO_BILL_COPIES                                              
MFA-TR*        INTO :AT-NO-BILL-COPIES                                          
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*       WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A4983F        CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR SELECTING CSS_ACCOUNT **'                  
                                          DELIMITED BY SIZE             
                                          INTO WS-ERR-MSG               
              STRING 'ACCOUNT NO = '      DELIMITED BY SIZE             
                      WS-ACCOUNT-NO       DELIMITED BY SIZE             
                                          INTO WS-ERR-MSG2              
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CHECK FOR EDI BILLS WITH READY/RESEND STATUS IN CSS_EDI_BILL_HDR        
      *----------------------------------------------------------------*        
       7950-CHECK-EDI-BILL-HDR.                                         
      *-----------------------*                                                 
           MOVE '7950'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT 'Y'                                                 
               INTO :WS-ROW-EXIST                                       
               FROM CSS_EDI_BILL_HDR HZ WITH(READUNCOMMITTED)                   
                   ,CSS_EDI_ACCT_DEST NF WITH(READUNCOMMITTED)                  
              WHERE HZ.ACCOUNT_NO     = :HZ-ACCOUNT-NO                  
                AND HZ.STATUS_CD      IN ('R','D')                      
                AND NF.ACCOUNT_NO     = HZ.ACCOUNT_NO                   
                AND NF.DEST_ID        = 'CHECKFREE'                     
C35914                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-ROW-EXIST                                               
MFA-TR*        FROM CSS_EDI_BILL_HDR HZ                                         
MFA-TR*            ,CSS_EDI_ACCT_DEST NF                                        
MFA-TR*       WHERE HZ.ACCOUNT_NO     = :HZ-ACCOUNT-NO                          
MFA-TR*         AND HZ.STATUS_CD      IN ('R','D')                              
MFA-TR*         AND NF.ACCOUNT_NO     = HZ.ACCOUNT_NO                           
MFA-TR*         AND NF.DEST_ID        = 'CHECKFREE'                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                      OR WS-811                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR WS-811      
                 MOVE WS-Y           TO WS-ROW-EXIST                    
              ELSE                                                      
                 MOVE WS-N           TO WS-ROW-EXIST                    
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR SELECTING CSS_EDI_BILL_HDR **'             
                                          DELIMITED BY SIZE             
                                          INTO WS-ERR-MSG               
              STRING 'ACCOUNT NO = '      DELIMITED BY SIZE             
                      WS-ACCOUNT-NO       DELIMITED BY SIZE             
                                          INTO WS-ERR-MSG2              
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * UPDATE EDI BILLS WITH READY/RESEND STATUS IN CSS_EDI_BILL_HDR*          
      *----------------------------------------------------------------*        
       7960-UPDATE-EDI-BILL-HDR.                                        
      *-----------------------*                                                 
           MOVE '7960'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_EDI_BILL_HDR                                    
                SET STATUS_CD  = 'X'                                    
                   ,LAST_UPDATE_USERID = 'SYSTEM'                       
                   ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()              
              WHERE ACCOUNT_NO = :HZ-ACCOUNT-NO                         
                AND STATUS_CD  IN ('R','D')                             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_EDI_BILL_HDR                                            
MFA-TR*         SET STATUS_CD  = 'X'                                            
MFA-TR*            ,LAST_UPDATE_USERID = 'SYSTEM'                               
MFA-TR*            ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                      
MFA-TR*       WHERE ACCOUNT_NO = :HZ-ACCOUNT-NO                                 
MFA-TR*         AND STATUS_CD  IN ('R','D')                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR UPDATING CSS_EDI_BILL_HDR **'              
                                          DELIMITED BY SIZE             
                                          INTO WS-ERR-MSG               
              STRING 'ACCOUNT NO = '      DELIMITED BY SIZE             
                      WS-ACCOUNT-NO       DELIMITED BY SIZE             
                                          INTO WS-ERR-MSG2              
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * INSERT A ROW IN CSS_EDI_ACCT_DEST TABLE                        *        
      *----------------------------------------------------------------*        
       8000-INSERT-EDI-ACCT.                                            
      *---------------------*                                                   
                                                                        
           MOVE '8000'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_EDI_ACCT_DEST                              
                (                                                       
                 ACCOUNT_NO                                             
                ,DEST_ID                                                
                ,AUTOMATIC_EMAIL_FL                                     
                ,EDI_ID_QUAL                                            
                ,EDI_RECEIVER_ID                                        
                ,EMAIL_GROUP                                            
                ,LAST_UPDATE_TS                                         
                ,LAST_UPDATE_USERID                                     
                ,STAT_BEGIN_DT                                          
                ,STAT_END_DT                                            
                ,STATUS_CD                                              
                ,HOLD_DAYS_NO                                           
                ) VALUES                                                
                (                                                       
                 :NF-ACCOUNT-NO                                         
                ,:NF-DEST-ID                                            
                ,:NF-AUTOMATIC-EMAIL-FL                                 
                ,:NF-EDI-ID-QUAL                                        
                ,:NF-EDI-RECEIVER-ID                                    
                ,:NF-EMAIL-GROUP                                        
                ,CIS.CURRENT$TIMESTAMP()                                      
                ,:NF-LAST-UPDATE-USERID                                 
                ,CAST(SYSDATETIMEOFFSET() AS DATE)                              
                ,IIF(TRY_CONVERT(DATE, :NF-STAT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :NF-STAT-END-DT
              ) <> 0) OR (LEN(:NF-STAT-END-DT) <> 10), CIS.CHAR2DATE(
                                                        :NF-STAT-END-DT
              ), CONVERT(DATE, :NF-STAT-END-DT) )                              
                ,:NF-STATUS-CD                                          
                ,:NF-HOLD-DAYS-NO                                       
                )                                                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_EDI_ACCT_DEST                                      
MFA-TR*         (                                                               
MFA-TR*          ACCOUNT_NO                                                     
MFA-TR*         ,DEST_ID                                                        
MFA-TR*         ,AUTOMATIC_EMAIL_FL                                             
MFA-TR*         ,EDI_ID_QUAL                                                    
MFA-TR*         ,EDI_RECEIVER_ID                                                
MFA-TR*         ,EMAIL_GROUP                                                    
MFA-TR*         ,LAST_UPDATE_TS                                                 
MFA-TR*         ,LAST_UPDATE_USERID                                             
MFA-TR*         ,STAT_BEGIN_DT                                                  
MFA-TR*         ,STAT_END_DT                                                    
MFA-TR*         ,STATUS_CD                                                      
MFA-TR*         ,HOLD_DAYS_NO                                                   
MFA-TR*         ) VALUES                                                        
MFA-TR*         (                                                               
MFA-TR*          :NF-ACCOUNT-NO                                                 
MFA-TR*         ,:NF-DEST-ID                                                    
MFA-TR*         ,:NF-AUTOMATIC-EMAIL-FL                                         
MFA-TR*         ,:NF-EDI-ID-QUAL                                                
MFA-TR*         ,:NF-EDI-RECEIVER-ID                                            
MFA-TR*         ,:NF-EMAIL-GROUP                                                
MFA-TR*         ,CURRENT TIMESTAMP                                              
MFA-TR*         ,:NF-LAST-UPDATE-USERID                                         
MFA-TR*         ,CURRENT DATE                                                   
MFA-TR*         ,:NF-STAT-END-DT                                                
MFA-TR*         ,:NF-STATUS-CD                                                  
MFA-TR*         ,:NF-HOLD-DAYS-NO                                               
MFA-TR*         )                                                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C35914           ADD +1                  TO WS-F2040-ADD-COUNT          
C35914           MOVE 'Y'                TO WS-F2040-PROCESSED-FLAG     
C35914*       CONTINUE                                                          
           ELSE                                                         
C35914        IF WS-ACTIVE-RETURN-CODE =  ALREADY-EXISTS                
C35914           MOVE 'N'                TO WS-F2040-PROCESSED-FLAG     
C35914           ADD +1                  TO WS-F2040-NPO-COUNT          
C35914           DISPLAY 'ACCOUNT ALREADY EXISTS   ' WS-ACCOUNT-NO      
C35914           IF  WS-F2040-NPO-COUNT = WS-ACCOUNTNO-COUNT            
C35914               STRING ' NOT PROCESSED ACCOUNTS ARE MORE '         
C35914                                      DELIMITED BY SIZE           
C35914                                      INTO WS-ERR-MSG             
C35914               STRING ' AS THERE ARE LOT OF DUPLICATES '          
C35914                                      DELIMITED BY SIZE           
C35914                                      INTO WS-ERR-MSG2            
C35914                 PERFORM 8800-DIS-TABLE-ERROR                     
C35914                    THRU 8800-EXIT                                
C35914           END-IF                                                 
C35914        ELSE                                                      
                STRING ' ERROR INSERTING INTO CSS_EDI_ACCT_DEST **'     
                                            DELIMITED BY SIZE           
                                            INTO WS-ERR-MSG             
                STRING 'ACCOUNT NO = '      DELIMITED BY SIZE           
                        WS-ACCOUNT-NO       DELIMITED BY SIZE           
                       ',DEST_ID  = '       DELIMITED BY SIZE           
                        NF-DEST-ID          DELIMITED BY SIZE           
                                            INTO WS-ERR-MSG2            
                                                                        
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
C35914       END-IF                                                     
           END-IF                                                       
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * UPDATE NO OF BILL COPIES                                       *        
      *----------------------------------------------------------------*        
       8050-UPDATE-ACCOUNT.                                             
      *--------------------*                                                    
                                                                        
           MOVE '8050'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_ACCOUNT                                         
                SET NO_BILL_COPIES = :AT-NO-BILL-COPIES                 
                   ,LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()                  
              WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_ACCOUNT                                                 
MFA-TR*         SET NO_BILL_COPIES = :AT-NO-BILL-COPIES                         
MFA-TR*            ,LAST_UPDATE_TS = CURRENT TIMESTAMP                          
MFA-TR*       WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR UPDATING CSS_ACCOUNT **'                   
                                          DELIMITED BY SIZE             
                                          INTO WS-ERR-MSG               
              STRING 'ACCOUNT NO = '      DELIMITED BY SIZE             
                      WS-ACCOUNT-NO       DELIMITED BY SIZE             
                                          INTO WS-ERR-MSG2              
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *  INSERT A ROW IN TO MAINTENANCE HISTORY TABLE                  *        
      *----------------------------------------------------------------*        
       8100-INSERT-MNT-HIST-TRANS.                                      
      *---------------------------*                                             
                                                                        
           MOVE '8100'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_MNT_TRANS_HIST                             
                (                                                       
                 TRANS_HIST_SEQ_NO                                      
                ,DATE_TRANS                                             
                ,CODE_TRAN_TYPE                                         
                ,RESP_AREA_ID                                           
                ,ACCOUNT_NO                                             
                ,CUSTOMER_NO                                            
                ,PREMISE_NO                                             
                ,USER_ID                                                
                ,APPL_PROGRAM_ID                                        
                ,TRAN_COMMENT                                           
                ) VALUES                                                
                (                                                       
                 CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO)                      
                ,CAST(SYSDATETIMEOFFSET() AS DATE)                              
                ,:MH-CODE-TRAN-TYPE                                     
                ,:MH-RESP-AREA-ID                                       
                ,:MH-ACCOUNT-NO                                         
                ,:MH-CUSTOMER-NO                                        
                ,:MH-PREMISE-NO                                         
                ,:MH-USER-ID                                            
                ,:MH-APPL-PROGRAM-ID                                    
                ,:MH-TRAN-COMMENT                                       
                )                                                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_MNT_TRANS_HIST                                     
MFA-TR*         (                                                               
MFA-TR*          TRANS_HIST_SEQ_NO                                              
MFA-TR*         ,DATE_TRANS                                                     
MFA-TR*         ,CODE_TRAN_TYPE                                                 
MFA-TR*         ,RESP_AREA_ID                                                   
MFA-TR*         ,ACCOUNT_NO                                                     
MFA-TR*         ,CUSTOMER_NO                                                    
MFA-TR*         ,PREMISE_NO                                                     
MFA-TR*         ,USER_ID                                                        
MFA-TR*         ,APPL_PROGRAM_ID                                                
MFA-TR*         ,TRAN_COMMENT                                                   
MFA-TR*         ) VALUES                                                        
MFA-TR*         (                                                               
MFA-TR*          :MH-TRANS-HIST-SEQ-NO                                          
MFA-TR*         ,CURRENT DATE                                                   
MFA-TR*         ,:MH-CODE-TRAN-TYPE                                             
MFA-TR*         ,:MH-RESP-AREA-ID                                               
MFA-TR*         ,:MH-ACCOUNT-NO                                                 
MFA-TR*         ,:MH-CUSTOMER-NO                                                
MFA-TR*         ,:MH-PREMISE-NO                                                 
MFA-TR*         ,:MH-USER-ID                                                    
MFA-TR*         ,:MH-APPL-PROGRAM-ID                                            
MFA-TR*         ,:MH-TRAN-COMMENT                                               
MFA-TR*         )                                                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR INSERTING INTO CSS_MNT_TRANS_HIST **'      
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              STRING 'ACCOUNT NO = '         DELIMITED BY SIZE          
                      WS-ACCOUNT-NO          DELIMITED BY SIZE          
                     ',TRANS HIST SEQ NO'    DELIMITED BY SIZE          
                      MH-TRANS-HIST-SEQ-NO   DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG2           
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * INSERT A ROW IN TO MAINTENANCE HISTORY DETAIL TABLE            *        
      *----------------------------------------------------------------*        
       8150-INSERT-MNT-DET-TRANS.                                       
      *---------------------------*                                             
                                                                        
           MOVE '8150'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_MT_TRN_HST_DET                             
                (                                                       
                 TRANS_HIST_SEQ_NO                                      
                ,TRAN_APPL_NO                                           
                ,COLUMN_DESC                                            
                ,TABLE_ID                                               
                ,PRV_COLUMN_VALUE                                       
                ,CHG_COLUMN_VALUE                                       
                ) VALUES                                                
                (                                                       
                 CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO)                      
                ,:MI-TRAN-APPL-NO                                       
                ,:MI-COLUMN-DESC                                        
                ,:MI-TABLE-ID                                           
                ,:MI-PRV-COLUMN-VALUE                                   
                ,:MI-CHG-COLUMN-VALUE                                   
                )                                                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_MT_TRN_HST_DET                                     
MFA-TR*         (                                                               
MFA-TR*          TRANS_HIST_SEQ_NO                                              
MFA-TR*         ,TRAN_APPL_NO                                                   
MFA-TR*         ,COLUMN_DESC                                                    
MFA-TR*         ,TABLE_ID                                                       
MFA-TR*         ,PRV_COLUMN_VALUE                                               
MFA-TR*         ,CHG_COLUMN_VALUE                                               
MFA-TR*         ) VALUES                                                        
MFA-TR*         (                                                               
MFA-TR*          :MI-TRANS-HIST-SEQ-NO                                          
MFA-TR*         ,:MI-TRAN-APPL-NO                                               
MFA-TR*         ,:MI-COLUMN-DESC                                                
MFA-TR*         ,:MI-TABLE-ID                                                   
MFA-TR*         ,:MI-PRV-COLUMN-VALUE                                           
MFA-TR*         ,:MI-CHG-COLUMN-VALUE                                           
MFA-TR*         )                                                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR INSERTING INTO CSS_MT_TRN_HST_DET **'      
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              STRING 'ACCOUNT NO = '         DELIMITED BY SIZE          
                      WS-ACCOUNT-NO          DELIMITED BY SIZE          
                     ',TRANS HIST SEQ NO'    DELIMITED BY SIZE          
                      MH-TRANS-HIST-SEQ-NO   DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG2           
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * INACTIVATE AN ACCOUNT FROM THIRDPARTY EBILL                    *        
      * STATUS CD 'D' WAS POPULATED , ACCOUNT WITH THIS STATUS CODE    *        
      * ARE NOT REPORTED IN 2050 REQ FILE BUT DELETED BY THE END OF    *        
      * PROCESS.                                                       *        
      *----------------------------------------------------------------*        
       8200-UPDATE-EDI-ACCT-DEST.                                       
      *--------------------------*                                              
                                                                        
           MOVE '8200'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_EDI_ACCT_DEST                                   
                SET STATUS_CD          = :WS-D                          
                   ,STAT_END_DT        = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                   ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()              
                   ,LAST_UPDATE_USERID = 'PCAC183'                      
              WHERE ACCOUNT_NO         = :NF-ACCOUNT-NO                 
                AND DEST_ID            = :NF-DEST-ID                    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_EDI_ACCT_DEST                                           
MFA-TR*         SET STATUS_CD          = :WS-D                                  
MFA-TR*            ,STAT_END_DT        = CURRENT DATE                           
MFA-TR*            ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                      
MFA-TR*            ,LAST_UPDATE_USERID = 'PCAC183'                              
MFA-TR*       WHERE ACCOUNT_NO         = :NF-ACCOUNT-NO                         
MFA-TR*         AND DEST_ID            = :NF-DEST-ID                            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C35914          ADD +1                  TO WS-F2040-INA-COUNT           
C35914          MOVE 'Y'                TO WS-F2040-PROCESSED-FLAG      
C35914*        CONTINUE                                                         
           ELSE                                                         
C35914       IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
C35914          ADD +1                  TO WS-F2040-NPO-COUNT           
C35914          DISPLAY 'ACCOUNT ALREADY INACTIVATED  ' WS-ACCOUNT-NO   
C35914          MOVE 'N'                TO WS-F2040-PROCESSED-FLAG      
C35914           IF  WS-F2040-NPO-COUNT = WS-ACCOUNTNO-COUNT            
C35914               STRING ' NOT PROCESSED ACCOUNTS ARE MORE '         
C35914                                      DELIMITED BY SIZE           
C35914                                      INTO WS-ERR-MSG             
C35914               STRING ' AS THERE ARE LOT OF DUPLICATES '          
C35914                                      DELIMITED BY SIZE           
C35914                                      INTO WS-ERR-MSG2            
C35914                 PERFORM 8800-DIS-TABLE-ERROR                     
C35914                    THRU 8800-EXIT                                
C35914           END-IF                                                 
C35914       ELSE                                                       
                STRING ' ERROR UPDATING CSS_EDI_ACCT_DEST **'           
                                            DELIMITED BY SIZE           
                                            INTO WS-ERR-MSG             
                STRING 'ACCOUNT NO = '      DELIMITED BY SIZE           
                        WS-ACCOUNT-NO       DELIMITED BY SIZE           
                       ',DEST_ID  = '       DELIMITED BY SIZE           
                        NF-DEST-ID          DELIMITED BY SIZE           
                                            INTO WS-ERR-MSG2            
                                                                        
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
C35914       END-IF                                                     
           END-IF                                                       
           .                                                            
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETE A ROW FROM CSS_EDI_ACCT_DEST TABLE                      *        
      *----------------------------------------------------------------*        
       8250-DELETE-EDI-ACCT.                                            
                                                                        
           MOVE '8250'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_EDI_ACCT_DEST                             
               WHERE ACCOUNT_NO = :NF-ACCOUNT-NO                        
                 AND DEST_ID    = 'CHECKFREE'                           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR DELETING CSS_EDI_ACCT_DEST **'             
                                          DELIMITED BY SIZE             
                                          INTO WS-ERR-MSG               
              STRING 'ACCOUNT NO = '      DELIMITED BY SIZE             
                      WS-ACCOUNT-NO       DELIMITED BY SIZE             
                     ',DEST_ID  = '       DELIMITED BY SIZE             
                      NF-DEST-ID          DELIMITED BY SIZE             
                                          INTO WS-ERR-MSG2              
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITE A RECORD IN 2050 FILE                                    *        
      *----------------------------------------------------------------*        
       8300-WRITE-2050-REC.                                             
                                                                        
           MOVE '8300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           IF E-F2040-RECORD-TYPE-0001 = '0000'                         
              MOVE FIO2040-BEGIN-REC    TO FIO2050-BEGIN-REC            
              MOVE E-F2040-SENDER-ID    TO E-F2050-RECEIVER-ID          
              MOVE E-F2040-RECEIVER-ID  TO E-F2050-SENDER-ID            
              MOVE WS-CREATE-DATE(1:2)  TO WS-CD-CC                     
              MOVE WS-CREATE-DATE(3:2)  TO WS-CD-YY                     
              MOVE WS-CREATE-DATE(6:2)  TO WS-CD-MM                     
              MOVE WS-CREATE-DATE(9:2)  TO WS-CD-DD                     
              MOVE WS-CURRENT-DATE      TO E-F2050-FILE-CREATE-DATE     
              MOVE WS-CURRENT-TS(12:2)  TO WS-TS-HH                     
              MOVE WS-CURRENT-TS(15:2)  TO WS-TS-MM                     
              MOVE WS-CURRENT-TS(18:2)  TO WS-TS-SS                     
              MOVE WS-CURRENT-TS(21:6)  TO WS-TS-MS                     
              MOVE WS-CREATE-TS         TO E-F2050-FILE-CREATE-TIME     
           ELSE                                                         
              IF E-F2040-RECORD-TYPE-0001 = '9999'                      
                 AND END-OF-RECORD                                      
                 MOVE FIO2040-END-REC      TO FIO2050-END-REC           
                 MOVE '2050'               TO E-F2050-RECORD-TYPE2      
                 COMPUTE WS-F2050-REC-COUNT =                           
                         WS-F2040-REC-COUNT +                           
                         WS-F2050-INA-COUNT                             
                 MOVE WS-F2050-REC-COUNT   TO E-F2050-NO-OF-RECORDS2    
              END-IF                                                    
           END-IF                                                       
                                                                        
           WRITE FIO2050                                                
                                                                        
           IF WS-FAC2050-SUCCESSFUL                                     
              CONTINUE                                                  
           ELSE                                                         
              STRING '** FILE WRITE ERROR FCS2050 **' DELIMITED BY SIZE 
              WS-FAC2050-STATUS                       DELIMITED BY SIZE 
                                         INTO WS-ERR-MSG                
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
           .                                                            
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * INSERT A ROW IN TO CUST EMAIL TABLE                            *        
      *----------------------------------------------------------------*        
       8400-INSERT-CUST-EMAIL.                                          
      *---------------------------*                                             
                                                                        
           MOVE '8400'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CUST_EMAIL                                 
                (                                                       
                 CUSTOMER_NO                                            
                ,EMAIL_TYPE_CD                                          
                ,EMAIL_DISP_PREF_CD                                     
                ,EMAIL_ADDRESS_TX                                       
                ,EMAIL_SOURCE_CD                                        
                ) VALUES                                                
                (                                                       
                 :NE-CUSTOMER-NO                                        
                ,:NE-EMAIL-TYPE-CD                                      
                ,:NE-EMAIL-DISP-PREF-CD                                 
                ,:NE-EMAIL-ADDRESS-TX                                   
                ,:NE-EMAIL-SOURCE-CD                                    
                )                                                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR INSERTING INTO CSS_CUST-EMAIL  **'         
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              STRING 'CUSTOMER NO ='         DELIMITED BY SIZE          
                      WS-CUSTOMER-NO         DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG2           
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29533*****************************************************************         
C29533* 8410-DELETE-ATTRIBUTES.                                       *         
C29533*  DELETE SPECIFIED ACCT ATTRIBUTE ROWS WHEN ACCOUNT IS SET UP  *         
C29533*  OR REMOVED FROM CHECKFREE E-BILL.                            *         
C29533*****************************************************************         
C29533 8410-DELETE-ATTRIBUTES.                                          
C29533                                                                  
C29533     MOVE '8410'                 TO WS-ACTIVE-PARAGRAPH.          
C29533     EXEC SQL                                                     
C29533         DELETE FROM CSS_ACCT_ATTRIBUTE                           
C29533         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
C29533         AND ATTRIBUTE_DESC IN ('EMAIL_BILLNOTIFY',               
C29533                               'EMAIL_PAPERONLY')                 
C29533     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29533                                                                  
C29533     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29533                                                                  
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29533        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C29533           MOVE ZEROES            TO WS-ACTIVE-RETURN-CODE        
C29533        END-IF                                                    
C29533     ELSE                                                         
C29533        STRING 'ACCOUNT NO = '         DELIMITED BY SIZE          
C29533                WS-ACCOUNT-NO          DELIMITED BY SIZE          
C29533                                       INTO WS-ERR-MSG2           
C29533        PERFORM 8800-DIS-TABLE-ERROR                              
C29533           THRU 8800-EXIT                                         
C29533     END-IF.                                                      
C29533                                                                  
C29533 8410-EXIT.                                                       
C29533     EXIT.                                                        
C29533******************************************************************07969900
C29533* 8420-CHECK-ACCT-ATTRB                                          *07492029
C29533*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
C29533******************************************************************07550000
C29533 8420-CHECK-ACCT-ATTRB.                                           
C29533                                                                  
C29533     MOVE '8420'                TO WS-ACTIVE-PARAGRAPH            
C29533     EXEC SQL                                                     
C29533          SELECT YP.ACCOUNT_NO                                    
C29533            INTO :YP-ACCOUNT-NO                                   
C29533            FROM CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                   
C29533                ,CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)              
C29533           WHERE YP.ACCOUNT_NO        = :AT-ACCOUNT-NO            
C29533             AND WZ.COMPANY_NO        = :AT-COMPANY-NO            
C29533             AND WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
C29533             AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC        
C29533             AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
C35914                                                           
C29533     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT YP.ACCOUNT_NO                                            
MFA-TR*           INTO :YP-ACCOUNT-NO                                           
MFA-TR*           FROM CSS_ATTRIBUTE WZ                                         
MFA-TR*               ,CSS_ACCT_ATTRIBUTE YP                                    
MFA-TR*          WHERE YP.ACCOUNT_NO        = :AT-ACCOUNT-NO                    
MFA-TR*            AND WZ.COMPANY_NO        = :AT-COMPANY-NO                    
MFA-TR*            AND WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC                 
MFA-TR*            AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC                
MFA-TR*            AND WZ.ATTRIBUTE_STAT_CD = 'A'                               
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29533                                                                  
C29533     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29533                                                                  
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29533        NEXT SENTENCE                                             
C29533     ELSE                                                         
C29533        STRING 'ACCOUNT NO = '         DELIMITED BY SIZE          
C29533                WS-ACCOUNT-NO          DELIMITED BY SIZE          
C29533                                       INTO WS-ERR-MSG2           
C29533        PERFORM 8800-DIS-TABLE-ERROR                              
C29533           THRU 8800-EXIT                                         
C29533     END-IF.                                                      
C29533                                                                  
C29533 8420-EXIT.                                                       
C29533     EXIT.                                                        
C29533******************************************************************        
C29533* 8430-EBILL-REGISTER                                            *        
C29533*     CHECK EBILL-REGISTER_IND                                   *        
C29533******************************************************************        
C29533                                                                  
C29533 8430-EBILL-REGISTER.                                             
C29533                                                                  
C29533     MOVE '8430'              TO WS-ACTIVE-PARAGRAPH              
C29533     EXEC SQL                                                     
C29533        SELECT EBILL_REGISTER_IND                                 
C29533          INTO :CE-EBILL-REGISTER-IND                             
C29533          FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
C29533         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
C29533           AND CUSTOMER_TYPE = 'C'                                
A02034                                                           
C29533     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EBILL_REGISTER_IND                                         
MFA-TR*         INTO :CE-EBILL-REGISTER-IND                                     
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE = 'C'                                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29533                                                                  
C29533     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29533                                                                  
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29533        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C29533           MOVE CE-EBILL-REGISTER-IND   TO WS-EBILL-REGISTER      
C29533        ELSE                                                      
C29533           MOVE 'N'                     TO WS-EBILL-REGISTER      
C29533        END-IF                                                    
C29533     ELSE                                                         
C29533        DISPLAY 'WS-ACTIVE-PARAGRAPH ' WS-ACTIVE-PARAGRAPH        
C29533        MOVE AT-CUSTOMER-NO             TO WS-CUSTOMER-NO         
C29533        STRING 'CUSTOMER NO = '         DELIMITED BY SIZE         
C29533                WS-CUSTOMER-NO          DELIMITED BY SIZE         
C29533                                        INTO WS-ERR-MSG2          
C29533        PERFORM 8800-DIS-TABLE-ERROR                              
C29533           THRU 8800-EXIT                                         
C29533     END-IF.                                                      
C29533                                                                  
C29533 8430-EXIT.                                                       
C29533     EXIT.                                                        
C29533                                                                  
C29533******************************************************************        
C29533* 8430A-EBILL-REGISTER                                           *        
C29533*     CHECK EBILL-REGISTER_IND IS SET FOR SPOUSE                 *        
C29533******************************************************************        
C29533                                                                  
C29533 8430A-EBILL-REGISTER.                                            
C29533                                                                  
C29533     MOVE '8430A'              TO WS-ACTIVE-PARAGRAPH             
C29533     EXEC SQL                                                     
C29533        SELECT EBILL_REGISTER_IND                                 
C29533          INTO :CE-EBILL-REGISTER-IND                             
C29533          FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
C29533         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
C29533           AND CUSTOMER_TYPE = 'S'                                
A02034                                                           
C29533     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EBILL_REGISTER_IND                                         
MFA-TR*         INTO :CE-EBILL-REGISTER-IND                                     
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE = 'S'                                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29533                                                                  
C29533     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29533                                                                  
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29533        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C29533           MOVE CE-EBILL-REGISTER-IND   TO WS-EBILL-REGISTER      
C29533        ELSE                                                      
C29533           MOVE 'N'                     TO WS-EBILL-REGISTER      
C29533        END-IF                                                    
C29533     ELSE                                                         
C29533        DISPLAY 'WS-ACTIVE-PARAGRAPH ' WS-ACTIVE-PARAGRAPH        
C29533        MOVE AT-CUSTOMER-NO             TO WS-CUSTOMER-NO         
C29533        STRING 'CUSTOMER NO = '         DELIMITED BY SIZE         
C29533                WS-CUSTOMER-NO          DELIMITED BY SIZE         
C29533                                        INTO WS-ERR-MSG2          
C29533        PERFORM 8800-DIS-TABLE-ERROR                              
C29533           THRU 8800-EXIT                                         
C29533     END-IF.                                                      
C29533                                                                  
C29533 8430A-EXIT.                                                      
C29533     EXIT.                                                        
C29533                                                                  
      *----------------------------------------------------------------*        
      * PRINT REPORT HEADER                                            *        
      *----------------------------------------------------------------*        
       8500-PRINT-HEADER.                                               
                                                                        
           MOVE '8500'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           PERFORM 8510-PRINT-TITLE       THRU 8510-EXIT                
                                                                        
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-3                     
              AFTER ADVANCING WS-2 LINES                                
           WRITE PRT33-RECORD FROM WS-LINE                              
              AFTER ADVANCING WS-1 LINE                                 
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
              AFTER ADVANCING WS-1 LINE                                 
           ADD WS-5                    TO WS-RPT1-LINE-NO               
           .                                                            
       8500-EXIT.                                                       
            EXIT.                                                       
      *----------------------------------------------------------------*        
      * PRINT REPORT NAME AND TITLE                                    *        
      *----------------------------------------------------------------*        
       8510-PRINT-TITLE.                                                
                                                                        
           MOVE '8510'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM             
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO                
                                                                        
           IF WS-SEB                                                    
              MOVE WS-SCANA-COMP-NAME  TO P-RPT1-COMP-NAME              
           END-IF                                                       
                                                                        
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
              AFTER ADVANCING TOP-OF-PAGE                               
                                                                        
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                     
               AFTER ADVANCING WS-1 LINE                                
                                                                        
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
              AFTER ADVANCING WS-1 LINE                                 
                                                                        
           MOVE WS-3                   TO WS-RPT1-LINE-NO               
           .                                                            
       8510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * PRINT REPORT DETAILS                                           *        
      *----------------------------------------------------------------*        
       8520-PRINT-DETAIL-LINE.                                          
                                                                        
           MOVE '8520'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           WRITE PRT33-RECORD FROM WS-RPT1-DETAIL-1                     
              AFTER ADVANCING WS-1 LINE                                 
                                                                        
           MOVE SPACES              TO WS-RPT1-DETAIL-1                 
           ADD WS-1                 TO WS-RPT1-LINE-NO                  
           .                                                            
       8520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY DATABASE ERROR                                         *        
      *----------------------------------------------------------------*        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'.    
           DISPLAY '**     PCSAC183 PROCESSING ERROR            **'.    
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'.    
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE.           
           DISPLAY '**       PROCESSING TERMINATED              **'.    
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *8895-INSERT-WORK-QUEUE                                         *         
      *****************************************************************         
      *                                                                         
       8895-INSERT-WORK-QUEUE.                                          
                                                                        
           MOVE '8895'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
ACT003     CALL SCSCB077  USING   CWS00077-FIELDS,                      
ACT003                            ABEND-FILE,                           
ACT003                            RS-RETURN-CODE.                       
ACT003                                                                  
ACT003     MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.   
ACT003                                                                  
ACT003     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
ACT003        MOVE WS-PGMNAME               TO ABEND-PROGRAM            
ACT003        DISPLAY '8895-INSERT-WORK-QUEUE'                          
ACT003        DISPLAY 'CALL SCSCB077         '                          
ACT003        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
ACT003        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
ACT003        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
ACT003        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
ACT003        PERFORM 9900-ABEND    THRU 9900-EXIT                      
ACT003     ELSE                                                         
ACT003        MOVE WS-77-WQ-ITEM-ID         TO WS-ITEM-ID               
ACT003     END-IF.                                                      
ACT003                                                                  
       8895-EXIT.  EXIT.                                                
      *                                                                         
      *----------------------------------------------------------------*        
      * DISPLAY PROGRAM ERROR                                          *        
      *----------------------------------------------------------------*        
       8900-DISPLAY-ERR-TERM.                                           
      *---------------------*                                                   
           DISPLAY '                                          '.        
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSAC183 PROCESSING ERROR        **'.        
           DISPLAY '******************************************'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**       PROCESSING TERMINATED          **'.        
           DISPLAY '******************************************'.        
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE 2040,2050 AND REPORT FILE                                *        
      *----------------------------------------------------------------*        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           CLOSE FCS2040-FILE.                                          
           IF WS-FAC2040-SUCCESSFUL                                     
              CONTINUE                                                  
           ELSE                                                         
              STRING  'CLOSE ERROR- FCS2040 INPUT FILE'                 
                                         DELIMITED BY SIZE              
                      'FILE STATUS = '   DELIMITED BY SIZE              
                       WS-FAC2040-STATUS DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              DISPLAY '**' WS-ERR-MSG                                   
           END-IF                                                       
                                                                        
           CLOSE FCS2050-FILE.                                          
           IF WS-FAC2050-SUCCESSFUL                                     
              CONTINUE                                                  
           ELSE                                                         
              STRING  'CLOSE ERROR- FCS2050 INPUT FILE'                 
                                         DELIMITED BY SIZE              
                      'FILE STATUS = '   DELIMITED BY SIZE              
                       WS-FAC2050-STATUS DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              DISPLAY '**' WS-ERR-MSG                                   
           END-IF                                                       
                                                                        
           CLOSE FCSPT33-FILE                                           
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
