       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSAC182.                                        
       DATE-WRITTEN.   DEC, 2003.                                       
      ***************************************************************** 00140000
      **                                                             ** 00150000
      **              PROGRAM  MODIFICATION  LOG                     ** 00160000
      **                                                             ** 00150000
      **    DATE   |    ID   |  REASON                               ** 00170000
      ** ----------|---------|-------------------------------------- **         
      **  12/01/03 |   DPS   | CML 29899 BILLMATRIX REQUIREMENT      **         
      **           |         | - CLOSE ALL OPEN 3RD PARTY BATCHES    **         
      ** ----------|---------|-------------------------------------- **         
C29529**  04/27/04 | BB18179 | CML 29529 - EPAY ENHANCEMENTS         **         
      **           |         | - UPDATE EPAY DATE TO NEXT BIZ DAY    **         
      **           |         |   AT JOURNALLING.                     **         
      **           |         | - CLOSE EPAY-RELATED BATCHES          **         
      ** ----------|---------|-------------------------------------- **         
A05460**  10/21/16  LG41184  CLOSE CSS_CSH_REPORT_HDR FOR OFFICES  **         
      ***************************************************************** 00200000
      *                                                               * 00210000
      *===============================================================* 00220000
      *===============================================================* 00230000
      **                                                             ** 00240000
      **   PCSAC182 WILL CLOSE ALL OPEN 3RD PARTY BATCHES            ** 00250000
      **       TO FOLLOW AR_LOCKOUT                                  ** 00270000
      *===============================================================* 00280000
      *===============================================================* 00290000
      *                                                                 00300000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00370000
       DATA DIVISION.                                                   
      *                                                                 00430000
       FILE SECTION.                                                    
      *                                                                 00450000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC182'.
MSQ017     COPY MFASQLM.
      *                                                                 00570000
       01  WS-MISCELLANEOUS.                                            
           05 WS-ERR-MSG               PIC X(100)    VALUE SPACES.      
           05 WS-ERR-MSG2              PIC X(115)    VALUE SPACES.      
           05 WS-PREV-DATE             PIC X(10)     VALUE SPACES.      
           05 WS-PREV-OFFICE           PIC X(03)     VALUE SPACES.      
           05 WS-DISP-CASH-DRAWER      PIC 9(04)     VALUE 0.           
           05 WS-BATCHES-PROCESSED     PIC S9(4) COMP VALUE +0.         
           05 WS-NULL-IND-11           PIC  S9(04) COMP VALUE 0.        
           05 WS-NULL-IND-12           PIC  S9(04) COMP VALUE 0.        
           05 WS-PROGRAM               PIC  X(08) VALUE 'PCSAC182'.     
      *                                                                 00651000
       COPY CWS09900.                                                   00660000
      *                                                                 00720000
       01  WS-LITERALS.                                                 
C29529     05 WS-NO                    PIC X(01)     VALUE 'N'.         
           05 WS-YES                   PIC X(01)     VALUE 'Y'.         
           05 WS-ACTIVE                PIC X         VALUE 'A'.         
           05 WS-CLOSED                PIC X         VALUE 'C'.         
           05 WS-SYSTEM                PIC X(07)     VALUE 'SYSTEM'.    
C29529     05 WS-PGRMNAME              PIC X(10)     VALUE 'PCSAC182  '.
      *                                                                         
       COPY CWS00303.                                                   02020000
                                                                        
C29529****************************************************************          
C29529**  CWS00315 CONTAINS WS FOR FINDING NEXT BUSINESS DAY        **          
C29529****************************************************************          
C29529     EXEC SQL                                                             
C29529       INCLUDE CWS00315                                                   
C29529     END-EXEC.                                                            
A05460*                                                                         
A05460     EXEC SQL                                                             
A05460       INCLUDE CWS00038                                           00660000
A05460     END-EXEC.                                                            
                                                                        
      *                                                                 02050000
      ****************************************************************          
      ** -------------------->  DB2 TABLES  <---------------------- **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     02090000
               INCLUDE SQLCA                                            02100000
           END-EXEC.                                                    02110000
      *                                                                         
      ******************************************************************        
      *    CSS_CSH_DRWR_CNTL                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBCDCNTL                                       05870000
           END-EXEC.                                                    05880000
A05460*                                                                         
A05460******************************************************************        
A05460*    CSS_CSH_REPORT_HDR - YR                                     *        
A05460******************************************************************        
A05460     EXEC SQL                                                     05860000
A05460          INCLUDE  TBCSRPHD                                       05870000
A05460     END-EXEC.                                                    05880000
A05460*                                                                         
A05460******************************************************************        
A05460*    CSS_CODE_VALUE  - UV                                        *        
A05460******************************************************************        
A05460     EXEC SQL                                                     05860000
A05460          INCLUDE  TBCDVALU                                       05870000
A05460     END-EXEC.                                                    05880000
A05460*                                                                 05880000
      ****************************************************************          
      **   CSS_CASHIER_OFFICE                                       **          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE TBCSHOFF                                                  
           END-EXEC.                                                            
                                                                        
C29529****************************************************************          
C29529**   CSS_JOB_PARM                                             **          
C29529****************************************************************          
C29529     EXEC SQL                                                             
C29529        INCLUDE TBJBPARM                                                  
C29529     END-EXEC.                                                            
                                                                        
C29529****************************************************************          
C29529**   CSS_HOLIDAY                                              **          
C29529****************************************************************          
C29529     EXEC SQL                                                             
C29529        INCLUDE TBHLDAY                                                   
C29529     END-EXEC.                                                            
                                                                        
APSAPS****************************************************************          
APSAPS**   CSS_DELINQUENCY                                          **          
APSAPS****************************************************************          
APSAPS     EXEC SQL                                                             
APSAPS        INCLUDE TBDELQ                                                    
APSAPS     END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      *    DECLARE CSH-CONTROL CURSOR                                           
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
            DECLARE CSH_CONTROL CURSOR WITH HOLD FOR                    
             SELECT CS.CASH_COMPANY_NO                                  
                   ,CS.CASH_LOCAL_OFFICE                                
                   ,CS.DATE_CASH_REPORT                                 
                   ,CS.CASH_DRAWER_ID                                   
               FROM CSS_CSH_DRWR_CNTL  CS                               
                   ,CSS_CASHIER_OFFICE Y2                               
              WHERE CS.CODE_CSH_DRWR_STAT = :WS-ACTIVE                  
                AND CS.CASH_COMPANY_NO    = Y2.CASH_COMPANY_NO          
                AND CS.CASH_LOCAL_OFFICE  = Y2.CASH_LOCAL_OFFICE        
A05460          AND CS.DATE_CASH_REPORT   <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )             
                AND (Y2.PAYMENT_AGENT_FL  = :WS-YES                     
A05460           OR  CS.CASH_LOCAL_OFFICE IN                            
A05460                  (SELECT UV.CODE_VALUE                           
A05460                     FROM CSS_CODE_VALUE UV                       
A05460                    WHERE UV.COMPANY_NO = CS.CASH_COMPANY_NO      
A05460                      AND UV.COLUMN_NA  = 'CASH_LOCAL_OFFICE'     
A05460                      AND UV.PROGRAM_ID = 'PCSAC182'))            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE CSH_CONTROL CURSOR WITH HOLD FOR                            
MFA-TR*      SELECT CS.CASH_COMPANY_NO                                          
MFA-TR*            ,CS.CASH_LOCAL_OFFICE                                        
MFA-TR*            ,CS.DATE_CASH_REPORT                                         
MFA-TR*            ,CS.CASH_DRAWER_ID                                           
MFA-TR*        FROM CSS_CSH_DRWR_CNTL  CS                                       
MFA-TR*            ,CSS_CASHIER_OFFICE Y2                                       
MFA-TR*       WHERE CS.CODE_CSH_DRWR_STAT = :WS-ACTIVE                          
MFA-TR*         AND CS.CASH_COMPANY_NO    = Y2.CASH_COMPANY_NO                  
MFA-TR*         AND CS.CASH_LOCAL_OFFICE  = Y2.CASH_LOCAL_OFFICE                
MFA-TR*         AND CS.DATE_CASH_REPORT   <= :WS-INPUT-DATE                     
MFA-TR*         AND (Y2.PAYMENT_AGENT_FL  = :WS-YES                             
MFA-TR*          OR  CS.CASH_LOCAL_OFFICE IN                                    
MFA-TR*                 (SELECT UV.CODE_VALUE                                   
MFA-TR*                    FROM CSS_CODE_VALUE UV                               
MFA-TR*                   WHERE UV.COMPANY_NO = CS.CASH_COMPANY_NO              
MFA-TR*                     AND UV.COLUMN_NA  = 'CASH_LOCAL_OFFICE'             
MFA-TR*                     AND UV.PROGRAM_ID = 'PCSAC182'))                    
MFA-TR*    END-EXEC.                                                            
A05460*                                                                         
A05460******************************************************************        
A05460*    DECLARE CSH_REPORT CURSOR                                            
A05460******************************************************************        
                                                                        
           EXEC SQL                                                     
            DECLARE CSH_REPORT CURSOR FOR                               
             SELECT  YR.CASH_COMPANY_NO                                 
                    ,YR.CASH_LOCAL_OFFICE                               
                    ,YR.DATE_CASH_REPORT                                
               FROM CSS_CSH_REPORT_HDR YR,                              
                    CSS_CASHIER_OFFICE Y2                               
              WHERE YR.STATUS = 'A'                                     
                AND YR.CASH_COMPANY_NO    = Y2.CASH_COMPANY_NO          
                AND YR.CASH_LOCAL_OFFICE  = Y2.CASH_LOCAL_OFFICE        
                AND YR.DATE_CASH_REPORT   <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )             
                AND (Y2.PAYMENT_AGENT_FL  =  :WS-YES                    
                 OR  YR.CASH_LOCAL_OFFICE IN                            
                        (SELECT UV.CODE_VALUE                           
                           FROM CSS_CODE_VALUE UV                       
                          WHERE UV.COMPANY_NO = YR.CASH_COMPANY_NO      
                            AND UV.COLUMN_NA  = 'CASH_LOCAL_OFFICE'     
                            AND UV.PROGRAM_ID = 'PCSAC182'))            
A05460     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE CSH_REPORT CURSOR FOR                                       
MFA-TR*      SELECT  YR.CASH_COMPANY_NO                                         
MFA-TR*             ,YR.CASH_LOCAL_OFFICE                                       
MFA-TR*             ,YR.DATE_CASH_REPORT                                        
MFA-TR*        FROM CSS_CSH_REPORT_HDR YR,                                      
MFA-TR*             CSS_CASHIER_OFFICE Y2                                       
MFA-TR*       WHERE YR.STATUS = 'A'                                             
MFA-TR*         AND YR.CASH_COMPANY_NO    = Y2.CASH_COMPANY_NO                  
MFA-TR*         AND YR.CASH_LOCAL_OFFICE  = Y2.CASH_LOCAL_OFFICE                
MFA-TR*         AND YR.DATE_CASH_REPORT   <= :WS-INPUT-DATE                     
MFA-TR*         AND (Y2.PAYMENT_AGENT_FL  =  :WS-YES                            
MFA-TR*          OR  YR.CASH_LOCAL_OFFICE IN                                    
MFA-TR*                 (SELECT UV.CODE_VALUE                                   
MFA-TR*                    FROM CSS_CODE_VALUE UV                               
MFA-TR*                   WHERE UV.COMPANY_NO = YR.CASH_COMPANY_NO              
MFA-TR*                     AND UV.COLUMN_NA  = 'CASH_LOCAL_OFFICE'             
MFA-TR*                     AND UV.PROGRAM_ID = 'PCSAC182'))                    
MFA-TR*    END-EXEC.                                                            
A05460*                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                 02550000
      ****************************************************************          
      ** 0000-MAINLINE ..                                           **          
      **   CONTROLS MAIN PROCESS .................................  **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                 02570000
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT           
                                                                        
C29529     PERFORM 1100-UPDATE-EPAY-BIZ-DATE   THRU 1100-EXIT           
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT           
                                                                        
           DISPLAY '*------- PCSAC182 ---------*'                       
           DISPLAY WS-BATCHES-PROCESSED '  BATCHES CLOSED '             
           DISPLAY '*------- PCSAC182 ---------*'                       
                                                                        
           STOP RUN                                                     
           .                                                            
      *                                                                 02710000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02740000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                         TO WS-ACTIVE-PARAGRAPH   
                                                                        
A05460     PERFORM 7550-GET-COMMON-DATE     THRU 7550-EXIT.             
A05460     MOVE WS-INPUT-RUN-DATE           TO WS-INPUT-DATE.           
A05460     DISPLAY '**   INPUT DATE = ' WS-INPUT-DATE.                  
A05460*                                                                         
           PERFORM 7000-OPEN-CSH-CNTL-CURSOR                            
              THRU 7000-EXIT                                            
                                                                        
           PERFORM 7100-FETCH-CSH-CNTL-CURSOR                           
              THRU 7100-EXIT                                            
                                                                        
           MOVE WS-SYSTEM                   TO CS-BALANCED-BY           
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8000-CLOSE-CSH-DRWR                               
                 THRU 8000-EXIT                                         
              ADD +1  TO WS-BATCHES-PROCESSED                           
              IF WS-PREV-DATE NOT EQUAL CS-DATE-CASH-REPORT             
                 OR WS-PREV-OFFICE NOT EQUAL CS-CASH-LOCAL-OFFICE       
                 PERFORM 8100-CLOSE-CSH-REPORT                          
                    THRU 8100-EXIT                                      
                 MOVE CS-DATE-CASH-REPORT   TO WS-PREV-DATE             
                 MOVE CS-CASH-LOCAL-OFFICE  TO WS-PREV-OFFICE           
              END-IF                                                    
              PERFORM 7100-FETCH-CSH-CNTL-CURSOR                        
                 THRU 7100-EXIT                                         
           END-PERFORM                                                  
                                                                        
A05460     PERFORM 7400-OPEN-CSH-REPORT        THRU 7400-EXIT.          
A05460     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
A05460        PERFORM 7420-FETCH-CSH-REPORT    THRU 7420-EXIT           
A05460        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A05460           MOVE YR-CASH-COMPANY-NO       TO CS-CASH-COMPANY-NO    
A05460           MOVE YR-CASH-LOCAL-OFFICE     TO CS-CASH-LOCAL-OFFICE  
A05460           MOVE YR-DATE-CASH-REPORT      TO CS-DATE-CASH-REPORT   
A05460           PERFORM 8100-CLOSE-CSH-REPORT THRU 8100-EXIT           
A05460        END-IF                                                    
A05460     END-PERFORM                                                  
A05460     PERFORM 7460-CLOSE-CSH-REPORT       THRU 7460-EXIT.          
A05460*                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29529****************************************************************          
C29529** UPDATING EPAYCURRDT IN CSS_JOB_PARM (CURRENT BIZ DATE)     **          
C29529****************************************************************          
C29529 1100-UPDATE-EPAY-BIZ-DATE.                                       
                                                                        
C29529     PERFORM 8200-SELECT-EPAYCURRDT                               
C29529        THRU 8200-EXIT.                                           
                                                                        
C29529     PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
C29529        THRU 6500-NEXT-BUSINESS-DAY-EXIT                          
C29529         UNTIL NEXT-BUSINESS-DAY-FOUND.                           
                                                                        
C29529     PERFORM 8250-UPDATE-EPAYCURRDT                               
C29529        THRU 8250-EXIT.                                           
           INITIALIZE DCLCSS-CSH-DRWR-CNTL                              
           MOVE '01'                      TO  CS-CASH-COMPANY-NO        
           MOVE 'AP'                      TO  Y2-PAYMENT-SOURCE-CD      
           PERFORM 7300-SELECT-CASHIER-OFF THRU 7300-EXIT               
           MOVE WS-NEW-BUSINESS-DAY       TO  CS-DATE-CASH-REPORT       
                                              CS-DATE-LAST-ACTIVITY     
           MOVE Y2-CASH-LOCAL-OFFICE      TO  CS-CASH-LOCAL-OFFICE      
                                              CS-CASH-REPORT-NO         
                                                                        
A05460     PERFORM 7200-SELECT-MAX-DRWR-ID THRU 7200-EXIT               
                                                                        
           ADD  1                         TO  CS-CASH-DRAWER-ID         
           MOVE 'A'                       TO  CS-CODE-CSH-DRWR-STAT     
           MOVE Y2-USER-ID                TO  CS-USER-ID                
           MOVE SPACES                    TO  CS-CASHIER-CODE           
           MOVE 'N'                       TO  CS-CODE-FCS-EXTRACTED     
           MOVE SPACES                    TO  CS-BALANCED-BY            
           MOVE 'A'                       TO  CS-CODE-PYMT-FACILITY     
           MOVE -1                        TO  WS-NULL-IND-12.           
APSAPS     PERFORM 8010-CREATE-NEW-BATCH  THRU 8010-EXIT.               
                                                                        
C29529 1100-EXIT.                                                       
C29529     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 7000-OPEN-CSH-CNTL-CURSOR...                               **          
      **  OPEN THE CASH CNTL CURSOR ..............................  **          
      **                                                            **          
      ****************************************************************          
                                                                        
       7000-OPEN-CSH-CNTL-CURSOR.                                       
                                                                        
           MOVE '7000'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           EXEC SQL                                                     
               OPEN CSH_CONTROL                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR WHILE OPENING CSH_CONTROL CURSOR **'       
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 9100-SQL-ERROR-ROUTINE                            
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      ** 7100-FETCH-CSH-CNTL-CURSOR...                              **          
      **  FETCH THE CASH CNTL CURSOR .............................  **          
      **                                                            **          
      ****************************************************************          
                                                                        
       7100-FETCH-CSH-CNTL-CURSOR.                                      
                                                                        
           MOVE '7100'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           EXEC SQL                                                     
              FETCH CSH_CONTROL                                         
               INTO :CS-CASH-COMPANY-NO                                 
                   ,:CS-CASH-LOCAL-OFFICE                               
                   ,:CS-DATE-CASH-REPORT                                
                   ,:CS-CASH-DRAWER-ID                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR WHILE FETCHING CSH_CONTROL CURSOR **'      
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              MOVE SPACES        TO WS-ERR-MSG2                         
              PERFORM 9100-SQL-ERROR-ROUTINE                            
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05460 7200-SELECT-MAX-DRWR-ID.                                         
                                                                        
           EXEC SQL                                                     
             SELECT MAX(CASH_DRAWER_ID)                                 
               INTO :CS-CASH-DRAWER-ID :WS-NULL-IND-11                   
               FROM CSS_CSH_DRWR_CNTL                                   
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                AND CASH_DRAWER_ID     < 500                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(CASH_DRAWER_ID)                                         
MFA-TR*        INTO :CS-CASH-DRAWER-ID:WS-NULL-IND-11                           
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                           
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                   
MFA-TR*         AND CASH_DRAWER_ID     < 500                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF  WS-NULL-IND-11 < ZERO                                 
                  MOVE 0                       TO CS-CASH-DRAWER-ID     
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR WHILE FETCHING CSH_CONTROL CURSOR **'      
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              MOVE SPACES        TO WS-ERR-MSG2                         
              PERFORM 9100-SQL-ERROR-ROUTINE                            
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
A05460 7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  08160000
      * 7300-SELECT-CASHIER-OFF                                   *     08170000
      ****************************************************************  08180000
                                                                        
       7300-SELECT-CASHIER-OFF.                                         
           EXEC SQL                                                     
              SELECT  CASH_LOCAL_OFFICE                                 
                     ,USER_ID                                           
                INTO :Y2-CASH-LOCAL-OFFICE                              
                    ,:Y2-USER-ID                                        
              FROM CSS_CASHIER_OFFICE                                   
              WHERE PAYMENT_SOURCE_CD = :Y2-PAYMENT-SOURCE-CD           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING ' ERROR WHILE SELECTING CSS_CASHIER_OFF   **'      
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              MOVE SPACES        TO WS-ERR-MSG2                         
              PERFORM 9100-SQL-ERROR-ROUTINE                            
                 THRU 9100-EXIT                                         
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A05460****************************************************************          
A05460** 7400-OPEN-CSH-REPORT                                       **          
A05460****************************************************************          
                                                                        
       7400-OPEN-CSH-REPORT.                                            
                                                                        
           MOVE '7400'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           EXEC SQL                                                     
               OPEN CSH_REPORT                                          
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR WHILE OPENING CSH_REPORT CURSOR **'        
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 9100-SQL-ERROR-ROUTINE                            
                 THRU 9100-EXIT                                         
           END-IF.                                                      
                                                                        
A05460 7400-EXIT.                                                       
A05460     EXIT.                                                        
                                                                        
A05460****************************************************************          
A05460** 7420-FETCH-CSH-REPORT                                      **          
A05460****************************************************************          
                                                                        
       7420-FETCH-CSH-REPORT.                                           
                                                                        
           MOVE '7420'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           EXEC SQL                                                     
              FETCH CSH_REPORT                                          
               INTO :YR-CASH-COMPANY-NO                                 
                   ,:YR-CASH-LOCAL-OFFICE                               
                   ,:YR-DATE-CASH-REPORT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR WHILE FETCHING CSH_REPORT CURSOR **'       
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              MOVE SPACES        TO WS-ERR-MSG2                         
              PERFORM 9100-SQL-ERROR-ROUTINE  THRU 9100-EXIT            
           END-IF.                                                      
                                                                        
A05460 7420-EXIT.                                                       
A05460     EXIT.                                                        
                                                                        
A05460****************************************************************          
A05460** 7460-CLOSE-CSH-REPORT                                      **          
A05460****************************************************************          
       7460-CLOSE-CSH-REPORT.                                           
                                                                        
           MOVE '7460'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           EXEC SQL                                                     
              CLOSE CSH_REPORT                                          
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR WHILE CLOSING CSH_REPORT CURSOR **'        
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              MOVE SPACES        TO WS-ERR-MSG2                         
              PERFORM 9100-SQL-ERROR-ROUTINE  THRU 9100-EXIT            
           END-IF.                                                      
                                                                        
A05460 7460-EXIT.                                                       
A05460     EXIT.                                                        
A05460*                                                                         
A05460 7550-GET-COMMON-DATE.                                            
           MOVE 'COMMON  '              TO G6-PROGRAM-NAME              
           MOVE 'DATE'                  TO G6-CMND-CODE                 
                                                                        
           EXEC SQL                                                     
              SELECT G6.PARM_DATA                                       
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM G6                                    
               WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                 
                 AND G6.CMND_CODE    = :G6-CMND-CODE                    
                 AND G6.COMPANY_NO   = '01'                             
                 AND G6.SEQ_NO       = 10                               
                 AND G6.STATUS       = 'A'                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA        TO WS-INPUT-DATA-BREAKDOWN       
           ELSE                                                         
              STRING ' ERROR WHILE SELECTING FROM JOB_PARM **'          
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              MOVE SPACES              TO WS-ERR-MSG2                   
              PERFORM 9100-SQL-ERROR-ROUTINE  THRU 9100-EXIT            
           END-IF.                                                      
                                                                        
A05460 7550-EXIT.                                                       
A05460     EXIT.                                                        
A05460*                                                                         
      ****************************************************************          
      ** 8000-CLOSE-CSH-DRWR....                                    **          
      **  CLOSE THE CASH DRWR ....................................  **          
      **                                                            **          
      ****************************************************************          
                                                                        
       8000-CLOSE-CSH-DRWR.                                             
                                                                        
           MOVE '8000'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_CSH_DRWR_CNTL                                   
                SET CODE_CSH_DRWR_STAT = :WS-CLOSED                     
                   ,DATE_LAST_ACTIVITY = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                   ,BALANCED_TS        = CIS.CURRENT$TIMESTAMP()              
                   ,BALANCED_BY        = :CS-BALANCED-BY                
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_CSH_DRWR_CNTL                                           
MFA-TR*         SET CODE_CSH_DRWR_STAT = :WS-CLOSED                             
MFA-TR*            ,DATE_LAST_ACTIVITY = CURRENT DATE                           
MFA-TR*            ,BALANCED_TS        = CURRENT TIMESTAMP                      
MFA-TR*            ,BALANCED_BY        = :CS-BALANCED-BY                        
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                   
MFA-TR*         AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE CS-CASH-DRAWER-ID TO WS-DISP-CASH-DRAWER             
              STRING ' ERROR WHILE UPDATING CSS_CSH_DRWR_CNTL TABLE **' 
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING 'CASH_COMPANY_NO'     DELIMITED BY SIZE            
                      CS-CASH-COMPANY-NO   DELIMITED BY SIZE            
                     ', CASH_LOCAL_OFFICE' DELIMITED BY SIZE            
                      CS-CASH-LOCAL-OFFICE DELIMITED BY SIZE            
                     ', DATE_CASH_REPORT'  DELIMITED BY SIZE            
                      CS-DATE-CASH-REPORT  DELIMITED BY SIZE            
                     ', CASH_DRAWER_ID'    DELIMITED BY SIZE            
                      WS-DISP-CASH-DRAWER  DELIMITED BY SIZE            
                                           INTO  WS-ERR-MSG2            
              PERFORM 9100-SQL-ERROR-ROUTINE                            
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      ** 8100-CLOSE-CSH-REPORT....                                  **          
      **  CLOSE THE CASH REPORT...................................  **          
      **                                                            **          
      ****************************************************************          
                                                                        
       8100-CLOSE-CSH-REPORT.                                           
                                                                        
           MOVE '8100'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_CSH_REPORT_HDR                                  
                SET STATUS             = :WS-CLOSED                     
                   ,CLOSED_TS          = CIS.CURRENT$TIMESTAMP()              
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_CSH_REPORT_HDR                                          
MFA-TR*         SET STATUS             = :WS-CLOSED                             
MFA-TR*            ,CLOSED_TS          = CURRENT TIMESTAMP                      
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                   
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR WHILE UPDATING CSS_CSH_REPORT_HDR TABLE **'
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING 'CASH_COMPANY_NO'     DELIMITED BY SIZE            
                      CS-CASH-COMPANY-NO   DELIMITED BY SIZE            
                     ', CASH_LOCAL_OFFICE' DELIMITED BY SIZE            
                      CS-CASH-LOCAL-OFFICE DELIMITED BY SIZE            
                     ', DATE_CASH_REPORT'  DELIMITED BY SIZE            
                      CS-DATE-CASH-REPORT  DELIMITED BY SIZE            
                                           INTO  WS-ERR-MSG2            
              PERFORM 9100-SQL-ERROR-ROUTINE                            
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29529****************************************************************          
C29529** SELECTING EPAYCURRDT FROM CSS_JOB_PARM                     **          
C29529****************************************************************          
C29529 8200-SELECT-EPAYCURRDT.                                          
                                                                        
C29529     MOVE '8200'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
C29529     EXEC SQL                                                     
C29529       SELECT PARM_DATA                                           
C29529         INTO :G6-PARM-DATA                                       
C29529         FROM CSS_JOB_PARM                                        
C29529        WHERE PROGRAM_NAME = 'EPAYCURRDT'                         
C29529          AND COMPANY_NO   = '01'                                 
C29529          AND CMND_CODE    = 'DATE'                               
C29529          AND SEQ_NO       = 10                                   
C29529          AND STATUS       = 'A'                                  
C29529     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        MOVE G6-PARM-DATA(1:10) TO WS-NEW-BUSINESS-DAY            
C29529        DISPLAY '**********************************************'  
C29529        DISPLAY '***    CSS_JOB_PARM INFO FOR EPAYCURRDT    ***'  
C29529        DISPLAY '**********************************************'  
C29529        DISPLAY '**   CURRENT EPAYCURRDT = ' G6-PARM-DATA         
C29529     ELSE                                                         
C29529        STRING ' ERROR SELECTING FROM CSS_JOB_PARM TABLE **'      
C29529                 DELIMITED BY SIZE INTO WS-ERR-MSG                
C29529        STRING 'PARM_DATA'           DELIMITED BY SIZE            
C29529                G6-PARM-DATA         DELIMITED BY SIZE            
C29529                                     INTO  WS-ERR-MSG2            
C29529        PERFORM 9100-SQL-ERROR-ROUTINE                            
C29529           THRU 9100-EXIT                                         
C29529     END-IF.                                                      
                                                                        
C29529 8200-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C29529****************************************************************          
C29529** UPDATING CSS_JOB_PARM FOR                                  **          
C29529****************************************************************          
C29529 8250-UPDATE-EPAYCURRDT.                                          
                                                                        
C29529     MOVE '8250'              TO WS-ACTIVE-PARAGRAPH              
                                                                        
C29529     MOVE WS-NEW-BUSINESS-DAY TO G6-PARM-DATA                     
                                                                        
C29529     EXEC SQL                                                     
C29529       UPDATE CSS_JOB_PARM                                        
C29529          SET PARM_DATA    = :G6-PARM-DATA                        
C29529        WHERE PROGRAM_NAME = 'EPAYCURRDT'                         
C29529          AND COMPANY_NO   = '01'                                 
C29529          AND CMND_CODE    = 'DATE'                               
C29529          AND SEQ_NO       = 10                                   
C29529          AND STATUS       = 'A'                                  
C29529     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        DISPLAY '**   UPDATED EPAYCURRDT = ' G6-PARM-DATA         
C29529        DISPLAY '**********************************************'  
C29529     ELSE                                                         
C29529        STRING ' ERROR WHILE UPDATING CSS_JOB_PARM TABLE **'      
C29529                 DELIMITED BY SIZE INTO WS-ERR-MSG                
C29529        STRING 'PARM_DATA = '        DELIMITED BY SIZE            
C29529                G6-PARM-DATA         DELIMITED BY SIZE            
C29529                                     INTO  WS-ERR-MSG2            
C29529        PERFORM 9100-SQL-ERROR-ROUTINE                            
C29529           THRU 9100-EXIT                                         
C29529     END-IF.                                                      
                                                                        
C29529 8250-EXIT.                                                       
C29529     EXIT.                                                        
      *---------------------------------------------------------------*         
      * CREATES NEW BATCH                                             *         
      *---------------------------------------------------------------*         
                                                                        
       8010-CREATE-NEW-BATCH.                                           
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_DRWR_CNTL                              
                  (                                                     
                   CASH_COMPANY_NO                                      
                  ,CASH_LOCAL_OFFICE                                    
                  ,CASH_REPORT_NO                                       
                  ,DATE_CASH_REPORT                                     
                  ,CASH_DRAWER_ID                                       
                  ,AMT_CASH_DEBIT                                       
                  ,AMT_CASH_CREDIT                                      
                  ,AMT_AR_DEBIT                                         
                  ,AMT_AR_CREDIT                                        
                  ,AMT_CK_ISS_DEBIT                                     
                  ,AMT_CK_ISS_CREDIT                                    
                  ,AMT_GL_DEBIT                                         
                  ,AMT_GL_CREDIT                                        
                  ,AMT_CASH_BEGIN_BAL                                   
                  ,AMT_BASIC_WORK                                       
                  ,USER_ID                                              
                  ,CASHIER_CODE                                         
                  ,CODE_PYMT_FACILITY                                   
                  ,CODE_FCS_EXTRACTED                                   
                  ,CODE_CSH_DRWR_STAT                                   
                  ,DATE_LAST_ACTIVITY                                   
                  ,BALANCED_BY                                          
                  ,BALANCED_TS                                          
                  ,NO_ITEMS_ENTERED                                     
                  )                                                     
           VALUES (                                                     
                   :CS-CASH-COMPANY-NO                                  
                  ,:CS-CASH-LOCAL-OFFICE                                
                  ,:CS-CASH-REPORT-NO                                   
                  ,IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )                         
                  ,:CS-CASH-DRAWER-ID                                   
                  ,:CS-AMT-CASH-DEBIT                                   
                  ,:CS-AMT-CASH-CREDIT                                  
                  ,:CS-AMT-AR-DEBIT                                     
                  ,:CS-AMT-AR-CREDIT                                    
                  ,:CS-AMT-CK-ISS-DEBIT                                 
                  ,:CS-AMT-CK-ISS-CREDIT                                
                  ,:CS-AMT-GL-DEBIT                                     
                  ,:CS-AMT-GL-CREDIT                                    
                  ,:CS-AMT-CASH-BEGIN-BAL                               
                  ,:CS-AMT-BASIC-WORK                                   
                  ,:CS-USER-ID                                          
                  ,:CS-CASHIER-CODE                                     
                  ,:CS-CODE-PYMT-FACILITY                               
                  ,:CS-CODE-FCS-EXTRACTED                               
                  ,:CS-CODE-CSH-DRWR-STAT                               
                  ,IIF(TRY_CONVERT(DATE, :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) )                       
                  ,:CS-BALANCED-BY                                      
                  ,CIS.CHAR2TIMESTAMP(:CS-BALANCED-TS :WS-NULL-IND-12)          
                  ,:CS-NO-ITEMS-ENTERED                                 
                  )                                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_DRWR_CNTL                                      
MFA-TR*           (                                                             
MFA-TR*            CASH_COMPANY_NO                                              
MFA-TR*           ,CASH_LOCAL_OFFICE                                            
MFA-TR*           ,CASH_REPORT_NO                                               
MFA-TR*           ,DATE_CASH_REPORT                                             
MFA-TR*           ,CASH_DRAWER_ID                                               
MFA-TR*           ,AMT_CASH_DEBIT                                               
MFA-TR*           ,AMT_CASH_CREDIT                                              
MFA-TR*           ,AMT_AR_DEBIT                                                 
MFA-TR*           ,AMT_AR_CREDIT                                                
MFA-TR*           ,AMT_CK_ISS_DEBIT                                             
MFA-TR*           ,AMT_CK_ISS_CREDIT                                            
MFA-TR*           ,AMT_GL_DEBIT                                                 
MFA-TR*           ,AMT_GL_CREDIT                                                
MFA-TR*           ,AMT_CASH_BEGIN_BAL                                           
MFA-TR*           ,AMT_BASIC_WORK                                               
MFA-TR*           ,USER_ID                                                      
MFA-TR*           ,CASHIER_CODE                                                 
MFA-TR*           ,CODE_PYMT_FACILITY                                           
MFA-TR*           ,CODE_FCS_EXTRACTED                                           
MFA-TR*           ,CODE_CSH_DRWR_STAT                                           
MFA-TR*           ,DATE_LAST_ACTIVITY                                           
MFA-TR*           ,BALANCED_BY                                                  
MFA-TR*           ,BALANCED_TS                                                  
MFA-TR*           ,NO_ITEMS_ENTERED                                             
MFA-TR*           )                                                             
MFA-TR*    VALUES (                                                             
MFA-TR*            :CS-CASH-COMPANY-NO                                          
MFA-TR*           ,:CS-CASH-LOCAL-OFFICE                                        
MFA-TR*           ,:CS-CASH-REPORT-NO                                           
MFA-TR*           ,:CS-DATE-CASH-REPORT                                         
MFA-TR*           ,:CS-CASH-DRAWER-ID                                           
MFA-TR*           ,:CS-AMT-CASH-DEBIT                                           
MFA-TR*           ,:CS-AMT-CASH-CREDIT                                          
MFA-TR*           ,:CS-AMT-AR-DEBIT                                             
MFA-TR*           ,:CS-AMT-AR-CREDIT                                            
MFA-TR*           ,:CS-AMT-CK-ISS-DEBIT                                         
MFA-TR*           ,:CS-AMT-CK-ISS-CREDIT                                        
MFA-TR*           ,:CS-AMT-GL-DEBIT                                             
MFA-TR*           ,:CS-AMT-GL-CREDIT                                            
MFA-TR*           ,:CS-AMT-CASH-BEGIN-BAL                                       
MFA-TR*           ,:CS-AMT-BASIC-WORK                                           
MFA-TR*           ,:CS-USER-ID                                                  
MFA-TR*           ,:CS-CASHIER-CODE                                             
MFA-TR*           ,:CS-CODE-PYMT-FACILITY                                       
MFA-TR*           ,:CS-CODE-FCS-EXTRACTED                                       
MFA-TR*           ,:CS-CODE-CSH-DRWR-STAT                                       
MFA-TR*           ,:CS-DATE-LAST-ACTIVITY                                       
MFA-TR*           ,:CS-BALANCED-BY                                              
MFA-TR*           ,:CS-BALANCED-TS:WS-NULL-IND-12                               
MFA-TR*           ,:CS-NO-ITEMS-ENTERED                                         
MFA-TR*           )                                                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR WHILE INSERTING INTO CSS_PYMT_TRANS*'      
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              MOVE SPACES        TO WS-ERR-MSG2                         
              PERFORM 9100-SQL-ERROR-ROUTINE                            
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29529*****************************************************************         
C29529*    6500-GET-NEXT-BUSINESS-DAY                                **         
C29529*                                                              **         
C29529*    COPYBOOK CPD00315 CONTAINS THE LOGIC FOR FINDING          **         
C29529*    THE NEXT BUSINESS DAY.                                    **         
C29529*****************************************************************         
                                                                        
C29529     EXEC SQL                                                             
C29529         INCLUDE CPD00315                                                 
C29529     END-EXEC.                                                            
                                                                        
      *                                                                         
      ****************************************************************          
      ** 9100-SQL-ERROR-ROUTINE ..                                  **          
      **  STANDARD DB2 ERROR ERROR ROUTINE .......................  **          
      **                                                            **          
      ****************************************************************          
       9100-SQL-ERROR-ROUTINE.                                          
      *                                                                 15911100
           DISPLAY '**********************************************'.    
           DISPLAY '**     PCSAC182 PROCESSING ERROR            **'.    
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '** SQL CODE    = ' WS-ACTIVE-RETURN-CODE.           
           DISPLAY '**       PROCESSING TERMINATED              **'.    
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
      *                                                                 15912103
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15910000
      ****************************************************************          
      ** 9000-TERMINATE...                                          **          
      **  CLOSE OPEN CURSOR.......................................  **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
                                                                        
           EXEC SQL                                                     
              CLOSE CSH_CONTROL                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
