       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSAC180.                                            
       AUTHOR. BASKAR VANNI.                                            
       DATE-WRITTEN. JULY 2010.                                         
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      **-------------------------------------------------------------**         
      *~~~~~~~            CUSTOMER INFORMATION SYSTEMS        ~~~~~~~~*         
      **-------------------------------------------------------------**         
      *                                                               *         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *                                                               *         
      *    DATE    INITIALS               REASON                      *         
      *========== =========   ========================================*         
      *07/20/2010  BASKAR V     NEW PROGRAM TO POST BATCH PAYMENTS -  *         
      *                         PROJ*420                              *         
A03244*04/12/2011  LG41184      UPDATE CUST-BANK-SEQ-NO FOR DRAFT AND *         
A03244*                         EPAY ACCOUNTS IN AR TRANSACTION HIST. *         
P00613*02/13/2014  LG41184      TO POPULATE PAYMENT FACILITY 'I' FOR  *         
P00613*                         MOBILE PAYMENTS.                      *         
A05203*09/28/2015  RB19957      CHANGE RETURN CODE SIZE TO S9(4)      *         
A05203*        RICK BLACK       INSTEAD OF S9(9).                     *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
      *---------------------------------------------------------------*         
      * THIS PROGRAM POSTS PAYMENTS USING SCSAC180. THIS PROGRAM CAN  *         
      * HANDLE MAIL-IN AND BANK DRAFT FILES. RAPIDPAY, PHONE CHARGE,  *         
      * EDI AND OTHER PAYMENT FILES ARE CONVERTED IN TO MAIL-IN       *         
      * (CSHCBCTC) FILE FORMAT AND PROCESSED VIA THIS PROGRAM.        *         
      *---------------------------------------------------------------*         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER. IBM-4341.                                       
       OBJECT-COMPUTER. IBM-4341.                                       
       SPECIAL-NAMES.   C01 IS TOP-OF-PAGE.                             
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSAC01-FILE  ASSIGN  UT-S-FCSAC01                    
             FILE STATUS IS WS-FAC01-STATUS.                            
       COPY CSSAC03.                                                            
                                                                        
           SELECT PCSA180M-FILE ASSIGN TO UT-S-PCSA180M                 
             FILE STATUS IS WS-PC180-STATUS.                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ******************************************************************        
      * CFDAC01 - FD FOR WAUSAU SEQUENTIAL INPUT FILE                  *        
      * THIS FILE CONTAINS WAUSAU CASH REMITTANCE PAYMENTS RECORDS.    *        
      ******************************************************************        
       FD  FCSAC01-FILE                                                 
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD                                 
           DATA RECORD IS  DETAIL-REC NOTICE REC BATCH-TOTAL-REC.       
                                                                        
       COPY CSHCBCTC.                                                           
                                                                        
      ******************************************************************00913600
      * CFDAC03 - FD FOR BANK DRAFT SEQUENTIAL INPUT FILE (PCSAC100)   *00913700
      * THIS FILE CONTAINS DRAFT PAYMENTS GENERATED FROM PCSCA190.     *        
      ******************************************************************00913800
       COPY CFDAC03.                                                            
       COPY FIOAC03B.                                                           
                                                                        
       FD  PCSA180M-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD                                 
           DATA RECORD IS  PCSAC180-REC.                                
       01  PCSA180M-REC                  PIC X(80).                     
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC180'.
MSQ017     COPY MFASQLM.
       01 WS-MISC.                                                      
          05 WS-ERR-MSG                     PIC X(100) VALUE SPACES.    
          05 WS-ERR-MSG2                    PIC X(150) VALUE SPACES.    
          05 WS-CODE-SOURCE-ID              PIC X(01)  VALUE SPACES.    
          05 WS-PYMT-FACILITY-CD            PIC X(01)  VALUE SPACES.    
          05 WS-RESTART-IND                 PIC X(01)  VALUE 'N'.       
          05 WS-ACCOUNT-NO                  PIC X(13).                  
          05 WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                  
                                            PIC 9(13).                  
          05 WS-CENTURY                     PIC 99.                     
          05 RESTART-REC-SW                 PIC X(01)  VALUE 'N'.       
             88 REC-FOUND                              VALUE 'Y'.       
             88 REC-NOT-FOUND                          VALUE 'N'.       
          05 FCSAC01-EOF-SW                 PIC X(01)  VALUE 'N'.       
             88 FCSAC01-AT-EOF                         VALUE 'Y'.       
             88 FCSAC01-NOT-AT-EOF                     VALUE 'N'.       
          05 FCSAC03-EOF-SW                 PIC X(01)  VALUE 'N'.       
             88 FCSAC03-AT-EOF                         VALUE 'Y'.       
             88 FCSAC03-NOT-AT-EOF                     VALUE 'N'.       
          05 WS-FIRST-WAUSAU-HEADER-SW      PIC X(01)  VALUE 'Y'.       
             88 WS-FIRST-WAUSAU-HEADER                 VALUE 'Y'.       
          05 WS-FAC01-STATUS                PIC X(02)  VALUE '00'.      
             88 FAC01-SUCCESSFUL                       VALUE '00'.      
          05 WS-FAC03-STATUS                PIC X(02)  VALUE '00'.      
             88 FAC03-SUCCESSFUL                       VALUE '00'.      
          05 WS-PC180-STATUS                PIC X(02)  VALUE '00'.      
             88 PC180-SUCCESSFUL                       VALUE '00'.      
          05 WS-RECORD-SW                   PIC X(01)  VALUE ' '.       
             88 WAUSAU-RECORD                          VALUE 'T'.       
             88 BANKDRAFT-RECORD                       VALUE 'D'.       
          05 WS-EPAY-ACCOUNT                PIC X(02)  VALUE 'N'.       
             88 EPAY-ACCOUNT                           VALUE 'Y'.       
             88 NOT-EPAY-ACCOUNT                       VALUE 'N'.       
          05 WS-PREV-LOCATION.                                          
             10 WS-PREV-LOCATION-1          PIC X(01).                  
             10 WS-PREV-LOCATION-2-3        PIC X(02).                  
          05 WS-BATCH-NO                    PIC 9(04) VALUE ZEROES.     
          05 WS-4-DIGIT-DRAWER.                                         
             10 WS-REPORT-BTR               PIC 9(02).                  
             10 WS-BATCH-NO-BTR             PIC 9(02).                  
          05 WS-4-BYTE-DRAWER  REDEFINES WS-4-DIGIT-DRAWER              
                                            PIC 9(04).                  
          05 WS-PYMT-AMT                    PIC X(11).                  
          05 WS-PYMT-AMT-NUM REDEFINES WS-PYMT-AMT PIC 9(9)V99.         
          05 WS-DISP-AMT                    PIC X(12).                  
          05 WS-DISP-AMT-NUM REDEFINES WS-DISP-AMT PIC 9(10)V99.        
          05 WS-DISP-CNT                    PIC X(07).                  
          05 WS-DISP-CNT-NUM REDEFINES WS-DISP-CNT PIC 9(7).            
          05 WS-DISP-CNT-2                  PIC X(07).                  
          05 WS-DISP-CNT-2-NUM REDEFINES WS-DISP-CNT-2 PIC 9(7).        
          05 WS-PARTITION-NO-CHAR           PIC X(01).                  
          05 WS-PARTITION-NO REDEFINES WS-PARTITION-NO-CHAR             
                                            PIC 9(01).                  
          05 WS-BKD-TYPE8-FOUND             PIC X(01) VALUE 'N'.        
          05 WS-BKD-TYPE9-FOUND             PIC X(01) VALUE 'N'.        
          05 WS-PAYMENT-SOURCE-CD.                                      
             10 WS-PAYMENT-SOURCE-1         PIC X(01) VALUE '0'.        
             10 WS-PAYMENT-SOURCE-2         PIC X(01) VALUE '0'.        
          05 WS-CONFIRM-NO.                                             
             10 WS-CONF-CSH-LOC-OFF         PIC X(03).                  
             10 FILLER                      PIC X(01) VALUE SPACES.     
             10 WS-CONF-DRAWER-ID           PIC 9(04).                  
             10 WS-CONF-SEQ-NO-DET          PIC 9(07).                  
A03244    05 WS-CUST-BANK-SEQ-NO            PIC X(09).                  
A05203    05 WS-DISPLAY-RETURN-CODE         PIC -9999.                  
                                                                        
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00104.                                                           
                                                                        
       01 WS-LITERALS.                                                  
          05 WS-1                            PIC X(01) VALUE '1'.       
          05 WS-2                            PIC X(01) VALUE '2'.       
          05 WS-6                            PIC X(01) VALUE '6'.       
          05 WS-8                            PIC X(01) VALUE '8'.       
          05 WS-9                            PIC X(01) VALUE '9'.       
          05 WS-D                            PIC X(01) VALUE 'D'.       
          05 WS-N                            PIC X(01) VALUE 'N'.       
          05 WS-Y                            PIC X(01) VALUE 'Y'.       
          05 WS-ONE                          PIC S9(1) VALUE +1.        
          05 WS-THREE                        PIC S9(1) VALUE +3.        
          05 WS-TWO                          PIC S9(1) VALUE +2.        
          05 WS-1000                         PIC S9(4) VALUE +1000.     
          05 WS-SYSTEM                       PIC X(08) VALUE 'SYSTEM'.  
          05 WS-PGRMNAME                     PIC X(08) VALUE 'PCSAC180'.
          05 SCSAC180                        PIC X(08) VALUE 'SCSAC180'.
          05 WS-BKD-LOCATION                 PIC X(03) VALUE SPACES.    
          05 WS-BKD-LOCATION-NUM             PIC 9(3).                  
          05 WS-DELINQUENCY-CD               PIC X(20) VALUE            
             'CASH-LOCAL-OFFICE   '.                                    
          05 WS-CSR                        PIC S9(9)V9(5) VALUE 1.00000.
          05 WS-DATABASE                     PIC X(08) VALUE 'DATABASE'.
                                                                        
       01 WS-COUNTERS.                                                  
          05 WS-BATCH-BKD-TYPE6           PIC S9(7)    COMP-3 VALUE +0. 
          05 WS-TOTAL-BKD-TYPE6           PIC S9(7)    COMP-3 VALUE +0. 
          05 WS-BATCH-NO-ENTRIES          PIC S9(7)    COMP-3 VALUE +0. 
          05 WS-TOTAL-NO-ENTRIES-BKD      PIC S9(7)    COMP-3 VALUE +0. 
          05 WS-BATCH-PYMT-AMT            PIC S9(9)V99 COMP-3 VALUE +0. 
          05 WS-TOTAL-AMT-BKD             PIC S9(9)V99 COMP-3 VALUE +0. 
          05 WS-BKT-HDR-ENTRIES           PIC S9(7)    COMP-3 VALUE +0. 
          05 WS-BKT-HDR-PYMT-AMT          PIC S9(9)V99 COMP-3 VALUE +0. 
          05 WS-FCSAC60-READ-COUNT        PIC  9(07)   VALUE ZERO.      
          05 WS-INPUT-ERROR-ACCT          PIC 9(04)    VALUE ZERO.      
                                                                        
       01 MAILHEAD-1.                                                   
          05 FILLER                       PIC X(22) VALUE               
             'HELO DOMAIN:     SCANA'.                                  
                                                                        
       01 MAILHEAD-2.                                                   
          05 FILLER                       PIC X(14) VALUE               
             'MAIL FROM:   <'.                                          
          05 MAIL2-JOB-NAME               PIC X(07).                    
          05 FILLER                       PIC X(20) VALUE               
             '@SCEGJES2.SCANA.COM>'.                                    
                                                                        
       01 MAILHEAD-3.                                                   
          05 FILLER                       PIC X(35) VALUE               
              'RCPT TO:   <PAGER.RTEAM@SCANA.COM>'.                     
                                                                        
       01 MAILHEAD-3A.                                                  
          05 FILLER                       PIC X(40) VALUE               
               'RCPT TO:   <RANDERSON@SCANA.COM>'.                      
                                                                        
       01 MAILHEAD-3B.                                                  
          05 FILLER                       PIC X(40) VALUE               
               'RCPT TO:   <LDERRICK@SCANA.COM>'.                       
                                                                        
       01 MAILHEAD-3C.                                                  
          05 FILLER                       PIC X(40) VALUE               
               'RCPT TO:   <CSWHITE@SCANA.COM>'.                        
                                                                        
       01 MAILHEAD-4.                                                   
          05 FILLER                       PIC X(04) VALUE               
                'DATA'.                                                 
                                                                        
       01 MAILHEAD-5.                                                   
          05 FILLER                       PIC X(18) VALUE               
                'FROM: CSR PAGING <'.                                   
          05 MAIL5-JOB-NAME               PIC X(07).                    
          05 FILLER                       PIC X(20) VALUE               
                '@SCEGJES2.SCANA.COM>'.                                 
                                                                        
       01 MAILHEAD-6.                                                   
          05 FILLER                       PIC X(35) VALUE               
               'TO:   <PAGER.RTEAM@SCANA.COM>'.                         
                                                                        
       01 MAILHEAD-6A.                                                  
          05 FILLER                       PIC X(35) VALUE               
               'TO:   <RANDERSON@SCANA.COM>'.                           
                                                                        
       01 MAILHEAD-6B.                                                  
          05 FILLER                       PIC X(35) VALUE               
               'TO:   <LDERRICK@SCANA.COM>'.                            
                                                                        
       01 MAILHEAD-6C.                                                  
          05 FILLER                       PIC X(35) VALUE               
               'TO:   <CSWHITE@SCANA.COM>'.                             
                                                                        
       01 MAILHEAD-7.                                                   
          05 FILLER                       PIC X(10) VALUE               
              'SUBJECT:  '.                                             
          05 MAIL7-JOB-NAME               PIC X(07).                    
                                                                        
       01 MAILHEAD-8.                                                   
          05 FILLER                       PIC X(80) VALUE SPACES.       
                                                                        
       01 MAILHEAD-9.                                                   
          05 MAIL9-MSG                    PIC X(80) VALUE SPACES.       
                                                                        
       01 WS-SUB-PGM-INPUT.                                             
          05 WS-SUB-TIMESTAMP             PIC X(26).                    
          05 WS-SUB-ACCOUNT-NO            PIC X(13).                    
          05 WS-SUB-COMPANY-NO            PIC X(04).                    
          05 WS-SUB-CASH-LOC-OFFICE       PIC X(03).                    
          05 WS-SUB-CUST-PHONE-NO         PIC X(10).                    
          05 WS-SUB-CURRENCY-TYPE         PIC X(01).                    
          05 WS-SUB-PAYMENT-AMOUNT        PIC X(11).                    
          05 WS-SUB-REPORT-DATE           PIC X(10).                    
          05 WS-SUB-PYMT-FACILITY-CD      PIC X(01).                    
          05 WS-SUB-DIR-PYMT-IND          PIC X(03).                    
          05 WS-SUB-CONFIRMATION-NO       PIC X(15).                    
          05 WS-SUB-APPL-PGM-ID           PIC X(09).                    
A05203    05 WS-SUB-S-RETURN-CODE         PIC S9(4).                    
          05 WS-SUB-S-TIMESTAMP           PIC X(26).                    
          05 WS-SUB-S-ACCOUNT-NO          PIC X(13).                    
          05 WS-SUB-S-COMPANY-NO          PIC X(04).                    
          05 WS-SUB-S-BILLED-BALANCE      PIC X(13).                    
          05 WS-SUB-S-CANCEL-DNP-FLAG     PIC X(01).                    
          05 WS-SUB-ERROR-SW              PIC X(01).                    
          05 WS-SUB-PAR-MSG-NO            PIC X(05).                    
          05 WS-SUB-ACTIVE-PARA           PIC X(05).                    
                                                                        
       01 WS-WORK-DATE.                                                 
          05 WS-WORK-CC                   PIC X(02).                    
          05 WS-WORK-YY                   PIC X(02).                    
          05 FILLER                       PIC X(01) VALUE '-'.          
          05 WS-WORK-MM                   PIC X(02).                    
          05 FILLER                       PIC X(01) VALUE '-'.          
          05 WS-WORK-DD                   PIC X(02).                    
                                                                        
       01 WS-BKD-DATE.                                                  
          05 WS-BKD-DATE-CC               PIC X(02).                    
          05 WS-BKD-DATE-YY               PIC X(02).                    
          05 FILLER                       PIC X(01) VALUE '-'.          
          05 WS-BKD-DATE-MM               PIC X(02).                    
          05 FILLER                       PIC X(01) VALUE '-'.          
          05 WS-BKD-DATE-DD               PIC X(02).                    
                                                                        
       01 WS-COMMIT-DATA.                                               
          05 WS-COMMIT-TEXT               PIC X(09).                    
          05 WS-COMMIT-NUM                PIC 9(04).                    
          05 FILLER                       PIC X(69).                    
                                                                        
       01 WS-RESTART-DATA.                                              
          05 WS-RESTART-KEY.                                            
             10 WS-RES-RPT-DATE           PIC X(06).                    
             10 WS-RES-BATCH-NO           PIC 9(04).                    
             10 WS-RES-SEQ-NO             PIC 9(07).                    
             10 WS-RES-ACCT-NO            PIC 9(13).                    
                                                                        
       01 WS-RESTART-MISC.                                              
          05 WS-DEFAULT-CHKP-LIMIT        PIC 9(04)  VALUE 1.           
          05 WS-CHKP-LIMIT                PIC 9(04)  VALUE ZERO.        
          05 WS-COMMIT-NUMBER             PIC S9(07) VALUE ZERO COMP-3. 
          05 WS-RECORDS-PROCESSED         PIC S9(07) VALUE ZERO COMP-3. 
          05 WS-BATCHES-PROCESSED         PIC S9(07) VALUE ZERO COMP-3. 
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_ACCOUNT                                                             
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      * CSS_CSH_DRWR_CNTL                                                       
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_JOB_PARM                                                            
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_RESTART                                                             
           EXEC SQL                                                             
              INCLUDE TBRESTRT                                                  
           END-EXEC.                                                            
                                                                        
      *  CSS_CASHIER_OFFICE                                                     
           EXEC SQL                                                             
              INCLUDE TBCSHOFF                                                  
           END-EXEC.                                                            
A03244*                                                                         
A03244*  CSS_AR_TRANS_HIST                                                      
A03244     EXEC SQL                                                             
A03244        INCLUDE TBARHIST                                                  
A03244     END-EXEC.                                                            
                                                                        
       01  WS-END                      PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSAC180 ENDS HERE  '.            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
        01  PARM.                                                       
            05  LNGTH                     PIC S9(04) COMP.              
            05  WS-PASS-JOB               PIC X(08).                    
                                                                        
       PROCEDURE DIVISION USING PARM.                                   
                                                                        
      *----------------------------------------------------------------*        
      *                       M A I N L I N E                          *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-BKT                                     
              THRU 1000-EXIT                                            
             UNTIL FCSAC01-AT-EOF                                       
                                                                        
      *----------------------------------------------------------------*        
      *  BANKDRAFT RECORD TYPE 1 = FILE BEGIN REC.      - 1 PER FILE   *        
      *  BANKDRAFT RECORD TYPE 5 = BATCH HEADER         - DESIGNED     *        
      *        FOR MULTIPLE BATCHES BUT PCSCA190 ONLY PRODUCES ONE     *        
      *  BANKDRAFT RECORD TYPE 6 = BATCH DETAILS        - MULTIPLE     *        
      *  BANKDRAFT RECORD TYPE 8 = BATCH TOTAL END REC. - DESIGNED     *        
      *        FOR MULTIPLE BATCHES BUT PCSCA190 ONLY PRODUCES ONE     *        
      *  BANKDRAFT RECORD TYPE 9 = FILE END REC.        - 1 PER FILE   *        
      *----------------------------------------------------------------*        
           IF WS-RESTART-IND = 'N'                                      
              PERFORM 0750-PROCESS-BKD-HEADER                           
                 THRU 0750-EXIT                                         
           END-IF                                                       
           PERFORM 1200-PROCESS-BKD  THRU 1200-EXIT                     
             UNTIL FCSAC03-AT-EOF                                       
                                                                        
           PERFORM 8300-DELETE-RESTART                                  
              THRU 8300-EXIT                                            
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           IF WS-INPUT-ERROR-ACCT > 0                                   
              MOVE 03  TO  RETURN-CODE                                  
           END-IF                                                       
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   COMMON INITIALIZATION ROUTINE.                               *        
      *   OPEN ALL FILES AND CHECKS FOR DATA.                          *        
      *   CHECKS FOR RESTART RUN.                                      *        
      *----------------------------------------------------------------*        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           OPEN INPUT FCSAC01-FILE                                      
           IF FAC01-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              STRING '** OPEN ERROR OF FCSAC01 ' DELIMITED BY SIZE      
                     'INPUT FILE   **  '         DELIMITED BY SIZE      
                INTO WS-ERR-MSG                                         
              STRING 'FILE STATUS = '  DELIMITED BY SIZE                
                      WS-FAC01-STATUS  DELIMITED BY SIZE                
                INTO WS-ERR-MSG2                                        
              PERFORM 8900-DISPLAY-ERROR                                
                 THRU 8900-EXIT                                         
           END-IF                                                       
                                                                        
           OPEN INPUT FCSAC03-FILE                                      
           IF FAC03-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              STRING '** OPEN ERROR OF FCSAC03 ' DELIMITED BY SIZE      
                     'INPUT FILE   **  '         DELIMITED BY SIZE      
                INTO WS-ERR-MSG                                         
              STRING 'FILE STATUS = '  DELIMITED BY SIZE                
                      WS-FAC01-STATUS  DELIMITED BY SIZE                
                INTO WS-ERR-MSG2                                        
              PERFORM 8900-DISPLAY-ERROR                                
                 THRU 8900-EXIT                                         
           END-IF                                                       
                                                                        
           MOVE WS-DATABASE               TO C8-DELINQ-CD               
           PERFORM 7700-SELECT-DELINQUENCY                              
              THRU 7700-EXIT                                            
           IF C8-DELINQ-VALUE = WS-CSR                                  
              MOVE WS-1                   TO WS-PAYMENT-SOURCE-1        
           ELSE                                                         
              MOVE WS-2                   TO WS-PAYMENT-SOURCE-1        
           END-IF                                                       
                                                                        
           MOVE WS-DELINQUENCY-CD         TO C8-DELINQ-CD               
           PERFORM 7700-SELECT-DELINQUENCY                              
              THRU 7700-EXIT                                            
           MOVE C8-DELINQ-VALUE           TO WS-BKD-LOCATION-NUM        
           MOVE WS-BKD-LOCATION-NUM       TO WS-BKD-LOCATION            
                                                                        
           PERFORM 6251-GET-FJC01-DATE                                  
              THRU 6251-EXIT                                            
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '        TO WS-PGRMNAME                     
              MOVE SPACES            TO WS-INPUT-AREA                   
              MOVE SPACES            TO WS-INPUT-DATA-BREAKDOWN         
              PERFORM 6251-GET-FJC01-DATE                               
                 THRU 6251-EXIT                                         
              MOVE 'PCSAC180'        TO WS-PGRMNAME                     
           END-IF                                                       
           MOVE WS-INPUT-DATE(1:2)   TO WS-CENTURY                      
                                                                        
           MOVE WS-PASS-JOB(8:1)     TO WS-PARTITION-NO-CHAR            
           MOVE WS-PARTITION-NO      TO RF-PARTITION-NO                 
           PERFORM 1010-COMMIT-JOB-PARM                                 
              THRU 1010-EXIT                                            
                                                                        
           PERFORM 7100-READ-FCSAC01 THRU 7100-EXIT                     
           IF FCSAC01-AT-EOF                                            
              DISPLAY ' '                                               
              DISPLAY '******************************************'      
              DISPLAY '**   PCSAC180-01 PROCESSING INFORMATION **'      
              DISPLAY '**   FCSAC01 FILE EMPTY.                **'      
              DISPLAY '**   FOR THIS RUN, NO WAUSAU CASH       **'      
              DISPLAY '**   REMITTANCE PAYMENTS WERE READ.     **'      
              DISPLAY '**   PROCESSING WILL CONTINUE.          **'      
              DISPLAY '******************************************'      
           END-IF                                                       
                                                                        
           PERFORM 7200-READ-FCSAC03 THRU 7200-EXIT                     
           IF FCSAC03-AT-EOF                                            
              DISPLAY ' '                                               
              DISPLAY '******************************************'      
              DISPLAY '**   PCSAC180-01 PROCESSING INFORMATION **'      
              DISPLAY '**   FCSAC03 FILE EMPTY.                **'      
              DISPLAY '**   FOR THIS RUN, NO BANK DRAFT        **'      
              DISPLAY '**   PAYMENTS WERE READ.                **'      
              DISPLAY '**   PROCESSING WILL CONTINUE.          **'      
              DISPLAY '******************************************'      
           END-IF                                                       
                                                                        
           IF FCSAC01-AT-EOF AND FCSAC03-AT-EOF                         
              DISPLAY '                                          '      
              DISPLAY '******************************************'      
              DISPLAY '**     PCSAC180 PROCESSING ERROR        **'      
              DISPLAY '******************************************'      
              DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH     
              DISPLAY '** WAUSAU AND BANKDRAFT FILES EMPTY     **'      
              DISPLAY '**       PROCESSING TERMINATED          **'      
              DISPLAY '******************************************'      
              IF WS-PASS-JOB = 'CSRA1601' OR 'SEBA1601'                 
                 PERFORM 8400-UPDATE-PAGE-FILE THRU 8400-EXIT           
                 MOVE '05' TO RETURN-CODE                               
                 PERFORM 9000-TERMINATE THRU 9000-EXIT                  
                 STOP RUN                                               
              ELSE                                                      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 7500-CHECK-FOR-RESTART                               
              THRU 7500-EXIT                                            
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE RF-RESTART-DATA-TEXT TO WS-RESTART-DATA              
              MOVE 'Y'   TO WS-RESTART-IND                              
              PERFORM 0200-FIND-RESTART-REC                             
                 THRU 0200-EXIT                                         
           END-IF                                                       
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   FOR RESTART RUNS, THIS PARAGRAPH FINDS THE LAST COMMIT RECORD*        
      *   IN THE INPUT FILE                                            *        
      *----------------------------------------------------------------*        
       0200-FIND-RESTART-REC.                                           
                                                                        
           MOVE '0200' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           IF FCSAC01-AT-EOF                                            
              CONTINUE                                                  
           ELSE                                                         
              PERFORM UNTIL FCSAC01-AT-EOF OR REC-FOUND                 
                                                                        
                 IF REC-TYPE-DET = 3                                    
                    MOVE WS-N TO WS-FIRST-WAUSAU-HEADER-SW              
                    MOVE DOC-TOTAL-BTR     TO WS-BKT-HDR-PYMT-AMT       
                    MOVE TOTAL-NO-DOCS-BTR TO WS-BKT-HDR-ENTRIES        
                    MOVE ZERO              TO WS-BATCH-NO-ENTRIES       
                                              WS-BATCH-PYMT-AMT         
                    MOVE WS-CENTURY        TO WS-WORK-CC                
                    MOVE YEAR-DET          TO WS-WORK-YY                
                    MOVE MONTH-DET         TO WS-WORK-MM                
                    MOVE DAY-DET           TO WS-WORK-DD                
                    MOVE '000'             TO WS-PREV-LOCATION          
                    MOVE '01'              TO Y2-CASH-COMPANY-NO        
                    MOVE BATCH-TYPE-BTR2   OF REPORT-BTR2               
                                           TO WS-PAYMENT-SOURCE-2       
                    MOVE WS-PAYMENT-SOURCE-CD TO Y2-PAYMENT-SOURCE-CD   
                    PERFORM 8100-SELECT-CASH-OFF THRU 8100-EXIT         
                    MOVE REPORT-BTR-AREA TO WS-BATCH-NO                 
                 END-IF                                                 
                                                                        
                 IF REC-TYPE-DET = 1                                    
                    ADD 1       TO WS-BATCH-NO-ENTRIES                  
                    ADD AMT-DET TO WS-BATCH-PYMT-AMT                    
                 END-IF                                                 
                                                                        
                 IF WS-RES-RPT-DATE = DATE-DET                          
                    AND WS-RES-BATCH-NO = REPORT-DET-AREA               
                    AND WS-RES-SEQ-NO   = OUT-SEQ-NO-DET                
                    AND WS-RES-ACCT-NO  = ACCT-NO-DET                   
                    SET REC-FOUND TO TRUE                               
                 END-IF                                                 
                                                                        
                 PERFORM 7100-READ-FCSAC01                              
                    THRU 7100-EXIT                                      
              END-PERFORM                                               
                                                                        
              IF FCSAC01-AT-EOF AND REC-NOT-FOUND                       
                 STRING '** RESTART RECORD NOT '  DELIMITED BY SIZE     
                        'FOUND ON FCSAC01 FILE**' DELIMITED BY SIZE     
                        INTO WS-ERR-MSG                                 
                 STRING 'WS-RESTART-KEY = ' DELIMITED BY SIZE           
                         WS-RESTART-KEY     DELIMITED BY SIZE           
                        INTO WS-ERR-MSG2                                
                 PERFORM 8900-DISPLAY-ERROR                             
                    THRU 8900-EXIT                                      
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY ' ** THIS IS A RESTART RUN **'                 
                 DISPLAY ' ** LAST COMMIT POINT KEY IS ' WS-RESTART-KEY 
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF FCSAC03-AT-EOF                                            
              CONTINUE                                                  
           ELSE                                                         
              PERFORM UNTIL FCSAC03-AT-EOF OR REC-FOUND                 
                                                                        
                 IF CSHCNACH-RECORD-TYPE = WS-1                         
                    MOVE 8001          TO WS-BATCH-NO                   
                                          WS-RES-BATCH-NO               
                    MOVE ZERO          TO WS-BATCH-NO-ENTRIES           
                                          WS-BATCH-PYMT-AMT             
                    MOVE WS-CENTURY    TO WS-BKD-DATE-CC                
                    MOVE CSHCNACH-1-FILE-CREATE-YY                      
                                       TO WS-BKD-DATE-YY                
                    MOVE CSHCNACH-1-FILE-CREATE-MM                      
                                       TO WS-BKD-DATE-MM                
                    MOVE CSHCNACH-1-FILE-CREATE-DD                      
                                       TO WS-BKD-DATE-DD                
                 END-IF                                                 
                                                                        
                 IF CSHCNACH-RECORD-TYPE = WS-6                         
                    ADD 1 TO WS-BATCH-BKD-TYPE6                         
                             WS-TOTAL-BKD-TYPE6                         
                    IF CSHCNACH-6-TRANSACTION-CODE NOT EQUAL 28         
                       ADD 1  TO WS-TOTAL-NO-ENTRIES-BKD                
                       ADD CSHCNACH-6-DRAFT-AMT TO WS-BATCH-PYMT-AMT    
                                                   WS-TOTAL-AMT-BKD     
                    END-IF                                              
                 END-IF                                                 
                                                                        
                 IF WS-RES-RPT-DATE(1:2)     = WS-BKD-DATE-YY           
                    AND WS-RES-RPT-DATE(3:2) = WS-BKD-DATE-MM           
                    AND WS-RES-RPT-DATE(5:2) = WS-BKD-DATE-DD           
                    AND WS-RES-BATCH-NO = WS-BATCH-NO                   
                    AND WS-RES-SEQ-NO   = CSHCNACH-6-TRACE-SEQ          
                    AND WS-RES-ACCT-NO  = CSHCNACH-6-ID-NBR(1:13)       
                    SET REC-FOUND TO TRUE                               
                 END-IF                                                 
                                                                        
                 PERFORM 7200-READ-FCSAC03                              
                    THRU 7200-EXIT                                      
              END-PERFORM                                               
                                                                        
              IF FCSAC03-AT-EOF AND REC-NOT-FOUND                       
                 STRING '** RESTART RECORD NOT '  DELIMITED BY SIZE     
                        'FOUND ON FCSAC03 FILE**' DELIMITED BY SIZE     
                        INTO WS-ERR-MSG                                 
                 STRING 'WS-RESTART-KEY = ' DELIMITED BY SIZE           
                         WS-RESTART-KEY     DELIMITED BY SIZE           
                        INTO WS-ERR-MSG2                                
                 PERFORM 8900-DISPLAY-ERROR                             
                    THRU 8900-EXIT                                      
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY ' ** THIS IS A RESTART RUN **'                 
                 DISPLAY ' ** LAST COMMIT POINT KEY IS ' WS-RESTART-KEY 
              END-IF                                                    
           END-IF                                                       
           .                                                            
       0200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *----------------------------------------------------------------*        
      *   CHECKS BANKDRAFT HEADER RECORD AND CHECKS WHETHER FILE DATE  *        
      *   IS MATCHING WITH RUN DATE                                    *        
      *----------------------------------------------------------------*        
       0750-PROCESS-BKD-HEADER.                                         
                                                                        
           MOVE '0750' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           IF FCSAC03-AT-EOF                                            
              CONTINUE                                                  
           ELSE                                                         
              IF (CSHCNACH-RECORD-TYPE NOT EQUAL WS-1)                  
                 STRING '** BANKDRAFT FILE ERROR ' DELIMITED BY SIZE    
                      INTO WS-ERR-MSG                                   
                 STRING '** FIRST RECORD MUST BE ' DELIMITED BY SIZE    
                     'BANKDRAFT FILE HEADER **  '  DELIMITED BY SIZE    
                      INTO WS-ERR-MSG2                                  
                 PERFORM 8900-DISPLAY-ERROR                             
                    THRU 8900-EXIT                                      
              ELSE                                                      
                 MOVE 8001       TO WS-BATCH-NO                         
                                    WS-RES-BATCH-NO                     
                 MOVE ZERO     TO WS-BATCH-NO-ENTRIES                   
                                  WS-BATCH-PYMT-AMT                     
                 MOVE WS-CENTURY     TO WS-BKD-DATE-CC                  
                 MOVE CSHCNACH-1-FILE-CREATE-YY                         
                                     TO WS-BKD-DATE-YY                  
                                        WS-RES-RPT-DATE(1:2)            
                 MOVE CSHCNACH-1-FILE-CREATE-MM                         
                                     TO WS-BKD-DATE-MM                  
                                        WS-RES-RPT-DATE(3:2)            
                 MOVE CSHCNACH-1-FILE-CREATE-DD                         
                                     TO WS-BKD-DATE-DD                  
                                        WS-RES-RPT-DATE(5:2)            
                 IF WS-INPUT-DATE NOT = WS-BKD-DATE                     
                    STRING '** DATE ON BANKDRAFT HEADER DOES'           
                        DELIMITED BY SIZE                               
                        'NOT MATCH RUN DATE ' DELIMITED BY SIZE         
                        INTO WS-ERR-MSG                                 
                    STRING 'DRAFT FILE DATE = ' DELIMITED BY SIZE       
                        WS-BKD-DATE             DELIMITED BY SIZE       
                       'RUN DATE =  '  DELIMITED BY SIZE                
                       WS-INPUT-DATE   DELIMITED BY SIZE                
                        INTO WS-ERR-MSG2                                
                    PERFORM 8900-DISPLAY-ERROR                          
                       THRU 8900-EXIT                                   
                 END-IF                                                 
               END-IF                                                   
           END-IF                                                       
                                                                        
           IF FCSAC03-NOT-AT-EOF                                        
             READ FCSAC03-FILE                                          
                  AT END MOVE WS-Y TO FCSAC03-EOF-SW                    
           END-IF                                                       
           .                                                            
       0750-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *----------------------------------------------------------------*        
      *    PROCESS WAUSAU FILE                                         *        
      *----------------------------------------------------------------*        
       1000-PROCESS-BKT.                                                
                                                                        
           MOVE '1000' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           EVALUATE REC-TYPE-DET                                        
               WHEN WS-ONE                                              
                  PERFORM 2000-CREATE-BKT-DETAIL                        
                     THRU 2000-EXIT                                     
               WHEN WS-TWO                                              
                  CONTINUE                                              
               WHEN WS-THREE                                            
                  IF WS-FIRST-WAUSAU-HEADER                             
                     MOVE WS-N TO WS-FIRST-WAUSAU-HEADER-SW             
                  ELSE                                                  
                     PERFORM 2090-BKT-HEADER-CHECK                      
                        THRU 2090-EXIT                                  
                     ADD +1  TO WS-BATCHES-PROCESSED                    
                     IF WS-RECORDS-PROCESSED > 0                        
                        PERFORM 2050-WRITE-RESTART                      
                           THRU 2050-EXIT                               
                     END-IF                                             
                     DISPLAY '** THIS IS A BATCH COMMIT. '              
                       WS-BATCHES-PROCESSED '  BATCHES ARE PROCESSED. ' 
                  END-IF                                                
                  PERFORM 2100-PROCESS-BATCH                            
                     THRU 2100-EXIT                                     
               WHEN OTHER                                               
                 DISPLAY '**  PCSAC180-1000 PROCESSING ERROR   **'      
                 DISPLAY '** INVALID TRANSACTION FROM WAUSAU   **'      
                 DISPLAY '** BATCH NUMBER ===> ' BATCH-NO-DET2          
                 DISPLAY '** OUT SEQ NUMBER => ' OUT-SEQ-NO-DET         
                 DISPLAY '** REC TYPE =======> ' REC-TYPE-DET           
                 DISPLAY '**    PROCESSING WILL CONTINUE       **'      
           END-EVALUATE                                                 
                                                                        
           PERFORM 7100-READ-FCSAC01      THRU 7100-EXIT                
                                                                        
           IF FCSAC01-AT-EOF                                            
              PERFORM 2090-BKT-HEADER-CHECK                             
                 THRU 2090-EXIT                                         
              ADD +1  TO WS-BATCHES-PROCESSED                           
              IF WS-RECORDS-PROCESSED > 0                               
                 PERFORM 2050-WRITE-RESTART                             
                    THRU 2050-EXIT                                      
              END-IF                                                    
              DISPLAY '** THIS IS A BATCH COMMIT. ' WS-BATCHES-PROCESSED
                      '  BATCHES ARE PROCESSED. '                       
           END-IF                                                       
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *    GET JOB PARM FOR COMMIT LOGIC.                              *        
      *----------------------------------------------------------------*        
       1010-COMMIT-JOB-PARM.                                            
                                                                        
           MOVE '1010' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           MOVE SPACES TO WS-SYSIPT                                     
           MOVE WS-PGRMNAME TO WS-PROGRAM                               
           MOVE WS-PARM     TO WS-COMMAND                               
           MOVE ZEROS       TO WS-SEQUENCE                              
                                                                        
           PERFORM 7600-START-FCSJC01                                   
              THRU 7600-EXIT                                            
                                                                        
           PERFORM 7610-READ-FCSJC01                                    
              THRU 7610-EXIT                                            
             UNTIL (WS-INPUT-DATA-BREAKDOWN(1:6) = 'COMMIT')            
                OR END-OF-SYSIPT                                        
                                                                        
           MOVE G6-PARM-DATA  TO WS-COMMIT-DATA                         
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSAC180 PROCESSING INFO   **'            
                 DISPLAY '**    COMMIT PARM NOT PRESENT'                
                 DISPLAY '**  DEFAULT CHKP 50 IS USED'                  
                 MOVE WS-DEFAULT-CHKP-LIMIT TO WS-CHKP-LIMIT            
              WHEN WS-COMMIT-NUM NOT NUMERIC                            
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
                  STRING '** COMMIT PARM NOT NUMERIC' DELIMITED BY SIZE 
                    INTO WS-ERR-MSG                                     
                  STRING '** KEY = '    DELIMITED BY SIZE               
                         WS-INPUT-KEY   DELIMITED BY SIZE               
                    INTO WS-ERR-MSG2                                    
                 PERFORM 8900-DISPLAY-ERROR                             
                    THRU 8900-EXIT                                      
              WHEN WS-COMMIT-NUM  NUMERIC                               
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSAC180 PROCESSING INFO  **'             
                 MOVE WS-COMMIT-NUM  TO  WS-CHKP-LIMIT                  
                 DISPLAY '**    CHKP LIMIT IS ' WS-CHKP-LIMIT           
                 PERFORM 7611-CLOSE                                     
                    THRU 7611-EXIT                                      
           END-EVALUATE                                                 
           .                                                            
       1010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *  PROCESS BANK DRAFT FILE                                       *        
      *  CSHCNACH-TRANSACTION-CODE = 28 IS A PRENOTE TO THE BANK       *        
      *   IGNORE THESE RECORDS.                                        *        
      *  CSHCNACH-TRANSACTION-CODE = 27 SAVINGS ACCOUNT                *        
      *  CSHCNACH-TRANSACTION-CODE = 28 CHECKING ACCOUNT               *        
      *----------------------------------------------------------------*        
       1200-PROCESS-BKD.                                                
                                                                        
           MOVE '1200' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           EVALUATE CSHCNACH-RECORD-TYPE                                
              WHEN WS-6                                                 
                 PERFORM 2200-PROCESS-DETAIL-RECORD                     
                    THRU 2200-EXIT                                      
              WHEN WS-8                                                 
                 MOVE 'Y' TO WS-BKD-TYPE8-FOUND                         
                 PERFORM 1205-CHK-FOR-BKD-BATCH-ERR   THRU 1205-EXIT    
                 ADD +1  TO WS-BATCHES-PROCESSED                        
                 IF WS-TOTAL-NO-ENTRIES-BKD = 0                         
                    DISPLAY '*** THE BANKDRAFT FILE (FCSAC03) DID NOT ' 
                            'CONTAIN ANY PAYMENTS (TYPE 6 RECORDS) ***' 
                 END-IF                                                 
                 MOVE ZEROES             TO WS-BATCH-PYMT-AMT           
                 MOVE ZEROES             TO WS-BATCH-NO-ENTRIES         
                 MOVE ZEROES             TO WS-BATCH-BKD-TYPE6          
                                                                        
                 MOVE WS-SYSTEM          TO CS-BALANCED-BY              
                 MOVE '01'               TO CS-CASH-COMPANY-NO          
                 MOVE WS-BKD-LOCATION    TO CS-CASH-LOCAL-OFFICE        
                 MOVE WS-BKD-DATE        TO CS-DATE-CASH-REPORT         
                 MOVE WS-BATCH-NO        TO CS-CASH-DRAWER-ID           
                 PERFORM 8500-CLOSE-CASH-BATCH                          
                    THRU 8500-EXIT                                      
                                                                        
              WHEN WS-9                                                 
                 MOVE 'Y' TO WS-BKD-TYPE9-FOUND                         
                 IF WS-BKD-TYPE8-FOUND = 'Y'                            
                    PERFORM 1210-CHK-FOR-BKD-TOTAL-ERR THRU 1210-EXIT   
                 ELSE                                                   
                    STRING '** BANKDRAFT BATCH TOTAL' DELIMITED BY SIZE 
                          ' RECOD (TYPE8) MISSING IN' DELIMITED BY SIZE 
                          ' AC03 FILE'                DELIMITED BY SIZE 
                       INTO WS-ERR-MSG                                  
                    MOVE SPACES TO WS-ERR-MSG2                          
                    PERFORM 8900-DISPLAY-ERROR                          
                       THRU 8900-EXIT                                   
                 END-IF                                                 
           END-EVALUATE                                                 
                                                                        
           READ FCSAC03-FILE                                            
             AT END MOVE WS-Y        TO FCSAC03-EOF-SW                  
                                                                        
           IF FCSAC03-AT-EOF                                            
              IF WS-BKD-TYPE8-FOUND = 'N'                               
                 STRING '** BANKDRAFT BATCH TOTAL'   DELIMITED BY SIZE  
                        ' RECORD (TYPE8) MISSING IN' DELIMITED BY SIZE  
                        ' AC03 FILE'                 DELIMITED BY SIZE  
                  INTO WS-ERR-MSG                                       
                 MOVE SPACES TO WS-ERR-MSG2                             
                 PERFORM 8900-DISPLAY-ERROR                             
                    THRU 8900-EXIT                                      
              ELSE                                                      
                IF WS-BKD-TYPE9-FOUND = 'N'                             
                   STRING '** BANKDRAFT BATCH'  DELIMITED BY SIZE       
                       ' TOTAL RECORD (TYPE9) ' DELIMITED BY SIZE       
                       'MISSING IN AC03 FILE'   DELIMITED BY SIZE       
                    INTO WS-ERR-MSG                                     
                    MOVE SPACES TO WS-ERR-MSG2                          
                    PERFORM 8900-DISPLAY-ERROR                          
                       THRU 8900-EXIT                                   
                 END-IF                                                 
              END-IF                                                    
                                                                        
              MOVE WS-BKD-DATE   TO WS-RES-RPT-DATE                     
              MOVE WS-BATCH-NO   TO WS-RES-BATCH-NO                     
              MOVE CSHCNACH-6-TRACE-SEQ TO WS-RES-SEQ-NO                
              MOVE CSHCNACH-6-ID-NBR(1:13) TO WS-RES-ACCT-NO            
              IF WS-RECORDS-PROCESSED > 0                               
                 PERFORM 2050-WRITE-RESTART                             
                    THRU 2050-EXIT                                      
              END-IF                                                    
              DISPLAY '** THIS IS A BATCH COMMIT. ' WS-BATCHES-PROCESSED
                      '  BATCHES ARE PROCESSED. '                       
           END-IF                                                       
           .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   CHECKS WHETHER BANKDRAFT TOTAL AMOUNT AND COUNT MATCHES WITH *        
      *   BATCH TOTAL AMOUNT AND COUNT.                                *        
      *----------------------------------------------------------------*        
       1205-CHK-FOR-BKD-BATCH-ERR.                                      
                                                                        
           MOVE '1205' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           IF WS-BATCH-PYMT-AMT = CSHCNACH-8-TOTAL-DEBIT                
             CONTINUE                                                   
           ELSE                                                         
             MOVE CSHCNACH-8-TOTAL-DEBIT TO WS-DISP-AMT-NUM             
             MOVE WS-BATCH-PYMT-AMT      TO WS-PYMT-AMT-NUM             
             STRING '** BANKDRAFT BATCH TOTAL AMT ' DELIMITED BY SIZE   
                    'DOES NOT MATCH WITH AMT ON '   DELIMITED BY SIZE   
                    'ACTUAL RECORDS'                DELIMITED BY SIZE   
               INTO WS-ERR-MSG                                          
             STRING 'BATCH NO = '              DELIMITED BY SIZE        
                    WS-BATCH-NO                DELIMITED BY SIZE        
                    'DRAFT BATCH TOTAL AMT = ' DELIMITED BY SIZE        
                    WS-DISP-AMT                DELIMITED BY SIZE        
                    'ACTUAL AMT = '            DELIMITED BY SIZE        
                    WS-PYMT-AMT                DELIMITED BY SIZE        
               INTO WS-ERR-MSG2                                         
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
                                                                        
           IF WS-BATCH-BKD-TYPE6 = CSHCNACH-8-ENTRY-ADDENDA-COUNT       
             CONTINUE                                                   
           ELSE                                                         
             MOVE WS-BATCH-BKD-TYPE6  TO WS-DISP-CNT-NUM                
             STRING '** BANKDRAFT BATCH TOTAL RECORDS' DELIMITED BY SIZE
                    'DOES NOT MATCH WITH THE '         DELIMITED BY SIZE
                    'ACTUAL NO OF RECORDS'             DELIMITED BY SIZE
               INTO WS-ERR-MSG                                          
             STRING 'BATCH NO = '                  DELIMITED BY SIZE    
                    WS-BATCH-NO                    DELIMITED BY SIZE    
                    'DRAFT BATCH TOTAL RECORDS = ' DELIMITED BY SIZE    
                    CSHCNACH-8-ENTRY-ADDENDA-COUNT DELIMITED BY SIZE    
                    'ACTUAL RECORDS = '            DELIMITED BY SIZE    
                    WS-DISP-CNT                    DELIMITED BY SIZE    
               INTO WS-ERR-MSG2                                         
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
           .                                                            
       1205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   CHECKS WHETHER BANKDRAFT TOTAL AMOUNT AND COUNT MATCHES      *        
      *   WITH FILE TOTAL AMOUNT AND COUNT.                            *        
      *----------------------------------------------------------------*        
       1210-CHK-FOR-BKD-TOTAL-ERR.                                      
                                                                        
           MOVE '1210' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           IF WS-TOTAL-AMT-BKD = CSHCNACH-9-TOTAL-DEBIT                 
             CONTINUE                                                   
           ELSE                                                         
             MOVE CSHCNACH-9-TOTAL-DEBIT TO WS-DISP-AMT-NUM             
             MOVE WS-TOTAL-AMT-BKD       TO WS-PYMT-AMT-NUM             
             STRING '** BANKDRAFT FILE TOTAL AMT ' DELIMITED BY SIZE    
                    'DOES NOT MATCH WITH AMT ON '  DELIMITED BY SIZE    
                    'ACTUAL RECORDS PROCESSED'     DELIMITED BY SIZE    
               INTO WS-ERR-MSG                                          
             STRING 'DRAFT FILE TOTAL AMT = '      DELIMITED BY SIZE    
                    WS-DISP-AMT                    DELIMITED BY SIZE    
                    'ACTUAL AMOUNT = '             DELIMITED BY SIZE    
                    WS-PYMT-AMT                    DELIMITED BY SIZE    
               INTO WS-ERR-MSG2                                         
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
                                                                        
           IF WS-TOTAL-BKD-TYPE6 = CSHCNACH-9-ENTRY-ADDENDA-COUNT       
             CONTINUE                                                   
           ELSE                                                         
             MOVE WS-TOTAL-BKD-TYPE6  TO WS-DISP-CNT-NUM                
             STRING '** BANKDRAFT FILE TOTAL RECORDS' DELIMITED BY SIZE 
                    'DOES NOT MATCH WITH THE '        DELIMITED BY SIZE 
                    'ACTUAL NO OF RECORDS'            DELIMITED BY SIZE 
               INTO WS-ERR-MSG                                          
             STRING 'DRAFT FILE TOTAL RECORDS = '  DELIMITED BY SIZE    
                    CSHCNACH-9-ENTRY-ADDENDA-COUNT DELIMITED BY SIZE    
                    'ACTUAL RECORDS = '            DELIMITED BY SIZE    
                    WS-DISP-CNT                    DELIMITED BY SIZE    
               INTO WS-ERR-MSG2                                         
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
           .                                                            
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   ASSIGN VALUES FOR SCSAC180 VARIABLES FROM WAUSAU DETAIL      *        
      *   RECORD TO POST PAYMENT.                                      *        
      *----------------------------------------------------------------*        
       2000-CREATE-BKT-DETAIL.                                          
           MOVE '2000' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           MOVE AMT-DET               TO WS-PYMT-AMT-NUM                
           IF WS-PYMT-AMT IS NUMERIC                                    
              ADD AMT-DET             TO WS-BATCH-PYMT-AMT              
           ELSE                                                         
              STRING '** PAYMENT AMT IS  ' DELIMITED BY SIZE            
                     ' NOT NUMERIC'        DELIMITED BY SIZE            
                INTO WS-ERR-MSG                                         
              STRING 'ACCOUNT NO = '       DELIMITED BY SIZE            
                     WS-SUB-ACCOUNT-NO     DELIMITED BY SIZE            
                INTO WS-ERR-MSG2                                        
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
                                                                        
           ADD 1 TO WS-BATCH-NO-ENTRIES                                 
                                                                        
           MOVE ACCT-NO-9-DET  TO WS-SUB-ACCOUNT-NO                     
                                  AT-ACCOUNT-NO                         
                                                                        
           PERFORM 7300-SELECT-COMPANY-NO                               
              THRU 7300-EXIT                                            
           MOVE SPACES            TO WS-SUB-TIMESTAMP                   
           MOVE AT-COMPANY-NO     TO WS-SUB-COMPANY-NO                  
           MOVE WS-PREV-LOCATION  TO WS-SUB-CASH-LOC-OFFICE             
                                     WS-CONF-CSH-LOC-OFF                
           MOVE SPACES            TO WS-SUB-CUST-PHONE-NO               
           MOVE 'C'               TO WS-SUB-CURRENCY-TYPE               
           MOVE WS-PYMT-AMT       TO WS-SUB-PAYMENT-AMOUNT              
           MOVE WS-WORK-DATE      TO WS-SUB-REPORT-DATE                 
           MOVE 'UND'             TO WS-SUB-DIR-PYMT-IND                
           MOVE 'CSR03413B'       TO  WS-SUB-APPL-PGM-ID                
                                                                        
           SET WAUSAU-RECORD      TO TRUE                               
           PERFORM 2500-SELECT-FACILITY-CD                              
              THRU 2500-EXIT                                            
           MOVE WS-PYMT-FACILITY-CD TO WS-SUB-PYMT-FACILITY-CD          
                                                                        
           MOVE WS-BATCH-NO     TO WS-CONF-DRAWER-ID                    
           MOVE OUT-SEQ-NO-DET  TO WS-CONF-SEQ-NO-DET                   
           MOVE WS-CONFIRM-NO   TO WS-SUB-CONFIRMATION-NO               
                                                                        
           MOVE ZERO    TO WS-SUB-S-RETURN-CODE                         
           MOVE SPACES  TO WS-SUB-S-TIMESTAMP                           
                           WS-SUB-S-ACCOUNT-NO                          
                           WS-SUB-S-COMPANY-NO                          
                           WS-SUB-S-BILLED-BALANCE                      
                           WS-SUB-S-CANCEL-DNP-FLAG                     
                           WS-SUB-ERROR-SW                              
                           WS-SUB-PAR-MSG-NO                            
                           WS-SUB-ACTIVE-PARA                           
                                                                        
           PERFORM 9800-CALL-SCSAC180                                   
              THRU 9800-EXIT                                            
           IF WS-SUB-S-RETURN-CODE = 0 AND WS-SUB-ERROR-SW = SPACES     
              AND WS-SUB-PAR-MSG-NO = SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              IF WS-SUB-ERROR-SW > SPACES                               
                       AND WS-SUB-ERROR-SW NOT EQUAL '9'                
                 ADD +1 TO WS-INPUT-ERROR-ACCT                          
              ELSE                                                      
                 MOVE WS-SUB-S-RETURN-CODE TO WS-ACTIVE-RETURN-CODE     
A05203                                        WS-DISPLAY-RETURN-CODE    
                 MOVE WS-SUB-ACTIVE-PARA   TO WS-ACTIVE-PARAGRAPH       
                 DISPLAY 'ACCOUNT NO = '  WS-SUB-ACCOUNT-NO             
                 DISPLAY '** CURRENT PARAGRAPH = '  WS-ACTIVE-PARAGRAPH 
                 DISPLAY '** RETURN CODE   = ' WS-DISPLAY-RETURN-CODE   
A05203           DISPLAY '** CALLED PROGRAM FAILED: ' WS-SUB-APPL-PGM-ID
                 DISPLAY '** PAYMENT POSTING FAILED IN SCSAC180'        
                 IF WS-SUB-ERROR-SW = '9'                               
                    DISPLAY ' BATCH ALREADY POSTED '                    
                            ' PLEASE CORRECT THE ERROR '                
                 END-IF                                                 
                 IF WS-SUB-PAR-MSG-NO > SPACES                          
                    DISPLAY 'WS-PAR-MESSAGE-NO =' WS-SUB-PAR-MSG-NO     
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
           ADD +1 TO WS-RECORDS-PROCESSED                               
           IF WS-RECORDS-PROCESSED = WS-CHKP-LIMIT                      
             OR WS-BATCH-NO-ENTRIES = WS-BKT-HDR-ENTRIES                
              MOVE DATE-DET        TO WS-RES-RPT-DATE                   
              MOVE REPORT-DET-AREA TO WS-RES-BATCH-NO                   
              MOVE OUT-SEQ-NO-DET  TO WS-RES-SEQ-NO                     
              MOVE ACCT-NO-9-DET   TO WS-RES-ACCT-NO                    
              IF WS-RECORDS-PROCESSED = WS-CHKP-LIMIT                   
                 PERFORM 2050-WRITE-RESTART                             
                    THRU 2050-EXIT                                      
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   INSERTS/UPDATES RESTART RECORD AND DOES A COMMIT TO SAVE     *        
      *   ALL PRIOR TRANSACTIONS.                                      *        
      *----------------------------------------------------------------*        
       2050-WRITE-RESTART.                                              
                                                                        
           MOVE '2050' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           MOVE +30             TO RF-RESTART-DATA-LEN                  
           MOVE WS-RESTART-DATA TO RF-RESTART-DATA-TEXT                 
                                                                        
           PERFORM 8200-UPDATE-RESTART                                  
              THRU 8200-EXIT                                            
           PERFORM 8999-ISSUE-COMMIT                                    
              THRU 8999-EXIT                                            
           MOVE 0   TO WS-RECORDS-PROCESSED                             
           ADD +1   TO WS-COMMIT-NUMBER                                 
           MOVE 'Y' TO WS-RESTART-IND                                   
                                                                        
           DISPLAY ' '                                                  
           DISPLAY '** COMMIT NUMBER ' WS-COMMIT-NUMBER ' TAKEN'        
                   ' FOR KEY ' WS-RESTART-KEY                           
           .                                                            
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   THESE EDITS ARE CHECKS WHEN A WAUSAU HEADER RECORD IS        *        
      *   DETECTED WHICH IS NOT THE FIRST IN THE FILE. THE WAUSAU FILE *        
      *   WAS SORTED PRIOR TO THIS PROGRAM SO THAT THE HEADERS PRECEED *        
      *   THE DETAIL. AFTER THE DETAIL NUMBER OF ENTRIES AND BATCH     *        
      *   TOTAL PAYMENT AMOUNT ARE ACCUMULATED, THEY ARE COMPARED TO   *        
      *   TO WHAT WAS SAVED FROM THE PREVIOUS HEADER RECORD. IF THEY   *        
      *   DO NOT MATCH, THE PROGRAM IS INSTRUCTED TO STOP PROCESSING.  *        
      *   THIS ALSO CLOSES THE BATCH OPENED EARLIER TO POST PAYMENT.   *        
      *----------------------------------------------------------------*        
       2090-BKT-HEADER-CHECK.                                           
                                                                        
           MOVE '2090' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
              DISPLAY 'HEADER NO OF ENTRIES ===> ' WS-BKT-HDR-ENTRIES   
              DISPLAY 'ACTUAL NO OF ENTRIES ===> ' WS-BATCH-NO-ENTRIES  
              DISPLAY 'HEADER PAYMENT AMT =====> ' WS-BKT-HDR-PYMT-AMT  
              DISPLAY 'ACTUAL PAYMENT AMT =====> ' WS-BATCH-PYMT-AMT    
                                                                        
           IF WS-BATCH-NO-ENTRIES = WS-BKT-HDR-ENTRIES                  
              CONTINUE                                                  
           ELSE                                                         
             MOVE WS-BATCH-NO-ENTRIES TO WS-DISP-CNT-NUM                
             MOVE WS-BKT-HDR-ENTRIES  TO WS-DISP-CNT-2-NUM              
             STRING '** NO OF ENTRIES ON WAUSAU '  DELIMITED BY SIZE    
                    'HEADER RECORD DOES NOT MATCH' DELIMITED BY SIZE    
                    'ACTUAL NO OF RECORDS'         DELIMITED BY SIZE    
               INTO WS-ERR-MSG                                          
             STRING 'BATCH NO = '             DELIMITED BY SIZE         
                    WS-BATCH-NO               DELIMITED BY SIZE         
                    'HEADER NO OF ENTRIES = ' DELIMITED BY SIZE         
                    WS-DISP-CNT-2             DELIMITED BY SIZE         
                    'ACTUAL NO OF ENTRIES = ' DELIMITED BY SIZE         
                    WS-DISP-CNT               DELIMITED BY SIZE         
               INTO WS-ERR-MSG2                                         
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
                                                                        
           IF WS-BATCH-NO-ENTRIES > WS-1000                             
             MOVE WS-BATCH-NO-ENTRIES TO WS-DISP-CNT-NUM                
             STRING '** NO OF ENTRIES IN A BATCH ' DELIMITED BY SIZE    
                    'EXCEEDED 1000. CHECK WAUSAU'  DELIMITED BY SIZE    
                    'FILE'                         DELIMITED BY SIZE    
               INTO WS-ERR-MSG                                          
             STRING 'BATCH NO = '             DELIMITED BY SIZE         
                    WS-BATCH-NO               DELIMITED BY SIZE         
                    'ACTUAL NO OF ENTRIES = ' DELIMITED BY SIZE         
                    WS-DISP-CNT               DELIMITED BY SIZE         
               INTO WS-ERR-MSG2                                         
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
                                                                        
           IF WS-BATCH-PYMT-AMT = WS-BKT-HDR-PYMT-AMT                   
              CONTINUE                                                  
           ELSE                                                         
             MOVE WS-BKT-HDR-PYMT-AMT TO WS-DISP-AMT-NUM                
             MOVE WS-BATCH-PYMT-AMT   TO WS-PYMT-AMT-NUM                
             STRING '** PAYMENT AMOUNT ON HEADER ' DELIMITED BY SIZE    
                    'RECORD DOES NOT MATCH ACTUAL' DELIMITED BY SIZE    
                    'AMOUNT'                       DELIMITED BY SIZE    
               INTO WS-ERR-MSG                                          
             STRING 'BATCH NO = '              DELIMITED BY SIZE        
                    WS-BATCH-NO                DELIMITED BY SIZE        
                    'HEADER PAYMENT AMOUNT = ' DELIMITED BY SIZE        
                    WS-DISP-AMT                DELIMITED BY SIZE        
                    'ACTUAL PAYMENT AMOUNT = ' DELIMITED BY SIZE        
                    WS-PYMT-AMT                DELIMITED BY SIZE        
               INTO WS-ERR-MSG2                                         
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
                                                                        
           MOVE WS-SYSTEM                  TO CS-BALANCED-BY            
           MOVE '01'                       TO CS-CASH-COMPANY-NO        
           MOVE WS-PREV-LOCATION           TO CS-CASH-LOCAL-OFFICE      
           MOVE WS-WORK-DATE               TO CS-DATE-CASH-REPORT       
           MOVE WS-BATCH-NO                TO CS-CASH-DRAWER-ID         
           PERFORM 8500-CLOSE-CASH-BATCH                                
              THRU 8500-EXIT                                            
           .                                                            
       2090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * PROCESS WAUSAU HEADER RECORD                                  *         
      *---------------------------------------------------------------*         
       2100-PROCESS-BATCH.                                              
                                                                        
           MOVE '2100' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           MOVE REPORT-BTR-AREA       TO WS-BATCH-NO                    
           MOVE '000'                 TO WS-PREV-LOCATION               
           MOVE '01'                  TO Y2-CASH-COMPANY-NO             
           MOVE BATCH-TYPE-BTR2 OF REPORT-BTR2                          
                                      TO WS-PAYMENT-SOURCE-2            
           MOVE WS-PAYMENT-SOURCE-CD  TO Y2-PAYMENT-SOURCE-CD           
                                                                        
           PERFORM 8100-SELECT-CASH-OFF THRU 8100-EXIT                  
           MOVE TOTAL-NO-DOCS-BTR     TO WS-BKT-HDR-ENTRIES             
           MOVE DOC-TOTAL-BTR         TO WS-BKT-HDR-PYMT-AMT            
                                                                        
           MOVE WS-CENTURY            TO WS-WORK-CC                     
           MOVE YEAR-DET              TO WS-WORK-YY                     
           MOVE MONTH-DET             TO WS-WORK-MM                     
           MOVE DAY-DET               TO WS-WORK-DD                     
                                                                        
           IF WS-INPUT-DATE NOT = WS-WORK-DATE                          
             STRING '** DATE ON WAUSAU HEADER '  DELIMITED BY SIZE      
                    'DOES NOT MATCH RUN DATE'    DELIMITED BY SIZE      
               INTO WS-ERR-MSG                                          
             STRING 'BATCH NO = '          DELIMITED BY SIZE            
                    BATCH-NO-BTR2          DELIMITED BY SIZE            
                    'BATCH HEADER DATE = ' DELIMITED BY SIZE            
                    WS-WORK-DATE           DELIMITED BY SIZE            
                    ' RUN DATE  = '        DELIMITED BY SIZE            
                    WS-INPUT-DATE          DELIMITED BY SIZE            
               INTO WS-ERR-MSG2                                         
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
                                                                        
           MOVE ZEROES TO WS-BATCH-NO-ENTRIES                           
                          WS-BATCH-PYMT-AMT                             
           .                                                            
       2100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------*         
      * PROCESS WAUSAU DETAIL RECORD                                  *         
      *---------------------------------------------------------------*         
       2200-PROCESS-DETAIL-RECORD.                                      
                                                                        
           ADD 1 TO WS-BATCH-BKD-TYPE6                                  
                    WS-TOTAL-BKD-TYPE6                                  
                                                                        
           IF CSHCNACH-6-TRANSACTION-CODE NOT EQUAL 28                  
              ADD 1                    TO WS-TOTAL-NO-ENTRIES-BKD       
              ADD CSHCNACH-6-DRAFT-AMT TO WS-BATCH-PYMT-AMT             
                                          WS-TOTAL-AMT-BKD              
                                                                        
              MOVE CSHCNACH-6-CODE-SOURCE-ID TO WS-CODE-SOURCE-ID       
              MOVE CSHCNACH-6-ID-NBR   TO WS-SUB-ACCOUNT-NO             
                                          WS-ACCOUNT-NO                 
              MOVE WS-ACCOUNT-NO-NUM   TO AT-ACCOUNT-NO                 
                                                                        
              PERFORM 7300-SELECT-COMPANY-NO                            
                 THRU 7300-EXIT                                         
              MOVE SPACES              TO   WS-SUB-TIMESTAMP            
              MOVE AT-COMPANY-NO       TO   WS-SUB-COMPANY-NO           
              MOVE WS-BKD-LOCATION     TO   WS-SUB-CASH-LOC-OFFICE      
                                            WS-CONF-CSH-LOC-OFF         
              MOVE SPACES              TO   WS-SUB-CUST-PHONE-NO        
              MOVE WS-D                TO   WS-SUB-CURRENCY-TYPE        
                                                                        
              MOVE CSHCNACH-6-DRAFT-AMT  TO WS-PYMT-AMT-NUM             
              IF WS-PYMT-AMT IS NUMERIC                                 
                 MOVE WS-PYMT-AMT TO WS-SUB-PAYMENT-AMOUNT              
              ELSE                                                      
                 STRING '** PAYMENT AMT IS  ' DELIMITED BY SIZE         
                        ' NOT NUMERIC'        DELIMITED BY SIZE         
                   INTO WS-ERR-MSG                                      
                 STRING 'ACCOUNT NO = '       DELIMITED BY SIZE         
                        WS-SUB-ACCOUNT-NO     DELIMITED BY SIZE         
                   INTO WS-ERR-MSG2                                     
                 PERFORM 8900-DISPLAY-ERROR                             
                    THRU 8900-EXIT                                      
              END-IF                                                    
                                                                        
              MOVE WS-BKD-DATE          TO WS-SUB-REPORT-DATE           
              MOVE 'UND'                TO WS-SUB-DIR-PYMT-IND          
              MOVE 'CSR03413B'          TO WS-SUB-APPL-PGM-ID           
                                                                        
              SET BANKDRAFT-RECORD      TO TRUE                         
              PERFORM 2500-SELECT-FACILITY-CD                           
                 THRU 2500-EXIT                                         
              MOVE WS-PYMT-FACILITY-CD  TO WS-SUB-PYMT-FACILITY-CD      
                                                                        
              MOVE WS-BATCH-NO          TO WS-CONF-DRAWER-ID            
              MOVE CSHCNACH-6-TRACE-SEQ TO WS-CONF-SEQ-NO-DET           
              MOVE WS-CONFIRM-NO        TO WS-SUB-CONFIRMATION-NO       
                                                                        
              MOVE ZERO    TO WS-SUB-S-RETURN-CODE                      
              MOVE SPACES  TO WS-SUB-S-TIMESTAMP                        
                              WS-SUB-S-ACCOUNT-NO                       
                              WS-SUB-S-COMPANY-NO                       
                              WS-SUB-S-BILLED-BALANCE                   
                              WS-SUB-S-CANCEL-DNP-FLAG                  
                              WS-SUB-ERROR-SW                           
                              WS-SUB-PAR-MSG-NO                         
                              WS-SUB-ACTIVE-PARA                        
                                                                        
              PERFORM 9800-CALL-SCSAC180                                
                 THRU 9800-EXIT                                         
              IF WS-SUB-S-RETURN-CODE = 0 AND WS-SUB-ERROR-SW = SPACES  
                                 AND WS-SUB-PAR-MSG-NO = SPACES         
A03244           IF WS-PYMT-FACILITY-CD = 'Z'                           
A03244                      OR WS-PYMT-FACILITY-CD = 'G'                
P00613                      OR WS-PYMT-FACILITY-CD = 'I'                
A03244              MOVE CSHCNACH-6-CUST-BANK-SEQ-NO   TO               
A03244                                AR-CUST-BANK-SEQ-NO,              
A03244                                WS-CUST-BANK-SEQ-NO               
A03244              PERFORM 8650-UPDATE-TRANS-HIST  THRU 8650-EXIT      
A03244           END-IF                                                 
              ELSE                                                      
                 IF WS-SUB-ERROR-SW > SPACES                            
                                 AND WS-SUB-ERROR-SW NOT EQUAL '9'      
                    ADD +1 TO WS-INPUT-ERROR-ACCT                       
                 ELSE                                                   
                    MOVE WS-SUB-S-RETURN-CODE TO WS-ACTIVE-RETURN-CODE  
A05203                                           WS-DISPLAY-RETURN-CODE 
                    MOVE WS-SUB-ACTIVE-PARA   TO WS-ACTIVE-PARAGRAPH    
                    DISPLAY '** PAYMENT POSTING FAILED IN SCSAC180'     
                    DISPLAY 'ACCOUNT NO = '  WS-SUB-ACCOUNT-NO          
                    DISPLAY '** CURRENT PARAGRAPH = '                   
                              WS-ACTIVE-PARAGRAPH                       
                    DISPLAY '** RETURN CODE       = '                   
                               WS-DISPLAY-RETURN-CODE                   
                    IF WS-SUB-ERROR-SW = '9'                            
                       DISPLAY ' BATCH ALREADY POSTED '                 
                               ' PLEASE CORRECT THE ERROR '             
                    END-IF                                              
                    IF WS-SUB-PAR-MSG-NO > SPACES                       
                       DISPLAY 'WS-PAR-MESSAGE-NO =' WS-SUB-PAR-MSG-NO  
                    END-IF                                              
                    PERFORM 9900-ABEND                                  
                       THRU 9900-EXIT                                   
                 END-IF                                                 
              END-IF                                                    
                                                                        
              ADD +1 TO WS-RECORDS-PROCESSED                            
              IF WS-RECORDS-PROCESSED = WS-CHKP-LIMIT                   
                 MOVE CSHCNACH-6-TRACE-SEQ    TO WS-RES-SEQ-NO          
                 MOVE CSHCNACH-6-ID-NBR(1:13) TO WS-RES-ACCT-NO         
                 PERFORM 2050-WRITE-RESTART                             
                    THRU 2050-EXIT                                      
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * ASSIGN FACILITY CODE                                          *         
      *---------------------------------------------------------------*         
       2500-SELECT-FACILITY-CD.                                         
                                                                        
           MOVE '2500' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           EVALUATE WS-RECORD-SW                                        
                                                                        
              WHEN 'T'                                                  
                                                                        
                 EVALUATE WS-SUB-CASH-LOC-OFFICE                        
                    WHEN '004'                                          
                    WHEN '009'                                          
                    WHEN '013'                                          
                    WHEN '021'                                          
                    WHEN '006'                                          
                      MOVE 'T'        TO WS-PYMT-FACILITY-CD            
                    WHEN '018'                                          
                      MOVE 'S'        TO WS-PYMT-FACILITY-CD            
      * LO 019 SCEG RAPIDPAY                                                    
                    WHEN '019'                                          
                    WHEN '024'                                          
                    WHEN '049'                                          
                    WHEN '033'                                          
                    WHEN '028'                                          
                    WHEN '029'                                          
                    WHEN '036'                                          
                    WHEN '039'                                          
                      MOVE 'Y'        TO WS-PYMT-FACILITY-CD            
                    WHEN '027'                                          
                      MOVE 'Z'        TO WS-PYMT-FACILITY-CD            
      * 032 - SCEG EDI, 040 - SEB EDI                                           
                    WHEN '032'                                          
                    WHEN '040'                                          
                      MOVE 'Q'        TO WS-PYMT-FACILITY-CD            
                    WHEN OTHER                                          
                      MOVE SPACES     TO WS-PYMT-FACILITY-CD            
                 END-EVALUATE                                           
                                                                        
              WHEN 'D'                                                  
                 PERFORM 7400-CHECK-FOR-EPAY                            
                    THRU 7400-EXIT                                      
                 IF EPAY-ACCOUNT                                        
P00613              IF CSHCNACH-6-BANK-DISCRET-DATA(2:1) = 'I'          
P00613                 MOVE 'I'       TO WS-PYMT-FACILITY-CD            
P00613              ELSE                                                
                       MOVE 'Z'       TO WS-PYMT-FACILITY-CD            
P00613              END-IF                                              
                 ELSE                                                   
                    IF WS-CODE-SOURCE-ID = 'E'                          
P00613                 IF CSHCNACH-6-BANK-DISCRET-DATA(2:1) = 'I'       
P00613                    MOVE 'I'    TO WS-PYMT-FACILITY-CD            
P00613                 ELSE                                             
                          MOVE 'Z'    TO WS-PYMT-FACILITY-CD            
P00613                 END-IF                                           
                    ELSE                                                
                       MOVE 'G'       TO WS-PYMT-FACILITY-CD            
                    END-IF                                              
                 END-IF                                                 
                                                                        
              WHEN OTHER                                                
                 MOVE SPACES          TO WS-PYMT-FACILITY-CD            
           END-EVALUATE                                                 
           .                                                            
       2500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------*         
      * 6251-GET-FJC01-DATE                                           *         
      *---------------------------------------------------------------*         
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      * READ WAUSAU FILE                                              *         
      *---------------------------------------------------------------*         
       7100-READ-FCSAC01.                                               
           MOVE '7100' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           READ FCSAC01-FILE                                            
             AT END                                                     
               MOVE WS-Y TO FCSAC01-EOF-SW                              
                                                                        
           IF FAC01-SUCCESSFUL OR FCSAC01-AT-EOF                        
              CONTINUE                                                  
           ELSE                                                         
             STRING '** READ ERROR OF FCSAC01 FILE ' DELIMITED BY SIZE  
               INTO WS-ERR-MSG                                          
             STRING 'FILE STATUS = ' DELIMITED BY SIZE                  
                    WS-FAC01-STATUS  DELIMITED BY SIZE                  
               INTO WS-ERR-MSG2                                         
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------*         
      * READ BANK DRAFT FILE                                          *         
      *---------------------------------------------------------------*         
       7200-READ-FCSAC03.                                               
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           READ FCSAC03-FILE                                            
             AT END                                                     
               MOVE WS-Y TO FCSAC03-EOF-SW                              
                                                                        
           IF FAC03-SUCCESSFUL OR FCSAC03-AT-EOF                        
              CONTINUE                                                  
           ELSE                                                         
             STRING '** READ ERROR OF FCSAC03 FILE ' DELIMITED BY SIZE  
               INTO WS-ERR-MSG                                          
             STRING 'FILE STATUS = ' DELIMITED BY SIZE                  
                    WS-FAC03-STATUS  DELIMITED BY SIZE                  
               INTO WS-ERR-MSG2                                         
             PERFORM 8900-DISPLAY-ERROR                                 
                THRU 8900-EXIT                                          
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------*         
      * SELECT THE COMPANY NO FROM ACCOUNT TABLE                      *         
      *---------------------------------------------------------------*         
       7300-SELECT-COMPANY-NO.                                          
                                                                        
           MOVE '7300' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
            EXEC SQL                                                    
              SELECT COMPANY_NO                                         
                INTO :AT-COMPANY-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT COMPANY_NO                                                 
MFA-TR*         INTO :AT-COMPANY-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE         
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
            ELSE                                                        
              STRING '** SELECTING COMPANY NO FROM ' DELIMITED BY SIZE  
                     'CSS_ACCOUNT  **  '             DELIMITED BY SIZE  
                      INTO WS-ERR-MSG                                   
              STRING 'ACCOUNT_NO '                   DELIMITED BY SIZE  
                      WS-SUB-ACCOUNT-NO              DELIMITED BY SIZE  
                      INTO WS-ERR-MSG2                                  
                                                                        
              PERFORM 8800-DISPLAY-TABLE-ERROR                          
                 THRU 8800-EXIT                                         
            END-IF                                                      
           .                                                            
       7300-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------*         
      * CHECKS WHETHER AN ACCOUNT IS ON EPAY                          *         
      *---------------------------------------------------------------*         
       7400-CHECK-FOR-EPAY.                                             
                                                                        
           MOVE '7400' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           MOVE 'N'   TO WS-EPAY-ACCOUNT                                
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-EPAY-ACCOUNT                                    
               FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND STATUS_CODE IN ('M','N','O')                        
                                             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-EPAY-ACCOUNT                                            
MFA-TR*        FROM CSS_BANK_EFT                                                
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*         AND STATUS_CODE IN ('M','N','O')                                
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
             STRING '** CHECK FOR EPAY ACCOUNT IN ' DELIMITED BY SIZE   
                    'CSS_BANK_EFT   **  '           DELIMITED BY SIZE   
                     INTO WS-ERR-MSG                                    
             STRING 'ACCOUNT_NO '                   DELIMITED BY SIZE   
                     WS-SUB-ACCOUNT-NO              DELIMITED BY SIZE   
                    'STATUS_CD IN ("M","N","O")'    DELIMITED BY SIZE   
                     INTO WS-ERR-MSG2                                   
                                                                        
             PERFORM 8800-DISPLAY-TABLE-ERROR                           
                THRU 8800-EXIT                                          
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * CHECKS FOR RESTART RECORD FOR THE PROGRAM                     *         
      *---------------------------------------------------------------*         
       7500-CHECK-FOR-RESTART.                                          
                                                                        
           MOVE '7500' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           EXEC SQL                                                     
             SELECT RESTART_DATA                                        
               INTO :RF-RESTART-DATA                                    
               FROM CSS_RESTART WITH(READUNCOMMITTED)                           
              WHERE NAME_PROGRAM = 'PCSAC180'                           
                AND DUP_CNTRL_NO = 1                                    
                AND PARTITION_NO = :RF-PARTITION-NO                     
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT RESTART_DATA                                                
MFA-TR*        INTO :RF-RESTART-DATA                                            
MFA-TR*        FROM CSS_RESTART                                                 
MFA-TR*       WHERE NAME_PROGRAM = 'PCSAC180'                                   
MFA-TR*         AND DUP_CNTRL_NO = 1                                            
MFA-TR*         AND PARTITION_NO = :RF-PARTITION-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
             STRING '** CHECK FOR RESTART DATA IN ' DELIMITED BY SIZE   
                    'CSS_RESTART    **  '           DELIMITED BY SIZE   
                    INTO WS-ERR-MSG                                     
             STRING 'PROGRAM NAME = PCSAC180 '      DELIMITED BY SIZE   
                    'PARTITION NO = '               DELIMITED BY SIZE   
                    WS-PARTITION-NO                 DELIMITED BY SIZE   
                    INTO WS-ERR-MSG2                                    
                                                                        
             PERFORM 8800-DISPLAY-TABLE-ERROR                           
                THRU 8800-EXIT                                          
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * SELECT DELINQUENCY VALUE FOR THE DELINQUENCY CODE             *         
      *---------------------------------------------------------------*         
        7700-SELECT-DELINQUENCY.                                        
                                                                        
           MOVE '7700' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
            EXEC SQL                                                    
              SELECT DELINQ_VALUE                                       
                    ,DESCRIPTION                                        
                INTO :C8-DELINQ-VALUE                                   
                    ,:C8-DESCRIPTION                                    
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD   = :C8-DELINQ-CD                        
                 AND COMPANY_NO  = '01'                                 
                                                                 
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*             ,DESCRIPTION                                                
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*             ,:C8-DESCRIPTION                                            
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD   = :C8-DELINQ-CD                                
MFA-TR*          AND COMPANY_NO  = '01'                                         
MFA-TR*         WITH UR                                                         
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE         
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
            ELSE                                                        
              STRING '** SELECTING DATABASE FROM ' DELIMITED BY SIZE    
                     'CSS_DELINQUENCY  **  '       DELIMITED BY SIZE    
                      INTO WS-ERR-MSG                                   
              STRING 'DELINQ_CD '                  DELIMITED BY SIZE    
                      C8-DELINQ-CD                 DELIMITED BY SIZE    
                      INTO WS-ERR-MSG2                                  
                                                                        
              PERFORM 8800-DISPLAY-TABLE-ERROR                          
                 THRU 8800-EXIT                                         
            END-IF                                                      
            .                                                           
        7700-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------*         
      * SELECT CASHIER OFFICE USING PAYMENT SOURCE CODE               *         
      *---------------------------------------------------------------*         
       8100-SELECT-CASH-OFF.                                            
                                                                        
           MOVE '8100' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           EXEC SQL                                                     
             SELECT CASH_LOCAL_OFFICE                                   
               INTO :Y2-CASH-LOCAL-OFFICE                               
               FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = :Y2-CASH-COMPANY-NO            
                AND PAYMENT_SOURCE_CD  = :Y2-PAYMENT-SOURCE-CD          
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CASH_LOCAL_OFFICE                                           
MFA-TR*        INTO :Y2-CASH-LOCAL-OFFICE                                       
MFA-TR*        FROM CSS_CASHIER_OFFICE                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :Y2-CASH-COMPANY-NO                    
MFA-TR*         AND PAYMENT_SOURCE_CD  = :Y2-PAYMENT-SOURCE-CD                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE Y2-CASH-LOCAL-OFFICE TO WS-PREV-LOCATION             
           ELSE                                                         
             STRING '** SELECTING CASH LOCAL OFFICE' DELIMITED BY SIZE  
                     'FROM CSS_CASHIER_OFFICE ** '   DELIMITED BY SIZE  
                     INTO WS-ERR-MSG                                    
             STRING 'CASH_COMPANY_NO = '  DELIMITED BY SIZE             
                     Y2-CASH-COMPANY-NO   DELIMITED BY SIZE             
                    'PAYMENT_SOURCE_CD'   DELIMITED BY SIZE             
                     Y2-PAYMENT-SOURCE-CD DELIMITED BY SIZE             
                     INTO WS-ERR-MSG2                                   
                                                                        
             PERFORM 8800-DISPLAY-TABLE-ERROR                           
                THRU 8800-EXIT                                          
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * INSERT/UPDATE RESTART RECORD                                  *         
      *---------------------------------------------------------------*         
       8200-UPDATE-RESTART.                                             
                                                                        
           MOVE '8200' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           IF WS-RESTART-IND = WS-Y                                     
              EXEC SQL                                                  
                UPDATE CSS_RESTART                                      
                   SET RESTART_DATA = :RF-RESTART-DATA                  
                 WHERE NAME_PROGRAM = 'PCSAC180'                        
                   AND DUP_CNTRL_NO = 1                                 
                   AND PARTITION_NO = :RF-PARTITION-NO                  
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           ELSE                                                         
              EXEC SQL                                                  
                INSERT INTO CSS_RESTART                                 
                      (NAME_PROGRAM                                     
                      ,PARTITION_NO                                     
                      ,DUP_CNTRL_NO                                     
                      ,RESTART_DATA)                                    
                VALUES                                                  
                      ('PCSAC180'                                       
                      ,:RF-PARTITION-NO                                 
                      ,1                                                
                      ,:RF-RESTART-DATA)                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF                                                       
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
             STRING '** UPDATE/INSERT RESTART '   DELIMITED BY SIZE     
                    'DATA IN CSS_RESTART    **  ' DELIMITED BY SIZE     
                    INTO WS-ERR-MSG                                     
             STRING 'PROGRAM NAME = PCSAC180 '    DELIMITED BY SIZE     
                    'PARTITION NO = ' DELIMITED BY SIZE                 
                    WS-PARTITION-NO   DELIMITED BY SIZE                 
                    'RESTART DATA = ' DELIMITED BY SIZE                 
                    WS-RESTART-KEY    DELIMITED BY SIZE                 
                    INTO WS-ERR-MSG2                                    
                                                                        
             PERFORM 8800-DISPLAY-TABLE-ERROR                           
                THRU 8800-EXIT                                          
           END-IF                                                       
           .                                                            
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * DELETES THE RESTART RECORD                                    *         
      *---------------------------------------------------------------*         
       8300-DELETE-RESTART.                                             
                                                                        
           MOVE '8300' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_RESTART                                    
              WHERE NAME_PROGRAM = 'PCSAC180'                           
                AND DUP_CNTRL_NO = 1                                    
                AND PARTITION_NO = :RF-PARTITION-NO                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
             STRING '** DELETE RESTART DATA '   DELIMITED BY SIZE       
                    'IN CSS_RESTART    **  '    DELIMITED BY SIZE       
                    INTO WS-ERR-MSG                                     
             STRING 'PROGRAM NAME = PCSAC180 '  DELIMITED BY SIZE       
                    'PARTITION NO = ' DELIMITED BY SIZE                 
                    WS-PARTITION-NO   DELIMITED BY SIZE                 
                    INTO WS-ERR-MSG2                                    
                                                                        
             PERFORM 8800-DISPLAY-TABLE-ERROR                           
                THRU 8800-EXIT                                          
           END-IF                                                       
           .                                                            
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * WRITE PAGE FILE                                               *         
      *---------------------------------------------------------------*         
       8400-UPDATE-PAGE-FILE.                                           
                                                                        
           MOVE '8400' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           OPEN OUTPUT PCSA180M-FILE                                    
           IF PC180-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
              STRING '** OPEN ERROR OF PCSA180M ' DELIMITED BY SIZE     
                     'PAGE FILE ** '              DELIMITED BY SIZE     
                      INTO WS-ERR-MSG                                   
              STRING 'FILE STATUS = '  DELIMITED BY SIZE                
                      WS-PC180-STATUS  DELIMITED BY SIZE                
                      INTO WS-ERR-MSG2                                  
                                                                        
              PERFORM 8900-DISPLAY-ERROR                                
                 THRU 8900-EXIT                                         
           END-IF                                                       
                                                                        
           MOVE WS-PASS-JOB TO MAIL2-JOB-NAME                           
                               MAIL5-JOB-NAME                           
                               MAIL7-JOB-NAME                           
           WRITE PCSA180M-REC FROM MAILHEAD-1                           
           WRITE PCSA180M-REC FROM MAILHEAD-2                           
           WRITE PCSA180M-REC FROM MAILHEAD-3                           
           WRITE PCSA180M-REC FROM MAILHEAD-3A                          
           WRITE PCSA180M-REC FROM MAILHEAD-3B                          
           WRITE PCSA180M-REC FROM MAILHEAD-3C                          
           WRITE PCSA180M-REC FROM MAILHEAD-4                           
           WRITE PCSA180M-REC FROM MAILHEAD-5                           
           WRITE PCSA180M-REC FROM MAILHEAD-6                           
           WRITE PCSA180M-REC FROM MAILHEAD-6A                          
           WRITE PCSA180M-REC FROM MAILHEAD-6B                          
           WRITE PCSA180M-REC FROM MAILHEAD-6C                          
           WRITE PCSA180M-REC FROM MAILHEAD-7                           
           WRITE PCSA180M-REC FROM MAILHEAD-8                           
                                                                        
           MOVE SPACES TO MAIL9-MSG                                     
           STRING WS-PASS-JOB DELIMITED BY SIZE,                        
                  ' JOB ABEND. WAUSAU FILE EMPTY ' DELIMITED BY SIZE    
                  INTO MAIL9-MSG                                        
           WRITE PCSA180M-REC FROM MAILHEAD-9                           
           .                                                            
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * CLOSE CASH DRAWER                                             *         
      *---------------------------------------------------------------*         
       8500-CLOSE-CASH-BATCH.                                           
                                                                        
           MOVE '8500' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_CSH_DRWR_CNTL                                   
                SET CODE_CSH_DRWR_STAT = 'C'                            
                   ,DATE_LAST_ACTIVITY = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                   ,BALANCED_TS        = CIS.CURRENT$TIMESTAMP()              
                   ,BALANCED_BY        = :CS-BALANCED-BY                
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_CSH_DRWR_CNTL                                           
MFA-TR*         SET CODE_CSH_DRWR_STAT = 'C'                                    
MFA-TR*            ,DATE_LAST_ACTIVITY = CURRENT DATE                           
MFA-TR*            ,BALANCED_TS        = CURRENT TIMESTAMP                      
MFA-TR*            ,BALANCED_BY        = :CS-BALANCED-BY                        
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                   
MFA-TR*         AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE         
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
            ELSE                                                        
              STRING '** CLOSE CASH BATCH IN ' DELIMITED BY SIZE        
                     'CSS_CSH_DRWR_CNTL **  '  DELIMITED BY SIZE        
                      INTO WS-ERR-MSG                                   
              STRING 'CASH_LOCAL_OFFICE = '  DELIMITED BY SIZE          
                      CS-CASH-LOCAL-OFFICE   DELIMITED BY SIZE          
                     'DATE_CASH_REPORT = '   DELIMITED BY SIZE          
                      CS-DATE-CASH-REPORT    DELIMITED BY SIZE          
                     'CASH_DRAWER_ID = '     DELIMITED BY SIZE          
                      WS-BATCH-NO            DELIMITED BY SIZE          
                      INTO WS-ERR-MSG2                                  
                                                                        
              PERFORM 8800-DISPLAY-TABLE-ERROR                          
                 THRU 8800-EXIT                                         
            END-IF                                                      
           .                                                            
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03244*---------------------------------------------------------------*         
A03244* UPDATE CUST-BANK-SEQ-NO IN AR-TRANS-HIST TABLE FOR DRAFT AND  *         
A03244* EPAY ACCOUNTS.                                                *         
A03244*---------------------------------------------------------------*         
A03244 8650-UPDATE-TRANS-HIST.                                          
A03244                                                                  
A03244     MOVE '8650'                  TO WS-ACTIVE-PARAGRAPH.         
A03244                                                                  
A03244     MOVE WS-SUB-S-ACCOUNT-NO     TO WS-ACCOUNT-NO.               
A03244     MOVE WS-ACCOUNT-NO-NUM       TO AR-ACCOUNT-NO.               
A03244     MOVE WS-SUB-TIMESTAMP        TO AR-TRANS-HIST-SEQ-NO.        
A03244                                                                  
A03244     EXEC SQL                                                     
A03244        UPDATE CSS_AR_TRANS_HIST                                  
A03244           SET CUST_BANK_SEQ_NO  = :AR-CUST-BANK-SEQ-NO           
A03244         WHERE ACCOUNT_NO  = :AR-ACCOUNT-NO                       
A03244           AND TRANS_HIST_SEQ_NO =                                
A03244               (SELECT MAX(TRANS_HIST_SEQ_NO)                     
A03244                  FROM CSS_AR_TRANS_HIST                          
A03244                 WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO         
A03244                   AND TRANS_HIST_SEQ_NO > CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )  
A03244                   AND CODE_TRAN_TYPE    = 'P')                   
A03244     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_AR_TRANS_HIST                                          
MFA-TR*          SET CUST_BANK_SEQ_NO  = :AR-CUST-BANK-SEQ-NO                   
MFA-TR*        WHERE ACCOUNT_NO  = :AR-ACCOUNT-NO                               
MFA-TR*          AND TRANS_HIST_SEQ_NO =                                        
MFA-TR*              (SELECT MAX(TRANS_HIST_SEQ_NO)                             
MFA-TR*                 FROM CSS_AR_TRANS_HIST                                  
MFA-TR*                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                 
MFA-TR*                  AND TRANS_HIST_SEQ_NO > :AR-TRANS-HIST-SEQ-NO          
MFA-TR*                  AND CODE_TRAN_TYPE    = 'P')                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03244                                                                  
A03244     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A03244     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A03244        CONTINUE                                                  
A03244     ELSE                                                         
A03244        STRING '** UPDATE OF '        DELIMITED BY SIZE           
A03244               'CSS_AR_TRANS_HIST **' DELIMITED BY SIZE           
A03244               INTO WS-ERR-MSG                                    
A03244        STRING ' ACCOUNT_NO ='        DELIMITED BY SIZE           
A03244               WS-SUB-ACCOUNT-NO      DELIMITED BY SIZE           
A03244               ' TRANS_HIST_SEQ_NO =' DELIMITED BY SIZE           
A03244               AR-TRANS-HIST-SEQ-NO   DELIMITED BY SIZE           
A03244               ' CUST_BANK_SEQ_NO ='  DELIMITED BY SIZE           
A03244               WS-CUST-BANK-SEQ-NO    DELIMITED BY SIZE           
A03244               INTO WS-ERR-MSG2                                   
A03244        PERFORM 8800-DISPLAY-TABLE-ERROR    THRU 8800-EXIT        
A03244     END-IF.                                                      
A03244                                                                  
A03244 8650-EXIT.                                                       
A03244     EXIT.                                                        
A03244*                                                                         
      *----------------------------------------------------------------*        
      *   DISPLAY TABLE ERROR                                          *        
      *----------------------------------------------------------------*        
       8800-DISPLAY-TABLE-ERROR.                                        
      *-------------------------*                                               
           DISPLAY '**********************************************'     
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'     
           DISPLAY  WS-ERR-MSG.                                         
           DISPLAY '**********************************************'     
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
A05203     MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-RETURN-CODE         
           DISPLAY '** SQL STATUS        = ' WS-DISPLAY-RETURN-CODE     
           DISPLAY '**' WS-ERR-MSG2                                     
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY PROGRAM ERROR                                          *        
      *----------------------------------------------------------------*        
       8900-DISPLAY-ERROR.                                              
      *-------------------*                                                     
           DISPLAY '                                          '         
           DISPLAY '******************************************'         
           DISPLAY '**     PCSAC180 PROCESSING ERROR        **'         
           DISPLAY '******************************************'         
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
A05203     MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-RETURN-CODE         
           DISPLAY '** RETURN CODE       = ' WS-DISPLAY-RETURN-CODE     
           DISPLAY '**' WS-ERR-MSG                                      
           DISPLAY '**' WS-ERR-MSG2                                     
           DISPLAY '**       PROCESSING TERMINATED          **'         
           DISPLAY '******************************************'         
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * COMMIT DB2                                                    *         
      *---------------------------------------------------------------*         
                                                                        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC                                                             
           .                                                                    
                                                    
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * CLOSE THE OPEN FILES                                          *         
      *---------------------------------------------------------------*         
       9000-TERMINATE.                                                  
           MOVE '9000' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           CLOSE FCSAC01-FILE                                           
                                                                        
           IF FAC01-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSAC180 PROCESSING ERROR  **'               
              DISPLAY '**    CLOSE ERROR OF FCSAC01 INPUT FILE'         
              DISPLAY '**    FILE STATUS = ' WS-FAC01-STATUS            
           END-IF                                                       
                                                                        
           CLOSE FCSAC03-FILE                                           
                                                                        
           IF FAC03-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSAC180 PROCESSING ERROR  **'               
              DISPLAY '**    CLOSE ERROR OF FCSAC03 INPUT FILE'         
              DISPLAY '**    FILE STATUS = ' WS-FAC03-STATUS            
           END-IF                                                       
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * CALL SCSAC180 TO POST UNDIRECTED PAYMENT                      *         
      *---------------------------------------------------------------*         
       9800-CALL-SCSAC180.                                              
                                                                        
           CALL SCSAC180 USING WS-SUB-PGM-INPUT                         
           .                                                            
       9800-EXIT.                                                       
           EXIT.                                                        
                                                                        
            EXEC SQL                                                            
                INCLUDE CPD09900                                                
            END-EXEC.                                                           
