       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSAC179.                                         
       DATE-WRITTEN.  04/10/03.                                         
       DATE-COMPILED.                                                   
       AUTHOR.        RICK SPIRES                                       
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS       REASON                            **         
      ** 05/20/03   R.SPIRES      INITIALIZE OUTPUT RECORD           **         
      **                                                             **         
      *****************************************************************         
      *                   PCSAC179   NARRATIVE                        *         
      *                                                               *         
      * THIS PROGRAM READS THE EDI 820 FILE FROM THE BANK AND PARSES  *         
      * FOR EACH FIELD THROUGH EACH RECORD TYPE AND BUILDS A FLAT FILE*         
      * WITH THE INDIVIDUAL RECORD TYPES BROKEN OUT.                  *         
      *****************************************************************         
                                                                        
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 3999     PARSING ROUTINES                        
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
           SELECT EDI820I-FILE                                          
             ASSIGN  TO EDI820I                                         
               FILE STATUS IS WS-EDI820I-STATUS.                        
                                                                        
           SELECT EDI820O-FILE                                          
             ASSIGN  TO EDI820O                                         
               FILE STATUS IS WS-EDI820O-STATUS.                        
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       COPY CFDPT33.                                                            
                                                                        
       FD  EDI820I-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  EDI-RECI                         PIC X(80).                  
                                                                        
       FD  EDI820O-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  EDI-RECO                         PIC X(165).                 
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
       01  WS-SWITCHES.                                                 
                                                                        
           05  WS-EDI820I-STATUS            PIC X(02).                  
               88 EDI820I-SUCCESSFUL                   VALUE '00'.      
           05  WS-EDI820O-STATUS            PIC X(02).                  
               88 EDI820O-SUCCESSFUL                   VALUE '00'.      
           05  WS-EDI820-EOF-SW             PIC X(01)  VALUE 'N'.       
               88  END-OF-EDI820-FILE                  VALUE 'Y'.       
               88  PROCESS-EDI820                      VALUE 'N'.       
           05  WS-PROCESS-TYPE-SW           PIC  X(01) VALUE SPACES.    
               88  PROCESS-HEADER                VALUE 'H'.             
               88  PROCESS-DETAIL                VALUE 'D'.             
               88  PROCESS-TRAILER               VALUE 'T'.             
           05  WS-DATA-SW                   PIC  X(01) VALUE SPACES.    
               88  VALID-DATA                    VALUE 'D'.             
               88  NO-DATA                       VALUE 'N'.             
           05  WS-PROCESS-SW                 PIC  X(01) VALUE 'S'.      
               88  SLASH-FND                     VALUE 'A'.             
               88  START-SRCH                    VALUE 'S'.             
           05  WS-FILE-SW                    PIC  X(01) VALUE 'F'.      
               88  FIRST-TRY                     VALUE 'F'.             
               88  SUBSEQUENT-ATTEMPT            VALUE 'S'.             
           05  WS-FILE-SW2                   PIC  X(01) VALUE 'F'.      
               88  FIRST-RECORD                  VALUE 'F'.             
               88  SUBSEQUENT-RECORDS            VALUE 'S'.             
           05  WS-RECORD-SW                  PIC  X(01) VALUE 'S'.      
               88  ISA-RECORD                    VALUE 'S'.             
               88  IEA-RECORD                    VALUE 'E'.             
           05  WS-FCSPT33-STATUS             PIC X(02)  VALUE '00'.     
               88  FCSPT33-SUCCESSFUL                   VALUE '00'.     
       01  WS-MISC.                                                     
           05  WS-EDI-LKB-IND                PIC X(03)  VALUE SPACES.   
           05  WS-HOLD-FILE-TYPE             PIC X(03)  VALUE SPACES.   
               88 LOCKBOX                               VALUE 'LKB'.    
               88 EDI                                   VALUE 'EDI'.    
           05  WS-SYSIN-COMP-NO              PIC X(02)  VALUE SPACES.   
           05  WS-DISP-RC                    PIC -ZZZZZZZZ9.9.          
           05  WS-MAX-LINES                  PIC 9(02)  VALUE 56.       
           05  WS-LINE-COUNT                 PIC 9(02)  VALUE 57.       
           05  WS-TEMP-COUNT                 PIC 9(02).                 
           05  WS-PAGE-COUNT                 PIC 9(05)  VALUE 0.        
           05  WS-ERR-MSG                    PIC X(60)  VALUE SPACES.   
           05  WS-REPTNAME                   PIC X(10)  VALUE           
                                                          'PCSA1791'.   
           05  WS-PROCESS-SW                 PIC 9(01)  VALUE 1.        
               88  PROCESS-CSR                          VALUE 1.        
               88  PROCESS-SEB                          VALUE 2.        
           05  WS-COMMON-DATE               PIC X(10).                  
           05  WS-COUNTER                   PIC 9(03)  VALUE ZEROES.    
           05  WS-CODE-DR-CR                PIC X(01)  VALUE 'C'.       
           05  WS-PGRMNAME                  PIC X(10)  VALUE 'PCSAC179'.
           05  WS-PGMNAME                   PIC X(08)  VALUE 'PCSAC179'.
           05  ACTIVE-PARAGRAPH             PIC X(04)  VALUE '0100'.    
           05  WS-NO                        PIC X(01)  VALUE 'N'.       
           05  WS-YES                       PIC X(01)  VALUE 'Y'.       
           05  WS-N                         PIC X(01)  VALUE 'N'.       
           05  WS-Y                         PIC X(01)  VALUE 'Y'.       
           05  WS-1                         PIC 9(01)  VALUE 1.         
           05  WS-AMOUNT                    PIC S9(09)V99               
                                                       VALUE ZERO.      
           05  WS-AMOUNT-NO-DEC REDEFINES WS-AMOUNT                     
                                            PIC 9(11).                  
           05  WS-NO-OF-READS               PIC 9(06) VALUE ZERO.       
           05  WS-NO-OF-WRITES              PIC 9(06) VALUE ZERO.       
           05  WS-EDI-REC.                                              
               10  WS-EDI-REC-ID            PIC X(03).                  
               10  WS-EDI-REST-OF-REC       PIC X(817).                 
                                                                        
           05  WS-PAYEE-NAME                PIC X(60)  VALUE SPACES.    
           05  WS-PAYOR-NAME                PIC X(60)  VALUE SPACES.    
           05  WS-RETURN-DATA               PIC X(80)  VALUE SPACES.    
           05  WS-SAVE-REF-NO               PIC X(30)  VALUE SPACES.    
           05  WS-INVOICE-DATE.                                         
               10  WS-INV-DATE-CC           PIC 9(2).                   
               10  WS-INV-DATE-YY           PIC 9(2).                   
               10  FILLER                   PIC X(01)  VALUE '-'.       
               10  WS-INV-DATE-MM           PIC 9(2).                   
               10  FILLER                   PIC X(01)  VALUE '-'.       
               10  WS-INV-DATE-DD           PIC 9(2).                   
           05  WS-PYMT-DATE.                                            
               10  WS-PYMT-DATE-CCYY        PIC 9(4).                   
               10  FILLER                   PIC X(01)  VALUE '-'.       
               10  WS-PYMT-DATE-MM          PIC 9(2).                   
               10  FILLER                   PIC X(01)  VALUE '-'.       
               10  WS-PYMT-DATE-DD          PIC 9(2).                   
           05  WS-CUR-TS                    PIC  X(26) VALUE SPACES.    
           05  WS-CUR-DATE                  PIC  X(10) VALUE SPACES.    
           05  WS-SAVE-DATE                 PIC  X(10) VALUE SPACES.    
           05  WS-PROCESS-SW                PIC  X(01) VALUE 'Y'.       
               88  FIRST-TIME                    VALUE 'F'.             
               88  COMBINE-PROCESS               VALUE 'C'.             
               88  NEW-BATCH                     VALUE 'N'.             
           05  WS-RMR-SW                    PIC  X(01) VALUE 'N'.       
               88  NO-RMR                        VALUE 'N'.             
               88  FIRST-RMR                     VALUE 'F'.             
               88  SUBSEQUENT-RMR                VALUE 'C'.             
           05  WS-EDI820I-REC               PIC  X(80)  VALUE SPACES.   
           05  WS-EDI820O-REC               PIC  X(165) VALUE SPACES.   
                                                                        
       01  WS-COMP-FIELDS                   USAGE COMP.                 
           05  WS-ONE                       PIC S9(4) VALUE +1.         
           05  WS-TWO                       PIC S9(4) VALUE +2.         
           05  WS-THREE                     PIC S9(4) VALUE +3.         
           05  WS-FOUR                      PIC S9(4) VALUE +4.         
           05  WS-FIVE                      PIC S9(4) VALUE +5.         
           05  WS-SIX                       PIC S9(4) VALUE +6.         
           05  WS-EIGHT                     PIC S9(4) VALUE +8.         
           05  WS-NINE                      PIC S9(4) VALUE +9.         
           05  WS-TEN                       PIC S9(4) VALUE +10.        
           05  WS-TWELVE                    PIC S9(4) VALUE +12.        
           05  WS-FIFTEEN                   PIC S9(4) VALUE +15.        
           05  WS-EIGHTEEN                  PIC S9(4) VALUE +18.        
           05  WS-THIRTY                    PIC S9(4) VALUE +30.        
           05  WS-THIRTY-FIVE               PIC S9(4) VALUE +35.        
           05  WS-SIXTY                     PIC S9(4) VALUE +60.        
           05  WS-EIGHTY                    PIC S9(4) VALUE +80.        
           05  WS-ONE-SIXTY-FIVE            PIC S9(4) VALUE +165.       
           05  WS-ST-LOC                    PIC S9(4) VALUE +1.         
           05  WS-CUR-LOC                   PIC S9(4) VALUE +1.         
           05  WS-OUT-LOC                   PIC S9(4) VALUE +1.         
           05  WS-MAX-LEN                   PIC S9(4) VALUE +1.         
           05  WS-FLD-LEN                   PIC S9(4) VALUE +1.         
           05  WS-JD-SEQUENCE               PIC S9(4) VALUE +1.         
           05  WS-COMMENT-LEN               PIC S9(4) VALUE +1.         
      ***************************************************************           
      *      WORKING STORAGE VARIABLES FOR REPORT HEADER            *           
      ***************************************************************           
       01  WS-HEADER-LINES.                                             
           05  WS-RPT-HEADER-1.                                         
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  P-RPT-TITLE-PGNM          PIC X(08).                 
               10  FILLER                    PIC X(51)  VALUE SPACES.   
               10  P-RPT-COMP-NAME           PIC X(15)  VALUE           
                   ' SCE&G / PSNC  '.                                   
               10  FILLER                    PIC X(40)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                       'RUN-DATE:'.     
               10  P-RPT-RUN-MM              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE '/'.      
               10  P-RPT-RUN-DD              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE '/'.      
               10  P-RPT-RUN-YY              PIC X(02).                 
           05  WS-RPT-HEADER-2.                                         
               10  FILLER                    PIC X(51)  VALUE SPACES.   
               10  FILLER                    PIC X(61)  VALUE           
                                 'ACCOUNTS PROCESSED USING EDI820'.     
               10  FILLER                    PIC X(04)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                      'RUN-TIME:'.      
               10  P-RPT-RUN-HH              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  P-RPT-RUN-MI              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  P-RPT-RUN-SS              PIC X(02).                 
      *                                                                         
           05  WS-RPT-HEADER-3.                                         
               10  FILLER                    PIC X(133) VALUE SPACES.   
                                                                        
           05  WS-RPT-HEADER-4.                                         
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  FILLER                    PIC X(10)  VALUE           
                                                 'ACCOUNT NO'.          
               10  FILLER                    PIC X(20)  VALUE SPACES.   
               10  FILLER                    PIC X(06)  VALUE           
                                                  'AMOUNT'.             
               10  FILLER                    PIC X(40)  VALUE SPACES.   
               10  FILLER                    PIC X(12)  VALUE           
                                                  'COMPANY NAME'.       
               10  FILLER                    PIC X(26)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                        'PAGE    :'.    
               10  P-RPT-PAGE-NO             PIC ZZZZZ.                 
      *                                                                         
           05  WS-RPT-HEADER-5.                                         
               10  FILLER                    PIC X(133) VALUE ALL '='.  
                                                                        
      ***************************************************************           
      *      WORKING STORAGE VARIABLES FOR REPORT DETAILS           *           
      ***************************************************************           
                                                                        
       01  WS-RPT-DETAIL-LINE-1.                                        
           05 FILLER                           PIC X(02) VALUE SPACES.  
           05 WS-RPT-ACCT1                     PIC X(01).               
           05 WS-RPT-DASH1                     PIC X(01) VALUE '-'.     
           05 WS-RPT-ACCT2                     PIC X(04).               
           05 WS-RPT-DASH2                     PIC X(01) VALUE '-'.     
           05 WS-RPT-ACCT3                     PIC X(04).               
           05 WS-RPT-DASH3                     PIC X(01) VALUE '-'.     
           05 WS-RPT-ACCT4                     PIC X(04).               
           05 FILLER                           PIC X(12) VALUE SPACES.  
           05 WS-RPT-EDI-AMT                   PIC ZZZ,ZZZ,ZZ9.99-.     
           05 FILLER                           PIC X(10) VALUE SPACES.  
           05 WS-RPT-COMPANY                   PIC X(60) VALUE SPACES.  
           05 FILLER                           PIC X(15) VALUE SPACES.  
                                                                        
       01  WS-MSG-LINE.                                                 
           05 FILLER                         PIC X(02)  VALUE SPACES.   
           05 WS-RPT-MSG-OVSH                PIC X(130) VALUE SPACES.   
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                         PIC X(48)  VALUE SPACES.   
           05 FILLER                         PIC X(31)  VALUE           
               '****** NO DATA THIS RUN *******'.                       
           05 FILLER                         PIC X(44)  VALUE SPACES.   
                                                                        
       01  WS-FOOTER.                                                   
           05 FILLER                         PIC X(48)  VALUE SPACES.   
           05 FILLER                         PIC X(25)  VALUE           
               '* * * END OF REPORT * * *'.                             
           05 FILLER                         PIC X(60)  VALUE SPACES.   
                                                                        
       01  WS-SAVE-PRT33                     PIC X(133).                
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      **                                                              **        
      **  0000-MAINLINE.                                              **        
      **       CONTROLS MAIN PATH OF PROGRAM                          **        
      **                                                              **        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT           
                   UNTIL END-OF-EDI820-FILE.                            
                                                                        
           IF FIRST-RECORD                                              
              GO TO 9200-DISPLAY-ERROR                                  
           END-IF.                                                      
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   0100-INITIALIZATION.                                       **        
      **        INITIALIZATION ROUTINE                                **        
      **                                                              **        
      ******************************************************************        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT EDI820I-FILE.                                     
                                                                        
           OPEN OUTPUT EDI820O-FILE,                                    
                       FCSPT33-FILE.                                    
                                                                        
           IF FCSPT33-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-FCSPT33-STATUS         TO WS-DISP-RC              
              MOVE ' ERROR IN OPENING FCSPT33 FILE.'                    
                                             TO WS-ERR-MSG              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF.                                                      
                                                                        
                                                                        
           IF  EDI820I-SUCCESSFUL                                       
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-EDI820I-STATUS           TO WS-DISP-RC            
              MOVE 'EDI820I FILE OPEN ERROR'   TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
           IF  EDI820O-SUCCESSFUL                                       
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-EDI820O-STATUS           TO WS-DISP-RC            
              MOVE 'EDI820O FILE OPEN ERROR'   TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
           ACCEPT WS-EDI-LKB-IND FROM SYSIN.                            
           IF WS-EDI-LKB-IND EQUAL SPACES OR LOW-VALUES                 
               DISPLAY '************** PCSAC179************'            
               DISPLAY '  INVALID FILE TYPE '                           
               DISPLAY '  PROCESSING TERMINATED'                        
               DISPLAY '************** PCSAC179************'            
               PERFORM 9300-DISPLAY-ERROR      THRU 9300-EXIT           
           ELSE                                                         
              MOVE WS-EDI-LKB-IND              TO WS-HOLD-FILE-TYPE     
           END-IF.                                                      
      *                                                                         
           SET FIRST-RECORD                    TO TRUE.                 
           MOVE WS-ONE                         TO WS-ST-LOC.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1000-PROCESS-INPUT.                                        **        
      **        MAIN PROCESS PARAGRAPH                                **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           IF START-SRCH                                                
              PERFORM 7000-READ-EDI820                                  
                 THRU 7000-EXIT                                         
           END-IF.                                                      
                                                                        
           IF END-OF-EDI820-FILE                                        
              GO TO 1000-EXIT
           END-IF.                                          
                                                                        
           PERFORM 1100-PROCESS-EDI820I-RECORD                          
              THRU 1100-EXIT.                                           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1100-PROCESS-EDI820I RECORD                                **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1100-PROCESS-EDI820I-RECORD.                                     
                                                                        
           MOVE '1100'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           COMPUTE WS-MAX-LEN = WS-EIGHTY - WS-ST-LOC + WS-ONE.         
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF FIRST-TRY                                                 
             IF SLASH-FND                                               
               IF WS-FLD-LEN = ZERO                                     
                  MOVE SPACES                 TO WS-EDI820O-REC         
               ELSE                                                     
                  MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                    
                                              TO WS-EDI820O-REC         
               END-IF                                                   
             ELSE                                                       
                IF WS-FLD-LEN > ZERO                                    
                   MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                   
                                              TO WS-EDI820O-REC         
                ELSE                                                    
                   DISPLAY 'CURRENT RECORD = ', EDI-RECI                
                END-IF                                                  
                MOVE WS-ONE                   TO WS-ST-LOC              
                IF IEA-RECORD                                           
                   MOVE WS-ONE                TO WS-OUT-LOC             
                   SET FIRST-TRY              TO TRUE                   
                   SET ISA-RECORD             TO TRUE                   
                   GO TO 1100-EXIT                                      
                ELSE                                                    
                   SET SUBSEQUENT-ATTEMPT     TO TRUE                   
                   COMPUTE WS-OUT-LOC = WS-FLD-LEN + WS-ONE             
                END-IF                                                  
             END-IF                                                     
           ELSE                                                         
              IF WS-FLD-LEN > ZERO                                      
                 MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                     
                             TO WS-EDI820O-REC (WS-OUT-LOC:WS-FLD-LEN)  
                 COMPUTE WS-OUT-LOC = WS-OUT-LOC + WS-FLD-LEN           
              END-IF                                                    
              IF SLASH-FND                                              
                 SET FIRST-TRY                TO TRUE                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF SLASH-FND                                                 
              PERFORM 8000-WRITE-EDI820O                                
                 THRU 8000-EXIT                                         
              IF WS-EDI820O-REC (1:3) EQUAL 'IEA'                       
                 SET IEA-RECORD               TO TRUE                   
              END-IF                                                    
              INITIALIZE WS-EDI820O-REC                                 
           ELSE                                                         
              SET START-SRCH TO TRUE                                    
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   2000-PROCESS-EDI-TABLES                                    **        
      **        INSERT EDI820 DATA INTO EDI TABLES                    **        
      **                                                              **        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *   THIS ROUTINE WILL PARSE THROUGH THE EDI 820 RECORDS LOOKING  *        
      *   FOR ASTERISKS AS A FIELD DELIMITER AND FIELD LENGTH AS A MAX *        
      *   SEARCH LENGTH.                                               *        
      ******************************************************************        
       3000-PARSE-EDI820-REC.                                           
                                                                        
           SET  VALID-DATA         TO TRUE.                             
           SET  START-SRCH         TO TRUE.                             
           MOVE WS-ONE             TO WS-FLD-LEN.                       
           MOVE SPACES             TO WS-RETURN-DATA.                   
           MOVE WS-ST-LOC          TO WS-CUR-LOC.                       
                                                                        
           PERFORM VARYING WS-CUR-LOC FROM WS-CUR-LOC BY WS-ONE UNTIL   
                           WS-FLD-LEN > WS-MAX-LEN                      
                        OR SLASH-FND                                    
              IF WS-EDI-REC (WS-CUR-LOC:1) EQUAL '\'                    
                IF WS-FLD-LEN EQUAL WS-ONE                              
                   SET NO-DATA     TO TRUE                              
                END-IF                                                  
                SET SLASH-FND TO TRUE                                   
      *         COMPUTE WS-FLD-LEN = WS-MAX-LEN + WS-ONE                        
              ELSE                                                      
                MOVE WS-EDI-REC (WS-CUR-LOC:1)                          
                                   TO WS-RETURN-DATA (WS-FLD-LEN:1)     
                ADD WS-ONE           TO WS-FLD-LEN                      
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF SLASH-FND                                                 
              COMPUTE WS-FLD-LEN = (WS-CUR-LOC - WS-ST-LOC) - WS-ONE    
           ELSE                                                         
              COMPUTE WS-FLD-LEN = WS-CUR-LOC - WS-ST-LOC
           END-IF.              
                                                                        
      * SET NEXT STARTING LOCATION                                              
                                                                        
           IF SLASH-FND                                                 
              MOVE WS-CUR-LOC TO WS-ST-LOC                              
           ELSE                                                         
              MOVE WS-ONE     TO WS-ST-LOC
           END-IF.                             
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   7000-READ-EDI820.                                          **        
      **        READ THE EDI 820 PAYMENT FILE                         **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7000-READ-EDI820.                                                
                                                                        
           MOVE '7000'                         TO ACTIVE-PARAGRAPH.     
           ADD WS-ONE                          TO WS-NO-OF-READS.       
                                                                        
           READ EDI820I-FILE                                            
               AT END                                                   
                  SET END-OF-EDI820-FILE       TO TRUE                  
                  GO                           TO 7000-EXIT.            
      *                                                                         
           IF  EDI820I-SUCCESSFUL                                       
               MOVE EDI-RECI                   TO WS-EDI-REC            
           ELSE                                                         
               DISPLAY '************** PCSAC179 ************'           
               DISPLAY 'ERROR IN READING EDI820-FILE'                   
               DISPLAY 'ERROR STATUS ' WS-EDI820I-STATUS                
               DISPLAY '  PROCESSING TERMINATED  '                      
               DISPLAY '************** PCSAC179 ************'           
               SET END-OF-EDI820-FILE TO TRUE                           
           END-IF.                                                      
      *                                                                         
           IF  FIRST-RECORD                                             
               SET SUBSEQUENT-RECORDS          TO TRUE                  
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *   8000-WRITE-EDI820O                                                    
      *                                                               *         
      *   WRITE EDI820O RECORDS.                                      *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8000-WRITE-EDI820O.                                              
      *                                                                         
           MOVE '8000'                       TO ACTIVE-PARAGRAPH.       
      *                                                                         
           MOVE WS-EDI820O-REC               TO EDI-RECO.               
      *                                                                         
           WRITE EDI-RECO.                                              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **        CLOSE THE EDI820-FILE                                 **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE EDI820I-FILE,                                          
                 EDI820O-FILE,                                          
                 FCSPT33-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9100-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9100-DISPLAY-ERROR.                                              
            DISPLAY WS-DISP-RC, ' WS-ACTIVE-RETURN-CODE  '.             
            DISPLAY '******************************************'.       
            DISPLAY '** PROCESSING ERROR                     **'.       
            DISPLAY '** PARAGRAPH = ', ACTIVE-PARAGRAPH.                
            DISPLAY '**  ', WS-ERR-MSG.                                 
            DISPLAY '** SQLCODE = ', WS-DISP-RC.                        
            DISPLAY '** PROCESSING TERMINATED                **'.       
            DISPLAY '******************************************'.       
       9100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9200-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9200-DISPLAY-ERROR.                                              
           DISPLAY '******************************************'.        
           DISPLAY '** PROCESSING ERROR                     **'.        
           DISPLAY '** WACHOVIA INPUT FILE IS EMPTY         **'.        
           DISPLAY '** CALL WACHOVIA AT 1-800-851-8311      **'.        
           DISPLAY '** PROCESSING TERMINATED                **'.        
           DISPLAY '******************************************'.        
                                                                        
           IF LOCKBOX                                                   
              MOVE 02  TO  RETURN-CODE                                  
           ELSE                                                         
              MOVE 12  TO  RETURN-CODE                                  
           END-IF.                                                      
                                                                        
           STOP RUN.                                                    
       9200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9300-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9300-DISPLAY-ERROR.                                              
                                                                        
           MOVE 12  TO  RETURN-CODE.                                    
                                                                        
           STOP RUN.                                                    
       9300-EXIT.                                                       
            EXIT.                                                       
                                                                        
            GOBACK.                                                     
