       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSAC178.                                        
       DATE-WRITTEN.   APRIL 1999.                                      
           DATE-COMPILED.                                               
      ***************************************************************** PCS00050
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** PCS00060
      **                     PRICE WATERHOUSE                        ** PCS00070
      **                1410 NORTH WESTSHORE BLVD                    ** PCS00080
      **                   TAMPA, FLORIDA  33607                     ** PCS00090
      **                      (813) 287-9200                         ** PCS00100
      **                                                             ** PCS00110
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________  ____________________________________  **         
      **  04/05/99  SEK        ORIGINALLY CODED.                     **         
T21229**  12/27/99  SFH        MODIFIED PARA 1000 TO CHECK FOR THE   **         
      **                       SECOND FINAL BILL NOTICE.  ALSO FIXED **         
      **                       INCORRECT ABEND PROCESSING.  ALSO     **         
      **                       FIXED PARA 2100 SO THAT IT WOULD NOT  **         
      **                       ABEND WHEN THE ACCOUNT WAS NOT FOUND  **         
      **                       ON CSS_AR_CNTL AND FIXED INCORRECT    **         
      **                       LOGIC IN PARA 2200. ALSO ADDED        **         
      **                       BANKRUPTCY LOGIC.                     **         
T35434**  06/07/07  SP94986    REPLACED MODEL_SQL TO SET STATEMENTS, **         
      **                       ADDED WITH UR CHANGES TO CURSOR AND   **         
      **                       FOR SINGLETON SELECT STATS.           **         
C30169**  07/08/08  CVNS       REPLACE FIRST_FINAL_DT,SECOND_FINAL_DT**         
      **            CHENNAI    WITH FW_ACTION_DT WHICH WILL BE       **         
      **                       RETRIEVED FROM CSS_FIN_WO_ACTION TABLE**         
      *****************************************************************         
       REMARKS.                                                         
                   THIS COMPONENT WILL RUN THREE TIMES EACH DAY.  IT    
               CREATES A PAID TRANSACTION WHEN AN ACCOUNT HAS CLEARED   
T21229         ITS BALANCE AFTER RECEIVING AN RONP AT THE FIRST FINAL   
T21229         BILL NOTICE OR THE SECOND FINAL BILL NOTICE.             
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC178'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                             PIC X(40)               
           VALUE 'WORKING STORAGE FOR PCSAC178 STARTS HERE'.            
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
       01  WS-MISC-FIELDS.                                              
           05  WS-MORE-CHARGE-OFFS         PIC X(01) VALUE 'Y'.         
               88  MORE-CHARGE-OFFS                  VALUE 'Y'.         
               88  NO-MORE-CHARGE-OFFS               VALUE 'N'.         
           05  WS-LAST-RUN-DATE            PIC X(26).                   
           05  WS-NEW-RUN-DATE             PIC X(26).                   
           05  WS-CURRENT-TIMESTAMP        PIC X(26).                   
           05  WS-PAID                     PIC X(04)                    
                                           VALUE 'PAID'.                
T21229     05  PROGRAM-NAME                PIC X(08) VALUE 'PCSAC178'.  
T21229     05  RS-RETURN-CODE              PIC S9(09) COMP VALUE +0.    
T21229     05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FINAL-WO-EXISTS          PIC X(01) VALUE 'N'.         
               88  FINAL-WO-EXISTS                   VALUE 'Y'.         
               88  FINAL-WO-NOT-EXISTS               VALUE 'N'.         
           05  WS-AR-CNTL-FOUND            PIC X(01) VALUE 'N'.         
               88  AR-CNTL-FOUND                     VALUE 'Y'.         
               88  AR-CNTL-NOT-FOUND                 VALUE 'N'.         
T21229*    05  WS-PROGRAM-ABEND            PIC X(01) VALUE 'N'.                 
T21229*        88  PROGRAM-ABENDED                   VALUE 'Y'.                 
T21229*        88  PROGRAM-NOT-ABENDED               VALUE 'N'.                 
T21229*                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  WS-AMT-TRANS-NULL-IND       PIC S9(04) COMP.             
           05  WS-DAY-00-NULL              PIC S9(04) COMP.             
           05  WS-DAY-30-NULL              PIC S9(04) COMP.             
           05  WS-DAY-60-NULL              PIC S9(04) COMP.             
           05  WS-DAY-90-NULL              PIC S9(04) COMP.             
           05  WS-TRAN-BAL-NULL            PIC S9(04) COMP.             
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
       COPY CWS00303.                                                           
T21229 COPY CWS00010.                                                           
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                   PIC X(01)      VALUE 'N'.         
           05  WS-Y                   PIC X(01)      VALUE 'Y'.         
           05  WS-PGRMNAME            PIC X(08)      VALUE 'PCSAC178'.  
      *                                                                         
      *****************************************************************         
      **------------> DB2 TABLES INCLUDED IN PROGRAM <---------------**         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      * DCLGEN FOR CSS_JOB_PARM TABLE                                           
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      * DCLGEN FOR CSS_AR_CNTRL TABLE                                           
           EXEC SQL                                                             
             INCLUDE TBARCNTL                                                   
           END-EXEC.                                                            
      *                                                                         
      * DCLGEN FOR CSS_AR_TRANS_HIST TABLE                                      
           EXEC SQL                                                             
             INCLUDE TBARHIST                                                   
           END-EXEC.                                                            
      *                                                                         
      * DCLGEN FOR CSS_ACCOUNT TABLE                                            
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      * DCLGEN FOR CSS_FINAL_WRITE_OFF TABLE                                    
           EXEC SQL                                                             
             INCLUDE TBFINLWO                                                   
           END-EXEC.                                                            
      *                                                                         
      * DCLGEN FOR CSS_CHARGE_OFF TABLE                                         
           EXEC SQL                                                             
             INCLUDE TBCHGOFF                                                   
           END-EXEC.                                                            
      *                                                                         
      * DCLGEN FOR CSS_MKT_TRAN_INFO                                            
           EXEC SQL                                                             
             INCLUDE TBMRKINF                                                   
           END-EXEC.                                                            
      *                                                                         
C30169******************************************************************        
C30169* KD - CSS_FIN_WO_ACTION                                         *        
C30169******************************************************************        
C30169*                                                                         
C30169     EXEC SQL                                                             
C30169        INCLUDE TBFWACTN                                                  
C30169     END-EXEC.                                                            
C30169*                                                                         
      ****************************************************************          
      ****** +++++++++++++++++ DECLARATIVES +++++++++++++++++++ ******          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
                DECLARE CSS_PAID_CRSR CURSOR FOR                        
                SELECT                                                  
                      AT.ACCOUNT_NO,                                    
                      AT.CODE_STATUS_REASON,                            
                      AT.COMPANY_NO,                                    
                      AT.BANKRUPTCY_IND,                                
                      AT.BNKRPT_CASE_NO,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           AR.TRANS_HIST_SEQ_NO), 121), ' ', '-'), ':', '.')                   
                FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
                WHERE AT.ACCOUNT_NO = AR.ACCOUNT_NO                     
                AND   AT.CODE_ACCT_STAT = 'B'                           
                AND AR.TRANS_HIST_SEQ_NO > CIS.CHAR2TIMESTAMP(
                                                      :WS-LAST-RUN-DATE
              )            
                AND AR.TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                       :WS-NEW-RUN-DATE
              )            
                AND AR.CODE_TRAN_TYPE NOT IN ('W', 'C')                 
                GROUP BY AT.ACCOUNT_NO,                                 
                         AT.CODE_STATUS_REASON,                         
                         AT.COMPANY_NO,                                 
                         AT.BANKRUPTCY_IND,                             
                         AT.BNKRPT_CASE_NO                              
T35434                   FOR READ ONLY                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CSS_PAID_CRSR CURSOR FOR                                
MFA-TR*         SELECT                                                          
MFA-TR*               AT.ACCOUNT_NO,                                            
MFA-TR*               AT.CODE_STATUS_REASON,                                    
MFA-TR*               AT.COMPANY_NO,                                            
MFA-TR*               AT.BANKRUPTCY_IND,                                        
MFA-TR*               AT.BNKRPT_CASE_NO,                                        
MFA-TR*               MAX(AR.TRANS_HIST_SEQ_NO)                                 
MFA-TR*         FROM  CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_AR_TRANS_HIST AR                                      
MFA-TR*         WHERE AT.ACCOUNT_NO = AR.ACCOUNT_NO                             
MFA-TR*         AND   AT.CODE_ACCT_STAT = 'B'                                   
MFA-TR*         AND AR.TRANS_HIST_SEQ_NO > :WS-LAST-RUN-DATE                    
MFA-TR*         AND AR.TRANS_HIST_SEQ_NO <= :WS-NEW-RUN-DATE                    
MFA-TR*         AND AR.CODE_TRAN_TYPE NOT IN ('W', 'C')                         
MFA-TR*         GROUP BY AT.ACCOUNT_NO,                                         
MFA-TR*                  AT.CODE_STATUS_REASON,                                 
MFA-TR*                  AT.COMPANY_NO,                                         
MFA-TR*                  AT.BANKRUPTCY_IND,                                     
MFA-TR*                  AT.BNKRPT_CASE_NO                                      
MFA-TR*                  FOR FETCH ONLY WITH UR                                 
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSAC178 ENDS HERE  '.            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
      *                                                                         
           PERFORM 7100-OPEN-PAID-CRSR         THRU 7100-EXIT.          
           SET MORE-CHARGE-OFFS TO TRUE.                                
           PERFORM 1000-PROCESS-ACCOUNTS       THRU 1000-EXIT           
               UNTIL NO-MORE-CHARGE-OFFS.                               
           PERFORM 7300-CLOSE-PAID-CRSR        THRU 7300-EXIT.          
      *                                                                         
           MOVE WS-NEW-RUN-DATE TO G6-PARM-DATA.                        
           PERFORM 4400-UPDATE-JOB-PARM THRU 4400-EXIT.                 
      *                                                                         
T21229     STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 0100-INITIALIZATION:  STANDARD INITIALIZATION ROUTINE      **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 4200-GET-JOB-PARM-DATE THRU 4200-EXIT.               
           MOVE G6-PARM-DATA(1:26)        TO WS-LAST-RUN-DATE.          
      *                                                                         
           PERFORM 4300-GET-CURRENT-TS    THRU 4300-EXIT.               
           MOVE WS-CURRENT-TIMESTAMP      TO WS-NEW-RUN-DATE.           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 1000-PROCESS-ACCOUNTS ... MAIN PROCESS ................... **          
      ****************************************************************          
       1000-PROCESS-ACCOUNTS.                                           
      *                                                                         
           PERFORM 7200-FETCH-PAID-ACCOUNTS     THRU 7200-EXIT.         
      *                                                                         
           IF MORE-CHARGE-OFFS                                          
T21229        IF AT-BANKRUPTCY-IND = 'B'                                
T21229           PERFORM 2400-PROCESS-PAID-TRAN THRU 2400-EXIT          
T21229        ELSE                                                      
                 PERFORM 2100-GET-AR-BALANCE       THRU 2100-EXIT       
                 PERFORM 2200-GET-WO-BALANCE       THRU 2200-EXIT       
                 IF (AC-AMT-AR-DAY-00 + AC-AMT-AR-DAY-30 +              
                    AC-AMT-AR-DAY-60 + AC-AMT-AR-DAY-90 +               
                    AC-AMT-TRAN-BALANCE + CO-AMT-TRANS) <= 0            
                    IF AT-CODE-STATUS-REASON = 'C'                      
                       PERFORM 2400-PROCESS-PAID-TRAN                   
                                                   THRU 2400-EXIT       
                    ELSE                                                
T21229                 PERFORM 2300-GET-RONP-FIRST THRU 2300-EXIT       
                       IF FINAL-WO-EXISTS                               
T21229                    CONTINUE                                      
T21229                 ELSE                                             
T21229                    PERFORM 2305-GET-RONP-SECOND THRU 2305-EXIT   
T21229                 END-IF                                           
C30169                 IF FINAL-WO-EXISTS                               
C30169                    IF KD-FW-ACTION-DT < WS-NEW-RUN-DATE          
T21229                       PERFORM 2400-PROCESS-PAID-TRAN             
T21229                                                    THRU 2400-EXIT
T21229                    END-IF                                        
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 2100-GET-AR-BALANCE                                        **          
      ****************************************************************          
       2100-GET-AR-BALANCE.                                             
           MOVE '2100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
T21229     INITIALIZE WS-DAY-00-NULL                                    
T21229                WS-DAY-30-NULL                                    
T21229                WS-DAY-60-NULL                                    
T21229                WS-DAY-90-NULL                                    
T21229                WS-TRAN-BAL-NULL.                                 
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(AMT_AR_DAY_00),                                
                     SUM(AMT_AR_DAY_30),                                
                     SUM(AMT_AR_DAY_60),                                
                     SUM(AMT_AR_DAY_90),                                
                     SUM(AMT_TRAN_BALANCE)                              
              INTO   :AC-AMT-AR-DAY-00 :WS-DAY-00-NULL,              
                     :AC-AMT-AR-DAY-30 :WS-DAY-30-NULL,              
                     :AC-AMT-AR-DAY-60 :WS-DAY-60-NULL,              
                     :AC-AMT-AR-DAY-90 :WS-DAY-90-NULL,              
                     :AC-AMT-TRAN-BALANCE :WS-TRAN-BAL-NULL             
              FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                          
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_AR_DAY_00),                                        
MFA-TR*              SUM(AMT_AR_DAY_30),                                        
MFA-TR*              SUM(AMT_AR_DAY_60),                                        
MFA-TR*              SUM(AMT_AR_DAY_90),                                        
MFA-TR*              SUM(AMT_TRAN_BALANCE)                                      
MFA-TR*       INTO   :AC-AMT-AR-DAY-00    :WS-DAY-00-NULL,                      
MFA-TR*              :AC-AMT-AR-DAY-30    :WS-DAY-30-NULL,                      
MFA-TR*              :AC-AMT-AR-DAY-60    :WS-DAY-60-NULL,                      
MFA-TR*              :AC-AMT-AR-DAY-90    :WS-DAY-90-NULL,                      
MFA-TR*              :AC-AMT-TRAN-BALANCE :WS-TRAN-BAL-NULL                     
MFA-TR*       FROM   CSS_AR_CNTL                                                
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T21229         CONTINUE                                                 
           ELSE                                                         
T21229         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T21229         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T21229         MOVE '2100'                TO ACTIVE-PARAGRAPH           
T21229         MOVE 'SELECT'              TO ABEND-FUNCTION             
T21229         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T21229                                       ABEND-TABLES               
T21229         MOVE 'CSS_AR_CNTL'         TO TABLE-1                    
T21229         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T21229         MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T21229         DISPLAY '*** 2100-GET-AR-BALANCE ***'                    
T21229         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-DAY-00-NULL   NOT EQUAL 0 AND                          
              WS-DAY-30-NULL   NOT EQUAL 0 AND                          
              WS-DAY-60-NULL   NOT EQUAL 0 AND                          
              WS-DAY-90-NULL   NOT EQUAL 0 AND                          
              WS-TRAN-BAL-NULL NOT EQUAL 0                              
              SET AR-CNTL-NOT-FOUND TO TRUE                             
           ELSE                                                         
              SET AR-CNTL-FOUND TO TRUE                                 
           END-IF.                                                      
      *                                                                         
           IF AR-CNTL-FOUND                                             
               IF WS-DAY-00-NULL NOT EQUAL 0                            
                  MOVE 0 TO AC-AMT-AR-DAY-00                            
               END-IF                                                   
               IF WS-DAY-30-NULL NOT EQUAL 0                            
                  MOVE 0 TO AC-AMT-AR-DAY-30                            
               END-IF                                                   
               IF WS-DAY-60-NULL NOT EQUAL 0                            
                  MOVE 0 TO AC-AMT-AR-DAY-60                            
               END-IF                                                   
               IF WS-DAY-90-NULL NOT EQUAL 0                            
                  MOVE 0 TO AC-AMT-AR-DAY-90                            
               END-IF                                                   
               IF WS-TRAN-BAL-NULL NOT EQUAL 0                          
                  MOVE 0 TO AC-AMT-TRAN-BALANCE                         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 2200-GET-WO-BALANCE                                        **          
      ****************************************************************          
       2200-GET-WO-BALANCE.                                             
           MOVE '2200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
T21229     INITIALIZE WS-AMT-TRANS-NULL-IND                             
T21229                CO-AMT-TRANS.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(AMT_TRANS)                                     
              INTO   :CO-AMT-TRANS :WS-AMT-TRANS-NULL-IND                
              FROM   CSS_CHRG_OFF WITH(READUNCOMMITTED)                         
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_TRANS)                                             
MFA-TR*       INTO   :CO-AMT-TRANS:WS-AMT-TRANS-NULL-IND                        
MFA-TR*       FROM   CSS_CHRG_OFF                                               
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21229     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-AMT-TRANS-NULL-IND NOT EQUAL ZERO                  
                   MOVE 0 TO CO-AMT-TRANS                               
               END-IF                                                   
T21229     ELSE                                                         
T21229         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T21229         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T21229         MOVE '2200'                TO ACTIVE-PARAGRAPH           
T21229         MOVE 'SELECT'              TO ABEND-FUNCTION             
T21229         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T21229                                       ABEND-TABLES               
T21229         MOVE 'CSS_CHRG_OFF'        TO TABLE-1                    
T21229         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T21229         MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               DISPLAY '*** 2200-GET-WO-BALANCE ***'                    
T21229         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
T21229     END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 2300-GET-RONP-FIRST                                        **          
      ****************************************************************          
       2300-GET-RONP-FIRST.                                             
           MOVE '2300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
C30169        SELECT FW_ACTION_DT                                       
C30169        INTO   :KD-FW-ACTION-DT                                   
C30169        FROM   CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                    
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
C30169        AND    FW_ACTION_TYPE_CD = '90308'                        
C30169        AND    FW_ACTION_AM > 0                                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FW_ACTION_DT                                               
MFA-TR*       INTO   :KD-FW-ACTION-DT                                           
MFA-TR*       FROM   CSS_FIN_WO_ACTION                                          
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       AND    FW_ACTION_TYPE_CD = '90308'                                
MFA-TR*       AND    FW_ACTION_AM > 0                                           
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 SET FINAL-WO-EXISTS TO TRUE                            
              WHEN NOT-FOUND                                            
                 SET FINAL-WO-NOT-EXISTS TO TRUE                        
              WHEN OTHER                                                
T21229           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
T21229           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
T21229           MOVE '2300'                TO ACTIVE-PARAGRAPH         
T21229           MOVE 'SELECT'              TO ABEND-FUNCTION           
T21229           MOVE SPACES                TO ABEND-SQL-PREDICATES     
T21229                                         ABEND-TABLES             
T21229           MOVE 'CSS_FIN_WO_ACTION'   TO TABLE-1                  
T21229           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
T21229           MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
T21229           DISPLAY '*** 2300-GET-RONP-FIRST ***'                  
T21229           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T21229****************************************************************          
T21229** 2305-GET-RONP-SECOND                                       **          
T21229****************************************************************          
T21229 2305-GET-RONP-SECOND.                                            
T21229     MOVE '2305' TO WS-ACTIVE-PARAGRAPH.                          
T21229*                                                                         
T21229     EXEC SQL                                                     
C30169        SELECT FW_ACTION_DT                                       
C30169        INTO   :KD-FW-ACTION-DT                                   
T21229        FROM   CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                    
T21229        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
C30169        AND    FW_ACTION_TYPE_CD IN ('90309','90304','90301')     
C30169        AND    FW_ACTION_AM > 0                                   
T35434                                                           
T21229     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FW_ACTION_DT                                               
MFA-TR*       INTO   :KD-FW-ACTION-DT                                           
MFA-TR*       FROM   CSS_FIN_WO_ACTION                                          
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       AND    FW_ACTION_TYPE_CD IN ('90309','90304','90301')             
MFA-TR*       AND    FW_ACTION_AM > 0                                           
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21229*                                                                         
T21229     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21229     EVALUATE WS-ACTIVE-RETURN-CODE                               
T21229        WHEN SUCCESSFUL-CALL                                      
T21229           SET FINAL-WO-EXISTS TO TRUE                            
T21229        WHEN NOT-FOUND                                            
T21229           SET FINAL-WO-NOT-EXISTS TO TRUE                        
T21229        WHEN OTHER                                                
T21229           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
T21229           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
T21229           MOVE '2305'                TO ACTIVE-PARAGRAPH         
T21229           MOVE 'SELECT'              TO ABEND-FUNCTION           
T21229           MOVE SPACES                TO ABEND-SQL-PREDICATES     
T21229                                         ABEND-TABLES             
T21229           MOVE 'CSS_FIN_WO_ACTION'   TO TABLE-1                  
T21229           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
T21229           MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
T21229           DISPLAY '*** 2305-GET-RONP-SECOND ***'                 
T21229           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
T21229     END-EVALUATE.                                                
T21229*                                                                         
T21229 2305-EXIT.                                                       
T21229     EXIT.                                                        
T21229*                                                                         
      ****************************************************************          
      ** 2400-PROCESS-PAID-TRAN                                     **          
      ****************************************************************          
       2400-PROCESS-PAID-TRAN.                                          
           MOVE '2400'               TO WS-ACTIVE-PARAGRAPH.            
      *                                                                         
           MOVE WS-PAID              TO TL-TRANS-ID-CD.                 
           MOVE AT-ACCOUNT-NO        TO TL-ACCOUNT-NO.                  
           MOVE AT-COMPANY-NO        TO TL-COMPANY-NO.                  
           MOVE AR-TRANS-HIST-SEQ-NO TO TL-TRANS-OCCURS-TS.             
           MOVE ZERO                 TO TL-TRANS-DATA-1-LEN.            
           MOVE ZERO                 TO TL-TRANS-DATA-2-LEN.            
           MOVE ZERO                 TO TL-TRANS-DATA-3-LEN.            
           MOVE ZERO                 TO TL-TRANS-DATA-4-LEN.            
           PERFORM 2500-INSERT-PAID-TRAN THRU 2500-EXIT.                
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 2500-INSERT-PAID-TRAN                                      **          
      ****************************************************************          
       2500-INSERT-PAID-TRAN.                                           
           MOVE '2500' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_MKT_TRAN_INFO                             
              VALUES (:TL-TRANS-ID-CD,                                  
                     :TL-ACCOUNT-NO,                                    
                     :TL-COMPANY-NO,                                    
                     CIS.CURRENT$TIMESTAMP(),                                 
                     CIS.CHAR2TIMESTAMP(:TL-TRANS-OCCURS-TS),                   
                     :TL-TRANS-DATA-1,                                  
                     :TL-TRANS-DATA-2,                                  
                     :TL-TRANS-DATA-3,                                  
                     :TL-TRANS-DATA-4)                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MKT_TRAN_INFO                                     
MFA-TR*       VALUES (:TL-TRANS-ID-CD,                                          
MFA-TR*              :TL-ACCOUNT-NO,                                            
MFA-TR*              :TL-COMPANY-NO,                                            
MFA-TR*              CURRENT TIMESTAMP,                                         
MFA-TR*              :TL-TRANS-OCCURS-TS,                                       
MFA-TR*              :TL-TRANS-DATA-1,                                          
MFA-TR*              :TL-TRANS-DATA-2,                                          
MFA-TR*              :TL-TRANS-DATA-3,                                          
MFA-TR*              :TL-TRANS-DATA-4)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
T21229         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T21229         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T21229         MOVE '2500'                TO ACTIVE-PARAGRAPH           
T21229         MOVE 'INSERT'              TO ABEND-FUNCTION             
T21229         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T21229                                       ABEND-TABLES               
T21229         MOVE 'CSS_MKT_TRAN_INFO'   TO TABLE-1                    
T21229         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T21229         MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               DISPLAY '*** 2500-INSERT-PAID-TRAN ***'                  
T21229         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 4200-GET-JOB-PARM-DATE                                     **          
      ****************************************************************          
       4200-GET-JOB-PARM-DATE.                                          
           MOVE '4200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
              INTO   :G6-PARM-DATA                                      
              FROM   CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  CMND_CODE = 'PARM'                                 
              AND    COMPANY_NO = '01'                                  
              AND    PROGRAM_NAME = 'PCSAC178'                          
              AND    SEQ_NO = 1                                         
              AND    STATUS = 'A'                                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*       INTO   :G6-PARM-DATA                                              
MFA-TR*       FROM   CSS_JOB_PARM                                               
MFA-TR*       WHERE  CMND_CODE = 'PARM'                                         
MFA-TR*       AND    COMPANY_NO = '01'                                          
MFA-TR*       AND    PROGRAM_NAME = 'PCSAC178'                                  
MFA-TR*       AND    SEQ_NO = 1                                                 
MFA-TR*       AND    STATUS = 'A'                                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
T21229         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T21229         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T21229         MOVE '4200'                TO ACTIVE-PARAGRAPH           
T21229         MOVE 'SELECT'              TO ABEND-FUNCTION             
T21229         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T21229                                       ABEND-TABLES               
T21229         MOVE 'CSS_JOB_PARM'        TO TABLE-1                    
T21229         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T21229         MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               DISPLAY '*** 4200-GET-JOB-PARM-DATE ***'                 
T21229         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       4200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 4300-GET-CURRENT-TS                                        **          
      ****************************************************************          
       4300-GET-CURRENT-TS.                                             
           MOVE '4300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
T21229         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T21229         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T21229         MOVE '4300'                TO ACTIVE-PARAGRAPH           
T21229         MOVE 'SET'                 TO ABEND-FUNCTION             
T21229         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T21229                                       ABEND-TABLES               
T35434         MOVE 'SET'                 TO TABLE-1                    
T21229         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T21229         MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               DISPLAY '*** 4300-GET-CURRENT-TS ***'                    
T21229         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       4300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 4400-UPDATE-JOB-PARM                                       **          
      ****************************************************************          
       4400-UPDATE-JOB-PARM.                                            
           MOVE '4400' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
              SET    PARM_DATA = :G6-PARM-DATA                          
              WHERE  CMND_CODE = 'PARM'                                 
              AND    COMPANY_NO = '01'                                  
              AND    PROGRAM_NAME = 'PCSAC178'                          
              AND    SEQ_NO = 1                                         
              AND    STATUS = 'A'                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
T21229         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T21229         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T21229         MOVE '4400'                TO ACTIVE-PARAGRAPH           
T21229         MOVE 'UPDATE'              TO ABEND-FUNCTION             
T21229         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T21229                                       ABEND-TABLES               
T21229         MOVE 'CSS_JOB_PARM'        TO TABLE-1                    
T21229         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T21229         MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               DISPLAY '*** 4400-UPDATE-JOB-PARM ***'                   
T21229         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       4400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY CPD00040.                                                           
      *                                                                         
      ****************************************************************          
      ** 7100-OPEN-PAID-CRSR                                        **          
      ****************************************************************          
       7100-OPEN-PAID-CRSR.                                             
           MOVE '7100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                OPEN CSS_PAID_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
T21229         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T21229         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T21229         MOVE '7100'                TO ACTIVE-PARAGRAPH           
T21229         MOVE 'OPEN'                TO ABEND-FUNCTION             
T21229         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T21229                                       ABEND-TABLES               
T21229         MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
T21229         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T21229         MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T21229         MOVE 'WS-LAST-RUN-DATE'    TO TABLE-ELEMENT-2            
T21229         MOVE WS-LAST-RUN-DATE      TO HOSTVAR-ELEMENT-2          
T21229         MOVE 'WS-NEW-RUN-DATE'     TO TABLE-ELEMENT-3            
T21229         MOVE WS-NEW-RUN-DATE       TO HOSTVAR-ELEMENT-3          
T21229         MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-2                    
               DISPLAY '*** 7100-OPEN-PAID-CRSR ***'                    
T21229         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7200-FETCH-PAID-ACCOUNTS:  FETCH DATA FROM CSS_PAID_CRSR.   **         
      *****************************************************************         
       7200-FETCH-PAID-ACCOUNTS.                                        
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                FETCH CSS_PAID_CRSR                                     
                INTO                                                    
                      :AT-ACCOUNT-NO,                                   
                      :AT-CODE-STATUS-REASON,                           
                      :AT-COMPANY-NO,                                   
                      :AT-BANKRUPTCY-IND,                               
                      :AT-BNKRPT-CASE-NO,                               
                      :AR-TRANS-HIST-SEQ-NO                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   SET NO-MORE-CHARGE-OFFS TO TRUE                      
               ELSE                                                     
T21229             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
T21229             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
T21229             MOVE '7200'                TO ACTIVE-PARAGRAPH       
T21229             MOVE 'FETCH'               TO ABEND-FUNCTION         
T21229             MOVE SPACES                TO ABEND-SQL-PREDICATES   
T21229                                           ABEND-TABLES           
T21229             MOVE 'CSS_ACCOUNT'         TO TABLE-1                
T21229             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
T21229             MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
T21229             MOVE 'WS-LAST-RUN-DATE'    TO TABLE-ELEMENT-2        
T21229             MOVE WS-LAST-RUN-DATE      TO HOSTVAR-ELEMENT-2      
T21229             MOVE 'WS-NEW-RUN-DATE'     TO TABLE-ELEMENT-3        
T21229             MOVE WS-NEW-RUN-DATE       TO HOSTVAR-ELEMENT-3      
T21229             MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-2                
                   DISPLAY '*** 7200-FETCH-PAID-AMOUNTS ***'            
T21229             PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7300-CLOSE-PAID-CRSR                                        **         
      *****************************************************************         
       7300-CLOSE-PAID-CRSR.                                            
           MOVE '7300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE CSS_PAID_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               CONTINUE                                                 
           ELSE                                                         
T21229         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T21229         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T21229         MOVE '7300'                TO ACTIVE-PARAGRAPH           
T21229         MOVE 'CLOSE'               TO ABEND-FUNCTION             
T21229         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T21229                                       ABEND-TABLES               
T21229         MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
T21229         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T21229         MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T21229         MOVE 'WS-LAST-RUN-DATE'    TO TABLE-ELEMENT-2            
T21229         MOVE WS-LAST-RUN-DATE      TO HOSTVAR-ELEMENT-2          
T21229         MOVE 'WS-NEW-RUN-DATE'     TO TABLE-ELEMENT-3            
T21229         MOVE WS-NEW-RUN-DATE       TO HOSTVAR-ELEMENT-3          
T21229         MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-2                    
               DISPLAY '*** 7300-CLOSE-PAID-CRSR ***'                   
T21229         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 9000-TERMINATE                                             **          
      ****************************************************************          
       9000-TERMINATE.                                                  
T21229*                                                                         
T21229*    IF PROGRAM-ABENDED                                                   
T21229*       PERFORM 4160-ROLLBACK-TRANSACTION THRU 4160-EXIT                  
T21229*    ELSE                                                                 
T21229*       PERFORM 4130-COMMIT-TRANSACTION   THRU 4130-EXIT                  
T21229*    END-IF.                                                              
T21229*                                                                         
T21229*    STOP RUN.                                                            
T21229*                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
T21229*                                                                         
T21229******************************************************************        
T21229*  9700-PROCESS-ABEND.                                           *        
T21229******************************************************************        
T21229     EXEC SQL                                                             
T21229       INCLUDE CPD0023B                                                   
T21229     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
