       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSAC177.                                            
       AUTHOR. BASKAR VANNI.                                            
       DATE-WRITTEN. MARCH 2003.                                        
                                                                        
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      ********            CUSTOMER INFORMATION SYSTEMS        *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **     DATE       INITIALS   REASON                            **         
      **   ==========   =========  ================================  **         
C28301**   03/03/2003   BASKAR     NEW PROGRAM TO PROCESS EDI PAYMENT**         
      **                                                             **         
T30775**   06/01/2004   COVANSYS   CHANGED CUSTOMER NAME TO PAYER    **         
T30775**                CHENNAI    NAME FOR COMPANY DESCRIPTION      **         
      **                                                             **         
PRDFIX**   06/04/2004   BASKAR     FIX PROD ABEND                    **         
FIXPRD**   02/07/2005   BASKAR     FIX PROBLEM-PAYMENTS WERE POSTING **         
      **                           TO WRONG ACCOUNT NOS, CHECKING    **         
      **                           FOR A NEW ACCT NO FORMAT NOW.     **         
A00950**   03/23/2009   BASKAR V   KICKOUT PAYMENTS FOR WHICH THE HDR**         
A00950**                           TOTALS ARE NOT MATCHING WITH DET  **         
A00950**                           TOTALS AND PROCESS THE REMAINING  **         
A00950**                           VALID PAYMENTS                    **         
A01346**   06/16/2009   BASKAR V   REJECT THE ERROR PAYMENT ONLY     **         
A01346**                           INSTEAD OF WHOLE BATCH WHEREVER   **         
A01346**                           IT IS POSSIBLE                    **         
A02388**   08/26/2010   LAT        CONVERT EDI PAYMENT ERROR REPORTING*         
A02388**                           TO BOE.                           **         
ACT061**   05/31/2013   BD09555    CHANGE TABLE SIZE TO 900 A04527    *         
ACT061**                                                             **         
ACT262**   08/19/2016   MS7M727    TO CHANGE FCSAC27 REPORT AS CSV    *         
ACT262**                A5460      FILE                              **         
ACT268*    08/31/2016   BD09555    REMOVE CBL ADV                     *         
ACT268*A05460-ACT268                                                  *         
      *****************************************************************         
             REMARKS.                                                   
      *****************************************************************         
      * THIS PROGRAM WILL CREATE EDI PAYMENT FILE IN BANCTEC FORMAT   *         
      * FROM CSS_EDI_PYMT_HDR AND CSS_EDI_PYMT_DET. THESE PAYMENT     *         
      * ARE SENT TO OUR BANK BY CUSTOMERS THROUGH ELECTRONIC          *         
      * DATA INTERCHAGE 820 FORMAT. OUR BANK WILL SEND ALL DETAILS    *         
      * IN SAME 820 FORMAT TO SCANA. WE WILL RECEIVE THE PAYMENT FILE *         
      * AND LOAD INTO ABOVE TWO TABLES IN DAILY BASIS AND PROCESS     *         
      * RECEIVED PAYMENTS BY THIS PROGRAM.                            *         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSAC01.                                                            
                                                                        
A02388     SELECT FCSAC27-FILE ASSIGN UT-S-FCSAC27                      
A02388        FILE STATUS IS WS-FAC27-STATUS.                           
                                                                        
           SELECT FCSPT331-FILE                                         
              ASSIGN UT-S-FCSPT331.                                     
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
      ******************************************************************        
      **  CFDAC01 - FD FOR BANCTEC SEQUENTIAL INPUT FILE.             **        
      ******************************************************************        
       COPY CFDAC01.                                                            
      ******************************************************************        
      **  FILE LAYOUT FOR BANCTEC CASH REMITTANCE PAYMENTS            **        
      ******************************************************************        
       COPY CSHCBCTC.                                                           
                                                                        
A02388 FD  FCSAC27-FILE                                                 
A02388     BLOCK CONTAINS  0 RECORDS                                    
A02388     RECORDING MODE  IS F                                         
A02388     LABEL RECORDS   ARE STANDARD.                                
ACT262 01  FCSAC27-OUT-REC                 PIC X(262).                  
                                                                        
       FD  FCSPT331-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT331-RECORD.                                               
           05  PRT331-CC                   PIC X(01).                   
           05  PRT331-DATA                 PIC X(132).                  
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC177'.
MSQ017     COPY MFASQLM.
       77  EOJ-CODE                        PIC S9(4) COMP VALUE +0.     
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-STR-LENGTH               PIC S9(4) COMP.              
           05  WS-BATCH-NO                 PIC S9(4) COMP VALUE 0.      
           05  WS-SPACE-CNT                PIC S9(4) COMP VALUE 0.      
           05  WS-SUB                      PIC S9(4) COMP.              
           05  WS-SUB1                     PIC S9(4) COMP.              
           05  WS-SUB2                     PIC S9(4) COMP.              
           05  WS-SEQ-NO                   PIC S9(6) COMP VALUE 0.      
                                                                        
       01  WS-CONSTANTS.                                                
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSAC177'.  
           05  WS-PGMNAME                  PIC X(08) VALUE 'PCSAC177'.  
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-D                        PIC X(01) VALUE 'D'.         
           05  WS-E                        PIC X(01) VALUE 'E'.         
           05  WS-P                        PIC X(01) VALUE 'P'.         
           05  WS-1                        PIC 9(01) VALUE 1.           
           05  WS-2                        PIC 9(01) VALUE 2.           
           05  WS-3                        PIC 9(01) VALUE 3.           
           05  WS-5                        PIC 9(01) VALUE 5.           
           05  WS-01                       PIC X(02) VALUE '01'.        
           05  WS-54                       PIC 9(02) VALUE 54.          
           05  WS-60                       PIC 9(02) VALUE 60.          
           05  WS-TWO                      PIC 9(01) VALUE 2.           
           05  MULTIPLE-ROWS-SELECTED      PIC S9(9) VALUE -811 COMP.   
                                                                        
       01  WS-VARIABLES.                                                
           05  WS-AMT-NUM                  PIC 9(13)V99.                
           05  WS-AMT-CHAR REDEFINES WS-AMT-NUM                         
                                           PIC X(15).                   
           05  WS-ACCOUNT-NUM              PIC 9(13).                   
           05  WS-ACCOUNT-NO               PIC X(13).                   
           05  FILLER REDEFINES WS-ACCOUNT-NO.                          
               10 WS-ACCOUNT-NO-X1         PIC X(01).                   
               10 WS-ACCOUNT-NO-X2         PIC X(04).                   
               10 WS-ACCOUNT-NO-X3         PIC X(04).                   
               10 WS-ACCOUNT-NO-X4         PIC X(04).                   
           05  WS-ERR-MSG                  PIC X(100) VALUE SPACES.     
           05  WS-ERR-MSG2                 PIC X(115) VALUE SPACES.     
           05  WS-EXISTS-FLAG              PIC X(01).                   
A02388     05  WS-ARCHIVE-FLAG             PIC X(01) VALUE 'N'.         
           05  WS-AMOUNT                   PIC 9(10).                   
           05  WS-HDR-AMT                  PIC S9(8)V99.                
           05  WS-ERR-AMT                  PIC S9(8)V99.                
           05  WS-LENGTH                   PIC S9(4) COMP.              
           05  WS-STR-ST                   PIC S9(4) COMP.              
           05  WS-SYSIN-COMP-NO            PIC  X(02) VALUE SPACES.     
           05  WS-DISP-HDR-AMT             PIC  ZZ,ZZZ,ZZZ.99-.         
           05  WS-DISP-DET-AMT             PIC  ZZ,ZZZ,ZZZ.99-.         
           05  WS-PYMT-RPT-NAME            PIC  X(20) VALUE SPACES.     
           05  WS-ERR-RPT-NAME             PIC  X(20) VALUE SPACES.     
           05  WS-REPORT-NAME.                                          
               10 FILLER                   PIC X(07)  VALUE 'PCSA177'.  
               10 WS-REPORT-NAME-1         PIC X(01).                   
               10 WS-REPORT-NAME-2         PIC X(01).                   
ACT262     05  WS-FCSAC27-FIRST-REC        PIC X(01) VALUE 'Y'.         
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-PYMNT-EXIST-SW           PIC X(01)  VALUE 'N'.        
               88 PAYMENT-EXIST                       VALUE 'Y'.        
               88 PAYMENT-NOT-EXIST                   VALUE 'N'.        
           05  WS-SYSIN-EXIST              PIC X(01)  VALUE 'Y'.        
               88 SYSIN-EXISTS                        VALUE 'Y'.        
               88 SYSIN-DOES-NOT-EXIST                VALUE 'N'.        
           05  WS-REPORT-SW                PIC X(01)  VALUE 'Y'.        
               88 PAYMENT-REPORT                      VALUE 'Y'.        
               88 ERROR-REPORT                        VALUE 'N'.        
           05  WS-VALID-ACCOUNT            PIC X(01)  VALUE 'N'.        
               88 VALID-ACCOUNT                       VALUE 'Y'.        
               88 INVALID-ACCOUNT                     VALUE 'N'.        
           05  WS-BATCH-REJECT-SW          PIC X(01)  VALUE 'N'.        
               88 BATCH-REJECTED                      VALUE 'Y'.        
               88 BATCH-NOT-REJECTED                  VALUE 'N'.        
A01346     05  WS-TOT-REC-SW               PIC X(01)  VALUE 'N'.        
A01346         88 WRITE-TOTAL-REC                     VALUE 'Y'.        
A01346     05  WS-PAYMENT-REJECT-SW        PIC X(01)  VALUE 'N'.        
A01346         88 PAYMENT-REJECTED                    VALUE 'Y'.        
A01346         88 PAYMENT-NOT-REJECTED                VALUE 'N'.        
           05  WS-FAC01-STATUS             PIC X(02)  VALUE '00'.       
               88 WS-FAC01-SUCCESSFUL                 VALUE '00' '04'.  
A02388     05  WS-FAC27-STATUS            PIC X(02)   VALUE '00'.       
A02388         88 WS-FAC27-SUCCESSFUL                 VALUE '00' '04'.  
           05  WS-RECORD-TYPE              PIC X(01)  VALUE 'D'.        
               88 DETAIL-RECORD                       VALUE 'D'.        
               88 TOTAL-RECORD                        VALUE 'T'.        
           05  WS-REJECT-REASON            PIC X(01)  VALUE SPACES.     
               88 ACCOUNT-NOT-NUMERIC                 VALUE 'A'.        
               88 MULTIPLE-OLD-ACCOUNTS               VALUE 'B'.        
               88 ACCOUNT-NOT-FOUND                   VALUE 'C'.        
               88 AMOUNT-NOT-NUMERIC                  VALUE 'D'.        
               88 AMOUNT-EQUALS-ZEROS                 VALUE 'E'.        
               88 NEGATIVE-AMOUNT                     VALUE 'F'.        
A00950         88 HDR-DET-AMT-NOT-MATCHING            VALUE 'G'.        
A02388         88 ACCOUNT-IS-ARCHIVED                 VALUE 'H'.        
                                                                        
       01  WS-ACCUMULATORS.                                             
           05  WS-GRND-TOT-ENTRIES         PIC S9(5)    COMP-3 VALUE +0.
           05  WS-GRND-TOT-ENT-REJ         PIC S9(5)    COMP-3 VALUE +0.
           05  WS-GRND-TOT-ENT-PEN-POST    PIC S9(5)    COMP-3 VALUE +0.
           05  WS-GRND-TOT-AMT             PIC S9(9)V99 COMP-3 VALUE +0.
           05  WS-GRND-NET-AMT-REJ         PIC S9(9)V99 COMP-3 VALUE +0.
           05  WS-GRND-NET-AMT-PEN-POST    PIC S9(9)V99 COMP-3 VALUE +0.
           05  WS-NO-DETAIL-RECS           PIC S9(4)    COMP-3 VALUE +0.
           05  WS-CHECK-TOTAL              PIC S9(9)V99 COMP-3 VALUE +0.
A01346     05  WS-BATCH-TOTAL              PIC S9(9)V99 COMP-3 VALUE +0.
                                                                        
       01  WS-REC-FORMAT.                                               
ACT061   03  WS-DETAIL-REC OCCURS 900 TIMES.                            
           05  WS-REC-TYPE-DET             PIC 9(01).                   
           05  WS-OUT-SEQ-NO-DET           PIC 9(06).                   
           05  WS-DATE-DET.                                             
               10  WS-MONTH-DET            PIC 9(02).                   
               10  WS-DAY-DET              PIC 9(02).                   
               10  WS-YEAR-DET             PIC 9(02).                   
           05  WS-REPORT-DET.                                           
               10  WS-BATCH-TYPE-DET       PIC 9(01).                   
           05  WS-BATCH-NO-DET             PIC 9(03).                   
           05  WS-SEQ-NO-DET               PIC 9(06).                   
           05  WS-ACCT-NO-DET              PIC 9(13).                   
           05  WS-CURR-TYPE                PIC X(01).                   
           05  WS-PAY-CD-DET               PIC X(01).                   
           05  WS-AMT-DET                  PIC 9(8)V9(02).              
           05  WS-BILL-DATE.                                            
               10  WS-BILL-MM              PIC X(02).                   
               10  WS-BILL-YY              PIC X(02).                   
           05  FILLER                      PIC X(28).                   
PRDFIX*  03 WS-DETAILS OCCURS 100 TIMES.                                        
PRDFIX   03 WS-DETAILS OCCURS 900 TIMES.                                
           05  WS-REJ-REASON               PIC X(01).                   
           05  WS-COMPANY-ID               PIC X(10).                   
T30775     05  WS-PAYER-NM                 PIC X(35).                   
           05  WS-TRAN-COMMENT             PIC X(60).                   
           05  WS-ACCT-NO                  PIC X(30).                   
A02388     05  WS-ACCT-XFER-TO             PIC 9(13).                   
                                                                        
       01  WS-BATCH-TOTAL-REC.                                          
           05  WS-REC-TYPE-BTR             PIC 9(01).                   
           05  WS-OUT-SEQ-NO-BTR           PIC 9(06).                   
           05  WS-DATE-BTR.                                             
               10  WS-MONTH-BTR            PIC 9(02).                   
               10  WS-DAY-BTR              PIC 9(02).                   
               10  WS-YEAR-BTR             PIC 9(02).                   
           05  WS-REPORT-BTR.                                           
               10  WS-BATCH-TYPE-BTR       PIC 9(01).                   
           05  WS-BATCH-NO-BTR             PIC 9(03).                   
           05  WS-TOTAL-NO-DOCS-BTR        PIC 9(03).                   
           05  WS-DOC-TOTAL-BTR            PIC 9(09)V9(02).             
           05  WS-CHECK-TOTAL-BTR          PIC 9(09)V9(02).             
           05  WS-BANK-NO-BTR              PIC 9(05).                   
           05  WS-AGENT-ID-BTR             PIC X(06).                   
           05  FILLER                      PIC X(27).                   
                                                                        
       01  WS-DATE-8.                                                   
           02  WS-D8-MM                    PIC X(02).                   
           02  FILLER                      PIC X(01)    VALUE '/'.      
           02  WS-D8-DD                    PIC X(02).                   
           02  FILLER                      PIC X(01)    VALUE '/'.      
           02  WS-D8-YY                    PIC X(02).                   
                                                                        
       01  WS-DATE-10.                                                  
           02  WS-D10-CC                   PIC X(02).                   
           02  WS-D10-YY                   PIC X(02).                   
           02  FILLER                      PIC X(01)    VALUE '/'.      
           02  WS-D10-MM                   PIC X(02).                   
           02  FILLER                      PIC X(01)    VALUE '/'.      
           02  WS-D10-DD                   PIC X(02).                   
                                                                        
       01  WS-CURRENT-DATE.                                             
           02  WS-CD-YY                    PIC X(02).                   
           02  WS-CD-MM                    PIC X(02).                   
           02  WS-CD-DD                    PIC X(02).                   
                                                                        
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                       PIC 9(02).                   
           05  WS-MM                       PIC 9(02).                   
           05  WS-SS                       PIC 9(02).                   
           05  WS-TT                       PIC 9(02).                   
                                                                        
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                    PIC X(02).                   
           05  FILLER                      PIC X(01)    VALUE ':'.      
           05  WS-RT-MM                    PIC X(02).                   
           05  FILLER                      PIC X(01)    VALUE ':'.      
           05  WS-RT-SS                    PIC X(02).                   
                                                                        
       01  PRINTER-CONTROL.                                             
           05  WS-LINE                 PIC X(132)   VALUE ALL '-'.      
           05  WS-BLANK-LINE           PIC X(132)   VALUE SPACES.       
           05  WS-RPT2-LINE-NO         PIC S999     COMP-3 VALUE +60.   
           05  WS-PAGE-SIZE            PIC S999     COMP-3 VALUE +55.   
           05  WS-RPT2-PAGE-NO         PIC S999     COMP-3 VALUE 0.     
           05  WS-DET-RECORD           PIC X(80)    VALUE SPACES.       
                                                                        
       01  WS-PARM-DATA.                                                
           05  FILLER                  PIC X(16)    VALUE               
                                       'LAST RUN DATE = '.              
           05  WS-PARM-DATE            PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(01)    VALUE ';'.          
           05  FILLER                  PIC X(16)    VALUE               
                                       'LAST BATCH NO = '.              
           05  WS-LAST-BATCH           PIC X(04).                       
           05  WS-LAST-BATCH-NUM REDEFINES WS-LAST-BATCH                
                                       PIC 9(04).                       
           05  FILLER                  PIC X(01)    VALUE '.'.          
           05  FILLER                  PIC X(32)    VALUE SPACES.       
                                                                        
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR REPORT TITLE           **          
      ****************************************************************          
                                                                        
       01  WS-HEADERS.                                                  
                                                                        
           05  WS-RPT1-TITLE.                                           
               10  P-RPT1-TITLE-PGNM   PIC X(08).                       
               10  FILLER              PIC X(38)    VALUE SPACES.       
               10  P-RPT1-COMP-NAME    PIC X(39)    VALUE               
                 'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.             
               10  FILLER              PIC X(29)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT1-RUN-DATE     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **          COMMON WORKING STORAGE FOR REPORT HEADER1         **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-DATE         PIC X(08).                       
               10  FILLER              PIC X(28)    VALUE SPACES.       
               10  FILLER              PIC X(18)    VALUE               
                                       ' DAILY REPORT FOR '.            
               10  P-RPT1-HEAD-1       PIC X(20)    VALUE SPACES.       
               10  FILLER              PIC X(34)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER              PIC X(118)   VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'PAGE:   '.   
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT2-HEADER-3.                                        
               10  FILLER              PIC X(10)    VALUE               
                                                    'ACCOUNT NO'.       
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  FILLER              PIC X(20)    VALUE               
                                       'COMPANY DESCRIPTION'.           
T30775         10  FILLER              PIC X(17)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE 'PAYMENT AMT'.
               10  FILLER              PIC X(06)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'COMMENTS'.   
T30775         10  FILLER              PIC X(56)    VALUE SPACES.       
                                                                        
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN DETAILS     **          
      ****************************************************************          
      *                                                                         
A02388     05  WS-RPT1-DETAIL.                                          
ACT262         10  FILLER              PIC X(01)    VALUE ''''.         
               10  P-ACCOUNT-NO        PIC X(27)    VALUE SPACES.       
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
T30775         10  P-COMP-DESC         PIC X(35)    VALUE SPACES.       
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
               10  P-REJECT-REASON     PIC X(33)    VALUE SPACES.       
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
A02388         10  P-PAYMENT-AMT       PIC 999999999.99-.               
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
               10  P-ACCT-COMB.                                         
                   15  P-ACCT-COMB-1   PIC X(13)    VALUE SPACES.       
                   15  FILLER          PIC X(01)    VALUE SPACES.       
                   15  P-ACCT-COMB-2   PIC X(13)    VALUE SPACES.       
                   15  FILLER          PIC X(01)    VALUE SPACES.       
                   15  P-ACCT-COMB-3   PIC X(13)    VALUE SPACES.       
                   15  FILLER          PIC X(01)    VALUE SPACES.       
                   15  P-ACCT-COMB-4   PIC X(13)    VALUE SPACES.       
                   15  FILLER          PIC X(01)    VALUE SPACES.       
                   15  P-ACCT-COMB-5   PIC X(13)    VALUE SPACES.       
                   15  FILLER          PIC X(01)    VALUE SPACES.       
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
               10  P-COMMENTS          PIC X(59)    VALUE SPACES.       
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
A02388         10  P-ACCT-XFER-TO      PIC 9(13)    VALUE 0.            
ACT262         10  FILLER              PIC X(05)    VALUE SPACES.       
                                                                        
ACT262     05  WS-RPT1-DETAIL-HDR.                                      
ACT262         10  P-ACCOUNT-NO-HDR    PIC X(10)    VALUE 'ACCOUNT NO'. 
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
ACT262         10  P-COMP-DESC-HDR     PIC X(19)    VALUE               
ACT262                                           'COMPANY_DESCRIPTION'. 
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
ACT262         10  P-REJECT-REASON-HDR PIC X(13)    VALUE               
ACT262                                                 'REJECT_REASON'. 
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
ACT262         10  P-PAYMENT-AMT-HDR   PIC X(14)    VALUE               
ACT262                                                'PAYMENT_AMOUNT'. 
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
ACT262         10  P-ACCT-COMB-HDR     PIC X(19)    VALUE               
ACT262                                           'POSSIBLE_ACCOUNT_NO'. 
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
ACT262         10  P-COMMENTS-HDR      PIC X(08)    VALUE               
ACT262                                                      'COMMENTS'. 
ACT262         10  FILLER              PIC X(01)    VALUE ','.          
ACT262         10  P-ACCT-XFER-TO-HDR  PIC X(18)    VALUE               
ACT262                                            'XFER_TO_ACCOUNT_NO'. 
ACT262         10  FILLER              PIC X(01)    VALUE SPACES.       
                                                                        
           05  WS-RPT2-DETAIL-1.                                        
               10  P2-ACCOUNT-NO       PIC X(13)    VALUE SPACES.       
               10  FILLER              PIC X(02)    VALUE SPACES.       
T30775         10  P2-COMP-DESC        PIC X(35)    VALUE SPACES.       
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P2-PAYMENT-AMT      PIC ZZZ,ZZZ,ZZZ.99-.             
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P2-COMMENTS         PIC X(60)    VALUE SPACES.       
T30775         10  FILLER              PIC X(04)    VALUE SPACES.       
                                                                        
      *                                                                         
      ****************************************************************          
      **      COMMON WORKING STORAGE FOR REPORT TOTAL LINES         **          
      ****************************************************************          
      *                                                                         
       01  WS-BATCH-TOTAL-LINES.                                        
                                                                        
           05  WS-TOTAL-LINE-1.                                         
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  FILLER              PIC X(27)    VALUE               
                                      '*** REPORT GRAND TOTALS ***'.    
               10  FILLER              PIC X(15)    VALUE SPACES.       
               10  FILLER              PIC X(27)    VALUE               
                                      ' TOTAL ENTRIES PROCESSED = '.    
               10  P-RPT-TOTAL-ENTRIES PIC ZZ,ZZ9.                      
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  FILLER              PIC X(26)    VALUE               
                                      '  NET AMOUNT PROCESSED =  '.     
               10  P-RPT-TOTAL-AMT     PIC ZZZ,ZZZ,ZZZ.99-.             
               10  FILLER              PIC X(12)    VALUE SPACE.        
                                                                        
           05  WS-TOTAL-LINE-2.                                         
               10  FILLER              PIC X(43)    VALUE SPACES.       
               10  FILLER              PIC X(27)    VALUE               
                                      ' TOTAL ENTRIES REJECTED  = '.    
               10  P-RPT-TOT-ENT-REJ   PIC ZZ,ZZ9.                      
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  FILLER              PIC X(26)    VALUE               
                                      '  NET AMOUNT REJECTED  =  '.     
               10  P-RPT-NET-AMT-REJ   PIC ZZZ,ZZZ,ZZZ.99-.             
               10  FILLER              PIC X(12)    VALUE SPACE.        
                                                                        
           05  WS-TOTAL-LINE-3.                                         
               10  FILLER              PIC X(43)    VALUE SPACES.       
               10  FILLER              PIC X(27)    VALUE               
                                      ' TOTAL ENTRIES PEN-POST  = '.    
               10  P-RPT-TOT-PEN-POST  PIC ZZ,ZZ9.                      
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  FILLER              PIC X(26)    VALUE               
                                      '  NET AMOUNT PEN-POST  =  '.     
               10  P-RPT-NET-PEN-POST  PIC ZZZ,ZZZ,ZZZ.99-.             
               10  FILLER              PIC X(12)    VALUE SPACE.        
                                                                        
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
      *===============================================================*         
      * SQL COMMUNICATION AREA                                        *         
      *===============================================================*         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *   CSS_JOB_PARM                                                *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_ACCOUNT                                                *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBACCT                                                      
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_XREF_ACCOUNT                                           *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBXREF                                                      
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_COMPANY - C7                                           *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================**        
      *    CSS_EDI_PYMT_HDR - JH                                       *        
      *===============================================================**        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBPYMTHD                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================**        
      *    CSS_EDI_PYMT_DET - JD                                       *        
      *===============================================================**        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBPYMTDT                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================**        
      *    CSS_EDI_COMP_ACCT - IK                                      *        
      *===============================================================**        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBIDACCT                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================**        
      *    CSS_EDI_COMPANY - IB                                        *        
      *===============================================================**        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBIDDESC                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================**        
      *     CSS_APPL_PGM_DESC K9                                       *        
      *===============================================================**        
           EXEC SQL                                                             
             INCLUDE TBPGMDSC                                                   
           END-EXEC.                                                            
                                                                        
A01346*===============================================================**        
A01346*     CSS_CODE_VALUE UV                                          *        
A01346*===============================================================**        
A01346     EXEC SQL                                                             
A01346       INCLUDE TBCDVALU                                                   
A01346     END-EXEC.                                                            
A02388*                                                                         
A02388*===============================================================**        
A02388*    HST_ACCOUNT                                                          
A02388*===============================================================**        
A02388                                                                  
A02388     EXEC SQL                                                             
A02388         INCLUDE TBHACCT                                                  
A02388     END-EXEC.                                                            
                                                                        
      *===============================================================*         
      * WS USED WITH PAYMENT APPLICATION ROUTINE                      *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00017                                                 
           END-EXEC.                                                            
                                                                        
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00038.                                                           
                                                                        
      ******************************************************************        
      *    CURSOR TO SELECT EDI PAYMENTS HDR DETAILS                   *        
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE EDI_HDR CURSOR WITH HOLD FOR                        
             SELECT DEBIT_CREDIT_CD                                     
                   ,EDI_COMPANY_ID                                      
T30775             ,PAYER_NM                                            
                   ,TOTAL_PYMT_AM                                       
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), TRANSACTION_TS
           , 121), ' ', '-'), ':', '.') TRANSACTION_TS                         
               FROM CSS_EDI_PYMT_HDR                                    
              WHERE EXTRACT_FL <> 'Y'                                   
                AND SEC_CD = :JH-SEC-CD                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE EDI_HDR CURSOR WITH HOLD FOR                                
MFA-TR*      SELECT DEBIT_CREDIT_CD                                             
MFA-TR*            ,EDI_COMPANY_ID                                              
MFA-TR*            ,PAYER_NM                                                    
MFA-TR*            ,TOTAL_PYMT_AM                                               
MFA-TR*            ,TRANSACTION_TS                                              
MFA-TR*        FROM CSS_EDI_PYMT_HDR                                            
MFA-TR*       WHERE EXTRACT_FL <> 'Y'                                           
MFA-TR*         AND SEC_CD = :JH-SEC-CD                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR TO SELECT EDI PAYMENTS DET DETAILS                   *        
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE EDI_DET CURSOR FOR                                  
             SELECT DEBIT_CREDIT_CD                                     
                   ,PAYMENT_AM                                          
                   ,REF_CUST_ACCT_NO                                    
                   ,SEQUENCE_NO                                         
                   ,TRAN_COMMENT                                        
               FROM CSS_EDI_PYMT_DET WITH(READUNCOMMITTED)                      
              WHERE TRANSACTION_TS = CIS.CHAR2TIMESTAMP(
                                                     :JH-TRANSACTION-TS
              )                 
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE EDI_DET CURSOR FOR                                          
MFA-TR*      SELECT DEBIT_CREDIT_CD                                             
MFA-TR*            ,PAYMENT_AM                                                  
MFA-TR*            ,REF_CUST_ACCT_NO                                            
MFA-TR*            ,SEQUENCE_NO                                                 
MFA-TR*            ,TRAN_COMMENT                                                
MFA-TR*        FROM CSS_EDI_PYMT_DET                                            
MFA-TR*       WHERE TRANSACTION_TS = :JH-TRANSACTION-TS                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR TO SELECT EDI COMPANY ACCOUNTS                       *        
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE EDI_ACCT CURSOR FOR                                 
             SELECT ACCOUNT_NO                                          
               FROM CSS_EDI_COMP_ACCT WITH(READUNCOMMITTED)                     
              WHERE EDI_COMPANY_ID = :IK-EDI-COMPANY-ID                 
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE EDI_ACCT CURSOR FOR                                         
MFA-TR*      SELECT ACCOUNT_NO                                                  
MFA-TR*        FROM CSS_EDI_COMP_ACCT                                           
MFA-TR*       WHERE EDI_COMPANY_ID = :IK-EDI-COMPANY-ID                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARM-INPUT.                                                  
           05  PARM-LENGTH             PIC S9(4) COMP.                  
           05  PARM-SEC-CD             PIC X(03).                       
           05  PARM-SOURCE-CD          PIC X(01).                       
                                                                        
       PROCEDURE DIVISION USING PARM-INPUT.                             
                                                                        
      ******************************************************************        
      **                         M A I N L I N E                      **        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-EXTRACT-PAYMENTS                                
              THRU 1000-EXIT                                            
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           IF PAYMENT-NOT-EXIST                                         
              MOVE '02'                  TO RETURN-CODE                 
           END-IF                                                       
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  COMMON INITIALIZATION ROUTINE                               **        
      **                                                              **        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0200-OPEN-FILES                                      
              THRU 0200-EXIT                                            
                                                                        
           PERFORM 0300-SETUP-DATES                                     
              THRU 0300-EXIT                                            
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  OPENS THE PAYMENT FILE AND ERROR REPORT                     **        
      **                                                              **        
      ******************************************************************        
       0200-OPEN-FILES.                                                 
      *---------------*                                                         
           MOVE '0200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           OPEN OUTPUT FCSAC01-FILE                                     
           IF WS-FAC01-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              STRING  '** FILE OPEN ERROR FCSAC01  **' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FAC01-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
                                                                        
A02388     OPEN OUTPUT FCSAC27-FILE                                     
A02388     MOVE SPACES                   TO FCSAC27-OUT-REC             
                                                                        
           OPEN OUTPUT FCSPT331-FILE                                    
           MOVE SPACES                   TO PRT331-RECORD               
           .                                                            
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  GET THE CURRENT DATE, TIME AND RUN DATE FROM JOB PARM TABLE **        
      **                                                              **        
      ******************************************************************        
       0300-SETUP-DATES.                                                
      *----------------*                                                        
           MOVE '0300'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           ACCEPT WS-CURRENT-TIME FROM TIME                             
           MOVE WS-HH                  TO WS-RT-HH                      
           MOVE WS-MM                  TO WS-RT-MM                      
           MOVE WS-SS                  TO WS-RT-SS                      
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME               
                                                                        
           ACCEPT WS-CURRENT-DATE FROM DATE                             
           MOVE WS-CD-YY               TO WS-D8-YY                      
           MOVE WS-CD-MM               TO WS-D8-MM                      
           MOVE WS-CD-DD               TO WS-D8-DD                      
           MOVE WS-DATE-8              TO P-RPT1-RUN-DATE               
                                                                        
           PERFORM 6251-GET-FJC01-DATE                                  
              THRU 6251-EXIT                                            
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '          TO WS-PGRMNAME                   
              MOVE SPACES              TO WS-INPUT-AREA                 
              MOVE SPACES              TO WS-INPUT-DATA-BREAKDOWN       
              PERFORM 6251-GET-FJC01-DATE                               
                 THRU 6251-EXIT                                         
              MOVE WS-PGMNAME          TO WS-PGRMNAME                   
           END-IF                                                       
                                                                        
           MOVE WS-PGRMNAME            TO G6-PROGRAM-NAME               
           MOVE WS-01                  TO G6-COMPANY-NO                 
           MOVE 'PARM'                 TO G6-CMND-CODE                  
           MOVE 1                      TO G6-SEQ-NO                     
           MOVE WS-A                   TO G6-STATUS                     
           PERFORM 7000-GET-LAST-BATCH THRU 7000-EXIT                   
           IF WS-PARM-DATE = WS-INPUT-DATE                              
              MOVE WS-LAST-BATCH-NUM   TO WS-BATCH-NO                   
           ELSE                                                         
              MOVE ZERO                TO WS-BATCH-NO                   
           END-IF                                                       
                                                                        
           MOVE WS-INPUT-DATE          TO WS-DATE-10                    
           MOVE WS-D10-YY              TO WS-D8-YY                      
           MOVE WS-D10-MM              TO WS-D8-MM                      
           MOVE WS-D10-DD              TO WS-D8-DD                      
           MOVE WS-DATE-8              TO P-RPT1-DATE                   
                                                                        
           MOVE PARM-SOURCE-CD         TO WS-REPORT-NAME-2              
                                                                        
           MOVE WS-P                   TO WS-REPORT-NAME-1              
           MOVE WS-REPORT-NAME         TO K9-APPL-PROGRAM-ID            
           PERFORM 7800-GET-APPL-DESC  THRU 7800-EXIT                   
           MOVE K9-APPL-PROGRAM-DESC   TO WS-PYMT-RPT-NAME              
           MOVE WS-E                   TO WS-REPORT-NAME-1              
           MOVE WS-REPORT-NAME         TO K9-APPL-PROGRAM-ID            
           PERFORM 7800-GET-APPL-DESC  THRU 7800-EXIT                   
           MOVE K9-APPL-PROGRAM-DESC   TO WS-ERR-RPT-NAME               
                                                                        
           MOVE WS-Y                   TO WS-SYSIN-EXIST                
           MOVE SPACES                 TO WS-SYSIN-COMP-NO              
                                                                        
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN                           
                                                                        
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               MOVE WS-N               TO WS-SYSIN-EXIST                
           END-IF                                                       
                                                                        
           IF SYSIN-EXISTS                                              
               MOVE WS-SYSIN-COMP-NO   TO C7-COMPANY-NO                 
               PERFORM 7900-GET-COMPANY-DESC     THRU 7900-EXIT         
           END-IF                                                       
           .                                                            
       0300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  EXTRACT PAYMENTS FROM THE HEADER TABLE                      **        
      **                                                              **        
      ******************************************************************        
       1000-EXTRACT-PAYMENTS.                                           
      *----------------------*                                                  
A02388     MOVE 60                            TO WS-RPT2-LINE-NO        
           MOVE PARM-SEC-CD                   TO JH-SEC-CD              
           PERFORM 7300-OPEN-EDI-HDR          THRU 7300-EXIT            
           PERFORM 7310-FETCH-EDI-HDR         THRU 7310-EXIT            
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              SET BATCH-NOT-REJECTED          TO TRUE                   
              UNSTRING JH-TOTAL-PYMT-AM  DELIMITED BY ' '               
                  INTO WS-AMOUNT                                        
              END-UNSTRING                                              
              MOVE ZEROES                     TO WS-AMT-CHAR            
              MOVE LENGTH OF WS-AMOUNT        TO WS-LENGTH              
              COMPUTE WS-STR-ST = 16 - WS-LENGTH                        
              MOVE WS-AMOUNT                  TO                        
                      WS-AMT-CHAR(WS-STR-ST:WS-LENGTH)                  
              MOVE WS-AMT-NUM                 TO WS-HDR-AMT             
              IF JH-DEBIT-CREDIT-CD = WS-D                              
                 MULTIPLY -1 BY WS-HDR-AMT                              
                 SET BATCH-REJECTED           TO TRUE                   
              ELSE                                                      
                 PERFORM 1600-VALIDATE-AMOUNT THRU 1600-EXIT            
              END-IF                                                    
              PERFORM 1400-PROCESS-EDI-DET    THRU 1400-EXIT            
              IF WS-HDR-AMT NOT EQUAL WS-CHECK-TOTAL                    
A00950           SET BATCH-REJECTED           TO TRUE                   
A00950           MOVE 'G'                     TO WS-REJ-REASON(1)       
                 MOVE WS-HDR-AMT               TO WS-DISP-HDR-AMT       
                 MOVE WS-CHECK-TOTAL           TO WS-DISP-DET-AMT       
                 MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH   
                 STRING ' HEADER PAYMENT AMOUNT IS NOT MATCHING '       
                        DELIMITED BY SIZE                               
                        'WITH DETAIL PAYMENT AMOUNTS **'                
                        DELIMITED BY SIZE     INTO WS-ERR-MSG           
                 STRING ' TRAN TS = '         DELIMITED BY SIZE         
                        JH-TRANSACTION-TS     DELIMITED BY SIZE         
                        ', COMP ID = '        DELIMITED BY SIZE         
                        JH-EDI-COMPANY-ID     DELIMITED BY SIZE         
                        ', HDR AMT = '        DELIMITED BY SIZE         
                        WS-DISP-HDR-AMT       DELIMITED BY SIZE         
                        ', DTL AMT = '        DELIMITED BY SIZE         
                        WS-DISP-DET-AMT       DELIMITED BY SIZE         
                        INTO     WS-ERR-MSG2                            
A00950           DISPLAY '** ' WS-ERR-MSG                               
A00950           DISPLAY '** ' WS-ERR-MSG2                              
              END-IF                                                    
A01346        IF PAYMENT-REJECTED                                       
A01346           PERFORM 1950-PROCESS-ALL-PYMTS                         
A01346              THRU 1950-EXIT                                      
A01346           SET PAYMENT-NOT-REJECTED    TO TRUE                    
A01346        ELSE                                                      
                 IF BATCH-REJECTED                                      
                    PERFORM 1900-ERROR-REPORT    THRU 1900-EXIT         
                    MOVE WS-N                    TO JH-VALID-CIS-FL     
                 ELSE                                                   
                    SET PAYMENT-EXIST            TO TRUE                
                    ADD WS-1                     TO WS-BATCH-NO         
                    PERFORM 1800-WRITE-PYMT-REC  THRU 1800-EXIT         
                    MOVE WS-Y                    TO JH-VALID-CIS-FL     
                 END-IF                                                 
A01346        END-IF                                                    
              PERFORM 7350-UPDATE-EDI-HDR     THRU 7350-EXIT            
              PERFORM 7310-FETCH-EDI-HDR      THRU 7310-EXIT            
           END-PERFORM                                                  
                                                                        
           PERFORM 7320-CLOSE-EDI-HDR         THRU 7320-EXIT            
                                                                        
           MOVE WS-BATCH-NO                   TO WS-LAST-BATCH-NUM      
           MOVE WS-INPUT-DATE                 TO WS-PARM-DATE           
           MOVE WS-PARM-DATA                  TO G6-PARM-DATA           
           PERFORM 8150-UPDATE-JOB-PARM       THRU 8150-EXIT            
                                                                        
           SET ERROR-REPORT                   TO TRUE                   
                                                                        
           MOVE WS-GRND-TOT-ENTRIES           TO P-RPT-TOTAL-ENTRIES    
           MOVE WS-GRND-TOT-AMT               TO P-RPT-TOTAL-AMT        
           MOVE WS-GRND-TOT-ENT-REJ           TO P-RPT-TOT-ENT-REJ      
           MOVE WS-GRND-NET-AMT-REJ           TO P-RPT-NET-AMT-REJ      
           MOVE WS-GRND-TOT-ENT-PEN-POST      TO P-RPT-TOT-PEN-POST     
           MOVE WS-GRND-NET-AMT-PEN-POST      TO P-RPT-NET-PEN-POST     
                                                                        
           SET PAYMENT-REPORT                 TO TRUE                   
           IF WS-RPT2-LINE-NO GREATER THAN WS-54                        
              PERFORM 8200-PRINT-HEADER   THRU 8200-EXIT                
           END-IF                                                       
                                                                        
           PERFORM 8500-PRINT-TOTAL-LINES     THRU 8500-EXIT            
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  FETCH ROWS FROM EDI DETAIL TABLE                            **        
      **                                                              **        
      ******************************************************************        
       1400-PROCESS-EDI-DET.                                            
      *---------------------*                                                   
           MOVE '1400'                        TO WS-ACTIVE-PARAGRAPH    
                                                                        
           INITIALIZE WS-CHECK-TOTAL                                    
                      WS-REC-FORMAT                                     
                      WS-SUB                                            
A01346                WS-BATCH-TOTAL                                    
                                                                        
           PERFORM 7400-OPEN-EDI-DET          THRU 7400-EXIT            
           PERFORM 7410-FETCH-EDI-DET         THRU 7410-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              SET INVALID-ACCOUNT             TO TRUE                   
              MOVE SPACES                     TO WS-REJECT-REASON       
              PERFORM 1500-VALIDATE-ACCOUNT-NO   THRU 1500-EXIT         
              UNSTRING JD-PAYMENT-AM  DELIMITED BY ' '                  
                  INTO WS-AMOUNT                                        
              END-UNSTRING                                              
              MOVE ZEROES                     TO WS-AMT-CHAR            
              MOVE LENGTH OF WS-AMOUNT        TO WS-LENGTH              
              COMPUTE WS-STR-ST = 16 - WS-LENGTH                        
              MOVE WS-AMOUNT                  TO                        
                      WS-AMT-CHAR(WS-STR-ST:WS-LENGTH)                  
              IF JD-DEBIT-CREDIT-CD = WS-D                              
                 SET NEGATIVE-AMOUNT          TO TRUE                   
              ELSE                                                      
                 PERFORM 1600-VALIDATE-AMOUNT THRU 1600-EXIT            
              END-IF                                                    
A01346        IF WS-REJECT-REASON NOT EQUAL SPACES                      
A01346           EVALUATE WS-REJECT-REASON                              
A01346               WHEN 'A'                                           
A01346                 MOVE 16                  TO UV-COLUMN-NA-LEN     
A01346                 MOVE 'ACCT_NOT_NUMERIC'  TO UV-COLUMN-NA-TEXT    
A01346               WHEN 'B'                                           
A01346                 MOVE 14                  TO UV-COLUMN-NA-LEN     
A01346                 MOVE 'MULT_OLD_ACCTS'    TO UV-COLUMN-NA-TEXT    
A01346               WHEN 'C'                                           
A01346                 MOVE 14                  TO UV-COLUMN-NA-LEN     
A01346                 MOVE 'ACCT_NOT_FOUND'    TO UV-COLUMN-NA-TEXT    
A01346               WHEN 'D'                                           
A01346                 MOVE 15                  TO UV-COLUMN-NA-LEN     
A01346                 MOVE 'AMT_NOT_NUMERIC'   TO UV-COLUMN-NA-TEXT    
A01346               WHEN 'E'                                           
A01346                 MOVE 15                  TO UV-COLUMN-NA-LEN     
A01346                 MOVE 'AMT_EQUALS_ZERO'   TO UV-COLUMN-NA-TEXT    
A01346               WHEN 'F'                                           
A01346                 MOVE 15                  TO UV-COLUMN-NA-LEN     
A01346                 MOVE 'NEGATIVE_AMOUNT'   TO UV-COLUMN-NA-TEXT    
A01346               WHEN 'G'                                           
A01346                 MOVE 17                  TO UV-COLUMN-NA-LEN     
A01346                 MOVE 'HDR_DET_NOT_EQUAL' TO UV-COLUMN-NA-TEXT    
A02388               WHEN 'H'                                           
A02388                 MOVE 13                  TO UV-COLUMN-NA-LEN     
A02388                 MOVE 'ACCT_ARCHIVED'     TO UV-COLUMN-NA-TEXT    
A01346               WHEN OTHER                                         
A01346                 MOVE 4                   TO UV-COLUMN-NA-LEN     
A01346                 MOVE '    '              TO UV-COLUMN-NA-TEXT    
A01346           END-EVALUATE                                           
A01346                                                                  
A01346           MOVE 9                       TO UV-TABLE-NA-LEN        
A01346           MOVE 'CSS_DUMMY'             TO UV-TABLE-NA-TEXT       
A01346           PERFORM 7910-SELECT-CODE-VALUE                         
A01346              THRU 7910-EXIT                                      
A01346        END-IF                                                    
              PERFORM 1700-ACCUM-DETAILS      THRU 1700-EXIT            
              PERFORM 7410-FETCH-EDI-DET      THRU 7410-EXIT            
           END-PERFORM                                                  
           PERFORM 7420-CLOSE-EDI-DET         THRU 7420-EXIT            
           .                                                            
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  VALIDATES THE ACCOUNT NO WHETHER IT IS IN CIS               **        
      **                                                              **        
      ******************************************************************        
       1500-VALIDATE-ACCOUNT-NO.                                        
      *-------------------------*                                               
                                                                        
           MOVE '1500'                        TO WS-ACTIVE-PARAGRAPH    
                                                                        
           MOVE ZEROS                          TO WS-ACCOUNT-NUM        
FIXPRD     MOVE SPACES                         TO WS-ACCOUNT-NO         
                                                                        
           MOVE ZERO                           TO WS-SPACE-CNT          
           INSPECT JD-REF-CUST-ACCT-NO TALLYING WS-SPACE-CNT            
                   FOR ALL ' '                                          
                                                                        
           COMPUTE WS-STR-LENGTH = 30 - WS-SPACE-CNT                    
           END-COMPUTE                                                  
                                                                        
           EVALUATE TRUE                                                
                                                                        
             WHEN WS-STR-LENGTH <= 13                                   
               MOVE JD-REF-CUST-ACCT-NO(1:WS-STR-LENGTH)                
                                              TO WS-ACCOUNT-NUM         
               MOVE WS-ACCOUNT-NUM            TO WS-ACCOUNT-NO          
                                                                        
             WHEN WS-STR-LENGTH = 16                                    
FIXPRD         MOVE JD-REF-CUST-ACCT-NO       TO WS-ACCOUNT-NO          
FIXPRD         IF WS-ACCOUNT-NO NUMERIC                                 
FIXPRD            CONTINUE                                              
FIXPRD         ELSE                                                     
                  UNSTRING JD-REF-CUST-ACCT-NO DELIMITED BY '-'         
                      INTO WS-ACCOUNT-NO-X1                             
                           WS-ACCOUNT-NO-X2                             
                           WS-ACCOUNT-NO-X3                             
                           WS-ACCOUNT-NO-X4                             
                  END-UNSTRING                                          
FIXPRD         END-IF                                                   
                                                                        
             WHEN WS-STR-LENGTH = 18                                    
               MOVE JD-REF-CUST-ACCT-NO(1:13) TO WS-ACCOUNT-NO          
               IF WS-ACCOUNT-NO NOT NUMERIC                             
                  IF JD-REF-CUST-ACCT-NO(6:13) NUMERIC                  
                     MOVE JD-REF-CUST-ACCT-NO(6:13) TO WS-ACCOUNT-NO    
                  END-IF                                                
               END-IF                                                   
                                                                        
             WHEN WS-STR-LENGTH = 21                                    
               MOVE JD-REF-CUST-ACCT-NO(9:13) TO WS-ACCOUNT-NO          
                                                                        
             WHEN OTHER                                                 
               MOVE JD-REF-CUST-ACCT-NO       TO WS-ACCOUNT-NO          
           END-EVALUATE                                                 
                                                                        
           IF WS-ACCOUNT-NO NUMERIC                                     
              MOVE WS-ACCOUNT-NO              TO AT-ACCOUNT-NO          
                                                 XR-OLD-ACCOUNT-NO      
A02388                                           HA-ACCOUNT-NO          
              PERFORM 1510-GET-CIS-ACCOUNT    THRU 1510-EXIT            
           ELSE                                                         
              SET ACCOUNT-NOT-NUMERIC         TO TRUE                   
           END-IF                                                       
                                                                        
           IF VALID-ACCOUNT                                             
              MOVE AT-ACCOUNT-NO              TO IK-ACCOUNT-NO          
              MOVE JH-EDI-COMPANY-ID          TO IK-EDI-COMPANY-ID      
              PERFORM 7530-SELECT-EDI-ACCT    THRU 7530-EXIT            
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 PERFORM 8100-INSERT-EDI-ACCT THRU 8100-EXIT            
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  CHECK THE ACCOUNT AND XREF ACCOUNT TABLES FOR ACCOUNT NO    **        
      **                                                              **        
      ******************************************************************        
       1510-GET-CIS-ACCOUNT.                                            
      *---------------------*                                                   
                                                                        
           MOVE WS-N                     TO WS-EXISTS-FLAG,             
A02388                                      WS-ARCHIVE-FLAG.            
A02388     INITIALIZE HA-ACCT-XFER-TO, P-ACCT-XFER-TO.                  
                                                                        
           PERFORM 7100-SELECT-CIS-ACCOUNT                              
              THRU 7100-EXIT                                            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7200-GET-OLD-ACCOUNT                              
                 THRU 7200-EXIT                                         
           END-IF                                                       
           .                                                            
       1510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  VALIDATE AMOUNT                                             **        
      **                                                              **        
      ******************************************************************        
       1600-VALIDATE-AMOUNT.                                            
      *---------------------*                                                   
           IF WS-AMT-CHAR NOT NUMERIC                                   
              SET AMOUNT-NOT-NUMERIC     TO TRUE                        
              IF WS-AMT-NUM < ZEROES                                    
                 SET NEGATIVE-AMOUNT     TO TRUE                        
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-AMT-NUM EQUAL ZEROES                                   
              SET AMOUNT-EQUALS-ZEROS    TO TRUE                        
           END-IF                                                       
           .                                                            
       1600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  ACCUMULATE THE DETAILS IN WORKING STORAGE TABLE             **        
      **                                                              **        
      ******************************************************************        
       1700-ACCUM-DETAILS.                                              
      *-------------------*                                                     
                                                                        
           ADD WS-1                      TO WS-SUB                      
                                            WS-GRND-TOT-ENTRIES         
           MOVE JD-SEQUENCE-NO           TO WS-SEQ-NO-DET(WS-SUB)       
           MOVE WS-ACCOUNT-NO            TO WS-ACCT-NO-DET(WS-SUB)      
           MOVE WS-AMT-NUM               TO WS-AMT-DET(WS-SUB)          
T30775     MOVE JH-PAYER-NM              TO WS-PAYER-NM(WS-SUB)         
           MOVE JD-TRAN-COMMENT-TEXT     TO WS-TRAN-COMMENT(WS-SUB)     
           MOVE JD-REF-CUST-ACCT-NO      TO WS-ACCT-NO(WS-SUB)          
                                                                        
           MOVE JH-EDI-COMPANY-ID        TO WS-COMPANY-ID(WS-SUB)       
           MOVE WS-REJECT-REASON         TO WS-REJ-REASON(WS-SUB)       
A02388     MOVE HA-ACCT-XFER-TO          TO WS-ACCT-XFER-TO(WS-SUB)     
                                                                        
           IF NEGATIVE-AMOUNT                                           
              SUBTRACT WS-AMT-NUM  FROM WS-CHECK-TOTAL                  
              SUBTRACT WS-AMT-NUM  FROM WS-GRND-TOT-AMT                 
           ELSE                                                         
              ADD  WS-AMT-NUM            TO WS-CHECK-TOTAL              
                                            WS-GRND-TOT-AMT             
           END-IF                                                       
           .                                                            
       1700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  WRITE DETAIL AND TOTAL RECORD FOR THE VALID PAYMENTS        **        
      **                                                              **        
      ******************************************************************        
       1800-WRITE-PYMT-REC.                                             
      *--------------------*                                                    
                                                                        
           SET DETAIL-RECORD           TO TRUE                          
           MOVE ZERO                   TO WS-NO-DETAIL-RECS             
                                                                        
           PERFORM VARYING WS-SUB1 FROM 1 BY 1                          
              UNTIL WS-SUB1 > WS-SUB                                    
A01346        PERFORM 1810-WRITE-PYMT-DET-REC                           
A01346           THRU 1810-EXIT                                         
           END-PERFORM                                                  
                                                                        
A01346     PERFORM 1820-WRITE-PYMT-TOT-REC                              
A01346        THRU 1820-EXIT                                            
           .                                                            
       1800-EXIT.                                                       
           EXIT.                                                        
                                                                        
A01346******************************************************************        
A01346** MOVE VALUES TO DETAIL RECORD AND WRITES THE RECORD IN TO PYMT**        
      ** FILE, WRITES THE PAYMENT DETAIL REPORT ALSO                  **        
      ******************************************************************        
       1810-WRITE-PYMT-DET-REC.                                         
      *------------------------*                                                
           ADD  WS-5                   TO WS-SEQ-NO                     
           MOVE WS-1                   TO WS-REC-TYPE-DET(WS-SUB1)      
           MOVE WS-SEQ-NO              TO WS-OUT-SEQ-NO-DET(WS-SUB1)    
           MOVE WS-INPUT-DATE(9:2)     TO WS-DAY-DET(WS-SUB1)           
           MOVE WS-INPUT-DATE(6:2)     TO WS-MONTH-DET(WS-SUB1)         
                                          WS-BILL-MM(WS-SUB1)           
           MOVE WS-INPUT-DATE(3:2)     TO WS-YEAR-DET(WS-SUB1)          
                                          WS-BILL-YY(WS-SUB1)           
           MOVE PARM-SOURCE-CD         TO WS-BATCH-TYPE-DET(WS-SUB1)    
           MOVE WS-BATCH-NO            TO WS-BATCH-NO-DET(WS-SUB1)      
           MOVE WS-C                   TO WS-CURR-TYPE(WS-SUB1)         
           MOVE ZERO                   TO WS-PAY-CD-DET(WS-SUB1)        
           ADD  WS-1                   TO WS-NO-DETAIL-RECS             
                                          WS-GRND-TOT-ENT-PEN-POST      
           ADD WS-AMT-DET(WS-SUB1)     TO WS-GRND-NET-AMT-PEN-POST      
A01346                                    WS-BATCH-TOTAL                
           PERFORM 8000-WRITE-FCSAC01 THRU 8000-EXIT                    
                                                                        
           MOVE WS-ACCT-NO-DET(WS-SUB1)          TO P2-ACCOUNT-NO       
           MOVE WS-AMT-DET(WS-SUB1)              TO P2-PAYMENT-AMT      
           MOVE WS-TRAN-COMMENT(WS-SUB1)         TO P2-COMMENTS         
T30775     MOVE WS-PAYER-NM(WS-SUB1)             TO P2-COMP-DESC        
                                                                        
           SET PAYMENT-REPORT                    TO TRUE                
                                                                        
           IF WS-RPT2-LINE-NO GREATER THAN WS-54                        
              PERFORM 8200-PRINT-HEADER          THRU 8200-EXIT         
           END-IF                                                       
           PERFORM 8600-PRINT-DETAIL-LINE        THRU 8600-EXIT         
           .                                                            
A01346 1810-EXIT.                                                       
A01346     EXIT.                                                        
                                                                        
A01346******************************************************************        
A01346** THIS PARAGRAPH WRITES THE TOTAL RECORD LINE IN THE PAYMENT   **        
      ** FILE, THIS TOTAL RECORD IS CREATED FOR EACH BATCH.           **        
      ******************************************************************        
       1820-WRITE-PYMT-TOT-REC.                                         
      *------------------------*                                                
           SET TOTAL-RECORD            TO TRUE                          
                                                                        
           MOVE WS-3                   TO  WS-REC-TYPE-BTR              
           ADD  WS-5                   TO WS-SEQ-NO                     
           MOVE WS-SEQ-NO              TO WS-OUT-SEQ-NO-BTR             
           MOVE WS-INPUT-DATE(9:2)     TO WS-DAY-BTR                    
           MOVE WS-INPUT-DATE(6:2)     TO WS-MONTH-BTR                  
           MOVE WS-INPUT-DATE(3:2)     TO WS-YEAR-BTR                   
           MOVE PARM-SOURCE-CD         TO WS-BATCH-TYPE-BTR             
           MOVE WS-BATCH-NO            TO WS-BATCH-NO-BTR               
           MOVE WS-NO-DETAIL-RECS      TO WS-TOTAL-NO-DOCS-BTR          
A01346     MOVE WS-BATCH-TOTAL         TO WS-DOC-TOTAL-BTR              
                                          WS-CHECK-TOTAL-BTR            
           MOVE ZEROS                  TO WS-BANK-NO-BTR                
           MOVE ZEROS                  TO WS-AGENT-ID-BTR               
                                                                        
           PERFORM 8000-WRITE-FCSAC01 THRU 8000-EXIT                    
           .                                                            
A01346 1820-EXIT.                                                       
A01346     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  WRITE ERROR REPORT FOR THE INVALID PAYMENTS                 **        
      **                                                              **        
      ******************************************************************        
       1900-ERROR-REPORT.                                               
      *------------------*                                                      
                                                                        
           PERFORM VARYING WS-SUB1 FROM 1 BY 1                          
              UNTIL WS-SUB1 > WS-SUB                                    
A01346        PERFORM 1910-WRITE-ERROR-RPT                              
A01346           THRU 1910-EXIT                                         
           END-PERFORM                                                  
           .                                                            
       1900-EXIT.                                                       
           EXIT.                                                        
                                                                        
A01346******************************************************************        
A01346** THIS PARAGRAPH WRITES THE REJECTED PAYMENTS IN ERROR REPORT  **        
      **                                                              **        
      ******************************************************************        
       1910-WRITE-ERROR-RPT.                                            
      *---------------------*                                                   
A00950     IF WS-REJ-REASON(1) = 'G'                                    
A00950        MOVE 'G' TO WS-REJ-REASON(WS-SUB1)                        
A00950     END-IF                                                       
                                                                        
           MOVE WS-REJ-REASON(WS-SUB1)        TO  WS-REJECT-REASON      
                                                                        
           EVALUATE WS-REJECT-REASON                                    
              WHEN 'A'                                                  
                 MOVE 'ACCOUNT NOT NUMERIC'   TO  P-REJECT-REASON       
              WHEN 'B'                                                  
                 MOVE 'MULTIPLE OLD ACCOUNTS' TO  P-REJECT-REASON       
              WHEN 'C'                                                  
                 MOVE 'ACCOUNT NOT FOUND'     TO  P-REJECT-REASON       
              WHEN 'D'                                                  
                 MOVE 'ACCOUNT NOT NUMERIC'   TO  P-REJECT-REASON       
              WHEN 'E'                                                  
                 MOVE 'AMOUNT EQUALS ZEROS'   TO  P-REJECT-REASON       
              WHEN 'F'                                                  
                 MOVE 'NEGATIVE AMOUNT'       TO  P-REJECT-REASON       
A00950        WHEN 'G'                                                  
A00950           MOVE 'HDR-DET-AMT-NOT-MATCHING'  TO P-REJECT-REASON    
A02388        WHEN 'H'                                                  
A02388           MOVE 'ACCOUNT IS ARCHIVED'       TO P-REJECT-REASON    
              WHEN OTHER                                                
                 MOVE 'PAYMENT IN REJECTED BATCH' TO P-REJECT-REASON    
           END-EVALUATE                                                 
                                                                        
           MOVE WS-AMT-DET(WS-SUB1)           TO WS-ERR-AMT             
           IF NEGATIVE-AMOUNT                                           
              MULTIPLY -1 BY WS-ERR-AMT                                 
           END-IF                                                       
                                                                        
           MOVE WS-ACCT-NO(WS-SUB1)              TO P-ACCOUNT-NO        
           MOVE SPACES                           TO P-COMMENTS          
           MOVE WS-TRAN-COMMENT(WS-SUB1)         TO P-COMMENTS          
A02388     MOVE WS-ACCT-XFER-TO(WS-SUB1)         TO P-ACCT-XFER-TO      
           ADD  WS-1                             TO WS-GRND-TOT-ENT-REJ 
           MOVE WS-ERR-AMT                       TO P-PAYMENT-AMT       
           ADD  WS-ERR-AMT                       TO WS-GRND-NET-AMT-REJ 
                                                                        
           IF ACCOUNT-NOT-FOUND                                         
              MOVE ZERO                          TO WS-SUB2             
              MOVE WS-COMPANY-ID(WS-SUB1)        TO IK-EDI-COMPANY-ID   
              PERFORM 7500-OPEN-EDI-ACCT         THRU 7500-EXIT         
              PERFORM 7510-FETCH-EDI-ACCT        THRU 7510-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 ADD  WS-1                       TO WS-SUB2             
                 EVALUATE WS-SUB2                                       
                     WHEN 1                                             
                       MOVE IK-ACCOUNT-NO        TO P-ACCT-COMB-1       
                     WHEN 2                                             
                       MOVE IK-ACCOUNT-NO     TO P-ACCT-COMB-2          
                     WHEN 3                                             
                       MOVE IK-ACCOUNT-NO     TO P-ACCT-COMB-3          
                     WHEN 4                                             
                       MOVE IK-ACCOUNT-NO     TO P-ACCT-COMB-4          
                     WHEN 5                                             
                       MOVE IK-ACCOUNT-NO     TO P-ACCT-COMB-5          
                 END-EVALUATE                                           
                 PERFORM 7510-FETCH-EDI-ACCT  THRU 7510-EXIT            
              END-PERFORM                                               
              PERFORM 7520-CLOSE-EDI-ACCT     THRU 7520-EXIT            
           END-IF                                                       
                                                                        
T30775     MOVE WS-PAYER-NM(WS-SUB1)          TO  P-COMP-DESC           
                                                                        
           SET ERROR-REPORT                   TO TRUE                   
                                                                        
           PERFORM 8600-PRINT-DETAIL-LINE     THRU 8600-EXIT            
           .                                                            
A01346 1910-EXIT.                                                       
A01346     EXIT.                                                        
                                                                        
A01346******************************************************************        
A01346**  IF NOT ALL PAYMENTS ARE REJECTED IN A BATCH THEN PROCESS THE**        
      **  PAYMENTS INDIVIDUALLY TO CREATE PAYMENT FILE AND ERROR      **        
      **  REPORT.                                                     **        
      ******************************************************************        
       1950-PROCESS-ALL-PYMTS.                                          
      *-----------------------*                                                 
           SET DETAIL-RECORD           TO TRUE                          
           MOVE ZERO                   TO WS-NO-DETAIL-RECS             
           MOVE SPACES                 TO WS-TOT-REC-SW                 
           ADD WS-1                    TO WS-BATCH-NO                   
                                                                        
           PERFORM VARYING WS-SUB1 FROM 1 BY 1                          
              UNTIL WS-SUB1 > WS-SUB                                    
              IF WS-REJ-REASON(WS-SUB1) > SPACES                        
                 PERFORM 1910-WRITE-ERROR-RPT                           
                    THRU 1910-EXIT                                      
              ELSE                                                      
                 SET PAYMENT-EXIST     TO TRUE                          
                 MOVE WS-Y             TO JH-VALID-CIS-FL               
                 PERFORM 1810-WRITE-PYMT-DET-REC                        
                    THRU 1810-EXIT                                      
                 SET WRITE-TOTAL-REC   TO TRUE                          
              END-IF                                                    
           END-PERFORM                                                  
                                                                        
           IF WRITE-TOTAL-REC                                           
              PERFORM 1820-WRITE-PYMT-TOT-REC                           
                 THRU 1820-EXIT                                         
           END-IF                                                       
           .                                                            
A01346 1950-EXIT.                                                       
A01346     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  GET BATCH NO OF THE LAST RUN                                **        
      **                                                              **        
      ******************************************************************        
       7000-GET-LAST-BATCH.                                             
      *--------------------*                                                    
                                                                        
           MOVE '7000'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             SELECT PARM_DATA                                           
               INTO :G6-PARM-DATA                                       
               FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                          
              WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                     
                AND COMPANY_NO   = :G6-COMPANY-NO                       
                AND CMND_CODE    = :G6-CMND-CODE                        
                AND SEQ_NO       = :G6-SEQ-NO                           
                AND STATUS       = :G6-STATUS                           
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PARM_DATA                                                   
MFA-TR*        INTO :G6-PARM-DATA                                               
MFA-TR*        FROM CSS_JOB_PARM                                                
MFA-TR*       WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                             
MFA-TR*         AND COMPANY_NO   = :G6-COMPANY-NO                               
MFA-TR*         AND CMND_CODE    = :G6-CMND-CODE                                
MFA-TR*         AND SEQ_NO       = :G6-SEQ-NO                                   
MFA-TR*         AND STATUS       = :G6-STATUS                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                MOVE G6-PARM-DATA      TO WS-PARM-DATA                  
             END-IF                                                     
           ELSE                                                         
              STRING 'SELECTING LAST BATCH NO FROM CSS_JOB_PARM  **'    
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
             STRING 'PROGRAM NAME  '     DELIMITED BY SIZE              
                     G6-PROGRAM-NAME     DELIMITED BY SIZE              
                    ', COMPANY NO  '     DELIMITED BY SIZE              
                     G6-COMPANY-NO       DELIMITED BY SIZE              
                    ', CMND CODE '       DELIMITED BY SIZE              
                     G6-CMND-CODE        DELIMITED BY SIZE              
                                         INTO  WS-ERR-MSG2              
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  CHECK WHETHER ACCOUNT EXIST IN ACCOUNT TABLE                **        
      **                                                              **        
      ******************************************************************        
       7100-SELECT-CIS-ACCOUNT.                                         
      *------------------------*                                                
                                                                        
           MOVE '7100'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             SELECT :WS-Y                                               
               INTO :WS-EXISTS-FLAG                                     
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT :WS-Y                                                       
MFA-TR*        INTO :WS-EXISTS-FLAG                                             
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                 SET VALID-ACCOUNT     TO TRUE                          
               WHEN NOT-FOUND                                           
                 CONTINUE                                               
               WHEN OTHER                                               
                 STRING 'CHECKING IF AN A/C IS CIS ACCOUNT    **'       
                         DELIMITED BY SIZE                              
                         INTO WS-ERR-MSG                                
                 STRING 'ACCOUNT NO    '                                
                         DELIMITED BY SIZE                              
                         WS-ACCOUNT-NO  DELIMITED BY SIZE               
                         INTO  WS-ERR-MSG2                              
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-EVALUATE                                                 
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  CHECK WHETHER ACCOUNT EXIST IN XREF ACCOUNT TABLE           **        
      **                                                              **        
      ******************************************************************        
       7200-GET-OLD-ACCOUNT.                                            
      *---------------------*                                                   
                                                                        
           MOVE '7200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT :WS-Y                                               
                   ,NEW_ACCOUNT_NO                                      
               INTO :WS-EXISTS-FLAG                                     
                   ,:XR-NEW-ACCOUNT-NO                                  
               FROM CSS_XREF_ACCT WITH(READUNCOMMITTED)                         
              WHERE OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO                 
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT :WS-Y                                                       
MFA-TR*            ,NEW_ACCOUNT_NO                                              
MFA-TR*        INTO :WS-EXISTS-FLAG                                             
MFA-TR*            ,:XR-NEW-ACCOUNT-NO                                          
MFA-TR*        FROM CSS_XREF_ACCT                                               
MFA-TR*       WHERE OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                 SET VALID-ACCOUNT         TO TRUE                      
                 MOVE XR-NEW-ACCOUNT-NO    TO AT-ACCOUNT-NO             
               WHEN MULTIPLE-ROWS-SELECTED                              
                 SET MULTIPLE-OLD-ACCOUNTS TO TRUE                      
               WHEN NOT-FOUND                                           
A02388           PERFORM 7210-CHECK-ARCHIVED-ACCTS THRU 7210-EXIT       
A02388           IF WS-ARCHIVE-FLAG = 'Y'                               
A02388              SET ACCOUNT-IS-ARCHIVED TO TRUE                     
A02388           ELSE                                                   
                    SET ACCOUNT-NOT-FOUND   TO TRUE                     
A02388           END-IF                                                 
               WHEN OTHER                                               
                 STRING 'CHECKING IF AN A/C IS OLD CIS ACCOUNT  **'     
                         DELIMITED BY SIZE                              
                         INTO WS-ERR-MSG                                
                 STRING 'ACCOUNT NO '  DELIMITED BY SIZE                
                         WS-ACCOUNT-NO DELIMITED BY SIZE                
                         INTO  WS-ERR-MSG2                              
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-EVALUATE                                                 
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02388******************************************************************        
A02388**  CHECK IF THE ACCOUNT IS ARCHIVED IN HST_ACCOUNT TABLE       **        
A02388******************************************************************        
A02388 7210-CHECK-ARCHIVED-ACCTS.                                       
A02388     MOVE '7210' TO WS-ACTIVE-PARAGRAPH.                          
A02388*                                                                         
A02388     EXEC SQL                                                     
A02388       SELECT :WS-Y,                                              
A02388              ACCT_XFER_TO                                        
A02388         INTO :WS-ARCHIVE-FLAG,                                   
A02388              :HA-ACCT-XFER-TO                                    
A02388         FROM HST_ACCOUNT WITH(READUNCOMMITTED)                           
A02388        WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                         
A02388                                                           
A02388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT :WS-Y,                                                      
MFA-TR*             ACCT_XFER_TO                                                
MFA-TR*        INTO :WS-ARCHIVE-FLAG,                                           
MFA-TR*             :HA-ACCT-XFER-TO                                            
MFA-TR*        FROM HST_ACCOUNT                                                 
MFA-TR*       WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02388                                                                  
A02388     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A02388        CONTINUE                                                  
A02388     ELSE                                                         
A02388        STRING 'CHECKING IF AN A/C IS ARCHIVED  **'               
A02388               DELIMITED BY SIZE                                  
A02388               INTO WS-ERR-MSG                                    
A02388        STRING 'ACCOUNT NO '  DELIMITED BY SIZE                   
A02388               WS-ACCOUNT-NO DELIMITED BY SIZE                    
A02388               INTO  WS-ERR-MSG2                                  
A02388        PERFORM 8800-DIS-TABLE-ERROR THRU 8800-EXIT               
A02388     END-IF.                                                      
A02388                                                                  
A02388 7210-EXIT.                                                       
A02388     EXIT.                                                        
A02388*                                                                         
      ******************************************************************        
      **  OPEN EDI HEADER CURSOR                                      **        
      **                                                              **        
      ******************************************************************        
       7300-OPEN-EDI-HDR.                                               
      *------------------*                                                      
           MOVE '7300'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                OPEN EDI_HDR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING EDI_HDR CURSOR **'                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  FETCH EDI HEADER CURSOR                                     **        
      **                                                              **        
      ******************************************************************        
       7310-FETCH-EDI-HDR.                                              
      *-------------------*                                                     
           MOVE '7310'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              FETCH EDI_HDR                                             
               INTO :JH-DEBIT-CREDIT-CD                                 
                   ,:JH-EDI-COMPANY-ID                                  
T30775             ,:JH-PAYER-NM                                        
                   ,:JH-TOTAL-PYMT-AM                                   
                   ,:JH-TRANSACTION-TS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR FETCHING EDI_HDR CURSOR **'                
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  CLOSE EDI HEADER CURSOR                                     **        
      **                                                              **        
      ******************************************************************        
       7320-CLOSE-EDI-HDR.                                              
      *-------------------*                                                     
           MOVE '7320'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                CLOSE EDI_HDR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR CLOSING EDI_HDR CURSOR **'                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  UPDATE EXTARCT FLAG AND VALID CIS FLAG IN HEADER TABLE      **        
      **                                                              **        
      ******************************************************************        
       7350-UPDATE-EDI-HDR.                                             
      *--------------------*                                                    
           MOVE '7350'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_EDI_PYMT_HDR                                    
                SET EXTRACT_DT     = CAST(SYSDATETIMEOFFSET() AS DATE)          
                   ,EXTRACT_FL     = 'Y'                                
                   ,VALID_CIS_FL   = :JH-VALID-CIS-FL                   
              WHERE TRANSACTION_TS = CIS.CHAR2TIMESTAMP(
                                                     :JH-TRANSACTION-TS
              )                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_EDI_PYMT_HDR                                            
MFA-TR*         SET EXTRACT_DT     = CURRENT DATE                               
MFA-TR*            ,EXTRACT_FL     = 'Y'                                        
MFA-TR*            ,VALID_CIS_FL   = :JH-VALID-CIS-FL                           
MFA-TR*       WHERE TRANSACTION_TS = :JH-TRANSACTION-TS                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR FETCHING EDI_HDR CURSOR **'                
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              STRING '** UPDATING VALID CIS FLAG AND EXTRACT FLAG '     
                      DELIMITED BY SIZE                                 
                     ' IN CSS_EDI_PYMT_HDR TABLE   **'                  
                      DELIMITED BY SIZE                                 
                      INTO WS-ERR-MSG                                   
              STRING 'TRANSACTION TS' DELIMITED BY SIZE                 
                      JH-TRANSACTION-TS DELIMITED BY SIZE               
                      INTO  WS-ERR-MSG2                                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  OPEN EDI DETAIL CURSOR                                      **        
      **                                                              **        
      ******************************************************************        
       7400-OPEN-EDI-DET.                                               
      *------------------*                                                      
           MOVE '7400'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                OPEN EDI_DET                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING EDI_DET CURSOR **'                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  FETCH EDI DETAIL CURSOR                                     **        
      **                                                              **        
      ******************************************************************        
       7410-FETCH-EDI-DET.                                              
      *-------------------*                                                     
           MOVE '7410'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           MOVE SPACES                 TO JD-TRAN-COMMENT-TEXT          
                                                                        
           EXEC SQL                                                     
              FETCH EDI_DET                                             
               INTO :JD-DEBIT-CREDIT-CD                                 
                   ,:JD-PAYMENT-AM                                      
                   ,:JD-REF-CUST-ACCT-NO                                
                   ,:JD-SEQUENCE-NO                                     
                   ,:JD-TRAN-COMMENT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR FETCHING EDI_DET CURSOR **'                
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  CLOSE EDI DETAIL CURSOR                                     **        
      **                                                              **        
      ******************************************************************        
       7420-CLOSE-EDI-DET.                                              
      *-------------------*                                                     
           MOVE '7420'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                CLOSE EDI_DET                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR CLOSING EDI_DET CURSOR **'                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  OPEN EDI COMPANY ACCOUNT TABLE CURSOR                       **        
      **                                                              **        
      ******************************************************************        
       7500-OPEN-EDI-ACCT.                                              
      *-------------------*                                                     
           MOVE '7500'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                OPEN EDI_ACCT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING EDI_ACCT CURSOR **'                
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  FETCH EDI COMPANY ACCOUNT TABLE CURSOR                      **        
      **                                                              **        
      ******************************************************************        
       7510-FETCH-EDI-ACCT.                                             
      *--------------------*                                                    
           MOVE '7510'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              FETCH EDI_ACCT                                            
               INTO :IK-ACCOUNT-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR FETCHING EDI_ACCT CURSOR **'               
                                             DELIMITED BY SIZE          
                                             INTO WS-ERR-MSG            
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  CLOSE EDI COMPANY ACCOUNT TABLE CURSOR                      **        
      **                                                              **        
      ******************************************************************        
       7520-CLOSE-EDI-ACCT.                                             
      *--------------------*                                                    
           MOVE '7520'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                CLOSE EDI_ACCT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR CLOSING EDI_ACCT CURSOR **'                
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  CHECK WHETHER ACCOUNT NO AND COMPANY ID EXIST IN COMPANY    **        
      **  ACCOUNT TABLE                                               **        
      **                                                              **        
      ******************************************************************        
       7530-SELECT-EDI-ACCT.                                            
      *---------------------*                                                   
                                                                        
           MOVE '7530'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             SELECT ACCOUNT_NO                                          
               INTO :IK-ACCOUNT-NO                                      
               FROM CSS_EDI_COMP_ACCT WITH(READUNCOMMITTED)                     
              WHERE EDI_COMPANY_ID = :IK-EDI-COMPANY-ID                 
                AND ACCOUNT_NO     = :IK-ACCOUNT-NO                     
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT ACCOUNT_NO                                                  
MFA-TR*        INTO :IK-ACCOUNT-NO                                              
MFA-TR*        FROM CSS_EDI_COMP_ACCT                                           
MFA-TR*       WHERE EDI_COMPANY_ID = :IK-EDI-COMPANY-ID                         
MFA-TR*         AND ACCOUNT_NO     = :IK-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING '** CHECKING IF ACCOUNT NO AND COMPANY ID ARE'     
                      DELIMITED BY SIZE                                 
                     ' EXISTING IN CSS_EDI_COMP_ACCT TABLE **'          
                      DELIMITED BY SIZE                                 
                      INTO WS-ERR-MSG                                   
              STRING 'ACCOUNT NO    '   DELIMITED BY SIZE               
                      WS-ACCOUNT-NO     DELIMITED BY SIZE               
                     'EDI COMPANY ID'   DELIMITED BY SIZE               
                      IK-EDI-COMPANY-ID DELIMITED BY SIZE               
                      INTO  WS-ERR-MSG2                                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  GET THE COMPANY DESCRIPTION OF THE CUSTOMER                 **        
      **                                                              **        
      ******************************************************************        
       7700-GET-COMP-DESC.                                              
      *-------------------*                                                     
                                                                        
           MOVE '7700'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             SELECT EDI_COMPANY_DESC                                    
               INTO :IB-EDI-COMPANY-DESC                                
               FROM CSS_EDI_COMPANY WITH(READUNCOMMITTED)                       
              WHERE EDI_COMPANY_ID = :IB-EDI-COMPANY-ID                 
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT EDI_COMPANY_DESC                                            
MFA-TR*        INTO :IB-EDI-COMPANY-DESC                                        
MFA-TR*        FROM CSS_EDI_COMPANY                                             
MFA-TR*       WHERE EDI_COMPANY_ID = :IB-EDI-COMPANY-ID                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING '** SELECTING EDI COMPANY DESCRIPTION '            
                      DELIMITED BY SIZE                                 
                     'IN CSS_EDI_COMPANY TABLE **'                      
                      DELIMITED BY SIZE                                 
                      INTO WS-ERR-MSG                                   
              STRING 'EDI COMPANY ID'   DELIMITED BY SIZE               
                      IB-EDI-COMPANY-ID DELIMITED BY SIZE               
                      INTO  WS-ERR-MSG2                                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  GET THE APPL PROGRAM DESCRIPTION                            **        
      **                                                              **        
      ******************************************************************        
       7800-GET-APPL-DESC.                                              
      *-------------------*                                                     
                                                                        
           MOVE '7600'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             SELECT APPL_PROGRAM_DESC                                   
               INTO :K9-APPL-PROGRAM-DESC                               
               FROM CSS_APPL_PGM_DESC WITH(READUNCOMMITTED)                     
              WHERE APPL_PROGRAM_ID  = :K9-APPL-PROGRAM-ID              
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT APPL_PROGRAM_DESC                                           
MFA-TR*        INTO :K9-APPL-PROGRAM-DESC                                       
MFA-TR*        FROM CSS_APPL_PGM_DESC                                           
MFA-TR*       WHERE APPL_PROGRAM_ID  = :K9-APPL-PROGRAM-ID                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING '** GET REPORT NAME FROM CSS_APPL_PGM_DESC **'     
                      DELIMITED BY SIZE                                 
                      INTO WS-ERR-MSG                                   
              STRING 'APPL PROGRAM ID  ' DELIMITED BY SIZE              
                      K9-APPL-PROGRAM-ID DELIMITED BY SIZE              
                      INTO  WS-ERR-MSG2                                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   7900-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7900-GET-COMPANY-DESC.                                           
      *----------------------*                                                  
                                                                        
           MOVE '7900'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             SELECT COMPANY_NAME                                        
               INTO :C7-COMPANY-NAME                                    
               FROM CSS_COMPANY WITH(READUNCOMMITTED)                           
              WHERE COMPANY_NO = :C7-COMPANY-NO                         
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NAME                                                
MFA-TR*        INTO :C7-COMPANY-NAME                                            
MFA-TR*        FROM CSS_COMPANY                                                 
MFA-TR*       WHERE COMPANY_NO = :C7-COMPANY-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE C7-COMPANY-NAME    TO P-RPT1-COMP-NAME               
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES         TO P-RPT1-COMP-NAME                
              ELSE                                                      
                 STRING '** GET COMPANY NAME FROM CSS_COMPANY   **'     
                      DELIMITED BY SIZE                                 
                      INTO WS-ERR-MSG                                   
                 STRING 'COMPANY NO  ' DELIMITED BY SIZE                
                      C7-COMPANY-NO    DELIMITED BY SIZE                
                      INTO  WS-ERR-MSG2                                 
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           END-IF                                                       
           .                                                            
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01346****************************************************************          
A01346**   7910-SELECT-CODE-VALUE                                   **          
      **     SELECTS CODE VALUE FOR GIVEN VALUES                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7910-SELECT-CODE-VALUE.                                          
      *-----------------------*                                                 
                                                                        
           MOVE '7910'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             SELECT CODE_VALUE                                          
               INTO :UV-CODE-VALUE                                      
               FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
              WHERE TABLE_NA    = :UV-TABLE-NA                          
                AND COLUMN_NA   = :UV-COLUMN-NA                         
                AND PROGRAM_ID  = 'PCSAC177'                            
                AND COMPANY_NO  = '01'                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CODE_VALUE                                                  
MFA-TR*        INTO :UV-CODE-VALUE                                              
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE TABLE_NA    = :UV-TABLE-NA                                  
MFA-TR*         AND COLUMN_NA   = :UV-COLUMN-NA                                 
MFA-TR*         AND PROGRAM_ID  = 'PCSAC177'                                    
MFA-TR*         AND COMPANY_NO  = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF UV-CODE-VALUE-TEXT(1:8) = 'PYMT REJ'                   
                 SET PAYMENT-REJECTED  TO TRUE                          
              ELSE                                                      
                 SET BATCH-REJECTED    TO TRUE                          
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 SET BATCH-REJECTED    TO TRUE                          
              ELSE                                                      
                 STRING '** SELECT CODE VALUE FROM CSS_CODE_VALUE  **'  
                      DELIMITED BY SIZE                                 
                      INTO WS-ERR-MSG                                   
                 STRING 'COLUMN NAME = ' DELIMITED BY SIZE              
                      UV-COLUMN-NA-TEXT  DELIMITED BY SIZE              
                       ',TABLE NAME  = ' DELIMITED BY SIZE              
                      UV-TABLE-NA-TEXT   DELIMITED BY SIZE              
                       ',PROGRAM ID = PCSAC177 '                        
                                         DELIMITED BY SIZE              
                       ',COMPANY NO = 01' DELIMITED BY SIZE             
                      INTO  WS-ERR-MSG2                                 
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           END-IF                                                       
           .                                                            
A01346 7910-EXIT.                                                       
A01346     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  WRITE PAYMENT FILE                                          **        
      **                                                              **        
      ******************************************************************        
       8000-WRITE-FCSAC01.                                              
      *-------------------*                                                     
           MOVE '8000'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           IF DETAIL-RECORD                                             
              MOVE WS-DETAIL-REC(WS-SUB1) TO WS-DET-RECORD              
              WRITE DETAIL-REC FROM WS-DET-RECORD                       
              MOVE SPACES TO WS-DET-RECORD                              
           ELSE                                                         
              WRITE BATCH-TOTAL-REC FROM WS-BATCH-TOTAL-REC             
           END-IF                                                       
                                                                        
           IF WS-FAC01-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              STRING '** FILE WRITE ERROR FCSAC01 **'                   
                                                    DELIMITED BY SIZE   
              WS-FAC01-STATUS                       DELIMITED BY SIZE   
                                            INTO    WS-ERR-MSG          
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  INSERT NEW ACCOUNT NO AND COMPANY ID IN THE COMPANY ACCOUNT **        
      **  TABLE                                                       **        
      **                                                              **        
      ******************************************************************        
       8100-INSERT-EDI-ACCT.                                            
      *---------------------*                                                   
                                                                        
           MOVE '8100'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_EDI_COMP_ACCT                              
                    ( ACCOUNT_NO                                        
                     ,EDI_COMPANY_ID                                    
                     ,LAST_UPDATE_TS                                    
                     ,LAST_UPDATE_USERID )                              
             VALUES (                                                   
                     :IK-ACCOUNT-NO                                     
                     ,:IK-EDI-COMPANY-ID                                
                     ,CIS.CURRENT$TIMESTAMP()                                 
                     ,'SYSTEM' )                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_EDI_COMP_ACCT                                      
MFA-TR*             ( ACCOUNT_NO                                                
MFA-TR*              ,EDI_COMPANY_ID                                            
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,LAST_UPDATE_USERID )                                      
MFA-TR*      VALUES (                                                           
MFA-TR*              :IK-ACCOUNT-NO                                             
MFA-TR*              ,:IK-EDI-COMPANY-ID                                        
MFA-TR*              ,CURRENT TIMESTAMP                                         
MFA-TR*              ,'SYSTEM' )                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             STRING 'ERROR INSERTING INTO CSS_EDI_COMP_ACCT  **'        
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
             STRING 'ACCOUNT NO    '     DELIMITED BY SIZE              
                     WS-ACCOUNT-NO       DELIMITED BY SIZE              
                    'EDI COMPANY ID'     DELIMITED BY SIZE              
                     IK-EDI-COMPANY-ID   DELIMITED BY SIZE              
                                         INTO  WS-ERR-MSG2              
             PERFORM 8800-DIS-TABLE-ERROR                               
                THRU 8800-EXIT                                          
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  UPDATE JOB PARM TABLE WITH LAST BATCH NO AND RUN DATE       **        
      **                                                              **        
      ******************************************************************        
       8150-UPDATE-JOB-PARM.                                            
      *---------------------*                                                   
                                                                        
           MOVE '8150'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_JOB_PARM                                        
                SET PARM_DATA    = :G6-PARM-DATA                        
              WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                     
                AND COMPANY_NO   = :G6-COMPANY-NO                       
                AND CMND_CODE    = :G6-CMND-CODE                        
                AND SEQ_NO       = :G6-SEQ-NO                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
             STRING 'ERROR UPDATING CSS_JOB_PARM TABLE       **'        
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
             STRING 'PROGRAM NAME  '     DELIMITED BY SIZE              
                     G6-PROGRAM-NAME     DELIMITED BY SIZE              
                    ', COMPANY NO  '     DELIMITED BY SIZE              
                     G6-COMPANY-NO       DELIMITED BY SIZE              
                    ', CMND CODE '       DELIMITED BY SIZE              
                     G6-CMND-CODE        DELIMITED BY SIZE              
                                         INTO  WS-ERR-MSG2              
             PERFORM 8800-DIS-TABLE-ERROR                               
                THRU 8800-EXIT                                          
           END-IF                                                       
           .                                                            
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** PRINTS THE HEADER FOR REPORT PCSAC177                      **          
      **                                                            **          
      ****************************************************************          
       8200-PRINT-HEADER.                                               
                                                                        
           MOVE '8200'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 8300-PRINT-COMP-NAME   THRU 8300-EXIT.               
           PERFORM 8400-PRINT-TITLE       THRU 8400-EXIT.               
                                                                        
           IF PAYMENT-REPORT                                            
              WRITE PRT331-RECORD FROM WS-RPT2-HEADER-3                 
                 AFTER ADVANCING WS-2 LINES                             
              WRITE PRT331-RECORD FROM WS-LINE                          
                 AFTER ADVANCING WS-1 LINE                              
              WRITE PRT331-RECORD FROM WS-BLANK-LINE                    
                 AFTER ADVANCING WS-1 LINE                              
              ADD WS-5                 TO WS-RPT2-LINE-NO               
A02388     END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      ** PRINTS THE COMPANY NAME FOR REPORT PCSAC177                **          
      **                                                            **          
      ****************************************************************          
       8300-PRINT-COMP-NAME.                                            
                                                                        
           MOVE '8300'                 TO WS-ACTIVE-PARAGRAPH           
                                                                        
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM             
                                                                        
           IF PAYMENT-REPORT                                            
              ADD WS-1                 TO WS-RPT2-PAGE-NO               
              WRITE PRT331-RECORD FROM WS-RPT1-TITLE                    
                 AFTER ADVANCING TOP-OF-PAGE                            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  PRINTS THE TITLE FOR REPORT PCSAC177                      **          
      **                                                            **          
      ****************************************************************          
       8400-PRINT-TITLE.                                                
                                                                        
           MOVE '8400'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           IF PAYMENT-REPORT                                            
              MOVE WS-PYMT-RPT-NAME    TO P-RPT1-HEAD-1                 
              WRITE PRT331-RECORD FROM WS-RPT1-HEADER-1                 
                 AFTER ADVANCING WS-1 LINE                              
                                                                        
              MOVE WS-RPT2-PAGE-NO     TO P-RPT1-PAGE-NO                
                                                                        
              WRITE PRT331-RECORD FROM WS-RPT1-HEADER-2                 
                 AFTER ADVANCING WS-1 LINE                              
                                                                        
              MOVE WS-3                TO WS-RPT2-LINE-NO               
A02388     END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   PRINTS THE TOTALS FOR THE REPORT PCSAC177                **          
      **                                                            **          
      ****************************************************************          
       8500-PRINT-TOTAL-LINES.                                          
      *                                                                         
           MOVE '8500'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           IF PAYMENT-REPORT                                            
              WRITE PRT331-RECORD FROM WS-TOTAL-LINE-1                  
                 AFTER ADVANCING  WS-2 LINES                            
              WRITE PRT331-RECORD FROM WS-TOTAL-LINE-2                  
                 AFTER ADVANCING  WS-1 LINE                             
              WRITE PRT331-RECORD FROM WS-TOTAL-LINE-3                  
                 AFTER ADVANCING  WS-1 LINE                             
              WRITE PRT331-RECORD FROM WS-BLANK-LINE                    
                 AFTER ADVANCING  WS-1 LINE                             
                                                                        
              WRITE PRT331-RECORD FROM WS-END-DATA-LINE                 
                 AFTER ADVANCING WS-2 LINE                              
A02388     END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   PRINT THE DETAILS FOR THE REPORT PCSAC177                **          
      **                                                            **          
      ****************************************************************          
       8600-PRINT-DETAIL-LINE.                                          
                                                                        
           MOVE '8600'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           IF PAYMENT-REPORT                                            
              WRITE PRT331-RECORD FROM WS-RPT2-DETAIL-1                 
                 AFTER ADVANCING WS-1 LINE                              
                                                                        
              MOVE SPACES              TO WS-RPT2-DETAIL-1              
              ADD WS-1                 TO WS-RPT2-LINE-NO               
                                                                        
           ELSE                                                         
              IF WS-FCSAC27-FIRST-REC EQUAL 'Y'                         
ACT262           MOVE WS-RPT1-DETAIL-HDR  TO FCSAC27-OUT-REC            
ACT262           WRITE FCSAC27-OUT-REC                                  
ACT262           INITIALIZE WS-RPT1-DETAIL-HDR                          
ACT262           MOVE 'N'                 TO WS-FCSAC27-FIRST-REC       
ACT262        END-IF                                                    
A02388        MOVE WS-RPT1-DETAIL      TO FCSAC27-OUT-REC               
A02388        WRITE FCSAC27-OUT-REC                                     
ACT262        INITIALIZE WS-RPT1-DETAIL                                 
A02388     END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  DISPLAY TABLE ERROR                                         **        
      **                                                              **        
      ******************************************************************        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'.    
           DISPLAY '**     PCSAC177 PROCESSING ERROR            **'.    
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'.    
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE.           
           DISPLAY '**       PROCESSING TERMINATED              **'.    
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **  DISPLAY ERROR                                               **        
      **                                                              **        
      ******************************************************************        
       8900-DISPLAY-ERR-TERM.                                           
      *---------------------*                                                   
           DISPLAY '                                          '.        
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSAC177 PROCESSING ERROR        **'.        
           DISPLAY '******************************************'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**       PROCESSING TERMINATED          **'.        
           DISPLAY '******************************************'.        
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  CLOSES THE PAYMENT FILE AND ERROR REPORT                    **        
      **       NORMAL TERMINATION OF THE PROGRAM                      **        
      ******************************************************************        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH.        
           CLOSE FCSAC01-FILE.                                          
                                                                        
           IF WS-FAC01-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              STRING  'CLOSE ERROR- BANCTEC INPUT FILE'                 
                                         DELIMITED BY SIZE              
                      'FILE STATUS = '   DELIMITED BY SIZE              
                       WS-FAC01-STATUS   DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              DISPLAY '**' WS-ERR-MSG                                   
           END-IF                                                       
                                                                        
A02388     CLOSE FCSAC27-FILE                                           
                                                                        
           CLOSE FCSPT331-FILE                                          
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
