       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSAC176.                                         
       DATE-WRITTEN.  02/24/03.                                         
       DATE-COMPILED.                                                   
       AUTHOR.        RICK SPIRES                                       
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      *                   PCSAC176   NARRATIVE                        *         
      *                                                               *         
      * THIS PROGRAM READS THE EDI 820 FILE FROM THE BANK AND PARSES  *         
      * FOR EACH FIELD THROUGH EACH RECORD TYPE AND INSERT THE RESULTS*         
      * INTO TABLES CSS_EDI_PYMT_HDR AND CSS_EDI_PYMT_DET.            *         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **   DATE     INITIALS       REASON                            **         
      ** 05/16/03  R. SPIRES      FIX SOC7 WITH .9 COMING IN ON BPR. **         
      ** 05/21/03  R. SPIRES      FIX ERRORS WITH BPR-PYMT-DATE.     **         
      ** 03/01/04  R. SPIRES      ADD PROCESSING FOR NM1 RECORD.     **         
      ** 03/10/04  R. SPIRES      FIX HEADER TOTAL PYMT AMOUNT.      **         
T35434** 03/01/07  COVANSYS       REPLACED CSS_MODEL_SQL WITH SET    **         
T35434**                          STATEMENT.                         **         
A00950** 05/19/09  R. SPIRES      ADD HOLIDAY CHECK FOR DATE ERROR.  **         
      *****************************************************************         
                                                                        
                                                                        
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 3999     PARSING ROUTINES                        
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
           SELECT EDI820-FILE                                           
             ASSIGN  TO EDI820I                                         
               FILE STATUS IS WS-EDI820-STATUS.                         
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       COPY CFDPT33.                                                            
                                                                        
       FD  EDI820-FILE                                                  
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  EDI-REC                          PIC X(165).                 
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC176'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-SWITCHES.                                                 
                                                                        
           05  WS-EDI820-STATUS             PIC X(02).                  
               88 EDI820-SUCCESSFUL                    VALUE '00'.      
           05  WS-EDI820-EOF-SW             PIC X(01)  VALUE 'N'.       
               88  END-OF-EDI820-FILE                  VALUE 'Y'.       
               88  PROCESS-EDI820                      VALUE 'N'.       
           05  WS-PROCESS-TYPE-SW           PIC  X(01) VALUE SPACES.    
               88  PROCESS-HEADER                VALUE 'H'.             
               88  PROCESS-DETAIL                VALUE 'D'.             
               88  PROCESS-TRAILER               VALUE 'T'.             
           05  WS-DATA-SW                   PIC  X(01) VALUE SPACES.    
               88  VALID-DATA                    VALUE 'D'.             
               88  NO-DATA                       VALUE 'N'.             
           05  WS-PROCESS-DATE-SW           PIC  X(01) VALUE SPACES.    
               88  SKIP-DATE                     VALUE 'S'.             
               88  PROCESS-DATE                  VALUE ' '.             
           05  WS-PARSE-SW                  PIC  X(01) VALUE SPACES.    
               88  ASTERISK-FND                  VALUE 'A'.             
               88  START-SRCH                    VALUE 'S'.             
           05  WS-DECIMAL-SW                PIC  X(01) VALUE SPACES.    
               88  DECIMAL-FND                   VALUE 'D'.             
               88  DECIMAL-SRCH                  VALUE ' '.             
RS0301     05  WS-NUMERIC-SW                PIC  X(01) VALUE SPACES.    
RS0301         88  FIND-NUM                      VALUE 'F'.             
RS0301         88  FOUND-NUM                     VALUE 'N'.             
RS0301     05  WS-NM1-REC-SW                PIC  X(01) VALUE SPACES.    
RS0301         88  NM1-REC-FND                   VALUE 'F'.             
RS0301         88  NO-NM1-REC                    VALUE 'N'.             
           05  WS-SEGMENT-SW                PIC  X(01) VALUE SPACES.    
               88  SEGMENT-ERROR                 VALUE 'E'.             
               88  NO-SEG-ERROR                  VALUE ' '.             
           05  WS-FCSPT33-STATUS             PIC X(02)  VALUE '00'.     
               88  FCSPT33-SUCCESSFUL                   VALUE '00'.     
A00950     05  WS-EXISTS-FL                  PIC X(01) VALUE ' '.       
       01  WS-MISC.                                                     
           05  WS-SYSIN-COMP-NO              PIC X(02)  VALUE SPACES.   
           05  WS-EDI-LKB-IND                PIC X(03)  VALUE SPACES.   
           05  WS-HOLD-FILE-TYPE             PIC X(03)  VALUE SPACES.   
           05  WS-DISP-RC                    PIC -ZZZZZZZZ9.9.          
           05  WS-MAX-LINES                  PIC 9(02)  VALUE 56.       
           05  WS-LINE-COUNT                 PIC 9(02)  VALUE 57.       
           05  WS-TEMP-COUNT                 PIC 9(02).                 
           05  WS-PAGE-COUNT                 PIC 9(05)  VALUE 0.        
           05  WS-ERR-MSG                    PIC X(60)  VALUE SPACES.   
           05  WS-REPTNAME                   PIC X(10)  VALUE           
                                                          'PCSA1761'.   
           05  WS-PROCESS-SW                 PIC 9(01)  VALUE 1.        
               88  PROCESS-CSR                          VALUE 1.        
               88  PROCESS-SEB                          VALUE 2.        
           05  WS-COMMON-DATE               PIC X(10).                  
           05  WS-PROCESS-DATE              PIC X(08).                  
           05  WS-COUNTER                   PIC 9(03)  VALUE ZEROES.    
           05  WS-CODE-DR-CR                PIC X(01)  VALUE 'C'.       
           05  WS-PGRMNAME                  PIC X(10)  VALUE 'PCSAC176'.
           05  WS-PGMNAME                   PIC X(08)  VALUE 'PCSAC176'.
           05  ACTIVE-PARAGRAPH             PIC X(04)  VALUE '0100'.    
           05  WS-NO                        PIC X(01)  VALUE 'N'.       
           05  WS-YES                       PIC X(01)  VALUE 'Y'.       
           05  WS-N                         PIC X(01)  VALUE 'N'.       
           05  WS-Y                         PIC X(01)  VALUE 'Y'.       
           05  WS-1                         PIC 9(01)  VALUE 1.         
           05  WS-CNT-CREDITS               PIC S9(09) VALUE ZERO.      
           05  WS-CNT-DEBITS                PIC S9(09) VALUE ZERO.      
           05  WS-TOT-AMT-CR                PIC S9(09)V99               
                                                       VALUE ZERO.      
           05  WS-TOT-AMT-DB                PIC S9(09)V99               
                                                       VALUE ZERO.      
           05  WS-AMOUNT                    PIC S9(09)V99               
                                                       VALUE ZERO.      
           05  WS-AMOUNT-NO-DEC REDEFINES WS-AMOUNT                     
                                            PIC 9(11).                  
RS0301     05  WS-TOTAL                     PIC S9(09)V99               
RS0301                                                 VALUE ZERO.      
RS0301     05  WS-TOT-AMT                   PIC 9(09)V99                
RS0301                                                 VALUE ZERO.      
RS0301     05  WS-TOT-AMT-X REDEFINES WS-TOT-AMT                        
RS0301                                      PIC X(11).                  
RS0301     05  WS-ALPHA-TOT                 PIC X(11).                  
           05  WS-NO-OF-SEGS                PIC 9(04) VALUE ZERO.       
           05  WS-NO-OF-SEGS-X REDEFINES                                
               WS-NO-OF-SEGS                PIC X(04).                  
           05  WS-EDI-REC.                                              
               10  WS-EDI-REC-ID            PIC X(03).                  
               10  WS-EDI-REST-OF-REC       PIC X(817).                 
                                                                        
           05  WS-PAYEE-NAME                PIC X(60)  VALUE SPACES.    
           05  WS-PAYOR-NAME                PIC X(60)  VALUE SPACES.    
           05  WS-RETURN-DATA               PIC X(80)  VALUE SPACES.    
           05  WS-SAVE-REF-NO               PIC X(30)  VALUE SPACES.    
           05  WS-BXFER-DATE.                                           
               10  WS-BXFER-DATE-DD         PIC 9(2).                   
               10  FILLER                   PIC X(01)  VALUE '-'.       
               10  WS-BXFER-DATE-MM         PIC X(3).                   
               10  FILLER                   PIC X(01)  VALUE '-'.       
               10  WS-BXFER-DATE-YY         PIC 9(2).                   
           05  WS-INVOICE-DATE.                                         
               10  WS-INV-DATE-CC           PIC 9(2).                   
               10  WS-INV-DATE-YY           PIC 9(2).                   
               10  FILLER                   PIC X(01)  VALUE '-'.       
               10  WS-INV-DATE-MM           PIC 9(2).                   
               10  FILLER                   PIC X(01)  VALUE '-'.       
               10  WS-INV-DATE-DD           PIC 9(2).                   
           05  WS-PYMT-DATE.                                            
               10  WS-PYMT-DATE-CCYY        PIC 9(4).                   
               10  FILLER                   PIC X(01)  VALUE '-'.       
               10  WS-PYMT-DATE-MM          PIC 9(2).                   
               10  FILLER                   PIC X(01)  VALUE '-'.       
               10  WS-PYMT-DATE-DD          PIC 9(2).                   
           05  WS-CUR-TS                    PIC  X(26) VALUE SPACES.    
           05  WS-CUR-DATE                  PIC  X(10) VALUE SPACES.    
           05  WS-SAVE-DATE                 PIC  X(10) VALUE SPACES.    
           05  WS-PROCESS-SW2               PIC  X(01) VALUE 'Y'.       
               88  FIRST-TIME                    VALUE 'F'.             
               88  COMBINE-PROCESS               VALUE 'C'.             
               88  NEW-BATCH                     VALUE 'N'.             
           05  WS-RMR-SW                    PIC  X(01) VALUE 'N'.       
               88  NO-RMR                        VALUE 'N'.             
               88  FIRST-RMR                     VALUE 'F'.             
               88  SUBSEQUENT-RMR                VALUE 'C'.             
                                                                        
       01  WS-COMP-FIELDS                   USAGE COMP.                 
           05  WS-ONE                       PIC S9(4) VALUE +1.         
           05  WS-TWO                       PIC S9(4) VALUE +2.         
           05  WS-THREE                     PIC S9(4) VALUE +3.         
           05  WS-FOUR                      PIC S9(4) VALUE +4.         
           05  WS-FIVE                      PIC S9(4) VALUE +5.         
           05  WS-SIX                       PIC S9(4) VALUE +6.         
           05  WS-EIGHT                     PIC S9(4) VALUE +8.         
           05  WS-NINE                      PIC S9(4) VALUE +9.         
           05  WS-TEN                       PIC S9(4) VALUE +10.        
RS0301     05  WS-ELEVEN                    PIC S9(4) VALUE +11.        
           05  WS-TWELVE                    PIC S9(4) VALUE +12.        
           05  WS-FIFTEEN                   PIC S9(4) VALUE +15.        
           05  WS-EIGHTEEN                  PIC S9(4) VALUE +18.        
           05  WS-TWENTY-FIVE               PIC S9(4) VALUE +25.        
           05  WS-THIRTY                    PIC S9(4) VALUE +30.        
           05  WS-THIRTY-FIVE               PIC S9(4) VALUE +35.        
           05  WS-SIXTY                     PIC S9(4) VALUE +60.        
           05  WS-EIGHTY                    PIC S9(4) VALUE +80.        
           05  WS-ST-LOC                    PIC S9(4) VALUE +1.         
           05  WS-CUR-LOC                   PIC S9(4) VALUE +1.         
           05  WS-MAX-LEN                   PIC S9(4) VALUE +1.         
           05  WS-FLD-LEN                   PIC S9(4) VALUE +1.         
RS0301     05  WS-ALPHA-LOC                 PIC S9(4) VALUE +1.         
RS0301     05  WS-NUM-LOC                   PIC S9(4) VALUE +1.         
           05  WS-DEC-LOC                   PIC S9(4) VALUE +1.         
           05  WS-DEC-LOC-P1                PIC S9(4) VALUE +1.         
           05  WS-DEC-LOC-P2                PIC S9(4) VALUE +1.         
           05  WS-JD-SEQUENCE               PIC S9(4) VALUE +1.         
           05  WS-COMMENT-LEN               PIC S9(4) VALUE +0.         
      ***************************************************************           
      *      WORKING STORAGE VARIABLES FOR REPORT HEADER            *           
      ***************************************************************           
       01  WS-HEADER-LINES.                                             
           05  WS-RPT-HEADER-1.                                         
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  P-RPT-TITLE-PGNM          PIC X(08).                 
               10  FILLER                    PIC X(51)  VALUE SPACES.   
               10  P-RPT-COMP-NAME           PIC X(15)  VALUE           
                   ' SCE&G / PSNC  '.                                   
               10  FILLER                    PIC X(40)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                       'RUN-DATE:'.     
               10  P-RPT-RUN-MM              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE '/'.      
               10  P-RPT-RUN-DD              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE '/'.      
               10  P-RPT-RUN-YY              PIC X(02).                 
                                                                        
           05  WS-RPT-HEADER-2.                                         
               10  FILLER                    PIC X(51)  VALUE SPACES.   
               10  FILLER                    PIC X(61)  VALUE           
                                 'ACCOUNTS PROCESSED USING EDI820'.     
               10  FILLER                    PIC X(04)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                      'RUN-TIME:'.      
               10  P-RPT-RUN-HH              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  P-RPT-RUN-MI              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  P-RPT-RUN-SS              PIC X(02).                 
      *                                                                         
           05  WS-RPT-HEADER-3.                                         
               10  FILLER                    PIC X(49)  VALUE SPACES.   
               10  FILLER                    PIC X(21)  VALUE           
                                 'WACHOVIA FILE DATE :'.                
               10  FILLER                    PIC X(04)  VALUE SPACES.   
               10  P-RPT-FILE-DATE           PIC X(10)  VALUE SPACES.   
               10  FILLER                    PIC X(31)  VALUE SPACES.   
               10  FILLER                    PIC X(13)  VALUE           
                                                        'PAGE    :'.    
               10  P-RPT-PAGE-NO             PIC ZZZZZ.                 
      *                                                                         
           05  WS-RPT-HEADER-4.                                         
               10  FILLER                    PIC X(133) VALUE SPACES.   
                                                                        
           05  WS-RPT-HEADER-5.                                         
               10  FILLER                    PIC X(07)  VALUE SPACES.   
               10  FILLER                    PIC X(10)  VALUE           
                                                 'ACCOUNT NO'.          
               10  FILLER                    PIC X(24)  VALUE SPACES.   
               10  FILLER                    PIC X(11)  VALUE           
                                                  'AMOUNT - DB'.        
               10  FILLER                    PIC X(13)  VALUE SPACES.   
               10  FILLER                    PIC X(11)  VALUE           
                                                  'AMOUNT - CR'.        
               10  FILLER                    PIC X(12)  VALUE SPACES.   
               10  FILLER                    PIC X(12)  VALUE           
                                                  'COMPANY NAME'.       
               10  FILLER                    PIC X(20)  VALUE SPACES.   
               10  FILLER                    PIC X(11)  VALUE           
                                                  'BANK DATE'.          
               10  FILLER                    PIC X(03)  VALUE SPACES.   
      *                                                                         
           05  WS-RPT-HEADER-6.                                         
               10  FILLER                    PIC X(133) VALUE ALL '='.  
                                                                        
      ***************************************************************           
      *      WORKING STORAGE VARIABLES FOR REPORT DETAILS           *           
      ***************************************************************           
                                                                        
       01  WS-RPT-DETAIL-LINE-1.                                        
           05 FILLER                           PIC X(02) VALUE SPACES.  
           05 WS-RPT-ACCT.                                              
              10 WS-RPT-ACCT1                  PIC X(01).               
              10 WS-RPT-DASH1                  PIC X(01) VALUE '-'.     
              10 WS-RPT-ACCT2                  PIC X(04).               
              10 WS-RPT-DASH2                  PIC X(01) VALUE '-'.     
              10 WS-RPT-ACCT3                  PIC X(04).               
              10 WS-RPT-DASH3                  PIC X(01) VALUE '-'.     
              10 WS-RPT-ACCT4                  PIC X(04).               
MAN001*       10 WS-RPT-ACCT5                  PIC X(12).
MAN001        10 WS-RPT-ACCT5                  PIC X(12) VALUE SPACES.
           05 FILLER                           PIC X(08) VALUE SPACES.  
           05 WS-RPT-EDI-AMT-DB                PIC ZZZ,ZZZ,ZZ9.99-.     
           05 FILLER                           PIC X(08) VALUE SPACES.  
           05 WS-RPT-EDI-AMT-CR                PIC ZZZ,ZZZ,ZZ9.99-.     
           05 FILLER                           PIC X(08) VALUE SPACES.  
           05 WS-RPT-COMPANY                   PIC X(30) VALUE SPACES.  
           05 FILLER                           PIC X(05) VALUE SPACES.  
           05 WS-RPT-BANK-DATE                 PIC X(10) VALUE SPACES.  
           05 FILLER                           PIC X(06) VALUE SPACES.  
                                                                        
       01  WS-RPT-TOTAL-LINE.                                           
           05 FILLER                           PIC X(02) VALUE SPACES.  
           05 WS-RPT-VERBIAGE                  PIC X(12) VALUE SPACES.  
           05 FILLER                           PIC X(24) VALUE SPACES.  
           05 WS-RPT-EDI-AMT-DB-TOT            PIC ZZZ,ZZZ,ZZ9.99-.     
           05 WS-RPT-EDI-CNT-DB-TOT REDEFINES  WS-RPT-EDI-AMT-DB-TOT    
                                               PIC ZZ,ZZZ,ZZZ,Z99-.     
           05 FILLER                           PIC X(08) VALUE SPACES.  
           05 WS-RPT-EDI-AMT-CR-TOT            PIC ZZZ,ZZZ,ZZ9.99-.     
           05 WS-RPT-EDI-CNT-CR-TOT REDEFINES  WS-RPT-EDI-AMT-CR-TOT    
                                               PIC ZZ,ZZZ,ZZZ,Z99-.     
           05 FILLER                           PIC X(49) VALUE SPACES.  
                                                                        
       01  WS-MSG-LINE.                                                 
           05 FILLER                         PIC X(02)  VALUE SPACES.   
           05 WS-RPT-MSG-OVSH                PIC X(130) VALUE SPACES.   
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                         PIC X(48)  VALUE SPACES.   
           05 FILLER                         PIC X(31)  VALUE           
               '****** NO DATA THIS RUN *******'.                       
           05 FILLER                         PIC X(44)  VALUE SPACES.   
                                                                        
       01  WS-FOOTER.                                                   
           05 FILLER                         PIC X(48)  VALUE SPACES.   
           05 FILLER                         PIC X(25)  VALUE           
               '* * * END OF REPORT * * *'.                             
           05 FILLER                         PIC X(60)  VALUE SPACES.   
                                                                        
       01  WS-SAVE-PRT33                     PIC X(133).                
                                                                        
      *                                                                         
       COPY EDI0820.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * WS FOR DATE ROUTINES                                          *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00018                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_JOB_PARM                                                  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_PYMT_DET                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPYMTDT                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_PYMT_HDR                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPYMTHD                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_COMPANY                                               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBIDDESC                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_COMPANY                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_DELIENQUENCY                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
A00950                                                                  
A00950*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
A00950* CSS_HOLIDAY                                                   *         
A00950*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
A00950                                                                  
A00950     EXEC SQL                                                             
A00950         INCLUDE TBHLDAY                                                  
A00950     END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      **                                                              **        
      **  0000-MAINLINE.                                              **        
      **       CONTROLS MAIN PATH OF PROGRAM                          **        
      **                                                              **        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT           
                   UNTIL END-OF-EDI820-FILE.                            
                                                                        
           PERFORM 8450-PRINT-RPT-FOOTER       THRU 8450-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   0100-INITIALIZATION.                                       **        
      **        INITIALIZATION ROUTINE                                **        
      **                                                              **        
      ******************************************************************        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT EDI820-FILE                                       
                OUTPUT FCSPT33-FILE.                                    
                                                                        
           IF FCSPT33-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-FCSPT33-STATUS         TO WS-DISP-RC              
              MOVE ' ERROR IN OPENING FCSPT33 FILE.'                    
                                             TO WS-ERR-MSG              
              PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
           END-IF.                                                      
                                                                        
                                                                        
           IF  EDI820-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-EDI820-STATUS            TO WS-DISP-RC            
              MOVE 'EDI820I FILE OPEN ERROR'   TO WS-ERR-MSG            
              PERFORM 9100-DISPLAY-ERROR       THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
      * GET COMMON DATE                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '                  TO WS-PGRMNAME           
              MOVE SPACES                      TO WS-INPUT-AREA         
              MOVE SPACES                      TO                       
                                           WS-INPUT-DATA-BREAKDOWN      
              PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT           
              MOVE WS-PGMNAME                  TO WS-PGRMNAME           
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE                  TO WS-COMMON-DATE.       
                                                                        
           MOVE WS-INPUT-DATE (1:4)            TO WS-PROCESS-DATE (1:4).
           MOVE WS-INPUT-DATE (6:2)            TO WS-PROCESS-DATE (5:2).
           MOVE WS-INPUT-DATE (9:2)            TO WS-PROCESS-DATE (7:2).
                                                                        
           PERFORM 7200-GET-CURRENT-TIMESTAMP  THRU 7200-EXIT.          
                                                                        
           MOVE WS-CUR-DATE (6:2)              TO P-RPT-RUN-MM.         
           MOVE WS-CUR-DATE (9:2)              TO P-RPT-RUN-DD.         
           MOVE WS-CUR-DATE (3:2)              TO P-RPT-RUN-YY.         
                                                                        
           MOVE WS-CUR-TS  (12:2)              TO P-RPT-RUN-HH.         
           MOVE WS-CUR-TS  (15:2)              TO P-RPT-RUN-MI.         
           MOVE WS-CUR-TS  (18:2)              TO P-RPT-RUN-SS.         
                                                                        
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES               
               DISPLAY '************** PCSAC176************'            
               DISPLAY '  INVALID COMPANY NUMBER'                       
               DISPLAY '  PROCESSING TERMINATED'                        
               DISPLAY '************** PCSAC176************'            
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           ELSE                                                         
              MOVE WS-SYSIN-COMP-NO            TO C7-COMPANY-NO         
           END-IF.                                                      
      *                                                                         
           ACCEPT WS-EDI-LKB-IND FROM SYSIN.                            
           IF WS-EDI-LKB-IND EQUAL SPACES OR LOW-VALUES                 
               DISPLAY '************** PCSAC176************'            
               DISPLAY '  INVALID FILE TYPE '                           
               DISPLAY '  PROCESSING TERMINATED'                        
               DISPLAY '************** PCSAC176************'            
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           ELSE                                                         
              MOVE WS-EDI-LKB-IND              TO WS-HOLD-FILE-TYPE     
           END-IF.                                                      
      *                                                                         
           PERFORM 7500-GET-COMP-DESC          THRU 7500-EXIT.          
      *                                                                         
      *****************************************************************         
      * CHECK CSS_DELINQUENCY TABLE TO DETERMINE IF SCEG/PSNC OR SEB  *         
      * ACCOUNT --                                                    *         
      *****************************************************************         
      *                                                                         
           MOVE 'DATABASE'                    TO C8-DELINQ-CD.          
           MOVE WS-SYSIN-COMP-NO              TO C8-COMPANY-NO.         
           PERFORM 7400-CALL-DELIQUENCY       THRU 7400-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-1                       TO WS-PROCESS-SW          
           ELSE                                                         
              MOVE C8-DELINQ-VALUE            TO WS-PROCESS-SW          
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1000-PROCESS-INPUT.                                        **        
      **        MAIN PROCESS PARAGRAPH                                **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           PERFORM 7000-READ-EDI820                                     
              THRU 7000-EXIT.                                           
                                                                        
           IF END-OF-EDI820-FILE                                        
              GO TO 1000-EXIT
           END-IF.                                          
                                                                        
           EVALUATE WS-EDI-REC-ID                                       
              WHEN 'GS*'                                                
                 PERFORM 1100-PROCESS-GS-RECORD                         
                    THRU 1100-EXIT                                      
              WHEN 'ST*'                                                
                 PERFORM 1120-PROCESS-ST-RECORD                         
                    THRU 1120-EXIT                                      
              WHEN 'BPR'                                                
                 PERFORM 1140-PROCESS-BPR-RECORD                        
                    THRU 1140-EXIT                                      
              WHEN 'TRN'                                                
                 PERFORM 1160-PROCESS-TRN-RECORD                        
                    THRU 1160-EXIT                                      
              WHEN 'REF'                                                
                 PERFORM 1180-PROCESS-REF-RECORD                        
                    THRU 1180-EXIT                                      
              WHEN 'DTM'                                                
                 PERFORM 1200-PROCESS-DTM-RECORD                        
                    THRU 1200-EXIT                                      
              WHEN 'N1*'                                                
                 PERFORM 1220-PROCESS-N1-RECORD                         
                    THRU 1220-EXIT                                      
RS0301        WHEN 'NM1'                                                
RS0301           PERFORM 1230-PROCESS-NM1-RECORD                        
RS0301              THRU 1230-EXIT                                      
              WHEN 'RMR'                                                
                 PERFORM 1240-PROCESS-RMR-RECORD                        
                    THRU 1240-EXIT                                      
              WHEN 'SE*'                                                
                 PERFORM 1260-PROCESS-SE-RECORD                         
                    THRU 1260-EXIT                                      
              WHEN 'GE*'                                                
                 PERFORM 1280-PROCESS-GE-RECORD                         
                    THRU 1280-EXIT                                      
              WHEN OTHER                                                
                 DISPLAY 'RECORD TYPE = ', WS-EDI-REC-ID                
                 ADD WS-ONE    TO WS-NO-OF-SEGS                         
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1100-PROCESS-GS-RECORD                                     **        
      **        EDI820 GS HEADER RECORD                               **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1100-PROCESS-GS-RECORD.                                          
                                                                        
           MOVE '1100'         TO WS-ACTIVE-PARAGRAPH.                  
           SET PROCESS-DATE    TO TRUE.                                 
           MOVE SPACES         TO GS-RECORD.                            
           ADD WS-ONE          TO WS-NO-OF-SEGS.                        
                                                                        
           MOVE WS-FOUR        TO WS-ST-LOC.                            
           MOVE WS-TWO         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO GS-FUNC-ID-CD          
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO GS-FUNC-ID-CD
           END-IF.         
                                                                        
           MOVE WS-FIFTEEN     TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO GS-APPL-SND-CD         
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO GS-APPL-SND-CD
           END-IF.        
                                                                        
           MOVE WS-FIFTEEN     TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO GS-APPL-RCV-CD         
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO GS-APPL-RCV-CD
           END-IF.        
                                                                        
           MOVE WS-EIGHT       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO GS-DATE-TRANS          
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO GS-DATE-TRANS
           END-IF.         
                                                                        
           IF GS-DATE-TRANS NOT EQUAL WS-PROCESS-DATE                   
A00950        PERFORM 7100-SELECT-HOLIDAY    THRU 7100-EXIT             
A00950        IF WS-EXISTS-FL EQUAL 'Y'                                 
A00950           MOVE WS-COMMON-DATE          TO P-RPT-FILE-DATE        
A00950        ELSE                                                      
              SET SKIP-DATE    TO TRUE                                  
              DISPLAY '******************************************'      
              DISPLAY '** PROCESSING ERROR                     **'      
              DISPLAY '** PARAGRAPH = ', WS-ACTIVE-PARAGRAPH            
              DISPLAY '** COMMON DATE DOES NOT MATCH FILE DATE **'      
              DISPLAY '** COMMON DATE = ', WS-PROCESS-DATE              
              DISPLAY '** EDI820 DATE = ', GS-DATE-TRANS                
              DISPLAY '** PROCESSING TERMINATED                **'      
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND              THRU 9900-EXIT            
              END-IF                                                    
           ELSE                                                         
              MOVE WS-COMMON-DATE             TO P-RPT-FILE-DATE        
           END-IF.                                                      
                                                                        
           MOVE WS-EIGHT       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO GS-TIME-TRANS          
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO GS-TIME-TRANS
           END-IF.         
                                                                        
           MOVE WS-NINE        TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO GS-GRP-CNTR-NO         
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO GS-GRP-CNTR-NO
           END-IF.        
                                                                        
           MOVE WS-TWO         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO GS-RESP-AGNCY-CD       
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO GS-RESP-AGNCY-CD
           END-IF.      
                                                                        
           MOVE WS-TWELVE      TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO GS-VERSION-REL         
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO GS-VERSION-REL
           END-IF.        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1120-PROCESS-ST-RECORD                                     **        
      **        EDI820 ST HEADER RECORD                               **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1120-PROCESS-ST-RECORD.                                          
                                                                        
           MOVE '1120'         TO WS-ACTIVE-PARAGRAPH.                  
                                                                        
           MOVE SPACES         TO WS-PAYEE-NAME.                        
           MOVE SPACES         TO WS-PAYOR-NAME.                        
           MOVE SPACES         TO BPR-RECORD.                           
           MOVE SPACES         TO TRN-RECORD.                           
           MOVE SPACES         TO REF-RECORD.                           
           MOVE SPACES         TO DTM-RECORD.                           
           MOVE SPACES         TO N1-RECORD.                            
           MOVE SPACES         TO RMR-RECORD.                           
           MOVE SPACES         TO SE-RECORD.                            
           MOVE SPACES         TO GE-RECORD.                            
           SET NO-RMR          TO TRUE.                                 
           SET NO-NM1-REC      TO TRUE.                                 
           MOVE ZEROS          TO WS-COMMENT-LEN.                       
RS0310     MOVE ZEROS          TO WS-TOTAL.                             
                                                                        
           MOVE SPACES         TO ST-RECORD.                            
           MOVE WS-ONE         TO WS-NO-OF-SEGS.                        
                                                                        
           IF SKIP-DATE                                                 
              GO TO 1120-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE WS-FOUR        TO WS-ST-LOC.                            
           MOVE WS-THREE       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO ST-ID-CD               
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO ST-ID-CD
           END-IF.              
                                                                        
           MOVE WS-NINE        TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO ST-CNTL-NO             
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO ST-CNTL-NO
           END-IF.            
                                                                        
       1120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1140-PROCESS-BPR-RECORD                                    **        
      **        EDI820 BPR HEADER RECORD                              **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1140-PROCESS-BPR-RECORD.                                         
                                                                        
           MOVE '1140'         TO WS-ACTIVE-PARAGRAPH.                  
           ADD WS-ONE          TO WS-NO-OF-SEGS.                        
                                                                        
           IF SKIP-DATE                                                 
              GO TO 1140-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE WS-FIVE        TO WS-ST-LOC.                            
           MOVE WS-ONE         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-TRANS-HANDLNG-CD   
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-TRANS-HANDLNG-CD
           END-IF.  
                                                                        
           MOVE WS-EIGHTEEN    TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           PERFORM 3100-REMOVE-DECIMAL                                  
              THRU 3100-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-MONETARY-AMT       
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-MONETARY-AMT,      
                                                 WS-AMOUNT-NO-DEC
           END-IF.      
                                                                        
           MOVE WS-ONE         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-MONETARY-CR-DB     
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-MONETARY-CR-DB
           END-IF.    
                                                                        
           MOVE WS-THREE       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-PYMT-METHOD-CD     
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-PYMT-METHOD-CD
           END-IF.    
                                                                        
           MOVE WS-TEN         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-PYMT-FORMAT-CD     
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-PYMT-FORMAT-CD
           END-IF.    
                                                                        
           MOVE WS-TWO         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-PAYR-DFI-ID-NO-QUAL
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-PAYR-DFI-ID-NO-QUAL
                                                                        
           MOVE WS-TWELVE      TO WS-MAX-LEN
           END-IF.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-PAYR-DFI-ID-NO     
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-PAYR-DFI-ID-NO
           END-IF.    
                                                                        
           MOVE WS-THREE       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                  TO BPR-PAYR-ACCT-NO-QUAL-CD  
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                           TO BPR-PAYR-ACCT-NO-QUAL-CD
           END-IF. 
                                                                        
           MOVE WS-THIRTY-FIVE TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-PAYR-ACCT-NO       
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-PAYR-ACCT-NO
           END-IF.      
                                                                        
           MOVE WS-TEN         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-ORIG-COMPNY-ID     
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-ORIG-COMPNY-ID
           END-IF.    
                                                                        
           MOVE WS-NINE        TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-ORIG-COMPNY-SUP-CD 
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-ORIG-COMPNY-SUP-CD
           END-IF.
                                                                        
           MOVE WS-TWO         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-PAYE-DFI-ID-NO-QUAL
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-PAYE-DFI-ID-NO-QUAL
                                                                        
           MOVE WS-TWELVE      TO WS-MAX-LEN
           END-IF.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-PAYE-DFI-ID-NO     
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-PAYE-DFI-ID-NO
           END-IF.    
                                                                        
           MOVE WS-THREE       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                   TO BPR-PAYE-ACCT-NO-QUAL-CD 
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                            TO BPR-PAYE-ACCT-NO-QUAL-CD
           END-IF.
                                                                        
           MOVE WS-THIRTY-FIVE TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-PAYE-ACCT-NO       
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-PAYE-ACCT-NO
           END-IF.      
                                                                        
           MOVE WS-EIGHT       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO BPR-PYMT-DATE          
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO BPR-PYMT-DATE
           END-IF.         
           MOVE BPR-PYMT-DATE (1:4)           TO WS-RPT-BANK-DATE (1:4).
           MOVE '-'                           TO WS-RPT-BANK-DATE (5:1).
           MOVE BPR-PYMT-DATE (5:2)           TO WS-RPT-BANK-DATE (6:2).
           MOVE '-'                           TO WS-RPT-BANK-DATE (8:1).
           MOVE BPR-PYMT-DATE (7:2)           TO WS-RPT-BANK-DATE (9:2).
                                                                        
       1140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1160-PROCESS-TRN-RECORD                                    **        
      **        EDI820 TRN HEADER RECORD                              **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1160-PROCESS-TRN-RECORD.                                         
                                                                        
           MOVE '1160'         TO WS-ACTIVE-PARAGRAPH.                  
           ADD WS-ONE          TO WS-NO-OF-SEGS.                        
                                                                        
           IF SKIP-DATE                                                 
              GO TO 1160-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE WS-FIVE        TO WS-ST-LOC.                            
           MOVE WS-TWO         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO TRN-TRACE-TYPE-CD      
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO TRN-TRACE-TYPE-CD
           END-IF.     
                                                                        
           MOVE WS-THIRTY      TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO TRN-REF-NO             
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO TRN-REF-NO
           END-IF.            
                                                                        
           MOVE WS-TEN         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO TRN-ORIG-COMPNY-ID     
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO TRN-ORIG-COMPNY-ID
           END-IF.    
                                                                        
           MOVE WS-THIRTY      TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO TRN-PYMT-METHOD-CD     
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO TRN-PYMT-METHOD-CD
           END-IF.    
                                                                        
       1160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1180-PROCESS-REF-RECORD                                    **        
      **        EDI820 REF RECORD                                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1180-PROCESS-REF-RECORD.                                         
                                                                        
           MOVE '1180'         TO WS-ACTIVE-PARAGRAPH.                  
           ADD WS-ONE          TO WS-NO-OF-SEGS.                        
                                                                        
           IF SKIP-DATE                                                 
              GO TO 1180-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE WS-FIVE        TO WS-ST-LOC.                            
           MOVE WS-THREE       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO REF-ID-QUALIFIER       
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO REF-ID-QUALIFIER
           END-IF.      
                                                                        
           MOVE WS-THIRTY      TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO REF-ID                 
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO REF-ID
           END-IF.                
                                                                        
           MOVE WS-EIGHTY      TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO REF-DESC               
           ELSE                                                         
              MOVE WS-FLD-LEN                 TO WS-COMMENT-LEN         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO REF-DESC
           END-IF.              
                                                                        
           IF WS-COMMENT-LEN > WS-SIXTY                                 
              MOVE WS-SIXTY                   TO WS-COMMENT-LEN         
           END-IF.                                                      
                                                                        
           IF REF-ID-QUALIFIER EQUAL 'TN'                               
              MOVE REF-ID                     TO WS-SAVE-REF-NO         
           END-IF.                                                      
                                                                        
       1180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1200-PROCESS-DTM-RECORD                                    **        
      **        EDI820 DTM - DATE TIME DETAIL RECORDS                 **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1200-PROCESS-DTM-RECORD.                                         
                                                                        
           MOVE '1200'         TO WS-ACTIVE-PARAGRAPH.                  
           ADD WS-ONE          TO WS-NO-OF-SEGS.                        
                                                                        
           IF SKIP-DATE                                                 
              GO TO 1200-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE WS-FIVE        TO WS-ST-LOC.                            
           MOVE WS-THREE       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO DTM-DT-TM-QUAL         
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO DTM-DT-TM-QUAL
           END-IF.        
                                                                        
           MOVE WS-EIGHT       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO DTM-DATE               
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO DTM-DATE
           END-IF.              
                                                                        
           MOVE WS-EIGHT       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO DTM-TIME               
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO DTM-TIME
           END-IF.              
                                                                        
           MOVE WS-TWO         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO DTM-TIME-CD            
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO DTM-TIME-CD
           END-IF.           
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1220-PROCESS-N1-RECORD                                     **        
      **        EDI820 N1 - NAME RECORD                               **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1220-PROCESS-N1-RECORD.                                          
                                                                        
           MOVE '1220'         TO WS-ACTIVE-PARAGRAPH.                  
           ADD WS-ONE          TO WS-NO-OF-SEGS.                        
                                                                        
           IF SKIP-DATE                                                 
              GO TO 1220-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE WS-FOUR        TO WS-ST-LOC.                            
           MOVE WS-THREE       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO N1-ENTITY-ID-CD        
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO N1-ENTITY-ID-CD
           END-IF.       
                                                                        
           MOVE WS-SIXTY       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO N1-NAME                
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO N1-NAME
           END-IF.               
                                                                        
           MOVE WS-TWO         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO N1-ID-CD-QUAL          
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO N1-ID-CD-QUAL
           END-IF.         
                                                                        
           MOVE WS-EIGHTY      TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO N1-ID-CD               
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO N1-ID-CD
           END-IF.              
                                                                        
           IF N1-ENTITY-ID-CD = 'PR '                                   
              MOVE N1-NAME                    TO WS-PAYOR-NAME,         
                                                 WS-RPT-COMPANY         
           END-IF.                                                      
                                                                        
           IF N1-ENTITY-ID-CD = 'PE '                                   
              MOVE N1-NAME                    TO WS-PAYEE-NAME          
           END-IF.                                                      
                                                                        
       1220-EXIT.                                                       
           EXIT.                                                        
                                                                        
RS0301******************************************************************        
RS0301**                                                              **        
RS0301**   1230-PROCESS-NM1-RECORD                                    **        
RS0301**        EDI820 NM1 - INDIVIDUAL AND ORGANIZATION NAME RECORD  **        
RS0301**                                                              **        
RS0301******************************************************************        
RS0301                                                                  
RS0301 1230-PROCESS-NM1-RECORD.                                         
RS0301                                                                  
RS0301     MOVE '1230'         TO WS-ACTIVE-PARAGRAPH.                  
RS0301     ADD WS-ONE          TO WS-NO-OF-SEGS.                        
RS0301     SET NM1-REC-FND     TO TRUE.                                 
RS0301                                                                  
RS0301     IF SKIP-DATE                                                 
RS0301        GO TO 1230-EXIT                                           
RS0301     END-IF.                                                      
RS0301                                                                  
RS0301     IF NO-RMR                                                    
RS0301        NEXT SENTENCE                                             
RS0301     ELSE                                                         
RS0301     IF FIRST-RMR                                                 
RS0301        SET PROCESS-HEADER TO TRUE                                
RS0301        PERFORM 3300-CONVERT-TO-CHAR    THRU 3300-EXIT            
RS0301        PERFORM 2000-PROCESS-EDI-TABLES THRU 2000-EXIT            
RS0301     ELSE                                                         
RS0301        SET PROCESS-DETAIL TO TRUE                                
RS0301        PERFORM 2000-PROCESS-EDI-TABLES THRU 2000-EXIT            
RS0301        PERFORM 3300-CONVERT-TO-CHAR    THRU 3300-EXIT            
RS0301        PERFORM 8250-UPDATE-JH          THRU 8250-EXIT            
RS0301     END-IF                                                       
RS0301     END-IF.                                                      
RS0301                                                                  
RS0301     SET NO-RMR          TO TRUE.                                 
RS0301     MOVE ZEROS          TO WS-TOT-AMT.                           
RS0310     MOVE ZEROS          TO WS-TOTAL.                             
RS0301                                                                  
RS0301     MOVE WS-FIVE        TO WS-ST-LOC.                            
RS0301     MOVE WS-THREE       TO WS-MAX-LEN.                           
RS0301                                                                  
RS0301     PERFORM 3000-PARSE-EDI820-REC                                
RS0301        THRU 3000-EXIT.                                           
RS0301                                                                  
RS0301     IF WS-FLD-LEN = ZERO                                         
RS0301        MOVE SPACES                     TO NM1-ENTITY-ID-CD       
RS0301     ELSE                                                         
RS0301        MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
RS0301                                        TO NM1-ENTITY-ID-CD
           END-IF.      
RS0301                                                                  
RS0301     MOVE WS-ONE         TO WS-MAX-LEN.                           
RS0301                                                                  
RS0301     PERFORM 3000-PARSE-EDI820-REC                                
RS0301        THRU 3000-EXIT.                                           
RS0301                                                                  
RS0301     IF WS-FLD-LEN = ZERO                                         
RS0301        MOVE SPACES                     TO NM1-TYPE               
RS0301     ELSE                                                         
RS0301        MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
RS0301                                        TO NM1-TYPE
           END-IF.              
RS0301                                                                  
RS0301     MOVE WS-THIRTY-FIVE TO WS-MAX-LEN.                           
RS0301                                                                  
RS0301     PERFORM 3000-PARSE-EDI820-REC                                
RS0301        THRU 3000-EXIT.                                           
RS0301                                                                  
RS0301     IF WS-FLD-LEN = ZERO                                         
RS0301        MOVE SPACES                     TO NM1-NAME               
RS0301     ELSE                                                         
RS0301        MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
RS0301                                        TO NM1-NAME
           END-IF.              
RS0301                                                                  
RS0301     MOVE WS-TWENTY-FIVE TO WS-MAX-LEN.                           
RS0301                                                                  
RS0301     PERFORM 3000-PARSE-EDI820-REC                                
RS0301        THRU 3000-EXIT.                                           
RS0301                                                                  
RS0301     IF WS-FLD-LEN = ZERO                                         
RS0301        MOVE SPACES                     TO NM1-FNAME              
RS0301     ELSE                                                         
RS0301        MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
RS0301                                        TO NM1-FNAME
           END-IF.             
RS0301                                                                  
RS0301     MOVE WS-TWENTY-FIVE TO WS-MAX-LEN.                           
RS0301                                                                  
RS0301     PERFORM 3000-PARSE-EDI820-REC                                
RS0301        THRU 3000-EXIT.                                           
RS0301                                                                  
RS0301     IF WS-FLD-LEN = ZERO                                         
RS0301        MOVE SPACES                     TO NM1-MNAME              
RS0301     ELSE                                                         
RS0301        MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
RS0301                                        TO NM1-MNAME
           END-IF.             
RS0301                                                                  
RS0301     MOVE WS-TEN         TO WS-MAX-LEN.                           
RS0301                                                                  
RS0301     PERFORM 3000-PARSE-EDI820-REC                                
RS0301        THRU 3000-EXIT.                                           
RS0301                                                                  
RS0301     IF WS-FLD-LEN = ZERO                                         
RS0301        MOVE SPACES                     TO NM1-PNAME              
RS0301     ELSE                                                         
RS0301        MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
RS0301                                        TO NM1-PNAME
           END-IF.             
RS0301                                                                  
RS0301     MOVE WS-TEN         TO WS-MAX-LEN.                           
RS0301                                                                  
RS0301     PERFORM 3000-PARSE-EDI820-REC                                
RS0301        THRU 3000-EXIT.                                           
RS0301                                                                  
RS0301     IF WS-FLD-LEN = ZERO                                         
RS0301        MOVE SPACES                     TO NM1-SNAME              
RS0301     ELSE                                                         
RS0301        MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
RS0301                                        TO NM1-SNAME
           END-IF.             
RS0301                                                                  
RS0301     MOVE WS-TWO         TO WS-MAX-LEN.                           
RS0301                                                                  
RS0301     PERFORM 3000-PARSE-EDI820-REC                                
RS0301        THRU 3000-EXIT.                                           
RS0301                                                                  
RS0301     IF WS-FLD-LEN = ZERO                                         
RS0301        MOVE SPACES                     TO NM1-ID-QUAL            
RS0301     ELSE                                                         
RS0301        MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
RS0301                                        TO NM1-ID-QUAL
           END-IF.           
RS0301                                                                  
RS0301     MOVE WS-EIGHTY      TO WS-MAX-LEN.                           
RS0301                                                                  
RS0301     PERFORM 3000-PARSE-EDI820-REC                                
RS0301        THRU 3000-EXIT.                                           
RS0301                                                                  
RS0301     IF WS-FLD-LEN = ZERO                                         
RS0301        MOVE SPACES                     TO NM1-ID                 
RS0301     ELSE                                                         
RS0301        MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
RS0301                                        TO NM1-ID
           END-IF.                
RS0301                                                                  
RS0301     DISPLAY 'NM1 NAME = ', NM1-NAME.                             
RS0301                                                                  
RS0301     MOVE NM1-NAME                      TO WS-PAYOR-NAME,         
RS0301                                           WS-RPT-COMPANY.        
RS0301                                                                  
RS0301 1230-EXIT.                                                       
RS0301     EXIT.                                                        
RS0301                                                                  
      ******************************************************************        
      **                                                              **        
      **   1240-PROCESS-RMR-RECORD                                    **        
      **        EDI820 RMR - PAYMENT DETAIL RECORD                    **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1240-PROCESS-RMR-RECORD.                                         
                                                                        
           MOVE '1240'         TO WS-ACTIVE-PARAGRAPH.                  
           ADD WS-ONE          TO WS-NO-OF-SEGS.                        
                                                                        
           IF SKIP-DATE                                                 
              GO TO 1240-EXIT                                           
           END-IF.                                                      
                                                                        
           IF NO-RMR                                                    
              SET FIRST-RMR TO TRUE                                     
           ELSE                                                         
           IF FIRST-RMR                                                 
              SET PROCESS-HEADER TO TRUE                                
              SET SUBSEQUENT-RMR TO TRUE                                
              PERFORM 2000-PROCESS-EDI-TABLES THRU 2000-EXIT            
           ELSE                                                         
              SET PROCESS-DETAIL TO TRUE                                
              PERFORM 2000-PROCESS-EDI-TABLES THRU 2000-EXIT            
           END-IF                                                       
           END-IF.                                                      
                                                                        
           MOVE WS-FIVE        TO WS-ST-LOC.                            
           MOVE WS-THREE       TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO RMR-REF-ID-QUAL        
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO RMR-REF-ID-QUAL
           END-IF.       
                                                                        
           MOVE WS-THIRTY      TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO RMR-REF-ID             
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO RMR-REF-ID
           END-IF.            
                                                                        
           MOVE WS-TWO         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO RMR-PAYMT-ACT-CD       
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO RMR-PAYMT-ACT-CD
           END-IF.      
                                                                        
           MOVE WS-EIGHTEEN    TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           PERFORM 3100-REMOVE-DECIMAL                                  
              THRU 3100-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO RMR-MONETARY-AMT       
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO RMR-MONETARY-AMT,      
                                                 WS-AMOUNT-NO-DEC
           END-IF.      
                                                                        
RS0301     ADD  WS-AMOUNT      TO WS-TOTAL.                             
RS0301                                                                  
           MOVE WS-EIGHTEEN    TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO RMR-INV-CR-DB-AMT      
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO RMR-INV-CR-DB-AMT
           END-IF.     
                                                                        
           MOVE WS-EIGHTEEN    TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO RMR-DISCOUNT-AMT       
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO RMR-DISCOUNT-AMT
           END-IF.      
                                                                        
       1240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1260-PROCESS-SE-RECORD                                     **        
      **        EDI820 SE TRAILER RECORD                              **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1260-PROCESS-SE-RECORD.                                          
                                                                        
           MOVE '1260'         TO WS-ACTIVE-PARAGRAPH.                  
           ADD WS-ONE          TO WS-NO-OF-SEGS.                        
           SET NO-SEG-ERROR    TO TRUE.                                 
                                                                        
           IF SKIP-DATE                                                 
              GO TO 1260-EXIT                                           
           END-IF.                                                      
                                                                        
      ******************************************************************        
      * IF NO RMR RECORDS, WRITE HEADER RECORD AND MOVE AMOUNT TO               
      *    DETAIL RECORDS. WRITE ACCOUNT NUMBER AS ALL NINES.                   
      ******************************************************************        
                                                                        
           IF NO-RMR                                                    
              SET FIRST-RMR TO TRUE                                     
              SET PROCESS-HEADER TO TRUE                                
              PERFORM 2000-PROCESS-EDI-TABLES THRU 2000-EXIT            
           ELSE                                                         
           IF FIRST-RMR                                                 
              SET PROCESS-HEADER TO TRUE                                
              PERFORM 2000-PROCESS-EDI-TABLES THRU 2000-EXIT            
           ELSE                                                         
              SET PROCESS-DETAIL TO TRUE                                
              PERFORM 2000-PROCESS-EDI-TABLES THRU 2000-EXIT            
           END-IF                                                       
           END-IF.                                                      
                                                                        
RS0301     IF NM1-REC-FND                                               
RS0301        PERFORM 3300-CONVERT-TO-CHAR    THRU 3300-EXIT            
RS0301        PERFORM 8250-UPDATE-JH          THRU 8250-EXIT            
RS0301     END-IF.                                                      
RS0301                                                                  
           MOVE WS-FOUR        TO WS-ST-LOC.                            
           MOVE WS-TEN         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO SE-NO-OF-SEGS          
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO SE-NO-OF-SEGS
           END-IF.         
                                                                        
           MOVE WS-NINE        TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO SE-TRANS-SET-CNTRL-NO  
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO SE-TRANS-SET-CNTRL-NO
           END-IF. 
                                                                        
           IF WS-NO-OF-SEGS-X (1:3) EQUAL '000'                         
             IF WS-NO-OF-SEGS-X (4:1) NOT EQUAL SE-NO-OF-SEGS           
                SET SEGMENT-ERROR TO TRUE                               
             END-IF                                                     
           ELSE                                                         
           IF WS-NO-OF-SEGS-X (1:2) EQUAL '00'                          
             IF WS-NO-OF-SEGS-X (3:2) NOT EQUAL SE-NO-OF-SEGS           
                SET SEGMENT-ERROR TO TRUE                               
             END-IF                                                     
           ELSE                                                         
           IF WS-NO-OF-SEGS-X (1:1) EQUAL '0'                           
             IF WS-NO-OF-SEGS-X (2:3) NOT EQUAL SE-NO-OF-SEGS           
                SET SEGMENT-ERROR TO TRUE                               
             END-IF                                                     
           ELSE                                                         
             IF WS-NO-OF-SEGS-X NOT EQUAL SE-NO-OF-SEGS                 
                SET SEGMENT-ERROR TO TRUE                               
             END-IF                                                     
           END-IF END-IF END-IF.                                        
                                                                        
           IF SEGMENT-ERROR                                             
              DISPLAY '*** NUMBER OF SEGMENTS MIS-MATCH ****'           
              DISPLAY '*** WARNING WARNING WARNING WARNING***'          
              DISPLAY 'NUMBER OF SEGMENTS ON SE RECORD = ',             
                      SE-NO-OF-SEGS                                     
              DISPLAY 'NUMBER OF SEGMENTS COUNTED = ',                  
                      WS-NO-OF-SEGS                                     
           END-IF.                                                      
                                                                        
       1260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   1280-PROCESS-GE-RECORD                                     **        
      **        EDI820 GE TRAILER RECORD                              **        
      **                                                              **        
      ******************************************************************        
                                                                        
       1280-PROCESS-GE-RECORD.                                          
                                                                        
           MOVE '1280'         TO WS-ACTIVE-PARAGRAPH.                  
                                                                        
           IF SKIP-DATE                                                 
              GO TO 1280-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE WS-FOUR        TO WS-ST-LOC.                            
           MOVE WS-SIX         TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO GE-NO-OF-TRANS-SETS    
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO GE-NO-OF-TRANS-SETS
           END-IF.   
                                                                        
           MOVE WS-NINE        TO WS-MAX-LEN.                           
                                                                        
           PERFORM 3000-PARSE-EDI820-REC                                
              THRU 3000-EXIT.                                           
                                                                        
           IF WS-FLD-LEN = ZERO                                         
              MOVE SPACES                     TO GE-GROUP-CNTRL-NO      
           ELSE                                                         
              MOVE WS-RETURN-DATA (1:WS-FLD-LEN)                        
                                              TO GE-GROUP-CNTRL-NO
           END-IF.     
                                                                        
       1280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **   2000-PROCESS-EDI-TABLES                                    **        
      **        INSERT EDI820 DATA INTO EDI TABLES                    **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2000-PROCESS-EDI-TABLES.                                         
                                                                        
           MOVE '2000'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           IF PROCESS-HEADER                                            
              PERFORM 7300-CHECK-COMPANY-NAME  THRU 7300-EXIT           
              PERFORM 2100-FORMAT-HDR          THRU 2100-EXIT           
              PERFORM 8000-INSERT-JH           THRU 8000-EXIT           
              PERFORM 2200-FORMAT-DET          THRU 2200-EXIT           
              PERFORM 8100-INSERT-JD           THRU 8100-EXIT           
           ELSE                                                         
           IF PROCESS-DETAIL                                            
              PERFORM 2200-FORMAT-DET          THRU 2200-EXIT           
              PERFORM 8100-INSERT-JD           THRU 8100-EXIT           
           END-IF                                                       
           END-IF.                                                      
                                                                        
           PERFORM 8300-PRINT-REPORT           THRU 8300-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2100-FORMAT-HDR                                             **        
      **      FORMATS DATA FOR CSS_EDI_PYMT_HDR                       **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2100-FORMAT-HDR.                                                 
                                                                        
           MOVE '2100'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           PERFORM 7200-GET-CURRENT-TIMESTAMP  THRU 7200-EXIT.          
                                                                        
           MOVE REF-ID                         TO JH-ACH-REF-NO.        
           MOVE BPR-MONETARY-CR-DB             TO JH-DEBIT-CREDIT-CD.   
           MOVE BPR-PAYR-ACCT-NO               TO JH-SENDER-BNK-ACCT-NO.
           MOVE BPR-ORIG-COMPNY-ID             TO JH-EDI-COMPANY-ID.    
           MOVE BPR-PAYR-DFI-ID-NO             TO JH-SENDER-ROUTING-NO. 
           IF BPR-PYMT-DATE = SPACES                                    
              MOVE WS-CUR-DATE                 TO JH-EFFECTIVE-DT       
           ELSE                                                         
              MOVE BPR-PYMT-DATE (1:4)         TO JH-EFFECTIVE-DT (1:4) 
              MOVE '-'                         TO JH-EFFECTIVE-DT (5:1) 
              MOVE BPR-PYMT-DATE (5:2)         TO JH-EFFECTIVE-DT (6:2) 
              MOVE '-'                         TO JH-EFFECTIVE-DT (8:1) 
              MOVE BPR-PYMT-DATE (7:2)         TO JH-EFFECTIVE-DT (9:2)
           END-IF.
           MOVE SPACES                         TO JH-EXTRACT-FL.        
           MOVE WS-PAYOR-NAME                  TO JH-PAYER-NM.          
           IF WS-HOLD-FILE-TYPE = 'LKB'                                 
              MOVE 'LKB'                       TO JH-SEC-CD             
           ELSE                                                         
              MOVE BPR-PYMT-METHOD-CD          TO JH-SEC-CD             
           END-IF.                                                      
           MOVE BPR-PAYE-ACCT-NO               TO JH-EDI-BANK-ACCT-NO.  
           MOVE BPR-PAYE-DFI-ID-NO             TO JH-EDI-ROUTING-NO.    
           MOVE BPR-MONETARY-AMT               TO JH-TOTAL-PYMT-AM.     
           IF TRN-REF-NO EQUAL LOW-VALUES                               
              MOVE SPACES                      TO JH-TRACE-NO           
           ELSE                                                         
              MOVE TRN-REF-NO                  TO JH-TRACE-NO
           END-IF.          
           MOVE REF-ID                         TO JH-TRAN-REF-NO.       
           MOVE WS-CUR-TS                      TO JH-TRANSACTION-TS.    
           MOVE SPACES                         TO JH-VALID-CIS-FL.      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2200-FORMAT-HDR                                             **        
      **      FORMATS DATA FOR CSS_EDI_PYMT_DET                       **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2200-FORMAT-DET.                                                 
                                                                        
           MOVE '2200'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
      *    IF RMR-REF-ID-QUAL EQUAL '45'                                        
           IF BPR-MONETARY-CR-DB EQUAL 'D'                              
              MOVE 'D'                         TO JD-DEBIT-CREDIT-CD    
           ELSE                                                         
              MOVE 'C'                         TO JD-DEBIT-CREDIT-CD    
           END-IF.                                                      
           IF DTM-DATE = SPACES OR LOW-VALUES                           
              MOVE WS-CUR-DATE                 TO JD-INVOICE-DT         
           ELSE                                                         
              MOVE DTM-DATE (1:4)              TO JD-INVOICE-DT (1:4)   
              MOVE '-'                         TO JD-INVOICE-DT (5:1)   
              MOVE DTM-DATE (5:2)              TO JD-INVOICE-DT (6:2)   
              MOVE '-'                         TO JD-INVOICE-DT (8:1)   
              MOVE DTM-DATE (7:2)              TO JD-INVOICE-DT (9:2)
           END-IF.  
           IF RMR-MONETARY-AMT EQUAL SPACES OR LOW-VALUES               
              MOVE BPR-MONETARY-AMT            TO JD-PAYMENT-AM         
           ELSE                                                         
              MOVE RMR-MONETARY-AMT            TO JD-PAYMENT-AM
           END-IF.        
           IF BPR-MONETARY-CR-DB EQUAL 'D'                              
              MOVE WS-AMOUNT                   TO WS-RPT-EDI-AMT-DB     
              MOVE ZEROS                       TO WS-RPT-EDI-AMT-CR     
              COMPUTE WS-TOT-AMT-DB = WS-TOT-AMT-DB + WS-AMOUNT         
              ADD WS-ONE                       TO WS-CNT-DEBITS         
           ELSE                                                         
              COMPUTE WS-TOT-AMT-CR = WS-TOT-AMT-CR + WS-AMOUNT         
              ADD WS-ONE                       TO WS-CNT-CREDITS        
              MOVE ZEROS                       TO WS-RPT-EDI-AMT-DB     
              MOVE WS-AMOUNT                   TO WS-RPT-EDI-AMT-CR
           END-IF.    
           IF RMR-REF-ID EQUAL SPACES OR LOW-VALUES                     
              MOVE '9999999999999'             TO JD-REF-CUST-ACCT-NO   
              MOVE '9'                         TO WS-RPT-ACCT1          
              MOVE '9999'                      TO WS-RPT-ACCT2          
              MOVE '9999'                      TO WS-RPT-ACCT3          
              MOVE '9999'                      TO WS-RPT-ACCT4          
           ELSE                                                         
              MOVE RMR-REF-ID                  TO JD-REF-CUST-ACCT-NO   
              IF RMR-REF-ID (14:1) EQUAL SPACES                         
                 MOVE RMR-REF-ID (1:1)         TO WS-RPT-ACCT1          
                 MOVE RMR-REF-ID (2:4)         TO WS-RPT-ACCT2          
                 MOVE RMR-REF-ID (6:4)         TO WS-RPT-ACCT3          
                 MOVE RMR-REF-ID (10:4)        TO WS-RPT-ACCT4          
              ELSE                                                      
                 MOVE RMR-REF-ID               TO WS-RPT-ACCT
              END-IF
           END-IF.          
           MOVE WS-JD-SEQUENCE                 TO JD-SEQUENCE-NO.       
           MOVE WS-COMMENT-LEN                 TO JD-TRAN-COMMENT-LEN.  
           MOVE REF-DESC                       TO JD-TRAN-COMMENT-TEXT. 
           MOVE WS-CUR-TS                      TO JD-TRANSACTION-TS.    
           ADD  WS-ONE                         TO WS-JD-SEQUENCE.       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   THIS ROUTINE WILL PARSE THROUGH THE EDI 820 RECORDS LOOKING  *        
      *   FOR ASTERISKS AS A FIELD DELIMITER AND FIELD LENGTH AS A MAX *        
      *   SEARCH LENGTH.                                               *        
      ******************************************************************        
       3000-PARSE-EDI820-REC.                                           
                                                                        
           SET  VALID-DATA         TO TRUE.                             
           SET  START-SRCH         TO TRUE.                             
           MOVE WS-ONE             TO WS-FLD-LEN.                       
           MOVE SPACES             TO WS-RETURN-DATA.                   
           MOVE WS-ST-LOC          TO WS-CUR-LOC.                       
                                                                        
           PERFORM VARYING WS-CUR-LOC FROM WS-CUR-LOC BY WS-ONE UNTIL   
                           WS-FLD-LEN > WS-MAX-LEN                      
                        OR ASTERISK-FND                                 
              IF WS-EDI-REC (WS-CUR-LOC:1) EQUAL '*'                    
              OR WS-EDI-REC (WS-CUR-LOC:9) EQUAL '         '            
                IF WS-FLD-LEN EQUAL WS-ONE                              
                   SET NO-DATA     TO TRUE                              
                END-IF                                                  
                SET ASTERISK-FND TO TRUE                                
      *         COMPUTE WS-FLD-LEN = WS-MAX-LEN + WS-ONE                        
              ELSE                                                      
                MOVE WS-EDI-REC (WS-CUR-LOC:1)                          
                                   TO WS-RETURN-DATA (WS-FLD-LEN:1)     
                ADD WS-ONE           TO WS-FLD-LEN                      
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF ASTERISK-FND                                              
              COMPUTE WS-FLD-LEN = (WS-CUR-LOC - WS-ST-LOC) - WS-ONE    
           ELSE                                                         
              COMPUTE WS-FLD-LEN = WS-CUR-LOC - WS-ST-LOC
           END-IF.              
                                                                        
      * SET NEXT STARTING LOCATION                                              
                                                                        
           IF ASTERISK-FND                                              
              MOVE WS-CUR-LOC TO WS-ST-LOC                              
           ELSE                                                         
              COMPUTE WS-ST-LOC = WS-CUR-LOC + WS-ONE
           END-IF.                  
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   THIS ROUTINE WILL TAKE THE DECIMAL POINT FROM A NUMERIC FIELD*        
      ******************************************************************        
       3100-REMOVE-DECIMAL.                                             
                                                                        
           SET DECIMAL-SRCH TO TRUE.                                    
           MOVE WS-ONE      TO WS-DEC-LOC.                              
                                                                        
           PERFORM VARYING WS-DEC-LOC FROM WS-ONE BY WS-ONE UNTIL       
                           WS-DEC-LOC > WS-FLD-LEN                      
                        OR DECIMAL-FND                                  
              IF WS-RETURN-DATA (WS-DEC-LOC:1) EQUAL '.'                
                 SET DECIMAL-FND TO TRUE                                
                 COMPUTE WS-DEC-LOC-P1 = WS-DEC-LOC + 1                 
                 COMPUTE WS-DEC-LOC-P2 = WS-DEC-LOC + 2                 
                 MOVE WS-RETURN-DATA (WS-DEC-LOC-P1:2)                  
                                    TO WS-RETURN-DATA (WS-DEC-LOC:2)    
                 MOVE SPACE         TO WS-RETURN-DATA (WS-DEC-LOC-P2:1) 
                 SUBTRACT WS-ONE    FROM WS-FLD-LEN                     
      *  MAKE SURE THAT .9 IS 90 WITH DECIMAL REMOVED                           
                 IF WS-RETURN-DATA (WS-DEC-LOC-P1:1) EQUAL SPACES       
                    MOVE '0'        TO WS-RETURN-DATA (WS-DEC-LOC-P1:1) 
                    ADD WS-ONE      TO WS-FLD-LEN                       
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
      *  ADD ZEROS FOR WHOLE DOLLAR AMOUNTS                                     
           IF DECIMAL-SRCH                                              
           AND VALID-DATA                                               
              COMPUTE WS-DEC-LOC-P1 = WS-FLD-LEN + 1                    
              MOVE '00'             TO WS-RETURN-DATA (WS-DEC-LOC-P1:2) 
              ADD WS-TWO            TO WS-FLD-LEN                       
           END-IF.                                                      
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
RS0301******************************************************************        
RS0301*   THIS ROUTINE WILL CONVERT A NUMERIC FIELD TO A CHARACTER FLD *        
RS0301******************************************************************        
RS0301 3300-CONVERT-TO-CHAR.                                            
RS0301                                                                  
RS0301     SET FIND-NUM     TO TRUE.                                    
RS0301     MOVE WS-ONE      TO WS-NUM-LOC.                              
RS0301     MOVE SPACES      TO WS-ALPHA-TOT                             
RS0301     MOVE WS-TOTAL    TO WS-TOT-AMT                               
RS0301                                                                  
RS0301     PERFORM VARYING WS-NUM-LOC FROM WS-ONE BY WS-ONE UNTIL       
RS0301                     WS-NUM-LOC > WS-ELEVEN                       
RS0301                  OR FOUND-NUM                                    
RS0301        IF WS-TOT-AMT-X (WS-NUM-LOC:1) > '0'                      
RS0301           SET FOUND-NUM  TO TRUE                                 
RS0301        END-IF                                                    
RS0301     END-PERFORM.                                                 
RS0301                                                                  
RS0301     MOVE WS-ONE TO WS-ALPHA-LOC.                                 
RS0301     SUBTRACT WS-ONE FROM WS-NUM-LOC.                             
RS0301                                                                  
RS0301     PERFORM VARYING WS-NUM-LOC FROM WS-NUM-LOC BY WS-ONE UNTIL   
RS0301                     WS-NUM-LOC > WS-ELEVEN                       
RS0301           MOVE WS-TOT-AMT-X (WS-NUM-LOC:1)                       
RS0301                              TO WS-ALPHA-TOT (WS-ALPHA-LOC:1)    
RS0301           ADD WS-ONE TO WS-ALPHA-LOC                             
RS0301     END-PERFORM.                                                 
RS0301                                                                  
RS0301     MOVE WS-ALPHA-TOT        TO BPR-MONETARY-AMT.                
RS0301     IF WS-TOTAL NEGATIVE                                         
RS0301        MOVE 'D'              TO BPR-MONETARY-CR-DB               
RS0301     END-IF.                                                      
RS0301                                                                  
RS0301     MOVE ZEROS               TO WS-TOTAL.                        
RS0301                                                                  
RS0301 3300-EXIT.                                                       
RS0301     EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                          *              
      *  6251-GET-FJC01-DATE                                     *              
      *                                                          *              
      ************************************************************              
                                                                        
        COPY CPD00037.                                                          
                                                                        
      *************************************************************             
      *                                                          *              
      * TAKES THE CURRENT DATE AND GETS NEW BUSINESS DATE.        *             
      *                                                          *              
      *************************************************************             
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00012                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **                                                              **        
      **   7000-READ-EDI820.                                          **        
      **        READ THE EDI 820 PAYMENT FILE                         **        
      **                                                              **        
      ******************************************************************        
                                                                        
       7000-READ-EDI820.                                                
                                                                        
           MOVE '7000'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           READ EDI820-FILE                                             
               AT END                                                   
                  SET END-OF-EDI820-FILE       TO TRUE                  
                  GO                           TO 7000-EXIT.            
      *                                                                         
           IF  EDI820-SUCCESSFUL                                        
               MOVE EDI-REC                    TO WS-EDI-REC            
           ELSE                                                         
               DISPLAY '************** PCSAC176 ************'           
               DISPLAY 'ERROR IN READING EDI820-FILE'                   
               DISPLAY 'ERROR STATUS ' WS-EDI820-STATUS                 
               DISPLAY '  PROCESSING TERMINATED  '                      
               DISPLAY '************** PCSAC176 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00950 7100-SELECT-HOLIDAY.                                             
A00950                                                                  
A00950     MOVE SPACES             TO WS-EXISTS-FL.                     
A00950     MOVE GS-DATE-TRANS(1:4) TO J8-HOLIDAY-DT.                    
A00950     MOVE GS-DATE-TRANS(5:2) TO J8-HOLIDAY-DT(6:2).               
A00950     MOVE GS-DATE-TRANS(7:2) TO J8-HOLIDAY-DT(9:2).               
A00950     MOVE '-'                TO J8-HOLIDAY-DT(5:1).               
A00950     MOVE '-'                TO J8-HOLIDAY-DT(8:1).               
A00950     MOVE C7-COMPANY-NO      TO J8-COMPANY-NO.                    
A00950                                                                  
A00950     EXEC SQL                                                     
A00950        SELECT 'Y'                                                
A00950        INTO   :WS-EXISTS-FL                                      
A00950        FROM   CSS_HOLIDAY WITH(READUNCOMMITTED)                          
A00950        WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                        
A00950          AND  COMPANY_NO = :J8-COMPANY-NO                        
A00950                                                           
A00950     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO   :WS-EXISTS-FL                                              
MFA-TR*       FROM   CSS_HOLIDAY                                                
MFA-TR*       WHERE  HOLIDAY_DT = :J8-HOLIDAY-DT                                
MFA-TR*         AND  COMPANY_NO = :J8-COMPANY-NO                                
MFA-TR*       WITH UR                                                   56210000
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00950                                                                  
A00950     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A00950                                                                  
A00950     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
A00950                                  OR  NOT-FOUND                   
A00950        NEXT SENTENCE                                             
A00950     ELSE                                                         
A00950        DISPLAY '************** PCSAC176 ************'            
A00950        DISPLAY 'ERROR IN 7100-SELECT-HOLIDAY'                    
A00950        DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                  
A00950        DISPLAY 'HOLIDAY DATE', J8-HOLIDAY-DT                     
A00950        DISPLAY 'COMPANY NO  ', J8-COMPANY-NO                     
A00950        DISPLAY 'PROCESSING TERMINATED  '                         
A00950        DISPLAY '************** PCSAC176 ************'            
A00950        PERFORM 9900-ABEND              THRU 9900-EXIT            
A00950     END-IF.                                                      
A00950                                                                  
A00950 7100-EXIT.                                                       
A00950                                                                  
      ************************************************************              
      **  7200-GET-CURRENT-TIMESTAMP.                           **              
      **      GETS THE CURRENT TIMESTAMP.                       **              
      ************************************************************              
       7200-GET-CURRENT-TIMESTAMP.                                      
           EXEC SQL                                                     
T35434         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CUR-TS,
              :WS-CUR-DATE                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CUR-TS   = CURRENT TIMESTAMP                             
MFA-TR*           ,:WS-CUR-DATE = CURRENT DATE                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '7200-GET-CURRENT-TIMESTAMP'                      
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7300-CHECK-COMPANY-NAME                               **              
      ************************************************************              
       7300-CHECK-COMPANY-NAME.                                         
                                                                        
           MOVE BPR-ORIG-COMPNY-ID        TO IB-EDI-COMPANY-ID.         
                                                                        
           EXEC SQL                                                     
               SELECT EDI_COMPANY_DESC                                  
               INTO   :IB-EDI-COMPANY-DESC                              
               FROM  CSS_EDI_COMPANY WITH(READUNCOMMITTED)                      
               WHERE EDI_COMPANY_ID = :IB-EDI-COMPANY-ID                
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EDI_COMPANY_DESC                                          
MFA-TR*        INTO   :IB-EDI-COMPANY-DESC                                      
MFA-TR*        FROM  CSS_EDI_COMPANY                                            
MFA-TR*        WHERE EDI_COMPANY_ID = :IB-EDI-COMPANY-ID                        
MFA-TR*        WITH UR                                                  56210000
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-PAYOR-NAME           TO IB-EDI-COMPANY-DESC       
              MOVE 'SYSTEM'                TO IB-LAST-UPDATE-USERID     
              PERFORM 8200-INSERT-IB       THRU 8200-EXIT               
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '7300-CHECK-COMPANY-NAME'                         
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DETERMINES IF WE ARE PROCESS SCEG/PSNC OR SEB                           
      ******************************************************************        
       7400-CALL-DELIQUENCY.                                            
           EXEC SQL                                                     
                SELECT DELINQ_VALUE                                     
                  INTO :C8-DELINQ-VALUE                                 
                  FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
                WHERE DELINQ_CD = :C8-DELINQ-CD                         
                  AND COMPANY_NO = :C8-COMPANY-NO                       
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DELINQ_VALUE                                             
MFA-TR*           INTO :C8-DELINQ-VALUE                                         
MFA-TR*           FROM CSS_DELINQUENCY                                          
MFA-TR*         WHERE DELINQ_CD = :C8-DELINQ-CD                                 
MFA-TR*           AND COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*         WITH UR                                                 56210000
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************** PCSRP219 ************'           
               DISPLAY 'ERROR IN 7400-CALL-DELINQUENCY'                 
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP219 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GETS THE COMPANY NAME FOR THE CASH COMPANY NUMBER                       
      ******************************************************************        
      *                                                                         
       7500-GET-COMP-DESC.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
A00950                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     56130000
MFA-TR*       SELECT COMPANY_NAME                                       56140000
MFA-TR*         INTO :C7-COMPANY-NAME                                   56170000
MFA-TR*         FROM CSS_COMPANY C7                                     56200000
MFA-TR*        WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     56210000
MFA-TR*        WITH UR                                                  56210000
MFA-TR*    END-EXEC.                                                    56242000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************** PCSAC176 ************'           
               DISPLAY 'ERROR IN 7500-GET-COMP-DESC'                    
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'CASH COMPANY NO  ', C7-COMPANY-NO               
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSRP219 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      *  7600-START-FCSJC01                                      *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      *   8000-INSERT-JH                                              *         
      *                                                               *         
      *   PERFORMS DB2 INSERT OF JH TABLE.                            *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8000-INSERT-JH.                                                  
      *                                                                         
           MOVE '8000' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_EDI_PYMT_HDR                              
                    (ACH_REF_NO,                                        
                     DEBIT_CREDIT_CD,                                   
                     EDI_BANK_ACCT_NO,                                  
                     EDI_COMPANY_ID,                                    
                     EDI_ROUTING_NO,                                    
                     EFFECTIVE_DT,                                      
      *              EXTRACT_DT,                                                
                     PAYER_NM,                                          
                     SEC_CD,                                            
                     SENDER_BNK_ACCT_NO,                                
                     SENDER_ROUTING_NO,                                 
                     TOTAL_PYMT_AM,                                     
                     TRACE_NO,                                          
                     TRAN_REF_NO,                                       
                     TRANSACTION_TS,                                    
                     VALID_CIS_FL)                                      
              VALUES                                                    
                    (:JH-ACH-REF-NO,                                    
                     :JH-DEBIT-CREDIT-CD,                               
                     :JH-EDI-BANK-ACCT-NO,                              
                     :JH-EDI-COMPANY-ID,                                
                     :JH-EDI-ROUTING-NO,                                
                     IIF(TRY_CONVERT(DATE, :JH-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :JH-EFFECTIVE-DT
              ) <> 0) OR (LEN(:JH-EFFECTIVE-DT) <> 10), CIS.CHAR2DATE(
                                                       :JH-EFFECTIVE-DT
              ), CONVERT(DATE, :JH-EFFECTIVE-DT) ),                            
      *              :JH-EXTRACT-DT,                                            
                     :JH-PAYER-NM,                                      
                     :JH-SEC-CD,                                        
                     :JH-SENDER-BNK-ACCT-NO,                            
                     :JH-SENDER-ROUTING-NO,                             
                     :JH-TOTAL-PYMT-AM,                                 
                     :JH-TRACE-NO,                                      
                     :JH-TRAN-REF-NO,                                   
                     CIS.CHAR2TIMESTAMP(:JH-TRANSACTION-TS),                    
                     :JH-VALID-CIS-FL)                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EDI_PYMT_HDR                                      
MFA-TR*             (ACH_REF_NO,                                                
MFA-TR*              DEBIT_CREDIT_CD,                                           
MFA-TR*              EDI_BANK_ACCT_NO,                                          
MFA-TR*              EDI_COMPANY_ID,                                            
MFA-TR*              EDI_ROUTING_NO,                                            
MFA-TR*              EFFECTIVE_DT,                                              
MFA-TR*              EXTRACT_DT,                                                
MFA-TR*              PAYER_NM,                                                  
MFA-TR*              SEC_CD,                                                    
MFA-TR*              SENDER_BNK_ACCT_NO,                                        
MFA-TR*              SENDER_ROUTING_NO,                                         
MFA-TR*              TOTAL_PYMT_AM,                                             
MFA-TR*              TRACE_NO,                                                  
MFA-TR*              TRAN_REF_NO,                                               
MFA-TR*              TRANSACTION_TS,                                            
MFA-TR*              VALID_CIS_FL)                                              
MFA-TR*       VALUES                                                            
MFA-TR*             (:JH-ACH-REF-NO,                                            
MFA-TR*              :JH-DEBIT-CREDIT-CD,                                       
MFA-TR*              :JH-EDI-BANK-ACCT-NO,                                      
MFA-TR*              :JH-EDI-COMPANY-ID,                                        
MFA-TR*              :JH-EDI-ROUTING-NO,                                        
MFA-TR*              :JH-EFFECTIVE-DT,                                          
MFA-TR*              :JH-EXTRACT-DT,                                            
MFA-TR*              :JH-PAYER-NM,                                              
MFA-TR*              :JH-SEC-CD,                                                
MFA-TR*              :JH-SENDER-BNK-ACCT-NO,                                    
MFA-TR*              :JH-SENDER-ROUTING-NO,                                     
MFA-TR*              :JH-TOTAL-PYMT-AM,                                         
MFA-TR*              :JH-TRACE-NO,                                              
MFA-TR*              :JH-TRAN-REF-NO,                                           
MFA-TR*              :JH-TRANSACTION-TS,                                        
MFA-TR*              :JH-VALID-CIS-FL)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSAC176 PROCESSING ERROR           **'     
              DISPLAY '**   INSERT TO JH TABLE FAILED           **'     
              DISPLAY '**   SQLCODE WAS: WS-ACTIVE-RETURN-CODE  **'     
              DISPLAY ' JH RECORD = ', DCLCSS-EDI-PYMT-HDR              
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *   8100-INSERT-JD                                              *         
      *                                                               *         
      *   PERFORMS DB2 INSERT OF JD TABLE.                            *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8100-INSERT-JD.                                                  
      *                                                                         
           MOVE '8100' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_EDI_PYMT_DET                              
                    (DEBIT_CREDIT_CD,                                   
                     INVOICE_DT,                                        
                     PAYMENT_AM,                                        
                     REF_CUST_ACCT_NO,                                  
                     SEQUENCE_NO,                                       
                     TRAN_COMMENT,                                      
                     TRANSACTION_TS)                                    
              VALUES                                                    
                    (:JD-DEBIT-CREDIT-CD,                               
                     IIF(TRY_CONVERT(DATE, :JD-INVOICE-DT
              ) IS NULL OR (PATINDEX('%.%', :JD-INVOICE-DT
              ) <> 0) OR (LEN(:JD-INVOICE-DT) <> 10), CIS.CHAR2DATE(
                                                         :JD-INVOICE-DT
              ), CONVERT(DATE, :JD-INVOICE-DT) ),                              
                     :JD-PAYMENT-AM,                                    
                     :JD-REF-CUST-ACCT-NO,                              
                     :JD-SEQUENCE-NO,                                   
                     :JD-TRAN-COMMENT,                                  
                     CIS.CHAR2TIMESTAMP(:JD-TRANSACTION-TS))                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EDI_PYMT_DET                                      
MFA-TR*             (DEBIT_CREDIT_CD,                                           
MFA-TR*              INVOICE_DT,                                                
MFA-TR*              PAYMENT_AM,                                                
MFA-TR*              REF_CUST_ACCT_NO,                                          
MFA-TR*              SEQUENCE_NO,                                               
MFA-TR*              TRAN_COMMENT,                                              
MFA-TR*              TRANSACTION_TS)                                            
MFA-TR*       VALUES                                                            
MFA-TR*             (:JD-DEBIT-CREDIT-CD,                                       
MFA-TR*              :JD-INVOICE-DT,                                            
MFA-TR*              :JD-PAYMENT-AM,                                            
MFA-TR*              :JD-REF-CUST-ACCT-NO,                                      
MFA-TR*              :JD-SEQUENCE-NO,                                           
MFA-TR*              :JD-TRAN-COMMENT,                                          
MFA-TR*              :JD-TRANSACTION-TS)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSAC176 PROCESSING ERROR           **'     
              DISPLAY '**   INSERT TO JD TABLE FAILED           **'     
              DISPLAY '**   SQLCODE WAS: WS-ACTIVE-RETURN-CODE  **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *   8200-INSERT-EDI-COMPANY                                     *         
      *                                                               *         
      *   PERFORMS DB2 INSERT OF IB TABLE.                            *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8200-INSERT-IB.                                                  
      *                                                                         
           MOVE '8200' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_EDI_COMPANY                               
                    (EDI_COMPANY_DESC,                                  
                     EDI_COMPANY_ID,                                    
                     LAST_UPDATE_TS,                                    
                     LAST_UPDATE_USERID)                                
              VALUES                                                    
                    (:IB-EDI-COMPANY-DESC,                              
                     :IB-EDI-COMPANY-ID,                                
                     CIS.CURRENT$TIMESTAMP(),                                 
                     :IB-LAST-UPDATE-USERID)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EDI_COMPANY                                       
MFA-TR*             (EDI_COMPANY_DESC,                                          
MFA-TR*              EDI_COMPANY_ID,                                            
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              LAST_UPDATE_USERID)                                        
MFA-TR*       VALUES                                                            
MFA-TR*             (:IB-EDI-COMPANY-DESC,                                      
MFA-TR*              :IB-EDI-COMPANY-ID,                                        
MFA-TR*              CURRENT TIMESTAMP,                                         
MFA-TR*              :IB-LAST-UPDATE-USERID)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSAC176 PROCESSING ERROR           **'     
              DISPLAY '**   INSERT TO IB TABLE FAILED           **'     
              DISPLAY '**   SQLCODE WAS: WS-ACTIVE-RETURN-CODE  **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
RS0301*****************************************************************         
RS0301*                                                               *         
RS0301*   8250-UPDATE-EDI-HEADER                                      *         
RS0301*                                                               *         
RS0301*   PERFORMS DB2 UPDATE OF JH TABLE.                            *         
RS0301*                                                               *         
RS0301*****************************************************************         
RS0301*                                                                         
RS0301 8250-UPDATE-JH.                                                  
RS0301*                                                                         
RS0301     MOVE '8250' TO ACTIVE-PARAGRAPH.                             
RS0301*                                                                         
RS0301     EXEC SQL                                                     
RS0301          UPDATE CSS_EDI_PYMT_HDR                                 
RS0301          SET    TOTAL_PYMT_AM      = :WS-ALPHA-TOT               
RS0301          WHERE  TRANSACTION_TS     = CIS.CHAR2TIMESTAMP(
                                                             :WS-CUR-TS
              )                  
RS0301     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_EDI_PYMT_HDR                                         
MFA-TR*         SET    TOTAL_PYMT_AM      = :WS-ALPHA-TOT                       
MFA-TR*         WHERE  TRANSACTION_TS     = :WS-CUR-TS                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

RS0301*                                                                         
RS0301     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
RS0301*                                                                         
RS0301     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
RS0301        NEXT SENTENCE                                             
RS0301     ELSE                                                         
RS0301        DISPLAY '*******************************************'     
RS0301        DISPLAY '**   PCSAC176 PROCESSING ERROR           **'     
RS0301        DISPLAY '**   UPDATE TO JH TABLE FAILED           **'     
RS0301        DISPLAY '**   SQLCODE WAS: WS-ACTIVE-RETURN-CODE  **'     
RS0301        DISPLAY '*******************************************'     
RS0301        PERFORM 9900-ABEND      THRU 9900-EXIT                    
RS0301     END-IF.                                                      
RS0301*                                                                         
RS0301 8250-EXIT.                                                       
RS0301     EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8300-PRINT-REPORT.                                          **        
      **       WRITES THE HEADER OR OUTPUT RECORDS TO THE REPORT FILE **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8300-PRINT-REPORT.                                               
                                                                        
           MOVE '8300'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              PERFORM 8500-PRINT-RPT-HEADERS                            
                                             THRU 8500-EXIT             
           END-IF.                                                      
                                                                        
           PERFORM 8350-WRITE-DETAIL         THRU 8350-EXIT.            
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8310-PRINT-RPT-NO-DATA.                                     **        
      **       WRITE THE MESSAGE "REPORT DOES NOT EXISTS"             **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8310-PRINT-RPT-NO-DATA.                                          
                                                                        
           MOVE '8310'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           MOVE WS-NO-DATA-LINE              TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
                                                                        
       8310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8350-WRITE-DETAIL.                                          **        
      **       WRITES THE OUTPUT RECORDS TO THE REPORT FILE           **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8350-WRITE-DETAIL.                                               
                                                                        
           MOVE '8350'                       TO WS-ACTIVE-PARAGRAPH.    
           MOVE WS-RPT-DETAIL-LINE-1         TO PRT33-RECORD.           
           ADD  WS-1                         TO WS-LINE-COUNT.          
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
                                                                        
           MOVE WS-MSG-LINE                  TO PRT33-RECORD.           
           ADD  WS-1                         TO WS-LINE-COUNT.          
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8450-PRINT-RPT-FOOTER.                                      **        
      **       WRITES THE FOOTER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8450-PRINT-RPT-FOOTER.                                           
                                                                        
           MOVE '8450'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           IF FIRST-TIME                                                
              PERFORM 8310-PRINT-RPT-NO-DATA THRU 8310-EXIT             
              GO TO 8450-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE    WS-RPT-HEADER-6           TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE 'TOTAL AMOUNT'               TO WS-RPT-VERBIAGE.        
           MOVE WS-TOT-AMT-DB                TO WS-RPT-EDI-AMT-DB-TOT.  
           MOVE WS-TOT-AMT-CR                TO WS-RPT-EDI-AMT-CR-TOT.  
           MOVE WS-RPT-TOTAL-LINE            TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE 'TOTAL COUNT'                TO WS-RPT-VERBIAGE.        
           MOVE WS-CNT-DEBITS                TO WS-RPT-EDI-CNT-DB-TOT.  
           MOVE WS-CNT-CREDITS               TO WS-RPT-EDI-CNT-CR-TOT.  
           MOVE WS-RPT-TOTAL-LINE            TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE    WS-RPT-HEADER-6           TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
           ADD WS-1                          TO WS-LINE-COUNT.          
                                                                        
           MOVE WS-FOOTER                    TO PRT33-RECORD.           
           PERFORM 8900-PRINT-RPT-DETAIL     THRU 8900-EXIT.            
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8500-PRINT-RPT-HEADERS.                                     **        
      **       WRITES THE HEADER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8500-PRINT-RPT-HEADERS.                                          
                                                                        
           MOVE '8500'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
      *    PRINTS COMPANY NAME                                                  
                                                                        
           ADD WS-1                          TO WS-PAGE-COUNT.          
           MOVE WS-PAGE-COUNT                TO P-RPT-PAGE-NO.          
           MOVE WS-REPTNAME                  TO P-RPT-TITLE-PGNM.       
           IF PROCESS-SEB                                               
              MOVE ' SCANA-ENERGY '          TO P-RPT-COMP-NAME         
           END-IF.                                                      
                                                                        
      *    PRINTS REPORT TITLE                                                  
                                                                        
           MOVE    WS-RPT-HEADER-1           TO PRT33-RECORD.           
           WRITE PRT33-RECORD AFTER ADVANCING TOP-OF-PAGE.              
                                                                        
           MOVE    WS-RPT-HEADER-2           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE    WS-RPT-HEADER-3           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE    WS-RPT-HEADER-4           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE    WS-RPT-HEADER-5           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE    WS-RPT-HEADER-6           TO PRT33-RECORD.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE WS-SIX                       TO WS-LINE-COUNT.          
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8900-PRINT-RPT-DETAIL.                                      **        
      **       WRITES THE RECORD IN THE SAME PAGE OR TO THE NEXT PAGE **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8900-PRINT-RPT-DETAIL.                                           
                                                                        
           MOVE '8900'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              MOVE PRT33-RECORD              TO WS-SAVE-PRT33           
              PERFORM 8500-PRINT-RPT-HEADERS THRU 8500-EXIT             
              MOVE WS-SAVE-PRT33             TO PRT33-RECORD            
              WRITE PRT33-RECORD                                        
              MOVE WS-1                      TO WS-LINE-COUNT           
           ELSE                                                         
              WRITE PRT33-RECORD                                        
              MOVE WS-LINE-COUNT             TO WS-TEMP-COUNT           
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **        CLOSE THE EDI820-FILE                                 **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE EDI820-FILE,                                           
                 FCSPT33-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9100-DISPLAY-ERROR.                                         **        
      **       DISPLAY ERROR PARA                                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9100-DISPLAY-ERROR.                                              
            DISPLAY WS-DISP-RC, ' WS-ACTIVE-RETURN-CODE  '.             
            DISPLAY '******************************************'.       
            DISPLAY '** PROCESSING ERROR                     **'.       
            DISPLAY '** PARAGRAPH = ', WS-ACTIVE-PARAGRAPH.             
            DISPLAY '**  ', WS-ERR-MSG.                                 
            DISPLAY '** SQLCODE = ', WS-DISP-RC.                        
            DISPLAY '** PROCESSING TERMINATED                **'.       
            DISPLAY '******************************************'.       
            PERFORM 9900-ABEND              THRU 9900-EXIT.             
       9100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * COPYBOOK FOR ABEND ROUTINE                                     *        
      *                                                                *        
      ******************************************************************        
                                                                        
            EXEC SQL                                                            
                INCLUDE CPD09900                                                
            END-EXEC.                                                           
                                                                        
