       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSAC175.                                            
       DATE-WRITTEN.                                                    
       AUTHOR. BASKAR VANNI.                                            
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*00050000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00060000
      *                          COVANSYS                              *00070000
      *                                                                *00080000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*00090000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*00100000
      *               PROGRAM  MODIFICATION  LOG                       *00110000
      *                                                                *00120000
      *      DATE       INITIALS    REASON                             *00130000
      *    12/10/2001   BASKAR      NEW PROGRAM TO INSERTS ROWS INTO   *00140000
      *                             CSS_BATCH_EMAILC FOR ECUSTOMERS.   *00150000
      *    01/11/2002   BASKAR      INCLUDE ONLY RESIDENTIAL CUSTOMERS *00160000
      *    02/06/2002   BASKAR      INCLUDE SEPARATE BATCH EMAIL CODE  *00170000
      *                             FOR DRAFT WHEN THE STATUS IS       *00180000
      *                             CHANGED TO ACTIVE FROM PRENOTE     *00190000
T26365*    05/01/2002   ESM         ADDED CODE TO SEPARATE PAPER FROM  *00200000
T26365*                             PAPERLESS                          *00210000
T26952*    07/03/2002   ESM         COMMENTED OUT CODE TO ALLOW COMM.  *00211000
T26952*                             CUSTOMERS TO BE PROCESSED.         *00212000
C25964*    08/12/2002   BASKAR      ADD NEW EVENTS FOR E-DRAFT.        *00213000
C28137*    06/04/2003   DPS         ADD COMMERCIAL/INDUSTRIAL ACCOUNTS *00214000
C28314*    06/04/2003   DPS         COMMENT LAST-DRAFT-DATE NULL CHECK *00215000
C30552*    03/25/2004   SS19371     NEW BILL MODIFICATION EMAIL TO     *00216000
C30552*                             CASH ONLY CUSTOMERS                *00217000
C29529*    07/08/2004   BB18179     EPAY EMAIL MODIFICATIONS:          *00218000
      *                             1) DISCONTINUE ECS01               *00219000
      *                             2) DISCONTINUE ECS10               *00219100
      *                             3) ADD SERVICE ADDRESS IF PRESENT  *00219200
      *                                TO THE FOLLOWING EMAIL EVENTS:  *00219300
      *                                ECS02, ECS04, ECS07, ECS08,     *00219400
      *                                ECS11, ECS12, ECS14, ECS15,     *00219500
      *                                AND ECS17                       *00219600
      *                             4) ADD DRAFT DATE IF ACCT ON DRAFT *00219700
      *                                TO THE FOLLOWING EMAIL EVENTS:  *00219800
      *                                ECS03, ECS07, ECS11, ECS12,     *00219900
      *                                AND ECS15                       *00220100
      *                             5) ADD NEW BATCH EMAIL TO NOTIFY   *00220200
      *                                CUSTOMERS THAT THERE IS A       *00220300
      *                                CORRECTED BILL                  *00220400
C31785*    10/29/2004   BB18179     CML 31785 - DISPLAY FIRST 6 CHARS  *00218000
      *                             OF SERVICE ADDRESS, THEN PAD RMDR  *00218000
      *                             WITH '*', AND INCLUDE CITY / STATE.*        
      *                             IE: 1401 MAIN STREET, COLUMBIA SC  *        
      *                             SHOULD DISPLAY AS:                 *        
      *                                 1401 M**********, COLUMBIA SC  *        
C29533*    01/20/2005   VV90387     PROCESS TO PREVENT SENDING BILL    *        
      *                             NOTIFICATION EMAILS BASED ON       *        
      *                             CUSTOMER PREFERENCE                *        
C32791*    05/31/2005   BB18179     CML 32791 - FIX PREM ADDRESS FUNCT *        
      *                             SO THAT SMALL ADDRESSES DON'T CAUSE*        
      *                             OTHER ADDRESSES TO NOT BE POPULATED*        
T35434*    04/16/2008   MR97640     ADDED WITH UR TO AVOID -911 ABENDS.*        
PRJ526*    10/07/2009   CB18344     ADDED NEW AUTOCARD BILL MESSAGES.  *        
PRJ526*    12/16/2009   CB18344     PRODUCTION FIX.                    *        
PRJ228*    02/16/2010   JG41113     ADD CHECKS FOR DNP, SUB ACCOUNTS,  *        
PRJ228*                             JUDGEMENTS, BANKRUPTCIES. INSERT   *        
PRJ228*                             AMT DUE AND DUE DATE IN EMAIL      *        
PRJ228*                             DETAIL TABLE FOR NORMAL, DRAFT, &  *        
PRJ228*                             AUTOCARD ACCOUNTS.                 *        
ACT070*    02/25/2016   MC95456    USE NEXT VALUE FOR BATCH_EMAIL_ID   *        
ACT070*    APPL5460                IN CSS_BATCH_EMAIL TABLE.           *        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*00221000
             REMARKS.                                                   
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*00240000
      *        THIS PROGRAM IS USED TO INSERT ROWS INTO CSS_BATCH_EMAIL*00250000
      *        TABLE FOR AN ECUSTOMER WHO HAS JUST GONE THRU BILLING   *00260000
      *        OR AN ECUSTOMER WHO HAS JUST PRENOTED SUCCESSFULLY.     *00270000
      *        THIS PROGRAM IS ALSO USED TO INSERT ROWS INTO           *00280000
      *        CSS_BATCH_EMAIL FROM A FILE. AT A SINGLE RUN IT EITHER  *00290000
      *        EXTRACTS DEATILS FROM TABLES TO INSERT ROWS OR PROCESS  *00300000
      *        THE INPUT FILE TO INSERT ROWS.                          *00310000
      * THE FOLLOWING EVENT CODES ARE USED.                             00311000
      * ECS01 - EPAY - PRENOTE TO ACTIVE                                00312000
      * ECS02 - EBILL                                                   00313000
      * ECS03 - EBILL & DRAFT                                           00314000
      * ECS04 - EBILL & EPAY                                            00315000
      * ECS05 - DRAFT -  PRENOTE TO ACTIVE                              00316000
      * ECS06 - USED FOR ONE TIME EVENT                                 00317000
      * ECS07 - DRAFT & EBILL PAPERLESS                                 00318000
      * ECS08 - EPAY  & EBILL PAPERLESS                                 00319000
      * ECS09 - USED FOR ONE TIME EVENT                                 00319100
      * ECS10 - E-DRAFT -  PRENOTE TO ACTIVE                            00319200
      * ECS11 - EDRAFT & EBILL                                          00319300
      * ECS12 - EDRAFT & EBILL PAPERLESS                                00319400
      * ECS13 - ????   SUPERSTITIOUS ??                                 00319500
C28137* ECS14 - IND/COMMERCIAL EBILL IND                                00319600
C28137* ECS15 - IND/COMMERCIAL BANKDRAFT & EBILL                        00319700
C30552* ECS17 - CASH ONLY EBILL                                         00319800
PRJ526* ECS27 - SCEG AUTOCARD/EBILL PAPERLESS                           00319800
PRJ526* ECS28 - SCEG AUTOCARD/EBILL PAPER BILL                          00319800
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*00320000
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
            SELECT FCSAC175-FILE ASSIGN  UT-S-FCSAC175                  
                   FILE STATUS IS WS-FAC175-STATUS.                     
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCSAC175-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
                                                                        
       01  FCSAC175-DETAIL.                                             
           05  E-FAC175-ACCOUNT-NO         PIC 9(13).                   
           05  E-FAC175-CUSTOMER-NO        PIC 9(10).                   
           05  E-FAC175-COMPANY-NO         PIC X(02).                   
           05  E-FAC175-EMAIL-EVENT-CD     PIC X(05).                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC175'.
MSQ017     COPY MFASQLM.
       01  WS-START                        PIC X(40) VALUE              
           'WORKING STORAGE FOR PCSAC175 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-PGRMNAME                 PIC X(10)  VALUE 'PCSAC175'. 
C29529     05  PROGRAM-NAME                PIC X(08)  VALUE 'PCSAC175'. 
           05  WS-NULL-INDICATOR           PIC S9(04) VALUE +0 COMP.    
           05  WS-COMMON                   PIC X(10)  VALUE 'COMMON  '. 
           05  WS-SELECT-IND               PIC X(01)  VALUE SPACES.     
PRJ526     05  WS-AUTOCARD-FLAG            PIC X(01)  VALUE SPACE.      
PRJ228     05  WS-DISP-BANK-ACCT           PIC X(01)  VALUE 'Y'.        
PRJ228     05  WS-BBP-IND                  PIC X(01)  VALUE SPACE.      
PRJ228     05  WS-EDRAFT-IND               PIC X(01)  VALUE SPACE.      
           05  WS-FAC175-STATUS            PIC X(02)  VALUE '00'.       
               88  WS-FAC175-SUCCESSFUL               VALUE '00'.       
           05  WS-END-OF-FILE              PIC X(01)  VALUE 'N'.        
               88  WS-END-OF-FCSAC175                 VALUE 'Y'.        
C28137     05  WS-ACCOUNT-TYPE             PIC X(01).                   
               88 IS-COMM-OR-IND           VALUE 'C' 'I'.               
C29529     05  RS-RETURN-CODE              PIC S9(4) COMP.              
C29529     05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
COB305     05 WS-AT-REV-MTH-LST-NRML        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.     
PRJ228     05  WS-AT-REV-MTH-LST-NRML-NUM  REDEFINES                    
                                       WS-AT-REV-MTH-LST-NRML PIC X(06).
PRJ228     05  WS-AT-REV-MTH-LST-NRML-ALPHA PIC X(06).                  
PRJ228     05  WS-AMOUNT-DUE               PIC -(9).9(2).               
PRJ228     05  WS-ZERO                     PIC -(9).9(2).               
PRJ228     05  WS-CL-AMT-NOTICE            PIC -(9).9(2).               
PRJ228     05  WS-DEPDNPLIM-01             PIC -(9).9(2).               
PRJ228     05  WS-RTCDNPLIM-01             PIC -(9).9(2).               
PRJ228     05  WS-SECONDDNPL-01            PIC -(9).9(2).               
PRJ228     05  WS-DEPDNPLIM-26             PIC -(9).9(2).               
PRJ228     05  WS-RTCDNPLIM-26             PIC -(9).9(2).               
PRJ228     05  WS-SECONDDNPL-26            PIC -(9).9(2).               
PRJ228     05  WS-DATE-DUE                 PIC X(10) VALUE SPACES.      
PRJ228     05  WS-SEE-BILL                 PIC X(7) VALUE 'SEEBILL'.    
PRJ228     05  WS-DNP                      PIC X(01) VALUE 'N'.         
PRJ228     05  WS-ANNIVERSARY              PIC X(01) VALUE 'N'.         
PRJ228     05  WS-AMT-FLAG                 PIC X(01) VALUE 'Y'.         
PRJ228     05  WS-DT-FLAG                  PIC X(01) VALUE 'Y'.         
PRJ228     05  WS-NULL-IND-3               PIC S9(04) COMP.             
PRJ228     05  WS-AMT-DEPDNPLIM-01         PIC -(4).9(5).               
PRJ228     05  WS-AMT-DEPDNPLIM-26         PIC -(4).9(5).               
PRJ228     05  WS-AMT-RTCDNPLIM-01         PIC -(4).9(5).               
PRJ228     05  WS-AMT-RTCDNPLIM-26         PIC -(4).9(5).               
PRJ228     05  WS-AMT-SECONDDNPL-01        PIC -(4).9(5).               
PRJ228     05  WS-AMT-SECONDDNPL-26        PIC -(4).9(5).               
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-M                        PIC X(01)  VALUE 'M'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
C25964     05  WS-01                       PIC X(02)  VALUE '01'.       
C25964     05  WS-02                       PIC X(02)  VALUE '02'.       
C29529     05  WS-EML-END-REC              PIC X(05)  VALUE 'ENDRE'.    
           05  WS-ECS01                    PIC X(05)  VALUE 'ECS01'.    
           05  WS-ECS02                    PIC X(05)  VALUE 'ECS02'.    
           05  WS-ECS03                    PIC X(05)  VALUE 'ECS03'.    
           05  WS-ECS04                    PIC X(05)  VALUE 'ECS04'.    
           05  WS-ECS05                    PIC X(05)  VALUE 'ECS05'.    
T26365     05  WS-ECS07                    PIC X(05)  VALUE 'ECS07'.    
T26365     05  WS-ECS08                    PIC X(05)  VALUE 'ECS08'.    
T25964     05  WS-ECS10                    PIC X(05)  VALUE 'ECS10'.    
T25964     05  WS-ECS11                    PIC X(05)  VALUE 'ECS11'.    
T25964     05  WS-ECS12                    PIC X(05)  VALUE 'ECS12'.    
C28137     05  WS-ECS14                    PIC X(05)  VALUE 'ECS14'.    
C28137     05  WS-ECS15                    PIC X(05)  VALUE 'ECS15'.    
C30552     05  WS-ECS17                    PIC X(05)  VALUE 'ECS17'.    
C29529     05  WS-ECS21                    PIC X(05)  VALUE 'ECS21'.    
PRJ526     05  WS-ECS27                    PIC X(05)  VALUE 'ECS27'.    
PRJ526     05  WS-ECS28                    PIC X(05)  VALUE 'ECS28'.    
       01  WS-RESTART-MISC.                                             
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04)  VALUE 50.         
           05  WS-CHKP-LUW-LIMIT           PIC 9(05)  VALUE ZERO.       
           05  WS-LUW-PROCESSED            PIC S9(07) VALUE ZERO COMP-3.
           05  WS-RECORDS-PROCESSED        PIC S9(07) VALUE ZERO COMP-3.
           05  WS-COMMIT-NUMBER            PIC S9(04) VALUE +0 COMP.    
           05  WS-ACCOUNT-NUMBER           PIC  9(13) VALUE 0  COMP.    
           05  WS-IS-THIS-A-RESTART        PIC X(01)  VALUE 'N'.        
               88  WS-THIS-IS-A-RESTART               VALUE 'Y'.        
               88  WS-NOT-A-RESTART                   VALUE 'N'.        
           05  WS-RESTART-RECORD           PIC X(01)  VALUE 'N'.        
               88  WS-RESTART-REC-FOUND               VALUE 'Y'.        
               88  WS-RESTART-REC-NOT-FOUND           VALUE 'N'.        
           05  WS-COMMIT-DATA.                                          
               10  WS-COMMIT-TEXT          PIC X(09).                   
               10  WS-COMMIT-NUM           PIC 9(05).                   
               10  FILLER                  PIC X(66).                   
           05  WS-DISPLAY-KEY.                                          
               10  WS-DISPLAY-ACCOUNT      PIC 9(13).                   
               10  WS-DISPLAY-CUSTOMER     PIC 9(10).                   
               10  WS-DISPLAY-DATE         PIC X(10).                   
               10  WS-DISPLAY-CODE         PIC X(05).                   
                                                                        
C29529 01  WS-EML-INFO.                                                 
C29529     05  WS-EML-ALERT                PIC X(01) VALUE 'N'.         
C29529         88  WS-NOTIFY-PROD-SUPP               VALUE 'Y'.         
C29529     05  WS-ADD-FIELD                PIC X(10).                   
C29529         88  WS-ADD-DRAFT-DT                  VALUE 'DRAFT-DT'.   
PRJ228         88  WS-ADD-DRAFT-AMT                 VALUE 'DRAFT-AMT'.  
PRJ228         88  WS-ADD-CHRGE-DT                  VALUE 'CHRGE-DT'.   
PRJ228         88  WS-ADD-CHRGE-AMT                 VALUE 'CHRGE-AMT'.  
PRJ228         88  WS-ADD-BILLD-DT                  VALUE 'BILLD-DT'.   
PRJ228         88  WS-ADD-BILLD-AMT                 VALUE 'BILLD-AMT'.  
PRJ228         88  WS-ADD-BANK-ACCT                 VALUE 'BANK-ACCT'.  
C29529         88  WS-ADD-PREM-ADDR                 VALUE 'PREM-ADDR'.  
C29529     05  WS-EML-NULL-IND             PIC S9(04) VALUE +0 COMP.    
C29529     05  WS-CANX-REBILL-IND          PIC X(01).                   
C29529         88  WS-CANX-REBILL-YES                VALUE 'Y'.         
C29529     05  WS-CR-NULL-IND              PIC S9(04) VALUE +0 COMP.    
C29529     05  WS-BILLING-EML-IND          PIC X(01).                   
C29529         88  WS-BILLING-EML-YES                VALUE 'Y'.         
C29529     05  WS-BILL-EML-NULL-IND        PIC S9(04) VALUE +0 COMP.    
C29529     05  WS-EML-COUNT-DIFF           PIC 9(04) VALUE 0.           
C29529     05  WS-COUNT                    PIC 9(04).                   
C31785     05  WS-MASK                     PIC S9(04) COMP VALUE 6.     
C31785     05  WS-MASK-COMPANY-01          PIC S9(04) COMP VALUE 6.     
C31785     05  WS-MASK-COMPANY-26          PIC S9(04) COMP VALUE 6.     
C31785     05  WS-MASK-STREET              PIC X(50).                   
C31785     05  WS-ADDRESS-SIZE             PIC X(01).                   
C32791         88  WS-ADDRESS-NORMAL                  VALUE 'N'.        
C31785         88  WS-ADDRESS-SMALL                   VALUE 'Y'.        
C31785     05  WS-CHECK-COUNT-IND          PIC X(01).                   
C31785         88  WS-CHECK-COUNT-YES                 VALUE 'Y'.        
C31785         88  WS-CHECK-COUNT-NO                  VALUE 'N'.        
C31785     05  WS-MASK-START               PIC S9(04) COMP.             
C31785     05  WS-MASK-DIFF                PIC S9(04) COMP.             
C29529     05  WS-EML-EVENT-EXIST          PIC X(01).                   
C29529         88  WS-EML-EVENT-FOUND                VALUE 'Y'.         
C29529     05  WS-EML-PREM-ADDR            PIC X(108).                  
C29529     05  WS-EML-PREM-ADDR-LEN        PIC S9(04) COMP.             
C31785     05  WS-EML-CITY-STATE-LEN       PIC S9(04) COMP.             
C29529     05  WS-EML-MAX-ENTRY            PIC 9(04) VALUE 500.         
PRJ228     05  WS-MASK-BANK-ACCT-01        PIC S9(04) COMP VALUE 4.     
PRJ228     05  WS-MASK-BANK-ACCT-26        PIC S9(04) COMP VALUE 4.     
C31785     05  WS-BANK-MASK                PIC S9(04) COMP VALUE 4.     
C29529*****                                                             01192202
C29529*  N O T E :  KEEP THE # IN THE VALUE CLAUSE OF WS-EML-MAX-ENTRY  01192302
C29529*             IN SYNC WITH THE OCCURS CLAUSE IN WS-EML-DATA       01192402
C29529*             -THE CODE CHECKS WS-EML-MAX-ENTRY TO MAKE SURE      01192502
C29529*              IT DOESN'T GO OUT OF BOUNDS AND ABEND.             01192602
C29529*****                                                             01192702
C29529     05  WS-EML-DATA                                              
C29529         OCCURS 500 TIMES.                                        
C29529*  SEE NOTE ABOVE WHEN INCREASING OCCURS CLAUSE                           
C29529         10  WS-EML-COMPANY-NO       PIC X(02).                   
C29529         10  WS-EML-EVENT-CD         PIC X(05).                   
C29529         10  WS-EML-SRV-ADR-FL       PIC X(01).                   
C29529         10  WS-EML-DRFT-DT-FL       PIC X(01).                   
PRJ228         10  WS-EML-DRFT-AMT-FL      PIC X(01).                   
PRJ228         10  WS-EML-CHRGE-DT-FL      PIC X(01).                   
PRJ228         10  WS-EML-CHRGE-AMT-FL     PIC X(01).                   
PRJ228         10  WS-EML-BILLD-DT-FL      PIC X(01).                   
PRJ228         10  WS-EML-BILLD-AMT-FL     PIC X(01).                   
PRJ228         10  WS-EML-BANK-ACCT-FL     PIC X(01).                   
                                                                        
C29533 01  WS-EMAIL-IND                    PIC X(01).                   
C29533     88    WS-SEND-EMAIL                       VALUE 'Y'.         
C29533     88    WS-DO-NOT-SEND-EMAIL                VALUE 'N'.         
                                                                        
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-KEY.                                          
COB305         10 WS-RESTART-ACCOUNT        PIC 9(13) COMP-3 VALUE 0.           
               10  WS-RESTART-CUSTOMER     PIC 9(10).                   
               10  WS-RESTART-EVENT-DATE   PIC X(10).                   
               10  WS-RESTART-EVENT-CD     PIC X(05).                   
                                                                        
       COPY CWS00038.                                                   01270000
       COPY CWS09900.                                                   01280000
       COPY CWS00303.                                                   01290000
C29529 COPY CWS00010.                                                           
C29529 COPY CWS00011.                                                           
       COPY FIOJC01.                                                    01300000
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01320000
      * SQL COMMUNICATION AREA                                        * 01330000
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01340000
           EXEC SQL                                                     01350000
                INCLUDE SQLCA                                           01360000
           END-EXEC.                                                    01370000
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01390000
      * CSS_ACCOUNT                                                   * 01400000
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01410000
           EXEC SQL                                                     01420000
                INCLUDE TBACCT                                          01430000
           END-EXEC.                                                    01440000
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01460000
      * CSS_JOB_PARM                                                  * 01470000
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01480000
           EXEC SQL                                                     01490000
                INCLUDE TBJBPARM                                        01500000
           END-EXEC.                                                    01510000
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01600000
      * CSS_BATCH_EMAIL                                               * 01610000
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01620000
           EXEC SQL                                                     01630000
               INCLUDE TBBEMAIL                                         01640000
           END-EXEC.                                                    01650000
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01740000
      * CSS_BANK_EFT                                                  * 01750000
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01760000
           EXEC SQL                                                     01770000
               INCLUDE TBBNKEFT                                         01780000
           END-EXEC.                                                    01790000
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01810000
      * CSS_BILLING_HDR                                               * 01820000
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01830000
           EXEC SQL                                                     01840000
               INCLUDE TBBLLHDR                                         01850000
           END-EXEC.                                                    01860000
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01880000
      * CSS_RESTART                                                   * 01890000
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 01900000
           EXEC SQL                                                     01910000
               INCLUDE TBRESTRT                                         01920000
           END-EXEC.                                                    01930000
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 02011000
      * CSS_CREDIT_PROFILE                                            * 02012000
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* 02013000
           EXEC SQL                                                     02014000
               INCLUDE TBCRPROF                                         02015000
           END-EXEC.                                                    02016000
                                                                        
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CSS_BTCH_EMAIL_DET (PREFIX = JK)                              *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE TBBTEDET                                                 
C29529     END-EXEC.                                                            
                                                                        
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CSS_DELINQUENCY    (PREFIX = C8)                              *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE TBDELQ                                                   
C29529     END-EXEC.                                                            
                                                                        
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CSS_PNDNG_BNK_DRFT (PREFIX = PB)                              *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE TBPDBKDF                                                 
C29529     END-EXEC.                                                            
                                                                        
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CSS_NAME           (PREFIX = DQ)                              *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE TBNAME                                                   
C29529     END-EXEC.                                                            
                                                                        
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CSS_NAME_ACCT_XREF (PREFIX = HT)                              *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE TBNMACTX                                                 
C29529     END-EXEC.                                                            
                                                                        
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CSS_CUST_ADDR_XREF (PREFIX = DM)                              *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE TBCSADRX                                                 
C29529     END-EXEC.                                                            
                                                                        
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CSS_FREEFORM_ADDR  (PREFIX = DZ)                              *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE TBADRFRE                                                 
C29529     END-EXEC.                                                            
                                                                        
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CSS_FORMATTED_ADDR (PREFIX = DY)                              *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE TBADRFMT                                                 
C29529     END-EXEC.                                                            
                                                                        
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CSS_ZIP_CODE       (PREFIX = A4)                              *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE TBZIPCD                                                  
C29529     END-EXEC.                                                            
                                                                        
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CSS_ACCOUNT_MISC   (PREFIX = TA)                              *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE TBATMISC                                                 
C29529     END-EXEC.                                                            
                                                                        
C29533*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ526* CSS_ACCT_ATTRIBUTE (PREFIX = YP)                              *         
C29533*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29533     EXEC SQL                                                             
C29533         INCLUDE TBACTATT                                                 
C29533     END-EXEC.                                                            
                                                                        
PRJ526*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ526* CSS_PNDNG_CARD_PMT (PREFIX = PC)                              *         
PRJ526*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ526     EXEC SQL                                                             
PRJ526         INCLUDE TBPNDCRD                                                 
PRJ526     END-EXEC.                                                            
PRJ526                                                                  
PRJ228*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ228* CSS_CRED_COLL (PREFIX = CL)                                   *         
PRJ228*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ228     EXEC SQL                                                             
PRJ228         INCLUDE TBCRCOLL                                                 
PRJ228     END-EXEC.                                                            
PRJ228                                                                  
PRJ228*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ228* CSS_BUDGET_PLAN (PREFIX = BU)                                 *         
PRJ228*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ228     EXEC SQL                                                             
PRJ228         INCLUDE TBBGTPLN                                                 
PRJ228     END-EXEC.                                                            
PRJ228                                                                  
PRJ228*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ228* CSS_CUSTOMER_BANK (PREFIX = JF)                               *         
PRJ228*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ228     EXEC SQL                                                             
PRJ228         INCLUDE TBCSTBNK                                                 
PRJ228     END-EXEC.                                                            
PRJ228                                                                  
PRJ228*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ228* CSS_AR_TRANS_HIST (PREFIX = AR)                               *         
PRJ228*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ228     EXEC SQL                                                             
PRJ228         INCLUDE TBARHIST                                                 
PRJ228     END-EXEC.                                                            
PRJ228                                                                  
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* COPYBOOK FOR NAME / ADDRESS ROUTINE                           *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE CWS00074                                                 
C29529     END-EXEC.                                                            
                                                                        
C29529*---------------------------------------------------------------* 02016203
C29529* CURSOR FOR FETCHING DELINQUENCY INFO FOR EMAILS.              * 02016303
C29529*---------------------------------------------------------------* 02016503
C29529     EXEC SQL                                                     
C29529          DECLARE EML_DELINQ CURSOR WITH HOLD FOR                 
C29529           SELECT C8.COMPANY_NO                                   
C29529                 ,C8.DELINQ_CD                                    
C31785                 ,C8.DELINQ_VALUE                                 
C29529             FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                
C29529            WHERE C8.DELINQ_CD LIKE 'SW-ECS%'                     
C29529              AND C8.DELINQ_VALUE = 1                             
C31785               OR C8.DELINQ_CD LIKE 'NO-ECS%'                     
PRJ228               OR C8.DELINQ_CD = 'AMT-DEPDNPLIM'                  
PRJ228               OR C8.DELINQ_CD = 'AMT-RTCDNPLIM'                  
PRJ228               OR C8.DELINQ_CD = 'AMT-SECONDDNPL'                 
C29529            ORDER BY C8.COMPANY_NO                                
C29529                    ,C8.DELINQ_CD                                 
T35434              FOR READ ONLY                               
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02016603
MFA-TR*         DECLARE EML_DELINQ CURSOR WITH HOLD FOR                 02016703
MFA-TR*          SELECT C8.COMPANY_NO                                   02016803
MFA-TR*                ,C8.DELINQ_CD                                    02016903
MFA-TR*                ,C8.DELINQ_VALUE                                         
MFA-TR*            FROM CSS_DELINQUENCY C8                              02017103
MFA-TR*           WHERE C8.DELINQ_CD LIKE 'SW-ECS%'                     02017203
MFA-TR*             AND C8.DELINQ_VALUE = 1                             02017304
MFA-TR*              OR C8.DELINQ_CD LIKE 'NO-ECS%'                             
MFA-TR*              OR C8.DELINQ_CD = 'AMT-DEPDNPLIM'                          
MFA-TR*              OR C8.DELINQ_CD = 'AMT-RTCDNPLIM'                          
MFA-TR*              OR C8.DELINQ_CD = 'AMT-SECONDDNPL'                         
MFA-TR*           ORDER BY C8.COMPANY_NO                                02017403
MFA-TR*                   ,C8.DELINQ_CD                                 02017503
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                    02017603
                                                                        
      *---------------------------------------------------------------* 02020000
      * CURSOR FOR FETCHING ECUSTOMERS WHO HAS JUST GONE THRU BILLING * 02030000
      * OR ECUSTOMERS WHO HAS JUST PRENOTED SUCCESSFULLY.             * 02040000
      *---------------------------------------------------------------* 02050000
           EXEC SQL                                                     
             DECLARE ECUST CURSOR WITH HOLD FOR                         
              SELECT DISTINCT(AT.ACCOUNT_NO)                            
                     ,AT.CUSTOMER_NO                                    
                     ,AT.COMPANY_NO                                     
C28137               ,AT.ACCOUNT_TYPE_CODE                              
T26365               ,AT.NO_BILL_COPIES                                 
                     ,BI.DATE_BILLED                                    
                     ,'C'                                               
C25964               ,'00'                                              
PRJ228               ,AT.BANKRUPTCY_IND                                 
PRJ228               ,AT.JUDGEMENT_IND                                  
PRJ228               ,AT.CREDIT_GROUP                                   
PRJ228               ,AT.CODES_DATA_PRESENT                             
PRJ228               ,AT.REV_MTH_LST_NRML                               
PRJ228               ,AT.TOTAL_AR_BALANCE                               
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                     ,CSS_CUST_STATS CE WITH(READUNCOMMITTED)                   
                     ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                  
               WHERE CE.EBILL_REGISTER_IND = 'Y'                        
                 AND CE.CUSTOMER_NO        = AT.CUSTOMER_NO             
                 AND AT.ACCOUNT_NO         = BI.ACCOUNT_NO              
                 AND BI.DATE_BILLED        = IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )            
               UNION ALL                                                
              SELECT AT.ACCOUNT_NO                                      
                     ,AT.CUSTOMER_NO                                    
                     ,AT.COMPANY_NO                                     
C28137               ,AT.ACCOUNT_TYPE_CODE                              
T26365               ,AT.NO_BILL_COPIES                                 
                     ,MAX(BI.DATE_BILLED)                               
                     ,BE.STATUS_CODE                                    
C25964               ,BE.INIT_TYPE_CD                                   
PRJ228               ,AT.BANKRUPTCY_IND                                 
PRJ228               ,AT.JUDGEMENT_IND                                  
PRJ228               ,AT.CREDIT_GROUP                                   
PRJ228               ,AT.CODES_DATA_PRESENT                             
PRJ228               ,AT.REV_MTH_LST_NRML                               
PRJ228               ,AT.TOTAL_AR_BALANCE                               
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                     ,CSS_CUST_STATS CE WITH(READUNCOMMITTED)                   
                     ,CSS_BANK_EFT BE WITH(READUNCOMMITTED)                     
                     ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                  
               WHERE CE.EBILL_REGISTER_IND = 'Y'                        
                 AND CE.CUSTOMER_NO        = AT.CUSTOMER_NO             
                 AND AT.ACCOUNT_NO         = BI.ACCOUNT_NO              
                 AND AT.ACCOUNT_NO         = BE.ACCOUNT_NO              
                 AND BE.STATUS_CODE IN ('A','M')                        
                 AND BE.STATUS_CHANGE_DT   = IIF(TRY_CONVERT(DATE, 
                                                   :BE-STATUS-CHANGE-DT
              ) IS NULL OR (PATINDEX('%.%', :BE-STATUS-CHANGE-DT
              ) <> 0) OR (LEN(:BE-STATUS-CHANGE-DT
              ) <> 10), CIS.CHAR2DATE(:BE-STATUS-CHANGE-DT
              ), CONVERT(DATE, :BE-STATUS-CHANGE-DT) )       
            GROUP BY AT.ACCOUNT_NO,AT.CUSTOMER_NO,AT.COMPANY_NO         
C28137              ,AT.ACCOUNT_TYPE_CODE                               
T26365              ,AT.NO_BILL_COPIES,BE.STATUS_CODE                   
C25964              ,BE.INIT_TYPE_CD,AT.BANKRUPTCY_IND,AT.JUDGEMENT_IND 
PRJ228              ,AT.CREDIT_GROUP,AT.CODES_DATA_PRESENT              
PRJ228              ,AT.REV_MTH_LST_NRML, AT.TOTAL_AR_BALANCE           
            ORDER BY 1                                                  
T35434           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02060000
MFA-TR*      DECLARE ECUST CURSOR WITH HOLD FOR                         02070000
MFA-TR*       SELECT DISTINCT(AT.ACCOUNT_NO)                            02080000
MFA-TR*              ,AT.CUSTOMER_NO                                    02090000
MFA-TR*              ,AT.COMPANY_NO                                     02100000
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                              02101000
MFA-TR*              ,AT.NO_BILL_COPIES                                 02110000
MFA-TR*              ,BI.DATE_BILLED                                    02120000
MFA-TR*              ,'C'                                               02140000
MFA-TR*              ,'00'                                              02141000
MFA-TR*              ,AT.BANKRUPTCY_IND                                 02141000
MFA-TR*              ,AT.JUDGEMENT_IND                                  02141000
MFA-TR*              ,AT.CREDIT_GROUP                                   02141000
MFA-TR*              ,AT.CODES_DATA_PRESENT                             02141000
MFA-TR*              ,AT.REV_MTH_LST_NRML                               02141000
MFA-TR*              ,AT.TOTAL_AR_BALANCE                               02141000
MFA-TR*         FROM CSS_ACCOUNT AT                                     02150000
MFA-TR*              ,CSS_CUST_STATS CE                                 02160000
MFA-TR*              ,CSS_BILLING_HDR BI                                02170000
MFA-TR*        WHERE CE.EBILL_REGISTER_IND = 'Y'                        02190000
MFA-TR*          AND CE.CUSTOMER_NO        = AT.CUSTOMER_NO             02200000
MFA-TR*          AND AT.ACCOUNT_NO         = BI.ACCOUNT_NO              02210000
MFA-TR*          AND BI.DATE_BILLED        = :BI-DATE-BILLED            02240000
MFA-TR*        UNION ALL                                                02250000
MFA-TR*       SELECT AT.ACCOUNT_NO                                      02260000
MFA-TR*              ,AT.CUSTOMER_NO                                    02270000
MFA-TR*              ,AT.COMPANY_NO                                     02280000
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                              02281000
MFA-TR*              ,AT.NO_BILL_COPIES                                 02290000
MFA-TR*              ,MAX(BI.DATE_BILLED)                               02300000
MFA-TR*              ,BE.STATUS_CODE                                    02320000
MFA-TR*              ,BE.INIT_TYPE_CD                                   02321000
MFA-TR*              ,AT.BANKRUPTCY_IND                                 02141000
MFA-TR*              ,AT.JUDGEMENT_IND                                  02141000
MFA-TR*              ,AT.CREDIT_GROUP                                   02141000
MFA-TR*              ,AT.CODES_DATA_PRESENT                             02141000
MFA-TR*              ,AT.REV_MTH_LST_NRML                               02141000
MFA-TR*              ,AT.TOTAL_AR_BALANCE                               02141000
MFA-TR*         FROM CSS_ACCOUNT AT                                     02330000
MFA-TR*              ,CSS_CUST_STATS CE                                 02340000
MFA-TR*              ,CSS_BANK_EFT BE                                   02350000
MFA-TR*              ,CSS_BILLING_HDR BI                                02360000
MFA-TR*        WHERE CE.EBILL_REGISTER_IND = 'Y'                        02380000
MFA-TR*          AND CE.CUSTOMER_NO        = AT.CUSTOMER_NO             02390000
MFA-TR*          AND AT.ACCOUNT_NO         = BI.ACCOUNT_NO              02400000
MFA-TR*          AND AT.ACCOUNT_NO         = BE.ACCOUNT_NO              02410000
MFA-TR*          AND BE.STATUS_CODE IN ('A','M')                        02440000
MFA-TR*          AND BE.STATUS_CHANGE_DT   = :BE-STATUS-CHANGE-DT       02450000
MFA-TR*     GROUP BY AT.ACCOUNT_NO,AT.CUSTOMER_NO,AT.COMPANY_NO         02470000
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                               02471000
MFA-TR*             ,AT.NO_BILL_COPIES,BE.STATUS_CODE                   02480000
MFA-TR*             ,BE.INIT_TYPE_CD,AT.BANKRUPTCY_IND,AT.JUDGEMENT_IND 02481000
MFA-TR*             ,AT.CREDIT_GROUP,AT.CODES_DATA_PRESENT                      
MFA-TR*             ,AT.REV_MTH_LST_NRML, AT.TOTAL_AR_BALANCE                   
MFA-TR*     ORDER BY 1                                                  02490000
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                    02500000
                                                                        
       01  WS-END                          PIC X(40) VALUE              
          'WORKING STORAGE FOR PCSAC175 ENDS HERE  '.                   
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARM.                                                        
           05  PARMLEN                 PIC 9(03)  USAGE COMP.           
           05  PARMTXT                 PIC X(10).                       
               88  READ-FILE                      VALUE 'READFILE=Y'.   
                                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*02630000
      *                                                                *02640000
      *   0000-MAINLINE.                                               *02650000
      *        CONTROLS MAIN PATH OF PROGRAM                           *02660000
      *                                                                *02670000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*02680000
                                                                        
       PROCEDURE DIVISION USING PARM.                                   
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                     TO WS-ACTIVE-PARAGRAPH       
           PERFORM 1000-INITIALIZATION     THRU 1000-EXIT               
                                                                        
           IF READ-FILE                                                 
              PERFORM 2050-PROCESS-FILE    THRU 2050-EXIT               
           ELSE                                                         
              PERFORM 2000-PROCESS-CURSOR  THRU 2000-EXIT               
           END-IF                                                       
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-PGRMNAME             TO RF-NAME-PROGRAM           
              MOVE 1                       TO RF-DUP-CNTRL-NO           
              MOVE 1                       TO RF-PARTITION-NO           
              PERFORM 8930-DELETE-RESTART-RECORD                        
                                           THRU 8930-EXIT               
           END-IF                                                       
                                                                        
           PERFORM 9000-TERMINATE          THRU 9000-EXIT               
                                                                        
C29529     IF WS-NOTIFY-PROD-SUPP                                       
C29529        MOVE 02 TO RETURN-CODE                                    
C29529        DISPLAY '***************************************'         
C29529        DISPLAY '**  ----->  W A R N I N G  <-----'               
C29529        DISPLAY '**  PARAGRAPH   = 0000-MAINLINE'                 
C29529        DISPLAY '**  INTERNAL TABLE SIZE NEEDS TO'                
C29529        DISPLAY '**  BE INCREASED BY 500.'                        
C29529        DISPLAY '**  TABLE NAME   = WS-EML-DATA'                  
C29529        DISPLAY '**  MAX ENTRIES  = ' WS-EML-MAX-ENTRY            
C29529        DISPLAY '**  RMNG ENTRIES = ' WS-EML-COUNT-DIFF           
C29529        DISPLAY '**  IF RMNG ENTRIES = 0 (CRITICAL)'              
C29529        DISPLAY '**     UPDATE PROGRAM TOMORROW'                  
C29529        DISPLAY '**  IF RMNG ENTRIES > 0 (NOT AS CRITICAL)'       
C29529        DISPLAY '**     UPDATE PROGRAM ASAP'                      
C29529        DISPLAY '**  YOU MAY POST JOB COMPLETE!'                  
C29529        DISPLAY '***************************************'         
C29529     END-IF                                                       
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*02980000
      *                                                                *02990000
      *    1000-INITIALIZATION.                                        *03000000
      *         GETS JOB PARM DATE AND CHECKS FOR RESTART RECORD       *03010000
      *                                                                *03020000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*03030000
       1000-INITIALIZATION.                                             
                                                                        
           MOVE '1000'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           OPEN INPUT  FCSAC175-FILE                                    
                                                                        
           IF WS-FAC175-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**       PCSAC175   PROCESSING ERROR       **'   
              DISPLAY '     OPEN ERROR OF FCSAC175 INPUT FILE '         
              DISPLAY '     FILE STATUS = ' WS-FAC175-STATUS            
              DISPLAY '**         PROCESSING TERMINATED           **'   
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
                                                                        
           SET  WS-NOT-A-RESTART           TO TRUE                      
           MOVE WS-PGRMNAME                TO RF-NAME-PROGRAM           
           MOVE 1                          TO RF-DUP-CNTRL-NO           
                                              RF-PARTITION-NO           
                                                                        
           PERFORM 8910-CHECK-FOR-RESTART  THRU 8910-EXIT               
                                                                        
           PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT               
           IF COMMON-DATE-NEEDED                                        
              MOVE WS-COMMON               TO WS-PGRMNAME               
              MOVE SPACES                  TO WS-INPUT-AREA             
              MOVE SPACES                  TO WS-INPUT-DATA-BREAKDOWN   
              PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT               
              MOVE 'PCSAC175'              TO WS-PGRMNAME               
           END-IF                                                       
                                                                        
           MOVE WS-INPUT-DATE              TO BI-DATE-BILLED            
                                              BE-STATUS-CHANGE-DT       
                                                                        
           PERFORM 1010-COMMIT-JOB-PARM    THRU 1010-EXIT               
                                                                        
C29529     PERFORM 1100-LOAD-DELINQ-INFO   THRU 1100-EXIT               
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*03450000
      *                                                                *03460000
      *    1010-COMMIT-JOB-PARM                                        *03470000
      *         GETS THE JOB PARM FOR COMMIT LOGIC                     *03480000
      *                                                                *03490000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*03500000
                                                                        
       1010-COMMIT-JOB-PARM.                                            
                                                                        
           MOVE SPACES                     TO WS-SYSIPT                 
           MOVE WS-PGRMNAME                TO WS-PROGRAM                
           MOVE WS-PARM                    TO WS-COMMAND                
           MOVE ZEROS                      TO WS-SEQUENCE               
                                                                        
           PERFORM 7600-START-FCSJC01      THRU 7600-EXIT               
                                                                        
           PERFORM 7610-READ-FCSJC01       THRU 7610-EXIT               
              UNTIL (WS-INPUT-DATA-BREAKDOWN(1:6) = 'COMMIT')           
                 OR  END-OF-SYSIPT                                      
                                                                        
           MOVE G6-PARM-DATA               TO WS-COMMIT-DATA            
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSAC175   PROCESSING INFO   **'          
                 DISPLAY '**  COMMIT PARM NOT PRESENT      **'          
                 DISPLAY '**  DEFAULT CHKP LUW 50 IS USED  **'          
                 DISPLAY ' '                                            
                 MOVE WS-DEFAULT-CHKP-LUW-LIMIT                         
                                           TO WS-CHKP-LUW-LIMIT         
              WHEN WS-COMMIT-NUM NOT NUMERIC                            
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSAC175   PROCESSING ERROR **'           
                 DISPLAY '**  COMMIT PARM NOT NUMERIC     **'           
                 DISPLAY '**  KEY =  ' WS-INPUT-KEY                     
                 DISPLAY '**  PROCESSING TERMINATED       **'           
                 DISPLAY ' '                                            
                 PERFORM 7611-CLOSE        THRU 7611-EXIT               
                 PERFORM 9900-ABEND        THRU 9900-EXIT               
              WHEN WS-COMMIT-NUM  NUMERIC                               
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSAC175   PROCESSING INFO  **'           
                 MOVE WS-COMMIT-NUM        TO  WS-CHKP-LUW-LIMIT        
                 DISPLAY '**    CHKP LUW IS  ' WS-CHKP-LUW-LIMIT        
                 DISPLAY ' '                                            
                 PERFORM 7611-CLOSE        THRU 7611-EXIT               
           END-EVALUATE                                                 
           .                                                            
       1010-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*03961003
C29529*                                                                *03962003
C29529*    1100-LOAD-DELINQ-INFO                                       *03963003
C29529*         LOADS THE INTERNAL TABLE WS-EML-DATA BASED ON          *03964003
C29529*         INFO FROM CSS_DELINQUENCY                              *03964103
C29529*                                                                *03965003
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*03966003
C29529 1100-LOAD-DELINQ-INFO.                                           
                                                                        
C29529     PERFORM 7500-OPEN-DELINQ-CURSOR                              
C29529        THRU 7500-EXIT.                                           
                                                                        
C29529     MOVE 1      TO WS-COUNT.                                     
                                                                        
C29529     PERFORM 7525-FETCH-DELINQ-CURSOR                             
C29529        THRU 7525-EXIT.                                           
                                                                        
C29529     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
C29529        MOVE SPACES TO WS-EML-DATA(WS-COUNT)                      
C29529        PERFORM UNTIL SQLCODE NOT EQUAL SUCCESSFUL-CALL           
C29529                   OR WS-COUNT > WS-EML-MAX-ENTRY                 
C29529            PERFORM 1125-LOAD-WS-EML-DATA                         
C29529               THRU 1125-EXIT                                     
C29529            PERFORM 7525-FETCH-DELINQ-CURSOR                      
C29529               THRU 7525-EXIT                                     
C29529            IF SQLCODE = SUCCESSFUL-CALL                          
C31785               IF WS-CHECK-COUNT-NO                               
C31785                  CONTINUE                                        
C31785               ELSE                                               
C29529                 IF C8-COMPANY-NO NOT EQUAL                       
C29529                    WS-EML-COMPANY-NO(WS-COUNT)                   
C29529                 OR C8-DELINQ-CD(4:5) NOT EQUAL                   
C29529                    WS-EML-EVENT-CD(WS-COUNT)                     
C29529                    ADD 1 TO WS-COUNT                             
C29529                    IF WS-COUNT <= WS-EML-MAX-ENTRY               
C29529                       MOVE SPACES TO WS-EML-DATA(WS-COUNT)       
C29529                    END-IF                                        
C29529                 END-IF                                           
C31785               END-IF                                             
C29529            ELSE                                                  
C29529               ADD 1 TO WS-COUNT                                  
C29529            END-IF                                                
C29529        END-PERFORM                                               
C29529     END-IF.                                                      
                                                                        
C29529     PERFORM 7550-CLOSE-DELINQ-CURSOR                             
C29529        THRU 7550-EXIT.                                           
                                                                        
C29529     IF WS-COUNT <= WS-EML-MAX-ENTRY                              
C29529        MOVE SPACES         TO WS-EML-DATA(WS-COUNT)              
C29529        MOVE '99'           TO WS-EML-COMPANY-NO(WS-COUNT)        
C29529        MOVE WS-EML-END-REC TO WS-EML-EVENT-CD(WS-COUNT)          
C29529     END-IF.                                                      
                                                                        
C29529     IF WS-COUNT >= WS-EML-MAX-ENTRY                              
C29529        MOVE 0 TO WS-EML-COUNT-DIFF                               
C29529        SET WS-NOTIFY-PROD-SUPP TO TRUE                           
C29529     ELSE                                                         
C29529        COMPUTE WS-EML-COUNT-DIFF = WS-EML-MAX-ENTRY - WS-COUNT   
C29529        IF WS-EML-COUNT-DIFF <= 100                               
C29529           SET WS-NOTIFY-PROD-SUPP TO TRUE                        
C29529        END-IF                                                    
C29529     END-IF.                                                      
                                                                        
C29529 1100-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*03975305
C29529*                                                                *03975405
C29529*    1125-LOAD-WS-EML-DATA                                       *03975505
C29529*         POPULATES THE INTERNAL TABLE WS-EML-DATA               *03975605
C29529*                                                                *03975705
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*03975805
C29529 1125-LOAD-WS-EML-DATA.                                           
                                                                        
C31785     SET WS-CHECK-COUNT-YES TO TRUE.                              
                                                                        
C31785     IF C8-DELINQ-CD = 'NO-ECS-MASK-AFTER'                        
C31785        IF C8-COMPANY-NO = '26'                                   
C31785           MOVE C8-DELINQ-VALUE TO WS-MASK-COMPANY-26             
C31785        ELSE                                                      
C31785           MOVE C8-DELINQ-VALUE TO WS-MASK-COMPANY-01             
C31785        END-IF                                                    
C31785        SET WS-CHECK-COUNT-NO   TO TRUE                           
C31785        GO TO 1125-EXIT                                           
C31785     END-IF                                                       
                                                                        
PRJ228     IF C8-DELINQ-CD = 'NO-ECS-BANK-MASK'                         
PRJ228        IF C8-COMPANY-NO = '26'                                   
PRJ228           MOVE C8-DELINQ-VALUE TO WS-MASK-BANK-ACCT-26           
PRJ228        ELSE                                                      
PRJ228           MOVE C8-DELINQ-VALUE TO WS-MASK-BANK-ACCT-01           
PRJ228        END-IF                                                    
PRJ228        SET WS-CHECK-COUNT-NO   TO TRUE                           
PRJ228        GO TO 1125-EXIT                                           
PRJ228     END-IF                                                       
                                                                        
PRJ228     IF C8-DELINQ-CD = 'AMT-SECONDDNPL'                           
PRJ228        IF C8-COMPANY-NO = '26'                                   
PRJ228           MOVE C8-DELINQ-VALUE      TO WS-AMT-SECONDDNPL-26      
PRJ228           MOVE WS-AMT-SECONDDNPL-26 TO WS-SECONDDNPL-26          
PRJ228        ELSE                                                      
PRJ228           MOVE C8-DELINQ-VALUE      TO WS-AMT-SECONDDNPL-01      
PRJ228           MOVE WS-AMT-SECONDDNPL-01 TO WS-SECONDDNPL-01          
PRJ228        END-IF                                                    
PRJ228        SET WS-CHECK-COUNT-NO   TO TRUE                           
PRJ228        GO TO 1125-EXIT                                           
PRJ228     END-IF                                                       
                                                                        
PRJ228     IF C8-DELINQ-CD = 'AMT-RTCDNPLIM'                            
PRJ228        IF C8-COMPANY-NO = '26'                                   
PRJ228           MOVE C8-DELINQ-VALUE     TO WS-AMT-RTCDNPLIM-26        
PRJ228           MOVE WS-AMT-RTCDNPLIM-26 TO WS-RTCDNPLIM-26            
PRJ228        ELSE                                                      
PRJ228           MOVE C8-DELINQ-VALUE     TO WS-AMT-RTCDNPLIM-01        
PRJ228           MOVE WS-AMT-RTCDNPLIM-01 TO WS-RTCDNPLIM-01            
PRJ228        END-IF                                                    
PRJ228        SET WS-CHECK-COUNT-NO   TO TRUE                           
PRJ228        GO TO 1125-EXIT                                           
PRJ228     END-IF                                                       
                                                                        
PRJ228     IF C8-DELINQ-CD = 'AMT-DEPDNPLIM'                            
PRJ228        IF C8-COMPANY-NO = '26'                                   
PRJ228           MOVE C8-DELINQ-VALUE     TO WS-AMT-DEPDNPLIM-26        
PRJ228           MOVE WS-AMT-DEPDNPLIM-26 TO WS-DEPDNPLIM-26            
PRJ228        ELSE                                                      
PRJ228           MOVE C8-DELINQ-VALUE     TO WS-AMT-DEPDNPLIM-01        
PRJ228           MOVE WS-AMT-DEPDNPLIM-01 TO WS-DEPDNPLIM-01            
PRJ228        END-IF                                                    
PRJ228        SET WS-CHECK-COUNT-NO   TO TRUE                           
PRJ228        GO TO 1125-EXIT                                           
PRJ228     END-IF                                                       
                                                                        
C29529     IF WS-EML-COMPANY-NO(WS-COUNT) EQUAL SPACES                  
C29529        OR WS-EML-EVENT-CD(WS-COUNT) EQUAL SPACES                 
C29529           MOVE C8-COMPANY-NO     TO WS-EML-COMPANY-NO(WS-COUNT)  
C29529           MOVE C8-DELINQ-CD(4:5) TO WS-EML-EVENT-CD(WS-COUNT)    
C29529     END-IF.                                                      
                                                                        
C29529     MOVE C8-DELINQ-CD(10:10) TO WS-ADD-FIELD.                    
                                                                        
C29529     EVALUATE TRUE                                                
C29529         WHEN WS-ADD-DRAFT-DT                                     
C29529              MOVE WS-Y TO WS-EML-DRFT-DT-FL(WS-COUNT)            
PRJ228         WHEN WS-ADD-DRAFT-AMT                                    
PRJ228              MOVE WS-Y TO WS-EML-DRFT-AMT-FL(WS-COUNT)           
PRJ228         WHEN WS-ADD-CHRGE-DT                                     
PRJ228              MOVE WS-Y TO WS-EML-CHRGE-DT-FL(WS-COUNT)           
PRJ228         WHEN WS-ADD-CHRGE-AMT                                    
PRJ228              MOVE WS-Y TO WS-EML-CHRGE-AMT-FL(WS-COUNT)          
PRJ228         WHEN WS-ADD-BILLD-DT                                     
PRJ228              MOVE WS-Y TO WS-EML-BILLD-DT-FL(WS-COUNT)           
PRJ228         WHEN WS-ADD-BILLD-AMT                                    
PRJ228              MOVE WS-Y TO WS-EML-BILLD-AMT-FL(WS-COUNT)          
PRJ228         WHEN WS-ADD-BANK-ACCT                                    
PRJ228              MOVE WS-Y TO WS-EML-BANK-ACCT-FL(WS-COUNT)          
C29529         WHEN WS-ADD-PREM-ADDR                                    
C29529              MOVE WS-Y TO WS-EML-SRV-ADR-FL(WS-COUNT)            
C29529     END-EVALUATE.                                                
                                                                        
C29529 1125-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*03979003
      *                                                                *03980000
      *    2000-PROCESS-CURSOR.                                        *03990000
      *         PROCESS FROM TABLES                                    *04000000
      *                                                                *04010000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*04020000
                                                                        
       2000-PROCESS-CURSOR.                                             
                                                                        
           PERFORM 7100-OPEN-CURSOR        THRU 7100-EXIT               
                                                                        
           SET WS-RESTART-REC-NOT-FOUND    TO TRUE                      
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM UNTIL WS-RESTART-REC-FOUND OR                     
                 WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                                                                        
                 PERFORM 7200-FETCH-CURSOR THRU 7200-EXIT               
                                                                        
                 IF AT-ACCOUNT-NO  EQUAL  WS-RESTART-ACCOUNT            
                    AND AT-CUSTOMER-NO EQUAL  WS-RESTART-CUSTOMER       
                    AND BI-DATE-BILLED EQUAL  WS-RESTART-EVENT-DATE     
                    SET WS-RESTART-REC-FOUND  TO TRUE                   
                 END-IF                                                 
              END-PERFORM                                               
                                                                        
              IF WS-RESTART-REC-NOT-FOUND                               
                 DISPLAY '***********************************'          
                 DISPLAY '**  PROCESSING ERROR             **'          
                 DISPLAY '**  PARAGRAPH   = 2000-PROCESS-CURSOR'        
                 DISPLAY '**  RESTART KEY NOT FOUND'                    
                 DISPLAY '**  ACCOUNT NO     = ' WS-RESTART-ACCOUNT     
                 DISPLAY '**  CUSTOMER NO    = ' WS-RESTART-CUSTOMER    
                 DISPLAY '**  DATE  BILLED   = ' WS-RESTART-EVENT-DATE  
                 DISPLAY '**  PROCESSING TERMINATED        **'          
                 DISPLAY '***********************************'          
                 PERFORM 9900-ABEND        THRU 9900-EXIT               
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 7200-FETCH-CURSOR       THRU 7200-EXIT               
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              DISPLAY ' '                                               
              DISPLAY '*************************************'           
              DISPLAY '**       NO ACCOUNTS FOUND         **'           
              DISPLAY '*************************************'           
           ELSE                                                         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 PERFORM 2600-PROCESS-FIELDS         THRU 2600-EXIT     
                 PERFORM 7200-FETCH-CURSOR           THRU 7200-EXIT     
              END-PERFORM                                               
           END-IF                                                       
                                                                        
           PERFORM 7300-CLOSE-CURSOR       THRU 7300-EXIT               
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*04560000
      *                                                                *04570000
      *    2050-PROCESS-FILE.                                          *04580000
      *         PROCESS ACCOUNTS FROM THE FILE                         *04590000
      *                                                                *04600000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*04610000
                                                                        
       2050-PROCESS-FILE.                                               
                                                                        
           PERFORM 7000-READ-FCSAC175      THRU 7000-EXIT               
           IF WS-END-OF-FCSAC175                                        
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH   = 2050-PROCESS-FILE'             
              DISPLAY '**  INPUT FILE IS EMPTY          **'             
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
                                                                        
           SET WS-RESTART-REC-NOT-FOUND    TO TRUE                      
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM UNTIL WS-RESTART-REC-FOUND                        
                OR WS-END-OF-FCSAC175                                   
                                                                        
                IF E-FAC175-ACCOUNT-NO EQUAL WS-RESTART-ACCOUNT         
                   AND E-FAC175-CUSTOMER-NO EQUAL WS-RESTART-CUSTOMER   
                   AND E-FAC175-EMAIL-EVENT-CD EQUAL WS-RESTART-EVENT-CD
                    SET WS-RESTART-REC-FOUND  TO TRUE                   
                END-IF                                                  
                                                                        
                PERFORM 7000-READ-FCSAC175      THRU 7000-EXIT          
                                                                        
              END-PERFORM                                               
                                                                        
              IF WS-RESTART-REC-NOT-FOUND                               
                 DISPLAY '***********************************'          
                 DISPLAY '**  PROCESSING ERROR             **'          
                 DISPLAY '**  PARAGRAPH   = 2050-PROCESS-FILE'          
                 DISPLAY '**  RESTART KEY NOT FOUND'                    
                 DISPLAY '**  ACCOUNT NO     = ' WS-RESTART-ACCOUNT     
                 DISPLAY '**  CUSTOMER NO    = ' WS-RESTART-CUSTOMER    
                 DISPLAY '**  EVENT CODE     = ' WS-RESTART-EVENT-CD    
                 DISPLAY '**  PROCESSING TERMINATED        **'          
                 DISPLAY '***********************************'          
                 PERFORM 9900-ABEND        THRU 9900-EXIT               
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-FAC175-SUCCESSFUL                                      
              PERFORM UNTIL WS-END-OF-FCSAC175                          
                 PERFORM 2100-FORMAT-BATCH-EMAIL                        
                                           THRU 2100-EXIT               
                 PERFORM 7000-READ-FCSAC175                             
                                           THRU 7000-EXIT               
              END-PERFORM                                               
           END-IF                                                       
                                                                        
           .                                                            
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*05190000
      *                                                                *05200000
      *   2100-FORMAT-BATCH-EMAIL                                      *05210000
      *        FORMATS THE DATA TO BE INERTED INTO CSS_BATCH_EMAIL,    *05220000
      *        WRITE RESTART RECORD  AND COMMIT THE CHANGES.           *05230000
      *                                                                *05240000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*05250000
                                                                        
       2100-FORMAT-BATCH-EMAIL.                                         
                                                                        
           MOVE '2100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
C29533     SET WS-SEND-EMAIL               TO TRUE.                     
                                                                        
C28137*REWORKED SOME IF STATEMENTS TO ALLOW EASIER REVISION AND ALLOW   05301000
C28137*  SEPARATION OF COMMERCIAL/INDUSTRIAL ACCOUNTS                   05302000
                                                                        
           INITIALIZE DCLCSS-BATCH-EMAIL.                               
           IF READ-FILE                                                 
              MOVE E-FAC175-ACCOUNT-NO     TO  AE-ACCOUNT-NO            
              MOVE E-FAC175-CUSTOMER-NO    TO  AE-CUSTOMER-NO           
              MOVE E-FAC175-COMPANY-NO     TO  AE-COMPANY-NO            
              MOVE E-FAC175-EMAIL-EVENT-CD TO  AE-EMAIL-EVENT-CD        
              MOVE WS-INPUT-DATE           TO  AE-EMAIL-EVENT-DT        
           ELSE                                                         
              MOVE AT-ACCOUNT-NO           TO  AE-ACCOUNT-NO            
                                               BE-ACCOUNT-NO            
              MOVE AT-CUSTOMER-NO          TO  AE-CUSTOMER-NO           
              MOVE AT-COMPANY-NO           TO  AE-COMPANY-NO            
              MOVE WS-INPUT-DATE           TO  AE-EMAIL-EVENT-DT        
              MOVE SPACES                  TO  AE-EMAIL-EVENT-CD        
           END-IF.                                                      
                                                                        
C29533     IF BE-STATUS-CODE = 'C' AND BE-INIT-TYPE-CD = '00'           
C29533        MOVE AE-ACCOUNT-NO TO YP-ACCOUNT-NO                       
C29533        PERFORM 2500-CHECK-ATTRIBUTE  THRU 2500-EXIT              
C29533     END-IF.                                                      
                                                                        
C29533     IF WS-DO-NOT-SEND-EMAIL                                      
C29533        GO TO 2100-EXIT                                           
C29533     END-IF.                                                      
                                                                        
C29529     MOVE SPACES TO WS-CANX-REBILL-IND.                           
C29529     MOVE SPACES TO WS-BILLING-EML-IND.                           
C29529     IF BE-STATUS-CODE = 'C' AND BE-INIT-TYPE-CD = '00'           
C29529        PERFORM 2400-CHECK-CANX-REBILL                            
C29529           THRU 2400-EXIT                                         
C29529     END-IF.                                                      
                                                                        
C28137     MOVE AT-ACCOUNT-TYPE-CODE TO WS-ACCOUNT-TYPE.                
C29529     IF WS-CANX-REBILL-YES                                        
C29529        PERFORM 2425-PROCESS-CANX-REBILL                          
C29529           THRU 2425-EXIT                                         
C29529     ELSE                                                         
C28137       IF IS-COMM-OR-IND                                          
C28137          PERFORM 2150-PROCESS-COMM-IND THRU 2150-EXIT            
C28137       ELSE                                                       
C28137          PERFORM 2125-PROCESS-RESIDENTIAL THRU 2125-EXIT         
C28137       END-IF                                                     
C29529     END-IF.                                                      
C28137* DUE TO IND/COM LOGIC IN 2150 PARA. AN EVENT MAY NOT BE POSTED   05810000
C28137* SO CHECK FOR BLANK AND DON'T UPDATE IF TRUE.                    05811000
           IF AE-EMAIL-EVENT-CD = SPACES                                
            CONTINUE                                                    
           ELSE                                                         
ACT070      PERFORM 7850-SET-NEXT-VALUE     THRU 7850-EXIT              
            PERFORM 8100-INSERT-BATCH-EMAIL THRU 8100-EXIT              
C29529      PERFORM 2300-INS-BTCH-EMAIL-DET THRU 2300-EXIT              
            ADD +1                          TO WS-LUW-PROCESSED         
                                              WS-RECORDS-PROCESSED      
           END-IF.                                                      
           IF WS-LUW-PROCESSED = WS-CHKP-LUW-LIMIT                      
              MOVE AE-ACCOUNT-NO           TO WS-RESTART-ACCOUNT        
              MOVE AE-CUSTOMER-NO          TO WS-RESTART-CUSTOMER       
              MOVE AE-EMAIL-EVENT-CD       TO WS-RESTART-EVENT-CD       
                                                                        
              IF READ-FILE                                              
                 MOVE AE-EMAIL-EVENT-DT    TO WS-RESTART-EVENT-DATE     
              ELSE                                                      
                 MOVE BI-DATE-BILLED       TO WS-RESTART-EVENT-DATE     
              END-IF                                                    
                                                                        
              MOVE WS-RESTART-DATA         TO RF-RESTART-DATA-TEXT      
              MOVE +32                     TO RF-RESTART-DATA-LEN       
                                                                        
              MOVE WS-PGRMNAME             TO RF-NAME-PROGRAM           
              MOVE 1                       TO RF-DUP-CNTRL-NO           
              MOVE 1                       TO RF-PARTITION-NO           
              PERFORM 8920-WRITE-RESTART-RECORD                         
                                           THRU 8920-EXIT               
                                                                        
              PERFORM 8898-ISSUE-CHKP      THRU 8898-EXIT               
                                                                        
              SET  WS-THIS-IS-A-RESTART    TO TRUE                      
              ADD +1                       TO WS-COMMIT-NUMBER          
              MOVE ZERO                    TO WS-LUW-PROCESSED          
                                                                        
              MOVE WS-RESTART-ACCOUNT      TO WS-ACCOUNT-NUMBER         
              MOVE WS-ACCOUNT-NUMBER       TO WS-DISPLAY-ACCOUNT        
              MOVE WS-RESTART-CUSTOMER     TO WS-DISPLAY-CUSTOMER       
              MOVE WS-RESTART-EVENT-DATE   TO WS-DISPLAY-DATE           
              MOVE WS-RESTART-EVENT-CD     TO WS-DISPLAY-CODE           
                                                                        
              DISPLAY '   '                                             
              DISPLAY 'TOTAL RECORDS PROCESSED = ' WS-RECORDS-PROCESSED 
              DISPLAY '** COMMIT NUMBER ' WS-COMMIT-NUMBER ' TAKEN'     
                      ' FOR KEY ' WS-DISPLAY-KEY                        
           END-IF.                                                      
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************             06276400
      * 2125-PROCESS-RESIDENTIAL                          *             06276500
      *****************************************************             06276600
       2125-PROCESS-RESIDENTIAL.                                        
           IF BE-STATUS-CODE = WS-A                                     
C25964        IF BE-INIT-TYPE-CD = WS-02                                
C29529            MOVE SPACES TO AE-EMAIL-EVENT-CD                      
C25964        ELSE                                                      
C25964            IF BE-INIT-TYPE-CD = WS-01                            
                     MOVE WS-ECS05 TO AE-EMAIL-EVENT-CD                 
C25964            END-IF                                                
C25964        END-IF                                                    
PRJ228        GO TO 2125-EXIT                                           
           ELSE                                                         
             IF BI-DATE-BILLED NOT EQUAL WS-INPUT-DATE                  
                OR BE-STATUS-CODE NOT EQUAL WS-C                        
C29529             MOVE SPACES TO AE-EMAIL-EVENT-CD                     
PRJ228             GO TO 2125-EXIT                                      
PRJ228       END-IF                                                     
           END-IF.                                                      
                                                                        
           PERFORM 7400-BANKDRAFT-DETAIL THRU 7400-EXIT                 
                                                                        
           IF BE-STATUS-CODE = WS-A                                     
C25964       IF BE-INIT-TYPE-CD = 02                                    
C25964          IF AT-NO-BILL-COPIES > 0                                
C25964             MOVE WS-ECS11 TO  AE-EMAIL-EVENT-CD                  
C25964          ELSE                                                    
C25964             MOVE WS-ECS12 TO  AE-EMAIL-EVENT-CD                  
C25964          END-IF                                                  
C25964       ELSE                                                       
C25964          IF BE-INIT-TYPE-CD = 01                                 
T26365             IF AT-NO-BILL-COPIES > 0                             
T26365                MOVE WS-ECS03  TO  AE-EMAIL-EVENT-CD              
T26365             ELSE                                                 
T26365                MOVE WS-ECS07  TO  AE-EMAIL-EVENT-CD              
T26365             END-IF                                               
C25964          END-IF                                                  
C25964       END-IF                                                     
           ELSE                                                         
PRJ526       IF WS-AUTOCARD-FLAG = 'Y'                                  
PRJ526          IF AT-NO-BILL-COPIES > 0                                
PRJ526             MOVE WS-ECS28 TO AE-EMAIL-EVENT-CD                   
PRJ526          ELSE                                                    
PRJ526             MOVE WS-ECS27 TO AE-EMAIL-EVENT-CD                   
PRJ526          END-IF                                                  
             ELSE                                                       
                IF BE-STATUS-CODE = WS-M                                
T26365             IF AT-NO-BILL-COPIES > 0                             
T26365                MOVE WS-ECS04 TO  AE-EMAIL-EVENT-CD               
T26365             ELSE                                                 
T26365                MOVE WS-ECS08 TO  AE-EMAIL-EVENT-CD               
T26365             END-IF                                               
                ELSE                                                    
C30552             PERFORM 2200-CASH-ONLY-ACCT THRU 2200-EXIT           
C30552             IF CZ-CASH-ONLY-FL = 'Y'                             
C30552                MOVE WS-ECS17 TO  AE-EMAIL-EVENT-CD               
C30552             ELSE                                                 
                      MOVE WS-ECS02 TO  AE-EMAIL-EVENT-CD               
C30552             END-IF                                               
                END-IF                                                  
             END-IF                                                     
           END-IF.                                                      
                                                                        
       2125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************             06276400
      * 2150-PROCESS-COMM-IND                             *             06276500
      *****************************************************             06276600
       2150-PROCESS-COMM-IND.                                           
           IF BI-DATE-BILLED = WS-INPUT-DATE                            
              AND BE-STATUS-CODE = WS-C                                 
                  MOVE WS-ECS14 TO  AE-EMAIL-EVENT-CD                   
            ELSE                                                        
              IF BE-STATUS-CODE = WS-A                                  
               AND BE-INIT-TYPE-CD = WS-01                              
                  MOVE WS-ECS15    TO  AE-EMAIL-EVENT-CD                
              END-IF                                                    
           END-IF.                                                      
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
C30552*****************************************************             06281700
C30552* 2200-CASH-ONLY-ACCT                               *             06281800
C30552*      RETRIEVES CASH ONLY FLAG SO THAT PROPER      *             06281900
C30552*      ECS EVENT IS LOADED INTO CSS_BATCH_EMAIL     *             06282000
C30552*****************************************************             06282100
C30552 2200-CASH-ONLY-ACCT.                                             
C30552                                                                  
C30552     EXEC SQL                                                     
C30552         SELECT CASH_ONLY_FL                                      
C30552           INTO :CZ-CASH-ONLY-FL                                  
C30552           FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                  
C30552          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
T35434                                                           
C30552     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06282400
MFA-TR*        SELECT CASH_ONLY_FL                                      06282500
MFA-TR*          INTO :CZ-CASH-ONLY-FL                                  06282600
MFA-TR*          FROM CSS_CREDIT_PROFILE                                06282700
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       06282800
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC                                                     06282900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30552                                                                  
C30552     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
C30552                                                                  
C30552     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30552        CONTINUE                                                  
C30552     ELSE                                                         
C30552        DISPLAY '********************************************'    
C30552        DISPLAY '**  PROCESSING ERROR'                            
C30552        DISPLAY '**  PARAGRAPH   = 2200-CASH-ONLY-ACCT'           
C30552        DISPLAY '**  DESCRIPTION = SELECT FROM CREDIT PROFILE'    
ERRINF        DISPLAY '**  ACCOUNT_NO  = ' AT-ACCOUNT-NO                
C30552        DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C30552        DISPLAY '**  PROCESSING TERMINATED'                       
C30552        DISPLAY '********************************************'    
C30552        PERFORM 9900-ABEND           THRU 9900-EXIT               
C30552     END-IF                                                       
C30552     .                                                            
C30552 2200-EXIT.                                                       
C30552      EXIT.                                                       
                                                                        
C29529*****************************************************             06284911
C29529* 2300-INS-BTCH-EMAIL-DET                           *             06285011
C29529*****************************************************             06285111
C29529 2300-INS-BTCH-EMAIL-DET.                                         
                                                                        
C29529     MOVE 0      TO WS-COUNT.                                     
C29529     MOVE 'N'    TO WS-EML-EVENT-EXIST.                           
C29529     PERFORM UNTIL WS-EML-EVENT-FOUND                             
C29529          OR WS-COUNT >= WS-EML-MAX-ENTRY                         
C29529             ADD 1 TO WS-COUNT                                    
C29529             PERFORM 2310-LOOKUP-EMAIL-EVENT                      
C29529                THRU 2310-EXIT                                    
C29529     END-PERFORM.                                                 
                                                                        
PRJ228     IF WS-COUNT = WS-EML-MAX-ENTRY                               
PRJ228        GO TO 2300-EXIT                                           
PRJ228     END-IF.                                                      
                                                                        
C29529     MOVE SPACES TO DCLCSS-BTCH-EMAIL-DET                         
                                                                        
C29529     IF WS-EML-SRV-ADR-FL(WS-COUNT) = WS-Y                        
C29529        OR WS-EML-DRFT-DT-FL(WS-COUNT) = WS-Y                     
C29529        OR WS-EML-DRFT-AMT-FL(WS-COUNT) = WS-Y                    
C29529        OR WS-EML-CHRGE-DT-FL(WS-COUNT) = WS-Y                    
C29529        OR WS-EML-CHRGE-AMT-FL(WS-COUNT) = WS-Y                   
C29529        OR WS-EML-BILLD-DT-FL(WS-COUNT) = WS-Y                    
C29529        OR WS-EML-BILLD-AMT-FL(WS-COUNT) = WS-Y                   
C29529        OR WS-EML-BANK-ACCT-FL(WS-COUNT) = WS-Y                   
C29529        PERFORM 2320-LOOKUP-BATCH-EMAIL-ID                        
C29529           THRU 2320-EXIT                                         
C29529        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
C29529           GO TO 2300-EXIT                                        
C29529        END-IF                                                    
C29529     END-IF.                                                      
                                                                        
C29529     MOVE AE-BATCH-EMAIL-ID  TO JK-BATCH-EMAIL-ID                 
                                                                        
C29529     IF WS-EML-DRFT-DT-FL(WS-COUNT) = WS-Y                        
PRJ228        OR WS-EML-CHRGE-DT-FL(WS-COUNT) = WS-Y                    
PRJ228        OR WS-EML-BILLD-DT-FL(WS-COUNT) = WS-Y                    
PRJ228        MOVE WS-SEE-BILL        TO JK-FIELD-VALUE-TX-TEXT         
PRJ228        MOVE LENGTH OF WS-SEE-BILL TO JK-FIELD-VALUE-TX-LEN       
                                                                        
PRJ228        IF WS-EDRAFT-IND = 'A'                                    
PRJ228           AND WS-EML-DRFT-DT-FL(WS-COUNT) = WS-Y                 
PRJ228           SET WS-ADD-DRAFT-DT  TO TRUE                           
PRJ228        ELSE                                                      
PRJ228           IF WS-AUTOCARD-FLAG = WS-Y                             
PRJ228              AND WS-EML-CHRGE-DT-FL(WS-COUNT) = WS-Y             
PRJ228              SET WS-ADD-CHRGE-DT TO TRUE                         
PRJ228           ELSE                                                   
PRJ228              SET WS-ADD-BILLD-DT TO TRUE                         
PRJ228           END-IF                                                 
PRJ228        END-IF                                                    
                                                                        
PRJ228        IF WS-DNP = 'N' AND (WS-DT-FLAG = 'Y' OR                  
                                   WS-AMOUNT-DUE <= WS-ZERO)            
                 IF WS-ANNIVERSARY = 'N' OR (WS-ANNIVERSARY = 'Y' AND   
                                           WS-DATE-DUE NOT EQUAL SPACES)
PRJ228              MOVE 10              TO JK-FIELD-VALUE-TX-LEN       
PRJ228              STRING WS-DATE-DUE(6:2) DELIMITED BY SIZE           
PRJ228                     '/'              DELIMITED BY SIZE           
PRJ228                     WS-DATE-DUE(9:2) DELIMITED BY SIZE           
PRJ228                     '/'              DELIMITED BY SIZE           
PRJ228                     WS-DATE-DUE(1:4) DELIMITED BY SIZE           
PRJ228              INTO JK-FIELD-VALUE-TX-TEXT                         
                 END-IF                                                 
PRJ228        END-IF                                                    
PRJ228        MOVE WS-ADD-FIELD       TO JK-FIELD-NAME-TX               
PRJ222        PERFORM 2350-INS-BTCH-EMAIL-DET THRU 2350-EXIT            
PRJ228     END-IF.                                                      
                                                                        
PRJ228     IF WS-EML-DRFT-AMT-FL(WS-COUNT) = WS-Y                       
PRJ228        OR WS-EML-CHRGE-AMT-FL(WS-COUNT) = WS-Y                   
PRJ228        OR WS-EML-BILLD-AMT-FL(WS-COUNT) = WS-Y                   
PRJ228        MOVE WS-SEE-BILL        TO JK-FIELD-VALUE-TX-TEXT         
PRJ228        MOVE LENGTH OF WS-SEE-BILL TO JK-FIELD-VALUE-TX-LEN       
                                                                        
PRJ228        IF WS-EDRAFT-IND = 'A'                                    
PRJ228           AND WS-EML-DRFT-AMT-FL(WS-COUNT) = WS-Y                
PRJ228           SET WS-ADD-DRAFT-AMT TO TRUE                           
PRJ228        ELSE                                                      
PRJ228           IF WS-AUTOCARD-FLAG = WS-Y                             
PRJ228              AND WS-EML-CHRGE-AMT-FL(WS-COUNT) = WS-Y            
PRJ228              SET WS-ADD-CHRGE-AMT TO TRUE                        
PRJ228           ELSE                                                   
PRJ228              SET WS-ADD-BILLD-AMT TO TRUE                        
PRJ228           END-IF                                                 
PRJ228        END-IF                                                    
                                                                        
PRJ228        IF (WS-ANNIVERSARY = 'N' OR WS-ADD-CHRGE-AMT OR           
PRJ228           WS-ADD-DRAFT-AMT) AND (WS-AMT-FLAG = 'Y' OR            
                                       WS-AMOUNT-DUE <= WS-ZERO)        
                 IF WS-ADD-BILLD-AMT OR                                 
                    (WS-ADD-CHRGE-AMT AND WS-DNP = 'N') OR              
PRJ228              (WS-ADD-DRAFT-AMT AND WS-DNP = 'N')                 
PRJ228              IF WS-AMOUNT-DUE NOT > WS-ZERO                      
PRJ228                 MOVE AT-TOTAL-AR-BALANCE  TO WS-AMOUNT-DUE       
PRJ228              END-IF                                              
                                                                        
PRJ228              MOVE WS-AMOUNT-DUE   TO JK-FIELD-VALUE-TX-TEXT      
PRJ228              MOVE LENGTH OF WS-AMOUNT-DUE                        
PRJ228                                   TO JK-FIELD-VALUE-TX-LEN       
PRJ228           END-IF                                                 
PRJ228        END-IF                                                    
PRJ228        MOVE WS-ADD-FIELD       TO JK-FIELD-NAME-TX               
PRJ228        PERFORM 2350-INS-BTCH-EMAIL-DET THRU 2350-EXIT            
PRJ228     END-IF.                                                      
                                                                        
PRJ228     IF WS-DISP-BANK-ACCT = WS-Y                                  
PRJ228        AND WS-EML-BANK-ACCT-FL(WS-COUNT) = WS-Y                  
PRJ228        SET WS-ADD-BANK-ACCT  TO TRUE                             
PRJ228        MOVE WS-ADD-FIELD    TO JK-FIELD-NAME-TX                  
PRJ228        MOVE JF-BANK-ACCT-NO TO JK-FIELD-VALUE-TX-TEXT            
PRJ228        MOVE LENGTH OF JK-FIELD-VALUE-TX-TEXT                     
PRJ228                             TO JK-FIELD-VALUE-TX-LEN             
PRJ228        PERFORM 2350-INS-BTCH-EMAIL-DET THRU 2350-EXIT            
PRJ228     END-IF.                                                      
                                                                        
C29529     IF WS-EML-SRV-ADR-FL(WS-COUNT) = WS-Y                        
C29529        SET WS-ADD-PREM-ADDR  TO TRUE                             
C29529        PERFORM 2340-LOOKUP-PREMISE-ADDR                          
C29529           THRU 2340-EXIT                                         
C29529        IF JK-FIELD-VALUE-TX-TEXT NOT EQUAL SPACES                
C29529           MOVE WS-ADD-FIELD  TO JK-FIELD-NAME-TX                 
C29529           PERFORM 2350-INS-BTCH-EMAIL-DET THRU 2350-EXIT         
C29529        END-IF                                                    
C29529     END-IF.                                                      
                                                                        
C29529 2300-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C29529*****************************************************             06290911
C29529* 2310-LOOKUP-EMAIL-EVENT                           *             06291011
C29529*****************************************************             06291111
C29529 2310-LOOKUP-EMAIL-EVENT.                                         
                                                                        
C29529     IF WS-EML-COMPANY-NO(WS-COUNT) = AE-COMPANY-NO               
C29529        AND WS-EML-EVENT-CD(WS-COUNT) = AE-EMAIL-EVENT-CD         
C29529        SET WS-EML-EVENT-FOUND TO TRUE                            
C29529        GO TO 2310-EXIT                                           
C29529     END-IF.                                                      
                                                                        
C29529     IF WS-EML-COMPANY-NO(WS-COUNT) = '99'                        
C29529        AND WS-EML-EVENT-CD(WS-COUNT) = WS-EML-END-REC            
PRJ228        MOVE WS-EML-MAX-ENTRY TO WS-COUNT                         
C29529        GO TO 2310-EXIT                                           
C29529     END-IF.                                                      
                                                                        
C29529 2310-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C29529*****************************************************             06292911
C29529* 2320-LOOKUP-BATCH-EMAIL-ID                        *             06293011
C29529*****************************************************             06293111
C29529 2320-LOOKUP-BATCH-EMAIL-ID.                                      
                                                                        
C29529     EXEC SQL                                                     
C29529       SELECT BATCH_EMAIL_ID                                      
C29529         INTO :AE-BATCH-EMAIL-ID                                  
C29529         FROM CSS_BATCH_EMAIL WITH(READUNCOMMITTED)                       
C29529        WHERE COMPANY_NO     = :AE-COMPANY-NO                     
C29529          AND ACCOUNT_NO     = :AE-ACCOUNT-NO                     
C29529          AND CUSTOMER_NO    = :AE-CUSTOMER-NO                    
C29529          AND EMAIL_EVENT_CD = :AE-EMAIL-EVENT-CD                 
C29529          AND EMAIL_EVENT_DT = IIF(TRY_CONVERT(DATE, 
                                                     :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )                 
T35434                                                           
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06293411
MFA-TR*      SELECT BATCH_EMAIL_ID                                      06293511
MFA-TR*        INTO :AE-BATCH-EMAIL-ID                                  06293611
MFA-TR*        FROM CSS_BATCH_EMAIL                                     06293711
MFA-TR*       WHERE COMPANY_NO     = :AE-COMPANY-NO                     06293811
MFA-TR*         AND ACCOUNT_NO     = :AE-ACCOUNT-NO                     06293911
MFA-TR*         AND CUSTOMER_NO    = :AE-CUSTOMER-NO                    06294011
MFA-TR*         AND EMAIL_EVENT_CD = :AE-EMAIL-EVENT-CD                 06294111
MFA-TR*         AND EMAIL_EVENT_DT = :AE-EMAIL-EVENT-DT                 06294211
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    06294311

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C29529     IF SQLCODE = SUCCESSFUL-CALL OR -811 OR NOT-FOUND            
C29529        CONTINUE                                                  
C29529     ELSE                                                         
C29529        DISPLAY '***********************************'             
C29529        DISPLAY '**  PROCESSING ERROR             **'             
C29529        DISPLAY '**  PARAGRAPH     = 2320-LOOKUP-BATCH-EMAIL-ID'  
C29529        DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
C29529        DISPLAY '**  COMPANY-NO    = ' AE-COMPANY-NO              
C29529        DISPLAY '**  ACCOUNT-NO    = ' AE-ACCOUNT-NO              
C29529        DISPLAY '**  CUSTOMER-NO   = ' AE-CUSTOMER-NO             
C29529        DISPLAY '**  EMAIL-EVENT-CD= ' AE-EMAIL-EVENT-CD          
C29529        DISPLAY '**  EMAIL-EVENT-DT= ' AE-EMAIL-EVENT-DT          
C29529        DISPLAY '**  PROCESSING TERMINATED        **'             
C29529        DISPLAY '***********************************'             
C29529        PERFORM 9900-ABEND         THRU 9900-EXIT                 
C29529     END-IF.                                                      
                                                                        
C29529 2320-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C29529*****************************************************             06296711
C29529* 2330-LOOKUP-DRAFT-AMT-DT.                         *             06296811
C29529*****************************************************             06296911
C29529 2330-LOOKUP-DRAFT-AMT-DT.                                        
                                                                        
C29529     MOVE SPACES         TO PB-DRAFT-DATE                         
PRJ228     MOVE 0              TO PB-DRAFT-AMT                          
PRJ228     MOVE SPACES         TO JF-BANK-ACCT-NO                       
C29529     MOVE AT-ACCOUNT-NO  TO PB-ACCOUNT-NO                         
C29529     MOVE AT-CUSTOMER-NO TO JF-CUSTOMER-NO                        
                                                                        
C29529     EXEC SQL                                                     
C29529       SELECT TOP(1) PB.DRAFT_DATE,
              PB.DRAFT_AMT,
              RIGHT(CIS.STRIP3(JF.BANK_ACCT_NO, 'B', ' '), :WS-BANK-MASK
           )     
C29529         INTO :PB-DRAFT-DATE :WS-EML-NULL-IND                     
PRJ228             ,:PB-DRAFT-AMT                                       
PRJ228             ,:JF-BANK-ACCT-NO                                    
C29529         FROM CSS_PNDNG_BNK_DRFT PB WITH(READUNCOMMITTED)                 
PRJ228             ,CSS_CUSTOMER_BANK JF WITH(READUNCOMMITTED)                  
C29529        WHERE PB.CUST_BANK_SEQ_NO = JF.CUST_BANK_SEQ_NO           
C29529          AND PB.ACCOUNT_NO = :PB-ACCOUNT-NO                      
C29529          AND JF.CUSTOMER_NO = :JF-CUSTOMER-NO                    
C29529          AND PB.CODE_SOURCE_ID IN ('I','S')                      
PRJ228        ORDER BY PB.DRAFT_DATE DESC                               
PRJ228                                              
T35434                                                           
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     06297511
MFA-TR*      SELECT PB.DRAFT_DATE                                       06297615
MFA-TR*            ,PB.DRAFT_AMT                                                
MFA-TR*            ,RIGHT(STRIP(JF.BANK_ACCT_NO, B), :WS-BANK-MASK)             
MFA-TR*        INTO :PB-DRAFT-DATE :WS-EML-NULL-IND                     06297713
MFA-TR*            ,:PB-DRAFT-AMT                                               
MFA-TR*            ,:JF-BANK-ACCT-NO                                            
MFA-TR*        FROM CSS_PNDNG_BNK_DRFT PB                               06297811
MFA-TR*            ,CSS_CUSTOMER_BANK JF                                        
MFA-TR*       WHERE PB.CUST_BANK_SEQ_NO = JF.CUST_BANK_SEQ_NO           06297911
MFA-TR*         AND PB.ACCOUNT_NO = :PB-ACCOUNT-NO                      06297911
MFA-TR*         AND JF.CUSTOMER_NO = :JF-CUSTOMER-NO                    06298111
MFA-TR*         AND PB.CODE_SOURCE_ID IN ('I','S')                      06298111
MFA-TR*       ORDER BY PB.DRAFT_DATE DESC                                       
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    06298311

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PRJ228        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
PRJ228           MOVE 'N'          TO WS-AMT-FLAG                       
PRJ228           MOVE 'N'          TO WS-DT-FLAG                        
PRJ228        ELSE                                                      
C29529           IF WS-EML-NULL-IND NOT EQUAL 0                         
C29529              MOVE NOT-FOUND TO SQLCODE                           
C29529              MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE             
C29529           END-IF                                                 
                                                                        
PRJ228           MOVE PB-DRAFT-DATE TO WS-DATE-DUE                      
PRJ228           MOVE PB-DRAFT-AMT  TO WS-AMOUNT-DUE                    
PRJ228        END-IF                                                    
C29529     ELSE                                                         
C29529        DISPLAY '***********************************'             
C29529        DISPLAY '**  PROCESSING ERROR             **'             
C29529        DISPLAY '**  PARAGRAPH     = 2330-LOOKUP-DRAFT-AMT-DT'    
C29529        DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
C29529        DISPLAY '**  ACCOUNT-NO    = ' PB-ACCOUNT-NO              
C29529        DISPLAY '**  PROCESSING TERMINATED        **'             
C29529        DISPLAY '***********************************'             
C29529        PERFORM 9900-ABEND         THRU 9900-EXIT                 
C29529     END-IF.                                                      
                                                                        
C29529 2330-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
PRJ526*****************************************************             06296711
PRJ526* 2335-LOOKUP-AC-DRAFT-AMT-DT                       *             06296811
PRJ526*****************************************************             06296911
PRJ526 2335-LOOKUP-AC-DRAFT-AMT-DT.                                     
PRJ526                                                                  
PRJ526     MOVE SPACES               TO PC-PAYMENT-DATE.                
PRJ228     MOVE 0                    TO PC-PAYMENT-AMT.                 
PRJ526     MOVE AT-ACCOUNT-NO TO PC-ACCOUNT-NO.                         
PRJ526     MOVE 0 TO WS-EML-NULL-IND.                                   
PRJ526                                                                  
PRJ526     EXEC SQL                                                     
PRJ526       SELECT TOP(1) PAYMENT_DATE,
              PAYMENT_AMT                                         
PRJ526         INTO :PC-PAYMENT-DATE :WS-EML-NULL-IND                   
PRJ228             ,:PC-PAYMENT-AMT                                     
PRJ526         FROM CSS_PNDNG_CARD_PMT WITH(READUNCOMMITTED)                    
PRJ526        WHERE ACCOUNT_NO      = :PC-ACCOUNT-NO                    
PRJ526          AND STATUS_CODE = 'A'                                   
PRJ228        ORDER BY PAYMENT_DATE DESC                                
PRJ228                                              
PRJ526                                                           
PRJ526     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06297511
MFA-TR*      SELECT PAYMENT_DATE                                        06297615
MFA-TR*            ,PAYMENT_AMT                                                 
MFA-TR*        INTO :PC-PAYMENT-DATE :WS-EML-NULL-IND                   06297713
MFA-TR*            ,:PC-PAYMENT-AMT                                             
MFA-TR*        FROM CSS_PNDNG_CARD_PMT                                  06297811
MFA-TR*       WHERE ACCOUNT_NO      = :PC-ACCOUNT-NO                    06297911
MFA-TR*         AND STATUS_CODE = 'A'                                   06298111
MFA-TR*       ORDER BY PAYMENT_DATE DESC                                        
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    06298311

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ526                                                                  
PRJ526     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PRJ526                                                                  
PRJ526     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ228        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
PRJ228           MOVE 'N'             TO WS-DT-FLAG                     
PRJ228           MOVE 'N'             TO WS-AMT-FLAG                    
PRJ228        ELSE                                                      
PRJ526           IF WS-EML-NULL-IND NOT EQUAL 0                         
PRJ526              MOVE NOT-FOUND    TO SQLCODE                        
PRJ526              MOVE NOT-FOUND    TO WS-ACTIVE-RETURN-CODE          
PRJ526              MOVE 'N' TO WS-AUTOCARD-FLAG                        
PRJ526           END-IF                                                 
                                                                        
PRJ228           MOVE PC-PAYMENT-DATE TO WS-DATE-DUE                    
PRJ228           MOVE PC-PAYMENT-AMT  TO WS-AMOUNT-DUE                  
PRJ228        END-IF                                                    
PRJ526     ELSE                                                         
PRJ526        DISPLAY '***********************************'             
PRJ526        DISPLAY '**  PROCESSING ERROR             **'             
PRJ526        DISPLAY '**  PARAGRAPH   = 2335-LOOKUP-AC-DRAFT-AMT-DT'   
PRJ526        DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
PRJ526        DISPLAY '**  ACCOUNT-NO  = ' PC-ACCOUNT-NO                
PRJ526        DISPLAY '**  PROCESSING TERMINATED        **'             
PRJ526        DISPLAY '***********************************'             
PRJ526        PERFORM 9900-ABEND         THRU 9900-EXIT                 
PRJ526     END-IF.                                                      
PRJ526                                                                  
PRJ526 2335-EXIT.                                                       
PRJ526     EXIT.                                                        
                                                                        
PRJ228*****************************************************             06296711
PRJ228* 2336-LOOKUP-AMT-DT                                *             06296811
PRJ228*****************************************************             06296911
PRJ228 2336-LOOKUP-AMT-DT.                                              
PRJ228                                                                  
PRJ228     MOVE SPACES TO CL-DATE-NOTICE-DUE.                           
PRJ228     MOVE 0      TO CL-AMT-NOTICE.                                
PRJ228     MOVE AT-ACCOUNT-NO TO CL-ACCOUNT-NO.                         
PRJ228                                                                  
PRJ228     EXEC SQL                                                     
PRJ228       SELECT AMT_NOTICE                                          
PRJ228             ,DATE_NOTICE_DUE                                     
PRJ228         INTO :CL-AMT-NOTICE                                      
PRJ228             ,:CL-DATE-NOTICE-DUE :WS-EML-NULL-IND                
PRJ228         FROM CSS_CRED_COLL CL WITH(READUNCOMMITTED)                      
PRJ228        WHERE CL.ACCOUNT_NO = :CL-ACCOUNT-NO                      
PRJ228          AND CL.CODE_NOTICE_TYPE = 'A'                           
PRJ228                                                           
PRJ228     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06297511
MFA-TR*      SELECT AMT_NOTICE                                          06297615
MFA-TR*            ,DATE_NOTICE_DUE                                             
MFA-TR*        INTO :CL-AMT-NOTICE                                      06297713
MFA-TR*            ,:CL-DATE-NOTICE-DUE :WS-EML-NULL-IND                        
MFA-TR*        FROM CSS_CRED_COLL CL                                    06297811
MFA-TR*       WHERE CL.ACCOUNT_NO = :CL-ACCOUNT-NO                      06297911
MFA-TR*         AND CL.CODE_NOTICE_TYPE = 'A'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    06298311

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ228                                                                  
PRJ228     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PRJ228                                                                  
PRJ228     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ228        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
PRJ228           MOVE 'N'             TO WS-AMT-FLAG                    
PRJ228           MOVE 'N'             TO WS-DT-FLAG                     
PRJ228        ELSE                                                      
PRJ526           IF WS-EML-NULL-IND NOT EQUAL 0                         
PRJ526              MOVE NOT-FOUND TO SQLCODE                           
PRJ526              MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE             
PRJ526              MOVE SPACE TO CL-DATE-NOTICE-DUE                    
PRJ526              MOVE 'N'   TO WS-DT-FLAG                            
PRJ526           END-IF                                                 
                                                                        
PRJ228           MOVE CL-AMT-NOTICE      TO WS-AMOUNT-DUE               
PRJ228           MOVE CL-DATE-NOTICE-DUE TO WS-DATE-DUE                 
PRJ228                                                                  
PRJ228        END-IF                                                    
PRJ228     ELSE                                                         
PRJ228        DISPLAY '***********************************'             
PRJ228        DISPLAY '**  PROCESSING ERROR             **'             
PRJ228        DISPLAY '**  PARAGRAPH   = 2336-LOOKUP-AMT-DT'            
PRJ228        DISPLAY '**  SELECT FROM CSS_CRED_COLL    **'             
PRJ228        DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
PRJ228        DISPLAY '**  ACCOUNT-NO  = ' CL-ACCOUNT-NO                
PRJ228        DISPLAY '**  PROCESSING TERMINATED        **'             
PRJ228        DISPLAY '***********************************'             
PRJ228        PERFORM 9900-ABEND         THRU 9900-EXIT                 
PRJ228     END-IF.                                                      
PRJ228                                                                  
PRJ228 2336-EXIT.                                                       
PRJ228     EXIT.                                                        
                                                                        
C29529*****************************************************             06301014
C29529* 2340-LOOKUP-PREMISE-ADDR                          *             06301114
C29529*****************************************************             06301214
C29529 2340-LOOKUP-PREMISE-ADDR.                                        
                                                                        
C29529     INITIALIZE DCLCSS-ACCOUNT.                                   
C29529     MOVE ZERO          TO AT-ADDRESS-ID.                         
C29529     MOVE AE-ACCOUNT-NO TO AT-ACCOUNT-NO.                         
C29529     MOVE SPACES TO WS-NAME-ONLY-SW.                              
C29529     PERFORM 4000-MAIL-NAME-ADDRESS                               
C29529        THRU 4000-EXIT.                                           
                                                                        
C29529     PERFORM 2345-FORMAT-ADDRESS                                  
C29529        THRU 2345-EXIT.                                           
                                                                        
C29529 2340-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C29529*****************************************************             06301014
C29529* 2345-FORMAT-ADDRESS                               *             06301114
C29529*****************************************************             06301214
C29529 2345-FORMAT-ADDRESS.                                             
                                                                        
C29529     MOVE 0      TO WS-EML-NULL-IND.                              
C29529     MOVE 0      TO WS-EML-PREM-ADDR-LEN.                         
C29529     MOVE 0      TO JK-FIELD-VALUE-TX-LEN.                        
C29529     MOVE SPACES TO WS-EML-PREM-ADDR.                             
C29529     MOVE SPACES TO JK-FIELD-VALUE-TX-TEXT.                       
C31785     IF AE-COMPANY-NO = '26'                                      
C31785        MOVE WS-MASK-COMPANY-26 TO WS-MASK                        
C31785     ELSE                                                         
C31785        MOVE WS-MASK-COMPANY-01 TO WS-MASK                        
C31785     END-IF.                                                      
                                                                        
C32791     SET WS-ADDRESS-NORMAL TO TRUE.                               
C31785     PERFORM 2347-FORMAT-SMALL-ADDRESS                            
C31785        THRU 2347-EXIT.                                           
                                                                        
C31785     IF WS-ADDRESS-SMALL                                          
C31785        GO TO 2345-EXIT                                           
C31785     END-IF.                                                      
                                                                        
C29529     EXEC SQL                                                     
C31785       SELECT LTRIM(RTRIM(CIS.SUBSTR3$(LTRIM(RTRIM(:WS-PR-STREET))
           , 1, :WS-MASK) + REPLICATE('*', DATALENGTH(LTRIM(RTRIM(
                                                          :WS-PR-STREET
           )))-:WS-MASK) + ', ' + :WS-PR-ADDR-CITY-STATE))                     
C31785          ,DATALENGTH(LTRIM(RTRIM(CIS.SUBSTR3$(LTRIM(RTRIM(
                                                          :WS-PR-STREET
           )), 1, :WS-MASK) + REPLICATE('*', DATALENGTH(LTRIM(RTRIM(
                                                          :WS-PR-STREET
           )))-:WS-MASK) + ', ' + :WS-PR-ADDR-CITY-STATE)))                    
C29529         INTO :WS-EML-PREM-ADDR :WS-EML-NULL-IND                  
C29529             ,:WS-EML-PREM-ADDR-LEN                               
C29529         FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                         
T35434                                                           
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     06297511
MFA-TR*      SELECT STRIP(SUBSTR(STRIP(:WS-PR-STREET),1,:WS-MASK) ||    06297615
MFA-TR*             REPEAT('*',LENGTH(STRIP(:WS-PR-STREET))-:WS-MASK) ||        
MFA-TR*             ', ' || :WS-PR-ADDR-CITY-STATE)                             
MFA-TR*         ,LENGTH(STRIP(SUBSTR(STRIP(:WS-PR-STREET),1,:WS-MASK) ||06297615
MFA-TR*             REPEAT('*',LENGTH(STRIP(:WS-PR-STREET))-:WS-MASK) ||        
MFA-TR*             ', ' || :WS-PR-ADDR-CITY-STATE))                            
MFA-TR*        INTO :WS-EML-PREM-ADDR :WS-EML-NULL-IND                  06297713
MFA-TR*            ,:WS-EML-PREM-ADDR-LEN                                       
MFA-TR*        FROM CSS_MODEL_SQL                                       06297811
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    06298311

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C29529     IF SQLCODE = SUCCESSFUL-CALL                                 
C29529        IF WS-EML-NULL-IND EQUAL 0                                
C29529           MOVE WS-EML-PREM-ADDR     TO JK-FIELD-VALUE-TX-TEXT    
C29529           MOVE WS-EML-PREM-ADDR-LEN TO JK-FIELD-VALUE-TX-LEN     
C29529        END-IF                                                    
C29529     ELSE                                                         
C29529        DISPLAY '***********************************'             
C29529        DISPLAY '**  PROCESSING ERROR             **'             
C29529        DISPLAY '**  PARAGRAPH     = 2345-FORMAT-ADDRESS'         
C29529        DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
C29529        DISPLAY '**  ACCOUNT-NO    = ' PB-ACCOUNT-NO              
C29529        DISPLAY '**  PR-STREET          = ' WS-PR-STREET          
C29529        DISPLAY '**  PR-ADDR-CITY-STATE = ' WS-PR-ADDR-CITY-STATE 
C29529        DISPLAY '**  PROCESSING TERMINATED        **'             
C29529        DISPLAY '***********************************'             
C29529        PERFORM 9900-ABEND         THRU 9900-EXIT                 
C29529     END-IF.                                                      
                                                                        
C29529 2345-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C31785*****************************************************             06301014
C31785* 2347-FORMAT-SMALL-ADDRESS                         *             06301114
C31785*****************************************************             06301214
C31785 2347-FORMAT-SMALL-ADDRESS.                                       
                                                                        
C31785     COMPUTE WS-MASK-START = WS-MASK + 1.                         
C31785     COMPUTE WS-MASK-DIFF = LENGTH OF WS-PR-STREET - WS-MASK-START
                                                                        
C31785     MOVE WS-PR-STREET(WS-MASK-START:WS-MASK-DIFF)                
C31785       TO WS-MASK-STREET.                                         
                                                                        
C31785     IF WS-MASK-STREET GREATER THAN SPACES                        
C31785        GO TO 2347-EXIT                                           
C31785     END-IF.                                                      
                                                                        
C31785     EXEC SQL                                                     
C31785       SELECT DATALENGTH(LTRIM(RTRIM(:WS-PR-STREET)))                     
C31785             ,DATALENGTH(LTRIM(RTRIM(:WS-PR-ADDR-CITY-STATE)))            
C31785             ,LTRIM(RTRIM(:WS-PR-ADDR-CITY-STATE))                       
C31785         INTO :WS-EML-PREM-ADDR-LEN                               
C31785             ,:WS-EML-CITY-STATE-LEN                              
C31785             ,:WS-EML-PREM-ADDR :WS-EML-NULL-IND                  
C31785         FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                         
T35434                                                           
C31785     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     06297511
MFA-TR*      SELECT LENGTH(STRIP(:WS-PR-STREET))                        06297615
MFA-TR*            ,LENGTH(STRIP(:WS-PR-ADDR-CITY-STATE))               06297615
MFA-TR*            ,STRIP(:WS-PR-ADDR-CITY-STATE)                               
MFA-TR*        INTO :WS-EML-PREM-ADDR-LEN                                       
MFA-TR*            ,:WS-EML-CITY-STATE-LEN                                      
MFA-TR*            ,:WS-EML-PREM-ADDR :WS-EML-NULL-IND                          
MFA-TR*        FROM CSS_MODEL_SQL                                       06297811
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    06298311

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C31785     IF SQLCODE = SUCCESSFUL-CALL                                 
C31785        CONTINUE                                                  
C31785     ELSE                                                         
C31785        DISPLAY '***********************************'             
C31785        DISPLAY '**  PROCESSING ERROR             **'             
C31785        DISPLAY '**  PARAGRAPH     = 2347-FORMAT-SMALL-ADDRESS'   
C31785        DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
C31785        DISPLAY '**  ACCOUNT-NO    = ' PB-ACCOUNT-NO              
C31785        DISPLAY '**  PR-STREET          = ' WS-PR-STREET          
C31785        DISPLAY '**  PR-ADDR-CITY-STATE = ' WS-PR-ADDR-CITY-STATE 
C31785        DISPLAY '**  PROCESSING TERMINATED        **'             
C31785        DISPLAY '***********************************'             
C31785        PERFORM 9900-ABEND         THRU 9900-EXIT                 
C31785     END-IF.                                                      
                                                                        
C31785     IF WS-EML-PREM-ADDR-LEN < 4                                  
C31785        SET WS-ADDRESS-SMALL TO TRUE                              
C29529        IF WS-EML-NULL-IND EQUAL 0                                
C31785           MOVE WS-EML-PREM-ADDR      TO JK-FIELD-VALUE-TX-TEXT   
C31785        ELSE                                                      
C31785           MOVE WS-PR-ADDR-CITY-STATE TO JK-FIELD-VALUE-TX-TEXT   
C31785        END-IF                                                    
C31785        MOVE WS-EML-CITY-STATE-LEN TO JK-FIELD-VALUE-TX-LEN       
C31785        GO TO 2347-EXIT                                           
C31785     END-IF.                                                      
                                                                        
C31785     COMPUTE WS-MASK ROUNDED = WS-EML-PREM-ADDR-LEN / 2.          
                                                                        
C31785 2347-EXIT.                                                       
C31785     EXIT.                                                        
                                                                        
C29529*****************************************************             06304514
C29529* 2350-INS-BTCH-EMAIL-DET                           *             06304614
C29529*****************************************************             06304714
C29529 2350-INS-BTCH-EMAIL-DET.                                         
                                                                        
C29529     EXEC SQL                                                     
C29529       INSERT INTO CSS_BTCH_EMAIL_DET                             
C29529              (BATCH_EMAIL_ID                                     
C29529              ,FIELD_NAME_TX                                      
C29529              ,FIELD_VALUE_TX)                                    
C29529       VALUES                                                     
C29529              (:JK-BATCH-EMAIL-ID                                 
C29529              ,:JK-FIELD-NAME-TX                                  
C29529              ,:JK-FIELD-VALUE-TX)                                
C29529     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C29529     IF SQLCODE = SUCCESSFUL-CALL OR -803                         
C29529        IF SQLCODE = -803                                         
C29529           MOVE SUCCESSFUL-CALL TO SQLCODE                        
C29529           MOVE SUCCESSFUL-CALL TO WS-ACTIVE-RETURN-CODE          
C29529        END-IF                                                    
C29529     ELSE                                                         
C29529        DISPLAY '***********************************'             
C29529        DISPLAY '**  PROCESSING ERROR             **'             
C29529        DISPLAY '**  PARAGRAPH     = 2350-INS-BTCH-EMAIL-DET'     
C29529        DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
C29529        DISPLAY '**  ACCOUNT-NO    = ' AE-ACCOUNT-NO              
C29529        DISPLAY '**  BATCH-EMAIL-ID= ' JK-BATCH-EMAIL-ID          
C29529        DISPLAY '**  FIELD-NAME-TX = ' JK-FIELD-NAME-TX           
C29529        DISPLAY '**  FIELD-VALUE-TX= ' JK-FIELD-VALUE-TX          
C29529        DISPLAY '**  PROCESSING TERMINATED        **'             
C29529        DISPLAY '***********************************'             
C29529        PERFORM 9900-ABEND         THRU 9900-EXIT                 
C29529     END-IF.                                                      
                                                                        
C29529 2350-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C29529*****************************************************                     
C29529* 2400-CHECK-CANX-REBILL                            *                     
C29529*      DETERMINES WHETHER AN ACCOUNT IS GOING       *                     
C29529*      THROUGH BILLING VIA CANX / REBILL.           *                     
C29529*****************************************************                     
C29529 2400-CHECK-CANX-REBILL.                                          
                                                                        
C29529     MOVE AT-ACCOUNT-NO TO BI-ACCOUNT-NO.                         
                                                                        
C29529     IF BI-DATE-BILLED EQUAL SPACES                               
C29529        GO TO 2400-EXIT                                           
C29529     END-IF.                                                      
                                                                        
C29529     EXEC SQL                                                     
C29529          SELECT DISTINCT 'Y'                                     
C29529            INTO :WS-CANX-REBILL-IND :WS-CR-NULL-IND              
C29529            FROM CSS_BILLING_HDR    BI WITH(READUNCOMMITTED)              
C29529                ,CSS_BILLING_DET    BG WITH(READUNCOMMITTED)              
C29529                ,CSS_BILL_ADJ_REASN BA WITH(READUNCOMMITTED)              
C29529           WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO           
C29529             AND BI.DATE_BILLED        = IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )          
C29529             AND BA.ADJ_REASON_DESC LIKE '%/C%'                   
C29529             AND BG.DATE_ORIG_BILL    IS NOT NULL                 
C29529             AND BG.REVENUE_MONTH     <> 0                        
C29529             AND BG.REV_MTH_ORIG_BILL <> 0                        
C29529             AND BG.ACCOUNT_NO         = BI.ACCOUNT_NO            
C29529             AND BG.BILL_NO            = BI.BILL_NO               
C29529             AND BA.ADJ_REASON_CD      = BG.ADJ_REASON_CD         
T35434                                                           
C29529     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DISTINCT 'Y'                                             
MFA-TR*           INTO :WS-CANX-REBILL-IND :WS-CR-NULL-IND                      
MFA-TR*           FROM CSS_BILLING_HDR    BI                                    
MFA-TR*               ,CSS_BILLING_DET    BG                                    
MFA-TR*               ,CSS_BILL_ADJ_REASN BA                                    
MFA-TR*          WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO                   
MFA-TR*            AND BI.DATE_BILLED        = :BI-DATE-BILLED                  
MFA-TR*            AND BA.ADJ_REASON_DESC LIKE '%/C%'                           
MFA-TR*            AND BG.DATE_ORIG_BILL    IS NOT NULL                         
MFA-TR*            AND BG.REVENUE_MONTH     <> 0                                
MFA-TR*            AND BG.REV_MTH_ORIG_BILL <> 0                                
MFA-TR*            AND BG.ACCOUNT_NO         = BI.ACCOUNT_NO                    
MFA-TR*            AND BG.BILL_NO            = BI.BILL_NO                       
MFA-TR*            AND BA.ADJ_REASON_CD      = BG.ADJ_REASON_CD                 
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C29529     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C29529        CONTINUE                                                  
C29529     ELSE                                                         
C29529        DISPLAY '***********************************'             
C29529        DISPLAY '**  PROCESSING ERROR             **'             
C29529        DISPLAY '**  PARAGRAPH    =  2400-CHECK-CANX-REBILL'      
C29529        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
C29529        DISPLAY '**  ACCOUNT-NO   = ' BI-ACCOUNT-NO               
C29529        DISPLAY '**  DATE-BILLED  = ' BI-DATE-BILLED              
C29529        DISPLAY '**  PROCESSING TERMINATED        **'             
C29529        DISPLAY '***********************************'             
C29529        PERFORM 9900-ABEND           THRU 9900-EXIT               
C29529     END-IF.                                                      
                                                                        
C29529 2400-EXIT.                                                       
C29529      EXIT.                                                       
                                                                        
C29529*****************************************************                     
C29529* 2425-PROCESS-CANX-REBILL                          *                     
C29529*      DETERMINES WHETHER AN ACCOUNT IS GOING       *                     
C29529*      THROUGH BILLING VIA CANX / REBILL.           *                     
C29529*****************************************************                     
C29529 2425-PROCESS-CANX-REBILL.                                        
                                                                        
C29529     EXEC SQL                                                     
C29529       SELECT DISTINCT 'Y'                                        
C29529         INTO :WS-BILLING-EML-IND :WS-BILL-EML-NULL-IND           
C29529         FROM CSS_BATCH_EMAIL WITH(READUNCOMMITTED)                       
C29529        WHERE COMPANY_NO     = :AE-COMPANY-NO                     
C29529          AND ACCOUNT_NO     = :AE-ACCOUNT-NO                     
C29529          AND CUSTOMER_NO    = :AE-CUSTOMER-NO                    
C29529          AND EMAIL_EVENT_DT = IIF(TRY_CONVERT(DATE, 
                                                     :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )                 
C29529          AND EMAIL_EVENT_CD IN ('ECS02','ECS03','ECS04',         
C29529                                 'ECS07','ECS08','ECS11',         
C29529                                 'ECS12','ECS14','ECS15',         
C29529                                 'ECS17','ECS21')                 
T35434                                                           
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06293411
MFA-TR*      SELECT DISTINCT 'Y'                                        06293511
MFA-TR*        INTO :WS-BILLING-EML-IND :WS-BILL-EML-NULL-IND           06293611
MFA-TR*        FROM CSS_BATCH_EMAIL                                     06293711
MFA-TR*       WHERE COMPANY_NO     = :AE-COMPANY-NO                     06293811
MFA-TR*         AND ACCOUNT_NO     = :AE-ACCOUNT-NO                     06293911
MFA-TR*         AND CUSTOMER_NO    = :AE-CUSTOMER-NO                    06294011
MFA-TR*         AND EMAIL_EVENT_DT = :AE-EMAIL-EVENT-DT                 06294211
MFA-TR*         AND EMAIL_EVENT_CD IN ('ECS02','ECS03','ECS04',         06294111
MFA-TR*                                'ECS07','ECS08','ECS11',         06294111
MFA-TR*                                'ECS12','ECS14','ECS15',         06294111
MFA-TR*                                'ECS17','ECS21')                 06294111
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    06294311

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C29529     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C29529        IF WS-BILLING-EML-YES                                     
C29529           MOVE SPACES   TO AE-EMAIL-EVENT-CD                     
C29529        ELSE                                                      
C29529           MOVE WS-ECS21 TO AE-EMAIL-EVENT-CD                     
C29529        END-IF                                                    
C29529     ELSE                                                         
C29529        DISPLAY '***********************************'             
C29529        DISPLAY '**  PROCESSING ERROR             **'             
C29529        DISPLAY '**  PARAGRAPH      =  2425-CHECK-CANX-REBILL'    
C29529        DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
C29529        DISPLAY '**  COMPANY-NO     = ' AE-COMPANY-NO             
C29529        DISPLAY '**  ACCOUNT-NO     = ' AE-ACCOUNT-NO             
C29529        DISPLAY '**  CUSTOMER-NO    = ' AE-CUSTOMER-NO            
C29529        DISPLAY '**  EMAIL-EVENT-DT = ' AE-EMAIL-EVENT-DT         
C29529        DISPLAY '**  PROCESSING TERMINATED        **'             
C29529        DISPLAY '***********************************'             
C29529        PERFORM 9900-ABEND           THRU 9900-EXIT               
C29529     END-IF.                                                      
                                                                        
C29529 2425-EXIT.                                                       
C29529      EXIT.                                                       
                                                                        
C29533*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29533* 2500-CHECK-ATTRIBUTE.                                         *         
C29533* VERIFY IF CUSTOMER HAS OPTED FOR PAPERONLY OR BILLNOTIFY      *         
C29533*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29533 2500-CHECK-ATTRIBUTE.                                            
C29533                                                                  
C29533     EXEC SQL                                                     
C29533         SELECT TOP(1) 'N'                                               
C29533           INTO :WS-EMAIL-IND                                     
C29533           FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)               
C29533          WHERE YP.ACCOUNT_NO             = :YP-ACCOUNT-NO        
C29533            AND ((YP.ATTRIBUTE_DESC       = 'EMAIL_PAPERONLY'     
C29533                AND YP.ATTRIBUTE_VALUE_CD = 'YES')                
C29533             OR  (YP.ATTRIBUTE_DESC       = 'EMAIL_BILLNOTIFY'    
C29533                AND YP.ATTRIBUTE_VALUE_CD = 'NO'))                
C29533                                              
T35434                                                           
C29533     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'N'                                                       
MFA-TR*          INTO :WS-EMAIL-IND                                             
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE YP                                     
MFA-TR*         WHERE YP.ACCOUNT_NO             = :YP-ACCOUNT-NO                
MFA-TR*           AND ((YP.ATTRIBUTE_DESC       = 'EMAIL_PAPERONLY'             
MFA-TR*               AND YP.ATTRIBUTE_VALUE_CD = 'YES')                        
MFA-TR*            OR  (YP.ATTRIBUTE_DESC       = 'EMAIL_BILLNOTIFY'            
MFA-TR*               AND YP.ATTRIBUTE_VALUE_CD = 'NO'))                        
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29533                                                                  
C29533     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
C29533                                                                  
C29533     IF WS-ACTIVE-RETURN-CODE    EQUAL NOT-FOUND                  
C29533        SET WS-SEND-EMAIL           TO TRUE                       
C29533     ELSE                                                         
C29533        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
C29533           SET WS-DO-NOT-SEND-EMAIL TO TRUE                       
C29533        ELSE                                                      
C29533           DISPLAY '***********************************'          
C29533           DISPLAY '**  PROCESSING ERROR             **'          
C29533           DISPLAY '**  PARAGRAPH      =   2500-CHECK-ATTRIBUTE'  
C29533           DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE  
C29533           DISPLAY '**  COMPANY-NO     = ' AE-COMPANY-NO          
C29533           DISPLAY '**  ACCOUNT-NO     = ' AE-ACCOUNT-NO          
C29533           DISPLAY '**  CUSTOMER-NO    = ' AE-CUSTOMER-NO         
C29533           DISPLAY '**  EMAIL-EVENT-DT = ' AE-EMAIL-EVENT-DT      
C29533           DISPLAY '**  PROCESSING TERMINATED        **'          
C29533           DISPLAY '***********************************'          
C29533           PERFORM 9900-ABEND           THRU 9900-EXIT            
C29533        END-IF                                                    
C29533     END-IF.                                                      
C29533                                                                  
C29533 2500-EXIT.                                                       
C29533      EXIT.                                                       
C29533                                                                  
PRJ228*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ228*                                                               *         
PRJ228* 2600-PROCESS-FIELDS.                                          *         
PRJ228* PROCESS BBP, EDRAFT, DNP, JUDGEMENT, SUBACCOUNT, BANKRUPTCY,  *         
PRJ228* AUTOCARD INDICATORS, ETC.                                     *         
PRJ228*                                                               *         
PRJ228*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
PRJ228 2600-PROCESS-FIELDS.                                             
PRJ228                                                                  
PRJ228     MOVE AT-CODES-DATA-PRESENT(14:1) TO WS-EDRAFT-IND            
PRJ228     MOVE AT-CODES-DATA-PRESENT(3:1)  TO WS-BBP-IND               
PRJ228     MOVE 'N'                         TO WS-ANNIVERSARY           
PRJ228     MOVE 'Y'                         TO WS-AMT-FLAG              
PRJ228     MOVE 'Y'                         TO WS-DT-FLAG               
PRJ228     MOVE ZERO                        TO WS-ZERO                  
                                                                        
PRJ228     IF AT-COMPANY-NO = '26'                                      
PRJ228        MOVE WS-MASK-BANK-ACCT-26 TO WS-BANK-MASK                 
PRJ228     ELSE                                                         
PRJ228        MOVE WS-MASK-BANK-ACCT-01 TO WS-BANK-MASK                 
PRJ228     END-IF                                                       
                                                                        
PRJ228     IF AT-BANKRUPTCY-IND = 'B' OR AT-JUDGEMENT-IND = 'J' OR      
PRJ228        AT-CREDIT-GROUP = 'S'                                     
PRJ228        CONTINUE                                                  
PRJ228     ELSE                                                         
PRJ228        PERFORM 7700-GET-CRED-COLL-DNP      THRU 7700-EXIT        
                                                                        
PRJ228        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
PRJ228           PERFORM 7750-GET-SO-DATA-DNP     THRU 7750-EXIT        
PRJ228        END-IF                                                    
                                                                        
PRJ228        IF WS-BBP-IND = 'A'                                       
PRJ228           PERFORM 7800-GET-ANNIVERSARY-DT  THRU 7800-EXIT        
                                                                        
PRJ228           MOVE AT-REV-MTH-LST-NRML TO WS-AT-REV-MTH-LST-NRML-NUM 
PRJ228           MOVE WS-AT-REV-MTH-LST-NRML-NUM                        
PRJ228                                  TO WS-AT-REV-MTH-LST-NRML-ALPHA 
                                                                        
PRJ228           IF BU-ANNIVERSARY-DATE(6:2)=                           
PRJ228                                WS-AT-REV-MTH-LST-NRML-ALPHA(5:2) 
PRJ228              MOVE 'Y'                TO WS-ANNIVERSARY           
PRJ228           END-IF                                                 
PRJ228        END-IF                                                    
                                                                        
PRJ228        IF WS-EDRAFT-IND = 'A'                                    
PRJ228           MOVE 'Y' TO WS-DISP-BANK-ACCT                          
PRJ228           PERFORM 2330-LOOKUP-DRAFT-AMT-DT THRU 2330-EXIT        
                                                                        
PRJ228           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
PRJ228              MOVE 'N' TO WS-DISP-BANK-ACCT                       
PRJ228              PERFORM 2336-LOOKUP-AMT-DT    THRU 2336-EXIT        
PRJ228           END-IF                                                 
PRJ228        ELSE                                                      
PRJ228           MOVE 'N' TO WS-DISP-BANK-ACCT                          
PRJ228           PERFORM 7425-SET-AUTOCARD-FLAG THRU 7425-EXIT          
                                                                        
PRJ228           IF WS-AUTOCARD-FLAG = 'Y'                              
PRJ228              PERFORM 2335-LOOKUP-AC-DRAFT-AMT-DT THRU 2335-EXIT  
                                                                        
PRJ228              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                
PRJ228                 PERFORM 2336-LOOKUP-AMT-DT       THRU 2336-EXIT  
                    END-IF                                              
PRJ228           ELSE                                                   
PRJ228              PERFORM 2336-LOOKUP-AMT-DT          THRU 2336-EXIT  
PRJ228           END-IF                                                 
              END-IF                                                    
                                                                        
PRJ228        IF CL-CODE-NOTICE-TYPE = 'I'                              
PRJ228           IF ((AT-COMPANY-NO ='26'                               
PRJ228               AND WS-CL-AMT-NOTICE <= WS-DEPDNPLIM-26) OR        
PRJ228              (AT-COMPANY-NO = '01'                               
PRJ228               AND WS-CL-AMT-NOTICE <= WS-DEPDNPLIM-01))          
PRJ228               MOVE 'N' TO WS-DNP                                 
PRJ228           END-IF                                                 
PRJ228        ELSE                                                      
PRJ228           IF CL-CODE-NOTICE-TYPE = 'H'                           
PRJ228              IF ((AT-COMPANY-NO = '26'                           
PRJ228                  AND WS-CL-AMT-NOTICE <= WS-RTCDNPLIM-26) OR     
PRJ228                 (AT-COMPANY-NO = '01'                            
PRJ228                  AND WS-CL-AMT-NOTICE <= WS-RTCDNPLIM-01))       
PRJ228                  MOVE 'N' TO WS-DNP                              
PRJ228              END-IF                                              
PRJ228           ELSE                                                   
PRJ228              IF (CL-CODE-NOTICE-TYPE = 'D' OR                    
PRJ228                  CL-CODE-NOTICE-TYPE = 'G')                      
PRJ228                 IF ((AT-COMPANY-NO = '26'                        
PRJ228                    AND WS-CL-AMT-NOTICE <= WS-SECONDDNPL-26) OR  
PRJ228                    (AT-COMPANY-NO = '01'                         
PRJ228                    AND WS-CL-AMT-NOTICE <= WS-SECONDDNPL-01))    
PRJ228                    MOVE 'N' TO WS-DNP                            
PRJ228                 END-IF                                           
PRJ228              END-IF                                              
PRJ228           END-IF                                                 
PRJ228        END-IF                                                    
                                                                        
              PERFORM 2100-FORMAT-BATCH-EMAIL           THRU 2100-EXIT  
PRJ228     END-IF.                                                      
PRJ228                                                                  
PRJ228 2600-EXIT.                                                       
PRJ228      EXIT.                                                       
PRJ228                                                                  
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CPD00004 (6010-REDUCE-EMBEDDED-SPACES)                        *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE CPD00004                                                 
C29529     END-EXEC.                                                            
                                                                        
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529* CPD00074 (4000-MAIL-NAME-ADDRESS)                             *         
C29529*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
C29529     EXEC SQL                                                             
C29529         INCLUDE CPD00074                                                 
C29529     END-EXEC.                                                            
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*06308214
      *                                                                *06308314
      *   7000-READ-FCSAC175.                                          *06309014
      *        READS THE INPUT FILE                                    *06310000
      *                                                                *06320000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*06330000
                                                                        
       7000-READ-FCSAC175.                                              
                                                                        
           MOVE '7000'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           READ FCSAC175-FILE                                           
             AT END                                                     
                SET WS-END-OF-FCSAC175     TO TRUE                      
                                                                        
           IF WS-FAC175-SUCCESSFUL OR WS-END-OF-FCSAC175                
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7000-READ-FCSAC175'          
              DISPLAY '**  FILE STATUS  = ' WS-FAC175-STATUS            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*06580000
      *                                                                *06590000
      *   7100-OPEN-CURSOR.                                            *06600000
      *        OPENS THE CURSOR TO FETCH ROWS                          *06610000
      *                                                                *06620000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*06630000
                                                                        
       7100-OPEN-CURSOR.                                                
                                                                        
           MOVE '7100'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           EXEC SQL                                                     
                OPEN ECUST                                              
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7100-OPEN-CURSOR '           
              DISPLAY '**  OPEN ECUST CURSOR '                          
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*06910000
      *                                                                *06920000
      *   7200-FETCH-CURSOR.                                           *06930000
      *        GETS ACCOUNT NO, CUSTOMER NO, COMPANY NO AND            *06940000
      *        DATE BILLED VALUES                                      *06950000
      *                                                                *06960000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*06970000
                                                                        
       7200-FETCH-CURSOR.                                               
                                                                        
           MOVE '7200'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           MOVE 0                          TO WS-NULL-INDICATOR         
                                                                        
           EXEC SQL                                                     
              FETCH ECUST INTO                                          
                    :AT-ACCOUNT-NO                                      
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-COMPANY-NO                                     
C28137              ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-NO-BILL-COPIES                                 
                    ,:BI-DATE-BILLED :WS-NULL-INDICATOR                 
                    ,:BE-STATUS-CODE                                    
C25964              ,:BE-INIT-TYPE-CD                                   
PRJ228              ,:AT-BANKRUPTCY-IND                                 
PRJ228              ,:AT-JUDGEMENT-IND                                  
PRJ228              ,:AT-CREDIT-GROUP                                   
PRJ228              ,:AT-CODES-DATA-PRESENT                             
PRJ228              ,:AT-REV-MTH-LST-NRML                               
PRJ228              ,:AT-TOTAL-AR-BALANCE                               
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-INDICATOR EQUAL -1                             
                 MOVE SPACES               TO BI-DATE-BILLED            
              END-IF                                                    
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7200-FETCH-CURSOR '           
              DISPLAY '**  FETCH ECUST CURSOR'                          
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*07360000
      *                                                                *07370000
      *   7300-CLOSE-CURSOR.                                           *07380000
      *        CLOSING CURSOR ECUST ON TABLES                          *07390000
      *                                                                *07400000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*07410000
                                                                        
       7300-CLOSE-CURSOR.                                               
                                                                        
           MOVE '7300'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           EXEC SQL                                                     
                CLOSE ECUST                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7300-CLOSE-CURSOR '           
              DISPLAY '**  CLOSE ECUST CURSOR '                         
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*07690000
      *                                                                *07700000
      *   7400-BANKDRAFT-DETAIL                                        *07710000
      *        RETRIEVE THE BANK DRAFT INFO FOR THE ACCOUNT            *07720000
      *                                                                *07730000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*07740000
                                                                        
       7400-BANKDRAFT-DETAIL.                                           
                                                                        
           MOVE '7400'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           EXEC SQL                                                     
             SELECT STATUS_CODE                                         
C25964              ,INIT_TYPE_CD                                       
               INTO :BE-STATUS-CODE                                     
C25964              ,:BE-INIT-TYPE-CD                                   
               FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                         
T35434                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07800000
MFA-TR*      SELECT STATUS_CODE                                         07810000
MFA-TR*             ,INIT_TYPE_CD                                       07811000
MFA-TR*        INTO :BE-STATUS-CODE                                     07820000
MFA-TR*             ,:BE-INIT-TYPE-CD                                   07821000
MFA-TR*        FROM CSS_BANK_EFT                                        07830000
MFA-TR*       WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                         07840000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                     07850000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES               TO BE-STATUS-CODE            
              END-IF                                                    
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH = 7400-BANKDRAFT-DETAIL'           
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  ACCOUNT NO   = ' BE-ACCOUNT-NO               
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ526*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*07690000
PRJ526*                                                                *07700000
PRJ526*   7425-SET-AUTOCARD-FLAG                                       *07710000
PRJ526*        SETS THE AUTOCARD FLAG IF THE CUSTOMER IS ENROLLED.     *07720000
PRJ526*                                                                *07730000
PRJ526*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*07740000
PRJ526                                                                  
PRJ526 7425-SET-AUTOCARD-FLAG.                                          
PRJ526                                                                  
PRJ526     MOVE '7425' TO WS-ACTIVE-PARAGRAPH.                          
PRJ526                                                                  
PRJ526     EXEC SQL                                                     
PRJ526       SELECT 'Y'                                                 
PRJ526         INTO :WS-AUTOCARD-FLAG                                   
PRJ526         FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                    
PRJ526        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 
PRJ526          AND ATTRIBUTE_DESC     = 'AUTO_CARD_PAY'                
PRJ526          AND ATTRIBUTE_VALUE_CD = 'AUTOC'                        
PRJ526          AND STATUS_CD          = 'A'                            
PRJ526                                                           
PRJ526     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07800000
MFA-TR*      SELECT 'Y'                                                 07810000
MFA-TR*        INTO :WS-AUTOCARD-FLAG                                   07820000
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE                                  07830000
MFA-TR*       WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 07840000
MFA-TR*         AND ATTRIBUTE_DESC     = 'AUTO_CARD_PAY'                07840000
MFA-TR*         AND ATTRIBUTE_VALUE_CD = 'AUTOC'                        07840000
MFA-TR*         AND STATUS_CD          = 'A'                            07840000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    07850000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ526                                                                  
PRJ526     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PRJ526                                                                  
PRJ526     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
PRJ228        CONTINUE                                                  
PRJ526     ELSE                                                         
PRJ526        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
PRJ526           MOVE 'N' TO WS-AUTOCARD-FLAG                           
PRJ526        ELSE                                                      
PRJ526           DISPLAY '***********************************'          
PRJ526           DISPLAY '**  PROCESSING ERROR             **'          
PRJ526           DISPLAY '**  PARAGRAPH = 7425-SET-AUTOCARD-FLAG'       
PRJ526           DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE    
PRJ526           DISPLAY '**  ACCOUNT NO   = ' AT-ACCOUNT-NO            
PRJ526           DISPLAY '**  PROCESSING TERMINATED        **'          
PRJ526           DISPLAY '***********************************'          
PRJ526           PERFORM 9900-ABEND           THRU 9900-EXIT            
PRJ526        END-IF                                                    
PRJ526     END-IF.                                                      
PRJ526                                                                  
PRJ526 7425-EXIT.                                                       
PRJ526     EXIT.                                                        
C29529                                                                  
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08061003
C29529*                                                                *08062003
C29529*   7500-OPEN-DELINQ-CURSOR                                      *08063003
C29529*        OPENS THE CURSOR TO FETCH ROWS                          *08064003
C29529*                                                                *08065003
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08066003
C29529                                                                  
C29529                                                                  
C29529 7500-OPEN-DELINQ-CURSOR.                                         
C29529                                                                  
C29529     MOVE '7500'                     TO WS-ACTIVE-PARAGRAPH       
C29529                                                                  
C29529     EXEC SQL                                                     
C29529          OPEN EML_DELINQ                                         
C29529     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C29529        CONTINUE                                                  
C29529     ELSE                                                         
C29529        DISPLAY '***********************************'             
C29529        DISPLAY '**  PROCESSING ERROR             **'             
C29529        DISPLAY '**  PARAGRAPH    =  7500-OPEN-DELINQ-CURSOR'     
C29529        DISPLAY '**  OPEN EML_DELINQ CURSOR'                      
C29529        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
C29529        DISPLAY '**  PROCESSING TERMINATED        **'             
C29529        DISPLAY '***********************************'             
C29529        PERFORM 9900-ABEND           THRU 9900-EXIT               
C29529     END-IF                                                       
C29529     .                                                            
C29529 7500-EXIT.                                                       
C29529     EXIT.                                                        
C29529                                                                  
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08071503
C29529*                                                                *08071603
C29529*   7525-FETCH-DELINQ-CURSOR                                     *08071703
C29529*        GETS DELINQUENCY INFO                                   *08071803
C29529*                                                                *08072003
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08072103
C29529                                                                  
C29529 7525-FETCH-DELINQ-CURSOR.                                        
C29529                                                                  
C29529     MOVE '7525'                     TO WS-ACTIVE-PARAGRAPH       
C29529                                                                  
C29529     EXEC SQL                                                     
C29529        FETCH EML_DELINQ INTO                                     
C29529               :C8-COMPANY-NO                                     
C29529              ,:C8-DELINQ-CD                                      
C31785              ,:C8-DELINQ-VALUE                                   
C29529     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C29529        CONTINUE                                                  
C29529     ELSE                                                         
C29529        DISPLAY '***********************************'             
C29529        DISPLAY '**  PROCESSING ERROR             **'             
C29529        DISPLAY '**  PARAGRAPH    = 7525-FETCH-DELINQ-CURSOR'     
C29529        DISPLAY '**  FETCH EML_DELINQ CURSOR'                     
C29529        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
C29529        DISPLAY '**  PROCESSING TERMINATED        **'             
C29529        DISPLAY '***********************************'             
C29529        PERFORM 9900-ABEND           THRU 9900-EXIT               
C29529     END-IF                                                       
C29529     .                                                            
C29529 7525-EXIT.                                                       
C29529     EXIT.                                                        
C29529                                                                  
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08076103
C29529*                                                                *08076203
C29529*   7550-CLOSE-DELINQ-CURSOR                                     *08076303
C29529*        CLOSING DELINQUENCY CURSOR                              *08076403
C29529*                                                                *08076503
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08076603
C29529                                                                  
C29529 7550-CLOSE-DELINQ-CURSOR.                                        
C29529                                                                  
C29529     MOVE '7550'                     TO WS-ACTIVE-PARAGRAPH       
C29529                                                                  
C29529     EXEC SQL                                                     
C29529          CLOSE EML_DELINQ                                        
C29529     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C29529        CONTINUE                                                  
C29529     ELSE                                                         
C29529        DISPLAY '***********************************'             
C29529        DISPLAY '**  PROCESSING ERROR             **'             
C29529        DISPLAY '**  PARAGRAPH    = 7550-CLOSE-DELINQ-CURSOR'     
C29529        DISPLAY '**  CLOSE EML_DELINQ CURSOR '                    
C29529        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
C29529        DISPLAY '**  PROCESSING TERMINATED        **'             
C29529        DISPLAY '***********************************'             
C29529        PERFORM 9900-ABEND           THRU 9900-EXIT               
C29529     END-IF                                                       
C29529     .                                                            
C29529 7550-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
PRJ228*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08076103
PRJ228*                                                                *08076203
PRJ228*   7700-GET-CRED-COLL-DNP                                       *08076303
PRJ228*                                                                *08076503
PRJ228*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08076603
PRJ228 7700-GET-CRED-COLL-DNP.                                          
PRJ228                                                                  
PRJ228     MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH       
PRJ228                                                                  
PRJ228     MOVE 'N'         TO WS-DNP                                   
PRJ228     MOVE SPACE       TO CL-CODE-NOTICE-TYPE                      
PRJ228     MOVE ZERO        TO CL-AMT-NOTICE                            
                                                                        
PRJ228     EXEC SQL                                                     
PRJ228          SELECT TOP(1) 'Y',
              CL.CODE_NOTICE_TYPE,
              CL.AMT_NOTICE                                    
PRJ228            INTO :WS-DNP                                          
PRJ228                ,:CL-CODE-NOTICE-TYPE                             
PRJ228                ,:CL-AMT-NOTICE                                   
PRJ228            FROM CSS_CRED_COLL CL WITH(READUNCOMMITTED)                   
PRJ228           WHERE CL.ACCOUNT_NO = :AT-ACCOUNT-NO                   
PRJ228             AND CL.CODE_NOTICE_TYPE IN('D','G','H','I')          
PRJ228                                              
PRJ228                                                           
PRJ228      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08077203
MFA-TR*         SELECT 'Y'                                              08077303
MFA-TR*               ,CL.CODE_NOTICE_TYPE                                      
MFA-TR*               ,CL.AMT_NOTICE                                            
MFA-TR*           INTO :WS-DNP                                          08077303
MFA-TR*               ,:CL-CODE-NOTICE-TYPE                                     
MFA-TR*               ,:CL-AMT-NOTICE                                           
MFA-TR*           FROM CSS_CRED_COLL CL                                 08077303
MFA-TR*          WHERE CL.ACCOUNT_NO = :AT-ACCOUNT-NO                   08077303
MFA-TR*            AND CL.CODE_NOTICE_TYPE IN('D','G','H','I')          08077303
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*     END-EXEC.                                                   08077403

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ228                                                                  
PRJ228     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
PRJ228                                                                  
PRJ228     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ228        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
PRJ228           MOVE CL-AMT-NOTICE        TO WS-CL-AMT-NOTICE          
PRJ228        END-IF                                                    
PRJ228     ELSE                                                         
PRJ228        DISPLAY '***********************************'             
PRJ228        DISPLAY '**  PROCESSING ERROR             **'             
PRJ228        DISPLAY '**  PARAGRAPH    = 7700-GET-DNP-IND'             
PRJ228        DISPLAY '**  SELECT CSS_CRED_COLL/CSS_SO_DATA'            
PRJ228        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
PRJ228        DISPLAY '**  PROCESSING TERMINATED        **'             
PRJ228        DISPLAY '***********************************'             
PRJ228        PERFORM 9900-ABEND           THRU 9900-EXIT               
PRJ228     END-IF                                                       
PRJ228     .                                                            
PRJ228 7700-EXIT.                                                       
PRJ228     EXIT.                                                        
                                                                        
PRJ228*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08076103
PRJ228*                                                                *08076203
PRJ228*   7750-GET-SO-DATA-DNP                                         *08076303
PRJ228*                                                                *08076503
PRJ228*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08076603
PRJ228 7750-GET-SO-DATA-DNP.                                            
PRJ228                                                                  
PRJ228     MOVE '7750'                     TO WS-ACTIVE-PARAGRAPH       
PRJ228                                                                  
PRJ228     MOVE 'N'         TO WS-DNP                                   
                                                                        
PRJ228     EXEC SQL                                                     
PRJ228          SELECT TOP(1) 'Y'                                              
PRJ228            INTO :WS-DNP                                          
PRJ228            FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                     
PRJ228           WHERE VO.ACCOUNT_NO = :AT-ACCOUNT-NO                   
PRJ228             AND VO.ORDER_TYPE_CD LIKE ('%DNP%')                  
PRJ228             AND VO.ORDER_STATE_CD IN ('A','B','D','H','Q','R')   
PRJ228        ORDER BY VO.DATE_RECVED DESC                              
PRJ228                                              
PRJ228                                                           
PRJ228      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08077203
MFA-TR*         SELECT 'Y'                                              08077303
MFA-TR*           INTO :WS-DNP                                          08077303
MFA-TR*           FROM CSS_SO_DATA VO                                   08077303
MFA-TR*          WHERE VO.ACCOUNT_NO = :AT-ACCOUNT-NO                   08077303
MFA-TR*            AND VO.ORDER_TYPE_CD LIKE ('%DNP%')                  08077303
MFA-TR*            AND VO.ORDER_STATE_CD IN ('A','B','D','H','Q','R')           
MFA-TR*       ORDER BY VO.DATE_RECVED DESC                              08077303
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*     END-EXEC.                                                   08077403

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ228                                                                  
PRJ228     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
PRJ228                                                                  
PRJ228     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ228        CONTINUE                                                  
PRJ228     ELSE                                                         
PRJ228        DISPLAY '***********************************'             
PRJ228        DISPLAY '**  PROCESSING ERROR             **'             
PRJ228        DISPLAY '**  PARAGRAPH    = 7750-GET-DNP-IND'             
PRJ228        DISPLAY '**  SELECT CSS_CRED_COLL/CSS_SO_DATA'            
PRJ228        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
PRJ228        DISPLAY '**  PROCESSING TERMINATED        **'             
PRJ228        DISPLAY '***********************************'             
PRJ228        PERFORM 9900-ABEND           THRU 9900-EXIT               
PRJ228     END-IF                                                       
PRJ228     .                                                            
PRJ228 7750-EXIT.                                                       
PRJ228     EXIT.                                                        
                                                                        
PRJ228*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08076103
PRJ228*                                                                *08076203
PRJ228*   7800-GET-ANNINVERSARY-DT                                     *08076303
PRJ228*                                                                *08076503
PRJ228*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08076603
PRJ228 7800-GET-ANNIVERSARY-DT.                                         
PRJ228                                                                  
PRJ228     MOVE '7800'                     TO WS-ACTIVE-PARAGRAPH       
PRJ228                                                                  
PRJ228     EXEC SQL                                                     
PRJ228          SELECT ANNIVERSARY_DATE                                 
PRJ228            INTO :BU-ANNIVERSARY-DATE                             
PRJ228            FROM CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                 
PRJ228           WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
PRJ228                                                           
PRJ228     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08077203
MFA-TR*         SELECT ANNIVERSARY_DATE                                 08077303
MFA-TR*           INTO :BU-ANNIVERSARY-DATE                             08077303
MFA-TR*           FROM CSS_BUDGET_PLAN BU                               08077303
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      08077303
MFA-TR*          WITH UR                                                08077303
MFA-TR*    END-EXEC                                                     08077403

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ228                                                                  
PRJ228     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
PRJ228                                                                  
PRJ228     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
PRJ228        CONTINUE                                                  
PRJ228     ELSE                                                         
PRJ228        DISPLAY '***********************************'             
PRJ228        DISPLAY '**  PROCESSING ERROR             **'             
PRJ228        DISPLAY '**  PARAGRAPH    = 7800-GET-ANNIVERSARY-DT'      
PRJ228        DISPLAY '**  SELECT CSS_BUDGET_PLAN'                      
PRJ228        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
PRJ228        DISPLAY '**  PROCESSING TERMINATED        **'             
PRJ228        DISPLAY '***********************************'             
PRJ228        PERFORM 9900-ABEND           THRU 9900-EXIT               
PRJ228     END-IF                                                       
PRJ228     .                                                            
PRJ228 7800-EXIT.                                                       
PRJ228     EXIT.                                                        
                                                                        
ACT070*****************************************************************         
ACT070* 7850-SET-NEXT-VALUE.                                          *         
ACT070*****************************************************************         
ACT070 7850-SET-NEXT-VALUE.                                             
      *                                                                         
ACT070     EXEC SQL                                                     
ACT070        SELECT
              NEXT VALUE FOR SEQ_AE_BATCH_EMAIL_ID
            INTO
              :AE-BATCH-EMAIL-ID
ACT070     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*       SET :AE-BATCH-EMAIL-ID = NEXTVAL FOR SEQ_AE_BATCH_EMAIL_ID07458000
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
ACT070     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
ACT070     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT070        CONTINUE                                                  
ACT070     ELSE                                                         
ACT070        DISPLAY '***********************************'             
ACT070        DISPLAY '**  PROCESSING ERROR             **'             
ACT070        DISPLAY '**  PARAGRAPH    = 7850-SET-NEXT-VALUE    '      
ACT070        DISPLAY '**  SET CSS_BATCH_EMAIL'                         
ACT070        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
ACT070        DISPLAY '**  PROCESSING TERMINATED        **'             
ACT070        DISPLAY '***********************************'             
ACT070        PERFORM 9900-ABEND                THRU 9900-EXIT          
ACT070     END-IF.                                                      
                                                                        
      *                                                                         
ACT070 7850-EXIT.                                                       
ACT070     EXIT.                                                        
      *                                                                 12950000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08079400
      *                                                                *08080000
      *   8100-INSERT-BATCH-EMAIL.                                     *08090000
      *        INSERTS A ROW IN CSS_BATCH_EMAIL TABLE                  *08100000
      *                                                                *08110000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08120000
                                                                        
       8100-INSERT-BATCH-EMAIL.                                         
                                                                        
           MOVE '8100'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_BATCH_EMAIL                             
                       (ACCOUNT_NO                                      
                       ,CUSTOMER_NO                                     
                       ,EMAIL_EVENT_CD                                  
                       ,EMAIL_EVENT_DT                                  
ACT070                 ,BATCH_EMAIL_ID                                  
                       ,COMPANY_NO)                                     
                VALUES                                                  
                       (:AE-ACCOUNT-NO                                  
                       ,:AE-CUSTOMER-NO                                 
                       ,:AE-EMAIL-EVENT-CD                              
                       ,IIF(TRY_CONVERT(DATE, :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )                           
ACT070                 ,:AE-BATCH-EMAIL-ID                              
                       ,:AE-COMPANY-NO)                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         INSERT INTO CSS_BATCH_EMAIL                             08190000
MFA-TR*                (ACCOUNT_NO                                      08200000
MFA-TR*                ,CUSTOMER_NO                                     08210000
MFA-TR*                ,EMAIL_EVENT_CD                                  08220000
MFA-TR*                ,EMAIL_EVENT_DT                                  08230000
MFA-TR*                ,BATCH_EMAIL_ID                                          
MFA-TR*                ,COMPANY_NO)                                     08240000
MFA-TR*         VALUES                                                  08250000
MFA-TR*                (:AE-ACCOUNT-NO                                  08260000
MFA-TR*                ,:AE-CUSTOMER-NO                                 08270000
MFA-TR*                ,:AE-EMAIL-EVENT-CD                              08280000
MFA-TR*                ,:AE-EMAIL-EVENT-DT                              08290000
MFA-TR*                ,:AE-BATCH-EMAIL-ID                                      
MFA-TR*                ,:AE-COMPANY-NO)                                 08300000
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              DISPLAY AE-ACCOUNT-NO     '  '                            
                      AE-EMAIL-EVENT-CD '  '                            
                      AE-EMAIL-EVENT-DT                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 8100-INSERT-BATCH-EMAIL'    
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  ACCOUNT NO     = ' AE-ACCOUNT-NO             
              DISPLAY '**  CUSTOMER NO    = ' AE-CUSTOMER-NO            
              DISPLAY '**  EMAIL EVENT CD = ' AE-EMAIL-EVENT-CD         
              DISPLAY '**  EMAIL EVENT DT = ' AE-EMAIL-EVENT-DT         
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08540000
      *                                                                *08550000
      *   8910-CHECK-FOR-RESTART                                       *08560000
      *        CHECKS FOR RESTART DATA FOR THE PROGRAM NAME            *08570000
      *                                                                *08580000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*08590000
                                                                        
       8910-CHECK-FOR-RESTART.                                          
                                                                        
           EXEC SQL                                                     
             SELECT RESTART_DATA                                        
               INTO :RF-RESTART-DATA                                    
               FROM CSS_RESTART WITH(READUNCOMMITTED)                           
              WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                     
                AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                     
                AND PARTITION_NO = :RF-PARTITION-NO                     
T35434                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08630000
MFA-TR*      SELECT RESTART_DATA                                        08640000
MFA-TR*        INTO :RF-RESTART-DATA                                    08650000
MFA-TR*        FROM CSS_RESTART                                         08660000
MFA-TR*       WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                     08670000
MFA-TR*         AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                     08680000
MFA-TR*         AND PARTITION_NO = :RF-PARTITION-NO                     08690000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                     08700000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                MOVE RF-RESTART-DATA-TEXT  TO WS-RESTART-DATA           
                SET  WS-THIS-IS-A-RESTART  TO TRUE                      
                DISPLAY '***********************************'           
                DISPLAY '**         PROCESSING INFO       **'           
                DISPLAY '**        THIS IS A RESTART      **'           
                DISPLAY '***********************************'           
              WHEN NOT-FOUND                                            
                CONTINUE                                                
              WHEN OTHER                                                
                DISPLAY '***********************************'           
                DISPLAY '**  PROCESSING ERROR             **'           
                DISPLAY '**  PARAGRAPH     = 8910-CHECK-FOR-RESTART'    
                DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE    
                DISPLAY '**  PROGRAM NAME  = ' RF-NAME-PROGRAM          
                DISPLAY '**  DUP CNTRL NO  = ' RF-DUP-CNTRL-NO          
                DISPLAY '**  PARTITION NO  = ' RF-PARTITION-NO          
                DISPLAY '**  PROCESSING TERMINATED        **'           
                DISPLAY '***********************************'           
                PERFORM 9900-ABEND         THRU 9900-EXIT               
           END-EVALUATE                                                 
           .                                                            
       8910-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*09010000
      *                                                                *09020000
      *   8920-WRITE-RESTART-RECORD                                    *09030000
      *        INSERTS OR UPDATES THE RESTART RECORD IN RESTART TABLE  *09040000
      *                                                                *09050000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*09060000
                                                                        
       8920-WRITE-RESTART-RECORD.                                       
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              EXEC SQL                                                  
                UPDATE CSS_RESTART                                      
                   SET RESTART_DATA = :RF-RESTART-DATA                  
                 WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                  
                   AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                  
                   AND PARTITION_NO = :RF-PARTITION-NO                  
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           ELSE                                                         
              EXEC SQL                                                  
                INSERT INTO CSS_RESTART                                 
                       (NAME_PROGRAM,                                   
                       PARTITION_NO,                                    
                       DUP_CNTRL_NO,                                    
                       RESTART_DATA)                                    
                VALUES                                                  
                       (:RF-NAME-PROGRAM,                               
                       :RF-PARTITION-NO,                                
                       :RF-DUP-CNTRL-NO,                                
                       :RF-RESTART-DATA)                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF                                                       
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH     = 8920-WRITE-RESTART-RECORD **'
              DISPLAY '**  RETURN CODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  PROGRAM NAME  = ' RF-NAME-PROGRAM            
              DISPLAY '**  DUP CNTRL NO  = ' RF-DUP-CNTRL-NO            
              DISPLAY '**  PARTITION NO  = ' RF-PARTITION-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           .                                                            
       8920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*09530000
      *                                                                *09540000
      *   8930-DELETE-RESTART-RECORD.                                  *09550000
      *        DELETES RESTART RECORD FROM THE RESTART TABLE           *09560000
      *                                                                *09570000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*09580000
                                                                        
       8930-DELETE-RESTART-RECORD.                                      
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_RESTART                                    
              WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                     
                AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                     
                AND PARTITION_NO = :RF-PARTITION-NO                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 8930-DELETE-RESTART-RECORD' 
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '**  PROGRAM NAME   = ' RF-NAME-PROGRAM           
              DISPLAY '**  DUP CNTRL NO   = ' RF-DUP-CNTRL-NO           
              DISPLAY '**  PARTITION NO   = ' RF-PARTITION-NO           
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           .                                                            
       8930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*09890000
      *                                                                *09900000
      *   8898-ISSUE-CHKP.                                             *09910000
      *        COMMIT ALL THE CHANGES                                  *09920000
      *                                                                *09930000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*09940000
                                                                        
       8898-ISSUE-CHKP.                                                 
           EXEC SQL                                                     09970000
              INCLUDE CPD00047                                          09980000
           END-EXEC                                                     09990000
           .                                                            10000000
                                                    
       8898-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*10040000
      *                                                                *10050000
      *   9000-TERMINATE.                                              *10060000
      *                                                                *10070000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*10080000
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSAC175-FILE                                          
                                                                        
           IF WS-FAC175-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSAC175  PROCESSING ERROR **'               
              DISPLAY '**    CLOSE ERROR OF FCSAC175 INPUT FILE'        
              DISPLAY '**    FILE STATUS = ' WS-FAC175-STATUS           
           END-IF                                                       
                                                                        
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*10270000
      *                                                                *10280000
      *  6251-GET-FJC01-DATE                                           *10290000
      *                                                                *10300000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*10310000
                                                                        
       COPY CPD00037.                                                   10330000
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*10350000
      *                                                                *10360000
      *  7600-START-FCSJC01                                            *10370000
      *                                                                *10380000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*10390000
                                                                        
           EXEC SQL                                                     10410000
               INCLUDE CPD00038                                         10420000
           END-EXEC.                                                    10430000
                                                                        
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*10450000
C29529*                                                                *10460000
C29529* COPYBOOK FOR ABEND ROUTINE                                     *10470000
C29529*                                                                *10480000
C29529*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*10490000
                                                                        
C29529     EXEC SQL                                                     10510000
C29529         INCLUDE CPD0023B                                         10520000
C29529     END-EXEC.                                                    10530000
                                                                        
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*10450000
      *                                                                *10460000
      * COPYBOOK FOR ABEND ROUTINE                                     *10470000
      *                                                                *10480000
      *+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*10490000
                                                                        
           EXEC SQL                                                     10510000
               INCLUDE CPD09900                                         10520000
           END-EXEC.                                                    10530000
