       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSAC174.                                            
       AUTHOR. COVANSYS.                                                
       DATE-WRITTEN. JULY 2001.                                         
                                                                        
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **                         COVANSYS                            **         
      **                                                             **         
      *****************************************************************         
      ********            FIELD CASH SYSTEM                   *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **     DATE       INITIALS   REASON                            **         
      **   ==========   =========  ================================  **         
T22767**   07-16-2001   COVANSYS   NEW PROGRAM TO UPLOAD APS         **         
      **                CHENNAI    PAYMENTS FOR CIS POSTING          **         
T22767**   10/05/2001   BASKAR     MADE CHANGES FOR PHONE CHARGE PYMT**         
T25923**   04/30/2002   BASKAR     SEND BATCH TYPE CODE 6 FOR SCEG APS*         
C30395**   06/22/2004   BASKAR     CHANGES FOR CHECKFREE              *         
C30395**                           IMPLEMENTATION                    **         
A02843**   02/22/2011   AP40911    FIX NEGATIVE AMOUNT ISSUE AND S04C**         
A03203**   03/15/2011   AP40911    CONVERT PCSAC174-01 REPORT TO BOE **         
      *****************************************************************         
             REMARKS.                                                   
      *****************************************************************         
      * THIS PROGRAM WILL FORMAT THE RAPIDPAY AND PHONE CHANGE PAYMENT*         
      * FILE TO BANCTEC FILE FORMAT. THIS PROGRAM VALIDATES THE FILE  *         
      * AND ASSIGN BATCH NO ALSO DEPENDING UPON THE INPUT FILE.       *         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT CSHBANK ASSIGN  TO UT-S-CSHBANK.                      
           SELECT CSHBNKTC ASSIGN TO UT-S-CSHBNKTC.                     
A03203*COPY CSSPT33.                                                            
                                                                        
A03203     SELECT FCSAC28-FILE ASSIGN UT-S-FCSAC28                      
A03203            FILE STATUS IS WS-FAC28-STATUS.                       
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
       FD  CSHBANK                                                      
           RECORDING MODE IS F                                          
           LABEL RECORDS STANDARD                                       
           DATA RECORD ARE WEB-HDR-REC WEB-DET-REC.                     
       01  WEB-REC.                                                     
           05  WEB-HDR-SOURCE          PIC XX.                          
           05  WEB-HDR-COMPANY         PIC XX.                          
           05  WEB-RECORD-COUNT        PIC 9(10).                       
           05  WEB-TOTAL-AMOUNT        PIC 9(08)V99.                    
           05  WEB-HDR-DATE            PIC 9(08).                       
           05  FILLER                  PIC X(68).                       
       01  WEB-DET-REC.                                                 
           05  WEB-DET-SOURCE          PIC XX.                          
           05  WEB-SCEGACCT            PIC X(13).                       
           05  WEB-NAME                PIC X(22).                       
           05  WEB-TRANSIT             PIC X(09).                       
           05  WEB-BANK-NBR            PIC X(16).                       
           05  WEB-DRAFTAMT            PIC 9(08)V99.                    
           05  WEB-DET-DATE            PIC 9(08).                       
           05  WEB-PMT-TYPE            PIC X(01).                       
           05  WEB-TRACE-NUMBER        PIC X(15).                       
           05  FILLER                  PIC X(04).                       
                                                                        
       FD  CSHBNKTC                                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS STANDARD                                       
           DATA RECORD IS DETAIL-REC.                                   
       COPY CSHCBCTC.                                                           
                                                                        
A03203*COPY CFDPT33.                                                            
                                                                        
A03203 FD  FCSAC28-FILE                                                 
A03203     BLOCK CONTAINS  0 RECORDS                                    
A03203     RECORDING MODE  IS F                                         
A03203     LABEL RECORDS   ARE STANDARD.                                
A03203 01  FCSAC28-OUT-REC                 PIC X(60).                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC174'.
MSQ017     COPY MFASQLM.
                                                                        
A03203  01 WS-PRINT-DETAIL.                                             
A03203     05  PRT-ACCOUNT             PIC 9(13).                       
A03203     05  PRT-DRAFT-AMT           PIC 9(09).99.                    
A03203     05  PRT-DATE                PIC X(8).                        
A03203     05  PRT-PAY-TYPE            PIC X(01).                       
A03203     05  PRT-NAME                PIC X(22).                       
                                                                        
        01 WS-TEMP-DATE.                                                
           05  WS-TEMP-CCYY            PIC 9(04).                       
           05  FILLER                  PIC X(01) VALUE '-'.             
           05  WS-TEMP-MM              PIC 9(02).                       
           05  FILLER                  PIC X(01) VALUE '-'.             
           05  WS-TEMP-DD              PIC 9(02).                       
        01 WS-FULL-DATE.                                                
           05  FILLER                  PIC 9(2) VALUE 20.               
           05  WS-CURRENT-DATE.                                         
               07 WORK-YR              PIC 9(02).                       
               07 WORK-MO              PIC 9(02).                       
               07 WORK-DA              PIC 9(02).                       
        01 WS-FULL-DATE8 REDEFINES WS-FULL-DATE  PIC 9(8).              
                                                                        
        01 WS-ACCUM-TOTALS.                                             
           05  WS-NO-DETAIL-RECS       PIC S9(5) VALUE +0.              
           05  WS-CHECK-TOTAL          PIC S9(9)V9(2)                   
                                                 VALUE +0.              
           05  WS-AMT-PROCESS          PIC -(9)V99.                     
           05  WS-BATCHES              PIC S9(3) VALUE +0.              
           05  WS-BATCH-SIZE           PIC S9(3) VALUE +0.              
           05  WS-BATCH-TOTAL          PIC S9(9)V9(2)                   
                                                 VALUE +0.              
           05  WS-BATCH-COUNT          PIC S9(3) VALUE +0.              
           05  WS-MAX-BATCH            PIC S9(3) VALUE +900.            
           05  WS-SCEG-1ST-APS-BATCH   PIC 9(3)  VALUE 201.             
           05  WS-GA-1ST-APS-BATCH     PIC 9(3)  VALUE 201.             
           05  WS-PSNC-1ST-APS-BATCH   PIC 9(3)  VALUE 201.             
                                                                        
        01 WS-RUN-FOR                  PIC XX.                          
           88  GEORGIA                           VALUE 'GA'.            
           88  SOUTH-CAROLINA                    VALUE 'SC'.            
           88  NORTH-CAROLINA                    VALUE 'NC'.            
                                                                        
        01 WS-DETAIL-REC.                                               
            05  WS-REC-TYPE-DET        PIC 9(01).                       
            05  WS-OUT-SEQ-NO-DET      PIC 9(06).                       
            05  WS-DATE-DET.                                            
                10  WS-MONTH-DET       PIC 9(02).                       
                10  WS-DAY-DET         PIC 9(02).                       
                10  WS-YEAR-DET        PIC 9(02).                       
            05  WS-REPORT-DET.                                          
                10  WS-BATCH-TYPE-DET  PIC 9(01).                       
            05  WS-BATCH-NO-DET        PIC 9(03).                       
            05  WS-SEQ-NO-DET          PIC 9(06).                       
            05  WS-ACCT-NO-DET         PIC 9(13).                       
            05  WS-CURR-TYPE           PIC X(01).                       
            05  WS-PAY-CD-DET          PIC X(01).                       
            05  WS-AMT-DET             PIC 9(8)V9(02).                  
            05  WS-BILL-DATE.                                           
                10  WS-BILL-MM         PIC X(02).                       
                10  WS-BILL-YY         PIC X(02).                       
            05  FILLER                 PIC X(28).                       
                                                                        
        01  WS-BATCH-TOTAL-REC.                                         
            05  WS-REC-TYPE-BTR        PIC 9(01).                       
            05  WS-OUT-SEQ-NO-BTR      PIC 9(06).                       
            05  WS-DATE-BTR.                                            
                10  WS-MONTH-BTR       PIC 9(02).                       
                10  WS-DAY-BTR         PIC 9(02).                       
                10  WS-YEAR-BTR        PIC 9(02).                       
            05  WS-REPORT-BTR.                                          
                10  WS-BATCH-TYPE-BTR  PIC 9(01).                       
            05  WS-BATCH-NO-BTR        PIC 9(03).                       
            05  WS-TOTAL-NO-DOCS-BTR   PIC 9(03).                       
            05  WS-DOC-TOTAL-BTR       PIC 9(09)V9(02).                 
            05  WS-CHECK-TOTAL-BTR     PIC 9(09)V9(02).                 
            05  WS-BANK-NO-BTR         PIC 9(05).                       
            05  WS-AGENT-ID-BTR        PIC X(06).                       
            05  FILLER                 PIC X(27).                       
                                                                        
       01  WS-DISP-RC                  PIC -ZZZZZZZZ9.9.                
       01  WS-ERR-MSG                  PIC X(40) VALUE SPACES.          
       01  WS-PGRMNAME                 PIC X(08) VALUE 'PCSAC174'.      
       01  WS-PGMNAME                  PIC X(08) VALUE 'PCSAC174'.      
       01  WS-WORK-CNTR                PIC 9(06) VALUE 700000.          
       01  WS-INCR                     PIC S9    VALUE +5.              
       01  WS-1                        PIC X(02) VALUE '01'.            
       01  WS-26                       PIC X(02) VALUE '26'.            
       01  WS-YES                      PIC X(01) VALUE 'Y'.             
       01  WS-NO                       PIC X(01) VALUE 'N'.             
       01  WS-NEW-BUS-DATE.                                             
           05 WS-NEW-BUS-DD            PIC  9(02).                      
           05 FILLER                   PIC  X(01) VALUE '-'.            
           05 WS-NEW-BUS-MM            PIC  9(02).                      
           05 FILLER                   PIC  X(01) VALUE '-'.            
           05 WS-NEW-BUS-YY            PIC  9(02).                      
       01  WS-FLAGS.                                                    
           05 WS-Y                     PIC X(01) VALUE 'Y'.             
           05 WS-N                     PIC X(01) VALUE 'N'.             
       01  WEB-BATCH-STORE.                                             
           05  WBS-HDR-SOURCE          PIC XX.                          
           05  WBS-HDR-COMPANY         PIC XX.                          
           05  WBS-RECORD-COUNT        PIC 9(10).                       
           05  WBS-TOTAL-AMOUNT        PIC 9(8)V99.                     
           05  WBS-HDR-DATE            PIC 9(8).                        
           05  FILLER                  PIC X(55).                       
                                                                        
       01  WS-INPUT-RECS-SW            PIC 9(01).                       
           88  END-OF-INPUT                      VALUE 0.               
           88  NOT-AT-END                        VALUE 1.               
                                                                        
A03203 01  WS-SWITCHES.                                                 
           05 BEGIN-SWITCH                PIC 9(01).                    
               88  FIRST-REC                         VALUE 0.           
               88  INTO-DETAIL                       VALUE 1.           
A03203     05  WS-FAC28-STATUS            PIC X(02)  VALUE '00'.        
A03203         88 WS-FAC28-SUCCESSFUL                VALUE '00' '04'.   
                                                                        
       01  BUSINESS-DATE-SW            PIC X(01) VALUE 'N'.             
           88  CHECK-FOR-BUSINESS-DATE           VALUE 'Y'.             
           88  NOT-CHECK-BUSINESS-DATE           VALUE 'N'.             
                                                                        
      *===============================================================*         
      * SQL COMMUNICATION AREA                                        *         
      *===============================================================*         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      * CSS_COMPANY                                                   *         
      *===============================================================*         
           EXEC SQL                                                             
                INCLUDE TBCOMPNY                                                
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *   CSS_JOB_PARM                                                *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      * CSS_HOLIDAY                                                   *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      * WS USED WITH PAYMENT APPLICATION ROUTINE                      *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00017                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      * WS FOR DATE ROUTINES                                          *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00018                                                 
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      * CWS00315 CONTAINS WS FOR FINDING NEXT BUSINESS DAY            *         
      *===============================================================*         
           EXEC SQL                                                             
               INCLUDE CWS00315                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  STATE-PARM.                                                  
           05  PARM-LEN                PIC S9(4) COMP.                  
           05  PARM-STATE              PIC X(4).                        
                                                                        
       PROCEDURE DIVISION USING STATE-PARM.                             
                                                                        
      *****************************************************************         
      * 0000-MAIN-PARA.                                               *         
      * THIS PROCEDURE CONTROLS THE FLOW OF THE WHOLE PROGRAM         *         
      *****************************************************************         
                                                                        
       0000-MAIN-PARA.                                                  
           MOVE '0000'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 1000-INITIALIZATION-PARA                             
           THRU    1000-EXIT.                                           
                                                                        
           MOVE WBS-HDR-DATE(1:4)           TO WS-TEMP-CCYY.            
           MOVE WBS-HDR-DATE(5:2)           TO WS-TEMP-MM.              
           MOVE WBS-HDR-DATE(7:2)           TO WS-TEMP-DD.              
           MOVE WS-TEMP-DATE                TO WS-NEW-BUSINESS-DAY.     
                                                                        
           IF CHECK-FOR-BUSINESS-DATE                                   
      * GET NEXT BUSINESS DATE                                                  
              PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
                 THRU 6500-NEXT-BUSINESS-DAY-EXIT                       
                 UNTIL NEXT-BUSINESS-DAY-FOUND                          
                                                                        
              IF WS-NEW-BUSINESS-DAY EQUAL  WS-INPUT-DATE               
                 MOVE WS-NEW-BUSINESS-DAY(3:2) TO WS-NEW-BUS-YY         
                 MOVE WS-NEW-BUSINESS-DAY(9:2) TO WS-NEW-BUS-DD         
                 MOVE WS-NEW-BUSINESS-DAY(6:2) TO WS-NEW-BUS-MM         
              ELSE                                                      
                 MOVE 'BUSINESS DATE AND INPUT DATE NOT EQUAL'          
                                               TO WS-ERR-MSG            
                 PERFORM 9100-DISPLAY-ERROR                             
                 THRU    9100-EXIT                                      
                 PERFORM 9900-ABEND                                     
                 THRU    9900-EXIT                                      
              END-IF                                                    
           ELSE                                                         
              IF WS-TEMP-DATE EQUAL WS-INPUT-DATE                       
                 MOVE WBS-HDR-DATE(3:2)        TO WS-NEW-BUS-YY         
                 MOVE WBS-HDR-DATE(5:2)        TO WS-NEW-BUS-MM         
                 MOVE WBS-HDR-DATE(7:2)        TO WS-NEW-BUS-DD         
              ELSE                                                      
                 MOVE 'FILE HDR DATE AND INPUT DATE NOT EQUAL'          
                                               TO WS-ERR-MSG            
                 PERFORM 9100-DISPLAY-ERROR                             
                 THRU    9100-EXIT                                      
                 PERFORM 9900-ABEND                                     
A02843           THRU    9900-EXIT                                      
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WBS-RECORD-COUNT LESS THAN 990                            
              MOVE 1                        TO WS-BATCHES               
              MOVE WBS-RECORD-COUNT         TO WS-BATCH-SIZE            
           ELSE                                                         
              PERFORM 1500-FIND-BATCH-SIZE                              
              THRU    1500-EXIT                                         
           END-IF.                                                      
                                                                        
           IF WBS-RECORD-COUNT GREATER THAN 3990                        
              MOVE +3                       TO WS-INCR                  
           END-IF.                                                      
                                                                        
           IF WBS-RECORD-COUNT GREATER THAN 6600                        
              MOVE +2                       TO WS-INCR                  
           END-IF.                                                      
                                                                        
           PERFORM 2000-READ-CSHBANK                                    
           THRU    2000-EXIT.                                           
                                                                        
           PERFORM 3000-PROCESS-INPUT       UNTIL END-OF-INPUT.         
                                                                        
           IF WS-BATCH-COUNT = ZERO                                     
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 3500-SETUP-BATCH-REC                              
              THRU    3500-EXIT                                         
           END-IF.                                                      
                                                                        
           PERFORM 9300-CROSSFOOT-TOTALS                                
           THRU    9300-EXIT.                                           
                                                                        
           PERFORM 9000-TERMINATE                                       
           THRU    9000-EXIT.                                           
                                                                        
C30395     IF WS-NO-DETAIL-RECS = ZERO                                  
C30395        MOVE '02'   TO RETURN-CODE                                
C30395     END-IF                                                       
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
                                                                        
      *****************************************************************         
      * 1000-INITIALIZATION-PARA.                                     *         
      * THIS ROUTINE OPENS THE FILES, AND INITIALIZES CONTROL AND     *         
      * TOTAL FIELDS AND SWITCHES IN WORKING STORAGE                  *         
      *****************************************************************         
                                                                        
       1000-INITIALIZATION-PARA.                                        
                                                                        
           MOVE '1000'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 1100-OPEN-FILES                                      
           THRU    1100-EXIT,                                           
                                                                        
           EVALUATE PARM-STATE                                          
             WHEN 'GAPS'                                                
               MOVE 'GA'                    TO WS-RUN-FOR               
             WHEN 'SAPS'                                                
               MOVE 'SC'                    TO WS-RUN-FOR               
               ADD 100000                   TO WS-WORK-CNTR             
             WHEN 'NAPS'                                                
               MOVE 'NC'                    TO WS-RUN-FOR               
               ADD 200000                   TO WS-WORK-CNTR             
             WHEN OTHER                                                 
               MOVE 'INVALID PARM VALUE'    TO WS-ERR-MSG               
               PERFORM 9100-DISPLAY-ERROR                               
               THRU    9100-EXIT                                        
               PERFORM 9900-ABEND                                       
               THRU    9900-EXIT                                        
           END-EVALUATE.                                                
                                                                        
           INITIALIZE WS-DETAIL-REC                                     
                      WS-BATCH-TOTAL-REC                                
                      DETAIL-REC.                                       
           MOVE SPACES                      TO WS-PRINT-DETAIL.         
           MOVE SPACES                      TO WS-BATCH-TOTAL-REC.      
           PERFORM  2500-COMMON-DATE-PARA                               
           THRU     2500-EXIT.                                          
                                                                        
           MOVE ZERO                        TO BEGIN-SWITCH.            
           MOVE 1                           TO WS-INPUT-RECS-SW.        
                                                                        
           PERFORM 2000-READ-CSHBANK                                    
           THRU    2000-EXIT                                            
                                                                        
           IF FIRST-REC                                                 
              MOVE WEB-REC                  TO WEB-BATCH-STORE          
              MOVE 1                        TO BEGIN-SWITCH             
           END-IF.                                                      
           EVALUATE WS-RUN-FOR                                          
              WHEN 'GA'                                                 
                 MOVE 1                     TO WS-BATCH-TYPE-DET        
                 MOVE WS-GA-1ST-APS-BATCH   TO WS-BATCH-NO-DET          
                 MOVE '1'                   TO WS-REPORT-BTR            
                 MOVE '000029'              TO WS-AGENT-ID-BTR          
                 MOVE WS-GA-1ST-APS-BATCH   TO WS-BATCH-NO-BTR          
              WHEN 'SC'                                                 
                 MOVE 8                     TO WS-BATCH-TYPE-DET        
                 MOVE WS-SCEG-1ST-APS-BATCH TO WS-BATCH-NO-DET          
                 MOVE '8'                   TO WS-REPORT-BTR            
                 MOVE '000028'              TO WS-AGENT-ID-BTR          
                 MOVE WS-SCEG-1ST-APS-BATCH TO WS-BATCH-NO-BTR          
              WHEN 'NC'                                                 
                 MOVE 8                     TO WS-BATCH-TYPE-DET        
                 MOVE WS-PSNC-1ST-APS-BATCH TO WS-BATCH-NO-DET          
                 MOVE '8'                   TO WS-REPORT-BTR            
                 MOVE '000028'              TO WS-AGENT-ID-BTR          
                 MOVE WS-PSNC-1ST-APS-BATCH TO WS-BATCH-NO-BTR          
              WHEN OTHER                                                
                 MOVE 9                     TO WS-BATCH-TYPE-DET        
                 MOVE '999'                 TO WS-BATCH-NO-DET          
                 MOVE '9'                   TO WS-REPORT-BTR            
                 MOVE '999028'              TO WS-AGENT-ID-BTR          
                 MOVE '999'                 TO WS-BATCH-NO-BTR          
           END-EVALUATE.                                                
           IF WS-INPUT-RECS-SW = '0'                                    
              MOVE 'PCSAC174 NULL INPUT'    TO WS-ERR-MSG               
              PERFORM 9100-DISPLAY-ERROR                                
              THRU    9100-EXIT                                         
              PERFORM 9900-ABEND                                        
              THRU    9900-EXIT                                         
           END-IF.                                                      
                                                                        
           SET NOT-CHECK-BUSINESS-DATE      TO TRUE.                    
                                                                        
           EVALUATE WBS-HDR-SOURCE                                      
              WHEN 'AP'                                                 
                ADD ZERO                    TO WS-WORK-CNTR             
                                                                        
C30395        WHEN 'CF'                                                 
                ADD 20000                   TO WS-WORK-CNTR             
                ADD 20                      TO WS-GA-1ST-APS-BATCH      
                ADD 20                      TO WS-SCEG-1ST-APS-BATCH    
                ADD 20                      TO WS-PSNC-1ST-APS-BATCH    
              WHEN 'BA'                                                 
              WHEN 'TP'                                                 
                ADD 40000                   TO WS-WORK-CNTR             
                ADD 40                      TO WS-GA-1ST-APS-BATCH      
                ADD 40                      TO WS-SCEG-1ST-APS-BATCH    
                ADD 40                      TO WS-PSNC-1ST-APS-BATCH    
                SET CHECK-FOR-BUSINESS-DATE TO TRUE                     
           END-EVALUATE.                                                
                                                                        
C30395     IF WBS-HDR-SOURCE EQUAL ('BA' OR 'TP')                       
              AND WS-RUN-FOR = 'GA'                                     
              MOVE '000024'                 TO WS-AGENT-ID-BTR          
              MOVE '5'                      TO WS-REPORT-BTR            
              MOVE '5'                      TO WS-BATCH-TYPE-DET        
           END-IF.                                                      
C30395     IF WBS-HDR-SOURCE EQUAL 'CF'                                 
              AND WS-RUN-FOR = 'GA'                                     
              MOVE '000039'                 TO WS-AGENT-ID-BTR          
              MOVE '7'                      TO WS-REPORT-BTR            
              MOVE '7'                      TO WS-BATCH-TYPE-DET        
           END-IF.                                                      
C30395     IF WBS-HDR-SOURCE EQUAL ('BA' OR 'TP')                       
              AND WS-RUN-FOR = 'SC'                                     
              MOVE '000019'                 TO WS-AGENT-ID-BTR          
C25923        MOVE '6'                      TO WS-REPORT-BTR            
C25923        MOVE '6'                      TO WS-BATCH-TYPE-DET        
           END-IF.                                                      
C30395     IF WBS-HDR-SOURCE EQUAL 'CF'                                 
              AND WS-RUN-FOR = 'SC'                                     
              MOVE '000036'                 TO WS-AGENT-ID-BTR          
              MOVE '9'                      TO WS-REPORT-BTR            
              MOVE '9'                      TO WS-BATCH-TYPE-DET        
           END-IF.                                                      
C30395     IF WBS-HDR-SOURCE EQUAL 'CF'                                 
              AND WS-RUN-FOR = 'NC'                                     
              MOVE '000036'                 TO WS-AGENT-ID-BTR          
              MOVE '9'                      TO WS-REPORT-BTR            
              MOVE '9'                      TO WS-BATCH-TYPE-DET        
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1100-OPEN-FILES,                                               *        
      *       THIS PARA OPENS ALL THE INPUT AND OUTPUT FILES           *        
      ******************************************************************        
                                                                        
       1100-OPEN-FILES.                                                 
                                                                        
           MOVE '1100'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           OPEN INPUT  CSHBANK.                                         
           OPEN OUTPUT CSHBNKTC.                                        
A03203     OPEN OUTPUT FCSAC28-FILE.                                    
                                                                        
       1100-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1500-FIND-BATCH-SIZE.                                          *        
      * THIS PARA FIGURES OUT THE BATCH SIZES TO KEEP THEM BELOW 999   *        
      ******************************************************************        
                                                                        
       1500-FIND-BATCH-SIZE.                                            
                                                                        
           MOVE '1500'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           DIVIDE WBS-RECORD-COUNT BY WS-MAX-BATCH                      
              GIVING WS-BATCHES ROUNDED.                                
           ADD +1                           TO WS-BATCHES.              
           DIVIDE WBS-RECORD-COUNT BY WS-BATCHES                        
              GIVING WS-BATCH-SIZE.                                     
           ADD +1                           TO WS-BATCH-SIZE.           
                                                                        
       1500-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-READ-CSHBANK.                                             *        
      * THIS PARA WILL READ THE NEXT RECORD OF THE INPUT CSHBANK FILE  *        
      ******************************************************************        
                                                                        
       2000-READ-CSHBANK.                                               
                                                                        
           MOVE '2000'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           READ CSHBANK                                                 
               AT END                                                   
                   SET END-OF-INPUT         TO TRUE                     
               NOT AT END                                               
                   SET NOT-AT-END           TO TRUE                     
           END-READ.                                                    
                                                                        
       2000-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2500-COMMON-DATE-PARA.                                         *        
      * THIS PARA WILL SELECT THE COMMON DATE  FROM CSS_JOB_PARM TABLE *        
      ******************************************************************        
                                                                        
       2500-COMMON-DATE-PARA.                                           
                                                                        
           MOVE '2500'                          TO WS-ACTIVE-PARAGRAPH. 
                                                                        
           PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT              
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '              TO WS-PGRMNAME               
              MOVE SPACES                  TO WS-INPUT-AREA             
              MOVE SPACES                  TO                           
                                              WS-INPUT-DATA-BREAKDOWN   
              PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT               
              MOVE WS-PGMNAME              TO WS-PGRMNAME               
           END-IF                                                       
                                                                        
           MOVE    WS-INPUT-DATE(3:2)       TO  WORK-YR.                
           MOVE    WS-INPUT-DATE(6:2)       TO  WORK-MO.                
           MOVE    WS-INPUT-DATE(9:2)       TO  WORK-DA.                
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3000-PROCESS-INPUT                                             *        
      * PROCESS THE INPUT RECORD FROM CSHBANK                          *        
      ******************************************************************        
                                                                        
       3000-PROCESS-INPUT.                                              
                                                                        
           MOVE '3000'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 3200-DETAIL-REC                                      
           THRU    3200-EXIT.                                           
                                                                        
           PERFORM 3300-WRITE-DETAIL                                    
           THRU    3300-EXIT.                                           
                                                                        
           IF WS-BATCH-COUNT = WS-BATCH-SIZE                            
              PERFORM 3500-SETUP-BATCH-REC                              
              THRU    3500-EXIT                                         
           END-IF.                                                      
                                                                        
           PERFORM 2000-READ-CSHBANK                                    
           THRU    2000-EXIT.                                           
                                                                        
       3000-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 3200-DETAIL-REC                                                *        
      * THE INPUT RECORD IS OF TYPE 1 = DETAIL REC                     *        
      ******************************************************************        
                                                                        
       3200-DETAIL-REC.                                                 
                                                                        
           MOVE '3200'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           MOVE WS-NEW-BUS-YY               TO WS-YEAR-DET.             
           MOVE WS-NEW-BUS-YY               TO WS-BILL-YY.              
           MOVE WS-NEW-BUS-MM               TO WS-MONTH-DET.            
           MOVE WS-NEW-BUS-MM               TO WS-BILL-MM.              
           MOVE WS-NEW-BUS-DD               TO WS-DAY-DET.              
           MOVE WS-FULL-DATE                TO PRT-DATE.                
           MOVE WEB-SCEGACCT                TO WS-ACCT-NO-DET.          
           MOVE WEB-SCEGACCT                TO PRT-ACCOUNT.             
           MOVE WEB-DRAFTAMT                TO WS-AMT-DET.              
           MOVE WEB-DRAFTAMT                TO PRT-DRAFT-AMT.           
A02843     IF WEB-DRAFTAMT IS NUMERIC                                   
A02843        ADD  WS-AMT-DET               TO WS-BATCH-TOTAL           
A02843        MOVE WEB-DRAFTAMT             TO WS-AMT-DET               
A02843     ELSE                                                         
A02843        DISPLAY 'ACCOUNT #          ' WEB-SCEGACCT                
A02843        DISPLAY 'INCORRECT AMOUNT   ' WEB-DRAFTAMT                
A02843        MOVE 0                        TO WS-AMT-DET               
A02843     END-IF                                                       
           MOVE '1'                         TO WS-REC-TYPE-DET.         
           MOVE WS-WORK-CNTR                TO WS-OUT-SEQ-NO-DET.       
           ADD WS-INCR                      TO WS-WORK-CNTR.            
           ADD +1                           TO WS-BATCH-COUNT.          
                                                                        
C30395     EVALUATE WEB-PMT-TYPE                                        
C30395       WHEN '1'                                                   
C30395          MOVE 'A'                    TO WS-CURR-TYPE             
C30395       WHEN '3'                                                   
C30395          MOVE 'M'                    TO WS-CURR-TYPE             
C30395       WHEN OTHER                                                 
C30395          MOVE 'C'                    TO WS-CURR-TYPE             
C30395     END-EVALUATE.                                                
                                                                        
           EVALUATE WS-RUN-FOR                                          
             WHEN 'GA'                                                  
               MOVE WS-GA-1ST-APS-BATCH     TO WS-BATCH-NO-DET          
             WHEN 'SC'                                                  
               MOVE WS-SCEG-1ST-APS-BATCH   TO WS-BATCH-NO-DET          
             WHEN 'NC'                                                  
               MOVE WS-PSNC-1ST-APS-BATCH   TO WS-BATCH-NO-DET          
           END-EVALUATE.                                                
           MOVE '000001'                    TO WS-SEQ-NO-DET.           
           MOVE '0'                         TO WS-PAY-CD-DET.           
           INITIALIZE DETAIL-REC.                                       
           MOVE WS-DETAIL-REC               TO DETAIL-REC.              
           PERFORM 3210-WRITE-DETAIL-REC                                
           THRU    3210-EXIT.                                           
       3200-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 3210-WRITE-DETAIL-REC.                                         *        
      * THIS PROCEDURE WRITES THE DETAIL RECORD                        *        
      ******************************************************************        
                                                                        
       3210-WRITE-DETAIL-REC.                                           
                                                                        
           MOVE '3210'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           WRITE DETAIL-REC.                                            
                                                                        
       3210-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 3300-PRINT-DETAIL.                                             *        
      * THIS PROCEDURE MOVES ALL THE VALUES TO THE REPORT VARIABLES    *        
      ******************************************************************        
                                                                        
       3300-WRITE-DETAIL.                                               
                                                                        
           MOVE '3300'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
C30395     EVALUATE WEB-PMT-TYPE                                        
C30395       WHEN '1'                                                   
C30395          MOVE 'A'                    TO PRT-PAY-TYPE             
C30395       WHEN '3'                                                   
C30395          MOVE 'M'                    TO PRT-PAY-TYPE             
C30395       WHEN OTHER                                                 
C30395          MOVE 'C'                    TO PRT-PAY-TYPE             
C30395     END-EVALUATE.                                                
                                                                        
           MOVE WEB-NAME                    TO PRT-NAME.                
A03203     MOVE WS-PRINT-DETAIL             TO FCSAC28-OUT-REC.         
           PERFORM 3310-PRINT                                           
           THRU    3310-EXIT.                                           
                                                                        
       3300-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 3310-PRINT.                                                    *        
      * THIS PROCEDURE WRITES THE REPORT                               *        
      ******************************************************************        
                                                                        
       3310-PRINT.                                                      
                                                                        
           MOVE '3310'                      TO WS-ACTIVE-PARAGRAPH.     
A03203     WRITE FCSAC28-OUT-REC.                                       
       3310-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 3500-SETUP-BATCH-REC.                                          *        
      * PREPARE THE BATCH RECORD FOR WRITING TO OUTPUT FILE            *        
      ******************************************************************        
                                                                        
       3500-SETUP-BATCH-REC.                                            
                                                                        
           MOVE '3500'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           MOVE  3                          TO WS-REC-TYPE-BTR.         
           MOVE WS-WORK-CNTR                TO WS-OUT-SEQ-NO-BTR.       
           ADD WS-INCR                      TO WS-WORK-CNTR.            
           MOVE WS-NEW-BUS-YY               TO WS-YEAR-BTR.             
           MOVE WS-NEW-BUS-MM               TO WS-MONTH-BTR.            
           MOVE WS-NEW-BUS-DD               TO WS-DAY-BTR.              
                                                                        
           EVALUATE WS-RUN-FOR                                          
              WHEN 'GA'                                                 
                MOVE WS-GA-1ST-APS-BATCH    TO WS-BATCH-NO-BTR          
              WHEN 'SC'                                                 
                MOVE WS-SCEG-1ST-APS-BATCH  TO WS-BATCH-NO-BTR          
              WHEN 'NC'                                                 
                MOVE WS-PSNC-1ST-APS-BATCH  TO WS-BATCH-NO-BTR          
           END-EVALUATE.                                                
           ADD  WS-BATCH-TOTAL              TO WS-CHECK-TOTAL.          
           ADD  WS-BATCH-COUNT              TO WS-NO-DETAIL-RECS.       
           MOVE WS-BATCH-COUNT              TO WS-TOTAL-NO-DOCS-BTR.    
           MOVE WS-BATCH-TOTAL              TO WS-DOC-TOTAL-BTR.        
           MOVE WS-BATCH-TOTAL              TO WS-CHECK-TOTAL-BTR.      
           MOVE '00225'                     TO WS-BANK-NO-BTR.          
           INITIALIZE DETAIL-REC.                                       
           MOVE WS-BATCH-TOTAL-REC          TO DETAIL-REC.              
           PERFORM 3210-WRITE-DETAIL-REC                                
           THRU    3210-EXIT.                                           
           MOVE ZERO                        TO WS-BATCH-TOTAL           
                                               WS-BATCH-COUNT.          
           ADD 1                            TO WS-SCEG-1ST-APS-BATCH.   
           ADD 1                            TO WS-GA-1ST-APS-BATCH.     
           ADD 1                            TO WS-PSNC-1ST-APS-BATCH.   
                                                                        
       3500-EXIT.                                                       
                                                                        
      *****************************************************************         
      * 9000-TERMINATE.                                               *         
      * THIS PARA WILL CLOSE ALL FILES WHICH ARE OPENED.              *         
      *****************************************************************         
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           MOVE '9000'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           CLOSE CSHBANK.                                               
           CLOSE CSHBNKTC.                                              
A03203     CLOSE FCSAC28-FILE.                                          
       9000-EXIT.                                                       
                                                                        
      *****************************************************************         
      * 9300-CROSSFOOT-TOTALS.                                        *         
      * THIS PARA VERIFIES THE AMOUNT TOTALS AND RECORD COUNT         *         
      *****************************************************************         
                                                                        
       9300-CROSSFOOT-TOTALS.                                           
                                                                        
           MOVE '9300'                      TO WS-ACTIVE-PARAGRAPH.     
           IF WS-NO-DETAIL-RECS = WBS-RECORD-COUNT                      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'RECORD COUNT MISMATCH ' TO WS-ERR-MSG               
              PERFORM 9100-DISPLAY-ERROR                                
              THRU    9100-EXIT                                         
              PERFORM 9900-ABEND                                        
              THRU    9900-EXIT                                         
           END-IF.                                                      
                                                                        
           IF WS-CHECK-TOTAL = WBS-TOTAL-AMOUNT                         
              NEXT SENTENCE                                             
           ELSE                                                         
A02843        MOVE WS-CHECK-TOTAL           TO WS-AMT-PROCESS           
A02843        DISPLAY '*********************************'               
A02843        DISPLAY 'TOTAL AMOUNT PROCESSED   ' WS-AMT-PROCESS        
A02843        DISPLAY 'TOTAL AMOUNT FROM FILE   ' WBS-TOTAL-AMOUNT      
A02843        DISPLAY '*********************************'               
              MOVE 'AMOUNT TOTAL MISMATCH'  TO WS-ERR-MSG               
              PERFORM 9100-DISPLAY-ERROR                                
              THRU    9100-EXIT                                         
              PERFORM 9900-ABEND                                        
              THRU    9900-EXIT                                         
           END-IF.                                                      
                                                                        
       9300-EXIT.                                                       
                                                                        
      ******************************************************************        
      *  9100-DISPLAY-ERROR                                            *        
      *  THIS PROCEDURE WILL GIVE THE DETILS OF ERROR MESSAGE WHILE    *        
      *  ABENDING THE PROGRAM                                          *        
      ******************************************************************        
                                                                        
       9100-DISPLAY-ERROR.                                              
                                                                        
           DISPLAY '**   PROCESSING ERROR IN PCSAC174  **'.             
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   COMPANY NO = ', WBS-HDR-COMPANY.               
           DISPLAY '**   ABENDING PROGRAM              **'.             
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  6251-GET-FJC01-DATE                                     *              
      ************************************************************              
                                                                        
       COPY CPD00037.                                                           
                                                                        
      ************************************************************              
      *  7600-START-FCSJC01                                      *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *                                                              **         
      *    COPYBOOK CPD00315 CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT BUSINESS DAY.                                    **         
      *****************************************************************         
      *                                                                         
            EXEC SQL                                                            
                INCLUDE CPD00315                                                
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      *  COPYBOOK FOR ABEND ROUTINE                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
