       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSAC172.                                         
       DATE-WRITTEN.  SEP-2000.                                         
      ***************************************************************           
      *                                                             *           
      *               PROGRAM MODIFICATION LOG                      *           
      *                                                             *           
      *     DATE      INITIALS      REASON                          *           
      *  ========     ========      =============================== *           
T22767*   09/2000     SK82806-CBSI  NEW REPORT PROGRAM FOR PAYMENTS *           
T22767*   07/2001     PA82152-CBSI  FOR SYSIN VALIDATIONS           *           
T22767*   10/2001     BASKAR VANNI  MOVE THE BATCH AMOUNT TO GL     *           
T22767*                             CREDIT INSTEAD OF CASH DEBIT.   *           
T22767*   10/2001     BASKAR VANNI  CHG THE CODE DR CR VALUE TO C.  *           
T22767*   10/2001     BASKAR VANNI  FIX THE JOURNAL PROBLEM         *           
T22767*   11/2001     BASKAR VANNI  DISPLAY THE GRAND TOTAL.        *           
C25923*   02/2002     BASKAR VANNI  MODIFIED THE REPORT TO INCLUDE  *           
C25923*                             REJECT REASON.                  *           
C25923*   04/2002     BASKAR VANNI  ADDED CODE TO SKIP PAYMENT AGENT*           
C25923*                             BANK XFER RECORD FOR REPORT     *           
C25923*   04/2002     RICK SPIRES   ADD APS DIRECT PAYMENTS PROCESS.*           
C25923*   07/2002     BASKAR VANNI  ADD OVERAGES & SHORTAGES IN NEW *           
C25923*                             OVERSHORT TABLE.                *           
C25923*   07/2002     BASKAR VANNI  SEND CORRECT LOCAL OFFICE       *           
C28322*   04/2003     BASKAR VANNI  ADD COBB XFERED ACCT IN REJECT  *           
C28322*                             REASON                          *           
T29889*   12/2003     COVANSYS      DO NOT SHOW REJECT REASON IN    *           
T29889*                             REPORT IF THE ACCOUNT HAS A DFA *           
C33928*   10/2006     BASKAR VANNI  PERFORMANCE TUNING - MOVED BANK *           
C33928*                             TRANSFER LOGIC FOR MAIL PAYMENTS*           
C33928*                             TO THIS PROGRAM FROM PCSAC170   *           
A02388*   05/2010     LAT           REVISE PAYMENT ERROR REPORTING  *           
A02388*                             TO GO TO BOE.                   *           
A03311*   04/2011     BASKAR VANNI  POST PAYMENTS AND BANK TRANSFER *           
A03311*                             IN SAME CASHIER OFFICE          *           
A05460*   05/19/16    MS7M727       TO CONVERT PCSAC171 RPT INTO CSV*           
A05460*               ACT174        FORMAT AND ADDED LOGIC FOR      *           
A05460*                             TO DISPLAY TOTAL PAYMENT AMOUNT *           
A05460*                             WHENEVER BATCH-NO CHANGE        *           
A05460*   10/19/16    LG41184       DO NOT CLOSE CASH REPORT HEADER *           
A05460*                             FOR EDI.                        *           
ACT306*   10/28/16    RB19957       REMOVE ALL LOGIC THAT CALLS DB2 *           
ACT306*  APPL00005460,ACT306        TABLE CSS_BILL_AGNT_PYMT &      *           
ACT306*                             TBBAPYMT.                       *           
      ***************************************************************           
      *                                                                         
       REMARKS.                                                         
      *                                                                         
      ***************************************************************           
      ** THIS IS A GENERIC PROGRAM TO READ INPUT PAYMENT FILE      **           
      ** AND WRITE OUT A REPORT OF ALL THE RECORDS AS WELL AS      **           
      ** CREATE BATCH JOURNAL ENTRIES & BILL AGENT PAYMENT ENTRIES **           
      ** THIS PROGRAM CAN TAKE ANY PAYMENT (PIPELINE OR ERROR)     **           
      ** AS INPUT - IN FUTURE, ANY OTHER SUCH PYMT FILE CAN ALSO   **           
      ** BE USED TO GET THE REQUIRED REPORT                        **           
      ***************************************************************           
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
      ***************************************************************           
      *  CSSAC21 - SELECT STATEMENT FOR INPUT FILE                  *           
      ***************************************************************           
       COPY CSSAC21.                                                            
      *                                                                         
      ***************************************************************           
A02388*  CSSAC26 - SELECT STATEMENT FOR OUTPUT FILE - 103 CHARS     *           
      ***************************************************************           
A02388 COPY CSSAC26.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ***************************************************************           
      *  CFDAC21 - FD SECTION FOR INPUT PYMNT FILE                  *           
      ***************************************************************           
       COPY CFDAC21.                                                            
      *                                                                         
      ***************************************************************           
      *  FIOAC21 - LAYOUT OF INPUT PYMNT FILE                       *           
      ***************************************************************           
       COPY FIOAC21.                                                            
      *                                                                         
      ***************************************************************           
A02388*  CFDAC26 - FD SECTION FOR OUTPUT REPORT FILE.               *           
      ***************************************************************           
A02388 COPY CFDAC26.                                                            
ACT174 01   FAC26-OUTREC                        PIC X(113).             
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC172'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START         PIC X(42) VALUE                             
                          'WORKING STORAGE FOR PCSAC172 BEGINS HERE'.   
      ***************************************************************           
      *  CJF00101 - COPY BOOK FOR TRAN DATA                         *           
      ***************************************************************           
       COPY CJF00101.                                                           
      *                                                                         
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR WORK VARIABLES                *        
      ******************************************************************        
       01  WS-WORK-VARIABLES.                                           
           05  WS-PARM-CO-NO                    PIC X(02)  VALUE SPACES.
ACT174     05  WS-FIRST-HDR                     PIC X(01)  VALUE 'Y'.   
           05  WS-TEMP-CASH-CO-NO               PIC X(02)  VALUE SPACES.
           05  WS-USER-ID                       PIC X(08)  VALUE SPACES.
           05  WS-CASHIER-OFFICE                PIC X(03)  VALUE SPACES.
A03311     05  WS-PREV-BATCH-NO                 PIC X(04)  VALUE SPACES.
ACT174     05  WS-PREV-BATCH-NO1                PIC 9(04)  VALUE ZERO.  
           05  WS-ERR-MSG                       PIC X(100) VALUE SPACES.
T22767     05  WS-TABLE-NAME                    PIC X(18)  VALUE SPACES.
C25923     05  WS-NULL-INDICATOR-1              PIC S9(4) COMP VALUE +0.
C33928     05  WS-NULL-INDICATOR-2              PIC S9(4) USAGE COMP    
C33928                                                    VALUE -1.     
C33928     05  WS-CNTL-TS-NI                    PIC S9(4) USAGE COMP    
C33928                                                    VALUE -1.     
C33928     05  WS-CJ-DATE-NI                    PIC S9(4) USAGE COMP    
C33928                                                    VALUE -1.     
C33928     05  WS-CJ-TIME-NI                    PIC S9(4) USAGE COMP    
C33928                                                    VALUE -1.     
C25923     05  WS-CASH-DRAWER-ID                PIC 9(03).              
C25923     05  WS-TPRTY-GL                      PIC 9(3).9(4).          
C25923     05  WS-TPRTY-TOTAL                   PIC S9(11)V9(2)         
C25923                                                    VALUE ZEROES. 
C25923     05  WS-DISP-GL-ACCT                  PIC 9(3).9(4).          
C33928     05  WS-XFR-TS                        PIC X(26) VALUE SPACES. 
C33928     05  WS-TRAN-TIME                     PIC X(08) VALUE SPACES. 
C33928     05  WS-DISP-CASH-DRAWER-ID           PIC 9(04).              
C33928     05  WS-DISP-BANK-ID                  PIC 9(06).              
C33928     05  WS-CASHIER-BANK-ID               PIC 9(05).              
A02388     05  WS-DISP-ACCT-NO                  PIC 9(13).              
ACT174     05  WS-FIRST-BATCH-NO-REC            PIC X(01) VALUE 'Y'.    
      *                                                                         
ACT174 01  WS-RPT-ACCT-NO                       PIC 9/9999/9999/9999.   
      *                                                                         
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR COUNTER VARIABLES             *        
      ******************************************************************        
       01  WS-COUNTER.                                                  
           05  WS-ENTRY-NO                      PIC 9(9) USAGE COMP     
                                                          VALUE 0.      
           05  WS-BATCH-ENTRY-NO                PIC 9(9) USAGE COMP     
                                                          VALUE 0.      
           05  WS-TOT-TRL-COUNT                 PIC 9(9) USAGE COMP     
                                                          VALUE 0.      
           05  WS-BATCH-AMOUNT                  PIC S9(11)V9(2)         
                                                          VALUE ZEROES. 
C25923     05  WS-BAT-CR-AMOUNT                 PIC S9(11)V9(2)         
C25923                                                    VALUE ZEROES. 
           05  WS-BATCH-TOT-AMOUNT              PIC S9(11)V9(2)         
                                                          VALUE ZEROES. 
C25923     05  WS-RPT-BAT-TOTAL                 PIC S9(11)V9(2)         
C25923                                                    VALUE ZEROES. 
           05  WS-TOT-TRL-AMOUNT                PIC S9(11)V9(2)         
                                                          VALUE ZEROES. 
T22767     05  WS-GRAND-TOTAL-AMT               PIC S9(11)V9(2)         
T22767                                                    VALUE ZEROES. 
           05  WS-LINE-CNTR                     PIC 9(03) VALUE 56.     
ACT174     05  WS-RPT-COUNT-REC                 PIC 9(02) VALUE 0.      
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR FLAG VARIABLES                *        
      ******************************************************************        
       01  WS-FLAGS.                                                    
           05  WS-FCSAC21-EOF-SW                PIC X(01) VALUE 'N'.    
               88  FCSAC21-AT-EOF                         VALUE 'Y'.    
               88  FCSAC21-NOT-AT-EOF                     VALUE 'N'.    
           05  WS-BATCH-CHANGED-SW              PIC X(01) VALUE 'Y'.    
               88 BATCH-CHANGED                           VALUE 'Y'.    
               88 BATCH-NOT-CHANGED                       VALUE 'N'.    
           05  WS-TRL-FLAG                      PIC X(01) VALUE 'N'.    
           05  WS-FAC21-STATUS                  PIC X(02) VALUE '00'.   
               88  FAC21-SUCCESSFUL                       VALUE '00'    
                                                                '04'.   
A02388     05  WS-FAC26-STATUS                  PIC X(02) VALUE '00'.   
A02388         88  FAC26-SUCCESSFUL                       VALUE '00'    
A02388                                                          '04'.   
C25923     05  WS-OVSH-TRANSACTION              PIC X(01) VALUE 'N'.    
C25923         88  OVERSHORT-TRANSACTION                  VALUE 'Y'.    
C25923     05  WS-TPRTY-RECEIVABLE              PIC X(01) VALUE 'N'.    
C25923         88  THIRDPARTY-RECEIVABLE                  VALUE 'Y'.    
C33928     05  WS-DEP-XFER-METHOD               PIC X(01) VALUE 'A'.    
C33928         88 AUTOMATIC-TRANSFER                      VALUE 'A'.    
C33928         88 MANUAL-TRANSFER                         VALUE 'M'.    
                                                                        
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR DATE VARIABLES                *        
      ******************************************************************        
       01  WS-DATE-VARIABLES.                                           
           05  WS-TEMP-DATE.                                            
               10  WS-TEMP-YY                   PIC 9(04).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-TEMP-MM                   PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-TEMP-DD                   PIC 9(02).              
           05  WS-RUN-DATE.                                             
               10 WS-DT-YY                      PIC 9(02).              
               10 WS-DT-MM                      PIC 9(02).              
               10 WS-DT-DD                      PIC 9(02).              
           05  WS-CUR-CCYY.                                             
               10  WS-CUR-CC                    PIC 9(02).              
               10  WS-CUR-YY                    PIC 9(02).              
           05  WS-REPORT-DATE.                                          
               10  WS-REP-MM                    PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '/'.    
               10  WS-REP-DD                    PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '/'.    
T22767*        10  WS-REP-YY                    PIC 9(04).                      
T22767         10  WS-REP-YY                    PIC 9(02).              
           05  WS-BATCH-DATE.                                           
               10  WS-BATCH-MM                  PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-BATCH-DD                  PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-BATCH-YY                  PIC 9(04).              
A02388*                                                                         
A02388     05  WS-RPT-DATE                      PIC 9(10).              
A02388     05  WS-RPT-TIME                      PIC X(08).              
      *                                                                         
T22767******************************************************************        
T22767*  WORKING STORAGE DECLARATION FOR TIME VARIABLES                *        
T22767******************************************************************        
T22767                                                                  
T22767 01  WS-TIME-VARIABLES.                                           
T22767     05  WS-RUN-TIME.                                             
T22767         10 WS-HH                         PIC 9(02).              
T22767         10 WS-MM                         PIC 9(02).              
T22767         10 WS-SS                         PIC 9(02).              
T22767         10 WS-TT                         PIC 9(02).              
T22767     05  WS-REPORT-TIME.                                          
T22767         10  WS-RT-HH                     PIC X(02).              
T22767         10  FILLER                       PIC X(01) VALUE ':'.    
T22767         10  WS-RT-MM                     PIC X(02).              
T22767         10  FILLER                       PIC X(01) VALUE ':'.    
T22767         10  WS-RT-SS                     PIC X(02).              
T22767                                                                  
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR HARCODED VARIABLES            *        
      ******************************************************************        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-COMPANY-NAME                  PIC X(13) VALUE         
                                                    'SCE&G COMPANY'.    
           05  WS-PGRMNAME                      PIC X(08) VALUE         
                                                   'PCSAC171'.          
C33928     05 WS-TRAN-ID                        PIC X(04) VALUE 'AC71'. 
           05 WS-D                              PIC X(01) VALUE 'D'.    
           05 WS-COMPANY-NO                     PIC X(02) VALUE '01'.   
           05 WS-LOCAL-OFFICE                   PIC X(03) VALUE '002'.  
           05 WS-JRNL-SORT-ID                   PIC X(01) VALUE 'A'.    
           05 WS-CUSTOMER-NO                    PIC S9(10)V USAGE COMP-3
                                                VALUE 000000000.        
           05 WS-METER-NO                       PIC X(09)               
                                                VALUE '000000000'.      
           05  WS-Y                             PIC X(01) VALUE 'Y'.    
C33928     05  WS-M                             PIC X(01) VALUE 'M'.    
           05  WS-N                             PIC X(01) VALUE 'N'.    
C33928     05  WS-NO                            PIC X(01) VALUE 'N'.    
C33928     05  WS-YES                           PIC X(01) VALUE 'Y'.    
C25923     05  WS-P                             PIC X(01) VALUE 'P'.    
           05  WS-ZERO                          PIC 9(01) VALUE 0.      
           05  WS-ONE                           PIC 9(01) VALUE 1.      
           05  WS-TWO                           PIC 9(01) VALUE 2.      
           05  WS-THREE                         PIC 9(01) VALUE 3.      
           05  WS-SIX                           PIC 9(01) VALUE 6.      
C33928     05  WS-101                           PIC 9(03) VALUE 101.    
           05  WS-ONES                          PIC X(01) VALUE '1'.    
           05  WS-FIVE                          PIC 9(01) VALUE 5.      
           05  WS-NINE                          PIC 9(01) VALUE 9.      
C25923     05  WS-04                            PIC X(02) VALUE '04'.   
           05  WS-19                            PIC 9(02) VALUE 19.     
           05  WS-20                            PIC 9(02) VALUE 20.     
C28322     05  WS-02                            PIC X(02) VALUE '02'.   
           05  WS-NINES                         PIC 9(13) VALUE         
                                                         9999999999999. 
           05  WS-HUNDRED-ONE                   PIC S9(05) COMP-3       
                                                          VALUE 101.    
           05  WS-FIFTY-FIVE                    PIC 9(03) VALUE 55.     
           05  WS-PAGE-NUM                      PIC 9(04) VALUE ZEROES. 
           05  WS-LINE-SPACE                    PIC 9(02) VALUE ZEROES. 
           05  WS-LINE-DIFF                     PIC 9(03) VALUE ZEROES. 
C25923     05  WS-COMMENT-LEN                   PIC S9(04) COMP         
C25923                                          VALUE +34.              
C25923     05  WS-COMMENT-TEXT                  PIC X(34) VALUE         
C25923             'BATCH OVERAGE POSTED BY THE SYSTEM'.                
C25923     05  WS-AC22                          PIC X(4)  VALUE 'AC22'. 
C25923     05  WS-AC23                          PIC X(4)  VALUE 'AC23'. 
C33928     05  WS-AC24                          PIC X(4)  VALUE 'AC24'. 
C25923     05  WS-SEB                           PIC S9(9)V9(5)          
C25923                                                    VALUE 2.00000.
C25923     05  WS-DATABASE                      PIC X(08) VALUE         
C25923                                                    'DATABASE'.   
C25923     05  WS-001                           PIC X(03) VALUE '001'.  
ACT174     05  WS-TOT-PYMT-AMOUNT               PIC S9(09)V99 VALUE 0.  
ACT174     05  WS-PYMT-DTL-AMOUNT               PIC S9(09)V99 VALUE 0.  
                                                                        
      ******************************************************************        
      *  REPORT STRUCTURES - FOR PIPELINE PAYMENTS                     *        
      *                    - FOR ERROR ACCOUNTS                        *        
      ******************************************************************        
      *                                                                         
ACT174 01  WS-RPT-DTL-HDR.                                              
ACT174     05  WS-RPT-COMPANY-NO-HDR            PIC X(10) VALUE         
ACT174                                             'COMPANY NO'.        
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  WS-RPT-LOCAL-OFFICE-HDR          PIC X(12) VALUE         
ACT174                                             'LOCAL OFFICE'.      
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  WS-RPT-BATCH-NO-HDR              PIC X(08) VALUE         
ACT174                                             'BATCH NO'.          
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  WS-RPT-BATCH-DATE-HDR            PIC X(10) VALUE         
ACT174                                             'BATCH DATE'.        
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  WS-RPT-ACCT-NO-DET-HDR           PIC X(10) VALUE         
ACT174                                             'ACCOUNT NO'.        
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  WS-RPT-REJ-REASON-HDR            PIC X(10) VALUE         
ACT174                                             'REJ REASON'.        
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  WS-RPT-DEBIT-GL-HDR              PIC X(08) VALUE         
ACT174                                             'DEBIT GL'.          
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  WS-RPT-CREDIT-GL-HDR             PIC X(09) VALUE         
ACT174                                             'CREDIT GL'.         
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  WS-RPT-AMOUNT-HDR                PIC X(06) VALUE         
ACT174                                             'AMOUNT'.            
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  WS-RPT-XFER-TOACCT-HDR           PIC X(12) VALUE         
ACT174                                           'XFER TO ACCT'.        
                                                                        
       01  WS-RPT-DTL.                                                  
           05  WS-RPT-COMPANY-NO                PIC X(02).              
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
T22767     05  WS-RPT-LOCAL-OFFICE              PIC X(03).              
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
A02388     05  WS-RPT-BATCH-NO                  PIC 9(04).              
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
A02388     05  WS-RPT-BATCH-DATE                PIC X(10).              
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
           05  WS-RPT-ACCT-NO-DET               PIC X(16).              
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
C25923     05  WS-RPT-REJ-REASON                PIC X(28).              
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
           05  WS-RPT-DEBIT-GL                  PIC 9(03).9(04).        
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
           05  WS-RPT-CREDIT-GL                 PIC 9(03).9(04).        
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
           05  WS-RPT-AMOUNT                    PIC 9(09).99.           
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
A02388     05  WS-RPT-XFER-TOACCT               PIC 9(13).              
                                                                        
ACT174 01  WS-RPT-DTL1.                                                 
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
           05  WS-RPT-TOTAL-PYMT-HDR            PIC X(05) VALUE 'TOTAL'.
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
ACT174     05  WS-RPT-TOTAL-PYMT                PIC 9(09).99.           
ACT174     05  FILLER                           PIC X(01) VALUE ','.    
                                                                        
      *****************************************************************         
      *        DECLARATIONS FOR COPYBOOK  - RETURN STATUS ETC         *         
      *****************************************************************         
                                                                        
       COPY CWS00303.                                                           
      *****************************************************************         
      *        DECLARATIONS FOR COPYBOOK - ABEND VARIABLES            *         
      *****************************************************************         
                                                                        
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *        DECLARATIONS FOR COPYBOOK - TO GET INPUT DATE FJC01    *         
      *****************************************************************         
                                                                        
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
                                                                        
      *****************************************************************         
      *    DECLARATIONS OF THE DCLGENS USED                           *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *****************************************************************         
      *     DECGEN FOR CSS_BATCH_JRNL TABLE                           *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBBTJRNL                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *     DECGEN FOR CSS_BCH_JRNL_CNTL TABLE                        *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBBJCNTL                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *     DECGEN FOR CSS_JOB_PARM TABLE                             *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
C25923*****************************************************************         
C25923* OH - CSS_OVERSHORT_HDR                                        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
             INCLUDE TBOVSHHD                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * OT - CSS_OVERSHORT_TYPE                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
             INCLUDE TBOVSHTY                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
C33928     EXEC SQL                                                             
C33928      INCLUDE CWS00315                                                    
C33928     END-EXEC.                                                            
C33928                                                                  
C33928******************************************************************        
C33928**   CSS_BANK                                                   **        
C33928******************************************************************        
C33928                                                                  
C33928     EXEC SQL                                                             
C33928      INCLUDE TBBANK                                                      
C33928     END-EXEC.                                                            
C33928                                                                  
C33928******************************************************************        
C33928**   CSS_BANK_TRANSFER                                          **        
C33928******************************************************************        
C33928                                                                  
C33928     EXEC SQL                                                             
C33928      INCLUDE TBBNKXFR                                                    
C33928     END-EXEC.                                                            
C33928                                                                  
C33928******************************************************************        
C33928**   CSS_CASHIER                                                **        
C33928******************************************************************        
C33928                                                                  
C33928     EXEC SQL                                                             
C33928      INCLUDE TBCSHIER                                                    
C33928     END-EXEC.                                                            
C33928                                                                  
C33928******************************************************************        
C33928**   CSS_CASHIER_OFFICE                                         **        
C33928******************************************************************        
C33928                                                                  
C33928     EXEC SQL                                                             
C33928      INCLUDE TBCSHOFF                                                    
C33928     END-EXEC.                                                            
C33928                                                                  
C33928******************************************************************        
C33928**   CSS_CSH_DRWR_CNTL                                          **        
C33928******************************************************************        
C33928                                                                  
C33928     EXEC SQL                                                             
C33928      INCLUDE TBCDCNTL                                                    
C33928     END-EXEC.                                                            
C33928                                                                  
C33928******************************************************************        
C33928**   CSS_CSH_DRWR_JRNL                                          **        
C33928******************************************************************        
C33928                                                                  
C33928     EXEC SQL                                                             
C33928      INCLUDE  TBCDJRNL                                                   
C33928     END-EXEC.                                                            
C33928                                                                  
C33928******************************************************************        
C33928*    CSS_HOLIDAY                                                 *        
C33928******************************************************************        
C33928                                                                  
C33928     EXEC SQL                                                             
C33928         INCLUDE TBHLDAY                                                  
C33928     END-EXEC.                                                            
C33928                                                                  
C33928******************************************************************        
C33928*    CSS_CSH_REPORT_HDR                                          *        
C33928******************************************************************        
C33928                                                                  
C33928     EXEC SQL                                                             
C33928         INCLUDE TBCSRPHD                                                 
C33928     END-EXEC.                                                            
A02388*                                                                         
A02388******************************************************************        
A02388*    HST_ACCOUNT                                                 *        
A02388******************************************************************        
A02388                                                                  
A02388     EXEC SQL                                                             
A02388         INCLUDE TBHACCT                                                  
A02388     END-EXEC.                                                            
                                                                        
      **************************************************************            
       PROCEDURE DIVISION.                                              
      **************************************************************            
      *   MAIN PARA - CONTROLS THE PROCESSING                      *            
      **************************************************************            
       0000-MAINLINE.                                                   
                                                                        
            MOVE '0000'               TO WS-ACTIVE-PARAGRAPH.           
                                                                        
            PERFORM     0100-INITIALIZATION                             
               THRU     0100-EXIT.                                      
                                                                        
            PERFORM     1000-PROCESS-NCP                                
               THRU     1000-EXIT                                       
              UNTIL     FCSAC21-AT-EOF.                                 
                                                                        
ACT174      PERFORM     2970-PROCESS-FINAL-REC-COUNT                    
ACT174         THRU     2970-EXIT                                       
                                                                        
            PERFORM     9000-TERMINATE                                  
               THRU     9000-EXIT.                                      
                                                                        
            STOP RUN.                                                   
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      **************************************************************            
      ** 0100-INITIALIZATION ROUTINE                               *            
      **************************************************************            
       0100-INITIALIZATION.                                             
                                                                        
T22767      PERFORM     0200-OPEN-FILES                                 
T22767         THRU     0200-EXIT.                                      
T22767                                                                  
T22767      MOVE '0100'              TO   WS-ACTIVE-PARAGRAPH.          
T22767                                                                  
            ACCEPT WS-PARM-CO-NO     FROM SYSIN.                        
T22767                                                                  
T22767*     IF WS-PARM-CO-NO EQUAL SPACES                                       
T22767      IF WS-PARM-CO-NO EQUAL SPACES OR LOW-VALUES                 
T22767*        MOVE    '** INVALID PARAMETER ***' TO WS-ERR-MSG                 
T22767         STRING '*COMPANY NO CANNOT BE SPACES*'  DELIMITED BY SIZE
T22767                                                 INTO WS-ERR-MSG  
               PERFORM     8900-DISPLAY-ERR-AND-TERMINATE               
                  THRU     8900-EXIT                                    
            END-IF.                                                     
T22767                                                                  
T22767      IF WS-PARM-CO-NO IS NUMERIC                                 
T22767         IF WS-PARM-CO-NO >= '00' AND WS-PARM-CO-NO <='99'        
T22767            CONTINUE                                              
T22767         ELSE                                                     
T22767            STRING '* INVALID COMPANY NUMBER *'  DELIMITED BY SIZE
T22767                                                 INTO WS-ERR-MSG  
T22767            PERFORM     8900-DISPLAY-ERR-AND-TERMINATE            
T22767               THRU     8900-EXIT                                 
T22767         END-IF                                                   
T22767      ELSE                                                        
T22767          STRING '** BILL-AGENT-CO-NO SHOULD BE' DELIMITED BY SIZE
T22767                    ' TWO DIGIT NUMERIC **'      DELIMITED BY SIZE
T22767                                                 INTO WS-ERR-MSG  
T22767          PERFORM     8900-DISPLAY-ERR-AND-TERMINATE              
T22767             THRU     8900-EXIT                                   
T22767      END-IF.                                                     
T22767                                                                  
                                                                        
            PERFORM     0300-SETUP-DATES                                
               THRU     0300-EXIT.                                      
                                                                        
T22767      PERFORM     0400-SETUP-TIME                                 
T22767         THRU     0400-EXIT.                                      
                                                                        
            PERFORM     7100-READ-FCSAC21                               
               THRU     7100-EXIT.                                      
                                                                        
      ***********************************************************               
      **  TO CHECK FOR EMPTY FILE & FORCE ABEND                **               
      ***********************************************************               
                                                                        
            IF FCSAC21-AT-EOF                                           
               MOVE    '**  INPUT FILE EMPTY **' TO WS-ERR-MSG          
               PERFORM     8900-DISPLAY-ERR-AND-TERMINATE               
                  THRU     8900-EXIT                                    
            END-IF.                                                     
                                                                        
      ***********************************************************               
      **  TO CHECK FOR FIRST RECORD IS NOT HDR & FORCE ABEND   **               
      ***********************************************************               
                                                                        
            IF FIOAC21-NCP-REC-TYPE NOT EQUAL    TO LOW-VALUES          
               MOVE    '**FIRST RECORD IS NOT HEADER **' TO WS-ERR-MSG  
               PERFORM     8900-DISPLAY-ERR-AND-TERMINATE               
                  THRU     8900-EXIT                                    
            END-IF.                                                     
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***********************************************************               
      **   0200-OPEN-FILES       *                                              
      ***********************************************************               
       0200-OPEN-FILES.                                                 
                                                                        
            MOVE '0200'              TO   WS-ACTIVE-PARAGRAPH.          
                                                                        
            OPEN INPUT FCSAC21-FILE.                                    
                                                                        
            IF FAC21-SUCCESSFUL                                         
               NEXT SENTENCE                                            
            ELSE                                                        
               STRING '** FILE OPEN ERROR   **' DELIMITED BY SIZE       
                       WS-FAC21-STATUS          DELIMITED BY SIZE       
                                                INTO WS-ERR-MSG         
               PERFORM     8900-DISPLAY-ERR-AND-TERMINATE               
                  THRU     8900-EXIT                                    
            END-IF.                                                     
                                                                        
A02388      OPEN OUTPUT FCSAC26-FILE.                                   
A02388*                                                                         
A02388      IF FAC26-SUCCESSFUL                                         
A02388         NEXT SENTENCE                                            
A02388      ELSE                                                        
A02388         STRING '** OUTPUT FILE OPEN ERROR **' DELIMITED BY SIZE  
A02388                 WS-FAC26-STATUS               DELIMITED BY SIZE  
A02388                                               INTO WS-ERR-MSG    
A02388         PERFORM 8900-DISPLAY-ERR-AND-TERMINATE THRU 8900-EXIT    
A02388      END-IF.                                                     
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **    0300-SETUP-DATES *                                                  
      ************************************************************              
       0300-SETUP-DATES.                                                
                                                                        
            MOVE '0300'                  TO WS-ACTIVE-PARAGRAPH.        
                                                                        
            PERFORM     6251-GET-FJC01-DATE                             
               THRU     6251-EXIT.                                      
                                                                        
            IF COMMON-DATE-NEEDED                                       
               MOVE 'COMMON'             TO WS-PGRMNAME                 
               MOVE SPACES               TO WS-INPUT-AREA               
               MOVE SPACES               TO WS-INPUT-DATA-BREAKDOWN     
                                                                        
               PERFORM     6251-GET-FJC01-DATE                          
                  THRU     6251-EXIT                                    
                                                                        
               MOVE 'PCSAC171'           TO WS-PGRMNAME                 
            END-IF.                                                     
                                                                        
      *    FORMATING DATE FOR REPORT HEADER.                                    
                                                                        
            ACCEPT WS-RUN-DATE               FROM DATE.                 
            IF WS-DT-YY    >   50                                       
               MOVE  WS-19               TO WS-CUR-CC                   
            ELSE                                                        
               MOVE  WS-20               TO WS-CUR-CC                   
            END-IF.                                                     
                                                                        
                                                                        
            MOVE WS-DT-MM                TO WS-REP-MM.                  
            MOVE WS-DT-YY                TO WS-CUR-YY.                  
T22767*     MOVE WS-CUR-CCYY             TO WS-REP-YY.                          
T22767      MOVE WS-CUR-YY               TO WS-REP-YY.                  
            MOVE WS-DT-DD                TO WS-REP-DD.                  
                                                                        
            MOVE WS-REPORT-DATE          TO WS-RPT-DATE.                
                                                                        
       0300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
T22767************************************************************              
T22767**    0400-SETUP-TIME *                                                   
T22767************************************************************              
T22767 0400-SETUP-TIME.                                                 
T22767                                                                  
T22767     MOVE '0400'                 TO WS-ACTIVE-PARAGRAPH.          
T22767                                                                  
T22767*    FORMATING TIME FOR REPORT HEADER.                                    
T22767                                                                  
T22767     ACCEPT WS-RUN-TIME               FROM TIME.                  
T22767                                                                  
T22767     MOVE WS-HH                  TO WS-RT-HH.                     
T22767     MOVE WS-MM                  TO WS-RT-MM.                     
T22767     MOVE WS-SS                  TO WS-RT-SS.                     
T22767     MOVE WS-REPORT-TIME         TO WS-RPT-TIME.                  
T22767                                                                  
T22767 0400-EXIT.                                                       
T22767      EXIT.                                                       
T22767*                                                                         
      ************************************************************              
      ** THIS IS THE MAIN PROCESSING PARA WHICH CONTROLS THE    **              
      ** READ OF THE INPUT FILE & PROCESS THE SAME              **              
      ************************************************************              
       1000-PROCESS-NCP.                                                
                                                                        
            MOVE '1000'                  TO WS-ACTIVE-PARAGRAPH.        
                                                                        
            EVALUATE     FIOAC21-NCP-REC-TYPE                           
                WHEN     LOW-VALUES                                     
                         PERFORM     2000-PROCESS-HEADER                
                            THRU     2000-EXIT                          
                                                                        
                WHEN     SPACES                                         
                         PERFORM     2100-PROCESS-DETAIL                
                            THRU     2100-EXIT                          
                                                                        
                WHEN     HIGH-VALUES                                    
                         PERFORM     2200-PROCESS-TRAILER               
                            THRU     2200-EXIT                          
                                                                        
                WHEN     OTHER                                          
                         MOVE '** INVALID INPUT REC TYPE **'            
                                                           TO WS-ERR-MSG
                         PERFORM     8900-DISPLAY-ERR-AND-TERMINATE     
                            THRU     8900-EXIT                          
                                                                        
            END-EVALUATE.                                               
                                                                        
            PERFORM      7100-READ-FCSAC21                              
               THRU      7100-EXIT.                                     
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ************************************************************              
      ** THIS PARA CONTROLS THE PROCESSING FOR HEADER RECORD    **              
      ************************************************************              
       2000-PROCESS-HEADER.                                             
                                                                        
            MOVE '2000'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            INITIALIZE                        DCLCSS-BCH-JRNL-CNTL,     
                                              DCLCSS-BATCH-JRNL.        
      * FOR THE FIRST TIME ONLY TO INITIALIZE THE COUNTER VARIABLES             
                                                                        
C33928      MOVE FIOAC21-NCP-HDR-LOCAL-OFFICE TO WS-CASHIER-OFFICE      
            IF  WS-PREV-BATCH-NO = SPACES                               
                MOVE  FIOAC21-NCP-HDR-DRWR-ID TO WS-PREV-BATCH-NO       
                                                                        
                INITIALIZE                       WS-ENTRY-NO,           
                                                 WS-BATCH-AMOUNT,       
C25923                                           WS-BAT-CR-AMOUNT,      
                                                 WS-BATCH-ENTRY-NO,     
                                                 WS-BATCH-TOT-AMOUNT,   
C25923                                           WS-RPT-BAT-TOTAL,      
T22767                                           WS-GRAND-TOTAL-AMT     
            END-IF.                                                     
                                                                        
      * WHENEVER BATCH CHANGES TRAILER FLAG IS SET TO NO                        
                                                                        
            IF  WS-PREV-BATCH-NO NOT EQUAL    TO FIOAC21-NCP-HDR-DRWR-ID
                INITIALIZE                       WS-ENTRY-NO,           
                                                 WS-BATCH-AMOUNT,       
C25923                                           WS-BAT-CR-AMOUNT,      
                                                 WS-BATCH-ENTRY-NO,     
                                                 WS-BATCH-TOT-AMOUNT,   
C25923                                           WS-RPT-BAT-TOTAL       
                                                                        
                MOVE FIOAC21-NCP-HDR-DRWR-ID  TO WS-PREV-BATCH-NO       
                MOVE WS-N                     TO WS-TRL-FLAG            
                SET BATCH-CHANGED             TO TRUE                   
            ELSE                                                        
                MOVE WS-Y                     TO WS-TRL-FLAG            
            END-IF.                                                     
                                                                        
            MOVE FIOAC21-NCP-HDR-USER-ID      TO WS-USER-ID.            
                                                                        
C25923      MOVE WS-COMPANY-NO                TO C8-COMPANY-NO          
C25923      MOVE WS-DATABASE                  TO C8-DELINQ-CD           
C25923      PERFORM 7850-SELECT-DATABASE      THRU 7850-EXIT            
C25923      IF C8-DELINQ-VALUE = WS-SEB                                 
C25923         MOVE WS-001                    TO WS-LOCAL-OFFICE        
C25923      END-IF                                                      
                                                                        
            PERFORM     2500-MOVE-HEADER-TO-TABLES-RPT                  
               THRU     2500-EXIT.                                      
                                                                        
            PERFORM     2600-MOVE-DEFAULT-VAL-TO-CNTL                   
               THRU     2600-EXIT.                                      
                                                                        
            PERFORM     7700-GET-CURRENT-TIMESTAMP                      
               THRU     7700-EXIT.                                      
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ************************************************************              
      ** THIS PARA CONTROLS THE PROCESSING FOR DETAIL RECORD    **              
      ************************************************************              
       2100-PROCESS-DETAIL.                                             
                                                                        
            MOVE '2100'                  TO WS-ACTIVE-PARAGRAPH.        
                                                                        
C33928      IF FIOAC21-NCP-DTL-TRAN-ID = WS-AC24                        
C33928         ADD WS-ONE                  TO WS-BATCH-ENTRY-NO         
C33928         ADD FIOAC21-NCP-DTL-PMT-AMT TO WS-BATCH-TOT-AMOUNT       
C33928         PERFORM 2300-WRITE-BANK-XFER                             
C33928            THRU 2300-EXIT                                        
C33928         GO TO 2100-EXIT                                          
C33928      END-IF                                                      
                                                                        
C25923      IF FIOAC21-NCP-DTL-TRAN-ID = WS-AC22                        
C25923         SET OVERSHORT-TRANSACTION TO TRUE                        
C25923      END-IF                                                      
C25923      IF FIOAC21-NCP-DTL-TRAN-ID = WS-AC23                        
C25923         SET THIRDPARTY-RECEIVABLE TO TRUE                        
C25923         MOVE FIOAC21-NCP-DTL-DR-GL   TO WS-TPRTY-GL              
C25923         MOVE FIOAC21-NCP-DTL-PMT-AMT TO WS-TPRTY-TOTAL           
C25923      END-IF                                                      
                                                                        
            PERFORM     2900-MOVE-DETAIL-TO-BCH-JRNL                    
               THRU     2900-EXIT.                                      
                                                                        
C25923      IF  PAYMENT-AGENT-JRNL                                      
C25923          CONTINUE                                                
C25923      ELSE                                                        
A02388          PERFORM 2960-PRINT-REPORT-DETAIL THRU 2960-EXIT         
C25923      END-IF.                                                     
                                                                        
A02388      PERFORM 3000-INSERT-RECS-INTO-TABLES THRU 3000-EXIT.        
                                                                        
       2100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ************************************************************              
      ** THIS PARA CONTROLS THE PROCESSING FOR TRAILER RECORD   **              
      ************************************************************              
       2200-PROCESS-TRAILER.                                            
                                                                        
            MOVE '2200'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
      ************************************************************              
      ** DO A FINAL UPDATE OF THE AMOUNTS & COUNTS INTO THE     **              
      ** CONTROL RECORD FOR RECONCILIATION                      **              
      ************************************************************              
                                                                        
            IF  WS-TRL-FLAG = WS-Y                                      
                ADD FIOAC21-NCP-TRL-BATCH-TOTAL TO WS-TOT-TRL-AMOUNT    
                ADD FIOAC21-NCP-TRL-BATCH-COUNT TO WS-TOT-TRL-COUNT     
            ELSE                                                        
               MOVE FIOAC21-NCP-TRL-BATCH-TOTAL TO WS-TOT-TRL-AMOUNT    
               MOVE FIOAC21-NCP-TRL-BATCH-COUNT TO WS-TOT-TRL-COUNT     
            END-IF.                                                     
                                                                        
      ************************************************************              
      ** PRINT THE REPORT TRAILER MESSAGE BASED ON MATCHED OR   **              
      ** MISMATCHED COUNTS AND TOTALS FOR FUTURE REFERENCE      **              
      ************************************************************              
                                                                        
           IF (WS-BATCH-ENTRY-NO            = WS-TOT-TRL-COUNT) AND     
              (WS-BATCH-TOT-AMOUNT          = WS-TOT-TRL-AMOUNT)        
A02388        CONTINUE                                                  
           ELSE                                                         
A02388        DISPLAY   '**BATCH TOTAL MISMATCH **'                     
              MOVE      WS-NINE                     TO RETURN-CODE      
           END-IF.                                                      
                                                                        
C25923      IF THIRDPARTY-RECEIVABLE                                    
C25923         MOVE WS-TPRTY-GL               TO OH-GL-ACCT-NO          
C25923         MOVE WS-TPRTY-TOTAL            TO OH-OVERSHORT-AMT       
C25923         MOVE WS-D                      TO OH-OVERSHORT-DR-CR     
C25923         PERFORM  2700-MOVE-DETAIL-TO-OVERSHORT                   
C25923            THRU  2700-EXIT                                       
C25923         PERFORM  8700-INSERT-OVERSHORT                           
C25923            THRU  8700-EXIT                                       
C25923         MOVE WS-N                  TO WS-TPRTY-RECEIVABLE        
C25923      END-IF                                                      
C25923*     IF  FIOAC21-NCP-TRL-BATCH-TOTAL NOT EQUAL TO WS-ZERO                
C25923      IF  WS-RPT-BAT-TOTAL NOT EQUAL TO WS-ZERO                   
C25923          IF OVERSHORT-TRANSACTION                                
C25923             MOVE WS-RPT-CREDIT-GL      TO OH-GL-ACCT-NO          
C25923             MOVE WS-RPT-BAT-TOTAL      TO OH-OVERSHORT-AMT       
C25923             MOVE WS-C                  TO OH-OVERSHORT-DR-CR     
C25923             PERFORM  2700-MOVE-DETAIL-TO-OVERSHORT               
C25923                THRU  2700-EXIT                                   
C25923             PERFORM  8700-INSERT-OVERSHORT                       
C25923                THRU  8700-EXIT                                   
C25923             MOVE WS-N                  TO WS-OVSH-TRANSACTION    
C25923          END-IF                                                  
            END-IF.                                                     
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
C33928 2300-WRITE-BANK-XFER.                                            
C33928                                                                  
           MOVE WS-CASHIER-OFFICE        TO Y2-CASH-LOCAL-OFFICE        
           PERFORM 7000-SELECT-CASHIER-OFFICE                           
              THRU 7000-EXIT                                            
                                                                        
           MOVE Y2-USER-ID               TO Y1-USER-ID                  
           PERFORM 7010-SELECT-CASHIER-CODE                             
              THRU 7010-EXIT                                            
                                                                        
           MOVE Y2-DEP-DEFT-BANK-ID      TO D1-BANK-ID                  
           PERFORM 7015-SELECT-BANK-ST-CD                               
              THRU 7015-EXIT                                            
                                                                        
           MOVE Y2-BATCH-DEP-CASH-OFF TO YR-CASH-LOCAL-OFFICE           
           MOVE WS-TEMP-DATE          TO YR-DATE-CASH-REPORT            
           MOVE Y2-USER-ID            TO YR-USER-ID                     
           PERFORM 7020-SELECT-CASH-REPORT                              
              THRU 7020-EXIT                                            
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8010-CREATE-CASH-REPORT                           
                 THRU 8010-EXIT                                         
           END-IF                                                       
                                                                        
           IF AUTOMATIC-TRANSFER                                        
              MOVE WS-PREV-BATCH-NO        TO CS-CASH-DRAWER-ID         
              MOVE WS-C                    TO CS-CODE-CSH-DRWR-STAT     
                                                                        
              PERFORM 2310-SET-CASH-DRWR-CNTL-VALUES                    
                 THRU 2310-EXIT                                         
                                                                        
              PERFORM 8020-CREATE-CASH-DRWR-CNTL                        
                 THRU 8020-EXIT                                         
                                                                        
              PERFORM 2320-SET-CASH-DRWR-JRNL-VALUES                    
                 THRU 2320-EXIT                                         
                                                                        
              PERFORM 8030-CREATE-CASH-DRWR-JRNL                        
                 THRU 8030-EXIT                                         
                                                                        
              PERFORM 2330-SET-BNK-XFR-VALUES                           
                 THRU 2330-EXIT                                         
                                                                        
              PERFORM 8040-CREATE-BANK-TRANSFER                         
                 THRU 8040-EXIT                                         
           ELSE                                                         
              MOVE WS-COMPANY-NO            TO CS-CASH-COMPANY-NO       
              MOVE Y2-BATCH-DEP-CASH-OFF    TO CS-CASH-LOCAL-OFFICE     
              MOVE WS-A                     TO CS-CODE-CSH-DRWR-STAT    
              MOVE WS-TEMP-DATE             TO CS-DATE-CASH-REPORT      
              PERFORM 7030-SELECT-CASH-DRWR-CNTL                        
                 THRU 7030-EXIT                                         
                                                                        
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-COMPANY-NO         TO CS-CASH-COMPANY-NO       
                 MOVE Y2-BATCH-DEP-CASH-OFF TO CS-CASH-LOCAL-OFFICE     
                 MOVE WS-C                  TO CS-CODE-CSH-DRWR-STAT    
                 MOVE WS-TEMP-DATE          TO CS-DATE-CASH-REPORT      
                                                                        
                 PERFORM 7040-GET-MAX-CNTL-DRWR                         
                    THRU 7040-EXIT                                      
                                                                        
                 MOVE WS-A                  TO CS-CODE-CSH-DRWR-STAT    
                 ADD  WS-ONE                TO CS-CASH-DRAWER-ID        
                                                                        
                 PERFORM 2310-SET-CASH-DRWR-CNTL-VALUES                 
                    THRU 2310-EXIT                                      
                 PERFORM 8020-CREATE-CASH-DRWR-CNTL                     
                    THRU 8020-EXIT                                      
              ELSE                                                      
                 ADD WS-ONE                  TO CS-NO-ITEMS-ENTERED     
                 ADD FIOAC21-NCP-DTL-PMT-AMT TO CS-AMT-CASH-DEBIT       
                                                CS-AMT-CASH-CREDIT      
                 MOVE Y2-USER-ID             TO CS-USER-ID              
                 MOVE Y1-CASHIER-CODE        TO CS-CASHIER-CODE         
                 MOVE WS-TEMP-DATE           TO CS-DATE-LAST-ACTIVITY   
                 PERFORM 8050-UPDATE-CASH-DRWR-CNTL                     
                    THRU 8050-EXIT                                      
              END-IF                                                    
                                                                        
              PERFORM 2320-SET-CASH-DRWR-JRNL-VALUES                    
                 THRU 2320-EXIT                                         
                                                                        
              PERFORM 8030-CREATE-CASH-DRWR-JRNL                        
                 THRU 8030-EXIT                                         
           END-IF                                                       
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2310-SET-CASH-DRWR-CNTL-VALUES                              **        
      **                                                              **        
      **                                                              **        
      ******************************************************************        
       2310-SET-CASH-DRWR-CNTL-VALUES.                                  
      *-------------------------------*                                         
           MOVE '2310'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-COMPANY-NO            TO CS-CASH-COMPANY-NO          
           MOVE Y2-BATCH-DEP-CASH-OFF    TO CS-CASH-LOCAL-OFFICE        
                                            CS-CASH-REPORT-NO           
           MOVE Y2-USER-ID               TO CS-USER-ID                  
           MOVE WS-ZERO                  TO CS-AMT-CASH-DEBIT           
                                            CS-AMT-CASH-CREDIT          
                                            CS-AMT-AR-DEBIT             
                                            CS-AMT-AR-CREDIT            
                                            CS-AMT-CK-ISS-DEBIT         
                                            CS-AMT-CK-ISS-CREDIT        
                                            CS-AMT-GL-DEBIT             
                                            CS-AMT-GL-CREDIT            
                                            CS-AMT-CASH-BEGIN-BAL       
                                            CS-AMT-BASIC-WORK           
                                                                        
           MOVE WS-TEMP-DATE             TO CS-DATE-CASH-REPORT         
           MOVE FIOAC21-NCP-DTL-PMT-AMT  TO CS-AMT-CASH-DEBIT           
                                            CS-AMT-CASH-CREDIT          
           MOVE WS-M                     TO CS-CODE-PYMT-FACILITY       
           MOVE WS-ONE                   TO CS-NO-ITEMS-ENTERED         
           MOVE WS-TEMP-DATE             TO CS-DATE-LAST-ACTIVITY       
           MOVE Y1-CASHIER-CODE          TO CS-CASHIER-CODE             
           MOVE SPACES                   TO CS-CODE-FCS-EXTRACTED       
                                                                        
           IF AUTOMATIC-TRANSFER                                        
              MOVE WS-XFR-TS             TO CS-BALANCED-TS              
              MOVE WS-ZERO               TO WS-CNTL-TS-NI               
              MOVE Y2-USER-ID            TO CS-BALANCED-BY              
           ELSE                                                         
              MOVE SPACES                TO CS-BALANCED-BY              
              MOVE -1                    TO WS-CNTL-TS-NI               
           END-IF                                                       
           .                                                            
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2320-SET-CASH-DRWR-JRNL-VALUES                              **        
      ******************************************************************        
       2320-SET-CASH-DRWR-JRNL-VALUES.                                  
      *------------------------------*                                          
           MOVE '2320'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE CS-CASH-COMPANY-NO       TO CJ-CASH-COMPANY-NO          
                                            CJ-COMPANY-NO               
           MOVE CS-CASH-LOCAL-OFFICE     TO CJ-CASH-LOCAL-OFFICE        
                                            CJ-CASH-REPORT-NO           
           MOVE WS-ONE                   TO CJ-TRAN-APPL-NO             
           MOVE CS-NO-ITEMS-ENTERED      TO CJ-ENTRY-NO                 
           MOVE CS-CASH-DRAWER-ID        TO CJ-CASH-DRAWER-ID           
           MOVE Y2-LOCAL-OFFICE          TO CJ-LOCAL-OFFICE             
                                            CJ-ENTRY-LOC                
           MOVE WS-A                     TO CJ-JRNL-SORT-ID             
           MOVE WS-NINES                 TO CJ-ACCOUNT-NO               
           MOVE WS-ZERO                  TO CJ-GL-ACCT-NO               
           MOVE WS-ZERO                  TO CJ-METER-NO                 
           MOVE WS-ZERO                  TO CJ-TRAN-COMMENT-LEN         
           MOVE SPACES                   TO CJ-TRAN-COMMENT-TEXT        
           MOVE WS-TRAN-TIME             TO CJ-TRAN-TIME                
           MOVE WS-TRAN-ID               TO CJ-TRAN-ID                  
           MOVE CS-DATE-CASH-REPORT      TO CJ-DATE-CASH-REPORT         
           MOVE WS-TEMP-DATE             TO CJ-DATE-TRAN                
           MOVE WS-TEMP-DATE             TO CJ-DATE-LAST-ACTION         
           MOVE WS-A                     TO CJ-CODE-ENTRY-SOURCE        
           MOVE CS-USER-ID               TO CJ-USER-ID                  
           MOVE SPACES                   TO CJ-BATCH-SEND-LOC           
           MOVE SPACES                   TO CJ-ENTRY-LOC                
           MOVE SPACES                   TO CJ-CODE-TRAN-ERRORS         
           MOVE SPACES                   TO CJ-CODE-JRNL-EXTRACT        
           MOVE SPACES                   TO CJ-CODE-STATUS              
           MOVE WS-C                     TO CJ-CURRENCY-TYPE            
           MOVE CS-CODE-PYMT-FACILITY    TO CJ-CODE-PYMT-FACILITY       
           MOVE SPACES                   TO CJ-CSR-PC-ID                
           MOVE WS-ZERO                  TO CJ-CUSTOMER-NO              
           MOVE SPACES                   TO CJ-BALANCED-BY              
           MOVE -1                       TO WS-CJ-DATE-NI               
                                            WS-CJ-TIME-NI               
                                                                        
           IF  AUTOMATIC-TRANSFER                                       
               MOVE WS-TEMP-DATE         TO CJ-DATE-BALANCED            
               MOVE WS-TRAN-TIME         TO CJ-TIME-BALANCED            
               MOVE WS-ZERO              TO WS-CJ-DATE-NI               
                                            WS-CJ-TIME-NI               
               MOVE Y2-USER-ID           TO CJ-BALANCED-BY              
           END-IF                                                       
                                                                        
           MOVE SPACES                   TO CJF00101                    
           MOVE WS-101                   TO WS-101-JRNL-FORMAT-NO       
           MOVE WS-ONE                   TO WS-101-CASH-DRAWER-USED     
           MOVE FIOAC21-NCP-DTL-PMT-AMT  TO WS-101-AMOUNT-ENTERED       
                                            WS-101-AMT-POSTED           
           MOVE FIOAC21-NCP-DTL-DR-GL    TO WS-101-ACCT-GEN-LED-DR      
           MOVE FIOAC21-NCP-DTL-CR-GL    TO WS-101-ACCT-GEN-LED-CR      
                                                                        
           MOVE ZEROES                   TO WS-101-ITEM-ID-NO           
                                            WS-101-DETAIL-END-AR-BAL    
                                            WS-101-ACCT-END-AR-BAL      
                                            WS-101-REVENUE-MONTH        
                                                                        
           MOVE Y2-DEP-DEFT-BANK-ID      TO WS-CASHIER-BANK-ID          
           MOVE WS-CASHIER-BANK-ID       TO WS-101-FCS-DEP-BANK-CD      
           MOVE D1-FCS-DEP-BANK-ST-CD    TO WS-101-FCS-DEP-BANK-ST-CD   
           MOVE CJF00101                 TO CJ-TRAN-DATA                
           .                                                            
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2330-SET-BNK-XFR-VALUES                                     **        
      **                                                              **        
      ******************************************************************        
       2330-SET-BNK-XFR-VALUES.                                         
      *----------------------*                                                  
           MOVE '2330'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-COMPANY-NO            TO YB-CASH-COMPANY-NO          
           MOVE Y2-BATCH-DEP-CASH-OFF    TO YB-CASH-LOCAL-OFFICE        
           MOVE CS-CASH-DRAWER-ID        TO YB-CASH-DRAWER-ID           
           MOVE CS-DATE-CASH-REPORT      TO YB-DATE-CASH-REPORT         
           MOVE Y2-USER-ID               TO YB-USER-ID                  
           MOVE Y2-DEP-DEFT-BANK-ID      TO YB-BANK-ID                  
           MOVE FIOAC21-NCP-DTL-PMT-AMT  TO YB-TRANSFER-AMT             
           MOVE WS-TEMP-DATE             TO WS-NEW-BUSINESS-DAY         
                                                                        
           PERFORM Y2-PYMT-TO-POST-DAYS TIMES                           
              MOVE WS-N                  TO WS-NEXT-BUSINESS-DAY        
              MOVE WS-Y                  TO WS-HOLIDAY-EXISTS           
              PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
                 THRU 6500-NEXT-BUSINESS-DAY-EXIT                       
                UNTIL NEXT-BUSINESS-DAY-FOUND                           
           END-PERFORM                                                  
                                                                        
           MOVE WS-NEW-BUSINESS-DAY      TO YB-BANK-POST-DT             
                                                                        
           MOVE WS-XFR-TS                TO YB-TRANSFER-TS              
           MOVE WS-C                     TO YB-CURRENCY-TYPE            
           MOVE WS-D                     TO YB-CODE-DR-CR               
           .                                                            
C33928 2330-EXIT.                                                       
C33928     EXIT.                                                        
                                                                        
      *                                                                         
      ************************************************************              
      ** TO MOVE RESPECTIVE VALUES TO BILL-AGNT,BCH_CNTL,REPORT **              
      **                                                        **              
      ************************************************************              
       2500-MOVE-HEADER-TO-TABLES-RPT.                                  
                                                                        
            MOVE '2500'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            MOVE FIOAC21-NCP-HDR-CO           TO BC-CASH-COMPANY-NO,    
                                                 WS-RPT-COMPANY-NO.     
            MOVE FIOAC21-NCP-HDR-DRWR-ID      TO BC-CASH-DRAWER-ID,     
                                                 BC-BATCH-NO,           
                                                 BC-LOCAL-OFFICE-SEND,  
                                                 WS-RPT-BATCH-NO.       
                                                                        
            MOVE FIOAC21-NCP-HDR-LOCAL-OFFICE TO BC-CASH-LOCAL-OFFICE,  
                                                 BC-CASH-REPORT-NO,     
                                                 WS-RPT-LOCAL-OFFICE.   
                                                                        
      *     DATE FORMATTING FOR DATE CASH **                                    
                                                                        
            MOVE FIOAC21-NCP-DRWR-MM          TO WS-TEMP-MM,            
                                                 WS-BATCH-MM.           
            MOVE FIOAC21-NCP-DRWR-DD          TO WS-TEMP-DD,            
                                                 WS-BATCH-DD.           
            MOVE FIOAC21-NCP-DRWR-CCYY        TO WS-TEMP-YY,            
                                                 WS-BATCH-YY.           
            MOVE WS-TEMP-DATE                 TO BC-DATE-CASH-REPORT.   
            MOVE WS-BATCH-DATE                TO WS-RPT-BATCH-DATE.     
                                                                        
      *     DATE FORMATTING FOR FILE DATE **                                    
                                                                        
            MOVE FIOAC21-NCP-HDR-CRE-MM       TO WS-TEMP-MM.            
            MOVE FIOAC21-NCP-HDR-CRE-DD       TO WS-TEMP-DD.            
            MOVE FIOAC21-NCP-HDR-CRE-CCYY     TO WS-TEMP-YY.            
                                                                        
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *     MOVE DEFAULT VALUES TO OTHER BCH-CNTL FIELDS              **        
      *     CODE STATUS IS SET TO  AUTOMATIC (A)                      **        
      *     ITEMS ENTERED AND POSTED ARE INCREMENTED BY ONE           **        
      *     LOCAL OFFICE ENTRY IS SET TO 002 ALWAYS                   **        
      *     LAST ACT DATE & BATCH ENTERED DATE IS SET TO CURRENT DATE **        
      *     ON WHICH REPORT IS RUN                                    **        
      ******************************************************************        
       2600-MOVE-DEFAULT-VAL-TO-CNTL.                                   
                                                                        
            MOVE '2600'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            MOVE WS-A                         TO BC-CODE-BATCH-STATUS.  
            MOVE WS-LOCAL-OFFICE              TO BC-LOCAL-OFFICE-ENTRY. 
            MOVE WS-INPUT-DATE                TO BC-DATE-LAST-ACTIVITY, 
                                                 BC-DATE-BATCH-ENTERED. 
                                                                        
       2600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
C25923 2700-MOVE-DETAIL-TO-OVERSHORT.                                   
           MOVE BC-CASH-COMPANY-NO            TO OH-CASH-COMPANY-NO     
           MOVE BC-CASH-LOCAL-OFFICE          TO OH-CASH-LOCAL-OFFICE   
           MOVE BC-DATE-CASH-REPORT           TO OH-DATE-CASH-REPORT    
           MOVE BC-CASH-DRAWER-ID             TO OH-CASH-DRAWER-ID      
                                                 WS-CASH-DRAWER-ID      
           MOVE BJ-USER-ID                    TO OH-USER-ID             
           MOVE WS-COMMENT-LEN                TO OH-TRAN-COMMENT-LEN    
           MOVE WS-COMMENT-TEXT               TO OH-TRAN-COMMENT-TEXT   
           MOVE WS-P                          TO OH-OVERSHORT-SOLTN-FL  
           MOVE OH-GL-ACCT-NO                 TO OT-GL-ACCT-NO          
                                                 WS-DISP-GL-ACCT        
A02388     PERFORM 7400-GET-OVSH-TYPE         THRU 7400-EXIT            
           MOVE OT-OVERSHORT-TYPE-CD          TO OH-OVERSHORT-TYPE-CD   
           MOVE ZERO                          TO OH-OVERSHORT-ID        
           PERFORM 7950-GET-OVSH-ID           THRU 7950-EXIT            
           ADD  1                             TO OH-OVERSHORT-ID        
           MOVE ZERO                          TO OH-OFST-OVERSHORT-AMT  
                                                 OH-ACCOUNT-NO          
           MOVE SPACES                        TO OH-OFST-DR-CR          
           .                                                            
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      ** TO MOVE RESPECTIVE VALUES OF DTL TO BCH JRNL VARIABLES **              
      ************************************************************              
       2900-MOVE-DETAIL-TO-BCH-JRNL.                                    
                                                                        
            MOVE '2900'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            MOVE  BC-CASH-COMPANY-NO          TO BJ-CASH-COMPANY-NO.    
            MOVE  BC-CASH-DRAWER-ID           TO BJ-CASH-DRAWER-ID,     
                                                 BJ-BATCH-NO.           
            MOVE  BC-CASH-LOCAL-OFFICE        TO BJ-CASH-LOCAL-OFFICE,  
                                                 BJ-BATCH-SEND-LOC,     
                                                 BJ-ENTRY-LOC.          
            MOVE  BC-CASH-REPORT-NO           TO BJ-CASH-REPORT-NO.     
            MOVE  BC-DATE-CASH-REPORT         TO BJ-DATE-CASH-REPORT.   
            MOVE  WS-USER-ID                  TO BJ-USER-ID.            
            MOVE  FIOAC21-NCP-DTL-ACCT-NUMERIC TO BJ-ACCOUNT-NO.        
            MOVE  WS-HUNDRED-ONE              TO WS-101-JRNL-FORMAT-NO. 
T22767*     MOVE  WS-ONES                    TO WS-101-CASH-DRAWER-USED.        
T22767      MOVE  SPACES                     TO WS-101-CASH-DRAWER-USED.
            MOVE  FIOAC21-NCP-DTL-PMT-AMT     TO WS-101-AMOUNT-ENTERED, 
                                                 WS-101-AMT-POSTED.     
            MOVE  FIOAC21-NCP-DTL-DR-GL       TO WS-101-ACCT-GEN-LED-DR.
            MOVE  FIOAC21-NCP-DTL-CR-GL       TO WS-101-ACCT-GEN-LED-CR.
            MOVE  FIOAC21-NCP-DTL-TRAN-ID     TO BJ-TRAN-ID.            
                                                                        
      ******************************************************************        
      *     MOVE DEFAULT VALUES TO OTHER BCH-JRNL FIELDS              **        
      *     TRAN-APPL-NO = 1,  DATE TRAN AND DATE LAST ACTION ARE     **        
      *     SET TO CURRENT DATE ON WHICH REPORT IS RUN                **        
      *     GET CURRENT TIMESTAMP FOR TRAN TIME, ENTRY-SOURCE = B     **        
      *     METER NUMBER = 0, WS-COMPANY-NO IS '01'                   **        
      ******************************************************************        
                                                                        
            MOVE WS-COMPANY-NO                TO BJ-COMPANY-NO.         
            MOVE WS-ONE                       TO BJ-TRAN-APPL-NO.       
            MOVE WS-LOCAL-OFFICE              TO BJ-LOCAL-OFFICE.       
            MOVE WS-TRAN-TIME                 TO BJ-TRAN-TIME           
            MOVE WS-INPUT-DATE                TO BJ-DATE-TRAN,          
                                                 BJ-DATE-LAST-ACTION.   
            MOVE WS-A                         TO BJ-CODE-STATUS.        
            MOVE WS-B                         TO BJ-CODE-ENTRY-SOURCE.  
T22767*     MOVE WS-ONE                       TO BJ-JRNL-SORT-ID.               
            MOVE WS-A                         TO BJ-JRNL-SORT-ID.       
            MOVE WS-ZERO                      TO BJ-GL-ACCT-NO,         
                                                 BJ-METER-NO,           
                                                 BJ-CUSTOMER-NO.        
            MOVE SPACES                       TO BJ-CODE-TRAN-ERRORS,   
                                                 BJ-CODE-JRNL-EXTRACT,  
                                                 BJ-BALANCED-BY,        
                                                 BJ-CURRENCY-TYPE.      
            MOVE CJF00101                     TO BJ-TRAN-DATA.          
                                                                        
                                                                        
       2900-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  2960-PRINT-REPORT-DETAIL*                                              
      ******************************************************************        
       2960-PRINT-REPORT-DETAIL.                                        
                                                                        
            MOVE '2960'                       TO WS-ACTIVE-PARAGRAPH.   
A02388      INITIALIZE HA-ACCOUNT-NO, HA-ACCT-XFER-TO.                  
                                                                        
            MOVE FIOAC21-NCP-DTL-CR-GL        TO WS-RPT-CREDIT-GL.      
            MOVE FIOAC21-NCP-DTL-DR-GL        TO WS-RPT-DEBIT-GL.       
            MOVE FIOAC21-NCP-DTL-PMT-AMT      TO WS-RPT-AMOUNT.         
ACT174      MOVE FIOAC21-NCP-DTL-ACCT-NUMERIC TO HA-ACCOUNT-NO.         
A02388                                                                  
                                                                        
A02388      MOVE ZERO                         TO WS-RPT-XFER-TOACCT.    
C25923      MOVE SPACES                       TO WS-RPT-REJ-REASON      
C25923      EVALUATE TRUE                                               
C25923          WHEN ACCOUNT-NOT-FOUND                                  
C25923             MOVE 'ACCOUNT NOT FOUND  ' TO WS-RPT-REJ-REASON      
C25923          WHEN ACCOUNT-NOT-NUMERIC                                
C25923             MOVE 'ACCOUNT NOT NUMERIC' TO WS-RPT-REJ-REASON      
C25923          WHEN ACCOUNT-IS-INACTIVE                                
C25923             MOVE 'ACCOUNT INACTIVE   ' TO WS-RPT-REJ-REASON      
C25923          WHEN AMOUNT-NOT-NUMERIC                                 
C25923             MOVE 'AMOUNT NOT NUMERIC ' TO WS-RPT-REJ-REASON      
C25923          WHEN AMOUNT-EQUALS-ZEROS                                
C25923             MOVE 'AMOUNT IS ZERO     ' TO WS-RPT-REJ-REASON      
C25923          WHEN MULTIPLE-OLD-ACCOUNTS                              
C25923             MOVE 'MULTIPLE OLD ACCTS ' TO WS-RPT-REJ-REASON      
C25923          WHEN CUSTOMER-ROW-NOT-FOUND                             
C25923             MOVE 'CUST ROW NOT FOUND ' TO WS-RPT-REJ-REASON      
T29889*         DO NOT VALIDATE IF THE ACCOUNT HAS A DFA                        
C25923*         WHEN DFA-ACCOUNT                                                
C25923*            MOVE 'ACCOUNT IS ON DFA  ' TO WS-RPT-REJ-REASON              
C25923          WHEN GAS-PIPELINE-ACCOUNT                               
C25923             MOVE 'GAS PIPELINE ACCT  ' TO WS-RPT-REJ-REASON      
C25923          WHEN APS-DIRECTED-PYMT                                  
C25923             MOVE 'APS DIRECTED PYMT  ' TO WS-RPT-REJ-REASON      
C28322          WHEN COBB-XFERED-ACCT                                   
C28322             MOVE 'COBB XFERED ACCT   ' TO WS-RPT-REJ-REASON      
C28322          WHEN COBB-XFERED-NOT-FOUND                              
C28322             MOVE 'COBB XFERED ACCT NOT FOUND'                    
C28322                                        TO WS-RPT-REJ-REASON      
A02388          WHEN ACCOUNT-IS-ARCHIVED                                
A02388             MOVE 'ACCOUNT IS ARCHIVED' TO WS-RPT-REJ-REASON      
A02388             PERFORM 7960-SELECT-HST-ACCOUNT  THRU 7960-EXIT      
A02388             IF HA-ACCT-XFER-TO > ZERO                            
A02388                MOVE HA-ACCT-XFER-TO    TO WS-RPT-XFER-TOACCT     
A02388             END-IF                                               
C25923      END-EVALUATE                                                
                                                                        
ACT174     IF WS-FIRST-HDR = 'Y'                                        
ACT174        MOVE  WS-RPT-DTL-HDR       TO FAC26-OUTREC                
ACT174        PERFORM 2985-WRITE-RECORD       THRU 2985-EXIT            
ACT174        MOVE 'N'                   TO WS-FIRST-HDR                
ACT174     END-IF.                                                      
                                                                        
                                                                        
ACT174     MOVE FIOAC21-NCP-DTL-ACCT-NUMERIC                            
ACT174                                   TO WS-RPT-ACCT-NO.             
ACT174     INSPECT WS-RPT-ACCT-NO REPLACING ALL '/' BY '-'.             
ACT174     MOVE WS-RPT-ACCT-NO           TO WS-RPT-ACCT-NO-DET.         
ACT174                                                                  
ACT174     IF WS-FIRST-BATCH-NO-REC = 'Y'                               
ACT174        MOVE WS-RPT-BATCH-NO       TO WS-PREV-BATCH-NO1           
ACT174        MOVE 'N'                   TO WS-FIRST-BATCH-NO-REC       
ACT174     END-IF.                                                      
ACT174                                                                  
ACT174     IF WS-RPT-BATCH-NO NOT EQUAL WS-PREV-BATCH-NO1               
ACT174        MOVE WS-TOT-PYMT-AMOUNT    TO WS-RPT-TOTAL-PYMT           
ACT174        MOVE  WS-RPT-DTL1          TO FAC26-OUTREC                
ACT174        PERFORM 2985-WRITE-RECORD       THRU 2985-EXIT            
ACT174        MOVE WS-RPT-BATCH-NO       TO WS-PREV-BATCH-NO1           
ACT174        INITIALIZE                    WS-TOT-PYMT-AMOUNT          
ACT174     END-IF.                                                      
ACT174                                                                  
ACT174     MOVE FIOAC21-NCP-DTL-PMT-AMT                                 
ACT174                                   TO WS-PYMT-DTL-AMOUNT          
ACT174     COMPUTE WS-TOT-PYMT-AMOUNT = WS-TOT-PYMT-AMOUNT +            
ACT174                                  WS-PYMT-DTL-AMOUNT              
                                                                        
A02388     MOVE  WS-RPT-DTL                   TO FAC26-OUTREC.          
A02388     PERFORM 2985-WRITE-RECORD          THRU 2985-EXIT.           
                                                                        
                                                                        
       2960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT174****************************************************************          
ACT174** 2970-PROCESS-FINAL-REC-COUNT                                *          
ACT174****************************************************************          
ACT174*                                                                         
ACT174 2970-PROCESS-FINAL-REC-COUNT.                                    
ACT174*                                                                         
ACT174     IF WS-RPT-COUNT-REC > ZERO                                   
ACT174                                                                  
ACT174        MOVE WS-TOT-PYMT-AMOUNT      TO WS-RPT-TOTAL-PYMT         
ACT174        MOVE  WS-RPT-DTL1            TO FAC26-OUTREC              
ACT174        PERFORM 2985-WRITE-RECORD        THRU 2985-EXIT           
ACT174                                                                  
ACT174     END-IF.                                                      
ACT174*                                                                         
ACT174 2970-EXIT.                                                       
ACT174     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 2985-WRITE-RECORD                                           *          
      ****************************************************************          
       2985-WRITE-RECORD.                                               
                                                                        
            MOVE '2985'                       TO WS-ACTIVE-PARAGRAPH.   
A02388      WRITE FAC26-OUTREC.                                         
ACT174      COMPUTE WS-RPT-COUNT-REC = WS-RPT-COUNT-REC + 1.            
                                                                        
       2985-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      **************************************************************            
      *** INSERT ALL THE VALUES INTO DIFFERENT TABLES       ********            
      *** CSS_BCH_JRNL_CNTL                                 ********            
      *** BILL-AGNT-PYMT AND THE BCH-JRNL TABLES            ********            
      *** FOR REFERENTIAL INTEGRITY, A CONTROL RECORD NEEDS ********            
      *** TO BE INSERTED IN BATCH-CONTROL TABLE IF NEED BE  ********            
      **************************************************************            
       3000-INSERT-RECS-INTO-TABLES.                                    
                                                                        
            MOVE '3000'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
      *  TO CHECK WHETHER THE BATCH ALREADY EXISTS                              
                                                                        
            PERFORM     7800-SELECT-BCH-JRNL-CNTL                       
               THRU     7800-EXIT.                                      
                                                                        
            IF    WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  PERFORM     8400-CREATE-BCH-JRNL-CNTL                 
                     THRU     8400-EXIT                                 
            END-IF.                                                     
                                                                        
      *  TO UPDATE THE BATCH IF IT ALREADY EXISTS                               
                                                                        
            MOVE BC-NO-ITEMS-ENTERED     TO WS-ENTRY-NO.                
            MOVE BC-AMT-CASH-DEBIT       TO WS-BATCH-AMOUNT.            
C25923      MOVE BC-AMT-CASH-CREDIT      TO WS-BAT-CR-AMOUNT.           
                                                                        
                                                                        
            ADD  WS-ONE                  TO WS-ENTRY-NO,                
                                            WS-BATCH-ENTRY-NO.          
C25923*     ADD  FIOAC21-NCP-DTL-PMT-AMT TO WS-BATCH-AMOUNT,                    
C25923*                                     WS-BATCH-TOT-AMOUNT.                
                                                                        
C25923      ADD  FIOAC21-NCP-DTL-PMT-AMT TO WS-BATCH-TOT-AMOUNT.        
                                                                        
C25923      IF  PAYMENT-AGENT-JRNL                                      
C25923          ADD  FIOAC21-NCP-DTL-PMT-AMT                            
C25923                                   TO WS-BAT-CR-AMOUNT            
C25923      ELSE                                                        
C25923          ADD FIOAC21-NCP-DTL-PMT-AMT                             
C25923                                   TO WS-GRAND-TOTAL-AMT          
C25923                                      WS-RPT-BAT-TOTAL            
C25923                                      WS-BATCH-AMOUNT             
C25923      END-IF                                                      
                                                                        
            MOVE WS-ENTRY-NO             TO BJ-ENTRY-NO.                
                                                                        
            PERFORM     8500-CREATE-CSS-BATCH-JRNL                      
               THRU     8500-EXIT.                                      
                                                                        
      ******************************************************************        
      *  THE  FIELDS INSERTED INTO THIS TABLE ARE COMPANY-NO,          *        
      *  CASH LOCAL OFFICE,DATE CASH REPORT,CASH DRAWER ID. THE        *        
      *  VALUES ARE MOVED TO THIS FIELDS FROM THE INPUT FILE.          *        
      ******************************************************************        
                                                                        
            MOVE WS-ENTRY-NO                  TO BC-NO-ITEMS-ENTERED,   
                                                 BC-NO-ITEMS-POSTED.    
C25923      MOVE WS-BAT-CR-AMOUNT             TO BC-AMT-CASH-CREDIT     
C25923                                           BC-AMT-GL-DEBIT        
            MOVE WS-BATCH-AMOUNT              TO BC-AMT-CASH-DEBIT      
      *                                          BC-AMT-CASH-CREDIT             
                                                 BC-AMT-GL-CREDIT       
                                                                        
            PERFORM     8600-UPDATE-BCH-JRNL-CNTL                       
               THRU     8600-EXIT.                                      
                                                                        
       3000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *     PARA TO GET DATE FROM JOB PARM TABLE                       *        
      ******************************************************************        
                                                                        
            EXEC SQL                                                            
                 INCLUDE CPD00037                                               
            END-EXEC.                                                           
                                                                        
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
                                                                        
C33928******************************************************************        
C33928**   6500-GET-NEXT-BUSINESS-DAY                                 **        
      **   COPYBOOK CPD00315 CONTAINS THE LOGIC FOR FINDING           **        
      **   THE NEXT BUSINESS DAY.                                     **        
      ******************************************************************        
            EXEC SQL                                                            
                INCLUDE CPD00315                                                
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      **  7000-SELECT-CASHIER-OFFICE                                  **        
      **                                                              **        
      ******************************************************************        
       7000-SELECT-CASHIER-OFFICE.                                      
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT BATCH_DEP_CASH_OFF                                  
                   ,DEP_XFER_METHOD                                     
                   ,USER_ID                                             
                   ,DEP_DEFT_BANK_ID                                    
                   ,LOCAL_OFFICE                                        
                   ,DEP_CASH_GL_OFFSET                                  
                   ,PAYMENT_AGENT_FL                                    
                   ,PYMT_TO_POST_DAYS                                   
                   ,ERROR_GL_OFFSET                                     
               INTO :Y2-BATCH-DEP-CASH-OFF                              
                   ,:Y2-DEP-XFER-METHOD                                 
                   ,:Y2-USER-ID                                         
                   ,:Y2-DEP-DEFT-BANK-ID                                
                   ,:Y2-LOCAL-OFFICE                                    
                   ,:Y2-DEP-CASH-GL-OFFSET                              
                   ,:Y2-PAYMENT-AGENT-FL                                
                   ,:Y2-PYMT-TO-POST-DAYS                               
                   ,:Y2-ERROR-GL-OFFSET                                 
               FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = '01'                           
                AND CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE          
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT BATCH_DEP_CASH_OFF                                          
MFA-TR*            ,DEP_XFER_METHOD                                             
MFA-TR*            ,USER_ID                                                     
MFA-TR*            ,DEP_DEFT_BANK_ID                                            
MFA-TR*            ,LOCAL_OFFICE                                                
MFA-TR*            ,DEP_CASH_GL_OFFSET                                          
MFA-TR*            ,PAYMENT_AGENT_FL                                            
MFA-TR*            ,PYMT_TO_POST_DAYS                                           
MFA-TR*            ,ERROR_GL_OFFSET                                             
MFA-TR*        INTO :Y2-BATCH-DEP-CASH-OFF                                      
MFA-TR*            ,:Y2-DEP-XFER-METHOD                                         
MFA-TR*            ,:Y2-USER-ID                                                 
MFA-TR*            ,:Y2-DEP-DEFT-BANK-ID                                        
MFA-TR*            ,:Y2-LOCAL-OFFICE                                            
MFA-TR*            ,:Y2-DEP-CASH-GL-OFFSET                                      
MFA-TR*            ,:Y2-PAYMENT-AGENT-FL                                        
MFA-TR*            ,:Y2-PYMT-TO-POST-DAYS                                       
MFA-TR*            ,:Y2-ERROR-GL-OFFSET                                         
MFA-TR*        FROM CSS_CASHIER_OFFICE                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = '01'                                   
MFA-TR*         AND CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE Y2-DEP-XFER-METHOD    TO WS-DEP-XFER-METHOD          
           ELSE                                                         
              STRING ' ERROR GETTING CASHIER OFFICE **'                 
                                              DELIMITED BY SIZE         
                      ' CASHIER OFFICE    '   DELIMITED BY SIZE         
                      Y2-CASH-LOCAL-OFFICE    DELIMITED BY SIZE         
                      ',CASH COMPANY NO = 01' DELIMITED BY SIZE         
                                         INTO WS-ERR-MSG                
              MOVE 'CSS_CASHIER_OFFICE'  TO WS-TABLE-NAME               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7010-SELECT-CASHIER-CODE                                    **        
      **                                                              **        
      ******************************************************************        
       7010-SELECT-CASHIER-CODE.                                        
           MOVE '7010'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT CASHIER_CODE                                        
               INTO :Y1-CASHIER-CODE                                    
               FROM CSS_CASHIER WITH(READUNCOMMITTED)                           
              WHERE USER_ID            = :Y1-USER-ID                    
                AND CASH_COMPANY_NO    = '01'                           
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CASHIER_CODE                                                
MFA-TR*        INTO :Y1-CASHIER-CODE                                            
MFA-TR*        FROM CSS_CASHIER                                                 
MFA-TR*       WHERE USER_ID            = :Y1-USER-ID                            
MFA-TR*         AND CASH_COMPANY_NO    = '01'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               STRING ' ERROR GETTING CASHIER CODE **'                  
                                              DELIMITED BY SIZE         
                      ' FOR USER ID       '   DELIMITED BY SIZE         
                      Y1-USER-ID,             DELIMITED BY SIZE         
                      ',CASH COMPANY NO = 01' DELIMITED BY SIZE         
                                         INTO WS-ERR-MSG                
               MOVE 'CSS_CASHIER'        TO WS-TABLE-NAME               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7015-SELECT-BANK-ST-CD                                      **        
      **                                                              **        
      ******************************************************************        
       7015-SELECT-BANK-ST-CD.                                          
      *-----------------------*                                                 
           MOVE '7015'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT FCS_DEP_BANK_ST_CD                                  
               INTO :D1-FCS-DEP-BANK-ST-CD                              
               FROM CSS_BANK WITH(READUNCOMMITTED)                              
              WHERE BANK_ID = :D1-BANK-ID                               
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT FCS_DEP_BANK_ST_CD                                          
MFA-TR*        INTO :D1-FCS-DEP-BANK-ST-CD                                      
MFA-TR*        FROM CSS_BANK                                                    
MFA-TR*       WHERE BANK_ID = :D1-BANK-ID                                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE D1-BANK-ID        TO WS-DISP-BANK-ID                
               STRING  'ERROR GETTING BANK ST CD  **'                   
                                      DELIMITED BY SIZE                 
                      'BANK ID '      DELIMITED BY SIZE                 
                 WS-DISP-BANK-ID      DELIMITED BY SIZE                 
                                      INTO WS-ERR-MSG                   
               MOVE 'CSS_BANK'        TO WS-TABLE-NAME                  
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7020-SELECT-CASH-REPORT                                     **        
      **                                                              **        
      ******************************************************************        
       7020-SELECT-CASH-REPORT.                                         
      *------------------------*                                                
           MOVE '7020'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT USER_ID                                             
               INTO :YR-USER-ID                                         
               FROM CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = '01'                           
                AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )           
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*        INTO :YR-USER-ID                                                 
MFA-TR*        FROM CSS_CSH_REPORT_HDR                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = '01'                                   
MFA-TR*         AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :YR-DATE-CASH-REPORT                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               STRING 'ERROR IN SELECTING CASH REPORT HEADER**'         
                                             DELIMITED BY SIZE          
                      ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                      YR-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ',CASH COMPANY = 01 '  DELIMITED BY SIZE          
                      ',DATE CASH REPORT'    DELIMITED BY SIZE          
                      YR-DATE-CASH-REPORT    DELIMITED BY SIZE          
                                       INTO WS-ERR-MSG                  
               MOVE 'CSS_CSH_REPORT_HDR'     TO WS-TABLE-NAME           
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7030-SELECT-CASH-DRWR-CNTL                                  **        
      **                                                              **        
      ******************************************************************        
       7030-SELECT-CASH-DRWR-CNTL.                                      
      *--------------------------*                                              
           MOVE '7030'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT CASH_DRAWER_ID                                      
                   ,DATE_CASH_REPORT                                    
                   ,AMT_CASH_DEBIT                                      
                   ,AMT_CASH_CREDIT                                     
                   ,NO_ITEMS_ENTERED                                    
               INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR-2            
                   ,:CS-DATE-CASH-REPORT                                
                   ,:CS-AMT-CASH-DEBIT                                  
                   ,:CS-AMT-CASH-CREDIT                                 
                   ,:CS-NO-ITEMS-ENTERED                                
               FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO      = :CS-CASH-COMPANY-NO          
                AND CASH_LOCAL_OFFICE    = :CS-CASH-LOCAL-OFFICE        
                AND CODE_CSH_DRWR_STAT   = :CS-CODE-CSH-DRWR-STAT       
                AND DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )         
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CASH_DRAWER_ID                                              
MFA-TR*            ,DATE_CASH_REPORT                                            
MFA-TR*            ,AMT_CASH_DEBIT                                              
MFA-TR*            ,AMT_CASH_CREDIT                                             
MFA-TR*            ,NO_ITEMS_ENTERED                                            
MFA-TR*        INTO :CS-CASH-DRAWER-ID  :WS-NULL-INDICATOR-2                    
MFA-TR*            ,:CS-DATE-CASH-REPORT                                        
MFA-TR*            ,:CS-AMT-CASH-DEBIT                                          
MFA-TR*            ,:CS-AMT-CASH-CREDIT                                         
MFA-TR*            ,:CS-NO-ITEMS-ENTERED                                        
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                           
MFA-TR*       WHERE CASH_COMPANY_NO      = :CS-CASH-COMPANY-NO                  
MFA-TR*         AND CASH_LOCAL_OFFICE    = :CS-CASH-LOCAL-OFFICE                
MFA-TR*         AND CODE_CSH_DRWR_STAT   = :CS-CODE-CSH-DRWR-STAT               
MFA-TR*         AND DATE_CASH_REPORT     = :CS-DATE-CASH-REPORT                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                              OR NOT-FOUND                              
              IF WS-NULL-INDICATOR-2 < ZERO                             
                 MOVE NOT-FOUND         TO WS-ACTIVE-RETURN-CODE        
              END-IF                                                    
           ELSE                                                         
               MOVE 'CSS_CSH_DRWR_CNTL'  TO WS-TABLE-NAME               
               MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID      
               STRING ' ERROR SELECTING CASH DRAWER ID **'              
                                             DELIMITED BY SIZE          
                      ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                      CS-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ' CASH DRAWER STATUS ' DELIMITED BY SIZE          
                      CS-CODE-CSH-DRWR-STAT  DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7040-GET-MAX-CNTL-DRWR                                      **        
      **                                                              **        
      ******************************************************************        
       7040-GET-MAX-CNTL-DRWR.                                          
      *----------------------*                                                  
           MOVE '7040'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT MAX(CASH_DRAWER_ID)                                 
               INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR-2             
               FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND CODE_CSH_DRWR_STAT = :CS-CODE-CSH-DRWR-STAT         
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(CASH_DRAWER_ID)                                         
MFA-TR*        INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR-2                     
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                           
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*         AND CODE_CSH_DRWR_STAT = :CS-CODE-CSH-DRWR-STAT                 
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF  WS-NULL-INDICATOR-2 < ZERO  OR                           
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               MOVE WS-ZERO          TO CS-CASH-DRAWER-ID               
               GO TO 7040-EXIT                                          
           END-IF                                                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'CSS_CSH_DRWR_CNTL'  TO WS-TABLE-NAME               
               MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID      
               STRING 'ERROR GETTING MAX CNTL DRAWER ID **'             
                                             DELIMITED BY SIZE          
                      ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                       CS-CASH-LOCAL-OFFICE, DELIMITED BY SIZE          
                      ',CASH DRAWER STATUS'  DELIMITED BY SIZE          
                      CS-CODE-CSH-DRWR-STAT  DELIMITED BY SIZE          
                                       INTO WS-ERR-MSG                  
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
C33928 7040-EXIT.                                                       
C33928     EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      *      THIS PARA READS THE INPUT FILE                            *        
      *                                                                *        
      ******************************************************************        
       7100-READ-FCSAC21.                                               
                                                                        
             MOVE '7100'                 TO WS-ACTIVE-PARAGRAPH.        
                                                                        
             READ FCSAC21-FILE AT END                                   
                        SET FCSAC21-AT-EOF TO TRUE.                     
                                                                        
             IF FAC21-SUCCESSFUL OR FCSAC21-AT-EOF                      
                NEXT SENTENCE                                           
             ELSE                                                       
                STRING  '** FILE READ ERROR    **' DELIMITED BY SIZE    
                          WS-FAC21-STATUS         DELIMITED BY SIZE     
                                         INTO     WS-ERR-MSG            
               PERFORM      8900-DISPLAY-ERR-AND-TERMINATE              
                  THRU      8900-EXIT                                   
             END-IF.                                                    
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
A02388*      THIS PARA GETS OVERSHORT TYPE                             *        
      ******************************************************************        
A02388 7400-GET-OVSH-TYPE.                                              
                                                                        
           MOVE '7400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
A02388         SELECT TOP(1) OVERSHORT_TYPE_CD                                 
A02388           INTO :OT-OVERSHORT-TYPE-CD                             
A02388           FROM CSS_OVERSHORT_TYPE WITH(READUNCOMMITTED)                  
A02388          WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                       
A02388                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT OVERSHORT_TYPE_CD                                         
MFA-TR*          INTO :OT-OVERSHORT-TYPE-CD                                     
MFA-TR*          FROM CSS_OVERSHORT_TYPE                                        
MFA-TR*         WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                               
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
A02388         STRING  '** ERROR GETTING OVERSHORT-TYPE  **'            
                                              DELIMITED BY SIZE         
                        ' GL ACCOUNT NO  '    DELIMITED BY SIZE         
                        WS-DISP-GL-ACCT       DELIMITED BY SIZE         
                                       INTO  WS-ERR-MSG                 
               MOVE 'CSS_OVERSHORT_TYPE' TO WS-TABLE-NAME               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *      THIS PARA GETS THE CURRENT VALUE OF                       *        
      *                             TIME                               *        
      ******************************************************************        
       7700-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           MOVE '7700'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
      *    EXEC SQL                                                             
      *     SELECT CURRENT TIME INTO   :BJ-TRAN-TIME                            
      *      FROM CSS_MODEL_SQL                                                 
      *    END-EXEC.                                                            
                                                                        
C33928     EXEC SQL                                                     
C33928       SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-XFR-TS                                          
C33928     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      VALUES CURRENT TIMESTAMP                                           
MFA-TR*        INTO :WS-XFR-TS                                                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C33928     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
C33928     IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
C33928         NEXT SENTENCE                                            
C33928     END-IF                                                       
                                                                        
C33928     EXEC SQL                                                     
C33928       SELECT
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-TRAN-TIME                                       
C33928     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      VALUES CURRENT TIME                                                
MFA-TR*        INTO :WS-TRAN-TIME                                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33928                                                                  
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
                 MOVE  '** ERROR GETTING TIMESTAMP VALUE  **'           
                                         TO  WS-ERR-MSG                 
                 PERFORM      8900-DISPLAY-ERR-AND-TERMINATE            
                    THRU      8900-EXIT                                 
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *      THIS PARA CHECKS FOR THE EXISTENCE OF                     *        
      *      A ROW IN THE CONTROL TABLE  FOR GIVEN BATCH NO,           *        
      *      CASH LOCAL OFFICE,DATE CASH REPORT ETC.                   *        
      ******************************************************************        
       7800-SELECT-BCH-JRNL-CNTL.                                       
                                                                        
             MOVE '7800'                 TO WS-ACTIVE-PARAGRAPH.        
                                                                        
             EXEC SQL                                                   
              SELECT CASH_COMPANY_NO,                                   
                     NO_ITEMS_ENTERED,                                  
                     NO_ITEMS_POSTED,                                   
                     AMT_CASH_DEBIT,                                    
C25923               AMT_CASH_CREDIT                                    
               INTO :WS-TEMP-CASH-CO-NO,                                
                    :BC-NO-ITEMS-ENTERED,                               
                    :BC-NO-ITEMS-POSTED,                                
                    :BC-AMT-CASH-DEBIT,                                 
C25923              :BC-AMT-CASH-CREDIT                                 
               FROM CSS_BCH_JRNL_CNTL                                   
              WHERE CASH_COMPANY_NO  = :BC-CASH-COMPANY-NO              
               AND CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE            
               AND CASH_DRAWER_ID    = :BC-CASH-DRAWER-ID               
               AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )             
               AND CASH_REPORT_NO    = :BC-CASH-REPORT-NO               
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*      EXEC SQL                                                           
MFA-TR*       SELECT CASH_COMPANY_NO,                                           
MFA-TR*              NO_ITEMS_ENTERED,                                          
MFA-TR*              NO_ITEMS_POSTED,                                           
MFA-TR*              AMT_CASH_DEBIT,                                            
MFA-TR*              AMT_CASH_CREDIT                                            
MFA-TR*        INTO :WS-TEMP-CASH-CO-NO,                                        
MFA-TR*             :BC-NO-ITEMS-ENTERED,                                       
MFA-TR*             :BC-NO-ITEMS-POSTED,                                        
MFA-TR*             :BC-AMT-CASH-DEBIT,                                         
MFA-TR*             :BC-AMT-CASH-CREDIT                                         
MFA-TR*        FROM CSS_BCH_JRNL_CNTL                                           
MFA-TR*       WHERE CASH_COMPANY_NO  = :BC-CASH-COMPANY-NO                      
MFA-TR*        AND CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE                    
MFA-TR*        AND CASH_DRAWER_ID    = :BC-CASH-DRAWER-ID                       
MFA-TR*        AND DATE_CASH_REPORT  = :BC-DATE-CASH-REPORT                     
MFA-TR*        AND CASH_REPORT_NO    = :BC-CASH-REPORT-NO                       
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.        
                                                                        
             IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR             
                 WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
             ELSE                                                       
                 STRING 'LOCAL OFFICE     '   DELIMITED BY SIZE         
                        BC-CASH-LOCAL-OFFICE, DELIMITED BY SIZE         
                        ',CASH COMPANY NO   ' DELIMITED BY SIZE         
                        BC-CASH-COMPANY-NO,   DELIMITED BY SIZE         
                        ',DATE CASH REPORT'   DELIMITED BY SIZE         
                        BC-DATE-CASH-REPORT,  DELIMITED BY SIZE         
                        ',CASH-REPORT-NO '    DELIMITED BY SIZE         
                        BC-CASH-REPORT-NO     DELIMITED BY SIZE         
                                             INTO WS-ERR-MSG            
T22767           MOVE  'CSS_BCH_JRNL_CNTL'    TO WS-TABLE-NAME          
                 PERFORM      8800-DIS-TABLE-ERROR                      
                    THRU      8800-EXIT                                 
             END-IF.                                                    
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
C25923******************************************************************        
C25923**  7850-SELECT-DATABASE                                        **        
      **                                                              **        
      ******************************************************************        
       7850-SELECT-DATABASE.                                            
      *---------------------*                                                   
           MOVE '7850'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT DELINQ_VALUE                                         
              INTO :C8-DELINQ-VALUE                                     
              FROM CSS_DELINQUENCY                                      
             WHERE COMPANY_NO           = :C8-COMPANY-NO                
               AND DELINQ_CD            = :C8-DELINQ-CD                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 STRING 'DELINQUENCY CODE '  DELIMITED BY SIZE          
                         C8-DELINQ-CD,       DELIMITED BY SIZE          
                         'COMPANY NO  '      DELIMITED BY SIZE          
                          C8-COMPANY-NO      DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
                 MOVE  'CSS_DELINQUENCY'      TO WS-TABLE-NAME          
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           END-IF                                                       
           .                                                            
C25923 7850-EXIT.                                                       
C25923     EXIT.                                                        
                                                                        
C25923******************************************************************        
C25923*      THIS PARA CREATES SELECTS                                 *        
      *               THE MAXIMUM OVERSHORT ID                         *        
      ******************************************************************        
       7950-GET-OVSH-ID.                                                
                                                                        
           MOVE '7950'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
             SELECT MAX(OVERSHORT_ID)                                   
               INTO :OH-OVERSHORT-ID :WS-NULL-INDICATOR-1               
               FROM CSS_OVERSHORT_HDR                                   
              WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO             
                AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE           
                AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )            
                AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(OVERSHORT_ID)                                           
MFA-TR*        INTO :OH-OVERSHORT-ID :WS-NULL-INDICATOR-1                       
MFA-TR*        FROM CSS_OVERSHORT_HDR                                           
MFA-TR*       WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
               IF WS-NULL-INDICATOR-1 EQUAL -1                          
                  MOVE ZERO                 TO OH-OVERSHORT-ID          
               END-IF                                                   
           ELSE                                                         
               STRING 'CASH LOCAL OFFICE '  DELIMITED BY SIZE           
                    OH-CASH-LOCAL-OFFICE,   DELIMITED BY SIZE           
                  ',DATE CASH REPORT'       DELIMITED BY SIZE           
                    OH-DATE-CASH-REPORT,    DELIMITED BY SIZE           
                  ',CASH DRAWER-ID  '       DELIMITED BY SIZE           
                    WS-CASH-DRAWER-ID,      DELIMITED BY SIZE           
                                            INTO WS-ERR-MSG             
                 MOVE  'CSS_OVERSHORT_HDR'  TO WS-TABLE-NAME            
                 PERFORM      8800-DIS-TABLE-ERROR                      
                    THRU      8800-EXIT                                 
                                                                        
           END-IF                                                       
           .                                                            
C25923 7950-EXIT.                                                       
C25923     EXIT.                                                        
A02388*                                                                         
A02388******************************************************************        
A02388**  7960-SELECT-HST-ACCOUNT                                     **        
A02388**  TO GET THE XFER-TO ACCT.                                    **        
A02388******************************************************************        
A02388 7960-SELECT-HST-ACCOUNT.                                         
A02388     MOVE '7960'                   TO WS-ACTIVE-PARAGRAPH.        
A02388                                                                  
A02388     EXEC SQL                                                     
A02388         SELECT ACCT_XFER_TO                                      
A02388           INTO :HA-ACCT-XFER-TO                                  
A02388           FROM HST_ACCOUNT WITH(READUNCOMMITTED)                         
A02388          WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                       
A02388                                                           
A02388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCT_XFER_TO                                              
MFA-TR*          INTO :HA-ACCT-XFER-TO                                          
MFA-TR*          FROM HST_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02388                                                                  
A02388     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
A02388                                                                  
A02388     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02388        NEXT SENTENCE                                             
A02388     ELSE                                                         
A02388         MOVE HA-ACCOUNT-NO           TO WS-DISP-ACCT-NO          
A02388         STRING 'ACCOUNT_NO '         DELIMITED BY SIZE           
A02388                WS-DISP-ACCT-NO,      DELIMITED BY SIZE           
A02388                                      INTO WS-ERR-MSG             
A02388         MOVE  'HST_ACCOUNT'          TO WS-TABLE-NAME            
A02388         PERFORM 8800-DIS-TABLE-ERROR THRU 8800-EXIT              
A02388     END-IF.                                                      
A02388*                                                                         
A02388 7960-EXIT.                                                       
A02388     EXIT.                                                        
                                                                        
C33928******************************************************************        
C33928**  8010-CREATE-CASH-REPORT                                     **        
      **                                                              **        
      ******************************************************************        
       8010-CREATE-CASH-REPORT.                                         
      *------------------------*                                                
           MOVE '8010'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_REPORT_HDR                             
                    ( CASH_COMPANY_NO                                   
                     ,CASH_LOCAL_OFFICE                                 
                     ,DATE_CASH_REPORT                                  
                     ,USER_ID                                           
                     ,STATUS                                            
                     ,CLOSED_TS)                                        
             VALUES ( '01'                                              
                     ,:YR-CASH-LOCAL-OFFICE                             
                     ,IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )                         
                     ,:YR-USER-ID                                       
A05460               ,'A'                                               
                     ,CIS.CURRENT$TIMESTAMP() )                               
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_REPORT_HDR                                     
MFA-TR*             ( CASH_COMPANY_NO                                           
MFA-TR*              ,CASH_LOCAL_OFFICE                                         
MFA-TR*              ,DATE_CASH_REPORT                                          
MFA-TR*              ,USER_ID                                                   
MFA-TR*              ,STATUS                                                    
MFA-TR*              ,CLOSED_TS)                                                
MFA-TR*      VALUES ( '01'                                                      
MFA-TR*              ,:YR-CASH-LOCAL-OFFICE                                     
MFA-TR*              ,:YR-DATE-CASH-REPORT                                      
MFA-TR*              ,:YR-USER-ID                                               
MFA-TR*              ,'A'                                                       
MFA-TR*              ,CURRENT TIMESTAMP )                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               STRING 'ERROR IN INSERTING CASH REPORT HEADER**'         
                                             DELIMITED BY SIZE          
                      ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                      YR-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ',CASH COMPANY = 01 '  DELIMITED BY SIZE          
                      ',DATE CASH REPORT'    DELIMITED BY SIZE          
                      YR-DATE-CASH-REPORT    DELIMITED BY SIZE          
                                       INTO WS-ERR-MSG                  
                                                                        
               MOVE 'CSS_CSH_REPORT_HDR' TO WS-TABLE-NAME               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8020-CREATE-CASH-DRWR-CNTL                                  **        
      **                                                              **        
      ******************************************************************        
       8020-CREATE-CASH-DRWR-CNTL.                                      
      *--------------------------*                                              
           MOVE '8020'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_DRWR_CNTL (                            
                        CASH_COMPANY_NO                                 
                       ,CASH_LOCAL_OFFICE                               
                       ,CASH_REPORT_NO                                  
                       ,DATE_CASH_REPORT                                
                       ,CASH_DRAWER_ID                                  
                       ,AMT_CASH_DEBIT                                  
                       ,AMT_CASH_CREDIT                                 
                       ,AMT_AR_DEBIT                                    
                       ,AMT_AR_CREDIT                                   
                       ,AMT_CK_ISS_DEBIT                                
                       ,AMT_CK_ISS_CREDIT                               
                       ,AMT_GL_DEBIT                                    
                       ,AMT_GL_CREDIT                                   
                       ,AMT_CASH_BEGIN_BAL                              
                       ,AMT_BASIC_WORK                                  
                       ,USER_ID                                         
                       ,CASHIER_CODE                                    
                       ,CODE_PYMT_FACILITY                              
                       ,CODE_FCS_EXTRACTED                              
                       ,CODE_CSH_DRWR_STAT                              
                       ,DATE_LAST_ACTIVITY                              
                       ,BALANCED_BY                                     
                       ,BALANCED_TS                                     
                       ,NO_ITEMS_ENTERED )                              
             VALUES (                                                   
                        '01'                                            
                       ,:CS-CASH-LOCAL-OFFICE                           
                       ,:CS-CASH-REPORT-NO                              
                       ,IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )                         
                       ,:CS-CASH-DRAWER-ID                              
                       ,:CS-AMT-CASH-DEBIT                              
                       ,:CS-AMT-CASH-CREDIT                             
                       ,:CS-AMT-AR-DEBIT                                
                       ,:CS-AMT-AR-CREDIT                               
                       ,:CS-AMT-CK-ISS-DEBIT                            
                       ,:CS-AMT-CK-ISS-CREDIT                           
                       ,:CS-AMT-GL-DEBIT                                
                       ,:CS-AMT-GL-CREDIT                               
                       ,:CS-AMT-CASH-BEGIN-BAL                          
                       ,:CS-AMT-BASIC-WORK                              
                       ,:CS-USER-ID                                     
                       ,:CS-CASHIER-CODE                                
                       ,'M'                                             
                       ,' '                                             
A03311                 ,'A'                                             
      * OPEN THE CASH DRAWER IN ACTIVE STATUS TO POST PAYMENTS, IF IT           
      * IS CLOSED THEN THE PAYMENT PROGRAM WILL ASSUME THE BATCH IS             
      * ALREADY POSTED.                                                         
                       ,CAST(SYSDATETIMEOFFSET() AS DATE)                       
                       ,:CS-BALANCED-BY                                 
                       ,CIS.CHAR2TIMESTAMP(:CS-BALANCED-TS 
                                           :WS-CNTL-TS-NI)                 
                       ,:CS-NO-ITEMS-ENTERED )                          
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_DRWR_CNTL (                                    
MFA-TR*                 CASH_COMPANY_NO                                         
MFA-TR*                ,CASH_LOCAL_OFFICE                                       
MFA-TR*                ,CASH_REPORT_NO                                          
MFA-TR*                ,DATE_CASH_REPORT                                        
MFA-TR*                ,CASH_DRAWER_ID                                          
MFA-TR*                ,AMT_CASH_DEBIT                                          
MFA-TR*                ,AMT_CASH_CREDIT                                         
MFA-TR*                ,AMT_AR_DEBIT                                            
MFA-TR*                ,AMT_AR_CREDIT                                           
MFA-TR*                ,AMT_CK_ISS_DEBIT                                        
MFA-TR*                ,AMT_CK_ISS_CREDIT                                       
MFA-TR*                ,AMT_GL_DEBIT                                            
MFA-TR*                ,AMT_GL_CREDIT                                           
MFA-TR*                ,AMT_CASH_BEGIN_BAL                                      
MFA-TR*                ,AMT_BASIC_WORK                                          
MFA-TR*                ,USER_ID                                                 
MFA-TR*                ,CASHIER_CODE                                            
MFA-TR*                ,CODE_PYMT_FACILITY                                      
MFA-TR*                ,CODE_FCS_EXTRACTED                                      
MFA-TR*                ,CODE_CSH_DRWR_STAT                                      
MFA-TR*                ,DATE_LAST_ACTIVITY                                      
MFA-TR*                ,BALANCED_BY                                             
MFA-TR*                ,BALANCED_TS                                             
MFA-TR*                ,NO_ITEMS_ENTERED )                                      
MFA-TR*      VALUES (                                                           
MFA-TR*                 '01'                                                    
MFA-TR*                ,:CS-CASH-LOCAL-OFFICE                                   
MFA-TR*                ,:CS-CASH-REPORT-NO                                      
MFA-TR*                ,:CS-DATE-CASH-REPORT                                    
MFA-TR*                ,:CS-CASH-DRAWER-ID                                      
MFA-TR*                ,:CS-AMT-CASH-DEBIT                                      
MFA-TR*                ,:CS-AMT-CASH-CREDIT                                     
MFA-TR*                ,:CS-AMT-AR-DEBIT                                        
MFA-TR*                ,:CS-AMT-AR-CREDIT                                       
MFA-TR*                ,:CS-AMT-CK-ISS-DEBIT                                    
MFA-TR*                ,:CS-AMT-CK-ISS-CREDIT                                   
MFA-TR*                ,:CS-AMT-GL-DEBIT                                        
MFA-TR*                ,:CS-AMT-GL-CREDIT                                       
MFA-TR*                ,:CS-AMT-CASH-BEGIN-BAL                                  
MFA-TR*                ,:CS-AMT-BASIC-WORK                                      
MFA-TR*                ,:CS-USER-ID                                             
MFA-TR*                ,:CS-CASHIER-CODE                                        
MFA-TR*                ,'M'                                                     
MFA-TR*                ,' '                                                     
MFA-TR*                ,'A'                                                     
MFA-TR* OPEN THE CASH DRAWER IN ACTIVE STATUS TO POST PAYMENTS, IF IT           
MFA-TR* IS CLOSED THEN THE PAYMENT PROGRAM WILL ASSUME THE BATCH IS             
MFA-TR* ALREADY POSTED.                                                         
MFA-TR*                ,CURRENT DATE                                            
MFA-TR*                ,:CS-BALANCED-BY                                         
MFA-TR*                ,:CS-BALANCED-TS  :WS-CNTL-TS-NI                         
MFA-TR*                ,:CS-NO-ITEMS-ENTERED )                                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSS_CSH_DRWR_CNTL'  TO WS-TABLE-NAME                
              MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID       
              STRING ' ERROR INSERTING  INTO CSS_CSH_DRWR_CNTL **'      
                                             DELIMITED BY SIZE          
                        'CASHIER OFFICE   '  DELIMITED BY SIZE          
                      CS-CASH-LOCAL-OFFICE   DELIMITED BY SIZE          
                      ',DATE CASH REPORT'    DELIMITED BY SIZE          
                      CS-DATE-CASH-REPORT    DELIMITED BY SIZE          
                      ',CASH DRAWER ID'      DELIMITED BY SIZE          
                      WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
                                                                        
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF                                                       
           .                                                            
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8030-CREATE-CASH-DRWR-JRNL                                  **        
      **                                                              **        
      ******************************************************************        
       8030-CREATE-CASH-DRWR-JRNL.                                      
      *--------------------------*                                              
           MOVE '8030'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
            INSERT INTO CSS_CSH_DRWR_JRNL (                             
                   CASH_COMPANY_NO,                                     
                   CASH_LOCAL_OFFICE,                                   
                   CASH_REPORT_NO,                                      
                   DATE_CASH_REPORT,                                    
                   CASH_DRAWER_ID,                                      
                   DATE_TRAN,                                           
                   ENTRY_NO,                                            
                   TRAN_APPL_NO,                                        
                   LOCAL_OFFICE,                                        
                   COMPANY_NO,                                          
                   JRNL_SORT_ID,                                        
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,                                         
                   GL_ACCT_NO,                                          
                   METER_NO,                                            
                   TRAN_TIME,                                           
                   TRAN_ID,                                             
                   DATE_LAST_ACTION,                                    
                   CODE_ENTRY_SOURCE,                                   
                   USER_ID,                                             
                   BATCH_SEND_LOC,                                      
                   ENTRY_LOC,                                           
                   CODE_TRAN_ERRORS,                                    
                   CODE_JRNL_EXTRACT,                                   
                   DATE_BALANCED,                                       
                   TIME_BALANCED,                                       
                   BALANCED_BY,                                         
                   CODE_STATUS,                                         
                   CURRENCY_TYPE,                                       
                   CODE_PYMT_FACILITY,                                  
                   TRAN_DATA,                                           
                   CSR_PC_ID,                                           
                   TRAN_COMMENT )                                       
              VALUES (                                                  
                   :CJ-CASH-COMPANY-NO,                                 
                   :CJ-CASH-LOCAL-OFFICE,                               
                   :CJ-CASH-REPORT-NO,                                  
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) ),                        
                   :CJ-CASH-DRAWER-ID,                                  
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-TRAN
              ) <> 0) OR (LEN(:CJ-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :CJ-DATE-TRAN
              ), CONVERT(DATE, :CJ-DATE-TRAN) ),                               
                   :CJ-ENTRY-NO,                                        
                   :CJ-TRAN-APPL-NO,                                    
                   :CJ-LOCAL-OFFICE,                                    
                   :CJ-COMPANY-NO,                                      
                   :CJ-JRNL-SORT-ID,                                    
                   :CJ-ACCOUNT-NO,                                      
                   :CJ-CUSTOMER-NO,                                     
                   :CJ-GL-ACCT-NO,                                      
                   :CJ-METER-NO,                                        
                   CIS.CHAR2TIME(:CJ-TRAN-TIME),                                
                   :CJ-TRAN-ID,                                         
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:CJ-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-LAST-ACTION
              ), CONVERT(DATE, :CJ-DATE-LAST-ACTION) ),                        
                   :CJ-CODE-ENTRY-SOURCE,                               
                   :CJ-USER-ID,                                         
                   :CJ-BATCH-SEND-LOC,                                  
                   :CJ-ENTRY-LOC,                                       
                   :CJ-CODE-TRAN-ERRORS ,                               
                   :CJ-CODE-JRNL-EXTRACT,                               
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-BALANCED 
                                         :WS-CJ-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-BALANCED 
                                                         :WS-CJ-DATE-NI
              ) <> 0) OR (LEN(:CJ-DATE-BALANCED :WS-CJ-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-BALANCED :WS-CJ-DATE-NI
              ), CONVERT(DATE, :CJ-DATE-BALANCED :WS-CJ-DATE-NI) ),            
                   CIS.CHAR2TIME(:CJ-TIME-BALANCED :WS-CJ-TIME-NI),             
                   :CJ-BALANCED-BY,                                     
                   :CJ-CODE-STATUS,                                     
                   :CJ-CURRENCY-TYPE,                                   
                   :CJ-CODE-PYMT-FACILITY,                              
                   :CJ-TRAN-DATA,                                       
                   :CJ-CSR-PC-ID,                                       
                   :CJ-TRAN-COMMENT )                                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     INSERT INTO CSS_CSH_DRWR_JRNL (                                     
MFA-TR*            CASH_COMPANY_NO,                                             
MFA-TR*            CASH_LOCAL_OFFICE,                                           
MFA-TR*            CASH_REPORT_NO,                                              
MFA-TR*            DATE_CASH_REPORT,                                            
MFA-TR*            CASH_DRAWER_ID,                                              
MFA-TR*            DATE_TRAN,                                                   
MFA-TR*            ENTRY_NO,                                                    
MFA-TR*            TRAN_APPL_NO,                                                
MFA-TR*            LOCAL_OFFICE,                                                
MFA-TR*            COMPANY_NO,                                                  
MFA-TR*            JRNL_SORT_ID,                                                
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            GL_ACCT_NO,                                                  
MFA-TR*            METER_NO,                                                    
MFA-TR*            TRAN_TIME,                                                   
MFA-TR*            TRAN_ID,                                                     
MFA-TR*            DATE_LAST_ACTION,                                            
MFA-TR*            CODE_ENTRY_SOURCE,                                           
MFA-TR*            USER_ID,                                                     
MFA-TR*            BATCH_SEND_LOC,                                              
MFA-TR*            ENTRY_LOC,                                                   
MFA-TR*            CODE_TRAN_ERRORS,                                            
MFA-TR*            CODE_JRNL_EXTRACT,                                           
MFA-TR*            DATE_BALANCED,                                               
MFA-TR*            TIME_BALANCED,                                               
MFA-TR*            BALANCED_BY,                                                 
MFA-TR*            CODE_STATUS,                                                 
MFA-TR*            CURRENCY_TYPE,                                               
MFA-TR*            CODE_PYMT_FACILITY,                                          
MFA-TR*            TRAN_DATA,                                                   
MFA-TR*            CSR_PC_ID,                                                   
MFA-TR*            TRAN_COMMENT )                                               
MFA-TR*       VALUES (                                                          
MFA-TR*            :CJ-CASH-COMPANY-NO,                                         
MFA-TR*            :CJ-CASH-LOCAL-OFFICE,                                       
MFA-TR*            :CJ-CASH-REPORT-NO,                                          
MFA-TR*            :CJ-DATE-CASH-REPORT,                                        
MFA-TR*            :CJ-CASH-DRAWER-ID,                                          
MFA-TR*            :CJ-DATE-TRAN,                                               
MFA-TR*            :CJ-ENTRY-NO,                                                
MFA-TR*            :CJ-TRAN-APPL-NO,                                            
MFA-TR*            :CJ-LOCAL-OFFICE,                                            
MFA-TR*            :CJ-COMPANY-NO,                                              
MFA-TR*            :CJ-JRNL-SORT-ID,                                            
MFA-TR*            :CJ-ACCOUNT-NO,                                              
MFA-TR*            :CJ-CUSTOMER-NO,                                             
MFA-TR*            :CJ-GL-ACCT-NO,                                              
MFA-TR*            :CJ-METER-NO,                                                
MFA-TR*            :CJ-TRAN-TIME,                                               
MFA-TR*            :CJ-TRAN-ID,                                                 
MFA-TR*            :CJ-DATE-LAST-ACTION,                                        
MFA-TR*            :CJ-CODE-ENTRY-SOURCE,                                       
MFA-TR*            :CJ-USER-ID,                                                 
MFA-TR*            :CJ-BATCH-SEND-LOC,                                          
MFA-TR*            :CJ-ENTRY-LOC,                                               
MFA-TR*            :CJ-CODE-TRAN-ERRORS ,                                       
MFA-TR*            :CJ-CODE-JRNL-EXTRACT,                                       
MFA-TR*            :CJ-DATE-BALANCED :WS-CJ-DATE-NI,                            
MFA-TR*            :CJ-TIME-BALANCED :WS-CJ-TIME-NI,                            
MFA-TR*            :CJ-BALANCED-BY,                                             
MFA-TR*            :CJ-CODE-STATUS,                                             
MFA-TR*            :CJ-CURRENCY-TYPE,                                           
MFA-TR*            :CJ-CODE-PYMT-FACILITY,                                      
MFA-TR*            :CJ-TRAN-DATA,                                               
MFA-TR*            :CJ-CSR-PC-ID,                                               
MFA-TR*            :CJ-TRAN-COMMENT )                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE 'CSS_CSH_DRWR_JRNL'    TO WS-TABLE-NAME             
               MOVE CJ-CASH-DRAWER-ID      TO WS-DISP-CASH-DRAWER-ID    
               STRING ' ERROR INSERTING  INTO CSS_CSH_DRWR_JRNL **'     
                                           DELIMITED BY SIZE            
                     ' CASHIER OFFICE   '  DELIMITED BY SIZE            
                    CJ-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE            
                    ',DATE CASH REPORT'    DELIMITED BY SIZE            
                    CJ-DATE-CASH-REPORT,   DELIMITED BY SIZE            
                    ',CASH-REPORT-NO '     DELIMITED BY SIZE            
                    CJ-CASH-REPORT-NO,     DELIMITED BY SIZE            
                    ',CASH DRAWER ID'      DELIMITED BY SIZE            
                    WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE            
                                         INTO WS-ERR-MSG                
                                                                        
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF                                                       
           .                                                            
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8040-CREATE-BANK-TRANSFER                                   **        
      **                                                              **        
      ******************************************************************        
       8040-CREATE-BANK-TRANSFER.                                       
      *-------------------------*                                               
           MOVE '8040'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
            INSERT INTO CSS_BANK_TRANSFER                               
                    ( CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      DATE_CASH_REPORT,                                 
                      CASH_DRAWER_ID,                                   
                      TRANSFER_TS,                                      
                      CURRENCY_TYPE,                                    
                      USER_ID,                                          
                      BANK_ID,                                          
                      TRANSFER_AMT,                                     
                      CODE_DR_CR,                                       
                      BANK_POST_DT)                                     
                      VALUES (                                          
                      :YB-CASH-COMPANY-NO,                              
                      :YB-CASH-LOCAL-OFFICE,                            
                      IIF(TRY_CONVERT(DATE, :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) ),                        
                      :YB-CASH-DRAWER-ID,                               
                      CIS.CHAR2TIMESTAMP(:YB-TRANSFER-TS),                      
                      :YB-CURRENCY-TYPE,                                
                      :YB-USER-ID,                                      
                      :YB-BANK-ID,                                      
                      :YB-TRANSFER-AMT,                                 
                      :YB-CODE-DR-CR,                                   
                      IIF(TRY_CONVERT(DATE, :YB-BANK-POST-DT
              ) IS NULL OR (PATINDEX('%.%', :YB-BANK-POST-DT
              ) <> 0) OR (LEN(:YB-BANK-POST-DT) <> 10), CIS.CHAR2DATE(
                                                       :YB-BANK-POST-DT
              ), CONVERT(DATE, :YB-BANK-POST-DT) ))                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     INSERT INTO CSS_BANK_TRANSFER                                       
MFA-TR*             ( CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               CASH_DRAWER_ID,                                           
MFA-TR*               TRANSFER_TS,                                              
MFA-TR*               CURRENCY_TYPE,                                            
MFA-TR*               USER_ID,                                                  
MFA-TR*               BANK_ID,                                                  
MFA-TR*               TRANSFER_AMT,                                             
MFA-TR*               CODE_DR_CR,                                               
MFA-TR*               BANK_POST_DT)                                             
MFA-TR*               VALUES (                                                  
MFA-TR*               :YB-CASH-COMPANY-NO,                                      
MFA-TR*               :YB-CASH-LOCAL-OFFICE,                                    
MFA-TR*               :YB-DATE-CASH-REPORT,                                     
MFA-TR*               :YB-CASH-DRAWER-ID,                                       
MFA-TR*               :YB-TRANSFER-TS,                                          
MFA-TR*               :YB-CURRENCY-TYPE,                                        
MFA-TR*               :YB-USER-ID,                                              
MFA-TR*               :YB-BANK-ID,                                              
MFA-TR*               :YB-TRANSFER-AMT,                                         
MFA-TR*               :YB-CODE-DR-CR,                                           
MFA-TR*               :YB-BANK-POST-DT)                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSS_BANK_TRANSFER'   TO WS-TABLE-NAME               
              MOVE YB-CASH-DRAWER-ID     TO WS-DISP-CASH-DRAWER-ID      
              STRING ' ERROR INSERTING INTO CSS_BANK_TRANSFER **'       
                                             DELIMITED BY SIZE          
                     'CASHIER OFFICE   '     DELIMITED BY SIZE          
                   YB-CASH-LOCAL-OFFICE,     DELIMITED BY SIZE          
                   ',DATE CASH REPORT'       DELIMITED BY SIZE          
                   YB-DATE-CASH-REPORT,      DELIMITED BY SIZE          
                   ',CASH DRAWER ID'         DELIMITED BY SIZE          
                   WS-DISP-CASH-DRAWER-ID,   DELIMITED BY SIZE          
                   ',USER ID       '         DELIMITED BY SIZE          
                   YB-USER-ID                DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8050-UPDATE-CASH-DRWR-CNTL                                  **        
      **                                                              **        
      ******************************************************************        
       8050-UPDATE-CASH-DRWR-CNTL.                                      
      *---------------------------*                                             
           MOVE '8050'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_CSH_DRWR_CNTL                                   
                SET AMT_CASH_DEBIT        = :CS-AMT-CASH-DEBIT          
                   ,AMT_CASH_CREDIT       = :CS-AMT-CASH-CREDIT         
                   ,USER_ID               = :CS-USER-ID                 
                   ,CASHIER_CODE          = :CS-CASHIER-CODE            
                   ,DATE_LAST_ACTIVITY    = IIF(TRY_CONVERT(DATE, 
                                                 :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) )      
                   ,NO_ITEMS_ENTERED      = :CS-NO-ITEMS-ENTERED        
              WHERE CASH_COMPANY_NO       = :CS-CASH-COMPANY-NO         
                AND CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE       
                AND CASH_DRAWER_ID        = :CS-CASH-DRAWER-ID          
                AND DATE_CASH_REPORT      = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )        
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_CSH_DRWR_CNTL                                           
MFA-TR*         SET AMT_CASH_DEBIT        = :CS-AMT-CASH-DEBIT                  
MFA-TR*            ,AMT_CASH_CREDIT       = :CS-AMT-CASH-CREDIT                 
MFA-TR*            ,USER_ID               = :CS-USER-ID                         
MFA-TR*            ,CASHIER_CODE          = :CS-CASHIER-CODE                    
MFA-TR*            ,DATE_LAST_ACTIVITY    = :CS-DATE-LAST-ACTIVITY              
MFA-TR*            ,NO_ITEMS_ENTERED      = :CS-NO-ITEMS-ENTERED                
MFA-TR*       WHERE CASH_COMPANY_NO       = :CS-CASH-COMPANY-NO                 
MFA-TR*         AND CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE               
MFA-TR*         AND CASH_DRAWER_ID        = :CS-CASH-DRAWER-ID                  
MFA-TR*         AND DATE_CASH_REPORT      = :CS-DATE-CASH-REPORT                
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSS_CSH_DRWR_CNTL'   TO WS-TABLE-NAME               
              MOVE CS-CASH-DRAWER-ID     TO WS-DISP-CASH-DRAWER-ID      
              STRING ' ERROR UPDATE CASH DRAWER CONTROL **'             
                                            DELIMITED BY SIZE           
                     ' CASHIER OFFICE '     DELIMITED BY SIZE           
                   CS-CASH-LOCAL-OFFICE     DELIMITED BY SIZE           
                   ',DATE CASH REPORT'      DELIMITED BY SIZE           
                   CS-DATE-CASH-REPORT      DELIMITED BY SIZE           
                   ',CASH DRAWER ID'        DELIMITED BY SIZE           
                   WS-DISP-CASH-DRAWER-ID   DELIMITED BY SIZE           
                                         INTO WS-ERR-MSG                
                                                                        
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF                                                       
           .                                                            
C33928 8050-EXIT.                                                       
C33928     EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      *      THIS PARA CREATES THE                                     *        
      *                   BATCH JOURNAL CONTROL                        *        
      ******************************************************************        
       8400-CREATE-BCH-JRNL-CNTL.                                       
                                                                        
           MOVE '8400'               TO WS-ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
            INSERT INTO CSS_BCH_JRNL_CNTL (                             
                        CASH_COMPANY_NO,                                
                        CASH_LOCAL_OFFICE,                              
                        CASH_REPORT_NO,                                 
                        DATE_CASH_REPORT,                               
                        CASH_DRAWER_ID,                                 
                        LOCAL_OFFICE_ENTRY,                             
                        BATCH_NO,                                       
                        CODE_BATCH_STATUS,                              
                        LOCAL_OFFICE_SEND,                              
                        DATE_BATCH_ENTERED,                             
                        DATE_LAST_ACTIVITY,                             
                        NO_ITEMS_ENTERED,                               
                        NO_ITEMS_POSTED,                                
                        AMT_CASH_DEBIT,                                 
                        AMT_CASH_CREDIT,                                
                        AMT_AR_DEBIT,                                   
                        AMT_AR_CREDIT,                                  
                        AMT_CK_ISS_DEBIT,                               
                        AMT_CK_ISS_CREDIT,                              
                        AMT_GL_DEBIT,                                   
                        AMT_GL_CREDIT,                                  
                        AMT_NET_BATCH,                                  
                        AMT_BATCH_DEBITS,                               
                        AMT_BATCH_CREDITS )                             
             VALUES (                                                   
                        :BC-CASH-COMPANY-NO,                            
                        :BC-CASH-LOCAL-OFFICE,                          
                        :BC-CASH-REPORT-NO,                             
                        IIF(TRY_CONVERT(DATE, :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) ),                        
                        :BC-CASH-DRAWER-ID,                             
                        :BC-LOCAL-OFFICE-ENTRY,                         
                        :BC-BATCH-NO,                                   
                        :BC-CODE-BATCH-STATUS,                          
                        :BC-LOCAL-OFFICE-SEND,                          
                        IIF(TRY_CONVERT(DATE, :BC-DATE-BATCH-ENTERED
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-BATCH-ENTERED
              ) <> 0) OR (LEN(:BC-DATE-BATCH-ENTERED
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-BATCH-ENTERED
              ), CONVERT(DATE, :BC-DATE-BATCH-ENTERED) ),                      
                        IIF(TRY_CONVERT(DATE, :BC-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:BC-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :BC-DATE-LAST-ACTIVITY) ),                      
                        :BC-NO-ITEMS-ENTERED,                           
                        :BC-NO-ITEMS-POSTED,                            
                        :BC-AMT-CASH-DEBIT,                             
                        :BC-AMT-CASH-CREDIT,                            
                        :BC-AMT-AR-DEBIT,                               
                        :BC-AMT-AR-CREDIT,                              
                        :BC-AMT-CK-ISS-DEBIT,                           
                        :BC-AMT-CK-ISS-CREDIT,                          
                        :BC-AMT-GL-DEBIT,                               
                        :BC-AMT-GL-CREDIT,                              
                        :BC-AMT-NET-BATCH,                              
                        :BC-AMT-BATCH-DEBITS,                           
                        :BC-AMT-BATCH-CREDITS )                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     INSERT INTO CSS_BCH_JRNL_CNTL (                                     
MFA-TR*                 CASH_COMPANY_NO,                                        
MFA-TR*                 CASH_LOCAL_OFFICE,                                      
MFA-TR*                 CASH_REPORT_NO,                                         
MFA-TR*                 DATE_CASH_REPORT,                                       
MFA-TR*                 CASH_DRAWER_ID,                                         
MFA-TR*                 LOCAL_OFFICE_ENTRY,                                     
MFA-TR*                 BATCH_NO,                                               
MFA-TR*                 CODE_BATCH_STATUS,                                      
MFA-TR*                 LOCAL_OFFICE_SEND,                                      
MFA-TR*                 DATE_BATCH_ENTERED,                                     
MFA-TR*                 DATE_LAST_ACTIVITY,                                     
MFA-TR*                 NO_ITEMS_ENTERED,                                       
MFA-TR*                 NO_ITEMS_POSTED,                                        
MFA-TR*                 AMT_CASH_DEBIT,                                         
MFA-TR*                 AMT_CASH_CREDIT,                                        
MFA-TR*                 AMT_AR_DEBIT,                                           
MFA-TR*                 AMT_AR_CREDIT,                                          
MFA-TR*                 AMT_CK_ISS_DEBIT,                                       
MFA-TR*                 AMT_CK_ISS_CREDIT,                                      
MFA-TR*                 AMT_GL_DEBIT,                                           
MFA-TR*                 AMT_GL_CREDIT,                                          
MFA-TR*                 AMT_NET_BATCH,                                          
MFA-TR*                 AMT_BATCH_DEBITS,                                       
MFA-TR*                 AMT_BATCH_CREDITS )                                     
MFA-TR*      VALUES (                                                           
MFA-TR*                 :BC-CASH-COMPANY-NO,                                    
MFA-TR*                 :BC-CASH-LOCAL-OFFICE,                                  
MFA-TR*                 :BC-CASH-REPORT-NO,                                     
MFA-TR*                 :BC-DATE-CASH-REPORT,                                   
MFA-TR*                 :BC-CASH-DRAWER-ID,                                     
MFA-TR*                 :BC-LOCAL-OFFICE-ENTRY,                                 
MFA-TR*                 :BC-BATCH-NO,                                           
MFA-TR*                 :BC-CODE-BATCH-STATUS,                                  
MFA-TR*                 :BC-LOCAL-OFFICE-SEND,                                  
MFA-TR*                 :BC-DATE-BATCH-ENTERED,                                 
MFA-TR*                 :BC-DATE-LAST-ACTIVITY,                                 
MFA-TR*                 :BC-NO-ITEMS-ENTERED,                                   
MFA-TR*                 :BC-NO-ITEMS-POSTED,                                    
MFA-TR*                 :BC-AMT-CASH-DEBIT,                                     
MFA-TR*                 :BC-AMT-CASH-CREDIT,                                    
MFA-TR*                 :BC-AMT-AR-DEBIT,                                       
MFA-TR*                 :BC-AMT-AR-CREDIT,                                      
MFA-TR*                 :BC-AMT-CK-ISS-DEBIT,                                   
MFA-TR*                 :BC-AMT-CK-ISS-CREDIT,                                  
MFA-TR*                 :BC-AMT-GL-DEBIT,                                       
MFA-TR*                 :BC-AMT-GL-CREDIT,                                      
MFA-TR*                 :BC-AMT-NET-BATCH,                                      
MFA-TR*                 :BC-AMT-BATCH-DEBITS,                                   
MFA-TR*                 :BC-AMT-BATCH-CREDITS )                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
                 STRING 'LOCAL OFFICE    '    DELIMITED BY SIZE         
                        BC-CASH-LOCAL-OFFICE, DELIMITED BY SIZE         
                        ',CASH COMPANY NO '   DELIMITED BY SIZE         
                        BC-CASH-COMPANY-NO,   DELIMITED BY SIZE         
                                        INTO WS-ERR-MSG                 
T22767           MOVE  'CSS_BCH_JRNL_CNTL'    TO WS-TABLE-NAME          
                 PERFORM      8800-DIS-TABLE-ERROR                      
                    THRU      8800-EXIT                                 
            END-IF.                                                     
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *      THIS PARA CREATES THE                                     *        
      *                   BATCH JOURNAL                                *        
      ******************************************************************        
       8500-CREATE-CSS-BATCH-JRNL.                                      
                                                                        
           MOVE '8500'                TO WS-ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
            INSERT INTO CSS_BATCH_JRNL (                                
                        CASH_COMPANY_NO,                                
                        CASH_LOCAL_OFFICE,                              
                        CASH_REPORT_NO,                                 
                        DATE_CASH_REPORT,                               
                        CASH_DRAWER_ID,                                 
                        DATE_TRAN,                                      
                        ENTRY_NO,                                       
                        TRAN_APPL_NO,                                   
                        COMPANY_NO,                                     
                        LOCAL_OFFICE,                                   
                        BATCH_NO,                                       
                        JRNL_SORT_ID,                                   
                        ACCOUNT_NO,                                     
                        CUSTOMER_NO,                                    
                        GL_ACCT_NO,                                     
                        METER_NO,                                       
                        TRAN_TIME,                                      
                        TRAN_ID,                                        
                        DATE_LAST_ACTION,                               
                        CODE_ENTRY_SOURCE,                              
                        USER_ID,                                        
                        BATCH_SEND_LOC,                                 
                        ENTRY_LOC,                                      
                        CODE_TRAN_ERRORS,                               
                        CODE_JRNL_EXTRACT,                              
                        BALANCED_BY,                                    
                        CODE_STATUS,                                    
                        CURRENCY_TYPE,                                  
                        TRAN_DATA )                                     
              VALUES (                                                  
                        :BJ-CASH-COMPANY-NO,                            
                        :BJ-CASH-LOCAL-OFFICE,                          
                        :BJ-CASH-REPORT-NO,                             
                        IIF(TRY_CONVERT(DATE, :BJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :BJ-DATE-CASH-REPORT) ),                        
                        :BJ-CASH-DRAWER-ID,                             
                        IIF(TRY_CONVERT(DATE, :BJ-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :BJ-DATE-TRAN
              ) <> 0) OR (LEN(:BJ-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :BJ-DATE-TRAN
              ), CONVERT(DATE, :BJ-DATE-TRAN) ),                               
                        :BJ-ENTRY-NO,                                   
                        :BJ-TRAN-APPL-NO,                               
                        :BJ-COMPANY-NO,                                 
                        :BJ-LOCAL-OFFICE,                               
                        :BJ-BATCH-NO,                                   
                        :BJ-JRNL-SORT-ID,                               
                        :BJ-ACCOUNT-NO,                                 
                        :BJ-CUSTOMER-NO,                                
                        :BJ-GL-ACCT-NO,                                 
                        :BJ-METER-NO,                                   
                        CIS.CHAR2TIME(:BJ-TRAN-TIME),                           
                        :BJ-TRAN-ID,                                    
                        IIF(TRY_CONVERT(DATE, :BJ-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :BJ-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:BJ-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:BJ-DATE-LAST-ACTION
              ), CONVERT(DATE, :BJ-DATE-LAST-ACTION) ),                        
                        :BJ-CODE-ENTRY-SOURCE,                          
                        :BJ-USER-ID,                                    
                        :BJ-BATCH-SEND-LOC,                             
                        :BJ-ENTRY-LOC,                                  
                        :BJ-CODE-TRAN-ERRORS ,                          
                        :BJ-CODE-JRNL-EXTRACT,                          
                        :BJ-BALANCED-BY,                                
                        :BJ-CODE-STATUS,                                
                        :BJ-CURRENCY-TYPE,                              
                        :BJ-TRAN-DATA )                                 
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     INSERT INTO CSS_BATCH_JRNL (                                        
MFA-TR*                 CASH_COMPANY_NO,                                        
MFA-TR*                 CASH_LOCAL_OFFICE,                                      
MFA-TR*                 CASH_REPORT_NO,                                         
MFA-TR*                 DATE_CASH_REPORT,                                       
MFA-TR*                 CASH_DRAWER_ID,                                         
MFA-TR*                 DATE_TRAN,                                              
MFA-TR*                 ENTRY_NO,                                               
MFA-TR*                 TRAN_APPL_NO,                                           
MFA-TR*                 COMPANY_NO,                                             
MFA-TR*                 LOCAL_OFFICE,                                           
MFA-TR*                 BATCH_NO,                                               
MFA-TR*                 JRNL_SORT_ID,                                           
MFA-TR*                 ACCOUNT_NO,                                             
MFA-TR*                 CUSTOMER_NO,                                            
MFA-TR*                 GL_ACCT_NO,                                             
MFA-TR*                 METER_NO,                                               
MFA-TR*                 TRAN_TIME,                                              
MFA-TR*                 TRAN_ID,                                                
MFA-TR*                 DATE_LAST_ACTION,                                       
MFA-TR*                 CODE_ENTRY_SOURCE,                                      
MFA-TR*                 USER_ID,                                                
MFA-TR*                 BATCH_SEND_LOC,                                         
MFA-TR*                 ENTRY_LOC,                                              
MFA-TR*                 CODE_TRAN_ERRORS,                                       
MFA-TR*                 CODE_JRNL_EXTRACT,                                      
MFA-TR*                 BALANCED_BY,                                            
MFA-TR*                 CODE_STATUS,                                            
MFA-TR*                 CURRENCY_TYPE,                                          
MFA-TR*                 TRAN_DATA )                                             
MFA-TR*       VALUES (                                                          
MFA-TR*                 :BJ-CASH-COMPANY-NO,                                    
MFA-TR*                 :BJ-CASH-LOCAL-OFFICE,                                  
MFA-TR*                 :BJ-CASH-REPORT-NO,                                     
MFA-TR*                 :BJ-DATE-CASH-REPORT,                                   
MFA-TR*                 :BJ-CASH-DRAWER-ID,                                     
MFA-TR*                 :BJ-DATE-TRAN,                                          
MFA-TR*                 :BJ-ENTRY-NO,                                           
MFA-TR*                 :BJ-TRAN-APPL-NO,                                       
MFA-TR*                 :BJ-COMPANY-NO,                                         
MFA-TR*                 :BJ-LOCAL-OFFICE,                                       
MFA-TR*                 :BJ-BATCH-NO,                                           
MFA-TR*                 :BJ-JRNL-SORT-ID,                                       
MFA-TR*                 :BJ-ACCOUNT-NO,                                         
MFA-TR*                 :BJ-CUSTOMER-NO,                                        
MFA-TR*                 :BJ-GL-ACCT-NO,                                         
MFA-TR*                 :BJ-METER-NO,                                           
MFA-TR*                 :BJ-TRAN-TIME,                                          
MFA-TR*                 :BJ-TRAN-ID,                                            
MFA-TR*                 :BJ-DATE-LAST-ACTION,                                   
MFA-TR*                 :BJ-CODE-ENTRY-SOURCE,                                  
MFA-TR*                 :BJ-USER-ID,                                            
MFA-TR*                 :BJ-BATCH-SEND-LOC,                                     
MFA-TR*                 :BJ-ENTRY-LOC,                                          
MFA-TR*                 :BJ-CODE-TRAN-ERRORS ,                                  
MFA-TR*                 :BJ-CODE-JRNL-EXTRACT,                                  
MFA-TR*                 :BJ-BALANCED-BY,                                        
MFA-TR*                 :BJ-CODE-STATUS,                                        
MFA-TR*                 :BJ-CURRENCY-TYPE,                                      
MFA-TR*                 :BJ-TRAN-DATA )                                         
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.      
                                                                        
             IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
             ELSE                                                       
                 STRING 'LOCAL OFFICE     ' DELIMITED BY SIZE           
                      BJ-CASH-LOCAL-OFFICE, DELIMITED BY SIZE           
                                       INTO WS-ERR-MSG                  
T22767           MOVE  'CSS_BATCH_JRNL   '    TO WS-TABLE-NAME          
                 PERFORM      8800-DIS-TABLE-ERROR                      
                    THRU      8800-EXIT                                 
             END-IF.                                                    
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *      THIS PARA UPDATES THE                                     *        
      *                   BATCH JOURNAL                                *        
      ******************************************************************        
       8600-UPDATE-BCH-JRNL-CNTL.                                       
                                                                        
             MOVE '8600'                 TO WS-ACTIVE-PARAGRAPH.        
                                                                        
             EXEC SQL                                                   
              UPDATE CSS_BCH_JRNL_CNTL                                  
               SET AMT_CASH_DEBIT    = :BC-AMT-CASH-DEBIT,              
                   AMT_GL_CREDIT     = :BC-AMT-GL-CREDIT,               
C25923             AMT_CASH_CREDIT   = :BC-AMT-CASH-CREDIT,             
C25923             AMT_GL_DEBIT      = :BC-AMT-GL-DEBIT,                
                   NO_ITEMS_ENTERED  = :BC-NO-ITEMS-ENTERED,            
                   NO_ITEMS_POSTED   = :BC-NO-ITEMS-POSTED              
              WHERE CASH_COMPANY_NO  = :BC-CASH-COMPANY-NO              
               AND CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE            
               AND CASH_DRAWER_ID    = :BC-CASH-DRAWER-ID               
               AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )             
               AND CASH_REPORT_NO    = :BC-CASH-REPORT-NO               
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*      EXEC SQL                                                           
MFA-TR*       UPDATE CSS_BCH_JRNL_CNTL                                          
MFA-TR*        SET AMT_CASH_DEBIT    = :BC-AMT-CASH-DEBIT,                      
MFA-TR*            AMT_GL_CREDIT     = :BC-AMT-GL-CREDIT,                       
MFA-TR*            AMT_CASH_CREDIT   = :BC-AMT-CASH-CREDIT,                     
MFA-TR*            AMT_GL_DEBIT      = :BC-AMT-GL-DEBIT,                        
MFA-TR*            NO_ITEMS_ENTERED  = :BC-NO-ITEMS-ENTERED,                    
MFA-TR*            NO_ITEMS_POSTED   = :BC-NO-ITEMS-POSTED                      
MFA-TR*       WHERE CASH_COMPANY_NO  = :BC-CASH-COMPANY-NO                      
MFA-TR*        AND CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE                    
MFA-TR*        AND CASH_DRAWER_ID    = :BC-CASH-DRAWER-ID                       
MFA-TR*        AND DATE_CASH_REPORT  = :BC-DATE-CASH-REPORT                     
MFA-TR*        AND CASH_REPORT_NO    = :BC-CASH-REPORT-NO                       
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.        
                                                                        
             IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
             ELSE                                                       
                 STRING 'LOCAL OFFICE     '   DELIMITED BY SIZE         
                        BC-CASH-LOCAL-OFFICE, DELIMITED BY SIZE         
                        ',CASH COMPANY NO   ' DELIMITED BY SIZE         
                        BC-CASH-COMPANY-NO,   DELIMITED BY SIZE         
                        ',DATE CASH REPORT'   DELIMITED BY SIZE         
                        BC-DATE-CASH-REPORT,  DELIMITED BY SIZE         
                        ',CASH-REPORT-NO '    DELIMITED BY SIZE         
                        BC-CASH-REPORT-NO     DELIMITED BY SIZE         
                                             INTO WS-ERR-MSG            
T22767           MOVE  'CSS_BCH_JRNL_CNTL'    TO WS-TABLE-NAME          
                 PERFORM      8800-DIS-TABLE-ERROR                      
                    THRU      8800-EXIT                                 
             END-IF.                                                    
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
A02388*  THIS PARA CREATES OVER SHORT FOR THE PAYMENTS                 *        
C25923******************************************************************        
C25923 8700-INSERT-OVERSHORT.                                           
                                                                        
           MOVE '8700'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_OVERSHORT_HDR                           
                       (                                                
                        CASH_COMPANY_NO                                 
                       ,CASH_LOCAL_OFFICE                               
                       ,DATE_CASH_REPORT                                
                       ,CASH_DRAWER_ID                                  
                       ,USER_ID                                         
                       ,OVERSHORT_ID                                    
                       ,TRAN_TS                                         
                       ,OVERSHORT_AMT                                   
                       ,OVERSHORT_DR_CR                                 
                       ,OFST_OVERSHORT_AMT                              
                       ,OFST_DR_CR                                      
                       ,GL_ACCT_NO                                      
                       ,LAST_UPDATE_TS                                  
                       ,OVERSHORT_TYPE_CD                               
                       ,OVERSHORT_SOLTN_FL                              
                       ,TRAN_COMMENT                                    
                       ,ACCOUNT_NO                                      
                       )                                                
                VALUES                                                  
                       (                                                
                        :OH-CASH-COMPANY-NO                             
                       ,:OH-CASH-LOCAL-OFFICE                           
                       ,IIF(TRY_CONVERT(DATE, :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )                         
                       ,:OH-CASH-DRAWER-ID                              
                       ,:OH-USER-ID                                     
                       ,:OH-OVERSHORT-ID                                
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:OH-OVERSHORT-AMT                               
                       ,:OH-OVERSHORT-DR-CR                             
                       ,:OH-OFST-OVERSHORT-AMT                          
                       ,:OH-OFST-DR-CR                                  
                       ,:OH-GL-ACCT-NO                                  
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:OH-OVERSHORT-TYPE-CD                           
                       ,:OH-OVERSHORT-SOLTN-FL                          
                       ,:OH-TRAN-COMMENT                                
                       ,:OH-ACCOUNT-NO                                  
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_OVERSHORT_HDR                                   
MFA-TR*                (                                                        
MFA-TR*                 CASH_COMPANY_NO                                         
MFA-TR*                ,CASH_LOCAL_OFFICE                                       
MFA-TR*                ,DATE_CASH_REPORT                                        
MFA-TR*                ,CASH_DRAWER_ID                                          
MFA-TR*                ,USER_ID                                                 
MFA-TR*                ,OVERSHORT_ID                                            
MFA-TR*                ,TRAN_TS                                                 
MFA-TR*                ,OVERSHORT_AMT                                           
MFA-TR*                ,OVERSHORT_DR_CR                                         
MFA-TR*                ,OFST_OVERSHORT_AMT                                      
MFA-TR*                ,OFST_DR_CR                                              
MFA-TR*                ,GL_ACCT_NO                                              
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,OVERSHORT_TYPE_CD                                       
MFA-TR*                ,OVERSHORT_SOLTN_FL                                      
MFA-TR*                ,TRAN_COMMENT                                            
MFA-TR*                ,ACCOUNT_NO                                              
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :OH-CASH-COMPANY-NO                                     
MFA-TR*                ,:OH-CASH-LOCAL-OFFICE                                   
MFA-TR*                ,:OH-DATE-CASH-REPORT                                    
MFA-TR*                ,:OH-CASH-DRAWER-ID                                      
MFA-TR*                ,:OH-USER-ID                                             
MFA-TR*                ,:OH-OVERSHORT-ID                                        
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:OH-OVERSHORT-AMT                                       
MFA-TR*                ,:OH-OVERSHORT-DR-CR                                     
MFA-TR*                ,:OH-OFST-OVERSHORT-AMT                                  
MFA-TR*                ,:OH-OFST-DR-CR                                          
MFA-TR*                ,:OH-GL-ACCT-NO                                          
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:OH-OVERSHORT-TYPE-CD                                   
MFA-TR*                ,:OH-OVERSHORT-SOLTN-FL                                  
MFA-TR*                ,:OH-TRAN-COMMENT                                        
MFA-TR*                ,:OH-ACCOUNT-NO                                          
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'CASH LOCAL OFFICE '  DELIMITED BY SIZE           
                    OH-CASH-LOCAL-OFFICE,   DELIMITED BY SIZE           
                  ',DATE CASH REPORT'       DELIMITED BY SIZE           
                    OH-DATE-CASH-REPORT,    DELIMITED BY SIZE           
                  ',CASH DRAWER-ID  '       DELIMITED BY SIZE           
                    WS-CASH-DRAWER-ID,      DELIMITED BY SIZE           
                                            INTO WS-ERR-MSG             
                 MOVE  'CSS_OVERSHORT_HDR'  TO WS-TABLE-NAME            
                 PERFORM      8800-DIS-TABLE-ERROR                      
                    THRU      8800-EXIT                                 
           END-IF                                                       
           .                                                            
C25923 8700-EXIT.                                                       
C25923     EXIT.                                                        
      *                                                                         
      **************************************************************            
      **  8800-DIS-TABLE-ERROR                                    **            
      **************************************************************            
       8800-DIS-TABLE-ERROR.                                            
                                                                        
               DISPLAY '**********************************************' 
               DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *' 
               DISPLAY '**********************************************' 
               DISPLAY '** PARAGRAPH         = ' WS-ACTIVE-PARAGRAPH    
T22767         DISPLAY '** TABLE NAME        = ' WS-TABLE-NAME          
               DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE  
               DISPLAY '**' WS-ERR-MSG                                  
               DISPLAY '**********************************************'.
                                                                        
               PERFORM      9900-ABEND                                  
                  THRU      9900-EXIT.                                  
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8900-DISPLAY-ERR-AND-TERMINATE                           **          
      ****************************************************************          
       8900-DISPLAY-ERR-AND-TERMINATE.                                  
                                                                        
              DISPLAY '******************************************'      
              DISPLAY '**     PCSAC172 PROCESSING ERROR        **'      
              DISPLAY '   CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH     
              DISPLAY '**' WS-ERR-MSG                                   
              DISPLAY '**       PROCESSING TERMINATED          **'      
              DISPLAY '******************************************'      
                                                                        
              PERFORM      9900-ABEND                                   
                 THRU      9900-EXIT.                                   
       8900-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *            THIS PARA PERFORMS THE TERMINATING FUNCTION         *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
            MOVE '9000'                  TO WS-ACTIVE-PARAGRAPH.        
                                                                        
            CLOSE FCSAC21-FILE.                                         
                                                                        
            IF FAC21-SUCCESSFUL                                         
                NEXT SENTENCE                                           
            ELSE                                                        
                DISPLAY '******************************************'    
                DISPLAY '**     PCSAC172 PROCESSING ERROR        **'    
                DISPLAY '** FILE CLOSE ERROR   **' WS-FAC21-STATUS      
                DISPLAY '   CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH   
                DISPLAY     WS-ERR-MSG                                  
                DISPLAY '**       PROCESSING TERMINATED          **'    
                DISPLAY '******************************************'    
            END-IF.                                                     
                                                                        
A02388      CLOSE FCSAC26-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
